/* VideoTable.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from VideoTable.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>
#include <sqlite3.h>
#include <gee.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecVideoRow ParamSpecVideoRow;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _video_row_unref0(var) ((var == NULL) ? NULL : (var = (video_row_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ParamSpecVideoRow {
	GParamSpec parent_instance;
};

static gpointer video_row_parent_class = NULL;
static gpointer video_table_parent_class = NULL;
static VideoTable* video_table_instance;
static VideoTable* video_table_instance = NULL;

static void video_row_finalize (VideoRow * obj);
static GType video_row_get_type_once (void);
static VideoTable* video_table_new (void);
static VideoTable* video_table_construct (GType object_type);
static sqlite3_stmt* video_table_get_duplicate_stmt (VideoTable* self,
                                              GFile* file,
                                              const gchar* md5);
static void _vala_array_add50 (VideoID* * array,
                        gint* length,
                        gint* size,
                        const VideoID* value);
static void video_table_finalize (DatabaseTable * obj);
static GType video_table_get_type_once (void);

void
video_id_init (VideoID *self,
               gint64 id)
{
	memset (self, 0, sizeof (VideoID));
	(*self).id = id;
}

gboolean
video_id_is_invalid (VideoID *self)
{
	gboolean result;
	result = (*self).id == VIDEO_ID_INVALID;
	return result;
}

gboolean
video_id_is_valid (VideoID *self)
{
	gboolean result;
	result = (*self).id != VIDEO_ID_INVALID;
	return result;
}

guint
video_id_hash (VideoID* a)
{
	guint result;
	result = int64_hash (&(*a).id);
	return result;
}

gboolean
video_id_equal (void* a,
                void* b)
{
	gboolean result;
	result = (*((VideoID*) a)).id == (*((VideoID*) b)).id;
	return result;
}

gchar*
video_id_upgrade_video_id_to_source_id (VideoID* video_id)
{
	VideoID _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (video_id != NULL, NULL);
	_tmp0_ = *video_id;
	_tmp1_ = g_strdup_printf ("%s-%016" G_GINT64_MODIFIER "x", VIDEO_TYPENAME, _tmp0_.id);
	result = _tmp1_;
	return result;
}

VideoID*
video_id_dup (const VideoID* self)
{
	VideoID* dup;
	dup = g_new0 (VideoID, 1);
	memcpy (dup, self, sizeof (VideoID));
	return dup;
}

void
video_id_free (VideoID* self)
{
	g_free (self);
}

static GType
video_id_get_type_once (void)
{
	GType video_id_type_id;
	video_id_type_id = g_boxed_type_register_static ("VideoID", (GBoxedCopyFunc) video_id_dup, (GBoxedFreeFunc) video_id_free);
	return video_id_type_id;
}

GType
video_id_get_type (void)
{
	static volatile gsize video_id_type_id__once = 0;
	if (g_once_init_enter (&video_id_type_id__once)) {
		GType video_id_type_id;
		video_id_type_id = video_id_get_type_once ();
		g_once_init_leave (&video_id_type_id__once, video_id_type_id);
	}
	return video_id_type_id__once;
}

VideoRow*
video_row_construct (GType object_type)
{
	VideoRow* self = NULL;
	self = (VideoRow*) g_type_create_instance (object_type);
	return self;
}

VideoRow*
video_row_new (void)
{
	return video_row_construct (TYPE_VIDEO_ROW);
}

static void
value_video_row_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_video_row_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		video_row_unref (value->data[0].v_pointer);
	}
}

static void
value_video_row_copy_value (const GValue* src_value,
                            GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = video_row_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_video_row_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_video_row_collect_value (GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		VideoRow * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = video_row_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_video_row_lcopy_value (const GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
	VideoRow ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = video_row_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_video_row (const gchar* name,
                      const gchar* nick,
                      const gchar* blurb,
                      GType object_type,
                      GParamFlags flags)
{
	ParamSpecVideoRow* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_VIDEO_ROW), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_video_row (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_ROW), NULL);
	return value->data[0].v_pointer;
}

void
value_set_video_row (GValue* value,
                     gpointer v_object)
{
	VideoRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIDEO_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		video_row_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		video_row_unref (old);
	}
}

void
value_take_video_row (GValue* value,
                      gpointer v_object)
{
	VideoRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIDEO_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		video_row_unref (old);
	}
}

static void
video_row_class_init (VideoRowClass * klass,
                      gpointer klass_data)
{
	video_row_parent_class = g_type_class_peek_parent (klass);
	((VideoRowClass *) klass)->finalize = video_row_finalize;
}

static void
video_row_instance_init (VideoRow * self,
                         gpointer klass)
{
	self->ref_count = 1;
}

static void
video_row_finalize (VideoRow * obj)
{
	VideoRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO_ROW, VideoRow);
	g_signal_handlers_destroy (self);
	_g_free0 (self->filepath);
	_g_free0 (self->md5);
	_g_free0 (self->title);
	_g_free0 (self->backlinks);
	_g_free0 (self->comment);
}

static GType
video_row_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_video_row_init, value_video_row_free_value, value_video_row_copy_value, value_video_row_peek_pointer, "p", value_video_row_collect_value, "p", value_video_row_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (VideoRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoRow), 0, (GInstanceInitFunc) video_row_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType video_row_type_id;
	video_row_type_id = g_type_register_fundamental (g_type_fundamental_next (), "VideoRow", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return video_row_type_id;
}

GType
video_row_get_type (void)
{
	static volatile gsize video_row_type_id__once = 0;
	if (g_once_init_enter (&video_row_type_id__once)) {
		GType video_row_type_id;
		video_row_type_id = video_row_get_type_once ();
		g_once_init_leave (&video_row_type_id__once, video_row_type_id);
	}
	return video_row_type_id__once;
}

gpointer
video_row_ref (gpointer instance)
{
	VideoRow * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
video_row_unref (gpointer instance)
{
	VideoRow * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VIDEO_ROW_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static VideoTable*
video_table_construct (GType object_type)
{
	VideoTable* self = NULL;
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	gint res = 0;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_;
	sqlite3_stmt* _tmp3_;
	self = (VideoTable*) database_table_construct (object_type);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "CREATE TABLE IF NOT EXISTS VideoTable (" "id INTEGER PRIMARY KEY, " "filename TEXT UNIQUE NOT NULL, " "width INTEGER, " "height INTEGER, " "clip_duration REAL, " "is_interpretable INTEGER, " "filesize INTEGER, " "timestamp INTEGER, " "exposure_time INTEGER, " "import_id INTEGER, " "event_id INTEGER, " "md5 TEXT, " "time_created INTEGER, " "title TEXT, " "backlinks TEXT, " "time_reimported INTEGER, " "flags INTEGER DEFAULT 0, " "comment TEXT " ")");
	stmt = _tmp0_;
	_tmp1_ = stmt;
	res = sqlite3_step (_tmp1_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("VideoTable constructor", res);
	}
	_tmp2_ = database_table_create_stmt ((DatabaseTable*) self, "CREATE INDEX IF NOT EXISTS VideoEventIDIndex ON VideoTable (event_id)");
	_sqlite3_finalize0 (stmt);
	stmt = _tmp2_;
	_tmp3_ = stmt;
	res = sqlite3_step (_tmp3_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("VideoTable constructor", res);
	}
	database_table_set_table_name ((DatabaseTable*) self, "VideoTable");
	_sqlite3_finalize0 (stmt);
	return self;
}

static VideoTable*
video_table_new (void)
{
	return video_table_construct (TYPE_VIDEO_TABLE);
}

static gpointer
_database_table_ref0 (gpointer self)
{
	return self ? database_table_ref (self) : NULL;
}

VideoTable*
video_table_get_instance (void)
{
	VideoTable* _tmp0_;
	VideoTable* _tmp2_;
	VideoTable* _tmp3_;
	VideoTable* result;
	_tmp0_ = video_table_instance;
	if (_tmp0_ == NULL) {
		VideoTable* _tmp1_;
		_tmp1_ = video_table_new ();
		_database_table_unref0 (video_table_instance);
		video_table_instance = _tmp1_;
	}
	_tmp2_ = video_table_instance;
	_tmp3_ = _database_table_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

void
video_table_add (VideoTable* self,
                 VideoRow* video_row,
                 VideoID* result,
                 GError** error)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	gint64 time_created = 0LL;
	sqlite3_stmt* _tmp1_;
	const gchar* _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp4_;
	sqlite3_stmt* _tmp5_;
	gint _tmp6_ = 0;
	sqlite3_stmt* _tmp7_;
	sqlite3_stmt* _tmp8_;
	sqlite3_stmt* _tmp9_;
	sqlite3_stmt* _tmp10_;
	sqlite3_stmt* _tmp11_;
	ImportID _tmp12_;
	sqlite3_stmt* _tmp13_;
	sqlite3_stmt* _tmp14_;
	const gchar* _tmp15_;
	sqlite3_stmt* _tmp16_;
	sqlite3_stmt* _tmp17_;
	const gchar* _tmp18_;
	sqlite3_stmt* _tmp19_;
	const gchar* _tmp20_;
	gint res = 0;
	sqlite3_stmt* _tmp21_;
	sqlite3* _tmp22_;
	VideoID _tmp23_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (video_row != NULL);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "INSERT INTO VideoTable (filename, width, height, clip_duration, is_int" \
"erpretable, " "filesize, timestamp, exposure_time, import_id, event_id, md5, time_cre" \
"ated, title, comment) " "VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
	stmt = _tmp0_;
	time_created = now_sec ();
	_tmp1_ = stmt;
	_tmp2_ = video_row->filepath;
	database_table_bind_text (_tmp1_, 1, _tmp2_);
	_tmp3_ = stmt;
	database_table_bind_int (_tmp3_, 2, video_row->width);
	_tmp4_ = stmt;
	database_table_bind_int (_tmp4_, 3, video_row->height);
	_tmp5_ = stmt;
	database_table_bind_double (_tmp5_, 4, video_row->clip_duration);
	if (video_row->is_interpretable) {
		_tmp6_ = 1;
	} else {
		_tmp6_ = 0;
	}
	_tmp7_ = stmt;
	database_table_bind_int (_tmp7_, 5, _tmp6_);
	_tmp8_ = stmt;
	database_table_bind_int64 (_tmp8_, 6, video_row->filesize);
	_tmp9_ = stmt;
	database_table_bind_int64 (_tmp9_, 7, video_row->timestamp);
	_tmp10_ = stmt;
	database_table_bind_int64 (_tmp10_, 8, video_row->exposure_time);
	_tmp11_ = stmt;
	_tmp12_ = video_row->import_id;
	database_table_bind_int64 (_tmp11_, 9, _tmp12_.id);
	_tmp13_ = stmt;
	database_table_bind_int64 (_tmp13_, 10, EVENT_ID_INVALID);
	_tmp14_ = stmt;
	_tmp15_ = video_row->md5;
	database_table_bind_text (_tmp14_, 11, _tmp15_);
	_tmp16_ = stmt;
	database_table_bind_int64 (_tmp16_, 12, time_created);
	_tmp17_ = stmt;
	_tmp18_ = video_row->title;
	database_table_bind_text (_tmp17_, 13, _tmp18_);
	_tmp19_ = stmt;
	_tmp20_ = video_row->comment;
	database_table_bind_text (_tmp19_, 14, _tmp20_);
	_tmp21_ = stmt;
	res = sqlite3_step (_tmp21_);
	if (res != SQLITE_DONE) {
		if (res != SQLITE_CONSTRAINT) {
			database_table_throw_error ("VideoTable.add", res, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_sqlite3_finalize0 (stmt);
					return;
				} else {
					_sqlite3_finalize0 (stmt);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
	}
	_tmp22_ = database_table_db;
	video_id_init (&video_row->video_id, sqlite3_last_insert_rowid (_tmp22_));
	event_id_init (&video_row->event_id, EVENT_ID_INVALID);
	video_row->time_created = time_created;
	video_row->flags = (guint64) 0;
	_tmp23_ = video_row->video_id;
	*result = _tmp23_;
	_sqlite3_finalize0 (stmt);
	return;
}

gboolean
video_table_drop_event (VideoTable* self,
                        EventID* event_id)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_;
	EventID _tmp3_;
	gint res = 0;
	sqlite3_stmt* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event_id != NULL, FALSE);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "UPDATE VideoTable SET event_id = ? WHERE event_id = ?");
	stmt = _tmp0_;
	_tmp1_ = stmt;
	database_table_bind_int64 (_tmp1_, 1, EVENT_ID_INVALID);
	_tmp2_ = stmt;
	_tmp3_ = *event_id;
	database_table_bind_int64 (_tmp2_, 2, _tmp3_.id);
	_tmp4_ = stmt;
	res = sqlite3_step (_tmp4_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("VideoTable.drop_event", res);
		result = FALSE;
		_sqlite3_finalize0 (stmt);
		return result;
	}
	result = TRUE;
	_sqlite3_finalize0 (stmt);
	return result;
}

VideoRow*
video_table_get_row (VideoTable* self,
                     VideoID* video_id)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	VideoID _tmp2_;
	sqlite3_stmt* _tmp3_;
	VideoRow* row = NULL;
	VideoRow* _tmp4_;
	VideoRow* _tmp5_;
	VideoID _tmp6_;
	VideoRow* _tmp7_;
	sqlite3_stmt* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	VideoRow* _tmp11_;
	sqlite3_stmt* _tmp12_;
	VideoRow* _tmp13_;
	sqlite3_stmt* _tmp14_;
	VideoRow* _tmp15_;
	sqlite3_stmt* _tmp16_;
	VideoRow* _tmp17_;
	sqlite3_stmt* _tmp18_;
	VideoRow* _tmp19_;
	sqlite3_stmt* _tmp20_;
	VideoRow* _tmp21_;
	sqlite3_stmt* _tmp22_;
	VideoRow* _tmp23_;
	sqlite3_stmt* _tmp24_;
	VideoRow* _tmp25_;
	sqlite3_stmt* _tmp26_;
	VideoRow* _tmp27_;
	sqlite3_stmt* _tmp28_;
	VideoRow* _tmp29_;
	sqlite3_stmt* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	VideoRow* _tmp33_;
	sqlite3_stmt* _tmp34_;
	VideoRow* _tmp35_;
	sqlite3_stmt* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	VideoRow* _tmp39_;
	sqlite3_stmt* _tmp40_;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	VideoRow* _tmp43_;
	sqlite3_stmt* _tmp44_;
	VideoRow* _tmp45_;
	sqlite3_stmt* _tmp46_;
	VideoRow* _tmp47_;
	sqlite3_stmt* _tmp48_;
	const gchar* _tmp49_;
	gchar* _tmp50_;
	VideoRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (video_id != NULL, NULL);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "SELECT filename, width, height, clip_duration, is_interpretable, files" \
"ize, timestamp, " "exposure_time, import_id, event_id, md5, time_created, title, backlink" \
"s, " "time_reimported, flags, comment FROM VideoTable WHERE id=?");
	stmt = _tmp0_;
	_tmp1_ = stmt;
	_tmp2_ = *video_id;
	database_table_bind_int64 (_tmp1_, 1, _tmp2_.id);
	_tmp3_ = stmt;
	if (sqlite3_step (_tmp3_) != SQLITE_ROW) {
		result = NULL;
		_sqlite3_finalize0 (stmt);
		return result;
	}
	_tmp4_ = video_row_new ();
	row = _tmp4_;
	_tmp5_ = row;
	_tmp6_ = *video_id;
	_tmp5_->video_id = _tmp6_;
	_tmp7_ = row;
	_tmp8_ = stmt;
	_tmp9_ = (const gchar*) sqlite3_column_text (_tmp8_, 0);
	_tmp10_ = g_strdup (_tmp9_);
	_g_free0 (_tmp7_->filepath);
	_tmp7_->filepath = _tmp10_;
	_tmp11_ = row;
	_tmp12_ = stmt;
	_tmp11_->width = sqlite3_column_int (_tmp12_, 1);
	_tmp13_ = row;
	_tmp14_ = stmt;
	_tmp13_->height = sqlite3_column_int (_tmp14_, 2);
	_tmp15_ = row;
	_tmp16_ = stmt;
	_tmp15_->clip_duration = sqlite3_column_double (_tmp16_, 3);
	_tmp17_ = row;
	_tmp18_ = stmt;
	_tmp17_->is_interpretable = sqlite3_column_int (_tmp18_, 4) == 1;
	_tmp19_ = row;
	_tmp20_ = stmt;
	_tmp19_->filesize = sqlite3_column_int64 (_tmp20_, 5);
	_tmp21_ = row;
	_tmp22_ = stmt;
	_tmp21_->timestamp = sqlite3_column_int64 (_tmp22_, 6);
	_tmp23_ = row;
	_tmp24_ = stmt;
	_tmp23_->exposure_time = sqlite3_column_int64 (_tmp24_, 7);
	_tmp25_ = row;
	_tmp26_ = stmt;
	_tmp25_->import_id.id = sqlite3_column_int64 (_tmp26_, 8);
	_tmp27_ = row;
	_tmp28_ = stmt;
	_tmp27_->event_id.id = sqlite3_column_int64 (_tmp28_, 9);
	_tmp29_ = row;
	_tmp30_ = stmt;
	_tmp31_ = (const gchar*) sqlite3_column_text (_tmp30_, 10);
	_tmp32_ = g_strdup (_tmp31_);
	_g_free0 (_tmp29_->md5);
	_tmp29_->md5 = _tmp32_;
	_tmp33_ = row;
	_tmp34_ = stmt;
	_tmp33_->time_created = sqlite3_column_int64 (_tmp34_, 11);
	_tmp35_ = row;
	_tmp36_ = stmt;
	_tmp37_ = (const gchar*) sqlite3_column_text (_tmp36_, 12);
	_tmp38_ = g_strdup (_tmp37_);
	_g_free0 (_tmp35_->title);
	_tmp35_->title = _tmp38_;
	_tmp39_ = row;
	_tmp40_ = stmt;
	_tmp41_ = (const gchar*) sqlite3_column_text (_tmp40_, 13);
	_tmp42_ = g_strdup (_tmp41_);
	_g_free0 (_tmp39_->backlinks);
	_tmp39_->backlinks = _tmp42_;
	_tmp43_ = row;
	_tmp44_ = stmt;
	_tmp43_->time_reimported = sqlite3_column_int64 (_tmp44_, 14);
	_tmp45_ = row;
	_tmp46_ = stmt;
	_tmp45_->flags = (guint64) sqlite3_column_int64 (_tmp46_, 15);
	_tmp47_ = row;
	_tmp48_ = stmt;
	_tmp49_ = (const gchar*) sqlite3_column_text (_tmp48_, 16);
	_tmp50_ = g_strdup (_tmp49_);
	_g_free0 (_tmp47_->comment);
	_tmp47_->comment = _tmp50_;
	result = row;
	_sqlite3_finalize0 (stmt);
	return result;
}

GeeArrayList*
video_table_get_all (VideoTable* self)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	GeeArrayList* all = NULL;
	GeeArrayList* _tmp1_;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "SELECT id, filename, width, height, clip_duration, is_interpretable, f" \
"ilesize, " "timestamp, exposure_time, import_id, event_id, md5, time_created, titl" \
"e, " "backlinks, time_reimported, flags, comment FROM VideoTable");
	stmt = _tmp0_;
	_tmp1_ = gee_array_list_new (TYPE_VIDEO_ROW, (GBoxedCopyFunc) video_row_ref, (GDestroyNotify) video_row_unref, NULL, NULL, NULL);
	all = _tmp1_;
	while (TRUE) {
		sqlite3_stmt* _tmp2_;
		VideoRow* row = NULL;
		VideoRow* _tmp3_;
		VideoRow* _tmp4_;
		sqlite3_stmt* _tmp5_;
		VideoRow* _tmp6_;
		sqlite3_stmt* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		VideoRow* _tmp10_;
		sqlite3_stmt* _tmp11_;
		VideoRow* _tmp12_;
		sqlite3_stmt* _tmp13_;
		VideoRow* _tmp14_;
		sqlite3_stmt* _tmp15_;
		VideoRow* _tmp16_;
		sqlite3_stmt* _tmp17_;
		VideoRow* _tmp18_;
		sqlite3_stmt* _tmp19_;
		VideoRow* _tmp20_;
		sqlite3_stmt* _tmp21_;
		VideoRow* _tmp22_;
		sqlite3_stmt* _tmp23_;
		VideoRow* _tmp24_;
		sqlite3_stmt* _tmp25_;
		VideoRow* _tmp26_;
		sqlite3_stmt* _tmp27_;
		VideoRow* _tmp28_;
		sqlite3_stmt* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		VideoRow* _tmp32_;
		sqlite3_stmt* _tmp33_;
		VideoRow* _tmp34_;
		sqlite3_stmt* _tmp35_;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		VideoRow* _tmp38_;
		sqlite3_stmt* _tmp39_;
		const gchar* _tmp40_;
		gchar* _tmp41_;
		VideoRow* _tmp42_;
		sqlite3_stmt* _tmp43_;
		VideoRow* _tmp44_;
		sqlite3_stmt* _tmp45_;
		VideoRow* _tmp46_;
		sqlite3_stmt* _tmp47_;
		const gchar* _tmp48_;
		gchar* _tmp49_;
		GeeArrayList* _tmp50_;
		VideoRow* _tmp51_;
		_tmp2_ = stmt;
		if (!(sqlite3_step (_tmp2_) == SQLITE_ROW)) {
			break;
		}
		_tmp3_ = video_row_new ();
		row = _tmp3_;
		_tmp4_ = row;
		_tmp5_ = stmt;
		_tmp4_->video_id.id = sqlite3_column_int64 (_tmp5_, 0);
		_tmp6_ = row;
		_tmp7_ = stmt;
		_tmp8_ = (const gchar*) sqlite3_column_text (_tmp7_, 1);
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (_tmp6_->filepath);
		_tmp6_->filepath = _tmp9_;
		_tmp10_ = row;
		_tmp11_ = stmt;
		_tmp10_->width = sqlite3_column_int (_tmp11_, 2);
		_tmp12_ = row;
		_tmp13_ = stmt;
		_tmp12_->height = sqlite3_column_int (_tmp13_, 3);
		_tmp14_ = row;
		_tmp15_ = stmt;
		_tmp14_->clip_duration = sqlite3_column_double (_tmp15_, 4);
		_tmp16_ = row;
		_tmp17_ = stmt;
		_tmp16_->is_interpretable = sqlite3_column_int (_tmp17_, 5) == 1;
		_tmp18_ = row;
		_tmp19_ = stmt;
		_tmp18_->filesize = sqlite3_column_int64 (_tmp19_, 6);
		_tmp20_ = row;
		_tmp21_ = stmt;
		_tmp20_->timestamp = sqlite3_column_int64 (_tmp21_, 7);
		_tmp22_ = row;
		_tmp23_ = stmt;
		_tmp22_->exposure_time = sqlite3_column_int64 (_tmp23_, 8);
		_tmp24_ = row;
		_tmp25_ = stmt;
		_tmp24_->import_id.id = sqlite3_column_int64 (_tmp25_, 9);
		_tmp26_ = row;
		_tmp27_ = stmt;
		_tmp26_->event_id.id = sqlite3_column_int64 (_tmp27_, 10);
		_tmp28_ = row;
		_tmp29_ = stmt;
		_tmp30_ = (const gchar*) sqlite3_column_text (_tmp29_, 11);
		_tmp31_ = g_strdup (_tmp30_);
		_g_free0 (_tmp28_->md5);
		_tmp28_->md5 = _tmp31_;
		_tmp32_ = row;
		_tmp33_ = stmt;
		_tmp32_->time_created = sqlite3_column_int64 (_tmp33_, 12);
		_tmp34_ = row;
		_tmp35_ = stmt;
		_tmp36_ = (const gchar*) sqlite3_column_text (_tmp35_, 13);
		_tmp37_ = g_strdup (_tmp36_);
		_g_free0 (_tmp34_->title);
		_tmp34_->title = _tmp37_;
		_tmp38_ = row;
		_tmp39_ = stmt;
		_tmp40_ = (const gchar*) sqlite3_column_text (_tmp39_, 14);
		_tmp41_ = g_strdup (_tmp40_);
		_g_free0 (_tmp38_->backlinks);
		_tmp38_->backlinks = _tmp41_;
		_tmp42_ = row;
		_tmp43_ = stmt;
		_tmp42_->time_reimported = sqlite3_column_int64 (_tmp43_, 15);
		_tmp44_ = row;
		_tmp45_ = stmt;
		_tmp44_->flags = (guint64) sqlite3_column_int64 (_tmp45_, 16);
		_tmp46_ = row;
		_tmp47_ = stmt;
		_tmp48_ = (const gchar*) sqlite3_column_text (_tmp47_, 17);
		_tmp49_ = g_strdup (_tmp48_);
		_g_free0 (_tmp46_->comment);
		_tmp46_->comment = _tmp49_;
		_tmp50_ = all;
		_tmp51_ = row;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp50_, _tmp51_);
		_video_row_unref0 (row);
	}
	result = all;
	_sqlite3_finalize0 (stmt);
	return result;
}

void
video_table_set_filepath (VideoTable* self,
                          VideoID* video_id,
                          const gchar* filepath,
                          GError** error)
{
	VideoID _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (video_id != NULL);
	g_return_if_fail (filepath != NULL);
	_tmp0_ = *video_id;
	database_table_update_text_by_id_2 ((DatabaseTable*) self, _tmp0_.id, "filename", filepath, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
video_table_set_title (VideoTable* self,
                       VideoID* video_id,
                       const gchar* new_title,
                       GError** error)
{
	const gchar* _tmp0_ = NULL;
	VideoID _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (video_id != NULL);
	if (new_title != NULL) {
		_tmp0_ = new_title;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = *video_id;
	database_table_update_text_by_id_2 ((DatabaseTable*) self, _tmp1_.id, "title", _tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
video_table_set_comment (VideoTable* self,
                         VideoID* video_id,
                         const gchar* new_comment,
                         GError** error)
{
	const gchar* _tmp0_ = NULL;
	VideoID _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (video_id != NULL);
	if (new_comment != NULL) {
		_tmp0_ = new_comment;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = *video_id;
	database_table_update_text_by_id_2 ((DatabaseTable*) self, _tmp1_.id, "comment", _tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
video_table_set_exposure_time (VideoTable* self,
                               VideoID* video_id,
                               gint64 time,
                               GError** error)
{
	VideoID _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (video_id != NULL);
	_tmp0_ = *video_id;
	database_table_update_int64_by_id_2 ((DatabaseTable*) self, _tmp0_.id, "exposure_time", time, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
video_table_set_flags (VideoTable* self,
                       VideoID* video_id,
                       guint64 flags,
                       GError** error)
{
	VideoID _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (video_id != NULL);
	_tmp0_ = *video_id;
	database_table_update_int64_by_id_2 ((DatabaseTable*) self, _tmp0_.id, "flags", (gint64) flags, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
video_table_update_backlinks (VideoTable* self,
                              VideoID* video_id,
                              const gchar* backlinks,
                              GError** error)
{
	const gchar* _tmp0_ = NULL;
	VideoID _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (video_id != NULL);
	if (backlinks != NULL) {
		_tmp0_ = backlinks;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = *video_id;
	database_table_update_text_by_id_2 ((DatabaseTable*) self, _tmp1_.id, "backlinks", _tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
video_table_update_is_interpretable (VideoTable* self,
                                     VideoID* video_id,
                                     gboolean is_interpretable,
                                     GError** error)
{
	gint _tmp0_ = 0;
	VideoID _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (video_id != NULL);
	if (is_interpretable) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	_tmp1_ = *video_id;
	database_table_update_int_by_id_2 ((DatabaseTable*) self, _tmp1_.id, "is_interpretable", _tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

gboolean
video_table_set_event (VideoTable* self,
                       VideoID* video_id,
                       EventID* event_id)
{
	VideoID _tmp0_;
	EventID _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (video_id != NULL, FALSE);
	g_return_val_if_fail (event_id != NULL, FALSE);
	_tmp0_ = *video_id;
	_tmp1_ = *event_id;
	result = database_table_update_int64_by_id ((DatabaseTable*) self, _tmp0_.id, "event_id", _tmp1_.id);
	return result;
}

void
video_table_remove_by_file (VideoTable* self,
                            GFile* file,
                            GError** error)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint res = 0;
	sqlite3_stmt* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "DELETE FROM VideoTable WHERE filename=?");
	stmt = _tmp0_;
	_tmp1_ = stmt;
	_tmp2_ = g_file_get_path (file);
	_tmp3_ = _tmp2_;
	database_table_bind_text (_tmp1_, 1, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = stmt;
	res = sqlite3_step (_tmp4_);
	if (res != SQLITE_DONE) {
		database_table_throw_error ("VideoTable.remove_by_file", res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_sqlite3_finalize0 (stmt);
}

void
video_table_remove (VideoTable* self,
                    VideoID* video_id,
                    GError** error)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	VideoID _tmp2_;
	gint res = 0;
	sqlite3_stmt* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (video_id != NULL);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "DELETE FROM VideoTable WHERE id=?");
	stmt = _tmp0_;
	_tmp1_ = stmt;
	_tmp2_ = *video_id;
	database_table_bind_int64 (_tmp1_, 1, _tmp2_.id);
	_tmp3_ = stmt;
	res = sqlite3_step (_tmp3_);
	if (res != SQLITE_DONE) {
		database_table_throw_error ("VideoTable.remove", res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_sqlite3_finalize0 (stmt);
}

gboolean
video_table_is_video_stored (VideoTable* self,
                             GFile* file)
{
	VideoID _tmp0_ = {0};
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	video_table_get_id (self, file, &_tmp0_);
	result = video_id_is_valid (&_tmp0_);
	return result;
}

void
video_table_get_id (VideoTable* self,
                    GFile* file,
                    VideoID* result)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint res = 0;
	sqlite3_stmt* _tmp4_;
	VideoID _tmp5_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "SELECT ID FROM VideoTable WHERE filename=?");
	stmt = _tmp0_;
	_tmp1_ = stmt;
	_tmp2_ = g_file_get_path (file);
	_tmp3_ = _tmp2_;
	database_table_bind_text (_tmp1_, 1, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = stmt;
	res = sqlite3_step (_tmp4_);
	if (res == SQLITE_ROW) {
		sqlite3_stmt* _tmp6_;
		_tmp6_ = stmt;
		video_id_init (&_tmp5_, sqlite3_column_int64 (_tmp6_, 0));
	} else {
		video_id_init (&_tmp5_, VIDEO_ID_INVALID);
	}
	*result = _tmp5_;
	_sqlite3_finalize0 (stmt);
	return;
}

GeeArrayList*
video_table_get_videos (VideoTable* self,
                        GError** error)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	GeeArrayList* video_ids = NULL;
	GeeArrayList* _tmp1_;
	GError* _inner_error0_ = NULL;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "SELECT id FROM VideoTable");
	stmt = _tmp0_;
	_tmp1_ = gee_array_list_new (TYPE_VIDEO_ID, (GBoxedCopyFunc) video_id_dup, (GDestroyNotify) video_id_free, NULL, NULL, NULL);
	video_ids = _tmp1_;
	{
		gboolean _tmp2_ = FALSE;
		_tmp2_ = TRUE;
		while (TRUE) {
			gint res = 0;
			sqlite3_stmt* _tmp3_;
			GeeArrayList* _tmp4_;
			sqlite3_stmt* _tmp5_;
			VideoID _tmp6_ = {0};
			if (!_tmp2_) {
			}
			_tmp2_ = FALSE;
			_tmp3_ = stmt;
			res = sqlite3_step (_tmp3_);
			if (res == SQLITE_DONE) {
				break;
			} else {
				if (res != SQLITE_ROW) {
					database_table_throw_error ("VideoTable.get_videos", res, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == DATABASE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_object_unref0 (video_ids);
							_sqlite3_finalize0 (stmt);
							return NULL;
						} else {
							_g_object_unref0 (video_ids);
							_sqlite3_finalize0 (stmt);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
				}
			}
			_tmp4_ = video_ids;
			_tmp5_ = stmt;
			video_id_init (&_tmp6_, sqlite3_column_int64 (_tmp5_, 0));
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, &_tmp6_);
		}
	}
	result = video_ids;
	_sqlite3_finalize0 (stmt);
	return result;
}

static sqlite3_stmt*
video_table_get_duplicate_stmt (VideoTable* self,
                                GFile* file,
                                const gchar* md5)
{
	gboolean _tmp0_ = FALSE;
	gchar* sql = NULL;
	gchar* _tmp1_;
	gboolean first = FALSE;
	sqlite3_stmt* stmt = NULL;
	const gchar* _tmp8_;
	sqlite3_stmt* _tmp9_;
	gint col = 0;
	sqlite3_stmt* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (file != NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = md5 != NULL;
	}
	_vala_assert (_tmp0_, "file != null || md5 != null");
	_tmp1_ = g_strdup ("SELECT id FROM VideoTable WHERE");
	sql = _tmp1_;
	first = TRUE;
	if (file != NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = sql;
		_tmp3_ = g_strconcat (_tmp2_, " filename=?", NULL);
		_g_free0 (sql);
		sql = _tmp3_;
		first = FALSE;
	}
	if (md5 != NULL) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		if (!first) {
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = sql;
			_tmp5_ = g_strconcat (_tmp4_, " OR ", NULL);
			_g_free0 (sql);
			sql = _tmp5_;
		}
		_tmp6_ = sql;
		_tmp7_ = g_strconcat (_tmp6_, " md5=?", NULL);
		_g_free0 (sql);
		sql = _tmp7_;
	}
	_tmp8_ = sql;
	_tmp9_ = database_table_create_stmt ((DatabaseTable*) self, _tmp8_);
	stmt = _tmp9_;
	col = 1;
	if (file != NULL) {
		sqlite3_stmt* _tmp10_;
		gint _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp10_ = stmt;
		_tmp11_ = col;
		col = _tmp11_ + 1;
		_tmp12_ = g_file_get_path (file);
		_tmp13_ = _tmp12_;
		database_table_bind_text (_tmp10_, _tmp11_, _tmp13_);
		_g_free0 (_tmp13_);
	}
	if (md5 != NULL) {
		sqlite3_stmt* _tmp14_;
		gint _tmp15_;
		const gchar* _tmp16_;
		_tmp14_ = stmt;
		_tmp15_ = col;
		col = _tmp15_ + 1;
		_tmp16_ = md5;
		database_table_bind_text (_tmp14_, _tmp15_, _tmp16_);
	}
	result = stmt;
	_g_free0 (sql);
	return result;
}

gboolean
video_table_has_duplicate (VideoTable* self,
                           GFile* file,
                           const gchar* md5)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	gint res = 0;
	sqlite3_stmt* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = video_table_get_duplicate_stmt (self, file, md5);
	stmt = _tmp0_;
	_tmp1_ = stmt;
	res = sqlite3_step (_tmp1_);
	if (res == SQLITE_DONE) {
		result = FALSE;
		_sqlite3_finalize0 (stmt);
		return result;
	} else {
		if (res == SQLITE_ROW) {
			result = TRUE;
			_sqlite3_finalize0 (stmt);
			return result;
		} else {
			database_table_fatal ("VideoTable.has_duplicate", res);
		}
	}
	result = FALSE;
	_sqlite3_finalize0 (stmt);
	return result;
}

static void
_vala_array_add50 (VideoID* * array,
                   gint* length,
                   gint* size,
                   const VideoID* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (VideoID, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

VideoID*
video_table_get_duplicate_ids (VideoTable* self,
                               GFile* file,
                               const gchar* md5,
                               gint* result_length1)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	VideoID* ids = NULL;
	VideoID* _tmp1_;
	gint ids_length1;
	gint _ids_size_;
	gint res = 0;
	sqlite3_stmt* _tmp2_;
	VideoID* _tmp6_;
	gint _tmp6__length1;
	VideoID* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = video_table_get_duplicate_stmt (self, file, md5);
	stmt = _tmp0_;
	_tmp1_ = g_new0 (VideoID, 0);
	ids = _tmp1_;
	ids_length1 = 0;
	_ids_size_ = ids_length1;
	_tmp2_ = stmt;
	res = sqlite3_step (_tmp2_);
	while (TRUE) {
		sqlite3_stmt* _tmp3_;
		VideoID _tmp4_ = {0};
		sqlite3_stmt* _tmp5_;
		if (!(res == SQLITE_ROW)) {
			break;
		}
		_tmp3_ = stmt;
		video_id_init (&_tmp4_, sqlite3_column_int64 (_tmp3_, 0));
		_vala_array_add50 (&ids, &ids_length1, &_ids_size_, &_tmp4_);
		_tmp5_ = stmt;
		res = sqlite3_step (_tmp5_);
	}
	_tmp6_ = ids;
	_tmp6__length1 = ids_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	_sqlite3_finalize0 (stmt);
	return result;
}

GeeArrayList*
video_table_get_event_source_ids (VideoTable* self,
                                  EventID* event_id)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	EventID _tmp2_;
	GeeArrayList* _result_ = NULL;
	GeeArrayList* _tmp3_;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (event_id != NULL, NULL);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "SELECT id FROM VideoTable WHERE event_id = ?");
	stmt = _tmp0_;
	_tmp1_ = stmt;
	_tmp2_ = *event_id;
	database_table_bind_int64 (_tmp1_, 1, _tmp2_.id);
	_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_result_ = _tmp3_;
	{
		gboolean _tmp4_ = FALSE;
		_tmp4_ = TRUE;
		while (TRUE) {
			gint res = 0;
			sqlite3_stmt* _tmp5_;
			GeeArrayList* _tmp6_;
			sqlite3_stmt* _tmp7_;
			VideoID _tmp8_ = {0};
			gchar* _tmp9_;
			gchar* _tmp10_;
			if (!_tmp4_) {
			}
			_tmp4_ = FALSE;
			_tmp5_ = stmt;
			res = sqlite3_step (_tmp5_);
			if (res == SQLITE_DONE) {
				break;
			} else {
				if (res != SQLITE_ROW) {
					database_table_fatal ("get_event_source_ids", res);
					break;
				}
			}
			_tmp6_ = _result_;
			_tmp7_ = stmt;
			video_id_init (&_tmp8_, sqlite3_column_int64 (_tmp7_, 0));
			_tmp9_ = video_id_upgrade_video_id_to_source_id (&_tmp8_);
			_tmp10_ = _tmp9_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, _tmp10_);
			_g_free0 (_tmp10_);
		}
	}
	result = _result_;
	_sqlite3_finalize0 (stmt);
	return result;
}

void
video_table_set_timestamp (VideoTable* self,
                           VideoID* video_id,
                           gint64 timestamp,
                           GError** error)
{
	VideoID _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (video_id != NULL);
	_tmp0_ = *video_id;
	database_table_update_int64_by_id_2 ((DatabaseTable*) self, _tmp0_.id, "timestamp", timestamp, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
video_table_class_init (VideoTableClass * klass,
                        gpointer klass_data)
{
	video_table_parent_class = g_type_class_peek_parent (klass);
	((DatabaseTableClass *) klass)->finalize = video_table_finalize;
}

static void
video_table_instance_init (VideoTable * self,
                           gpointer klass)
{
}

static void
video_table_finalize (DatabaseTable * obj)
{
	VideoTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO_TABLE, VideoTable);
	DATABASE_TABLE_CLASS (video_table_parent_class)->finalize (obj);
}

static GType
video_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (VideoTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoTable), 0, (GInstanceInitFunc) video_table_instance_init, NULL };
	GType video_table_type_id;
	video_table_type_id = g_type_register_static (TYPE_DATABASE_TABLE, "VideoTable", &g_define_type_info, 0);
	return video_table_type_id;
}

GType
video_table_get_type (void)
{
	static volatile gsize video_table_type_id__once = 0;
	if (g_once_init_enter (&video_table_type_id__once)) {
		GType video_table_type_id;
		video_table_type_id = video_table_get_type_once ();
		g_once_init_leave (&video_table_type_id__once, video_table_type_id);
	}
	return video_table_type_id__once;
}

