#line 1 "repl_scanner.c"
/*-------------------------------------------------------------------------
 *
 * repl_scanner.l
 *	  a lexical scanner for the replication commands
 *
 * Portions Copyright (c) 1996-2024, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 *
 * IDENTIFICATION
 *	  src/backend/replication/repl_scanner.l
 *
 *-------------------------------------------------------------------------
 */
#include "postgres.h"

#include "nodes/parsenodes.h"
#include "utils/builtins.h"
#include "parser/scansup.h"

/*
 * NB: include repl_gram.h only AFTER including walsender_private.h, because
 * walsender_private includes headers that define XLogRecPtr.
 */
#include "replication/walsender_private.h"
#include "repl_gram.h"

#line 29 "repl_scanner.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define yy_create_buffer replication_yy_create_buffer
#define yy_delete_buffer replication_yy_delete_buffer
#define yy_scan_buffer replication_yy_scan_buffer
#define yy_scan_string replication_yy_scan_string
#define yy_scan_bytes replication_yy_scan_bytes
#define yy_init_buffer replication_yy_init_buffer
#define yy_flush_buffer replication_yy_flush_buffer
#define yy_load_buffer_state replication_yy_load_buffer_state
#define yy_switch_to_buffer replication_yy_switch_to_buffer
#define yypush_buffer_state replication_yypush_buffer_state
#define yypop_buffer_state replication_yypop_buffer_state
#define yyensure_buffer_stack replication_yyensure_buffer_stack
#define yy_flex_debug replication_yy_flex_debug
#define yyin replication_yyin
#define yyleng replication_yyleng
#define yylex replication_yylex
#define yylineno replication_yylineno
#define yyout replication_yyout
#define yyrestart replication_yyrestart
#define yytext replication_yytext
#define yywrap replication_yywrap
#define yyalloc replication_yyalloc
#define yyrealloc replication_yyrealloc
#define yyfree replication_yyfree

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

#ifdef yy_create_buffer
#define replication_yy_create_buffer_ALREADY_DEFINED
#else
#define yy_create_buffer replication_yy_create_buffer
#endif

#ifdef yy_delete_buffer
#define replication_yy_delete_buffer_ALREADY_DEFINED
#else
#define yy_delete_buffer replication_yy_delete_buffer
#endif

#ifdef yy_scan_buffer
#define replication_yy_scan_buffer_ALREADY_DEFINED
#else
#define yy_scan_buffer replication_yy_scan_buffer
#endif

#ifdef yy_scan_string
#define replication_yy_scan_string_ALREADY_DEFINED
#else
#define yy_scan_string replication_yy_scan_string
#endif

#ifdef yy_scan_bytes
#define replication_yy_scan_bytes_ALREADY_DEFINED
#else
#define yy_scan_bytes replication_yy_scan_bytes
#endif

#ifdef yy_init_buffer
#define replication_yy_init_buffer_ALREADY_DEFINED
#else
#define yy_init_buffer replication_yy_init_buffer
#endif

#ifdef yy_flush_buffer
#define replication_yy_flush_buffer_ALREADY_DEFINED
#else
#define yy_flush_buffer replication_yy_flush_buffer
#endif

#ifdef yy_load_buffer_state
#define replication_yy_load_buffer_state_ALREADY_DEFINED
#else
#define yy_load_buffer_state replication_yy_load_buffer_state
#endif

#ifdef yy_switch_to_buffer
#define replication_yy_switch_to_buffer_ALREADY_DEFINED
#else
#define yy_switch_to_buffer replication_yy_switch_to_buffer
#endif

#ifdef yypush_buffer_state
#define replication_yypush_buffer_state_ALREADY_DEFINED
#else
#define yypush_buffer_state replication_yypush_buffer_state
#endif

#ifdef yypop_buffer_state
#define replication_yypop_buffer_state_ALREADY_DEFINED
#else
#define yypop_buffer_state replication_yypop_buffer_state
#endif

#ifdef yyensure_buffer_stack
#define replication_yyensure_buffer_stack_ALREADY_DEFINED
#else
#define yyensure_buffer_stack replication_yyensure_buffer_stack
#endif

#ifdef yylex
#define replication_yylex_ALREADY_DEFINED
#else
#define yylex replication_yylex
#endif

#ifdef yyrestart
#define replication_yyrestart_ALREADY_DEFINED
#else
#define yyrestart replication_yyrestart
#endif

#ifdef yylex_init
#define replication_yylex_init_ALREADY_DEFINED
#else
#define yylex_init replication_yylex_init
#endif

#ifdef yylex_init_extra
#define replication_yylex_init_extra_ALREADY_DEFINED
#else
#define yylex_init_extra replication_yylex_init_extra
#endif

#ifdef yylex_destroy
#define replication_yylex_destroy_ALREADY_DEFINED
#else
#define yylex_destroy replication_yylex_destroy
#endif

#ifdef yyget_debug
#define replication_yyget_debug_ALREADY_DEFINED
#else
#define yyget_debug replication_yyget_debug
#endif

#ifdef yyset_debug
#define replication_yyset_debug_ALREADY_DEFINED
#else
#define yyset_debug replication_yyset_debug
#endif

#ifdef yyget_extra
#define replication_yyget_extra_ALREADY_DEFINED
#else
#define yyget_extra replication_yyget_extra
#endif

#ifdef yyset_extra
#define replication_yyset_extra_ALREADY_DEFINED
#else
#define yyset_extra replication_yyset_extra
#endif

#ifdef yyget_in
#define replication_yyget_in_ALREADY_DEFINED
#else
#define yyget_in replication_yyget_in
#endif

#ifdef yyset_in
#define replication_yyset_in_ALREADY_DEFINED
#else
#define yyset_in replication_yyset_in
#endif

#ifdef yyget_out
#define replication_yyget_out_ALREADY_DEFINED
#else
#define yyget_out replication_yyget_out
#endif

#ifdef yyset_out
#define replication_yyset_out_ALREADY_DEFINED
#else
#define yyset_out replication_yyset_out
#endif

#ifdef yyget_leng
#define replication_yyget_leng_ALREADY_DEFINED
#else
#define yyget_leng replication_yyget_leng
#endif

#ifdef yyget_text
#define replication_yyget_text_ALREADY_DEFINED
#else
#define yyget_text replication_yyget_text
#endif

#ifdef yyget_lineno
#define replication_yyget_lineno_ALREADY_DEFINED
#else
#define yyget_lineno replication_yyget_lineno
#endif

#ifdef yyset_lineno
#define replication_yyset_lineno_ALREADY_DEFINED
#else
#define yyset_lineno replication_yyset_lineno
#endif

#ifdef yywrap
#define replication_yywrap_ALREADY_DEFINED
#else
#define yywrap replication_yywrap
#endif

#ifdef yyalloc
#define replication_yyalloc_ALREADY_DEFINED
#else
#define yyalloc replication_yyalloc
#endif

#ifdef yyrealloc
#define replication_yyrealloc_ALREADY_DEFINED
#else
#define yyrealloc replication_yyrealloc
#endif

#ifdef yyfree
#define replication_yyfree_ALREADY_DEFINED
#else
#define yyfree replication_yyfree
#endif

#ifdef yytext
#define replication_yytext_ALREADY_DEFINED
#else
#define yytext replication_yytext
#endif

#ifdef yyleng
#define replication_yyleng_ALREADY_DEFINED
#else
#define yyleng replication_yyleng
#endif

#ifdef yyin
#define replication_yyin_ALREADY_DEFINED
#else
#define yyin replication_yyin
#endif

#ifdef yyout
#define replication_yyout_ALREADY_DEFINED
#else
#define yyout replication_yyout
#endif

#ifdef yy_flex_debug
#define replication_yy_flex_debug_ALREADY_DEFINED
#else
#define yy_flex_debug replication_yy_flex_debug
#endif

#ifdef yylineno
#define replication_yylineno_ALREADY_DEFINED
#else
#define yylineno replication_yylineno
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin  )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern int yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = NULL; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = NULL;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart ( FILE *input_file  );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size  );
void yy_delete_buffer ( YY_BUFFER_STATE b  );
void yy_flush_buffer ( YY_BUFFER_STATE b  );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state ( void );

static void yyensure_buffer_stack ( void );
static void yy_load_buffer_state ( void );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file  );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size  );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, int len  );

void *yyalloc ( yy_size_t  );
void *yyrealloc ( void *, yy_size_t  );
void yyfree ( void *  );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define replication_yywrap() (/*CONSTCOND*/1)
#define YY_SKIP_YYWRAP
typedef flex_uint8_t YY_CHAR;

FILE *yyin = NULL, *yyout = NULL;

typedef int yy_state_type;

extern int yylineno;
int yylineno = 1;

extern char *yytext;
#ifdef yytext_ptr
#undef yytext_ptr
#endif
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state ( void );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  );
static int yy_get_next_buffer ( void );
static void yynoreturn yy_fatal_error ( const char* msg  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;
#define YY_NUM_RULES 34
#define YY_END_OF_BUFFER 35
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static const flex_int16_t yy_accept[285] =
    {   0,
        0,    0,    0,    0,    0,    0,   35,   33,   22,   22,
       29,   25,   23,   32,   32,   32,   32,   32,   32,   32,
       32,   32,   32,   32,   32,   32,   32,   32,   32,   31,
       30,   28,   26,   22,    0,   23,    0,   32,   32,   32,
       32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
       32,   32,   32,   32,   32,   32,   32,   32,   31,   28,
       27,   24,   32,   32,   32,   32,   32,   32,   32,   32,
       32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
       32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
       32,   32,   32,    4,   14,   32,   32,   32,   32,   32,

       32,   20,   32,   32,   32,   32,   32,   32,   32,   32,
       32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
       32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
       32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
       32,   32,   13,   32,   32,   32,   32,   32,   32,   32,
       32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
       11,   32,   32,   32,   32,    5,   32,   32,   32,   32,
       32,   32,   32,   32,   32,   32,   32,   32,   32,   15,
       32,   16,   32,   32,   32,   32,   32,   32,   32,   32,
       32,   32,   32,   32,   32,   32,   32,   32,    1,   32,

       32,   32,   32,   32,   32,   12,   32,   32,   32,   32,
       32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
       19,   32,   32,   32,   32,   32,   32,   32,   32,   32,
       32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
       32,   32,   32,   32,   17,    2,   32,   32,   32,   32,
       21,   32,   32,   32,   32,   32,   32,   10,   32,   32,
       32,   18,   32,    6,   32,   32,   32,   32,   32,   32,
       32,   32,   32,   32,   32,   32,   32,   32,    8,    3,
        9,   32,    7,    0
    } ;

static const YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        2,    2,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    4,    1,    5,    1,    1,    6,    1,
        1,    1,    1,    1,    1,    1,    7,    8,    8,    8,
        8,    8,    8,    8,    8,    8,    8,    1,    1,    1,
        1,    1,    1,    1,    9,   10,   11,   12,   13,   14,
       15,   16,   17,   18,   19,   20,   21,   22,   23,   24,
       18,   25,   26,   27,   28,   29,   30,   31,   32,   18,
        1,    1,    1,    1,   33,    1,   34,   34,   34,   34,

       34,   34,   18,   18,   18,   18,   18,   18,   18,   18,
       18,   18,   18,   18,   18,   18,   18,   18,   18,   18,
       18,   18,    1,    1,    1,    1,    1,   18,   18,   18,
       18,   18,   18,   18,   18,   18,   18,   18,   18,   18,
       18,   18,   18,   18,   18,   18,   18,   18,   18,   18,
       18,   18,   18,   18,   18,   18,   18,   18,   18,   18,
       18,   18,   18,   18,   18,   18,   18,   18,   18,   18,
       18,   18,   18,   18,   18,   18,   18,   18,   18,   18,
       18,   18,   18,   18,   18,   18,   18,   18,   18,   18,
       18,   18,   18,   18,   18,   18,   18,   18,   18,   18,

       18,   18,   18,   18,   18,   18,   18,   18,   18,   18,
       18,   18,   18,   18,   18,   18,   18,   18,   18,   18,
       18,   18,   18,   18,   18,   18,   18,   18,   18,   18,
       18,   18,   18,   18,   18,   18,   18,   18,   18,   18,
       18,   18,   18,   18,   18,   18,   18,   18,   18,   18,
       18,   18,   18,   18,   18
    } ;

static const YY_CHAR yy_meta[35] =
    {   0,
        1,    1,    1,    2,    3,    4,    5,    6,    6,    6,
        6,    6,    6,    6,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    6
    } ;

static const flex_int16_t yy_base[292] =
    {   0,
        0,    0,  588,  587,  584,  583,  588,  593,   33,   35,
      593,  593,   32,   34,   62,   40,   41,   46,  578,  579,
       44,   55,   56,   45,   46,   73,   74,   60,   51,    0,
      593,    0,  579,   80,    0,   87,  577,  576,  573,   78,
       81,   85,   90,   92,   95,   94,   99,   96,  108,  103,
      104,  111,  112,  114,  107,  116,  118,  115,    0,    0,
      593,    0,  130,  131,  132,  122,  117,  135,  138,   57,
      140,  141,  143,  142,  144,  145,  151,  147,  152,  154,
      155,  156,  157,  158,  160,  161,  167,  162,  169,  166,
      179,  171,  172,  574,  573,  174,  177,  186,  188,  196,

      191,  572,  192,  200,  195,  202,  204,  206,  207,  211,
      208,  213,  214,  215,  217,  219,  221,  223,  222,  225,
      232,  226,  233,  238,  240,  242,  244,  246,  245,  250,
      249,  257,  253,  258,  254,  261,  265,  266,  269,  272,
      273,  274,  571,  275,  277,  276,  278,  279,  282,  288,
      283,  284,  286,  291,  297,  301,  305,  281,  306,  310,
      568,  311,  312,  313,  314,  315,  316,  317,  321,  320,
      323,  325,  327,  326,  329,  331,  343,  345,  338,  560,
      346,  556,  334,  352,  354,  356,  357,  358,  359,  360,
      363,  365,  366,  367,  371,  372,  368,  383,  539,  380,

      386,  374,  375,  389,  395,  535,  392,  398,  399,  400,
      401,  404,  402,  405,  407,  409,  410,  411,  412,  415,
      534,  416,  423,  418,  419,  431,  424,  429,  433,  434,
      438,  441,  440,  442,  444,  445,  446,  447,  452,  448,
      449,  454,  461,  465,  533,  532,  456,  467,  468,  473,
      531,  474,  475,  476,  477,  478,  479,  530,  481,  485,
      486,  529,  487,  527,  490,  488,  483,  495,  499,  492,
      501,  503,  510,  515,  493,  516,  518,  521,  525,  524,
      523,  520,  522,  593,  547,  553,  555,  559,  565,  571,
       51

    } ;

static const flex_int16_t yy_def[292] =
    {   0,
      284,    1,  285,  285,  286,  286,  284,  284,  284,  284,
      284,  284,  287,  288,  288,   15,   15,   15,   15,  288,
      288,  288,  288,  288,  288,  288,  288,  288,  288,  289,
      284,  290,  284,  284,  291,  287,  287,  288,   15,  288,
       15,  288,  288,  288,  288,  288,  288,  288,  288,  288,
      288,  288,  288,  288,  288,  288,  288,  288,  289,  290,
      284,  291,  288,  288,  288,  288,  288,  288,  288,  288,
      288,  288,  288,  288,  288,  288,  288,  288,  288,  288,
      288,  288,  288,  288,  288,  288,  288,  288,  288,  288,
      288,  288,  288,  288,  288,  288,  288,  288,  288,  288,

      288,  288,  288,  288,  288,  288,  288,  288,  288,  288,
      288,  288,  288,  288,  288,  288,  288,  288,  288,  288,
      288,  288,  288,  288,  288,  288,  288,  288,  288,  288,
      288,  288,  288,  288,  288,  288,  288,  288,  288,  288,
      288,  288,  288,  288,  288,  288,  288,  288,  288,  288,
      288,  288,  288,  288,  288,  288,  288,  288,  288,  288,
      288,  288,  288,  288,  288,  288,  288,  288,  288,  288,
      288,  288,  288,  288,  288,  288,  288,  288,  288,  288,
      288,  288,  288,  288,  288,  288,  288,  288,  288,  288,
      288,  288,  288,  288,  288,  288,  288,  288,  288,  288,

      288,  288,  288,  288,  288,  288,  288,  288,  288,  288,
      288,  288,  288,  288,  288,  288,  288,  288,  288,  288,
      288,  288,  288,  288,  288,  288,  288,  288,  288,  288,
      288,  288,  288,  288,  288,  288,  288,  288,  288,  288,
      288,  288,  288,  288,  288,  288,  288,  288,  288,  288,
      288,  288,  288,  288,  288,  288,  288,  288,  288,  288,
      288,  288,  288,  288,  288,  288,  288,  288,  288,  288,
      288,  288,  288,  288,  288,  288,  288,  288,  288,  288,
      288,  288,  288,    0,  284,  284,  284,  284,  284,  284,
      284

    } ;

static const flex_int16_t yy_nxt[628] =
    {   0,
        8,    9,   10,   11,    8,   12,    8,   13,   14,   15,
       16,   17,   18,   19,   20,   20,   21,   20,   20,   22,
       20,   23,   20,   24,   25,   26,   27,   28,   20,   29,
       20,   20,   20,   19,   34,   34,   34,   34,   35,   36,
       35,   39,   39,   39,   39,   39,   39,   39,   39,   39,
      284,  284,  284,   40,   39,   45,   62,  284,   49,   58,
       48,  284,  284,  284,   42,   43,  284,   39,   35,   39,
       41,   39,   39,   39,   39,   39,   44,   46,   47,  284,
      284,   34,   34,   56,  284,   57,   53,   90,   50,   39,
       54,  284,   51,   35,   36,   39,  284,   65,  284,   52,

      284,  284,  284,   55,   63,  284,   64,   68,   69,  284,
      284,   70,   66,  284,  284,   67,   72,  284,  284,   76,
      284,  284,  284,  284,  284,   74,   75,   71,  284,   79,
       81,   82,   77,   73,   78,   80,  284,  284,  284,   87,
       85,  284,   83,   84,  284,   86,  284,  284,  284,  284,
      284,  284,   92,  284,   89,   93,   88,  284,  284,   98,
      284,  284,  284,  284,  284,   91,  284,  284,  284,   96,
       95,   94,  284,  284,   97,  284,  100,  284,  284,  109,
      284,  103,  102,  284,   99,  284,  105,  101,  108,  110,
      104,  107,  284,  106,  284,  111,  113,  284,  284,  115,

      114,  284,  284,  112,  118,  116,  284,  122,  284,  121,
      284,  117,  284,  284,  284,  126,  119,  284,  128,  284,
      284,  284,  125,  284,  120,  284,  123,  284,  284,  284,
      124,  284,  284,  127,  135,  133,  134,  129,  284,  284,
      138,  132,  130,  136,  284,  140,  284,  131,  284,  137,
      284,  284,  284,  142,  145,  284,  284,  146,  139,  284,
      284,  143,  147,  284,  284,  149,  151,  284,  144,  153,
      141,  284,  284,  148,  150,  284,  155,  154,  284,  284,
      284,  284,  284,  284,  284,  284,  152,  284,  284,  284,
      284,  164,  284,  156,  284,  157,  161,  284,  158,  162,

      166,  160,  174,  284,  168,  159,  165,  284,  167,  169,
      163,  284,  284,  172,  170,  171,  284,  284,  284,  284,
      284,  284,  284,  284,  173,  183,  284,  284,  182,  284,
      177,  284,  284,  284,  189,  284,  179,  284,  175,  185,
      284,  178,  176,  188,  284,  180,  184,  181,  187,  284,
      186,  284,  284,  193,  190,  196,  191,  194,  284,  192,
      284,  195,  284,  284,  284,  284,  284,  197,  201,  284,
      198,  284,  284,  284,  284,  205,  200,  284,  284,  199,
      284,  284,  202,  207,  204,  206,  284,  208,  209,  284,
      210,  203,  284,  211,  213,  284,  212,  216,  284,  214,

      215,  284,  218,  217,  284,  284,  284,  284,  284,  222,
      284,  284,  220,  284,  223,  284,  284,  284,  284,  229,
      225,  284,  284,  219,  284,  284,  221,  231,  224,  284,
      284,  233,  227,  226,  234,  284,  228,  284,  230,  284,
      284,  235,  232,  236,  284,  238,  284,  284,  284,  237,
      284,  284,  284,  284,  284,  284,  240,  242,  284,  239,
      284,  247,  284,  241,  244,  246,  243,  284,  249,  248,
      245,  284,  250,  284,  284,  251,  252,  253,  255,  284,
      284,  284,  284,  284,  284,  284,  254,  284,  256,  284,
      257,  284,  284,  284,  284,  259,  284,  260,  284,  284,

      264,  284,  271,  262,  258,  284,  266,  284,  261,  284,
      263,  267,  268,  265,  272,  269,  284,  274,  273,  279,
      270,  284,  284,  275,  284,  276,  284,  284,  284,  284,
      284,  284,  277,  284,  278,  284,  284,  284,  284,  284,
      284,  284,  280,  282,  281,  284,  283,   30,   30,   30,
       30,   30,   30,   32,   32,   32,   32,   32,   32,   37,
       37,   38,  284,   38,   38,   59,  284,   59,   59,   59,
       59,   60,   60,   60,  284,   60,   60,  284,  284,  284,
      284,   39,  284,   35,   61,  284,   39,  284,   33,   33,
       31,   31,    7,  284,  284,  284,  284,  284,  284,  284,

      284,  284,  284,  284,  284,  284,  284,  284,  284,  284,
      284,  284,  284,  284,  284,  284,  284,  284,  284,  284,
      284,  284,  284,  284,  284,  284,  284
    } ;

static const flex_int16_t yy_chk[628] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    9,    9,   10,   10,   13,   13,
       14,   14,   14,   14,   14,   14,   14,   14,   16,   17,
       21,   24,   25,   14,   18,   21,  291,   29,   25,   29,
       24,   22,   23,   70,   16,   17,   28,   14,   15,   15,
       15,   15,   15,   15,   15,   15,   18,   22,   23,   26,
       27,   34,   34,   28,   40,   28,   27,   70,   26,   41,
       27,   42,   26,   36,   36,   15,   43,   42,   44,   26,

       46,   45,   48,   27,   40,   47,   41,   45,   46,   50,
       51,   47,   43,   55,   49,   44,   49,   52,   53,   52,
       54,   58,   56,   67,   57,   50,   51,   48,   66,   55,
       57,   58,   53,   49,   54,   56,   63,   64,   65,   67,
       65,   68,   63,   64,   69,   66,   71,   72,   74,   73,
       75,   76,   72,   78,   69,   73,   68,   77,   79,   78,
       80,   81,   82,   83,   84,   71,   85,   86,   88,   76,
       75,   74,   90,   87,   77,   89,   80,   92,   93,   89,
       96,   83,   82,   97,   79,   91,   85,   81,   88,   90,
       84,   87,   98,   86,   99,   91,   93,  101,  103,   97,

       96,  105,  100,   92,  100,   98,  104,  105,  106,  104,
      107,   99,  108,  109,  111,  109,  101,  110,  111,  112,
      113,  114,  108,  115,  103,  116,  106,  117,  119,  118,
      107,  120,  122,  110,  118,  116,  117,  112,  121,  123,
      121,  115,  113,  119,  124,  123,  125,  114,  126,  120,
      127,  129,  128,  125,  128,  131,  130,  129,  122,  133,
      135,  126,  130,  132,  134,  132,  134,  136,  127,  136,
      124,  137,  138,  131,  133,  139,  138,  137,  140,  141,
      142,  144,  146,  145,  147,  148,  135,  158,  149,  151,
      152,  148,  153,  139,  150,  140,  145,  154,  141,  146,

      150,  144,  158,  155,  152,  142,  149,  156,  151,  153,
      147,  157,  159,  156,  154,  155,  160,  162,  163,  164,
      165,  166,  167,  168,  157,  168,  170,  169,  167,  171,
      162,  172,  174,  173,  174,  175,  164,  176,  159,  170,
      183,  163,  160,  173,  179,  165,  169,  166,  172,  177,
      171,  178,  181,  178,  175,  183,  176,  179,  184,  177,
      185,  181,  186,  187,  188,  189,  190,  184,  188,  191,
      185,  192,  193,  194,  197,  192,  187,  195,  196,  186,
      202,  203,  189,  194,  191,  193,  200,  195,  196,  198,
      197,  190,  201,  198,  201,  204,  200,  204,  207,  202,

      203,  205,  207,  205,  208,  209,  210,  211,  213,  211,
      212,  214,  209,  215,  212,  216,  217,  218,  219,  218,
      214,  220,  222,  208,  224,  225,  210,  220,  213,  223,
      227,  223,  216,  215,  224,  228,  217,  226,  219,  229,
      230,  225,  222,  226,  231,  228,  233,  232,  234,  227,
      235,  236,  237,  238,  240,  241,  230,  232,  239,  229,
      242,  237,  247,  231,  234,  236,  233,  243,  239,  238,
      235,  244,  240,  248,  249,  241,  242,  243,  247,  250,
      252,  253,  254,  255,  256,  257,  244,  259,  248,  267,
      249,  260,  261,  263,  266,  252,  265,  253,  270,  275,

      257,  268,  267,  255,  250,  269,  260,  271,  254,  272,
      256,  261,  263,  259,  268,  265,  273,  270,  269,  275,
      266,  274,  276,  271,  277,  272,  282,  278,  283,  281,
      280,  279,  273,  264,  274,  262,  258,  251,  246,  245,
      221,  206,  276,  278,  277,  199,  282,  285,  285,  285,
      285,  285,  285,  286,  286,  286,  286,  286,  286,  287,
      287,  288,  182,  288,  288,  289,  180,  289,  289,  289,
      289,  290,  290,  290,  161,  290,  290,  143,  102,   95,
       94,   39,   38,   37,   33,   20,   19,    7,    6,    5,
        4,    3,  284,  284,  284,  284,  284,  284,  284,  284,

      284,  284,  284,  284,  284,  284,  284,  284,  284,  284,
      284,  284,  284,  284,  284,  284,  284,  284,  284,  284,
      284,  284,  284,  284,  284,  284,  284
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"

#line 31 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
/* Avoid exit() on fatal scanner errors (a bit ugly -- see yy_fatal_error) */
#undef fprintf
#define fprintf(file, fmt, msg)  fprintf_to_ereport(fmt, msg)

static void
fprintf_to_ereport(const char *fmt, const char *msg)
{
	ereport(ERROR, (errmsg_internal("%s", msg)));
}

/* Handle to the buffer that the lexer uses internally */
static YY_BUFFER_STATE scanbufhandle;

/* Pushed-back token (we only handle one) */
static int	repl_pushed_back_token;

/* Work area for collecting literals */
static StringInfoData litbuf;

static void startlit(void);
static char *litbufdup(void);
static void addlit(char *ytext, int yleng);
static void addlitchar(unsigned char ychar);

/* LCOV_EXCL_START */

#line 990 "repl_scanner.c"
#define YY_NO_INPUT 1
/*
 * Exclusive states:
 *  <xd> delimited identifiers (double-quoted identifiers)
 *  <xq> standard single-quoted strings
 */

/* Extended quote
 * xqdouble implements embedded quote, ''''
 */
/* Double quote
 * Allows embedded spaces and other special characters into identifiers.
 */
#line 1004 "repl_scanner.c"

#define INITIAL 0
#define xd 1
#define xq 2

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals ( void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( void );

int yyget_debug ( void );

void yyset_debug ( int debug_flag  );

YY_EXTRA_TYPE yyget_extra ( void );

void yyset_extra ( YY_EXTRA_TYPE user_defined  );

FILE *yyget_in ( void );

void yyset_in  ( FILE * _in_str  );

FILE *yyget_out ( void );

void yyset_out  ( FILE * _out_str  );

			int yyget_leng ( void );

char *yyget_text ( void );

int yyget_lineno ( void );

void yyset_lineno ( int _line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( void );
#else
extern int yywrap ( void );
#endif
#endif

#ifndef YY_NO_UNPUT
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * );
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( void );
#else
static int input ( void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex (void);

#define YY_DECL int yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE );
		}

		yy_load_buffer_state(  );
		}

	{
#line 105 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"



#line 109 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
	/* This code is inserted at the start of replication_yylex() */

	/* If we have a pushed-back token, return that. */
	if (repl_pushed_back_token)
	{
		int			result = repl_pushed_back_token;

		repl_pushed_back_token = 0;
		return result;
	}


#line 1238 "repl_scanner.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 285 )
					yy_c = yy_meta[yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 284 );
		yy_cp = (yy_last_accepting_cpos);
		yy_current_state = (yy_last_accepting_state);

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 121 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{ return K_BASE_BACKUP; }
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 122 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{ return K_IDENTIFY_SYSTEM; }
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 123 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{ return K_READ_REPLICATION_SLOT; }
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 124 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{ return K_SHOW; }
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 125 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{ return K_TIMELINE; }
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 126 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{ return K_START_REPLICATION; }
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 127 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{ return K_CREATE_REPLICATION_SLOT; }
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 128 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{ return K_DROP_REPLICATION_SLOT; }
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 129 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{ return K_ALTER_REPLICATION_SLOT; }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 130 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{ return K_TIMELINE_HISTORY; }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 131 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{ return K_PHYSICAL; }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 132 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{ return K_RESERVE_WAL; }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 133 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{ return K_LOGICAL; }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 134 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{ return K_SLOT; }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 135 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{ return K_TEMPORARY; }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 136 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{ return K_TWO_PHASE; }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 137 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{ return K_EXPORT_SNAPSHOT; }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 138 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{ return K_NOEXPORT_SNAPSHOT; }
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 139 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{ return K_USE_SNAPSHOT; }
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 140 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{ return K_WAIT; }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 141 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{ return K_UPLOAD_MANIFEST; }
	YY_BREAK
case 22:
/* rule 22 can match eol */
YY_RULE_SETUP
#line 143 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{ /* do nothing */ }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 145 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{
					replication_yylval.uintval = strtoul(yytext, NULL, 10);
					return UCONST;
				}
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 150 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{
					uint32	hi,
							lo;
					if (sscanf(yytext, "%X/%X", &hi, &lo) != 2)
						replication_yyerror("invalid streaming start location");
					replication_yylval.recptr = ((uint64) hi) << 32 | lo;
					return RECPTR;
				}
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 159 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{
					BEGIN(xq);
					startlit();
				}
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 164 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{
					yyless(1);
					BEGIN(INITIAL);
					replication_yylval.str = litbufdup();
					return SCONST;
				}
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 171 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{
					addlitchar('\'');
				}
	YY_BREAK
case 28:
/* rule 28 can match eol */
YY_RULE_SETUP
#line 175 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 179 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{
					BEGIN(xd);
					startlit();
				}
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 184 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{
					int			len;

					yyless(1);
					BEGIN(INITIAL);
					replication_yylval.str = litbufdup();
					len = strlen(replication_yylval.str);
					truncate_identifier(replication_yylval.str, len, true);
					return IDENT;
				}
	YY_BREAK
case 31:
/* rule 31 can match eol */
YY_RULE_SETUP
#line 195 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 199 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{
					int			len = strlen(yytext);

					replication_yylval.str = downcase_truncate_identifier(yytext, len, true);
					return IDENT;
				}
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 206 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{
					/* Any char not recognized above is returned as itself */
					return yytext[0];
				}
	YY_BREAK
case YY_STATE_EOF(xq):
case YY_STATE_EOF(xd):
#line 211 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{ replication_yyerror("unterminated quoted string"); }
	YY_BREAK
case YY_STATE_EOF(INITIAL):
#line 214 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
{
					yyterminate();
				}
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 218 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"
YY_FATAL_ERROR( "flex scanner jammed" );
	YY_BREAK
#line 1519 "repl_scanner.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_last_accepting_cpos);
				yy_current_state = (yy_last_accepting_state);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap(  ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = (yytext_ptr);
	int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr) - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 (yy_size_t) (b->yy_buf_size + 2)  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if (((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 285 )
				yy_c = yy_meta[yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	int yy_is_jam;
    	char *yy_cp = (yy_c_buf_p);

	YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 285 )
			yy_c = yy_meta[yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	yy_is_jam = (yy_current_state == 284);

		return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (int) ((yy_c_buf_p) - (yytext_ptr));
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap(  ) )
						return 0;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE );
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file );
	yy_load_buffer_state(  );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state(  );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2)  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf  );

	yyfree( (void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state(  );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state(  );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state(  );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (const char * yystr )
{
    
	return yy_scan_bytes( yystr, (int) strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (const char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc( n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg )
{
			fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
    
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
int yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param _line_number line number
 * 
 */
void yyset_lineno (int  _line_number )
{
    
    yylineno = _line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str )
{
        yyin = _in_str ;
}

void yyset_out (FILE *  _out_str )
{
        yyout = _out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  _bdebug )
{
        yy_flex_debug = _bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    (yy_buffer_stack) = NULL;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = NULL;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer( YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
			return malloc(size);
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return realloc(ptr, size);
}

void yyfree (void * ptr )
{
			free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 218 "/build/postgresql-old-upgrade/src/build/../postgresql-17.6/src/backend/replication/repl_scanner.l"


/* LCOV_EXCL_STOP */

static void
startlit(void)
{
	initStringInfo(&litbuf);
}

static char *
litbufdup(void)
{
	return litbuf.data;
}

static void
addlit(char *ytext, int yleng)
{
	appendBinaryStringInfo(&litbuf, ytext, yleng);
}

static void
addlitchar(unsigned char ychar)
{
	appendStringInfoChar(&litbuf, ychar);
}

void
replication_yyerror(const char *message)
{
	ereport(ERROR,
			(errcode(ERRCODE_SYNTAX_ERROR),
			 errmsg_internal("%s", message)));
}


void
replication_scanner_init(const char *str)
{
	Size		slen = strlen(str);
	char	   *scanbuf;

	/*
	 * Might be left over after ereport()
	 */
	if (YY_CURRENT_BUFFER)
		yy_delete_buffer(YY_CURRENT_BUFFER);

	/*
	 * Make a scan buffer with special termination needed by flex.
	 */
	scanbuf = (char *) palloc(slen + 2);
	memcpy(scanbuf, str, slen);
	scanbuf[slen] = scanbuf[slen + 1] = YY_END_OF_BUFFER_CHAR;
	scanbufhandle = yy_scan_buffer(scanbuf, slen + 2);

	/* Make sure we start in proper state */
	BEGIN(INITIAL);
	repl_pushed_back_token = 0;
}

void
replication_scanner_finish(void)
{
	yy_delete_buffer(scanbufhandle);
	scanbufhandle = NULL;
}

/*
 * Check to see if the first token of a command is a WalSender keyword.
 *
 * To keep repl_scanner.l minimal, we don't ask it to know every construct
 * that the core lexer knows.  Therefore, we daren't lex more than the
 * first token of a general SQL command.  That will usually look like an
 * IDENT token here, although some other cases are possible.
 */
bool
replication_scanner_is_replication_command(void)
{
	int			first_token = replication_yylex();

	switch (first_token)
	{
		case K_IDENTIFY_SYSTEM:
		case K_BASE_BACKUP:
		case K_START_REPLICATION:
		case K_CREATE_REPLICATION_SLOT:
		case K_DROP_REPLICATION_SLOT:
		case K_ALTER_REPLICATION_SLOT:
		case K_READ_REPLICATION_SLOT:
		case K_TIMELINE_HISTORY:
		case K_UPLOAD_MANIFEST:
		case K_SHOW:
			/* Yes; push back the first token so we can parse later. */
			repl_pushed_back_token = first_token;
			return true;
		default:
			/* Nope; we don't bother to push back the token. */
			return false;
	}
}

