// Copyright © 2023-2025 Advanced Micro Devices, Inc.
// SPDX-License-Identifier: MIT

// clang-format off
#pragma once

#include <aotriton/config.h>
#include <aotriton/_internal/triton_kernel.h>
#include <aotriton/dtypes.h>
#include <aotriton/runtime.h>
#include <aotriton/util.h>
#include <aotriton/_internal/lazy_tensor_internal.h>
#include <functional>
#include <string>
#include <vector>

#if 1
namespace AOTRITON_NS::v3::flash {
    struct OpAttnBwdParams;
}
#endif

namespace AOTRITON_NS::v3::flash {

#if 1
using AOTRITON_NS::v3::flash::OpAttnBwdParams;
#else
// The parameter class must be defined here when
// There is no common operator for bwd_postprocess.
struct OpAttnBwdParams {
    LazyTensorInternal<4>* DQ_ACC;
    const TensorView<4>*   DQ;
    int32_t                max_seqlen_q;
    int32_t                head_dim;
    int16_t                BLOCK_DMODEL;
    bool                   PADDED_HEAD;
};
#endif

struct BwdPostprocessContext {
    const OpAttnBwdParams *params = nullptr;
    // Performance related arguments for current selection
    int16_t BLOCK_M;

    TritonKernel* kernel_on_device = nullptr;
    int pp_args_index = -1;
    pstring_view package_path;
    std::string_view func_name;
    std::string_view arch_name;
    // Note to save ELF space, this object is constructed on the fly.
    const char* _debug_kernel_name = nullptr;
#if AOTRITON_BUILD_FOR_TUNING
    int _has_preferred_kernel = -1; // For C++ based autotune database generation
    int _total_number_of_kernels = -1;
    const char* _preferred_kernel_psels = nullptr;
    const char* _preferred_kernel_copts = nullptr;
    bool peek_kernel_image = false;
#endif

    hipError_t lookup_optimal(Gpu gpu);
    hipError_t launch(hipStream_t stream) const;

    dim3 grid_calculator() const;
    std::function<dim3(const BwdPostprocessContext&)> custom_grid_calculator;

    int64_t godel_number() const;
    static std::tuple<int, int> get_archmod_number(Gpu gpu);
    static constexpr int kMaxGodelNumber = 48;

    typedef void (*AutoTuneTableEntry)(BwdPostprocessContext& context, int mod_number);
    static AutoTuneTableEntry autotune_table[][ kMaxGodelNumber ];
};

struct BwdPostprocessMetadata {
    // Note: FEAT_CHOICES here
    static const std::vector<std::string>& get_DQ_ACC_choices();
    static const std::vector<std::string>& get_DQ_choices();
    static const std::vector<std::string>& get_max_seqlen_q_choices();
    static const std::vector<std::string>& get_head_dim_choices();
    static const std::vector<int>& get_BLOCK_DMODEL_choices();
    static const std::vector<bool>& get_PADDED_HEAD_choices();
};

namespace autotune {

extern const char bwd_postprocess_packed_string[];

extern int bwd_postprocess__lut_lambda__0(const OpAttnBwdParams& params, int mod_number, int8_t lut[1][1]);

void Autotune_bwd_postprocess__A0__F0(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F1(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F2(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F3(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F4(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F5(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F6(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F7(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F8(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F9(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F10(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F11(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F12(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F13(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F14(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F15(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F16(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F17(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F18(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F19(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F20(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F21(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F22(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F23(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F24(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F25(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F26(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F27(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F28(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F29(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F30(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F31(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F32(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F33(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F34(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F35(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F36(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F37(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F38(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F39(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F40(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F41(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F42(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F43(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F44(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F45(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F46(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A0__F47(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F0(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F1(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F2(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F3(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F4(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F5(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F6(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F7(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F8(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F9(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F10(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F11(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F12(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F13(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F14(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F15(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F16(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F17(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F18(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F19(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F20(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F21(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F22(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F23(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F24(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F25(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F26(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F27(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F28(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F29(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F30(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F31(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F32(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F33(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F34(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F35(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F36(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F37(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F38(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F39(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F40(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F41(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F42(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F43(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F44(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F45(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F46(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A1__F47(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F0(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F1(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F2(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F3(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F4(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F5(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F6(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F7(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F8(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F9(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F10(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F11(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F12(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F13(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F14(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F15(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F16(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F17(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F18(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F19(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F20(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F21(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F22(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F23(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F24(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F25(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F26(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F27(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F28(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F29(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F30(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F31(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F32(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F33(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F34(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F35(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F36(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F37(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F38(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F39(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F40(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F41(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F42(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F43(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F44(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F45(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F46(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A2__F47(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F0(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F1(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F2(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F3(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F4(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F5(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F6(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F7(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F8(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F9(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F10(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F11(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F12(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F13(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F14(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F15(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F16(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F17(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F18(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F19(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F20(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F21(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F22(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F23(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F24(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F25(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F26(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F27(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F28(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F29(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F30(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F31(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F32(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F33(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F34(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F35(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F36(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F37(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F38(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F39(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F40(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F41(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F42(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F43(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F44(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F45(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F46(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A3__F47(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F0(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F1(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F2(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F3(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F4(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F5(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F6(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F7(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F8(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F9(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F10(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F11(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F12(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F13(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F14(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F15(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F16(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F17(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F18(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F19(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F20(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F21(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F22(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F23(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F24(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F25(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F26(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F27(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F28(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F29(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F30(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F31(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F32(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F33(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F34(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F35(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F36(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F37(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F38(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F39(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F40(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F41(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F42(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F43(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F44(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F45(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F46(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A4__F47(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F0(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F1(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F2(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F3(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F4(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F5(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F6(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F7(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F8(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F9(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F10(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F11(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F12(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F13(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F14(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F15(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F16(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F17(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F18(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F19(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F20(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F21(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F22(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F23(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F24(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F25(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F26(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F27(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F28(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F29(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F30(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F31(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F32(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F33(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F34(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F35(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F36(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F37(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F38(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F39(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F40(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F41(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F42(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F43(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F44(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F45(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F46(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A5__F47(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F0(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F1(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F2(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F3(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F4(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F5(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F6(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F7(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F8(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F9(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F10(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F11(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F12(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F13(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F14(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F15(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F16(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F17(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F18(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F19(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F20(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F21(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F22(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F23(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F24(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F25(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F26(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F27(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F28(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F29(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F30(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F31(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F32(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F33(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F34(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F35(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F36(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F37(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F38(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F39(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F40(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F41(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F42(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F43(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F44(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F45(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F46(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A6__F47(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F0(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F1(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F2(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F3(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F4(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F5(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F6(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F7(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F8(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F9(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F10(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F11(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F12(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F13(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F14(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F15(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F16(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F17(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F18(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F19(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F20(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F21(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F22(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F23(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F24(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F25(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F26(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F27(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F28(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F29(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F30(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F31(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F32(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F33(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F34(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F35(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F36(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F37(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F38(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F39(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F40(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F41(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F42(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F43(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F44(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F45(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F46(BwdPostprocessContext& params, int mod_number);
void Autotune_bwd_postprocess__A7__F47(BwdPostprocessContext& params, int mod_number);

}


}

// vim: set fileencoding=utf-8

