/* s3 compat server functions auto-generated by pidl */
#include "bin/default/librpc/gen_ndr/ndr_fsrvp.h"
#include "bin/default/librpc/gen_ndr/ndr_fsrvp_scompat.h"
#include <librpc/rpc/dcesrv_core.h>
#include <rpc_server/rpc_config.h>
#include <rpc_server/rpc_server.h>
#include <util/debug.h>

enum s3compat_rpc_dispatch {
	S3COMPAT_RPC_DISPATCH_EXTERNAL = 0x00000001,
	S3COMPAT_RPC_DISPATCH_INTERNAL = 0x00000002,
};

/* FileServerVssAgent - dcerpc server boilerplate generated by pidl */
static NTSTATUS FileServerVssAgent__op_bind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_FILESERVERVSSAGENT_BIND
	return DCESRV_INTERFACE_FILESERVERVSSAGENT_BIND(context,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void FileServerVssAgent__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_FILESERVERVSSAGENT_UNBIND
	DCESRV_INTERFACE_FILESERVERVSSAGENT_UNBIND(context, iface);
#else
	return;
#endif
}

NTSTATUS FileServerVssAgent__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= ndr_table_FileServerVssAgent.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx, ndr_table_FileServerVssAgent.calls[opnum].struct_size, "struct %s", ndr_table_FileServerVssAgent.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

	/* unravel the NDR for the packet */
	ndr_err = ndr_table_FileServerVssAgent.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS FileServerVssAgent__op_dispatch_internal(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r, enum s3compat_rpc_dispatch dispatch)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;
	struct pipes_struct *p = NULL;
	NTSTATUS status = NT_STATUS_OK;
	bool impersonated = false;

	/* Retrieve pipes struct */
	p = dcesrv_get_pipes_struct(dce_call->conn);
	p->dce_call = dce_call;
	p->mem_ctx = mem_ctx;
	/* Reset pipes struct fault state */
	p->fault_state = 0;

	/* Impersonate */
	if (dispatch == S3COMPAT_RPC_DISPATCH_EXTERNAL) {
		impersonated = become_authenticated_pipe_user(dce_call->auth_state->session_info);
		if (!impersonated) {
			dce_call->fault_code = DCERPC_FAULT_ACCESS_DENIED;
			status = NT_STATUS_NET_WRITE_FAULT;
			goto fail;
		}
	}

	switch (opnum) {
	case 0: { /* fss_GetSupportedVersion */
		struct fss_GetSupportedVersion *r2 = (struct fss_GetSupportedVersion *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(fss_GetSupportedVersion, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.MinVersion = talloc_zero(r2, uint32_t);
		if (r2->out.MinVersion == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.MaxVersion = talloc_zero(r2, uint32_t);
		if (r2->out.MaxVersion == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _fss_GetSupportedVersion(p, r2);
		break;
	}
	case 1: { /* fss_SetContext */
		struct fss_SetContext *r2 = (struct fss_SetContext *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(fss_SetContext, NDR_IN, r2);
		}
		r2->out.result = _fss_SetContext(p, r2);
		break;
	}
	case 2: { /* fss_StartShadowCopySet */
		struct fss_StartShadowCopySet *r2 = (struct fss_StartShadowCopySet *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(fss_StartShadowCopySet, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pShadowCopySetId = talloc_zero(r2, struct GUID);
		if (r2->out.pShadowCopySetId == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _fss_StartShadowCopySet(p, r2);
		break;
	}
	case 3: { /* fss_AddToShadowCopySet */
		struct fss_AddToShadowCopySet *r2 = (struct fss_AddToShadowCopySet *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(fss_AddToShadowCopySet, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pShadowCopyId = talloc_zero(r2, struct GUID);
		if (r2->out.pShadowCopyId == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _fss_AddToShadowCopySet(p, r2);
		break;
	}
	case 4: { /* fss_CommitShadowCopySet */
		struct fss_CommitShadowCopySet *r2 = (struct fss_CommitShadowCopySet *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(fss_CommitShadowCopySet, NDR_IN, r2);
		}
		r2->out.result = _fss_CommitShadowCopySet(p, r2);
		break;
	}
	case 5: { /* fss_ExposeShadowCopySet */
		struct fss_ExposeShadowCopySet *r2 = (struct fss_ExposeShadowCopySet *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(fss_ExposeShadowCopySet, NDR_IN, r2);
		}
		r2->out.result = _fss_ExposeShadowCopySet(p, r2);
		break;
	}
	case 6: { /* fss_RecoveryCompleteShadowCopySet */
		struct fss_RecoveryCompleteShadowCopySet *r2 = (struct fss_RecoveryCompleteShadowCopySet *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(fss_RecoveryCompleteShadowCopySet, NDR_IN, r2);
		}
		r2->out.result = _fss_RecoveryCompleteShadowCopySet(p, r2);
		break;
	}
	case 7: { /* fss_AbortShadowCopySet */
		struct fss_AbortShadowCopySet *r2 = (struct fss_AbortShadowCopySet *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(fss_AbortShadowCopySet, NDR_IN, r2);
		}
		r2->out.result = _fss_AbortShadowCopySet(p, r2);
		break;
	}
	case 8: { /* fss_IsPathSupported */
		struct fss_IsPathSupported *r2 = (struct fss_IsPathSupported *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(fss_IsPathSupported, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.SupportedByThisProvider = talloc_zero(r2, uint32_t);
		if (r2->out.SupportedByThisProvider == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.OwnerMachineName = talloc_zero(r2, const char *);
		if (r2->out.OwnerMachineName == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _fss_IsPathSupported(p, r2);
		break;
	}
	case 9: { /* fss_IsPathShadowCopied */
		struct fss_IsPathShadowCopied *r2 = (struct fss_IsPathShadowCopied *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(fss_IsPathShadowCopied, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.ShadowCopyPresent = talloc_zero(r2, uint32_t);
		if (r2->out.ShadowCopyPresent == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.ShadowCopyCompatibility = talloc_zero(r2, int32_t);
		if (r2->out.ShadowCopyCompatibility == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _fss_IsPathShadowCopied(p, r2);
		break;
	}
	case 10: { /* fss_GetShareMapping */
		struct fss_GetShareMapping *r2 = (struct fss_GetShareMapping *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(fss_GetShareMapping, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.ShareMapping = talloc_zero(r2, union fssagent_share_mapping);
		if (r2->out.ShareMapping == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _fss_GetShareMapping(p, r2);
		break;
	}
	case 11: { /* fss_DeleteShareMapping */
		struct fss_DeleteShareMapping *r2 = (struct fss_DeleteShareMapping *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(fss_DeleteShareMapping, NDR_IN, r2);
		}
		r2->out.result = _fss_DeleteShareMapping(p, r2);
		break;
	}
	case 12: { /* fss_PrepareShadowCopySet */
		struct fss_PrepareShadowCopySet *r2 = (struct fss_PrepareShadowCopySet *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(fss_PrepareShadowCopySet, NDR_IN, r2);
		}
		r2->out.result = _fss_PrepareShadowCopySet(p, r2);
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

fail:
	/* Unimpersonate */
	if (impersonated) {
		unbecome_authenticated_pipe_user();
	}

	p->dce_call = NULL;
	p->mem_ctx = NULL;
	/* Check pipes struct fault state */
	if (p->fault_state != 0) {
		dce_call->fault_code = p->fault_state;
	}
	if (dce_call->fault_code != 0) {
		status = NT_STATUS_NET_WRITE_FAULT;
	}

	return status;
}

NTSTATUS FileServerVssAgent__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return FileServerVssAgent__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_EXTERNAL);
}

NTSTATUS FileServerVssAgent__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: { /* fss_GetSupportedVersion */
		struct fss_GetSupportedVersion *r2 = (struct fss_GetSupportedVersion *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function fss_GetSupportedVersion replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(fss_GetSupportedVersion, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in fss_GetSupportedVersion\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 1: { /* fss_SetContext */
		struct fss_SetContext *r2 = (struct fss_SetContext *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function fss_SetContext replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(fss_SetContext, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in fss_SetContext\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 2: { /* fss_StartShadowCopySet */
		struct fss_StartShadowCopySet *r2 = (struct fss_StartShadowCopySet *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function fss_StartShadowCopySet replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(fss_StartShadowCopySet, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in fss_StartShadowCopySet\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 3: { /* fss_AddToShadowCopySet */
		struct fss_AddToShadowCopySet *r2 = (struct fss_AddToShadowCopySet *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function fss_AddToShadowCopySet replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(fss_AddToShadowCopySet, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in fss_AddToShadowCopySet\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 4: { /* fss_CommitShadowCopySet */
		struct fss_CommitShadowCopySet *r2 = (struct fss_CommitShadowCopySet *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function fss_CommitShadowCopySet replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(fss_CommitShadowCopySet, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in fss_CommitShadowCopySet\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 5: { /* fss_ExposeShadowCopySet */
		struct fss_ExposeShadowCopySet *r2 = (struct fss_ExposeShadowCopySet *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function fss_ExposeShadowCopySet replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(fss_ExposeShadowCopySet, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in fss_ExposeShadowCopySet\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 6: { /* fss_RecoveryCompleteShadowCopySet */
		struct fss_RecoveryCompleteShadowCopySet *r2 = (struct fss_RecoveryCompleteShadowCopySet *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function fss_RecoveryCompleteShadowCopySet replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(fss_RecoveryCompleteShadowCopySet, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in fss_RecoveryCompleteShadowCopySet\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 7: { /* fss_AbortShadowCopySet */
		struct fss_AbortShadowCopySet *r2 = (struct fss_AbortShadowCopySet *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function fss_AbortShadowCopySet replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(fss_AbortShadowCopySet, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in fss_AbortShadowCopySet\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 8: { /* fss_IsPathSupported */
		struct fss_IsPathSupported *r2 = (struct fss_IsPathSupported *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function fss_IsPathSupported replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(fss_IsPathSupported, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in fss_IsPathSupported\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 9: { /* fss_IsPathShadowCopied */
		struct fss_IsPathShadowCopied *r2 = (struct fss_IsPathShadowCopied *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function fss_IsPathShadowCopied replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(fss_IsPathShadowCopied, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in fss_IsPathShadowCopied\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 10: { /* fss_GetShareMapping */
		struct fss_GetShareMapping *r2 = (struct fss_GetShareMapping *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function fss_GetShareMapping replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(fss_GetShareMapping, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in fss_GetShareMapping\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 11: { /* fss_DeleteShareMapping */
		struct fss_DeleteShareMapping *r2 = (struct fss_DeleteShareMapping *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function fss_DeleteShareMapping replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(fss_DeleteShareMapping, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in fss_DeleteShareMapping\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 12: { /* fss_PrepareShadowCopySet */
		struct fss_PrepareShadowCopySet *r2 = (struct fss_PrepareShadowCopySet *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function fss_PrepareShadowCopySet replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(fss_PrepareShadowCopySet, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in fss_PrepareShadowCopySet\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS FileServerVssAgent__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	ndr_err = ndr_table_FileServerVssAgent.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS FileServerVssAgent__op_local(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return FileServerVssAgent__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_INTERNAL);
}

static const struct dcesrv_interface dcesrv_FileServerVssAgent_interface = {
	.name      = "FileServerVssAgent",
	.syntax_id = {{0xa8e0653c,0x2744,0x4389,{0xa6,0x1d},{0x73,0x73,0xdf,0x8b,0x22,0x92}},1.0},
	.bind      = FileServerVssAgent__op_bind,
	.unbind    = FileServerVssAgent__op_unbind,
	.ndr_pull  = FileServerVssAgent__op_ndr_pull,
	.dispatch  = FileServerVssAgent__op_dispatch,
	.reply     = FileServerVssAgent__op_reply,
	.ndr_push  = FileServerVssAgent__op_ndr_push,
	.local     = FileServerVssAgent__op_local,
#ifdef DCESRV_INTERFACE_FILESERVERVSSAGENT_FLAGS
	.flags     = DCESRV_INTERFACE_FILESERVERVSSAGENT_FLAGS
#else
	.flags     = 0
#endif
};

static NTSTATUS FileServerVssAgent__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	uint32_t i;
	NTSTATUS ret;

#ifdef DCESRV_INTERFACE_FILESERVERVSSAGENT_NCACN_NP_SECONDARY_ENDPOINT
	const char *ncacn_np_secondary_endpoint = DCESRV_INTERFACE_FILESERVERVSSAGENT_NCACN_NP_SECONDARY_ENDPOINT;
#else
	const char *ncacn_np_secondary_endpoint = NULL;
#endif

	for (i=0;i<ndr_table_FileServerVssAgent.endpoints->count;i++) {
		const char *name = ndr_table_FileServerVssAgent.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, ncacn_np_secondary_endpoint, &dcesrv_FileServerVssAgent_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DBG_ERR("Failed to register endpoint '%s'\n",name);
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static NTSTATUS FileServerVssAgent__op_shutdown_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	return NT_STATUS_OK;
}

static bool FileServerVssAgent__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_FileServerVssAgent_interface.syntax_id.if_version == if_version && GUID_equal(&dcesrv_FileServerVssAgent_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_FileServerVssAgent_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool FileServerVssAgent__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_FileServerVssAgent_interface.name, name)==0) {
		memcpy(iface, &dcesrv_FileServerVssAgent_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static const struct dcesrv_endpoint_server FileServerVssAgent_ep_server = {
	/* fill in our name */
	.name = "FileServerVssAgent",

	/* Initialization flag */
	.initialized = false,

	/* fill in all the operations */
#ifdef DCESRV_INTERFACE_FILESERVERVSSAGENT_INIT_SERVER
	.init_server = DCESRV_INTERFACE_FILESERVERVSSAGENT_INIT_SERVER,
#else
	.init_server = FileServerVssAgent__op_init_server,
#endif
#ifdef DCESRV_INTERFACE_FILESERVERVSSAGENT_SHUTDOWN_SERVER
	.shutdown_server = DCESRV_INTERFACE_FILESERVERVSSAGENT_SHUTDOWN_SERVER,
#else
	.shutdown_server = FileServerVssAgent__op_shutdown_server,
#endif
	.interface_by_uuid = FileServerVssAgent__op_interface_by_uuid,
	.interface_by_name = FileServerVssAgent__op_interface_by_name
};

const struct dcesrv_endpoint_server *FileServerVssAgent_get_ep_server(void)
{
	return &FileServerVssAgent_ep_server;
}
