/* Plugins.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Plugins.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>
#include <gio/gio.h>
#include <gmodule.h>
#include "shotwell-plugin-dev-1.0.h"
#include <gee.h>

#define PLUGINS_MIN_SPIT_INTERFACE 0
#define PLUGINS_MAX_SPIT_INTERFACE 0
#define UTIL_FILE_ATTRIBUTES "standard::*,time::*,id::file,id::filesystem,etag::value"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PLUGINS_TYPE_EXTENSION_POINT (plugins_extension_point_get_type ())
#define PLUGINS_EXTENSION_POINT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PLUGINS_TYPE_EXTENSION_POINT, PluginsExtensionPoint))
#define PLUGINS_EXTENSION_POINT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PLUGINS_TYPE_EXTENSION_POINT, PluginsExtensionPointClass))
#define PLUGINS_IS_EXTENSION_POINT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PLUGINS_TYPE_EXTENSION_POINT))
#define PLUGINS_IS_EXTENSION_POINT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PLUGINS_TYPE_EXTENSION_POINT))
#define PLUGINS_EXTENSION_POINT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PLUGINS_TYPE_EXTENSION_POINT, PluginsExtensionPointClass))

typedef struct _PluginsExtensionPoint PluginsExtensionPoint;
typedef struct _PluginsExtensionPointClass PluginsExtensionPointClass;
typedef struct _PluginsExtensionPointPrivate PluginsExtensionPointPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _PluginsParamSpecExtensionPoint PluginsParamSpecExtensionPoint;

#define PLUGINS_TYPE_MODULE_REP (plugins_module_rep_get_type ())
#define PLUGINS_MODULE_REP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PLUGINS_TYPE_MODULE_REP, PluginsModuleRep))
#define PLUGINS_MODULE_REP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PLUGINS_TYPE_MODULE_REP, PluginsModuleRepClass))
#define PLUGINS_IS_MODULE_REP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PLUGINS_TYPE_MODULE_REP))
#define PLUGINS_IS_MODULE_REP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PLUGINS_TYPE_MODULE_REP))
#define PLUGINS_MODULE_REP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PLUGINS_TYPE_MODULE_REP, PluginsModuleRepClass))

typedef struct _PluginsModuleRep PluginsModuleRep;
typedef struct _PluginsModuleRepClass PluginsModuleRepClass;
typedef struct _PluginsModuleRepPrivate PluginsModuleRepPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_module_close0(var) ((var == NULL) ? NULL : (var = (g_module_close (var), NULL)))
#define _plugins_module_rep_unref0(var) ((var == NULL) ? NULL : (var = (plugins_module_rep_unref (var), NULL)))
typedef struct _PluginsParamSpecModuleRep PluginsParamSpecModuleRep;

#define PLUGINS_TYPE_PLUGGABLE_REP (plugins_pluggable_rep_get_type ())
#define PLUGINS_PLUGGABLE_REP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PLUGINS_TYPE_PLUGGABLE_REP, PluginsPluggableRep))
#define PLUGINS_PLUGGABLE_REP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PLUGINS_TYPE_PLUGGABLE_REP, PluginsPluggableRepClass))
#define PLUGINS_IS_PLUGGABLE_REP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PLUGINS_TYPE_PLUGGABLE_REP))
#define PLUGINS_IS_PLUGGABLE_REP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PLUGINS_TYPE_PLUGGABLE_REP))
#define PLUGINS_PLUGGABLE_REP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PLUGINS_TYPE_PLUGGABLE_REP, PluginsPluggableRepClass))

typedef struct _PluginsPluggableRep PluginsPluggableRep;
typedef struct _PluginsPluggableRepClass PluginsPluggableRepClass;
typedef struct _PluginsPluggableRepPrivate PluginsPluggableRepPrivate;
typedef enum  {
	FUZZY_PROPERTY_STATE_ENABLED,
	FUZZY_PROPERTY_STATE_DISABLED,
	FUZZY_PROPERTY_STATE_UNKNOWN
} FuzzyPropertyState;

#define TYPE_FUZZY_PROPERTY_STATE (fuzzy_property_state_get_type ())

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;
typedef struct _PluginsParamSpecPluggableRep PluginsParamSpecPluggableRep;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define PLUGINS_TYPE_NOTIFIER (plugins_notifier_get_type ())
#define PLUGINS_NOTIFIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PLUGINS_TYPE_NOTIFIER, PluginsNotifier))
#define PLUGINS_NOTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PLUGINS_TYPE_NOTIFIER, PluginsNotifierClass))
#define PLUGINS_IS_NOTIFIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PLUGINS_TYPE_NOTIFIER))
#define PLUGINS_IS_NOTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PLUGINS_TYPE_NOTIFIER))
#define PLUGINS_NOTIFIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PLUGINS_TYPE_NOTIFIER, PluginsNotifierClass))

typedef struct _PluginsNotifier PluginsNotifier;
typedef struct _PluginsNotifierClass PluginsNotifierClass;
typedef struct _PluginsNotifierPrivate PluginsNotifierPrivate;
#define _plugins_notifier_unref0(var) ((var == NULL) ? NULL : (var = (plugins_notifier_unref (var), NULL)))
typedef struct _PluginsParamSpecNotifier PluginsParamSpecNotifier;
enum  {
	PLUGINS_NOTIFIER_PLUGGABLE_ACTIVATION_SIGNAL,
	PLUGINS_NOTIFIER_NUM_SIGNALS
};
static guint plugins_notifier_signals[PLUGINS_NOTIFIER_NUM_SIGNALS] = {0};
#define _plugins_extension_point_unref0(var) ((var == NULL) ? NULL : (var = (plugins_extension_point_unref (var), NULL)))
#define _plugins_pluggable_rep_unref0(var) ((var == NULL) ? NULL : (var = (plugins_pluggable_rep_unref (var), NULL)))
typedef enum  {
	PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL = 1 << 0,
	PREPARE_INPUT_TEXT_OPTIONS_VALIDATE = 1 << 1,
	PREPARE_INPUT_TEXT_OPTIONS_INVALID_IS_NULL = 1 << 2,
	PREPARE_INPUT_TEXT_OPTIONS_STRIP = 1 << 3,
	PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF = 1 << 4,
	PREPARE_INPUT_TEXT_OPTIONS_NORMALIZE = 1 << 5,
	PREPARE_INPUT_TEXT_OPTIONS_DEFAULT = ((((PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL | PREPARE_INPUT_TEXT_OPTIONS_VALIDATE) | PREPARE_INPUT_TEXT_OPTIONS_INVALID_IS_NULL) | PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF) | PREPARE_INPUT_TEXT_OPTIONS_STRIP) | PREPARE_INPUT_TEXT_OPTIONS_NORMALIZE
} PrepareInputTextOptions;

#define TYPE_PREPARE_INPUT_TEXT_OPTIONS (prepare_input_text_options_get_type ())
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PluginsExtensionPoint {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PluginsExtensionPointPrivate * priv;
};

struct _PluginsExtensionPointClass {
	GTypeClass parent_class;
	void (*finalize) (PluginsExtensionPoint *self);
};

struct _PluginsExtensionPointPrivate {
	GType _pluggable_type;
	gchar* _name;
	gchar* _icon_name;
	gchar** _core_ids;
	gint _core_ids_length1;
	gint __core_ids_size_;
};

struct _PluginsParamSpecExtensionPoint {
	GParamSpec parent_instance;
};

struct _PluginsModuleRep {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PluginsModuleRepPrivate * priv;
	GFile* file;
	GModule* module;
	SpitModule* spit_module;
	gint spit_interface;
	gchar* id;
};

struct _PluginsModuleRepClass {
	GTypeClass parent_class;
	void (*finalize) (PluginsModuleRep *self);
};

struct _PluginsParamSpecModuleRep {
	GParamSpec parent_instance;
};

struct _PluginsPluggableRep {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PluginsPluggableRepPrivate * priv;
};

struct _PluginsPluggableRepClass {
	GTypeClass parent_class;
	void (*finalize) (PluginsPluggableRep *self);
};

struct _PluginsPluggableRepPrivate {
	SpitPluggable* _pluggable;
	gchar* _id;
	gboolean _is_core;
	gboolean _activated;
	gboolean enabled;
};

struct _PluginsParamSpecPluggableRep {
	GParamSpec parent_instance;
};

struct _PluginsNotifier {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PluginsNotifierPrivate * priv;
};

struct _PluginsNotifierClass {
	GTypeClass parent_class;
	void (*finalize) (PluginsNotifier *self);
};

struct _PluginsParamSpecNotifier {
	GParamSpec parent_instance;
};

static gint PluginsExtensionPoint_private_offset;
static gpointer plugins_extension_point_parent_class = NULL;
static gpointer plugins_module_rep_parent_class = NULL;
static gint PluginsPluggableRep_private_offset;
static gpointer plugins_pluggable_rep_parent_class = NULL;
VALA_EXTERN GFile** plugins_search_dirs;
VALA_EXTERN gint plugins_search_dirs_length1;
GFile** plugins_search_dirs = NULL;
gint plugins_search_dirs_length1 = 0;
static gint _plugins_search_dirs_size_ = 0;
VALA_EXTERN GeeHashMap* plugins_module_table;
GeeHashMap* plugins_module_table = NULL;
VALA_EXTERN GeeHashMap* plugins_pluggable_table;
GeeHashMap* plugins_pluggable_table = NULL;
VALA_EXTERN GeeHashMap* plugins_extension_points;
GeeHashMap* plugins_extension_points = NULL;
VALA_EXTERN GeeHashSet* plugins_core_ids;
GeeHashSet* plugins_core_ids = NULL;
static gpointer plugins_notifier_parent_class = NULL;
static PluginsNotifier* plugins_notifier_instance;
static PluginsNotifier* plugins_notifier_instance = NULL;

VALA_EXTERN gpointer plugins_extension_point_ref (gpointer instance);
VALA_EXTERN void plugins_extension_point_unref (gpointer instance);
VALA_EXTERN GParamSpec* plugins_param_spec_extension_point (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
VALA_EXTERN void plugins_value_set_extension_point (GValue* value,
                                        gpointer v_object);
VALA_EXTERN void plugins_value_take_extension_point (GValue* value,
                                         gpointer v_object);
VALA_EXTERN gpointer plugins_value_get_extension_point (const GValue* value);
VALA_EXTERN GType plugins_extension_point_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PluginsExtensionPoint, plugins_extension_point_unref)
VALA_EXTERN PluginsExtensionPoint* plugins_extension_point_new (GType pluggable_type,
                                                    const gchar* name,
                                                    const gchar* icon_name,
                                                    gchar** core_ids,
                                                    gint core_ids_length1);
VALA_EXTERN PluginsExtensionPoint* plugins_extension_point_construct (GType object_type,
                                                          GType pluggable_type,
                                                          const gchar* name,
                                                          const gchar* icon_name,
                                                          gchar** core_ids,
                                                          gint core_ids_length1);
static void plugins_extension_point_set_pluggable_type (PluginsExtensionPoint* self,
                                                 GType value);
static void plugins_extension_point_set_name (PluginsExtensionPoint* self,
                                       const gchar* value);
static void plugins_extension_point_set_icon_name (PluginsExtensionPoint* self,
                                            const gchar* value);
static void plugins_extension_point_set_core_ids (PluginsExtensionPoint* self,
                                           gchar** value,
                                           gint value_length1);
VALA_EXTERN GType plugins_extension_point_get_pluggable_type (PluginsExtensionPoint* self);
VALA_EXTERN const gchar* plugins_extension_point_get_name (PluginsExtensionPoint* self);
VALA_EXTERN const gchar* plugins_extension_point_get_icon_name (PluginsExtensionPoint* self);
VALA_EXTERN gchar** plugins_extension_point_get_core_ids (PluginsExtensionPoint* self,
                                              gint* result_length1);
static gchar** _vala_array_dup27 (gchar** self,
                           gssize length);
static void plugins_extension_point_finalize (PluginsExtensionPoint * obj);
static GType plugins_extension_point_get_type_once (void);
VALA_EXTERN gpointer plugins_module_rep_ref (gpointer instance);
VALA_EXTERN void plugins_module_rep_unref (gpointer instance);
VALA_EXTERN GParamSpec* plugins_param_spec_module_rep (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void plugins_value_set_module_rep (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void plugins_value_take_module_rep (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer plugins_value_get_module_rep (const GValue* value);
VALA_EXTERN GType plugins_module_rep_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PluginsModuleRep, plugins_module_rep_unref)
static PluginsModuleRep* plugins_module_rep_new (GFile* file);
static PluginsModuleRep* plugins_module_rep_construct (GType object_type,
                                                GFile* file);
VALA_EXTERN PluginsModuleRep* plugins_module_rep_open (GFile* file);
static void plugins_module_rep_finalize (PluginsModuleRep * obj);
static GType plugins_module_rep_get_type_once (void);
VALA_EXTERN gpointer plugins_pluggable_rep_ref (gpointer instance);
VALA_EXTERN void plugins_pluggable_rep_unref (gpointer instance);
VALA_EXTERN GParamSpec* plugins_param_spec_pluggable_rep (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
VALA_EXTERN void plugins_value_set_pluggable_rep (GValue* value,
                                      gpointer v_object);
VALA_EXTERN void plugins_value_take_pluggable_rep (GValue* value,
                                       gpointer v_object);
VALA_EXTERN gpointer plugins_value_get_pluggable_rep (const GValue* value);
VALA_EXTERN GType plugins_pluggable_rep_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PluginsPluggableRep, plugins_pluggable_rep_unref)
VALA_EXTERN PluginsPluggableRep* plugins_pluggable_rep_new (SpitPluggable* pluggable);
VALA_EXTERN PluginsPluggableRep* plugins_pluggable_rep_construct (GType object_type,
                                                      SpitPluggable* pluggable);
static void plugins_pluggable_rep_set_pluggable (PluginsPluggableRep* self,
                                          SpitPluggable* value);
static void plugins_pluggable_rep_set_id (PluginsPluggableRep* self,
                                   const gchar* value);
VALA_EXTERN void plugins_pluggable_rep_activate (PluginsPluggableRep* self);
VALA_EXTERN gboolean plugins_is_core_pluggable (SpitPluggable* pluggable);
VALA_EXTERN SpitPluggable* plugins_pluggable_rep_get_pluggable (PluginsPluggableRep* self);
static void plugins_pluggable_rep_set_is_core (PluginsPluggableRep* self,
                                        gboolean value);
VALA_EXTERN GType fuzzy_property_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType configuration_facade_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigurationFacade, g_object_unref)
VALA_EXTERN GType config_facade_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigFacade, g_object_unref)
VALA_EXTERN ConfigFacade* config_facade_get_instance (void);
VALA_EXTERN FuzzyPropertyState configuration_facade_is_plugin_enabled (ConfigurationFacade* self,
                                                           const gchar* id);
VALA_EXTERN const gchar* plugins_pluggable_rep_get_id (PluginsPluggableRep* self);
VALA_EXTERN gboolean plugins_pluggable_rep_get_is_core (PluginsPluggableRep* self);
static void plugins_pluggable_rep_set_activated (PluginsPluggableRep* self,
                                          gboolean value);
VALA_EXTERN gboolean plugins_pluggable_rep_is_enabled (PluginsPluggableRep* self);
VALA_EXTERN gboolean plugins_pluggable_rep_set_enabled (PluginsPluggableRep* self,
                                            gboolean enabled);
VALA_EXTERN void configuration_facade_set_plugin_enabled (ConfigurationFacade* self,
                                              const gchar* id,
                                              gboolean enabled);
VALA_EXTERN gboolean plugins_pluggable_rep_get_activated (PluginsPluggableRep* self);
static void plugins_pluggable_rep_finalize (PluginsPluggableRep * obj);
static GType plugins_pluggable_rep_get_type_once (void);
VALA_EXTERN void plugins_init (GError** error);
static void _vala_array_add49 (GFile** * array,
                        gint* length,
                        gint* size,
                        GFile* value);
VALA_EXTERN GFile* app_dirs_get_user_plugins_dir (void);
static void _vala_array_add50 (GFile** * array,
                        gint* length,
                        gint* size,
                        GFile* value);
VALA_EXTERN GFile* app_dirs_get_system_plugins_dir (void);
static void _vala_array_add51 (GFile** * array,
                        gint* length,
                        gint* size,
                        GFile* value);
VALA_EXTERN void plugins_search_for_plugins (GFile* dir,
                                 GError** error);
VALA_EXTERN void plugins_terminate (void);
VALA_EXTERN gpointer plugins_notifier_ref (gpointer instance);
VALA_EXTERN void plugins_notifier_unref (gpointer instance);
VALA_EXTERN GParamSpec* plugins_param_spec_notifier (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void plugins_value_set_notifier (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void plugins_value_take_notifier (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer plugins_value_get_notifier (const GValue* value);
VALA_EXTERN GType plugins_notifier_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PluginsNotifier, plugins_notifier_unref)
static PluginsNotifier* plugins_notifier_new (void);
static PluginsNotifier* plugins_notifier_construct (GType object_type);
VALA_EXTERN PluginsNotifier* plugins_notifier_get_instance (void);
static void g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static void plugins_notifier_finalize (PluginsNotifier * obj);
static GType plugins_notifier_get_type_once (void);
VALA_EXTERN void plugins_register_extension_point (GType type,
                                       const gchar* name,
                                       const gchar* icon_name,
                                       gchar** core_ids,
                                       gint core_ids_length1);
VALA_EXTERN GeeCollection* plugins_get_pluggables (gboolean include_disabled);
VALA_EXTERN PluginsModuleRep* plugins_get_module_for_pluggable (SpitPluggable* needle);
static SpitPluggable** _vala_array_dup28 (SpitPluggable** self,
                                   gssize length);
VALA_EXTERN gchar* plugins_get_pluggable_module_id (SpitPluggable* needle);
VALA_EXTERN GeeCollection* plugins_get_extension_points (GCompareDataFunc compare_func,
                                             gpointer compare_func_target,
                                             GDestroyNotify compare_func_target_destroy_notify);
VALA_EXTERN GeeCollection* plugins_get_pluggables_for_type (GType type,
                                                GCompareDataFunc compare_func,
                                                gpointer compare_func_target,
                                                GDestroyNotify compare_func_target_destroy_notify,
                                                gboolean include_disabled);
VALA_EXTERN gchar* plugins_get_pluggable_name (const gchar* id);
VALA_EXTERN gboolean plugins_get_pluggable_info (const gchar* id,
                                     SpitPluggableInfo** info);
VALA_EXTERN gboolean plugins_get_pluggable_enabled (const gchar* id,
                                        gboolean* enabled);
VALA_EXTERN void plugins_set_pluggable_enabled (const gchar* id,
                                    gboolean enabled);
VALA_EXTERN GFile* plugins_get_pluggable_module_file (SpitPluggable* pluggable);
VALA_EXTERN gint plugins_compare_pluggable_names (SpitPluggable* a,
                                      SpitPluggable* b);
VALA_EXTERN gint plugins_compare_extension_point_names (PluginsExtensionPoint* a,
                                            PluginsExtensionPoint* b);
VALA_EXTERN void plugins_load_module (GFile* file);
VALA_EXTERN GType prepare_input_text_options_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* prepare_input_text (const gchar* text,
                           PrepareInputTextOptions options,
                           gint dest_length);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
plugins_extension_point_get_instance_private (PluginsExtensionPoint* self)
{
	return G_STRUCT_MEMBER_P (self, PluginsExtensionPoint_private_offset);
}

PluginsExtensionPoint*
plugins_extension_point_construct (GType object_type,
                                   GType pluggable_type,
                                   const gchar* name,
                                   const gchar* icon_name,
                                   gchar** core_ids,
                                   gint core_ids_length1)
{
	PluginsExtensionPoint* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (PluginsExtensionPoint*) g_type_create_instance (object_type);
	plugins_extension_point_set_pluggable_type (self, pluggable_type);
	plugins_extension_point_set_name (self, name);
	plugins_extension_point_set_icon_name (self, icon_name);
	plugins_extension_point_set_core_ids (self, core_ids, core_ids_length1);
	return self;
}

PluginsExtensionPoint*
plugins_extension_point_new (GType pluggable_type,
                             const gchar* name,
                             const gchar* icon_name,
                             gchar** core_ids,
                             gint core_ids_length1)
{
	return plugins_extension_point_construct (PLUGINS_TYPE_EXTENSION_POINT, pluggable_type, name, icon_name, core_ids, core_ids_length1);
}

GType
plugins_extension_point_get_pluggable_type (PluginsExtensionPoint* self)
{
	GType result;
	g_return_val_if_fail (PLUGINS_IS_EXTENSION_POINT (self), 0UL);
	result = self->priv->_pluggable_type;
	return result;
}

static void
plugins_extension_point_set_pluggable_type (PluginsExtensionPoint* self,
                                            GType value)
{
	g_return_if_fail (PLUGINS_IS_EXTENSION_POINT (self));
	self->priv->_pluggable_type = value;
}

const gchar*
plugins_extension_point_get_name (PluginsExtensionPoint* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (PLUGINS_IS_EXTENSION_POINT (self), NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
plugins_extension_point_set_name (PluginsExtensionPoint* self,
                                  const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (PLUGINS_IS_EXTENSION_POINT (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp0_;
}

const gchar*
plugins_extension_point_get_icon_name (PluginsExtensionPoint* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (PLUGINS_IS_EXTENSION_POINT (self), NULL);
	_tmp0_ = self->priv->_icon_name;
	result = _tmp0_;
	return result;
}

static void
plugins_extension_point_set_icon_name (PluginsExtensionPoint* self,
                                       const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (PLUGINS_IS_EXTENSION_POINT (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_icon_name);
	self->priv->_icon_name = _tmp0_;
}

gchar**
plugins_extension_point_get_core_ids (PluginsExtensionPoint* self,
                                      gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (PLUGINS_IS_EXTENSION_POINT (self), NULL);
	_tmp0_ = self->priv->_core_ids;
	_tmp0__length1 = self->priv->_core_ids_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup27 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
plugins_extension_point_set_core_ids (PluginsExtensionPoint* self,
                                      gchar** value,
                                      gint value_length1)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (PLUGINS_IS_EXTENSION_POINT (self));
	_tmp0_ = (value != NULL) ? _vala_array_dup27 (value, value_length1) : value;
	_tmp0__length1 = value_length1;
	self->priv->_core_ids = (_vala_array_free (self->priv->_core_ids, self->priv->_core_ids_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_core_ids = _tmp0_;
	self->priv->_core_ids_length1 = _tmp0__length1;
	self->priv->__core_ids_size_ = self->priv->_core_ids_length1;
}

static void
plugins_value_extension_point_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
plugins_value_extension_point_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		plugins_extension_point_unref (value->data[0].v_pointer);
	}
}

static void
plugins_value_extension_point_copy_value (const GValue* src_value,
                                          GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = plugins_extension_point_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
plugins_value_extension_point_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
plugins_value_extension_point_collect_value (GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PluginsExtensionPoint * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = plugins_extension_point_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
plugins_value_extension_point_lcopy_value (const GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	PluginsExtensionPoint ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = plugins_extension_point_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
plugins_param_spec_extension_point (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags)
{
	PluginsParamSpecExtensionPoint* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PLUGINS_TYPE_EXTENSION_POINT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
plugins_value_get_extension_point (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PLUGINS_TYPE_EXTENSION_POINT), NULL);
	return value->data[0].v_pointer;
}

void
plugins_value_set_extension_point (GValue* value,
                                   gpointer v_object)
{
	PluginsExtensionPoint * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PLUGINS_TYPE_EXTENSION_POINT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PLUGINS_TYPE_EXTENSION_POINT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		plugins_extension_point_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		plugins_extension_point_unref (old);
	}
}

void
plugins_value_take_extension_point (GValue* value,
                                    gpointer v_object)
{
	PluginsExtensionPoint * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PLUGINS_TYPE_EXTENSION_POINT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PLUGINS_TYPE_EXTENSION_POINT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		plugins_extension_point_unref (old);
	}
}

static void
plugins_extension_point_class_init (PluginsExtensionPointClass * klass,
                                    gpointer klass_data)
{
	plugins_extension_point_parent_class = g_type_class_peek_parent (klass);
	((PluginsExtensionPointClass *) klass)->finalize = plugins_extension_point_finalize;
	g_type_class_adjust_private_offset (klass, &PluginsExtensionPoint_private_offset);
}

static void
plugins_extension_point_instance_init (PluginsExtensionPoint * self,
                                       gpointer klass)
{
	self->priv = plugins_extension_point_get_instance_private (self);
	self->ref_count = 1;
}

static void
plugins_extension_point_finalize (PluginsExtensionPoint * obj)
{
	PluginsExtensionPoint * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLUGINS_TYPE_EXTENSION_POINT, PluginsExtensionPoint);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_icon_name);
	self->priv->_core_ids = (_vala_array_free (self->priv->_core_ids, self->priv->_core_ids_length1, (GDestroyNotify) g_free), NULL);
}

static GType
plugins_extension_point_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { plugins_value_extension_point_init, plugins_value_extension_point_free_value, plugins_value_extension_point_copy_value, plugins_value_extension_point_peek_pointer, "p", plugins_value_extension_point_collect_value, "p", plugins_value_extension_point_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PluginsExtensionPointClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plugins_extension_point_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PluginsExtensionPoint), 0, (GInstanceInitFunc) plugins_extension_point_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType plugins_extension_point_type_id;
	plugins_extension_point_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PluginsExtensionPoint", &g_define_type_info, &g_define_type_fundamental_info, 0);
	PluginsExtensionPoint_private_offset = g_type_add_instance_private (plugins_extension_point_type_id, sizeof (PluginsExtensionPointPrivate));
	return plugins_extension_point_type_id;
}

GType
plugins_extension_point_get_type (void)
{
	static volatile gsize plugins_extension_point_type_id__once = 0;
	if (g_once_init_enter (&plugins_extension_point_type_id__once)) {
		GType plugins_extension_point_type_id;
		plugins_extension_point_type_id = plugins_extension_point_get_type_once ();
		g_once_init_leave (&plugins_extension_point_type_id__once, plugins_extension_point_type_id);
	}
	return plugins_extension_point_type_id__once;
}

gpointer
plugins_extension_point_ref (gpointer instance)
{
	PluginsExtensionPoint * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
plugins_extension_point_unref (gpointer instance)
{
	PluginsExtensionPoint * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PLUGINS_EXTENSION_POINT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static PluginsModuleRep*
plugins_module_rep_construct (GType object_type,
                              GFile* file)
{
	PluginsModuleRep* self = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GModule* _tmp3_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	self = (PluginsModuleRep*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->file);
	self->file = _tmp0_;
	_tmp1_ = g_file_get_path (file);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_module_open (_tmp2_, G_MODULE_BIND_LAZY);
	_g_module_close0 (self->module);
	self->module = _tmp3_;
	_g_free0 (_tmp2_);
	return self;
}

static PluginsModuleRep*
plugins_module_rep_new (GFile* file)
{
	return plugins_module_rep_construct (PLUGINS_TYPE_MODULE_REP, file);
}

static gpointer
_plugins_module_rep_ref0 (gpointer self)
{
	return self ? plugins_module_rep_ref (self) : NULL;
}

PluginsModuleRep*
plugins_module_rep_open (GFile* file)
{
	PluginsModuleRep* module_rep = NULL;
	PluginsModuleRep* _tmp0_;
	PluginsModuleRep* _tmp1_ = NULL;
	PluginsModuleRep* _tmp2_;
	GModule* _tmp3_;
	PluginsModuleRep* _tmp5_;
	PluginsModuleRep* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	_tmp0_ = plugins_module_rep_new (file);
	module_rep = _tmp0_;
	_tmp2_ = module_rep;
	_tmp3_ = _tmp2_->module;
	if (_tmp3_ != NULL) {
		PluginsModuleRep* _tmp4_;
		_tmp4_ = module_rep;
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = NULL;
	}
	_tmp5_ = _plugins_module_rep_ref0 (_tmp1_);
	result = _tmp5_;
	_plugins_module_rep_unref0 (module_rep);
	return result;
}

static void
plugins_value_module_rep_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
plugins_value_module_rep_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		plugins_module_rep_unref (value->data[0].v_pointer);
	}
}

static void
plugins_value_module_rep_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = plugins_module_rep_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
plugins_value_module_rep_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
plugins_value_module_rep_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PluginsModuleRep * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = plugins_module_rep_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
plugins_value_module_rep_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	PluginsModuleRep ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = plugins_module_rep_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
plugins_param_spec_module_rep (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	PluginsParamSpecModuleRep* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PLUGINS_TYPE_MODULE_REP), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
plugins_value_get_module_rep (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PLUGINS_TYPE_MODULE_REP), NULL);
	return value->data[0].v_pointer;
}

void
plugins_value_set_module_rep (GValue* value,
                              gpointer v_object)
{
	PluginsModuleRep * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PLUGINS_TYPE_MODULE_REP));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PLUGINS_TYPE_MODULE_REP));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		plugins_module_rep_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		plugins_module_rep_unref (old);
	}
}

void
plugins_value_take_module_rep (GValue* value,
                               gpointer v_object)
{
	PluginsModuleRep * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PLUGINS_TYPE_MODULE_REP));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PLUGINS_TYPE_MODULE_REP));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		plugins_module_rep_unref (old);
	}
}

static void
plugins_module_rep_class_init (PluginsModuleRepClass * klass,
                               gpointer klass_data)
{
	plugins_module_rep_parent_class = g_type_class_peek_parent (klass);
	((PluginsModuleRepClass *) klass)->finalize = plugins_module_rep_finalize;
}

static void
plugins_module_rep_instance_init (PluginsModuleRep * self,
                                  gpointer klass)
{
	self->spit_module = NULL;
	self->spit_interface = SPIT_UNSUPPORTED_INTERFACE;
	self->id = NULL;
	self->ref_count = 1;
}

static void
plugins_module_rep_finalize (PluginsModuleRep * obj)
{
	PluginsModuleRep * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLUGINS_TYPE_MODULE_REP, PluginsModuleRep);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->spit_module);
	self->spit_module = NULL;
	_g_object_unref0 (self->file);
	_g_module_close0 (self->module);
	_g_object_unref0 (self->spit_module);
	_g_free0 (self->id);
}

static GType
plugins_module_rep_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { plugins_value_module_rep_init, plugins_value_module_rep_free_value, plugins_value_module_rep_copy_value, plugins_value_module_rep_peek_pointer, "p", plugins_value_module_rep_collect_value, "p", plugins_value_module_rep_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PluginsModuleRepClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plugins_module_rep_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PluginsModuleRep), 0, (GInstanceInitFunc) plugins_module_rep_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType plugins_module_rep_type_id;
	plugins_module_rep_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PluginsModuleRep", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return plugins_module_rep_type_id;
}

GType
plugins_module_rep_get_type (void)
{
	static volatile gsize plugins_module_rep_type_id__once = 0;
	if (g_once_init_enter (&plugins_module_rep_type_id__once)) {
		GType plugins_module_rep_type_id;
		plugins_module_rep_type_id = plugins_module_rep_get_type_once ();
		g_once_init_leave (&plugins_module_rep_type_id__once, plugins_module_rep_type_id);
	}
	return plugins_module_rep_type_id__once;
}

gpointer
plugins_module_rep_ref (gpointer instance)
{
	PluginsModuleRep * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
plugins_module_rep_unref (gpointer instance)
{
	PluginsModuleRep * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PLUGINS_MODULE_REP_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
plugins_pluggable_rep_get_instance_private (PluginsPluggableRep* self)
{
	return G_STRUCT_MEMBER_P (self, PluginsPluggableRep_private_offset);
}

PluginsPluggableRep*
plugins_pluggable_rep_construct (GType object_type,
                                 SpitPluggable* pluggable)
{
	PluginsPluggableRep* self = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (pluggable, SPIT_TYPE_PLUGGABLE), NULL);
	self = (PluginsPluggableRep*) g_type_create_instance (object_type);
	plugins_pluggable_rep_set_pluggable (self, pluggable);
	_tmp0_ = spit_pluggable_get_id (pluggable);
	plugins_pluggable_rep_set_id (self, _tmp0_);
	return self;
}

PluginsPluggableRep*
plugins_pluggable_rep_new (SpitPluggable* pluggable)
{
	return plugins_pluggable_rep_construct (PLUGINS_TYPE_PLUGGABLE_REP, pluggable);
}

void
plugins_pluggable_rep_activate (PluginsPluggableRep* self)
{
	SpitPluggable* _tmp0_;
	FuzzyPropertyState saved_state = 0;
	ConfigFacade* _tmp1_;
	ConfigFacade* _tmp2_;
	const gchar* _tmp3_;
	FuzzyPropertyState _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_;
	SpitPluggable* _tmp10_;
	g_return_if_fail (PLUGINS_IS_PLUGGABLE_REP (self));
	_tmp0_ = self->priv->_pluggable;
	plugins_pluggable_rep_set_is_core (self, plugins_is_core_pluggable (_tmp0_));
	_tmp1_ = config_facade_get_instance ();
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_id;
	_tmp4_ = configuration_facade_is_plugin_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp3_);
	_g_object_unref0 (_tmp2_);
	saved_state = _tmp4_;
	_tmp7_ = self->priv->_is_core;
	if (_tmp7_) {
		_tmp6_ = saved_state != FUZZY_PROPERTY_STATE_DISABLED;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_;
		_tmp9_ = self->priv->_is_core;
		if (!_tmp9_) {
			_tmp8_ = saved_state == FUZZY_PROPERTY_STATE_ENABLED;
		} else {
			_tmp8_ = FALSE;
		}
		_tmp5_ = _tmp8_;
	}
	self->priv->enabled = _tmp5_;
	_tmp10_ = self->priv->_pluggable;
	spit_pluggable_activation (_tmp10_, self->priv->enabled);
	plugins_pluggable_rep_set_activated (self, TRUE);
}

gboolean
plugins_pluggable_rep_is_enabled (PluginsPluggableRep* self)
{
	gboolean result;
	g_return_val_if_fail (PLUGINS_IS_PLUGGABLE_REP (self), FALSE);
	result = self->priv->enabled;
	return result;
}

gboolean
plugins_pluggable_rep_set_enabled (PluginsPluggableRep* self,
                                   gboolean enabled)
{
	ConfigFacade* _tmp0_;
	ConfigFacade* _tmp1_;
	const gchar* _tmp2_;
	SpitPluggable* _tmp3_;
	gboolean result;
	g_return_val_if_fail (PLUGINS_IS_PLUGGABLE_REP (self), FALSE);
	if (enabled == self->priv->enabled) {
		result = FALSE;
		return result;
	}
	self->priv->enabled = enabled;
	_tmp0_ = config_facade_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_id;
	configuration_facade_set_plugin_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp2_, enabled);
	_g_object_unref0 (_tmp1_);
	_tmp3_ = self->priv->_pluggable;
	spit_pluggable_activation (_tmp3_, enabled);
	result = TRUE;
	return result;
}

SpitPluggable*
plugins_pluggable_rep_get_pluggable (PluginsPluggableRep* self)
{
	SpitPluggable* result;
	SpitPluggable* _tmp0_;
	g_return_val_if_fail (PLUGINS_IS_PLUGGABLE_REP (self), NULL);
	_tmp0_ = self->priv->_pluggable;
	result = _tmp0_;
	return result;
}

static void
plugins_pluggable_rep_set_pluggable (PluginsPluggableRep* self,
                                     SpitPluggable* value)
{
	SpitPluggable* _tmp0_;
	g_return_if_fail (PLUGINS_IS_PLUGGABLE_REP (self));
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_pluggable);
	self->priv->_pluggable = _tmp0_;
}

const gchar*
plugins_pluggable_rep_get_id (PluginsPluggableRep* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (PLUGINS_IS_PLUGGABLE_REP (self), NULL);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}

static void
plugins_pluggable_rep_set_id (PluginsPluggableRep* self,
                              const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (PLUGINS_IS_PLUGGABLE_REP (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_id);
	self->priv->_id = _tmp0_;
}

gboolean
plugins_pluggable_rep_get_is_core (PluginsPluggableRep* self)
{
	gboolean result;
	g_return_val_if_fail (PLUGINS_IS_PLUGGABLE_REP (self), FALSE);
	result = self->priv->_is_core;
	return result;
}

static void
plugins_pluggable_rep_set_is_core (PluginsPluggableRep* self,
                                   gboolean value)
{
	g_return_if_fail (PLUGINS_IS_PLUGGABLE_REP (self));
	self->priv->_is_core = value;
}

gboolean
plugins_pluggable_rep_get_activated (PluginsPluggableRep* self)
{
	gboolean result;
	g_return_val_if_fail (PLUGINS_IS_PLUGGABLE_REP (self), FALSE);
	result = self->priv->_activated;
	return result;
}

static void
plugins_pluggable_rep_set_activated (PluginsPluggableRep* self,
                                     gboolean value)
{
	g_return_if_fail (PLUGINS_IS_PLUGGABLE_REP (self));
	self->priv->_activated = value;
}

static void
plugins_value_pluggable_rep_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
plugins_value_pluggable_rep_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		plugins_pluggable_rep_unref (value->data[0].v_pointer);
	}
}

static void
plugins_value_pluggable_rep_copy_value (const GValue* src_value,
                                        GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = plugins_pluggable_rep_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
plugins_value_pluggable_rep_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
plugins_value_pluggable_rep_collect_value (GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PluginsPluggableRep * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = plugins_pluggable_rep_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
plugins_value_pluggable_rep_lcopy_value (const GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	PluginsPluggableRep ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = plugins_pluggable_rep_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
plugins_param_spec_pluggable_rep (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags)
{
	PluginsParamSpecPluggableRep* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PLUGINS_TYPE_PLUGGABLE_REP), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
plugins_value_get_pluggable_rep (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PLUGINS_TYPE_PLUGGABLE_REP), NULL);
	return value->data[0].v_pointer;
}

void
plugins_value_set_pluggable_rep (GValue* value,
                                 gpointer v_object)
{
	PluginsPluggableRep * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PLUGINS_TYPE_PLUGGABLE_REP));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PLUGINS_TYPE_PLUGGABLE_REP));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		plugins_pluggable_rep_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		plugins_pluggable_rep_unref (old);
	}
}

void
plugins_value_take_pluggable_rep (GValue* value,
                                  gpointer v_object)
{
	PluginsPluggableRep * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PLUGINS_TYPE_PLUGGABLE_REP));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PLUGINS_TYPE_PLUGGABLE_REP));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		plugins_pluggable_rep_unref (old);
	}
}

static void
plugins_pluggable_rep_class_init (PluginsPluggableRepClass * klass,
                                  gpointer klass_data)
{
	plugins_pluggable_rep_parent_class = g_type_class_peek_parent (klass);
	((PluginsPluggableRepClass *) klass)->finalize = plugins_pluggable_rep_finalize;
	g_type_class_adjust_private_offset (klass, &PluginsPluggableRep_private_offset);
}

static void
plugins_pluggable_rep_instance_init (PluginsPluggableRep * self,
                                     gpointer klass)
{
	self->priv = plugins_pluggable_rep_get_instance_private (self);
	self->priv->_is_core = FALSE;
	self->priv->_activated = FALSE;
	self->priv->enabled = FALSE;
	self->ref_count = 1;
}

static void
plugins_pluggable_rep_finalize (PluginsPluggableRep * obj)
{
	PluginsPluggableRep * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLUGINS_TYPE_PLUGGABLE_REP, PluginsPluggableRep);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->_pluggable);
	_g_free0 (self->priv->_id);
}

static GType
plugins_pluggable_rep_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { plugins_value_pluggable_rep_init, plugins_value_pluggable_rep_free_value, plugins_value_pluggable_rep_copy_value, plugins_value_pluggable_rep_peek_pointer, "p", plugins_value_pluggable_rep_collect_value, "p", plugins_value_pluggable_rep_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PluginsPluggableRepClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plugins_pluggable_rep_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PluginsPluggableRep), 0, (GInstanceInitFunc) plugins_pluggable_rep_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType plugins_pluggable_rep_type_id;
	plugins_pluggable_rep_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PluginsPluggableRep", &g_define_type_info, &g_define_type_fundamental_info, 0);
	PluginsPluggableRep_private_offset = g_type_add_instance_private (plugins_pluggable_rep_type_id, sizeof (PluginsPluggableRepPrivate));
	return plugins_pluggable_rep_type_id;
}

GType
plugins_pluggable_rep_get_type (void)
{
	static volatile gsize plugins_pluggable_rep_type_id__once = 0;
	if (g_once_init_enter (&plugins_pluggable_rep_type_id__once)) {
		GType plugins_pluggable_rep_type_id;
		plugins_pluggable_rep_type_id = plugins_pluggable_rep_get_type_once ();
		g_once_init_leave (&plugins_pluggable_rep_type_id__once, plugins_pluggable_rep_type_id);
	}
	return plugins_pluggable_rep_type_id__once;
}

gpointer
plugins_pluggable_rep_ref (gpointer instance)
{
	PluginsPluggableRep * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
plugins_pluggable_rep_unref (gpointer instance)
{
	PluginsPluggableRep * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PLUGINS_PLUGGABLE_REP_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_add49 (GFile** * array,
                   gint* length,
                   gint* size,
                   GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add50 (GFile** * array,
                   gint* length,
                   gint* size,
                   GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add51 (GFile** * array,
                   gint* length,
                   gint* size,
                   GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
plugins_init (GError** error)
{
	GFile** _tmp0_;
	const gchar* plugin_dir = NULL;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	GeeHashMap* _tmp9_;
	GeeHashMap* _tmp10_;
	GeeHashMap* _tmp11_;
	GeeHashSet* _tmp12_;
	GFile** _tmp13_;
	gint _tmp13__length1;
	GError* _inner_error0_ = NULL;
	_tmp0_ = g_new0 (GFile*, 0 + 1);
	plugins_search_dirs = (_vala_array_free (plugins_search_dirs, plugins_search_dirs_length1, (GDestroyNotify) g_object_unref), NULL);
	plugins_search_dirs = _tmp0_;
	plugins_search_dirs_length1 = 0;
	_plugins_search_dirs_size_ = plugins_search_dirs_length1;
	_tmp1_ = g_getenv ("SHOTWELL_PLUGIN_PATH");
	plugin_dir = _tmp1_;
	_tmp3_ = plugin_dir;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = plugin_dir;
		_tmp2_ = g_strcmp0 (_tmp4_, "") != 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp5_;
		GFile* _tmp6_;
		_tmp5_ = plugin_dir;
		_tmp6_ = g_file_new_for_commandline_arg (_tmp5_);
		_vala_array_add49 (&plugins_search_dirs, &plugins_search_dirs_length1, &_plugins_search_dirs_size_, _tmp6_);
	}
	_tmp7_ = app_dirs_get_user_plugins_dir ();
	_vala_array_add50 (&plugins_search_dirs, &plugins_search_dirs_length1, &_plugins_search_dirs_size_, _tmp7_);
	_tmp8_ = app_dirs_get_system_plugins_dir ();
	_vala_array_add51 (&plugins_search_dirs, &plugins_search_dirs_length1, &_plugins_search_dirs_size_, _tmp8_);
	_tmp9_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, PLUGINS_TYPE_MODULE_REP, (GBoxedCopyFunc) plugins_module_rep_ref, (GDestroyNotify) plugins_module_rep_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (plugins_module_table);
	plugins_module_table = _tmp9_;
	_tmp10_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, PLUGINS_TYPE_PLUGGABLE_REP, (GBoxedCopyFunc) plugins_pluggable_rep_ref, (GDestroyNotify) plugins_pluggable_rep_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (plugins_pluggable_table);
	plugins_pluggable_table = _tmp10_;
	_tmp11_ = gee_hash_map_new (G_TYPE_GTYPE, NULL, NULL, PLUGINS_TYPE_EXTENSION_POINT, (GBoxedCopyFunc) plugins_extension_point_ref, (GDestroyNotify) plugins_extension_point_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (plugins_extension_points);
	plugins_extension_points = _tmp11_;
	_tmp12_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (plugins_core_ids);
	plugins_core_ids = _tmp12_;
	if (!g_module_supported ()) {
		g_warning ("Plugins.vala:130: Plugins not support: GModule not supported on this p" \
"latform.");
		return;
	}
	_tmp13_ = plugins_search_dirs;
	_tmp13__length1 = plugins_search_dirs_length1;
	{
		GFile** dir_collection = NULL;
		gint dir_collection_length1 = 0;
		gint _dir_collection_size_ = 0;
		gint dir_it = 0;
		dir_collection = _tmp13_;
		dir_collection_length1 = _tmp13__length1;
		for (dir_it = 0; dir_it < dir_collection_length1; dir_it = dir_it + 1) {
			GFile* _tmp14_;
			GFile* dir = NULL;
			_tmp14_ = _g_object_ref0 (dir_collection[dir_it]);
			dir = _tmp14_;
			{
				{
					GFile* _tmp15_;
					_tmp15_ = dir;
					plugins_search_for_plugins (_tmp15_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* err = NULL;
					GFile* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					GError* _tmp19_;
					const gchar* _tmp20_;
					err = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp16_ = dir;
					_tmp17_ = g_file_get_path (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = err;
					_tmp20_ = _tmp19_->message;
					g_debug ("Plugins.vala:139: Unable to search directory %s for plugins: %s", _tmp18_, _tmp20_);
					_g_free0 (_tmp18_);
					_g_error_free0 (err);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (dir);
					return;
				}
				_g_object_unref0 (dir);
			}
		}
	}
}

void
plugins_terminate (void)
{
	plugins_search_dirs = (_vala_array_free (plugins_search_dirs, plugins_search_dirs_length1, (GDestroyNotify) g_object_unref), NULL);
	plugins_search_dirs = NULL;
	plugins_search_dirs_length1 = 0;
	_plugins_search_dirs_size_ = plugins_search_dirs_length1;
	_g_object_unref0 (plugins_pluggable_table);
	plugins_pluggable_table = NULL;
	_g_object_unref0 (plugins_module_table);
	plugins_module_table = NULL;
	_g_object_unref0 (plugins_extension_points);
	plugins_extension_points = NULL;
	_g_object_unref0 (plugins_core_ids);
	plugins_core_ids = NULL;
}

static PluginsNotifier*
plugins_notifier_construct (GType object_type)
{
	PluginsNotifier* self = NULL;
	self = (PluginsNotifier*) g_type_create_instance (object_type);
	return self;
}

static PluginsNotifier*
plugins_notifier_new (void)
{
	return plugins_notifier_construct (PLUGINS_TYPE_NOTIFIER);
}

static gpointer
_plugins_notifier_ref0 (gpointer self)
{
	return self ? plugins_notifier_ref (self) : NULL;
}

PluginsNotifier*
plugins_notifier_get_instance (void)
{
	PluginsNotifier* _tmp0_;
	PluginsNotifier* _tmp2_;
	PluginsNotifier* _tmp3_;
	PluginsNotifier* result;
	_tmp0_ = plugins_notifier_instance;
	if (_tmp0_ == NULL) {
		PluginsNotifier* _tmp1_;
		_tmp1_ = plugins_notifier_new ();
		_plugins_notifier_unref0 (plugins_notifier_instance);
		plugins_notifier_instance = _tmp1_;
	}
	_tmp2_ = plugins_notifier_instance;
	_tmp3_ = _plugins_notifier_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static void
g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_BOOLEAN) (gpointer data1, gpointer arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}

static void
plugins_value_notifier_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
plugins_value_notifier_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		plugins_notifier_unref (value->data[0].v_pointer);
	}
}

static void
plugins_value_notifier_copy_value (const GValue* src_value,
                                   GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = plugins_notifier_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
plugins_value_notifier_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
plugins_value_notifier_collect_value (GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PluginsNotifier * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = plugins_notifier_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
plugins_value_notifier_lcopy_value (const GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	PluginsNotifier ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = plugins_notifier_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
plugins_param_spec_notifier (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags)
{
	PluginsParamSpecNotifier* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PLUGINS_TYPE_NOTIFIER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
plugins_value_get_notifier (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PLUGINS_TYPE_NOTIFIER), NULL);
	return value->data[0].v_pointer;
}

void
plugins_value_set_notifier (GValue* value,
                            gpointer v_object)
{
	PluginsNotifier * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PLUGINS_TYPE_NOTIFIER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PLUGINS_TYPE_NOTIFIER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		plugins_notifier_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		plugins_notifier_unref (old);
	}
}

void
plugins_value_take_notifier (GValue* value,
                             gpointer v_object)
{
	PluginsNotifier * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PLUGINS_TYPE_NOTIFIER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PLUGINS_TYPE_NOTIFIER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		plugins_notifier_unref (old);
	}
}

static void
plugins_notifier_class_init (PluginsNotifierClass * klass,
                             gpointer klass_data)
{
	plugins_notifier_parent_class = g_type_class_peek_parent (klass);
	((PluginsNotifierClass *) klass)->finalize = plugins_notifier_finalize;
	plugins_notifier_signals[PLUGINS_NOTIFIER_PLUGGABLE_ACTIVATION_SIGNAL] = g_signal_new ("pluggable-activation", PLUGINS_TYPE_NOTIFIER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN, G_TYPE_NONE, 2, SPIT_TYPE_PLUGGABLE, G_TYPE_BOOLEAN);
}

static void
plugins_notifier_instance_init (PluginsNotifier * self,
                                gpointer klass)
{
	self->ref_count = 1;
}

static void
plugins_notifier_finalize (PluginsNotifier * obj)
{
	PluginsNotifier * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLUGINS_TYPE_NOTIFIER, PluginsNotifier);
	g_signal_handlers_destroy (self);
}

static GType
plugins_notifier_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { plugins_value_notifier_init, plugins_value_notifier_free_value, plugins_value_notifier_copy_value, plugins_value_notifier_peek_pointer, "p", plugins_value_notifier_collect_value, "p", plugins_value_notifier_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PluginsNotifierClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plugins_notifier_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PluginsNotifier), 0, (GInstanceInitFunc) plugins_notifier_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType plugins_notifier_type_id;
	plugins_notifier_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PluginsNotifier", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return plugins_notifier_type_id;
}

GType
plugins_notifier_get_type (void)
{
	static volatile gsize plugins_notifier_type_id__once = 0;
	if (g_once_init_enter (&plugins_notifier_type_id__once)) {
		GType plugins_notifier_type_id;
		plugins_notifier_type_id = plugins_notifier_get_type_once ();
		g_once_init_leave (&plugins_notifier_type_id__once, plugins_notifier_type_id);
	}
	return plugins_notifier_type_id__once;
}

gpointer
plugins_notifier_ref (gpointer instance)
{
	PluginsNotifier * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
plugins_notifier_unref (gpointer instance)
{
	PluginsNotifier * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PLUGINS_NOTIFIER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

void
plugins_register_extension_point (GType type,
                                  const gchar* name,
                                  const gchar* icon_name,
                                  gchar** core_ids,
                                  gint core_ids_length1)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	PluginsExtensionPoint* _tmp2_;
	PluginsExtensionPoint* _tmp3_;
	g_return_if_fail (name != NULL);
	_tmp0_ = plugins_extension_points;
	_vala_assert (!gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) type)), "!extension_points.has_key(type)");
	_tmp1_ = plugins_extension_points;
	_tmp2_ = plugins_extension_point_new (type, name, icon_name, core_ids, core_ids_length1);
	_tmp3_ = _tmp2_;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) type), _tmp3_);
	_plugins_extension_point_unref0 (_tmp3_);
	if (core_ids != NULL) {
		{
			gchar** core_id_collection = NULL;
			gint core_id_collection_length1 = 0;
			gint _core_id_collection_size_ = 0;
			gint core_id_it = 0;
			core_id_collection = core_ids;
			core_id_collection_length1 = core_ids_length1;
			for (core_id_it = 0; core_id_it < core_id_collection_length1; core_id_it = core_id_it + 1) {
				gchar* _tmp4_;
				gchar* core_id = NULL;
				_tmp4_ = g_strdup (core_id_collection[core_id_it]);
				core_id = _tmp4_;
				{
					GeeHashSet* _tmp5_;
					const gchar* _tmp6_;
					_tmp5_ = plugins_core_ids;
					_tmp6_ = core_id;
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp6_);
					_g_free0 (core_id);
				}
			}
		}
	}
	{
		GeeIterator* _pluggable_rep_it = NULL;
		GeeHashMap* _tmp7_;
		GeeCollection* _tmp8_;
		GeeCollection* _tmp9_;
		GeeCollection* _tmp10_;
		GeeIterator* _tmp11_;
		GeeIterator* _tmp12_;
		_tmp7_ = plugins_pluggable_table;
		_tmp8_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_;
		_tmp11_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp12_ = _tmp11_;
		_g_object_unref0 (_tmp10_);
		_pluggable_rep_it = _tmp12_;
		while (TRUE) {
			GeeIterator* _tmp13_;
			PluginsPluggableRep* pluggable_rep = NULL;
			GeeIterator* _tmp14_;
			gpointer _tmp15_;
			PluginsPluggableRep* _tmp16_;
			SpitPluggable* _tmp17_;
			SpitPluggable* _tmp18_;
			PluginsPluggableRep* _tmp19_;
			PluginsNotifier* _tmp20_;
			PluginsNotifier* _tmp21_;
			PluginsPluggableRep* _tmp22_;
			SpitPluggable* _tmp23_;
			SpitPluggable* _tmp24_;
			PluginsPluggableRep* _tmp25_;
			_tmp13_ = _pluggable_rep_it;
			if (!gee_iterator_next (_tmp13_)) {
				break;
			}
			_tmp14_ = _pluggable_rep_it;
			_tmp15_ = gee_iterator_get (_tmp14_);
			pluggable_rep = (PluginsPluggableRep*) _tmp15_;
			_tmp16_ = pluggable_rep;
			_tmp17_ = plugins_pluggable_rep_get_pluggable (_tmp16_);
			_tmp18_ = _tmp17_;
			if (!g_type_is_a (G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, G_TYPE_OBJECT, GObject)), type)) {
				_plugins_pluggable_rep_unref0 (pluggable_rep);
				continue;
			}
			_tmp19_ = pluggable_rep;
			plugins_pluggable_rep_activate (_tmp19_);
			_tmp20_ = plugins_notifier_get_instance ();
			_tmp21_ = _tmp20_;
			_tmp22_ = pluggable_rep;
			_tmp23_ = plugins_pluggable_rep_get_pluggable (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = pluggable_rep;
			g_signal_emit (_tmp21_, plugins_notifier_signals[PLUGINS_NOTIFIER_PLUGGABLE_ACTIVATION_SIGNAL], 0, _tmp24_, plugins_pluggable_rep_is_enabled (_tmp25_));
			_plugins_notifier_unref0 (_tmp21_);
			_plugins_pluggable_rep_unref0 (pluggable_rep);
		}
		_g_object_unref0 (_pluggable_rep_it);
	}
}

GeeCollection*
plugins_get_pluggables (gboolean include_disabled)
{
	GeeCollection* all = NULL;
	GeeHashSet* _tmp0_;
	GeeCollection* result;
	_tmp0_ = gee_hash_set_new (SPIT_TYPE_PLUGGABLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	all = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
	{
		GeeIterator* _pluggable_rep_it = NULL;
		GeeHashMap* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp1_ = plugins_pluggable_table;
		_tmp2_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_pluggable_rep_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			PluginsPluggableRep* pluggable_rep = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			gboolean _tmp10_ = FALSE;
			PluginsPluggableRep* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp7_ = _pluggable_rep_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _pluggable_rep_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			pluggable_rep = (PluginsPluggableRep*) _tmp9_;
			_tmp11_ = pluggable_rep;
			_tmp12_ = plugins_pluggable_rep_get_activated (_tmp11_);
			_tmp13_ = _tmp12_;
			if (_tmp13_) {
				gboolean _tmp14_ = FALSE;
				if (include_disabled) {
					_tmp14_ = TRUE;
				} else {
					PluginsPluggableRep* _tmp15_;
					_tmp15_ = pluggable_rep;
					_tmp14_ = plugins_pluggable_rep_is_enabled (_tmp15_);
				}
				_tmp10_ = _tmp14_;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				GeeCollection* _tmp16_;
				PluginsPluggableRep* _tmp17_;
				SpitPluggable* _tmp18_;
				SpitPluggable* _tmp19_;
				_tmp16_ = all;
				_tmp17_ = pluggable_rep;
				_tmp18_ = plugins_pluggable_rep_get_pluggable (_tmp17_);
				_tmp19_ = _tmp18_;
				gee_collection_add (_tmp16_, _tmp19_);
			}
			_plugins_pluggable_rep_unref0 (pluggable_rep);
		}
		_g_object_unref0 (_pluggable_rep_it);
	}
	result = all;
	return result;
}

gboolean
plugins_is_core_pluggable (SpitPluggable* pluggable)
{
	GeeHashSet* _tmp0_;
	const gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (pluggable, SPIT_TYPE_PLUGGABLE), FALSE);
	_tmp0_ = plugins_core_ids;
	_tmp1_ = spit_pluggable_get_id (pluggable);
	result = gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp1_);
	return result;
}

static SpitPluggable**
_vala_array_dup28 (SpitPluggable** self,
                   gssize length)
{
	if (length >= 0) {
		SpitPluggable** result;
		gssize i;
		result = g_new0 (SpitPluggable*, length + 1);
		for (i = 0; i < length; i++) {
			SpitPluggable* _tmp0_;
			_tmp0_ = _g_object_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

PluginsModuleRep*
plugins_get_module_for_pluggable (SpitPluggable* needle)
{
	PluginsModuleRep* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (needle, SPIT_TYPE_PLUGGABLE), NULL);
	{
		GeeIterator* _module_rep_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = plugins_module_table;
		_tmp1_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_module_rep_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			PluginsModuleRep* module_rep = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			SpitPluggable** pluggables = NULL;
			PluginsModuleRep* _tmp9_;
			SpitModule* _tmp10_;
			gint _tmp11_ = 0;
			SpitPluggable** _tmp12_;
			SpitPluggable** _tmp13_;
			gint _tmp13__length1;
			gint pluggables_length1;
			gint _pluggables_size_;
			SpitPluggable** _tmp14_;
			gint _tmp14__length1;
			_tmp6_ = _module_rep_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _module_rep_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			module_rep = (PluginsModuleRep*) _tmp8_;
			_tmp9_ = module_rep;
			_tmp10_ = _tmp9_->spit_module;
			_tmp12_ = spit_module_get_pluggables (_tmp10_, &_tmp11_);
			_tmp13_ = (_tmp12_ != NULL) ? _vala_array_dup28 (_tmp12_, _tmp11_) : _tmp12_;
			_tmp13__length1 = _tmp11_;
			pluggables = _tmp13_;
			pluggables_length1 = _tmp13__length1;
			_pluggables_size_ = pluggables_length1;
			_tmp14_ = pluggables;
			_tmp14__length1 = pluggables_length1;
			if (_tmp14_ != NULL) {
				SpitPluggable** _tmp15_;
				gint _tmp15__length1;
				_tmp15_ = pluggables;
				_tmp15__length1 = pluggables_length1;
				{
					SpitPluggable** pluggable_collection = NULL;
					gint pluggable_collection_length1 = 0;
					gint _pluggable_collection_size_ = 0;
					gint pluggable_it = 0;
					pluggable_collection = _tmp15_;
					pluggable_collection_length1 = _tmp15__length1;
					for (pluggable_it = 0; pluggable_it < pluggable_collection_length1; pluggable_it = pluggable_it + 1) {
						SpitPluggable* _tmp16_;
						SpitPluggable* pluggable = NULL;
						_tmp16_ = _g_object_ref0 (pluggable_collection[pluggable_it]);
						pluggable = _tmp16_;
						{
							SpitPluggable* _tmp17_;
							_tmp17_ = pluggable;
							if (_tmp17_ == needle) {
								result = module_rep;
								_g_object_unref0 (pluggable);
								pluggables = (_vala_array_free (pluggables, pluggables_length1, (GDestroyNotify) g_object_unref), NULL);
								_g_object_unref0 (_module_rep_it);
								return result;
							}
							_g_object_unref0 (pluggable);
						}
					}
				}
			}
			pluggables = (_vala_array_free (pluggables, pluggables_length1, (GDestroyNotify) g_object_unref), NULL);
			_plugins_module_rep_unref0 (module_rep);
		}
		_g_object_unref0 (_module_rep_it);
	}
	result = NULL;
	return result;
}

gchar*
plugins_get_pluggable_module_id (SpitPluggable* needle)
{
	PluginsModuleRep* module_rep = NULL;
	PluginsModuleRep* _tmp0_;
	const gchar* _tmp1_ = NULL;
	PluginsModuleRep* _tmp2_;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (needle, SPIT_TYPE_PLUGGABLE), NULL);
	_tmp0_ = plugins_get_module_for_pluggable (needle);
	module_rep = _tmp0_;
	_tmp2_ = module_rep;
	if (_tmp2_ != NULL) {
		PluginsModuleRep* _tmp3_;
		SpitModule* _tmp4_;
		const gchar* _tmp5_;
		_tmp3_ = module_rep;
		_tmp4_ = _tmp3_->spit_module;
		_tmp5_ = spit_module_get_id (_tmp4_);
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = NULL;
	}
	_tmp6_ = g_strdup (_tmp1_);
	result = _tmp6_;
	_plugins_module_rep_unref0 (module_rep);
	return result;
}

GeeCollection*
plugins_get_extension_points (GCompareDataFunc compare_func,
                              gpointer compare_func_target,
                              GDestroyNotify compare_func_target_destroy_notify)
{
	GeeCollection* sorted = NULL;
	GCompareDataFunc _tmp0_;
	gpointer _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	GeeTreeSet* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* result;
	_tmp0_ = compare_func;
	_tmp0__target = compare_func_target;
	_tmp0__target_destroy_notify = compare_func_target_destroy_notify;
	compare_func = NULL;
	compare_func_target = NULL;
	compare_func_target_destroy_notify = NULL;
	_tmp1_ = gee_tree_set_new (PLUGINS_TYPE_EXTENSION_POINT, (GBoxedCopyFunc) plugins_extension_point_ref, (GDestroyNotify) plugins_extension_point_unref, _tmp0_, _tmp0__target, _tmp0__target_destroy_notify);
	sorted = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection);
	_tmp2_ = plugins_extension_points;
	_tmp3_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	gee_collection_add_all (sorted, _tmp5_);
	_g_object_unref0 (_tmp5_);
	result = sorted;
	(compare_func_target_destroy_notify == NULL) ? NULL : (compare_func_target_destroy_notify (compare_func_target), NULL);
	compare_func = NULL;
	compare_func_target = NULL;
	compare_func_target_destroy_notify = NULL;
	return result;
}

GeeCollection*
plugins_get_pluggables_for_type (GType type,
                                 GCompareDataFunc compare_func,
                                 gpointer compare_func_target,
                                 GDestroyNotify compare_func_target_destroy_notify,
                                 gboolean include_disabled)
{
	GeeHashMap* _tmp0_;
	GeeCollection* for_type = NULL;
	GCompareDataFunc _tmp1_;
	gpointer _tmp1__target;
	GDestroyNotify _tmp1__target_destroy_notify;
	GeeTreeSet* _tmp2_;
	GeeCollection* result;
	_tmp0_ = plugins_extension_points;
	_vala_assert (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) type)), "extension_points.has_key(type)");
	_tmp1_ = compare_func;
	_tmp1__target = compare_func_target;
	_tmp1__target_destroy_notify = compare_func_target_destroy_notify;
	compare_func = NULL;
	compare_func_target = NULL;
	compare_func_target_destroy_notify = NULL;
	_tmp2_ = gee_tree_set_new (SPIT_TYPE_PLUGGABLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp1_, _tmp1__target, _tmp1__target_destroy_notify);
	for_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
	{
		GeeIterator* _pluggable_rep_it = NULL;
		GeeHashMap* _tmp3_;
		GeeCollection* _tmp4_;
		GeeCollection* _tmp5_;
		GeeCollection* _tmp6_;
		GeeIterator* _tmp7_;
		GeeIterator* _tmp8_;
		_tmp3_ = plugins_pluggable_table;
		_tmp4_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_;
		_tmp7_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp6_);
		_pluggable_rep_it = _tmp8_;
		while (TRUE) {
			GeeIterator* _tmp9_;
			PluginsPluggableRep* pluggable_rep = NULL;
			GeeIterator* _tmp10_;
			gpointer _tmp11_;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			PluginsPluggableRep* _tmp14_;
			gboolean _tmp15_;
			gboolean _tmp16_;
			_tmp9_ = _pluggable_rep_it;
			if (!gee_iterator_next (_tmp9_)) {
				break;
			}
			_tmp10_ = _pluggable_rep_it;
			_tmp11_ = gee_iterator_get (_tmp10_);
			pluggable_rep = (PluginsPluggableRep*) _tmp11_;
			_tmp14_ = pluggable_rep;
			_tmp15_ = plugins_pluggable_rep_get_activated (_tmp14_);
			_tmp16_ = _tmp15_;
			if (_tmp16_) {
				PluginsPluggableRep* _tmp17_;
				SpitPluggable* _tmp18_;
				SpitPluggable* _tmp19_;
				_tmp17_ = pluggable_rep;
				_tmp18_ = plugins_pluggable_rep_get_pluggable (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp13_ = g_type_is_a (G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, G_TYPE_OBJECT, GObject)), type);
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				gboolean _tmp20_ = FALSE;
				if (include_disabled) {
					_tmp20_ = TRUE;
				} else {
					PluginsPluggableRep* _tmp21_;
					_tmp21_ = pluggable_rep;
					_tmp20_ = plugins_pluggable_rep_is_enabled (_tmp21_);
				}
				_tmp12_ = _tmp20_;
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				GeeCollection* _tmp22_;
				PluginsPluggableRep* _tmp23_;
				SpitPluggable* _tmp24_;
				SpitPluggable* _tmp25_;
				_tmp22_ = for_type;
				_tmp23_ = pluggable_rep;
				_tmp24_ = plugins_pluggable_rep_get_pluggable (_tmp23_);
				_tmp25_ = _tmp24_;
				gee_collection_add (_tmp22_, _tmp25_);
			}
			_plugins_pluggable_rep_unref0 (pluggable_rep);
		}
		_g_object_unref0 (_pluggable_rep_it);
	}
	result = for_type;
	(compare_func_target_destroy_notify == NULL) ? NULL : (compare_func_target_destroy_notify (compare_func_target), NULL);
	compare_func = NULL;
	compare_func_target = NULL;
	compare_func_target_destroy_notify = NULL;
	return result;
}

gchar*
plugins_get_pluggable_name (const gchar* id)
{
	PluginsPluggableRep* pluggable_rep = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	PluginsPluggableRep* _tmp4_;
	gchar* _tmp12_;
	gchar* result;
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = plugins_pluggable_table;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), id);
	pluggable_rep = (PluginsPluggableRep*) _tmp1_;
	_tmp4_ = pluggable_rep;
	if (_tmp4_ != NULL) {
		PluginsPluggableRep* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = pluggable_rep;
		_tmp6_ = plugins_pluggable_rep_get_activated (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		PluginsPluggableRep* _tmp8_;
		SpitPluggable* _tmp9_;
		SpitPluggable* _tmp10_;
		const gchar* _tmp11_;
		_tmp8_ = pluggable_rep;
		_tmp9_ = plugins_pluggable_rep_get_pluggable (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = spit_pluggable_get_pluggable_name (_tmp10_);
		_tmp2_ = _tmp11_;
	} else {
		_tmp2_ = NULL;
	}
	_tmp12_ = g_strdup (_tmp2_);
	result = _tmp12_;
	_plugins_pluggable_rep_unref0 (pluggable_rep);
	return result;
}

gboolean
plugins_get_pluggable_info (const gchar* id,
                            SpitPluggableInfo** info)
{
	SpitPluggableInfo* _vala_info = NULL;
	PluginsPluggableRep* pluggable_rep = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	gboolean _tmp2_ = FALSE;
	PluginsPluggableRep* _tmp3_;
	PluginsPluggableRep* _tmp7_;
	SpitPluggable* _tmp8_;
	SpitPluggable* _tmp9_;
	SpitPluggableInfo* _tmp10_;
	gboolean result;
	g_return_val_if_fail (id != NULL, FALSE);
	_tmp0_ = plugins_pluggable_table;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), id);
	pluggable_rep = (PluginsPluggableRep*) _tmp1_;
	_tmp3_ = pluggable_rep;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		PluginsPluggableRep* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = pluggable_rep;
		_tmp5_ = plugins_pluggable_rep_get_activated (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = !_tmp6_;
	}
	if (_tmp2_) {
		_g_object_unref0 (_vala_info);
		_vala_info = NULL;
		result = FALSE;
		_plugins_pluggable_rep_unref0 (pluggable_rep);
		if (info) {
			*info = _vala_info;
		} else {
			_g_object_unref0 (_vala_info);
		}
		return result;
	}
	_tmp7_ = pluggable_rep;
	_tmp8_ = plugins_pluggable_rep_get_pluggable (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = spit_pluggable_get_info (_tmp9_);
	_g_object_unref0 (_vala_info);
	_vala_info = _tmp10_;
	result = TRUE;
	_plugins_pluggable_rep_unref0 (pluggable_rep);
	if (info) {
		*info = _vala_info;
	} else {
		_g_object_unref0 (_vala_info);
	}
	return result;
}

gboolean
plugins_get_pluggable_enabled (const gchar* id,
                               gboolean* enabled)
{
	gboolean _vala_enabled = FALSE;
	PluginsPluggableRep* pluggable_rep = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	gboolean _tmp2_ = FALSE;
	PluginsPluggableRep* _tmp3_;
	PluginsPluggableRep* _tmp7_;
	gboolean result;
	g_return_val_if_fail (id != NULL, FALSE);
	_tmp0_ = plugins_pluggable_table;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), id);
	pluggable_rep = (PluginsPluggableRep*) _tmp1_;
	_tmp3_ = pluggable_rep;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		PluginsPluggableRep* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = pluggable_rep;
		_tmp5_ = plugins_pluggable_rep_get_activated (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = !_tmp6_;
	}
	if (_tmp2_) {
		_vala_enabled = FALSE;
		result = FALSE;
		_plugins_pluggable_rep_unref0 (pluggable_rep);
		if (enabled) {
			*enabled = _vala_enabled;
		}
		return result;
	}
	_tmp7_ = pluggable_rep;
	_vala_enabled = plugins_pluggable_rep_is_enabled (_tmp7_);
	result = TRUE;
	_plugins_pluggable_rep_unref0 (pluggable_rep);
	if (enabled) {
		*enabled = _vala_enabled;
	}
	return result;
}

void
plugins_set_pluggable_enabled (const gchar* id,
                               gboolean enabled)
{
	PluginsPluggableRep* pluggable_rep = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	gboolean _tmp2_ = FALSE;
	PluginsPluggableRep* _tmp3_;
	PluginsPluggableRep* _tmp7_;
	g_return_if_fail (id != NULL);
	_tmp0_ = plugins_pluggable_table;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), id);
	pluggable_rep = (PluginsPluggableRep*) _tmp1_;
	_tmp3_ = pluggable_rep;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		PluginsPluggableRep* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = pluggable_rep;
		_tmp5_ = plugins_pluggable_rep_get_activated (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = !_tmp6_;
	}
	if (_tmp2_) {
		_plugins_pluggable_rep_unref0 (pluggable_rep);
		return;
	}
	_tmp7_ = pluggable_rep;
	if (plugins_pluggable_rep_set_enabled (_tmp7_, enabled)) {
		PluginsNotifier* _tmp8_;
		PluginsNotifier* _tmp9_;
		PluginsPluggableRep* _tmp10_;
		SpitPluggable* _tmp11_;
		SpitPluggable* _tmp12_;
		_tmp8_ = plugins_notifier_get_instance ();
		_tmp9_ = _tmp8_;
		_tmp10_ = pluggable_rep;
		_tmp11_ = plugins_pluggable_rep_get_pluggable (_tmp10_);
		_tmp12_ = _tmp11_;
		g_signal_emit (_tmp9_, plugins_notifier_signals[PLUGINS_NOTIFIER_PLUGGABLE_ACTIVATION_SIGNAL], 0, _tmp12_, enabled);
		_plugins_notifier_unref0 (_tmp9_);
	}
	_plugins_pluggable_rep_unref0 (pluggable_rep);
}

GFile*
plugins_get_pluggable_module_file (SpitPluggable* pluggable)
{
	PluginsModuleRep* module_rep = NULL;
	PluginsModuleRep* _tmp0_;
	GFile* _tmp1_ = NULL;
	PluginsModuleRep* _tmp2_;
	GFile* _tmp5_;
	GFile* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (pluggable, SPIT_TYPE_PLUGGABLE), NULL);
	_tmp0_ = plugins_get_module_for_pluggable (pluggable);
	module_rep = _tmp0_;
	_tmp2_ = module_rep;
	if (_tmp2_ != NULL) {
		PluginsModuleRep* _tmp3_;
		GFile* _tmp4_;
		_tmp3_ = module_rep;
		_tmp4_ = _tmp3_->file;
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = NULL;
	}
	_tmp5_ = _g_object_ref0 (_tmp1_);
	result = _tmp5_;
	_plugins_module_rep_unref0 (module_rep);
	return result;
}

gint
plugins_compare_pluggable_names (SpitPluggable* a,
                                 SpitPluggable* b)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (a, SPIT_TYPE_PLUGGABLE), 0);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (b, SPIT_TYPE_PLUGGABLE), 0);
	_tmp0_ = spit_pluggable_get_pluggable_name (a);
	_tmp1_ = spit_pluggable_get_pluggable_name (b);
	result = g_utf8_collate (_tmp0_, _tmp1_);
	return result;
}

gint
plugins_compare_extension_point_names (PluginsExtensionPoint* a,
                                       PluginsExtensionPoint* b)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint result;
	g_return_val_if_fail (PLUGINS_IS_EXTENSION_POINT (a), 0);
	g_return_val_if_fail (PLUGINS_IS_EXTENSION_POINT (b), 0);
	_tmp0_ = plugins_extension_point_get_name (a);
	_tmp1_ = _tmp0_;
	_tmp2_ = plugins_extension_point_get_name (b);
	_tmp3_ = _tmp2_;
	result = g_utf8_collate (_tmp1_, _tmp3_);
	return result;
}

void
plugins_search_for_plugins (GFile* dir,
                            GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFileEnumerator* enumerator = NULL;
	GFileEnumerator* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dir, g_file_get_type ()));
	_tmp0_ = g_file_get_path (dir);
	_tmp1_ = _tmp0_;
	g_debug ("Plugins.vala:304: Searching %s for plugins…", _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = g_file_enumerate_children (dir, UTIL_FILE_ATTRIBUTES, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
	enumerator = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	{
		gboolean _tmp3_ = FALSE;
		_tmp3_ = TRUE;
		while (TRUE) {
			GFileInfo* info = NULL;
			GFileEnumerator* _tmp4_;
			GFileInfo* _tmp5_;
			GFileInfo* _tmp6_;
			GFileInfo* _tmp7_;
			GFile* file = NULL;
			GFileInfo* _tmp8_;
			const gchar* _tmp9_;
			GFile* _tmp10_;
			GFileInfo* _tmp11_;
			if (!_tmp3_) {
			}
			_tmp3_ = FALSE;
			_tmp4_ = enumerator;
			_tmp5_ = g_file_enumerator_next_file (_tmp4_, NULL, &_inner_error0_);
			info = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (enumerator);
				return;
			}
			_tmp6_ = info;
			if (_tmp6_ == NULL) {
				_g_object_unref0 (info);
				break;
			}
			_tmp7_ = info;
			if (g_file_info_get_is_hidden (_tmp7_)) {
				_g_object_unref0 (info);
				continue;
			}
			_tmp8_ = info;
			_tmp9_ = g_file_info_get_name (_tmp8_);
			_tmp10_ = g_file_get_child (dir, _tmp9_);
			file = _tmp10_;
			_tmp11_ = info;
			switch (g_file_info_get_file_type (_tmp11_)) {
				case G_FILE_TYPE_DIRECTORY:
				{
					{
						GFile* _tmp12_;
						_tmp12_ = file;
						plugins_search_for_plugins (_tmp12_, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch0_g_error;
						}
					}
					goto __finally0;
					__catch0_g_error:
					{
						GError* err = NULL;
						GFile* _tmp13_;
						gchar* _tmp14_;
						gchar* _tmp15_;
						GError* _tmp16_;
						const gchar* _tmp17_;
						err = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp13_ = file;
						_tmp14_ = g_file_get_path (_tmp13_);
						_tmp15_ = _tmp14_;
						_tmp16_ = err;
						_tmp17_ = _tmp16_->message;
						g_warning ("Plugins.vala:325: Unable to search directory %s for plugins: %s", _tmp15_, _tmp17_);
						_g_free0 (_tmp15_);
						_g_error_free0 (err);
					}
					__finally0:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						_g_object_unref0 (file);
						_g_object_unref0 (info);
						_g_object_unref0 (enumerator);
						return;
					}
					break;
				}
				case G_FILE_TYPE_REGULAR:
				{
					GFileInfo* _tmp18_;
					const gchar* _tmp19_;
					_tmp18_ = info;
					_tmp19_ = g_file_info_get_content_type (_tmp18_);
					if (g_strcmp0 (_tmp19_, "application/x-sharedlib") == 0) {
						GFile* _tmp20_;
						_tmp20_ = file;
						plugins_load_module (_tmp20_);
					}
					break;
				}
				default:
				{
					break;
				}
			}
			_g_object_unref0 (file);
			_g_object_unref0 (info);
		}
	}
	_g_object_unref0 (enumerator);
}

void
plugins_load_module (GFile* file)
{
	PluginsModuleRep* module_rep = NULL;
	PluginsModuleRep* _tmp0_;
	PluginsModuleRep* _tmp1_;
	void* entry = NULL;
	PluginsModuleRep* _tmp5_;
	GModule* _tmp6_;
	void* _tmp7_ = NULL;
	gboolean _tmp8_;
	SpitEntryPoint spit_entry_point = NULL;
	void* _tmp11_;
	gboolean _tmp12_ = FALSE;
	SpitEntryPointParams params = {0};
	GFile* _tmp13_;
	PluginsModuleRep* _tmp14_;
	SpitEntryPoint _tmp15_;
	SpitModule* _tmp16_;
	SpitEntryPointParams _tmp17_;
	gboolean _tmp20_ = FALSE;
	SpitEntryPointParams _tmp21_;
	PluginsModuleRep* _tmp26_;
	SpitEntryPointParams _tmp27_;
	PluginsModuleRep* _tmp28_;
	SpitModule* _tmp29_;
	PluginsModuleRep* _tmp31_;
	SpitModule* _tmp32_;
	PluginsModuleRep* _tmp36_;
	PluginsModuleRep* _tmp37_;
	SpitModule* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	PluginsModuleRep* _tmp41_;
	const gchar* _tmp42_;
	GeeHashMap* _tmp46_;
	PluginsModuleRep* _tmp47_;
	const gchar* _tmp48_;
	PluginsModuleRep* _tmp54_;
	SpitModule* _tmp55_;
	const gchar* _tmp56_;
	PluginsModuleRep* _tmp57_;
	SpitModule* _tmp58_;
	const gchar* _tmp59_;
	PluginsModuleRep* _tmp60_;
	const gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	GeeHashMap* _tmp64_;
	PluginsModuleRep* _tmp65_;
	const gchar* _tmp66_;
	PluginsModuleRep* _tmp67_;
	PluginsModuleRep* _tmp68_;
	SpitModule* _tmp69_;
	gint _tmp70_ = 0;
	SpitPluggable** _tmp71_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	_tmp0_ = plugins_module_rep_open (file);
	module_rep = _tmp0_;
	_tmp1_ = module_rep;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = g_file_get_path (file);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_module_error ();
		g_critical ("Plugins.vala:345: Unable to load module %s: %s", _tmp3_, _tmp4_);
		_g_free0 (_tmp3_);
		_plugins_module_rep_unref0 (module_rep);
		return;
	}
	_tmp5_ = module_rep;
	_tmp6_ = _tmp5_->module;
	_tmp8_ = g_module_symbol (_tmp6_, SPIT_ENTRY_POINT_NAME, &_tmp7_);
	entry = _tmp7_;
	if (!_tmp8_) {
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = g_file_get_path (file);
		_tmp10_ = _tmp9_;
		g_critical ("Plugins.vala:353: Unable to load module %s: well-known entry point %s " \
"not found", _tmp10_, SPIT_ENTRY_POINT_NAME);
		_g_free0 (_tmp10_);
		_plugins_module_rep_unref0 (module_rep);
		return;
	}
	_tmp11_ = entry;
	spit_entry_point = (SpitEntryPoint) _tmp11_;
	if (PLUGINS_MIN_SPIT_INTERFACE <= SPIT_CURRENT_INTERFACE) {
		_tmp12_ = SPIT_CURRENT_INTERFACE <= PLUGINS_MAX_SPIT_INTERFACE;
	} else {
		_tmp12_ = FALSE;
	}
	_vala_assert (_tmp12_, "MIN_SPIT_INTERFACE <= Spit.CURRENT_INTERFACE && Spit.CURRENT_INTERFACE <= MAX_SPIT_INTERFACE");
	memset (&params, 0, sizeof (SpitEntryPointParams));
	params.host_min_spit_interface = PLUGINS_MIN_SPIT_INTERFACE;
	params.host_max_spit_interface = PLUGINS_MAX_SPIT_INTERFACE;
	params.module_spit_interface = SPIT_UNSUPPORTED_INTERFACE;
	_tmp13_ = _g_object_ref0 (file);
	_g_object_unref0 (params.module_file);
	params.module_file = _tmp13_;
	_tmp14_ = module_rep;
	_tmp15_ = spit_entry_point;
	_tmp16_ = _tmp15_ (&params);
	_g_object_unref0 (_tmp14_->spit_module);
	_tmp14_->spit_module = _tmp16_;
	_tmp17_ = params;
	if (_tmp17_.module_spit_interface == SPIT_UNSUPPORTED_INTERFACE) {
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp18_ = g_file_get_path (file);
		_tmp19_ = _tmp18_;
		g_critical ("Plugins.vala:370: Unable to load module %s: module reports no support " \
"for SPIT interfaces %d to %d", _tmp19_, PLUGINS_MIN_SPIT_INTERFACE, PLUGINS_MAX_SPIT_INTERFACE);
		_g_free0 (_tmp19_);
		spit_entry_point_params_destroy (&params);
		_plugins_module_rep_unref0 (module_rep);
		return;
	}
	_tmp21_ = params;
	if (_tmp21_.module_spit_interface < PLUGINS_MIN_SPIT_INTERFACE) {
		_tmp20_ = TRUE;
	} else {
		SpitEntryPointParams _tmp22_;
		_tmp22_ = params;
		_tmp20_ = _tmp22_.module_spit_interface > PLUGINS_MAX_SPIT_INTERFACE;
	}
	if (_tmp20_) {
		gchar* _tmp23_;
		gchar* _tmp24_;
		PluginsModuleRep* _tmp25_;
		_tmp23_ = g_file_get_path (file);
		_tmp24_ = _tmp23_;
		_tmp25_ = module_rep;
		g_critical ("Plugins.vala:377: Unable to load module %s: module reports unsupported" \
" SPIT version %d (out of range %d to %d)", _tmp24_, _tmp25_->spit_interface, PLUGINS_MIN_SPIT_INTERFACE, PLUGINS_MAX_SPIT_INTERFACE);
		_g_free0 (_tmp24_);
		spit_entry_point_params_destroy (&params);
		_plugins_module_rep_unref0 (module_rep);
		return;
	}
	_tmp26_ = module_rep;
	_tmp27_ = params;
	_tmp26_->spit_interface = _tmp27_.module_spit_interface;
	_tmp28_ = module_rep;
	_tmp29_ = _tmp28_->spit_module;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, SPIT_TYPE_MODULE)) {
		PluginsModuleRep* _tmp30_;
		_tmp30_ = module_rep;
		_g_object_unref0 (_tmp30_->spit_module);
		_tmp30_->spit_module = NULL;
	}
	_tmp31_ = module_rep;
	_tmp32_ = _tmp31_->spit_module;
	if (_tmp32_ == NULL) {
		gchar* _tmp33_;
		gchar* _tmp34_;
		PluginsModuleRep* _tmp35_;
		_tmp33_ = g_file_get_path (file);
		_tmp34_ = _tmp33_;
		_tmp35_ = module_rep;
		g_critical ("Plugins.vala:390: Unable to load module %s (SPIT %d): no spit module r" \
"eturned", _tmp34_, _tmp35_->spit_interface);
		_g_free0 (_tmp34_);
		spit_entry_point_params_destroy (&params);
		_plugins_module_rep_unref0 (module_rep);
		return;
	}
	_tmp36_ = module_rep;
	_tmp37_ = module_rep;
	_tmp38_ = _tmp37_->spit_module;
	_tmp39_ = spit_module_get_id (_tmp38_);
	_tmp40_ = prepare_input_text (_tmp39_, PREPARE_INPUT_TEXT_OPTIONS_DEFAULT, -1);
	_g_free0 (_tmp36_->id);
	_tmp36_->id = _tmp40_;
	_tmp41_ = module_rep;
	_tmp42_ = _tmp41_->id;
	if (_tmp42_ == NULL) {
		gchar* _tmp43_;
		gchar* _tmp44_;
		PluginsModuleRep* _tmp45_;
		_tmp43_ = g_file_get_path (file);
		_tmp44_ = _tmp43_;
		_tmp45_ = module_rep;
		g_critical ("Plugins.vala:400: Unable to load module %s (SPIT %d): invalid or empty" \
" module name", _tmp44_, _tmp45_->spit_interface);
		_g_free0 (_tmp44_);
		spit_entry_point_params_destroy (&params);
		_plugins_module_rep_unref0 (module_rep);
		return;
	}
	_tmp46_ = plugins_module_table;
	_tmp47_ = module_rep;
	_tmp48_ = _tmp47_->id;
	if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp48_)) {
		gchar* _tmp49_;
		gchar* _tmp50_;
		PluginsModuleRep* _tmp51_;
		PluginsModuleRep* _tmp52_;
		const gchar* _tmp53_;
		_tmp49_ = g_file_get_path (file);
		_tmp50_ = _tmp49_;
		_tmp51_ = module_rep;
		_tmp52_ = module_rep;
		_tmp53_ = _tmp52_->id;
		g_critical ("Plugins.vala:407: Not loading module %s (SPIT %d): module with name \"" \
"%s\" already loaded", _tmp50_, _tmp51_->spit_interface, _tmp53_);
		_g_free0 (_tmp50_);
		spit_entry_point_params_destroy (&params);
		_plugins_module_rep_unref0 (module_rep);
		return;
	}
	_tmp54_ = module_rep;
	_tmp55_ = _tmp54_->spit_module;
	_tmp56_ = spit_module_get_module_name (_tmp55_);
	_tmp57_ = module_rep;
	_tmp58_ = _tmp57_->spit_module;
	_tmp59_ = spit_module_get_version (_tmp58_);
	_tmp60_ = module_rep;
	_tmp61_ = _tmp60_->id;
	_tmp62_ = g_file_get_path (file);
	_tmp63_ = _tmp62_;
	g_debug ("Plugins.vala:413: Loaded SPIT module \"%s %s\" (%s) [%s]", _tmp56_, _tmp59_, _tmp61_, _tmp63_);
	_g_free0 (_tmp63_);
	_tmp64_ = plugins_module_table;
	_tmp65_ = module_rep;
	_tmp66_ = _tmp65_->id;
	_tmp67_ = module_rep;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp66_, _tmp67_);
	_tmp68_ = module_rep;
	_tmp69_ = _tmp68_->spit_module;
	_tmp71_ = spit_module_get_pluggables (_tmp69_, &_tmp70_);
	{
		SpitPluggable** pluggable_collection = NULL;
		gint pluggable_collection_length1 = 0;
		gint _pluggable_collection_size_ = 0;
		gint pluggable_it = 0;
		pluggable_collection = _tmp71_;
		pluggable_collection_length1 = _tmp70_;
		for (pluggable_it = 0; pluggable_it < pluggable_collection_length1; pluggable_it = pluggable_it + 1) {
			SpitPluggable* _tmp72_;
			SpitPluggable* pluggable = NULL;
			_tmp72_ = _g_object_ref0 (pluggable_collection[pluggable_it]);
			pluggable = _tmp72_;
			{
				GeeHashMap* _tmp73_;
				SpitPluggable* _tmp74_;
				const gchar* _tmp75_;
				SpitPluggable* _tmp76_;
				PluginsPluggableRep* _tmp77_;
				PluginsPluggableRep* _tmp78_;
				_tmp73_ = plugins_pluggable_table;
				_tmp74_ = pluggable;
				_tmp75_ = spit_pluggable_get_id (_tmp74_);
				_tmp76_ = pluggable;
				_tmp77_ = plugins_pluggable_rep_new (_tmp76_);
				_tmp78_ = _tmp77_;
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp75_, _tmp78_);
				_plugins_pluggable_rep_unref0 (_tmp78_);
				_g_object_unref0 (pluggable);
			}
		}
	}
	spit_entry_point_params_destroy (&params);
	_plugins_module_rep_unref0 (module_rep);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

