/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha3

// DeviceTaintSelectorApplyConfiguration represents a declarative configuration of the DeviceTaintSelector type for use
// with apply.
//
// DeviceTaintSelector defines which device(s) a DeviceTaintRule applies to.
// The empty selector matches all devices. Without a selector, no devices
// are matched.
type DeviceTaintSelectorApplyConfiguration struct {
	// If driver is set, only devices from that driver are selected.
	// This fields corresponds to slice.spec.driver.
	Driver *string `json:"driver,omitempty"`
	// If pool is set, only devices in that pool are selected.
	//
	// Also setting the driver name may be useful to avoid
	// ambiguity when different drivers use the same pool name,
	// but this is not required because selecting pools from
	// different drivers may also be useful, for example when
	// drivers with node-local devices use the node name as
	// their pool name.
	Pool *string `json:"pool,omitempty"`
	// If device is set, only devices with that name are selected.
	// This field corresponds to slice.spec.devices[].name.
	//
	// Setting also driver and pool may be required to avoid ambiguity,
	// but is not required.
	Device *string `json:"device,omitempty"`
}

// DeviceTaintSelectorApplyConfiguration constructs a declarative configuration of the DeviceTaintSelector type for use with
// apply.
func DeviceTaintSelector() *DeviceTaintSelectorApplyConfiguration {
	return &DeviceTaintSelectorApplyConfiguration{}
}

// WithDriver sets the Driver field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Driver field is set to the value of the last call.
func (b *DeviceTaintSelectorApplyConfiguration) WithDriver(value string) *DeviceTaintSelectorApplyConfiguration {
	b.Driver = &value
	return b
}

// WithPool sets the Pool field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Pool field is set to the value of the last call.
func (b *DeviceTaintSelectorApplyConfiguration) WithPool(value string) *DeviceTaintSelectorApplyConfiguration {
	b.Pool = &value
	return b
}

// WithDevice sets the Device field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Device field is set to the value of the last call.
func (b *DeviceTaintSelectorApplyConfiguration) WithDevice(value string) *DeviceTaintSelectorApplyConfiguration {
	b.Device = &value
	return b
}
