/* MountEntry.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from MountEntry.vala, do not modify */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MOUNT_ENTRY (mount_entry_get_type ())
#define MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_ENTRY, MountEntry))
#define MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_ENTRY, MountEntryClass))
#define IS_MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_ENTRY))
#define IS_MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_ENTRY))
#define MOUNT_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_ENTRY, MountEntryClass))

typedef struct _MountEntry MountEntry;
typedef struct _MountEntryClass MountEntryClass;
typedef struct _MountEntryPrivate MountEntryPrivate;

#define TYPE_DEVICE (device_get_type ())
#define DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEVICE, Device))
#define DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEVICE, DeviceClass))
#define IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEVICE))
#define IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEVICE))
#define DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEVICE, DeviceClass))

typedef struct _Device Device;
typedef struct _DeviceClass DeviceClass;
enum  {
	MOUNT_ENTRY_0_PROPERTY,
	MOUNT_ENTRY_NUM_PROPERTIES
};
static GParamSpec* mount_entry_properties[MOUNT_ENTRY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _DevicePrivate DevicePrivate;

struct _MountEntry {
	GObject parent_instance;
	MountEntryPrivate * priv;
	Device* device;
	gchar* mount_point;
	gchar* mount_options;
};

struct _MountEntryClass {
	GObjectClass parent_class;
};

struct _Device {
	GObject parent_instance;
	DevicePrivate * priv;
	gchar* device;
	gchar* name;
	gchar* kname;
	gchar* pkname;
	gchar* pkname_toplevel;
	gchar* mapped_name;
	gchar* uuid;
	gchar* label;
	gchar* partuuid;
	gchar* partlabel;
	gint major;
	gint minor;
	gchar* device_mapper;
	gchar* device_by_uuid;
	gchar* device_by_label;
	gchar* device_by_partuuid;
	gchar* device_by_partlabel;
	gchar* type;
	gchar* fstype;
	gint order;
	gchar* vendor;
	gchar* model;
	gchar* serial;
	gchar* revision;
	gboolean removable;
	gboolean read_only;
	guint64 size_bytes;
	guint64 used_bytes;
	guint64 available_bytes;
	gchar* used_percent;
	gchar* dist_info;
	GeeArrayList* mount_points;
	GeeArrayList* symlinks;
	Device* parent;
	GeeArrayList* children;
};

struct _DeviceClass {
	GObjectClass parent_class;
};

static gpointer mount_entry_parent_class = NULL;

VALA_EXTERN GType mount_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MountEntry, g_object_unref)
VALA_EXTERN GType device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Device, g_object_unref)
VALA_EXTERN MountEntry* mount_entry_new (Device* device,
                             const gchar* mount_point,
                             const gchar* mount_options);
VALA_EXTERN MountEntry* mount_entry_construct (GType object_type,
                                   Device* device,
                                   const gchar* mount_point,
                                   const gchar* mount_options);
VALA_EXTERN gchar* mount_entry_subvolume_name (MountEntry* self);
VALA_EXTERN gchar* mount_entry_lvm_name (MountEntry* self);
VALA_EXTERN MountEntry* mount_entry_find_entry_by_mount_point (GeeArrayList* entries,
                                                   const gchar* mount_path);
static void mount_entry_finalize (GObject * obj);
static GType mount_entry_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

MountEntry*
mount_entry_construct (GType object_type,
                       Device* device,
                       const gchar* mount_point,
                       const gchar* mount_options)
{
	MountEntry * self = NULL;
	Device* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (mount_point != NULL, NULL);
	g_return_val_if_fail (mount_options != NULL, NULL);
	self = (MountEntry*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (device);
	_g_object_unref0 (self->device);
	self->device = _tmp0_;
	_tmp1_ = g_strdup (mount_point);
	_g_free0 (self->mount_point);
	self->mount_point = _tmp1_;
	_tmp2_ = g_strdup (mount_options);
	_g_free0 (self->mount_options);
	self->mount_options = _tmp2_;
	return self;
}

MountEntry*
mount_entry_new (Device* device,
                 const gchar* mount_point,
                 const gchar* mount_options)
{
	return mount_entry_construct (TYPE_MOUNT_ENTRY, device, mount_point, mount_options);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

gchar*
mount_entry_subvolume_name (MountEntry* self)
{
	const gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->mount_options;
	if (string_contains (_tmp0_, "subvol=")) {
		gchar* txt = NULL;
		const gchar* _tmp1_;
		gchar** _tmp2_;
		gchar** _tmp3_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		const gchar* _tmp5_;
		gchar** _tmp6_;
		gchar** _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gboolean _tmp12_ = FALSE;
		const gchar* _tmp13_;
		_tmp1_ = self->mount_options;
		_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, "subvol=", 0);
		_tmp4_ = _tmp3_;
		_tmp4__length1 = _vala_array_length (_tmp2_);
		_tmp5_ = _tmp4_[1];
		_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, ",", 0);
		_tmp8_ = _tmp7_;
		_tmp8__length1 = _vala_array_length (_tmp6_);
		_tmp9_ = _tmp8_[0];
		_tmp10_ = string_strip (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
		_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
		txt = _tmp11_;
		_tmp13_ = txt;
		if (g_str_has_prefix (_tmp13_, "/")) {
			const gchar* _tmp14_;
			gchar** _tmp15_;
			gchar** _tmp16_;
			gchar** _tmp17_;
			gint _tmp17__length1;
			_tmp14_ = txt;
			_tmp16_ = _tmp15_ = g_strsplit (_tmp14_, "/", 0);
			_tmp17_ = _tmp16_;
			_tmp17__length1 = _vala_array_length (_tmp15_);
			_tmp12_ = _vala_array_length (_tmp15_) == 2;
			_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			const gchar* _tmp18_;
			gchar** _tmp19_;
			gchar** _tmp20_;
			gchar** _tmp21_;
			gint _tmp21__length1;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp18_ = txt;
			_tmp20_ = _tmp19_ = g_strsplit (_tmp18_, "/", 0);
			_tmp21_ = _tmp20_;
			_tmp21__length1 = _vala_array_length (_tmp19_);
			_tmp22_ = _tmp21_[1];
			_tmp23_ = g_strdup (_tmp22_);
			_g_free0 (txt);
			txt = _tmp23_;
			_tmp21_ = (_vala_array_free (_tmp21_, _tmp21__length1, (GDestroyNotify) g_free), NULL);
		}
		result = txt;
		return result;
	} else {
		gchar* _tmp24_;
		_tmp24_ = g_strdup ("");
		result = _tmp24_;
		return result;
	}
}

gchar*
mount_entry_lvm_name (MountEntry* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Device* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp2_ = self->device;
	if (_tmp2_ != NULL) {
		Device* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = self->device;
		_tmp4_ = _tmp3_->type;
		_tmp1_ = g_strcmp0 (_tmp4_, "lvm") == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		Device* _tmp5_;
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp5_ = self->device;
		_tmp6_ = _tmp5_->mapped_name;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp0_ = _tmp8_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Device* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp9_ = self->device;
		_tmp10_ = _tmp9_->mapped_name;
		_tmp11_ = string_strip (_tmp10_);
		result = _tmp11_;
		return result;
	} else {
		gchar* _tmp12_;
		_tmp12_ = g_strdup ("");
		result = _tmp12_;
		return result;
	}
}

MountEntry*
mount_entry_find_entry_by_mount_point (GeeArrayList* entries,
                                       const gchar* mount_path)
{
	MountEntry* result;
	g_return_val_if_fail (entries != NULL, NULL);
	g_return_val_if_fail (mount_path != NULL, NULL);
	{
		GeeArrayList* _entry_list = NULL;
		gint _entry_size = 0;
		GeeArrayList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint _entry_index = 0;
		_entry_list = entries;
		_tmp0_ = _entry_list;
		_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		_entry_size = _tmp2_;
		_entry_index = -1;
		while (TRUE) {
			gint _tmp3_;
			gint _tmp4_;
			MountEntry* entry = NULL;
			GeeArrayList* _tmp5_;
			gpointer _tmp6_;
			MountEntry* _tmp7_;
			const gchar* _tmp8_;
			_entry_index = _entry_index + 1;
			_tmp3_ = _entry_index;
			_tmp4_ = _entry_size;
			if (!(_tmp3_ < _tmp4_)) {
				break;
			}
			_tmp5_ = _entry_list;
			_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _entry_index);
			entry = (MountEntry*) _tmp6_;
			_tmp7_ = entry;
			_tmp8_ = _tmp7_->mount_point;
			if (g_strcmp0 (_tmp8_, mount_path) == 0) {
				result = entry;
				return result;
			}
			_g_object_unref0 (entry);
		}
	}
	result = NULL;
	return result;
}

static void
mount_entry_class_init (MountEntryClass * klass,
                        gpointer klass_data)
{
	mount_entry_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = mount_entry_finalize;
}

static void
mount_entry_instance_init (MountEntry * self,
                           gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->device = NULL;
	_tmp0_ = g_strdup ("");
	self->mount_point = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->mount_options = _tmp1_;
}

static void
mount_entry_finalize (GObject * obj)
{
	MountEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MOUNT_ENTRY, MountEntry);
	_g_object_unref0 (self->device);
	_g_free0 (self->mount_point);
	_g_free0 (self->mount_options);
	G_OBJECT_CLASS (mount_entry_parent_class)->finalize (obj);
}

static GType
mount_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MountEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mount_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MountEntry), 0, (GInstanceInitFunc) mount_entry_instance_init, NULL };
	GType mount_entry_type_id;
	mount_entry_type_id = g_type_register_static (G_TYPE_OBJECT, "MountEntry", &g_define_type_info, 0);
	return mount_entry_type_id;
}

GType
mount_entry_get_type (void)
{
	static volatile gsize mount_entry_type_id__once = 0;
	if (g_once_init_enter (&mount_entry_type_id__once)) {
		GType mount_entry_type_id;
		mount_entry_type_id = mount_entry_get_type_once ();
		g_once_init_leave (&mount_entry_type_id__once, mount_entry_type_id);
	}
	return mount_entry_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

