/* TeeJee.Process.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from TeeJee.Process.vala, do not modify */

/*
 * TeeJee.ProcessHelper.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <stdio.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <errno.h>
#include <signal.h>
#include <sys/time.h>
#include <sys/resource.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_rand_free0(var) ((var == NULL) ? NULL : (var = (g_rand_free (var), NULL)))

VALA_EXTERN gchar* tee_jee_process_helper_TEMP_DIR;
gchar* tee_jee_process_helper_TEMP_DIR = NULL;

VALA_EXTERN void tee_jee_process_helper_init_tmp (void);
VALA_EXTERN gchar* tee_jee_misc_random_string (gint length,
                                   const gchar* charset);
VALA_EXTERN gboolean tee_jee_file_system_dir_create (const gchar* dir_path,
                                         gboolean show_message);
VALA_EXTERN gint tee_jee_process_helper_exec_script_sync (const gchar* script,
                                              gchar** std_out,
                                              gchar** std_err,
                                              gboolean supress_errors,
                                              gboolean run_as_admin,
                                              gboolean cleanup_tmp,
                                              gboolean print_to_terminal);
VALA_EXTERN gboolean tee_jee_file_system_dir_delete (const gchar* dir_path,
                                         gboolean show_message);
VALA_EXTERN gint tee_jee_process_helper_exec_sync (const gchar* cmd,
                                       gchar** std_out,
                                       gchar** std_err);
VALA_EXTERN void tee_jee_logging_log_error (const gchar* message,
                                gboolean highlight,
                                gboolean is_warning);
VALA_EXTERN gchar* tee_jee_process_helper_save_bash_script_temp (const gchar* commands,
                                                     const gchar* script_path,
                                                     gboolean force_locale,
                                                     gboolean supress_errors);
VALA_EXTERN gchar* tee_jee_file_system_escape_single_quote (const gchar* file_path);
VALA_EXTERN gchar* tee_jee_file_system_file_parent (const gchar* file_path);
VALA_EXTERN gboolean tee_jee_file_system_file_delete (const gchar* file_path);
VALA_EXTERN gint tee_jee_process_helper_exec_script_async (const gchar* script);
VALA_EXTERN gint tee_jee_process_helper_exec_user_async (const gchar* command);
VALA_EXTERN gint tee_jee_system_get_user_id (void);
VALA_EXTERN gchar* tee_jee_system_get_username_from_uid (gint user_id);
VALA_EXTERN void tee_jee_logging_log_debug (const gchar* message);
VALA_EXTERN gchar* tee_jee_process_helper_get_temp_file_path (void);
VALA_EXTERN gchar* tee_jee_misc_timestamp_numeric (void);
VALA_EXTERN gboolean tee_jee_process_helper_cmd_exists (const gchar* cmd_tool);
VALA_EXTERN gchar* tee_jee_process_helper_get_process_exe_name (glong pid);
VALA_EXTERN GPid tee_jee_process_helper_get_process_parent (GPid process);
VALA_EXTERN gchar* tee_jee_file_system_file_read (const gchar* file_path);
VALA_EXTERN gint tee_jee_process_helper_get_euid_of_process (GPid process);
VALA_EXTERN GPid tee_jee_process_helper_get_user_process (void);
VALA_EXTERN gchar** tee_jee_process_helper_get_process_env (GPid pid,
                                                gint* result_length1);
VALA_EXTERN gchar** tee_jee_file_system_file_read_array (const gchar* file_path,
                                             gchar delimiter,
                                             gint* result_length1);
VALA_EXTERN gchar* tee_jee_process_helper_get_env (gchar** env,
                                       gint env_length1,
                                       const gchar* name,
                                       const gchar* default_value);
VALA_EXTERN GPid* tee_jee_process_helper_get_process_children (GPid parent_pid,
                                                   gint* result_length1);
static void _vala_array_add2 (GPid* * array,
                       gint* length,
                       gint* size,
                       GPid value);
VALA_EXTERN void tee_jee_process_helper_process_quit (GPid process_pid,
                                          gboolean killChildren);
VALA_EXTERN void tee_jee_process_helper_process_send_signal (GPid process_pid,
                                                 int sig,
                                                 gboolean children);
VALA_EXTERN void tee_jee_process_helper_process_kill (GPid process_pid,
                                          gboolean killChildren);
VALA_EXTERN void tee_jee_process_helper_process_set_priority (GPid procID,
                                                  gint prio);
VALA_EXTERN gint tee_jee_process_helper_process_get_priority (GPid procID);
VALA_EXTERN void tee_jee_process_helper_process_set_priority_normal (GPid procID);
VALA_EXTERN void tee_jee_process_helper_process_set_priority_low (GPid procID);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

void
tee_jee_process_helper_init_tmp (void)
{
	gchar** tempPlaces = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gint tempPlaces_length1;
	gint _tempPlaces_size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	FILE* _tmp25_;
	_tmp0_ = g_get_tmp_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	_tmp2_ = g_strdup ("/var/tmp");
	_tmp3_ = g_get_home_dir ();
	_tmp4_ = g_strconcat (_tmp3_, "/.temp", NULL);
	_tmp5_ = g_strdup ("/dev/shm");
	_tmp6_ = g_new0 (gchar*, 4 + 1);
	_tmp6_[0] = _tmp1_;
	_tmp6_[1] = _tmp2_;
	_tmp6_[2] = _tmp4_;
	_tmp6_[3] = _tmp5_;
	tempPlaces = _tmp6_;
	tempPlaces_length1 = 4;
	_tempPlaces_size_ = tempPlaces_length1;
	_tmp7_ = tempPlaces;
	_tmp7__length1 = tempPlaces_length1;
	{
		gchar** tempPlace_collection = NULL;
		gint tempPlace_collection_length1 = 0;
		gint _tempPlace_collection_size_ = 0;
		gint tempPlace_it = 0;
		tempPlace_collection = _tmp7_;
		tempPlace_collection_length1 = _tmp7__length1;
		for (tempPlace_it = 0; tempPlace_it < tempPlace_collection_length1; tempPlace_it = tempPlace_it + 1) {
			gchar* _tmp8_;
			gchar* tempPlace = NULL;
			_tmp8_ = g_strdup (tempPlace_collection[tempPlace_it]);
			tempPlace = _tmp8_;
			{
				gchar* std_out = NULL;
				gchar* std_err = NULL;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				gboolean _tmp19_ = FALSE;
				const gchar* _tmp20_;
				_tmp9_ = tempPlace;
				_tmp10_ = g_strconcat (_tmp9_, "/timeshift-", NULL);
				_tmp11_ = _tmp10_;
				_tmp12_ = tee_jee_misc_random_string (8, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890");
				_tmp13_ = _tmp12_;
				_tmp14_ = g_strconcat (_tmp11_, _tmp13_, NULL);
				_g_free0 (tee_jee_process_helper_TEMP_DIR);
				tee_jee_process_helper_TEMP_DIR = _tmp14_;
				_g_free0 (_tmp13_);
				_g_free0 (_tmp11_);
				_tmp15_ = tee_jee_process_helper_TEMP_DIR;
				tee_jee_file_system_dir_create (_tmp15_, FALSE);
				_tmp16_ = tee_jee_process_helper_TEMP_DIR;
				chmod (_tmp16_, (mode_t) 0750);
				tee_jee_process_helper_exec_script_sync ("echo 'ok'", &_tmp17_, &_tmp18_, TRUE, FALSE, TRUE, FALSE);
				_g_free0 (std_out);
				std_out = _tmp17_;
				_g_free0 (std_err);
				std_err = _tmp18_;
				_tmp20_ = std_out;
				if (_tmp20_ == NULL) {
					_tmp19_ = TRUE;
				} else {
					const gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					_tmp21_ = std_out;
					_tmp22_ = string_strip (_tmp21_);
					_tmp23_ = _tmp22_;
					_tmp19_ = g_strcmp0 (_tmp23_, "ok") != 0;
					_g_free0 (_tmp23_);
				}
				if (_tmp19_) {
					const gchar* _tmp24_;
					_tmp24_ = tee_jee_process_helper_TEMP_DIR;
					tee_jee_file_system_dir_delete (_tmp24_, FALSE);
				} else {
					_g_free0 (std_err);
					_g_free0 (std_out);
					_g_free0 (tempPlace);
					tempPlaces = (_vala_array_free (tempPlaces, tempPlaces_length1, (GDestroyNotify) g_free), NULL);
					return;
				}
				_g_free0 (std_err);
				_g_free0 (std_out);
				_g_free0 (tempPlace);
			}
		}
	}
	_tmp25_ = stderr;
	fprintf (_tmp25_, "No usable temp directory was found!\n");
	tempPlaces = (_vala_array_free (tempPlaces, tempPlaces_length1, (GDestroyNotify) g_free), NULL);
}

gint
tee_jee_process_helper_exec_sync (const gchar* cmd,
                                  gchar** std_out,
                                  gchar** std_err)
{
	gchar* _vala_std_out = NULL;
	gchar* _vala_std_err = NULL;
	gint _tmp5_ = -1;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (cmd != NULL, 0);
	{
		gint status = 0;
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		g_spawn_command_line_sync (cmd, &_tmp0_, &_tmp1_, &_tmp2_, &_inner_error0_);
		_g_free0 (_vala_std_out);
		_vala_std_out = _tmp0_;
		_g_free0 (_vala_std_err);
		_vala_std_err = _tmp1_;
		status = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = status;
		if (std_out) {
			*std_out = _vala_std_out;
		} else {
			_g_free0 (_vala_std_out);
		}
		if (std_err) {
			*std_err = _vala_std_err;
		} else {
			_g_free0 (_vala_std_err);
		}
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		tee_jee_logging_log_error (_tmp4_, FALSE, FALSE);
		result = -1;
		_g_error_free0 (e);
		if (std_out) {
			*std_out = _vala_std_out;
		} else {
			_g_free0 (_vala_std_out);
		}
		if (std_err) {
			*std_err = _vala_std_err;
		} else {
			_g_free0 (_vala_std_err);
		}
		return result;
	}
	__finally0:
	_g_free0 (_vala_std_out);
	_g_free0 (_vala_std_err);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp5_;
}

gint
tee_jee_process_helper_exec_script_sync (const gchar* script,
                                         gchar** std_out,
                                         gchar** std_err,
                                         gboolean supress_errors,
                                         gboolean run_as_admin,
                                         gboolean cleanup_tmp,
                                         gboolean print_to_terminal)
{
	gchar* _vala_std_out = NULL;
	gchar* _vala_std_err = NULL;
	gchar* sh_file = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* sh_file_admin = NULL;
	gchar* _tmp2_;
	gint _tmp44_ = -1;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (script != NULL, 0);
	_tmp0_ = tee_jee_process_helper_save_bash_script_temp (script, NULL, TRUE, supress_errors);
	sh_file = _tmp0_;
	_tmp1_ = sh_file;
	if (_tmp1_ == NULL) {
		result = -1;
		_g_free0 (sh_file);
		if (std_out) {
			*std_out = _vala_std_out;
		} else {
			_g_free0 (_vala_std_out);
		}
		if (std_err) {
			*std_err = _vala_std_err;
		} else {
			_g_free0 (_vala_std_err);
		}
		return result;
	}
	_tmp2_ = g_strdup ("");
	sh_file_admin = _tmp2_;
	if (run_as_admin) {
		gchar* script_admin = NULL;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp3_ = g_strdup ("#!/usr/bin/env bash\n");
		script_admin = _tmp3_;
		_tmp4_ = script_admin;
		_tmp5_ = g_strconcat (_tmp4_, "pkexec env DISPLAY=$DISPLAY XAUTHORITY=$XAUTHORITY", NULL);
		_g_free0 (script_admin);
		script_admin = _tmp5_;
		_tmp6_ = script_admin;
		_tmp7_ = sh_file;
		_tmp8_ = tee_jee_file_system_escape_single_quote (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup_printf (" '%s'", _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat (_tmp6_, _tmp11_, NULL);
		_g_free0 (script_admin);
		script_admin = _tmp12_;
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		_tmp13_ = sh_file;
		_tmp14_ = tee_jee_file_system_file_parent (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_build_filename (_tmp15_, "script-admin.sh", NULL);
		_g_free0 (sh_file_admin);
		sh_file_admin = _tmp16_;
		_g_free0 (_tmp15_);
		_tmp17_ = script_admin;
		_tmp18_ = sh_file_admin;
		_tmp19_ = tee_jee_process_helper_save_bash_script_temp (_tmp17_, _tmp18_, TRUE, supress_errors);
		_tmp20_ = _tmp19_;
		_g_free0 (_tmp20_);
		_g_free0 (script_admin);
	}
	{
		gchar** argv = NULL;
		gchar** _tmp21_;
		gint argv_length1;
		gint _argv_size_;
		gchar** env = NULL;
		gchar** _tmp28_;
		gchar** _tmp29_;
		gint env_length1;
		gint _env_size_;
		gint exit_code = 0;
		_tmp21_ = g_new0 (gchar*, 1 + 1);
		argv = _tmp21_;
		argv_length1 = 1;
		_argv_size_ = argv_length1;
		if (run_as_admin) {
			gchar** _tmp22_;
			gint _tmp22__length1;
			const gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp22_ = argv;
			_tmp22__length1 = argv_length1;
			_tmp23_ = sh_file_admin;
			_tmp24_ = g_strdup (_tmp23_);
			_g_free0 (_tmp22_[0]);
			_tmp22_[0] = _tmp24_;
		} else {
			gchar** _tmp25_;
			gint _tmp25__length1;
			const gchar* _tmp26_;
			gchar* _tmp27_;
			_tmp25_ = argv;
			_tmp25__length1 = argv_length1;
			_tmp26_ = sh_file;
			_tmp27_ = g_strdup (_tmp26_);
			_g_free0 (_tmp25_[0]);
			_tmp25_[0] = _tmp27_;
		}
		_tmp29_ = _tmp28_ = g_get_environ ();
		env = _tmp29_;
		env_length1 = _vala_array_length (_tmp28_);
		_env_size_ = env_length1;
		if (print_to_terminal) {
			const gchar* _tmp30_;
			gchar** _tmp31_;
			gint _tmp31__length1;
			gchar** _tmp32_;
			gint _tmp32__length1;
			gint _tmp33_ = 0;
			_tmp30_ = tee_jee_process_helper_TEMP_DIR;
			_tmp31_ = argv;
			_tmp31__length1 = argv_length1;
			_tmp32_ = env;
			_tmp32__length1 = env_length1;
			g_spawn_sync (_tmp30_, _tmp31_, _tmp32_, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, NULL, &_tmp33_, &_inner_error0_);
			exit_code = _tmp33_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				goto __catch0_g_error;
			}
		} else {
			const gchar* _tmp34_;
			gchar** _tmp35_;
			gint _tmp35__length1;
			gchar** _tmp36_;
			gint _tmp36__length1;
			gchar* _tmp37_ = NULL;
			gchar* _tmp38_ = NULL;
			gint _tmp39_ = 0;
			_tmp34_ = tee_jee_process_helper_TEMP_DIR;
			_tmp35_ = argv;
			_tmp35__length1 = argv_length1;
			_tmp36_ = env;
			_tmp36__length1 = env_length1;
			g_spawn_sync (_tmp34_, _tmp35_, _tmp36_, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp37_, &_tmp38_, &_tmp39_, &_inner_error0_);
			_g_free0 (_vala_std_out);
			_vala_std_out = _tmp37_;
			_g_free0 (_vala_std_err);
			_vala_std_err = _tmp38_;
			exit_code = _tmp39_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				goto __catch0_g_error;
			}
		}
		if (cleanup_tmp) {
			const gchar* _tmp40_;
			_tmp40_ = sh_file;
			tee_jee_file_system_file_delete (_tmp40_);
			if (run_as_admin) {
				const gchar* _tmp41_;
				_tmp41_ = sh_file_admin;
				tee_jee_file_system_file_delete (_tmp41_);
			}
		}
		result = exit_code;
		env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (sh_file_admin);
		_g_free0 (sh_file);
		if (std_out) {
			*std_out = _vala_std_out;
		} else {
			_g_free0 (_vala_std_out);
		}
		if (std_err) {
			*std_err = _vala_std_err;
		} else {
			_g_free0 (_vala_std_err);
		}
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		if (!supress_errors) {
			GError* _tmp42_;
			const gchar* _tmp43_;
			_tmp42_ = e;
			_tmp43_ = _tmp42_->message;
			tee_jee_logging_log_error (_tmp43_, FALSE, FALSE);
		}
		result = -1;
		_g_error_free0 (e);
		_g_free0 (sh_file_admin);
		_g_free0 (sh_file);
		if (std_out) {
			*std_out = _vala_std_out;
		} else {
			_g_free0 (_vala_std_out);
		}
		if (std_err) {
			*std_err = _vala_std_err;
		} else {
			_g_free0 (_vala_std_err);
		}
		return result;
	}
	__finally0:
	_g_free0 (sh_file_admin);
	_g_free0 (sh_file);
	_g_free0 (_vala_std_out);
	_g_free0 (_vala_std_err);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp44_;
}

gint
tee_jee_process_helper_exec_script_async (const gchar* script)
{
	gint _tmp9_ = -1;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (script != NULL, 0);
	{
		gchar* scriptfile = NULL;
		gchar* _tmp0_;
		gchar** argv = NULL;
		gchar** _tmp1_;
		gint argv_length1;
		gint _argv_size_;
		gchar* _tmp2_;
		gchar** env = NULL;
		gchar** _tmp3_;
		gchar** _tmp4_;
		gint env_length1;
		gint _env_size_;
		GPid child_pid = 0;
		const gchar* _tmp5_;
		GPid _tmp6_ = 0;
		_tmp0_ = tee_jee_process_helper_save_bash_script_temp (script, NULL, TRUE, FALSE);
		scriptfile = _tmp0_;
		_tmp1_ = g_new0 (gchar*, 1 + 1);
		argv = _tmp1_;
		argv_length1 = 1;
		_argv_size_ = argv_length1;
		_tmp2_ = g_strdup (scriptfile);
		_g_free0 (argv[0]);
		argv[0] = _tmp2_;
		_tmp4_ = _tmp3_ = g_get_environ ();
		env = _tmp4_;
		env_length1 = _vala_array_length (_tmp3_);
		_env_size_ = env_length1;
		_tmp5_ = tee_jee_process_helper_TEMP_DIR;
		g_spawn_async_with_pipes (_tmp5_, argv, env, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp6_, NULL, NULL, NULL, &_inner_error0_);
		child_pid = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (scriptfile);
			goto __catch0_g_error;
		}
		result = 0;
		env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (scriptfile);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		tee_jee_logging_log_error (_tmp8_, FALSE, FALSE);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp9_;
}

/**
executes a command as the "normal" unprivileged user async
may execute the command as root if the user could not be determined or the name could not be resolved
 */
gint
tee_jee_process_helper_exec_user_async (const gchar* command)
{
	gint uid = 0;
	gchar* cmd = NULL;
	gchar* _tmp0_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gint result;
	g_return_val_if_fail (command != NULL, 0);
	uid = tee_jee_system_get_user_id ();
	_tmp0_ = g_strdup (command);
	cmd = _tmp0_;
	if (uid > 0) {
		gchar* user = NULL;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = tee_jee_system_get_username_from_uid (uid);
		user = _tmp1_;
		_tmp2_ = user;
		if (_tmp2_ != NULL) {
			const gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp3_ = user;
			_tmp4_ = g_strdup_printf ("pkexec --user %s env DISPLAY=$DISPLAY XAUTHORITY=$XAUTHORITY DBUS_SESS" \
"ION_BUS_ADDRESS=$DBUS_SESSION_BUS_ADDRESS ", _tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = cmd;
			_tmp7_ = g_strconcat (_tmp5_, _tmp6_, NULL);
			_g_free0 (cmd);
			cmd = _tmp7_;
			_g_free0 (_tmp5_);
		}
		_g_free0 (user);
	}
	_tmp8_ = cmd;
	tee_jee_logging_log_debug (_tmp8_);
	_tmp9_ = cmd;
	result = tee_jee_process_helper_exec_script_async (_tmp9_);
	_g_free0 (cmd);
	return result;
}

gchar*
tee_jee_process_helper_save_bash_script_temp (const gchar* commands,
                                              const gchar* script_path,
                                              gboolean force_locale,
                                              gboolean supress_errors)
{
	gchar* sh_path = NULL;
	gchar* _tmp0_;
	GString* script = NULL;
	GString* _tmp1_;
	GString* _tmp2_;
	GString* _tmp3_;
	GString* _tmp6_;
	GString* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GString* _tmp10_;
	GString* _tmp11_;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (commands != NULL, NULL);
	_tmp0_ = g_strdup (script_path);
	sh_path = _tmp0_;
	_tmp1_ = g_string_new ("");
	script = _tmp1_;
	_tmp2_ = script;
	g_string_append (_tmp2_, "#!/usr/bin/env bash\n");
	_tmp3_ = script;
	g_string_append (_tmp3_, "\n");
	if (force_locale) {
		GString* _tmp4_;
		GString* _tmp5_;
		_tmp4_ = script;
		g_string_append (_tmp4_, "LANG=C\n");
		_tmp5_ = script;
		g_string_append (_tmp5_, "LC_ALL=C.UTF-8\n");
	}
	_tmp6_ = script;
	g_string_append (_tmp6_, "\n");
	_tmp7_ = script;
	_tmp8_ = g_strdup_printf ("%s\n", commands);
	_tmp9_ = _tmp8_;
	g_string_append (_tmp7_, _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = script;
	g_string_append (_tmp10_, "\n\nexitCode=$?\n");
	_tmp11_ = script;
	g_string_append (_tmp11_, "echo ${exitCode} > status\n");
	_tmp13_ = sh_path;
	if (_tmp13_ == NULL) {
		_tmp12_ = TRUE;
	} else {
		const gchar* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		_tmp14_ = sh_path;
		_tmp15_ = strlen (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp12_ = _tmp16_ == 0;
	}
	if (_tmp12_) {
		gchar* _tmp17_;
		_tmp17_ = tee_jee_process_helper_get_temp_file_path ();
		_g_free0 (sh_path);
		sh_path = _tmp17_;
	}
	{
		GFile* file = NULL;
		const gchar* _tmp18_;
		GFile* _tmp19_;
		GFile* _tmp20_;
		GFileOutputStream* file_stream = NULL;
		GFile* _tmp22_;
		GFileOutputStream* _tmp23_;
		GDataOutputStream* data_stream = NULL;
		GFileOutputStream* _tmp24_;
		GDataOutputStream* _tmp25_;
		GDataOutputStream* _tmp26_;
		GString* _tmp27_;
		const gchar* _tmp28_;
		GDataOutputStream* _tmp29_;
		const gchar* _tmp30_;
		_tmp18_ = sh_path;
		_tmp19_ = g_file_new_for_path (_tmp18_);
		file = _tmp19_;
		_tmp20_ = file;
		if (g_file_query_exists (_tmp20_, NULL)) {
			GFile* _tmp21_;
			_tmp21_ = file;
			g_file_delete (_tmp21_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				goto __catch0_g_error;
			}
		}
		_tmp22_ = file;
		_tmp23_ = g_file_create (_tmp22_, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error0_);
		file_stream = _tmp23_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			goto __catch0_g_error;
		}
		_tmp24_ = file_stream;
		_tmp25_ = g_data_output_stream_new ((GOutputStream*) _tmp24_);
		data_stream = _tmp25_;
		_tmp26_ = data_stream;
		_tmp27_ = script;
		_tmp28_ = _tmp27_->str;
		g_data_output_stream_put_string (_tmp26_, _tmp28_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (data_stream);
			_g_object_unref0 (file_stream);
			_g_object_unref0 (file);
			goto __catch0_g_error;
		}
		_tmp29_ = data_stream;
		g_output_stream_close ((GOutputStream*) _tmp29_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (data_stream);
			_g_object_unref0 (file_stream);
			_g_object_unref0 (file);
			goto __catch0_g_error;
		}
		_tmp30_ = sh_path;
		chmod (_tmp30_, (mode_t) 0744);
		result = sh_path;
		_g_object_unref0 (data_stream);
		_g_object_unref0 (file_stream);
		_g_object_unref0 (file);
		_g_string_free0 (script);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		if (!supress_errors) {
			GError* _tmp31_;
			const gchar* _tmp32_;
			_tmp31_ = e;
			_tmp32_ = _tmp31_->message;
			tee_jee_logging_log_error (_tmp32_, FALSE, FALSE);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_string_free0 (script);
		_g_free0 (sh_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	_g_string_free0 (script);
	_g_free0 (sh_path);
	return result;
}

gchar*
tee_jee_process_helper_get_temp_file_path (void)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GRand* _tmp7_;
	GRand* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* result;
	_tmp0_ = tee_jee_process_helper_TEMP_DIR;
	_tmp1_ = g_strconcat (_tmp0_, "/", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = tee_jee_misc_timestamp_numeric ();
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp2_, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_rand_new ();
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup_printf ("%u", g_rand_int (_tmp8_));
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat (_tmp6_, _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	_g_rand_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = _tmp12_;
	return result;
}

gboolean
tee_jee_process_helper_cmd_exists (const gchar* cmd_tool)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (cmd_tool != NULL, FALSE);
	_tmp0_ = g_find_program_in_path (cmd_tool);
	path = _tmp0_;
	_tmp2_ = path;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp3_ = path;
		_tmp4_ = strlen (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_ > 0;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	_g_free0 (path);
	return result;
}

gchar*
tee_jee_process_helper_get_process_exe_name (glong pid)
{
	gchar* _tmp0_ = NULL;
	gchar* pidStr = NULL;
	gchar* _tmp3_;
	gchar* path = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* link = NULL;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	if (pid <= ((glong) 0)) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("self");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_strdup_printf ("%li", pid);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = g_strdup (_tmp0_);
	pidStr = _tmp3_;
	_tmp4_ = pidStr;
	_tmp5_ = g_strdup_printf ("/proc/%s/exe", _tmp4_);
	path = _tmp5_;
	{
		gchar* _tmp6_ = NULL;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = path;
		_tmp8_ = g_file_read_link (_tmp7_, &_inner_error0_);
		_tmp6_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp9_ = _tmp6_;
		_tmp6_ = NULL;
		_g_free0 (link);
		link = _tmp9_;
		_g_free0 (_tmp6_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		gchar* _tmp10_;
		g_clear_error (&_inner_error0_);
		_tmp10_ = g_strdup ("");
		result = _tmp10_;
		_g_free0 (link);
		_g_free0 (path);
		_g_free0 (pidStr);
		_g_free0 (_tmp0_);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (link);
		_g_free0 (path);
		_g_free0 (pidStr);
		_g_free0 (_tmp0_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp11_ = link;
	_tmp12_ = g_path_get_basename (_tmp11_);
	result = _tmp12_;
	_g_free0 (link);
	_g_free0 (path);
	_g_free0 (pidStr);
	_g_free0 (_tmp0_);
	return result;
}

GPid
tee_jee_process_helper_get_process_parent (GPid process)
{
	gchar* _tmp0_ = NULL;
	gchar* pidStr = NULL;
	gchar* _tmp3_;
	gchar* path = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* stats = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* details = NULL;
	const gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar** splitted = NULL;
	const gchar* _tmp15_;
	gchar** _tmp16_;
	gchar** _tmp17_;
	gint splitted_length1;
	gint _splitted_size_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GPid result;
	if (process <= ((GPid) 0)) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("self");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_strdup_printf ("%i", (gint) process);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = g_strdup (_tmp0_);
	pidStr = _tmp3_;
	_tmp4_ = pidStr;
	_tmp5_ = g_strdup_printf ("/proc/%s/stat", _tmp4_);
	path = _tmp5_;
	_tmp6_ = path;
	_tmp7_ = tee_jee_file_system_file_read (_tmp6_);
	stats = _tmp7_;
	_tmp8_ = stats;
	_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, ")", 2);
	_tmp11_ = _tmp10_;
	_tmp11__length1 = _vala_array_length (_tmp9_);
	_tmp12_ = _tmp11_[1];
	_tmp13_ = g_strdup (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	details = _tmp14_;
	_tmp15_ = details;
	_tmp17_ = _tmp16_ = g_strsplit (_tmp15_, " ", 3);
	splitted = _tmp17_;
	splitted_length1 = _vala_array_length (_tmp16_);
	_splitted_size_ = splitted_length1;
	_tmp18_ = splitted;
	_tmp18__length1 = splitted_length1;
	if (_tmp18__length1 == 3) {
		gchar** _tmp19_;
		gint _tmp19__length1;
		const gchar* _tmp20_;
		_tmp19_ = splitted;
		_tmp19__length1 = splitted_length1;
		_tmp20_ = _tmp19_[2];
		result = (GPid) atoi (_tmp20_);
		splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (details);
		_g_free0 (stats);
		_g_free0 (path);
		_g_free0 (pidStr);
		_g_free0 (_tmp0_);
		return result;
	}
	_tmp21_ = stats;
	_tmp22_ = g_strdup_printf ("can not parse process stat %s", _tmp21_);
	_tmp23_ = _tmp22_;
	tee_jee_logging_log_debug (_tmp23_);
	_g_free0 (_tmp23_);
	result = (GPid) -1;
	splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (details);
	_g_free0 (stats);
	_g_free0 (path);
	_g_free0 (pidStr);
	_g_free0 (_tmp0_);
	return result;
}

gint
tee_jee_process_helper_get_euid_of_process (GPid process)
{
	GFile* file = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GError* _inner_error0_ = NULL;
	gint result;
	_tmp0_ = g_strdup_printf ("/proc/%d", (gint) process);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	file = _tmp3_;
	{
		GFileInfo* info = NULL;
		GFileInfo* _tmp4_;
		_tmp4_ = g_file_query_info (file, G_FILE_ATTRIBUTE_UNIX_UID, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		info = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = (gint) g_file_info_get_attribute_uint32 (info, G_FILE_ATTRIBUTE_UNIX_UID);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		_tmp7_ = g_strdup_printf ("failed to fetch user of process %i %s", (gint) process, _tmp6_);
		_tmp8_ = _tmp7_;
		tee_jee_logging_log_debug (_tmp8_);
		_g_free0 (_tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp9_ = -1;
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	result = -1;
	_g_object_unref0 (file);
	return result;
}

GPid
tee_jee_process_helper_get_user_process (void)
{
	GPid ppid = 0;
	gint targetUser = 0;
	gint user = 0;
	GPid result;
	ppid = (GPid) -1;
	targetUser = tee_jee_system_get_user_id ();
	user = 0;
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			if (!_tmp0_) {
				gboolean _tmp1_ = FALSE;
				if (user != targetUser) {
					_tmp1_ = ppid > ((GPid) 1);
				} else {
					_tmp1_ = FALSE;
				}
				if (!_tmp1_) {
					break;
				}
			}
			_tmp0_ = FALSE;
			ppid = tee_jee_process_helper_get_process_parent (ppid);
			user = tee_jee_process_helper_get_euid_of_process (ppid);
		}
	}
	if (user == targetUser) {
		result = ppid;
		return result;
	}
	result = (GPid) -1;
	return result;
}

gchar**
tee_jee_process_helper_get_process_env (GPid pid,
                                        gint* result_length1)
{
	gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_ = 0;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** result;
	if (pid < ((GPid) 1)) {
		gchar** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = NULL;
		_tmp0__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp0__length1;
		}
		result = _tmp0_;
		return result;
	}
	_tmp1_ = g_strdup_printf ("/proc/%i/environ", (gint) pid);
	_tmp2_ = _tmp1_;
	_tmp4_ = tee_jee_file_system_file_read_array (_tmp2_, '\0', &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp3_;
	_g_free0 (_tmp2_);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

gchar*
tee_jee_process_helper_get_env (gchar** env,
                                gint env_length1,
                                const gchar* name,
                                const gchar* default_value)
{
	gchar* _tmp10_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	{
		gchar** env_var_collection = NULL;
		gint env_var_collection_length1 = 0;
		gint _env_var_collection_size_ = 0;
		gint env_var_it = 0;
		env_var_collection = env;
		env_var_collection_length1 = env_length1;
		for (env_var_it = 0; env_var_it < env_var_collection_length1; env_var_it = env_var_it + 1) {
			gchar* _tmp0_;
			gchar* env_var = NULL;
			_tmp0_ = g_strdup (env_var_collection[env_var_it]);
			env_var = _tmp0_;
			{
				gchar** splitted = NULL;
				const gchar* _tmp1_;
				gchar** _tmp2_;
				gchar** _tmp3_;
				gint splitted_length1;
				gint _splitted_size_;
				gchar** _tmp4_;
				gint _tmp4__length1;
				const gchar* _tmp5_;
				_tmp1_ = env_var;
				_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, "=", 2);
				splitted = _tmp3_;
				splitted_length1 = _vala_array_length (_tmp2_);
				_splitted_size_ = splitted_length1;
				_tmp4_ = splitted;
				_tmp4__length1 = splitted_length1;
				_tmp5_ = _tmp4_[0];
				if (g_strcmp0 (_tmp5_, name) == 0) {
					gchar** _tmp6_;
					gint _tmp6__length1;
					_tmp6_ = splitted;
					_tmp6__length1 = splitted_length1;
					if (_tmp6__length1 == 2) {
						gchar** _tmp7_;
						gint _tmp7__length1;
						const gchar* _tmp8_;
						gchar* _tmp9_;
						_tmp7_ = splitted;
						_tmp7__length1 = splitted_length1;
						_tmp8_ = _tmp7_[1];
						_tmp9_ = g_strdup (_tmp8_);
						result = _tmp9_;
						splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (env_var);
						return result;
					}
				}
				splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (env_var);
			}
		}
	}
	_tmp10_ = g_strdup (default_value);
	result = _tmp10_;
	return result;
}

static gboolean
uint64_try_parse (const gchar* str,
                  guint64* _result_,
                  const gchar** unparsed,
                  guint _base)
{
	guint64 _vala__result_ = 0ULL;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	guint64 _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = g_ascii_strtoull (str, &_tmp0_, _base);
	endptr = _tmp0_;
	_vala__result_ = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		gboolean _tmp5_ = FALSE;
		_vala_unparsed = "";
		if (errno != ERANGE) {
			_tmp5_ = errno != EINVAL;
		} else {
			_tmp5_ = FALSE;
		}
		result = _tmp5_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp6_;
		_tmp6_ = endptr;
		_vala_unparsed = (const gchar*) _tmp6_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static guint64
uint64_parse (const gchar* str,
              guint _base)
{
	guint64 result;
	g_return_val_if_fail (str != NULL, 0ULL);
	result = g_ascii_strtoull (str, NULL, _base);
	return result;
}

static void
_vala_array_add2 (GPid* * array,
                  gint* length,
                  gint* size,
                  GPid value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GPid, *array, *size);
	}
	(*array)[(*length)++] = value;
}

GPid*
tee_jee_process_helper_get_process_children (GPid parent_pid,
                                             gint* result_length1)
{
	GFile* procfs = NULL;
	GFile* _tmp0_;
	GPid* _tmp39_;
	GPid* _tmp40_;
	gint _tmp40__length1;
	GError* _inner_error0_ = NULL;
	GPid* result;
	_tmp0_ = g_file_new_for_path ("/proc/");
	procfs = _tmp0_;
	{
		GFileEnumerator* enumerator = NULL;
		GFile* _tmp1_;
		GFileEnumerator* _tmp2_;
		GFileInfo* info = NULL;
		GPid* childList = NULL;
		GPid* _tmp3_;
		gint childList_length1;
		gint _childList_size_;
		GPid* _tmp34_;
		gint _tmp34__length1;
		_tmp1_ = procfs;
		_tmp2_ = g_file_enumerate_children (_tmp1_, G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
		enumerator = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = g_new0 (GPid, 0);
		childList = _tmp3_;
		childList_length1 = 0;
		_childList_size_ = childList_length1;
		while (TRUE) {
			GFileInfo* _tmp4_ = NULL;
			GFileEnumerator* _tmp5_;
			GFileInfo* _tmp6_;
			GFileInfo* _tmp7_;
			GFileInfo* _tmp8_;
			GFileInfo* _tmp9_;
			gchar* name = NULL;
			GFileInfo* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			guint64 pid = 0ULL;
			const gchar* _tmp13_;
			guint64 _tmp14_ = 0ULL;
			gboolean _tmp15_;
			gchar* fileCont = NULL;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			const gchar* _tmp21_;
			gint index = 0;
			const gchar* _tmp22_;
			gchar* parseline = NULL;
			const gchar* _tmp23_;
			gchar* _tmp24_;
			gchar** split = NULL;
			const gchar* _tmp25_;
			gchar** _tmp26_;
			gchar** _tmp27_;
			gint split_length1;
			gint _split_size_;
			gchar** _tmp28_;
			gint _tmp28__length1;
			guint64 ppid = 0ULL;
			gchar** _tmp31_;
			gint _tmp31__length1;
			const gchar* _tmp32_;
			gboolean _tmp33_ = FALSE;
			_tmp5_ = enumerator;
			_tmp6_ = g_file_enumerator_next_file (_tmp5_, NULL, &_inner_error0_);
			_tmp4_ = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				childList = (g_free (childList), NULL);
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
				goto __catch0_g_error;
			}
			_tmp7_ = _tmp4_;
			_tmp4_ = NULL;
			_g_object_unref0 (info);
			info = _tmp7_;
			_tmp8_ = info;
			if (!(_tmp8_ != NULL)) {
				_g_object_unref0 (_tmp4_);
				break;
			}
			_tmp9_ = info;
			if (g_file_info_get_file_type (_tmp9_) != G_FILE_TYPE_DIRECTORY) {
				_g_object_unref0 (_tmp4_);
				continue;
			}
			_tmp10_ = info;
			_tmp11_ = g_file_info_get_name (_tmp10_);
			_tmp12_ = g_strdup (_tmp11_);
			name = _tmp12_;
			_tmp13_ = name;
			_tmp15_ = uint64_try_parse (_tmp13_, &_tmp14_, NULL, (guint) 0);
			pid = _tmp14_;
			if (!_tmp15_) {
				_g_free0 (name);
				_g_object_unref0 (_tmp4_);
				continue;
			}
			_tmp16_ = name;
			_tmp17_ = g_strdup_printf ("/proc/%s/stat", _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = tee_jee_file_system_file_read (_tmp18_);
			_tmp20_ = _tmp19_;
			_g_free0 (_tmp18_);
			fileCont = _tmp20_;
			_tmp21_ = fileCont;
			if (_tmp21_ == NULL) {
				_g_free0 (fileCont);
				_g_free0 (name);
				_g_object_unref0 (_tmp4_);
				continue;
			}
			_tmp22_ = fileCont;
			index = string_last_index_of_char (_tmp22_, (gunichar) ')', 0);
			_tmp23_ = fileCont;
			_tmp24_ = string_substring (_tmp23_, (glong) index, (glong) -1);
			parseline = _tmp24_;
			_tmp25_ = parseline;
			_tmp27_ = _tmp26_ = g_strsplit (_tmp25_, " ", 4);
			split = _tmp27_;
			split_length1 = _vala_array_length (_tmp26_);
			_split_size_ = split_length1;
			_tmp28_ = split;
			_tmp28__length1 = split_length1;
			if (_tmp28__length1 != 4) {
				gchar* _tmp29_;
				gchar* _tmp30_;
				_tmp29_ = g_strdup_printf ("can not parse state of %ld", (glong) pid);
				_tmp30_ = _tmp29_;
				tee_jee_logging_log_error (_tmp30_, FALSE, FALSE);
				_g_free0 (_tmp30_);
				split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (parseline);
				_g_free0 (fileCont);
				_g_free0 (name);
				_g_object_unref0 (_tmp4_);
				continue;
			}
			_tmp31_ = split;
			_tmp31__length1 = split_length1;
			_tmp32_ = _tmp31_[2];
			ppid = uint64_parse (_tmp32_, (guint) 0);
			if (ppid != ((guint64) 0)) {
				_tmp33_ = ppid == ((guint64) parent_pid);
			} else {
				_tmp33_ = FALSE;
			}
			if (_tmp33_) {
				_vala_array_add2 (&childList, &childList_length1, &_childList_size_, (GPid) pid);
			}
			split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (parseline);
			_g_free0 (fileCont);
			_g_free0 (name);
			_g_object_unref0 (_tmp4_);
		}
		_tmp34_ = childList;
		_tmp34__length1 = childList_length1;
		if (result_length1) {
			*result_length1 = _tmp34__length1;
		}
		result = _tmp34_;
		_g_object_unref0 (info);
		_g_object_unref0 (enumerator);
		_g_object_unref0 (procfs);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp35_;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp35_ = e;
		_tmp36_ = _tmp35_->message;
		tee_jee_logging_log_error (_tmp36_, FALSE, FALSE);
		_tmp37_ = g_strdup_printf ("Failed to get child processes of %ld", (glong) parent_pid);
		_tmp38_ = _tmp37_;
		tee_jee_logging_log_error (_tmp38_, FALSE, FALSE);
		_g_free0 (_tmp38_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (procfs);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp39_ = g_new0 (GPid, 0);
	_tmp40_ = _tmp39_;
	_tmp40__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp40__length1;
	}
	result = _tmp40_;
	_g_object_unref0 (procfs);
	return result;
}

void
tee_jee_process_helper_process_quit (GPid process_pid,
                                     gboolean killChildren)
{
	tee_jee_process_helper_process_send_signal (process_pid, SIGTERM, killChildren);
}

void
tee_jee_process_helper_process_kill (GPid process_pid,
                                     gboolean killChildren)
{
	tee_jee_process_helper_process_send_signal (process_pid, SIGKILL, killChildren);
}

void
tee_jee_process_helper_process_send_signal (GPid process_pid,
                                            int sig,
                                            gboolean children)
{
	GPid* child_pids = NULL;
	gint _tmp0_ = 0;
	GPid* _tmp1_;
	gint child_pids_length1;
	gint _child_pids_size_;
	_tmp1_ = tee_jee_process_helper_get_process_children (process_pid, &_tmp0_);
	child_pids = _tmp1_;
	child_pids_length1 = _tmp0_;
	_child_pids_size_ = child_pids_length1;
	kill ((pid_t) process_pid, (gint) sig);
	if (children) {
		GPid* _tmp2_;
		gint _tmp2__length1;
		_tmp2_ = child_pids;
		_tmp2__length1 = child_pids_length1;
		{
			GPid* pid_collection = NULL;
			gint pid_collection_length1 = 0;
			gint _pid_collection_size_ = 0;
			gint pid_it = 0;
			pid_collection = _tmp2_;
			pid_collection_length1 = _tmp2__length1;
			for (pid_it = 0; pid_it < pid_collection_length1; pid_it = pid_it + 1) {
				GPid pid = 0;
				pid = pid_collection[pid_it];
				{
					kill ((pid_t) pid, (gint) sig);
				}
			}
		}
	}
	child_pids = (g_free (child_pids), NULL);
}

void
tee_jee_process_helper_process_set_priority (GPid procID,
                                             gint prio)
{
	if (getpriority (PRIO_PROCESS, (gint) procID) != prio) {
		setpriority (PRIO_PROCESS, (gint) procID, prio);
	}
}

gint
tee_jee_process_helper_process_get_priority (GPid procID)
{
	gint result;
	result = getpriority (PRIO_PROCESS, (gint) procID);
	return result;
}

void
tee_jee_process_helper_process_set_priority_normal (GPid procID)
{
	tee_jee_process_helper_process_set_priority (procID, 0);
}

void
tee_jee_process_helper_process_set_priority_low (GPid procID)
{
	tee_jee_process_helper_process_set_priority (procID, 5);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

