// This file is @generated by crates/typos-vars/tests/codegen.rs
#![allow(clippy::unreadable_literal, clippy::type_complexity)]

pub type Variants = &'static [&'static str];
pub type VariantsMap = [Variants; 4];

pub fn all_categories() -> crate::CategorySet {
    crate::Category::American
        | crate::Category::BritishIse
        | crate::Category::Canadian
        | crate::Category::Australian
}

pub fn corrections(category: crate::Category, options: VariantsMap) -> &'static [&'static str] {
    match category {
        crate::Category::American => options[0],
        crate::Category::BritishIse => options[1],
        crate::Category::Canadian => options[2],
        crate::Category::Australian => options[3],
        crate::Category::BritishIze | crate::Category::Other => {
            unreachable!("{:?} is unused", category)
        }
    }
}

pub static VARS: dictgen::Trie<&[(u8, &VariantsMap)]> = dictgen::Trie {
    root: &VARS_NODE,
    unicode: &VARS_UNICODE_TABLE,
    range: 2..=21,
};

pub static VARS_UNICODE_TABLE: dictgen::OrderedMap<
    dictgen::InsensitiveStr<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[],
    values: &[],
    range: 0..=0,
};

static VARS_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_CHILDREN),
    value: None,
};

static VARS_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_A_NODE),
    Some(&VARS_B_NODE),
    Some(&VARS_C_NODE),
    Some(&VARS_D_NODE),
    Some(&VARS_E_NODE),
    Some(&VARS_F_NODE),
    Some(&VARS_G_NODE),
    Some(&VARS_H_NODE),
    Some(&VARS_I_NODE),
    Some(&VARS_J_NODE),
    Some(&VARS_K_NODE),
    Some(&VARS_L_NODE),
    Some(&VARS_M_NODE),
    Some(&VARS_N_NODE),
    Some(&VARS_O_NODE),
    Some(&VARS_P_NODE),
    Some(&VARS_Q_NODE),
    Some(&VARS_R_NODE),
    Some(&VARS_S_NODE),
    Some(&VARS_T_NODE),
    Some(&VARS_U_NODE),
    Some(&VARS_V_NODE),
    Some(&VARS_W_NODE),
    None,
    Some(&VARS_Y_NODE),
    None,
];

static VARS_Y_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_Y_CHILDREN),
    value: None,
};

pub static VARS_Y_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("odeled"),
        dictgen::InsensitiveAscii("odeler"),
        dictgen::InsensitiveAscii("odelers"),
        dictgen::InsensitiveAscii("odeling"),
        dictgen::InsensitiveAscii("odelled"),
        dictgen::InsensitiveAscii("odeller"),
        dictgen::InsensitiveAscii("odellers"),
        dictgen::InsensitiveAscii("odelling"),
        dictgen::InsensitiveAscii("oghourt"),
        dictgen::InsensitiveAscii("oghourts"),
        dictgen::InsensitiveAscii("oghurt"),
        dictgen::InsensitiveAscii("oghurts"),
        dictgen::InsensitiveAscii("ogourt"),
        dictgen::InsensitiveAscii("ogourts"),
    ],
    values: &[
        &[(0b01001, &ENTRY_YODELED_15671817307109302642)],
        &[(0b01001, &ENTRY_YODELER_7988137706216703211)],
        &[(0b01001, &ENTRY_YODELERS_18010970770053754843)],
        &[(0b01001, &ENTRY_YODELING_5584968248317185710)],
        &[(0b11010, &ENTRY_YODELED_15671817307109302642)],
        &[(0b11010, &ENTRY_YODELER_7988137706216703211)],
        &[(0b11010, &ENTRY_YODELERS_18010970770053754843)],
        &[(0b11010, &ENTRY_YODELING_5584968248317185710)],
        &[(0b10010, &ENTRY_YOGURT_4836021873407169494)],
        &[(0b10010, &ENTRY_YOGURTS_12979282136707959016)],
        &[(0b11010, &ENTRY_YOGURT_4836021873407169494)],
        &[(0b11010, &ENTRY_YOGURTS_12979282136707959016)],
        &[(0b01000, &ENTRY_YOGURT_4836021873407169494)],
        &[(0b01000, &ENTRY_YOGURTS_12979282136707959016)],
    ],
    range: 6..=8,
};

static VARS_W_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_W_CHILDREN),
    value: None,
};

static VARS_W_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_WA_NODE),
    None,
    None,
    None,
    Some(&VARS_WE_NODE),
    None,
    None,
    Some(&VARS_WH_NODE),
    Some(&VARS_WI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_WO_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_WO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_WO_CHILDREN),
    value: None,
};

pub static VARS_WO_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("manise"),
        dictgen::InsensitiveAscii("manised"),
        dictgen::InsensitiveAscii("maniser"),
        dictgen::InsensitiveAscii("manisers"),
        dictgen::InsensitiveAscii("manises"),
        dictgen::InsensitiveAscii("manising"),
        dictgen::InsensitiveAscii("manize"),
        dictgen::InsensitiveAscii("manized"),
        dictgen::InsensitiveAscii("manizer"),
        dictgen::InsensitiveAscii("manizers"),
        dictgen::InsensitiveAscii("manizes"),
        dictgen::InsensitiveAscii("manizing"),
        dictgen::InsensitiveAscii("olen"),
        dictgen::InsensitiveAscii("olenner"),
        dictgen::InsensitiveAscii("olennest"),
        dictgen::InsensitiveAscii("olens"),
        dictgen::InsensitiveAscii("ollen"),
        dictgen::InsensitiveAscii("ollenner"),
        dictgen::InsensitiveAscii("ollennest"),
        dictgen::InsensitiveAscii("ollens"),
        dictgen::InsensitiveAscii("rshiped"),
        dictgen::InsensitiveAscii("rshiper"),
        dictgen::InsensitiveAscii("rshipers"),
        dictgen::InsensitiveAscii("rshiping"),
        dictgen::InsensitiveAscii("rshipped"),
        dictgen::InsensitiveAscii("rshipper"),
        dictgen::InsensitiveAscii("rshippers"),
        dictgen::InsensitiveAscii("rshipping"),
    ],
    values: &[
        &[(0b10010, &ENTRY_WOMANIZE_13944014032617070061)],
        &[(0b10010, &ENTRY_WOMANIZED_6823201211994765463)],
        &[(0b10010, &ENTRY_WOMANIZER_12959923156017407936)],
        &[(0b10010, &ENTRY_WOMANIZERS_2730363125830539583)],
        &[(0b10010, &ENTRY_WOMANIZES_1396386385917615542)],
        &[(0b10010, &ENTRY_WOMANIZING_14010372556431313508)],
        &[(0b01001, &ENTRY_WOMANIZE_13944014032617070061)],
        &[(0b01001, &ENTRY_WOMANIZED_6823201211994765463)],
        &[(0b01001, &ENTRY_WOMANIZER_12959923156017407936)],
        &[(0b01001, &ENTRY_WOMANIZERS_2730363125830539583)],
        &[(0b01001, &ENTRY_WOMANIZES_1396386385917615542)],
        &[(0b01001, &ENTRY_WOMANIZING_14010372556431313508)],
        &[(0b01001, &ENTRY_WOOLEN_16877039187309954068)],
        &[(0b01001, &ENTRY_WOOLENNER_16121158420209065321)],
        &[(0b01001, &ENTRY_WOOLENNEST_9962428894247675717)],
        &[(0b01001, &ENTRY_WOOLENS_6397410426801008847)],
        &[(0b11010, &ENTRY_WOOLEN_16877039187309954068)],
        &[(0b11010, &ENTRY_WOOLENNER_16121158420209065321)],
        &[(0b11010, &ENTRY_WOOLENNEST_9962428894247675717)],
        &[(0b11010, &ENTRY_WOOLENS_6397410426801008847)],
        &[(0b00001, &ENTRY_WORSHIPED_13801735218945656036)],
        &[(0b00001, &ENTRY_WORSHIPER_9520180601499296676)],
        &[(0b00001, &ENTRY_WORSHIPERS_2792179872387820015)],
        &[(0b00001, &ENTRY_WORSHIPING_9531564570456686375)],
        &[(0b11010, &ENTRY_WORSHIPED_13801735218945656036)],
        &[(0b11010, &ENTRY_WORSHIPER_9520180601499296676)],
        &[(0b11010, &ENTRY_WORSHIPERS_2792179872387820015)],
        &[(0b11010, &ENTRY_WORSHIPING_9531564570456686375)],
    ],
    range: 4..=9,
};

static VARS_WI_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_WI_CHILDREN),
    value: None,
};

pub static VARS_WI_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("lfullier"),
        dictgen::InsensitiveAscii("lfulliest"),
        dictgen::InsensitiveAscii("lfully"),
        dictgen::InsensitiveAscii("llful"),
        dictgen::InsensitiveAscii("llfuler"),
        dictgen::InsensitiveAscii("llfulest"),
        dictgen::InsensitiveAscii("llfullier"),
        dictgen::InsensitiveAscii("llfulliest"),
        dictgen::InsensitiveAscii("llfully"),
        dictgen::InsensitiveAscii("llfulness"),
        dictgen::InsensitiveAscii("nterisation"),
        dictgen::InsensitiveAscii("nterisations"),
        dictgen::InsensitiveAscii("nterise"),
        dictgen::InsensitiveAscii("nterised"),
        dictgen::InsensitiveAscii("nterises"),
        dictgen::InsensitiveAscii("nterising"),
        dictgen::InsensitiveAscii("nterization"),
        dictgen::InsensitiveAscii("nterizations"),
        dictgen::InsensitiveAscii("nterize"),
        dictgen::InsensitiveAscii("nterized"),
        dictgen::InsensitiveAscii("nterizes"),
        dictgen::InsensitiveAscii("nterizing"),
    ],
    values: &[
        &[(0b11010, &ENTRY_WILLFULLIER_15285733710201810363)],
        &[(0b11010, &ENTRY_WILLFULLIEST_1229078038469558436)],
        &[(0b11010, &ENTRY_WILLFULLY_11177950727637010120)],
        &[(0b01001, &ENTRY_WILLFUL_888733828666730475)],
        &[(0b01001, &ENTRY_WILLFULER_5381487143875928951)],
        &[(0b01001, &ENTRY_WILLFULEST_14812841215434133378)],
        &[(0b00001, &ENTRY_WILLFULLIER_15285733710201810363)],
        &[(0b00001, &ENTRY_WILLFULLIEST_1229078038469558436)],
        &[(0b00001, &ENTRY_WILLFULLY_11177950727637010120)],
        &[(0b00001, &ENTRY_WILLFULNESS_10353200066895422050)],
        &[(0b10010, &ENTRY_WINTERIZATION_347749948628387205)],
        &[(0b10010, &ENTRY_WINTERIZATIONS_10939012107648324861)],
        &[(0b10010, &ENTRY_WINTERIZE_2183252607445844863)],
        &[(0b10010, &ENTRY_WINTERIZED_13138859505846530038)],
        &[(0b10010, &ENTRY_WINTERIZES_6133753376693721696)],
        &[(0b10010, &ENTRY_WINTERIZING_3911142690065298063)],
        &[(0b01001, &ENTRY_WINTERIZATION_347749948628387205)],
        &[(0b01001, &ENTRY_WINTERIZATIONS_10939012107648324861)],
        &[(0b01001, &ENTRY_WINTERIZE_2183252607445844863)],
        &[(0b01001, &ENTRY_WINTERIZED_13138859505846530038)],
        &[(0b01001, &ENTRY_WINTERIZES_6133753376693721696)],
        &[(0b01001, &ENTRY_WINTERIZING_3911142690065298063)],
    ],
    range: 5..=12,
};

static VARS_WH_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_WH_CHILDREN),
    value: None,
};

pub static VARS_WH_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[dictgen::InsensitiveAscii("iskeys")],
    values: &[&[(0b01001, &ENTRY_WHISKEYS_7436468433370877238)]],
    range: 6..=6,
};

static VARS_WE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_WE_CHILDREN),
    value: None,
};

pub static VARS_WE_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("aseled"),
        dictgen::InsensitiveAscii("aseling"),
        dictgen::InsensitiveAscii("aselled"),
        dictgen::InsensitiveAscii("aselling"),
        dictgen::InsensitiveAscii("sternisation"),
        dictgen::InsensitiveAscii("sternisations"),
        dictgen::InsensitiveAscii("sternization"),
        dictgen::InsensitiveAscii("sternizations"),
    ],
    values: &[
        &[(0b01001, &ENTRY_WEASELED_7269396054259240547)],
        &[(0b01001, &ENTRY_WEASELING_2632216130329270938)],
        &[(0b10010, &ENTRY_WEASELED_7269396054259240547)],
        &[(0b10010, &ENTRY_WEASELING_2632216130329270938)],
        &[(0b10010, &ENTRY_WESTERNIZATION_10693435618580655065)],
        &[(0b10010, &ENTRY_WESTERNIZATIONS_17887310843739967172)],
        &[(0b01001, &ENTRY_WESTERNIZATION_10693435618580655065)],
        &[(0b01001, &ENTRY_WESTERNIZATIONS_17887310843739967172)],
    ],
    range: 6..=13,
};

static VARS_WA_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_WA_CHILDREN),
    value: None,
};

pub static VARS_WA_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ggon"),
        dictgen::InsensitiveAscii("ggoned"),
        dictgen::InsensitiveAscii("ggoner"),
        dictgen::InsensitiveAscii("ggoners"),
        dictgen::InsensitiveAscii("ggonette"),
        dictgen::InsensitiveAscii("ggonettes"),
        dictgen::InsensitiveAscii("ggoning"),
        dictgen::InsensitiveAscii("ggons"),
        dictgen::InsensitiveAscii("tercolor"),
        dictgen::InsensitiveAscii("tercolored"),
        dictgen::InsensitiveAscii("tercoloring"),
        dictgen::InsensitiveAscii("tercolorist"),
        dictgen::InsensitiveAscii("tercolorists"),
        dictgen::InsensitiveAscii("tercolors"),
        dictgen::InsensitiveAscii("tercolour"),
        dictgen::InsensitiveAscii("tercoloured"),
        dictgen::InsensitiveAscii("tercolouring"),
        dictgen::InsensitiveAscii("tercolourist"),
        dictgen::InsensitiveAscii("tercolourists"),
        dictgen::InsensitiveAscii("tercolours"),
    ],
    values: &[
        &[(0b10010, &ENTRY_WAGON_5335298714004042393)],
        &[(0b10010, &ENTRY_WAGONED_18404896035191047132)],
        &[(0b10010, &ENTRY_WAGONER_11432045632874199662)],
        &[(0b10010, &ENTRY_WAGONERS_6388316509001104344)],
        &[(0b10010, &ENTRY_WAGONETTE_3903149371449355531)],
        &[(0b10010, &ENTRY_WAGONETTES_2415032088297891551)],
        &[(0b10010, &ENTRY_WAGONING_2887560265469426881)],
        &[(0b10010, &ENTRY_WAGONS_11395031855637672578)],
        &[(0b11001, &ENTRY_WATERCOLOR_1242471837856686461)],
        &[(0b11001, &ENTRY_WATERCOLORED_551761815331700825)],
        &[(0b11001, &ENTRY_WATERCOLORING_7585263825752051770)],
        &[(0b00001, &ENTRY_WATERCOLORIST_15171920726508503979)],
        &[(0b00001, &ENTRY_WATERCOLORISTS_16203366413065930985)],
        &[(0b11001, &ENTRY_WATERCOLORS_9935320064817263087)],
        &[(0b11010, &ENTRY_WATERCOLOR_1242471837856686461)],
        &[(0b11010, &ENTRY_WATERCOLORED_551761815331700825)],
        &[(0b11010, &ENTRY_WATERCOLORING_7585263825752051770)],
        &[(0b11010, &ENTRY_WATERCOLORIST_15171920726508503979)],
        &[(0b11010, &ENTRY_WATERCOLORISTS_16203366413065930985)],
        &[(0b11010, &ENTRY_WATERCOLORS_9935320064817263087)],
    ],
    range: 4..=13,
};

static VARS_V_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_V_CHILDREN),
    value: None,
};

static VARS_V_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_VA_NODE),
    None,
    None,
    None,
    Some(&VARS_VE_NODE),
    None,
    None,
    None,
    Some(&VARS_VI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_VO_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_VU_NODE),
    None,
    None,
    None,
    None,
    None,
];

static VARS_VU_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_VU_CHILDREN),
    value: None,
};

pub static VARS_VU_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("lcanisation"),
        dictgen::InsensitiveAscii("lcanisations"),
        dictgen::InsensitiveAscii("lcanise"),
        dictgen::InsensitiveAscii("lcanised"),
        dictgen::InsensitiveAscii("lcaniser"),
        dictgen::InsensitiveAscii("lcanisers"),
        dictgen::InsensitiveAscii("lcanises"),
        dictgen::InsensitiveAscii("lcanising"),
        dictgen::InsensitiveAscii("lcanization"),
        dictgen::InsensitiveAscii("lcanizations"),
        dictgen::InsensitiveAscii("lcanize"),
        dictgen::InsensitiveAscii("lcanized"),
        dictgen::InsensitiveAscii("lcanizer"),
        dictgen::InsensitiveAscii("lcanizers"),
        dictgen::InsensitiveAscii("lcanizes"),
        dictgen::InsensitiveAscii("lcanizing"),
        dictgen::InsensitiveAscii("lgarisation"),
        dictgen::InsensitiveAscii("lgarisations"),
        dictgen::InsensitiveAscii("lgarise"),
        dictgen::InsensitiveAscii("lgarised"),
        dictgen::InsensitiveAscii("lgarises"),
        dictgen::InsensitiveAscii("lgarising"),
        dictgen::InsensitiveAscii("lgarization"),
        dictgen::InsensitiveAscii("lgarizations"),
        dictgen::InsensitiveAscii("lgarize"),
        dictgen::InsensitiveAscii("lgarized"),
        dictgen::InsensitiveAscii("lgarizes"),
        dictgen::InsensitiveAscii("lgarizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_VULCANIZATION_7905884940104482341)],
        &[(0b10010, &ENTRY_VULCANIZATIONS_15847832065617865889)],
        &[(0b10010, &ENTRY_VULCANIZE_6585960079549072743)],
        &[(0b10010, &ENTRY_VULCANIZED_14313743718177692805)],
        &[(0b10010, &ENTRY_VULCANIZER_9826867449740889574)],
        &[(0b10010, &ENTRY_VULCANIZERS_17322632051634463265)],
        &[(0b10010, &ENTRY_VULCANIZES_16377609962408860153)],
        &[(0b10010, &ENTRY_VULCANIZING_13984517742257009109)],
        &[(0b01001, &ENTRY_VULCANIZATION_7905884940104482341)],
        &[(0b01001, &ENTRY_VULCANIZATIONS_15847832065617865889)],
        &[(0b01001, &ENTRY_VULCANIZE_6585960079549072743)],
        &[(0b01001, &ENTRY_VULCANIZED_14313743718177692805)],
        &[(0b01001, &ENTRY_VULCANIZER_9826867449740889574)],
        &[(0b01001, &ENTRY_VULCANIZERS_17322632051634463265)],
        &[(0b01001, &ENTRY_VULCANIZES_16377609962408860153)],
        &[(0b01001, &ENTRY_VULCANIZING_13984517742257009109)],
        &[(0b10010, &ENTRY_VULGARIZATION_15527570270767072109)],
        &[(0b10010, &ENTRY_VULGARIZATIONS_8843218827275212658)],
        &[(0b10010, &ENTRY_VULGARIZE_6707031466678228051)],
        &[(0b10010, &ENTRY_VULGARIZED_8073979986420271297)],
        &[(0b10010, &ENTRY_VULGARIZES_645579138050710392)],
        &[(0b10010, &ENTRY_VULGARIZING_6396108281264937628)],
        &[(0b01001, &ENTRY_VULGARIZATION_15527570270767072109)],
        &[(0b01001, &ENTRY_VULGARIZATIONS_8843218827275212658)],
        &[(0b01001, &ENTRY_VULGARIZE_6707031466678228051)],
        &[(0b01001, &ENTRY_VULGARIZED_8073979986420271297)],
        &[(0b01001, &ENTRY_VULGARIZES_645579138050710392)],
        &[(0b01001, &ENTRY_VULGARIZING_6396108281264937628)],
    ],
    range: 7..=12,
};

static VARS_VO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_VO_CHILDREN),
    value: None,
};

pub static VARS_VO_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("calisation"),
        dictgen::InsensitiveAscii("calisations"),
        dictgen::InsensitiveAscii("calise"),
        dictgen::InsensitiveAscii("calised"),
        dictgen::InsensitiveAscii("calises"),
        dictgen::InsensitiveAscii("calising"),
        dictgen::InsensitiveAscii("calization"),
        dictgen::InsensitiveAscii("calizations"),
        dictgen::InsensitiveAscii("calize"),
        dictgen::InsensitiveAscii("calized"),
        dictgen::InsensitiveAscii("calizes"),
        dictgen::InsensitiveAscii("calizing"),
        dictgen::InsensitiveAscii("latilisation"),
        dictgen::InsensitiveAscii("latilisations"),
        dictgen::InsensitiveAscii("latilise"),
        dictgen::InsensitiveAscii("latilised"),
        dictgen::InsensitiveAscii("latilises"),
        dictgen::InsensitiveAscii("latilising"),
        dictgen::InsensitiveAscii("latilization"),
        dictgen::InsensitiveAscii("latilizations"),
        dictgen::InsensitiveAscii("latilize"),
        dictgen::InsensitiveAscii("latilized"),
        dictgen::InsensitiveAscii("latilizes"),
        dictgen::InsensitiveAscii("latilizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_VOCALIZATION_3101814292430397767)],
        &[(0b10010, &ENTRY_VOCALIZATIONS_17133298955574595735)],
        &[(0b10010, &ENTRY_VOCALIZE_4185858433777108713)],
        &[(0b10010, &ENTRY_VOCALIZED_10488165785915354680)],
        &[(0b10010, &ENTRY_VOCALIZES_9022405961253042006)],
        &[(0b10010, &ENTRY_VOCALIZING_6360195233059633529)],
        &[(0b01001, &ENTRY_VOCALIZATION_3101814292430397767)],
        &[(0b01001, &ENTRY_VOCALIZATIONS_17133298955574595735)],
        &[(0b01001, &ENTRY_VOCALIZE_4185858433777108713)],
        &[(0b01001, &ENTRY_VOCALIZED_10488165785915354680)],
        &[(0b01001, &ENTRY_VOCALIZES_9022405961253042006)],
        &[(0b01001, &ENTRY_VOCALIZING_6360195233059633529)],
        &[(0b10010, &ENTRY_VOLATILIZATION_3221641183281199106)],
        &[(0b10010, &ENTRY_VOLATILIZATIONS_8168537470161802057)],
        &[(0b10010, &ENTRY_VOLATILIZE_16270565871743863998)],
        &[(0b10010, &ENTRY_VOLATILIZED_13699473491173599192)],
        &[(0b10010, &ENTRY_VOLATILIZES_14953405067501371419)],
        &[(0b10010, &ENTRY_VOLATILIZING_9187797455588347418)],
        &[(0b01001, &ENTRY_VOLATILIZATION_3221641183281199106)],
        &[(0b01001, &ENTRY_VOLATILIZATIONS_8168537470161802057)],
        &[(0b01001, &ENTRY_VOLATILIZE_16270565871743863998)],
        &[(0b01001, &ENTRY_VOLATILIZED_13699473491173599192)],
        &[(0b01001, &ENTRY_VOLATILIZES_14953405067501371419)],
        &[(0b01001, &ENTRY_VOLATILIZING_9187797455588347418)],
    ],
    range: 6..=13,
};

static VARS_VI_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_VI_CHILDREN),
    value: None,
};

pub static VARS_VI_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ctimisation"),
        dictgen::InsensitiveAscii("ctimisations"),
        dictgen::InsensitiveAscii("ctimise"),
        dictgen::InsensitiveAscii("ctimised"),
        dictgen::InsensitiveAscii("ctimiser"),
        dictgen::InsensitiveAscii("ctimisers"),
        dictgen::InsensitiveAscii("ctimises"),
        dictgen::InsensitiveAscii("ctimising"),
        dictgen::InsensitiveAscii("ctimization"),
        dictgen::InsensitiveAscii("ctimizations"),
        dictgen::InsensitiveAscii("ctimize"),
        dictgen::InsensitiveAscii("ctimized"),
        dictgen::InsensitiveAscii("ctimizer"),
        dictgen::InsensitiveAscii("ctimizers"),
        dictgen::InsensitiveAscii("ctimizes"),
        dictgen::InsensitiveAscii("ctimizing"),
        dictgen::InsensitiveAscii("ctualed"),
        dictgen::InsensitiveAscii("ctualer"),
        dictgen::InsensitiveAscii("ctualers"),
        dictgen::InsensitiveAscii("ctualing"),
        dictgen::InsensitiveAscii("ctualled"),
        dictgen::InsensitiveAscii("ctualler"),
        dictgen::InsensitiveAscii("ctuallers"),
        dictgen::InsensitiveAscii("ctualling"),
        dictgen::InsensitiveAscii("deodisk"),
        dictgen::InsensitiveAscii("deodisks"),
        dictgen::InsensitiveAscii("gor"),
        dictgen::InsensitiveAscii("gors"),
        dictgen::InsensitiveAscii("gour"),
        dictgen::InsensitiveAscii("gours"),
        dictgen::InsensitiveAscii("rtuosoes"),
        dictgen::InsensitiveAscii("sualisable"),
        dictgen::InsensitiveAscii("sualisation"),
        dictgen::InsensitiveAscii("sualisations"),
        dictgen::InsensitiveAscii("sualise"),
        dictgen::InsensitiveAscii("sualised"),
        dictgen::InsensitiveAscii("sualises"),
        dictgen::InsensitiveAscii("sualising"),
        dictgen::InsensitiveAscii("sualizable"),
        dictgen::InsensitiveAscii("sualization"),
        dictgen::InsensitiveAscii("sualizations"),
        dictgen::InsensitiveAscii("sualize"),
        dictgen::InsensitiveAscii("sualized"),
        dictgen::InsensitiveAscii("sualizes"),
        dictgen::InsensitiveAscii("sualizing"),
        dictgen::InsensitiveAscii("talisation"),
        dictgen::InsensitiveAscii("talisations"),
        dictgen::InsensitiveAscii("talise"),
        dictgen::InsensitiveAscii("talised"),
        dictgen::InsensitiveAscii("talises"),
        dictgen::InsensitiveAscii("talising"),
        dictgen::InsensitiveAscii("talisings"),
        dictgen::InsensitiveAscii("talization"),
        dictgen::InsensitiveAscii("talizations"),
        dictgen::InsensitiveAscii("talize"),
        dictgen::InsensitiveAscii("talized"),
        dictgen::InsensitiveAscii("talizes"),
        dictgen::InsensitiveAscii("talizing"),
        dictgen::InsensitiveAscii("talizings"),
        dictgen::InsensitiveAscii("zor"),
        dictgen::InsensitiveAscii("zors"),
    ],
    values: &[
        &[(0b10010, &ENTRY_VICTIMIZATION_6473682179195269391)],
        &[(0b10010, &ENTRY_VICTIMIZATIONS_5670211910093257144)],
        &[(0b10010, &ENTRY_VICTIMIZE_17964381173204803563)],
        &[(0b10010, &ENTRY_VICTIMIZED_16785627582641973610)],
        &[(0b10010, &ENTRY_VICTIMIZER_15193367442648599657)],
        &[(0b10010, &ENTRY_VICTIMIZERS_1678778459889759577)],
        &[(0b10010, &ENTRY_VICTIMIZES_10527897189755188591)],
        &[(0b10010, &ENTRY_VICTIMIZING_2512377935106454315)],
        &[(0b01001, &ENTRY_VICTIMIZATION_6473682179195269391)],
        &[(0b01001, &ENTRY_VICTIMIZATIONS_5670211910093257144)],
        &[(0b01001, &ENTRY_VICTIMIZE_17964381173204803563)],
        &[(0b01001, &ENTRY_VICTIMIZED_16785627582641973610)],
        &[(0b01001, &ENTRY_VICTIMIZER_15193367442648599657)],
        &[(0b01001, &ENTRY_VICTIMIZERS_1678778459889759577)],
        &[(0b01001, &ENTRY_VICTIMIZES_10527897189755188591)],
        &[(0b01001, &ENTRY_VICTIMIZING_2512377935106454315)],
        &[(0b00001, &ENTRY_VICTUALED_15540819304108381987)],
        &[(0b00001, &ENTRY_VICTUALER_6653512003545303549)],
        &[(0b00001, &ENTRY_VICTUALERS_12039289652841636588)],
        &[(0b00001, &ENTRY_VICTUALING_15440302570998416657)],
        &[(0b11010, &ENTRY_VICTUALED_15540819304108381987)],
        &[(0b11010, &ENTRY_VICTUALER_6653512003545303549)],
        &[(0b11010, &ENTRY_VICTUALERS_12039289652841636588)],
        &[(0b11010, &ENTRY_VICTUALING_15440302570998416657)],
        &[(0b00001, &ENTRY_VIDEODISC_6353050125875667178)],
        &[(0b00001, &ENTRY_VIDEODISCS_16872815408295672812)],
        &[(0b11001, &ENTRY_VIGOR_15557932597045951621)],
        &[(0b11001, &ENTRY_VIGORS_2946830186019355206)],
        &[(0b11010, &ENTRY_VIGOR_15557932597045951621)],
        &[(0b11010, &ENTRY_VIGORS_2946830186019355206)],
        &[(0b00001, &ENTRY_VIRTUOSI_16194921273122969553)],
        &[(0b10010, &ENTRY_VISUALIZABLE_4488080677314869313)],
        &[(0b10010, &ENTRY_VISUALIZATION_17562130536164744176)],
        &[(0b10010, &ENTRY_VISUALIZATIONS_18350724909305357812)],
        &[(0b10010, &ENTRY_VISUALIZE_11481052441218524608)],
        &[(0b10010, &ENTRY_VISUALIZED_4674981066915252884)],
        &[(0b10010, &ENTRY_VISUALIZES_127948688781322581)],
        &[(0b10010, &ENTRY_VISUALIZING_8899358108480045240)],
        &[(0b01001, &ENTRY_VISUALIZABLE_4488080677314869313)],
        &[(0b01001, &ENTRY_VISUALIZATION_17562130536164744176)],
        &[(0b01001, &ENTRY_VISUALIZATIONS_18350724909305357812)],
        &[(0b01001, &ENTRY_VISUALIZE_11481052441218524608)],
        &[(0b01001, &ENTRY_VISUALIZED_4674981066915252884)],
        &[(0b01001, &ENTRY_VISUALIZES_127948688781322581)],
        &[(0b01001, &ENTRY_VISUALIZING_8899358108480045240)],
        &[(0b10010, &ENTRY_VITALIZATION_6622991581175063916)],
        &[(0b10010, &ENTRY_VITALIZATIONS_10201411925742357344)],
        &[(0b10010, &ENTRY_VITALIZE_6481155641390081467)],
        &[(0b10010, &ENTRY_VITALIZED_4801592680431520472)],
        &[(0b10010, &ENTRY_VITALIZES_3154160873090627908)],
        &[(0b10010, &ENTRY_VITALIZING_5684293940323598911)],
        &[(0b10010, &ENTRY_VITALIZINGS_3549538285617044596)],
        &[(0b01001, &ENTRY_VITALIZATION_6622991581175063916)],
        &[(0b01001, &ENTRY_VITALIZATIONS_10201411925742357344)],
        &[(0b01001, &ENTRY_VITALIZE_6481155641390081467)],
        &[(0b01001, &ENTRY_VITALIZED_4801592680431520472)],
        &[(0b01001, &ENTRY_VITALIZES_3154160873090627908)],
        &[(0b01001, &ENTRY_VITALIZING_5684293940323598911)],
        &[(0b01001, &ENTRY_VITALIZINGS_3549538285617044596)],
        &[(0b10011, &ENTRY_VISOR_6793712644535862367)],
        &[(0b10011, &ENTRY_VISORS_134473816422776887)],
    ],
    range: 3..=12,
};

static VARS_VE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_VE_CHILDREN),
    value: None,
};

pub static VARS_VE_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("nder"),
        dictgen::InsensitiveAscii("nders"),
        dictgen::InsensitiveAscii("ntriloquise"),
        dictgen::InsensitiveAscii("ntriloquised"),
        dictgen::InsensitiveAscii("ntriloquises"),
        dictgen::InsensitiveAscii("ntriloquising"),
        dictgen::InsensitiveAscii("ntriloquize"),
        dictgen::InsensitiveAscii("ntriloquized"),
        dictgen::InsensitiveAscii("ntriloquizes"),
        dictgen::InsensitiveAscii("ntriloquizing"),
        dictgen::InsensitiveAscii("rbalisation"),
        dictgen::InsensitiveAscii("rbalisations"),
        dictgen::InsensitiveAscii("rbalise"),
        dictgen::InsensitiveAscii("rbalised"),
        dictgen::InsensitiveAscii("rbaliser"),
        dictgen::InsensitiveAscii("rbalisers"),
        dictgen::InsensitiveAscii("rbalises"),
        dictgen::InsensitiveAscii("rbalising"),
        dictgen::InsensitiveAscii("rbalization"),
        dictgen::InsensitiveAscii("rbalizations"),
        dictgen::InsensitiveAscii("rbalize"),
        dictgen::InsensitiveAscii("rbalized"),
        dictgen::InsensitiveAscii("rbalizer"),
        dictgen::InsensitiveAscii("rbalizers"),
        dictgen::InsensitiveAscii("rbalizes"),
        dictgen::InsensitiveAscii("rbalizing"),
    ],
    values: &[
        &[(0b00001, &ENTRY_VENDOR_614257521164925268)],
        &[(0b00001, &ENTRY_VENDORS_1436950525202030326)],
        &[(0b10010, &ENTRY_VENTRILOQUIZE_6075592572709749127)],
        &[(0b10010, &ENTRY_VENTRILOQUIZED_3898326028561445962)],
        &[(0b10010, &ENTRY_VENTRILOQUIZES_221071050486777356)],
        &[(0b10010, &ENTRY_VENTRILOQUIZING_17870016245092386407)],
        &[(0b01001, &ENTRY_VENTRILOQUIZE_6075592572709749127)],
        &[(0b01001, &ENTRY_VENTRILOQUIZED_3898326028561445962)],
        &[(0b01001, &ENTRY_VENTRILOQUIZES_221071050486777356)],
        &[(0b01001, &ENTRY_VENTRILOQUIZING_17870016245092386407)],
        &[(0b10010, &ENTRY_VERBALIZATION_17014780536966514150)],
        &[(0b10010, &ENTRY_VERBALIZATIONS_2148556691017306909)],
        &[(0b10010, &ENTRY_VERBALIZE_1198319365461788046)],
        &[(0b10010, &ENTRY_VERBALIZED_10494008423617804243)],
        &[(0b10010, &ENTRY_VERBALIZER_4530481668094425579)],
        &[(0b10010, &ENTRY_VERBALIZERS_6929664897053786061)],
        &[(0b10010, &ENTRY_VERBALIZES_11158219462754520064)],
        &[(0b10010, &ENTRY_VERBALIZING_3065579017212147213)],
        &[(0b01001, &ENTRY_VERBALIZATION_17014780536966514150)],
        &[(0b01001, &ENTRY_VERBALIZATIONS_2148556691017306909)],
        &[(0b01001, &ENTRY_VERBALIZE_1198319365461788046)],
        &[(0b01001, &ENTRY_VERBALIZED_10494008423617804243)],
        &[(0b01001, &ENTRY_VERBALIZER_4530481668094425579)],
        &[(0b01001, &ENTRY_VERBALIZERS_6929664897053786061)],
        &[(0b01001, &ENTRY_VERBALIZES_11158219462754520064)],
        &[(0b01001, &ENTRY_VERBALIZING_3065579017212147213)],
    ],
    range: 4..=13,
};

static VARS_VA_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_VA_CHILDREN),
    value: None,
};

static VARS_VA_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_VAL_NODE),
    None,
    Some(&VARS_VAN_NODE),
    None,
    Some(&VARS_VAP_NODE),
    None,
    Some(&VARS_VAR_NODE),
    Some(&VARS_VAS_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_VAS_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_VAS_CHILDREN),
    value: None,
};

pub static VARS_VAS_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ectomise"),
        dictgen::InsensitiveAscii("ectomised"),
        dictgen::InsensitiveAscii("ectomising"),
        dictgen::InsensitiveAscii("ectomize"),
        dictgen::InsensitiveAscii("ectomized"),
        dictgen::InsensitiveAscii("ectomizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_VASECTOMIZE_14117059244189610141)],
        &[(0b10010, &ENTRY_VASECTOMIZED_9802783923443016839)],
        &[(0b10010, &ENTRY_VASECTOMIZING_9067814547217523949)],
        &[(0b01001, &ENTRY_VASECTOMIZE_14117059244189610141)],
        &[(0b01001, &ENTRY_VASECTOMIZED_9802783923443016839)],
        &[(0b01001, &ENTRY_VASECTOMIZING_9067814547217523949)],
    ],
    range: 8..=10,
};

static VARS_VAR_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_VAR_CHILDREN),
    value: None,
};

pub static VARS_VAR_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("icolored"),
        dictgen::InsensitiveAscii("icoloredder"),
        dictgen::InsensitiveAscii("icoloreddest"),
        dictgen::InsensitiveAscii("icoloreds"),
        dictgen::InsensitiveAscii("icoloured"),
        dictgen::InsensitiveAscii("icolouredder"),
        dictgen::InsensitiveAscii("icoloureddest"),
        dictgen::InsensitiveAscii("icoloureds"),
    ],
    values: &[
        &[(0b01001, &ENTRY_VARICOLORED_14826810108614522572)],
        &[(0b01001, &ENTRY_VARICOLOREDDER_17739587046028260965)],
        &[(0b01001, &ENTRY_VARICOLOREDDEST_13804238764633913841)],
        &[(0b01001, &ENTRY_VARICOLOREDS_11023757870916070482)],
        &[(0b11010, &ENTRY_VARICOLORED_14826810108614522572)],
        &[(0b11010, &ENTRY_VARICOLOREDDER_17739587046028260965)],
        &[(0b11010, &ENTRY_VARICOLOREDDEST_13804238764633913841)],
        &[(0b11010, &ENTRY_VARICOLOREDS_11023757870916070482)],
    ],
    range: 8..=13,
};

static VARS_VAP_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_VAP_CHILDREN),
    value: None,
};

pub static VARS_VAP_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("or"),
        dictgen::InsensitiveAscii("ored"),
        dictgen::InsensitiveAscii("oring"),
        dictgen::InsensitiveAscii("orings"),
        dictgen::InsensitiveAscii("orisation"),
        dictgen::InsensitiveAscii("orisations"),
        dictgen::InsensitiveAscii("orise"),
        dictgen::InsensitiveAscii("orised"),
        dictgen::InsensitiveAscii("oriser"),
        dictgen::InsensitiveAscii("orisers"),
        dictgen::InsensitiveAscii("orises"),
        dictgen::InsensitiveAscii("orising"),
        dictgen::InsensitiveAscii("orization"),
        dictgen::InsensitiveAscii("orizations"),
        dictgen::InsensitiveAscii("orize"),
        dictgen::InsensitiveAscii("orized"),
        dictgen::InsensitiveAscii("orizer"),
        dictgen::InsensitiveAscii("orizers"),
        dictgen::InsensitiveAscii("orizes"),
        dictgen::InsensitiveAscii("orizing"),
        dictgen::InsensitiveAscii("ors"),
        dictgen::InsensitiveAscii("orware"),
        dictgen::InsensitiveAscii("our"),
        dictgen::InsensitiveAscii("oured"),
        dictgen::InsensitiveAscii("ouring"),
        dictgen::InsensitiveAscii("ourings"),
        dictgen::InsensitiveAscii("ours"),
        dictgen::InsensitiveAscii("ourware"),
    ],
    values: &[
        &[(0b11001, &ENTRY_VAPOR_2186715544993402811)],
        &[(0b11001, &ENTRY_VAPORED_8090866757673721955)],
        &[(0b11001, &ENTRY_VAPORING_420257298669421065)],
        &[(0b11001, &ENTRY_VAPORINGS_1485515244068360371)],
        &[(0b10010, &ENTRY_VAPORIZATION_18013020655663665183)],
        &[(0b10010, &ENTRY_VAPORIZATIONS_16022234579712511195)],
        &[(0b10010, &ENTRY_VAPORIZE_3098164633633455886)],
        &[(0b10010, &ENTRY_VAPORIZED_15975626787835074281)],
        &[(0b10010, &ENTRY_VAPORIZER_2660185636167297891)],
        &[(0b10010, &ENTRY_VAPORIZERS_5986565178581788761)],
        &[(0b10010, &ENTRY_VAPORIZES_9602890245599971042)],
        &[(0b10010, &ENTRY_VAPORIZING_11567514291379105650)],
        &[(0b01001, &ENTRY_VAPORIZATION_18013020655663665183)],
        &[(0b01001, &ENTRY_VAPORIZATIONS_16022234579712511195)],
        &[(0b01001, &ENTRY_VAPORIZE_3098164633633455886)],
        &[(0b01001, &ENTRY_VAPORIZED_15975626787835074281)],
        &[(0b01001, &ENTRY_VAPORIZER_2660185636167297891)],
        &[(0b01001, &ENTRY_VAPORIZERS_5986565178581788761)],
        &[(0b01001, &ENTRY_VAPORIZES_9602890245599971042)],
        &[(0b01001, &ENTRY_VAPORIZING_11567514291379105650)],
        &[(0b11001, &ENTRY_VAPORS_10654457609159557123)],
        &[(0b01001, &ENTRY_VAPORWARE_9698524933063954413)],
        &[(0b11010, &ENTRY_VAPOR_2186715544993402811)],
        &[(0b11010, &ENTRY_VAPORED_8090866757673721955)],
        &[(0b11010, &ENTRY_VAPORING_420257298669421065)],
        &[(0b11010, &ENTRY_VAPORINGS_1485515244068360371)],
        &[(0b11010, &ENTRY_VAPORS_10654457609159557123)],
        &[(0b11010, &ENTRY_VAPORWARE_9698524933063954413)],
    ],
    range: 2..=10,
};

static VARS_VAN_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_VAN_CHILDREN),
    value: None,
};

pub static VARS_VAN_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("dalise"),
        dictgen::InsensitiveAscii("dalised"),
        dictgen::InsensitiveAscii("dalises"),
        dictgen::InsensitiveAscii("dalising"),
        dictgen::InsensitiveAscii("dalize"),
        dictgen::InsensitiveAscii("dalized"),
        dictgen::InsensitiveAscii("dalizes"),
        dictgen::InsensitiveAscii("dalizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_VANDALIZE_3654743374834615371)],
        &[(0b10010, &ENTRY_VANDALIZED_4895140872617125953)],
        &[(0b10010, &ENTRY_VANDALIZES_7396543552418251345)],
        &[(0b10010, &ENTRY_VANDALIZING_2999607049988004510)],
        &[(0b01001, &ENTRY_VANDALIZE_3654743374834615371)],
        &[(0b01001, &ENTRY_VANDALIZED_4895140872617125953)],
        &[(0b01001, &ENTRY_VANDALIZES_7396543552418251345)],
        &[(0b01001, &ENTRY_VANDALIZING_2999607049988004510)],
    ],
    range: 6..=8,
};

static VARS_VAL_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_VAL_CHILDREN),
    value: None,
};

pub static VARS_VAL_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("or"),
        dictgen::InsensitiveAscii("orisation"),
        dictgen::InsensitiveAscii("orisations"),
        dictgen::InsensitiveAscii("orise"),
        dictgen::InsensitiveAscii("orised"),
        dictgen::InsensitiveAscii("orises"),
        dictgen::InsensitiveAscii("orising"),
        dictgen::InsensitiveAscii("orization"),
        dictgen::InsensitiveAscii("orizations"),
        dictgen::InsensitiveAscii("orize"),
        dictgen::InsensitiveAscii("orized"),
        dictgen::InsensitiveAscii("orizes"),
        dictgen::InsensitiveAscii("orizing"),
        dictgen::InsensitiveAscii("ors"),
        dictgen::InsensitiveAscii("our"),
        dictgen::InsensitiveAscii("ours"),
    ],
    values: &[
        &[(0b11001, &ENTRY_VALOR_10381241029341969425)],
        &[(0b10010, &ENTRY_VALORIZATION_13227626070656104535)],
        &[(0b10010, &ENTRY_VALORIZATIONS_18099999439268061636)],
        &[(0b10010, &ENTRY_VALORIZE_2044080804493227048)],
        &[(0b10010, &ENTRY_VALORIZED_18268036447448640796)],
        &[(0b10010, &ENTRY_VALORIZES_8203138506905157861)],
        &[(0b10010, &ENTRY_VALORIZING_1072198845281593214)],
        &[(0b01001, &ENTRY_VALORIZATION_13227626070656104535)],
        &[(0b01001, &ENTRY_VALORIZATIONS_18099999439268061636)],
        &[(0b01001, &ENTRY_VALORIZE_2044080804493227048)],
        &[(0b01001, &ENTRY_VALORIZED_18268036447448640796)],
        &[(0b01001, &ENTRY_VALORIZES_8203138506905157861)],
        &[(0b01001, &ENTRY_VALORIZING_1072198845281593214)],
        &[(0b11001, &ENTRY_VALORS_9234945520471825890)],
        &[(0b11010, &ENTRY_VALOR_10381241029341969425)],
        &[(0b11010, &ENTRY_VALORS_9234945520471825890)],
    ],
    range: 2..=10,
};

static VARS_U_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_U_CHILDREN),
    value: None,
};

static VARS_U_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_UN_NODE),
    None,
    Some(&VARS_UP_NODE),
    None,
    Some(&VARS_UR_NODE),
    Some(&VARS_US_NODE),
    Some(&VARS_UT_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_UT_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_UT_CHILDREN),
    value: None,
};

pub static VARS_UT_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ilisable"),
        dictgen::InsensitiveAscii("ilisables"),
        dictgen::InsensitiveAscii("ilisation"),
        dictgen::InsensitiveAscii("ilisations"),
        dictgen::InsensitiveAscii("ilise"),
        dictgen::InsensitiveAscii("ilised"),
        dictgen::InsensitiveAscii("ilises"),
        dictgen::InsensitiveAscii("ilising"),
        dictgen::InsensitiveAscii("ilizable"),
        dictgen::InsensitiveAscii("ilizables"),
        dictgen::InsensitiveAscii("ilization"),
        dictgen::InsensitiveAscii("ilizations"),
        dictgen::InsensitiveAscii("ilize"),
        dictgen::InsensitiveAscii("ilized"),
        dictgen::InsensitiveAscii("ilizes"),
        dictgen::InsensitiveAscii("ilizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UTILIZABLE_6658429424042092500)],
        &[(0b10010, &ENTRY_UTILIZABLES_10040108748299984073)],
        &[(0b10010, &ENTRY_UTILIZATION_6568984108837424526)],
        &[(0b10010, &ENTRY_UTILIZATIONS_5213929250198924058)],
        &[(0b10010, &ENTRY_UTILIZE_10044375682174548784)],
        &[(0b10010, &ENTRY_UTILIZED_18374385558160803150)],
        &[(0b10010, &ENTRY_UTILIZES_17217644256000960699)],
        &[(0b10010, &ENTRY_UTILIZING_6570837818573449537)],
        &[(0b01001, &ENTRY_UTILIZABLE_6658429424042092500)],
        &[(0b01001, &ENTRY_UTILIZABLES_10040108748299984073)],
        &[(0b01001, &ENTRY_UTILIZATION_6568984108837424526)],
        &[(0b01001, &ENTRY_UTILIZATIONS_5213929250198924058)],
        &[(0b01001, &ENTRY_UTILIZE_10044375682174548784)],
        &[(0b01001, &ENTRY_UTILIZED_18374385558160803150)],
        &[(0b01001, &ENTRY_UTILIZES_17217644256000960699)],
        &[(0b01001, &ENTRY_UTILIZING_6570837818573449537)],
    ],
    range: 5..=10,
};

static VARS_US_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_US_CHILDREN),
    value: None,
};

pub static VARS_US_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[dictgen::InsensitiveAscii("eability")],
    values: &[&[(0b00001, &ENTRY_USABILITY_14697152389699662448)]],
    range: 8..=8,
};

static VARS_UR_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_UR_CHILDREN),
    value: None,
};

pub static VARS_UR_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("aemia"),
        dictgen::InsensitiveAscii("aemias"),
        dictgen::InsensitiveAscii("aemic"),
        dictgen::InsensitiveAscii("banisation"),
        dictgen::InsensitiveAscii("banisations"),
        dictgen::InsensitiveAscii("banise"),
        dictgen::InsensitiveAscii("banised"),
        dictgen::InsensitiveAscii("banises"),
        dictgen::InsensitiveAscii("banising"),
        dictgen::InsensitiveAscii("banization"),
        dictgen::InsensitiveAscii("banizations"),
        dictgen::InsensitiveAscii("banize"),
        dictgen::InsensitiveAscii("banized"),
        dictgen::InsensitiveAscii("banizes"),
        dictgen::InsensitiveAscii("banizing"),
        dictgen::InsensitiveAscii("emia"),
        dictgen::InsensitiveAscii("emias"),
        dictgen::InsensitiveAscii("emic"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UREMIA_18083383868084280126)],
        &[(0b10010, &ENTRY_UREMIAS_12816641380732423378)],
        &[(0b10010, &ENTRY_UREMIC_1443341952685545241)],
        &[(0b10010, &ENTRY_URBANIZATION_12387885989461849064)],
        &[(0b10010, &ENTRY_URBANIZATIONS_8711148164069228358)],
        &[(0b10010, &ENTRY_URBANIZE_7137294181980044513)],
        &[(0b10010, &ENTRY_URBANIZED_8452856878168803812)],
        &[(0b10010, &ENTRY_URBANIZES_10930122484117694307)],
        &[(0b10010, &ENTRY_URBANIZING_14508129715867395456)],
        &[(0b01001, &ENTRY_URBANIZATION_12387885989461849064)],
        &[(0b01001, &ENTRY_URBANIZATIONS_8711148164069228358)],
        &[(0b01001, &ENTRY_URBANIZE_7137294181980044513)],
        &[(0b01001, &ENTRY_URBANIZED_8452856878168803812)],
        &[(0b01001, &ENTRY_URBANIZES_10930122484117694307)],
        &[(0b01001, &ENTRY_URBANIZING_14508129715867395456)],
        &[(0b01001, &ENTRY_UREMIA_18083383868084280126)],
        &[(0b01001, &ENTRY_UREMIAS_12816641380732423378)],
        &[(0b01001, &ENTRY_UREMIC_1443341952685545241)],
    ],
    range: 4..=11,
};

static VARS_UP_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_UP_CHILDREN),
    value: None,
};

pub static VARS_UP_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("draft"),
        dictgen::InsensitiveAscii("drafts"),
        dictgen::InsensitiveAscii("draught"),
        dictgen::InsensitiveAscii("draughts"),
    ],
    values: &[
        &[(0b01001, &ENTRY_UPDRAFT_2544941178284387496)],
        &[(0b01001, &ENTRY_UPDRAFTS_3266150290118937286)],
        &[(0b11010, &ENTRY_UPDRAFT_2544941178284387496)],
        &[(0b11010, &ENTRY_UPDRAFTS_3266150290118937286)],
    ],
    range: 5..=8,
};

static VARS_UN_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_UN_CHILDREN),
    value: None,
};

static VARS_UN_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_UNA_NODE),
    None,
    Some(&VARS_UNC_NODE),
    Some(&VARS_UND_NODE),
    Some(&VARS_UNE_NODE),
    Some(&VARS_UNF_NODE),
    Some(&VARS_UNG_NODE),
    None,
    Some(&VARS_UNI_NODE),
    None,
    None,
    Some(&VARS_UNL_NODE),
    None,
    None,
    Some(&VARS_UNO_NODE),
    Some(&VARS_UNP_NODE),
    None,
    Some(&VARS_UNR_NODE),
    Some(&VARS_UNS_NODE),
    Some(&VARS_UNT_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_UNT_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_UNT_CHILDREN),
    value: None,
};

pub static VARS_UNT_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("rammeled"),
        dictgen::InsensitiveAscii("rammeledder"),
        dictgen::InsensitiveAscii("rammeleddest"),
        dictgen::InsensitiveAscii("rammelled"),
        dictgen::InsensitiveAscii("rammelledder"),
        dictgen::InsensitiveAscii("rammelleddest"),
    ],
    values: &[
        &[(0b00001, &ENTRY_UNTRAMMELED_10950501341680868626)],
        &[(0b00001, &ENTRY_UNTRAMMELEDDER_14704643385630931751)],
        &[(0b00001, &ENTRY_UNTRAMMELEDDEST_9165425453399950000)],
        &[(0b11010, &ENTRY_UNTRAMMELED_10950501341680868626)],
        &[(0b11010, &ENTRY_UNTRAMMELEDDER_14704643385630931751)],
        &[(0b11010, &ENTRY_UNTRAMMELEDDEST_9165425453399950000)],
    ],
    range: 8..=13,
};

static VARS_UNS_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_UNS_CHILDREN),
    value: None,
};

pub static VARS_UNS_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("avorier"),
        dictgen::InsensitiveAscii("avories"),
        dictgen::InsensitiveAscii("avoriest"),
        dictgen::InsensitiveAscii("avoriness"),
        dictgen::InsensitiveAscii("avorinesses"),
        dictgen::InsensitiveAscii("avory"),
        dictgen::InsensitiveAscii("avourier"),
        dictgen::InsensitiveAscii("avouries"),
        dictgen::InsensitiveAscii("avouriest"),
        dictgen::InsensitiveAscii("avouriness"),
        dictgen::InsensitiveAscii("avourinesses"),
        dictgen::InsensitiveAscii("avoury"),
        dictgen::InsensitiveAscii("pecialised"),
        dictgen::InsensitiveAscii("pecialisedder"),
        dictgen::InsensitiveAscii("pecialiseddest"),
        dictgen::InsensitiveAscii("pecialized"),
        dictgen::InsensitiveAscii("pecializedder"),
        dictgen::InsensitiveAscii("pecializeddest"),
    ],
    values: &[
        &[(0b01001, &ENTRY_UNSAVORIER_7566012794202894976)],
        &[(0b01001, &ENTRY_UNSAVORIES_13570256108415909776)],
        &[(0b01001, &ENTRY_UNSAVORIEST_18354309014937328323)],
        &[(0b00001, &ENTRY_UNSAVORINESS_10308314055531850628)],
        &[(0b00001, &ENTRY_UNSAVORINESSES_9146175498090621820)],
        &[(0b01001, &ENTRY_UNSAVORY_14080716095107745994)],
        &[(0b11010, &ENTRY_UNSAVORIER_7566012794202894976)],
        &[(0b11010, &ENTRY_UNSAVORIES_13570256108415909776)],
        &[(0b11010, &ENTRY_UNSAVORIEST_18354309014937328323)],
        &[(0b11010, &ENTRY_UNSAVORINESS_10308314055531850628)],
        &[(0b11010, &ENTRY_UNSAVORINESSES_9146175498090621820)],
        &[(0b11010, &ENTRY_UNSAVORY_14080716095107745994)],
        &[(0b10010, &ENTRY_UNSPECIALIZED_5465071604094517809)],
        &[(0b10010, &ENTRY_UNSPECIALIZEDDER_9071034409026977091)],
        &[(0b10010, &ENTRY_UNSPECIALIZEDDEST_8581399916465856628)],
        &[(0b01001, &ENTRY_UNSPECIALIZED_5465071604094517809)],
        &[(0b01001, &ENTRY_UNSPECIALIZEDDER_9071034409026977091)],
        &[(0b01001, &ENTRY_UNSPECIALIZEDDEST_8581399916465856628)],
    ],
    range: 5..=14,
};

static VARS_UNR_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_UNR_CHILDREN),
    value: None,
};

pub static VARS_UNR_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("aveled"),
        dictgen::InsensitiveAscii("aveling"),
        dictgen::InsensitiveAscii("avelled"),
        dictgen::InsensitiveAscii("avelling"),
        dictgen::InsensitiveAscii("ealisable"),
        dictgen::InsensitiveAscii("ealisables"),
        dictgen::InsensitiveAscii("ealise"),
        dictgen::InsensitiveAscii("ealised"),
        dictgen::InsensitiveAscii("ealises"),
        dictgen::InsensitiveAscii("ealising"),
        dictgen::InsensitiveAscii("ealisings"),
        dictgen::InsensitiveAscii("ealizable"),
        dictgen::InsensitiveAscii("ealizables"),
        dictgen::InsensitiveAscii("ealize"),
        dictgen::InsensitiveAscii("ealized"),
        dictgen::InsensitiveAscii("ealizes"),
        dictgen::InsensitiveAscii("ealizing"),
        dictgen::InsensitiveAscii("ealizings"),
        dictgen::InsensitiveAscii("ecognisable"),
        dictgen::InsensitiveAscii("ecognisabler"),
        dictgen::InsensitiveAscii("ecognisablest"),
        dictgen::InsensitiveAscii("ecognisably"),
        dictgen::InsensitiveAscii("ecognised"),
        dictgen::InsensitiveAscii("ecognizable"),
        dictgen::InsensitiveAscii("ecognizabler"),
        dictgen::InsensitiveAscii("ecognizablest"),
        dictgen::InsensitiveAscii("ecognizably"),
        dictgen::InsensitiveAscii("ecognized"),
        dictgen::InsensitiveAscii("ivaled"),
        dictgen::InsensitiveAscii("ivaledder"),
        dictgen::InsensitiveAscii("ivaleddest"),
        dictgen::InsensitiveAscii("ivalled"),
        dictgen::InsensitiveAscii("ivalledder"),
        dictgen::InsensitiveAscii("ivalleddest"),
    ],
    values: &[
        &[(0b00001, &ENTRY_UNRAVELED_903111391532922846)],
        &[(0b00001, &ENTRY_UNRAVELING_765040154842555334)],
        &[(0b11010, &ENTRY_UNRAVELED_903111391532922846)],
        &[(0b11010, &ENTRY_UNRAVELING_765040154842555334)],
        &[(0b10010, &ENTRY_UNREALIZABLE_11418766116297521465)],
        &[(0b10010, &ENTRY_UNREALIZABLES_11601733641828871347)],
        &[(0b10010, &ENTRY_UNREALIZE_13293507645818343125)],
        &[(0b10010, &ENTRY_UNREALIZED_13998697549380132918)],
        &[(0b10010, &ENTRY_UNREALIZES_16009560303031337105)],
        &[(0b10010, &ENTRY_UNREALIZING_14733349295903954205)],
        &[(0b10010, &ENTRY_UNREALIZINGS_7526494100193070690)],
        &[(0b01001, &ENTRY_UNREALIZABLE_11418766116297521465)],
        &[(0b01001, &ENTRY_UNREALIZABLES_11601733641828871347)],
        &[(0b01001, &ENTRY_UNREALIZE_13293507645818343125)],
        &[(0b01001, &ENTRY_UNREALIZED_13998697549380132918)],
        &[(0b01001, &ENTRY_UNREALIZES_16009560303031337105)],
        &[(0b01001, &ENTRY_UNREALIZING_14733349295903954205)],
        &[(0b01001, &ENTRY_UNREALIZINGS_7526494100193070690)],
        &[(0b10010, &ENTRY_UNRECOGNIZABLE_7821646033253824562)],
        &[(0b10010, &ENTRY_UNRECOGNIZABLER_16831988820104346693)],
        &[(0b10010, &ENTRY_UNRECOGNIZABLEST_3385202348855994373)],
        &[(0b10010, &ENTRY_UNRECOGNIZABLY_16907513329485194946)],
        &[(0b10010, &ENTRY_UNRECOGNIZED_291281988118866118)],
        &[(0b01001, &ENTRY_UNRECOGNIZABLE_7821646033253824562)],
        &[(0b01001, &ENTRY_UNRECOGNIZABLER_16831988820104346693)],
        &[(0b01001, &ENTRY_UNRECOGNIZABLEST_3385202348855994373)],
        &[(0b01001, &ENTRY_UNRECOGNIZABLY_16907513329485194946)],
        &[(0b01001, &ENTRY_UNRECOGNIZED_291281988118866118)],
        &[(0b00001, &ENTRY_UNRIVALED_7537208612931158340)],
        &[(0b00001, &ENTRY_UNRIVALEDDER_8854788039016975855)],
        &[(0b00001, &ENTRY_UNRIVALEDDEST_18237777950481518710)],
        &[(0b11010, &ENTRY_UNRIVALED_7537208612931158340)],
        &[(0b11010, &ENTRY_UNRIVALEDDER_8854788039016975855)],
        &[(0b11010, &ENTRY_UNRIVALEDDEST_18237777950481518710)],
    ],
    range: 6..=13,
};

static VARS_UNP_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_UNP_CHILDREN),
    value: None,
};

pub static VARS_UNP_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("asteurised"),
        dictgen::InsensitiveAscii("asteurized"),
        dictgen::InsensitiveAscii("racticed"),
        dictgen::InsensitiveAscii("racticedder"),
        dictgen::InsensitiveAscii("racticeddest"),
        dictgen::InsensitiveAscii("ractised"),
        dictgen::InsensitiveAscii("ractisedder"),
        dictgen::InsensitiveAscii("ractiseddest"),
        dictgen::InsensitiveAscii("ressurised"),
        dictgen::InsensitiveAscii("ressurized"),
        dictgen::InsensitiveAscii("ublicised"),
        dictgen::InsensitiveAscii("ublicized"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNPASTEURIZED_5265896385107446936)],
        &[(0b01001, &ENTRY_UNPASTEURIZED_5265896385107446936)],
        &[(0b01001, &ENTRY_UNPRACTICED_6794067215889205747)],
        &[(0b01001, &ENTRY_UNPRACTICEDDER_17255783698342166608)],
        &[(0b01001, &ENTRY_UNPRACTICEDDEST_12496382526145371505)],
        &[(0b11010, &ENTRY_UNPRACTICED_6794067215889205747)],
        &[(0b11010, &ENTRY_UNPRACTICEDDER_17255783698342166608)],
        &[(0b11010, &ENTRY_UNPRACTICEDDEST_12496382526145371505)],
        &[(0b10010, &ENTRY_UNPRESSURIZED_5109647751733072461)],
        &[(0b01001, &ENTRY_UNPRESSURIZED_5109647751733072461)],
        &[(0b10010, &ENTRY_UNPUBLICIZED_11411018472574932653)],
        &[(0b01001, &ENTRY_UNPUBLICIZED_11411018472574932653)],
    ],
    range: 8..=12,
};

static VARS_UNO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_UNO_CHILDREN),
    value: None,
};

pub static VARS_UNO_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("rganised"),
        dictgen::InsensitiveAscii("rganized"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNORGANIZED_11234215167570055764)],
        &[(0b01001, &ENTRY_UNORGANIZED_11234215167570055764)],
    ],
    range: 8..=8,
};

static VARS_UNL_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_UNL_CHILDREN),
    value: None,
};

pub static VARS_UNL_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("abeled"),
        dictgen::InsensitiveAscii("abeledder"),
        dictgen::InsensitiveAscii("abeleddest"),
        dictgen::InsensitiveAscii("abelled"),
        dictgen::InsensitiveAscii("abelledder"),
        dictgen::InsensitiveAscii("abelleddest"),
        dictgen::InsensitiveAscii("earnt"),
    ],
    values: &[
        &[(0b00001, &ENTRY_UNLABELED_5521478301443297379)],
        &[(0b00001, &ENTRY_UNLABELEDDER_14520124038825557406)],
        &[(0b00001, &ENTRY_UNLABELEDDEST_17384647877826400058)],
        &[(0b11010, &ENTRY_UNLABELED_5521478301443297379)],
        &[(0b11010, &ENTRY_UNLABELEDDER_14520124038825557406)],
        &[(0b11010, &ENTRY_UNLABELEDDEST_17384647877826400058)],
        &[(0b11010, &ENTRY_UNLEARNED_4424673437597791231)],
    ],
    range: 5..=11,
};

static VARS_UNI_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_UNI_CHILDREN),
    value: None,
};

pub static VARS_UNI_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("onisation"),
        dictgen::InsensitiveAscii("onisations"),
        dictgen::InsensitiveAscii("onise"),
        dictgen::InsensitiveAscii("onised"),
        dictgen::InsensitiveAscii("onises"),
        dictgen::InsensitiveAscii("onising"),
        dictgen::InsensitiveAscii("onization"),
        dictgen::InsensitiveAscii("onizations"),
        dictgen::InsensitiveAscii("onize"),
        dictgen::InsensitiveAscii("onized"),
        dictgen::InsensitiveAscii("onizes"),
        dictgen::InsensitiveAscii("onizing"),
        dictgen::InsensitiveAscii("versalisation"),
        dictgen::InsensitiveAscii("versalisations"),
        dictgen::InsensitiveAscii("versalise"),
        dictgen::InsensitiveAscii("versalised"),
        dictgen::InsensitiveAscii("versalises"),
        dictgen::InsensitiveAscii("versalising"),
        dictgen::InsensitiveAscii("versalization"),
        dictgen::InsensitiveAscii("versalizations"),
        dictgen::InsensitiveAscii("versalize"),
        dictgen::InsensitiveAscii("versalized"),
        dictgen::InsensitiveAscii("versalizes"),
        dictgen::InsensitiveAscii("versalizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNIONIZATION_2816931840848288400)],
        &[(0b10010, &ENTRY_UNIONIZATIONS_8188645564688971694)],
        &[(0b10010, &ENTRY_UNIONIZE_10414936899999594660)],
        &[(0b10010, &ENTRY_UNIONIZED_4300815435733718278)],
        &[(0b10010, &ENTRY_UNIONIZES_1566009791777584230)],
        &[(0b10010, &ENTRY_UNIONIZING_7690467481138958046)],
        &[(0b01001, &ENTRY_UNIONIZATION_2816931840848288400)],
        &[(0b01001, &ENTRY_UNIONIZATIONS_8188645564688971694)],
        &[(0b01001, &ENTRY_UNIONIZE_10414936899999594660)],
        &[(0b01001, &ENTRY_UNIONIZED_4300815435733718278)],
        &[(0b01001, &ENTRY_UNIONIZES_1566009791777584230)],
        &[(0b01001, &ENTRY_UNIONIZING_7690467481138958046)],
        &[(0b10010, &ENTRY_UNIVERSALIZATION_2454309767089738201)],
        &[(0b10010, &ENTRY_UNIVERSALIZATIONS_13530116854029584990)],
        &[(0b10010, &ENTRY_UNIVERSALIZE_14896798826234728638)],
        &[(0b10010, &ENTRY_UNIVERSALIZED_7596820744757624427)],
        &[(0b10010, &ENTRY_UNIVERSALIZES_7397422123387773820)],
        &[(0b10010, &ENTRY_UNIVERSALIZING_10782273614602618944)],
        &[(0b01001, &ENTRY_UNIVERSALIZATION_2454309767089738201)],
        &[(0b01001, &ENTRY_UNIVERSALIZATIONS_13530116854029584990)],
        &[(0b01001, &ENTRY_UNIVERSALIZE_14896798826234728638)],
        &[(0b01001, &ENTRY_UNIVERSALIZED_7596820744757624427)],
        &[(0b01001, &ENTRY_UNIVERSALIZES_7397422123387773820)],
        &[(0b01001, &ENTRY_UNIVERSALIZING_10782273614602618944)],
    ],
    range: 5..=14,
};

static VARS_UNG_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_UNG_CHILDREN),
    value: None,
};

pub static VARS_UNG_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[dictgen::InsensitiveAscii("lamourous")],
    values: &[&[(0b11010, &ENTRY_UNGLAMOROUS_17159152581421977091)]],
    range: 9..=9,
};

static VARS_UNF_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_UNF_CHILDREN),
    value: None,
};

pub static VARS_UNF_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("avorable"),
        dictgen::InsensitiveAscii("avorabler"),
        dictgen::InsensitiveAscii("avorables"),
        dictgen::InsensitiveAscii("avorablest"),
        dictgen::InsensitiveAscii("avorablier"),
        dictgen::InsensitiveAscii("avorabliest"),
        dictgen::InsensitiveAscii("avorably"),
        dictgen::InsensitiveAscii("avourable"),
        dictgen::InsensitiveAscii("avourabler"),
        dictgen::InsensitiveAscii("avourables"),
        dictgen::InsensitiveAscii("avourablest"),
        dictgen::InsensitiveAscii("avourablier"),
        dictgen::InsensitiveAscii("avourabliest"),
        dictgen::InsensitiveAscii("avourably"),
        dictgen::InsensitiveAscii("ertilised"),
        dictgen::InsensitiveAscii("ertilisedder"),
        dictgen::InsensitiveAscii("ertiliseddest"),
        dictgen::InsensitiveAscii("ertilized"),
        dictgen::InsensitiveAscii("ertilizedder"),
        dictgen::InsensitiveAscii("ertilizeddest"),
        dictgen::InsensitiveAscii("lavored"),
        dictgen::InsensitiveAscii("lavoredder"),
        dictgen::InsensitiveAscii("lavoreddest"),
        dictgen::InsensitiveAscii("lavoured"),
        dictgen::InsensitiveAscii("lavouredder"),
        dictgen::InsensitiveAscii("lavoureddest"),
    ],
    values: &[
        &[(0b11001, &ENTRY_UNFAVORABLE_5650317643174313946)],
        &[(0b11001, &ENTRY_UNFAVORABLER_8407653781350191045)],
        &[(0b11001, &ENTRY_UNFAVORABLES_245237680247907199)],
        &[(0b11001, &ENTRY_UNFAVORABLEST_8329180226725391402)],
        &[(0b11001, &ENTRY_UNFAVORABLIER_5445832020764674982)],
        &[(0b11001, &ENTRY_UNFAVORABLIEST_9135988438022295109)],
        &[(0b11001, &ENTRY_UNFAVORABLY_4995649989227121664)],
        &[(0b11010, &ENTRY_UNFAVORABLE_5650317643174313946)],
        &[(0b11010, &ENTRY_UNFAVORABLER_8407653781350191045)],
        &[(0b11010, &ENTRY_UNFAVORABLES_245237680247907199)],
        &[(0b11010, &ENTRY_UNFAVORABLEST_8329180226725391402)],
        &[(0b11010, &ENTRY_UNFAVORABLIER_5445832020764674982)],
        &[(0b11010, &ENTRY_UNFAVORABLIEST_9135988438022295109)],
        &[(0b11010, &ENTRY_UNFAVORABLY_4995649989227121664)],
        &[(0b10010, &ENTRY_UNFERTILIZED_1896012193898147315)],
        &[(0b10010, &ENTRY_UNFERTILIZEDDER_3962795259989687011)],
        &[(0b10010, &ENTRY_UNFERTILIZEDDEST_16794644706411544184)],
        &[(0b01001, &ENTRY_UNFERTILIZED_1896012193898147315)],
        &[(0b01001, &ENTRY_UNFERTILIZEDDER_3962795259989687011)],
        &[(0b01001, &ENTRY_UNFERTILIZEDDEST_16794644706411544184)],
        &[(0b11001, &ENTRY_UNFLAVORED_9672896276378072278)],
        &[(0b11001, &ENTRY_UNFLAVOREDDER_8175850200918329116)],
        &[(0b11001, &ENTRY_UNFLAVOREDDEST_5088848224529312235)],
        &[(0b11010, &ENTRY_UNFLAVORED_9672896276378072278)],
        &[(0b11010, &ENTRY_UNFLAVOREDDER_8175850200918329116)],
        &[(0b11010, &ENTRY_UNFLAVOREDDEST_5088848224529312235)],
    ],
    range: 7..=13,
};

static VARS_UNE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_UNE_CHILDREN),
    value: None,
};

pub static VARS_UNE_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("qualed"),
        dictgen::InsensitiveAscii("qualedder"),
        dictgen::InsensitiveAscii("qualeddest"),
        dictgen::InsensitiveAscii("qualled"),
        dictgen::InsensitiveAscii("qualledder"),
        dictgen::InsensitiveAscii("qualleddest"),
    ],
    values: &[
        &[(0b00001, &ENTRY_UNEQUALED_13151580965074494682)],
        &[(0b00001, &ENTRY_UNEQUALEDDER_6427424448868113114)],
        &[(0b00001, &ENTRY_UNEQUALEDDEST_2906178077931186884)],
        &[(0b11010, &ENTRY_UNEQUALED_13151580965074494682)],
        &[(0b11010, &ENTRY_UNEQUALEDDER_6427424448868113114)],
        &[(0b11010, &ENTRY_UNEQUALEDDEST_2906178077931186884)],
    ],
    range: 6..=11,
};

static VARS_UND_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_UND_CHILDREN),
    value: None,
};

pub static VARS_UND_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("eremphasise"),
        dictgen::InsensitiveAscii("eremphasised"),
        dictgen::InsensitiveAscii("eremphasises"),
        dictgen::InsensitiveAscii("eremphasising"),
        dictgen::InsensitiveAscii("eremphasize"),
        dictgen::InsensitiveAscii("eremphasized"),
        dictgen::InsensitiveAscii("eremphasizes"),
        dictgen::InsensitiveAscii("eremphasizing"),
        dictgen::InsensitiveAscii("erutilisation"),
        dictgen::InsensitiveAscii("erutilisations"),
        dictgen::InsensitiveAscii("erutilise"),
        dictgen::InsensitiveAscii("erutilised"),
        dictgen::InsensitiveAscii("erutilises"),
        dictgen::InsensitiveAscii("erutilising"),
        dictgen::InsensitiveAscii("erutilization"),
        dictgen::InsensitiveAscii("erutilizations"),
        dictgen::InsensitiveAscii("erutilize"),
        dictgen::InsensitiveAscii("erutilized"),
        dictgen::InsensitiveAscii("erutilizes"),
        dictgen::InsensitiveAscii("erutilizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNDEREMPHASIZE_113262683283266999)],
        &[(0b10010, &ENTRY_UNDEREMPHASIZED_16225182233832818906)],
        &[(0b10010, &ENTRY_UNDEREMPHASIZES_15383330958221639486)],
        &[(0b10010, &ENTRY_UNDEREMPHASIZING_8500735646633380499)],
        &[(0b01001, &ENTRY_UNDEREMPHASIZE_113262683283266999)],
        &[(0b01001, &ENTRY_UNDEREMPHASIZED_16225182233832818906)],
        &[(0b01001, &ENTRY_UNDEREMPHASIZES_15383330958221639486)],
        &[(0b01001, &ENTRY_UNDEREMPHASIZING_8500735646633380499)],
        &[(0b10010, &ENTRY_UNDERUTILIZATION_14694691541150582602)],
        &[(0b10010, &ENTRY_UNDERUTILIZATIONS_16994081773856805411)],
        &[(0b10010, &ENTRY_UNDERUTILIZE_12788386196891414227)],
        &[(0b10010, &ENTRY_UNDERUTILIZED_11374623631374378006)],
        &[(0b10010, &ENTRY_UNDERUTILIZES_10200345077765075455)],
        &[(0b10010, &ENTRY_UNDERUTILIZING_8716553292659107585)],
        &[(0b01001, &ENTRY_UNDERUTILIZATION_14694691541150582602)],
        &[(0b01001, &ENTRY_UNDERUTILIZATIONS_16994081773856805411)],
        &[(0b01001, &ENTRY_UNDERUTILIZE_12788386196891414227)],
        &[(0b01001, &ENTRY_UNDERUTILIZED_11374623631374378006)],
        &[(0b01001, &ENTRY_UNDERUTILIZES_10200345077765075455)],
        &[(0b01001, &ENTRY_UNDERUTILIZING_8716553292659107585)],
    ],
    range: 9..=14,
};

static VARS_UNC_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_UNC_CHILDREN),
    value: None,
};

pub static VARS_UNC_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ivilised"),
        dictgen::InsensitiveAscii("ivilized"),
        dictgen::InsensitiveAscii("olored"),
        dictgen::InsensitiveAscii("oloredder"),
        dictgen::InsensitiveAscii("oloreddest"),
        dictgen::InsensitiveAscii("oloreds"),
        dictgen::InsensitiveAscii("oloured"),
        dictgen::InsensitiveAscii("olouredder"),
        dictgen::InsensitiveAscii("oloureddest"),
        dictgen::InsensitiveAscii("oloureds"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNCIVILIZED_11842993558173640265)],
        &[(0b01001, &ENTRY_UNCIVILIZED_11842993558173640265)],
        &[(0b11001, &ENTRY_UNCOLORED_5376239934140006972)],
        &[(0b11001, &ENTRY_UNCOLOREDDER_7581046306117193660)],
        &[(0b11001, &ENTRY_UNCOLOREDDEST_2266252169475963598)],
        &[(0b11001, &ENTRY_UNCOLOREDS_17448592794042459595)],
        &[(0b11010, &ENTRY_UNCOLORED_5376239934140006972)],
        &[(0b11010, &ENTRY_UNCOLOREDDER_7581046306117193660)],
        &[(0b11010, &ENTRY_UNCOLOREDDEST_2266252169475963598)],
        &[(0b11010, &ENTRY_UNCOLOREDS_17448592794042459595)],
    ],
    range: 6..=11,
};

static VARS_UNA_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_UNA_CHILDREN),
    value: None,
};

pub static VARS_UNA_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ppetising"),
        dictgen::InsensitiveAscii("ppetisinger"),
        dictgen::InsensitiveAscii("ppetisingest"),
        dictgen::InsensitiveAscii("ppetisinglier"),
        dictgen::InsensitiveAscii("ppetisingliest"),
        dictgen::InsensitiveAscii("ppetisingly"),
        dictgen::InsensitiveAscii("ppetizing"),
        dictgen::InsensitiveAscii("ppetizinger"),
        dictgen::InsensitiveAscii("ppetizingest"),
        dictgen::InsensitiveAscii("ppetizinglier"),
        dictgen::InsensitiveAscii("ppetizingliest"),
        dictgen::InsensitiveAscii("ppetizingly"),
        dictgen::InsensitiveAscii("uthorised"),
        dictgen::InsensitiveAscii("uthorisedder"),
        dictgen::InsensitiveAscii("uthoriseddest"),
        dictgen::InsensitiveAscii("uthorized"),
        dictgen::InsensitiveAscii("uthorizedder"),
        dictgen::InsensitiveAscii("uthorizeddest"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNAPPETIZING_17929454627207091337)],
        &[(0b10010, &ENTRY_UNAPPETIZINGER_8263527658294102086)],
        &[(0b10010, &ENTRY_UNAPPETIZINGEST_10792936073593456042)],
        &[(0b10010, &ENTRY_UNAPPETIZINGLIER_5664751833539432448)],
        &[(0b10010, &ENTRY_UNAPPETIZINGLIEST_17210870251486801769)],
        &[(0b10010, &ENTRY_UNAPPETIZINGLY_3201479097994435826)],
        &[(0b01001, &ENTRY_UNAPPETIZING_17929454627207091337)],
        &[(0b01001, &ENTRY_UNAPPETIZINGER_8263527658294102086)],
        &[(0b01001, &ENTRY_UNAPPETIZINGEST_10792936073593456042)],
        &[(0b01001, &ENTRY_UNAPPETIZINGLIER_5664751833539432448)],
        &[(0b01001, &ENTRY_UNAPPETIZINGLIEST_17210870251486801769)],
        &[(0b01001, &ENTRY_UNAPPETIZINGLY_3201479097994435826)],
        &[(0b10010, &ENTRY_UNAUTHORIZED_1030895852257832941)],
        &[(0b10010, &ENTRY_UNAUTHORIZEDDER_6601639422567613002)],
        &[(0b10010, &ENTRY_UNAUTHORIZEDDEST_4803048533625012750)],
        &[(0b01001, &ENTRY_UNAUTHORIZED_1030895852257832941)],
        &[(0b01001, &ENTRY_UNAUTHORIZEDDER_6601639422567613002)],
        &[(0b01001, &ENTRY_UNAUTHORIZEDDEST_4803048533625012750)],
    ],
    range: 9..=14,
};

static VARS_T_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_T_CHILDREN),
    value: None,
};

static VARS_T_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_TA_NODE),
    None,
    None,
    None,
    Some(&VARS_TE_NODE),
    None,
    None,
    Some(&VARS_TH_NODE),
    Some(&VARS_TI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_TO_NODE),
    None,
    None,
    Some(&VARS_TR_NODE),
    None,
    None,
    Some(&VARS_TU_NODE),
    None,
    None,
    None,
    Some(&VARS_TY_NODE),
    Some(&VARS_TZ_NODE),
];

static VARS_TZ_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_TZ_CHILDREN),
    value: None,
};

pub static VARS_TZ_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ar"),
        dictgen::InsensitiveAscii("ars"),
    ],
    values: &[
        &[(0b10011, &ENTRY_CZAR_10918908885952851126)],
        &[(0b10011, &ENTRY_CZARS_17220740917194786378)],
    ],
    range: 2..=3,
};

static VARS_TY_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_TY_CHILDREN),
    value: None,
};

pub static VARS_TY_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("rannise"),
        dictgen::InsensitiveAscii("rannised"),
        dictgen::InsensitiveAscii("rannises"),
        dictgen::InsensitiveAscii("rannising"),
        dictgen::InsensitiveAscii("rannisings"),
        dictgen::InsensitiveAscii("rannize"),
        dictgen::InsensitiveAscii("rannized"),
        dictgen::InsensitiveAscii("rannizes"),
        dictgen::InsensitiveAscii("rannizing"),
        dictgen::InsensitiveAscii("rannizings"),
        dictgen::InsensitiveAscii("re"),
        dictgen::InsensitiveAscii("res"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TYRANNIZE_1000053221538931404)],
        &[(0b10010, &ENTRY_TYRANNIZED_10508710200970438760)],
        &[(0b10010, &ENTRY_TYRANNIZES_9564723788181665646)],
        &[(0b10010, &ENTRY_TYRANNIZING_1392868749194607551)],
        &[(0b10010, &ENTRY_TYRANNIZINGS_338643871377770319)],
        &[(0b01001, &ENTRY_TYRANNIZE_1000053221538931404)],
        &[(0b01001, &ENTRY_TYRANNIZED_10508710200970438760)],
        &[(0b01001, &ENTRY_TYRANNIZES_9564723788181665646)],
        &[(0b01001, &ENTRY_TYRANNIZING_1392868749194607551)],
        &[(0b01001, &ENTRY_TYRANNIZINGS_338643871377770319)],
        &[(0b10010, &ENTRY_TIRE_6240813028329445155)],
        &[(0b10010, &ENTRY_TIRES_4841205171088418079)],
    ],
    range: 2..=10,
};

static VARS_TU_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_TU_CHILDREN),
    value: None,
};

pub static VARS_TU_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("laraemia"),
        dictgen::InsensitiveAscii("laraemias"),
        dictgen::InsensitiveAscii("laremia"),
        dictgen::InsensitiveAscii("laremias"),
        dictgen::InsensitiveAscii("mor"),
        dictgen::InsensitiveAscii("mors"),
        dictgen::InsensitiveAscii("mour"),
        dictgen::InsensitiveAscii("mours"),
        dictgen::InsensitiveAscii("nneled"),
        dictgen::InsensitiveAscii("nneler"),
        dictgen::InsensitiveAscii("nnelers"),
        dictgen::InsensitiveAscii("nneling"),
        dictgen::InsensitiveAscii("nnelings"),
        dictgen::InsensitiveAscii("nnelled"),
        dictgen::InsensitiveAscii("nneller"),
        dictgen::InsensitiveAscii("nnellers"),
        dictgen::InsensitiveAscii("nnelling"),
        dictgen::InsensitiveAscii("nnellings"),
    ],
    values: &[
        &[(0b11010, &ENTRY_TULAREMIA_15946480059849647392)],
        &[(0b11010, &ENTRY_TULAREMIAS_3114003671274129745)],
        &[(0b01001, &ENTRY_TULAREMIA_15946480059849647392)],
        &[(0b01001, &ENTRY_TULAREMIAS_3114003671274129745)],
        &[(0b11001, &ENTRY_TUMOR_18208195035577206669)],
        &[(0b11001, &ENTRY_TUMORS_823212688865744384)],
        &[(0b11010, &ENTRY_TUMOR_18208195035577206669)],
        &[(0b11010, &ENTRY_TUMORS_823212688865744384)],
        &[(0b00001, &ENTRY_TUNNELED_11370086013695475785)],
        &[(0b00001, &ENTRY_TUNNELER_14964877288873936262)],
        &[(0b00001, &ENTRY_TUNNELERS_17425429561485837672)],
        &[(0b00001, &ENTRY_TUNNELING_8449736644402875370)],
        &[(0b00001, &ENTRY_TUNNELINGS_14406089909159685424)],
        &[(0b11010, &ENTRY_TUNNELED_11370086013695475785)],
        &[(0b11010, &ENTRY_TUNNELER_14964877288873936262)],
        &[(0b11010, &ENTRY_TUNNELERS_17425429561485837672)],
        &[(0b11010, &ENTRY_TUNNELING_8449736644402875370)],
        &[(0b11010, &ENTRY_TUNNELINGS_14406089909159685424)],
    ],
    range: 3..=9,
};

static VARS_TR_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_TR_CHILDREN),
    value: None,
};

static VARS_TR_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_TRA_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_TRI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_TRO_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_TRO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_TRO_CHILDREN),
    value: None,
};

pub static VARS_TRO_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("llied"),
        dictgen::InsensitiveAscii("llies"),
        dictgen::InsensitiveAscii("lly"),
        dictgen::InsensitiveAscii("llying"),
        dictgen::InsensitiveAscii("weled"),
        dictgen::InsensitiveAscii("weling"),
        dictgen::InsensitiveAscii("welled"),
        dictgen::InsensitiveAscii("welling"),
    ],
    values: &[
        &[(0b01001, &ENTRY_TROLLEYED_2326301207880015686)],
        &[(0b01001, &ENTRY_TROLLEYS_15846935468965102939)],
        &[(0b01001, &ENTRY_TROLLEY_2675453022762314926)],
        &[(0b01001, &ENTRY_TROLLEYING_17091158982650946031)],
        &[(0b00001, &ENTRY_TROWELED_16175988571968784498)],
        &[(0b00001, &ENTRY_TROWELING_8006341101894809093)],
        &[(0b11010, &ENTRY_TROWELED_16175988571968784498)],
        &[(0b11010, &ENTRY_TROWELING_8006341101894809093)],
    ],
    range: 3..=7,
};

static VARS_TRI_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_TRI_CHILDREN),
    value: None,
};

pub static VARS_TRI_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("aled"),
        dictgen::InsensitiveAscii("aling"),
        dictgen::InsensitiveAscii("alled"),
        dictgen::InsensitiveAscii("alling"),
        dictgen::InsensitiveAscii("vialisation"),
        dictgen::InsensitiveAscii("vialisations"),
        dictgen::InsensitiveAscii("vialise"),
        dictgen::InsensitiveAscii("vialised"),
        dictgen::InsensitiveAscii("vialises"),
        dictgen::InsensitiveAscii("vialising"),
        dictgen::InsensitiveAscii("vialization"),
        dictgen::InsensitiveAscii("vializations"),
        dictgen::InsensitiveAscii("vialize"),
        dictgen::InsensitiveAscii("vialized"),
        dictgen::InsensitiveAscii("vializes"),
        dictgen::InsensitiveAscii("vializing"),
    ],
    values: &[
        &[(0b00001, &ENTRY_TRIALED_10369074344397465464)],
        &[(0b00001, &ENTRY_TRIALING_1943354202061564251)],
        &[(0b11010, &ENTRY_TRIALED_10369074344397465464)],
        &[(0b11010, &ENTRY_TRIALING_1943354202061564251)],
        &[(0b10010, &ENTRY_TRIVIALIZATION_11133234604148815742)],
        &[(0b10010, &ENTRY_TRIVIALIZATIONS_17093718113863109033)],
        &[(0b10010, &ENTRY_TRIVIALIZE_13642761010371027521)],
        &[(0b10010, &ENTRY_TRIVIALIZED_8435647137273948084)],
        &[(0b10010, &ENTRY_TRIVIALIZES_11774779970344017336)],
        &[(0b10010, &ENTRY_TRIVIALIZING_17871312244441571781)],
        &[(0b01001, &ENTRY_TRIVIALIZATION_11133234604148815742)],
        &[(0b01001, &ENTRY_TRIVIALIZATIONS_17093718113863109033)],
        &[(0b01001, &ENTRY_TRIVIALIZE_13642761010371027521)],
        &[(0b01001, &ENTRY_TRIVIALIZED_8435647137273948084)],
        &[(0b01001, &ENTRY_TRIVIALIZES_11774779970344017336)],
        &[(0b01001, &ENTRY_TRIVIALIZING_17871312244441571781)],
    ],
    range: 4..=12,
};

static VARS_TRA_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_TRA_CHILDREN),
    value: None,
};

pub static VARS_TRA_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("mmeled"),
        dictgen::InsensitiveAscii("mmeling"),
        dictgen::InsensitiveAscii("mmelled"),
        dictgen::InsensitiveAscii("mmelling"),
        dictgen::InsensitiveAscii("nquilize"),
        dictgen::InsensitiveAscii("nquilized"),
        dictgen::InsensitiveAscii("nquilizer"),
        dictgen::InsensitiveAscii("nquilizers"),
        dictgen::InsensitiveAscii("nquilizes"),
        dictgen::InsensitiveAscii("nquilizing"),
        dictgen::InsensitiveAscii("nquilizings"),
        dictgen::InsensitiveAscii("nquillise"),
        dictgen::InsensitiveAscii("nquillised"),
        dictgen::InsensitiveAscii("nquilliser"),
        dictgen::InsensitiveAscii("nquillisers"),
        dictgen::InsensitiveAscii("nquillises"),
        dictgen::InsensitiveAscii("nquillising"),
        dictgen::InsensitiveAscii("nquillisings"),
        dictgen::InsensitiveAscii("nquillities"),
        dictgen::InsensitiveAscii("nquillity"),
        dictgen::InsensitiveAscii("nquillize"),
        dictgen::InsensitiveAscii("nquillized"),
        dictgen::InsensitiveAscii("nquillizer"),
        dictgen::InsensitiveAscii("nquillizers"),
        dictgen::InsensitiveAscii("nquillizes"),
        dictgen::InsensitiveAscii("nquillizing"),
        dictgen::InsensitiveAscii("nquillizings"),
        dictgen::InsensitiveAscii("nsistorise"),
        dictgen::InsensitiveAscii("nsistorised"),
        dictgen::InsensitiveAscii("nsistorises"),
        dictgen::InsensitiveAscii("nsistorising"),
        dictgen::InsensitiveAscii("nsistorize"),
        dictgen::InsensitiveAscii("nsistorized"),
        dictgen::InsensitiveAscii("nsistorizes"),
        dictgen::InsensitiveAscii("nsistorizing"),
        dictgen::InsensitiveAscii("umatisation"),
        dictgen::InsensitiveAscii("umatisations"),
        dictgen::InsensitiveAscii("umatise"),
        dictgen::InsensitiveAscii("umatised"),
        dictgen::InsensitiveAscii("umatises"),
        dictgen::InsensitiveAscii("umatising"),
        dictgen::InsensitiveAscii("umatization"),
        dictgen::InsensitiveAscii("umatizations"),
        dictgen::InsensitiveAscii("umatize"),
        dictgen::InsensitiveAscii("umatized"),
        dictgen::InsensitiveAscii("umatizes"),
        dictgen::InsensitiveAscii("umatizing"),
        dictgen::InsensitiveAscii("veled"),
        dictgen::InsensitiveAscii("veler"),
        dictgen::InsensitiveAscii("velers"),
        dictgen::InsensitiveAscii("veling"),
        dictgen::InsensitiveAscii("velings"),
        dictgen::InsensitiveAscii("velled"),
        dictgen::InsensitiveAscii("veller"),
        dictgen::InsensitiveAscii("vellers"),
        dictgen::InsensitiveAscii("velling"),
        dictgen::InsensitiveAscii("vellings"),
        dictgen::InsensitiveAscii("velog"),
        dictgen::InsensitiveAscii("velogs"),
    ],
    values: &[
        &[(0b01001, &ENTRY_TRAMMELED_8060808627087874636)],
        &[(0b01001, &ENTRY_TRAMMELING_6888018546127671609)],
        &[(0b11010, &ENTRY_TRAMMELED_8060808627087874636)],
        &[(0b11010, &ENTRY_TRAMMELING_6888018546127671609)],
        &[(0b01001, &ENTRY_TRANQUILIZE_2318549175902793795)],
        &[(0b01001, &ENTRY_TRANQUILIZED_12211443123255939369)],
        &[(0b01001, &ENTRY_TRANQUILIZER_4580963450554408865)],
        &[(0b01001, &ENTRY_TRANQUILIZERS_9011655985998697530)],
        &[(0b01001, &ENTRY_TRANQUILIZES_8944342824362588640)],
        &[(0b01001, &ENTRY_TRANQUILIZING_16473900108179388526)],
        &[(0b01001, &ENTRY_TRANQUILIZINGS_14161142259051334768)],
        &[(0b11010, &ENTRY_TRANQUILIZE_2318549175902793795)],
        &[(0b11010, &ENTRY_TRANQUILIZED_12211443123255939369)],
        &[(0b11010, &ENTRY_TRANQUILIZER_4580963450554408865)],
        &[(0b11010, &ENTRY_TRANQUILIZERS_9011655985998697530)],
        &[(0b11010, &ENTRY_TRANQUILIZES_8944342824362588640)],
        &[(0b11010, &ENTRY_TRANQUILIZING_16473900108179388526)],
        &[(0b11010, &ENTRY_TRANQUILIZINGS_14161142259051334768)],
        &[(0b10011, &ENTRY_TRANQUILITIES_14597029814491190009)],
        &[(0b10011, &ENTRY_TRANQUILITY_17026669099016984269)],
        &[(0b01001, &ENTRY_TRANQUILIZE_2318549175902793795)],
        &[(0b01001, &ENTRY_TRANQUILIZED_12211443123255939369)],
        &[(0b01001, &ENTRY_TRANQUILIZER_4580963450554408865)],
        &[(0b01001, &ENTRY_TRANQUILIZERS_9011655985998697530)],
        &[(0b01001, &ENTRY_TRANQUILIZES_8944342824362588640)],
        &[(0b01001, &ENTRY_TRANQUILIZING_16473900108179388526)],
        &[(0b01001, &ENTRY_TRANQUILIZINGS_14161142259051334768)],
        &[(0b10010, &ENTRY_TRANSISTORIZE_10887604825192662062)],
        &[(0b10010, &ENTRY_TRANSISTORIZED_6257541205718300499)],
        &[(0b10010, &ENTRY_TRANSISTORIZES_5429831375135101974)],
        &[(0b10010, &ENTRY_TRANSISTORIZING_15414761324720715044)],
        &[(0b01001, &ENTRY_TRANSISTORIZE_10887604825192662062)],
        &[(0b01001, &ENTRY_TRANSISTORIZED_6257541205718300499)],
        &[(0b01001, &ENTRY_TRANSISTORIZES_5429831375135101974)],
        &[(0b01001, &ENTRY_TRANSISTORIZING_15414761324720715044)],
        &[(0b10010, &ENTRY_TRAUMATIZATION_15736086621227074923)],
        &[(0b10010, &ENTRY_TRAUMATIZATIONS_4401483376475543285)],
        &[(0b10010, &ENTRY_TRAUMATIZE_7046895873965760654)],
        &[(0b10010, &ENTRY_TRAUMATIZED_625907274700949941)],
        &[(0b10010, &ENTRY_TRAUMATIZES_1060950316018981423)],
        &[(0b10010, &ENTRY_TRAUMATIZING_11107301809578264309)],
        &[(0b01001, &ENTRY_TRAUMATIZATION_15736086621227074923)],
        &[(0b01001, &ENTRY_TRAUMATIZATIONS_4401483376475543285)],
        &[(0b01001, &ENTRY_TRAUMATIZE_7046895873965760654)],
        &[(0b01001, &ENTRY_TRAUMATIZED_625907274700949941)],
        &[(0b01001, &ENTRY_TRAUMATIZES_1060950316018981423)],
        &[(0b01001, &ENTRY_TRAUMATIZING_11107301809578264309)],
        &[(0b00001, &ENTRY_TRAVELED_435534264813308465)],
        &[(0b00001, &ENTRY_TRAVELER_10167238839538419147)],
        &[(0b00001, &ENTRY_TRAVELERS_16181301710981832055)],
        &[(0b00001, &ENTRY_TRAVELING_3424866904821184310)],
        &[(0b00001, &ENTRY_TRAVELINGS_6548611322609842336)],
        &[(0b11010, &ENTRY_TRAVELED_435534264813308465)],
        &[(0b11010, &ENTRY_TRAVELER_10167238839538419147)],
        &[(0b11010, &ENTRY_TRAVELERS_16181301710981832055)],
        &[(0b11010, &ENTRY_TRAVELING_3424866904821184310)],
        &[(0b11010, &ENTRY_TRAVELINGS_6548611322609842336)],
        &[(0b00001, &ENTRY_TRAVELOGUE_2518512371096354483)],
        &[(0b00001, &ENTRY_TRAVELOGUES_17520213145795989298)],
    ],
    range: 5..=12,
};

static VARS_TO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_TO_CHILDREN),
    value: None,
};

pub static VARS_TO_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("taled"),
        dictgen::InsensitiveAscii("taling"),
        dictgen::InsensitiveAscii("talisation"),
        dictgen::InsensitiveAscii("talisations"),
        dictgen::InsensitiveAscii("talise"),
        dictgen::InsensitiveAscii("talised"),
        dictgen::InsensitiveAscii("talises"),
        dictgen::InsensitiveAscii("talising"),
        dictgen::InsensitiveAscii("talization"),
        dictgen::InsensitiveAscii("talizations"),
        dictgen::InsensitiveAscii("talize"),
        dictgen::InsensitiveAscii("talized"),
        dictgen::InsensitiveAscii("talizes"),
        dictgen::InsensitiveAscii("talizing"),
        dictgen::InsensitiveAscii("talled"),
        dictgen::InsensitiveAscii("talling"),
        dictgen::InsensitiveAscii("weled"),
        dictgen::InsensitiveAscii("weling"),
        dictgen::InsensitiveAscii("welings"),
        dictgen::InsensitiveAscii("welled"),
        dictgen::InsensitiveAscii("welling"),
        dictgen::InsensitiveAscii("wellings"),
        dictgen::InsensitiveAscii("xaemia"),
        dictgen::InsensitiveAscii("xaemias"),
        dictgen::InsensitiveAscii("xaemic"),
        dictgen::InsensitiveAscii("xemia"),
        dictgen::InsensitiveAscii("xemias"),
        dictgen::InsensitiveAscii("xemic"),
    ],
    values: &[
        &[(0b00001, &ENTRY_TOTALED_16465945397491592065)],
        &[(0b00001, &ENTRY_TOTALING_5708433697317878112)],
        &[(0b10010, &ENTRY_TOTALIZATION_677434854617719224)],
        &[(0b10010, &ENTRY_TOTALIZATIONS_12539779961057448289)],
        &[(0b10010, &ENTRY_TOTALIZE_15116326015710861314)],
        &[(0b10010, &ENTRY_TOTALIZED_5947312301455804043)],
        &[(0b10010, &ENTRY_TOTALIZES_9293041034438278469)],
        &[(0b10010, &ENTRY_TOTALIZING_2151125471228422884)],
        &[(0b01001, &ENTRY_TOTALIZATION_677434854617719224)],
        &[(0b01001, &ENTRY_TOTALIZATIONS_12539779961057448289)],
        &[(0b01001, &ENTRY_TOTALIZE_15116326015710861314)],
        &[(0b01001, &ENTRY_TOTALIZED_5947312301455804043)],
        &[(0b01001, &ENTRY_TOTALIZES_9293041034438278469)],
        &[(0b01001, &ENTRY_TOTALIZING_2151125471228422884)],
        &[(0b11010, &ENTRY_TOTALED_16465945397491592065)],
        &[(0b11010, &ENTRY_TOTALING_5708433697317878112)],
        &[(0b00001, &ENTRY_TOWELED_10940852459488171030)],
        &[(0b00001, &ENTRY_TOWELING_1180280283599091589)],
        &[(0b00001, &ENTRY_TOWELINGS_6040236374111337509)],
        &[(0b11010, &ENTRY_TOWELED_10940852459488171030)],
        &[(0b11010, &ENTRY_TOWELING_1180280283599091589)],
        &[(0b11010, &ENTRY_TOWELINGS_6040236374111337509)],
        &[(0b10010, &ENTRY_TOXEMIA_8507561579843698401)],
        &[(0b10010, &ENTRY_TOXEMIAS_6987620895652086802)],
        &[(0b10010, &ENTRY_TOXEMIC_11112870586226499459)],
        &[(0b11001, &ENTRY_TOXEMIA_8507561579843698401)],
        &[(0b11001, &ENTRY_TOXEMIAS_6987620895652086802)],
        &[(0b11001, &ENTRY_TOXEMIC_11112870586226499459)],
    ],
    range: 5..=11,
};

static VARS_TI_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_TI_CHILDREN),
    value: None,
};

pub static VARS_TI_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("dbit"),
        dictgen::InsensitiveAscii("dbits"),
        dictgen::InsensitiveAscii("nseled"),
        dictgen::InsensitiveAscii("nseling"),
        dictgen::InsensitiveAscii("nselled"),
        dictgen::InsensitiveAscii("nselling"),
        dictgen::InsensitiveAscii("tbit"),
        dictgen::InsensitiveAscii("tbits"),
        dictgen::InsensitiveAscii("ter"),
        dictgen::InsensitiveAscii("ters"),
        dictgen::InsensitiveAscii("tre"),
        dictgen::InsensitiveAscii("tres"),
    ],
    values: &[
        &[(0b01001, &ENTRY_TIDBIT_7805000089381014190)],
        &[(0b01001, &ENTRY_TIDBITS_16344615149357827521)],
        &[(0b01001, &ENTRY_TINSELED_3866509100193036989)],
        &[(0b01001, &ENTRY_TINSELING_2103793771113344037)],
        &[(0b11010, &ENTRY_TINSELED_3866509100193036989)],
        &[(0b11010, &ENTRY_TINSELING_2103793771113344037)],
        &[(0b10011, &ENTRY_TIDBIT_7805000089381014190)],
        &[(0b10011, &ENTRY_TIDBITS_16344615149357827521)],
        &[(0b01001, &ENTRY_TITER_8889184709551132501)],
        &[(0b01001, &ENTRY_TITERS_11786621739929986321)],
        &[(0b11010, &ENTRY_TITER_8889184709551132501)],
        &[(0b11010, &ENTRY_TITERS_11786621739929986321)],
    ],
    range: 3..=8,
};

static VARS_TH_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_TH_CHILDREN),
    value: None,
};

pub static VARS_TH_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("eater"),
        dictgen::InsensitiveAscii("eatergoer"),
        dictgen::InsensitiveAscii("eatergoers"),
        dictgen::InsensitiveAscii("eaters"),
        dictgen::InsensitiveAscii("eatre"),
        dictgen::InsensitiveAscii("eatregoer"),
        dictgen::InsensitiveAscii("eatregoers"),
        dictgen::InsensitiveAscii("eatres"),
        dictgen::InsensitiveAscii("eologise"),
        dictgen::InsensitiveAscii("eologised"),
        dictgen::InsensitiveAscii("eologises"),
        dictgen::InsensitiveAscii("eologising"),
        dictgen::InsensitiveAscii("eologize"),
        dictgen::InsensitiveAscii("eologized"),
        dictgen::InsensitiveAscii("eologizes"),
        dictgen::InsensitiveAscii("eologizing"),
        dictgen::InsensitiveAscii("eorisation"),
        dictgen::InsensitiveAscii("eorisations"),
        dictgen::InsensitiveAscii("eorise"),
        dictgen::InsensitiveAscii("eorised"),
        dictgen::InsensitiveAscii("eoriser"),
        dictgen::InsensitiveAscii("eorisers"),
        dictgen::InsensitiveAscii("eorises"),
        dictgen::InsensitiveAscii("eorising"),
        dictgen::InsensitiveAscii("eorization"),
        dictgen::InsensitiveAscii("eorizations"),
        dictgen::InsensitiveAscii("eorize"),
        dictgen::InsensitiveAscii("eorized"),
        dictgen::InsensitiveAscii("eorizer"),
        dictgen::InsensitiveAscii("eorizers"),
        dictgen::InsensitiveAscii("eorizes"),
        dictgen::InsensitiveAscii("eorizing"),
        dictgen::InsensitiveAscii("ru"),
        dictgen::InsensitiveAscii("ruway"),
        dictgen::InsensitiveAscii("ruways"),
    ],
    values: &[
        &[(0b01001, &ENTRY_THEATER_7475041782659424938)],
        &[(0b00001, &ENTRY_THEATERGOER_13508908798164743655)],
        &[(0b00001, &ENTRY_THEATERGOERS_5559625776188799969)],
        &[(0b01001, &ENTRY_THEATERS_7003357064188297631)],
        &[(0b11010, &ENTRY_THEATER_7475041782659424938)],
        &[(0b11010, &ENTRY_THEATERGOER_13508908798164743655)],
        &[(0b11010, &ENTRY_THEATERGOERS_5559625776188799969)],
        &[(0b11010, &ENTRY_THEATERS_7003357064188297631)],
        &[(0b10010, &ENTRY_THEOLOGIZE_12039512331849672306)],
        &[(0b10010, &ENTRY_THEOLOGIZED_10310177154314243592)],
        &[(0b10010, &ENTRY_THEOLOGIZES_11032972148839634053)],
        &[(0b10010, &ENTRY_THEOLOGIZING_7504945621285245915)],
        &[(0b01001, &ENTRY_THEOLOGIZE_12039512331849672306)],
        &[(0b01001, &ENTRY_THEOLOGIZED_10310177154314243592)],
        &[(0b01001, &ENTRY_THEOLOGIZES_11032972148839634053)],
        &[(0b01001, &ENTRY_THEOLOGIZING_7504945621285245915)],
        &[(0b10010, &ENTRY_THEORIZATION_12059838448730918530)],
        &[(0b10010, &ENTRY_THEORIZATIONS_14753566303904725274)],
        &[(0b10010, &ENTRY_THEORIZE_7590366607759932540)],
        &[(0b10010, &ENTRY_THEORIZED_15807114832316720521)],
        &[(0b10010, &ENTRY_THEORIZER_16504744998921729475)],
        &[(0b10010, &ENTRY_THEORIZERS_11381755780951206742)],
        &[(0b10010, &ENTRY_THEORIZES_8680815198827974415)],
        &[(0b10010, &ENTRY_THEORIZING_12129998359159098514)],
        &[(0b01001, &ENTRY_THEORIZATION_12059838448730918530)],
        &[(0b01001, &ENTRY_THEORIZATIONS_14753566303904725274)],
        &[(0b01001, &ENTRY_THEORIZE_7590366607759932540)],
        &[(0b01001, &ENTRY_THEORIZED_15807114832316720521)],
        &[(0b01001, &ENTRY_THEORIZER_16504744998921729475)],
        &[(0b01001, &ENTRY_THEORIZERS_11381755780951206742)],
        &[(0b01001, &ENTRY_THEORIZES_8680815198827974415)],
        &[(0b01001, &ENTRY_THEORIZING_12129998359159098514)],
        &[(0b00001, &ENTRY_THROUGH_14009312703153313360)],
        &[(0b10011, &ENTRY_THRUWAY_390000294149739545)],
        &[(0b10011, &ENTRY_THRUWAYS_9243384191667191710)],
    ],
    range: 2..=11,
};

static VARS_TE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_TE_CHILDREN),
    value: None,
};

pub static VARS_TE_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("aselled"),
        dictgen::InsensitiveAscii("aseller"),
        dictgen::InsensitiveAscii("asellers"),
        dictgen::InsensitiveAscii("aselling"),
        dictgen::InsensitiveAscii("asellings"),
        dictgen::InsensitiveAscii("chnicolour"),
        dictgen::InsensitiveAscii("chnicoloured"),
        dictgen::InsensitiveAscii("chnicolours"),
        dictgen::InsensitiveAscii("etotaler"),
        dictgen::InsensitiveAscii("etotalers"),
        dictgen::InsensitiveAscii("etotaller"),
        dictgen::InsensitiveAscii("etotallers"),
        dictgen::InsensitiveAscii("mporisation"),
        dictgen::InsensitiveAscii("mporisations"),
        dictgen::InsensitiveAscii("mporise"),
        dictgen::InsensitiveAscii("mporised"),
        dictgen::InsensitiveAscii("mporiser"),
        dictgen::InsensitiveAscii("mporisers"),
        dictgen::InsensitiveAscii("mporises"),
        dictgen::InsensitiveAscii("mporising"),
        dictgen::InsensitiveAscii("mporisings"),
        dictgen::InsensitiveAscii("mporization"),
        dictgen::InsensitiveAscii("mporizations"),
        dictgen::InsensitiveAscii("mporize"),
        dictgen::InsensitiveAscii("mporized"),
        dictgen::InsensitiveAscii("mporizer"),
        dictgen::InsensitiveAscii("mporizers"),
        dictgen::InsensitiveAscii("mporizes"),
        dictgen::InsensitiveAscii("mporizing"),
        dictgen::InsensitiveAscii("mporizings"),
        dictgen::InsensitiveAscii("nderise"),
        dictgen::InsensitiveAscii("nderised"),
        dictgen::InsensitiveAscii("nderiser"),
        dictgen::InsensitiveAscii("nderisers"),
        dictgen::InsensitiveAscii("nderises"),
        dictgen::InsensitiveAscii("nderising"),
        dictgen::InsensitiveAscii("nderize"),
        dictgen::InsensitiveAscii("nderized"),
        dictgen::InsensitiveAscii("nderizer"),
        dictgen::InsensitiveAscii("nderizers"),
        dictgen::InsensitiveAscii("nderizes"),
        dictgen::InsensitiveAscii("nderizing"),
        dictgen::InsensitiveAscii("rrorise"),
        dictgen::InsensitiveAscii("rrorised"),
        dictgen::InsensitiveAscii("rrorises"),
        dictgen::InsensitiveAscii("rrorising"),
        dictgen::InsensitiveAscii("rrorize"),
        dictgen::InsensitiveAscii("rrorized"),
        dictgen::InsensitiveAscii("rrorizes"),
        dictgen::InsensitiveAscii("rrorizing"),
    ],
    values: &[
        &[(0b00001, &ENTRY_TEASELED_2404281669479955994)],
        &[(0b00001, &ENTRY_TEASELER_15816628167253312937)],
        &[(0b00001, &ENTRY_TEASELERS_12811270860239416974)],
        &[
            (0b00001, &ENTRY_TEASELING_3193421888859226649),
            (0b00001, &ENTRY_TEASELING_6449109682441957740),
        ],
        &[(0b00001, &ENTRY_TEASELINGS_7138615751835008671)],
        &[
            (0b11010, &ENTRY_TECHNICOLOR_15713729011025864853),
            (0b11010, &ENTRY_TECHNICOLOR_5654403922354832142),
        ],
        &[(0b11010, &ENTRY_TECHNICOLORED_7154232169686816579)],
        &[(0b11010, &ENTRY_TECHNICOLORS_2621716821548091481)],
        &[(0b00001, &ENTRY_TEETOTALER_9642485742897840895)],
        &[(0b00001, &ENTRY_TEETOTALERS_5250373658369188480)],
        &[(0b11010, &ENTRY_TEETOTALER_9642485742897840895)],
        &[(0b11010, &ENTRY_TEETOTALERS_5250373658369188480)],
        &[(0b10010, &ENTRY_TEMPORIZATION_4135233642498941184)],
        &[(0b10010, &ENTRY_TEMPORIZATIONS_2987472207501959609)],
        &[(0b10010, &ENTRY_TEMPORIZE_7694977824627458983)],
        &[(0b10010, &ENTRY_TEMPORIZED_4964570364177704531)],
        &[(0b10010, &ENTRY_TEMPORIZER_6688110462298171935)],
        &[(0b10010, &ENTRY_TEMPORIZERS_18437130794992057942)],
        &[(0b10010, &ENTRY_TEMPORIZES_11341794494418625299)],
        &[(0b10010, &ENTRY_TEMPORIZING_16023698398897725311)],
        &[(0b10010, &ENTRY_TEMPORIZINGS_16954412101165281486)],
        &[(0b01001, &ENTRY_TEMPORIZATION_4135233642498941184)],
        &[(0b01001, &ENTRY_TEMPORIZATIONS_2987472207501959609)],
        &[(0b01001, &ENTRY_TEMPORIZE_7694977824627458983)],
        &[(0b01001, &ENTRY_TEMPORIZED_4964570364177704531)],
        &[(0b01001, &ENTRY_TEMPORIZER_6688110462298171935)],
        &[(0b01001, &ENTRY_TEMPORIZERS_18437130794992057942)],
        &[(0b01001, &ENTRY_TEMPORIZES_11341794494418625299)],
        &[(0b01001, &ENTRY_TEMPORIZING_16023698398897725311)],
        &[(0b01001, &ENTRY_TEMPORIZINGS_16954412101165281486)],
        &[(0b10010, &ENTRY_TENDERIZE_3531288944634226086)],
        &[(0b10010, &ENTRY_TENDERIZED_13718535317658548812)],
        &[(0b10010, &ENTRY_TENDERIZER_17224224602025748842)],
        &[(0b10010, &ENTRY_TENDERIZERS_13914793532536564520)],
        &[(0b10010, &ENTRY_TENDERIZES_13464919051528220037)],
        &[(0b10010, &ENTRY_TENDERIZING_9684594006719958471)],
        &[(0b01001, &ENTRY_TENDERIZE_3531288944634226086)],
        &[(0b01001, &ENTRY_TENDERIZED_13718535317658548812)],
        &[(0b01001, &ENTRY_TENDERIZER_17224224602025748842)],
        &[(0b01001, &ENTRY_TENDERIZERS_13914793532536564520)],
        &[(0b01001, &ENTRY_TENDERIZES_13464919051528220037)],
        &[(0b01001, &ENTRY_TENDERIZING_9684594006719958471)],
        &[(0b10010, &ENTRY_TERRORIZE_4433495255228210158)],
        &[(0b10010, &ENTRY_TERRORIZED_4215828528050644298)],
        &[(0b10010, &ENTRY_TERRORIZES_14794147503379380662)],
        &[(0b10010, &ENTRY_TERRORIZING_10081605138431727816)],
        &[(0b01001, &ENTRY_TERRORIZE_4433495255228210158)],
        &[(0b01001, &ENTRY_TERRORIZED_4215828528050644298)],
        &[(0b01001, &ENTRY_TERRORIZES_14794147503379380662)],
        &[(0b01001, &ENTRY_TERRORIZING_10081605138431727816)],
    ],
    range: 7..=12,
};

static VARS_TA_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_TA_CHILDREN),
    value: None,
};

pub static VARS_TA_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("mboura"),
        dictgen::InsensitiveAscii("mbouras"),
        dictgen::InsensitiveAscii("ntalisation"),
        dictgen::InsensitiveAscii("ntalisations"),
        dictgen::InsensitiveAscii("ntalise"),
        dictgen::InsensitiveAscii("ntalised"),
        dictgen::InsensitiveAscii("ntaliser"),
        dictgen::InsensitiveAscii("ntalisers"),
        dictgen::InsensitiveAscii("ntalises"),
        dictgen::InsensitiveAscii("ntalising"),
        dictgen::InsensitiveAscii("ntalisinglier"),
        dictgen::InsensitiveAscii("ntalisinglies"),
        dictgen::InsensitiveAscii("ntalisingliest"),
        dictgen::InsensitiveAscii("ntalisingly"),
        dictgen::InsensitiveAscii("ntalisings"),
        dictgen::InsensitiveAscii("ntalization"),
        dictgen::InsensitiveAscii("ntalizations"),
        dictgen::InsensitiveAscii("ntalize"),
        dictgen::InsensitiveAscii("ntalized"),
        dictgen::InsensitiveAscii("ntalizer"),
        dictgen::InsensitiveAscii("ntalizers"),
        dictgen::InsensitiveAscii("ntalizes"),
        dictgen::InsensitiveAscii("ntalizing"),
        dictgen::InsensitiveAscii("ntalizinglier"),
        dictgen::InsensitiveAscii("ntalizinglies"),
        dictgen::InsensitiveAscii("ntalizingliest"),
        dictgen::InsensitiveAscii("ntalizingly"),
        dictgen::InsensitiveAscii("ntalizings"),
        dictgen::InsensitiveAscii("sseled"),
        dictgen::InsensitiveAscii("sseling"),
        dictgen::InsensitiveAscii("sselled"),
        dictgen::InsensitiveAscii("sselling"),
        dictgen::InsensitiveAscii("ssells"),
        dictgen::InsensitiveAscii("utologise"),
        dictgen::InsensitiveAscii("utologised"),
        dictgen::InsensitiveAscii("utologises"),
        dictgen::InsensitiveAscii("utologising"),
        dictgen::InsensitiveAscii("utologize"),
        dictgen::InsensitiveAscii("utologized"),
        dictgen::InsensitiveAscii("utologizes"),
        dictgen::InsensitiveAscii("utologizing"),
    ],
    values: &[
        &[(0b11010, &ENTRY_TAMBURA_10774020505110351537)],
        &[(0b11010, &ENTRY_TAMBURAS_3622963385462333423)],
        &[(0b10010, &ENTRY_TANTALIZATION_11251308735880559440)],
        &[(0b10010, &ENTRY_TANTALIZATIONS_4202766685588417911)],
        &[(0b10010, &ENTRY_TANTALIZE_18432661058571036826)],
        &[(0b10010, &ENTRY_TANTALIZED_8361102485824684408)],
        &[(0b10010, &ENTRY_TANTALIZER_16233188677397603167)],
        &[(0b10010, &ENTRY_TANTALIZERS_15046066302558840427)],
        &[(0b10010, &ENTRY_TANTALIZES_11631837874131073727)],
        &[(0b10010, &ENTRY_TANTALIZING_1104308605989653249)],
        &[(0b10010, &ENTRY_TANTALIZINGLIER_7583695578673101293)],
        &[(0b10010, &ENTRY_TANTALIZINGLIES_9817814848083768632)],
        &[(0b10010, &ENTRY_TANTALIZINGLIEST_10330928641973270079)],
        &[(0b10010, &ENTRY_TANTALIZINGLY_6966920924649933678)],
        &[(0b10010, &ENTRY_TANTALIZINGS_2351246836151437376)],
        &[(0b01001, &ENTRY_TANTALIZATION_11251308735880559440)],
        &[(0b01001, &ENTRY_TANTALIZATIONS_4202766685588417911)],
        &[(0b01001, &ENTRY_TANTALIZE_18432661058571036826)],
        &[(0b01001, &ENTRY_TANTALIZED_8361102485824684408)],
        &[(0b01001, &ENTRY_TANTALIZER_16233188677397603167)],
        &[(0b01001, &ENTRY_TANTALIZERS_15046066302558840427)],
        &[(0b01001, &ENTRY_TANTALIZES_11631837874131073727)],
        &[(0b01001, &ENTRY_TANTALIZING_1104308605989653249)],
        &[(0b01001, &ENTRY_TANTALIZINGLIER_7583695578673101293)],
        &[(0b01001, &ENTRY_TANTALIZINGLIES_9817814848083768632)],
        &[(0b01001, &ENTRY_TANTALIZINGLIEST_10330928641973270079)],
        &[(0b01001, &ENTRY_TANTALIZINGLY_6966920924649933678)],
        &[(0b01001, &ENTRY_TANTALIZINGS_2351246836151437376)],
        &[(0b00001, &ENTRY_TASSELED_4679022262489379669)],
        &[(0b00001, &ENTRY_TASSELING_10007583439810610023)],
        &[(0b11010, &ENTRY_TASSELED_4679022262489379669)],
        &[(0b11010, &ENTRY_TASSELING_10007583439810610023)],
        &[(0b11010, &ENTRY_TASSELS_13976945035735097519)],
        &[(0b10010, &ENTRY_TAUTOLOGIZE_11478929002088519989)],
        &[(0b10010, &ENTRY_TAUTOLOGIZED_1863604812276127359)],
        &[(0b10010, &ENTRY_TAUTOLOGIZES_13343636725490349506)],
        &[(0b10010, &ENTRY_TAUTOLOGIZING_15254400746085954202)],
        &[(0b01001, &ENTRY_TAUTOLOGIZE_11478929002088519989)],
        &[(0b01001, &ENTRY_TAUTOLOGIZED_1863604812276127359)],
        &[(0b01001, &ENTRY_TAUTOLOGIZES_13343636725490349506)],
        &[(0b01001, &ENTRY_TAUTOLOGIZING_15254400746085954202)],
    ],
    range: 6..=14,
};

static VARS_S_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_S_CHILDREN),
    value: None,
};

static VARS_S_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_SA_NODE),
    None,
    Some(&VARS_SC_NODE),
    None,
    Some(&VARS_SE_NODE),
    None,
    None,
    Some(&VARS_SH_NODE),
    Some(&VARS_SI_NODE),
    None,
    Some(&VARS_SK_NODE),
    Some(&VARS_SL_NODE),
    Some(&VARS_SM_NODE),
    Some(&VARS_SN_NODE),
    Some(&VARS_SO_NODE),
    Some(&VARS_SP_NODE),
    Some(&VARS_SQ_NODE),
    None,
    None,
    Some(&VARS_ST_NODE),
    Some(&VARS_SU_NODE),
    None,
    Some(&VARS_SW_NODE),
    None,
    Some(&VARS_SY_NODE),
    None,
];

static VARS_SY_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_SY_CHILDREN),
    value: None,
};

static VARS_SY_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_SYL_NODE),
    Some(&VARS_SYM_NODE),
    Some(&VARS_SYN_NODE),
    None,
    Some(&VARS_SYP_NODE),
    None,
    None,
    Some(&VARS_SYS_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_SYS_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_SYS_CHILDREN),
    value: None,
};

pub static VARS_SYS_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("tematisation"),
        dictgen::InsensitiveAscii("tematisations"),
        dictgen::InsensitiveAscii("tematise"),
        dictgen::InsensitiveAscii("tematised"),
        dictgen::InsensitiveAscii("tematiser"),
        dictgen::InsensitiveAscii("tematisers"),
        dictgen::InsensitiveAscii("tematises"),
        dictgen::InsensitiveAscii("tematising"),
        dictgen::InsensitiveAscii("tematization"),
        dictgen::InsensitiveAscii("tematizations"),
        dictgen::InsensitiveAscii("tematize"),
        dictgen::InsensitiveAscii("tematized"),
        dictgen::InsensitiveAscii("tematizer"),
        dictgen::InsensitiveAscii("tematizers"),
        dictgen::InsensitiveAscii("tematizes"),
        dictgen::InsensitiveAscii("tematizing"),
        dictgen::InsensitiveAscii("temisation"),
        dictgen::InsensitiveAscii("temisations"),
        dictgen::InsensitiveAscii("temise"),
        dictgen::InsensitiveAscii("temised"),
        dictgen::InsensitiveAscii("temiser"),
        dictgen::InsensitiveAscii("temisers"),
        dictgen::InsensitiveAscii("temises"),
        dictgen::InsensitiveAscii("temising"),
        dictgen::InsensitiveAscii("temization"),
        dictgen::InsensitiveAscii("temizations"),
        dictgen::InsensitiveAscii("temize"),
        dictgen::InsensitiveAscii("temized"),
        dictgen::InsensitiveAscii("temizer"),
        dictgen::InsensitiveAscii("temizers"),
        dictgen::InsensitiveAscii("temizes"),
        dictgen::InsensitiveAscii("temizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SYSTEMATIZATION_3107776542992770160)],
        &[(0b10010, &ENTRY_SYSTEMATIZATIONS_3352523032353611097)],
        &[(0b10010, &ENTRY_SYSTEMATIZE_16900057715370037545)],
        &[(0b10010, &ENTRY_SYSTEMATIZED_4844953296714238844)],
        &[(0b10010, &ENTRY_SYSTEMATIZER_5303654505244699756)],
        &[(0b10010, &ENTRY_SYSTEMATIZERS_15772744122736196869)],
        &[(0b10010, &ENTRY_SYSTEMATIZES_14036170375607791421)],
        &[(0b10010, &ENTRY_SYSTEMATIZING_13014106459165883860)],
        &[(0b01001, &ENTRY_SYSTEMATIZATION_3107776542992770160)],
        &[(0b01001, &ENTRY_SYSTEMATIZATIONS_3352523032353611097)],
        &[(0b01001, &ENTRY_SYSTEMATIZE_16900057715370037545)],
        &[(0b01001, &ENTRY_SYSTEMATIZED_4844953296714238844)],
        &[(0b01001, &ENTRY_SYSTEMATIZER_5303654505244699756)],
        &[(0b01001, &ENTRY_SYSTEMATIZERS_15772744122736196869)],
        &[(0b01001, &ENTRY_SYSTEMATIZES_14036170375607791421)],
        &[(0b01001, &ENTRY_SYSTEMATIZING_13014106459165883860)],
        &[(0b10010, &ENTRY_SYSTEMIZATION_14190190500089956604)],
        &[(0b10010, &ENTRY_SYSTEMIZATIONS_4121671049363517727)],
        &[(0b10010, &ENTRY_SYSTEMIZE_6906592582631805748)],
        &[(0b10010, &ENTRY_SYSTEMIZED_6678000876435289660)],
        &[(0b10010, &ENTRY_SYSTEMIZER_11174811386299123332)],
        &[(0b10010, &ENTRY_SYSTEMIZERS_127559560082533162)],
        &[(0b10010, &ENTRY_SYSTEMIZES_17547677193703511225)],
        &[(0b10010, &ENTRY_SYSTEMIZING_11854782298171599250)],
        &[(0b01001, &ENTRY_SYSTEMIZATION_14190190500089956604)],
        &[(0b01001, &ENTRY_SYSTEMIZATIONS_4121671049363517727)],
        &[(0b01001, &ENTRY_SYSTEMIZE_6906592582631805748)],
        &[(0b01001, &ENTRY_SYSTEMIZED_6678000876435289660)],
        &[(0b01001, &ENTRY_SYSTEMIZER_11174811386299123332)],
        &[(0b01001, &ENTRY_SYSTEMIZERS_127559560082533162)],
        &[(0b01001, &ENTRY_SYSTEMIZES_17547677193703511225)],
        &[(0b01001, &ENTRY_SYSTEMIZING_11854782298171599250)],
    ],
    range: 6..=13,
};

static VARS_SYP_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_SYP_CHILDREN),
    value: None,
};

pub static VARS_SYP_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("hon"),
        dictgen::InsensitiveAscii("honed"),
        dictgen::InsensitiveAscii("honing"),
        dictgen::InsensitiveAscii("hons"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SIPHON_3485864798732184416)],
        &[(0b10010, &ENTRY_SIPHONED_18424232856912206813)],
        &[(0b10010, &ENTRY_SIPHONING_18027669453640804145)],
        &[(0b10010, &ENTRY_SIPHONS_3803350051205365845)],
    ],
    range: 3..=6,
};

static VARS_SYN_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_SYN_CHILDREN),
    value: None,
};

pub static VARS_SYN_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("chronisation"),
        dictgen::InsensitiveAscii("chronisations"),
        dictgen::InsensitiveAscii("chronise"),
        dictgen::InsensitiveAscii("chronised"),
        dictgen::InsensitiveAscii("chroniser"),
        dictgen::InsensitiveAscii("chronisers"),
        dictgen::InsensitiveAscii("chronises"),
        dictgen::InsensitiveAscii("chronising"),
        dictgen::InsensitiveAscii("chronization"),
        dictgen::InsensitiveAscii("chronizations"),
        dictgen::InsensitiveAscii("chronize"),
        dictgen::InsensitiveAscii("chronized"),
        dictgen::InsensitiveAscii("chronizer"),
        dictgen::InsensitiveAscii("chronizers"),
        dictgen::InsensitiveAscii("chronizes"),
        dictgen::InsensitiveAscii("chronizing"),
        dictgen::InsensitiveAscii("cretise"),
        dictgen::InsensitiveAscii("cretised"),
        dictgen::InsensitiveAscii("cretises"),
        dictgen::InsensitiveAscii("cretising"),
        dictgen::InsensitiveAscii("cretize"),
        dictgen::InsensitiveAscii("cretized"),
        dictgen::InsensitiveAscii("cretizes"),
        dictgen::InsensitiveAscii("cretizing"),
        dictgen::InsensitiveAscii("opsise"),
        dictgen::InsensitiveAscii("opsised"),
        dictgen::InsensitiveAscii("opsises"),
        dictgen::InsensitiveAscii("opsising"),
        dictgen::InsensitiveAscii("opsize"),
        dictgen::InsensitiveAscii("opsized"),
        dictgen::InsensitiveAscii("opsizes"),
        dictgen::InsensitiveAscii("opsizing"),
        dictgen::InsensitiveAscii("thesise"),
        dictgen::InsensitiveAscii("thesised"),
        dictgen::InsensitiveAscii("thesiser"),
        dictgen::InsensitiveAscii("thesisers"),
        dictgen::InsensitiveAscii("thesises"),
        dictgen::InsensitiveAscii("thesising"),
        dictgen::InsensitiveAscii("thesize"),
        dictgen::InsensitiveAscii("thesized"),
        dictgen::InsensitiveAscii("thesizes"),
        dictgen::InsensitiveAscii("thesizing"),
        dictgen::InsensitiveAscii("thetize"),
        dictgen::InsensitiveAscii("thetized"),
        dictgen::InsensitiveAscii("thetizes"),
        dictgen::InsensitiveAscii("thetizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SYNCHRONIZATION_15433063296853954842)],
        &[(0b10010, &ENTRY_SYNCHRONIZATIONS_11173757005398448736)],
        &[(0b10010, &ENTRY_SYNCHRONIZE_4051274325149144681)],
        &[(0b10010, &ENTRY_SYNCHRONIZED_11809698306854658807)],
        &[(0b10010, &ENTRY_SYNCHRONIZER_16183643797162044552)],
        &[(0b10010, &ENTRY_SYNCHRONIZERS_5513142999037450686)],
        &[(0b10010, &ENTRY_SYNCHRONIZES_14508130385940854115)],
        &[(0b10010, &ENTRY_SYNCHRONIZING_10768676641182362541)],
        &[(0b01001, &ENTRY_SYNCHRONIZATION_15433063296853954842)],
        &[(0b01001, &ENTRY_SYNCHRONIZATIONS_11173757005398448736)],
        &[(0b01001, &ENTRY_SYNCHRONIZE_4051274325149144681)],
        &[(0b01001, &ENTRY_SYNCHRONIZED_11809698306854658807)],
        &[(0b01001, &ENTRY_SYNCHRONIZER_16183643797162044552)],
        &[(0b01001, &ENTRY_SYNCHRONIZERS_5513142999037450686)],
        &[(0b01001, &ENTRY_SYNCHRONIZES_14508130385940854115)],
        &[(0b01001, &ENTRY_SYNCHRONIZING_10768676641182362541)],
        &[(0b10010, &ENTRY_SYNCRETIZE_882464552271583194)],
        &[(0b10010, &ENTRY_SYNCRETIZED_2883269728087305484)],
        &[(0b10010, &ENTRY_SYNCRETIZES_10622149550205968342)],
        &[(0b10010, &ENTRY_SYNCRETIZING_4094600194477609283)],
        &[(0b01001, &ENTRY_SYNCRETIZE_882464552271583194)],
        &[(0b01001, &ENTRY_SYNCRETIZED_2883269728087305484)],
        &[(0b01001, &ENTRY_SYNCRETIZES_10622149550205968342)],
        &[(0b01001, &ENTRY_SYNCRETIZING_4094600194477609283)],
        &[(0b10010, &ENTRY_SYNOPSIZE_17024762574525177281)],
        &[(0b10010, &ENTRY_SYNOPSIZED_13456249660267777970)],
        &[(0b10010, &ENTRY_SYNOPSIZES_3670003564639771417)],
        &[(0b10010, &ENTRY_SYNOPSIZING_16020823300312837540)],
        &[(0b01001, &ENTRY_SYNOPSIZE_17024762574525177281)],
        &[(0b01001, &ENTRY_SYNOPSIZED_13456249660267777970)],
        &[(0b01001, &ENTRY_SYNOPSIZES_3670003564639771417)],
        &[(0b01001, &ENTRY_SYNOPSIZING_16020823300312837540)],
        &[(0b10010, &ENTRY_SYNTHESIZE_12842132831652901179)],
        &[(0b10010, &ENTRY_SYNTHESIZED_2719272835003500056)],
        &[(0b11010, &ENTRY_SYNTHESIZER_8049018325598125114)],
        &[(0b11010, &ENTRY_SYNTHESIZERS_6048422950398681894)],
        &[(0b10010, &ENTRY_SYNTHESIZES_8265650206703294571)],
        &[(0b10010, &ENTRY_SYNTHESIZING_16486290831466977941)],
        &[(0b01001, &ENTRY_SYNTHESIZE_12842132831652901179)],
        &[(0b01001, &ENTRY_SYNTHESIZED_2719272835003500056)],
        &[(0b01001, &ENTRY_SYNTHESIZES_8265650206703294571)],
        &[(0b01001, &ENTRY_SYNTHESIZING_16486290831466977941)],
        &[(0b01000, &ENTRY_SYNTHESIZE_12842132831652901179)],
        &[(0b01000, &ENTRY_SYNTHESIZED_2719272835003500056)],
        &[(0b01000, &ENTRY_SYNTHESIZES_8265650206703294571)],
        &[(0b01000, &ENTRY_SYNTHESIZING_16486290831466977941)],
    ],
    range: 6..=13,
};

static VARS_SYM_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_SYM_CHILDREN),
    value: None,
};

pub static VARS_SYM_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("bolisation"),
        dictgen::InsensitiveAscii("bolisations"),
        dictgen::InsensitiveAscii("bolise"),
        dictgen::InsensitiveAscii("bolised"),
        dictgen::InsensitiveAscii("bolises"),
        dictgen::InsensitiveAscii("bolising"),
        dictgen::InsensitiveAscii("bolization"),
        dictgen::InsensitiveAscii("bolizations"),
        dictgen::InsensitiveAscii("bolize"),
        dictgen::InsensitiveAscii("bolized"),
        dictgen::InsensitiveAscii("bolizes"),
        dictgen::InsensitiveAscii("bolizing"),
        dictgen::InsensitiveAscii("metricly"),
        dictgen::InsensitiveAscii("metrise"),
        dictgen::InsensitiveAscii("metrised"),
        dictgen::InsensitiveAscii("metrises"),
        dictgen::InsensitiveAscii("metrising"),
        dictgen::InsensitiveAscii("metrize"),
        dictgen::InsensitiveAscii("metrized"),
        dictgen::InsensitiveAscii("metrizes"),
        dictgen::InsensitiveAscii("metrizing"),
        dictgen::InsensitiveAscii("pathise"),
        dictgen::InsensitiveAscii("pathised"),
        dictgen::InsensitiveAscii("pathiser"),
        dictgen::InsensitiveAscii("pathisers"),
        dictgen::InsensitiveAscii("pathises"),
        dictgen::InsensitiveAscii("pathising"),
        dictgen::InsensitiveAscii("pathisings"),
        dictgen::InsensitiveAscii("pathize"),
        dictgen::InsensitiveAscii("pathized"),
        dictgen::InsensitiveAscii("pathizer"),
        dictgen::InsensitiveAscii("pathizers"),
        dictgen::InsensitiveAscii("pathizes"),
        dictgen::InsensitiveAscii("pathizing"),
        dictgen::InsensitiveAscii("pathizings"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SYMBOLIZATION_183719897408488449)],
        &[(0b10010, &ENTRY_SYMBOLIZATIONS_11456355786708744140)],
        &[(0b10010, &ENTRY_SYMBOLIZE_10234132787766621474)],
        &[(0b10010, &ENTRY_SYMBOLIZED_10774231202089876919)],
        &[(0b10010, &ENTRY_SYMBOLIZES_16079471803221884218)],
        &[(0b10010, &ENTRY_SYMBOLIZING_3483608355906583358)],
        &[(0b01001, &ENTRY_SYMBOLIZATION_183719897408488449)],
        &[(0b01001, &ENTRY_SYMBOLIZATIONS_11456355786708744140)],
        &[(0b01001, &ENTRY_SYMBOLIZE_10234132787766621474)],
        &[(0b01001, &ENTRY_SYMBOLIZED_10774231202089876919)],
        &[(0b01001, &ENTRY_SYMBOLIZES_16079471803221884218)],
        &[(0b01001, &ENTRY_SYMBOLIZING_3483608355906583358)],
        &[(0b00001, &ENTRY_SYMMETRICALLY_6141818263074127947)],
        &[(0b10010, &ENTRY_SYMMETRIZE_16248404151674446594)],
        &[(0b10010, &ENTRY_SYMMETRIZED_15665190699389382501)],
        &[(0b10010, &ENTRY_SYMMETRIZES_13244460606866139100)],
        &[(0b10010, &ENTRY_SYMMETRIZING_3371155737907396072)],
        &[(0b01001, &ENTRY_SYMMETRIZE_16248404151674446594)],
        &[(0b01001, &ENTRY_SYMMETRIZED_15665190699389382501)],
        &[(0b01001, &ENTRY_SYMMETRIZES_13244460606866139100)],
        &[(0b01001, &ENTRY_SYMMETRIZING_3371155737907396072)],
        &[(0b10010, &ENTRY_SYMPATHIZE_14904500675501907799)],
        &[(0b10010, &ENTRY_SYMPATHIZED_6861363094123974820)],
        &[(0b10010, &ENTRY_SYMPATHIZER_13267697269507764406)],
        &[(0b10010, &ENTRY_SYMPATHIZERS_13386252484170054055)],
        &[(0b10010, &ENTRY_SYMPATHIZES_12347458223414813053)],
        &[(0b10010, &ENTRY_SYMPATHIZING_15316845270723087051)],
        &[(0b10010, &ENTRY_SYMPATHIZINGS_14912483334972090994)],
        &[(0b01001, &ENTRY_SYMPATHIZE_14904500675501907799)],
        &[(0b01001, &ENTRY_SYMPATHIZED_6861363094123974820)],
        &[(0b01001, &ENTRY_SYMPATHIZER_13267697269507764406)],
        &[(0b01001, &ENTRY_SYMPATHIZERS_13386252484170054055)],
        &[(0b01001, &ENTRY_SYMPATHIZES_12347458223414813053)],
        &[(0b01001, &ENTRY_SYMPATHIZING_15316845270723087051)],
        &[(0b01001, &ENTRY_SYMPATHIZINGS_14912483334972090994)],
    ],
    range: 6..=11,
};

static VARS_SYL_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_SYL_CHILDREN),
    value: None,
};

pub static VARS_SYL_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("labise"),
        dictgen::InsensitiveAscii("labised"),
        dictgen::InsensitiveAscii("labises"),
        dictgen::InsensitiveAscii("labising"),
        dictgen::InsensitiveAscii("labize"),
        dictgen::InsensitiveAscii("labized"),
        dictgen::InsensitiveAscii("labizes"),
        dictgen::InsensitiveAscii("labizing"),
        dictgen::InsensitiveAscii("logise"),
        dictgen::InsensitiveAscii("logised"),
        dictgen::InsensitiveAscii("logises"),
        dictgen::InsensitiveAscii("logising"),
        dictgen::InsensitiveAscii("logize"),
        dictgen::InsensitiveAscii("logized"),
        dictgen::InsensitiveAscii("logizes"),
        dictgen::InsensitiveAscii("logizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SYLLABIZE_8311221770764080536)],
        &[(0b10010, &ENTRY_SYLLABIZED_12280190710023663969)],
        &[(0b10010, &ENTRY_SYLLABIZES_7491957200438406322)],
        &[(0b10010, &ENTRY_SYLLABIZING_5950775546479042598)],
        &[(0b01001, &ENTRY_SYLLABIZE_8311221770764080536)],
        &[(0b01001, &ENTRY_SYLLABIZED_12280190710023663969)],
        &[(0b01001, &ENTRY_SYLLABIZES_7491957200438406322)],
        &[(0b01001, &ENTRY_SYLLABIZING_5950775546479042598)],
        &[(0b10010, &ENTRY_SYLLOGIZE_8982419159006310572)],
        &[(0b10010, &ENTRY_SYLLOGIZED_9577236679427493870)],
        &[(0b10010, &ENTRY_SYLLOGIZES_6778886382501204195)],
        &[(0b10010, &ENTRY_SYLLOGIZING_14604366328538691091)],
        &[(0b01001, &ENTRY_SYLLOGIZE_8982419159006310572)],
        &[(0b01001, &ENTRY_SYLLOGIZED_9577236679427493870)],
        &[(0b01001, &ENTRY_SYLLOGIZES_6778886382501204195)],
        &[(0b01001, &ENTRY_SYLLOGIZING_14604366328538691091)],
    ],
    range: 6..=8,
};

static VARS_SW_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_SW_CHILDREN),
    value: None,
};

pub static VARS_SW_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("iveled"),
        dictgen::InsensitiveAscii("iveling"),
        dictgen::InsensitiveAscii("ivelled"),
        dictgen::InsensitiveAscii("ivelling"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SWIVELED_12677672287636743928)],
        &[(0b00001, &ENTRY_SWIVELING_14921165234587300041)],
        &[(0b11010, &ENTRY_SWIVELED_12677672287636743928)],
        &[(0b11010, &ENTRY_SWIVELING_14921165234587300041)],
    ],
    range: 6..=8,
};

static VARS_SU_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_SU_CHILDREN),
    value: None,
};

pub static VARS_SU_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("bsidisation"),
        dictgen::InsensitiveAscii("bsidisations"),
        dictgen::InsensitiveAscii("bsidise"),
        dictgen::InsensitiveAscii("bsidised"),
        dictgen::InsensitiveAscii("bsidises"),
        dictgen::InsensitiveAscii("bsidising"),
        dictgen::InsensitiveAscii("bsidization"),
        dictgen::InsensitiveAscii("bsidizations"),
        dictgen::InsensitiveAscii("bsidize"),
        dictgen::InsensitiveAscii("bsidized"),
        dictgen::InsensitiveAscii("bsidizes"),
        dictgen::InsensitiveAscii("bsidizing"),
        dictgen::InsensitiveAscii("burbanisation"),
        dictgen::InsensitiveAscii("burbanisations"),
        dictgen::InsensitiveAscii("burbanise"),
        dictgen::InsensitiveAscii("burbanised"),
        dictgen::InsensitiveAscii("burbanises"),
        dictgen::InsensitiveAscii("burbanising"),
        dictgen::InsensitiveAscii("burbanization"),
        dictgen::InsensitiveAscii("burbanizations"),
        dictgen::InsensitiveAscii("burbanize"),
        dictgen::InsensitiveAscii("burbanized"),
        dictgen::InsensitiveAscii("burbanizes"),
        dictgen::InsensitiveAscii("burbanizing"),
        dictgen::InsensitiveAscii("ccor"),
        dictgen::InsensitiveAscii("ccored"),
        dictgen::InsensitiveAscii("ccoring"),
        dictgen::InsensitiveAscii("ccors"),
        dictgen::InsensitiveAscii("ccour"),
        dictgen::InsensitiveAscii("ccoured"),
        dictgen::InsensitiveAscii("ccouring"),
        dictgen::InsensitiveAscii("ccours"),
        dictgen::InsensitiveAscii("lfate"),
        dictgen::InsensitiveAscii("lfates"),
        dictgen::InsensitiveAscii("lfide"),
        dictgen::InsensitiveAscii("lfides"),
        dictgen::InsensitiveAscii("lfuric"),
        dictgen::InsensitiveAscii("lfurous"),
        dictgen::InsensitiveAscii("lphate"),
        dictgen::InsensitiveAscii("lphates"),
        dictgen::InsensitiveAscii("lphide"),
        dictgen::InsensitiveAscii("lphides"),
        dictgen::InsensitiveAscii("lphur"),
        dictgen::InsensitiveAscii("lphured"),
        dictgen::InsensitiveAscii("lphuric"),
        dictgen::InsensitiveAscii("lphuring"),
        dictgen::InsensitiveAscii("lphurous"),
        dictgen::InsensitiveAscii("lphurs"),
        dictgen::InsensitiveAscii("mmarise"),
        dictgen::InsensitiveAscii("mmarised"),
        dictgen::InsensitiveAscii("mmariser"),
        dictgen::InsensitiveAscii("mmarisers"),
        dictgen::InsensitiveAscii("mmarises"),
        dictgen::InsensitiveAscii("mmarising"),
        dictgen::InsensitiveAscii("mmarize"),
        dictgen::InsensitiveAscii("mmarized"),
        dictgen::InsensitiveAscii("mmarizer"),
        dictgen::InsensitiveAscii("mmarizers"),
        dictgen::InsensitiveAscii("mmarizes"),
        dictgen::InsensitiveAscii("mmarizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SUBSIDIZATION_7432910440349917685)],
        &[(0b10010, &ENTRY_SUBSIDIZATIONS_4486482297001394355)],
        &[(0b10010, &ENTRY_SUBSIDIZE_8108840583723309870)],
        &[(0b10010, &ENTRY_SUBSIDIZED_12233822221943616893)],
        &[(0b10010, &ENTRY_SUBSIDIZES_12108807615198513181)],
        &[(0b10010, &ENTRY_SUBSIDIZING_2003367098489373574)],
        &[(0b01001, &ENTRY_SUBSIDIZATION_7432910440349917685)],
        &[(0b01001, &ENTRY_SUBSIDIZATIONS_4486482297001394355)],
        &[(0b01001, &ENTRY_SUBSIDIZE_8108840583723309870)],
        &[(0b01001, &ENTRY_SUBSIDIZED_12233822221943616893)],
        &[(0b01001, &ENTRY_SUBSIDIZES_12108807615198513181)],
        &[(0b01001, &ENTRY_SUBSIDIZING_2003367098489373574)],
        &[(0b10010, &ENTRY_SUBURBANIZATION_3414694287850191476)],
        &[(0b10010, &ENTRY_SUBURBANIZATIONS_11288460981948975469)],
        &[(0b10010, &ENTRY_SUBURBANIZE_8705753901311457396)],
        &[(0b10010, &ENTRY_SUBURBANIZED_14463903828300157975)],
        &[(0b10010, &ENTRY_SUBURBANIZES_1453459705211408783)],
        &[(0b10010, &ENTRY_SUBURBANIZING_10298908135687396391)],
        &[(0b01001, &ENTRY_SUBURBANIZATION_3414694287850191476)],
        &[(0b01001, &ENTRY_SUBURBANIZATIONS_11288460981948975469)],
        &[(0b01001, &ENTRY_SUBURBANIZE_8705753901311457396)],
        &[(0b01001, &ENTRY_SUBURBANIZED_14463903828300157975)],
        &[(0b01001, &ENTRY_SUBURBANIZES_1453459705211408783)],
        &[(0b01001, &ENTRY_SUBURBANIZING_10298908135687396391)],
        &[(0b10001, &ENTRY_SUCCOR_17748336429959042470)],
        &[(0b10001, &ENTRY_SUCCORED_5734881716933621932)],
        &[(0b10001, &ENTRY_SUCCORING_2368336012653392444)],
        &[(0b10001, &ENTRY_SUCCORS_12549649896393872866)],
        &[(0b11010, &ENTRY_SUCCOR_17748336429959042470)],
        &[(0b11010, &ENTRY_SUCCORED_5734881716933621932)],
        &[(0b11010, &ENTRY_SUCCORING_2368336012653392444)],
        &[(0b11010, &ENTRY_SUCCORS_12549649896393872866)],
        &[(0b01001, &ENTRY_SULFATE_5597431207872465349)],
        &[(0b01001, &ENTRY_SULFATES_8796950330452912058)],
        &[(0b01001, &ENTRY_SULFIDE_9727735702512693147)],
        &[(0b01001, &ENTRY_SULFIDES_13405158617155232434)],
        &[(0b11001, &ENTRY_SULFURIC_10293656358970420214)],
        &[(0b01001, &ENTRY_SULFUROUS_15394058625634122012)],
        &[(0b11010, &ENTRY_SULFATE_5597431207872465349)],
        &[(0b11010, &ENTRY_SULFATES_8796950330452912058)],
        &[(0b11010, &ENTRY_SULFIDE_9727735702512693147)],
        &[(0b11010, &ENTRY_SULFIDES_13405158617155232434)],
        &[(0b11010, &ENTRY_SULFUR_3036232781385162519)],
        &[(0b11010, &ENTRY_SULFURED_11124029077762090229)],
        &[(0b11010, &ENTRY_SULFURIC_10293656358970420214)],
        &[(0b11010, &ENTRY_SULFURING_14046967905068039328)],
        &[(0b11010, &ENTRY_SULFUROUS_15394058625634122012)],
        &[(0b11010, &ENTRY_SULFURS_6162252460689699663)],
        &[(0b10010, &ENTRY_SUMMARIZE_7205302793340192646)],
        &[(0b10010, &ENTRY_SUMMARIZED_16717521893464613077)],
        &[(0b10010, &ENTRY_SUMMARIZER_11266733895685449964)],
        &[(0b10010, &ENTRY_SUMMARIZERS_8415819060575461568)],
        &[(0b10010, &ENTRY_SUMMARIZES_7904661076957850623)],
        &[(0b10010, &ENTRY_SUMMARIZING_12169215762339627229)],
        &[(0b01001, &ENTRY_SUMMARIZE_7205302793340192646)],
        &[(0b01001, &ENTRY_SUMMARIZED_16717521893464613077)],
        &[(0b01001, &ENTRY_SUMMARIZER_11266733895685449964)],
        &[(0b01001, &ENTRY_SUMMARIZERS_8415819060575461568)],
        &[(0b01001, &ENTRY_SUMMARIZES_7904661076957850623)],
        &[(0b01001, &ENTRY_SUMMARIZING_12169215762339627229)],
    ],
    range: 4..=14,
};

static VARS_ST_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_ST_CHILDREN),
    value: None,
};

static VARS_ST_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_STA_NODE),
    None,
    None,
    None,
    Some(&VARS_STE_NODE),
    None,
    None,
    None,
    Some(&VARS_STI_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_STY_NODE),
    None,
];

static VARS_STY_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_STY_CHILDREN),
    value: None,
};

pub static VARS_STY_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("lisation"),
        dictgen::InsensitiveAscii("lisations"),
        dictgen::InsensitiveAscii("lise"),
        dictgen::InsensitiveAscii("lised"),
        dictgen::InsensitiveAscii("lises"),
        dictgen::InsensitiveAscii("lising"),
        dictgen::InsensitiveAscii("lization"),
        dictgen::InsensitiveAscii("lizations"),
        dictgen::InsensitiveAscii("lize"),
        dictgen::InsensitiveAscii("lized"),
        dictgen::InsensitiveAscii("lizes"),
        dictgen::InsensitiveAscii("lizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_STYLIZATION_6235644091145662258)],
        &[(0b10010, &ENTRY_STYLIZATIONS_2138820429543216253)],
        &[(0b10010, &ENTRY_STYLIZE_13371282579615467796)],
        &[(0b10010, &ENTRY_STYLIZED_4847869505285666329)],
        &[(0b10010, &ENTRY_STYLIZES_2600387667375095470)],
        &[(0b10010, &ENTRY_STYLIZING_10937898920006317214)],
        &[(0b01001, &ENTRY_STYLIZATION_6235644091145662258)],
        &[(0b01001, &ENTRY_STYLIZATIONS_2138820429543216253)],
        &[(0b01001, &ENTRY_STYLIZE_13371282579615467796)],
        &[(0b01001, &ENTRY_STYLIZED_4847869505285666329)],
        &[(0b01001, &ENTRY_STYLIZES_2600387667375095470)],
        &[(0b01001, &ENTRY_STYLIZING_10937898920006317214)],
    ],
    range: 4..=9,
};

static VARS_STI_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_STI_CHILDREN),
    value: None,
};

pub static VARS_STI_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("gmatisation"),
        dictgen::InsensitiveAscii("gmatisations"),
        dictgen::InsensitiveAscii("gmatise"),
        dictgen::InsensitiveAscii("gmatised"),
        dictgen::InsensitiveAscii("gmatises"),
        dictgen::InsensitiveAscii("gmatising"),
        dictgen::InsensitiveAscii("gmatization"),
        dictgen::InsensitiveAscii("gmatizations"),
        dictgen::InsensitiveAscii("gmatize"),
        dictgen::InsensitiveAscii("gmatized"),
        dictgen::InsensitiveAscii("gmatizes"),
        dictgen::InsensitiveAscii("gmatizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_STIGMATIZATION_15367665650808291201)],
        &[(0b10010, &ENTRY_STIGMATIZATIONS_4419626284437647049)],
        &[(0b10010, &ENTRY_STIGMATIZE_5799619399576330013)],
        &[(0b10010, &ENTRY_STIGMATIZED_2708765122033987200)],
        &[(0b10010, &ENTRY_STIGMATIZES_14729433263129115837)],
        &[(0b10010, &ENTRY_STIGMATIZING_1440308166481676994)],
        &[(0b01001, &ENTRY_STIGMATIZATION_15367665650808291201)],
        &[(0b01001, &ENTRY_STIGMATIZATIONS_4419626284437647049)],
        &[(0b01001, &ENTRY_STIGMATIZE_5799619399576330013)],
        &[(0b01001, &ENTRY_STIGMATIZED_2708765122033987200)],
        &[(0b01001, &ENTRY_STIGMATIZES_14729433263129115837)],
        &[(0b01001, &ENTRY_STIGMATIZING_1440308166481676994)],
    ],
    range: 7..=12,
};

static VARS_STE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_STE_CHILDREN),
    value: None,
};

pub static VARS_STE_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("nciled"),
        dictgen::InsensitiveAscii("nciling"),
        dictgen::InsensitiveAscii("ncilled"),
        dictgen::InsensitiveAscii("ncilling"),
        dictgen::InsensitiveAscii("rilisable"),
        dictgen::InsensitiveAscii("rilisabler"),
        dictgen::InsensitiveAscii("rilisables"),
        dictgen::InsensitiveAscii("rilisablest"),
        dictgen::InsensitiveAscii("rilisation"),
        dictgen::InsensitiveAscii("rilisations"),
        dictgen::InsensitiveAscii("rilise"),
        dictgen::InsensitiveAscii("rilised"),
        dictgen::InsensitiveAscii("riliser"),
        dictgen::InsensitiveAscii("rilisers"),
        dictgen::InsensitiveAscii("rilises"),
        dictgen::InsensitiveAscii("rilising"),
        dictgen::InsensitiveAscii("rilizable"),
        dictgen::InsensitiveAscii("rilizabler"),
        dictgen::InsensitiveAscii("rilizables"),
        dictgen::InsensitiveAscii("rilizablest"),
        dictgen::InsensitiveAscii("rilization"),
        dictgen::InsensitiveAscii("rilizations"),
        dictgen::InsensitiveAscii("rilize"),
        dictgen::InsensitiveAscii("rilized"),
        dictgen::InsensitiveAscii("rilizer"),
        dictgen::InsensitiveAscii("rilizers"),
        dictgen::InsensitiveAscii("rilizes"),
        dictgen::InsensitiveAscii("rilizing"),
    ],
    values: &[
        &[(0b00001, &ENTRY_STENCILED_18358466251443584244)],
        &[(0b00001, &ENTRY_STENCILING_16009278311382010932)],
        &[(0b11010, &ENTRY_STENCILED_18358466251443584244)],
        &[(0b11010, &ENTRY_STENCILING_16009278311382010932)],
        &[(0b10010, &ENTRY_STERILIZABLE_12001563571902655950)],
        &[(0b10010, &ENTRY_STERILIZABLER_2981777391612929274)],
        &[(0b10010, &ENTRY_STERILIZABLES_9392344777525592572)],
        &[(0b10010, &ENTRY_STERILIZABLEST_12402421338830249014)],
        &[(0b10010, &ENTRY_STERILIZATION_8065625074540222478)],
        &[(0b10010, &ENTRY_STERILIZATIONS_6145032887986296344)],
        &[(0b10010, &ENTRY_STERILIZE_1847097589172243146)],
        &[(0b10010, &ENTRY_STERILIZED_17543306694251609885)],
        &[(0b10010, &ENTRY_STERILIZER_14841880991277730478)],
        &[(0b10010, &ENTRY_STERILIZERS_3377446126211900294)],
        &[(0b10010, &ENTRY_STERILIZES_4362381845943247126)],
        &[(0b10010, &ENTRY_STERILIZING_8492025091236842001)],
        &[(0b01001, &ENTRY_STERILIZABLE_12001563571902655950)],
        &[(0b01001, &ENTRY_STERILIZABLER_2981777391612929274)],
        &[(0b01001, &ENTRY_STERILIZABLES_9392344777525592572)],
        &[(0b01001, &ENTRY_STERILIZABLEST_12402421338830249014)],
        &[(0b01001, &ENTRY_STERILIZATION_8065625074540222478)],
        &[(0b01001, &ENTRY_STERILIZATIONS_6145032887986296344)],
        &[(0b01001, &ENTRY_STERILIZE_1847097589172243146)],
        &[(0b01001, &ENTRY_STERILIZED_17543306694251609885)],
        &[(0b01001, &ENTRY_STERILIZER_14841880991277730478)],
        &[(0b01001, &ENTRY_STERILIZERS_3377446126211900294)],
        &[(0b01001, &ENTRY_STERILIZES_4362381845943247126)],
        &[(0b01001, &ENTRY_STERILIZING_8492025091236842001)],
    ],
    range: 6..=11,
};

static VARS_STA_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_STA_CHILDREN),
    value: None,
};

pub static VARS_STA_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("bilisation"),
        dictgen::InsensitiveAscii("bilisations"),
        dictgen::InsensitiveAscii("bilise"),
        dictgen::InsensitiveAscii("bilised"),
        dictgen::InsensitiveAscii("biliser"),
        dictgen::InsensitiveAscii("bilisers"),
        dictgen::InsensitiveAscii("bilises"),
        dictgen::InsensitiveAscii("bilising"),
        dictgen::InsensitiveAscii("bilization"),
        dictgen::InsensitiveAscii("bilizations"),
        dictgen::InsensitiveAscii("bilize"),
        dictgen::InsensitiveAscii("bilized"),
        dictgen::InsensitiveAscii("bilizer"),
        dictgen::InsensitiveAscii("bilizers"),
        dictgen::InsensitiveAscii("bilizes"),
        dictgen::InsensitiveAscii("bilizing"),
        dictgen::InsensitiveAscii("ndardisation"),
        dictgen::InsensitiveAscii("ndardisations"),
        dictgen::InsensitiveAscii("ndardise"),
        dictgen::InsensitiveAscii("ndardised"),
        dictgen::InsensitiveAscii("ndardises"),
        dictgen::InsensitiveAscii("ndardising"),
        dictgen::InsensitiveAscii("ndardization"),
        dictgen::InsensitiveAscii("ndardizations"),
        dictgen::InsensitiveAscii("ndardize"),
        dictgen::InsensitiveAscii("ndardized"),
        dictgen::InsensitiveAscii("ndardizes"),
        dictgen::InsensitiveAscii("ndardizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_STABILIZATION_8501631360615854418)],
        &[(0b10010, &ENTRY_STABILIZATIONS_11866129248341293272)],
        &[(0b10010, &ENTRY_STABILIZE_11592021559489637588)],
        &[(0b10010, &ENTRY_STABILIZED_11637850169426450316)],
        &[(0b10010, &ENTRY_STABILIZER_10839686795364476539)],
        &[(0b10010, &ENTRY_STABILIZERS_6342146151996925299)],
        &[(0b10010, &ENTRY_STABILIZES_14273493638532544927)],
        &[(0b10010, &ENTRY_STABILIZING_12133357303799134695)],
        &[(0b01001, &ENTRY_STABILIZATION_8501631360615854418)],
        &[(0b01001, &ENTRY_STABILIZATIONS_11866129248341293272)],
        &[(0b01001, &ENTRY_STABILIZE_11592021559489637588)],
        &[(0b01001, &ENTRY_STABILIZED_11637850169426450316)],
        &[(0b01001, &ENTRY_STABILIZER_10839686795364476539)],
        &[(0b01001, &ENTRY_STABILIZERS_6342146151996925299)],
        &[(0b01001, &ENTRY_STABILIZES_14273493638532544927)],
        &[(0b01001, &ENTRY_STABILIZING_12133357303799134695)],
        &[(0b10010, &ENTRY_STANDARDIZATION_15383021445373007707)],
        &[(0b10010, &ENTRY_STANDARDIZATIONS_332063199494197132)],
        &[(0b10010, &ENTRY_STANDARDIZE_16594334550448089105)],
        &[(0b10010, &ENTRY_STANDARDIZED_7943764922032376919)],
        &[(0b10010, &ENTRY_STANDARDIZES_7893289976137443900)],
        &[(0b10010, &ENTRY_STANDARDIZING_8802579594080422420)],
        &[(0b01001, &ENTRY_STANDARDIZATION_15383021445373007707)],
        &[(0b01001, &ENTRY_STANDARDIZATIONS_332063199494197132)],
        &[(0b01001, &ENTRY_STANDARDIZE_16594334550448089105)],
        &[(0b01001, &ENTRY_STANDARDIZED_7943764922032376919)],
        &[(0b01001, &ENTRY_STANDARDIZES_7893289976137443900)],
        &[(0b01001, &ENTRY_STANDARDIZING_8802579594080422420)],
    ],
    range: 6..=13,
};

static VARS_SQ_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_SQ_CHILDREN),
    value: None,
};

pub static VARS_SQ_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("uirreled"),
        dictgen::InsensitiveAscii("uirreling"),
        dictgen::InsensitiveAscii("uirrelled"),
        dictgen::InsensitiveAscii("uirrelling"),
    ],
    values: &[
        &[(0b01001, &ENTRY_SQUIRRELED_18389953608476203741)],
        &[(0b01001, &ENTRY_SQUIRRELING_2889119631030338646)],
        &[(0b11010, &ENTRY_SQUIRRELED_18389953608476203741)],
        &[(0b11010, &ENTRY_SQUIRRELING_2889119631030338646)],
    ],
    range: 8..=10,
};

static VARS_SP_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_SP_CHILDREN),
    value: None,
};

pub static VARS_SP_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ecialisation"),
        dictgen::InsensitiveAscii("ecialisations"),
        dictgen::InsensitiveAscii("ecialise"),
        dictgen::InsensitiveAscii("ecialised"),
        dictgen::InsensitiveAscii("ecialises"),
        dictgen::InsensitiveAscii("ecialising"),
        dictgen::InsensitiveAscii("ecialities"),
        dictgen::InsensitiveAscii("eciality"),
        dictgen::InsensitiveAscii("ecialization"),
        dictgen::InsensitiveAscii("ecializations"),
        dictgen::InsensitiveAscii("ecialize"),
        dictgen::InsensitiveAscii("ecialized"),
        dictgen::InsensitiveAscii("ecializes"),
        dictgen::InsensitiveAscii("ecializing"),
        dictgen::InsensitiveAscii("ecialties"),
        dictgen::InsensitiveAscii("ecialty"),
        dictgen::InsensitiveAscii("ecter"),
        dictgen::InsensitiveAscii("ecters"),
        dictgen::InsensitiveAscii("ectre"),
        dictgen::InsensitiveAscii("ectres"),
        dictgen::InsensitiveAscii("elaeological"),
        dictgen::InsensitiveAscii("iraled"),
        dictgen::InsensitiveAscii("iraling"),
        dictgen::InsensitiveAscii("iralled"),
        dictgen::InsensitiveAscii("iralling"),
        dictgen::InsensitiveAscii("irea"),
        dictgen::InsensitiveAscii("ireas"),
        dictgen::InsensitiveAscii("iritualisation"),
        dictgen::InsensitiveAscii("iritualisations"),
        dictgen::InsensitiveAscii("iritualise"),
        dictgen::InsensitiveAscii("iritualised"),
        dictgen::InsensitiveAscii("iritualises"),
        dictgen::InsensitiveAscii("iritualising"),
        dictgen::InsensitiveAscii("iritualization"),
        dictgen::InsensitiveAscii("iritualizations"),
        dictgen::InsensitiveAscii("iritualize"),
        dictgen::InsensitiveAscii("iritualized"),
        dictgen::InsensitiveAscii("iritualizes"),
        dictgen::InsensitiveAscii("iritualizing"),
        dictgen::InsensitiveAscii("irochaete"),
        dictgen::InsensitiveAscii("irochaetes"),
        dictgen::InsensitiveAscii("irochete"),
        dictgen::InsensitiveAscii("irochetes"),
        dictgen::InsensitiveAscii("lendor"),
        dictgen::InsensitiveAscii("lendors"),
        dictgen::InsensitiveAscii("lendour"),
        dictgen::InsensitiveAscii("lendours"),
        dictgen::InsensitiveAscii("oilt"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SPECIALIZATION_6120455718688591089)],
        &[(0b10010, &ENTRY_SPECIALIZATIONS_8996872983896742236)],
        &[(0b10010, &ENTRY_SPECIALIZE_11882111573270244369)],
        &[(0b10010, &ENTRY_SPECIALIZED_16208307633714518784)],
        &[(0b10010, &ENTRY_SPECIALIZES_8324377090323742106)],
        &[(0b10010, &ENTRY_SPECIALIZING_313518186697576164)],
        &[(0b10010, &ENTRY_SPECIALTIES_4384906624021484771)],
        &[(0b10010, &ENTRY_SPECIALTY_7072505085373556831)],
        &[(0b01001, &ENTRY_SPECIALIZATION_6120455718688591089)],
        &[(0b01001, &ENTRY_SPECIALIZATIONS_8996872983896742236)],
        &[(0b01001, &ENTRY_SPECIALIZE_11882111573270244369)],
        &[(0b01001, &ENTRY_SPECIALIZED_16208307633714518784)],
        &[(0b01001, &ENTRY_SPECIALIZES_8324377090323742106)],
        &[(0b01001, &ENTRY_SPECIALIZING_313518186697576164)],
        &[(0b01001, &ENTRY_SPECIALTIES_4384906624021484771)],
        &[(0b01001, &ENTRY_SPECIALTY_7072505085373556831)],
        &[(0b00001, &ENTRY_SPECTER_6975611216022022799)],
        &[(0b00001, &ENTRY_SPECTERS_5015013310557036380)],
        &[(0b11010, &ENTRY_SPECTER_6975611216022022799)],
        &[(0b11010, &ENTRY_SPECTERS_5015013310557036380)],
        &[(0b11010, &ENTRY_SPELEOLOGICAL_5030814757410755163)],
        &[(0b01001, &ENTRY_SPIRALED_16325472687253851967)],
        &[(0b01001, &ENTRY_SPIRALING_17847046296192692592)],
        &[(0b11010, &ENTRY_SPIRALED_16325472687253851967)],
        &[(0b11010, &ENTRY_SPIRALING_17847046296192692592)],
        &[(0b01001, &ENTRY_SPIREA_8481146863445432200)],
        &[(0b01001, &ENTRY_SPIREAS_2974152297943195596)],
        &[(0b10010, &ENTRY_SPIRITUALIZATION_9220466398088529072)],
        &[(0b10010, &ENTRY_SPIRITUALIZATIONS_17245892670567210801)],
        &[(0b10010, &ENTRY_SPIRITUALIZE_12814212072235396435)],
        &[(0b10010, &ENTRY_SPIRITUALIZED_15163734331617007407)],
        &[(0b10010, &ENTRY_SPIRITUALIZES_15228536253347259988)],
        &[(0b10010, &ENTRY_SPIRITUALIZING_3491733202887639865)],
        &[(0b01001, &ENTRY_SPIRITUALIZATION_9220466398088529072)],
        &[(0b01001, &ENTRY_SPIRITUALIZATIONS_17245892670567210801)],
        &[(0b01001, &ENTRY_SPIRITUALIZE_12814212072235396435)],
        &[(0b01001, &ENTRY_SPIRITUALIZED_15163734331617007407)],
        &[(0b01001, &ENTRY_SPIRITUALIZES_15228536253347259988)],
        &[(0b01001, &ENTRY_SPIRITUALIZING_3491733202887639865)],
        &[(0b10010, &ENTRY_SPIROCHETE_7516750690687611615)],
        &[(0b10010, &ENTRY_SPIROCHETES_7149420395283644676)],
        &[(0b01001, &ENTRY_SPIROCHETE_7516750690687611615)],
        &[(0b01001, &ENTRY_SPIROCHETES_7149420395283644676)],
        &[(0b11001, &ENTRY_SPLENDOR_8664416655036864719)],
        &[(0b11001, &ENTRY_SPLENDORS_5940678279727313679)],
        &[(0b11010, &ENTRY_SPLENDOR_8664416655036864719)],
        &[(0b11010, &ENTRY_SPLENDORS_5940678279727313679)],
        &[(0b11010, &ENTRY_SPOILED_924892233379569654)],
    ],
    range: 4..=15,
};

static VARS_SO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_SO_CHILDREN),
    value: None,
};

static VARS_SO_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    Some(&VARS_SOC_NODE),
    Some(&VARS_SOD_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_SOL_NODE),
    Some(&VARS_SOM_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_SOV_NODE),
    None,
    None,
    None,
    None,
];

static VARS_SOV_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_SOV_CHILDREN),
    value: None,
};

pub static VARS_SOV_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ietisation"),
        dictgen::InsensitiveAscii("ietisations"),
        dictgen::InsensitiveAscii("ietise"),
        dictgen::InsensitiveAscii("ietised"),
        dictgen::InsensitiveAscii("ietises"),
        dictgen::InsensitiveAscii("ietising"),
        dictgen::InsensitiveAscii("ietization"),
        dictgen::InsensitiveAscii("ietizations"),
        dictgen::InsensitiveAscii("ietize"),
        dictgen::InsensitiveAscii("ietized"),
        dictgen::InsensitiveAscii("ietizes"),
        dictgen::InsensitiveAscii("ietizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SOVIETIZATION_12298078635242896286)],
        &[(0b10010, &ENTRY_SOVIETIZATIONS_4958691907677433643)],
        &[(0b10010, &ENTRY_SOVIETIZE_4186406491577376479)],
        &[(0b10010, &ENTRY_SOVIETIZED_14659307059412841290)],
        &[(0b10010, &ENTRY_SOVIETIZES_17217850242167584748)],
        &[(0b10010, &ENTRY_SOVIETIZING_1809586830086781112)],
        &[(0b01001, &ENTRY_SOVIETIZATION_12298078635242896286)],
        &[(0b01001, &ENTRY_SOVIETIZATIONS_4958691907677433643)],
        &[(0b01001, &ENTRY_SOVIETIZE_4186406491577376479)],
        &[(0b01001, &ENTRY_SOVIETIZED_14659307059412841290)],
        &[(0b01001, &ENTRY_SOVIETIZES_17217850242167584748)],
        &[(0b01001, &ENTRY_SOVIETIZING_1809586830086781112)],
    ],
    range: 6..=11,
};

static VARS_SOM_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_SOM_CHILDREN),
    value: None,
};

pub static VARS_SOM_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ber"),
        dictgen::InsensitiveAscii("berer"),
        dictgen::InsensitiveAscii("berest"),
        dictgen::InsensitiveAscii("berly"),
        dictgen::InsensitiveAscii("berness"),
        dictgen::InsensitiveAscii("bernesses"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SOMBER_7545143144533743661)],
        &[(0b00001, &ENTRY_SOMBERER_5923083299459142321)],
        &[(0b00001, &ENTRY_SOMBEREST_13920553234454816213)],
        &[(0b00001, &ENTRY_SOMBERLY_8543050585429649865)],
        &[(0b00001, &ENTRY_SOMBERNESS_15776453114536814910)],
        &[(0b00001, &ENTRY_SOMBERNESSES_37120742853890215)],
    ],
    range: 3..=9,
};

static VARS_SOL_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_SOL_CHILDREN),
    value: None,
};

pub static VARS_SOL_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("arisation"),
        dictgen::InsensitiveAscii("arisations"),
        dictgen::InsensitiveAscii("arise"),
        dictgen::InsensitiveAscii("arised"),
        dictgen::InsensitiveAscii("arises"),
        dictgen::InsensitiveAscii("arising"),
        dictgen::InsensitiveAscii("arization"),
        dictgen::InsensitiveAscii("arizations"),
        dictgen::InsensitiveAscii("arize"),
        dictgen::InsensitiveAscii("arized"),
        dictgen::InsensitiveAscii("arizes"),
        dictgen::InsensitiveAscii("arizing"),
        dictgen::InsensitiveAscii("emnisation"),
        dictgen::InsensitiveAscii("emnisations"),
        dictgen::InsensitiveAscii("emnise"),
        dictgen::InsensitiveAscii("emnised"),
        dictgen::InsensitiveAscii("emnises"),
        dictgen::InsensitiveAscii("emnising"),
        dictgen::InsensitiveAscii("emnization"),
        dictgen::InsensitiveAscii("emnizations"),
        dictgen::InsensitiveAscii("emnize"),
        dictgen::InsensitiveAscii("emnized"),
        dictgen::InsensitiveAscii("emnizes"),
        dictgen::InsensitiveAscii("emnizing"),
        dictgen::InsensitiveAscii("iloquise"),
        dictgen::InsensitiveAscii("iloquised"),
        dictgen::InsensitiveAscii("iloquises"),
        dictgen::InsensitiveAscii("iloquising"),
        dictgen::InsensitiveAscii("iloquisings"),
        dictgen::InsensitiveAscii("iloquize"),
        dictgen::InsensitiveAscii("iloquized"),
        dictgen::InsensitiveAscii("iloquizes"),
        dictgen::InsensitiveAscii("iloquizing"),
        dictgen::InsensitiveAscii("iloquizings"),
        dictgen::InsensitiveAscii("misation"),
        dictgen::InsensitiveAscii("misations"),
        dictgen::InsensitiveAscii("mization"),
        dictgen::InsensitiveAscii("mizations"),
        dictgen::InsensitiveAscii("ubilisation"),
        dictgen::InsensitiveAscii("ubilisations"),
        dictgen::InsensitiveAscii("ubilise"),
        dictgen::InsensitiveAscii("ubilised"),
        dictgen::InsensitiveAscii("ubilises"),
        dictgen::InsensitiveAscii("ubilising"),
        dictgen::InsensitiveAscii("ubilization"),
        dictgen::InsensitiveAscii("ubilizations"),
        dictgen::InsensitiveAscii("ubilize"),
        dictgen::InsensitiveAscii("ubilized"),
        dictgen::InsensitiveAscii("ubilizes"),
        dictgen::InsensitiveAscii("ubilizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SOLARIZATION_4885912231243718586)],
        &[(0b10010, &ENTRY_SOLARIZATIONS_11436810758858977879)],
        &[(0b10010, &ENTRY_SOLARIZE_5717478759034003221)],
        &[(0b10010, &ENTRY_SOLARIZED_4040826558854876151)],
        &[(0b10010, &ENTRY_SOLARIZES_4506803855717626619)],
        &[(0b10010, &ENTRY_SOLARIZING_8595599809624415698)],
        &[(0b01001, &ENTRY_SOLARIZATION_4885912231243718586)],
        &[(0b01001, &ENTRY_SOLARIZATIONS_11436810758858977879)],
        &[(0b01001, &ENTRY_SOLARIZE_5717478759034003221)],
        &[(0b01001, &ENTRY_SOLARIZED_4040826558854876151)],
        &[(0b01001, &ENTRY_SOLARIZES_4506803855717626619)],
        &[(0b01001, &ENTRY_SOLARIZING_8595599809624415698)],
        &[(0b10010, &ENTRY_SOLEMNIZATION_11065823287402873495)],
        &[(0b10010, &ENTRY_SOLEMNIZATIONS_10033372229920712112)],
        &[(0b10010, &ENTRY_SOLEMNIZE_15679717866562504473)],
        &[(0b10010, &ENTRY_SOLEMNIZED_224034548114018910)],
        &[(0b10010, &ENTRY_SOLEMNIZES_12952089326401148902)],
        &[(0b10010, &ENTRY_SOLEMNIZING_630145090956262150)],
        &[(0b01001, &ENTRY_SOLEMNIZATION_11065823287402873495)],
        &[(0b01001, &ENTRY_SOLEMNIZATIONS_10033372229920712112)],
        &[(0b01001, &ENTRY_SOLEMNIZE_15679717866562504473)],
        &[(0b01001, &ENTRY_SOLEMNIZED_224034548114018910)],
        &[(0b01001, &ENTRY_SOLEMNIZES_12952089326401148902)],
        &[(0b01001, &ENTRY_SOLEMNIZING_630145090956262150)],
        &[(0b10010, &ENTRY_SOLILOQUIZE_14417000719223788095)],
        &[(0b10010, &ENTRY_SOLILOQUIZED_4881410725010799917)],
        &[(0b10010, &ENTRY_SOLILOQUIZES_409834577954225605)],
        &[(0b10010, &ENTRY_SOLILOQUIZING_9233664287673036156)],
        &[(0b10010, &ENTRY_SOLILOQUIZINGS_16981301693070525140)],
        &[(0b01001, &ENTRY_SOLILOQUIZE_14417000719223788095)],
        &[(0b01001, &ENTRY_SOLILOQUIZED_4881410725010799917)],
        &[(0b01001, &ENTRY_SOLILOQUIZES_409834577954225605)],
        &[(0b01001, &ENTRY_SOLILOQUIZING_9233664287673036156)],
        &[(0b01001, &ENTRY_SOLILOQUIZINGS_16981301693070525140)],
        &[(0b10010, &ENTRY_SOLMIZATION_12587274322609700335)],
        &[(0b10010, &ENTRY_SOLMIZATIONS_13644603279878977752)],
        &[(0b01001, &ENTRY_SOLMIZATION_12587274322609700335)],
        &[(0b01001, &ENTRY_SOLMIZATIONS_13644603279878977752)],
        &[(0b10010, &ENTRY_SOLUBILIZATION_10580055016658346926)],
        &[(0b10010, &ENTRY_SOLUBILIZATIONS_4955462430772240177)],
        &[(0b10010, &ENTRY_SOLUBILIZE_1673521634914384541)],
        &[(0b10010, &ENTRY_SOLUBILIZED_10156344475132002791)],
        &[(0b10010, &ENTRY_SOLUBILIZES_12208892698399982158)],
        &[(0b10010, &ENTRY_SOLUBILIZING_5913383570927297322)],
        &[(0b01001, &ENTRY_SOLUBILIZATION_10580055016658346926)],
        &[(0b01001, &ENTRY_SOLUBILIZATIONS_4955462430772240177)],
        &[(0b01001, &ENTRY_SOLUBILIZE_1673521634914384541)],
        &[(0b01001, &ENTRY_SOLUBILIZED_10156344475132002791)],
        &[(0b01001, &ENTRY_SOLUBILIZES_12208892698399982158)],
        &[(0b01001, &ENTRY_SOLUBILIZING_5913383570927297322)],
    ],
    range: 5..=12,
};

static VARS_SOD_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_SOD_CHILDREN),
    value: None,
};

pub static VARS_SOD_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("omise"),
        dictgen::InsensitiveAscii("omised"),
        dictgen::InsensitiveAscii("omises"),
        dictgen::InsensitiveAscii("omising"),
        dictgen::InsensitiveAscii("omize"),
        dictgen::InsensitiveAscii("omized"),
        dictgen::InsensitiveAscii("omizes"),
        dictgen::InsensitiveAscii("omizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SODOMIZE_8989273429049313613)],
        &[(0b10010, &ENTRY_SODOMIZED_14987743408591553330)],
        &[(0b10010, &ENTRY_SODOMIZES_13961547799680688282)],
        &[(0b10010, &ENTRY_SODOMIZING_17930954299621224444)],
        &[(0b01001, &ENTRY_SODOMIZE_8989273429049313613)],
        &[(0b01001, &ENTRY_SODOMIZED_14987743408591553330)],
        &[(0b01001, &ENTRY_SODOMIZES_13961547799680688282)],
        &[(0b01001, &ENTRY_SODOMIZING_17930954299621224444)],
    ],
    range: 5..=7,
};

static VARS_SOC_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_SOC_CHILDREN),
    value: None,
};

pub static VARS_SOC_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ialisation"),
        dictgen::InsensitiveAscii("ialisations"),
        dictgen::InsensitiveAscii("ialise"),
        dictgen::InsensitiveAscii("ialised"),
        dictgen::InsensitiveAscii("ialises"),
        dictgen::InsensitiveAscii("ialising"),
        dictgen::InsensitiveAscii("ialization"),
        dictgen::InsensitiveAscii("ializations"),
        dictgen::InsensitiveAscii("ialize"),
        dictgen::InsensitiveAscii("ialized"),
        dictgen::InsensitiveAscii("ializes"),
        dictgen::InsensitiveAscii("ializing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SOCIALIZATION_4031789440864790681)],
        &[(0b10010, &ENTRY_SOCIALIZATIONS_2850800344346221828)],
        &[(0b10010, &ENTRY_SOCIALIZE_7608316723437121057)],
        &[(0b10010, &ENTRY_SOCIALIZED_6519290214037545163)],
        &[(0b10010, &ENTRY_SOCIALIZES_17008876412249563437)],
        &[(0b10010, &ENTRY_SOCIALIZING_5892971976061278726)],
        &[(0b01001, &ENTRY_SOCIALIZATION_4031789440864790681)],
        &[(0b01001, &ENTRY_SOCIALIZATIONS_2850800344346221828)],
        &[(0b01001, &ENTRY_SOCIALIZE_7608316723437121057)],
        &[(0b01001, &ENTRY_SOCIALIZED_6519290214037545163)],
        &[(0b01001, &ENTRY_SOCIALIZES_17008876412249563437)],
        &[(0b01001, &ENTRY_SOCIALIZING_5892971976061278726)],
    ],
    range: 6..=11,
};

static VARS_SN_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_SN_CHILDREN),
    value: None,
};

pub static VARS_SN_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("iveled"),
        dictgen::InsensitiveAscii("iveler"),
        dictgen::InsensitiveAscii("ivelers"),
        dictgen::InsensitiveAscii("iveling"),
        dictgen::InsensitiveAscii("ivelings"),
        dictgen::InsensitiveAscii("ivelled"),
        dictgen::InsensitiveAscii("iveller"),
        dictgen::InsensitiveAscii("ivellers"),
        dictgen::InsensitiveAscii("ivelling"),
        dictgen::InsensitiveAscii("ivellings"),
        dictgen::InsensitiveAscii("orkeled"),
        dictgen::InsensitiveAscii("orkeling"),
        dictgen::InsensitiveAscii("orkelled"),
        dictgen::InsensitiveAscii("orkelling"),
        dictgen::InsensitiveAscii("owplough"),
        dictgen::InsensitiveAscii("owploughs"),
        dictgen::InsensitiveAscii("owplow"),
        dictgen::InsensitiveAscii("owplows"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SNIVELED_4241225854345991490)],
        &[(0b00001, &ENTRY_SNIVELER_7636471678868749639)],
        &[(0b00001, &ENTRY_SNIVELERS_10785023557653793627)],
        &[(0b00001, &ENTRY_SNIVELING_5513010514012383062)],
        &[(0b00001, &ENTRY_SNIVELINGS_8577178711179056074)],
        &[(0b11010, &ENTRY_SNIVELED_4241225854345991490)],
        &[(0b11010, &ENTRY_SNIVELER_7636471678868749639)],
        &[(0b11010, &ENTRY_SNIVELERS_10785023557653793627)],
        &[(0b11010, &ENTRY_SNIVELING_5513010514012383062)],
        &[(0b11010, &ENTRY_SNIVELINGS_8577178711179056074)],
        &[(0b01001, &ENTRY_SNORKELED_8473613528721477540)],
        &[(0b01001, &ENTRY_SNORKELING_13852650475536131090)],
        &[(0b11010, &ENTRY_SNORKELED_8473613528721477540)],
        &[(0b11010, &ENTRY_SNORKELING_13852650475536131090)],
        &[(0b11010, &ENTRY_SNOWPLOW_2634183079313653004)],
        &[(0b11010, &ENTRY_SNOWPLOWS_6320103518456053512)],
        &[(0b01001, &ENTRY_SNOWPLOW_2634183079313653004)],
        &[(0b01001, &ENTRY_SNOWPLOWS_6320103518456053512)],
    ],
    range: 6..=9,
};

static VARS_SM_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_SM_CHILDREN),
    value: None,
};

pub static VARS_SM_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("idge"),
        dictgen::InsensitiveAscii("idges"),
        dictgen::InsensitiveAscii("older"),
        dictgen::InsensitiveAscii("oldered"),
        dictgen::InsensitiveAscii("oldering"),
        dictgen::InsensitiveAscii("olders"),
    ],
    values: &[
        &[(0b01001, &ENTRY_SMIDGEN_1020835176028070080)],
        &[(0b01001, &ENTRY_SMIDGENS_12067204132214853089)],
        &[(0b01001, &ENTRY_SMOLDER_18206679862651421040)],
        &[(0b01001, &ENTRY_SMOLDERED_525255363028764433)],
        &[(0b01001, &ENTRY_SMOLDERING_1321144217497101015)],
        &[(0b01001, &ENTRY_SMOLDERS_5811778710193840809)],
    ],
    range: 4..=8,
};

static VARS_SL_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_SL_CHILDREN),
    value: None,
};

pub static VARS_SL_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("enderise"),
        dictgen::InsensitiveAscii("enderised"),
        dictgen::InsensitiveAscii("enderises"),
        dictgen::InsensitiveAscii("enderising"),
        dictgen::InsensitiveAscii("enderize"),
        dictgen::InsensitiveAscii("enderized"),
        dictgen::InsensitiveAscii("enderizes"),
        dictgen::InsensitiveAscii("enderizing"),
        dictgen::InsensitiveAscii("ier"),
        dictgen::InsensitiveAscii("iest"),
        dictgen::InsensitiveAscii("ily"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SLENDERIZE_8450406323160278788)],
        &[(0b10010, &ENTRY_SLENDERIZED_12017380378072055827)],
        &[(0b10010, &ENTRY_SLENDERIZES_3290303620172743698)],
        &[(0b10010, &ENTRY_SLENDERIZING_16035225838163229483)],
        &[(0b01001, &ENTRY_SLENDERIZE_8450406323160278788)],
        &[(0b01001, &ENTRY_SLENDERIZED_12017380378072055827)],
        &[(0b01001, &ENTRY_SLENDERIZES_3290303620172743698)],
        &[(0b01001, &ENTRY_SLENDERIZING_16035225838163229483)],
        &[(0b00001, &ENTRY_SLIER_9265750496896058833)],
        &[(0b00001, &ENTRY_SLIEST_15096652467551200006)],
        &[(0b10011, &ENTRY_SLYLY_17796644133630896913)],
    ],
    range: 3..=10,
};

static VARS_SK_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_SK_CHILDREN),
    value: None,
};

pub static VARS_SK_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("eptic"),
        dictgen::InsensitiveAscii("eptical"),
        dictgen::InsensitiveAscii("epticaler"),
        dictgen::InsensitiveAscii("epticalest"),
        dictgen::InsensitiveAscii("eptically"),
        dictgen::InsensitiveAscii("epticer"),
        dictgen::InsensitiveAscii("epticest"),
        dictgen::InsensitiveAscii("epticism"),
        dictgen::InsensitiveAscii("epticisms"),
        dictgen::InsensitiveAscii("eptics"),
    ],
    values: &[
        &[(0b11001, &ENTRY_SKEPTIC_9815313097030140436)],
        &[(0b11001, &ENTRY_SKEPTICAL_17849179356584176691)],
        &[(0b11001, &ENTRY_SKEPTICALER_10497826709555834276)],
        &[(0b11001, &ENTRY_SKEPTICALEST_4980384681338816222)],
        &[(0b11001, &ENTRY_SKEPTICALLY_1022245430766512126)],
        &[(0b11001, &ENTRY_SKEPTICER_17239131044137588151)],
        &[(0b11001, &ENTRY_SKEPTICEST_7590086531147625946)],
        &[(0b11001, &ENTRY_SKEPTICISM_14105128952227011757)],
        &[(0b11001, &ENTRY_SKEPTICISMS_4642865009100445057)],
        &[(0b11001, &ENTRY_SKEPTICS_10828965990171531904)],
    ],
    range: 5..=10,
};

static VARS_SI_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_SI_CHILDREN),
    value: None,
};

pub static VARS_SI_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("gnaled"),
        dictgen::InsensitiveAscii("gnaler"),
        dictgen::InsensitiveAscii("gnalers"),
        dictgen::InsensitiveAscii("gnaling"),
        dictgen::InsensitiveAscii("gnalled"),
        dictgen::InsensitiveAscii("gnaller"),
        dictgen::InsensitiveAscii("gnallers"),
        dictgen::InsensitiveAscii("gnalling"),
        dictgen::InsensitiveAscii("ngularisation"),
        dictgen::InsensitiveAscii("ngularisations"),
        dictgen::InsensitiveAscii("ngularise"),
        dictgen::InsensitiveAscii("ngularised"),
        dictgen::InsensitiveAscii("ngularises"),
        dictgen::InsensitiveAscii("ngularising"),
        dictgen::InsensitiveAscii("ngularization"),
        dictgen::InsensitiveAscii("ngularizations"),
        dictgen::InsensitiveAscii("ngularize"),
        dictgen::InsensitiveAscii("ngularized"),
        dictgen::InsensitiveAscii("ngularizes"),
        dictgen::InsensitiveAscii("ngularizing"),
        dictgen::InsensitiveAscii("rup"),
        dictgen::InsensitiveAscii("rups"),
        dictgen::InsensitiveAscii("zably"),
        dictgen::InsensitiveAscii("zeably"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SIGNALED_3243424452669156037)],
        &[(0b00001, &ENTRY_SIGNALER_16546374588847832384)],
        &[(0b00001, &ENTRY_SIGNALERS_12534746997930214169)],
        &[(0b00001, &ENTRY_SIGNALING_10001000836087480137)],
        &[(0b11010, &ENTRY_SIGNALED_3243424452669156037)],
        &[(0b11010, &ENTRY_SIGNALER_16546374588847832384)],
        &[(0b11010, &ENTRY_SIGNALERS_12534746997930214169)],
        &[(0b11010, &ENTRY_SIGNALING_10001000836087480137)],
        &[(0b10010, &ENTRY_SINGULARIZATION_8500018865289525170)],
        &[(0b10010, &ENTRY_SINGULARIZATIONS_13878245436318237762)],
        &[(0b10010, &ENTRY_SINGULARIZE_11329575142831190791)],
        &[(0b10010, &ENTRY_SINGULARIZED_15088538269088551750)],
        &[(0b10010, &ENTRY_SINGULARIZES_9740292182667737407)],
        &[(0b10010, &ENTRY_SINGULARIZING_922470838749445662)],
        &[(0b01001, &ENTRY_SINGULARIZATION_8500018865289525170)],
        &[(0b01001, &ENTRY_SINGULARIZATIONS_13878245436318237762)],
        &[(0b01001, &ENTRY_SINGULARIZE_11329575142831190791)],
        &[(0b01001, &ENTRY_SINGULARIZED_15088538269088551750)],
        &[(0b01001, &ENTRY_SINGULARIZES_9740292182667737407)],
        &[(0b01001, &ENTRY_SINGULARIZING_922470838749445662)],
        &[(0b00001, &ENTRY_SYRUP_11479307931259416998)],
        &[(0b00001, &ENTRY_SYRUPS_6494928060225946043)],
        &[(0b01001, &ENTRY_SIZABLY_12301409967193602959)],
        &[(0b10011, &ENTRY_SIZABLY_12301409967193602959)],
    ],
    range: 3..=14,
};

static VARS_SH_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_SH_CHILDREN),
    value: None,
};

pub static VARS_SH_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("aikh"),
        dictgen::InsensitiveAscii("aikhs"),
        dictgen::InsensitiveAscii("oveled"),
        dictgen::InsensitiveAscii("oveler"),
        dictgen::InsensitiveAscii("ovelers"),
        dictgen::InsensitiveAscii("oveling"),
        dictgen::InsensitiveAscii("ovelled"),
        dictgen::InsensitiveAscii("oveller"),
        dictgen::InsensitiveAscii("ovellers"),
        dictgen::InsensitiveAscii("ovelling"),
        dictgen::InsensitiveAscii("riveled"),
        dictgen::InsensitiveAscii("riveling"),
        dictgen::InsensitiveAscii("rivelled"),
        dictgen::InsensitiveAscii("rivelling"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SHEIKH_9141106394100021739)],
        &[(0b00001, &ENTRY_SHEIKHS_15546350165137358568)],
        &[(0b00001, &ENTRY_SHOVELED_10216188925046182061)],
        &[(0b01001, &ENTRY_SHOVELER_16005482335483577091)],
        &[(0b01001, &ENTRY_SHOVELERS_9645466719000067881)],
        &[(0b00001, &ENTRY_SHOVELING_6097820986538846736)],
        &[(0b11010, &ENTRY_SHOVELED_10216188925046182061)],
        &[(0b11010, &ENTRY_SHOVELER_16005482335483577091)],
        &[(0b11010, &ENTRY_SHOVELERS_9645466719000067881)],
        &[(0b11010, &ENTRY_SHOVELING_6097820986538846736)],
        &[(0b00001, &ENTRY_SHRIVELED_14279328409283350057)],
        &[(0b00001, &ENTRY_SHRIVELING_7338996136982496684)],
        &[(0b11010, &ENTRY_SHRIVELED_14279328409283350057)],
        &[(0b11010, &ENTRY_SHRIVELING_7338996136982496684)],
    ],
    range: 4..=9,
};

static VARS_SE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_SE_CHILDREN),
    value: None,
};

static VARS_SE_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    Some(&VARS_SEB_NODE),
    Some(&VARS_SEC_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_SEI_NODE),
    None,
    None,
    None,
    None,
    Some(&VARS_SEN_NODE),
    None,
    Some(&VARS_SEP_NODE),
    None,
    Some(&VARS_SER_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_SER_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_SER_CHILDREN),
    value: None,
};

pub static VARS_SER_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ialisation"),
        dictgen::InsensitiveAscii("ialisations"),
        dictgen::InsensitiveAscii("ialise"),
        dictgen::InsensitiveAscii("ialised"),
        dictgen::InsensitiveAscii("ialises"),
        dictgen::InsensitiveAscii("ialising"),
        dictgen::InsensitiveAscii("ialization"),
        dictgen::InsensitiveAscii("ializations"),
        dictgen::InsensitiveAscii("ialize"),
        dictgen::InsensitiveAscii("ialized"),
        dictgen::InsensitiveAscii("ializes"),
        dictgen::InsensitiveAscii("ializing"),
        dictgen::InsensitiveAscii("monise"),
        dictgen::InsensitiveAscii("monised"),
        dictgen::InsensitiveAscii("moniser"),
        dictgen::InsensitiveAscii("monisers"),
        dictgen::InsensitiveAscii("monises"),
        dictgen::InsensitiveAscii("monising"),
        dictgen::InsensitiveAscii("monize"),
        dictgen::InsensitiveAscii("monized"),
        dictgen::InsensitiveAscii("monizer"),
        dictgen::InsensitiveAscii("monizers"),
        dictgen::InsensitiveAscii("monizes"),
        dictgen::InsensitiveAscii("monizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SERIALIZATION_9018956433699872037)],
        &[(0b10010, &ENTRY_SERIALIZATIONS_706918596756843003)],
        &[(0b10010, &ENTRY_SERIALIZE_14877336825166275236)],
        &[(0b10010, &ENTRY_SERIALIZED_8728958192744003140)],
        &[(0b10010, &ENTRY_SERIALIZES_3430793096929337696)],
        &[(0b10010, &ENTRY_SERIALIZING_2676257449327141209)],
        &[(0b01001, &ENTRY_SERIALIZATION_9018956433699872037)],
        &[(0b01001, &ENTRY_SERIALIZATIONS_706918596756843003)],
        &[(0b01001, &ENTRY_SERIALIZE_14877336825166275236)],
        &[(0b01001, &ENTRY_SERIALIZED_8728958192744003140)],
        &[(0b01001, &ENTRY_SERIALIZES_3430793096929337696)],
        &[(0b01001, &ENTRY_SERIALIZING_2676257449327141209)],
        &[(0b10010, &ENTRY_SERMONIZE_18313527686432697628)],
        &[(0b10010, &ENTRY_SERMONIZED_16528095817328710811)],
        &[(0b10010, &ENTRY_SERMONIZER_16673411385474735084)],
        &[(0b10010, &ENTRY_SERMONIZERS_8038249026909210325)],
        &[(0b10010, &ENTRY_SERMONIZES_6019643563928317531)],
        &[(0b10010, &ENTRY_SERMONIZING_11733933952570021776)],
        &[(0b01001, &ENTRY_SERMONIZE_18313527686432697628)],
        &[(0b01001, &ENTRY_SERMONIZED_16528095817328710811)],
        &[(0b01001, &ENTRY_SERMONIZER_16673411385474735084)],
        &[(0b01001, &ENTRY_SERMONIZERS_8038249026909210325)],
        &[(0b01001, &ENTRY_SERMONIZES_6019643563928317531)],
        &[(0b01001, &ENTRY_SERMONIZING_11733933952570021776)],
    ],
    range: 6..=11,
};

static VARS_SEP_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_SEP_CHILDREN),
    value: None,
};

pub static VARS_SEP_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ticaemia"),
        dictgen::InsensitiveAscii("ticaemias"),
        dictgen::InsensitiveAscii("ticaemic"),
        dictgen::InsensitiveAscii("ticemia"),
        dictgen::InsensitiveAscii("ticemias"),
        dictgen::InsensitiveAscii("ticemic"),
        dictgen::InsensitiveAscii("ulcher"),
        dictgen::InsensitiveAscii("ulchered"),
        dictgen::InsensitiveAscii("ulchering"),
        dictgen::InsensitiveAscii("ulchers"),
        dictgen::InsensitiveAscii("ulchre"),
        dictgen::InsensitiveAscii("ulchred"),
        dictgen::InsensitiveAscii("ulchres"),
        dictgen::InsensitiveAscii("ulchring"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SEPTICEMIA_15776803637197261182)],
        &[(0b10010, &ENTRY_SEPTICEMIAS_8755899979809830376)],
        &[(0b10010, &ENTRY_SEPTICEMIC_16980008368837900987)],
        &[(0b01001, &ENTRY_SEPTICEMIA_15776803637197261182)],
        &[(0b01001, &ENTRY_SEPTICEMIAS_8755899979809830376)],
        &[(0b01001, &ENTRY_SEPTICEMIC_16980008368837900987)],
        &[(0b00001, &ENTRY_SEPULCHER_18098224318037396545)],
        &[(0b00001, &ENTRY_SEPULCHERED_6261011539804735837)],
        &[(0b00001, &ENTRY_SEPULCHERING_13256373528547912718)],
        &[(0b00001, &ENTRY_SEPULCHERS_1058787016282390839)],
        &[(0b11010, &ENTRY_SEPULCHER_18098224318037396545)],
        &[(0b11010, &ENTRY_SEPULCHERED_6261011539804735837)],
        &[(0b11010, &ENTRY_SEPULCHERS_1058787016282390839)],
        &[(0b11010, &ENTRY_SEPULCHERING_13256373528547912718)],
    ],
    range: 6..=9,
};

static VARS_SEN_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_SEN_CHILDREN),
    value: None,
};

pub static VARS_SEN_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("sationalise"),
        dictgen::InsensitiveAscii("sationalised"),
        dictgen::InsensitiveAscii("sationalises"),
        dictgen::InsensitiveAscii("sationalising"),
        dictgen::InsensitiveAscii("sationalize"),
        dictgen::InsensitiveAscii("sationalized"),
        dictgen::InsensitiveAscii("sationalizes"),
        dictgen::InsensitiveAscii("sationalizing"),
        dictgen::InsensitiveAscii("sitisation"),
        dictgen::InsensitiveAscii("sitisations"),
        dictgen::InsensitiveAscii("sitise"),
        dictgen::InsensitiveAscii("sitised"),
        dictgen::InsensitiveAscii("sitiser"),
        dictgen::InsensitiveAscii("sitisers"),
        dictgen::InsensitiveAscii("sitises"),
        dictgen::InsensitiveAscii("sitising"),
        dictgen::InsensitiveAscii("sitization"),
        dictgen::InsensitiveAscii("sitizations"),
        dictgen::InsensitiveAscii("sitize"),
        dictgen::InsensitiveAscii("sitized"),
        dictgen::InsensitiveAscii("sitizer"),
        dictgen::InsensitiveAscii("sitizers"),
        dictgen::InsensitiveAscii("sitizes"),
        dictgen::InsensitiveAscii("sitizing"),
        dictgen::InsensitiveAscii("sualise"),
        dictgen::InsensitiveAscii("sualised"),
        dictgen::InsensitiveAscii("sualises"),
        dictgen::InsensitiveAscii("sualising"),
        dictgen::InsensitiveAscii("sualize"),
        dictgen::InsensitiveAscii("sualized"),
        dictgen::InsensitiveAscii("sualizes"),
        dictgen::InsensitiveAscii("sualizing"),
        dictgen::InsensitiveAscii("timentalisation"),
        dictgen::InsensitiveAscii("timentalisations"),
        dictgen::InsensitiveAscii("timentalise"),
        dictgen::InsensitiveAscii("timentalised"),
        dictgen::InsensitiveAscii("timentalises"),
        dictgen::InsensitiveAscii("timentalising"),
        dictgen::InsensitiveAscii("timentalization"),
        dictgen::InsensitiveAscii("timentalizations"),
        dictgen::InsensitiveAscii("timentalize"),
        dictgen::InsensitiveAscii("timentalized"),
        dictgen::InsensitiveAscii("timentalizes"),
        dictgen::InsensitiveAscii("timentalizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SENSATIONALIZE_4701218119855164579)],
        &[(0b10010, &ENTRY_SENSATIONALIZED_806729255320749316)],
        &[(0b10010, &ENTRY_SENSATIONALIZES_1873975152603613564)],
        &[(0b10010, &ENTRY_SENSATIONALIZING_16018544793631553710)],
        &[(0b01001, &ENTRY_SENSATIONALIZE_4701218119855164579)],
        &[(0b01001, &ENTRY_SENSATIONALIZED_806729255320749316)],
        &[(0b01001, &ENTRY_SENSATIONALIZES_1873975152603613564)],
        &[(0b01001, &ENTRY_SENSATIONALIZING_16018544793631553710)],
        &[(0b10010, &ENTRY_SENSITIZATION_17980445782706254952)],
        &[(0b10010, &ENTRY_SENSITIZATIONS_3771550480827878176)],
        &[(0b10010, &ENTRY_SENSITIZE_16896529045122621888)],
        &[(0b10010, &ENTRY_SENSITIZED_3723688270446372923)],
        &[(0b10010, &ENTRY_SENSITIZER_13590195476574032900)],
        &[(0b10010, &ENTRY_SENSITIZERS_837347902048952541)],
        &[(0b10010, &ENTRY_SENSITIZES_1732547089436557908)],
        &[(0b10010, &ENTRY_SENSITIZING_2002820405955253385)],
        &[(0b01001, &ENTRY_SENSITIZATION_17980445782706254952)],
        &[(0b01001, &ENTRY_SENSITIZATIONS_3771550480827878176)],
        &[(0b01001, &ENTRY_SENSITIZE_16896529045122621888)],
        &[(0b01001, &ENTRY_SENSITIZED_3723688270446372923)],
        &[(0b01001, &ENTRY_SENSITIZER_13590195476574032900)],
        &[(0b01001, &ENTRY_SENSITIZERS_837347902048952541)],
        &[(0b01001, &ENTRY_SENSITIZES_1732547089436557908)],
        &[(0b01001, &ENTRY_SENSITIZING_2002820405955253385)],
        &[(0b10010, &ENTRY_SENSUALIZE_430137685449901167)],
        &[(0b10010, &ENTRY_SENSUALIZED_5037909159991545251)],
        &[(0b10010, &ENTRY_SENSUALIZES_276828862031219211)],
        &[(0b10010, &ENTRY_SENSUALIZING_5522084897844086892)],
        &[(0b01001, &ENTRY_SENSUALIZE_430137685449901167)],
        &[(0b01001, &ENTRY_SENSUALIZED_5037909159991545251)],
        &[(0b01001, &ENTRY_SENSUALIZES_276828862031219211)],
        &[(0b01001, &ENTRY_SENSUALIZING_5522084897844086892)],
        &[(0b10010, &ENTRY_SENTIMENTALIZATION_5296627102104537727)],
        &[(0b10010, &ENTRY_SENTIMENTALIZATIONS_13391940016403046982)],
        &[(0b10010, &ENTRY_SENTIMENTALIZE_12182871308532479588)],
        &[(0b10010, &ENTRY_SENTIMENTALIZED_16225167419707712005)],
        &[(0b10010, &ENTRY_SENTIMENTALIZES_16806348349169501348)],
        &[(0b10010, &ENTRY_SENTIMENTALIZING_5876768100471681381)],
        &[(0b01001, &ENTRY_SENTIMENTALIZATION_5296627102104537727)],
        &[(0b01001, &ENTRY_SENTIMENTALIZATIONS_13391940016403046982)],
        &[(0b01001, &ENTRY_SENTIMENTALIZE_12182871308532479588)],
        &[(0b01001, &ENTRY_SENTIMENTALIZED_16225167419707712005)],
        &[(0b01001, &ENTRY_SENTIMENTALIZES_16806348349169501348)],
        &[(0b01001, &ENTRY_SENTIMENTALIZING_5876768100471681381)],
    ],
    range: 6..=16,
};

static VARS_SEI_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_SEI_CHILDREN),
    value: None,
};

pub static VARS_SEI_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ser"),
        dictgen::InsensitiveAscii("sers"),
        dictgen::InsensitiveAscii("zer"),
        dictgen::InsensitiveAscii("zers"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SEIZER_9955492685377349774)],
        &[(0b10010, &ENTRY_SEIZERS_7950705537771035669)],
        &[(0b01001, &ENTRY_SEIZER_9955492685377349774)],
        &[(0b01001, &ENTRY_SEIZERS_7950705537771035669)],
    ],
    range: 3..=4,
};

static VARS_SEC_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_SEC_CHILDREN),
    value: None,
};

pub static VARS_SEC_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("tionalise"),
        dictgen::InsensitiveAscii("tionalised"),
        dictgen::InsensitiveAscii("tionalises"),
        dictgen::InsensitiveAscii("tionalising"),
        dictgen::InsensitiveAscii("tionalize"),
        dictgen::InsensitiveAscii("tionalized"),
        dictgen::InsensitiveAscii("tionalizes"),
        dictgen::InsensitiveAscii("tionalizing"),
        dictgen::InsensitiveAscii("ularisation"),
        dictgen::InsensitiveAscii("ularisations"),
        dictgen::InsensitiveAscii("ularise"),
        dictgen::InsensitiveAscii("ularised"),
        dictgen::InsensitiveAscii("ularises"),
        dictgen::InsensitiveAscii("ularising"),
        dictgen::InsensitiveAscii("ularization"),
        dictgen::InsensitiveAscii("ularizations"),
        dictgen::InsensitiveAscii("ularize"),
        dictgen::InsensitiveAscii("ularized"),
        dictgen::InsensitiveAscii("ularizes"),
        dictgen::InsensitiveAscii("ularizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SECTIONALIZE_2892469613560393091)],
        &[(0b10010, &ENTRY_SECTIONALIZED_5043821153558608530)],
        &[(0b10010, &ENTRY_SECTIONALIZES_11528039426529780489)],
        &[(0b10010, &ENTRY_SECTIONALIZING_17081195346063464372)],
        &[(0b01001, &ENTRY_SECTIONALIZE_2892469613560393091)],
        &[(0b01001, &ENTRY_SECTIONALIZED_5043821153558608530)],
        &[(0b01001, &ENTRY_SECTIONALIZES_11528039426529780489)],
        &[(0b01001, &ENTRY_SECTIONALIZING_17081195346063464372)],
        &[(0b10010, &ENTRY_SECULARIZATION_1401194994331432655)],
        &[(0b10010, &ENTRY_SECULARIZATIONS_4846586083503105748)],
        &[(0b10010, &ENTRY_SECULARIZE_7264705334185351711)],
        &[(0b10010, &ENTRY_SECULARIZED_161249998284362054)],
        &[(0b10010, &ENTRY_SECULARIZES_14861150832754880137)],
        &[(0b10010, &ENTRY_SECULARIZING_13366387235044393553)],
        &[(0b01001, &ENTRY_SECULARIZATION_1401194994331432655)],
        &[(0b01001, &ENTRY_SECULARIZATIONS_4846586083503105748)],
        &[(0b01001, &ENTRY_SECULARIZE_7264705334185351711)],
        &[(0b01001, &ENTRY_SECULARIZED_161249998284362054)],
        &[(0b01001, &ENTRY_SECULARIZES_14861150832754880137)],
        &[(0b01001, &ENTRY_SECULARIZING_13366387235044393553)],
    ],
    range: 7..=12,
};

static VARS_SEB_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_SEB_CHILDREN),
    value: None,
};

pub static VARS_SEB_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("orrhea"),
        dictgen::InsensitiveAscii("orrheas"),
        dictgen::InsensitiveAscii("orrheic"),
        dictgen::InsensitiveAscii("orrhoea"),
        dictgen::InsensitiveAscii("orrhoeas"),
        dictgen::InsensitiveAscii("orrhoeic"),
    ],
    values: &[
        &[(0b01001, &ENTRY_SEBORRHEA_8596487171579042968)],
        &[(0b01001, &ENTRY_SEBORRHEAS_17664504842211561857)],
        &[(0b01001, &ENTRY_SEBORRHEIC_14630913311363871280)],
        &[(0b10010, &ENTRY_SEBORRHEA_8596487171579042968)],
        &[(0b10010, &ENTRY_SEBORRHEAS_17664504842211561857)],
        &[(0b10010, &ENTRY_SEBORRHEIC_14630913311363871280)],
    ],
    range: 6..=8,
};

static VARS_SC_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_SC_CHILDREN),
    value: None,
};

pub static VARS_SC_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("andalise"),
        dictgen::InsensitiveAscii("andalised"),
        dictgen::InsensitiveAscii("andalises"),
        dictgen::InsensitiveAscii("andalising"),
        dictgen::InsensitiveAscii("andalize"),
        dictgen::InsensitiveAscii("andalized"),
        dictgen::InsensitiveAscii("andalizes"),
        dictgen::InsensitiveAscii("andalizing"),
        dictgen::InsensitiveAscii("epter"),
        dictgen::InsensitiveAscii("eptered"),
        dictgen::InsensitiveAscii("eptering"),
        dictgen::InsensitiveAscii("epters"),
        dictgen::InsensitiveAscii("eptic"),
        dictgen::InsensitiveAscii("eptical"),
        dictgen::InsensitiveAscii("epticaler"),
        dictgen::InsensitiveAscii("epticalest"),
        dictgen::InsensitiveAscii("eptically"),
        dictgen::InsensitiveAscii("epticer"),
        dictgen::InsensitiveAscii("epticest"),
        dictgen::InsensitiveAscii("epticism"),
        dictgen::InsensitiveAscii("epticisms"),
        dictgen::InsensitiveAscii("eptics"),
        dictgen::InsensitiveAscii("eptre"),
        dictgen::InsensitiveAscii("eptred"),
        dictgen::InsensitiveAscii("eptres"),
        dictgen::InsensitiveAscii("eptring"),
        dictgen::InsensitiveAscii("hematisation"),
        dictgen::InsensitiveAscii("hematisations"),
        dictgen::InsensitiveAscii("hematise"),
        dictgen::InsensitiveAscii("hematised"),
        dictgen::InsensitiveAscii("hematises"),
        dictgen::InsensitiveAscii("hematising"),
        dictgen::InsensitiveAscii("hematization"),
        dictgen::InsensitiveAscii("hematizations"),
        dictgen::InsensitiveAscii("hematize"),
        dictgen::InsensitiveAscii("hematized"),
        dictgen::InsensitiveAscii("hematizes"),
        dictgen::InsensitiveAscii("hematizing"),
        dictgen::InsensitiveAscii("rutinise"),
        dictgen::InsensitiveAscii("rutinised"),
        dictgen::InsensitiveAscii("rutiniser"),
        dictgen::InsensitiveAscii("rutinisers"),
        dictgen::InsensitiveAscii("rutinises"),
        dictgen::InsensitiveAscii("rutinising"),
        dictgen::InsensitiveAscii("rutinize"),
        dictgen::InsensitiveAscii("rutinized"),
        dictgen::InsensitiveAscii("rutinizer"),
        dictgen::InsensitiveAscii("rutinizers"),
        dictgen::InsensitiveAscii("rutinizes"),
        dictgen::InsensitiveAscii("rutinizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SCANDALIZE_13541782947542016266)],
        &[(0b10010, &ENTRY_SCANDALIZED_1748801122543387716)],
        &[(0b10010, &ENTRY_SCANDALIZES_16055760817318112159)],
        &[(0b10010, &ENTRY_SCANDALIZING_11160701382824581155)],
        &[(0b01001, &ENTRY_SCANDALIZE_13541782947542016266)],
        &[(0b01001, &ENTRY_SCANDALIZED_1748801122543387716)],
        &[(0b01001, &ENTRY_SCANDALIZES_16055760817318112159)],
        &[(0b01001, &ENTRY_SCANDALIZING_11160701382824581155)],
        &[(0b00001, &ENTRY_SCEPTER_10836268721579569022)],
        &[(0b00001, &ENTRY_SCEPTERED_2583853657518887848)],
        &[(0b00001, &ENTRY_SCEPTERING_12898998411155997054)],
        &[(0b00001, &ENTRY_SCEPTERS_11825573776001921342)],
        &[(0b11010, &ENTRY_SKEPTIC_9815313097030140436)],
        &[(0b11010, &ENTRY_SKEPTICAL_17849179356584176691)],
        &[(0b11010, &ENTRY_SKEPTICALER_10497826709555834276)],
        &[(0b11010, &ENTRY_SKEPTICALEST_4980384681338816222)],
        &[(0b11010, &ENTRY_SKEPTICALLY_1022245430766512126)],
        &[(0b11010, &ENTRY_SKEPTICER_17239131044137588151)],
        &[(0b11010, &ENTRY_SKEPTICEST_7590086531147625946)],
        &[(0b11010, &ENTRY_SKEPTICISM_14105128952227011757)],
        &[(0b11010, &ENTRY_SKEPTICISMS_4642865009100445057)],
        &[(0b11010, &ENTRY_SKEPTICS_10828965990171531904)],
        &[(0b11010, &ENTRY_SCEPTER_10836268721579569022)],
        &[(0b11010, &ENTRY_SCEPTERED_2583853657518887848)],
        &[(0b11010, &ENTRY_SCEPTERS_11825573776001921342)],
        &[(0b11010, &ENTRY_SCEPTERING_12898998411155997054)],
        &[(0b10010, &ENTRY_SCHEMATIZATION_1676990775754888542)],
        &[(0b10010, &ENTRY_SCHEMATIZATIONS_6437769711305203183)],
        &[(0b10010, &ENTRY_SCHEMATIZE_16415111007074766296)],
        &[(0b10010, &ENTRY_SCHEMATIZED_16870559659839470180)],
        &[(0b10010, &ENTRY_SCHEMATIZES_5455806020883567582)],
        &[(0b10010, &ENTRY_SCHEMATIZING_17927667405052965293)],
        &[(0b01001, &ENTRY_SCHEMATIZATION_1676990775754888542)],
        &[(0b01001, &ENTRY_SCHEMATIZATIONS_6437769711305203183)],
        &[(0b01001, &ENTRY_SCHEMATIZE_16415111007074766296)],
        &[(0b01001, &ENTRY_SCHEMATIZED_16870559659839470180)],
        &[(0b01001, &ENTRY_SCHEMATIZES_5455806020883567582)],
        &[(0b01001, &ENTRY_SCHEMATIZING_17927667405052965293)],
        &[(0b10010, &ENTRY_SCRUTINIZE_11520578540425679510)],
        &[(0b10010, &ENTRY_SCRUTINIZED_2329669763243403883)],
        &[(0b10010, &ENTRY_SCRUTINIZER_1548201174107564828)],
        &[(0b10010, &ENTRY_SCRUTINIZERS_4674596638392471916)],
        &[(0b10010, &ENTRY_SCRUTINIZES_7393741262112863368)],
        &[(0b10010, &ENTRY_SCRUTINIZING_3883358635901547505)],
        &[(0b01001, &ENTRY_SCRUTINIZE_11520578540425679510)],
        &[(0b01001, &ENTRY_SCRUTINIZED_2329669763243403883)],
        &[(0b01001, &ENTRY_SCRUTINIZER_1548201174107564828)],
        &[(0b01001, &ENTRY_SCRUTINIZERS_4674596638392471916)],
        &[(0b01001, &ENTRY_SCRUTINIZES_7393741262112863368)],
        &[(0b01001, &ENTRY_SCRUTINIZING_3883358635901547505)],
    ],
    range: 5..=13,
};

static VARS_SA_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_SA_CHILDREN),
    value: None,
};

static VARS_SA_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    Some(&VARS_SAB_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_SAL_NODE),
    None,
    Some(&VARS_SAN_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_SAT_NODE),
    None,
    Some(&VARS_SAV_NODE),
    None,
    None,
    None,
    None,
];

static VARS_SAV_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_SAV_CHILDREN),
    value: None,
};

pub static VARS_SAV_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ior"),
        dictgen::InsensitiveAscii("iors"),
        dictgen::InsensitiveAscii("iour"),
        dictgen::InsensitiveAscii("iours"),
        dictgen::InsensitiveAscii("or"),
        dictgen::InsensitiveAscii("ored"),
        dictgen::InsensitiveAscii("orier"),
        dictgen::InsensitiveAscii("ories"),
        dictgen::InsensitiveAscii("oriest"),
        dictgen::InsensitiveAscii("orilies"),
        dictgen::InsensitiveAscii("orily"),
        dictgen::InsensitiveAscii("oriness"),
        dictgen::InsensitiveAscii("orinesses"),
        dictgen::InsensitiveAscii("oring"),
        dictgen::InsensitiveAscii("orless"),
        dictgen::InsensitiveAscii("orlesser"),
        dictgen::InsensitiveAscii("orlessest"),
        dictgen::InsensitiveAscii("ors"),
        dictgen::InsensitiveAscii("ory"),
        dictgen::InsensitiveAscii("our"),
        dictgen::InsensitiveAscii("oured"),
        dictgen::InsensitiveAscii("ourier"),
        dictgen::InsensitiveAscii("ouries"),
        dictgen::InsensitiveAscii("ouriest"),
        dictgen::InsensitiveAscii("ourilies"),
        dictgen::InsensitiveAscii("ourily"),
        dictgen::InsensitiveAscii("ouriness"),
        dictgen::InsensitiveAscii("ourinesses"),
        dictgen::InsensitiveAscii("ouring"),
        dictgen::InsensitiveAscii("ourless"),
        dictgen::InsensitiveAscii("ourlesser"),
        dictgen::InsensitiveAscii("ourlessest"),
        dictgen::InsensitiveAscii("ours"),
        dictgen::InsensitiveAscii("oury"),
    ],
    values: &[
        &[(0b11001, &ENTRY_SAVIOR_9168066282007531402)],
        &[(0b11001, &ENTRY_SAVIORS_678195616807904094)],
        &[(0b11010, &ENTRY_SAVIOR_9168066282007531402)],
        &[(0b11010, &ENTRY_SAVIORS_678195616807904094)],
        &[(0b11001, &ENTRY_SAVOR_2009903601214458496)],
        &[(0b11001, &ENTRY_SAVORED_10072117720481381746)],
        &[(0b11001, &ENTRY_SAVORIER_3288635659178747397)],
        &[(0b11001, &ENTRY_SAVORIES_17238888817605202369)],
        &[(0b11001, &ENTRY_SAVORIEST_5279619332722860135)],
        &[(0b11001, &ENTRY_SAVORILIES_12504192655922635406)],
        &[(0b11001, &ENTRY_SAVORILY_9272760762798011467)],
        &[(0b11001, &ENTRY_SAVORINESS_14234013341609684681)],
        &[(0b11001, &ENTRY_SAVORINESSES_8162276890626615)],
        &[(0b11001, &ENTRY_SAVORING_7676890325408701864)],
        &[(0b11001, &ENTRY_SAVORLESS_16913507828862527408)],
        &[(0b11001, &ENTRY_SAVORLESSER_5411670158498378508)],
        &[(0b11001, &ENTRY_SAVORLESSEST_13669214750218952880)],
        &[(0b11001, &ENTRY_SAVORS_13144818916465986619)],
        &[(0b11001, &ENTRY_SAVORY_10419005726511351932)],
        &[(0b11010, &ENTRY_SAVOR_2009903601214458496)],
        &[(0b11010, &ENTRY_SAVORED_10072117720481381746)],
        &[(0b11010, &ENTRY_SAVORIER_3288635659178747397)],
        &[(0b11010, &ENTRY_SAVORIES_17238888817605202369)],
        &[(0b11010, &ENTRY_SAVORIEST_5279619332722860135)],
        &[(0b11010, &ENTRY_SAVORILIES_12504192655922635406)],
        &[(0b11010, &ENTRY_SAVORILY_9272760762798011467)],
        &[(0b11010, &ENTRY_SAVORINESS_14234013341609684681)],
        &[(0b11010, &ENTRY_SAVORINESSES_8162276890626615)],
        &[(0b11010, &ENTRY_SAVORING_7676890325408701864)],
        &[(0b11010, &ENTRY_SAVORLESS_16913507828862527408)],
        &[(0b11010, &ENTRY_SAVORLESSER_5411670158498378508)],
        &[(0b11010, &ENTRY_SAVORLESSEST_13669214750218952880)],
        &[(0b11010, &ENTRY_SAVORS_13144818916465986619)],
        &[(0b11010, &ENTRY_SAVORY_10419005726511351932)],
    ],
    range: 2..=10,
};

static VARS_SAT_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_SAT_CHILDREN),
    value: None,
};

pub static VARS_SAT_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("irisation"),
        dictgen::InsensitiveAscii("irise"),
        dictgen::InsensitiveAscii("irised"),
        dictgen::InsensitiveAscii("irises"),
        dictgen::InsensitiveAscii("irising"),
        dictgen::InsensitiveAscii("irization"),
        dictgen::InsensitiveAscii("irize"),
        dictgen::InsensitiveAscii("irized"),
        dictgen::InsensitiveAscii("irizes"),
        dictgen::InsensitiveAscii("irizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SATIRIZATION_7570569320271471416)],
        &[(0b10010, &ENTRY_SATIRIZE_6448100415548150058)],
        &[(0b10010, &ENTRY_SATIRIZED_2609000629009969840)],
        &[(0b10010, &ENTRY_SATIRIZES_5832579008425684994)],
        &[(0b10010, &ENTRY_SATIRIZING_4490066541734347659)],
        &[(0b01001, &ENTRY_SATIRIZATION_7570569320271471416)],
        &[(0b01001, &ENTRY_SATIRIZE_6448100415548150058)],
        &[(0b01001, &ENTRY_SATIRIZED_2609000629009969840)],
        &[(0b01001, &ENTRY_SATIRIZES_5832579008425684994)],
        &[(0b01001, &ENTRY_SATIRIZING_4490066541734347659)],
    ],
    range: 5..=9,
};

static VARS_SAN_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_SAN_CHILDREN),
    value: None,
};

pub static VARS_SAN_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("daled"),
        dictgen::InsensitiveAscii("daling"),
        dictgen::InsensitiveAscii("dalled"),
        dictgen::InsensitiveAscii("dalling"),
        dictgen::InsensitiveAscii("itisation"),
        dictgen::InsensitiveAscii("itisations"),
        dictgen::InsensitiveAscii("itise"),
        dictgen::InsensitiveAscii("itised"),
        dictgen::InsensitiveAscii("itiser"),
        dictgen::InsensitiveAscii("itisers"),
        dictgen::InsensitiveAscii("itises"),
        dictgen::InsensitiveAscii("itising"),
        dictgen::InsensitiveAscii("itization"),
        dictgen::InsensitiveAscii("itizations"),
        dictgen::InsensitiveAscii("itize"),
        dictgen::InsensitiveAscii("itized"),
        dictgen::InsensitiveAscii("itizer"),
        dictgen::InsensitiveAscii("itizers"),
        dictgen::InsensitiveAscii("itizes"),
        dictgen::InsensitiveAscii("itizing"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SANDALED_9300809745501373029)],
        &[(0b00001, &ENTRY_SANDALING_9906711963656843788)],
        &[(0b11010, &ENTRY_SANDALED_9300809745501373029)],
        &[(0b11010, &ENTRY_SANDALING_9906711963656843788)],
        &[(0b10010, &ENTRY_SANITIZATION_6597368949679247898)],
        &[(0b10010, &ENTRY_SANITIZATIONS_2020024074797942758)],
        &[(0b10010, &ENTRY_SANITIZE_13579713832357769834)],
        &[(0b10010, &ENTRY_SANITIZED_16038727043373480177)],
        &[(0b10010, &ENTRY_SANITIZER_2612058493574762426)],
        &[(0b10010, &ENTRY_SANITIZERS_15061258670919139218)],
        &[(0b10010, &ENTRY_SANITIZES_6782686809683998201)],
        &[(0b10010, &ENTRY_SANITIZING_8219973274341078569)],
        &[(0b01001, &ENTRY_SANITIZATION_6597368949679247898)],
        &[(0b01001, &ENTRY_SANITIZATIONS_2020024074797942758)],
        &[(0b01001, &ENTRY_SANITIZE_13579713832357769834)],
        &[(0b01001, &ENTRY_SANITIZED_16038727043373480177)],
        &[(0b01001, &ENTRY_SANITIZER_2612058493574762426)],
        &[(0b01001, &ENTRY_SANITIZERS_15061258670919139218)],
        &[(0b01001, &ENTRY_SANITIZES_6782686809683998201)],
        &[(0b01001, &ENTRY_SANITIZING_8219973274341078569)],
    ],
    range: 5..=10,
};

static VARS_SAL_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_SAL_CHILDREN),
    value: None,
};

pub static VARS_SAL_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("able"),
        dictgen::InsensitiveAscii("abler"),
        dictgen::InsensitiveAscii("ablest"),
        dictgen::InsensitiveAscii("inisation"),
        dictgen::InsensitiveAscii("inization"),
        dictgen::InsensitiveAscii("tpeter"),
        dictgen::InsensitiveAscii("tpeters"),
        dictgen::InsensitiveAscii("tpetre"),
        dictgen::InsensitiveAscii("tpetres"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SALABLE_9416288983668269251)],
        &[(0b00001, &ENTRY_SALABLER_12436535119147435528)],
        &[(0b00001, &ENTRY_SALABLEST_11800233581075881251)],
        &[(0b10010, &ENTRY_SALINIZATION_13266963897300307508)],
        &[(0b01001, &ENTRY_SALINIZATION_13266963897300307508)],
        &[(0b00001, &ENTRY_SALTPETER_173602624950229471)],
        &[(0b00001, &ENTRY_SALTPETERS_6897362156960271547)],
        &[(0b11010, &ENTRY_SALTPETER_173602624950229471)],
        &[(0b11010, &ENTRY_SALTPETERS_6897362156960271547)],
    ],
    range: 4..=9,
};

static VARS_SAB_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_SAB_CHILDREN),
    value: None,
};

pub static VARS_SAB_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("er"),
        dictgen::InsensitiveAscii("ered"),
        dictgen::InsensitiveAscii("ering"),
        dictgen::InsensitiveAscii("ers"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SABER_11215537798592835960)],
        &[(0b00001, &ENTRY_SABERED_354016476875728649)],
        &[(0b00001, &ENTRY_SABERING_4510522223387135900)],
        &[(0b00001, &ENTRY_SABERS_17469384891487410695)],
    ],
    range: 2..=5,
};

static VARS_R_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_R_CHILDREN),
    value: None,
};

static VARS_R_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_RA_NODE),
    None,
    None,
    None,
    Some(&VARS_RE_NODE),
    None,
    None,
    Some(&VARS_RH_NODE),
    Some(&VARS_RI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_RO_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_RU_NODE),
    None,
    None,
    None,
    None,
    None,
];

static VARS_RU_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_RU_CHILDREN),
    value: None,
};

pub static VARS_RU_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("bberise"),
        dictgen::InsensitiveAscii("bberised"),
        dictgen::InsensitiveAscii("bberises"),
        dictgen::InsensitiveAscii("bberising"),
        dictgen::InsensitiveAscii("bberize"),
        dictgen::InsensitiveAscii("bberized"),
        dictgen::InsensitiveAscii("bberizes"),
        dictgen::InsensitiveAscii("bberizing"),
        dictgen::InsensitiveAscii("mor"),
        dictgen::InsensitiveAscii("mored"),
        dictgen::InsensitiveAscii("moring"),
        dictgen::InsensitiveAscii("mors"),
        dictgen::InsensitiveAscii("mour"),
        dictgen::InsensitiveAscii("moured"),
        dictgen::InsensitiveAscii("mouring"),
        dictgen::InsensitiveAscii("mours"),
        dictgen::InsensitiveAscii("ralisation"),
        dictgen::InsensitiveAscii("ralisations"),
        dictgen::InsensitiveAscii("ralise"),
        dictgen::InsensitiveAscii("ralised"),
        dictgen::InsensitiveAscii("ralises"),
        dictgen::InsensitiveAscii("ralising"),
        dictgen::InsensitiveAscii("ralization"),
        dictgen::InsensitiveAscii("ralizations"),
        dictgen::InsensitiveAscii("ralize"),
        dictgen::InsensitiveAscii("ralized"),
        dictgen::InsensitiveAscii("ralizes"),
        dictgen::InsensitiveAscii("ralizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_RUBBERIZE_12684219161328931610)],
        &[(0b10010, &ENTRY_RUBBERIZED_14611155806859179613)],
        &[(0b10010, &ENTRY_RUBBERIZES_2448401715198131266)],
        &[(0b10010, &ENTRY_RUBBERIZING_11711303490733810019)],
        &[(0b01001, &ENTRY_RUBBERIZE_12684219161328931610)],
        &[(0b01001, &ENTRY_RUBBERIZED_14611155806859179613)],
        &[(0b01001, &ENTRY_RUBBERIZES_2448401715198131266)],
        &[(0b01001, &ENTRY_RUBBERIZING_11711303490733810019)],
        &[(0b11001, &ENTRY_RUMOR_14879871972679734791)],
        &[(0b11001, &ENTRY_RUMORED_440192285504422993)],
        &[(0b11001, &ENTRY_RUMORING_6988773240152687435)],
        &[(0b11001, &ENTRY_RUMORS_12062925234185208276)],
        &[(0b11010, &ENTRY_RUMOR_14879871972679734791)],
        &[(0b11010, &ENTRY_RUMORED_440192285504422993)],
        &[(0b11010, &ENTRY_RUMORING_6988773240152687435)],
        &[(0b11010, &ENTRY_RUMORS_12062925234185208276)],
        &[(0b10010, &ENTRY_RURALIZATION_12580175398492738873)],
        &[(0b10010, &ENTRY_RURALIZATIONS_13674767207069067961)],
        &[(0b10010, &ENTRY_RURALIZE_15119229364207745147)],
        &[(0b10010, &ENTRY_RURALIZED_3311773382035084319)],
        &[(0b10010, &ENTRY_RURALIZES_1476309458742854492)],
        &[(0b10010, &ENTRY_RURALIZING_421101365792616220)],
        &[(0b01001, &ENTRY_RURALIZATION_12580175398492738873)],
        &[(0b01001, &ENTRY_RURALIZATIONS_13674767207069067961)],
        &[(0b01001, &ENTRY_RURALIZE_15119229364207745147)],
        &[(0b01001, &ENTRY_RURALIZED_3311773382035084319)],
        &[(0b01001, &ENTRY_RURALIZES_1476309458742854492)],
        &[(0b01001, &ENTRY_RURALIZING_421101365792616220)],
    ],
    range: 3..=11,
};

static VARS_RO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_RO_CHILDREN),
    value: None,
};

pub static VARS_RO_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("botisation"),
        dictgen::InsensitiveAscii("botisations"),
        dictgen::InsensitiveAscii("botise"),
        dictgen::InsensitiveAscii("botised"),
        dictgen::InsensitiveAscii("botises"),
        dictgen::InsensitiveAscii("botising"),
        dictgen::InsensitiveAscii("botization"),
        dictgen::InsensitiveAscii("botizations"),
        dictgen::InsensitiveAscii("botize"),
        dictgen::InsensitiveAscii("botized"),
        dictgen::InsensitiveAscii("botizes"),
        dictgen::InsensitiveAscii("botizing"),
        dictgen::InsensitiveAscii("manise"),
        dictgen::InsensitiveAscii("manised"),
        dictgen::InsensitiveAscii("manises"),
        dictgen::InsensitiveAscii("manising"),
        dictgen::InsensitiveAscii("manize"),
        dictgen::InsensitiveAscii("manized"),
        dictgen::InsensitiveAscii("manizes"),
        dictgen::InsensitiveAscii("manizing"),
        dictgen::InsensitiveAscii("manticisation"),
        dictgen::InsensitiveAscii("manticisations"),
        dictgen::InsensitiveAscii("manticise"),
        dictgen::InsensitiveAscii("manticised"),
        dictgen::InsensitiveAscii("manticises"),
        dictgen::InsensitiveAscii("manticising"),
        dictgen::InsensitiveAscii("manticization"),
        dictgen::InsensitiveAscii("manticizations"),
        dictgen::InsensitiveAscii("manticize"),
        dictgen::InsensitiveAscii("manticized"),
        dictgen::InsensitiveAscii("manticizes"),
        dictgen::InsensitiveAscii("manticizing"),
        dictgen::InsensitiveAscii("utinisation"),
        dictgen::InsensitiveAscii("utinisations"),
        dictgen::InsensitiveAscii("utinise"),
        dictgen::InsensitiveAscii("utinised"),
        dictgen::InsensitiveAscii("utinises"),
        dictgen::InsensitiveAscii("utinising"),
        dictgen::InsensitiveAscii("utinization"),
        dictgen::InsensitiveAscii("utinizations"),
        dictgen::InsensitiveAscii("utinize"),
        dictgen::InsensitiveAscii("utinized"),
        dictgen::InsensitiveAscii("utinizes"),
        dictgen::InsensitiveAscii("utinizing"),
        dictgen::InsensitiveAscii("weled"),
        dictgen::InsensitiveAscii("weling"),
        dictgen::InsensitiveAscii("welled"),
        dictgen::InsensitiveAscii("welling"),
    ],
    values: &[
        &[(0b10010, &ENTRY_ROBOTIZATION_10850862175275622758)],
        &[(0b10010, &ENTRY_ROBOTIZATIONS_17425010007834309500)],
        &[(0b10010, &ENTRY_ROBOTIZE_12113166233450095442)],
        &[(0b10010, &ENTRY_ROBOTIZED_5530996200469975174)],
        &[(0b10010, &ENTRY_ROBOTIZES_6429276732898466559)],
        &[(0b10010, &ENTRY_ROBOTIZING_16303228955863605624)],
        &[(0b01001, &ENTRY_ROBOTIZATION_10850862175275622758)],
        &[(0b01001, &ENTRY_ROBOTIZATIONS_17425010007834309500)],
        &[(0b01001, &ENTRY_ROBOTIZE_12113166233450095442)],
        &[(0b01001, &ENTRY_ROBOTIZED_5530996200469975174)],
        &[(0b01001, &ENTRY_ROBOTIZES_6429276732898466559)],
        &[(0b01001, &ENTRY_ROBOTIZING_16303228955863605624)],
        &[(0b10010, &ENTRY_ROMANIZE_17828022341300623695)],
        &[(0b10010, &ENTRY_ROMANIZED_11325302352054785292)],
        &[(0b10010, &ENTRY_ROMANIZES_14316864401141443537)],
        &[(0b10010, &ENTRY_ROMANIZING_6533972516331684265)],
        &[(0b01001, &ENTRY_ROMANIZE_17828022341300623695)],
        &[(0b01001, &ENTRY_ROMANIZED_11325302352054785292)],
        &[(0b01001, &ENTRY_ROMANIZES_14316864401141443537)],
        &[(0b01001, &ENTRY_ROMANIZING_6533972516331684265)],
        &[(0b10010, &ENTRY_ROMANTICIZATION_98519846053872295)],
        &[(0b10010, &ENTRY_ROMANTICIZATIONS_14917933992160685773)],
        &[(0b10010, &ENTRY_ROMANTICIZE_12085162654923168482)],
        &[(0b10010, &ENTRY_ROMANTICIZED_6690263810463145292)],
        &[(0b10010, &ENTRY_ROMANTICIZES_7010079394357286132)],
        &[(0b10010, &ENTRY_ROMANTICIZING_7886244968785418156)],
        &[(0b01001, &ENTRY_ROMANTICIZATION_98519846053872295)],
        &[(0b01001, &ENTRY_ROMANTICIZATIONS_14917933992160685773)],
        &[(0b01001, &ENTRY_ROMANTICIZE_12085162654923168482)],
        &[(0b01001, &ENTRY_ROMANTICIZED_6690263810463145292)],
        &[(0b01001, &ENTRY_ROMANTICIZES_7010079394357286132)],
        &[(0b01001, &ENTRY_ROMANTICIZING_7886244968785418156)],
        &[(0b10010, &ENTRY_ROUTINIZATION_17863253035896437203)],
        &[(0b10010, &ENTRY_ROUTINIZATIONS_2795005236388921160)],
        &[(0b10010, &ENTRY_ROUTINIZE_7572489982015879408)],
        &[(0b10010, &ENTRY_ROUTINIZED_4682046108054080633)],
        &[(0b10010, &ENTRY_ROUTINIZES_17936070643930576806)],
        &[(0b10010, &ENTRY_ROUTINIZING_807124837692788271)],
        &[(0b01001, &ENTRY_ROUTINIZATION_17863253035896437203)],
        &[(0b01001, &ENTRY_ROUTINIZATIONS_2795005236388921160)],
        &[(0b01001, &ENTRY_ROUTINIZE_7572489982015879408)],
        &[(0b01001, &ENTRY_ROUTINIZED_4682046108054080633)],
        &[(0b01001, &ENTRY_ROUTINIZES_17936070643930576806)],
        &[(0b01001, &ENTRY_ROUTINIZING_807124837692788271)],
        &[(0b01001, &ENTRY_ROWELED_12947825968091277960)],
        &[(0b01001, &ENTRY_ROWELING_3646767635271162596)],
        &[(0b11010, &ENTRY_ROWELED_12947825968091277960)],
        &[(0b11010, &ENTRY_ROWELING_3646767635271162596)],
    ],
    range: 5..=14,
};

static VARS_RI_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_RI_CHILDREN),
    value: None,
};

pub static VARS_RI_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("gor"),
        dictgen::InsensitiveAscii("gors"),
        dictgen::InsensitiveAscii("gour"),
        dictgen::InsensitiveAscii("gours"),
        dictgen::InsensitiveAscii("tualisation"),
        dictgen::InsensitiveAscii("tualisations"),
        dictgen::InsensitiveAscii("tualise"),
        dictgen::InsensitiveAscii("tualised"),
        dictgen::InsensitiveAscii("tualises"),
        dictgen::InsensitiveAscii("tualising"),
        dictgen::InsensitiveAscii("tualization"),
        dictgen::InsensitiveAscii("tualizations"),
        dictgen::InsensitiveAscii("tualize"),
        dictgen::InsensitiveAscii("tualized"),
        dictgen::InsensitiveAscii("tualizes"),
        dictgen::InsensitiveAscii("tualizing"),
        dictgen::InsensitiveAscii("valed"),
        dictgen::InsensitiveAscii("valing"),
        dictgen::InsensitiveAscii("valled"),
        dictgen::InsensitiveAscii("valling"),
    ],
    values: &[
        &[(0b11001, &ENTRY_RIGOR_13840324324485661310)],
        &[(0b11001, &ENTRY_RIGORS_3068318220888831390)],
        &[(0b11010, &ENTRY_RIGOR_13840324324485661310)],
        &[(0b11010, &ENTRY_RIGORS_3068318220888831390)],
        &[(0b10010, &ENTRY_RITUALIZATION_17342697987838586636)],
        &[(0b10010, &ENTRY_RITUALIZATIONS_8869257737053182647)],
        &[(0b10010, &ENTRY_RITUALIZE_12932718365597780903)],
        &[(0b10010, &ENTRY_RITUALIZED_4837360641797207469)],
        &[(0b10010, &ENTRY_RITUALIZES_17901433018773934503)],
        &[(0b10010, &ENTRY_RITUALIZING_17963863299966783179)],
        &[(0b01001, &ENTRY_RITUALIZATION_17342697987838586636)],
        &[(0b01001, &ENTRY_RITUALIZATIONS_8869257737053182647)],
        &[(0b01001, &ENTRY_RITUALIZE_12932718365597780903)],
        &[(0b01001, &ENTRY_RITUALIZED_4837360641797207469)],
        &[(0b01001, &ENTRY_RITUALIZES_17901433018773934503)],
        &[(0b01001, &ENTRY_RITUALIZING_17963863299966783179)],
        &[(0b00001, &ENTRY_RIVALED_10007684086261671851)],
        &[(0b00001, &ENTRY_RIVALING_9971938631235821729)],
        &[(0b11010, &ENTRY_RIVALED_10007684086261671851)],
        &[(0b11010, &ENTRY_RIVALING_9971938631235821729)],
    ],
    range: 3..=12,
};

static VARS_RH_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_RH_CHILDREN),
    value: None,
};

pub static VARS_RH_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("apsodise"),
        dictgen::InsensitiveAscii("apsodised"),
        dictgen::InsensitiveAscii("apsodises"),
        dictgen::InsensitiveAscii("apsodising"),
        dictgen::InsensitiveAscii("apsodize"),
        dictgen::InsensitiveAscii("apsodized"),
        dictgen::InsensitiveAscii("apsodizes"),
        dictgen::InsensitiveAscii("apsodizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_RHAPSODIZE_8592901551161811550)],
        &[(0b10010, &ENTRY_RHAPSODIZED_16882300059855716248)],
        &[(0b10010, &ENTRY_RHAPSODIZES_8543334345807282409)],
        &[(0b10010, &ENTRY_RHAPSODIZING_9325748671831046103)],
        &[(0b01001, &ENTRY_RHAPSODIZE_8592901551161811550)],
        &[(0b01001, &ENTRY_RHAPSODIZED_16882300059855716248)],
        &[(0b01001, &ENTRY_RHAPSODIZES_8543334345807282409)],
        &[(0b01001, &ENTRY_RHAPSODIZING_9325748671831046103)],
    ],
    range: 8..=10,
};

static VARS_RE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_RE_CHILDREN),
    value: None,
};

static VARS_RE_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_REA_NODE),
    None,
    Some(&VARS_REC_NODE),
    Some(&VARS_RED_NODE),
    Some(&VARS_REE_NODE),
    Some(&VARS_REF_NODE),
    Some(&VARS_REG_NODE),
    None,
    None,
    None,
    None,
    Some(&VARS_REL_NODE),
    Some(&VARS_REM_NODE),
    None,
    Some(&VARS_REO_NODE),
    Some(&VARS_REP_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_REV_NODE),
    None,
    None,
    None,
    None,
];

static VARS_REV_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_REV_CHILDREN),
    value: None,
};

pub static VARS_REV_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("eled"),
        dictgen::InsensitiveAscii("eler"),
        dictgen::InsensitiveAscii("elers"),
        dictgen::InsensitiveAscii("eling"),
        dictgen::InsensitiveAscii("elings"),
        dictgen::InsensitiveAscii("elled"),
        dictgen::InsensitiveAscii("eller"),
        dictgen::InsensitiveAscii("ellers"),
        dictgen::InsensitiveAscii("elling"),
        dictgen::InsensitiveAscii("ellings"),
        dictgen::InsensitiveAscii("italisation"),
        dictgen::InsensitiveAscii("italisations"),
        dictgen::InsensitiveAscii("italise"),
        dictgen::InsensitiveAscii("italised"),
        dictgen::InsensitiveAscii("italises"),
        dictgen::InsensitiveAscii("italising"),
        dictgen::InsensitiveAscii("italization"),
        dictgen::InsensitiveAscii("italizations"),
        dictgen::InsensitiveAscii("italize"),
        dictgen::InsensitiveAscii("italized"),
        dictgen::InsensitiveAscii("italizes"),
        dictgen::InsensitiveAscii("italizing"),
        dictgen::InsensitiveAscii("olutionise"),
        dictgen::InsensitiveAscii("olutionised"),
        dictgen::InsensitiveAscii("olutionises"),
        dictgen::InsensitiveAscii("olutionising"),
        dictgen::InsensitiveAscii("olutionize"),
        dictgen::InsensitiveAscii("olutionized"),
        dictgen::InsensitiveAscii("olutionizes"),
        dictgen::InsensitiveAscii("olutionizing"),
    ],
    values: &[
        &[(0b00001, &ENTRY_REVELED_10192387357620140676)],
        &[(0b00001, &ENTRY_REVELER_8384109924943712265)],
        &[(0b00001, &ENTRY_REVELERS_9470175687026840)],
        &[(0b00001, &ENTRY_REVELING_59082295884336446)],
        &[(0b00001, &ENTRY_REVELINGS_4220623056617091529)],
        &[(0b11010, &ENTRY_REVELED_10192387357620140676)],
        &[(0b11010, &ENTRY_REVELER_8384109924943712265)],
        &[(0b11010, &ENTRY_REVELERS_9470175687026840)],
        &[(0b11010, &ENTRY_REVELING_59082295884336446)],
        &[(0b11010, &ENTRY_REVELINGS_4220623056617091529)],
        &[(0b10010, &ENTRY_REVITALIZATION_16085757167990752927)],
        &[(0b10010, &ENTRY_REVITALIZATIONS_18307091255909150620)],
        &[(0b10010, &ENTRY_REVITALIZE_6139669234338764878)],
        &[(0b10010, &ENTRY_REVITALIZED_150745644348740042)],
        &[(0b10010, &ENTRY_REVITALIZES_636040321623977777)],
        &[(0b10010, &ENTRY_REVITALIZING_2708402192275645435)],
        &[(0b01001, &ENTRY_REVITALIZATION_16085757167990752927)],
        &[(0b01001, &ENTRY_REVITALIZATIONS_18307091255909150620)],
        &[(0b01001, &ENTRY_REVITALIZE_6139669234338764878)],
        &[(0b01001, &ENTRY_REVITALIZED_150745644348740042)],
        &[(0b01001, &ENTRY_REVITALIZES_636040321623977777)],
        &[(0b01001, &ENTRY_REVITALIZING_2708402192275645435)],
        &[(0b10010, &ENTRY_REVOLUTIONIZE_3470055274275469616)],
        &[(0b10010, &ENTRY_REVOLUTIONIZED_17229010415616229254)],
        &[(0b10010, &ENTRY_REVOLUTIONIZES_11138653471155510637)],
        &[(0b10010, &ENTRY_REVOLUTIONIZING_12791238819359973912)],
        &[(0b01001, &ENTRY_REVOLUTIONIZE_3470055274275469616)],
        &[(0b01001, &ENTRY_REVOLUTIONIZED_17229010415616229254)],
        &[(0b01001, &ENTRY_REVOLUTIONIZES_11138653471155510637)],
        &[(0b01001, &ENTRY_REVOLUTIONIZING_12791238819359973912)],
    ],
    range: 4..=12,
};

static VARS_REP_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_REP_CHILDREN),
    value: None,
};

pub static VARS_REP_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("rogramme"),
        dictgen::InsensitiveAscii("rogrammes"),
    ],
    values: &[
        &[(0b11010, &ENTRY_REPROGRAM_11078775064421802261)],
        &[(0b11010, &ENTRY_REPROGRAMS_17888173972796244259)],
    ],
    range: 8..=9,
};

static VARS_REO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_REO_CHILDREN),
    value: None,
};

pub static VARS_REO_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("rganisation"),
        dictgen::InsensitiveAscii("rganisations"),
        dictgen::InsensitiveAscii("rganise"),
        dictgen::InsensitiveAscii("rganised"),
        dictgen::InsensitiveAscii("rganiser"),
        dictgen::InsensitiveAscii("rganisers"),
        dictgen::InsensitiveAscii("rganises"),
        dictgen::InsensitiveAscii("rganising"),
        dictgen::InsensitiveAscii("rganization"),
        dictgen::InsensitiveAscii("rganizations"),
        dictgen::InsensitiveAscii("rganize"),
        dictgen::InsensitiveAscii("rganized"),
        dictgen::InsensitiveAscii("rganizer"),
        dictgen::InsensitiveAscii("rganizers"),
        dictgen::InsensitiveAscii("rganizes"),
        dictgen::InsensitiveAscii("rganizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_REORGANIZATION_1151969410969297489)],
        &[(0b10010, &ENTRY_REORGANIZATIONS_11667766387551531150)],
        &[(0b10010, &ENTRY_REORGANIZE_2389493382480671527)],
        &[(0b10010, &ENTRY_REORGANIZED_11646562196618885024)],
        &[(0b10010, &ENTRY_REORGANIZER_11200739295922273776)],
        &[(0b10010, &ENTRY_REORGANIZERS_18113843032605671569)],
        &[(0b10010, &ENTRY_REORGANIZES_16934615739192478647)],
        &[(0b10010, &ENTRY_REORGANIZING_12928416874346171218)],
        &[(0b01001, &ENTRY_REORGANIZATION_1151969410969297489)],
        &[(0b01001, &ENTRY_REORGANIZATIONS_11667766387551531150)],
        &[(0b01001, &ENTRY_REORGANIZE_2389493382480671527)],
        &[(0b01001, &ENTRY_REORGANIZED_11646562196618885024)],
        &[(0b01001, &ENTRY_REORGANIZER_11200739295922273776)],
        &[(0b01001, &ENTRY_REORGANIZERS_18113843032605671569)],
        &[(0b01001, &ENTRY_REORGANIZES_16934615739192478647)],
        &[(0b01001, &ENTRY_REORGANIZING_12928416874346171218)],
    ],
    range: 7..=12,
};

static VARS_REM_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_REM_CHILDREN),
    value: None,
};

pub static VARS_REM_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("odeled"),
        dictgen::InsensitiveAscii("odeling"),
        dictgen::InsensitiveAscii("odelled"),
        dictgen::InsensitiveAscii("odelling"),
        dictgen::InsensitiveAscii("old"),
        dictgen::InsensitiveAscii("olded"),
        dictgen::InsensitiveAscii("olding"),
        dictgen::InsensitiveAscii("olds"),
        dictgen::InsensitiveAscii("ould"),
        dictgen::InsensitiveAscii("oulded"),
        dictgen::InsensitiveAscii("oulding"),
        dictgen::InsensitiveAscii("oulds"),
    ],
    values: &[
        &[(0b00001, &ENTRY_REMODELED_12570106397455685821)],
        &[(0b00001, &ENTRY_REMODELING_4879706051317551240)],
        &[(0b11010, &ENTRY_REMODELED_12570106397455685821)],
        &[(0b11010, &ENTRY_REMODELING_4879706051317551240)],
        &[(0b01001, &ENTRY_REMOLD_13068228302489147488)],
        &[(0b01001, &ENTRY_REMOLDED_10738250144723767360)],
        &[(0b01001, &ENTRY_REMOLDING_8712026113000611166)],
        &[(0b01001, &ENTRY_REMOLDS_15039385602131518728)],
        &[(0b11010, &ENTRY_REMOLD_13068228302489147488)],
        &[(0b11010, &ENTRY_REMOLDED_10738250144723767360)],
        &[(0b11010, &ENTRY_REMOLDING_8712026113000611166)],
        &[(0b11010, &ENTRY_REMOLDS_15039385602131518728)],
    ],
    range: 3..=8,
};

static VARS_REL_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_REL_CHILDREN),
    value: None,
};

pub static VARS_REL_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ativisation"),
        dictgen::InsensitiveAscii("ativisations"),
        dictgen::InsensitiveAscii("ativise"),
        dictgen::InsensitiveAscii("ativised"),
        dictgen::InsensitiveAscii("ativises"),
        dictgen::InsensitiveAscii("ativising"),
        dictgen::InsensitiveAscii("ativization"),
        dictgen::InsensitiveAscii("ativizations"),
        dictgen::InsensitiveAscii("ativize"),
        dictgen::InsensitiveAscii("ativized"),
        dictgen::InsensitiveAscii("ativizes"),
        dictgen::InsensitiveAscii("ativizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_RELATIVIZATION_7062869909836897887)],
        &[(0b10010, &ENTRY_RELATIVIZATIONS_5362517281385024225)],
        &[(0b10010, &ENTRY_RELATIVIZE_10808045875347801764)],
        &[(0b10010, &ENTRY_RELATIVIZED_11759925488764903476)],
        &[(0b10010, &ENTRY_RELATIVIZES_786585049191494591)],
        &[(0b10010, &ENTRY_RELATIVIZING_1902231948164306511)],
        &[(0b01001, &ENTRY_RELATIVIZATION_7062869909836897887)],
        &[(0b01001, &ENTRY_RELATIVIZATIONS_5362517281385024225)],
        &[(0b01001, &ENTRY_RELATIVIZE_10808045875347801764)],
        &[(0b01001, &ENTRY_RELATIVIZED_11759925488764903476)],
        &[(0b01001, &ENTRY_RELATIVIZES_786585049191494591)],
        &[(0b01001, &ENTRY_RELATIVIZING_1902231948164306511)],
    ],
    range: 7..=12,
};

static VARS_REG_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_REG_CHILDREN),
    value: None,
};

pub static VARS_REG_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ularisation"),
        dictgen::InsensitiveAscii("ularisations"),
        dictgen::InsensitiveAscii("ularise"),
        dictgen::InsensitiveAscii("ularised"),
        dictgen::InsensitiveAscii("ularises"),
        dictgen::InsensitiveAscii("ularising"),
        dictgen::InsensitiveAscii("ularization"),
        dictgen::InsensitiveAscii("ularizations"),
        dictgen::InsensitiveAscii("ularize"),
        dictgen::InsensitiveAscii("ularized"),
        dictgen::InsensitiveAscii("ularizes"),
        dictgen::InsensitiveAscii("ularizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_REGULARIZATION_612324028625749871)],
        &[(0b10010, &ENTRY_REGULARIZATIONS_14630290664482038867)],
        &[(0b10010, &ENTRY_REGULARIZE_1740270232233444369)],
        &[(0b10010, &ENTRY_REGULARIZED_812906416837862635)],
        &[(0b10010, &ENTRY_REGULARIZES_12868817085662467445)],
        &[(0b10010, &ENTRY_REGULARIZING_11742129379425728272)],
        &[(0b01001, &ENTRY_REGULARIZATION_612324028625749871)],
        &[(0b01001, &ENTRY_REGULARIZATIONS_14630290664482038867)],
        &[(0b01001, &ENTRY_REGULARIZE_1740270232233444369)],
        &[(0b01001, &ENTRY_REGULARIZED_812906416837862635)],
        &[(0b01001, &ENTRY_REGULARIZES_12868817085662467445)],
        &[(0b01001, &ENTRY_REGULARIZING_11742129379425728272)],
    ],
    range: 7..=12,
};

static VARS_REF_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_REF_CHILDREN),
    value: None,
};

pub static VARS_REF_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ueled"),
        dictgen::InsensitiveAscii("ueling"),
        dictgen::InsensitiveAscii("uelled"),
        dictgen::InsensitiveAscii("uelling"),
    ],
    values: &[
        &[(0b00001, &ENTRY_REFUELED_4168397973029836713)],
        &[(0b00001, &ENTRY_REFUELING_10201954940304240886)],
        &[(0b11010, &ENTRY_REFUELED_4168397973029836713)],
        &[(0b11010, &ENTRY_REFUELING_10201954940304240886)],
    ],
    range: 5..=7,
};

static VARS_REE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_REE_CHILDREN),
    value: None,
};

pub static VARS_REE_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("nforce"),
        dictgen::InsensitiveAscii("nforced"),
        dictgen::InsensitiveAscii("nforces"),
        dictgen::InsensitiveAscii("nforcing"),
    ],
    values: &[
        &[(0b00001, &ENTRY_REINFORCE_7852553905371384184)],
        &[(0b00001, &ENTRY_REINFORCED_4138373865022379291)],
        &[(0b00001, &ENTRY_REINFORCES_16061889159840988630)],
        &[(0b00001, &ENTRY_REINFORCING_895373427829466869)],
    ],
    range: 6..=8,
};

static VARS_RED_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_RED_CHILDREN),
    value: None,
};

pub static VARS_RED_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ialed"),
        dictgen::InsensitiveAscii("ialing"),
        dictgen::InsensitiveAscii("ialled"),
        dictgen::InsensitiveAscii("ialling"),
    ],
    values: &[
        &[(0b01001, &ENTRY_REDIALED_11643369836594380113)],
        &[(0b01001, &ENTRY_REDIALING_15990642980268023127)],
        &[(0b11010, &ENTRY_REDIALED_11643369836594380113)],
        &[(0b11010, &ENTRY_REDIALING_15990642980268023127)],
    ],
    range: 5..=7,
};

static VARS_REC_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_REC_CHILDREN),
    value: None,
};

pub static VARS_REC_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("apitalisation"),
        dictgen::InsensitiveAscii("apitalisations"),
        dictgen::InsensitiveAscii("apitalise"),
        dictgen::InsensitiveAscii("apitalised"),
        dictgen::InsensitiveAscii("apitalises"),
        dictgen::InsensitiveAscii("apitalising"),
        dictgen::InsensitiveAscii("apitalization"),
        dictgen::InsensitiveAscii("apitalizations"),
        dictgen::InsensitiveAscii("apitalize"),
        dictgen::InsensitiveAscii("apitalized"),
        dictgen::InsensitiveAscii("apitalizes"),
        dictgen::InsensitiveAscii("apitalizing"),
        dictgen::InsensitiveAscii("ognisability"),
        dictgen::InsensitiveAscii("ognisable"),
        dictgen::InsensitiveAscii("ognisabler"),
        dictgen::InsensitiveAscii("ognisablest"),
        dictgen::InsensitiveAscii("ognisably"),
        dictgen::InsensitiveAscii("ognisance"),
        dictgen::InsensitiveAscii("ognisances"),
        dictgen::InsensitiveAscii("ognise"),
        dictgen::InsensitiveAscii("ognised"),
        dictgen::InsensitiveAscii("ogniser"),
        dictgen::InsensitiveAscii("ognisers"),
        dictgen::InsensitiveAscii("ognises"),
        dictgen::InsensitiveAscii("ognising"),
        dictgen::InsensitiveAscii("ognizability"),
        dictgen::InsensitiveAscii("ognizable"),
        dictgen::InsensitiveAscii("ognizabler"),
        dictgen::InsensitiveAscii("ognizablest"),
        dictgen::InsensitiveAscii("ognizably"),
        dictgen::InsensitiveAscii("ognizance"),
        dictgen::InsensitiveAscii("ognizances"),
        dictgen::InsensitiveAscii("ognize"),
        dictgen::InsensitiveAscii("ognized"),
        dictgen::InsensitiveAscii("ognizer"),
        dictgen::InsensitiveAscii("ognizers"),
        dictgen::InsensitiveAscii("ognizes"),
        dictgen::InsensitiveAscii("ognizing"),
        dictgen::InsensitiveAscii("olonisation"),
        dictgen::InsensitiveAscii("olonisations"),
        dictgen::InsensitiveAscii("olonise"),
        dictgen::InsensitiveAscii("olonised"),
        dictgen::InsensitiveAscii("olonises"),
        dictgen::InsensitiveAscii("olonising"),
        dictgen::InsensitiveAscii("olonization"),
        dictgen::InsensitiveAscii("olonizations"),
        dictgen::InsensitiveAscii("olonize"),
        dictgen::InsensitiveAscii("olonized"),
        dictgen::InsensitiveAscii("olonizes"),
        dictgen::InsensitiveAscii("olonizing"),
        dictgen::InsensitiveAscii("onnoiter"),
        dictgen::InsensitiveAscii("onnoitered"),
        dictgen::InsensitiveAscii("onnoitering"),
        dictgen::InsensitiveAscii("onnoiters"),
        dictgen::InsensitiveAscii("onnoitre"),
        dictgen::InsensitiveAscii("onnoitred"),
        dictgen::InsensitiveAscii("onnoitres"),
        dictgen::InsensitiveAscii("onnoitring"),
    ],
    values: &[
        &[(0b10010, &ENTRY_RECAPITALIZATION_10508729055647744364)],
        &[(0b10010, &ENTRY_RECAPITALIZATIONS_4437798653748561592)],
        &[(0b10010, &ENTRY_RECAPITALIZE_7414811184860400912)],
        &[(0b10010, &ENTRY_RECAPITALIZED_14061551312028988978)],
        &[(0b10010, &ENTRY_RECAPITALIZES_15012732459360105212)],
        &[(0b10010, &ENTRY_RECAPITALIZING_11777631663823328319)],
        &[(0b01001, &ENTRY_RECAPITALIZATION_10508729055647744364)],
        &[(0b01001, &ENTRY_RECAPITALIZATIONS_4437798653748561592)],
        &[(0b01001, &ENTRY_RECAPITALIZE_7414811184860400912)],
        &[(0b01001, &ENTRY_RECAPITALIZED_14061551312028988978)],
        &[(0b01001, &ENTRY_RECAPITALIZES_15012732459360105212)],
        &[(0b01001, &ENTRY_RECAPITALIZING_11777631663823328319)],
        &[(0b10010, &ENTRY_RECOGNIZABILITY_10357285971929431711)],
        &[(0b10010, &ENTRY_RECOGNIZABLE_7613722258514271208)],
        &[(0b10010, &ENTRY_RECOGNIZABLER_4263942192681001064)],
        &[(0b10010, &ENTRY_RECOGNIZABLEST_4777556240445602065)],
        &[(0b10010, &ENTRY_RECOGNIZABLY_5262242687840057985)],
        &[(0b10010, &ENTRY_RECOGNIZANCE_4728169876554590520)],
        &[(0b10010, &ENTRY_RECOGNIZANCES_1889737239613628316)],
        &[(0b10010, &ENTRY_RECOGNIZE_2951534439364429088)],
        &[(0b10010, &ENTRY_RECOGNIZED_8994678971763803574)],
        &[(0b10010, &ENTRY_RECOGNIZER_8837107831671387344)],
        &[(0b10010, &ENTRY_RECOGNIZERS_12071383181262313264)],
        &[(0b10010, &ENTRY_RECOGNIZES_4631719440910592363)],
        &[(0b10010, &ENTRY_RECOGNIZING_7647130431971528373)],
        &[(0b01001, &ENTRY_RECOGNIZABILITY_10357285971929431711)],
        &[(0b01001, &ENTRY_RECOGNIZABLE_7613722258514271208)],
        &[(0b01001, &ENTRY_RECOGNIZABLER_4263942192681001064)],
        &[(0b01001, &ENTRY_RECOGNIZABLEST_4777556240445602065)],
        &[(0b01001, &ENTRY_RECOGNIZABLY_5262242687840057985)],
        &[(0b01001, &ENTRY_RECOGNIZANCE_4728169876554590520)],
        &[(0b01001, &ENTRY_RECOGNIZANCES_1889737239613628316)],
        &[(0b01001, &ENTRY_RECOGNIZE_2951534439364429088)],
        &[(0b01001, &ENTRY_RECOGNIZED_8994678971763803574)],
        &[(0b01001, &ENTRY_RECOGNIZER_8837107831671387344)],
        &[(0b01001, &ENTRY_RECOGNIZERS_12071383181262313264)],
        &[(0b01001, &ENTRY_RECOGNIZES_4631719440910592363)],
        &[(0b01001, &ENTRY_RECOGNIZING_7647130431971528373)],
        &[(0b10010, &ENTRY_RECOLONIZATION_6967476021876992825)],
        &[(0b10010, &ENTRY_RECOLONIZATIONS_1558253647578378818)],
        &[(0b10010, &ENTRY_RECOLONIZE_8041961132234757613)],
        &[(0b10010, &ENTRY_RECOLONIZED_13885306844450340179)],
        &[(0b10010, &ENTRY_RECOLONIZES_2544530612567301872)],
        &[(0b10010, &ENTRY_RECOLONIZING_4581044221369467580)],
        &[(0b01001, &ENTRY_RECOLONIZATION_6967476021876992825)],
        &[(0b01001, &ENTRY_RECOLONIZATIONS_1558253647578378818)],
        &[(0b01001, &ENTRY_RECOLONIZE_8041961132234757613)],
        &[(0b01001, &ENTRY_RECOLONIZED_13885306844450340179)],
        &[(0b01001, &ENTRY_RECOLONIZES_2544530612567301872)],
        &[(0b01001, &ENTRY_RECOLONIZING_4581044221369467580)],
        &[(0b01001, &ENTRY_RECONNOITER_5276997216676634421)],
        &[(0b01001, &ENTRY_RECONNOITERED_2213490465207030464)],
        &[(0b01001, &ENTRY_RECONNOITERING_445941575931390448)],
        &[(0b01001, &ENTRY_RECONNOITERS_525334200628355206)],
        &[(0b11010, &ENTRY_RECONNOITER_5276997216676634421)],
        &[(0b11010, &ENTRY_RECONNOITERED_2213490465207030464)],
        &[(0b11010, &ENTRY_RECONNOITERS_525334200628355206)],
        &[(0b11010, &ENTRY_RECONNOITERING_445941575931390448)],
    ],
    range: 6..=14,
};

static VARS_REA_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_REA_CHILDREN),
    value: None,
};

pub static VARS_REA_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("lisabilities"),
        dictgen::InsensitiveAscii("lisability"),
        dictgen::InsensitiveAscii("lisable"),
        dictgen::InsensitiveAscii("lisabler"),
        dictgen::InsensitiveAscii("lisables"),
        dictgen::InsensitiveAscii("lisablest"),
        dictgen::InsensitiveAscii("lisation"),
        dictgen::InsensitiveAscii("lisations"),
        dictgen::InsensitiveAscii("lise"),
        dictgen::InsensitiveAscii("lised"),
        dictgen::InsensitiveAscii("liser"),
        dictgen::InsensitiveAscii("lisers"),
        dictgen::InsensitiveAscii("lises"),
        dictgen::InsensitiveAscii("lising"),
        dictgen::InsensitiveAscii("lisings"),
        dictgen::InsensitiveAscii("lizabilities"),
        dictgen::InsensitiveAscii("lizability"),
        dictgen::InsensitiveAscii("lizable"),
        dictgen::InsensitiveAscii("lizabler"),
        dictgen::InsensitiveAscii("lizables"),
        dictgen::InsensitiveAscii("lizablest"),
        dictgen::InsensitiveAscii("lization"),
        dictgen::InsensitiveAscii("lizations"),
        dictgen::InsensitiveAscii("lize"),
        dictgen::InsensitiveAscii("lized"),
        dictgen::InsensitiveAscii("lizer"),
        dictgen::InsensitiveAscii("lizers"),
        dictgen::InsensitiveAscii("lizes"),
        dictgen::InsensitiveAscii("lizing"),
        dictgen::InsensitiveAscii("lizings"),
        dictgen::InsensitiveAscii("nalyse"),
        dictgen::InsensitiveAscii("nalysed"),
        dictgen::InsensitiveAscii("nalysing"),
        dictgen::InsensitiveAscii("nalyze"),
        dictgen::InsensitiveAscii("nalyzed"),
        dictgen::InsensitiveAscii("nalyzes"),
        dictgen::InsensitiveAscii("nalyzing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_REALIZABILITIES_13223271680114933460)],
        &[(0b10010, &ENTRY_REALIZABILITY_13322425294944377574)],
        &[(0b10010, &ENTRY_REALIZABLE_10812601608535921771)],
        &[(0b10010, &ENTRY_REALIZABLER_14683688646248955937)],
        &[(0b10010, &ENTRY_REALIZABLES_7049723572386299791)],
        &[(0b10010, &ENTRY_REALIZABLEST_2622856111033460976)],
        &[(0b10010, &ENTRY_REALIZATION_17538125674282335558)],
        &[(0b10010, &ENTRY_REALIZATIONS_12363509003743664991)],
        &[(0b10010, &ENTRY_REALIZE_16854214244264054056)],
        &[(0b10010, &ENTRY_REALIZED_16745895995959846860)],
        &[(0b10010, &ENTRY_REALIZER_1946233796964896252)],
        &[(0b10010, &ENTRY_REALIZERS_8487572591462819622)],
        &[(0b10010, &ENTRY_REALIZES_2138970691925381265)],
        &[(0b10010, &ENTRY_REALIZING_510217803664458507)],
        &[(0b10010, &ENTRY_REALIZINGS_5530634631066484428)],
        &[(0b01001, &ENTRY_REALIZABILITIES_13223271680114933460)],
        &[(0b01001, &ENTRY_REALIZABILITY_13322425294944377574)],
        &[(0b01001, &ENTRY_REALIZABLE_10812601608535921771)],
        &[(0b01001, &ENTRY_REALIZABLER_14683688646248955937)],
        &[(0b01001, &ENTRY_REALIZABLES_7049723572386299791)],
        &[(0b01001, &ENTRY_REALIZABLEST_2622856111033460976)],
        &[(0b01001, &ENTRY_REALIZATION_17538125674282335558)],
        &[(0b01001, &ENTRY_REALIZATIONS_12363509003743664991)],
        &[(0b01001, &ENTRY_REALIZE_16854214244264054056)],
        &[(0b01001, &ENTRY_REALIZED_16745895995959846860)],
        &[(0b01001, &ENTRY_REALIZER_1946233796964896252)],
        &[(0b01001, &ENTRY_REALIZERS_8487572591462819622)],
        &[(0b01001, &ENTRY_REALIZES_2138970691925381265)],
        &[(0b01001, &ENTRY_REALIZING_510217803664458507)],
        &[(0b01001, &ENTRY_REALIZINGS_5530634631066484428)],
        &[(0b10010, &ENTRY_REANALYZE_1610229560390845063)],
        &[(0b10010, &ENTRY_REANALYZED_5684089744805187690)],
        &[(0b10010, &ENTRY_REANALYZING_10344228664173305161)],
        &[(0b01001, &ENTRY_REANALYZE_1610229560390845063)],
        &[(0b01001, &ENTRY_REANALYZED_5684089744805187690)],
        &[(0b01001, &ENTRY_REANALYZES_2618902483948124452)],
        &[(0b01001, &ENTRY_REANALYZING_10344228664173305161)],
    ],
    range: 4..=12,
};

static VARS_RA_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_RA_CHILDREN),
    value: None,
};

pub static VARS_RA_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("cialise"),
        dictgen::InsensitiveAscii("cialises"),
        dictgen::InsensitiveAscii("cialize"),
        dictgen::InsensitiveAscii("cializes"),
        dictgen::InsensitiveAscii("dicalisation"),
        dictgen::InsensitiveAscii("dicalisations"),
        dictgen::InsensitiveAscii("dicalise"),
        dictgen::InsensitiveAscii("dicalised"),
        dictgen::InsensitiveAscii("dicalises"),
        dictgen::InsensitiveAscii("dicalising"),
        dictgen::InsensitiveAscii("dicalization"),
        dictgen::InsensitiveAscii("dicalizations"),
        dictgen::InsensitiveAscii("dicalize"),
        dictgen::InsensitiveAscii("dicalized"),
        dictgen::InsensitiveAscii("dicalizes"),
        dictgen::InsensitiveAscii("dicalizing"),
        dictgen::InsensitiveAscii("ncor"),
        dictgen::InsensitiveAscii("ncors"),
        dictgen::InsensitiveAscii("ncour"),
        dictgen::InsensitiveAscii("ncours"),
        dictgen::InsensitiveAscii("ndomisation"),
        dictgen::InsensitiveAscii("ndomisations"),
        dictgen::InsensitiveAscii("ndomise"),
        dictgen::InsensitiveAscii("ndomised"),
        dictgen::InsensitiveAscii("ndomises"),
        dictgen::InsensitiveAscii("ndomising"),
        dictgen::InsensitiveAscii("ndomization"),
        dictgen::InsensitiveAscii("ndomizations"),
        dictgen::InsensitiveAscii("ndomize"),
        dictgen::InsensitiveAscii("ndomized"),
        dictgen::InsensitiveAscii("ndomizes"),
        dictgen::InsensitiveAscii("ndomizing"),
        dictgen::InsensitiveAscii("tionalisation"),
        dictgen::InsensitiveAscii("tionalisations"),
        dictgen::InsensitiveAscii("tionalise"),
        dictgen::InsensitiveAscii("tionalised"),
        dictgen::InsensitiveAscii("tionaliser"),
        dictgen::InsensitiveAscii("tionalisers"),
        dictgen::InsensitiveAscii("tionalises"),
        dictgen::InsensitiveAscii("tionalising"),
        dictgen::InsensitiveAscii("tionalization"),
        dictgen::InsensitiveAscii("tionalizations"),
        dictgen::InsensitiveAscii("tionalize"),
        dictgen::InsensitiveAscii("tionalized"),
        dictgen::InsensitiveAscii("tionalizer"),
        dictgen::InsensitiveAscii("tionalizers"),
        dictgen::InsensitiveAscii("tionalizes"),
        dictgen::InsensitiveAscii("tionalizing"),
        dictgen::InsensitiveAscii("veled"),
        dictgen::InsensitiveAscii("veling"),
        dictgen::InsensitiveAscii("velings"),
        dictgen::InsensitiveAscii("velled"),
        dictgen::InsensitiveAscii("velling"),
        dictgen::InsensitiveAscii("vellings"),
    ],
    values: &[
        &[(0b10010, &ENTRY_RACIALIZE_3649756850548033240)],
        &[(0b10010, &ENTRY_RACIALIZES_2119895632298352154)],
        &[(0b01001, &ENTRY_RACIALIZE_3649756850548033240)],
        &[(0b01001, &ENTRY_RACIALIZES_2119895632298352154)],
        &[(0b10010, &ENTRY_RADICALIZATION_13110894594007945745)],
        &[(0b10010, &ENTRY_RADICALIZATIONS_11340536761047241964)],
        &[(0b10010, &ENTRY_RADICALIZE_10054640819610183612)],
        &[(0b10010, &ENTRY_RADICALIZED_16178051502331122105)],
        &[(0b10010, &ENTRY_RADICALIZES_7656516679067813609)],
        &[(0b10010, &ENTRY_RADICALIZING_9302352701494268209)],
        &[(0b01001, &ENTRY_RADICALIZATION_13110894594007945745)],
        &[(0b01001, &ENTRY_RADICALIZATIONS_11340536761047241964)],
        &[(0b01001, &ENTRY_RADICALIZE_10054640819610183612)],
        &[(0b01001, &ENTRY_RADICALIZED_16178051502331122105)],
        &[(0b01001, &ENTRY_RADICALIZES_7656516679067813609)],
        &[(0b01001, &ENTRY_RADICALIZING_9302352701494268209)],
        &[(0b11001, &ENTRY_RANCOR_9356695782734834392)],
        &[(0b11001, &ENTRY_RANCORS_270940283740230206)],
        &[(0b11010, &ENTRY_RANCOR_9356695782734834392)],
        &[(0b11010, &ENTRY_RANCORS_270940283740230206)],
        &[(0b10010, &ENTRY_RANDOMIZATION_3681577253421449588)],
        &[(0b10010, &ENTRY_RANDOMIZATIONS_17321397777946946784)],
        &[(0b10010, &ENTRY_RANDOMIZE_6072760763688384932)],
        &[(0b10010, &ENTRY_RANDOMIZED_14277029247963491589)],
        &[(0b10010, &ENTRY_RANDOMIZES_13911797236422860580)],
        &[(0b10010, &ENTRY_RANDOMIZING_2799378200434038162)],
        &[(0b01001, &ENTRY_RANDOMIZATION_3681577253421449588)],
        &[(0b01001, &ENTRY_RANDOMIZATIONS_17321397777946946784)],
        &[(0b01001, &ENTRY_RANDOMIZE_6072760763688384932)],
        &[(0b01001, &ENTRY_RANDOMIZED_14277029247963491589)],
        &[(0b01001, &ENTRY_RANDOMIZES_13911797236422860580)],
        &[(0b01001, &ENTRY_RANDOMIZING_2799378200434038162)],
        &[(0b10010, &ENTRY_RATIONALIZATION_15122379068974818074)],
        &[(0b10010, &ENTRY_RATIONALIZATIONS_9800744027548504414)],
        &[(0b10010, &ENTRY_RATIONALIZE_6652701615501848408)],
        &[(0b10010, &ENTRY_RATIONALIZED_1971558827219194409)],
        &[(0b10010, &ENTRY_RATIONALIZER_11150960083745833433)],
        &[(0b10010, &ENTRY_RATIONALIZERS_14291639036077192937)],
        &[(0b10010, &ENTRY_RATIONALIZES_4247086699247832305)],
        &[(0b10010, &ENTRY_RATIONALIZING_8795870211255807930)],
        &[(0b01001, &ENTRY_RATIONALIZATION_15122379068974818074)],
        &[(0b01001, &ENTRY_RATIONALIZATIONS_9800744027548504414)],
        &[(0b01001, &ENTRY_RATIONALIZE_6652701615501848408)],
        &[(0b01001, &ENTRY_RATIONALIZED_1971558827219194409)],
        &[(0b01001, &ENTRY_RATIONALIZER_11150960083745833433)],
        &[(0b01001, &ENTRY_RATIONALIZERS_14291639036077192937)],
        &[(0b01001, &ENTRY_RATIONALIZES_4247086699247832305)],
        &[(0b01001, &ENTRY_RATIONALIZING_8795870211255807930)],
        &[(0b00001, &ENTRY_RAVELED_9671236154632535117)],
        &[
            (0b00001, &ENTRY_RAVELING_11765690468894667622),
            (0b01001, &ENTRY_RAVELING_17031636493348292626),
        ],
        &[(0b01001, &ENTRY_RAVELINGS_15784329780600976151)],
        &[(0b11010, &ENTRY_RAVELED_9671236154632535117)],
        &[
            (0b11010, &ENTRY_RAVELING_11765690468894667622),
            (0b11010, &ENTRY_RAVELING_17031636493348292626),
        ],
        &[(0b11010, &ENTRY_RAVELINGS_15784329780600976151)],
    ],
    range: 4..=14,
};

static VARS_Q_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_Q_CHILDREN),
    value: None,
};

pub static VARS_Q_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("uantisation"),
        dictgen::InsensitiveAscii("uantisations"),
        dictgen::InsensitiveAscii("uantise"),
        dictgen::InsensitiveAscii("uantised"),
        dictgen::InsensitiveAscii("uantises"),
        dictgen::InsensitiveAscii("uantising"),
        dictgen::InsensitiveAscii("uantization"),
        dictgen::InsensitiveAscii("uantizations"),
        dictgen::InsensitiveAscii("uantize"),
        dictgen::InsensitiveAscii("uantized"),
        dictgen::InsensitiveAscii("uantizes"),
        dictgen::InsensitiveAscii("uantizing"),
        dictgen::InsensitiveAscii("uarreled"),
        dictgen::InsensitiveAscii("uarreler"),
        dictgen::InsensitiveAscii("uarrelers"),
        dictgen::InsensitiveAscii("uarreling"),
        dictgen::InsensitiveAscii("uarrelled"),
        dictgen::InsensitiveAscii("uarreller"),
        dictgen::InsensitiveAscii("uarrellers"),
        dictgen::InsensitiveAscii("uarrelling"),
        dictgen::InsensitiveAscii("uestor"),
        dictgen::InsensitiveAscii("uestors"),
        dictgen::InsensitiveAscii("ueueing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_QUANTIZATION_16189268688890136964)],
        &[(0b10010, &ENTRY_QUANTIZATIONS_15578988125770234593)],
        &[(0b10010, &ENTRY_QUANTIZE_17116602340307321764)],
        &[(0b10010, &ENTRY_QUANTIZED_191687807901136208)],
        &[(0b10010, &ENTRY_QUANTIZES_7731963658205656129)],
        &[(0b10010, &ENTRY_QUANTIZING_10481986099348319524)],
        &[(0b01001, &ENTRY_QUANTIZATION_16189268688890136964)],
        &[(0b01001, &ENTRY_QUANTIZATIONS_15578988125770234593)],
        &[(0b01001, &ENTRY_QUANTIZE_17116602340307321764)],
        &[(0b01001, &ENTRY_QUANTIZED_191687807901136208)],
        &[(0b01001, &ENTRY_QUANTIZES_7731963658205656129)],
        &[(0b01001, &ENTRY_QUANTIZING_10481986099348319524)],
        &[(0b00001, &ENTRY_QUARRELED_15985766844967944821)],
        &[(0b00001, &ENTRY_QUARRELER_14446710496260840710)],
        &[(0b00001, &ENTRY_QUARRELERS_11216624719057293145)],
        &[(0b00001, &ENTRY_QUARRELING_14209000824927192944)],
        &[(0b11010, &ENTRY_QUARRELED_15985766844967944821)],
        &[(0b11010, &ENTRY_QUARRELER_14446710496260840710)],
        &[(0b11010, &ENTRY_QUARRELERS_11216624719057293145)],
        &[(0b11010, &ENTRY_QUARRELING_14209000824927192944)],
        &[(0b00001, &ENTRY_QUAESTOR_2102274138115411812)],
        &[(0b00001, &ENTRY_QUAESTORS_10032398541103637992)],
        &[(0b11010, &ENTRY_QUEUING_8138344236437954477)],
    ],
    range: 6..=12,
};

static VARS_P_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_P_CHILDREN),
    value: None,
};

static VARS_P_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_PA_NODE),
    None,
    None,
    None,
    Some(&VARS_PE_NODE),
    None,
    None,
    Some(&VARS_PH_NODE),
    Some(&VARS_PI_NODE),
    None,
    None,
    Some(&VARS_PL_NODE),
    None,
    None,
    Some(&VARS_PO_NODE),
    None,
    None,
    Some(&VARS_PR_NODE),
    Some(&VARS_PS_NODE),
    None,
    Some(&VARS_PU_NODE),
    None,
    None,
    None,
    Some(&VARS_PY_NODE),
    None,
];

static VARS_PY_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_PY_CHILDREN),
    value: None,
};

pub static VARS_PY_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("jama"),
        dictgen::InsensitiveAscii("jamas"),
        dictgen::InsensitiveAscii("orrhea"),
        dictgen::InsensitiveAscii("orrheas"),
        dictgen::InsensitiveAscii("orrhoea"),
        dictgen::InsensitiveAscii("orrhoeas"),
        dictgen::InsensitiveAscii("rolyse"),
        dictgen::InsensitiveAscii("rolysed"),
        dictgen::InsensitiveAscii("rolyses"),
        dictgen::InsensitiveAscii("rolysing"),
        dictgen::InsensitiveAscii("rolyze"),
        dictgen::InsensitiveAscii("rolyzed"),
        dictgen::InsensitiveAscii("rolyzes"),
        dictgen::InsensitiveAscii("rolyzing"),
    ],
    values: &[
        &[(0b11010, &ENTRY_PAJAMA_3939742153808099869)],
        &[(0b11010, &ENTRY_PAJAMAS_18438866384752213563)],
        &[(0b01001, &ENTRY_PYORRHEA_3796710759481808618)],
        &[(0b01001, &ENTRY_PYORRHEAS_10646277786557890077)],
        &[(0b10010, &ENTRY_PYORRHEA_3796710759481808618)],
        &[(0b10010, &ENTRY_PYORRHEAS_10646277786557890077)],
        &[(0b11010, &ENTRY_PYROLYZE_1370306423959504329)],
        &[(0b11010, &ENTRY_PYROLYZED_13833971036459417043)],
        &[(0b11010, &ENTRY_PYROLYZES_4360458297920745869)],
        &[(0b11010, &ENTRY_PYROLYZING_3017668529784184986)],
        &[(0b01001, &ENTRY_PYROLYZE_1370306423959504329)],
        &[(0b01001, &ENTRY_PYROLYZED_13833971036459417043)],
        &[(0b01001, &ENTRY_PYROLYZES_4360458297920745869)],
        &[(0b01001, &ENTRY_PYROLYZING_3017668529784184986)],
    ],
    range: 4..=8,
};

static VARS_PU_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_PU_CHILDREN),
    value: None,
};

pub static VARS_PU_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("blicise"),
        dictgen::InsensitiveAscii("blicised"),
        dictgen::InsensitiveAscii("blicises"),
        dictgen::InsensitiveAscii("blicising"),
        dictgen::InsensitiveAscii("blicize"),
        dictgen::InsensitiveAscii("blicized"),
        dictgen::InsensitiveAscii("blicizes"),
        dictgen::InsensitiveAscii("blicizing"),
        dictgen::InsensitiveAscii("lverisation"),
        dictgen::InsensitiveAscii("lverisations"),
        dictgen::InsensitiveAscii("lverise"),
        dictgen::InsensitiveAscii("lverised"),
        dictgen::InsensitiveAscii("lveriser"),
        dictgen::InsensitiveAscii("lverisers"),
        dictgen::InsensitiveAscii("lverises"),
        dictgen::InsensitiveAscii("lverising"),
        dictgen::InsensitiveAscii("lverization"),
        dictgen::InsensitiveAscii("lverizations"),
        dictgen::InsensitiveAscii("lverize"),
        dictgen::InsensitiveAscii("lverized"),
        dictgen::InsensitiveAscii("lverizer"),
        dictgen::InsensitiveAscii("lverizers"),
        dictgen::InsensitiveAscii("lverizes"),
        dictgen::InsensitiveAscii("lverizing"),
        dictgen::InsensitiveAscii("mmeled"),
        dictgen::InsensitiveAscii("mmeling"),
        dictgen::InsensitiveAscii("mmelled"),
        dictgen::InsensitiveAscii("mmelling"),
    ],
    values: &[
        &[(0b10010, &ENTRY_PUBLICIZE_5424063269919566067)],
        &[(0b10010, &ENTRY_PUBLICIZED_16571421876501016970)],
        &[(0b10010, &ENTRY_PUBLICIZES_9435453312305988637)],
        &[(0b10010, &ENTRY_PUBLICIZING_9494963417088857325)],
        &[(0b01001, &ENTRY_PUBLICIZE_5424063269919566067)],
        &[(0b01001, &ENTRY_PUBLICIZED_16571421876501016970)],
        &[(0b01001, &ENTRY_PUBLICIZES_9435453312305988637)],
        &[(0b01001, &ENTRY_PUBLICIZING_9494963417088857325)],
        &[(0b10010, &ENTRY_PULVERIZATION_17401567700247612056)],
        &[(0b10010, &ENTRY_PULVERIZATIONS_2088646255652876100)],
        &[(0b10010, &ENTRY_PULVERIZE_7762340513545873128)],
        &[(0b10010, &ENTRY_PULVERIZED_8994580757484344110)],
        &[(0b10010, &ENTRY_PULVERIZER_10176365177336582670)],
        &[(0b10010, &ENTRY_PULVERIZERS_9774439820094487955)],
        &[(0b10010, &ENTRY_PULVERIZES_10527798401373635350)],
        &[(0b10010, &ENTRY_PULVERIZING_2591037067348532366)],
        &[(0b01001, &ENTRY_PULVERIZATION_17401567700247612056)],
        &[(0b01001, &ENTRY_PULVERIZATIONS_2088646255652876100)],
        &[(0b01001, &ENTRY_PULVERIZE_7762340513545873128)],
        &[(0b01001, &ENTRY_PULVERIZED_8994580757484344110)],
        &[(0b01001, &ENTRY_PULVERIZER_10176365177336582670)],
        &[(0b01001, &ENTRY_PULVERIZERS_9774439820094487955)],
        &[(0b01001, &ENTRY_PULVERIZES_10527798401373635350)],
        &[(0b01001, &ENTRY_PULVERIZING_2591037067348532366)],
        &[(0b00001, &ENTRY_PUMMELED_14220543769322316417)],
        &[(0b00001, &ENTRY_PUMMELING_86144285377904737)],
        &[(0b11010, &ENTRY_PUMMELED_14220543769322316417)],
        &[(0b11010, &ENTRY_PUMMELING_86144285377904737)],
    ],
    range: 6..=12,
};

static VARS_PS_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_PS_CHILDREN),
    value: None,
};

pub static VARS_PS_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ychoanalyse"),
        dictgen::InsensitiveAscii("ychoanalysed"),
        dictgen::InsensitiveAscii("ychoanalysing"),
        dictgen::InsensitiveAscii("ychoanalyze"),
        dictgen::InsensitiveAscii("ychoanalyzed"),
        dictgen::InsensitiveAscii("ychoanalyzes"),
        dictgen::InsensitiveAscii("ychoanalyzing"),
        dictgen::InsensitiveAscii("ychologise"),
        dictgen::InsensitiveAscii("ychologised"),
        dictgen::InsensitiveAscii("ychologises"),
        dictgen::InsensitiveAscii("ychologising"),
        dictgen::InsensitiveAscii("ychologize"),
        dictgen::InsensitiveAscii("ychologized"),
        dictgen::InsensitiveAscii("ychologizes"),
        dictgen::InsensitiveAscii("ychologizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_PSYCHOANALYZE_13352325501420392703)],
        &[(0b10010, &ENTRY_PSYCHOANALYZED_2361240273552649217)],
        &[(0b10010, &ENTRY_PSYCHOANALYZING_17396903265279304718)],
        &[(0b01001, &ENTRY_PSYCHOANALYZE_13352325501420392703)],
        &[(0b01001, &ENTRY_PSYCHOANALYZED_2361240273552649217)],
        &[(0b01001, &ENTRY_PSYCHOANALYZES_17393570726957476631)],
        &[(0b01001, &ENTRY_PSYCHOANALYZING_17396903265279304718)],
        &[(0b10010, &ENTRY_PSYCHOLOGIZE_5793948135745501907)],
        &[(0b10010, &ENTRY_PSYCHOLOGIZED_6245845065865139826)],
        &[(0b10010, &ENTRY_PSYCHOLOGIZES_5058513302027995583)],
        &[(0b10010, &ENTRY_PSYCHOLOGIZING_3642591565222639415)],
        &[(0b01001, &ENTRY_PSYCHOLOGIZE_5793948135745501907)],
        &[(0b01001, &ENTRY_PSYCHOLOGIZED_6245845065865139826)],
        &[(0b01001, &ENTRY_PSYCHOLOGIZES_5058513302027995583)],
        &[(0b01001, &ENTRY_PSYCHOLOGIZING_3642591565222639415)],
    ],
    range: 10..=13,
};

static VARS_PR_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_PR_CHILDREN),
    value: None,
};

static VARS_PR_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_PRA_NODE),
    None,
    None,
    None,
    Some(&VARS_PRE_NODE),
    None,
    None,
    None,
    Some(&VARS_PRI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_PRO_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_PRO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_PRO_CHILDREN),
    value: None,
};

pub static VARS_PRO_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("fessionalisation"),
        dictgen::InsensitiveAscii("fessionalisations"),
        dictgen::InsensitiveAscii("fessionalise"),
        dictgen::InsensitiveAscii("fessionalised"),
        dictgen::InsensitiveAscii("fessionalises"),
        dictgen::InsensitiveAscii("fessionalising"),
        dictgen::InsensitiveAscii("fessionalization"),
        dictgen::InsensitiveAscii("fessionalizations"),
        dictgen::InsensitiveAscii("fessionalize"),
        dictgen::InsensitiveAscii("fessionalized"),
        dictgen::InsensitiveAscii("fessionalizes"),
        dictgen::InsensitiveAscii("fessionalizing"),
        dictgen::InsensitiveAscii("gramed"),
        dictgen::InsensitiveAscii("gramer"),
        dictgen::InsensitiveAscii("gramers"),
        dictgen::InsensitiveAscii("graming"),
        dictgen::InsensitiveAscii("log"),
        dictgen::InsensitiveAscii("logs"),
        dictgen::InsensitiveAscii("pagandise"),
        dictgen::InsensitiveAscii("pagandised"),
        dictgen::InsensitiveAscii("pagandises"),
        dictgen::InsensitiveAscii("pagandising"),
        dictgen::InsensitiveAscii("pagandize"),
        dictgen::InsensitiveAscii("pagandized"),
        dictgen::InsensitiveAscii("pagandizes"),
        dictgen::InsensitiveAscii("pagandizing"),
        dictgen::InsensitiveAscii("selytisation"),
        dictgen::InsensitiveAscii("selytisations"),
        dictgen::InsensitiveAscii("selytise"),
        dictgen::InsensitiveAscii("selytised"),
        dictgen::InsensitiveAscii("selytiser"),
        dictgen::InsensitiveAscii("selytisers"),
        dictgen::InsensitiveAscii("selytises"),
        dictgen::InsensitiveAscii("selytising"),
        dictgen::InsensitiveAscii("selytization"),
        dictgen::InsensitiveAscii("selytizations"),
        dictgen::InsensitiveAscii("selytize"),
        dictgen::InsensitiveAscii("selytized"),
        dictgen::InsensitiveAscii("selytizer"),
        dictgen::InsensitiveAscii("selytizers"),
        dictgen::InsensitiveAscii("selytizes"),
        dictgen::InsensitiveAscii("selytizing"),
        dictgen::InsensitiveAscii("sopopeia"),
        dictgen::InsensitiveAscii("sopopeias"),
    ],
    values: &[
        &[(0b10010, &ENTRY_PROFESSIONALIZATION_18024061751549463881)],
        &[(0b10010, &ENTRY_PROFESSIONALIZATIONS_15242793239637656612)],
        &[(0b10010, &ENTRY_PROFESSIONALIZE_8390330200790326962)],
        &[(0b10010, &ENTRY_PROFESSIONALIZED_2063985099756041218)],
        &[(0b10010, &ENTRY_PROFESSIONALIZES_13162965236440047136)],
        &[(0b10010, &ENTRY_PROFESSIONALIZING_11815435443308938942)],
        &[(0b01001, &ENTRY_PROFESSIONALIZATION_18024061751549463881)],
        &[(0b01001, &ENTRY_PROFESSIONALIZATIONS_15242793239637656612)],
        &[(0b01001, &ENTRY_PROFESSIONALIZE_8390330200790326962)],
        &[(0b01001, &ENTRY_PROFESSIONALIZED_2063985099756041218)],
        &[(0b01001, &ENTRY_PROFESSIONALIZES_13162965236440047136)],
        &[(0b01001, &ENTRY_PROFESSIONALIZING_11815435443308938942)],
        &[
            (0b00001, &ENTRY_PROGRAMMED_11095179087329270774),
            (0b00001, &ENTRY_PROGRAMMED_14686782791235843952),
        ],
        &[(0b00001, &ENTRY_PROGRAMMER_14647609425245098552)],
        &[(0b00001, &ENTRY_PROGRAMMERS_7198725162117062597)],
        &[
            (0b00001, &ENTRY_PROGRAMMING_3117523448840634735),
            (0b00001, &ENTRY_PROGRAMMING_9189526122229014819),
        ],
        &[(0b00001, &ENTRY_PROLOGUE_11728138965466131419)],
        &[(0b00001, &ENTRY_PROLOGUES_2022541342111438442)],
        &[(0b10010, &ENTRY_PROPAGANDIZE_8177553084887485510)],
        &[(0b10010, &ENTRY_PROPAGANDIZED_16934930634247263476)],
        &[(0b10010, &ENTRY_PROPAGANDIZES_9571312284054421445)],
        &[(0b10010, &ENTRY_PROPAGANDIZING_8734852002578869522)],
        &[(0b01001, &ENTRY_PROPAGANDIZE_8177553084887485510)],
        &[(0b01001, &ENTRY_PROPAGANDIZED_16934930634247263476)],
        &[(0b01001, &ENTRY_PROPAGANDIZES_9571312284054421445)],
        &[(0b01001, &ENTRY_PROPAGANDIZING_8734852002578869522)],
        &[(0b10010, &ENTRY_PROSELYTIZATION_17135856883988053610)],
        &[(0b10010, &ENTRY_PROSELYTIZATIONS_15779681958788343945)],
        &[(0b10010, &ENTRY_PROSELYTIZE_14508434076807964437)],
        &[(0b10010, &ENTRY_PROSELYTIZED_13393641785992171327)],
        &[(0b10010, &ENTRY_PROSELYTIZER_10730288809990334441)],
        &[(0b10010, &ENTRY_PROSELYTIZERS_7582504000576690857)],
        &[(0b10010, &ENTRY_PROSELYTIZES_6759164791000097610)],
        &[(0b10010, &ENTRY_PROSELYTIZING_3222893683296080940)],
        &[(0b01001, &ENTRY_PROSELYTIZATION_17135856883988053610)],
        &[(0b01001, &ENTRY_PROSELYTIZATIONS_15779681958788343945)],
        &[(0b01001, &ENTRY_PROSELYTIZE_14508434076807964437)],
        &[(0b01001, &ENTRY_PROSELYTIZED_13393641785992171327)],
        &[(0b01001, &ENTRY_PROSELYTIZER_10730288809990334441)],
        &[(0b01001, &ENTRY_PROSELYTIZERS_7582504000576690857)],
        &[(0b01001, &ENTRY_PROSELYTIZES_6759164791000097610)],
        &[(0b01001, &ENTRY_PROSELYTIZING_3222893683296080940)],
        &[(0b01001, &ENTRY_PROSOPOPOEIA_3116153132173899307)],
        &[(0b01001, &ENTRY_PROSOPOPOEIAS_10634619028210897533)],
    ],
    range: 3..=17,
};

static VARS_PRI_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_PRI_CHILDREN),
    value: None,
};

pub static VARS_PRI_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("maeval"),
        dictgen::InsensitiveAscii("maevally"),
        dictgen::InsensitiveAscii("oritisation"),
        dictgen::InsensitiveAscii("oritisations"),
        dictgen::InsensitiveAscii("oritise"),
        dictgen::InsensitiveAscii("oritised"),
        dictgen::InsensitiveAscii("oritises"),
        dictgen::InsensitiveAscii("oritising"),
        dictgen::InsensitiveAscii("oritisings"),
        dictgen::InsensitiveAscii("oritization"),
        dictgen::InsensitiveAscii("oritizations"),
        dictgen::InsensitiveAscii("oritize"),
        dictgen::InsensitiveAscii("oritized"),
        dictgen::InsensitiveAscii("oritizes"),
        dictgen::InsensitiveAscii("oritizing"),
        dictgen::InsensitiveAscii("oritizings"),
        dictgen::InsensitiveAscii("se"),
        dictgen::InsensitiveAscii("sed"),
        dictgen::InsensitiveAscii("ser"),
        dictgen::InsensitiveAscii("sers"),
        dictgen::InsensitiveAscii("ses"),
        dictgen::InsensitiveAscii("sing"),
        dictgen::InsensitiveAscii("vatisation"),
        dictgen::InsensitiveAscii("vatisations"),
        dictgen::InsensitiveAscii("vatise"),
        dictgen::InsensitiveAscii("vatised"),
        dictgen::InsensitiveAscii("vatises"),
        dictgen::InsensitiveAscii("vatising"),
        dictgen::InsensitiveAscii("vatization"),
        dictgen::InsensitiveAscii("vatizations"),
        dictgen::InsensitiveAscii("vatize"),
        dictgen::InsensitiveAscii("vatized"),
        dictgen::InsensitiveAscii("vatizes"),
        dictgen::InsensitiveAscii("vatizing"),
    ],
    values: &[
        &[(0b11010, &ENTRY_PRIMEVAL_1417379882500902562)],
        &[(0b11010, &ENTRY_PRIMEVALLY_5695214551446778886)],
        &[(0b10010, &ENTRY_PRIORITIZATION_17373812427352173208)],
        &[(0b10010, &ENTRY_PRIORITIZATIONS_4547440538414190662)],
        &[(0b10010, &ENTRY_PRIORITIZE_7432754868592786562)],
        &[(0b10010, &ENTRY_PRIORITIZED_4527962682420219040)],
        &[(0b10010, &ENTRY_PRIORITIZES_9554518663110998287)],
        &[(0b10010, &ENTRY_PRIORITIZING_10063035288697055724)],
        &[(0b10010, &ENTRY_PRIORITIZINGS_16876590680015495867)],
        &[(0b01001, &ENTRY_PRIORITIZATION_17373812427352173208)],
        &[(0b01001, &ENTRY_PRIORITIZATIONS_4547440538414190662)],
        &[(0b01001, &ENTRY_PRIORITIZE_7432754868592786562)],
        &[(0b01001, &ENTRY_PRIORITIZED_4527962682420219040)],
        &[(0b01001, &ENTRY_PRIORITIZES_9554518663110998287)],
        &[(0b01001, &ENTRY_PRIORITIZING_10063035288697055724)],
        &[(0b01001, &ENTRY_PRIORITIZINGS_16876590680015495867)],
        &[(0b10010, &ENTRY_PRIZE_1961043608814215148)],
        &[(0b10010, &ENTRY_PRIZED_13278503117736836068)],
        &[(0b10010, &ENTRY_PRIZER_3172722922601400896)],
        &[(0b10010, &ENTRY_PRIZERS_15789594842148438822)],
        &[(0b10010, &ENTRY_PRIZES_7638257834418170687)],
        &[(0b10010, &ENTRY_PRIZING_5311484152980850571)],
        &[(0b10010, &ENTRY_PRIVATIZATION_3684133102365221258)],
        &[(0b10010, &ENTRY_PRIVATIZATIONS_17033667469063461810)],
        &[(0b10010, &ENTRY_PRIVATIZE_9023800133991613189)],
        &[(0b10010, &ENTRY_PRIVATIZED_17871845478636985919)],
        &[(0b10010, &ENTRY_PRIVATIZES_15354432852660291680)],
        &[(0b10010, &ENTRY_PRIVATIZING_15665137231742087652)],
        &[(0b01001, &ENTRY_PRIVATIZATION_3684133102365221258)],
        &[(0b01001, &ENTRY_PRIVATIZATIONS_17033667469063461810)],
        &[(0b01001, &ENTRY_PRIVATIZE_9023800133991613189)],
        &[(0b01001, &ENTRY_PRIVATIZED_17871845478636985919)],
        &[(0b01001, &ENTRY_PRIVATIZES_15354432852660291680)],
        &[(0b01001, &ENTRY_PRIVATIZING_15665137231742087652)],
    ],
    range: 2..=12,
};

static VARS_PRE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_PRE_CHILDREN),
    value: None,
};

pub static VARS_PRE_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("conise"),
        dictgen::InsensitiveAscii("conised"),
        dictgen::InsensitiveAscii("conises"),
        dictgen::InsensitiveAscii("conising"),
        dictgen::InsensitiveAscii("conize"),
        dictgen::InsensitiveAscii("conized"),
        dictgen::InsensitiveAscii("conizes"),
        dictgen::InsensitiveAscii("conizing"),
        dictgen::InsensitiveAscii("judgement"),
        dictgen::InsensitiveAscii("judgements"),
        dictgen::InsensitiveAscii("nomen"),
        dictgen::InsensitiveAscii("nomens"),
        dictgen::InsensitiveAscii("sidia"),
        dictgen::InsensitiveAscii("ssurisation"),
        dictgen::InsensitiveAscii("ssurisations"),
        dictgen::InsensitiveAscii("ssurise"),
        dictgen::InsensitiveAscii("ssurised"),
        dictgen::InsensitiveAscii("ssurises"),
        dictgen::InsensitiveAscii("ssurising"),
        dictgen::InsensitiveAscii("ssurization"),
        dictgen::InsensitiveAscii("ssurizations"),
        dictgen::InsensitiveAscii("ssurize"),
        dictgen::InsensitiveAscii("ssurized"),
        dictgen::InsensitiveAscii("ssurizes"),
        dictgen::InsensitiveAscii("ssurizing"),
        dictgen::InsensitiveAscii("tence"),
        dictgen::InsensitiveAscii("tences"),
        dictgen::InsensitiveAscii("tense"),
        dictgen::InsensitiveAscii("tenses"),
        dictgen::InsensitiveAscii("terit"),
        dictgen::InsensitiveAscii("terits"),
        dictgen::InsensitiveAscii("vue"),
        dictgen::InsensitiveAscii("vues"),
    ],
    values: &[
        &[(0b10010, &ENTRY_PRECONIZE_13784477669434917149)],
        &[(0b10010, &ENTRY_PRECONIZED_11673314501314681040)],
        &[(0b10010, &ENTRY_PRECONIZES_16046662733582737370)],
        &[(0b10010, &ENTRY_PRECONIZING_856066415909262347)],
        &[(0b01001, &ENTRY_PRECONIZE_13784477669434917149)],
        &[(0b01001, &ENTRY_PRECONIZED_11673314501314681040)],
        &[(0b01001, &ENTRY_PRECONIZES_16046662733582737370)],
        &[(0b01001, &ENTRY_PRECONIZING_856066415909262347)],
        &[(0b10010, &ENTRY_PREJUDGMENT_16703900164850541684)],
        &[(0b10010, &ENTRY_PREJUDGMENTS_14741815798482492241)],
        &[(0b00001, &ENTRY_PRAENOMEN_12851101647627907857)],
        &[(0b00001, &ENTRY_PRAENOMENS_251912711638326782)],
        &[(0b00001, &ENTRY_PRESIDIUMS_1425790211349943895)],
        &[(0b10010, &ENTRY_PRESSURIZATION_13356670902399248842)],
        &[(0b10010, &ENTRY_PRESSURIZATIONS_118195243034235909)],
        &[(0b10010, &ENTRY_PRESSURIZE_2472285357926099657)],
        &[(0b10010, &ENTRY_PRESSURIZED_13396852261615154911)],
        &[(0b10010, &ENTRY_PRESSURIZES_12650153372563760390)],
        &[(0b10010, &ENTRY_PRESSURIZING_5224479349902662356)],
        &[(0b01001, &ENTRY_PRESSURIZATION_13356670902399248842)],
        &[(0b01001, &ENTRY_PRESSURIZATIONS_118195243034235909)],
        &[(0b01001, &ENTRY_PRESSURIZE_2472285357926099657)],
        &[(0b01001, &ENTRY_PRESSURIZED_13396852261615154911)],
        &[(0b01001, &ENTRY_PRESSURIZES_12650153372563760390)],
        &[(0b01001, &ENTRY_PRESSURIZING_5224479349902662356)],
        &[(0b11010, &ENTRY_PRETENSE_11134246296321318334)],
        &[(0b11010, &ENTRY_PRETENSES_7458659267060171206)],
        &[(0b01001, &ENTRY_PRETENSE_11134246296321318334)],
        &[(0b01001, &ENTRY_PRETENSES_7458659267060171206)],
        &[(0b01001, &ENTRY_PRETERIT_7498968913037091407)],
        &[(0b01001, &ENTRY_PRETERITS_12755061437397802511)],
        &[(0b00001, &ENTRY_PREVIEW_17480641034975402216)],
        &[(0b00001, &ENTRY_PREVIEWS_15754902130358490470)],
    ],
    range: 3..=12,
};

static VARS_PRA_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_PRA_CHILDREN),
    value: None,
};

pub static VARS_PRA_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("cticed"),
        dictgen::InsensitiveAscii("cticer"),
        dictgen::InsensitiveAscii("cticers"),
        dictgen::InsensitiveAscii("cticing"),
        dictgen::InsensitiveAscii("ctiser"),
        dictgen::InsensitiveAscii("ctisers"),
    ],
    values: &[
        &[(0b01001, &ENTRY_PRACTICED_14764358740174771780)],
        &[(0b00001, &ENTRY_PRACTICER_1604829236283350937)],
        &[(0b00001, &ENTRY_PRACTICERS_11781048523398293872)],
        &[(0b01001, &ENTRY_PRACTICING_14301958615475402676)],
        &[(0b11010, &ENTRY_PRACTICER_1604829236283350937)],
        &[(0b11010, &ENTRY_PRACTICERS_11781048523398293872)],
    ],
    range: 6..=7,
};

static VARS_PO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_PO_CHILDREN),
    value: None,
};

static VARS_PO_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    None,
    None,
    Some(&VARS_POE_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_POL_NODE),
    Some(&VARS_POM_NODE),
    None,
    None,
    Some(&VARS_POP_NODE),
    None,
    Some(&VARS_POR_NODE),
    None,
    None,
    Some(&VARS_POU_NODE),
    None,
    None,
    None,
    None,
    None,
];

static VARS_POU_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_POU_CHILDREN),
    value: None,
};

pub static VARS_POU_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("rer"),
        dictgen::InsensitiveAscii("rers"),
    ],
    values: &[
        &[(0b11010, &ENTRY_PORER_2873682223884239996)],
        &[(0b11010, &ENTRY_PORERS_4082508852567391444)],
    ],
    range: 3..=4,
};

static VARS_POR_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_POR_CHILDREN),
    value: None,
};

pub static VARS_POR_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("er"),
        dictgen::InsensitiveAscii("ers"),
    ],
    values: &[
        &[(0b00001, &ENTRY_PORER_2873682223884239996)],
        &[(0b00001, &ENTRY_PORERS_4082508852567391444)],
    ],
    range: 2..=3,
};

static VARS_POP_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_POP_CHILDREN),
    value: None,
};

pub static VARS_POP_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ularisation"),
        dictgen::InsensitiveAscii("ularisations"),
        dictgen::InsensitiveAscii("ularise"),
        dictgen::InsensitiveAscii("ularised"),
        dictgen::InsensitiveAscii("ulariser"),
        dictgen::InsensitiveAscii("ularisers"),
        dictgen::InsensitiveAscii("ularises"),
        dictgen::InsensitiveAscii("ularising"),
        dictgen::InsensitiveAscii("ularization"),
        dictgen::InsensitiveAscii("ularizations"),
        dictgen::InsensitiveAscii("ularize"),
        dictgen::InsensitiveAscii("ularized"),
        dictgen::InsensitiveAscii("ularizer"),
        dictgen::InsensitiveAscii("ularizers"),
        dictgen::InsensitiveAscii("ularizes"),
        dictgen::InsensitiveAscii("ularizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_POPULARIZATION_4319386853038418661)],
        &[(0b10010, &ENTRY_POPULARIZATIONS_9101849244962729450)],
        &[(0b10010, &ENTRY_POPULARIZE_11338007415870421983)],
        &[(0b10010, &ENTRY_POPULARIZED_10236116886713392471)],
        &[(0b10010, &ENTRY_POPULARIZER_3100157993575081442)],
        &[(0b10010, &ENTRY_POPULARIZERS_7507780986550043141)],
        &[(0b10010, &ENTRY_POPULARIZES_14323192839718770214)],
        &[(0b10010, &ENTRY_POPULARIZING_12963060727527671938)],
        &[(0b01001, &ENTRY_POPULARIZATION_4319386853038418661)],
        &[(0b01001, &ENTRY_POPULARIZATIONS_9101849244962729450)],
        &[(0b01001, &ENTRY_POPULARIZE_11338007415870421983)],
        &[(0b01001, &ENTRY_POPULARIZED_10236116886713392471)],
        &[(0b01001, &ENTRY_POPULARIZER_3100157993575081442)],
        &[(0b01001, &ENTRY_POPULARIZERS_7507780986550043141)],
        &[(0b01001, &ENTRY_POPULARIZES_14323192839718770214)],
        &[(0b01001, &ENTRY_POPULARIZING_12963060727527671938)],
    ],
    range: 7..=12,
};

static VARS_POM_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_POM_CHILDREN),
    value: None,
};

pub static VARS_POM_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("meled"),
        dictgen::InsensitiveAscii("meling"),
        dictgen::InsensitiveAscii("melled"),
        dictgen::InsensitiveAscii("melling"),
    ],
    values: &[
        &[(0b00001, &ENTRY_POMMELED_12392540602238287482)],
        &[(0b00001, &ENTRY_POMMELING_9892304044489697369)],
        &[(0b11010, &ENTRY_POMMELED_12392540602238287482)],
        &[(0b11010, &ENTRY_POMMELING_9892304044489697369)],
    ],
    range: 5..=7,
};

static VARS_POL_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_POL_CHILDREN),
    value: None,
};

pub static VARS_POL_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("arisable"),
        dictgen::InsensitiveAscii("arisables"),
        dictgen::InsensitiveAscii("arisation"),
        dictgen::InsensitiveAscii("arisations"),
        dictgen::InsensitiveAscii("arise"),
        dictgen::InsensitiveAscii("arised"),
        dictgen::InsensitiveAscii("ariser"),
        dictgen::InsensitiveAscii("arisers"),
        dictgen::InsensitiveAscii("arises"),
        dictgen::InsensitiveAscii("arising"),
        dictgen::InsensitiveAscii("arizable"),
        dictgen::InsensitiveAscii("arizables"),
        dictgen::InsensitiveAscii("arization"),
        dictgen::InsensitiveAscii("arizations"),
        dictgen::InsensitiveAscii("arize"),
        dictgen::InsensitiveAscii("arized"),
        dictgen::InsensitiveAscii("arizer"),
        dictgen::InsensitiveAscii("arizers"),
        dictgen::InsensitiveAscii("arizes"),
        dictgen::InsensitiveAscii("arizing"),
        dictgen::InsensitiveAscii("emicise"),
        dictgen::InsensitiveAscii("emicised"),
        dictgen::InsensitiveAscii("emicises"),
        dictgen::InsensitiveAscii("emicising"),
        dictgen::InsensitiveAscii("emicize"),
        dictgen::InsensitiveAscii("emicized"),
        dictgen::InsensitiveAscii("emicizes"),
        dictgen::InsensitiveAscii("emicizing"),
        dictgen::InsensitiveAscii("iticisation"),
        dictgen::InsensitiveAscii("iticisations"),
        dictgen::InsensitiveAscii("iticise"),
        dictgen::InsensitiveAscii("iticised"),
        dictgen::InsensitiveAscii("iticises"),
        dictgen::InsensitiveAscii("iticising"),
        dictgen::InsensitiveAscii("iticization"),
        dictgen::InsensitiveAscii("iticizations"),
        dictgen::InsensitiveAscii("iticize"),
        dictgen::InsensitiveAscii("iticized"),
        dictgen::InsensitiveAscii("iticizes"),
        dictgen::InsensitiveAscii("iticizing"),
        dictgen::InsensitiveAscii("ymerisation"),
        dictgen::InsensitiveAscii("ymerisations"),
        dictgen::InsensitiveAscii("ymerise"),
        dictgen::InsensitiveAscii("ymerised"),
        dictgen::InsensitiveAscii("ymerises"),
        dictgen::InsensitiveAscii("ymerising"),
        dictgen::InsensitiveAscii("ymerization"),
        dictgen::InsensitiveAscii("ymerizations"),
        dictgen::InsensitiveAscii("ymerize"),
        dictgen::InsensitiveAscii("ymerized"),
        dictgen::InsensitiveAscii("ymerizes"),
        dictgen::InsensitiveAscii("ymerizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_POLARIZABLE_18223083191028705666)],
        &[(0b10010, &ENTRY_POLARIZABLES_6205801333281852987)],
        &[(0b10010, &ENTRY_POLARIZATION_6614126062136329693)],
        &[(0b10010, &ENTRY_POLARIZATIONS_5016707483625496334)],
        &[(0b10010, &ENTRY_POLARIZE_6991502646544699233)],
        &[(0b10010, &ENTRY_POLARIZED_4384502108509113795)],
        &[(0b10010, &ENTRY_POLARIZER_216484594834440123)],
        &[(0b10010, &ENTRY_POLARIZERS_17435224860043461879)],
        &[(0b10010, &ENTRY_POLARIZES_8543434351223099952)],
        &[(0b10010, &ENTRY_POLARIZING_5791777031620829770)],
        &[(0b01001, &ENTRY_POLARIZABLE_18223083191028705666)],
        &[(0b01001, &ENTRY_POLARIZABLES_6205801333281852987)],
        &[(0b01001, &ENTRY_POLARIZATION_6614126062136329693)],
        &[(0b01001, &ENTRY_POLARIZATIONS_5016707483625496334)],
        &[(0b01001, &ENTRY_POLARIZE_6991502646544699233)],
        &[(0b01001, &ENTRY_POLARIZED_4384502108509113795)],
        &[(0b01001, &ENTRY_POLARIZER_216484594834440123)],
        &[(0b01001, &ENTRY_POLARIZERS_17435224860043461879)],
        &[(0b01001, &ENTRY_POLARIZES_8543434351223099952)],
        &[(0b01001, &ENTRY_POLARIZING_5791777031620829770)],
        &[(0b10010, &ENTRY_POLEMICIZE_15120423673289782910)],
        &[(0b10010, &ENTRY_POLEMICIZED_5043816132806935047)],
        &[(0b10010, &ENTRY_POLEMICIZES_11323884554859340249)],
        &[(0b10010, &ENTRY_POLEMICIZING_17142821477503800842)],
        &[(0b01001, &ENTRY_POLEMICIZE_15120423673289782910)],
        &[(0b01001, &ENTRY_POLEMICIZED_5043816132806935047)],
        &[(0b01001, &ENTRY_POLEMICIZES_11323884554859340249)],
        &[(0b01001, &ENTRY_POLEMICIZING_17142821477503800842)],
        &[(0b10010, &ENTRY_POLITICIZATION_14296189920998092712)],
        &[(0b10010, &ENTRY_POLITICIZATIONS_1624829829441968277)],
        &[(0b10010, &ENTRY_POLITICIZE_14733719891264090605)],
        &[(0b10010, &ENTRY_POLITICIZED_2600843113498243890)],
        &[(0b10010, &ENTRY_POLITICIZES_15842748929836601577)],
        &[(0b10010, &ENTRY_POLITICIZING_2582222145866644700)],
        &[(0b01001, &ENTRY_POLITICIZATION_14296189920998092712)],
        &[(0b01001, &ENTRY_POLITICIZATIONS_1624829829441968277)],
        &[(0b01001, &ENTRY_POLITICIZE_14733719891264090605)],
        &[(0b01001, &ENTRY_POLITICIZED_2600843113498243890)],
        &[(0b01001, &ENTRY_POLITICIZES_15842748929836601577)],
        &[(0b01001, &ENTRY_POLITICIZING_2582222145866644700)],
        &[(0b10010, &ENTRY_POLYMERIZATION_1464478082413309887)],
        &[(0b10010, &ENTRY_POLYMERIZATIONS_6860899723431207692)],
        &[(0b10010, &ENTRY_POLYMERIZE_6708036056371064979)],
        &[(0b10010, &ENTRY_POLYMERIZED_13422662021131191207)],
        &[(0b10010, &ENTRY_POLYMERIZES_2934787247449201471)],
        &[(0b10010, &ENTRY_POLYMERIZING_4276224557971404133)],
        &[(0b01001, &ENTRY_POLYMERIZATION_1464478082413309887)],
        &[(0b01001, &ENTRY_POLYMERIZATIONS_6860899723431207692)],
        &[(0b01001, &ENTRY_POLYMERIZE_6708036056371064979)],
        &[(0b01001, &ENTRY_POLYMERIZED_13422662021131191207)],
        &[(0b01001, &ENTRY_POLYMERIZES_2934787247449201471)],
        &[(0b01001, &ENTRY_POLYMERIZING_4276224557971404133)],
    ],
    range: 5..=12,
};

static VARS_POE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_POE_CHILDREN),
    value: None,
};

pub static VARS_POE_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ticise"),
        dictgen::InsensitiveAscii("ticised"),
        dictgen::InsensitiveAscii("ticises"),
        dictgen::InsensitiveAscii("ticising"),
        dictgen::InsensitiveAscii("ticize"),
        dictgen::InsensitiveAscii("ticized"),
        dictgen::InsensitiveAscii("ticizes"),
        dictgen::InsensitiveAscii("ticizing"),
        dictgen::InsensitiveAscii("tise"),
        dictgen::InsensitiveAscii("tised"),
        dictgen::InsensitiveAscii("tises"),
        dictgen::InsensitiveAscii("tising"),
        dictgen::InsensitiveAscii("tize"),
        dictgen::InsensitiveAscii("tized"),
        dictgen::InsensitiveAscii("tizes"),
        dictgen::InsensitiveAscii("tizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_POETICIZE_3171830565693860719)],
        &[(0b10010, &ENTRY_POETICIZED_11505730651571650970)],
        &[(0b10010, &ENTRY_POETICIZES_932344514096954986)],
        &[(0b10010, &ENTRY_POETICIZING_2145412927507553207)],
        &[(0b01001, &ENTRY_POETICIZE_3171830565693860719)],
        &[(0b01001, &ENTRY_POETICIZED_11505730651571650970)],
        &[(0b01001, &ENTRY_POETICIZES_932344514096954986)],
        &[(0b01001, &ENTRY_POETICIZING_2145412927507553207)],
        &[(0b10010, &ENTRY_POETIZE_4485886018698886455)],
        &[(0b10010, &ENTRY_POETIZED_10784111762264956661)],
        &[(0b10010, &ENTRY_POETIZES_10934814919977679962)],
        &[(0b10010, &ENTRY_POETIZING_14064411681153855919)],
        &[(0b01001, &ENTRY_POETIZE_4485886018698886455)],
        &[(0b01001, &ENTRY_POETIZED_10784111762264956661)],
        &[(0b01001, &ENTRY_POETIZES_10934814919977679962)],
        &[(0b01001, &ENTRY_POETIZING_14064411681153855919)],
    ],
    range: 4..=8,
};

static VARS_PL_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_PL_CHILDREN),
    value: None,
};

static VARS_PL_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_PLA_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_PLO_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_PLU_NODE),
    None,
    None,
    None,
    None,
    None,
];

static VARS_PLU_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_PLU_CHILDREN),
    value: None,
};

pub static VARS_PLU_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ralisation"),
        dictgen::InsensitiveAscii("ralisations"),
        dictgen::InsensitiveAscii("ralise"),
        dictgen::InsensitiveAscii("ralised"),
        dictgen::InsensitiveAscii("ralises"),
        dictgen::InsensitiveAscii("ralising"),
        dictgen::InsensitiveAscii("ralization"),
        dictgen::InsensitiveAscii("ralizations"),
        dictgen::InsensitiveAscii("ralize"),
        dictgen::InsensitiveAscii("ralized"),
        dictgen::InsensitiveAscii("ralizes"),
        dictgen::InsensitiveAscii("ralizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_PLURALIZATION_5670946523880574178)],
        &[(0b10010, &ENTRY_PLURALIZATIONS_18269674181224004202)],
        &[(0b10010, &ENTRY_PLURALIZE_11864296364586636944)],
        &[(0b10010, &ENTRY_PLURALIZED_6800060174654023706)],
        &[(0b10010, &ENTRY_PLURALIZES_11096808149614325328)],
        &[(0b10010, &ENTRY_PLURALIZING_11611672548631403517)],
        &[(0b01001, &ENTRY_PLURALIZATION_5670946523880574178)],
        &[(0b01001, &ENTRY_PLURALIZATIONS_18269674181224004202)],
        &[(0b01001, &ENTRY_PLURALIZE_11864296364586636944)],
        &[(0b01001, &ENTRY_PLURALIZED_6800060174654023706)],
        &[(0b01001, &ENTRY_PLURALIZES_11096808149614325328)],
        &[(0b01001, &ENTRY_PLURALIZING_11611672548631403517)],
    ],
    range: 6..=11,
};

static VARS_PLO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_PLO_CHILDREN),
    value: None,
};

pub static VARS_PLO_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ugh"),
        dictgen::InsensitiveAscii("ughable"),
        dictgen::InsensitiveAscii("ughed"),
        dictgen::InsensitiveAscii("ugher"),
        dictgen::InsensitiveAscii("ughers"),
        dictgen::InsensitiveAscii("ughing"),
        dictgen::InsensitiveAscii("ughman"),
        dictgen::InsensitiveAscii("ughmen"),
        dictgen::InsensitiveAscii("ughs"),
        dictgen::InsensitiveAscii("ughshare"),
        dictgen::InsensitiveAscii("ughshares"),
        dictgen::InsensitiveAscii("w"),
        dictgen::InsensitiveAscii("wable"),
        dictgen::InsensitiveAscii("wed"),
        dictgen::InsensitiveAscii("wer"),
        dictgen::InsensitiveAscii("wers"),
        dictgen::InsensitiveAscii("wing"),
        dictgen::InsensitiveAscii("wman"),
        dictgen::InsensitiveAscii("wmen"),
        dictgen::InsensitiveAscii("ws"),
        dictgen::InsensitiveAscii("wshare"),
        dictgen::InsensitiveAscii("wshares"),
    ],
    values: &[
        &[(0b11010, &ENTRY_PLOW_5294773589996205415)],
        &[(0b10010, &ENTRY_PLOWABLE_17280767722391212022)],
        &[(0b11010, &ENTRY_PLOWED_9574602430050227983)],
        &[(0b10010, &ENTRY_PLOWER_8745478383312458084)],
        &[(0b10010, &ENTRY_PLOWERS_12302245220185487703)],
        &[(0b11010, &ENTRY_PLOWING_17492249086035756049)],
        &[(0b11010, &ENTRY_PLOWMAN_17563255430094623913)],
        &[(0b11010, &ENTRY_PLOWMEN_2445871749264248581)],
        &[(0b11010, &ENTRY_PLOWS_11203227963409601706)],
        &[(0b11010, &ENTRY_PLOWSHARE_951608328770233313)],
        &[(0b11010, &ENTRY_PLOWSHARES_13417439424755185353)],
        &[(0b01001, &ENTRY_PLOW_5294773589996205415)],
        &[(0b01001, &ENTRY_PLOWABLE_17280767722391212022)],
        &[(0b01001, &ENTRY_PLOWED_9574602430050227983)],
        &[(0b01001, &ENTRY_PLOWER_8745478383312458084)],
        &[(0b01001, &ENTRY_PLOWERS_12302245220185487703)],
        &[(0b01001, &ENTRY_PLOWING_17492249086035756049)],
        &[(0b01001, &ENTRY_PLOWMAN_17563255430094623913)],
        &[(0b01001, &ENTRY_PLOWMEN_2445871749264248581)],
        &[(0b01001, &ENTRY_PLOWS_11203227963409601706)],
        &[(0b01001, &ENTRY_PLOWSHARE_951608328770233313)],
        &[(0b01001, &ENTRY_PLOWSHARES_13417439424755185353)],
    ],
    range: 1..=9,
};

static VARS_PLA_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_PLA_CHILDREN),
    value: None,
};

pub static VARS_PLA_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("giarise"),
        dictgen::InsensitiveAscii("giarised"),
        dictgen::InsensitiveAscii("giariser"),
        dictgen::InsensitiveAscii("giarisers"),
        dictgen::InsensitiveAscii("giarises"),
        dictgen::InsensitiveAscii("giarising"),
        dictgen::InsensitiveAscii("giarize"),
        dictgen::InsensitiveAscii("giarized"),
        dictgen::InsensitiveAscii("giarizer"),
        dictgen::InsensitiveAscii("giarizers"),
        dictgen::InsensitiveAscii("giarizes"),
        dictgen::InsensitiveAscii("giarizing"),
        dictgen::InsensitiveAscii("sticise"),
        dictgen::InsensitiveAscii("sticised"),
        dictgen::InsensitiveAscii("sticiser"),
        dictgen::InsensitiveAscii("sticisers"),
        dictgen::InsensitiveAscii("sticises"),
        dictgen::InsensitiveAscii("sticising"),
        dictgen::InsensitiveAscii("sticize"),
        dictgen::InsensitiveAscii("sticized"),
        dictgen::InsensitiveAscii("sticizer"),
        dictgen::InsensitiveAscii("sticizers"),
        dictgen::InsensitiveAscii("sticizes"),
        dictgen::InsensitiveAscii("sticizing"),
        dictgen::InsensitiveAscii("tinisation"),
        dictgen::InsensitiveAscii("tinisations"),
        dictgen::InsensitiveAscii("tinise"),
        dictgen::InsensitiveAscii("tinised"),
        dictgen::InsensitiveAscii("tinises"),
        dictgen::InsensitiveAscii("tinising"),
        dictgen::InsensitiveAscii("tinization"),
        dictgen::InsensitiveAscii("tinizations"),
        dictgen::InsensitiveAscii("tinize"),
        dictgen::InsensitiveAscii("tinized"),
        dictgen::InsensitiveAscii("tinizes"),
        dictgen::InsensitiveAscii("tinizing"),
        dictgen::InsensitiveAscii("titudinise"),
        dictgen::InsensitiveAscii("titudinised"),
        dictgen::InsensitiveAscii("titudinises"),
        dictgen::InsensitiveAscii("titudinising"),
        dictgen::InsensitiveAscii("titudinize"),
        dictgen::InsensitiveAscii("titudinized"),
        dictgen::InsensitiveAscii("titudinizes"),
        dictgen::InsensitiveAscii("titudinizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_PLAGIARIZE_10194759391693640324)],
        &[(0b10010, &ENTRY_PLAGIARIZED_9613017187196721707)],
        &[(0b10010, &ENTRY_PLAGIARIZER_837829193172431711)],
        &[(0b10010, &ENTRY_PLAGIARIZERS_9616347174653166907)],
        &[(0b10010, &ENTRY_PLAGIARIZES_5807100586921225426)],
        &[(0b10010, &ENTRY_PLAGIARIZING_14588615914934086132)],
        &[(0b01001, &ENTRY_PLAGIARIZE_10194759391693640324)],
        &[(0b01001, &ENTRY_PLAGIARIZED_9613017187196721707)],
        &[(0b01001, &ENTRY_PLAGIARIZER_837829193172431711)],
        &[(0b01001, &ENTRY_PLAGIARIZERS_9616347174653166907)],
        &[(0b01001, &ENTRY_PLAGIARIZES_5807100586921225426)],
        &[(0b01001, &ENTRY_PLAGIARIZING_14588615914934086132)],
        &[(0b10010, &ENTRY_PLASTICIZE_12797038501706387171)],
        &[(0b10010, &ENTRY_PLASTICIZED_7781252037154490596)],
        &[(0b10010, &ENTRY_PLASTICIZER_8318606071228781590)],
        &[(0b10010, &ENTRY_PLASTICIZERS_6018942164442812723)],
        &[(0b10010, &ENTRY_PLASTICIZES_9170692950470288401)],
        &[(0b10010, &ENTRY_PLASTICIZING_9614229074072341821)],
        &[(0b01001, &ENTRY_PLASTICIZE_12797038501706387171)],
        &[(0b01001, &ENTRY_PLASTICIZED_7781252037154490596)],
        &[(0b01001, &ENTRY_PLASTICIZER_8318606071228781590)],
        &[(0b01001, &ENTRY_PLASTICIZERS_6018942164442812723)],
        &[(0b01001, &ENTRY_PLASTICIZES_9170692950470288401)],
        &[(0b01001, &ENTRY_PLASTICIZING_9614229074072341821)],
        &[(0b10010, &ENTRY_PLATINIZATION_1083038364602615335)],
        &[(0b10010, &ENTRY_PLATINIZATIONS_1156288939962168369)],
        &[(0b10010, &ENTRY_PLATINIZE_6742218053291606205)],
        &[(0b10010, &ENTRY_PLATINIZED_14868058494774606882)],
        &[(0b10010, &ENTRY_PLATINIZES_2691556545522250539)],
        &[(0b10010, &ENTRY_PLATINIZING_8264599125346829618)],
        &[(0b01001, &ENTRY_PLATINIZATION_1083038364602615335)],
        &[(0b01001, &ENTRY_PLATINIZATIONS_1156288939962168369)],
        &[(0b01001, &ENTRY_PLATINIZE_6742218053291606205)],
        &[(0b01001, &ENTRY_PLATINIZED_14868058494774606882)],
        &[(0b01001, &ENTRY_PLATINIZES_2691556545522250539)],
        &[(0b01001, &ENTRY_PLATINIZING_8264599125346829618)],
        &[(0b10010, &ENTRY_PLATITUDINIZE_5511778463063483337)],
        &[(0b10010, &ENTRY_PLATITUDINIZED_12324616080202347816)],
        &[(0b10010, &ENTRY_PLATITUDINIZES_13848363114958142428)],
        &[(0b10010, &ENTRY_PLATITUDINIZING_11960508778562463338)],
        &[(0b01001, &ENTRY_PLATITUDINIZE_5511778463063483337)],
        &[(0b01001, &ENTRY_PLATITUDINIZED_12324616080202347816)],
        &[(0b01001, &ENTRY_PLATITUDINIZES_13848363114958142428)],
        &[(0b01001, &ENTRY_PLATITUDINIZING_11960508778562463338)],
    ],
    range: 6..=12,
};

static VARS_PI_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_PI_CHILDREN),
    value: None,
};

pub static VARS_PI_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("aster"),
        dictgen::InsensitiveAscii("asters"),
        dictgen::InsensitiveAscii("astre"),
        dictgen::InsensitiveAscii("astres"),
    ],
    values: &[
        &[(0b00001, &ENTRY_PIASTER_11202645044054150783)],
        &[(0b00001, &ENTRY_PIASTERS_7280037555234194522)],
        &[(0b11010, &ENTRY_PIASTER_11202645044054150783)],
        &[(0b11010, &ENTRY_PIASTERS_7280037555234194522)],
    ],
    range: 5..=6,
};

static VARS_PH_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_PH_CHILDREN),
    value: None,
};

pub static VARS_PH_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ilosophise"),
        dictgen::InsensitiveAscii("ilosophised"),
        dictgen::InsensitiveAscii("ilosophiser"),
        dictgen::InsensitiveAscii("ilosophisers"),
        dictgen::InsensitiveAscii("ilosophises"),
        dictgen::InsensitiveAscii("ilosophising"),
        dictgen::InsensitiveAscii("ilosophize"),
        dictgen::InsensitiveAscii("ilosophized"),
        dictgen::InsensitiveAscii("ilosophizer"),
        dictgen::InsensitiveAscii("ilosophizers"),
        dictgen::InsensitiveAscii("ilosophizes"),
        dictgen::InsensitiveAscii("ilosophizing"),
        dictgen::InsensitiveAscii("ilter"),
        dictgen::InsensitiveAscii("ilters"),
        dictgen::InsensitiveAscii("iltre"),
        dictgen::InsensitiveAscii("iltres"),
        dictgen::InsensitiveAscii("lebotomise"),
        dictgen::InsensitiveAscii("lebotomised"),
        dictgen::InsensitiveAscii("lebotomises"),
        dictgen::InsensitiveAscii("lebotomising"),
        dictgen::InsensitiveAscii("lebotomize"),
        dictgen::InsensitiveAscii("lebotomized"),
        dictgen::InsensitiveAscii("lebotomizes"),
        dictgen::InsensitiveAscii("lebotomizing"),
        dictgen::InsensitiveAscii("oneyed"),
        dictgen::InsensitiveAscii("oneying"),
        dictgen::InsensitiveAscii("otosynthesise"),
        dictgen::InsensitiveAscii("otosynthesised"),
        dictgen::InsensitiveAscii("otosynthesises"),
        dictgen::InsensitiveAscii("otosynthesising"),
        dictgen::InsensitiveAscii("otosynthesize"),
        dictgen::InsensitiveAscii("otosynthesized"),
        dictgen::InsensitiveAscii("otosynthesizes"),
        dictgen::InsensitiveAscii("otosynthesizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_PHILOSOPHIZE_6289672951361880530)],
        &[(0b10010, &ENTRY_PHILOSOPHIZED_2316681608168076190)],
        &[(0b10010, &ENTRY_PHILOSOPHIZER_13078210838054950081)],
        &[(0b10010, &ENTRY_PHILOSOPHIZERS_9751548833379500220)],
        &[(0b10010, &ENTRY_PHILOSOPHIZES_4374489325746751173)],
        &[(0b10010, &ENTRY_PHILOSOPHIZING_7293438746871613968)],
        &[(0b01001, &ENTRY_PHILOSOPHIZE_6289672951361880530)],
        &[(0b01001, &ENTRY_PHILOSOPHIZED_2316681608168076190)],
        &[(0b01001, &ENTRY_PHILOSOPHIZER_13078210838054950081)],
        &[(0b01001, &ENTRY_PHILOSOPHIZERS_9751548833379500220)],
        &[(0b01001, &ENTRY_PHILOSOPHIZES_4374489325746751173)],
        &[(0b01001, &ENTRY_PHILOSOPHIZING_7293438746871613968)],
        &[(0b00001, &ENTRY_PHILTER_10084940057302890116)],
        &[(0b00001, &ENTRY_PHILTERS_15728406259693213137)],
        &[(0b11010, &ENTRY_PHILTER_10084940057302890116)],
        &[(0b11010, &ENTRY_PHILTERS_15728406259693213137)],
        &[(0b10010, &ENTRY_PHLEBOTOMIZE_5424959391532030755)],
        &[(0b10010, &ENTRY_PHLEBOTOMIZED_5100102168126674735)],
        &[(0b10010, &ENTRY_PHLEBOTOMIZES_4093384839909362396)],
        &[(0b10010, &ENTRY_PHLEBOTOMIZING_12242317892759935073)],
        &[(0b01001, &ENTRY_PHLEBOTOMIZE_5424959391532030755)],
        &[(0b01001, &ENTRY_PHLEBOTOMIZED_5100102168126674735)],
        &[(0b01001, &ENTRY_PHLEBOTOMIZES_4093384839909362396)],
        &[(0b01001, &ENTRY_PHLEBOTOMIZING_12242317892759935073)],
        &[(0b00001, &ENTRY_PHONIED_2250260042946147168)],
        &[(0b00001, &ENTRY_PHONYING_13054141319835686864)],
        &[(0b10010, &ENTRY_PHOTOSYNTHESIZE_9353202202077615821)],
        &[(0b10010, &ENTRY_PHOTOSYNTHESIZED_8205058313674230591)],
        &[(0b10010, &ENTRY_PHOTOSYNTHESIZES_2447766527906919866)],
        &[(0b10010, &ENTRY_PHOTOSYNTHESIZING_9195844832593591204)],
        &[(0b01001, &ENTRY_PHOTOSYNTHESIZE_9353202202077615821)],
        &[(0b01001, &ENTRY_PHOTOSYNTHESIZED_8205058313674230591)],
        &[(0b01001, &ENTRY_PHOTOSYNTHESIZES_2447766527906919866)],
        &[(0b01001, &ENTRY_PHOTOSYNTHESIZING_9195844832593591204)],
    ],
    range: 5..=15,
};

static VARS_PE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_PE_CHILDREN),
    value: None,
};

static VARS_PE_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    None,
    Some(&VARS_PED_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_PEN_NODE),
    None,
    None,
    None,
    Some(&VARS_PER_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_PER_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_PER_CHILDREN),
    value: None,
};

pub static VARS_PER_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("iled"),
        dictgen::InsensitiveAscii("iling"),
        dictgen::InsensitiveAscii("illed"),
        dictgen::InsensitiveAscii("illing"),
        dictgen::InsensitiveAscii("iodisation"),
        dictgen::InsensitiveAscii("iodisations"),
        dictgen::InsensitiveAscii("iodization"),
        dictgen::InsensitiveAscii("iodizations"),
        dictgen::InsensitiveAscii("sonalisation"),
        dictgen::InsensitiveAscii("sonalisations"),
        dictgen::InsensitiveAscii("sonalise"),
        dictgen::InsensitiveAscii("sonalised"),
        dictgen::InsensitiveAscii("sonalises"),
        dictgen::InsensitiveAscii("sonalising"),
        dictgen::InsensitiveAscii("sonalization"),
        dictgen::InsensitiveAscii("sonalizations"),
        dictgen::InsensitiveAscii("sonalize"),
        dictgen::InsensitiveAscii("sonalized"),
        dictgen::InsensitiveAscii("sonalizes"),
        dictgen::InsensitiveAscii("sonalizing"),
    ],
    values: &[
        &[(0b00001, &ENTRY_PERILED_15060178372319479950)],
        &[(0b00001, &ENTRY_PERILING_16221031141616213209)],
        &[(0b11010, &ENTRY_PERILED_15060178372319479950)],
        &[(0b11010, &ENTRY_PERILING_16221031141616213209)],
        &[(0b10010, &ENTRY_PERIODIZATION_10629388178555953074)],
        &[(0b10010, &ENTRY_PERIODIZATIONS_17618036349132017353)],
        &[(0b01001, &ENTRY_PERIODIZATION_10629388178555953074)],
        &[(0b01001, &ENTRY_PERIODIZATIONS_17618036349132017353)],
        &[(0b10010, &ENTRY_PERSONALIZATION_2807413073355132478)],
        &[(0b10010, &ENTRY_PERSONALIZATIONS_8445180728009943143)],
        &[(0b10010, &ENTRY_PERSONALIZE_16406670836185668125)],
        &[(0b10010, &ENTRY_PERSONALIZED_7678165486146161596)],
        &[(0b10010, &ENTRY_PERSONALIZES_498227984615996131)],
        &[(0b10010, &ENTRY_PERSONALIZING_5672131506914446806)],
        &[(0b01001, &ENTRY_PERSONALIZATION_2807413073355132478)],
        &[(0b01001, &ENTRY_PERSONALIZATIONS_8445180728009943143)],
        &[(0b01001, &ENTRY_PERSONALIZE_16406670836185668125)],
        &[(0b01001, &ENTRY_PERSONALIZED_7678165486146161596)],
        &[(0b01001, &ENTRY_PERSONALIZES_498227984615996131)],
        &[(0b01001, &ENTRY_PERSONALIZING_5672131506914446806)],
    ],
    range: 4..=13,
};

static VARS_PEN_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_PEN_CHILDREN),
    value: None,
};

pub static VARS_PEN_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("alisation"),
        dictgen::InsensitiveAscii("alisations"),
        dictgen::InsensitiveAscii("alise"),
        dictgen::InsensitiveAscii("alised"),
        dictgen::InsensitiveAscii("alises"),
        dictgen::InsensitiveAscii("alising"),
        dictgen::InsensitiveAscii("alization"),
        dictgen::InsensitiveAscii("alizations"),
        dictgen::InsensitiveAscii("alize"),
        dictgen::InsensitiveAscii("alized"),
        dictgen::InsensitiveAscii("alizes"),
        dictgen::InsensitiveAscii("alizing"),
        dictgen::InsensitiveAscii("ciled"),
        dictgen::InsensitiveAscii("ciling"),
        dictgen::InsensitiveAscii("cilings"),
        dictgen::InsensitiveAscii("cilled"),
        dictgen::InsensitiveAscii("cilling"),
        dictgen::InsensitiveAscii("cillings"),
    ],
    values: &[
        &[(0b10010, &ENTRY_PENALIZATION_11949589953931542079)],
        &[(0b10010, &ENTRY_PENALIZATIONS_6599684304676350857)],
        &[(0b10010, &ENTRY_PENALIZE_2530505701143168189)],
        &[(0b10010, &ENTRY_PENALIZED_11761122234321379751)],
        &[(0b10010, &ENTRY_PENALIZES_3731488236002265727)],
        &[(0b10010, &ENTRY_PENALIZING_15558361744095191436)],
        &[(0b01001, &ENTRY_PENALIZATION_11949589953931542079)],
        &[(0b01001, &ENTRY_PENALIZATIONS_6599684304676350857)],
        &[(0b01001, &ENTRY_PENALIZE_2530505701143168189)],
        &[(0b01001, &ENTRY_PENALIZED_11761122234321379751)],
        &[(0b01001, &ENTRY_PENALIZES_3731488236002265727)],
        &[(0b01001, &ENTRY_PENALIZING_15558361744095191436)],
        &[(0b00001, &ENTRY_PENCILED_12950313690598237437)],
        &[(0b00001, &ENTRY_PENCILING_16152937612714350821)],
        &[(0b00001, &ENTRY_PENCILINGS_15763703545745446520)],
        &[(0b11010, &ENTRY_PENCILED_12950313690598237437)],
        &[(0b11010, &ENTRY_PENCILING_16152937612714350821)],
        &[(0b11010, &ENTRY_PENCILINGS_15763703545745446520)],
    ],
    range: 5..=10,
};

static VARS_PED_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_PED_CHILDREN),
    value: None,
};

pub static VARS_PED_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("agog"),
        dictgen::InsensitiveAscii("agogs"),
        dictgen::InsensitiveAscii("aled"),
        dictgen::InsensitiveAscii("aler"),
        dictgen::InsensitiveAscii("alers"),
        dictgen::InsensitiveAscii("aling"),
        dictgen::InsensitiveAscii("alled"),
        dictgen::InsensitiveAscii("aller"),
        dictgen::InsensitiveAscii("allers"),
        dictgen::InsensitiveAscii("alling"),
        dictgen::InsensitiveAscii("dler"),
        dictgen::InsensitiveAscii("dlers"),
        dictgen::InsensitiveAscii("estrianisation"),
        dictgen::InsensitiveAscii("estrianisations"),
        dictgen::InsensitiveAscii("estrianise"),
        dictgen::InsensitiveAscii("estrianised"),
        dictgen::InsensitiveAscii("estrianises"),
        dictgen::InsensitiveAscii("estrianising"),
        dictgen::InsensitiveAscii("estrianization"),
        dictgen::InsensitiveAscii("estrianizations"),
        dictgen::InsensitiveAscii("estrianize"),
        dictgen::InsensitiveAscii("estrianized"),
        dictgen::InsensitiveAscii("estrianizes"),
        dictgen::InsensitiveAscii("estrianizing"),
        dictgen::InsensitiveAscii("iatric"),
        dictgen::InsensitiveAscii("iatrician"),
        dictgen::InsensitiveAscii("iatricians"),
        dictgen::InsensitiveAscii("iatrics"),
        dictgen::InsensitiveAscii("iatrist"),
        dictgen::InsensitiveAscii("iatrists"),
        dictgen::InsensitiveAscii("ophile"),
        dictgen::InsensitiveAscii("ophiles"),
        dictgen::InsensitiveAscii("ophilia"),
        dictgen::InsensitiveAscii("ophilias"),
    ],
    values: &[
        &[(0b00001, &ENTRY_PEDAGOGUE_17463305726294731487)],
        &[(0b00001, &ENTRY_PEDAGOGUES_7902989780410302300)],
        &[(0b01001, &ENTRY_PEDALED_11301735024430265900)],
        &[(0b01001, &ENTRY_PEDALER_6897157105660727886)],
        &[(0b01001, &ENTRY_PEDALERS_15975067802508211844)],
        &[(0b01001, &ENTRY_PEDALING_5358000154746792705)],
        &[(0b11010, &ENTRY_PEDALED_11301735024430265900)],
        &[(0b11010, &ENTRY_PEDALER_6897157105660727886)],
        &[(0b11010, &ENTRY_PEDALERS_15975067802508211844)],
        &[(0b11010, &ENTRY_PEDALING_5358000154746792705)],
        &[(0b01001, &ENTRY_PEDDLER_7340625236288148080)],
        &[(0b01001, &ENTRY_PEDDLERS_13297303646234860431)],
        &[(0b10010, &ENTRY_PEDESTRIANIZATION_10522132408255479732)],
        &[(0b10010, &ENTRY_PEDESTRIANIZATIONS_15701187568960243875)],
        &[(0b10010, &ENTRY_PEDESTRIANIZE_14520784452518295924)],
        &[(0b10010, &ENTRY_PEDESTRIANIZED_13675127004868727770)],
        &[(0b10010, &ENTRY_PEDESTRIANIZES_3493882547527020632)],
        &[(0b10010, &ENTRY_PEDESTRIANIZING_6617534362263439264)],
        &[(0b01001, &ENTRY_PEDESTRIANIZATION_10522132408255479732)],
        &[(0b01001, &ENTRY_PEDESTRIANIZATIONS_15701187568960243875)],
        &[(0b01001, &ENTRY_PEDESTRIANIZE_14520784452518295924)],
        &[(0b01001, &ENTRY_PEDESTRIANIZED_13675127004868727770)],
        &[(0b01001, &ENTRY_PEDESTRIANIZES_3493882547527020632)],
        &[(0b01001, &ENTRY_PEDESTRIANIZING_6617534362263439264)],
        &[(0b11001, &ENTRY_PEDIATRIC_14057388448801273518)],
        &[(0b11001, &ENTRY_PEDIATRICIAN_10944796143655723735)],
        &[(0b11001, &ENTRY_PEDIATRICIANS_11770782104393001942)],
        &[(0b11001, &ENTRY_PEDIATRICS_11689829247825832837)],
        &[(0b00001, &ENTRY_PEDIATRICIAN_10944796143655723735)],
        &[(0b00001, &ENTRY_PEDIATRICIANS_11770782104393001942)],
        &[(0b11001, &ENTRY_PEDOPHILE_17284081556096473917)],
        &[(0b11001, &ENTRY_PEDOPHILES_18122867727560912141)],
        &[(0b10001, &ENTRY_PEDOPHILIA_6687546858614581858)],
        &[(0b10001, &ENTRY_PEDOPHILIAS_7493061271312788807)],
    ],
    range: 4..=15,
};

static VARS_PA_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_PA_CHILDREN),
    value: None,
};

static VARS_PA_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    None,
    None,
    Some(&VARS_PAE_NODE),
    None,
    None,
    None,
    None,
    Some(&VARS_PAJ_NODE),
    None,
    Some(&VARS_PAL_NODE),
    None,
    Some(&VARS_PAN_NODE),
    None,
    None,
    None,
    Some(&VARS_PAR_NODE),
    Some(&VARS_PAS_NODE),
    Some(&VARS_PAT_NODE),
    Some(&VARS_PAU_NODE),
    None,
    None,
    None,
    None,
    None,
];

static VARS_PAU_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_PAU_CHILDREN),
    value: None,
};

pub static VARS_PAU_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("perisation"),
        dictgen::InsensitiveAscii("perisations"),
        dictgen::InsensitiveAscii("perise"),
        dictgen::InsensitiveAscii("perised"),
        dictgen::InsensitiveAscii("perises"),
        dictgen::InsensitiveAscii("perising"),
        dictgen::InsensitiveAscii("perization"),
        dictgen::InsensitiveAscii("perizations"),
        dictgen::InsensitiveAscii("perize"),
        dictgen::InsensitiveAscii("perized"),
        dictgen::InsensitiveAscii("perizes"),
        dictgen::InsensitiveAscii("perizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_PAUPERIZATION_2161984306553805604)],
        &[(0b10010, &ENTRY_PAUPERIZATIONS_10251769409806507728)],
        &[(0b10010, &ENTRY_PAUPERIZE_18158151809070795878)],
        &[(0b10010, &ENTRY_PAUPERIZED_6686296815894484392)],
        &[(0b10010, &ENTRY_PAUPERIZES_13654913193374307039)],
        &[(0b10010, &ENTRY_PAUPERIZING_9202769342367666141)],
        &[(0b01001, &ENTRY_PAUPERIZATION_2161984306553805604)],
        &[(0b01001, &ENTRY_PAUPERIZATIONS_10251769409806507728)],
        &[(0b01001, &ENTRY_PAUPERIZE_18158151809070795878)],
        &[(0b01001, &ENTRY_PAUPERIZED_6686296815894484392)],
        &[(0b01001, &ENTRY_PAUPERIZES_13654913193374307039)],
        &[(0b01001, &ENTRY_PAUPERIZING_9202769342367666141)],
    ],
    range: 6..=11,
};

static VARS_PAT_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_PAT_CHILDREN),
    value: None,
};

pub static VARS_PAT_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ronise"),
        dictgen::InsensitiveAscii("ronised"),
        dictgen::InsensitiveAscii("roniser"),
        dictgen::InsensitiveAscii("ronisers"),
        dictgen::InsensitiveAscii("ronises"),
        dictgen::InsensitiveAscii("ronising"),
        dictgen::InsensitiveAscii("ronisinglier"),
        dictgen::InsensitiveAscii("ronisingliest"),
        dictgen::InsensitiveAscii("ronisingly"),
        dictgen::InsensitiveAscii("ronisings"),
        dictgen::InsensitiveAscii("ronize"),
        dictgen::InsensitiveAscii("ronized"),
        dictgen::InsensitiveAscii("ronizer"),
        dictgen::InsensitiveAscii("ronizers"),
        dictgen::InsensitiveAscii("ronizes"),
        dictgen::InsensitiveAscii("ronizing"),
        dictgen::InsensitiveAscii("ronizinglier"),
        dictgen::InsensitiveAscii("ronizingliest"),
        dictgen::InsensitiveAscii("ronizingly"),
        dictgen::InsensitiveAscii("ronizings"),
    ],
    values: &[
        &[(0b10010, &ENTRY_PATRONIZE_2120552335415939536)],
        &[(0b10010, &ENTRY_PATRONIZED_11064398139600850345)],
        &[(0b10010, &ENTRY_PATRONIZER_10813433458376234707)],
        &[(0b10010, &ENTRY_PATRONIZERS_11272030543646937310)],
        &[(0b10010, &ENTRY_PATRONIZES_11395708073720458865)],
        &[(0b10010, &ENTRY_PATRONIZING_12434118065877059973)],
        &[(0b10010, &ENTRY_PATRONIZINGLIER_302802414773543310)],
        &[(0b10010, &ENTRY_PATRONIZINGLIEST_16305371931388137130)],
        &[(0b10010, &ENTRY_PATRONIZINGLY_6847062421337873239)],
        &[(0b10010, &ENTRY_PATRONIZINGS_13629575403778748423)],
        &[(0b01001, &ENTRY_PATRONIZE_2120552335415939536)],
        &[(0b01001, &ENTRY_PATRONIZED_11064398139600850345)],
        &[(0b01001, &ENTRY_PATRONIZER_10813433458376234707)],
        &[(0b01001, &ENTRY_PATRONIZERS_11272030543646937310)],
        &[(0b01001, &ENTRY_PATRONIZES_11395708073720458865)],
        &[(0b01001, &ENTRY_PATRONIZING_12434118065877059973)],
        &[(0b01001, &ENTRY_PATRONIZINGLIER_302802414773543310)],
        &[(0b01001, &ENTRY_PATRONIZINGLIEST_16305371931388137130)],
        &[(0b01001, &ENTRY_PATRONIZINGLY_6847062421337873239)],
        &[(0b01001, &ENTRY_PATRONIZINGS_13629575403778748423)],
    ],
    range: 6..=13,
};

static VARS_PAS_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_PAS_CHILDREN),
    value: None,
};

pub static VARS_PAS_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("sivisation"),
        dictgen::InsensitiveAscii("sivization"),
        dictgen::InsensitiveAscii("teurisation"),
        dictgen::InsensitiveAscii("teurisations"),
        dictgen::InsensitiveAscii("teurise"),
        dictgen::InsensitiveAscii("teurised"),
        dictgen::InsensitiveAscii("teuriser"),
        dictgen::InsensitiveAscii("teurisers"),
        dictgen::InsensitiveAscii("teurises"),
        dictgen::InsensitiveAscii("teurising"),
        dictgen::InsensitiveAscii("teurization"),
        dictgen::InsensitiveAscii("teurizations"),
        dictgen::InsensitiveAscii("teurize"),
        dictgen::InsensitiveAscii("teurized"),
        dictgen::InsensitiveAscii("teurizer"),
        dictgen::InsensitiveAscii("teurizers"),
        dictgen::InsensitiveAscii("teurizes"),
        dictgen::InsensitiveAscii("teurizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_PASSIVIZATION_14555794353650852047)],
        &[(0b01001, &ENTRY_PASSIVIZATION_14555794353650852047)],
        &[(0b10010, &ENTRY_PASTEURIZATION_15699653175330456323)],
        &[(0b10010, &ENTRY_PASTEURIZATIONS_2915811841905287610)],
        &[(0b10010, &ENTRY_PASTEURIZE_163174462491369649)],
        &[(0b10010, &ENTRY_PASTEURIZED_13548937625186713170)],
        &[(0b10010, &ENTRY_PASTEURIZER_2458848217830417439)],
        &[(0b10010, &ENTRY_PASTEURIZERS_15085534957712496351)],
        &[(0b10010, &ENTRY_PASTEURIZES_5846494049033549631)],
        &[(0b10010, &ENTRY_PASTEURIZING_15425456478399382152)],
        &[(0b01001, &ENTRY_PASTEURIZATION_15699653175330456323)],
        &[(0b01001, &ENTRY_PASTEURIZATIONS_2915811841905287610)],
        &[(0b01001, &ENTRY_PASTEURIZE_163174462491369649)],
        &[(0b01001, &ENTRY_PASTEURIZED_13548937625186713170)],
        &[(0b01001, &ENTRY_PASTEURIZER_2458848217830417439)],
        &[(0b01001, &ENTRY_PASTEURIZERS_15085534957712496351)],
        &[(0b01001, &ENTRY_PASTEURIZES_5846494049033549631)],
        &[(0b01001, &ENTRY_PASTEURIZING_15425456478399382152)],
    ],
    range: 7..=12,
};

static VARS_PAR_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_PAR_CHILDREN),
    value: None,
};

pub static VARS_PAR_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("alyse"),
        dictgen::InsensitiveAscii("alysed"),
        dictgen::InsensitiveAscii("alysing"),
        dictgen::InsensitiveAscii("alyze"),
        dictgen::InsensitiveAscii("alyzed"),
        dictgen::InsensitiveAscii("alyzes"),
        dictgen::InsensitiveAscii("alyzing"),
        dictgen::InsensitiveAscii("ameterisation"),
        dictgen::InsensitiveAscii("ameterisations"),
        dictgen::InsensitiveAscii("ameterization"),
        dictgen::InsensitiveAscii("ameterizations"),
        dictgen::InsensitiveAscii("asitisation"),
        dictgen::InsensitiveAscii("asitise"),
        dictgen::InsensitiveAscii("asitised"),
        dictgen::InsensitiveAscii("asitises"),
        dictgen::InsensitiveAscii("asitising"),
        dictgen::InsensitiveAscii("asitization"),
        dictgen::InsensitiveAscii("asitize"),
        dictgen::InsensitiveAscii("asitized"),
        dictgen::InsensitiveAscii("asitizes"),
        dictgen::InsensitiveAscii("asitizing"),
        dictgen::InsensitiveAscii("celed"),
        dictgen::InsensitiveAscii("celing"),
        dictgen::InsensitiveAscii("celled"),
        dictgen::InsensitiveAscii("celling"),
        dictgen::InsensitiveAscii("enthesise"),
        dictgen::InsensitiveAscii("enthesised"),
        dictgen::InsensitiveAscii("enthesises"),
        dictgen::InsensitiveAscii("enthesising"),
        dictgen::InsensitiveAscii("enthesize"),
        dictgen::InsensitiveAscii("enthesized"),
        dictgen::InsensitiveAscii("enthesizes"),
        dictgen::InsensitiveAscii("enthesizing"),
        dictgen::InsensitiveAscii("lor"),
        dictgen::InsensitiveAscii("lormaid"),
        dictgen::InsensitiveAscii("lors"),
        dictgen::InsensitiveAscii("lour"),
        dictgen::InsensitiveAscii("lourmaid"),
        dictgen::InsensitiveAscii("lours"),
        dictgen::InsensitiveAscii("ticularisation"),
        dictgen::InsensitiveAscii("ticularisations"),
        dictgen::InsensitiveAscii("ticularise"),
        dictgen::InsensitiveAscii("ticularised"),
        dictgen::InsensitiveAscii("ticularises"),
        dictgen::InsensitiveAscii("ticularising"),
        dictgen::InsensitiveAscii("ticularization"),
        dictgen::InsensitiveAscii("ticularizations"),
        dictgen::InsensitiveAscii("ticularize"),
        dictgen::InsensitiveAscii("ticularized"),
        dictgen::InsensitiveAscii("ticularizes"),
        dictgen::InsensitiveAscii("ticularizing"),
    ],
    values: &[
        &[(0b11010, &ENTRY_PARALYZE_5616245633076129426)],
        &[(0b11010, &ENTRY_PARALYZED_16839880512939084025)],
        &[(0b11010, &ENTRY_PARALYZING_3887960173123159019)],
        &[(0b01001, &ENTRY_PARALYZE_5616245633076129426)],
        &[(0b01001, &ENTRY_PARALYZED_16839880512939084025)],
        &[(0b01001, &ENTRY_PARALYZES_2906384954321317007)],
        &[(0b01001, &ENTRY_PARALYZING_3887960173123159019)],
        &[(0b10010, &ENTRY_PARAMETERIZATION_11837209911752300457)],
        &[(0b10010, &ENTRY_PARAMETERIZATIONS_7162471395165876296)],
        &[(0b01001, &ENTRY_PARAMETERIZATION_11837209911752300457)],
        &[(0b01001, &ENTRY_PARAMETERIZATIONS_7162471395165876296)],
        &[(0b10010, &ENTRY_PARASITIZATION_10764422602155636226)],
        &[(0b10010, &ENTRY_PARASITIZE_10442537268642059851)],
        &[(0b10010, &ENTRY_PARASITIZED_17454588215531391347)],
        &[(0b10010, &ENTRY_PARASITIZES_15093324507866591370)],
        &[(0b10010, &ENTRY_PARASITIZING_13253219762304399299)],
        &[(0b01001, &ENTRY_PARASITIZATION_10764422602155636226)],
        &[(0b01001, &ENTRY_PARASITIZE_10442537268642059851)],
        &[(0b01001, &ENTRY_PARASITIZED_17454588215531391347)],
        &[(0b01001, &ENTRY_PARASITIZES_15093324507866591370)],
        &[(0b01001, &ENTRY_PARASITIZING_13253219762304399299)],
        &[(0b00001, &ENTRY_PARCELED_6170016542434984869)],
        &[(0b00001, &ENTRY_PARCELING_851710970245334651)],
        &[(0b11010, &ENTRY_PARCELED_6170016542434984869)],
        &[(0b11010, &ENTRY_PARCELING_851710970245334651)],
        &[(0b10010, &ENTRY_PARENTHESIZE_16232933755981914094)],
        &[(0b10010, &ENTRY_PARENTHESIZED_3648906989752316418)],
        &[(0b10010, &ENTRY_PARENTHESIZES_9065065510113606774)],
        &[(0b10010, &ENTRY_PARENTHESIZING_632457343746225122)],
        &[(0b01001, &ENTRY_PARENTHESIZE_16232933755981914094)],
        &[(0b01001, &ENTRY_PARENTHESIZED_3648906989752316418)],
        &[(0b01001, &ENTRY_PARENTHESIZES_9065065510113606774)],
        &[(0b01001, &ENTRY_PARENTHESIZING_632457343746225122)],
        &[(0b11001, &ENTRY_PARLOR_5988253503224208460)],
        &[(0b10001, &ENTRY_PARLORMAID_4150851883941162027)],
        &[(0b11001, &ENTRY_PARLORS_13263653608415272696)],
        &[(0b11010, &ENTRY_PARLOR_5988253503224208460)],
        &[(0b11010, &ENTRY_PARLORMAID_4150851883941162027)],
        &[(0b11010, &ENTRY_PARLORS_13263653608415272696)],
        &[(0b10010, &ENTRY_PARTICULARIZATION_15085297445135933435)],
        &[(0b10010, &ENTRY_PARTICULARIZATIONS_7496757883724885887)],
        &[(0b10010, &ENTRY_PARTICULARIZE_15520939813264385830)],
        &[(0b10010, &ENTRY_PARTICULARIZED_11569157644638431290)],
        &[(0b10010, &ENTRY_PARTICULARIZES_8370763796403583228)],
        &[(0b10010, &ENTRY_PARTICULARIZING_5658452593803942085)],
        &[(0b01001, &ENTRY_PARTICULARIZATION_15085297445135933435)],
        &[(0b01001, &ENTRY_PARTICULARIZATIONS_7496757883724885887)],
        &[(0b01001, &ENTRY_PARTICULARIZE_15520939813264385830)],
        &[(0b01001, &ENTRY_PARTICULARIZED_11569157644638431290)],
        &[(0b01001, &ENTRY_PARTICULARIZES_8370763796403583228)],
        &[(0b01001, &ENTRY_PARTICULARIZING_5658452593803942085)],
    ],
    range: 3..=15,
};

static VARS_PAN_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_PAN_CHILDREN),
    value: None,
};

pub static VARS_PAN_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("egyrise"),
        dictgen::InsensitiveAscii("egyrised"),
        dictgen::InsensitiveAscii("egyrises"),
        dictgen::InsensitiveAscii("egyrising"),
        dictgen::InsensitiveAscii("egyrize"),
        dictgen::InsensitiveAscii("egyrized"),
        dictgen::InsensitiveAscii("egyrizes"),
        dictgen::InsensitiveAscii("egyrizing"),
        dictgen::InsensitiveAscii("eled"),
        dictgen::InsensitiveAscii("eling"),
        dictgen::InsensitiveAscii("elings"),
        dictgen::InsensitiveAscii("elist"),
        dictgen::InsensitiveAscii("elists"),
        dictgen::InsensitiveAscii("elled"),
        dictgen::InsensitiveAscii("elling"),
        dictgen::InsensitiveAscii("ellings"),
        dictgen::InsensitiveAscii("ellist"),
        dictgen::InsensitiveAscii("ellists"),
    ],
    values: &[
        &[(0b10010, &ENTRY_PANEGYRIZE_464787387720568012)],
        &[(0b10010, &ENTRY_PANEGYRIZED_1510999540705297287)],
        &[(0b10010, &ENTRY_PANEGYRIZES_614276823774184510)],
        &[(0b10010, &ENTRY_PANEGYRIZING_7503940443087587961)],
        &[(0b01001, &ENTRY_PANEGYRIZE_464787387720568012)],
        &[(0b01001, &ENTRY_PANEGYRIZED_1510999540705297287)],
        &[(0b01001, &ENTRY_PANEGYRIZES_614276823774184510)],
        &[(0b01001, &ENTRY_PANEGYRIZING_7503940443087587961)],
        &[(0b00001, &ENTRY_PANELED_12586780164955993512)],
        &[(0b00001, &ENTRY_PANELING_8089572046105071609)],
        &[(0b00001, &ENTRY_PANELINGS_11260550015389622953)],
        &[(0b00001, &ENTRY_PANELIST_3043263775088249330)],
        &[(0b00001, &ENTRY_PANELISTS_16863143863031647099)],
        &[(0b11010, &ENTRY_PANELED_12586780164955993512)],
        &[(0b11010, &ENTRY_PANELING_8089572046105071609)],
        &[(0b11010, &ENTRY_PANELINGS_11260550015389622953)],
        &[(0b11010, &ENTRY_PANELIST_3043263775088249330)],
        &[(0b11010, &ENTRY_PANELISTS_16863143863031647099)],
    ],
    range: 4..=9,
};

static VARS_PAL_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_PAL_CHILDREN),
    value: None,
};

pub static VARS_PAL_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("aeoclimatologies"),
        dictgen::InsensitiveAscii("aeoclimatology"),
        dictgen::InsensitiveAscii("aeoecologies"),
        dictgen::InsensitiveAscii("aeoecology"),
        dictgen::InsensitiveAscii("aeogeographies"),
        dictgen::InsensitiveAscii("aeogeography"),
        dictgen::InsensitiveAscii("aeolithic"),
        dictgen::InsensitiveAscii("aeontological"),
        dictgen::InsensitiveAscii("aeontologist"),
        dictgen::InsensitiveAscii("aeontologists"),
        dictgen::InsensitiveAscii("aeontology"),
        dictgen::InsensitiveAscii("atalisation"),
        dictgen::InsensitiveAscii("atalisations"),
        dictgen::InsensitiveAscii("atalise"),
        dictgen::InsensitiveAscii("atalised"),
        dictgen::InsensitiveAscii("atalises"),
        dictgen::InsensitiveAscii("atalising"),
        dictgen::InsensitiveAscii("atalization"),
        dictgen::InsensitiveAscii("atalizations"),
        dictgen::InsensitiveAscii("atalize"),
        dictgen::InsensitiveAscii("atalized"),
        dictgen::InsensitiveAscii("atalizes"),
        dictgen::InsensitiveAscii("atalizing"),
        dictgen::InsensitiveAscii("eoclimatologies"),
        dictgen::InsensitiveAscii("eoclimatology"),
        dictgen::InsensitiveAscii("eoecologies"),
        dictgen::InsensitiveAscii("eoecology"),
        dictgen::InsensitiveAscii("eogeographies"),
        dictgen::InsensitiveAscii("eogeography"),
        dictgen::InsensitiveAscii("eolithic"),
        dictgen::InsensitiveAscii("eontological"),
        dictgen::InsensitiveAscii("eontologist"),
        dictgen::InsensitiveAscii("eontologists"),
        dictgen::InsensitiveAscii("eontology"),
    ],
    values: &[
        &[(0b10010, &ENTRY_PALEOCLIMATOLOGIES_11917584077388492841)],
        &[(0b10010, &ENTRY_PALEOCLIMATOLOGY_1888923764675563721)],
        &[(0b10010, &ENTRY_PALEOECOLOGIES_18110959250046855627)],
        &[(0b10010, &ENTRY_PALEOECOLOGY_4482816158539091906)],
        &[(0b10010, &ENTRY_PALEOGEOGRAPHIES_12038367756274519862)],
        &[(0b10010, &ENTRY_PALEOGEOGRAPHY_14735924833615110050)],
        &[(0b10010, &ENTRY_PALEOLITHIC_10579173722626414001)],
        &[(0b10010, &ENTRY_PALEONTOLOGICAL_11378757918485663576)],
        &[(0b10010, &ENTRY_PALEONTOLOGIST_14409308310083449867)],
        &[(0b10010, &ENTRY_PALEONTOLOGISTS_1615341850049645435)],
        &[(0b10010, &ENTRY_PALEONTOLOGY_8727472879076855658)],
        &[(0b10010, &ENTRY_PALATALIZATION_5484250888619777534)],
        &[(0b10010, &ENTRY_PALATALIZATIONS_4807700789809767940)],
        &[(0b10010, &ENTRY_PALATALIZE_11951391819712678616)],
        &[(0b10010, &ENTRY_PALATALIZED_9802151654299491783)],
        &[(0b10010, &ENTRY_PALATALIZES_9060739880362868418)],
        &[(0b10010, &ENTRY_PALATALIZING_8149766451780072792)],
        &[(0b01001, &ENTRY_PALATALIZATION_5484250888619777534)],
        &[(0b01001, &ENTRY_PALATALIZATIONS_4807700789809767940)],
        &[(0b01001, &ENTRY_PALATALIZE_11951391819712678616)],
        &[(0b01001, &ENTRY_PALATALIZED_9802151654299491783)],
        &[(0b01001, &ENTRY_PALATALIZES_9060739880362868418)],
        &[(0b01001, &ENTRY_PALATALIZING_8149766451780072792)],
        &[(0b11001, &ENTRY_PALEOCLIMATOLOGIES_11917584077388492841)],
        &[(0b11001, &ENTRY_PALEOCLIMATOLOGY_1888923764675563721)],
        &[(0b11001, &ENTRY_PALEOECOLOGIES_18110959250046855627)],
        &[(0b11001, &ENTRY_PALEOECOLOGY_4482816158539091906)],
        &[(0b11001, &ENTRY_PALEOGEOGRAPHIES_12038367756274519862)],
        &[(0b11001, &ENTRY_PALEOGEOGRAPHY_14735924833615110050)],
        &[(0b11001, &ENTRY_PALEOLITHIC_10579173722626414001)],
        &[(0b11001, &ENTRY_PALEONTOLOGICAL_11378757918485663576)],
        &[(0b11001, &ENTRY_PALEONTOLOGIST_14409308310083449867)],
        &[(0b11001, &ENTRY_PALEONTOLOGISTS_1615341850049645435)],
        &[(0b11001, &ENTRY_PALEONTOLOGY_8727472879076855658)],
    ],
    range: 7..=16,
};

static VARS_PAJ_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_PAJ_CHILDREN),
    value: None,
};

pub static VARS_PAJ_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ama"),
        dictgen::InsensitiveAscii("amas"),
    ],
    values: &[
        &[(0b01001, &ENTRY_PAJAMA_3939742153808099869)],
        &[(0b01001, &ENTRY_PAJAMAS_18438866384752213563)],
    ],
    range: 3..=4,
};

static VARS_PAE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_PAE_CHILDREN),
    value: None,
};

pub static VARS_PAE_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("derast"),
        dictgen::InsensitiveAscii("derasts"),
        dictgen::InsensitiveAscii("diatric"),
        dictgen::InsensitiveAscii("diatrician"),
        dictgen::InsensitiveAscii("diatricians"),
        dictgen::InsensitiveAscii("diatrics"),
        dictgen::InsensitiveAscii("dophile"),
        dictgen::InsensitiveAscii("dophiles"),
        dictgen::InsensitiveAscii("dophilia"),
        dictgen::InsensitiveAscii("dophilias"),
    ],
    values: &[
        &[(0b11010, &ENTRY_PEDERAST_6508738365729508616)],
        &[(0b11010, &ENTRY_PEDERASTS_5835872448427039713)],
        &[(0b10010, &ENTRY_PEDIATRIC_14057388448801273518)],
        &[(0b10010, &ENTRY_PEDIATRICIAN_10944796143655723735)],
        &[(0b10010, &ENTRY_PEDIATRICIANS_11770782104393001942)],
        &[(0b10010, &ENTRY_PEDIATRICS_11689829247825832837)],
        &[(0b10010, &ENTRY_PEDOPHILE_17284081556096473917)],
        &[(0b10010, &ENTRY_PEDOPHILES_18122867727560912141)],
        &[(0b11010, &ENTRY_PEDOPHILIA_6687546858614581858)],
        &[(0b11010, &ENTRY_PEDOPHILIAS_7493061271312788807)],
    ],
    range: 6..=11,
};

static VARS_O_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_O_CHILDREN),
    value: None,
};

static VARS_O_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    Some(&VARS_OB_NODE),
    Some(&VARS_OC_NODE),
    Some(&VARS_OD_NODE),
    Some(&VARS_OE_NODE),
    Some(&VARS_OF_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_OM_NODE),
    None,
    None,
    Some(&VARS_OP_NODE),
    None,
    Some(&VARS_OR_NODE),
    Some(&VARS_OS_NODE),
    None,
    Some(&VARS_OU_NODE),
    Some(&VARS_OV_NODE),
    None,
    Some(&VARS_OX_NODE),
    None,
    None,
];

static VARS_OX_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_OX_CHILDREN),
    value: None,
};

pub static VARS_OX_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("idisable"),
        dictgen::InsensitiveAscii("idisables"),
        dictgen::InsensitiveAscii("idisation"),
        dictgen::InsensitiveAscii("idisations"),
        dictgen::InsensitiveAscii("idise"),
        dictgen::InsensitiveAscii("idised"),
        dictgen::InsensitiveAscii("idiser"),
        dictgen::InsensitiveAscii("idisers"),
        dictgen::InsensitiveAscii("idises"),
        dictgen::InsensitiveAscii("idising"),
        dictgen::InsensitiveAscii("idisings"),
        dictgen::InsensitiveAscii("idizable"),
        dictgen::InsensitiveAscii("idizables"),
        dictgen::InsensitiveAscii("idization"),
        dictgen::InsensitiveAscii("idizations"),
        dictgen::InsensitiveAscii("idize"),
        dictgen::InsensitiveAscii("idized"),
        dictgen::InsensitiveAscii("idizer"),
        dictgen::InsensitiveAscii("idizers"),
        dictgen::InsensitiveAscii("idizes"),
        dictgen::InsensitiveAscii("idizing"),
        dictgen::InsensitiveAscii("idizings"),
    ],
    values: &[
        &[(0b10010, &ENTRY_OXIDIZABLE_5289655147636602365)],
        &[(0b10010, &ENTRY_OXIDIZABLES_10964178463482153600)],
        &[(0b10010, &ENTRY_OXIDIZATION_13166504173020505769)],
        &[(0b10010, &ENTRY_OXIDIZATIONS_10794857157062767651)],
        &[(0b10010, &ENTRY_OXIDIZE_16273392528175590013)],
        &[(0b10010, &ENTRY_OXIDIZED_11075904073295172473)],
        &[(0b10010, &ENTRY_OXIDIZER_10115554319871451478)],
        &[(0b10010, &ENTRY_OXIDIZERS_15313203568879188818)],
        &[(0b10010, &ENTRY_OXIDIZES_9639252663902404191)],
        &[(0b10010, &ENTRY_OXIDIZING_16338645204512386709)],
        &[(0b10010, &ENTRY_OXIDIZINGS_10090589532009393809)],
        &[(0b01001, &ENTRY_OXIDIZABLE_5289655147636602365)],
        &[(0b01001, &ENTRY_OXIDIZABLES_10964178463482153600)],
        &[(0b01001, &ENTRY_OXIDIZATION_13166504173020505769)],
        &[(0b01001, &ENTRY_OXIDIZATIONS_10794857157062767651)],
        &[(0b01001, &ENTRY_OXIDIZE_16273392528175590013)],
        &[(0b01001, &ENTRY_OXIDIZED_11075904073295172473)],
        &[(0b01001, &ENTRY_OXIDIZER_10115554319871451478)],
        &[(0b01001, &ENTRY_OXIDIZERS_15313203568879188818)],
        &[(0b01001, &ENTRY_OXIDIZES_9639252663902404191)],
        &[(0b01001, &ENTRY_OXIDIZING_16338645204512386709)],
        &[(0b01001, &ENTRY_OXIDIZINGS_10090589532009393809)],
    ],
    range: 5..=10,
};

static VARS_OV_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_OV_CHILDREN),
    value: None,
};

pub static VARS_OV_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ercapitalise"),
        dictgen::InsensitiveAscii("ercapitalised"),
        dictgen::InsensitiveAscii("ercapitalises"),
        dictgen::InsensitiveAscii("ercapitalising"),
        dictgen::InsensitiveAscii("ercapitalize"),
        dictgen::InsensitiveAscii("ercapitalized"),
        dictgen::InsensitiveAscii("ercapitalizes"),
        dictgen::InsensitiveAscii("ercapitalizing"),
        dictgen::InsensitiveAscii("erdramatise"),
        dictgen::InsensitiveAscii("erdramatised"),
        dictgen::InsensitiveAscii("erdramatises"),
        dictgen::InsensitiveAscii("erdramatising"),
        dictgen::InsensitiveAscii("erdramatize"),
        dictgen::InsensitiveAscii("erdramatized"),
        dictgen::InsensitiveAscii("erdramatizes"),
        dictgen::InsensitiveAscii("erdramatizing"),
        dictgen::InsensitiveAscii("eremphasise"),
        dictgen::InsensitiveAscii("eremphasised"),
        dictgen::InsensitiveAscii("eremphasises"),
        dictgen::InsensitiveAscii("eremphasising"),
        dictgen::InsensitiveAscii("eremphasize"),
        dictgen::InsensitiveAscii("eremphasized"),
        dictgen::InsensitiveAscii("eremphasizes"),
        dictgen::InsensitiveAscii("eremphasizing"),
        dictgen::InsensitiveAscii("ergeneralise"),
        dictgen::InsensitiveAscii("ergeneralised"),
        dictgen::InsensitiveAscii("ergeneralises"),
        dictgen::InsensitiveAscii("ergeneralising"),
        dictgen::InsensitiveAscii("ergeneralize"),
        dictgen::InsensitiveAscii("ergeneralized"),
        dictgen::InsensitiveAscii("ergeneralizes"),
        dictgen::InsensitiveAscii("ergeneralizing"),
        dictgen::InsensitiveAscii("erspecialisation"),
        dictgen::InsensitiveAscii("erspecialisations"),
        dictgen::InsensitiveAscii("erspecialise"),
        dictgen::InsensitiveAscii("erspecialised"),
        dictgen::InsensitiveAscii("erspecialises"),
        dictgen::InsensitiveAscii("erspecialising"),
        dictgen::InsensitiveAscii("erspecialization"),
        dictgen::InsensitiveAscii("erspecializations"),
        dictgen::InsensitiveAscii("erspecialize"),
        dictgen::InsensitiveAscii("erspecialized"),
        dictgen::InsensitiveAscii("erspecializes"),
        dictgen::InsensitiveAscii("erspecializing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_OVERCAPITALIZE_5137404458805033721)],
        &[(0b10010, &ENTRY_OVERCAPITALIZED_16391070453870509941)],
        &[(0b10010, &ENTRY_OVERCAPITALIZES_6277345493449192746)],
        &[(0b10010, &ENTRY_OVERCAPITALIZING_1761143477577642450)],
        &[(0b01001, &ENTRY_OVERCAPITALIZE_5137404458805033721)],
        &[(0b01001, &ENTRY_OVERCAPITALIZED_16391070453870509941)],
        &[(0b01001, &ENTRY_OVERCAPITALIZES_6277345493449192746)],
        &[(0b01001, &ENTRY_OVERCAPITALIZING_1761143477577642450)],
        &[(0b10010, &ENTRY_OVERDRAMATIZE_9956046184240652478)],
        &[(0b10010, &ENTRY_OVERDRAMATIZED_568182443613701103)],
        &[(0b10010, &ENTRY_OVERDRAMATIZES_677559530199440792)],
        &[(0b10010, &ENTRY_OVERDRAMATIZING_8041727993818066162)],
        &[(0b01001, &ENTRY_OVERDRAMATIZE_9956046184240652478)],
        &[(0b01001, &ENTRY_OVERDRAMATIZED_568182443613701103)],
        &[(0b01001, &ENTRY_OVERDRAMATIZES_677559530199440792)],
        &[(0b01001, &ENTRY_OVERDRAMATIZING_8041727993818066162)],
        &[(0b10010, &ENTRY_OVEREMPHASIZE_10188078811171146690)],
        &[(0b10010, &ENTRY_OVEREMPHASIZED_14422660185907423404)],
        &[(0b10010, &ENTRY_OVEREMPHASIZES_9211947340714823778)],
        &[(0b10010, &ENTRY_OVEREMPHASIZING_656930053748535278)],
        &[(0b01001, &ENTRY_OVEREMPHASIZE_10188078811171146690)],
        &[(0b01001, &ENTRY_OVEREMPHASIZED_14422660185907423404)],
        &[(0b01001, &ENTRY_OVEREMPHASIZES_9211947340714823778)],
        &[(0b01001, &ENTRY_OVEREMPHASIZING_656930053748535278)],
        &[(0b10010, &ENTRY_OVERGENERALIZE_7625722739665195923)],
        &[(0b10010, &ENTRY_OVERGENERALIZED_2362525225382909269)],
        &[(0b10010, &ENTRY_OVERGENERALIZES_1194543416222013859)],
        &[(0b10010, &ENTRY_OVERGENERALIZING_3046182641254114632)],
        &[(0b01001, &ENTRY_OVERGENERALIZE_7625722739665195923)],
        &[(0b01001, &ENTRY_OVERGENERALIZED_2362525225382909269)],
        &[(0b01001, &ENTRY_OVERGENERALIZES_1194543416222013859)],
        &[(0b01001, &ENTRY_OVERGENERALIZING_3046182641254114632)],
        &[(0b10010, &ENTRY_OVERSPECIALIZATION_1633031571639798019)],
        &[(0b10010, &ENTRY_OVERSPECIALIZATIONS_18126012734047267284)],
        &[(0b10010, &ENTRY_OVERSPECIALIZE_7229749289149801509)],
        &[(0b10010, &ENTRY_OVERSPECIALIZED_1547172552972623375)],
        &[(0b10010, &ENTRY_OVERSPECIALIZES_10793320734082567309)],
        &[(0b10010, &ENTRY_OVERSPECIALIZING_3587227959598734164)],
        &[(0b01001, &ENTRY_OVERSPECIALIZATION_1633031571639798019)],
        &[(0b01001, &ENTRY_OVERSPECIALIZATIONS_18126012734047267284)],
        &[(0b01001, &ENTRY_OVERSPECIALIZE_7229749289149801509)],
        &[(0b01001, &ENTRY_OVERSPECIALIZED_1547172552972623375)],
        &[(0b01001, &ENTRY_OVERSPECIALIZES_10793320734082567309)],
        &[(0b01001, &ENTRY_OVERSPECIALIZING_3587227959598734164)],
    ],
    range: 11..=17,
};

static VARS_OU_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_OU_CHILDREN),
    value: None,
};

pub static VARS_OU_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("rang"),
        dictgen::InsensitiveAscii("rangs"),
        dictgen::InsensitiveAscii("tmaneuver"),
        dictgen::InsensitiveAscii("tmaneuvered"),
        dictgen::InsensitiveAscii("tmaneuvering"),
        dictgen::InsensitiveAscii("tmaneuvers"),
        dictgen::InsensitiveAscii("tmanoeuvre"),
        dictgen::InsensitiveAscii("tmanoeuvred"),
        dictgen::InsensitiveAscii("tmanoeuvres"),
        dictgen::InsensitiveAscii("tmanoeuvring"),
    ],
    values: &[
        &[(0b11010, &ENTRY_ORANG_3026443150827231855)],
        &[(0b11010, &ENTRY_ORANGS_11893539110910417877)],
        &[(0b01001, &ENTRY_OUTMANEUVER_8971376472472700486)],
        &[(0b01001, &ENTRY_OUTMANEUVERED_15207995604008599908)],
        &[(0b01001, &ENTRY_OUTMANEUVERING_18066101649103069658)],
        &[(0b01001, &ENTRY_OUTMANEUVERS_12354989641176250449)],
        &[(0b11010, &ENTRY_OUTMANEUVER_8971376472472700486)],
        &[(0b11010, &ENTRY_OUTMANEUVERED_15207995604008599908)],
        &[(0b11010, &ENTRY_OUTMANEUVERS_12354989641176250449)],
        &[(0b11010, &ENTRY_OUTMANEUVERING_18066101649103069658)],
    ],
    range: 4..=12,
};

static VARS_OS_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_OS_CHILDREN),
    value: None,
};

pub static VARS_OS_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("tracise"),
        dictgen::InsensitiveAscii("tracised"),
        dictgen::InsensitiveAscii("tracises"),
        dictgen::InsensitiveAscii("tracising"),
        dictgen::InsensitiveAscii("tracize"),
        dictgen::InsensitiveAscii("tracized"),
        dictgen::InsensitiveAscii("tracizes"),
        dictgen::InsensitiveAscii("tracizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_OSTRACIZE_16556482869488657514)],
        &[(0b10010, &ENTRY_OSTRACIZED_17082390290234422430)],
        &[(0b10010, &ENTRY_OSTRACIZES_12242933710212962262)],
        &[(0b10010, &ENTRY_OSTRACIZING_13078448502630833661)],
        &[(0b01001, &ENTRY_OSTRACIZE_16556482869488657514)],
        &[(0b01001, &ENTRY_OSTRACIZED_17082390290234422430)],
        &[(0b01001, &ENTRY_OSTRACIZES_12242933710212962262)],
        &[(0b01001, &ENTRY_OSTRACIZING_13078448502630833661)],
    ],
    range: 7..=9,
};

static VARS_OR_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_OR_CHILDREN),
    value: None,
};

pub static VARS_OR_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("gandie"),
        dictgen::InsensitiveAscii("gandy"),
        dictgen::InsensitiveAscii("ganisation"),
        dictgen::InsensitiveAscii("ganisational"),
        dictgen::InsensitiveAscii("ganisationaler"),
        dictgen::InsensitiveAscii("ganisationalest"),
        dictgen::InsensitiveAscii("ganisationallier"),
        dictgen::InsensitiveAscii("ganisationalliest"),
        dictgen::InsensitiveAscii("ganisationally"),
        dictgen::InsensitiveAscii("ganisationals"),
        dictgen::InsensitiveAscii("ganisations"),
        dictgen::InsensitiveAscii("ganise"),
        dictgen::InsensitiveAscii("ganised"),
        dictgen::InsensitiveAscii("ganiser"),
        dictgen::InsensitiveAscii("ganisers"),
        dictgen::InsensitiveAscii("ganises"),
        dictgen::InsensitiveAscii("ganising"),
        dictgen::InsensitiveAscii("ganization"),
        dictgen::InsensitiveAscii("ganizational"),
        dictgen::InsensitiveAscii("ganizationaler"),
        dictgen::InsensitiveAscii("ganizationalest"),
        dictgen::InsensitiveAscii("ganizationallier"),
        dictgen::InsensitiveAscii("ganizationalliest"),
        dictgen::InsensitiveAscii("ganizationally"),
        dictgen::InsensitiveAscii("ganizationals"),
        dictgen::InsensitiveAscii("ganizations"),
        dictgen::InsensitiveAscii("ganize"),
        dictgen::InsensitiveAscii("ganized"),
        dictgen::InsensitiveAscii("ganizer"),
        dictgen::InsensitiveAscii("ganizers"),
        dictgen::InsensitiveAscii("ganizes"),
        dictgen::InsensitiveAscii("ganizing"),
        dictgen::InsensitiveAscii("ientalise"),
        dictgen::InsensitiveAscii("ientalised"),
        dictgen::InsensitiveAscii("ientalises"),
        dictgen::InsensitiveAscii("ientalising"),
        dictgen::InsensitiveAscii("ientalize"),
        dictgen::InsensitiveAscii("ientalized"),
        dictgen::InsensitiveAscii("ientalizes"),
        dictgen::InsensitiveAscii("ientalizing"),
        dictgen::InsensitiveAscii("thopaedic"),
        dictgen::InsensitiveAscii("thopaedicer"),
        dictgen::InsensitiveAscii("thopaedicest"),
        dictgen::InsensitiveAscii("thopaedics"),
        dictgen::InsensitiveAscii("thopaedist"),
        dictgen::InsensitiveAscii("thopaedists"),
        dictgen::InsensitiveAscii("thopedic"),
        dictgen::InsensitiveAscii("thopedicer"),
        dictgen::InsensitiveAscii("thopedicest"),
        dictgen::InsensitiveAscii("thopedics"),
        dictgen::InsensitiveAscii("thopedist"),
        dictgen::InsensitiveAscii("thopedists"),
    ],
    values: &[
        &[(0b10011, &ENTRY_ORGANDY_16885011380899378447)],
        &[(0b01001, &ENTRY_ORGANDY_16885011380899378447)],
        &[(0b10010, &ENTRY_ORGANIZATION_17289795818827632314)],
        &[(0b10010, &ENTRY_ORGANIZATIONAL_2693930595138979162)],
        &[(0b10010, &ENTRY_ORGANIZATIONALER_3873019173853092798)],
        &[(0b10010, &ENTRY_ORGANIZATIONALEST_1078872185464956795)],
        &[(0b10010, &ENTRY_ORGANIZATIONALLIER_4232299366340167031)],
        &[(0b10010, &ENTRY_ORGANIZATIONALLIEST_5781070786689457967)],
        &[(0b10010, &ENTRY_ORGANIZATIONALLY_14545398087106745696)],
        &[(0b10010, &ENTRY_ORGANIZATIONALS_14375928891357084131)],
        &[(0b10010, &ENTRY_ORGANIZATIONS_4577579545569833942)],
        &[(0b10010, &ENTRY_ORGANIZE_5877473548332466223)],
        &[(0b10010, &ENTRY_ORGANIZED_14662641348959642965)],
        &[(0b10010, &ENTRY_ORGANIZER_11892981286551035399)],
        &[(0b10010, &ENTRY_ORGANIZERS_3593448493398179170)],
        &[(0b10010, &ENTRY_ORGANIZES_10823078939317146880)],
        &[(0b10010, &ENTRY_ORGANIZING_8682329261432472945)],
        &[(0b01001, &ENTRY_ORGANIZATION_17289795818827632314)],
        &[(0b01001, &ENTRY_ORGANIZATIONAL_2693930595138979162)],
        &[(0b01001, &ENTRY_ORGANIZATIONALER_3873019173853092798)],
        &[(0b01001, &ENTRY_ORGANIZATIONALEST_1078872185464956795)],
        &[(0b01001, &ENTRY_ORGANIZATIONALLIER_4232299366340167031)],
        &[(0b01001, &ENTRY_ORGANIZATIONALLIEST_5781070786689457967)],
        &[(0b01001, &ENTRY_ORGANIZATIONALLY_14545398087106745696)],
        &[(0b01001, &ENTRY_ORGANIZATIONALS_14375928891357084131)],
        &[(0b01001, &ENTRY_ORGANIZATIONS_4577579545569833942)],
        &[(0b01001, &ENTRY_ORGANIZE_5877473548332466223)],
        &[(0b01001, &ENTRY_ORGANIZED_14662641348959642965)],
        &[(0b01001, &ENTRY_ORGANIZER_11892981286551035399)],
        &[(0b01001, &ENTRY_ORGANIZERS_3593448493398179170)],
        &[(0b01001, &ENTRY_ORGANIZES_10823078939317146880)],
        &[(0b01001, &ENTRY_ORGANIZING_8682329261432472945)],
        &[(0b10010, &ENTRY_ORIENTALIZE_3925980212984131506)],
        &[(0b10010, &ENTRY_ORIENTALIZED_17195678597420672824)],
        &[(0b10010, &ENTRY_ORIENTALIZES_15493764345171362933)],
        &[(0b10010, &ENTRY_ORIENTALIZING_16469770502347036371)],
        &[(0b01001, &ENTRY_ORIENTALIZE_3925980212984131506)],
        &[(0b01001, &ENTRY_ORIENTALIZED_17195678597420672824)],
        &[(0b01001, &ENTRY_ORIENTALIZES_15493764345171362933)],
        &[(0b01001, &ENTRY_ORIENTALIZING_16469770502347036371)],
        &[(0b11010, &ENTRY_ORTHOPEDIC_11181628856417796299)],
        &[(0b11010, &ENTRY_ORTHOPEDICER_3585810925484129429)],
        &[(0b11010, &ENTRY_ORTHOPEDICEST_12750955173838086616)],
        &[(0b11010, &ENTRY_ORTHOPEDICS_12977459761715868784)],
        &[(0b11010, &ENTRY_ORTHOPEDIST_6644326132964977786)],
        &[(0b11010, &ENTRY_ORTHOPEDISTS_13748363777846849291)],
        &[(0b11001, &ENTRY_ORTHOPEDIC_11181628856417796299)],
        &[(0b11001, &ENTRY_ORTHOPEDICER_3585810925484129429)],
        &[(0b11001, &ENTRY_ORTHOPEDICEST_12750955173838086616)],
        &[(0b11001, &ENTRY_ORTHOPEDICS_12977459761715868784)],
        &[(0b10001, &ENTRY_ORTHOPEDIST_6644326132964977786)],
        &[(0b10001, &ENTRY_ORTHOPEDISTS_13748363777846849291)],
    ],
    range: 5..=17,
};

static VARS_OP_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_OP_CHILDREN),
    value: None,
};

pub static VARS_OP_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("timisation"),
        dictgen::InsensitiveAscii("timisations"),
        dictgen::InsensitiveAscii("timise"),
        dictgen::InsensitiveAscii("timised"),
        dictgen::InsensitiveAscii("timiser"),
        dictgen::InsensitiveAscii("timisers"),
        dictgen::InsensitiveAscii("timises"),
        dictgen::InsensitiveAscii("timising"),
        dictgen::InsensitiveAscii("timization"),
        dictgen::InsensitiveAscii("timizations"),
        dictgen::InsensitiveAscii("timize"),
        dictgen::InsensitiveAscii("timized"),
        dictgen::InsensitiveAscii("timizer"),
        dictgen::InsensitiveAscii("timizers"),
        dictgen::InsensitiveAscii("timizes"),
        dictgen::InsensitiveAscii("timizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_OPTIMIZATION_7999660279345208813)],
        &[(0b10010, &ENTRY_OPTIMIZATIONS_5853505921922952795)],
        &[(0b10010, &ENTRY_OPTIMIZE_2249839710181808282)],
        &[(0b10010, &ENTRY_OPTIMIZED_1595116357475103476)],
        &[(0b10010, &ENTRY_OPTIMIZER_17271297266309970872)],
        &[(0b10010, &ENTRY_OPTIMIZERS_9262293159377441067)],
        &[(0b10010, &ENTRY_OPTIMIZES_4735979948079339705)],
        &[(0b10010, &ENTRY_OPTIMIZING_13977015133672850235)],
        &[(0b01001, &ENTRY_OPTIMIZATION_7999660279345208813)],
        &[(0b01001, &ENTRY_OPTIMIZATIONS_5853505921922952795)],
        &[(0b01001, &ENTRY_OPTIMIZE_2249839710181808282)],
        &[(0b01001, &ENTRY_OPTIMIZED_1595116357475103476)],
        &[(0b01001, &ENTRY_OPTIMIZER_17271297266309970872)],
        &[(0b01001, &ENTRY_OPTIMIZERS_9262293159377441067)],
        &[(0b01001, &ENTRY_OPTIMIZES_4735979948079339705)],
        &[(0b01001, &ENTRY_OPTIMIZING_13977015133672850235)],
    ],
    range: 6..=11,
};

static VARS_OM_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_OM_CHILDREN),
    value: None,
};

pub static VARS_OM_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("elet"),
        dictgen::InsensitiveAscii("elets"),
    ],
    values: &[
        &[(0b01001, &ENTRY_OMELET_764513264155611675)],
        &[(0b01001, &ENTRY_OMELETS_3609558159591624407)],
    ],
    range: 4..=5,
};

static VARS_OF_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_OF_CHILDREN),
    value: None,
};

pub static VARS_OF_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("fence"),
        dictgen::InsensitiveAscii("fences"),
        dictgen::InsensitiveAscii("fense"),
        dictgen::InsensitiveAscii("fenses"),
    ],
    values: &[
        &[(0b11010, &ENTRY_OFFENSE_3255912368052973030)],
        &[(0b11010, &ENTRY_OFFENSES_14914149738486494625)],
        &[(0b01001, &ENTRY_OFFENSE_3255912368052973030)],
        &[(0b01001, &ENTRY_OFFENSES_14914149738486494625)],
    ],
    range: 5..=6,
};

static VARS_OE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_OE_CHILDREN),
    value: None,
};

pub static VARS_OE_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("cumenism"),
        dictgen::InsensitiveAscii("dema"),
        dictgen::InsensitiveAscii("demas"),
        dictgen::InsensitiveAscii("dematous"),
        dictgen::InsensitiveAscii("nological"),
        dictgen::InsensitiveAscii("nologist"),
        dictgen::InsensitiveAscii("nologists"),
        dictgen::InsensitiveAscii("sophagi"),
        dictgen::InsensitiveAscii("sophagus"),
        dictgen::InsensitiveAscii("sophaguses"),
        dictgen::InsensitiveAscii("strogen"),
        dictgen::InsensitiveAscii("strogenic"),
        dictgen::InsensitiveAscii("strogens"),
        dictgen::InsensitiveAscii("strous"),
        dictgen::InsensitiveAscii("strus"),
        dictgen::InsensitiveAscii("struses"),
    ],
    values: &[
        &[(0b11010, &ENTRY_ECUMENISM_1878909652524904058)],
        &[(0b10010, &ENTRY_EDEMA_6077775640730618555)],
        &[(0b10010, &ENTRY_EDEMAS_2647107175205211125)],
        &[(0b10010, &ENTRY_EDEMATOUS_6296161129737314269)],
        &[(0b11010, &ENTRY_ENOLOGICAL_11189078660498192658)],
        &[(0b11010, &ENTRY_ENOLOGIST_382673391921246993)],
        &[(0b11010, &ENTRY_ENOLOGISTS_1989647851737964355)],
        &[(0b10010, &ENTRY_ESOPHAGI_11954876978132806506)],
        &[(0b11010, &ENTRY_ESOPHAGUS_17094499599237101062)],
        &[(0b00010, &ENTRY_ESOPHAGI_11954876978132806506)],
        &[(0b10010, &ENTRY_ESTROGEN_10173348120996063533)],
        &[(0b10010, &ENTRY_ESTROGENIC_3724956938647222280)],
        &[(0b10010, &ENTRY_ESTROGENS_11487970579706669068)],
        &[(0b10010, &ENTRY_ESTROUS_7878210273842809015)],
        &[(0b10010, &ENTRY_ESTRUS_391811675946213924)],
        &[(0b10010, &ENTRY_ESTRUSES_7947106804154830951)],
    ],
    range: 4..=10,
};

static VARS_OD_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_OD_CHILDREN),
    value: None,
};

pub static VARS_OD_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("or"),
        dictgen::InsensitiveAscii("orless"),
        dictgen::InsensitiveAscii("orlesser"),
        dictgen::InsensitiveAscii("orlessest"),
        dictgen::InsensitiveAscii("ors"),
        dictgen::InsensitiveAscii("our"),
        dictgen::InsensitiveAscii("ourless"),
        dictgen::InsensitiveAscii("ourlesser"),
        dictgen::InsensitiveAscii("ourlessest"),
        dictgen::InsensitiveAscii("ours"),
    ],
    values: &[
        &[(0b11001, &ENTRY_ODOR_2702216183818705106)],
        &[(0b11001, &ENTRY_ODORLESS_16700169054217746196)],
        &[(0b11001, &ENTRY_ODORLESSER_9186460254240088489)],
        &[(0b11001, &ENTRY_ODORLESSEST_9571347228428809475)],
        &[(0b11001, &ENTRY_ODORS_1722093147325611045)],
        &[(0b11010, &ENTRY_ODOR_2702216183818705106)],
        &[(0b11010, &ENTRY_ODORLESS_16700169054217746196)],
        &[(0b11010, &ENTRY_ODORLESSER_9186460254240088489)],
        &[(0b11010, &ENTRY_ODORLESSEST_9571347228428809475)],
        &[(0b11010, &ENTRY_ODORS_1722093147325611045)],
    ],
    range: 2..=10,
};

static VARS_OC_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_OC_CHILDREN),
    value: None,
};

pub static VARS_OC_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("her"),
        dictgen::InsensitiveAscii("hered"),
        dictgen::InsensitiveAscii("hering"),
        dictgen::InsensitiveAscii("herous"),
        dictgen::InsensitiveAscii("herouser"),
        dictgen::InsensitiveAscii("herousest"),
        dictgen::InsensitiveAscii("herrer"),
        dictgen::InsensitiveAscii("herrest"),
        dictgen::InsensitiveAscii("hers"),
        dictgen::InsensitiveAscii("hre"),
        dictgen::InsensitiveAscii("hred"),
        dictgen::InsensitiveAscii("hrer"),
        dictgen::InsensitiveAscii("hres"),
        dictgen::InsensitiveAscii("hrest"),
        dictgen::InsensitiveAscii("hring"),
    ],
    values: &[
        &[(0b00001, &ENTRY_OCHER_17256686823220191412)],
        &[(0b00001, &ENTRY_OCHERED_16675172852225671937)],
        &[(0b00001, &ENTRY_OCHERING_14121606727366800680)],
        &[(0b00001, &ENTRY_OCHEROUS_7457653784346760110)],
        &[(0b00001, &ENTRY_OCHEROUSER_9548217901029813754)],
        &[(0b00001, &ENTRY_OCHEROUSEST_9550248650160884919)],
        &[(0b00001, &ENTRY_OCHERRER_16308994947056150512)],
        &[(0b00001, &ENTRY_OCHERREST_7388621669374657137)],
        &[(0b00001, &ENTRY_OCHERS_4760067737965399289)],
        &[(0b11010, &ENTRY_OCHER_17256686823220191412)],
        &[(0b11010, &ENTRY_OCHERED_16675172852225671937)],
        &[(0b11010, &ENTRY_OCHERRER_16308994947056150512)],
        &[(0b11010, &ENTRY_OCHERS_4760067737965399289)],
        &[(0b11010, &ENTRY_OCHERREST_7388621669374657137)],
        &[(0b11010, &ENTRY_OCHERING_14121606727366800680)],
    ],
    range: 3..=9,
};

static VARS_OB_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_OB_CHILDREN),
    value: None,
};

pub static VARS_OB_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("jectivise"),
        dictgen::InsensitiveAscii("jectivised"),
        dictgen::InsensitiveAscii("jectivises"),
        dictgen::InsensitiveAscii("jectivising"),
        dictgen::InsensitiveAscii("jectivize"),
        dictgen::InsensitiveAscii("jectivized"),
        dictgen::InsensitiveAscii("jectivizes"),
        dictgen::InsensitiveAscii("jectivizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_OBJECTIVIZE_17947776649437604843)],
        &[(0b10010, &ENTRY_OBJECTIVIZED_15413360897315336968)],
        &[(0b10010, &ENTRY_OBJECTIVIZES_9105568866369059029)],
        &[(0b10010, &ENTRY_OBJECTIVIZING_12654258354920210911)],
        &[(0b01001, &ENTRY_OBJECTIVIZE_17947776649437604843)],
        &[(0b01001, &ENTRY_OBJECTIVIZED_15413360897315336968)],
        &[(0b01001, &ENTRY_OBJECTIVIZES_9105568866369059029)],
        &[(0b01001, &ENTRY_OBJECTIVIZING_12654258354920210911)],
    ],
    range: 9..=11,
};

static VARS_N_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_N_CHILDREN),
    value: None,
};

static VARS_N_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_NA_NODE),
    None,
    None,
    None,
    Some(&VARS_NE_NODE),
    None,
    None,
    None,
    Some(&VARS_NI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_NO_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_NO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_NO_CHILDREN),
    value: None,
};

pub static VARS_NO_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("rmalisation"),
        dictgen::InsensitiveAscii("rmalisations"),
        dictgen::InsensitiveAscii("rmalise"),
        dictgen::InsensitiveAscii("rmalised"),
        dictgen::InsensitiveAscii("rmaliser"),
        dictgen::InsensitiveAscii("rmalisers"),
        dictgen::InsensitiveAscii("rmalises"),
        dictgen::InsensitiveAscii("rmalising"),
        dictgen::InsensitiveAscii("rmalization"),
        dictgen::InsensitiveAscii("rmalizations"),
        dictgen::InsensitiveAscii("rmalize"),
        dictgen::InsensitiveAscii("rmalized"),
        dictgen::InsensitiveAscii("rmalizer"),
        dictgen::InsensitiveAscii("rmalizers"),
        dictgen::InsensitiveAscii("rmalizes"),
        dictgen::InsensitiveAscii("rmalizing"),
        dictgen::InsensitiveAscii("sey"),
        dictgen::InsensitiveAscii("seys"),
        dictgen::InsensitiveAscii("tarise"),
        dictgen::InsensitiveAscii("tarised"),
        dictgen::InsensitiveAscii("tarises"),
        dictgen::InsensitiveAscii("tarising"),
        dictgen::InsensitiveAscii("tarize"),
        dictgen::InsensitiveAscii("tarized"),
        dictgen::InsensitiveAscii("tarizes"),
        dictgen::InsensitiveAscii("tarizing"),
        dictgen::InsensitiveAscii("velisation"),
        dictgen::InsensitiveAscii("velisations"),
        dictgen::InsensitiveAscii("velise"),
        dictgen::InsensitiveAscii("velised"),
        dictgen::InsensitiveAscii("velises"),
        dictgen::InsensitiveAscii("velising"),
        dictgen::InsensitiveAscii("velization"),
        dictgen::InsensitiveAscii("velizations"),
        dictgen::InsensitiveAscii("velize"),
        dictgen::InsensitiveAscii("velized"),
        dictgen::InsensitiveAscii("velizes"),
        dictgen::InsensitiveAscii("velizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_NORMALIZATION_1763771903231509736)],
        &[(0b10010, &ENTRY_NORMALIZATIONS_6086334685841165071)],
        &[(0b10010, &ENTRY_NORMALIZE_17937494001703948277)],
        &[(0b10010, &ENTRY_NORMALIZED_13905640716588216801)],
        &[(0b10010, &ENTRY_NORMALIZER_6185815349658447968)],
        &[(0b10010, &ENTRY_NORMALIZERS_9242854506371928930)],
        &[(0b10010, &ENTRY_NORMALIZES_11815977506135648870)],
        &[(0b10010, &ENTRY_NORMALIZING_8454204097903734518)],
        &[(0b01001, &ENTRY_NORMALIZATION_1763771903231509736)],
        &[(0b01001, &ENTRY_NORMALIZATIONS_6086334685841165071)],
        &[(0b01001, &ENTRY_NORMALIZE_17937494001703948277)],
        &[(0b01001, &ENTRY_NORMALIZED_13905640716588216801)],
        &[(0b01001, &ENTRY_NORMALIZER_6185815349658447968)],
        &[(0b01001, &ENTRY_NORMALIZERS_9242854506371928930)],
        &[(0b01001, &ENTRY_NORMALIZES_11815977506135648870)],
        &[(0b01001, &ENTRY_NORMALIZING_8454204097903734518)],
        &[(0b11010, &ENTRY_NOSY_1009929718367174024)],
        &[(0b11010, &ENTRY_NOSIES_15482746754024260075)],
        &[(0b11010, &ENTRY_NOTARIZE_14995362902294634015)],
        &[(0b11010, &ENTRY_NOTARIZED_5329696136884282809)],
        &[(0b11010, &ENTRY_NOTARIZES_9436796973316272397)],
        &[(0b11010, &ENTRY_NOTARIZING_5636125110527307987)],
        &[(0b01001, &ENTRY_NOTARIZE_14995362902294634015)],
        &[(0b01001, &ENTRY_NOTARIZED_5329696136884282809)],
        &[(0b01001, &ENTRY_NOTARIZES_9436796973316272397)],
        &[(0b01001, &ENTRY_NOTARIZING_5636125110527307987)],
        &[(0b10010, &ENTRY_NOVELIZATION_21718915207717005)],
        &[(0b10010, &ENTRY_NOVELIZATIONS_3735074127764106015)],
        &[(0b10010, &ENTRY_NOVELIZE_9678275742447267508)],
        &[(0b10010, &ENTRY_NOVELIZED_15738528375210454895)],
        &[(0b10010, &ENTRY_NOVELIZES_4390292103638708970)],
        &[(0b10010, &ENTRY_NOVELIZING_8236112411426222682)],
        &[(0b01001, &ENTRY_NOVELIZATION_21718915207717005)],
        &[(0b01001, &ENTRY_NOVELIZATIONS_3735074127764106015)],
        &[(0b01001, &ENTRY_NOVELIZE_9678275742447267508)],
        &[(0b01001, &ENTRY_NOVELIZED_15738528375210454895)],
        &[(0b01001, &ENTRY_NOVELIZES_4390292103638708970)],
        &[(0b01001, &ENTRY_NOVELIZING_8236112411426222682)],
    ],
    range: 3..=12,
};

static VARS_NI_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_NI_CHILDREN),
    value: None,
};

pub static VARS_NI_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("te"),
        dictgen::InsensitiveAscii("ter"),
        dictgen::InsensitiveAscii("ters"),
        dictgen::InsensitiveAscii("tes"),
        dictgen::InsensitiveAscii("tre"),
        dictgen::InsensitiveAscii("tres"),
        dictgen::InsensitiveAscii("troglycerin"),
        dictgen::InsensitiveAscii("troglycerins"),
    ],
    values: &[
        &[(0b00001, &ENTRY_NIGHT_12445825267878435538)],
        &[(0b00001, &ENTRY_NITER_11730030586484906596)],
        &[(0b00001, &ENTRY_NITERS_15109525363766142335)],
        &[(0b00001, &ENTRY_NIGHTS_2853012648953157620)],
        &[(0b11010, &ENTRY_NITER_11730030586484906596)],
        &[(0b11010, &ENTRY_NITERS_15109525363766142335)],
        &[(0b01001, &ENTRY_NITROGLYCERIN_14614401800457155758)],
        &[(0b01001, &ENTRY_NITROGLYCERINS_868987947481490504)],
    ],
    range: 2..=12,
};

static VARS_NE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_NE_CHILDREN),
    value: None,
};

static VARS_NE_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    Some(&VARS_NEB_NODE),
    None,
    None,
    None,
    None,
    Some(&VARS_NEG_NODE),
    None,
    Some(&VARS_NEI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_NEO_NODE),
    None,
    None,
    None,
    None,
    Some(&VARS_NET_NODE),
    Some(&VARS_NEU_NODE),
    None,
    None,
    None,
    None,
    None,
];

static VARS_NEU_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_NEU_CHILDREN),
    value: None,
};

pub static VARS_NEU_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("tralisation"),
        dictgen::InsensitiveAscii("tralisations"),
        dictgen::InsensitiveAscii("tralise"),
        dictgen::InsensitiveAscii("tralised"),
        dictgen::InsensitiveAscii("traliser"),
        dictgen::InsensitiveAscii("tralisers"),
        dictgen::InsensitiveAscii("tralises"),
        dictgen::InsensitiveAscii("tralising"),
        dictgen::InsensitiveAscii("tralization"),
        dictgen::InsensitiveAscii("tralizations"),
        dictgen::InsensitiveAscii("tralize"),
        dictgen::InsensitiveAscii("tralized"),
        dictgen::InsensitiveAscii("tralizer"),
        dictgen::InsensitiveAscii("tralizers"),
        dictgen::InsensitiveAscii("tralizes"),
        dictgen::InsensitiveAscii("tralizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_NEUTRALIZATION_3752767150712391454)],
        &[(0b10010, &ENTRY_NEUTRALIZATIONS_7938385529409734858)],
        &[(0b10010, &ENTRY_NEUTRALIZE_8250094940796239103)],
        &[(0b10010, &ENTRY_NEUTRALIZED_23570169514124780)],
        &[(0b10010, &ENTRY_NEUTRALIZER_13734573167959567076)],
        &[(0b10010, &ENTRY_NEUTRALIZERS_1000093030679533320)],
        &[(0b10010, &ENTRY_NEUTRALIZES_3865166621052534884)],
        &[(0b10010, &ENTRY_NEUTRALIZING_14844449700074149114)],
        &[(0b01001, &ENTRY_NEUTRALIZATION_3752767150712391454)],
        &[(0b01001, &ENTRY_NEUTRALIZATIONS_7938385529409734858)],
        &[(0b01001, &ENTRY_NEUTRALIZE_8250094940796239103)],
        &[(0b01001, &ENTRY_NEUTRALIZED_23570169514124780)],
        &[(0b01001, &ENTRY_NEUTRALIZER_13734573167959567076)],
        &[(0b01001, &ENTRY_NEUTRALIZERS_1000093030679533320)],
        &[(0b01001, &ENTRY_NEUTRALIZES_3865166621052534884)],
        &[(0b01001, &ENTRY_NEUTRALIZING_14844449700074149114)],
    ],
    range: 7..=12,
};

static VARS_NET_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_NET_CHILDREN),
    value: None,
};

pub static VARS_NET_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("t"),
        dictgen::InsensitiveAscii("ts"),
    ],
    values: &[
        &[(0b10010, &ENTRY_NET_1634985998898472374)],
        &[(0b10010, &ENTRY_NETS_165907139467352353)],
    ],
    range: 1..=2,
};

static VARS_NEO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_NEO_CHILDREN),
    value: None,
};

pub static VARS_NEO_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("logise"),
        dictgen::InsensitiveAscii("logised"),
        dictgen::InsensitiveAscii("logises"),
        dictgen::InsensitiveAscii("logising"),
        dictgen::InsensitiveAscii("logize"),
        dictgen::InsensitiveAscii("logized"),
        dictgen::InsensitiveAscii("logizes"),
        dictgen::InsensitiveAscii("logizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_NEOLOGIZE_5094848877824842155)],
        &[(0b10010, &ENTRY_NEOLOGIZED_9476639829063323419)],
        &[(0b10010, &ENTRY_NEOLOGIZES_2611172356463477981)],
        &[(0b10010, &ENTRY_NEOLOGIZING_6439029299467534255)],
        &[(0b01001, &ENTRY_NEOLOGIZE_5094848877824842155)],
        &[(0b01001, &ENTRY_NEOLOGIZED_9476639829063323419)],
        &[(0b01001, &ENTRY_NEOLOGIZES_2611172356463477981)],
        &[(0b01001, &ENTRY_NEOLOGIZING_6439029299467534255)],
    ],
    range: 6..=8,
};

static VARS_NEI_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_NEI_CHILDREN),
    value: None,
};

pub static VARS_NEI_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ghbor"),
        dictgen::InsensitiveAscii("ghbored"),
        dictgen::InsensitiveAscii("ghborhood"),
        dictgen::InsensitiveAscii("ghborhoods"),
        dictgen::InsensitiveAscii("ghboring"),
        dictgen::InsensitiveAscii("ghborings"),
        dictgen::InsensitiveAscii("ghborlier"),
        dictgen::InsensitiveAscii("ghborliest"),
        dictgen::InsensitiveAscii("ghborliness"),
        dictgen::InsensitiveAscii("ghborlinesses"),
        dictgen::InsensitiveAscii("ghborly"),
        dictgen::InsensitiveAscii("ghbors"),
        dictgen::InsensitiveAscii("ghbour"),
        dictgen::InsensitiveAscii("ghboured"),
        dictgen::InsensitiveAscii("ghbourhood"),
        dictgen::InsensitiveAscii("ghbourhoods"),
        dictgen::InsensitiveAscii("ghbouring"),
        dictgen::InsensitiveAscii("ghbourings"),
        dictgen::InsensitiveAscii("ghbourlier"),
        dictgen::InsensitiveAscii("ghbourliest"),
        dictgen::InsensitiveAscii("ghbourliness"),
        dictgen::InsensitiveAscii("ghbourlinesses"),
        dictgen::InsensitiveAscii("ghbourly"),
        dictgen::InsensitiveAscii("ghbours"),
    ],
    values: &[
        &[(0b11001, &ENTRY_NEIGHBOR_9223532537551591313)],
        &[(0b11001, &ENTRY_NEIGHBORED_1453065315242132972)],
        &[(0b11001, &ENTRY_NEIGHBORHOOD_13179978688818671082)],
        &[(0b11001, &ENTRY_NEIGHBORHOODS_13147261698969498299)],
        &[(0b11001, &ENTRY_NEIGHBORING_11318750292661541645)],
        &[(0b11001, &ENTRY_NEIGHBORINGS_12373492488609025236)],
        &[(0b11001, &ENTRY_NEIGHBORLIER_5964029050832264412)],
        &[(0b11001, &ENTRY_NEIGHBORLIEST_6163034189378516769)],
        &[(0b10001, &ENTRY_NEIGHBORLINESS_10203381514206777935)],
        &[(0b10001, &ENTRY_NEIGHBORLINESSES_15429938495896734143)],
        &[(0b11001, &ENTRY_NEIGHBORLY_1379658281742193125)],
        &[(0b11001, &ENTRY_NEIGHBORS_11834946978992293791)],
        &[(0b11010, &ENTRY_NEIGHBOR_9223532537551591313)],
        &[(0b11010, &ENTRY_NEIGHBORED_1453065315242132972)],
        &[(0b11010, &ENTRY_NEIGHBORHOOD_13179978688818671082)],
        &[(0b11010, &ENTRY_NEIGHBORHOODS_13147261698969498299)],
        &[(0b11010, &ENTRY_NEIGHBORING_11318750292661541645)],
        &[(0b11010, &ENTRY_NEIGHBORINGS_12373492488609025236)],
        &[(0b11010, &ENTRY_NEIGHBORLIER_5964029050832264412)],
        &[(0b11010, &ENTRY_NEIGHBORLIEST_6163034189378516769)],
        &[(0b11010, &ENTRY_NEIGHBORLINESS_10203381514206777935)],
        &[(0b11010, &ENTRY_NEIGHBORLINESSES_15429938495896734143)],
        &[(0b11010, &ENTRY_NEIGHBORLY_1379658281742193125)],
        &[(0b11010, &ENTRY_NEIGHBORS_11834946978992293791)],
    ],
    range: 5..=14,
};

static VARS_NEG_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_NEG_CHILDREN),
    value: None,
};

pub static VARS_NEG_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("lig"),
        dictgen::InsensitiveAscii("ligs"),
    ],
    values: &[
        &[(0b00001, &ENTRY_NEGLIGEE_12210121686392984472)],
        &[(0b00001, &ENTRY_NEGLIGEES_4454821460830858983)],
    ],
    range: 3..=4,
};

static VARS_NEB_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_NEB_CHILDREN),
    value: None,
};

pub static VARS_NEB_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ulise"),
        dictgen::InsensitiveAscii("ulised"),
        dictgen::InsensitiveAscii("uliser"),
        dictgen::InsensitiveAscii("ulisers"),
        dictgen::InsensitiveAscii("ulises"),
        dictgen::InsensitiveAscii("ulising"),
        dictgen::InsensitiveAscii("ulize"),
        dictgen::InsensitiveAscii("ulized"),
        dictgen::InsensitiveAscii("ulizer"),
        dictgen::InsensitiveAscii("ulizers"),
        dictgen::InsensitiveAscii("ulizes"),
        dictgen::InsensitiveAscii("ulizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_NEBULIZE_897376798026210104)],
        &[(0b10010, &ENTRY_NEBULIZED_8317403402858231652)],
        &[(0b10010, &ENTRY_NEBULIZER_9105631547111211944)],
        &[(0b10010, &ENTRY_NEBULIZERS_575364184566751247)],
        &[(0b10010, &ENTRY_NEBULIZES_1042694150983522129)],
        &[(0b10010, &ENTRY_NEBULIZING_9748130735255218557)],
        &[(0b01001, &ENTRY_NEBULIZE_897376798026210104)],
        &[(0b01001, &ENTRY_NEBULIZED_8317403402858231652)],
        &[(0b01001, &ENTRY_NEBULIZER_9105631547111211944)],
        &[(0b01001, &ENTRY_NEBULIZERS_575364184566751247)],
        &[(0b01001, &ENTRY_NEBULIZES_1042694150983522129)],
        &[(0b01001, &ENTRY_NEBULIZING_9748130735255218557)],
    ],
    range: 5..=7,
};

static VARS_NA_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_NA_CHILDREN),
    value: None,
};

pub static VARS_NA_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("nometer"),
        dictgen::InsensitiveAscii("nometers"),
        dictgen::InsensitiveAscii("nometre"),
        dictgen::InsensitiveAscii("nometres"),
        dictgen::InsensitiveAscii("rcotise"),
        dictgen::InsensitiveAscii("rcotised"),
        dictgen::InsensitiveAscii("rcotises"),
        dictgen::InsensitiveAscii("rcotising"),
        dictgen::InsensitiveAscii("rcotize"),
        dictgen::InsensitiveAscii("rcotized"),
        dictgen::InsensitiveAscii("rcotizes"),
        dictgen::InsensitiveAscii("rcotizing"),
        dictgen::InsensitiveAscii("salisation"),
        dictgen::InsensitiveAscii("salisations"),
        dictgen::InsensitiveAscii("salise"),
        dictgen::InsensitiveAscii("salised"),
        dictgen::InsensitiveAscii("salises"),
        dictgen::InsensitiveAscii("salising"),
        dictgen::InsensitiveAscii("salization"),
        dictgen::InsensitiveAscii("salizations"),
        dictgen::InsensitiveAscii("salize"),
        dictgen::InsensitiveAscii("salized"),
        dictgen::InsensitiveAscii("salizes"),
        dictgen::InsensitiveAscii("salizing"),
        dictgen::InsensitiveAscii("tionalisation"),
        dictgen::InsensitiveAscii("tionalisations"),
        dictgen::InsensitiveAscii("tionalise"),
        dictgen::InsensitiveAscii("tionalised"),
        dictgen::InsensitiveAscii("tionalises"),
        dictgen::InsensitiveAscii("tionalising"),
        dictgen::InsensitiveAscii("tionalization"),
        dictgen::InsensitiveAscii("tionalizations"),
        dictgen::InsensitiveAscii("tionalize"),
        dictgen::InsensitiveAscii("tionalized"),
        dictgen::InsensitiveAscii("tionalizes"),
        dictgen::InsensitiveAscii("tionalizing"),
        dictgen::InsensitiveAscii("turalisation"),
        dictgen::InsensitiveAscii("turalisations"),
        dictgen::InsensitiveAscii("turalise"),
        dictgen::InsensitiveAscii("turalised"),
        dictgen::InsensitiveAscii("turalises"),
        dictgen::InsensitiveAscii("turalising"),
        dictgen::InsensitiveAscii("turalization"),
        dictgen::InsensitiveAscii("turalizations"),
        dictgen::InsensitiveAscii("turalize"),
        dictgen::InsensitiveAscii("turalized"),
        dictgen::InsensitiveAscii("turalizes"),
        dictgen::InsensitiveAscii("turalizing"),
    ],
    values: &[
        &[(0b01001, &ENTRY_NANOMETER_15050479722914391248)],
        &[(0b01001, &ENTRY_NANOMETERS_14532694249183942048)],
        &[(0b11010, &ENTRY_NANOMETER_15050479722914391248)],
        &[(0b11010, &ENTRY_NANOMETERS_14532694249183942048)],
        &[(0b10010, &ENTRY_NARCOTIZE_14616380840716794484)],
        &[(0b10010, &ENTRY_NARCOTIZED_16901265805353552450)],
        &[(0b10010, &ENTRY_NARCOTIZES_5310729382357568649)],
        &[(0b10010, &ENTRY_NARCOTIZING_7516536430926503777)],
        &[(0b01001, &ENTRY_NARCOTIZE_14616380840716794484)],
        &[(0b01001, &ENTRY_NARCOTIZED_16901265805353552450)],
        &[(0b01001, &ENTRY_NARCOTIZES_5310729382357568649)],
        &[(0b01001, &ENTRY_NARCOTIZING_7516536430926503777)],
        &[(0b10010, &ENTRY_NASALIZATION_9447471797004510318)],
        &[(0b10010, &ENTRY_NASALIZATIONS_7277160551960333351)],
        &[(0b10010, &ENTRY_NASALIZE_76311075047194658)],
        &[(0b10010, &ENTRY_NASALIZED_1043946313139330861)],
        &[(0b10010, &ENTRY_NASALIZES_6487641598131144165)],
        &[(0b10010, &ENTRY_NASALIZING_2082301516066873014)],
        &[(0b01001, &ENTRY_NASALIZATION_9447471797004510318)],
        &[(0b01001, &ENTRY_NASALIZATIONS_7277160551960333351)],
        &[(0b01001, &ENTRY_NASALIZE_76311075047194658)],
        &[(0b01001, &ENTRY_NASALIZED_1043946313139330861)],
        &[(0b01001, &ENTRY_NASALIZES_6487641598131144165)],
        &[(0b01001, &ENTRY_NASALIZING_2082301516066873014)],
        &[(0b10010, &ENTRY_NATIONALIZATION_16093349884516853513)],
        &[(0b10010, &ENTRY_NATIONALIZATIONS_5281594635957507193)],
        &[(0b10010, &ENTRY_NATIONALIZE_1535875549943010403)],
        &[(0b10010, &ENTRY_NATIONALIZED_14123403696319407671)],
        &[(0b10010, &ENTRY_NATIONALIZES_9931517547348470217)],
        &[(0b10010, &ENTRY_NATIONALIZING_154708228623797355)],
        &[(0b01001, &ENTRY_NATIONALIZATION_16093349884516853513)],
        &[(0b01001, &ENTRY_NATIONALIZATIONS_5281594635957507193)],
        &[(0b01001, &ENTRY_NATIONALIZE_1535875549943010403)],
        &[(0b01001, &ENTRY_NATIONALIZED_14123403696319407671)],
        &[(0b01001, &ENTRY_NATIONALIZES_9931517547348470217)],
        &[(0b01001, &ENTRY_NATIONALIZING_154708228623797355)],
        &[(0b10010, &ENTRY_NATURALIZATION_901934936058317884)],
        &[(0b10010, &ENTRY_NATURALIZATIONS_15146375781211350844)],
        &[(0b10010, &ENTRY_NATURALIZE_15129142042727649412)],
        &[(0b10010, &ENTRY_NATURALIZED_4952898848561703349)],
        &[(0b10010, &ENTRY_NATURALIZES_7464268429055724811)],
        &[(0b10010, &ENTRY_NATURALIZING_7589140168222731708)],
        &[(0b01001, &ENTRY_NATURALIZATION_901934936058317884)],
        &[(0b01001, &ENTRY_NATURALIZATIONS_15146375781211350844)],
        &[(0b01001, &ENTRY_NATURALIZE_15129142042727649412)],
        &[(0b01001, &ENTRY_NATURALIZED_4952898848561703349)],
        &[(0b01001, &ENTRY_NATURALIZES_7464268429055724811)],
        &[(0b01001, &ENTRY_NATURALIZING_7589140168222731708)],
    ],
    range: 6..=14,
};

static VARS_M_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_M_CHILDREN),
    value: None,
};

static VARS_M_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_MA_NODE),
    None,
    None,
    None,
    Some(&VARS_ME_NODE),
    None,
    None,
    None,
    Some(&VARS_MI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_MO_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_MU_NODE),
    None,
    None,
    None,
    Some(&VARS_MY_NODE),
    None,
];

static VARS_MY_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_MY_CHILDREN),
    value: None,
};

pub static VARS_MY_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("thicise"),
        dictgen::InsensitiveAscii("thicised"),
        dictgen::InsensitiveAscii("thicises"),
        dictgen::InsensitiveAscii("thicising"),
        dictgen::InsensitiveAscii("thicize"),
        dictgen::InsensitiveAscii("thicized"),
        dictgen::InsensitiveAscii("thicizes"),
        dictgen::InsensitiveAscii("thicizing"),
        dictgen::InsensitiveAscii("thologise"),
        dictgen::InsensitiveAscii("thologised"),
        dictgen::InsensitiveAscii("thologiser"),
        dictgen::InsensitiveAscii("thologisers"),
        dictgen::InsensitiveAscii("thologises"),
        dictgen::InsensitiveAscii("thologising"),
        dictgen::InsensitiveAscii("thologize"),
        dictgen::InsensitiveAscii("thologized"),
        dictgen::InsensitiveAscii("thologizer"),
        dictgen::InsensitiveAscii("thologizers"),
        dictgen::InsensitiveAscii("thologizes"),
        dictgen::InsensitiveAscii("thologizing"),
        dictgen::InsensitiveAscii("thopeic"),
        dictgen::InsensitiveAscii("thopoeic"),
        dictgen::InsensitiveAscii("xedema"),
        dictgen::InsensitiveAscii("xedemas"),
        dictgen::InsensitiveAscii("xoedema"),
        dictgen::InsensitiveAscii("xoedemas"),
    ],
    values: &[
        &[(0b10010, &ENTRY_MYTHICIZE_15101061579084626306)],
        &[(0b10010, &ENTRY_MYTHICIZED_11662179048722869017)],
        &[(0b10010, &ENTRY_MYTHICIZES_9101844747788591414)],
        &[(0b10010, &ENTRY_MYTHICIZING_8015028542255723699)],
        &[(0b01001, &ENTRY_MYTHICIZE_15101061579084626306)],
        &[(0b01001, &ENTRY_MYTHICIZED_11662179048722869017)],
        &[(0b01001, &ENTRY_MYTHICIZES_9101844747788591414)],
        &[(0b01001, &ENTRY_MYTHICIZING_8015028542255723699)],
        &[(0b10010, &ENTRY_MYTHOLOGIZE_17851220199810661728)],
        &[(0b10010, &ENTRY_MYTHOLOGIZED_428065733344575408)],
        &[(0b10010, &ENTRY_MYTHOLOGIZER_5981916303789676389)],
        &[(0b10010, &ENTRY_MYTHOLOGIZERS_12949952831045609835)],
        &[(0b10010, &ENTRY_MYTHOLOGIZES_10098277791216764614)],
        &[(0b10010, &ENTRY_MYTHOLOGIZING_5599630321255412519)],
        &[(0b01001, &ENTRY_MYTHOLOGIZE_17851220199810661728)],
        &[(0b01001, &ENTRY_MYTHOLOGIZED_428065733344575408)],
        &[(0b01001, &ENTRY_MYTHOLOGIZER_5981916303789676389)],
        &[(0b01001, &ENTRY_MYTHOLOGIZERS_12949952831045609835)],
        &[(0b01001, &ENTRY_MYTHOLOGIZES_10098277791216764614)],
        &[(0b01001, &ENTRY_MYTHOLOGIZING_5599630321255412519)],
        &[(0b00001, &ENTRY_MYTHOPEIC_2516977976434896705)],
        &[(0b11010, &ENTRY_MYTHOPEIC_2516977976434896705)],
        &[(0b11001, &ENTRY_MYXEDEMA_1555701545725524849)],
        &[(0b11001, &ENTRY_MYXEDEMAS_15468056638103415791)],
        &[(0b10010, &ENTRY_MYXEDEMA_1555701545725524849)],
        &[(0b10010, &ENTRY_MYXEDEMAS_15468056638103415791)],
    ],
    range: 6..=11,
};

static VARS_MU_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_MU_CHILDREN),
    value: None,
};

pub static VARS_MU_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("stache"),
        dictgen::InsensitiveAscii("stached"),
        dictgen::InsensitiveAscii("staches"),
    ],
    values: &[
        &[(0b01001, &ENTRY_MUSTACHE_14138320497461763274)],
        &[(0b00001, &ENTRY_MUSTACHED_2746912378249692800)],
        &[(0b01001, &ENTRY_MUSTACHES_1764222008694028144)],
    ],
    range: 6..=7,
};

static VARS_MO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_MO_CHILDREN),
    value: None,
};

static VARS_MO_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    Some(&VARS_MOB_NODE),
    None,
    Some(&VARS_MOD_NODE),
    None,
    None,
    Some(&VARS_MOG_NODE),
    None,
    Some(&VARS_MOI_NODE),
    None,
    None,
    Some(&VARS_MOL_NODE),
    None,
    Some(&VARS_MON_NODE),
    None,
    None,
    None,
    Some(&VARS_MOR_NODE),
    None,
    Some(&VARS_MOT_NODE),
    Some(&VARS_MOU_NODE),
    Some(&VARS_MOV_NODE),
    None,
    None,
    None,
    None,
];

static VARS_MOV_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_MOV_CHILDREN),
    value: None,
};

pub static VARS_MOV_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[dictgen::InsensitiveAscii("eability")],
    values: &[&[(0b00001, &ENTRY_MOVABILITY_2120736134131484989)]],
    range: 8..=8,
};

static VARS_MOU_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_MOU_CHILDREN),
    value: None,
};

pub static VARS_MOU_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ld"),
        dictgen::InsensitiveAscii("lded"),
        dictgen::InsensitiveAscii("lder"),
        dictgen::InsensitiveAscii("ldered"),
        dictgen::InsensitiveAscii("ldering"),
        dictgen::InsensitiveAscii("lders"),
        dictgen::InsensitiveAscii("ldier"),
        dictgen::InsensitiveAscii("ldiest"),
        dictgen::InsensitiveAscii("lding"),
        dictgen::InsensitiveAscii("ldings"),
        dictgen::InsensitiveAscii("lds"),
        dictgen::InsensitiveAscii("ldy"),
        dictgen::InsensitiveAscii("lt"),
        dictgen::InsensitiveAscii("lted"),
        dictgen::InsensitiveAscii("lting"),
        dictgen::InsensitiveAscii("lts"),
        dictgen::InsensitiveAscii("stache"),
        dictgen::InsensitiveAscii("stached"),
        dictgen::InsensitiveAscii("staches"),
    ],
    values: &[
        &[(0b11010, &ENTRY_MOLD_13654108368759432573)],
        &[(0b11010, &ENTRY_MOLDED_18226100678955103665)],
        &[(0b11010, &ENTRY_MOLDER_15465918692066970810)],
        &[(0b11010, &ENTRY_MOLDERED_4758916297507026457)],
        &[(0b11010, &ENTRY_MOLDERING_12580871299131147348)],
        &[(0b11010, &ENTRY_MOLDERS_13997118245436919961)],
        &[(0b11010, &ENTRY_MOLDIER_10922522589068582068)],
        &[(0b11010, &ENTRY_MOLDIEST_1317386157625536454)],
        &[(0b11010, &ENTRY_MOLDING_5803372015928130364)],
        &[(0b11010, &ENTRY_MOLDINGS_2565998909932841371)],
        &[(0b11010, &ENTRY_MOLDS_12422213630336798844)],
        &[(0b11010, &ENTRY_MOLDY_14321784814821274745)],
        &[(0b11010, &ENTRY_MOLT_17322314851966354350)],
        &[(0b11010, &ENTRY_MOLTED_15961459823560620603)],
        &[(0b11010, &ENTRY_MOLTING_8804427143377484509)],
        &[(0b11010, &ENTRY_MOLTS_9899279585297366446)],
        &[(0b11010, &ENTRY_MUSTACHE_14138320497461763274)],
        &[(0b11010, &ENTRY_MUSTACHED_2746912378249692800)],
        &[(0b11010, &ENTRY_MUSTACHES_1764222008694028144)],
    ],
    range: 2..=7,
};

static VARS_MOT_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_MOT_CHILDREN),
    value: None,
};

pub static VARS_MOT_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("orisation"),
        dictgen::InsensitiveAscii("orisations"),
        dictgen::InsensitiveAscii("orise"),
        dictgen::InsensitiveAscii("orised"),
        dictgen::InsensitiveAscii("orises"),
        dictgen::InsensitiveAscii("orising"),
        dictgen::InsensitiveAscii("orization"),
        dictgen::InsensitiveAscii("orizations"),
        dictgen::InsensitiveAscii("orize"),
        dictgen::InsensitiveAscii("orized"),
        dictgen::InsensitiveAscii("orizes"),
        dictgen::InsensitiveAscii("orizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_MOTORIZATION_15203193516949680060)],
        &[(0b10010, &ENTRY_MOTORIZATIONS_5644703283678263848)],
        &[(0b10010, &ENTRY_MOTORIZE_8341729549011887242)],
        &[(0b10010, &ENTRY_MOTORIZED_10933184907556825861)],
        &[(0b10010, &ENTRY_MOTORIZES_16591316114722878019)],
        &[(0b10010, &ENTRY_MOTORIZING_5672986852014941836)],
        &[(0b01001, &ENTRY_MOTORIZATION_15203193516949680060)],
        &[(0b01001, &ENTRY_MOTORIZATIONS_5644703283678263848)],
        &[(0b01001, &ENTRY_MOTORIZE_8341729549011887242)],
        &[(0b01001, &ENTRY_MOTORIZED_10933184907556825861)],
        &[(0b01001, &ENTRY_MOTORIZES_16591316114722878019)],
        &[(0b01001, &ENTRY_MOTORIZING_5672986852014941836)],
    ],
    range: 5..=10,
};

static VARS_MOR_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_MOR_CHILDREN),
    value: None,
};

pub static VARS_MOR_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("alisation"),
        dictgen::InsensitiveAscii("alisations"),
        dictgen::InsensitiveAscii("alise"),
        dictgen::InsensitiveAscii("alised"),
        dictgen::InsensitiveAscii("aliser"),
        dictgen::InsensitiveAscii("alisers"),
        dictgen::InsensitiveAscii("alises"),
        dictgen::InsensitiveAscii("alising"),
        dictgen::InsensitiveAscii("alisinglies"),
        dictgen::InsensitiveAscii("alisingly"),
        dictgen::InsensitiveAscii("alization"),
        dictgen::InsensitiveAscii("alizations"),
        dictgen::InsensitiveAscii("alize"),
        dictgen::InsensitiveAscii("alized"),
        dictgen::InsensitiveAscii("alizer"),
        dictgen::InsensitiveAscii("alizers"),
        dictgen::InsensitiveAscii("alizes"),
        dictgen::InsensitiveAscii("alizing"),
        dictgen::InsensitiveAscii("alizinglies"),
        dictgen::InsensitiveAscii("alizingly"),
    ],
    values: &[
        &[(0b10010, &ENTRY_MORALIZATION_14314788277554352162)],
        &[(0b10010, &ENTRY_MORALIZATIONS_1247598452579114999)],
        &[(0b10010, &ENTRY_MORALIZE_12018775556937054309)],
        &[(0b10010, &ENTRY_MORALIZED_16553177123856203000)],
        &[(0b10010, &ENTRY_MORALIZER_4189449725336148474)],
        &[(0b10010, &ENTRY_MORALIZERS_10483038900046187164)],
        &[(0b10010, &ENTRY_MORALIZES_9700732558433022344)],
        &[(0b10010, &ENTRY_MORALIZING_1210066302484943067)],
        &[(0b10010, &ENTRY_MORALIZINGLIES_11220751541860329137)],
        &[(0b10010, &ENTRY_MORALIZINGLY_11960315981427170808)],
        &[(0b01001, &ENTRY_MORALIZATION_14314788277554352162)],
        &[(0b01001, &ENTRY_MORALIZATIONS_1247598452579114999)],
        &[(0b01001, &ENTRY_MORALIZE_12018775556937054309)],
        &[(0b01001, &ENTRY_MORALIZED_16553177123856203000)],
        &[(0b01001, &ENTRY_MORALIZER_4189449725336148474)],
        &[(0b01001, &ENTRY_MORALIZERS_10483038900046187164)],
        &[(0b01001, &ENTRY_MORALIZES_9700732558433022344)],
        &[(0b01001, &ENTRY_MORALIZING_1210066302484943067)],
        &[(0b01001, &ENTRY_MORALIZINGLIES_11220751541860329137)],
        &[(0b01001, &ENTRY_MORALIZINGLY_11960315981427170808)],
    ],
    range: 5..=11,
};

static VARS_MON_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_MON_CHILDREN),
    value: None,
};

pub static VARS_MON_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ecious"),
        dictgen::InsensitiveAscii("etisation"),
        dictgen::InsensitiveAscii("etisations"),
        dictgen::InsensitiveAscii("etization"),
        dictgen::InsensitiveAscii("etizations"),
        dictgen::InsensitiveAscii("grelisation"),
        dictgen::InsensitiveAscii("grelisations"),
        dictgen::InsensitiveAscii("grelise"),
        dictgen::InsensitiveAscii("grelised"),
        dictgen::InsensitiveAscii("grelises"),
        dictgen::InsensitiveAscii("grelising"),
        dictgen::InsensitiveAscii("grelization"),
        dictgen::InsensitiveAscii("grelizations"),
        dictgen::InsensitiveAscii("grelize"),
        dictgen::InsensitiveAscii("grelized"),
        dictgen::InsensitiveAscii("grelizes"),
        dictgen::InsensitiveAscii("grelizing"),
        dictgen::InsensitiveAscii("olog"),
        dictgen::InsensitiveAscii("ologs"),
        dictgen::InsensitiveAscii("opolisation"),
        dictgen::InsensitiveAscii("opolisations"),
        dictgen::InsensitiveAscii("opolise"),
        dictgen::InsensitiveAscii("opolised"),
        dictgen::InsensitiveAscii("opoliser"),
        dictgen::InsensitiveAscii("opolisers"),
        dictgen::InsensitiveAscii("opolises"),
        dictgen::InsensitiveAscii("opolising"),
        dictgen::InsensitiveAscii("opolization"),
        dictgen::InsensitiveAscii("opolizations"),
        dictgen::InsensitiveAscii("opolize"),
        dictgen::InsensitiveAscii("opolized"),
        dictgen::InsensitiveAscii("opolizer"),
        dictgen::InsensitiveAscii("opolizers"),
        dictgen::InsensitiveAscii("opolizes"),
        dictgen::InsensitiveAscii("opolizing"),
        dictgen::InsensitiveAscii("umentalise"),
        dictgen::InsensitiveAscii("umentalised"),
        dictgen::InsensitiveAscii("umentalises"),
        dictgen::InsensitiveAscii("umentalising"),
        dictgen::InsensitiveAscii("umentalize"),
        dictgen::InsensitiveAscii("umentalized"),
        dictgen::InsensitiveAscii("umentalizes"),
        dictgen::InsensitiveAscii("umentalizing"),
    ],
    values: &[
        &[(0b00001, &ENTRY_MONOECIOUS_9746279935101117316)],
        &[(0b10010, &ENTRY_MONETIZATION_13483845355572497348)],
        &[(0b10010, &ENTRY_MONETIZATIONS_14358715948666978904)],
        &[(0b01001, &ENTRY_MONETIZATION_13483845355572497348)],
        &[(0b01001, &ENTRY_MONETIZATIONS_14358715948666978904)],
        &[(0b10010, &ENTRY_MONGRELIZATION_15091053595967389048)],
        &[(0b10010, &ENTRY_MONGRELIZATIONS_2436371981269651275)],
        &[(0b10010, &ENTRY_MONGRELIZE_11229468945460271254)],
        &[(0b10010, &ENTRY_MONGRELIZED_8363623153012541092)],
        &[(0b10010, &ENTRY_MONGRELIZES_8947086149363047319)],
        &[(0b10010, &ENTRY_MONGRELIZING_5997412177056765410)],
        &[(0b01001, &ENTRY_MONGRELIZATION_15091053595967389048)],
        &[(0b01001, &ENTRY_MONGRELIZATIONS_2436371981269651275)],
        &[(0b01001, &ENTRY_MONGRELIZE_11229468945460271254)],
        &[(0b01001, &ENTRY_MONGRELIZED_8363623153012541092)],
        &[(0b01001, &ENTRY_MONGRELIZES_8947086149363047319)],
        &[(0b01001, &ENTRY_MONGRELIZING_5997412177056765410)],
        &[(0b00001, &ENTRY_MONOLOGUE_3143921545359140083)],
        &[(0b00001, &ENTRY_MONOLOGUES_17834811023314193123)],
        &[(0b10010, &ENTRY_MONOPOLIZATION_17799440194255806413)],
        &[(0b10010, &ENTRY_MONOPOLIZATIONS_10067342361986951454)],
        &[(0b10010, &ENTRY_MONOPOLIZE_7442479439377420004)],
        &[(0b10010, &ENTRY_MONOPOLIZED_12340647197458384203)],
        &[(0b10010, &ENTRY_MONOPOLIZER_2371550496160060744)],
        &[(0b10010, &ENTRY_MONOPOLIZERS_6125991689529832032)],
        &[(0b10010, &ENTRY_MONOPOLIZES_12189941398566584704)],
        &[(0b10010, &ENTRY_MONOPOLIZING_16637234271263734393)],
        &[(0b01001, &ENTRY_MONOPOLIZATION_17799440194255806413)],
        &[(0b01001, &ENTRY_MONOPOLIZATIONS_10067342361986951454)],
        &[(0b01001, &ENTRY_MONOPOLIZE_7442479439377420004)],
        &[(0b01001, &ENTRY_MONOPOLIZED_12340647197458384203)],
        &[(0b01001, &ENTRY_MONOPOLIZER_2371550496160060744)],
        &[(0b01001, &ENTRY_MONOPOLIZERS_6125991689529832032)],
        &[(0b01001, &ENTRY_MONOPOLIZES_12189941398566584704)],
        &[(0b01001, &ENTRY_MONOPOLIZING_16637234271263734393)],
        &[(0b10010, &ENTRY_MONUMENTALIZE_13392828455281638997)],
        &[(0b10010, &ENTRY_MONUMENTALIZED_5711079078755470487)],
        &[(0b10010, &ENTRY_MONUMENTALIZES_504136983336154068)],
        &[(0b10010, &ENTRY_MONUMENTALIZING_135723146422787131)],
        &[(0b01001, &ENTRY_MONUMENTALIZE_13392828455281638997)],
        &[(0b01001, &ENTRY_MONUMENTALIZED_5711079078755470487)],
        &[(0b01001, &ENTRY_MONUMENTALIZES_504136983336154068)],
        &[(0b01001, &ENTRY_MONUMENTALIZING_135723146422787131)],
    ],
    range: 4..=12,
};

static VARS_MOL_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_MOL_CHILDREN),
    value: None,
};

pub static VARS_MOL_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("d"),
        dictgen::InsensitiveAscii("ded"),
        dictgen::InsensitiveAscii("der"),
        dictgen::InsensitiveAscii("dered"),
        dictgen::InsensitiveAscii("dering"),
        dictgen::InsensitiveAscii("ders"),
        dictgen::InsensitiveAscii("dier"),
        dictgen::InsensitiveAscii("diest"),
        dictgen::InsensitiveAscii("ding"),
        dictgen::InsensitiveAscii("dings"),
        dictgen::InsensitiveAscii("ds"),
        dictgen::InsensitiveAscii("dy"),
        dictgen::InsensitiveAscii("lusk"),
        dictgen::InsensitiveAscii("luskan"),
        dictgen::InsensitiveAscii("lusks"),
        dictgen::InsensitiveAscii("t"),
        dictgen::InsensitiveAscii("ted"),
        dictgen::InsensitiveAscii("ting"),
        dictgen::InsensitiveAscii("ts"),
    ],
    values: &[
        &[(0b11001, &ENTRY_MOLD_13654108368759432573)],
        &[(0b11001, &ENTRY_MOLDED_18226100678955103665)],
        &[(0b10001, &ENTRY_MOLDER_15465918692066970810)],
        &[(0b10001, &ENTRY_MOLDERED_4758916297507026457)],
        &[(0b10001, &ENTRY_MOLDERING_12580871299131147348)],
        &[(0b10001, &ENTRY_MOLDERS_13997118245436919961)],
        &[(0b11001, &ENTRY_MOLDIER_10922522589068582068)],
        &[(0b11001, &ENTRY_MOLDIEST_1317386157625536454)],
        &[(0b11001, &ENTRY_MOLDING_5803372015928130364)],
        &[(0b11001, &ENTRY_MOLDINGS_2565998909932841371)],
        &[(0b11001, &ENTRY_MOLDS_12422213630336798844)],
        &[(0b11001, &ENTRY_MOLDY_14321784814821274745)],
        &[(0b00001, &ENTRY_MOLLUSK_6823511292751098286)],
        &[(0b00001, &ENTRY_MOLLUSCAN_17330317330413879995)],
        &[(0b00001, &ENTRY_MOLLUSKS_7011160555842704825)],
        &[(0b10001, &ENTRY_MOLT_17322314851966354350)],
        &[(0b10001, &ENTRY_MOLTED_15961459823560620603)],
        &[(0b10001, &ENTRY_MOLTING_8804427143377484509)],
        &[(0b10001, &ENTRY_MOLTS_9899279585297366446)],
    ],
    range: 1..=6,
};

static VARS_MOI_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_MOI_CHILDREN),
    value: None,
};

pub static VARS_MOI_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("sturise"),
        dictgen::InsensitiveAscii("sturised"),
        dictgen::InsensitiveAscii("sturiser"),
        dictgen::InsensitiveAscii("sturisers"),
        dictgen::InsensitiveAscii("sturises"),
        dictgen::InsensitiveAscii("sturising"),
        dictgen::InsensitiveAscii("sturize"),
        dictgen::InsensitiveAscii("sturized"),
        dictgen::InsensitiveAscii("sturizer"),
        dictgen::InsensitiveAscii("sturizers"),
        dictgen::InsensitiveAscii("sturizes"),
        dictgen::InsensitiveAscii("sturizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_MOISTURIZE_3082181073277609007)],
        &[(0b10010, &ENTRY_MOISTURIZED_16147661633583544526)],
        &[(0b10010, &ENTRY_MOISTURIZER_976074536579829817)],
        &[(0b10010, &ENTRY_MOISTURIZERS_9974196958240719712)],
        &[(0b10010, &ENTRY_MOISTURIZES_5386452103898759766)],
        &[(0b10010, &ENTRY_MOISTURIZING_1153301405850895778)],
        &[(0b01001, &ENTRY_MOISTURIZE_3082181073277609007)],
        &[(0b01001, &ENTRY_MOISTURIZED_16147661633583544526)],
        &[(0b01001, &ENTRY_MOISTURIZER_976074536579829817)],
        &[(0b01001, &ENTRY_MOISTURIZERS_9974196958240719712)],
        &[(0b01001, &ENTRY_MOISTURIZES_5386452103898759766)],
        &[(0b01001, &ENTRY_MOISTURIZING_1153301405850895778)],
    ],
    range: 7..=9,
};

static VARS_MOG_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_MOG_CHILDREN),
    value: None,
};

pub static VARS_MOG_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[dictgen::InsensitiveAscii("gy")],
    values: &[&[(0b10011, &ENTRY_MOGGY_7403358484289979778)]],
    range: 2..=2,
};

static VARS_MOD_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_MOD_CHILDREN),
    value: None,
};

pub static VARS_MOD_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("eled"),
        dictgen::InsensitiveAscii("eler"),
        dictgen::InsensitiveAscii("elers"),
        dictgen::InsensitiveAscii("eling"),
        dictgen::InsensitiveAscii("elings"),
        dictgen::InsensitiveAscii("elled"),
        dictgen::InsensitiveAscii("eller"),
        dictgen::InsensitiveAscii("ellers"),
        dictgen::InsensitiveAscii("elling"),
        dictgen::InsensitiveAscii("ellings"),
        dictgen::InsensitiveAscii("ernisation"),
        dictgen::InsensitiveAscii("ernisations"),
        dictgen::InsensitiveAscii("ernise"),
        dictgen::InsensitiveAscii("ernised"),
        dictgen::InsensitiveAscii("erniser"),
        dictgen::InsensitiveAscii("ernisers"),
        dictgen::InsensitiveAscii("ernises"),
        dictgen::InsensitiveAscii("ernising"),
        dictgen::InsensitiveAscii("ernization"),
        dictgen::InsensitiveAscii("ernizations"),
        dictgen::InsensitiveAscii("ernize"),
        dictgen::InsensitiveAscii("ernized"),
        dictgen::InsensitiveAscii("ernizer"),
        dictgen::InsensitiveAscii("ernizers"),
        dictgen::InsensitiveAscii("ernizes"),
        dictgen::InsensitiveAscii("ernizing"),
    ],
    values: &[
        &[(0b00001, &ENTRY_MODELED_12650479689070423426)],
        &[(0b00001, &ENTRY_MODELER_14424786862458395262)],
        &[(0b00001, &ENTRY_MODELERS_3381426157906439456)],
        &[(0b00001, &ENTRY_MODELING_2974344260900643587)],
        &[(0b00001, &ENTRY_MODELINGS_18288599171721945682)],
        &[(0b11010, &ENTRY_MODELED_12650479689070423426)],
        &[(0b11010, &ENTRY_MODELER_14424786862458395262)],
        &[(0b11010, &ENTRY_MODELERS_3381426157906439456)],
        &[(0b11010, &ENTRY_MODELING_2974344260900643587)],
        &[(0b11010, &ENTRY_MODELINGS_18288599171721945682)],
        &[(0b10010, &ENTRY_MODERNIZATION_14709070202714057545)],
        &[(0b10010, &ENTRY_MODERNIZATIONS_11584063023767292185)],
        &[(0b10010, &ENTRY_MODERNIZE_7510605744058517470)],
        &[(0b10010, &ENTRY_MODERNIZED_16345622123558324284)],
        &[(0b10010, &ENTRY_MODERNIZER_18233663007102441685)],
        &[(0b10010, &ENTRY_MODERNIZERS_17286474013116987617)],
        &[(0b10010, &ENTRY_MODERNIZES_12697791365347916756)],
        &[(0b10010, &ENTRY_MODERNIZING_5025029940522757107)],
        &[(0b01001, &ENTRY_MODERNIZATION_14709070202714057545)],
        &[(0b01001, &ENTRY_MODERNIZATIONS_11584063023767292185)],
        &[(0b01001, &ENTRY_MODERNIZE_7510605744058517470)],
        &[(0b01001, &ENTRY_MODERNIZED_16345622123558324284)],
        &[(0b01001, &ENTRY_MODERNIZER_18233663007102441685)],
        &[(0b01001, &ENTRY_MODERNIZERS_17286474013116987617)],
        &[(0b01001, &ENTRY_MODERNIZES_12697791365347916756)],
        &[(0b01001, &ENTRY_MODERNIZING_5025029940522757107)],
    ],
    range: 4..=11,
};

static VARS_MOB_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_MOB_CHILDREN),
    value: None,
};

pub static VARS_MOB_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ilisable"),
        dictgen::InsensitiveAscii("ilisabler"),
        dictgen::InsensitiveAscii("ilisables"),
        dictgen::InsensitiveAscii("ilisablest"),
        dictgen::InsensitiveAscii("ilisation"),
        dictgen::InsensitiveAscii("ilisations"),
        dictgen::InsensitiveAscii("ilise"),
        dictgen::InsensitiveAscii("ilised"),
        dictgen::InsensitiveAscii("iliser"),
        dictgen::InsensitiveAscii("ilisers"),
        dictgen::InsensitiveAscii("ilises"),
        dictgen::InsensitiveAscii("ilising"),
        dictgen::InsensitiveAscii("ilizable"),
        dictgen::InsensitiveAscii("ilizabler"),
        dictgen::InsensitiveAscii("ilizables"),
        dictgen::InsensitiveAscii("ilizablest"),
        dictgen::InsensitiveAscii("ilization"),
        dictgen::InsensitiveAscii("ilizations"),
        dictgen::InsensitiveAscii("ilize"),
        dictgen::InsensitiveAscii("ilized"),
        dictgen::InsensitiveAscii("ilizer"),
        dictgen::InsensitiveAscii("ilizers"),
        dictgen::InsensitiveAscii("ilizes"),
        dictgen::InsensitiveAscii("ilizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_MOBILIZABLE_4838354601271065797)],
        &[(0b10010, &ENTRY_MOBILIZABLER_550692436973252168)],
        &[(0b10010, &ENTRY_MOBILIZABLES_13069683708079300928)],
        &[(0b10010, &ENTRY_MOBILIZABLEST_2936215873432536207)],
        &[(0b10010, &ENTRY_MOBILIZATION_5777426368387580657)],
        &[(0b10010, &ENTRY_MOBILIZATIONS_14453487133355314782)],
        &[(0b10010, &ENTRY_MOBILIZE_8789464231798787986)],
        &[(0b10010, &ENTRY_MOBILIZED_5804933841881642219)],
        &[(0b10010, &ENTRY_MOBILIZER_10343085295594491112)],
        &[(0b10010, &ENTRY_MOBILIZERS_3858507952045243762)],
        &[(0b10010, &ENTRY_MOBILIZES_16439067393017229087)],
        &[(0b10010, &ENTRY_MOBILIZING_1417290482744517718)],
        &[(0b01001, &ENTRY_MOBILIZABLE_4838354601271065797)],
        &[(0b01001, &ENTRY_MOBILIZABLER_550692436973252168)],
        &[(0b01001, &ENTRY_MOBILIZABLES_13069683708079300928)],
        &[(0b01001, &ENTRY_MOBILIZABLEST_2936215873432536207)],
        &[(0b01001, &ENTRY_MOBILIZATION_5777426368387580657)],
        &[(0b01001, &ENTRY_MOBILIZATIONS_14453487133355314782)],
        &[(0b01001, &ENTRY_MOBILIZE_8789464231798787986)],
        &[(0b01001, &ENTRY_MOBILIZED_5804933841881642219)],
        &[(0b01001, &ENTRY_MOBILIZER_10343085295594491112)],
        &[(0b01001, &ENTRY_MOBILIZERS_3858507952045243762)],
        &[(0b01001, &ENTRY_MOBILIZES_16439067393017229087)],
        &[(0b01001, &ENTRY_MOBILIZING_1417290482744517718)],
    ],
    range: 5..=10,
};

static VARS_MI_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_MI_CHILDREN),
    value: None,
};

static VARS_MI_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_MIA_NODE),
    None,
    Some(&VARS_MIC_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_MIL_NODE),
    None,
    Some(&VARS_MIN_NODE),
    None,
    None,
    None,
    None,
    Some(&VARS_MIS_NODE),
    Some(&VARS_MIT_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_MIT_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_MIT_CHILDREN),
    value: None,
};

pub static VARS_MIT_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("er"),
        dictgen::InsensitiveAscii("ered"),
        dictgen::InsensitiveAscii("ering"),
        dictgen::InsensitiveAscii("ers"),
        dictgen::InsensitiveAscii("re"),
        dictgen::InsensitiveAscii("red"),
        dictgen::InsensitiveAscii("res"),
        dictgen::InsensitiveAscii("ring"),
    ],
    values: &[
        &[(0b00001, &ENTRY_MITER_14901282210601132768)],
        &[(0b00001, &ENTRY_MITERED_8698507717371065494)],
        &[(0b00001, &ENTRY_MITERING_17472611887349673354)],
        &[(0b00001, &ENTRY_MITERS_13601882143052765005)],
        &[(0b11010, &ENTRY_MITER_14901282210601132768)],
        &[(0b11010, &ENTRY_MITERED_8698507717371065494)],
        &[(0b11010, &ENTRY_MITERS_13601882143052765005)],
        &[(0b11010, &ENTRY_MITERING_17472611887349673354)],
    ],
    range: 2..=5,
};

static VARS_MIS_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_MIS_CHILDREN),
    value: None,
};

pub static VARS_MIS_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("behavior"),
        dictgen::InsensitiveAscii("behaviors"),
        dictgen::InsensitiveAscii("behaviour"),
        dictgen::InsensitiveAscii("behaviours"),
        dictgen::InsensitiveAscii("demeanor"),
        dictgen::InsensitiveAscii("demeanors"),
        dictgen::InsensitiveAscii("demeanour"),
        dictgen::InsensitiveAscii("demeanours"),
        dictgen::InsensitiveAscii("judgement"),
        dictgen::InsensitiveAscii("judgements"),
        dictgen::InsensitiveAscii("prise"),
        dictgen::InsensitiveAscii("prised"),
        dictgen::InsensitiveAscii("prises"),
        dictgen::InsensitiveAscii("prising"),
    ],
    values: &[
        &[(0b10001, &ENTRY_MISBEHAVIOR_1494581758331316402)],
        &[(0b10001, &ENTRY_MISBEHAVIORS_4095360583991043350)],
        &[(0b11010, &ENTRY_MISBEHAVIOR_1494581758331316402)],
        &[(0b11010, &ENTRY_MISBEHAVIORS_4095360583991043350)],
        &[(0b11001, &ENTRY_MISDEMEANOR_1250919998876899665)],
        &[(0b11001, &ENTRY_MISDEMEANORS_11749207148565478841)],
        &[(0b11010, &ENTRY_MISDEMEANOR_1250919998876899665)],
        &[(0b11010, &ENTRY_MISDEMEANORS_11749207148565478841)],
        &[(0b11010, &ENTRY_MISJUDGMENT_17843686745476490529)],
        &[(0b11010, &ENTRY_MISJUDGMENTS_17389672896349870910)],
        &[(0b11010, &ENTRY_MISPRIZE_7317761504865217596)],
        &[(0b11010, &ENTRY_MISPRIZED_15910979320445924885)],
        &[(0b11010, &ENTRY_MISPRIZES_16040140991463042359)],
        &[(0b11010, &ENTRY_MISPRIZING_12105379912423556571)],
    ],
    range: 5..=10,
};

static VARS_MIN_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_MIN_CHILDREN),
    value: None,
};

pub static VARS_MIN_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("eralisation"),
        dictgen::InsensitiveAscii("eralisations"),
        dictgen::InsensitiveAscii("eralise"),
        dictgen::InsensitiveAscii("eralised"),
        dictgen::InsensitiveAscii("eralises"),
        dictgen::InsensitiveAscii("eralising"),
        dictgen::InsensitiveAscii("eralization"),
        dictgen::InsensitiveAscii("eralizations"),
        dictgen::InsensitiveAscii("eralize"),
        dictgen::InsensitiveAscii("eralized"),
        dictgen::InsensitiveAscii("eralizes"),
        dictgen::InsensitiveAscii("eralizing"),
        dictgen::InsensitiveAscii("iaturisation"),
        dictgen::InsensitiveAscii("iaturisations"),
        dictgen::InsensitiveAscii("iaturise"),
        dictgen::InsensitiveAscii("iaturised"),
        dictgen::InsensitiveAscii("iaturises"),
        dictgen::InsensitiveAscii("iaturising"),
        dictgen::InsensitiveAscii("iaturization"),
        dictgen::InsensitiveAscii("iaturizations"),
        dictgen::InsensitiveAscii("iaturize"),
        dictgen::InsensitiveAscii("iaturized"),
        dictgen::InsensitiveAscii("iaturizes"),
        dictgen::InsensitiveAscii("iaturizing"),
        dictgen::InsensitiveAscii("ibusses"),
        dictgen::InsensitiveAscii("imisation"),
        dictgen::InsensitiveAscii("imisations"),
        dictgen::InsensitiveAscii("imise"),
        dictgen::InsensitiveAscii("imised"),
        dictgen::InsensitiveAscii("imiser"),
        dictgen::InsensitiveAscii("imisers"),
        dictgen::InsensitiveAscii("imises"),
        dictgen::InsensitiveAscii("imising"),
        dictgen::InsensitiveAscii("imization"),
        dictgen::InsensitiveAscii("imizations"),
        dictgen::InsensitiveAscii("imize"),
        dictgen::InsensitiveAscii("imized"),
        dictgen::InsensitiveAscii("imizer"),
        dictgen::InsensitiveAscii("imizers"),
        dictgen::InsensitiveAscii("imizes"),
        dictgen::InsensitiveAscii("imizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_MINERALIZATION_6932253078663165468)],
        &[(0b10010, &ENTRY_MINERALIZATIONS_10546963403531567133)],
        &[(0b10010, &ENTRY_MINERALIZE_7945578525483035467)],
        &[(0b10010, &ENTRY_MINERALIZED_4247107678262591457)],
        &[(0b10010, &ENTRY_MINERALIZES_12077281629276944607)],
        &[(0b10010, &ENTRY_MINERALIZING_3182430059767749821)],
        &[(0b01001, &ENTRY_MINERALIZATION_6932253078663165468)],
        &[(0b01001, &ENTRY_MINERALIZATIONS_10546963403531567133)],
        &[(0b01001, &ENTRY_MINERALIZE_7945578525483035467)],
        &[(0b01001, &ENTRY_MINERALIZED_4247107678262591457)],
        &[(0b01001, &ENTRY_MINERALIZES_12077281629276944607)],
        &[(0b01001, &ENTRY_MINERALIZING_3182430059767749821)],
        &[(0b10010, &ENTRY_MINIATURIZATION_11771675081402773636)],
        &[(0b10010, &ENTRY_MINIATURIZATIONS_13443825612505429435)],
        &[(0b10010, &ENTRY_MINIATURIZE_14775476687436824687)],
        &[(0b10010, &ENTRY_MINIATURIZED_3880152562256982898)],
        &[(0b10010, &ENTRY_MINIATURIZES_4987348295329229449)],
        &[(0b10010, &ENTRY_MINIATURIZING_4324908215288109965)],
        &[(0b01001, &ENTRY_MINIATURIZATION_11771675081402773636)],
        &[(0b01001, &ENTRY_MINIATURIZATIONS_13443825612505429435)],
        &[(0b01001, &ENTRY_MINIATURIZE_14775476687436824687)],
        &[(0b01001, &ENTRY_MINIATURIZED_3880152562256982898)],
        &[(0b01001, &ENTRY_MINIATURIZES_4987348295329229449)],
        &[(0b01001, &ENTRY_MINIATURIZING_4324908215288109965)],
        &[(0b00001, &ENTRY_MINIBUSES_11051687516105212429)],
        &[(0b10010, &ENTRY_MINIMIZATION_15941432212626950244)],
        &[(0b10010, &ENTRY_MINIMIZATIONS_16859838846464243203)],
        &[(0b10010, &ENTRY_MINIMIZE_2781781045543044735)],
        &[(0b10010, &ENTRY_MINIMIZED_11553117414376788475)],
        &[(0b10010, &ENTRY_MINIMIZER_5548812611203507924)],
        &[(0b10010, &ENTRY_MINIMIZERS_3612737951166107599)],
        &[(0b10010, &ENTRY_MINIMIZES_9554981472878791756)],
        &[(0b10010, &ENTRY_MINIMIZING_16481774084401198225)],
        &[(0b01001, &ENTRY_MINIMIZATION_15941432212626950244)],
        &[(0b01001, &ENTRY_MINIMIZATIONS_16859838846464243203)],
        &[(0b01001, &ENTRY_MINIMIZE_2781781045543044735)],
        &[(0b01001, &ENTRY_MINIMIZED_11553117414376788475)],
        &[(0b01001, &ENTRY_MINIMIZER_5548812611203507924)],
        &[(0b01001, &ENTRY_MINIMIZERS_3612737951166107599)],
        &[(0b01001, &ENTRY_MINIMIZES_9554981472878791756)],
        &[(0b01001, &ENTRY_MINIMIZING_16481774084401198225)],
    ],
    range: 5..=13,
};

static VARS_MIL_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_MIL_CHILDREN),
    value: None,
};

pub static VARS_MIL_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("itarisation"),
        dictgen::InsensitiveAscii("itarisations"),
        dictgen::InsensitiveAscii("itarise"),
        dictgen::InsensitiveAscii("itarised"),
        dictgen::InsensitiveAscii("itarises"),
        dictgen::InsensitiveAscii("itarising"),
        dictgen::InsensitiveAscii("itarization"),
        dictgen::InsensitiveAscii("itarizations"),
        dictgen::InsensitiveAscii("itarize"),
        dictgen::InsensitiveAscii("itarized"),
        dictgen::InsensitiveAscii("itarizes"),
        dictgen::InsensitiveAscii("itarizing"),
        dictgen::InsensitiveAscii("ligramme"),
        dictgen::InsensitiveAscii("ligrammes"),
        dictgen::InsensitiveAscii("liliter"),
        dictgen::InsensitiveAscii("liliters"),
        dictgen::InsensitiveAscii("lilitre"),
        dictgen::InsensitiveAscii("lilitres"),
        dictgen::InsensitiveAscii("limeter"),
        dictgen::InsensitiveAscii("limeters"),
        dictgen::InsensitiveAscii("limetre"),
        dictgen::InsensitiveAscii("limetres"),
    ],
    values: &[
        &[(0b10010, &ENTRY_MILITARIZATION_8896321595375246390)],
        &[(0b10010, &ENTRY_MILITARIZATIONS_7705734301801515430)],
        &[(0b10010, &ENTRY_MILITARIZE_9495798303128415382)],
        &[(0b10010, &ENTRY_MILITARIZED_16232436267971009706)],
        &[(0b10010, &ENTRY_MILITARIZES_14452269897116904753)],
        &[(0b10010, &ENTRY_MILITARIZING_554769254101207928)],
        &[(0b01001, &ENTRY_MILITARIZATION_8896321595375246390)],
        &[(0b01001, &ENTRY_MILITARIZATIONS_7705734301801515430)],
        &[(0b01001, &ENTRY_MILITARIZE_9495798303128415382)],
        &[(0b01001, &ENTRY_MILITARIZED_16232436267971009706)],
        &[(0b01001, &ENTRY_MILITARIZES_14452269897116904753)],
        &[(0b01001, &ENTRY_MILITARIZING_554769254101207928)],
        &[(0b11010, &ENTRY_MILLIGRAM_13513186363380334269)],
        &[(0b11010, &ENTRY_MILLIGRAMS_1518179305136992377)],
        &[(0b00001, &ENTRY_MILLILITER_4334261634926370944)],
        &[(0b00001, &ENTRY_MILLILITERS_11102962851052563190)],
        &[(0b11010, &ENTRY_MILLILITER_4334261634926370944)],
        &[(0b11010, &ENTRY_MILLILITERS_11102962851052563190)],
        &[(0b01001, &ENTRY_MILLIMETER_910141945772637554)],
        &[(0b01001, &ENTRY_MILLIMETERS_15997711111545097679)],
        &[(0b11010, &ENTRY_MILLIMETER_910141945772637554)],
        &[(0b11010, &ENTRY_MILLIMETERS_15997711111545097679)],
    ],
    range: 7..=12,
};

static VARS_MIC_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_MIC_CHILDREN),
    value: None,
};

pub static VARS_MIC_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("rometre"),
        dictgen::InsensitiveAscii("rometres"),
        dictgen::InsensitiveAscii("rominiaturisation"),
        dictgen::InsensitiveAscii("rominiaturisations"),
        dictgen::InsensitiveAscii("rominiaturization"),
        dictgen::InsensitiveAscii("rominiaturizations"),
    ],
    values: &[
        &[(0b11010, &ENTRY_MICROMETER_12426531854552032888)],
        &[(0b11010, &ENTRY_MICROMETERS_17594798746021449366)],
        &[(0b10010, &ENTRY_MICROMINIATURIZATION_11811432514999527166)],
        &[(0b10010, &ENTRY_MICROMINIATURIZATIONS_5246749790513836150)],
        &[(0b01001, &ENTRY_MICROMINIATURIZATION_11811432514999527166)],
        &[(0b01001, &ENTRY_MICROMINIATURIZATIONS_5246749790513836150)],
    ],
    range: 7..=18,
};

static VARS_MIA_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_MIA_CHILDREN),
    value: None,
};

pub static VARS_MIA_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ow"),
        dictgen::InsensitiveAscii("owed"),
        dictgen::InsensitiveAscii("owing"),
        dictgen::InsensitiveAscii("ows"),
    ],
    values: &[
        &[(0b10011, &ENTRY_MEOW_9410098915523682519)],
        &[(0b10011, &ENTRY_MEOWED_12917082202071017756)],
        &[(0b10011, &ENTRY_MEOWING_14461347911601242891)],
        &[(0b10011, &ENTRY_MEOWS_2381455287142978475)],
    ],
    range: 2..=5,
};

static VARS_ME_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_ME_CHILDREN),
    value: None,
};

static VARS_ME_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_MEA_NODE),
    None,
    Some(&VARS_MEC_NODE),
    Some(&VARS_MED_NODE),
    None,
    None,
    Some(&VARS_MEG_NODE),
    None,
    None,
    None,
    None,
    Some(&VARS_MEL_NODE),
    Some(&VARS_MEM_NODE),
    Some(&VARS_MEN_NODE),
    None,
    None,
    None,
    Some(&VARS_MER_NODE),
    Some(&VARS_MES_NODE),
    Some(&VARS_MET_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_MET_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_MET_CHILDREN),
    value: None,
};

pub static VARS_MET_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("abolisable"),
        dictgen::InsensitiveAscii("abolisables"),
        dictgen::InsensitiveAscii("abolise"),
        dictgen::InsensitiveAscii("abolised"),
        dictgen::InsensitiveAscii("abolises"),
        dictgen::InsensitiveAscii("abolising"),
        dictgen::InsensitiveAscii("abolizable"),
        dictgen::InsensitiveAscii("abolizables"),
        dictgen::InsensitiveAscii("abolize"),
        dictgen::InsensitiveAscii("abolized"),
        dictgen::InsensitiveAscii("abolizes"),
        dictgen::InsensitiveAscii("abolizing"),
        dictgen::InsensitiveAscii("acenter"),
        dictgen::InsensitiveAscii("acenters"),
        dictgen::InsensitiveAscii("acentre"),
        dictgen::InsensitiveAscii("acentres"),
        dictgen::InsensitiveAscii("aled"),
        dictgen::InsensitiveAscii("aling"),
        dictgen::InsensitiveAscii("alization"),
        dictgen::InsensitiveAscii("alizations"),
        dictgen::InsensitiveAscii("alize"),
        dictgen::InsensitiveAscii("alized"),
        dictgen::InsensitiveAscii("alizes"),
        dictgen::InsensitiveAscii("alizing"),
        dictgen::InsensitiveAscii("alled"),
        dictgen::InsensitiveAscii("alling"),
        dictgen::InsensitiveAscii("allisation"),
        dictgen::InsensitiveAscii("allisations"),
        dictgen::InsensitiveAscii("allise"),
        dictgen::InsensitiveAscii("allised"),
        dictgen::InsensitiveAscii("allises"),
        dictgen::InsensitiveAscii("allising"),
        dictgen::InsensitiveAscii("allization"),
        dictgen::InsensitiveAscii("allizations"),
        dictgen::InsensitiveAscii("allize"),
        dictgen::InsensitiveAscii("allized"),
        dictgen::InsensitiveAscii("allizes"),
        dictgen::InsensitiveAscii("allizing"),
        dictgen::InsensitiveAscii("astasise"),
        dictgen::InsensitiveAscii("astasised"),
        dictgen::InsensitiveAscii("astasises"),
        dictgen::InsensitiveAscii("astasising"),
        dictgen::InsensitiveAscii("astasize"),
        dictgen::InsensitiveAscii("astasized"),
        dictgen::InsensitiveAscii("astasizes"),
        dictgen::InsensitiveAscii("astasizing"),
        dictgen::InsensitiveAscii("re"),
        dictgen::InsensitiveAscii("res"),
    ],
    values: &[
        &[(0b10010, &ENTRY_METABOLIZABLE_9512483414343288081)],
        &[(0b10010, &ENTRY_METABOLIZABLES_16212828364863118123)],
        &[(0b10010, &ENTRY_METABOLIZE_5263729176482445241)],
        &[(0b10010, &ENTRY_METABOLIZED_894424192524670370)],
        &[(0b10010, &ENTRY_METABOLIZES_2735479621970518981)],
        &[(0b10010, &ENTRY_METABOLIZING_8339637372408897948)],
        &[(0b01001, &ENTRY_METABOLIZABLE_9512483414343288081)],
        &[(0b01001, &ENTRY_METABOLIZABLES_16212828364863118123)],
        &[(0b01001, &ENTRY_METABOLIZE_5263729176482445241)],
        &[(0b01001, &ENTRY_METABOLIZED_894424192524670370)],
        &[(0b01001, &ENTRY_METABOLIZES_2735479621970518981)],
        &[(0b01001, &ENTRY_METABOLIZING_8339637372408897948)],
        &[(0b00001, &ENTRY_METACENTER_16724078749924963707)],
        &[(0b00001, &ENTRY_METACENTERS_5577639685165206381)],
        &[(0b11010, &ENTRY_METACENTER_16724078749924963707)],
        &[(0b11010, &ENTRY_METACENTERS_5577639685165206381)],
        &[(0b01001, &ENTRY_METALED_9553049451671231773)],
        &[(0b01001, &ENTRY_METALING_15686558716068715897)],
        &[(0b00001, &ENTRY_METALIZATION_98135509290292258)],
        &[(0b00001, &ENTRY_METALIZATIONS_6695845103746956826)],
        &[(0b00001, &ENTRY_METALIZE_16814796087793133597)],
        &[(0b00001, &ENTRY_METALIZED_15261403894302784256)],
        &[(0b00001, &ENTRY_METALIZES_10341894663346117437)],
        &[(0b00001, &ENTRY_METALIZING_496172402873116442)],
        &[(0b11010, &ENTRY_METALED_9553049451671231773)],
        &[(0b11010, &ENTRY_METALING_15686558716068715897)],
        &[(0b10010, &ENTRY_METALIZATION_98135509290292258)],
        &[(0b10010, &ENTRY_METALIZATIONS_6695845103746956826)],
        &[(0b10010, &ENTRY_METALIZE_16814796087793133597)],
        &[(0b10010, &ENTRY_METALIZED_15261403894302784256)],
        &[(0b10010, &ENTRY_METALIZES_10341894663346117437)],
        &[(0b10010, &ENTRY_METALIZING_496172402873116442)],
        &[(0b01000, &ENTRY_METALIZATION_98135509290292258)],
        &[(0b01000, &ENTRY_METALIZATIONS_6695845103746956826)],
        &[(0b01000, &ENTRY_METALIZE_16814796087793133597)],
        &[(0b01000, &ENTRY_METALIZED_15261403894302784256)],
        &[(0b01000, &ENTRY_METALIZES_10341894663346117437)],
        &[(0b01000, &ENTRY_METALIZING_496172402873116442)],
        &[(0b10010, &ENTRY_METASTASIZE_5162116501126745804)],
        &[(0b10010, &ENTRY_METASTASIZED_6407966435125605786)],
        &[(0b10010, &ENTRY_METASTASIZES_10123690877213783906)],
        &[(0b10010, &ENTRY_METASTASIZING_6012917817918288983)],
        &[(0b01001, &ENTRY_METASTASIZE_5162116501126745804)],
        &[(0b01001, &ENTRY_METASTASIZED_6407966435125605786)],
        &[(0b01001, &ENTRY_METASTASIZES_10123690877213783906)],
        &[(0b01001, &ENTRY_METASTASIZING_6012917817918288983)],
        &[(0b11010, &ENTRY_METER_3080570475644919217)],
        &[(0b11010, &ENTRY_METERS_1321374795298554236)],
    ],
    range: 2..=11,
};

static VARS_MES_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_MES_CHILDREN),
    value: None,
};

pub static VARS_MES_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("merise"),
        dictgen::InsensitiveAscii("merised"),
        dictgen::InsensitiveAscii("merises"),
        dictgen::InsensitiveAscii("merising"),
        dictgen::InsensitiveAscii("merize"),
        dictgen::InsensitiveAscii("merized"),
        dictgen::InsensitiveAscii("merizes"),
        dictgen::InsensitiveAscii("merizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_MESMERIZE_5317367348452378793)],
        &[(0b10010, &ENTRY_MESMERIZED_16433180714453641642)],
        &[(0b10010, &ENTRY_MESMERIZES_16069764006210185557)],
        &[(0b10010, &ENTRY_MESMERIZING_10029307437868883072)],
        &[(0b01001, &ENTRY_MESMERIZE_5317367348452378793)],
        &[(0b01001, &ENTRY_MESMERIZED_16433180714453641642)],
        &[(0b01001, &ENTRY_MESMERIZES_16069764006210185557)],
        &[(0b01001, &ENTRY_MESMERIZING_10029307437868883072)],
    ],
    range: 6..=8,
};

static VARS_MER_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_MER_CHILDREN),
    value: None,
};

pub static VARS_MER_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("cerise"),
        dictgen::InsensitiveAscii("cerised"),
        dictgen::InsensitiveAscii("cerises"),
        dictgen::InsensitiveAscii("cerising"),
        dictgen::InsensitiveAscii("cerize"),
        dictgen::InsensitiveAscii("cerized"),
        dictgen::InsensitiveAscii("cerizes"),
        dictgen::InsensitiveAscii("cerizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_MERCERIZE_10358461438508840539)],
        &[(0b10010, &ENTRY_MERCERIZED_6026301924133596159)],
        &[(0b10010, &ENTRY_MERCERIZES_14867805097673002748)],
        &[(0b10010, &ENTRY_MERCERIZING_15719429984314868087)],
        &[(0b01001, &ENTRY_MERCERIZE_10358461438508840539)],
        &[(0b01001, &ENTRY_MERCERIZED_6026301924133596159)],
        &[(0b01001, &ENTRY_MERCERIZES_14867805097673002748)],
        &[(0b01001, &ENTRY_MERCERIZING_15719429984314868087)],
    ],
    range: 6..=8,
};

static VARS_MEN_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_MEN_CHILDREN),
    value: None,
};

pub static VARS_MEN_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ad"),
        dictgen::InsensitiveAscii("adic"),
        dictgen::InsensitiveAscii("ads"),
    ],
    values: &[
        &[(0b00001, &ENTRY_MAENAD_17014549470545688439)],
        &[(0b00001, &ENTRY_MAENADIC_10391457552203438714)],
        &[(0b00001, &ENTRY_MAENADS_16301310937820360625)],
    ],
    range: 2..=4,
};

static VARS_MEM_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_MEM_CHILDREN),
    value: None,
};

pub static VARS_MEM_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("orialise"),
        dictgen::InsensitiveAscii("orialised"),
        dictgen::InsensitiveAscii("orialises"),
        dictgen::InsensitiveAscii("orialising"),
        dictgen::InsensitiveAscii("orialize"),
        dictgen::InsensitiveAscii("orialized"),
        dictgen::InsensitiveAscii("orializes"),
        dictgen::InsensitiveAscii("orializing"),
        dictgen::InsensitiveAscii("orisation"),
        dictgen::InsensitiveAscii("orisations"),
        dictgen::InsensitiveAscii("orise"),
        dictgen::InsensitiveAscii("orised"),
        dictgen::InsensitiveAscii("oriser"),
        dictgen::InsensitiveAscii("orisers"),
        dictgen::InsensitiveAscii("orises"),
        dictgen::InsensitiveAscii("orising"),
        dictgen::InsensitiveAscii("orization"),
        dictgen::InsensitiveAscii("orizations"),
        dictgen::InsensitiveAscii("orize"),
        dictgen::InsensitiveAscii("orized"),
        dictgen::InsensitiveAscii("orizer"),
        dictgen::InsensitiveAscii("orizers"),
        dictgen::InsensitiveAscii("orizes"),
        dictgen::InsensitiveAscii("orizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_MEMORIALIZE_1075532353319465636)],
        &[(0b10010, &ENTRY_MEMORIALIZED_12387502526621019454)],
        &[(0b10010, &ENTRY_MEMORIALIZES_6025600930549122809)],
        &[(0b10010, &ENTRY_MEMORIALIZING_6464676930179799173)],
        &[(0b01001, &ENTRY_MEMORIALIZE_1075532353319465636)],
        &[(0b01001, &ENTRY_MEMORIALIZED_12387502526621019454)],
        &[(0b01001, &ENTRY_MEMORIALIZES_6025600930549122809)],
        &[(0b01001, &ENTRY_MEMORIALIZING_6464676930179799173)],
        &[(0b10010, &ENTRY_MEMORIZATION_9905762212081933855)],
        &[(0b10010, &ENTRY_MEMORIZATIONS_9230505688495133407)],
        &[(0b10010, &ENTRY_MEMORIZE_12947638813038433309)],
        &[(0b10010, &ENTRY_MEMORIZED_6819787376078494141)],
        &[(0b10010, &ENTRY_MEMORIZER_17044084127009102585)],
        &[(0b10010, &ENTRY_MEMORIZERS_1062747053394007451)],
        &[(0b10010, &ENTRY_MEMORIZES_5171178815680156610)],
        &[(0b10010, &ENTRY_MEMORIZING_3818508847656258506)],
        &[(0b01001, &ENTRY_MEMORIZATION_9905762212081933855)],
        &[(0b01001, &ENTRY_MEMORIZATIONS_9230505688495133407)],
        &[(0b01001, &ENTRY_MEMORIZE_12947638813038433309)],
        &[(0b01001, &ENTRY_MEMORIZED_6819787376078494141)],
        &[(0b01001, &ENTRY_MEMORIZER_17044084127009102585)],
        &[(0b01001, &ENTRY_MEMORIZERS_1062747053394007451)],
        &[(0b01001, &ENTRY_MEMORIZES_5171178815680156610)],
        &[(0b01001, &ENTRY_MEMORIZING_3818508847656258506)],
    ],
    range: 5..=10,
};

static VARS_MEL_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_MEL_CHILDREN),
    value: None,
};

pub static VARS_MEL_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("odise"),
        dictgen::InsensitiveAscii("odised"),
        dictgen::InsensitiveAscii("odises"),
        dictgen::InsensitiveAscii("odising"),
        dictgen::InsensitiveAscii("odize"),
        dictgen::InsensitiveAscii("odized"),
        dictgen::InsensitiveAscii("odizes"),
        dictgen::InsensitiveAscii("odizing"),
        dictgen::InsensitiveAscii("odramatise"),
        dictgen::InsensitiveAscii("odramatised"),
        dictgen::InsensitiveAscii("odramatises"),
        dictgen::InsensitiveAscii("odramatising"),
        dictgen::InsensitiveAscii("odramatize"),
        dictgen::InsensitiveAscii("odramatized"),
        dictgen::InsensitiveAscii("odramatizes"),
        dictgen::InsensitiveAscii("odramatizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_MELODIZE_7912016393930350549)],
        &[(0b10010, &ENTRY_MELODIZED_3082275023028261392)],
        &[(0b10010, &ENTRY_MELODIZES_2517544335598130476)],
        &[(0b10010, &ENTRY_MELODIZING_6937142596752062613)],
        &[(0b01001, &ENTRY_MELODIZE_7912016393930350549)],
        &[(0b01001, &ENTRY_MELODIZED_3082275023028261392)],
        &[(0b01001, &ENTRY_MELODIZES_2517544335598130476)],
        &[(0b01001, &ENTRY_MELODIZING_6937142596752062613)],
        &[(0b10010, &ENTRY_MELODRAMATIZE_8158763736750286482)],
        &[(0b10010, &ENTRY_MELODRAMATIZED_8147783138457416369)],
        &[(0b10010, &ENTRY_MELODRAMATIZES_13654098972815682124)],
        &[(0b10010, &ENTRY_MELODRAMATIZING_8357301537520359496)],
        &[(0b01001, &ENTRY_MELODRAMATIZE_8158763736750286482)],
        &[(0b01001, &ENTRY_MELODRAMATIZED_8147783138457416369)],
        &[(0b01001, &ENTRY_MELODRAMATIZES_13654098972815682124)],
        &[(0b01001, &ENTRY_MELODRAMATIZING_8357301537520359496)],
    ],
    range: 5..=12,
};

static VARS_MEG_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_MEG_CHILDREN),
    value: None,
};

pub static VARS_MEG_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("agramme"),
        dictgen::InsensitiveAscii("agrammes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_MEGAGRAM_8029617688198245061)],
        &[(0b10010, &ENTRY_MEGAGRAMS_16983511226700950884)],
    ],
    range: 7..=8,
};

static VARS_MED_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_MED_CHILDREN),
    value: None,
};

pub static VARS_MED_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("alist"),
        dictgen::InsensitiveAscii("alists"),
        dictgen::InsensitiveAscii("allist"),
        dictgen::InsensitiveAscii("allists"),
        dictgen::InsensitiveAscii("iaeval"),
        dictgen::InsensitiveAscii("iaevals"),
    ],
    values: &[
        &[(0b00001, &ENTRY_MEDALIST_17015107528020299327)],
        &[(0b00001, &ENTRY_MEDALISTS_7569600200481823699)],
        &[(0b11010, &ENTRY_MEDALIST_17015107528020299327)],
        &[(0b11010, &ENTRY_MEDALISTS_7569600200481823699)],
        &[(0b10011, &ENTRY_MEDIEVAL_17850117342556318282)],
        &[(0b10011, &ENTRY_MEDIEVALS_565656105957485309)],
    ],
    range: 5..=7,
};

static VARS_MEC_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_MEC_CHILDREN),
    value: None,
};

pub static VARS_MEC_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("hanisation"),
        dictgen::InsensitiveAscii("hanisations"),
        dictgen::InsensitiveAscii("hanise"),
        dictgen::InsensitiveAscii("hanised"),
        dictgen::InsensitiveAscii("haniser"),
        dictgen::InsensitiveAscii("hanisers"),
        dictgen::InsensitiveAscii("hanises"),
        dictgen::InsensitiveAscii("hanising"),
        dictgen::InsensitiveAscii("hanization"),
        dictgen::InsensitiveAscii("hanizations"),
        dictgen::InsensitiveAscii("hanize"),
        dictgen::InsensitiveAscii("hanized"),
        dictgen::InsensitiveAscii("hanizer"),
        dictgen::InsensitiveAscii("hanizers"),
        dictgen::InsensitiveAscii("hanizes"),
        dictgen::InsensitiveAscii("hanizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_MECHANIZATION_1053035171790140063)],
        &[(0b10010, &ENTRY_MECHANIZATIONS_14663166362277345847)],
        &[(0b10010, &ENTRY_MECHANIZE_16535652198395559730)],
        &[(0b10010, &ENTRY_MECHANIZED_9673871810101964259)],
        &[(0b10010, &ENTRY_MECHANIZER_3254719858646223585)],
        &[(0b10010, &ENTRY_MECHANIZERS_14840837706803972436)],
        &[(0b10010, &ENTRY_MECHANIZES_7811802180133123379)],
        &[(0b10010, &ENTRY_MECHANIZING_15860356773348186437)],
        &[(0b01001, &ENTRY_MECHANIZATION_1053035171790140063)],
        &[(0b01001, &ENTRY_MECHANIZATIONS_14663166362277345847)],
        &[(0b01001, &ENTRY_MECHANIZE_16535652198395559730)],
        &[(0b01001, &ENTRY_MECHANIZED_9673871810101964259)],
        &[(0b01001, &ENTRY_MECHANIZER_3254719858646223585)],
        &[(0b01001, &ENTRY_MECHANIZERS_14840837706803972436)],
        &[(0b01001, &ENTRY_MECHANIZES_7811802180133123379)],
        &[(0b01001, &ENTRY_MECHANIZING_15860356773348186437)],
    ],
    range: 6..=11,
};

static VARS_MEA_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_MEA_CHILDREN),
    value: None,
};

pub static VARS_MEA_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ger"),
        dictgen::InsensitiveAscii("gerrer"),
        dictgen::InsensitiveAscii("gerrest"),
        dictgen::InsensitiveAscii("gre"),
        dictgen::InsensitiveAscii("grer"),
        dictgen::InsensitiveAscii("grest"),
    ],
    values: &[
        &[(0b01001, &ENTRY_MEAGER_16437138915349494155)],
        &[(0b01001, &ENTRY_MEAGERRER_16342562731232285770)],
        &[(0b01001, &ENTRY_MEAGERREST_10155328827598626356)],
        &[(0b11010, &ENTRY_MEAGER_16437138915349494155)],
        &[(0b11010, &ENTRY_MEAGERRER_16342562731232285770)],
        &[(0b11010, &ENTRY_MEAGERREST_10155328827598626356)],
    ],
    range: 3..=7,
};

static VARS_MA_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_MA_CHILDREN),
    value: None,
};

static VARS_MA_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_MAG_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_MAN_NODE),
    None,
    None,
    None,
    Some(&VARS_MAR_NODE),
    None,
    Some(&VARS_MAT_NODE),
    None,
    None,
    None,
    Some(&VARS_MAX_NODE),
    None,
    None,
];

static VARS_MAX_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_MAX_CHILDREN),
    value: None,
};

pub static VARS_MAX_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("imisation"),
        dictgen::InsensitiveAscii("imisations"),
        dictgen::InsensitiveAscii("imise"),
        dictgen::InsensitiveAscii("imised"),
        dictgen::InsensitiveAscii("imiser"),
        dictgen::InsensitiveAscii("imisers"),
        dictgen::InsensitiveAscii("imises"),
        dictgen::InsensitiveAscii("imising"),
        dictgen::InsensitiveAscii("imization"),
        dictgen::InsensitiveAscii("imizations"),
        dictgen::InsensitiveAscii("imize"),
        dictgen::InsensitiveAscii("imized"),
        dictgen::InsensitiveAscii("imizer"),
        dictgen::InsensitiveAscii("imizers"),
        dictgen::InsensitiveAscii("imizes"),
        dictgen::InsensitiveAscii("imizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_MAXIMIZATION_3582457980210831801)],
        &[(0b10010, &ENTRY_MAXIMIZATIONS_17498251387785973609)],
        &[(0b10010, &ENTRY_MAXIMIZE_3031872585153948954)],
        &[(0b10010, &ENTRY_MAXIMIZED_18322342409602816855)],
        &[(0b10010, &ENTRY_MAXIMIZER_7689755575199270297)],
        &[(0b10010, &ENTRY_MAXIMIZERS_9246458667812951153)],
        &[(0b10010, &ENTRY_MAXIMIZES_8121680605285929508)],
        &[(0b10010, &ENTRY_MAXIMIZING_944961283075648715)],
        &[(0b01001, &ENTRY_MAXIMIZATION_3582457980210831801)],
        &[(0b01001, &ENTRY_MAXIMIZATIONS_17498251387785973609)],
        &[(0b01001, &ENTRY_MAXIMIZE_3031872585153948954)],
        &[(0b01001, &ENTRY_MAXIMIZED_18322342409602816855)],
        &[(0b01001, &ENTRY_MAXIMIZER_7689755575199270297)],
        &[(0b01001, &ENTRY_MAXIMIZERS_9246458667812951153)],
        &[(0b01001, &ENTRY_MAXIMIZES_8121680605285929508)],
        &[(0b01001, &ENTRY_MAXIMIZING_944961283075648715)],
    ],
    range: 5..=10,
};

static VARS_MAT_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_MAT_CHILDREN),
    value: None,
};

pub static VARS_MAT_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("erialisation"),
        dictgen::InsensitiveAscii("erialisations"),
        dictgen::InsensitiveAscii("erialise"),
        dictgen::InsensitiveAscii("erialised"),
        dictgen::InsensitiveAscii("erialises"),
        dictgen::InsensitiveAscii("erialising"),
        dictgen::InsensitiveAscii("erialization"),
        dictgen::InsensitiveAscii("erializations"),
        dictgen::InsensitiveAscii("erialize"),
        dictgen::InsensitiveAscii("erialized"),
        dictgen::InsensitiveAscii("erializes"),
        dictgen::InsensitiveAscii("erializing"),
        dictgen::InsensitiveAscii("ts"),
    ],
    values: &[
        &[(0b10010, &ENTRY_MATERIALIZATION_15275246538418004637)],
        &[(0b10010, &ENTRY_MATERIALIZATIONS_2652185200878385871)],
        &[(0b10010, &ENTRY_MATERIALIZE_751513275282658322)],
        &[(0b10010, &ENTRY_MATERIALIZED_12794251805380683570)],
        &[(0b10010, &ENTRY_MATERIALIZES_1701928859160069487)],
        &[(0b10010, &ENTRY_MATERIALIZING_12202103934838377179)],
        &[(0b01001, &ENTRY_MATERIALIZATION_15275246538418004637)],
        &[(0b01001, &ENTRY_MATERIALIZATIONS_2652185200878385871)],
        &[(0b01001, &ENTRY_MATERIALIZE_751513275282658322)],
        &[(0b01001, &ENTRY_MATERIALIZED_12794251805380683570)],
        &[(0b01001, &ENTRY_MATERIALIZES_1701928859160069487)],
        &[(0b01001, &ENTRY_MATERIALIZING_12202103934838377179)],
        &[(0b10011, &ENTRY_MATS_9238000290813577978)],
    ],
    range: 2..=13,
};

static VARS_MAR_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_MAR_CHILDREN),
    value: None,
};

pub static VARS_MAR_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("bleise"),
        dictgen::InsensitiveAscii("bleised"),
        dictgen::InsensitiveAscii("bleises"),
        dictgen::InsensitiveAscii("bleising"),
        dictgen::InsensitiveAscii("bleize"),
        dictgen::InsensitiveAscii("bleized"),
        dictgen::InsensitiveAscii("bleizes"),
        dictgen::InsensitiveAscii("bleizing"),
        dictgen::InsensitiveAscii("ginalisation"),
        dictgen::InsensitiveAscii("ginalise"),
        dictgen::InsensitiveAscii("ginalised"),
        dictgen::InsensitiveAscii("ginalises"),
        dictgen::InsensitiveAscii("ginalising"),
        dictgen::InsensitiveAscii("ginalization"),
        dictgen::InsensitiveAscii("ginalize"),
        dictgen::InsensitiveAscii("ginalized"),
        dictgen::InsensitiveAscii("ginalizes"),
        dictgen::InsensitiveAscii("ginalizing"),
        dictgen::InsensitiveAscii("shaled"),
        dictgen::InsensitiveAscii("shaling"),
        dictgen::InsensitiveAscii("shalled"),
        dictgen::InsensitiveAscii("shalling"),
        dictgen::InsensitiveAscii("veled"),
        dictgen::InsensitiveAscii("veling"),
        dictgen::InsensitiveAscii("velled"),
        dictgen::InsensitiveAscii("velling"),
        dictgen::InsensitiveAscii("vellous"),
        dictgen::InsensitiveAscii("vellouser"),
        dictgen::InsensitiveAscii("vellousest"),
        dictgen::InsensitiveAscii("vellouslier"),
        dictgen::InsensitiveAscii("vellousliest"),
        dictgen::InsensitiveAscii("vellously"),
        dictgen::InsensitiveAscii("vellousness"),
        dictgen::InsensitiveAscii("vellousnesses"),
        dictgen::InsensitiveAscii("velous"),
        dictgen::InsensitiveAscii("velouser"),
        dictgen::InsensitiveAscii("velousest"),
        dictgen::InsensitiveAscii("velouslier"),
        dictgen::InsensitiveAscii("velousliest"),
        dictgen::InsensitiveAscii("velously"),
        dictgen::InsensitiveAscii("velousness"),
        dictgen::InsensitiveAscii("velousnesses"),
    ],
    values: &[
        &[(0b10010, &ENTRY_MARBLEIZE_1587151371458840015)],
        &[(0b10010, &ENTRY_MARBLEIZED_9909511827189901753)],
        &[(0b10010, &ENTRY_MARBLEIZES_13333904138730712912)],
        &[(0b10010, &ENTRY_MARBLEIZING_4602625009210891897)],
        &[(0b01001, &ENTRY_MARBLEIZE_1587151371458840015)],
        &[(0b01001, &ENTRY_MARBLEIZED_9909511827189901753)],
        &[(0b01001, &ENTRY_MARBLEIZES_13333904138730712912)],
        &[(0b01001, &ENTRY_MARBLEIZING_4602625009210891897)],
        &[(0b10010, &ENTRY_MARGINALIZATION_845141011968765477)],
        &[(0b10010, &ENTRY_MARGINALIZE_3216468021553056827)],
        &[(0b10010, &ENTRY_MARGINALIZED_7354157641651435628)],
        &[(0b10010, &ENTRY_MARGINALIZES_2216379754364106454)],
        &[(0b10010, &ENTRY_MARGINALIZING_14750515117536904615)],
        &[(0b01001, &ENTRY_MARGINALIZATION_845141011968765477)],
        &[(0b01001, &ENTRY_MARGINALIZE_3216468021553056827)],
        &[(0b01001, &ENTRY_MARGINALIZED_7354157641651435628)],
        &[(0b01001, &ENTRY_MARGINALIZES_2216379754364106454)],
        &[(0b01001, &ENTRY_MARGINALIZING_14750515117536904615)],
        &[(0b00001, &ENTRY_MARSHALED_17388940496017695622)],
        &[(0b00001, &ENTRY_MARSHALING_14317227469213788602)],
        &[(0b11010, &ENTRY_MARSHALED_17388940496017695622)],
        &[(0b11010, &ENTRY_MARSHALING_14317227469213788602)],
        &[(0b00001, &ENTRY_MARVELED_7643699015465825056)],
        &[(0b00001, &ENTRY_MARVELING_1354065551177639579)],
        &[(0b11010, &ENTRY_MARVELED_7643699015465825056)],
        &[(0b11010, &ENTRY_MARVELING_1354065551177639579)],
        &[(0b11010, &ENTRY_MARVELOUS_82637440345212214)],
        &[(0b11010, &ENTRY_MARVELOUSER_7705396939137168592)],
        &[(0b11010, &ENTRY_MARVELOUSEST_912599784216442683)],
        &[(0b11010, &ENTRY_MARVELOUSLIER_12811886966499643595)],
        &[(0b11010, &ENTRY_MARVELOUSLIEST_16737159169599622279)],
        &[(0b11010, &ENTRY_MARVELOUSLY_18213355249698171803)],
        &[(0b11010, &ENTRY_MARVELOUSNESS_15500940188234401273)],
        &[(0b11010, &ENTRY_MARVELOUSNESSES_8865126466913012309)],
        &[(0b00001, &ENTRY_MARVELOUS_82637440345212214)],
        &[(0b00001, &ENTRY_MARVELOUSER_7705396939137168592)],
        &[(0b00001, &ENTRY_MARVELOUSEST_912599784216442683)],
        &[(0b00001, &ENTRY_MARVELOUSLIER_12811886966499643595)],
        &[(0b00001, &ENTRY_MARVELOUSLIEST_16737159169599622279)],
        &[(0b00001, &ENTRY_MARVELOUSLY_18213355249698171803)],
        &[(0b00001, &ENTRY_MARVELOUSNESS_15500940188234401273)],
        &[(0b00001, &ENTRY_MARVELOUSNESSES_8865126466913012309)],
    ],
    range: 5..=13,
};

static VARS_MAN_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_MAN_CHILDREN),
    value: None,
};

pub static VARS_MAN_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("daean"),
        dictgen::InsensitiveAscii("daeans"),
        dictgen::InsensitiveAscii("dean"),
        dictgen::InsensitiveAscii("deans"),
        dictgen::InsensitiveAscii("euver"),
        dictgen::InsensitiveAscii("euverabilities"),
        dictgen::InsensitiveAscii("euverability"),
        dictgen::InsensitiveAscii("euverable"),
        dictgen::InsensitiveAscii("euverabler"),
        dictgen::InsensitiveAscii("euverablest"),
        dictgen::InsensitiveAscii("euvered"),
        dictgen::InsensitiveAscii("euverer"),
        dictgen::InsensitiveAscii("euverers"),
        dictgen::InsensitiveAscii("euvering"),
        dictgen::InsensitiveAscii("euverings"),
        dictgen::InsensitiveAscii("euvers"),
        dictgen::InsensitiveAscii("ichaeism"),
        dictgen::InsensitiveAscii("ichaeisms"),
        dictgen::InsensitiveAscii("oeuver"),
        dictgen::InsensitiveAscii("oeuvered"),
        dictgen::InsensitiveAscii("oeuvering"),
        dictgen::InsensitiveAscii("oeuverings"),
        dictgen::InsensitiveAscii("oeuvers"),
        dictgen::InsensitiveAscii("oeuvrabilities"),
        dictgen::InsensitiveAscii("oeuvrability"),
        dictgen::InsensitiveAscii("oeuvrable"),
        dictgen::InsensitiveAscii("oeuvrabler"),
        dictgen::InsensitiveAscii("oeuvrablest"),
        dictgen::InsensitiveAscii("oeuvre"),
        dictgen::InsensitiveAscii("oeuvred"),
        dictgen::InsensitiveAscii("oeuvrer"),
        dictgen::InsensitiveAscii("oeuvrers"),
        dictgen::InsensitiveAscii("oeuvres"),
        dictgen::InsensitiveAscii("oeuvring"),
        dictgen::InsensitiveAscii("oeuvrings"),
    ],
    values: &[
        &[(0b11010, &ENTRY_MANDEAN_16756153629008001222)],
        &[(0b11010, &ENTRY_MANDEANS_6139983685022239651)],
        &[(0b10011, &ENTRY_MANDEAN_16756153629008001222)],
        &[(0b10011, &ENTRY_MANDEANS_6139983685022239651)],
        &[(0b01001, &ENTRY_MANEUVER_2827757268422810275)],
        &[(0b00001, &ENTRY_MANEUVERABILITIES_1191935897985178601)],
        &[(0b00001, &ENTRY_MANEUVERABILITY_13828505830247153454)],
        &[(0b00001, &ENTRY_MANEUVERABLE_15149317836898965786)],
        &[(0b00001, &ENTRY_MANEUVERABLER_8453360608082720316)],
        &[(0b00001, &ENTRY_MANEUVERABLEST_9950206171061443172)],
        &[(0b01001, &ENTRY_MANEUVERED_1283956380608823667)],
        &[(0b00001, &ENTRY_MANEUVERER_16909121286634766647)],
        &[(0b00001, &ENTRY_MANEUVERERS_16918168302778575325)],
        &[(0b01001, &ENTRY_MANEUVERING_7486833768050311559)],
        &[(0b01001, &ENTRY_MANEUVERINGS_15820076380390390309)],
        &[(0b01001, &ENTRY_MANEUVERS_11853919997692060327)],
        &[(0b11010, &ENTRY_MANICHEISM_13987531657185741850)],
        &[(0b11010, &ENTRY_MANICHEISMS_4550426137129529134)],
        &[(0b01000, &ENTRY_MANEUVER_2827757268422810275)],
        &[(0b01000, &ENTRY_MANEUVERED_1283956380608823667)],
        &[(0b01000, &ENTRY_MANEUVERING_7486833768050311559)],
        &[(0b01000, &ENTRY_MANEUVERINGS_15820076380390390309)],
        &[(0b01000, &ENTRY_MANEUVERS_11853919997692060327)],
        &[(0b11010, &ENTRY_MANEUVERABILITIES_1191935897985178601)],
        &[(0b11010, &ENTRY_MANEUVERABILITY_13828505830247153454)],
        &[(0b11010, &ENTRY_MANEUVERABLE_15149317836898965786)],
        &[(0b11010, &ENTRY_MANEUVERABLER_8453360608082720316)],
        &[(0b11010, &ENTRY_MANEUVERABLEST_9950206171061443172)],
        &[(0b11010, &ENTRY_MANEUVER_2827757268422810275)],
        &[(0b11010, &ENTRY_MANEUVERED_1283956380608823667)],
        &[(0b11010, &ENTRY_MANEUVERER_16909121286634766647)],
        &[(0b11010, &ENTRY_MANEUVERERS_16918168302778575325)],
        &[(0b11010, &ENTRY_MANEUVERS_11853919997692060327)],
        &[(0b11010, &ENTRY_MANEUVERING_7486833768050311559)],
        &[(0b11010, &ENTRY_MANEUVERINGS_15820076380390390309)],
    ],
    range: 4..=14,
};

static VARS_MAG_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_MAG_CHILDREN),
    value: None,
};

pub static VARS_MAG_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("netisation"),
        dictgen::InsensitiveAscii("netisations"),
        dictgen::InsensitiveAscii("netise"),
        dictgen::InsensitiveAscii("netised"),
        dictgen::InsensitiveAscii("netises"),
        dictgen::InsensitiveAscii("netising"),
        dictgen::InsensitiveAscii("netization"),
        dictgen::InsensitiveAscii("netizations"),
        dictgen::InsensitiveAscii("netize"),
        dictgen::InsensitiveAscii("netized"),
        dictgen::InsensitiveAscii("netizes"),
        dictgen::InsensitiveAscii("netizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_MAGNETIZATION_9483881663837891030)],
        &[(0b10010, &ENTRY_MAGNETIZATIONS_4200667569204648331)],
        &[(0b10010, &ENTRY_MAGNETIZE_17032040585995329794)],
        &[(0b10010, &ENTRY_MAGNETIZED_12485429316868328420)],
        &[(0b10010, &ENTRY_MAGNETIZES_15356358395494315006)],
        &[(0b10010, &ENTRY_MAGNETIZING_16368507504957955556)],
        &[(0b01001, &ENTRY_MAGNETIZATION_9483881663837891030)],
        &[(0b01001, &ENTRY_MAGNETIZATIONS_4200667569204648331)],
        &[(0b01001, &ENTRY_MAGNETIZE_17032040585995329794)],
        &[(0b01001, &ENTRY_MAGNETIZED_12485429316868328420)],
        &[(0b01001, &ENTRY_MAGNETIZES_15356358395494315006)],
        &[(0b01001, &ENTRY_MAGNETIZING_16368507504957955556)],
    ],
    range: 6..=11,
};

static VARS_L_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_L_CHILDREN),
    value: None,
};

static VARS_L_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_LA_NODE),
    None,
    None,
    None,
    Some(&VARS_LE_NODE),
    None,
    None,
    None,
    Some(&VARS_LI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_LO_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_LU_NODE),
    None,
    None,
    None,
    Some(&VARS_LY_NODE),
    None,
];

static VARS_LY_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_LY_CHILDREN),
    value: None,
};

pub static VARS_LY_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ophilisation"),
        dictgen::InsensitiveAscii("ophilisations"),
        dictgen::InsensitiveAscii("ophilise"),
        dictgen::InsensitiveAscii("ophilised"),
        dictgen::InsensitiveAscii("ophilises"),
        dictgen::InsensitiveAscii("ophilising"),
        dictgen::InsensitiveAscii("ophilization"),
        dictgen::InsensitiveAscii("ophilizations"),
        dictgen::InsensitiveAscii("ophilize"),
        dictgen::InsensitiveAscii("ophilized"),
        dictgen::InsensitiveAscii("ophilizes"),
        dictgen::InsensitiveAscii("ophilizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_LYOPHILIZATION_238925001880862200)],
        &[(0b10010, &ENTRY_LYOPHILIZATIONS_11641961854700529778)],
        &[(0b10010, &ENTRY_LYOPHILIZE_17394361786807322599)],
        &[(0b10010, &ENTRY_LYOPHILIZED_12354358301774087178)],
        &[(0b10010, &ENTRY_LYOPHILIZES_10620381546865479198)],
        &[(0b10010, &ENTRY_LYOPHILIZING_854033355703357663)],
        &[(0b01001, &ENTRY_LYOPHILIZATION_238925001880862200)],
        &[(0b01001, &ENTRY_LYOPHILIZATIONS_11641961854700529778)],
        &[(0b01001, &ENTRY_LYOPHILIZE_17394361786807322599)],
        &[(0b01001, &ENTRY_LYOPHILIZED_12354358301774087178)],
        &[(0b01001, &ENTRY_LYOPHILIZES_10620381546865479198)],
        &[(0b01001, &ENTRY_LYOPHILIZING_854033355703357663)],
    ],
    range: 8..=13,
};

static VARS_LU_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_LU_CHILDREN),
    value: None,
};

pub static VARS_LU_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("pines"),
        dictgen::InsensitiveAscii("ster"),
        dictgen::InsensitiveAscii("stered"),
        dictgen::InsensitiveAscii("stering"),
        dictgen::InsensitiveAscii("sterless"),
        dictgen::InsensitiveAscii("sterlesser"),
        dictgen::InsensitiveAscii("sterlessest"),
        dictgen::InsensitiveAscii("sters"),
        dictgen::InsensitiveAscii("sterware"),
        dictgen::InsensitiveAscii("sterwares"),
        dictgen::InsensitiveAscii("streless"),
        dictgen::InsensitiveAscii("strelesser"),
        dictgen::InsensitiveAscii("strelessest"),
        dictgen::InsensitiveAscii("streware"),
        dictgen::InsensitiveAscii("strewares"),
        dictgen::InsensitiveAscii("v"),
        dictgen::InsensitiveAscii("vs"),
    ],
    values: &[
        &[(0b01001, &ENTRY_LUPINES_16622756440390859222)],
        &[(0b00001, &ENTRY_LUSTER_34214050459909607)],
        &[(0b00001, &ENTRY_LUSTERED_11665281529057185042)],
        &[(0b00001, &ENTRY_LUSTERING_8070190029646350099)],
        &[(0b00001, &ENTRY_LUSTERLESS_18388613709739398315)],
        &[(0b00001, &ENTRY_LUSTERLESSER_2845716573356909139)],
        &[(0b00001, &ENTRY_LUSTERLESSEST_5530749287519804822)],
        &[(0b00001, &ENTRY_LUSTERS_15914131236659551229)],
        &[(0b00001, &ENTRY_LUSTERWARE_9411302114705132644)],
        &[(0b00001, &ENTRY_LUSTERWARES_13754816865182407391)],
        &[(0b11010, &ENTRY_LUSTERLESS_18388613709739398315)],
        &[(0b11010, &ENTRY_LUSTERLESSER_2845716573356909139)],
        &[(0b11010, &ENTRY_LUSTERLESSEST_5530749287519804822)],
        &[(0b11010, &ENTRY_LUSTERWARE_9411302114705132644)],
        &[(0b11010, &ENTRY_LUSTERWARES_13754816865182407391)],
        &[(0b00001, &ENTRY_LOVE_17065904044059271019)],
        &[(0b00001, &ENTRY_LOVES_9736395093583352222)],
    ],
    range: 1..=11,
};

static VARS_LO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_LO_CHILDREN),
    value: None,
};

pub static VARS_LO_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("botomise"),
        dictgen::InsensitiveAscii("botomised"),
        dictgen::InsensitiveAscii("botomises"),
        dictgen::InsensitiveAscii("botomising"),
        dictgen::InsensitiveAscii("botomize"),
        dictgen::InsensitiveAscii("botomized"),
        dictgen::InsensitiveAscii("botomizes"),
        dictgen::InsensitiveAscii("botomizing"),
        dictgen::InsensitiveAscii("calisable"),
        dictgen::InsensitiveAscii("calisabler"),
        dictgen::InsensitiveAscii("calisables"),
        dictgen::InsensitiveAscii("calisablest"),
        dictgen::InsensitiveAscii("calisation"),
        dictgen::InsensitiveAscii("calisations"),
        dictgen::InsensitiveAscii("calise"),
        dictgen::InsensitiveAscii("calised"),
        dictgen::InsensitiveAscii("caliser"),
        dictgen::InsensitiveAscii("calisers"),
        dictgen::InsensitiveAscii("calises"),
        dictgen::InsensitiveAscii("calising"),
        dictgen::InsensitiveAscii("calizable"),
        dictgen::InsensitiveAscii("calizabler"),
        dictgen::InsensitiveAscii("calizables"),
        dictgen::InsensitiveAscii("calizablest"),
        dictgen::InsensitiveAscii("calization"),
        dictgen::InsensitiveAscii("calizations"),
        dictgen::InsensitiveAscii("calize"),
        dictgen::InsensitiveAscii("calized"),
        dictgen::InsensitiveAscii("calizer"),
        dictgen::InsensitiveAscii("calizers"),
        dictgen::InsensitiveAscii("calizes"),
        dictgen::InsensitiveAscii("calizing"),
        dictgen::InsensitiveAscii("gorrhea"),
        dictgen::InsensitiveAscii("gorrheas"),
        dictgen::InsensitiveAscii("gorrhoea"),
        dictgen::InsensitiveAscii("gorrhoeas"),
        dictgen::InsensitiveAscii("uver"),
        dictgen::InsensitiveAscii("uvered"),
        dictgen::InsensitiveAscii("uvers"),
        dictgen::InsensitiveAscii("uvre"),
        dictgen::InsensitiveAscii("uvred"),
        dictgen::InsensitiveAscii("uvres"),
        dictgen::InsensitiveAscii("vaebility"),
        dictgen::InsensitiveAscii("veableness"),
        dictgen::InsensitiveAscii("veably"),
    ],
    values: &[
        &[(0b10010, &ENTRY_LOBOTOMIZE_8963885444869982297)],
        &[(0b10010, &ENTRY_LOBOTOMIZED_8233435547170173963)],
        &[(0b10010, &ENTRY_LOBOTOMIZES_12096959998457471825)],
        &[(0b10010, &ENTRY_LOBOTOMIZING_1629157880661707450)],
        &[(0b01001, &ENTRY_LOBOTOMIZE_8963885444869982297)],
        &[(0b01001, &ENTRY_LOBOTOMIZED_8233435547170173963)],
        &[(0b01001, &ENTRY_LOBOTOMIZES_12096959998457471825)],
        &[(0b01001, &ENTRY_LOBOTOMIZING_1629157880661707450)],
        &[(0b10010, &ENTRY_LOCALIZABLE_18184729227341816025)],
        &[(0b10010, &ENTRY_LOCALIZABLER_4472819140531439518)],
        &[(0b10010, &ENTRY_LOCALIZABLES_14485108443499471420)],
        &[(0b10010, &ENTRY_LOCALIZABLEST_6312048620019063505)],
        &[(0b10010, &ENTRY_LOCALIZATION_1714165233158101768)],
        &[(0b10010, &ENTRY_LOCALIZATIONS_10357720798895176938)],
        &[(0b10010, &ENTRY_LOCALIZE_3508370761131546110)],
        &[(0b10010, &ENTRY_LOCALIZED_15436756507414158023)],
        &[(0b10010, &ENTRY_LOCALIZER_12500323668628991619)],
        &[(0b10010, &ENTRY_LOCALIZERS_9928746809280119061)],
        &[(0b10010, &ENTRY_LOCALIZES_128174617828783907)],
        &[(0b10010, &ENTRY_LOCALIZING_919540865361361114)],
        &[(0b01001, &ENTRY_LOCALIZABLE_18184729227341816025)],
        &[(0b01001, &ENTRY_LOCALIZABLER_4472819140531439518)],
        &[(0b01001, &ENTRY_LOCALIZABLES_14485108443499471420)],
        &[(0b01001, &ENTRY_LOCALIZABLEST_6312048620019063505)],
        &[(0b01001, &ENTRY_LOCALIZATION_1714165233158101768)],
        &[(0b01001, &ENTRY_LOCALIZATIONS_10357720798895176938)],
        &[(0b01001, &ENTRY_LOCALIZE_3508370761131546110)],
        &[(0b01001, &ENTRY_LOCALIZED_15436756507414158023)],
        &[(0b01001, &ENTRY_LOCALIZER_12500323668628991619)],
        &[(0b01001, &ENTRY_LOCALIZERS_9928746809280119061)],
        &[(0b01001, &ENTRY_LOCALIZES_128174617828783907)],
        &[(0b01001, &ENTRY_LOCALIZING_919540865361361114)],
        &[(0b11001, &ENTRY_LOGORRHEA_8997080484454664729)],
        &[(0b11001, &ENTRY_LOGORRHEAS_14700518672865329126)],
        &[(0b10010, &ENTRY_LOGORRHEA_8997080484454664729)],
        &[(0b10010, &ENTRY_LOGORRHEAS_14700518672865329126)],
        &[(0b01001, &ENTRY_LOUVER_16383649386238497792)],
        &[(0b01001, &ENTRY_LOUVERED_4612129354743875164)],
        &[(0b01001, &ENTRY_LOUVERS_13562782101200585962)],
        &[(0b11010, &ENTRY_LOUVER_16383649386238497792)],
        &[(0b11010, &ENTRY_LOUVERED_4612129354743875164)],
        &[(0b11010, &ENTRY_LOUVERS_13562782101200585962)],
        &[(0b00001, &ENTRY_LOVABILITY_12982835729070356135)],
        &[(0b00001, &ENTRY_LOVABLENESS_15385519583573319347)],
        &[(0b00001, &ENTRY_LOVABLY_8687570857338148234)],
    ],
    range: 4..=11,
};

static VARS_LI_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_LI_CHILDREN),
    value: None,
};

static VARS_LI_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    Some(&VARS_LIB_NODE),
    Some(&VARS_LIC_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_LIK_NODE),
    None,
    None,
    Some(&VARS_LIN_NODE),
    Some(&VARS_LIO_NODE),
    None,
    Some(&VARS_LIQ_NODE),
    None,
    Some(&VARS_LIS_NODE),
    Some(&VARS_LIT_NODE),
    None,
    Some(&VARS_LIV_NODE),
    None,
    None,
    None,
    None,
];

static VARS_LIV_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_LIV_CHILDREN),
    value: None,
};

pub static VARS_LIV_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[dictgen::InsensitiveAscii("able")],
    values: &[&[(0b11001, &ENTRY_LIVABLE_13408079841838673902)]],
    range: 4..=4,
};

static VARS_LIT_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_LIT_CHILDREN),
    value: None,
};

pub static VARS_LIT_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("er"),
        dictgen::InsensitiveAscii("eralise"),
        dictgen::InsensitiveAscii("eralised"),
        dictgen::InsensitiveAscii("eralises"),
        dictgen::InsensitiveAscii("eralising"),
        dictgen::InsensitiveAscii("eralize"),
        dictgen::InsensitiveAscii("eralized"),
        dictgen::InsensitiveAscii("eralizes"),
        dictgen::InsensitiveAscii("eralizing"),
        dictgen::InsensitiveAscii("ers"),
        dictgen::InsensitiveAscii("re"),
        dictgen::InsensitiveAscii("res"),
    ],
    values: &[
        &[(0b00001, &ENTRY_LITER_6442068802085842758)],
        &[(0b10010, &ENTRY_LITERALIZE_936950175462886011)],
        &[(0b10010, &ENTRY_LITERALIZED_12392805848021505273)],
        &[(0b10010, &ENTRY_LITERALIZES_12963354118044673239)],
        &[(0b10010, &ENTRY_LITERALIZING_4067560910880631706)],
        &[(0b01001, &ENTRY_LITERALIZE_936950175462886011)],
        &[(0b01001, &ENTRY_LITERALIZED_12392805848021505273)],
        &[(0b01001, &ENTRY_LITERALIZES_12963354118044673239)],
        &[(0b01001, &ENTRY_LITERALIZING_4067560910880631706)],
        &[(0b00001, &ENTRY_LITERS_6702315605664025195)],
        &[(0b11010, &ENTRY_LITER_6442068802085842758)],
        &[(0b11010, &ENTRY_LITERS_6702315605664025195)],
    ],
    range: 2..=9,
};

static VARS_LIS_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_LIS_CHILDREN),
    value: None,
};

pub static VARS_LIS_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("someness"),
        dictgen::InsensitiveAscii("somenesses"),
        dictgen::InsensitiveAscii("somness"),
        dictgen::InsensitiveAscii("somnesses"),
    ],
    values: &[
        &[(0b01001, &ENTRY_LISSOMENESS_3042611249910147188)],
        &[(0b01001, &ENTRY_LISSOMENESSES_15531245348799674971)],
        &[(0b10011, &ENTRY_LISSOMENESS_3042611249910147188)],
        &[(0b10011, &ENTRY_LISSOMENESSES_15531245348799674971)],
    ],
    range: 7..=10,
};

static VARS_LIQ_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_LIQ_CHILDREN),
    value: None,
};

pub static VARS_LIQ_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("uidise"),
        dictgen::InsensitiveAscii("uidised"),
        dictgen::InsensitiveAscii("uidiser"),
        dictgen::InsensitiveAscii("uidisers"),
        dictgen::InsensitiveAscii("uidises"),
        dictgen::InsensitiveAscii("uidising"),
        dictgen::InsensitiveAscii("uidize"),
        dictgen::InsensitiveAscii("uidized"),
        dictgen::InsensitiveAscii("uidizer"),
        dictgen::InsensitiveAscii("uidizers"),
        dictgen::InsensitiveAscii("uidizes"),
        dictgen::InsensitiveAscii("uidizing"),
        dictgen::InsensitiveAscii("uifier"),
        dictgen::InsensitiveAscii("uifiers"),
    ],
    values: &[
        &[(0b11010, &ENTRY_LIQUIDIZE_14194923337466264130)],
        &[(0b11010, &ENTRY_LIQUIDIZED_3292692080763673196)],
        &[(0b10010, &ENTRY_LIQUIDIZER_11706828663079340333)],
        &[(0b10010, &ENTRY_LIQUIDIZERS_4929831666489438893)],
        &[(0b11010, &ENTRY_LIQUIDIZES_15521435243413925703)],
        &[(0b11010, &ENTRY_LIQUIDIZING_9649118097468787294)],
        &[(0b01001, &ENTRY_LIQUIDIZE_14194923337466264130)],
        &[(0b01001, &ENTRY_LIQUIDIZED_3292692080763673196)],
        &[(0b01001, &ENTRY_LIQUIDIZER_11706828663079340333)],
        &[(0b01001, &ENTRY_LIQUIDIZERS_4929831666489438893)],
        &[(0b01001, &ENTRY_LIQUIDIZES_15521435243413925703)],
        &[(0b01001, &ENTRY_LIQUIDIZING_9649118097468787294)],
        &[(0b00001, &ENTRY_LIQUEFIER_8084176495582278110)],
        &[(0b00001, &ENTRY_LIQUEFIERS_3218357154702987275)],
    ],
    range: 6..=8,
};

static VARS_LIO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_LIO_CHILDREN),
    value: None,
};

pub static VARS_LIO_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("nisation"),
        dictgen::InsensitiveAscii("nisations"),
        dictgen::InsensitiveAscii("nise"),
        dictgen::InsensitiveAscii("nised"),
        dictgen::InsensitiveAscii("niser"),
        dictgen::InsensitiveAscii("nisers"),
        dictgen::InsensitiveAscii("nises"),
        dictgen::InsensitiveAscii("nising"),
        dictgen::InsensitiveAscii("nization"),
        dictgen::InsensitiveAscii("nizations"),
        dictgen::InsensitiveAscii("nize"),
        dictgen::InsensitiveAscii("nized"),
        dictgen::InsensitiveAscii("nizer"),
        dictgen::InsensitiveAscii("nizers"),
        dictgen::InsensitiveAscii("nizes"),
        dictgen::InsensitiveAscii("nizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_LIONIZATION_7835868583533630314)],
        &[(0b10010, &ENTRY_LIONIZATIONS_16641459291019877558)],
        &[(0b10010, &ENTRY_LIONIZE_18412797134322626457)],
        &[(0b10010, &ENTRY_LIONIZED_10011915111141731981)],
        &[(0b10010, &ENTRY_LIONIZER_8892928801781639667)],
        &[(0b10010, &ENTRY_LIONIZERS_10333415518245099706)],
        &[(0b10010, &ENTRY_LIONIZES_5684603994471877067)],
        &[(0b10010, &ENTRY_LIONIZING_9945396776786882247)],
        &[(0b01001, &ENTRY_LIONIZATION_7835868583533630314)],
        &[(0b01001, &ENTRY_LIONIZATIONS_16641459291019877558)],
        &[(0b01001, &ENTRY_LIONIZE_18412797134322626457)],
        &[(0b01001, &ENTRY_LIONIZED_10011915111141731981)],
        &[(0b01001, &ENTRY_LIONIZER_8892928801781639667)],
        &[(0b01001, &ENTRY_LIONIZERS_10333415518245099706)],
        &[(0b01001, &ENTRY_LIONIZES_5684603994471877067)],
        &[(0b01001, &ENTRY_LIONIZING_9945396776786882247)],
    ],
    range: 4..=9,
};

static VARS_LIN_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_LIN_CHILDREN),
    value: None,
};

pub static VARS_LIN_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("earise"),
        dictgen::InsensitiveAscii("earised"),
        dictgen::InsensitiveAscii("earises"),
        dictgen::InsensitiveAscii("earising"),
        dictgen::InsensitiveAscii("earize"),
        dictgen::InsensitiveAscii("earized"),
        dictgen::InsensitiveAscii("earizes"),
        dictgen::InsensitiveAscii("earizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_LINEARIZE_6585591481529371953)],
        &[(0b10010, &ENTRY_LINEARIZED_6277814411607786019)],
        &[(0b10010, &ENTRY_LINEARIZES_9623143888404969081)],
        &[(0b10010, &ENTRY_LINEARIZING_7681767987068150150)],
        &[(0b01001, &ENTRY_LINEARIZE_6585591481529371953)],
        &[(0b01001, &ENTRY_LINEARIZED_6277814411607786019)],
        &[(0b01001, &ENTRY_LINEARIZES_9623143888404969081)],
        &[(0b01001, &ENTRY_LINEARIZING_7681767987068150150)],
    ],
    range: 6..=8,
};

static VARS_LIK_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_LIK_CHILDREN),
    value: None,
};

pub static VARS_LIK_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("abilities"),
        dictgen::InsensitiveAscii("ability"),
        dictgen::InsensitiveAscii("ableness"),
        dictgen::InsensitiveAscii("ablenesses"),
    ],
    values: &[
        &[(0b10001, &ENTRY_LIKABILITIES_11415080682327614883)],
        &[(0b10001, &ENTRY_LIKABILITY_14107426908958456352)],
        &[(0b10001, &ENTRY_LIKABLENESS_3894991900618167051)],
        &[(0b10001, &ENTRY_LIKABLENESSES_7732487243731741508)],
    ],
    range: 7..=10,
};

static VARS_LIC_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_LIC_CHILDREN),
    value: None,
};

pub static VARS_LIC_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ence"),
        dictgen::InsensitiveAscii("enced"),
        dictgen::InsensitiveAscii("ences"),
        dictgen::InsensitiveAscii("encing"),
    ],
    values: &[
        &[
            (0b00010, &ENTRY_LICENSE_15235558001562153549),
            (0b11010, &ENTRY_LICENSE_8420547614103398896),
        ],
        &[(0b00010, &ENTRY_LICENSED_17867087688345174857)],
        &[
            (0b00010, &ENTRY_LICENSES_16200011703717675342),
            (0b11010, &ENTRY_LICENSES_6688982061827133578),
        ],
        &[(0b00010, &ENTRY_LICENSING_17752252713375594291)],
    ],
    range: 4..=6,
};

static VARS_LIB_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_LIB_CHILDREN),
    value: None,
};

pub static VARS_LIB_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("eled"),
        dictgen::InsensitiveAscii("eler"),
        dictgen::InsensitiveAscii("elers"),
        dictgen::InsensitiveAscii("eling"),
        dictgen::InsensitiveAscii("elled"),
        dictgen::InsensitiveAscii("eller"),
        dictgen::InsensitiveAscii("ellers"),
        dictgen::InsensitiveAscii("elling"),
        dictgen::InsensitiveAscii("ellous"),
        dictgen::InsensitiveAscii("ellouser"),
        dictgen::InsensitiveAscii("ellousest"),
        dictgen::InsensitiveAscii("elous"),
        dictgen::InsensitiveAscii("elouser"),
        dictgen::InsensitiveAscii("elousest"),
        dictgen::InsensitiveAscii("eralisation"),
        dictgen::InsensitiveAscii("eralisations"),
        dictgen::InsensitiveAscii("eralise"),
        dictgen::InsensitiveAscii("eralised"),
        dictgen::InsensitiveAscii("eraliser"),
        dictgen::InsensitiveAscii("eralisers"),
        dictgen::InsensitiveAscii("eralises"),
        dictgen::InsensitiveAscii("eralising"),
        dictgen::InsensitiveAscii("eralization"),
        dictgen::InsensitiveAscii("eralizations"),
        dictgen::InsensitiveAscii("eralize"),
        dictgen::InsensitiveAscii("eralized"),
        dictgen::InsensitiveAscii("eralizer"),
        dictgen::InsensitiveAscii("eralizers"),
        dictgen::InsensitiveAscii("eralizes"),
        dictgen::InsensitiveAscii("eralizing"),
    ],
    values: &[
        &[(0b00001, &ENTRY_LIBELED_8051675010294297382)],
        &[(0b00001, &ENTRY_LIBELER_24227560685436157)],
        &[(0b00001, &ENTRY_LIBELERS_847096387317740162)],
        &[(0b00001, &ENTRY_LIBELING_928273583787085556)],
        &[(0b11010, &ENTRY_LIBELED_8051675010294297382)],
        &[(0b11010, &ENTRY_LIBELER_24227560685436157)],
        &[(0b11010, &ENTRY_LIBELERS_847096387317740162)],
        &[(0b11010, &ENTRY_LIBELING_928273583787085556)],
        &[(0b11010, &ENTRY_LIBELOUS_17927467531006981983)],
        &[(0b11010, &ENTRY_LIBELOUSER_4863053355167467915)],
        &[(0b11010, &ENTRY_LIBELOUSEST_3829700018638160477)],
        &[(0b01001, &ENTRY_LIBELOUS_17927467531006981983)],
        &[(0b01001, &ENTRY_LIBELOUSER_4863053355167467915)],
        &[(0b01001, &ENTRY_LIBELOUSEST_3829700018638160477)],
        &[(0b10010, &ENTRY_LIBERALIZATION_6402945837364985631)],
        &[(0b10010, &ENTRY_LIBERALIZATIONS_10234274833724631870)],
        &[(0b10010, &ENTRY_LIBERALIZE_76622256595054540)],
        &[(0b10010, &ENTRY_LIBERALIZED_7103715465503664043)],
        &[(0b10010, &ENTRY_LIBERALIZER_6703544626598968567)],
        &[(0b10010, &ENTRY_LIBERALIZERS_17607581360244717241)],
        &[(0b10010, &ENTRY_LIBERALIZES_2300482275642251125)],
        &[(0b10010, &ENTRY_LIBERALIZING_1078842496046790451)],
        &[(0b01001, &ENTRY_LIBERALIZATION_6402945837364985631)],
        &[(0b01001, &ENTRY_LIBERALIZATIONS_10234274833724631870)],
        &[(0b01001, &ENTRY_LIBERALIZE_76622256595054540)],
        &[(0b01001, &ENTRY_LIBERALIZED_7103715465503664043)],
        &[(0b01001, &ENTRY_LIBERALIZER_6703544626598968567)],
        &[(0b01001, &ENTRY_LIBERALIZERS_17607581360244717241)],
        &[(0b01001, &ENTRY_LIBERALIZES_2300482275642251125)],
        &[(0b01001, &ENTRY_LIBERALIZING_1078842496046790451)],
    ],
    range: 4..=12,
};

static VARS_LE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_LE_CHILDREN),
    value: None,
};

pub static VARS_LE_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("arnt"),
        dictgen::InsensitiveAscii("galisation"),
        dictgen::InsensitiveAscii("galisations"),
        dictgen::InsensitiveAscii("galise"),
        dictgen::InsensitiveAscii("galised"),
        dictgen::InsensitiveAscii("galises"),
        dictgen::InsensitiveAscii("galising"),
        dictgen::InsensitiveAscii("galization"),
        dictgen::InsensitiveAscii("galizations"),
        dictgen::InsensitiveAscii("galize"),
        dictgen::InsensitiveAscii("galized"),
        dictgen::InsensitiveAscii("galizes"),
        dictgen::InsensitiveAscii("galizing"),
        dictgen::InsensitiveAscii("ggin"),
        dictgen::InsensitiveAscii("ggins"),
        dictgen::InsensitiveAscii("gitimisation"),
        dictgen::InsensitiveAscii("gitimisations"),
        dictgen::InsensitiveAscii("gitimise"),
        dictgen::InsensitiveAscii("gitimised"),
        dictgen::InsensitiveAscii("gitimises"),
        dictgen::InsensitiveAscii("gitimising"),
        dictgen::InsensitiveAscii("gitimization"),
        dictgen::InsensitiveAscii("gitimizations"),
        dictgen::InsensitiveAscii("gitimize"),
        dictgen::InsensitiveAscii("gitimized"),
        dictgen::InsensitiveAscii("gitimizes"),
        dictgen::InsensitiveAscii("gitimizing"),
        dictgen::InsensitiveAscii("ukaemia"),
        dictgen::InsensitiveAscii("ukaemias"),
        dictgen::InsensitiveAscii("ukemia"),
        dictgen::InsensitiveAscii("ukemias"),
        dictgen::InsensitiveAscii("veled"),
        dictgen::InsensitiveAscii("veler"),
        dictgen::InsensitiveAscii("velers"),
        dictgen::InsensitiveAscii("velest"),
        dictgen::InsensitiveAscii("veling"),
        dictgen::InsensitiveAscii("velled"),
        dictgen::InsensitiveAscii("veller"),
        dictgen::InsensitiveAscii("vellers"),
        dictgen::InsensitiveAscii("vellest"),
        dictgen::InsensitiveAscii("velling"),
    ],
    values: &[
        &[(0b11010, &ENTRY_LEARNED_16553251450375188122)],
        &[(0b10010, &ENTRY_LEGALIZATION_14069720183344579391)],
        &[(0b10010, &ENTRY_LEGALIZATIONS_7369809481070839600)],
        &[(0b10010, &ENTRY_LEGALIZE_6090443744031107422)],
        &[(0b10010, &ENTRY_LEGALIZED_4279297604105669391)],
        &[(0b10010, &ENTRY_LEGALIZES_15551841073682264464)],
        &[(0b10010, &ENTRY_LEGALIZING_14672145239610477044)],
        &[(0b01001, &ENTRY_LEGALIZATION_14069720183344579391)],
        &[(0b01001, &ENTRY_LEGALIZATIONS_7369809481070839600)],
        &[(0b01001, &ENTRY_LEGALIZE_6090443744031107422)],
        &[(0b01001, &ENTRY_LEGALIZED_4279297604105669391)],
        &[(0b01001, &ENTRY_LEGALIZES_15551841073682264464)],
        &[(0b01001, &ENTRY_LEGALIZING_14672145239610477044)],
        &[(0b00001, &ENTRY_LEGGING_8791551298779124491)],
        &[(0b00001, &ENTRY_LEGGINGS_18074923807625757810)],
        &[(0b10010, &ENTRY_LEGITIMIZATION_522172373867492649)],
        &[(0b10010, &ENTRY_LEGITIMIZATIONS_11689914768775001401)],
        &[(0b10010, &ENTRY_LEGITIMIZE_162184278793564767)],
        &[(0b10010, &ENTRY_LEGITIMIZED_7050352751899263729)],
        &[(0b10010, &ENTRY_LEGITIMIZES_15916033610846937765)],
        &[(0b10010, &ENTRY_LEGITIMIZING_15403346656705937661)],
        &[(0b01001, &ENTRY_LEGITIMIZATION_522172373867492649)],
        &[(0b01001, &ENTRY_LEGITIMIZATIONS_11689914768775001401)],
        &[(0b01001, &ENTRY_LEGITIMIZE_162184278793564767)],
        &[(0b01001, &ENTRY_LEGITIMIZED_7050352751899263729)],
        &[(0b01001, &ENTRY_LEGITIMIZES_15916033610846937765)],
        &[(0b01001, &ENTRY_LEGITIMIZING_15403346656705937661)],
        &[(0b10010, &ENTRY_LEUKEMIA_18308238259623845158)],
        &[(0b10010, &ENTRY_LEUKEMIAS_9099411686641435250)],
        &[(0b11001, &ENTRY_LEUKEMIA_18308238259623845158)],
        &[(0b11001, &ENTRY_LEUKEMIAS_9099411686641435250)],
        &[(0b00001, &ENTRY_LEVELED_17710552579875587899)],
        &[(0b00001, &ENTRY_LEVELER_16958859746569115537)],
        &[(0b00001, &ENTRY_LEVELERS_7665258852948284339)],
        &[(0b00001, &ENTRY_LEVELEST_13356524148042532014)],
        &[(0b00001, &ENTRY_LEVELING_498798874102170149)],
        &[(0b11010, &ENTRY_LEVELED_17710552579875587899)],
        &[(0b11010, &ENTRY_LEVELER_16958859746569115537)],
        &[(0b11010, &ENTRY_LEVELERS_7665258852948284339)],
        &[(0b11010, &ENTRY_LEVELEST_13356524148042532014)],
        &[(0b11010, &ENTRY_LEVELING_498798874102170149)],
    ],
    range: 4..=13,
};

static VARS_LA_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_LA_CHILDREN),
    value: None,
};

pub static VARS_LA_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("beled"),
        dictgen::InsensitiveAscii("beler"),
        dictgen::InsensitiveAscii("belers"),
        dictgen::InsensitiveAscii("beling"),
        dictgen::InsensitiveAscii("belled"),
        dictgen::InsensitiveAscii("beller"),
        dictgen::InsensitiveAscii("bellers"),
        dictgen::InsensitiveAscii("belling"),
        dictgen::InsensitiveAscii("bialise"),
        dictgen::InsensitiveAscii("bialised"),
        dictgen::InsensitiveAscii("bialises"),
        dictgen::InsensitiveAscii("bialising"),
        dictgen::InsensitiveAscii("bialize"),
        dictgen::InsensitiveAscii("bialized"),
        dictgen::InsensitiveAscii("bializes"),
        dictgen::InsensitiveAscii("bializing"),
        dictgen::InsensitiveAscii("bor"),
        dictgen::InsensitiveAscii("bored"),
        dictgen::InsensitiveAscii("borer"),
        dictgen::InsensitiveAscii("borers"),
        dictgen::InsensitiveAscii("boring"),
        dictgen::InsensitiveAscii("borings"),
        dictgen::InsensitiveAscii("bors"),
        dictgen::InsensitiveAscii("bour"),
        dictgen::InsensitiveAscii("boured"),
        dictgen::InsensitiveAscii("bourer"),
        dictgen::InsensitiveAscii("bourers"),
        dictgen::InsensitiveAscii("bouring"),
        dictgen::InsensitiveAscii("bourings"),
        dictgen::InsensitiveAscii("bours"),
        dictgen::InsensitiveAscii("ckluster"),
        dictgen::InsensitiveAscii("cklusterrer"),
        dictgen::InsensitiveAscii("cklusterrest"),
        dictgen::InsensitiveAscii("cklusters"),
        dictgen::InsensitiveAscii("cklustre"),
        dictgen::InsensitiveAscii("cklustrer"),
        dictgen::InsensitiveAscii("cklustres"),
        dictgen::InsensitiveAscii("cklustrest"),
        dictgen::InsensitiveAscii("icisation"),
        dictgen::InsensitiveAscii("icisations"),
        dictgen::InsensitiveAscii("icise"),
        dictgen::InsensitiveAscii("icised"),
        dictgen::InsensitiveAscii("icises"),
        dictgen::InsensitiveAscii("icising"),
        dictgen::InsensitiveAscii("icization"),
        dictgen::InsensitiveAscii("icizations"),
        dictgen::InsensitiveAscii("icize"),
        dictgen::InsensitiveAscii("icized"),
        dictgen::InsensitiveAscii("icizes"),
        dictgen::InsensitiveAscii("icizing"),
        dictgen::InsensitiveAscii("tinisation"),
        dictgen::InsensitiveAscii("tinisations"),
        dictgen::InsensitiveAscii("tinise"),
        dictgen::InsensitiveAscii("tinised"),
        dictgen::InsensitiveAscii("tinises"),
        dictgen::InsensitiveAscii("tinising"),
        dictgen::InsensitiveAscii("tinization"),
        dictgen::InsensitiveAscii("tinizations"),
        dictgen::InsensitiveAscii("tinize"),
        dictgen::InsensitiveAscii("tinized"),
        dictgen::InsensitiveAscii("tinizes"),
        dictgen::InsensitiveAscii("tinizing"),
    ],
    values: &[
        &[(0b00001, &ENTRY_LABELED_2907482757768957656)],
        &[(0b00001, &ENTRY_LABELER_4919831389912264778)],
        &[(0b00001, &ENTRY_LABELERS_11132772436034449864)],
        &[(0b00001, &ENTRY_LABELING_17714047580259532785)],
        &[(0b11010, &ENTRY_LABELED_2907482757768957656)],
        &[(0b11010, &ENTRY_LABELER_4919831389912264778)],
        &[(0b11010, &ENTRY_LABELERS_11132772436034449864)],
        &[(0b11010, &ENTRY_LABELING_17714047580259532785)],
        &[(0b10010, &ENTRY_LABIALIZE_12309708431223536784)],
        &[(0b10010, &ENTRY_LABIALIZED_13758824402379981127)],
        &[(0b10010, &ENTRY_LABIALIZES_4066346379039880965)],
        &[(0b10010, &ENTRY_LABIALIZING_12581521144967923205)],
        &[(0b01001, &ENTRY_LABIALIZE_12309708431223536784)],
        &[(0b01001, &ENTRY_LABIALIZED_13758824402379981127)],
        &[(0b01001, &ENTRY_LABIALIZES_4066346379039880965)],
        &[(0b01001, &ENTRY_LABIALIZING_12581521144967923205)],
        &[(0b11001, &ENTRY_LABOR_17181769129422624469)],
        &[(0b11001, &ENTRY_LABORED_15774914145750785155)],
        &[(0b11001, &ENTRY_LABORER_7780947282825536960)],
        &[(0b11001, &ENTRY_LABORERS_7225219841972156021)],
        &[(0b11001, &ENTRY_LABORING_3043303013162659642)],
        &[(0b11001, &ENTRY_LABORINGS_3319891939721158320)],
        &[(0b11001, &ENTRY_LABORS_911770229695768884)],
        &[(0b11010, &ENTRY_LABOR_17181769129422624469)],
        &[(0b11010, &ENTRY_LABORED_15774914145750785155)],
        &[(0b11010, &ENTRY_LABORER_7780947282825536960)],
        &[(0b11010, &ENTRY_LABORERS_7225219841972156021)],
        &[(0b11010, &ENTRY_LABORING_3043303013162659642)],
        &[(0b11010, &ENTRY_LABORINGS_3319891939721158320)],
        &[(0b11010, &ENTRY_LABORS_911770229695768884)],
        &[(0b00001, &ENTRY_LACKLUSTER_1715256487006561661)],
        &[(0b00001, &ENTRY_LACKLUSTERRER_1131236613295912206)],
        &[(0b00001, &ENTRY_LACKLUSTERREST_12506726696603302121)],
        &[(0b00001, &ENTRY_LACKLUSTERS_6612944023946392488)],
        &[(0b11010, &ENTRY_LACKLUSTER_1715256487006561661)],
        &[(0b11010, &ENTRY_LACKLUSTERRER_1131236613295912206)],
        &[(0b11010, &ENTRY_LACKLUSTERS_6612944023946392488)],
        &[(0b11010, &ENTRY_LACKLUSTERREST_12506726696603302121)],
        &[(0b10010, &ENTRY_LAICIZATION_2887235584180290305)],
        &[(0b10010, &ENTRY_LAICIZATIONS_9749455722701689807)],
        &[(0b10010, &ENTRY_LAICIZE_3572230327046139216)],
        &[(0b10010, &ENTRY_LAICIZED_80445541934935273)],
        &[(0b10010, &ENTRY_LAICIZES_869459089127458605)],
        &[(0b10010, &ENTRY_LAICIZING_5309366367065705343)],
        &[(0b01001, &ENTRY_LAICIZATION_2887235584180290305)],
        &[(0b01001, &ENTRY_LAICIZATIONS_9749455722701689807)],
        &[(0b01001, &ENTRY_LAICIZE_3572230327046139216)],
        &[(0b01001, &ENTRY_LAICIZED_80445541934935273)],
        &[(0b01001, &ENTRY_LAICIZES_869459089127458605)],
        &[(0b01001, &ENTRY_LAICIZING_5309366367065705343)],
        &[(0b10010, &ENTRY_LATINIZATION_11972451538371752217)],
        &[(0b10010, &ENTRY_LATINIZATIONS_6858424540483628997)],
        &[(0b10010, &ENTRY_LATINIZE_10995098395307448983)],
        &[(0b10010, &ENTRY_LATINIZED_10581307786903570003)],
        &[(0b10010, &ENTRY_LATINIZES_9202029225723708964)],
        &[(0b10010, &ENTRY_LATINIZING_12540759379841466342)],
        &[(0b01001, &ENTRY_LATINIZATION_11972451538371752217)],
        &[(0b01001, &ENTRY_LATINIZATIONS_6858424540483628997)],
        &[(0b01001, &ENTRY_LATINIZE_10995098395307448983)],
        &[(0b01001, &ENTRY_LATINIZED_10581307786903570003)],
        &[(0b01001, &ENTRY_LATINIZES_9202029225723708964)],
        &[(0b01001, &ENTRY_LATINIZING_12540759379841466342)],
    ],
    range: 3..=12,
};

static VARS_K_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_K_CHILDREN),
    value: None,
};

pub static VARS_K_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("enneled"),
        dictgen::InsensitiveAscii("enneling"),
        dictgen::InsensitiveAscii("ennelled"),
        dictgen::InsensitiveAscii("ennelling"),
        dictgen::InsensitiveAscii("eratinisation"),
        dictgen::InsensitiveAscii("eratinisations"),
        dictgen::InsensitiveAscii("eratinise"),
        dictgen::InsensitiveAscii("eratinised"),
        dictgen::InsensitiveAscii("eratinises"),
        dictgen::InsensitiveAscii("eratinising"),
        dictgen::InsensitiveAscii("eratinization"),
        dictgen::InsensitiveAscii("eratinizations"),
        dictgen::InsensitiveAscii("eratinize"),
        dictgen::InsensitiveAscii("eratinized"),
        dictgen::InsensitiveAscii("eratinizes"),
        dictgen::InsensitiveAscii("eratinizing"),
        dictgen::InsensitiveAscii("erosine"),
        dictgen::InsensitiveAscii("erosines"),
        dictgen::InsensitiveAscii("idnaped"),
        dictgen::InsensitiveAscii("idnaper"),
        dictgen::InsensitiveAscii("idnapers"),
        dictgen::InsensitiveAscii("idnaping"),
        dictgen::InsensitiveAscii("ilogramme"),
        dictgen::InsensitiveAscii("ilogrammes"),
        dictgen::InsensitiveAscii("iloliter"),
        dictgen::InsensitiveAscii("iloliters"),
        dictgen::InsensitiveAscii("ilolitre"),
        dictgen::InsensitiveAscii("ilolitres"),
        dictgen::InsensitiveAscii("ilometer"),
        dictgen::InsensitiveAscii("ilometers"),
        dictgen::InsensitiveAscii("ilometre"),
        dictgen::InsensitiveAscii("ilometres"),
        dictgen::InsensitiveAscii("inaesthesia"),
        dictgen::InsensitiveAscii("inaesthesias"),
        dictgen::InsensitiveAscii("inaesthetic"),
        dictgen::InsensitiveAscii("inaestheticer"),
        dictgen::InsensitiveAscii("inaestheticest"),
        dictgen::InsensitiveAscii("inaesthetics"),
        dictgen::InsensitiveAscii("indergartener"),
        dictgen::InsensitiveAscii("indergarteners"),
        dictgen::InsensitiveAscii("indergartner"),
        dictgen::InsensitiveAscii("indergartners"),
        dictgen::InsensitiveAscii("inesthesia"),
        dictgen::InsensitiveAscii("inesthesias"),
        dictgen::InsensitiveAscii("inesthetic"),
        dictgen::InsensitiveAscii("inestheticer"),
        dictgen::InsensitiveAscii("inestheticest"),
        dictgen::InsensitiveAscii("inesthetics"),
    ],
    values: &[
        &[(0b00001, &ENTRY_KENNELED_7097387362453255328)],
        &[(0b00001, &ENTRY_KENNELING_3222702508854487680)],
        &[(0b11010, &ENTRY_KENNELED_7097387362453255328)],
        &[(0b11010, &ENTRY_KENNELING_3222702508854487680)],
        &[(0b10010, &ENTRY_KERATINIZATION_9287269898372096209)],
        &[(0b10010, &ENTRY_KERATINIZATIONS_11148703562572717517)],
        &[(0b10010, &ENTRY_KERATINIZE_5854314817304010708)],
        &[(0b10010, &ENTRY_KERATINIZED_9532404537119161326)],
        &[(0b10010, &ENTRY_KERATINIZES_6869237603626021135)],
        &[(0b10010, &ENTRY_KERATINIZING_6928540492051600473)],
        &[(0b01001, &ENTRY_KERATINIZATION_9287269898372096209)],
        &[(0b01001, &ENTRY_KERATINIZATIONS_11148703562572717517)],
        &[(0b01001, &ENTRY_KERATINIZE_5854314817304010708)],
        &[(0b01001, &ENTRY_KERATINIZED_9532404537119161326)],
        &[(0b01001, &ENTRY_KERATINIZES_6869237603626021135)],
        &[(0b01001, &ENTRY_KERATINIZING_6928540492051600473)],
        &[(0b10011, &ENTRY_KEROSENE_5237608390797685560)],
        &[(0b10011, &ENTRY_KEROSENES_9607995162491837420)],
        &[(0b00001, &ENTRY_KIDNAPPED_9540389708046051348)],
        &[(0b00001, &ENTRY_KIDNAPPER_13085195688301237337)],
        &[(0b00001, &ENTRY_KIDNAPPERS_9985029854330453394)],
        &[(0b00001, &ENTRY_KIDNAPPING_70511558429659)],
        &[(0b10010, &ENTRY_KILOGRAM_7939130248079190868)],
        &[(0b10010, &ENTRY_KILOGRAMS_12915102141657973507)],
        &[(0b01001, &ENTRY_KILOLITER_8811985426912090253)],
        &[(0b01001, &ENTRY_KILOLITERS_7196014977999441896)],
        &[(0b11010, &ENTRY_KILOLITER_8811985426912090253)],
        &[(0b11010, &ENTRY_KILOLITERS_7196014977999441896)],
        &[(0b01001, &ENTRY_KILOMETER_3916092874457639239)],
        &[(0b01001, &ENTRY_KILOMETERS_7517136324284687795)],
        &[(0b11010, &ENTRY_KILOMETER_3916092874457639239)],
        &[(0b11010, &ENTRY_KILOMETERS_7517136324284687795)],
        &[(0b11010, &ENTRY_KINESTHESIA_4063943003598390788)],
        &[(0b11010, &ENTRY_KINESTHESIAS_5509168349661428667)],
        &[(0b11010, &ENTRY_KINESTHETIC_12696136530393551560)],
        &[(0b11010, &ENTRY_KINESTHETICER_10688483926829306448)],
        &[(0b11010, &ENTRY_KINESTHETICEST_17532483346165398356)],
        &[(0b11010, &ENTRY_KINESTHETICS_8164390027509303384)],
        &[(0b10011, &ENTRY_KINDERGARTNER_13742901016370510532)],
        &[(0b10011, &ENTRY_KINDERGARTNERS_5091309540324859208)],
        &[(0b01001, &ENTRY_KINDERGARTNER_13742901016370510532)],
        &[(0b01001, &ENTRY_KINDERGARTNERS_5091309540324859208)],
        &[(0b11001, &ENTRY_KINESTHESIA_4063943003598390788)],
        &[(0b11001, &ENTRY_KINESTHESIAS_5509168349661428667)],
        &[(0b11001, &ENTRY_KINESTHETIC_12696136530393551560)],
        &[(0b11001, &ENTRY_KINESTHETICER_10688483926829306448)],
        &[(0b11001, &ENTRY_KINESTHETICEST_17532483346165398356)],
        &[(0b11001, &ENTRY_KINESTHETICS_8164390027509303384)],
    ],
    range: 7..=14,
};

static VARS_J_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_J_CHILDREN),
    value: None,
};

pub static VARS_J_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ailor"),
        dictgen::InsensitiveAscii("ailors"),
        dictgen::InsensitiveAscii("argonise"),
        dictgen::InsensitiveAscii("argonised"),
        dictgen::InsensitiveAscii("argonises"),
        dictgen::InsensitiveAscii("argonising"),
        dictgen::InsensitiveAscii("argonize"),
        dictgen::InsensitiveAscii("argonized"),
        dictgen::InsensitiveAscii("argonizes"),
        dictgen::InsensitiveAscii("argonizing"),
        dictgen::InsensitiveAscii("eopardise"),
        dictgen::InsensitiveAscii("eopardised"),
        dictgen::InsensitiveAscii("eopardises"),
        dictgen::InsensitiveAscii("eopardising"),
        dictgen::InsensitiveAscii("eopardize"),
        dictgen::InsensitiveAscii("eopardized"),
        dictgen::InsensitiveAscii("eopardizes"),
        dictgen::InsensitiveAscii("eopardizing"),
        dictgen::InsensitiveAscii("eweled"),
        dictgen::InsensitiveAscii("eweler"),
        dictgen::InsensitiveAscii("ewelers"),
        dictgen::InsensitiveAscii("eweling"),
        dictgen::InsensitiveAscii("ewelled"),
        dictgen::InsensitiveAscii("eweller"),
        dictgen::InsensitiveAscii("ewellers"),
        dictgen::InsensitiveAscii("ewellery"),
        dictgen::InsensitiveAscii("ewelling"),
        dictgen::InsensitiveAscii("ewelry"),
        dictgen::InsensitiveAscii("oky"),
        dictgen::InsensitiveAscii("udaisation"),
        dictgen::InsensitiveAscii("udaise"),
        dictgen::InsensitiveAscii("udaised"),
        dictgen::InsensitiveAscii("udaising"),
        dictgen::InsensitiveAscii("udaization"),
        dictgen::InsensitiveAscii("udaize"),
        dictgen::InsensitiveAscii("udaized"),
        dictgen::InsensitiveAscii("udaizing"),
        dictgen::InsensitiveAscii("udgement"),
        dictgen::InsensitiveAscii("udgements"),
    ],
    values: &[
        &[(0b01001, &ENTRY_JAILER_16794396359446182049)],
        &[(0b01001, &ENTRY_JAILERS_15685267405324816915)],
        &[(0b10010, &ENTRY_JARGONIZE_17586054368036140712)],
        &[(0b10010, &ENTRY_JARGONIZED_15791162347082638293)],
        &[(0b10010, &ENTRY_JARGONIZES_4998631633267950571)],
        &[(0b10010, &ENTRY_JARGONIZING_4259002532402415391)],
        &[(0b01001, &ENTRY_JARGONIZE_17586054368036140712)],
        &[(0b01001, &ENTRY_JARGONIZED_15791162347082638293)],
        &[(0b01001, &ENTRY_JARGONIZES_4998631633267950571)],
        &[(0b01001, &ENTRY_JARGONIZING_4259002532402415391)],
        &[(0b10010, &ENTRY_JEOPARDIZE_7563132171286021122)],
        &[(0b10010, &ENTRY_JEOPARDIZED_4290897290667261086)],
        &[(0b10010, &ENTRY_JEOPARDIZES_1770057888942412589)],
        &[(0b10010, &ENTRY_JEOPARDIZING_11478877839793401266)],
        &[(0b01001, &ENTRY_JEOPARDIZE_7563132171286021122)],
        &[(0b01001, &ENTRY_JEOPARDIZED_4290897290667261086)],
        &[(0b01001, &ENTRY_JEOPARDIZES_1770057888942412589)],
        &[(0b01001, &ENTRY_JEOPARDIZING_11478877839793401266)],
        &[(0b00001, &ENTRY_JEWELED_1164673326064560766)],
        &[(0b00001, &ENTRY_JEWELER_11683392478209510720)],
        &[(0b00001, &ENTRY_JEWELERS_4919007304834585018)],
        &[(0b00001, &ENTRY_JEWELING_17397805769460286766)],
        &[(0b11010, &ENTRY_JEWELED_1164673326064560766)],
        &[(0b11010, &ENTRY_JEWELER_11683392478209510720)],
        &[(0b11010, &ENTRY_JEWELERS_4919007304834585018)],
        &[(0b11010, &ENTRY_JEWELRY_1265691138331552301)],
        &[(0b11010, &ENTRY_JEWELING_17397805769460286766)],
        &[(0b01001, &ENTRY_JEWELRY_1265691138331552301)],
        &[(0b10011, &ENTRY_JOKEY_1401133516029317070)],
        &[(0b10010, &ENTRY_JUDAIZATION_8802637711012973186)],
        &[(0b10010, &ENTRY_JUDAIZE_12262219091800711286)],
        &[(0b10010, &ENTRY_JUDAIZED_11097537345612695567)],
        &[(0b10010, &ENTRY_JUDAIZING_3118358796769865883)],
        &[(0b01001, &ENTRY_JUDAIZATION_8802637711012973186)],
        &[(0b01001, &ENTRY_JUDAIZE_12262219091800711286)],
        &[(0b01001, &ENTRY_JUDAIZED_11097537345612695567)],
        &[(0b01001, &ENTRY_JUDAIZING_3118358796769865883)],
        &[(0b11010, &ENTRY_JUDGMENT_16033544137863724757)],
        &[(0b11010, &ENTRY_JUDGMENTS_3887014541133672054)],
    ],
    range: 3..=11,
};

static VARS_I_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_I_CHILDREN),
    value: None,
};

static VARS_I_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    None,
    Some(&VARS_ID_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_IM_NODE),
    Some(&VARS_IN_NODE),
    Some(&VARS_IO_NODE),
    None,
    None,
    None,
    Some(&VARS_IS_NODE),
    Some(&VARS_IT_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_IT_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_IT_CHILDREN),
    value: None,
};

pub static VARS_IT_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("alicisation"),
        dictgen::InsensitiveAscii("alicisations"),
        dictgen::InsensitiveAscii("alicise"),
        dictgen::InsensitiveAscii("alicised"),
        dictgen::InsensitiveAscii("alicises"),
        dictgen::InsensitiveAscii("alicising"),
        dictgen::InsensitiveAscii("alicization"),
        dictgen::InsensitiveAscii("alicizations"),
        dictgen::InsensitiveAscii("alicize"),
        dictgen::InsensitiveAscii("alicized"),
        dictgen::InsensitiveAscii("alicizes"),
        dictgen::InsensitiveAscii("alicizing"),
        dictgen::InsensitiveAscii("emisation"),
        dictgen::InsensitiveAscii("emisations"),
        dictgen::InsensitiveAscii("emise"),
        dictgen::InsensitiveAscii("emised"),
        dictgen::InsensitiveAscii("emises"),
        dictgen::InsensitiveAscii("emising"),
        dictgen::InsensitiveAscii("emization"),
        dictgen::InsensitiveAscii("emizations"),
        dictgen::InsensitiveAscii("emize"),
        dictgen::InsensitiveAscii("emized"),
        dictgen::InsensitiveAscii("emizes"),
        dictgen::InsensitiveAscii("emizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_ITALICIZATION_7637072269958036418)],
        &[(0b10010, &ENTRY_ITALICIZATIONS_8504692545843995442)],
        &[(0b10010, &ENTRY_ITALICIZE_13351991321688846658)],
        &[(0b10010, &ENTRY_ITALICIZED_18008158115597569175)],
        &[(0b10010, &ENTRY_ITALICIZES_14940618929368461253)],
        &[(0b10010, &ENTRY_ITALICIZING_14716378013800458429)],
        &[(0b01001, &ENTRY_ITALICIZATION_7637072269958036418)],
        &[(0b01001, &ENTRY_ITALICIZATIONS_8504692545843995442)],
        &[(0b01001, &ENTRY_ITALICIZE_13351991321688846658)],
        &[(0b01001, &ENTRY_ITALICIZED_18008158115597569175)],
        &[(0b01001, &ENTRY_ITALICIZES_14940618929368461253)],
        &[(0b01001, &ENTRY_ITALICIZING_14716378013800458429)],
        &[(0b10010, &ENTRY_ITEMIZATION_2083084966275745571)],
        &[(0b10010, &ENTRY_ITEMIZATIONS_6647254086503275130)],
        &[(0b10010, &ENTRY_ITEMIZE_1075679219292232313)],
        &[(0b10010, &ENTRY_ITEMIZED_72220609705553029)],
        &[(0b10010, &ENTRY_ITEMIZES_9916875436104019879)],
        &[(0b10010, &ENTRY_ITEMIZING_2983331397312369622)],
        &[(0b01001, &ENTRY_ITEMIZATION_2083084966275745571)],
        &[(0b01001, &ENTRY_ITEMIZATIONS_6647254086503275130)],
        &[(0b01001, &ENTRY_ITEMIZE_1075679219292232313)],
        &[(0b01001, &ENTRY_ITEMIZED_72220609705553029)],
        &[(0b01001, &ENTRY_ITEMIZES_9916875436104019879)],
        &[(0b01001, &ENTRY_ITEMIZING_2983331397312369622)],
    ],
    range: 5..=12,
};

static VARS_IS_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_IS_CHILDREN),
    value: None,
};

pub static VARS_IS_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("chaemia"),
        dictgen::InsensitiveAscii("chaemias"),
        dictgen::InsensitiveAscii("chaemic"),
        dictgen::InsensitiveAscii("chemia"),
        dictgen::InsensitiveAscii("chemias"),
        dictgen::InsensitiveAscii("chemic"),
    ],
    values: &[
        &[(0b10010, &ENTRY_ISCHEMIA_10554201921415637717)],
        &[(0b10010, &ENTRY_ISCHEMIAS_9916394730153752763)],
        &[(0b10010, &ENTRY_ISCHEMIC_2442996153770242671)],
        &[(0b11001, &ENTRY_ISCHEMIA_10554201921415637717)],
        &[(0b11001, &ENTRY_ISCHEMIAS_9916394730153752763)],
        &[(0b11001, &ENTRY_ISCHEMIC_2442996153770242671)],
    ],
    range: 6..=8,
};

static VARS_IO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_IO_CHILDREN),
    value: None,
};

pub static VARS_IO_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("dise"),
        dictgen::InsensitiveAscii("dised"),
        dictgen::InsensitiveAscii("dises"),
        dictgen::InsensitiveAscii("dising"),
        dictgen::InsensitiveAscii("dize"),
        dictgen::InsensitiveAscii("dized"),
        dictgen::InsensitiveAscii("dizes"),
        dictgen::InsensitiveAscii("dizing"),
        dictgen::InsensitiveAscii("nisable"),
        dictgen::InsensitiveAscii("nisabler"),
        dictgen::InsensitiveAscii("nisables"),
        dictgen::InsensitiveAscii("nisablest"),
        dictgen::InsensitiveAscii("nisation"),
        dictgen::InsensitiveAscii("nisations"),
        dictgen::InsensitiveAscii("nise"),
        dictgen::InsensitiveAscii("nised"),
        dictgen::InsensitiveAscii("niser"),
        dictgen::InsensitiveAscii("nisers"),
        dictgen::InsensitiveAscii("nises"),
        dictgen::InsensitiveAscii("nising"),
        dictgen::InsensitiveAscii("nisings"),
        dictgen::InsensitiveAscii("nizable"),
        dictgen::InsensitiveAscii("nizabler"),
        dictgen::InsensitiveAscii("nizables"),
        dictgen::InsensitiveAscii("nizablest"),
        dictgen::InsensitiveAscii("nization"),
        dictgen::InsensitiveAscii("nizations"),
        dictgen::InsensitiveAscii("nize"),
        dictgen::InsensitiveAscii("nized"),
        dictgen::InsensitiveAscii("nizes"),
        dictgen::InsensitiveAscii("nizing"),
        dictgen::InsensitiveAscii("nizings"),
    ],
    values: &[
        &[(0b10010, &ENTRY_IODIZE_1306425172808849701)],
        &[(0b10010, &ENTRY_IODIZED_5589078459430909426)],
        &[(0b10010, &ENTRY_IODIZES_6118120030788983283)],
        &[(0b10010, &ENTRY_IODIZING_930016750218813133)],
        &[(0b01001, &ENTRY_IODIZE_1306425172808849701)],
        &[(0b01001, &ENTRY_IODIZED_5589078459430909426)],
        &[(0b01001, &ENTRY_IODIZES_6118120030788983283)],
        &[(0b01001, &ENTRY_IODIZING_930016750218813133)],
        &[(0b10010, &ENTRY_IONIZABLE_2644993999701298176)],
        &[(0b10010, &ENTRY_IONIZABLER_16464484515284442321)],
        &[(0b10010, &ENTRY_IONIZABLES_8313950107455257059)],
        &[(0b10010, &ENTRY_IONIZABLEST_11814301960561543823)],
        &[(0b10010, &ENTRY_IONIZATION_8191072411043319491)],
        &[(0b10010, &ENTRY_IONIZATIONS_13158526918879542436)],
        &[(0b10010, &ENTRY_IONIZE_7165534751673675076)],
        &[(0b10010, &ENTRY_IONIZED_2589085332884313053)],
        &[(0b10010, &ENTRY_IONIZER_16865151505607853304)],
        &[(0b10010, &ENTRY_IONIZERS_17432893927149158571)],
        &[(0b10010, &ENTRY_IONIZES_10700550406719206692)],
        &[(0b10010, &ENTRY_IONIZING_6475308404816427379)],
        &[(0b10010, &ENTRY_IONIZINGS_654410480601582690)],
        &[(0b01001, &ENTRY_IONIZABLE_2644993999701298176)],
        &[(0b01001, &ENTRY_IONIZABLER_16464484515284442321)],
        &[(0b01001, &ENTRY_IONIZABLES_8313950107455257059)],
        &[(0b01001, &ENTRY_IONIZABLEST_11814301960561543823)],
        &[(0b01001, &ENTRY_IONIZATION_8191072411043319491)],
        &[(0b01001, &ENTRY_IONIZATIONS_13158526918879542436)],
        &[(0b01001, &ENTRY_IONIZE_7165534751673675076)],
        &[(0b01001, &ENTRY_IONIZED_2589085332884313053)],
        &[(0b01001, &ENTRY_IONIZES_10700550406719206692)],
        &[(0b01001, &ENTRY_IONIZING_6475308404816427379)],
        &[(0b01001, &ENTRY_IONIZINGS_654410480601582690)],
    ],
    range: 4..=9,
};

static VARS_IN_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_IN_CHILDREN),
    value: None,
};

static VARS_IN_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    Some(&VARS_INC_NODE),
    Some(&VARS_IND_NODE),
    None,
    Some(&VARS_INF_NODE),
    None,
    None,
    Some(&VARS_INI_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_INS_NODE),
    Some(&VARS_INT_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_INT_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_INT_CHILDREN),
    value: None,
};

pub static VARS_INT_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ellectualise"),
        dictgen::InsensitiveAscii("ellectualised"),
        dictgen::InsensitiveAscii("ellectualises"),
        dictgen::InsensitiveAscii("ellectualising"),
        dictgen::InsensitiveAscii("ellectualize"),
        dictgen::InsensitiveAscii("ellectualized"),
        dictgen::InsensitiveAscii("ellectualizes"),
        dictgen::InsensitiveAscii("ellectualizing"),
        dictgen::InsensitiveAscii("eriorise"),
        dictgen::InsensitiveAscii("eriorised"),
        dictgen::InsensitiveAscii("eriorises"),
        dictgen::InsensitiveAscii("eriorising"),
        dictgen::InsensitiveAscii("eriorize"),
        dictgen::InsensitiveAscii("eriorized"),
        dictgen::InsensitiveAscii("eriorizes"),
        dictgen::InsensitiveAscii("eriorizing"),
        dictgen::InsensitiveAscii("ernalisation"),
        dictgen::InsensitiveAscii("ernalisations"),
        dictgen::InsensitiveAscii("ernalise"),
        dictgen::InsensitiveAscii("ernalised"),
        dictgen::InsensitiveAscii("ernalises"),
        dictgen::InsensitiveAscii("ernalising"),
        dictgen::InsensitiveAscii("ernalization"),
        dictgen::InsensitiveAscii("ernalizations"),
        dictgen::InsensitiveAscii("ernalize"),
        dictgen::InsensitiveAscii("ernalized"),
        dictgen::InsensitiveAscii("ernalizes"),
        dictgen::InsensitiveAscii("ernalizing"),
        dictgen::InsensitiveAscii("ernationalisation"),
        dictgen::InsensitiveAscii("ernationalisations"),
        dictgen::InsensitiveAscii("ernationalise"),
        dictgen::InsensitiveAscii("ernationalised"),
        dictgen::InsensitiveAscii("ernationalises"),
        dictgen::InsensitiveAscii("ernationalising"),
        dictgen::InsensitiveAscii("ernationalization"),
        dictgen::InsensitiveAscii("ernationalizations"),
        dictgen::InsensitiveAscii("ernationalize"),
        dictgen::InsensitiveAscii("ernationalized"),
        dictgen::InsensitiveAscii("ernationalizes"),
        dictgen::InsensitiveAscii("ernationalizing"),
        dictgen::InsensitiveAscii("hrall"),
        dictgen::InsensitiveAscii("hralled"),
        dictgen::InsensitiveAscii("hralling"),
        dictgen::InsensitiveAscii("hralls"),
    ],
    values: &[
        &[(0b10010, &ENTRY_INTELLECTUALIZE_11938342110187123902)],
        &[(0b10010, &ENTRY_INTELLECTUALIZED_1369730666677628659)],
        &[(0b10010, &ENTRY_INTELLECTUALIZES_7905351319809097487)],
        &[(0b10010, &ENTRY_INTELLECTUALIZING_11651251432471897085)],
        &[(0b01001, &ENTRY_INTELLECTUALIZE_11938342110187123902)],
        &[(0b01001, &ENTRY_INTELLECTUALIZED_1369730666677628659)],
        &[(0b01001, &ENTRY_INTELLECTUALIZES_7905351319809097487)],
        &[(0b01001, &ENTRY_INTELLECTUALIZING_11651251432471897085)],
        &[(0b10010, &ENTRY_INTERIORIZE_1278621744135628260)],
        &[(0b10010, &ENTRY_INTERIORIZED_6788051806688856581)],
        &[(0b10010, &ENTRY_INTERIORIZES_7201579775546454896)],
        &[(0b10010, &ENTRY_INTERIORIZING_4906116630681746350)],
        &[(0b01001, &ENTRY_INTERIORIZE_1278621744135628260)],
        &[(0b01001, &ENTRY_INTERIORIZED_6788051806688856581)],
        &[(0b01001, &ENTRY_INTERIORIZES_7201579775546454896)],
        &[(0b01001, &ENTRY_INTERIORIZING_4906116630681746350)],
        &[(0b10010, &ENTRY_INTERNALIZATION_603288853246606634)],
        &[(0b10010, &ENTRY_INTERNALIZATIONS_5057687877137841458)],
        &[(0b10010, &ENTRY_INTERNALIZE_3793676571111920632)],
        &[(0b10010, &ENTRY_INTERNALIZED_16309550961213758253)],
        &[(0b10010, &ENTRY_INTERNALIZES_13136383420864185970)],
        &[(0b10010, &ENTRY_INTERNALIZING_13806294993771050282)],
        &[(0b01001, &ENTRY_INTERNALIZATION_603288853246606634)],
        &[(0b01001, &ENTRY_INTERNALIZATIONS_5057687877137841458)],
        &[(0b01001, &ENTRY_INTERNALIZE_3793676571111920632)],
        &[(0b01001, &ENTRY_INTERNALIZED_16309550961213758253)],
        &[(0b01001, &ENTRY_INTERNALIZES_13136383420864185970)],
        &[(0b01001, &ENTRY_INTERNALIZING_13806294993771050282)],
        &[(0b10010, &ENTRY_INTERNATIONALIZATION_6644139225428402812)],
        &[(0b10010, &ENTRY_INTERNATIONALIZATIONS_6708926163950225930)],
        &[(0b10010, &ENTRY_INTERNATIONALIZE_10844257627404265374)],
        &[(0b10010, &ENTRY_INTERNATIONALIZED_12532701823222614624)],
        &[(0b10010, &ENTRY_INTERNATIONALIZES_3638667411109828830)],
        &[(0b10010, &ENTRY_INTERNATIONALIZING_1991011473935504392)],
        &[(0b01001, &ENTRY_INTERNATIONALIZATION_6644139225428402812)],
        &[(0b01001, &ENTRY_INTERNATIONALIZATIONS_6708926163950225930)],
        &[(0b01001, &ENTRY_INTERNATIONALIZE_10844257627404265374)],
        &[(0b01001, &ENTRY_INTERNATIONALIZED_12532701823222614624)],
        &[(0b01001, &ENTRY_INTERNATIONALIZES_3638667411109828830)],
        &[(0b01001, &ENTRY_INTERNATIONALIZING_1991011473935504392)],
        &[(0b10010, &ENTRY_ENTHRALL_5942778214277993445)],
        &[(0b11010, &ENTRY_ENTHRALLED_11841948867063911915)],
        &[(0b11010, &ENTRY_ENTHRALLING_1804014087037406105)],
        &[(0b10010, &ENTRY_ENTHRALLS_4931585169072696150)],
    ],
    range: 5..=18,
};

static VARS_INS_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_INS_CHILDREN),
    value: None,
};

pub static VARS_INS_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("tal"),
        dictgen::InsensitiveAscii("tallment"),
        dictgen::InsensitiveAscii("tallments"),
        dictgen::InsensitiveAscii("talment"),
        dictgen::InsensitiveAscii("talments"),
        dictgen::InsensitiveAscii("tals"),
        dictgen::InsensitiveAscii("til"),
        dictgen::InsensitiveAscii("tils"),
        dictgen::InsensitiveAscii("titutionalisation"),
        dictgen::InsensitiveAscii("titutionalisations"),
        dictgen::InsensitiveAscii("titutionalise"),
        dictgen::InsensitiveAscii("titutionalised"),
        dictgen::InsensitiveAscii("titutionalises"),
        dictgen::InsensitiveAscii("titutionalising"),
        dictgen::InsensitiveAscii("titutionalization"),
        dictgen::InsensitiveAscii("titutionalizations"),
        dictgen::InsensitiveAscii("titutionalize"),
        dictgen::InsensitiveAscii("titutionalized"),
        dictgen::InsensitiveAscii("titutionalizes"),
        dictgen::InsensitiveAscii("titutionalizing"),
    ],
    values: &[
        &[(0b11010, &ENTRY_INSTALL_15816930015169857728)],
        &[(0b01001, &ENTRY_INSTALLMENT_12886693295291815493)],
        &[(0b01001, &ENTRY_INSTALLMENTS_12858268561173152905)],
        &[(0b11010, &ENTRY_INSTALLMENT_12886693295291815493)],
        &[(0b11010, &ENTRY_INSTALLMENTS_12858268561173152905)],
        &[(0b11010, &ENTRY_INSTALLS_3461768427562416254)],
        &[(0b11010, &ENTRY_INSTILL_818656269309790815)],
        &[(0b11010, &ENTRY_INSTILLS_5925820004112489897)],
        &[(0b10010, &ENTRY_INSTITUTIONALIZATION_16914483925074067352)],
        &[(0b10010, &ENTRY_INSTITUTIONALIZATIONS_9914961461183238934)],
        &[(0b10010, &ENTRY_INSTITUTIONALIZE_17179024303922716440)],
        &[(0b10010, &ENTRY_INSTITUTIONALIZED_7693436138088669527)],
        &[(0b10010, &ENTRY_INSTITUTIONALIZES_14636735774131912950)],
        &[(0b10010, &ENTRY_INSTITUTIONALIZING_16851706637198417031)],
        &[(0b01001, &ENTRY_INSTITUTIONALIZATION_16914483925074067352)],
        &[(0b01001, &ENTRY_INSTITUTIONALIZATIONS_9914961461183238934)],
        &[(0b01001, &ENTRY_INSTITUTIONALIZE_17179024303922716440)],
        &[(0b01001, &ENTRY_INSTITUTIONALIZED_7693436138088669527)],
        &[(0b01001, &ENTRY_INSTITUTIONALIZES_14636735774131912950)],
        &[(0b01001, &ENTRY_INSTITUTIONALIZING_16851706637198417031)],
    ],
    range: 3..=18,
};

static VARS_INI_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_INI_CHILDREN),
    value: None,
};

pub static VARS_INI_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("tialed"),
        dictgen::InsensitiveAscii("tialing"),
        dictgen::InsensitiveAscii("tialisation"),
        dictgen::InsensitiveAscii("tialisations"),
        dictgen::InsensitiveAscii("tialise"),
        dictgen::InsensitiveAscii("tialised"),
        dictgen::InsensitiveAscii("tialises"),
        dictgen::InsensitiveAscii("tialising"),
        dictgen::InsensitiveAscii("tialization"),
        dictgen::InsensitiveAscii("tializations"),
        dictgen::InsensitiveAscii("tialize"),
        dictgen::InsensitiveAscii("tialized"),
        dictgen::InsensitiveAscii("tializes"),
        dictgen::InsensitiveAscii("tializing"),
        dictgen::InsensitiveAscii("tialled"),
        dictgen::InsensitiveAscii("tialling"),
    ],
    values: &[
        &[(0b01001, &ENTRY_INITIALED_15902103209860719864)],
        &[(0b01001, &ENTRY_INITIALING_12788057999224789960)],
        &[(0b10010, &ENTRY_INITIALIZATION_590649834113769182)],
        &[(0b10010, &ENTRY_INITIALIZATIONS_11293364423346468549)],
        &[(0b10010, &ENTRY_INITIALIZE_12324019979030561655)],
        &[(0b10010, &ENTRY_INITIALIZED_15301195923117397100)],
        &[(0b10010, &ENTRY_INITIALIZES_18102819297915065203)],
        &[(0b10010, &ENTRY_INITIALIZING_12464707441303468819)],
        &[(0b01001, &ENTRY_INITIALIZATION_590649834113769182)],
        &[(0b01001, &ENTRY_INITIALIZATIONS_11293364423346468549)],
        &[(0b01001, &ENTRY_INITIALIZE_12324019979030561655)],
        &[(0b01001, &ENTRY_INITIALIZED_15301195923117397100)],
        &[(0b01001, &ENTRY_INITIALIZES_18102819297915065203)],
        &[(0b01001, &ENTRY_INITIALIZING_12464707441303468819)],
        &[(0b11010, &ENTRY_INITIALED_15902103209860719864)],
        &[(0b11010, &ENTRY_INITIALING_12788057999224789960)],
    ],
    range: 6..=12,
};

static VARS_INF_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_INF_CHILDREN),
    value: None,
};

pub static VARS_INF_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("lexion"),
        dictgen::InsensitiveAscii("lexions"),
    ],
    values: &[
        &[(0b10010, &ENTRY_INFLECTION_18277295203675481446)],
        &[(0b10010, &ENTRY_INFLECTIONS_16947371245746328476)],
    ],
    range: 6..=7,
};

static VARS_IND_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_IND_CHILDREN),
    value: None,
};

pub static VARS_IND_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ianisation"),
        dictgen::InsensitiveAscii("ianise"),
        dictgen::InsensitiveAscii("ianised"),
        dictgen::InsensitiveAscii("ianises"),
        dictgen::InsensitiveAscii("ianising"),
        dictgen::InsensitiveAscii("ianization"),
        dictgen::InsensitiveAscii("ianize"),
        dictgen::InsensitiveAscii("ianized"),
        dictgen::InsensitiveAscii("ianizes"),
        dictgen::InsensitiveAscii("ianizing"),
        dictgen::InsensitiveAscii("ividualisation"),
        dictgen::InsensitiveAscii("ividualisations"),
        dictgen::InsensitiveAscii("ividualise"),
        dictgen::InsensitiveAscii("ividualised"),
        dictgen::InsensitiveAscii("ividualises"),
        dictgen::InsensitiveAscii("ividualising"),
        dictgen::InsensitiveAscii("ividualization"),
        dictgen::InsensitiveAscii("ividualizations"),
        dictgen::InsensitiveAscii("ividualize"),
        dictgen::InsensitiveAscii("ividualized"),
        dictgen::InsensitiveAscii("ividualizes"),
        dictgen::InsensitiveAscii("ividualizing"),
        dictgen::InsensitiveAscii("raft"),
        dictgen::InsensitiveAscii("rafts"),
        dictgen::InsensitiveAscii("raught"),
        dictgen::InsensitiveAscii("raughts"),
        dictgen::InsensitiveAscii("ustrialisation"),
        dictgen::InsensitiveAscii("ustrialisations"),
        dictgen::InsensitiveAscii("ustrialise"),
        dictgen::InsensitiveAscii("ustrialised"),
        dictgen::InsensitiveAscii("ustrialises"),
        dictgen::InsensitiveAscii("ustrialising"),
        dictgen::InsensitiveAscii("ustrialization"),
        dictgen::InsensitiveAscii("ustrializations"),
        dictgen::InsensitiveAscii("ustrialize"),
        dictgen::InsensitiveAscii("ustrialized"),
        dictgen::InsensitiveAscii("ustrializes"),
        dictgen::InsensitiveAscii("ustrializing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_INDIANIZATION_1716413238822798201)],
        &[(0b10010, &ENTRY_INDIANIZE_15318260537100967280)],
        &[(0b10010, &ENTRY_INDIANIZED_6681655339922669663)],
        &[(0b10010, &ENTRY_INDIANIZES_451682467374866405)],
        &[(0b10010, &ENTRY_INDIANIZING_17001518438969414024)],
        &[(0b01001, &ENTRY_INDIANIZATION_1716413238822798201)],
        &[(0b01001, &ENTRY_INDIANIZE_15318260537100967280)],
        &[(0b01001, &ENTRY_INDIANIZED_6681655339922669663)],
        &[(0b01001, &ENTRY_INDIANIZES_451682467374866405)],
        &[(0b01001, &ENTRY_INDIANIZING_17001518438969414024)],
        &[(0b10010, &ENTRY_INDIVIDUALIZATION_12161892009800116926)],
        &[(0b10010, &ENTRY_INDIVIDUALIZATIONS_16008274701567236397)],
        &[(0b10010, &ENTRY_INDIVIDUALIZE_14128117353720123820)],
        &[(0b10010, &ENTRY_INDIVIDUALIZED_12615286571022762701)],
        &[(0b10010, &ENTRY_INDIVIDUALIZES_5313824086917745418)],
        &[(0b10010, &ENTRY_INDIVIDUALIZING_15464150109564265891)],
        &[(0b01001, &ENTRY_INDIVIDUALIZATION_12161892009800116926)],
        &[(0b01001, &ENTRY_INDIVIDUALIZATIONS_16008274701567236397)],
        &[(0b01001, &ENTRY_INDIVIDUALIZE_14128117353720123820)],
        &[(0b01001, &ENTRY_INDIVIDUALIZED_12615286571022762701)],
        &[(0b01001, &ENTRY_INDIVIDUALIZES_5313824086917745418)],
        &[(0b01001, &ENTRY_INDIVIDUALIZING_15464150109564265891)],
        &[(0b01001, &ENTRY_INDRAFT_1882858010909385258)],
        &[(0b01001, &ENTRY_INDRAFTS_9423407568172028790)],
        &[(0b10010, &ENTRY_INDRAFT_1882858010909385258)],
        &[(0b10010, &ENTRY_INDRAFTS_9423407568172028790)],
        &[(0b10010, &ENTRY_INDUSTRIALIZATION_350753450895865005)],
        &[(0b10010, &ENTRY_INDUSTRIALIZATIONS_17597998929798495645)],
        &[(0b10010, &ENTRY_INDUSTRIALIZE_9725131420784308416)],
        &[(0b10010, &ENTRY_INDUSTRIALIZED_9347966852221416739)],
        &[(0b10010, &ENTRY_INDUSTRIALIZES_17591656646172403685)],
        &[(0b10010, &ENTRY_INDUSTRIALIZING_3256987218630221135)],
        &[(0b01001, &ENTRY_INDUSTRIALIZATION_350753450895865005)],
        &[(0b01001, &ENTRY_INDUSTRIALIZATIONS_17597998929798495645)],
        &[(0b01001, &ENTRY_INDUSTRIALIZE_9725131420784308416)],
        &[(0b01001, &ENTRY_INDUSTRIALIZED_9347966852221416739)],
        &[(0b01001, &ENTRY_INDUSTRIALIZES_17591656646172403685)],
        &[(0b01001, &ENTRY_INDUSTRIALIZING_3256987218630221135)],
    ],
    range: 4..=15,
};

static VARS_INC_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_INC_CHILDREN),
    value: None,
};

pub static VARS_INC_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("entivise"),
        dictgen::InsensitiveAscii("entivised"),
        dictgen::InsensitiveAscii("entivises"),
        dictgen::InsensitiveAscii("entivising"),
        dictgen::InsensitiveAscii("entivize"),
        dictgen::InsensitiveAscii("entivized"),
        dictgen::InsensitiveAscii("entivizes"),
        dictgen::InsensitiveAscii("entivizing"),
        dictgen::InsensitiveAscii("lose"),
        dictgen::InsensitiveAscii("losed"),
        dictgen::InsensitiveAscii("loses"),
        dictgen::InsensitiveAscii("losing"),
        dictgen::InsensitiveAscii("ognisant"),
        dictgen::InsensitiveAscii("ognizant"),
    ],
    values: &[
        &[(0b10010, &ENTRY_INCENTIVIZE_16078554441117960885)],
        &[(0b10010, &ENTRY_INCENTIVIZED_16632919930346554292)],
        &[(0b10010, &ENTRY_INCENTIVIZES_8999169043411056754)],
        &[(0b10010, &ENTRY_INCENTIVIZING_2171837523441254972)],
        &[(0b01001, &ENTRY_INCENTIVIZE_16078554441117960885)],
        &[(0b01001, &ENTRY_INCENTIVIZED_16632919930346554292)],
        &[(0b01001, &ENTRY_INCENTIVIZES_8999169043411056754)],
        &[(0b01001, &ENTRY_INCENTIVIZING_2171837523441254972)],
        &[(0b00001, &ENTRY_ENCLOSE_10842906381131425887)],
        &[(0b00001, &ENTRY_ENCLOSED_1563410036667921820)],
        &[(0b00001, &ENTRY_ENCLOSES_18044907393387133378)],
        &[(0b00001, &ENTRY_ENCLOSING_16339276559305482445)],
        &[(0b10010, &ENTRY_INCOGNIZANT_15888512407120483355)],
        &[(0b01001, &ENTRY_INCOGNIZANT_15888512407120483355)],
    ],
    range: 4..=10,
};

static VARS_IM_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_IM_CHILDREN),
    value: None,
};

pub static VARS_IM_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("bedment"),
        dictgen::InsensitiveAscii("bedments"),
        dictgen::InsensitiveAscii("mobilisation"),
        dictgen::InsensitiveAscii("mobilisations"),
        dictgen::InsensitiveAscii("mobilise"),
        dictgen::InsensitiveAscii("mobilised"),
        dictgen::InsensitiveAscii("mobiliser"),
        dictgen::InsensitiveAscii("mobilisers"),
        dictgen::InsensitiveAscii("mobilises"),
        dictgen::InsensitiveAscii("mobilising"),
        dictgen::InsensitiveAscii("mobilization"),
        dictgen::InsensitiveAscii("mobilizations"),
        dictgen::InsensitiveAscii("mobilize"),
        dictgen::InsensitiveAscii("mobilized"),
        dictgen::InsensitiveAscii("mobilizer"),
        dictgen::InsensitiveAscii("mobilizers"),
        dictgen::InsensitiveAscii("mobilizes"),
        dictgen::InsensitiveAscii("mobilizing"),
        dictgen::InsensitiveAscii("mortalisation"),
        dictgen::InsensitiveAscii("mortalisations"),
        dictgen::InsensitiveAscii("mortalise"),
        dictgen::InsensitiveAscii("mortalised"),
        dictgen::InsensitiveAscii("mortalises"),
        dictgen::InsensitiveAscii("mortalising"),
        dictgen::InsensitiveAscii("mortalization"),
        dictgen::InsensitiveAscii("mortalizations"),
        dictgen::InsensitiveAscii("mortalize"),
        dictgen::InsensitiveAscii("mortalized"),
        dictgen::InsensitiveAscii("mortalizes"),
        dictgen::InsensitiveAscii("mortalizing"),
        dictgen::InsensitiveAscii("munisation"),
        dictgen::InsensitiveAscii("munisations"),
        dictgen::InsensitiveAscii("munise"),
        dictgen::InsensitiveAscii("munised"),
        dictgen::InsensitiveAscii("muniser"),
        dictgen::InsensitiveAscii("munises"),
        dictgen::InsensitiveAscii("munising"),
        dictgen::InsensitiveAscii("munization"),
        dictgen::InsensitiveAscii("munizations"),
        dictgen::InsensitiveAscii("munize"),
        dictgen::InsensitiveAscii("munized"),
        dictgen::InsensitiveAscii("munizer"),
        dictgen::InsensitiveAscii("munizes"),
        dictgen::InsensitiveAscii("munizing"),
        dictgen::InsensitiveAscii("paneled"),
        dictgen::InsensitiveAscii("paneling"),
        dictgen::InsensitiveAscii("panelled"),
        dictgen::InsensitiveAscii("panelling"),
        dictgen::InsensitiveAscii("periled"),
        dictgen::InsensitiveAscii("periling"),
        dictgen::InsensitiveAscii("perilled"),
        dictgen::InsensitiveAscii("perilling"),
    ],
    values: &[
        &[(0b00001, &ENTRY_EMBEDMENT_4196454539976023920)],
        &[(0b00001, &ENTRY_EMBEDMENTS_3554420096971369231)],
        &[(0b10010, &ENTRY_IMMOBILIZATION_11535874786657183681)],
        &[(0b10010, &ENTRY_IMMOBILIZATIONS_11913395493106272461)],
        &[(0b10010, &ENTRY_IMMOBILIZE_409138148493531223)],
        &[(0b10010, &ENTRY_IMMOBILIZED_2218449348429448480)],
        &[(0b10010, &ENTRY_IMMOBILIZER_2052176910993424670)],
        &[(0b10010, &ENTRY_IMMOBILIZERS_3641715443719698453)],
        &[(0b10010, &ENTRY_IMMOBILIZES_3228156254989919907)],
        &[(0b10010, &ENTRY_IMMOBILIZING_16170310105570993627)],
        &[(0b01001, &ENTRY_IMMOBILIZATION_11535874786657183681)],
        &[(0b01001, &ENTRY_IMMOBILIZATIONS_11913395493106272461)],
        &[(0b01001, &ENTRY_IMMOBILIZE_409138148493531223)],
        &[(0b01001, &ENTRY_IMMOBILIZED_2218449348429448480)],
        &[(0b01001, &ENTRY_IMMOBILIZER_2052176910993424670)],
        &[(0b01001, &ENTRY_IMMOBILIZERS_3641715443719698453)],
        &[(0b01001, &ENTRY_IMMOBILIZES_3228156254989919907)],
        &[(0b01001, &ENTRY_IMMOBILIZING_16170310105570993627)],
        &[(0b10010, &ENTRY_IMMORTALIZATION_10488407014653410612)],
        &[(0b10010, &ENTRY_IMMORTALIZATIONS_13947110718243595455)],
        &[(0b10010, &ENTRY_IMMORTALIZE_709590795785947525)],
        &[(0b10010, &ENTRY_IMMORTALIZED_13104274410574807419)],
        &[(0b10010, &ENTRY_IMMORTALIZES_5576583787201540554)],
        &[(0b10010, &ENTRY_IMMORTALIZING_5453074279253364520)],
        &[(0b01001, &ENTRY_IMMORTALIZATION_10488407014653410612)],
        &[(0b01001, &ENTRY_IMMORTALIZATIONS_13947110718243595455)],
        &[(0b01001, &ENTRY_IMMORTALIZE_709590795785947525)],
        &[(0b01001, &ENTRY_IMMORTALIZED_13104274410574807419)],
        &[(0b01001, &ENTRY_IMMORTALIZES_5576583787201540554)],
        &[(0b01001, &ENTRY_IMMORTALIZING_5453074279253364520)],
        &[(0b10010, &ENTRY_IMMUNIZATION_41859105662498323)],
        &[(0b10010, &ENTRY_IMMUNIZATIONS_6777054902061161290)],
        &[(0b10010, &ENTRY_IMMUNIZE_7761802139818992811)],
        &[(0b10010, &ENTRY_IMMUNIZED_14708964453824556295)],
        &[(0b10010, &ENTRY_IMMUNIZER_397316735795648135)],
        &[(0b10010, &ENTRY_IMMUNIZES_4888824548752332625)],
        &[(0b10010, &ENTRY_IMMUNIZING_12247538481370716233)],
        &[(0b01001, &ENTRY_IMMUNIZATION_41859105662498323)],
        &[(0b01001, &ENTRY_IMMUNIZATIONS_6777054902061161290)],
        &[(0b01001, &ENTRY_IMMUNIZE_7761802139818992811)],
        &[(0b01001, &ENTRY_IMMUNIZED_14708964453824556295)],
        &[(0b01001, &ENTRY_IMMUNIZER_397316735795648135)],
        &[(0b01001, &ENTRY_IMMUNIZES_4888824548752332625)],
        &[(0b01001, &ENTRY_IMMUNIZING_12247538481370716233)],
        &[(0b00001, &ENTRY_IMPANELED_5408518347675931541)],
        &[(0b00001, &ENTRY_IMPANELING_2814603235256758547)],
        &[(0b11010, &ENTRY_IMPANELED_5408518347675931541)],
        &[(0b11010, &ENTRY_IMPANELING_2814603235256758547)],
        &[(0b00001, &ENTRY_IMPERILED_8444551636021682618)],
        &[(0b00001, &ENTRY_IMPERILING_4650244730518368073)],
        &[(0b11010, &ENTRY_IMPERILED_8444551636021682618)],
        &[(0b11010, &ENTRY_IMPERILING_4650244730518368073)],
    ],
    range: 6..=14,
};

static VARS_ID_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_ID_CHILDREN),
    value: None,
};

pub static VARS_ID_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ealisation"),
        dictgen::InsensitiveAscii("ealisations"),
        dictgen::InsensitiveAscii("ealise"),
        dictgen::InsensitiveAscii("ealised"),
        dictgen::InsensitiveAscii("ealises"),
        dictgen::InsensitiveAscii("ealising"),
        dictgen::InsensitiveAscii("ealization"),
        dictgen::InsensitiveAscii("ealizations"),
        dictgen::InsensitiveAscii("ealize"),
        dictgen::InsensitiveAscii("ealized"),
        dictgen::InsensitiveAscii("ealizes"),
        dictgen::InsensitiveAscii("ealizing"),
        dictgen::InsensitiveAscii("olisation"),
        dictgen::InsensitiveAscii("olisations"),
        dictgen::InsensitiveAscii("olise"),
        dictgen::InsensitiveAscii("olised"),
        dictgen::InsensitiveAscii("oliser"),
        dictgen::InsensitiveAscii("olisers"),
        dictgen::InsensitiveAscii("olises"),
        dictgen::InsensitiveAscii("olising"),
        dictgen::InsensitiveAscii("olization"),
        dictgen::InsensitiveAscii("olizations"),
        dictgen::InsensitiveAscii("olize"),
        dictgen::InsensitiveAscii("olized"),
        dictgen::InsensitiveAscii("olizer"),
        dictgen::InsensitiveAscii("olizers"),
        dictgen::InsensitiveAscii("olizes"),
        dictgen::InsensitiveAscii("olizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_IDEALIZATION_13571578580847994239)],
        &[(0b10010, &ENTRY_IDEALIZATIONS_3729750012626226945)],
        &[(0b10010, &ENTRY_IDEALIZE_10907881421979440742)],
        &[(0b10010, &ENTRY_IDEALIZED_5103962997156504752)],
        &[(0b10010, &ENTRY_IDEALIZES_17744034669185196667)],
        &[(0b10010, &ENTRY_IDEALIZING_1544218102413826617)],
        &[(0b01001, &ENTRY_IDEALIZATION_13571578580847994239)],
        &[(0b01001, &ENTRY_IDEALIZATIONS_3729750012626226945)],
        &[(0b01001, &ENTRY_IDEALIZE_10907881421979440742)],
        &[(0b01001, &ENTRY_IDEALIZED_5103962997156504752)],
        &[(0b01001, &ENTRY_IDEALIZES_17744034669185196667)],
        &[(0b01001, &ENTRY_IDEALIZING_1544218102413826617)],
        &[(0b10010, &ENTRY_IDOLIZATION_15105118948886829092)],
        &[(0b10010, &ENTRY_IDOLIZATIONS_4690624939733294253)],
        &[(0b10010, &ENTRY_IDOLIZE_8242557763652368312)],
        &[(0b10010, &ENTRY_IDOLIZED_3011013183847203085)],
        &[(0b10010, &ENTRY_IDOLIZER_6262630986106221245)],
        &[(0b10010, &ENTRY_IDOLIZERS_3155462085555547150)],
        &[(0b10010, &ENTRY_IDOLIZES_7288494209899528996)],
        &[(0b10010, &ENTRY_IDOLIZING_5172443194465202077)],
        &[(0b01001, &ENTRY_IDOLIZATION_15105118948886829092)],
        &[(0b01001, &ENTRY_IDOLIZATIONS_4690624939733294253)],
        &[(0b01001, &ENTRY_IDOLIZE_8242557763652368312)],
        &[(0b01001, &ENTRY_IDOLIZED_3011013183847203085)],
        &[(0b01001, &ENTRY_IDOLIZER_6262630986106221245)],
        &[(0b01001, &ENTRY_IDOLIZERS_3155462085555547150)],
        &[(0b01001, &ENTRY_IDOLIZES_7288494209899528996)],
        &[(0b01001, &ENTRY_IDOLIZING_5172443194465202077)],
    ],
    range: 5..=11,
};

static VARS_H_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_H_CHILDREN),
    value: None,
};

static VARS_H_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_HA_NODE),
    None,
    None,
    None,
    Some(&VARS_HE_NODE),
    None,
    None,
    None,
    Some(&VARS_HI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_HO_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_HU_NODE),
    None,
    None,
    None,
    Some(&VARS_HY_NODE),
    None,
];

static VARS_HY_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_HY_CHILDREN),
    value: None,
};

pub static VARS_HY_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("bridisable"),
        dictgen::InsensitiveAscii("bridisabler"),
        dictgen::InsensitiveAscii("bridisables"),
        dictgen::InsensitiveAscii("bridisablest"),
        dictgen::InsensitiveAscii("bridisation"),
        dictgen::InsensitiveAscii("bridisations"),
        dictgen::InsensitiveAscii("bridise"),
        dictgen::InsensitiveAscii("bridised"),
        dictgen::InsensitiveAscii("bridiser"),
        dictgen::InsensitiveAscii("bridisers"),
        dictgen::InsensitiveAscii("bridises"),
        dictgen::InsensitiveAscii("bridising"),
        dictgen::InsensitiveAscii("bridizable"),
        dictgen::InsensitiveAscii("bridizabler"),
        dictgen::InsensitiveAscii("bridizables"),
        dictgen::InsensitiveAscii("bridizablest"),
        dictgen::InsensitiveAscii("bridization"),
        dictgen::InsensitiveAscii("bridizations"),
        dictgen::InsensitiveAscii("bridize"),
        dictgen::InsensitiveAscii("bridized"),
        dictgen::InsensitiveAscii("bridizer"),
        dictgen::InsensitiveAscii("bridizers"),
        dictgen::InsensitiveAscii("bridizes"),
        dictgen::InsensitiveAscii("bridizing"),
        dictgen::InsensitiveAscii("drolyse"),
        dictgen::InsensitiveAscii("drolysed"),
        dictgen::InsensitiveAscii("drolysing"),
        dictgen::InsensitiveAscii("drolyze"),
        dictgen::InsensitiveAscii("drolyzed"),
        dictgen::InsensitiveAscii("drolyzes"),
        dictgen::InsensitiveAscii("drolyzing"),
        dictgen::InsensitiveAscii("pnotisable"),
        dictgen::InsensitiveAscii("pnotisabler"),
        dictgen::InsensitiveAscii("pnotisables"),
        dictgen::InsensitiveAscii("pnotisablest"),
        dictgen::InsensitiveAscii("pnotise"),
        dictgen::InsensitiveAscii("pnotised"),
        dictgen::InsensitiveAscii("pnotises"),
        dictgen::InsensitiveAscii("pnotising"),
        dictgen::InsensitiveAscii("pnotizable"),
        dictgen::InsensitiveAscii("pnotizabler"),
        dictgen::InsensitiveAscii("pnotizables"),
        dictgen::InsensitiveAscii("pnotizablest"),
        dictgen::InsensitiveAscii("pnotize"),
        dictgen::InsensitiveAscii("pnotized"),
        dictgen::InsensitiveAscii("pnotizes"),
        dictgen::InsensitiveAscii("pnotizing"),
        dictgen::InsensitiveAscii("pothesise"),
        dictgen::InsensitiveAscii("pothesised"),
        dictgen::InsensitiveAscii("pothesises"),
        dictgen::InsensitiveAscii("pothesising"),
        dictgen::InsensitiveAscii("pothesize"),
        dictgen::InsensitiveAscii("pothesized"),
        dictgen::InsensitiveAscii("pothesizes"),
        dictgen::InsensitiveAscii("pothesizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_HYBRIDIZABLE_15539830790317538897)],
        &[(0b10010, &ENTRY_HYBRIDIZABLER_14819123538336949488)],
        &[(0b10010, &ENTRY_HYBRIDIZABLES_17797450459897065062)],
        &[(0b10010, &ENTRY_HYBRIDIZABLEST_10233706175812001084)],
        &[(0b10010, &ENTRY_HYBRIDIZATION_4332178131605916168)],
        &[(0b10010, &ENTRY_HYBRIDIZATIONS_10283609484469810765)],
        &[(0b10010, &ENTRY_HYBRIDIZE_8248491254784836054)],
        &[(0b10010, &ENTRY_HYBRIDIZED_7034214956457758537)],
        &[(0b10010, &ENTRY_HYBRIDIZER_2748552798742818278)],
        &[(0b10010, &ENTRY_HYBRIDIZERS_7357049388164342672)],
        &[(0b10010, &ENTRY_HYBRIDIZES_5507688108918127290)],
        &[(0b10010, &ENTRY_HYBRIDIZING_1851952307355033640)],
        &[(0b01001, &ENTRY_HYBRIDIZABLE_15539830790317538897)],
        &[(0b01001, &ENTRY_HYBRIDIZABLER_14819123538336949488)],
        &[(0b01001, &ENTRY_HYBRIDIZABLES_17797450459897065062)],
        &[(0b01001, &ENTRY_HYBRIDIZABLEST_10233706175812001084)],
        &[(0b01001, &ENTRY_HYBRIDIZATION_4332178131605916168)],
        &[(0b01001, &ENTRY_HYBRIDIZATIONS_10283609484469810765)],
        &[(0b01001, &ENTRY_HYBRIDIZE_8248491254784836054)],
        &[(0b01001, &ENTRY_HYBRIDIZED_7034214956457758537)],
        &[(0b01001, &ENTRY_HYBRIDIZER_2748552798742818278)],
        &[(0b01001, &ENTRY_HYBRIDIZERS_7357049388164342672)],
        &[(0b01001, &ENTRY_HYBRIDIZES_5507688108918127290)],
        &[(0b01001, &ENTRY_HYBRIDIZING_1851952307355033640)],
        &[(0b11010, &ENTRY_HYDROLYZE_14101715282298871514)],
        &[(0b11010, &ENTRY_HYDROLYZED_13508052463277306099)],
        &[(0b11010, &ENTRY_HYDROLYZING_18045157705495274283)],
        &[(0b01001, &ENTRY_HYDROLYZE_14101715282298871514)],
        &[(0b01001, &ENTRY_HYDROLYZED_13508052463277306099)],
        &[(0b01001, &ENTRY_HYDROLYZES_1708953578311006919)],
        &[(0b01001, &ENTRY_HYDROLYZING_18045157705495274283)],
        &[(0b10010, &ENTRY_HYPNOTIZABLE_1111458195931571372)],
        &[(0b10010, &ENTRY_HYPNOTIZABLER_16475549704606191881)],
        &[(0b10010, &ENTRY_HYPNOTIZABLES_15256571692608743267)],
        &[(0b10010, &ENTRY_HYPNOTIZABLEST_570003064636075490)],
        &[(0b10010, &ENTRY_HYPNOTIZE_15259856905514903130)],
        &[(0b10010, &ENTRY_HYPNOTIZED_3155367972836581303)],
        &[(0b10010, &ENTRY_HYPNOTIZES_15369403272790064853)],
        &[(0b10010, &ENTRY_HYPNOTIZING_12709364564970055556)],
        &[(0b01001, &ENTRY_HYPNOTIZABLE_1111458195931571372)],
        &[(0b01001, &ENTRY_HYPNOTIZABLER_16475549704606191881)],
        &[(0b01001, &ENTRY_HYPNOTIZABLES_15256571692608743267)],
        &[(0b01001, &ENTRY_HYPNOTIZABLEST_570003064636075490)],
        &[(0b01001, &ENTRY_HYPNOTIZE_15259856905514903130)],
        &[(0b01001, &ENTRY_HYPNOTIZED_3155367972836581303)],
        &[(0b01001, &ENTRY_HYPNOTIZES_15369403272790064853)],
        &[(0b01001, &ENTRY_HYPNOTIZING_12709364564970055556)],
        &[(0b10010, &ENTRY_HYPOTHESIZE_3825963791328606413)],
        &[(0b10010, &ENTRY_HYPOTHESIZED_14110128970476142821)],
        &[(0b10010, &ENTRY_HYPOTHESIZES_3305988013143404614)],
        &[(0b10010, &ENTRY_HYPOTHESIZING_7325923156843990124)],
        &[(0b01001, &ENTRY_HYPOTHESIZE_3825963791328606413)],
        &[(0b01001, &ENTRY_HYPOTHESIZED_14110128970476142821)],
        &[(0b01001, &ENTRY_HYPOTHESIZES_3305988013143404614)],
        &[(0b01001, &ENTRY_HYPOTHESIZING_7325923156843990124)],
    ],
    range: 7..=12,
};

static VARS_HU_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_HU_CHILDREN),
    value: None,
};

pub static VARS_HU_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("manisation"),
        dictgen::InsensitiveAscii("manisations"),
        dictgen::InsensitiveAscii("manise"),
        dictgen::InsensitiveAscii("manised"),
        dictgen::InsensitiveAscii("manises"),
        dictgen::InsensitiveAscii("manising"),
        dictgen::InsensitiveAscii("manization"),
        dictgen::InsensitiveAscii("manizations"),
        dictgen::InsensitiveAscii("manize"),
        dictgen::InsensitiveAscii("manized"),
        dictgen::InsensitiveAscii("manizes"),
        dictgen::InsensitiveAscii("manizing"),
        dictgen::InsensitiveAscii("mor"),
        dictgen::InsensitiveAscii("mored"),
        dictgen::InsensitiveAscii("moring"),
        dictgen::InsensitiveAscii("morless"),
        dictgen::InsensitiveAscii("morlesser"),
        dictgen::InsensitiveAscii("morlessest"),
        dictgen::InsensitiveAscii("morlessness"),
        dictgen::InsensitiveAscii("morlessnesses"),
        dictgen::InsensitiveAscii("mors"),
        dictgen::InsensitiveAscii("mour"),
        dictgen::InsensitiveAscii("moured"),
        dictgen::InsensitiveAscii("mouring"),
        dictgen::InsensitiveAscii("mourless"),
        dictgen::InsensitiveAscii("mourlesser"),
        dictgen::InsensitiveAscii("mourlessest"),
        dictgen::InsensitiveAscii("mourlessness"),
        dictgen::InsensitiveAscii("mourlessnesses"),
        dictgen::InsensitiveAscii("mours"),
        dictgen::InsensitiveAscii("rrahes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_HUMANIZATION_15705527931514057427)],
        &[(0b10010, &ENTRY_HUMANIZATIONS_15582377768763436651)],
        &[(0b10010, &ENTRY_HUMANIZE_12698260631072657271)],
        &[(0b10010, &ENTRY_HUMANIZED_6176873167717917443)],
        &[(0b10010, &ENTRY_HUMANIZES_799641267605433339)],
        &[(0b10010, &ENTRY_HUMANIZING_11718797637513438180)],
        &[(0b01001, &ENTRY_HUMANIZATION_15705527931514057427)],
        &[(0b01001, &ENTRY_HUMANIZATIONS_15582377768763436651)],
        &[(0b01001, &ENTRY_HUMANIZE_12698260631072657271)],
        &[(0b01001, &ENTRY_HUMANIZED_6176873167717917443)],
        &[(0b01001, &ENTRY_HUMANIZES_799641267605433339)],
        &[(0b01001, &ENTRY_HUMANIZING_11718797637513438180)],
        &[(0b11001, &ENTRY_HUMOR_3738238959900212968)],
        &[(0b11001, &ENTRY_HUMORED_10786336881623276233)],
        &[(0b11001, &ENTRY_HUMORING_11392688200375000188)],
        &[(0b11001, &ENTRY_HUMORLESS_14939288701032885532)],
        &[(0b11001, &ENTRY_HUMORLESSER_5799000569275879062)],
        &[(0b11001, &ENTRY_HUMORLESSEST_7303152498734358734)],
        &[(0b11001, &ENTRY_HUMORLESSNESS_15579411466297936763)],
        &[(0b11001, &ENTRY_HUMORLESSNESSES_14163478094240283512)],
        &[(0b11001, &ENTRY_HUMORS_3898460867445362619)],
        &[(0b11010, &ENTRY_HUMOR_3738238959900212968)],
        &[(0b11010, &ENTRY_HUMORED_10786336881623276233)],
        &[(0b11010, &ENTRY_HUMORING_11392688200375000188)],
        &[(0b11010, &ENTRY_HUMORLESS_14939288701032885532)],
        &[(0b11010, &ENTRY_HUMORLESSER_5799000569275879062)],
        &[(0b11010, &ENTRY_HUMORLESSEST_7303152498734358734)],
        &[(0b11010, &ENTRY_HUMORLESSNESS_15579411466297936763)],
        &[(0b11010, &ENTRY_HUMORLESSNESSES_14163478094240283512)],
        &[(0b11010, &ENTRY_HUMORS_3898460867445362619)],
        &[(0b00001, &ENTRY_HURRAHS_1533032267235892768)],
    ],
    range: 3..=14,
};

static VARS_HO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_HO_CHILDREN),
    value: None,
};

static VARS_HO_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_HOM_NODE),
    Some(&VARS_HON_NODE),
    Some(&VARS_HOO_NODE),
    None,
    None,
    None,
    Some(&VARS_HOS_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_HOS_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_HOS_CHILDREN),
    value: None,
};

pub static VARS_HOS_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("pitalisation"),
        dictgen::InsensitiveAscii("pitalisations"),
        dictgen::InsensitiveAscii("pitalise"),
        dictgen::InsensitiveAscii("pitalised"),
        dictgen::InsensitiveAscii("pitalises"),
        dictgen::InsensitiveAscii("pitalising"),
        dictgen::InsensitiveAscii("pitalization"),
        dictgen::InsensitiveAscii("pitalizations"),
        dictgen::InsensitiveAscii("pitalize"),
        dictgen::InsensitiveAscii("pitalized"),
        dictgen::InsensitiveAscii("pitalizes"),
        dictgen::InsensitiveAscii("pitalizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_HOSPITALIZATION_5040452602598774204)],
        &[(0b10010, &ENTRY_HOSPITALIZATIONS_4719313081670515361)],
        &[(0b10010, &ENTRY_HOSPITALIZE_13160741346544894903)],
        &[(0b10010, &ENTRY_HOSPITALIZED_7758414069821260041)],
        &[(0b10010, &ENTRY_HOSPITALIZES_5958151208692605706)],
        &[(0b10010, &ENTRY_HOSPITALIZING_10285779206835646544)],
        &[(0b01001, &ENTRY_HOSPITALIZATION_5040452602598774204)],
        &[(0b01001, &ENTRY_HOSPITALIZATIONS_4719313081670515361)],
        &[(0b01001, &ENTRY_HOSPITALIZE_13160741346544894903)],
        &[(0b01001, &ENTRY_HOSPITALIZED_7758414069821260041)],
        &[(0b01001, &ENTRY_HOSPITALIZES_5958151208692605706)],
        &[(0b01001, &ENTRY_HOSPITALIZING_10285779206835646544)],
    ],
    range: 8..=13,
};

static VARS_HOO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_HOO_CHILDREN),
    value: None,
};

pub static VARS_HOO_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("rah"),
        dictgen::InsensitiveAscii("rahs"),
    ],
    values: &[
        &[(0b00001, &ENTRY_HURRAH_8390607640434840198)],
        &[(0b00001, &ENTRY_HURRAHS_1533032267235892768)],
    ],
    range: 3..=4,
};

static VARS_HON_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_HON_CHILDREN),
    value: None,
};

pub static VARS_HON_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("or"),
        dictgen::InsensitiveAscii("orable"),
        dictgen::InsensitiveAscii("orableness"),
        dictgen::InsensitiveAscii("orablenesses"),
        dictgen::InsensitiveAscii("orabler"),
        dictgen::InsensitiveAscii("orables"),
        dictgen::InsensitiveAscii("orablest"),
        dictgen::InsensitiveAscii("orablier"),
        dictgen::InsensitiveAscii("orablies"),
        dictgen::InsensitiveAscii("orabliest"),
        dictgen::InsensitiveAscii("orably"),
        dictgen::InsensitiveAscii("ored"),
        dictgen::InsensitiveAscii("oring"),
        dictgen::InsensitiveAscii("ors"),
        dictgen::InsensitiveAscii("our"),
        dictgen::InsensitiveAscii("ourable"),
        dictgen::InsensitiveAscii("ourableness"),
        dictgen::InsensitiveAscii("ourablenesses"),
        dictgen::InsensitiveAscii("ourabler"),
        dictgen::InsensitiveAscii("ourables"),
        dictgen::InsensitiveAscii("ourablest"),
        dictgen::InsensitiveAscii("ourablier"),
        dictgen::InsensitiveAscii("ourablies"),
        dictgen::InsensitiveAscii("ourabliest"),
        dictgen::InsensitiveAscii("ourably"),
        dictgen::InsensitiveAscii("oured"),
        dictgen::InsensitiveAscii("ouring"),
        dictgen::InsensitiveAscii("ours"),
    ],
    values: &[
        &[(0b11001, &ENTRY_HONOR_15399646154796433816)],
        &[(0b11001, &ENTRY_HONORABLE_5267590017508289195)],
        &[(0b11001, &ENTRY_HONORABLENESS_15173649896519914801)],
        &[(0b11001, &ENTRY_HONORABLENESSES_9431133268909004141)],
        &[(0b11001, &ENTRY_HONORABLER_7881684582071414508)],
        &[(0b11001, &ENTRY_HONORABLES_1953687291526751468)],
        &[(0b11001, &ENTRY_HONORABLEST_11032014460277721019)],
        &[(0b11001, &ENTRY_HONORABLIER_6189546938867907020)],
        &[(0b11001, &ENTRY_HONORABLIES_15207939272996415718)],
        &[(0b11001, &ENTRY_HONORABLIEST_12608350415220368236)],
        &[(0b11001, &ENTRY_HONORABLY_12699768841379405701)],
        &[(0b11001, &ENTRY_HONORED_11309103293723691238)],
        &[(0b11001, &ENTRY_HONORING_8233222848637053479)],
        &[(0b11001, &ENTRY_HONORS_11917319892138194792)],
        &[(0b11010, &ENTRY_HONOR_15399646154796433816)],
        &[(0b11010, &ENTRY_HONORABLE_5267590017508289195)],
        &[(0b11010, &ENTRY_HONORABLENESS_15173649896519914801)],
        &[(0b11010, &ENTRY_HONORABLENESSES_9431133268909004141)],
        &[(0b11010, &ENTRY_HONORABLER_7881684582071414508)],
        &[(0b11010, &ENTRY_HONORABLES_1953687291526751468)],
        &[(0b11010, &ENTRY_HONORABLEST_11032014460277721019)],
        &[(0b11010, &ENTRY_HONORABLIER_6189546938867907020)],
        &[(0b11010, &ENTRY_HONORABLIES_15207939272996415718)],
        &[(0b11010, &ENTRY_HONORABLIEST_12608350415220368236)],
        &[(0b11010, &ENTRY_HONORABLY_12699768841379405701)],
        &[(0b11010, &ENTRY_HONORED_11309103293723691238)],
        &[(0b11010, &ENTRY_HONORING_8233222848637053479)],
        &[(0b11010, &ENTRY_HONORS_11917319892138194792)],
    ],
    range: 2..=13,
};

static VARS_HOM_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_HOM_CHILDREN),
    value: None,
};

pub static VARS_HOM_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("oeopath"),
        dictgen::InsensitiveAscii("oeopathic"),
        dictgen::InsensitiveAscii("oeopathicer"),
        dictgen::InsensitiveAscii("oeopathicest"),
        dictgen::InsensitiveAscii("oeopathies"),
        dictgen::InsensitiveAscii("oeopaths"),
        dictgen::InsensitiveAscii("oeopathy"),
        dictgen::InsensitiveAscii("oeostatic"),
        dictgen::InsensitiveAscii("ogenisation"),
        dictgen::InsensitiveAscii("ogenisations"),
        dictgen::InsensitiveAscii("ogenise"),
        dictgen::InsensitiveAscii("ogenised"),
        dictgen::InsensitiveAscii("ogeniser"),
        dictgen::InsensitiveAscii("ogenisers"),
        dictgen::InsensitiveAscii("ogenises"),
        dictgen::InsensitiveAscii("ogenising"),
        dictgen::InsensitiveAscii("ogenization"),
        dictgen::InsensitiveAscii("ogenizations"),
        dictgen::InsensitiveAscii("ogenize"),
        dictgen::InsensitiveAscii("ogenized"),
        dictgen::InsensitiveAscii("ogenizer"),
        dictgen::InsensitiveAscii("ogenizers"),
        dictgen::InsensitiveAscii("ogenizes"),
        dictgen::InsensitiveAscii("ogenizing"),
        dictgen::InsensitiveAscii("ologise"),
        dictgen::InsensitiveAscii("ologised"),
        dictgen::InsensitiveAscii("ologises"),
        dictgen::InsensitiveAscii("ologising"),
        dictgen::InsensitiveAscii("ologize"),
        dictgen::InsensitiveAscii("ologized"),
        dictgen::InsensitiveAscii("ologizes"),
        dictgen::InsensitiveAscii("ologizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_HOMEOPATH_5229181903591905312)],
        &[(0b10010, &ENTRY_HOMEOPATHIC_1676669387100956776)],
        &[(0b10010, &ENTRY_HOMEOPATHICER_15560122889304365087)],
        &[(0b10010, &ENTRY_HOMEOPATHICEST_13516270066115997921)],
        &[(0b10010, &ENTRY_HOMEOPATHIES_2232350069189750480)],
        &[(0b10010, &ENTRY_HOMEOPATHS_4695543130932217571)],
        &[(0b10010, &ENTRY_HOMEOPATHY_72053453141065048)],
        &[(0b11010, &ENTRY_HOMEOSTATIC_16235185197438287529)],
        &[(0b10010, &ENTRY_HOMOGENIZATION_4287750092569292868)],
        &[(0b10010, &ENTRY_HOMOGENIZATIONS_17792406420314111467)],
        &[(0b10010, &ENTRY_HOMOGENIZE_2370634469192321173)],
        &[(0b10010, &ENTRY_HOMOGENIZED_1883548529710793939)],
        &[(0b10010, &ENTRY_HOMOGENIZER_15311593186707876916)],
        &[(0b10010, &ENTRY_HOMOGENIZERS_5505783736797997695)],
        &[(0b10010, &ENTRY_HOMOGENIZES_13436650567116217979)],
        &[(0b10010, &ENTRY_HOMOGENIZING_12711102365188412108)],
        &[(0b01001, &ENTRY_HOMOGENIZATION_4287750092569292868)],
        &[(0b01001, &ENTRY_HOMOGENIZATIONS_17792406420314111467)],
        &[(0b01001, &ENTRY_HOMOGENIZE_2370634469192321173)],
        &[(0b01001, &ENTRY_HOMOGENIZED_1883548529710793939)],
        &[(0b01001, &ENTRY_HOMOGENIZER_15311593186707876916)],
        &[(0b01001, &ENTRY_HOMOGENIZERS_5505783736797997695)],
        &[(0b01001, &ENTRY_HOMOGENIZES_13436650567116217979)],
        &[(0b01001, &ENTRY_HOMOGENIZING_12711102365188412108)],
        &[(0b10010, &ENTRY_HOMOLOGIZE_11175870910521621561)],
        &[(0b10010, &ENTRY_HOMOLOGIZED_14063866540046840119)],
        &[(0b10010, &ENTRY_HOMOLOGIZES_14027542917284050646)],
        &[(0b10010, &ENTRY_HOMOLOGIZING_11333343336294935163)],
        &[(0b01001, &ENTRY_HOMOLOGIZE_11175870910521621561)],
        &[(0b01001, &ENTRY_HOMOLOGIZED_14063866540046840119)],
        &[(0b01001, &ENTRY_HOMOLOGIZES_14027542917284050646)],
        &[(0b01001, &ENTRY_HOMOLOGIZING_11333343336294935163)],
    ],
    range: 7..=12,
};

static VARS_HI_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_HI_CHILDREN),
    value: None,
};

pub static VARS_HI_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ccupped"),
        dictgen::InsensitiveAscii("ccupping"),
    ],
    values: &[
        &[(0b01000, &ENTRY_HICCUPED_10125331953329560167)],
        &[(0b01000, &ENTRY_HICCUPING_14277666795637273542)],
    ],
    range: 7..=8,
};

static VARS_HE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_HE_CHILDREN),
    value: None,
};

pub static VARS_HE_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("braise"),
        dictgen::InsensitiveAscii("braised"),
        dictgen::InsensitiveAscii("braises"),
        dictgen::InsensitiveAscii("braising"),
        dictgen::InsensitiveAscii("braize"),
        dictgen::InsensitiveAscii("braized"),
        dictgen::InsensitiveAscii("braizes"),
        dictgen::InsensitiveAscii("braizing"),
        dictgen::InsensitiveAscii("ctogramme"),
        dictgen::InsensitiveAscii("ctogrammes"),
        dictgen::InsensitiveAscii("ctoliter"),
        dictgen::InsensitiveAscii("ctoliters"),
        dictgen::InsensitiveAscii("ctolitre"),
        dictgen::InsensitiveAscii("ctolitres"),
        dictgen::InsensitiveAscii("ctometer"),
        dictgen::InsensitiveAscii("ctometers"),
        dictgen::InsensitiveAscii("ctometre"),
        dictgen::InsensitiveAscii("ctometres"),
        dictgen::InsensitiveAscii("llenisation"),
        dictgen::InsensitiveAscii("llenisations"),
        dictgen::InsensitiveAscii("llenise"),
        dictgen::InsensitiveAscii("llenised"),
        dictgen::InsensitiveAscii("llenises"),
        dictgen::InsensitiveAscii("llenising"),
        dictgen::InsensitiveAscii("llenization"),
        dictgen::InsensitiveAscii("llenizations"),
        dictgen::InsensitiveAscii("llenize"),
        dictgen::InsensitiveAscii("llenized"),
        dictgen::InsensitiveAscii("llenizes"),
        dictgen::InsensitiveAscii("llenizing"),
        dictgen::InsensitiveAscii("mal"),
        dictgen::InsensitiveAscii("matite"),
        dictgen::InsensitiveAscii("matites"),
        dictgen::InsensitiveAscii("matocele"),
        dictgen::InsensitiveAscii("matologic"),
        dictgen::InsensitiveAscii("matological"),
        dictgen::InsensitiveAscii("matologies"),
        dictgen::InsensitiveAscii("matologist"),
        dictgen::InsensitiveAscii("matologists"),
        dictgen::InsensitiveAscii("matology"),
        dictgen::InsensitiveAscii("matoxylin"),
        dictgen::InsensitiveAscii("matoxylins"),
        dictgen::InsensitiveAscii("maturia"),
        dictgen::InsensitiveAscii("maturias"),
        dictgen::InsensitiveAscii("modialyses"),
        dictgen::InsensitiveAscii("modialysis"),
        dictgen::InsensitiveAscii("moglobin"),
        dictgen::InsensitiveAscii("mophilia"),
        dictgen::InsensitiveAscii("mophiliac"),
        dictgen::InsensitiveAscii("mophiliacs"),
        dictgen::InsensitiveAscii("mophilic"),
        dictgen::InsensitiveAscii("morrhage"),
        dictgen::InsensitiveAscii("morrhaged"),
        dictgen::InsensitiveAscii("morrhages"),
        dictgen::InsensitiveAscii("morrhaging"),
        dictgen::InsensitiveAscii("morrhoid"),
        dictgen::InsensitiveAscii("morrhoidal"),
        dictgen::InsensitiveAscii("morrhoids"),
    ],
    values: &[
        &[(0b10010, &ENTRY_HEBRAIZE_11806255597737775133)],
        &[(0b10010, &ENTRY_HEBRAIZED_15890797870447255830)],
        &[(0b10010, &ENTRY_HEBRAIZES_8311891020625852527)],
        &[(0b10010, &ENTRY_HEBRAIZING_6478640508596731098)],
        &[(0b01001, &ENTRY_HEBRAIZE_11806255597737775133)],
        &[(0b01001, &ENTRY_HEBRAIZED_15890797870447255830)],
        &[(0b01001, &ENTRY_HEBRAIZES_8311891020625852527)],
        &[(0b01001, &ENTRY_HEBRAIZING_6478640508596731098)],
        &[(0b10010, &ENTRY_HECTOGRAM_5003794503916308235)],
        &[(0b10010, &ENTRY_HECTOGRAMS_12165348482753150057)],
        &[(0b00001, &ENTRY_HECTOLITER_11797212009084644420)],
        &[(0b00001, &ENTRY_HECTOLITERS_10663113073214490065)],
        &[(0b11010, &ENTRY_HECTOLITER_11797212009084644420)],
        &[(0b11010, &ENTRY_HECTOLITERS_10663113073214490065)],
        &[(0b01001, &ENTRY_HECTOMETER_13063905498394725108)],
        &[(0b01001, &ENTRY_HECTOMETERS_8178246137676970270)],
        &[(0b11010, &ENTRY_HECTOMETER_13063905498394725108)],
        &[(0b11010, &ENTRY_HECTOMETERS_8178246137676970270)],
        &[(0b10010, &ENTRY_HELLENIZATION_13783607174000789408)],
        &[(0b10010, &ENTRY_HELLENIZATIONS_8710172968727451939)],
        &[(0b10010, &ENTRY_HELLENIZE_15853764160002328426)],
        &[(0b10010, &ENTRY_HELLENIZED_14906317295118144102)],
        &[(0b10010, &ENTRY_HELLENIZES_16596514924514097835)],
        &[(0b10010, &ENTRY_HELLENIZING_11296376674365030923)],
        &[(0b01001, &ENTRY_HELLENIZATION_13783607174000789408)],
        &[(0b01001, &ENTRY_HELLENIZATIONS_8710172968727451939)],
        &[(0b01001, &ENTRY_HELLENIZE_15853764160002328426)],
        &[(0b01001, &ENTRY_HELLENIZED_14906317295118144102)],
        &[(0b01001, &ENTRY_HELLENIZES_16596514924514097835)],
        &[(0b01001, &ENTRY_HELLENIZING_11296376674365030923)],
        &[(0b10001, &ENTRY_HEMAL_17441393171650814474)],
        &[(0b11001, &ENTRY_HEMATITE_14468869663106727324)],
        &[(0b11001, &ENTRY_HEMATITES_16432545135150625666)],
        &[(0b11001, &ENTRY_HEMATOCELE_1972666202637019639)],
        &[(0b11001, &ENTRY_HEMATOLOGIC_18220046089117542599)],
        &[(0b11001, &ENTRY_HEMATOLOGICAL_1312253959057451336)],
        &[(0b11001, &ENTRY_HEMATOLOGIES_16189544558993565198)],
        &[(0b11001, &ENTRY_HEMATOLOGIST_14280007862665204292)],
        &[(0b11001, &ENTRY_HEMATOLOGISTS_4782136239490629800)],
        &[(0b11001, &ENTRY_HEMATOLOGY_15238707498752205552)],
        &[(0b11001, &ENTRY_HEMATOXYLIN_6889865558698001812)],
        &[(0b11001, &ENTRY_HEMATOXYLINS_16418497755495172078)],
        &[(0b11001, &ENTRY_HEMATURIA_2017961132280396424)],
        &[(0b11001, &ENTRY_HEMATURIAS_9554717110278540795)],
        &[(0b11001, &ENTRY_HEMODIALYSES_7416791187084499531)],
        &[(0b11001, &ENTRY_HEMODIALYSIS_2356269218981689445)],
        &[(0b11001, &ENTRY_HEMOGLOBIN_7404896410383089627)],
        &[(0b11001, &ENTRY_HEMOPHILIA_7379790116520405129)],
        &[(0b11001, &ENTRY_HEMOPHILIAC_15127098181926005330)],
        &[(0b11001, &ENTRY_HEMOPHILIACS_1819791222881034020)],
        &[(0b11001, &ENTRY_HEMOPHILIC_14674123167547417778)],
        &[(0b11001, &ENTRY_HEMORRHAGE_13487833252665047802)],
        &[(0b11001, &ENTRY_HEMORRHAGED_3567508913732842236)],
        &[(0b11001, &ENTRY_HEMORRHAGES_11033424934560552856)],
        &[(0b11001, &ENTRY_HEMORRHAGING_14700849159949160924)],
        &[(0b11001, &ENTRY_HEMORRHOID_7766599523154289018)],
        &[(0b11001, &ENTRY_HEMORRHOIDAL_10501532313574976310)],
        &[(0b11001, &ENTRY_HEMORRHOIDS_13714329857736517214)],
    ],
    range: 3..=12,
};

static VARS_HA_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_HA_CHILDREN),
    value: None,
};

pub static VARS_HA_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("emal"),
        dictgen::InsensitiveAscii("ematite"),
        dictgen::InsensitiveAscii("ematites"),
        dictgen::InsensitiveAscii("ematocele"),
        dictgen::InsensitiveAscii("ematologic"),
        dictgen::InsensitiveAscii("ematological"),
        dictgen::InsensitiveAscii("ematologies"),
        dictgen::InsensitiveAscii("ematologist"),
        dictgen::InsensitiveAscii("ematologists"),
        dictgen::InsensitiveAscii("ematology"),
        dictgen::InsensitiveAscii("ematoxylin"),
        dictgen::InsensitiveAscii("ematoxylins"),
        dictgen::InsensitiveAscii("ematuria"),
        dictgen::InsensitiveAscii("ematurias"),
        dictgen::InsensitiveAscii("emodialyses"),
        dictgen::InsensitiveAscii("emodialysis"),
        dictgen::InsensitiveAscii("emoglobin"),
        dictgen::InsensitiveAscii("emophilia"),
        dictgen::InsensitiveAscii("emophiliac"),
        dictgen::InsensitiveAscii("emophiliacs"),
        dictgen::InsensitiveAscii("emophilic"),
        dictgen::InsensitiveAscii("emorrhage"),
        dictgen::InsensitiveAscii("emorrhaged"),
        dictgen::InsensitiveAscii("emorrhages"),
        dictgen::InsensitiveAscii("emorrhaging"),
        dictgen::InsensitiveAscii("emorrhoid"),
        dictgen::InsensitiveAscii("emorrhoidal"),
        dictgen::InsensitiveAscii("emorrhoids"),
        dictgen::InsensitiveAscii("rbor"),
        dictgen::InsensitiveAscii("rbored"),
        dictgen::InsensitiveAscii("rboring"),
        dictgen::InsensitiveAscii("rbors"),
        dictgen::InsensitiveAscii("rbour"),
        dictgen::InsensitiveAscii("rboured"),
        dictgen::InsensitiveAscii("rbouring"),
        dictgen::InsensitiveAscii("rbours"),
        dictgen::InsensitiveAscii("rmonisation"),
        dictgen::InsensitiveAscii("rmonisations"),
        dictgen::InsensitiveAscii("rmonise"),
        dictgen::InsensitiveAscii("rmonised"),
        dictgen::InsensitiveAscii("rmoniser"),
        dictgen::InsensitiveAscii("rmonisers"),
        dictgen::InsensitiveAscii("rmonises"),
        dictgen::InsensitiveAscii("rmonising"),
        dictgen::InsensitiveAscii("rmonization"),
        dictgen::InsensitiveAscii("rmonizations"),
        dictgen::InsensitiveAscii("rmonize"),
        dictgen::InsensitiveAscii("rmonized"),
        dictgen::InsensitiveAscii("rmonizer"),
        dictgen::InsensitiveAscii("rmonizers"),
        dictgen::InsensitiveAscii("rmonizes"),
        dictgen::InsensitiveAscii("rmonizing"),
    ],
    values: &[
        &[(0b11010, &ENTRY_HEMAL_17441393171650814474)],
        &[(0b10010, &ENTRY_HEMATITE_14468869663106727324)],
        &[(0b10010, &ENTRY_HEMATITES_16432545135150625666)],
        &[(0b10010, &ENTRY_HEMATOCELE_1972666202637019639)],
        &[(0b10010, &ENTRY_HEMATOLOGIC_18220046089117542599)],
        &[(0b10010, &ENTRY_HEMATOLOGICAL_1312253959057451336)],
        &[(0b10010, &ENTRY_HEMATOLOGIES_16189544558993565198)],
        &[(0b10010, &ENTRY_HEMATOLOGIST_14280007862665204292)],
        &[(0b10010, &ENTRY_HEMATOLOGISTS_4782136239490629800)],
        &[(0b10010, &ENTRY_HEMATOLOGY_15238707498752205552)],
        &[(0b10010, &ENTRY_HEMATOXYLIN_6889865558698001812)],
        &[(0b10010, &ENTRY_HEMATOXYLINS_16418497755495172078)],
        &[(0b10010, &ENTRY_HEMATURIA_2017961132280396424)],
        &[(0b10010, &ENTRY_HEMATURIAS_9554717110278540795)],
        &[(0b10010, &ENTRY_HEMODIALYSES_7416791187084499531)],
        &[(0b10010, &ENTRY_HEMODIALYSIS_2356269218981689445)],
        &[(0b10010, &ENTRY_HEMOGLOBIN_7404896410383089627)],
        &[(0b10010, &ENTRY_HEMOPHILIA_7379790116520405129)],
        &[(0b10010, &ENTRY_HEMOPHILIAC_15127098181926005330)],
        &[(0b10010, &ENTRY_HEMOPHILIACS_1819791222881034020)],
        &[(0b10010, &ENTRY_HEMOPHILIC_14674123167547417778)],
        &[(0b10010, &ENTRY_HEMORRHAGE_13487833252665047802)],
        &[(0b10010, &ENTRY_HEMORRHAGED_3567508913732842236)],
        &[(0b10010, &ENTRY_HEMORRHAGES_11033424934560552856)],
        &[(0b10010, &ENTRY_HEMORRHAGING_14700849159949160924)],
        &[(0b10010, &ENTRY_HEMORRHOID_7766599523154289018)],
        &[(0b10010, &ENTRY_HEMORRHOIDAL_10501532313574976310)],
        &[(0b10010, &ENTRY_HEMORRHOIDS_13714329857736517214)],
        &[(0b11001, &ENTRY_HARBOR_5806650173337038030)],
        &[(0b11001, &ENTRY_HARBORED_3058577388408571447)],
        &[(0b11001, &ENTRY_HARBORING_4045224059910485868)],
        &[(0b11001, &ENTRY_HARBORS_17563481687131959756)],
        &[(0b11010, &ENTRY_HARBOR_5806650173337038030)],
        &[(0b11010, &ENTRY_HARBORED_3058577388408571447)],
        &[(0b11010, &ENTRY_HARBORING_4045224059910485868)],
        &[(0b11010, &ENTRY_HARBORS_17563481687131959756)],
        &[(0b10010, &ENTRY_HARMONIZATION_13372020123799276914)],
        &[(0b10010, &ENTRY_HARMONIZATIONS_6188790709212492045)],
        &[(0b10010, &ENTRY_HARMONIZE_8848752875563823524)],
        &[(0b10010, &ENTRY_HARMONIZED_10072567516328574029)],
        &[(0b10010, &ENTRY_HARMONIZER_11613954086587370839)],
        &[(0b10010, &ENTRY_HARMONIZERS_7428199368959927446)],
        &[(0b10010, &ENTRY_HARMONIZES_11674618683147479548)],
        &[(0b10010, &ENTRY_HARMONIZING_15304155413238255688)],
        &[(0b01001, &ENTRY_HARMONIZATION_13372020123799276914)],
        &[(0b01001, &ENTRY_HARMONIZATIONS_6188790709212492045)],
        &[(0b01001, &ENTRY_HARMONIZE_8848752875563823524)],
        &[(0b01001, &ENTRY_HARMONIZED_10072567516328574029)],
        &[(0b01001, &ENTRY_HARMONIZER_11613954086587370839)],
        &[(0b01001, &ENTRY_HARMONIZERS_7428199368959927446)],
        &[(0b01001, &ENTRY_HARMONIZES_11674618683147479548)],
        &[(0b01001, &ENTRY_HARMONIZING_15304155413238255688)],
    ],
    range: 4..=12,
};

static VARS_G_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_G_CHILDREN),
    value: None,
};

static VARS_G_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_GA_NODE),
    None,
    None,
    None,
    Some(&VARS_GE_NODE),
    None,
    None,
    Some(&VARS_GH_NODE),
    Some(&VARS_GI_NODE),
    None,
    None,
    Some(&VARS_GL_NODE),
    None,
    None,
    Some(&VARS_GO_NODE),
    None,
    None,
    Some(&VARS_GR_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_GY_NODE),
    None,
];

static VARS_GY_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_GY_CHILDREN),
    value: None,
};

pub static VARS_GY_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("naecological"),
        dictgen::InsensitiveAscii("naecologicaler"),
        dictgen::InsensitiveAscii("naecologicalest"),
        dictgen::InsensitiveAscii("naecologicals"),
        dictgen::InsensitiveAscii("naecologies"),
        dictgen::InsensitiveAscii("naecologist"),
        dictgen::InsensitiveAscii("naecologists"),
        dictgen::InsensitiveAscii("naecology"),
        dictgen::InsensitiveAscii("naecomastia"),
        dictgen::InsensitiveAscii("naecomastias"),
        dictgen::InsensitiveAscii("necological"),
        dictgen::InsensitiveAscii("necologicaler"),
        dictgen::InsensitiveAscii("necologicalest"),
        dictgen::InsensitiveAscii("necologicals"),
        dictgen::InsensitiveAscii("necologies"),
        dictgen::InsensitiveAscii("necologist"),
        dictgen::InsensitiveAscii("necologists"),
        dictgen::InsensitiveAscii("necology"),
        dictgen::InsensitiveAscii("necomastia"),
        dictgen::InsensitiveAscii("necomastias"),
    ],
    values: &[
        &[(0b10010, &ENTRY_GYNECOLOGICAL_10068656459548202370)],
        &[(0b10010, &ENTRY_GYNECOLOGICALER_5828237580949279739)],
        &[(0b10010, &ENTRY_GYNECOLOGICALEST_11608781569016296041)],
        &[(0b10010, &ENTRY_GYNECOLOGICALS_16704040688018194960)],
        &[(0b11010, &ENTRY_GYNECOLOGIES_7633791099195262658)],
        &[(0b10010, &ENTRY_GYNECOLOGIST_2204758927405939841)],
        &[(0b10010, &ENTRY_GYNECOLOGISTS_8430092894671465244)],
        &[(0b11010, &ENTRY_GYNECOLOGY_6636046866210569760)],
        &[(0b11010, &ENTRY_GYNECOMASTIA_14330546154000297664)],
        &[(0b11010, &ENTRY_GYNECOMASTIAS_4871542087429003006)],
        &[(0b11001, &ENTRY_GYNECOLOGICAL_10068656459548202370)],
        &[(0b11001, &ENTRY_GYNECOLOGICALER_5828237580949279739)],
        &[(0b11001, &ENTRY_GYNECOLOGICALEST_11608781569016296041)],
        &[(0b11001, &ENTRY_GYNECOLOGICALS_16704040688018194960)],
        &[(0b11001, &ENTRY_GYNECOLOGIES_7633791099195262658)],
        &[(0b11001, &ENTRY_GYNECOLOGIST_2204758927405939841)],
        &[(0b11001, &ENTRY_GYNECOLOGISTS_8430092894671465244)],
        &[(0b11001, &ENTRY_GYNECOLOGY_6636046866210569760)],
        &[(0b11001, &ENTRY_GYNECOMASTIA_14330546154000297664)],
        &[(0b11001, &ENTRY_GYNECOMASTIAS_4871542087429003006)],
    ],
    range: 8..=15,
};

static VARS_GR_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_GR_CHILDREN),
    value: None,
};

pub static VARS_GR_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("aecism"),
        dictgen::InsensitiveAscii("aecisms"),
        dictgen::InsensitiveAscii("amme"),
        dictgen::InsensitiveAscii("ammes"),
        dictgen::InsensitiveAscii("aphitise"),
        dictgen::InsensitiveAscii("aphitised"),
        dictgen::InsensitiveAscii("aphitises"),
        dictgen::InsensitiveAscii("aphitising"),
        dictgen::InsensitiveAscii("aphitize"),
        dictgen::InsensitiveAscii("aphitized"),
        dictgen::InsensitiveAscii("aphitizes"),
        dictgen::InsensitiveAscii("aphitizing"),
        dictgen::InsensitiveAscii("aveled"),
        dictgen::InsensitiveAscii("aveling"),
        dictgen::InsensitiveAscii("avelled"),
        dictgen::InsensitiveAscii("avelling"),
        dictgen::InsensitiveAscii("ayed"),
        dictgen::InsensitiveAscii("ayer"),
        dictgen::InsensitiveAscii("ayest"),
        dictgen::InsensitiveAscii("aying"),
        dictgen::InsensitiveAscii("ayish"),
        dictgen::InsensitiveAscii("ayness"),
        dictgen::InsensitiveAscii("eyish"),
        dictgen::InsensitiveAscii("eyness"),
        dictgen::InsensitiveAscii("oined"),
        dictgen::InsensitiveAscii("oining"),
        dictgen::InsensitiveAscii("oveled"),
        dictgen::InsensitiveAscii("oveler"),
        dictgen::InsensitiveAscii("ovelers"),
        dictgen::InsensitiveAscii("oveling"),
        dictgen::InsensitiveAscii("ovelinglier"),
        dictgen::InsensitiveAscii("ovelingliest"),
        dictgen::InsensitiveAscii("ovelingly"),
        dictgen::InsensitiveAscii("ovelled"),
        dictgen::InsensitiveAscii("oveller"),
        dictgen::InsensitiveAscii("ovellers"),
        dictgen::InsensitiveAscii("ovelling"),
        dictgen::InsensitiveAscii("ovellinglier"),
        dictgen::InsensitiveAscii("ovellingliest"),
        dictgen::InsensitiveAscii("ovellingly"),
        dictgen::InsensitiveAscii("oyne"),
        dictgen::InsensitiveAscii("oyned"),
        dictgen::InsensitiveAscii("oynes"),
        dictgen::InsensitiveAscii("oyning"),
        dictgen::InsensitiveAscii("ueled"),
        dictgen::InsensitiveAscii("ueling"),
        dictgen::InsensitiveAscii("uelingly"),
        dictgen::InsensitiveAscii("uelings"),
        dictgen::InsensitiveAscii("uelled"),
        dictgen::InsensitiveAscii("uelling"),
        dictgen::InsensitiveAscii("uellingly"),
        dictgen::InsensitiveAscii("uellings"),
    ],
    values: &[
        &[(0b11010, &ENTRY_GRECISM_11998927259268433496)],
        &[(0b11010, &ENTRY_GRECISMS_14469374135032380871)],
        &[(0b10010, &ENTRY_GRAM_12153808189248219413)],
        &[(0b10010, &ENTRY_GRAMS_7239637483562572698)],
        &[(0b10010, &ENTRY_GRAPHITIZE_820728043344395996)],
        &[(0b10010, &ENTRY_GRAPHITIZED_6227783366697728706)],
        &[(0b10010, &ENTRY_GRAPHITIZES_4200881641591371190)],
        &[(0b10010, &ENTRY_GRAPHITIZING_8705628871531345361)],
        &[(0b01001, &ENTRY_GRAPHITIZE_820728043344395996)],
        &[(0b01001, &ENTRY_GRAPHITIZED_6227783366697728706)],
        &[(0b01001, &ENTRY_GRAPHITIZES_4200881641591371190)],
        &[(0b01001, &ENTRY_GRAPHITIZING_8705628871531345361)],
        &[(0b00001, &ENTRY_GRAVELED_2807681232939008308)],
        &[(0b00001, &ENTRY_GRAVELING_10440686553850601055)],
        &[(0b11010, &ENTRY_GRAVELED_2807681232939008308)],
        &[(0b11010, &ENTRY_GRAVELING_10440686553850601055)],
        &[(0b01001, &ENTRY_GRAYED_2126221854892912128)],
        &[(0b01001, &ENTRY_GRAYER_16353903293922225810)],
        &[(0b01001, &ENTRY_GRAYEST_9398546240809766238)],
        &[(0b01001, &ENTRY_GRAYING_17334366481873759110)],
        &[(0b00001, &ENTRY_GRAYISH_1156907900107349696)],
        &[(0b00001, &ENTRY_GRAYNESS_14336126497721340945)],
        &[(0b11010, &ENTRY_GRAYISH_1156907900107349696)],
        &[(0b11010, &ENTRY_GRAYNESS_14336126497721340945)],
        &[(0b00001, &ENTRY_GROINED_2809452461899594102)],
        &[(0b00001, &ENTRY_GROINING_7538300092747501321)],
        &[(0b01001, &ENTRY_GROVELED_11655386549337225742)],
        &[(0b00001, &ENTRY_GROVELER_17000057584571165802)],
        &[(0b00001, &ENTRY_GROVELERS_1063263311160407851)],
        &[(0b01001, &ENTRY_GROVELING_12072037399255827644)],
        &[(0b00001, &ENTRY_GROVELINGLIER_1214630554400703346)],
        &[(0b00001, &ENTRY_GROVELINGLIEST_11811119470500539386)],
        &[(0b00001, &ENTRY_GROVELINGLY_8701513157425366439)],
        &[(0b11010, &ENTRY_GROVELED_11655386549337225742)],
        &[(0b11010, &ENTRY_GROVELER_17000057584571165802)],
        &[(0b11010, &ENTRY_GROVELERS_1063263311160407851)],
        &[(0b11010, &ENTRY_GROVELING_12072037399255827644)],
        &[(0b11010, &ENTRY_GROVELINGLIER_1214630554400703346)],
        &[(0b11010, &ENTRY_GROVELINGLIEST_11811119470500539386)],
        &[(0b11010, &ENTRY_GROVELINGLY_8701513157425366439)],
        &[(0b11010, &ENTRY_GROIN_5340788760231681661)],
        &[(0b11010, &ENTRY_GROINED_2809452461899594102)],
        &[(0b11010, &ENTRY_GROINS_7022214519428560367)],
        &[(0b11010, &ENTRY_GROINING_7538300092747501321)],
        &[(0b01001, &ENTRY_GRUELED_11469179107855937094)],
        &[(0b01001, &ENTRY_GRUELING_10540189782332096170)],
        &[(0b00001, &ENTRY_GRUELINGLY_17624749743431370706)],
        &[(0b01001, &ENTRY_GRUELINGS_2606568893918528496)],
        &[(0b11010, &ENTRY_GRUELED_11469179107855937094)],
        &[(0b11010, &ENTRY_GRUELING_10540189782332096170)],
        &[(0b11010, &ENTRY_GRUELINGLY_17624749743431370706)],
        &[(0b11010, &ENTRY_GRUELINGS_2606568893918528496)],
    ],
    range: 4..=13,
};

static VARS_GO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_GO_CHILDREN),
    value: None,
};

pub static VARS_GO_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("iter"),
        dictgen::InsensitiveAscii("iters"),
        dictgen::InsensitiveAscii("itre"),
        dictgen::InsensitiveAscii("itres"),
        dictgen::InsensitiveAscii("norrhea"),
        dictgen::InsensitiveAscii("norrheal"),
        dictgen::InsensitiveAscii("norrhealer"),
        dictgen::InsensitiveAscii("norrhealest"),
        dictgen::InsensitiveAscii("norrheas"),
        dictgen::InsensitiveAscii("norrhoea"),
        dictgen::InsensitiveAscii("norrhoeal"),
        dictgen::InsensitiveAscii("norrhoealer"),
        dictgen::InsensitiveAscii("norrhoealest"),
        dictgen::InsensitiveAscii("norrhoeas"),
        dictgen::InsensitiveAscii("odby"),
        dictgen::InsensitiveAscii("odbys"),
    ],
    values: &[
        &[(0b00001, &ENTRY_GOITER_14429026844787476944)],
        &[(0b00001, &ENTRY_GOITERS_5380033633196816136)],
        &[(0b11010, &ENTRY_GOITER_14429026844787476944)],
        &[(0b11010, &ENTRY_GOITERS_5380033633196816136)],
        &[(0b11001, &ENTRY_GONORRHEA_14553002728173647424)],
        &[(0b11001, &ENTRY_GONORRHEAL_1953933058900099744)],
        &[(0b11001, &ENTRY_GONORRHEALER_6558496656666898706)],
        &[(0b11001, &ENTRY_GONORRHEALEST_7101359392395224585)],
        &[(0b11001, &ENTRY_GONORRHEAS_3200457042710401964)],
        &[(0b10010, &ENTRY_GONORRHEA_14553002728173647424)],
        &[(0b10010, &ENTRY_GONORRHEAL_1953933058900099744)],
        &[(0b10010, &ENTRY_GONORRHEALER_6558496656666898706)],
        &[(0b10010, &ENTRY_GONORRHEALEST_7101359392395224585)],
        &[(0b10010, &ENTRY_GONORRHEAS_3200457042710401964)],
        &[(0b00001, &ENTRY_GOODBYE_955015322523257602)],
        &[(0b00001, &ENTRY_GOODBYES_4328442898272974601)],
    ],
    range: 4..=12,
};

static VARS_GL_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_GL_CHILDREN),
    value: None,
};

pub static VARS_GL_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("amor"),
        dictgen::InsensitiveAscii("amored"),
        dictgen::InsensitiveAscii("amoring"),
        dictgen::InsensitiveAscii("amorisation"),
        dictgen::InsensitiveAscii("amorisations"),
        dictgen::InsensitiveAscii("amorise"),
        dictgen::InsensitiveAscii("amorised"),
        dictgen::InsensitiveAscii("amorises"),
        dictgen::InsensitiveAscii("amorising"),
        dictgen::InsensitiveAscii("amorization"),
        dictgen::InsensitiveAscii("amorizations"),
        dictgen::InsensitiveAscii("amorize"),
        dictgen::InsensitiveAscii("amorized"),
        dictgen::InsensitiveAscii("amorizes"),
        dictgen::InsensitiveAscii("amorizing"),
        dictgen::InsensitiveAscii("amors"),
        dictgen::InsensitiveAscii("amourization"),
        dictgen::InsensitiveAscii("amourize"),
        dictgen::InsensitiveAscii("amourized"),
        dictgen::InsensitiveAscii("amourizes"),
        dictgen::InsensitiveAscii("amourizing"),
        dictgen::InsensitiveAscii("amourous"),
        dictgen::InsensitiveAscii("obalisation"),
        dictgen::InsensitiveAscii("obalisations"),
        dictgen::InsensitiveAscii("obalise"),
        dictgen::InsensitiveAscii("obalised"),
        dictgen::InsensitiveAscii("obalises"),
        dictgen::InsensitiveAscii("obalising"),
        dictgen::InsensitiveAscii("obalization"),
        dictgen::InsensitiveAscii("obalizations"),
        dictgen::InsensitiveAscii("obalize"),
        dictgen::InsensitiveAscii("obalized"),
        dictgen::InsensitiveAscii("obalizes"),
        dictgen::InsensitiveAscii("obalizing"),
        dictgen::InsensitiveAscii("utaeal"),
        dictgen::InsensitiveAscii("ycerin"),
        dictgen::InsensitiveAscii("ycerins"),
    ],
    values: &[
        &[(0b11001, &ENTRY_GLAMOUR_12012756924820660610)],
        &[(0b11001, &ENTRY_GLAMOURED_12641645216907215470)],
        &[(0b11001, &ENTRY_GLAMOURING_8071112096581134588)],
        &[(0b10010, &ENTRY_GLAMORIZATION_17390559971758126451)],
        &[(0b10010, &ENTRY_GLAMORIZATIONS_11025706385369300820)],
        &[(0b10010, &ENTRY_GLAMORIZE_16872152441454086075)],
        &[(0b10010, &ENTRY_GLAMORIZED_14235641202752203193)],
        &[(0b10010, &ENTRY_GLAMORIZES_30562212031075527)],
        &[(0b10010, &ENTRY_GLAMORIZING_2022801147073053480)],
        &[(0b01001, &ENTRY_GLAMORIZATION_17390559971758126451)],
        &[(0b01001, &ENTRY_GLAMORIZATIONS_11025706385369300820)],
        &[(0b01001, &ENTRY_GLAMORIZE_16872152441454086075)],
        &[(0b01001, &ENTRY_GLAMORIZED_14235641202752203193)],
        &[(0b01001, &ENTRY_GLAMORIZES_30562212031075527)],
        &[(0b01001, &ENTRY_GLAMORIZING_2022801147073053480)],
        &[(0b11001, &ENTRY_GLAMOURS_5834129166696821991)],
        &[(0b00001, &ENTRY_GLAMORIZATION_17390559971758126451)],
        &[(0b01001, &ENTRY_GLAMORIZE_16872152441454086075)],
        &[(0b01001, &ENTRY_GLAMORIZED_14235641202752203193)],
        &[(0b01001, &ENTRY_GLAMORIZES_30562212031075527)],
        &[(0b01001, &ENTRY_GLAMORIZING_2022801147073053480)],
        &[(0b11010, &ENTRY_GLAMOROUS_16076170602432207668)],
        &[(0b10010, &ENTRY_GLOBALIZATION_12699369965025909498)],
        &[(0b10010, &ENTRY_GLOBALIZATIONS_5052956206367697156)],
        &[(0b10010, &ENTRY_GLOBALIZE_3759893079231687276)],
        &[(0b10010, &ENTRY_GLOBALIZED_6495417237922060299)],
        &[(0b10010, &ENTRY_GLOBALIZES_15478358400156150387)],
        &[(0b10010, &ENTRY_GLOBALIZING_3545733493688582389)],
        &[(0b01001, &ENTRY_GLOBALIZATION_12699369965025909498)],
        &[(0b01001, &ENTRY_GLOBALIZATIONS_5052956206367697156)],
        &[(0b01001, &ENTRY_GLOBALIZE_3759893079231687276)],
        &[(0b01001, &ENTRY_GLOBALIZED_6495417237922060299)],
        &[(0b01001, &ENTRY_GLOBALIZES_15478358400156150387)],
        &[(0b01001, &ENTRY_GLOBALIZING_3545733493688582389)],
        &[(0b11010, &ENTRY_GLUTEAL_7146771961772255008)],
        &[(0b00001, &ENTRY_GLYCERIN_6083208262382782239)],
        &[(0b00001, &ENTRY_GLYCERINS_10842297970680678300)],
    ],
    range: 4..=12,
};

static VARS_GI_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_GI_CHILDREN),
    value: None,
};

pub static VARS_GI_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("gagramme"),
        dictgen::InsensitiveAscii("gagrammes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_GIGAGRAM_7417691256052791905)],
        &[(0b10010, &ENTRY_GIGAGRAMS_13735334786282432453)],
    ],
    range: 8..=9,
};

static VARS_GH_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_GH_CHILDREN),
    value: None,
};

pub static VARS_GH_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ettoisation"),
        dictgen::InsensitiveAscii("ettoisations"),
        dictgen::InsensitiveAscii("ettoise"),
        dictgen::InsensitiveAscii("ettoised"),
        dictgen::InsensitiveAscii("ettoises"),
        dictgen::InsensitiveAscii("ettoising"),
        dictgen::InsensitiveAscii("ettoization"),
        dictgen::InsensitiveAscii("ettoizations"),
        dictgen::InsensitiveAscii("ettoize"),
        dictgen::InsensitiveAscii("ettoized"),
        dictgen::InsensitiveAscii("ettoizes"),
        dictgen::InsensitiveAscii("ettoizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_GHETTOIZATION_9347494697012841103)],
        &[(0b10010, &ENTRY_GHETTOIZATIONS_14465065685022919973)],
        &[(0b10010, &ENTRY_GHETTOIZE_3920432753121390069)],
        &[(0b10010, &ENTRY_GHETTOIZED_15432712263833756702)],
        &[(0b10010, &ENTRY_GHETTOIZES_15179150910854310387)],
        &[(0b10010, &ENTRY_GHETTOIZING_6347419295465163704)],
        &[(0b01001, &ENTRY_GHETTOIZATION_9347494697012841103)],
        &[(0b01001, &ENTRY_GHETTOIZATIONS_14465065685022919973)],
        &[(0b01001, &ENTRY_GHETTOIZE_3920432753121390069)],
        &[(0b01001, &ENTRY_GHETTOIZED_15432712263833756702)],
        &[(0b01001, &ENTRY_GHETTOIZES_15179150910854310387)],
        &[(0b01001, &ENTRY_GHETTOIZING_6347419295465163704)],
    ],
    range: 7..=12,
};

static VARS_GE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_GE_CHILDREN),
    value: None,
};

pub static VARS_GE_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("latinisation"),
        dictgen::InsensitiveAscii("latinisations"),
        dictgen::InsensitiveAscii("latinise"),
        dictgen::InsensitiveAscii("latinised"),
        dictgen::InsensitiveAscii("latinises"),
        dictgen::InsensitiveAscii("latinising"),
        dictgen::InsensitiveAscii("latinization"),
        dictgen::InsensitiveAscii("latinizations"),
        dictgen::InsensitiveAscii("latinize"),
        dictgen::InsensitiveAscii("latinized"),
        dictgen::InsensitiveAscii("latinizes"),
        dictgen::InsensitiveAscii("latinizing"),
        dictgen::InsensitiveAscii("mmologies"),
        dictgen::InsensitiveAscii("mmology"),
        dictgen::InsensitiveAscii("mologies"),
        dictgen::InsensitiveAscii("mology"),
        dictgen::InsensitiveAscii("neralisability"),
        dictgen::InsensitiveAscii("neralisable"),
        dictgen::InsensitiveAscii("neralisabler"),
        dictgen::InsensitiveAscii("neralisables"),
        dictgen::InsensitiveAscii("neralisablest"),
        dictgen::InsensitiveAscii("neralisation"),
        dictgen::InsensitiveAscii("neralisations"),
        dictgen::InsensitiveAscii("neralise"),
        dictgen::InsensitiveAscii("neralised"),
        dictgen::InsensitiveAscii("neraliser"),
        dictgen::InsensitiveAscii("neralisers"),
        dictgen::InsensitiveAscii("neralises"),
        dictgen::InsensitiveAscii("neralising"),
        dictgen::InsensitiveAscii("neralizability"),
        dictgen::InsensitiveAscii("neralizable"),
        dictgen::InsensitiveAscii("neralizabler"),
        dictgen::InsensitiveAscii("neralizables"),
        dictgen::InsensitiveAscii("neralizablest"),
        dictgen::InsensitiveAscii("neralization"),
        dictgen::InsensitiveAscii("neralizations"),
        dictgen::InsensitiveAscii("neralize"),
        dictgen::InsensitiveAscii("neralized"),
        dictgen::InsensitiveAscii("neralizer"),
        dictgen::InsensitiveAscii("neralizers"),
        dictgen::InsensitiveAscii("neralizes"),
        dictgen::InsensitiveAscii("neralizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_GELATINIZATION_10171589934060374244)],
        &[(0b10010, &ENTRY_GELATINIZATIONS_3461490016782968866)],
        &[(0b10010, &ENTRY_GELATINIZE_16970171286224203718)],
        &[(0b10010, &ENTRY_GELATINIZED_3461761477823005775)],
        &[(0b10010, &ENTRY_GELATINIZES_15322238107724094444)],
        &[(0b10010, &ENTRY_GELATINIZING_15953751603785988233)],
        &[(0b01001, &ENTRY_GELATINIZATION_10171589934060374244)],
        &[(0b01001, &ENTRY_GELATINIZATIONS_3461490016782968866)],
        &[(0b01001, &ENTRY_GELATINIZE_16970171286224203718)],
        &[(0b01001, &ENTRY_GELATINIZED_3461761477823005775)],
        &[(0b01001, &ENTRY_GELATINIZES_15322238107724094444)],
        &[(0b01001, &ENTRY_GELATINIZING_15953751603785988233)],
        &[(0b10011, &ENTRY_GEMOLOGIES_10089052264640071050)],
        &[(0b10011, &ENTRY_GEMOLOGY_6361260868768825578)],
        &[(0b01001, &ENTRY_GEMOLOGIES_10089052264640071050)],
        &[(0b01001, &ENTRY_GEMOLOGY_6361260868768825578)],
        &[(0b10010, &ENTRY_GENERALIZABILITY_14379431587366972360)],
        &[(0b10010, &ENTRY_GENERALIZABLE_18295725543642075611)],
        &[(0b10010, &ENTRY_GENERALIZABLER_18102132003690783604)],
        &[(0b10010, &ENTRY_GENERALIZABLES_154180711840966000)],
        &[(0b10010, &ENTRY_GENERALIZABLEST_11553065349222479768)],
        &[(0b10010, &ENTRY_GENERALIZATION_2013961301751158492)],
        &[(0b10010, &ENTRY_GENERALIZATIONS_2731364307838232099)],
        &[(0b10010, &ENTRY_GENERALIZE_7119013892575487093)],
        &[(0b10010, &ENTRY_GENERALIZED_7165523126062259290)],
        &[(0b10010, &ENTRY_GENERALIZER_10108415814272974359)],
        &[(0b10010, &ENTRY_GENERALIZERS_16845345421553349857)],
        &[(0b10010, &ENTRY_GENERALIZES_4170424702375409863)],
        &[(0b10010, &ENTRY_GENERALIZING_1808553508228690165)],
        &[(0b01001, &ENTRY_GENERALIZABILITY_14379431587366972360)],
        &[(0b01001, &ENTRY_GENERALIZABLE_18295725543642075611)],
        &[(0b01001, &ENTRY_GENERALIZABLER_18102132003690783604)],
        &[(0b01001, &ENTRY_GENERALIZABLES_154180711840966000)],
        &[(0b01001, &ENTRY_GENERALIZABLEST_11553065349222479768)],
        &[(0b01001, &ENTRY_GENERALIZATION_2013961301751158492)],
        &[(0b01001, &ENTRY_GENERALIZATIONS_2731364307838232099)],
        &[(0b01001, &ENTRY_GENERALIZE_7119013892575487093)],
        &[(0b01001, &ENTRY_GENERALIZED_7165523126062259290)],
        &[(0b01001, &ENTRY_GENERALIZER_10108415814272974359)],
        &[(0b01001, &ENTRY_GENERALIZERS_16845345421553349857)],
        &[(0b01001, &ENTRY_GENERALIZES_4170424702375409863)],
        &[(0b01001, &ENTRY_GENERALIZING_1808553508228690165)],
    ],
    range: 6..=14,
};

static VARS_GA_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_GA_CHILDREN),
    value: None,
};

pub static VARS_GA_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("llicise"),
        dictgen::InsensitiveAscii("llicised"),
        dictgen::InsensitiveAscii("llicises"),
        dictgen::InsensitiveAscii("llicising"),
        dictgen::InsensitiveAscii("llicize"),
        dictgen::InsensitiveAscii("llicized"),
        dictgen::InsensitiveAscii("llicizes"),
        dictgen::InsensitiveAscii("llicizing"),
        dictgen::InsensitiveAscii("lvanisation"),
        dictgen::InsensitiveAscii("lvanisations"),
        dictgen::InsensitiveAscii("lvanise"),
        dictgen::InsensitiveAscii("lvanised"),
        dictgen::InsensitiveAscii("lvaniser"),
        dictgen::InsensitiveAscii("lvanisers"),
        dictgen::InsensitiveAscii("lvanises"),
        dictgen::InsensitiveAscii("lvanising"),
        dictgen::InsensitiveAscii("lvanization"),
        dictgen::InsensitiveAscii("lvanizations"),
        dictgen::InsensitiveAscii("lvanize"),
        dictgen::InsensitiveAscii("lvanized"),
        dictgen::InsensitiveAscii("lvanizer"),
        dictgen::InsensitiveAscii("lvanizers"),
        dictgen::InsensitiveAscii("lvanizes"),
        dictgen::InsensitiveAscii("lvanizing"),
        dictgen::InsensitiveAscii("mboled"),
        dictgen::InsensitiveAscii("mboling"),
        dictgen::InsensitiveAscii("mbolled"),
        dictgen::InsensitiveAscii("mbolling"),
        dictgen::InsensitiveAscii("ol"),
        dictgen::InsensitiveAscii("olbird"),
        dictgen::InsensitiveAscii("olbirds"),
        dictgen::InsensitiveAscii("olbreak"),
        dictgen::InsensitiveAscii("olbreaks"),
        dictgen::InsensitiveAscii("oled"),
        dictgen::InsensitiveAscii("oler"),
        dictgen::InsensitiveAscii("olers"),
        dictgen::InsensitiveAscii("oling"),
        dictgen::InsensitiveAscii("ols"),
        dictgen::InsensitiveAscii("solene"),
        dictgen::InsensitiveAscii("solenes"),
        dictgen::InsensitiveAscii("sses"),
    ],
    values: &[
        &[(0b10010, &ENTRY_GALLICIZE_18203286620435437022)],
        &[(0b10010, &ENTRY_GALLICIZED_2802912364772929047)],
        &[(0b10010, &ENTRY_GALLICIZES_2239235669702708730)],
        &[(0b10010, &ENTRY_GALLICIZING_6975607554354786209)],
        &[(0b01001, &ENTRY_GALLICIZE_18203286620435437022)],
        &[(0b01001, &ENTRY_GALLICIZED_2802912364772929047)],
        &[(0b01001, &ENTRY_GALLICIZES_2239235669702708730)],
        &[(0b01001, &ENTRY_GALLICIZING_6975607554354786209)],
        &[(0b10010, &ENTRY_GALVANIZATION_5717361496948402685)],
        &[(0b10010, &ENTRY_GALVANIZATIONS_94633790537656998)],
        &[(0b10010, &ENTRY_GALVANIZE_13754138134384178626)],
        &[(0b10010, &ENTRY_GALVANIZED_6983753273153337994)],
        &[(0b10010, &ENTRY_GALVANIZER_9294868075827996057)],
        &[(0b10010, &ENTRY_GALVANIZERS_12527605368925810121)],
        &[(0b10010, &ENTRY_GALVANIZES_5332765103438806141)],
        &[(0b10010, &ENTRY_GALVANIZING_1108449218863508353)],
        &[(0b01001, &ENTRY_GALVANIZATION_5717361496948402685)],
        &[(0b01001, &ENTRY_GALVANIZATIONS_94633790537656998)],
        &[(0b01001, &ENTRY_GALVANIZE_13754138134384178626)],
        &[(0b01001, &ENTRY_GALVANIZED_6983753273153337994)],
        &[(0b01001, &ENTRY_GALVANIZER_9294868075827996057)],
        &[(0b01001, &ENTRY_GALVANIZERS_12527605368925810121)],
        &[(0b01001, &ENTRY_GALVANIZES_5332765103438806141)],
        &[(0b01001, &ENTRY_GALVANIZING_1108449218863508353)],
        &[(0b00001, &ENTRY_GAMBOLED_4664830494285802567)],
        &[(0b00001, &ENTRY_GAMBOLING_15706579681008403067)],
        &[(0b11010, &ENTRY_GAMBOLED_4664830494285802567)],
        &[(0b11010, &ENTRY_GAMBOLING_15706579681008403067)],
        &[(0b11010, &ENTRY_JAIL_9355766415908209672)],
        &[(0b11010, &ENTRY_JAILBIRD_1212632149307874383)],
        &[(0b11010, &ENTRY_JAILBIRDS_6287442130171297097)],
        &[(0b11010, &ENTRY_JAILBREAK_4699850190274924246)],
        &[(0b11010, &ENTRY_JAILBREAKS_17258526740881807361)],
        &[(0b11010, &ENTRY_JAILED_1125764234507810906)],
        &[(0b10010, &ENTRY_JAILER_16794396359446182049)],
        &[(0b10010, &ENTRY_JAILERS_15685267405324816915)],
        &[(0b11010, &ENTRY_JAILING_1957609231097707934)],
        &[(0b11010, &ENTRY_JAILS_3678144083221559157)],
        &[(0b10011, &ENTRY_GASOLINE_2174214619583348604)],
        &[(0b10011, &ENTRY_GASOLINES_1372889667055729574)],
        &[(0b00001, &ENTRY_GASES_3527587012732480671)],
    ],
    range: 2..=12,
};

static VARS_F_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_F_CHILDREN),
    value: None,
};

static VARS_F_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_FA_NODE),
    None,
    None,
    None,
    Some(&VARS_FE_NODE),
    None,
    None,
    None,
    Some(&VARS_FI_NODE),
    None,
    None,
    Some(&VARS_FL_NODE),
    None,
    None,
    Some(&VARS_FO_NODE),
    None,
    None,
    Some(&VARS_FR_NODE),
    None,
    None,
    Some(&VARS_FU_NODE),
    None,
    None,
    None,
    None,
    None,
];

static VARS_FU_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_FU_CHILDREN),
    value: None,
};

pub static VARS_FU_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("eled"),
        dictgen::InsensitiveAscii("eling"),
        dictgen::InsensitiveAscii("elled"),
        dictgen::InsensitiveAscii("elling"),
        dictgen::InsensitiveAscii("lfil"),
        dictgen::InsensitiveAscii("lfill"),
        dictgen::InsensitiveAscii("lfillment"),
        dictgen::InsensitiveAscii("lfillments"),
        dictgen::InsensitiveAscii("lfills"),
        dictgen::InsensitiveAscii("lfilment"),
        dictgen::InsensitiveAscii("lfilments"),
        dictgen::InsensitiveAscii("lfils"),
        dictgen::InsensitiveAscii("nneled"),
        dictgen::InsensitiveAscii("nneling"),
        dictgen::InsensitiveAscii("nnelled"),
        dictgen::InsensitiveAscii("nnelling"),
        dictgen::InsensitiveAscii("ror"),
        dictgen::InsensitiveAscii("rore"),
        dictgen::InsensitiveAscii("rores"),
        dictgen::InsensitiveAscii("rors"),
        dictgen::InsensitiveAscii("ze"),
        dictgen::InsensitiveAscii("zed"),
        dictgen::InsensitiveAscii("zes"),
        dictgen::InsensitiveAscii("zing"),
    ],
    values: &[
        &[(0b00001, &ENTRY_FUELED_1405501076484499618)],
        &[(0b00001, &ENTRY_FUELING_13174491634544185979)],
        &[(0b11010, &ENTRY_FUELED_1405501076484499618)],
        &[(0b11010, &ENTRY_FUELING_13174491634544185979)],
        &[(0b11010, &ENTRY_FULFILL_9378496470221325385)],
        &[(0b11001, &ENTRY_FULFILL_9378496470221325385)],
        &[(0b01001, &ENTRY_FULFILLMENT_7148807446626431675)],
        &[(0b01001, &ENTRY_FULFILLMENTS_1418454263886981690)],
        &[(0b11001, &ENTRY_FULFILLS_3570272199614377288)],
        &[(0b11010, &ENTRY_FULFILLMENT_7148807446626431675)],
        &[(0b11010, &ENTRY_FULFILLMENTS_1418454263886981690)],
        &[(0b11010, &ENTRY_FULFILLS_3570272199614377288)],
        &[(0b00001, &ENTRY_FUNNELED_12440004640602776962)],
        &[(0b00001, &ENTRY_FUNNELING_3433367811767870104)],
        &[(0b11010, &ENTRY_FUNNELED_12440004640602776962)],
        &[(0b11010, &ENTRY_FUNNELING_3433367811767870104)],
        &[(0b11001, &ENTRY_FUROR_9905139920010048702)],
        &[(0b10010, &ENTRY_FUROR_9905139920010048702)],
        &[(0b10010, &ENTRY_FURORS_11654983778967796186)],
        &[(0b11001, &ENTRY_FURORS_11654983778967796186)],
        &[(0b01001, &ENTRY_FUSE_13721350294892050426)],
        &[(0b01001, &ENTRY_FUSED_16220222527302259642)],
        &[(0b01001, &ENTRY_FUSES_6052488625673233414)],
        &[(0b01001, &ENTRY_FUSING_4402212491712141583)],
    ],
    range: 2..=10,
};

static VARS_FR_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_FR_CHILDREN),
    value: None,
};

pub static VARS_FR_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("aternisation"),
        dictgen::InsensitiveAscii("aternisations"),
        dictgen::InsensitiveAscii("aternise"),
        dictgen::InsensitiveAscii("aternised"),
        dictgen::InsensitiveAscii("aternises"),
        dictgen::InsensitiveAscii("aternising"),
        dictgen::InsensitiveAscii("aternization"),
        dictgen::InsensitiveAscii("aternizations"),
        dictgen::InsensitiveAscii("aternize"),
        dictgen::InsensitiveAscii("aternized"),
        dictgen::InsensitiveAscii("aternizes"),
        dictgen::InsensitiveAscii("aternizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_FRATERNIZATION_17491532297861507226)],
        &[(0b10010, &ENTRY_FRATERNIZATIONS_2264901292350066915)],
        &[(0b10010, &ENTRY_FRATERNIZE_6114828862653151704)],
        &[(0b10010, &ENTRY_FRATERNIZED_40843362060401503)],
        &[(0b10010, &ENTRY_FRATERNIZES_11999482520269062840)],
        &[(0b10010, &ENTRY_FRATERNIZING_17486557641907645835)],
        &[(0b01001, &ENTRY_FRATERNIZATION_17491532297861507226)],
        &[(0b01001, &ENTRY_FRATERNIZATIONS_2264901292350066915)],
        &[(0b01001, &ENTRY_FRATERNIZE_6114828862653151704)],
        &[(0b01001, &ENTRY_FRATERNIZED_40843362060401503)],
        &[(0b01001, &ENTRY_FRATERNIZES_11999482520269062840)],
        &[(0b01001, &ENTRY_FRATERNIZING_17486557641907645835)],
    ],
    range: 8..=13,
};

static VARS_FO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_FO_CHILDREN),
    value: None,
};

pub static VARS_FO_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("calisation"),
        dictgen::InsensitiveAscii("calisations"),
        dictgen::InsensitiveAscii("calise"),
        dictgen::InsensitiveAscii("calised"),
        dictgen::InsensitiveAscii("calises"),
        dictgen::InsensitiveAscii("calising"),
        dictgen::InsensitiveAscii("calization"),
        dictgen::InsensitiveAscii("calizations"),
        dictgen::InsensitiveAscii("calize"),
        dictgen::InsensitiveAscii("calized"),
        dictgen::InsensitiveAscii("calizes"),
        dictgen::InsensitiveAscii("calizing"),
        dictgen::InsensitiveAscii("etal"),
        dictgen::InsensitiveAscii("etid"),
        dictgen::InsensitiveAscii("etider"),
        dictgen::InsensitiveAscii("etidest"),
        dictgen::InsensitiveAscii("etus"),
        dictgen::InsensitiveAscii("etuses"),
        dictgen::InsensitiveAscii("gey"),
        dictgen::InsensitiveAscii("geys"),
        dictgen::InsensitiveAscii("ntanel"),
        dictgen::InsensitiveAscii("ntanels"),
        dictgen::InsensitiveAscii("rmalisation"),
        dictgen::InsensitiveAscii("rmalisations"),
        dictgen::InsensitiveAscii("rmalise"),
        dictgen::InsensitiveAscii("rmalised"),
        dictgen::InsensitiveAscii("rmalises"),
        dictgen::InsensitiveAscii("rmalising"),
        dictgen::InsensitiveAscii("rmalization"),
        dictgen::InsensitiveAscii("rmalizations"),
        dictgen::InsensitiveAscii("rmalize"),
        dictgen::InsensitiveAscii("rmalized"),
        dictgen::InsensitiveAscii("rmalizes"),
        dictgen::InsensitiveAscii("rmalizing"),
        dictgen::InsensitiveAscii("ssilisation"),
        dictgen::InsensitiveAscii("ssilisations"),
        dictgen::InsensitiveAscii("ssilise"),
        dictgen::InsensitiveAscii("ssilised"),
        dictgen::InsensitiveAscii("ssilises"),
        dictgen::InsensitiveAscii("ssilising"),
        dictgen::InsensitiveAscii("ssilization"),
        dictgen::InsensitiveAscii("ssilizations"),
        dictgen::InsensitiveAscii("ssilize"),
        dictgen::InsensitiveAscii("ssilized"),
        dictgen::InsensitiveAscii("ssilizes"),
        dictgen::InsensitiveAscii("ssilizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_FOCALIZATION_14563255569333889153)],
        &[(0b10010, &ENTRY_FOCALIZATIONS_656464172871381508)],
        &[(0b10010, &ENTRY_FOCALIZE_9001114145740139167)],
        &[(0b10010, &ENTRY_FOCALIZED_6456532754500655101)],
        &[(0b10010, &ENTRY_FOCALIZES_4692085235969656840)],
        &[(0b10010, &ENTRY_FOCALIZING_4389775854829490698)],
        &[(0b01001, &ENTRY_FOCALIZATION_14563255569333889153)],
        &[(0b01001, &ENTRY_FOCALIZATIONS_656464172871381508)],
        &[(0b01001, &ENTRY_FOCALIZE_9001114145740139167)],
        &[(0b01001, &ENTRY_FOCALIZED_6456532754500655101)],
        &[(0b01001, &ENTRY_FOCALIZES_4692085235969656840)],
        &[(0b01001, &ENTRY_FOCALIZING_4389775854829490698)],
        &[(0b10010, &ENTRY_FETAL_16307774344388919965)],
        &[(0b10010, &ENTRY_FETID_2099281485779081953)],
        &[(0b10010, &ENTRY_FETIDER_17182410576284038642)],
        &[(0b10010, &ENTRY_FETIDEST_14215422447438146768)],
        &[(0b10010, &ENTRY_FETUS_2053571947879381898)],
        &[(0b10010, &ENTRY_FETUSES_7564330503533825550)],
        &[(0b11010, &ENTRY_FOGY_7754829639070054468)],
        &[(0b11010, &ENTRY_FOGIES_5940521606153956705)],
        &[(0b00001, &ENTRY_FONTANEL_10062742686753308418)],
        &[(0b00001, &ENTRY_FONTANELS_4866743522768096750)],
        &[(0b10010, &ENTRY_FORMALIZATION_2591485126762882449)],
        &[(0b10010, &ENTRY_FORMALIZATIONS_8555578184919419751)],
        &[(0b10010, &ENTRY_FORMALIZE_1679468906044255450)],
        &[(0b10010, &ENTRY_FORMALIZED_9806599668393286541)],
        &[(0b10010, &ENTRY_FORMALIZES_15752365028447713270)],
        &[(0b10010, &ENTRY_FORMALIZING_5721392513252990643)],
        &[(0b01001, &ENTRY_FORMALIZATION_2591485126762882449)],
        &[(0b01001, &ENTRY_FORMALIZATIONS_8555578184919419751)],
        &[(0b01001, &ENTRY_FORMALIZE_1679468906044255450)],
        &[(0b01001, &ENTRY_FORMALIZED_9806599668393286541)],
        &[(0b01001, &ENTRY_FORMALIZES_15752365028447713270)],
        &[(0b01001, &ENTRY_FORMALIZING_5721392513252990643)],
        &[(0b10010, &ENTRY_FOSSILIZATION_8495765767484914666)],
        &[(0b10010, &ENTRY_FOSSILIZATIONS_13043864217790465526)],
        &[(0b10010, &ENTRY_FOSSILIZE_15956386341505137526)],
        &[(0b10010, &ENTRY_FOSSILIZED_9532911763478840886)],
        &[(0b10010, &ENTRY_FOSSILIZES_1575017333804498872)],
        &[(0b10010, &ENTRY_FOSSILIZING_12802087173792026745)],
        &[(0b01001, &ENTRY_FOSSILIZATION_8495765767484914666)],
        &[(0b01001, &ENTRY_FOSSILIZATIONS_13043864217790465526)],
        &[(0b01001, &ENTRY_FOSSILIZE_15956386341505137526)],
        &[(0b01001, &ENTRY_FOSSILIZED_9532911763478840886)],
        &[(0b01001, &ENTRY_FOSSILIZES_1575017333804498872)],
        &[(0b01001, &ENTRY_FOSSILIZING_12802087173792026745)],
    ],
    range: 3..=12,
};

static VARS_FL_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_FL_CHILDREN),
    value: None,
};

pub static VARS_FL_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("anneled"),
        dictgen::InsensitiveAscii("annelet"),
        dictgen::InsensitiveAscii("anneling"),
        dictgen::InsensitiveAscii("annelled"),
        dictgen::InsensitiveAscii("annelling"),
        dictgen::InsensitiveAscii("autist"),
        dictgen::InsensitiveAscii("autists"),
        dictgen::InsensitiveAscii("avor"),
        dictgen::InsensitiveAscii("avored"),
        dictgen::InsensitiveAscii("avorful"),
        dictgen::InsensitiveAscii("avorfuler"),
        dictgen::InsensitiveAscii("avorfulest"),
        dictgen::InsensitiveAscii("avoring"),
        dictgen::InsensitiveAscii("avorings"),
        dictgen::InsensitiveAscii("avorless"),
        dictgen::InsensitiveAscii("avorlesser"),
        dictgen::InsensitiveAscii("avorlessest"),
        dictgen::InsensitiveAscii("avors"),
        dictgen::InsensitiveAscii("avorsome"),
        dictgen::InsensitiveAscii("avorsomer"),
        dictgen::InsensitiveAscii("avorsomest"),
        dictgen::InsensitiveAscii("avour"),
        dictgen::InsensitiveAscii("avoured"),
        dictgen::InsensitiveAscii("avourful"),
        dictgen::InsensitiveAscii("avourfuler"),
        dictgen::InsensitiveAscii("avourfulest"),
        dictgen::InsensitiveAscii("avouring"),
        dictgen::InsensitiveAscii("avourings"),
        dictgen::InsensitiveAscii("avourless"),
        dictgen::InsensitiveAscii("avourlesser"),
        dictgen::InsensitiveAscii("avourlessest"),
        dictgen::InsensitiveAscii("avours"),
        dictgen::InsensitiveAscii("avoursome"),
        dictgen::InsensitiveAscii("avoursomer"),
        dictgen::InsensitiveAscii("avoursomest"),
        dictgen::InsensitiveAscii("edgeling"),
        dictgen::InsensitiveAscii("edgelings"),
        dictgen::InsensitiveAscii("uidisation"),
        dictgen::InsensitiveAscii("uidisations"),
        dictgen::InsensitiveAscii("uidise"),
        dictgen::InsensitiveAscii("uidised"),
        dictgen::InsensitiveAscii("uidises"),
        dictgen::InsensitiveAscii("uidising"),
        dictgen::InsensitiveAscii("uidization"),
        dictgen::InsensitiveAscii("uidizations"),
        dictgen::InsensitiveAscii("uidize"),
        dictgen::InsensitiveAscii("uidized"),
        dictgen::InsensitiveAscii("uidizes"),
        dictgen::InsensitiveAscii("uidizing"),
        dictgen::InsensitiveAscii("utist"),
        dictgen::InsensitiveAscii("utists"),
    ],
    values: &[
        &[(0b01001, &ENTRY_FLANNELED_3360043852230682699)],
        &[(0b00001, &ENTRY_FLANNELETTE_12069498104014004076)],
        &[(0b01001, &ENTRY_FLANNELING_4012495315920627349)],
        &[(0b11010, &ENTRY_FLANNELED_3360043852230682699)],
        &[(0b11010, &ENTRY_FLANNELING_4012495315920627349)],
        &[(0b11010, &ENTRY_FLUTIST_8416620116439104202)],
        &[(0b11010, &ENTRY_FLUTISTS_1304316840696127041)],
        &[(0b11001, &ENTRY_FLAVOR_13147746738852786676)],
        &[(0b11001, &ENTRY_FLAVORED_5627247048743299150)],
        &[(0b11001, &ENTRY_FLAVORFUL_5944085188485911509)],
        &[(0b11001, &ENTRY_FLAVORFULER_6696273803305785559)],
        &[(0b11001, &ENTRY_FLAVORFULEST_11637668202952292143)],
        &[(0b11001, &ENTRY_FLAVORING_1040976265495793448)],
        &[(0b11001, &ENTRY_FLAVORINGS_4333914468476562312)],
        &[(0b11001, &ENTRY_FLAVORLESS_11245042299561592850)],
        &[(0b11001, &ENTRY_FLAVORLESSER_6704080193000679945)],
        &[(0b11001, &ENTRY_FLAVORLESSEST_5257507821497526035)],
        &[(0b11001, &ENTRY_FLAVORS_7502432271130276472)],
        &[(0b11001, &ENTRY_FLAVORSOME_3715740836293625146)],
        &[(0b11001, &ENTRY_FLAVORSOMER_9283046503206827837)],
        &[(0b11001, &ENTRY_FLAVORSOMEST_15528669799121213414)],
        &[(0b11010, &ENTRY_FLAVOR_13147746738852786676)],
        &[(0b11010, &ENTRY_FLAVORED_5627247048743299150)],
        &[(0b11010, &ENTRY_FLAVORFUL_5944085188485911509)],
        &[(0b11010, &ENTRY_FLAVORFULER_6696273803305785559)],
        &[(0b11010, &ENTRY_FLAVORFULEST_11637668202952292143)],
        &[(0b11010, &ENTRY_FLAVORING_1040976265495793448)],
        &[(0b11010, &ENTRY_FLAVORINGS_4333914468476562312)],
        &[(0b11010, &ENTRY_FLAVORLESS_11245042299561592850)],
        &[(0b11010, &ENTRY_FLAVORLESSER_6704080193000679945)],
        &[(0b11010, &ENTRY_FLAVORLESSEST_5257507821497526035)],
        &[(0b11010, &ENTRY_FLAVORS_7502432271130276472)],
        &[(0b11010, &ENTRY_FLAVORSOME_3715740836293625146)],
        &[(0b11010, &ENTRY_FLAVORSOMER_9283046503206827837)],
        &[(0b11010, &ENTRY_FLAVORSOMEST_15528669799121213414)],
        &[(0b10011, &ENTRY_FLEDGLING_7994074526705315877)],
        &[(0b10011, &ENTRY_FLEDGLINGS_13590009262290363932)],
        &[(0b10010, &ENTRY_FLUIDIZATION_11969565540843536522)],
        &[(0b10010, &ENTRY_FLUIDIZATIONS_5389462904710287795)],
        &[(0b10010, &ENTRY_FLUIDIZE_1455252710765083915)],
        &[(0b10010, &ENTRY_FLUIDIZED_16610704945227594739)],
        &[(0b10010, &ENTRY_FLUIDIZES_406786174709282531)],
        &[(0b10010, &ENTRY_FLUIDIZING_3867188207098201511)],
        &[(0b01001, &ENTRY_FLUIDIZATION_11969565540843536522)],
        &[(0b01001, &ENTRY_FLUIDIZATIONS_5389462904710287795)],
        &[(0b01001, &ENTRY_FLUIDIZE_1455252710765083915)],
        &[(0b01001, &ENTRY_FLUIDIZED_16610704945227594739)],
        &[(0b01001, &ENTRY_FLUIDIZES_406786174709282531)],
        &[(0b01001, &ENTRY_FLUIDIZING_3867188207098201511)],
        &[(0b01001, &ENTRY_FLUTIST_8416620116439104202)],
        &[(0b01001, &ENTRY_FLUTISTS_1304316840696127041)],
    ],
    range: 4..=12,
};

static VARS_FI_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_FI_CHILDREN),
    value: None,
};

pub static VARS_FI_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ber"),
        dictgen::InsensitiveAscii("berboard"),
        dictgen::InsensitiveAscii("berboards"),
        dictgen::InsensitiveAscii("berfill"),
        dictgen::InsensitiveAscii("berfills"),
        dictgen::InsensitiveAscii("berglass"),
        dictgen::InsensitiveAscii("berglasses"),
        dictgen::InsensitiveAscii("berless"),
        dictgen::InsensitiveAscii("berlesser"),
        dictgen::InsensitiveAscii("berlessest"),
        dictgen::InsensitiveAscii("bers"),
        dictgen::InsensitiveAscii("bre"),
        dictgen::InsensitiveAscii("breboard"),
        dictgen::InsensitiveAscii("breboards"),
        dictgen::InsensitiveAscii("brefill"),
        dictgen::InsensitiveAscii("brefills"),
        dictgen::InsensitiveAscii("breglass"),
        dictgen::InsensitiveAscii("breglasses"),
        dictgen::InsensitiveAscii("breless"),
        dictgen::InsensitiveAscii("brelesser"),
        dictgen::InsensitiveAscii("brelessest"),
        dictgen::InsensitiveAscii("bres"),
        dictgen::InsensitiveAscii("ctionalisation"),
        dictgen::InsensitiveAscii("ctionalisations"),
        dictgen::InsensitiveAscii("ctionalise"),
        dictgen::InsensitiveAscii("ctionalised"),
        dictgen::InsensitiveAscii("ctionalises"),
        dictgen::InsensitiveAscii("ctionalising"),
        dictgen::InsensitiveAscii("ctionalization"),
        dictgen::InsensitiveAscii("ctionalizations"),
        dictgen::InsensitiveAscii("ctionalize"),
        dictgen::InsensitiveAscii("ctionalized"),
        dictgen::InsensitiveAscii("ctionalizes"),
        dictgen::InsensitiveAscii("ctionalizing"),
        dictgen::InsensitiveAscii("nalisation"),
        dictgen::InsensitiveAscii("nalisations"),
        dictgen::InsensitiveAscii("nalise"),
        dictgen::InsensitiveAscii("nalised"),
        dictgen::InsensitiveAscii("nalises"),
        dictgen::InsensitiveAscii("nalising"),
        dictgen::InsensitiveAscii("nalization"),
        dictgen::InsensitiveAscii("nalizations"),
        dictgen::InsensitiveAscii("nalize"),
        dictgen::InsensitiveAscii("nalized"),
        dictgen::InsensitiveAscii("nalizes"),
        dictgen::InsensitiveAscii("nalizing"),
    ],
    values: &[
        &[(0b00001, &ENTRY_FIBER_7952077420634658656)],
        &[(0b00001, &ENTRY_FIBERBOARD_9088608551824916909)],
        &[(0b00001, &ENTRY_FIBERBOARDS_12731975045296410883)],
        &[(0b00001, &ENTRY_FIBERFILL_13606310046445718422)],
        &[(0b00001, &ENTRY_FIBERFILLS_6447949254246220216)],
        &[(0b00001, &ENTRY_FIBERGLASS_7810341362649925221)],
        &[(0b00001, &ENTRY_FIBERGLASSES_3971392659490472340)],
        &[(0b00001, &ENTRY_FIBERLESS_12969055159511376893)],
        &[(0b00001, &ENTRY_FIBERLESSER_4551498916657548546)],
        &[(0b00001, &ENTRY_FIBERLESSEST_14496238235310789976)],
        &[(0b00001, &ENTRY_FIBERS_1646201480676499010)],
        &[(0b11010, &ENTRY_FIBER_7952077420634658656)],
        &[(0b11010, &ENTRY_FIBERBOARD_9088608551824916909)],
        &[(0b11010, &ENTRY_FIBERBOARDS_12731975045296410883)],
        &[(0b11010, &ENTRY_FIBERFILL_13606310046445718422)],
        &[(0b11010, &ENTRY_FIBERFILLS_6447949254246220216)],
        &[(0b11010, &ENTRY_FIBERGLASS_7810341362649925221)],
        &[(0b11010, &ENTRY_FIBERGLASSES_3971392659490472340)],
        &[(0b11010, &ENTRY_FIBERLESS_12969055159511376893)],
        &[(0b11010, &ENTRY_FIBERLESSER_4551498916657548546)],
        &[(0b11010, &ENTRY_FIBERLESSEST_14496238235310789976)],
        &[(0b11010, &ENTRY_FIBERS_1646201480676499010)],
        &[(0b10010, &ENTRY_FICTIONALIZATION_5522094113122146310)],
        &[(0b10010, &ENTRY_FICTIONALIZATIONS_14516051539943227290)],
        &[(0b10010, &ENTRY_FICTIONALIZE_16577222807187796806)],
        &[(0b10010, &ENTRY_FICTIONALIZED_15741748969425662890)],
        &[(0b10010, &ENTRY_FICTIONALIZES_13772431052894991620)],
        &[(0b10010, &ENTRY_FICTIONALIZING_1062972705175871031)],
        &[(0b01001, &ENTRY_FICTIONALIZATION_5522094113122146310)],
        &[(0b01001, &ENTRY_FICTIONALIZATIONS_14516051539943227290)],
        &[(0b01001, &ENTRY_FICTIONALIZE_16577222807187796806)],
        &[(0b01001, &ENTRY_FICTIONALIZED_15741748969425662890)],
        &[(0b01001, &ENTRY_FICTIONALIZES_13772431052894991620)],
        &[(0b01001, &ENTRY_FICTIONALIZING_1062972705175871031)],
        &[(0b10010, &ENTRY_FINALIZATION_1713663724954282799)],
        &[(0b10010, &ENTRY_FINALIZATIONS_8331454203854375513)],
        &[(0b10010, &ENTRY_FINALIZE_6361287847222643044)],
        &[(0b10010, &ENTRY_FINALIZED_12365738080071899916)],
        &[(0b10010, &ENTRY_FINALIZES_10983321682404972812)],
        &[(0b10010, &ENTRY_FINALIZING_10636713064978874210)],
        &[(0b01001, &ENTRY_FINALIZATION_1713663724954282799)],
        &[(0b01001, &ENTRY_FINALIZATIONS_8331454203854375513)],
        &[(0b01001, &ENTRY_FINALIZE_6361287847222643044)],
        &[(0b01001, &ENTRY_FINALIZED_12365738080071899916)],
        &[(0b01001, &ENTRY_FINALIZES_10983321682404972812)],
        &[(0b01001, &ENTRY_FINALIZING_10636713064978874210)],
    ],
    range: 3..=15,
};

static VARS_FE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_FE_CHILDREN),
    value: None,
};

pub static VARS_FE_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("cal"),
        dictgen::InsensitiveAscii("ces"),
        dictgen::InsensitiveAscii("deralisation"),
        dictgen::InsensitiveAscii("deralisations"),
        dictgen::InsensitiveAscii("deralise"),
        dictgen::InsensitiveAscii("deralised"),
        dictgen::InsensitiveAscii("deralises"),
        dictgen::InsensitiveAscii("deralising"),
        dictgen::InsensitiveAscii("deralization"),
        dictgen::InsensitiveAscii("deralizations"),
        dictgen::InsensitiveAscii("deralize"),
        dictgen::InsensitiveAscii("deralized"),
        dictgen::InsensitiveAscii("deralizes"),
        dictgen::InsensitiveAscii("deralizing"),
        dictgen::InsensitiveAscii("minisation"),
        dictgen::InsensitiveAscii("minisations"),
        dictgen::InsensitiveAscii("minise"),
        dictgen::InsensitiveAscii("minised"),
        dictgen::InsensitiveAscii("minises"),
        dictgen::InsensitiveAscii("minising"),
        dictgen::InsensitiveAscii("minization"),
        dictgen::InsensitiveAscii("minizations"),
        dictgen::InsensitiveAscii("minize"),
        dictgen::InsensitiveAscii("minized"),
        dictgen::InsensitiveAscii("minizes"),
        dictgen::InsensitiveAscii("minizing"),
        dictgen::InsensitiveAscii("rtilisable"),
        dictgen::InsensitiveAscii("rtilisabler"),
        dictgen::InsensitiveAscii("rtilisables"),
        dictgen::InsensitiveAscii("rtilisablest"),
        dictgen::InsensitiveAscii("rtilisation"),
        dictgen::InsensitiveAscii("rtilisations"),
        dictgen::InsensitiveAscii("rtilise"),
        dictgen::InsensitiveAscii("rtilised"),
        dictgen::InsensitiveAscii("rtiliser"),
        dictgen::InsensitiveAscii("rtilisers"),
        dictgen::InsensitiveAscii("rtilises"),
        dictgen::InsensitiveAscii("rtilising"),
        dictgen::InsensitiveAscii("rtilizable"),
        dictgen::InsensitiveAscii("rtilizabler"),
        dictgen::InsensitiveAscii("rtilizables"),
        dictgen::InsensitiveAscii("rtilizablest"),
        dictgen::InsensitiveAscii("rtilization"),
        dictgen::InsensitiveAscii("rtilizations"),
        dictgen::InsensitiveAscii("rtilize"),
        dictgen::InsensitiveAscii("rtilized"),
        dictgen::InsensitiveAscii("rtilizer"),
        dictgen::InsensitiveAscii("rtilizers"),
        dictgen::InsensitiveAscii("rtilizes"),
        dictgen::InsensitiveAscii("rtilizing"),
        dictgen::InsensitiveAscii("rvor"),
        dictgen::InsensitiveAscii("rvors"),
        dictgen::InsensitiveAscii("rvour"),
        dictgen::InsensitiveAscii("rvours"),
        dictgen::InsensitiveAscii("tich"),
        dictgen::InsensitiveAscii("tiches"),
    ],
    values: &[
        &[(0b11001, &ENTRY_FECAL_12589305345141408090)],
        &[(0b11001, &ENTRY_FECES_13271217083721614065)],
        &[(0b10010, &ENTRY_FEDERALIZATION_2930003327175764780)],
        &[(0b10010, &ENTRY_FEDERALIZATIONS_16898914644507613247)],
        &[(0b10010, &ENTRY_FEDERALIZE_2707270304365088999)],
        &[(0b10010, &ENTRY_FEDERALIZED_2097461935187515346)],
        &[(0b10010, &ENTRY_FEDERALIZES_16852170011006866629)],
        &[(0b10010, &ENTRY_FEDERALIZING_13709518621335381978)],
        &[(0b01001, &ENTRY_FEDERALIZATION_2930003327175764780)],
        &[(0b01001, &ENTRY_FEDERALIZATIONS_16898914644507613247)],
        &[(0b01001, &ENTRY_FEDERALIZE_2707270304365088999)],
        &[(0b01001, &ENTRY_FEDERALIZED_2097461935187515346)],
        &[(0b01001, &ENTRY_FEDERALIZES_16852170011006866629)],
        &[(0b01001, &ENTRY_FEDERALIZING_13709518621335381978)],
        &[(0b10010, &ENTRY_FEMINIZATION_16468029640514579744)],
        &[(0b10010, &ENTRY_FEMINIZATIONS_10686352193044586448)],
        &[(0b10010, &ENTRY_FEMINIZE_14041224965069375071)],
        &[(0b10010, &ENTRY_FEMINIZED_8252992945131834923)],
        &[(0b10010, &ENTRY_FEMINIZES_16698712700755007840)],
        &[(0b10010, &ENTRY_FEMINIZING_15919362523885018840)],
        &[(0b01001, &ENTRY_FEMINIZATION_16468029640514579744)],
        &[(0b01001, &ENTRY_FEMINIZATIONS_10686352193044586448)],
        &[(0b01001, &ENTRY_FEMINIZE_14041224965069375071)],
        &[(0b01001, &ENTRY_FEMINIZED_8252992945131834923)],
        &[(0b01001, &ENTRY_FEMINIZES_16698712700755007840)],
        &[(0b01001, &ENTRY_FEMINIZING_15919362523885018840)],
        &[(0b10010, &ENTRY_FERTILIZABLE_15315198919851330239)],
        &[(0b10010, &ENTRY_FERTILIZABLER_11059282997226454750)],
        &[(0b10010, &ENTRY_FERTILIZABLES_727447058423532709)],
        &[(0b10010, &ENTRY_FERTILIZABLEST_5310132580923675289)],
        &[(0b10010, &ENTRY_FERTILIZATION_4201619629518396111)],
        &[(0b10010, &ENTRY_FERTILIZATIONS_14053083959867550141)],
        &[(0b10010, &ENTRY_FERTILIZE_16309782255722600032)],
        &[(0b10010, &ENTRY_FERTILIZED_13008162956323771867)],
        &[(0b10010, &ENTRY_FERTILIZER_6815415387209233087)],
        &[(0b10010, &ENTRY_FERTILIZERS_10709867916374165319)],
        &[(0b10010, &ENTRY_FERTILIZES_14381177978733680135)],
        &[(0b10010, &ENTRY_FERTILIZING_11080486546218839023)],
        &[(0b01001, &ENTRY_FERTILIZABLE_15315198919851330239)],
        &[(0b01001, &ENTRY_FERTILIZABLER_11059282997226454750)],
        &[(0b01001, &ENTRY_FERTILIZABLES_727447058423532709)],
        &[(0b01001, &ENTRY_FERTILIZABLEST_5310132580923675289)],
        &[(0b01001, &ENTRY_FERTILIZATION_4201619629518396111)],
        &[(0b01001, &ENTRY_FERTILIZATIONS_14053083959867550141)],
        &[(0b01001, &ENTRY_FERTILIZE_16309782255722600032)],
        &[(0b01001, &ENTRY_FERTILIZED_13008162956323771867)],
        &[(0b01001, &ENTRY_FERTILIZER_6815415387209233087)],
        &[(0b01001, &ENTRY_FERTILIZERS_10709867916374165319)],
        &[(0b01001, &ENTRY_FERTILIZES_14381177978733680135)],
        &[(0b01001, &ENTRY_FERTILIZING_11080486546218839023)],
        &[(0b11001, &ENTRY_FERVOR_614815645528947396)],
        &[(0b11001, &ENTRY_FERVORS_6323083099093999272)],
        &[(0b11010, &ENTRY_FERVOR_614815645528947396)],
        &[(0b11010, &ENTRY_FERVORS_6323083099093999272)],
        &[(0b00001, &ENTRY_FETISH_14617370190649429983)],
        &[(0b00001, &ENTRY_FETISHES_1240063895948325551)],
    ],
    range: 3..=13,
};

static VARS_FA_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_FA_CHILDREN),
    value: None,
};

static VARS_FA_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    Some(&VARS_FAC_NODE),
    None,
    Some(&VARS_FAE_NODE),
    None,
    Some(&VARS_FAG_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_FAM_NODE),
    Some(&VARS_FAN_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_FAV_NODE),
    None,
    None,
    None,
    None,
];

static VARS_FAV_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_FAV_CHILDREN),
    value: None,
};

pub static VARS_FAV_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("or"),
        dictgen::InsensitiveAscii("orable"),
        dictgen::InsensitiveAscii("orableness"),
        dictgen::InsensitiveAscii("orablenesses"),
        dictgen::InsensitiveAscii("orabler"),
        dictgen::InsensitiveAscii("orables"),
        dictgen::InsensitiveAscii("orablest"),
        dictgen::InsensitiveAscii("orablier"),
        dictgen::InsensitiveAscii("orabliest"),
        dictgen::InsensitiveAscii("orably"),
        dictgen::InsensitiveAscii("ored"),
        dictgen::InsensitiveAscii("oreds"),
        dictgen::InsensitiveAscii("oring"),
        dictgen::InsensitiveAscii("orings"),
        dictgen::InsensitiveAscii("orite"),
        dictgen::InsensitiveAscii("oriter"),
        dictgen::InsensitiveAscii("orites"),
        dictgen::InsensitiveAscii("oritest"),
        dictgen::InsensitiveAscii("oritism"),
        dictgen::InsensitiveAscii("oritisms"),
        dictgen::InsensitiveAscii("ors"),
        dictgen::InsensitiveAscii("our"),
        dictgen::InsensitiveAscii("ourable"),
        dictgen::InsensitiveAscii("ourableness"),
        dictgen::InsensitiveAscii("ourablenesses"),
        dictgen::InsensitiveAscii("ourabler"),
        dictgen::InsensitiveAscii("ourables"),
        dictgen::InsensitiveAscii("ourablest"),
        dictgen::InsensitiveAscii("ourablier"),
        dictgen::InsensitiveAscii("ourabliest"),
        dictgen::InsensitiveAscii("ourably"),
        dictgen::InsensitiveAscii("oured"),
        dictgen::InsensitiveAscii("oureds"),
        dictgen::InsensitiveAscii("ouring"),
        dictgen::InsensitiveAscii("ourings"),
        dictgen::InsensitiveAscii("ourite"),
        dictgen::InsensitiveAscii("ouriter"),
        dictgen::InsensitiveAscii("ourites"),
        dictgen::InsensitiveAscii("ouritest"),
        dictgen::InsensitiveAscii("ouritism"),
        dictgen::InsensitiveAscii("ouritisms"),
        dictgen::InsensitiveAscii("ours"),
    ],
    values: &[
        &[(0b11001, &ENTRY_FAVOR_3275216426677362412)],
        &[(0b11001, &ENTRY_FAVORABLE_3232743289071203492)],
        &[(0b11001, &ENTRY_FAVORABLENESS_13318204817688701067)],
        &[(0b11001, &ENTRY_FAVORABLENESSES_11975449432847156038)],
        &[(0b11001, &ENTRY_FAVORABLER_1666504773214810504)],
        &[(0b11001, &ENTRY_FAVORABLES_9226020009295042529)],
        &[(0b11001, &ENTRY_FAVORABLEST_7604212844361785683)],
        &[(0b11001, &ENTRY_FAVORABLIER_9313656689589060087)],
        &[(0b11001, &ENTRY_FAVORABLIEST_14028659737830856566)],
        &[(0b11001, &ENTRY_FAVORABLY_14208254678721843327)],
        &[(0b11001, &ENTRY_FAVORED_10193433870000535406)],
        &[(0b11001, &ENTRY_FAVOREDS_2145643335759443083)],
        &[(0b11001, &ENTRY_FAVORING_10319622535862907770)],
        &[(0b11001, &ENTRY_FAVORINGS_11595257563255629951)],
        &[(0b11001, &ENTRY_FAVORITE_17454427683063934544)],
        &[(0b11001, &ENTRY_FAVORITER_13507792634611311500)],
        &[(0b11001, &ENTRY_FAVORITES_16988681338183255120)],
        &[(0b11001, &ENTRY_FAVORITEST_18081892094238130437)],
        &[(0b11001, &ENTRY_FAVORITISM_16206254464455079260)],
        &[(0b11001, &ENTRY_FAVORITISMS_1820158452140245407)],
        &[(0b11001, &ENTRY_FAVORS_3051235537214510517)],
        &[(0b11010, &ENTRY_FAVOR_3275216426677362412)],
        &[(0b11010, &ENTRY_FAVORABLE_3232743289071203492)],
        &[(0b11010, &ENTRY_FAVORABLENESS_13318204817688701067)],
        &[(0b11010, &ENTRY_FAVORABLENESSES_11975449432847156038)],
        &[(0b11010, &ENTRY_FAVORABLER_1666504773214810504)],
        &[(0b11010, &ENTRY_FAVORABLES_9226020009295042529)],
        &[(0b11010, &ENTRY_FAVORABLEST_7604212844361785683)],
        &[(0b11010, &ENTRY_FAVORABLIER_9313656689589060087)],
        &[(0b11010, &ENTRY_FAVORABLIEST_14028659737830856566)],
        &[(0b11010, &ENTRY_FAVORABLY_14208254678721843327)],
        &[(0b11010, &ENTRY_FAVORED_10193433870000535406)],
        &[(0b11010, &ENTRY_FAVOREDS_2145643335759443083)],
        &[(0b11010, &ENTRY_FAVORING_10319622535862907770)],
        &[(0b11010, &ENTRY_FAVORINGS_11595257563255629951)],
        &[(0b11010, &ENTRY_FAVORITE_17454427683063934544)],
        &[(0b11010, &ENTRY_FAVORITER_13507792634611311500)],
        &[(0b11010, &ENTRY_FAVORITES_16988681338183255120)],
        &[(0b11010, &ENTRY_FAVORITEST_18081892094238130437)],
        &[(0b11010, &ENTRY_FAVORITISM_16206254464455079260)],
        &[(0b11010, &ENTRY_FAVORITISMS_1820158452140245407)],
        &[(0b11010, &ENTRY_FAVORS_3051235537214510517)],
    ],
    range: 2..=13,
};

static VARS_FAN_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_FAN_CHILDREN),
    value: None,
};

pub static VARS_FAN_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("tasise"),
        dictgen::InsensitiveAscii("tasised"),
        dictgen::InsensitiveAscii("tasises"),
        dictgen::InsensitiveAscii("tasising"),
        dictgen::InsensitiveAscii("tasize"),
        dictgen::InsensitiveAscii("tasized"),
        dictgen::InsensitiveAscii("tasizes"),
        dictgen::InsensitiveAscii("tasizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_FANTASIZE_14080369588189172386)],
        &[(0b10010, &ENTRY_FANTASIZED_15872386699233756433)],
        &[(0b10010, &ENTRY_FANTASIZES_4908779596089212975)],
        &[(0b10010, &ENTRY_FANTASIZING_4236358014599476998)],
        &[(0b01001, &ENTRY_FANTASIZE_14080369588189172386)],
        &[(0b01001, &ENTRY_FANTASIZED_15872386699233756433)],
        &[(0b01001, &ENTRY_FANTASIZES_4908779596089212975)],
        &[(0b01001, &ENTRY_FANTASIZING_4236358014599476998)],
    ],
    range: 6..=8,
};

static VARS_FAM_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_FAM_CHILDREN),
    value: None,
};

pub static VARS_FAM_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("iliarisation"),
        dictgen::InsensitiveAscii("iliarisations"),
        dictgen::InsensitiveAscii("iliarise"),
        dictgen::InsensitiveAscii("iliarised"),
        dictgen::InsensitiveAscii("iliarises"),
        dictgen::InsensitiveAscii("iliarising"),
        dictgen::InsensitiveAscii("iliarization"),
        dictgen::InsensitiveAscii("iliarizations"),
        dictgen::InsensitiveAscii("iliarize"),
        dictgen::InsensitiveAscii("iliarized"),
        dictgen::InsensitiveAscii("iliarizes"),
        dictgen::InsensitiveAscii("iliarizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_FAMILIARIZATION_12082687538774621170)],
        &[(0b10010, &ENTRY_FAMILIARIZATIONS_12640437606890487270)],
        &[(0b10010, &ENTRY_FAMILIARIZE_6242156019669273444)],
        &[(0b10010, &ENTRY_FAMILIARIZED_15024414515945758936)],
        &[(0b10010, &ENTRY_FAMILIARIZES_17026717100467495383)],
        &[(0b10010, &ENTRY_FAMILIARIZING_8104674979842226150)],
        &[(0b01001, &ENTRY_FAMILIARIZATION_12082687538774621170)],
        &[(0b01001, &ENTRY_FAMILIARIZATIONS_12640437606890487270)],
        &[(0b01001, &ENTRY_FAMILIARIZE_6242156019669273444)],
        &[(0b01001, &ENTRY_FAMILIARIZED_15024414515945758936)],
        &[(0b01001, &ENTRY_FAMILIARIZES_17026717100467495383)],
        &[(0b01001, &ENTRY_FAMILIARIZING_8104674979842226150)],
    ],
    range: 8..=13,
};

static VARS_FAG_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_FAG_CHILDREN),
    value: None,
};

pub static VARS_FAG_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ot"),
        dictgen::InsensitiveAscii("oted"),
        dictgen::InsensitiveAscii("oting"),
        dictgen::InsensitiveAscii("ots"),
    ],
    values: &[
        &[
            (0b01001, &ENTRY_FAGOT_10151298035917845314),
            (0b01001, &ENTRY_FAGOT_7863482917477677576),
        ],
        &[(0b01001, &ENTRY_FAGOTED_6374042289029783427)],
        &[(0b01001, &ENTRY_FAGOTING_5494547696679224898)],
        &[
            (0b01001, &ENTRY_FAGOTS_14417121374438859878),
            (0b01001, &ENTRY_FAGOTS_15779386352352349090),
        ],
    ],
    range: 2..=5,
};

static VARS_FAE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_FAE_CHILDREN),
    value: None,
};

pub static VARS_FAE_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("cal"),
        dictgen::InsensitiveAscii("ces"),
    ],
    values: &[
        &[(0b10010, &ENTRY_FECAL_12589305345141408090)],
        &[(0b11010, &ENTRY_FECES_13271217083721614065)],
    ],
    range: 3..=3,
};

static VARS_FAC_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_FAC_CHILDREN),
    value: None,
};

pub static VARS_FAC_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("torisation"),
        dictgen::InsensitiveAscii("torisations"),
        dictgen::InsensitiveAscii("torise"),
        dictgen::InsensitiveAscii("torised"),
        dictgen::InsensitiveAscii("torises"),
        dictgen::InsensitiveAscii("torising"),
        dictgen::InsensitiveAscii("torization"),
        dictgen::InsensitiveAscii("torizations"),
        dictgen::InsensitiveAscii("torize"),
        dictgen::InsensitiveAscii("torized"),
        dictgen::InsensitiveAscii("torizes"),
        dictgen::InsensitiveAscii("torizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_FACTORIZATION_5102971756633526494)],
        &[(0b10010, &ENTRY_FACTORIZATIONS_4638071637630345545)],
        &[(0b10010, &ENTRY_FACTORIZE_6248620742291710594)],
        &[(0b10010, &ENTRY_FACTORIZED_3076385353944751316)],
        &[(0b10010, &ENTRY_FACTORIZES_6368168670047017262)],
        &[(0b10010, &ENTRY_FACTORIZING_10106476068343096154)],
        &[(0b01001, &ENTRY_FACTORIZATION_5102971756633526494)],
        &[(0b01001, &ENTRY_FACTORIZATIONS_4638071637630345545)],
        &[(0b01001, &ENTRY_FACTORIZE_6248620742291710594)],
        &[(0b01001, &ENTRY_FACTORIZED_3076385353944751316)],
        &[(0b01001, &ENTRY_FACTORIZES_6368168670047017262)],
        &[(0b01001, &ENTRY_FACTORIZING_10106476068343096154)],
    ],
    range: 6..=11,
};

static VARS_E_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_E_CHILDREN),
    value: None,
};

static VARS_E_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    Some(&VARS_EC_NODE),
    Some(&VARS_ED_NODE),
    None,
    None,
    Some(&VARS_EG_NODE),
    None,
    None,
    None,
    None,
    Some(&VARS_EL_NODE),
    Some(&VARS_EM_NODE),
    Some(&VARS_EN_NODE),
    None,
    Some(&VARS_EP_NODE),
    Some(&VARS_EQ_NODE),
    None,
    Some(&VARS_ES_NODE),
    Some(&VARS_ET_NODE),
    Some(&VARS_EU_NODE),
    Some(&VARS_EV_NODE),
    None,
    Some(&VARS_EX_NODE),
    Some(&VARS_EY_NODE),
    None,
];

static VARS_EY_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_EY_CHILDREN),
    value: None,
};

pub static VARS_EY_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("rie"),
        dictgen::InsensitiveAscii("ry"),
    ],
    values: &[
        &[(0b11010, &ENTRY_AERIE_17068047033087189954)],
        &[(0b00001, &ENTRY_AERIE_17068047033087189954)],
    ],
    range: 2..=3,
};

static VARS_EX_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_EX_CHILDREN),
    value: None,
};

pub static VARS_EX_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("orcize"),
        dictgen::InsensitiveAscii("orcized"),
        dictgen::InsensitiveAscii("orcizes"),
        dictgen::InsensitiveAscii("orcizing"),
        dictgen::InsensitiveAscii("temporisation"),
        dictgen::InsensitiveAscii("temporisations"),
        dictgen::InsensitiveAscii("temporise"),
        dictgen::InsensitiveAscii("temporised"),
        dictgen::InsensitiveAscii("temporises"),
        dictgen::InsensitiveAscii("temporising"),
        dictgen::InsensitiveAscii("temporization"),
        dictgen::InsensitiveAscii("temporizations"),
        dictgen::InsensitiveAscii("temporize"),
        dictgen::InsensitiveAscii("temporized"),
        dictgen::InsensitiveAscii("temporizes"),
        dictgen::InsensitiveAscii("temporizing"),
        dictgen::InsensitiveAscii("teriorise"),
        dictgen::InsensitiveAscii("teriorised"),
        dictgen::InsensitiveAscii("teriorises"),
        dictgen::InsensitiveAscii("teriorising"),
        dictgen::InsensitiveAscii("teriorize"),
        dictgen::InsensitiveAscii("teriorized"),
        dictgen::InsensitiveAscii("teriorizes"),
        dictgen::InsensitiveAscii("teriorizing"),
        dictgen::InsensitiveAscii("ternalisation"),
        dictgen::InsensitiveAscii("ternalisations"),
        dictgen::InsensitiveAscii("ternalise"),
        dictgen::InsensitiveAscii("ternalised"),
        dictgen::InsensitiveAscii("ternalises"),
        dictgen::InsensitiveAscii("ternalising"),
        dictgen::InsensitiveAscii("ternalization"),
        dictgen::InsensitiveAscii("ternalizations"),
        dictgen::InsensitiveAscii("ternalize"),
        dictgen::InsensitiveAscii("ternalized"),
        dictgen::InsensitiveAscii("ternalizes"),
        dictgen::InsensitiveAscii("ternalizing"),
        dictgen::InsensitiveAscii("toll"),
        dictgen::InsensitiveAscii("tolls"),
        dictgen::InsensitiveAscii("travert"),
        dictgen::InsensitiveAscii("traverted"),
        dictgen::InsensitiveAscii("traverts"),
    ],
    values: &[
        &[(0b01001, &ENTRY_EXORCISE_6519813252766976149)],
        &[(0b01001, &ENTRY_EXORCISED_7923013483761916535)],
        &[(0b01001, &ENTRY_EXORCISES_13003500046685598280)],
        &[(0b01001, &ENTRY_EXORCISING_7595159943765013984)],
        &[(0b10010, &ENTRY_EXTEMPORIZATION_16495995827408513386)],
        &[(0b10010, &ENTRY_EXTEMPORIZATIONS_484835912937984024)],
        &[(0b10010, &ENTRY_EXTEMPORIZE_18100427440717892297)],
        &[(0b10010, &ENTRY_EXTEMPORIZED_8373892655121344093)],
        &[(0b10010, &ENTRY_EXTEMPORIZES_10237434907700901719)],
        &[(0b10010, &ENTRY_EXTEMPORIZING_3627576447114749026)],
        &[(0b01001, &ENTRY_EXTEMPORIZATION_16495995827408513386)],
        &[(0b01001, &ENTRY_EXTEMPORIZATIONS_484835912937984024)],
        &[(0b01001, &ENTRY_EXTEMPORIZE_18100427440717892297)],
        &[(0b01001, &ENTRY_EXTEMPORIZED_8373892655121344093)],
        &[(0b01001, &ENTRY_EXTEMPORIZES_10237434907700901719)],
        &[(0b01001, &ENTRY_EXTEMPORIZING_3627576447114749026)],
        &[(0b10010, &ENTRY_EXTERIORIZE_44904350820292310)],
        &[(0b10010, &ENTRY_EXTERIORIZED_15754857071634888794)],
        &[(0b10010, &ENTRY_EXTERIORIZES_1503361879818597816)],
        &[(0b10010, &ENTRY_EXTERIORIZING_13843149969846401653)],
        &[(0b01001, &ENTRY_EXTERIORIZE_44904350820292310)],
        &[(0b01001, &ENTRY_EXTERIORIZED_15754857071634888794)],
        &[(0b01001, &ENTRY_EXTERIORIZES_1503361879818597816)],
        &[(0b01001, &ENTRY_EXTERIORIZING_13843149969846401653)],
        &[(0b10010, &ENTRY_EXTERNALIZATION_9246128994925255934)],
        &[(0b10010, &ENTRY_EXTERNALIZATIONS_6813089105022337009)],
        &[(0b10010, &ENTRY_EXTERNALIZE_1755256362900379852)],
        &[(0b10010, &ENTRY_EXTERNALIZED_9673243200936449099)],
        &[(0b10010, &ENTRY_EXTERNALIZES_2963526646467072454)],
        &[(0b10010, &ENTRY_EXTERNALIZING_13585703043209993488)],
        &[(0b01001, &ENTRY_EXTERNALIZATION_9246128994925255934)],
        &[(0b01001, &ENTRY_EXTERNALIZATIONS_6813089105022337009)],
        &[(0b01001, &ENTRY_EXTERNALIZE_1755256362900379852)],
        &[(0b01001, &ENTRY_EXTERNALIZED_9673243200936449099)],
        &[(0b01001, &ENTRY_EXTERNALIZES_2963526646467072454)],
        &[(0b01001, &ENTRY_EXTERNALIZING_13585703043209993488)],
        &[(0b00001, &ENTRY_EXTOL_6530203836420061929)],
        &[(0b00001, &ENTRY_EXTOLS_11917668525245354154)],
        &[(0b10011, &ENTRY_EXTROVERT_14223399491319457241)],
        &[(0b10011, &ENTRY_EXTROVERTED_3349811760540489416)],
        &[(0b10011, &ENTRY_EXTROVERTS_5855938022041084405)],
    ],
    range: 4..=14,
};

static VARS_EV_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_EV_CHILDREN),
    value: None,
};

pub static VARS_EV_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("angelisation"),
        dictgen::InsensitiveAscii("angelisations"),
        dictgen::InsensitiveAscii("angelise"),
        dictgen::InsensitiveAscii("angelised"),
        dictgen::InsensitiveAscii("angeliser"),
        dictgen::InsensitiveAscii("angelisers"),
        dictgen::InsensitiveAscii("angelises"),
        dictgen::InsensitiveAscii("angelising"),
        dictgen::InsensitiveAscii("angelization"),
        dictgen::InsensitiveAscii("angelizations"),
        dictgen::InsensitiveAscii("angelize"),
        dictgen::InsensitiveAscii("angelized"),
        dictgen::InsensitiveAscii("angelizer"),
        dictgen::InsensitiveAscii("angelizers"),
        dictgen::InsensitiveAscii("angelizes"),
        dictgen::InsensitiveAscii("angelizing"),
        dictgen::InsensitiveAscii("iler"),
        dictgen::InsensitiveAscii("ilest"),
        dictgen::InsensitiveAscii("iller"),
        dictgen::InsensitiveAscii("illest"),
    ],
    values: &[
        &[(0b10010, &ENTRY_EVANGELIZATION_95918260299241119)],
        &[(0b10010, &ENTRY_EVANGELIZATIONS_13830601721028602369)],
        &[(0b10010, &ENTRY_EVANGELIZE_3816430481934936599)],
        &[(0b10010, &ENTRY_EVANGELIZED_17447599926020044651)],
        &[(0b10010, &ENTRY_EVANGELIZER_15719745451926752893)],
        &[(0b10010, &ENTRY_EVANGELIZERS_13970259288304829321)],
        &[(0b10010, &ENTRY_EVANGELIZES_6848716766820134553)],
        &[(0b10010, &ENTRY_EVANGELIZING_9044162222729137139)],
        &[(0b01001, &ENTRY_EVANGELIZATION_95918260299241119)],
        &[(0b01001, &ENTRY_EVANGELIZATIONS_13830601721028602369)],
        &[(0b01001, &ENTRY_EVANGELIZE_3816430481934936599)],
        &[(0b01001, &ENTRY_EVANGELIZED_17447599926020044651)],
        &[(0b01001, &ENTRY_EVANGELIZER_15719745451926752893)],
        &[(0b01001, &ENTRY_EVANGELIZERS_13970259288304829321)],
        &[(0b01001, &ENTRY_EVANGELIZES_6848716766820134553)],
        &[(0b01001, &ENTRY_EVANGELIZING_9044162222729137139)],
        &[(0b00001, &ENTRY_EVILER_1511493183642407212)],
        &[(0b00001, &ENTRY_EVILEST_13211136907355422438)],
        &[(0b11010, &ENTRY_EVILER_1511493183642407212)],
        &[(0b11010, &ENTRY_EVILEST_13211136907355422438)],
    ],
    range: 4..=13,
};

static VARS_EU_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_EU_CHILDREN),
    value: None,
};

pub static VARS_EU_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("logise"),
        dictgen::InsensitiveAscii("logised"),
        dictgen::InsensitiveAscii("logises"),
        dictgen::InsensitiveAscii("logising"),
        dictgen::InsensitiveAscii("logize"),
        dictgen::InsensitiveAscii("logized"),
        dictgen::InsensitiveAscii("logizes"),
        dictgen::InsensitiveAscii("logizing"),
        dictgen::InsensitiveAscii("phemise"),
        dictgen::InsensitiveAscii("phemised"),
        dictgen::InsensitiveAscii("phemises"),
        dictgen::InsensitiveAscii("phemising"),
        dictgen::InsensitiveAscii("phemize"),
        dictgen::InsensitiveAscii("phemized"),
        dictgen::InsensitiveAscii("phemizes"),
        dictgen::InsensitiveAscii("phemizing"),
        dictgen::InsensitiveAscii("ropeanisation"),
        dictgen::InsensitiveAscii("ropeanisations"),
        dictgen::InsensitiveAscii("ropeanise"),
        dictgen::InsensitiveAscii("ropeanised"),
        dictgen::InsensitiveAscii("ropeanises"),
        dictgen::InsensitiveAscii("ropeanising"),
        dictgen::InsensitiveAscii("ropeanization"),
        dictgen::InsensitiveAscii("ropeanizations"),
        dictgen::InsensitiveAscii("ropeanize"),
        dictgen::InsensitiveAscii("ropeanized"),
        dictgen::InsensitiveAscii("ropeanizes"),
        dictgen::InsensitiveAscii("ropeanizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_EULOGIZE_5057583596298469791)],
        &[(0b10010, &ENTRY_EULOGIZED_8728323980549981685)],
        &[(0b10010, &ENTRY_EULOGIZES_3835732440821657383)],
        &[(0b10010, &ENTRY_EULOGIZING_13191497739725600277)],
        &[(0b01001, &ENTRY_EULOGIZE_5057583596298469791)],
        &[(0b01001, &ENTRY_EULOGIZED_8728323980549981685)],
        &[(0b01001, &ENTRY_EULOGIZES_3835732440821657383)],
        &[(0b01001, &ENTRY_EULOGIZING_13191497739725600277)],
        &[(0b10010, &ENTRY_EUPHEMIZE_6354436200580711971)],
        &[(0b10010, &ENTRY_EUPHEMIZED_384901376621156921)],
        &[(0b10010, &ENTRY_EUPHEMIZES_17040532734112861700)],
        &[(0b10010, &ENTRY_EUPHEMIZING_12922673468625138298)],
        &[(0b01001, &ENTRY_EUPHEMIZE_6354436200580711971)],
        &[(0b01001, &ENTRY_EUPHEMIZED_384901376621156921)],
        &[(0b01001, &ENTRY_EUPHEMIZES_17040532734112861700)],
        &[(0b01001, &ENTRY_EUPHEMIZING_12922673468625138298)],
        &[(0b10010, &ENTRY_EUROPEANIZATION_18182188015643339370)],
        &[(0b10010, &ENTRY_EUROPEANIZATIONS_11732866676783163952)],
        &[(0b10010, &ENTRY_EUROPEANIZE_7877119707137615478)],
        &[(0b10010, &ENTRY_EUROPEANIZED_5069713816195565465)],
        &[(0b10010, &ENTRY_EUROPEANIZES_15551253373119788515)],
        &[(0b10010, &ENTRY_EUROPEANIZING_2151542840584223646)],
        &[(0b01001, &ENTRY_EUROPEANIZATION_18182188015643339370)],
        &[(0b01001, &ENTRY_EUROPEANIZATIONS_11732866676783163952)],
        &[(0b01001, &ENTRY_EUROPEANIZE_7877119707137615478)],
        &[(0b01001, &ENTRY_EUROPEANIZED_5069713816195565465)],
        &[(0b01001, &ENTRY_EUROPEANIZES_15551253373119788515)],
        &[(0b01001, &ENTRY_EUROPEANIZING_2151542840584223646)],
    ],
    range: 6..=14,
};

static VARS_ET_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_ET_CHILDREN),
    value: None,
};

pub static VARS_ET_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ernalise"),
        dictgen::InsensitiveAscii("ernalised"),
        dictgen::InsensitiveAscii("ernalises"),
        dictgen::InsensitiveAscii("ernalising"),
        dictgen::InsensitiveAscii("ernalize"),
        dictgen::InsensitiveAscii("ernalized"),
        dictgen::InsensitiveAscii("ernalizes"),
        dictgen::InsensitiveAscii("ernalizing"),
        dictgen::InsensitiveAscii("herise"),
        dictgen::InsensitiveAscii("herised"),
        dictgen::InsensitiveAscii("herises"),
        dictgen::InsensitiveAscii("herising"),
        dictgen::InsensitiveAscii("herize"),
        dictgen::InsensitiveAscii("herized"),
        dictgen::InsensitiveAscii("herizes"),
        dictgen::InsensitiveAscii("herizing"),
        dictgen::InsensitiveAscii("iologically"),
        dictgen::InsensitiveAscii("iology"),
        dictgen::InsensitiveAscii("ymologise"),
        dictgen::InsensitiveAscii("ymologised"),
        dictgen::InsensitiveAscii("ymologises"),
        dictgen::InsensitiveAscii("ymologising"),
        dictgen::InsensitiveAscii("ymologize"),
        dictgen::InsensitiveAscii("ymologized"),
        dictgen::InsensitiveAscii("ymologizes"),
        dictgen::InsensitiveAscii("ymologizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_ETERNALIZE_16866605418824842181)],
        &[(0b10010, &ENTRY_ETERNALIZED_3895092792354325191)],
        &[(0b10010, &ENTRY_ETERNALIZES_10340106011591437418)],
        &[(0b10010, &ENTRY_ETERNALIZING_3666087619740459810)],
        &[(0b01001, &ENTRY_ETERNALIZE_16866605418824842181)],
        &[(0b01001, &ENTRY_ETERNALIZED_3895092792354325191)],
        &[(0b01001, &ENTRY_ETERNALIZES_10340106011591437418)],
        &[(0b01001, &ENTRY_ETERNALIZING_3666087619740459810)],
        &[(0b10010, &ENTRY_ETHERIZE_7063818294001377173)],
        &[(0b10010, &ENTRY_ETHERIZED_12616495300571811734)],
        &[(0b10010, &ENTRY_ETHERIZES_13639595418596582424)],
        &[(0b10010, &ENTRY_ETHERIZING_1369052890079428803)],
        &[(0b01001, &ENTRY_ETHERIZE_7063818294001377173)],
        &[(0b01001, &ENTRY_ETHERIZED_12616495300571811734)],
        &[(0b01001, &ENTRY_ETHERIZES_13639595418596582424)],
        &[(0b01001, &ENTRY_ETHERIZING_1369052890079428803)],
        &[(0b11001, &ENTRY_ETIOLOGICALLY_1064612193650452227)],
        &[(0b11001, &ENTRY_ETIOLOGY_4658311861857715324)],
        &[(0b10010, &ENTRY_ETYMOLOGIZE_11288336530403962791)],
        &[(0b10010, &ENTRY_ETYMOLOGIZED_2645595824075873147)],
        &[(0b10010, &ENTRY_ETYMOLOGIZES_13710053144878095709)],
        &[(0b10010, &ENTRY_ETYMOLOGIZING_1743090802525341227)],
        &[(0b01001, &ENTRY_ETYMOLOGIZE_11288336530403962791)],
        &[(0b01001, &ENTRY_ETYMOLOGIZED_2645595824075873147)],
        &[(0b01001, &ENTRY_ETYMOLOGIZES_13710053144878095709)],
        &[(0b01001, &ENTRY_ETYMOLOGIZING_1743090802525341227)],
    ],
    range: 6..=11,
};

static VARS_ES_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_ES_CHILDREN),
    value: None,
};

pub static VARS_ES_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ophagi"),
        dictgen::InsensitiveAscii("ophagus"),
        dictgen::InsensitiveAscii("ophaguses"),
        dictgen::InsensitiveAscii("thete"),
        dictgen::InsensitiveAscii("thetes"),
        dictgen::InsensitiveAscii("thetic"),
        dictgen::InsensitiveAscii("thetically"),
        dictgen::InsensitiveAscii("thetician"),
        dictgen::InsensitiveAscii("theticians"),
        dictgen::InsensitiveAscii("thetics"),
        dictgen::InsensitiveAscii("tival"),
        dictgen::InsensitiveAscii("tivate"),
        dictgen::InsensitiveAscii("tivated"),
        dictgen::InsensitiveAscii("tivates"),
        dictgen::InsensitiveAscii("tivating"),
        dictgen::InsensitiveAscii("tivation"),
        dictgen::InsensitiveAscii("tivations"),
        dictgen::InsensitiveAscii("trogen"),
        dictgen::InsensitiveAscii("trogenic"),
        dictgen::InsensitiveAscii("trogens"),
        dictgen::InsensitiveAscii("trous"),
        dictgen::InsensitiveAscii("trus"),
        dictgen::InsensitiveAscii("truses"),
    ],
    values: &[
        &[(0b11001, &ENTRY_ESOPHAGI_11954876978132806506)],
        &[(0b10001, &ENTRY_ESOPHAGUS_17094499599237101062)],
        &[(0b01001, &ENTRY_ESOPHAGI_11954876978132806506)],
        &[(0b00001, &ENTRY_AESTHETE_6475321551135991601)],
        &[(0b00001, &ENTRY_AESTHETES_15012821507993100258)],
        &[(0b11001, &ENTRY_AESTHETIC_5817909166486372441)],
        &[(0b00001, &ENTRY_AESTHETICALLY_4393362297255043635)],
        &[(0b01001, &ENTRY_ESTHETICIAN_6690642998636082700)],
        &[(0b01001, &ENTRY_ESTHETICIANS_16857352085837156733)],
        &[(0b11001, &ENTRY_AESTHETICS_3207114874897219410)],
        &[(0b01001, &ENTRY_ESTIVAL_11802673568747360369)],
        &[(0b01001, &ENTRY_ESTIVATE_10836493401844257867)],
        &[(0b01001, &ENTRY_ESTIVATED_5948189904457603376)],
        &[(0b01001, &ENTRY_ESTIVATES_8627334418178723288)],
        &[(0b01001, &ENTRY_ESTIVATING_9498433178617024784)],
        &[(0b01001, &ENTRY_ESTIVATION_6434066985142123064)],
        &[(0b01001, &ENTRY_ESTIVATIONS_15940487245092349305)],
        &[(0b11001, &ENTRY_ESTROGEN_10173348120996063533)],
        &[(0b11001, &ENTRY_ESTROGENIC_3724956938647222280)],
        &[(0b11001, &ENTRY_ESTROGENS_11487970579706669068)],
        &[(0b01001, &ENTRY_ESTROUS_7878210273842809015)],
        &[(0b01001, &ENTRY_ESTRUS_391811675946213924)],
        &[(0b01001, &ENTRY_ESTRUSES_7947106804154830951)],
    ],
    range: 4..=10,
};

static VARS_EQ_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_EQ_CHILDREN),
    value: None,
};

pub static VARS_EQ_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ualed"),
        dictgen::InsensitiveAscii("ualing"),
        dictgen::InsensitiveAscii("ualisation"),
        dictgen::InsensitiveAscii("ualisations"),
        dictgen::InsensitiveAscii("ualise"),
        dictgen::InsensitiveAscii("ualised"),
        dictgen::InsensitiveAscii("ualiser"),
        dictgen::InsensitiveAscii("ualisers"),
        dictgen::InsensitiveAscii("ualises"),
        dictgen::InsensitiveAscii("ualising"),
        dictgen::InsensitiveAscii("ualisings"),
        dictgen::InsensitiveAscii("ualization"),
        dictgen::InsensitiveAscii("ualizations"),
        dictgen::InsensitiveAscii("ualize"),
        dictgen::InsensitiveAscii("ualized"),
        dictgen::InsensitiveAscii("ualizer"),
        dictgen::InsensitiveAscii("ualizers"),
        dictgen::InsensitiveAscii("ualizes"),
        dictgen::InsensitiveAscii("ualizing"),
        dictgen::InsensitiveAscii("ualizings"),
        dictgen::InsensitiveAscii("ualled"),
        dictgen::InsensitiveAscii("ualling"),
    ],
    values: &[
        &[(0b00001, &ENTRY_EQUALED_9280544645272281486)],
        &[(0b00001, &ENTRY_EQUALING_2200698246943537365)],
        &[(0b10010, &ENTRY_EQUALIZATION_15703715989268616381)],
        &[(0b10010, &ENTRY_EQUALIZATIONS_17119813704324078034)],
        &[(0b10010, &ENTRY_EQUALIZE_2295006139195864596)],
        &[(0b10010, &ENTRY_EQUALIZED_13933428330870564759)],
        &[(0b10010, &ENTRY_EQUALIZER_12962637525747924057)],
        &[(0b10010, &ENTRY_EQUALIZERS_55108374391593906)],
        &[(0b10010, &ENTRY_EQUALIZES_11036742568829365058)],
        &[(0b10010, &ENTRY_EQUALIZING_8520313871903824117)],
        &[(0b10010, &ENTRY_EQUALIZINGS_754862697182198741)],
        &[(0b01001, &ENTRY_EQUALIZATION_15703715989268616381)],
        &[(0b01001, &ENTRY_EQUALIZATIONS_17119813704324078034)],
        &[(0b01001, &ENTRY_EQUALIZE_2295006139195864596)],
        &[(0b01001, &ENTRY_EQUALIZED_13933428330870564759)],
        &[(0b01001, &ENTRY_EQUALIZER_12962637525747924057)],
        &[(0b01001, &ENTRY_EQUALIZERS_55108374391593906)],
        &[(0b01001, &ENTRY_EQUALIZES_11036742568829365058)],
        &[(0b01001, &ENTRY_EQUALIZING_8520313871903824117)],
        &[(0b01001, &ENTRY_EQUALIZINGS_754862697182198741)],
        &[(0b11010, &ENTRY_EQUALED_9280544645272281486)],
        &[(0b11010, &ENTRY_EQUALING_2200698246943537365)],
    ],
    range: 5..=11,
};

static VARS_EP_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_EP_CHILDREN),
    value: None,
};

pub static VARS_EP_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("aulet"),
        dictgen::InsensitiveAscii("aulets"),
        dictgen::InsensitiveAscii("icenter"),
        dictgen::InsensitiveAscii("icenters"),
        dictgen::InsensitiveAscii("icentre"),
        dictgen::InsensitiveAscii("icentres"),
        dictgen::InsensitiveAscii("ilog"),
        dictgen::InsensitiveAscii("ilogs"),
        dictgen::InsensitiveAscii("itomisation"),
        dictgen::InsensitiveAscii("itomisations"),
        dictgen::InsensitiveAscii("itomise"),
        dictgen::InsensitiveAscii("itomised"),
        dictgen::InsensitiveAscii("itomises"),
        dictgen::InsensitiveAscii("itomising"),
        dictgen::InsensitiveAscii("itomization"),
        dictgen::InsensitiveAscii("itomizations"),
        dictgen::InsensitiveAscii("itomize"),
        dictgen::InsensitiveAscii("itomized"),
        dictgen::InsensitiveAscii("itomizes"),
        dictgen::InsensitiveAscii("itomizing"),
    ],
    values: &[
        &[(0b01001, &ENTRY_EPAULET_3626800389363536157)],
        &[(0b01001, &ENTRY_EPAULETS_15943230211605632990)],
        &[(0b00001, &ENTRY_EPICENTER_7128649262146588844)],
        &[(0b00001, &ENTRY_EPICENTERS_6438256216831055083)],
        &[(0b11010, &ENTRY_EPICENTER_7128649262146588844)],
        &[(0b11010, &ENTRY_EPICENTERS_6438256216831055083)],
        &[(0b00001, &ENTRY_EPILOGUE_8824676410841380805)],
        &[(0b00001, &ENTRY_EPILOGUES_9706718333805199018)],
        &[(0b10010, &ENTRY_EPITOMIZATION_10587528992127024576)],
        &[(0b10010, &ENTRY_EPITOMIZATIONS_6345699152655468434)],
        &[(0b10010, &ENTRY_EPITOMIZE_798154534644964032)],
        &[(0b10010, &ENTRY_EPITOMIZED_14066301984118681615)],
        &[(0b10010, &ENTRY_EPITOMIZES_1913888595081252026)],
        &[(0b10010, &ENTRY_EPITOMIZING_8673529461190796371)],
        &[(0b01001, &ENTRY_EPITOMIZATION_10587528992127024576)],
        &[(0b01001, &ENTRY_EPITOMIZATIONS_6345699152655468434)],
        &[(0b01001, &ENTRY_EPITOMIZE_798154534644964032)],
        &[(0b01001, &ENTRY_EPITOMIZED_14066301984118681615)],
        &[(0b01001, &ENTRY_EPITOMIZES_1913888595081252026)],
        &[(0b01001, &ENTRY_EPITOMIZING_8673529461190796371)],
    ],
    range: 4..=12,
};

static VARS_EN_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_EN_CHILDREN),
    value: None,
};

pub static VARS_EN_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ameled"),
        dictgen::InsensitiveAscii("ameler"),
        dictgen::InsensitiveAscii("amelers"),
        dictgen::InsensitiveAscii("ameling"),
        dictgen::InsensitiveAscii("amelings"),
        dictgen::InsensitiveAscii("amelled"),
        dictgen::InsensitiveAscii("ameller"),
        dictgen::InsensitiveAscii("amellers"),
        dictgen::InsensitiveAscii("amelling"),
        dictgen::InsensitiveAscii("amellings"),
        dictgen::InsensitiveAscii("amor"),
        dictgen::InsensitiveAscii("amored"),
        dictgen::InsensitiveAscii("amoreds"),
        dictgen::InsensitiveAscii("amoring"),
        dictgen::InsensitiveAscii("amors"),
        dictgen::InsensitiveAscii("amour"),
        dictgen::InsensitiveAscii("amoured"),
        dictgen::InsensitiveAscii("amoureds"),
        dictgen::InsensitiveAscii("amouring"),
        dictgen::InsensitiveAscii("amours"),
        dictgen::InsensitiveAscii("deavor"),
        dictgen::InsensitiveAscii("deavored"),
        dictgen::InsensitiveAscii("deavoring"),
        dictgen::InsensitiveAscii("deavors"),
        dictgen::InsensitiveAscii("deavour"),
        dictgen::InsensitiveAscii("deavoured"),
        dictgen::InsensitiveAscii("deavouring"),
        dictgen::InsensitiveAscii("deavours"),
        dictgen::InsensitiveAscii("ergise"),
        dictgen::InsensitiveAscii("ergised"),
        dictgen::InsensitiveAscii("ergises"),
        dictgen::InsensitiveAscii("ergising"),
        dictgen::InsensitiveAscii("ergize"),
        dictgen::InsensitiveAscii("ergized"),
        dictgen::InsensitiveAscii("ergizes"),
        dictgen::InsensitiveAscii("ergizing"),
        dictgen::InsensitiveAscii("ological"),
        dictgen::InsensitiveAscii("ologist"),
        dictgen::InsensitiveAscii("ologists"),
        dictgen::InsensitiveAscii("quire"),
        dictgen::InsensitiveAscii("quired"),
        dictgen::InsensitiveAscii("quires"),
        dictgen::InsensitiveAscii("quiries"),
        dictgen::InsensitiveAscii("quiring"),
        dictgen::InsensitiveAscii("quiry"),
        dictgen::InsensitiveAscii("rol"),
        dictgen::InsensitiveAscii("roll"),
        dictgen::InsensitiveAscii("rollment"),
        dictgen::InsensitiveAscii("rollments"),
        dictgen::InsensitiveAscii("rolls"),
        dictgen::InsensitiveAscii("rolment"),
        dictgen::InsensitiveAscii("rolments"),
        dictgen::InsensitiveAscii("rols"),
        dictgen::InsensitiveAscii("thral"),
        dictgen::InsensitiveAscii("thrall"),
        dictgen::InsensitiveAscii("thrallment"),
        dictgen::InsensitiveAscii("thrallments"),
        dictgen::InsensitiveAscii("thralls"),
        dictgen::InsensitiveAscii("thralment"),
        dictgen::InsensitiveAscii("thralments"),
        dictgen::InsensitiveAscii("thrals"),
    ],
    values: &[
        &[(0b01001, &ENTRY_ENAMELED_11306849032588231949)],
        &[(0b00001, &ENTRY_ENAMELER_2186265811744360882)],
        &[(0b00001, &ENTRY_ENAMELERS_5158818097595900189)],
        &[(0b01001, &ENTRY_ENAMELING_13986001605744876872)],
        &[(0b01001, &ENTRY_ENAMELINGS_6194997663710852731)],
        &[(0b11010, &ENTRY_ENAMELED_11306849032588231949)],
        &[(0b11010, &ENTRY_ENAMELER_2186265811744360882)],
        &[(0b11010, &ENTRY_ENAMELERS_5158818097595900189)],
        &[(0b11010, &ENTRY_ENAMELING_13986001605744876872)],
        &[(0b11010, &ENTRY_ENAMELINGS_6194997663710852731)],
        &[(0b11001, &ENTRY_ENAMOR_18438712925910130607)],
        &[(0b11001, &ENTRY_ENAMORED_3978396704928569217)],
        &[(0b11001, &ENTRY_ENAMOREDS_1170610777553507807)],
        &[(0b11001, &ENTRY_ENAMORING_873141923636435610)],
        &[(0b11001, &ENTRY_ENAMORS_15866647987432832950)],
        &[(0b11010, &ENTRY_ENAMOR_18438712925910130607)],
        &[(0b11010, &ENTRY_ENAMORED_3978396704928569217)],
        &[(0b11010, &ENTRY_ENAMOREDS_1170610777553507807)],
        &[(0b11010, &ENTRY_ENAMORING_873141923636435610)],
        &[(0b11010, &ENTRY_ENAMORS_15866647987432832950)],
        &[(0b11001, &ENTRY_ENDEAVOR_16478995020577429674)],
        &[(0b11001, &ENTRY_ENDEAVORED_8875983943474804048)],
        &[(0b11001, &ENTRY_ENDEAVORING_13456096223476863134)],
        &[(0b11001, &ENTRY_ENDEAVORS_4206263397240885183)],
        &[(0b11010, &ENTRY_ENDEAVOR_16478995020577429674)],
        &[(0b11010, &ENTRY_ENDEAVORED_8875983943474804048)],
        &[(0b11010, &ENTRY_ENDEAVORING_13456096223476863134)],
        &[(0b11010, &ENTRY_ENDEAVORS_4206263397240885183)],
        &[(0b10010, &ENTRY_ENERGIZE_4079145480961428012)],
        &[(0b10010, &ENTRY_ENERGIZED_8110447848594482786)],
        &[(0b10010, &ENTRY_ENERGIZES_15882306341173011479)],
        &[(0b10010, &ENTRY_ENERGIZING_14435058947853843369)],
        &[(0b01001, &ENTRY_ENERGIZE_4079145480961428012)],
        &[(0b01001, &ENTRY_ENERGIZED_8110447848594482786)],
        &[(0b01001, &ENTRY_ENERGIZES_15882306341173011479)],
        &[(0b01001, &ENTRY_ENERGIZING_14435058947853843369)],
        &[(0b00001, &ENTRY_ENOLOGICAL_11189078660498192658)],
        &[(0b00001, &ENTRY_ENOLOGIST_382673391921246993)],
        &[(0b00001, &ENTRY_ENOLOGISTS_1989647851737964355)],
        &[(0b11010, &ENTRY_INQUIRE_9931226624157807030)],
        &[(0b11010, &ENTRY_INQUIRED_859881660768366050)],
        &[(0b11010, &ENTRY_INQUIRES_15638770793218138085)],
        &[(0b11010, &ENTRY_INQUIRIES_14785300041968074867)],
        &[(0b11010, &ENTRY_INQUIRING_8930995414308740890)],
        &[(0b11010, &ENTRY_INQUIRY_8834861104825329029)],
        &[(0b11010, &ENTRY_ENROLL_9372041037495900233)],
        &[(0b11001, &ENTRY_ENROLL_9372041037495900233)],
        &[(0b11001, &ENTRY_ENROLLMENT_1944796353205798833)],
        &[(0b11001, &ENTRY_ENROLLMENTS_6330348617051249235)],
        &[(0b11001, &ENTRY_ENROLLS_11547415760061099613)],
        &[(0b11010, &ENTRY_ENROLLMENT_1944796353205798833)],
        &[(0b11010, &ENTRY_ENROLLMENTS_6330348617051249235)],
        &[(0b11010, &ENTRY_ENROLLS_11547415760061099613)],
        &[
            (0b11010, &ENTRY_ENTHRALL_4754864491654938416),
            (0b11010, &ENTRY_ENTHRALL_5942778214277993445),
        ],
        &[
            (0b01001, &ENTRY_ENTHRALL_4754864491654938416),
            (0b01001, &ENTRY_ENTHRALL_5942778214277993445),
        ],
        &[(0b01001, &ENTRY_ENTHRALLMENT_7453407253455951045)],
        &[(0b01001, &ENTRY_ENTHRALLMENTS_3346774299329360123)],
        &[
            (0b01001, &ENTRY_ENTHRALLS_12657636057000965567),
            (0b01001, &ENTRY_ENTHRALLS_4931585169072696150),
        ],
        &[(0b11010, &ENTRY_ENTHRALLMENT_7453407253455951045)],
        &[(0b11010, &ENTRY_ENTHRALLMENTS_3346774299329360123)],
        &[
            (0b11010, &ENTRY_ENTHRALLS_12657636057000965567),
            (0b11010, &ENTRY_ENTHRALLS_4931585169072696150),
        ],
    ],
    range: 3..=11,
};

static VARS_EM_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_EM_CHILDREN),
    value: None,
};

pub static VARS_EM_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("blematise"),
        dictgen::InsensitiveAscii("blematised"),
        dictgen::InsensitiveAscii("blematises"),
        dictgen::InsensitiveAscii("blematising"),
        dictgen::InsensitiveAscii("blematize"),
        dictgen::InsensitiveAscii("blematized"),
        dictgen::InsensitiveAscii("blematizes"),
        dictgen::InsensitiveAscii("blematizing"),
        dictgen::InsensitiveAscii("otionalise"),
        dictgen::InsensitiveAscii("otionalised"),
        dictgen::InsensitiveAscii("otionalises"),
        dictgen::InsensitiveAscii("otionalising"),
        dictgen::InsensitiveAscii("otionalize"),
        dictgen::InsensitiveAscii("otionalized"),
        dictgen::InsensitiveAscii("otionalizes"),
        dictgen::InsensitiveAscii("otionalizing"),
        dictgen::InsensitiveAscii("paneled"),
        dictgen::InsensitiveAscii("paneling"),
        dictgen::InsensitiveAscii("panelled"),
        dictgen::InsensitiveAscii("panelling"),
        dictgen::InsensitiveAscii("pathise"),
        dictgen::InsensitiveAscii("pathised"),
        dictgen::InsensitiveAscii("pathises"),
        dictgen::InsensitiveAscii("pathising"),
        dictgen::InsensitiveAscii("pathize"),
        dictgen::InsensitiveAscii("pathized"),
        dictgen::InsensitiveAscii("pathizes"),
        dictgen::InsensitiveAscii("pathizing"),
        dictgen::InsensitiveAscii("phasise"),
        dictgen::InsensitiveAscii("phasised"),
        dictgen::InsensitiveAscii("phasises"),
        dictgen::InsensitiveAscii("phasising"),
        dictgen::InsensitiveAscii("phasize"),
        dictgen::InsensitiveAscii("phasized"),
        dictgen::InsensitiveAscii("phasizes"),
        dictgen::InsensitiveAscii("phasizing"),
        dictgen::InsensitiveAscii("ploye"),
        dictgen::InsensitiveAscii("ployes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_EMBLEMATIZE_1598009610505106027)],
        &[(0b10010, &ENTRY_EMBLEMATIZED_13094007365723895528)],
        &[(0b10010, &ENTRY_EMBLEMATIZES_6955351418847090060)],
        &[(0b10010, &ENTRY_EMBLEMATIZING_9369922012211496667)],
        &[(0b01001, &ENTRY_EMBLEMATIZE_1598009610505106027)],
        &[(0b01001, &ENTRY_EMBLEMATIZED_13094007365723895528)],
        &[(0b01001, &ENTRY_EMBLEMATIZES_6955351418847090060)],
        &[(0b01001, &ENTRY_EMBLEMATIZING_9369922012211496667)],
        &[(0b10010, &ENTRY_EMOTIONALIZE_11024287246619149998)],
        &[(0b10010, &ENTRY_EMOTIONALIZED_6884440531306026397)],
        &[(0b10010, &ENTRY_EMOTIONALIZES_16647510988271072305)],
        &[(0b10010, &ENTRY_EMOTIONALIZING_8290060333843675227)],
        &[(0b01001, &ENTRY_EMOTIONALIZE_11024287246619149998)],
        &[(0b01001, &ENTRY_EMOTIONALIZED_6884440531306026397)],
        &[(0b01001, &ENTRY_EMOTIONALIZES_16647510988271072305)],
        &[(0b01001, &ENTRY_EMOTIONALIZING_8290060333843675227)],
        &[(0b00001, &ENTRY_IMPANELED_5408518347675931541)],
        &[(0b00001, &ENTRY_IMPANELING_2814603235256758547)],
        &[(0b11010, &ENTRY_IMPANELED_5408518347675931541)],
        &[(0b11010, &ENTRY_IMPANELING_2814603235256758547)],
        &[(0b10010, &ENTRY_EMPATHIZE_4851926761652344693)],
        &[(0b10010, &ENTRY_EMPATHIZED_1551573131065246112)],
        &[(0b10010, &ENTRY_EMPATHIZES_14920809075846536428)],
        &[(0b10010, &ENTRY_EMPATHIZING_5521634151158166341)],
        &[(0b01001, &ENTRY_EMPATHIZE_4851926761652344693)],
        &[(0b01001, &ENTRY_EMPATHIZED_1551573131065246112)],
        &[(0b01001, &ENTRY_EMPATHIZES_14920809075846536428)],
        &[(0b01001, &ENTRY_EMPATHIZING_5521634151158166341)],
        &[(0b10010, &ENTRY_EMPHASIZE_1866717834630982104)],
        &[(0b10010, &ENTRY_EMPHASIZED_11690096218388969918)],
        &[(0b10010, &ENTRY_EMPHASIZES_12089402216306749832)],
        &[(0b10010, &ENTRY_EMPHASIZING_2120491803588767663)],
        &[(0b01001, &ENTRY_EMPHASIZE_1866717834630982104)],
        &[(0b01001, &ENTRY_EMPHASIZED_11690096218388969918)],
        &[(0b01001, &ENTRY_EMPHASIZES_12089402216306749832)],
        &[(0b01001, &ENTRY_EMPHASIZING_2120491803588767663)],
        &[(0b00001, &ENTRY_EMPLOYEE_17424105370251049414)],
        &[(0b00001, &ENTRY_EMPLOYEES_17687744840650937952)],
    ],
    range: 5..=12,
};

static VARS_EL_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_EL_CHILDREN),
    value: None,
};

pub static VARS_EL_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("egise"),
        dictgen::InsensitiveAscii("egised"),
        dictgen::InsensitiveAscii("egises"),
        dictgen::InsensitiveAscii("egising"),
        dictgen::InsensitiveAscii("egize"),
        dictgen::InsensitiveAscii("egized"),
        dictgen::InsensitiveAscii("egizes"),
        dictgen::InsensitiveAscii("egizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_ELEGIZE_6148791844217028940)],
        &[(0b10010, &ENTRY_ELEGIZED_16680402250437818257)],
        &[(0b10010, &ENTRY_ELEGIZES_18250546226667841408)],
        &[(0b10010, &ENTRY_ELEGIZING_9684027986507103857)],
        &[(0b01001, &ENTRY_ELEGIZE_6148791844217028940)],
        &[(0b01001, &ENTRY_ELEGIZED_16680402250437818257)],
        &[(0b01001, &ENTRY_ELEGIZES_18250546226667841408)],
        &[(0b01001, &ENTRY_ELEGIZING_9684027986507103857)],
    ],
    range: 5..=7,
};

static VARS_EG_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_EG_CHILDREN),
    value: None,
};

pub static VARS_EG_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("is"),
        dictgen::InsensitiveAscii("ises"),
    ],
    values: &[
        &[(0b00001, &ENTRY_AEGIS_8763057825902985675)],
        &[(0b00001, &ENTRY_AEGISES_11533648482988821845)],
    ],
    range: 2..=4,
};

static VARS_ED_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_ED_CHILDREN),
    value: None,
};

pub static VARS_ED_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ema"),
        dictgen::InsensitiveAscii("emas"),
        dictgen::InsensitiveAscii("ematous"),
        dictgen::InsensitiveAscii("ile"),
        dictgen::InsensitiveAscii("iles"),
        dictgen::InsensitiveAscii("itorialise"),
        dictgen::InsensitiveAscii("itorialised"),
        dictgen::InsensitiveAscii("itorialises"),
        dictgen::InsensitiveAscii("itorialising"),
        dictgen::InsensitiveAscii("itorialize"),
        dictgen::InsensitiveAscii("itorialized"),
        dictgen::InsensitiveAscii("itorializes"),
        dictgen::InsensitiveAscii("itorializing"),
    ],
    values: &[
        &[(0b11001, &ENTRY_EDEMA_6077775640730618555)],
        &[(0b11001, &ENTRY_EDEMAS_2647107175205211125)],
        &[(0b11001, &ENTRY_EDEMATOUS_6296161129737314269)],
        &[(0b00001, &ENTRY_AEDILE_15038900667105730092)],
        &[(0b00001, &ENTRY_AEDILES_9510493690992644415)],
        &[(0b10010, &ENTRY_EDITORIALIZE_14666089880239131679)],
        &[(0b10010, &ENTRY_EDITORIALIZED_206766284852555978)],
        &[(0b10010, &ENTRY_EDITORIALIZES_7980175984307295032)],
        &[(0b10010, &ENTRY_EDITORIALIZING_6393585257106387800)],
        &[(0b01001, &ENTRY_EDITORIALIZE_14666089880239131679)],
        &[(0b01001, &ENTRY_EDITORIALIZED_206766284852555978)],
        &[(0b01001, &ENTRY_EDITORIALIZES_7980175984307295032)],
        &[(0b01001, &ENTRY_EDITORIALIZING_6393585257106387800)],
    ],
    range: 3..=12,
};

static VARS_EC_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_EC_CHILDREN),
    value: None,
};

pub static VARS_EC_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("onomise"),
        dictgen::InsensitiveAscii("onomised"),
        dictgen::InsensitiveAscii("onomiser"),
        dictgen::InsensitiveAscii("onomisers"),
        dictgen::InsensitiveAscii("onomises"),
        dictgen::InsensitiveAscii("onomising"),
        dictgen::InsensitiveAscii("onomize"),
        dictgen::InsensitiveAscii("onomized"),
        dictgen::InsensitiveAscii("onomizer"),
        dictgen::InsensitiveAscii("onomizers"),
        dictgen::InsensitiveAscii("onomizes"),
        dictgen::InsensitiveAscii("onomizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_ECONOMIZE_12047501793607810301)],
        &[(0b10010, &ENTRY_ECONOMIZED_7472643162983045891)],
        &[(0b10010, &ENTRY_ECONOMIZER_1145608432005541501)],
        &[(0b10010, &ENTRY_ECONOMIZERS_11377293695267374301)],
        &[(0b10010, &ENTRY_ECONOMIZES_15039806622307012464)],
        &[(0b10010, &ENTRY_ECONOMIZING_9258997222217906936)],
        &[(0b01001, &ENTRY_ECONOMIZE_12047501793607810301)],
        &[(0b01001, &ENTRY_ECONOMIZED_7472643162983045891)],
        &[(0b01001, &ENTRY_ECONOMIZER_1145608432005541501)],
        &[(0b01001, &ENTRY_ECONOMIZERS_11377293695267374301)],
        &[(0b01001, &ENTRY_ECONOMIZES_15039806622307012464)],
        &[(0b01001, &ENTRY_ECONOMIZING_9258997222217906936)],
    ],
    range: 7..=9,
};

static VARS_D_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_D_CHILDREN),
    value: None,
};

static VARS_D_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    None,
    None,
    Some(&VARS_DE_NODE),
    None,
    None,
    None,
    Some(&VARS_DI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_DO_NODE),
    None,
    None,
    Some(&VARS_DR_NODE),
    None,
    None,
    Some(&VARS_DU_NODE),
    None,
    None,
    None,
    Some(&VARS_DY_NODE),
    None,
];

static VARS_DY_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DY_CHILDREN),
    value: None,
};

pub static VARS_DY_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("spnea"),
        dictgen::InsensitiveAscii("spneas"),
        dictgen::InsensitiveAscii("spnoea"),
        dictgen::InsensitiveAscii("spnoeas"),
    ],
    values: &[
        &[(0b11001, &ENTRY_DYSPNEA_8650571964047698387)],
        &[(0b11001, &ENTRY_DYSPNEAS_9210940115108150000)],
        &[(0b10010, &ENTRY_DYSPNEA_8650571964047698387)],
        &[(0b10010, &ENTRY_DYSPNEAS_9210940115108150000)],
    ],
    range: 5..=7,
};

static VARS_DU_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DU_CHILDREN),
    value: None,
};

pub static VARS_DU_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("eled"),
        dictgen::InsensitiveAscii("eler"),
        dictgen::InsensitiveAscii("elers"),
        dictgen::InsensitiveAscii("eling"),
        dictgen::InsensitiveAscii("elings"),
        dictgen::InsensitiveAscii("elist"),
        dictgen::InsensitiveAscii("elists"),
        dictgen::InsensitiveAscii("elled"),
        dictgen::InsensitiveAscii("eller"),
        dictgen::InsensitiveAscii("ellers"),
        dictgen::InsensitiveAscii("elling"),
        dictgen::InsensitiveAscii("ellings"),
        dictgen::InsensitiveAscii("ellist"),
        dictgen::InsensitiveAscii("ellists"),
    ],
    values: &[
        &[(0b00001, &ENTRY_DUELED_9329917518038504527)],
        &[(0b00001, &ENTRY_DUELER_1881004460634174849)],
        &[(0b00001, &ENTRY_DUELERS_7359774943746748566)],
        &[(0b00001, &ENTRY_DUELING_517690675461305714)],
        &[(0b00001, &ENTRY_DUELINGS_16266636898439940215)],
        &[(0b00001, &ENTRY_DUELIST_3617834640500550373)],
        &[(0b00001, &ENTRY_DUELISTS_2315213851465914209)],
        &[(0b11010, &ENTRY_DUELED_9329917518038504527)],
        &[(0b11010, &ENTRY_DUELER_1881004460634174849)],
        &[(0b11010, &ENTRY_DUELERS_7359774943746748566)],
        &[(0b11010, &ENTRY_DUELING_517690675461305714)],
        &[(0b11010, &ENTRY_DUELINGS_16266636898439940215)],
        &[(0b11010, &ENTRY_DUELIST_3617834640500550373)],
        &[(0b11010, &ENTRY_DUELISTS_2315213851465914209)],
    ],
    range: 4..=7,
};

static VARS_DR_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DR_CHILDREN),
    value: None,
};

pub static VARS_DR_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("aftboard"),
        dictgen::InsensitiveAscii("aftboards"),
        dictgen::InsensitiveAscii("aftier"),
        dictgen::InsensitiveAscii("aftiest"),
        dictgen::InsensitiveAscii("aftilier"),
        dictgen::InsensitiveAscii("aftiliest"),
        dictgen::InsensitiveAscii("aftily"),
        dictgen::InsensitiveAscii("aftiness"),
        dictgen::InsensitiveAscii("aftinesses"),
        dictgen::InsensitiveAscii("aftsman"),
        dictgen::InsensitiveAscii("aftsmanship"),
        dictgen::InsensitiveAscii("aftsmanships"),
        dictgen::InsensitiveAscii("aftsmen"),
        dictgen::InsensitiveAscii("aftswoman"),
        dictgen::InsensitiveAscii("aftswomen"),
        dictgen::InsensitiveAscii("afty"),
        dictgen::InsensitiveAscii("amatisation"),
        dictgen::InsensitiveAscii("amatisations"),
        dictgen::InsensitiveAscii("amatise"),
        dictgen::InsensitiveAscii("amatised"),
        dictgen::InsensitiveAscii("amatises"),
        dictgen::InsensitiveAscii("amatising"),
        dictgen::InsensitiveAscii("amatization"),
        dictgen::InsensitiveAscii("amatizations"),
        dictgen::InsensitiveAscii("amatize"),
        dictgen::InsensitiveAscii("amatized"),
        dictgen::InsensitiveAscii("amatizes"),
        dictgen::InsensitiveAscii("amatizing"),
        dictgen::InsensitiveAscii("aughted"),
        dictgen::InsensitiveAscii("aughtier"),
        dictgen::InsensitiveAscii("aughtiest"),
        dictgen::InsensitiveAscii("aughtilier"),
        dictgen::InsensitiveAscii("aughtiliest"),
        dictgen::InsensitiveAscii("aughtily"),
        dictgen::InsensitiveAscii("aughtiness"),
        dictgen::InsensitiveAscii("aughtinesses"),
        dictgen::InsensitiveAscii("aughting"),
        dictgen::InsensitiveAscii("aughtsmanship"),
        dictgen::InsensitiveAscii("aughtsmanships"),
        dictgen::InsensitiveAscii("aughtswoman"),
        dictgen::InsensitiveAscii("aughtswomen"),
        dictgen::InsensitiveAscii("aughty"),
        dictgen::InsensitiveAscii("eamt"),
        dictgen::InsensitiveAscii("iveled"),
        dictgen::InsensitiveAscii("iveler"),
        dictgen::InsensitiveAscii("ivelers"),
        dictgen::InsensitiveAscii("iveling"),
        dictgen::InsensitiveAscii("ivelled"),
        dictgen::InsensitiveAscii("iveller"),
        dictgen::InsensitiveAscii("ivellers"),
        dictgen::InsensitiveAscii("ivelling"),
    ],
    values: &[
        &[(0b01001, &ENTRY_DRAUGHTBOARD_9322151322657814001)],
        &[(0b01001, &ENTRY_DRAUGHTBOARDS_18406148555375655231)],
        &[(0b01001, &ENTRY_DRAFTIER_10315157891310403943)],
        &[(0b01001, &ENTRY_DRAFTIEST_8211720032838927607)],
        &[(0b01001, &ENTRY_DRAFTILIER_7262684480559882840)],
        &[(0b01001, &ENTRY_DRAFTILIEST_9434728745324700875)],
        &[(0b01001, &ENTRY_DRAFTILY_16179502285729030019)],
        &[(0b01001, &ENTRY_DRAFTINESS_17583131269164652522)],
        &[(0b01001, &ENTRY_DRAFTINESSES_2329357781885563418)],
        &[(0b01001, &ENTRY_DRAFTSMAN_6333936616453092304)],
        &[(0b01001, &ENTRY_DRAFTSMANSHIP_15527745914295176647)],
        &[(0b01001, &ENTRY_DRAFTSMANSHIPS_4161880617470266425)],
        &[(0b01001, &ENTRY_DRAFTSMEN_7938842928790039444)],
        &[(0b01001, &ENTRY_DRAFTSWOMAN_15962715217490874254)],
        &[(0b01001, &ENTRY_DRAFTSWOMEN_1853126005122534712)],
        &[(0b01001, &ENTRY_DRAFTY_1579846262644957016)],
        &[(0b10010, &ENTRY_DRAMATIZATION_7793417852737015856)],
        &[(0b10010, &ENTRY_DRAMATIZATIONS_18020015640645554579)],
        &[(0b10010, &ENTRY_DRAMATIZE_5576714162148854490)],
        &[(0b10010, &ENTRY_DRAMATIZED_1183366410074875762)],
        &[(0b10010, &ENTRY_DRAMATIZES_17928119971239910049)],
        &[(0b10010, &ENTRY_DRAMATIZING_17356943686393270091)],
        &[(0b01001, &ENTRY_DRAMATIZATION_7793417852737015856)],
        &[(0b01001, &ENTRY_DRAMATIZATIONS_18020015640645554579)],
        &[(0b01001, &ENTRY_DRAMATIZE_5576714162148854490)],
        &[(0b01001, &ENTRY_DRAMATIZED_1183366410074875762)],
        &[(0b01001, &ENTRY_DRAMATIZES_17928119971239910049)],
        &[(0b01001, &ENTRY_DRAMATIZING_17356943686393270091)],
        &[(0b10010, &ENTRY_DRAFTED_17845159112580457751)],
        &[(0b10010, &ENTRY_DRAFTIER_10315157891310403943)],
        &[(0b10010, &ENTRY_DRAFTIEST_8211720032838927607)],
        &[(0b10010, &ENTRY_DRAFTILIER_7262684480559882840)],
        &[(0b10010, &ENTRY_DRAFTILIEST_9434728745324700875)],
        &[(0b10010, &ENTRY_DRAFTILY_16179502285729030019)],
        &[(0b10010, &ENTRY_DRAFTINESS_17583131269164652522)],
        &[(0b10010, &ENTRY_DRAFTINESSES_2329357781885563418)],
        &[(0b10010, &ENTRY_DRAFTING_9360381139157558092)],
        &[(0b10010, &ENTRY_DRAFTSMANSHIP_15527745914295176647)],
        &[(0b10010, &ENTRY_DRAFTSMANSHIPS_4161880617470266425)],
        &[(0b10010, &ENTRY_DRAFTSWOMAN_15962715217490874254)],
        &[(0b10010, &ENTRY_DRAFTSWOMEN_1853126005122534712)],
        &[(0b10010, &ENTRY_DRAFTY_1579846262644957016)],
        &[(0b11010, &ENTRY_DREAMED_8816476032248430540)],
        &[(0b00001, &ENTRY_DRIVELED_10369632498060637218)],
        &[(0b00001, &ENTRY_DRIVELER_5677282658106600455)],
        &[(0b00001, &ENTRY_DRIVELERS_292810807634252006)],
        &[(0b00001, &ENTRY_DRIVELING_9276931416261875171)],
        &[(0b11010, &ENTRY_DRIVELED_10369632498060637218)],
        &[(0b11010, &ENTRY_DRIVELER_5677282658106600455)],
        &[(0b11010, &ENTRY_DRIVELERS_292810807634252006)],
        &[(0b11010, &ENTRY_DRIVELING_9276931416261875171)],
    ],
    range: 4..=14,
};

static VARS_DO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DO_CHILDREN),
    value: None,
};

pub static VARS_DO_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("gmatise"),
        dictgen::InsensitiveAscii("gmatised"),
        dictgen::InsensitiveAscii("gmatises"),
        dictgen::InsensitiveAscii("gmatising"),
        dictgen::InsensitiveAscii("gmatize"),
        dictgen::InsensitiveAscii("gmatized"),
        dictgen::InsensitiveAscii("gmatizes"),
        dictgen::InsensitiveAscii("gmatizing"),
        dictgen::InsensitiveAscii("lor"),
        dictgen::InsensitiveAscii("lors"),
        dictgen::InsensitiveAscii("lour"),
        dictgen::InsensitiveAscii("lours"),
        dictgen::InsensitiveAscii("nut"),
        dictgen::InsensitiveAscii("nuts"),
        dictgen::InsensitiveAscii("wndraft"),
        dictgen::InsensitiveAscii("wndraught"),
    ],
    values: &[
        &[(0b10010, &ENTRY_DOGMATIZE_4788814445794390818)],
        &[(0b10010, &ENTRY_DOGMATIZED_12823946452811271962)],
        &[(0b10010, &ENTRY_DOGMATIZES_15001409429715187150)],
        &[(0b10010, &ENTRY_DOGMATIZING_17332622864075797339)],
        &[(0b01001, &ENTRY_DOGMATIZE_4788814445794390818)],
        &[(0b01001, &ENTRY_DOGMATIZED_12823946452811271962)],
        &[(0b01001, &ENTRY_DOGMATIZES_15001409429715187150)],
        &[(0b01001, &ENTRY_DOGMATIZING_17332622864075797339)],
        &[(0b11001, &ENTRY_DOLOR_11069244362262877679)],
        &[(0b11001, &ENTRY_DOLORS_8418108938588101110)],
        &[(0b11010, &ENTRY_DOLOR_11069244362262877679)],
        &[(0b11010, &ENTRY_DOLORS_8418108938588101110)],
        &[(0b00001, &ENTRY_DOUGHNUT_18126283850351248332)],
        &[(0b00001, &ENTRY_DOUGHNUTS_10463227561131847319)],
        &[(0b01001, &ENTRY_DOWNDRAFT_672818375102871084)],
        &[(0b10010, &ENTRY_DOWNDRAFT_672818375102871084)],
    ],
    range: 3..=9,
};

static VARS_DI_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_DI_CHILDREN),
    value: None,
};

static VARS_DI_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_DIA_NODE),
    None,
    Some(&VARS_DIC_NODE),
    None,
    Some(&VARS_DIE_NODE),
    None,
    Some(&VARS_DIG_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_DIO_NODE),
    Some(&VARS_DIP_NODE),
    None,
    None,
    Some(&VARS_DIS_NODE),
    None,
    None,
    Some(&VARS_DIV_NODE),
    None,
    None,
    None,
    None,
];

static VARS_DIV_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DIV_CHILDREN),
    value: None,
};

pub static VARS_DIV_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("inise"),
        dictgen::InsensitiveAscii("inised"),
        dictgen::InsensitiveAscii("inises"),
        dictgen::InsensitiveAscii("inising"),
        dictgen::InsensitiveAscii("inize"),
        dictgen::InsensitiveAscii("inized"),
        dictgen::InsensitiveAscii("inizes"),
        dictgen::InsensitiveAscii("inizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_DIVINIZE_8792843604983197190)],
        &[(0b10010, &ENTRY_DIVINIZED_6811293569537741594)],
        &[(0b10010, &ENTRY_DIVINIZES_15547907663135588559)],
        &[(0b10010, &ENTRY_DIVINIZING_10978447348346172564)],
        &[(0b01001, &ENTRY_DIVINIZE_8792843604983197190)],
        &[(0b01001, &ENTRY_DIVINIZED_6811293569537741594)],
        &[(0b01001, &ENTRY_DIVINIZES_15547907663135588559)],
        &[(0b01001, &ENTRY_DIVINIZING_10978447348346172564)],
    ],
    range: 5..=7,
};

static VARS_DIS_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_DIS_CHILDREN),
    value: None,
};

static VARS_DIS_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    Some(&VARS_DISC_NODE),
    None,
    Some(&VARS_DISE_NODE),
    Some(&VARS_DISF_NODE),
    None,
    Some(&VARS_DISH_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_DISO_NODE),
    None,
    None,
    None,
    None,
    Some(&VARS_DIST_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_DIST_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DIST_CHILDREN),
    value: None,
};

pub static VARS_DIST_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ill"),
        dictgen::InsensitiveAscii("ills"),
    ],
    values: &[
        &[(0b01001, &ENTRY_DISTILL_72998375259612317)],
        &[(0b01001, &ENTRY_DISTILLS_6330479058124863728)],
    ],
    range: 3..=4,
};

static VARS_DISO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DISO_CHILDREN),
    value: None,
};

pub static VARS_DISO_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("rganisation"),
        dictgen::InsensitiveAscii("rganisations"),
        dictgen::InsensitiveAscii("rganise"),
        dictgen::InsensitiveAscii("rganised"),
        dictgen::InsensitiveAscii("rganises"),
        dictgen::InsensitiveAscii("rganising"),
        dictgen::InsensitiveAscii("rganization"),
        dictgen::InsensitiveAscii("rganizations"),
        dictgen::InsensitiveAscii("rganize"),
        dictgen::InsensitiveAscii("rganized"),
        dictgen::InsensitiveAscii("rganizes"),
        dictgen::InsensitiveAscii("rganizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_DISORGANIZATION_16996811069576322696)],
        &[(0b10010, &ENTRY_DISORGANIZATIONS_5594690456228431300)],
        &[(0b10010, &ENTRY_DISORGANIZE_8532063637419651098)],
        &[(0b10010, &ENTRY_DISORGANIZED_8174306046630470447)],
        &[(0b10010, &ENTRY_DISORGANIZES_2153949974040488529)],
        &[(0b10010, &ENTRY_DISORGANIZING_9571942280468279076)],
        &[(0b01001, &ENTRY_DISORGANIZATION_16996811069576322696)],
        &[(0b01001, &ENTRY_DISORGANIZATIONS_5594690456228431300)],
        &[(0b01001, &ENTRY_DISORGANIZE_8532063637419651098)],
        &[(0b01001, &ENTRY_DISORGANIZED_8174306046630470447)],
        &[(0b01001, &ENTRY_DISORGANIZES_2153949974040488529)],
        &[(0b01001, &ENTRY_DISORGANIZING_9571942280468279076)],
    ],
    range: 7..=12,
};

static VARS_DISH_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DISH_CHILDREN),
    value: None,
};

pub static VARS_DISH_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("eveled"),
        dictgen::InsensitiveAscii("eveling"),
        dictgen::InsensitiveAscii("evelled"),
        dictgen::InsensitiveAscii("evelling"),
        dictgen::InsensitiveAscii("onor"),
        dictgen::InsensitiveAscii("onorable"),
        dictgen::InsensitiveAscii("onorableness"),
        dictgen::InsensitiveAscii("onorablenesses"),
        dictgen::InsensitiveAscii("onorabler"),
        dictgen::InsensitiveAscii("onorables"),
        dictgen::InsensitiveAscii("onorablest"),
        dictgen::InsensitiveAscii("onorablier"),
        dictgen::InsensitiveAscii("onorablies"),
        dictgen::InsensitiveAscii("onorabliest"),
        dictgen::InsensitiveAscii("onorably"),
        dictgen::InsensitiveAscii("onored"),
        dictgen::InsensitiveAscii("onoring"),
        dictgen::InsensitiveAscii("onors"),
        dictgen::InsensitiveAscii("onour"),
        dictgen::InsensitiveAscii("onourable"),
        dictgen::InsensitiveAscii("onourableness"),
        dictgen::InsensitiveAscii("onourablenesses"),
        dictgen::InsensitiveAscii("onourabler"),
        dictgen::InsensitiveAscii("onourables"),
        dictgen::InsensitiveAscii("onourablest"),
        dictgen::InsensitiveAscii("onourablier"),
        dictgen::InsensitiveAscii("onourablies"),
        dictgen::InsensitiveAscii("onourabliest"),
        dictgen::InsensitiveAscii("onourably"),
        dictgen::InsensitiveAscii("onoured"),
        dictgen::InsensitiveAscii("onouring"),
        dictgen::InsensitiveAscii("onours"),
    ],
    values: &[
        &[(0b00001, &ENTRY_DISHEVELED_870550093566288707)],
        &[(0b00001, &ENTRY_DISHEVELING_6322833404479205492)],
        &[(0b11010, &ENTRY_DISHEVELED_870550093566288707)],
        &[(0b11010, &ENTRY_DISHEVELING_6322833404479205492)],
        &[(0b11001, &ENTRY_DISHONOR_11620713121077259513)],
        &[(0b11001, &ENTRY_DISHONORABLE_38080454965404032)],
        &[(0b11001, &ENTRY_DISHONORABLENESS_10657592516833463167)],
        &[(0b11001, &ENTRY_DISHONORABLENESSES_17639524963688776538)],
        &[(0b11001, &ENTRY_DISHONORABLER_13799504522206021743)],
        &[(0b11001, &ENTRY_DISHONORABLES_16248754702342750197)],
        &[(0b11001, &ENTRY_DISHONORABLEST_15156355191001228972)],
        &[(0b11001, &ENTRY_DISHONORABLIER_1654116585736260216)],
        &[(0b11001, &ENTRY_DISHONORABLIES_15514876857964789392)],
        &[(0b11001, &ENTRY_DISHONORABLIEST_16101869312549419261)],
        &[(0b11001, &ENTRY_DISHONORABLY_7020648298729028040)],
        &[(0b11001, &ENTRY_DISHONORED_2157274559673536220)],
        &[(0b11001, &ENTRY_DISHONORING_2399726273028722915)],
        &[(0b11001, &ENTRY_DISHONORS_1597149550458150983)],
        &[(0b11010, &ENTRY_DISHONOR_11620713121077259513)],
        &[(0b11010, &ENTRY_DISHONORABLE_38080454965404032)],
        &[(0b11010, &ENTRY_DISHONORABLENESS_10657592516833463167)],
        &[(0b11010, &ENTRY_DISHONORABLENESSES_17639524963688776538)],
        &[(0b11010, &ENTRY_DISHONORABLER_13799504522206021743)],
        &[(0b11010, &ENTRY_DISHONORABLES_16248754702342750197)],
        &[(0b11010, &ENTRY_DISHONORABLEST_15156355191001228972)],
        &[(0b11010, &ENTRY_DISHONORABLIER_1654116585736260216)],
        &[(0b11010, &ENTRY_DISHONORABLIES_15514876857964789392)],
        &[(0b11010, &ENTRY_DISHONORABLIEST_16101869312549419261)],
        &[(0b11010, &ENTRY_DISHONORABLY_7020648298729028040)],
        &[(0b11010, &ENTRY_DISHONORED_2157274559673536220)],
        &[(0b11010, &ENTRY_DISHONORING_2399726273028722915)],
        &[(0b11010, &ENTRY_DISHONORS_1597149550458150983)],
    ],
    range: 4..=15,
};

static VARS_DISF_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DISF_CHILDREN),
    value: None,
};

pub static VARS_DISF_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("avor"),
        dictgen::InsensitiveAscii("avored"),
        dictgen::InsensitiveAscii("avoring"),
        dictgen::InsensitiveAscii("avors"),
        dictgen::InsensitiveAscii("avour"),
        dictgen::InsensitiveAscii("avoured"),
        dictgen::InsensitiveAscii("avouring"),
        dictgen::InsensitiveAscii("avours"),
    ],
    values: &[
        &[(0b11001, &ENTRY_DISFAVOR_11771334909061188611)],
        &[(0b11001, &ENTRY_DISFAVORED_6170594285770625316)],
        &[(0b11001, &ENTRY_DISFAVORING_8029210556789284619)],
        &[(0b11001, &ENTRY_DISFAVORS_7649343434045517378)],
        &[(0b11010, &ENTRY_DISFAVOR_11771334909061188611)],
        &[(0b11010, &ENTRY_DISFAVORED_6170594285770625316)],
        &[(0b11010, &ENTRY_DISFAVORING_8029210556789284619)],
        &[(0b11010, &ENTRY_DISFAVORS_7649343434045517378)],
    ],
    range: 4..=8,
};

static VARS_DISE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DISE_CHILDREN),
    value: None,
};

pub static VARS_DISE_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("mboweled"),
        dictgen::InsensitiveAscii("mboweling"),
        dictgen::InsensitiveAscii("mbowelled"),
        dictgen::InsensitiveAscii("mbowelling"),
    ],
    values: &[
        &[(0b00001, &ENTRY_DISEMBOWELED_4919626984837066547)],
        &[(0b00001, &ENTRY_DISEMBOWELING_17785417677818928746)],
        &[(0b11010, &ENTRY_DISEMBOWELED_4919626984837066547)],
        &[(0b11010, &ENTRY_DISEMBOWELING_17785417677818928746)],
    ],
    range: 8..=10,
};

static VARS_DISC_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DISC_CHILDREN),
    value: None,
};

pub static VARS_DISC_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("olor"),
        dictgen::InsensitiveAscii("olored"),
        dictgen::InsensitiveAscii("oloreds"),
        dictgen::InsensitiveAscii("oloring"),
        dictgen::InsensitiveAscii("olors"),
        dictgen::InsensitiveAscii("olour"),
        dictgen::InsensitiveAscii("olouration"),
        dictgen::InsensitiveAscii("olourations"),
        dictgen::InsensitiveAscii("oloured"),
        dictgen::InsensitiveAscii("oloureds"),
        dictgen::InsensitiveAscii("olouring"),
        dictgen::InsensitiveAscii("olours"),
    ],
    values: &[
        &[(0b01001, &ENTRY_DISCOLOR_2037841141685560590)],
        &[(0b01001, &ENTRY_DISCOLORED_16908798995974595866)],
        &[(0b01001, &ENTRY_DISCOLOREDS_7473250501334264517)],
        &[(0b01001, &ENTRY_DISCOLORING_8629722440902022000)],
        &[(0b01001, &ENTRY_DISCOLORS_3188891474327267925)],
        &[(0b11010, &ENTRY_DISCOLOR_2037841141685560590)],
        &[(0b11010, &ENTRY_DISCOLORATION_1217061862280012422)],
        &[(0b11010, &ENTRY_DISCOLORATIONS_1674651272709360573)],
        &[(0b11010, &ENTRY_DISCOLORED_16908798995974595866)],
        &[(0b11010, &ENTRY_DISCOLOREDS_7473250501334264517)],
        &[(0b11010, &ENTRY_DISCOLORING_8629722440902022000)],
        &[(0b11010, &ENTRY_DISCOLORS_3188891474327267925)],
    ],
    range: 4..=11,
};

static VARS_DIP_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DIP_CHILDREN),
    value: None,
};

pub static VARS_DIP_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("hthongisation"),
        dictgen::InsensitiveAscii("hthongisations"),
        dictgen::InsensitiveAscii("hthongise"),
        dictgen::InsensitiveAscii("hthongised"),
        dictgen::InsensitiveAscii("hthongises"),
        dictgen::InsensitiveAscii("hthongising"),
        dictgen::InsensitiveAscii("hthongization"),
        dictgen::InsensitiveAscii("hthongizations"),
        dictgen::InsensitiveAscii("hthongize"),
        dictgen::InsensitiveAscii("hthongized"),
        dictgen::InsensitiveAscii("hthongizes"),
        dictgen::InsensitiveAscii("hthongizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_DIPHTHONGIZATION_17407501498744325663)],
        &[(0b10010, &ENTRY_DIPHTHONGIZATIONS_2030371554784749334)],
        &[(0b10010, &ENTRY_DIPHTHONGIZE_10084557415323022414)],
        &[(0b10010, &ENTRY_DIPHTHONGIZED_13148843710594941732)],
        &[(0b10010, &ENTRY_DIPHTHONGIZES_13677092120190203653)],
        &[(0b10010, &ENTRY_DIPHTHONGIZING_11085495889059563585)],
        &[(0b01001, &ENTRY_DIPHTHONGIZATION_17407501498744325663)],
        &[(0b01001, &ENTRY_DIPHTHONGIZATIONS_2030371554784749334)],
        &[(0b01001, &ENTRY_DIPHTHONGIZE_10084557415323022414)],
        &[(0b01001, &ENTRY_DIPHTHONGIZED_13148843710594941732)],
        &[(0b01001, &ENTRY_DIPHTHONGIZES_13677092120190203653)],
        &[(0b01001, &ENTRY_DIPHTHONGIZING_11085495889059563585)],
    ],
    range: 9..=14,
};

static VARS_DIO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DIO_CHILDREN),
    value: None,
};

pub static VARS_DIO_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("pter"),
        dictgen::InsensitiveAscii("pters"),
        dictgen::InsensitiveAscii("ptre"),
        dictgen::InsensitiveAscii("ptres"),
    ],
    values: &[
        &[(0b01001, &ENTRY_DIOPTER_16953349812175946912)],
        &[(0b01001, &ENTRY_DIOPTERS_11469688744147601313)],
        &[(0b11010, &ENTRY_DIOPTER_16953349812175946912)],
        &[(0b11010, &ENTRY_DIOPTERS_11469688744147601313)],
    ],
    range: 4..=5,
};

static VARS_DIG_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DIG_CHILDREN),
    value: None,
};

pub static VARS_DIG_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("italise"),
        dictgen::InsensitiveAscii("italised"),
        dictgen::InsensitiveAscii("italising"),
        dictgen::InsensitiveAscii("italize"),
        dictgen::InsensitiveAscii("italized"),
        dictgen::InsensitiveAscii("italizes"),
        dictgen::InsensitiveAscii("italizing"),
        dictgen::InsensitiveAscii("itisation"),
        dictgen::InsensitiveAscii("itisations"),
        dictgen::InsensitiveAscii("itise"),
        dictgen::InsensitiveAscii("itised"),
        dictgen::InsensitiveAscii("itiser"),
        dictgen::InsensitiveAscii("itisers"),
        dictgen::InsensitiveAscii("itises"),
        dictgen::InsensitiveAscii("itising"),
        dictgen::InsensitiveAscii("itization"),
        dictgen::InsensitiveAscii("itizations"),
        dictgen::InsensitiveAscii("itize"),
        dictgen::InsensitiveAscii("itized"),
        dictgen::InsensitiveAscii("itizer"),
        dictgen::InsensitiveAscii("itizers"),
        dictgen::InsensitiveAscii("itizes"),
        dictgen::InsensitiveAscii("itizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_DIGITALIZE_641397969368171855)],
        &[(0b10010, &ENTRY_DIGITALIZED_10523465632142129010)],
        &[(0b10010, &ENTRY_DIGITALIZING_5222161273491894931)],
        &[(0b01001, &ENTRY_DIGITALIZE_641397969368171855)],
        &[(0b01001, &ENTRY_DIGITALIZED_10523465632142129010)],
        &[(0b01001, &ENTRY_DIGITALIZES_16738992677023261947)],
        &[(0b01001, &ENTRY_DIGITALIZING_5222161273491894931)],
        &[(0b10010, &ENTRY_DIGITIZATION_16526021465569627029)],
        &[(0b10010, &ENTRY_DIGITIZATIONS_16075534772362552339)],
        &[(0b10010, &ENTRY_DIGITIZE_2409600049499220627)],
        &[(0b10010, &ENTRY_DIGITIZED_9086015022851622383)],
        &[(0b10010, &ENTRY_DIGITIZER_17878398947103509512)],
        &[(0b10010, &ENTRY_DIGITIZERS_13765203491581800269)],
        &[(0b10010, &ENTRY_DIGITIZES_8019423972202149279)],
        &[(0b10010, &ENTRY_DIGITIZING_18195991368262756258)],
        &[(0b01001, &ENTRY_DIGITIZATION_16526021465569627029)],
        &[(0b01001, &ENTRY_DIGITIZATIONS_16075534772362552339)],
        &[(0b01001, &ENTRY_DIGITIZE_2409600049499220627)],
        &[(0b01001, &ENTRY_DIGITIZED_9086015022851622383)],
        &[(0b01001, &ENTRY_DIGITIZER_17878398947103509512)],
        &[(0b01001, &ENTRY_DIGITIZERS_13765203491581800269)],
        &[(0b01001, &ENTRY_DIGITIZES_8019423972202149279)],
        &[(0b01001, &ENTRY_DIGITIZING_18195991368262756258)],
    ],
    range: 5..=10,
};

static VARS_DIE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DIE_CHILDREN),
    value: None,
};

pub static VARS_DIE_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[dictgen::InsensitiveAscii("cious")],
    values: &[&[(0b00001, &ENTRY_DIOECIOUS_755179665025369568)]],
    range: 5..=5,
};

static VARS_DIC_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DIC_CHILDREN),
    value: None,
};

pub static VARS_DIC_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("hotomise"),
        dictgen::InsensitiveAscii("hotomised"),
        dictgen::InsensitiveAscii("hotomises"),
        dictgen::InsensitiveAscii("hotomising"),
        dictgen::InsensitiveAscii("hotomize"),
        dictgen::InsensitiveAscii("hotomized"),
        dictgen::InsensitiveAscii("hotomizes"),
        dictgen::InsensitiveAscii("hotomizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_DICHOTOMIZE_10272954486831643030)],
        &[(0b10010, &ENTRY_DICHOTOMIZED_6365894040247689611)],
        &[(0b10010, &ENTRY_DICHOTOMIZES_6036836042986433362)],
        &[(0b10010, &ENTRY_DICHOTOMIZING_12141393071288009958)],
        &[(0b01001, &ENTRY_DICHOTOMIZE_10272954486831643030)],
        &[(0b01001, &ENTRY_DICHOTOMIZED_6365894040247689611)],
        &[(0b01001, &ENTRY_DICHOTOMIZES_6036836042986433362)],
        &[(0b01001, &ENTRY_DICHOTOMIZING_12141393071288009958)],
    ],
    range: 8..=10,
};

static VARS_DIA_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DIA_CHILDREN),
    value: None,
};

pub static VARS_DIA_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("led"),
        dictgen::InsensitiveAscii("ling"),
        dictgen::InsensitiveAscii("lings"),
        dictgen::InsensitiveAscii("lled"),
        dictgen::InsensitiveAscii("lling"),
        dictgen::InsensitiveAscii("llings"),
        dictgen::InsensitiveAscii("logged"),
        dictgen::InsensitiveAscii("logging"),
        dictgen::InsensitiveAscii("logs"),
        dictgen::InsensitiveAscii("lyse"),
        dictgen::InsensitiveAscii("lysed"),
        dictgen::InsensitiveAscii("lysing"),
        dictgen::InsensitiveAscii("lyze"),
        dictgen::InsensitiveAscii("lyzed"),
        dictgen::InsensitiveAscii("lyzes"),
        dictgen::InsensitiveAscii("lyzing"),
        dictgen::InsensitiveAscii("rrhea"),
        dictgen::InsensitiveAscii("rrheal"),
        dictgen::InsensitiveAscii("rrhealer"),
        dictgen::InsensitiveAscii("rrhealest"),
        dictgen::InsensitiveAscii("rrheas"),
        dictgen::InsensitiveAscii("rrhoea"),
        dictgen::InsensitiveAscii("rrhoeal"),
        dictgen::InsensitiveAscii("rrhoealer"),
        dictgen::InsensitiveAscii("rrhoealest"),
        dictgen::InsensitiveAscii("rrhoeas"),
    ],
    values: &[
        &[(0b01001, &ENTRY_DIALED_8624721026195652691)],
        &[(0b01001, &ENTRY_DIALING_14894824825058184021)],
        &[(0b01001, &ENTRY_DIALINGS_16812342776213308353)],
        &[(0b11010, &ENTRY_DIALED_8624721026195652691)],
        &[(0b11010, &ENTRY_DIALING_14894824825058184021)],
        &[(0b11010, &ENTRY_DIALINGS_16812342776213308353)],
        &[(0b00001, &ENTRY_DIALOGUED_6096361692015426802)],
        &[(0b00001, &ENTRY_DIALOGUING_11388291889533762516)],
        &[(0b00001, &ENTRY_DIALOGUES_11293834938019836177)],
        &[(0b10010, &ENTRY_DIALYZE_1688147137734168562)],
        &[(0b10010, &ENTRY_DIALYZED_14166787736891210495)],
        &[(0b10010, &ENTRY_DIALYZING_14844209232520540927)],
        &[(0b01001, &ENTRY_DIALYZE_1688147137734168562)],
        &[(0b01001, &ENTRY_DIALYZED_14166787736891210495)],
        &[(0b01001, &ENTRY_DIALYZES_7300597766358786533)],
        &[(0b01001, &ENTRY_DIALYZING_14844209232520540927)],
        &[(0b11001, &ENTRY_DIARRHEA_3911277028508716960)],
        &[(0b11001, &ENTRY_DIARRHEAL_13632347487774327311)],
        &[(0b11001, &ENTRY_DIARRHEALER_3006325160958144376)],
        &[(0b11001, &ENTRY_DIARRHEALEST_17262839018541832325)],
        &[(0b11001, &ENTRY_DIARRHEAS_15185377414757726510)],
        &[(0b10010, &ENTRY_DIARRHEA_3911277028508716960)],
        &[(0b10010, &ENTRY_DIARRHEAL_13632347487774327311)],
        &[(0b10010, &ENTRY_DIARRHEALER_3006325160958144376)],
        &[(0b10010, &ENTRY_DIARRHEALEST_17262839018541832325)],
        &[(0b10010, &ENTRY_DIARRHEAS_15185377414757726510)],
    ],
    range: 3..=10,
};

static VARS_DE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_DE_CHILDREN),
    value: None,
};

static VARS_DE_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    Some(&VARS_DEC_NODE),
    None,
    None,
    Some(&VARS_DEF_NODE),
    None,
    Some(&VARS_DEH_NODE),
    Some(&VARS_DEI_NODE),
    None,
    None,
    Some(&VARS_DEL_NODE),
    Some(&VARS_DEM_NODE),
    Some(&VARS_DEN_NODE),
    Some(&VARS_DEO_NODE),
    Some(&VARS_DEP_NODE),
    None,
    None,
    Some(&VARS_DES_NODE),
    Some(&VARS_DET_NODE),
    None,
    Some(&VARS_DEV_NODE),
    None,
    None,
    None,
    None,
];

static VARS_DEV_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DEV_CHILDREN),
    value: None,
};

pub static VARS_DEV_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("iled"),
        dictgen::InsensitiveAscii("iling"),
        dictgen::InsensitiveAscii("illed"),
        dictgen::InsensitiveAscii("illing"),
        dictgen::InsensitiveAscii("italisation"),
        dictgen::InsensitiveAscii("italisations"),
        dictgen::InsensitiveAscii("italise"),
        dictgen::InsensitiveAscii("italised"),
        dictgen::InsensitiveAscii("italises"),
        dictgen::InsensitiveAscii("italising"),
        dictgen::InsensitiveAscii("italization"),
        dictgen::InsensitiveAscii("italizations"),
        dictgen::InsensitiveAscii("italize"),
        dictgen::InsensitiveAscii("italized"),
        dictgen::InsensitiveAscii("italizes"),
        dictgen::InsensitiveAscii("italizing"),
    ],
    values: &[
        &[(0b00001, &ENTRY_DEVILED_3048829577081044907)],
        &[(0b00001, &ENTRY_DEVILING_2852485461150693530)],
        &[(0b11010, &ENTRY_DEVILED_3048829577081044907)],
        &[(0b11010, &ENTRY_DEVILING_2852485461150693530)],
        &[(0b10010, &ENTRY_DEVITALIZATION_15852094530751489673)],
        &[(0b10010, &ENTRY_DEVITALIZATIONS_1168911391057981701)],
        &[(0b10010, &ENTRY_DEVITALIZE_5134304117244312868)],
        &[(0b10010, &ENTRY_DEVITALIZED_2614953819800812061)],
        &[(0b10010, &ENTRY_DEVITALIZES_8740304697698136600)],
        &[(0b10010, &ENTRY_DEVITALIZING_432513802469216184)],
        &[(0b01001, &ENTRY_DEVITALIZATION_15852094530751489673)],
        &[(0b01001, &ENTRY_DEVITALIZATIONS_1168911391057981701)],
        &[(0b01001, &ENTRY_DEVITALIZE_5134304117244312868)],
        &[(0b01001, &ENTRY_DEVITALIZED_2614953819800812061)],
        &[(0b01001, &ENTRY_DEVITALIZES_8740304697698136600)],
        &[(0b01001, &ENTRY_DEVITALIZING_432513802469216184)],
    ],
    range: 4..=12,
};

static VARS_DET_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DET_CHILDREN),
    value: None,
};

pub static VARS_DET_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ribalisation"),
        dictgen::InsensitiveAscii("ribalisations"),
        dictgen::InsensitiveAscii("ribalise"),
        dictgen::InsensitiveAscii("ribalised"),
        dictgen::InsensitiveAscii("ribalises"),
        dictgen::InsensitiveAscii("ribalising"),
        dictgen::InsensitiveAscii("ribalization"),
        dictgen::InsensitiveAscii("ribalizations"),
        dictgen::InsensitiveAscii("ribalize"),
        dictgen::InsensitiveAscii("ribalized"),
        dictgen::InsensitiveAscii("ribalizes"),
        dictgen::InsensitiveAscii("ribalizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_DETRIBALIZATION_1652215190238627536)],
        &[(0b10010, &ENTRY_DETRIBALIZATIONS_10197716064139754204)],
        &[(0b10010, &ENTRY_DETRIBALIZE_1614085836292794906)],
        &[(0b10010, &ENTRY_DETRIBALIZED_8262386414888942658)],
        &[(0b10010, &ENTRY_DETRIBALIZES_10964606572749162711)],
        &[(0b10010, &ENTRY_DETRIBALIZING_4078840495989197779)],
        &[(0b01001, &ENTRY_DETRIBALIZATION_1652215190238627536)],
        &[(0b01001, &ENTRY_DETRIBALIZATIONS_10197716064139754204)],
        &[(0b01001, &ENTRY_DETRIBALIZE_1614085836292794906)],
        &[(0b01001, &ENTRY_DETRIBALIZED_8262386414888942658)],
        &[(0b01001, &ENTRY_DETRIBALIZES_10964606572749162711)],
        &[(0b01001, &ENTRY_DETRIBALIZING_4078840495989197779)],
    ],
    range: 8..=13,
};

static VARS_DES_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_DES_CHILDREN),
    value: None,
};

static VARS_DES_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_DESA_NODE),
    None,
    Some(&VARS_DESC_NODE),
    None,
    Some(&VARS_DESE_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_DESP_NODE),
    None,
    None,
    None,
    Some(&VARS_DEST_NODE),
    Some(&VARS_DESU_NODE),
    None,
    None,
    None,
    None,
    None,
];

static VARS_DESU_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DESU_CHILDREN),
    value: None,
};

pub static VARS_DESU_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("lfurization"),
        dictgen::InsensitiveAscii("lfurizations"),
        dictgen::InsensitiveAscii("lfurize"),
        dictgen::InsensitiveAscii("lfurized"),
        dictgen::InsensitiveAscii("lfurizes"),
        dictgen::InsensitiveAscii("lfurizing"),
        dictgen::InsensitiveAscii("lphurisation"),
        dictgen::InsensitiveAscii("lphurisations"),
        dictgen::InsensitiveAscii("lphurise"),
        dictgen::InsensitiveAscii("lphurised"),
        dictgen::InsensitiveAscii("lphurises"),
        dictgen::InsensitiveAscii("lphurising"),
        dictgen::InsensitiveAscii("lphurization"),
        dictgen::InsensitiveAscii("lphurizations"),
        dictgen::InsensitiveAscii("lphurize"),
        dictgen::InsensitiveAscii("lphurized"),
        dictgen::InsensitiveAscii("lphurizes"),
        dictgen::InsensitiveAscii("lphurizing"),
    ],
    values: &[
        &[(0b00001, &ENTRY_DESULFURIZATION_7274801890477561400)],
        &[(0b00001, &ENTRY_DESULFURIZATIONS_2177003244823249071)],
        &[(0b00001, &ENTRY_DESULFURIZE_13186827014999009464)],
        &[(0b00001, &ENTRY_DESULFURIZED_2406386063012452485)],
        &[(0b00001, &ENTRY_DESULFURIZES_35072370079092901)],
        &[(0b00001, &ENTRY_DESULFURIZING_15868123655289821047)],
        &[(0b10010, &ENTRY_DESULFURIZATION_7274801890477561400)],
        &[(0b10010, &ENTRY_DESULFURIZATIONS_2177003244823249071)],
        &[(0b10010, &ENTRY_DESULFURIZE_13186827014999009464)],
        &[(0b10010, &ENTRY_DESULFURIZED_2406386063012452485)],
        &[(0b10010, &ENTRY_DESULFURIZES_35072370079092901)],
        &[(0b10010, &ENTRY_DESULFURIZING_15868123655289821047)],
        &[(0b01000, &ENTRY_DESULFURIZATION_7274801890477561400)],
        &[(0b01000, &ENTRY_DESULFURIZATIONS_2177003244823249071)],
        &[(0b01000, &ENTRY_DESULFURIZE_13186827014999009464)],
        &[(0b01000, &ENTRY_DESULFURIZED_2406386063012452485)],
        &[(0b01000, &ENTRY_DESULFURIZES_35072370079092901)],
        &[(0b01000, &ENTRY_DESULFURIZING_15868123655289821047)],
    ],
    range: 7..=13,
};

static VARS_DEST_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DEST_CHILDREN),
    value: None,
};

pub static VARS_DEST_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("abilisation"),
        dictgen::InsensitiveAscii("abilise"),
        dictgen::InsensitiveAscii("abilised"),
        dictgen::InsensitiveAscii("abilises"),
        dictgen::InsensitiveAscii("abilising"),
        dictgen::InsensitiveAscii("abilization"),
        dictgen::InsensitiveAscii("abilize"),
        dictgen::InsensitiveAscii("abilized"),
        dictgen::InsensitiveAscii("abilizes"),
        dictgen::InsensitiveAscii("abilizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_DESTABILIZATION_13317005930133883698)],
        &[(0b10010, &ENTRY_DESTABILIZE_6658582433887926026)],
        &[(0b10010, &ENTRY_DESTABILIZED_798803001524481006)],
        &[(0b10010, &ENTRY_DESTABILIZES_9175954977739946204)],
        &[(0b10010, &ENTRY_DESTABILIZING_11313904175788895920)],
        &[(0b01001, &ENTRY_DESTABILIZATION_13317005930133883698)],
        &[(0b01001, &ENTRY_DESTABILIZE_6658582433887926026)],
        &[(0b01001, &ENTRY_DESTABILIZED_798803001524481006)],
        &[(0b01001, &ENTRY_DESTABILIZES_9175954977739946204)],
        &[(0b01001, &ENTRY_DESTABILIZING_11313904175788895920)],
    ],
    range: 7..=11,
};

static VARS_DESP_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DESP_CHILDREN),
    value: None,
};

pub static VARS_DESP_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("atch"),
        dictgen::InsensitiveAscii("atched"),
        dictgen::InsensitiveAscii("atches"),
        dictgen::InsensitiveAscii("atching"),
    ],
    values: &[
        &[(0b10011, &ENTRY_DISPATCH_1411749765220275516)],
        &[(0b10011, &ENTRY_DISPATCHED_15237234107206890876)],
        &[(0b10011, &ENTRY_DISPATCHES_6888853082053231509)],
        &[(0b10011, &ENTRY_DISPATCHING_14791196208532843181)],
    ],
    range: 4..=7,
};

static VARS_DESE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DESE_CHILDREN),
    value: None,
};

pub static VARS_DESE_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("nsitisation"),
        dictgen::InsensitiveAscii("nsitisations"),
        dictgen::InsensitiveAscii("nsitise"),
        dictgen::InsensitiveAscii("nsitised"),
        dictgen::InsensitiveAscii("nsitiser"),
        dictgen::InsensitiveAscii("nsitisers"),
        dictgen::InsensitiveAscii("nsitises"),
        dictgen::InsensitiveAscii("nsitising"),
        dictgen::InsensitiveAscii("nsitization"),
        dictgen::InsensitiveAscii("nsitizations"),
        dictgen::InsensitiveAscii("nsitize"),
        dictgen::InsensitiveAscii("nsitized"),
        dictgen::InsensitiveAscii("nsitizer"),
        dictgen::InsensitiveAscii("nsitizers"),
        dictgen::InsensitiveAscii("nsitizes"),
        dictgen::InsensitiveAscii("nsitizing"),
        dictgen::InsensitiveAscii("xualise"),
        dictgen::InsensitiveAscii("xualised"),
        dictgen::InsensitiveAscii("xualises"),
        dictgen::InsensitiveAscii("xualising"),
        dictgen::InsensitiveAscii("xualize"),
        dictgen::InsensitiveAscii("xualized"),
        dictgen::InsensitiveAscii("xualizes"),
        dictgen::InsensitiveAscii("xualizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_DESENSITIZATION_6477425684013695224)],
        &[(0b10010, &ENTRY_DESENSITIZATIONS_2653162068724592823)],
        &[(0b10010, &ENTRY_DESENSITIZE_7076278913280010375)],
        &[(0b10010, &ENTRY_DESENSITIZED_18060076779967037190)],
        &[(0b10010, &ENTRY_DESENSITIZER_17295084989835588516)],
        &[(0b10010, &ENTRY_DESENSITIZERS_4492855637688265508)],
        &[(0b10010, &ENTRY_DESENSITIZES_14085116376101022093)],
        &[(0b10010, &ENTRY_DESENSITIZING_1861532716047418795)],
        &[(0b01001, &ENTRY_DESENSITIZATION_6477425684013695224)],
        &[(0b01001, &ENTRY_DESENSITIZATIONS_2653162068724592823)],
        &[(0b01001, &ENTRY_DESENSITIZE_7076278913280010375)],
        &[(0b01001, &ENTRY_DESENSITIZED_18060076779967037190)],
        &[(0b01001, &ENTRY_DESENSITIZER_17295084989835588516)],
        &[(0b01001, &ENTRY_DESENSITIZERS_4492855637688265508)],
        &[(0b01001, &ENTRY_DESENSITIZES_14085116376101022093)],
        &[(0b01001, &ENTRY_DESENSITIZING_1861532716047418795)],
        &[(0b10010, &ENTRY_DESEXUALIZE_1452349021755288588)],
        &[(0b10010, &ENTRY_DESEXUALIZED_14697196652232596540)],
        &[(0b10010, &ENTRY_DESEXUALIZES_310153221369007273)],
        &[(0b10010, &ENTRY_DESEXUALIZING_12199543455593087481)],
        &[(0b01001, &ENTRY_DESEXUALIZE_1452349021755288588)],
        &[(0b01001, &ENTRY_DESEXUALIZED_14697196652232596540)],
        &[(0b01001, &ENTRY_DESEXUALIZES_310153221369007273)],
        &[(0b01001, &ENTRY_DESEXUALIZING_12199543455593087481)],
    ],
    range: 7..=12,
};

static VARS_DESC_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DESC_CHILDREN),
    value: None,
};

pub static VARS_DESC_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[dictgen::InsensitiveAscii("endents")],
    values: &[&[(0b00001, &ENTRY_DESCENDANTS_15651999902366879600)]],
    range: 7..=7,
};

static VARS_DESA_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DESA_CHILDREN),
    value: None,
};

pub static VARS_DESA_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("linisation"),
        dictgen::InsensitiveAscii("linisations"),
        dictgen::InsensitiveAscii("linise"),
        dictgen::InsensitiveAscii("linised"),
        dictgen::InsensitiveAscii("linises"),
        dictgen::InsensitiveAscii("linising"),
        dictgen::InsensitiveAscii("linization"),
        dictgen::InsensitiveAscii("linizations"),
        dictgen::InsensitiveAscii("linize"),
        dictgen::InsensitiveAscii("linized"),
        dictgen::InsensitiveAscii("linizes"),
        dictgen::InsensitiveAscii("linizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_DESALINIZATION_18136851436548406134)],
        &[(0b10010, &ENTRY_DESALINIZATIONS_1947156449217935933)],
        &[(0b10010, &ENTRY_DESALINIZE_15580269981634714244)],
        &[(0b10010, &ENTRY_DESALINIZED_787514518667266596)],
        &[(0b10010, &ENTRY_DESALINIZES_3392036422321879852)],
        &[(0b10010, &ENTRY_DESALINIZING_7600583977642503954)],
        &[(0b01001, &ENTRY_DESALINIZATION_18136851436548406134)],
        &[(0b01001, &ENTRY_DESALINIZATIONS_1947156449217935933)],
        &[(0b01001, &ENTRY_DESALINIZE_15580269981634714244)],
        &[(0b01001, &ENTRY_DESALINIZED_787514518667266596)],
        &[(0b01001, &ENTRY_DESALINIZES_3392036422321879852)],
        &[(0b01001, &ENTRY_DESALINIZING_7600583977642503954)],
    ],
    range: 6..=11,
};

static VARS_DEP_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_DEP_CHILDREN),
    value: None,
};

static VARS_DEP_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_DEPA_NODE),
    None,
    None,
    None,
    Some(&VARS_DEPE_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_DEPO_NODE),
    None,
    None,
    Some(&VARS_DEPR_NODE),
    None,
    None,
    Some(&VARS_DEPU_NODE),
    None,
    None,
    None,
    None,
    None,
];

static VARS_DEPU_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DEPU_CHILDREN),
    value: None,
};

pub static VARS_DEPU_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("tise"),
        dictgen::InsensitiveAscii("tised"),
        dictgen::InsensitiveAscii("tises"),
        dictgen::InsensitiveAscii("tising"),
        dictgen::InsensitiveAscii("tize"),
        dictgen::InsensitiveAscii("tized"),
        dictgen::InsensitiveAscii("tizes"),
        dictgen::InsensitiveAscii("tizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_DEPUTIZE_14708452402802592517)],
        &[(0b10010, &ENTRY_DEPUTIZED_15591871669346119917)],
        &[(0b10010, &ENTRY_DEPUTIZES_16885595381873833095)],
        &[(0b10010, &ENTRY_DEPUTIZING_11731565191775615613)],
        &[(0b01001, &ENTRY_DEPUTIZE_14708452402802592517)],
        &[(0b01001, &ENTRY_DEPUTIZED_15591871669346119917)],
        &[(0b01001, &ENTRY_DEPUTIZES_16885595381873833095)],
        &[(0b01001, &ENTRY_DEPUTIZING_11731565191775615613)],
    ],
    range: 4..=6,
};

static VARS_DEPR_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DEPR_CHILDREN),
    value: None,
};

pub static VARS_DEPR_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("essurisation"),
        dictgen::InsensitiveAscii("essurisations"),
        dictgen::InsensitiveAscii("essurise"),
        dictgen::InsensitiveAscii("essurised"),
        dictgen::InsensitiveAscii("essurises"),
        dictgen::InsensitiveAscii("essurising"),
        dictgen::InsensitiveAscii("essurization"),
        dictgen::InsensitiveAscii("essurizations"),
        dictgen::InsensitiveAscii("essurize"),
        dictgen::InsensitiveAscii("essurized"),
        dictgen::InsensitiveAscii("essurizes"),
        dictgen::InsensitiveAscii("essurizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_DEPRESSURIZATION_10217952263080064818)],
        &[(0b10010, &ENTRY_DEPRESSURIZATIONS_3229591287232610524)],
        &[(0b10010, &ENTRY_DEPRESSURIZE_4006202201627920697)],
        &[(0b10010, &ENTRY_DEPRESSURIZED_4661479933134951890)],
        &[(0b10010, &ENTRY_DEPRESSURIZES_6344315569910956899)],
        &[(0b10010, &ENTRY_DEPRESSURIZING_309386769136380221)],
        &[(0b01001, &ENTRY_DEPRESSURIZATION_10217952263080064818)],
        &[(0b01001, &ENTRY_DEPRESSURIZATIONS_3229591287232610524)],
        &[(0b01001, &ENTRY_DEPRESSURIZE_4006202201627920697)],
        &[(0b01001, &ENTRY_DEPRESSURIZED_4661479933134951890)],
        &[(0b01001, &ENTRY_DEPRESSURIZES_6344315569910956899)],
        &[(0b01001, &ENTRY_DEPRESSURIZING_309386769136380221)],
    ],
    range: 8..=13,
};

static VARS_DEPO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DEPO_CHILDREN),
    value: None,
};

pub static VARS_DEPO_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("larisation"),
        dictgen::InsensitiveAscii("larisations"),
        dictgen::InsensitiveAscii("larise"),
        dictgen::InsensitiveAscii("larised"),
        dictgen::InsensitiveAscii("larises"),
        dictgen::InsensitiveAscii("larising"),
        dictgen::InsensitiveAscii("larization"),
        dictgen::InsensitiveAscii("larizations"),
        dictgen::InsensitiveAscii("larize"),
        dictgen::InsensitiveAscii("larized"),
        dictgen::InsensitiveAscii("larizes"),
        dictgen::InsensitiveAscii("larizing"),
        dictgen::InsensitiveAscii("liticisation"),
        dictgen::InsensitiveAscii("liticise"),
        dictgen::InsensitiveAscii("liticised"),
        dictgen::InsensitiveAscii("liticises"),
        dictgen::InsensitiveAscii("liticising"),
        dictgen::InsensitiveAscii("liticization"),
        dictgen::InsensitiveAscii("liticize"),
        dictgen::InsensitiveAscii("liticized"),
        dictgen::InsensitiveAscii("liticizes"),
        dictgen::InsensitiveAscii("liticizing"),
        dictgen::InsensitiveAscii("lymerisation"),
        dictgen::InsensitiveAscii("lymerisations"),
        dictgen::InsensitiveAscii("lymerise"),
        dictgen::InsensitiveAscii("lymerised"),
        dictgen::InsensitiveAscii("lymerises"),
        dictgen::InsensitiveAscii("lymerising"),
        dictgen::InsensitiveAscii("lymerization"),
        dictgen::InsensitiveAscii("lymerizations"),
        dictgen::InsensitiveAscii("lymerize"),
        dictgen::InsensitiveAscii("lymerized"),
        dictgen::InsensitiveAscii("lymerizes"),
        dictgen::InsensitiveAscii("lymerizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_DEPOLARIZATION_15774978100153361770)],
        &[(0b10010, &ENTRY_DEPOLARIZATIONS_16752636127743385337)],
        &[(0b10010, &ENTRY_DEPOLARIZE_14265169874625051800)],
        &[(0b10010, &ENTRY_DEPOLARIZED_377191566140430593)],
        &[(0b10010, &ENTRY_DEPOLARIZES_3226445999634432202)],
        &[(0b10010, &ENTRY_DEPOLARIZING_5347205347171321160)],
        &[(0b01001, &ENTRY_DEPOLARIZATION_15774978100153361770)],
        &[(0b01001, &ENTRY_DEPOLARIZATIONS_16752636127743385337)],
        &[(0b01001, &ENTRY_DEPOLARIZE_14265169874625051800)],
        &[(0b01001, &ENTRY_DEPOLARIZED_377191566140430593)],
        &[(0b01001, &ENTRY_DEPOLARIZES_3226445999634432202)],
        &[(0b01001, &ENTRY_DEPOLARIZING_5347205347171321160)],
        &[(0b10010, &ENTRY_DEPOLITICIZATION_15265110179231465481)],
        &[(0b10010, &ENTRY_DEPOLITICIZE_7370960578004693927)],
        &[(0b10010, &ENTRY_DEPOLITICIZED_17235888679911223431)],
        &[(0b10010, &ENTRY_DEPOLITICIZES_13700298543339019300)],
        &[(0b10010, &ENTRY_DEPOLITICIZING_2647277921869165326)],
        &[(0b01001, &ENTRY_DEPOLITICIZATION_15265110179231465481)],
        &[(0b01001, &ENTRY_DEPOLITICIZE_7370960578004693927)],
        &[(0b01001, &ENTRY_DEPOLITICIZED_17235888679911223431)],
        &[(0b01001, &ENTRY_DEPOLITICIZES_13700298543339019300)],
        &[(0b01001, &ENTRY_DEPOLITICIZING_2647277921869165326)],
        &[(0b10010, &ENTRY_DEPOLYMERIZATION_3633275984619877932)],
        &[(0b10010, &ENTRY_DEPOLYMERIZATIONS_11969399143532196145)],
        &[(0b10010, &ENTRY_DEPOLYMERIZE_17116091341951567184)],
        &[(0b10010, &ENTRY_DEPOLYMERIZED_3571703505928412135)],
        &[(0b10010, &ENTRY_DEPOLYMERIZES_18366430796592539914)],
        &[(0b10010, &ENTRY_DEPOLYMERIZING_4657392775383874483)],
        &[(0b01001, &ENTRY_DEPOLYMERIZATION_3633275984619877932)],
        &[(0b01001, &ENTRY_DEPOLYMERIZATIONS_11969399143532196145)],
        &[(0b01001, &ENTRY_DEPOLYMERIZE_17116091341951567184)],
        &[(0b01001, &ENTRY_DEPOLYMERIZED_3571703505928412135)],
        &[(0b01001, &ENTRY_DEPOLYMERIZES_18366430796592539914)],
        &[(0b01001, &ENTRY_DEPOLYMERIZING_4657392775383874483)],
    ],
    range: 6..=13,
};

static VARS_DEPE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DEPE_CHILDREN),
    value: None,
};

pub static VARS_DEPE_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ndance"),
        dictgen::InsensitiveAscii("ndances"),
        dictgen::InsensitiveAscii("ndant"),
        dictgen::InsensitiveAscii("ndants"),
        dictgen::InsensitiveAscii("rsonalisation"),
        dictgen::InsensitiveAscii("rsonalisations"),
        dictgen::InsensitiveAscii("rsonalise"),
        dictgen::InsensitiveAscii("rsonalised"),
        dictgen::InsensitiveAscii("rsonalises"),
        dictgen::InsensitiveAscii("rsonalising"),
        dictgen::InsensitiveAscii("rsonalization"),
        dictgen::InsensitiveAscii("rsonalizations"),
        dictgen::InsensitiveAscii("rsonalize"),
        dictgen::InsensitiveAscii("rsonalized"),
        dictgen::InsensitiveAscii("rsonalizes"),
        dictgen::InsensitiveAscii("rsonalizing"),
    ],
    values: &[
        &[(0b00001, &ENTRY_DEPENDENCE_2975032857660330940)],
        &[(0b00001, &ENTRY_DEPENDENCES_4898857694362268650)],
        &[(0b11010, &ENTRY_DEPENDENT_15548837712937438814)],
        &[(0b11010, &ENTRY_DEPENDENTS_6484680412761939586)],
        &[(0b10010, &ENTRY_DEPERSONALIZATION_3798571196825324317)],
        &[(0b10010, &ENTRY_DEPERSONALIZATIONS_13800546258710189283)],
        &[(0b10010, &ENTRY_DEPERSONALIZE_6577935583661707932)],
        &[(0b10010, &ENTRY_DEPERSONALIZED_4395700992531987338)],
        &[(0b10010, &ENTRY_DEPERSONALIZES_2561116931316488871)],
        &[(0b10010, &ENTRY_DEPERSONALIZING_12778802923540312835)],
        &[(0b01001, &ENTRY_DEPERSONALIZATION_3798571196825324317)],
        &[(0b01001, &ENTRY_DEPERSONALIZATIONS_13800546258710189283)],
        &[(0b01001, &ENTRY_DEPERSONALIZE_6577935583661707932)],
        &[(0b01001, &ENTRY_DEPERSONALIZED_4395700992531987338)],
        &[(0b01001, &ENTRY_DEPERSONALIZES_2561116931316488871)],
        &[(0b01001, &ENTRY_DEPERSONALIZING_12778802923540312835)],
    ],
    range: 5..=14,
};

static VARS_DEPA_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DEPA_CHILDREN),
    value: None,
};

pub static VARS_DEPA_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("rtmentalisation"),
        dictgen::InsensitiveAscii("rtmentalisations"),
        dictgen::InsensitiveAscii("rtmentalise"),
        dictgen::InsensitiveAscii("rtmentalised"),
        dictgen::InsensitiveAscii("rtmentalises"),
        dictgen::InsensitiveAscii("rtmentalising"),
        dictgen::InsensitiveAscii("rtmentalization"),
        dictgen::InsensitiveAscii("rtmentalizations"),
        dictgen::InsensitiveAscii("rtmentalize"),
        dictgen::InsensitiveAscii("rtmentalized"),
        dictgen::InsensitiveAscii("rtmentalizes"),
        dictgen::InsensitiveAscii("rtmentalizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_DEPARTMENTALIZATION_16732736631808006231)],
        &[(0b10010, &ENTRY_DEPARTMENTALIZATIONS_12433036246957322206)],
        &[(0b10010, &ENTRY_DEPARTMENTALIZE_12544989001599465845)],
        &[(0b10010, &ENTRY_DEPARTMENTALIZED_6440346371168938642)],
        &[(0b10010, &ENTRY_DEPARTMENTALIZES_5200360728452577607)],
        &[(0b10010, &ENTRY_DEPARTMENTALIZING_14933842151249052929)],
        &[(0b01001, &ENTRY_DEPARTMENTALIZATION_16732736631808006231)],
        &[(0b01001, &ENTRY_DEPARTMENTALIZATIONS_12433036246957322206)],
        &[(0b01001, &ENTRY_DEPARTMENTALIZE_12544989001599465845)],
        &[(0b01001, &ENTRY_DEPARTMENTALIZED_6440346371168938642)],
        &[(0b01001, &ENTRY_DEPARTMENTALIZES_5200360728452577607)],
        &[(0b01001, &ENTRY_DEPARTMENTALIZING_14933842151249052929)],
    ],
    range: 11..=16,
};

static VARS_DEO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DEO_CHILDREN),
    value: None,
};

pub static VARS_DEO_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("dorisation"),
        dictgen::InsensitiveAscii("dorisations"),
        dictgen::InsensitiveAscii("dorise"),
        dictgen::InsensitiveAscii("dorised"),
        dictgen::InsensitiveAscii("doriser"),
        dictgen::InsensitiveAscii("dorisers"),
        dictgen::InsensitiveAscii("dorises"),
        dictgen::InsensitiveAscii("dorising"),
        dictgen::InsensitiveAscii("dorization"),
        dictgen::InsensitiveAscii("dorizations"),
        dictgen::InsensitiveAscii("dorize"),
        dictgen::InsensitiveAscii("dorized"),
        dictgen::InsensitiveAscii("dorizer"),
        dictgen::InsensitiveAscii("dorizers"),
        dictgen::InsensitiveAscii("dorizes"),
        dictgen::InsensitiveAscii("dorizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_DEODORIZATION_15742635316130478344)],
        &[(0b10010, &ENTRY_DEODORIZATIONS_1611791796101503754)],
        &[(0b10010, &ENTRY_DEODORIZE_11113930164721287704)],
        &[(0b10010, &ENTRY_DEODORIZED_18267764171132816135)],
        &[(0b10010, &ENTRY_DEODORIZER_10856939399522550712)],
        &[(0b10010, &ENTRY_DEODORIZERS_14070131912570234977)],
        &[(0b10010, &ENTRY_DEODORIZES_9011430423896385984)],
        &[(0b10010, &ENTRY_DEODORIZING_13167718500093382611)],
        &[(0b01001, &ENTRY_DEODORIZATION_15742635316130478344)],
        &[(0b01001, &ENTRY_DEODORIZATIONS_1611791796101503754)],
        &[(0b01001, &ENTRY_DEODORIZE_11113930164721287704)],
        &[(0b01001, &ENTRY_DEODORIZED_18267764171132816135)],
        &[(0b01001, &ENTRY_DEODORIZER_10856939399522550712)],
        &[(0b01001, &ENTRY_DEODORIZERS_14070131912570234977)],
        &[(0b01001, &ENTRY_DEODORIZES_9011430423896385984)],
        &[(0b01001, &ENTRY_DEODORIZING_13167718500093382611)],
    ],
    range: 6..=11,
};

static VARS_DEN_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DEN_CHILDREN),
    value: None,
};

pub static VARS_DEN_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ationalisation"),
        dictgen::InsensitiveAscii("ationalisations"),
        dictgen::InsensitiveAscii("ationalise"),
        dictgen::InsensitiveAscii("ationalised"),
        dictgen::InsensitiveAscii("ationalises"),
        dictgen::InsensitiveAscii("ationalising"),
        dictgen::InsensitiveAscii("ationalization"),
        dictgen::InsensitiveAscii("ationalizations"),
        dictgen::InsensitiveAscii("ationalize"),
        dictgen::InsensitiveAscii("ationalized"),
        dictgen::InsensitiveAscii("ationalizes"),
        dictgen::InsensitiveAscii("ationalizing"),
        dictgen::InsensitiveAscii("aturalisation"),
        dictgen::InsensitiveAscii("aturalisations"),
        dictgen::InsensitiveAscii("aturalise"),
        dictgen::InsensitiveAscii("aturalised"),
        dictgen::InsensitiveAscii("aturalises"),
        dictgen::InsensitiveAscii("aturalising"),
        dictgen::InsensitiveAscii("aturalization"),
        dictgen::InsensitiveAscii("aturalizations"),
        dictgen::InsensitiveAscii("aturalize"),
        dictgen::InsensitiveAscii("aturalized"),
        dictgen::InsensitiveAscii("aturalizes"),
        dictgen::InsensitiveAscii("aturalizing"),
        dictgen::InsensitiveAscii("tin"),
        dictgen::InsensitiveAscii("tins"),
        dictgen::InsensitiveAscii("uclearisation"),
        dictgen::InsensitiveAscii("uclearisations"),
        dictgen::InsensitiveAscii("uclearise"),
        dictgen::InsensitiveAscii("uclearised"),
        dictgen::InsensitiveAscii("uclearises"),
        dictgen::InsensitiveAscii("uclearising"),
        dictgen::InsensitiveAscii("uclearization"),
        dictgen::InsensitiveAscii("uclearizations"),
        dictgen::InsensitiveAscii("uclearize"),
        dictgen::InsensitiveAscii("uclearized"),
        dictgen::InsensitiveAscii("uclearizes"),
        dictgen::InsensitiveAscii("uclearizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_DENATIONALIZATION_7729401217206590693)],
        &[(0b10010, &ENTRY_DENATIONALIZATIONS_15722416399546323549)],
        &[(0b10010, &ENTRY_DENATIONALIZE_6717709717538962281)],
        &[(0b10010, &ENTRY_DENATIONALIZED_743884727286515814)],
        &[(0b10010, &ENTRY_DENATIONALIZES_810829978748210734)],
        &[(0b10010, &ENTRY_DENATIONALIZING_700744151576877592)],
        &[(0b01001, &ENTRY_DENATIONALIZATION_7729401217206590693)],
        &[(0b01001, &ENTRY_DENATIONALIZATIONS_15722416399546323549)],
        &[(0b01001, &ENTRY_DENATIONALIZE_6717709717538962281)],
        &[(0b01001, &ENTRY_DENATIONALIZED_743884727286515814)],
        &[(0b01001, &ENTRY_DENATIONALIZES_810829978748210734)],
        &[(0b01001, &ENTRY_DENATIONALIZING_700744151576877592)],
        &[(0b10010, &ENTRY_DENATURALIZATION_971871507540742642)],
        &[(0b10010, &ENTRY_DENATURALIZATIONS_8163203679079106549)],
        &[(0b10010, &ENTRY_DENATURALIZE_13324203980568159303)],
        &[(0b10010, &ENTRY_DENATURALIZED_12577789701438825587)],
        &[(0b10010, &ENTRY_DENATURALIZES_1101122283585879857)],
        &[(0b10010, &ENTRY_DENATURALIZING_10692265626612469207)],
        &[(0b01001, &ENTRY_DENATURALIZATION_971871507540742642)],
        &[(0b01001, &ENTRY_DENATURALIZATIONS_8163203679079106549)],
        &[(0b01001, &ENTRY_DENATURALIZE_13324203980568159303)],
        &[(0b01001, &ENTRY_DENATURALIZED_12577789701438825587)],
        &[(0b01001, &ENTRY_DENATURALIZES_1101122283585879857)],
        &[(0b01001, &ENTRY_DENATURALIZING_10692265626612469207)],
        &[(0b00001, &ENTRY_DENTIN_357200140665913924)],
        &[(0b00001, &ENTRY_DENTINS_16363943754880560753)],
        &[(0b10010, &ENTRY_DENUCLEARIZATION_3316678403334950773)],
        &[(0b10010, &ENTRY_DENUCLEARIZATIONS_14853943063749587480)],
        &[(0b10010, &ENTRY_DENUCLEARIZE_7087853246260766822)],
        &[(0b10010, &ENTRY_DENUCLEARIZED_6796248104359598000)],
        &[(0b10010, &ENTRY_DENUCLEARIZES_18168803656441460141)],
        &[(0b10010, &ENTRY_DENUCLEARIZING_12070807204335448918)],
        &[(0b01001, &ENTRY_DENUCLEARIZATION_3316678403334950773)],
        &[(0b01001, &ENTRY_DENUCLEARIZATIONS_14853943063749587480)],
        &[(0b01001, &ENTRY_DENUCLEARIZE_7087853246260766822)],
        &[(0b01001, &ENTRY_DENUCLEARIZED_6796248104359598000)],
        &[(0b01001, &ENTRY_DENUCLEARIZES_18168803656441460141)],
        &[(0b01001, &ENTRY_DENUCLEARIZING_12070807204335448918)],
    ],
    range: 3..=15,
};

static VARS_DEM_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_DEM_CHILDREN),
    value: None,
};

static VARS_DEM_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_DEMA_NODE),
    None,
    None,
    None,
    Some(&VARS_DEME_NODE),
    None,
    None,
    None,
    Some(&VARS_DEMI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_DEMO_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_DEMY_NODE),
    None,
];

static VARS_DEMY_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DEMY_CHILDREN),
    value: None,
};

pub static VARS_DEMY_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("thologise"),
        dictgen::InsensitiveAscii("thologised"),
        dictgen::InsensitiveAscii("thologises"),
        dictgen::InsensitiveAscii("thologising"),
        dictgen::InsensitiveAscii("thologize"),
        dictgen::InsensitiveAscii("thologized"),
        dictgen::InsensitiveAscii("thologizes"),
        dictgen::InsensitiveAscii("thologizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_DEMYTHOLOGIZE_16256850336374180662)],
        &[(0b10010, &ENTRY_DEMYTHOLOGIZED_1548902620938435190)],
        &[(0b10010, &ENTRY_DEMYTHOLOGIZES_9084348299549456287)],
        &[(0b10010, &ENTRY_DEMYTHOLOGIZING_16424025398156147764)],
        &[(0b01001, &ENTRY_DEMYTHOLOGIZE_16256850336374180662)],
        &[(0b01001, &ENTRY_DEMYTHOLOGIZED_1548902620938435190)],
        &[(0b01001, &ENTRY_DEMYTHOLOGIZES_9084348299549456287)],
        &[(0b01001, &ENTRY_DEMYTHOLOGIZING_16424025398156147764)],
    ],
    range: 9..=11,
};

static VARS_DEMO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DEMO_CHILDREN),
    value: None,
};

pub static VARS_DEMO_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("bilisation"),
        dictgen::InsensitiveAscii("bilisations"),
        dictgen::InsensitiveAscii("bilise"),
        dictgen::InsensitiveAscii("bilised"),
        dictgen::InsensitiveAscii("bilises"),
        dictgen::InsensitiveAscii("bilising"),
        dictgen::InsensitiveAscii("bilization"),
        dictgen::InsensitiveAscii("bilizations"),
        dictgen::InsensitiveAscii("bilize"),
        dictgen::InsensitiveAscii("bilized"),
        dictgen::InsensitiveAscii("bilizes"),
        dictgen::InsensitiveAscii("bilizing"),
        dictgen::InsensitiveAscii("cratisation"),
        dictgen::InsensitiveAscii("cratisations"),
        dictgen::InsensitiveAscii("cratise"),
        dictgen::InsensitiveAscii("cratised"),
        dictgen::InsensitiveAscii("cratises"),
        dictgen::InsensitiveAscii("cratising"),
        dictgen::InsensitiveAscii("cratization"),
        dictgen::InsensitiveAscii("cratizations"),
        dictgen::InsensitiveAscii("cratize"),
        dictgen::InsensitiveAscii("cratized"),
        dictgen::InsensitiveAscii("cratizes"),
        dictgen::InsensitiveAscii("cratizing"),
        dictgen::InsensitiveAscii("netisation"),
        dictgen::InsensitiveAscii("netisations"),
        dictgen::InsensitiveAscii("netise"),
        dictgen::InsensitiveAscii("netised"),
        dictgen::InsensitiveAscii("netises"),
        dictgen::InsensitiveAscii("netising"),
        dictgen::InsensitiveAscii("netization"),
        dictgen::InsensitiveAscii("netizations"),
        dictgen::InsensitiveAscii("netize"),
        dictgen::InsensitiveAscii("netized"),
        dictgen::InsensitiveAscii("netizes"),
        dictgen::InsensitiveAscii("netizing"),
        dictgen::InsensitiveAscii("nisation"),
        dictgen::InsensitiveAscii("nise"),
        dictgen::InsensitiveAscii("nised"),
        dictgen::InsensitiveAscii("nises"),
        dictgen::InsensitiveAscii("nising"),
        dictgen::InsensitiveAscii("nization"),
        dictgen::InsensitiveAscii("nize"),
        dictgen::InsensitiveAscii("nized"),
        dictgen::InsensitiveAscii("nizes"),
        dictgen::InsensitiveAscii("nizing"),
        dictgen::InsensitiveAscii("ralisation"),
        dictgen::InsensitiveAscii("ralisations"),
        dictgen::InsensitiveAscii("ralise"),
        dictgen::InsensitiveAscii("ralised"),
        dictgen::InsensitiveAscii("ralises"),
        dictgen::InsensitiveAscii("ralising"),
        dictgen::InsensitiveAscii("ralisingly"),
        dictgen::InsensitiveAscii("ralization"),
        dictgen::InsensitiveAscii("ralizations"),
        dictgen::InsensitiveAscii("ralize"),
        dictgen::InsensitiveAscii("ralized"),
        dictgen::InsensitiveAscii("ralizes"),
        dictgen::InsensitiveAscii("ralizing"),
        dictgen::InsensitiveAscii("ralizingly"),
    ],
    values: &[
        &[(0b10010, &ENTRY_DEMOBILIZATION_1049482128993581914)],
        &[(0b10010, &ENTRY_DEMOBILIZATIONS_13060676951440773109)],
        &[(0b10010, &ENTRY_DEMOBILIZE_14631658221062411664)],
        &[(0b10010, &ENTRY_DEMOBILIZED_17675606354573049345)],
        &[(0b10010, &ENTRY_DEMOBILIZES_10953083886563254885)],
        &[(0b10010, &ENTRY_DEMOBILIZING_12570129016674680770)],
        &[(0b01001, &ENTRY_DEMOBILIZATION_1049482128993581914)],
        &[(0b01001, &ENTRY_DEMOBILIZATIONS_13060676951440773109)],
        &[(0b01001, &ENTRY_DEMOBILIZE_14631658221062411664)],
        &[(0b01001, &ENTRY_DEMOBILIZED_17675606354573049345)],
        &[(0b01001, &ENTRY_DEMOBILIZES_10953083886563254885)],
        &[(0b01001, &ENTRY_DEMOBILIZING_12570129016674680770)],
        &[(0b10010, &ENTRY_DEMOCRATIZATION_14834678678990587615)],
        &[(0b10010, &ENTRY_DEMOCRATIZATIONS_3121981811677706660)],
        &[(0b10010, &ENTRY_DEMOCRATIZE_14651228604547676688)],
        &[(0b10010, &ENTRY_DEMOCRATIZED_12561497189609834727)],
        &[(0b10010, &ENTRY_DEMOCRATIZES_9683541385378161525)],
        &[(0b10010, &ENTRY_DEMOCRATIZING_17328231163322967219)],
        &[(0b01001, &ENTRY_DEMOCRATIZATION_14834678678990587615)],
        &[(0b01001, &ENTRY_DEMOCRATIZATIONS_3121981811677706660)],
        &[(0b01001, &ENTRY_DEMOCRATIZE_14651228604547676688)],
        &[(0b01001, &ENTRY_DEMOCRATIZED_12561497189609834727)],
        &[(0b01001, &ENTRY_DEMOCRATIZES_9683541385378161525)],
        &[(0b01001, &ENTRY_DEMOCRATIZING_17328231163322967219)],
        &[(0b10010, &ENTRY_DEMONETIZATION_4518090358111490492)],
        &[(0b10010, &ENTRY_DEMONETIZATIONS_5789055765366818676)],
        &[(0b10010, &ENTRY_DEMONETIZE_13078441376893081927)],
        &[(0b10010, &ENTRY_DEMONETIZED_9558772114869845360)],
        &[(0b10010, &ENTRY_DEMONETIZES_11169810391799810472)],
        &[(0b10010, &ENTRY_DEMONETIZING_17201412552660846011)],
        &[(0b01001, &ENTRY_DEMONETIZATION_4518090358111490492)],
        &[(0b01001, &ENTRY_DEMONETIZATIONS_5789055765366818676)],
        &[(0b01001, &ENTRY_DEMONETIZE_13078441376893081927)],
        &[(0b01001, &ENTRY_DEMONETIZED_9558772114869845360)],
        &[(0b01001, &ENTRY_DEMONETIZES_11169810391799810472)],
        &[(0b01001, &ENTRY_DEMONETIZING_17201412552660846011)],
        &[(0b10010, &ENTRY_DEMONIZATION_435935988767727254)],
        &[(0b10010, &ENTRY_DEMONIZE_13260611226384752739)],
        &[(0b10010, &ENTRY_DEMONIZED_7711881396852229241)],
        &[(0b10010, &ENTRY_DEMONIZES_6258438652449642743)],
        &[(0b10010, &ENTRY_DEMONIZING_8343923659206792410)],
        &[(0b01001, &ENTRY_DEMONIZATION_435935988767727254)],
        &[(0b01001, &ENTRY_DEMONIZE_13260611226384752739)],
        &[(0b01001, &ENTRY_DEMONIZED_7711881396852229241)],
        &[(0b01001, &ENTRY_DEMONIZES_6258438652449642743)],
        &[(0b01001, &ENTRY_DEMONIZING_8343923659206792410)],
        &[(0b10010, &ENTRY_DEMORALIZATION_5556421705683237030)],
        &[(0b10010, &ENTRY_DEMORALIZATIONS_9043499224356783699)],
        &[(0b10010, &ENTRY_DEMORALIZE_6209215674833141288)],
        &[(0b10010, &ENTRY_DEMORALIZED_11896518767543535927)],
        &[(0b10010, &ENTRY_DEMORALIZES_17922317839176266819)],
        &[(0b10010, &ENTRY_DEMORALIZING_7879881258206607673)],
        &[(0b10010, &ENTRY_DEMORALIZINGLY_11418463351635146120)],
        &[(0b01001, &ENTRY_DEMORALIZATION_5556421705683237030)],
        &[(0b01001, &ENTRY_DEMORALIZATIONS_9043499224356783699)],
        &[(0b01001, &ENTRY_DEMORALIZE_6209215674833141288)],
        &[(0b01001, &ENTRY_DEMORALIZED_11896518767543535927)],
        &[(0b01001, &ENTRY_DEMORALIZES_17922317839176266819)],
        &[(0b01001, &ENTRY_DEMORALIZING_7879881258206607673)],
        &[(0b01001, &ENTRY_DEMORALIZINGLY_11418463351635146120)],
    ],
    range: 4..=12,
};

static VARS_DEMI_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DEMI_CHILDREN),
    value: None,
};

pub static VARS_DEMI_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("litarisation"),
        dictgen::InsensitiveAscii("litarisations"),
        dictgen::InsensitiveAscii("litarise"),
        dictgen::InsensitiveAscii("litarised"),
        dictgen::InsensitiveAscii("litarises"),
        dictgen::InsensitiveAscii("litarising"),
        dictgen::InsensitiveAscii("litarization"),
        dictgen::InsensitiveAscii("litarizations"),
        dictgen::InsensitiveAscii("litarize"),
        dictgen::InsensitiveAscii("litarized"),
        dictgen::InsensitiveAscii("litarizes"),
        dictgen::InsensitiveAscii("litarizing"),
        dictgen::InsensitiveAscii("neralisation"),
        dictgen::InsensitiveAscii("neralisations"),
        dictgen::InsensitiveAscii("neralise"),
        dictgen::InsensitiveAscii("neralised"),
        dictgen::InsensitiveAscii("neralises"),
        dictgen::InsensitiveAscii("neralising"),
        dictgen::InsensitiveAscii("neralization"),
        dictgen::InsensitiveAscii("neralizations"),
        dictgen::InsensitiveAscii("neralize"),
        dictgen::InsensitiveAscii("neralized"),
        dictgen::InsensitiveAscii("neralizes"),
        dictgen::InsensitiveAscii("neralizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_DEMILITARIZATION_8640733064988757472)],
        &[(0b10010, &ENTRY_DEMILITARIZATIONS_13863377781587784313)],
        &[(0b10010, &ENTRY_DEMILITARIZE_5838068700068012783)],
        &[(0b10010, &ENTRY_DEMILITARIZED_4980413846043795380)],
        &[(0b10010, &ENTRY_DEMILITARIZES_1164840116130396010)],
        &[(0b10010, &ENTRY_DEMILITARIZING_994064454433057567)],
        &[(0b01001, &ENTRY_DEMILITARIZATION_8640733064988757472)],
        &[(0b01001, &ENTRY_DEMILITARIZATIONS_13863377781587784313)],
        &[(0b01001, &ENTRY_DEMILITARIZE_5838068700068012783)],
        &[(0b01001, &ENTRY_DEMILITARIZED_4980413846043795380)],
        &[(0b01001, &ENTRY_DEMILITARIZES_1164840116130396010)],
        &[(0b01001, &ENTRY_DEMILITARIZING_994064454433057567)],
        &[(0b10010, &ENTRY_DEMINERALIZATION_3724123166587453242)],
        &[(0b10010, &ENTRY_DEMINERALIZATIONS_3572117260520975819)],
        &[(0b10010, &ENTRY_DEMINERALIZE_11805613081665284275)],
        &[(0b10010, &ENTRY_DEMINERALIZED_5889760188783683563)],
        &[(0b10010, &ENTRY_DEMINERALIZES_7031323467048546237)],
        &[(0b10010, &ENTRY_DEMINERALIZING_17818456458860291247)],
        &[(0b01001, &ENTRY_DEMINERALIZATION_3724123166587453242)],
        &[(0b01001, &ENTRY_DEMINERALIZATIONS_3572117260520975819)],
        &[(0b01001, &ENTRY_DEMINERALIZE_11805613081665284275)],
        &[(0b01001, &ENTRY_DEMINERALIZED_5889760188783683563)],
        &[(0b01001, &ENTRY_DEMINERALIZES_7031323467048546237)],
        &[(0b01001, &ENTRY_DEMINERALIZING_17818456458860291247)],
    ],
    range: 8..=13,
};

static VARS_DEME_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DEME_CHILDREN),
    value: None,
};

pub static VARS_DEME_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("anor"),
        dictgen::InsensitiveAscii("anors"),
        dictgen::InsensitiveAscii("anour"),
        dictgen::InsensitiveAscii("anours"),
    ],
    values: &[
        &[(0b11001, &ENTRY_DEMEANOR_16422703697064073325)],
        &[(0b11001, &ENTRY_DEMEANORS_7209163777589536912)],
        &[(0b11010, &ENTRY_DEMEANOR_16422703697064073325)],
        &[(0b11010, &ENTRY_DEMEANORS_7209163777589536912)],
    ],
    range: 4..=6,
};

static VARS_DEMA_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DEMA_CHILDREN),
    value: None,
};

pub static VARS_DEMA_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("gnetisation"),
        dictgen::InsensitiveAscii("gnetisations"),
        dictgen::InsensitiveAscii("gnetise"),
        dictgen::InsensitiveAscii("gnetised"),
        dictgen::InsensitiveAscii("gnetiser"),
        dictgen::InsensitiveAscii("gnetisers"),
        dictgen::InsensitiveAscii("gnetises"),
        dictgen::InsensitiveAscii("gnetising"),
        dictgen::InsensitiveAscii("gnetization"),
        dictgen::InsensitiveAscii("gnetizations"),
        dictgen::InsensitiveAscii("gnetize"),
        dictgen::InsensitiveAscii("gnetized"),
        dictgen::InsensitiveAscii("gnetizer"),
        dictgen::InsensitiveAscii("gnetizers"),
        dictgen::InsensitiveAscii("gnetizes"),
        dictgen::InsensitiveAscii("gnetizing"),
        dictgen::InsensitiveAscii("gog"),
        dictgen::InsensitiveAscii("goged"),
        dictgen::InsensitiveAscii("goging"),
        dictgen::InsensitiveAscii("gogry"),
        dictgen::InsensitiveAscii("gogs"),
        dictgen::InsensitiveAscii("terialisation"),
        dictgen::InsensitiveAscii("terialisations"),
        dictgen::InsensitiveAscii("terialise"),
        dictgen::InsensitiveAscii("terialised"),
        dictgen::InsensitiveAscii("terialises"),
        dictgen::InsensitiveAscii("terialising"),
        dictgen::InsensitiveAscii("terialization"),
        dictgen::InsensitiveAscii("terializations"),
        dictgen::InsensitiveAscii("terialize"),
        dictgen::InsensitiveAscii("terialized"),
        dictgen::InsensitiveAscii("terializes"),
        dictgen::InsensitiveAscii("terializing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_DEMAGNETIZATION_8660626408268068192)],
        &[(0b10010, &ENTRY_DEMAGNETIZATIONS_6017739735415397589)],
        &[(0b10010, &ENTRY_DEMAGNETIZE_14716676657435015384)],
        &[(0b10010, &ENTRY_DEMAGNETIZED_16278014960965990808)],
        &[(0b10010, &ENTRY_DEMAGNETIZER_4728434350800689036)],
        &[(0b10010, &ENTRY_DEMAGNETIZERS_931034885365981384)],
        &[(0b10010, &ENTRY_DEMAGNETIZES_677533597345689814)],
        &[(0b10010, &ENTRY_DEMAGNETIZING_11214913343744584233)],
        &[(0b01001, &ENTRY_DEMAGNETIZATION_8660626408268068192)],
        &[(0b01001, &ENTRY_DEMAGNETIZATIONS_6017739735415397589)],
        &[(0b01001, &ENTRY_DEMAGNETIZE_14716676657435015384)],
        &[(0b01001, &ENTRY_DEMAGNETIZED_16278014960965990808)],
        &[(0b01001, &ENTRY_DEMAGNETIZER_4728434350800689036)],
        &[(0b01001, &ENTRY_DEMAGNETIZERS_931034885365981384)],
        &[(0b01001, &ENTRY_DEMAGNETIZES_677533597345689814)],
        &[(0b01001, &ENTRY_DEMAGNETIZING_11214913343744584233)],
        &[(0b00001, &ENTRY_DEMAGOGUE_8651813563125313987)],
        &[(0b00001, &ENTRY_DEMAGOGUED_3536597591189504210)],
        &[(0b00001, &ENTRY_DEMAGOGUING_15979024284168235826)],
        &[(0b00001, &ENTRY_DEMAGOGUERY_1494206203290122461)],
        &[(0b00001, &ENTRY_DEMAGOGUES_15335780932382092242)],
        &[(0b10010, &ENTRY_DEMATERIALIZATION_6643468176116888919)],
        &[(0b10010, &ENTRY_DEMATERIALIZATIONS_9448622588126109210)],
        &[(0b10010, &ENTRY_DEMATERIALIZE_5188464319891499632)],
        &[(0b10010, &ENTRY_DEMATERIALIZED_13253413423231441157)],
        &[(0b10010, &ENTRY_DEMATERIALIZES_5270284454646712513)],
        &[(0b10010, &ENTRY_DEMATERIALIZING_4105956654256703819)],
        &[(0b01001, &ENTRY_DEMATERIALIZATION_6643468176116888919)],
        &[(0b01001, &ENTRY_DEMATERIALIZATIONS_9448622588126109210)],
        &[(0b01001, &ENTRY_DEMATERIALIZE_5188464319891499632)],
        &[(0b01001, &ENTRY_DEMATERIALIZED_13253413423231441157)],
        &[(0b01001, &ENTRY_DEMATERIALIZES_5270284454646712513)],
        &[(0b01001, &ENTRY_DEMATERIALIZING_4105956654256703819)],
    ],
    range: 3..=14,
};

static VARS_DEL_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DEL_CHILDREN),
    value: None,
};

pub static VARS_DEL_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ocalisation"),
        dictgen::InsensitiveAscii("ocalisations"),
        dictgen::InsensitiveAscii("ocalise"),
        dictgen::InsensitiveAscii("ocalised"),
        dictgen::InsensitiveAscii("ocalises"),
        dictgen::InsensitiveAscii("ocalising"),
        dictgen::InsensitiveAscii("ocalization"),
        dictgen::InsensitiveAscii("ocalizations"),
        dictgen::InsensitiveAscii("ocalize"),
        dictgen::InsensitiveAscii("ocalized"),
        dictgen::InsensitiveAscii("ocalizes"),
        dictgen::InsensitiveAscii("ocalizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_DELOCALIZATION_3872128840219390827)],
        &[(0b10010, &ENTRY_DELOCALIZATIONS_11207793221550956501)],
        &[(0b10010, &ENTRY_DELOCALIZE_2924961970509538366)],
        &[(0b10010, &ENTRY_DELOCALIZED_17487743123281665827)],
        &[(0b10010, &ENTRY_DELOCALIZES_1352875521634188136)],
        &[(0b10010, &ENTRY_DELOCALIZING_18066483905901400466)],
        &[(0b01001, &ENTRY_DELOCALIZATION_3872128840219390827)],
        &[(0b01001, &ENTRY_DELOCALIZATIONS_11207793221550956501)],
        &[(0b01001, &ENTRY_DELOCALIZE_2924961970509538366)],
        &[(0b01001, &ENTRY_DELOCALIZED_17487743123281665827)],
        &[(0b01001, &ENTRY_DELOCALIZES_1352875521634188136)],
        &[(0b01001, &ENTRY_DELOCALIZING_18066483905901400466)],
    ],
    range: 7..=12,
};

static VARS_DEI_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DEI_CHILDREN),
    value: None,
};

pub static VARS_DEI_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("onisation"),
        dictgen::InsensitiveAscii("onise"),
        dictgen::InsensitiveAscii("onised"),
        dictgen::InsensitiveAscii("onises"),
        dictgen::InsensitiveAscii("onising"),
        dictgen::InsensitiveAscii("onization"),
        dictgen::InsensitiveAscii("onize"),
        dictgen::InsensitiveAscii("onized"),
        dictgen::InsensitiveAscii("onizes"),
        dictgen::InsensitiveAscii("onizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_DEIONIZATION_8915428723312142234)],
        &[(0b10010, &ENTRY_DEIONIZE_338398712613893588)],
        &[(0b10010, &ENTRY_DEIONIZED_10491202019791607626)],
        &[(0b10010, &ENTRY_DEIONIZES_10200275155305727895)],
        &[(0b10010, &ENTRY_DEIONIZING_16611163248873983172)],
        &[(0b01001, &ENTRY_DEIONIZATION_8915428723312142234)],
        &[(0b01001, &ENTRY_DEIONIZE_338398712613893588)],
        &[(0b01001, &ENTRY_DEIONIZED_10491202019791607626)],
        &[(0b01001, &ENTRY_DEIONIZES_10200275155305727895)],
        &[(0b01001, &ENTRY_DEIONIZING_16611163248873983172)],
    ],
    range: 5..=9,
};

static VARS_DEH_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DEH_CHILDREN),
    value: None,
};

pub static VARS_DEH_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("umanisation"),
        dictgen::InsensitiveAscii("umanisations"),
        dictgen::InsensitiveAscii("umanise"),
        dictgen::InsensitiveAscii("umanised"),
        dictgen::InsensitiveAscii("umanises"),
        dictgen::InsensitiveAscii("umanising"),
        dictgen::InsensitiveAscii("umanization"),
        dictgen::InsensitiveAscii("umanizations"),
        dictgen::InsensitiveAscii("umanize"),
        dictgen::InsensitiveAscii("umanized"),
        dictgen::InsensitiveAscii("umanizes"),
        dictgen::InsensitiveAscii("umanizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_DEHUMANIZATION_8203365336341231524)],
        &[(0b10010, &ENTRY_DEHUMANIZATIONS_12753893729327325578)],
        &[(0b10010, &ENTRY_DEHUMANIZE_18142286574789231038)],
        &[(0b10010, &ENTRY_DEHUMANIZED_6478369645453909211)],
        &[(0b10010, &ENTRY_DEHUMANIZES_7224437139012646110)],
        &[(0b10010, &ENTRY_DEHUMANIZING_9897055991255710061)],
        &[(0b01001, &ENTRY_DEHUMANIZATION_8203365336341231524)],
        &[(0b01001, &ENTRY_DEHUMANIZATIONS_12753893729327325578)],
        &[(0b01001, &ENTRY_DEHUMANIZE_18142286574789231038)],
        &[(0b01001, &ENTRY_DEHUMANIZED_6478369645453909211)],
        &[(0b01001, &ENTRY_DEHUMANIZES_7224437139012646110)],
        &[(0b01001, &ENTRY_DEHUMANIZING_9897055991255710061)],
    ],
    range: 7..=12,
};

static VARS_DEF_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DEF_CHILDREN),
    value: None,
};

pub static VARS_DEF_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ence"),
        dictgen::InsensitiveAscii("enced"),
        dictgen::InsensitiveAscii("enceless"),
        dictgen::InsensitiveAscii("encelesser"),
        dictgen::InsensitiveAscii("encelessest"),
        dictgen::InsensitiveAscii("encelessness"),
        dictgen::InsensitiveAscii("encelessnesses"),
        dictgen::InsensitiveAscii("ences"),
        dictgen::InsensitiveAscii("encing"),
        dictgen::InsensitiveAscii("ense"),
        dictgen::InsensitiveAscii("ensed"),
        dictgen::InsensitiveAscii("enseless"),
        dictgen::InsensitiveAscii("enselesser"),
        dictgen::InsensitiveAscii("enselessest"),
        dictgen::InsensitiveAscii("enselessness"),
        dictgen::InsensitiveAscii("enselessnesses"),
        dictgen::InsensitiveAscii("enses"),
        dictgen::InsensitiveAscii("ensing"),
    ],
    values: &[
        &[(0b11010, &ENTRY_DEFENSE_6661070793019776368)],
        &[(0b11010, &ENTRY_DEFENSED_10450678450925087448)],
        &[(0b11010, &ENTRY_DEFENSELESS_18055933219220277884)],
        &[(0b11010, &ENTRY_DEFENSELESSER_11231098921374350935)],
        &[(0b11010, &ENTRY_DEFENSELESSEST_11877359825751139498)],
        &[(0b11010, &ENTRY_DEFENSELESSNESS_2531659609001850832)],
        &[(0b11010, &ENTRY_DEFENSELESSNESSES_5028704575903983200)],
        &[(0b11010, &ENTRY_DEFENSES_10286318404274050577)],
        &[(0b11010, &ENTRY_DEFENSING_10107917169615339119)],
        &[(0b01001, &ENTRY_DEFENSE_6661070793019776368)],
        &[(0b01001, &ENTRY_DEFENSED_10450678450925087448)],
        &[(0b00001, &ENTRY_DEFENSELESS_18055933219220277884)],
        &[(0b00001, &ENTRY_DEFENSELESSER_11231098921374350935)],
        &[(0b00001, &ENTRY_DEFENSELESSEST_11877359825751139498)],
        &[(0b00001, &ENTRY_DEFENSELESSNESS_2531659609001850832)],
        &[(0b00001, &ENTRY_DEFENSELESSNESSES_5028704575903983200)],
        &[(0b01001, &ENTRY_DEFENSES_10286318404274050577)],
        &[(0b01001, &ENTRY_DEFENSING_10107917169615339119)],
    ],
    range: 4..=14,
};

static VARS_DEC_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_DEC_CHILDREN),
    value: None,
};

static VARS_DEC_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_DECA_NODE),
    None,
    None,
    None,
    Some(&VARS_DECE_NODE),
    None,
    None,
    None,
    Some(&VARS_DECI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_DECO_NODE),
    None,
    None,
    Some(&VARS_DECR_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_DECR_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DECR_CHILDREN),
    value: None,
};

pub static VARS_DECR_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("iminalisation"),
        dictgen::InsensitiveAscii("iminalisations"),
        dictgen::InsensitiveAscii("iminalise"),
        dictgen::InsensitiveAscii("iminalised"),
        dictgen::InsensitiveAscii("iminalises"),
        dictgen::InsensitiveAscii("iminalising"),
        dictgen::InsensitiveAscii("iminalization"),
        dictgen::InsensitiveAscii("iminalizations"),
        dictgen::InsensitiveAscii("iminalize"),
        dictgen::InsensitiveAscii("iminalized"),
        dictgen::InsensitiveAscii("iminalizes"),
        dictgen::InsensitiveAscii("iminalizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_DECRIMINALIZATION_10972189705541961663)],
        &[(0b10010, &ENTRY_DECRIMINALIZATIONS_12268289228613201569)],
        &[(0b10010, &ENTRY_DECRIMINALIZE_6677799413626987625)],
        &[(0b10010, &ENTRY_DECRIMINALIZED_5536378597888996415)],
        &[(0b10010, &ENTRY_DECRIMINALIZES_6555315341160373102)],
        &[(0b10010, &ENTRY_DECRIMINALIZING_6483531696781808568)],
        &[(0b01001, &ENTRY_DECRIMINALIZATION_10972189705541961663)],
        &[(0b01001, &ENTRY_DECRIMINALIZATIONS_12268289228613201569)],
        &[(0b01001, &ENTRY_DECRIMINALIZE_6677799413626987625)],
        &[(0b01001, &ENTRY_DECRIMINALIZED_5536378597888996415)],
        &[(0b01001, &ENTRY_DECRIMINALIZES_6555315341160373102)],
        &[(0b01001, &ENTRY_DECRIMINALIZING_6483531696781808568)],
    ],
    range: 9..=14,
};

static VARS_DECO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DECO_CHILDREN),
    value: None,
};

pub static VARS_DECO_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("lonisation"),
        dictgen::InsensitiveAscii("lonisations"),
        dictgen::InsensitiveAscii("lonise"),
        dictgen::InsensitiveAscii("lonised"),
        dictgen::InsensitiveAscii("lonises"),
        dictgen::InsensitiveAscii("lonising"),
        dictgen::InsensitiveAscii("lonization"),
        dictgen::InsensitiveAscii("lonizations"),
        dictgen::InsensitiveAscii("lonize"),
        dictgen::InsensitiveAscii("lonized"),
        dictgen::InsensitiveAscii("lonizes"),
        dictgen::InsensitiveAscii("lonizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_DECOLONIZATION_1486129639809542135)],
        &[(0b10010, &ENTRY_DECOLONIZATIONS_15958442548094153342)],
        &[(0b10010, &ENTRY_DECOLONIZE_8186463036478425034)],
        &[(0b10010, &ENTRY_DECOLONIZED_4107643671609353888)],
        &[(0b10010, &ENTRY_DECOLONIZES_2371774017479885060)],
        &[(0b10010, &ENTRY_DECOLONIZING_9800590501891725470)],
        &[(0b01001, &ENTRY_DECOLONIZATION_1486129639809542135)],
        &[(0b01001, &ENTRY_DECOLONIZATIONS_15958442548094153342)],
        &[(0b01001, &ENTRY_DECOLONIZE_8186463036478425034)],
        &[(0b01001, &ENTRY_DECOLONIZED_4107643671609353888)],
        &[(0b01001, &ENTRY_DECOLONIZES_2371774017479885060)],
        &[(0b01001, &ENTRY_DECOLONIZING_9800590501891725470)],
    ],
    range: 6..=11,
};

static VARS_DECI_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DECI_CHILDREN),
    value: None,
};

pub static VARS_DECI_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("liter"),
        dictgen::InsensitiveAscii("liters"),
        dictgen::InsensitiveAscii("litre"),
        dictgen::InsensitiveAscii("litres"),
        dictgen::InsensitiveAscii("malisation"),
        dictgen::InsensitiveAscii("malisations"),
        dictgen::InsensitiveAscii("malise"),
        dictgen::InsensitiveAscii("malised"),
        dictgen::InsensitiveAscii("malises"),
        dictgen::InsensitiveAscii("malising"),
        dictgen::InsensitiveAscii("malization"),
        dictgen::InsensitiveAscii("malizations"),
        dictgen::InsensitiveAscii("malize"),
        dictgen::InsensitiveAscii("malized"),
        dictgen::InsensitiveAscii("malizes"),
        dictgen::InsensitiveAscii("malizing"),
        dictgen::InsensitiveAscii("meter"),
        dictgen::InsensitiveAscii("meters"),
        dictgen::InsensitiveAscii("metre"),
        dictgen::InsensitiveAscii("metres"),
    ],
    values: &[
        &[(0b00001, &ENTRY_DECILITER_16596592820215375084)],
        &[(0b00001, &ENTRY_DECILITERS_151708397377325111)],
        &[(0b11010, &ENTRY_DECILITER_16596592820215375084)],
        &[(0b11010, &ENTRY_DECILITERS_151708397377325111)],
        &[(0b10010, &ENTRY_DECIMALIZATION_6585979287053082594)],
        &[(0b10010, &ENTRY_DECIMALIZATIONS_14219964716573449259)],
        &[(0b10010, &ENTRY_DECIMALIZE_6260219389368908768)],
        &[(0b10010, &ENTRY_DECIMALIZED_8364548564908015686)],
        &[(0b10010, &ENTRY_DECIMALIZES_15979587779699755101)],
        &[(0b10010, &ENTRY_DECIMALIZING_17193949793978263746)],
        &[(0b01001, &ENTRY_DECIMALIZATION_6585979287053082594)],
        &[(0b01001, &ENTRY_DECIMALIZATIONS_14219964716573449259)],
        &[(0b01001, &ENTRY_DECIMALIZE_6260219389368908768)],
        &[(0b01001, &ENTRY_DECIMALIZED_8364548564908015686)],
        &[(0b01001, &ENTRY_DECIMALIZES_15979587779699755101)],
        &[(0b01001, &ENTRY_DECIMALIZING_17193949793978263746)],
        &[(0b01001, &ENTRY_DECIMETER_5877956144268963607)],
        &[(0b01001, &ENTRY_DECIMETERS_10623100407909187264)],
        &[(0b11010, &ENTRY_DECIMETER_5877956144268963607)],
        &[(0b11010, &ENTRY_DECIMETERS_10623100407909187264)],
    ],
    range: 5..=11,
};

static VARS_DECE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DECE_CHILDREN),
    value: None,
};

pub static VARS_DECE_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ntralisation"),
        dictgen::InsensitiveAscii("ntralisations"),
        dictgen::InsensitiveAscii("ntralise"),
        dictgen::InsensitiveAscii("ntralised"),
        dictgen::InsensitiveAscii("ntralises"),
        dictgen::InsensitiveAscii("ntralising"),
        dictgen::InsensitiveAscii("ntralization"),
        dictgen::InsensitiveAscii("ntralizations"),
        dictgen::InsensitiveAscii("ntralize"),
        dictgen::InsensitiveAscii("ntralized"),
        dictgen::InsensitiveAscii("ntralizes"),
        dictgen::InsensitiveAscii("ntralizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_DECENTRALIZATION_14989034485163734668)],
        &[(0b10010, &ENTRY_DECENTRALIZATIONS_15028307675843910435)],
        &[(0b10010, &ENTRY_DECENTRALIZE_17306384894132674147)],
        &[(0b10010, &ENTRY_DECENTRALIZED_15938901073912000317)],
        &[(0b10010, &ENTRY_DECENTRALIZES_8990159632087872438)],
        &[(0b10010, &ENTRY_DECENTRALIZING_11771308820494191656)],
        &[(0b01001, &ENTRY_DECENTRALIZATION_14989034485163734668)],
        &[(0b01001, &ENTRY_DECENTRALIZATIONS_15028307675843910435)],
        &[(0b01001, &ENTRY_DECENTRALIZE_17306384894132674147)],
        &[(0b01001, &ENTRY_DECENTRALIZED_15938901073912000317)],
        &[(0b01001, &ENTRY_DECENTRALIZES_8990159632087872438)],
        &[(0b01001, &ENTRY_DECENTRALIZING_11771308820494191656)],
    ],
    range: 8..=13,
};

static VARS_DECA_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_DECA_CHILDREN),
    value: None,
};

pub static VARS_DECA_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("rbonisation"),
        dictgen::InsensitiveAscii("rbonisations"),
        dictgen::InsensitiveAscii("rbonise"),
        dictgen::InsensitiveAscii("rbonised"),
        dictgen::InsensitiveAscii("rbonises"),
        dictgen::InsensitiveAscii("rbonising"),
        dictgen::InsensitiveAscii("rbonization"),
        dictgen::InsensitiveAscii("rbonizations"),
        dictgen::InsensitiveAscii("rbonize"),
        dictgen::InsensitiveAscii("rbonized"),
        dictgen::InsensitiveAscii("rbonizes"),
        dictgen::InsensitiveAscii("rbonizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_DECARBONIZATION_11478706021702952565)],
        &[(0b10010, &ENTRY_DECARBONIZATIONS_16017243127754390829)],
        &[(0b10010, &ENTRY_DECARBONIZE_17211928749740566614)],
        &[(0b10010, &ENTRY_DECARBONIZED_10394178489330721396)],
        &[(0b10010, &ENTRY_DECARBONIZES_11122308997566756604)],
        &[(0b10010, &ENTRY_DECARBONIZING_5775070557566850865)],
        &[(0b01001, &ENTRY_DECARBONIZATION_11478706021702952565)],
        &[(0b01001, &ENTRY_DECARBONIZATIONS_16017243127754390829)],
        &[(0b01001, &ENTRY_DECARBONIZE_17211928749740566614)],
        &[(0b01001, &ENTRY_DECARBONIZED_10394178489330721396)],
        &[(0b01001, &ENTRY_DECARBONIZES_11122308997566756604)],
        &[(0b01001, &ENTRY_DECARBONIZING_5775070557566850865)],
    ],
    range: 7..=12,
};

static VARS_C_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_C_CHILDREN),
    value: None,
};

static VARS_C_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_CA_NODE),
    None,
    None,
    None,
    Some(&VARS_CE_NODE),
    None,
    None,
    Some(&VARS_CH_NODE),
    Some(&VARS_CI_NODE),
    None,
    None,
    Some(&VARS_CL_NODE),
    None,
    None,
    Some(&VARS_CO_NODE),
    None,
    None,
    Some(&VARS_CR_NODE),
    None,
    None,
    Some(&VARS_CU_NODE),
    None,
    None,
    None,
    None,
    None,
];

static VARS_CU_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_CU_CHILDREN),
    value: None,
};

pub static VARS_CU_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("dgeled"),
        dictgen::InsensitiveAscii("dgeling"),
        dictgen::InsensitiveAscii("dgelings"),
        dictgen::InsensitiveAscii("dgelled"),
        dictgen::InsensitiveAscii("dgelling"),
        dictgen::InsensitiveAscii("dgellings"),
        dictgen::InsensitiveAscii("pelation"),
        dictgen::InsensitiveAscii("pellation"),
        dictgen::InsensitiveAscii("stomisable"),
        dictgen::InsensitiveAscii("stomisation"),
        dictgen::InsensitiveAscii("stomisations"),
        dictgen::InsensitiveAscii("stomise"),
        dictgen::InsensitiveAscii("stomised"),
        dictgen::InsensitiveAscii("stomises"),
        dictgen::InsensitiveAscii("stomising"),
        dictgen::InsensitiveAscii("stomizable"),
        dictgen::InsensitiveAscii("stomization"),
        dictgen::InsensitiveAscii("stomizations"),
        dictgen::InsensitiveAscii("stomize"),
        dictgen::InsensitiveAscii("stomized"),
        dictgen::InsensitiveAscii("stomizes"),
        dictgen::InsensitiveAscii("stomizing"),
    ],
    values: &[
        &[(0b00001, &ENTRY_CUDGELED_9692005941001882555)],
        &[(0b00001, &ENTRY_CUDGELING_8911435466137772919)],
        &[(0b00001, &ENTRY_CUDGELINGS_15615614002141274961)],
        &[(0b11010, &ENTRY_CUDGELED_9692005941001882555)],
        &[(0b11010, &ENTRY_CUDGELING_8911435466137772919)],
        &[(0b11010, &ENTRY_CUDGELINGS_15615614002141274961)],
        &[(0b00001, &ENTRY_CUPELATION_6970002014185731346)],
        &[(0b11010, &ENTRY_CUPELATION_6970002014185731346)],
        &[(0b10010, &ENTRY_CUSTOMIZABLE_13082591789323327431)],
        &[(0b10010, &ENTRY_CUSTOMIZATION_6533324325688675249)],
        &[(0b10010, &ENTRY_CUSTOMIZATIONS_4094977061478290809)],
        &[(0b10010, &ENTRY_CUSTOMIZE_8330776599249555820)],
        &[(0b10010, &ENTRY_CUSTOMIZED_18152983780958356874)],
        &[(0b10010, &ENTRY_CUSTOMIZES_5070925338090106827)],
        &[(0b10010, &ENTRY_CUSTOMIZING_2510425683526861127)],
        &[(0b01001, &ENTRY_CUSTOMIZABLE_13082591789323327431)],
        &[(0b01001, &ENTRY_CUSTOMIZATION_6533324325688675249)],
        &[(0b01001, &ENTRY_CUSTOMIZATIONS_4094977061478290809)],
        &[(0b01001, &ENTRY_CUSTOMIZE_8330776599249555820)],
        &[(0b01001, &ENTRY_CUSTOMIZED_18152983780958356874)],
        &[(0b01001, &ENTRY_CUSTOMIZES_5070925338090106827)],
        &[(0b01001, &ENTRY_CUSTOMIZING_2510425683526861127)],
    ],
    range: 6..=12,
};

static VARS_CR_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_CR_CHILDREN),
    value: None,
};

static VARS_CR_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    None,
    None,
    Some(&VARS_CRE_NODE),
    None,
    None,
    None,
    Some(&VARS_CRI_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_CRU_NODE),
    None,
    None,
    None,
    Some(&VARS_CRY_NODE),
    None,
];

static VARS_CRY_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_CRY_CHILDREN),
    value: None,
};

pub static VARS_CRY_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("stalize"),
        dictgen::InsensitiveAscii("stalized"),
        dictgen::InsensitiveAscii("stalizes"),
        dictgen::InsensitiveAscii("stalizing"),
        dictgen::InsensitiveAscii("stallisable"),
        dictgen::InsensitiveAscii("stallisabler"),
        dictgen::InsensitiveAscii("stallisables"),
        dictgen::InsensitiveAscii("stallisablest"),
        dictgen::InsensitiveAscii("stallisation"),
        dictgen::InsensitiveAscii("stallisations"),
        dictgen::InsensitiveAscii("stallise"),
        dictgen::InsensitiveAscii("stallised"),
        dictgen::InsensitiveAscii("stallises"),
        dictgen::InsensitiveAscii("stallising"),
        dictgen::InsensitiveAscii("stallizable"),
        dictgen::InsensitiveAscii("stallizabler"),
        dictgen::InsensitiveAscii("stallizables"),
        dictgen::InsensitiveAscii("stallizablest"),
        dictgen::InsensitiveAscii("stallization"),
        dictgen::InsensitiveAscii("stallizations"),
        dictgen::InsensitiveAscii("stallize"),
        dictgen::InsensitiveAscii("stallized"),
        dictgen::InsensitiveAscii("stallizes"),
        dictgen::InsensitiveAscii("stallizing"),
    ],
    values: &[
        &[(0b00001, &ENTRY_CRYSTALLIZE_3680960475075584665)],
        &[(0b00001, &ENTRY_CRYSTALLIZED_248195502747238890)],
        &[(0b00001, &ENTRY_CRYSTALLIZES_10883222514964571084)],
        &[(0b00001, &ENTRY_CRYSTALLIZING_16188565388667490505)],
        &[(0b10010, &ENTRY_CRYSTALLIZABLE_16889159866170496088)],
        &[(0b10010, &ENTRY_CRYSTALLIZABLER_10028068295407018641)],
        &[(0b10010, &ENTRY_CRYSTALLIZABLES_5177371679598980802)],
        &[(0b10010, &ENTRY_CRYSTALLIZABLEST_15524726073324327188)],
        &[(0b10010, &ENTRY_CRYSTALLIZATION_8976951361725962128)],
        &[(0b10010, &ENTRY_CRYSTALLIZATIONS_18023920101940919054)],
        &[(0b10010, &ENTRY_CRYSTALLIZE_3680960475075584665)],
        &[(0b10010, &ENTRY_CRYSTALLIZED_248195502747238890)],
        &[(0b10010, &ENTRY_CRYSTALLIZES_10883222514964571084)],
        &[(0b10010, &ENTRY_CRYSTALLIZING_16188565388667490505)],
        &[(0b01001, &ENTRY_CRYSTALLIZABLE_16889159866170496088)],
        &[(0b01001, &ENTRY_CRYSTALLIZABLER_10028068295407018641)],
        &[(0b01001, &ENTRY_CRYSTALLIZABLES_5177371679598980802)],
        &[(0b01001, &ENTRY_CRYSTALLIZABLEST_15524726073324327188)],
        &[(0b01001, &ENTRY_CRYSTALLIZATION_8976951361725962128)],
        &[(0b01001, &ENTRY_CRYSTALLIZATIONS_18023920101940919054)],
        &[(0b01001, &ENTRY_CRYSTALLIZE_3680960475075584665)],
        &[(0b01001, &ENTRY_CRYSTALLIZED_248195502747238890)],
        &[(0b01001, &ENTRY_CRYSTALLIZES_10883222514964571084)],
        &[(0b01001, &ENTRY_CRYSTALLIZING_16188565388667490505)],
    ],
    range: 7..=13,
};

static VARS_CRU_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_CRU_CHILDREN),
    value: None,
};

pub static VARS_CRU_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("eler"),
        dictgen::InsensitiveAscii("elest"),
        dictgen::InsensitiveAscii("eller"),
        dictgen::InsensitiveAscii("ellest"),
    ],
    values: &[
        &[(0b01001, &ENTRY_CRUELER_965105578349190970)],
        &[(0b01001, &ENTRY_CRUELEST_13236978233703918484)],
        &[(0b11010, &ENTRY_CRUELER_965105578349190970)],
        &[(0b11010, &ENTRY_CRUELEST_13236978233703918484)],
    ],
    range: 4..=6,
};

static VARS_CRI_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_CRI_CHILDREN),
    value: None,
};

pub static VARS_CRI_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("minalisation"),
        dictgen::InsensitiveAscii("minalisations"),
        dictgen::InsensitiveAscii("minalise"),
        dictgen::InsensitiveAscii("minalised"),
        dictgen::InsensitiveAscii("minalises"),
        dictgen::InsensitiveAscii("minalising"),
        dictgen::InsensitiveAscii("minalization"),
        dictgen::InsensitiveAscii("minalizations"),
        dictgen::InsensitiveAscii("minalize"),
        dictgen::InsensitiveAscii("minalized"),
        dictgen::InsensitiveAscii("minalizes"),
        dictgen::InsensitiveAscii("minalizing"),
        dictgen::InsensitiveAscii("ticisable"),
        dictgen::InsensitiveAscii("ticisabler"),
        dictgen::InsensitiveAscii("ticisables"),
        dictgen::InsensitiveAscii("ticisablest"),
        dictgen::InsensitiveAscii("ticise"),
        dictgen::InsensitiveAscii("ticised"),
        dictgen::InsensitiveAscii("ticiser"),
        dictgen::InsensitiveAscii("ticisers"),
        dictgen::InsensitiveAscii("ticises"),
        dictgen::InsensitiveAscii("ticising"),
        dictgen::InsensitiveAscii("ticizable"),
        dictgen::InsensitiveAscii("ticizabler"),
        dictgen::InsensitiveAscii("ticizables"),
        dictgen::InsensitiveAscii("ticizablest"),
        dictgen::InsensitiveAscii("ticize"),
        dictgen::InsensitiveAscii("ticized"),
        dictgen::InsensitiveAscii("ticizer"),
        dictgen::InsensitiveAscii("ticizers"),
        dictgen::InsensitiveAscii("ticizes"),
        dictgen::InsensitiveAscii("ticizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_CRIMINALIZATION_12203512332897805584)],
        &[(0b10010, &ENTRY_CRIMINALIZATIONS_9877401047859565771)],
        &[(0b10010, &ENTRY_CRIMINALIZE_9971594675545300062)],
        &[(0b10010, &ENTRY_CRIMINALIZED_3582649755795597508)],
        &[(0b10010, &ENTRY_CRIMINALIZES_7223829830621296974)],
        &[(0b10010, &ENTRY_CRIMINALIZING_12354761681927219659)],
        &[(0b01001, &ENTRY_CRIMINALIZATION_12203512332897805584)],
        &[(0b01001, &ENTRY_CRIMINALIZATIONS_9877401047859565771)],
        &[(0b01001, &ENTRY_CRIMINALIZE_9971594675545300062)],
        &[(0b01001, &ENTRY_CRIMINALIZED_3582649755795597508)],
        &[(0b01001, &ENTRY_CRIMINALIZES_7223829830621296974)],
        &[(0b01001, &ENTRY_CRIMINALIZING_12354761681927219659)],
        &[(0b10010, &ENTRY_CRITICIZABLE_12337979955682572299)],
        &[(0b10010, &ENTRY_CRITICIZABLER_16750540382481946795)],
        &[(0b10010, &ENTRY_CRITICIZABLES_14668868341788863043)],
        &[(0b10010, &ENTRY_CRITICIZABLEST_444603967053446436)],
        &[(0b10010, &ENTRY_CRITICIZE_13517498827728588589)],
        &[(0b10010, &ENTRY_CRITICIZED_10569362492506305842)],
        &[(0b10010, &ENTRY_CRITICIZER_8603387376111275284)],
        &[(0b10010, &ENTRY_CRITICIZERS_17493845359467775710)],
        &[(0b10010, &ENTRY_CRITICIZES_11166250956805349653)],
        &[(0b10010, &ENTRY_CRITICIZING_14274101564029962026)],
        &[(0b01001, &ENTRY_CRITICIZABLE_12337979955682572299)],
        &[(0b01001, &ENTRY_CRITICIZABLER_16750540382481946795)],
        &[(0b01001, &ENTRY_CRITICIZABLES_14668868341788863043)],
        &[(0b01001, &ENTRY_CRITICIZABLEST_444603967053446436)],
        &[(0b01001, &ENTRY_CRITICIZE_13517498827728588589)],
        &[(0b01001, &ENTRY_CRITICIZED_10569362492506305842)],
        &[(0b01001, &ENTRY_CRITICIZER_8603387376111275284)],
        &[(0b01001, &ENTRY_CRITICIZERS_17493845359467775710)],
        &[(0b01001, &ENTRY_CRITICIZES_11166250956805349653)],
        &[(0b01001, &ENTRY_CRITICIZING_14274101564029962026)],
    ],
    range: 6..=13,
};

static VARS_CRE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_CRE_CHILDREN),
    value: None,
};

pub static VARS_CRE_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("nellate"),
        dictgen::InsensitiveAscii("nellated"),
        dictgen::InsensitiveAscii("nellater"),
        dictgen::InsensitiveAscii("nellates"),
        dictgen::InsensitiveAscii("nellatest"),
        dictgen::InsensitiveAscii("nellating"),
        dictgen::InsensitiveAscii("olisation"),
        dictgen::InsensitiveAscii("olisations"),
        dictgen::InsensitiveAscii("olise"),
        dictgen::InsensitiveAscii("olised"),
        dictgen::InsensitiveAscii("olises"),
        dictgen::InsensitiveAscii("olising"),
        dictgen::InsensitiveAscii("olization"),
        dictgen::InsensitiveAscii("olizations"),
        dictgen::InsensitiveAscii("olize"),
        dictgen::InsensitiveAscii("olized"),
        dictgen::InsensitiveAscii("olizes"),
        dictgen::InsensitiveAscii("olizing"),
    ],
    values: &[
        &[(0b11010, &ENTRY_CRENELATE_16654827051033938768)],
        &[(0b11010, &ENTRY_CRENELATED_14791658803956712009)],
        &[(0b11010, &ENTRY_CRENELATER_11388015695766004333)],
        &[(0b11010, &ENTRY_CRENELATES_10245337469566174666)],
        &[(0b11010, &ENTRY_CRENELATEST_14183406657979002478)],
        &[(0b11010, &ENTRY_CRENELATING_17583663146982717987)],
        &[(0b10010, &ENTRY_CREOLIZATION_18113727530889902093)],
        &[(0b10010, &ENTRY_CREOLIZATIONS_17009489055568961562)],
        &[(0b10010, &ENTRY_CREOLIZE_146003202220590288)],
        &[(0b10010, &ENTRY_CREOLIZED_11852473936521640088)],
        &[(0b10010, &ENTRY_CREOLIZES_17960363375761238839)],
        &[(0b10010, &ENTRY_CREOLIZING_13664113412449994869)],
        &[(0b01001, &ENTRY_CREOLIZATION_18113727530889902093)],
        &[(0b01001, &ENTRY_CREOLIZATIONS_17009489055568961562)],
        &[(0b01001, &ENTRY_CREOLIZE_146003202220590288)],
        &[(0b01001, &ENTRY_CREOLIZED_11852473936521640088)],
        &[(0b01001, &ENTRY_CREOLIZES_17960363375761238839)],
        &[(0b01001, &ENTRY_CREOLIZING_13664113412449994869)],
    ],
    range: 5..=10,
};

static VARS_CO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_CO_CHILDREN),
    value: None,
};

static VARS_CO_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    None,
    None,
    Some(&VARS_COE_NODE),
    None,
    Some(&VARS_COG_NODE),
    None,
    None,
    None,
    None,
    Some(&VARS_COL_NODE),
    Some(&VARS_COM_NODE),
    Some(&VARS_CON_NODE),
    Some(&VARS_COO_NODE),
    Some(&VARS_COP_NODE),
    None,
    None,
    Some(&VARS_COS_NODE),
    None,
    Some(&VARS_COU_NODE),
    None,
    None,
    None,
    None,
    Some(&VARS_COZ_NODE),
];

static VARS_COZ_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_COZ_CHILDREN),
    value: None,
};

pub static VARS_COZ_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ied"),
        dictgen::InsensitiveAscii("ier"),
        dictgen::InsensitiveAscii("ies"),
        dictgen::InsensitiveAscii("iest"),
        dictgen::InsensitiveAscii("ily"),
        dictgen::InsensitiveAscii("iness"),
        dictgen::InsensitiveAscii("y"),
        dictgen::InsensitiveAscii("ying"),
    ],
    values: &[
        &[(0b01001, &ENTRY_COZIED_6562646973128567884)],
        &[(0b01001, &ENTRY_COZIER_9366197992019890355)],
        &[(0b01001, &ENTRY_COZIES_1955518053712297702)],
        &[(0b01001, &ENTRY_COZIEST_10595392179485625103)],
        &[(0b01001, &ENTRY_COZILY_9030881398920983543)],
        &[(0b01001, &ENTRY_COZINESS_3678850341916343717)],
        &[(0b01001, &ENTRY_COZY_7236665209258571742)],
        &[(0b01001, &ENTRY_COZYING_15155247936314647373)],
    ],
    range: 1..=5,
};

static VARS_COU_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_COU_CHILDREN),
    value: None,
};

pub static VARS_COU_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ncillor"),
        dictgen::InsensitiveAscii("ncillors"),
        dictgen::InsensitiveAscii("ncillorship"),
        dictgen::InsensitiveAscii("ncillorships"),
        dictgen::InsensitiveAscii("ncilor"),
        dictgen::InsensitiveAscii("ncilors"),
        dictgen::InsensitiveAscii("ncilorship"),
        dictgen::InsensitiveAscii("ncilorships"),
        dictgen::InsensitiveAscii("nseled"),
        dictgen::InsensitiveAscii("nseling"),
        dictgen::InsensitiveAscii("nselled"),
        dictgen::InsensitiveAscii("nselling"),
        dictgen::InsensitiveAscii("nsellor"),
        dictgen::InsensitiveAscii("nsellors"),
        dictgen::InsensitiveAscii("nselor"),
        dictgen::InsensitiveAscii("nselors"),
    ],
    values: &[
        &[(0b11010, &ENTRY_COUNCILOR_15580609476721559009)],
        &[(0b11010, &ENTRY_COUNCILORS_8086440655852289978)],
        &[(0b11010, &ENTRY_COUNCILORSHIP_16998032340551826478)],
        &[(0b11010, &ENTRY_COUNCILORSHIPS_3525523011873776596)],
        &[(0b00001, &ENTRY_COUNCILOR_15580609476721559009)],
        &[(0b00001, &ENTRY_COUNCILORS_8086440655852289978)],
        &[(0b00001, &ENTRY_COUNCILORSHIP_16998032340551826478)],
        &[(0b00001, &ENTRY_COUNCILORSHIPS_3525523011873776596)],
        &[(0b00001, &ENTRY_COUNSELED_10079969979774535185)],
        &[(0b00001, &ENTRY_COUNSELING_3362710659606651238)],
        &[(0b11010, &ENTRY_COUNSELED_10079969979774535185)],
        &[(0b11010, &ENTRY_COUNSELING_3362710659606651238)],
        &[(0b11010, &ENTRY_COUNSELOR_13404070207747695814)],
        &[(0b11010, &ENTRY_COUNSELORS_1887733060441859158)],
        &[(0b01001, &ENTRY_COUNSELOR_13404070207747695814)],
        &[(0b01001, &ENTRY_COUNSELORS_1887733060441859158)],
    ],
    range: 6..=12,
};

static VARS_COS_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_COS_CHILDREN),
    value: None,
};

pub static VARS_COS_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ied"),
        dictgen::InsensitiveAscii("ier"),
        dictgen::InsensitiveAscii("ies"),
        dictgen::InsensitiveAscii("iest"),
        dictgen::InsensitiveAscii("ily"),
        dictgen::InsensitiveAscii("iness"),
        dictgen::InsensitiveAscii("mopolitanise"),
        dictgen::InsensitiveAscii("mopolitanised"),
        dictgen::InsensitiveAscii("mopolitanises"),
        dictgen::InsensitiveAscii("mopolitanising"),
        dictgen::InsensitiveAscii("mopolitanize"),
        dictgen::InsensitiveAscii("mopolitanized"),
        dictgen::InsensitiveAscii("mopolitanizes"),
        dictgen::InsensitiveAscii("mopolitanizing"),
        dictgen::InsensitiveAscii("y"),
        dictgen::InsensitiveAscii("ying"),
    ],
    values: &[
        &[(0b11010, &ENTRY_COZIED_6562646973128567884)],
        &[(0b11010, &ENTRY_COZIER_9366197992019890355)],
        &[(0b11010, &ENTRY_COZIES_1955518053712297702)],
        &[(0b11010, &ENTRY_COZIEST_10595392179485625103)],
        &[(0b10010, &ENTRY_COZILY_9030881398920983543)],
        &[(0b10010, &ENTRY_COZINESS_3678850341916343717)],
        &[(0b10010, &ENTRY_COSMOPOLITANIZE_2274947466234383776)],
        &[(0b10010, &ENTRY_COSMOPOLITANIZED_7733201348304626234)],
        &[(0b10010, &ENTRY_COSMOPOLITANIZES_10510882645788399153)],
        &[(0b10010, &ENTRY_COSMOPOLITANIZING_8986323684241042113)],
        &[(0b01001, &ENTRY_COSMOPOLITANIZE_2274947466234383776)],
        &[(0b01001, &ENTRY_COSMOPOLITANIZED_7733201348304626234)],
        &[(0b01001, &ENTRY_COSMOPOLITANIZES_10510882645788399153)],
        &[(0b01001, &ENTRY_COSMOPOLITANIZING_8986323684241042113)],
        &[(0b11010, &ENTRY_COZY_7236665209258571742)],
        &[(0b11010, &ENTRY_COZYING_15155247936314647373)],
    ],
    range: 1..=14,
};

static VARS_COP_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_COP_CHILDREN),
    value: None,
};

pub static VARS_COP_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("olymerise"),
        dictgen::InsensitiveAscii("olymerised"),
        dictgen::InsensitiveAscii("olymerises"),
        dictgen::InsensitiveAscii("olymerising"),
        dictgen::InsensitiveAscii("olymerize"),
        dictgen::InsensitiveAscii("olymerized"),
        dictgen::InsensitiveAscii("olymerizes"),
        dictgen::InsensitiveAscii("olymerizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_COPOLYMERIZE_2974760063313637629)],
        &[(0b10010, &ENTRY_COPOLYMERIZED_4836344646706287325)],
        &[(0b10010, &ENTRY_COPOLYMERIZES_3215794498833268659)],
        &[(0b10010, &ENTRY_COPOLYMERIZING_343564958295258899)],
        &[(0b01001, &ENTRY_COPOLYMERIZE_2974760063313637629)],
        &[(0b01001, &ENTRY_COPOLYMERIZED_4836344646706287325)],
        &[(0b01001, &ENTRY_COPOLYMERIZES_3215794498833268659)],
        &[(0b01001, &ENTRY_COPOLYMERIZING_343564958295258899)],
    ],
    range: 9..=11,
};

static VARS_COO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_COO_CHILDREN),
    value: None,
};

pub static VARS_COO_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[dictgen::InsensitiveAscii("ky")],
    values: &[&[(0b00001, &ENTRY_COOKIE_9287663065088073450)]],
    range: 2..=2,
};

static VARS_CON_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_CON_CHILDREN),
    value: None,
};

pub static VARS_CON_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ceptualisation"),
        dictgen::InsensitiveAscii("ceptualisations"),
        dictgen::InsensitiveAscii("ceptualise"),
        dictgen::InsensitiveAscii("ceptualised"),
        dictgen::InsensitiveAscii("ceptualises"),
        dictgen::InsensitiveAscii("ceptualising"),
        dictgen::InsensitiveAscii("ceptualization"),
        dictgen::InsensitiveAscii("ceptualizations"),
        dictgen::InsensitiveAscii("ceptualize"),
        dictgen::InsensitiveAscii("ceptualized"),
        dictgen::InsensitiveAscii("ceptualizes"),
        dictgen::InsensitiveAscii("ceptualizing"),
        dictgen::InsensitiveAscii("cretisation"),
        dictgen::InsensitiveAscii("cretisations"),
        dictgen::InsensitiveAscii("cretise"),
        dictgen::InsensitiveAscii("cretised"),
        dictgen::InsensitiveAscii("cretises"),
        dictgen::InsensitiveAscii("cretising"),
        dictgen::InsensitiveAscii("cretization"),
        dictgen::InsensitiveAscii("cretizations"),
        dictgen::InsensitiveAscii("cretize"),
        dictgen::InsensitiveAscii("cretized"),
        dictgen::InsensitiveAscii("cretizes"),
        dictgen::InsensitiveAscii("cretizing"),
        dictgen::InsensitiveAscii("necter"),
        dictgen::InsensitiveAscii("necters"),
        dictgen::InsensitiveAscii("nectible"),
        dictgen::InsensitiveAscii("nexion"),
        dictgen::InsensitiveAscii("nexions"),
        dictgen::InsensitiveAscii("tainerisation"),
        dictgen::InsensitiveAscii("tainerisations"),
        dictgen::InsensitiveAscii("tainerise"),
        dictgen::InsensitiveAscii("tainerised"),
        dictgen::InsensitiveAscii("tainerises"),
        dictgen::InsensitiveAscii("tainerising"),
        dictgen::InsensitiveAscii("tainerization"),
        dictgen::InsensitiveAscii("tainerizations"),
        dictgen::InsensitiveAscii("tainerize"),
        dictgen::InsensitiveAscii("tainerized"),
        dictgen::InsensitiveAscii("tainerizes"),
        dictgen::InsensitiveAscii("tainerizing"),
        dictgen::InsensitiveAscii("textualisation"),
        dictgen::InsensitiveAscii("textualisations"),
        dictgen::InsensitiveAscii("textualise"),
        dictgen::InsensitiveAscii("textualised"),
        dictgen::InsensitiveAscii("textualises"),
        dictgen::InsensitiveAscii("textualising"),
        dictgen::InsensitiveAscii("textualization"),
        dictgen::InsensitiveAscii("textualizations"),
        dictgen::InsensitiveAscii("textualize"),
        dictgen::InsensitiveAscii("textualized"),
        dictgen::InsensitiveAscii("textualizes"),
        dictgen::InsensitiveAscii("textualizing"),
        dictgen::InsensitiveAscii("ventionalise"),
        dictgen::InsensitiveAscii("ventionalised"),
        dictgen::InsensitiveAscii("ventionalises"),
        dictgen::InsensitiveAscii("ventionalising"),
        dictgen::InsensitiveAscii("ventionalize"),
        dictgen::InsensitiveAscii("ventionalized"),
        dictgen::InsensitiveAscii("ventionalizes"),
        dictgen::InsensitiveAscii("ventionalizing"),
        dictgen::InsensitiveAscii("vertor"),
        dictgen::InsensitiveAscii("vertors"),
    ],
    values: &[
        &[(0b10010, &ENTRY_CONCEPTUALIZATION_1957977035290831317)],
        &[(0b10010, &ENTRY_CONCEPTUALIZATIONS_1431558151182672246)],
        &[(0b10010, &ENTRY_CONCEPTUALIZE_14569429550467897306)],
        &[(0b10010, &ENTRY_CONCEPTUALIZED_16855689032804433939)],
        &[(0b10010, &ENTRY_CONCEPTUALIZES_3109330931899076925)],
        &[(0b10010, &ENTRY_CONCEPTUALIZING_3830098906802741483)],
        &[(0b01001, &ENTRY_CONCEPTUALIZATION_1957977035290831317)],
        &[(0b01001, &ENTRY_CONCEPTUALIZATIONS_1431558151182672246)],
        &[(0b01001, &ENTRY_CONCEPTUALIZE_14569429550467897306)],
        &[(0b01001, &ENTRY_CONCEPTUALIZED_16855689032804433939)],
        &[(0b01001, &ENTRY_CONCEPTUALIZES_3109330931899076925)],
        &[(0b01001, &ENTRY_CONCEPTUALIZING_3830098906802741483)],
        &[(0b10010, &ENTRY_CONCRETIZATION_16748795997403623068)],
        &[(0b10010, &ENTRY_CONCRETIZATIONS_16577819847117636011)],
        &[(0b10010, &ENTRY_CONCRETIZE_2393131352307099452)],
        &[(0b10010, &ENTRY_CONCRETIZED_11886059222443029705)],
        &[(0b10010, &ENTRY_CONCRETIZES_14708644144755990132)],
        &[(0b10010, &ENTRY_CONCRETIZING_6612279978454068181)],
        &[(0b01001, &ENTRY_CONCRETIZATION_16748795997403623068)],
        &[(0b01001, &ENTRY_CONCRETIZATIONS_16577819847117636011)],
        &[(0b01001, &ENTRY_CONCRETIZE_2393131352307099452)],
        &[(0b01001, &ENTRY_CONCRETIZED_11886059222443029705)],
        &[(0b01001, &ENTRY_CONCRETIZES_14708644144755990132)],
        &[(0b01001, &ENTRY_CONCRETIZING_6612279978454068181)],
        &[(0b00001, &ENTRY_CONNECTOR_13923636240148187800)],
        &[(0b00001, &ENTRY_CONNECTORS_2449191281557186850)],
        &[(0b00001, &ENTRY_CONNECTABLE_7524650066461359012)],
        &[(0b10010, &ENTRY_CONNECTION_16157944294383303345)],
        &[(0b10010, &ENTRY_CONNECTIONS_13854358641231956725)],
        &[(0b10010, &ENTRY_CONTAINERIZATION_357714449239345018)],
        &[(0b10010, &ENTRY_CONTAINERIZATIONS_1825293490197224406)],
        &[(0b10010, &ENTRY_CONTAINERIZE_16524442428649009741)],
        &[(0b10010, &ENTRY_CONTAINERIZED_11191961675041311832)],
        &[(0b10010, &ENTRY_CONTAINERIZES_128119427989538890)],
        &[(0b10010, &ENTRY_CONTAINERIZING_13615379785688951746)],
        &[(0b01001, &ENTRY_CONTAINERIZATION_357714449239345018)],
        &[(0b01001, &ENTRY_CONTAINERIZATIONS_1825293490197224406)],
        &[(0b01001, &ENTRY_CONTAINERIZE_16524442428649009741)],
        &[(0b01001, &ENTRY_CONTAINERIZED_11191961675041311832)],
        &[(0b01001, &ENTRY_CONTAINERIZES_128119427989538890)],
        &[(0b01001, &ENTRY_CONTAINERIZING_13615379785688951746)],
        &[(0b10010, &ENTRY_CONTEXTUALIZATION_15725305900345696430)],
        &[(0b10010, &ENTRY_CONTEXTUALIZATIONS_17844118780680419482)],
        &[(0b10010, &ENTRY_CONTEXTUALIZE_1732229238408526525)],
        &[(0b10010, &ENTRY_CONTEXTUALIZED_13151283679008083721)],
        &[(0b10010, &ENTRY_CONTEXTUALIZES_9989549820338407239)],
        &[(0b10010, &ENTRY_CONTEXTUALIZING_15565025679692944311)],
        &[(0b01001, &ENTRY_CONTEXTUALIZATION_15725305900345696430)],
        &[(0b01001, &ENTRY_CONTEXTUALIZATIONS_17844118780680419482)],
        &[(0b01001, &ENTRY_CONTEXTUALIZE_1732229238408526525)],
        &[(0b01001, &ENTRY_CONTEXTUALIZED_13151283679008083721)],
        &[(0b01001, &ENTRY_CONTEXTUALIZES_9989549820338407239)],
        &[(0b01001, &ENTRY_CONTEXTUALIZING_15565025679692944311)],
        &[(0b10010, &ENTRY_CONVENTIONALIZE_8965825227981389572)],
        &[(0b10010, &ENTRY_CONVENTIONALIZED_2515352950983299261)],
        &[(0b10010, &ENTRY_CONVENTIONALIZES_9956067957387320740)],
        &[(0b10010, &ENTRY_CONVENTIONALIZING_1207910973175187527)],
        &[(0b01001, &ENTRY_CONVENTIONALIZE_8965825227981389572)],
        &[(0b01001, &ENTRY_CONVENTIONALIZED_2515352950983299261)],
        &[(0b01001, &ENTRY_CONVENTIONALIZES_9956067957387320740)],
        &[(0b01001, &ENTRY_CONVENTIONALIZING_1207910973175187527)],
        &[
            (0b10011, &ENTRY_CONVERTER_11042638331866408272),
            (0b10010, &ENTRY_CONVERTER_9597145040682608749),
        ],
        &[
            (0b10011, &ENTRY_CONVERTERS_18202666178479349443),
            (0b10010, &ENTRY_CONVERTERS_2794867188871344776),
        ],
    ],
    range: 6..=15,
};

static VARS_COM_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_COM_CHILDREN),
    value: None,
};

pub static VARS_COM_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("mercialisation"),
        dictgen::InsensitiveAscii("mercialisations"),
        dictgen::InsensitiveAscii("mercialise"),
        dictgen::InsensitiveAscii("mercialised"),
        dictgen::InsensitiveAscii("mercialises"),
        dictgen::InsensitiveAscii("mercialising"),
        dictgen::InsensitiveAscii("mercialization"),
        dictgen::InsensitiveAscii("mercializations"),
        dictgen::InsensitiveAscii("mercialize"),
        dictgen::InsensitiveAscii("mercialized"),
        dictgen::InsensitiveAscii("mercializes"),
        dictgen::InsensitiveAscii("mercializing"),
        dictgen::InsensitiveAscii("partmentalisation"),
        dictgen::InsensitiveAscii("partmentalisations"),
        dictgen::InsensitiveAscii("partmentalise"),
        dictgen::InsensitiveAscii("partmentalised"),
        dictgen::InsensitiveAscii("partmentalises"),
        dictgen::InsensitiveAscii("partmentalising"),
        dictgen::InsensitiveAscii("partmentalization"),
        dictgen::InsensitiveAscii("partmentalizations"),
        dictgen::InsensitiveAscii("partmentalize"),
        dictgen::InsensitiveAscii("partmentalized"),
        dictgen::InsensitiveAscii("partmentalizes"),
        dictgen::InsensitiveAscii("partmentalizing"),
        dictgen::InsensitiveAscii("puterisation"),
        dictgen::InsensitiveAscii("puterisations"),
        dictgen::InsensitiveAscii("puterise"),
        dictgen::InsensitiveAscii("puterised"),
        dictgen::InsensitiveAscii("puterises"),
        dictgen::InsensitiveAscii("puterising"),
        dictgen::InsensitiveAscii("puterization"),
        dictgen::InsensitiveAscii("puterizations"),
        dictgen::InsensitiveAscii("puterize"),
        dictgen::InsensitiveAscii("puterized"),
        dictgen::InsensitiveAscii("puterizes"),
        dictgen::InsensitiveAscii("puterizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_COMMERCIALIZATION_11469816268140890812)],
        &[(0b10010, &ENTRY_COMMERCIALIZATIONS_1148877062636686126)],
        &[(0b10010, &ENTRY_COMMERCIALIZE_1137904747608279477)],
        &[(0b10010, &ENTRY_COMMERCIALIZED_2494708843919137706)],
        &[(0b10010, &ENTRY_COMMERCIALIZES_14762377282271056556)],
        &[(0b10010, &ENTRY_COMMERCIALIZING_11104285966117995808)],
        &[(0b01001, &ENTRY_COMMERCIALIZATION_11469816268140890812)],
        &[(0b01001, &ENTRY_COMMERCIALIZATIONS_1148877062636686126)],
        &[(0b01001, &ENTRY_COMMERCIALIZE_1137904747608279477)],
        &[(0b01001, &ENTRY_COMMERCIALIZED_2494708843919137706)],
        &[(0b01001, &ENTRY_COMMERCIALIZES_14762377282271056556)],
        &[(0b01001, &ENTRY_COMMERCIALIZING_11104285966117995808)],
        &[(0b10010, &ENTRY_COMPARTMENTALIZATION_8817670805873858578)],
        &[(0b10010, &ENTRY_COMPARTMENTALIZATIONS_7803350045421233416)],
        &[(0b10010, &ENTRY_COMPARTMENTALIZE_8466180960814001454)],
        &[(0b10010, &ENTRY_COMPARTMENTALIZED_5318284676300892382)],
        &[(0b10010, &ENTRY_COMPARTMENTALIZES_295558042693607522)],
        &[(0b10010, &ENTRY_COMPARTMENTALIZING_180997580421371176)],
        &[(0b01001, &ENTRY_COMPARTMENTALIZATION_8817670805873858578)],
        &[(0b01001, &ENTRY_COMPARTMENTALIZATIONS_7803350045421233416)],
        &[(0b01001, &ENTRY_COMPARTMENTALIZE_8466180960814001454)],
        &[(0b01001, &ENTRY_COMPARTMENTALIZED_5318284676300892382)],
        &[(0b01001, &ENTRY_COMPARTMENTALIZES_295558042693607522)],
        &[(0b01001, &ENTRY_COMPARTMENTALIZING_180997580421371176)],
        &[(0b10010, &ENTRY_COMPUTERIZATION_8388242133507632203)],
        &[(0b10010, &ENTRY_COMPUTERIZATIONS_14988232009287248263)],
        &[(0b10010, &ENTRY_COMPUTERIZE_540581710185506773)],
        &[(0b10010, &ENTRY_COMPUTERIZED_17906439342563202559)],
        &[(0b10010, &ENTRY_COMPUTERIZES_5839612827384030489)],
        &[(0b10010, &ENTRY_COMPUTERIZING_9293272863931059588)],
        &[(0b01001, &ENTRY_COMPUTERIZATION_8388242133507632203)],
        &[(0b01001, &ENTRY_COMPUTERIZATIONS_14988232009287248263)],
        &[(0b01001, &ENTRY_COMPUTERIZE_540581710185506773)],
        &[(0b01001, &ENTRY_COMPUTERIZED_17906439342563202559)],
        &[(0b01001, &ENTRY_COMPUTERIZES_5839612827384030489)],
        &[(0b01001, &ENTRY_COMPUTERIZING_9293272863931059588)],
    ],
    range: 8..=18,
};

static VARS_COL_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_COL_CHILDREN),
    value: None,
};

static VARS_COL_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_COLL_NODE),
    None,
    None,
    Some(&VARS_COLO_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_COLO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_COLO_CHILDREN),
    value: None,
};

static VARS_COLO_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_COLON_NODE),
    None,
    None,
    None,
    Some(&VARS_COLOR_NODE),
    None,
    None,
    Some(&VARS_COLOU_NODE),
    None,
    None,
    None,
    None,
    None,
];

static VARS_COLOU_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_COLOU_CHILDREN),
    value: None,
};

pub static VARS_COLOU_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("r"),
        dictgen::InsensitiveAscii("rable"),
        dictgen::InsensitiveAscii("rabler"),
        dictgen::InsensitiveAscii("rables"),
        dictgen::InsensitiveAscii("rablest"),
        dictgen::InsensitiveAscii("rant"),
        dictgen::InsensitiveAscii("rants"),
        dictgen::InsensitiveAscii("ration"),
        dictgen::InsensitiveAscii("rations"),
        dictgen::InsensitiveAscii("red"),
        dictgen::InsensitiveAscii("reds"),
        dictgen::InsensitiveAscii("rer"),
        dictgen::InsensitiveAscii("rers"),
        dictgen::InsensitiveAscii("rest"),
        dictgen::InsensitiveAscii("rful"),
        dictgen::InsensitiveAscii("rfuler"),
        dictgen::InsensitiveAscii("rfulest"),
        dictgen::InsensitiveAscii("rfullier"),
        dictgen::InsensitiveAscii("rfulliest"),
        dictgen::InsensitiveAscii("rfully"),
        dictgen::InsensitiveAscii("rfulness"),
        dictgen::InsensitiveAscii("rfulnesses"),
        dictgen::InsensitiveAscii("rimeter"),
        dictgen::InsensitiveAscii("rimeters"),
        dictgen::InsensitiveAscii("rimetric"),
        dictgen::InsensitiveAscii("rimetrics"),
        dictgen::InsensitiveAscii("rimetries"),
        dictgen::InsensitiveAscii("rimetry"),
        dictgen::InsensitiveAscii("ring"),
        dictgen::InsensitiveAscii("rings"),
        dictgen::InsensitiveAscii("rist"),
        dictgen::InsensitiveAscii("rists"),
        dictgen::InsensitiveAscii("rless"),
        dictgen::InsensitiveAscii("rlesser"),
        dictgen::InsensitiveAscii("rlessest"),
        dictgen::InsensitiveAscii("rlesslier"),
        dictgen::InsensitiveAscii("rlessliest"),
        dictgen::InsensitiveAscii("rlessly"),
        dictgen::InsensitiveAscii("rs"),
        dictgen::InsensitiveAscii("rway"),
        dictgen::InsensitiveAscii("rways"),
    ],
    values: &[
        &[(0b11010, &ENTRY_COLOR_4390088940109675041)],
        &[(0b11010, &ENTRY_COLORABLE_7050710397577980432)],
        &[(0b11010, &ENTRY_COLORABLER_9668141786678165672)],
        &[(0b11010, &ENTRY_COLORABLES_9835654246095695799)],
        &[(0b11010, &ENTRY_COLORABLEST_7942972157513237380)],
        &[(0b11010, &ENTRY_COLORANT_8508078357677443619)],
        &[(0b11010, &ENTRY_COLORANTS_5504580436166605292)],
        &[(0b11010, &ENTRY_COLORATION_16722034247789816535)],
        &[(0b11010, &ENTRY_COLORATIONS_10032620475490215127)],
        &[(0b11010, &ENTRY_COLORED_16993799574214757686)],
        &[(0b11010, &ENTRY_COLOREDS_3930825355719143828)],
        &[(0b11010, &ENTRY_COLORER_14593090349752845026)],
        &[(0b11010, &ENTRY_COLORERS_13681356278503403951)],
        &[(0b11010, &ENTRY_COLORREST_13441910764710538786)],
        &[(0b11010, &ENTRY_COLORFUL_4806683583475489506)],
        &[(0b11010, &ENTRY_COLORFULER_4366882207953732907)],
        &[(0b11010, &ENTRY_COLORFULEST_15151264088558637473)],
        &[(0b11010, &ENTRY_COLORFULLIER_12948386305746310089)],
        &[(0b11010, &ENTRY_COLORFULLIEST_14305289677627923994)],
        &[(0b11010, &ENTRY_COLORFULLY_12792342106302406309)],
        &[(0b11010, &ENTRY_COLORFULNESS_15839726768009061296)],
        &[(0b11010, &ENTRY_COLORFULNESSES_12191353247710978564)],
        &[(0b11010, &ENTRY_COLORIMETER_7886930247663758657)],
        &[(0b11010, &ENTRY_COLORIMETERS_11304231755461980338)],
        &[(0b11010, &ENTRY_COLORIMETRIC_7191450808866389504)],
        &[(0b11010, &ENTRY_COLORIMETRICS_7899060896503658636)],
        &[(0b11010, &ENTRY_COLORIMETRIES_4002895138139503597)],
        &[(0b11010, &ENTRY_COLORIMETRY_17653132236103689829)],
        &[(0b11010, &ENTRY_COLORING_1146707622868481032)],
        &[(0b11010, &ENTRY_COLORINGS_7915048393125592470)],
        &[(0b11010, &ENTRY_COLORIST_17294665081422796979)],
        &[(0b11010, &ENTRY_COLORISTS_12579547357893269970)],
        &[(0b11010, &ENTRY_COLORLESS_79666121160281791)],
        &[(0b11010, &ENTRY_COLORLESSER_14130375164463853792)],
        &[(0b11010, &ENTRY_COLORLESSEST_14480954022966990260)],
        &[(0b11010, &ENTRY_COLORLESSLIER_4162646048805483531)],
        &[(0b11010, &ENTRY_COLORLESSLIEST_12869681984000132288)],
        &[(0b11010, &ENTRY_COLORLESSLY_13297396459356641001)],
        &[(0b11010, &ENTRY_COLORS_11482118763257927768)],
        &[(0b11010, &ENTRY_COLORWAY_17470413378276487899)],
        &[(0b11010, &ENTRY_COLORWAYS_4628145222031734139)],
    ],
    range: 1..=10,
};

static VARS_COLOR_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_COLOR_CHILDREN),
    value: Some(&[(0b11001, &ENTRY_COLOR_4390088940109675041)]),
};

pub static VARS_COLOR_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("able"),
        dictgen::InsensitiveAscii("abler"),
        dictgen::InsensitiveAscii("ables"),
        dictgen::InsensitiveAscii("ablest"),
        dictgen::InsensitiveAscii("ant"),
        dictgen::InsensitiveAscii("ants"),
        dictgen::InsensitiveAscii("ed"),
        dictgen::InsensitiveAscii("eds"),
        dictgen::InsensitiveAscii("er"),
        dictgen::InsensitiveAscii("ers"),
        dictgen::InsensitiveAscii("ful"),
        dictgen::InsensitiveAscii("fuler"),
        dictgen::InsensitiveAscii("fulest"),
        dictgen::InsensitiveAscii("fullier"),
        dictgen::InsensitiveAscii("fulliest"),
        dictgen::InsensitiveAscii("fully"),
        dictgen::InsensitiveAscii("fulness"),
        dictgen::InsensitiveAscii("fulnesses"),
        dictgen::InsensitiveAscii("ing"),
        dictgen::InsensitiveAscii("ings"),
        dictgen::InsensitiveAscii("ist"),
        dictgen::InsensitiveAscii("ists"),
        dictgen::InsensitiveAscii("less"),
        dictgen::InsensitiveAscii("lesser"),
        dictgen::InsensitiveAscii("lessest"),
        dictgen::InsensitiveAscii("lesslier"),
        dictgen::InsensitiveAscii("lessliest"),
        dictgen::InsensitiveAscii("lessly"),
        dictgen::InsensitiveAscii("rest"),
        dictgen::InsensitiveAscii("s"),
        dictgen::InsensitiveAscii("way"),
        dictgen::InsensitiveAscii("ways"),
    ],
    values: &[
        &[(0b11001, &ENTRY_COLORABLE_7050710397577980432)],
        &[(0b11001, &ENTRY_COLORABLER_9668141786678165672)],
        &[(0b11001, &ENTRY_COLORABLES_9835654246095695799)],
        &[(0b11001, &ENTRY_COLORABLEST_7942972157513237380)],
        &[(0b11001, &ENTRY_COLORANT_8508078357677443619)],
        &[(0b11001, &ENTRY_COLORANTS_5504580436166605292)],
        &[(0b11001, &ENTRY_COLORED_16993799574214757686)],
        &[(0b11001, &ENTRY_COLOREDS_3930825355719143828)],
        &[(0b11001, &ENTRY_COLORER_14593090349752845026)],
        &[(0b11001, &ENTRY_COLORERS_13681356278503403951)],
        &[(0b11001, &ENTRY_COLORFUL_4806683583475489506)],
        &[(0b11001, &ENTRY_COLORFULER_4366882207953732907)],
        &[(0b11001, &ENTRY_COLORFULEST_15151264088558637473)],
        &[(0b11001, &ENTRY_COLORFULLIER_12948386305746310089)],
        &[(0b11001, &ENTRY_COLORFULLIEST_14305289677627923994)],
        &[(0b11001, &ENTRY_COLORFULLY_12792342106302406309)],
        &[(0b11001, &ENTRY_COLORFULNESS_15839726768009061296)],
        &[(0b11001, &ENTRY_COLORFULNESSES_12191353247710978564)],
        &[(0b11001, &ENTRY_COLORING_1146707622868481032)],
        &[(0b11001, &ENTRY_COLORINGS_7915048393125592470)],
        &[(0b01001, &ENTRY_COLORIST_17294665081422796979)],
        &[(0b01001, &ENTRY_COLORISTS_12579547357893269970)],
        &[(0b11001, &ENTRY_COLORLESS_79666121160281791)],
        &[(0b11001, &ENTRY_COLORLESSER_14130375164463853792)],
        &[(0b11001, &ENTRY_COLORLESSEST_14480954022966990260)],
        &[(0b11001, &ENTRY_COLORLESSLIER_4162646048805483531)],
        &[(0b11001, &ENTRY_COLORLESSLIEST_12869681984000132288)],
        &[(0b11001, &ENTRY_COLORLESSLY_13297396459356641001)],
        &[(0b11001, &ENTRY_COLORREST_13441910764710538786)],
        &[(0b11001, &ENTRY_COLORS_11482118763257927768)],
        &[(0b11001, &ENTRY_COLORWAY_17470413378276487899)],
        &[(0b11001, &ENTRY_COLORWAYS_4628145222031734139)],
    ],
    range: 1..=9,
};

static VARS_COLON_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_COLON_CHILDREN),
    value: None,
};

pub static VARS_COLON_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("isation"),
        dictgen::InsensitiveAscii("isations"),
        dictgen::InsensitiveAscii("ise"),
        dictgen::InsensitiveAscii("ised"),
        dictgen::InsensitiveAscii("iser"),
        dictgen::InsensitiveAscii("isers"),
        dictgen::InsensitiveAscii("ises"),
        dictgen::InsensitiveAscii("ising"),
        dictgen::InsensitiveAscii("ization"),
        dictgen::InsensitiveAscii("izations"),
        dictgen::InsensitiveAscii("ize"),
        dictgen::InsensitiveAscii("ized"),
        dictgen::InsensitiveAscii("izer"),
        dictgen::InsensitiveAscii("izers"),
        dictgen::InsensitiveAscii("izes"),
        dictgen::InsensitiveAscii("izing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_COLONIZATION_5170205300413493772)],
        &[(0b10010, &ENTRY_COLONIZATIONS_5914393406246107629)],
        &[(0b10010, &ENTRY_COLONIZE_15736921118583985460)],
        &[(0b10010, &ENTRY_COLONIZED_1613678129917812032)],
        &[(0b10010, &ENTRY_COLONIZER_12757929901281569170)],
        &[(0b10010, &ENTRY_COLONIZERS_8168468522547534282)],
        &[(0b10010, &ENTRY_COLONIZES_12944167433051970340)],
        &[(0b10010, &ENTRY_COLONIZING_10333921368822957164)],
        &[(0b01001, &ENTRY_COLONIZATION_5170205300413493772)],
        &[(0b01001, &ENTRY_COLONIZATIONS_5914393406246107629)],
        &[(0b01001, &ENTRY_COLONIZE_15736921118583985460)],
        &[(0b01001, &ENTRY_COLONIZED_1613678129917812032)],
        &[(0b01001, &ENTRY_COLONIZER_12757929901281569170)],
        &[(0b01001, &ENTRY_COLONIZERS_8168468522547534282)],
        &[(0b01001, &ENTRY_COLONIZES_12944167433051970340)],
        &[(0b01001, &ENTRY_COLONIZING_10333921368822957164)],
    ],
    range: 3..=8,
};

static VARS_COLL_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_COLL_CHILDREN),
    value: None,
};

pub static VARS_COLL_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ectable"),
        dictgen::InsensitiveAscii("ectables"),
        dictgen::InsensitiveAscii("ectivisation"),
        dictgen::InsensitiveAscii("ectivisations"),
        dictgen::InsensitiveAscii("ectivise"),
        dictgen::InsensitiveAscii("ectivised"),
        dictgen::InsensitiveAscii("ectivises"),
        dictgen::InsensitiveAscii("ectivising"),
        dictgen::InsensitiveAscii("ectivization"),
        dictgen::InsensitiveAscii("ectivizations"),
        dictgen::InsensitiveAscii("ectivize"),
        dictgen::InsensitiveAscii("ectivized"),
        dictgen::InsensitiveAscii("ectivizes"),
        dictgen::InsensitiveAscii("ectivizing"),
    ],
    values: &[
        &[(0b10011, &ENTRY_COLLECTIBLE_1730285011498072035)],
        &[(0b10011, &ENTRY_COLLECTIBLES_7358720680663200346)],
        &[(0b10010, &ENTRY_COLLECTIVIZATION_1362380877833359975)],
        &[(0b10010, &ENTRY_COLLECTIVIZATIONS_6195427118788754823)],
        &[(0b10010, &ENTRY_COLLECTIVIZE_12809074466084828054)],
        &[(0b10010, &ENTRY_COLLECTIVIZED_6132833186626165249)],
        &[(0b10010, &ENTRY_COLLECTIVIZES_10627545540156031817)],
        &[(0b10010, &ENTRY_COLLECTIVIZING_7798244009757756216)],
        &[(0b01001, &ENTRY_COLLECTIVIZATION_1362380877833359975)],
        &[(0b01001, &ENTRY_COLLECTIVIZATIONS_6195427118788754823)],
        &[(0b01001, &ENTRY_COLLECTIVIZE_12809074466084828054)],
        &[(0b01001, &ENTRY_COLLECTIVIZED_6132833186626165249)],
        &[(0b01001, &ENTRY_COLLECTIVIZES_10627545540156031817)],
        &[(0b01001, &ENTRY_COLLECTIVIZING_7798244009757756216)],
    ],
    range: 7..=13,
};

static VARS_COG_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_COG_CHILDREN),
    value: None,
};

pub static VARS_COG_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("nisable"),
        dictgen::InsensitiveAscii("nisabler"),
        dictgen::InsensitiveAscii("nisablest"),
        dictgen::InsensitiveAscii("nisance"),
        dictgen::InsensitiveAscii("nisances"),
        dictgen::InsensitiveAscii("nisant"),
        dictgen::InsensitiveAscii("nisanter"),
        dictgen::InsensitiveAscii("nisantest"),
        dictgen::InsensitiveAscii("nizable"),
        dictgen::InsensitiveAscii("nizabler"),
        dictgen::InsensitiveAscii("nizablest"),
        dictgen::InsensitiveAscii("nizance"),
        dictgen::InsensitiveAscii("nizances"),
        dictgen::InsensitiveAscii("nizant"),
        dictgen::InsensitiveAscii("nizanter"),
        dictgen::InsensitiveAscii("nizantest"),
    ],
    values: &[
        &[(0b10010, &ENTRY_COGNIZABLE_17452455676169531153)],
        &[(0b10010, &ENTRY_COGNIZABLER_15866973125677355856)],
        &[(0b10010, &ENTRY_COGNIZABLEST_2508940668012161280)],
        &[(0b10010, &ENTRY_COGNIZANCE_16406744570348652654)],
        &[(0b10010, &ENTRY_COGNIZANCES_278004122060158781)],
        &[(0b10010, &ENTRY_COGNIZANT_8482318087824381990)],
        &[(0b10010, &ENTRY_COGNIZANTER_1642202493657548366)],
        &[(0b10010, &ENTRY_COGNIZANTEST_2041114456387040574)],
        &[(0b01001, &ENTRY_COGNIZABLE_17452455676169531153)],
        &[(0b01001, &ENTRY_COGNIZABLER_15866973125677355856)],
        &[(0b01001, &ENTRY_COGNIZABLEST_2508940668012161280)],
        &[(0b01001, &ENTRY_COGNIZANCE_16406744570348652654)],
        &[(0b01001, &ENTRY_COGNIZANCES_278004122060158781)],
        &[(0b01001, &ENTRY_COGNIZANT_8482318087824381990)],
        &[(0b01001, &ENTRY_COGNIZANTER_1642202493657548366)],
        &[(0b01001, &ENTRY_COGNIZANTEST_2041114456387040574)],
    ],
    range: 6..=9,
};

static VARS_COE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_COE_CHILDREN),
    value: None,
};

pub static VARS_COE_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("lom"),
        dictgen::InsensitiveAscii("lomata"),
        dictgen::InsensitiveAscii("loms"),
        dictgen::InsensitiveAscii("nobite"),
        dictgen::InsensitiveAscii("nobites"),
        dictgen::InsensitiveAscii("nobitic"),
        dictgen::InsensitiveAscii("nobitical"),
    ],
    values: &[
        &[(0b11010, &ENTRY_CELOM_6954296651788090066)],
        &[(0b00010, &ENTRY_CELOMS_4896390401945145201)],
        &[(0b11010, &ENTRY_CELOMS_4896390401945145201)],
        &[(0b11010, &ENTRY_CENOBITE_3238719954758957076)],
        &[(0b11010, &ENTRY_CENOBITES_13837713854551690629)],
        &[(0b11010, &ENTRY_CENOBITIC_14473057480801204596)],
        &[(0b11010, &ENTRY_CENOBITICAL_6881474597185636655)],
    ],
    range: 3..=9,
};

static VARS_CL_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_CL_CHILDREN),
    value: None,
};

pub static VARS_CL_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("amor"),
        dictgen::InsensitiveAscii("amored"),
        dictgen::InsensitiveAscii("amoring"),
        dictgen::InsensitiveAscii("amors"),
        dictgen::InsensitiveAscii("amour"),
        dictgen::InsensitiveAscii("amoured"),
        dictgen::InsensitiveAscii("amouring"),
        dictgen::InsensitiveAscii("amours"),
        dictgen::InsensitiveAscii("angor"),
        dictgen::InsensitiveAscii("angored"),
        dictgen::InsensitiveAscii("angoring"),
        dictgen::InsensitiveAscii("angors"),
        dictgen::InsensitiveAscii("angour"),
        dictgen::InsensitiveAscii("angoured"),
        dictgen::InsensitiveAscii("angouring"),
        dictgen::InsensitiveAscii("angours"),
        dictgen::InsensitiveAscii("arinetist"),
        dictgen::InsensitiveAscii("arinetists"),
        dictgen::InsensitiveAscii("arinettist"),
        dictgen::InsensitiveAscii("arinettists"),
        dictgen::InsensitiveAscii("assicise"),
        dictgen::InsensitiveAscii("assicised"),
        dictgen::InsensitiveAscii("assicises"),
        dictgen::InsensitiveAscii("assicising"),
        dictgen::InsensitiveAscii("assicize"),
        dictgen::InsensitiveAscii("assicized"),
        dictgen::InsensitiveAscii("assicizes"),
        dictgen::InsensitiveAscii("assicizing"),
    ],
    values: &[
        &[(0b11001, &ENTRY_CLAMOR_5158185862304229945)],
        &[(0b11001, &ENTRY_CLAMORED_2092729859202254484)],
        &[(0b11001, &ENTRY_CLAMORING_17170493137896914728)],
        &[(0b11001, &ENTRY_CLAMORS_12585789829012154512)],
        &[(0b11010, &ENTRY_CLAMOR_5158185862304229945)],
        &[(0b11010, &ENTRY_CLAMORED_2092729859202254484)],
        &[(0b11010, &ENTRY_CLAMORING_17170493137896914728)],
        &[(0b11010, &ENTRY_CLAMORS_12585789829012154512)],
        &[(0b11001, &ENTRY_CLANGOR_11068622204017638397)],
        &[(0b11001, &ENTRY_CLANGORED_4896068625903464560)],
        &[(0b11001, &ENTRY_CLANGORING_2067393512241593148)],
        &[(0b11001, &ENTRY_CLANGORS_9815521559387015927)],
        &[(0b11010, &ENTRY_CLANGOR_11068622204017638397)],
        &[(0b11010, &ENTRY_CLANGORED_4896068625903464560)],
        &[(0b11010, &ENTRY_CLANGORING_2067393512241593148)],
        &[(0b11010, &ENTRY_CLANGORS_9815521559387015927)],
        &[(0b01001, &ENTRY_CLARINETIST_10300531156065359462)],
        &[(0b01001, &ENTRY_CLARINETISTS_6735422107420159102)],
        &[(0b10011, &ENTRY_CLARINETIST_10300531156065359462)],
        &[(0b10011, &ENTRY_CLARINETISTS_6735422107420159102)],
        &[(0b10010, &ENTRY_CLASSICIZE_6173596440580862000)],
        &[(0b10010, &ENTRY_CLASSICIZED_1424459898101384526)],
        &[(0b10010, &ENTRY_CLASSICIZES_5416184573508461528)],
        &[(0b10010, &ENTRY_CLASSICIZING_7645297896587290775)],
        &[(0b01001, &ENTRY_CLASSICIZE_6173596440580862000)],
        &[(0b01001, &ENTRY_CLASSICIZED_1424459898101384526)],
        &[(0b01001, &ENTRY_CLASSICIZES_5416184573508461528)],
        &[(0b01001, &ENTRY_CLASSICIZING_7645297896587290775)],
    ],
    range: 4..=11,
};

static VARS_CI_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_CI_CHILDREN),
    value: None,
};

pub static VARS_CI_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("catrisation"),
        dictgen::InsensitiveAscii("catrisations"),
        dictgen::InsensitiveAscii("catrise"),
        dictgen::InsensitiveAscii("catrised"),
        dictgen::InsensitiveAscii("catrises"),
        dictgen::InsensitiveAscii("catrising"),
        dictgen::InsensitiveAscii("catrixes"),
        dictgen::InsensitiveAscii("catrization"),
        dictgen::InsensitiveAscii("catrizations"),
        dictgen::InsensitiveAscii("catrize"),
        dictgen::InsensitiveAscii("catrized"),
        dictgen::InsensitiveAscii("catrizes"),
        dictgen::InsensitiveAscii("catrizing"),
        dictgen::InsensitiveAscii("garet"),
        dictgen::InsensitiveAscii("garets"),
        dictgen::InsensitiveAscii("vilisation"),
        dictgen::InsensitiveAscii("vilisations"),
        dictgen::InsensitiveAscii("vilise"),
        dictgen::InsensitiveAscii("vilised"),
        dictgen::InsensitiveAscii("viliser"),
        dictgen::InsensitiveAscii("vilisers"),
        dictgen::InsensitiveAscii("vilises"),
        dictgen::InsensitiveAscii("vilising"),
        dictgen::InsensitiveAscii("vilization"),
        dictgen::InsensitiveAscii("vilizations"),
        dictgen::InsensitiveAscii("vilize"),
        dictgen::InsensitiveAscii("vilized"),
        dictgen::InsensitiveAscii("vilizer"),
        dictgen::InsensitiveAscii("vilizers"),
        dictgen::InsensitiveAscii("vilizes"),
        dictgen::InsensitiveAscii("vilizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_CICATRIZATION_9264802001449770315)],
        &[(0b10010, &ENTRY_CICATRIZATIONS_6401479390305959155)],
        &[(0b10010, &ENTRY_CICATRIZE_10818694238612969910)],
        &[(0b10010, &ENTRY_CICATRIZED_1828890261939464598)],
        &[(0b10010, &ENTRY_CICATRIZES_10804914940535295994)],
        &[(0b10010, &ENTRY_CICATRIZING_2146572731064124559)],
        &[(0b00001, &ENTRY_CICATRICES_17574423838445240061)],
        &[(0b01001, &ENTRY_CICATRIZATION_9264802001449770315)],
        &[(0b01001, &ENTRY_CICATRIZATIONS_6401479390305959155)],
        &[(0b01001, &ENTRY_CICATRIZE_10818694238612969910)],
        &[(0b01001, &ENTRY_CICATRIZED_1828890261939464598)],
        &[(0b01001, &ENTRY_CICATRIZES_10804914940535295994)],
        &[(0b01001, &ENTRY_CICATRIZING_2146572731064124559)],
        &[(0b00001, &ENTRY_CIGARETTE_5420991040189256779)],
        &[(0b00001, &ENTRY_CIGARETTES_16419249441518698267)],
        &[(0b10010, &ENTRY_CIVILIZATION_15411020791056209676)],
        &[(0b10010, &ENTRY_CIVILIZATIONS_8013365541301592457)],
        &[(0b10010, &ENTRY_CIVILIZE_16590332670644302211)],
        &[(0b10010, &ENTRY_CIVILIZED_8223404244720114957)],
        &[(0b10010, &ENTRY_CIVILIZER_8024073242072515118)],
        &[(0b10010, &ENTRY_CIVILIZERS_3015830727153297093)],
        &[(0b10010, &ENTRY_CIVILIZES_9333851959553393399)],
        &[(0b10010, &ENTRY_CIVILIZING_17372507961283340052)],
        &[(0b01001, &ENTRY_CIVILIZATION_15411020791056209676)],
        &[(0b01001, &ENTRY_CIVILIZATIONS_8013365541301592457)],
        &[(0b01001, &ENTRY_CIVILIZE_16590332670644302211)],
        &[(0b01001, &ENTRY_CIVILIZED_8223404244720114957)],
        &[(0b01001, &ENTRY_CIVILIZER_8024073242072515118)],
        &[(0b01001, &ENTRY_CIVILIZERS_3015830727153297093)],
        &[(0b01001, &ENTRY_CIVILIZES_9333851959553393399)],
        &[(0b01001, &ENTRY_CIVILIZING_17372507961283340052)],
    ],
    range: 5..=12,
};

static VARS_CH_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_CH_CHILDREN),
    value: None,
};

static VARS_CH_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_CHA_NODE),
    None,
    None,
    None,
    Some(&VARS_CHE_NODE),
    None,
    None,
    None,
    Some(&VARS_CHI_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_CHR_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_CHR_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_CHR_CHILDREN),
    value: None,
};

pub static VARS_CHR_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("istianisation"),
        dictgen::InsensitiveAscii("istianisations"),
        dictgen::InsensitiveAscii("istianise"),
        dictgen::InsensitiveAscii("istianised"),
        dictgen::InsensitiveAscii("istianises"),
        dictgen::InsensitiveAscii("istianising"),
        dictgen::InsensitiveAscii("istianization"),
        dictgen::InsensitiveAscii("istianizations"),
        dictgen::InsensitiveAscii("istianize"),
        dictgen::InsensitiveAscii("istianized"),
        dictgen::InsensitiveAscii("istianizes"),
        dictgen::InsensitiveAscii("istianizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_CHRISTIANIZATION_11631799398993571501)],
        &[(0b10010, &ENTRY_CHRISTIANIZATIONS_16703091698980017207)],
        &[(0b10010, &ENTRY_CHRISTIANIZE_15479599846963049140)],
        &[(0b10010, &ENTRY_CHRISTIANIZED_14623745351432413209)],
        &[(0b10010, &ENTRY_CHRISTIANIZES_5529854457085699383)],
        &[(0b10010, &ENTRY_CHRISTIANIZING_18179844943674675649)],
        &[(0b01001, &ENTRY_CHRISTIANIZATION_11631799398993571501)],
        &[(0b01001, &ENTRY_CHRISTIANIZATIONS_16703091698980017207)],
        &[(0b01001, &ENTRY_CHRISTIANIZE_15479599846963049140)],
        &[(0b01001, &ENTRY_CHRISTIANIZED_14623745351432413209)],
        &[(0b01001, &ENTRY_CHRISTIANIZES_5529854457085699383)],
        &[(0b01001, &ENTRY_CHRISTIANIZING_18179844943674675649)],
    ],
    range: 9..=14,
};

static VARS_CHI_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_CHI_CHILDREN),
    value: None,
};

pub static VARS_CHI_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("le"),
        dictgen::InsensitiveAscii("les"),
        dictgen::InsensitiveAscii("li"),
        dictgen::InsensitiveAscii("lies"),
        dictgen::InsensitiveAscii("lis"),
        dictgen::InsensitiveAscii("lli"),
        dictgen::InsensitiveAscii("llies"),
        dictgen::InsensitiveAscii("seled"),
        dictgen::InsensitiveAscii("seler"),
        dictgen::InsensitiveAscii("selers"),
        dictgen::InsensitiveAscii("seling"),
    ],
    values: &[
        &[(0b01001, &ENTRY_CHILI_8746464747530279303)],
        &[(0b01001, &ENTRY_CHILIES_17046197863582163056)],
        &[(0b01001, &ENTRY_CHILI_8746464747530279303)],
        &[(0b01001, &ENTRY_CHILIES_17046197863582163056)],
        &[(0b00001, &ENTRY_CHILIES_17046197863582163056)],
        &[(0b10011, &ENTRY_CHILI_8746464747530279303)],
        &[(0b10011, &ENTRY_CHILIES_17046197863582163056)],
        &[(0b00001, &ENTRY_CHISELED_15546949667254573790)],
        &[(0b00001, &ENTRY_CHISELER_1587603412683173146)],
        &[(0b00001, &ENTRY_CHISELERS_13598630043321083893)],
        &[(0b00001, &ENTRY_CHISELING_4623966446629021871)],
    ],
    range: 2..=6,
};

static VARS_CHE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_CHE_CHILDREN),
    value: None,
};

pub static VARS_CHE_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ckbook"),
        dictgen::InsensitiveAscii("ckbooks"),
        dictgen::InsensitiveAscii("ckerboard"),
        dictgen::InsensitiveAscii("ckerboards"),
        dictgen::InsensitiveAscii("ckered"),
        dictgen::InsensitiveAscii("ckering"),
        dictgen::InsensitiveAscii("que"),
        dictgen::InsensitiveAscii("quebook"),
        dictgen::InsensitiveAscii("quebooks"),
        dictgen::InsensitiveAscii("qued"),
        dictgen::InsensitiveAscii("quer"),
        dictgen::InsensitiveAscii("querboard"),
        dictgen::InsensitiveAscii("querboards"),
        dictgen::InsensitiveAscii("quered"),
        dictgen::InsensitiveAscii("quering"),
        dictgen::InsensitiveAscii("quers"),
        dictgen::InsensitiveAscii("ques"),
        dictgen::InsensitiveAscii("quing"),
    ],
    values: &[
        &[(0b00001, &ENTRY_CHECKBOOK_1836353332372798027)],
        &[(0b00001, &ENTRY_CHECKBOOKS_17373327628350162625)],
        &[(0b00001, &ENTRY_CHECKERBOARD_16789724192435672675)],
        &[(0b00001, &ENTRY_CHECKERBOARDS_4609233615704287762)],
        &[(0b01001, &ENTRY_CHECKERED_9945873716414107297)],
        &[(0b01001, &ENTRY_CHECKERING_4080085454000431870)],
        &[(0b11010, &ENTRY_CHECK_9710872025351452895)],
        &[(0b11010, &ENTRY_CHECKBOOK_1836353332372798027)],
        &[(0b11010, &ENTRY_CHECKBOOKS_17373327628350162625)],
        &[(0b11010, &ENTRY_CHECKED_9204677386650577893)],
        &[(0b11010, &ENTRY_CHECKER_15996220430790986329)],
        &[(0b11010, &ENTRY_CHECKERBOARD_16789724192435672675)],
        &[(0b11010, &ENTRY_CHECKERBOARDS_4609233615704287762)],
        &[(0b11010, &ENTRY_CHECKERED_9945873716414107297)],
        &[(0b11010, &ENTRY_CHECKERING_4080085454000431870)],
        &[(0b11010, &ENTRY_CHECKERS_10330904262647298958)],
        &[(0b11010, &ENTRY_CHECKS_2013661607139878581)],
        &[(0b11010, &ENTRY_CHECKING_12809623155680137187)],
    ],
    range: 3..=10,
};

static VARS_CHA_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_CHA_CHILDREN),
    value: None,
};

pub static VARS_CHA_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("nneled"),
        dictgen::InsensitiveAscii("nneling"),
        dictgen::InsensitiveAscii("nnelise"),
        dictgen::InsensitiveAscii("nnelised"),
        dictgen::InsensitiveAscii("nnelises"),
        dictgen::InsensitiveAscii("nnelising"),
        dictgen::InsensitiveAscii("nnelize"),
        dictgen::InsensitiveAscii("nnelized"),
        dictgen::InsensitiveAscii("nnelizes"),
        dictgen::InsensitiveAscii("nnelizing"),
        dictgen::InsensitiveAscii("nnelled"),
        dictgen::InsensitiveAscii("nnelling"),
        dictgen::InsensitiveAscii("racterisation"),
        dictgen::InsensitiveAscii("racterisations"),
        dictgen::InsensitiveAscii("racterise"),
        dictgen::InsensitiveAscii("racterised"),
        dictgen::InsensitiveAscii("racterises"),
        dictgen::InsensitiveAscii("racterising"),
        dictgen::InsensitiveAscii("racterization"),
        dictgen::InsensitiveAscii("racterizations"),
        dictgen::InsensitiveAscii("racterize"),
        dictgen::InsensitiveAscii("racterized"),
        dictgen::InsensitiveAscii("racterizes"),
        dictgen::InsensitiveAscii("racterizing"),
    ],
    values: &[
        &[(0b00001, &ENTRY_CHANNELED_3884192849125819469)],
        &[(0b00001, &ENTRY_CHANNELING_4768505129233237962)],
        &[(0b10010, &ENTRY_CHANNELIZE_9103946204000221039)],
        &[(0b10010, &ENTRY_CHANNELIZED_5449663681030349216)],
        &[(0b10010, &ENTRY_CHANNELIZES_8130546736139303129)],
        &[(0b10010, &ENTRY_CHANNELIZING_6754708663381850003)],
        &[(0b01001, &ENTRY_CHANNELIZE_9103946204000221039)],
        &[(0b01001, &ENTRY_CHANNELIZED_5449663681030349216)],
        &[(0b01001, &ENTRY_CHANNELIZES_8130546736139303129)],
        &[(0b01001, &ENTRY_CHANNELIZING_6754708663381850003)],
        &[(0b11010, &ENTRY_CHANNELED_3884192849125819469)],
        &[(0b11010, &ENTRY_CHANNELING_4768505129233237962)],
        &[(0b10010, &ENTRY_CHARACTERIZATION_11550110625481177338)],
        &[(0b10010, &ENTRY_CHARACTERIZATIONS_13277352132965580301)],
        &[(0b10010, &ENTRY_CHARACTERIZE_14637565961485771135)],
        &[(0b10010, &ENTRY_CHARACTERIZED_17817519055123408875)],
        &[(0b10010, &ENTRY_CHARACTERIZES_14017907572178871492)],
        &[(0b10010, &ENTRY_CHARACTERIZING_15152517398466769326)],
        &[(0b01001, &ENTRY_CHARACTERIZATION_11550110625481177338)],
        &[(0b01001, &ENTRY_CHARACTERIZATIONS_13277352132965580301)],
        &[(0b01001, &ENTRY_CHARACTERIZE_14637565961485771135)],
        &[(0b01001, &ENTRY_CHARACTERIZED_17817519055123408875)],
        &[(0b01001, &ENTRY_CHARACTERIZES_14017907572178871492)],
        &[(0b01001, &ENTRY_CHARACTERIZING_15152517398466769326)],
    ],
    range: 6..=14,
};

static VARS_CE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_CE_CHILDREN),
    value: None,
};

pub static VARS_CE_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("lom"),
        dictgen::InsensitiveAscii("loms"),
        dictgen::InsensitiveAscii("nter"),
        dictgen::InsensitiveAscii("nterboard"),
        dictgen::InsensitiveAscii("nterboards"),
        dictgen::InsensitiveAscii("ntered"),
        dictgen::InsensitiveAscii("nterfold"),
        dictgen::InsensitiveAscii("nterfolds"),
        dictgen::InsensitiveAscii("ntering"),
        dictgen::InsensitiveAscii("nterings"),
        dictgen::InsensitiveAscii("nterpiece"),
        dictgen::InsensitiveAscii("nterpieces"),
        dictgen::InsensitiveAscii("nters"),
        dictgen::InsensitiveAscii("ntigramme"),
        dictgen::InsensitiveAscii("ntigrammes"),
        dictgen::InsensitiveAscii("ntiliter"),
        dictgen::InsensitiveAscii("ntiliters"),
        dictgen::InsensitiveAscii("ntilitre"),
        dictgen::InsensitiveAscii("ntilitres"),
        dictgen::InsensitiveAscii("ntimeter"),
        dictgen::InsensitiveAscii("ntimeters"),
        dictgen::InsensitiveAscii("ntimetre"),
        dictgen::InsensitiveAscii("ntimetres"),
        dictgen::InsensitiveAscii("ntralisation"),
        dictgen::InsensitiveAscii("ntralisations"),
        dictgen::InsensitiveAscii("ntralise"),
        dictgen::InsensitiveAscii("ntralised"),
        dictgen::InsensitiveAscii("ntralises"),
        dictgen::InsensitiveAscii("ntralising"),
        dictgen::InsensitiveAscii("ntralization"),
        dictgen::InsensitiveAscii("ntralizations"),
        dictgen::InsensitiveAscii("ntralize"),
        dictgen::InsensitiveAscii("ntralized"),
        dictgen::InsensitiveAscii("ntralizes"),
        dictgen::InsensitiveAscii("ntralizing"),
        dictgen::InsensitiveAscii("ntre"),
        dictgen::InsensitiveAscii("ntreboard"),
        dictgen::InsensitiveAscii("ntreboards"),
        dictgen::InsensitiveAscii("ntred"),
        dictgen::InsensitiveAscii("ntrefold"),
        dictgen::InsensitiveAscii("ntrefolds"),
        dictgen::InsensitiveAscii("ntrepiece"),
        dictgen::InsensitiveAscii("ntrepieces"),
        dictgen::InsensitiveAscii("ntres"),
        dictgen::InsensitiveAscii("ntring"),
        dictgen::InsensitiveAscii("ntrings"),
        dictgen::InsensitiveAscii("sium"),
        dictgen::InsensitiveAscii("siums"),
        dictgen::InsensitiveAscii("sural"),
    ],
    values: &[
        &[(0b11001, &ENTRY_CELOM_6954296651788090066)],
        &[(0b11001, &ENTRY_CELOMS_4896390401945145201)],
        &[(0b01001, &ENTRY_CENTER_2062827205925125611)],
        &[(0b00001, &ENTRY_CENTERBOARD_12936059728076156984)],
        &[(0b00001, &ENTRY_CENTERBOARDS_8162665466509661850)],
        &[(0b01001, &ENTRY_CENTERED_15927189749167280073)],
        &[(0b00001, &ENTRY_CENTERFOLD_13964837998835453817)],
        &[(0b00001, &ENTRY_CENTERFOLDS_6987098084704804029)],
        &[(0b01001, &ENTRY_CENTERING_12678821431832397053)],
        &[(0b01001, &ENTRY_CENTERINGS_14821164417176031250)],
        &[(0b00001, &ENTRY_CENTERPIECE_8959571131813824904)],
        &[(0b00001, &ENTRY_CENTERPIECES_9003602563873687762)],
        &[(0b01001, &ENTRY_CENTERS_3653356479744194617)],
        &[(0b10010, &ENTRY_CENTIGRAM_16369133942610299137)],
        &[(0b10010, &ENTRY_CENTIGRAMS_4446712383280702017)],
        &[(0b00001, &ENTRY_CENTILITER_5486758117872326030)],
        &[(0b00001, &ENTRY_CENTILITERS_1152239446012655040)],
        &[(0b11010, &ENTRY_CENTILITER_5486758117872326030)],
        &[(0b11010, &ENTRY_CENTILITERS_1152239446012655040)],
        &[(0b01001, &ENTRY_CENTIMETER_16919893077343778486)],
        &[(0b01001, &ENTRY_CENTIMETERS_2488768602472487806)],
        &[(0b11010, &ENTRY_CENTIMETER_16919893077343778486)],
        &[(0b11010, &ENTRY_CENTIMETERS_2488768602472487806)],
        &[(0b10010, &ENTRY_CENTRALIZATION_14489606925183485682)],
        &[(0b10010, &ENTRY_CENTRALIZATIONS_14077284492075609276)],
        &[(0b10010, &ENTRY_CENTRALIZE_3598052449531879733)],
        &[(0b10010, &ENTRY_CENTRALIZED_11571044202801829690)],
        &[(0b10010, &ENTRY_CENTRALIZES_13364036337997133322)],
        &[(0b10010, &ENTRY_CENTRALIZING_16563092158705447235)],
        &[(0b01001, &ENTRY_CENTRALIZATION_14489606925183485682)],
        &[(0b01001, &ENTRY_CENTRALIZATIONS_14077284492075609276)],
        &[(0b01001, &ENTRY_CENTRALIZE_3598052449531879733)],
        &[(0b01001, &ENTRY_CENTRALIZED_11571044202801829690)],
        &[(0b01001, &ENTRY_CENTRALIZES_13364036337997133322)],
        &[(0b01001, &ENTRY_CENTRALIZING_16563092158705447235)],
        &[(0b11010, &ENTRY_CENTER_2062827205925125611)],
        &[(0b11010, &ENTRY_CENTERBOARD_12936059728076156984)],
        &[(0b11010, &ENTRY_CENTERBOARDS_8162665466509661850)],
        &[(0b11010, &ENTRY_CENTERED_15927189749167280073)],
        &[(0b11010, &ENTRY_CENTERFOLD_13964837998835453817)],
        &[(0b11010, &ENTRY_CENTERFOLDS_6987098084704804029)],
        &[(0b11010, &ENTRY_CENTERPIECE_8959571131813824904)],
        &[(0b11010, &ENTRY_CENTERPIECES_9003602563873687762)],
        &[(0b11010, &ENTRY_CENTERS_3653356479744194617)],
        &[(0b11010, &ENTRY_CENTERING_12678821431832397053)],
        &[(0b11010, &ENTRY_CENTERINGS_14821164417176031250)],
        &[(0b11001, &ENTRY_CESIUM_14697098024822079251)],
        &[(0b11001, &ENTRY_CESIUMS_6672725677512073080)],
        &[(0b10001, &ENTRY_CESURAL_6753528217264809955)],
    ],
    range: 3..=13,
};

static VARS_CA_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_CA_CHILDREN),
    value: None,
};

static VARS_CA_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    None,
    None,
    Some(&VARS_CAE_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_CAL_NODE),
    None,
    Some(&VARS_CAN_NODE),
    None,
    Some(&VARS_CAP_NODE),
    None,
    Some(&VARS_CAR_NODE),
    None,
    Some(&VARS_CAT_NODE),
    Some(&VARS_CAU_NODE),
    Some(&VARS_CAV_NODE),
    None,
    None,
    None,
    None,
];

static VARS_CAV_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_CAV_CHILDREN),
    value: None,
};

pub static VARS_CAV_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("iare"),
        dictgen::InsensitiveAscii("iares"),
        dictgen::InsensitiveAscii("iled"),
        dictgen::InsensitiveAscii("iler"),
        dictgen::InsensitiveAscii("ilers"),
        dictgen::InsensitiveAscii("iling"),
        dictgen::InsensitiveAscii("ilings"),
        dictgen::InsensitiveAscii("illed"),
        dictgen::InsensitiveAscii("iller"),
        dictgen::InsensitiveAscii("illers"),
        dictgen::InsensitiveAscii("illing"),
        dictgen::InsensitiveAscii("illings"),
    ],
    values: &[
        &[(0b10011, &ENTRY_CAVIAR_13293796828806890873)],
        &[(0b10011, &ENTRY_CAVIARS_11505002019485473608)],
        &[(0b01001, &ENTRY_CAVILED_11192889244066147526)],
        &[(0b00001, &ENTRY_CAVILER_9496917240731757934)],
        &[(0b00001, &ENTRY_CAVILERS_12077868647577851396)],
        &[(0b01001, &ENTRY_CAVILING_17734305391918802240)],
        &[(0b01001, &ENTRY_CAVILINGS_2004720957308004113)],
        &[(0b11010, &ENTRY_CAVILED_11192889244066147526)],
        &[(0b11010, &ENTRY_CAVILER_9496917240731757934)],
        &[(0b11010, &ENTRY_CAVILERS_12077868647577851396)],
        &[(0b11010, &ENTRY_CAVILING_17734305391918802240)],
        &[(0b11010, &ENTRY_CAVILINGS_2004720957308004113)],
    ],
    range: 4..=7,
};

static VARS_CAU_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_CAU_CHILDREN),
    value: None,
};

pub static VARS_CAU_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("terisation"),
        dictgen::InsensitiveAscii("terisations"),
        dictgen::InsensitiveAscii("terise"),
        dictgen::InsensitiveAscii("terised"),
        dictgen::InsensitiveAscii("terises"),
        dictgen::InsensitiveAscii("terising"),
        dictgen::InsensitiveAscii("terization"),
        dictgen::InsensitiveAscii("terizations"),
        dictgen::InsensitiveAscii("terize"),
        dictgen::InsensitiveAscii("terized"),
        dictgen::InsensitiveAscii("terizes"),
        dictgen::InsensitiveAscii("terizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_CAUTERIZATION_11314889126154078843)],
        &[(0b10010, &ENTRY_CAUTERIZATIONS_4890341307628816522)],
        &[(0b10010, &ENTRY_CAUTERIZE_11145047639262148996)],
        &[(0b10010, &ENTRY_CAUTERIZED_12118160833980913736)],
        &[(0b10010, &ENTRY_CAUTERIZES_17337688368809469148)],
        &[(0b10010, &ENTRY_CAUTERIZING_14426485505826676009)],
        &[(0b01001, &ENTRY_CAUTERIZATION_11314889126154078843)],
        &[(0b01001, &ENTRY_CAUTERIZATIONS_4890341307628816522)],
        &[(0b01001, &ENTRY_CAUTERIZE_11145047639262148996)],
        &[(0b01001, &ENTRY_CAUTERIZED_12118160833980913736)],
        &[(0b01001, &ENTRY_CAUTERIZES_17337688368809469148)],
        &[(0b01001, &ENTRY_CAUTERIZING_14426485505826676009)],
    ],
    range: 6..=11,
};

static VARS_CAT_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_CAT_CHILDREN),
    value: None,
};

pub static VARS_CAT_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("alog"),
        dictgen::InsensitiveAscii("aloged"),
        dictgen::InsensitiveAscii("aloger"),
        dictgen::InsensitiveAscii("alogers"),
        dictgen::InsensitiveAscii("aloging"),
        dictgen::InsensitiveAscii("alogs"),
        dictgen::InsensitiveAscii("aloguer"),
        dictgen::InsensitiveAscii("aloguers"),
        dictgen::InsensitiveAscii("alyse"),
        dictgen::InsensitiveAscii("alysed"),
        dictgen::InsensitiveAscii("alysing"),
        dictgen::InsensitiveAscii("alyze"),
        dictgen::InsensitiveAscii("alyzed"),
        dictgen::InsensitiveAscii("alyzes"),
        dictgen::InsensitiveAscii("alyzing"),
        dictgen::InsensitiveAscii("echise"),
        dictgen::InsensitiveAscii("echised"),
        dictgen::InsensitiveAscii("echiser"),
        dictgen::InsensitiveAscii("echisers"),
        dictgen::InsensitiveAscii("echises"),
        dictgen::InsensitiveAscii("echising"),
        dictgen::InsensitiveAscii("echisings"),
        dictgen::InsensitiveAscii("echize"),
        dictgen::InsensitiveAscii("echized"),
        dictgen::InsensitiveAscii("echizer"),
        dictgen::InsensitiveAscii("echizers"),
        dictgen::InsensitiveAscii("echizes"),
        dictgen::InsensitiveAscii("echizing"),
        dictgen::InsensitiveAscii("echizings"),
        dictgen::InsensitiveAscii("egorisation"),
        dictgen::InsensitiveAscii("egorisations"),
        dictgen::InsensitiveAscii("egorise"),
        dictgen::InsensitiveAscii("egorised"),
        dictgen::InsensitiveAscii("egorises"),
        dictgen::InsensitiveAscii("egorising"),
        dictgen::InsensitiveAscii("egorization"),
        dictgen::InsensitiveAscii("egorizations"),
        dictgen::InsensitiveAscii("egorize"),
        dictgen::InsensitiveAscii("egorized"),
        dictgen::InsensitiveAscii("egorizes"),
        dictgen::InsensitiveAscii("egorizing"),
        dictgen::InsensitiveAscii("heterisation"),
        dictgen::InsensitiveAscii("heterisations"),
        dictgen::InsensitiveAscii("heterise"),
        dictgen::InsensitiveAscii("heterised"),
        dictgen::InsensitiveAscii("heterises"),
        dictgen::InsensitiveAscii("heterising"),
        dictgen::InsensitiveAscii("heterization"),
        dictgen::InsensitiveAscii("heterizations"),
        dictgen::InsensitiveAscii("heterize"),
        dictgen::InsensitiveAscii("heterized"),
        dictgen::InsensitiveAscii("heterizes"),
        dictgen::InsensitiveAscii("heterizing"),
    ],
    values: &[
        &[(0b00001, &ENTRY_CATALOG_565730177416789533)],
        &[(0b00001, &ENTRY_CATALOGED_13847517650261824048)],
        &[(0b00001, &ENTRY_CATALOGER_17511688898877974998)],
        &[(0b00001, &ENTRY_CATALOGERS_4685828953878934730)],
        &[(0b00001, &ENTRY_CATALOGING_9488455222365923997)],
        &[(0b00001, &ENTRY_CATALOGS_5196696314182792455)],
        &[(0b11010, &ENTRY_CATALOGER_17511688898877974998)],
        &[(0b11010, &ENTRY_CATALOGERS_4685828953878934730)],
        &[(0b11010, &ENTRY_CATALYZE_5340148730721059753)],
        &[(0b11010, &ENTRY_CATALYZED_18179839917863952435)],
        &[(0b11010, &ENTRY_CATALYZING_13540847378063734907)],
        &[(0b01001, &ENTRY_CATALYZE_5340148730721059753)],
        &[(0b01001, &ENTRY_CATALYZED_18179839917863952435)],
        &[(0b01001, &ENTRY_CATALYZES_11042547222296624347)],
        &[(0b01001, &ENTRY_CATALYZING_13540847378063734907)],
        &[(0b10010, &ENTRY_CATECHIZE_5115052394209545163)],
        &[(0b10010, &ENTRY_CATECHIZED_12525365667138826112)],
        &[(0b10010, &ENTRY_CATECHIZER_7607670417085575365)],
        &[(0b10010, &ENTRY_CATECHIZERS_7954123406223722552)],
        &[(0b10010, &ENTRY_CATECHIZES_15782633201911980832)],
        &[(0b10010, &ENTRY_CATECHIZING_3256072816982004976)],
        &[(0b10010, &ENTRY_CATECHIZINGS_8339955228064173770)],
        &[(0b01001, &ENTRY_CATECHIZE_5115052394209545163)],
        &[(0b01001, &ENTRY_CATECHIZED_12525365667138826112)],
        &[(0b01001, &ENTRY_CATECHIZER_7607670417085575365)],
        &[(0b01001, &ENTRY_CATECHIZERS_7954123406223722552)],
        &[(0b01001, &ENTRY_CATECHIZES_15782633201911980832)],
        &[(0b01001, &ENTRY_CATECHIZING_3256072816982004976)],
        &[(0b01001, &ENTRY_CATECHIZINGS_8339955228064173770)],
        &[(0b10010, &ENTRY_CATEGORIZATION_18434363169100289749)],
        &[(0b10010, &ENTRY_CATEGORIZATIONS_16946076754480761936)],
        &[(0b10010, &ENTRY_CATEGORIZE_8200356101421109194)],
        &[(0b10010, &ENTRY_CATEGORIZED_3860898201662042852)],
        &[(0b10010, &ENTRY_CATEGORIZES_5429500333056172375)],
        &[(0b10010, &ENTRY_CATEGORIZING_3255461076933906932)],
        &[(0b01001, &ENTRY_CATEGORIZATION_18434363169100289749)],
        &[(0b01001, &ENTRY_CATEGORIZATIONS_16946076754480761936)],
        &[(0b01001, &ENTRY_CATEGORIZE_8200356101421109194)],
        &[(0b01001, &ENTRY_CATEGORIZED_3860898201662042852)],
        &[(0b01001, &ENTRY_CATEGORIZES_5429500333056172375)],
        &[(0b01001, &ENTRY_CATEGORIZING_3255461076933906932)],
        &[(0b10010, &ENTRY_CATHETERIZATION_3744811591478338437)],
        &[(0b10010, &ENTRY_CATHETERIZATIONS_5962217885260693783)],
        &[(0b10010, &ENTRY_CATHETERIZE_6223868023340323760)],
        &[(0b10010, &ENTRY_CATHETERIZED_2068677963449945916)],
        &[(0b10010, &ENTRY_CATHETERIZES_8282905890220338225)],
        &[(0b10010, &ENTRY_CATHETERIZING_9242723783135014192)],
        &[(0b01001, &ENTRY_CATHETERIZATION_3744811591478338437)],
        &[(0b01001, &ENTRY_CATHETERIZATIONS_5962217885260693783)],
        &[(0b01001, &ENTRY_CATHETERIZE_6223868023340323760)],
        &[(0b01001, &ENTRY_CATHETERIZED_2068677963449945916)],
        &[(0b01001, &ENTRY_CATHETERIZES_8282905890220338225)],
        &[(0b01001, &ENTRY_CATHETERIZING_9242723783135014192)],
    ],
    range: 4..=13,
};

static VARS_CAR_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_CAR_CHILDREN),
    value: None,
};

pub static VARS_CAR_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("amelisation"),
        dictgen::InsensitiveAscii("amelisations"),
        dictgen::InsensitiveAscii("amelise"),
        dictgen::InsensitiveAscii("amelised"),
        dictgen::InsensitiveAscii("amelises"),
        dictgen::InsensitiveAscii("amelising"),
        dictgen::InsensitiveAscii("amelization"),
        dictgen::InsensitiveAscii("amelizations"),
        dictgen::InsensitiveAscii("amelize"),
        dictgen::InsensitiveAscii("amelized"),
        dictgen::InsensitiveAscii("amelizes"),
        dictgen::InsensitiveAscii("amelizing"),
        dictgen::InsensitiveAscii("bonisation"),
        dictgen::InsensitiveAscii("bonisations"),
        dictgen::InsensitiveAscii("bonise"),
        dictgen::InsensitiveAscii("bonised"),
        dictgen::InsensitiveAscii("bonises"),
        dictgen::InsensitiveAscii("bonising"),
        dictgen::InsensitiveAscii("bonization"),
        dictgen::InsensitiveAscii("bonizations"),
        dictgen::InsensitiveAscii("bonize"),
        dictgen::InsensitiveAscii("bonized"),
        dictgen::InsensitiveAscii("bonizes"),
        dictgen::InsensitiveAscii("bonizing"),
        dictgen::InsensitiveAscii("oled"),
        dictgen::InsensitiveAscii("oler"),
        dictgen::InsensitiveAscii("olers"),
        dictgen::InsensitiveAscii("oling"),
        dictgen::InsensitiveAscii("olled"),
        dictgen::InsensitiveAscii("oller"),
        dictgen::InsensitiveAscii("ollers"),
        dictgen::InsensitiveAscii("olling"),
        dictgen::InsensitiveAscii("telise"),
        dictgen::InsensitiveAscii("telised"),
        dictgen::InsensitiveAscii("telises"),
        dictgen::InsensitiveAscii("telising"),
        dictgen::InsensitiveAscii("telize"),
        dictgen::InsensitiveAscii("telized"),
        dictgen::InsensitiveAscii("telizes"),
        dictgen::InsensitiveAscii("telizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_CARAMELIZATION_12515762504964341677)],
        &[(0b10010, &ENTRY_CARAMELIZATIONS_2385837672145447407)],
        &[(0b10010, &ENTRY_CARAMELIZE_1110104959262710985)],
        &[(0b10010, &ENTRY_CARAMELIZED_7793381247604239400)],
        &[(0b10010, &ENTRY_CARAMELIZES_6059982956966755570)],
        &[(0b10010, &ENTRY_CARAMELIZING_2936515763713237491)],
        &[(0b01001, &ENTRY_CARAMELIZATION_12515762504964341677)],
        &[(0b01001, &ENTRY_CARAMELIZATIONS_2385837672145447407)],
        &[(0b01001, &ENTRY_CARAMELIZE_1110104959262710985)],
        &[(0b01001, &ENTRY_CARAMELIZED_7793381247604239400)],
        &[(0b01001, &ENTRY_CARAMELIZES_6059982956966755570)],
        &[(0b01001, &ENTRY_CARAMELIZING_2936515763713237491)],
        &[(0b10010, &ENTRY_CARBONIZATION_16165847968956959109)],
        &[(0b10010, &ENTRY_CARBONIZATIONS_13100027598773896835)],
        &[(0b10010, &ENTRY_CARBONIZE_1296979562221113559)],
        &[(0b10010, &ENTRY_CARBONIZED_14007117269969730084)],
        &[(0b10010, &ENTRY_CARBONIZES_4601016301417314989)],
        &[(0b10010, &ENTRY_CARBONIZING_9584599099267202250)],
        &[(0b01001, &ENTRY_CARBONIZATION_16165847968956959109)],
        &[(0b01001, &ENTRY_CARBONIZATIONS_13100027598773896835)],
        &[(0b01001, &ENTRY_CARBONIZE_1296979562221113559)],
        &[(0b01001, &ENTRY_CARBONIZED_14007117269969730084)],
        &[(0b01001, &ENTRY_CARBONIZES_4601016301417314989)],
        &[(0b01001, &ENTRY_CARBONIZING_9584599099267202250)],
        &[(0b00001, &ENTRY_CAROLED_4418735863611872467)],
        &[(0b00001, &ENTRY_CAROLER_4713116399310207395)],
        &[(0b00001, &ENTRY_CAROLERS_5398425405494964276)],
        &[(0b00001, &ENTRY_CAROLING_6802531412817349154)],
        &[(0b11010, &ENTRY_CAROLED_4418735863611872467)],
        &[(0b11010, &ENTRY_CAROLER_4713116399310207395)],
        &[(0b11010, &ENTRY_CAROLERS_5398425405494964276)],
        &[(0b11010, &ENTRY_CAROLING_6802531412817349154)],
        &[(0b10010, &ENTRY_CARTELIZE_2833428251960695439)],
        &[(0b10010, &ENTRY_CARTELIZED_12213627611344387963)],
        &[(0b10010, &ENTRY_CARTELIZES_7591657395331891195)],
        &[(0b10010, &ENTRY_CARTELIZING_11143164166226551666)],
        &[(0b01001, &ENTRY_CARTELIZE_2833428251960695439)],
        &[(0b01001, &ENTRY_CARTELIZED_12213627611344387963)],
        &[(0b01001, &ENTRY_CARTELIZES_7591657395331891195)],
        &[(0b01001, &ENTRY_CARTELIZING_11143164166226551666)],
    ],
    range: 4..=12,
};

static VARS_CAP_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_CAP_CHILDREN),
    value: None,
};

pub static VARS_CAP_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("italisation"),
        dictgen::InsensitiveAscii("italisations"),
        dictgen::InsensitiveAscii("italise"),
        dictgen::InsensitiveAscii("italised"),
        dictgen::InsensitiveAscii("italises"),
        dictgen::InsensitiveAscii("italising"),
        dictgen::InsensitiveAscii("italization"),
        dictgen::InsensitiveAscii("italizations"),
        dictgen::InsensitiveAscii("italize"),
        dictgen::InsensitiveAscii("italized"),
        dictgen::InsensitiveAscii("italizes"),
        dictgen::InsensitiveAscii("italizing"),
        dictgen::InsensitiveAscii("onise"),
        dictgen::InsensitiveAscii("onised"),
        dictgen::InsensitiveAscii("onises"),
        dictgen::InsensitiveAscii("onising"),
        dictgen::InsensitiveAscii("onize"),
        dictgen::InsensitiveAscii("onized"),
        dictgen::InsensitiveAscii("onizes"),
        dictgen::InsensitiveAscii("onizing"),
        dictgen::InsensitiveAscii("sulise"),
        dictgen::InsensitiveAscii("sulised"),
        dictgen::InsensitiveAscii("sulises"),
        dictgen::InsensitiveAscii("sulising"),
        dictgen::InsensitiveAscii("sulize"),
        dictgen::InsensitiveAscii("sulized"),
        dictgen::InsensitiveAscii("sulizes"),
        dictgen::InsensitiveAscii("sulizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_CAPITALIZATION_701575089089546433)],
        &[(0b10010, &ENTRY_CAPITALIZATIONS_12418153595184643992)],
        &[(0b10010, &ENTRY_CAPITALIZE_14987270073189981607)],
        &[(0b10010, &ENTRY_CAPITALIZED_16586381829524591032)],
        &[(0b10010, &ENTRY_CAPITALIZES_8346787254057235765)],
        &[(0b10010, &ENTRY_CAPITALIZING_12592559899378813681)],
        &[(0b01001, &ENTRY_CAPITALIZATION_701575089089546433)],
        &[(0b01001, &ENTRY_CAPITALIZATIONS_12418153595184643992)],
        &[(0b01001, &ENTRY_CAPITALIZE_14987270073189981607)],
        &[(0b01001, &ENTRY_CAPITALIZED_16586381829524591032)],
        &[(0b01001, &ENTRY_CAPITALIZES_8346787254057235765)],
        &[(0b01001, &ENTRY_CAPITALIZING_12592559899378813681)],
        &[(0b10010, &ENTRY_CAPONIZE_7723124127427821667)],
        &[(0b10010, &ENTRY_CAPONIZED_3599983764436663496)],
        &[(0b10010, &ENTRY_CAPONIZES_8112348068369020206)],
        &[(0b10010, &ENTRY_CAPONIZING_4731137034979888377)],
        &[(0b01001, &ENTRY_CAPONIZE_7723124127427821667)],
        &[(0b01001, &ENTRY_CAPONIZED_3599983764436663496)],
        &[(0b01001, &ENTRY_CAPONIZES_8112348068369020206)],
        &[(0b01001, &ENTRY_CAPONIZING_4731137034979888377)],
        &[(0b10010, &ENTRY_CAPSULIZE_8925469580586567241)],
        &[(0b10010, &ENTRY_CAPSULIZED_15163714329989053697)],
        &[(0b10010, &ENTRY_CAPSULIZES_6046785573783515511)],
        &[(0b10010, &ENTRY_CAPSULIZING_14108763304053705443)],
        &[(0b01001, &ENTRY_CAPSULIZE_8925469580586567241)],
        &[(0b01001, &ENTRY_CAPSULIZED_15163714329989053697)],
        &[(0b01001, &ENTRY_CAPSULIZES_6046785573783515511)],
        &[(0b01001, &ENTRY_CAPSULIZING_14108763304053705443)],
    ],
    range: 5..=12,
};

static VARS_CAN_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_CAN_CHILDREN),
    value: None,
};

pub static VARS_CAN_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("alisation"),
        dictgen::InsensitiveAscii("alisations"),
        dictgen::InsensitiveAscii("alise"),
        dictgen::InsensitiveAscii("alised"),
        dictgen::InsensitiveAscii("alises"),
        dictgen::InsensitiveAscii("alising"),
        dictgen::InsensitiveAscii("alization"),
        dictgen::InsensitiveAscii("alizations"),
        dictgen::InsensitiveAscii("alize"),
        dictgen::InsensitiveAscii("alized"),
        dictgen::InsensitiveAscii("alizes"),
        dictgen::InsensitiveAscii("alizing"),
        dictgen::InsensitiveAscii("celation"),
        dictgen::InsensitiveAscii("celed"),
        dictgen::InsensitiveAscii("celer"),
        dictgen::InsensitiveAscii("celers"),
        dictgen::InsensitiveAscii("celing"),
        dictgen::InsensitiveAscii("celler"),
        dictgen::InsensitiveAscii("cellers"),
        dictgen::InsensitiveAscii("dor"),
        dictgen::InsensitiveAscii("dors"),
        dictgen::InsensitiveAscii("dour"),
        dictgen::InsensitiveAscii("dours"),
        dictgen::InsensitiveAscii("nibalisation"),
        dictgen::InsensitiveAscii("nibalisations"),
        dictgen::InsensitiveAscii("nibalise"),
        dictgen::InsensitiveAscii("nibalised"),
        dictgen::InsensitiveAscii("nibalises"),
        dictgen::InsensitiveAscii("nibalising"),
        dictgen::InsensitiveAscii("nibalization"),
        dictgen::InsensitiveAscii("nibalizations"),
        dictgen::InsensitiveAscii("nibalize"),
        dictgen::InsensitiveAscii("nibalized"),
        dictgen::InsensitiveAscii("nibalizes"),
        dictgen::InsensitiveAscii("nibalizing"),
        dictgen::InsensitiveAscii("onisation"),
        dictgen::InsensitiveAscii("onisations"),
        dictgen::InsensitiveAscii("onise"),
        dictgen::InsensitiveAscii("onised"),
        dictgen::InsensitiveAscii("onises"),
        dictgen::InsensitiveAscii("onising"),
        dictgen::InsensitiveAscii("onization"),
        dictgen::InsensitiveAscii("onizations"),
        dictgen::InsensitiveAscii("onize"),
        dictgen::InsensitiveAscii("onized"),
        dictgen::InsensitiveAscii("onizes"),
        dictgen::InsensitiveAscii("onizing"),
        dictgen::InsensitiveAscii("taloup"),
        dictgen::InsensitiveAscii("taloups"),
    ],
    values: &[
        &[(0b10010, &ENTRY_CANALIZATION_13228363861342779584)],
        &[(0b10010, &ENTRY_CANALIZATIONS_13532066641589359430)],
        &[(0b10010, &ENTRY_CANALIZE_3951994517517182635)],
        &[(0b10010, &ENTRY_CANALIZED_8165057117631879852)],
        &[(0b10010, &ENTRY_CANALIZES_49113899823800782)],
        &[(0b10010, &ENTRY_CANALIZING_5717449398288828945)],
        &[(0b01001, &ENTRY_CANALIZATION_13228363861342779584)],
        &[(0b01001, &ENTRY_CANALIZATIONS_13532066641589359430)],
        &[(0b01001, &ENTRY_CANALIZE_3951994517517182635)],
        &[(0b01001, &ENTRY_CANALIZED_8165057117631879852)],
        &[(0b01001, &ENTRY_CANALIZES_49113899823800782)],
        &[(0b01001, &ENTRY_CANALIZING_5717449398288828945)],
        &[(0b00001, &ENTRY_CANCELLATION_1555414462165920792)],
        &[(0b00001, &ENTRY_CANCELED_12672342492571604224)],
        &[(0b00001, &ENTRY_CANCELER_12983343936465600908)],
        &[(0b00001, &ENTRY_CANCELERS_3981532768174175193)],
        &[(0b00001, &ENTRY_CANCELING_16146260375495786001)],
        &[(0b11010, &ENTRY_CANCELER_12983343936465600908)],
        &[(0b11010, &ENTRY_CANCELERS_3981532768174175193)],
        &[(0b11001, &ENTRY_CANDOR_10788361890221941916)],
        &[(0b11001, &ENTRY_CANDORS_11609560572454050104)],
        &[(0b11010, &ENTRY_CANDOR_10788361890221941916)],
        &[(0b11010, &ENTRY_CANDORS_11609560572454050104)],
        &[(0b10010, &ENTRY_CANNIBALIZATION_10362383723962441168)],
        &[(0b10010, &ENTRY_CANNIBALIZATIONS_8053294690714421066)],
        &[(0b10010, &ENTRY_CANNIBALIZE_12913259420777918440)],
        &[(0b10010, &ENTRY_CANNIBALIZED_13179636865120338437)],
        &[(0b10010, &ENTRY_CANNIBALIZES_5843119974222450091)],
        &[(0b10010, &ENTRY_CANNIBALIZING_16266472115659513272)],
        &[(0b01001, &ENTRY_CANNIBALIZATION_10362383723962441168)],
        &[(0b01001, &ENTRY_CANNIBALIZATIONS_8053294690714421066)],
        &[(0b01001, &ENTRY_CANNIBALIZE_12913259420777918440)],
        &[(0b01001, &ENTRY_CANNIBALIZED_13179636865120338437)],
        &[(0b01001, &ENTRY_CANNIBALIZES_5843119974222450091)],
        &[(0b01001, &ENTRY_CANNIBALIZING_16266472115659513272)],
        &[(0b10010, &ENTRY_CANONIZATION_2650997251769306758)],
        &[(0b10010, &ENTRY_CANONIZATIONS_1884767107904362564)],
        &[(0b10010, &ENTRY_CANONIZE_3694127234765675696)],
        &[(0b10010, &ENTRY_CANONIZED_15761367761494193573)],
        &[(0b10010, &ENTRY_CANONIZES_9784118345073131908)],
        &[(0b10010, &ENTRY_CANONIZING_2446378015323590313)],
        &[(0b01001, &ENTRY_CANONIZATION_2650997251769306758)],
        &[(0b01001, &ENTRY_CANONIZATIONS_1884767107904362564)],
        &[(0b01001, &ENTRY_CANONIZE_3694127234765675696)],
        &[(0b01001, &ENTRY_CANONIZED_15761367761494193573)],
        &[(0b01001, &ENTRY_CANONIZES_9784118345073131908)],
        &[(0b01001, &ENTRY_CANONIZING_2446378015323590313)],
        &[(0b01001, &ENTRY_CANTALOUPE_16173297872474332016)],
        &[(0b01001, &ENTRY_CANTALOUPES_964160501109699483)],
    ],
    range: 3..=13,
};

static VARS_CAL_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_CAL_CHILDREN),
    value: None,
};

pub static VARS_CAL_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("dron"),
        dictgen::InsensitiveAscii("drons"),
        dictgen::InsensitiveAscii("iber"),
        dictgen::InsensitiveAscii("ibers"),
        dictgen::InsensitiveAscii("ibre"),
        dictgen::InsensitiveAscii("ibres"),
        dictgen::InsensitiveAscii("k"),
        dictgen::InsensitiveAscii("ked"),
        dictgen::InsensitiveAscii("king"),
        dictgen::InsensitiveAscii("kings"),
        dictgen::InsensitiveAscii("ks"),
        dictgen::InsensitiveAscii("liper"),
        dictgen::InsensitiveAscii("lipered"),
        dictgen::InsensitiveAscii("lipering"),
        dictgen::InsensitiveAscii("lipers"),
    ],
    values: &[
        &[(0b10011, &ENTRY_CAULDRON_1773331448073014615)],
        &[(0b10011, &ENTRY_CAULDRONS_5688241368036052829)],
        &[(0b00001, &ENTRY_CALIBER_11979237421213696401)],
        &[(0b00001, &ENTRY_CALIBERS_12175169505129012964)],
        &[(0b11010, &ENTRY_CALIBER_11979237421213696401)],
        &[(0b11010, &ENTRY_CALIBERS_12175169505129012964)],
        &[
            (0b00001, &ENTRY_CALK_9463720069156928103),
            (0b00001, &ENTRY_CAULK_13405348041672279283),
            (0b00001, &ENTRY_CAULK_5085090702762931673),
        ],
        &[
            (0b00001, &ENTRY_CALKED_17587227683338315155),
            (0b00001, &ENTRY_CAULKED_17850506211135154377),
        ],
        &[
            (0b00001, &ENTRY_CALKING_15122106954759194192),
            (0b00001, &ENTRY_CAULKING_1812804659342859546),
            (0b00001, &ENTRY_CAULK_5085090702762931673),
        ],
        &[(0b00001, &ENTRY_CAULKS_2004629765557914803)],
        &[
            (0b00001, &ENTRY_CALKS_3513793957936189042),
            (0b00001, &ENTRY_CAULKS_2004629765557914803),
            (0b00001, &ENTRY_CAULKS_4230617823899022638),
        ],
        &[(0b11010, &ENTRY_CALIPER_11659384912162704496)],
        &[(0b11010, &ENTRY_CALIPERED_15148589818375924712)],
        &[(0b11010, &ENTRY_CALIPERING_13878626335317126988)],
        &[(0b11010, &ENTRY_CALIPERS_1796103950790864970)],
    ],
    range: 1..=8,
};

static VARS_CAE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_CAE_CHILDREN),
    value: None,
};

pub static VARS_CAE_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("sium"),
        dictgen::InsensitiveAscii("siums"),
        dictgen::InsensitiveAscii("sural"),
    ],
    values: &[
        &[(0b11010, &ENTRY_CESIUM_14697098024822079251)],
        &[(0b11010, &ENTRY_CESIUMS_6672725677512073080)],
        &[(0b11010, &ENTRY_CESURAL_6753528217264809955)],
    ],
    range: 4..=5,
};

static VARS_B_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_B_CHILDREN),
    value: None,
};

static VARS_B_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_BA_NODE),
    None,
    None,
    None,
    Some(&VARS_BE_NODE),
    None,
    None,
    None,
    Some(&VARS_BI_NODE),
    None,
    None,
    Some(&VARS_BL_NODE),
    None,
    None,
    Some(&VARS_BO_NODE),
    None,
    None,
    Some(&VARS_BR_NODE),
    None,
    None,
    Some(&VARS_BU_NODE),
    None,
    None,
    None,
    None,
    None,
];

static VARS_BU_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_BU_CHILDREN),
    value: None,
};

pub static VARS_BU_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("reaucratisation"),
        dictgen::InsensitiveAscii("reaucratisations"),
        dictgen::InsensitiveAscii("reaucratise"),
        dictgen::InsensitiveAscii("reaucratised"),
        dictgen::InsensitiveAscii("reaucratises"),
        dictgen::InsensitiveAscii("reaucratising"),
        dictgen::InsensitiveAscii("reaucratization"),
        dictgen::InsensitiveAscii("reaucratizations"),
        dictgen::InsensitiveAscii("reaucratize"),
        dictgen::InsensitiveAscii("reaucratized"),
        dictgen::InsensitiveAscii("reaucratizes"),
        dictgen::InsensitiveAscii("reaucratizing"),
        dictgen::InsensitiveAscii("rglarise"),
        dictgen::InsensitiveAscii("rglarised"),
        dictgen::InsensitiveAscii("rglarises"),
        dictgen::InsensitiveAscii("rglarising"),
        dictgen::InsensitiveAscii("rglarize"),
        dictgen::InsensitiveAscii("rglarized"),
        dictgen::InsensitiveAscii("rglarizes"),
        dictgen::InsensitiveAscii("rglarizing"),
        dictgen::InsensitiveAscii("ssings"),
    ],
    values: &[
        &[(0b10010, &ENTRY_BUREAUCRATIZATION_7250957081103523449)],
        &[(0b10010, &ENTRY_BUREAUCRATIZATIONS_4674366041166989149)],
        &[(0b10010, &ENTRY_BUREAUCRATIZE_13391150115061038607)],
        &[(0b10010, &ENTRY_BUREAUCRATIZED_4248245955080237225)],
        &[(0b10010, &ENTRY_BUREAUCRATIZES_16810259950475596086)],
        &[(0b10010, &ENTRY_BUREAUCRATIZING_8025017160589580538)],
        &[(0b01001, &ENTRY_BUREAUCRATIZATION_7250957081103523449)],
        &[(0b01001, &ENTRY_BUREAUCRATIZATIONS_4674366041166989149)],
        &[(0b01001, &ENTRY_BUREAUCRATIZE_13391150115061038607)],
        &[(0b01001, &ENTRY_BUREAUCRATIZED_4248245955080237225)],
        &[(0b01001, &ENTRY_BUREAUCRATIZES_16810259950475596086)],
        &[(0b01001, &ENTRY_BUREAUCRATIZING_8025017160589580538)],
        &[(0b10010, &ENTRY_BURGLARIZE_1087475814106005332)],
        &[(0b10010, &ENTRY_BURGLARIZED_5921030312710381425)],
        &[(0b10010, &ENTRY_BURGLARIZES_13866286421224924410)],
        &[(0b10010, &ENTRY_BURGLARIZING_18147959943236525815)],
        &[(0b01001, &ENTRY_BURGLARIZE_1087475814106005332)],
        &[(0b01001, &ENTRY_BURGLARIZED_5921030312710381425)],
        &[(0b01001, &ENTRY_BURGLARIZES_13866286421224924410)],
        &[(0b01001, &ENTRY_BURGLARIZING_18147959943236525815)],
        &[(0b10011, &ENTRY_BUSINGS_8757237867622763594)],
    ],
    range: 6..=16,
};

static VARS_BR_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_BR_CHILDREN),
    value: None,
};

pub static VARS_BR_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("eathalyse"),
        dictgen::InsensitiveAscii("eathalysed"),
        dictgen::InsensitiveAscii("eathalyser"),
        dictgen::InsensitiveAscii("eathalysers"),
        dictgen::InsensitiveAscii("eathalyses"),
        dictgen::InsensitiveAscii("eathalysing"),
        dictgen::InsensitiveAscii("eathalyze"),
        dictgen::InsensitiveAscii("eathalyzed"),
        dictgen::InsensitiveAscii("eathalyzers"),
        dictgen::InsensitiveAscii("eathalyzes"),
        dictgen::InsensitiveAscii("eathalyzing"),
        dictgen::InsensitiveAscii("utalisation"),
        dictgen::InsensitiveAscii("utalisations"),
        dictgen::InsensitiveAscii("utalise"),
        dictgen::InsensitiveAscii("utalised"),
        dictgen::InsensitiveAscii("utalises"),
        dictgen::InsensitiveAscii("utalising"),
        dictgen::InsensitiveAscii("utalization"),
        dictgen::InsensitiveAscii("utalizations"),
        dictgen::InsensitiveAscii("utalize"),
        dictgen::InsensitiveAscii("utalized"),
        dictgen::InsensitiveAscii("utalizes"),
        dictgen::InsensitiveAscii("utalizing"),
    ],
    values: &[
        &[(0b11010, &ENTRY_BREATHALYZE_10796683967425699198)],
        &[(0b11010, &ENTRY_BREATHALYZED_16539997499095919892)],
        &[(0b11010, &ENTRY_BREATHALYZER_4271010669418934525)],
        &[(0b11010, &ENTRY_BREATHALYZERS_3691744749547968414)],
        &[(0b11010, &ENTRY_BREATHALYZES_11235604268893682846)],
        &[(0b11010, &ENTRY_BREATHALYZING_565448827730861286)],
        &[(0b01001, &ENTRY_BREATHALYZE_10796683967425699198)],
        &[(0b01001, &ENTRY_BREATHALYZED_16539997499095919892)],
        &[(0b00001, &ENTRY_BREATHALYZERS_3691744749547968414)],
        &[(0b01001, &ENTRY_BREATHALYZES_11235604268893682846)],
        &[(0b01001, &ENTRY_BREATHALYZING_565448827730861286)],
        &[(0b10010, &ENTRY_BRUTALIZATION_11293320142916899383)],
        &[(0b10010, &ENTRY_BRUTALIZATIONS_14281415064444405659)],
        &[(0b10010, &ENTRY_BRUTALIZE_13435719365361063955)],
        &[(0b10010, &ENTRY_BRUTALIZED_12895970956896346273)],
        &[(0b10010, &ENTRY_BRUTALIZES_15844790462452513749)],
        &[(0b10010, &ENTRY_BRUTALIZING_7797427754196540922)],
        &[(0b01001, &ENTRY_BRUTALIZATION_11293320142916899383)],
        &[(0b01001, &ENTRY_BRUTALIZATIONS_14281415064444405659)],
        &[(0b01001, &ENTRY_BRUTALIZE_13435719365361063955)],
        &[(0b01001, &ENTRY_BRUTALIZED_12895970956896346273)],
        &[(0b01001, &ENTRY_BRUTALIZES_15844790462452513749)],
        &[(0b01001, &ENTRY_BRUTALIZING_7797427754196540922)],
    ],
    range: 7..=12,
};

static VARS_BO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_BO_CHILDREN),
    value: None,
};

pub static VARS_BO_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("tanise"),
        dictgen::InsensitiveAscii("tanised"),
        dictgen::InsensitiveAscii("tanises"),
        dictgen::InsensitiveAscii("tanising"),
        dictgen::InsensitiveAscii("tanize"),
        dictgen::InsensitiveAscii("tanized"),
        dictgen::InsensitiveAscii("tanizes"),
        dictgen::InsensitiveAscii("tanizing"),
        dictgen::InsensitiveAscii("wdlerisation"),
        dictgen::InsensitiveAscii("wdlerisations"),
        dictgen::InsensitiveAscii("wdlerise"),
        dictgen::InsensitiveAscii("wdlerised"),
        dictgen::InsensitiveAscii("wdlerises"),
        dictgen::InsensitiveAscii("wdlerising"),
        dictgen::InsensitiveAscii("wdlerization"),
        dictgen::InsensitiveAscii("wdlerizations"),
        dictgen::InsensitiveAscii("wdlerize"),
        dictgen::InsensitiveAscii("wdlerized"),
        dictgen::InsensitiveAscii("wdlerizes"),
        dictgen::InsensitiveAscii("wdlerizing"),
        dictgen::InsensitiveAscii("wlder"),
        dictgen::InsensitiveAscii("wlders"),
    ],
    values: &[
        &[(0b10010, &ENTRY_BOTANIZE_3414900112803410859)],
        &[(0b10010, &ENTRY_BOTANIZED_6623624034808806509)],
        &[(0b10010, &ENTRY_BOTANIZES_3701375861091440735)],
        &[(0b10010, &ENTRY_BOTANIZING_7854186980211713777)],
        &[(0b01001, &ENTRY_BOTANIZE_3414900112803410859)],
        &[(0b01001, &ENTRY_BOTANIZED_6623624034808806509)],
        &[(0b01001, &ENTRY_BOTANIZES_3701375861091440735)],
        &[(0b01001, &ENTRY_BOTANIZING_7854186980211713777)],
        &[(0b10010, &ENTRY_BOWDLERIZATION_8303366286031487639)],
        &[(0b10010, &ENTRY_BOWDLERIZATIONS_6775792789701362692)],
        &[(0b10010, &ENTRY_BOWDLERIZE_5456349648157007190)],
        &[(0b10010, &ENTRY_BOWDLERIZED_4489335143117406489)],
        &[(0b10010, &ENTRY_BOWDLERIZES_9741187207136026760)],
        &[(0b10010, &ENTRY_BOWDLERIZING_13774867242132431801)],
        &[(0b01001, &ENTRY_BOWDLERIZATION_8303366286031487639)],
        &[(0b01001, &ENTRY_BOWDLERIZATIONS_6775792789701362692)],
        &[(0b01001, &ENTRY_BOWDLERIZE_5456349648157007190)],
        &[(0b01001, &ENTRY_BOWDLERIZED_4489335143117406489)],
        &[(0b01001, &ENTRY_BOWDLERIZES_9741187207136026760)],
        &[(0b01001, &ENTRY_BOWDLERIZING_13774867242132431801)],
        &[(0b00001, &ENTRY_BOULDER_2537004730775027440)],
        &[(0b00001, &ENTRY_BOULDERS_9268529342784684955)],
    ],
    range: 5..=13,
};

static VARS_BL_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_BL_CHILDREN),
    value: None,
};

pub static VARS_BL_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[dictgen::InsensitiveAscii("amable")],
    values: &[&[(0b01001, &ENTRY_BLAMABLE_2805926222821580419)]],
    range: 6..=6,
};

static VARS_BI_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_BI_CHILDREN),
    value: None,
};

pub static VARS_BI_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("assed"),
        dictgen::InsensitiveAscii("assing"),
        dictgen::InsensitiveAscii("nging"),
        dictgen::InsensitiveAscii("ster"),
        dictgen::InsensitiveAscii("sters"),
        dictgen::InsensitiveAscii("stre"),
        dictgen::InsensitiveAscii("stres"),
    ],
    values: &[
        &[(0b10011, &ENTRY_BIASED_15079696021925521823)],
        &[(0b10011, &ENTRY_BIASING_18108238854297339846)],
        &[(0b00001, &ENTRY_BINGEING_178843586653742040)],
        &[(0b01001, &ENTRY_BISTER_10449402161913041976)],
        &[(0b01001, &ENTRY_BISTERS_7831835768196639468)],
        &[(0b11010, &ENTRY_BISTER_10449402161913041976)],
        &[(0b11010, &ENTRY_BISTERS_7831835768196639468)],
    ],
    range: 4..=6,
};

static VARS_BE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_BE_CHILDREN),
    value: None,
};

static VARS_BE_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    None,
    Some(&VARS_BED_NODE),
    None,
    None,
    None,
    Some(&VARS_BEH_NODE),
    None,
    Some(&VARS_BEJ_NODE),
    None,
    Some(&VARS_BEL_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_BEV_NODE),
    None,
    None,
    None,
    None,
];

static VARS_BEV_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_BEV_CHILDREN),
    value: None,
};

pub static VARS_BEV_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("eled"),
        dictgen::InsensitiveAscii("eler"),
        dictgen::InsensitiveAscii("elers"),
        dictgen::InsensitiveAscii("eling"),
        dictgen::InsensitiveAscii("elings"),
        dictgen::InsensitiveAscii("elled"),
        dictgen::InsensitiveAscii("eller"),
        dictgen::InsensitiveAscii("ellers"),
        dictgen::InsensitiveAscii("elling"),
        dictgen::InsensitiveAscii("ellings"),
    ],
    values: &[
        &[(0b01001, &ENTRY_BEVELED_10378533536024013853)],
        &[(0b01001, &ENTRY_BEVELER_2498982223785959149)],
        &[(0b01001, &ENTRY_BEVELERS_1892360606418032248)],
        &[(0b01001, &ENTRY_BEVELING_2110798044912558228)],
        &[(0b01001, &ENTRY_BEVELINGS_1501034049167710764)],
        &[(0b11010, &ENTRY_BEVELED_10378533536024013853)],
        &[(0b11010, &ENTRY_BEVELER_2498982223785959149)],
        &[(0b11010, &ENTRY_BEVELERS_1892360606418032248)],
        &[(0b11010, &ENTRY_BEVELING_2110798044912558228)],
        &[(0b11010, &ENTRY_BEVELINGS_1501034049167710764)],
    ],
    range: 4..=7,
};

static VARS_BEL_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_BEL_CHILDREN),
    value: None,
};

pub static VARS_BEL_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("abor"),
        dictgen::InsensitiveAscii("abored"),
        dictgen::InsensitiveAscii("aboring"),
        dictgen::InsensitiveAscii("abors"),
        dictgen::InsensitiveAscii("abour"),
        dictgen::InsensitiveAscii("aboured"),
        dictgen::InsensitiveAscii("abouring"),
        dictgen::InsensitiveAscii("abours"),
    ],
    values: &[
        &[(0b11001, &ENTRY_BELABOR_2245031289291089410)],
        &[(0b11001, &ENTRY_BELABORED_14959360057364846988)],
        &[(0b11001, &ENTRY_BELABORING_16550814486427716841)],
        &[(0b11001, &ENTRY_BELABORS_9616903556092237149)],
        &[(0b11010, &ENTRY_BELABOR_2245031289291089410)],
        &[(0b11010, &ENTRY_BELABORED_14959360057364846988)],
        &[(0b11010, &ENTRY_BELABORING_16550814486427716841)],
        &[(0b11010, &ENTRY_BELABORS_9616903556092237149)],
    ],
    range: 4..=8,
};

static VARS_BEJ_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_BEJ_CHILDREN),
    value: None,
};

pub static VARS_BEJ_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("eweled"),
        dictgen::InsensitiveAscii("eweling"),
        dictgen::InsensitiveAscii("ewelled"),
        dictgen::InsensitiveAscii("ewelling"),
    ],
    values: &[
        &[(0b00001, &ENTRY_BEJEWELED_12216934890816407648)],
        &[(0b00001, &ENTRY_BEJEWELING_8804246701630066335)],
        &[(0b11010, &ENTRY_BEJEWELED_12216934890816407648)],
        &[(0b11010, &ENTRY_BEJEWELING_8804246701630066335)],
    ],
    range: 6..=8,
};

static VARS_BEH_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_BEH_CHILDREN),
    value: None,
};

pub static VARS_BEH_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("avior"),
        dictgen::InsensitiveAscii("avioral"),
        dictgen::InsensitiveAscii("avioraler"),
        dictgen::InsensitiveAscii("avioralest"),
        dictgen::InsensitiveAscii("aviorally"),
        dictgen::InsensitiveAscii("aviorism"),
        dictgen::InsensitiveAscii("aviorisms"),
        dictgen::InsensitiveAscii("aviorist"),
        dictgen::InsensitiveAscii("avioristic"),
        dictgen::InsensitiveAscii("avioristicer"),
        dictgen::InsensitiveAscii("avioristicest"),
        dictgen::InsensitiveAscii("avioristics"),
        dictgen::InsensitiveAscii("aviorists"),
        dictgen::InsensitiveAscii("aviors"),
        dictgen::InsensitiveAscii("aviour"),
        dictgen::InsensitiveAscii("avioural"),
        dictgen::InsensitiveAscii("aviouraler"),
        dictgen::InsensitiveAscii("aviouralest"),
        dictgen::InsensitiveAscii("aviourally"),
        dictgen::InsensitiveAscii("aviourism"),
        dictgen::InsensitiveAscii("aviourisms"),
        dictgen::InsensitiveAscii("aviourist"),
        dictgen::InsensitiveAscii("aviouristic"),
        dictgen::InsensitiveAscii("aviouristicer"),
        dictgen::InsensitiveAscii("aviouristicest"),
        dictgen::InsensitiveAscii("aviouristics"),
        dictgen::InsensitiveAscii("aviourists"),
        dictgen::InsensitiveAscii("aviours"),
        dictgen::InsensitiveAscii("oove"),
        dictgen::InsensitiveAscii("ooved"),
        dictgen::InsensitiveAscii("ooves"),
        dictgen::InsensitiveAscii("ooving"),
        dictgen::InsensitiveAscii("oovings"),
        dictgen::InsensitiveAscii("ove"),
        dictgen::InsensitiveAscii("oved"),
        dictgen::InsensitiveAscii("oves"),
        dictgen::InsensitiveAscii("oving"),
        dictgen::InsensitiveAscii("ovings"),
    ],
    values: &[
        &[(0b11001, &ENTRY_BEHAVIOR_4270292057978962250)],
        &[(0b11001, &ENTRY_BEHAVIORAL_1668398487637965302)],
        &[(0b11001, &ENTRY_BEHAVIORALER_15849878698882095342)],
        &[(0b11001, &ENTRY_BEHAVIORALEST_4676686848581067810)],
        &[(0b11001, &ENTRY_BEHAVIORALLY_15603975909970219512)],
        &[(0b11001, &ENTRY_BEHAVIORISM_16788531821804542526)],
        &[(0b11001, &ENTRY_BEHAVIORISMS_18431005634091902550)],
        &[(0b11001, &ENTRY_BEHAVIORIST_538165502271076270)],
        &[(0b11001, &ENTRY_BEHAVIORISTIC_10912467475164998417)],
        &[(0b11001, &ENTRY_BEHAVIORISTICER_1771754648963132210)],
        &[(0b11001, &ENTRY_BEHAVIORISTICEST_13940464183699495590)],
        &[(0b11001, &ENTRY_BEHAVIORISTICS_9644519070934483422)],
        &[(0b11001, &ENTRY_BEHAVIORISTS_2791913883690306158)],
        &[(0b11001, &ENTRY_BEHAVIORS_17740975427353098200)],
        &[(0b11010, &ENTRY_BEHAVIOR_4270292057978962250)],
        &[(0b11010, &ENTRY_BEHAVIORAL_1668398487637965302)],
        &[(0b11010, &ENTRY_BEHAVIORALER_15849878698882095342)],
        &[(0b11010, &ENTRY_BEHAVIORALEST_4676686848581067810)],
        &[(0b11010, &ENTRY_BEHAVIORALLY_15603975909970219512)],
        &[(0b11010, &ENTRY_BEHAVIORISM_16788531821804542526)],
        &[(0b11010, &ENTRY_BEHAVIORISMS_18431005634091902550)],
        &[(0b11010, &ENTRY_BEHAVIORIST_538165502271076270)],
        &[(0b11010, &ENTRY_BEHAVIORISTIC_10912467475164998417)],
        &[(0b11010, &ENTRY_BEHAVIORISTICER_1771754648963132210)],
        &[(0b11010, &ENTRY_BEHAVIORISTICEST_13940464183699495590)],
        &[(0b11010, &ENTRY_BEHAVIORISTICS_9644519070934483422)],
        &[(0b11010, &ENTRY_BEHAVIORISTS_2791913883690306158)],
        &[(0b11010, &ENTRY_BEHAVIORS_17740975427353098200)],
        &[(0b01001, &ENTRY_BEHOOVE_15601060046872655911)],
        &[(0b01001, &ENTRY_BEHOOVED_19557981828125274)],
        &[(0b01001, &ENTRY_BEHOOVES_18171198361790854374)],
        &[(0b01001, &ENTRY_BEHOOVING_8542587834338786394)],
        &[(0b01001, &ENTRY_BEHOOVINGS_5611929196356326751)],
        &[(0b10010, &ENTRY_BEHOOVE_15601060046872655911)],
        &[(0b10010, &ENTRY_BEHOOVED_19557981828125274)],
        &[(0b10010, &ENTRY_BEHOOVES_18171198361790854374)],
        &[(0b10010, &ENTRY_BEHOOVING_8542587834338786394)],
        &[(0b10010, &ENTRY_BEHOOVINGS_5611929196356326751)],
    ],
    range: 3..=14,
};

static VARS_BED_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_BED_CHILDREN),
    value: None,
};

pub static VARS_BED_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("eviled"),
        dictgen::InsensitiveAscii("eviling"),
        dictgen::InsensitiveAscii("evilled"),
        dictgen::InsensitiveAscii("evilling"),
    ],
    values: &[
        &[(0b00001, &ENTRY_BEDEVILED_11085714010658112928)],
        &[(0b00001, &ENTRY_BEDEVILING_10442109879718503775)],
        &[(0b11010, &ENTRY_BEDEVILED_11085714010658112928)],
        &[(0b11010, &ENTRY_BEDEVILING_10442109879718503775)],
    ],
    range: 6..=8,
};

static VARS_BA_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_BA_CHILDREN),
    value: None,
};

pub static VARS_BA_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("cterias"),
        dictgen::InsensitiveAscii("lkanisation"),
        dictgen::InsensitiveAscii("lkanisations"),
        dictgen::InsensitiveAscii("lkanise"),
        dictgen::InsensitiveAscii("lkanised"),
        dictgen::InsensitiveAscii("lkanises"),
        dictgen::InsensitiveAscii("lkanising"),
        dictgen::InsensitiveAscii("lkanization"),
        dictgen::InsensitiveAscii("lkanizations"),
        dictgen::InsensitiveAscii("lkanize"),
        dictgen::InsensitiveAscii("lkanized"),
        dictgen::InsensitiveAscii("lkanizes"),
        dictgen::InsensitiveAscii("lkanizing"),
        dictgen::InsensitiveAscii("ptise"),
        dictgen::InsensitiveAscii("ptised"),
        dictgen::InsensitiveAscii("ptiser"),
        dictgen::InsensitiveAscii("ptisers"),
        dictgen::InsensitiveAscii("ptises"),
        dictgen::InsensitiveAscii("ptising"),
        dictgen::InsensitiveAscii("ptize"),
        dictgen::InsensitiveAscii("ptized"),
        dictgen::InsensitiveAscii("ptizer"),
        dictgen::InsensitiveAscii("ptizers"),
        dictgen::InsensitiveAscii("ptizes"),
        dictgen::InsensitiveAscii("ptizing"),
        dictgen::InsensitiveAscii("rbarisation"),
        dictgen::InsensitiveAscii("rbarisations"),
        dictgen::InsensitiveAscii("rbarise"),
        dictgen::InsensitiveAscii("rbarised"),
        dictgen::InsensitiveAscii("rbarises"),
        dictgen::InsensitiveAscii("rbarising"),
        dictgen::InsensitiveAscii("rbarization"),
        dictgen::InsensitiveAscii("rbarizations"),
        dictgen::InsensitiveAscii("rbarize"),
        dictgen::InsensitiveAscii("rbarized"),
        dictgen::InsensitiveAscii("rbarizes"),
        dictgen::InsensitiveAscii("rbarizing"),
        dictgen::InsensitiveAscii("rreled"),
        dictgen::InsensitiveAscii("rreling"),
        dictgen::InsensitiveAscii("stardisation"),
        dictgen::InsensitiveAscii("stardisations"),
        dictgen::InsensitiveAscii("stardise"),
        dictgen::InsensitiveAscii("stardised"),
        dictgen::InsensitiveAscii("stardises"),
        dictgen::InsensitiveAscii("stardising"),
        dictgen::InsensitiveAscii("stardization"),
        dictgen::InsensitiveAscii("stardizations"),
        dictgen::InsensitiveAscii("stardize"),
        dictgen::InsensitiveAscii("stardized"),
        dictgen::InsensitiveAscii("stardizes"),
        dictgen::InsensitiveAscii("stardizing"),
        dictgen::InsensitiveAscii("ttleax"),
        dictgen::InsensitiveAscii("ulk"),
        dictgen::InsensitiveAscii("ulked"),
        dictgen::InsensitiveAscii("ulking"),
        dictgen::InsensitiveAscii("ulks"),
    ],
    values: &[
        &[(0b00001, &ENTRY_BACTERIA_16095578107548828853)],
        &[(0b10010, &ENTRY_BALKANIZATION_9747896824720545908)],
        &[(0b10010, &ENTRY_BALKANIZATIONS_7005506925687374553)],
        &[(0b10010, &ENTRY_BALKANIZE_12204669760694621864)],
        &[(0b10010, &ENTRY_BALKANIZED_12279192716835695133)],
        &[(0b10010, &ENTRY_BALKANIZES_2001964342934763145)],
        &[(0b10010, &ENTRY_BALKANIZING_14076694085527168987)],
        &[(0b01001, &ENTRY_BALKANIZATION_9747896824720545908)],
        &[(0b01001, &ENTRY_BALKANIZATIONS_7005506925687374553)],
        &[(0b01001, &ENTRY_BALKANIZE_12204669760694621864)],
        &[(0b01001, &ENTRY_BALKANIZED_12279192716835695133)],
        &[(0b01001, &ENTRY_BALKANIZES_2001964342934763145)],
        &[(0b01001, &ENTRY_BALKANIZING_14076694085527168987)],
        &[(0b10010, &ENTRY_BAPTIZE_17709364285657597325)],
        &[(0b10010, &ENTRY_BAPTIZED_3084779397484844921)],
        &[(0b10010, &ENTRY_BAPTIZER_5319953109508258693)],
        &[(0b10010, &ENTRY_BAPTIZERS_17786948365777430097)],
        &[(0b10010, &ENTRY_BAPTIZES_3674202696170149073)],
        &[(0b10010, &ENTRY_BAPTIZING_4391013702348485363)],
        &[(0b01001, &ENTRY_BAPTIZE_17709364285657597325)],
        &[(0b01001, &ENTRY_BAPTIZED_3084779397484844921)],
        &[(0b01001, &ENTRY_BAPTIZER_5319953109508258693)],
        &[(0b01001, &ENTRY_BAPTIZERS_17786948365777430097)],
        &[(0b01001, &ENTRY_BAPTIZES_3674202696170149073)],
        &[(0b01001, &ENTRY_BAPTIZING_4391013702348485363)],
        &[(0b10010, &ENTRY_BARBARIZATION_1565508341740347927)],
        &[(0b10010, &ENTRY_BARBARIZATIONS_16120039862360583028)],
        &[(0b10010, &ENTRY_BARBARIZE_11203839610503788919)],
        &[(0b10010, &ENTRY_BARBARIZED_10589089200149181973)],
        &[(0b10010, &ENTRY_BARBARIZES_11729924502589455167)],
        &[(0b10010, &ENTRY_BARBARIZING_10697728842079700750)],
        &[(0b01001, &ENTRY_BARBARIZATION_1565508341740347927)],
        &[(0b01001, &ENTRY_BARBARIZATIONS_16120039862360583028)],
        &[(0b01001, &ENTRY_BARBARIZE_11203839610503788919)],
        &[(0b01001, &ENTRY_BARBARIZED_10589089200149181973)],
        &[(0b01001, &ENTRY_BARBARIZES_11729924502589455167)],
        &[(0b01001, &ENTRY_BARBARIZING_10697728842079700750)],
        &[(0b00001, &ENTRY_BARRELED_14092667501559584042)],
        &[(0b00001, &ENTRY_BARRELING_14466284948340214047)],
        &[(0b10010, &ENTRY_BASTARDIZATION_4159983584935153450)],
        &[(0b10010, &ENTRY_BASTARDIZATIONS_3269957802823510223)],
        &[(0b10010, &ENTRY_BASTARDIZE_3932717470754109062)],
        &[(0b10010, &ENTRY_BASTARDIZED_8789832174701091014)],
        &[(0b10010, &ENTRY_BASTARDIZES_4123418596066734832)],
        &[(0b10010, &ENTRY_BASTARDIZING_16141466359672648361)],
        &[(0b01001, &ENTRY_BASTARDIZATION_4159983584935153450)],
        &[(0b01001, &ENTRY_BASTARDIZATIONS_3269957802823510223)],
        &[(0b01001, &ENTRY_BASTARDIZE_3932717470754109062)],
        &[(0b01001, &ENTRY_BASTARDIZED_8789832174701091014)],
        &[(0b01001, &ENTRY_BASTARDIZES_4123418596066734832)],
        &[(0b01001, &ENTRY_BASTARDIZING_16141466359672648361)],
        &[(0b00001, &ENTRY_BATTLEAXE_5257995273927790498)],
        &[(0b10010, &ENTRY_BALK_16035479339777098788)],
        &[(0b10010, &ENTRY_BALKED_3526355814992470448)],
        &[(0b10010, &ENTRY_BALKING_8837528869624452282)],
        &[(0b10010, &ENTRY_BALKS_16564351609417220858)],
    ],
    range: 3..=13,
};

static VARS_A_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_A_CHILDREN),
    value: None,
};

static VARS_A_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    Some(&VARS_AB_NODE),
    Some(&VARS_AC_NODE),
    Some(&VARS_AD_NODE),
    Some(&VARS_AE_NODE),
    Some(&VARS_AF_NODE),
    Some(&VARS_AG_NODE),
    None,
    Some(&VARS_AI_NODE),
    None,
    None,
    Some(&VARS_AL_NODE),
    Some(&VARS_AM_NODE),
    Some(&VARS_AN_NODE),
    None,
    Some(&VARS_AP_NODE),
    None,
    Some(&VARS_AR_NODE),
    Some(&VARS_AS_NODE),
    Some(&VARS_AT_NODE),
    Some(&VARS_AU_NODE),
    None,
    None,
    Some(&VARS_AX_NODE),
    None,
    None,
];

static VARS_AX_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_AX_CHILDREN),
    value: Some(&[(0b00001, &ENTRY_AX_8791902263575839056)]),
};

pub static VARS_AX_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[dictgen::InsensitiveAscii("e")],
    values: &[&[(0b11010, &ENTRY_AX_8791902263575839056)]],
    range: 1..=1,
};

static VARS_AU_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_AU_CHILDREN),
    value: None,
};

pub static VARS_AU_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("thorisation"),
        dictgen::InsensitiveAscii("thorisations"),
        dictgen::InsensitiveAscii("thorise"),
        dictgen::InsensitiveAscii("thorised"),
        dictgen::InsensitiveAscii("thorises"),
        dictgen::InsensitiveAscii("thorising"),
        dictgen::InsensitiveAscii("thorization"),
        dictgen::InsensitiveAscii("thorizations"),
        dictgen::InsensitiveAscii("thorize"),
        dictgen::InsensitiveAscii("thorized"),
        dictgen::InsensitiveAscii("thorizes"),
        dictgen::InsensitiveAscii("thorizing"),
        dictgen::InsensitiveAscii("tomatisation"),
        dictgen::InsensitiveAscii("tomatisations"),
        dictgen::InsensitiveAscii("tomatise"),
        dictgen::InsensitiveAscii("tomatised"),
        dictgen::InsensitiveAscii("tomatises"),
        dictgen::InsensitiveAscii("tomatising"),
        dictgen::InsensitiveAscii("tomatization"),
        dictgen::InsensitiveAscii("tomatizations"),
        dictgen::InsensitiveAscii("tomatize"),
        dictgen::InsensitiveAscii("tomatized"),
        dictgen::InsensitiveAscii("tomatizes"),
        dictgen::InsensitiveAscii("tomatizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_AUTHORIZATION_9399085124340736739)],
        &[(0b10010, &ENTRY_AUTHORIZATIONS_11920547268538394932)],
        &[(0b10010, &ENTRY_AUTHORIZE_2165377916187291578)],
        &[(0b10010, &ENTRY_AUTHORIZED_15853776364746167522)],
        &[(0b10010, &ENTRY_AUTHORIZES_12688794592033918408)],
        &[(0b10010, &ENTRY_AUTHORIZING_9710867312061027048)],
        &[(0b01001, &ENTRY_AUTHORIZATION_9399085124340736739)],
        &[(0b01001, &ENTRY_AUTHORIZATIONS_11920547268538394932)],
        &[(0b01001, &ENTRY_AUTHORIZE_2165377916187291578)],
        &[(0b01001, &ENTRY_AUTHORIZED_15853776364746167522)],
        &[(0b01001, &ENTRY_AUTHORIZES_12688794592033918408)],
        &[(0b01001, &ENTRY_AUTHORIZING_9710867312061027048)],
        &[(0b10010, &ENTRY_AUTOMATIZATION_5810567154782386881)],
        &[(0b10010, &ENTRY_AUTOMATIZATIONS_11353228502294123144)],
        &[(0b10010, &ENTRY_AUTOMATIZE_16310459509383804856)],
        &[(0b10010, &ENTRY_AUTOMATIZED_6360332663543743601)],
        &[(0b10010, &ENTRY_AUTOMATIZES_16200902288701375676)],
        &[(0b10010, &ENTRY_AUTOMATIZING_1555845313837902984)],
        &[(0b01001, &ENTRY_AUTOMATIZATION_5810567154782386881)],
        &[(0b01001, &ENTRY_AUTOMATIZATIONS_11353228502294123144)],
        &[(0b01001, &ENTRY_AUTOMATIZE_16310459509383804856)],
        &[(0b01001, &ENTRY_AUTOMATIZED_6360332663543743601)],
        &[(0b01001, &ENTRY_AUTOMATIZES_16200902288701375676)],
        &[(0b01001, &ENTRY_AUTOMATIZING_1555845313837902984)],
    ],
    range: 7..=13,
};

static VARS_AT_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_AT_CHILDREN),
    value: None,
};

pub static VARS_AT_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("omisation"),
        dictgen::InsensitiveAscii("omisations"),
        dictgen::InsensitiveAscii("omise"),
        dictgen::InsensitiveAscii("omised"),
        dictgen::InsensitiveAscii("omiser"),
        dictgen::InsensitiveAscii("omisers"),
        dictgen::InsensitiveAscii("omises"),
        dictgen::InsensitiveAscii("omising"),
        dictgen::InsensitiveAscii("omization"),
        dictgen::InsensitiveAscii("omizations"),
        dictgen::InsensitiveAscii("omize"),
        dictgen::InsensitiveAscii("omized"),
        dictgen::InsensitiveAscii("omizer"),
        dictgen::InsensitiveAscii("omizers"),
        dictgen::InsensitiveAscii("omizes"),
        dictgen::InsensitiveAscii("omizing"),
        dictgen::InsensitiveAscii("titudinise"),
        dictgen::InsensitiveAscii("titudinised"),
        dictgen::InsensitiveAscii("titudinises"),
        dictgen::InsensitiveAscii("titudinising"),
        dictgen::InsensitiveAscii("titudinisings"),
        dictgen::InsensitiveAscii("titudinize"),
        dictgen::InsensitiveAscii("titudinized"),
        dictgen::InsensitiveAscii("titudinizes"),
        dictgen::InsensitiveAscii("titudinizing"),
        dictgen::InsensitiveAscii("titudinizings"),
    ],
    values: &[
        &[(0b10010, &ENTRY_ATOMIZATION_590556657495417532)],
        &[(0b10010, &ENTRY_ATOMIZATIONS_13202958232672091227)],
        &[(0b10010, &ENTRY_ATOMIZE_1487134664435979373)],
        &[(0b10010, &ENTRY_ATOMIZED_14021873460744571304)],
        &[(0b10010, &ENTRY_ATOMIZER_11539225746984001325)],
        &[(0b10010, &ENTRY_ATOMIZERS_7852074573965124043)],
        &[(0b10010, &ENTRY_ATOMIZES_933901040229054200)],
        &[(0b10010, &ENTRY_ATOMIZING_15930852773659767832)],
        &[(0b01001, &ENTRY_ATOMIZATION_590556657495417532)],
        &[(0b01001, &ENTRY_ATOMIZATIONS_13202958232672091227)],
        &[(0b01001, &ENTRY_ATOMIZE_1487134664435979373)],
        &[(0b01001, &ENTRY_ATOMIZED_14021873460744571304)],
        &[(0b01001, &ENTRY_ATOMIZER_11539225746984001325)],
        &[(0b01001, &ENTRY_ATOMIZERS_7852074573965124043)],
        &[(0b01001, &ENTRY_ATOMIZES_933901040229054200)],
        &[(0b01001, &ENTRY_ATOMIZING_15930852773659767832)],
        &[(0b10010, &ENTRY_ATTITUDINIZE_13882543243823601511)],
        &[(0b10010, &ENTRY_ATTITUDINIZED_14589679104763490674)],
        &[(0b10010, &ENTRY_ATTITUDINIZES_8414732033616113994)],
        &[(0b10010, &ENTRY_ATTITUDINIZING_1855190539336439905)],
        &[(0b10010, &ENTRY_ATTITUDINIZINGS_3731252719764627971)],
        &[(0b01001, &ENTRY_ATTITUDINIZE_13882543243823601511)],
        &[(0b01001, &ENTRY_ATTITUDINIZED_14589679104763490674)],
        &[(0b01001, &ENTRY_ATTITUDINIZES_8414732033616113994)],
        &[(0b01001, &ENTRY_ATTITUDINIZING_1855190539336439905)],
        &[(0b01001, &ENTRY_ATTITUDINIZINGS_3731252719764627971)],
    ],
    range: 5..=13,
};

static VARS_AS_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_AS_CHILDREN),
    value: None,
};

pub static VARS_AS_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("afetida"),
        dictgen::InsensitiveAscii("afetidas"),
        dictgen::InsensitiveAscii("afoetida"),
        dictgen::InsensitiveAscii("afoetidas"),
        dictgen::InsensitiveAscii("cendency"),
        dictgen::InsensitiveAscii("cendent"),
        dictgen::InsensitiveAscii("cendents"),
        dictgen::InsensitiveAscii("shole"),
        dictgen::InsensitiveAscii("sholes"),
    ],
    values: &[
        &[(0b01001, &ENTRY_ASAFETIDA_7533383003905845995)],
        &[(0b01001, &ENTRY_ASAFETIDAS_7613771138640395119)],
        &[(0b11010, &ENTRY_ASAFETIDA_7533383003905845995)],
        &[(0b11010, &ENTRY_ASAFETIDAS_7613771138640395119)],
        &[(0b01001, &ENTRY_ASCENDANCY_18331730091976203528)],
        &[(0b10011, &ENTRY_ASCENDANT_16268836042646778732)],
        &[(0b10011, &ENTRY_ASCENDANTS_3461593336021850728)],
        &[(0b00001, &ENTRY_ASSHOLE_17127558960509698292)],
        &[(0b00001, &ENTRY_ASSHOLES_4727626946303116044)],
    ],
    range: 5..=9,
};

static VARS_AR_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_AR_CHILDREN),
    value: None,
};

static VARS_AR_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    Some(&VARS_ARB_NODE),
    Some(&VARS_ARC_NODE),
    Some(&VARS_ARD_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_ARM_NODE),
    None,
    Some(&VARS_ARO_NODE),
    None,
    None,
    None,
    Some(&VARS_ARS_NODE),
    Some(&VARS_ART_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_ART_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_ART_CHILDREN),
    value: None,
};

pub static VARS_ART_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("efact"),
        dictgen::InsensitiveAscii("efacts"),
        dictgen::InsensitiveAscii("erialisation"),
        dictgen::InsensitiveAscii("erialisations"),
        dictgen::InsensitiveAscii("erialise"),
        dictgen::InsensitiveAscii("erialised"),
        dictgen::InsensitiveAscii("erialises"),
        dictgen::InsensitiveAscii("erialising"),
        dictgen::InsensitiveAscii("erialization"),
        dictgen::InsensitiveAscii("erializations"),
        dictgen::InsensitiveAscii("erialize"),
        dictgen::InsensitiveAscii("erialized"),
        dictgen::InsensitiveAscii("erializes"),
        dictgen::InsensitiveAscii("erializing"),
        dictgen::InsensitiveAscii("ifact"),
        dictgen::InsensitiveAscii("ifacts"),
    ],
    values: &[
        &[(0b11010, &ENTRY_ARTIFACT_17509472184751868861)],
        &[(0b11010, &ENTRY_ARTIFACTS_1062240257173575487)],
        &[(0b10010, &ENTRY_ARTERIALIZATION_12220214490626585223)],
        &[(0b10010, &ENTRY_ARTERIALIZATIONS_14137202706840549747)],
        &[(0b10010, &ENTRY_ARTERIALIZE_160821330242474661)],
        &[(0b10010, &ENTRY_ARTERIALIZED_13112994890988388396)],
        &[(0b10010, &ENTRY_ARTERIALIZES_17367277747015913948)],
        &[(0b10010, &ENTRY_ARTERIALIZING_12599986629846293545)],
        &[(0b01001, &ENTRY_ARTERIALIZATION_12220214490626585223)],
        &[(0b01001, &ENTRY_ARTERIALIZATIONS_14137202706840549747)],
        &[(0b01001, &ENTRY_ARTERIALIZE_160821330242474661)],
        &[(0b01001, &ENTRY_ARTERIALIZED_13112994890988388396)],
        &[(0b01001, &ENTRY_ARTERIALIZES_17367277747015913948)],
        &[(0b01001, &ENTRY_ARTERIALIZING_12599986629846293545)],
        &[(0b11001, &ENTRY_ARTIFACT_17509472184751868861)],
        &[(0b11001, &ENTRY_ARTIFACTS_1062240257173575487)],
    ],
    range: 5..=13,
};

static VARS_ARS_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_ARS_CHILDREN),
    value: None,
};

pub static VARS_ARS_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("e"),
        dictgen::InsensitiveAscii("ehole"),
        dictgen::InsensitiveAscii("eholes"),
        dictgen::InsensitiveAscii("es"),
    ],
    values: &[
        &[(0b11010, &ENTRY_ASS_13267007711731927046)],
        &[(0b11010, &ENTRY_ASSHOLE_17127558960509698292)],
        &[(0b11010, &ENTRY_ASSHOLES_4727626946303116044)],
        &[(0b11010, &ENTRY_ASSES_10300641245501717757)],
    ],
    range: 1..=6,
};

static VARS_ARO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_ARO_CHILDREN),
    value: None,
};

pub static VARS_ARO_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("matisation"),
        dictgen::InsensitiveAscii("matise"),
        dictgen::InsensitiveAscii("matised"),
        dictgen::InsensitiveAscii("matises"),
        dictgen::InsensitiveAscii("matising"),
        dictgen::InsensitiveAscii("matization"),
        dictgen::InsensitiveAscii("matize"),
        dictgen::InsensitiveAscii("matized"),
        dictgen::InsensitiveAscii("matizes"),
        dictgen::InsensitiveAscii("matizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_AROMATIZATION_5370295794385992127)],
        &[(0b10010, &ENTRY_AROMATIZE_17577690372454585657)],
        &[(0b10010, &ENTRY_AROMATIZED_5000984731968850520)],
        &[(0b10010, &ENTRY_AROMATIZES_11882880046820259901)],
        &[(0b10010, &ENTRY_AROMATIZING_12161529232297358732)],
        &[(0b01001, &ENTRY_AROMATIZATION_5370295794385992127)],
        &[(0b01001, &ENTRY_AROMATIZE_17577690372454585657)],
        &[(0b01001, &ENTRY_AROMATIZED_5000984731968850520)],
        &[(0b01001, &ENTRY_AROMATIZES_11882880046820259901)],
        &[(0b01001, &ENTRY_AROMATIZING_12161529232297358732)],
    ],
    range: 6..=10,
};

static VARS_ARM_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_ARM_CHILDREN),
    value: None,
};

pub static VARS_ARM_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("or"),
        dictgen::InsensitiveAscii("ored"),
        dictgen::InsensitiveAscii("orer"),
        dictgen::InsensitiveAscii("orers"),
        dictgen::InsensitiveAscii("ories"),
        dictgen::InsensitiveAscii("oring"),
        dictgen::InsensitiveAscii("ors"),
        dictgen::InsensitiveAscii("ory"),
        dictgen::InsensitiveAscii("our"),
        dictgen::InsensitiveAscii("oured"),
        dictgen::InsensitiveAscii("ourer"),
        dictgen::InsensitiveAscii("ourers"),
        dictgen::InsensitiveAscii("ouries"),
        dictgen::InsensitiveAscii("ouring"),
        dictgen::InsensitiveAscii("ours"),
        dictgen::InsensitiveAscii("oury"),
    ],
    values: &[
        &[(0b11001, &ENTRY_ARMOR_4945447914484381803)],
        &[(0b11001, &ENTRY_ARMORED_214663291627156832)],
        &[(0b11001, &ENTRY_ARMORER_15410308267945880573)],
        &[(0b11001, &ENTRY_ARMORERS_15576792766558527660)],
        &[(0b11001, &ENTRY_ARMORIES_338319230858200174)],
        &[(0b11001, &ENTRY_ARMORING_10102011884001661988)],
        &[(0b11001, &ENTRY_ARMORS_14520485620428417155)],
        &[(0b11001, &ENTRY_ARMORY_13479680231027438950)],
        &[(0b11010, &ENTRY_ARMOR_4945447914484381803)],
        &[(0b11010, &ENTRY_ARMORED_214663291627156832)],
        &[(0b11010, &ENTRY_ARMORER_15410308267945880573)],
        &[(0b11010, &ENTRY_ARMORERS_15576792766558527660)],
        &[(0b11010, &ENTRY_ARMORIES_338319230858200174)],
        &[(0b11010, &ENTRY_ARMORING_10102011884001661988)],
        &[(0b11010, &ENTRY_ARMORS_14520485620428417155)],
        &[(0b11010, &ENTRY_ARMORY_13479680231027438950)],
    ],
    range: 2..=6,
};

static VARS_ARD_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_ARD_CHILDREN),
    value: None,
};

pub static VARS_ARD_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("or"),
        dictgen::InsensitiveAscii("ors"),
        dictgen::InsensitiveAscii("our"),
        dictgen::InsensitiveAscii("ours"),
    ],
    values: &[
        &[(0b11001, &ENTRY_ARDOR_14403534690593993712)],
        &[(0b11001, &ENTRY_ARDORS_3754540775895817864)],
        &[(0b11010, &ENTRY_ARDOR_14403534690593993712)],
        &[(0b11010, &ENTRY_ARDORS_3754540775895817864)],
    ],
    range: 2..=4,
};

static VARS_ARC_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_ARC_CHILDREN),
    value: None,
};

pub static VARS_ARC_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("haise"),
        dictgen::InsensitiveAscii("haised"),
        dictgen::InsensitiveAscii("haises"),
        dictgen::InsensitiveAscii("haising"),
        dictgen::InsensitiveAscii("haize"),
        dictgen::InsensitiveAscii("haized"),
        dictgen::InsensitiveAscii("haizes"),
        dictgen::InsensitiveAscii("haizing"),
        dictgen::InsensitiveAscii("heologic"),
        dictgen::InsensitiveAscii("heological"),
        dictgen::InsensitiveAscii("heologies"),
        dictgen::InsensitiveAscii("heologist"),
        dictgen::InsensitiveAscii("heologists"),
        dictgen::InsensitiveAscii("heology"),
    ],
    values: &[
        &[(0b10010, &ENTRY_ARCHAIZE_306453875004862597)],
        &[(0b10010, &ENTRY_ARCHAIZED_17502443965255232728)],
        &[(0b10010, &ENTRY_ARCHAIZES_3289069090284787945)],
        &[(0b10010, &ENTRY_ARCHAIZING_3514060218818847476)],
        &[(0b01001, &ENTRY_ARCHAIZE_306453875004862597)],
        &[(0b01001, &ENTRY_ARCHAIZED_17502443965255232728)],
        &[(0b01001, &ENTRY_ARCHAIZES_3289069090284787945)],
        &[(0b01001, &ENTRY_ARCHAIZING_3514060218818847476)],
        &[(0b11001, &ENTRY_ARCHAEOLOGIC_175348203002056666)],
        &[(0b11001, &ENTRY_ARCHAEOLOGICAL_10563432210833298458)],
        &[(0b11001, &ENTRY_ARCHAEOLOGIES_8039431778163772974)],
        &[(0b11001, &ENTRY_ARCHAEOLOGIST_12712686763317819627)],
        &[(0b11001, &ENTRY_ARCHAEOLOGISTS_15763944587883983376)],
        &[(0b11001, &ENTRY_ARCHAEOLOGY_10452692803395720100)],
    ],
    range: 5..=10,
};

static VARS_ARB_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_ARB_CHILDREN),
    value: None,
};

pub static VARS_ARB_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("or"),
        dictgen::InsensitiveAscii("ored"),
        dictgen::InsensitiveAscii("ores"),
        dictgen::InsensitiveAscii("orisation"),
        dictgen::InsensitiveAscii("orisations"),
        dictgen::InsensitiveAscii("orization"),
        dictgen::InsensitiveAscii("orizations"),
        dictgen::InsensitiveAscii("ors"),
        dictgen::InsensitiveAscii("our"),
        dictgen::InsensitiveAscii("oured"),
        dictgen::InsensitiveAscii("oures"),
        dictgen::InsensitiveAscii("ours"),
    ],
    values: &[
        &[(0b01001, &ENTRY_ARBOR_820303798692032572)],
        &[(0b00001, &ENTRY_ARBORED_9841319088226677951)],
        &[(0b01001, &ENTRY_ARBORES_15360373317740002388)],
        &[(0b10010, &ENTRY_ARBORIZATION_15816140615041238184)],
        &[(0b10010, &ENTRY_ARBORIZATIONS_4188589807836256359)],
        &[(0b01001, &ENTRY_ARBORIZATION_15816140615041238184)],
        &[(0b01001, &ENTRY_ARBORIZATIONS_4188589807836256359)],
        &[(0b01001, &ENTRY_ARBORS_2769870038356325080)],
        &[(0b11010, &ENTRY_ARBOR_820303798692032572)],
        &[(0b11010, &ENTRY_ARBORED_9841319088226677951)],
        &[(0b11010, &ENTRY_ARBORES_15360373317740002388)],
        &[(0b11010, &ENTRY_ARBORS_2769870038356325080)],
    ],
    range: 2..=10,
};

static VARS_AP_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_AP_CHILDREN),
    value: None,
};

static VARS_AP_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_APH_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_APN_NODE),
    Some(&VARS_APO_NODE),
    Some(&VARS_APP_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_APP_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_APP_CHILDREN),
    value: None,
};

pub static VARS_APP_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("al"),
        dictgen::InsensitiveAscii("all"),
        dictgen::InsensitiveAscii("alls"),
        dictgen::InsensitiveAscii("als"),
        dictgen::InsensitiveAscii("areled"),
        dictgen::InsensitiveAscii("areling"),
        dictgen::InsensitiveAscii("arelled"),
        dictgen::InsensitiveAscii("arelling"),
        dictgen::InsensitiveAscii("etise"),
        dictgen::InsensitiveAscii("etised"),
        dictgen::InsensitiveAscii("etiser"),
        dictgen::InsensitiveAscii("etisers"),
        dictgen::InsensitiveAscii("etises"),
        dictgen::InsensitiveAscii("etising"),
        dictgen::InsensitiveAscii("etisingly"),
        dictgen::InsensitiveAscii("etize"),
        dictgen::InsensitiveAscii("etized"),
        dictgen::InsensitiveAscii("etizer"),
        dictgen::InsensitiveAscii("etizers"),
        dictgen::InsensitiveAscii("etizes"),
        dictgen::InsensitiveAscii("etizing"),
        dictgen::InsensitiveAscii("etizingly"),
    ],
    values: &[
        &[(0b11010, &ENTRY_APPALL_3381232000687374522)],
        &[(0b11001, &ENTRY_APPALL_3381232000687374522)],
        &[(0b11001, &ENTRY_APPALLS_14971304364498187153)],
        &[(0b11010, &ENTRY_APPALLS_14971304364498187153)],
        &[(0b00001, &ENTRY_APPARELED_5914262035984071991)],
        &[(0b00001, &ENTRY_APPARELING_11650623594673700867)],
        &[(0b11010, &ENTRY_APPARELED_5914262035984071991)],
        &[(0b11010, &ENTRY_APPARELING_11650623594673700867)],
        &[(0b10010, &ENTRY_APPETIZE_12214870214458995398)],
        &[(0b10010, &ENTRY_APPETIZED_12779274256898682576)],
        &[(0b10010, &ENTRY_APPETIZER_8559355853918389374)],
        &[(0b10010, &ENTRY_APPETIZERS_5843282302692262805)],
        &[(0b10010, &ENTRY_APPETIZES_14250778261697102866)],
        &[(0b10010, &ENTRY_APPETIZING_3391416091007273367)],
        &[(0b10010, &ENTRY_APPETIZINGLY_9913312311160671376)],
        &[(0b01001, &ENTRY_APPETIZE_12214870214458995398)],
        &[(0b01001, &ENTRY_APPETIZED_12779274256898682576)],
        &[(0b01001, &ENTRY_APPETIZER_8559355853918389374)],
        &[(0b01001, &ENTRY_APPETIZERS_5843282302692262805)],
        &[(0b01001, &ENTRY_APPETIZES_14250778261697102866)],
        &[(0b01001, &ENTRY_APPETIZING_3391416091007273367)],
        &[(0b01001, &ENTRY_APPETIZINGLY_9913312311160671376)],
    ],
    range: 2..=9,
};

static VARS_APO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_APO_CHILDREN),
    value: None,
};

pub static VARS_APO_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("logise"),
        dictgen::InsensitiveAscii("logised"),
        dictgen::InsensitiveAscii("logises"),
        dictgen::InsensitiveAscii("logising"),
        dictgen::InsensitiveAscii("logize"),
        dictgen::InsensitiveAscii("logized"),
        dictgen::InsensitiveAscii("logizes"),
        dictgen::InsensitiveAscii("logizing"),
        dictgen::InsensitiveAscii("statise"),
        dictgen::InsensitiveAscii("statised"),
        dictgen::InsensitiveAscii("statises"),
        dictgen::InsensitiveAscii("statising"),
        dictgen::InsensitiveAscii("statize"),
        dictgen::InsensitiveAscii("statized"),
        dictgen::InsensitiveAscii("statizes"),
        dictgen::InsensitiveAscii("statizing"),
        dictgen::InsensitiveAscii("strophise"),
        dictgen::InsensitiveAscii("strophised"),
        dictgen::InsensitiveAscii("strophises"),
        dictgen::InsensitiveAscii("strophising"),
        dictgen::InsensitiveAscii("strophize"),
        dictgen::InsensitiveAscii("strophized"),
        dictgen::InsensitiveAscii("strophizes"),
        dictgen::InsensitiveAscii("strophizing"),
        dictgen::InsensitiveAscii("theosise"),
        dictgen::InsensitiveAscii("theosised"),
        dictgen::InsensitiveAscii("theosises"),
        dictgen::InsensitiveAscii("theosising"),
        dictgen::InsensitiveAscii("theosize"),
        dictgen::InsensitiveAscii("theosized"),
        dictgen::InsensitiveAscii("theosizes"),
        dictgen::InsensitiveAscii("theosizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_APOLOGIZE_14449570546795754812)],
        &[(0b10010, &ENTRY_APOLOGIZED_3547075355470705991)],
        &[(0b10010, &ENTRY_APOLOGIZES_13345357472753740063)],
        &[(0b10010, &ENTRY_APOLOGIZING_16657477641936872991)],
        &[(0b01001, &ENTRY_APOLOGIZE_14449570546795754812)],
        &[(0b01001, &ENTRY_APOLOGIZED_3547075355470705991)],
        &[(0b01001, &ENTRY_APOLOGIZES_13345357472753740063)],
        &[(0b01001, &ENTRY_APOLOGIZING_16657477641936872991)],
        &[(0b10010, &ENTRY_APOSTATIZE_13080506949193574486)],
        &[(0b10010, &ENTRY_APOSTATIZED_44225222340281598)],
        &[(0b10010, &ENTRY_APOSTATIZES_10706409261795785069)],
        &[(0b10010, &ENTRY_APOSTATIZING_18253376445779049751)],
        &[(0b01001, &ENTRY_APOSTATIZE_13080506949193574486)],
        &[(0b01001, &ENTRY_APOSTATIZED_44225222340281598)],
        &[(0b01001, &ENTRY_APOSTATIZES_10706409261795785069)],
        &[(0b01001, &ENTRY_APOSTATIZING_18253376445779049751)],
        &[(0b10010, &ENTRY_APOSTROPHIZE_17888463482112539780)],
        &[(0b10010, &ENTRY_APOSTROPHIZED_10611323756896254538)],
        &[(0b10010, &ENTRY_APOSTROPHIZES_14704113907193101943)],
        &[(0b10010, &ENTRY_APOSTROPHIZING_5813087553114165636)],
        &[(0b01001, &ENTRY_APOSTROPHIZE_17888463482112539780)],
        &[(0b01001, &ENTRY_APOSTROPHIZED_10611323756896254538)],
        &[(0b01001, &ENTRY_APOSTROPHIZES_14704113907193101943)],
        &[(0b01001, &ENTRY_APOSTROPHIZING_5813087553114165636)],
        &[(0b10010, &ENTRY_APOTHEOSIZE_6351046197862617198)],
        &[(0b10010, &ENTRY_APOTHEOSIZED_8172850542068614358)],
        &[(0b10010, &ENTRY_APOTHEOSIZES_3324551187478048042)],
        &[(0b10010, &ENTRY_APOTHEOSIZING_10080445523181927742)],
        &[(0b01001, &ENTRY_APOTHEOSIZE_6351046197862617198)],
        &[(0b01001, &ENTRY_APOTHEOSIZED_8172850542068614358)],
        &[(0b01001, &ENTRY_APOTHEOSIZES_3324551187478048042)],
        &[(0b01001, &ENTRY_APOTHEOSIZING_10080445523181927742)],
    ],
    range: 6..=11,
};

static VARS_APN_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_APN_CHILDREN),
    value: None,
};

pub static VARS_APN_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ea"),
        dictgen::InsensitiveAscii("eas"),
        dictgen::InsensitiveAscii("oea"),
        dictgen::InsensitiveAscii("oeas"),
    ],
    values: &[
        &[(0b11001, &ENTRY_APNEA_6406034786678842123)],
        &[(0b11001, &ENTRY_APNEAS_2550899720378134826)],
        &[(0b10010, &ENTRY_APNEA_6406034786678842123)],
        &[(0b10010, &ENTRY_APNEAS_2550899720378134826)],
    ],
    range: 2..=4,
};

static VARS_APH_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_APH_CHILDREN),
    value: None,
};

pub static VARS_APH_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("orise"),
        dictgen::InsensitiveAscii("orised"),
        dictgen::InsensitiveAscii("orises"),
        dictgen::InsensitiveAscii("orising"),
        dictgen::InsensitiveAscii("orize"),
        dictgen::InsensitiveAscii("orized"),
        dictgen::InsensitiveAscii("orizes"),
        dictgen::InsensitiveAscii("orizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_APHORIZE_17513005870741888985)],
        &[(0b10010, &ENTRY_APHORIZED_10249942663715046169)],
        &[(0b10010, &ENTRY_APHORIZES_16282592296354062486)],
        &[(0b10010, &ENTRY_APHORIZING_8622079489862524646)],
        &[(0b01001, &ENTRY_APHORIZE_17513005870741888985)],
        &[(0b01001, &ENTRY_APHORIZED_10249942663715046169)],
        &[(0b01001, &ENTRY_APHORIZES_16282592296354062486)],
        &[(0b01001, &ENTRY_APHORIZING_8622079489862524646)],
    ],
    range: 5..=7,
};

static VARS_AN_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_AN_CHILDREN),
    value: None,
};

static VARS_AN_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_ANA_NODE),
    None,
    None,
    None,
    Some(&VARS_ANE_NODE),
    None,
    Some(&VARS_ANG_NODE),
    None,
    Some(&VARS_ANI_NODE),
    None,
    None,
    None,
    None,
    Some(&VARS_ANN_NODE),
    Some(&VARS_ANO_NODE),
    None,
    None,
    None,
    None,
    Some(&VARS_ANT_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_ANT_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_ANT_CHILDREN),
    value: None,
};

pub static VARS_ANT_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("agonise"),
        dictgen::InsensitiveAscii("agonised"),
        dictgen::InsensitiveAscii("agonises"),
        dictgen::InsensitiveAscii("agonising"),
        dictgen::InsensitiveAscii("agonize"),
        dictgen::InsensitiveAscii("agonized"),
        dictgen::InsensitiveAscii("agonizes"),
        dictgen::InsensitiveAscii("agonizing"),
        dictgen::InsensitiveAscii("hologise"),
        dictgen::InsensitiveAscii("hologised"),
        dictgen::InsensitiveAscii("hologises"),
        dictgen::InsensitiveAscii("hologising"),
        dictgen::InsensitiveAscii("hologize"),
        dictgen::InsensitiveAscii("hologized"),
        dictgen::InsensitiveAscii("hologizes"),
        dictgen::InsensitiveAscii("hologizing"),
        dictgen::InsensitiveAscii("hropomorphise"),
        dictgen::InsensitiveAscii("hropomorphised"),
        dictgen::InsensitiveAscii("hropomorphises"),
        dictgen::InsensitiveAscii("hropomorphising"),
        dictgen::InsensitiveAscii("hropomorphize"),
        dictgen::InsensitiveAscii("hropomorphized"),
        dictgen::InsensitiveAscii("hropomorphizes"),
        dictgen::InsensitiveAscii("hropomorphizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_ANTAGONIZE_9720477866642638466)],
        &[(0b10010, &ENTRY_ANTAGONIZED_14895933622160991615)],
        &[(0b10010, &ENTRY_ANTAGONIZES_10024723998796407988)],
        &[(0b10010, &ENTRY_ANTAGONIZING_6352128995314172485)],
        &[(0b01001, &ENTRY_ANTAGONIZE_9720477866642638466)],
        &[(0b01001, &ENTRY_ANTAGONIZED_14895933622160991615)],
        &[(0b01001, &ENTRY_ANTAGONIZES_10024723998796407988)],
        &[(0b01001, &ENTRY_ANTAGONIZING_6352128995314172485)],
        &[(0b10010, &ENTRY_ANTHOLOGIZE_5139724017303417861)],
        &[(0b10010, &ENTRY_ANTHOLOGIZED_13481396057773837788)],
        &[(0b10010, &ENTRY_ANTHOLOGIZES_3543574969907946599)],
        &[(0b10010, &ENTRY_ANTHOLOGIZING_15922251613207293395)],
        &[(0b01001, &ENTRY_ANTHOLOGIZE_5139724017303417861)],
        &[(0b01001, &ENTRY_ANTHOLOGIZED_13481396057773837788)],
        &[(0b01001, &ENTRY_ANTHOLOGIZES_3543574969907946599)],
        &[(0b01001, &ENTRY_ANTHOLOGIZING_15922251613207293395)],
        &[(0b10010, &ENTRY_ANTHROPOMORPHIZE_728742791191255557)],
        &[(0b10010, &ENTRY_ANTHROPOMORPHIZED_8782099582013525777)],
        &[(0b10010, &ENTRY_ANTHROPOMORPHIZES_11954393995572409567)],
        &[(0b10010, &ENTRY_ANTHROPOMORPHIZING_6013696895454427306)],
        &[(0b01001, &ENTRY_ANTHROPOMORPHIZE_728742791191255557)],
        &[(0b01001, &ENTRY_ANTHROPOMORPHIZED_8782099582013525777)],
        &[(0b01001, &ENTRY_ANTHROPOMORPHIZES_11954393995572409567)],
        &[(0b01001, &ENTRY_ANTHROPOMORPHIZING_6013696895454427306)],
    ],
    range: 7..=15,
};

static VARS_ANO_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_ANO_CHILDREN),
    value: None,
};

pub static VARS_ANO_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("dise"),
        dictgen::InsensitiveAscii("dised"),
        dictgen::InsensitiveAscii("dises"),
        dictgen::InsensitiveAscii("dising"),
        dictgen::InsensitiveAscii("dize"),
        dictgen::InsensitiveAscii("dized"),
        dictgen::InsensitiveAscii("dizes"),
        dictgen::InsensitiveAscii("dizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_ANODIZE_15718660927426923526)],
        &[(0b10010, &ENTRY_ANODIZED_15907709896779053361)],
        &[(0b10010, &ENTRY_ANODIZES_11959401558402485938)],
        &[(0b10010, &ENTRY_ANODIZING_10710921135886181266)],
        &[(0b01001, &ENTRY_ANODIZE_15718660927426923526)],
        &[(0b01001, &ENTRY_ANODIZED_15907709896779053361)],
        &[(0b01001, &ENTRY_ANODIZES_11959401558402485938)],
        &[(0b01001, &ENTRY_ANODIZING_10710921135886181266)],
    ],
    range: 4..=6,
};

static VARS_ANN_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_ANN_CHILDREN),
    value: None,
};

pub static VARS_ANN_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ualise"),
        dictgen::InsensitiveAscii("ualised"),
        dictgen::InsensitiveAscii("ualises"),
        dictgen::InsensitiveAscii("ualising"),
        dictgen::InsensitiveAscii("ualize"),
        dictgen::InsensitiveAscii("ualized"),
        dictgen::InsensitiveAscii("ualizes"),
        dictgen::InsensitiveAscii("ualizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_ANNUALIZE_14357283589343884058)],
        &[(0b10010, &ENTRY_ANNUALIZED_8158941755303657840)],
        &[(0b10010, &ENTRY_ANNUALIZES_3376871436090240009)],
        &[(0b10010, &ENTRY_ANNUALIZING_14559072289548057157)],
        &[(0b01001, &ENTRY_ANNUALIZE_14357283589343884058)],
        &[(0b01001, &ENTRY_ANNUALIZED_8158941755303657840)],
        &[(0b01001, &ENTRY_ANNUALIZES_3376871436090240009)],
        &[(0b01001, &ENTRY_ANNUALIZING_14559072289548057157)],
    ],
    range: 6..=8,
};

static VARS_ANI_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_ANI_CHILDREN),
    value: None,
};

pub static VARS_ANI_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("malisation"),
        dictgen::InsensitiveAscii("malisations"),
        dictgen::InsensitiveAscii("malise"),
        dictgen::InsensitiveAscii("malised"),
        dictgen::InsensitiveAscii("malises"),
        dictgen::InsensitiveAscii("malising"),
        dictgen::InsensitiveAscii("malization"),
        dictgen::InsensitiveAscii("malizations"),
        dictgen::InsensitiveAscii("malize"),
        dictgen::InsensitiveAscii("malized"),
        dictgen::InsensitiveAscii("malizes"),
        dictgen::InsensitiveAscii("malizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_ANIMALIZATION_2531195057486411112)],
        &[(0b10010, &ENTRY_ANIMALIZATIONS_15722635992002526559)],
        &[(0b10010, &ENTRY_ANIMALIZE_13599801917843491747)],
        &[(0b10010, &ENTRY_ANIMALIZED_11992776700792677845)],
        &[(0b10010, &ENTRY_ANIMALIZES_13031030594595132678)],
        &[(0b10010, &ENTRY_ANIMALIZING_16466913009307928576)],
        &[(0b01001, &ENTRY_ANIMALIZATION_2531195057486411112)],
        &[(0b01001, &ENTRY_ANIMALIZATIONS_15722635992002526559)],
        &[(0b01001, &ENTRY_ANIMALIZE_13599801917843491747)],
        &[(0b01001, &ENTRY_ANIMALIZED_11992776700792677845)],
        &[(0b01001, &ENTRY_ANIMALIZES_13031030594595132678)],
        &[(0b01001, &ENTRY_ANIMALIZING_16466913009307928576)],
    ],
    range: 6..=11,
};

static VARS_ANG_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_ANG_CHILDREN),
    value: None,
};

pub static VARS_ANG_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("licisation"),
        dictgen::InsensitiveAscii("licisations"),
        dictgen::InsensitiveAscii("licise"),
        dictgen::InsensitiveAscii("licised"),
        dictgen::InsensitiveAscii("licises"),
        dictgen::InsensitiveAscii("licising"),
        dictgen::InsensitiveAscii("licization"),
        dictgen::InsensitiveAscii("licizations"),
        dictgen::InsensitiveAscii("licize"),
        dictgen::InsensitiveAscii("licized"),
        dictgen::InsensitiveAscii("licizes"),
        dictgen::InsensitiveAscii("licizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_ANGLICIZATION_2983200592739510459)],
        &[(0b10010, &ENTRY_ANGLICIZATIONS_8469725992410144048)],
        &[(0b10010, &ENTRY_ANGLICIZE_6354255494717016366)],
        &[(0b10010, &ENTRY_ANGLICIZED_14308195744307041473)],
        &[(0b10010, &ENTRY_ANGLICIZES_2840411104211976362)],
        &[(0b10010, &ENTRY_ANGLICIZING_8410491650860737901)],
        &[(0b01001, &ENTRY_ANGLICIZATION_2983200592739510459)],
        &[(0b01001, &ENTRY_ANGLICIZATIONS_8469725992410144048)],
        &[(0b01001, &ENTRY_ANGLICIZE_6354255494717016366)],
        &[(0b01001, &ENTRY_ANGLICIZED_14308195744307041473)],
        &[(0b01001, &ENTRY_ANGLICIZES_2840411104211976362)],
        &[(0b01001, &ENTRY_ANGLICIZING_8410491650860737901)],
    ],
    range: 6..=11,
};

static VARS_ANE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_ANE_CHILDREN),
    value: None,
};

pub static VARS_ANE_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("mia"),
        dictgen::InsensitiveAscii("mias"),
        dictgen::InsensitiveAscii("mic"),
        dictgen::InsensitiveAscii("micer"),
        dictgen::InsensitiveAscii("micest"),
        dictgen::InsensitiveAscii("mics"),
        dictgen::InsensitiveAscii("sthesia"),
        dictgen::InsensitiveAscii("sthesias"),
        dictgen::InsensitiveAscii("sthesiologies"),
        dictgen::InsensitiveAscii("sthesiologist"),
        dictgen::InsensitiveAscii("sthesiologists"),
        dictgen::InsensitiveAscii("sthesiology"),
        dictgen::InsensitiveAscii("sthetic"),
        dictgen::InsensitiveAscii("stheticer"),
        dictgen::InsensitiveAscii("stheticest"),
        dictgen::InsensitiveAscii("sthetics"),
        dictgen::InsensitiveAscii("sthetisation"),
        dictgen::InsensitiveAscii("sthetisations"),
        dictgen::InsensitiveAscii("sthetise"),
        dictgen::InsensitiveAscii("sthetised"),
        dictgen::InsensitiveAscii("sthetises"),
        dictgen::InsensitiveAscii("sthetising"),
        dictgen::InsensitiveAscii("sthetist"),
        dictgen::InsensitiveAscii("sthetists"),
        dictgen::InsensitiveAscii("sthetization"),
        dictgen::InsensitiveAscii("sthetizations"),
        dictgen::InsensitiveAscii("sthetize"),
        dictgen::InsensitiveAscii("sthetized"),
        dictgen::InsensitiveAscii("sthetizes"),
        dictgen::InsensitiveAscii("sthetizing"),
    ],
    values: &[
        &[(0b11001, &ENTRY_ANEMIA_17351338060107863650)],
        &[(0b11001, &ENTRY_ANEMIAS_9703736074959593780)],
        &[(0b11001, &ENTRY_ANEMIC_110986479873166850)],
        &[(0b11001, &ENTRY_ANEMICER_10489187624102082516)],
        &[(0b11001, &ENTRY_ANEMICEST_16912294123173826264)],
        &[(0b11001, &ENTRY_ANEMICS_16585338697348245033)],
        &[(0b11001, &ENTRY_ANESTHESIA_7949842536189154112)],
        &[(0b11001, &ENTRY_ANESTHESIAS_4599764321131919802)],
        &[(0b11001, &ENTRY_ANESTHESIOLOGIES_140878230116787033)],
        &[(0b11001, &ENTRY_ANESTHESIOLOGIST_11739214388783841528)],
        &[(0b11001, &ENTRY_ANESTHESIOLOGISTS_5917925088694288121)],
        &[(0b11001, &ENTRY_ANESTHESIOLOGY_17372491589772115476)],
        &[(0b11001, &ENTRY_ANESTHETIC_14288529759943853831)],
        &[(0b11001, &ENTRY_ANESTHETICER_2077884160248687026)],
        &[(0b11001, &ENTRY_ANESTHETICEST_9846998351210964261)],
        &[(0b11001, &ENTRY_ANESTHETICS_14641815304467888505)],
        &[(0b10000, &ENTRY_ANESTHETIZATION_16202486391697802084)],
        &[(0b10000, &ENTRY_ANESTHETIZATIONS_12188987204886505606)],
        &[(0b10000, &ENTRY_ANESTHETIZE_14671518822963641349)],
        &[(0b10000, &ENTRY_ANESTHETIZED_16430560117590162734)],
        &[(0b10000, &ENTRY_ANESTHETIZES_6012915426134202133)],
        &[(0b10000, &ENTRY_ANESTHETIZING_9434687273852626047)],
        &[(0b11001, &ENTRY_ANESTHETIST_11538281420926207852)],
        &[(0b11001, &ENTRY_ANESTHETISTS_8704279203965849778)],
        &[(0b00001, &ENTRY_ANESTHETIZATION_16202486391697802084)],
        &[(0b00001, &ENTRY_ANESTHETIZATIONS_12188987204886505606)],
        &[(0b01001, &ENTRY_ANESTHETIZE_14671518822963641349)],
        &[(0b01001, &ENTRY_ANESTHETIZED_16430560117590162734)],
        &[(0b01001, &ENTRY_ANESTHETIZES_6012915426134202133)],
        &[(0b01001, &ENTRY_ANESTHETIZING_9434687273852626047)],
    ],
    range: 3..=14,
};

static VARS_ANA_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Nested(&VARS_ANA_CHILDREN),
    value: None,
};

static VARS_ANA_CHILDREN: [Option<&dictgen::TrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    None,
    None,
    Some(&VARS_ANAE_NODE),
    None,
    Some(&VARS_ANAG_NODE),
    None,
    None,
    None,
    None,
    Some(&VARS_ANAL_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_ANAT_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_ANAT_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_ANAT_CHILDREN),
    value: None,
};

pub static VARS_ANAT_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("hematise"),
        dictgen::InsensitiveAscii("hematised"),
        dictgen::InsensitiveAscii("hematises"),
        dictgen::InsensitiveAscii("hematising"),
        dictgen::InsensitiveAscii("hematize"),
        dictgen::InsensitiveAscii("hematized"),
        dictgen::InsensitiveAscii("hematizes"),
        dictgen::InsensitiveAscii("hematizing"),
        dictgen::InsensitiveAscii("omise"),
        dictgen::InsensitiveAscii("omised"),
        dictgen::InsensitiveAscii("omises"),
        dictgen::InsensitiveAscii("omising"),
        dictgen::InsensitiveAscii("omize"),
        dictgen::InsensitiveAscii("omized"),
        dictgen::InsensitiveAscii("omizes"),
        dictgen::InsensitiveAscii("omizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_ANATHEMATIZE_8985478249302198786)],
        &[(0b10010, &ENTRY_ANATHEMATIZED_14882382556399376184)],
        &[(0b10010, &ENTRY_ANATHEMATIZES_1397436506406873414)],
        &[(0b10010, &ENTRY_ANATHEMATIZING_3364254909178814387)],
        &[(0b01001, &ENTRY_ANATHEMATIZE_8985478249302198786)],
        &[(0b01001, &ENTRY_ANATHEMATIZED_14882382556399376184)],
        &[(0b01001, &ENTRY_ANATHEMATIZES_1397436506406873414)],
        &[(0b01001, &ENTRY_ANATHEMATIZING_3364254909178814387)],
        &[(0b10010, &ENTRY_ANATOMIZE_5992811181160301723)],
        &[(0b10010, &ENTRY_ANATOMIZED_15278909516951232818)],
        &[(0b10010, &ENTRY_ANATOMIZES_9984137617813051385)],
        &[(0b10010, &ENTRY_ANATOMIZING_16127461066028765958)],
        &[(0b01001, &ENTRY_ANATOMIZE_5992811181160301723)],
        &[(0b01001, &ENTRY_ANATOMIZED_15278909516951232818)],
        &[(0b01001, &ENTRY_ANATOMIZES_9984137617813051385)],
        &[(0b01001, &ENTRY_ANATOMIZING_16127461066028765958)],
    ],
    range: 5..=10,
};

static VARS_ANAL_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_ANAL_CHILDREN),
    value: None,
};

pub static VARS_ANAL_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ogise"),
        dictgen::InsensitiveAscii("ogised"),
        dictgen::InsensitiveAscii("ogises"),
        dictgen::InsensitiveAscii("ogising"),
        dictgen::InsensitiveAscii("ogize"),
        dictgen::InsensitiveAscii("ogized"),
        dictgen::InsensitiveAscii("ogizes"),
        dictgen::InsensitiveAscii("ogizing"),
        dictgen::InsensitiveAscii("ysable"),
        dictgen::InsensitiveAscii("ysabler"),
        dictgen::InsensitiveAscii("ysablest"),
        dictgen::InsensitiveAscii("yse"),
        dictgen::InsensitiveAscii("ysed"),
        dictgen::InsensitiveAscii("yser"),
        dictgen::InsensitiveAscii("ysers"),
        dictgen::InsensitiveAscii("ysing"),
        dictgen::InsensitiveAscii("yzable"),
        dictgen::InsensitiveAscii("yzabler"),
        dictgen::InsensitiveAscii("yzablest"),
        dictgen::InsensitiveAscii("yze"),
        dictgen::InsensitiveAscii("yzed"),
        dictgen::InsensitiveAscii("yzer"),
        dictgen::InsensitiveAscii("yzers"),
        dictgen::InsensitiveAscii("yzes"),
        dictgen::InsensitiveAscii("yzing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_ANALOGIZE_3496372555061910029)],
        &[(0b10010, &ENTRY_ANALOGIZED_7650212126382953539)],
        &[(0b10010, &ENTRY_ANALOGIZES_13569410805636149254)],
        &[(0b10010, &ENTRY_ANALOGIZING_5745351008205937159)],
        &[(0b01001, &ENTRY_ANALOGIZE_3496372555061910029)],
        &[(0b01001, &ENTRY_ANALOGIZED_7650212126382953539)],
        &[(0b01001, &ENTRY_ANALOGIZES_13569410805636149254)],
        &[(0b01001, &ENTRY_ANALOGIZING_5745351008205937159)],
        &[(0b10010, &ENTRY_ANALYZABLE_6620659606031844316)],
        &[(0b10010, &ENTRY_ANALYZABLER_1175108799224565364)],
        &[(0b10010, &ENTRY_ANALYZABLEST_6927325114662775659)],
        &[(0b11010, &ENTRY_ANALYZE_12128484930486970639)],
        &[(0b11010, &ENTRY_ANALYZED_15674848014505848991)],
        &[(0b10010, &ENTRY_ANALYZER_5869658529883306960)],
        &[(0b10010, &ENTRY_ANALYZERS_1666949323375308230)],
        &[(0b11010, &ENTRY_ANALYZING_15099411830060036147)],
        &[(0b01001, &ENTRY_ANALYZABLE_6620659606031844316)],
        &[(0b01001, &ENTRY_ANALYZABLER_1175108799224565364)],
        &[(0b01001, &ENTRY_ANALYZABLEST_6927325114662775659)],
        &[(0b01001, &ENTRY_ANALYZE_12128484930486970639)],
        &[(0b01001, &ENTRY_ANALYZED_15674848014505848991)],
        &[(0b01001, &ENTRY_ANALYZER_5869658529883306960)],
        &[(0b01001, &ENTRY_ANALYZERS_1666949323375308230)],
        &[(0b01001, &ENTRY_ANALYZES_2322356799829770580)],
        &[(0b01001, &ENTRY_ANALYZING_15099411830060036147)],
    ],
    range: 3..=8,
};

static VARS_ANAG_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_ANAG_CHILDREN),
    value: None,
};

pub static VARS_ANAG_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("rammatise"),
        dictgen::InsensitiveAscii("rammatised"),
        dictgen::InsensitiveAscii("rammatises"),
        dictgen::InsensitiveAscii("rammatising"),
        dictgen::InsensitiveAscii("rammatize"),
        dictgen::InsensitiveAscii("rammatized"),
        dictgen::InsensitiveAscii("rammatizes"),
        dictgen::InsensitiveAscii("rammatizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_ANAGRAMMATIZE_5529917246968520880)],
        &[(0b10010, &ENTRY_ANAGRAMMATIZED_12777276468218717735)],
        &[(0b10010, &ENTRY_ANAGRAMMATIZES_13672255743930960739)],
        &[(0b10010, &ENTRY_ANAGRAMMATIZING_9269936032771734368)],
        &[(0b01001, &ENTRY_ANAGRAMMATIZE_5529917246968520880)],
        &[(0b01001, &ENTRY_ANAGRAMMATIZED_12777276468218717735)],
        &[(0b01001, &ENTRY_ANAGRAMMATIZES_13672255743930960739)],
        &[(0b01001, &ENTRY_ANAGRAMMATIZING_9269936032771734368)],
    ],
    range: 9..=11,
};

static VARS_ANAE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_ANAE_CHILDREN),
    value: None,
};

pub static VARS_ANAE_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("mia"),
        dictgen::InsensitiveAscii("mias"),
        dictgen::InsensitiveAscii("mic"),
        dictgen::InsensitiveAscii("micer"),
        dictgen::InsensitiveAscii("micest"),
        dictgen::InsensitiveAscii("mics"),
        dictgen::InsensitiveAscii("sthesia"),
        dictgen::InsensitiveAscii("sthesias"),
        dictgen::InsensitiveAscii("sthesiologies"),
        dictgen::InsensitiveAscii("sthesiologist"),
        dictgen::InsensitiveAscii("sthesiologists"),
        dictgen::InsensitiveAscii("sthesiology"),
        dictgen::InsensitiveAscii("sthetic"),
        dictgen::InsensitiveAscii("stheticer"),
        dictgen::InsensitiveAscii("stheticest"),
        dictgen::InsensitiveAscii("sthetics"),
        dictgen::InsensitiveAscii("sthetisation"),
        dictgen::InsensitiveAscii("sthetisations"),
        dictgen::InsensitiveAscii("sthetise"),
        dictgen::InsensitiveAscii("sthetised"),
        dictgen::InsensitiveAscii("sthetises"),
        dictgen::InsensitiveAscii("sthetising"),
        dictgen::InsensitiveAscii("sthetist"),
        dictgen::InsensitiveAscii("sthetists"),
        dictgen::InsensitiveAscii("sthetization"),
        dictgen::InsensitiveAscii("sthetizations"),
        dictgen::InsensitiveAscii("sthetize"),
        dictgen::InsensitiveAscii("sthetized"),
        dictgen::InsensitiveAscii("sthetizes"),
        dictgen::InsensitiveAscii("sthetizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_ANEMIA_17351338060107863650)],
        &[(0b10010, &ENTRY_ANEMIAS_9703736074959593780)],
        &[(0b10010, &ENTRY_ANEMIC_110986479873166850)],
        &[(0b10010, &ENTRY_ANEMICER_10489187624102082516)],
        &[(0b10010, &ENTRY_ANEMICEST_16912294123173826264)],
        &[(0b10010, &ENTRY_ANEMICS_16585338697348245033)],
        &[(0b11010, &ENTRY_ANESTHESIA_7949842536189154112)],
        &[(0b11010, &ENTRY_ANESTHESIAS_4599764321131919802)],
        &[(0b10010, &ENTRY_ANESTHESIOLOGIES_140878230116787033)],
        &[(0b10010, &ENTRY_ANESTHESIOLOGIST_11739214388783841528)],
        &[(0b10010, &ENTRY_ANESTHESIOLOGISTS_5917925088694288121)],
        &[(0b10010, &ENTRY_ANESTHESIOLOGY_17372491589772115476)],
        &[(0b11010, &ENTRY_ANESTHETIC_14288529759943853831)],
        &[(0b11010, &ENTRY_ANESTHETICER_2077884160248687026)],
        &[(0b11010, &ENTRY_ANESTHETICEST_9846998351210964261)],
        &[(0b11010, &ENTRY_ANESTHETICS_14641815304467888505)],
        &[(0b10010, &ENTRY_ANESTHETIZATION_16202486391697802084)],
        &[(0b10010, &ENTRY_ANESTHETIZATIONS_12188987204886505606)],
        &[(0b10010, &ENTRY_ANESTHETIZE_14671518822963641349)],
        &[(0b10010, &ENTRY_ANESTHETIZED_16430560117590162734)],
        &[(0b10010, &ENTRY_ANESTHETIZES_6012915426134202133)],
        &[(0b10010, &ENTRY_ANESTHETIZING_9434687273852626047)],
        &[(0b11010, &ENTRY_ANESTHETIST_11538281420926207852)],
        &[(0b11010, &ENTRY_ANESTHETISTS_8704279203965849778)],
        &[(0b01000, &ENTRY_ANESTHETIZATION_16202486391697802084)],
        &[(0b01000, &ENTRY_ANESTHETIZATIONS_12188987204886505606)],
        &[(0b01000, &ENTRY_ANESTHETIZE_14671518822963641349)],
        &[(0b01000, &ENTRY_ANESTHETIZED_16430560117590162734)],
        &[(0b01000, &ENTRY_ANESTHETIZES_6012915426134202133)],
        &[(0b01000, &ENTRY_ANESTHETIZING_9434687273852626047)],
    ],
    range: 3..=14,
};

static VARS_AM_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_AM_CHILDREN),
    value: None,
};

pub static VARS_AM_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("eba"),
        dictgen::InsensitiveAscii("ebae"),
        dictgen::InsensitiveAscii("ebas"),
        dictgen::InsensitiveAscii("ebic"),
        dictgen::InsensitiveAscii("eboid"),
        dictgen::InsensitiveAscii("enorrhea"),
        dictgen::InsensitiveAscii("enorrheas"),
        dictgen::InsensitiveAscii("enorrhoea"),
        dictgen::InsensitiveAscii("enorrhoeas"),
        dictgen::InsensitiveAscii("ericanisation"),
        dictgen::InsensitiveAscii("ericanisations"),
        dictgen::InsensitiveAscii("ericanise"),
        dictgen::InsensitiveAscii("ericanised"),
        dictgen::InsensitiveAscii("ericanises"),
        dictgen::InsensitiveAscii("ericanising"),
        dictgen::InsensitiveAscii("ericanization"),
        dictgen::InsensitiveAscii("ericanizations"),
        dictgen::InsensitiveAscii("ericanize"),
        dictgen::InsensitiveAscii("ericanized"),
        dictgen::InsensitiveAscii("ericanizes"),
        dictgen::InsensitiveAscii("ericanizing"),
        dictgen::InsensitiveAscii("ortisation"),
        dictgen::InsensitiveAscii("ortisations"),
        dictgen::InsensitiveAscii("ortise"),
        dictgen::InsensitiveAscii("ortised"),
        dictgen::InsensitiveAscii("ortises"),
        dictgen::InsensitiveAscii("ortising"),
        dictgen::InsensitiveAscii("ortization"),
        dictgen::InsensitiveAscii("ortizations"),
        dictgen::InsensitiveAscii("ortize"),
        dictgen::InsensitiveAscii("ortized"),
        dictgen::InsensitiveAscii("ortizes"),
        dictgen::InsensitiveAscii("ortizing"),
        dictgen::InsensitiveAscii("phitheater"),
        dictgen::InsensitiveAscii("phitheaters"),
        dictgen::InsensitiveAscii("phitheatre"),
        dictgen::InsensitiveAscii("phitheatres"),
    ],
    values: &[
        &[(0b10001, &ENTRY_AMOEBA_6065159277789412432)],
        &[(0b10001, &ENTRY_AMOEBAS_14731335040187035859)],
        &[(0b10001, &ENTRY_AMOEBAS_14731335040187035859)],
        &[(0b10001, &ENTRY_AMOEBIC_11458986316626520792)],
        &[(0b10001, &ENTRY_AMOEBOID_15535671593298564900)],
        &[(0b11001, &ENTRY_AMENORRHEA_242453106803645932)],
        &[(0b11001, &ENTRY_AMENORRHEAS_3139958337225187988)],
        &[(0b11010, &ENTRY_AMENORRHEA_242453106803645932)],
        &[(0b11010, &ENTRY_AMENORRHEAS_3139958337225187988)],
        &[(0b10010, &ENTRY_AMERICANIZATION_17361533923238172216)],
        &[(0b10010, &ENTRY_AMERICANIZATIONS_10566116106297564484)],
        &[(0b10010, &ENTRY_AMERICANIZE_17271444033069169029)],
        &[(0b10010, &ENTRY_AMERICANIZED_17030997472393305329)],
        &[(0b10010, &ENTRY_AMERICANIZES_11703695827536694615)],
        &[(0b10010, &ENTRY_AMERICANIZING_2551380555094033314)],
        &[(0b01001, &ENTRY_AMERICANIZATION_17361533923238172216)],
        &[(0b01001, &ENTRY_AMERICANIZATIONS_10566116106297564484)],
        &[(0b01001, &ENTRY_AMERICANIZE_17271444033069169029)],
        &[(0b01001, &ENTRY_AMERICANIZED_17030997472393305329)],
        &[(0b01001, &ENTRY_AMERICANIZES_11703695827536694615)],
        &[(0b01001, &ENTRY_AMERICANIZING_2551380555094033314)],
        &[(0b10010, &ENTRY_AMORTIZATION_18349471581624055412)],
        &[(0b10010, &ENTRY_AMORTIZATIONS_16886902791141844612)],
        &[(0b10010, &ENTRY_AMORTIZE_11005762606748607646)],
        &[(0b10010, &ENTRY_AMORTIZED_2614639190878550237)],
        &[(0b10010, &ENTRY_AMORTIZES_12419679215195830898)],
        &[(0b10010, &ENTRY_AMORTIZING_18247929480308315117)],
        &[(0b01001, &ENTRY_AMORTIZATION_18349471581624055412)],
        &[(0b01001, &ENTRY_AMORTIZATIONS_16886902791141844612)],
        &[(0b01001, &ENTRY_AMORTIZE_11005762606748607646)],
        &[(0b01001, &ENTRY_AMORTIZED_2614639190878550237)],
        &[(0b01001, &ENTRY_AMORTIZES_12419679215195830898)],
        &[(0b01001, &ENTRY_AMORTIZING_18247929480308315117)],
        &[(0b01001, &ENTRY_AMPHITHEATER_13906435369224031259)],
        &[(0b01001, &ENTRY_AMPHITHEATERS_976595961664678124)],
        &[(0b11010, &ENTRY_AMPHITHEATER_13906435369224031259)],
        &[(0b11010, &ENTRY_AMPHITHEATERS_976595961664678124)],
    ],
    range: 3..=14,
};

static VARS_AL_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_AL_CHILDREN),
    value: None,
};

pub static VARS_AL_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("chemise"),
        dictgen::InsensitiveAscii("chemised"),
        dictgen::InsensitiveAscii("chemises"),
        dictgen::InsensitiveAscii("chemising"),
        dictgen::InsensitiveAscii("chemize"),
        dictgen::InsensitiveAscii("chemized"),
        dictgen::InsensitiveAscii("chemizes"),
        dictgen::InsensitiveAscii("chemizing"),
        dictgen::InsensitiveAscii("ine"),
        dictgen::InsensitiveAscii("ined"),
        dictgen::InsensitiveAscii("inement"),
        dictgen::InsensitiveAscii("inements"),
        dictgen::InsensitiveAscii("ines"),
        dictgen::InsensitiveAscii("ining"),
        dictgen::InsensitiveAscii("legorisation"),
        dictgen::InsensitiveAscii("legorisations"),
        dictgen::InsensitiveAscii("legorise"),
        dictgen::InsensitiveAscii("legorised"),
        dictgen::InsensitiveAscii("legorises"),
        dictgen::InsensitiveAscii("legorising"),
        dictgen::InsensitiveAscii("legorization"),
        dictgen::InsensitiveAscii("legorizations"),
        dictgen::InsensitiveAscii("legorize"),
        dictgen::InsensitiveAscii("legorized"),
        dictgen::InsensitiveAscii("legorizes"),
        dictgen::InsensitiveAscii("legorizing"),
        dictgen::InsensitiveAscii("manack"),
        dictgen::InsensitiveAscii("manacks"),
        dictgen::InsensitiveAscii("phabetisation"),
        dictgen::InsensitiveAscii("phabetisations"),
        dictgen::InsensitiveAscii("phabetise"),
        dictgen::InsensitiveAscii("phabetised"),
        dictgen::InsensitiveAscii("phabetises"),
        dictgen::InsensitiveAscii("phabetising"),
        dictgen::InsensitiveAscii("phabetization"),
        dictgen::InsensitiveAscii("phabetizations"),
        dictgen::InsensitiveAscii("phabetize"),
        dictgen::InsensitiveAscii("phabetized"),
        dictgen::InsensitiveAscii("phabetizes"),
        dictgen::InsensitiveAscii("phabetizing"),
        dictgen::InsensitiveAscii("tho"),
        dictgen::InsensitiveAscii("uminise"),
        dictgen::InsensitiveAscii("uminised"),
        dictgen::InsensitiveAscii("uminises"),
        dictgen::InsensitiveAscii("uminising"),
        dictgen::InsensitiveAscii("uminium"),
        dictgen::InsensitiveAscii("uminiums"),
        dictgen::InsensitiveAscii("uminize"),
        dictgen::InsensitiveAscii("uminized"),
        dictgen::InsensitiveAscii("uminizes"),
        dictgen::InsensitiveAscii("uminizing"),
        dictgen::InsensitiveAscii("uminum"),
        dictgen::InsensitiveAscii("uminums"),
    ],
    values: &[
        &[(0b10010, &ENTRY_ALCHEMIZE_4688225926772014989)],
        &[(0b10010, &ENTRY_ALCHEMIZED_970509173487598237)],
        &[(0b10010, &ENTRY_ALCHEMIZES_11682546917258585686)],
        &[(0b10010, &ENTRY_ALCHEMIZING_6827374645777654741)],
        &[(0b01001, &ENTRY_ALCHEMIZE_4688225926772014989)],
        &[(0b01001, &ENTRY_ALCHEMIZED_970509173487598237)],
        &[(0b01001, &ENTRY_ALCHEMIZES_11682546917258585686)],
        &[(0b01001, &ENTRY_ALCHEMIZING_6827374645777654741)],
        &[(0b00001, &ENTRY_ALIGN_4971550510086993659)],
        &[(0b00001, &ENTRY_ALIGNED_8535548357538490917)],
        &[(0b00001, &ENTRY_ALIGNMENT_16172862810825494574)],
        &[(0b00001, &ENTRY_ALIGNMENTS_13271850361761755881)],
        &[(0b00001, &ENTRY_ALIGNS_17212579295098786518)],
        &[(0b00001, &ENTRY_ALIGNING_11906672542962792842)],
        &[(0b10010, &ENTRY_ALLEGORIZATION_4541977880287652521)],
        &[(0b10010, &ENTRY_ALLEGORIZATIONS_8012727316187763644)],
        &[(0b10010, &ENTRY_ALLEGORIZE_8243818793381064842)],
        &[(0b10010, &ENTRY_ALLEGORIZED_15639970683830457866)],
        &[(0b10010, &ENTRY_ALLEGORIZES_264741514106655340)],
        &[(0b10010, &ENTRY_ALLEGORIZING_6032281381406970489)],
        &[(0b01001, &ENTRY_ALLEGORIZATION_4541977880287652521)],
        &[(0b01001, &ENTRY_ALLEGORIZATIONS_8012727316187763644)],
        &[(0b01001, &ENTRY_ALLEGORIZE_8243818793381064842)],
        &[(0b01001, &ENTRY_ALLEGORIZED_15639970683830457866)],
        &[(0b01001, &ENTRY_ALLEGORIZES_264741514106655340)],
        &[(0b01001, &ENTRY_ALLEGORIZING_6032281381406970489)],
        &[(0b10010, &ENTRY_ALMANAC_9022062463507112858)],
        &[(0b10010, &ENTRY_ALMANACS_5174170691068691024)],
        &[(0b10010, &ENTRY_ALPHABETIZATION_1968434628773617953)],
        &[(0b10010, &ENTRY_ALPHABETIZATIONS_6211095631410316582)],
        &[(0b10010, &ENTRY_ALPHABETIZE_17413351134035178681)],
        &[(0b10010, &ENTRY_ALPHABETIZED_2753693013313167498)],
        &[(0b10010, &ENTRY_ALPHABETIZES_5626725721294168785)],
        &[(0b10010, &ENTRY_ALPHABETIZING_3131711685375790300)],
        &[(0b01001, &ENTRY_ALPHABETIZATION_1968434628773617953)],
        &[(0b01001, &ENTRY_ALPHABETIZATIONS_6211095631410316582)],
        &[(0b01001, &ENTRY_ALPHABETIZE_17413351134035178681)],
        &[(0b01001, &ENTRY_ALPHABETIZED_2753693013313167498)],
        &[(0b01001, &ENTRY_ALPHABETIZES_5626725721294168785)],
        &[(0b01001, &ENTRY_ALPHABETIZING_3131711685375790300)],
        &[(0b00001, &ENTRY_ALTHOUGH_1476504865379962577)],
        &[(0b10010, &ENTRY_ALUMINIZE_9483354617585319049)],
        &[(0b10010, &ENTRY_ALUMINIZED_10511736687970899076)],
        &[(0b10010, &ENTRY_ALUMINIZES_13479682276812698370)],
        &[(0b10010, &ENTRY_ALUMINIZING_17184640806714355126)],
        &[(0b10010, &ENTRY_ALUMINUM_14009724291836144060)],
        &[(0b10010, &ENTRY_ALUMINUMS_17635872113099894054)],
        &[(0b01001, &ENTRY_ALUMINIZE_9483354617585319049)],
        &[(0b01001, &ENTRY_ALUMINIZED_10511736687970899076)],
        &[(0b01001, &ENTRY_ALUMINIZES_13479682276812698370)],
        &[(0b01001, &ENTRY_ALUMINIZING_17184640806714355126)],
        &[(0b01001, &ENTRY_ALUMINUM_14009724291836144060)],
        &[(0b01001, &ENTRY_ALUMINUMS_17635872113099894054)],
    ],
    range: 3..=14,
};

static VARS_AI_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_AI_CHILDREN),
    value: None,
};

pub static VARS_AI_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("rfoil"),
        dictgen::InsensitiveAscii("rfoils"),
        dictgen::InsensitiveAscii("rplane"),
        dictgen::InsensitiveAscii("rplanes"),
    ],
    values: &[
        &[(0b01001, &ENTRY_AIRFOIL_8793212550719857477)],
        &[(0b01001, &ENTRY_AIRFOILS_16600511204738890239)],
        &[(0b11001, &ENTRY_AIRPLANE_9809064680775935608)],
        &[(0b11001, &ENTRY_AIRPLANES_7495463879091464018)],
    ],
    range: 5..=7,
};

static VARS_AG_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_AG_CHILDREN),
    value: None,
};

pub static VARS_AG_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("grandise"),
        dictgen::InsensitiveAscii("grandised"),
        dictgen::InsensitiveAscii("grandisement"),
        dictgen::InsensitiveAscii("grandisements"),
        dictgen::InsensitiveAscii("grandiser"),
        dictgen::InsensitiveAscii("grandisers"),
        dictgen::InsensitiveAscii("grandises"),
        dictgen::InsensitiveAscii("grandising"),
        dictgen::InsensitiveAscii("grandize"),
        dictgen::InsensitiveAscii("grandized"),
        dictgen::InsensitiveAscii("grandizement"),
        dictgen::InsensitiveAscii("grandizements"),
        dictgen::InsensitiveAscii("grandizer"),
        dictgen::InsensitiveAscii("grandizers"),
        dictgen::InsensitiveAscii("grandizes"),
        dictgen::InsensitiveAscii("grandizing"),
        dictgen::InsensitiveAscii("onise"),
        dictgen::InsensitiveAscii("onised"),
        dictgen::InsensitiveAscii("onises"),
        dictgen::InsensitiveAscii("onising"),
        dictgen::InsensitiveAscii("onisinglier"),
        dictgen::InsensitiveAscii("onisingliest"),
        dictgen::InsensitiveAscii("onisingly"),
        dictgen::InsensitiveAscii("onize"),
        dictgen::InsensitiveAscii("onized"),
        dictgen::InsensitiveAscii("onizes"),
        dictgen::InsensitiveAscii("onizing"),
        dictgen::InsensitiveAscii("onizinglier"),
        dictgen::InsensitiveAscii("onizingliest"),
        dictgen::InsensitiveAscii("onizingly"),
    ],
    values: &[
        &[(0b10010, &ENTRY_AGGRANDIZE_14928776110274947016)],
        &[(0b10010, &ENTRY_AGGRANDIZED_5678047642823184520)],
        &[(0b10010, &ENTRY_AGGRANDIZEMENT_5112363745808153547)],
        &[(0b10010, &ENTRY_AGGRANDIZEMENTS_13322482535421162803)],
        &[(0b10010, &ENTRY_AGGRANDIZER_14976020900821693201)],
        &[(0b10010, &ENTRY_AGGRANDIZERS_15651589293150719753)],
        &[(0b10010, &ENTRY_AGGRANDIZES_12993795888011857693)],
        &[(0b10010, &ENTRY_AGGRANDIZING_10289964617012803392)],
        &[(0b01001, &ENTRY_AGGRANDIZE_14928776110274947016)],
        &[(0b01001, &ENTRY_AGGRANDIZED_5678047642823184520)],
        &[(0b01001, &ENTRY_AGGRANDIZEMENT_5112363745808153547)],
        &[(0b01001, &ENTRY_AGGRANDIZEMENTS_13322482535421162803)],
        &[(0b01001, &ENTRY_AGGRANDIZER_14976020900821693201)],
        &[(0b01001, &ENTRY_AGGRANDIZERS_15651589293150719753)],
        &[(0b01001, &ENTRY_AGGRANDIZES_12993795888011857693)],
        &[(0b01001, &ENTRY_AGGRANDIZING_10289964617012803392)],
        &[(0b10010, &ENTRY_AGONIZE_14877090130667543233)],
        &[(0b10010, &ENTRY_AGONIZED_17678244103143625810)],
        &[(0b10010, &ENTRY_AGONIZES_14844009888333237557)],
        &[(0b10010, &ENTRY_AGONIZING_14014895105394090708)],
        &[(0b10010, &ENTRY_AGONIZINGLIER_10296833915180893028)],
        &[(0b10010, &ENTRY_AGONIZINGLIEST_3823537194548772440)],
        &[(0b10010, &ENTRY_AGONIZINGLY_5283227355985477567)],
        &[(0b01001, &ENTRY_AGONIZE_14877090130667543233)],
        &[(0b01001, &ENTRY_AGONIZED_17678244103143625810)],
        &[(0b01001, &ENTRY_AGONIZES_14844009888333237557)],
        &[(0b01001, &ENTRY_AGONIZING_14014895105394090708)],
        &[(0b01001, &ENTRY_AGONIZINGLIER_10296833915180893028)],
        &[(0b01001, &ENTRY_AGONIZINGLIEST_3823537194548772440)],
        &[(0b01001, &ENTRY_AGONIZINGLY_5283227355985477567)],
    ],
    range: 5..=13,
};

static VARS_AF_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_AF_CHILDREN),
    value: None,
};

pub static VARS_AF_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("ricanise"),
        dictgen::InsensitiveAscii("ricanised"),
        dictgen::InsensitiveAscii("ricanises"),
        dictgen::InsensitiveAscii("ricanising"),
        dictgen::InsensitiveAscii("ricanize"),
        dictgen::InsensitiveAscii("ricanized"),
        dictgen::InsensitiveAscii("ricanizes"),
        dictgen::InsensitiveAscii("ricanizing"),
        dictgen::InsensitiveAscii("terward"),
    ],
    values: &[
        &[(0b10010, &ENTRY_AFRICANIZE_8899009377488121155)],
        &[(0b10010, &ENTRY_AFRICANIZED_8120286406579238289)],
        &[(0b10010, &ENTRY_AFRICANIZES_422967171139772976)],
        &[(0b10010, &ENTRY_AFRICANIZING_5922056489408751942)],
        &[(0b01001, &ENTRY_AFRICANIZE_8899009377488121155)],
        &[(0b01001, &ENTRY_AFRICANIZED_8120286406579238289)],
        &[(0b01001, &ENTRY_AFRICANIZES_422967171139772976)],
        &[(0b01001, &ENTRY_AFRICANIZING_5922056489408751942)],
        &[(0b01001, &ENTRY_AFTERWARDS_5679799743915530462)],
    ],
    range: 7..=10,
};

static VARS_AE_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_AE_CHILDREN),
    value: None,
};

pub static VARS_AE_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("rofoil"),
        dictgen::InsensitiveAscii("rofoils"),
        dictgen::InsensitiveAscii("roplane"),
        dictgen::InsensitiveAscii("roplanes"),
        dictgen::InsensitiveAscii("sthetician"),
        dictgen::InsensitiveAscii("stheticians"),
        dictgen::InsensitiveAscii("stivate"),
        dictgen::InsensitiveAscii("stivated"),
        dictgen::InsensitiveAscii("stivates"),
        dictgen::InsensitiveAscii("stivating"),
        dictgen::InsensitiveAscii("stivation"),
        dictgen::InsensitiveAscii("stivations"),
        dictgen::InsensitiveAscii("tiologically"),
        dictgen::InsensitiveAscii("tiology"),
    ],
    values: &[
        &[(0b10010, &ENTRY_AIRFOIL_8793212550719857477)],
        &[(0b10010, &ENTRY_AIRFOILS_16600511204738890239)],
        &[(0b10010, &ENTRY_AIRPLANE_9809064680775935608)],
        &[(0b10010, &ENTRY_AIRPLANES_7495463879091464018)],
        &[(0b11010, &ENTRY_ESTHETICIAN_6690642998636082700)],
        &[(0b11010, &ENTRY_ESTHETICIANS_16857352085837156733)],
        &[(0b11010, &ENTRY_ESTIVATE_10836493401844257867)],
        &[(0b11010, &ENTRY_ESTIVATED_5948189904457603376)],
        &[(0b11010, &ENTRY_ESTIVATES_8627334418178723288)],
        &[(0b11010, &ENTRY_ESTIVATING_9498433178617024784)],
        &[(0b11010, &ENTRY_ESTIVATION_6434066985142123064)],
        &[(0b11010, &ENTRY_ESTIVATIONS_15940487245092349305)],
        &[(0b10010, &ENTRY_ETIOLOGICALLY_1064612193650452227)],
        &[(0b10010, &ENTRY_ETIOLOGY_4658311861857715324)],
    ],
    range: 6..=12,
};

static VARS_AD_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_AD_CHILDREN),
    value: None,
};

pub static VARS_AD_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("vertize"),
        dictgen::InsensitiveAscii("vertized"),
        dictgen::InsensitiveAscii("vertizement"),
        dictgen::InsensitiveAscii("vertizements"),
        dictgen::InsensitiveAscii("vertizes"),
        dictgen::InsensitiveAscii("vertizing"),
        dictgen::InsensitiveAscii("z"),
    ],
    values: &[
        &[(0b00001, &ENTRY_ADVERTISE_1587220052516245642)],
        &[(0b00001, &ENTRY_ADVERTISED_16571098524643298315)],
        &[(0b00001, &ENTRY_ADVERTISEMENT_617466274215936600)],
        &[(0b00001, &ENTRY_ADVERTISEMENTS_10822012965069036505)],
        &[(0b00001, &ENTRY_ADVERTISES_18397243032181025507)],
        &[(0b00001, &ENTRY_ADVERTISING_17484433287178545655)],
        &[(0b00001, &ENTRY_ADZE_730807116656886229)],
    ],
    range: 1..=12,
};

static VARS_AC_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_AC_CHILDREN),
    value: None,
};

pub static VARS_AC_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("cessorise"),
        dictgen::InsensitiveAscii("cessorised"),
        dictgen::InsensitiveAscii("cessorises"),
        dictgen::InsensitiveAscii("cessorising"),
        dictgen::InsensitiveAscii("cessorize"),
        dictgen::InsensitiveAscii("cessorized"),
        dictgen::InsensitiveAscii("cessorizes"),
        dictgen::InsensitiveAscii("cessorizing"),
        dictgen::InsensitiveAscii("climatisation"),
        dictgen::InsensitiveAscii("climatise"),
        dictgen::InsensitiveAscii("climatised"),
        dictgen::InsensitiveAscii("climatises"),
        dictgen::InsensitiveAscii("climatising"),
        dictgen::InsensitiveAscii("climatization"),
        dictgen::InsensitiveAscii("climatize"),
        dictgen::InsensitiveAscii("climatized"),
        dictgen::InsensitiveAscii("climatizes"),
        dictgen::InsensitiveAscii("climatizing"),
        dictgen::InsensitiveAscii("couter"),
        dictgen::InsensitiveAscii("coutered"),
        dictgen::InsensitiveAscii("coutering"),
        dictgen::InsensitiveAscii("couterment"),
        dictgen::InsensitiveAscii("couterments"),
        dictgen::InsensitiveAscii("couters"),
        dictgen::InsensitiveAscii("knowledgment"),
        dictgen::InsensitiveAscii("knowledgments"),
        dictgen::InsensitiveAscii("tualisation"),
        dictgen::InsensitiveAscii("tualisations"),
        dictgen::InsensitiveAscii("tualise"),
        dictgen::InsensitiveAscii("tualised"),
        dictgen::InsensitiveAscii("tualises"),
        dictgen::InsensitiveAscii("tualising"),
        dictgen::InsensitiveAscii("tualization"),
        dictgen::InsensitiveAscii("tualizations"),
        dictgen::InsensitiveAscii("tualize"),
        dictgen::InsensitiveAscii("tualized"),
        dictgen::InsensitiveAscii("tualizes"),
        dictgen::InsensitiveAscii("tualizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_ACCESSORIZE_11617210258539552709)],
        &[(0b10010, &ENTRY_ACCESSORIZED_16819425426462683049)],
        &[(0b10010, &ENTRY_ACCESSORIZES_17250993592859046715)],
        &[(0b10010, &ENTRY_ACCESSORIZING_7867120879431421529)],
        &[(0b01001, &ENTRY_ACCESSORIZE_11617210258539552709)],
        &[(0b01001, &ENTRY_ACCESSORIZED_16819425426462683049)],
        &[(0b01001, &ENTRY_ACCESSORIZES_17250993592859046715)],
        &[(0b01001, &ENTRY_ACCESSORIZING_7867120879431421529)],
        &[(0b10010, &ENTRY_ACCLIMATIZATION_17249634281186105692)],
        &[(0b10010, &ENTRY_ACCLIMATIZE_12341890419648119606)],
        &[(0b10010, &ENTRY_ACCLIMATIZED_18204400938003696366)],
        &[(0b10010, &ENTRY_ACCLIMATIZES_11293424161032753847)],
        &[(0b10010, &ENTRY_ACCLIMATIZING_5604828123835799328)],
        &[(0b01001, &ENTRY_ACCLIMATIZATION_17249634281186105692)],
        &[(0b01001, &ENTRY_ACCLIMATIZE_12341890419648119606)],
        &[(0b01001, &ENTRY_ACCLIMATIZED_18204400938003696366)],
        &[(0b01001, &ENTRY_ACCLIMATIZES_11293424161032753847)],
        &[(0b01001, &ENTRY_ACCLIMATIZING_5604828123835799328)],
        &[(0b00001, &ENTRY_ACCOUTER_972199126233896575)],
        &[(0b00001, &ENTRY_ACCOUTERED_1879271502352972191)],
        &[(0b00001, &ENTRY_ACCOUTERING_4561163924549595645)],
        &[(0b00001, &ENTRY_ACCOUTERMENT_9608115872698025560)],
        &[(0b00001, &ENTRY_ACCOUTERMENTS_6877400773059867645)],
        &[(0b00001, &ENTRY_ACCOUTERS_13168290146957425825)],
        &[(0b01001, &ENTRY_ACKNOWLEDGMENT_111837139751826554)],
        &[(0b01001, &ENTRY_ACKNOWLEDGMENTS_11271013032845791746)],
        &[(0b10010, &ENTRY_ACTUALIZATION_4669686872691310817)],
        &[(0b10010, &ENTRY_ACTUALIZATIONS_15085416589313391950)],
        &[(0b10010, &ENTRY_ACTUALIZE_3735240609323878703)],
        &[(0b10010, &ENTRY_ACTUALIZED_16024949220724570012)],
        &[(0b10010, &ENTRY_ACTUALIZES_83603976374293051)],
        &[(0b10010, &ENTRY_ACTUALIZING_1158152971406011993)],
        &[(0b01001, &ENTRY_ACTUALIZATION_4669686872691310817)],
        &[(0b01001, &ENTRY_ACTUALIZATIONS_15085416589313391950)],
        &[(0b01001, &ENTRY_ACTUALIZE_3735240609323878703)],
        &[(0b01001, &ENTRY_ACTUALIZED_16024949220724570012)],
        &[(0b01001, &ENTRY_ACTUALIZES_83603976374293051)],
        &[(0b01001, &ENTRY_ACTUALIZING_1158152971406011993)],
    ],
    range: 6..=13,
};

static VARS_AB_NODE: dictgen::TrieNode<&[(u8, &VariantsMap)]> = dictgen::TrieNode {
    children: dictgen::TrieChild::Flat(&VARS_AB_CHILDREN),
    value: None,
};

pub static VARS_AB_CHILDREN: dictgen::OrderedMap<
    dictgen::InsensitiveAscii<'static>,
    &[(u8, &VariantsMap)],
> = dictgen::OrderedMap {
    keys: &[
        dictgen::InsensitiveAscii("etter"),
        dictgen::InsensitiveAscii("etters"),
        dictgen::InsensitiveAscii("ridgement"),
        dictgen::InsensitiveAscii("ridgements"),
    ],
    values: &[
        &[(0b10011, &ENTRY_ABETTOR_17495586682475011085)],
        &[(0b10011, &ENTRY_ABETTORS_14954007126644140096)],
        &[(0b11010, &ENTRY_ABRIDGMENT_6696980223623735112)],
        &[(0b11010, &ENTRY_ABRIDGMENTS_1895547516404179990)],
    ],
    range: 5..=10,
};

pub const NO_INVALID: bool = true;

pub(crate) static ENTRY_ABETTORS_14954007126644140096: VariantsMap =
    [&["abettors"], &["abetters"], &["abettors"], &["abetters"]];

pub(crate) static ENTRY_ABETTOR_17495586682475011085: VariantsMap =
    [&["abettor"], &["abetter"], &["abettor"], &["abetter"]];

pub(crate) static ENTRY_ABRIDGMENTS_1895547516404179990: VariantsMap = [
    &["abridgments"],
    &["abridgements"],
    &["abridgements"],
    &["abridgements"],
];

pub(crate) static ENTRY_ABRIDGMENT_6696980223623735112: VariantsMap = [
    &["abridgment"],
    &["abridgement"],
    &["abridgement"],
    &["abridgement"],
];

pub(crate) static ENTRY_ACCESSORIZED_16819425426462683049: VariantsMap = [
    &["accessorized"],
    &["accessorised"],
    &["accessorized"],
    &["accessorised"],
];

pub(crate) static ENTRY_ACCESSORIZES_17250993592859046715: VariantsMap = [
    &["accessorizes"],
    &["accessorises"],
    &["accessorizes"],
    &["accessorises"],
];

pub(crate) static ENTRY_ACCESSORIZE_11617210258539552709: VariantsMap = [
    &["accessorize"],
    &["accessorise"],
    &["accessorize"],
    &["accessorise"],
];

pub(crate) static ENTRY_ACCESSORIZING_7867120879431421529: VariantsMap = [
    &["accessorizing"],
    &["accessorising"],
    &["accessorizing"],
    &["accessorising"],
];

pub(crate) static ENTRY_ACCLIMATIZATION_17249634281186105692: VariantsMap = [
    &["acclimatization"],
    &["acclimatisation"],
    &["acclimatization"],
    &["acclimatisation"],
];

pub(crate) static ENTRY_ACCLIMATIZED_18204400938003696366: VariantsMap = [
    &["acclimatized"],
    &["acclimatised"],
    &["acclimatized"],
    &["acclimatised"],
];

pub(crate) static ENTRY_ACCLIMATIZES_11293424161032753847: VariantsMap = [
    &["acclimatizes"],
    &["acclimatises"],
    &["acclimatizes"],
    &["acclimatises"],
];

pub(crate) static ENTRY_ACCLIMATIZE_12341890419648119606: VariantsMap = [
    &["acclimatize"],
    &["acclimatise"],
    &["acclimatize"],
    &["acclimatise"],
];

pub(crate) static ENTRY_ACCLIMATIZING_5604828123835799328: VariantsMap = [
    &["acclimatizing"],
    &["acclimatising"],
    &["acclimatizing"],
    &["acclimatising"],
];

pub(crate) static ENTRY_ACCOUTERED_1879271502352972191: VariantsMap = [
    &["accoutered"],
    &["accoutred"],
    &["accoutred"],
    &["accoutred"],
];

pub(crate) static ENTRY_ACCOUTERING_4561163924549595645: VariantsMap = [
    &["accoutering"],
    &["accoutring"],
    &["accoutring"],
    &["accoutring"],
];

pub(crate) static ENTRY_ACCOUTERMENTS_6877400773059867645: VariantsMap = [
    &["accouterments"],
    &["accoutrements"],
    &["accoutreme