/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta2

import (
	resourcev1beta2 "k8s.io/api/resource/v1beta2"
	v1 "k8s.io/client-go/applyconfigurations/core/v1"
)

// DeviceApplyConfiguration represents a declarative configuration of the Device type for use
// with apply.
//
// Device represents one individual hardware instance that can be selected based
// on its attributes. Besides the name, exactly one field must be set.
type DeviceApplyConfiguration struct {
	// Name is unique identifier among all devices managed by
	// the driver in the pool. It must be a DNS label.
	Name *string `json:"name,omitempty"`
	// Attributes defines the set of attributes for this device.
	// The name of each attribute must be unique in that set.
	//
	// The maximum number of attributes and capacities combined is 32.
	Attributes map[resourcev1beta2.QualifiedName]DeviceAttributeApplyConfiguration `json:"attributes,omitempty"`
	// Capacity defines the set of capacities for this device.
	// The name of each capacity must be unique in that set.
	//
	// The maximum number of attributes and capacities combined is 32.
	Capacity map[resourcev1beta2.QualifiedName]DeviceCapacityApplyConfiguration `json:"capacity,omitempty"`
	// ConsumesCounters defines a list of references to sharedCounters
	// and the set of counters that the device will
	// consume from those counter sets.
	//
	// There can only be a single entry per counterSet.
	//
	// The maximum number of device counter consumptions per
	// device is 2.
	ConsumesCounters []DeviceCounterConsumptionApplyConfiguration `json:"consumesCounters,omitempty"`
	// NodeName identifies the node where the device is available.
	//
	// Must only be set if Spec.PerDeviceNodeSelection is set to true.
	// At most one of NodeName, NodeSelector and AllNodes can be set.
	NodeName *string `json:"nodeName,omitempty"`
	// NodeSelector defines the nodes where the device is available.
	//
	// Must use exactly one term.
	//
	// Must only be set if Spec.PerDeviceNodeSelection is set to true.
	// At most one of NodeName, NodeSelector and AllNodes can be set.
	NodeSelector *v1.NodeSelectorApplyConfiguration `json:"nodeSelector,omitempty"`
	// AllNodes indicates that all nodes have access to the device.
	//
	// Must only be set if Spec.PerDeviceNodeSelection is set to true.
	// At most one of NodeName, NodeSelector and AllNodes can be set.
	AllNodes *bool `json:"allNodes,omitempty"`
	// If specified, these are the driver-defined taints.
	//
	// The maximum number of taints is 16. If taints are set for
	// any device in a ResourceSlice, then the maximum number of
	// allowed devices per ResourceSlice is 64 instead of 128.
	//
	// This is an alpha field and requires enabling the DRADeviceTaints
	// feature gate.
	Taints []DeviceTaintApplyConfiguration `json:"taints,omitempty"`
	// BindsToNode indicates if the usage of an allocation involving this device
	// has to be limited to exactly the node that was chosen when allocating the claim.
	// If set to true, the scheduler will set the ResourceClaim.Status.Allocation.NodeSelector
	// to match the node where the allocation was made.
	//
	// This is an alpha field and requires enabling the DRADeviceBindingConditions and DRAResourceClaimDeviceStatus
	// feature gates.
	BindsToNode *bool `json:"bindsToNode,omitempty"`
	// BindingConditions defines the conditions for proceeding with binding.
	// All of these conditions must be set in the per-device status
	// conditions with a value of True to proceed with binding the pod to the node
	// while scheduling the pod.
	//
	// The maximum number of binding conditions is 4.
	//
	// The conditions must be a valid condition type string.
	//
	// This is an alpha field and requires enabling the DRADeviceBindingConditions and DRAResourceClaimDeviceStatus
	// feature gates.
	BindingConditions []string `json:"bindingConditions,omitempty"`
	// BindingFailureConditions defines the conditions for binding failure.
	// They may be set in the per-device status conditions.
	// If any is set to "True", a binding failure occurred.
	//
	// The maximum number of binding failure conditions is 4.
	//
	// The conditions must be a valid condition type string.
	//
	// This is an alpha field and requires enabling the DRADeviceBindingConditions and DRAResourceClaimDeviceStatus
	// feature gates.
	BindingFailureConditions []string `json:"bindingFailureConditions,omitempty"`
	// AllowMultipleAllocations marks whether the device is allowed to be allocated to multiple DeviceRequests.
	//
	// If AllowMultipleAllocations is set to true, the device can be allocated more than once,
	// and all of its capacity is consumable, regardless of whether the requestPolicy is defined or not.
	AllowMultipleAllocations *bool `json:"allowMultipleAllocations,omitempty"`
}

// DeviceApplyConfiguration constructs a declarative configuration of the Device type for use with
// apply.
func Device() *DeviceApplyConfiguration {
	return &DeviceApplyConfiguration{}
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *DeviceApplyConfiguration) WithName(value string) *DeviceApplyConfiguration {
	b.Name = &value
	return b
}

// WithAttributes puts the entries into the Attributes field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Attributes field,
// overwriting an existing map entries in Attributes field with the same key.
func (b *DeviceApplyConfiguration) WithAttributes(entries map[resourcev1beta2.QualifiedName]DeviceAttributeApplyConfiguration) *DeviceApplyConfiguration {
	if b.Attributes == nil && len(entries) > 0 {
		b.Attributes = make(map[resourcev1beta2.QualifiedName]DeviceAttributeApplyConfiguration, len(entries))
	}
	for k, v := range entries {
		b.Attributes[k] = v
	}
	return b
}

// WithCapacity puts the entries into the Capacity field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Capacity field,
// overwriting an existing map entries in Capacity field with the same key.
func (b *DeviceApplyConfiguration) WithCapacity(entries map[resourcev1beta2.QualifiedName]DeviceCapacityApplyConfiguration) *DeviceApplyConfiguration {
	if b.Capacity == nil && len(entries) > 0 {
		b.Capacity = make(map[resourcev1beta2.QualifiedName]DeviceCapacityApplyConfiguration, len(entries))
	}
	for k, v := range entries {
		b.Capacity[k] = v
	}
	return b
}

// WithConsumesCounters adds the given value to the ConsumesCounters field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the ConsumesCounters field.
func (b *DeviceApplyConfiguration) WithConsumesCounters(values ...*DeviceCounterConsumptionApplyConfiguration) *DeviceApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithConsumesCounters")
		}
		b.ConsumesCounters = append(b.ConsumesCounters, *values[i])
	}
	return b
}

// WithNodeName sets the NodeName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NodeName field is set to the value of the last call.
func (b *DeviceApplyConfiguration) WithNodeName(value string) *DeviceApplyConfiguration {
	b.NodeName = &value
	return b
}

// WithNodeSelector sets the NodeSelector field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NodeSelector field is set to the value of the last call.
func (b *DeviceApplyConfiguration) WithNodeSelector(value *v1.NodeSelectorApplyConfiguration) *DeviceApplyConfiguration {
	b.NodeSelector = value
	return b
}

// WithAllNodes sets the AllNodes field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AllNodes field is set to the value of the last call.
func (b *DeviceApplyConfiguration) WithAllNodes(value bool) *DeviceApplyConfiguration {
	b.AllNodes = &value
	return b
}

// WithTaints adds the given value to the Taints field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Taints field.
func (b *DeviceApplyConfiguration) WithTaints(values ...*DeviceTaintApplyConfiguration) *DeviceApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithTaints")
		}
		b.Taints = append(b.Taints, *values[i])
	}
	return b
}

// WithBindsToNode sets the BindsToNode field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the BindsToNode field is set to the value of the last call.
func (b *DeviceApplyConfiguration) WithBindsToNode(value bool) *DeviceApplyConfiguration {
	b.BindsToNode = &value
	return b
}

// WithBindingConditions adds the given value to the BindingConditions field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the BindingConditions field.
func (b *DeviceApplyConfiguration) WithBindingConditions(values ...string) *DeviceApplyConfiguration {
	for i := range values {
		b.BindingConditions = append(b.BindingConditions, values[i])
	}
	return b
}

// WithBindingFailureConditions adds the given value to the BindingFailureConditions field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the BindingFailureConditions field.
func (b *DeviceApplyConfiguration) WithBindingFailureConditions(values ...string) *DeviceApplyConfiguration {
	for i := range values {
		b.BindingFailureConditions = append(b.BindingFailureConditions, values[i])
	}
	return b
}

// WithAllowMultipleAllocations sets the AllowMultipleAllocations field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AllowMultipleAllocations field is set to the value of the last call.
func (b *DeviceApplyConfiguration) WithAllowMultipleAllocations(value bool) *DeviceApplyConfiguration {
	b.AllowMultipleAllocations = &value
	return b
}
