/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "common-dbus.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_message,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectBooleanFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gboolean arg_e,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectBooleanFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectBooleanFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_boolean (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_application_name,
        const gchar *arg_reason_for_inhibit,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        guint arg_cookie,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_uint (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_BOOLEAN (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringBooleanFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_message,
        gboolean arg_fatal,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringBooleanFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringBooleanFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_boolean (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_UINT_STRING_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringUintStringUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_app_id,
        guint arg_toplevel_xid,
        const gchar *arg_reason,
        guint arg_flags,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringUintStringUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 6);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringUintStringUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_uint (param_values + 3),
              g_marshal_value_peek_string (param_values + 4),
              g_marshal_value_peek_uint (param_values + 5),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN_BOOLEAN_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectBooleanBooleanStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gboolean arg_include_cursor,
        gboolean arg_flash,
        const gchar *arg_filename,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectBooleanBooleanStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectBooleanBooleanStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_boolean (param_values + 2),
              g_marshal_value_peek_boolean (param_values + 3),
              g_marshal_value_peek_string (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN_BOOLEAN_BOOLEAN_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectBooleanBooleanBooleanStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gboolean arg_include_frame,
        gboolean arg_include_cursor,
        gboolean arg_flash,
        const gchar *arg_filename,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectBooleanBooleanBooleanStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 6);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectBooleanBooleanBooleanStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_boolean (param_values + 2),
              g_marshal_value_peek_boolean (param_values + 3),
              g_marshal_value_peek_boolean (param_values + 4),
              g_marshal_value_peek_string (param_values + 5),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_INT_INT_INT_BOOLEAN_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectIntIntIntIntBooleanStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gint arg_x,
        gint arg_y,
        gint arg_width,
        gint arg_height,
        gboolean arg_flash,
        const gchar *arg_filename,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectIntIntIntIntBooleanStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 8);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectIntIntIntIntBooleanStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_int (param_values + 2),
              g_marshal_value_peek_int (param_values + 3),
              g_marshal_value_peek_int (param_values + 4),
              g_marshal_value_peek_int (param_values + 5),
              g_marshal_value_peek_boolean (param_values + 6),
              g_marshal_value_peek_string (param_values + 7),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_INT_INT_INT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectIntIntIntIntFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gint arg_x,
        gint arg_y,
        gint arg_width,
        gint arg_height,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectIntIntIntIntFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 6);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectIntIntIntIntFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_int (param_values + 2),
              g_marshal_value_peek_int (param_values + 3),
              g_marshal_value_peek_int (param_values + 4),
              g_marshal_value_peek_int (param_values + 5),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.cinnamon.PortalHandlers
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:OrgCinnamonPortalHandlers
 * @title: OrgCinnamonPortalHandlers
 * @short_description: Generated C code for the org.cinnamon.PortalHandlers D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-cinnamon-PortalHandlers.top_of_page">org.cinnamon.PortalHandlers</link> D-Bus interface in C.
 */

enum
{
  _ORG_CINNAMON_PORTAL_HANDLERS_RUNNING_APPS_CHANGED,
};

static unsigned _ORG_CINNAMON_PORTAL_HANDLERS_SIGNALS[1] = { 0 };

/* ---- Introspection data for org.cinnamon.PortalHandlers ---- */

static const _ExtendedGDBusArgInfo _org_cinnamon_portal_handlers_method_info_get_app_states_OUT_ARG_apps =
{
  {
    -1,
    (gchar *) "apps",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_cinnamon_portal_handlers_method_info_get_app_states_OUT_ARG_pointers[] =
{
  &_org_cinnamon_portal_handlers_method_info_get_app_states_OUT_ARG_apps.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_cinnamon_portal_handlers_method_info_get_app_states =
{
  {
    -1,
    (gchar *) "GetAppStates",
    NULL,
    (GDBusArgInfo **) &_org_cinnamon_portal_handlers_method_info_get_app_states_OUT_ARG_pointers,
    NULL
  },
  "handle-get-app-states",
  FALSE
};

static const GDBusMethodInfo * const _org_cinnamon_portal_handlers_method_info_pointers[] =
{
  &_org_cinnamon_portal_handlers_method_info_get_app_states.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _org_cinnamon_portal_handlers_signal_info_running_apps_changed =
{
  {
    -1,
    (gchar *) "RunningAppsChanged",
    NULL,
    NULL
  },
  "running-apps-changed"
};

static const GDBusSignalInfo * const _org_cinnamon_portal_handlers_signal_info_pointers[] =
{
  &_org_cinnamon_portal_handlers_signal_info_running_apps_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _org_cinnamon_portal_handlers_interface_info =
{
  {
    -1,
    (gchar *) "org.cinnamon.PortalHandlers",
    (GDBusMethodInfo **) &_org_cinnamon_portal_handlers_method_info_pointers,
    (GDBusSignalInfo **) &_org_cinnamon_portal_handlers_signal_info_pointers,
    NULL,
    NULL
  },
  "org-cinnamon-portal-handlers",
};


/**
 * org_cinnamon_portal_handlers_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-cinnamon-PortalHandlers.top_of_page">org.cinnamon.PortalHandlers</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
org_cinnamon_portal_handlers_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_org_cinnamon_portal_handlers_interface_info.parent_struct;
}

/**
 * org_cinnamon_portal_handlers_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #OrgCinnamonPortalHandlers interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
org_cinnamon_portal_handlers_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
org_cinnamon_portal_handlers_signal_marshal_running_apps_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_cinnamon_portal_handlers_method_marshal_get_app_states (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * OrgCinnamonPortalHandlers:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-cinnamon-PortalHandlers.top_of_page">org.cinnamon.PortalHandlers</link>.
 */

/**
 * OrgCinnamonPortalHandlersIface:
 * @parent_iface: The parent interface.
 * @handle_get_app_states: Handler for the #OrgCinnamonPortalHandlers::handle-get-app-states signal.
 * @running_apps_changed: Handler for the #OrgCinnamonPortalHandlers::running-apps-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-cinnamon-PortalHandlers.top_of_page">org.cinnamon.PortalHandlers</link>.
 */

typedef OrgCinnamonPortalHandlersIface OrgCinnamonPortalHandlersInterface;
G_DEFINE_INTERFACE (OrgCinnamonPortalHandlers, org_cinnamon_portal_handlers, G_TYPE_OBJECT)

static void
org_cinnamon_portal_handlers_default_init (OrgCinnamonPortalHandlersIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * OrgCinnamonPortalHandlers::handle-get-app-states:
   * @object: A #OrgCinnamonPortalHandlers.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-cinnamon-PortalHandlers.GetAppStates">GetAppStates()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_cinnamon_portal_handlers_complete_get_app_states() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-app-states",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgCinnamonPortalHandlersIface, handle_get_app_states),
    g_signal_accumulator_true_handled,
    NULL,
      org_cinnamon_portal_handlers_method_marshal_get_app_states,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * OrgCinnamonPortalHandlers::running-apps-changed:
   * @object: A #OrgCinnamonPortalHandlers.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-cinnamon-PortalHandlers.RunningAppsChanged">"RunningAppsChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  _ORG_CINNAMON_PORTAL_HANDLERS_SIGNALS[_ORG_CINNAMON_PORTAL_HANDLERS_RUNNING_APPS_CHANGED] =
    g_signal_new ("running-apps-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (OrgCinnamonPortalHandlersIface, running_apps_changed),
      NULL,
      NULL,
      org_cinnamon_portal_handlers_signal_marshal_running_apps_changed,
      G_TYPE_NONE,
      0);

}

/**
 * org_cinnamon_portal_handlers_emit_running_apps_changed:
 * @object: A #OrgCinnamonPortalHandlers.
 *
 * Emits the <link linkend="gdbus-signal-org-cinnamon-PortalHandlers.RunningAppsChanged">"RunningAppsChanged"</link> D-Bus signal.
 */
void
org_cinnamon_portal_handlers_emit_running_apps_changed (
    OrgCinnamonPortalHandlers *object)
{
  g_signal_emit (object, _ORG_CINNAMON_PORTAL_HANDLERS_SIGNALS[_ORG_CINNAMON_PORTAL_HANDLERS_RUNNING_APPS_CHANGED], 0);
}

/**
 * org_cinnamon_portal_handlers_call_get_app_states:
 * @proxy: A #OrgCinnamonPortalHandlersProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-cinnamon-PortalHandlers.GetAppStates">GetAppStates()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_cinnamon_portal_handlers_call_get_app_states_finish() to get the result of the operation.
 *
 * See org_cinnamon_portal_handlers_call_get_app_states_sync() for the synchronous, blocking version of this method.
 */
void
org_cinnamon_portal_handlers_call_get_app_states (
    OrgCinnamonPortalHandlers *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetAppStates",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_cinnamon_portal_handlers_call_get_app_states_finish:
 * @proxy: A #OrgCinnamonPortalHandlersProxy.
 * @out_apps: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_cinnamon_portal_handlers_call_get_app_states().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_cinnamon_portal_handlers_call_get_app_states().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_cinnamon_portal_handlers_call_get_app_states_finish (
    OrgCinnamonPortalHandlers *proxy,
    GVariant **out_apps,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_apps);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_cinnamon_portal_handlers_call_get_app_states_sync:
 * @proxy: A #OrgCinnamonPortalHandlersProxy.
 * @out_apps: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-cinnamon-PortalHandlers.GetAppStates">GetAppStates()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_cinnamon_portal_handlers_call_get_app_states() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_cinnamon_portal_handlers_call_get_app_states_sync (
    OrgCinnamonPortalHandlers *proxy,
    GVariant **out_apps,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetAppStates",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_apps);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_cinnamon_portal_handlers_complete_get_app_states:
 * @object: A #OrgCinnamonPortalHandlers.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @apps: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-cinnamon-PortalHandlers.GetAppStates">GetAppStates()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_cinnamon_portal_handlers_complete_get_app_states (
    OrgCinnamonPortalHandlers *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *apps)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sv})",
                   apps));
}

/* ------------------------------------------------------------------------ */

/**
 * OrgCinnamonPortalHandlersProxy:
 *
 * The #OrgCinnamonPortalHandlersProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgCinnamonPortalHandlersProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgCinnamonPortalHandlersProxy.
 */

struct _OrgCinnamonPortalHandlersProxyPrivate
{
  GData *qdata;
};

static void org_cinnamon_portal_handlers_proxy_iface_init (OrgCinnamonPortalHandlersIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgCinnamonPortalHandlersProxy, org_cinnamon_portal_handlers_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (OrgCinnamonPortalHandlersProxy)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_CINNAMON_PORTAL_HANDLERS, org_cinnamon_portal_handlers_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgCinnamonPortalHandlersProxy, org_cinnamon_portal_handlers_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_CINNAMON_PORTAL_HANDLERS, org_cinnamon_portal_handlers_proxy_iface_init))

#endif
static void
org_cinnamon_portal_handlers_proxy_finalize (GObject *object)
{
  OrgCinnamonPortalHandlersProxy *proxy = ORG_CINNAMON_PORTAL_HANDLERS_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (org_cinnamon_portal_handlers_proxy_parent_class)->finalize (object);
}

static void
org_cinnamon_portal_handlers_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
org_cinnamon_portal_handlers_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
org_cinnamon_portal_handlers_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_org_cinnamon_portal_handlers_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TYPE_ORG_CINNAMON_PORTAL_HANDLERS);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_CINNAMON_PORTAL_HANDLERS);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
org_cinnamon_portal_handlers_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  OrgCinnamonPortalHandlersProxy *proxy = ORG_CINNAMON_PORTAL_HANDLERS_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_cinnamon_portal_handlers_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_cinnamon_portal_handlers_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
org_cinnamon_portal_handlers_proxy_init (OrgCinnamonPortalHandlersProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = org_cinnamon_portal_handlers_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TYPE_ORG_CINNAMON_PORTAL_HANDLERS_PROXY, OrgCinnamonPortalHandlersProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), org_cinnamon_portal_handlers_interface_info ());
}

static void
org_cinnamon_portal_handlers_proxy_class_init (OrgCinnamonPortalHandlersProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = org_cinnamon_portal_handlers_proxy_finalize;
  gobject_class->get_property = org_cinnamon_portal_handlers_proxy_get_property;
  gobject_class->set_property = org_cinnamon_portal_handlers_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = org_cinnamon_portal_handlers_proxy_g_signal;
  proxy_class->g_properties_changed = org_cinnamon_portal_handlers_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgCinnamonPortalHandlersProxyPrivate));
#endif
}

static void
org_cinnamon_portal_handlers_proxy_iface_init (OrgCinnamonPortalHandlersIface *iface G_GNUC_UNUSED)
{
}

/**
 * org_cinnamon_portal_handlers_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-cinnamon-PortalHandlers.top_of_page">org.cinnamon.PortalHandlers</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_cinnamon_portal_handlers_proxy_new_finish() to get the result of the operation.
 *
 * See org_cinnamon_portal_handlers_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
org_cinnamon_portal_handlers_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_CINNAMON_PORTAL_HANDLERS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.cinnamon.PortalHandlers", NULL);
}

/**
 * org_cinnamon_portal_handlers_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_cinnamon_portal_handlers_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_cinnamon_portal_handlers_proxy_new().
 *
 * Returns: (transfer full) (type OrgCinnamonPortalHandlersProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgCinnamonPortalHandlers *
org_cinnamon_portal_handlers_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_CINNAMON_PORTAL_HANDLERS (ret);
  else
    return NULL;
}

/**
 * org_cinnamon_portal_handlers_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-cinnamon-PortalHandlers.top_of_page">org.cinnamon.PortalHandlers</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_cinnamon_portal_handlers_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgCinnamonPortalHandlersProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgCinnamonPortalHandlers *
org_cinnamon_portal_handlers_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_CINNAMON_PORTAL_HANDLERS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.cinnamon.PortalHandlers", NULL);
  if (ret != NULL)
    return ORG_CINNAMON_PORTAL_HANDLERS (ret);
  else
    return NULL;
}


/**
 * org_cinnamon_portal_handlers_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like org_cinnamon_portal_handlers_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_cinnamon_portal_handlers_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See org_cinnamon_portal_handlers_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
org_cinnamon_portal_handlers_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_CINNAMON_PORTAL_HANDLERS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.cinnamon.PortalHandlers", NULL);
}

/**
 * org_cinnamon_portal_handlers_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_cinnamon_portal_handlers_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_cinnamon_portal_handlers_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type OrgCinnamonPortalHandlersProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgCinnamonPortalHandlers *
org_cinnamon_portal_handlers_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_CINNAMON_PORTAL_HANDLERS (ret);
  else
    return NULL;
}

/**
 * org_cinnamon_portal_handlers_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like org_cinnamon_portal_handlers_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_cinnamon_portal_handlers_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgCinnamonPortalHandlersProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgCinnamonPortalHandlers *
org_cinnamon_portal_handlers_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_CINNAMON_PORTAL_HANDLERS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.cinnamon.PortalHandlers", NULL);
  if (ret != NULL)
    return ORG_CINNAMON_PORTAL_HANDLERS (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * OrgCinnamonPortalHandlersSkeleton:
 *
 * The #OrgCinnamonPortalHandlersSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgCinnamonPortalHandlersSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgCinnamonPortalHandlersSkeleton.
 */

struct _OrgCinnamonPortalHandlersSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_org_cinnamon_portal_handlers_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  OrgCinnamonPortalHandlersSkeleton *skeleton = ORG_CINNAMON_PORTAL_HANDLERS_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TYPE_ORG_CINNAMON_PORTAL_HANDLERS);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_CINNAMON_PORTAL_HANDLERS);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_org_cinnamon_portal_handlers_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  OrgCinnamonPortalHandlersSkeleton *skeleton = ORG_CINNAMON_PORTAL_HANDLERS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_cinnamon_portal_handlers_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_org_cinnamon_portal_handlers_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  OrgCinnamonPortalHandlersSkeleton *skeleton = ORG_CINNAMON_PORTAL_HANDLERS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_cinnamon_portal_handlers_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _org_cinnamon_portal_handlers_skeleton_vtable =
{
  _org_cinnamon_portal_handlers_skeleton_handle_method_call,
  _org_cinnamon_portal_handlers_skeleton_handle_get_property,
  _org_cinnamon_portal_handlers_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
org_cinnamon_portal_handlers_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return org_cinnamon_portal_handlers_interface_info ();
}

static GDBusInterfaceVTable *
org_cinnamon_portal_handlers_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_org_cinnamon_portal_handlers_skeleton_vtable;
}

static GVariant *
org_cinnamon_portal_handlers_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  OrgCinnamonPortalHandlersSkeleton *skeleton = ORG_CINNAMON_PORTAL_HANDLERS_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_org_cinnamon_portal_handlers_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _org_cinnamon_portal_handlers_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _org_cinnamon_portal_handlers_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _org_cinnamon_portal_handlers_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.cinnamon.PortalHandlers", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
org_cinnamon_portal_handlers_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_org_cinnamon_portal_handlers_on_signal_running_apps_changed (
    OrgCinnamonPortalHandlers *object)
{
  OrgCinnamonPortalHandlersSkeleton *skeleton = ORG_CINNAMON_PORTAL_HANDLERS_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.cinnamon.PortalHandlers", "RunningAppsChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void org_cinnamon_portal_handlers_skeleton_iface_init (OrgCinnamonPortalHandlersIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgCinnamonPortalHandlersSkeleton, org_cinnamon_portal_handlers_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (OrgCinnamonPortalHandlersSkeleton)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_CINNAMON_PORTAL_HANDLERS, org_cinnamon_portal_handlers_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgCinnamonPortalHandlersSkeleton, org_cinnamon_portal_handlers_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_CINNAMON_PORTAL_HANDLERS, org_cinnamon_portal_handlers_skeleton_iface_init))

#endif
static void
org_cinnamon_portal_handlers_skeleton_finalize (GObject *object)
{
  OrgCinnamonPortalHandlersSkeleton *skeleton = ORG_CINNAMON_PORTAL_HANDLERS_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (org_cinnamon_portal_handlers_skeleton_parent_class)->finalize (object);
}

static void
org_cinnamon_portal_handlers_skeleton_init (OrgCinnamonPortalHandlersSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = org_cinnamon_portal_handlers_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TYPE_ORG_CINNAMON_PORTAL_HANDLERS_SKELETON, OrgCinnamonPortalHandlersSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
org_cinnamon_portal_handlers_skeleton_class_init (OrgCinnamonPortalHandlersSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = org_cinnamon_portal_handlers_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = org_cinnamon_portal_handlers_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = org_cinnamon_portal_handlers_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = org_cinnamon_portal_handlers_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = org_cinnamon_portal_handlers_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgCinnamonPortalHandlersSkeletonPrivate));
#endif
}

static void
org_cinnamon_portal_handlers_skeleton_iface_init (OrgCinnamonPortalHandlersIface *iface)
{
  iface->running_apps_changed = _org_cinnamon_portal_handlers_on_signal_running_apps_changed;
}

/**
 * org_cinnamon_portal_handlers_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-cinnamon-PortalHandlers.top_of_page">org.cinnamon.PortalHandlers</link>.
 *
 * Returns: (transfer full) (type OrgCinnamonPortalHandlersSkeleton): The skeleton object.
 */
OrgCinnamonPortalHandlers *
org_cinnamon_portal_handlers_skeleton_new (void)
{
  return ORG_CINNAMON_PORTAL_HANDLERS (g_object_new (TYPE_ORG_CINNAMON_PORTAL_HANDLERS_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.cinnamon.ScreenSaver
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:OrgCinnamonScreenSaver
 * @title: OrgCinnamonScreenSaver
 * @short_description: Generated C code for the org.cinnamon.ScreenSaver D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-cinnamon-ScreenSaver.top_of_page">org.cinnamon.ScreenSaver</link> D-Bus interface in C.
 */

enum
{
  _ORG_CINNAMON_SCREEN_SAVER_ACTIVE_CHANGED,
};

static unsigned _ORG_CINNAMON_SCREEN_SAVER_SIGNALS[1] = { 0 };

/* ---- Introspection data for org.cinnamon.ScreenSaver ---- */

static const _ExtendedGDBusArgInfo _org_cinnamon_screen_saver_method_info_lock_IN_ARG_message =
{
  {
    -1,
    (gchar *) "message",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_cinnamon_screen_saver_method_info_lock_IN_ARG_pointers[] =
{
  &_org_cinnamon_screen_saver_method_info_lock_IN_ARG_message.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_cinnamon_screen_saver_method_info_lock =
{
  {
    -1,
    (gchar *) "Lock",
    (GDBusArgInfo **) &_org_cinnamon_screen_saver_method_info_lock_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-lock",
  FALSE
};

static const _ExtendedGDBusMethodInfo _org_cinnamon_screen_saver_method_info_simulate_user_activity =
{
  {
    -1,
    (gchar *) "SimulateUserActivity",
    NULL,
    NULL,
    NULL
  },
  "handle-simulate-user-activity",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_cinnamon_screen_saver_method_info_get_active_OUT_ARG_arg_0 =
{
  {
    -1,
    (gchar *) "arg_0",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_cinnamon_screen_saver_method_info_get_active_OUT_ARG_pointers[] =
{
  &_org_cinnamon_screen_saver_method_info_get_active_OUT_ARG_arg_0.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_cinnamon_screen_saver_method_info_get_active =
{
  {
    -1,
    (gchar *) "GetActive",
    NULL,
    (GDBusArgInfo **) &_org_cinnamon_screen_saver_method_info_get_active_OUT_ARG_pointers,
    NULL
  },
  "handle-get-active",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_cinnamon_screen_saver_method_info_get_active_time_OUT_ARG_seconds =
{
  {
    -1,
    (gchar *) "seconds",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_cinnamon_screen_saver_method_info_get_active_time_OUT_ARG_pointers[] =
{
  &_org_cinnamon_screen_saver_method_info_get_active_time_OUT_ARG_seconds.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_cinnamon_screen_saver_method_info_get_active_time =
{
  {
    -1,
    (gchar *) "GetActiveTime",
    NULL,
    (GDBusArgInfo **) &_org_cinnamon_screen_saver_method_info_get_active_time_OUT_ARG_pointers,
    NULL
  },
  "handle-get-active-time",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_cinnamon_screen_saver_method_info_get_session_idle_time_OUT_ARG_seconds =
{
  {
    -1,
    (gchar *) "seconds",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_cinnamon_screen_saver_method_info_get_session_idle_time_OUT_ARG_pointers[] =
{
  &_org_cinnamon_screen_saver_method_info_get_session_idle_time_OUT_ARG_seconds.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_cinnamon_screen_saver_method_info_get_session_idle_time =
{
  {
    -1,
    (gchar *) "GetSessionIdleTime",
    NULL,
    (GDBusArgInfo **) &_org_cinnamon_screen_saver_method_info_get_session_idle_time_OUT_ARG_pointers,
    NULL
  },
  "handle-get-session-idle-time",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_cinnamon_screen_saver_method_info_set_active_IN_ARG_e =
{
  {
    -1,
    (gchar *) "e",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_cinnamon_screen_saver_method_info_set_active_IN_ARG_pointers[] =
{
  &_org_cinnamon_screen_saver_method_info_set_active_IN_ARG_e.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_cinnamon_screen_saver_method_info_set_active =
{
  {
    -1,
    (gchar *) "SetActive",
    (GDBusArgInfo **) &_org_cinnamon_screen_saver_method_info_set_active_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-active",
  FALSE
};

static const _ExtendedGDBusMethodInfo _org_cinnamon_screen_saver_method_info_quit =
{
  {
    -1,
    (gchar *) "Quit",
    NULL,
    NULL,
    NULL
  },
  "handle-quit",
  FALSE
};

static const GDBusMethodInfo * const _org_cinnamon_screen_saver_method_info_pointers[] =
{
  &_org_cinnamon_screen_saver_method_info_lock.parent_struct,
  &_org_cinnamon_screen_saver_method_info_simulate_user_activity.parent_struct,
  &_org_cinnamon_screen_saver_method_info_get_active.parent_struct,
  &_org_cinnamon_screen_saver_method_info_get_active_time.parent_struct,
  &_org_cinnamon_screen_saver_method_info_get_session_idle_time.parent_struct,
  &_org_cinnamon_screen_saver_method_info_set_active.parent_struct,
  &_org_cinnamon_screen_saver_method_info_quit.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_cinnamon_screen_saver_signal_info_active_changed_ARG_arg_0 =
{
  {
    -1,
    (gchar *) "arg_0",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_cinnamon_screen_saver_signal_info_active_changed_ARG_pointers[] =
{
  &_org_cinnamon_screen_saver_signal_info_active_changed_ARG_arg_0.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _org_cinnamon_screen_saver_signal_info_active_changed =
{
  {
    -1,
    (gchar *) "ActiveChanged",
    (GDBusArgInfo **) &_org_cinnamon_screen_saver_signal_info_active_changed_ARG_pointers,
    NULL
  },
  "active-changed"
};

static const GDBusSignalInfo * const _org_cinnamon_screen_saver_signal_info_pointers[] =
{
  &_org_cinnamon_screen_saver_signal_info_active_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _org_cinnamon_screen_saver_interface_info =
{
  {
    -1,
    (gchar *) "org.cinnamon.ScreenSaver",
    (GDBusMethodInfo **) &_org_cinnamon_screen_saver_method_info_pointers,
    (GDBusSignalInfo **) &_org_cinnamon_screen_saver_signal_info_pointers,
    NULL,
    NULL
  },
  "org-cinnamon-screen-saver",
};


/**
 * org_cinnamon_screen_saver_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-cinnamon-ScreenSaver.top_of_page">org.cinnamon.ScreenSaver</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
org_cinnamon_screen_saver_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_org_cinnamon_screen_saver_interface_info.parent_struct;
}

/**
 * org_cinnamon_screen_saver_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #OrgCinnamonScreenSaver interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
org_cinnamon_screen_saver_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
org_cinnamon_screen_saver_signal_marshal_active_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_cinnamon_screen_saver_method_marshal_lock (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_cinnamon_screen_saver_method_marshal_simulate_user_activity (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_cinnamon_screen_saver_method_marshal_get_active (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_cinnamon_screen_saver_method_marshal_get_active_time (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_cinnamon_screen_saver_method_marshal_get_session_idle_time (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_cinnamon_screen_saver_method_marshal_set_active (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_cinnamon_screen_saver_method_marshal_quit (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * OrgCinnamonScreenSaver:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-cinnamon-ScreenSaver.top_of_page">org.cinnamon.ScreenSaver</link>.
 */

/**
 * OrgCinnamonScreenSaverIface:
 * @parent_iface: The parent interface.
 * @handle_get_active: Handler for the #OrgCinnamonScreenSaver::handle-get-active signal.
 * @handle_get_active_time: Handler for the #OrgCinnamonScreenSaver::handle-get-active-time signal.
 * @handle_get_session_idle_time: Handler for the #OrgCinnamonScreenSaver::handle-get-session-idle-time signal.
 * @handle_lock: Handler for the #OrgCinnamonScreenSaver::handle-lock signal.
 * @handle_quit: Handler for the #OrgCinnamonScreenSaver::handle-quit signal.
 * @handle_set_active: Handler for the #OrgCinnamonScreenSaver::handle-set-active signal.
 * @handle_simulate_user_activity: Handler for the #OrgCinnamonScreenSaver::handle-simulate-user-activity signal.
 * @active_changed: Handler for the #OrgCinnamonScreenSaver::active-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-cinnamon-ScreenSaver.top_of_page">org.cinnamon.ScreenSaver</link>.
 */

typedef OrgCinnamonScreenSaverIface OrgCinnamonScreenSaverInterface;
G_DEFINE_INTERFACE (OrgCinnamonScreenSaver, org_cinnamon_screen_saver, G_TYPE_OBJECT)

static void
org_cinnamon_screen_saver_default_init (OrgCinnamonScreenSaverIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * OrgCinnamonScreenSaver::handle-lock:
   * @object: A #OrgCinnamonScreenSaver.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_message: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-cinnamon-ScreenSaver.Lock">Lock()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_cinnamon_screen_saver_complete_lock() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-lock",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgCinnamonScreenSaverIface, handle_lock),
    g_signal_accumulator_true_handled,
    NULL,
      org_cinnamon_screen_saver_method_marshal_lock,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * OrgCinnamonScreenSaver::handle-simulate-user-activity:
   * @object: A #OrgCinnamonScreenSaver.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-cinnamon-ScreenSaver.SimulateUserActivity">SimulateUserActivity()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_cinnamon_screen_saver_complete_simulate_user_activity() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-simulate-user-activity",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgCinnamonScreenSaverIface, handle_simulate_user_activity),
    g_signal_accumulator_true_handled,
    NULL,
      org_cinnamon_screen_saver_method_marshal_simulate_user_activity,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * OrgCinnamonScreenSaver::handle-get-active:
   * @object: A #OrgCinnamonScreenSaver.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-cinnamon-ScreenSaver.GetActive">GetActive()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_cinnamon_screen_saver_complete_get_active() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-active",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgCinnamonScreenSaverIface, handle_get_active),
    g_signal_accumulator_true_handled,
    NULL,
      org_cinnamon_screen_saver_method_marshal_get_active,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * OrgCinnamonScreenSaver::handle-get-active-time:
   * @object: A #OrgCinnamonScreenSaver.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-cinnamon-ScreenSaver.GetActiveTime">GetActiveTime()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_cinnamon_screen_saver_complete_get_active_time() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-active-time",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgCinnamonScreenSaverIface, handle_get_active_time),
    g_signal_accumulator_true_handled,
    NULL,
      org_cinnamon_screen_saver_method_marshal_get_active_time,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * OrgCinnamonScreenSaver::handle-get-session-idle-time:
   * @object: A #OrgCinnamonScreenSaver.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-cinnamon-ScreenSaver.GetSessionIdleTime">GetSessionIdleTime()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_cinnamon_screen_saver_complete_get_session_idle_time() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-session-idle-time",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgCinnamonScreenSaverIface, handle_get_session_idle_time),
    g_signal_accumulator_true_handled,
    NULL,
      org_cinnamon_screen_saver_method_marshal_get_session_idle_time,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * OrgCinnamonScreenSaver::handle-set-active:
   * @object: A #OrgCinnamonScreenSaver.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_e: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-cinnamon-ScreenSaver.SetActive">SetActive()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_cinnamon_screen_saver_complete_set_active() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-active",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgCinnamonScreenSaverIface, handle_set_active),
    g_signal_accumulator_true_handled,
    NULL,
      org_cinnamon_screen_saver_method_marshal_set_active,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN);

  /**
   * OrgCinnamonScreenSaver::handle-quit:
   * @object: A #OrgCinnamonScreenSaver.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-cinnamon-ScreenSaver.Quit">Quit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_cinnamon_screen_saver_complete_quit() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-quit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgCinnamonScreenSaverIface, handle_quit),
    g_signal_accumulator_true_handled,
    NULL,
      org_cinnamon_screen_saver_method_marshal_quit,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * OrgCinnamonScreenSaver::active-changed:
   * @object: A #OrgCinnamonScreenSaver.
   * @arg_arg_0: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-cinnamon-ScreenSaver.ActiveChanged">"ActiveChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  _ORG_CINNAMON_SCREEN_SAVER_SIGNALS[_ORG_CINNAMON_SCREEN_SAVER_ACTIVE_CHANGED] =
    g_signal_new ("active-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (OrgCinnamonScreenSaverIface, active_changed),
      NULL,
      NULL,
      org_cinnamon_screen_saver_signal_marshal_active_changed,
      G_TYPE_NONE,
      1, G_TYPE_BOOLEAN);

}

/**
 * org_cinnamon_screen_saver_emit_active_changed:
 * @object: A #OrgCinnamonScreenSaver.
 * @arg_arg_0: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-cinnamon-ScreenSaver.ActiveChanged">"ActiveChanged"</link> D-Bus signal.
 */
void
org_cinnamon_screen_saver_emit_active_changed (
    OrgCinnamonScreenSaver *object,
    gboolean arg_arg_0)
{
  g_signal_emit (object, _ORG_CINNAMON_SCREEN_SAVER_SIGNALS[_ORG_CINNAMON_SCREEN_SAVER_ACTIVE_CHANGED], 0, arg_arg_0);
}

/**
 * org_cinnamon_screen_saver_call_lock:
 * @proxy: A #OrgCinnamonScreenSaverProxy.
 * @arg_message: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-cinnamon-ScreenSaver.Lock">Lock()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_cinnamon_screen_saver_call_lock_finish() to get the result of the operation.
 *
 * See org_cinnamon_screen_saver_call_lock_sync() for the synchronous, blocking version of this method.
 */
void
org_cinnamon_screen_saver_call_lock (
    OrgCinnamonScreenSaver *proxy,
    const gchar *arg_message,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Lock",
    g_variant_new ("(s)",
                   arg_message),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_cinnamon_screen_saver_call_lock_finish:
 * @proxy: A #OrgCinnamonScreenSaverProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_cinnamon_screen_saver_call_lock().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_cinnamon_screen_saver_call_lock().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_cinnamon_screen_saver_call_lock_finish (
    OrgCinnamonScreenSaver *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_cinnamon_screen_saver_call_lock_sync:
 * @proxy: A #OrgCinnamonScreenSaverProxy.
 * @arg_message: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-cinnamon-ScreenSaver.Lock">Lock()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_cinnamon_screen_saver_call_lock() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_cinnamon_screen_saver_call_lock_sync (
    OrgCinnamonScreenSaver *proxy,
    const gchar *arg_message,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Lock",
    g_variant_new ("(s)",
                   arg_message),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_cinnamon_screen_saver_call_simulate_user_activity:
 * @proxy: A #OrgCinnamonScreenSaverProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-cinnamon-ScreenSaver.SimulateUserActivity">SimulateUserActivity()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_cinnamon_screen_saver_call_simulate_user_activity_finish() to get the result of the operation.
 *
 * See org_cinnamon_screen_saver_call_simulate_user_activity_sync() for the synchronous, blocking version of this method.
 */
void
org_cinnamon_screen_saver_call_simulate_user_activity (
    OrgCinnamonScreenSaver *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SimulateUserActivity",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_cinnamon_screen_saver_call_simulate_user_activity_finish:
 * @proxy: A #OrgCinnamonScreenSaverProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_cinnamon_screen_saver_call_simulate_user_activity().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_cinnamon_screen_saver_call_simulate_user_activity().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_cinnamon_screen_saver_call_simulate_user_activity_finish (
    OrgCinnamonScreenSaver *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_cinnamon_screen_saver_call_simulate_user_activity_sync:
 * @proxy: A #OrgCinnamonScreenSaverProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-cinnamon-ScreenSaver.SimulateUserActivity">SimulateUserActivity()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_cinnamon_screen_saver_call_simulate_user_activity() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_cinnamon_screen_saver_call_simulate_user_activity_sync (
    OrgCinnamonScreenSaver *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SimulateUserActivity",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_cinnamon_screen_saver_call_get_active:
 * @proxy: A #OrgCinnamonScreenSaverProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-cinnamon-ScreenSaver.GetActive">GetActive()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_cinnamon_screen_saver_call_get_active_finish() to get the result of the operation.
 *
 * See org_cinnamon_screen_saver_call_get_active_sync() for the synchronous, blocking version of this method.
 */
void
org_cinnamon_screen_saver_call_get_active (
    OrgCinnamonScreenSaver *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetActive",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_cinnamon_screen_saver_call_get_active_finish:
 * @proxy: A #OrgCinnamonScreenSaverProxy.
 * @out_arg_0: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_cinnamon_screen_saver_call_get_active().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_cinnamon_screen_saver_call_get_active().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_cinnamon_screen_saver_call_get_active_finish (
    OrgCinnamonScreenSaver *proxy,
    gboolean *out_arg_0,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_arg_0);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_cinnamon_screen_saver_call_get_active_sync:
 * @proxy: A #OrgCinnamonScreenSaverProxy.
 * @out_arg_0: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-cinnamon-ScreenSaver.GetActive">GetActive()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_cinnamon_screen_saver_call_get_active() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_cinnamon_screen_saver_call_get_active_sync (
    OrgCinnamonScreenSaver *proxy,
    gboolean *out_arg_0,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetActive",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_arg_0);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_cinnamon_screen_saver_call_get_active_time:
 * @proxy: A #OrgCinnamonScreenSaverProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-cinnamon-ScreenSaver.GetActiveTime">GetActiveTime()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_cinnamon_screen_saver_call_get_active_time_finish() to get the result of the operation.
 *
 * See org_cinnamon_screen_saver_call_get_active_time_sync() for the synchronous, blocking version of this method.
 */
void
org_cinnamon_screen_saver_call_get_active_time (
    OrgCinnamonScreenSaver *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetActiveTime",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_cinnamon_screen_saver_call_get_active_time_finish:
 * @proxy: A #OrgCinnamonScreenSaverProxy.
 * @out_seconds: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_cinnamon_screen_saver_call_get_active_time().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_cinnamon_screen_saver_call_get_active_time().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_cinnamon_screen_saver_call_get_active_time_finish (
    OrgCinnamonScreenSaver *proxy,
    guint *out_seconds,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_seconds);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_cinnamon_screen_saver_call_get_active_time_sync:
 * @proxy: A #OrgCinnamonScreenSaverProxy.
 * @out_seconds: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-cinnamon-ScreenSaver.GetActiveTime">GetActiveTime()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_cinnamon_screen_saver_call_get_active_time() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_cinnamon_screen_saver_call_get_active_time_sync (
    OrgCinnamonScreenSaver *proxy,
    guint *out_seconds,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetActiveTime",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_seconds);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_cinnamon_screen_saver_call_get_session_idle_time:
 * @proxy: A #OrgCinnamonScreenSaverProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-cinnamon-ScreenSaver.GetSessionIdleTime">GetSessionIdleTime()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_cinnamon_screen_saver_call_get_session_idle_time_finish() to get the result of the operation.
 *
 * See org_cinnamon_screen_saver_call_get_session_idle_time_sync() for the synchronous, blocking version of this method.
 */
void
org_cinnamon_screen_saver_call_get_session_idle_time (
    OrgCinnamonScreenSaver *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetSessionIdleTime",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_cinnamon_screen_saver_call_get_session_idle_time_finish:
 * @proxy: A #OrgCinnamonScreenSaverProxy.
 * @out_seconds: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_cinnamon_screen_saver_call_get_session_idle_time().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_cinnamon_screen_saver_call_get_session_idle_time().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_cinnamon_screen_saver_call_get_session_idle_time_finish (
    OrgCinnamonScreenSaver *proxy,
    guint *out_seconds,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_seconds);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_cinnamon_screen_saver_call_get_session_idle_time_sync:
 * @proxy: A #OrgCinnamonScreenSaverProxy.
 * @out_seconds: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-cinnamon-ScreenSaver.GetSessionIdleTime">GetSessionIdleTime()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_cinnamon_screen_saver_call_get_session_idle_time() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_cinnamon_screen_saver_call_get_session_idle_time_sync (
    OrgCinnamonScreenSaver *proxy,
    guint *out_seconds,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetSessionIdleTime",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_seconds);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_cinnamon_screen_saver_call_set_active:
 * @proxy: A #OrgCinnamonScreenSaverProxy.
 * @arg_e: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-cinnamon-ScreenSaver.SetActive">SetActive()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_cinnamon_screen_saver_call_set_active_finish() to get the result of the operation.
 *
 * See org_cinnamon_screen_saver_call_set_active_sync() for the synchronous, blocking version of this method.
 */
void
org_cinnamon_screen_saver_call_set_active (
    OrgCinnamonScreenSaver *proxy,
    gboolean arg_e,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetActive",
    g_variant_new ("(b)",
                   arg_e),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_cinnamon_screen_saver_call_set_active_finish:
 * @proxy: A #OrgCinnamonScreenSaverProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_cinnamon_screen_saver_call_set_active().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_cinnamon_screen_saver_call_set_active().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_cinnamon_screen_saver_call_set_active_finish (
    OrgCinnamonScreenSaver *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_cinnamon_screen_saver_call_set_active_sync:
 * @proxy: A #OrgCinnamonScreenSaverProxy.
 * @arg_e: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-cinnamon-ScreenSaver.SetActive">SetActive()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_cinnamon_screen_saver_call_set_active() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_cinnamon_screen_saver_call_set_active_sync (
    OrgCinnamonScreenSaver *proxy,
    gboolean arg_e,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetActive",
    g_variant_new ("(b)",
                   arg_e),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_cinnamon_screen_saver_call_quit:
 * @proxy: A #OrgCinnamonScreenSaverProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-cinnamon-ScreenSaver.Quit">Quit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_cinnamon_screen_saver_call_quit_finish() to get the result of the operation.
 *
 * See org_cinnamon_screen_saver_call_quit_sync() for the synchronous, blocking version of this method.
 */
void
org_cinnamon_screen_saver_call_quit (
    OrgCinnamonScreenSaver *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Quit",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_cinnamon_screen_saver_call_quit_finish:
 * @proxy: A #OrgCinnamonScreenSaverProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_cinnamon_screen_saver_call_quit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_cinnamon_screen_saver_call_quit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_cinnamon_screen_saver_call_quit_finish (
    OrgCinnamonScreenSaver *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_cinnamon_screen_saver_call_quit_sync:
 * @proxy: A #OrgCinnamonScreenSaverProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-cinnamon-ScreenSaver.Quit">Quit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_cinnamon_screen_saver_call_quit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_cinnamon_screen_saver_call_quit_sync (
    OrgCinnamonScreenSaver *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Quit",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_cinnamon_screen_saver_complete_lock:
 * @object: A #OrgCinnamonScreenSaver.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-cinnamon-ScreenSaver.Lock">Lock()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_cinnamon_screen_saver_complete_lock (
    OrgCinnamonScreenSaver *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_cinnamon_screen_saver_complete_simulate_user_activity:
 * @object: A #OrgCinnamonScreenSaver.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-cinnamon-ScreenSaver.SimulateUserActivity">SimulateUserActivity()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_cinnamon_screen_saver_complete_simulate_user_activity (
    OrgCinnamonScreenSaver *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_cinnamon_screen_saver_complete_get_active:
 * @object: A #OrgCinnamonScreenSaver.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @arg_0: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-cinnamon-ScreenSaver.GetActive">GetActive()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_cinnamon_screen_saver_complete_get_active (
    OrgCinnamonScreenSaver *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean arg_0)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   arg_0));
}

/**
 * org_cinnamon_screen_saver_complete_get_active_time:
 * @object: A #OrgCinnamonScreenSaver.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @seconds: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-cinnamon-ScreenSaver.GetActiveTime">GetActiveTime()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_cinnamon_screen_saver_complete_get_active_time (
    OrgCinnamonScreenSaver *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint seconds)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   seconds));
}

/**
 * org_cinnamon_screen_saver_complete_get_session_idle_time:
 * @object: A #OrgCinnamonScreenSaver.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @seconds: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-cinnamon-ScreenSaver.GetSessionIdleTime">GetSessionIdleTime()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_cinnamon_screen_saver_complete_get_session_idle_time (
    OrgCinnamonScreenSaver *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint seconds)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   seconds));
}

/**
 * org_cinnamon_screen_saver_complete_set_active:
 * @object: A #OrgCinnamonScreenSaver.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-cinnamon-ScreenSaver.SetActive">SetActive()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_cinnamon_screen_saver_complete_set_active (
    OrgCinnamonScreenSaver *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_cinnamon_screen_saver_complete_quit:
 * @object: A #OrgCinnamonScreenSaver.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-cinnamon-ScreenSaver.Quit">Quit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_cinnamon_screen_saver_complete_quit (
    OrgCinnamonScreenSaver *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * OrgCinnamonScreenSaverProxy:
 *
 * The #OrgCinnamonScreenSaverProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgCinnamonScreenSaverProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgCinnamonScreenSaverProxy.
 */

struct _OrgCinnamonScreenSaverProxyPrivate
{
  GData *qdata;
};

static void org_cinnamon_screen_saver_proxy_iface_init (OrgCinnamonScreenSaverIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgCinnamonScreenSaverProxy, org_cinnamon_screen_saver_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (OrgCinnamonScreenSaverProxy)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_CINNAMON_SCREEN_SAVER, org_cinnamon_screen_saver_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgCinnamonScreenSaverProxy, org_cinnamon_screen_saver_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_CINNAMON_SCREEN_SAVER, org_cinnamon_screen_saver_proxy_iface_init))

#endif
static void
org_cinnamon_screen_saver_proxy_finalize (GObject *object)
{
  OrgCinnamonScreenSaverProxy *proxy = ORG_CINNAMON_SCREEN_SAVER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (org_cinnamon_screen_saver_proxy_parent_class)->finalize (object);
}

static void
org_cinnamon_screen_saver_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
org_cinnamon_screen_saver_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
org_cinnamon_screen_saver_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_org_cinnamon_screen_saver_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TYPE_ORG_CINNAMON_SCREEN_SAVER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_CINNAMON_SCREEN_SAVER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
org_cinnamon_screen_saver_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  OrgCinnamonScreenSaverProxy *proxy = ORG_CINNAMON_SCREEN_SAVER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_cinnamon_screen_saver_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_cinnamon_screen_saver_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
org_cinnamon_screen_saver_proxy_init (OrgCinnamonScreenSaverProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = org_cinnamon_screen_saver_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TYPE_ORG_CINNAMON_SCREEN_SAVER_PROXY, OrgCinnamonScreenSaverProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), org_cinnamon_screen_saver_interface_info ());
}

static void
org_cinnamon_screen_saver_proxy_class_init (OrgCinnamonScreenSaverProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = org_cinnamon_screen_saver_proxy_finalize;
  gobject_class->get_property = org_cinnamon_screen_saver_proxy_get_property;
  gobject_class->set_property = org_cinnamon_screen_saver_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = org_cinnamon_screen_saver_proxy_g_signal;
  proxy_class->g_properties_changed = org_cinnamon_screen_saver_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgCinnamonScreenSaverProxyPrivate));
#endif
}

static void
org_cinnamon_screen_saver_proxy_iface_init (OrgCinnamonScreenSaverIface *iface G_GNUC_UNUSED)
{
}

/**
 * org_cinnamon_screen_saver_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-cinnamon-ScreenSaver.top_of_page">org.cinnamon.ScreenSaver</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_cinnamon_screen_saver_proxy_new_finish() to get the result of the operation.
 *
 * See org_cinnamon_screen_saver_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
org_cinnamon_screen_saver_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_CINNAMON_SCREEN_SAVER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.cinnamon.ScreenSaver", NULL);
}

/**
 * org_cinnamon_screen_saver_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_cinnamon_screen_saver_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_cinnamon_screen_saver_proxy_new().
 *
 * Returns: (transfer full) (type OrgCinnamonScreenSaverProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgCinnamonScreenSaver *
org_cinnamon_screen_saver_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_CINNAMON_SCREEN_SAVER (ret);
  else
    return NULL;
}

/**
 * org_cinnamon_screen_saver_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-cinnamon-ScreenSaver.top_of_page">org.cinnamon.ScreenSaver</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_cinnamon_screen_saver_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgCinnamonScreenSaverProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgCinnamonScreenSaver *
org_cinnamon_screen_saver_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_CINNAMON_SCREEN_SAVER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.cinnamon.ScreenSaver", NULL);
  if (ret != NULL)
    return ORG_CINNAMON_SCREEN_SAVER (ret);
  else
    return NULL;
}


/**
 * org_cinnamon_screen_saver_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like org_cinnamon_screen_saver_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_cinnamon_screen_saver_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See org_cinnamon_screen_saver_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
org_cinnamon_screen_saver_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_CINNAMON_SCREEN_SAVER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.cinnamon.ScreenSaver", NULL);
}

/**
 * org_cinnamon_screen_saver_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_cinnamon_screen_saver_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_cinnamon_screen_saver_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type OrgCinnamonScreenSaverProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgCinnamonScreenSaver *
org_cinnamon_screen_saver_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_CINNAMON_SCREEN_SAVER (ret);
  else
    return NULL;
}

/**
 * org_cinnamon_screen_saver_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like org_cinnamon_screen_saver_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_cinnamon_screen_saver_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgCinnamonScreenSaverProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgCinnamonScreenSaver *
org_cinnamon_screen_saver_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_CINNAMON_SCREEN_SAVER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.cinnamon.ScreenSaver", NULL);
  if (ret != NULL)
    return ORG_CINNAMON_SCREEN_SAVER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * OrgCinnamonScreenSaverSkeleton:
 *
 * The #OrgCinnamonScreenSaverSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgCinnamonScreenSaverSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgCinnamonScreenSaverSkeleton.
 */

struct _OrgCinnamonScreenSaverSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_org_cinnamon_screen_saver_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  OrgCinnamonScreenSaverSkeleton *skeleton = ORG_CINNAMON_SCREEN_SAVER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TYPE_ORG_CINNAMON_SCREEN_SAVER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_CINNAMON_SCREEN_SAVER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_org_cinnamon_screen_saver_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  OrgCinnamonScreenSaverSkeleton *skeleton = ORG_CINNAMON_SCREEN_SAVER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_cinnamon_screen_saver_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_org_cinnamon_screen_saver_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  OrgCinnamonScreenSaverSkeleton *skeleton = ORG_CINNAMON_SCREEN_SAVER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_cinnamon_screen_saver_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _org_cinnamon_screen_saver_skeleton_vtable =
{
  _org_cinnamon_screen_saver_skeleton_handle_method_call,
  _org_cinnamon_screen_saver_skeleton_handle_get_property,
  _org_cinnamon_screen_saver_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
org_cinnamon_screen_saver_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return org_cinnamon_screen_saver_interface_info ();
}

static GDBusInterfaceVTable *
org_cinnamon_screen_saver_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_org_cinnamon_screen_saver_skeleton_vtable;
}

static GVariant *
org_cinnamon_screen_saver_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  OrgCinnamonScreenSaverSkeleton *skeleton = ORG_CINNAMON_SCREEN_SAVER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_org_cinnamon_screen_saver_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _org_cinnamon_screen_saver_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _org_cinnamon_screen_saver_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _org_cinnamon_screen_saver_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.cinnamon.ScreenSaver", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
org_cinnamon_screen_saver_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_org_cinnamon_screen_saver_on_signal_active_changed (
    OrgCinnamonScreenSaver *object,
    gboolean arg_arg_0)
{
  OrgCinnamonScreenSaverSkeleton *skeleton = ORG_CINNAMON_SCREEN_SAVER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(b)",
                   arg_arg_0));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.cinnamon.ScreenSaver", "ActiveChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void org_cinnamon_screen_saver_skeleton_iface_init (OrgCinnamonScreenSaverIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgCinnamonScreenSaverSkeleton, org_cinnamon_screen_saver_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (OrgCinnamonScreenSaverSkeleton)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_CINNAMON_SCREEN_SAVER, org_cinnamon_screen_saver_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgCinnamonScreenSaverSkeleton, org_cinnamon_screen_saver_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_CINNAMON_SCREEN_SAVER, org_cinnamon_screen_saver_skeleton_iface_init))

#endif
static void
org_cinnamon_screen_saver_skeleton_finalize (GObject *object)
{
  OrgCinnamonScreenSaverSkeleton *skeleton = ORG_CINNAMON_SCREEN_SAVER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (org_cinnamon_screen_saver_skeleton_parent_class)->finalize (object);
}

static void
org_cinnamon_screen_saver_skeleton_init (OrgCinnamonScreenSaverSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = org_cinnamon_screen_saver_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TYPE_ORG_CINNAMON_SCREEN_SAVER_SKELETON, OrgCinnamonScreenSaverSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
org_cinnamon_screen_saver_skeleton_class_init (OrgCinnamonScreenSaverSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = org_cinnamon_screen_saver_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = org_cinnamon_screen_saver_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = org_cinnamon_screen_saver_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = org_cinnamon_screen_saver_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = org_cinnamon_screen_saver_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgCinnamonScreenSaverSkeletonPrivate));
#endif
}

static void
org_cinnamon_screen_saver_skeleton_iface_init (OrgCinnamonScreenSaverIface *iface)
{
  iface->active_changed = _org_cinnamon_screen_saver_on_signal_active_changed;
}

/**
 * org_cinnamon_screen_saver_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-cinnamon-ScreenSaver.top_of_page">org.cinnamon.ScreenSaver</link>.
 *
 * Returns: (transfer full) (type OrgCinnamonScreenSaverSkeleton): The skeleton object.
 */
OrgCinnamonScreenSaver *
org_cinnamon_screen_saver_skeleton_new (void)
{
  return ORG_CINNAMON_SCREEN_SAVER (g_object_new (TYPE_ORG_CINNAMON_SCREEN_SAVER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.ScreenSaver
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:OrgFreedesktopScreenSaver
 * @title: OrgFreedesktopScreenSaver
 * @short_description: Generated C code for the org.freedesktop.ScreenSaver D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-ScreenSaver.top_of_page">org.freedesktop.ScreenSaver</link> D-Bus interface in C.
 */

enum
{
  _ORG_FREEDESKTOP_SCREEN_SAVER_ACTIVE_CHANGED,
};

static unsigned _ORG_FREEDESKTOP_SCREEN_SAVER_SIGNALS[1] = { 0 };

/* ---- Introspection data for org.freedesktop.ScreenSaver ---- */

static const _ExtendedGDBusMethodInfo _org_freedesktop_screen_saver_method_info_lock =
{
  {
    -1,
    (gchar *) "Lock",
    NULL,
    NULL,
    NULL
  },
  "handle-lock",
  FALSE
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_screen_saver_method_info_simulate_user_activity =
{
  {
    -1,
    (gchar *) "SimulateUserActivity",
    NULL,
    NULL,
    NULL
  },
  "handle-simulate-user-activity",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_screen_saver_method_info_get_active_OUT_ARG_unnamed_arg0 =
{
  {
    -1,
    (gchar *) "unnamed_arg0",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_screen_saver_method_info_get_active_OUT_ARG_pointers[] =
{
  &_org_freedesktop_screen_saver_method_info_get_active_OUT_ARG_unnamed_arg0.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_screen_saver_method_info_get_active =
{
  {
    -1,
    (gchar *) "GetActive",
    NULL,
    (GDBusArgInfo **) &_org_freedesktop_screen_saver_method_info_get_active_OUT_ARG_pointers,
    NULL
  },
  "handle-get-active",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_screen_saver_method_info_get_active_time_OUT_ARG_seconds =
{
  {
    -1,
    (gchar *) "seconds",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_screen_saver_method_info_get_active_time_OUT_ARG_pointers[] =
{
  &_org_freedesktop_screen_saver_method_info_get_active_time_OUT_ARG_seconds.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_screen_saver_method_info_get_active_time =
{
  {
    -1,
    (gchar *) "GetActiveTime",
    NULL,
    (GDBusArgInfo **) &_org_freedesktop_screen_saver_method_info_get_active_time_OUT_ARG_pointers,
    NULL
  },
  "handle-get-active-time",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_screen_saver_method_info_get_session_idle_time_OUT_ARG_seconds =
{
  {
    -1,
    (gchar *) "seconds",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_screen_saver_method_info_get_session_idle_time_OUT_ARG_pointers[] =
{
  &_org_freedesktop_screen_saver_method_info_get_session_idle_time_OUT_ARG_seconds.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_screen_saver_method_info_get_session_idle_time =
{
  {
    -1,
    (gchar *) "GetSessionIdleTime",
    NULL,
    (GDBusArgInfo **) &_org_freedesktop_screen_saver_method_info_get_session_idle_time_OUT_ARG_pointers,
    NULL
  },
  "handle-get-session-idle-time",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_screen_saver_method_info_set_active_IN_ARG_e =
{
  {
    -1,
    (gchar *) "e",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_screen_saver_method_info_set_active_IN_ARG_pointers[] =
{
  &_org_freedesktop_screen_saver_method_info_set_active_IN_ARG_e.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_freedesktop_screen_saver_method_info_set_active_OUT_ARG_unnamed_arg1 =
{
  {
    -1,
    (gchar *) "unnamed_arg1",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_screen_saver_method_info_set_active_OUT_ARG_pointers[] =
{
  &_org_freedesktop_screen_saver_method_info_set_active_OUT_ARG_unnamed_arg1.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_screen_saver_method_info_set_active =
{
  {
    -1,
    (gchar *) "SetActive",
    (GDBusArgInfo **) &_org_freedesktop_screen_saver_method_info_set_active_IN_ARG_pointers,
    (GDBusArgInfo **) &_org_freedesktop_screen_saver_method_info_set_active_OUT_ARG_pointers,
    NULL
  },
  "handle-set-active",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_screen_saver_method_info_inhibit_IN_ARG_application_name =
{
  {
    -1,
    (gchar *) "application_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_screen_saver_method_info_inhibit_IN_ARG_reason_for_inhibit =
{
  {
    -1,
    (gchar *) "reason_for_inhibit",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_screen_saver_method_info_inhibit_IN_ARG_pointers[] =
{
  &_org_freedesktop_screen_saver_method_info_inhibit_IN_ARG_application_name.parent_struct,
  &_org_freedesktop_screen_saver_method_info_inhibit_IN_ARG_reason_for_inhibit.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_freedesktop_screen_saver_method_info_inhibit_OUT_ARG_cookie =
{
  {
    -1,
    (gchar *) "cookie",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_screen_saver_method_info_inhibit_OUT_ARG_pointers[] =
{
  &_org_freedesktop_screen_saver_method_info_inhibit_OUT_ARG_cookie.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_screen_saver_method_info_inhibit =
{
  {
    -1,
    (gchar *) "Inhibit",
    (GDBusArgInfo **) &_org_freedesktop_screen_saver_method_info_inhibit_IN_ARG_pointers,
    (GDBusArgInfo **) &_org_freedesktop_screen_saver_method_info_inhibit_OUT_ARG_pointers,
    NULL
  },
  "handle-inhibit",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_screen_saver_method_info_un_inhibit_IN_ARG_cookie =
{
  {
    -1,
    (gchar *) "cookie",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_screen_saver_method_info_un_inhibit_IN_ARG_pointers[] =
{
  &_org_freedesktop_screen_saver_method_info_un_inhibit_IN_ARG_cookie.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_screen_saver_method_info_un_inhibit =
{
  {
    -1,
    (gchar *) "UnInhibit",
    (GDBusArgInfo **) &_org_freedesktop_screen_saver_method_info_un_inhibit_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-un-inhibit",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_screen_saver_method_info_throttle_IN_ARG_application_name =
{
  {
    -1,
    (gchar *) "application_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_screen_saver_method_info_throttle_IN_ARG_reason_for_inhibit =
{
  {
    -1,
    (gchar *) "reason_for_inhibit",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_screen_saver_method_info_throttle_IN_ARG_pointers[] =
{
  &_org_freedesktop_screen_saver_method_info_throttle_IN_ARG_application_name.parent_struct,
  &_org_freedesktop_screen_saver_method_info_throttle_IN_ARG_reason_for_inhibit.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_freedesktop_screen_saver_method_info_throttle_OUT_ARG_cookie =
{
  {
    -1,
    (gchar *) "cookie",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_screen_saver_method_info_throttle_OUT_ARG_pointers[] =
{
  &_org_freedesktop_screen_saver_method_info_throttle_OUT_ARG_cookie.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_screen_saver_method_info_throttle =
{
  {
    -1,
    (gchar *) "Throttle",
    (GDBusArgInfo **) &_org_freedesktop_screen_saver_method_info_throttle_IN_ARG_pointers,
    (GDBusArgInfo **) &_org_freedesktop_screen_saver_method_info_throttle_OUT_ARG_pointers,
    NULL
  },
  "handle-throttle",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_screen_saver_method_info_un_throttle_IN_ARG_cookie =
{
  {
    -1,
    (gchar *) "cookie",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_screen_saver_method_info_un_throttle_IN_ARG_pointers[] =
{
  &_org_freedesktop_screen_saver_method_info_un_throttle_IN_ARG_cookie.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_screen_saver_method_info_un_throttle =
{
  {
    -1,
    (gchar *) "UnThrottle",
    (GDBusArgInfo **) &_org_freedesktop_screen_saver_method_info_un_throttle_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-un-throttle",
  FALSE
};

static const GDBusMethodInfo * const _org_freedesktop_screen_saver_method_info_pointers[] =
{
  &_org_freedesktop_screen_saver_method_info_lock.parent_struct,
  &_org_freedesktop_screen_saver_method_info_simulate_user_activity.parent_struct,
  &_org_freedesktop_screen_saver_method_info_get_active.parent_struct,
  &_org_freedesktop_screen_saver_method_info_get_active_time.parent_struct,
  &_org_freedesktop_screen_saver_method_info_get_session_idle_time.parent_struct,
  &_org_freedesktop_screen_saver_method_info_set_active.parent_struct,
  &_org_freedesktop_screen_saver_method_info_inhibit.parent_struct,
  &_org_freedesktop_screen_saver_method_info_un_inhibit.parent_struct,
  &_org_freedesktop_screen_saver_method_info_throttle.parent_struct,
  &_org_freedesktop_screen_saver_method_info_un_throttle.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_freedesktop_screen_saver_signal_info_active_changed_ARG_unnamed_arg0 =
{
  {
    -1,
    (gchar *) "unnamed_arg0",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_screen_saver_signal_info_active_changed_ARG_pointers[] =
{
  &_org_freedesktop_screen_saver_signal_info_active_changed_ARG_unnamed_arg0.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _org_freedesktop_screen_saver_signal_info_active_changed =
{
  {
    -1,
    (gchar *) "ActiveChanged",
    (GDBusArgInfo **) &_org_freedesktop_screen_saver_signal_info_active_changed_ARG_pointers,
    NULL
  },
  "active-changed"
};

static const GDBusSignalInfo * const _org_freedesktop_screen_saver_signal_info_pointers[] =
{
  &_org_freedesktop_screen_saver_signal_info_active_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _org_freedesktop_screen_saver_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.ScreenSaver",
    (GDBusMethodInfo **) &_org_freedesktop_screen_saver_method_info_pointers,
    (GDBusSignalInfo **) &_org_freedesktop_screen_saver_signal_info_pointers,
    NULL,
    NULL
  },
  "org-freedesktop-screen-saver",
};


/**
 * org_freedesktop_screen_saver_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-ScreenSaver.top_of_page">org.freedesktop.ScreenSaver</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
org_freedesktop_screen_saver_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_org_freedesktop_screen_saver_interface_info.parent_struct;
}

/**
 * org_freedesktop_screen_saver_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #OrgFreedesktopScreenSaver interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
org_freedesktop_screen_saver_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
org_freedesktop_screen_saver_signal_marshal_active_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_freedesktop_screen_saver_method_marshal_lock (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_freedesktop_screen_saver_method_marshal_simulate_user_activity (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_freedesktop_screen_saver_method_marshal_get_active (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_freedesktop_screen_saver_method_marshal_get_active_time (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_freedesktop_screen_saver_method_marshal_get_session_idle_time (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_freedesktop_screen_saver_method_marshal_set_active (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_freedesktop_screen_saver_method_marshal_inhibit (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_freedesktop_screen_saver_method_marshal_un_inhibit (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_freedesktop_screen_saver_method_marshal_throttle (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_freedesktop_screen_saver_method_marshal_un_throttle (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * OrgFreedesktopScreenSaver:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ScreenSaver.top_of_page">org.freedesktop.ScreenSaver</link>.
 */

/**
 * OrgFreedesktopScreenSaverIface:
 * @parent_iface: The parent interface.
 * @handle_get_active: Handler for the #OrgFreedesktopScreenSaver::handle-get-active signal.
 * @handle_get_active_time: Handler for the #OrgFreedesktopScreenSaver::handle-get-active-time signal.
 * @handle_get_session_idle_time: Handler for the #OrgFreedesktopScreenSaver::handle-get-session-idle-time signal.
 * @handle_inhibit: Handler for the #OrgFreedesktopScreenSaver::handle-inhibit signal.
 * @handle_lock: Handler for the #OrgFreedesktopScreenSaver::handle-lock signal.
 * @handle_set_active: Handler for the #OrgFreedesktopScreenSaver::handle-set-active signal.
 * @handle_simulate_user_activity: Handler for the #OrgFreedesktopScreenSaver::handle-simulate-user-activity signal.
 * @handle_throttle: Handler for the #OrgFreedesktopScreenSaver::handle-throttle signal.
 * @handle_un_inhibit: Handler for the #OrgFreedesktopScreenSaver::handle-un-inhibit signal.
 * @handle_un_throttle: Handler for the #OrgFreedesktopScreenSaver::handle-un-throttle signal.
 * @active_changed: Handler for the #OrgFreedesktopScreenSaver::active-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ScreenSaver.top_of_page">org.freedesktop.ScreenSaver</link>.
 */

typedef OrgFreedesktopScreenSaverIface OrgFreedesktopScreenSaverInterface;
G_DEFINE_INTERFACE (OrgFreedesktopScreenSaver, org_freedesktop_screen_saver, G_TYPE_OBJECT)

static void
org_freedesktop_screen_saver_default_init (OrgFreedesktopScreenSaverIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * OrgFreedesktopScreenSaver::handle-lock:
   * @object: A #OrgFreedesktopScreenSaver.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.Lock">Lock()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_screen_saver_complete_lock() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-lock",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopScreenSaverIface, handle_lock),
    g_signal_accumulator_true_handled,
    NULL,
      org_freedesktop_screen_saver_method_marshal_lock,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * OrgFreedesktopScreenSaver::handle-simulate-user-activity:
   * @object: A #OrgFreedesktopScreenSaver.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.SimulateUserActivity">SimulateUserActivity()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_screen_saver_complete_simulate_user_activity() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-simulate-user-activity",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopScreenSaverIface, handle_simulate_user_activity),
    g_signal_accumulator_true_handled,
    NULL,
      org_freedesktop_screen_saver_method_marshal_simulate_user_activity,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * OrgFreedesktopScreenSaver::handle-get-active:
   * @object: A #OrgFreedesktopScreenSaver.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.GetActive">GetActive()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_screen_saver_complete_get_active() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-active",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopScreenSaverIface, handle_get_active),
    g_signal_accumulator_true_handled,
    NULL,
      org_freedesktop_screen_saver_method_marshal_get_active,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * OrgFreedesktopScreenSaver::handle-get-active-time:
   * @object: A #OrgFreedesktopScreenSaver.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.GetActiveTime">GetActiveTime()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_screen_saver_complete_get_active_time() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-active-time",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopScreenSaverIface, handle_get_active_time),
    g_signal_accumulator_true_handled,
    NULL,
      org_freedesktop_screen_saver_method_marshal_get_active_time,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * OrgFreedesktopScreenSaver::handle-get-session-idle-time:
   * @object: A #OrgFreedesktopScreenSaver.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.GetSessionIdleTime">GetSessionIdleTime()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_screen_saver_complete_get_session_idle_time() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-session-idle-time",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopScreenSaverIface, handle_get_session_idle_time),
    g_signal_accumulator_true_handled,
    NULL,
      org_freedesktop_screen_saver_method_marshal_get_session_idle_time,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * OrgFreedesktopScreenSaver::handle-set-active:
   * @object: A #OrgFreedesktopScreenSaver.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_e: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.SetActive">SetActive()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_screen_saver_complete_set_active() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-active",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopScreenSaverIface, handle_set_active),
    g_signal_accumulator_true_handled,
    NULL,
      org_freedesktop_screen_saver_method_marshal_set_active,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN);

  /**
   * OrgFreedesktopScreenSaver::handle-inhibit:
   * @object: A #OrgFreedesktopScreenSaver.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_application_name: Argument passed by remote caller.
   * @arg_reason_for_inhibit: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.Inhibit">Inhibit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_screen_saver_complete_inhibit() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-inhibit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopScreenSaverIface, handle_inhibit),
    g_signal_accumulator_true_handled,
    NULL,
      org_freedesktop_screen_saver_method_marshal_inhibit,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * OrgFreedesktopScreenSaver::handle-un-inhibit:
   * @object: A #OrgFreedesktopScreenSaver.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_cookie: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.UnInhibit">UnInhibit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_screen_saver_complete_un_inhibit() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-un-inhibit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopScreenSaverIface, handle_un_inhibit),
    g_signal_accumulator_true_handled,
    NULL,
      org_freedesktop_screen_saver_method_marshal_un_inhibit,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * OrgFreedesktopScreenSaver::handle-throttle:
   * @object: A #OrgFreedesktopScreenSaver.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_application_name: Argument passed by remote caller.
   * @arg_reason_for_inhibit: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.Throttle">Throttle()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_screen_saver_complete_throttle() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-throttle",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopScreenSaverIface, handle_throttle),
    g_signal_accumulator_true_handled,
    NULL,
      org_freedesktop_screen_saver_method_marshal_throttle,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * OrgFreedesktopScreenSaver::handle-un-throttle:
   * @object: A #OrgFreedesktopScreenSaver.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_cookie: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.UnThrottle">UnThrottle()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_screen_saver_complete_un_throttle() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-un-throttle",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopScreenSaverIface, handle_un_throttle),
    g_signal_accumulator_true_handled,
    NULL,
      org_freedesktop_screen_saver_method_marshal_un_throttle,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /* GObject signals for received D-Bus signals: */
  /**
   * OrgFreedesktopScreenSaver::active-changed:
   * @object: A #OrgFreedesktopScreenSaver.
   * @arg_unnamed_arg0: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-ScreenSaver.ActiveChanged">"ActiveChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  _ORG_FREEDESKTOP_SCREEN_SAVER_SIGNALS[_ORG_FREEDESKTOP_SCREEN_SAVER_ACTIVE_CHANGED] =
    g_signal_new ("active-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (OrgFreedesktopScreenSaverIface, active_changed),
      NULL,
      NULL,
      org_freedesktop_screen_saver_signal_marshal_active_changed,
      G_TYPE_NONE,
      1, G_TYPE_BOOLEAN);

}

/**
 * org_freedesktop_screen_saver_emit_active_changed:
 * @object: A #OrgFreedesktopScreenSaver.
 * @arg_unnamed_arg0: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-ScreenSaver.ActiveChanged">"ActiveChanged"</link> D-Bus signal.
 */
void
org_freedesktop_screen_saver_emit_active_changed (
    OrgFreedesktopScreenSaver *object,
    gboolean arg_unnamed_arg0)
{
  g_signal_emit (object, _ORG_FREEDESKTOP_SCREEN_SAVER_SIGNALS[_ORG_FREEDESKTOP_SCREEN_SAVER_ACTIVE_CHANGED], 0, arg_unnamed_arg0);
}

/**
 * org_freedesktop_screen_saver_call_lock:
 * @proxy: A #OrgFreedesktopScreenSaverProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.Lock">Lock()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_screen_saver_call_lock_finish() to get the result of the operation.
 *
 * See org_freedesktop_screen_saver_call_lock_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_screen_saver_call_lock (
    OrgFreedesktopScreenSaver *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Lock",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_screen_saver_call_lock_finish:
 * @proxy: A #OrgFreedesktopScreenSaverProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_screen_saver_call_lock().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_screen_saver_call_lock().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_screen_saver_call_lock_finish (
    OrgFreedesktopScreenSaver *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_screen_saver_call_lock_sync:
 * @proxy: A #OrgFreedesktopScreenSaverProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.Lock">Lock()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_screen_saver_call_lock() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_screen_saver_call_lock_sync (
    OrgFreedesktopScreenSaver *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Lock",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_screen_saver_call_simulate_user_activity:
 * @proxy: A #OrgFreedesktopScreenSaverProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.SimulateUserActivity">SimulateUserActivity()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_screen_saver_call_simulate_user_activity_finish() to get the result of the operation.
 *
 * See org_freedesktop_screen_saver_call_simulate_user_activity_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_screen_saver_call_simulate_user_activity (
    OrgFreedesktopScreenSaver *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SimulateUserActivity",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_screen_saver_call_simulate_user_activity_finish:
 * @proxy: A #OrgFreedesktopScreenSaverProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_screen_saver_call_simulate_user_activity().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_screen_saver_call_simulate_user_activity().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_screen_saver_call_simulate_user_activity_finish (
    OrgFreedesktopScreenSaver *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_screen_saver_call_simulate_user_activity_sync:
 * @proxy: A #OrgFreedesktopScreenSaverProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.SimulateUserActivity">SimulateUserActivity()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_screen_saver_call_simulate_user_activity() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_screen_saver_call_simulate_user_activity_sync (
    OrgFreedesktopScreenSaver *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SimulateUserActivity",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_screen_saver_call_get_active:
 * @proxy: A #OrgFreedesktopScreenSaverProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.GetActive">GetActive()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_screen_saver_call_get_active_finish() to get the result of the operation.
 *
 * See org_freedesktop_screen_saver_call_get_active_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_screen_saver_call_get_active (
    OrgFreedesktopScreenSaver *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetActive",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_screen_saver_call_get_active_finish:
 * @proxy: A #OrgFreedesktopScreenSaverProxy.
 * @out_unnamed_arg0: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_screen_saver_call_get_active().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_screen_saver_call_get_active().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_screen_saver_call_get_active_finish (
    OrgFreedesktopScreenSaver *proxy,
    gboolean *out_unnamed_arg0,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_unnamed_arg0);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_screen_saver_call_get_active_sync:
 * @proxy: A #OrgFreedesktopScreenSaverProxy.
 * @out_unnamed_arg0: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.GetActive">GetActive()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_screen_saver_call_get_active() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_screen_saver_call_get_active_sync (
    OrgFreedesktopScreenSaver *proxy,
    gboolean *out_unnamed_arg0,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetActive",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_unnamed_arg0);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_screen_saver_call_get_active_time:
 * @proxy: A #OrgFreedesktopScreenSaverProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.GetActiveTime">GetActiveTime()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_screen_saver_call_get_active_time_finish() to get the result of the operation.
 *
 * See org_freedesktop_screen_saver_call_get_active_time_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_screen_saver_call_get_active_time (
    OrgFreedesktopScreenSaver *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetActiveTime",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_screen_saver_call_get_active_time_finish:
 * @proxy: A #OrgFreedesktopScreenSaverProxy.
 * @out_seconds: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_screen_saver_call_get_active_time().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_screen_saver_call_get_active_time().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_screen_saver_call_get_active_time_finish (
    OrgFreedesktopScreenSaver *proxy,
    guint *out_seconds,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_seconds);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_screen_saver_call_get_active_time_sync:
 * @proxy: A #OrgFreedesktopScreenSaverProxy.
 * @out_seconds: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.GetActiveTime">GetActiveTime()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_screen_saver_call_get_active_time() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_screen_saver_call_get_active_time_sync (
    OrgFreedesktopScreenSaver *proxy,
    guint *out_seconds,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetActiveTime",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_seconds);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_screen_saver_call_get_session_idle_time:
 * @proxy: A #OrgFreedesktopScreenSaverProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.GetSessionIdleTime">GetSessionIdleTime()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_screen_saver_call_get_session_idle_time_finish() to get the result of the operation.
 *
 * See org_freedesktop_screen_saver_call_get_session_idle_time_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_screen_saver_call_get_session_idle_time (
    OrgFreedesktopScreenSaver *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetSessionIdleTime",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_screen_saver_call_get_session_idle_time_finish:
 * @proxy: A #OrgFreedesktopScreenSaverProxy.
 * @out_seconds: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_screen_saver_call_get_session_idle_time().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_screen_saver_call_get_session_idle_time().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_screen_saver_call_get_session_idle_time_finish (
    OrgFreedesktopScreenSaver *proxy,
    guint *out_seconds,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_seconds);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_screen_saver_call_get_session_idle_time_sync:
 * @proxy: A #OrgFreedesktopScreenSaverProxy.
 * @out_seconds: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.GetSessionIdleTime">GetSessionIdleTime()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_screen_saver_call_get_session_idle_time() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_screen_saver_call_get_session_idle_time_sync (
    OrgFreedesktopScreenSaver *proxy,
    guint *out_seconds,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetSessionIdleTime",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_seconds);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_screen_saver_call_set_active:
 * @proxy: A #OrgFreedesktopScreenSaverProxy.
 * @arg_e: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.SetActive">SetActive()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_screen_saver_call_set_active_finish() to get the result of the operation.
 *
 * See org_freedesktop_screen_saver_call_set_active_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_screen_saver_call_set_active (
    OrgFreedesktopScreenSaver *proxy,
    gboolean arg_e,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetActive",
    g_variant_new ("(b)",
                   arg_e),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_screen_saver_call_set_active_finish:
 * @proxy: A #OrgFreedesktopScreenSaverProxy.
 * @out_unnamed_arg1: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_screen_saver_call_set_active().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_screen_saver_call_set_active().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_screen_saver_call_set_active_finish (
    OrgFreedesktopScreenSaver *proxy,
    gboolean *out_unnamed_arg1,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_unnamed_arg1);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_screen_saver_call_set_active_sync:
 * @proxy: A #OrgFreedesktopScreenSaverProxy.
 * @arg_e: Argument to pass with the method invocation.
 * @out_unnamed_arg1: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.SetActive">SetActive()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_screen_saver_call_set_active() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_screen_saver_call_set_active_sync (
    OrgFreedesktopScreenSaver *proxy,
    gboolean arg_e,
    gboolean *out_unnamed_arg1,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetActive",
    g_variant_new ("(b)",
                   arg_e),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_unnamed_arg1);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_screen_saver_call_inhibit:
 * @proxy: A #OrgFreedesktopScreenSaverProxy.
 * @arg_application_name: Argument to pass with the method invocation.
 * @arg_reason_for_inhibit: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.Inhibit">Inhibit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_screen_saver_call_inhibit_finish() to get the result of the operation.
 *
 * See org_freedesktop_screen_saver_call_inhibit_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_screen_saver_call_inhibit (
    OrgFreedesktopScreenSaver *proxy,
    const gchar *arg_application_name,
    const gchar *arg_reason_for_inhibit,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Inhibit",
    g_variant_new ("(ss)",
                   arg_application_name,
                   arg_reason_for_inhibit),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_screen_saver_call_inhibit_finish:
 * @proxy: A #OrgFreedesktopScreenSaverProxy.
 * @out_cookie: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_screen_saver_call_inhibit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_screen_saver_call_inhibit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_screen_saver_call_inhibit_finish (
    OrgFreedesktopScreenSaver *proxy,
    guint *out_cookie,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_cookie);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_screen_saver_call_inhibit_sync:
 * @proxy: A #OrgFreedesktopScreenSaverProxy.
 * @arg_application_name: Argument to pass with the method invocation.
 * @arg_reason_for_inhibit: Argument to pass with the method invocation.
 * @out_cookie: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.Inhibit">Inhibit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_screen_saver_call_inhibit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_screen_saver_call_inhibit_sync (
    OrgFreedesktopScreenSaver *proxy,
    const gchar *arg_application_name,
    const gchar *arg_reason_for_inhibit,
    guint *out_cookie,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Inhibit",
    g_variant_new ("(ss)",
                   arg_application_name,
                   arg_reason_for_inhibit),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_cookie);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_screen_saver_call_un_inhibit:
 * @proxy: A #OrgFreedesktopScreenSaverProxy.
 * @arg_cookie: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.UnInhibit">UnInhibit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_screen_saver_call_un_inhibit_finish() to get the result of the operation.
 *
 * See org_freedesktop_screen_saver_call_un_inhibit_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_screen_saver_call_un_inhibit (
    OrgFreedesktopScreenSaver *proxy,
    guint arg_cookie,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UnInhibit",
    g_variant_new ("(u)",
                   arg_cookie),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_screen_saver_call_un_inhibit_finish:
 * @proxy: A #OrgFreedesktopScreenSaverProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_screen_saver_call_un_inhibit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_screen_saver_call_un_inhibit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_screen_saver_call_un_inhibit_finish (
    OrgFreedesktopScreenSaver *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_screen_saver_call_un_inhibit_sync:
 * @proxy: A #OrgFreedesktopScreenSaverProxy.
 * @arg_cookie: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.UnInhibit">UnInhibit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_screen_saver_call_un_inhibit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_screen_saver_call_un_inhibit_sync (
    OrgFreedesktopScreenSaver *proxy,
    guint arg_cookie,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UnInhibit",
    g_variant_new ("(u)",
                   arg_cookie),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_screen_saver_call_throttle:
 * @proxy: A #OrgFreedesktopScreenSaverProxy.
 * @arg_application_name: Argument to pass with the method invocation.
 * @arg_reason_for_inhibit: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.Throttle">Throttle()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_screen_saver_call_throttle_finish() to get the result of the operation.
 *
 * See org_freedesktop_screen_saver_call_throttle_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_screen_saver_call_throttle (
    OrgFreedesktopScreenSaver *proxy,
    const gchar *arg_application_name,
    const gchar *arg_reason_for_inhibit,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Throttle",
    g_variant_new ("(ss)",
                   arg_application_name,
                   arg_reason_for_inhibit),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_screen_saver_call_throttle_finish:
 * @proxy: A #OrgFreedesktopScreenSaverProxy.
 * @out_cookie: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_screen_saver_call_throttle().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_screen_saver_call_throttle().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_screen_saver_call_throttle_finish (
    OrgFreedesktopScreenSaver *proxy,
    guint *out_cookie,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_cookie);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_screen_saver_call_throttle_sync:
 * @proxy: A #OrgFreedesktopScreenSaverProxy.
 * @arg_application_name: Argument to pass with the method invocation.
 * @arg_reason_for_inhibit: Argument to pass with the method invocation.
 * @out_cookie: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.Throttle">Throttle()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_screen_saver_call_throttle() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_screen_saver_call_throttle_sync (
    OrgFreedesktopScreenSaver *proxy,
    const gchar *arg_application_name,
    const gchar *arg_reason_for_inhibit,
    guint *out_cookie,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Throttle",
    g_variant_new ("(ss)",
                   arg_application_name,
                   arg_reason_for_inhibit),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_cookie);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_screen_saver_call_un_throttle:
 * @proxy: A #OrgFreedesktopScreenSaverProxy.
 * @arg_cookie: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.UnThrottle">UnThrottle()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_screen_saver_call_un_throttle_finish() to get the result of the operation.
 *
 * See org_freedesktop_screen_saver_call_un_throttle_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_screen_saver_call_un_throttle (
    OrgFreedesktopScreenSaver *proxy,
    guint arg_cookie,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UnThrottle",
    g_variant_new ("(u)",
                   arg_cookie),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_screen_saver_call_un_throttle_finish:
 * @proxy: A #OrgFreedesktopScreenSaverProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_screen_saver_call_un_throttle().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_screen_saver_call_un_throttle().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_screen_saver_call_un_throttle_finish (
    OrgFreedesktopScreenSaver *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_screen_saver_call_un_throttle_sync:
 * @proxy: A #OrgFreedesktopScreenSaverProxy.
 * @arg_cookie: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.UnThrottle">UnThrottle()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_screen_saver_call_un_throttle() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_screen_saver_call_un_throttle_sync (
    OrgFreedesktopScreenSaver *proxy,
    guint arg_cookie,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UnThrottle",
    g_variant_new ("(u)",
                   arg_cookie),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_screen_saver_complete_lock:
 * @object: A #OrgFreedesktopScreenSaver.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.Lock">Lock()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_screen_saver_complete_lock (
    OrgFreedesktopScreenSaver *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_freedesktop_screen_saver_complete_simulate_user_activity:
 * @object: A #OrgFreedesktopScreenSaver.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.SimulateUserActivity">SimulateUserActivity()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_screen_saver_complete_simulate_user_activity (
    OrgFreedesktopScreenSaver *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_freedesktop_screen_saver_complete_get_active:
 * @object: A #OrgFreedesktopScreenSaver.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @unnamed_arg0: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.GetActive">GetActive()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_screen_saver_complete_get_active (
    OrgFreedesktopScreenSaver *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean unnamed_arg0)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   unnamed_arg0));
}

/**
 * org_freedesktop_screen_saver_complete_get_active_time:
 * @object: A #OrgFreedesktopScreenSaver.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @seconds: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.GetActiveTime">GetActiveTime()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_screen_saver_complete_get_active_time (
    OrgFreedesktopScreenSaver *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint seconds)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   seconds));
}

/**
 * org_freedesktop_screen_saver_complete_get_session_idle_time:
 * @object: A #OrgFreedesktopScreenSaver.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @seconds: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.GetSessionIdleTime">GetSessionIdleTime()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_screen_saver_complete_get_session_idle_time (
    OrgFreedesktopScreenSaver *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint seconds)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   seconds));
}

/**
 * org_freedesktop_screen_saver_complete_set_active:
 * @object: A #OrgFreedesktopScreenSaver.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @unnamed_arg1: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.SetActive">SetActive()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_screen_saver_complete_set_active (
    OrgFreedesktopScreenSaver *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean unnamed_arg1)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   unnamed_arg1));
}

/**
 * org_freedesktop_screen_saver_complete_inhibit:
 * @object: A #OrgFreedesktopScreenSaver.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @cookie: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.Inhibit">Inhibit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_screen_saver_complete_inhibit (
    OrgFreedesktopScreenSaver *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint cookie)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   cookie));
}

/**
 * org_freedesktop_screen_saver_complete_un_inhibit:
 * @object: A #OrgFreedesktopScreenSaver.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.UnInhibit">UnInhibit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_screen_saver_complete_un_inhibit (
    OrgFreedesktopScreenSaver *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_freedesktop_screen_saver_complete_throttle:
 * @object: A #OrgFreedesktopScreenSaver.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @cookie: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.Throttle">Throttle()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_screen_saver_complete_throttle (
    OrgFreedesktopScreenSaver *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint cookie)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   cookie));
}

/**
 * org_freedesktop_screen_saver_complete_un_throttle:
 * @object: A #OrgFreedesktopScreenSaver.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ScreenSaver.UnThrottle">UnThrottle()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_screen_saver_complete_un_throttle (
    OrgFreedesktopScreenSaver *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * OrgFreedesktopScreenSaverProxy:
 *
 * The #OrgFreedesktopScreenSaverProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgFreedesktopScreenSaverProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgFreedesktopScreenSaverProxy.
 */

struct _OrgFreedesktopScreenSaverProxyPrivate
{
  GData *qdata;
};

static void org_freedesktop_screen_saver_proxy_iface_init (OrgFreedesktopScreenSaverIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgFreedesktopScreenSaverProxy, org_freedesktop_screen_saver_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (OrgFreedesktopScreenSaverProxy)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_FREEDESKTOP_SCREEN_SAVER, org_freedesktop_screen_saver_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgFreedesktopScreenSaverProxy, org_freedesktop_screen_saver_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_FREEDESKTOP_SCREEN_SAVER, org_freedesktop_screen_saver_proxy_iface_init))

#endif
static void
org_freedesktop_screen_saver_proxy_finalize (GObject *object)
{
  OrgFreedesktopScreenSaverProxy *proxy = ORG_FREEDESKTOP_SCREEN_SAVER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (org_freedesktop_screen_saver_proxy_parent_class)->finalize (object);
}

static void
org_freedesktop_screen_saver_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
org_freedesktop_screen_saver_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
org_freedesktop_screen_saver_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_org_freedesktop_screen_saver_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TYPE_ORG_FREEDESKTOP_SCREEN_SAVER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_FREEDESKTOP_SCREEN_SAVER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
org_freedesktop_screen_saver_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  OrgFreedesktopScreenSaverProxy *proxy = ORG_FREEDESKTOP_SCREEN_SAVER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_freedesktop_screen_saver_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_freedesktop_screen_saver_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
org_freedesktop_screen_saver_proxy_init (OrgFreedesktopScreenSaverProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = org_freedesktop_screen_saver_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TYPE_ORG_FREEDESKTOP_SCREEN_SAVER_PROXY, OrgFreedesktopScreenSaverProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), org_freedesktop_screen_saver_interface_info ());
}

static void
org_freedesktop_screen_saver_proxy_class_init (OrgFreedesktopScreenSaverProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = org_freedesktop_screen_saver_proxy_finalize;
  gobject_class->get_property = org_freedesktop_screen_saver_proxy_get_property;
  gobject_class->set_property = org_freedesktop_screen_saver_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = org_freedesktop_screen_saver_proxy_g_signal;
  proxy_class->g_properties_changed = org_freedesktop_screen_saver_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgFreedesktopScreenSaverProxyPrivate));
#endif
}

static void
org_freedesktop_screen_saver_proxy_iface_init (OrgFreedesktopScreenSaverIface *iface G_GNUC_UNUSED)
{
}

/**
 * org_freedesktop_screen_saver_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ScreenSaver.top_of_page">org.freedesktop.ScreenSaver</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_screen_saver_proxy_new_finish() to get the result of the operation.
 *
 * See org_freedesktop_screen_saver_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
org_freedesktop_screen_saver_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_FREEDESKTOP_SCREEN_SAVER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ScreenSaver", NULL);
}

/**
 * org_freedesktop_screen_saver_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_screen_saver_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_freedesktop_screen_saver_proxy_new().
 *
 * Returns: (transfer full) (type OrgFreedesktopScreenSaverProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgFreedesktopScreenSaver *
org_freedesktop_screen_saver_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_FREEDESKTOP_SCREEN_SAVER (ret);
  else
    return NULL;
}

/**
 * org_freedesktop_screen_saver_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ScreenSaver.top_of_page">org.freedesktop.ScreenSaver</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_screen_saver_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgFreedesktopScreenSaverProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgFreedesktopScreenSaver *
org_freedesktop_screen_saver_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_FREEDESKTOP_SCREEN_SAVER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ScreenSaver", NULL);
  if (ret != NULL)
    return ORG_FREEDESKTOP_SCREEN_SAVER (ret);
  else
    return NULL;
}


/**
 * org_freedesktop_screen_saver_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like org_freedesktop_screen_saver_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_screen_saver_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See org_freedesktop_screen_saver_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
org_freedesktop_screen_saver_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_FREEDESKTOP_SCREEN_SAVER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ScreenSaver", NULL);
}

/**
 * org_freedesktop_screen_saver_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_screen_saver_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_freedesktop_screen_saver_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type OrgFreedesktopScreenSaverProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgFreedesktopScreenSaver *
org_freedesktop_screen_saver_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_FREEDESKTOP_SCREEN_SAVER (ret);
  else
    return NULL;
}

/**
 * org_freedesktop_screen_saver_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like org_freedesktop_screen_saver_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_screen_saver_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgFreedesktopScreenSaverProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgFreedesktopScreenSaver *
org_freedesktop_screen_saver_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_FREEDESKTOP_SCREEN_SAVER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ScreenSaver", NULL);
  if (ret != NULL)
    return ORG_FREEDESKTOP_SCREEN_SAVER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * OrgFreedesktopScreenSaverSkeleton:
 *
 * The #OrgFreedesktopScreenSaverSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgFreedesktopScreenSaverSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgFreedesktopScreenSaverSkeleton.
 */

struct _OrgFreedesktopScreenSaverSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_org_freedesktop_screen_saver_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  OrgFreedesktopScreenSaverSkeleton *skeleton = ORG_FREEDESKTOP_SCREEN_SAVER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TYPE_ORG_FREEDESKTOP_SCREEN_SAVER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_FREEDESKTOP_SCREEN_SAVER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_org_freedesktop_screen_saver_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  OrgFreedesktopScreenSaverSkeleton *skeleton = ORG_FREEDESKTOP_SCREEN_SAVER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_freedesktop_screen_saver_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_org_freedesktop_screen_saver_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  OrgFreedesktopScreenSaverSkeleton *skeleton = ORG_FREEDESKTOP_SCREEN_SAVER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_freedesktop_screen_saver_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _org_freedesktop_screen_saver_skeleton_vtable =
{
  _org_freedesktop_screen_saver_skeleton_handle_method_call,
  _org_freedesktop_screen_saver_skeleton_handle_get_property,
  _org_freedesktop_screen_saver_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
org_freedesktop_screen_saver_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return org_freedesktop_screen_saver_interface_info ();
}

static GDBusInterfaceVTable *
org_freedesktop_screen_saver_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_org_freedesktop_screen_saver_skeleton_vtable;
}

static GVariant *
org_freedesktop_screen_saver_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  OrgFreedesktopScreenSaverSkeleton *skeleton = ORG_FREEDESKTOP_SCREEN_SAVER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_org_freedesktop_screen_saver_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _org_freedesktop_screen_saver_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _org_freedesktop_screen_saver_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _org_freedesktop_screen_saver_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.ScreenSaver", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
org_freedesktop_screen_saver_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_org_freedesktop_screen_saver_on_signal_active_changed (
    OrgFreedesktopScreenSaver *object,
    gboolean arg_unnamed_arg0)
{
  OrgFreedesktopScreenSaverSkeleton *skeleton = ORG_FREEDESKTOP_SCREEN_SAVER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(b)",
                   arg_unnamed_arg0));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.ScreenSaver", "ActiveChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void org_freedesktop_screen_saver_skeleton_iface_init (OrgFreedesktopScreenSaverIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgFreedesktopScreenSaverSkeleton, org_freedesktop_screen_saver_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (OrgFreedesktopScreenSaverSkeleton)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_FREEDESKTOP_SCREEN_SAVER, org_freedesktop_screen_saver_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgFreedesktopScreenSaverSkeleton, org_freedesktop_screen_saver_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_FREEDESKTOP_SCREEN_SAVER, org_freedesktop_screen_saver_skeleton_iface_init))

#endif
static void
org_freedesktop_screen_saver_skeleton_finalize (GObject *object)
{
  OrgFreedesktopScreenSaverSkeleton *skeleton = ORG_FREEDESKTOP_SCREEN_SAVER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (org_freedesktop_screen_saver_skeleton_parent_class)->finalize (object);
}

static void
org_freedesktop_screen_saver_skeleton_init (OrgFreedesktopScreenSaverSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = org_freedesktop_screen_saver_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TYPE_ORG_FREEDESKTOP_SCREEN_SAVER_SKELETON, OrgFreedesktopScreenSaverSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
org_freedesktop_screen_saver_skeleton_class_init (OrgFreedesktopScreenSaverSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = org_freedesktop_screen_saver_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = org_freedesktop_screen_saver_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = org_freedesktop_screen_saver_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = org_freedesktop_screen_saver_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = org_freedesktop_screen_saver_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgFreedesktopScreenSaverSkeletonPrivate));
#endif
}

static void
org_freedesktop_screen_saver_skeleton_iface_init (OrgFreedesktopScreenSaverIface *iface)
{
  iface->active_changed = _org_freedesktop_screen_saver_on_signal_active_changed;
}

/**
 * org_freedesktop_screen_saver_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ScreenSaver.top_of_page">org.freedesktop.ScreenSaver</link>.
 *
 * Returns: (transfer full) (type OrgFreedesktopScreenSaverSkeleton): The skeleton object.
 */
OrgFreedesktopScreenSaver *
org_freedesktop_screen_saver_skeleton_new (void)
{
  return ORG_FREEDESKTOP_SCREEN_SAVER (g_object_new (TYPE_ORG_FREEDESKTOP_SCREEN_SAVER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.ScreenSaver
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:OrgGnomeScreenSaver
 * @title: OrgGnomeScreenSaver
 * @short_description: Generated C code for the org.gnome.ScreenSaver D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-ScreenSaver.top_of_page">org.gnome.ScreenSaver</link> D-Bus interface in C.
 */

enum
{
  _ORG_GNOME_SCREEN_SAVER_ACTIVE_CHANGED,
};

static unsigned _ORG_GNOME_SCREEN_SAVER_SIGNALS[1] = { 0 };

/* ---- Introspection data for org.gnome.ScreenSaver ---- */

static const _ExtendedGDBusMethodInfo _org_gnome_screen_saver_method_info_lock =
{
  {
    -1,
    (gchar *) "Lock",
    NULL,
    NULL,
    NULL
  },
  "handle-lock",
  FALSE
};

static const _ExtendedGDBusMethodInfo _org_gnome_screen_saver_method_info_simulate_user_activity =
{
  {
    -1,
    (gchar *) "SimulateUserActivity",
    NULL,
    NULL,
    NULL
  },
  "handle-simulate-user-activity",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_screen_saver_method_info_get_active_OUT_ARG_arg_0 =
{
  {
    -1,
    (gchar *) "arg_0",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_screen_saver_method_info_get_active_OUT_ARG_pointers[] =
{
  &_org_gnome_screen_saver_method_info_get_active_OUT_ARG_arg_0.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_screen_saver_method_info_get_active =
{
  {
    -1,
    (gchar *) "GetActive",
    NULL,
    (GDBusArgInfo **) &_org_gnome_screen_saver_method_info_get_active_OUT_ARG_pointers,
    NULL
  },
  "handle-get-active",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_screen_saver_method_info_get_active_time_OUT_ARG_seconds =
{
  {
    -1,
    (gchar *) "seconds",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_screen_saver_method_info_get_active_time_OUT_ARG_pointers[] =
{
  &_org_gnome_screen_saver_method_info_get_active_time_OUT_ARG_seconds.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_screen_saver_method_info_get_active_time =
{
  {
    -1,
    (gchar *) "GetActiveTime",
    NULL,
    (GDBusArgInfo **) &_org_gnome_screen_saver_method_info_get_active_time_OUT_ARG_pointers,
    NULL
  },
  "handle-get-active-time",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_screen_saver_method_info_set_active_IN_ARG_e =
{
  {
    -1,
    (gchar *) "e",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_screen_saver_method_info_set_active_IN_ARG_pointers[] =
{
  &_org_gnome_screen_saver_method_info_set_active_IN_ARG_e.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_screen_saver_method_info_set_active =
{
  {
    -1,
    (gchar *) "SetActive",
    (GDBusArgInfo **) &_org_gnome_screen_saver_method_info_set_active_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-active",
  FALSE
};

static const GDBusMethodInfo * const _org_gnome_screen_saver_method_info_pointers[] =
{
  &_org_gnome_screen_saver_method_info_lock.parent_struct,
  &_org_gnome_screen_saver_method_info_simulate_user_activity.parent_struct,
  &_org_gnome_screen_saver_method_info_get_active.parent_struct,
  &_org_gnome_screen_saver_method_info_get_active_time.parent_struct,
  &_org_gnome_screen_saver_method_info_set_active.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_gnome_screen_saver_signal_info_active_changed_ARG_arg_0 =
{
  {
    -1,
    (gchar *) "arg_0",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_screen_saver_signal_info_active_changed_ARG_pointers[] =
{
  &_org_gnome_screen_saver_signal_info_active_changed_ARG_arg_0.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _org_gnome_screen_saver_signal_info_active_changed =
{
  {
    -1,
    (gchar *) "ActiveChanged",
    (GDBusArgInfo **) &_org_gnome_screen_saver_signal_info_active_changed_ARG_pointers,
    NULL
  },
  "active-changed"
};

static const GDBusSignalInfo * const _org_gnome_screen_saver_signal_info_pointers[] =
{
  &_org_gnome_screen_saver_signal_info_active_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _org_gnome_screen_saver_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.ScreenSaver",
    (GDBusMethodInfo **) &_org_gnome_screen_saver_method_info_pointers,
    (GDBusSignalInfo **) &_org_gnome_screen_saver_signal_info_pointers,
    NULL,
    NULL
  },
  "org-gnome-screen-saver",
};


/**
 * org_gnome_screen_saver_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-ScreenSaver.top_of_page">org.gnome.ScreenSaver</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
org_gnome_screen_saver_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_org_gnome_screen_saver_interface_info.parent_struct;
}

/**
 * org_gnome_screen_saver_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #OrgGnomeScreenSaver interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
org_gnome_screen_saver_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
org_gnome_screen_saver_signal_marshal_active_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_gnome_screen_saver_method_marshal_lock (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_gnome_screen_saver_method_marshal_simulate_user_activity (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_gnome_screen_saver_method_marshal_get_active (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_gnome_screen_saver_method_marshal_get_active_time (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_gnome_screen_saver_method_marshal_set_active (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * OrgGnomeScreenSaver:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-ScreenSaver.top_of_page">org.gnome.ScreenSaver</link>.
 */

/**
 * OrgGnomeScreenSaverIface:
 * @parent_iface: The parent interface.
 * @handle_get_active: Handler for the #OrgGnomeScreenSaver::handle-get-active signal.
 * @handle_get_active_time: Handler for the #OrgGnomeScreenSaver::handle-get-active-time signal.
 * @handle_lock: Handler for the #OrgGnomeScreenSaver::handle-lock signal.
 * @handle_set_active: Handler for the #OrgGnomeScreenSaver::handle-set-active signal.
 * @handle_simulate_user_activity: Handler for the #OrgGnomeScreenSaver::handle-simulate-user-activity signal.
 * @active_changed: Handler for the #OrgGnomeScreenSaver::active-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-ScreenSaver.top_of_page">org.gnome.ScreenSaver</link>.
 */

typedef OrgGnomeScreenSaverIface OrgGnomeScreenSaverInterface;
G_DEFINE_INTERFACE (OrgGnomeScreenSaver, org_gnome_screen_saver, G_TYPE_OBJECT)

static void
org_gnome_screen_saver_default_init (OrgGnomeScreenSaverIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * OrgGnomeScreenSaver::handle-lock:
   * @object: A #OrgGnomeScreenSaver.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-ScreenSaver.Lock">Lock()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_screen_saver_complete_lock() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-lock",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeScreenSaverIface, handle_lock),
    g_signal_accumulator_true_handled,
    NULL,
      org_gnome_screen_saver_method_marshal_lock,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * OrgGnomeScreenSaver::handle-simulate-user-activity:
   * @object: A #OrgGnomeScreenSaver.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-ScreenSaver.SimulateUserActivity">SimulateUserActivity()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_screen_saver_complete_simulate_user_activity() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-simulate-user-activity",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeScreenSaverIface, handle_simulate_user_activity),
    g_signal_accumulator_true_handled,
    NULL,
      org_gnome_screen_saver_method_marshal_simulate_user_activity,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * OrgGnomeScreenSaver::handle-get-active:
   * @object: A #OrgGnomeScreenSaver.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-ScreenSaver.GetActive">GetActive()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_screen_saver_complete_get_active() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-active",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeScreenSaverIface, handle_get_active),
    g_signal_accumulator_true_handled,
    NULL,
      org_gnome_screen_saver_method_marshal_get_active,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * OrgGnomeScreenSaver::handle-get-active-time:
   * @object: A #OrgGnomeScreenSaver.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-ScreenSaver.GetActiveTime">GetActiveTime()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_screen_saver_complete_get_active_time() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-active-time",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeScreenSaverIface, handle_get_active_time),
    g_signal_accumulator_true_handled,
    NULL,
      org_gnome_screen_saver_method_marshal_get_active_time,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * OrgGnomeScreenSaver::handle-set-active:
   * @object: A #OrgGnomeScreenSaver.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_e: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-ScreenSaver.SetActive">SetActive()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_screen_saver_complete_set_active() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-active",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeScreenSaverIface, handle_set_active),
    g_signal_accumulator_true_handled,
    NULL,
      org_gnome_screen_saver_method_marshal_set_active,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN);

  /* GObject signals for received D-Bus signals: */
  /**
   * OrgGnomeScreenSaver::active-changed:
   * @object: A #OrgGnomeScreenSaver.
   * @arg_arg_0: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-ScreenSaver.ActiveChanged">"ActiveChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  _ORG_GNOME_SCREEN_SAVER_SIGNALS[_ORG_GNOME_SCREEN_SAVER_ACTIVE_CHANGED] =
    g_signal_new ("active-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (OrgGnomeScreenSaverIface, active_changed),
      NULL,
      NULL,
      org_gnome_screen_saver_signal_marshal_active_changed,
      G_TYPE_NONE,
      1, G_TYPE_BOOLEAN);

}

/**
 * org_gnome_screen_saver_emit_active_changed:
 * @object: A #OrgGnomeScreenSaver.
 * @arg_arg_0: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-ScreenSaver.ActiveChanged">"ActiveChanged"</link> D-Bus signal.
 */
void
org_gnome_screen_saver_emit_active_changed (
    OrgGnomeScreenSaver *object,
    gboolean arg_arg_0)
{
  g_signal_emit (object, _ORG_GNOME_SCREEN_SAVER_SIGNALS[_ORG_GNOME_SCREEN_SAVER_ACTIVE_CHANGED], 0, arg_arg_0);
}

/**
 * org_gnome_screen_saver_call_lock:
 * @proxy: A #OrgGnomeScreenSaverProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-ScreenSaver.Lock">Lock()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_screen_saver_call_lock_finish() to get the result of the operation.
 *
 * See org_gnome_screen_saver_call_lock_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_screen_saver_call_lock (
    OrgGnomeScreenSaver *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Lock",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_screen_saver_call_lock_finish:
 * @proxy: A #OrgGnomeScreenSaverProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_screen_saver_call_lock().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_screen_saver_call_lock().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_screen_saver_call_lock_finish (
    OrgGnomeScreenSaver *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_screen_saver_call_lock_sync:
 * @proxy: A #OrgGnomeScreenSaverProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-ScreenSaver.Lock">Lock()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_screen_saver_call_lock() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_screen_saver_call_lock_sync (
    OrgGnomeScreenSaver *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Lock",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_screen_saver_call_simulate_user_activity:
 * @proxy: A #OrgGnomeScreenSaverProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-ScreenSaver.SimulateUserActivity">SimulateUserActivity()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_screen_saver_call_simulate_user_activity_finish() to get the result of the operation.
 *
 * See org_gnome_screen_saver_call_simulate_user_activity_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_screen_saver_call_simulate_user_activity (
    OrgGnomeScreenSaver *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SimulateUserActivity",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_screen_saver_call_simulate_user_activity_finish:
 * @proxy: A #OrgGnomeScreenSaverProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_screen_saver_call_simulate_user_activity().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_screen_saver_call_simulate_user_activity().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_screen_saver_call_simulate_user_activity_finish (
    OrgGnomeScreenSaver *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_screen_saver_call_simulate_user_activity_sync:
 * @proxy: A #OrgGnomeScreenSaverProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-ScreenSaver.SimulateUserActivity">SimulateUserActivity()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_screen_saver_call_simulate_user_activity() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_screen_saver_call_simulate_user_activity_sync (
    OrgGnomeScreenSaver *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SimulateUserActivity",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_screen_saver_call_get_active:
 * @proxy: A #OrgGnomeScreenSaverProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-ScreenSaver.GetActive">GetActive()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_screen_saver_call_get_active_finish() to get the result of the operation.
 *
 * See org_gnome_screen_saver_call_get_active_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_screen_saver_call_get_active (
    OrgGnomeScreenSaver *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetActive",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_screen_saver_call_get_active_finish:
 * @proxy: A #OrgGnomeScreenSaverProxy.
 * @out_arg_0: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_screen_saver_call_get_active().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_screen_saver_call_get_active().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_screen_saver_call_get_active_finish (
    OrgGnomeScreenSaver *proxy,
    gboolean *out_arg_0,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_arg_0);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_screen_saver_call_get_active_sync:
 * @proxy: A #OrgGnomeScreenSaverProxy.
 * @out_arg_0: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-ScreenSaver.GetActive">GetActive()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_screen_saver_call_get_active() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_screen_saver_call_get_active_sync (
    OrgGnomeScreenSaver *proxy,
    gboolean *out_arg_0,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetActive",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_arg_0);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_screen_saver_call_get_active_time:
 * @proxy: A #OrgGnomeScreenSaverProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-ScreenSaver.GetActiveTime">GetActiveTime()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_screen_saver_call_get_active_time_finish() to get the result of the operation.
 *
 * See org_gnome_screen_saver_call_get_active_time_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_screen_saver_call_get_active_time (
    OrgGnomeScreenSaver *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetActiveTime",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_screen_saver_call_get_active_time_finish:
 * @proxy: A #OrgGnomeScreenSaverProxy.
 * @out_seconds: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_screen_saver_call_get_active_time().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_screen_saver_call_get_active_time().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_screen_saver_call_get_active_time_finish (
    OrgGnomeScreenSaver *proxy,
    guint *out_seconds,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_seconds);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_screen_saver_call_get_active_time_sync:
 * @proxy: A #OrgGnomeScreenSaverProxy.
 * @out_seconds: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-ScreenSaver.GetActiveTime">GetActiveTime()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_screen_saver_call_get_active_time() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_screen_saver_call_get_active_time_sync (
    OrgGnomeScreenSaver *proxy,
    guint *out_seconds,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetActiveTime",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_seconds);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_screen_saver_call_set_active:
 * @proxy: A #OrgGnomeScreenSaverProxy.
 * @arg_e: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-ScreenSaver.SetActive">SetActive()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_screen_saver_call_set_active_finish() to get the result of the operation.
 *
 * See org_gnome_screen_saver_call_set_active_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_screen_saver_call_set_active (
    OrgGnomeScreenSaver *proxy,
    gboolean arg_e,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetActive",
    g_variant_new ("(b)",
                   arg_e),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_screen_saver_call_set_active_finish:
 * @proxy: A #OrgGnomeScreenSaverProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_screen_saver_call_set_active().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_screen_saver_call_set_active().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_screen_saver_call_set_active_finish (
    OrgGnomeScreenSaver *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_screen_saver_call_set_active_sync:
 * @proxy: A #OrgGnomeScreenSaverProxy.
 * @arg_e: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-ScreenSaver.SetActive">SetActive()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_screen_saver_call_set_active() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_screen_saver_call_set_active_sync (
    OrgGnomeScreenSaver *proxy,
    gboolean arg_e,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetActive",
    g_variant_new ("(b)",
                   arg_e),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_screen_saver_complete_lock:
 * @object: A #OrgGnomeScreenSaver.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-ScreenSaver.Lock">Lock()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_screen_saver_complete_lock (
    OrgGnomeScreenSaver *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_gnome_screen_saver_complete_simulate_user_activity:
 * @object: A #OrgGnomeScreenSaver.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-ScreenSaver.SimulateUserActivity">SimulateUserActivity()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_screen_saver_complete_simulate_user_activity (
    OrgGnomeScreenSaver *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_gnome_screen_saver_complete_get_active:
 * @object: A #OrgGnomeScreenSaver.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @arg_0: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-ScreenSaver.GetActive">GetActive()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_screen_saver_complete_get_active (
    OrgGnomeScreenSaver *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean arg_0)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   arg_0));
}

/**
 * org_gnome_screen_saver_complete_get_active_time:
 * @object: A #OrgGnomeScreenSaver.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @seconds: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-ScreenSaver.GetActiveTime">GetActiveTime()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_screen_saver_complete_get_active_time (
    OrgGnomeScreenSaver *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint seconds)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   seconds));
}

/**
 * org_gnome_screen_saver_complete_set_active:
 * @object: A #OrgGnomeScreenSaver.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-ScreenSaver.SetActive">SetActive()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_screen_saver_complete_set_active (
    OrgGnomeScreenSaver *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * OrgGnomeScreenSaverProxy:
 *
 * The #OrgGnomeScreenSaverProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgGnomeScreenSaverProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgGnomeScreenSaverProxy.
 */

struct _OrgGnomeScreenSaverProxyPrivate
{
  GData *qdata;
};

static void org_gnome_screen_saver_proxy_iface_init (OrgGnomeScreenSaverIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgGnomeScreenSaverProxy, org_gnome_screen_saver_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (OrgGnomeScreenSaverProxy)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_SCREEN_SAVER, org_gnome_screen_saver_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgGnomeScreenSaverProxy, org_gnome_screen_saver_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_SCREEN_SAVER, org_gnome_screen_saver_proxy_iface_init))

#endif
static void
org_gnome_screen_saver_proxy_finalize (GObject *object)
{
  OrgGnomeScreenSaverProxy *proxy = ORG_GNOME_SCREEN_SAVER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (org_gnome_screen_saver_proxy_parent_class)->finalize (object);
}

static void
org_gnome_screen_saver_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
org_gnome_screen_saver_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
org_gnome_screen_saver_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_org_gnome_screen_saver_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TYPE_ORG_GNOME_SCREEN_SAVER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_GNOME_SCREEN_SAVER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
org_gnome_screen_saver_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  OrgGnomeScreenSaverProxy *proxy = ORG_GNOME_SCREEN_SAVER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_screen_saver_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_screen_saver_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
org_gnome_screen_saver_proxy_init (OrgGnomeScreenSaverProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = org_gnome_screen_saver_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TYPE_ORG_GNOME_SCREEN_SAVER_PROXY, OrgGnomeScreenSaverProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), org_gnome_screen_saver_interface_info ());
}

static void
org_gnome_screen_saver_proxy_class_init (OrgGnomeScreenSaverProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = org_gnome_screen_saver_proxy_finalize;
  gobject_class->get_property = org_gnome_screen_saver_proxy_get_property;
  gobject_class->set_property = org_gnome_screen_saver_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = org_gnome_screen_saver_proxy_g_signal;
  proxy_class->g_properties_changed = org_gnome_screen_saver_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgGnomeScreenSaverProxyPrivate));
#endif
}

static void
org_gnome_screen_saver_proxy_iface_init (OrgGnomeScreenSaverIface *iface G_GNUC_UNUSED)
{
}

/**
 * org_gnome_screen_saver_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-ScreenSaver.top_of_page">org.gnome.ScreenSaver</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_screen_saver_proxy_new_finish() to get the result of the operation.
 *
 * See org_gnome_screen_saver_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
org_gnome_screen_saver_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_GNOME_SCREEN_SAVER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.ScreenSaver", NULL);
}

/**
 * org_gnome_screen_saver_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_screen_saver_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_gnome_screen_saver_proxy_new().
 *
 * Returns: (transfer full) (type OrgGnomeScreenSaverProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeScreenSaver *
org_gnome_screen_saver_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_GNOME_SCREEN_SAVER (ret);
  else
    return NULL;
}

/**
 * org_gnome_screen_saver_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-ScreenSaver.top_of_page">org.gnome.ScreenSaver</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_gnome_screen_saver_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgGnomeScreenSaverProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeScreenSaver *
org_gnome_screen_saver_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_GNOME_SCREEN_SAVER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.ScreenSaver", NULL);
  if (ret != NULL)
    return ORG_GNOME_SCREEN_SAVER (ret);
  else
    return NULL;
}


/**
 * org_gnome_screen_saver_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like org_gnome_screen_saver_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_screen_saver_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See org_gnome_screen_saver_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
org_gnome_screen_saver_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_GNOME_SCREEN_SAVER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.ScreenSaver", NULL);
}

/**
 * org_gnome_screen_saver_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_screen_saver_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_gnome_screen_saver_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type OrgGnomeScreenSaverProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeScreenSaver *
org_gnome_screen_saver_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_GNOME_SCREEN_SAVER (ret);
  else
    return NULL;
}

/**
 * org_gnome_screen_saver_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like org_gnome_screen_saver_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_gnome_screen_saver_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgGnomeScreenSaverProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeScreenSaver *
org_gnome_screen_saver_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_GNOME_SCREEN_SAVER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.ScreenSaver", NULL);
  if (ret != NULL)
    return ORG_GNOME_SCREEN_SAVER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * OrgGnomeScreenSaverSkeleton:
 *
 * The #OrgGnomeScreenSaverSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgGnomeScreenSaverSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgGnomeScreenSaverSkeleton.
 */

struct _OrgGnomeScreenSaverSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_org_gnome_screen_saver_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  OrgGnomeScreenSaverSkeleton *skeleton = ORG_GNOME_SCREEN_SAVER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TYPE_ORG_GNOME_SCREEN_SAVER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_GNOME_SCREEN_SAVER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_org_gnome_screen_saver_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  OrgGnomeScreenSaverSkeleton *skeleton = ORG_GNOME_SCREEN_SAVER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_screen_saver_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_org_gnome_screen_saver_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  OrgGnomeScreenSaverSkeleton *skeleton = ORG_GNOME_SCREEN_SAVER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_screen_saver_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _org_gnome_screen_saver_skeleton_vtable =
{
  _org_gnome_screen_saver_skeleton_handle_method_call,
  _org_gnome_screen_saver_skeleton_handle_get_property,
  _org_gnome_screen_saver_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
org_gnome_screen_saver_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return org_gnome_screen_saver_interface_info ();
}

static GDBusInterfaceVTable *
org_gnome_screen_saver_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_org_gnome_screen_saver_skeleton_vtable;
}

static GVariant *
org_gnome_screen_saver_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  OrgGnomeScreenSaverSkeleton *skeleton = ORG_GNOME_SCREEN_SAVER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_org_gnome_screen_saver_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _org_gnome_screen_saver_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _org_gnome_screen_saver_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _org_gnome_screen_saver_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.ScreenSaver", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
org_gnome_screen_saver_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_org_gnome_screen_saver_on_signal_active_changed (
    OrgGnomeScreenSaver *object,
    gboolean arg_arg_0)
{
  OrgGnomeScreenSaverSkeleton *skeleton = ORG_GNOME_SCREEN_SAVER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(b)",
                   arg_arg_0));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.ScreenSaver", "ActiveChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void org_gnome_screen_saver_skeleton_iface_init (OrgGnomeScreenSaverIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgGnomeScreenSaverSkeleton, org_gnome_screen_saver_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (OrgGnomeScreenSaverSkeleton)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_SCREEN_SAVER, org_gnome_screen_saver_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgGnomeScreenSaverSkeleton, org_gnome_screen_saver_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_SCREEN_SAVER, org_gnome_screen_saver_skeleton_iface_init))

#endif
static void
org_gnome_screen_saver_skeleton_finalize (GObject *object)
{
  OrgGnomeScreenSaverSkeleton *skeleton = ORG_GNOME_SCREEN_SAVER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (org_gnome_screen_saver_skeleton_parent_class)->finalize (object);
}

static void
org_gnome_screen_saver_skeleton_init (OrgGnomeScreenSaverSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = org_gnome_screen_saver_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TYPE_ORG_GNOME_SCREEN_SAVER_SKELETON, OrgGnomeScreenSaverSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
org_gnome_screen_saver_skeleton_class_init (OrgGnomeScreenSaverSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = org_gnome_screen_saver_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = org_gnome_screen_saver_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = org_gnome_screen_saver_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = org_gnome_screen_saver_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = org_gnome_screen_saver_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgGnomeScreenSaverSkeletonPrivate));
#endif
}

static void
org_gnome_screen_saver_skeleton_iface_init (OrgGnomeScreenSaverIface *iface)
{
  iface->active_changed = _org_gnome_screen_saver_on_signal_active_changed;
}

/**
 * org_gnome_screen_saver_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-ScreenSaver.top_of_page">org.gnome.ScreenSaver</link>.
 *
 * Returns: (transfer full) (type OrgGnomeScreenSaverSkeleton): The skeleton object.
 */
OrgGnomeScreenSaver *
org_gnome_screen_saver_skeleton_new (void)
{
  return ORG_GNOME_SCREEN_SAVER (g_object_new (TYPE_ORG_GNOME_SCREEN_SAVER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.SessionManager
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:OrgGnomeSessionManager
 * @title: OrgGnomeSessionManager
 * @short_description: Generated C code for the org.gnome.SessionManager D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-SessionManager.top_of_page">org.gnome.SessionManager</link> D-Bus interface in C.
 */

enum
{
  _ORG_GNOME_SESSION_MANAGER_CLIENT_ADDED,
  _ORG_GNOME_SESSION_MANAGER_CLIENT_REMOVED,
  _ORG_GNOME_SESSION_MANAGER_INHIBITOR_ADDED,
  _ORG_GNOME_SESSION_MANAGER_INHIBITOR_REMOVED,
  _ORG_GNOME_SESSION_MANAGER_SESSION_RUNNING,
  _ORG_GNOME_SESSION_MANAGER_SESSION_OVER,
};

static unsigned _ORG_GNOME_SESSION_MANAGER_SIGNALS[6] = { 0 };

/* ---- Introspection data for org.gnome.SessionManager ---- */

static const _ExtendedGDBusArgInfo _org_gnome_session_manager_method_info_setenv_IN_ARG_variable =
{
  {
    -1,
    (gchar *) "variable",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_session_manager_method_info_setenv_IN_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_session_manager_method_info_setenv_IN_ARG_pointers[] =
{
  &_org_gnome_session_manager_method_info_setenv_IN_ARG_variable.parent_struct,
  &_org_gnome_session_manager_method_info_setenv_IN_ARG_value.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_session_manager_method_info_setenv =
{
  {
    -1,
    (gchar *) "Setenv",
    (GDBusArgInfo **) &_org_gnome_session_manager_method_info_setenv_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-setenv",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_session_manager_method_info_initialization_error_IN_ARG_message =
{
  {
    -1,
    (gchar *) "message",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_session_manager_method_info_initialization_error_IN_ARG_fatal =
{
  {
    -1,
    (gchar *) "fatal",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_session_manager_method_info_initialization_error_IN_ARG_pointers[] =
{
  &_org_gnome_session_manager_method_info_initialization_error_IN_ARG_message.parent_struct,
  &_org_gnome_session_manager_method_info_initialization_error_IN_ARG_fatal.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_session_manager_method_info_initialization_error =
{
  {
    -1,
    (gchar *) "InitializationError",
    (GDBusArgInfo **) &_org_gnome_session_manager_method_info_initialization_error_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-initialization-error",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_session_manager_method_info_register_client_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_session_manager_method_info_register_client_IN_ARG_client_startup_id =
{
  {
    -1,
    (gchar *) "client_startup_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_session_manager_method_info_register_client_IN_ARG_pointers[] =
{
  &_org_gnome_session_manager_method_info_register_client_IN_ARG_app_id.parent_struct,
  &_org_gnome_session_manager_method_info_register_client_IN_ARG_client_startup_id.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_gnome_session_manager_method_info_register_client_OUT_ARG_client_id =
{
  {
    -1,
    (gchar *) "client_id",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_session_manager_method_info_register_client_OUT_ARG_pointers[] =
{
  &_org_gnome_session_manager_method_info_register_client_OUT_ARG_client_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_session_manager_method_info_register_client =
{
  {
    -1,
    (gchar *) "RegisterClient",
    (GDBusArgInfo **) &_org_gnome_session_manager_method_info_register_client_IN_ARG_pointers,
    (GDBusArgInfo **) &_org_gnome_session_manager_method_info_register_client_OUT_ARG_pointers,
    NULL
  },
  "handle-register-client",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_session_manager_method_info_unregister_client_IN_ARG_client_id =
{
  {
    -1,
    (gchar *) "client_id",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_session_manager_method_info_unregister_client_IN_ARG_pointers[] =
{
  &_org_gnome_session_manager_method_info_unregister_client_IN_ARG_client_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_session_manager_method_info_unregister_client =
{
  {
    -1,
    (gchar *) "UnregisterClient",
    (GDBusArgInfo **) &_org_gnome_session_manager_method_info_unregister_client_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-unregister-client",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_session_manager_method_info_inhibit_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_session_manager_method_info_inhibit_IN_ARG_toplevel_xid =
{
  {
    -1,
    (gchar *) "toplevel_xid",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_session_manager_method_info_inhibit_IN_ARG_reason =
{
  {
    -1,
    (gchar *) "reason",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_session_manager_method_info_inhibit_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_session_manager_method_info_inhibit_IN_ARG_pointers[] =
{
  &_org_gnome_session_manager_method_info_inhibit_IN_ARG_app_id.parent_struct,
  &_org_gnome_session_manager_method_info_inhibit_IN_ARG_toplevel_xid.parent_struct,
  &_org_gnome_session_manager_method_info_inhibit_IN_ARG_reason.parent_struct,
  &_org_gnome_session_manager_method_info_inhibit_IN_ARG_flags.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_gnome_session_manager_method_info_inhibit_OUT_ARG_inhibit_cookie =
{
  {
    -1,
    (gchar *) "inhibit_cookie",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_session_manager_method_info_inhibit_OUT_ARG_pointers[] =
{
  &_org_gnome_session_manager_method_info_inhibit_OUT_ARG_inhibit_cookie.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_session_manager_method_info_inhibit =
{
  {
    -1,
    (gchar *) "Inhibit",
    (GDBusArgInfo **) &_org_gnome_session_manager_method_info_inhibit_IN_ARG_pointers,
    (GDBusArgInfo **) &_org_gnome_session_manager_method_info_inhibit_OUT_ARG_pointers,
    NULL
  },
  "handle-inhibit",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_session_manager_method_info_uninhibit_IN_ARG_inhibit_cookie =
{
  {
    -1,
    (gchar *) "inhibit_cookie",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_session_manager_method_info_uninhibit_IN_ARG_pointers[] =
{
  &_org_gnome_session_manager_method_info_uninhibit_IN_ARG_inhibit_cookie.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_session_manager_method_info_uninhibit =
{
  {
    -1,
    (gchar *) "Uninhibit",
    (GDBusArgInfo **) &_org_gnome_session_manager_method_info_uninhibit_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-uninhibit",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_session_manager_method_info_is_inhibited_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_session_manager_method_info_is_inhibited_IN_ARG_pointers[] =
{
  &_org_gnome_session_manager_method_info_is_inhibited_IN_ARG_flags.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_gnome_session_manager_method_info_is_inhibited_OUT_ARG_is_inhibited =
{
  {
    -1,
    (gchar *) "is_inhibited",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_session_manager_method_info_is_inhibited_OUT_ARG_pointers[] =
{
  &_org_gnome_session_manager_method_info_is_inhibited_OUT_ARG_is_inhibited.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_session_manager_method_info_is_inhibited =
{
  {
    -1,
    (gchar *) "IsInhibited",
    (GDBusArgInfo **) &_org_gnome_session_manager_method_info_is_inhibited_IN_ARG_pointers,
    (GDBusArgInfo **) &_org_gnome_session_manager_method_info_is_inhibited_OUT_ARG_pointers,
    NULL
  },
  "handle-is-inhibited",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_session_manager_method_info_get_clients_OUT_ARG_clients =
{
  {
    -1,
    (gchar *) "clients",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_session_manager_method_info_get_clients_OUT_ARG_pointers[] =
{
  &_org_gnome_session_manager_method_info_get_clients_OUT_ARG_clients.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_session_manager_method_info_get_clients =
{
  {
    -1,
    (gchar *) "GetClients",
    NULL,
    (GDBusArgInfo **) &_org_gnome_session_manager_method_info_get_clients_OUT_ARG_pointers,
    NULL
  },
  "handle-get-clients",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_session_manager_method_info_get_inhibitors_OUT_ARG_inhibitors =
{
  {
    -1,
    (gchar *) "inhibitors",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_session_manager_method_info_get_inhibitors_OUT_ARG_pointers[] =
{
  &_org_gnome_session_manager_method_info_get_inhibitors_OUT_ARG_inhibitors.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_session_manager_method_info_get_inhibitors =
{
  {
    -1,
    (gchar *) "GetInhibitors",
    NULL,
    (GDBusArgInfo **) &_org_gnome_session_manager_method_info_get_inhibitors_OUT_ARG_pointers,
    NULL
  },
  "handle-get-inhibitors",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_session_manager_method_info_is_autostart_condition_handled_IN_ARG_condition =
{
  {
    -1,
    (gchar *) "condition",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_session_manager_method_info_is_autostart_condition_handled_IN_ARG_pointers[] =
{
  &_org_gnome_session_manager_method_info_is_autostart_condition_handled_IN_ARG_condition.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_gnome_session_manager_method_info_is_autostart_condition_handled_OUT_ARG_handled =
{
  {
    -1,
    (gchar *) "handled",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_session_manager_method_info_is_autostart_condition_handled_OUT_ARG_pointers[] =
{
  &_org_gnome_session_manager_method_info_is_autostart_condition_handled_OUT_ARG_handled.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_session_manager_method_info_is_autostart_condition_handled =
{
  {
    -1,
    (gchar *) "IsAutostartConditionHandled",
    (GDBusArgInfo **) &_org_gnome_session_manager_method_info_is_autostart_condition_handled_IN_ARG_pointers,
    (GDBusArgInfo **) &_org_gnome_session_manager_method_info_is_autostart_condition_handled_OUT_ARG_pointers,
    NULL
  },
  "handle-is-autostart-condition-handled",
  FALSE
};

static const _ExtendedGDBusMethodInfo _org_gnome_session_manager_method_info_shutdown =
{
  {
    -1,
    (gchar *) "Shutdown",
    NULL,
    NULL,
    NULL
  },
  "handle-shutdown",
  FALSE
};

static const _ExtendedGDBusMethodInfo _org_gnome_session_manager_method_info_reboot =
{
  {
    -1,
    (gchar *) "Reboot",
    NULL,
    NULL,
    NULL
  },
  "handle-reboot",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_session_manager_method_info_can_shutdown_OUT_ARG_is_available =
{
  {
    -1,
    (gchar *) "is_available",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_session_manager_method_info_can_shutdown_OUT_ARG_pointers[] =
{
  &_org_gnome_session_manager_method_info_can_shutdown_OUT_ARG_is_available.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_session_manager_method_info_can_shutdown =
{
  {
    -1,
    (gchar *) "CanShutdown",
    NULL,
    (GDBusArgInfo **) &_org_gnome_session_manager_method_info_can_shutdown_OUT_ARG_pointers,
    NULL
  },
  "handle-can-shutdown",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_session_manager_method_info_logout_IN_ARG_mode =
{
  {
    -1,
    (gchar *) "mode",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_session_manager_method_info_logout_IN_ARG_pointers[] =
{
  &_org_gnome_session_manager_method_info_logout_IN_ARG_mode.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_session_manager_method_info_logout =
{
  {
    -1,
    (gchar *) "Logout",
    (GDBusArgInfo **) &_org_gnome_session_manager_method_info_logout_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-logout",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_session_manager_method_info_is_session_running_OUT_ARG_running =
{
  {
    -1,
    (gchar *) "running",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_session_manager_method_info_is_session_running_OUT_ARG_pointers[] =
{
  &_org_gnome_session_manager_method_info_is_session_running_OUT_ARG_running.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_session_manager_method_info_is_session_running =
{
  {
    -1,
    (gchar *) "IsSessionRunning",
    NULL,
    (GDBusArgInfo **) &_org_gnome_session_manager_method_info_is_session_running_OUT_ARG_pointers,
    NULL
  },
  "handle-is-session-running",
  FALSE
};

static const _ExtendedGDBusMethodInfo _org_gnome_session_manager_method_info_request_shutdown =
{
  {
    -1,
    (gchar *) "RequestShutdown",
    NULL,
    NULL,
    NULL
  },
  "handle-request-shutdown",
  FALSE
};

static const _ExtendedGDBusMethodInfo _org_gnome_session_manager_method_info_request_reboot =
{
  {
    -1,
    (gchar *) "RequestReboot",
    NULL,
    NULL,
    NULL
  },
  "handle-request-reboot",
  FALSE
};

static const GDBusMethodInfo * const _org_gnome_session_manager_method_info_pointers[] =
{
  &_org_gnome_session_manager_method_info_setenv.parent_struct,
  &_org_gnome_session_manager_method_info_initialization_error.parent_struct,
  &_org_gnome_session_manager_method_info_register_client.parent_struct,
  &_org_gnome_session_manager_method_info_unregister_client.parent_struct,
  &_org_gnome_session_manager_method_info_inhibit.parent_struct,
  &_org_gnome_session_manager_method_info_uninhibit.parent_struct,
  &_org_gnome_session_manager_method_info_is_inhibited.parent_struct,
  &_org_gnome_session_manager_method_info_get_clients.parent_struct,
  &_org_gnome_session_manager_method_info_get_inhibitors.parent_struct,
  &_org_gnome_session_manager_method_info_is_autostart_condition_handled.parent_struct,
  &_org_gnome_session_manager_method_info_shutdown.parent_struct,
  &_org_gnome_session_manager_method_info_reboot.parent_struct,
  &_org_gnome_session_manager_method_info_can_shutdown.parent_struct,
  &_org_gnome_session_manager_method_info_logout.parent_struct,
  &_org_gnome_session_manager_method_info_is_session_running.parent_struct,
  &_org_gnome_session_manager_method_info_request_shutdown.parent_struct,
  &_org_gnome_session_manager_method_info_request_reboot.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_gnome_session_manager_signal_info_client_added_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_session_manager_signal_info_client_added_ARG_pointers[] =
{
  &_org_gnome_session_manager_signal_info_client_added_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _org_gnome_session_manager_signal_info_client_added =
{
  {
    -1,
    (gchar *) "ClientAdded",
    (GDBusArgInfo **) &_org_gnome_session_manager_signal_info_client_added_ARG_pointers,
    NULL
  },
  "client-added"
};

static const _ExtendedGDBusArgInfo _org_gnome_session_manager_signal_info_client_removed_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_session_manager_signal_info_client_removed_ARG_pointers[] =
{
  &_org_gnome_session_manager_signal_info_client_removed_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _org_gnome_session_manager_signal_info_client_removed =
{
  {
    -1,
    (gchar *) "ClientRemoved",
    (GDBusArgInfo **) &_org_gnome_session_manager_signal_info_client_removed_ARG_pointers,
    NULL
  },
  "client-removed"
};

static const _ExtendedGDBusArgInfo _org_gnome_session_manager_signal_info_inhibitor_added_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_session_manager_signal_info_inhibitor_added_ARG_pointers[] =
{
  &_org_gnome_session_manager_signal_info_inhibitor_added_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _org_gnome_session_manager_signal_info_inhibitor_added =
{
  {
    -1,
    (gchar *) "InhibitorAdded",
    (GDBusArgInfo **) &_org_gnome_session_manager_signal_info_inhibitor_added_ARG_pointers,
    NULL
  },
  "inhibitor-added"
};

static const _ExtendedGDBusArgInfo _org_gnome_session_manager_signal_info_inhibitor_removed_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_session_manager_signal_info_inhibitor_removed_ARG_pointers[] =
{
  &_org_gnome_session_manager_signal_info_inhibitor_removed_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _org_gnome_session_manager_signal_info_inhibitor_removed =
{
  {
    -1,
    (gchar *) "InhibitorRemoved",
    (GDBusArgInfo **) &_org_gnome_session_manager_signal_info_inhibitor_removed_ARG_pointers,
    NULL
  },
  "inhibitor-removed"
};

static const _ExtendedGDBusSignalInfo _org_gnome_session_manager_signal_info_session_running =
{
  {
    -1,
    (gchar *) "SessionRunning",
    NULL,
    NULL
  },
  "session-running"
};

static const _ExtendedGDBusSignalInfo _org_gnome_session_manager_signal_info_session_over =
{
  {
    -1,
    (gchar *) "SessionOver",
    NULL,
    NULL
  },
  "session-over"
};

static const GDBusSignalInfo * const _org_gnome_session_manager_signal_info_pointers[] =
{
  &_org_gnome_session_manager_signal_info_client_added.parent_struct,
  &_org_gnome_session_manager_signal_info_client_removed.parent_struct,
  &_org_gnome_session_manager_signal_info_inhibitor_added.parent_struct,
  &_org_gnome_session_manager_signal_info_inhibitor_removed.parent_struct,
  &_org_gnome_session_manager_signal_info_session_running.parent_struct,
  &_org_gnome_session_manager_signal_info_session_over.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _org_gnome_session_manager_property_info_session_name =
{
  {
    -1,
    (gchar *) "SessionName",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "session-name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _org_gnome_session_manager_property_info_inhibited_actions =
{
  {
    -1,
    (gchar *) "InhibitedActions",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "inhibited-actions",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _org_gnome_session_manager_property_info_pointers[] =
{
  &_org_gnome_session_manager_property_info_session_name.parent_struct,
  &_org_gnome_session_manager_property_info_inhibited_actions.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _org_gnome_session_manager_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.SessionManager",
    (GDBusMethodInfo **) &_org_gnome_session_manager_method_info_pointers,
    (GDBusSignalInfo **) &_org_gnome_session_manager_signal_info_pointers,
    (GDBusPropertyInfo **) &_org_gnome_session_manager_property_info_pointers,
    NULL
  },
  "org-gnome-session-manager",
};


/**
 * org_gnome_session_manager_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-SessionManager.top_of_page">org.gnome.SessionManager</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
org_gnome_session_manager_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_org_gnome_session_manager_interface_info.parent_struct;
}

/**
 * org_gnome_session_manager_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #OrgGnomeSessionManager interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
org_gnome_session_manager_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "session-name");
  g_object_class_override_property (klass, property_id_begin++, "inhibited-actions");
  return property_id_begin - 1;
}


inline static void
org_gnome_session_manager_signal_marshal_client_added (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_gnome_session_manager_signal_marshal_client_removed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_gnome_session_manager_signal_marshal_inhibitor_added (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_gnome_session_manager_signal_marshal_inhibitor_removed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_gnome_session_manager_signal_marshal_session_running (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_gnome_session_manager_signal_marshal_session_over (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_gnome_session_manager_method_marshal_setenv (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_gnome_session_manager_method_marshal_initialization_error (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_gnome_session_manager_method_marshal_register_client (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_gnome_session_manager_method_marshal_unregister_client (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_gnome_session_manager_method_marshal_inhibit (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_UINT_STRING_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_gnome_session_manager_method_marshal_uninhibit (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_gnome_session_manager_method_marshal_is_inhibited (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_gnome_session_manager_method_marshal_get_clients (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_gnome_session_manager_method_marshal_get_inhibitors (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_gnome_session_manager_method_marshal_is_autostart_condition_handled (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_gnome_session_manager_method_marshal_shutdown (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_gnome_session_manager_method_marshal_reboot (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_gnome_session_manager_method_marshal_can_shutdown (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_gnome_session_manager_method_marshal_logout (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_gnome_session_manager_method_marshal_is_session_running (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_gnome_session_manager_method_marshal_request_shutdown (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_gnome_session_manager_method_marshal_request_reboot (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * OrgGnomeSessionManager:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-SessionManager.top_of_page">org.gnome.SessionManager</link>.
 */

/**
 * OrgGnomeSessionManagerIface:
 * @parent_iface: The parent interface.
 * @handle_can_shutdown: Handler for the #OrgGnomeSessionManager::handle-can-shutdown signal.
 * @handle_get_clients: Handler for the #OrgGnomeSessionManager::handle-get-clients signal.
 * @handle_get_inhibitors: Handler for the #OrgGnomeSessionManager::handle-get-inhibitors signal.
 * @handle_inhibit: Handler for the #OrgGnomeSessionManager::handle-inhibit signal.
 * @handle_initialization_error: Handler for the #OrgGnomeSessionManager::handle-initialization-error signal.
 * @handle_is_autostart_condition_handled: Handler for the #OrgGnomeSessionManager::handle-is-autostart-condition-handled signal.
 * @handle_is_inhibited: Handler for the #OrgGnomeSessionManager::handle-is-inhibited signal.
 * @handle_is_session_running: Handler for the #OrgGnomeSessionManager::handle-is-session-running signal.
 * @handle_logout: Handler for the #OrgGnomeSessionManager::handle-logout signal.
 * @handle_reboot: Handler for the #OrgGnomeSessionManager::handle-reboot signal.
 * @handle_register_client: Handler for the #OrgGnomeSessionManager::handle-register-client signal.
 * @handle_request_reboot: Handler for the #OrgGnomeSessionManager::handle-request-reboot signal.
 * @handle_request_shutdown: Handler for the #OrgGnomeSessionManager::handle-request-shutdown signal.
 * @handle_setenv: Handler for the #OrgGnomeSessionManager::handle-setenv signal.
 * @handle_shutdown: Handler for the #OrgGnomeSessionManager::handle-shutdown signal.
 * @handle_uninhibit: Handler for the #OrgGnomeSessionManager::handle-uninhibit signal.
 * @handle_unregister_client: Handler for the #OrgGnomeSessionManager::handle-unregister-client signal.
 * @get_inhibited_actions: Getter for the #OrgGnomeSessionManager:inhibited-actions property.
 * @get_session_name: Getter for the #OrgGnomeSessionManager:session-name property.
 * @client_added: Handler for the #OrgGnomeSessionManager::client-added signal.
 * @client_removed: Handler for the #OrgGnomeSessionManager::client-removed signal.
 * @inhibitor_added: Handler for the #OrgGnomeSessionManager::inhibitor-added signal.
 * @inhibitor_removed: Handler for the #OrgGnomeSessionManager::inhibitor-removed signal.
 * @session_over: Handler for the #OrgGnomeSessionManager::session-over signal.
 * @session_running: Handler for the #OrgGnomeSessionManager::session-running signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-SessionManager.top_of_page">org.gnome.SessionManager</link>.
 */

typedef OrgGnomeSessionManagerIface OrgGnomeSessionManagerInterface;
G_DEFINE_INTERFACE (OrgGnomeSessionManager, org_gnome_session_manager, G_TYPE_OBJECT)

static void
org_gnome_session_manager_default_init (OrgGnomeSessionManagerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * OrgGnomeSessionManager::handle-setenv:
   * @object: A #OrgGnomeSessionManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_variable: Argument passed by remote caller.
   * @arg_value: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-SessionManager.Setenv">Setenv()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_session_manager_complete_setenv() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-setenv",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeSessionManagerIface, handle_setenv),
    g_signal_accumulator_true_handled,
    NULL,
      org_gnome_session_manager_method_marshal_setenv,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * OrgGnomeSessionManager::handle-initialization-error:
   * @object: A #OrgGnomeSessionManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_message: Argument passed by remote caller.
   * @arg_fatal: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-SessionManager.InitializationError">InitializationError()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_session_manager_complete_initialization_error() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-initialization-error",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeSessionManagerIface, handle_initialization_error),
    g_signal_accumulator_true_handled,
    NULL,
      org_gnome_session_manager_method_marshal_initialization_error,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_BOOLEAN);

  /**
   * OrgGnomeSessionManager::handle-register-client:
   * @object: A #OrgGnomeSessionManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_client_startup_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-SessionManager.RegisterClient">RegisterClient()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_session_manager_complete_register_client() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-register-client",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeSessionManagerIface, handle_register_client),
    g_signal_accumulator_true_handled,
    NULL,
      org_gnome_session_manager_method_marshal_register_client,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * OrgGnomeSessionManager::handle-unregister-client:
   * @object: A #OrgGnomeSessionManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_client_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-SessionManager.UnregisterClient">UnregisterClient()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_session_manager_complete_unregister_client() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-unregister-client",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeSessionManagerIface, handle_unregister_client),
    g_signal_accumulator_true_handled,
    NULL,
      org_gnome_session_manager_method_marshal_unregister_client,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * OrgGnomeSessionManager::handle-inhibit:
   * @object: A #OrgGnomeSessionManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_toplevel_xid: Argument passed by remote caller.
   * @arg_reason: Argument passed by remote caller.
   * @arg_flags: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-SessionManager.Inhibit">Inhibit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_session_manager_complete_inhibit() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-inhibit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeSessionManagerIface, handle_inhibit),
    g_signal_accumulator_true_handled,
    NULL,
      org_gnome_session_manager_method_marshal_inhibit,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT);

  /**
   * OrgGnomeSessionManager::handle-uninhibit:
   * @object: A #OrgGnomeSessionManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_inhibit_cookie: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-SessionManager.Uninhibit">Uninhibit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_session_manager_complete_uninhibit() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-uninhibit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeSessionManagerIface, handle_uninhibit),
    g_signal_accumulator_true_handled,
    NULL,
      org_gnome_session_manager_method_marshal_uninhibit,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * OrgGnomeSessionManager::handle-is-inhibited:
   * @object: A #OrgGnomeSessionManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_flags: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-SessionManager.IsInhibited">IsInhibited()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_session_manager_complete_is_inhibited() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-is-inhibited",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeSessionManagerIface, handle_is_inhibited),
    g_signal_accumulator_true_handled,
    NULL,
      org_gnome_session_manager_method_marshal_is_inhibited,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * OrgGnomeSessionManager::handle-get-clients:
   * @object: A #OrgGnomeSessionManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-SessionManager.GetClients">GetClients()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_session_manager_complete_get_clients() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-clients",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeSessionManagerIface, handle_get_clients),
    g_signal_accumulator_true_handled,
    NULL,
      org_gnome_session_manager_method_marshal_get_clients,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * OrgGnomeSessionManager::handle-get-inhibitors:
   * @object: A #OrgGnomeSessionManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-SessionManager.GetInhibitors">GetInhibitors()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_session_manager_complete_get_inhibitors() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-inhibitors",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeSessionManagerIface, handle_get_inhibitors),
    g_signal_accumulator_true_handled,
    NULL,
      org_gnome_session_manager_method_marshal_get_inhibitors,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * OrgGnomeSessionManager::handle-is-autostart-condition-handled:
   * @object: A #OrgGnomeSessionManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_condition: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-SessionManager.IsAutostartConditionHandled">IsAutostartConditionHandled()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_session_manager_complete_is_autostart_condition_handled() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-is-autostart-condition-handled",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeSessionManagerIface, handle_is_autostart_condition_handled),
    g_signal_accumulator_true_handled,
    NULL,
      org_gnome_session_manager_method_marshal_is_autostart_condition_handled,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * OrgGnomeSessionManager::handle-shutdown:
   * @object: A #OrgGnomeSessionManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-SessionManager.Shutdown">Shutdown()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_session_manager_complete_shutdown() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-shutdown",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeSessionManagerIface, handle_shutdown),
    g_signal_accumulator_true_handled,
    NULL,
      org_gnome_session_manager_method_marshal_shutdown,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * OrgGnomeSessionManager::handle-reboot:
   * @object: A #OrgGnomeSessionManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-SessionManager.Reboot">Reboot()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_session_manager_complete_reboot() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-reboot",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeSessionManagerIface, handle_reboot),
    g_signal_accumulator_true_handled,
    NULL,
      org_gnome_session_manager_method_marshal_reboot,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * OrgGnomeSessionManager::handle-can-shutdown:
   * @object: A #OrgGnomeSessionManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-SessionManager.CanShutdown">CanShutdown()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_session_manager_complete_can_shutdown() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-can-shutdown",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeSessionManagerIface, handle_can_shutdown),
    g_signal_accumulator_true_handled,
    NULL,
      org_gnome_session_manager_method_marshal_can_shutdown,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * OrgGnomeSessionManager::handle-logout:
   * @object: A #OrgGnomeSessionManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_mode: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-SessionManager.Logout">Logout()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_session_manager_complete_logout() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-logout",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeSessionManagerIface, handle_logout),
    g_signal_accumulator_true_handled,
    NULL,
      org_gnome_session_manager_method_marshal_logout,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * OrgGnomeSessionManager::handle-is-session-running:
   * @object: A #OrgGnomeSessionManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-SessionManager.IsSessionRunning">IsSessionRunning()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_session_manager_complete_is_session_running() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-is-session-running",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeSessionManagerIface, handle_is_session_running),
    g_signal_accumulator_true_handled,
    NULL,
      org_gnome_session_manager_method_marshal_is_session_running,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * OrgGnomeSessionManager::handle-request-shutdown:
   * @object: A #OrgGnomeSessionManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-SessionManager.RequestShutdown">RequestShutdown()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_session_manager_complete_request_shutdown() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-request-shutdown",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeSessionManagerIface, handle_request_shutdown),
    g_signal_accumulator_true_handled,
    NULL,
      org_gnome_session_manager_method_marshal_request_shutdown,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * OrgGnomeSessionManager::handle-request-reboot:
   * @object: A #OrgGnomeSessionManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-SessionManager.RequestReboot">RequestReboot()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_session_manager_complete_request_reboot() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-request-reboot",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeSessionManagerIface, handle_request_reboot),
    g_signal_accumulator_true_handled,
    NULL,
      org_gnome_session_manager_method_marshal_request_reboot,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * OrgGnomeSessionManager::client-added:
   * @object: A #OrgGnomeSessionManager.
   * @arg_id: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-SessionManager.ClientAdded">"ClientAdded"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  _ORG_GNOME_SESSION_MANAGER_SIGNALS[_ORG_GNOME_SESSION_MANAGER_CLIENT_ADDED] =
    g_signal_new ("client-added",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (OrgGnomeSessionManagerIface, client_added),
      NULL,
      NULL,
      org_gnome_session_manager_signal_marshal_client_added,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * OrgGnomeSessionManager::client-removed:
   * @object: A #OrgGnomeSessionManager.
   * @arg_id: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-SessionManager.ClientRemoved">"ClientRemoved"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  _ORG_GNOME_SESSION_MANAGER_SIGNALS[_ORG_GNOME_SESSION_MANAGER_CLIENT_REMOVED] =
    g_signal_new ("client-removed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (OrgGnomeSessionManagerIface, client_removed),
      NULL,
      NULL,
      org_gnome_session_manager_signal_marshal_client_removed,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * OrgGnomeSessionManager::inhibitor-added:
   * @object: A #OrgGnomeSessionManager.
   * @arg_id: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-SessionManager.InhibitorAdded">"InhibitorAdded"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  _ORG_GNOME_SESSION_MANAGER_SIGNALS[_ORG_GNOME_SESSION_MANAGER_INHIBITOR_ADDED] =
    g_signal_new ("inhibitor-added",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (OrgGnomeSessionManagerIface, inhibitor_added),
      NULL,
      NULL,
      org_gnome_session_manager_signal_marshal_inhibitor_added,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * OrgGnomeSessionManager::inhibitor-removed:
   * @object: A #OrgGnomeSessionManager.
   * @arg_id: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-SessionManager.InhibitorRemoved">"InhibitorRemoved"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  _ORG_GNOME_SESSION_MANAGER_SIGNALS[_ORG_GNOME_SESSION_MANAGER_INHIBITOR_REMOVED] =
    g_signal_new ("inhibitor-removed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (OrgGnomeSessionManagerIface, inhibitor_removed),
      NULL,
      NULL,
      org_gnome_session_manager_signal_marshal_inhibitor_removed,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * OrgGnomeSessionManager::session-running:
   * @object: A #OrgGnomeSessionManager.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-SessionManager.SessionRunning">"SessionRunning"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  _ORG_GNOME_SESSION_MANAGER_SIGNALS[_ORG_GNOME_SESSION_MANAGER_SESSION_RUNNING] =
    g_signal_new ("session-running",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (OrgGnomeSessionManagerIface, session_running),
      NULL,
      NULL,
      org_gnome_session_manager_signal_marshal_session_running,
      G_TYPE_NONE,
      0);

  /**
   * OrgGnomeSessionManager::session-over:
   * @object: A #OrgGnomeSessionManager.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-SessionManager.SessionOver">"SessionOver"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  _ORG_GNOME_SESSION_MANAGER_SIGNALS[_ORG_GNOME_SESSION_MANAGER_SESSION_OVER] =
    g_signal_new ("session-over",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (OrgGnomeSessionManagerIface, session_over),
      NULL,
      NULL,
      org_gnome_session_manager_signal_marshal_session_over,
      G_TYPE_NONE,
      0);

  /* GObject properties for D-Bus properties: */
  /**
   * OrgGnomeSessionManager:session-name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-SessionManager.SessionName">"SessionName"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("session-name", "SessionName", "SessionName", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * OrgGnomeSessionManager:inhibited-actions:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-SessionManager.InhibitedActions">"InhibitedActions"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("inhibited-actions", "InhibitedActions", "InhibitedActions", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * org_gnome_session_manager_get_session_name: (skip)
 * @object: A #OrgGnomeSessionManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-SessionManager.SessionName">"SessionName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use org_gnome_session_manager_dup_session_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
org_gnome_session_manager_get_session_name (OrgGnomeSessionManager *object)
{
  g_return_val_if_fail (IS_ORG_GNOME_SESSION_MANAGER (object), NULL);

  return ORG_GNOME_SESSION_MANAGER_GET_IFACE (object)->get_session_name (object);
}

/**
 * org_gnome_session_manager_dup_session_name: (skip)
 * @object: A #OrgGnomeSessionManager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-SessionManager.SessionName">"SessionName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
org_gnome_session_manager_dup_session_name (OrgGnomeSessionManager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "session-name", &value, NULL);
  return value;
}

/**
 * org_gnome_session_manager_set_session_name: (skip)
 * @object: A #OrgGnomeSessionManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-SessionManager.SessionName">"SessionName"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
org_gnome_session_manager_set_session_name (OrgGnomeSessionManager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "session-name", value, NULL);
}

/**
 * org_gnome_session_manager_get_inhibited_actions: (skip)
 * @object: A #OrgGnomeSessionManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-SessionManager.InhibitedActions">"InhibitedActions"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
org_gnome_session_manager_get_inhibited_actions (OrgGnomeSessionManager *object)
{
  g_return_val_if_fail (IS_ORG_GNOME_SESSION_MANAGER (object), 0);

  return ORG_GNOME_SESSION_MANAGER_GET_IFACE (object)->get_inhibited_actions (object);
}

/**
 * org_gnome_session_manager_set_inhibited_actions: (skip)
 * @object: A #OrgGnomeSessionManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-SessionManager.InhibitedActions">"InhibitedActions"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
org_gnome_session_manager_set_inhibited_actions (OrgGnomeSessionManager *object, guint value)
{
  g_object_set (G_OBJECT (object), "inhibited-actions", value, NULL);
}

/**
 * org_gnome_session_manager_emit_client_added:
 * @object: A #OrgGnomeSessionManager.
 * @arg_id: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-SessionManager.ClientAdded">"ClientAdded"</link> D-Bus signal.
 */
void
org_gnome_session_manager_emit_client_added (
    OrgGnomeSessionManager *object,
    const gchar *arg_id)
{
  g_signal_emit (object, _ORG_GNOME_SESSION_MANAGER_SIGNALS[_ORG_GNOME_SESSION_MANAGER_CLIENT_ADDED], 0, arg_id);
}

/**
 * org_gnome_session_manager_emit_client_removed:
 * @object: A #OrgGnomeSessionManager.
 * @arg_id: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-SessionManager.ClientRemoved">"ClientRemoved"</link> D-Bus signal.
 */
void
org_gnome_session_manager_emit_client_removed (
    OrgGnomeSessionManager *object,
    const gchar *arg_id)
{
  g_signal_emit (object, _ORG_GNOME_SESSION_MANAGER_SIGNALS[_ORG_GNOME_SESSION_MANAGER_CLIENT_REMOVED], 0, arg_id);
}

/**
 * org_gnome_session_manager_emit_inhibitor_added:
 * @object: A #OrgGnomeSessionManager.
 * @arg_id: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-SessionManager.InhibitorAdded">"InhibitorAdded"</link> D-Bus signal.
 */
void
org_gnome_session_manager_emit_inhibitor_added (
    OrgGnomeSessionManager *object,
    const gchar *arg_id)
{
  g_signal_emit (object, _ORG_GNOME_SESSION_MANAGER_SIGNALS[_ORG_GNOME_SESSION_MANAGER_INHIBITOR_ADDED], 0, arg_id);
}

/**
 * org_gnome_session_manager_emit_inhibitor_removed:
 * @object: A #OrgGnomeSessionManager.
 * @arg_id: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-SessionManager.InhibitorRemoved">"InhibitorRemoved"</link> D-Bus signal.
 */
void
org_gnome_session_manager_emit_inhibitor_removed (
    OrgGnomeSessionManager *object,
    const gchar *arg_id)
{
  g_signal_emit (object, _ORG_GNOME_SESSION_MANAGER_SIGNALS[_ORG_GNOME_SESSION_MANAGER_INHIBITOR_REMOVED], 0, arg_id);
}

/**
 * org_gnome_session_manager_emit_session_running:
 * @object: A #OrgGnomeSessionManager.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-SessionManager.SessionRunning">"SessionRunning"</link> D-Bus signal.
 */
void
org_gnome_session_manager_emit_session_running (
    OrgGnomeSessionManager *object)
{
  g_signal_emit (object, _ORG_GNOME_SESSION_MANAGER_SIGNALS[_ORG_GNOME_SESSION_MANAGER_SESSION_RUNNING], 0);
}

/**
 * org_gnome_session_manager_emit_session_over:
 * @object: A #OrgGnomeSessionManager.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-SessionManager.SessionOver">"SessionOver"</link> D-Bus signal.
 */
void
org_gnome_session_manager_emit_session_over (
    OrgGnomeSessionManager *object)
{
  g_signal_emit (object, _ORG_GNOME_SESSION_MANAGER_SIGNALS[_ORG_GNOME_SESSION_MANAGER_SESSION_OVER], 0);
}

/**
 * org_gnome_session_manager_call_setenv:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @arg_variable: Argument to pass with the method invocation.
 * @arg_value: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.Setenv">Setenv()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_session_manager_call_setenv_finish() to get the result of the operation.
 *
 * See org_gnome_session_manager_call_setenv_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_session_manager_call_setenv (
    OrgGnomeSessionManager *proxy,
    const gchar *arg_variable,
    const gchar *arg_value,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Setenv",
    g_variant_new ("(ss)",
                   arg_variable,
                   arg_value),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_session_manager_call_setenv_finish:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_session_manager_call_setenv().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_session_manager_call_setenv().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_setenv_finish (
    OrgGnomeSessionManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_call_setenv_sync:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @arg_variable: Argument to pass with the method invocation.
 * @arg_value: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.Setenv">Setenv()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_session_manager_call_setenv() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_setenv_sync (
    OrgGnomeSessionManager *proxy,
    const gchar *arg_variable,
    const gchar *arg_value,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Setenv",
    g_variant_new ("(ss)",
                   arg_variable,
                   arg_value),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_call_initialization_error:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @arg_message: Argument to pass with the method invocation.
 * @arg_fatal: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.InitializationError">InitializationError()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_session_manager_call_initialization_error_finish() to get the result of the operation.
 *
 * See org_gnome_session_manager_call_initialization_error_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_session_manager_call_initialization_error (
    OrgGnomeSessionManager *proxy,
    const gchar *arg_message,
    gboolean arg_fatal,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "InitializationError",
    g_variant_new ("(sb)",
                   arg_message,
                   arg_fatal),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_session_manager_call_initialization_error_finish:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_session_manager_call_initialization_error().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_session_manager_call_initialization_error().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_initialization_error_finish (
    OrgGnomeSessionManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_call_initialization_error_sync:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @arg_message: Argument to pass with the method invocation.
 * @arg_fatal: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.InitializationError">InitializationError()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_session_manager_call_initialization_error() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_initialization_error_sync (
    OrgGnomeSessionManager *proxy,
    const gchar *arg_message,
    gboolean arg_fatal,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "InitializationError",
    g_variant_new ("(sb)",
                   arg_message,
                   arg_fatal),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_call_register_client:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_client_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.RegisterClient">RegisterClient()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_session_manager_call_register_client_finish() to get the result of the operation.
 *
 * See org_gnome_session_manager_call_register_client_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_session_manager_call_register_client (
    OrgGnomeSessionManager *proxy,
    const gchar *arg_app_id,
    const gchar *arg_client_startup_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RegisterClient",
    g_variant_new ("(ss)",
                   arg_app_id,
                   arg_client_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_session_manager_call_register_client_finish:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @out_client_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_session_manager_call_register_client().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_session_manager_call_register_client().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_register_client_finish (
    OrgGnomeSessionManager *proxy,
    gchar **out_client_id,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_client_id);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_call_register_client_sync:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_client_startup_id: Argument to pass with the method invocation.
 * @out_client_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.RegisterClient">RegisterClient()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_session_manager_call_register_client() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_register_client_sync (
    OrgGnomeSessionManager *proxy,
    const gchar *arg_app_id,
    const gchar *arg_client_startup_id,
    gchar **out_client_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RegisterClient",
    g_variant_new ("(ss)",
                   arg_app_id,
                   arg_client_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_client_id);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_call_unregister_client:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @arg_client_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.UnregisterClient">UnregisterClient()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_session_manager_call_unregister_client_finish() to get the result of the operation.
 *
 * See org_gnome_session_manager_call_unregister_client_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_session_manager_call_unregister_client (
    OrgGnomeSessionManager *proxy,
    const gchar *arg_client_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UnregisterClient",
    g_variant_new ("(o)",
                   arg_client_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_session_manager_call_unregister_client_finish:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_session_manager_call_unregister_client().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_session_manager_call_unregister_client().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_unregister_client_finish (
    OrgGnomeSessionManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_call_unregister_client_sync:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @arg_client_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.UnregisterClient">UnregisterClient()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_session_manager_call_unregister_client() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_unregister_client_sync (
    OrgGnomeSessionManager *proxy,
    const gchar *arg_client_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UnregisterClient",
    g_variant_new ("(o)",
                   arg_client_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_call_inhibit:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_toplevel_xid: Argument to pass with the method invocation.
 * @arg_reason: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.Inhibit">Inhibit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_session_manager_call_inhibit_finish() to get the result of the operation.
 *
 * See org_gnome_session_manager_call_inhibit_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_session_manager_call_inhibit (
    OrgGnomeSessionManager *proxy,
    const gchar *arg_app_id,
    guint arg_toplevel_xid,
    const gchar *arg_reason,
    guint arg_flags,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Inhibit",
    g_variant_new ("(susu)",
                   arg_app_id,
                   arg_toplevel_xid,
                   arg_reason,
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_session_manager_call_inhibit_finish:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @out_inhibit_cookie: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_session_manager_call_inhibit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_session_manager_call_inhibit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_inhibit_finish (
    OrgGnomeSessionManager *proxy,
    guint *out_inhibit_cookie,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_inhibit_cookie);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_call_inhibit_sync:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_toplevel_xid: Argument to pass with the method invocation.
 * @arg_reason: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @out_inhibit_cookie: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.Inhibit">Inhibit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_session_manager_call_inhibit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_inhibit_sync (
    OrgGnomeSessionManager *proxy,
    const gchar *arg_app_id,
    guint arg_toplevel_xid,
    const gchar *arg_reason,
    guint arg_flags,
    guint *out_inhibit_cookie,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Inhibit",
    g_variant_new ("(susu)",
                   arg_app_id,
                   arg_toplevel_xid,
                   arg_reason,
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_inhibit_cookie);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_call_uninhibit:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @arg_inhibit_cookie: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.Uninhibit">Uninhibit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_session_manager_call_uninhibit_finish() to get the result of the operation.
 *
 * See org_gnome_session_manager_call_uninhibit_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_session_manager_call_uninhibit (
    OrgGnomeSessionManager *proxy,
    guint arg_inhibit_cookie,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Uninhibit",
    g_variant_new ("(u)",
                   arg_inhibit_cookie),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_session_manager_call_uninhibit_finish:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_session_manager_call_uninhibit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_session_manager_call_uninhibit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_uninhibit_finish (
    OrgGnomeSessionManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_call_uninhibit_sync:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @arg_inhibit_cookie: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.Uninhibit">Uninhibit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_session_manager_call_uninhibit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_uninhibit_sync (
    OrgGnomeSessionManager *proxy,
    guint arg_inhibit_cookie,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Uninhibit",
    g_variant_new ("(u)",
                   arg_inhibit_cookie),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_call_is_inhibited:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.IsInhibited">IsInhibited()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_session_manager_call_is_inhibited_finish() to get the result of the operation.
 *
 * See org_gnome_session_manager_call_is_inhibited_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_session_manager_call_is_inhibited (
    OrgGnomeSessionManager *proxy,
    guint arg_flags,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "IsInhibited",
    g_variant_new ("(u)",
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_session_manager_call_is_inhibited_finish:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @out_is_inhibited: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_session_manager_call_is_inhibited().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_session_manager_call_is_inhibited().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_is_inhibited_finish (
    OrgGnomeSessionManager *proxy,
    gboolean *out_is_inhibited,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_is_inhibited);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_call_is_inhibited_sync:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @out_is_inhibited: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.IsInhibited">IsInhibited()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_session_manager_call_is_inhibited() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_is_inhibited_sync (
    OrgGnomeSessionManager *proxy,
    guint arg_flags,
    gboolean *out_is_inhibited,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "IsInhibited",
    g_variant_new ("(u)",
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_is_inhibited);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_call_get_clients:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.GetClients">GetClients()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_session_manager_call_get_clients_finish() to get the result of the operation.
 *
 * See org_gnome_session_manager_call_get_clients_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_session_manager_call_get_clients (
    OrgGnomeSessionManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetClients",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_session_manager_call_get_clients_finish:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @out_clients: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_session_manager_call_get_clients().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_session_manager_call_get_clients().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_get_clients_finish (
    OrgGnomeSessionManager *proxy,
    gchar ***out_clients,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_clients);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_call_get_clients_sync:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @out_clients: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.GetClients">GetClients()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_session_manager_call_get_clients() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_get_clients_sync (
    OrgGnomeSessionManager *proxy,
    gchar ***out_clients,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetClients",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_clients);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_call_get_inhibitors:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.GetInhibitors">GetInhibitors()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_session_manager_call_get_inhibitors_finish() to get the result of the operation.
 *
 * See org_gnome_session_manager_call_get_inhibitors_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_session_manager_call_get_inhibitors (
    OrgGnomeSessionManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetInhibitors",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_session_manager_call_get_inhibitors_finish:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @out_inhibitors: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_session_manager_call_get_inhibitors().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_session_manager_call_get_inhibitors().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_get_inhibitors_finish (
    OrgGnomeSessionManager *proxy,
    gchar ***out_inhibitors,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_inhibitors);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_call_get_inhibitors_sync:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @out_inhibitors: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.GetInhibitors">GetInhibitors()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_session_manager_call_get_inhibitors() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_get_inhibitors_sync (
    OrgGnomeSessionManager *proxy,
    gchar ***out_inhibitors,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetInhibitors",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_inhibitors);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_call_is_autostart_condition_handled:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @arg_condition: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.IsAutostartConditionHandled">IsAutostartConditionHandled()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_session_manager_call_is_autostart_condition_handled_finish() to get the result of the operation.
 *
 * See org_gnome_session_manager_call_is_autostart_condition_handled_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_session_manager_call_is_autostart_condition_handled (
    OrgGnomeSessionManager *proxy,
    const gchar *arg_condition,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "IsAutostartConditionHandled",
    g_variant_new ("(s)",
                   arg_condition),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_session_manager_call_is_autostart_condition_handled_finish:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @out_handled: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_session_manager_call_is_autostart_condition_handled().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_session_manager_call_is_autostart_condition_handled().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_is_autostart_condition_handled_finish (
    OrgGnomeSessionManager *proxy,
    gboolean *out_handled,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_handled);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_call_is_autostart_condition_handled_sync:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @arg_condition: Argument to pass with the method invocation.
 * @out_handled: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.IsAutostartConditionHandled">IsAutostartConditionHandled()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_session_manager_call_is_autostart_condition_handled() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_is_autostart_condition_handled_sync (
    OrgGnomeSessionManager *proxy,
    const gchar *arg_condition,
    gboolean *out_handled,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "IsAutostartConditionHandled",
    g_variant_new ("(s)",
                   arg_condition),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_handled);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_call_shutdown:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.Shutdown">Shutdown()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_session_manager_call_shutdown_finish() to get the result of the operation.
 *
 * See org_gnome_session_manager_call_shutdown_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_session_manager_call_shutdown (
    OrgGnomeSessionManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Shutdown",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_session_manager_call_shutdown_finish:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_session_manager_call_shutdown().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_session_manager_call_shutdown().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_shutdown_finish (
    OrgGnomeSessionManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_call_shutdown_sync:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.Shutdown">Shutdown()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_session_manager_call_shutdown() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_shutdown_sync (
    OrgGnomeSessionManager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Shutdown",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_call_reboot:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.Reboot">Reboot()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_session_manager_call_reboot_finish() to get the result of the operation.
 *
 * See org_gnome_session_manager_call_reboot_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_session_manager_call_reboot (
    OrgGnomeSessionManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Reboot",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_session_manager_call_reboot_finish:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_session_manager_call_reboot().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_session_manager_call_reboot().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_reboot_finish (
    OrgGnomeSessionManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_call_reboot_sync:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.Reboot">Reboot()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_session_manager_call_reboot() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_reboot_sync (
    OrgGnomeSessionManager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Reboot",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_call_can_shutdown:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.CanShutdown">CanShutdown()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_session_manager_call_can_shutdown_finish() to get the result of the operation.
 *
 * See org_gnome_session_manager_call_can_shutdown_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_session_manager_call_can_shutdown (
    OrgGnomeSessionManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CanShutdown",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_session_manager_call_can_shutdown_finish:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @out_is_available: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_session_manager_call_can_shutdown().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_session_manager_call_can_shutdown().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_can_shutdown_finish (
    OrgGnomeSessionManager *proxy,
    gboolean *out_is_available,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_is_available);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_call_can_shutdown_sync:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @out_is_available: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.CanShutdown">CanShutdown()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_session_manager_call_can_shutdown() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_can_shutdown_sync (
    OrgGnomeSessionManager *proxy,
    gboolean *out_is_available,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CanShutdown",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_is_available);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_call_logout:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @arg_mode: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.Logout">Logout()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_session_manager_call_logout_finish() to get the result of the operation.
 *
 * See org_gnome_session_manager_call_logout_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_session_manager_call_logout (
    OrgGnomeSessionManager *proxy,
    guint arg_mode,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Logout",
    g_variant_new ("(u)",
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_session_manager_call_logout_finish:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_session_manager_call_logout().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_session_manager_call_logout().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_logout_finish (
    OrgGnomeSessionManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_call_logout_sync:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @arg_mode: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.Logout">Logout()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_session_manager_call_logout() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_logout_sync (
    OrgGnomeSessionManager *proxy,
    guint arg_mode,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Logout",
    g_variant_new ("(u)",
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_call_is_session_running:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.IsSessionRunning">IsSessionRunning()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_session_manager_call_is_session_running_finish() to get the result of the operation.
 *
 * See org_gnome_session_manager_call_is_session_running_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_session_manager_call_is_session_running (
    OrgGnomeSessionManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "IsSessionRunning",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_session_manager_call_is_session_running_finish:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @out_running: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_session_manager_call_is_session_running().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_session_manager_call_is_session_running().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_is_session_running_finish (
    OrgGnomeSessionManager *proxy,
    gboolean *out_running,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_running);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_call_is_session_running_sync:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @out_running: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.IsSessionRunning">IsSessionRunning()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_session_manager_call_is_session_running() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_is_session_running_sync (
    OrgGnomeSessionManager *proxy,
    gboolean *out_running,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "IsSessionRunning",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_running);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_call_request_shutdown:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.RequestShutdown">RequestShutdown()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_session_manager_call_request_shutdown_finish() to get the result of the operation.
 *
 * See org_gnome_session_manager_call_request_shutdown_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_session_manager_call_request_shutdown (
    OrgGnomeSessionManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RequestShutdown",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_session_manager_call_request_shutdown_finish:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_session_manager_call_request_shutdown().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_session_manager_call_request_shutdown().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_request_shutdown_finish (
    OrgGnomeSessionManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_call_request_shutdown_sync:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.RequestShutdown">RequestShutdown()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_session_manager_call_request_shutdown() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_request_shutdown_sync (
    OrgGnomeSessionManager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RequestShutdown",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_call_request_reboot:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.RequestReboot">RequestReboot()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_session_manager_call_request_reboot_finish() to get the result of the operation.
 *
 * See org_gnome_session_manager_call_request_reboot_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_session_manager_call_request_reboot (
    OrgGnomeSessionManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RequestReboot",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_session_manager_call_request_reboot_finish:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_session_manager_call_request_reboot().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_session_manager_call_request_reboot().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_request_reboot_finish (
    OrgGnomeSessionManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_call_request_reboot_sync:
 * @proxy: A #OrgGnomeSessionManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.RequestReboot">RequestReboot()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_session_manager_call_request_reboot() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_session_manager_call_request_reboot_sync (
    OrgGnomeSessionManager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RequestReboot",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_session_manager_complete_setenv:
 * @object: A #OrgGnomeSessionManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-SessionManager.Setenv">Setenv()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_session_manager_complete_setenv (
    OrgGnomeSessionManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_gnome_session_manager_complete_initialization_error:
 * @object: A #OrgGnomeSessionManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-SessionManager.InitializationError">InitializationError()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_session_manager_complete_initialization_error (
    OrgGnomeSessionManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_gnome_session_manager_complete_register_client:
 * @object: A #OrgGnomeSessionManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @client_id: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-SessionManager.RegisterClient">RegisterClient()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_session_manager_complete_register_client (
    OrgGnomeSessionManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *client_id)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   client_id));
}

/**
 * org_gnome_session_manager_complete_unregister_client:
 * @object: A #OrgGnomeSessionManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-SessionManager.UnregisterClient">UnregisterClient()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_session_manager_complete_unregister_client (
    OrgGnomeSessionManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_gnome_session_manager_complete_inhibit:
 * @object: A #OrgGnomeSessionManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @inhibit_cookie: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-SessionManager.Inhibit">Inhibit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_session_manager_complete_inhibit (
    OrgGnomeSessionManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint inhibit_cookie)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   inhibit_cookie));
}

/**
 * org_gnome_session_manager_complete_uninhibit:
 * @object: A #OrgGnomeSessionManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-SessionManager.Uninhibit">Uninhibit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_session_manager_complete_uninhibit (
    OrgGnomeSessionManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_gnome_session_manager_complete_is_inhibited:
 * @object: A #OrgGnomeSessionManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @is_inhibited: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-SessionManager.IsInhibited">IsInhibited()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_session_manager_complete_is_inhibited (
    OrgGnomeSessionManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean is_inhibited)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   is_inhibited));
}

/**
 * org_gnome_session_manager_complete_get_clients:
 * @object: A #OrgGnomeSessionManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @clients: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-SessionManager.GetClients">GetClients()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_session_manager_complete_get_clients (
    OrgGnomeSessionManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *clients)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^ao)",
                   clients));
}

/**
 * org_gnome_session_manager_complete_get_inhibitors:
 * @object: A #OrgGnomeSessionManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @inhibitors: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-SessionManager.GetInhibitors">GetInhibitors()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_session_manager_complete_get_inhibitors (
    OrgGnomeSessionManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *inhibitors)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^ao)",
                   inhibitors));
}

/**
 * org_gnome_session_manager_complete_is_autostart_condition_handled:
 * @object: A #OrgGnomeSessionManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @handled: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-SessionManager.IsAutostartConditionHandled">IsAutostartConditionHandled()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_session_manager_complete_is_autostart_condition_handled (
    OrgGnomeSessionManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean handled)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   handled));
}

/**
 * org_gnome_session_manager_complete_shutdown:
 * @object: A #OrgGnomeSessionManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-SessionManager.Shutdown">Shutdown()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_session_manager_complete_shutdown (
    OrgGnomeSessionManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_gnome_session_manager_complete_reboot:
 * @object: A #OrgGnomeSessionManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-SessionManager.Reboot">Reboot()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_session_manager_complete_reboot (
    OrgGnomeSessionManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_gnome_session_manager_complete_can_shutdown:
 * @object: A #OrgGnomeSessionManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @is_available: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-SessionManager.CanShutdown">CanShutdown()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_session_manager_complete_can_shutdown (
    OrgGnomeSessionManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean is_available)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   is_available));
}

/**
 * org_gnome_session_manager_complete_logout:
 * @object: A #OrgGnomeSessionManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-SessionManager.Logout">Logout()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_session_manager_complete_logout (
    OrgGnomeSessionManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_gnome_session_manager_complete_is_session_running:
 * @object: A #OrgGnomeSessionManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @running: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-SessionManager.IsSessionRunning">IsSessionRunning()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_session_manager_complete_is_session_running (
    OrgGnomeSessionManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean running)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   running));
}

/**
 * org_gnome_session_manager_complete_request_shutdown:
 * @object: A #OrgGnomeSessionManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-SessionManager.RequestShutdown">RequestShutdown()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_session_manager_complete_request_shutdown (
    OrgGnomeSessionManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_gnome_session_manager_complete_request_reboot:
 * @object: A #OrgGnomeSessionManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-SessionManager.RequestReboot">RequestReboot()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_session_manager_complete_request_reboot (
    OrgGnomeSessionManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * OrgGnomeSessionManagerProxy:
 *
 * The #OrgGnomeSessionManagerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgGnomeSessionManagerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgGnomeSessionManagerProxy.
 */

struct _OrgGnomeSessionManagerProxyPrivate
{
  GData *qdata;
};

static void org_gnome_session_manager_proxy_iface_init (OrgGnomeSessionManagerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgGnomeSessionManagerProxy, org_gnome_session_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (OrgGnomeSessionManagerProxy)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_SESSION_MANAGER, org_gnome_session_manager_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgGnomeSessionManagerProxy, org_gnome_session_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_SESSION_MANAGER, org_gnome_session_manager_proxy_iface_init))

#endif
static void
org_gnome_session_manager_proxy_finalize (GObject *object)
{
  OrgGnomeSessionManagerProxy *proxy = ORG_GNOME_SESSION_MANAGER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (org_gnome_session_manager_proxy_parent_class)->finalize (object);
}

static void
org_gnome_session_manager_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _org_gnome_session_manager_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
org_gnome_session_manager_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.SessionManager: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
org_gnome_session_manager_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _org_gnome_session_manager_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.SessionManager", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) org_gnome_session_manager_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
org_gnome_session_manager_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_org_gnome_session_manager_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TYPE_ORG_GNOME_SESSION_MANAGER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_GNOME_SESSION_MANAGER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
org_gnome_session_manager_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  OrgGnomeSessionManagerProxy *proxy = ORG_GNOME_SESSION_MANAGER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_session_manager_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_session_manager_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
org_gnome_session_manager_proxy_get_session_name (OrgGnomeSessionManager *object)
{
  OrgGnomeSessionManagerProxy *proxy = ORG_GNOME_SESSION_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SessionName");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
org_gnome_session_manager_proxy_get_inhibited_actions (OrgGnomeSessionManager *object)
{
  OrgGnomeSessionManagerProxy *proxy = ORG_GNOME_SESSION_MANAGER_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "InhibitedActions");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
org_gnome_session_manager_proxy_init (OrgGnomeSessionManagerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = org_gnome_session_manager_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TYPE_ORG_GNOME_SESSION_MANAGER_PROXY, OrgGnomeSessionManagerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), org_gnome_session_manager_interface_info ());
}

static void
org_gnome_session_manager_proxy_class_init (OrgGnomeSessionManagerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = org_gnome_session_manager_proxy_finalize;
  gobject_class->get_property = org_gnome_session_manager_proxy_get_property;
  gobject_class->set_property = org_gnome_session_manager_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = org_gnome_session_manager_proxy_g_signal;
  proxy_class->g_properties_changed = org_gnome_session_manager_proxy_g_properties_changed;

  org_gnome_session_manager_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgGnomeSessionManagerProxyPrivate));
#endif
}

static void
org_gnome_session_manager_proxy_iface_init (OrgGnomeSessionManagerIface *iface)
{
  iface->get_session_name = org_gnome_session_manager_proxy_get_session_name;
  iface->get_inhibited_actions = org_gnome_session_manager_proxy_get_inhibited_actions;
}

/**
 * org_gnome_session_manager_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-SessionManager.top_of_page">org.gnome.SessionManager</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_session_manager_proxy_new_finish() to get the result of the operation.
 *
 * See org_gnome_session_manager_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
org_gnome_session_manager_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_GNOME_SESSION_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.SessionManager", NULL);
}

/**
 * org_gnome_session_manager_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_session_manager_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_gnome_session_manager_proxy_new().
 *
 * Returns: (transfer full) (type OrgGnomeSessionManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeSessionManager *
org_gnome_session_manager_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_GNOME_SESSION_MANAGER (ret);
  else
    return NULL;
}

/**
 * org_gnome_session_manager_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-SessionManager.top_of_page">org.gnome.SessionManager</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_gnome_session_manager_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgGnomeSessionManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeSessionManager *
org_gnome_session_manager_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_GNOME_SESSION_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.SessionManager", NULL);
  if (ret != NULL)
    return ORG_GNOME_SESSION_MANAGER (ret);
  else
    return NULL;
}


/**
 * org_gnome_session_manager_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like org_gnome_session_manager_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_session_manager_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See org_gnome_session_manager_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
org_gnome_session_manager_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_GNOME_SESSION_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.SessionManager", NULL);
}

/**
 * org_gnome_session_manager_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_session_manager_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_gnome_session_manager_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type OrgGnomeSessionManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeSessionManager *
org_gnome_session_manager_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_GNOME_SESSION_MANAGER (ret);
  else
    return NULL;
}

/**
 * org_gnome_session_manager_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like org_gnome_session_manager_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_gnome_session_manager_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgGnomeSessionManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeSessionManager *
org_gnome_session_manager_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_GNOME_SESSION_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.SessionManager", NULL);
  if (ret != NULL)
    return ORG_GNOME_SESSION_MANAGER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * OrgGnomeSessionManagerSkeleton:
 *
 * The #OrgGnomeSessionManagerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgGnomeSessionManagerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgGnomeSessionManagerSkeleton.
 */

struct _OrgGnomeSessionManagerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_org_gnome_session_manager_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  OrgGnomeSessionManagerSkeleton *skeleton = ORG_GNOME_SESSION_MANAGER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TYPE_ORG_GNOME_SESSION_MANAGER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_GNOME_SESSION_MANAGER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_org_gnome_session_manager_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  OrgGnomeSessionManagerSkeleton *skeleton = ORG_GNOME_SESSION_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_session_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_org_gnome_session_manager_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  OrgGnomeSessionManagerSkeleton *skeleton = ORG_GNOME_SESSION_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_session_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _org_gnome_session_manager_skeleton_vtable =
{
  _org_gnome_session_manager_skeleton_handle_method_call,
  _org_gnome_session_manager_skeleton_handle_get_property,
  _org_gnome_session_manager_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
org_gnome_session_manager_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return org_gnome_session_manager_interface_info ();
}

static GDBusInterfaceVTable *
org_gnome_session_manager_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_org_gnome_session_manager_skeleton_vtable;
}

static GVariant *
org_gnome_session_manager_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  OrgGnomeSessionManagerSkeleton *skeleton = ORG_GNOME_SESSION_MANAGER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_org_gnome_session_manager_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _org_gnome_session_manager_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _org_gnome_session_manager_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _org_gnome_session_manager_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.SessionManager", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _org_gnome_session_manager_emit_changed (gpointer user_data);

static void
org_gnome_session_manager_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  OrgGnomeSessionManagerSkeleton *skeleton = ORG_GNOME_SESSION_MANAGER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _org_gnome_session_manager_emit_changed (skeleton);
}

static void
_org_gnome_session_manager_on_signal_client_added (
    OrgGnomeSessionManager *object,
    const gchar *arg_id)
{
  OrgGnomeSessionManagerSkeleton *skeleton = ORG_GNOME_SESSION_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_id));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.SessionManager", "ClientAdded",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_org_gnome_session_manager_on_signal_client_removed (
    OrgGnomeSessionManager *object,
    const gchar *arg_id)
{
  OrgGnomeSessionManagerSkeleton *skeleton = ORG_GNOME_SESSION_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_id));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.SessionManager", "ClientRemoved",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_org_gnome_session_manager_on_signal_inhibitor_added (
    OrgGnomeSessionManager *object,
    const gchar *arg_id)
{
  OrgGnomeSessionManagerSkeleton *skeleton = ORG_GNOME_SESSION_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_id));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.SessionManager", "InhibitorAdded",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_org_gnome_session_manager_on_signal_inhibitor_removed (
    OrgGnomeSessionManager *object,
    const gchar *arg_id)
{
  OrgGnomeSessionManagerSkeleton *skeleton = ORG_GNOME_SESSION_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_id));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.SessionManager", "InhibitorRemoved",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_org_gnome_session_manager_on_signal_session_running (
    OrgGnomeSessionManager *object)
{
  OrgGnomeSessionManagerSkeleton *skeleton = ORG_GNOME_SESSION_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.SessionManager", "SessionRunning",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_org_gnome_session_manager_on_signal_session_over (
    OrgGnomeSessionManager *object)
{
  OrgGnomeSessionManagerSkeleton *skeleton = ORG_GNOME_SESSION_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.SessionManager", "SessionOver",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void org_gnome_session_manager_skeleton_iface_init (OrgGnomeSessionManagerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgGnomeSessionManagerSkeleton, org_gnome_session_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (OrgGnomeSessionManagerSkeleton)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_SESSION_MANAGER, org_gnome_session_manager_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgGnomeSessionManagerSkeleton, org_gnome_session_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_SESSION_MANAGER, org_gnome_session_manager_skeleton_iface_init))

#endif
static void
org_gnome_session_manager_skeleton_finalize (GObject *object)
{
  OrgGnomeSessionManagerSkeleton *skeleton = ORG_GNOME_SESSION_MANAGER_SKELETON (object);
  guint n;
  for (n = 0; n < 2; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (org_gnome_session_manager_skeleton_parent_class)->finalize (object);
}

static void
org_gnome_session_manager_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  OrgGnomeSessionManagerSkeleton *skeleton = ORG_GNOME_SESSION_MANAGER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_org_gnome_session_manager_emit_changed (gpointer user_data)
{
  OrgGnomeSessionManagerSkeleton *skeleton = ORG_GNOME_SESSION_MANAGER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.SessionManager",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_org_gnome_session_manager_schedule_emit_changed (OrgGnomeSessionManagerSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
org_gnome_session_manager_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  OrgGnomeSessionManagerSkeleton *skeleton = ORG_GNOME_SESSION_MANAGER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _org_gnome_session_manager_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _org_gnome_session_manager_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
org_gnome_session_manager_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  OrgGnomeSessionManagerSkeleton *skeleton = ORG_GNOME_SESSION_MANAGER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _org_gnome_session_manager_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _org_gnome_session_manager_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
org_gnome_session_manager_skeleton_init (OrgGnomeSessionManagerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = org_gnome_session_manager_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TYPE_ORG_GNOME_SESSION_MANAGER_SKELETON, OrgGnomeSessionManagerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 2);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_UINT);
}

static const gchar *
org_gnome_session_manager_skeleton_get_session_name (OrgGnomeSessionManager *object)
{
  OrgGnomeSessionManagerSkeleton *skeleton = ORG_GNOME_SESSION_MANAGER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
org_gnome_session_manager_skeleton_get_inhibited_actions (OrgGnomeSessionManager *object)
{
  OrgGnomeSessionManagerSkeleton *skeleton = ORG_GNOME_SESSION_MANAGER_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
org_gnome_session_manager_skeleton_class_init (OrgGnomeSessionManagerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = org_gnome_session_manager_skeleton_finalize;
  gobject_class->get_property = org_gnome_session_manager_skeleton_get_property;
  gobject_class->set_property = org_gnome_session_manager_skeleton_set_property;
  gobject_class->notify       = org_gnome_session_manager_skeleton_notify;


  org_gnome_session_manager_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = org_gnome_session_manager_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = org_gnome_session_manager_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = org_gnome_session_manager_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = org_gnome_session_manager_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgGnomeSessionManagerSkeletonPrivate));
#endif
}

static void
org_gnome_session_manager_skeleton_iface_init (OrgGnomeSessionManagerIface *iface)
{
  iface->client_added = _org_gnome_session_manager_on_signal_client_added;
  iface->client_removed = _org_gnome_session_manager_on_signal_client_removed;
  iface->inhibitor_added = _org_gnome_session_manager_on_signal_inhibitor_added;
  iface->inhibitor_removed = _org_gnome_session_manager_on_signal_inhibitor_removed;
  iface->session_running = _org_gnome_session_manager_on_signal_session_running;
  iface->session_over = _org_gnome_session_manager_on_signal_session_over;
  iface->get_session_name = org_gnome_session_manager_skeleton_get_session_name;
  iface->get_inhibited_actions = org_gnome_session_manager_skeleton_get_inhibited_actions;
}

/**
 * org_gnome_session_manager_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-SessionManager.top_of_page">org.gnome.SessionManager</link>.
 *
 * Returns: (transfer full) (type OrgGnomeSessionManagerSkeleton): The skeleton object.
 */
OrgGnomeSessionManager *
org_gnome_session_manager_skeleton_new (void)
{
  return ORG_GNOME_SESSION_MANAGER (g_object_new (TYPE_ORG_GNOME_SESSION_MANAGER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Shell.Screenshot
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:OrgGnomeShellScreenshot
 * @title: OrgGnomeShellScreenshot
 * @short_description: Generated C code for the org.gnome.Shell.Screenshot D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Shell-Screenshot.top_of_page">org.gnome.Shell.Screenshot</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.Shell.Screenshot ---- */

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_IN_ARG_include_cursor =
{
  {
    -1,
    (gchar *) "include_cursor",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_IN_ARG_flash =
{
  {
    -1,
    (gchar *) "flash",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_IN_ARG_filename =
{
  {
    -1,
    (gchar *) "filename",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_shell_screenshot_method_info_screenshot_IN_ARG_pointers[] =
{
  &_org_gnome_shell_screenshot_method_info_screenshot_IN_ARG_include_cursor.parent_struct,
  &_org_gnome_shell_screenshot_method_info_screenshot_IN_ARG_flash.parent_struct,
  &_org_gnome_shell_screenshot_method_info_screenshot_IN_ARG_filename.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_OUT_ARG_success =
{
  {
    -1,
    (gchar *) "success",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_OUT_ARG_filename_used =
{
  {
    -1,
    (gchar *) "filename_used",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_shell_screenshot_method_info_screenshot_OUT_ARG_pointers[] =
{
  &_org_gnome_shell_screenshot_method_info_screenshot_OUT_ARG_success.parent_struct,
  &_org_gnome_shell_screenshot_method_info_screenshot_OUT_ARG_filename_used.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_shell_screenshot_method_info_screenshot =
{
  {
    -1,
    (gchar *) "Screenshot",
    (GDBusArgInfo **) &_org_gnome_shell_screenshot_method_info_screenshot_IN_ARG_pointers,
    (GDBusArgInfo **) &_org_gnome_shell_screenshot_method_info_screenshot_OUT_ARG_pointers,
    NULL
  },
  "handle-screenshot",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_window_IN_ARG_include_frame =
{
  {
    -1,
    (gchar *) "include_frame",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_window_IN_ARG_include_cursor =
{
  {
    -1,
    (gchar *) "include_cursor",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_window_IN_ARG_flash =
{
  {
    -1,
    (gchar *) "flash",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_window_IN_ARG_filename =
{
  {
    -1,
    (gchar *) "filename",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_shell_screenshot_method_info_screenshot_window_IN_ARG_pointers[] =
{
  &_org_gnome_shell_screenshot_method_info_screenshot_window_IN_ARG_include_frame.parent_struct,
  &_org_gnome_shell_screenshot_method_info_screenshot_window_IN_ARG_include_cursor.parent_struct,
  &_org_gnome_shell_screenshot_method_info_screenshot_window_IN_ARG_flash.parent_struct,
  &_org_gnome_shell_screenshot_method_info_screenshot_window_IN_ARG_filename.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_window_OUT_ARG_success =
{
  {
    -1,
    (gchar *) "success",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_window_OUT_ARG_filename_used =
{
  {
    -1,
    (gchar *) "filename_used",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_shell_screenshot_method_info_screenshot_window_OUT_ARG_pointers[] =
{
  &_org_gnome_shell_screenshot_method_info_screenshot_window_OUT_ARG_success.parent_struct,
  &_org_gnome_shell_screenshot_method_info_screenshot_window_OUT_ARG_filename_used.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_shell_screenshot_method_info_screenshot_window =
{
  {
    -1,
    (gchar *) "ScreenshotWindow",
    (GDBusArgInfo **) &_org_gnome_shell_screenshot_method_info_screenshot_window_IN_ARG_pointers,
    (GDBusArgInfo **) &_org_gnome_shell_screenshot_method_info_screenshot_window_OUT_ARG_pointers,
    NULL
  },
  "handle-screenshot-window",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_area_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_area_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_area_IN_ARG_width =
{
  {
    -1,
    (gchar *) "width",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_area_IN_ARG_height =
{
  {
    -1,
    (gchar *) "height",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_area_IN_ARG_flash =
{
  {
    -1,
    (gchar *) "flash",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_area_IN_ARG_filename =
{
  {
    -1,
    (gchar *) "filename",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_shell_screenshot_method_info_screenshot_area_IN_ARG_pointers[] =
{
  &_org_gnome_shell_screenshot_method_info_screenshot_area_IN_ARG_x.parent_struct,
  &_org_gnome_shell_screenshot_method_info_screenshot_area_IN_ARG_y.parent_struct,
  &_org_gnome_shell_screenshot_method_info_screenshot_area_IN_ARG_width.parent_struct,
  &_org_gnome_shell_screenshot_method_info_screenshot_area_IN_ARG_height.parent_struct,
  &_org_gnome_shell_screenshot_method_info_screenshot_area_IN_ARG_flash.parent_struct,
  &_org_gnome_shell_screenshot_method_info_screenshot_area_IN_ARG_filename.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_area_OUT_ARG_success =
{
  {
    -1,
    (gchar *) "success",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_area_OUT_ARG_filename_used =
{
  {
    -1,
    (gchar *) "filename_used",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_shell_screenshot_method_info_screenshot_area_OUT_ARG_pointers[] =
{
  &_org_gnome_shell_screenshot_method_info_screenshot_area_OUT_ARG_success.parent_struct,
  &_org_gnome_shell_screenshot_method_info_screenshot_area_OUT_ARG_filename_used.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_shell_screenshot_method_info_screenshot_area =
{
  {
    -1,
    (gchar *) "ScreenshotArea",
    (GDBusArgInfo **) &_org_gnome_shell_screenshot_method_info_screenshot_area_IN_ARG_pointers,
    (GDBusArgInfo **) &_org_gnome_shell_screenshot_method_info_screenshot_area_OUT_ARG_pointers,
    NULL
  },
  "handle-screenshot-area",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_flash_area_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_flash_area_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_flash_area_IN_ARG_width =
{
  {
    -1,
    (gchar *) "width",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_flash_area_IN_ARG_height =
{
  {
    -1,
    (gchar *) "height",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_shell_screenshot_method_info_flash_area_IN_ARG_pointers[] =
{
  &_org_gnome_shell_screenshot_method_info_flash_area_IN_ARG_x.parent_struct,
  &_org_gnome_shell_screenshot_method_info_flash_area_IN_ARG_y.parent_struct,
  &_org_gnome_shell_screenshot_method_info_flash_area_IN_ARG_width.parent_struct,
  &_org_gnome_shell_screenshot_method_info_flash_area_IN_ARG_height.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_shell_screenshot_method_info_flash_area =
{
  {
    -1,
    (gchar *) "FlashArea",
    (GDBusArgInfo **) &_org_gnome_shell_screenshot_method_info_flash_area_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-flash-area",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_select_area_OUT_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_select_area_OUT_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_select_area_OUT_ARG_width =
{
  {
    -1,
    (gchar *) "width",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_select_area_OUT_ARG_height =
{
  {
    -1,
    (gchar *) "height",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_shell_screenshot_method_info_select_area_OUT_ARG_pointers[] =
{
  &_org_gnome_shell_screenshot_method_info_select_area_OUT_ARG_x.parent_struct,
  &_org_gnome_shell_screenshot_method_info_select_area_OUT_ARG_y.parent_struct,
  &_org_gnome_shell_screenshot_method_info_select_area_OUT_ARG_width.parent_struct,
  &_org_gnome_shell_screenshot_method_info_select_area_OUT_ARG_height.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_shell_screenshot_method_info_select_area =
{
  {
    -1,
    (gchar *) "SelectArea",
    NULL,
    (GDBusArgInfo **) &_org_gnome_shell_screenshot_method_info_select_area_OUT_ARG_pointers,
    NULL
  },
  "handle-select-area",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_pick_color_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_shell_screenshot_method_info_pick_color_OUT_ARG_pointers[] =
{
  &_org_gnome_shell_screenshot_method_info_pick_color_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_shell_screenshot_method_info_pick_color =
{
  {
    -1,
    (gchar *) "PickColor",
    NULL,
    (GDBusArgInfo **) &_org_gnome_shell_screenshot_method_info_pick_color_OUT_ARG_pointers,
    NULL
  },
  "handle-pick-color",
  FALSE
};

static const GDBusMethodInfo * const _org_gnome_shell_screenshot_method_info_pointers[] =
{
  &_org_gnome_shell_screenshot_method_info_screenshot.parent_struct,
  &_org_gnome_shell_screenshot_method_info_screenshot_window.parent_struct,
  &_org_gnome_shell_screenshot_method_info_screenshot_area.parent_struct,
  &_org_gnome_shell_screenshot_method_info_flash_area.parent_struct,
  &_org_gnome_shell_screenshot_method_info_select_area.parent_struct,
  &_org_gnome_shell_screenshot_method_info_pick_color.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _org_gnome_shell_screenshot_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Shell.Screenshot",
    (GDBusMethodInfo **) &_org_gnome_shell_screenshot_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "org-gnome-shell-screenshot",
};


/**
 * org_gnome_shell_screenshot_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Shell-Screenshot.top_of_page">org.gnome.Shell.Screenshot</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
org_gnome_shell_screenshot_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_org_gnome_shell_screenshot_interface_info.parent_struct;
}

/**
 * org_gnome_shell_screenshot_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #OrgGnomeShellScreenshot interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
org_gnome_shell_screenshot_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
org_gnome_shell_screenshot_method_marshal_screenshot (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN_BOOLEAN_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_gnome_shell_screenshot_method_marshal_screenshot_window (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN_BOOLEAN_BOOLEAN_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_gnome_shell_screenshot_method_marshal_screenshot_area (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_INT_INT_INT_BOOLEAN_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_gnome_shell_screenshot_method_marshal_flash_area (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_INT_INT_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_gnome_shell_screenshot_method_marshal_select_area (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_gnome_shell_screenshot_method_marshal_pick_color (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * OrgGnomeShellScreenshot:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Shell-Screenshot.top_of_page">org.gnome.Shell.Screenshot</link>.
 */

/**
 * OrgGnomeShellScreenshotIface:
 * @parent_iface: The parent interface.
 * @handle_flash_area: Handler for the #OrgGnomeShellScreenshot::handle-flash-area signal.
 * @handle_pick_color: Handler for the #OrgGnomeShellScreenshot::handle-pick-color signal.
 * @handle_screenshot: Handler for the #OrgGnomeShellScreenshot::handle-screenshot signal.
 * @handle_screenshot_area: Handler for the #OrgGnomeShellScreenshot::handle-screenshot-area signal.
 * @handle_screenshot_window: Handler for the #OrgGnomeShellScreenshot::handle-screenshot-window signal.
 * @handle_select_area: Handler for the #OrgGnomeShellScreenshot::handle-select-area signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Shell-Screenshot.top_of_page">org.gnome.Shell.Screenshot</link>.
 */

typedef OrgGnomeShellScreenshotIface OrgGnomeShellScreenshotInterface;
G_DEFINE_INTERFACE (OrgGnomeShellScreenshot, org_gnome_shell_screenshot, G_TYPE_OBJECT)

static void
org_gnome_shell_screenshot_default_init (OrgGnomeShellScreenshotIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * OrgGnomeShellScreenshot::handle-screenshot:
   * @object: A #OrgGnomeShellScreenshot.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_include_cursor: Argument passed by remote caller.
   * @arg_flash: Argument passed by remote caller.
   * @arg_filename: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.Screenshot">Screenshot()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_shell_screenshot_complete_screenshot() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-screenshot",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeShellScreenshotIface, handle_screenshot),
    g_signal_accumulator_true_handled,
    NULL,
      org_gnome_shell_screenshot_method_marshal_screenshot,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN, G_TYPE_STRING);

  /**
   * OrgGnomeShellScreenshot::handle-screenshot-window:
   * @object: A #OrgGnomeShellScreenshot.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_include_frame: Argument passed by remote caller.
   * @arg_include_cursor: Argument passed by remote caller.
   * @arg_flash: Argument passed by remote caller.
   * @arg_filename: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.ScreenshotWindow">ScreenshotWindow()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_shell_screenshot_complete_screenshot_window() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-screenshot-window",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeShellScreenshotIface, handle_screenshot_window),
    g_signal_accumulator_true_handled,
    NULL,
      org_gnome_shell_screenshot_method_marshal_screenshot_window,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN, G_TYPE_STRING);

  /**
   * OrgGnomeShellScreenshot::handle-screenshot-area:
   * @object: A #OrgGnomeShellScreenshot.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   * @arg_width: Argument passed by remote caller.
   * @arg_height: Argument passed by remote caller.
   * @arg_flash: Argument passed by remote caller.
   * @arg_filename: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.ScreenshotArea">ScreenshotArea()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_shell_screenshot_complete_screenshot_area() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-screenshot-area",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeShellScreenshotIface, handle_screenshot_area),
    g_signal_accumulator_true_handled,
    NULL,
      org_gnome_shell_screenshot_method_marshal_screenshot_area,
    G_TYPE_BOOLEAN,
    7,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_BOOLEAN, G_TYPE_STRING);

  /**
   * OrgGnomeShellScreenshot::handle-flash-area:
   * @object: A #OrgGnomeShellScreenshot.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   * @arg_width: Argument passed by remote caller.
   * @arg_height: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.FlashArea">FlashArea()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_shell_screenshot_complete_flash_area() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-flash-area",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeShellScreenshotIface, handle_flash_area),
    g_signal_accumulator_true_handled,
    NULL,
      org_gnome_shell_screenshot_method_marshal_flash_area,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT);

  /**
   * OrgGnomeShellScreenshot::handle-select-area:
   * @object: A #OrgGnomeShellScreenshot.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.SelectArea">SelectArea()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_shell_screenshot_complete_select_area() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-select-area",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeShellScreenshotIface, handle_select_area),
    g_signal_accumulator_true_handled,
    NULL,
      org_gnome_shell_screenshot_method_marshal_select_area,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * OrgGnomeShellScreenshot::handle-pick-color:
   * @object: A #OrgGnomeShellScreenshot.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.PickColor">PickColor()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_shell_screenshot_complete_pick_color() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-pick-color",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeShellScreenshotIface, handle_pick_color),
    g_signal_accumulator_true_handled,
    NULL,
      org_gnome_shell_screenshot_method_marshal_pick_color,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

}

/**
 * org_gnome_shell_screenshot_call_screenshot:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @arg_include_cursor: Argument to pass with the method invocation.
 * @arg_flash: Argument to pass with the method invocation.
 * @arg_filename: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.Screenshot">Screenshot()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_shell_screenshot_call_screenshot_finish() to get the result of the operation.
 *
 * See org_gnome_shell_screenshot_call_screenshot_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_shell_screenshot_call_screenshot (
    OrgGnomeShellScreenshot *proxy,
    gboolean arg_include_cursor,
    gboolean arg_flash,
    const gchar *arg_filename,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Screenshot",
    g_variant_new ("(bbs)",
                   arg_include_cursor,
                   arg_flash,
                   arg_filename),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_shell_screenshot_call_screenshot_finish:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @out_success: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_filename_used: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_shell_screenshot_call_screenshot().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_shell_screenshot_call_screenshot().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_shell_screenshot_call_screenshot_finish (
    OrgGnomeShellScreenshot *proxy,
    gboolean *out_success,
    gchar **out_filename_used,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(bs)",
                 out_success,
                 out_filename_used);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_shell_screenshot_call_screenshot_sync:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @arg_include_cursor: Argument to pass with the method invocation.
 * @arg_flash: Argument to pass with the method invocation.
 * @arg_filename: Argument to pass with the method invocation.
 * @out_success: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_filename_used: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.Screenshot">Screenshot()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_shell_screenshot_call_screenshot() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_shell_screenshot_call_screenshot_sync (
    OrgGnomeShellScreenshot *proxy,
    gboolean arg_include_cursor,
    gboolean arg_flash,
    const gchar *arg_filename,
    gboolean *out_success,
    gchar **out_filename_used,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Screenshot",
    g_variant_new ("(bbs)",
                   arg_include_cursor,
                   arg_flash,
                   arg_filename),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(bs)",
                 out_success,
                 out_filename_used);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_shell_screenshot_call_screenshot_window:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @arg_include_frame: Argument to pass with the method invocation.
 * @arg_include_cursor: Argument to pass with the method invocation.
 * @arg_flash: Argument to pass with the method invocation.
 * @arg_filename: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.ScreenshotWindow">ScreenshotWindow()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_shell_screenshot_call_screenshot_window_finish() to get the result of the operation.
 *
 * See org_gnome_shell_screenshot_call_screenshot_window_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_shell_screenshot_call_screenshot_window (
    OrgGnomeShellScreenshot *proxy,
    gboolean arg_include_frame,
    gboolean arg_include_cursor,
    gboolean arg_flash,
    const gchar *arg_filename,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ScreenshotWindow",
    g_variant_new ("(bbbs)",
                   arg_include_frame,
                   arg_include_cursor,
                   arg_flash,
                   arg_filename),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_shell_screenshot_call_screenshot_window_finish:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @out_success: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_filename_used: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_shell_screenshot_call_screenshot_window().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_shell_screenshot_call_screenshot_window().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_shell_screenshot_call_screenshot_window_finish (
    OrgGnomeShellScreenshot *proxy,
    gboolean *out_success,
    gchar **out_filename_used,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(bs)",
                 out_success,
                 out_filename_used);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_shell_screenshot_call_screenshot_window_sync:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @arg_include_frame: Argument to pass with the method invocation.
 * @arg_include_cursor: Argument to pass with the method invocation.
 * @arg_flash: Argument to pass with the method invocation.
 * @arg_filename: Argument to pass with the method invocation.
 * @out_success: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_filename_used: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.ScreenshotWindow">ScreenshotWindow()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_shell_screenshot_call_screenshot_window() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_shell_screenshot_call_screenshot_window_sync (
    OrgGnomeShellScreenshot *proxy,
    gboolean arg_include_frame,
    gboolean arg_include_cursor,
    gboolean arg_flash,
    const gchar *arg_filename,
    gboolean *out_success,
    gchar **out_filename_used,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ScreenshotWindow",
    g_variant_new ("(bbbs)",
                   arg_include_frame,
                   arg_include_cursor,
                   arg_flash,
                   arg_filename),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(bs)",
                 out_success,
                 out_filename_used);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_shell_screenshot_call_screenshot_area:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @arg_width: Argument to pass with the method invocation.
 * @arg_height: Argument to pass with the method invocation.
 * @arg_flash: Argument to pass with the method invocation.
 * @arg_filename: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.ScreenshotArea">ScreenshotArea()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_shell_screenshot_call_screenshot_area_finish() to get the result of the operation.
 *
 * See org_gnome_shell_screenshot_call_screenshot_area_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_shell_screenshot_call_screenshot_area (
    OrgGnomeShellScreenshot *proxy,
    gint arg_x,
    gint arg_y,
    gint arg_width,
    gint arg_height,
    gboolean arg_flash,
    const gchar *arg_filename,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ScreenshotArea",
    g_variant_new ("(iiiibs)",
                   arg_x,
                   arg_y,
                   arg_width,
                   arg_height,
                   arg_flash,
                   arg_filename),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_shell_screenshot_call_screenshot_area_finish:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @out_success: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_filename_used: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_shell_screenshot_call_screenshot_area().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_shell_screenshot_call_screenshot_area().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_shell_screenshot_call_screenshot_area_finish (
    OrgGnomeShellScreenshot *proxy,
    gboolean *out_success,
    gchar **out_filename_used,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(bs)",
                 out_success,
                 out_filename_used);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_shell_screenshot_call_screenshot_area_sync:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @arg_width: Argument to pass with the method invocation.
 * @arg_height: Argument to pass with the method invocation.
 * @arg_flash: Argument to pass with the method invocation.
 * @arg_filename: Argument to pass with the method invocation.
 * @out_success: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_filename_used: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.ScreenshotArea">ScreenshotArea()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_shell_screenshot_call_screenshot_area() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_shell_screenshot_call_screenshot_area_sync (
    OrgGnomeShellScreenshot *proxy,
    gint arg_x,
    gint arg_y,
    gint arg_width,
    gint arg_height,
    gboolean arg_flash,
    const gchar *arg_filename,
    gboolean *out_success,
    gchar **out_filename_used,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ScreenshotArea",
    g_variant_new ("(iiiibs)",
                   arg_x,
                   arg_y,
                   arg_width,
                   arg_height,
                   arg_flash,
                   arg_filename),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(bs)",
                 out_success,
                 out_filename_used);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_shell_screenshot_call_flash_area:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @arg_width: Argument to pass with the method invocation.
 * @arg_height: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.FlashArea">FlashArea()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_shell_screenshot_call_flash_area_finish() to get the result of the operation.
 *
 * See org_gnome_shell_screenshot_call_flash_area_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_shell_screenshot_call_flash_area (
    OrgGnomeShellScreenshot *proxy,
    gint arg_x,
    gint arg_y,
    gint arg_width,
    gint arg_height,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "FlashArea",
    g_variant_new ("(iiii)",
                   arg_x,
                   arg_y,
                   arg_width,
                   arg_height),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_shell_screenshot_call_flash_area_finish:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_shell_screenshot_call_flash_area().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_shell_screenshot_call_flash_area().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_shell_screenshot_call_flash_area_finish (
    OrgGnomeShellScreenshot *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_shell_screenshot_call_flash_area_sync:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @arg_width: Argument to pass with the method invocation.
 * @arg_height: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.FlashArea">FlashArea()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_shell_screenshot_call_flash_area() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_shell_screenshot_call_flash_area_sync (
    OrgGnomeShellScreenshot *proxy,
    gint arg_x,
    gint arg_y,
    gint arg_width,
    gint arg_height,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "FlashArea",
    g_variant_new ("(iiii)",
                   arg_x,
                   arg_y,
                   arg_width,
                   arg_height),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_shell_screenshot_call_select_area:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.SelectArea">SelectArea()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_shell_screenshot_call_select_area_finish() to get the result of the operation.
 *
 * See org_gnome_shell_screenshot_call_select_area_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_shell_screenshot_call_select_area (
    OrgGnomeShellScreenshot *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SelectArea",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_shell_screenshot_call_select_area_finish:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @out_x: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_y: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_width: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_height: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_shell_screenshot_call_select_area().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_shell_screenshot_call_select_area().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_shell_screenshot_call_select_area_finish (
    OrgGnomeShellScreenshot *proxy,
    gint *out_x,
    gint *out_y,
    gint *out_width,
    gint *out_height,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(iiii)",
                 out_x,
                 out_y,
                 out_width,
                 out_height);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_shell_screenshot_call_select_area_sync:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @out_x: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_y: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_width: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_height: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.SelectArea">SelectArea()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_shell_screenshot_call_select_area() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_shell_screenshot_call_select_area_sync (
    OrgGnomeShellScreenshot *proxy,
    gint *out_x,
    gint *out_y,
    gint *out_width,
    gint *out_height,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SelectArea",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(iiii)",
                 out_x,
                 out_y,
                 out_width,
                 out_height);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_shell_screenshot_call_pick_color:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.PickColor">PickColor()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_shell_screenshot_call_pick_color_finish() to get the result of the operation.
 *
 * See org_gnome_shell_screenshot_call_pick_color_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_shell_screenshot_call_pick_color (
    OrgGnomeShellScreenshot *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PickColor",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_shell_screenshot_call_pick_color_finish:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_shell_screenshot_call_pick_color().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_shell_screenshot_call_pick_color().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_shell_screenshot_call_pick_color_finish (
    OrgGnomeShellScreenshot *proxy,
    GVariant **out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_shell_screenshot_call_pick_color_sync:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.PickColor">PickColor()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_shell_screenshot_call_pick_color() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_shell_screenshot_call_pick_color_sync (
    OrgGnomeShellScreenshot *proxy,
    GVariant **out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PickColor",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_shell_screenshot_complete_screenshot:
 * @object: A #OrgGnomeShellScreenshot.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @success: Parameter to return.
 * @filename_used: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.Screenshot">Screenshot()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_shell_screenshot_complete_screenshot (
    OrgGnomeShellScreenshot *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean success,
    const gchar *filename_used)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(bs)",
                   success,
                   filename_used));
}

/**
 * org_gnome_shell_screenshot_complete_screenshot_window:
 * @object: A #OrgGnomeShellScreenshot.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @success: Parameter to return.
 * @filename_used: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.ScreenshotWindow">ScreenshotWindow()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_shell_screenshot_complete_screenshot_window (
    OrgGnomeShellScreenshot *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean success,
    const gchar *filename_used)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(bs)",
                   success,
                   filename_used));
}

/**
 * org_gnome_shell_screenshot_complete_screenshot_area:
 * @object: A #OrgGnomeShellScreenshot.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @success: Parameter to return.
 * @filename_used: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.ScreenshotArea">ScreenshotArea()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_shell_screenshot_complete_screenshot_area (
    OrgGnomeShellScreenshot *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean success,
    const gchar *filename_used)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(bs)",
                   success,
                   filename_used));
}

/**
 * org_gnome_shell_screenshot_complete_flash_area:
 * @object: A #OrgGnomeShellScreenshot.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.FlashArea">FlashArea()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_shell_screenshot_complete_flash_area (
    OrgGnomeShellScreenshot *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_gnome_shell_screenshot_complete_select_area:
 * @object: A #OrgGnomeShellScreenshot.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @x: Parameter to return.
 * @y: Parameter to return.
 * @width: Parameter to return.
 * @height: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.SelectArea">SelectArea()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_shell_screenshot_complete_select_area (
    OrgGnomeShellScreenshot *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gint x,
    gint y,
    gint width,
    gint height)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(iiii)",
                   x,
                   y,
                   width,
                   height));
}

/**
 * org_gnome_shell_screenshot_complete_pick_color:
 * @object: A #OrgGnomeShellScreenshot.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.PickColor">PickColor()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_shell_screenshot_complete_pick_color (
    OrgGnomeShellScreenshot *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sv})",
                   result));
}

/* ------------------------------------------------------------------------ */

/**
 * OrgGnomeShellScreenshotProxy:
 *
 * The #OrgGnomeShellScreenshotProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgGnomeShellScreenshotProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgGnomeShellScreenshotProxy.
 */

struct _OrgGnomeShellScreenshotProxyPrivate
{
  GData *qdata;
};

static void org_gnome_shell_screenshot_proxy_iface_init (OrgGnomeShellScreenshotIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgGnomeShellScreenshotProxy, org_gnome_shell_screenshot_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (OrgGnomeShellScreenshotProxy)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_SHELL_SCREENSHOT, org_gnome_shell_screenshot_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgGnomeShellScreenshotProxy, org_gnome_shell_screenshot_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_SHELL_SCREENSHOT, org_gnome_shell_screenshot_proxy_iface_init))

#endif
static void
org_gnome_shell_screenshot_proxy_finalize (GObject *object)
{
  OrgGnomeShellScreenshotProxy *proxy = ORG_GNOME_SHELL_SCREENSHOT_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (org_gnome_shell_screenshot_proxy_parent_class)->finalize (object);
}

static void
org_gnome_shell_screenshot_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
org_gnome_shell_screenshot_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
org_gnome_shell_screenshot_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_org_gnome_shell_screenshot_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TYPE_ORG_GNOME_SHELL_SCREENSHOT);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_GNOME_SHELL_SCREENSHOT);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
org_gnome_shell_screenshot_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  OrgGnomeShellScreenshotProxy *proxy = ORG_GNOME_SHELL_SCREENSHOT_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_shell_screenshot_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_shell_screenshot_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
org_gnome_shell_screenshot_proxy_init (OrgGnomeShellScreenshotProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = org_gnome_shell_screenshot_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TYPE_ORG_GNOME_SHELL_SCREENSHOT_PROXY, OrgGnomeShellScreenshotProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), org_gnome_shell_screenshot_interface_info ());
}

static void
org_gnome_shell_screenshot_proxy_class_init (OrgGnomeShellScreenshotProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = org_gnome_shell_screenshot_proxy_finalize;
  gobject_class->get_property = org_gnome_shell_screenshot_proxy_get_property;
  gobject_class->set_property = org_gnome_shell_screenshot_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = org_gnome_shell_screenshot_proxy_g_signal;
  proxy_class->g_properties_changed = org_gnome_shell_screenshot_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgGnomeShellScreenshotProxyPrivate));
#endif
}

static void
org_gnome_shell_screenshot_proxy_iface_init (OrgGnomeShellScreenshotIface *iface G_GNUC_UNUSED)
{
}

/**
 * org_gnome_shell_screenshot_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Shell-Screenshot.top_of_page">org.gnome.Shell.Screenshot</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_shell_screenshot_proxy_new_finish() to get the result of the operation.
 *
 * See org_gnome_shell_screenshot_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
org_gnome_shell_screenshot_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_GNOME_SHELL_SCREENSHOT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Shell.Screenshot", NULL);
}

/**
 * org_gnome_shell_screenshot_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_shell_screenshot_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_gnome_shell_screenshot_proxy_new().
 *
 * Returns: (transfer full) (type OrgGnomeShellScreenshotProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeShellScreenshot *
org_gnome_shell_screenshot_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_GNOME_SHELL_SCREENSHOT (ret);
  else
    return NULL;
}

/**
 * org_gnome_shell_screenshot_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Shell-Screenshot.top_of_page">org.gnome.Shell.Screenshot</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_gnome_shell_screenshot_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgGnomeShellScreenshotProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeShellScreenshot *
org_gnome_shell_screenshot_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_GNOME_SHELL_SCREENSHOT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Shell.Screenshot", NULL);
  if (ret != NULL)
    return ORG_GNOME_SHELL_SCREENSHOT (ret);
  else
    return NULL;
}


/**
 * org_gnome_shell_screenshot_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like org_gnome_shell_screenshot_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_shell_screenshot_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See org_gnome_shell_screenshot_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
org_gnome_shell_screenshot_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_GNOME_SHELL_SCREENSHOT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Shell.Screenshot", NULL);
}

/**
 * org_gnome_shell_screenshot_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_shell_screenshot_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_gnome_shell_screenshot_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type OrgGnomeShellScreenshotProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeShellScreenshot *
org_gnome_shell_screenshot_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_GNOME_SHELL_SCREENSHOT (ret);
  else
    return NULL;
}

/**
 * org_gnome_shell_screenshot_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like org_gnome_shell_screenshot_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_gnome_shell_screenshot_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgGnomeShellScreenshotProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeShellScreenshot *
org_gnome_shell_screenshot_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_GNOME_SHELL_SCREENSHOT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Shell.Screenshot", NULL);
  if (ret != NULL)
    return ORG_GNOME_SHELL_SCREENSHOT (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * OrgGnomeShellScreenshotSkeleton:
 *
 * The #OrgGnomeShellScreenshotSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgGnomeShellScreenshotSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgGnomeShellScreenshotSkeleton.
 */

struct _OrgGnomeShellScreenshotSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_org_gnome_shell_screenshot_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  OrgGnomeShellScreenshotSkeleton *skeleton = ORG_GNOME_SHELL_SCREENSHOT_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TYPE_ORG_GNOME_SHELL_SCREENSHOT);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_GNOME_SHELL_SCREENSHOT);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_org_gnome_shell_screenshot_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  OrgGnomeShellScreenshotSkeleton *skeleton = ORG_GNOME_SHELL_SCREENSHOT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_shell_screenshot_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_org_gnome_shell_screenshot_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  OrgGnomeShellScreenshotSkeleton *skeleton = ORG_GNOME_SHELL_SCREENSHOT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_shell_screenshot_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _org_gnome_shell_screenshot_skeleton_vtable =
{
  _org_gnome_shell_screenshot_skeleton_handle_method_call,
  _org_gnome_shell_screenshot_skeleton_handle_get_property,
  _org_gnome_shell_screenshot_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
org_gnome_shell_screenshot_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return org_gnome_shell_screenshot_interface_info ();
}

static GDBusInterfaceVTable *
org_gnome_shell_screenshot_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_org_gnome_shell_screenshot_skeleton_vtable;
}

static GVariant *
org_gnome_shell_screenshot_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  OrgGnomeShellScreenshotSkeleton *skeleton = ORG_GNOME_SHELL_SCREENSHOT_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_org_gnome_shell_screenshot_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _org_gnome_shell_screenshot_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _org_gnome_shell_screenshot_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _org_gnome_shell_screenshot_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Shell.Screenshot", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
org_gnome_shell_screenshot_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void org_gnome_shell_screenshot_skeleton_iface_init (OrgGnomeShellScreenshotIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgGnomeShellScreenshotSkeleton, org_gnome_shell_screenshot_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (OrgGnomeShellScreenshotSkeleton)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_SHELL_SCREENSHOT, org_gnome_shell_screenshot_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgGnomeShellScreenshotSkeleton, org_gnome_shell_screenshot_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_SHELL_SCREENSHOT, org_gnome_shell_screenshot_skeleton_iface_init))

#endif
static void
org_gnome_shell_screenshot_skeleton_finalize (GObject *object)
{
  OrgGnomeShellScreenshotSkeleton *skeleton = ORG_GNOME_SHELL_SCREENSHOT_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (org_gnome_shell_screenshot_skeleton_parent_class)->finalize (object);
}

static void
org_gnome_shell_screenshot_skeleton_init (OrgGnomeShellScreenshotSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = org_gnome_shell_screenshot_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TYPE_ORG_GNOME_SHELL_SCREENSHOT_SKELETON, OrgGnomeShellScreenshotSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
org_gnome_shell_screenshot_skeleton_class_init (OrgGnomeShellScreenshotSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = org_gnome_shell_screenshot_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = org_gnome_shell_screenshot_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = org_gnome_shell_screenshot_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = org_gnome_shell_screenshot_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = org_gnome_shell_screenshot_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgGnomeShellScreenshotSkeletonPrivate));
#endif
}

static void
org_gnome_shell_screenshot_skeleton_iface_init (OrgGnomeShellScreenshotIface *iface G_GNUC_UNUSED)
{
}

/**
 * org_gnome_shell_screenshot_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Shell-Screenshot.top_of_page">org.gnome.Shell.Screenshot</link>.
 *
 * Returns: (transfer full) (type OrgGnomeShellScreenshotSkeleton): The skeleton object.
 */
OrgGnomeShellScreenshot *
org_gnome_shell_screenshot_skeleton_new (void)
{
  return ORG_GNOME_SHELL_SCREENSHOT (g_object_new (TYPE_ORG_GNOME_SHELL_SCREENSHOT_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.mate.ScreenSaver
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:OrgMateScreenSaver
 * @title: OrgMateScreenSaver
 * @short_description: Generated C code for the org.mate.ScreenSaver D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-mate-ScreenSaver.top_of_page">org.mate.ScreenSaver</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.mate.ScreenSaver ---- */

static const _ExtendedGDBusMethodInfo _org_mate_screen_saver_method_info_lock =
{
  {
    -1,
    (gchar *) "Lock",
    NULL,
    NULL,
    NULL
  },
  "handle-lock",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_mate_screen_saver_method_info_get_active_OUT_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_mate_screen_saver_method_info_get_active_OUT_ARG_pointers[] =
{
  &_org_mate_screen_saver_method_info_get_active_OUT_ARG_value.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_mate_screen_saver_method_info_get_active =
{
  {
    -1,
    (gchar *) "GetActive",
    NULL,
    (GDBusArgInfo **) &_org_mate_screen_saver_method_info_get_active_OUT_ARG_pointers,
    NULL
  },
  "handle-get-active",
  FALSE
};

static const GDBusMethodInfo * const _org_mate_screen_saver_method_info_pointers[] =
{
  &_org_mate_screen_saver_method_info_lock.parent_struct,
  &_org_mate_screen_saver_method_info_get_active.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _org_mate_screen_saver_interface_info =
{
  {
    -1,
    (gchar *) "org.mate.ScreenSaver",
    (GDBusMethodInfo **) &_org_mate_screen_saver_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "org-mate-screen-saver",
};


/**
 * org_mate_screen_saver_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-mate-ScreenSaver.top_of_page">org.mate.ScreenSaver</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
org_mate_screen_saver_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_org_mate_screen_saver_interface_info.parent_struct;
}

/**
 * org_mate_screen_saver_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #OrgMateScreenSaver interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
org_mate_screen_saver_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
org_mate_screen_saver_method_marshal_lock (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
org_mate_screen_saver_method_marshal_get_active (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * OrgMateScreenSaver:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-mate-ScreenSaver.top_of_page">org.mate.ScreenSaver</link>.
 */

/**
 * OrgMateScreenSaverIface:
 * @parent_iface: The parent interface.
 * @handle_get_active: Handler for the #OrgMateScreenSaver::handle-get-active signal.
 * @handle_lock: Handler for the #OrgMateScreenSaver::handle-lock signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-mate-ScreenSaver.top_of_page">org.mate.ScreenSaver</link>.
 */

typedef OrgMateScreenSaverIface OrgMateScreenSaverInterface;
G_DEFINE_INTERFACE (OrgMateScreenSaver, org_mate_screen_saver, G_TYPE_OBJECT)

static void
org_mate_screen_saver_default_init (OrgMateScreenSaverIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * OrgMateScreenSaver::handle-lock:
   * @object: A #OrgMateScreenSaver.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mate-ScreenSaver.Lock">Lock()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_mate_screen_saver_complete_lock() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-lock",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgMateScreenSaverIface, handle_lock),
    g_signal_accumulator_true_handled,
    NULL,
      org_mate_screen_saver_method_marshal_lock,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * OrgMateScreenSaver::handle-get-active:
   * @object: A #OrgMateScreenSaver.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mate-ScreenSaver.GetActive">GetActive()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_mate_screen_saver_complete_get_active() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-active",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgMateScreenSaverIface, handle_get_active),
    g_signal_accumulator_true_handled,
    NULL,
      org_mate_screen_saver_method_marshal_get_active,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

}

/**
 * org_mate_screen_saver_call_lock:
 * @proxy: A #OrgMateScreenSaverProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mate-ScreenSaver.Lock">Lock()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_mate_screen_saver_call_lock_finish() to get the result of the operation.
 *
 * See org_mate_screen_saver_call_lock_sync() for the synchronous, blocking version of this method.
 */
void
org_mate_screen_saver_call_lock (
    OrgMateScreenSaver *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Lock",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_mate_screen_saver_call_lock_finish:
 * @proxy: A #OrgMateScreenSaverProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_mate_screen_saver_call_lock().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_mate_screen_saver_call_lock().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_mate_screen_saver_call_lock_finish (
    OrgMateScreenSaver *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_mate_screen_saver_call_lock_sync:
 * @proxy: A #OrgMateScreenSaverProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mate-ScreenSaver.Lock">Lock()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_mate_screen_saver_call_lock() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_mate_screen_saver_call_lock_sync (
    OrgMateScreenSaver *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Lock",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_mate_screen_saver_call_get_active:
 * @proxy: A #OrgMateScreenSaverProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mate-ScreenSaver.GetActive">GetActive()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_mate_screen_saver_call_get_active_finish() to get the result of the operation.
 *
 * See org_mate_screen_saver_call_get_active_sync() for the synchronous, blocking version of this method.
 */
void
org_mate_screen_saver_call_get_active (
    OrgMateScreenSaver *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetActive",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_mate_screen_saver_call_get_active_finish:
 * @proxy: A #OrgMateScreenSaverProxy.
 * @out_value: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_mate_screen_saver_call_get_active().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_mate_screen_saver_call_get_active().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_mate_screen_saver_call_get_active_finish (
    OrgMateScreenSaver *proxy,
    gboolean *out_value,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_value);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_mate_screen_saver_call_get_active_sync:
 * @proxy: A #OrgMateScreenSaverProxy.
 * @out_value: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mate-ScreenSaver.GetActive">GetActive()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_mate_screen_saver_call_get_active() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_mate_screen_saver_call_get_active_sync (
    OrgMateScreenSaver *proxy,
    gboolean *out_value,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetActive",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_value);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_mate_screen_saver_complete_lock:
 * @object: A #OrgMateScreenSaver.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mate-ScreenSaver.Lock">Lock()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_mate_screen_saver_complete_lock (
    OrgMateScreenSaver *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_mate_screen_saver_complete_get_active:
 * @object: A #OrgMateScreenSaver.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @value: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mate-ScreenSaver.GetActive">GetActive()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_mate_screen_saver_complete_get_active (
    OrgMateScreenSaver *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean value)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   value));
}

/* ------------------------------------------------------------------------ */

/**
 * OrgMateScreenSaverProxy:
 *
 * The #OrgMateScreenSaverProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgMateScreenSaverProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgMateScreenSaverProxy.
 */

struct _OrgMateScreenSaverProxyPrivate
{
  GData *qdata;
};

static void org_mate_screen_saver_proxy_iface_init (OrgMateScreenSaverIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgMateScreenSaverProxy, org_mate_screen_saver_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (OrgMateScreenSaverProxy)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_MATE_SCREEN_SAVER, org_mate_screen_saver_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgMateScreenSaverProxy, org_mate_screen_saver_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_MATE_SCREEN_SAVER, org_mate_screen_saver_proxy_iface_init))

#endif
static void
org_mate_screen_saver_proxy_finalize (GObject *object)
{
  OrgMateScreenSaverProxy *proxy = ORG_MATE_SCREEN_SAVER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (org_mate_screen_saver_proxy_parent_class)->finalize (object);
}

static void
org_mate_screen_saver_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
org_mate_screen_saver_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
org_mate_screen_saver_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_org_mate_screen_saver_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TYPE_ORG_MATE_SCREEN_SAVER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_MATE_SCREEN_SAVER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
org_mate_screen_saver_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  OrgMateScreenSaverProxy *proxy = ORG_MATE_SCREEN_SAVER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_mate_screen_saver_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_mate_screen_saver_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
org_mate_screen_saver_proxy_init (OrgMateScreenSaverProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = org_mate_screen_saver_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TYPE_ORG_MATE_SCREEN_SAVER_PROXY, OrgMateScreenSaverProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), org_mate_screen_saver_interface_info ());
}

static void
org_mate_screen_saver_proxy_class_init (OrgMateScreenSaverProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = org_mate_screen_saver_proxy_finalize;
  gobject_class->get_property = org_mate_screen_saver_proxy_get_property;
  gobject_class->set_property = org_mate_screen_saver_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = org_mate_screen_saver_proxy_g_signal;
  proxy_class->g_properties_changed = org_mate_screen_saver_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgMateScreenSaverProxyPrivate));
#endif
}

static void
org_mate_screen_saver_proxy_iface_init (OrgMateScreenSaverIface *iface G_GNUC_UNUSED)
{
}

/**
 * org_mate_screen_saver_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-mate-ScreenSaver.top_of_page">org.mate.ScreenSaver</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_mate_screen_saver_proxy_new_finish() to get the result of the operation.
 *
 * See org_mate_screen_saver_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
org_mate_screen_saver_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_MATE_SCREEN_SAVER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.mate.ScreenSaver", NULL);
}

/**
 * org_mate_screen_saver_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_mate_screen_saver_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_mate_screen_saver_proxy_new().
 *
 * Returns: (transfer full) (type OrgMateScreenSaverProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgMateScreenSaver *
org_mate_screen_saver_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_MATE_SCREEN_SAVER (ret);
  else
    return NULL;
}

/**
 * org_mate_screen_saver_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-mate-ScreenSaver.top_of_page">org.mate.ScreenSaver</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_mate_screen_saver_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgMateScreenSaverProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgMateScreenSaver *
org_mate_screen_saver_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_MATE_SCREEN_SAVER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.mate.ScreenSaver", NULL);
  if (ret != NULL)
    return ORG_MATE_SCREEN_SAVER (ret);
  else
    return NULL;
}


/**
 * org_mate_screen_saver_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like org_mate_screen_saver_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_mate_screen_saver_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See org_mate_screen_saver_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
org_mate_screen_saver_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_MATE_SCREEN_SAVER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.mate.ScreenSaver", NULL);
}

/**
 * org_mate_screen_saver_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_mate_screen_saver_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_mate_screen_saver_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type OrgMateScreenSaverProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgMateScreenSaver *
org_mate_screen_saver_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_MATE_SCREEN_SAVER (ret);
  else
    return NULL;
}

/**
 * org_mate_screen_saver_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like org_mate_screen_saver_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_mate_screen_saver_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgMateScreenSaverProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgMateScreenSaver *
org_mate_screen_saver_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_MATE_SCREEN_SAVER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.mate.ScreenSaver", NULL);
  if (ret != NULL)
    return ORG_MATE_SCREEN_SAVER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * OrgMateScreenSaverSkeleton:
 *
 * The #OrgMateScreenSaverSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgMateScreenSaverSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgMateScreenSaverSkeleton.
 */

struct _OrgMateScreenSaverSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_org_mate_screen_saver_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  OrgMateScreenSaverSkeleton *skeleton = ORG_MATE_SCREEN_SAVER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TYPE_ORG_MATE_SCREEN_SAVER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_MATE_SCREEN_SAVER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_org_mate_screen_saver_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  OrgMateScreenSaverSkeleton *skeleton = ORG_MATE_SCREEN_SAVER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_mate_screen_saver_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_org_mate_screen_saver_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  OrgMateScreenSaverSkeleton *skeleton = ORG_MATE_SCREEN_SAVER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_mate_screen_saver_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _org_mate_screen_saver_skeleton_vtable =
{
  _org_mate_screen_saver_skeleton_handle_method_call,
  _org_mate_screen_saver_skeleton_handle_get_property,
  _org_mate_screen_saver_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
org_mate_screen_saver_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return org_mate_screen_saver_interface_info ();
}

static GDBusInterfaceVTable *
org_mate_screen_saver_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_org_mate_screen_saver_skeleton_vtable;
}

static GVariant *
org_mate_screen_saver_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  OrgMateScreenSaverSkeleton *skeleton = ORG_MATE_SCREEN_SAVER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_org_mate_screen_saver_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _org_mate_screen_saver_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _org_mate_screen_saver_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _org_mate_screen_saver_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.mate.ScreenSaver", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
org_mate_screen_saver_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void org_mate_screen_saver_skeleton_iface_init (OrgMateScreenSaverIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgMateScreenSaverSkeleton, org_mate_screen_saver_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (OrgMateScreenSaverSkeleton)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_MATE_SCREEN_SAVER, org_mate_screen_saver_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgMateScreenSaverSkeleton, org_mate_screen_saver_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_MATE_SCREEN_SAVER, org_mate_screen_saver_skeleton_iface_init))

#endif
static void
org_mate_screen_saver_skeleton_finalize (GObject *object)
{
  OrgMateScreenSaverSkeleton *skeleton = ORG_MATE_SCREEN_SAVER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (org_mate_screen_saver_skeleton_parent_class)->finalize (object);
}

static void
org_mate_screen_saver_skeleton_init (OrgMateScreenSaverSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = org_mate_screen_saver_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TYPE_ORG_MATE_SCREEN_SAVER_SKELETON, OrgMateScreenSaverSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
org_mate_screen_saver_skeleton_class_init (OrgMateScreenSaverSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = org_mate_screen_saver_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = org_mate_screen_saver_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = org_mate_screen_saver_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = org_mate_screen_saver_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = org_mate_screen_saver_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgMateScreenSaverSkeletonPrivate));
#endif
}

static void
org_mate_screen_saver_skeleton_iface_init (OrgMateScreenSaverIface *iface G_GNUC_UNUSED)
{
}

/**
 * org_mate_screen_saver_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-mate-ScreenSaver.top_of_page">org.mate.ScreenSaver</link>.
 *
 * Returns: (transfer full) (type OrgMateScreenSaverSkeleton): The skeleton object.
 */
OrgMateScreenSaver *
org_mate_screen_saver_skeleton_new (void)
{
  return ORG_MATE_SCREEN_SAVER (g_object_new (TYPE_ORG_MATE_SCREEN_SAVER_SKELETON, NULL));
}

