/* SpacerApplet.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SpacerApplet.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "spacerapplet.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "plugin.h"
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <libpeas.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SPACER_PLUGIN_0_PROPERTY,
	SPACER_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* spacer_plugin_properties[SPACER_PLUGIN_NUM_PROPERTIES];
enum  {
	SPACER_SETTINGS_0_PROPERTY,
	SPACER_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* spacer_settings_properties[SPACER_SETTINGS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	SPACER_APPLET_0_PROPERTY,
	SPACER_APPLET_SPACE_SIZE_PROPERTY,
	SPACER_APPLET_UUID_PROPERTY,
	SPACER_APPLET_NUM_PROPERTIES
};
static GParamSpec* spacer_applet_properties[SPACER_APPLET_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

struct _SpacerSettingsPrivate {
	GSettings* settings;
	GtkSpinButton* spinbutton_size;
};

struct _SpacerAppletPrivate {
	gint _space_size;
	gchar* _uuid;
	GSettings* settings;
	BudgiePanelPosition panel_position;
};

static gpointer spacer_plugin_parent_class = NULL;
static BudgiePluginIface * spacer_plugin_budgie_plugin_parent_iface = NULL;
static GType spacer_plugin_type_id = 0;
static gint SpacerSettings_private_offset;
static gpointer spacer_settings_parent_class = NULL;
static GType spacer_settings_type_id = 0;
static gint SpacerApplet_private_offset;
static gpointer spacer_applet_parent_class = NULL;
static GType spacer_applet_type_id = 0;

static BudgieApplet* spacer_plugin_real_get_panel_widget (BudgiePlugin* base,
                                                   const gchar* uuid);
static void spacer_settings_finalize (GObject * obj);
static gboolean spacer_applet_real_supports_settings (BudgieApplet* base);
static GtkWidget* spacer_applet_real_get_settings_ui (BudgieApplet* base);
static void spacer_applet_on_settings_change (SpacerApplet* self,
                                       const gchar* key);
static void _spacer_applet_on_settings_change_g_settings_changed (GSettings* _sender,
                                                           const gchar* key,
                                                           gpointer self);
static void spacer_applet_real_panel_position_changed (BudgieApplet* base,
                                                BudgiePanelPosition position);
static void spacer_applet_real_get_preferred_width (GtkWidget* base,
                                             gint* min,
                                             gint* nat);
static void spacer_applet_real_get_preferred_width_for_height (GtkWidget* base,
                                                        gint h,
                                                        gint* min,
                                                        gint* nat);
static void spacer_applet_real_get_preferred_height (GtkWidget* base,
                                              gint* min,
                                              gint* nat);
static void spacer_applet_real_get_preferred_height_for_width (GtkWidget* base,
                                                        gint h,
                                                        gint* min,
                                                        gint* nat);
static void spacer_applet_finalize (GObject * obj);
static void _vala_spacer_applet_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_spacer_applet_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);

static BudgieApplet*
spacer_plugin_real_get_panel_widget (BudgiePlugin* base,
                                     const gchar* uuid)
{
	SpacerPlugin * self;
	SpacerApplet* _tmp0_;
	BudgieApplet* result;
	self = (SpacerPlugin*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = spacer_applet_new (uuid);
	g_object_ref_sink (_tmp0_);
	result = (BudgieApplet*) _tmp0_;
	return result;
}

SpacerPlugin*
spacer_plugin_construct (GType object_type)
{
	SpacerPlugin * self = NULL;
	self = (SpacerPlugin*) g_object_new (object_type, NULL);
	return self;
}

SpacerPlugin*
spacer_plugin_new (void)
{
	return spacer_plugin_construct (TYPE_SPACER_PLUGIN);
}

static void
spacer_plugin_class_init (SpacerPluginClass * klass,
                          gpointer klass_data)
{
	spacer_plugin_parent_class = g_type_class_peek_parent (klass);
}

static void
spacer_plugin_budgie_plugin_interface_init (BudgiePluginIface * iface,
                                            gpointer iface_data)
{
	spacer_plugin_budgie_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_panel_widget = (BudgieApplet* (*) (BudgiePlugin*, const gchar*)) spacer_plugin_real_get_panel_widget;
}

static void
spacer_plugin_instance_init (SpacerPlugin * self,
                             gpointer klass)
{
}

GType
spacer_plugin_get_type (void)
{
	return spacer_plugin_type_id;
}

GType
spacer_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpacerPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spacer_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpacerPlugin), 0, (GInstanceInitFunc) spacer_plugin_instance_init, NULL };
	static const GInterfaceInfo budgie_plugin_info = { (GInterfaceInitFunc) spacer_plugin_budgie_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	spacer_plugin_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "SpacerPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, spacer_plugin_type_id, budgie_plugin_get_type (), &budgie_plugin_info);
	return spacer_plugin_type_id;
}

static inline gpointer
spacer_settings_get_instance_private (SpacerSettings* self)
{
	return G_STRUCT_MEMBER_P (self, SpacerSettings_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

SpacerSettings*
spacer_settings_construct (GType object_type,
                           GSettings* settings)
{
	SpacerSettings * self = NULL;
	GSettings* _tmp0_;
	GtkSpinButton* _tmp1_;
	self = (SpacerSettings*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->spinbutton_size;
	g_settings_bind (settings, "size", (GObject*) _tmp1_, "value", G_SETTINGS_BIND_DEFAULT);
	return self;
}

SpacerSettings*
spacer_settings_new (GSettings* settings)
{
	return spacer_settings_construct (TYPE_SPACER_SETTINGS, settings);
}

static void
spacer_settings_class_init (SpacerSettingsClass * klass,
                            gpointer klass_data)
{
	spacer_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SpacerSettings_private_offset);
	G_OBJECT_CLASS (klass)->finalize = spacer_settings_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/solus-project/spacer/settings.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "spinbutton_size", FALSE, SpacerSettings_private_offset + G_STRUCT_OFFSET (SpacerSettingsPrivate, spinbutton_size));
}

static void
spacer_settings_instance_init (SpacerSettings * self,
                               gpointer klass)
{
	self->priv = spacer_settings_get_instance_private (self);
	self->priv->settings = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
spacer_settings_finalize (GObject * obj)
{
	SpacerSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SPACER_SETTINGS, SpacerSettings);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (spacer_settings_parent_class)->finalize (obj);
}

GType
spacer_settings_get_type (void)
{
	return spacer_settings_type_id;
}

GType
spacer_settings_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpacerSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spacer_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpacerSettings), 0, (GInstanceInitFunc) spacer_settings_instance_init, NULL };
	spacer_settings_type_id = g_type_module_register_type (module, gtk_grid_get_type (), "SpacerSettings", &g_define_type_info, 0);
	SpacerSettings_private_offset = sizeof (SpacerSettingsPrivate);
	return spacer_settings_type_id;
}

static inline gpointer
spacer_applet_get_instance_private (SpacerApplet* self)
{
	return G_STRUCT_MEMBER_P (self, SpacerApplet_private_offset);
}

static gboolean
spacer_applet_real_supports_settings (BudgieApplet* base)
{
	SpacerApplet * self;
	gboolean result;
	self = (SpacerApplet*) base;
	result = TRUE;
	return result;
}

static GtkWidget*
spacer_applet_real_get_settings_ui (BudgieApplet* base)
{
	SpacerApplet * self;
	const gchar* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	SpacerSettings* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* result;
	self = (SpacerApplet*) base;
	_tmp0_ = self->priv->_uuid;
	_tmp1_ = budgie_applet_get_applet_settings ((BudgieApplet*) self, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = spacer_settings_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = (GtkWidget*) _tmp3_;
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static void
_spacer_applet_on_settings_change_g_settings_changed (GSettings* _sender,
                                                      const gchar* key,
                                                      gpointer self)
{
	spacer_applet_on_settings_change ((SpacerApplet*) self, key);
}

SpacerApplet*
spacer_applet_construct (GType object_type,
                         const gchar* uuid)
{
	SpacerApplet * self = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	g_return_val_if_fail (uuid != NULL, NULL);
	self = (SpacerApplet*) g_object_new (object_type, "uuid", uuid, NULL);
	budgie_applet_set_settings_schema ((BudgieApplet*) self, "com.solus-project.spacer");
	budgie_applet_set_settings_prefix ((BudgieApplet*) self, "/com/solus-project/budgie-panel/instance/spacer");
	_tmp0_ = budgie_applet_get_applet_settings ((BudgieApplet*) self, uuid);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->settings;
	g_signal_connect_object (_tmp1_, "changed", (GCallback) _spacer_applet_on_settings_change_g_settings_changed, self, 0);
	spacer_applet_on_settings_change (self, "size");
	gtk_widget_show_all ((GtkWidget*) self);
	return self;
}

SpacerApplet*
spacer_applet_new (const gchar* uuid)
{
	return spacer_applet_construct (TYPE_SPACER_APPLET, uuid);
}

static void
spacer_applet_on_settings_change (SpacerApplet* self,
                                  const gchar* key)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, "size") != 0) {
		return;
	}
	_tmp0_ = self->priv->settings;
	spacer_applet_set_space_size (self, g_settings_get_int (_tmp0_, key));
	gtk_widget_queue_resize ((GtkWidget*) self);
}

/**
 * Our panel has moved somewhere, stash the position
 */
static void
spacer_applet_real_panel_position_changed (BudgieApplet* base,
                                           BudgiePanelPosition position)
{
	SpacerApplet * self;
	self = (SpacerApplet*) base;
	self->priv->panel_position = position;
	gtk_widget_queue_resize ((GtkWidget*) self);
}

static void
spacer_applet_real_get_preferred_width (GtkWidget* base,
                                        gint* min,
                                        gint* nat)
{
	SpacerApplet * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	gboolean _tmp0_ = FALSE;
	self = (SpacerApplet*) base;
	_vala_min = -1;
	_vala_nat = -1;
	if (self->priv->panel_position == BUDGIE_PANEL_POSITION_TOP) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->panel_position == BUDGIE_PANEL_POSITION_BOTTOM;
	}
	if (_tmp0_) {
		gint _tmp1_;
		_tmp1_ = self->priv->_space_size;
		_vala_nat = _tmp1_;
		_vala_min = _vala_nat;
	}
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}

static void
spacer_applet_real_get_preferred_width_for_height (GtkWidget* base,
                                                   gint h,
                                                   gint* min,
                                                   gint* nat)
{
	SpacerApplet * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	gboolean _tmp0_ = FALSE;
	self = (SpacerApplet*) base;
	_vala_min = -1;
	_vala_nat = -1;
	if (self->priv->panel_position == BUDGIE_PANEL_POSITION_TOP) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->panel_position == BUDGIE_PANEL_POSITION_BOTTOM;
	}
	if (_tmp0_) {
		gint _tmp1_;
		_tmp1_ = self->priv->_space_size;
		_vala_nat = _tmp1_;
		_vala_min = _vala_nat;
	}
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}

static void
spacer_applet_real_get_preferred_height (GtkWidget* base,
                                         gint* min,
                                         gint* nat)
{
	SpacerApplet * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	gboolean _tmp0_ = FALSE;
	self = (SpacerApplet*) base;
	_vala_min = -1;
	_vala_nat = -1;
	if (self->priv->panel_position == BUDGIE_PANEL_POSITION_LEFT) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->panel_position == BUDGIE_PANEL_POSITION_RIGHT;
	}
	if (_tmp0_) {
		gint _tmp1_;
		_tmp1_ = self->priv->_space_size;
		_vala_nat = _tmp1_;
		_vala_min = _vala_nat;
	}
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}

static void
spacer_applet_real_get_preferred_height_for_width (GtkWidget* base,
                                                   gint h,
                                                   gint* min,
                                                   gint* nat)
{
	SpacerApplet * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	gboolean _tmp0_ = FALSE;
	self = (SpacerApplet*) base;
	_vala_min = -1;
	_vala_nat = -1;
	if (self->priv->panel_position == BUDGIE_PANEL_POSITION_LEFT) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->panel_position == BUDGIE_PANEL_POSITION_RIGHT;
	}
	if (_tmp0_) {
		gint _tmp1_;
		_tmp1_ = self->priv->_space_size;
		_vala_nat = _tmp1_;
		_vala_min = _vala_nat;
	}
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}

gint
spacer_applet_get_space_size (SpacerApplet* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_space_size;
	return result;
}

void
spacer_applet_set_space_size (SpacerApplet* self,
                              gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = spacer_applet_get_space_size (self);
	if (old_value != value) {
		self->priv->_space_size = value;
		g_object_notify_by_pspec ((GObject *) self, spacer_applet_properties[SPACER_APPLET_SPACE_SIZE_PROPERTY]);
	}
}

const gchar*
spacer_applet_get_uuid (SpacerApplet* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uuid;
	result = _tmp0_;
	return result;
}

void
spacer_applet_set_uuid (SpacerApplet* self,
                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = spacer_applet_get_uuid (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uuid);
		self->priv->_uuid = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, spacer_applet_properties[SPACER_APPLET_UUID_PROPERTY]);
	}
}

static void
spacer_applet_class_init (SpacerAppletClass * klass,
                          gpointer klass_data)
{
	spacer_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SpacerApplet_private_offset);
	((BudgieAppletClass *) klass)->supports_settings = (gboolean (*) (BudgieApplet*)) spacer_applet_real_supports_settings;
	((BudgieAppletClass *) klass)->get_settings_ui = (GtkWidget* (*) (BudgieApplet*)) spacer_applet_real_get_settings_ui;
	((BudgieAppletClass *) klass)->panel_position_changed = (void (*) (BudgieApplet*, BudgiePanelPosition)) spacer_applet_real_panel_position_changed;
	((GtkWidgetClass *) klass)->get_preferred_width = (void (*) (GtkWidget*, gint*, gint*)) spacer_applet_real_get_preferred_width;
	((GtkWidgetClass *) klass)->get_preferred_width_for_height = (void (*) (GtkWidget*, gint, gint*, gint*)) spacer_applet_real_get_preferred_width_for_height;
	((GtkWidgetClass *) klass)->get_preferred_height = (void (*) (GtkWidget*, gint*, gint*)) spacer_applet_real_get_preferred_height;
	((GtkWidgetClass *) klass)->get_preferred_height_for_width = (void (*) (GtkWidget*, gint, gint*, gint*)) spacer_applet_real_get_preferred_height_for_width;
	G_OBJECT_CLASS (klass)->get_property = _vala_spacer_applet_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_spacer_applet_set_property;
	G_OBJECT_CLASS (klass)->finalize = spacer_applet_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPACER_APPLET_SPACE_SIZE_PROPERTY, spacer_applet_properties[SPACER_APPLET_SPACE_SIZE_PROPERTY] = g_param_spec_int ("space-size", "space-size", "space-size", G_MININT, G_MAXINT, 5, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPACER_APPLET_UUID_PROPERTY, spacer_applet_properties[SPACER_APPLET_UUID_PROPERTY] = g_param_spec_string ("uuid", "uuid", "uuid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
spacer_applet_instance_init (SpacerApplet * self,
                             gpointer klass)
{
	self->priv = spacer_applet_get_instance_private (self);
	self->priv->_space_size = 5;
	self->priv->panel_position = BUDGIE_PANEL_POSITION_BOTTOM;
}

static void
spacer_applet_finalize (GObject * obj)
{
	SpacerApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SPACER_APPLET, SpacerApplet);
	_g_free0 (self->priv->_uuid);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (spacer_applet_parent_class)->finalize (obj);
}

GType
spacer_applet_get_type (void)
{
	return spacer_applet_type_id;
}

GType
spacer_applet_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpacerAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spacer_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpacerApplet), 0, (GInstanceInitFunc) spacer_applet_instance_init, NULL };
	spacer_applet_type_id = g_type_module_register_type (module, budgie_applet_get_type (), "SpacerApplet", &g_define_type_info, 0);
	SpacerApplet_private_offset = sizeof (SpacerAppletPrivate);
	return spacer_applet_type_id;
}

static void
_vala_spacer_applet_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	SpacerApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SPACER_APPLET, SpacerApplet);
	switch (property_id) {
		case SPACER_APPLET_SPACE_SIZE_PROPERTY:
		g_value_set_int (value, spacer_applet_get_space_size (self));
		break;
		case SPACER_APPLET_UUID_PROPERTY:
		g_value_set_string (value, spacer_applet_get_uuid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_spacer_applet_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	SpacerApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SPACER_APPLET, SpacerApplet);
	switch (property_id) {
		case SPACER_APPLET_SPACE_SIZE_PROPERTY:
		spacer_applet_set_space_size (self, g_value_get_int (value));
		break;
		case SPACER_APPLET_UUID_PROPERTY:
		spacer_applet_set_uuid (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	spacer_plugin_register_type (module);
	spacer_settings_register_type (module);
	spacer_applet_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, budgie_plugin_get_type (), TYPE_SPACER_PLUGIN);
	_g_object_unref0 (objmodule);
}

