/* desktop_item.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from desktop_item.vala, do not modify */

/*
Copyright Buddies of Budgie

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <pango/pango.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>

#define ITEM_MARGIN 10
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DESKTOP_ITEM (desktop_item_get_type ())
#define DESKTOP_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DESKTOP_ITEM, DesktopItem))
#define DESKTOP_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DESKTOP_ITEM, DesktopItemClass))
#define IS_DESKTOP_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DESKTOP_ITEM))
#define IS_DESKTOP_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DESKTOP_ITEM))
#define DESKTOP_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DESKTOP_ITEM, DesktopItemClass))

typedef struct _DesktopItem DesktopItem;
typedef struct _DesktopItemClass DesktopItemClass;
typedef struct _DesktopItemPrivate DesktopItemPrivate;

#define TYPE_UNIFIED_PROPS (unified_props_get_type ())
#define UNIFIED_PROPS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNIFIED_PROPS, UnifiedProps))
#define UNIFIED_PROPS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNIFIED_PROPS, UnifiedPropsClass))
#define IS_UNIFIED_PROPS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNIFIED_PROPS))
#define IS_UNIFIED_PROPS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNIFIED_PROPS))
#define UNIFIED_PROPS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNIFIED_PROPS, UnifiedPropsClass))

typedef struct _UnifiedProps UnifiedProps;
typedef struct _UnifiedPropsClass UnifiedPropsClass;
enum  {
	DESKTOP_ITEM_0_PROPERTY,
	DESKTOP_ITEM_IS_COPYING_PROPERTY,
	DESKTOP_ITEM_IS_MOUNT_PROPERTY,
	DESKTOP_ITEM_IS_SPECIAL_PROPERTY,
	DESKTOP_ITEM_ITEM_TYPE_PROPERTY,
	DESKTOP_ITEM_LABEL_NAME_PROPERTY,
	DESKTOP_ITEM_NUM_PROPERTIES
};
static GParamSpec* desktop_item_properties[DESKTOP_ITEM_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _UnifiedPropsPrivate UnifiedPropsPrivate;

#define TYPE_FILE_MENU (file_menu_get_type ())
#define FILE_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_MENU, FileMenu))
#define FILE_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_MENU, FileMenuClass))
#define IS_FILE_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_MENU))
#define IS_FILE_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_MENU))
#define FILE_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_MENU, FileMenuClass))

typedef struct _FileMenu FileMenu;
typedef struct _FileMenuClass FileMenuClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _DesktopItem {
	GtkFlowBoxChild parent_instance;
	DesktopItemPrivate * priv;
	UnifiedProps* props;
	gint _label_width;
	gboolean _copying;
	gboolean _mount;
	gchar* _name;
	gchar* _type;
	gboolean _special_dir;
	GtkImage* image;
	GtkLabel* label;
	GtkEventBox* event_box;
	GtkBox* main_layout;
	GdkPixbuf* original_image_pixbuf;
	GIcon* icon;
};

struct _DesktopItemClass {
	GtkFlowBoxChildClass parent_class;
};

struct _UnifiedProps {
	GObject parent_instance;
	UnifiedPropsPrivate * priv;
	GHashTable* files_currently_copying;
	gboolean is_launching;
	GdkCursor* blocked_cursor;
	GdkCursor* hand_cursor;
	GdkCursor* loading_cursor;
	GdkAppLaunchContext* launch_context;
	FileMenu* file_menu;
	GtkIconTheme* icon_theme;
	gint* icon_size;
	guint* s_factor;
};

struct _UnifiedPropsClass {
	GObjectClass parent_class;
};

static gpointer desktop_item_parent_class = NULL;

VALA_EXTERN GType desktop_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DesktopItem, g_object_unref)
VALA_EXTERN GType unified_props_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UnifiedProps, g_object_unref)
VALA_EXTERN DesktopItem* desktop_item_new (void);
VALA_EXTERN DesktopItem* desktop_item_construct (GType object_type);
static gboolean desktop_item_on_enter (DesktopItem* self,
                                GdkEventCrossing* event);
static gboolean _desktop_item_on_enter_gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                               GdkEventCrossing* event,
                                                               gpointer self);
static gboolean desktop_item_on_leave (DesktopItem* self,
                                GdkEventCrossing* event);
static gboolean _desktop_item_on_leave_gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                               GdkEventCrossing* event,
                                                               gpointer self);
VALA_EXTERN GType file_menu_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FileMenu, g_object_unref)
VALA_EXTERN void unified_props_set_current_cursor (UnifiedProps* self,
                                       GdkCursor* value);
VALA_EXTERN void desktop_item_request_show (DesktopItem* self);
VALA_EXTERN void desktop_item_saturate_image (DesktopItem* self,
                                  gfloat val);
VALA_EXTERN void desktop_item_set_icon (DesktopItem* self,
                            GIcon* ico,
                            GError** error);
VALA_EXTERN void desktop_item_set_icon_from_iconinfo (DesktopItem* self,
                                          GtkIconInfo* icon_info,
                                          GError** error);
VALA_EXTERN void desktop_item_set_icon_from_name (DesktopItem* self,
                                      const gchar* icon_name,
                                      GError** error);
VALA_EXTERN void desktop_item_set_image_pixbuf (DesktopItem* self,
                                    GdkPixbuf* pix);
VALA_EXTERN void desktop_item_set_icon_factors (DesktopItem* self,
                                    GError** error);
static gboolean _int_equal (const gint * s1,
                     const gint * s2);
VALA_EXTERN gboolean desktop_item_get_is_copying (DesktopItem* self);
VALA_EXTERN void desktop_item_set_is_copying (DesktopItem* self,
                                  gboolean value);
VALA_EXTERN gboolean desktop_item_get_is_mount (DesktopItem* self);
VALA_EXTERN void desktop_item_set_is_mount (DesktopItem* self,
                                gboolean value);
VALA_EXTERN gboolean desktop_item_get_is_special (DesktopItem* self);
VALA_EXTERN void desktop_item_set_is_special (DesktopItem* self,
                                  gboolean value);
VALA_EXTERN const gchar* desktop_item_get_item_type (DesktopItem* self);
VALA_EXTERN const gchar* desktop_item_get_label_name (DesktopItem* self);
VALA_EXTERN void desktop_item_set_label_name (DesktopItem* self,
                                  const gchar* value);
static void desktop_item_finalize (GObject * obj);
static GType desktop_item_get_type_once (void);
static void _vala_desktop_item_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_desktop_item_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);

static gboolean
_desktop_item_on_enter_gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                      GdkEventCrossing* event,
                                                      gpointer self)
{
	gboolean result;
	result = desktop_item_on_enter ((DesktopItem*) self, event);
	return result;
}

static gboolean
_desktop_item_on_leave_gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                      GdkEventCrossing* event,
                                                      gpointer self)
{
	gboolean result;
	result = desktop_item_on_leave ((DesktopItem*) self, event);
	return result;
}

DesktopItem*
desktop_item_construct (GType object_type)
{
	DesktopItem * self = NULL;
	GtkStyleContext* _tmp0_;
	GtkEventBox* _tmp1_;
	GtkBox* _tmp2_;
	GtkBox* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkBox* _tmp12_;
	GtkLabel* _tmp13_;
	GtkEventBox* _tmp14_;
	GtkBox* _tmp15_;
	GtkEventBox* _tmp16_;
	GtkEventBox* _tmp17_;
	GtkEventBox* _tmp18_;
	GtkEventBox* _tmp19_;
	self = (DesktopItem*) g_object_new (object_type, NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "desktop-item");
	g_object_set ((GtkWidget*) self, "expand", TRUE, NULL);
	g_object_set ((GtkWidget*) self, "margin", ITEM_MARGIN, NULL);
	gtk_widget_set_no_show_all ((GtkWidget*) self, TRUE);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	self->_copying = FALSE;
	self->_special_dir = FALSE;
	_tmp1_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->event_box);
	self->event_box = _tmp1_;
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->main_layout);
	self->main_layout = _tmp2_;
	_tmp3_ = self->main_layout;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, TRUE);
	_tmp4_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->label);
	self->label = _tmp4_;
	_tmp5_ = self->label;
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
	gtk_style_context_add_class (_tmp6_, "desktop-item-label");
	_tmp7_ = self->label;
	gtk_label_set_ellipsize (_tmp7_, PANGO_ELLIPSIZE_END);
	_tmp8_ = self->label;
	gtk_label_set_justify (_tmp8_, GTK_JUSTIFY_CENTER);
	_tmp9_ = self->label;
	gtk_label_set_lines (_tmp9_, 2);
	_tmp10_ = self->label;
	g_object_set (_tmp10_, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
	_tmp11_ = self->label;
	g_object_set (_tmp11_, "wrap", TRUE, NULL);
	_tmp12_ = self->main_layout;
	_tmp13_ = self->label;
	gtk_box_pack_end (_tmp12_, (GtkWidget*) _tmp13_, TRUE, TRUE, (guint) 0);
	_tmp14_ = self->event_box;
	_tmp15_ = self->main_layout;
	gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = self->event_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp16_);
	_tmp17_ = self->event_box;
	gtk_widget_set_events ((GtkWidget*) _tmp17_, (gint) ((GDK_BUTTON_PRESS_MASK & GDK_ENTER_NOTIFY_MASK) & GDK_LEAVE_NOTIFY_MASK));
	_tmp18_ = self->event_box;
	g_signal_connect_object ((GtkWidget*) _tmp18_, "enter-notify-event", (GCallback) _desktop_item_on_enter_gtk_widget_enter_notify_event, self, 0);
	_tmp19_ = self->event_box;
	g_signal_connect_object ((GtkWidget*) _tmp19_, "leave-notify-event", (GCallback) _desktop_item_on_leave_gtk_widget_leave_notify_event, self, 0);
	return self;
}

DesktopItem*
desktop_item_new (void)
{
	return desktop_item_construct (TYPE_DESKTOP_ITEM);
}

static gboolean
desktop_item_on_enter (DesktopItem* self,
                       GdkEventCrossing* event)
{
	GtkStyleContext* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->mode != GDK_CROSSING_NORMAL) {
		result = GDK_EVENT_STOP;
		return result;
	}
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "selected");
	if (self->_copying) {
		UnifiedProps* _tmp1_;
		UnifiedProps* _tmp2_;
		GdkCursor* _tmp3_;
		_tmp1_ = self->props;
		_tmp2_ = self->props;
		_tmp3_ = _tmp2_->blocked_cursor;
		unified_props_set_current_cursor (_tmp1_, _tmp3_);
	}
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
desktop_item_on_leave (DesktopItem* self,
                       GdkEventCrossing* event)
{
	GtkStyleContext* _tmp0_;
	UnifiedProps* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->mode != GDK_CROSSING_NORMAL) {
		result = GDK_EVENT_STOP;
		return result;
	}
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_remove_class (_tmp0_, "selected");
	_tmp1_ = self->props;
	if (!_tmp1_->is_launching) {
		UnifiedProps* _tmp2_;
		UnifiedProps* _tmp3_;
		GdkCursor* _tmp4_;
		_tmp2_ = self->props;
		_tmp3_ = self->props;
		_tmp4_ = _tmp3_->hand_cursor;
		unified_props_set_current_cursor (_tmp2_, _tmp4_);
	}
	result = GDK_EVENT_STOP;
	return result;
}

void
desktop_item_request_show (DesktopItem* self)
{
	GtkBox* _tmp0_;
	GtkEventBox* _tmp1_;
	GtkImage* _tmp2_;
	GtkLabel* _tmp4_;
	g_return_if_fail (self != NULL);
	gtk_widget_show ((GtkWidget*) self);
	_tmp0_ = self->main_layout;
	gtk_widget_show ((GtkWidget*) _tmp0_);
	_tmp1_ = self->event_box;
	gtk_widget_show ((GtkWidget*) _tmp1_);
	_tmp2_ = self->image;
	if (_tmp2_ != NULL) {
		GtkImage* _tmp3_;
		_tmp3_ = self->image;
		gtk_widget_show ((GtkWidget*) _tmp3_);
	}
	_tmp4_ = self->label;
	if (_tmp4_ != NULL) {
		GtkLabel* _tmp5_;
		_tmp5_ = self->label;
		gtk_widget_show ((GtkWidget*) _tmp5_);
	}
}

void
desktop_item_saturate_image (DesktopItem* self,
                             gfloat val)
{
	GtkImage* _tmp0_;
	GdkPixbuf* saturated_pixbuf = NULL;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	GtkImage* _tmp5_;
	GdkPixbuf* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->image;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->original_image_pixbuf;
	_tmp2_ = gdk_pixbuf_copy (_tmp1_);
	saturated_pixbuf = _tmp2_;
	_tmp3_ = self->original_image_pixbuf;
	_tmp4_ = saturated_pixbuf;
	gdk_pixbuf_saturate_and_pixelate (_tmp3_, _tmp4_, val, FALSE);
	_tmp5_ = self->image;
	_tmp6_ = saturated_pixbuf;
	gtk_image_set_from_pixbuf (_tmp5_, _tmp6_);
	_g_object_unref0 (saturated_pixbuf);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
desktop_item_set_icon (DesktopItem* self,
                       GIcon* ico,
                       GError** error)
{
	GIcon* _tmp0_;
	GtkIconInfo* icon_info = NULL;
	UnifiedProps* _tmp1_;
	GtkIconTheme* _tmp2_;
	GIcon* _tmp3_;
	UnifiedProps* _tmp4_;
	gint* _tmp5_;
	UnifiedProps* _tmp6_;
	guint* _tmp7_;
	GtkIconInfo* _tmp8_;
	GtkIconInfo* _tmp9_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ico != NULL);
	if (ico == NULL) {
		return;
	}
	_tmp0_ = _g_object_ref0 (ico);
	_g_object_unref0 (self->icon);
	self->icon = _tmp0_;
	_tmp1_ = self->props;
	_tmp2_ = _tmp1_->icon_theme;
	_tmp3_ = self->icon;
	_tmp4_ = self->props;
	_tmp5_ = _tmp4_->icon_size;
	_tmp6_ = self->props;
	_tmp7_ = _tmp6_->s_factor;
	_tmp8_ = gtk_icon_theme_lookup_by_gicon_for_scale (_tmp2_, _tmp3_, *_tmp5_, (gint) (*_tmp7_), GTK_ICON_LOOKUP_USE_BUILTIN & GTK_ICON_LOOKUP_GENERIC_FALLBACK);
	icon_info = _tmp8_;
	_tmp9_ = icon_info;
	desktop_item_set_icon_from_iconinfo (self, _tmp9_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (icon_info);
		return;
	}
	_g_object_unref0 (icon_info);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

void
desktop_item_set_icon_from_name (DesktopItem* self,
                                 const gchar* icon_name,
                                 GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_name != NULL);
	{
		GdkPixbuf* pix = NULL;
		UnifiedProps* _tmp0_;
		GtkIconTheme* _tmp1_;
		UnifiedProps* _tmp2_;
		gint* _tmp3_;
		UnifiedProps* _tmp4_;
		guint* _tmp5_;
		GdkPixbuf* _tmp6_;
		GdkPixbuf* _tmp7_;
		_tmp0_ = self->props;
		_tmp1_ = _tmp0_->icon_theme;
		_tmp2_ = self->props;
		_tmp3_ = _tmp2_->icon_size;
		_tmp4_ = self->props;
		_tmp5_ = _tmp4_->s_factor;
		_tmp6_ = gtk_icon_theme_load_icon_for_scale (_tmp1_, icon_name, *_tmp3_, (gint) (*_tmp5_), GTK_ICON_LOOKUP_GENERIC_FALLBACK, &_inner_error0_);
		pix = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = pix;
		desktop_item_set_image_pixbuf (self, _tmp7_);
		_g_object_unref0 (pix);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		GError* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _g_error_copy0 (_tmp8_);
		_inner_error0_ = _tmp9_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

void
desktop_item_set_icon_from_iconinfo (DesktopItem* self,
                                     GtkIconInfo* icon_info,
                                     GError** error)
{
	GdkPixbuf* pix = NULL;
	GdkPixbuf* _tmp8_;
	UnifiedProps* _tmp9_;
	gint* _tmp10_;
	GdkPixbuf* _tmp17_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (icon_info == NULL) {
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		GError* _tmp2_;
		_tmp0_ = gtk_widget_get_name ((GtkWidget*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_error_new (GTK_ICON_THEME_ERROR, GTK_ICON_THEME_FAILED, "Failed to load icon for: %s\n", _tmp1_);
		_inner_error0_ = _tmp2_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	pix = NULL;
	{
		GdkPixbuf* _tmp3_ = NULL;
		GdkPixbuf* _tmp4_;
		GdkPixbuf* _tmp5_;
		_tmp4_ = gtk_icon_info_load_icon (icon_info, &_inner_error0_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		_g_object_unref0 (pix);
		pix = _tmp5_;
		_g_object_unref0 (_tmp3_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		GError* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _g_error_copy0 (_tmp6_);
		_inner_error0_ = _tmp7_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (pix);
		return;
	}
	_tmp8_ = pix;
	_tmp9_ = self->props;
	_tmp10_ = _tmp9_->icon_size;
	if (gdk_pixbuf_get_width (_tmp8_) > (*_tmp10_)) {
		GdkPixbuf* _tmp11_;
		UnifiedProps* _tmp12_;
		gint* _tmp13_;
		UnifiedProps* _tmp14_;
		gint* _tmp15_;
		GdkPixbuf* _tmp16_;
		_tmp11_ = pix;
		_tmp12_ = self->props;
		_tmp13_ = _tmp12_->icon_size;
		_tmp14_ = self->props;
		_tmp15_ = _tmp14_->icon_size;
		_tmp16_ = gdk_pixbuf_scale_simple (_tmp11_, *_tmp13_, *_tmp15_, GDK_INTERP_BILINEAR);
		_g_object_unref0 (pix);
		pix = _tmp16_;
	}
	_tmp17_ = pix;
	desktop_item_set_image_pixbuf (self, _tmp17_);
	_g_object_unref0 (pix);
}

static gboolean
_int_equal (const gint * s1,
            const gint * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

void
desktop_item_set_icon_factors (DesktopItem* self,
                               GError** error)
{
	UnifiedProps* _tmp0_;
	gint* _tmp1_;
	GIcon* _tmp18_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->props;
	_tmp1_ = _tmp0_->icon_size;
	if (_tmp1_ != NULL) {
		UnifiedProps* _tmp2_;
		gint* _tmp3_;
		GtkLabel* _tmp16_;
		GtkLabel* _tmp17_;
		_tmp2_ = self->props;
		_tmp3_ = _tmp2_->icon_size;
		if ((*_tmp3_) <= 48) {
			GtkLabel* _tmp4_;
			GtkStyleContext* _tmp5_;
			self->_label_width = 12;
			_tmp4_ = self->label;
			_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
			gtk_style_context_remove_class (_tmp5_, "larger-text");
		} else {
			UnifiedProps* _tmp6_;
			gint* _tmp7_;
			gint _tmp8_;
			_tmp6_ = self->props;
			_tmp7_ = _tmp6_->icon_size;
			_tmp8_ = 64;
			if (_int_equal (_tmp7_, &_tmp8_) == TRUE) {
				GtkLabel* _tmp9_;
				GtkStyleContext* _tmp10_;
				self->_label_width = 18;
				_tmp9_ = self->label;
				_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) _tmp9_);
				gtk_style_context_add_class (_tmp10_, "larger-text");
			} else {
				UnifiedProps* _tmp11_;
				gint* _tmp12_;
				gint _tmp13_;
				_tmp11_ = self->props;
				_tmp12_ = _tmp11_->icon_size;
				_tmp13_ = 96;
				if (_int_equal (_tmp12_, &_tmp13_) == TRUE) {
					GtkLabel* _tmp14_;
					GtkStyleContext* _tmp15_;
					self->_label_width = 20;
					_tmp14_ = self->label;
					_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) _tmp14_);
					gtk_style_context_add_class (_tmp15_, "larger-text");
				}
			}
		}
		_tmp16_ = self->label;
		gtk_label_set_max_width_chars (_tmp16_, self->_label_width);
		_tmp17_ = self->label;
		gtk_label_set_width_chars (_tmp17_, self->_label_width);
	}
	_tmp18_ = self->icon;
	if (_tmp18_ != NULL) {
		{
			GIcon* _tmp19_;
			_tmp19_ = self->icon;
			desktop_item_set_icon (self, _tmp19_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp20_;
			const gchar* _tmp21_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp20_ = e;
			_tmp21_ = _tmp20_->message;
			g_warning ("desktop_item.vala:247: Failed to set icon: %s", _tmp21_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
	}
}

void
desktop_item_set_image_pixbuf (DesktopItem* self,
                               GdkPixbuf* pix)
{
	GdkPixbuf* _tmp0_;
	GtkImage* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pix != NULL);
	_tmp0_ = _g_object_ref0 (pix);
	_g_object_unref0 (self->original_image_pixbuf);
	self->original_image_pixbuf = _tmp0_;
	_tmp1_ = self->image;
	if (_tmp1_ == NULL) {
		GtkImage* _tmp2_;
		GtkImage* _tmp3_;
		GtkStyleContext* _tmp4_;
		GtkImage* _tmp5_;
		GtkBox* _tmp6_;
		GtkImage* _tmp7_;
		_tmp2_ = (GtkImage*) gtk_image_new_from_pixbuf (pix);
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (self->image);
		self->image = _tmp2_;
		_tmp3_ = self->image;
		_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
		gtk_style_context_add_class (_tmp4_, "desktop-item-image");
		_tmp5_ = self->image;
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp5_, 10);
		_tmp6_ = self->main_layout;
		_tmp7_ = self->image;
		gtk_box_pack_start (_tmp6_, (GtkWidget*) _tmp7_, TRUE, TRUE, (guint) 0);
	} else {
		GtkImage* _tmp8_;
		_tmp8_ = self->image;
		gtk_image_set_from_pixbuf (_tmp8_, pix);
	}
}

gboolean
desktop_item_get_is_copying (DesktopItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->_copying;
	return result;
}

void
desktop_item_set_is_copying (DesktopItem* self,
                             gboolean value)
{
	gfloat _tmp0_ = 0.0F;
	g_return_if_fail (self != NULL);
	self->_copying = value;
	gtk_widget_set_has_tooltip ((GtkWidget*) self, value);
	if (self->_copying) {
		_tmp0_ = (gfloat) 0.5;
	} else {
		_tmp0_ = (gfloat) 1.0;
	}
	desktop_item_saturate_image (self, _tmp0_);
	if (self->_copying) {
		GtkLabel* _tmp1_;
		GtkStyleContext* _tmp2_;
		_tmp1_ = self->label;
		_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
		gtk_style_context_add_class (_tmp2_, "is-disabled");
		gtk_widget_set_tooltip_text ((GtkWidget*) self, _ ("File currently copying"));
	} else {
		GtkLabel* _tmp3_;
		GtkStyleContext* _tmp4_;
		_tmp3_ = self->label;
		_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
		gtk_style_context_remove_class (_tmp4_, "is-disabled");
		gtk_widget_set_tooltip_text ((GtkWidget*) self, "");
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, desktop_item_properties[DESKTOP_ITEM_IS_COPYING_PROPERTY]);
}

gboolean
desktop_item_get_is_mount (DesktopItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->_mount;
	return result;
}

void
desktop_item_set_is_mount (DesktopItem* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->_mount = value;
	g_object_notify_by_pspec ((GObject *) self, desktop_item_properties[DESKTOP_ITEM_IS_MOUNT_PROPERTY]);
}

gboolean
desktop_item_get_is_special (DesktopItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->_special_dir;
	return result;
}

void
desktop_item_set_is_special (DesktopItem* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->_special_dir = value;
	g_object_notify_by_pspec ((GObject *) self, desktop_item_properties[DESKTOP_ITEM_IS_SPECIAL_PROPERTY]);
}

const gchar*
desktop_item_get_item_type (DesktopItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->_type;
	result = _tmp0_;
	return result;
}

const gchar*
desktop_item_get_label_name (DesktopItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->_name;
	result = _tmp0_;
	return result;
}

void
desktop_item_set_label_name (DesktopItem* self,
                             const gchar* value)
{
	gchar* _tmp0_;
	GtkLabel* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->_name);
	self->_name = _tmp0_;
	_tmp1_ = self->label;
	gtk_label_set_text (_tmp1_, value);
	g_object_notify_by_pspec ((GObject *) self, desktop_item_properties[DESKTOP_ITEM_LABEL_NAME_PROPERTY]);
}

static void
desktop_item_class_init (DesktopItemClass * klass,
                         gpointer klass_data)
{
	desktop_item_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_desktop_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_desktop_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = desktop_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_ITEM_IS_COPYING_PROPERTY, desktop_item_properties[DESKTOP_ITEM_IS_COPYING_PROPERTY] = g_param_spec_boolean ("is-copying", "is-copying", "is-copying", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_ITEM_IS_MOUNT_PROPERTY, desktop_item_properties[DESKTOP_ITEM_IS_MOUNT_PROPERTY] = g_param_spec_boolean ("is-mount", "is-mount", "is-mount", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_ITEM_IS_SPECIAL_PROPERTY, desktop_item_properties[DESKTOP_ITEM_IS_SPECIAL_PROPERTY] = g_param_spec_boolean ("is-special", "is-special", "is-special", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_ITEM_ITEM_TYPE_PROPERTY, desktop_item_properties[DESKTOP_ITEM_ITEM_TYPE_PROPERTY] = g_param_spec_string ("item-type", "item-type", "item-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_ITEM_LABEL_NAME_PROPERTY, desktop_item_properties[DESKTOP_ITEM_LABEL_NAME_PROPERTY] = g_param_spec_string ("label-name", "label-name", "label-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
desktop_item_instance_init (DesktopItem * self,
                            gpointer klass)
{
}

static void
desktop_item_finalize (GObject * obj)
{
	DesktopItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DESKTOP_ITEM, DesktopItem);
	_g_free0 (self->_name);
	_g_free0 (self->_type);
	_g_object_unref0 (self->image);
	_g_object_unref0 (self->label);
	_g_object_unref0 (self->event_box);
	_g_object_unref0 (self->main_layout);
	_g_object_unref0 (self->original_image_pixbuf);
	_g_object_unref0 (self->icon);
	G_OBJECT_CLASS (desktop_item_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
desktop_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DesktopItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopItem), 0, (GInstanceInitFunc) desktop_item_instance_init, NULL };
	GType desktop_item_type_id;
	desktop_item_type_id = g_type_register_static (gtk_flow_box_child_get_type (), "DesktopItem", &g_define_type_info, 0);
	return desktop_item_type_id;
}

GType
desktop_item_get_type (void)
{
	static volatile gsize desktop_item_type_id__once = 0;
	if (g_once_init_enter (&desktop_item_type_id__once)) {
		GType desktop_item_type_id;
		desktop_item_type_id = desktop_item_get_type_once ();
		g_once_init_leave (&desktop_item_type_id__once, desktop_item_type_id);
	}
	return desktop_item_type_id__once;
}

static void
_vala_desktop_item_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	DesktopItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DESKTOP_ITEM, DesktopItem);
	switch (property_id) {
		case DESKTOP_ITEM_IS_COPYING_PROPERTY:
		g_value_set_boolean (value, desktop_item_get_is_copying (self));
		break;
		case DESKTOP_ITEM_IS_MOUNT_PROPERTY:
		g_value_set_boolean (value, desktop_item_get_is_mount (self));
		break;
		case DESKTOP_ITEM_IS_SPECIAL_PROPERTY:
		g_value_set_boolean (value, desktop_item_get_is_special (self));
		break;
		case DESKTOP_ITEM_ITEM_TYPE_PROPERTY:
		g_value_set_string (value, desktop_item_get_item_type (self));
		break;
		case DESKTOP_ITEM_LABEL_NAME_PROPERTY:
		g_value_set_string (value, desktop_item_get_label_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_desktop_item_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	DesktopItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DESKTOP_ITEM, DesktopItem);
	switch (property_id) {
		case DESKTOP_ITEM_IS_COPYING_PROPERTY:
		desktop_item_set_is_copying (self, g_value_get_boolean (value));
		break;
		case DESKTOP_ITEM_IS_MOUNT_PROPERTY:
		desktop_item_set_is_mount (self, g_value_get_boolean (value));
		break;
		case DESKTOP_ITEM_IS_SPECIAL_PROPERTY:
		desktop_item_set_is_special (self, g_value_get_boolean (value));
		break;
		case DESKTOP_ITEM_LABEL_NAME_PROPERTY:
		desktop_item_set_label_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

