// Code generated by smithy-go-codegen DO NOT EDIT.

package autoscaling

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/aws/protocol/query"
	"github.com/aws/aws-sdk-go-v2/service/autoscaling/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
	"path"
)

type awsAwsquery_serializeOpAttachInstances struct {
}

func (*awsAwsquery_serializeOpAttachInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpAttachInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AttachInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AttachInstances")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentAttachInstancesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpAttachLoadBalancers struct {
}

func (*awsAwsquery_serializeOpAttachLoadBalancers) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpAttachLoadBalancers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AttachLoadBalancersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AttachLoadBalancers")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentAttachLoadBalancersInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpAttachLoadBalancerTargetGroups struct {
}

func (*awsAwsquery_serializeOpAttachLoadBalancerTargetGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpAttachLoadBalancerTargetGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AttachLoadBalancerTargetGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AttachLoadBalancerTargetGroups")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentAttachLoadBalancerTargetGroupsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpAttachTrafficSources struct {
}

func (*awsAwsquery_serializeOpAttachTrafficSources) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpAttachTrafficSources) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AttachTrafficSourcesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AttachTrafficSources")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentAttachTrafficSourcesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpBatchDeleteScheduledAction struct {
}

func (*awsAwsquery_serializeOpBatchDeleteScheduledAction) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpBatchDeleteScheduledAction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchDeleteScheduledActionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("BatchDeleteScheduledAction")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentBatchDeleteScheduledActionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpBatchPutScheduledUpdateGroupAction struct {
}

func (*awsAwsquery_serializeOpBatchPutScheduledUpdateGroupAction) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpBatchPutScheduledUpdateGroupAction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchPutScheduledUpdateGroupActionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("BatchPutScheduledUpdateGroupAction")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentBatchPutScheduledUpdateGroupActionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCancelInstanceRefresh struct {
}

func (*awsAwsquery_serializeOpCancelInstanceRefresh) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCancelInstanceRefresh) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelInstanceRefreshInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CancelInstanceRefresh")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentCancelInstanceRefreshInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCompleteLifecycleAction struct {
}

func (*awsAwsquery_serializeOpCompleteLifecycleAction) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCompleteLifecycleAction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CompleteLifecycleActionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CompleteLifecycleAction")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentCompleteLifecycleActionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateAutoScalingGroup struct {
}

func (*awsAwsquery_serializeOpCreateAutoScalingGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateAutoScalingGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateAutoScalingGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateAutoScalingGroup")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentCreateAutoScalingGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateLaunchConfiguration struct {
}

func (*awsAwsquery_serializeOpCreateLaunchConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateLaunchConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateLaunchConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateLaunchConfiguration")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentCreateLaunchConfigurationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateOrUpdateTags struct {
}

func (*awsAwsquery_serializeOpCreateOrUpdateTags) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateOrUpdateTags) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateOrUpdateTagsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateOrUpdateTags")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentCreateOrUpdateTagsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteAutoScalingGroup struct {
}

func (*awsAwsquery_serializeOpDeleteAutoScalingGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteAutoScalingGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAutoScalingGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteAutoScalingGroup")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentDeleteAutoScalingGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteLaunchConfiguration struct {
}

func (*awsAwsquery_serializeOpDeleteLaunchConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteLaunchConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteLaunchConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteLaunchConfiguration")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentDeleteLaunchConfigurationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteLifecycleHook struct {
}

func (*awsAwsquery_serializeOpDeleteLifecycleHook) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteLifecycleHook) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteLifecycleHookInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteLifecycleHook")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentDeleteLifecycleHookInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteNotificationConfiguration struct {
}

func (*awsAwsquery_serializeOpDeleteNotificationConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteNotificationConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteNotificationConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteNotificationConfiguration")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentDeleteNotificationConfigurationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeletePolicy struct {
}

func (*awsAwsquery_serializeOpDeletePolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeletePolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeletePolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeletePolicy")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentDeletePolicyInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteScheduledAction struct {
}

func (*awsAwsquery_serializeOpDeleteScheduledAction) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteScheduledAction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteScheduledActionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteScheduledAction")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentDeleteScheduledActionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteTags struct {
}

func (*awsAwsquery_serializeOpDeleteTags) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteTags) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTagsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteTags")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentDeleteTagsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteWarmPool struct {
}

func (*awsAwsquery_serializeOpDeleteWarmPool) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteWarmPool) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteWarmPoolInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteWarmPool")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentDeleteWarmPoolInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeAccountLimits struct {
}

func (*awsAwsquery_serializeOpDescribeAccountLimits) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeAccountLimits) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAccountLimitsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeAccountLimits")
	body.Key("Version").String("2011-01-01")

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeAdjustmentTypes struct {
}

func (*awsAwsquery_serializeOpDescribeAdjustmentTypes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeAdjustmentTypes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAdjustmentTypesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeAdjustmentTypes")
	body.Key("Version").String("2011-01-01")

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeAutoScalingGroups struct {
}

func (*awsAwsquery_serializeOpDescribeAutoScalingGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeAutoScalingGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAutoScalingGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeAutoScalingGroups")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentDescribeAutoScalingGroupsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeAutoScalingInstances struct {
}

func (*awsAwsquery_serializeOpDescribeAutoScalingInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeAutoScalingInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAutoScalingInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeAutoScalingInstances")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentDescribeAutoScalingInstancesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeAutoScalingNotificationTypes struct {
}

func (*awsAwsquery_serializeOpDescribeAutoScalingNotificationTypes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeAutoScalingNotificationTypes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAutoScalingNotificationTypesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeAutoScalingNotificationTypes")
	body.Key("Version").String("2011-01-01")

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeInstanceRefreshes struct {
}

func (*awsAwsquery_serializeOpDescribeInstanceRefreshes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeInstanceRefreshes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeInstanceRefreshesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeInstanceRefreshes")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentDescribeInstanceRefreshesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeLaunchConfigurations struct {
}

func (*awsAwsquery_serializeOpDescribeLaunchConfigurations) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeLaunchConfigurations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeLaunchConfigurationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeLaunchConfigurations")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentDescribeLaunchConfigurationsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeLifecycleHooks struct {
}

func (*awsAwsquery_serializeOpDescribeLifecycleHooks) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeLifecycleHooks) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeLifecycleHooksInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeLifecycleHooks")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentDescribeLifecycleHooksInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeLifecycleHookTypes struct {
}

func (*awsAwsquery_serializeOpDescribeLifecycleHookTypes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeLifecycleHookTypes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeLifecycleHookTypesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeLifecycleHookTypes")
	body.Key("Version").String("2011-01-01")

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeLoadBalancers struct {
}

func (*awsAwsquery_serializeOpDescribeLoadBalancers) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeLoadBalancers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeLoadBalancersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeLoadBalancers")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentDescribeLoadBalancersInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeLoadBalancerTargetGroups struct {
}

func (*awsAwsquery_serializeOpDescribeLoadBalancerTargetGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeLoadBalancerTargetGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeLoadBalancerTargetGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeLoadBalancerTargetGroups")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentDescribeLoadBalancerTargetGroupsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeMetricCollectionTypes struct {
}

func (*awsAwsquery_serializeOpDescribeMetricCollectionTypes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeMetricCollectionTypes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeMetricCollectionTypesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeMetricCollectionTypes")
	body.Key("Version").String("2011-01-01")

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeNotificationConfigurations struct {
}

func (*awsAwsquery_serializeOpDescribeNotificationConfigurations) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeNotificationConfigurations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeNotificationConfigurationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeNotificationConfigurations")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentDescribeNotificationConfigurationsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribePolicies struct {
}

func (*awsAwsquery_serializeOpDescribePolicies) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribePolicies) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribePoliciesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribePolicies")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentDescribePoliciesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeScalingActivities struct {
}

func (*awsAwsquery_serializeOpDescribeScalingActivities) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeScalingActivities) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeScalingActivitiesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeScalingActivities")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentDescribeScalingActivitiesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeScalingProcessTypes struct {
}

func (*awsAwsquery_serializeOpDescribeScalingProcessTypes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeScalingProcessTypes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeScalingProcessTypesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeScalingProcessTypes")
	body.Key("Version").String("2011-01-01")

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeScheduledActions struct {
}

func (*awsAwsquery_serializeOpDescribeScheduledActions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeScheduledActions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeScheduledActionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeScheduledActions")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentDescribeScheduledActionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeTags struct {
}

func (*awsAwsquery_serializeOpDescribeTags) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeTags) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTagsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeTags")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentDescribeTagsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeTerminationPolicyTypes struct {
}

func (*awsAwsquery_serializeOpDescribeTerminationPolicyTypes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeTerminationPolicyTypes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTerminationPolicyTypesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeTerminationPolicyTypes")
	body.Key("Version").String("2011-01-01")

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeTrafficSources struct {
}

func (*awsAwsquery_serializeOpDescribeTrafficSources) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeTrafficSources) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTrafficSourcesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeTrafficSources")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentDescribeTrafficSourcesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeWarmPool struct {
}

func (*awsAwsquery_serializeOpDescribeWarmPool) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeWarmPool) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeWarmPoolInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeWarmPool")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentDescribeWarmPoolInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDetachInstances struct {
}

func (*awsAwsquery_serializeOpDetachInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDetachInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DetachInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DetachInstances")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentDetachInstancesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDetachLoadBalancers struct {
}

func (*awsAwsquery_serializeOpDetachLoadBalancers) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDetachLoadBalancers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DetachLoadBalancersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DetachLoadBalancers")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentDetachLoadBalancersInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDetachLoadBalancerTargetGroups struct {
}

func (*awsAwsquery_serializeOpDetachLoadBalancerTargetGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDetachLoadBalancerTargetGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DetachLoadBalancerTargetGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DetachLoadBalancerTargetGroups")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentDetachLoadBalancerTargetGroupsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDetachTrafficSources struct {
}

func (*awsAwsquery_serializeOpDetachTrafficSources) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDetachTrafficSources) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DetachTrafficSourcesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DetachTrafficSources")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentDetachTrafficSourcesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDisableMetricsCollection struct {
}

func (*awsAwsquery_serializeOpDisableMetricsCollection) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDisableMetricsCollection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisableMetricsCollectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DisableMetricsCollection")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentDisableMetricsCollectionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpEnableMetricsCollection struct {
}

func (*awsAwsquery_serializeOpEnableMetricsCollection) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpEnableMetricsCollection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*EnableMetricsCollectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("EnableMetricsCollection")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentEnableMetricsCollectionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpEnterStandby struct {
}

func (*awsAwsquery_serializeOpEnterStandby) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpEnterStandby) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*EnterStandbyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("EnterStandby")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentEnterStandbyInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpExecutePolicy struct {
}

func (*awsAwsquery_serializeOpExecutePolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpExecutePolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ExecutePolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ExecutePolicy")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentExecutePolicyInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpExitStandby struct {
}

func (*awsAwsquery_serializeOpExitStandby) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpExitStandby) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ExitStandbyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ExitStandby")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentExitStandbyInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpGetPredictiveScalingForecast struct {
}

func (*awsAwsquery_serializeOpGetPredictiveScalingForecast) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpGetPredictiveScalingForecast) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPredictiveScalingForecastInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetPredictiveScalingForecast")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentGetPredictiveScalingForecastInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpLaunchInstances struct {
}

func (*awsAwsquery_serializeOpLaunchInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpLaunchInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*LaunchInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("LaunchInstances")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentLaunchInstancesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpPutLifecycleHook struct {
}

func (*awsAwsquery_serializeOpPutLifecycleHook) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpPutLifecycleHook) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutLifecycleHookInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("PutLifecycleHook")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentPutLifecycleHookInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpPutNotificationConfiguration struct {
}

func (*awsAwsquery_serializeOpPutNotificationConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpPutNotificationConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutNotificationConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("PutNotificationConfiguration")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentPutNotificationConfigurationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpPutScalingPolicy struct {
}

func (*awsAwsquery_serializeOpPutScalingPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpPutScalingPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutScalingPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("PutScalingPolicy")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentPutScalingPolicyInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpPutScheduledUpdateGroupAction struct {
}

func (*awsAwsquery_serializeOpPutScheduledUpdateGroupAction) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpPutScheduledUpdateGroupAction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutScheduledUpdateGroupActionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("PutScheduledUpdateGroupAction")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentPutScheduledUpdateGroupActionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpPutWarmPool struct {
}

func (*awsAwsquery_serializeOpPutWarmPool) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpPutWarmPool) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutWarmPoolInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("PutWarmPool")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentPutWarmPoolInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpRecordLifecycleActionHeartbeat struct {
}

func (*awsAwsquery_serializeOpRecordLifecycleActionHeartbeat) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpRecordLifecycleActionHeartbeat) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RecordLifecycleActionHeartbeatInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RecordLifecycleActionHeartbeat")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentRecordLifecycleActionHeartbeatInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpResumeProcesses struct {
}

func (*awsAwsquery_serializeOpResumeProcesses) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpResumeProcesses) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ResumeProcessesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ResumeProcesses")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentResumeProcessesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpRollbackInstanceRefresh struct {
}

func (*awsAwsquery_serializeOpRollbackInstanceRefresh) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpRollbackInstanceRefresh) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RollbackInstanceRefreshInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RollbackInstanceRefresh")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentRollbackInstanceRefreshInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpSetDesiredCapacity struct {
}

func (*awsAwsquery_serializeOpSetDesiredCapacity) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpSetDesiredCapacity) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetDesiredCapacityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SetDesiredCapacity")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentSetDesiredCapacityInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpSetInstanceHealth struct {
}

func (*awsAwsquery_serializeOpSetInstanceHealth) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpSetInstanceHealth) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetInstanceHealthInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SetInstanceHealth")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentSetInstanceHealthInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpSetInstanceProtection struct {
}

func (*awsAwsquery_serializeOpSetInstanceProtection) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpSetInstanceProtection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetInstanceProtectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SetInstanceProtection")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentSetInstanceProtectionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpStartInstanceRefresh struct {
}

func (*awsAwsquery_serializeOpStartInstanceRefresh) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpStartInstanceRefresh) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartInstanceRefreshInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("StartInstanceRefresh")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentStartInstanceRefreshInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpSuspendProcesses struct {
}

func (*awsAwsquery_serializeOpSuspendProcesses) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpSuspendProcesses) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SuspendProcessesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SuspendProcesses")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentSuspendProcessesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpTerminateInstanceInAutoScalingGroup struct {
}

func (*awsAwsquery_serializeOpTerminateInstanceInAutoScalingGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpTerminateInstanceInAutoScalingGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TerminateInstanceInAutoScalingGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("TerminateInstanceInAutoScalingGroup")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentTerminateInstanceInAutoScalingGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpUpdateAutoScalingGroup struct {
}

func (*awsAwsquery_serializeOpUpdateAutoScalingGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpUpdateAutoScalingGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateAutoScalingGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("UpdateAutoScalingGroup")
	body.Key("Version").String("2011-01-01")

	if err := awsAwsquery_serializeOpDocumentUpdateAutoScalingGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsAwsquery_serializeDocumentAcceleratorCountRequest(v *types.AcceleratorCountRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Max != nil {
		objectKey := object.Key("Max")
		objectKey.Integer(*v.Max)
	}

	if v.Min != nil {
		objectKey := object.Key("Min")
		objectKey.Integer(*v.Min)
	}

	return nil
}

func awsAwsquery_serializeDocumentAcceleratorManufacturers(v []types.AcceleratorManufacturer, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsquery_serializeDocumentAcceleratorNames(v []types.AcceleratorName, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsquery_serializeDocumentAcceleratorTotalMemoryMiBRequest(v *types.AcceleratorTotalMemoryMiBRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Max != nil {
		objectKey := object.Key("Max")
		objectKey.Integer(*v.Max)
	}

	if v.Min != nil {
		objectKey := object.Key("Min")
		objectKey.Integer(*v.Min)
	}

	return nil
}

func awsAwsquery_serializeDocumentAcceleratorTypes(v []types.AcceleratorType, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsquery_serializeDocumentActivityIds(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentAlarmList(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentAlarmSpecification(v *types.AlarmSpecification, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Alarms != nil {
		objectKey := object.Key("Alarms")
		if err := awsAwsquery_serializeDocumentAlarmList(v.Alarms, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentAllowedInstanceTypes(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentAutoScalingGroupNames(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentAutoScalingNotificationTypes(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentAvailabilityZoneDistribution(v *types.AvailabilityZoneDistribution, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.CapacityDistributionStrategy) > 0 {
		objectKey := object.Key("CapacityDistributionStrategy")
		objectKey.String(string(v.CapacityDistributionStrategy))
	}

	return nil
}

func awsAwsquery_serializeDocumentAvailabilityZoneIdsLimit1(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentAvailabilityZoneImpairmentPolicy(v *types.AvailabilityZoneImpairmentPolicy, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.ImpairedZoneHealthCheckBehavior) > 0 {
		objectKey := object.Key("ImpairedZoneHealthCheckBehavior")
		objectKey.String(string(v.ImpairedZoneHealthCheckBehavior))
	}

	if v.ZonalShiftEnabled != nil {
		objectKey := object.Key("ZonalShiftEnabled")
		objectKey.Boolean(*v.ZonalShiftEnabled)
	}

	return nil
}

func awsAwsquery_serializeDocumentAvailabilityZones(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentAvailabilityZonesLimit1(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentBaselineEbsBandwidthMbpsRequest(v *types.BaselineEbsBandwidthMbpsRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Max != nil {
		objectKey := object.Key("Max")
		objectKey.Integer(*v.Max)
	}

	if v.Min != nil {
		objectKey := object.Key("Min")
		objectKey.Integer(*v.Min)
	}

	return nil
}

func awsAwsquery_serializeDocumentBaselinePerformanceFactorsRequest(v *types.BaselinePerformanceFactorsRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Cpu != nil {
		objectKey := object.Key("Cpu")
		if err := awsAwsquery_serializeDocumentCpuPerformanceFactorRequest(v.Cpu, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentBlockDeviceMapping(v *types.BlockDeviceMapping, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DeviceName != nil {
		objectKey := object.Key("DeviceName")
		objectKey.String(*v.DeviceName)
	}

	if v.Ebs != nil {
		objectKey := object.Key("Ebs")
		if err := awsAwsquery_serializeDocumentEbs(v.Ebs, objectKey); err != nil {
			return err
		}
	}

	if v.NoDevice != nil {
		objectKey := object.Key("NoDevice")
		objectKey.Boolean(*v.NoDevice)
	}

	if v.VirtualName != nil {
		objectKey := object.Key("VirtualName")
		objectKey.String(*v.VirtualName)
	}

	return nil
}

func awsAwsquery_serializeDocumentBlockDeviceMappings(v []types.BlockDeviceMapping, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentBlockDeviceMapping(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentCapacityReservationIds(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentCapacityReservationResourceGroupArns(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentCapacityReservationSpecification(v *types.CapacityReservationSpecification, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.CapacityReservationPreference) > 0 {
		objectKey := object.Key("CapacityReservationPreference")
		objectKey.String(string(v.CapacityReservationPreference))
	}

	if v.CapacityReservationTarget != nil {
		objectKey := object.Key("CapacityReservationTarget")
		if err := awsAwsquery_serializeDocumentCapacityReservationTarget(v.CapacityReservationTarget, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentCapacityReservationTarget(v *types.CapacityReservationTarget, value query.Value) error {
	object := value.Object()
	_ = object

	if v.CapacityReservationIds != nil {
		objectKey := object.Key("CapacityReservationIds")
		if err := awsAwsquery_serializeDocumentCapacityReservationIds(v.CapacityReservationIds, objectKey); err != nil {
			return err
		}
	}

	if v.CapacityReservationResourceGroupArns != nil {
		objectKey := object.Key("CapacityReservationResourceGroupArns")
		if err := awsAwsquery_serializeDocumentCapacityReservationResourceGroupArns(v.CapacityReservationResourceGroupArns, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentCheckpointPercentages(v []int32, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.Integer(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentClassicLinkVPCSecurityGroups(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentCpuManufacturers(v []types.CpuManufacturer, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsquery_serializeDocumentCpuPerformanceFactorRequest(v *types.CpuPerformanceFactorRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.References != nil {
		objectKey := object.Key("Reference")
		if err := awsAwsquery_serializeDocumentPerformanceFactorReferenceSetRequest(v.References, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentCustomizedMetricSpecification(v *types.CustomizedMetricSpecification, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Dimensions != nil {
		objectKey := object.Key("Dimensions")
		if err := awsAwsquery_serializeDocumentMetricDimensions(v.Dimensions, objectKey); err != nil {
			return err
		}
	}

	if v.MetricName != nil {
		objectKey := object.Key("MetricName")
		objectKey.String(*v.MetricName)
	}

	if v.Metrics != nil {
		objectKey := object.Key("Metrics")
		if err := awsAwsquery_serializeDocumentTargetTrackingMetricDataQueries(v.Metrics, objectKey); err != nil {
			return err
		}
	}

	if v.Namespace != nil {
		objectKey := object.Key("Namespace")
		objectKey.String(*v.Namespace)
	}

	if v.Period != nil {
		objectKey := object.Key("Period")
		objectKey.Integer(*v.Period)
	}

	if len(v.Statistic) > 0 {
		objectKey := object.Key("Statistic")
		objectKey.String(string(v.Statistic))
	}

	if v.Unit != nil {
		objectKey := object.Key("Unit")
		objectKey.String(*v.Unit)
	}

	return nil
}

func awsAwsquery_serializeDocumentDesiredConfiguration(v *types.DesiredConfiguration, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LaunchTemplate != nil {
		objectKey := object.Key("LaunchTemplate")
		if err := awsAwsquery_serializeDocumentLaunchTemplateSpecification(v.LaunchTemplate, objectKey); err != nil {
			return err
		}
	}

	if v.MixedInstancesPolicy != nil {
		objectKey := object.Key("MixedInstancesPolicy")
		if err := awsAwsquery_serializeDocumentMixedInstancesPolicy(v.MixedInstancesPolicy, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentEbs(v *types.Ebs, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DeleteOnTermination != nil {
		objectKey := object.Key("DeleteOnTermination")
		objectKey.Boolean(*v.DeleteOnTermination)
	}

	if v.Encrypted != nil {
		objectKey := object.Key("Encrypted")
		objectKey.Boolean(*v.Encrypted)
	}

	if v.Iops != nil {
		objectKey := object.Key("Iops")
		objectKey.Integer(*v.Iops)
	}

	if v.SnapshotId != nil {
		objectKey := object.Key("SnapshotId")
		objectKey.String(*v.SnapshotId)
	}

	if v.Throughput != nil {
		objectKey := object.Key("Throughput")
		objectKey.Integer(*v.Throughput)
	}

	if v.VolumeSize != nil {
		objectKey := object.Key("VolumeSize")
		objectKey.Integer(*v.VolumeSize)
	}

	if v.VolumeType != nil {
		objectKey := object.Key("VolumeType")
		objectKey.String(*v.VolumeType)
	}

	return nil
}

func awsAwsquery_serializeDocumentExcludedInstanceTypes(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentFilter(v *types.Filter, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Name != nil {
		objectKey := object.Key("Name")
		objectKey.String(*v.Name)
	}

	if v.Values != nil {
		objectKey := object.Key("Values")
		if err := awsAwsquery_serializeDocumentValues(v.Values, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentFilters(v []types.Filter, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentInstanceGenerations(v []types.InstanceGeneration, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsquery_serializeDocumentInstanceIds(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentInstanceLifecyclePolicy(v *types.InstanceLifecyclePolicy, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RetentionTriggers != nil {
		objectKey := object.Key("RetentionTriggers")
		if err := awsAwsquery_serializeDocumentRetentionTriggers(v.RetentionTriggers, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentInstanceMaintenancePolicy(v *types.InstanceMaintenancePolicy, value query.Value) error {
	object := value.Object()
	_ = object

	if v.MaxHealthyPercentage != nil {
		objectKey := object.Key("MaxHealthyPercentage")
		objectKey.Integer(*v.MaxHealthyPercentage)
	}

	if v.MinHealthyPercentage != nil {
		objectKey := object.Key("MinHealthyPercentage")
		objectKey.Integer(*v.MinHealthyPercentage)
	}

	return nil
}

func awsAwsquery_serializeDocumentInstanceMetadataOptions(v *types.InstanceMetadataOptions, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.HttpEndpoint) > 0 {
		objectKey := object.Key("HttpEndpoint")
		objectKey.String(string(v.HttpEndpoint))
	}

	if v.HttpPutResponseHopLimit != nil {
		objectKey := object.Key("HttpPutResponseHopLimit")
		objectKey.Integer(*v.HttpPutResponseHopLimit)
	}

	if len(v.HttpTokens) > 0 {
		objectKey := object.Key("HttpTokens")
		objectKey.String(string(v.HttpTokens))
	}

	return nil
}

func awsAwsquery_serializeDocumentInstanceMonitoring(v *types.InstanceMonitoring, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Enabled != nil {
		objectKey := object.Key("Enabled")
		objectKey.Boolean(*v.Enabled)
	}

	return nil
}

func awsAwsquery_serializeDocumentInstanceRefreshIds(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentInstanceRequirements(v *types.InstanceRequirements, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AcceleratorCount != nil {
		objectKey := object.Key("AcceleratorCount")
		if err := awsAwsquery_serializeDocumentAcceleratorCountRequest(v.AcceleratorCount, objectKey); err != nil {
			return err
		}
	}

	if v.AcceleratorManufacturers != nil {
		objectKey := object.Key("AcceleratorManufacturers")
		if err := awsAwsquery_serializeDocumentAcceleratorManufacturers(v.AcceleratorManufacturers, objectKey); err != nil {
			return err
		}
	}

	if v.AcceleratorNames != nil {
		objectKey := object.Key("AcceleratorNames")
		if err := awsAwsquery_serializeDocumentAcceleratorNames(v.AcceleratorNames, objectKey); err != nil {
			return err
		}
	}

	if v.AcceleratorTotalMemoryMiB != nil {
		objectKey := object.Key("AcceleratorTotalMemoryMiB")
		if err := awsAwsquery_serializeDocumentAcceleratorTotalMemoryMiBRequest(v.AcceleratorTotalMemoryMiB, objectKey); err != nil {
			return err
		}
	}

	if v.AcceleratorTypes != nil {
		objectKey := object.Key("AcceleratorTypes")
		if err := awsAwsquery_serializeDocumentAcceleratorTypes(v.AcceleratorTypes, objectKey); err != nil {
			return err
		}
	}

	if v.AllowedInstanceTypes != nil {
		objectKey := object.Key("AllowedInstanceTypes")
		if err := awsAwsquery_serializeDocumentAllowedInstanceTypes(v.AllowedInstanceTypes, objectKey); err != nil {
			return err
		}
	}

	if len(v.BareMetal) > 0 {
		objectKey := object.Key("BareMetal")
		objectKey.String(string(v.BareMetal))
	}

	if v.BaselineEbsBandwidthMbps != nil {
		objectKey := object.Key("BaselineEbsBandwidthMbps")
		if err := awsAwsquery_serializeDocumentBaselineEbsBandwidthMbpsRequest(v.BaselineEbsBandwidthMbps, objectKey); err != nil {
			return err
		}
	}

	if v.BaselinePerformanceFactors != nil {
		objectKey := object.Key("BaselinePerformanceFactors")
		if err := awsAwsquery_serializeDocumentBaselinePerformanceFactorsRequest(v.BaselinePerformanceFactors, objectKey); err != nil {
			return err
		}
	}

	if len(v.BurstablePerformance) > 0 {
		objectKey := object.Key("BurstablePerformance")
		objectKey.String(string(v.BurstablePerformance))
	}

	if v.CpuManufacturers != nil {
		objectKey := object.Key("CpuManufacturers")
		if err := awsAwsquery_serializeDocumentCpuManufacturers(v.CpuManufacturers, objectKey); err != nil {
			return err
		}
	}

	if v.ExcludedInstanceTypes != nil {
		objectKey := object.Key("ExcludedInstanceTypes")
		if err := awsAwsquery_serializeDocumentExcludedInstanceTypes(v.ExcludedInstanceTypes, objectKey); err != nil {
			return err
		}
	}

	if v.InstanceGenerations != nil {
		objectKey := object.Key("InstanceGenerations")
		if err := awsAwsquery_serializeDocumentInstanceGenerations(v.InstanceGenerations, objectKey); err != nil {
			return err
		}
	}

	if len(v.LocalStorage) > 0 {
		objectKey := object.Key("LocalStorage")
		objectKey.String(string(v.LocalStorage))
	}

	if v.LocalStorageTypes != nil {
		objectKey := object.Key("LocalStorageTypes")
		if err := awsAwsquery_serializeDocumentLocalStorageTypes(v.LocalStorageTypes, objectKey); err != nil {
			return err
		}
	}

	if v.MaxSpotPriceAsPercentageOfOptimalOnDemandPrice != nil {
		objectKey := object.Key("MaxSpotPriceAsPercentageOfOptimalOnDemandPrice")
		objectKey.Integer(*v.MaxSpotPriceAsPercentageOfOptimalOnDemandPrice)
	}

	if v.MemoryGiBPerVCpu != nil {
		objectKey := object.Key("MemoryGiBPerVCpu")
		if err := awsAwsquery_serializeDocumentMemoryGiBPerVCpuRequest(v.MemoryGiBPerVCpu, objectKey); err != nil {
			return err
		}
	}

	if v.MemoryMiB != nil {
		objectKey := object.Key("MemoryMiB")
		if err := awsAwsquery_serializeDocumentMemoryMiBRequest(v.MemoryMiB, objectKey); err != nil {
			return err
		}
	}

	if v.NetworkBandwidthGbps != nil {
		objectKey := object.Key("NetworkBandwidthGbps")
		if err := awsAwsquery_serializeDocumentNetworkBandwidthGbpsRequest(v.NetworkBandwidthGbps, objectKey); err != nil {
			return err
		}
	}

	if v.NetworkInterfaceCount != nil {
		objectKey := object.Key("NetworkInterfaceCount")
		if err := awsAwsquery_serializeDocumentNetworkInterfaceCountRequest(v.NetworkInterfaceCount, objectKey); err != nil {
			return err
		}
	}

	if v.OnDemandMaxPricePercentageOverLowestPrice != nil {
		objectKey := object.Key("OnDemandMaxPricePercentageOverLowestPrice")
		objectKey.Integer(*v.OnDemandMaxPricePercentageOverLowestPrice)
	}

	if v.RequireHibernateSupport != nil {
		objectKey := object.Key("RequireHibernateSupport")
		objectKey.Boolean(*v.RequireHibernateSupport)
	}

	if v.SpotMaxPricePercentageOverLowestPrice != nil {
		objectKey := object.Key("SpotMaxPricePercentageOverLowestPrice")
		objectKey.Integer(*v.SpotMaxPricePercentageOverLowestPrice)
	}

	if v.TotalLocalStorageGB != nil {
		objectKey := object.Key("TotalLocalStorageGB")
		if err := awsAwsquery_serializeDocumentTotalLocalStorageGBRequest(v.TotalLocalStorageGB, objectKey); err != nil {
			return err
		}
	}

	if v.VCpuCount != nil {
		objectKey := object.Key("VCpuCount")
		if err := awsAwsquery_serializeDocumentVCpuCountRequest(v.VCpuCount, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentInstanceReusePolicy(v *types.InstanceReusePolicy, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ReuseOnScaleIn != nil {
		objectKey := object.Key("ReuseOnScaleIn")
		objectKey.Boolean(*v.ReuseOnScaleIn)
	}

	return nil
}

func awsAwsquery_serializeDocumentInstancesDistribution(v *types.InstancesDistribution, value query.Value) error {
	object := value.Object()
	_ = object

	if v.OnDemandAllocationStrategy != nil {
		objectKey := object.Key("OnDemandAllocationStrategy")
		objectKey.String(*v.OnDemandAllocationStrategy)
	}

	if v.OnDemandBaseCapacity != nil {
		objectKey := object.Key("OnDemandBaseCapacity")
		objectKey.Integer(*v.OnDemandBaseCapacity)
	}

	if v.OnDemandPercentageAboveBaseCapacity != nil {
		objectKey := object.Key("OnDemandPercentageAboveBaseCapacity")
		objectKey.Integer(*v.OnDemandPercentageAboveBaseCapacity)
	}

	if v.SpotAllocationStrategy != nil {
		objectKey := object.Key("SpotAllocationStrategy")
		objectKey.String(*v.SpotAllocationStrategy)
	}

	if v.SpotInstancePools != nil {
		objectKey := object.Key("SpotInstancePools")
		objectKey.Integer(*v.SpotInstancePools)
	}

	if v.SpotMaxPrice != nil {
		objectKey := object.Key("SpotMaxPrice")
		objectKey.String(*v.SpotMaxPrice)
	}

	return nil
}

func awsAwsquery_serializeDocumentLaunchConfigurationNames(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentLaunchTemplate(v *types.LaunchTemplate, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LaunchTemplateSpecification != nil {
		objectKey := object.Key("LaunchTemplateSpecification")
		if err := awsAwsquery_serializeDocumentLaunchTemplateSpecification(v.LaunchTemplateSpecification, objectKey); err != nil {
			return err
		}
	}

	if v.Overrides != nil {
		objectKey := object.Key("Overrides")
		if err := awsAwsquery_serializeDocumentOverrides(v.Overrides, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentLaunchTemplateOverrides(v *types.LaunchTemplateOverrides, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ImageId != nil {
		objectKey := object.Key("ImageId")
		objectKey.String(*v.ImageId)
	}

	if v.InstanceRequirements != nil {
		objectKey := object.Key("InstanceRequirements")
		if err := awsAwsquery_serializeDocumentInstanceRequirements(v.InstanceRequirements, objectKey); err != nil {
			return err
		}
	}

	if v.InstanceType != nil {
		objectKey := object.Key("InstanceType")
		objectKey.String(*v.InstanceType)
	}

	if v.LaunchTemplateSpecification != nil {
		objectKey := object.Key("LaunchTemplateSpecification")
		if err := awsAwsquery_serializeDocumentLaunchTemplateSpecification(v.LaunchTemplateSpecification, objectKey); err != nil {
			return err
		}
	}

	if v.WeightedCapacity != nil {
		objectKey := object.Key("WeightedCapacity")
		objectKey.String(*v.WeightedCapacity)
	}

	return nil
}

func awsAwsquery_serializeDocumentLaunchTemplateSpecification(v *types.LaunchTemplateSpecification, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LaunchTemplateId != nil {
		objectKey := object.Key("LaunchTemplateId")
		objectKey.String(*v.LaunchTemplateId)
	}

	if v.LaunchTemplateName != nil {
		objectKey := object.Key("LaunchTemplateName")
		objectKey.String(*v.LaunchTemplateName)
	}

	if v.Version != nil {
		objectKey := object.Key("Version")
		objectKey.String(*v.Version)
	}

	return nil
}

func awsAwsquery_serializeDocumentLifecycleHookNames(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentLifecycleHookSpecification(v *types.LifecycleHookSpecification, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DefaultResult != nil {
		objectKey := object.Key("DefaultResult")
		objectKey.String(*v.DefaultResult)
	}

	if v.HeartbeatTimeout != nil {
		objectKey := object.Key("HeartbeatTimeout")
		objectKey.Integer(*v.HeartbeatTimeout)
	}

	if v.LifecycleHookName != nil {
		objectKey := object.Key("LifecycleHookName")
		objectKey.String(*v.LifecycleHookName)
	}

	if v.LifecycleTransition != nil {
		objectKey := object.Key("LifecycleTransition")
		objectKey.String(*v.LifecycleTransition)
	}

	if v.NotificationMetadata != nil {
		objectKey := object.Key("NotificationMetadata")
		objectKey.String(*v.NotificationMetadata)
	}

	if v.NotificationTargetARN != nil {
		objectKey := object.Key("NotificationTargetARN")
		objectKey.String(*v.NotificationTargetARN)
	}

	if v.RoleARN != nil {
		objectKey := object.Key("RoleARN")
		objectKey.String(*v.RoleARN)
	}

	return nil
}

func awsAwsquery_serializeDocumentLifecycleHookSpecifications(v []types.LifecycleHookSpecification, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentLifecycleHookSpecification(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentLoadBalancerNames(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentLocalStorageTypes(v []types.LocalStorageType, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsquery_serializeDocumentMemoryGiBPerVCpuRequest(v *types.MemoryGiBPerVCpuRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Max != nil {
		objectKey := object.Key("Max")
		switch {
		case math.IsNaN(*v.Max):
			objectKey.String("NaN")

		case math.IsInf(*v.Max, 1):
			objectKey.String("Infinity")

		case math.IsInf(*v.Max, -1):
			objectKey.String("-Infinity")

		default:
			objectKey.Double(*v.Max)

		}
	}

	if v.Min != nil {
		objectKey := object.Key("Min")
		switch {
		case math.IsNaN(*v.Min):
			objectKey.String("NaN")

		case math.IsInf(*v.Min, 1):
			objectKey.String("Infinity")

		case math.IsInf(*v.Min, -1):
			objectKey.String("-Infinity")

		default:
			objectKey.Double(*v.Min)

		}
	}

	return nil
}

func awsAwsquery_serializeDocumentMemoryMiBRequest(v *types.MemoryMiBRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Max != nil {
		objectKey := object.Key("Max")
		objectKey.Integer(*v.Max)
	}

	if v.Min != nil {
		objectKey := object.Key("Min")
		objectKey.Integer(*v.Min)
	}

	return nil
}

func awsAwsquery_serializeDocumentMetric(v *types.Metric, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Dimensions != nil {
		objectKey := object.Key("Dimensions")
		if err := awsAwsquery_serializeDocumentMetricDimensions(v.Dimensions, objectKey); err != nil {
			return err
		}
	}

	if v.MetricName != nil {
		objectKey := object.Key("MetricName")
		objectKey.String(*v.MetricName)
	}

	if v.Namespace != nil {
		objectKey := object.Key("Namespace")
		objectKey.String(*v.Namespace)
	}

	return nil
}

func awsAwsquery_serializeDocumentMetricDataQueries(v []types.MetricDataQuery, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentMetricDataQuery(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentMetricDataQuery(v *types.MetricDataQuery, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Expression != nil {
		objectKey := object.Key("Expression")
		objectKey.String(*v.Expression)
	}

	if v.Id != nil {
		objectKey := object.Key("Id")
		objectKey.String(*v.Id)
	}

	if v.Label != nil {
		objectKey := object.Key("Label")
		objectKey.String(*v.Label)
	}

	if v.MetricStat != nil {
		objectKey := object.Key("MetricStat")
		if err := awsAwsquery_serializeDocumentMetricStat(v.MetricStat, objectKey); err != nil {
			return err
		}
	}

	if v.ReturnData != nil {
		objectKey := object.Key("ReturnData")
		objectKey.Boolean(*v.ReturnData)
	}

	return nil
}

func awsAwsquery_serializeDocumentMetricDimension(v *types.MetricDimension, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Name != nil {
		objectKey := object.Key("Name")
		objectKey.String(*v.Name)
	}

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.String(*v.Value)
	}

	return nil
}

func awsAwsquery_serializeDocumentMetricDimensions(v []types.MetricDimension, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentMetricDimension(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentMetrics(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentMetricStat(v *types.MetricStat, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Metric != nil {
		objectKey := object.Key("Metric")
		if err := awsAwsquery_serializeDocumentMetric(v.Metric, objectKey); err != nil {
			return err
		}
	}

	if v.Stat != nil {
		objectKey := object.Key("Stat")
		objectKey.String(*v.Stat)
	}

	if v.Unit != nil {
		objectKey := object.Key("Unit")
		objectKey.String(*v.Unit)
	}

	return nil
}

func awsAwsquery_serializeDocumentMixedInstancesPolicy(v *types.MixedInstancesPolicy, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstancesDistribution != nil {
		objectKey := object.Key("InstancesDistribution")
		if err := awsAwsquery_serializeDocumentInstancesDistribution(v.InstancesDistribution, objectKey); err != nil {
			return err
		}
	}

	if v.LaunchTemplate != nil {
		objectKey := object.Key("LaunchTemplate")
		if err := awsAwsquery_serializeDocumentLaunchTemplate(v.LaunchTemplate, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentNetworkBandwidthGbpsRequest(v *types.NetworkBandwidthGbpsRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Max != nil {
		objectKey := object.Key("Max")
		switch {
		case math.IsNaN(*v.Max):
			objectKey.String("NaN")

		case math.IsInf(*v.Max, 1):
			objectKey.String("Infinity")

		case math.IsInf(*v.Max, -1):
			objectKey.String("-Infinity")

		default:
			objectKey.Double(*v.Max)

		}
	}

	if v.Min != nil {
		objectKey := object.Key("Min")
		switch {
		case math.IsNaN(*v.Min):
			objectKey.String("NaN")

		case math.IsInf(*v.Min, 1):
			objectKey.String("Infinity")

		case math.IsInf(*v.Min, -1):
			objectKey.String("-Infinity")

		default:
			objectKey.Double(*v.Min)

		}
	}

	return nil
}

func awsAwsquery_serializeDocumentNetworkInterfaceCountRequest(v *types.NetworkInterfaceCountRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Max != nil {
		objectKey := object.Key("Max")
		objectKey.Integer(*v.Max)
	}

	if v.Min != nil {
		objectKey := object.Key("Min")
		objectKey.Integer(*v.Min)
	}

	return nil
}

func awsAwsquery_serializeDocumentOverrides(v []types.LaunchTemplateOverrides, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentLaunchTemplateOverrides(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentPerformanceFactorReferenceRequest(v *types.PerformanceFactorReferenceRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstanceFamily != nil {
		objectKey := object.Key("InstanceFamily")
		objectKey.String(*v.InstanceFamily)
	}

	return nil
}

func awsAwsquery_serializeDocumentPerformanceFactorReferenceSetRequest(v []types.PerformanceFactorReferenceRequest, value query.Value) error {
	array := value.Array("item")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentPerformanceFactorReferenceRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentPolicyNames(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentPolicyTypes(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentPredefinedMetricSpecification(v *types.PredefinedMetricSpecification, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.PredefinedMetricType) > 0 {
		objectKey := object.Key("PredefinedMetricType")
		objectKey.String(string(v.PredefinedMetricType))
	}

	if v.ResourceLabel != nil {
		objectKey := object.Key("ResourceLabel")
		objectKey.String(*v.ResourceLabel)
	}

	return nil
}

func awsAwsquery_serializeDocumentPredictiveScalingConfiguration(v *types.PredictiveScalingConfiguration, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.MaxCapacityBreachBehavior) > 0 {
		objectKey := object.Key("MaxCapacityBreachBehavior")
		objectKey.String(string(v.MaxCapacityBreachBehavior))
	}

	if v.MaxCapacityBuffer != nil {
		objectKey := object.Key("MaxCapacityBuffer")
		objectKey.Integer(*v.MaxCapacityBuffer)
	}

	if v.MetricSpecifications != nil {
		objectKey := object.Key("MetricSpecifications")
		if err := awsAwsquery_serializeDocumentPredictiveScalingMetricSpecifications(v.MetricSpecifications, objectKey); err != nil {
			return err
		}
	}

	if len(v.Mode) > 0 {
		objectKey := object.Key("Mode")
		objectKey.String(string(v.Mode))
	}

	if v.SchedulingBufferTime != nil {
		objectKey := object.Key("SchedulingBufferTime")
		objectKey.Integer(*v.SchedulingBufferTime)
	}

	return nil
}

func awsAwsquery_serializeDocumentPredictiveScalingCustomizedCapacityMetric(v *types.PredictiveScalingCustomizedCapacityMetric, value query.Value) error {
	object := value.Object()
	_ = object

	if v.MetricDataQueries != nil {
		objectKey := object.Key("MetricDataQueries")
		if err := awsAwsquery_serializeDocumentMetricDataQueries(v.MetricDataQueries, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentPredictiveScalingCustomizedLoadMetric(v *types.PredictiveScalingCustomizedLoadMetric, value query.Value) error {
	object := value.Object()
	_ = object

	if v.MetricDataQueries != nil {
		objectKey := object.Key("MetricDataQueries")
		if err := awsAwsquery_serializeDocumentMetricDataQueries(v.MetricDataQueries, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentPredictiveScalingCustomizedScalingMetric(v *types.PredictiveScalingCustomizedScalingMetric, value query.Value) error {
	object := value.Object()
	_ = object

	if v.MetricDataQueries != nil {
		objectKey := object.Key("MetricDataQueries")
		if err := awsAwsquery_serializeDocumentMetricDataQueries(v.MetricDataQueries, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentPredictiveScalingMetricSpecification(v *types.PredictiveScalingMetricSpecification, value query.Value) error {
	object := value.Object()
	_ = object

	if v.CustomizedCapacityMetricSpecification != nil {
		objectKey := object.Key("CustomizedCapacityMetricSpecification")
		if err := awsAwsquery_serializeDocumentPredictiveScalingCustomizedCapacityMetric(v.CustomizedCapacityMetricSpecification, objectKey); err != nil {
			return err
		}
	}

	if v.CustomizedLoadMetricSpecification != nil {
		objectKey := object.Key("CustomizedLoadMetricSpecification")
		if err := awsAwsquery_serializeDocumentPredictiveScalingCustomizedLoadMetric(v.CustomizedLoadMetricSpecification, objectKey); err != nil {
			return err
		}
	}

	if v.CustomizedScalingMetricSpecification != nil {
		objectKey := object.Key("CustomizedScalingMetricSpecification")
		if err := awsAwsquery_serializeDocumentPredictiveScalingCustomizedScalingMetric(v.CustomizedScalingMetricSpecification, objectKey); err != nil {
			return err
		}
	}

	if v.PredefinedLoadMetricSpecification != nil {
		objectKey := object.Key("PredefinedLoadMetricSpecification")
		if err := awsAwsquery_serializeDocumentPredictiveScalingPredefinedLoadMetric(v.PredefinedLoadMetricSpecification, objectKey); err != nil {
			return err
		}
	}

	if v.PredefinedMetricPairSpecification != nil {
		objectKey := object.Key("PredefinedMetricPairSpecification")
		if err := awsAwsquery_serializeDocumentPredictiveScalingPredefinedMetricPair(v.PredefinedMetricPairSpecification, objectKey); err != nil {
			return err
		}
	}

	if v.PredefinedScalingMetricSpecification != nil {
		objectKey := object.Key("PredefinedScalingMetricSpecification")
		if err := awsAwsquery_serializeDocumentPredictiveScalingPredefinedScalingMetric(v.PredefinedScalingMetricSpecification, objectKey); err != nil {
			return err
		}
	}

	if v.TargetValue != nil {
		objectKey := object.Key("TargetValue")
		switch {
		case math.IsNaN(*v.TargetValue):
			objectKey.String("NaN")

		case math.IsInf(*v.TargetValue, 1):
			objectKey.String("Infinity")

		case math.IsInf(*v.TargetValue, -1):
			objectKey.String("-Infinity")

		default:
			objectKey.Double(*v.TargetValue)

		}
	}

	return nil
}

func awsAwsquery_serializeDocumentPredictiveScalingMetricSpecifications(v []types.PredictiveScalingMetricSpecification, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentPredictiveScalingMetricSpecification(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentPredictiveScalingPredefinedLoadMetric(v *types.PredictiveScalingPredefinedLoadMetric, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.PredefinedMetricType) > 0 {
		objectKey := object.Key("PredefinedMetricType")
		objectKey.String(string(v.PredefinedMetricType))
	}

	if v.ResourceLabel != nil {
		objectKey := object.Key("ResourceLabel")
		objectKey.String(*v.ResourceLabel)
	}

	return nil
}

func awsAwsquery_serializeDocumentPredictiveScalingPredefinedMetricPair(v *types.PredictiveScalingPredefinedMetricPair, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.PredefinedMetricType) > 0 {
		objectKey := object.Key("PredefinedMetricType")
		objectKey.String(string(v.PredefinedMetricType))
	}

	if v.ResourceLabel != nil {
		objectKey := object.Key("ResourceLabel")
		objectKey.String(*v.ResourceLabel)
	}

	return nil
}

func awsAwsquery_serializeDocumentPredictiveScalingPredefinedScalingMetric(v *types.PredictiveScalingPredefinedScalingMetric, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.PredefinedMetricType) > 0 {
		objectKey := object.Key("PredefinedMetricType")
		objectKey.String(string(v.PredefinedMetricType))
	}

	if v.ResourceLabel != nil {
		objectKey := object.Key("ResourceLabel")
		objectKey.String(*v.ResourceLabel)
	}

	return nil
}

func awsAwsquery_serializeDocumentProcessNames(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentRefreshPreferences(v *types.RefreshPreferences, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AlarmSpecification != nil {
		objectKey := object.Key("AlarmSpecification")
		if err := awsAwsquery_serializeDocumentAlarmSpecification(v.AlarmSpecification, objectKey); err != nil {
			return err
		}
	}

	if v.AutoRollback != nil {
		objectKey := object.Key("AutoRollback")
		objectKey.Boolean(*v.AutoRollback)
	}

	if v.BakeTime != nil {
		objectKey := object.Key("BakeTime")
		objectKey.Integer(*v.BakeTime)
	}

	if v.CheckpointDelay != nil {
		objectKey := object.Key("CheckpointDelay")
		objectKey.Integer(*v.CheckpointDelay)
	}

	if v.CheckpointPercentages != nil {
		objectKey := object.Key("CheckpointPercentages")
		if err := awsAwsquery_serializeDocumentCheckpointPercentages(v.CheckpointPercentages, objectKey); err != nil {
			return err
		}
	}

	if v.InstanceWarmup != nil {
		objectKey := object.Key("InstanceWarmup")
		objectKey.Integer(*v.InstanceWarmup)
	}

	if v.MaxHealthyPercentage != nil {
		objectKey := object.Key("MaxHealthyPercentage")
		objectKey.Integer(*v.MaxHealthyPercentage)
	}

	if v.MinHealthyPercentage != nil {
		objectKey := object.Key("MinHealthyPercentage")
		objectKey.Integer(*v.MinHealthyPercentage)
	}

	if len(v.ScaleInProtectedInstances) > 0 {
		objectKey := object.Key("ScaleInProtectedInstances")
		objectKey.String(string(v.ScaleInProtectedInstances))
	}

	if v.SkipMatching != nil {
		objectKey := object.Key("SkipMatching")
		objectKey.Boolean(*v.SkipMatching)
	}

	if len(v.StandbyInstances) > 0 {
		objectKey := object.Key("StandbyInstances")
		objectKey.String(string(v.StandbyInstances))
	}

	return nil
}

func awsAwsquery_serializeDocumentRetentionTriggers(v *types.RetentionTriggers, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.TerminateHookAbandon) > 0 {
		objectKey := object.Key("TerminateHookAbandon")
		objectKey.String(string(v.TerminateHookAbandon))
	}

	return nil
}

func awsAwsquery_serializeDocumentScheduledActionNames(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentScheduledUpdateGroupActionRequest(v *types.ScheduledUpdateGroupActionRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DesiredCapacity != nil {
		objectKey := object.Key("DesiredCapacity")
		objectKey.Integer(*v.DesiredCapacity)
	}

	if v.EndTime != nil {
		objectKey := object.Key("EndTime")
		objectKey.String(smithytime.FormatDateTime(*v.EndTime))
	}

	if v.MaxSize != nil {
		objectKey := object.Key("MaxSize")
		objectKey.Integer(*v.MaxSize)
	}

	if v.MinSize != nil {
		objectKey := object.Key("MinSize")
		objectKey.Integer(*v.MinSize)
	}

	if v.Recurrence != nil {
		objectKey := object.Key("Recurrence")
		objectKey.String(*v.Recurrence)
	}

	if v.ScheduledActionName != nil {
		objectKey := object.Key("ScheduledActionName")
		objectKey.String(*v.ScheduledActionName)
	}

	if v.StartTime != nil {
		objectKey := object.Key("StartTime")
		objectKey.String(smithytime.FormatDateTime(*v.StartTime))
	}

	if v.TimeZone != nil {
		objectKey := object.Key("TimeZone")
		objectKey.String(*v.TimeZone)
	}

	return nil
}

func awsAwsquery_serializeDocumentScheduledUpdateGroupActionRequests(v []types.ScheduledUpdateGroupActionRequest, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentScheduledUpdateGroupActionRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentSecurityGroups(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentStepAdjustment(v *types.StepAdjustment, value query.Value) error {
	object := value.Object()
	_ = object

	if v.MetricIntervalLowerBound != nil {
		objectKey := object.Key("MetricIntervalLowerBound")
		switch {
		case math.IsNaN(*v.MetricIntervalLowerBound):
			objectKey.String("NaN")

		case math.IsInf(*v.MetricIntervalLowerBound, 1):
			objectKey.String("Infinity")

		case math.IsInf(*v.MetricIntervalLowerBound, -1):
			objectKey.String("-Infinity")

		default:
			objectKey.Double(*v.MetricIntervalLowerBound)

		}
	}

	if v.MetricIntervalUpperBound != nil {
		objectKey := object.Key("MetricIntervalUpperBound")
		switch {
		case math.IsNaN(*v.MetricIntervalUpperBound):
			objectKey.String("NaN")

		case math.IsInf(*v.MetricIntervalUpperBound, 1):
			objectKey.String("Infinity")

		case math.IsInf(*v.MetricIntervalUpperBound, -1):
			objectKey.String("-Infinity")

		default:
			objectKey.Double(*v.MetricIntervalUpperBound)

		}
	}

	if v.ScalingAdjustment != nil {
		objectKey := object.Key("ScalingAdjustment")
		objectKey.Integer(*v.ScalingAdjustment)
	}

	return nil
}

func awsAwsquery_serializeDocumentStepAdjustments(v []types.StepAdjustment, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentStepAdjustment(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentSubnetIdsLimit1(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentTag(v *types.Tag, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Key != nil {
		objectKey := object.Key("Key")
		objectKey.String(*v.Key)
	}

	if v.PropagateAtLaunch != nil {
		objectKey := object.Key("PropagateAtLaunch")
		objectKey.Boolean(*v.PropagateAtLaunch)
	}

	if v.ResourceId != nil {
		objectKey := object.Key("ResourceId")
		objectKey.String(*v.ResourceId)
	}

	if v.ResourceType != nil {
		objectKey := object.Key("ResourceType")
		objectKey.String(*v.ResourceType)
	}

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.String(*v.Value)
	}

	return nil
}

func awsAwsquery_serializeDocumentTags(v []types.Tag, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentTargetGroupARNs(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentTargetTrackingConfiguration(v *types.TargetTrackingConfiguration, value query.Value) error {
	object := value.Object()
	_ = object

	if v.CustomizedMetricSpecification != nil {
		objectKey := object.Key("CustomizedMetricSpecification")
		if err := awsAwsquery_serializeDocumentCustomizedMetricSpecification(v.CustomizedMetricSpecification, objectKey); err != nil {
			return err
		}
	}

	if v.DisableScaleIn != nil {
		objectKey := object.Key("DisableScaleIn")
		objectKey.Boolean(*v.DisableScaleIn)
	}

	if v.PredefinedMetricSpecification != nil {
		objectKey := object.Key("PredefinedMetricSpecification")
		if err := awsAwsquery_serializeDocumentPredefinedMetricSpecification(v.PredefinedMetricSpecification, objectKey); err != nil {
			return err
		}
	}

	if v.TargetValue != nil {
		objectKey := object.Key("TargetValue")
		switch {
		case math.IsNaN(*v.TargetValue):
			objectKey.String("NaN")

		case math.IsInf(*v.TargetValue, 1):
			objectKey.String("Infinity")

		case math.IsInf(*v.TargetValue, -1):
			objectKey.String("-Infinity")

		default:
			objectKey.Double(*v.TargetValue)

		}
	}

	return nil
}

func awsAwsquery_serializeDocumentTargetTrackingMetricDataQueries(v []types.TargetTrackingMetricDataQuery, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentTargetTrackingMetricDataQuery(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentTargetTrackingMetricDataQuery(v *types.TargetTrackingMetricDataQuery, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Expression != nil {
		objectKey := object.Key("Expression")
		objectKey.String(*v.Expression)
	}

	if v.Id != nil {
		objectKey := object.Key("Id")
		objectKey.String(*v.Id)
	}

	if v.Label != nil {
		objectKey := object.Key("Label")
		objectKey.String(*v.Label)
	}

	if v.MetricStat != nil {
		objectKey := object.Key("MetricStat")
		if err := awsAwsquery_serializeDocumentTargetTrackingMetricStat(v.MetricStat, objectKey); err != nil {
			return err
		}
	}

	if v.Period != nil {
		objectKey := object.Key("Period")
		objectKey.Integer(*v.Period)
	}

	if v.ReturnData != nil {
		objectKey := object.Key("ReturnData")
		objectKey.Boolean(*v.ReturnData)
	}

	return nil
}

func awsAwsquery_serializeDocumentTargetTrackingMetricStat(v *types.TargetTrackingMetricStat, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Metric != nil {
		objectKey := object.Key("Metric")
		if err := awsAwsquery_serializeDocumentMetric(v.Metric, objectKey); err != nil {
			return err
		}
	}

	if v.Period != nil {
		objectKey := object.Key("Period")
		objectKey.Integer(*v.Period)
	}

	if v.Stat != nil {
		objectKey := object.Key("Stat")
		objectKey.String(*v.Stat)
	}

	if v.Unit != nil {
		objectKey := object.Key("Unit")
		objectKey.String(*v.Unit)
	}

	return nil
}

func awsAwsquery_serializeDocumentTerminationPolicies(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentTotalLocalStorageGBRequest(v *types.TotalLocalStorageGBRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Max != nil {
		objectKey := object.Key("Max")
		switch {
		case math.IsNaN(*v.Max):
			objectKey.String("NaN")

		case math.IsInf(*v.Max, 1):
			objectKey.String("Infinity")

		case math.IsInf(*v.Max, -1):
			objectKey.String("-Infinity")

		default:
			objectKey.Double(*v.Max)

		}
	}

	if v.Min != nil {
		objectKey := object.Key("Min")
		switch {
		case math.IsNaN(*v.Min):
			objectKey.String("NaN")

		case math.IsInf(*v.Min, 1):
			objectKey.String("Infinity")

		case math.IsInf(*v.Min, -1):
			objectKey.String("-Infinity")

		default:
			objectKey.Double(*v.Min)

		}
	}

	return nil
}

func awsAwsquery_serializeDocumentTrafficSourceIdentifier(v *types.TrafficSourceIdentifier, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Identifier != nil {
		objectKey := object.Key("Identifier")
		objectKey.String(*v.Identifier)
	}

	if v.Type != nil {
		objectKey := object.Key("Type")
		objectKey.String(*v.Type)
	}

	return nil
}

func awsAwsquery_serializeDocumentTrafficSources(v []types.TrafficSourceIdentifier, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentTrafficSourceIdentifier(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentValues(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentVCpuCountRequest(v *types.VCpuCountRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Max != nil {
		objectKey := object.Key("Max")
		objectKey.Integer(*v.Max)
	}

	if v.Min != nil {
		objectKey := object.Key("Min")
		objectKey.Integer(*v.Min)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentAttachInstancesInput(v *AttachInstancesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.InstanceIds != nil {
		objectKey := object.Key("InstanceIds")
		if err := awsAwsquery_serializeDocumentInstanceIds(v.InstanceIds, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentAttachLoadBalancersInput(v *AttachLoadBalancersInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.LoadBalancerNames != nil {
		objectKey := object.Key("LoadBalancerNames")
		if err := awsAwsquery_serializeDocumentLoadBalancerNames(v.LoadBalancerNames, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentAttachLoadBalancerTargetGroupsInput(v *AttachLoadBalancerTargetGroupsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.TargetGroupARNs != nil {
		objectKey := object.Key("TargetGroupARNs")
		if err := awsAwsquery_serializeDocumentTargetGroupARNs(v.TargetGroupARNs, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentAttachTrafficSourcesInput(v *AttachTrafficSourcesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.SkipZonalShiftValidation != nil {
		objectKey := object.Key("SkipZonalShiftValidation")
		objectKey.Boolean(*v.SkipZonalShiftValidation)
	}

	if v.TrafficSources != nil {
		objectKey := object.Key("TrafficSources")
		if err := awsAwsquery_serializeDocumentTrafficSources(v.TrafficSources, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentBatchDeleteScheduledActionInput(v *BatchDeleteScheduledActionInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.ScheduledActionNames != nil {
		objectKey := object.Key("ScheduledActionNames")
		if err := awsAwsquery_serializeDocumentScheduledActionNames(v.ScheduledActionNames, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentBatchPutScheduledUpdateGroupActionInput(v *BatchPutScheduledUpdateGroupActionInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.ScheduledUpdateGroupActions != nil {
		objectKey := object.Key("ScheduledUpdateGroupActions")
		if err := awsAwsquery_serializeDocumentScheduledUpdateGroupActionRequests(v.ScheduledUpdateGroupActions, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCancelInstanceRefreshInput(v *CancelInstanceRefreshInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.WaitForTransitioningInstances != nil {
		objectKey := object.Key("WaitForTransitioningInstances")
		objectKey.Boolean(*v.WaitForTransitioningInstances)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCompleteLifecycleActionInput(v *CompleteLifecycleActionInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	if v.LifecycleActionResult != nil {
		objectKey := object.Key("LifecycleActionResult")
		objectKey.String(*v.LifecycleActionResult)
	}

	if v.LifecycleActionToken != nil {
		objectKey := object.Key("LifecycleActionToken")
		objectKey.String(*v.LifecycleActionToken)
	}

	if v.LifecycleHookName != nil {
		objectKey := object.Key("LifecycleHookName")
		objectKey.String(*v.LifecycleHookName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateAutoScalingGroupInput(v *CreateAutoScalingGroupInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.AvailabilityZoneDistribution != nil {
		objectKey := object.Key("AvailabilityZoneDistribution")
		if err := awsAwsquery_serializeDocumentAvailabilityZoneDistribution(v.AvailabilityZoneDistribution, objectKey); err != nil {
			return err
		}
	}

	if v.AvailabilityZoneImpairmentPolicy != nil {
		objectKey := object.Key("AvailabilityZoneImpairmentPolicy")
		if err := awsAwsquery_serializeDocumentAvailabilityZoneImpairmentPolicy(v.AvailabilityZoneImpairmentPolicy, objectKey); err != nil {
			return err
		}
	}

	if v.AvailabilityZones != nil {
		objectKey := object.Key("AvailabilityZones")
		if err := awsAwsquery_serializeDocumentAvailabilityZones(v.AvailabilityZones, objectKey); err != nil {
			return err
		}
	}

	if v.CapacityRebalance != nil {
		objectKey := object.Key("CapacityRebalance")
		objectKey.Boolean(*v.CapacityRebalance)
	}

	if v.CapacityReservationSpecification != nil {
		objectKey := object.Key("CapacityReservationSpecification")
		if err := awsAwsquery_serializeDocumentCapacityReservationSpecification(v.CapacityReservationSpecification, objectKey); err != nil {
			return err
		}
	}

	if v.Context != nil {
		objectKey := object.Key("Context")
		objectKey.String(*v.Context)
	}

	if v.DefaultCooldown != nil {
		objectKey := object.Key("DefaultCooldown")
		objectKey.Integer(*v.DefaultCooldown)
	}

	if v.DefaultInstanceWarmup != nil {
		objectKey := object.Key("DefaultInstanceWarmup")
		objectKey.Integer(*v.DefaultInstanceWarmup)
	}

	if v.DesiredCapacity != nil {
		objectKey := object.Key("DesiredCapacity")
		objectKey.Integer(*v.DesiredCapacity)
	}

	if v.DesiredCapacityType != nil {
		objectKey := object.Key("DesiredCapacityType")
		objectKey.String(*v.DesiredCapacityType)
	}

	if v.HealthCheckGracePeriod != nil {
		objectKey := object.Key("HealthCheckGracePeriod")
		objectKey.Integer(*v.HealthCheckGracePeriod)
	}

	if v.HealthCheckType != nil {
		objectKey := object.Key("HealthCheckType")
		objectKey.String(*v.HealthCheckType)
	}

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	if v.InstanceLifecyclePolicy != nil {
		objectKey := object.Key("InstanceLifecyclePolicy")
		if err := awsAwsquery_serializeDocumentInstanceLifecyclePolicy(v.InstanceLifecyclePolicy, objectKey); err != nil {
			return err
		}
	}

	if v.InstanceMaintenancePolicy != nil {
		objectKey := object.Key("InstanceMaintenancePolicy")
		if err := awsAwsquery_serializeDocumentInstanceMaintenancePolicy(v.InstanceMaintenancePolicy, objectKey); err != nil {
			return err
		}
	}

	if v.LaunchConfigurationName != nil {
		objectKey := object.Key("LaunchConfigurationName")
		objectKey.String(*v.LaunchConfigurationName)
	}

	if v.LaunchTemplate != nil {
		objectKey := object.Key("LaunchTemplate")
		if err := awsAwsquery_serializeDocumentLaunchTemplateSpecification(v.LaunchTemplate, objectKey); err != nil {
			return err
		}
	}

	if v.LifecycleHookSpecificationList != nil {
		objectKey := object.Key("LifecycleHookSpecificationList")
		if err := awsAwsquery_serializeDocumentLifecycleHookSpecifications(v.LifecycleHookSpecificationList, objectKey); err != nil {
			return err
		}
	}

	if v.LoadBalancerNames != nil {
		objectKey := object.Key("LoadBalancerNames")
		if err := awsAwsquery_serializeDocumentLoadBalancerNames(v.LoadBalancerNames, objectKey); err != nil {
			return err
		}
	}

	if v.MaxInstanceLifetime != nil {
		objectKey := object.Key("MaxInstanceLifetime")
		objectKey.Integer(*v.MaxInstanceLifetime)
	}

	if v.MaxSize != nil {
		objectKey := object.Key("MaxSize")
		objectKey.Integer(*v.MaxSize)
	}

	if v.MinSize != nil {
		objectKey := object.Key("MinSize")
		objectKey.Integer(*v.MinSize)
	}

	if v.MixedInstancesPolicy != nil {
		objectKey := object.Key("MixedInstancesPolicy")
		if err := awsAwsquery_serializeDocumentMixedInstancesPolicy(v.MixedInstancesPolicy, objectKey); err != nil {
			return err
		}
	}

	if v.NewInstancesProtectedFromScaleIn != nil {
		objectKey := object.Key("NewInstancesProtectedFromScaleIn")
		objectKey.Boolean(*v.NewInstancesProtectedFromScaleIn)
	}

	if v.PlacementGroup != nil {
		objectKey := object.Key("PlacementGroup")
		objectKey.String(*v.PlacementGroup)
	}

	if v.ServiceLinkedRoleARN != nil {
		objectKey := object.Key("ServiceLinkedRoleARN")
		objectKey.String(*v.ServiceLinkedRoleARN)
	}

	if v.SkipZonalShiftValidation != nil {
		objectKey := object.Key("SkipZonalShiftValidation")
		objectKey.Boolean(*v.SkipZonalShiftValidation)
	}

	if v.Tags != nil {
		objectKey := object.Key("Tags")
		if err := awsAwsquery_serializeDocumentTags(v.Tags, objectKey); err != nil {
			return err
		}
	}

	if v.TargetGroupARNs != nil {
		objectKey := object.Key("TargetGroupARNs")
		if err := awsAwsquery_serializeDocumentTargetGroupARNs(v.TargetGroupARNs, objectKey); err != nil {
			return err
		}
	}

	if v.TerminationPolicies != nil {
		objectKey := object.Key("TerminationPolicies")
		if err := awsAwsquery_serializeDocumentTerminationPolicies(v.TerminationPolicies, objectKey); err != nil {
			return err
		}
	}

	if v.TrafficSources != nil {
		objectKey := object.Key("TrafficSources")
		if err := awsAwsquery_serializeDocumentTrafficSources(v.TrafficSources, objectKey); err != nil {
			return err
		}
	}

	if v.VPCZoneIdentifier != nil {
		objectKey := object.Key("VPCZoneIdentifier")
		objectKey.String(*v.VPCZoneIdentifier)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateLaunchConfigurationInput(v *CreateLaunchConfigurationInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AssociatePublicIpAddress != nil {
		objectKey := object.Key("AssociatePublicIpAddress")
		objectKey.Boolean(*v.AssociatePublicIpAddress)
	}

	if v.BlockDeviceMappings != nil {
		objectKey := object.Key("BlockDeviceMappings")
		if err := awsAwsquery_serializeDocumentBlockDeviceMappings(v.BlockDeviceMappings, objectKey); err != nil {
			return err
		}
	}

	if v.ClassicLinkVPCId != nil {
		objectKey := object.Key("ClassicLinkVPCId")
		objectKey.String(*v.ClassicLinkVPCId)
	}

	if v.ClassicLinkVPCSecurityGroups != nil {
		objectKey := object.Key("ClassicLinkVPCSecurityGroups")
		if err := awsAwsquery_serializeDocumentClassicLinkVPCSecurityGroups(v.ClassicLinkVPCSecurityGroups, objectKey); err != nil {
			return err
		}
	}

	if v.EbsOptimized != nil {
		objectKey := object.Key("EbsOptimized")
		objectKey.Boolean(*v.EbsOptimized)
	}

	if v.IamInstanceProfile != nil {
		objectKey := object.Key("IamInstanceProfile")
		objectKey.String(*v.IamInstanceProfile)
	}

	if v.ImageId != nil {
		objectKey := object.Key("ImageId")
		objectKey.String(*v.ImageId)
	}

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	if v.InstanceMonitoring != nil {
		objectKey := object.Key("InstanceMonitoring")
		if err := awsAwsquery_serializeDocumentInstanceMonitoring(v.InstanceMonitoring, objectKey); err != nil {
			return err
		}
	}

	if v.InstanceType != nil {
		objectKey := object.Key("InstanceType")
		objectKey.String(*v.InstanceType)
	}

	if v.KernelId != nil {
		objectKey := object.Key("KernelId")
		objectKey.String(*v.KernelId)
	}

	if v.KeyName != nil {
		objectKey := object.Key("KeyName")
		objectKey.String(*v.KeyName)
	}

	if v.LaunchConfigurationName != nil {
		objectKey := object.Key("LaunchConfigurationName")
		objectKey.String(*v.LaunchConfigurationName)
	}

	if v.MetadataOptions != nil {
		objectKey := object.Key("MetadataOptions")
		if err := awsAwsquery_serializeDocumentInstanceMetadataOptions(v.MetadataOptions, objectKey); err != nil {
			return err
		}
	}

	if v.PlacementTenancy != nil {
		objectKey := object.Key("PlacementTenancy")
		objectKey.String(*v.PlacementTenancy)
	}

	if v.RamdiskId != nil {
		objectKey := object.Key("RamdiskId")
		objectKey.String(*v.RamdiskId)
	}

	if v.SecurityGroups != nil {
		objectKey := object.Key("SecurityGroups")
		if err := awsAwsquery_serializeDocumentSecurityGroups(v.SecurityGroups, objectKey); err != nil {
			return err
		}
	}

	if v.SpotPrice != nil {
		objectKey := object.Key("SpotPrice")
		objectKey.String(*v.SpotPrice)
	}

	if v.UserData != nil {
		objectKey := object.Key("UserData")
		objectKey.String(*v.UserData)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateOrUpdateTagsInput(v *CreateOrUpdateTagsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Tags != nil {
		objectKey := object.Key("Tags")
		if err := awsAwsquery_serializeDocumentTags(v.Tags, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteAutoScalingGroupInput(v *DeleteAutoScalingGroupInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.ForceDelete != nil {
		objectKey := object.Key("ForceDelete")
		objectKey.Boolean(*v.ForceDelete)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteLaunchConfigurationInput(v *DeleteLaunchConfigurationInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LaunchConfigurationName != nil {
		objectKey := object.Key("LaunchConfigurationName")
		objectKey.String(*v.LaunchConfigurationName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteLifecycleHookInput(v *DeleteLifecycleHookInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.LifecycleHookName != nil {
		objectKey := object.Key("LifecycleHookName")
		objectKey.String(*v.LifecycleHookName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteNotificationConfigurationInput(v *DeleteNotificationConfigurationInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.TopicARN != nil {
		objectKey := object.Key("TopicARN")
		objectKey.String(*v.TopicARN)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeletePolicyInput(v *DeletePolicyInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.PolicyName != nil {
		objectKey := object.Key("PolicyName")
		objectKey.String(*v.PolicyName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteScheduledActionInput(v *DeleteScheduledActionInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.ScheduledActionName != nil {
		objectKey := object.Key("ScheduledActionName")
		objectKey.String(*v.ScheduledActionName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteTagsInput(v *DeleteTagsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Tags != nil {
		objectKey := object.Key("Tags")
		if err := awsAwsquery_serializeDocumentTags(v.Tags, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteWarmPoolInput(v *DeleteWarmPoolInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.ForceDelete != nil {
		objectKey := object.Key("ForceDelete")
		objectKey.Boolean(*v.ForceDelete)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeAutoScalingGroupsInput(v *DescribeAutoScalingGroupsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupNames != nil {
		objectKey := object.Key("AutoScalingGroupNames")
		if err := awsAwsquery_serializeDocumentAutoScalingGroupNames(v.AutoScalingGroupNames, objectKey); err != nil {
			return err
		}
	}

	if v.Filters != nil {
		objectKey := object.Key("Filters")
		if err := awsAwsquery_serializeDocumentFilters(v.Filters, objectKey); err != nil {
			return err
		}
	}

	if v.IncludeInstances != nil {
		objectKey := object.Key("IncludeInstances")
		objectKey.Boolean(*v.IncludeInstances)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.NextToken != nil {
		objectKey := object.Key("NextToken")
		objectKey.String(*v.NextToken)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeAutoScalingInstancesInput(v *DescribeAutoScalingInstancesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstanceIds != nil {
		objectKey := object.Key("InstanceIds")
		if err := awsAwsquery_serializeDocumentInstanceIds(v.InstanceIds, objectKey); err != nil {
			return err
		}
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.NextToken != nil {
		objectKey := object.Key("NextToken")
		objectKey.String(*v.NextToken)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeInstanceRefreshesInput(v *DescribeInstanceRefreshesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.InstanceRefreshIds != nil {
		objectKey := object.Key("InstanceRefreshIds")
		if err := awsAwsquery_serializeDocumentInstanceRefreshIds(v.InstanceRefreshIds, objectKey); err != nil {
			return err
		}
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.NextToken != nil {
		objectKey := object.Key("NextToken")
		objectKey.String(*v.NextToken)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeLaunchConfigurationsInput(v *DescribeLaunchConfigurationsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LaunchConfigurationNames != nil {
		objectKey := object.Key("LaunchConfigurationNames")
		if err := awsAwsquery_serializeDocumentLaunchConfigurationNames(v.LaunchConfigurationNames, objectKey); err != nil {
			return err
		}
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.NextToken != nil {
		objectKey := object.Key("NextToken")
		objectKey.String(*v.NextToken)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeLifecycleHooksInput(v *DescribeLifecycleHooksInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.LifecycleHookNames != nil {
		objectKey := object.Key("LifecycleHookNames")
		if err := awsAwsquery_serializeDocumentLifecycleHookNames(v.LifecycleHookNames, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeLoadBalancersInput(v *DescribeLoadBalancersInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.NextToken != nil {
		objectKey := object.Key("NextToken")
		objectKey.String(*v.NextToken)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeLoadBalancerTargetGroupsInput(v *DescribeLoadBalancerTargetGroupsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.NextToken != nil {
		objectKey := object.Key("NextToken")
		objectKey.String(*v.NextToken)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeNotificationConfigurationsInput(v *DescribeNotificationConfigurationsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupNames != nil {
		objectKey := object.Key("AutoScalingGroupNames")
		if err := awsAwsquery_serializeDocumentAutoScalingGroupNames(v.AutoScalingGroupNames, objectKey); err != nil {
			return err
		}
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.NextToken != nil {
		objectKey := object.Key("NextToken")
		objectKey.String(*v.NextToken)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribePoliciesInput(v *DescribePoliciesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.NextToken != nil {
		objectKey := object.Key("NextToken")
		objectKey.String(*v.NextToken)
	}

	if v.PolicyNames != nil {
		objectKey := object.Key("PolicyNames")
		if err := awsAwsquery_serializeDocumentPolicyNames(v.PolicyNames, objectKey); err != nil {
			return err
		}
	}

	if v.PolicyTypes != nil {
		objectKey := object.Key("PolicyTypes")
		if err := awsAwsquery_serializeDocumentPolicyTypes(v.PolicyTypes, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeScalingActivitiesInput(v *DescribeScalingActivitiesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ActivityIds != nil {
		objectKey := object.Key("ActivityIds")
		if err := awsAwsquery_serializeDocumentActivityIds(v.ActivityIds, objectKey); err != nil {
			return err
		}
	}

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.IncludeDeletedGroups != nil {
		objectKey := object.Key("IncludeDeletedGroups")
		objectKey.Boolean(*v.IncludeDeletedGroups)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.NextToken != nil {
		objectKey := object.Key("NextToken")
		objectKey.String(*v.NextToken)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeScheduledActionsInput(v *DescribeScheduledActionsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.EndTime != nil {
		objectKey := object.Key("EndTime")
		objectKey.String(smithytime.FormatDateTime(*v.EndTime))
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.NextToken != nil {
		objectKey := object.Key("NextToken")
		objectKey.String(*v.NextToken)
	}

	if v.ScheduledActionNames != nil {
		objectKey := object.Key("ScheduledActionNames")
		if err := awsAwsquery_serializeDocumentScheduledActionNames(v.ScheduledActionNames, objectKey); err != nil {
			return err
		}
	}

	if v.StartTime != nil {
		objectKey := object.Key("StartTime")
		objectKey.String(smithytime.FormatDateTime(*v.StartTime))
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeTagsInput(v *DescribeTagsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Filters != nil {
		objectKey := object.Key("Filters")
		if err := awsAwsquery_serializeDocumentFilters(v.Filters, objectKey); err != nil {
			return err
		}
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.NextToken != nil {
		objectKey := object.Key("NextToken")
		objectKey.String(*v.NextToken)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeTrafficSourcesInput(v *DescribeTrafficSourcesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.NextToken != nil {
		objectKey := object.Key("NextToken")
		objectKey.String(*v.NextToken)
	}

	if v.TrafficSourceType != nil {
		objectKey := object.Key("TrafficSourceType")
		objectKey.String(*v.TrafficSourceType)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeWarmPoolInput(v *DescribeWarmPoolInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.NextToken != nil {
		objectKey := object.Key("NextToken")
		objectKey.String(*v.NextToken)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDetachInstancesInput(v *DetachInstancesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.InstanceIds != nil {
		objectKey := object.Key("InstanceIds")
		if err := awsAwsquery_serializeDocumentInstanceIds(v.InstanceIds, objectKey); err != nil {
			return err
		}
	}

	if v.ShouldDecrementDesiredCapacity != nil {
		objectKey := object.Key("ShouldDecrementDesiredCapacity")
		objectKey.Boolean(*v.ShouldDecrementDesiredCapacity)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDetachLoadBalancersInput(v *DetachLoadBalancersInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.LoadBalancerNames != nil {
		objectKey := object.Key("LoadBalancerNames")
		if err := awsAwsquery_serializeDocumentLoadBalancerNames(v.LoadBalancerNames, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDetachLoadBalancerTargetGroupsInput(v *DetachLoadBalancerTargetGroupsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.TargetGroupARNs != nil {
		objectKey := object.Key("TargetGroupARNs")
		if err := awsAwsquery_serializeDocumentTargetGroupARNs(v.TargetGroupARNs, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDetachTrafficSourcesInput(v *DetachTrafficSourcesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.TrafficSources != nil {
		objectKey := object.Key("TrafficSources")
		if err := awsAwsquery_serializeDocumentTrafficSources(v.TrafficSources, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDisableMetricsCollectionInput(v *DisableMetricsCollectionInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.Metrics != nil {
		objectKey := object.Key("Metrics")
		if err := awsAwsquery_serializeDocumentMetrics(v.Metrics, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentEnableMetricsCollectionInput(v *EnableMetricsCollectionInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.Granularity != nil {
		objectKey := object.Key("Granularity")
		objectKey.String(*v.Granularity)
	}

	if v.Metrics != nil {
		objectKey := object.Key("Metrics")
		if err := awsAwsquery_serializeDocumentMetrics(v.Metrics, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentEnterStandbyInput(v *EnterStandbyInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.InstanceIds != nil {
		objectKey := object.Key("InstanceIds")
		if err := awsAwsquery_serializeDocumentInstanceIds(v.InstanceIds, objectKey); err != nil {
			return err
		}
	}

	if v.ShouldDecrementDesiredCapacity != nil {
		objectKey := object.Key("ShouldDecrementDesiredCapacity")
		objectKey.Boolean(*v.ShouldDecrementDesiredCapacity)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentExecutePolicyInput(v *ExecutePolicyInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.BreachThreshold != nil {
		objectKey := object.Key("BreachThreshold")
		switch {
		case math.IsNaN(*v.BreachThreshold):
			objectKey.String("NaN")

		case math.IsInf(*v.BreachThreshold, 1):
			objectKey.String("Infinity")

		case math.IsInf(*v.BreachThreshold, -1):
			objectKey.String("-Infinity")

		default:
			objectKey.Double(*v.BreachThreshold)

		}
	}

	if v.HonorCooldown != nil {
		objectKey := object.Key("HonorCooldown")
		objectKey.Boolean(*v.HonorCooldown)
	}

	if v.MetricValue != nil {
		objectKey := object.Key("MetricValue")
		switch {
		case math.IsNaN(*v.MetricValue):
			objectKey.String("NaN")

		case math.IsInf(*v.MetricValue, 1):
			objectKey.String("Infinity")

		case math.IsInf(*v.MetricValue, -1):
			objectKey.String("-Infinity")

		default:
			objectKey.Double(*v.MetricValue)

		}
	}

	if v.PolicyName != nil {
		objectKey := object.Key("PolicyName")
		objectKey.String(*v.PolicyName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentExitStandbyInput(v *ExitStandbyInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.InstanceIds != nil {
		objectKey := object.Key("InstanceIds")
		if err := awsAwsquery_serializeDocumentInstanceIds(v.InstanceIds, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentGetPredictiveScalingForecastInput(v *GetPredictiveScalingForecastInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.EndTime != nil {
		objectKey := object.Key("EndTime")
		objectKey.String(smithytime.FormatDateTime(*v.EndTime))
	}

	if v.PolicyName != nil {
		objectKey := object.Key("PolicyName")
		objectKey.String(*v.PolicyName)
	}

	if v.StartTime != nil {
		objectKey := object.Key("StartTime")
		objectKey.String(smithytime.FormatDateTime(*v.StartTime))
	}

	return nil
}

func awsAwsquery_serializeOpDocumentLaunchInstancesInput(v *LaunchInstancesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.AvailabilityZoneIds != nil {
		objectKey := object.Key("AvailabilityZoneIds")
		if err := awsAwsquery_serializeDocumentAvailabilityZoneIdsLimit1(v.AvailabilityZoneIds, objectKey); err != nil {
			return err
		}
	}

	if v.AvailabilityZones != nil {
		objectKey := object.Key("AvailabilityZones")
		if err := awsAwsquery_serializeDocumentAvailabilityZonesLimit1(v.AvailabilityZones, objectKey); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		objectKey := object.Key("ClientToken")
		objectKey.String(*v.ClientToken)
	}

	if v.RequestedCapacity != nil {
		objectKey := object.Key("RequestedCapacity")
		objectKey.Integer(*v.RequestedCapacity)
	}

	if len(v.RetryStrategy) > 0 {
		objectKey := object.Key("RetryStrategy")
		objectKey.String(string(v.RetryStrategy))
	}

	if v.SubnetIds != nil {
		objectKey := object.Key("SubnetIds")
		if err := awsAwsquery_serializeDocumentSubnetIdsLimit1(v.SubnetIds, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentPutLifecycleHookInput(v *PutLifecycleHookInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.DefaultResult != nil {
		objectKey := object.Key("DefaultResult")
		objectKey.String(*v.DefaultResult)
	}

	if v.HeartbeatTimeout != nil {
		objectKey := object.Key("HeartbeatTimeout")
		objectKey.Integer(*v.HeartbeatTimeout)
	}

	if v.LifecycleHookName != nil {
		objectKey := object.Key("LifecycleHookName")
		objectKey.String(*v.LifecycleHookName)
	}

	if v.LifecycleTransition != nil {
		objectKey := object.Key("LifecycleTransition")
		objectKey.String(*v.LifecycleTransition)
	}

	if v.NotificationMetadata != nil {
		objectKey := object.Key("NotificationMetadata")
		objectKey.String(*v.NotificationMetadata)
	}

	if v.NotificationTargetARN != nil {
		objectKey := object.Key("NotificationTargetARN")
		objectKey.String(*v.NotificationTargetARN)
	}

	if v.RoleARN != nil {
		objectKey := object.Key("RoleARN")
		objectKey.String(*v.RoleARN)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentPutNotificationConfigurationInput(v *PutNotificationConfigurationInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.NotificationTypes != nil {
		objectKey := object.Key("NotificationTypes")
		if err := awsAwsquery_serializeDocumentAutoScalingNotificationTypes(v.NotificationTypes, objectKey); err != nil {
			return err
		}
	}

	if v.TopicARN != nil {
		objectKey := object.Key("TopicARN")
		objectKey.String(*v.TopicARN)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentPutScalingPolicyInput(v *PutScalingPolicyInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AdjustmentType != nil {
		objectKey := object.Key("AdjustmentType")
		objectKey.String(*v.AdjustmentType)
	}

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.Cooldown != nil {
		objectKey := object.Key("Cooldown")
		objectKey.Integer(*v.Cooldown)
	}

	if v.Enabled != nil {
		objectKey := object.Key("Enabled")
		objectKey.Boolean(*v.Enabled)
	}

	if v.EstimatedInstanceWarmup != nil {
		objectKey := object.Key("EstimatedInstanceWarmup")
		objectKey.Integer(*v.EstimatedInstanceWarmup)
	}

	if v.MetricAggregationType != nil {
		objectKey := object.Key("MetricAggregationType")
		objectKey.String(*v.MetricAggregationType)
	}

	if v.MinAdjustmentMagnitude != nil {
		objectKey := object.Key("MinAdjustmentMagnitude")
		objectKey.Integer(*v.MinAdjustmentMagnitude)
	}

	if v.MinAdjustmentStep != nil {
		objectKey := object.Key("MinAdjustmentStep")
		objectKey.Integer(*v.MinAdjustmentStep)
	}

	if v.PolicyName != nil {
		objectKey := object.Key("PolicyName")
		objectKey.String(*v.PolicyName)
	}

	if v.PolicyType != nil {
		objectKey := object.Key("PolicyType")
		objectKey.String(*v.PolicyType)
	}

	if v.PredictiveScalingConfiguration != nil {
		objectKey := object.Key("PredictiveScalingConfiguration")
		if err := awsAwsquery_serializeDocumentPredictiveScalingConfiguration(v.PredictiveScalingConfiguration, objectKey); err != nil {
			return err
		}
	}

	if v.ScalingAdjustment != nil {
		objectKey := object.Key("ScalingAdjustment")
		objectKey.Integer(*v.ScalingAdjustment)
	}

	if v.StepAdjustments != nil {
		objectKey := object.Key("StepAdjustments")
		if err := awsAwsquery_serializeDocumentStepAdjustments(v.StepAdjustments, objectKey); err != nil {
			return err
		}
	}

	if v.TargetTrackingConfiguration != nil {
		objectKey := object.Key("TargetTrackingConfiguration")
		if err := awsAwsquery_serializeDocumentTargetTrackingConfiguration(v.TargetTrackingConfiguration, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentPutScheduledUpdateGroupActionInput(v *PutScheduledUpdateGroupActionInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.DesiredCapacity != nil {
		objectKey := object.Key("DesiredCapacity")
		objectKey.Integer(*v.DesiredCapacity)
	}

	if v.EndTime != nil {
		objectKey := object.Key("EndTime")
		objectKey.String(smithytime.FormatDateTime(*v.EndTime))
	}

	if v.MaxSize != nil {
		objectKey := object.Key("MaxSize")
		objectKey.Integer(*v.MaxSize)
	}

	if v.MinSize != nil {
		objectKey := object.Key("MinSize")
		objectKey.Integer(*v.MinSize)
	}

	if v.Recurrence != nil {
		objectKey := object.Key("Recurrence")
		objectKey.String(*v.Recurrence)
	}

	if v.ScheduledActionName != nil {
		objectKey := object.Key("ScheduledActionName")
		objectKey.String(*v.ScheduledActionName)
	}

	if v.StartTime != nil {
		objectKey := object.Key("StartTime")
		objectKey.String(smithytime.FormatDateTime(*v.StartTime))
	}

	if v.Time != nil {
		objectKey := object.Key("Time")
		objectKey.String(smithytime.FormatDateTime(*v.Time))
	}

	if v.TimeZone != nil {
		objectKey := object.Key("TimeZone")
		objectKey.String(*v.TimeZone)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentPutWarmPoolInput(v *PutWarmPoolInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.InstanceReusePolicy != nil {
		objectKey := object.Key("InstanceReusePolicy")
		if err := awsAwsquery_serializeDocumentInstanceReusePolicy(v.InstanceReusePolicy, objectKey); err != nil {
			return err
		}
	}

	if v.MaxGroupPreparedCapacity != nil {
		objectKey := object.Key("MaxGroupPreparedCapacity")
		objectKey.Integer(*v.MaxGroupPreparedCapacity)
	}

	if v.MinSize != nil {
		objectKey := object.Key("MinSize")
		objectKey.Integer(*v.MinSize)
	}

	if len(v.PoolState) > 0 {
		objectKey := object.Key("PoolState")
		objectKey.String(string(v.PoolState))
	}

	return nil
}

func awsAwsquery_serializeOpDocumentRecordLifecycleActionHeartbeatInput(v *RecordLifecycleActionHeartbeatInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	if v.LifecycleActionToken != nil {
		objectKey := object.Key("LifecycleActionToken")
		objectKey.String(*v.LifecycleActionToken)
	}

	if v.LifecycleHookName != nil {
		objectKey := object.Key("LifecycleHookName")
		objectKey.String(*v.LifecycleHookName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentResumeProcessesInput(v *ResumeProcessesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.ScalingProcesses != nil {
		objectKey := object.Key("ScalingProcesses")
		if err := awsAwsquery_serializeDocumentProcessNames(v.ScalingProcesses, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentRollbackInstanceRefreshInput(v *RollbackInstanceRefreshInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentSetDesiredCapacityInput(v *SetDesiredCapacityInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.DesiredCapacity != nil {
		objectKey := object.Key("DesiredCapacity")
		objectKey.Integer(*v.DesiredCapacity)
	}

	if v.HonorCooldown != nil {
		objectKey := object.Key("HonorCooldown")
		objectKey.Boolean(*v.HonorCooldown)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentSetInstanceHealthInput(v *SetInstanceHealthInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.HealthStatus != nil {
		objectKey := object.Key("HealthStatus")
		objectKey.String(*v.HealthStatus)
	}

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	if v.ShouldRespectGracePeriod != nil {
		objectKey := object.Key("ShouldRespectGracePeriod")
		objectKey.Boolean(*v.ShouldRespectGracePeriod)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentSetInstanceProtectionInput(v *SetInstanceProtectionInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.InstanceIds != nil {
		objectKey := object.Key("InstanceIds")
		if err := awsAwsquery_serializeDocumentInstanceIds(v.InstanceIds, objectKey); err != nil {
			return err
		}
	}

	if v.ProtectedFromScaleIn != nil {
		objectKey := object.Key("ProtectedFromScaleIn")
		objectKey.Boolean(*v.ProtectedFromScaleIn)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentStartInstanceRefreshInput(v *StartInstanceRefreshInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.DesiredConfiguration != nil {
		objectKey := object.Key("DesiredConfiguration")
		if err := awsAwsquery_serializeDocumentDesiredConfiguration(v.DesiredConfiguration, objectKey); err != nil {
			return err
		}
	}

	if v.Preferences != nil {
		objectKey := object.Key("Preferences")
		if err := awsAwsquery_serializeDocumentRefreshPreferences(v.Preferences, objectKey); err != nil {
			return err
		}
	}

	if len(v.Strategy) > 0 {
		objectKey := object.Key("Strategy")
		objectKey.String(string(v.Strategy))
	}

	return nil
}

func awsAwsquery_serializeOpDocumentSuspendProcessesInput(v *SuspendProcessesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.ScalingProcesses != nil {
		objectKey := object.Key("ScalingProcesses")
		if err := awsAwsquery_serializeDocumentProcessNames(v.ScalingProcesses, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentTerminateInstanceInAutoScalingGroupInput(v *TerminateInstanceInAutoScalingGroupInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	if v.ShouldDecrementDesiredCapacity != nil {
		objectKey := object.Key("ShouldDecrementDesiredCapacity")
		objectKey.Boolean(*v.ShouldDecrementDesiredCapacity)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentUpdateAutoScalingGroupInput(v *UpdateAutoScalingGroupInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.AvailabilityZoneDistribution != nil {
		objectKey := object.Key("AvailabilityZoneDistribution")
		if err := awsAwsquery_serializeDocumentAvailabilityZoneDistribution(v.AvailabilityZoneDistribution, objectKey); err != nil {
			return err
		}
	}

	if v.AvailabilityZoneImpairmentPolicy != nil {
		objectKey := object.Key("AvailabilityZoneImpairmentPolicy")
		if err := awsAwsquery_serializeDocumentAvailabilityZoneImpairmentPolicy(v.AvailabilityZoneImpairmentPolicy, objectKey); err != nil {
			return err
		}
	}

	if v.AvailabilityZones != nil {
		objectKey := object.Key("AvailabilityZones")
		if err := awsAwsquery_serializeDocumentAvailabilityZones(v.AvailabilityZones, objectKey); err != nil {
			return err
		}
	}

	if v.CapacityRebalance != nil {
		objectKey := object.Key("CapacityRebalance")
		objectKey.Boolean(*v.CapacityRebalance)
	}

	if v.CapacityReservationSpecification != nil {
		objectKey := object.Key("CapacityReservationSpecification")
		if err := awsAwsquery_serializeDocumentCapacityReservationSpecification(v.CapacityReservationSpecification, objectKey); err != nil {
			return err
		}
	}

	if v.Context != nil {
		objectKey := object.Key("Context")
		objectKey.String(*v.Context)
	}

	if v.DefaultCooldown != nil {
		objectKey := object.Key("DefaultCooldown")
		objectKey.Integer(*v.DefaultCooldown)
	}

	if v.DefaultInstanceWarmup != nil {
		objectKey := object.Key("DefaultInstanceWarmup")
		objectKey.Integer(*v.DefaultInstanceWarmup)
	}

	if v.DesiredCapacity != nil {
		objectKey := object.Key("DesiredCapacity")
		objectKey.Integer(*v.DesiredCapacity)
	}

	if v.DesiredCapacityType != nil {
		objectKey := object.Key("DesiredCapacityType")
		objectKey.String(*v.DesiredCapacityType)
	}

	if v.HealthCheckGracePeriod != nil {
		objectKey := object.Key("HealthCheckGracePeriod")
		objectKey.Integer(*v.HealthCheckGracePeriod)
	}

	if v.HealthCheckType != nil {
		objectKey := object.Key("HealthCheckType")
		objectKey.String(*v.HealthCheckType)
	}

	if v.InstanceLifecyclePolicy != nil {
		objectKey := object.Key("InstanceLifecyclePolicy")
		if err := awsAwsquery_serializeDocumentInstanceLifecyclePolicy(v.InstanceLifecyclePolicy, objectKey); err != nil {
			return err
		}
	}

	if v.InstanceMaintenancePolicy != nil {
		objectKey := object.Key("InstanceMaintenancePolicy")
		if err := awsAwsquery_serializeDocumentInstanceMaintenancePolicy(v.InstanceMaintenancePolicy, objectKey); err != nil {
			return err
		}
	}

	if v.LaunchConfigurationName != nil {
		objectKey := object.Key("LaunchConfigurationName")
		objectKey.String(*v.LaunchConfigurationName)
	}

	if v.LaunchTemplate != nil {
		objectKey := object.Key("LaunchTemplate")
		if err := awsAwsquery_serializeDocumentLaunchTemplateSpecification(v.LaunchTemplate, objectKey); err != nil {
			return err
		}
	}

	if v.MaxInstanceLifetime != nil {
		objectKey := object.Key("MaxInstanceLifetime")
		objectKey.Integer(*v.MaxInstanceLifetime)
	}

	if v.MaxSize != nil {
		objectKey := object.Key("MaxSize")
		objectKey.Integer(*v.MaxSize)
	}

	if v.MinSize != nil {
		objectKey := object.Key("MinSize")
		objectKey.Integer(*v.MinSize)
	}

	if v.MixedInstancesPolicy != nil {
		objectKey := object.Key("MixedInstancesPolicy")
		if err := awsAwsquery_serializeDocumentMixedInstancesPolicy(v.MixedInstancesPolicy, objectKey); err != nil {
			return err
		}
	}

	if v.NewInstancesProtectedFromScaleIn != nil {
		objectKey := object.Key("NewInstancesProtectedFromScaleIn")
		objectKey.Boolean(*v.NewInstancesProtectedFromScaleIn)
	}

	if v.PlacementGroup != nil {
		objectKey := object.Key("PlacementGroup")
		objectKey.String(*v.PlacementGroup)
	}

	if v.ServiceLinkedRoleARN != nil {
		objectKey := object.Key("ServiceLinkedRoleARN")
		objectKey.String(*v.ServiceLinkedRoleARN)
	}

	if v.SkipZonalShiftValidation != nil {
		objectKey := object.Key("SkipZonalShiftValidation")
		objectKey.Boolean(*v.SkipZonalShiftValidation)
	}

	if v.TerminationPolicies != nil {
		objectKey := object.Key("TerminationPolicies")
		if err := awsAwsquery_serializeDocumentTerminationPolicies(v.TerminationPolicies, objectKey); err != nil {
			return err
		}
	}

	if v.VPCZoneIdentifier != nil {
		objectKey := object.Key("VPCZoneIdentifier")
		objectKey.String(*v.VPCZoneIdentifier)
	}

	return nil
}
