// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudwatchlogs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new Scheduled Query that runs CloudWatch Logs Insights queries on a
// schedule and delivers results to specified destinations.
func (c *Client) CreateScheduledQuery(ctx context.Context, params *CreateScheduledQueryInput, optFns ...func(*Options)) (*CreateScheduledQueryOutput, error) {
	if params == nil {
		params = &CreateScheduledQueryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateScheduledQuery", params, optFns, c.addOperationCreateScheduledQueryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateScheduledQueryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateScheduledQueryInput struct {

	// The Amazon Resource Name (ARN) of the IAM role that CloudWatch Logs will assume
	// to execute the scheduled query and deliver results to the specified
	// destinations.
	//
	// This member is required.
	ExecutionRoleArn *string

	// A unique name for the scheduled query within the region for an AWS account. The
	// name can contain letters, numbers, underscores, hyphens, forward slashes,
	// periods, and hash symbols.
	//
	// This member is required.
	Name *string

	// The query language to use for the scheduled query. Valid values are LogsQL
	// (CloudWatch Logs Insights query language), PPL (OpenSearch Service Piped
	// Processing Language), and SQL (OpenSearch Service Structured Query Language).
	//
	// This member is required.
	QueryLanguage types.QueryLanguage

	// The CloudWatch Logs Insights query string to execute. This is the actual query
	// that will be run against your log data on the specified schedule.
	//
	// This member is required.
	QueryString *string

	// A cron expression that defines when the scheduled query runs. The format is
	// cron(fields) where fields consist of six space-separated values: minutes, hours,
	// day_of_month, month, day_of_week, year.
	//
	// This member is required.
	ScheduleExpression *string

	// An optional description for the scheduled query to help identify its purpose.
	Description *string

	// Configuration for destinations where the query results will be delivered after
	// successful execution. You can configure delivery to S3 buckets or EventBridge
	// event buses.
	DestinationConfiguration *types.DestinationConfiguration

	// The log group identifiers to query. You can specify log group names or log
	// group ARNs. If querying log groups in a source account from a monitoring
	// account, you must specify the ARN of the log group.
	LogGroupIdentifiers []string

	// The end time for the query schedule in Unix epoch time (seconds since January
	// 1, 1970, 00:00:00 UTC). If not specified, the schedule runs indefinitely.
	ScheduleEndTime *int64

	// The start time for the query schedule in Unix epoch time (seconds since January
	// 1, 1970, 00:00:00 UTC). If not specified, the schedule starts immediately.
	ScheduleStartTime *int64

	// Time offset in seconds from the execution time for the start of the query time
	// range. This defines the lookback period for the query (for example, 3600 for the
	// last hour).
	StartTimeOffset *int64

	// The initial state of the scheduled query. Valid values are ENABLED (the query
	// will run according to its schedule) and DISABLED (the query is paused and will
	// not run). If not provided, defaults to ENABLED.
	State types.ScheduledQueryState

	// An optional list of key-value pairs to associate with the resource.
	//
	// For more information about tagging, see [Tagging Amazon Web Services resources]
	//
	// [Tagging Amazon Web Services resources]: https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html
	Tags map[string]string

	// The timezone in which the schedule expression is evaluated. If not provided,
	// defaults to UTC.
	Timezone *string

	noSmithyDocumentSerde
}

type CreateScheduledQueryOutput struct {

	// The Amazon Resource Name (ARN) of the created scheduled query.
	ScheduledQueryArn *string

	// The current state of the scheduled query (ENABLED or DISABLED).
	State types.ScheduledQueryState

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateScheduledQueryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateScheduledQuery{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateScheduledQuery{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateScheduledQuery"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateScheduledQueryValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateScheduledQuery(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateScheduledQuery(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateScheduledQuery",
	}
}
