﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/inspector2/Inspector2_EXPORTS.h>

namespace Aws {
namespace Inspector2 {
namespace Model {
enum class EcrRescanDurationStatus { NOT_SET, SUCCESS, PENDING, FAILED };

namespace EcrRescanDurationStatusMapper {
AWS_INSPECTOR2_API EcrRescanDurationStatus GetEcrRescanDurationStatusForName(const Aws::String& name);

AWS_INSPECTOR2_API Aws::String GetNameForEcrRescanDurationStatus(EcrRescanDurationStatus value);
}  // namespace EcrRescanDurationStatusMapper
}  // namespace Model
}  // namespace Inspector2
}  // namespace Aws
