﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/neptune-graph/NeptuneGraph_EXPORTS.h>
#include <aws/neptune-graph/model/Format.h>
#include <aws/neptune-graph/model/ImportTaskStatus.h>
#include <aws/neptune-graph/model/ParquetType.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace NeptuneGraph {
namespace Model {
class CancelImportTaskResult {
 public:
  AWS_NEPTUNEGRAPH_API CancelImportTaskResult() = default;
  AWS_NEPTUNEGRAPH_API CancelImportTaskResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_NEPTUNEGRAPH_API CancelImportTaskResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The unique identifier of the Neptune Analytics graph.</p>
   */
  inline const Aws::String& GetGraphId() const { return m_graphId; }
  template <typename GraphIdT = Aws::String>
  void SetGraphId(GraphIdT&& value) {
    m_graphIdHasBeenSet = true;
    m_graphId = std::forward<GraphIdT>(value);
  }
  template <typename GraphIdT = Aws::String>
  CancelImportTaskResult& WithGraphId(GraphIdT&& value) {
    SetGraphId(std::forward<GraphIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier of the import task.</p>
   */
  inline const Aws::String& GetTaskId() const { return m_taskId; }
  template <typename TaskIdT = Aws::String>
  void SetTaskId(TaskIdT&& value) {
    m_taskIdHasBeenSet = true;
    m_taskId = std::forward<TaskIdT>(value);
  }
  template <typename TaskIdT = Aws::String>
  CancelImportTaskResult& WithTaskId(TaskIdT&& value) {
    SetTaskId(std::forward<TaskIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A URL identifying to the location of the data to be imported. This can be an
   * Amazon S3 path, or can point to a Neptune database endpoint or snapshot.</p>
   */
  inline const Aws::String& GetSource() const { return m_source; }
  template <typename SourceT = Aws::String>
  void SetSource(SourceT&& value) {
    m_sourceHasBeenSet = true;
    m_source = std::forward<SourceT>(value);
  }
  template <typename SourceT = Aws::String>
  CancelImportTaskResult& WithSource(SourceT&& value) {
    SetSource(std::forward<SourceT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies the format of S3 data to be imported. Valid values are
   * <code>CSV</code>, which identifies the <a
   * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html">Gremlin
   * CSV format</a> or <code>OPENCYPHER</code>, which identies the <a
   * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html">openCypher
   * load format</a>.</p>
   */
  inline Format GetFormat() const { return m_format; }
  inline void SetFormat(Format value) {
    m_formatHasBeenSet = true;
    m_format = value;
  }
  inline CancelImportTaskResult& WithFormat(Format value) {
    SetFormat(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The parquet type of the cancelled import task.</p>
   */
  inline ParquetType GetParquetType() const { return m_parquetType; }
  inline void SetParquetType(ParquetType value) {
    m_parquetTypeHasBeenSet = true;
    m_parquetType = value;
  }
  inline CancelImportTaskResult& WithParquetType(ParquetType value) {
    SetParquetType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the IAM role that will allow access to the data that is to be
   * imported.</p>
   */
  inline const Aws::String& GetRoleArn() const { return m_roleArn; }
  template <typename RoleArnT = Aws::String>
  void SetRoleArn(RoleArnT&& value) {
    m_roleArnHasBeenSet = true;
    m_roleArn = std::forward<RoleArnT>(value);
  }
  template <typename RoleArnT = Aws::String>
  CancelImportTaskResult& WithRoleArn(RoleArnT&& value) {
    SetRoleArn(std::forward<RoleArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Current status of the task. Status is CANCELLING when the import task is
   * cancelled.</p>
   */
  inline ImportTaskStatus GetStatus() const { return m_status; }
  inline void SetStatus(ImportTaskStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline CancelImportTaskResult& WithStatus(ImportTaskStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CancelImportTaskResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_graphId;

  Aws::String m_taskId;

  Aws::String m_source;

  Format m_format{Format::NOT_SET};

  ParquetType m_parquetType{ParquetType::NOT_SET};

  Aws::String m_roleArn;

  ImportTaskStatus m_status{ImportTaskStatus::NOT_SET};

  Aws::String m_requestId;
  bool m_graphIdHasBeenSet = false;
  bool m_taskIdHasBeenSet = false;
  bool m_sourceHasBeenSet = false;
  bool m_formatHasBeenSet = false;
  bool m_parquetTypeHasBeenSet = false;
  bool m_roleArnHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace NeptuneGraph
}  // namespace Aws
