/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components.resizer;

import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.resizer.OneTouchCollapseResizer;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.IMapViewManager;

public class UIComponentVisibilityDispatcher {
    private static String DISPATCHER_CLIENT_PROPERTY_NAME = UIComponentVisibilityDispatcher.class.getName() + ".KEY";
    private final String propertyBaseName;
    private final JComponent component;
    private OneTouchCollapseResizer resizer;

    public void setResizer(OneTouchCollapseResizer resizer) {
        this.resizer = resizer;
    }

    public static UIComponentVisibilityDispatcher install(JComponent component, String propertyBaseName) {
        UIComponentVisibilityDispatcher dispatcher = new UIComponentVisibilityDispatcher(component, propertyBaseName);
        component.putClientProperty(DISPATCHER_CLIENT_PROPERTY_NAME, dispatcher);
        return dispatcher;
    }

    public static void uninstall(JComponent component) {
        component.putClientProperty(DISPATCHER_CLIENT_PROPERTY_NAME, null);
    }

    public static UIComponentVisibilityDispatcher of(JComponent component) {
        return (UIComponentVisibilityDispatcher)component.getClientProperty(DISPATCHER_CLIENT_PROPERTY_NAME);
    }

    private UIComponentVisibilityDispatcher(JComponent component, String propertyBaseName) {
        this.component = component;
        this.propertyBaseName = propertyBaseName;
    }

    private String completeVisiblePropertyName() {
        String completeKeyString = this.isContainedInFullScreenWindow() ? this.propertyBaseName + ".fullscreen" : this.propertyBaseName;
        return completeKeyString;
    }

    private boolean isContainedInFullScreenWindow() {
        JRootPane rootPane = this.component.getRootPane();
        return rootPane != null && Boolean.TRUE.equals(rootPane.getClientProperty("fullscreen_enabled"));
    }

    public void toggleVisibility() {
        ResourceController resourceController = ResourceController.getResourceController();
        boolean wasVisible = resourceController.getBooleanProperty(this.getPropertyName());
        this.setVisible(!wasVisible);
    }

    public void setVisible(boolean visible) {
        this.setProperty(visible);
        this.makeComponentVisible(visible);
        Container parent = this.component.getParent();
        if (parent != null) {
            ((JComponent)parent).revalidate();
        }
        if (!visible) {
            IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
            mapViewManager.moveFocusFromDescendantToSelection(this.component);
        }
    }

    void setProperty(boolean visible) {
        ResourceController resourceController = ResourceController.getResourceController();
        resourceController.setProperty(this.getPropertyName(), visible);
    }

    private void makeComponentVisible(boolean visible) {
        if (this.resizer == null) {
            this.component.setVisible(visible);
        } else {
            boolean containedInFullWindow = this.isContainedInFullScreenWindow();
            if (visible || !containedInFullWindow || containedInFullWindow && !visible) {
                this.resizer.setVisible(visible || !containedInFullWindow);
            }
            this.resizer.setExpanded(visible);
        }
    }

    public String getPropertyName() {
        return this.completeVisiblePropertyName();
    }

    public String getPropertyBaseName() {
        return this.propertyBaseName;
    }

    public boolean isVisible() {
        String completeKeyString = this.completeVisiblePropertyName();
        if (completeKeyString == null) {
            return true;
        }
        return !"false".equals(ResourceController.getResourceController().getProperty(completeKeyString, "true"));
    }

    public void resetVisible() {
        this.setVisible(this.isVisible());
    }
}

