/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import java.net.MalformedURLException;
import java.net.URL;
import org.freeplane.core.util.Compat;
import org.freeplane.features.icon.MindIcon;

public class EmojiIcon
extends MindIcon {
    private static final String VERSION = "12.1.4";
    private static final String RESOURCE_IMAGE_PATH = "/images/emoji";
    private static final String REMOTE_IMAGE_PATH = "https://twemoji.maxcdn.com/v/12.1.4/svg/";
    private static final boolean areResourcesAvailable = !Compat.isApplet();
    final String emoji;

    public EmojiIcon(String emoji, String entity, String file, String description, int order) {
        super(EmojiIcon.entityName(entity), file, description, order);
        if (areResourcesAvailable) {
            this.initializeUrl();
        }
        this.emoji = emoji;
    }

    public static String entityName(String entity) {
        return "emoji-" + entity.replace(' ', '-');
    }

    @Override
    public String getImagePath() {
        return RESOURCE_IMAGE_PATH;
    }

    @Override
    public URL getUrl() {
        if (!areResourcesAvailable) {
            try {
                return new URL(REMOTE_IMAGE_PATH + this.getFile());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return super.getUrl();
    }

    @Override
    public String getTranslatedDescription() {
        String key = this.getDescriptionTranslationKey();
        return key;
    }
}

