/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.task;

import com.amazon.randomcutforest.config.ForestMode;
import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.opensearch.ad.ml.ADColdStart;
import org.opensearch.ad.model.ADTask;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.timeseries.ml.ModelColdStart;
import org.opensearch.timeseries.model.Entity;

public class ADBatchTaskCache {
    private final String detectorId;
    private final String taskId;
    private final String detectorTaskId;
    private ThresholdedRandomCutForest rcfModel;
    private boolean thresholdModelTrained;
    private AtomicInteger thresholdModelTrainingDataSize = new AtomicInteger(0);
    private AtomicBoolean cancelled = new AtomicBoolean(false);
    private AtomicLong cacheMemorySize = new AtomicLong(0L);
    private String cancelReason;
    private String cancelledBy;
    private Entity entity;

    protected ADBatchTaskCache(ADTask adTask) {
        this.detectorId = adTask.getConfigId();
        this.taskId = adTask.getTaskId();
        this.detectorTaskId = adTask.getConfigLevelTaskId();
        this.entity = adTask.getEntity();
        AnomalyDetector detector = adTask.getDetector();
        int numberOfTrees = 50;
        int shingleSize = detector.getShingleSize();
        int dimensions = detector.getShingleSize() * detector.getEnabledFeatureIds().size();
        ThresholdedRandomCutForest.Builder rcfBuilder = ThresholdedRandomCutForest.builder().dimensions(dimensions).numberOfTrees(numberOfTrees).timeDecay(detector.getTimeDecay().doubleValue()).sampleSize(256).outputAfter(32).initialAcceptFraction(0.125).parallelExecutionEnabled(false).compact(true).precision(Precision.FLOAT_32).boundingBoxCacheFraction(1.0).shingleSize(shingleSize).anomalyRate(0.0050000000000000044).transformMethod(TransformMethod.NORMALIZE).alertOnce(true).autoAdjust(true).internalShinglingEnabled(true);
        if (shingleSize > 1) {
            rcfBuilder.forestMode(ForestMode.STREAMING_IMPUTE);
            rcfBuilder = ModelColdStart.applyImputationMethod(detector, rcfBuilder);
        } else {
            rcfBuilder.forestMode(ForestMode.STANDARD);
        }
        ADColdStart.applyRule(rcfBuilder, detector);
        this.rcfModel = rcfBuilder.build();
        this.thresholdModelTrained = false;
    }

    protected String getId() {
        return this.detectorId;
    }

    protected String getTaskId() {
        return this.taskId;
    }

    protected String getDetectorTaskId() {
        return this.detectorTaskId;
    }

    protected ThresholdedRandomCutForest getTRcfModel() {
        return this.rcfModel;
    }

    protected void setThresholdModelTrained(boolean thresholdModelTrained) {
        this.thresholdModelTrained = thresholdModelTrained;
    }

    protected boolean isThresholdModelTrained() {
        return this.thresholdModelTrained;
    }

    public AtomicInteger getThresholdModelTrainingDataSize() {
        return this.thresholdModelTrainingDataSize;
    }

    protected AtomicLong getCacheMemorySize() {
        return this.cacheMemorySize;
    }

    protected boolean isCancelled() {
        return this.cancelled.get();
    }

    protected String getCancelReason() {
        return this.cancelReason;
    }

    protected String getCancelledBy() {
        return this.cancelledBy;
    }

    public Entity getEntity() {
        return this.entity;
    }

    protected void cancel(String reason, String userName) {
        this.cancelled.compareAndSet(false, true);
        this.cancelReason = reason;
        this.cancelledBy = userName;
    }
}

