/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.opensearch.common.geo.GeoBoundingBox;
import org.opensearch.geo.search.aggregations.bucket.geogrid.GeoGridAggregatorSupplier;
import org.opensearch.geo.search.aggregations.bucket.geogrid.cells.CellIdSource;
import org.opensearch.geospatial.search.aggregations.bucket.geogrid.GeoHexGrid;
import org.opensearch.geospatial.search.aggregations.bucket.geogrid.GeoHexGridAggregationBuilder;
import org.opensearch.geospatial.search.aggregations.bucket.geogrid.GeoHexGridAggregator;
import org.opensearch.geospatial.search.aggregations.bucket.geogrid.GeoHexHelper;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.AggregatorFactory;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.NonCollectingAggregator;
import org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.aggregations.support.ValuesSourceRegistry;
import org.opensearch.search.aggregations.support.ValuesSourceType;
import org.opensearch.search.internal.SearchContext;

public class GeoHexGridAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final int precision;
    private final int requiredSize;
    private final int shardSize;
    private final GeoBoundingBox geoBoundingBox;

    GeoHexGridAggregatorFactory(String name, ValuesSourceConfig config, int precision, int requiredSize, int shardSize, GeoBoundingBox geoBoundingBox, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.precision = precision;
        this.requiredSize = requiredSize;
        this.shardSize = shardSize;
        this.geoBoundingBox = geoBoundingBox;
    }

    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator aggregator, Map<String, Object> map) throws IOException {
        final GeoHexGrid aggregation = new GeoHexGrid(this.name, this.requiredSize, List.of(), this.metadata);
        return new NonCollectingAggregator(this, this.name, searchContext, aggregator, this.factories, this.metadata){

            public InternalAggregation buildEmptyAggregation() {
                return aggregation;
            }
        };
    }

    protected Aggregator doCreateInternal(SearchContext searchContext, Aggregator aggregator, CardinalityUpperBound cardinalityUpperBound, Map<String, Object> map) throws IOException {
        return ((GeoGridAggregatorSupplier)this.queryShardContext.getValuesSourceRegistry().getAggregator(GeoHexGridAggregationBuilder.REGISTRY_KEY, this.config)).build(this.name, this.factories, this.config.getValuesSource(), this.precision, this.geoBoundingBox, this.requiredSize, this.shardSize, searchContext, aggregator, cardinalityUpperBound, this.metadata);
    }

    static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(GeoHexGridAggregationBuilder.REGISTRY_KEY, (ValuesSourceType)CoreValuesSourceType.GEOPOINT, (name, factories, valuesSource, precision, geoBoundingBox, requiredSize, shardSize, aggregationContext, parent, cardinality, metadata) -> {
            CellIdSource cellIdSource = new CellIdSource((ValuesSource.GeoPoint)valuesSource, precision, geoBoundingBox, GeoHexHelper::longEncode);
            return new GeoHexGridAggregator(name, factories, (ValuesSource.Numeric)cellIdSource, requiredSize, shardSize, aggregationContext, parent, cardinality, metadata);
        }, true);
    }
}

