/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.transform;

import org.opensearch.notifications.core.repackage.com.amazonaws.DefaultRequest;
import org.opensearch.notifications.core.repackage.com.amazonaws.Request;
import org.opensearch.notifications.core.repackage.com.amazonaws.SdkClientException;
import org.opensearch.notifications.core.repackage.com.amazonaws.http.HttpMethodName;
import org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.DeliveryOptions;
import org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.PutConfigurationSetDeliveryOptionsRequest;
import org.opensearch.notifications.core.repackage.com.amazonaws.transform.Marshaller;
import org.opensearch.notifications.core.repackage.com.amazonaws.util.StringUtils;

public class PutConfigurationSetDeliveryOptionsRequestMarshaller
implements Marshaller<Request<PutConfigurationSetDeliveryOptionsRequest>, PutConfigurationSetDeliveryOptionsRequest> {
    @Override
    public Request<PutConfigurationSetDeliveryOptionsRequest> marshall(PutConfigurationSetDeliveryOptionsRequest putConfigurationSetDeliveryOptionsRequest) {
        DeliveryOptions deliveryOptions;
        if (putConfigurationSetDeliveryOptionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutConfigurationSetDeliveryOptionsRequest> request = new DefaultRequest<PutConfigurationSetDeliveryOptionsRequest>(putConfigurationSetDeliveryOptionsRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "PutConfigurationSetDeliveryOptions");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putConfigurationSetDeliveryOptionsRequest.getConfigurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringUtils.fromString(putConfigurationSetDeliveryOptionsRequest.getConfigurationSetName()));
        }
        if ((deliveryOptions = putConfigurationSetDeliveryOptionsRequest.getDeliveryOptions()) != null && deliveryOptions.getTlsPolicy() != null) {
            request.addParameter("DeliveryOptions.TlsPolicy", StringUtils.fromString(deliveryOptions.getTlsPolicy()));
        }
        return request;
    }
}

