/* number.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from number.vala, do not modify */

/*
 * Copyright (C) 1987-2008 Sun Microsystems, Inc. All Rights Reserved.
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/*  This maths library is based on the MP multi-precision floating-point
 *  arithmetic package originally written in FORTRAN by Richard Brent,
 *  Computer Centre, Australian National University in the 1970's.
 *
 *  It has been converted from FORTRAN into C using the freely available
 *  f2c translator, available via netlib on research.att.com.
 *
 *  The subsequently converted C code has then been tidied up, mainly to
 *  remove any dependencies on the libI77 and libF77 support libraries.
 *
 *  FOR A GENERAL DESCRIPTION OF THE PHILOSOPHY AND DESIGN OF MP,
 *  SEE - R. P. BRENT, A FORTRAN MULTIPLE-PRECISION ARITHMETIC
 *  SOME ADDITIONAL DETAILS ARE GIVEN IN THE SAME ISSUE, 71-81.
 *  FOR DETAILS OF THE IMPLEMENTATION, CALLING SEQUENCES ETC. SEE
 *  THE MP USERS GUIDE.
 */

#include <glib.h>
#include "calculator.h"
#include "mpc.h"
#include "mpfr.h"
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include "mpfrg.h"
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef gint (*BitwiseFunc) (gint v1, gint v2, gpointer user_data);
enum  {
	NUMBER_0_PROPERTY,
	NUMBER_NUM_PROPERTIES
};
static GParamSpec* number_properties[NUMBER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _NumberPrivate {
	__mpc_struct num;
	gboolean force_float;
	gboolean finite;
};

struct _Block2Data {
	int _ref_count_;
	GPtrArray* self;
	GCompareFunc compare_func;
};

static gint Number_private_offset;
static gpointer number_parent_class = NULL;
static mpfr_prec_t number__precision;
static mpfr_prec_t number__precision = (mpfr_prec_t) 1000;
static gchar* number__error;
static gchar* number__error = NULL;

static void number_mpc_from_radians (__mpc_struct* res,
                              __mpc_struct* op,
                              AngleUnit unit);
static Number* number_copy (Number* self);
static void number_mpc_to_radians (__mpc_struct* res,
                            __mpc_struct* op,
                            AngleUnit unit);
static Number* number_bitwise (Number* self,
                        Number* y,
                        BitwiseFunc bitwise_operator,
                        gpointer bitwise_operator_target,
                        gint wordlen);
static gint __lambda4_ (Number* self,
                 gint v1,
                 gint v2);
static gint ___lambda4__bitwise_func (gint v1,
                               gint v2,
                               gpointer self);
static gint __lambda5_ (Number* self,
                 gint v1,
                 gint v2);
static gint ___lambda5__bitwise_func (gint v1,
                               gint v2,
                               gpointer self);
static gint __lambda7_ (Number* self,
                 gint v1,
                 gint v2);
static gint ___lambda7__bitwise_func (gint v1,
                               gint v2,
                               gpointer self);
static gint __lambda8_ (Number* self,
                 gint v1,
                 gint v2);
static gint ___lambda8__bitwise_func (gint v1,
                               gint v2,
                               gpointer self);
static gint __lambda9_ (Number* self,
                 gint v1,
                 gint v2);
static gint ___lambda9__bitwise_func (gint v1,
                               gint v2,
                               gpointer self);
static gint __lambda10_ (Number* self,
                  gint v1,
                  gint v2);
static gint ___lambda10__bitwise_func (gint v1,
                                gint v2,
                                gpointer self);
static gint __lambda6_ (Number* self,
                 gint v1,
                 gint v2);
static gint ___lambda6__bitwise_func (gint v1,
                               gint v2,
                               gpointer self);
static gboolean number_can_shift (Number* self,
                           Number* count,
                           gint wordlen);
static gint __lambda11_ (Number* self,
                  gint v1,
                  gint v2);
static gint ___lambda11__bitwise_func (gint v1,
                                gint v2,
                                gpointer self);
static Number* number_gcd_x_y (Number* x,
                        Number* y);
static Number* number_lcm_x_y (Number* x,
                        Number* y);
static void _g_object_unref0_ (gpointer var);
static Number** _vala_array_dup12 (Number** self,
                            gssize length);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gint ___lambda0__gcompare_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self);
static gint __lambda12_ (Number* a,
                  Number* b);
static gint ___lambda12__gcompare_func (gconstpointer a,
                                 gconstpointer b);
static gboolean number_is_sprp (Number* self,
                         Number* p,
                         guint64 b);
static gboolean number_is_prime (Number* self,
                          Number* x);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static gboolean _mpc_equal (const __mpc_struct * s1,
                     const __mpc_struct * s2);
static gchar* number_to_hex_string (Number* self);
static gint number_hex_to_int (Number* self,
                        gchar digit);
static void number_finalize (GObject * obj);
static GType number_get_type_once (void);
static void _vala_number_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec);
static void _vala_number_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec);
VALA_EXTERN Number* set_from_sexagesimal (const gchar* s);
VALA_EXTERN gint parse_literal_prefix (const gchar* str,
                           gint* prefix_len);
VALA_EXTERN gint char_val (gunichar c,
               gint number_base);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

 G_GNUC_NO_INLINE static GType
angle_unit_get_type_once (void)
{
	static const GEnumValue values[] = {{ANGLE_UNIT_RADIANS, "ANGLE_UNIT_RADIANS", "radians"}, {ANGLE_UNIT_DEGREES, "ANGLE_UNIT_DEGREES", "degrees"}, {ANGLE_UNIT_GRADIANS, "ANGLE_UNIT_GRADIANS", "gradians"}, {0, NULL, NULL}};
	GType angle_unit_type_id;
	angle_unit_type_id = g_enum_register_static ("AngleUnit", values);
	return angle_unit_type_id;
}

GType
angle_unit_get_type (void)
{
	static gsize angle_unit_type_id__once = 0;
	if (g_once_init_enter (&angle_unit_type_id__once)) {
		GType angle_unit_type_id;
		angle_unit_type_id = angle_unit_get_type_once ();
		g_once_init_leave (&angle_unit_type_id__once, angle_unit_type_id);
	}
	return angle_unit_type_id__once;
}

static inline gpointer
number_get_instance_private (Number* self)
{
	return G_STRUCT_MEMBER_P (self, Number_private_offset);
}

Number*
number_construct_integer (GType object_type,
                          gint64 real,
                          gint64 imag)
{
	Number * self = NULL;
	self = (Number*) g_object_new (object_type, NULL);
	mpc_set_si_si (&self->priv->num, (glong) real, (glong) imag, MPC_RNDNN);
	return self;
}

Number*
number_new_integer (gint64 real,
                    gint64 imag)
{
	return number_construct_integer (TYPE_NUMBER, real, imag);
}

Number*
number_construct_unsigned_integer (GType object_type,
                                   guint64 real,
                                   guint64 imag)
{
	Number * self = NULL;
	self = (Number*) g_object_new (object_type, NULL);
	mpc_set_ui_ui (&self->priv->num, (gulong) real, (gulong) imag, MPC_RNDNN);
	return self;
}

Number*
number_new_unsigned_integer (guint64 real,
                             guint64 imag)
{
	return number_construct_unsigned_integer (TYPE_NUMBER, real, imag);
}

Number*
number_construct_fraction (GType object_type,
                           gint64 numerator,
                           gint64 denominator)
{
	Number * self = NULL;
	if (denominator < ((gint64) 0)) {
		numerator = -numerator;
		denominator = -denominator;
	}
	self = (Number*) number_construct_integer (object_type, numerator, (gint64) 0);
	if (denominator != ((gint64) 1)) {
		mpc_div_ui (&self->priv->num, &self->priv->num, (gulong) ((glong) denominator), MPC_RNDNN);
	}
	return self;
}

Number*
number_new_fraction (gint64 numerator,
                     gint64 denominator)
{
	return number_construct_fraction (TYPE_NUMBER, numerator, denominator);
}

static gint
mpc_set_mpreal (__mpc_struct *self,
                __mpfr_struct* re,
                __mpfr_struct* im,
                mpc_rnd_t rnd)
{
	__mpfr_struct _tmp1_;
	__mpfr_struct _tmp2_;
	gint result;
	g_return_val_if_fail (re != NULL, 0);
	if (im == NULL) {
		__mpfr_struct _tmp0_;
		_tmp0_ = *re;
		result = mpc_set_fr (&(*self), &_tmp0_, rnd);
		return result;
	}
	_tmp1_ = *re;
	_tmp2_ = *im;
	result = mpc_set_fr_fr (&(*self), &_tmp1_, &_tmp2_, rnd);
	return result;
}

Number*
number_construct_mpreal (GType object_type,
                         __mpfr_struct* real,
                         __mpfr_struct* imag)
{
	Number * self = NULL;
	__mpfr_struct _tmp0_;
	g_return_val_if_fail (real != NULL, NULL);
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = *real;
	mpc_set_mpreal (&self->priv->num, &_tmp0_, imag, MPC_RNDNN);
	return self;
}

Number*
number_new_mpreal (__mpfr_struct* real,
                   __mpfr_struct* imag)
{
	return number_construct_mpreal (TYPE_NUMBER, real, imag);
}

Number*
number_construct_float (GType object_type,
                        gfloat real,
                        gfloat imag)
{
	Number * self = NULL;
	self = (Number*) g_object_new (object_type, NULL);
	if (isfinite (real)) {
		mpc_set_d_d (&self->priv->num, (gdouble) real, (gdouble) imag, MPC_RNDNN);
	} else {
		mpc_set_ui_ui (&self->priv->num, (gulong) (*((guint32*) (&real))), (gulong) 0, MPC_RNDNN);
		self->priv->finite = FALSE;
	}
	return self;
}

Number*
number_new_float (gfloat real,
                  gfloat imag)
{
	return number_construct_float (TYPE_NUMBER, real, imag);
}

Number*
number_construct_double (GType object_type,
                         gdouble real,
                         gdouble imag)
{
	Number * self = NULL;
	self = (Number*) g_object_new (object_type, NULL);
	if (isfinite (real)) {
		mpc_set_d_d (&self->priv->num, real, imag, MPC_RNDNN);
	} else {
		mpc_set_ui_ui (&self->priv->num, (gulong) (*((guint64*) (&real))), (gulong) 0, MPC_RNDNN);
		self->priv->finite = FALSE;
	}
	return self;
}

Number*
number_new_double (gdouble real,
                   gdouble imag)
{
	return number_construct_double (TYPE_NUMBER, real, imag);
}

Number*
number_construct_complex (GType object_type,
                          Number* r,
                          Number* i)
{
	Number * self = NULL;
	MPFRGRealRef* _tmp0_;
	MPFRGRealRef* _tmp1_;
	g_return_val_if_fail (r != NULL, NULL);
	g_return_val_if_fail (i != NULL, NULL);
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = mpc_realref (&r->priv->num);
	_tmp1_ = mpc_realref (&i->priv->num);
	mpc_set_mpreal (&self->priv->num, &_tmp0_->val, &_tmp1_->val, MPC_RNDNN);
	return self;
}

Number*
number_new_complex (Number* r,
                    Number* i)
{
	return number_construct_complex (TYPE_NUMBER, r, i);
}

Number*
number_construct_polar (GType object_type,
                        Number* r,
                        Number* theta,
                        AngleUnit unit)
{
	Number * self = NULL;
	Number* x = NULL;
	Number* _tmp0_;
	Number* y = NULL;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	g_return_val_if_fail (r != NULL, NULL);
	g_return_val_if_fail (theta != NULL, NULL);
	_tmp0_ = number_cos (theta, unit);
	x = _tmp0_;
	_tmp1_ = number_sin (theta, unit);
	y = _tmp1_;
	_tmp2_ = number_multiply (x, r);
	_tmp3_ = _tmp2_;
	_tmp4_ = number_multiply (y, r);
	_tmp5_ = _tmp4_;
	self = (Number*) number_construct_complex (object_type, _tmp3_, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (y);
	_g_object_unref0 (x);
	return self;
}

Number*
number_new_polar (Number* r,
                  Number* theta,
                  AngleUnit unit)
{
	return number_construct_polar (TYPE_NUMBER, r, theta, unit);
}

Number*
number_construct_eulers (GType object_type)
{
	Number * self = NULL;
	MPFRGRealRef* _tmp0_;
	MPFRGRealRef* _tmp1_;
	MPFRGRealRef* _tmp2_;
	MPFRGRealRef* _tmp3_;
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = mpc_realref (&self->priv->num);
	mpfr_set_ui (&_tmp0_->val, (gulong) 1, MPFR_RNDN);
	_tmp1_ = mpc_realref (&self->priv->num);
	_tmp2_ = mpc_realref (&self->priv->num);
	mpfr_exp (&_tmp1_->val, &_tmp2_->val, MPFR_RNDN);
	_tmp3_ = mpc_imagref (&self->priv->num);
	mpfr_set_zero (&_tmp3_->val, MPFR_RNDN);
	return self;
}

Number*
number_new_eulers (void)
{
	return number_construct_eulers (TYPE_NUMBER);
}

Number*
number_construct_i (GType object_type)
{
	Number * self = NULL;
	self = (Number*) g_object_new (object_type, NULL);
	mpc_set_si_si (&self->priv->num, (glong) 0, (glong) 1, MPC_RNDNN);
	return self;
}

Number*
number_new_i (void)
{
	return number_construct_i (TYPE_NUMBER);
}

Number*
number_construct_pi (GType object_type)
{
	Number * self = NULL;
	MPFRGRealRef* _tmp0_;
	MPFRGRealRef* _tmp1_;
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = mpc_realref (&self->priv->num);
	mpfr_const_pi (&_tmp0_->val, MPFR_RNDN);
	_tmp1_ = mpc_imagref (&self->priv->num);
	mpfr_set_zero (&_tmp1_->val, MPFR_RNDN);
	return self;
}

Number*
number_new_pi (void)
{
	return number_construct_pi (TYPE_NUMBER);
}

static gint
mpfr_const_tau (__mpfr_struct *self,
                mpfr_rnd_t rnd)
{
	gint i = 0;
	gint result;
	i = mpfr_const_pi (&(*self), rnd);
	mpfr_mul_si (&(*self), &(*self), (glong) 2, rnd);
	result = i;
	return result;
}

Number*
number_construct_tau (GType object_type)
{
	Number * self = NULL;
	MPFRGRealRef* _tmp0_;
	MPFRGRealRef* _tmp1_;
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = mpc_realref (&self->priv->num);
	mpfr_const_tau (&_tmp0_->val, MPFR_RNDN);
	_tmp1_ = mpc_imagref (&self->priv->num);
	mpfr_set_zero (&_tmp1_->val, MPFR_RNDN);
	return self;
}

Number*
number_new_tau (void)
{
	return number_construct_tau (TYPE_NUMBER);
}

Number*
number_construct_random (GType object_type)
{
	Number * self = NULL;
	self = (Number*) number_construct_double (object_type, g_random_double (), (gdouble) 0);
	return self;
}

Number*
number_new_random (void)
{
	return number_construct_random (TYPE_NUMBER);
}

gint64
number_to_integer (Number* self)
{
	MPFRGRealRef* _tmp0_;
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = mpc_realref (&self->priv->num);
	result = (gint64) mpfr_get_si (&_tmp0_->val, MPFR_RNDN);
	return result;
}

guint64
number_to_unsigned_integer (Number* self)
{
	MPFRGRealRef* _tmp0_;
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	_tmp0_ = mpc_realref (&self->priv->num);
	result = (guint64) mpfr_get_ui (&_tmp0_->val, MPFR_RNDN);
	return result;
}

gfloat
number_to_float (Number* self)
{
	MPFRGRealRef* _tmp0_;
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	if (!self->priv->finite) {
		guint64 bits = 0ULL;
		bits = number_to_unsigned_integer (self);
		if (bits > ((guint64) G_MAXUINT32)) {
			result = (gfloat) (*((gdouble*) (&bits)));
			return result;
		}
		result = *((gfloat*) (&bits));
		return result;
	}
	_tmp0_ = mpc_realref (&self->priv->num);
	result = mpfr_get_flt (&_tmp0_->val, MPFR_RNDN);
	return result;
}

gdouble
number_to_double (Number* self)
{
	MPFRGRealRef* _tmp0_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	if (!self->priv->finite) {
		guint64 bits = 0ULL;
		bits = number_to_unsigned_integer (self);
		if (bits > ((guint64) G_MAXUINT32)) {
			result = *((gdouble*) (&bits));
			return result;
		}
		result = (gdouble) (*((gfloat*) (&bits)));
		return result;
	}
	_tmp0_ = mpc_realref (&self->priv->num);
	result = mpfr_get_d (&_tmp0_->val, MPFR_RNDN);
	return result;
}

void
number_set_force_float (Number* self,
                        gboolean force_float)
{
	g_return_if_fail (self != NULL);
	self->priv->force_float = force_float;
}

static gboolean
mpc_is_zero (__mpc_struct *self)
{
	gint res = 0;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	res = mpc_cmp_si_si (&(*self), (glong) 0, (glong) 0);
	if (MPC_INEX_RE (res) == 0) {
		_tmp0_ = MPC_INEX_IM (res) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
number_is_zero (Number* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = mpc_is_zero (&self->priv->num);
	return result;
}

gboolean
number_is_negative (Number* self)
{
	MPFRGRealRef* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = mpc_realref (&self->priv->num);
	result = mpfr_sgn (&_tmp0_->val) < 0;
	return result;
}

gboolean
number_is_integer (Number* self)
{
	MPFRGRealRef* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (number_is_complex (self)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = mpc_realref (&self->priv->num);
	result = mpfr_integer_p (&_tmp0_->val) != 0;
	return result;
}

gboolean
number_is_natural (Number* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (number_is_complex (self)) {
		result = FALSE;
		return result;
	} else {
		gboolean _tmp0_ = FALSE;
		MPFRGRealRef* _tmp1_;
		_tmp1_ = mpc_realref (&self->priv->num);
		if (mpfr_sgn (&_tmp1_->val) >= 0) {
			_tmp0_ = number_is_integer (self);
		} else {
			_tmp0_ = FALSE;
		}
		result = _tmp0_;
		return result;
	}
}

gboolean
number_is_float (Number* self)
{
	gboolean _tmp0_ = FALSE;
	Number* max = NULL;
	Number* _tmp3_;
	Number* min = NULL;
	Number* _tmp4_;
	gboolean _tmp5_ = FALSE;
	Number* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->force_float) {
		_tmp0_ = TRUE;
	} else {
		Number* _tmp1_;
		Number* _tmp2_;
		_tmp1_ = number_fractional_component (self);
		_tmp2_ = _tmp1_;
		_tmp0_ = !number_is_zero (_tmp2_);
		_g_object_unref0 (_tmp2_);
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp3_ = number_new_unsigned_integer (G_MAXUINT64, (guint64) 0);
	max = _tmp3_;
	_tmp4_ = number_new_integer (G_MININT64, (gint64) 0);
	min = _tmp4_;
	_tmp6_ = max;
	if (number_compare (self, _tmp6_) > 0) {
		_tmp5_ = TRUE;
	} else {
		Number* _tmp7_;
		_tmp7_ = min;
		_tmp5_ = number_compare (self, _tmp7_) < 0;
	}
	result = _tmp5_;
	_g_object_unref0 (min);
	_g_object_unref0 (max);
	return result;
}

gboolean
number_is_finite (Number* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->finite;
	return result;
}

gboolean
number_is_complex (Number* self)
{
	MPFRGRealRef* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = mpc_imagref (&self->priv->num);
	result = !mpfr_zero_p (&_tmp0_->val);
	return result;
}

gboolean
number_is_180n_degrees (Number* self,
                        AngleUnit unit)
{
	Number* check = NULL;
	gboolean is_180n = FALSE;
	Number* _tmp9_;
	gboolean _tmp10_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (number_is_complex (self)) {
		result = FALSE;
		return result;
	}
	switch (unit) {
		case ANGLE_UNIT_RADIANS:
		{
			Number* _tmp0_;
			Number* _tmp1_;
			Number* _tmp2_;
			_tmp0_ = number_new_pi ();
			_tmp1_ = _tmp0_;
			_tmp2_ = number_divide (self, _tmp1_);
			_g_object_unref0 (check);
			check = _tmp2_;
			_g_object_unref0 (_tmp1_);
			break;
		}
		case ANGLE_UNIT_DEGREES:
		{
			Number* _tmp3_;
			Number* _tmp4_;
			Number* _tmp5_;
			_tmp3_ = number_new_integer ((gint64) 180, (gint64) 0);
			_tmp4_ = _tmp3_;
			_tmp5_ = number_divide (self, _tmp4_);
			_g_object_unref0 (check);
			check = _tmp5_;
			_g_object_unref0 (_tmp4_);
			break;
		}
		case ANGLE_UNIT_GRADIANS:
		{
			Number* _tmp6_;
			Number* _tmp7_;
			Number* _tmp8_;
			_tmp6_ = number_new_integer ((gint64) 200, (gint64) 0);
			_tmp7_ = _tmp6_;
			_tmp8_ = number_divide (self, _tmp7_);
			_g_object_unref0 (check);
			check = _tmp8_;
			_g_object_unref0 (_tmp7_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
			result = TRUE;
			_g_object_unref0 (check);
			return result;
		}
	}
	_tmp9_ = check;
	is_180n = number_is_integer (_tmp9_);
	if (!is_180n) {
		_tmp10_ = unit == ANGLE_UNIT_RADIANS;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		Number* eps = NULL;
		Number* _tmp11_;
		Number* _tmp12_;
		mpfr_prec_t _tmp13_;
		mpfr_prec_t _tmp14_;
		Number* _tmp15_;
		Number* _tmp16_;
		Number* _tmp17_;
		Number* _tmp18_;
		Number* _tmp19_;
		Number* _tmp20_;
		Number* _tmp21_;
		Number* _tmp22_;
		Number* _tmp23_;
		Number* _tmp24_;
		Number* _tmp25_;
		Number* _tmp26_;
		Number* _tmp27_;
		Number* _tmp28_;
		Number* _tmp29_;
		_tmp11_ = number_new_integer ((gint64) 2, (gint64) 0);
		_tmp12_ = _tmp11_;
		_tmp13_ = number_get_precision ();
		_tmp14_ = _tmp13_;
		_tmp15_ = number_xpowy_integer (_tmp12_, (gint64) (-_tmp14_));
		_tmp16_ = _tmp15_;
		_tmp17_ = number_multiply (self, _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = number_abs (_tmp18_);
		_tmp20_ = _tmp19_;
		_g_object_unref0 (_tmp18_);
		_g_object_unref0 (_tmp16_);
		_g_object_unref0 (_tmp12_);
		eps = _tmp20_;
		_tmp21_ = check;
		_tmp22_ = check;
		_tmp23_ = number_round (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = number_subtract (_tmp21_, _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = number_abs (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = eps;
		is_180n = number_compare (_tmp28_, _tmp29_) < 0;
		_g_object_unref0 (_tmp28_);
		_g_object_unref0 (_tmp26_);
		_g_object_unref0 (_tmp24_);
		_g_object_unref0 (eps);
	}
	result = is_180n;
	_g_object_unref0 (check);
	return result;
}

gboolean
number_is_180n_plus_90_degrees (Number* self,
                                AngleUnit unit)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	switch (unit) {
		case ANGLE_UNIT_RADIANS:
		{
			Number* _tmp0_;
			Number* _tmp1_;
			Number* _tmp2_;
			Number* _tmp3_;
			Number* _tmp4_;
			Number* _tmp5_;
			gboolean _tmp6_;
			_tmp0_ = number_new_pi ();
			_tmp1_ = _tmp0_;
			_tmp2_ = number_divide_integer (_tmp1_, (gint64) 2);
			_tmp3_ = _tmp2_;
			_tmp4_ = number_subtract (self, _tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = number_is_180n_degrees (_tmp5_, unit);
			_g_object_unref0 (_tmp5_);
			_g_object_unref0 (_tmp3_);
			_g_object_unref0 (_tmp1_);
			result = _tmp6_;
			return result;
		}
		case ANGLE_UNIT_DEGREES:
		{
			Number* _tmp7_;
			Number* _tmp8_;
			Number* _tmp9_;
			Number* _tmp10_;
			gboolean _tmp11_;
			_tmp7_ = number_new_integer ((gint64) 90, (gint64) 0);
			_tmp8_ = _tmp7_;
			_tmp9_ = number_subtract (self, _tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = number_is_180n_degrees (_tmp10_, unit);
			_g_object_unref0 (_tmp10_);
			_g_object_unref0 (_tmp8_);
			result = _tmp11_;
			return result;
		}
		case ANGLE_UNIT_GRADIANS:
		{
			Number* _tmp12_;
			Number* _tmp13_;
			Number* _tmp14_;
			Number* _tmp15_;
			gboolean _tmp16_;
			_tmp12_ = number_new_integer ((gint64) 100, (gint64) 0);
			_tmp13_ = _tmp12_;
			_tmp14_ = number_subtract (self, _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = number_is_180n_degrees (_tmp15_, unit);
			_g_object_unref0 (_tmp15_);
			_g_object_unref0 (_tmp13_);
			result = _tmp16_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
			result = TRUE;
			return result;
		}
	}
}

gboolean
number_is_overflow (Number* self,
                    gint wordlen,
                    gboolean may_be_negative)
{
	Number* max = NULL;
	Number* _tmp0_;
	Number* min = NULL;
	Number* _tmp2_;
	gboolean _tmp3_ = FALSE;
	Number* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = number_new_unsigned_integer (G_MAXUINT64 >> (64 - wordlen), (guint64) 0);
	max = _tmp0_;
	if (!may_be_negative) {
		Number* _tmp1_;
		_tmp1_ = max;
		result = number_compare (self, _tmp1_) > 0;
		_g_object_unref0 (max);
		return result;
	}
	_tmp2_ = number_new_integer (G_MININT64 >> (64 - wordlen), (gint64) 0);
	min = _tmp2_;
	_tmp4_ = max;
	if (number_compare (self, _tmp4_) > 0) {
		_tmp3_ = TRUE;
	} else {
		Number* _tmp5_;
		_tmp5_ = min;
		_tmp3_ = number_compare (self, _tmp5_) < 0;
	}
	result = _tmp3_;
	_g_object_unref0 (min);
	_g_object_unref0 (max);
	return result;
}

void
number_check_flags (void)
{
	if (mpfr_underflow_p () != 0) {
		number_set_error (_ ("Underflow error"));
	} else {
		if (mpfr_overflow_p () != 0) {
			number_set_error (_ ("Overflow error"));
		}
	}
}

static gboolean
mpc_is_equal (__mpc_struct *self,
              __mpc_struct* c)
{
	gint res = 0;
	__mpc_struct _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = *c;
	res = mpc_cmp (&(*self), &_tmp0_);
	if (MPC_INEX_RE (res) == 0) {
		_tmp1_ = MPC_INEX_IM (res) == 0;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	return result;
}

gboolean
number_equals (Number* self,
               Number* y)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (y != NULL, FALSE);
	result = mpc_is_equal (&self->priv->num, &y->priv->num);
	return result;
}

gint
number_compare (Number* self,
                Number* y)
{
	MPFRGRealRef* _tmp0_;
	MPFRGRealRef* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (y != NULL, 0);
	_tmp0_ = mpc_realref (&self->priv->num);
	_tmp1_ = mpc_realref (&y->priv->num);
	result = mpfr_cmp (&_tmp0_->val, &_tmp1_->val);
	return result;
}

Number*
number_kronecker_delta (Number* self,
                        Number* y)
{
	gint _tmp0_ = 0;
	Number* _tmp1_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	if (number_equals (self, y)) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	_tmp1_ = number_new_integer ((gint64) _tmp0_, (gint64) 0);
	result = _tmp1_;
	return result;
}

Number*
number_sgn (Number* self)
{
	Number* z = NULL;
	MPFRGRealRef* _tmp4_;
	Number* _tmp5_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (number_is_complex (self)) {
		Number* _tmp0_;
		Number* _tmp1_;
		Number* _tmp2_;
		Number* _tmp3_;
		_tmp0_ = number_abs (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = number_divide (self, _tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = mpc_realref (&self->priv->num);
	_tmp5_ = number_new_integer ((gint64) mpfr_sgn (&_tmp4_->val), (gint64) 0);
	z = _tmp5_;
	result = z;
	return result;
}

Number*
number_invert_sign (Number* self)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_neg (&z->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_abs (Number* self)
{
	Number* z = NULL;
	Number* _tmp0_;
	MPFRGRealRef* _tmp1_;
	MPFRGRealRef* _tmp2_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = mpc_imagref (&z->priv->num);
	mpfr_set_zero (&_tmp1_->val, MPFR_RNDN);
	_tmp2_ = mpc_realref (&z->priv->num);
	mpc_abs (&_tmp2_->val, &self->priv->num, MPFR_RNDN);
	result = z;
	return result;
}

Number*
number_arg (Number* self,
            AngleUnit unit)
{
	Number* z = NULL;
	Number* _tmp1_;
	Number* _tmp2_;
	MPFRGRealRef* _tmp3_;
	Number* _tmp4_;
	MPFRGRealRef* _tmp5_;
	Number* _tmp6_;
	Number* _tmp7_;
	gboolean _tmp8_ = FALSE;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (number_is_zero (self)) {
		Number* _tmp0_;
		number_set_error (_ ("Argument not defined for zero"));
		_tmp0_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = number_new ();
	z = _tmp1_;
	_tmp2_ = z;
	_tmp3_ = mpc_imagref (&_tmp2_->priv->num);
	mpfr_set_zero (&_tmp3_->val, MPFR_RNDN);
	_tmp4_ = z;
	_tmp5_ = mpc_realref (&_tmp4_->priv->num);
	mpc_arg (&_tmp5_->val, &self->priv->num, MPFR_RNDN);
	_tmp6_ = z;
	_tmp7_ = z;
	number_mpc_from_radians (&_tmp6_->priv->num, &_tmp7_->priv->num, unit);
	if (!number_is_complex (self)) {
		_tmp8_ = number_is_negative (self);
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		Number* _tmp9_;
		MPFRGRealRef* _tmp10_;
		Number* _tmp11_;
		MPFRGRealRef* _tmp12_;
		_tmp9_ = z;
		_tmp10_ = mpc_realref (&_tmp9_->priv->num);
		_tmp11_ = z;
		_tmp12_ = mpc_realref (&_tmp11_->priv->num);
		mpfr_abs (&_tmp10_->val, &_tmp12_->val, MPFR_RNDN);
	}
	result = z;
	return result;
}

Number*
number_conjugate (Number* self)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_conj (&z->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_real_component (Number* self)
{
	Number* z = NULL;
	Number* _tmp0_;
	MPFRGRealRef* _tmp1_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = mpc_realref (&self->priv->num);
	mpc_set_mpreal (&z->priv->num, &_tmp1_->val, NULL, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_imaginary_component (Number* self)
{
	Number* z = NULL;
	Number* _tmp0_;
	MPFRGRealRef* _tmp1_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = mpc_imagref (&self->priv->num);
	mpc_set_mpreal (&z->priv->num, &_tmp1_->val, NULL, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_integer_component (Number* self)
{
	Number* z = NULL;
	Number* _tmp0_;
	MPFRGRealRef* _tmp1_;
	MPFRGRealRef* _tmp2_;
	MPFRGRealRef* _tmp3_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = mpc_imagref (&z->priv->num);
	mpfr_set_zero (&_tmp1_->val, MPFR_RNDN);
	_tmp2_ = mpc_realref (&z->priv->num);
	_tmp3_ = mpc_realref (&self->priv->num);
	mpfr_trunc (&_tmp2_->val, &_tmp3_->val);
	result = z;
	return result;
}

Number*
number_fractional_component (Number* self)
{
	Number* z = NULL;
	Number* _tmp0_;
	MPFRGRealRef* _tmp1_;
	MPFRGRealRef* _tmp2_;
	MPFRGRealRef* _tmp3_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = mpc_imagref (&z->priv->num);
	mpfr_set_zero (&_tmp1_->val, MPFR_RNDN);
	_tmp2_ = mpc_realref (&z->priv->num);
	_tmp3_ = mpc_realref (&self->priv->num);
	mpfr_frac (&_tmp2_->val, &_tmp3_->val, MPFR_RNDN);
	result = z;
	return result;
}

Number*
number_fractional_part (Number* self)
{
	Number* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_floor (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = number_subtract (self, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

Number*
number_floor (Number* self)
{
	Number* z = NULL;
	Number* _tmp1_;
	Number* _tmp2_;
	MPFRGRealRef* _tmp3_;
	Number* _tmp4_;
	MPFRGRealRef* _tmp5_;
	MPFRGRealRef* _tmp6_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (number_is_complex (self)) {
		Number* _tmp0_;
		number_set_error (_ ("Floor is only defined for real numbers"));
		_tmp0_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = number_new ();
	z = _tmp1_;
	_tmp2_ = z;
	_tmp3_ = mpc_imagref (&_tmp2_->priv->num);
	mpfr_set_zero (&_tmp3_->val, MPFR_RNDN);
	_tmp4_ = z;
	_tmp5_ = mpc_realref (&_tmp4_->priv->num);
	_tmp6_ = mpc_realref (&self->priv->num);
	mpfr_floor (&_tmp5_->val, &_tmp6_->val);
	result = z;
	return result;
}

Number*
number_ceiling (Number* self)
{
	Number* z = NULL;
	Number* _tmp1_;
	Number* _tmp2_;
	MPFRGRealRef* _tmp3_;
	Number* _tmp4_;
	MPFRGRealRef* _tmp5_;
	MPFRGRealRef* _tmp6_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (number_is_complex (self)) {
		Number* _tmp0_;
		number_set_error (_ ("Ceiling is only defined for real numbers"));
		_tmp0_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = number_new ();
	z = _tmp1_;
	_tmp2_ = z;
	_tmp3_ = mpc_imagref (&_tmp2_->priv->num);
	mpfr_set_zero (&_tmp3_->val, MPFR_RNDN);
	_tmp4_ = z;
	_tmp5_ = mpc_realref (&_tmp4_->priv->num);
	_tmp6_ = mpc_realref (&self->priv->num);
	mpfr_ceil (&_tmp5_->val, &_tmp6_->val);
	result = z;
	return result;
}

Number*
number_round (Number* self)
{
	Number* z = NULL;
	Number* _tmp1_;
	Number* _tmp2_;
	MPFRGRealRef* _tmp3_;
	Number* _tmp4_;
	MPFRGRealRef* _tmp5_;
	MPFRGRealRef* _tmp6_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (number_is_complex (self)) {
		Number* _tmp0_;
		number_set_error (_ ("Round is only defined for real numbers"));
		_tmp0_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = number_new ();
	z = _tmp1_;
	_tmp2_ = z;
	_tmp3_ = mpc_imagref (&_tmp2_->priv->num);
	mpfr_set_zero (&_tmp3_->val, MPFR_RNDN);
	_tmp4_ = z;
	_tmp5_ = mpc_realref (&_tmp4_->priv->num);
	_tmp6_ = mpc_realref (&self->priv->num);
	mpfr_round (&_tmp5_->val, &_tmp6_->val);
	result = z;
	return result;
}

Number*
number_reciprocal (Number* self)
{
	Number* z = NULL;
	Number* _tmp0_;
	MPFRGRealRef* _tmp1_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_set_si_si (&z->priv->num, (glong) 1, (glong) 0, MPC_RNDNN);
	_tmp1_ = mpc_realref (&z->priv->num);
	mpc_fr_div (&z->priv->num, &_tmp1_->val, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_epowy (Number* self)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_exp (&z->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_xpowy (Number* self,
              Number* y)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	Number* z = NULL;
	Number* _tmp10_;
	Number* _tmp11_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	if (number_is_zero (self)) {
		_tmp0_ = number_is_negative (y);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Number* _tmp1_;
		number_set_error (_ ("The power of zero is undefined for a negative exponent"));
		_tmp1_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp1_;
		return result;
	}
	if (number_is_zero (self)) {
		_tmp2_ = number_is_zero (y);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		Number* _tmp3_;
		number_set_error (_ ("Zero raised to zero is undefined"));
		_tmp3_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp3_;
		return result;
	}
	if (!number_is_complex (self)) {
		_tmp5_ = !number_is_complex (y);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		_tmp4_ = !number_is_integer (y);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		Number* reciprocal = NULL;
		Number* _tmp6_;
		Number* _tmp7_;
		_tmp6_ = number_reciprocal (y);
		reciprocal = _tmp6_;
		_tmp7_ = reciprocal;
		if (number_is_integer (_tmp7_)) {
			Number* _tmp8_;
			Number* _tmp9_;
			_tmp8_ = reciprocal;
			_tmp9_ = number_root (self, number_to_integer (_tmp8_));
			result = _tmp9_;
			_g_object_unref0 (reciprocal);
			return result;
		}
		_g_object_unref0 (reciprocal);
	}
	_tmp10_ = number_new ();
	z = _tmp10_;
	_tmp11_ = z;
	mpc_pow (&_tmp11_->priv->num, &self->priv->num, &y->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_xpowy_integer (Number* self,
                      gint64 n)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_ = FALSE;
	Number* z = NULL;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (number_is_zero (self)) {
		_tmp0_ = n < ((gint64) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Number* _tmp1_;
		number_set_error (_ ("The power of zero is undefined for a negative exponent"));
		_tmp1_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp1_;
		return result;
	}
	if (number_is_zero (self)) {
		_tmp2_ = n == ((gint64) 0);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		Number* _tmp3_;
		number_set_error (_ ("Zero raised to zero is undefined"));
		_tmp3_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = number_new ();
	z = _tmp4_;
	_tmp5_ = z;
	mpc_pow_si (&_tmp5_->priv->num, &self->priv->num, (glong) n, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_root (Number* self,
             gint64 n)
{
	guint64 p = 0ULL;
	Number* z = NULL;
	Number* _tmp0_;
	gboolean _tmp4_ = FALSE;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	if (n < ((gint64) 0)) {
		Number* _tmp1_;
		_tmp1_ = z;
		mpc_ui_div (&_tmp1_->priv->num, (gulong) 1, &self->priv->num, MPC_RNDNN);
		if (n == G_MININT64) {
			p = ((guint64) G_MAXINT64) + 1;
		} else {
			p = (guint64) (-n);
		}
	} else {
		if (n > ((gint64) 0)) {
			Number* _tmp2_;
			_tmp2_ = z;
			mpc_set (&_tmp2_->priv->num, &self->priv->num, MPC_RNDNN);
			p = (guint64) n;
		} else {
			Number* _tmp3_;
			number_set_error (_ ("The zeroth root of a number is undefined"));
			_tmp3_ = number_new_integer ((gint64) 0, (gint64) 0);
			result = _tmp3_;
			_g_object_unref0 (z);
			return result;
		}
	}
	if (!number_is_complex (self)) {
		gboolean _tmp5_ = FALSE;
		if (!number_is_negative (self)) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = (p & 1) == ((guint64) 1);
		}
		_tmp4_ = _tmp5_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		Number* _tmp6_;
		MPFRGRealRef* _tmp7_;
		Number* _tmp8_;
		MPFRGRealRef* _tmp9_;
		Number* _tmp10_;
		MPFRGRealRef* _tmp11_;
		_tmp6_ = z;
		_tmp7_ = mpc_realref (&_tmp6_->priv->num);
		_tmp8_ = z;
		_tmp9_ = mpc_realref (&_tmp8_->priv->num);
		mpfr_root (&_tmp7_->val, &_tmp9_->val, (gulong) p, MPFR_RNDN);
		_tmp10_ = z;
		_tmp11_ = mpc_imagref (&_tmp10_->priv->num);
		mpfr_set_zero (&_tmp11_->val, MPFR_RNDN);
	} else {
		__mpfr_struct tmp = {0};
		mpfr_prec_t _tmp12_;
		mpfr_prec_t _tmp13_;
		Number* _tmp14_;
		Number* _tmp15_;
		_tmp12_ = number_get_precision ();
		_tmp13_ = _tmp12_;
		mpfr_init2 (&tmp, _tmp13_);
		mpfr_set_ui (&tmp, (gulong) p, MPFR_RNDN);
		mpfr_ui_div (&tmp, (gulong) 1, &tmp, MPFR_RNDN);
		_tmp14_ = z;
		_tmp15_ = z;
		mpc_pow_fr (&_tmp14_->priv->num, &_tmp15_->priv->num, &tmp, MPC_RNDNN);
		mpfr_clear (&tmp);
	}
	result = z;
	return result;
}

Number*
number_sqrt (Number* self)
{
	Number* _tmp0_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_root (self, (gint64) 2);
	result = _tmp0_;
	return result;
}

Number*
number_ln (Number* self)
{
	Number* z = NULL;
	Number* _tmp1_;
	Number* _tmp2_;
	gboolean _tmp3_ = FALSE;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (number_is_zero (self)) {
		Number* _tmp0_;
		number_set_error (_ ("Logarithm of zero is undefined"));
		_tmp0_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = number_new ();
	z = _tmp1_;
	_tmp2_ = z;
	mpc_log (&_tmp2_->priv->num, &self->priv->num, MPC_RNDNN);
	if (!number_is_complex (self)) {
		_tmp3_ = number_is_negative (self);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		Number* _tmp4_;
		MPFRGRealRef* _tmp5_;
		Number* _tmp6_;
		MPFRGRealRef* _tmp7_;
		_tmp4_ = z;
		_tmp5_ = mpc_imagref (&_tmp4_->priv->num);
		_tmp6_ = z;
		_tmp7_ = mpc_imagref (&_tmp6_->priv->num);
		mpfr_abs (&_tmp5_->val, &_tmp7_->val, MPFR_RNDN);
	}
	result = z;
	return result;
}

Number*
number_logarithm (Number* self,
                  Number* n)
{
	gboolean _tmp1_ = FALSE;
	Number* _tmp5_;
	Number* _tmp6_;
	Number* _tmp7_;
	Number* _tmp8_;
	Number* _tmp9_;
	Number* _tmp10_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (n != NULL, NULL);
	if (number_is_zero (self)) {
		Number* _tmp0_;
		number_set_error (_ ("Logarithm of zero is undefined"));
		_tmp0_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp0_;
		return result;
	}
	if (number_is_zero (n)) {
		_tmp1_ = TRUE;
	} else {
		Number* _tmp2_;
		Number* _tmp3_;
		_tmp2_ = number_new_integer ((gint64) 1, (gint64) 0);
		_tmp3_ = _tmp2_;
		_tmp1_ = number_equals (n, _tmp3_);
		_g_object_unref0 (_tmp3_);
	}
	if (_tmp1_) {
		Number* _tmp4_;
		number_set_error (_ ("Logarithm with base 0 or 1 is undefined"));
		_tmp4_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = number_ln (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = number_ln (n);
	_tmp8_ = _tmp7_;
	_tmp9_ = number_divide (_tmp6_, _tmp8_);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp8_);
	_g_object_unref0 (_tmp6_);
	result = _tmp10_;
	return result;
}

Number*
number_factorial (Number* self)
{
	gboolean _tmp2_ = FALSE;
	Number* tmp = NULL;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* _tmp6_;
	Number* _tmp7_;
	__mpfr_struct tmp2 = {0};
	mpfr_prec_t _tmp8_;
	mpfr_prec_t _tmp9_;
	Number* _tmp10_;
	MPFRGRealRef* _tmp11_;
	Number* _tmp12_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (number_is_zero (self)) {
		Number* _tmp0_;
		_tmp0_ = number_new_integer ((gint64) 1, (gint64) 0);
		result = _tmp0_;
		return result;
	}
	if (number_is_complex (self)) {
		Number* _tmp1_;
		number_set_error (_ ("Factorial of complex numbers is not supported"));
		_tmp1_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp1_;
		return result;
	}
	if (number_is_negative (self)) {
		_tmp2_ = number_is_integer (self);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		Number* _tmp3_;
		number_set_error (_ ("Factorial is undefined for negative integers"));
		_tmp3_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = number_new_integer ((gint64) 1, (gint64) 0);
	_tmp5_ = _tmp4_;
	_tmp6_ = number_add (self, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	tmp = _tmp7_;
	_tmp8_ = number_get_precision ();
	_tmp9_ = _tmp8_;
	mpfr_init2 (&tmp2, _tmp9_);
	_tmp10_ = tmp;
	_tmp11_ = mpc_realref (&_tmp10_->priv->num);
	mpfr_gamma (&tmp2, &_tmp11_->val, MPFR_RNDN);
	_tmp12_ = number_new_mpreal (&tmp2, NULL);
	result = _tmp12_;
	mpfr_clear (&tmp2);
	_g_object_unref0 (tmp);
	return result;
}

Number*
number_add (Number* self,
            Number* y)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_add (&z->priv->num, &self->priv->num, &y->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_subtract (Number* self,
                 Number* y)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_sub (&z->priv->num, &self->priv->num, &y->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_multiply (Number* self,
                 Number* y)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_mul (&z->priv->num, &self->priv->num, &y->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_multiply_integer (Number* self,
                         gint64 y)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_mul_si (&z->priv->num, &self->priv->num, (glong) y, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_divide (Number* self,
               Number* y)
{
	Number* z = NULL;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	if (number_is_zero (y)) {
		Number* _tmp0_;
		number_set_error (_ ("Division by zero is undefined"));
		_tmp0_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = number_new ();
	z = _tmp1_;
	_tmp2_ = z;
	mpc_div (&_tmp2_->priv->num, &self->priv->num, &y->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_divide_integer (Number* self,
                       gint64 y)
{
	Number* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new_integer (y, (gint64) 0);
	_tmp1_ = _tmp0_;
	_tmp2_ = number_divide (self, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

Number*
number_modulus_divide (Number* self,
                       Number* y)
{
	gboolean _tmp0_ = FALSE;
	Number* t1 = NULL;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* t2 = NULL;
	Number* _tmp6_;
	Number* _tmp7_;
	Number* z = NULL;
	Number* _tmp8_;
	Number* _tmp9_;
	Number* _tmp10_;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	Number* _tmp13_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	if (number_is_complex (self)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = number_is_complex (y);
	}
	if (_tmp0_) {
		Number* _tmp1_;
		number_set_error (_ ("Modulus division is only defined for real numbers"));
		_tmp1_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = number_divide (self, y);
	_tmp3_ = _tmp2_;
	_tmp4_ = number_floor (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	t1 = _tmp5_;
	_tmp6_ = t1;
	_tmp7_ = number_multiply (_tmp6_, y);
	t2 = _tmp7_;
	_tmp8_ = t2;
	_tmp9_ = number_subtract (self, _tmp8_);
	z = _tmp9_;
	_tmp10_ = number_new_integer ((gint64) 0, (gint64) 0);
	_g_object_unref0 (t1);
	t1 = _tmp10_;
	_tmp13_ = t1;
	if (number_compare (y, _tmp13_) < 0) {
		Number* _tmp14_;
		Number* _tmp15_;
		_tmp14_ = z;
		_tmp15_ = t1;
		_tmp12_ = number_compare (_tmp14_, _tmp15_) > 0;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		_tmp11_ = TRUE;
	} else {
		gboolean _tmp16_ = FALSE;
		Number* _tmp17_;
		_tmp17_ = t1;
		if (number_compare (y, _tmp17_) > 0) {
			Number* _tmp18_;
			Number* _tmp19_;
			_tmp18_ = z;
			_tmp19_ = t1;
			_tmp16_ = number_compare (_tmp18_, _tmp19_) < 0;
		} else {
			_tmp16_ = FALSE;
		}
		_tmp11_ = _tmp16_;
	}
	if (_tmp11_) {
		Number* _tmp20_;
		Number* _tmp21_;
		_tmp20_ = z;
		_tmp21_ = number_add (_tmp20_, y);
		_g_object_unref0 (z);
		z = _tmp21_;
	}
	result = z;
	_g_object_unref0 (t2);
	_g_object_unref0 (t1);
	return result;
}

Number*
number_modular_exponentiation (Number* self,
                               Number* exp,
                               Number* mod)
{
	Number* base_value = NULL;
	Number* _tmp0_;
	Number* exp_value = NULL;
	Number* _tmp3_;
	Number* ans = NULL;
	Number* _tmp4_;
	Number* two = NULL;
	Number* _tmp5_;
	Number* _tmp26_;
	Number* _tmp27_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (exp != NULL, NULL);
	g_return_val_if_fail (mod != NULL, NULL);
	_tmp0_ = number_copy (self);
	base_value = _tmp0_;
	if (number_is_negative (exp)) {
		Number* _tmp1_;
		Number* _tmp2_;
		_tmp1_ = base_value;
		_tmp2_ = number_reciprocal (_tmp1_);
		_g_object_unref0 (base_value);
		base_value = _tmp2_;
	}
	_tmp3_ = number_abs (exp);
	exp_value = _tmp3_;
	_tmp4_ = number_new_integer ((gint64) 1, (gint64) 0);
	ans = _tmp4_;
	_tmp5_ = number_new_integer ((gint64) 2, (gint64) 0);
	two = _tmp5_;
	while (TRUE) {
		Number* _tmp6_;
		gboolean is_even = FALSE;
		Number* _tmp7_;
		Number* _tmp8_;
		Number* _tmp9_;
		Number* _tmp10_;
		gboolean _tmp11_;
		Number* _tmp17_;
		Number* _tmp18_;
		Number* _tmp19_;
		Number* _tmp20_;
		Number* _tmp21_;
		Number* _tmp22_;
		Number* _tmp23_;
		Number* _tmp24_;
		Number* _tmp25_;
		_tmp6_ = exp_value;
		if (!(!number_is_zero (_tmp6_))) {
			break;
		}
		_tmp7_ = exp_value;
		_tmp8_ = two;
		_tmp9_ = number_modulus_divide (_tmp7_, _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = number_is_zero (_tmp10_);
		_g_object_unref0 (_tmp10_);
		is_even = _tmp11_;
		if (!is_even) {
			Number* _tmp12_;
			Number* _tmp13_;
			Number* _tmp14_;
			Number* _tmp15_;
			Number* _tmp16_;
			_tmp12_ = ans;
			_tmp13_ = base_value;
			_tmp14_ = number_multiply (_tmp12_, _tmp13_);
			_g_object_unref0 (ans);
			ans = _tmp14_;
			_tmp15_ = ans;
			_tmp16_ = number_modulus_divide (_tmp15_, mod);
			_g_object_unref0 (ans);
			ans = _tmp16_;
		}
		_tmp17_ = base_value;
		_tmp18_ = base_value;
		_tmp19_ = number_multiply (_tmp17_, _tmp18_);
		_g_object_unref0 (base_value);
		base_value = _tmp19_;
		_tmp20_ = base_value;
		_tmp21_ = number_modulus_divide (_tmp20_, mod);
		_g_object_unref0 (base_value);
		base_value = _tmp21_;
		_tmp22_ = exp_value;
		_tmp23_ = number_divide_integer (_tmp22_, (gint64) 2);
		_tmp24_ = _tmp23_;
		_tmp25_ = number_floor (_tmp24_);
		_g_object_unref0 (exp_value);
		exp_value = _tmp25_;
		_g_object_unref0 (_tmp24_);
	}
	_tmp26_ = ans;
	_tmp27_ = number_modulus_divide (_tmp26_, mod);
	result = _tmp27_;
	_g_object_unref0 (two);
	_g_object_unref0 (ans);
	_g_object_unref0 (exp_value);
	_g_object_unref0 (base_value);
	return result;
}

Number*
number_sin (Number* self,
            AngleUnit unit)
{
	Number* z = NULL;
	Number* _tmp1_;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (number_is_180n_degrees (self, unit)) {
		Number* _tmp0_;
		_tmp0_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = number_new ();
	z = _tmp1_;
	if (number_is_complex (self)) {
		Number* _tmp2_;
		_tmp2_ = z;
		mpc_set (&_tmp2_->priv->num, &self->priv->num, MPC_RNDNN);
	} else {
		Number* _tmp3_;
		_tmp3_ = z;
		number_mpc_to_radians (&_tmp3_->priv->num, &self->priv->num, unit);
	}
	_tmp4_ = z;
	_tmp5_ = z;
	mpc_sin (&_tmp4_->priv->num, &_tmp5_->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_cos (Number* self,
            AngleUnit unit)
{
	Number* z = NULL;
	Number* _tmp1_;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (number_is_180n_plus_90_degrees (self, unit)) {
		Number* _tmp0_;
		_tmp0_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = number_new ();
	z = _tmp1_;
	if (number_is_complex (self)) {
		Number* _tmp2_;
		_tmp2_ = z;
		mpc_set (&_tmp2_->priv->num, &self->priv->num, MPC_RNDNN);
	} else {
		Number* _tmp3_;
		_tmp3_ = z;
		number_mpc_to_radians (&_tmp3_->priv->num, &self->priv->num, unit);
	}
	_tmp4_ = z;
	_tmp5_ = z;
	mpc_cos (&_tmp4_->priv->num, &_tmp5_->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_tan (Number* self,
            AngleUnit unit)
{
	Number* z = NULL;
	Number* _tmp2_;
	Number* _tmp5_;
	Number* _tmp6_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (number_is_180n_degrees (self, unit)) {
		Number* _tmp0_;
		_tmp0_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp0_;
		return result;
	} else {
		if (number_is_180n_plus_90_degrees (self, unit)) {
			Number* _tmp1_;
			number_set_error (_ ("Tangent is undefined for angles that are multiples of π (180°) from π∕" \
"2 (90°)"));
			_tmp1_ = number_new_integer ((gint64) 0, (gint64) 0);
			result = _tmp1_;
			return result;
		}
	}
	_tmp2_ = number_new ();
	z = _tmp2_;
	if (number_is_complex (self)) {
		Number* _tmp3_;
		_tmp3_ = z;
		mpc_set (&_tmp3_->priv->num, &self->priv->num, MPC_RNDNN);
	} else {
		Number* _tmp4_;
		_tmp4_ = z;
		number_mpc_to_radians (&_tmp4_->priv->num, &self->priv->num, unit);
	}
	_tmp5_ = z;
	_tmp6_ = z;
	mpc_tan (&_tmp5_->priv->num, &_tmp6_->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_asin (Number* self,
             AngleUnit unit)
{
	gboolean _tmp0_ = FALSE;
	Number* z = NULL;
	Number* _tmp8_;
	Number* _tmp9_;
	Number* _tmp10_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (!number_is_complex (self)) {
		gboolean _tmp1_ = FALSE;
		Number* _tmp2_;
		Number* _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = number_new_integer ((gint64) 1, (gint64) 0);
		_tmp3_ = _tmp2_;
		_tmp4_ = number_compare (self, _tmp3_) > 0;
		_g_object_unref0 (_tmp3_);
		if (_tmp4_) {
			_tmp1_ = TRUE;
		} else {
			Number* _tmp5_;
			Number* _tmp6_;
			_tmp5_ = number_new_integer ((gint64) -1, (gint64) 0);
			_tmp6_ = _tmp5_;
			_tmp1_ = number_compare (self, _tmp6_) < 0;
			_g_object_unref0 (_tmp6_);
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Number* _tmp7_;
		number_set_error (_ ("Inverse sine is undefined for values outside [-1, 1]"));
		_tmp7_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp7_;
		return result;
	}
	_tmp8_ = number_new ();
	z = _tmp8_;
	_tmp9_ = z;
	mpc_asin (&_tmp9_->priv->num, &self->priv->num, MPC_RNDNN);
	_tmp10_ = z;
	if (!number_is_complex (_tmp10_)) {
		Number* _tmp11_;
		Number* _tmp12_;
		_tmp11_ = z;
		_tmp12_ = z;
		number_mpc_from_radians (&_tmp11_->priv->num, &_tmp12_->priv->num, unit);
	}
	result = z;
	return result;
}

Number*
number_acos (Number* self,
             AngleUnit unit)
{
	gboolean _tmp0_ = FALSE;
	Number* z = NULL;
	Number* _tmp8_;
	Number* _tmp9_;
	Number* _tmp10_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (!number_is_complex (self)) {
		gboolean _tmp1_ = FALSE;
		Number* _tmp2_;
		Number* _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = number_new_integer ((gint64) 1, (gint64) 0);
		_tmp3_ = _tmp2_;
		_tmp4_ = number_compare (self, _tmp3_) > 0;
		_g_object_unref0 (_tmp3_);
		if (_tmp4_) {
			_tmp1_ = TRUE;
		} else {
			Number* _tmp5_;
			Number* _tmp6_;
			_tmp5_ = number_new_integer ((gint64) -1, (gint64) 0);
			_tmp6_ = _tmp5_;
			_tmp1_ = number_compare (self, _tmp6_) < 0;
			_g_object_unref0 (_tmp6_);
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Number* _tmp7_;
		number_set_error (_ ("Inverse cosine is undefined for values outside [-1, 1]"));
		_tmp7_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp7_;
		return result;
	}
	_tmp8_ = number_new ();
	z = _tmp8_;
	_tmp9_ = z;
	mpc_acos (&_tmp9_->priv->num, &self->priv->num, MPC_RNDNN);
	_tmp10_ = z;
	if (!number_is_complex (_tmp10_)) {
		Number* _tmp11_;
		Number* _tmp12_;
		_tmp11_ = z;
		_tmp12_ = z;
		number_mpc_from_radians (&_tmp11_->priv->num, &_tmp12_->priv->num, unit);
	}
	result = z;
	return result;
}

Number*
number_atan (Number* self,
             AngleUnit unit)
{
	gboolean _tmp0_ = FALSE;
	Number* _tmp1_;
	Number* _tmp2_;
	gboolean _tmp3_;
	Number* z = NULL;
	Number* _tmp7_;
	Number* _tmp8_;
	Number* _tmp9_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = number_new_integer ((gint64) 0, (gint64) 1);
	_tmp2_ = _tmp1_;
	_tmp3_ = number_equals (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		_tmp0_ = TRUE;
	} else {
		Number* _tmp4_;
		Number* _tmp5_;
		_tmp4_ = number_new_integer ((gint64) 0, (gint64) -1);
		_tmp5_ = _tmp4_;
		_tmp0_ = number_equals (self, _tmp5_);
		_g_object_unref0 (_tmp5_);
	}
	if (_tmp0_) {
		Number* _tmp6_;
		number_set_error (_ ("Inverse tangent is undefined for values i and -i"));
		_tmp6_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp6_;
		return result;
	}
	_tmp7_ = number_new ();
	z = _tmp7_;
	_tmp8_ = z;
	mpc_atan (&_tmp8_->priv->num, &self->priv->num, MPC_RNDNN);
	_tmp9_ = z;
	if (!number_is_complex (_tmp9_)) {
		Number* _tmp10_;
		Number* _tmp11_;
		_tmp10_ = z;
		_tmp11_ = z;
		number_mpc_from_radians (&_tmp10_->priv->num, &_tmp11_->priv->num, unit);
	}
	result = z;
	return result;
}

Number*
number_sinh (Number* self)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_sinh (&z->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_cosh (Number* self)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_cosh (&z->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_tanh (Number* self)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_tanh (&z->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_asinh (Number* self)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_asinh (&z->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_acosh (Number* self)
{
	Number* t = NULL;
	Number* _tmp0_;
	gboolean _tmp1_ = FALSE;
	Number* z = NULL;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new_integer ((gint64) 1, (gint64) 0);
	t = _tmp0_;
	if (!number_is_complex (self)) {
		Number* _tmp2_;
		_tmp2_ = t;
		_tmp1_ = number_compare (self, _tmp2_) < 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		Number* _tmp3_;
		number_set_error (_ ("Inverse hyperbolic cosine is undefined for values less than one"));
		_tmp3_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp3_;
		_g_object_unref0 (t);
		return result;
	}
	_tmp4_ = number_new ();
	z = _tmp4_;
	_tmp5_ = z;
	mpc_acosh (&_tmp5_->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	_g_object_unref0 (t);
	return result;
}

Number*
number_atanh (Number* self)
{
	gboolean _tmp0_ = FALSE;
	Number* z = NULL;
	Number* _tmp8_;
	Number* _tmp9_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (!number_is_complex (self)) {
		gboolean _tmp1_ = FALSE;
		Number* _tmp2_;
		Number* _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = number_new_integer ((gint64) 1, (gint64) 0);
		_tmp3_ = _tmp2_;
		_tmp4_ = number_compare (self, _tmp3_) >= 0;
		_g_object_unref0 (_tmp3_);
		if (_tmp4_) {
			_tmp1_ = TRUE;
		} else {
			Number* _tmp5_;
			Number* _tmp6_;
			_tmp5_ = number_new_integer ((gint64) -1, (gint64) 0);
			_tmp6_ = _tmp5_;
			_tmp1_ = number_compare (self, _tmp6_) <= 0;
			_g_object_unref0 (_tmp6_);
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Number* _tmp7_;
		number_set_error (_ ("Inverse hyperbolic tangent is undefined for values outside [-1, 1]"));
		_tmp7_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp7_;
		return result;
	}
	_tmp8_ = number_new ();
	z = _tmp8_;
	_tmp9_ = z;
	mpc_atanh (&_tmp9_->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

static gint
__lambda4_ (Number* self,
            gint v1,
            gint v2)
{
	gint result;
	result = v1 & v2;
	return result;
}

static gint
___lambda4__bitwise_func (gint v1,
                          gint v2,
                          gpointer self)
{
	gint result;
	result = __lambda4_ ((Number*) self, v1, v2);
	return result;
}

Number*
number_and (Number* self,
            Number* y)
{
	gboolean _tmp0_ = FALSE;
	Number* _tmp2_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	if (!number_is_natural (self)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !number_is_natural (y);
	}
	if (_tmp0_) {
		Number* _tmp1_;
		number_set_error (_ ("Bitwise AND is only defined for non-negative integers"));
		_tmp1_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = number_bitwise (self, y, ___lambda4__bitwise_func, self, 0);
	result = _tmp2_;
	return result;
}

static gint
__lambda5_ (Number* self,
            gint v1,
            gint v2)
{
	gint result;
	result = v1 & v2;
	return result;
}

static gint
___lambda5__bitwise_func (gint v1,
                          gint v2,
                          gpointer self)
{
	gint result;
	result = __lambda5_ ((Number*) self, v1, v2);
	return result;
}

Number*
number_nand (Number* self,
             Number* y,
             gint wordlen)
{
	gboolean _tmp0_ = FALSE;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	if (!number_is_natural (self)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !number_is_natural (y);
	}
	if (_tmp0_) {
		Number* _tmp1_;
		number_set_error (_ ("Bitwise NAND is only defined for non-negative integers"));
		_tmp1_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = number_bitwise (self, y, ___lambda5__bitwise_func, self, wordlen);
	_tmp3_ = _tmp2_;
	_tmp4_ = number_not (_tmp3_, wordlen);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	result = _tmp5_;
	return result;
}

static gint
__lambda7_ (Number* self,
            gint v1,
            gint v2)
{
	gint result;
	result = v1 | v2;
	return result;
}

static gint
___lambda7__bitwise_func (gint v1,
                          gint v2,
                          gpointer self)
{
	gint result;
	result = __lambda7_ ((Number*) self, v1, v2);
	return result;
}

Number*
number_or (Number* self,
           Number* y)
{
	gboolean _tmp0_ = FALSE;
	Number* _tmp2_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	if (!number_is_natural (self)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !number_is_natural (y);
	}
	if (_tmp0_) {
		Number* _tmp1_;
		number_set_error (_ ("Bitwise OR is only defined for non-negative integers"));
		_tmp1_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = number_bitwise (self, y, ___lambda7__bitwise_func, self, 0);
	result = _tmp2_;
	return result;
}

static gint
__lambda8_ (Number* self,
            gint v1,
            gint v2)
{
	gint result;
	result = v1 | v2;
	return result;
}

static gint
___lambda8__bitwise_func (gint v1,
                          gint v2,
                          gpointer self)
{
	gint result;
	result = __lambda8_ ((Number*) self, v1, v2);
	return result;
}

Number*
number_nor (Number* self,
            Number* y,
            gint wordlen)
{
	gboolean _tmp0_ = FALSE;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	if (!number_is_natural (self)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !number_is_natural (y);
	}
	if (_tmp0_) {
		Number* _tmp1_;
		number_set_error (_ ("Bitwise NOR is only defined for non-negative integers"));
		_tmp1_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = number_bitwise (self, y, ___lambda8__bitwise_func, self, wordlen);
	_tmp3_ = _tmp2_;
	_tmp4_ = number_not (_tmp3_, wordlen);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	result = _tmp5_;
	return result;
}

static gint
__lambda9_ (Number* self,
            gint v1,
            gint v2)
{
	gint result;
	result = v1 ^ v2;
	return result;
}

static gint
___lambda9__bitwise_func (gint v1,
                          gint v2,
                          gpointer self)
{
	gint result;
	result = __lambda9_ ((Number*) self, v1, v2);
	return result;
}

Number*
number_xor (Number* self,
            Number* y)
{
	gboolean _tmp0_ = FALSE;
	Number* _tmp2_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	if (!number_is_natural (self)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !number_is_natural (y);
	}
	if (_tmp0_) {
		Number* _tmp1_;
		number_set_error (_ ("Bitwise XOR is only defined for non-negative integers"));
		_tmp1_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = number_bitwise (self, y, ___lambda9__bitwise_func, self, 0);
	result = _tmp2_;
	return result;
}

static gint
__lambda10_ (Number* self,
             gint v1,
             gint v2)
{
	gint result;
	result = v1 ^ v2;
	return result;
}

static gint
___lambda10__bitwise_func (gint v1,
                           gint v2,
                           gpointer self)
{
	gint result;
	result = __lambda10_ ((Number*) self, v1, v2);
	return result;
}

Number*
number_xnor (Number* self,
             Number* y,
             gint wordlen)
{
	gboolean _tmp0_ = FALSE;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	if (!number_is_natural (self)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !number_is_natural (y);
	}
	if (_tmp0_) {
		Number* _tmp1_;
		number_set_error (_ ("Bitwise XNOR is only defined for non-negative integers"));
		_tmp1_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = number_bitwise (self, y, ___lambda10__bitwise_func, self, wordlen);
	_tmp3_ = _tmp2_;
	_tmp4_ = number_not (_tmp3_, wordlen);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	result = _tmp5_;
	return result;
}

static gint
__lambda6_ (Number* self,
            gint v1,
            gint v2)
{
	gint result;
	result = v1 ^ 0xF;
	return result;
}

static gint
___lambda6__bitwise_func (gint v1,
                          gint v2,
                          gpointer self)
{
	gint result;
	result = __lambda6_ ((Number*) self, v1, v2);
	return result;
}

Number*
number_not (Number* self,
            gint wordlen)
{
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (!number_is_natural (self)) {
		Number* _tmp0_;
		number_set_error (_ ("Bitwise NOT is only defined for non-negative integers"));
		_tmp0_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = number_new_integer ((gint64) 0, (gint64) 0);
	_tmp2_ = _tmp1_;
	_tmp3_ = number_bitwise (self, _tmp2_, ___lambda6__bitwise_func, self, wordlen);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

Number*
number_left_shift (Number* self,
                   Number* count,
                   gint wordlen)
{
	guint64 _tmp1_ = 0ULL;
	guint64 bits = 0ULL;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* _tmp8_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (count != NULL, NULL);
	if (!number_can_shift (self, count, wordlen)) {
		Number* _tmp0_;
		_tmp0_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp0_;
		return result;
	}
	if (number_is_negative (self)) {
		_tmp1_ = (guint64) number_to_integer (self);
	} else {
		_tmp1_ = number_to_unsigned_integer (self);
	}
	bits = _tmp1_;
	_tmp2_ = number_new_integer ((gint64) wordlen, (gint64) 0);
	_tmp3_ = _tmp2_;
	_tmp4_ = number_modulus_divide (count, _tmp3_);
	_tmp5_ = _tmp4_;
	bits <<= (guint64) number_to_integer (_tmp5_);
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	if (wordlen != 64) {
		gboolean _tmp6_ = FALSE;
		if (number_is_negative (self)) {
			_tmp6_ = (bits & (1ULL << (wordlen - 1))) != ((guint64) 0);
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			bits |= G_MAXUINT64 << wordlen;
		} else {
			bits &= G_MAXUINT64 >> (64 - wordlen);
		}
	}
	if (number_is_negative (self)) {
		Number* _tmp7_;
		_tmp7_ = number_new_integer ((gint64) bits, (gint64) 0);
		result = _tmp7_;
		return result;
	}
	_tmp8_ = number_new_unsigned_integer (bits, (guint64) 0);
	result = _tmp8_;
	return result;
}

Number*
number_right_shift (Number* self,
                    Number* count,
                    gint wordlen)
{
	guint64 bits = 0ULL;
	Number* _tmp6_;
	Number* _tmp7_;
	Number* _tmp8_;
	Number* _tmp9_;
	Number* _tmp10_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (count != NULL, NULL);
	if (!number_can_shift (self, count, wordlen)) {
		Number* _tmp0_;
		_tmp0_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp0_;
		return result;
	}
	if (number_is_negative (self)) {
		gint64 bits = 0LL;
		Number* _tmp1_;
		Number* _tmp2_;
		Number* _tmp3_;
		Number* _tmp4_;
		Number* _tmp5_;
		bits = number_to_integer (self);
		_tmp1_ = number_new_integer ((gint64) wordlen, (gint64) 0);
		_tmp2_ = _tmp1_;
		_tmp3_ = number_modulus_divide (count, _tmp2_);
		_tmp4_ = _tmp3_;
		bits >>= number_to_integer (_tmp4_);
		_g_object_unref0 (_tmp4_);
		_g_object_unref0 (_tmp2_);
		_tmp5_ = number_new_integer (bits, (gint64) 0);
		result = _tmp5_;
		return result;
	}
	bits = number_to_unsigned_integer (self);
	_tmp6_ = number_new_integer ((gint64) wordlen, (gint64) 0);
	_tmp7_ = _tmp6_;
	_tmp8_ = number_modulus_divide (count, _tmp7_);
	_tmp9_ = _tmp8_;
	bits >>= (guint64) number_to_integer (_tmp9_);
	_g_object_unref0 (_tmp9_);
	_g_object_unref0 (_tmp7_);
	_tmp10_ = number_new_unsigned_integer (bits, (guint64) 0);
	result = _tmp10_;
	return result;
}

Number*
number_unsigned_right_shift (Number* self,
                             Number* count,
                             gint wordlen)
{
	guint64 _tmp1_ = 0ULL;
	guint64 bits = 0ULL;
	gboolean _tmp2_ = FALSE;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* _tmp6_;
	Number* _tmp7_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (count != NULL, NULL);
	if (!number_can_shift (self, count, wordlen)) {
		Number* _tmp0_;
		_tmp0_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp0_;
		return result;
	}
	if (number_is_negative (self)) {
		_tmp1_ = (guint64) number_to_integer (self);
	} else {
		_tmp1_ = number_to_unsigned_integer (self);
	}
	bits = _tmp1_;
	if (wordlen != 64) {
		_tmp2_ = number_is_negative (self);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		bits &= G_MAXUINT64 >> (64 - wordlen);
	}
	_tmp3_ = number_new_integer ((gint64) wordlen, (gint64) 0);
	_tmp4_ = _tmp3_;
	_tmp5_ = number_modulus_divide (count, _tmp4_);
	_tmp6_ = _tmp5_;
	bits >>= (guint64) number_to_integer (_tmp6_);
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp4_);
	_tmp7_ = number_new_unsigned_integer (bits, (guint64) 0);
	result = _tmp7_;
	return result;
}

static gboolean
number_can_shift (Number* self,
                  Number* count,
                  gint wordlen)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (count != NULL, FALSE);
	if (!number_is_integer (self)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !number_is_integer (count);
	}
	if (_tmp0_) {
		number_set_error (_ ("Shift is only possible on integers"));
		result = FALSE;
		return result;
	}
	if (number_is_overflow (self, wordlen, TRUE)) {
		number_set_error (_ ("Overflow. Try a bigger word size"));
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static gint
__lambda11_ (Number* self,
             gint v1,
             gint v2)
{
	gint result;
	result = v1 ^ v2;
	return result;
}

static gint
___lambda11__bitwise_func (gint v1,
                           gint v2,
                           gpointer self)
{
	gint result;
	result = __lambda11_ ((Number*) self, v1, v2);
	return result;
}

Number*
number_ones_complement (Number* self,
                        gint wordlen)
{
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* _tmp6_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (!number_is_natural (self)) {
		Number* _tmp0_;
		number_set_error (_ ("Ones’ complement is only defined for non-negative integers"));
		_tmp0_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = number_new_integer ((gint64) 0, (gint64) 0);
	_tmp2_ = _tmp1_;
	_tmp3_ = number_bitwise (self, _tmp2_, ___lambda11__bitwise_func, self, wordlen);
	_tmp4_ = _tmp3_;
	_tmp5_ = number_not (_tmp4_, wordlen);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}

Number*
number_twos_complement (Number* self,
                        gint wordlen)
{
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* _tmp6_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (!number_is_natural (self)) {
		Number* _tmp0_;
		number_set_error (_ ("Two’s complement is only defined for non-negative integers"));
		_tmp0_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = number_ones_complement (self, wordlen);
	_tmp2_ = _tmp1_;
	_tmp3_ = number_new_integer ((gint64) 1, (gint64) 0);
	_tmp4_ = _tmp3_;
	_tmp5_ = number_add (_tmp2_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}

Number*
number_swap_endianness (Number* self,
                        gint wordlen)
{
	guint64 _tmp2_ = 0ULL;
	guint64 bits = 0ULL;
	guint64 new_bits = 0ULL;
	gboolean _tmp6_ = FALSE;
	Number* _tmp7_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (!number_is_integer (self)) {
		Number* _tmp0_;
		number_set_error (_ ("Swap endianness is only possible on integers"));
		_tmp0_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp0_;
		return result;
	}
	if (number_is_overflow (self, wordlen, TRUE)) {
		Number* _tmp1_;
		number_set_error (_ ("Overflow. Try a bigger word size"));
		_tmp1_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp1_;
		return result;
	}
	if (number_is_negative (self)) {
		_tmp2_ = (guint64) number_to_integer (self);
	} else {
		_tmp2_ = number_to_unsigned_integer (self);
	}
	bits = _tmp2_;
	new_bits = (guint64) 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (!(i < (wordlen / 8))) {
					break;
				}
				new_bits = (new_bits << 8) | (bits & 0xFF);
				bits >>= (guint64) 8;
			}
		}
	}
	if (!number_is_negative (self)) {
		Number* _tmp5_;
		_tmp5_ = number_new_unsigned_integer (new_bits, (guint64) 0);
		result = _tmp5_;
		return result;
	}
	if (wordlen != 64) {
		_tmp6_ = (new_bits & (1ULL << (wordlen - 1))) != ((guint64) 0);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		new_bits |= G_MAXUINT64 << wordlen;
	}
	_tmp7_ = number_new_integer ((gint64) new_bits, (gint64) 0);
	result = _tmp7_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

Number*
number_combination (Number* self,
                    Number* r)
{
	gboolean _tmp0_ = FALSE;
	Number* _tmp3_ = NULL;
	Number* _tmp4_;
	Number* _tmp5_;
	gboolean _tmp6_;
	Number* r1 = NULL;
	Number* _tmp9_;
	Number* _tmp10_;
	Number* _tmp11_;
	Number* _tmp12_;
	Number* _tmp13_;
	Number* _tmp14_;
	Number* _tmp15_;
	Number* _tmp16_;
	Number* _tmp17_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (r != NULL, NULL);
	if (!number_is_natural (self)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !number_is_natural (r);
	}
	if (_tmp0_) {
		Number* _tmp1_;
		number_set_error (_ ("Combination is only defined for non-negative integers"));
		_tmp1_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp1_;
		return result;
	}
	if (number_compare (self, r) < 0) {
		Number* _tmp2_;
		number_set_error (_ ("Combination is undefined if n is less than r"));
		_tmp2_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp2_;
		return result;
	}
	_tmp4_ = number_divide_integer (self, (gint64) 2);
	_tmp5_ = _tmp4_;
	_tmp6_ = number_compare (r, _tmp5_) <= 0;
	_g_object_unref0 (_tmp5_);
	if (_tmp6_) {
		Number* _tmp7_;
		_tmp7_ = _g_object_ref0 (r);
		_g_object_unref0 (_tmp3_);
		_tmp3_ = _tmp7_;
	} else {
		Number* _tmp8_;
		_tmp8_ = number_subtract (self, r);
		_g_object_unref0 (_tmp3_);
		_tmp3_ = _tmp8_;
	}
	_tmp9_ = _g_object_ref0 (_tmp3_);
	r1 = _tmp9_;
	_tmp10_ = r1;
	_tmp11_ = number_permutation (self, _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = r1;
	_tmp14_ = number_factorial (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = number_divide (_tmp12_, _tmp15_);
	_tmp17_ = _tmp16_;
	_g_object_unref0 (_tmp15_);
	_g_object_unref0 (_tmp12_);
	result = _tmp17_;
	_g_object_unref0 (r1);
	_g_object_unref0 (_tmp3_);
	return result;
}

Number*
number_permutation (Number* self,
                    Number* r)
{
	gboolean _tmp0_ = FALSE;
	gint64 value = 0LL;
	Number* z = NULL;
	Number* _tmp4_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (r != NULL, NULL);
	if (!number_is_natural (self)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !number_is_natural (r);
	}
	if (_tmp0_) {
		Number* _tmp1_;
		number_set_error (_ ("Permutation is only defined for non-negative integers"));
		_tmp1_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp1_;
		return result;
	}
	if (number_compare (self, r) < 0) {
		Number* _tmp2_;
		number_set_error (_ ("Permutation is undefined if n is less than r"));
		_tmp2_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp2_;
		return result;
	}
	if (number_is_zero (r)) {
		Number* _tmp3_;
		_tmp3_ = number_new_integer ((gint64) 1, (gint64) 0);
		result = _tmp3_;
		return result;
	}
	value = number_to_integer (self);
	_tmp4_ = _g_object_ref0 (self);
	z = _tmp4_;
	{
		gint64 i = 0LL;
		i = (value - number_to_integer (r)) + 1;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				Number* _tmp7_;
				Number* _tmp8_;
				if (!_tmp5_) {
					gint64 _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				if (!(i < value)) {
					break;
				}
				_tmp7_ = z;
				_tmp8_ = number_multiply_integer (_tmp7_, i);
				_g_object_unref0 (z);
				z = _tmp8_;
			}
		}
	}
	result = z;
	return result;
}

Number*
number_gcd (Number** args,
            gint args_length1)
{
	Number* z = NULL;
	Number* _tmp6_;
	Number* _tmp7_;
	Number* _tmp8_;
	Number* _tmp14_;
	Number* _tmp15_;
	Number* result;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				Number* _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < args_length1)) {
					break;
				}
				_tmp2_ = args[i];
				if (!number_is_integer (_tmp2_)) {
					Number* _tmp3_;
					number_set_error (_ ("Greatest common divisor is only defined for integers"));
					_tmp3_ = number_new_integer ((gint64) 0, (gint64) 0);
					result = _tmp3_;
					return result;
				}
			}
		}
	}
	if (args_length1 == 1) {
		Number* _tmp4_;
		Number* _tmp5_;
		_tmp4_ = args[0];
		_tmp5_ = number_abs (_tmp4_);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = args[0];
	_tmp7_ = args[1];
	_tmp8_ = number_gcd_x_y (_tmp6_, _tmp7_);
	z = _tmp8_;
	{
		gint i = 0;
		i = 2;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				Number* _tmp11_;
				Number* _tmp12_;
				Number* _tmp13_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				if (!(i < args_length1)) {
					break;
				}
				_tmp11_ = z;
				_tmp12_ = args[i];
				_tmp13_ = number_gcd_x_y (_tmp11_, _tmp12_);
				_g_object_unref0 (z);
				z = _tmp13_;
			}
		}
	}
	_tmp14_ = z;
	_tmp15_ = number_abs (_tmp14_);
	result = _tmp15_;
	_g_object_unref0 (z);
	return result;
}

Number*
number_lcm (Number** args,
            gint args_length1)
{
	Number* z = NULL;
	Number* _tmp6_;
	Number* _tmp7_;
	Number* _tmp8_;
	Number* _tmp14_;
	Number* _tmp15_;
	Number* result;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				Number* _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < args_length1)) {
					break;
				}
				_tmp2_ = args[i];
				if (!number_is_integer (_tmp2_)) {
					Number* _tmp3_;
					number_set_error (_ ("Least common multiple is only defined for integers"));
					_tmp3_ = number_new_integer ((gint64) 0, (gint64) 0);
					result = _tmp3_;
					return result;
				}
			}
		}
	}
	if (args_length1 == 1) {
		Number* _tmp4_;
		Number* _tmp5_;
		_tmp4_ = args[0];
		_tmp5_ = number_abs (_tmp4_);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = args[0];
	_tmp7_ = args[1];
	_tmp8_ = number_lcm_x_y (_tmp6_, _tmp7_);
	z = _tmp8_;
	{
		gint i = 0;
		i = 2;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				Number* _tmp11_;
				Number* _tmp12_;
				Number* _tmp13_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				if (!(i < args_length1)) {
					break;
				}
				_tmp11_ = z;
				_tmp12_ = args[i];
				_tmp13_ = number_lcm_x_y (_tmp11_, _tmp12_);
				_g_object_unref0 (z);
				z = _tmp13_;
			}
		}
	}
	_tmp14_ = z;
	_tmp15_ = number_abs (_tmp14_);
	result = _tmp15_;
	_g_object_unref0 (z);
	return result;
}

static Number*
number_gcd_x_y (Number* x,
                Number* y)
{
	Number* a = NULL;
	Number* _tmp0_;
	Number* b = NULL;
	Number* _tmp1_;
	Number* result;
	g_return_val_if_fail (x != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp0_ = _g_object_ref0 (x);
	a = _tmp0_;
	_tmp1_ = _g_object_ref0 (y);
	b = _tmp1_;
	while (TRUE) {
		Number* _tmp2_;
		Number* remainder = NULL;
		Number* _tmp3_;
		Number* _tmp4_;
		Number* _tmp5_;
		Number* _tmp6_;
		Number* _tmp7_;
		Number* _tmp8_;
		Number* _tmp9_;
		_tmp2_ = b;
		if (!(!number_is_zero (_tmp2_))) {
			break;
		}
		_tmp3_ = a;
		_tmp4_ = b;
		_tmp5_ = number_modulus_divide (_tmp3_, _tmp4_);
		remainder = _tmp5_;
		_tmp6_ = b;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_g_object_unref0 (a);
		a = _tmp7_;
		_tmp8_ = remainder;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_g_object_unref0 (b);
		b = _tmp9_;
		_g_object_unref0 (remainder);
	}
	result = a;
	_g_object_unref0 (b);
	return result;
}

static Number*
number_lcm_x_y (Number* x,
                Number* y)
{
	gboolean _tmp0_ = FALSE;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* _tmp6_;
	Number* _tmp7_;
	Number* result;
	g_return_val_if_fail (x != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	if (number_is_zero (x)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = number_is_zero (y);
	}
	if (_tmp0_) {
		Number* _tmp1_;
		_tmp1_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = number_gcd_x_y (x, y);
	_tmp3_ = _tmp2_;
	_tmp4_ = number_divide (x, _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = number_multiply (_tmp5_, y);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	result = _tmp7_;
	return result;
}

Number*
number_sum (Number** args,
            gint args_length1)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* result;
	_tmp0_ = number_new_integer ((gint64) 0, (gint64) 0);
	z = _tmp0_;
	{
		Number** x_collection = NULL;
		gint x_collection_length1 = 0;
		gint _x_collection_size_ = 0;
		gint x_it = 0;
		x_collection = args;
		x_collection_length1 = args_length1;
		for (x_it = 0; x_it < x_collection_length1; x_it = x_it + 1) {
			Number* _tmp1_;
			Number* x = NULL;
			_tmp1_ = _g_object_ref0 (x_collection[x_it]);
			x = _tmp1_;
			{
				Number* _tmp2_;
				Number* _tmp3_;
				Number* _tmp4_;
				_tmp2_ = z;
				_tmp3_ = x;
				_tmp4_ = number_add (_tmp2_, _tmp3_);
				_g_object_unref0 (z);
				z = _tmp4_;
				_g_object_unref0 (x);
			}
		}
	}
	result = z;
	return result;
}

Number*
number_sum_squares (Number** args,
                    gint args_length1)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* result;
	_tmp0_ = number_new_integer ((gint64) 0, (gint64) 0);
	z = _tmp0_;
	{
		Number** x_collection = NULL;
		gint x_collection_length1 = 0;
		gint _x_collection_size_ = 0;
		gint x_it = 0;
		x_collection = args;
		x_collection_length1 = args_length1;
		for (x_it = 0; x_it < x_collection_length1; x_it = x_it + 1) {
			Number* _tmp1_;
			Number* x = NULL;
			_tmp1_ = _g_object_ref0 (x_collection[x_it]);
			x = _tmp1_;
			{
				Number* _tmp2_;
				Number* _tmp3_;
				Number* _tmp4_;
				Number* _tmp5_;
				Number* _tmp6_;
				_tmp2_ = z;
				_tmp3_ = x;
				_tmp4_ = number_xpowy_integer (_tmp3_, (gint64) 2);
				_tmp5_ = _tmp4_;
				_tmp6_ = number_add (_tmp2_, _tmp5_);
				_g_object_unref0 (z);
				z = _tmp6_;
				_g_object_unref0 (_tmp5_);
				_g_object_unref0 (x);
			}
		}
	}
	result = z;
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static Number**
_vala_array_dup12 (Number** self,
                   gssize length)
{
	if (length >= 0) {
		Number** result;
		gssize i;
		result = g_new0 (Number*, length + 1);
		for (i = 0; i < length; i++) {
			Number* _tmp0_;
			_tmp0_ = _g_object_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		GPtrArray* self;
		self = _data2_->self;
		_g_ptr_array_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gint
__lambda0_ (Block2Data* _data2_,
            gconstpointer** a,
            gconstpointer** b)
{
	GPtrArray* self;
	gint result;
	self = _data2_->self;
	result = _data2_->compare_func ((gconstpointer**) (*a), (gconstpointer**) (*b));
	return result;
}

static gint
___lambda0__gcompare_data_func (gconstpointer a,
                                gconstpointer b,
                                gpointer self)
{
	gint result;
	result = __lambda0_ (self, a, b);
	return result;
}

static void
vala_g_ptr_array_sort (GPtrArray* self,
                       GCompareFunc compare_func)
{
	Block2Data* _data2_;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_ptr_array_ref (self);
	_data2_->compare_func = compare_func;
	g_ptr_array_sort_with_data (self, ___lambda0__gcompare_data_func, _data2_);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static gint
__lambda12_ (Number* a,
             Number* b)
{
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	result = number_compare (a, b);
	return result;
}

static gint
___lambda12__gcompare_func (gconstpointer a,
                            gconstpointer b)
{
	gint result;
	result = __lambda12_ ((Number*) a, (Number*) b);
	return result;
}

Number*
number_median (Number** args,
               gint args_length1)
{
	GPtrArray* array = NULL;
	GPtrArray* _tmp3_;
	GPtrArray* _tmp4_;
	Number** _tmp5_;
	gint _tmp5__length1;
	GPtrArray* _tmp6_;
	GPtrArray* _tmp10_;
	gconstpointer _tmp11_;
	GPtrArray* _tmp12_;
	gconstpointer _tmp13_;
	Number* _tmp14_;
	Number* _tmp15_;
	Number* _tmp16_;
	Number* _tmp17_;
	Number* result;
	{
		Number** x_collection = NULL;
		gint x_collection_length1 = 0;
		gint _x_collection_size_ = 0;
		gint x_it = 0;
		x_collection = args;
		x_collection_length1 = args_length1;
		for (x_it = 0; x_it < x_collection_length1; x_it = x_it + 1) {
			Number* _tmp0_;
			Number* x = NULL;
			_tmp0_ = _g_object_ref0 (x_collection[x_it]);
			x = _tmp0_;
			{
				Number* _tmp1_;
				_tmp1_ = x;
				if (number_is_complex (_tmp1_)) {
					Number* _tmp2_;
					number_set_error (_ ("Median is only defined for real numbers"));
					_tmp2_ = number_new_integer ((gint64) 0, (gint64) 0);
					result = _tmp2_;
					_g_object_unref0 (x);
					return result;
				}
				_g_object_unref0 (x);
			}
		}
	}
	_tmp3_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	array = _tmp3_;
	_tmp4_ = array;
	_tmp5_ = (args != NULL) ? _vala_array_dup12 (args, args_length1) : args;
	_tmp5__length1 = args_length1;
	_tmp4_->pdata = (_vala_array_free (_tmp4_->pdata, _tmp4_->len, (GDestroyNotify) g_object_unref), NULL);
	_tmp4_->pdata = _tmp5_;
	_tmp4_->len = _tmp5__length1;
	_tmp6_ = array;
	vala_g_ptr_array_sort (_tmp6_, ___lambda12__gcompare_func);
	if ((args_length1 % 2) != 0) {
		GPtrArray* _tmp7_;
		gconstpointer _tmp8_;
		Number* _tmp9_;
		_tmp7_ = array;
		_tmp8_ = g_ptr_array_index (_tmp7_, (guint) (args_length1 / 2));
		_tmp9_ = _g_object_ref0 ((Number*) _tmp8_);
		result = _tmp9_;
		_g_ptr_array_unref0 (array);
		return result;
	}
	_tmp10_ = array;
	_tmp11_ = g_ptr_array_index (_tmp10_, (guint) (args_length1 / 2));
	_tmp12_ = array;
	_tmp13_ = g_ptr_array_index (_tmp12_, (guint) ((args_length1 / 2) - 1));
	_tmp14_ = number_add ((Number*) _tmp11_, (Number*) _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = number_divide_integer (_tmp15_, (gint64) 2);
	_tmp17_ = _tmp16_;
	_g_object_unref0 (_tmp15_);
	result = _tmp17_;
	_g_ptr_array_unref0 (array);
	return result;
}

Number*
number_min (Number** args,
            gint args_length1)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* result;
	_tmp0_ = args[0];
	_tmp1_ = _g_object_ref0 (_tmp0_);
	z = _tmp1_;
	{
		Number** x_collection = NULL;
		gint x_collection_length1 = 0;
		gint _x_collection_size_ = 0;
		gint x_it = 0;
		x_collection = args;
		x_collection_length1 = args_length1;
		for (x_it = 0; x_it < x_collection_length1; x_it = x_it + 1) {
			Number* _tmp2_;
			Number* x = NULL;
			_tmp2_ = _g_object_ref0 (x_collection[x_it]);
			x = _tmp2_;
			{
				Number* _tmp3_;
				Number* _tmp5_;
				Number* _tmp6_;
				_tmp3_ = x;
				if (number_is_complex (_tmp3_)) {
					Number* _tmp4_;
					number_set_error (_ ("Minimum value is only defined for real numbers"));
					_tmp4_ = number_new_integer ((gint64) 0, (gint64) 0);
					result = _tmp4_;
					_g_object_unref0 (x);
					_g_object_unref0 (z);
					return result;
				}
				_tmp5_ = x;
				_tmp6_ = z;
				if (number_compare (_tmp5_, _tmp6_) < 0) {
					Number* _tmp7_;
					Number* _tmp8_;
					_tmp7_ = x;
					_tmp8_ = _g_object_ref0 (_tmp7_);
					_g_object_unref0 (z);
					z = _tmp8_;
				}
				_g_object_unref0 (x);
			}
		}
	}
	result = z;
	return result;
}

Number*
number_max (Number** args,
            gint args_length1)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* result;
	_tmp0_ = args[0];
	_tmp1_ = _g_object_ref0 (_tmp0_);
	z = _tmp1_;
	{
		Number** x_collection = NULL;
		gint x_collection_length1 = 0;
		gint _x_collection_size_ = 0;
		gint x_it = 0;
		x_collection = args;
		x_collection_length1 = args_length1;
		for (x_it = 0; x_it < x_collection_length1; x_it = x_it + 1) {
			Number* _tmp2_;
			Number* x = NULL;
			_tmp2_ = _g_object_ref0 (x_collection[x_it]);
			x = _tmp2_;
			{
				Number* _tmp3_;
				Number* _tmp5_;
				Number* _tmp6_;
				_tmp3_ = x;
				if (number_is_complex (_tmp3_)) {
					Number* _tmp4_;
					number_set_error (_ ("Maximum value is only defined for real numbers"));
					_tmp4_ = number_new_integer ((gint64) 0, (gint64) 0);
					result = _tmp4_;
					_g_object_unref0 (x);
					_g_object_unref0 (z);
					return result;
				}
				_tmp5_ = x;
				_tmp6_ = z;
				if (number_compare (_tmp5_, _tmp6_) > 0) {
					Number* _tmp7_;
					Number* _tmp8_;
					_tmp7_ = x;
					_tmp8_ = _g_object_ref0 (_tmp7_);
					_g_object_unref0 (z);
					z = _tmp8_;
				}
				_g_object_unref0 (x);
			}
		}
	}
	result = z;
	return result;
}

Number*
number_variance (Number** args,
                 gint args_length1,
                 gboolean is_sample)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* average = NULL;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	gint _tmp16_ = 0;
	Number* _tmp17_;
	Number* _tmp18_;
	Number* result;
	_tmp0_ = number_new_integer ((gint64) 0, (gint64) 0);
	z = _tmp0_;
	_tmp1_ = number_sum (args, (gint) args_length1);
	_tmp2_ = _tmp1_;
	_tmp3_ = number_divide_integer (_tmp2_, (gint64) args_length1);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	average = _tmp4_;
	{
		Number** x_collection = NULL;
		gint x_collection_length1 = 0;
		gint _x_collection_size_ = 0;
		gint x_it = 0;
		x_collection = args;
		x_collection_length1 = args_length1;
		for (x_it = 0; x_it < x_collection_length1; x_it = x_it + 1) {
			Number* _tmp5_;
			Number* x = NULL;
			_tmp5_ = _g_object_ref0 (x_collection[x_it]);
			x = _tmp5_;
			{
				Number* _tmp6_;
				Number* _tmp7_;
				Number* _tmp8_;
				Number* _tmp9_;
				Number* _tmp10_;
				Number* _tmp11_;
				Number* _tmp12_;
				Number* _tmp13_;
				Number* _tmp14_;
				Number* _tmp15_;
				_tmp6_ = z;
				_tmp7_ = x;
				_tmp8_ = average;
				_tmp9_ = number_subtract (_tmp7_, _tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = number_abs (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = number_xpowy_integer (_tmp12_, (gint64) 2);
				_tmp14_ = _tmp13_;
				_tmp15_ = number_add (_tmp6_, _tmp14_);
				_g_object_unref0 (z);
				z = _tmp15_;
				_g_object_unref0 (_tmp14_);
				_g_object_unref0 (_tmp12_);
				_g_object_unref0 (_tmp10_);
				_g_object_unref0 (x);
			}
		}
	}
	if (is_sample) {
		_tmp16_ = args_length1 - 1;
	} else {
		_tmp16_ = args_length1;
	}
	_tmp17_ = z;
	_tmp18_ = number_divide_integer (_tmp17_, (gint64) _tmp16_);
	result = _tmp18_;
	_g_object_unref0 (average);
	_g_object_unref0 (z);
	return result;
}

static gboolean
number_is_sprp (Number* self,
                Number* p,
                guint64 b)
{
	Number* unit = NULL;
	Number* _tmp0_;
	Number* pminus = NULL;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* d = NULL;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* two = NULL;
	Number* _tmp5_;
	guint64 twofactor = 0ULL;
	Number* x = NULL;
	Number* _tmp12_;
	Number* _tmp13_;
	Number* _tmp14_;
	Number* _tmp15_;
	Number* _tmp16_;
	gboolean _tmp17_ = FALSE;
	Number* _tmp18_;
	Number* _tmp19_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (p != NULL, FALSE);
	_tmp0_ = number_new_unsigned_integer ((guint64) 1, (guint64) 0);
	unit = _tmp0_;
	_tmp1_ = unit;
	_tmp2_ = number_subtract (p, _tmp1_);
	pminus = _tmp2_;
	_tmp3_ = pminus;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	d = _tmp4_;
	_tmp5_ = number_new_unsigned_integer ((guint64) 2, (guint64) 0);
	two = _tmp5_;
	twofactor = (guint64) 0;
	while (TRUE) {
		Number* tmp = NULL;
		Number* _tmp6_;
		Number* _tmp7_;
		Number* _tmp8_;
		Number* _tmp9_;
		_tmp6_ = d;
		_tmp7_ = two;
		_tmp8_ = number_divide (_tmp6_, _tmp7_);
		tmp = _tmp8_;
		_tmp9_ = tmp;
		if (number_is_integer (_tmp9_)) {
			Number* _tmp10_;
			Number* _tmp11_;
			_tmp10_ = tmp;
			_tmp11_ = _g_object_ref0 (_tmp10_);
			_g_object_unref0 (d);
			d = _tmp11_;
			twofactor = twofactor + 1;
		} else {
			_g_object_unref0 (tmp);
			break;
		}
		_g_object_unref0 (tmp);
	}
	_tmp12_ = number_new_unsigned_integer (b, (guint64) 0);
	_tmp13_ = _tmp12_;
	_tmp14_ = d;
	_tmp15_ = number_modular_exponentiation (_tmp13_, _tmp14_, p);
	_tmp16_ = _tmp15_;
	_g_object_unref0 (_tmp13_);
	x = _tmp16_;
	_tmp18_ = x;
	_tmp19_ = unit;
	if (number_equals (_tmp18_, _tmp19_)) {
		_tmp17_ = TRUE;
	} else {
		Number* _tmp20_;
		Number* _tmp21_;
		_tmp20_ = x;
		_tmp21_ = pminus;
		_tmp17_ = number_equals (_tmp20_, _tmp21_);
	}
	if (_tmp17_) {
		result = TRUE;
		_g_object_unref0 (x);
		_g_object_unref0 (two);
		_g_object_unref0 (d);
		_g_object_unref0 (pminus);
		_g_object_unref0 (unit);
		return result;
	}
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp22_ = FALSE;
			_tmp22_ = TRUE;
			while (TRUE) {
				Number* _tmp24_;
				Number* _tmp25_;
				Number* _tmp26_;
				Number* _tmp27_;
				Number* _tmp28_;
				Number* _tmp29_;
				Number* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(((guint64) i) < twofactor)) {
					break;
				}
				_tmp24_ = x;
				_tmp25_ = x;
				_tmp26_ = number_multiply (_tmp24_, _tmp25_);
				_g_object_unref0 (x);
				x = _tmp26_;
				_tmp27_ = x;
				_tmp28_ = number_modulus_divide (_tmp27_, p);
				_g_object_unref0 (x);
				x = _tmp28_;
				_tmp29_ = x;
				_tmp30_ = pminus;
				if (number_equals (_tmp29_, _tmp30_)) {
					result = TRUE;
					_g_object_unref0 (x);
					_g_object_unref0 (two);
					_g_object_unref0 (d);
					_g_object_unref0 (pminus);
					_g_object_unref0 (unit);
					return result;
				}
			}
		}
	}
	result = FALSE;
	_g_object_unref0 (x);
	_g_object_unref0 (two);
	_g_object_unref0 (d);
	_g_object_unref0 (pminus);
	_g_object_unref0 (unit);
	return result;
}

static gboolean
number_is_prime (Number* self,
                 Number* x)
{
	static const guint64 BASES[13] = {(guint64) 2, (guint64) 3, (guint64) 5, (guint64) 7, (guint64) 11, (guint64) 13, (guint64) 17, (guint64) 19, (guint64) 23, (guint64) 29, (guint64) 31, (guint64) 37, (guint64) 41};
	guint64 sup = 0ULL;
	Number* _tmp0_;
	Number* _tmp1_;
	guint64 _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (x != NULL, FALSE);
	_tmp0_ = number_ln (x);
	_tmp1_ = _tmp0_;
	_tmp2_ = number_to_unsigned_integer (_tmp1_) + 1;
	_g_object_unref0 (_tmp1_);
	sup = _tmp2_;
	if (sup < ((guint64) 56)) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					guint64 _tmp5_;
					if (!_tmp3_) {
						gint _tmp4_;
						_tmp4_ = i;
						i = _tmp4_ + 1;
					}
					_tmp3_ = FALSE;
					if (!(i < 13)) {
						break;
					}
					_tmp5_ = BASES[i];
					if (!number_is_sprp (self, x, _tmp5_)) {
						result = FALSE;
						return result;
					}
				}
			}
		}
		result = TRUE;
		return result;
	} else {
		sup = (sup * sup) * 2;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp6_ = FALSE;
				_tmp6_ = TRUE;
				while (TRUE) {
					if (!_tmp6_) {
						gint _tmp7_;
						_tmp7_ = i;
						i = _tmp7_ + 1;
					}
					_tmp6_ = FALSE;
					if (!(((guint64) i) < sup)) {
						break;
					}
					if (!number_is_sprp (self, x, (guint64) i)) {
						result = FALSE;
						return result;
					}
				}
			}
		}
		result = TRUE;
		return result;
	}
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

GList*
number_factorize (Number* self)
{
	GList* factors = NULL;
	Number* value = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* _tmp6_;
	gboolean _tmp7_;
	Number* _tmp9_;
	Number* _tmp10_;
	Number* _tmp11_;
	gboolean _tmp12_;
	Number* int_max = NULL;
	Number* _tmp16_;
	Number* _tmp17_;
	Number* _tmp18_;
	Number* divisor = NULL;
	Number* _tmp25_;
	Number* _tmp34_;
	Number* root = NULL;
	Number* _tmp35_;
	Number* _tmp36_;
	Number* _tmp55_;
	Number* _tmp56_;
	Number* _tmp57_;
	gboolean _tmp58_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	factors = NULL;
	_tmp0_ = number_abs (self);
	value = _tmp0_;
	_tmp1_ = value;
	if (number_is_zero (_tmp1_)) {
		Number* _tmp2_;
		Number* _tmp3_;
		_tmp2_ = value;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		factors = g_list_append (factors, _tmp3_);
		result = factors;
		_g_object_unref0 (value);
		return result;
	}
	_tmp4_ = value;
	_tmp5_ = number_new_integer ((gint64) 1, (gint64) 0);
	_tmp6_ = _tmp5_;
	_tmp7_ = number_equals (_tmp4_, _tmp6_);
	_g_object_unref0 (_tmp6_);
	if (_tmp7_) {
		Number* _tmp8_;
		_tmp8_ = _g_object_ref0 (self);
		factors = g_list_append (factors, _tmp8_);
		result = factors;
		_g_object_unref0 (value);
		return result;
	}
	_tmp9_ = value;
	_tmp10_ = number_new_integer (0xFFFFFFFFLL, (gint64) 0);
	_tmp11_ = _tmp10_;
	_tmp12_ = number_compare (_tmp9_, _tmp11_) > 0;
	_g_object_unref0 (_tmp11_);
	if (_tmp12_) {
		Number* _tmp13_;
		_tmp13_ = value;
		if (number_is_prime (self, _tmp13_)) {
			Number* _tmp14_;
			Number* _tmp15_;
			_tmp14_ = value;
			_tmp15_ = _g_object_ref0 (_tmp14_);
			factors = g_list_append (factors, _tmp15_);
			result = factors;
			_g_object_unref0 (value);
			return result;
		}
	}
	_tmp16_ = number_new_unsigned_integer ((guint64) 0xFFFFFFFFFFFFFFFFLL, (guint64) 0);
	int_max = _tmp16_;
	_tmp17_ = value;
	_tmp18_ = int_max;
	if (number_compare (_tmp17_, _tmp18_) <= 0) {
		GList* factors_int64 = NULL;
		Number* _tmp19_;
		GList* _tmp20_;
		_tmp19_ = value;
		_tmp20_ = number_factorize_uint64 (self, number_to_unsigned_integer (_tmp19_));
		factors_int64 = _tmp20_;
		if (number_is_negative (self)) {
			GList* _tmp21_;
			GList* _tmp22_;
			gconstpointer _tmp23_;
			Number* _tmp24_;
			_tmp21_ = factors_int64;
			_tmp22_ = factors_int64;
			_tmp23_ = _tmp22_->data;
			_tmp24_ = number_invert_sign ((Number*) _tmp23_);
			_g_object_unref0 (_tmp21_->data);
			_tmp21_->data = _tmp24_;
		}
		result = factors_int64;
		_g_object_unref0 (int_max);
		_g_object_unref0 (value);
		(factors == NULL) ? NULL : (factors = (_g_list_free__g_object_unref0_ (factors), NULL));
		return result;
	}
	_tmp25_ = number_new_integer ((gint64) 2, (gint64) 0);
	divisor = _tmp25_;
	while (TRUE) {
		Number* tmp = NULL;
		Number* _tmp26_;
		Number* _tmp27_;
		Number* _tmp28_;
		Number* _tmp29_;
		_tmp26_ = value;
		_tmp27_ = divisor;
		_tmp28_ = number_divide (_tmp26_, _tmp27_);
		tmp = _tmp28_;
		_tmp29_ = tmp;
		if (number_is_integer (_tmp29_)) {
			Number* _tmp30_;
			Number* _tmp31_;
			Number* _tmp32_;
			Number* _tmp33_;
			_tmp30_ = tmp;
			_tmp31_ = _g_object_ref0 (_tmp30_);
			_g_object_unref0 (value);
			value = _tmp31_;
			_tmp32_ = divisor;
			_tmp33_ = _g_object_ref0 (_tmp32_);
			factors = g_list_append (factors, _tmp33_);
		} else {
			_g_object_unref0 (tmp);
			break;
		}
		_g_object_unref0 (tmp);
	}
	_tmp34_ = number_new_integer ((gint64) 3, (gint64) 0);
	_g_object_unref0 (divisor);
	divisor = _tmp34_;
	_tmp35_ = value;
	_tmp36_ = number_sqrt (_tmp35_);
	root = _tmp36_;
	while (TRUE) {
		Number* _tmp37_;
		Number* _tmp38_;
		Number* tmp = NULL;
		Number* _tmp39_;
		Number* _tmp40_;
		Number* _tmp41_;
		Number* _tmp42_;
		_tmp37_ = divisor;
		_tmp38_ = root;
		if (!(number_compare (_tmp37_, _tmp38_) <= 0)) {
			break;
		}
		_tmp39_ = value;
		_tmp40_ = divisor;
		_tmp41_ = number_divide (_tmp39_, _tmp40_);
		tmp = _tmp41_;
		_tmp42_ = tmp;
		if (number_is_integer (_tmp42_)) {
			Number* _tmp43_;
			Number* _tmp44_;
			Number* _tmp45_;
			Number* _tmp46_;
			Number* _tmp47_;
			Number* _tmp48_;
			_tmp43_ = tmp;
			_tmp44_ = _g_object_ref0 (_tmp43_);
			_g_object_unref0 (value);
			value = _tmp44_;
			_tmp45_ = value;
			_tmp46_ = number_sqrt (_tmp45_);
			_g_object_unref0 (root);
			root = _tmp46_;
			_tmp47_ = divisor;
			_tmp48_ = _g_object_ref0 (_tmp47_);
			factors = g_list_append (factors, _tmp48_);
		} else {
			Number* _tmp49_;
			Number* _tmp50_;
			Number* _tmp51_;
			Number* _tmp52_;
			Number* _tmp53_;
			Number* _tmp54_;
			_tmp49_ = divisor;
			_tmp50_ = number_new_integer ((gint64) 2, (gint64) 0);
			_tmp51_ = _tmp50_;
			_tmp52_ = number_add (_tmp49_, _tmp51_);
			_g_object_unref0 (tmp);
			tmp = _tmp52_;
			_g_object_unref0 (_tmp51_);
			_tmp53_ = tmp;
			_tmp54_ = _g_object_ref0 (_tmp53_);
			_g_object_unref0 (divisor);
			divisor = _tmp54_;
		}
		_g_object_unref0 (tmp);
	}
	_tmp55_ = value;
	_tmp56_ = number_new_integer ((gint64) 1, (gint64) 0);
	_tmp57_ = _tmp56_;
	_tmp58_ = number_compare (_tmp55_, _tmp57_) > 0;
	_g_object_unref0 (_tmp57_);
	if (_tmp58_) {
		Number* _tmp59_;
		Number* _tmp60_;
		_tmp59_ = value;
		_tmp60_ = _g_object_ref0 (_tmp59_);
		factors = g_list_append (factors, _tmp60_);
	}
	if (number_is_negative (self)) {
		GList* _tmp61_;
		GList* _tmp62_;
		gconstpointer _tmp63_;
		Number* _tmp64_;
		_tmp61_ = factors;
		_tmp62_ = factors;
		_tmp63_ = _tmp62_->data;
		_tmp64_ = number_invert_sign ((Number*) _tmp63_);
		_g_object_unref0 (_tmp61_->data);
		_tmp61_->data = _tmp64_;
	}
	result = factors;
	_g_object_unref0 (root);
	_g_object_unref0 (divisor);
	_g_object_unref0 (int_max);
	_g_object_unref0 (value);
	return result;
}

GList*
number_factorize_uint64 (Number* self,
                         guint64 n)
{
	GList* factors = NULL;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	factors = NULL;
	while (TRUE) {
		Number* _tmp0_;
		if (!((n % 2) == ((guint64) 0))) {
			break;
		}
		n = n / 2;
		_tmp0_ = number_new_unsigned_integer ((guint64) 2, (guint64) 0);
		factors = g_list_append (factors, _tmp0_);
	}
	{
		guint64 divisor = 0ULL;
		divisor = (guint64) 3;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					divisor += (guint64) 2;
				}
				_tmp1_ = FALSE;
				if (!(divisor <= (n / divisor))) {
					break;
				}
				while (TRUE) {
					Number* _tmp2_;
					if (!((n % divisor) == ((guint64) 0))) {
						break;
					}
					n = n / divisor;
					_tmp2_ = number_new_unsigned_integer (divisor, (guint64) 0);
					factors = g_list_append (factors, _tmp2_);
				}
			}
		}
	}
	if (n > ((guint64) 1)) {
		Number* _tmp3_;
		_tmp3_ = number_new_unsigned_integer (n, (guint64) 0);
		factors = g_list_append (factors, _tmp3_);
	}
	result = factors;
	return result;
}

static Number*
number_copy (Number* self)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_set (&z->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

static gboolean
_mpc_equal (const __mpc_struct * s1,
            const __mpc_struct * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return FALSE;
}

static void
number_mpc_from_radians (__mpc_struct* res,
                         __mpc_struct* op,
                         AngleUnit unit)
{
	gint i = 0;
	__mpfr_struct scale = {0};
	mpfr_prec_t _tmp1_;
	mpfr_prec_t _tmp2_;
	__mpc_struct _tmp3_;
	g_return_if_fail (res != NULL);
	g_return_if_fail (op != NULL);
	switch (unit) {
		default:
		case ANGLE_UNIT_RADIANS:
		{
			if (_mpc_equal (res, op) != TRUE) {
				__mpc_struct _tmp0_;
				_tmp0_ = *op;
				mpc_set (res, &_tmp0_, MPC_RNDNN);
			}
			return;
		}
		case ANGLE_UNIT_DEGREES:
		{
			i = 180;
			break;
		}
		case ANGLE_UNIT_GRADIANS:
		{
			i = 200;
			break;
		}
	}
	_tmp1_ = number_get_precision ();
	_tmp2_ = _tmp1_;
	mpfr_init2 (&scale, _tmp2_);
	mpfr_const_pi (&scale, MPFR_RNDN);
	mpfr_si_div (&scale, (glong) i, &scale, MPFR_RNDN);
	_tmp3_ = *op;
	mpc_mul_fr (res, &_tmp3_, &scale, MPC_RNDNN);
	mpfr_clear (&scale);
}

static void
number_mpc_to_radians (__mpc_struct* res,
                       __mpc_struct* op,
                       AngleUnit unit)
{
	gint i = 0;
	__mpfr_struct scale = {0};
	mpfr_prec_t _tmp1_;
	mpfr_prec_t _tmp2_;
	__mpc_struct _tmp3_;
	g_return_if_fail (res != NULL);
	g_return_if_fail (op != NULL);
	switch (unit) {
		default:
		case ANGLE_UNIT_RADIANS:
		{
			if (_mpc_equal (res, op) != TRUE) {
				__mpc_struct _tmp0_;
				_tmp0_ = *op;
				mpc_set (res, &_tmp0_, MPC_RNDNN);
			}
			return;
		}
		case ANGLE_UNIT_DEGREES:
		{
			i = 180;
			break;
		}
		case ANGLE_UNIT_GRADIANS:
		{
			i = 200;
			break;
		}
	}
	_tmp1_ = number_get_precision ();
	_tmp2_ = _tmp1_;
	mpfr_init2 (&scale, _tmp2_);
	mpfr_const_pi (&scale, MPFR_RNDN);
	mpfr_div_si (&scale, &scale, (glong) i, MPFR_RNDN);
	_tmp3_ = *op;
	mpc_mul_fr (res, &_tmp3_, &scale, MPC_RNDNN);
	mpfr_clear (&scale);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static Number*
number_bitwise (Number* self,
                Number* y,
                BitwiseFunc bitwise_operator,
                gpointer bitwise_operator_target,
                gint wordlen)
{
	gboolean _tmp0_ = FALSE;
	gchar* text1 = NULL;
	gchar* _tmp3_;
	gchar* text2 = NULL;
	gchar* _tmp4_;
	gint offset1 = 0;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint offset2 = 0;
	const gchar* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint offset_out = 0;
	gchar* text_out = NULL;
	gchar* _tmp12_;
	gint text_out_length1;
	gint _text_out_size_;
	gchar* _tmp22_;
	gint _tmp22__length1;
	Number* _tmp23_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	if (wordlen > 0) {
		gboolean _tmp1_ = FALSE;
		if (number_is_overflow (self, wordlen, FALSE)) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = number_is_overflow (y, wordlen, FALSE);
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Number* _tmp2_;
		number_set_error (_ ("Overflow. Try a bigger word size"));
		_tmp2_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = number_to_hex_string (self);
	text1 = _tmp3_;
	_tmp4_ = number_to_hex_string (y);
	text2 = _tmp4_;
	_tmp5_ = text1;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	offset1 = _tmp7_ - 1;
	_tmp8_ = text2;
	_tmp9_ = strlen (_tmp8_);
	_tmp10_ = _tmp9_;
	offset2 = _tmp10_ - 1;
	offset_out = (wordlen / 4) - 1;
	if (offset_out <= 0) {
		gint _tmp11_ = 0;
		if (offset1 > offset2) {
			_tmp11_ = offset1;
		} else {
			_tmp11_ = offset2;
		}
		offset_out = _tmp11_;
	}
	_tmp12_ = g_new0 (gchar, offset_out + 2);
	text_out = _tmp12_;
	text_out_length1 = offset_out + 2;
	_text_out_size_ = text_out_length1;
	{
		gchar* _tmp13_;
		gint _tmp13__length1;
		gboolean _tmp14_ = FALSE;
		_tmp13_ = text_out;
		_tmp13__length1 = text_out_length1;
		_tmp13_[offset_out + 1] = '\0';
		_tmp14_ = TRUE;
		while (TRUE) {
			gint v1 = 0;
			gint v2 = 0;
			static const gchar digits[16] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
			gchar* _tmp20_;
			gint _tmp20__length1;
			gchar _tmp21_;
			if (!_tmp14_) {
				gint _tmp15_;
				_tmp15_ = offset_out;
				offset_out = _tmp15_ - 1;
			}
			_tmp14_ = FALSE;
			if (!(offset_out >= 0)) {
				break;
			}
			v1 = 0;
			v2 = 0;
			if (offset1 >= 0) {
				const gchar* _tmp16_;
				gint _tmp17_;
				_tmp16_ = text1;
				v1 = number_hex_to_int (self, string_get (_tmp16_, (glong) offset1));
				_tmp17_ = offset1;
				offset1 = _tmp17_ - 1;
			}
			if (offset2 >= 0) {
				const gchar* _tmp18_;
				gint _tmp19_;
				_tmp18_ = text2;
				v2 = number_hex_to_int (self, string_get (_tmp18_, (glong) offset2));
				_tmp19_ = offset2;
				offset2 = _tmp19_ - 1;
			}
			_tmp20_ = text_out;
			_tmp20__length1 = text_out_length1;
			_tmp21_ = digits[bitwise_operator (v1, v2, bitwise_operator_target)];
			_tmp20_[offset_out] = _tmp21_;
		}
	}
	_tmp22_ = text_out;
	_tmp22__length1 = text_out_length1;
	_tmp23_ = mp_set_from_string ((const gchar*) _tmp22_, 16, FALSE);
	result = _tmp23_;
	text_out = (g_free (text_out), NULL);
	_g_free0 (text2);
	_g_free0 (text1);
	return result;
}

static gint
number_hex_to_int (Number* self,
                   gchar digit)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if (digit >= '0') {
		_tmp0_ = digit <= '9';
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = (gint) (digit - '0');
		return result;
	}
	if (digit >= 'A') {
		_tmp1_ = digit <= 'F';
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = (digit - 'A') + 10;
		return result;
	}
	if (digit >= 'a') {
		_tmp2_ = digit <= 'f';
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = (digit - 'a') + 10;
		return result;
	}
	result = 0;
	return result;
}

static gchar*
number_to_hex_string (Number* self)
{
	Serializer* serializer = NULL;
	Serializer* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = serializer_new (DISPLAY_FORMAT_FIXED, 16, 0);
	serializer = _tmp0_;
	serializer_set_check_fixed_max (serializer, FALSE);
	_tmp1_ = serializer_to_string (serializer, self);
	result = _tmp1_;
	_g_object_unref0 (serializer);
	return result;
}

Number*
number_construct (GType object_type)
{
	Number * self = NULL;
	self = (Number*) g_object_new (object_type, NULL);
	return self;
}

Number*
number_new (void)
{
	return number_construct (TYPE_NUMBER);
}

mpfr_prec_t
number_get_precision (void)
{
	mpfr_prec_t result;
	result = number__precision;
	return result;
}

void
number_set_precision (mpfr_prec_t value)
{
	number__precision = value;
}

const gchar*
number_get_error (void)
{
	const gchar* result;
	const gchar* _tmp0_;
	_tmp0_ = number__error;
	result = _tmp0_;
	return result;
}

void
number_set_error (const gchar* value)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup (value);
	_g_free0 (number__error);
	number__error = _tmp0_;
}

static void
number_class_init (NumberClass * klass,
                   gpointer klass_data)
{
	number_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Number_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_number_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_number_set_property;
	G_OBJECT_CLASS (klass)->finalize = number_finalize;
}

static void
number_instance_init (Number * self,
                      gpointer klass)
{
	mpfr_prec_t _tmp0_;
	mpfr_prec_t _tmp1_;
	self->priv = number_get_instance_private (self);
	_tmp0_ = number_get_precision ();
	_tmp1_ = _tmp0_;
	mpc_init2 (&self->priv->num, _tmp1_);
	self->priv->force_float = FALSE;
	self->priv->finite = TRUE;
}

static void
number_finalize (GObject * obj)
{
	Number * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NUMBER, Number);
	mpc_clear (&self->priv->num);
	G_OBJECT_CLASS (number_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
number_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NumberClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) number_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Number), 0, (GInstanceInitFunc) number_instance_init, NULL };
	GType number_type_id;
	number_type_id = g_type_register_static (G_TYPE_OBJECT, "Number", &g_define_type_info, 0);
	Number_private_offset = g_type_add_instance_private (number_type_id, sizeof (NumberPrivate));
	return number_type_id;
}

GType
number_get_type (void)
{
	static gsize number_type_id__once = 0;
	if (g_once_init_enter (&number_type_id__once)) {
		GType number_type_id;
		number_type_id = number_get_type_once ();
		g_once_init_leave (&number_type_id__once, number_type_id);
	}
	return number_type_id__once;
}

static void
_vala_number_get_property (GObject * object,
                           guint property_id,
                           GValue * value,
                           GParamSpec * pspec)
{
	Number * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NUMBER, Number);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_number_set_property (GObject * object,
                           guint property_id,
                           const GValue * value,
                           GParamSpec * pspec)
{
	Number * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NUMBER, Number);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

static gboolean
string_get_prev_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (0 < (*index)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_prev_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		_vala_c = (gunichar) 0;
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

Number*
mp_set_from_string (const gchar* str,
                    gint default_base,
                    gboolean may_have_prefix)
{
	static const gunichar base_digits[10] = {8320U, 8321U, 8322U, 8323U, 8324U, 8325U, 8326U, 8327U, 8328U, 8329U};
	gint index = 0;
	gint base_prefix = 0;
	gunichar c = 0U;
	gint end = 0;
	gint number_base = 0;
	gint literal_base = 0;
	gint base_multiplier = 0;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean negate = FALSE;
	gunichar _tmp16_ = 0U;
	Number* z = NULL;
	Number* _tmp19_;
	static const gunichar fractions[15] = {189U, 8531U, 8532U, 188U, 190U, 8533U, 8534U, 8535U, 8536U, 8537U, 8538U, 8539U, 8540U, 8541U, 8542U};
	static const gint numerators[15] = {1, 1, 2, 1, 3, 1, 2, 3, 4, 1, 5, 1, 3, 5, 7};
	static const gint denominators[15] = {2, 3, 3, 4, 4, 5, 5, 5, 5, 6, 6, 8, 8, 8, 8};
	gboolean has_fraction = FALSE;
	gunichar _tmp29_ = 0U;
	gboolean _tmp30_;
	Number* _tmp64_;
	Number* result;
	g_return_val_if_fail (str != NULL, NULL);
	if (string_index_of_char (str, 176U, 0) >= 0) {
		Number* _tmp0_;
		_tmp0_ = set_from_sexagesimal (str);
		result = _tmp0_;
		return result;
	}
	index = 0;
	base_prefix = 0;
	while (TRUE) {
		gunichar _tmp1_ = 0U;
		gboolean _tmp2_;
		_tmp2_ = string_get_next_char (str, &index, &_tmp1_);
		c = _tmp1_;
		if (!_tmp2_) {
			break;
		}
	}
	end = index;
	number_base = 0;
	literal_base = 0;
	base_multiplier = 1;
	while (TRUE) {
		gunichar _tmp3_ = 0U;
		gboolean _tmp4_;
		gint value = 0;
		_tmp4_ = string_get_prev_char (str, &index, &_tmp3_);
		c = _tmp3_;
		if (!_tmp4_) {
			break;
		}
		value = -1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					gunichar _tmp7_;
					if (!_tmp5_) {
						gint _tmp6_;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp5_ = FALSE;
					if (!(i < G_N_ELEMENTS (base_digits))) {
						break;
					}
					_tmp7_ = base_digits[i];
					if (c == _tmp7_) {
						value = i;
						break;
					}
				}
			}
		}
		if (value < 0) {
			break;
		}
		end = index;
		number_base += value * base_multiplier;
		base_multiplier *= 10;
	}
	if (number_base != 0) {
		gboolean _tmp10_ = FALSE;
		if (number_base < 2) {
			_tmp10_ = TRUE;
		} else {
			_tmp10_ = number_base > 16;
		}
		_tmp9_ = _tmp10_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		_tmp8_ = TRUE;
	} else {
		gboolean _tmp11_ = FALSE;
		if (number_base == 0) {
			_tmp11_ = g_str_has_suffix (str, "₀");
		} else {
			_tmp11_ = FALSE;
		}
		_tmp8_ = _tmp11_;
	}
	if (_tmp8_) {
		result = NULL;
		return result;
	}
	if (may_have_prefix) {
		gint _tmp12_;
		_tmp12_ = parse_literal_prefix (str, &base_prefix);
		literal_base = _tmp12_;
	}
	if (number_base != 0) {
		_tmp14_ = literal_base != 0;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		_tmp13_ = literal_base != number_base;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		result = NULL;
		return result;
	}
	if (number_base == 0) {
		gint _tmp15_ = 0;
		if (literal_base != 0) {
			_tmp15_ = literal_base;
		} else {
			_tmp15_ = default_base;
		}
		number_base = _tmp15_;
	}
	negate = FALSE;
	index = base_prefix;
	string_get_next_char (str, &index, &_tmp16_);
	c = _tmp16_;
	if (c == ((gunichar) '+')) {
		negate = FALSE;
	} else {
		gboolean _tmp17_ = FALSE;
		if (c == ((gunichar) '-')) {
			_tmp17_ = TRUE;
		} else {
			_tmp17_ = c == 8722U;
		}
		if (_tmp17_) {
			negate = TRUE;
		} else {
			gunichar _tmp18_ = 0U;
			string_get_prev_char (str, &index, &_tmp18_);
			c = _tmp18_;
		}
	}
	_tmp19_ = number_new_integer ((gint64) 0, (gint64) 0);
	z = _tmp19_;
	while (TRUE) {
		gunichar _tmp20_ = 0U;
		gboolean _tmp21_;
		gint i = 0;
		Number* _tmp23_;
		Number* _tmp24_;
		Number* _tmp25_;
		Number* _tmp26_;
		Number* _tmp27_;
		Number* _tmp28_;
		_tmp21_ = string_get_next_char (str, &index, &_tmp20_);
		c = _tmp20_;
		if (!_tmp21_) {
			break;
		}
		i = char_val (c, number_base);
		if (i > number_base) {
			result = NULL;
			_g_object_unref0 (z);
			return result;
		}
		if (i < 0) {
			gunichar _tmp22_ = 0U;
			string_get_prev_char (str, &index, &_tmp22_);
			c = _tmp22_;
			break;
		}
		_tmp23_ = z;
		_tmp24_ = number_multiply_integer (_tmp23_, (gint64) number_base);
		_tmp25_ = _tmp24_;
		_tmp26_ = number_new_integer ((gint64) i, (gint64) 0);
		_tmp27_ = _tmp26_;
		_tmp28_ = number_add (_tmp25_, _tmp27_);
		_g_object_unref0 (z);
		z = _tmp28_;
		_g_object_unref0 (_tmp27_);
		_g_object_unref0 (_tmp25_);
	}
	has_fraction = FALSE;
	_tmp30_ = string_get_next_char (str, &index, &_tmp29_);
	c = _tmp29_;
	if (_tmp30_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp31_ = FALSE;
				_tmp31_ = TRUE;
				while (TRUE) {
					gunichar _tmp33_;
					if (!_tmp31_) {
						gint _tmp32_;
						_tmp32_ = i;
						i = _tmp32_ + 1;
					}
					_tmp31_ = FALSE;
					if (!(i < G_N_ELEMENTS (fractions))) {
						break;
					}
					_tmp33_ = fractions[i];
					if (c == _tmp33_) {
						Number* fraction = NULL;
						gint _tmp34_;
						gint _tmp35_;
						Number* _tmp36_;
						Number* _tmp37_;
						Number* _tmp38_;
						Number* _tmp39_;
						gunichar _tmp40_ = 0U;
						gboolean _tmp41_;
						_tmp34_ = numerators[i];
						_tmp35_ = denominators[i];
						_tmp36_ = number_new_fraction ((gint64) _tmp34_, (gint64) _tmp35_);
						fraction = _tmp36_;
						_tmp37_ = z;
						_tmp38_ = fraction;
						_tmp39_ = number_add (_tmp37_, _tmp38_);
						_g_object_unref0 (z);
						z = _tmp39_;
						_tmp41_ = string_get_next_char (str, &index, &_tmp40_);
						c = _tmp40_;
						if (!_tmp41_) {
							result = z;
							_g_object_unref0 (fraction);
							return result;
						} else {
							result = NULL;
							_g_object_unref0 (fraction);
							_g_object_unref0 (z);
							return result;
						}
						_g_object_unref0 (fraction);
					}
				}
			}
		}
		if (c == ((gunichar) '.')) {
			has_fraction = TRUE;
		} else {
			gunichar _tmp42_ = 0U;
			string_get_prev_char (str, &index, &_tmp42_);
			c = _tmp42_;
		}
	}
	if (has_fraction) {
		Number* numerator = NULL;
		Number* _tmp43_;
		Number* denominator = NULL;
		Number* _tmp44_;
		Number* _tmp56_;
		Number* _tmp57_;
		Number* _tmp58_;
		Number* _tmp59_;
		Number* _tmp60_;
		Number* _tmp61_;
		_tmp43_ = number_new_integer ((gint64) 0, (gint64) 0);
		numerator = _tmp43_;
		_tmp44_ = number_new_integer ((gint64) 1, (gint64) 0);
		denominator = _tmp44_;
		while (TRUE) {
			gunichar _tmp45_ = 0U;
			gboolean _tmp46_;
			gint i = 0;
			Number* _tmp48_;
			Number* _tmp49_;
			Number* _tmp50_;
			Number* _tmp51_;
			Number* _tmp52_;
			Number* _tmp53_;
			Number* _tmp54_;
			Number* _tmp55_;
			_tmp46_ = string_get_next_char (str, &index, &_tmp45_);
			c = _tmp45_;
			if (!_tmp46_) {
				break;
			}
			i = char_val (c, number_base);
			if (i < 0) {
				gunichar _tmp47_ = 0U;
				string_get_prev_char (str, &index, &_tmp47_);
				c = _tmp47_;
				break;
			}
			_tmp48_ = denominator;
			_tmp49_ = number_multiply_integer (_tmp48_, (gint64) number_base);
			_g_object_unref0 (denominator);
			denominator = _tmp49_;
			_tmp50_ = numerator;
			_tmp51_ = number_multiply_integer (_tmp50_, (gint64) number_base);
			_g_object_unref0 (numerator);
			numerator = _tmp51_;
			_tmp52_ = numerator;
			_tmp53_ = number_new_integer ((gint64) i, (gint64) 0);
			_tmp54_ = _tmp53_;
			_tmp55_ = number_add (_tmp52_, _tmp54_);
			_g_object_unref0 (numerator);
			numerator = _tmp55_;
			_g_object_unref0 (_tmp54_);
		}
		_tmp56_ = numerator;
		_tmp57_ = denominator;
		_tmp58_ = number_divide (_tmp56_, _tmp57_);
		_g_object_unref0 (numerator);
		numerator = _tmp58_;
		_tmp59_ = z;
		_tmp60_ = numerator;
		_tmp61_ = number_add (_tmp59_, _tmp60_);
		_g_object_unref0 (z);
		z = _tmp61_;
		_g_object_unref0 (denominator);
		_g_object_unref0 (numerator);
	}
	if (index != end) {
		result = NULL;
		_g_object_unref0 (z);
		return result;
	}
	if (negate) {
		Number* _tmp62_;
		Number* _tmp63_;
		_tmp62_ = z;
		_tmp63_ = number_invert_sign (_tmp62_);
		_g_object_unref0 (z);
		z = _tmp63_;
	}
	_tmp64_ = z;
	number_set_force_float (_tmp64_, has_fraction);
	result = z;
	return result;
}

gint
parse_literal_prefix (const gchar* str,
                      gint* prefix_len)
{
	gint new_base = 0;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	gchar prefix = '\0';
	gint result;
	g_return_val_if_fail (str != NULL, 0);
	new_base = 0;
	_tmp1_ = strlen (str);
	_tmp2_ = _tmp1_;
	if (_tmp2_ < 3) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = string_get (str, (glong) 0) != '0';
	}
	if (_tmp0_) {
		result = new_base;
		return result;
	}
	prefix = g_ascii_tolower (string_get (str, (glong) 1));
	if (prefix == 'b') {
		new_base = 2;
	} else {
		if (prefix == 'o') {
			new_base = 8;
		} else {
			if (prefix == 'x') {
				new_base = 16;
			}
		}
	}
	if (new_base != 0) {
		*prefix_len = 2;
	}
	result = new_base;
	return result;
}

gint
char_val (gunichar c,
          gint number_base)
{
	gint value = 0;
	gint result;
	if (!g_unichar_isxdigit (c)) {
		result = -1;
		return result;
	}
	value = g_unichar_xdigit_value (c);
	if (value >= number_base) {
		result = -1;
		return result;
	}
	result = value;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

Number*
set_from_sexagesimal (const gchar* s)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gint degree_index = 0;
	const gchar* _tmp10_;
	Number* degrees = NULL;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	Number* _tmp14_;
	Number* _tmp15_;
	Number* _tmp16_;
	gint minute_start = 0;
	gunichar c = 0U;
	const gchar* _tmp17_;
	gunichar _tmp18_ = 0U;
	const gchar* _tmp19_;
	gint minute_index = 0;
	const gchar* _tmp20_;
	Number* minutes = NULL;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	Number* _tmp27_;
	Number* _tmp28_;
	Number* _tmp29_;
	Number* _tmp30_;
	Number* _tmp31_;
	Number* _tmp32_;
	Number* _tmp33_;
	Number* _tmp34_;
	gint second_start = 0;
	const gchar* _tmp35_;
	gunichar _tmp36_ = 0U;
	const gchar* _tmp37_;
	gint second_index = 0;
	const gchar* _tmp38_;
	Number* seconds = NULL;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	Number* _tmp45_;
	Number* _tmp46_;
	Number* _tmp47_;
	Number* _tmp48_;
	Number* _tmp49_;
	Number* _tmp50_;
	Number* _tmp51_;
	Number* _tmp52_;
	const gchar* _tmp53_;
	gunichar _tmp54_ = 0U;
	const gchar* _tmp55_;
	Number* result;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = string_replace (s, "′", "'");
	_tmp1_ = _tmp0_;
	_tmp2_ = string_replace (_tmp1_, "’", "'");
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	str = _tmp3_;
	_tmp4_ = str;
	_tmp5_ = string_replace (_tmp4_, "''", "\"");
	_tmp6_ = _tmp5_;
	_tmp7_ = string_replace (_tmp6_, "″", "\"");
	_tmp8_ = _tmp7_;
	_tmp9_ = string_replace (_tmp8_, "”", "\"");
	_g_free0 (str);
	str = _tmp9_;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_tmp10_ = str;
	degree_index = string_index_of_char (_tmp10_, 176U, 0);
	if (degree_index < 0) {
		result = NULL;
		_g_free0 (str);
		return result;
	}
	_tmp11_ = str;
	_tmp12_ = string_substring (_tmp11_, (glong) 0, (glong) degree_index);
	_tmp13_ = _tmp12_;
	_tmp14_ = mp_set_from_string (_tmp13_, 10, TRUE);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	degrees = _tmp15_;
	_tmp16_ = degrees;
	if (_tmp16_ == NULL) {
		result = NULL;
		_g_object_unref0 (degrees);
		_g_free0 (str);
		return result;
	}
	minute_start = degree_index;
	_tmp17_ = str;
	string_get_next_char (_tmp17_, &minute_start, &_tmp18_);
	c = _tmp18_;
	_tmp19_ = str;
	if (string_get (_tmp19_, (glong) minute_start) == '\0') {
		result = degrees;
		_g_free0 (str);
		return result;
	}
	_tmp20_ = str;
	minute_index = string_index_of_char (_tmp20_, (gunichar) '\'', minute_start);
	if (minute_index < 0) {
		const gchar* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		_tmp21_ = str;
		_tmp22_ = strlen (_tmp21_);
		_tmp23_ = _tmp22_;
		minute_index = _tmp23_;
	}
	_tmp24_ = str;
	_tmp25_ = string_substring (_tmp24_, (glong) minute_start, (glong) (minute_index - minute_start));
	_tmp26_ = _tmp25_;
	_tmp27_ = mp_set_from_string (_tmp26_, 10, TRUE);
	_tmp28_ = _tmp27_;
	_g_free0 (_tmp26_);
	minutes = _tmp28_;
	_tmp29_ = minutes;
	if (_tmp29_ == NULL) {
		result = NULL;
		_g_object_unref0 (minutes);
		_g_object_unref0 (degrees);
		_g_free0 (str);
		return result;
	}
	_tmp30_ = degrees;
	_tmp31_ = minutes;
	_tmp32_ = number_divide_integer (_tmp31_, (gint64) 60);
	_tmp33_ = _tmp32_;
	_tmp34_ = number_add (_tmp30_, _tmp33_);
	_g_object_unref0 (degrees);
	degrees = _tmp34_;
	_g_object_unref0 (_tmp33_);
	second_start = minute_index;
	_tmp35_ = str;
	string_get_next_char (_tmp35_, &second_start, &_tmp36_);
	c = _tmp36_;
	_tmp37_ = str;
	if (string_get (_tmp37_, (glong) second_start) == '\0') {
		result = degrees;
		_g_object_unref0 (minutes);
		_g_free0 (str);
		return result;
	}
	_tmp38_ = str;
	second_index = string_index_of_char (_tmp38_, (gunichar) '"', second_start);
	if (second_index < 0) {
		const gchar* _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		_tmp39_ = str;
		_tmp40_ = strlen (_tmp39_);
		_tmp41_ = _tmp40_;
		second_index = _tmp41_;
	}
	_tmp42_ = str;
	_tmp43_ = string_substring (_tmp42_, (glong) second_start, (glong) (second_index - second_start));
	_tmp44_ = _tmp43_;
	_tmp45_ = mp_set_from_string (_tmp44_, 10, TRUE);
	_tmp46_ = _tmp45_;
	_g_free0 (_tmp44_);
	seconds = _tmp46_;
	_tmp47_ = seconds;
	if (_tmp47_ == NULL) {
		result = NULL;
		_g_object_unref0 (seconds);
		_g_object_unref0 (minutes);
		_g_object_unref0 (degrees);
		_g_free0 (str);
		return result;
	}
	_tmp48_ = degrees;
	_tmp49_ = seconds;
	_tmp50_ = number_divide_integer (_tmp49_, (gint64) 3600);
	_tmp51_ = _tmp50_;
	_tmp52_ = number_add (_tmp48_, _tmp51_);
	_g_object_unref0 (degrees);
	degrees = _tmp52_;
	_g_object_unref0 (_tmp51_);
	_tmp53_ = str;
	string_get_next_char (_tmp53_, &second_index, &_tmp54_);
	c = _tmp54_;
	_tmp55_ = str;
	if (string_get (_tmp55_, (glong) second_index) == '\0') {
		result = degrees;
		_g_object_unref0 (seconds);
		_g_object_unref0 (minutes);
		_g_free0 (str);
		return result;
	} else {
		result = NULL;
		_g_object_unref0 (seconds);
		_g_object_unref0 (minutes);
		_g_object_unref0 (degrees);
		_g_free0 (str);
		return result;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

