/* IconTasklistApplet.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from IconTasklistApplet.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <gtk/gtk.h>
#include <glib.h>
#include "icontasklistapplet.h"
#include <stdlib.h>
#include <string.h>
#include "plugin.h"
#include <glib-object.h>
#include <gio/gio.h>
#include "budgie-windowing.h"
#include <gio/gdesktopappinfo.h>
#include "budgie-private.h"
#include <gdk/gdk.h>
#include <libxfce4windowing/libxfce4windowing.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <cairo-gobject.h>
#include <libpeas.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	ICON_TASKLIST_0_PROPERTY,
	ICON_TASKLIST_NUM_PROPERTIES
};
static GParamSpec* icon_tasklist_properties[ICON_TASKLIST_NUM_PROPERTIES];
enum  {
	ICON_TASKLIST_SETTINGS_0_PROPERTY,
	ICON_TASKLIST_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* icon_tasklist_settings_properties[ICON_TASKLIST_SETTINGS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	ICON_TASKLIST_APPLET_0_PROPERTY,
	ICON_TASKLIST_APPLET_UUID_PROPERTY,
	ICON_TASKLIST_APPLET_NUM_PROPERTIES
};
static GParamSpec* icon_tasklist_applet_properties[ICON_TASKLIST_APPLET_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _IconTasklistSettingsPrivate {
	GtkSwitch* switch_restrict;
	GtkSwitch* switch_lock_icons;
	GtkSwitch* switch_only_pinned;
	GtkSwitch* show_all_on_click;
	GtkSwitch* switch_middle_click_create_new_instance;
	GtkSwitch* switch_require_double_click_to_launch_new_instance;
	GSettings* settings;
};

struct _IconTasklistAppletPrivate {
	BudgieWindowingWindowing* windowing;
	GSettings* settings;
	GtkBox* main_layout;
	gboolean lock_icons;
	gboolean restrict_to_workspace;
	gboolean only_show_pinned;
	gint icon_size;
	gint panel_size;
	BudgiePanelPosition panel_position;
	GHashTable* buttons;
	GRecMutex __lock_buttons;
	BudgiePopoverManager* manager;
	gchar* _uuid;
};

static gpointer icon_tasklist_parent_class = NULL;
static BudgiePluginIface * icon_tasklist_budgie_plugin_parent_iface = NULL;
static GType icon_tasklist_type_id = 0;
static gint IconTasklistSettings_private_offset;
static gpointer icon_tasklist_settings_parent_class = NULL;
static GType icon_tasklist_settings_type_id = 0;
static gint IconTasklistApplet_private_offset;
static gpointer icon_tasklist_applet_parent_class = NULL;
static GType icon_tasklist_applet_type_id = 0;

static BudgieApplet* icon_tasklist_real_get_panel_widget (BudgiePlugin* base,
                                                   const gchar* uuid);
static void icon_tasklist_settings_finalize (GObject * obj);
static GtkWidget* icon_tasklist_applet_real_get_settings_ui (BudgieApplet* base);
static gboolean icon_tasklist_applet_real_supports_settings (BudgieApplet* base);
static void icon_tasklist_applet_on_settings_changed (IconTasklistApplet* self,
                                               const gchar* key);
static void _icon_tasklist_applet_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                                   const gchar* key,
                                                                   gpointer self);
static gboolean __lambda29_ (IconTasklistApplet* self);
static void icon_tasklist_applet_rebuild_items (IconTasklistApplet* self);
static gboolean ___lambda29__gsource_func (gpointer self);
static void icon_tasklist_applet_connect_app_signals (IconTasklistApplet* self);
static void icon_tasklist_applet_startup (IconTasklistApplet* self);
static gboolean icon_tasklist_applet_on_button_press (IconTasklistApplet* self,
                                               GtkWidget* widget,
                                               GdkEventButton* event);
static gboolean _icon_tasklist_applet_on_button_press_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                              GdkEventButton* event,
                                                                              gpointer self);
static gboolean icon_tasklist_applet_on_button_release (IconTasklistApplet* self,
                                                 GtkWidget* widget,
                                                 GdkEventButton* event);
static gboolean _icon_tasklist_applet_on_button_release_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                                  GdkEventButton* event,
                                                                                  gpointer self);
static void icon_tasklist_applet_on_pinned_changed (IconTasklistApplet* self,
                                             GObject* object,
                                             GParamSpec* pspec);
static void _icon_tasklist_applet_on_pinned_changed_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self);
static void icon_tasklist_applet_add_icon_button (IconTasklistApplet* self,
                                           const gchar* app_id,
                                           IconButton* button);
static void icon_tasklist_applet_on_active_window_changed (IconTasklistApplet* self,
                                                    XfwWindow* old_active_window,
                                                    XfwWindow* new_active_window);
static void _icon_tasklist_applet_on_active_window_changed_budgie_windowing_windowing_active_window_changed (BudgieWindowingWindowing* _sender,
                                                                                                      XfwWindow* old_active_window,
                                                                                                      XfwWindow* new_active_window,
                                                                                                      gpointer self);
static void icon_tasklist_applet_update_buttons (IconTasklistApplet* self);
static void _icon_tasklist_applet_update_buttons_budgie_windowing_windowing_active_workspace_changed (BudgieWindowingWindowing* _sender,
                                                                                               XfwWorkspace* old_active_workspace,
                                                                                               gpointer self);
static void icon_tasklist_applet_on_app_opened (IconTasklistApplet* self,
                                         BudgieWindowingWindowGroup* group);
static void _icon_tasklist_applet_on_app_opened_budgie_windowing_windowing_window_group_added (BudgieWindowingWindowing* _sender,
                                                                                        BudgieWindowingWindowGroup* group,
                                                                                        gpointer self);
static void icon_tasklist_applet_on_app_closed (IconTasklistApplet* self,
                                         BudgieWindowingWindowGroup* group);
static void _icon_tasklist_applet_on_app_closed_budgie_windowing_windowing_window_group_removed (BudgieWindowingWindowing* _sender,
                                                                                          BudgieWindowingWindowGroup* group,
                                                                                          gpointer self);
static void _icon_tasklist_applet_on_app_opened_gfunc (gconstpointer data,
                                                gpointer self);
static void __lambda27_ (IconTasklistApplet* self,
                  const gchar* id,
                  IconButton* button);
static void icon_tasklist_applet_update_button (IconTasklistApplet* self,
                                         IconButton* button);
static void ___lambda27__gh_func (gconstpointer key,
                           gconstpointer value,
                           gpointer self);
static void icon_tasklist_applet_button_drag_data_get (IconTasklistApplet* self,
                                                GtkWidget* widget,
                                                GdkDragContext* context,
                                                GtkSelectionData* data,
                                                guint info,
                                                guint time);
static void icon_tasklist_applet_button_drag_begin (IconTasklistApplet* self,
                                             GtkWidget* widget,
                                             GdkDragContext* context);
static void icon_tasklist_applet_button_drag_data_received (IconTasklistApplet* self,
                                                     GtkWidget* widget,
                                                     GdkDragContext* context,
                                                     gint x,
                                                     gint y,
                                                     GtkSelectionData* data,
                                                     guint info,
                                                     guint time);
static void icon_tasklist_applet_button_drag_data_received_handle_desktop_info (IconTasklistApplet* self,
                                                                         GtkWidget* widget,
                                                                         GdkDragContext* context,
                                                                         GtkSelectionData* data,
                                                                         GtkWidget* source);
static void icon_tasklist_applet_button_drag_data_received_handle_uri (IconTasklistApplet* self,
                                                                GdkDragContext* context,
                                                                GtkSelectionData* data,
                                                                guint time);
static gint __lambda30_ (GtkWidget* a,
                  GtkWidget* b);
static gint ___lambda30__gcompare_func (gconstpointer a,
                                 gconstpointer b);
static void icon_tasklist_applet_update_pinned_launchers (IconTasklistApplet* self);
static void icon_tasklist_applet_button_drag_leave (IconTasklistApplet* self,
                                             GtkWidget* widget,
                                             GdkDragContext* context,
                                             guint time);
static gboolean icon_tasklist_applet_button_drag_motion (IconTasklistApplet* self,
                                                  GtkWidget* widget,
                                                  GdkDragContext* context,
                                                  gint x,
                                                  gint y,
                                                  guint time);
static gboolean icon_tasklist_applet_button_drag_drop (IconTasklistApplet* self,
                                                GtkWidget* widget,
                                                GdkDragContext* context,
                                                gint x,
                                                gint y,
                                                guint time);
static void icon_tasklist_applet_add_button (IconTasklistApplet* self,
                                      const gchar* key,
                                      IconButton* button);
static void icon_tasklist_applet_remove_button (IconTasklistApplet* self,
                                         const gchar* key);
static void icon_tasklist_applet_real_panel_position_changed (BudgieApplet* base,
                                                       BudgiePanelPosition position);
static GtkOrientation icon_tasklist_applet_get_orientation (IconTasklistApplet* self);
static void icon_tasklist_applet_resize (IconTasklistApplet* self);
static void icon_tasklist_applet_real_panel_size_changed (BudgieApplet* base,
                                                   gint panel,
                                                   gint icon,
                                                   gint small_icon);
static void __lambda31_ (IconTasklistApplet* self,
                  const gchar* id,
                  IconButton* button);
static void ___lambda31__gh_func (gconstpointer key,
                           gconstpointer value,
                           gpointer self);
static void icon_tasklist_applet_real_update_popovers (BudgieApplet* base,
                                                BudgiePopoverManager* manager);
static void _icon_tasklist_applet_button_drag_data_get_gtk_widget_drag_data_get (GtkWidget* _sender,
                                                                          GdkDragContext* context,
                                                                          GtkSelectionData* selection_data,
                                                                          guint info,
                                                                          guint time_,
                                                                          gpointer self);
static void _icon_tasklist_applet_button_drag_begin_gtk_widget_drag_begin (GtkWidget* _sender,
                                                                    GdkDragContext* context,
                                                                    gpointer self);
static void _icon_tasklist_applet_button_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                                    GdkDragContext* context,
                                                                                    gint x,
                                                                                    gint y,
                                                                                    GtkSelectionData* selection_data,
                                                                                    guint info,
                                                                                    guint time_,
                                                                                    gpointer self);
static gboolean _icon_tasklist_applet_button_drag_motion_gtk_widget_drag_motion (GtkWidget* _sender,
                                                                          GdkDragContext* context,
                                                                          gint x,
                                                                          gint y,
                                                                          guint time_,
                                                                          gpointer self);
static gboolean _icon_tasklist_applet_button_drag_drop_gtk_widget_drag_drop (GtkWidget* _sender,
                                                                      GdkDragContext* context,
                                                                      gint x,
                                                                      gint y,
                                                                      guint time_,
                                                                      gpointer self);
static void _icon_tasklist_applet_button_drag_leave_gtk_widget_drag_leave (GtkWidget* _sender,
                                                                    GdkDragContext* context,
                                                                    guint time_,
                                                                    gpointer self);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void icon_tasklist_applet_swap_button (IconTasklistApplet* self,
                                       const gchar* old_key,
                                       const gchar* new_key);
static GObject * icon_tasklist_applet_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void icon_tasklist_applet_finalize (GObject * obj);
static void _vala_icon_tasklist_applet_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_icon_tasklist_applet_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
GType icon_tasklist_button_popover_register_type (GTypeModule * module);
GType window_controls_register_type (GTypeModule * module);
GType window_item_register_type (GTypeModule * module);
GType button_wrapper_register_type (GTypeModule * module);
GType icon_register_type (GTypeModule * module);
GType icon_button_register_type (GTypeModule * module);
GType settings_remote_register_type (GTypeModule * module);
VALA_EXTERN void settings_remote_proxy_register_dynamic_type (GTypeModule* module);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

const GtkTargetEntry DRAG_TARGETS[2] = {{"application/x-desktop", (guint) 0, (guint) 0}, {"text/uri-list", (guint) 0, (guint) 1}};
const GtkTargetEntry SOURCE_TARGET[1] = {{"application/x-desktop", (guint) 0, (guint) 0}};

static BudgieApplet*
icon_tasklist_real_get_panel_widget (BudgiePlugin* base,
                                     const gchar* uuid)
{
	IconTasklist * self;
	IconTasklistApplet* _tmp0_;
	BudgieApplet* result;
	self = (IconTasklist*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = icon_tasklist_applet_new (uuid);
	g_object_ref_sink (_tmp0_);
	result = (BudgieApplet*) _tmp0_;
	return result;
}

IconTasklist*
icon_tasklist_construct (GType object_type)
{
	IconTasklist * self = NULL;
	self = (IconTasklist*) g_object_new (object_type, NULL);
	return self;
}

IconTasklist*
icon_tasklist_new (void)
{
	return icon_tasklist_construct (TYPE_ICON_TASKLIST);
}

static void
icon_tasklist_class_init (IconTasklistClass * klass,
                          gpointer klass_data)
{
	icon_tasklist_parent_class = g_type_class_peek_parent (klass);
}

static void
icon_tasklist_budgie_plugin_interface_init (BudgiePluginIface * iface,
                                            gpointer iface_data)
{
	icon_tasklist_budgie_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_panel_widget = (BudgieApplet* (*) (BudgiePlugin*, const gchar*)) icon_tasklist_real_get_panel_widget;
}

static void
icon_tasklist_instance_init (IconTasklist * self,
                             gpointer klass)
{
}

GType
icon_tasklist_get_type (void)
{
	return icon_tasklist_type_id;
}

GType
icon_tasklist_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (IconTasklistClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) icon_tasklist_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IconTasklist), 0, (GInstanceInitFunc) icon_tasklist_instance_init, NULL };
	static const GInterfaceInfo budgie_plugin_info = { (GInterfaceInitFunc) icon_tasklist_budgie_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	icon_tasklist_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "IconTasklist", &g_define_type_info, 0);
	g_type_module_add_interface (module, icon_tasklist_type_id, budgie_plugin_get_type (), &budgie_plugin_info);
	return icon_tasklist_type_id;
}

static inline gpointer
icon_tasklist_settings_get_instance_private (IconTasklistSettings* self)
{
	return G_STRUCT_MEMBER_P (self, IconTasklistSettings_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

IconTasklistSettings*
icon_tasklist_settings_construct (GType object_type,
                                  GSettings* settings)
{
	IconTasklistSettings * self = NULL;
	GSettings* _tmp0_;
	GtkSwitch* _tmp1_;
	GtkSwitch* _tmp2_;
	GtkSwitch* _tmp3_;
	GtkSwitch* _tmp4_;
	GtkSwitch* _tmp5_;
	GtkSwitch* _tmp6_;
	self = (IconTasklistSettings*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->switch_restrict;
	g_settings_bind (settings, "restrict-to-workspace", (GObject*) _tmp1_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp2_ = self->priv->switch_lock_icons;
	g_settings_bind (settings, "lock-icons", (GObject*) _tmp2_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp3_ = self->priv->switch_only_pinned;
	g_settings_bind (settings, "only-pinned", (GObject*) _tmp3_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp4_ = self->priv->show_all_on_click;
	g_settings_bind (settings, "show-all-windows-on-click", (GObject*) _tmp4_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp5_ = self->priv->switch_middle_click_create_new_instance;
	g_settings_bind (settings, "middle-click-launch-new-instance", (GObject*) _tmp5_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp6_ = self->priv->switch_require_double_click_to_launch_new_instance;
	g_settings_bind (settings, "require-double-click-to-launch", (GObject*) _tmp6_, "active", G_SETTINGS_BIND_DEFAULT);
	return self;
}

IconTasklistSettings*
icon_tasklist_settings_new (GSettings* settings)
{
	return icon_tasklist_settings_construct (TYPE_ICON_TASKLIST_SETTINGS, settings);
}

static void
icon_tasklist_settings_class_init (IconTasklistSettingsClass * klass,
                                   gpointer klass_data)
{
	icon_tasklist_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &IconTasklistSettings_private_offset);
	G_OBJECT_CLASS (klass)->finalize = icon_tasklist_settings_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/solus-project/icon-tasklist/settings.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_restrict", FALSE, IconTasklistSettings_private_offset + G_STRUCT_OFFSET (IconTasklistSettingsPrivate, switch_restrict));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_lock_icons", FALSE, IconTasklistSettings_private_offset + G_STRUCT_OFFSET (IconTasklistSettingsPrivate, switch_lock_icons));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_only_pinned", FALSE, IconTasklistSettings_private_offset + G_STRUCT_OFFSET (IconTasklistSettingsPrivate, switch_only_pinned));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "show_all_on_click", FALSE, IconTasklistSettings_private_offset + G_STRUCT_OFFSET (IconTasklistSettingsPrivate, show_all_on_click));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_middle_click_create_new_instance", FALSE, IconTasklistSettings_private_offset + G_STRUCT_OFFSET (IconTasklistSettingsPrivate, switch_middle_click_create_new_instance));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_require_double_click_to_launch_new_instance", FALSE, IconTasklistSettings_private_offset + G_STRUCT_OFFSET (IconTasklistSettingsPrivate, switch_require_double_click_to_launch_new_instance));
}

static void
icon_tasklist_settings_instance_init (IconTasklistSettings * self,
                                      gpointer klass)
{
	self->priv = icon_tasklist_settings_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
icon_tasklist_settings_finalize (GObject * obj)
{
	IconTasklistSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ICON_TASKLIST_SETTINGS, IconTasklistSettings);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (icon_tasklist_settings_parent_class)->finalize (obj);
}

GType
icon_tasklist_settings_get_type (void)
{
	return icon_tasklist_settings_type_id;
}

GType
icon_tasklist_settings_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (IconTasklistSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) icon_tasklist_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IconTasklistSettings), 0, (GInstanceInitFunc) icon_tasklist_settings_instance_init, NULL };
	icon_tasklist_settings_type_id = g_type_module_register_type (module, gtk_grid_get_type (), "IconTasklistSettings", &g_define_type_info, 0);
	IconTasklistSettings_private_offset = sizeof (IconTasklistSettingsPrivate);
	return icon_tasklist_settings_type_id;
}

static inline gpointer
icon_tasklist_applet_get_instance_private (IconTasklistApplet* self)
{
	return G_STRUCT_MEMBER_P (self, IconTasklistApplet_private_offset);
}

static GtkWidget*
icon_tasklist_applet_real_get_settings_ui (BudgieApplet* base)
{
	IconTasklistApplet * self;
	const gchar* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	IconTasklistSettings* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* result;
	self = (IconTasklistApplet*) base;
	_tmp0_ = self->priv->_uuid;
	_tmp1_ = budgie_applet_get_applet_settings ((BudgieApplet*) self, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = icon_tasklist_settings_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = (GtkWidget*) _tmp3_;
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static gboolean
icon_tasklist_applet_real_supports_settings (BudgieApplet* base)
{
	IconTasklistApplet * self;
	gboolean result;
	self = (IconTasklistApplet*) base;
	result = TRUE;
	return result;
}

static void
_icon_tasklist_applet_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                              const gchar* key,
                                                              gpointer self)
{
	icon_tasklist_applet_on_settings_changed ((IconTasklistApplet*) self, key);
}

static gboolean
__lambda29_ (IconTasklistApplet* self)
{
	gboolean result;
	icon_tasklist_applet_rebuild_items (self);
	result = FALSE;
	return result;
}

static gboolean
___lambda29__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda29_ ((IconTasklistApplet*) self);
	return result;
}

IconTasklistApplet*
icon_tasklist_applet_construct (GType object_type,
                                const gchar* uuid)
{
	IconTasklistApplet * self = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	g_return_val_if_fail (uuid != NULL, NULL);
	self = (IconTasklistApplet*) g_object_new (object_type, "uuid", uuid, NULL);
	budgie_applet_set_settings_schema ((BudgieApplet*) self, "com.solus-project.icon-tasklist");
	budgie_applet_set_settings_prefix ((BudgieApplet*) self, "/com/solus-project/budgie-panel/instance/icon-tasklist");
	_tmp0_ = budgie_applet_get_applet_settings ((BudgieApplet*) self, uuid);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->settings;
	g_signal_connect_object (_tmp1_, "changed", (GCallback) _icon_tasklist_applet_on_settings_changed_g_settings_changed, self, 0);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda29__gsource_func, g_object_ref (self), g_object_unref);
	icon_tasklist_applet_on_settings_changed (self, "restrict-to-workspace");
	icon_tasklist_applet_on_settings_changed (self, "lock-icons");
	icon_tasklist_applet_on_settings_changed (self, "only-pinned");
	icon_tasklist_applet_connect_app_signals (self);
	gtk_widget_show_all ((GtkWidget*) self);
	return self;
}

IconTasklistApplet*
icon_tasklist_applet_new (const gchar* uuid)
{
	return icon_tasklist_applet_construct (TYPE_ICON_TASKLIST_APPLET, uuid);
}

/**
 * Add IconButton for pinned apps
 */
static gboolean
_icon_tasklist_applet_on_button_press_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                     GdkEventButton* event,
                                                                     gpointer self)
{
	gboolean result;
	result = icon_tasklist_applet_on_button_press ((IconTasklistApplet*) self, _sender, event);
	return result;
}

static gboolean
_icon_tasklist_applet_on_button_release_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                         GdkEventButton* event,
                                                                         gpointer self)
{
	gboolean result;
	result = icon_tasklist_applet_on_button_release ((IconTasklistApplet*) self, _sender, event);
	return result;
}

static void
_icon_tasklist_applet_on_pinned_changed_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self)
{
	icon_tasklist_applet_on_pinned_changed ((IconTasklistApplet*) self, _sender, pspec);
}

static void
icon_tasklist_applet_startup (IconTasklistApplet* self)
{
	gchar** pinned = NULL;
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint pinned_length1;
	gint _pinned_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, "pinned-launchers");
	pinned = _tmp2_;
	pinned_length1 = _vala_array_length (_tmp1_);
	_pinned_size_ = pinned_length1;
	_tmp3_ = pinned;
	_tmp3__length1 = pinned_length1;
	{
		gchar** launcher_collection = NULL;
		gint launcher_collection_length1 = 0;
		gint _launcher_collection_size_ = 0;
		gint launcher_it = 0;
		launcher_collection = _tmp3_;
		launcher_collection_length1 = _tmp3__length1;
		for (launcher_it = 0; launcher_it < launcher_collection_length1; launcher_it = launcher_it + 1) {
			gchar* _tmp4_;
			gchar* launcher = NULL;
			_tmp4_ = g_strdup (launcher_collection[launcher_it]);
			launcher = _tmp4_;
			{
				GDesktopAppInfo* info = NULL;
				const gchar* _tmp5_;
				GDesktopAppInfo* _tmp6_;
				GDesktopAppInfo* _tmp7_;
				BudgieApplication* application = NULL;
				GDesktopAppInfo* _tmp8_;
				BudgieApplication* _tmp9_;
				IconButton* button = NULL;
				BudgiePopoverManager* _tmp10_;
				BudgieApplication* _tmp11_;
				IconButton* _tmp12_ = NULL;
				IconButton* _tmp13_;
				IconButton* _tmp14_;
				IconButton* _tmp15_;
				const gchar* _tmp16_;
				IconButton* _tmp17_;
				_tmp5_ = launcher;
				_tmp6_ = g_desktop_app_info_new (_tmp5_);
				info = _tmp6_;
				_tmp7_ = info;
				if (_tmp7_ == NULL) {
					_g_object_unref0 (info);
					_g_free0 (launcher);
					continue;
				}
				_tmp8_ = info;
				_tmp9_ = budgie_application_new (_tmp8_);
				application = _tmp9_;
				_tmp10_ = self->priv->manager;
				_tmp11_ = application;
				_tmp12_ = icon_button_new (_tmp10_, _tmp11_);
				icon_button_set_pinned (_tmp12_, TRUE);
				g_object_ref_sink (_tmp12_);
				button = _tmp12_;
				_tmp13_ = button;
				g_signal_connect_object ((GtkWidget*) _tmp13_, "button-press-event", (GCallback) _icon_tasklist_applet_on_button_press_gtk_widget_button_press_event, self, 0);
				_tmp14_ = button;
				g_signal_connect_object ((GtkWidget*) _tmp14_, "button-release-event", (GCallback) _icon_tasklist_applet_on_button_release_gtk_widget_button_release_event, self, 0);
				_tmp15_ = button;
				g_signal_connect_object ((GObject*) _tmp15_, "notify::pinned", (GCallback) _icon_tasklist_applet_on_pinned_changed_g_object_notify, self, 0);
				_tmp16_ = launcher;
				_tmp17_ = button;
				icon_tasklist_applet_add_icon_button (self, _tmp16_, _tmp17_);
				_g_object_unref0 (button);
				_g_object_unref0 (application);
				_g_object_unref0 (info);
				_g_free0 (launcher);
			}
		}
	}
	pinned = (_vala_array_free (pinned, pinned_length1, (GDestroyNotify) g_free), NULL);
}

static void
_icon_tasklist_applet_on_active_window_changed_budgie_windowing_windowing_active_window_changed (BudgieWindowingWindowing* _sender,
                                                                                                 XfwWindow* old_active_window,
                                                                                                 XfwWindow* new_active_window,
                                                                                                 gpointer self)
{
	icon_tasklist_applet_on_active_window_changed ((IconTasklistApplet*) self, old_active_window, new_active_window);
}

static void
_icon_tasklist_applet_update_buttons_budgie_windowing_windowing_active_workspace_changed (BudgieWindowingWindowing* _sender,
                                                                                          XfwWorkspace* old_active_workspace,
                                                                                          gpointer self)
{
	icon_tasklist_applet_update_buttons ((IconTasklistApplet*) self);
}

static void
_icon_tasklist_applet_on_app_opened_budgie_windowing_windowing_window_group_added (BudgieWindowingWindowing* _sender,
                                                                                   BudgieWindowingWindowGroup* group,
                                                                                   gpointer self)
{
	icon_tasklist_applet_on_app_opened ((IconTasklistApplet*) self, group);
}

static void
_icon_tasklist_applet_on_app_closed_budgie_windowing_windowing_window_group_removed (BudgieWindowingWindowing* _sender,
                                                                                     BudgieWindowingWindowGroup* group,
                                                                                     gpointer self)
{
	icon_tasklist_applet_on_app_closed ((IconTasklistApplet*) self, group);
}

static void
icon_tasklist_applet_connect_app_signals (IconTasklistApplet* self)
{
	BudgieWindowingWindowing* _tmp0_;
	BudgieWindowingWindowing* _tmp1_;
	BudgieWindowingWindowing* _tmp2_;
	BudgieWindowingWindowing* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->windowing;
	g_signal_connect_object (_tmp0_, "active-window-changed", (GCallback) _icon_tasklist_applet_on_active_window_changed_budgie_windowing_windowing_active_window_changed, self, G_CONNECT_AFTER);
	_tmp1_ = self->priv->windowing;
	g_signal_connect_object (_tmp1_, "active-workspace-changed", (GCallback) _icon_tasklist_applet_update_buttons_budgie_windowing_windowing_active_workspace_changed, self, G_CONNECT_AFTER);
	_tmp2_ = self->priv->windowing;
	g_signal_connect_object (_tmp2_, "window-group-added", (GCallback) _icon_tasklist_applet_on_app_opened_budgie_windowing_windowing_window_group_added, self, 0);
	_tmp3_ = self->priv->windowing;
	g_signal_connect_object (_tmp3_, "window-group-removed", (GCallback) _icon_tasklist_applet_on_app_closed_budgie_windowing_windowing_window_group_removed, self, 0);
}

/**
 * Remove every IconButton and add them back
 */
static void
_icon_tasklist_applet_on_app_opened_gfunc (gconstpointer data,
                                           gpointer self)
{
	icon_tasklist_applet_on_app_opened ((IconTasklistApplet*) self, (BudgieWindowingWindowGroup*) data);
}

static void
icon_tasklist_applet_rebuild_items (IconTasklistApplet* self)
{
	GtkBox* _tmp0_;
	GList* _tmp1_;
	GHashTable* _tmp4_;
	BudgieWindowingWindowing* _tmp5_;
	GList* _tmp6_;
	GList* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_layout;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* widget_collection = NULL;
		GList* widget_it = NULL;
		widget_collection = _tmp1_;
		for (widget_it = widget_collection; widget_it != NULL; widget_it = widget_it->next) {
			GtkWidget* _tmp2_;
			GtkWidget* widget = NULL;
			_tmp2_ = _g_object_ref0 ((GtkWidget*) widget_it->data);
			widget = _tmp2_;
			{
				GtkWidget* _tmp3_;
				_tmp3_ = widget;
				gtk_widget_destroy (_tmp3_);
				_g_object_unref0 (widget);
			}
		}
		(widget_collection == NULL) ? NULL : (widget_collection = (g_list_free (widget_collection), NULL));
	}
	_tmp4_ = self->priv->buttons;
	g_hash_table_remove_all (_tmp4_);
	icon_tasklist_applet_startup (self);
	_tmp5_ = self->priv->windowing;
	_tmp6_ = budgie_windowing_windowing_get_window_groups (_tmp5_);
	_tmp7_ = _tmp6_;
	g_list_foreach (_tmp7_, _icon_tasklist_applet_on_app_opened_gfunc, self);
	(_tmp7_ == NULL) ? NULL : (_tmp7_ = (g_list_free (_tmp7_), NULL));
}

static void
icon_tasklist_applet_on_settings_changed (IconTasklistApplet* self,
                                          const gchar* key)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("lock-icons")))) {
		switch (0) {
			default:
			{
				GSettings* _tmp3_;
				_tmp3_ = self->priv->settings;
				self->priv->lock_icons = g_settings_get_boolean (_tmp3_, key);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("restrict-to-workspace")))) {
		switch (0) {
			default:
			{
				GSettings* _tmp4_;
				_tmp4_ = self->priv->settings;
				self->priv->restrict_to_workspace = g_settings_get_boolean (_tmp4_, key);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("only-pinned")))) {
		switch (0) {
			default:
			{
				GSettings* _tmp5_;
				_tmp5_ = self->priv->settings;
				self->priv->only_show_pinned = g_settings_get_boolean (_tmp5_, key);
				break;
			}
		}
	}
	icon_tasklist_applet_update_buttons (self);
}

static void
__lambda27_ (IconTasklistApplet* self,
             const gchar* id,
             IconButton* button)
{
	g_return_if_fail (id != NULL);
	g_return_if_fail (button != NULL);
	icon_tasklist_applet_update_button (self, button);
}

static void
___lambda27__gh_func (gconstpointer key,
                      gconstpointer value,
                      gpointer self)
{
	__lambda27_ ((IconTasklistApplet*) self, (const gchar*) key, (IconButton*) value);
}

static void
icon_tasklist_applet_update_buttons (IconTasklistApplet* self)
{
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->buttons;
	g_hash_table_foreach (_tmp0_, ___lambda27__gh_func, self);
}

/**
 * Handles the drag_data_get signal for an icon button.
 *
 * This sets the button's application's desktop-id as the drag data.
 */
static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
icon_tasklist_applet_button_drag_data_get (IconTasklistApplet* self,
                                           GtkWidget* widget,
                                           GdkDragContext* context,
                                           GtkSelectionData* data,
                                           guint info,
                                           guint time)
{
	IconButton* button = NULL;
	IconButton* _tmp0_;
	gchar* id = NULL;
	BudgieApplication* _tmp1_;
	BudgieApplication* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	guint8* _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_ = 0;
	guint8* _tmp8_;
	gint _tmp8__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = _g_object_ref0 (IS_ICON_BUTTON (widget) ? ((IconButton*) widget) : NULL);
	button = _tmp0_;
	_tmp1_ = icon_button_get_app (button);
	_tmp2_ = _tmp1_;
	_tmp3_ = budgie_application_get_desktop_id (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	id = _tmp5_;
	_tmp6_ = string_get_data (id, &_tmp7_);
	_tmp6__length1 = _tmp7_;
	_tmp8_ = _tmp6_;
	_tmp8__length1 = _tmp6__length1;
	gtk_selection_data_set (data, gtk_selection_data_get_target (data), 8, _tmp8_, (gint) _tmp8__length1);
	_g_free0 (id);
	_g_object_unref0 (button);
}

/**
 * Handles the drag_begin signal for an icon button.
 *
 * This sets the icon at the cursor when the button is dragged.
 */
static void
icon_tasklist_applet_button_drag_begin (IconTasklistApplet* self,
                                        GtkWidget* widget,
                                        GdkDragContext* context)
{
	IconButton* button = NULL;
	IconButton* _tmp0_;
	gint size = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_;
	gint scale_factor = 0;
	IconButton* _tmp3_;
	GtkIconTheme* icon_theme = NULL;
	GtkIconTheme* _tmp4_;
	GtkIconTheme* _tmp5_;
	GtkIconInfo* icon_info = NULL;
	GtkIconTheme* _tmp6_;
	IconButton* _tmp7_;
	BudgieApplication* _tmp8_;
	BudgieApplication* _tmp9_;
	GIcon* _tmp10_;
	GIcon* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GtkIconInfo* _tmp14_;
	GtkIconInfo* _tmp15_;
	GtkIconInfo* _tmp16_;
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp28_;
	cairo_surface_t* surface = NULL;
	GdkPixbuf* _tmp29_;
	cairo_surface_t* _tmp30_;
	cairo_surface_t* _tmp31_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = _g_object_ref0 (IS_ICON_BUTTON (widget) ? ((IconButton*) widget) : NULL);
	button = _tmp0_;
	size = 0;
	_tmp2_ = gtk_icon_size_lookup (GTK_ICON_SIZE_DND, &_tmp1_, NULL);
	size = _tmp1_;
	if (!_tmp2_) {
		size = 32;
	}
	_tmp3_ = button;
	scale_factor = gtk_widget_get_scale_factor ((GtkWidget*) _tmp3_);
	_tmp4_ = gtk_icon_theme_get_default ();
	_tmp5_ = _g_object_ref0 (_tmp4_);
	icon_theme = _tmp5_;
	_tmp6_ = icon_theme;
	_tmp7_ = button;
	_tmp8_ = icon_button_get_app (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = budgie_application_get_icon (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_icon_to_string (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = gtk_icon_theme_lookup_icon (_tmp6_, _tmp13_, size, GTK_ICON_LOOKUP_USE_BUILTIN);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	icon_info = _tmp15_;
	_tmp16_ = icon_info;
	if (_tmp16_ == NULL) {
		IconButton* _tmp17_;
		BudgieApplication* _tmp18_;
		BudgieApplication* _tmp19_;
		GIcon* _tmp20_;
		GIcon* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp17_ = button;
		_tmp18_ = icon_button_get_app (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = budgie_application_get_icon (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_icon_to_string (_tmp21_);
		_tmp23_ = _tmp22_;
		g_warning ("IconTasklistApplet.vala:232: Unable to find icon: %s", _tmp23_);
		_g_free0 (_tmp23_);
		_g_object_unref0 (icon_info);
		_g_object_unref0 (icon_theme);
		_g_object_unref0 (button);
		return;
	}
	{
		GdkPixbuf* _tmp24_ = NULL;
		GtkIconInfo* _tmp25_;
		GdkPixbuf* _tmp26_;
		GdkPixbuf* _tmp27_;
		_tmp25_ = icon_info;
		_tmp26_ = gtk_icon_info_load_icon (_tmp25_, &_inner_error0_);
		_tmp24_ = _tmp26_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp27_ = _tmp24_;
		_tmp24_ = NULL;
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp27_;
		_g_object_unref0 (_tmp24_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_warning ("IconTasklistApplet.vala:241: Unable to get Pixbuf from Icon");
		_g_object_unref0 (pixbuf);
		_g_object_unref0 (icon_info);
		_g_object_unref0 (icon_theme);
		_g_object_unref0 (button);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (pixbuf);
		_g_object_unref0 (icon_info);
		_g_object_unref0 (icon_theme);
		_g_object_unref0 (button);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp28_ = pixbuf;
	if (_tmp28_ == NULL) {
		_g_object_unref0 (pixbuf);
		_g_object_unref0 (icon_info);
		_g_object_unref0 (icon_theme);
		_g_object_unref0 (button);
		return;
	}
	_tmp29_ = pixbuf;
	_tmp30_ = gdk_cairo_surface_create_from_pixbuf (_tmp29_, scale_factor, NULL);
	surface = _tmp30_;
	_tmp31_ = surface;
	gtk_drag_set_icon_surface (context, _tmp31_);
	_cairo_surface_destroy0 (surface);
	_g_object_unref0 (pixbuf);
	_g_object_unref0 (icon_info);
	_g_object_unref0 (icon_theme);
	_g_object_unref0 (button);
}

/**
 * Handles when a drag item is dropped on a icon button.
 *
 * If the source widget is another icon button, reorder the widgets in
 * our container so that the dropped button is put in the place of this
 * button.
 */
static void
icon_tasklist_applet_button_drag_data_received (IconTasklistApplet* self,
                                                GtkWidget* widget,
                                                GdkDragContext* context,
                                                gint x,
                                                gint y,
                                                GtkSelectionData* data,
                                                guint info,
                                                guint time)
{
	GtkWidget* source = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = gtk_drag_get_source_widget (context);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	source = _tmp1_;
	switch (info) {
		case 0:
		{
			GtkWidget* _tmp2_;
			_tmp2_ = source;
			icon_tasklist_applet_button_drag_data_received_handle_desktop_info (self, widget, context, data, _tmp2_);
			break;
		}
		case 1:
		{
			icon_tasklist_applet_button_drag_data_received_handle_uri (self, context, data, time);
			break;
		}
		default:
		{
			g_warning ("IconTasklistApplet.vala:270: Unknown data passed during drag and drop");
			gtk_drag_finish (context, FALSE, FALSE, gtk_get_current_event_time ());
			break;
		}
	}
	_g_object_unref0 (source);
}

static gint
__lambda30_ (GtkWidget* a,
             GtkWidget* b)
{
	ButtonWrapper* wrapper_a = NULL;
	ButtonWrapper* _tmp0_;
	ButtonWrapper* wrapper_b = NULL;
	ButtonWrapper* _tmp1_;
	GCompareFunc _tmp2_;
	IconButton* _tmp3_;
	IconButton* _tmp4_;
	BudgieApplication* _tmp5_;
	BudgieApplication* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	IconButton* _tmp9_;
	IconButton* _tmp10_;
	BudgieApplication* _tmp11_;
	BudgieApplication* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = _g_object_ref0 (IS_BUTTON_WRAPPER (a) ? ((ButtonWrapper*) a) : NULL);
	wrapper_a = _tmp0_;
	_tmp1_ = _g_object_ref0 (IS_BUTTON_WRAPPER (b) ? ((ButtonWrapper*) b) : NULL);
	wrapper_b = _tmp1_;
	_tmp2_ = ((GCompareFunc) g_strcmp0);
	_tmp3_ = button_wrapper_get_button (wrapper_a);
	_tmp4_ = _tmp3_;
	_tmp5_ = icon_button_get_app (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = budgie_application_get_desktop_id (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = button_wrapper_get_button (wrapper_b);
	_tmp10_ = _tmp9_;
	_tmp11_ = icon_button_get_app (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = budgie_application_get_desktop_id (_tmp12_);
	_tmp14_ = _tmp13_;
	result = _tmp2_ (_tmp8_, _tmp14_);
	_g_object_unref0 (wrapper_b);
	_g_object_unref0 (wrapper_a);
	return result;
}

static gint
___lambda30__gcompare_func (gconstpointer a,
                            gconstpointer b)
{
	gint result;
	result = __lambda30_ ((GtkWidget*) a, (GtkWidget*) b);
	return result;
}

static void
icon_tasklist_applet_button_drag_data_received_handle_desktop_info (IconTasklistApplet* self,
                                                                    GtkWidget* widget,
                                                                    GdkDragContext* context,
                                                                    GtkSelectionData* data,
                                                                    GtkWidget* source)
{
	IconButton* button = NULL;
	IconButton* _tmp0_;
	GList* children = NULL;
	GtkBox* _tmp1_;
	GList* _tmp2_;
	GList* _self_ = NULL;
	GList* _tmp3_;
	IconButton* _tmp4_;
	GtkContainer* _tmp5_;
	GList* _tmp6_;
	GList* _tmp7_;
	gint position = 0;
	GList* _tmp8_;
	GList* _tmp9_;
	GtkBox* _tmp10_;
	GtkContainer* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (data != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = _g_object_ref0 (IS_ICON_BUTTON (widget) ? ((IconButton*) widget) : NULL);
	button = _tmp0_;
	_tmp1_ = self->priv->main_layout;
	_tmp2_ = gtk_container_get_children ((GtkContainer*) _tmp1_);
	children = _tmp2_;
	_tmp3_ = children;
	_tmp4_ = button;
	_tmp5_ = gtk_widget_get_parent ((GtkWidget*) _tmp4_);
	_tmp6_ = g_list_find_custom (_tmp3_, (GtkWidget*) _tmp5_, ___lambda30__gcompare_func);
	_self_ = _tmp6_;
	_tmp7_ = _self_;
	if (_tmp7_ == NULL) {
		g_warning ("IconTasklistApplet.vala:288: Unable to find the correct wrapper");
		gtk_drag_finish (context, FALSE, FALSE, gtk_get_current_event_time ());
		(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
		_g_object_unref0 (button);
		return;
	}
	_tmp8_ = children;
	_tmp9_ = _self_;
	position = g_list_position (_tmp8_, _tmp9_);
	_tmp10_ = self->priv->main_layout;
	_tmp11_ = gtk_widget_get_parent (source);
	gtk_box_reorder_child (_tmp10_, (GtkWidget*) _tmp11_, position);
	icon_tasklist_applet_update_pinned_launchers (self);
	gtk_drag_finish (context, TRUE, gdk_drag_context_get_selected_action (context) == GDK_ACTION_MOVE, gtk_get_current_event_time ());
	(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
	_g_object_unref0 (button);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
icon_tasklist_applet_button_drag_data_received_handle_uri (IconTasklistApplet* self,
                                                           GdkDragContext* context,
                                                           GtkSelectionData* data,
                                                           guint time)
{
	gchar* app_id = NULL;
	guint8* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar** parts = NULL;
	const gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp8_;
	gint _tmp8__length1;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GDesktopAppInfo* info = NULL;
	const gchar* _tmp13_;
	GDesktopAppInfo* _tmp14_;
	GDesktopAppInfo* _tmp15_;
	GDesktopAppInfo* _tmp16_;
	const gchar* _tmp17_;
	gchar* launcher = NULL;
	GDesktopAppInfo* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	GHashTable* _tmp21_;
	const gchar* _tmp22_;
	BudgieApplication* application = NULL;
	GDesktopAppInfo* _tmp23_;
	BudgieApplication* _tmp24_;
	IconButton* button = NULL;
	BudgiePopoverManager* _tmp25_;
	BudgieApplication* _tmp26_;
	IconButton* _tmp27_ = NULL;
	IconButton* _tmp28_;
	IconButton* _tmp29_;
	IconButton* _tmp30_;
	const gchar* _tmp31_;
	IconButton* _tmp32_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = gtk_selection_data_get_data (data);
	_tmp1_ = g_strdup ((const gchar*) _tmp0_);
	app_id = _tmp1_;
	_tmp2_ = app_id;
	if (!g_str_has_prefix (_tmp2_, "file://")) {
		gtk_drag_finish (context, FALSE, FALSE, (guint32) time);
		_g_free0 (app_id);
		return;
	}
	_tmp3_ = app_id;
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, "://", 0);
	parts = _tmp5_;
	parts_length1 = _vala_array_length (_tmp4_);
	_parts_size_ = parts_length1;
	_tmp6_ = parts;
	_tmp6__length1 = parts_length1;
	if (_tmp6__length1 < 2) {
		const gchar* _tmp7_;
		_tmp7_ = app_id;
		g_warning ("IconTasklistApplet.vala:311: Malformed URI: %s", _tmp7_);
		gtk_drag_finish (context, FALSE, FALSE, (guint32) time);
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (app_id);
		return;
	}
	_tmp8_ = parts;
	_tmp8__length1 = parts_length1;
	_tmp9_ = _tmp8_[1];
	_tmp10_ = g_strdup (_tmp9_);
	_g_free0 (app_id);
	app_id = _tmp10_;
	_tmp11_ = app_id;
	_tmp12_ = string_strip (_tmp11_);
	_g_free0 (app_id);
	app_id = _tmp12_;
	_tmp13_ = app_id;
	_tmp14_ = g_desktop_app_info_new_from_filename (_tmp13_);
	info = _tmp14_;
	_tmp15_ = info;
	if (_tmp15_ == NULL) {
		gtk_drag_finish (context, FALSE, FALSE, (guint32) time);
		_g_object_unref0 (info);
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (app_id);
		return;
	}
	_tmp16_ = info;
	_tmp17_ = g_desktop_app_info_get_startup_wm_class (_tmp16_);
	if (g_strcmp0 (_tmp17_, "budgie-desktop-settings") == 0) {
		gtk_drag_finish (context, FALSE, FALSE, (guint32) time);
		_g_object_unref0 (info);
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (app_id);
		return;
	}
	_tmp18_ = info;
	_tmp19_ = g_app_info_get_id ((GAppInfo*) _tmp18_);
	_tmp20_ = g_strdup (_tmp19_);
	launcher = _tmp20_;
	_tmp21_ = self->priv->buttons;
	_tmp22_ = launcher;
	if (g_hash_table_contains (_tmp21_, _tmp22_)) {
		gtk_drag_finish (context, TRUE, gdk_drag_context_get_selected_action (context) == GDK_ACTION_MOVE, (guint32) time);
		_g_free0 (launcher);
		_g_object_unref0 (info);
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (app_id);
		return;
	}
	_tmp23_ = info;
	_tmp24_ = budgie_application_new (_tmp23_);
	application = _tmp24_;
	_tmp25_ = self->priv->manager;
	_tmp26_ = application;
	_tmp27_ = icon_button_new (_tmp25_, _tmp26_);
	icon_button_set_pinned (_tmp27_, TRUE);
	g_object_ref_sink (_tmp27_);
	button = _tmp27_;
	_tmp28_ = button;
	g_signal_connect_object ((GtkWidget*) _tmp28_, "button-press-event", (GCallback) _icon_tasklist_applet_on_button_press_gtk_widget_button_press_event, self, 0);
	_tmp29_ = button;
	g_signal_connect_object ((GtkWidget*) _tmp29_, "button-release-event", (GCallback) _icon_tasklist_applet_on_button_release_gtk_widget_button_release_event, self, 0);
	_tmp30_ = button;
	g_signal_connect_object ((GObject*) _tmp30_, "notify::pinned", (GCallback) _icon_tasklist_applet_on_pinned_changed_g_object_notify, self, 0);
	_tmp31_ = launcher;
	_tmp32_ = button;
	icon_tasklist_applet_add_icon_button (self, _tmp31_, _tmp32_);
	icon_tasklist_applet_update_pinned_launchers (self);
	gtk_drag_finish (context, TRUE, gdk_drag_context_get_selected_action (context) == GDK_ACTION_MOVE, (guint32) time);
	_g_object_unref0 (button);
	_g_object_unref0 (application);
	_g_free0 (launcher);
	_g_object_unref0 (info);
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (app_id);
}

/**
 * Handles when the cursor leaves the space of a button during a drag.
 */
static void
icon_tasklist_applet_button_drag_leave (IconTasklistApplet* self,
                                        GtkWidget* widget,
                                        GdkDragContext* context,
                                        guint time)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (context != NULL);
	gtk_drag_unhighlight (widget);
}

/**
 * Handles when a widget is dragged over a tasklist button.
 */
static gboolean
icon_tasklist_applet_button_drag_motion (IconTasklistApplet* self,
                                         GtkWidget* widget,
                                         GdkDragContext* context,
                                         gint x,
                                         gint y,
                                         guint time)
{
	GdkAtom ret = (GdkAtom) 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	ret = gtk_drag_dest_find_target (widget, context, NULL);
	if (ret == GDK_NONE) {
		gdk_drag_status (context, 0, (guint32) time);
		result = FALSE;
		return result;
	}
	gtk_drag_highlight (widget);
	gdk_drag_status (context, GDK_ACTION_MOVE, (guint32) time);
	result = TRUE;
	return result;
}

static gboolean
icon_tasklist_applet_button_drag_drop (IconTasklistApplet* self,
                                       GtkWidget* widget,
                                       GdkDragContext* context,
                                       gint x,
                                       gint y,
                                       guint time)
{
	GdkAtom ret = (GdkAtom) 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	ret = gtk_drag_dest_find_target (widget, context, NULL);
	gtk_drag_get_data (widget, context, ret, (guint32) time);
	result = TRUE;
	return result;
}

/**
 * on_app_opened handles when we open a new app
 */
static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
icon_tasklist_applet_on_app_opened (IconTasklistApplet* self,
                                    BudgieWindowingWindowGroup* group)
{
	gchar* application_id = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	BudgieApplication* application = NULL;
	GDesktopAppInfo* _tmp4_;
	GDesktopAppInfo* _tmp5_;
	GHashTable* _tmp17_;
	const gchar* _tmp18_;
	IconButton* button = NULL;
	GHashTable* _tmp37_;
	const gchar* _tmp38_;
	IconButton* _tmp46_;
	IconButton* _tmp55_;
	BudgieWindowingWindowGroup* _tmp56_;
	BudgieWindowingWindowGroup* _tmp57_;
	gboolean _tmp58_;
	IconButton* _tmp60_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	_tmp0_ = budgie_windowing_window_group_get_group_id (group);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	application_id = _tmp3_;
	application = NULL;
	_tmp4_ = budgie_windowing_window_group_get_app_info (group);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		GDesktopAppInfo* _tmp6_;
		GDesktopAppInfo* _tmp7_;
		BudgieApplication* _tmp8_;
		GHashTable* _tmp9_;
		BudgieApplication* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp6_ = budgie_windowing_window_group_get_app_info (group);
		_tmp7_ = _tmp6_;
		_tmp8_ = budgie_application_new (_tmp7_);
		_g_object_unref0 (application);
		application = _tmp8_;
		_tmp9_ = self->priv->buttons;
		_tmp10_ = application;
		_tmp11_ = budgie_application_get_desktop_id (_tmp10_);
		_tmp12_ = _tmp11_;
		if (g_hash_table_contains (_tmp9_, _tmp12_)) {
			BudgieApplication* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp13_ = application;
			_tmp14_ = budgie_application_get_desktop_id (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strdup (_tmp15_);
			_g_free0 (application_id);
			application_id = _tmp16_;
		}
	}
	_tmp17_ = self->priv->buttons;
	_tmp18_ = application_id;
	if (g_hash_table_contains (_tmp17_, _tmp18_)) {
		IconButton* first_button = NULL;
		GHashTable* _tmp19_;
		const gchar* _tmp20_;
		gconstpointer _tmp21_;
		IconButton* _tmp22_;
		gboolean _tmp23_ = FALSE;
		IconButton* _tmp24_;
		Icon* _tmp25_;
		Icon* _tmp26_;
		gboolean _tmp27_;
		_tmp19_ = self->priv->buttons;
		_tmp20_ = application_id;
		_tmp21_ = g_hash_table_lookup (_tmp19_, _tmp20_);
		_tmp22_ = _g_object_ref0 ((IconButton*) _tmp21_);
		first_button = _tmp22_;
		_tmp24_ = first_button;
		_tmp25_ = icon_button_get_icon (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = !_tmp26_->waiting;
		_g_object_unref0 (_tmp26_);
		if (_tmp27_) {
			IconButton* _tmp28_;
			Icon* _tmp29_;
			Icon* _tmp30_;
			_tmp28_ = first_button;
			_tmp29_ = icon_button_get_icon (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp23_ = gtk_widget_get_realized ((GtkWidget*) _tmp30_);
			_g_object_unref0 (_tmp30_);
		} else {
			_tmp23_ = FALSE;
		}
		if (_tmp23_) {
			IconButton* _tmp31_;
			Icon* _tmp32_;
			Icon* _tmp33_;
			IconButton* _tmp34_;
			Icon* _tmp35_;
			Icon* _tmp36_;
			_tmp31_ = first_button;
			_tmp32_ = icon_button_get_icon (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp33_->waiting = TRUE;
			_g_object_unref0 (_tmp33_);
			_tmp34_ = first_button;
			_tmp35_ = icon_button_get_icon (_tmp34_);
			_tmp36_ = _tmp35_;
			icon_animate_wait (_tmp36_);
			_g_object_unref0 (_tmp36_);
		}
		_g_object_unref0 (first_button);
	}
	button = NULL;
	_tmp37_ = self->priv->buttons;
	_tmp38_ = application_id;
	if (g_hash_table_contains (_tmp37_, _tmp38_)) {
		GHashTable* _tmp39_;
		const gchar* _tmp40_;
		gconstpointer _tmp41_;
		IconButton* _tmp42_;
		IconButton* _tmp43_;
		_tmp39_ = self->priv->buttons;
		_tmp40_ = application_id;
		_tmp41_ = g_hash_table_lookup (_tmp39_, _tmp40_);
		_tmp42_ = _g_object_ref0 ((IconButton*) _tmp41_);
		_g_object_unref0 (button);
		button = _tmp42_;
		_tmp43_ = button;
		if (_tmp43_ != NULL) {
			const gchar* _tmp44_;
			IconButton* _tmp45_;
			_tmp44_ = application_id;
			_tmp45_ = button;
			icon_tasklist_applet_add_button (self, _tmp44_, _tmp45_);
		}
	}
	_tmp46_ = button;
	if (_tmp46_ == NULL) {
		BudgiePopoverManager* _tmp47_;
		BudgieApplication* _tmp48_;
		IconButton* _tmp49_;
		IconButton* _tmp50_;
		IconButton* _tmp51_;
		IconButton* _tmp52_;
		const gchar* _tmp53_;
		IconButton* _tmp54_;
		_tmp47_ = self->priv->manager;
		_tmp48_ = application;
		_tmp49_ = icon_button_new_with_group (group, _tmp47_, _tmp48_);
		g_object_ref_sink (_tmp49_);
		_g_object_unref0 (button);
		button = _tmp49_;
		_tmp50_ = button;
		g_signal_connect_object ((GtkWidget*) _tmp50_, "button-press-event", (GCallback) _icon_tasklist_applet_on_button_press_gtk_widget_button_press_event, self, 0);
		_tmp51_ = button;
		g_signal_connect_object ((GtkWidget*) _tmp51_, "button-release-event", (GCallback) _icon_tasklist_applet_on_button_release_gtk_widget_button_release_event, self, 0);
		_tmp52_ = button;
		g_signal_connect_object ((GObject*) _tmp52_, "notify::pinned", (GCallback) _icon_tasklist_applet_on_pinned_changed_g_object_notify, self, 0);
		_tmp53_ = application_id;
		_tmp54_ = button;
		icon_tasklist_applet_add_icon_button (self, _tmp53_, _tmp54_);
	}
	_tmp55_ = button;
	_tmp56_ = icon_button_get_window_group (_tmp55_);
	_tmp57_ = _tmp56_;
	_tmp58_ = _tmp57_ == NULL;
	_g_object_unref0 (_tmp57_);
	if (_tmp58_) {
		IconButton* _tmp59_;
		_tmp59_ = button;
		icon_button_set_window_group (_tmp59_, group);
	}
	_tmp60_ = button;
	icon_tasklist_applet_update_button (self, _tmp60_);
	_g_object_unref0 (button);
	_g_object_unref0 (application);
	_g_free0 (application_id);
}

static void
icon_tasklist_applet_on_app_closed (IconTasklistApplet* self,
                                    BudgieWindowingWindowGroup* group)
{
	gchar* app_id = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	IconButton* button = NULL;
	GHashTable* _tmp4_;
	const gchar* _tmp5_;
	gconstpointer _tmp6_;
	IconButton* _tmp7_;
	IconButton* _tmp8_;
	IconButton* _tmp21_;
	IconButton* _tmp27_;
	gboolean _tmp28_;
	gboolean _tmp29_;
	IconButton* _tmp35_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	_tmp0_ = budgie_windowing_window_group_get_group_id (group);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	app_id = _tmp3_;
	_tmp4_ = self->priv->buttons;
	_tmp5_ = app_id;
	_tmp6_ = g_hash_table_lookup (_tmp4_, _tmp5_);
	_tmp7_ = _g_object_ref0 ((IconButton*) _tmp6_);
	button = _tmp7_;
	_tmp8_ = button;
	if (_tmp8_ == NULL) {
		gchar* _tmp9_;
		GHashTable* _tmp10_;
		const gchar* _tmp11_;
		gconstpointer _tmp12_;
		IconButton* _tmp13_;
		IconButton* _tmp14_;
		_tmp9_ = budgie_windowing_window_group_get_desktop_id (group);
		_g_free0 (app_id);
		app_id = _tmp9_;
		_tmp10_ = self->priv->buttons;
		_tmp11_ = app_id;
		_tmp12_ = g_hash_table_lookup (_tmp10_, _tmp11_);
		_tmp13_ = _g_object_ref0 ((IconButton*) _tmp12_);
		_g_object_unref0 (button);
		button = _tmp13_;
		_tmp14_ = button;
		if (_tmp14_ == NULL) {
			const gchar* _tmp15_;
			gchar* _tmp16_;
			GHashTable* _tmp17_;
			const gchar* _tmp18_;
			gconstpointer _tmp19_;
			IconButton* _tmp20_;
			_tmp15_ = app_id;
			_tmp16_ = g_utf8_strdown (_tmp15_, (gssize) -1);
			_g_free0 (app_id);
			app_id = _tmp16_;
			_tmp17_ = self->priv->buttons;
			_tmp18_ = app_id;
			_tmp19_ = g_hash_table_lookup (_tmp17_, _tmp18_);
			_tmp20_ = _g_object_ref0 ((IconButton*) _tmp19_);
			_g_object_unref0 (button);
			button = _tmp20_;
		}
	}
	_tmp21_ = button;
	if (_tmp21_ == NULL) {
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		_tmp22_ = budgie_windowing_window_group_get_group_id (group);
		_tmp23_ = _tmp22_;
		_tmp24_ = string_to_string (_tmp23_);
		_tmp25_ = g_strconcat ("an application (", _tmp24_, ") was closed, but we couldn't find its button", NULL);
		_tmp26_ = _tmp25_;
		g_warning ("IconTasklistApplet.vala:455: %s", _tmp26_);
		_g_free0 (_tmp26_);
		_g_object_unref0 (button);
		_g_free0 (app_id);
		return;
	}
	_tmp27_ = button;
	_tmp28_ = icon_button_get_pinned (_tmp27_);
	_tmp29_ = _tmp28_;
	if (!_tmp29_) {
		IconButton* _tmp30_;
		GtkContainer* _tmp31_;
		const gchar* _tmp34_;
		_tmp30_ = button;
		_tmp31_ = gtk_widget_get_parent ((GtkWidget*) _tmp30_);
		if (IS_BUTTON_WRAPPER (_tmp31_)) {
			IconButton* _tmp32_;
			GtkContainer* _tmp33_;
			_tmp32_ = button;
			_tmp33_ = gtk_widget_get_parent ((GtkWidget*) _tmp32_);
			button_wrapper_gracefully_die (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, TYPE_BUTTON_WRAPPER, ButtonWrapper));
		}
		_tmp34_ = app_id;
		icon_tasklist_applet_remove_button (self, _tmp34_);
		_g_object_unref0 (button);
		_g_free0 (app_id);
		return;
	}
	_tmp35_ = button;
	icon_button_update (_tmp35_);
	_g_object_unref0 (button);
	_g_free0 (app_id);
}

static void
icon_tasklist_applet_on_active_window_changed (IconTasklistApplet* self,
                                               XfwWindow* old_active_window,
                                               XfwWindow* new_active_window)
{
	GHashTable* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->buttons;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* button_collection = NULL;
		GList* button_it = NULL;
		button_collection = _tmp1_;
		for (button_it = button_collection; button_it != NULL; button_it = button_it->next) {
			IconButton* _tmp2_;
			IconButton* button = NULL;
			_tmp2_ = _g_object_ref0 ((IconButton*) button_it->data);
			button = _tmp2_;
			{
				gboolean _tmp3_ = FALSE;
				IconButton* _tmp7_;
				if (new_active_window != NULL) {
					IconButton* _tmp4_;
					_tmp4_ = button;
					_tmp3_ = icon_button_has_window (_tmp4_, new_active_window);
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					IconButton* _tmp5_;
					_tmp5_ = button;
					icon_button_set_active_window (_tmp5_, TRUE);
				} else {
					IconButton* _tmp6_;
					_tmp6_ = button;
					icon_button_set_active_window (_tmp6_, FALSE);
				}
				_tmp7_ = button;
				icon_button_update (_tmp7_);
				_g_object_unref0 (button);
			}
		}
		(button_collection == NULL) ? NULL : (button_collection = (g_list_free (button_collection), NULL));
	}
}

static gboolean
icon_tasklist_applet_on_button_press (IconTasklistApplet* self,
                                      GtkWidget* widget,
                                      GdkEventButton* event)
{
	GSettings* _tmp0_;
	IconButton* button = NULL;
	IconButton* _tmp1_;
	gboolean _tmp2_ = FALSE;
	IconButton* _tmp3_;
	BudgieWindowingWindowGroup* _tmp4_;
	BudgieWindowingWindowGroup* _tmp5_;
	gboolean _tmp6_;
	IconButton* _tmp10_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button != ((guint) GDK_BUTTON_PRIMARY)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp0_ = self->priv->settings;
	if (!g_settings_get_boolean (_tmp0_, "require-double-click-to-launch")) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	if (event->type != GDK_DOUBLE_BUTTON_PRESS) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp1_ = _g_object_ref0 (IS_ICON_BUTTON (widget) ? ((IconButton*) widget) : NULL);
	button = _tmp1_;
	_tmp3_ = button;
	_tmp4_ = icon_button_get_window_group (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_ != NULL;
	_g_object_unref0 (_tmp5_);
	if (_tmp6_) {
		IconButton* _tmp7_;
		BudgieWindowingWindowGroup* _tmp8_;
		BudgieWindowingWindowGroup* _tmp9_;
		_tmp7_ = button;
		_tmp8_ = icon_button_get_window_group (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp2_ = budgie_windowing_window_group_has_windows (_tmp9_);
		_g_object_unref0 (_tmp9_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = GDK_EVENT_PROPAGATE;
		_g_object_unref0 (button);
		return result;
	}
	_tmp10_ = button;
	if (!icon_button_launch (_tmp10_)) {
		IconButton* _tmp11_;
		BudgieApplication* _tmp12_;
		BudgieApplication* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		_tmp11_ = button;
		_tmp12_ = icon_button_get_app (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = budgie_application_get_name (_tmp13_);
		_tmp15_ = _tmp14_;
		g_warning ("IconTasklistApplet.vala:494: Failed to launch application: %s", _tmp15_);
	}
	result = GDK_EVENT_STOP;
	_g_object_unref0 (button);
	return result;
}

static gboolean
icon_tasklist_applet_on_button_release (IconTasklistApplet* self,
                                        GtkWidget* widget,
                                        GdkEventButton* event)
{
	IconButton* button = NULL;
	IconButton* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (IS_ICON_BUTTON (widget) ? ((IconButton*) widget) : NULL);
	button = _tmp0_;
	switch (event->button) {
		case GDK_BUTTON_PRIMARY:
		{
			gboolean _tmp1_ = FALSE;
			IconButton* _tmp2_;
			BudgieWindowingWindowGroup* _tmp3_;
			BudgieWindowingWindowGroup* _tmp4_;
			gboolean _tmp5_;
			gboolean has_open_windows = FALSE;
			gboolean _tmp9_ = FALSE;
			_tmp2_ = button;
			_tmp3_ = icon_button_get_window_group (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = _tmp4_ != NULL;
			_g_object_unref0 (_tmp4_);
			if (_tmp5_) {
				IconButton* _tmp6_;
				BudgieWindowingWindowGroup* _tmp7_;
				BudgieWindowingWindowGroup* _tmp8_;
				_tmp6_ = button;
				_tmp7_ = icon_button_get_window_group (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp1_ = budgie_windowing_window_group_has_windows (_tmp8_);
				_g_object_unref0 (_tmp8_);
			} else {
				_tmp1_ = FALSE;
			}
			has_open_windows = _tmp1_;
			if (has_open_windows) {
				GSettings* _tmp10_;
				_tmp10_ = self->priv->settings;
				_tmp9_ = g_settings_get_boolean (_tmp10_, "show-all-windows-on-click");
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				BudgieWindowingWindowGroup* group = NULL;
				IconButton* _tmp11_;
				BudgieWindowingWindowGroup* _tmp12_;
				GList* windows = NULL;
				BudgieWindowingWindowGroup* _tmp13_;
				GList* _tmp14_;
				gboolean has_active = FALSE;
				GList* _tmp15_;
				GList* _tmp17_;
				_tmp11_ = button;
				_tmp12_ = icon_button_get_window_group (_tmp11_);
				group = _tmp12_;
				_tmp13_ = group;
				_tmp14_ = budgie_windowing_window_group_get_windows (_tmp13_);
				windows = _tmp14_;
				has_active = FALSE;
				_tmp15_ = windows;
				{
					GList* window_collection = NULL;
					GList* window_it = NULL;
					window_collection = _tmp15_;
					for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
						XfwWindow* window = NULL;
						window = (XfwWindow*) window_it->data;
						{
							XfwWindow* _tmp16_;
							_tmp16_ = window;
							if (!xfw_window_is_minimized (_tmp16_)) {
								has_active = TRUE;
								break;
							}
						}
					}
				}
				_tmp17_ = windows;
				{
					GList* window_collection = NULL;
					GList* window_it = NULL;
					window_collection = _tmp17_;
					for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
						XfwWindow* window = NULL;
						window = (XfwWindow*) window_it->data;
						{
							if (has_active) {
								{
									XfwWindow* _tmp18_;
									_tmp18_ = window;
									xfw_window_set_minimized (_tmp18_, TRUE, &_inner_error0_);
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
										goto __catch0_g_error;
									}
								}
								goto __finally0;
								__catch0_g_error:
								{
									GError* e = NULL;
									XfwWindow* _tmp19_;
									const gchar* _tmp20_;
									GError* _tmp21_;
									const gchar* _tmp22_;
									e = _inner_error0_;
									_inner_error0_ = NULL;
									_tmp19_ = window;
									_tmp20_ = xfw_window_get_name (_tmp19_);
									_tmp21_ = e;
									_tmp22_ = _tmp21_->message;
									g_warning ("IconTasklistApplet.vala:528: Unable to minimize window '%s': %s", _tmp20_, _tmp22_);
									_g_error_free0 (e);
								}
								__finally0:
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									gboolean _tmp23_ = FALSE;
									(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
									_g_object_unref0 (group);
									_g_object_unref0 (button);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
									g_clear_error (&_inner_error0_);
									return _tmp23_;
								}
							} else {
								{
									XfwWindow* _tmp24_;
									XfwWindow* _tmp25_;
									_tmp24_ = window;
									xfw_window_set_minimized (_tmp24_, FALSE, &_inner_error0_);
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
										goto __catch1_g_error;
									}
									_tmp25_ = window;
									xfw_window_activate (_tmp25_, NULL, (guint64) event->time, &_inner_error0_);
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
										goto __catch1_g_error;
									}
								}
								goto __finally1;
								__catch1_g_error:
								{
									GError* e = NULL;
									XfwWindow* _tmp26_;
									const gchar* _tmp27_;
									GError* _tmp28_;
									const gchar* _tmp29_;
									e = _inner_error0_;
									_inner_error0_ = NULL;
									_tmp26_ = window;
									_tmp27_ = xfw_window_get_name (_tmp26_);
									_tmp28_ = e;
									_tmp29_ = _tmp28_->message;
									g_warning ("IconTasklistApplet.vala:535: Unable to un-minimize or activate window " \
"'%s': %s", _tmp27_, _tmp29_);
									_g_error_free0 (e);
								}
								__finally1:
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									gboolean _tmp30_ = FALSE;
									(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
									_g_object_unref0 (group);
									_g_object_unref0 (button);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
									g_clear_error (&_inner_error0_);
									return _tmp30_;
								}
							}
						}
					}
				}
				(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
				_g_object_unref0 (group);
			} else {
				if (has_open_windows) {
					BudgieWindowingWindowGroup* group = NULL;
					IconButton* _tmp31_;
					BudgieWindowingWindowGroup* _tmp32_;
					IconButton* _tmp33_;
					gboolean _tmp34_;
					gboolean _tmp35_;
					_tmp31_ = button;
					_tmp32_ = icon_button_get_window_group (_tmp31_);
					group = _tmp32_;
					_tmp33_ = button;
					_tmp34_ = icon_button_get_has_active_window (_tmp33_);
					_tmp35_ = _tmp34_;
					if (_tmp35_) {
						XfwWindow* window = NULL;
						BudgieWindowingWindowGroup* _tmp36_;
						XfwWindow* _tmp37_;
						XfwWindow* _tmp38_;
						_tmp36_ = group;
						_tmp37_ = budgie_windowing_window_group_get_active_window (_tmp36_);
						_tmp38_ = _g_object_ref0 (_tmp37_);
						window = _tmp38_;
						{
							XfwWindow* _tmp39_;
							XfwWindow* _tmp40_;
							_tmp39_ = window;
							_tmp40_ = window;
							xfw_window_set_minimized (_tmp39_, !xfw_window_is_minimized (_tmp40_), &_inner_error0_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								goto __catch2_g_error;
							}
						}
						goto __finally2;
						__catch2_g_error:
						{
							GError* e = NULL;
							XfwWindow* _tmp41_;
							const gchar* _tmp42_;
							GError* _tmp43_;
							const gchar* _tmp44_;
							e = _inner_error0_;
							_inner_error0_ = NULL;
							_tmp41_ = window;
							_tmp42_ = xfw_window_get_name (_tmp41_);
							_tmp43_ = e;
							_tmp44_ = _tmp43_->message;
							g_warning ("IconTasklistApplet.vala:549: Unable to set minimized state of window %" \
"s: %s", _tmp42_, _tmp44_);
							_g_error_free0 (e);
						}
						__finally2:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							gboolean _tmp45_ = FALSE;
							_g_object_unref0 (window);
							_g_object_unref0 (group);
							_g_object_unref0 (button);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return _tmp45_;
						}
						_g_object_unref0 (window);
					} else {
						XfwWindow* window = NULL;
						BudgieWindowingWindowGroup* _tmp46_;
						XfwWindow* _tmp47_;
						XfwWindow* _tmp48_;
						_tmp46_ = group;
						_tmp47_ = budgie_windowing_window_group_get_last_active_window (_tmp46_);
						_tmp48_ = _g_object_ref0 (_tmp47_);
						window = _tmp48_;
						{
							XfwWindow* _tmp49_;
							_tmp49_ = window;
							xfw_window_activate (_tmp49_, NULL, (guint64) event->time, &_inner_error0_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								goto __catch3_g_error;
							}
						}
						goto __finally3;
						__catch3_g_error:
						{
							GError* e = NULL;
							XfwWindow* _tmp50_;
							const gchar* _tmp51_;
							GError* _tmp52_;
							const gchar* _tmp53_;
							e = _inner_error0_;
							_inner_error0_ = NULL;
							_tmp50_ = window;
							_tmp51_ = xfw_window_get_name (_tmp50_);
							_tmp52_ = e;
							_tmp53_ = _tmp52_->message;
							g_warning ("IconTasklistApplet.vala:557: Unable to activate window %s: %s", _tmp51_, _tmp53_);
							_g_error_free0 (e);
						}
						__finally3:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							gboolean _tmp54_ = FALSE;
							_g_object_unref0 (window);
							_g_object_unref0 (group);
							_g_object_unref0 (button);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return _tmp54_;
						}
						_g_object_unref0 (window);
					}
					_g_object_unref0 (group);
				} else {
					GSettings* _tmp55_;
					IconButton* _tmp56_;
					_tmp55_ = self->priv->settings;
					if (g_settings_get_boolean (_tmp55_, "require-double-click-to-launch")) {
						break;
					}
					_tmp56_ = button;
					if (!icon_button_launch (_tmp56_)) {
						IconButton* _tmp57_;
						BudgieApplication* _tmp58_;
						BudgieApplication* _tmp59_;
						const gchar* _tmp60_;
						const gchar* _tmp61_;
						_tmp57_ = button;
						_tmp58_ = icon_button_get_app (_tmp57_);
						_tmp59_ = _tmp58_;
						_tmp60_ = budgie_application_get_name (_tmp59_);
						_tmp61_ = _tmp60_;
						g_warning ("IconTasklistApplet.vala:564: Failed to launch application: %s", _tmp61_);
					}
				}
			}
			break;
		}
		case GDK_BUTTON_SECONDARY:
		{
			BudgiePopoverManager* _tmp62_;
			IconButton* _tmp63_;
			_tmp62_ = self->priv->manager;
			_tmp63_ = button;
			budgie_popover_manager_show_popover (_tmp62_, (GtkWidget*) _tmp63_);
			result = GDK_EVENT_STOP;
			_g_object_unref0 (button);
			return result;
		}
		case GDK_BUTTON_MIDDLE:
		{
			GSettings* _tmp64_;
			IconButton* _tmp65_;
			_tmp64_ = self->priv->settings;
			if (g_settings_get_boolean (_tmp64_, "middle-click-launch-new-instance")) {
				break;
			}
			_tmp65_ = button;
			if (!icon_button_launch (_tmp65_)) {
				IconButton* _tmp66_;
				BudgieApplication* _tmp67_;
				BudgieApplication* _tmp68_;
				const gchar* _tmp69_;
				const gchar* _tmp70_;
				_tmp66_ = button;
				_tmp67_ = icon_button_get_app (_tmp66_);
				_tmp68_ = _tmp67_;
				_tmp69_ = budgie_application_get_name (_tmp68_);
				_tmp70_ = _tmp69_;
				g_warning ("IconTasklistApplet.vala:575: Failed to launch application: %s", _tmp70_);
			}
			break;
		}
		default:
		break;
	}
	result = GDK_EVENT_PROPAGATE;
	_g_object_unref0 (button);
	return result;
}

/**
 * Our panel has moved somewhere, stash the positions
 */
static void
icon_tasklist_applet_real_panel_position_changed (BudgieApplet* base,
                                                  BudgiePanelPosition position)
{
	IconTasklistApplet * self;
	GHashTable* _tmp0_;
	GList* _tmp1_;
	GtkBox* _tmp5_;
	self = (IconTasklistApplet*) base;
	self->priv->panel_position = position;
	_tmp0_ = self->priv->buttons;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* button_collection = NULL;
		GList* button_it = NULL;
		button_collection = _tmp1_;
		for (button_it = button_collection; button_it != NULL; button_it = button_it->next) {
			IconButton* _tmp2_;
			IconButton* button = NULL;
			_tmp2_ = _g_object_ref0 ((IconButton*) button_it->data);
			button = _tmp2_;
			{
				IconButton* _tmp3_;
				IconButton* _tmp4_;
				_tmp3_ = button;
				icon_button_set_panel_position (_tmp3_, position);
				_tmp4_ = button;
				icon_button_set_orientation (_tmp4_, icon_tasklist_applet_get_orientation (self));
				_g_object_unref0 (button);
			}
		}
		(button_collection == NULL) ? NULL : (button_collection = (g_list_free (button_collection), NULL));
	}
	_tmp5_ = self->priv->main_layout;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp5_, icon_tasklist_applet_get_orientation (self));
	icon_tasklist_applet_resize (self);
}

/**
 * Our panel has changed size, record the new icon sizes
 */
static void
icon_tasklist_applet_real_panel_size_changed (BudgieApplet* base,
                                              gint panel,
                                              gint icon,
                                              gint small_icon)
{
	IconTasklistApplet * self;
	self = (IconTasklistApplet*) base;
	self->priv->icon_size = small_icon;
	self->priv->panel_size = panel;
	icon_tasklist_applet_resize (self);
}

static void
__lambda31_ (IconTasklistApplet* self,
             const gchar* id,
             IconButton* button)
{
	g_return_if_fail (id != NULL);
	g_return_if_fail (button != NULL);
	icon_button_set_icon_size (button, self->priv->icon_size);
	icon_button_set_panel_size (button, self->priv->panel_size);
	gtk_widget_queue_resize ((GtkWidget*) button);
}

static void
___lambda31__gh_func (gconstpointer key,
                      gconstpointer value,
                      gpointer self)
{
	__lambda31_ ((IconTasklistApplet*) self, (const gchar*) key, (IconButton*) value);
}

static void
icon_tasklist_applet_resize (IconTasklistApplet* self)
{
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->buttons;
	g_hash_table_foreach (_tmp0_, ___lambda31__gh_func, self);
	gtk_widget_queue_resize ((GtkWidget*) self);
}

static void
icon_tasklist_applet_real_update_popovers (BudgieApplet* base,
                                           BudgiePopoverManager* manager)
{
	IconTasklistApplet * self;
	self = (IconTasklistApplet*) base;
	self->priv->manager = manager;
}

/**
 * Return our orientation in relation to the panel position
 */
static GtkOrientation
icon_tasklist_applet_get_orientation (IconTasklistApplet* self)
{
	GtkOrientation result;
	g_return_val_if_fail (self != NULL, 0);
	switch (self->priv->panel_position) {
		case BUDGIE_PANEL_POSITION_TOP:
		case BUDGIE_PANEL_POSITION_BOTTOM:
		{
			result = GTK_ORIENTATION_HORIZONTAL;
			return result;
		}
		default:
		{
			result = GTK_ORIENTATION_VERTICAL;
			return result;
		}
	}
}

static void
_icon_tasklist_applet_button_drag_data_get_gtk_widget_drag_data_get (GtkWidget* _sender,
                                                                     GdkDragContext* context,
                                                                     GtkSelectionData* selection_data,
                                                                     guint info,
                                                                     guint time_,
                                                                     gpointer self)
{
	icon_tasklist_applet_button_drag_data_get ((IconTasklistApplet*) self, _sender, context, selection_data, info, time_);
}

static void
_icon_tasklist_applet_button_drag_begin_gtk_widget_drag_begin (GtkWidget* _sender,
                                                               GdkDragContext* context,
                                                               gpointer self)
{
	icon_tasklist_applet_button_drag_begin ((IconTasklistApplet*) self, _sender, context);
}

static void
_icon_tasklist_applet_button_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                               GdkDragContext* context,
                                                                               gint x,
                                                                               gint y,
                                                                               GtkSelectionData* selection_data,
                                                                               guint info,
                                                                               guint time_,
                                                                               gpointer self)
{
	icon_tasklist_applet_button_drag_data_received ((IconTasklistApplet*) self, _sender, context, x, y, selection_data, info, time_);
}

static gboolean
_icon_tasklist_applet_button_drag_motion_gtk_widget_drag_motion (GtkWidget* _sender,
                                                                 GdkDragContext* context,
                                                                 gint x,
                                                                 gint y,
                                                                 guint time_,
                                                                 gpointer self)
{
	gboolean result;
	result = icon_tasklist_applet_button_drag_motion ((IconTasklistApplet*) self, _sender, context, x, y, time_);
	return result;
}

static gboolean
_icon_tasklist_applet_button_drag_drop_gtk_widget_drag_drop (GtkWidget* _sender,
                                                             GdkDragContext* context,
                                                             gint x,
                                                             gint y,
                                                             guint time_,
                                                             gpointer self)
{
	gboolean result;
	result = icon_tasklist_applet_button_drag_drop ((IconTasklistApplet*) self, _sender, context, x, y, time_);
	return result;
}

static void
_icon_tasklist_applet_button_drag_leave_gtk_widget_drag_leave (GtkWidget* _sender,
                                                               GdkDragContext* context,
                                                               guint time_,
                                                               gpointer self)
{
	icon_tasklist_applet_button_drag_leave ((IconTasklistApplet*) self, _sender, context, time_);
}

static void
icon_tasklist_applet_add_icon_button (IconTasklistApplet* self,
                                      const gchar* app_id,
                                      IconButton* button)
{
	ButtonWrapper* wrapper = NULL;
	ButtonWrapper* _tmp0_;
	GtkBox* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app_id != NULL);
	g_return_if_fail (button != NULL);
	icon_tasklist_applet_add_button (self, app_id, button);
	_tmp0_ = button_wrapper_new (button);
	g_object_ref_sink (_tmp0_);
	wrapper = _tmp0_;
	button_wrapper_set_orient (wrapper, icon_tasklist_applet_get_orientation (self));
	gtk_drag_dest_set ((GtkWidget*) button, 0, DRAG_TARGETS, (gint) G_N_ELEMENTS (DRAG_TARGETS), GDK_ACTION_MOVE);
	g_signal_connect_object ((GtkWidget*) button, "drag-data-get", (GCallback) _icon_tasklist_applet_button_drag_data_get_gtk_widget_drag_data_get, self, 0);
	g_signal_connect_object ((GtkWidget*) button, "drag-begin", (GCallback) _icon_tasklist_applet_button_drag_begin_gtk_widget_drag_begin, self, 0);
	g_signal_connect_object ((GtkWidget*) button, "drag-data-received", (GCallback) _icon_tasklist_applet_button_drag_data_received_gtk_widget_drag_data_received, self, 0);
	g_signal_connect_object ((GtkWidget*) button, "drag-motion", (GCallback) _icon_tasklist_applet_button_drag_motion_gtk_widget_drag_motion, self, 0);
	g_signal_connect_object ((GtkWidget*) button, "drag-drop", (GCallback) _icon_tasklist_applet_button_drag_drop_gtk_widget_drag_drop, self, 0);
	g_signal_connect_object ((GtkWidget*) button, "drag-leave", (GCallback) _icon_tasklist_applet_button_drag_leave_gtk_widget_drag_leave, self, 0);
	_tmp1_ = self->priv->main_layout;
	gtk_container_add ((GtkContainer*) _tmp1_, (GtkWidget*) wrapper);
	icon_tasklist_applet_update_button (self, button);
	_g_object_unref0 (wrapper);
}

static void
icon_tasklist_applet_on_pinned_changed (IconTasklistApplet* self,
                                        GObject* object,
                                        GParamSpec* pspec)
{
	IconButton* button = NULL;
	IconButton* _tmp0_;
	IconButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = _g_object_ref0 (IS_ICON_BUTTON (object) ? ((IconButton*) object) : NULL);
	button = _tmp0_;
	_tmp1_ = button;
	_tmp2_ = icon_button_get_pinned (_tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		BudgieWindowingWindowGroup* group = NULL;
		IconButton* _tmp4_;
		BudgieWindowingWindowGroup* _tmp5_;
		BudgieWindowingWindowGroup* _tmp6_;
		_tmp4_ = button;
		_tmp5_ = icon_button_get_window_group (_tmp4_);
		group = _tmp5_;
		_tmp6_ = group;
		if (_tmp6_ == NULL) {
			gchar* id = NULL;
			IconButton* _tmp7_;
			BudgieApplication* _tmp8_;
			BudgieApplication* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			IconButton* _tmp13_;
			GtkContainer* _tmp14_;
			const gchar* _tmp15_;
			_tmp7_ = button;
			_tmp8_ = icon_button_get_app (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = budgie_application_get_desktop_id (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strdup (_tmp11_);
			id = _tmp12_;
			_tmp13_ = button;
			_tmp14_ = gtk_widget_get_parent ((GtkWidget*) _tmp13_);
			button_wrapper_gracefully_die (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_BUTTON_WRAPPER, ButtonWrapper));
			_tmp15_ = id;
			icon_tasklist_applet_remove_button (self, _tmp15_);
			_g_free0 (id);
		}
		_g_object_unref0 (group);
	}
	icon_tasklist_applet_update_pinned_launchers (self);
	_g_object_unref0 (button);
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
icon_tasklist_applet_update_pinned_launchers (IconTasklistApplet* self)
{
	gchar** pinned = NULL;
	gchar** _tmp0_;
	gint pinned_length1;
	gint _pinned_size_;
	GtkBox* _tmp1_;
	GList* _tmp2_;
	GSettings* _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	pinned = _tmp0_;
	pinned_length1 = 0;
	_pinned_size_ = pinned_length1;
	_tmp1_ = self->priv->main_layout;
	_tmp2_ = gtk_container_get_children ((GtkContainer*) _tmp1_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp2_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				IconButton* child_button = NULL;
				GtkWidget* _tmp3_;
				IconButton* _tmp4_;
				IconButton* _tmp5_;
				IconButton* _tmp6_;
				IconButton* _tmp7_;
				gboolean _tmp8_;
				gboolean _tmp9_;
				_tmp3_ = child;
				_tmp4_ = button_wrapper_get_button (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_BUTTON_WRAPPER, ButtonWrapper));
				_tmp5_ = _tmp4_;
				_tmp6_ = _g_object_ref0 (_tmp5_);
				child_button = _tmp6_;
				_tmp7_ = child_button;
				_tmp8_ = icon_button_get_pinned (_tmp7_);
				_tmp9_ = _tmp8_;
				if (_tmp9_) {
					IconButton* _tmp10_;
					BudgieApplication* _tmp11_;
					BudgieApplication* _tmp12_;
					const gchar* _tmp13_;
					const gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp10_ = child_button;
					_tmp11_ = icon_button_get_app (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp13_ = budgie_application_get_desktop_id (_tmp12_);
					_tmp14_ = _tmp13_;
					_tmp15_ = g_strdup (_tmp14_);
					_vala_array_add1 (&pinned, &pinned_length1, &_pinned_size_, _tmp15_);
				}
				_g_object_unref0 (child_button);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	_tmp16_ = self->priv->settings;
	_tmp17_ = pinned;
	_tmp17__length1 = pinned_length1;
	g_settings_set_strv (_tmp16_, "pinned-launchers", _tmp17_);
	pinned = (_vala_array_free (pinned, pinned_length1, (GDestroyNotify) g_free), NULL);
}

static void
icon_tasklist_applet_update_button (IconTasklistApplet* self,
                                    IconButton* button)
{
	gboolean visible = FALSE;
	gboolean _tmp9_ = FALSE;
	GtkContainer* _tmp12_;
	GtkContainer* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	visible = TRUE;
	if (self->priv->restrict_to_workspace) {
		XfwWorkspace* workspace = NULL;
		BudgieWindowingWindowing* _tmp0_;
		XfwWorkspace* _tmp1_;
		XfwWorkspace* _tmp2_;
		_tmp0_ = self->priv->windowing;
		_tmp1_ = budgie_windowing_windowing_get_active_workspace (_tmp0_);
		workspace = _tmp1_;
		_tmp2_ = workspace;
		if (_tmp2_ != NULL) {
			BudgieWindowingWindowGroup* group = NULL;
			BudgieWindowingWindowGroup* _tmp3_;
			BudgieWindowingWindowGroup* _tmp4_;
			_tmp3_ = icon_button_get_window_group (button);
			group = _tmp3_;
			_tmp4_ = group;
			if (_tmp4_ != NULL) {
				BudgieWindowingWindowGroup* _tmp5_;
				XfwWorkspace* _tmp6_;
				_tmp5_ = group;
				_tmp6_ = workspace;
				visible = budgie_windowing_window_group_has_window_on_workspace (_tmp5_, _tmp6_);
			}
			_g_object_unref0 (group);
		}
		_g_object_unref0 (workspace);
	}
	if (self->priv->only_show_pinned) {
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp7_ = icon_button_get_pinned (button);
		_tmp8_ = _tmp7_;
		visible = _tmp8_;
	}
	if (self->priv->lock_icons) {
		gtk_drag_source_unset ((GtkWidget*) button);
	} else {
		gtk_drag_source_set ((GtkWidget*) button, GDK_BUTTON1_MASK, SOURCE_TARGET, (gint) G_N_ELEMENTS (SOURCE_TARGET), GDK_ACTION_MOVE);
	}
	if (visible) {
		_tmp9_ = TRUE;
	} else {
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp10_ = icon_button_get_pinned (button);
		_tmp11_ = _tmp10_;
		_tmp9_ = _tmp11_;
	}
	visible = _tmp9_;
	_tmp12_ = gtk_widget_get_parent ((GtkWidget*) button);
	button_wrapper_set_orient (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_BUTTON_WRAPPER, ButtonWrapper), icon_tasklist_applet_get_orientation (self));
	_tmp13_ = gtk_widget_get_parent ((GtkWidget*) button);
	gtk_revealer_set_reveal_child (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_revealer_get_type (), GtkRevealer), visible);
	icon_button_set_panel_size (button, self->priv->panel_size);
	icon_button_set_panel_position (button, self->priv->panel_position);
	icon_button_set_orientation (button, icon_tasklist_applet_get_orientation (self));
	icon_button_update (button);
}

/**
 * Ensure that we don't access the resource simultaneously when adding new buttons.
 */
static void
icon_tasklist_applet_add_button (IconTasklistApplet* self,
                                 const gchar* key,
                                 IconButton* button)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (button != NULL);
	{
		GHashTable* _tmp0_;
		_tmp0_ = self->priv->buttons;
		g_rec_mutex_lock (&self->priv->__lock_buttons);
		{
			GHashTable* _tmp1_;
			gchar* _tmp2_;
			IconButton* _tmp3_;
			_tmp1_ = self->priv->buttons;
			_tmp2_ = g_strdup (key);
			_tmp3_ = _g_object_ref0 (button);
			g_hash_table_insert (_tmp1_, _tmp2_, _tmp3_);
		}
		__finally0:
		{
			GHashTable* _tmp4_;
			_tmp4_ = self->priv->buttons;
			g_rec_mutex_unlock (&self->priv->__lock_buttons);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

/**
 * Ensure that we don't access the resource simultaneously when removing a button.
 */
static void
icon_tasklist_applet_remove_button (IconTasklistApplet* self,
                                    const gchar* key)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	{
		GHashTable* _tmp0_;
		_tmp0_ = self->priv->buttons;
		g_rec_mutex_lock (&self->priv->__lock_buttons);
		{
			GHashTable* _tmp1_;
			_tmp1_ = self->priv->buttons;
			g_hash_table_remove (_tmp1_, key);
		}
		__finally0:
		{
			GHashTable* _tmp2_;
			_tmp2_ = self->priv->buttons;
			g_rec_mutex_unlock (&self->priv->__lock_buttons);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

/**
 * Ensure that we don't access the resource simultaneously when swapping a button's key.
 */
static gpointer
_vala_g_hash_table_take (GHashTable* self,
                         gconstpointer key,
                         gboolean* exists)
{
	gboolean _vala_exists = FALSE;
	GHashTable* ht = NULL;
	void** htp = NULL;
	gconstpointer _tmp0_;
	gpointer result;
	g_return_val_if_fail (self != NULL, NULL);
	ht = NULL;
	htp = &ht;
	_tmp0_ = g_hash_table_lookup (self, key);
	*htp = _tmp0_;
	_vala_exists = g_hash_table_steal (self, key);
	result = ht;
	if (exists) {
		*exists = _vala_exists;
	}
	return result;
}

static void
icon_tasklist_applet_swap_button (IconTasklistApplet* self,
                                  const gchar* old_key,
                                  const gchar* new_key)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (old_key != NULL);
	g_return_if_fail (new_key != NULL);
	{
		GHashTable* _tmp0_;
		_tmp0_ = self->priv->buttons;
		g_rec_mutex_lock (&self->priv->__lock_buttons);
		{
			GHashTable* _tmp1_;
			gchar* _tmp2_;
			GHashTable* _tmp3_;
			gpointer _tmp4_;
			_tmp1_ = self->priv->buttons;
			_tmp2_ = g_strdup (new_key);
			_tmp3_ = self->priv->buttons;
			_tmp4_ = _vala_g_hash_table_take (_tmp3_, old_key, NULL);
			g_hash_table_insert (_tmp1_, _tmp2_, (IconButton*) _tmp4_);
		}
		__finally0:
		{
			GHashTable* _tmp5_;
			_tmp5_ = self->priv->buttons;
			g_rec_mutex_unlock (&self->priv->__lock_buttons);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

const gchar*
icon_tasklist_applet_get_uuid (IconTasklistApplet* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uuid;
	result = _tmp0_;
	return result;
}

void
icon_tasklist_applet_set_uuid (IconTasklistApplet* self,
                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = icon_tasklist_applet_get_uuid (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uuid);
		self->priv->_uuid = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, icon_tasklist_applet_properties[ICON_TASKLIST_APPLET_UUID_PROPERTY]);
	}
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static GObject *
icon_tasklist_applet_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	IconTasklistApplet * self;
	GtkStyleContext* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	GtkBox* _tmp4_;
	BudgieWindowingWindowing* _tmp5_;
	GtkBox* _tmp6_;
	parent_class = G_OBJECT_CLASS (icon_tasklist_applet_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ICON_TASKLIST_APPLET, IconTasklistApplet);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "icon-tasklist");
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->buttons);
	self->priv->buttons = _tmp3_;
	_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->main_layout);
	self->priv->main_layout = _tmp4_;
	_tmp5_ = budgie_windowing_windowing_new ();
	_g_object_unref0 (self->priv->windowing);
	self->priv->windowing = _tmp5_;
	_tmp6_ = self->priv->main_layout;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp6_);
	return obj;
}

static void
icon_tasklist_applet_class_init (IconTasklistAppletClass * klass,
                                 gpointer klass_data)
{
	icon_tasklist_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &IconTasklistApplet_private_offset);
	((BudgieAppletClass *) klass)->get_settings_ui = (GtkWidget* (*) (BudgieApplet*)) icon_tasklist_applet_real_get_settings_ui;
	((BudgieAppletClass *) klass)->supports_settings = (gboolean (*) (BudgieApplet*)) icon_tasklist_applet_real_supports_settings;
	((BudgieAppletClass *) klass)->panel_position_changed = (void (*) (BudgieApplet*, BudgiePanelPosition)) icon_tasklist_applet_real_panel_position_changed;
	((BudgieAppletClass *) klass)->panel_size_changed = (void (*) (BudgieApplet*, gint, gint, gint)) icon_tasklist_applet_real_panel_size_changed;
	((BudgieAppletClass *) klass)->update_popovers = (void (*) (BudgieApplet*, BudgiePopoverManager*)) icon_tasklist_applet_real_update_popovers;
	G_OBJECT_CLASS (klass)->get_property = _vala_icon_tasklist_applet_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_icon_tasklist_applet_set_property;
	G_OBJECT_CLASS (klass)->constructor = icon_tasklist_applet_constructor;
	G_OBJECT_CLASS (klass)->finalize = icon_tasklist_applet_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ICON_TASKLIST_APPLET_UUID_PROPERTY, icon_tasklist_applet_properties[ICON_TASKLIST_APPLET_UUID_PROPERTY] = g_param_spec_string ("uuid", "uuid", "uuid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
icon_tasklist_applet_instance_init (IconTasklistApplet * self,
                                    gpointer klass)
{
	self->priv = icon_tasklist_applet_get_instance_private (self);
	self->priv->lock_icons = FALSE;
	self->priv->restrict_to_workspace = FALSE;
	self->priv->only_show_pinned = FALSE;
	self->priv->icon_size = 0;
	self->priv->panel_size = 0;
	self->priv->panel_position = BUDGIE_PANEL_POSITION_BOTTOM;
	g_rec_mutex_init (&self->priv->__lock_buttons);
	self->priv->manager = NULL;
}

static void
icon_tasklist_applet_finalize (GObject * obj)
{
	IconTasklistApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ICON_TASKLIST_APPLET, IconTasklistApplet);
	_g_object_unref0 (self->priv->windowing);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->main_layout);
	g_rec_mutex_clear (&self->priv->__lock_buttons);
	_g_hash_table_unref0 (self->priv->buttons);
	_g_free0 (self->priv->_uuid);
	G_OBJECT_CLASS (icon_tasklist_applet_parent_class)->finalize (obj);
}

GType
icon_tasklist_applet_get_type (void)
{
	return icon_tasklist_applet_type_id;
}

GType
icon_tasklist_applet_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (IconTasklistAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) icon_tasklist_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IconTasklistApplet), 0, (GInstanceInitFunc) icon_tasklist_applet_instance_init, NULL };
	icon_tasklist_applet_type_id = g_type_module_register_type (module, budgie_applet_get_type (), "IconTasklistApplet", &g_define_type_info, 0);
	IconTasklistApplet_private_offset = sizeof (IconTasklistAppletPrivate);
	return icon_tasklist_applet_type_id;
}

static void
_vala_icon_tasklist_applet_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	IconTasklistApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ICON_TASKLIST_APPLET, IconTasklistApplet);
	switch (property_id) {
		case ICON_TASKLIST_APPLET_UUID_PROPERTY:
		g_value_set_string (value, icon_tasklist_applet_get_uuid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_icon_tasklist_applet_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	IconTasklistApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ICON_TASKLIST_APPLET, IconTasklistApplet);
	switch (property_id) {
		case ICON_TASKLIST_APPLET_UUID_PROPERTY:
		icon_tasklist_applet_set_uuid (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	icon_tasklist_register_type (module);
	icon_tasklist_settings_register_type (module);
	icon_tasklist_applet_register_type (module);
	icon_tasklist_button_popover_register_type (module);
	window_controls_register_type (module);
	window_item_register_type (module);
	button_wrapper_register_type (module);
	icon_register_type (module);
	icon_button_register_type (module);
	settings_remote_register_type (module);
	settings_remote_proxy_register_dynamic_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, budgie_plugin_get_type (), TYPE_ICON_TASKLIST);
	_g_object_unref0 (objmodule);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

