// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        (unknown)
// source: buf/alpha/registry/v1alpha1/repository_tag.proto

package registryv1alpha1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type RepositoryTag struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Id         string                 `protobuf:"bytes,1,opt,name=id,proto3"`
	xxx_hidden_CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3"`
	xxx_hidden_Name       string                 `protobuf:"bytes,4,opt,name=name,proto3"`
	xxx_hidden_CommitName string                 `protobuf:"bytes,5,opt,name=commit_name,json=commitName,proto3"`
	xxx_hidden_Author     string                 `protobuf:"bytes,6,opt,name=author,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *RepositoryTag) Reset() {
	*x = RepositoryTag{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_tag_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RepositoryTag) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RepositoryTag) ProtoMessage() {}

func (x *RepositoryTag) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_tag_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *RepositoryTag) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *RepositoryTag) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_CreateTime
	}
	return nil
}

func (x *RepositoryTag) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *RepositoryTag) GetCommitName() string {
	if x != nil {
		return x.xxx_hidden_CommitName
	}
	return ""
}

func (x *RepositoryTag) GetAuthor() string {
	if x != nil {
		return x.xxx_hidden_Author
	}
	return ""
}

func (x *RepositoryTag) SetId(v string) {
	x.xxx_hidden_Id = v
}

func (x *RepositoryTag) SetCreateTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_CreateTime = v
}

func (x *RepositoryTag) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *RepositoryTag) SetCommitName(v string) {
	x.xxx_hidden_CommitName = v
}

func (x *RepositoryTag) SetAuthor(v string) {
	x.xxx_hidden_Author = v
}

func (x *RepositoryTag) HasCreateTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_CreateTime != nil
}

func (x *RepositoryTag) ClearCreateTime() {
	x.xxx_hidden_CreateTime = nil
}

type RepositoryTag_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// primary key, unique.
	// tags are based on labels, so if a label has been moved, the ID will point to the
	// updated entry in the labels table.
	Id string
	// immutable
	CreateTime *timestamppb.Timestamp
	// We reserve field number '3' for the update_time.
	// google.protobuf.Timestamp update_time = 3;
	// The name of the repository tag, e.g. "6e2e7f24718a76caa32a80d0e2b1841ef2c61403".
	Name string
	// The name of the commit this tag belongs to.
	CommitName string
	// The username of the author of the tag.
	Author string
}

func (b0 RepositoryTag_builder) Build() *RepositoryTag {
	m0 := &RepositoryTag{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Id = b.Id
	x.xxx_hidden_CreateTime = b.CreateTime
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_CommitName = b.CommitName
	x.xxx_hidden_Author = b.Author
	return m0
}

type GetRepositoryTagRequest struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId string                 `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_Name         string                 `protobuf:"bytes,2,opt,name=name,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *GetRepositoryTagRequest) Reset() {
	*x = GetRepositoryTagRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_tag_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepositoryTagRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositoryTagRequest) ProtoMessage() {}

func (x *GetRepositoryTagRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_tag_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRepositoryTagRequest) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *GetRepositoryTagRequest) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *GetRepositoryTagRequest) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *GetRepositoryTagRequest) SetName(v string) {
	x.xxx_hidden_Name = v
}

type GetRepositoryTagRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the repository this tag belongs to.
	RepositoryId string
	// The name of the repository tag to get, e.g. "6e2e7f24718a76caa32a80d0e2b1841ef2c61403".
	Name string
}

func (b0 GetRepositoryTagRequest_builder) Build() *GetRepositoryTagRequest {
	m0 := &GetRepositoryTagRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_Name = b.Name
	return m0
}

type GetRepositoryTagResponse struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryTag *RepositoryTag         `protobuf:"bytes,1,opt,name=repository_tag,json=repositoryTag,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *GetRepositoryTagResponse) Reset() {
	*x = GetRepositoryTagResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_tag_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepositoryTagResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositoryTagResponse) ProtoMessage() {}

func (x *GetRepositoryTagResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_tag_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRepositoryTagResponse) GetRepositoryTag() *RepositoryTag {
	if x != nil {
		return x.xxx_hidden_RepositoryTag
	}
	return nil
}

func (x *GetRepositoryTagResponse) SetRepositoryTag(v *RepositoryTag) {
	x.xxx_hidden_RepositoryTag = v
}

func (x *GetRepositoryTagResponse) HasRepositoryTag() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_RepositoryTag != nil
}

func (x *GetRepositoryTagResponse) ClearRepositoryTag() {
	x.xxx_hidden_RepositoryTag = nil
}

type GetRepositoryTagResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	RepositoryTag *RepositoryTag
}

func (b0 GetRepositoryTagResponse_builder) Build() *GetRepositoryTagResponse {
	m0 := &GetRepositoryTagResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryTag = b.RepositoryTag
	return m0
}

type CreateRepositoryTagRequest struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId string                 `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_Name         string                 `protobuf:"bytes,2,opt,name=name,proto3"`
	xxx_hidden_CommitName   string                 `protobuf:"bytes,3,opt,name=commit_name,json=commitName,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *CreateRepositoryTagRequest) Reset() {
	*x = CreateRepositoryTagRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_tag_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateRepositoryTagRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRepositoryTagRequest) ProtoMessage() {}

func (x *CreateRepositoryTagRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_tag_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreateRepositoryTagRequest) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *CreateRepositoryTagRequest) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *CreateRepositoryTagRequest) GetCommitName() string {
	if x != nil {
		return x.xxx_hidden_CommitName
	}
	return ""
}

func (x *CreateRepositoryTagRequest) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *CreateRepositoryTagRequest) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *CreateRepositoryTagRequest) SetCommitName(v string) {
	x.xxx_hidden_CommitName = v
}

type CreateRepositoryTagRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the repository this tag should be created on.
	RepositoryId string
	// The name of the repository tag, e.g. "6e2e7f24718a76caa32a80d0e2b1841ef2c61403".
	Name string
	// The name of the commit this tag should be created for.
	CommitName string
}

func (b0 CreateRepositoryTagRequest_builder) Build() *CreateRepositoryTagRequest {
	m0 := &CreateRepositoryTagRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_CommitName = b.CommitName
	return m0
}

type CreateRepositoryTagResponse struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryTag *RepositoryTag         `protobuf:"bytes,1,opt,name=repository_tag,json=repositoryTag,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *CreateRepositoryTagResponse) Reset() {
	*x = CreateRepositoryTagResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_tag_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateRepositoryTagResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRepositoryTagResponse) ProtoMessage() {}

func (x *CreateRepositoryTagResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_tag_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreateRepositoryTagResponse) GetRepositoryTag() *RepositoryTag {
	if x != nil {
		return x.xxx_hidden_RepositoryTag
	}
	return nil
}

func (x *CreateRepositoryTagResponse) SetRepositoryTag(v *RepositoryTag) {
	x.xxx_hidden_RepositoryTag = v
}

func (x *CreateRepositoryTagResponse) HasRepositoryTag() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_RepositoryTag != nil
}

func (x *CreateRepositoryTagResponse) ClearRepositoryTag() {
	x.xxx_hidden_RepositoryTag = nil
}

type CreateRepositoryTagResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	RepositoryTag *RepositoryTag
}

func (b0 CreateRepositoryTagResponse_builder) Build() *CreateRepositoryTagResponse {
	m0 := &CreateRepositoryTagResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryTag = b.RepositoryTag
	return m0
}

type UpdateRepositoryTagRequest struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId string                 `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_Name         string                 `protobuf:"bytes,2,opt,name=name,proto3"`
	xxx_hidden_CommitName   *string                `protobuf:"bytes,3,opt,name=commit_name,json=commitName,proto3,oneof"`
	XXX_raceDetectHookData  protoimpl.RaceDetectHookData
	XXX_presence            [1]uint32
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *UpdateRepositoryTagRequest) Reset() {
	*x = UpdateRepositoryTagRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_tag_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateRepositoryTagRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRepositoryTagRequest) ProtoMessage() {}

func (x *UpdateRepositoryTagRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_tag_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UpdateRepositoryTagRequest) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *UpdateRepositoryTagRequest) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *UpdateRepositoryTagRequest) GetCommitName() string {
	if x != nil {
		if x.xxx_hidden_CommitName != nil {
			return *x.xxx_hidden_CommitName
		}
		return ""
	}
	return ""
}

func (x *UpdateRepositoryTagRequest) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *UpdateRepositoryTagRequest) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *UpdateRepositoryTagRequest) SetCommitName(v string) {
	x.xxx_hidden_CommitName = &v
	protoimpl.X.SetPresent(&(x.XXX_presence[0]), 2, 3)
}

func (x *UpdateRepositoryTagRequest) HasCommitName() bool {
	if x == nil {
		return false
	}
	return protoimpl.X.Present(&(x.XXX_presence[0]), 2)
}

func (x *UpdateRepositoryTagRequest) ClearCommitName() {
	protoimpl.X.ClearPresent(&(x.XXX_presence[0]), 2)
	x.xxx_hidden_CommitName = nil
}

type UpdateRepositoryTagRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the repository this tag belongs to.
	RepositoryId string
	// The name of the repository tag, to update e.g. "6e2e7f24718a76caa32a80d0e2b1841ef2c61403".
	Name string
	// The name of the commit this tag should reference.
	CommitName *string
}

func (b0 UpdateRepositoryTagRequest_builder) Build() *UpdateRepositoryTagRequest {
	m0 := &UpdateRepositoryTagRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_Name = b.Name
	if b.CommitName != nil {
		protoimpl.X.SetPresentNonAtomic(&(x.XXX_presence[0]), 2, 3)
		x.xxx_hidden_CommitName = b.CommitName
	}
	return m0
}

type UpdateRepositoryTagResponse struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryTag *RepositoryTag         `protobuf:"bytes,1,opt,name=repository_tag,json=repositoryTag,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *UpdateRepositoryTagResponse) Reset() {
	*x = UpdateRepositoryTagResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_tag_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateRepositoryTagResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRepositoryTagResponse) ProtoMessage() {}

func (x *UpdateRepositoryTagResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_tag_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UpdateRepositoryTagResponse) GetRepositoryTag() *RepositoryTag {
	if x != nil {
		return x.xxx_hidden_RepositoryTag
	}
	return nil
}

func (x *UpdateRepositoryTagResponse) SetRepositoryTag(v *RepositoryTag) {
	x.xxx_hidden_RepositoryTag = v
}

func (x *UpdateRepositoryTagResponse) HasRepositoryTag() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_RepositoryTag != nil
}

func (x *UpdateRepositoryTagResponse) ClearRepositoryTag() {
	x.xxx_hidden_RepositoryTag = nil
}

type UpdateRepositoryTagResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	RepositoryTag *RepositoryTag
}

func (b0 UpdateRepositoryTagResponse_builder) Build() *UpdateRepositoryTagResponse {
	m0 := &UpdateRepositoryTagResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryTag = b.RepositoryTag
	return m0
}

type ListRepositoryTagsRequest struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId string                 `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_PageSize     uint32                 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken    string                 `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_Reverse      bool                   `protobuf:"varint,4,opt,name=reverse,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *ListRepositoryTagsRequest) Reset() {
	*x = ListRepositoryTagsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_tag_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRepositoryTagsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRepositoryTagsRequest) ProtoMessage() {}

func (x *ListRepositoryTagsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_tag_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListRepositoryTagsRequest) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *ListRepositoryTagsRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *ListRepositoryTagsRequest) GetPageToken() string {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return ""
}

func (x *ListRepositoryTagsRequest) GetReverse() bool {
	if x != nil {
		return x.xxx_hidden_Reverse
	}
	return false
}

func (x *ListRepositoryTagsRequest) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *ListRepositoryTagsRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *ListRepositoryTagsRequest) SetPageToken(v string) {
	x.xxx_hidden_PageToken = v
}

func (x *ListRepositoryTagsRequest) SetReverse(v bool) {
	x.xxx_hidden_Reverse = v
}

type ListRepositoryTagsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the repository whose tags should be listed.
	RepositoryId string
	PageSize     uint32
	// The first page is returned if this is empty.
	PageToken string
	Reverse   bool
}

func (b0 ListRepositoryTagsRequest_builder) Build() *ListRepositoryTagsRequest {
	m0 := &ListRepositoryTagsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	x.xxx_hidden_Reverse = b.Reverse
	return m0
}

type ListRepositoryTagsResponse struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryTags *[]*RepositoryTag      `protobuf:"bytes,1,rep,name=repository_tags,json=repositoryTags,proto3"`
	xxx_hidden_NextPageToken  string                 `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *ListRepositoryTagsResponse) Reset() {
	*x = ListRepositoryTagsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_tag_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRepositoryTagsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRepositoryTagsResponse) ProtoMessage() {}

func (x *ListRepositoryTagsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_tag_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListRepositoryTagsResponse) GetRepositoryTags() []*RepositoryTag {
	if x != nil {
		if x.xxx_hidden_RepositoryTags != nil {
			return *x.xxx_hidden_RepositoryTags
		}
	}
	return nil
}

func (x *ListRepositoryTagsResponse) GetNextPageToken() string {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return ""
}

func (x *ListRepositoryTagsResponse) SetRepositoryTags(v []*RepositoryTag) {
	x.xxx_hidden_RepositoryTags = &v
}

func (x *ListRepositoryTagsResponse) SetNextPageToken(v string) {
	x.xxx_hidden_NextPageToken = v
}

type ListRepositoryTagsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	RepositoryTags []*RepositoryTag
	// There are no more pages if this is empty.
	NextPageToken string
}

func (b0 ListRepositoryTagsResponse_builder) Build() *ListRepositoryTagsResponse {
	m0 := &ListRepositoryTagsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryTags = &b.RepositoryTags
	x.xxx_hidden_NextPageToken = b.NextPageToken
	return m0
}

type ListRepositoryTagsForReferenceRequest struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId string                 `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_Reference    string                 `protobuf:"bytes,2,opt,name=reference,proto3"`
	xxx_hidden_PageSize     uint32                 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken    string                 `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_Reverse      bool                   `protobuf:"varint,5,opt,name=reverse,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *ListRepositoryTagsForReferenceRequest) Reset() {
	*x = ListRepositoryTagsForReferenceRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_tag_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRepositoryTagsForReferenceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRepositoryTagsForReferenceRequest) ProtoMessage() {}

func (x *ListRepositoryTagsForReferenceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_tag_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListRepositoryTagsForReferenceRequest) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *ListRepositoryTagsForReferenceRequest) GetReference() string {
	if x != nil {
		return x.xxx_hidden_Reference
	}
	return ""
}

func (x *ListRepositoryTagsForReferenceRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *ListRepositoryTagsForReferenceRequest) GetPageToken() string {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return ""
}

func (x *ListRepositoryTagsForReferenceRequest) GetReverse() bool {
	if x != nil {
		return x.xxx_hidden_Reverse
	}
	return false
}

func (x *ListRepositoryTagsForReferenceRequest) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *ListRepositoryTagsForReferenceRequest) SetReference(v string) {
	x.xxx_hidden_Reference = v
}

func (x *ListRepositoryTagsForReferenceRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *ListRepositoryTagsForReferenceRequest) SetPageToken(v string) {
	x.xxx_hidden_PageToken = v
}

func (x *ListRepositoryTagsForReferenceRequest) SetReverse(v bool) {
	x.xxx_hidden_Reverse = v
}

type ListRepositoryTagsForReferenceRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the repository whose tags should be listed.
	RepositoryId string
	// Optional reference (if unspecified, will use the repository's default_branch).
	Reference string
	PageSize  uint32
	// The first page is returned if this is empty.
	PageToken string
	Reverse   bool
}

func (b0 ListRepositoryTagsForReferenceRequest_builder) Build() *ListRepositoryTagsForReferenceRequest {
	m0 := &ListRepositoryTagsForReferenceRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_Reference = b.Reference
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	x.xxx_hidden_Reverse = b.Reverse
	return m0
}

type ListRepositoryTagsForReferenceResponse struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryTags *[]*RepositoryTag      `protobuf:"bytes,1,rep,name=repository_tags,json=repositoryTags,proto3"`
	xxx_hidden_NextPageToken  string                 `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *ListRepositoryTagsForReferenceResponse) Reset() {
	*x = ListRepositoryTagsForReferenceResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_tag_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRepositoryTagsForReferenceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRepositoryTagsForReferenceResponse) ProtoMessage() {}

func (x *ListRepositoryTagsForReferenceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_tag_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListRepositoryTagsForReferenceResponse) GetRepositoryTags() []*RepositoryTag {
	if x != nil {
		if x.xxx_hidden_RepositoryTags != nil {
			return *x.xxx_hidden_RepositoryTags
		}
	}
	return nil
}

func (x *ListRepositoryTagsForReferenceResponse) GetNextPageToken() string {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return ""
}

func (x *ListRepositoryTagsForReferenceResponse) SetRepositoryTags(v []*RepositoryTag) {
	x.xxx_hidden_RepositoryTags = &v
}

func (x *ListRepositoryTagsForReferenceResponse) SetNextPageToken(v string) {
	x.xxx_hidden_NextPageToken = v
}

type ListRepositoryTagsForReferenceResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	RepositoryTags []*RepositoryTag
	// There are no more pages if this is empty.
	NextPageToken string
}

func (b0 ListRepositoryTagsForReferenceResponse_builder) Build() *ListRepositoryTagsForReferenceResponse {
	m0 := &ListRepositoryTagsForReferenceResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryTags = &b.RepositoryTags
	x.xxx_hidden_NextPageToken = b.NextPageToken
	return m0
}

var File_buf_alpha_registry_v1alpha1_repository_tag_proto protoreflect.FileDescriptor

const file_buf_alpha_registry_v1alpha1_repository_tag_proto_rawDesc = "" +
	"\n" +
	"0buf/alpha/registry/v1alpha1/repository_tag.proto\x12\x1bbuf.alpha.registry.v1alpha1\x1a\x1fgoogle/protobuf/timestamp.proto\"\xa9\x01\n" +
	"\rRepositoryTag\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12;\n" +
	"\vcreate_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"createTime\x12\x12\n" +
	"\x04name\x18\x04 \x01(\tR\x04name\x12\x1f\n" +
	"\vcommit_name\x18\x05 \x01(\tR\n" +
	"commitName\x12\x16\n" +
	"\x06author\x18\x06 \x01(\tR\x06author\"R\n" +
	"\x17GetRepositoryTagRequest\x12#\n" +
	"\rrepository_id\x18\x01 \x01(\tR\frepositoryId\x12\x12\n" +
	"\x04name\x18\x02 \x01(\tR\x04name\"m\n" +
	"\x18GetRepositoryTagResponse\x12Q\n" +
	"\x0erepository_tag\x18\x01 \x01(\v2*.buf.alpha.registry.v1alpha1.RepositoryTagR\rrepositoryTag\"v\n" +
	"\x1aCreateRepositoryTagRequest\x12#\n" +
	"\rrepository_id\x18\x01 \x01(\tR\frepositoryId\x12\x12\n" +
	"\x04name\x18\x02 \x01(\tR\x04name\x12\x1f\n" +
	"\vcommit_name\x18\x03 \x01(\tR\n" +
	"commitName\"p\n" +
	"\x1bCreateRepositoryTagResponse\x12Q\n" +
	"\x0erepository_tag\x18\x01 \x01(\v2*.buf.alpha.registry.v1alpha1.RepositoryTagR\rrepositoryTag\"\x8b\x01\n" +
	"\x1aUpdateRepositoryTagRequest\x12#\n" +
	"\rrepository_id\x18\x01 \x01(\tR\frepositoryId\x12\x12\n" +
	"\x04name\x18\x02 \x01(\tR\x04name\x12$\n" +
	"\vcommit_name\x18\x03 \x01(\tH\x00R\n" +
	"commitName\x88\x01\x01B\x0e\n" +
	"\f_commit_name\"p\n" +
	"\x1bUpdateRepositoryTagResponse\x12Q\n" +
	"\x0erepository_tag\x18\x01 \x01(\v2*.buf.alpha.registry.v1alpha1.RepositoryTagR\rrepositoryTag\"\x96\x01\n" +
	"\x19ListRepositoryTagsRequest\x12#\n" +
	"\rrepository_id\x18\x01 \x01(\tR\frepositoryId\x12\x1b\n" +
	"\tpage_size\x18\x02 \x01(\rR\bpageSize\x12\x1d\n" +
	"\n" +
	"page_token\x18\x03 \x01(\tR\tpageToken\x12\x18\n" +
	"\areverse\x18\x04 \x01(\bR\areverse\"\x99\x01\n" +
	"\x1aListRepositoryTagsResponse\x12S\n" +
	"\x0frepository_tags\x18\x01 \x03(\v2*.buf.alpha.registry.v1alpha1.RepositoryTagR\x0erepositoryTags\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"\xc0\x01\n" +
	"%ListRepositoryTagsForReferenceRequest\x12#\n" +
	"\rrepository_id\x18\x01 \x01(\tR\frepositoryId\x12\x1c\n" +
	"\treference\x18\x02 \x01(\tR\treference\x12\x1b\n" +
	"\tpage_size\x18\x03 \x01(\rR\bpageSize\x12\x1d\n" +
	"\n" +
	"page_token\x18\x04 \x01(\tR\tpageToken\x12\x18\n" +
	"\areverse\x18\x05 \x01(\bR\areverse\"\xa5\x01\n" +
	"&ListRepositoryTagsForReferenceResponse\x12S\n" +
	"\x0frepository_tags\x18\x01 \x03(\v2*.buf.alpha.registry.v1alpha1.RepositoryTagR\x0erepositoryTags\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken2\xfb\x05\n" +
	"\x14RepositoryTagService\x12\x84\x01\n" +
	"\x10GetRepositoryTag\x124.buf.alpha.registry.v1alpha1.GetRepositoryTagRequest\x1a5.buf.alpha.registry.v1alpha1.GetRepositoryTagResponse\"\x03\x90\x02\x02\x12\x8d\x01\n" +
	"\x13CreateRepositoryTag\x127.buf.alpha.registry.v1alpha1.CreateRepositoryTagRequest\x1a8.buf.alpha.registry.v1alpha1.CreateRepositoryTagResponse\"\x03\x90\x02\x02\x12\x8d\x01\n" +
	"\x13UpdateRepositoryTag\x127.buf.alpha.registry.v1alpha1.UpdateRepositoryTagRequest\x1a8.buf.alpha.registry.v1alpha1.UpdateRepositoryTagResponse\"\x03\x90\x02\x02\x12\x8a\x01\n" +
	"\x12ListRepositoryTags\x126.buf.alpha.registry.v1alpha1.ListRepositoryTagsRequest\x1a7.buf.alpha.registry.v1alpha1.ListRepositoryTagsResponse\"\x03\x90\x02\x01\x12\xae\x01\n" +
	"\x1eListRepositoryTagsForReference\x12B.buf.alpha.registry.v1alpha1.ListRepositoryTagsForReferenceRequest\x1aC.buf.alpha.registry.v1alpha1.ListRepositoryTagsForReferenceResponse\"\x03\x90\x02\x01B\x9f\x02\n" +
	"\x1fcom.buf.alpha.registry.v1alpha1B\x12RepositoryTagProtoP\x01ZYgithub.com/bufbuild/buf/private/gen/proto/go/buf/alpha/registry/v1alpha1;registryv1alpha1\xa2\x02\x03BAR\xaa\x02\x1bBuf.Alpha.Registry.V1alpha1\xca\x02\x1bBuf\\Alpha\\Registry\\V1alpha1\xe2\x02'Buf\\Alpha\\Registry\\V1alpha1\\GPBMetadata\xea\x02\x1eBuf::Alpha::Registry::V1alpha1b\x06proto3"

var file_buf_alpha_registry_v1alpha1_repository_tag_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_buf_alpha_registry_v1alpha1_repository_tag_proto_goTypes = []any{
	(*RepositoryTag)(nil),                          // 0: buf.alpha.registry.v1alpha1.RepositoryTag
	(*GetRepositoryTagRequest)(nil),                // 1: buf.alpha.registry.v1alpha1.GetRepositoryTagRequest
	(*GetRepositoryTagResponse)(nil),               // 2: buf.alpha.registry.v1alpha1.GetRepositoryTagResponse
	(*CreateRepositoryTagRequest)(nil),             // 3: buf.alpha.registry.v1alpha1.CreateRepositoryTagRequest
	(*CreateRepositoryTagResponse)(nil),            // 4: buf.alpha.registry.v1alpha1.CreateRepositoryTagResponse
	(*UpdateRepositoryTagRequest)(nil),             // 5: buf.alpha.registry.v1alpha1.UpdateRepositoryTagRequest
	(*UpdateRepositoryTagResponse)(nil),            // 6: buf.alpha.registry.v1alpha1.UpdateRepositoryTagResponse
	(*ListRepositoryTagsRequest)(nil),              // 7: buf.alpha.registry.v1alpha1.ListRepositoryTagsRequest
	(*ListRepositoryTagsResponse)(nil),             // 8: buf.alpha.registry.v1alpha1.ListRepositoryTagsResponse
	(*ListRepositoryTagsForReferenceRequest)(nil),  // 9: buf.alpha.registry.v1alpha1.ListRepositoryTagsForReferenceRequest
	(*ListRepositoryTagsForReferenceResponse)(nil), // 10: buf.alpha.registry.v1alpha1.ListRepositoryTagsForReferenceResponse
	(*timestamppb.Timestamp)(nil),                  // 11: google.protobuf.Timestamp
}
var file_buf_alpha_registry_v1alpha1_repository_tag_proto_depIdxs = []int32{
	11, // 0: buf.alpha.registry.v1alpha1.RepositoryTag.create_time:type_name -> google.protobuf.Timestamp
	0,  // 1: buf.alpha.registry.v1alpha1.GetRepositoryTagResponse.repository_tag:type_name -> buf.alpha.registry.v1alpha1.RepositoryTag
	0,  // 2: buf.alpha.registry.v1alpha1.CreateRepositoryTagResponse.repository_tag:type_name -> buf.alpha.registry.v1alpha1.RepositoryTag
	0,  // 3: buf.alpha.registry.v1alpha1.UpdateRepositoryTagResponse.repository_tag:type_name -> buf.alpha.registry.v1alpha1.RepositoryTag
	0,  // 4: buf.alpha.registry.v1alpha1.ListRepositoryTagsResponse.repository_tags:type_name -> buf.alpha.registry.v1alpha1.RepositoryTag
	0,  // 5: buf.alpha.registry.v1alpha1.ListRepositoryTagsForReferenceResponse.repository_tags:type_name -> buf.alpha.registry.v1alpha1.RepositoryTag
	1,  // 6: buf.alpha.registry.v1alpha1.RepositoryTagService.GetRepositoryTag:input_type -> buf.alpha.registry.v1alpha1.GetRepositoryTagRequest
	3,  // 7: buf.alpha.registry.v1alpha1.RepositoryTagService.CreateRepositoryTag:input_type -> buf.alpha.registry.v1alpha1.CreateRepositoryTagRequest
	5,  // 8: buf.alpha.registry.v1alpha1.RepositoryTagService.UpdateRepositoryTag:input_type -> buf.alpha.registry.v1alpha1.UpdateRepositoryTagRequest
	7,  // 9: buf.alpha.registry.v1alpha1.RepositoryTagService.ListRepositoryTags:input_type -> buf.alpha.registry.v1alpha1.ListRepositoryTagsRequest
	9,  // 10: buf.alpha.registry.v1alpha1.RepositoryTagService.ListRepositoryTagsForReference:input_type -> buf.alpha.registry.v1alpha1.ListRepositoryTagsForReferenceRequest
	2,  // 11: buf.alpha.registry.v1alpha1.RepositoryTagService.GetRepositoryTag:output_type -> buf.alpha.registry.v1alpha1.GetRepositoryTagResponse
	4,  // 12: buf.alpha.registry.v1alpha1.RepositoryTagService.CreateRepositoryTag:output_type -> buf.alpha.registry.v1alpha1.CreateRepositoryTagResponse
	6,  // 13: buf.alpha.registry.v1alpha1.RepositoryTagService.UpdateRepositoryTag:output_type -> buf.alpha.registry.v1alpha1.UpdateRepositoryTagResponse
	8,  // 14: buf.alpha.registry.v1alpha1.RepositoryTagService.ListRepositoryTags:output_type -> buf.alpha.registry.v1alpha1.ListRepositoryTagsResponse
	10, // 15: buf.alpha.registry.v1alpha1.RepositoryTagService.ListRepositoryTagsForReference:output_type -> buf.alpha.registry.v1alpha1.ListRepositoryTagsForReferenceResponse
	11, // [11:16] is the sub-list for method output_type
	6,  // [6:11] is the sub-list for method input_type
	6,  // [6:6] is the sub-list for extension type_name
	6,  // [6:6] is the sub-list for extension extendee
	0,  // [0:6] is the sub-list for field type_name
}

func init() { file_buf_alpha_registry_v1alpha1_repository_tag_proto_init() }
func file_buf_alpha_registry_v1alpha1_repository_tag_proto_init() {
	if File_buf_alpha_registry_v1alpha1_repository_tag_proto != nil {
		return
	}
	file_buf_alpha_registry_v1alpha1_repository_tag_proto_msgTypes[5].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_alpha_registry_v1alpha1_repository_tag_proto_rawDesc), len(file_buf_alpha_registry_v1alpha1_repository_tag_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_alpha_registry_v1alpha1_repository_tag_proto_goTypes,
		DependencyIndexes: file_buf_alpha_registry_v1alpha1_repository_tag_proto_depIdxs,
		MessageInfos:      file_buf_alpha_registry_v1alpha1_repository_tag_proto_msgTypes,
	}.Build()
	File_buf_alpha_registry_v1alpha1_repository_tag_proto = out.File
	file_buf_alpha_registry_v1alpha1_repository_tag_proto_goTypes = nil
	file_buf_alpha_registry_v1alpha1_repository_tag_proto_depIdxs = nil
}
