
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "downloaditem_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_DownloadItem_Type = nullptr;
static PyTypeObject *Sbk_DownloadItem_TypeF(void)
{
    return _Sbk_DownloadItem_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void DownloadItemWrapper::pysideInitQtMetaTypes()
{
}

void DownloadItemWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

DownloadItemWrapper::DownloadItemWrapper(::QListWidgetItem * item, ::QWebEngineDownloadRequest * downloadItem, const ::QString & path, const ::QString & fileName, bool openFile, ::DownloadManager * manager) : DownloadItem(item, downloadItem, path, fileName, openFile, manager)
{
}

void DownloadItemWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    WebViewWrapper::sbk_o_actionEvent("DownloadItem", funcName, gil, pyOverride, event);
}

void DownloadItemWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    WebViewWrapper::sbk_o_changeEvent("DownloadItem", funcName, gil, pyOverride, event);
}

void DownloadItemWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("DownloadItem", funcName, gil, pyOverride, event);
}

void DownloadItemWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    WebViewWrapper::sbk_o_closeEvent("DownloadItem", funcName, gil, pyOverride, event);
}

void DownloadItemWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("DownloadItem", funcName, gil, pyOverride, signal);
}

void DownloadItemWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    WebViewWrapper::sbk_o_contextMenuEvent("DownloadItem", funcName, gil, pyOverride, event);
}

void DownloadItemWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("DownloadItem", funcName, gil, pyOverride, event);
}

int DownloadItemWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return WebViewWrapper::sbk_o_devType("DownloadItem", funcName, gil, pyOverride);
}

void DownloadItemWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("DownloadItem", funcName, gil, pyOverride, signal);
}

void DownloadItemWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    WebViewWrapper::sbk_o_dragEnterEvent("DownloadItem", funcName, gil, pyOverride, event);
}

void DownloadItemWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    WebViewWrapper::sbk_o_dragLeaveEvent("DownloadItem", funcName, gil, pyOverride, event);
}

void DownloadItemWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    WebViewWrapper::sbk_o_dragMoveEvent("DownloadItem", funcName, gil, pyOverride, event);
}

void DownloadItemWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    WebViewWrapper::sbk_o_dropEvent("DownloadItem", funcName, gil, pyOverride, event);
}

void DownloadItemWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    WebViewWrapper::sbk_o_enterEvent("DownloadItem", funcName, gil, pyOverride, event);
}

bool DownloadItemWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::event(event);
    }
    return WebViewWrapper::sbk_o_event("DownloadItem", funcName, gil, pyOverride, event);
}

bool DownloadItemWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("DownloadItem", funcName, gil, pyOverride, watched, event);
}

void DownloadItemWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    WebViewWrapper::sbk_o_focusInEvent("DownloadItem", funcName, gil, pyOverride, event);
}

bool DownloadItemWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return WebViewWrapper::sbk_o_focusNextPrevChild("DownloadItem", funcName, gil, pyOverride, next);
}

void DownloadItemWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    WebViewWrapper::sbk_o_focusOutEvent("DownloadItem", funcName, gil, pyOverride, event);
}

bool DownloadItemWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return WebViewWrapper::sbk_o_hasHeightForWidth("DownloadItem", funcName, gil, pyOverride);
}

int DownloadItemWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return WebViewWrapper::sbk_o_heightForWidth("DownloadItem", funcName, gil, pyOverride, arg__1);
}

void DownloadItemWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    WebViewWrapper::sbk_o_hideEvent("DownloadItem", funcName, gil, pyOverride, event);
}

void DownloadItemWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    WebViewWrapper::sbk_o_initPainter("DownloadItem", funcName, gil, pyOverride, painter);
}

void DownloadItemWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    WebViewWrapper::sbk_o_inputMethodEvent("DownloadItem", funcName, gil, pyOverride, event);
}

::QVariant DownloadItemWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return WebViewWrapper::sbk_o_inputMethodQuery("DownloadItem", funcName, gil, pyOverride, arg__1);
}

void DownloadItemWrapper::keyPressEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyPressEvent(event);
    }
    WebViewWrapper::sbk_o_keyPressEvent("DownloadItem", funcName, gil, pyOverride, event);
}

void DownloadItemWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    WebViewWrapper::sbk_o_keyReleaseEvent("DownloadItem", funcName, gil, pyOverride, event);
}

void DownloadItemWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    WebViewWrapper::sbk_o_leaveEvent("DownloadItem", funcName, gil, pyOverride, event);
}

int DownloadItemWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return WebViewWrapper::sbk_o_metric("DownloadItem", funcName, gil, pyOverride, arg__1);
}

::QSize DownloadItemWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("DownloadItem", funcName, gil, pyOverride);
}

void DownloadItemWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    WebViewWrapper::sbk_o_mouseMoveEvent("DownloadItem", funcName, gil, pyOverride, event);
}

void DownloadItemWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    WebViewWrapper::sbk_o_mousePressEvent("DownloadItem", funcName, gil, pyOverride, event);
}

void DownloadItemWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    WebViewWrapper::sbk_o_mouseReleaseEvent("DownloadItem", funcName, gil, pyOverride, event);
}

void DownloadItemWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    WebViewWrapper::sbk_o_moveEvent("DownloadItem", funcName, gil, pyOverride, event);
}

bool DownloadItemWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return WebViewWrapper::sbk_o_nativeEvent("DownloadItem", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * DownloadItemWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return WebViewWrapper::sbk_o_paintEngine("DownloadItem", funcName, gil, pyOverride);
}

void DownloadItemWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEvent(event);
    }
    WebViewWrapper::sbk_o_paintEvent("DownloadItem", funcName, gil, pyOverride, event);
}

::QPaintDevice * DownloadItemWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return WebViewWrapper::sbk_o_redirected("DownloadItem", funcName, gil, pyOverride, offset);
}

void DownloadItemWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    WebViewWrapper::sbk_o_resizeEvent("DownloadItem", funcName, gil, pyOverride, event);
}

void DownloadItemWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    WebViewWrapper::sbk_o_requestFullScreen("DownloadItem", funcName, gil, pyOverride, visible);
}

::QPainter * DownloadItemWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return WebViewWrapper::sbk_o_sharedPainter("DownloadItem", funcName, gil, pyOverride);
}

void DownloadItemWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    WebViewWrapper::sbk_o_showEvent("DownloadItem", funcName, gil, pyOverride, event);
}

::QSize DownloadItemWrapper::sizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("DownloadItem", funcName, gil, pyOverride);
}

void DownloadItemWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    WebViewWrapper::sbk_o_tabletEvent("DownloadItem", funcName, gil, pyOverride, event);
}

void DownloadItemWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("DownloadItem", funcName, gil, pyOverride, event);
}

void DownloadItemWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadItem_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    WebViewWrapper::sbk_o_wheelEvent("DownloadItem", funcName, gil, pyOverride, event);
}

const QMetaObject *DownloadItemWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return DownloadItem::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int DownloadItemWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = DownloadItem::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *DownloadItemWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< DownloadItemWrapper *>(this));
    }
    return DownloadItem::qt_metacast(_clname);
}

DownloadItemWrapper::~DownloadItemWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_DownloadItem_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_DownloadItem_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::DownloadItem >()))
        return -1;

    DownloadItemWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[6];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "DownloadItem", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: DownloadItem::DownloadItem(QListWidgetItem*,QWebEngineDownloadRequest*,QString,QString,bool,DownloadManager*)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QListWidgetItem_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineDownloadRequest_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX]), (pyArgs[5])))) {
        overloadId = 0; // DownloadItem(QListWidgetItem*,QWebEngineDownloadRequest*,QString,QString,bool,DownloadManager*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_DownloadItem_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_DownloadItem_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QListWidgetItem *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return -1;
        ::QWebEngineDownloadRequest *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        bool cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        if (!Shiboken::Object::isValid(pyArgs[5]))
            return -1;
        ::DownloadManager *cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (Shiboken::Errors::occurred() == nullptr) {
            // DownloadItem(QListWidgetItem*,QWebEngineDownloadRequest*,QString,QString,bool,DownloadManager*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) DownloadItemWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new DownloadItemWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< DownloadItem >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_DownloadItem_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_DownloadItem_IDX]);
    };


    return 1;
}

static PyObject *Sbk_DownloadItemFunc_currentSpeed(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<DownloadItemWrapper *>(reinterpret_cast< ::DownloadItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // currentSpeed()const
        double cppResult = const_cast<const DownloadItemWrapper *>(cppSelf)->currentSpeed();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<double>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_DownloadItemFunc_currentSpeedToString(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static DownloadItem::currentSpeedToString(double)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArg)))) {
        overloadId = 0; // currentSpeedToString(double)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "currentSpeedToString", errInfo, SbkPyFalkonTypeStructs[SBK_DownloadItem_IDX]);

    // Call function/method
    {
        double cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // currentSpeedToString(double)
            QString cppResult = ::DownloadItem::currentSpeedToString(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_DownloadItemFunc_fileName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<DownloadItemWrapper *>(reinterpret_cast< ::DownloadItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // fileName()const
        QString cppResult = const_cast<const DownloadItemWrapper *>(cppSelf)->fileName();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_DownloadItemFunc_isCancelled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<DownloadItemWrapper *>(reinterpret_cast< ::DownloadItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isCancelled()
        bool cppResult = cppSelf->isCancelled();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_DownloadItemFunc_isDownloading(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<DownloadItemWrapper *>(reinterpret_cast< ::DownloadItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isDownloading()const
        bool cppResult = const_cast<const DownloadItemWrapper *>(cppSelf)->isDownloading();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_DownloadItemFunc_mouseDoubleClickEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<DownloadItemWrapper *>(reinterpret_cast< ::DownloadItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::mouseDoubleClickEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QMouseEvent_IDX]), (pyArg)))) {
        overloadId = 0; // mouseDoubleClickEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "mouseDoubleClickEvent", errInfo, SbkPyFalkonTypeStructs[SBK_DownloadItem_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("mouseDoubleClickEvent(QMouseEvent *e)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_DownloadItemFunc_path(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<DownloadItemWrapper *>(reinterpret_cast< ::DownloadItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // path()const
        QString cppResult = const_cast<const DownloadItemWrapper *>(cppSelf)->path();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_DownloadItemFunc_progress(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<DownloadItemWrapper *>(reinterpret_cast< ::DownloadItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // progress()
        int cppResult = cppSelf->progress();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_DownloadItemFunc_remaingTimeToString(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static DownloadItem::remaingTimeToString(QTime)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTime_IDX]), (pyArg)))) {
        overloadId = 0; // remaingTimeToString(QTime)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "remaingTimeToString", errInfo, SbkPyFalkonTypeStructs[SBK_DownloadItem_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTime cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // remaingTimeToString(QTime)
            QString cppResult = ::DownloadItem::remaingTimeToString(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_DownloadItemFunc_remainingTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<DownloadItemWrapper *>(reinterpret_cast< ::DownloadItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // remainingTime()const
        QTime cppResult = const_cast<const DownloadItemWrapper *>(cppSelf)->remainingTime();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTime_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_DownloadItemFunc_setDownTimer(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<DownloadItemWrapper *>(reinterpret_cast< ::DownloadItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: DownloadItem::setDownTimer(QElapsedTimer)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QElapsedTimer_IDX]), (pyArg)))) {
        overloadId = 0; // setDownTimer(QElapsedTimer)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setDownTimer", errInfo, SbkPyFalkonTypeStructs[SBK_DownloadItem_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QElapsedTimer cppArg0_local;
        ::QElapsedTimer *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setDownTimer(QElapsedTimer)
            cppSelf->setDownTimer(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_DownloadItemFunc_startDownloading(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<DownloadItemWrapper *>(reinterpret_cast< ::DownloadItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // startDownloading()
        cppSelf->startDownloading();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_DownloadItemFunc_url(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<DownloadItemWrapper *>(reinterpret_cast< ::DownloadItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // url()const
        QUrl cppResult = const_cast<const DownloadItemWrapper *>(cppSelf)->url();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_DownloadItem_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_DownloadItem_methods[] = {
    {"currentSpeed", reinterpret_cast<PyCFunction>(Sbk_DownloadItemFunc_currentSpeed), METH_NOARGS, nullptr},
    {"currentSpeedToString", reinterpret_cast<PyCFunction>(Sbk_DownloadItemFunc_currentSpeedToString), METH_O|METH_STATIC, nullptr},
    {"fileName", reinterpret_cast<PyCFunction>(Sbk_DownloadItemFunc_fileName), METH_NOARGS, nullptr},
    {"isCancelled", reinterpret_cast<PyCFunction>(Sbk_DownloadItemFunc_isCancelled), METH_NOARGS, nullptr},
    {"isDownloading", reinterpret_cast<PyCFunction>(Sbk_DownloadItemFunc_isDownloading), METH_NOARGS, nullptr},
    {"mouseDoubleClickEvent", reinterpret_cast<PyCFunction>(Sbk_DownloadItemFunc_mouseDoubleClickEvent), METH_O, nullptr},
    {"path", reinterpret_cast<PyCFunction>(Sbk_DownloadItemFunc_path), METH_NOARGS, nullptr},
    {"progress", reinterpret_cast<PyCFunction>(Sbk_DownloadItemFunc_progress), METH_NOARGS, nullptr},
    {"remaingTimeToString", reinterpret_cast<PyCFunction>(Sbk_DownloadItemFunc_remaingTimeToString), METH_O|METH_STATIC, nullptr},
    {"remainingTime", reinterpret_cast<PyCFunction>(Sbk_DownloadItemFunc_remainingTime), METH_NOARGS, nullptr},
    {"setDownTimer", reinterpret_cast<PyCFunction>(Sbk_DownloadItemFunc_setDownTimer), METH_O, nullptr},
    {"startDownloading", reinterpret_cast<PyCFunction>(Sbk_DownloadItemFunc_startDownloading), METH_NOARGS, nullptr},
    {"url", reinterpret_cast<PyCFunction>(Sbk_DownloadItemFunc_url), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_DownloadItem_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::DownloadItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadItem_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<DownloadItemWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_DownloadItem_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_DownloadItem_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_DownloadItemSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::DownloadItem *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_DownloadItem_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_DownloadItem_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_DownloadItem_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_DownloadItem_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_DownloadItem_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_DownloadItem_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_DownloadItem_spec = {
    "1:PyFalkon.DownloadItem",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_DownloadItem_slots
};

} //extern "C"

static void *Sbk_DownloadItem_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::DownloadItem *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::DownloadItem *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::DownloadItem *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void DownloadItem_PythonToCpp_DownloadItem_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_DownloadItem_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_DownloadItem_PythonToCpp_DownloadItem_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_DownloadItem_TypeF()))
        return DownloadItem_PythonToCpp_DownloadItem_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *DownloadItem_PTR_CppToPython_DownloadItem(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::DownloadItem *>(const_cast<void *>(cppIn)), Sbk_DownloadItem_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *DownloadItem_SignatureStrings[] = {
    "PyFalkon.DownloadItem(self,item:PySide6.QtWidgets.QListWidgetItem,downloadItem:PySide6.QtWebEngineCore.QWebEngineDownloadRequest,path:QString,fileName:QString,openFile:bool,manager:PyFalkon.DownloadManager)",
    "PyFalkon.DownloadItem.currentSpeed(self)->double",
    "PyFalkon.DownloadItem.currentSpeedToString(speed:double)->QString",
    "PyFalkon.DownloadItem.fileName(self)->QString",
    "PyFalkon.DownloadItem.isCancelled(self)->bool",
    "PyFalkon.DownloadItem.isDownloading(self)->bool",
    "PyFalkon.DownloadItem.mouseDoubleClickEvent(self,e:PySide6.QtGui.QMouseEvent)",
    "PyFalkon.DownloadItem.path(self)->QString",
    "PyFalkon.DownloadItem.progress(self)->int",
    "PyFalkon.DownloadItem.remaingTimeToString(time:PySide6.QtCore.QTime)->QString",
    "PyFalkon.DownloadItem.remainingTime(self)->PySide6.QtCore.QTime",
    "PyFalkon.DownloadItem.setDownTimer(self,timer:PySide6.QtCore.QElapsedTimer)",
    "PyFalkon.DownloadItem.startDownloading(self)",
    "PyFalkon.DownloadItem.url(self)->PySide6.QtCore.QUrl",
    nullptr}; // Sentinel
#else
static constexpr size_t DownloadItem_SignatureByteSize = 321;
static constexpr uint8_t DownloadItem_SignatureBytes[321] = {
    0x78, 0xda, 0x8d, 0x52, 0xcb, 0x4e, 0xc3, 0x30, 0x10, 0xbc, 0xf7, 0x4b, 0x5a, 0x29, 0xf8, 0xc8,
    0x21, 0x07, 0x2e, 0x21, 0x45, 0x48, 0x14, 0x25, 0xa4, 0x88, 0xb3, 0x93, 0x6c, 0x53, 0xab, 0x7e,
    0x84, 0xb5, 0x03, 0xea, 0xdf, 0x63, 0xc7, 0x71, 0x89, 0x68, 0x4d, 0x7b, 0xf3, 0xd8, 0xb3, 0xb3,
    0x33, 0xbb, 0x2e, 0x8e, 0x6b, 0xca, 0x0f, 0x4a, 0x92, 0x47, 0xf5, 0x2d, 0xb9, 0xa2, 0xed, 0xb3,
    0x01, 0xb1, 0xd4, 0xc0, 0x77, 0x09, 0xb3, 0xa7, 0xb4, 0x38, 0x56, 0xac, 0x85, 0x7b, 0x52, 0x9a,
    0x0f, 0xd6, 0x76, 0x60, 0x34, 0x29, 0x5f, 0x98, 0x9e, 0x80, 0xe3, 0x26, 0xed, 0xac, 0x70, 0x4e,
    0x87, 0x3a, 0x97, 0x1d, 0x93, 0x90, 0x29, 0x04, 0x52, 0x9e, 0x60, 0xe8, 0xf3, 0x06, 0x9f, 0x03,
    0x68, 0x93, 0xf4, 0xd4, 0xec, 0xd3, 0xb2, 0x32, 0xc8, 0x64, 0x97, 0xec, 0x18, 0x87, 0x57, 0x2a,
    0xe0, 0x74, 0xa1, 0x7a, 0x90, 0x6b, 0x7b, 0x99, 0xd6, 0x4a, 0xf1, 0x44, 0x50, 0x49, 0x3b, 0x40,
    0xdb, 0xe5, 0x8f, 0xe9, 0x8d, 0x7f, 0x58, 0x2d, 0x8a, 0x4b, 0x71, 0x48, 0x33, 0x20, 0x82, 0x34,
    0x55, 0x0f, 0xd0, 0x8e, 0xd9, 0x56, 0x77, 0x0f, 0xad, 0x1a, 0x6a, 0x0e, 0x37, 0x14, 0x6c, 0x95,
    0xf7, 0xb2, 0xd4, 0x0e, 0xa5, 0xbe, 0xce, 0x0a, 0x4c, 0x16, 0x23, 0x0a, 0x21, 0x49, 0x68, 0xf7,
    0x3f, 0x9b, 0xe9, 0x8c, 0xca, 0x06, 0x38, 0xff, 0xf5, 0xe7, 0x02, 0x47, 0xd9, 0x01, 0x8e, 0xb6,
    0xae, 0xf2, 0x85, 0x1a, 0xb4, 0x9d, 0xbb, 0xf3, 0x9d, 0x71, 0xd6, 0x1c, 0xf2, 0x2f, 0x9b, 0xcd,
    0xef, 0x18, 0x66, 0x1b, 0x7b, 0x1a, 0x18, 0x29, 0x37, 0x8e, 0x3b, 0x12, 0x62, 0xc3, 0x74, 0x0b,
    0xbb, 0x2d, 0x55, 0x8f, 0xaa, 0x43, 0xd0, 0x3a, 0xb0, 0x99, 0x34, 0x11, 0x26, 0x82, 0xa0, 0x56,
    0x67, 0xcb, 0x04, 0x9c, 0xc6, 0x6d, 0x2c, 0x98, 0xb9, 0xf3, 0xdf, 0xc8, 0x31, 0xae, 0xf6, 0xf5,
    0x6a, 0x93, 0x5e, 0x68, 0x7e, 0x49, 0x29, 0x52, 0xaf, 0xc1, 0x38, 0xec, 0x18, 0xe8, 0xc7, 0xe4,
    0xbc, 0xe0, 0x99, 0x99, 0x9c, 0xd3, 0x5e, 0xdb, 0x0f, 0xe2, 0x1e, 0x63, 0xd3, 0xd2, 0x86, 0xa2,
    0x39, 0x5b, 0x57, 0x84, 0x3c, 0x20, 0x8f, 0xd9, 0x7d, 0x47, 0xbe, 0xf8, 0x01, 0x2d, 0x7e, 0x59,
    0xda
};
#endif

PyTypeObject *init_DownloadItem(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_DownloadItem_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_DownloadItem_IDX].type;

    Shiboken::AutoDecRef Sbk_DownloadItem_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))));

    _Sbk_DownloadItem_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "DownloadItem",
        "DownloadItem*",
        &Sbk_DownloadItem_spec,
        &Shiboken::callCppDestructor< DownloadItem >,
        Sbk_DownloadItem_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_DownloadItem_Type; // references _Sbk_DownloadItem_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, DownloadItem_SignatureStrings);
#else
    InitSignatureBytes(pyType, DownloadItem_SignatureBytes, DownloadItem_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_DownloadItem_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_DownloadItem_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        DownloadItem_PythonToCpp_DownloadItem_PTR,
        is_DownloadItem_PythonToCpp_DownloadItem_PTR_Convertible,
        DownloadItem_PTR_CppToPython_DownloadItem);

    Shiboken::Conversions::registerConverterName(converter, "DownloadItem");
    Shiboken::Conversions::registerConverterName(converter, "DownloadItem*");
    Shiboken::Conversions::registerConverterName(converter, "DownloadItem&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::DownloadItem).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(DownloadItemWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_DownloadItem_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_DownloadItem_TypeF(), &Sbk_DownloadItemSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_DownloadItem_TypeF(), &Sbk_DownloadItem_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::DownloadItem::staticMetaObject);
    DownloadItemWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::DownloadItem::staticMetaObject, sizeof(DownloadItemWrapper));

    return pyType;
}
