/* function-manager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from function-manager.vala, do not modify */

/*
 * Copyright (C) 2013 Garima Joshi
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include "calculator.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <glib-object.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	FUNCTION_MANAGER_0_PROPERTY,
	FUNCTION_MANAGER_NUM_PROPERTIES
};
static GParamSpec* function_manager_properties[FUNCTION_MANAGER_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
enum  {
	FUNCTION_MANAGER_FUNCTION_ADDED_SIGNAL,
	FUNCTION_MANAGER_FUNCTION_EDITED_SIGNAL,
	FUNCTION_MANAGER_FUNCTION_DELETED_SIGNAL,
	FUNCTION_MANAGER_NUM_SIGNALS
};
static guint function_manager_signals[FUNCTION_MANAGER_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FunctionManagerPrivate {
	gchar* file_name;
	GHashTable* functions;
	Serializer* serializer;
};

VALA_EXTERN FunctionManager* default_function_manager;
FunctionManager* default_function_manager = NULL;
static gint FunctionManager_private_offset;
static gpointer function_manager_parent_class = NULL;
FunctionCategory* function_manager_FUNCTION_CATEGORIES = NULL;
gint function_manager_FUNCTION_CATEGORIES_length1 = 0;

static MathFunction** _vala_array_dup2 (MathFunction** self,
                                 gssize length);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void function_manager_reload_functions (FunctionManager* self);
static void function_manager_reload_custom_functions (FunctionManager* self);
static void function_manager_reload_builtin_functions (FunctionManager* self);
static gboolean function_manager_add (FunctionManager* self,
                               MathFunction* new_function);
static MathFunction* function_manager_parse_function_from_string (FunctionManager* self,
                                                           const gchar* data);
static void function_manager_save (FunctionManager* self);
static gchar** function_manager_array_sort_string (FunctionManager* self,
                                            gchar** array,
                                            gint array_length1,
                                            gint* result_length1);
static gchar** _vala_array_dup3 (gchar** self,
                          gssize length);
static Number** _vala_array_dup4 (Number** self,
                           gssize length);
static void _vala_array_add4 (Number** * array,
                       gint* length,
                       gint* size,
                       Number* value);
static MathFunction** function_manager_array_sort_math_function (FunctionManager* self,
                                                          MathFunction** array,
                                                          gint array_length1,
                                                          gint* result_length1);
static MathFunction** _vala_array_dup5 (MathFunction** self,
                                 gssize length);
static MathFunction** _vala_array_dup6 (MathFunction** self,
                                 gssize length);
static void _vala_array_add5 (MathFunction** * array,
                       gint* length,
                       gint* size,
                       MathFunction* value);
static void function_manager_finalize (GObject * obj);
static GType function_manager_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static MathFunction**
_vala_array_dup2 (MathFunction** self,
                  gssize length)
{
	if (length >= 0) {
		MathFunction** result;
		gssize i;
		result = g_new0 (MathFunction*, length + 1);
		for (i = 0; i < length; i++) {
			MathFunction* _tmp0_;
			_tmp0_ = _g_object_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
function_category_copy (const FunctionCategory* self,
                        FunctionCategory* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	MathFunction** _tmp2_;
	gint _tmp2__length1;
	MathFunction** _tmp3_;
	gint _tmp3__length1;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).functions;
	_tmp2__length1 = (*self).functions_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup2 (_tmp2_, _tmp2__length1) : _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	(*dest).functions = (_vala_array_free ((*dest).functions, (*dest).functions_length1, (GDestroyNotify) g_object_unref), NULL);
	(*dest).functions = _tmp3_;
	(*dest).functions_length1 = _tmp3__length1;
}

void
function_category_destroy (FunctionCategory* self)
{
	_g_free0 ((*self).name);
	(*self).functions = (_vala_array_free ((*self).functions, (*self).functions_length1, (GDestroyNotify) g_object_unref), NULL);
}

FunctionCategory*
function_category_dup (const FunctionCategory* self)
{
	FunctionCategory* dup;
	dup = g_new0 (FunctionCategory, 1);
	function_category_copy (self, dup);
	return dup;
}

void
function_category_free (FunctionCategory* self)
{
	function_category_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
function_category_get_type_once (void)
{
	GType function_category_type_id;
	function_category_type_id = g_boxed_type_register_static ("FunctionCategory", (GBoxedCopyFunc) function_category_dup, (GBoxedFreeFunc) function_category_free);
	return function_category_type_id;
}

GType
function_category_get_type (void)
{
	static gsize function_category_type_id__once = 0;
	if (g_once_init_enter (&function_category_type_id__once)) {
		GType function_category_type_id;
		function_category_type_id = function_category_get_type_once ();
		g_once_init_leave (&function_category_type_id__once, function_category_type_id);
	}
	return function_category_type_id__once;
}

static inline gpointer
function_manager_get_instance_private (FunctionManager* self)
{
	return G_STRUCT_MEMBER_P (self, FunctionManager_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

FunctionManager*
function_manager_construct (GType object_type)
{
	FunctionManager * self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	Serializer* _tmp5_;
	Serializer* _tmp6_;
	self = (FunctionManager*) g_object_new (object_type, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->functions);
	self->priv->functions = _tmp2_;
	_tmp3_ = g_get_user_data_dir ();
	_tmp4_ = g_build_filename (_tmp3_, "gnome-calculator", "custom-functions", NULL);
	_g_free0 (self->priv->file_name);
	self->priv->file_name = _tmp4_;
	_tmp5_ = serializer_new (DISPLAY_FORMAT_SCIENTIFIC, 10, 50);
	_g_object_unref0 (self->priv->serializer);
	self->priv->serializer = _tmp5_;
	_tmp6_ = self->priv->serializer;
	serializer_set_radix (_tmp6_, (gunichar) '.');
	function_manager_reload_functions (self);
	return self;
}

FunctionManager*
function_manager_new (void)
{
	return function_manager_construct (TYPE_FUNCTION_MANAGER);
}

FunctionManager*
function_manager_get_default_function_manager (void)
{
	FunctionManager* _tmp0_;
	FunctionManager* _tmp2_;
	FunctionManager* _tmp3_;
	FunctionManager* result;
	_tmp0_ = default_function_manager;
	if (_tmp0_ == NULL) {
		FunctionManager* _tmp1_;
		_tmp1_ = function_manager_new ();
		_g_object_unref0 (default_function_manager);
		default_function_manager = _tmp1_;
	}
	_tmp2_ = default_function_manager;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static void
function_manager_reload_functions (FunctionManager* self)
{
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->functions;
	g_hash_table_remove_all (_tmp0_);
	function_manager_reload_custom_functions (self);
	function_manager_reload_builtin_functions (self);
}

static void
function_manager_reload_builtin_functions (FunctionManager* self)
{
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	BuiltInMathFunction* _tmp3_;
	BuiltInMathFunction* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	BuiltInMathFunction* _tmp8_;
	BuiltInMathFunction* _tmp9_;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	BuiltInMathFunction* _tmp13_;
	BuiltInMathFunction* _tmp14_;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	BuiltInMathFunction* _tmp18_;
	BuiltInMathFunction* _tmp19_;
	gchar* _tmp20_;
	gchar** _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	BuiltInMathFunction* _tmp23_;
	BuiltInMathFunction* _tmp24_;
	gchar* _tmp25_;
	gchar** _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	BuiltInMathFunction* _tmp28_;
	BuiltInMathFunction* _tmp29_;
	FunctionCategory* _tmp30_;
	gint _tmp30__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("x");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	_tmp3_ = built_in_math_function_new ("asin", _ ("Inverse Sine"), _tmp2_, 1);
	_tmp4_ = _tmp3_;
	function_manager_add (self, (MathFunction*) _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	_tmp5_ = g_strdup ("x");
	_tmp6_ = g_new0 (gchar*, 1 + 1);
	_tmp6_[0] = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 1;
	_tmp8_ = built_in_math_function_new ("acos", _ ("Inverse Cosine"), _tmp7_, 1);
	_tmp9_ = _tmp8_;
	function_manager_add (self, (MathFunction*) _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
	_tmp10_ = g_strdup ("x");
	_tmp11_ = g_new0 (gchar*, 1 + 1);
	_tmp11_[0] = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp12__length1 = 1;
	_tmp13_ = built_in_math_function_new ("atan", _ ("Inverse Tangent"), _tmp12_, 1);
	_tmp14_ = _tmp13_;
	function_manager_add (self, (MathFunction*) _tmp14_);
	_g_object_unref0 (_tmp14_);
	_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_free), NULL);
	_tmp15_ = g_strdup ("x");
	_tmp16_ = g_new0 (gchar*, 1 + 1);
	_tmp16_[0] = _tmp15_;
	_tmp17_ = _tmp16_;
	_tmp17__length1 = 1;
	_tmp18_ = built_in_math_function_new ("asinh", _ ("Inverse Hyperbolic Sine"), _tmp17_, 1);
	_tmp19_ = _tmp18_;
	function_manager_add (self, (MathFunction*) _tmp19_);
	_g_object_unref0 (_tmp19_);
	_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
	_tmp20_ = g_strdup ("x");
	_tmp21_ = g_new0 (gchar*, 1 + 1);
	_tmp21_[0] = _tmp20_;
	_tmp22_ = _tmp21_;
	_tmp22__length1 = 1;
	_tmp23_ = built_in_math_function_new ("acosh", _ ("Inverse Hyperbolic Cosine"), _tmp22_, 1);
	_tmp24_ = _tmp23_;
	function_manager_add (self, (MathFunction*) _tmp24_);
	_g_object_unref0 (_tmp24_);
	_tmp22_ = (_vala_array_free (_tmp22_, _tmp22__length1, (GDestroyNotify) g_free), NULL);
	_tmp25_ = g_strdup ("x");
	_tmp26_ = g_new0 (gchar*, 1 + 1);
	_tmp26_[0] = _tmp25_;
	_tmp27_ = _tmp26_;
	_tmp27__length1 = 1;
	_tmp28_ = built_in_math_function_new ("atanh", _ ("Inverse Hyperbolic Tangent"), _tmp27_, 1);
	_tmp29_ = _tmp28_;
	function_manager_add (self, (MathFunction*) _tmp29_);
	_g_object_unref0 (_tmp29_);
	_tmp27_ = (_vala_array_free (_tmp27_, _tmp27__length1, (GDestroyNotify) g_free), NULL);
	_tmp30_ = function_manager_FUNCTION_CATEGORIES;
	_tmp30__length1 = function_manager_FUNCTION_CATEGORIES_length1;
	{
		FunctionCategory* categoty_collection = NULL;
		gint categoty_collection_length1 = 0;
		gint _categoty_collection_size_ = 0;
		gint categoty_it = 0;
		categoty_collection = _tmp30_;
		categoty_collection_length1 = _tmp30__length1;
		for (categoty_it = 0; categoty_it < categoty_collection_length1; categoty_it = categoty_it + 1) {
			FunctionCategory _tmp31_;
			FunctionCategory _tmp32_ = {0};
			FunctionCategory categoty = {0};
			_tmp31_ = categoty_collection[categoty_it];
			function_category_copy (&_tmp31_, &_tmp32_);
			categoty = _tmp32_;
			{
				FunctionCategory _tmp33_;
				MathFunction** _tmp34_;
				gint _tmp34__length1;
				_tmp33_ = categoty;
				_tmp34_ = _tmp33_.functions;
				_tmp34__length1 = _tmp33_.functions_length1;
				{
					MathFunction** function_collection = NULL;
					gint function_collection_length1 = 0;
					gint _function_collection_size_ = 0;
					gint function_it = 0;
					function_collection = _tmp34_;
					function_collection_length1 = _tmp34__length1;
					for (function_it = 0; function_it < function_collection_length1; function_it = function_it + 1) {
						MathFunction* _tmp35_;
						MathFunction* function = NULL;
						_tmp35_ = _g_object_ref0 (function_collection[function_it]);
						function = _tmp35_;
						{
							MathFunction* _tmp36_;
							_tmp36_ = function;
							function_manager_add (self, _tmp36_);
							_g_object_unref0 (function);
						}
					}
				}
				function_category_destroy (&categoty);
			}
		}
	}
}

static void
function_manager_reload_custom_functions (FunctionManager* self)
{
	gchar* data = NULL;
	gchar** lines = NULL;
	const gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint lines_length1;
	gint _lines_size_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		_tmp0_ = self->priv->file_name;
		g_file_get_contents (_tmp0_, &_tmp1_, NULL, &_inner_error0_);
		_g_free0 (data);
		data = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (data);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		g_clear_error (&_inner_error0_);
		_g_free0 (data);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp2_ = data;
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, "\n", 0);
	lines = _tmp4_;
	lines_length1 = _vala_array_length (_tmp3_);
	_lines_size_ = lines_length1;
	_tmp5_ = lines;
	_tmp5__length1 = lines_length1;
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp5_;
		line_collection_length1 = _tmp5__length1;
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp6_;
			gchar* line = NULL;
			_tmp6_ = g_strdup (line_collection[line_it]);
			line = _tmp6_;
			{
				MathFunction* function = NULL;
				const gchar* _tmp7_;
				MathFunction* _tmp8_;
				MathFunction* _tmp9_;
				_tmp7_ = line;
				_tmp8_ = function_manager_parse_function_from_string (self, _tmp7_);
				function = _tmp8_;
				_tmp9_ = function;
				if (_tmp9_ != NULL) {
					GHashTable* _tmp10_;
					MathFunction* _tmp11_;
					const gchar* _tmp12_;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					MathFunction* _tmp15_;
					MathFunction* _tmp16_;
					_tmp10_ = self->priv->functions;
					_tmp11_ = function;
					_tmp12_ = math_function_get_name (_tmp11_);
					_tmp13_ = _tmp12_;
					_tmp14_ = g_strdup (_tmp13_);
					_tmp15_ = function;
					_tmp16_ = _g_object_ref0 (_tmp15_);
					g_hash_table_insert (_tmp10_, _tmp14_, _tmp16_);
				}
				_g_object_unref0 (function);
				_g_free0 (line);
			}
		}
	}
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (data);
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static MathFunction*
function_manager_parse_function_from_string (FunctionManager* self,
                                             const gchar* data)
{
	gint i = 0;
	gchar* left = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* right = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	gchar* expression = NULL;
	gchar* _tmp11_;
	gchar* description = NULL;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* name = NULL;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* argument_list = NULL;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gboolean _tmp36_ = FALSE;
	const gchar* _tmp37_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	gchar** arguments = NULL;
	const gchar* _tmp41_;
	gchar** _tmp42_;
	gchar** _tmp43_;
	gint arguments_length1;
	gint _arguments_size_;
	const gchar* _tmp44_;
	gchar** _tmp45_;
	gint _tmp45__length1;
	const gchar* _tmp46_;
	const gchar* _tmp47_;
	MathFunction* _tmp48_;
	MathFunction* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (data == NULL) {
		result = NULL;
		return result;
	}
	i = string_index_of_char (data, (gunichar) '=', 0);
	if (i < 0) {
		result = NULL;
		return result;
	}
	_tmp0_ = string_substring (data, (glong) 0, (glong) i);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_strip (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	left = _tmp3_;
	_tmp4_ = string_substring (data, (glong) (i + 1), (glong) -1);
	_tmp5_ = _tmp4_;
	_tmp6_ = string_strip (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	right = _tmp7_;
	_tmp9_ = left;
	if (_tmp9_ == NULL) {
		_tmp8_ = TRUE;
	} else {
		const gchar* _tmp10_;
		_tmp10_ = right;
		_tmp8_ = _tmp10_ == NULL;
	}
	if (_tmp8_) {
		result = NULL;
		_g_free0 (right);
		_g_free0 (left);
		return result;
	}
	_tmp11_ = g_strdup ("");
	expression = _tmp11_;
	_tmp12_ = g_strdup ("");
	description = _tmp12_;
	_tmp13_ = right;
	i = string_index_of_char (_tmp13_, (gunichar) '@', 0);
	if (i < 0) {
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp14_ = right;
		_tmp15_ = g_strdup (_tmp14_);
		_g_free0 (expression);
		expression = _tmp15_;
	} else {
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp16_ = right;
		_tmp17_ = string_substring (_tmp16_, (glong) 0, (glong) i);
		_tmp18_ = _tmp17_;
		_tmp19_ = string_strip (_tmp18_);
		_g_free0 (expression);
		expression = _tmp19_;
		_g_free0 (_tmp18_);
		_tmp20_ = right;
		_tmp21_ = string_substring (_tmp20_, (glong) (i + 1), (glong) -1);
		_tmp22_ = _tmp21_;
		_tmp23_ = string_strip (_tmp22_);
		_g_free0 (description);
		description = _tmp23_;
		_g_free0 (_tmp22_);
	}
	_tmp24_ = expression;
	if (_tmp24_ == NULL) {
		result = NULL;
		_g_free0 (description);
		_g_free0 (expression);
		_g_free0 (right);
		_g_free0 (left);
		return result;
	}
	_tmp25_ = left;
	i = string_index_of_char (_tmp25_, (gunichar) '(', 0);
	if (i < 0) {
		result = NULL;
		_g_free0 (description);
		_g_free0 (expression);
		_g_free0 (right);
		_g_free0 (left);
		return result;
	}
	_tmp26_ = left;
	_tmp27_ = string_substring (_tmp26_, (glong) 0, (glong) i);
	_tmp28_ = _tmp27_;
	_tmp29_ = string_strip (_tmp28_);
	_tmp30_ = _tmp29_;
	_g_free0 (_tmp28_);
	name = _tmp30_;
	_tmp31_ = left;
	_tmp32_ = string_substring (_tmp31_, (glong) (i + 1), (glong) -1);
	_tmp33_ = _tmp32_;
	_tmp34_ = string_strip (_tmp33_);
	_tmp35_ = _tmp34_;
	_g_free0 (_tmp33_);
	argument_list = _tmp35_;
	_tmp37_ = name;
	if (_tmp37_ == NULL) {
		_tmp36_ = TRUE;
	} else {
		const gchar* _tmp38_;
		_tmp38_ = argument_list;
		_tmp36_ = _tmp38_ == NULL;
	}
	if (_tmp36_) {
		result = NULL;
		_g_free0 (argument_list);
		_g_free0 (name);
		_g_free0 (description);
		_g_free0 (expression);
		_g_free0 (right);
		_g_free0 (left);
		return result;
	}
	_tmp39_ = argument_list;
	_tmp40_ = string_replace (_tmp39_, ")", "");
	_g_free0 (argument_list);
	argument_list = _tmp40_;
	_tmp41_ = argument_list;
	_tmp43_ = _tmp42_ = g_strsplit_set (_tmp41_, ";", 0);
	arguments = _tmp43_;
	arguments_length1 = _vala_array_length (_tmp42_);
	_arguments_size_ = arguments_length1;
	_tmp44_ = name;
	_tmp45_ = arguments;
	_tmp45__length1 = arguments_length1;
	_tmp46_ = expression;
	_tmp47_ = description;
	_tmp48_ = math_function_new (_tmp44_, _tmp45_, _tmp45__length1, _tmp46_, _tmp47_);
	result = _tmp48_;
	arguments = (_vala_array_free (arguments, arguments_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (argument_list);
	_g_free0 (name);
	_g_free0 (description);
	_g_free0 (expression);
	_g_free0 (right);
	_g_free0 (left);
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static void
function_manager_save (FunctionManager* self)
{
	gchar* data = NULL;
	gchar* _tmp0_;
	GHashTableIter iter = {0};
	GHashTable* _tmp1_;
	gchar* name = NULL;
	MathFunction* math_function = NULL;
	gchar* dir = NULL;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	data = _tmp0_;
	_tmp1_ = self->priv->functions;
	g_hash_table_iter_init (&iter, _tmp1_);
	while (TRUE) {
		gconstpointer _tmp2_ = NULL;
		gconstpointer _tmp3_ = NULL;
		gboolean _tmp4_;
		gchar* _tmp5_;
		MathFunction* _tmp6_;
		MathFunction* _tmp7_;
		const gchar* _tmp8_;
		MathFunction* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		MathFunction* _tmp12_;
		gchar** _tmp13_;
		gint _tmp13__length1;
		gint _tmp14_ = 0;
		gchar** _tmp15_;
		gint _tmp15__length1;
		gchar* _tmp16_;
		gchar* _tmp17_;
		MathFunction* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		MathFunction* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		_tmp4_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp2_), (gpointer*) (&_tmp3_));
		_g_free0 (name);
		_tmp5_ = g_strdup ((const gchar*) _tmp2_);
		name = _tmp5_;
		_g_object_unref0 (math_function);
		_tmp6_ = _g_object_ref0 ((MathFunction*) _tmp3_);
		math_function = _tmp6_;
		if (!_tmp4_) {
			break;
		}
		_tmp7_ = math_function;
		if (!math_function_is_custom_function (_tmp7_)) {
			continue;
		}
		_tmp8_ = data;
		_tmp9_ = math_function;
		_tmp10_ = math_function_get_name (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = math_function;
		_tmp13_ = math_function_get_arguments (_tmp12_, &_tmp14_);
		_tmp13__length1 = _tmp14_;
		_tmp15_ = _tmp13_;
		_tmp15__length1 = _tmp13__length1;
		_tmp16_ = _vala_g_strjoinv (";", _tmp15_, (gint) _tmp15__length1);
		_tmp17_ = _tmp16_;
		_tmp18_ = math_function;
		_tmp19_ = math_function_get_expression (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = math_function;
		_tmp22_ = math_function_get_description (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strdup_printf ("%s(%s)=%s@%s\n", _tmp11_, _tmp17_, _tmp20_, _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strconcat (_tmp8_, _tmp25_, NULL);
		_g_free0 (data);
		data = _tmp26_;
		_g_free0 (_tmp25_);
		_g_free0 (_tmp17_);
	}
	_tmp27_ = self->priv->file_name;
	_tmp28_ = g_path_get_dirname (_tmp27_);
	dir = _tmp28_;
	g_mkdir_with_parents (dir, 0700);
	{
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		_tmp29_ = self->priv->file_name;
		_tmp30_ = data;
		g_file_set_contents (_tmp29_, _tmp30_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (dir);
			_g_object_unref0 (math_function);
			_g_free0 (name);
			_g_free0 (data);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (dir);
		_g_object_unref0 (math_function);
		_g_free0 (name);
		_g_free0 (data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (dir);
	_g_object_unref0 (math_function);
	_g_free0 (name);
	_g_free0 (data);
}

static gchar**
_vala_array_dup3 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
function_manager_array_sort_string (FunctionManager* self,
                                    gchar** array,
                                    gint array_length1,
                                    gint* result_length1)
{
	gboolean swapped = FALSE;
	gint _tmp0_ = 0;
	const gchar* _tmp1_;
	gint j = 0;
	gchar* tmp = NULL;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	swapped = TRUE;
	_tmp1_ = array[array_length1 - 1];
	if (_tmp1_ == NULL) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	j = _tmp0_;
	while (TRUE) {
		gint _tmp2_;
		if (!swapped) {
			break;
		}
		swapped = FALSE;
		_tmp2_ = j;
		j = _tmp2_ + 1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					const gchar* _tmp5_;
					const gchar* _tmp6_;
					if (!_tmp3_) {
						gint _tmp4_;
						_tmp4_ = i;
						i = _tmp4_ + 1;
					}
					_tmp3_ = FALSE;
					if (!(i < (array_length1 - j))) {
						break;
					}
					_tmp5_ = array[i];
					_tmp6_ = array[i + 1];
					if (g_strcmp0 (_tmp5_, _tmp6_) < 0) {
						const gchar* _tmp7_;
						gchar* _tmp8_;
						const gchar* _tmp9_;
						gchar* _tmp10_;
						const gchar* _tmp11_;
						gchar* _tmp12_;
						_tmp7_ = array[i];
						_tmp8_ = g_strdup (_tmp7_);
						_g_free0 (tmp);
						tmp = _tmp8_;
						_tmp9_ = array[i + 1];
						_tmp10_ = g_strdup (_tmp9_);
						_g_free0 (array[i]);
						array[i] = _tmp10_;
						_tmp11_ = tmp;
						_tmp12_ = g_strdup (_tmp11_);
						_g_free0 (array[i + 1]);
						array[i + 1] = _tmp12_;
						swapped = TRUE;
					}
				}
			}
		}
	}
	_tmp13_ = (array != NULL) ? _vala_array_dup3 (array, array_length1) : array;
	_tmp13__length1 = array_length1;
	_tmp14_ = _tmp13_;
	_tmp14__length1 = _tmp13__length1;
	if (result_length1) {
		*result_length1 = _tmp14__length1;
	}
	result = _tmp14_;
	_g_free0 (tmp);
	return result;
}

gchar**
function_manager_get_names (FunctionManager* self,
                            gint* result_length1)
{
	gchar** names = NULL;
	GHashTable* _tmp0_;
	gchar** _tmp1_;
	gint names_length1;
	gint _names_size_;
	GHashTableIter iter = {0};
	GHashTable* _tmp2_;
	gint i = 0;
	gchar* name = NULL;
	MathFunction* definition = NULL;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gint _tmp14_ = 0;
	gchar** _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->functions;
	_tmp1_ = g_new0 (gchar*, (g_hash_table_size (_tmp0_) + 1) + 1);
	names = _tmp1_;
	names_length1 = g_hash_table_size (_tmp0_) + 1;
	_names_size_ = names_length1;
	_tmp2_ = self->priv->functions;
	g_hash_table_iter_init (&iter, _tmp2_);
	i = 0;
	while (TRUE) {
		gconstpointer _tmp3_ = NULL;
		gconstpointer _tmp4_ = NULL;
		gboolean _tmp5_;
		gchar* _tmp6_;
		MathFunction* _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gint _tmp11_;
		_tmp5_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp3_), (gpointer*) (&_tmp4_));
		_g_free0 (name);
		_tmp6_ = g_strdup ((const gchar*) _tmp3_);
		name = _tmp6_;
		_g_object_unref0 (definition);
		_tmp7_ = _g_object_ref0 ((MathFunction*) _tmp4_);
		definition = _tmp7_;
		if (!_tmp5_) {
			break;
		}
		_tmp8_ = names;
		_tmp8__length1 = names_length1;
		_tmp9_ = name;
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (_tmp8_[i]);
		_tmp8_[i] = _tmp10_;
		_tmp11_ = i;
		i = _tmp11_ + 1;
	}
	_tmp12_ = names;
	_tmp12__length1 = names_length1;
	_g_free0 (_tmp12_[i]);
	_tmp12_[i] = NULL;
	_tmp13_ = names;
	_tmp13__length1 = names_length1;
	_tmp15_ = function_manager_array_sort_string (self, _tmp13_, (gint) _tmp13__length1, &_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp16__length1 = _tmp14_;
	if (result_length1) {
		*result_length1 = _tmp16__length1;
	}
	result = _tmp16_;
	_g_object_unref0 (definition);
	_g_free0 (name);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

/**
      * Adds a function to the manager, unless the given name is already taken
      * by a predefined function.
      * @return If the function was successfully added.
      */
static gboolean
function_manager_add (FunctionManager* self,
                      MathFunction* new_function)
{
	MathFunction* existing_function = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	MathFunction* _tmp2_;
	gboolean _tmp3_ = FALSE;
	MathFunction* _tmp4_;
	GHashTable* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	MathFunction* _tmp10_;
	MathFunction* _tmp11_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (new_function != NULL, FALSE);
	_tmp0_ = math_function_get_name (new_function);
	_tmp1_ = _tmp0_;
	_tmp2_ = function_manager_get (self, _tmp1_);
	existing_function = _tmp2_;
	_tmp4_ = existing_function;
	if (_tmp4_ != NULL) {
		MathFunction* _tmp5_;
		_tmp5_ = existing_function;
		_tmp3_ = !math_function_is_custom_function (_tmp5_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = FALSE;
		_g_object_unref0 (existing_function);
		return result;
	}
	_tmp6_ = self->priv->functions;
	_tmp7_ = math_function_get_name (new_function);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup (_tmp8_);
	_tmp10_ = _g_object_ref0 (new_function);
	g_hash_table_insert (_tmp6_, _tmp9_, _tmp10_);
	_tmp11_ = existing_function;
	if (_tmp11_ != NULL) {
		g_signal_emit (self, function_manager_signals[FUNCTION_MANAGER_FUNCTION_EDITED_SIGNAL], 0, new_function);
	} else {
		g_signal_emit (self, function_manager_signals[FUNCTION_MANAGER_FUNCTION_ADDED_SIGNAL], 0, new_function);
	}
	result = TRUE;
	_g_object_unref0 (existing_function);
	return result;
}

gboolean
function_manager_add_function_with_properties (FunctionManager* self,
                                               const gchar* name,
                                               const gchar* arguments,
                                               const gchar* description,
                                               Parser* root_parser)
{
	gchar* function_string = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	MathFunction* new_function = NULL;
	const gchar* _tmp8_;
	MathFunction* _tmp9_;
	gboolean _tmp10_ = FALSE;
	MathFunction* _tmp11_;
	gboolean is_function_added = FALSE;
	MathFunction* _tmp13_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	g_return_val_if_fail (arguments != NULL, FALSE);
	g_return_val_if_fail (description != NULL, FALSE);
	_tmp0_ = g_strconcat (name, "(", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, arguments, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, ")=", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, description, NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	function_string = _tmp7_;
	_tmp8_ = function_string;
	_tmp9_ = function_manager_parse_function_from_string (self, _tmp8_);
	new_function = _tmp9_;
	_tmp11_ = new_function;
	if (_tmp11_ == NULL) {
		_tmp10_ = TRUE;
	} else {
		MathFunction* _tmp12_;
		_tmp12_ = new_function;
		_tmp10_ = math_function_validate (_tmp12_, root_parser) == FALSE;
	}
	if (_tmp10_) {
		parser_set_error (root_parser, ERROR_CODE_INVALID, NULL, (guint) 0, (guint) 0);
		result = FALSE;
		_g_object_unref0 (new_function);
		_g_free0 (function_string);
		return result;
	}
	_tmp13_ = new_function;
	is_function_added = function_manager_add (self, _tmp13_);
	if (is_function_added) {
		function_manager_save (self);
	}
	result = is_function_added;
	_g_object_unref0 (new_function);
	_g_free0 (function_string);
	return result;
}

MathFunction*
function_manager_get (FunctionManager* self,
                      const gchar* name)
{
	MathFunction* function = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	MathFunction* _tmp2_;
	MathFunction* _tmp3_;
	GHashTable* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gconstpointer _tmp7_;
	MathFunction* _tmp8_;
	MathFunction* _tmp9_;
	MathFunction* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->functions;
	_tmp1_ = g_hash_table_lookup (_tmp0_, name);
	_tmp2_ = _g_object_ref0 ((MathFunction*) _tmp1_);
	function = _tmp2_;
	_tmp3_ = function;
	if (_tmp3_ != NULL) {
		result = function;
		return result;
	}
	_tmp4_ = self->priv->functions;
	_tmp5_ = g_utf8_strdown (name, (gssize) -1);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_hash_table_lookup (_tmp4_, _tmp6_);
	_tmp8_ = _g_object_ref0 ((MathFunction*) _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp6_);
	result = _tmp9_;
	_g_object_unref0 (function);
	return result;
}

void
function_manager_delete (FunctionManager* self,
                         const gchar* name)
{
	MathFunction* function = NULL;
	MathFunction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	MathFunction* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = function_manager_get (self, name);
	function = _tmp0_;
	_tmp2_ = function;
	if (_tmp2_ != NULL) {
		MathFunction* _tmp3_;
		_tmp3_ = function;
		_tmp1_ = math_function_is_custom_function (_tmp3_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GHashTable* _tmp4_;
		MathFunction* _tmp5_;
		_tmp4_ = self->priv->functions;
		g_hash_table_remove (_tmp4_, name);
		function_manager_save (self);
		_tmp5_ = function;
		g_signal_emit (self, function_manager_signals[FUNCTION_MANAGER_FUNCTION_DELETED_SIGNAL], 0, _tmp5_);
	}
	_g_object_unref0 (function);
}

gboolean
function_manager_is_function_defined (FunctionManager* self,
                                      const gchar* name)
{
	gchar* lower_name = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gboolean _tmp6_ = FALSE;
	GHashTable* _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = g_utf8_strdown (name, (gssize) -1);
	lower_name = _tmp0_;
	_tmp2_ = lower_name;
	if (g_str_has_prefix (_tmp2_, "log")) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = lower_name;
		_tmp4_ = string_substring (_tmp3_, (glong) 3, (glong) -1);
		_tmp5_ = _tmp4_;
		_tmp1_ = sub_atoi (_tmp5_) >= 0;
		_g_free0 (_tmp5_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = TRUE;
		_g_free0 (lower_name);
		return result;
	}
	_tmp7_ = self->priv->functions;
	if (g_hash_table_contains (_tmp7_, name)) {
		_tmp6_ = TRUE;
	} else {
		GHashTable* _tmp8_;
		const gchar* _tmp9_;
		_tmp8_ = self->priv->functions;
		_tmp9_ = lower_name;
		_tmp6_ = g_hash_table_contains (_tmp8_, _tmp9_);
	}
	result = _tmp6_;
	_g_free0 (lower_name);
	return result;
}

static Number**
_vala_array_dup4 (Number** self,
                  gssize length)
{
	if (length >= 0) {
		Number** result;
		gssize i;
		result = g_new0 (Number*, length + 1);
		for (i = 0; i < length; i++) {
			Number* _tmp0_;
			_tmp0_ = _g_object_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
_vala_array_add4 (Number** * array,
                  gint* length,
                  gint* size,
                  Number* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Number*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

Number*
function_manager_evaluate_function (FunctionManager* self,
                                    const gchar* name,
                                    Number** arguments,
                                    gint arguments_length1,
                                    Parser* parser)
{
	gchar* lower_name = NULL;
	gchar* _tmp0_;
	Number** args = NULL;
	Number** _tmp1_;
	gint _tmp1__length1;
	gint args_length1;
	gint _args_size_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	MathFunction* function = NULL;
	MathFunction* _tmp15_;
	MathFunction* _tmp16_;
	const gchar* _tmp17_;
	MathFunction* _tmp59_;
	Number** _tmp60_;
	gint _tmp60__length1;
	Number* _tmp61_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (parser != NULL, NULL);
	_tmp0_ = g_utf8_strdown (name, (gssize) -1);
	lower_name = _tmp0_;
	_tmp1_ = (arguments != NULL) ? _vala_array_dup4 (arguments, arguments_length1) : arguments;
	_tmp1__length1 = arguments_length1;
	args = _tmp1_;
	args_length1 = _tmp1__length1;
	_args_size_ = args_length1;
	_tmp3_ = lower_name;
	if (g_str_has_prefix (_tmp3_, "log")) {
		const gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp4_ = lower_name;
		_tmp5_ = strlen (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ > 3;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gint log_base = 0;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gint _tmp10_;
		_tmp7_ = lower_name;
		_tmp8_ = string_substring (_tmp7_, (glong) 3, (glong) -1);
		_tmp9_ = _tmp8_;
		_tmp10_ = sub_atoi (_tmp9_);
		_g_free0 (_tmp9_);
		log_base = _tmp10_;
		if (log_base >= 0) {
			Number** _tmp11_;
			gint _tmp11__length1;
			Number* _tmp14_;
			_tmp11_ = args;
			_tmp11__length1 = args_length1;
			if (_tmp11__length1 > 1) {
				gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp12_ = g_strdup_printf (_ ("Function “%s” takes 1 argument"), name);
				_tmp13_ = _tmp12_;
				number_set_error (_tmp13_);
				_g_free0 (_tmp13_);
				result = NULL;
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_object_unref), NULL);
				_g_free0 (lower_name);
				return result;
			}
			_tmp14_ = number_new_integer ((gint64) log_base, (gint64) 0);
			_vala_array_add4 (&args, &args_length1, &_args_size_, _tmp14_);
			name = "log";
		}
	}
	_tmp15_ = function_manager_get (self, name);
	function = _tmp15_;
	_tmp16_ = function;
	if (_tmp16_ == NULL) {
		parser_set_error (parser, ERROR_CODE_UNKNOWN_FUNCTION, NULL, (guint) 0, (guint) 0);
		result = NULL;
		_g_object_unref0 (function);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_free0 (lower_name);
		return result;
	}
	_tmp17_ = lower_name;
	if (g_strcmp0 (_tmp17_, "log") == 0) {
		Number** _tmp18_;
		gint _tmp18__length1;
		_tmp18_ = args;
		_tmp18__length1 = args_length1;
		if (_tmp18__length1 > 2) {
			gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp19_ = g_strdup_printf (_ ("Function “%s” takes 1 or 2 arguments"), name);
			_tmp20_ = _tmp19_;
			number_set_error (_tmp20_);
			_g_free0 (_tmp20_);
			result = NULL;
			_g_object_unref0 (function);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_object_unref), NULL);
			_g_free0 (lower_name);
			return result;
		}
	} else {
		gboolean _tmp21_ = FALSE;
		const gchar* _tmp22_;
		_tmp22_ = lower_name;
		if (g_strcmp0 (_tmp22_, "stdev") == 0) {
			_tmp21_ = TRUE;
		} else {
			const gchar* _tmp23_;
			_tmp23_ = lower_name;
			_tmp21_ = g_strcmp0 (_tmp23_, "var") == 0;
		}
		if (_tmp21_) {
			Number** _tmp24_;
			gint _tmp24__length1;
			_tmp24_ = args;
			_tmp24__length1 = args_length1;
			if (_tmp24__length1 == 1) {
				gchar* _tmp25_;
				gchar* _tmp26_;
				_tmp25_ = g_strdup_printf (_ ("Function “%s” takes at least 2 arguments"), name);
				_tmp26_ = _tmp25_;
				number_set_error (_tmp26_);
				_g_free0 (_tmp26_);
				result = NULL;
				_g_object_unref0 (function);
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_object_unref), NULL);
				_g_free0 (lower_name);
				return result;
			}
		} else {
			gboolean _tmp27_ = FALSE;
			gboolean _tmp28_ = FALSE;
			Number** _tmp29_;
			gint _tmp29__length1;
			MathFunction* _tmp30_;
			gchar** _tmp31_;
			gint _tmp31__length1;
			gint _tmp32_ = 0;
			gchar** _tmp33_;
			gint _tmp33__length1;
			_tmp29_ = args;
			_tmp29__length1 = args_length1;
			_tmp30_ = function;
			_tmp31_ = math_function_get_arguments (_tmp30_, &_tmp32_);
			_tmp31__length1 = _tmp32_;
			_tmp33_ = _tmp31_;
			_tmp33__length1 = _tmp31__length1;
			if (_tmp29__length1 != _tmp33__length1) {
				MathFunction* _tmp34_;
				gchar** _tmp35_;
				gint _tmp35__length1;
				gint _tmp36_ = 0;
				gchar** _tmp37_;
				gint _tmp37__length1;
				_tmp34_ = function;
				_tmp35_ = math_function_get_arguments (_tmp34_, &_tmp36_);
				_tmp35__length1 = _tmp36_;
				_tmp37_ = _tmp35_;
				_tmp37__length1 = _tmp35__length1;
				_tmp28_ = _tmp37__length1 != 0;
			} else {
				_tmp28_ = FALSE;
			}
			if (_tmp28_) {
				MathFunction* _tmp38_;
				gchar** _tmp39_;
				gint _tmp39__length1;
				gint _tmp40_ = 0;
				gchar** _tmp41_;
				gint _tmp41__length1;
				MathFunction* _tmp42_;
				gchar** _tmp43_;
				gint _tmp43__length1;
				gint _tmp44_ = 0;
				gchar** _tmp45_;
				gint _tmp45__length1;
				const gchar* _tmp46_;
				_tmp38_ = function;
				_tmp39_ = math_function_get_arguments (_tmp38_, &_tmp40_);
				_tmp39__length1 = _tmp40_;
				_tmp41_ = _tmp39_;
				_tmp41__length1 = _tmp39__length1;
				_tmp42_ = function;
				_tmp43_ = math_function_get_arguments (_tmp42_, &_tmp44_);
				_tmp43__length1 = _tmp44_;
				_tmp45_ = _tmp43_;
				_tmp45__length1 = _tmp43__length1;
				_tmp46_ = _tmp41_[_tmp45__length1 - 1];
				_tmp27_ = g_strcmp0 (_tmp46_, "…") != 0;
			} else {
				_tmp27_ = FALSE;
			}
			if (_tmp27_) {
				gchar* _error_ = NULL;
				MathFunction* _tmp47_;
				gchar** _tmp48_;
				gint _tmp48__length1;
				gint _tmp49_ = 0;
				gchar** _tmp50_;
				gint _tmp50__length1;
				gchar* _tmp51_;
				const gchar* _tmp52_;
				MathFunction* _tmp53_;
				gchar** _tmp54_;
				gint _tmp54__length1;
				gint _tmp55_ = 0;
				gchar** _tmp56_;
				gint _tmp56__length1;
				gchar* _tmp57_;
				gchar* _tmp58_;
				_tmp47_ = function;
				_tmp48_ = math_function_get_arguments (_tmp47_, &_tmp49_);
				_tmp48__length1 = _tmp49_;
				_tmp50_ = _tmp48_;
				_tmp50__length1 = _tmp48__length1;
				_tmp51_ = g_strdup (ngettext ("Function “%s” takes %d argument", "Function “%s” takes %d arguments", (gulong) _tmp50__length1));
				_error_ = _tmp51_;
				_tmp52_ = _error_;
				_tmp53_ = function;
				_tmp54_ = math_function_get_arguments (_tmp53_, &_tmp55_);
				_tmp54__length1 = _tmp55_;
				_tmp56_ = _tmp54_;
				_tmp56__length1 = _tmp54__length1;
				_tmp57_ = g_strdup_printf (_tmp52_, name, _tmp56__length1);
				_tmp58_ = _tmp57_;
				number_set_error (_tmp58_);
				_g_free0 (_tmp58_);
				result = NULL;
				_g_free0 (_error_);
				_g_object_unref0 (function);
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_object_unref), NULL);
				_g_free0 (lower_name);
				return result;
			}
		}
	}
	_tmp59_ = function;
	_tmp60_ = args;
	_tmp60__length1 = args_length1;
	_tmp61_ = math_function_evaluate (_tmp59_, _tmp60_, (gint) _tmp60__length1, parser);
	result = _tmp61_;
	_g_object_unref0 (function);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_free0 (lower_name);
	return result;
}

static MathFunction**
_vala_array_dup5 (MathFunction** self,
                  gssize length)
{
	if (length >= 0) {
		MathFunction** result;
		gssize i;
		result = g_new0 (MathFunction*, length + 1);
		for (i = 0; i < length; i++) {
			MathFunction* _tmp0_;
			_tmp0_ = _g_object_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static MathFunction**
_vala_array_dup6 (MathFunction** self,
                  gssize length)
{
	if (length >= 0) {
		MathFunction** result;
		gssize i;
		result = g_new0 (MathFunction*, length + 1);
		for (i = 0; i < length; i++) {
			MathFunction* _tmp0_;
			_tmp0_ = _g_object_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static MathFunction**
function_manager_array_sort_math_function (FunctionManager* self,
                                           MathFunction** array,
                                           gint array_length1,
                                           gint* result_length1)
{
	gboolean swapped = FALSE;
	gint _tmp2_ = 0;
	MathFunction* _tmp3_;
	gint j = 0;
	MathFunction* tmp = NULL;
	MathFunction** _tmp21_;
	gint _tmp21__length1;
	MathFunction** _tmp22_;
	gint _tmp22__length1;
	MathFunction** result;
	g_return_val_if_fail (self != NULL, NULL);
	if (array_length1 == 0) {
		MathFunction** _tmp0_;
		gint _tmp0__length1;
		MathFunction** _tmp1_;
		gint _tmp1__length1;
		_tmp0_ = (array != NULL) ? _vala_array_dup5 (array, array_length1) : array;
		_tmp0__length1 = array_length1;
		_tmp1_ = _tmp0_;
		_tmp1__length1 = _tmp0__length1;
		if (result_length1) {
			*result_length1 = _tmp1__length1;
		}
		result = _tmp1_;
		return result;
	}
	swapped = TRUE;
	_tmp3_ = array[array_length1 - 1];
	if (_tmp3_ == NULL) {
		_tmp2_ = 1;
	} else {
		_tmp2_ = 0;
	}
	j = _tmp2_;
	while (TRUE) {
		gint _tmp4_;
		gint _tmp5_;
		if (!swapped) {
			break;
		}
		swapped = FALSE;
		_tmp4_ = j;
		j = _tmp4_ + 1;
		_tmp5_ = j;
		_vala_assert ((0 <= _tmp5_) && (_tmp5_ <= array_length1), "0 <= j <= array.length");
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp6_ = FALSE;
				_tmp6_ = TRUE;
				while (TRUE) {
					gint _tmp8_;
					MathFunction* _tmp9_;
					const gchar* _tmp10_;
					const gchar* _tmp11_;
					MathFunction* _tmp12_;
					const gchar* _tmp13_;
					const gchar* _tmp14_;
					if (!_tmp6_) {
						gint _tmp7_;
						_tmp7_ = i;
						i = _tmp7_ + 1;
					}
					_tmp6_ = FALSE;
					if (!(i < (array_length1 - j))) {
						break;
					}
					_tmp8_ = i + 1;
					_vala_assert ((0 <= _tmp8_) && (_tmp8_ < array_length1), "0 <= (i+1) < array.length");
					_tmp9_ = array[i];
					_tmp10_ = math_function_get_name (_tmp9_);
					_tmp11_ = _tmp10_;
					_tmp12_ = array[i + 1];
					_tmp13_ = math_function_get_name (_tmp12_);
					_tmp14_ = _tmp13_;
					if (g_strcmp0 (_tmp11_, _tmp14_) > 0) {
						MathFunction* _tmp15_;
						MathFunction* _tmp16_;
						MathFunction* _tmp17_;
						MathFunction* _tmp18_;
						MathFunction* _tmp19_;
						MathFunction* _tmp20_;
						_tmp15_ = array[i];
						_tmp16_ = _g_object_ref0 (_tmp15_);
						_g_object_unref0 (tmp);
						tmp = _tmp16_;
						_tmp17_ = array[i + 1];
						_tmp18_ = _g_object_ref0 (_tmp17_);
						_g_object_unref0 (array[i]);
						array[i] = _tmp18_;
						_tmp19_ = tmp;
						_tmp20_ = _g_object_ref0 (_tmp19_);
						_g_object_unref0 (array[i + 1]);
						array[i + 1] = _tmp20_;
						swapped = TRUE;
					}
				}
			}
		}
	}
	_tmp21_ = (array != NULL) ? _vala_array_dup6 (array, array_length1) : array;
	_tmp21__length1 = array_length1;
	_tmp22_ = _tmp21_;
	_tmp22__length1 = _tmp21__length1;
	if (result_length1) {
		*result_length1 = _tmp22__length1;
	}
	result = _tmp22_;
	_g_object_unref0 (tmp);
	return result;
}

static void
_vala_array_add5 (MathFunction** * array,
                  gint* length,
                  gint* size,
                  MathFunction* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (MathFunction*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

MathFunction**
function_manager_functions_eligible_for_autocompletion (FunctionManager* self,
                                                        const gchar* text,
                                                        gint* result_length1)
{
	MathFunction** eligible_functions = NULL;
	MathFunction** _tmp0_;
	gint eligible_functions_length1;
	gint _eligible_functions_size_;
	gchar* text_case_insensitive = NULL;
	gchar* _tmp1_;
	GHashTableIter iter = {0};
	GHashTable* _tmp2_;
	gchar* function_name = NULL;
	MathFunction* function = NULL;
	MathFunction** _tmp14_;
	gint _tmp14__length1;
	gint _tmp15_ = 0;
	MathFunction** _tmp16_;
	MathFunction** _tmp17_;
	gint _tmp17__length1;
	MathFunction** result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = g_new0 (MathFunction*, 0 + 1);
	eligible_functions = _tmp0_;
	eligible_functions_length1 = 0;
	_eligible_functions_size_ = eligible_functions_length1;
	_tmp1_ = g_utf8_strdown (text, (gssize) -1);
	text_case_insensitive = _tmp1_;
	_tmp2_ = self->priv->functions;
	g_hash_table_iter_init (&iter, _tmp2_);
	while (TRUE) {
		gconstpointer _tmp3_ = NULL;
		gconstpointer _tmp4_ = NULL;
		gboolean _tmp5_;
		gchar* _tmp6_;
		MathFunction* _tmp7_;
		gchar* function_name_case_insensitive = NULL;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp5_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp3_), (gpointer*) (&_tmp4_));
		_g_free0 (function_name);
		_tmp6_ = g_strdup ((const gchar*) _tmp3_);
		function_name = _tmp6_;
		_g_object_unref0 (function);
		_tmp7_ = _g_object_ref0 ((MathFunction*) _tmp4_);
		function = _tmp7_;
		if (!_tmp5_) {
			break;
		}
		_tmp8_ = function_name;
		_tmp9_ = g_utf8_strdown (_tmp8_, (gssize) -1);
		function_name_case_insensitive = _tmp9_;
		_tmp10_ = function_name_case_insensitive;
		_tmp11_ = text_case_insensitive;
		if (g_str_has_prefix (_tmp10_, _tmp11_)) {
			MathFunction* _tmp12_;
			MathFunction* _tmp13_;
			_tmp12_ = function;
			_tmp13_ = _g_object_ref0 (_tmp12_);
			_vala_array_add5 (&eligible_functions, &eligible_functions_length1, &_eligible_functions_size_, _tmp13_);
		}
		_g_free0 (function_name_case_insensitive);
	}
	_tmp14_ = eligible_functions;
	_tmp14__length1 = eligible_functions_length1;
	_tmp16_ = function_manager_array_sort_math_function (self, _tmp14_, (gint) _tmp14__length1, &_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp17__length1 = _tmp15_;
	if (result_length1) {
		*result_length1 = _tmp17__length1;
	}
	result = _tmp17_;
	_g_object_unref0 (function);
	_g_free0 (function_name);
	_g_free0 (text_case_insensitive);
	eligible_functions = (_vala_array_free (eligible_functions, eligible_functions_length1, (GDestroyNotify) g_object_unref), NULL);
	return result;
}

static void
function_manager_class_init (FunctionManagerClass * klass,
                             gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	BuiltInMathFunction* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	BuiltInMathFunction* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	BuiltInMathFunction* _tmp12_;
	gchar* _tmp13_;
	gchar** _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	BuiltInMathFunction* _tmp16_;
	gchar* _tmp17_;
	gchar** _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	BuiltInMathFunction* _tmp20_;
	gchar* _tmp21_;
	gchar** _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	BuiltInMathFunction* _tmp24_;
	gchar* _tmp25_;
	gchar** _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	BuiltInMathFunction* _tmp28_;
	gchar* _tmp29_;
	gchar** _tmp30_;
	gchar** _tmp31_;
	gint _tmp31__length1;
	BuiltInMathFunction* _tmp32_;
	gchar* _tmp33_;
	gchar** _tmp34_;
	gchar** _tmp35_;
	gint _tmp35__length1;
	BuiltInMathFunction* _tmp36_;
	gchar* _tmp37_;
	gchar** _tmp38_;
	gchar** _tmp39_;
	gint _tmp39__length1;
	BuiltInMathFunction* _tmp40_;
	gchar* _tmp41_;
	gchar** _tmp42_;
	gchar** _tmp43_;
	gint _tmp43__length1;
	BuiltInMathFunction* _tmp44_;
	gchar* _tmp45_;
	gchar** _tmp46_;
	gchar** _tmp47_;
	gint _tmp47__length1;
	BuiltInMathFunction* _tmp48_;
	MathFunction** _tmp49_;
	FunctionCategory _tmp50_ = {0};
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar** _tmp53_;
	gchar** _tmp54_;
	gint _tmp54__length1;
	BuiltInMathFunction* _tmp55_;
	gchar* _tmp56_;
	gchar** _tmp57_;
	gchar** _tmp58_;
	gint _tmp58__length1;
	BuiltInMathFunction* _tmp59_;
	gchar* _tmp60_;
	gchar** _tmp61_;
	gchar** _tmp62_;
	gint _tmp62__length1;
	BuiltInMathFunction* _tmp63_;
	gchar* _tmp64_;
	gchar** _tmp65_;
	gchar** _tmp66_;
	gint _tmp66__length1;
	BuiltInMathFunction* _tmp67_;
	MathFunction** _tmp68_;
	FunctionCategory _tmp69_ = {0};
	gchar* _tmp70_;
	gchar* _tmp71_;
	gchar** _tmp72_;
	gchar** _tmp73_;
	gint _tmp73__length1;
	BuiltInMathFunction* _tmp74_;
	gchar* _tmp75_;
	gchar** _tmp76_;
	gchar** _tmp77_;
	gint _tmp77__length1;
	BuiltInMathFunction* _tmp78_;
	gchar* _tmp79_;
	gchar** _tmp80_;
	gchar** _tmp81_;
	gint _tmp81__length1;
	BuiltInMathFunction* _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	gchar** _tmp85_;
	gchar** _tmp86_;
	gint _tmp86__length1;
	BuiltInMathFunction* _tmp87_;
	gchar* _tmp88_;
	gchar* _tmp89_;
	gchar* _tmp90_;
	gchar** _tmp91_;
	gchar** _tmp92_;
	gint _tmp92__length1;
	BuiltInMathFunction* _tmp93_;
	MathFunction** _tmp94_;
	FunctionCategory _tmp95_ = {0};
	gchar* _tmp96_;
	gchar* _tmp97_;
	gchar** _tmp98_;
	gchar** _tmp99_;
	gint _tmp99__length1;
	BuiltInMathFunction* _tmp100_;
	gchar* _tmp101_;
	gchar** _tmp102_;
	gchar** _tmp103_;
	gint _tmp103__length1;
	BuiltInMathFunction* _tmp104_;
	gchar* _tmp105_;
	gchar** _tmp106_;
	gchar** _tmp107_;
	gint _tmp107__length1;
	BuiltInMathFunction* _tmp108_;
	gchar* _tmp109_;
	gchar** _tmp110_;
	gchar** _tmp111_;
	gint _tmp111__length1;
	BuiltInMathFunction* _tmp112_;
	gchar* _tmp113_;
	gchar** _tmp114_;
	gchar** _tmp115_;
	gint _tmp115__length1;
	BuiltInMathFunction* _tmp116_;
	MathFunction** _tmp117_;
	FunctionCategory _tmp118_ = {0};
	gchar* _tmp119_;
	gchar* _tmp120_;
	gchar* _tmp121_;
	gchar* _tmp122_;
	gchar** _tmp123_;
	gchar** _tmp124_;
	gint _tmp124__length1;
	BuiltInMathFunction* _tmp125_;
	gchar* _tmp126_;
	gchar* _tmp127_;
	gchar* _tmp128_;
	gchar** _tmp129_;
	gchar** _tmp130_;
	gint _tmp130__length1;
	BuiltInMathFunction* _tmp131_;
	gchar* _tmp132_;
	gchar* _tmp133_;
	gchar* _tmp134_;
	gchar** _tmp135_;
	gchar** _tmp136_;
	gint _tmp136__length1;
	BuiltInMathFunction* _tmp137_;
	gchar* _tmp138_;
	gchar* _tmp139_;
	gchar* _tmp140_;
	gchar** _tmp141_;
	gchar** _tmp142_;
	gint _tmp142__length1;
	BuiltInMathFunction* _tmp143_;
	gchar* _tmp144_;
	gchar* _tmp145_;
	gchar* _tmp146_;
	gchar** _tmp147_;
	gchar** _tmp148_;
	gint _tmp148__length1;
	BuiltInMathFunction* _tmp149_;
	gchar* _tmp150_;
	gchar* _tmp151_;
	gchar* _tmp152_;
	gchar** _tmp153_;
	gchar** _tmp154_;
	gint _tmp154__length1;
	BuiltInMathFunction* _tmp155_;
	gchar* _tmp156_;
	gchar* _tmp157_;
	gchar* _tmp158_;
	gchar** _tmp159_;
	gchar** _tmp160_;
	gint _tmp160__length1;
	BuiltInMathFunction* _tmp161_;
	gchar* _tmp162_;
	gchar* _tmp163_;
	gchar* _tmp164_;
	gchar** _tmp165_;
	gchar** _tmp166_;
	gint _tmp166__length1;
	BuiltInMathFunction* _tmp167_;
	gchar* _tmp168_;
	gchar* _tmp169_;
	gchar* _tmp170_;
	gchar** _tmp171_;
	gchar** _tmp172_;
	gint _tmp172__length1;
	BuiltInMathFunction* _tmp173_;
	gchar* _tmp174_;
	gchar* _tmp175_;
	gchar* _tmp176_;
	gchar** _tmp177_;
	gchar** _tmp178_;
	gint _tmp178__length1;
	BuiltInMathFunction* _tmp179_;
	MathFunction** _tmp180_;
	FunctionCategory _tmp181_ = {0};
	gchar* _tmp182_;
	gchar* _tmp183_;
	gchar* _tmp184_;
	gchar** _tmp185_;
	gchar** _tmp186_;
	gint _tmp186__length1;
	BuiltInMathFunction* _tmp187_;
	gchar* _tmp188_;
	gchar** _tmp189_;
	gchar** _tmp190_;
	gint _tmp190__length1;
	BuiltInMathFunction* _tmp191_;
	gchar* _tmp192_;
	gchar** _tmp193_;
	gchar** _tmp194_;
	gint _tmp194__length1;
	BuiltInMathFunction* _tmp195_;
	gchar* _tmp196_;
	gchar** _tmp197_;
	gchar** _tmp198_;
	gint _tmp198__length1;
	BuiltInMathFunction* _tmp199_;
	gchar* _tmp200_;
	gchar** _tmp201_;
	gchar** _tmp202_;
	gint _tmp202__length1;
	BuiltInMathFunction* _tmp203_;
	gchar* _tmp204_;
	gchar* _tmp205_;
	gchar** _tmp206_;
	gchar** _tmp207_;
	gint _tmp207__length1;
	BuiltInMathFunction* _tmp208_;
	gchar* _tmp209_;
	gchar* _tmp210_;
	gchar** _tmp211_;
	gchar** _tmp212_;
	gint _tmp212__length1;
	BuiltInMathFunction* _tmp213_;
	gchar* _tmp214_;
	gchar* _tmp215_;
	gchar* _tmp216_;
	gchar** _tmp217_;
	gchar** _tmp218_;
	gint _tmp218__length1;
	BuiltInMathFunction* _tmp219_;
	gchar* _tmp220_;
	gchar* _tmp221_;
	gchar* _tmp222_;
	gchar** _tmp223_;
	gchar** _tmp224_;
	gint _tmp224__length1;
	BuiltInMathFunction* _tmp225_;
	gchar* _tmp226_;
	gchar* _tmp227_;
	gchar** _tmp228_;
	gchar** _tmp229_;
	gint _tmp229__length1;
	BuiltInMathFunction* _tmp230_;
	MathFunction** _tmp231_;
	FunctionCategory _tmp232_ = {0};
	FunctionCategory* _tmp233_;
	function_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FunctionManager_private_offset);
	G_OBJECT_CLASS (klass)->finalize = function_manager_finalize;
	function_manager_signals[FUNCTION_MANAGER_FUNCTION_ADDED_SIGNAL] = g_signal_new ("function-added", TYPE_FUNCTION_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_MATH_FUNCTION);
	function_manager_signals[FUNCTION_MANAGER_FUNCTION_EDITED_SIGNAL] = g_signal_new ("function-edited", TYPE_FUNCTION_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_MATH_FUNCTION);
	function_manager_signals[FUNCTION_MANAGER_FUNCTION_DELETED_SIGNAL] = g_signal_new ("function-deleted", TYPE_FUNCTION_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_MATH_FUNCTION);
	_tmp0_ = g_strdup (_ ("Trigonometry"));
	_tmp1_ = g_strdup ("x");
	_tmp2_ = g_new0 (gchar*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	_tmp4_ = built_in_math_function_new ("sin", _ ("Sine"), _tmp3_, 1);
	_tmp5_ = g_strdup ("x");
	_tmp6_ = g_new0 (gchar*, 1 + 1);
	_tmp6_[0] = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 1;
	_tmp8_ = built_in_math_function_new ("cos", _ ("Cosine"), _tmp7_, 1);
	_tmp9_ = g_strdup ("x");
	_tmp10_ = g_new0 (gchar*, 1 + 1);
	_tmp10_[0] = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 1;
	_tmp12_ = built_in_math_function_new ("tan", _ ("Tangent"), _tmp11_, 1);
	_tmp13_ = g_strdup ("x");
	_tmp14_ = g_new0 (gchar*, 1 + 1);
	_tmp14_[0] = _tmp13_;
	_tmp15_ = _tmp14_;
	_tmp15__length1 = 1;
	_tmp16_ = built_in_math_function_new ("sin⁻¹", _ ("Inverse Sine"), _tmp15_, 1);
	_tmp17_ = g_strdup ("x");
	_tmp18_ = g_new0 (gchar*, 1 + 1);
	_tmp18_[0] = _tmp17_;
	_tmp19_ = _tmp18_;
	_tmp19__length1 = 1;
	_tmp20_ = built_in_math_function_new ("cos⁻¹", _ ("Inverse Cosine"), _tmp19_, 1);
	_tmp21_ = g_strdup ("x");
	_tmp22_ = g_new0 (gchar*, 1 + 1);
	_tmp22_[0] = _tmp21_;
	_tmp23_ = _tmp22_;
	_tmp23__length1 = 1;
	_tmp24_ = built_in_math_function_new ("tan⁻¹", _ ("Inverse Tangent"), _tmp23_, 1);
	_tmp25_ = g_strdup ("x");
	_tmp26_ = g_new0 (gchar*, 1 + 1);
	_tmp26_[0] = _tmp25_;
	_tmp27_ = _tmp26_;
	_tmp27__length1 = 1;
	_tmp28_ = built_in_math_function_new ("sinh", _ ("Hyperbolic Sine"), _tmp27_, 1);
	_tmp29_ = g_strdup ("x");
	_tmp30_ = g_new0 (gchar*, 1 + 1);
	_tmp30_[0] = _tmp29_;
	_tmp31_ = _tmp30_;
	_tmp31__length1 = 1;
	_tmp32_ = built_in_math_function_new ("cosh", _ ("Hyperbolic Cosine"), _tmp31_, 1);
	_tmp33_ = g_strdup ("x");
	_tmp34_ = g_new0 (gchar*, 1 + 1);
	_tmp34_[0] = _tmp33_;
	_tmp35_ = _tmp34_;
	_tmp35__length1 = 1;
	_tmp36_ = built_in_math_function_new ("tanh", _ ("Hyperbolic Tangent"), _tmp35_, 1);
	_tmp37_ = g_strdup ("x");
	_tmp38_ = g_new0 (gchar*, 1 + 1);
	_tmp38_[0] = _tmp37_;
	_tmp39_ = _tmp38_;
	_tmp39__length1 = 1;
	_tmp40_ = built_in_math_function_new ("sinh⁻¹", _ ("Inverse Hyperbolic Sine"), _tmp39_, 1);
	_tmp41_ = g_strdup ("x");
	_tmp42_ = g_new0 (gchar*, 1 + 1);
	_tmp42_[0] = _tmp41_;
	_tmp43_ = _tmp42_;
	_tmp43__length1 = 1;
	_tmp44_ = built_in_math_function_new ("cosh⁻¹", _ ("Inverse Hyperbolic Cosine"), _tmp43_, 1);
	_tmp45_ = g_strdup ("x");
	_tmp46_ = g_new0 (gchar*, 1 + 1);
	_tmp46_[0] = _tmp45_;
	_tmp47_ = _tmp46_;
	_tmp47__length1 = 1;
	_tmp48_ = built_in_math_function_new ("tanh⁻¹", _ ("Inverse Hyperbolic Tangent"), _tmp47_, 1);
	_tmp49_ = g_new0 (MathFunction*, 12 + 1);
	_tmp49_[0] = (MathFunction*) _tmp4_;
	_tmp49_[1] = (MathFunction*) _tmp8_;
	_tmp49_[2] = (MathFunction*) _tmp12_;
	_tmp49_[3] = (MathFunction*) _tmp16_;
	_tmp49_[4] = (MathFunction*) _tmp20_;
	_tmp49_[5] = (MathFunction*) _tmp24_;
	_tmp49_[6] = (MathFunction*) _tmp28_;
	_tmp49_[7] = (MathFunction*) _tmp32_;
	_tmp49_[8] = (MathFunction*) _tmp36_;
	_tmp49_[9] = (MathFunction*) _tmp40_;
	_tmp49_[10] = (MathFunction*) _tmp44_;
	_tmp49_[11] = (MathFunction*) _tmp48_;
	memset (&_tmp50_, 0, sizeof (FunctionCategory));
	_g_free0 (_tmp50_.name);
	_tmp50_.name = _tmp0_;
	_tmp50_.functions = (_vala_array_free (_tmp50_.functions, _tmp50_.functions_length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp50_.functions = _tmp49_;
	_tmp50_.functions_length1 = 12;
	_tmp51_ = g_strdup (_ ("Complex"));
	_tmp52_ = g_strdup ("x");
	_tmp53_ = g_new0 (gchar*, 1 + 1);
	_tmp53_[0] = _tmp52_;
	_tmp54_ = _tmp53_;
	_tmp54__length1 = 1;
	_tmp55_ = built_in_math_function_new ("conj", _ ("Complex Conjugate"), _tmp54_, 1);
	_tmp56_ = g_strdup ("x");
	_tmp57_ = g_new0 (gchar*, 1 + 1);
	_tmp57_[0] = _tmp56_;
	_tmp58_ = _tmp57_;
	_tmp58__length1 = 1;
	_tmp59_ = built_in_math_function_new ("arg", _ ("Complex Argument"), _tmp58_, 1);
	_tmp60_ = g_strdup ("x");
	_tmp61_ = g_new0 (gchar*, 1 + 1);
	_tmp61_[0] = _tmp60_;
	_tmp62_ = _tmp61_;
	_tmp62__length1 = 1;
	_tmp63_ = built_in_math_function_new ("re", _ ("Real Component"), _tmp62_, 1);
	_tmp64_ = g_strdup ("x");
	_tmp65_ = g_new0 (gchar*, 1 + 1);
	_tmp65_[0] = _tmp64_;
	_tmp66_ = _tmp65_;
	_tmp66__length1 = 1;
	_tmp67_ = built_in_math_function_new ("im", _ ("Imaginary Component"), _tmp66_, 1);
	_tmp68_ = g_new0 (MathFunction*, 4 + 1);
	_tmp68_[0] = (MathFunction*) _tmp55_;
	_tmp68_[1] = (MathFunction*) _tmp59_;
	_tmp68_[2] = (MathFunction*) _tmp63_;
	_tmp68_[3] = (MathFunction*) _tmp67_;
	memset (&_tmp69_, 0, sizeof (FunctionCategory));
	_g_free0 (_tmp69_.name);
	_tmp69_.name = _tmp51_;
	_tmp69_.functions = (_vala_array_free (_tmp69_.functions, _tmp69_.functions_length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp69_.functions = _tmp68_;
	_tmp69_.functions_length1 = 4;
	_tmp70_ = g_strdup (_ ("Programming"));
	_tmp71_ = g_strdup ("x");
	_tmp72_ = g_new0 (gchar*, 1 + 1);
	_tmp72_[0] = _tmp71_;
	_tmp73_ = _tmp72_;
	_tmp73__length1 = 1;
	_tmp74_ = built_in_math_function_new ("ones", _ ("Ones’ Complement"), _tmp73_, 1);
	_tmp75_ = g_strdup ("x");
	_tmp76_ = g_new0 (gchar*, 1 + 1);
	_tmp76_[0] = _tmp75_;
	_tmp77_ = _tmp76_;
	_tmp77__length1 = 1;
	_tmp78_ = built_in_math_function_new ("twos", _ ("Two’s Complement"), _tmp77_, 1);
	_tmp79_ = g_strdup ("x");
	_tmp80_ = g_new0 (gchar*, 1 + 1);
	_tmp80_[0] = _tmp79_;
	_tmp81_ = _tmp80_;
	_tmp81__length1 = 1;
	_tmp82_ = built_in_math_function_new ("bswap", _ ("Swap Endianness"), _tmp81_, 1);
	_tmp83_ = g_strdup ("x");
	_tmp84_ = g_strdup ("y");
	_tmp85_ = g_new0 (gchar*, 2 + 1);
	_tmp85_[0] = _tmp83_;
	_tmp85_[1] = _tmp84_;
	_tmp86_ = _tmp85_;
	_tmp86__length1 = 2;
	_tmp87_ = built_in_math_function_new ("mod", _ ("Modulus Divide"), _tmp86_, 2);
	_tmp88_ = g_strdup ("x");
	_tmp89_ = g_strdup ("y");
	_tmp90_ = g_strdup ("p");
	_tmp91_ = g_new0 (gchar*, 3 + 1);
	_tmp91_[0] = _tmp88_;
	_tmp91_[1] = _tmp89_;
	_tmp91_[2] = _tmp90_;
	_tmp92_ = _tmp91_;
	_tmp92__length1 = 3;
	_tmp93_ = built_in_math_function_new ("modexp", _ ("Modular Exponentiation"), _tmp92_, 3);
	_tmp94_ = g_new0 (MathFunction*, 5 + 1);
	_tmp94_[0] = (MathFunction*) _tmp74_;
	_tmp94_[1] = (MathFunction*) _tmp78_;
	_tmp94_[2] = (MathFunction*) _tmp82_;
	_tmp94_[3] = (MathFunction*) _tmp87_;
	_tmp94_[4] = (MathFunction*) _tmp93_;
	memset (&_tmp95_, 0, sizeof (FunctionCategory));
	_g_free0 (_tmp95_.name);
	_tmp95_.name = _tmp70_;
	_tmp95_.functions = (_vala_array_free (_tmp95_.functions, _tmp95_.functions_length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp95_.functions = _tmp94_;
	_tmp95_.functions_length1 = 5;
	_tmp96_ = g_strdup (_ ("Rounding"));
	_tmp97_ = g_strdup ("x");
	_tmp98_ = g_new0 (gchar*, 1 + 1);
	_tmp98_[0] = _tmp97_;
	_tmp99_ = _tmp98_;
	_tmp99__length1 = 1;
	_tmp100_ = built_in_math_function_new ("round", _ ("Round"), _tmp99_, 1);
	_tmp101_ = g_strdup ("x");
	_tmp102_ = g_new0 (gchar*, 1 + 1);
	_tmp102_[0] = _tmp101_;
	_tmp103_ = _tmp102_;
	_tmp103__length1 = 1;
	_tmp104_ = built_in_math_function_new ("floor", _ ("Floor"), _tmp103_, 1);
	_tmp105_ = g_strdup ("x");
	_tmp106_ = g_new0 (gchar*, 1 + 1);
	_tmp106_[0] = _tmp105_;
	_tmp107_ = _tmp106_;
	_tmp107__length1 = 1;
	_tmp108_ = built_in_math_function_new ("ceil", _ ("Ceiling"), _tmp107_, 1);
	_tmp109_ = g_strdup ("x");
	_tmp110_ = g_new0 (gchar*, 1 + 1);
	_tmp110_[0] = _tmp109_;
	_tmp111_ = _tmp110_;
	_tmp111__length1 = 1;
	_tmp112_ = built_in_math_function_new ("int", _ ("Integer Component"), _tmp111_, 1);
	_tmp113_ = g_strdup ("x");
	_tmp114_ = g_new0 (gchar*, 1 + 1);
	_tmp114_[0] = _tmp113_;
	_tmp115_ = _tmp114_;
	_tmp115__length1 = 1;
	_tmp116_ = built_in_math_function_new ("frac", _ ("Fractional Component"), _tmp115_, 1);
	_tmp117_ = g_new0 (MathFunction*, 5 + 1);
	_tmp117_[0] = (MathFunction*) _tmp100_;
	_tmp117_[1] = (MathFunction*) _tmp104_;
	_tmp117_[2] = (MathFunction*) _tmp108_;
	_tmp117_[3] = (MathFunction*) _tmp112_;
	_tmp117_[4] = (MathFunction*) _tmp116_;
	memset (&_tmp118_, 0, sizeof (FunctionCategory));
	_g_free0 (_tmp118_.name);
	_tmp118_.name = _tmp96_;
	_tmp118_.functions = (_vala_array_free (_tmp118_.functions, _tmp118_.functions_length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp118_.functions = _tmp117_;
	_tmp118_.functions_length1 = 5;
	_tmp119_ = g_strdup (_ ("Statistics"));
	_tmp120_ = g_strdup ("x₁");
	_tmp121_ = g_strdup ("x₂");
	_tmp122_ = g_strdup ("…");
	_tmp123_ = g_new0 (gchar*, 3 + 1);
	_tmp123_[0] = _tmp120_;
	_tmp123_[1] = _tmp121_;
	_tmp123_[2] = _tmp122_;
	_tmp124_ = _tmp123_;
	_tmp124__length1 = 3;
	_tmp125_ = built_in_math_function_new ("sum", _ ("Sum"), _tmp124_, 3);
	_tmp126_ = g_strdup ("x₁");
	_tmp127_ = g_strdup ("x₂");
	_tmp128_ = g_strdup ("…");
	_tmp129_ = g_new0 (gchar*, 3 + 1);
	_tmp129_[0] = _tmp126_;
	_tmp129_[1] = _tmp127_;
	_tmp129_[2] = _tmp128_;
	_tmp130_ = _tmp129_;
	_tmp130__length1 = 3;
	_tmp131_ = built_in_math_function_new ("sumsq", _ ("Sum of Squares"), _tmp130_, 3);
	_tmp132_ = g_strdup ("x₁");
	_tmp133_ = g_strdup ("x₂");
	_tmp134_ = g_strdup ("…");
	_tmp135_ = g_new0 (gchar*, 3 + 1);
	_tmp135_[0] = _tmp132_;
	_tmp135_[1] = _tmp133_;
	_tmp135_[2] = _tmp134_;
	_tmp136_ = _tmp135_;
	_tmp136__length1 = 3;
	_tmp137_ = built_in_math_function_new ("average", _ ("Average"), _tmp136_, 3);
	_tmp138_ = g_strdup ("x₁");
	_tmp139_ = g_strdup ("x₂");
	_tmp140_ = g_strdup ("…");
	_tmp141_ = g_new0 (gchar*, 3 + 1);
	_tmp141_[0] = _tmp138_;
	_tmp141_[1] = _tmp139_;
	_tmp141_[2] = _tmp140_;
	_tmp142_ = _tmp141_;
	_tmp142__length1 = 3;
	_tmp143_ = built_in_math_function_new ("median", _ ("Median"), _tmp142_, 3);
	_tmp144_ = g_strdup ("x₁");
	_tmp145_ = g_strdup ("x₂");
	_tmp146_ = g_strdup ("…");
	_tmp147_ = g_new0 (gchar*, 3 + 1);
	_tmp147_[0] = _tmp144_;
	_tmp147_[1] = _tmp145_;
	_tmp147_[2] = _tmp146_;
	_tmp148_ = _tmp147_;
	_tmp148__length1 = 3;
	_tmp149_ = built_in_math_function_new ("min", _ ("Minimum Value"), _tmp148_, 3);
	_tmp150_ = g_strdup ("x₁");
	_tmp151_ = g_strdup ("x₂");
	_tmp152_ = g_strdup ("…");
	_tmp153_ = g_new0 (gchar*, 3 + 1);
	_tmp153_[0] = _tmp150_;
	_tmp153_[1] = _tmp151_;
	_tmp153_[2] = _tmp152_;
	_tmp154_ = _tmp153_;
	_tmp154__length1 = 3;
	_tmp155_ = built_in_math_function_new ("max", _ ("Maximum Value"), _tmp154_, 3);
	_tmp156_ = g_strdup ("x₁");
	_tmp157_ = g_strdup ("x₂");
	_tmp158_ = g_strdup ("…");
	_tmp159_ = g_new0 (gchar*, 3 + 1);
	_tmp159_[0] = _tmp156_;
	_tmp159_[1] = _tmp157_;
	_tmp159_[2] = _tmp158_;
	_tmp160_ = _tmp159_;
	_tmp160__length1 = 3;
	_tmp161_ = built_in_math_function_new ("stdev", _ ("Sample Standard Deviation"), _tmp160_, 3);
	_tmp162_ = g_strdup ("x₁");
	_tmp163_ = g_strdup ("x₂");
	_tmp164_ = g_strdup ("…");
	_tmp165_ = g_new0 (gchar*, 3 + 1);
	_tmp165_[0] = _tmp162_;
	_tmp165_[1] = _tmp163_;
	_tmp165_[2] = _tmp164_;
	_tmp166_ = _tmp165_;
	_tmp166__length1 = 3;
	_tmp167_ = built_in_math_function_new ("stdevp", _ ("Population Standard Deviation"), _tmp166_, 3);
	_tmp168_ = g_strdup ("x₁");
	_tmp169_ = g_strdup ("x₂");
	_tmp170_ = g_strdup ("…");
	_tmp171_ = g_new0 (gchar*, 3 + 1);
	_tmp171_[0] = _tmp168_;
	_tmp171_[1] = _tmp169_;
	_tmp171_[2] = _tmp170_;
	_tmp172_ = _tmp171_;
	_tmp172__length1 = 3;
	_tmp173_ = built_in_math_function_new ("var", _ ("Sample Variance"), _tmp172_, 3);
	_tmp174_ = g_strdup ("x₁");
	_tmp175_ = g_strdup ("x₂");
	_tmp176_ = g_strdup ("…");
	_tmp177_ = g_new0 (gchar*, 3 + 1);
	_tmp177_[0] = _tmp174_;
	_tmp177_[1] = _tmp175_;
	_tmp177_[2] = _tmp176_;
	_tmp178_ = _tmp177_;
	_tmp178__length1 = 3;
	_tmp179_ = built_in_math_function_new ("varp", _ ("Population Variance"), _tmp178_, 3);
	_tmp180_ = g_new0 (MathFunction*, 10 + 1);
	_tmp180_[0] = (MathFunction*) _tmp125_;
	_tmp180_[1] = (MathFunction*) _tmp131_;
	_tmp180_[2] = (MathFunction*) _tmp137_;
	_tmp180_[3] = (MathFunction*) _tmp143_;
	_tmp180_[4] = (MathFunction*) _tmp149_;
	_tmp180_[5] = (MathFunction*) _tmp155_;
	_tmp180_[6] = (MathFunction*) _tmp161_;
	_tmp180_[7] = (MathFunction*) _tmp167_;
	_tmp180_[8] = (MathFunction*) _tmp173_;
	_tmp180_[9] = (MathFunction*) _tmp179_;
	memset (&_tmp181_, 0, sizeof (FunctionCategory));
	_g_free0 (_tmp181_.name);
	_tmp181_.name = _tmp119_;
	_tmp181_.functions = (_vala_array_free (_tmp181_.functions, _tmp181_.functions_length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp181_.functions = _tmp180_;
	_tmp181_.functions_length1 = 10;
	_tmp182_ = g_strdup (_ ("Sundry"));
	_tmp183_ = g_strdup ("x");
	_tmp184_ = g_strdup ("[y]");
	_tmp185_ = g_new0 (gchar*, 2 + 1);
	_tmp185_[0] = _tmp183_;
	_tmp185_[1] = _tmp184_;
	_tmp186_ = _tmp185_;
	_tmp186__length1 = 2;
	_tmp187_ = built_in_math_function_new ("log", _ ("Logarithm"), _tmp186_, 2);
	_tmp188_ = g_strdup ("x");
	_tmp189_ = g_new0 (gchar*, 1 + 1);
	_tmp189_[0] = _tmp188_;
	_tmp190_ = _tmp189_;
	_tmp190__length1 = 1;
	_tmp191_ = built_in_math_function_new ("ln", _ ("Natural Logarithm"), _tmp190_, 1);
	_tmp192_ = g_strdup ("x");
	_tmp193_ = g_new0 (gchar*, 1 + 1);
	_tmp193_[0] = _tmp192_;
	_tmp194_ = _tmp193_;
	_tmp194__length1 = 1;
	_tmp195_ = built_in_math_function_new ("sqrt", _ ("Square Root"), _tmp194_, 1);
	_tmp196_ = g_strdup ("x");
	_tmp197_ = g_new0 (gchar*, 1 + 1);
	_tmp197_[0] = _tmp196_;
	_tmp198_ = _tmp197_;
	_tmp198__length1 = 1;
	_tmp199_ = built_in_math_function_new ("abs", _ ("Absolute Value"), _tmp198_, 1);
	_tmp200_ = g_strdup ("x");
	_tmp201_ = g_new0 (gchar*, 1 + 1);
	_tmp201_[0] = _tmp200_;
	_tmp202_ = _tmp201_;
	_tmp202__length1 = 1;
	_tmp203_ = built_in_math_function_new ("sgn", _ ("Signum"), _tmp202_, 1);
	_tmp204_ = g_strdup ("n");
	_tmp205_ = g_strdup ("r");
	_tmp206_ = g_new0 (gchar*, 2 + 1);
	_tmp206_[0] = _tmp204_;
	_tmp206_[1] = _tmp205_;
	_tmp207_ = _tmp206_;
	_tmp207__length1 = 2;
	_tmp208_ = built_in_math_function_new ("ncr", _ ("Combination"), _tmp207_, 2);
	_tmp209_ = g_strdup ("n");
	_tmp210_ = g_strdup ("r");
	_tmp211_ = g_new0 (gchar*, 2 + 1);
	_tmp211_[0] = _tmp209_;
	_tmp211_[1] = _tmp210_;
	_tmp212_ = _tmp211_;
	_tmp212__length1 = 2;
	_tmp213_ = built_in_math_function_new ("npr", _ ("Permutation"), _tmp212_, 2);
	_tmp214_ = g_strdup ("x₁");
	_tmp215_ = g_strdup ("x₂");
	_tmp216_ = g_strdup ("…");
	_tmp217_ = g_new0 (gchar*, 3 + 1);
	_tmp217_[0] = _tmp214_;
	_tmp217_[1] = _tmp215_;
	_tmp217_[2] = _tmp216_;
	_tmp218_ = _tmp217_;
	_tmp218__length1 = 3;
	_tmp219_ = built_in_math_function_new ("gcd", _ ("Greatest Common Divisor"), _tmp218_, 3);
	_tmp220_ = g_strdup ("x₁");
	_tmp221_ = g_strdup ("x₂");
	_tmp222_ = g_strdup ("…");
	_tmp223_ = g_new0 (gchar*, 3 + 1);
	_tmp223_[0] = _tmp220_;
	_tmp223_[1] = _tmp221_;
	_tmp223_[2] = _tmp222_;
	_tmp224_ = _tmp223_;
	_tmp224__length1 = 3;
	_tmp225_ = built_in_math_function_new ("lcm", _ ("Least Common Multiple"), _tmp224_, 3);
	_tmp226_ = g_strdup ("x");
	_tmp227_ = g_strdup ("y");
	_tmp228_ = g_new0 (gchar*, 2 + 1);
	_tmp228_[0] = _tmp226_;
	_tmp228_[1] = _tmp227_;
	_tmp229_ = _tmp228_;
	_tmp229__length1 = 2;
	_tmp230_ = built_in_math_function_new ("cmp", _ ("Comparison (Kronecker Delta)"), _tmp229_, 2);
	_tmp231_ = g_new0 (MathFunction*, 10 + 1);
	_tmp231_[0] = (MathFunction*) _tmp187_;
	_tmp231_[1] = (MathFunction*) _tmp191_;
	_tmp231_[2] = (MathFunction*) _tmp195_;
	_tmp231_[3] = (MathFunction*) _tmp199_;
	_tmp231_[4] = (MathFunction*) _tmp203_;
	_tmp231_[5] = (MathFunction*) _tmp208_;
	_tmp231_[6] = (MathFunction*) _tmp213_;
	_tmp231_[7] = (MathFunction*) _tmp219_;
	_tmp231_[8] = (MathFunction*) _tmp225_;
	_tmp231_[9] = (MathFunction*) _tmp230_;
	memset (&_tmp232_, 0, sizeof (FunctionCategory));
	_g_free0 (_tmp232_.name);
	_tmp232_.name = _tmp182_;
	_tmp232_.functions = (_vala_array_free (_tmp232_.functions, _tmp232_.functions_length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp232_.functions = _tmp231_;
	_tmp232_.functions_length1 = 10;
	_tmp233_ = g_new0 (FunctionCategory, 6);
	_tmp233_[0] = _tmp50_;
	_tmp233_[1] = _tmp69_;
	_tmp233_[2] = _tmp95_;
	_tmp233_[3] = _tmp118_;
	_tmp233_[4] = _tmp181_;
	_tmp233_[5] = _tmp232_;
	function_manager_FUNCTION_CATEGORIES = _tmp233_;
	function_manager_FUNCTION_CATEGORIES_length1 = 6;
}

static void
function_manager_instance_init (FunctionManager * self,
                                gpointer klass)
{
	self->priv = function_manager_get_instance_private (self);
}

static void
function_manager_finalize (GObject * obj)
{
	FunctionManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FUNCTION_MANAGER, FunctionManager);
	_g_free0 (self->priv->file_name);
	_g_hash_table_unref0 (self->priv->functions);
	_g_object_unref0 (self->priv->serializer);
	G_OBJECT_CLASS (function_manager_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
function_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FunctionManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) function_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FunctionManager), 0, (GInstanceInitFunc) function_manager_instance_init, NULL };
	GType function_manager_type_id;
	function_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "FunctionManager", &g_define_type_info, 0);
	FunctionManager_private_offset = g_type_add_instance_private (function_manager_type_id, sizeof (FunctionManagerPrivate));
	return function_manager_type_id;
}

GType
function_manager_get_type (void)
{
	static gsize function_manager_type_id__once = 0;
	if (g_once_init_enter (&function_manager_type_id__once)) {
		GType function_manager_type_id;
		function_manager_type_id = function_manager_get_type_once ();
		g_once_init_leave (&function_manager_type_id__once, function_manager_type_id);
	}
	return function_manager_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

