/* math-variables.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from math-variables.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include "calculator.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	MATH_VARIABLES_0_PROPERTY,
	MATH_VARIABLES_NUM_PROPERTIES
};
static GParamSpec* math_variables_properties[MATH_VARIABLES_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	MATH_VARIABLES_VARIABLE_ADDED_SIGNAL,
	MATH_VARIABLES_VARIABLE_EDITED_SIGNAL,
	MATH_VARIABLES_VARIABLE_DELETED_SIGNAL,
	MATH_VARIABLES_NUM_SIGNALS
};
static guint math_variables_signals[MATH_VARIABLES_NUM_SIGNALS] = {0};

struct _MathVariablesPrivate {
	gchar* file_name;
	GHashTable* registers;
	Serializer* serializer;
};

static gint MathVariables_private_offset;
static gpointer math_variables_parent_class = NULL;

static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void math_variables_registers_load (MathVariables* self);
static void math_variables_save (MathVariables* self);
static gchar** math_variables_array_sort_string (MathVariables* self,
                                          gchar** array,
                                          gint array_length1,
                                          gint* result_length1);
static gchar** _vala_array_dup11 (gchar** self,
                           gssize length);
static void _vala_array_add6 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void g_cclosure_user_marshal_VOID__STRING_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void math_variables_finalize (GObject * obj);
static GType math_variables_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
math_variables_get_instance_private (MathVariables* self)
{
	return G_STRUCT_MEMBER_P (self, MathVariables_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

MathVariables*
math_variables_construct (GType object_type)
{
	MathVariables * self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	Serializer* _tmp5_;
	Serializer* _tmp6_;
	self = (MathVariables*) g_object_new (object_type, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->registers);
	self->priv->registers = _tmp2_;
	_tmp3_ = g_get_user_data_dir ();
	_tmp4_ = g_build_filename (_tmp3_, "gnome-calculator", "registers", NULL);
	_g_free0 (self->priv->file_name);
	self->priv->file_name = _tmp4_;
	_tmp5_ = serializer_new (DISPLAY_FORMAT_SCIENTIFIC, 10, 50);
	_g_object_unref0 (self->priv->serializer);
	self->priv->serializer = _tmp5_;
	_tmp6_ = self->priv->serializer;
	serializer_set_radix (_tmp6_, (gunichar) '.');
	math_variables_registers_load (self);
	return self;
}

MathVariables*
math_variables_new (void)
{
	return math_variables_construct (TYPE_MATH_VARIABLES);
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
math_variables_registers_load (MathVariables* self)
{
	gchar* data = NULL;
	GHashTable* _tmp2_;
	gchar** lines = NULL;
	const gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint lines_length1;
	gint _lines_size_;
	Number* ten = NULL;
	Number* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		_tmp0_ = self->priv->file_name;
		g_file_get_contents (_tmp0_, &_tmp1_, NULL, &_inner_error0_);
		_g_free0 (data);
		data = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (data);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		g_clear_error (&_inner_error0_);
		_g_free0 (data);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp2_ = self->priv->registers;
	g_hash_table_remove_all (_tmp2_);
	_tmp3_ = data;
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, "\n", 0);
	lines = _tmp5_;
	lines_length1 = _vala_array_length (_tmp4_);
	_lines_size_ = lines_length1;
	_tmp6_ = number_new_integer ((gint64) 10, (gint64) 0);
	ten = _tmp6_;
	_tmp7_ = lines;
	_tmp7__length1 = lines_length1;
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp7_;
		line_collection_length1 = _tmp7__length1;
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp8_;
			gchar* line = NULL;
			_tmp8_ = g_strdup (line_collection[line_it]);
			line = _tmp8_;
			{
				gint i = 0;
				const gchar* _tmp9_;
				gchar* name = NULL;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar** value = NULL;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gchar** _tmp20_;
				gchar** _tmp21_;
				gchar** _tmp22_;
				gint _tmp22__length1;
				gint value_length1;
				gint _value_size_;
				Number* t = NULL;
				gchar** _tmp23_;
				gint _tmp23__length1;
				const gchar* _tmp24_;
				Number* _tmp25_;
				Number* _tmp26_;
				_tmp9_ = line;
				i = string_index_of_char (_tmp9_, (gunichar) '=', 0);
				if (i < 0) {
					_g_free0 (line);
					continue;
				}
				_tmp10_ = line;
				_tmp11_ = string_substring (_tmp10_, (glong) 0, (glong) i);
				_tmp12_ = _tmp11_;
				_tmp13_ = string_strip (_tmp12_);
				_tmp14_ = _tmp13_;
				_g_free0 (_tmp12_);
				name = _tmp14_;
				_tmp15_ = line;
				_tmp16_ = string_substring (_tmp15_, (glong) (i + 1), (glong) -1);
				_tmp17_ = _tmp16_;
				_tmp18_ = string_strip (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp21_ = _tmp20_ = g_strsplit (_tmp19_, "×10", 0);
				_tmp22_ = _tmp21_;
				_tmp22__length1 = _vala_array_length (_tmp20_);
				_g_free0 (_tmp19_);
				_g_free0 (_tmp17_);
				value = _tmp22_;
				value_length1 = _tmp22__length1;
				_value_size_ = value_length1;
				_tmp23_ = value;
				_tmp23__length1 = value_length1;
				_tmp24_ = _tmp23_[0];
				_tmp25_ = mp_set_from_string (_tmp24_, 10, TRUE);
				t = _tmp25_;
				_tmp26_ = t;
				if (_tmp26_ != NULL) {
					gchar** _tmp27_;
					gint _tmp27__length1;
					GHashTable* _tmp35_;
					const gchar* _tmp36_;
					gchar* _tmp37_;
					Number* _tmp38_;
					Number* _tmp39_;
					_tmp27_ = value;
					_tmp27__length1 = value_length1;
					if (_tmp27__length1 > 1) {
						Number* _tmp28_;
						Number* _tmp29_;
						gchar** _tmp30_;
						gint _tmp30__length1;
						const gchar* _tmp31_;
						Number* _tmp32_;
						Number* _tmp33_;
						Number* _tmp34_;
						_tmp28_ = t;
						_tmp29_ = ten;
						_tmp30_ = value;
						_tmp30__length1 = value_length1;
						_tmp31_ = _tmp30_[1];
						_tmp32_ = number_xpowy_integer (_tmp29_, (gint64) super_atoi (_tmp31_));
						_tmp33_ = _tmp32_;
						_tmp34_ = number_multiply (_tmp28_, _tmp33_);
						_g_object_unref0 (t);
						t = _tmp34_;
						_g_object_unref0 (_tmp33_);
					}
					_tmp35_ = self->priv->registers;
					_tmp36_ = name;
					_tmp37_ = g_strdup (_tmp36_);
					_tmp38_ = t;
					_tmp39_ = _g_object_ref0 (_tmp38_);
					g_hash_table_insert (_tmp35_, _tmp37_, _tmp39_);
				}
				_g_object_unref0 (t);
				value = (_vala_array_free (value, value_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (name);
				_g_free0 (line);
			}
		}
	}
	_g_object_unref0 (ten);
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (data);
}

static void
math_variables_save (MathVariables* self)
{
	gchar* data = NULL;
	gchar* _tmp0_;
	GHashTableIter iter = {0};
	GHashTable* _tmp1_;
	gchar* name = NULL;
	Number* value = NULL;
	gchar* dir = NULL;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	data = _tmp0_;
	_tmp1_ = self->priv->registers;
	g_hash_table_iter_init (&iter, _tmp1_);
	while (TRUE) {
		gconstpointer _tmp2_ = NULL;
		gconstpointer _tmp3_ = NULL;
		gboolean _tmp4_;
		gchar* _tmp5_;
		Number* _tmp6_;
		gchar* number = NULL;
		Serializer* _tmp7_;
		Number* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp4_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp2_), (gpointer*) (&_tmp3_));
		_g_free0 (name);
		_tmp5_ = g_strdup ((const gchar*) _tmp2_);
		name = _tmp5_;
		_g_object_unref0 (value);
		_tmp6_ = _g_object_ref0 ((Number*) _tmp3_);
		value = _tmp6_;
		if (!_tmp4_) {
			break;
		}
		_tmp7_ = self->priv->serializer;
		_tmp8_ = value;
		_tmp9_ = serializer_to_string (_tmp7_, _tmp8_);
		number = _tmp9_;
		_tmp10_ = data;
		_tmp11_ = name;
		_tmp12_ = number;
		_tmp13_ = g_strdup_printf ("%s=%s\n", _tmp11_, _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat (_tmp10_, _tmp14_, NULL);
		_g_free0 (data);
		data = _tmp15_;
		_g_free0 (_tmp14_);
		_g_free0 (number);
	}
	_tmp16_ = self->priv->file_name;
	_tmp17_ = g_path_get_dirname (_tmp16_);
	dir = _tmp17_;
	g_mkdir_with_parents (dir, 0700);
	{
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		_tmp18_ = self->priv->file_name;
		_tmp19_ = data;
		g_file_set_contents (_tmp18_, _tmp19_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (dir);
			_g_object_unref0 (value);
			_g_free0 (name);
			_g_free0 (data);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (dir);
		_g_object_unref0 (value);
		_g_free0 (name);
		_g_free0 (data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (dir);
	_g_object_unref0 (value);
	_g_free0 (name);
	_g_free0 (data);
}

static gchar**
_vala_array_dup11 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
math_variables_array_sort_string (MathVariables* self,
                                  gchar** array,
                                  gint array_length1,
                                  gint* result_length1)
{
	gboolean swapped = FALSE;
	gint _tmp0_ = 0;
	const gchar* _tmp1_;
	gint j = 0;
	gchar* tmp = NULL;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	swapped = TRUE;
	_tmp1_ = array[array_length1 - 1];
	if (_tmp1_ == NULL) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	j = _tmp0_;
	while (TRUE) {
		gint _tmp2_;
		if (!swapped) {
			break;
		}
		swapped = FALSE;
		_tmp2_ = j;
		j = _tmp2_ + 1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					const gchar* _tmp5_;
					const gchar* _tmp6_;
					if (!_tmp3_) {
						gint _tmp4_;
						_tmp4_ = i;
						i = _tmp4_ + 1;
					}
					_tmp3_ = FALSE;
					if (!(i < (array_length1 - j))) {
						break;
					}
					_tmp5_ = array[i];
					_tmp6_ = array[i + 1];
					if (g_strcmp0 (_tmp5_, _tmp6_) < 0) {
						const gchar* _tmp7_;
						gchar* _tmp8_;
						const gchar* _tmp9_;
						gchar* _tmp10_;
						const gchar* _tmp11_;
						gchar* _tmp12_;
						_tmp7_ = array[i];
						_tmp8_ = g_strdup (_tmp7_);
						_g_free0 (tmp);
						tmp = _tmp8_;
						_tmp9_ = array[i + 1];
						_tmp10_ = g_strdup (_tmp9_);
						_g_free0 (array[i]);
						array[i] = _tmp10_;
						_tmp11_ = tmp;
						_tmp12_ = g_strdup (_tmp11_);
						_g_free0 (array[i + 1]);
						array[i + 1] = _tmp12_;
						swapped = TRUE;
					}
				}
			}
		}
	}
	_tmp13_ = (array != NULL) ? _vala_array_dup11 (array, array_length1) : array;
	_tmp13__length1 = array_length1;
	_tmp14_ = _tmp13_;
	_tmp14__length1 = _tmp13__length1;
	if (result_length1) {
		*result_length1 = _tmp14__length1;
	}
	result = _tmp14_;
	_g_free0 (tmp);
	return result;
}

gchar**
math_variables_get_names (MathVariables* self,
                          gint* result_length1)
{
	gchar** names = NULL;
	GHashTable* _tmp0_;
	gchar** _tmp1_;
	gint names_length1;
	gint _names_size_;
	GHashTableIter iter = {0};
	GHashTable* _tmp2_;
	gint i = 0;
	gchar* name = NULL;
	Number* value = NULL;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gint _tmp14_ = 0;
	gchar** _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->registers;
	_tmp1_ = g_new0 (gchar*, (g_hash_table_size (_tmp0_) + 1) + 1);
	names = _tmp1_;
	names_length1 = g_hash_table_size (_tmp0_) + 1;
	_names_size_ = names_length1;
	_tmp2_ = self->priv->registers;
	g_hash_table_iter_init (&iter, _tmp2_);
	i = 0;
	while (TRUE) {
		gconstpointer _tmp3_ = NULL;
		gconstpointer _tmp4_ = NULL;
		gboolean _tmp5_;
		gchar* _tmp6_;
		Number* _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gint _tmp11_;
		_tmp5_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp3_), (gpointer*) (&_tmp4_));
		_g_free0 (name);
		_tmp6_ = g_strdup ((const gchar*) _tmp3_);
		name = _tmp6_;
		_g_object_unref0 (value);
		_tmp7_ = _g_object_ref0 ((Number*) _tmp4_);
		value = _tmp7_;
		if (!_tmp5_) {
			break;
		}
		_tmp8_ = names;
		_tmp8__length1 = names_length1;
		_tmp9_ = name;
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (_tmp8_[i]);
		_tmp8_[i] = _tmp10_;
		_tmp11_ = i;
		i = _tmp11_ + 1;
	}
	_tmp12_ = names;
	_tmp12__length1 = names_length1;
	_g_free0 (_tmp12_[i]);
	_tmp12_[i] = NULL;
	_tmp13_ = names;
	_tmp13__length1 = names_length1;
	_tmp15_ = math_variables_array_sort_string (self, _tmp13_, (gint) _tmp13__length1, &_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp16__length1 = _tmp14_;
	if (result_length1) {
		*result_length1 = _tmp16__length1;
	}
	result = _tmp16_;
	_g_object_unref0 (value);
	_g_free0 (name);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
_vala_array_add6 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gchar**
math_variables_variables_eligible_for_autocompletion (MathVariables* self,
                                                      const gchar* text,
                                                      gint* result_length1)
{
	gchar** eligible_variables = NULL;
	gchar** _tmp0_;
	gint eligible_variables_length1;
	gint _eligible_variables_size_;
	gint _tmp1_;
	gint _tmp2_;
	gchar** variables = NULL;
	gint _tmp4_ = 0;
	gchar** _tmp5_;
	gint variables_length1;
	gint _variables_size_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	eligible_variables = _tmp0_;
	eligible_variables_length1 = 0;
	_eligible_variables_size_ = eligible_variables_length1;
	_tmp1_ = strlen (text);
	_tmp2_ = _tmp1_;
	if (_tmp2_ < 1) {
		gchar** _tmp3_;
		gint _tmp3__length1;
		_tmp3_ = eligible_variables;
		_tmp3__length1 = eligible_variables_length1;
		if (result_length1) {
			*result_length1 = _tmp3__length1;
		}
		result = _tmp3_;
		return result;
	}
	_tmp5_ = math_variables_get_names (self, &_tmp4_);
	variables = _tmp5_;
	variables_length1 = _tmp4_;
	_variables_size_ = variables_length1;
	_tmp6_ = variables;
	_tmp6__length1 = variables_length1;
	{
		gchar** variable_collection = NULL;
		gint variable_collection_length1 = 0;
		gint _variable_collection_size_ = 0;
		gint variable_it = 0;
		variable_collection = _tmp6_;
		variable_collection_length1 = _tmp6__length1;
		for (variable_it = 0; variable_it < variable_collection_length1; variable_it = variable_it + 1) {
			gchar* _tmp7_;
			gchar* variable = NULL;
			_tmp7_ = g_strdup (variable_collection[variable_it]);
			variable = _tmp7_;
			{
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				_tmp8_ = variable;
				if (_tmp8_ == NULL) {
					_g_free0 (variable);
					break;
				}
				_tmp9_ = variable;
				if (g_str_has_prefix (_tmp9_, text)) {
					const gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp10_ = variable;
					_tmp11_ = g_strdup (_tmp10_);
					_vala_array_add6 (&eligible_variables, &eligible_variables_length1, &_eligible_variables_size_, _tmp11_);
				}
				_g_free0 (variable);
			}
		}
	}
	_tmp12_ = eligible_variables;
	_tmp12__length1 = eligible_variables_length1;
	if (result_length1) {
		*result_length1 = _tmp12__length1;
	}
	result = _tmp12_;
	variables = (_vala_array_free (variables, variables_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

void
math_variables_set (MathVariables* self,
                    const gchar* name,
                    Number* value)
{
	gboolean editing = FALSE;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	gchar* _tmp2_;
	Number* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = self->priv->registers;
	editing = g_hash_table_contains (_tmp0_, name);
	_tmp1_ = self->priv->registers;
	_tmp2_ = g_strdup (name);
	_tmp3_ = _g_object_ref0 (value);
	g_hash_table_insert (_tmp1_, _tmp2_, _tmp3_);
	math_variables_save (self);
	if (editing) {
		g_signal_emit (self, math_variables_signals[MATH_VARIABLES_VARIABLE_EDITED_SIGNAL], 0, name, value);
	} else {
		g_signal_emit (self, math_variables_signals[MATH_VARIABLES_VARIABLE_ADDED_SIGNAL], 0, name, value);
	}
}

Number*
math_variables_get (MathVariables* self,
                    const gchar* name)
{
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	Number* _tmp2_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->registers;
	_tmp1_ = g_hash_table_lookup (_tmp0_, name);
	_tmp2_ = _g_object_ref0 ((Number*) _tmp1_);
	result = _tmp2_;
	return result;
}

void
math_variables_delete (MathVariables* self,
                       const gchar* name)
{
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->registers;
	g_hash_table_remove (_tmp0_, name);
	math_variables_save (self);
	g_signal_emit (self, math_variables_signals[MATH_VARIABLES_VARIABLE_DELETED_SIGNAL], 0, name);
}

static void
g_cclosure_user_marshal_VOID__STRING_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_OBJECT) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
math_variables_class_init (MathVariablesClass * klass,
                           gpointer klass_data)
{
	math_variables_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MathVariables_private_offset);
	G_OBJECT_CLASS (klass)->finalize = math_variables_finalize;
	math_variables_signals[MATH_VARIABLES_VARIABLE_ADDED_SIGNAL] = g_signal_new ("variable-added", TYPE_MATH_VARIABLES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_OBJECT, G_TYPE_NONE, 2, G_TYPE_STRING, TYPE_NUMBER);
	math_variables_signals[MATH_VARIABLES_VARIABLE_EDITED_SIGNAL] = g_signal_new ("variable-edited", TYPE_MATH_VARIABLES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_OBJECT, G_TYPE_NONE, 2, G_TYPE_STRING, TYPE_NUMBER);
	math_variables_signals[MATH_VARIABLES_VARIABLE_DELETED_SIGNAL] = g_signal_new ("variable-deleted", TYPE_MATH_VARIABLES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
math_variables_instance_init (MathVariables * self,
                              gpointer klass)
{
	self->priv = math_variables_get_instance_private (self);
}

static void
math_variables_finalize (GObject * obj)
{
	MathVariables * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_VARIABLES, MathVariables);
	_g_free0 (self->priv->file_name);
	_g_hash_table_unref0 (self->priv->registers);
	_g_object_unref0 (self->priv->serializer);
	G_OBJECT_CLASS (math_variables_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
math_variables_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MathVariablesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_variables_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathVariables), 0, (GInstanceInitFunc) math_variables_instance_init, NULL };
	GType math_variables_type_id;
	math_variables_type_id = g_type_register_static (G_TYPE_OBJECT, "MathVariables", &g_define_type_info, 0);
	MathVariables_private_offset = g_type_add_instance_private (math_variables_type_id, sizeof (MathVariablesPrivate));
	return math_variables_type_id;
}

GType
math_variables_get_type (void)
{
	static gsize math_variables_type_id__once = 0;
	if (g_once_init_enter (&math_variables_type_id__once)) {
		GType math_variables_type_id;
		math_variables_type_id = math_variables_get_type_once ();
		g_once_init_leave (&math_variables_type_id__once, math_variables_type_id);
	}
	return math_variables_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

