/* gnome-calculator.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gnome-calculator.vala, do not modify */

/*
 * Copyright (C) 1987-2008 Sun Microsystems, Inc. All Rights Reserved.
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include "calculator.h"
#include "mpfr.h"
#include <gtk/gtk.h>
#include <gtksourceview/gtksource.h>
#include <stdio.h>
#include <langinfo.h>
#include <locale.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_CALCULATOR (calculator_get_type ())
#define CALCULATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CALCULATOR, Calculator))
#define CALCULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CALCULATOR, CalculatorClass))
#define IS_CALCULATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CALCULATOR))
#define IS_CALCULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CALCULATOR))
#define CALCULATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CALCULATOR, CalculatorClass))

typedef struct _Calculator Calculator;
typedef struct _CalculatorClass CalculatorClass;
typedef struct _CalculatorPrivate CalculatorPrivate;

#define TYPE_MATH_WINDOW (math_window_get_type ())
#define MATH_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_WINDOW, MathWindow))
#define MATH_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_WINDOW, MathWindowClass))
#define IS_MATH_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_WINDOW))
#define IS_MATH_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_WINDOW))
#define MATH_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_WINDOW, MathWindowClass))

typedef struct _MathWindow MathWindow;
typedef struct _MathWindowClass MathWindowClass;
enum  {
	CALCULATOR_0_PROPERTY,
	CALCULATOR_NUM_PROPERTIES
};
static GParamSpec* calculator_properties[CALCULATOR_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	BUTTON_MODE_BASIC,
	BUTTON_MODE_ADVANCED,
	BUTTON_MODE_FINANCIAL,
	BUTTON_MODE_PROGRAMMING,
	BUTTON_MODE_KEYBOARD,
	BUTTON_MODE_CONVERSION
} ButtonMode;

#define TYPE_BUTTON_MODE (button_mode_get_type ())

#define TYPE_MATH_CONVERTER (math_converter_get_type ())
#define MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_CONVERTER, MathConverter))
#define MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_CONVERTER, MathConverterClass))
#define IS_MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_CONVERTER))
#define IS_MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_CONVERTER))
#define MATH_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_CONVERTER, MathConverterClass))

typedef struct _MathConverter MathConverter;
typedef struct _MathConverterClass MathConverterClass;

#define TYPE_MATH_BUTTONS (math_buttons_get_type ())
#define MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_BUTTONS, MathButtons))
#define MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_BUTTONS, MathButtonsClass))
#define IS_MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_BUTTONS))
#define IS_MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_BUTTONS))
#define MATH_BUTTONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_BUTTONS, MathButtonsClass))

typedef struct _MathButtons MathButtons;
typedef struct _MathButtonsClass MathButtonsClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _Calculator {
	AdwApplication parent_instance;
	CalculatorPrivate * priv;
};

struct _CalculatorClass {
	AdwApplicationClass parent_class;
};

struct _CalculatorPrivate {
	GSettings* settings;
	MathWindow* last_opened_window;
};

static gint Calculator_private_offset;
static gpointer calculator_parent_class = NULL;
static gchar* calculator_mode_string;
static gchar* calculator_equation_string;
static gchar* calculator_program_name;
static gchar* calculator_program_name = NULL;
static gchar* calculator_equation_string = NULL;
static gchar* calculator_mode_string = NULL;

VALA_EXTERN GType calculator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Calculator, g_object_unref)
VALA_EXTERN GType math_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathWindow, g_object_unref)
static void calculator_new_window_cb (Calculator* self);
static void _calculator_new_window_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void calculator_help_cb (Calculator* self);
static void _calculator_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
static void calculator_about_cb (Calculator* self);
static void _calculator_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self);
static void calculator_quit_cb (Calculator* self);
static void _calculator_quit_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
VALA_EXTERN Calculator* calculator_new (void);
VALA_EXTERN Calculator* calculator_construct (GType object_type);
static MathWindow* calculator_create_new_window (Calculator* self,
                                          GSettings* settings);
VALA_EXTERN GType button_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN MathWindow* math_window_new (GtkApplication* app,
                             MathEquation* equation);
VALA_EXTERN MathWindow* math_window_construct (GType object_type,
                                   GtkApplication* app,
                                   MathEquation* equation);
VALA_EXTERN GType math_converter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathConverter, g_object_unref)
VALA_EXTERN MathConverter* math_window_get_converter (MathWindow* self);
VALA_EXTERN void math_converter_set_source_units (MathConverter* self,
                                      gchar** value,
                                      gint value_length1);
VALA_EXTERN void math_converter_set_target_units (MathConverter* self,
                                      gchar** value,
                                      gint value_length1);
VALA_EXTERN void math_converter_set_category (MathConverter* self,
                                  const gchar* category);
VALA_EXTERN GType math_buttons_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathButtons, g_object_unref)
VALA_EXTERN MathButtons* math_window_get_buttons (MathWindow* self);
VALA_EXTERN void math_buttons_set_programming_base (MathButtons* self,
                                        gint value);
VALA_EXTERN void math_buttons_set_mode (MathButtons* self,
                            ButtonMode value);
static void calculator_real_startup (GApplication* base);
static void __lambda52_ (Calculator* self);
static void ___lambda52__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void calculator_real_activate (GApplication* base);
VALA_EXTERN MathEquation* math_window_get_equation (MathWindow* self);
static void calculator_real_shutdown (GApplication* base);
VALA_EXTERN ButtonMode math_buttons_get_mode (MathButtons* self);
VALA_EXTERN gchar* math_converter_get_category (MathConverter* self);
VALA_EXTERN gchar** math_converter_get_source_units (MathConverter* self,
                                         gint* result_length1);
VALA_EXTERN gchar** math_converter_get_target_units (MathConverter* self,
                                         gint* result_length1);
VALA_EXTERN gint math_buttons_get_programming_base (MathButtons* self);
static gint calculator_real_handle_local_options (GApplication* base,
                                           GVariantDict* options);
static gchar* _variant_get1 (GVariant* value);
static gchar** _vala_array_dup4 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup5 (gchar** self,
                          gssize length);
static void ___lambda51_ (Calculator* self,
                   const gchar* _result_);
static void ____lambda51__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                              const gchar* response,
                                              gpointer self);
static gint calculator_main (gchar** args,
                      gint args_length1);
static void calculator_finalize (GObject * obj);
static GType calculator_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GOptionEntry CALCULATOR_option_entries[5] = {{"mode", 'm', (gint) 0, G_OPTION_ARG_STRING, &calculator_mode_string, N_ ("Start in given mode (basic, advanced, financial, programming, keyboard" \
", conversion)"), "mode"}, {"solve", 's', (gint) 0, G_OPTION_ARG_STRING, NULL, N_ ("Solve given equation"), "equation"}, {"equation", 'e', (gint) 0, G_OPTION_ARG_STRING, &calculator_equation_string, N_ ("Start with given equation"), "equation"}, {"version", 'v', (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Show release version"), NULL}, {NULL}};
static const GActionEntry CALCULATOR_app_entries[4] = {{"new-window", _calculator_new_window_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"help", _calculator_help_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"about", _calculator_about_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"quit", _calculator_quit_cb_gsimple_action_activate_callback, NULL, NULL, NULL}};

static inline gpointer
calculator_get_instance_private (Calculator* self)
{
	return G_STRUCT_MEMBER_P (self, Calculator_private_offset);
}

static void
_calculator_new_window_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	calculator_new_window_cb ((Calculator*) self);
}

static void
_calculator_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	calculator_help_cb ((Calculator*) self);
}

static void
_calculator_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	calculator_about_cb ((Calculator*) self);
}

static void
_calculator_quit_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	calculator_quit_cb ((Calculator*) self);
}

Calculator*
calculator_construct (GType object_type)
{
	Calculator * self = NULL;
	self = (Calculator*) g_object_new (object_type, "flags", G_APPLICATION_NON_UNIQUE, "application-id", APP_ID, NULL);
	g_application_set_resource_base_path ((GApplication*) self, "/org/gnome/calculator");
	g_application_add_main_option_entries ((GApplication*) self, CALCULATOR_option_entries);
	return self;
}

Calculator*
calculator_new (void)
{
	return calculator_construct (TYPE_CALCULATOR);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static MathWindow*
calculator_create_new_window (Calculator* self,
                              GSettings* settings)
{
	gint accuracy = 0;
	gint word_size = 0;
	gint number_base = 0;
	gboolean show_tsep = FALSE;
	gboolean show_zeroes = FALSE;
	DisplayFormat number_format = 0;
	AngleUnit angle_units = 0;
	ButtonMode button_mode = 0;
	gchar* unit_category = NULL;
	gchar* _tmp0_;
	gchar** source_units = NULL;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint source_units_length1;
	gint _source_units_size_;
	gchar** target_units = NULL;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint target_units_length1;
	gint _target_units_size_;
	gint precision = 0;
	gboolean maximized = FALSE;
	gint width = 0;
	gint height = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	MathEquation* equation = NULL;
	MathEquation* _tmp7_;
	Number* _tmp8_;
	Number* _tmp9_;
	Number* _tmp10_;
	Number* _tmp11_;
	MathWindow* current_window = NULL;
	MathWindow* _tmp12_;
	MathConverter* converter = NULL;
	MathConverter* _tmp13_;
	MathConverter* _tmp14_;
	MathConverter* _tmp15_;
	MathButtons* buttons = NULL;
	MathButtons* _tmp16_;
	MathButtons* _tmp17_;
	MathButtons* _tmp18_;
	gchar* _tmp19_;
	gchar** _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	gchar* _tmp22_;
	gchar** _tmp23_;
	gchar** _tmp24_;
	gint _tmp24__length1;
	gchar* _tmp25_;
	gchar** _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	gchar* _tmp28_;
	gchar** _tmp29_;
	gchar** _tmp30_;
	gint _tmp30__length1;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar** _tmp33_;
	gchar** _tmp34_;
	gint _tmp34__length1;
	gchar* _tmp35_;
	gchar** _tmp36_;
	gchar** _tmp37_;
	gint _tmp37__length1;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar** _tmp40_;
	gchar** _tmp41_;
	gint _tmp41__length1;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar** _tmp44_;
	gchar** _tmp45_;
	gint _tmp45__length1;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar** _tmp48_;
	gchar** _tmp49_;
	gint _tmp49__length1;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar** _tmp52_;
	gchar** _tmp53_;
	gint _tmp53__length1;
	gchar* _tmp54_;
	gchar** _tmp55_;
	gchar** _tmp56_;
	gint _tmp56__length1;
	gchar* _tmp57_;
	gchar** _tmp58_;
	gchar** _tmp59_;
	gint _tmp59__length1;
	gchar* _tmp60_;
	gchar** _tmp61_;
	gchar** _tmp62_;
	gint _tmp62__length1;
	gchar* _tmp63_;
	gchar** _tmp64_;
	gchar** _tmp65_;
	gint _tmp65__length1;
	gchar* _tmp66_;
	gchar** _tmp67_;
	gchar** _tmp68_;
	gint _tmp68__length1;
	gchar* _tmp69_;
	gchar** _tmp70_;
	gchar** _tmp71_;
	gint _tmp71__length1;
	gchar* _tmp72_;
	gchar** _tmp73_;
	gchar** _tmp74_;
	gint _tmp74__length1;
	MathWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (settings != NULL, NULL);
	accuracy = g_settings_get_int (settings, "accuracy");
	word_size = g_settings_get_int (settings, "word-size");
	number_base = g_settings_get_int (settings, "base");
	show_tsep = g_settings_get_boolean (settings, "show-thousands");
	show_zeroes = g_settings_get_boolean (settings, "show-zeroes");
	number_format = (DisplayFormat) g_settings_get_enum (settings, "number-format");
	angle_units = (AngleUnit) g_settings_get_enum (settings, "angle-units");
	button_mode = (ButtonMode) g_settings_get_enum (settings, "button-mode");
	_tmp0_ = g_settings_get_string (settings, "unit-category");
	unit_category = _tmp0_;
	_tmp2_ = _tmp1_ = g_settings_get_strv (settings, "source-units");
	source_units = _tmp2_;
	source_units_length1 = _vala_array_length (_tmp1_);
	_source_units_size_ = source_units_length1;
	_tmp4_ = _tmp3_ = g_settings_get_strv (settings, "target-units");
	target_units = _tmp4_;
	target_units_length1 = _vala_array_length (_tmp3_);
	_target_units_size_ = target_units_length1;
	precision = g_settings_get_int (settings, "precision");
	maximized = g_settings_get_boolean (settings, "window-maximized");
	g_settings_get (settings, "window-size", "(ii)", &_tmp5_, &_tmp6_);
	width = _tmp5_;
	height = _tmp6_;
	_tmp7_ = math_equation_new ();
	equation = _tmp7_;
	math_equation_set_accuracy (equation, accuracy);
	math_equation_set_word_size (equation, word_size);
	math_equation_set_show_thousands_separators (equation, show_tsep);
	math_equation_set_show_trailing_zeroes (equation, show_zeroes);
	math_equation_set_number_format (equation, number_format);
	math_equation_set_angle_units (equation, angle_units);
	number_set_precision ((mpfr_prec_t) precision);
	_tmp8_ = number_new_integer ((gint64) 2, (gint64) 0);
	_tmp9_ = _tmp8_;
	_tmp10_ = number_xpowy_integer (_tmp9_, (gint64) precision);
	_tmp11_ = _tmp10_;
	serializer_set_fixed_max (_tmp11_);
	_g_object_unref0 (_tmp11_);
	_g_object_unref0 (_tmp9_);
	g_action_map_add_action_entries ((GActionMap*) self, CALCULATOR_app_entries, (gint) G_N_ELEMENTS (CALCULATOR_app_entries), self);
	_tmp12_ = math_window_new ((GtkApplication*) self, equation);
	g_object_ref_sink (_tmp12_);
	current_window = _tmp12_;
	gtk_window_set_title ((GtkWindow*) current_window, _ ("Calculator"));
	g_object_set ((GtkWindow*) current_window, "maximized", maximized, NULL);
	gtk_window_set_default_size ((GtkWindow*) current_window, width, height);
	_tmp13_ = math_window_get_converter (current_window);
	_tmp14_ = _tmp13_;
	_tmp15_ = _g_object_ref0 (_tmp14_);
	converter = _tmp15_;
	math_converter_set_source_units (converter, source_units, source_units_length1);
	math_converter_set_target_units (converter, target_units, target_units_length1);
	math_converter_set_category (converter, unit_category);
	_tmp16_ = math_window_get_buttons (current_window);
	_tmp17_ = _tmp16_;
	_tmp18_ = _g_object_ref0 (_tmp17_);
	buttons = _tmp18_;
	math_buttons_set_programming_base (buttons, number_base);
	math_buttons_set_mode (buttons, button_mode);
	_tmp19_ = g_strdup ("<control><alt>B");
	_tmp20_ = g_new0 (gchar*, 1 + 1);
	_tmp20_[0] = _tmp19_;
	_tmp21_ = _tmp20_;
	_tmp21__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.mode::basic", _tmp21_);
	_tmp21_ = (_vala_array_free (_tmp21_, _tmp21__length1, (GDestroyNotify) g_free), NULL);
	_tmp22_ = g_strdup ("<control><alt>A");
	_tmp23_ = g_new0 (gchar*, 1 + 1);
	_tmp23_[0] = _tmp22_;
	_tmp24_ = _tmp23_;
	_tmp24__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.mode::advanced", _tmp24_);
	_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_free), NULL);
	_tmp25_ = g_strdup ("<control><alt>F");
	_tmp26_ = g_new0 (gchar*, 1 + 1);
	_tmp26_[0] = _tmp25_;
	_tmp27_ = _tmp26_;
	_tmp27__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.mode::financial", _tmp27_);
	_tmp27_ = (_vala_array_free (_tmp27_, _tmp27__length1, (GDestroyNotify) g_free), NULL);
	_tmp28_ = g_strdup ("<control><alt>P");
	_tmp29_ = g_new0 (gchar*, 1 + 1);
	_tmp29_[0] = _tmp28_;
	_tmp30_ = _tmp29_;
	_tmp30__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.mode::programming", _tmp30_);
	_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
	_tmp31_ = g_strdup ("<control><alt>K");
	_tmp32_ = g_strdup ("<control><alt>T");
	_tmp33_ = g_new0 (gchar*, 2 + 1);
	_tmp33_[0] = _tmp31_;
	_tmp33_[1] = _tmp32_;
	_tmp34_ = _tmp33_;
	_tmp34__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.mode::keyboard", _tmp34_);
	_tmp34_ = (_vala_array_free (_tmp34_, _tmp34__length1, (GDestroyNotify) g_free), NULL);
	_tmp35_ = g_strdup ("<control><alt>C");
	_tmp36_ = g_new0 (gchar*, 1 + 1);
	_tmp36_[0] = _tmp35_;
	_tmp37_ = _tmp36_;
	_tmp37__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.mode::conversion", _tmp37_);
	_tmp37_ = (_vala_array_free (_tmp37_, _tmp37__length1, (GDestroyNotify) g_free), NULL);
	_tmp38_ = g_strdup ("<control>C");
	_tmp39_ = g_strdup ("Copy");
	_tmp40_ = g_new0 (gchar*, 2 + 1);
	_tmp40_[0] = _tmp38_;
	_tmp40_[1] = _tmp39_;
	_tmp41_ = _tmp40_;
	_tmp41__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.copy", _tmp41_);
	_tmp41_ = (_vala_array_free (_tmp41_, _tmp41__length1, (GDestroyNotify) g_free), NULL);
	_tmp42_ = g_strdup ("<control>V");
	_tmp43_ = g_strdup ("Paste");
	_tmp44_ = g_new0 (gchar*, 2 + 1);
	_tmp44_[0] = _tmp42_;
	_tmp44_[1] = _tmp43_;
	_tmp45_ = _tmp44_;
	_tmp45__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.paste", _tmp45_);
	_tmp45_ = (_vala_array_free (_tmp45_, _tmp45__length1, (GDestroyNotify) g_free), NULL);
	_tmp46_ = g_strdup ("<control>Z");
	_tmp47_ = g_strdup ("Undo");
	_tmp48_ = g_new0 (gchar*, 2 + 1);
	_tmp48_[0] = _tmp46_;
	_tmp48_[1] = _tmp47_;
	_tmp49_ = _tmp48_;
	_tmp49__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.undo", _tmp49_);
	_tmp49_ = (_vala_array_free (_tmp49_, _tmp49__length1, (GDestroyNotify) g_free), NULL);
	_tmp50_ = g_strdup ("<control><shift>Z");
	_tmp51_ = g_strdup ("Redo");
	_tmp52_ = g_new0 (gchar*, 2 + 1);
	_tmp52_[0] = _tmp50_;
	_tmp52_[1] = _tmp51_;
	_tmp53_ = _tmp52_;
	_tmp53__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.redo", _tmp53_);
	_tmp53_ = (_vala_array_free (_tmp53_, _tmp53__length1, (GDestroyNotify) g_free), NULL);
	_tmp54_ = g_strdup ("<control>Escape");
	_tmp55_ = g_new0 (gchar*, 1 + 1);
	_tmp55_[0] = _tmp54_;
	_tmp56_ = _tmp55_;
	_tmp56__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.clear", _tmp56_);
	_tmp56_ = (_vala_array_free (_tmp56_, _tmp56__length1, (GDestroyNotify) g_free), NULL);
	_tmp57_ = g_strdup ("<control>comma");
	_tmp58_ = g_new0 (gchar*, 1 + 1);
	_tmp58_[0] = _tmp57_;
	_tmp59_ = _tmp58_;
	_tmp59__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.preferences", _tmp59_);
	_tmp59_ = (_vala_array_free (_tmp59_, _tmp59__length1, (GDestroyNotify) g_free), NULL);
	_tmp60_ = g_strdup ("<control>W");
	_tmp61_ = g_new0 (gchar*, 1 + 1);
	_tmp61_[0] = _tmp60_;
	_tmp62_ = _tmp61_;
	_tmp62__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.close", _tmp62_);
	_tmp62_ = (_vala_array_free (_tmp62_, _tmp62__length1, (GDestroyNotify) g_free), NULL);
	_tmp63_ = g_strdup ("<control>Q");
	_tmp64_ = g_new0 (gchar*, 1 + 1);
	_tmp64_[0] = _tmp63_;
	_tmp65_ = _tmp64_;
	_tmp65__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp65_);
	_tmp65_ = (_vala_array_free (_tmp65_, _tmp65__length1, (GDestroyNotify) g_free), NULL);
	_tmp66_ = g_strdup ("<control>N");
	_tmp67_ = g_new0 (gchar*, 1 + 1);
	_tmp67_[0] = _tmp66_;
	_tmp68_ = _tmp67_;
	_tmp68__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.new-window", _tmp68_);
	_tmp68_ = (_vala_array_free (_tmp68_, _tmp68__length1, (GDestroyNotify) g_free), NULL);
	_tmp69_ = g_strdup ("F1");
	_tmp70_ = g_new0 (gchar*, 1 + 1);
	_tmp70_[0] = _tmp69_;
	_tmp71_ = _tmp70_;
	_tmp71__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.help", _tmp71_);
	_tmp71_ = (_vala_array_free (_tmp71_, _tmp71__length1, (GDestroyNotify) g_free), NULL);
	_tmp72_ = g_strdup ("<control>question");
	_tmp73_ = g_new0 (gchar*, 1 + 1);
	_tmp73_[0] = _tmp72_;
	_tmp74_ = _tmp73_;
	_tmp74__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.shortcuts", _tmp74_);
	_tmp74_ = (_vala_array_free (_tmp74_, _tmp74__length1, (GDestroyNotify) g_free), NULL);
	result = current_window;
	_g_object_unref0 (buttons);
	_g_object_unref0 (converter);
	_g_object_unref0 (equation);
	target_units = (_vala_array_free (target_units, target_units_length1, (GDestroyNotify) g_free), NULL);
	source_units = (_vala_array_free (source_units, source_units_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (unit_category);
	return result;
}

static void
__lambda52_ (Calculator* self)
{
	CurrencyManager* _tmp0_;
	CurrencyManager* _tmp1_;
	GSettings* _tmp2_;
	CurrencyManager* _tmp3_;
	CurrencyManager* _tmp4_;
	_tmp0_ = currency_manager_get_default (TRUE, TRUE);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->settings;
	currency_manager_set_refresh_interval (_tmp1_, g_settings_get_int (_tmp2_, "refresh-interval"));
	_g_object_unref0 (_tmp1_);
	_tmp3_ = currency_manager_get_default (TRUE, TRUE);
	_tmp4_ = _tmp3_;
	currency_manager_refresh_async (_tmp4_, FALSE);
	_g_object_unref0 (_tmp4_);
}

static void
___lambda52__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda52_ ((Calculator*) self);
}

static void
calculator_real_startup (GApplication* base)
{
	Calculator * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	MathWindow* _tmp3_;
	CurrencyManager* _tmp4_;
	CurrencyManager* _tmp5_;
	GSettings* _tmp6_;
	CurrencyManager* _tmp7_;
	CurrencyManager* _tmp8_;
	GSettings* _tmp9_;
	GSettings* _tmp10_;
	CurrencyManager* _tmp11_;
	CurrencyManager* _tmp12_;
	self = (Calculator*) base;
	G_APPLICATION_CLASS (calculator_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_get_type (), AdwApplication));
	gtk_source_init ();
	_tmp0_ = g_settings_new ("org.gnome.calculator");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->settings;
	g_settings_delay (_tmp1_);
	_tmp2_ = self->priv->settings;
	_tmp3_ = calculator_create_new_window (self, _tmp2_);
	_g_object_unref0 (self->priv->last_opened_window);
	self->priv->last_opened_window = _tmp3_;
	_tmp4_ = currency_manager_get_default (TRUE, TRUE);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->settings;
	currency_manager_set_refresh_interval (_tmp5_, g_settings_get_int (_tmp6_, "refresh-interval"));
	_g_object_unref0 (_tmp5_);
	_tmp7_ = currency_manager_get_default (TRUE, TRUE);
	_tmp8_ = _tmp7_;
	currency_manager_refresh_async (_tmp8_, FALSE);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = self->priv->settings;
	g_signal_connect_object (_tmp9_, "changed::refresh-interval", (GCallback) ___lambda52__g_settings_changed, self, 0);
	_tmp10_ = self->priv->settings;
	_tmp11_ = currency_manager_get_default (TRUE, TRUE);
	_tmp12_ = _tmp11_;
	g_settings_bind (_tmp10_, "favorite-currencies", (GObject*) _tmp12_, "favorite_currencies", G_SETTINGS_BIND_GET);
	_g_object_unref0 (_tmp12_);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
calculator_real_activate (GApplication* base)
{
	Calculator * self;
	MathWindow* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gboolean _tmp28_ = FALSE;
	const gchar* _tmp29_;
	self = (Calculator*) base;
	G_APPLICATION_CLASS (calculator_parent_class)->activate ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_get_type (), AdwApplication));
	_tmp0_ = self->priv->last_opened_window;
	gtk_window_present ((GtkWindow*) _tmp0_);
	_tmp2_ = calculator_equation_string;
	if (g_strcmp0 (_tmp2_, "") != 0) {
		const gchar* _tmp3_;
		_tmp3_ = calculator_equation_string;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar** equations = NULL;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar** _tmp7_;
		gchar** _tmp8_;
		gchar** _tmp9_;
		gint _tmp9__length1;
		gint equations_length1;
		gint _equations_size_;
		_tmp4_ = calculator_equation_string;
		_tmp5_ = g_strcompress (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "\n", 0);
		_tmp9_ = _tmp8_;
		_tmp9__length1 = _vala_array_length (_tmp7_);
		_g_free0 (_tmp6_);
		equations = _tmp9_;
		equations_length1 = _tmp9__length1;
		_equations_size_ = equations_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp10_ = FALSE;
				_tmp10_ = TRUE;
				while (TRUE) {
					gchar** _tmp12_;
					gint _tmp12__length1;
					gchar** _tmp13_;
					gint _tmp13__length1;
					const gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					gboolean _tmp19_;
					if (!_tmp10_) {
						gint _tmp11_;
						_tmp11_ = i;
						i = _tmp11_ + 1;
					}
					_tmp10_ = FALSE;
					_tmp12_ = equations;
					_tmp12__length1 = equations_length1;
					if (!(i < _tmp12__length1)) {
						break;
					}
					_tmp13_ = equations;
					_tmp13__length1 = equations_length1;
					_tmp14_ = _tmp13_[i];
					_tmp15_ = string_strip (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = strlen (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = _tmp18_ > 0;
					_g_free0 (_tmp16_);
					if (_tmp19_) {
						MathWindow* _tmp20_;
						MathEquation* _tmp21_;
						MathEquation* _tmp22_;
						gchar** _tmp23_;
						gint _tmp23__length1;
						const gchar* _tmp24_;
						_tmp20_ = self->priv->last_opened_window;
						_tmp21_ = math_window_get_equation (_tmp20_);
						_tmp22_ = _tmp21_;
						_tmp23_ = equations;
						_tmp23__length1 = equations_length1;
						_tmp24_ = _tmp23_[i];
						math_equation_set (_tmp22_, _tmp24_);
					} else {
						MathWindow* _tmp25_;
						MathEquation* _tmp26_;
						MathEquation* _tmp27_;
						_tmp25_ = self->priv->last_opened_window;
						_tmp26_ = math_window_get_equation (_tmp25_);
						_tmp27_ = _tmp26_;
						math_equation_solve (_tmp27_);
					}
				}
			}
		}
		equations = (_vala_array_free (equations, equations_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp29_ = calculator_mode_string;
	if (g_strcmp0 (_tmp29_, "") != 0) {
		const gchar* _tmp30_;
		_tmp30_ = calculator_mode_string;
		_tmp28_ = _tmp30_ != NULL;
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		ButtonMode mode = 0;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		GQuark _tmp34_ = 0U;
		static GQuark _tmp33_label0 = 0;
		static GQuark _tmp33_label1 = 0;
		static GQuark _tmp33_label2 = 0;
		static GQuark _tmp33_label3 = 0;
		static GQuark _tmp33_label4 = 0;
		static GQuark _tmp33_label5 = 0;
		MathWindow* _tmp35_;
		MathButtons* _tmp36_;
		MathButtons* _tmp37_;
		mode = BUTTON_MODE_BASIC;
		_tmp31_ = calculator_mode_string;
		_tmp32_ = _tmp31_;
		_tmp34_ = (NULL == _tmp32_) ? 0 : g_quark_from_string (_tmp32_);
		if (_tmp34_ == ((0 != _tmp33_label0) ? _tmp33_label0 : (_tmp33_label0 = g_quark_from_static_string ("basic")))) {
			switch (0) {
				default:
				{
					mode = BUTTON_MODE_BASIC;
					break;
				}
			}
		} else if (_tmp34_ == ((0 != _tmp33_label1) ? _tmp33_label1 : (_tmp33_label1 = g_quark_from_static_string ("advanced")))) {
			switch (0) {
				default:
				{
					mode = BUTTON_MODE_ADVANCED;
					break;
				}
			}
		} else if (_tmp34_ == ((0 != _tmp33_label2) ? _tmp33_label2 : (_tmp33_label2 = g_quark_from_static_string ("financial")))) {
			switch (0) {
				default:
				{
					mode = BUTTON_MODE_FINANCIAL;
					break;
				}
			}
		} else if (_tmp34_ == ((0 != _tmp33_label3) ? _tmp33_label3 : (_tmp33_label3 = g_quark_from_static_string ("programming")))) {
			switch (0) {
				default:
				{
					mode = BUTTON_MODE_PROGRAMMING;
					break;
				}
			}
		} else if (_tmp34_ == ((0 != _tmp33_label4) ? _tmp33_label4 : (_tmp33_label4 = g_quark_from_static_string ("keyboard")))) {
			switch (0) {
				default:
				{
					mode = BUTTON_MODE_KEYBOARD;
					break;
				}
			}
		} else if (_tmp34_ == ((0 != _tmp33_label5) ? _tmp33_label5 : (_tmp33_label5 = g_quark_from_static_string ("conversion")))) {
			switch (0) {
				default:
				{
					mode = BUTTON_MODE_CONVERSION;
					break;
				}
			}
		}
		_tmp35_ = self->priv->last_opened_window;
		_tmp36_ = math_window_get_buttons (_tmp35_);
		_tmp37_ = _tmp36_;
		math_buttons_set_mode (_tmp37_, mode);
	}
}

static void
calculator_real_shutdown (GApplication* base)
{
	Calculator * self;
	MathWindow* window = NULL;
	MathWindow* _tmp0_;
	MathWindow* _tmp1_;
	MathConverter* converter = NULL;
	MathConverter* _tmp2_;
	MathConverter* _tmp3_;
	MathConverter* _tmp4_;
	MathButtons* buttons = NULL;
	MathButtons* _tmp5_;
	MathButtons* _tmp6_;
	MathButtons* _tmp7_;
	GSettings* _tmp8_;
	ButtonMode _tmp9_;
	ButtonMode _tmp10_;
	GSettings* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GSettings* _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gint _tmp16_ = 0;
	gchar** _tmp17_;
	gint _tmp17__length1;
	gchar** _tmp18_;
	gint _tmp18__length1;
	GSettings* _tmp19_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	gint _tmp21_ = 0;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gchar** _tmp23_;
	gint _tmp23__length1;
	GSettings* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	GSettings* _tmp27_;
	gboolean _tmp28_;
	gboolean _tmp29_;
	gint width = 0;
	gint height = 0;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	GSettings* _tmp32_;
	GSettings* _tmp33_;
	self = (Calculator*) base;
	_tmp0_ = self->priv->last_opened_window;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	window = _tmp1_;
	_tmp2_ = math_window_get_converter (window);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	converter = _tmp4_;
	_tmp5_ = math_window_get_buttons (window);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	buttons = _tmp7_;
	_tmp8_ = self->priv->settings;
	_tmp9_ = math_buttons_get_mode (buttons);
	_tmp10_ = _tmp9_;
	g_settings_set_enum (_tmp8_, "button-mode", (gint) _tmp10_);
	_tmp11_ = self->priv->settings;
	_tmp12_ = math_converter_get_category (converter);
	_tmp13_ = _tmp12_;
	g_settings_set_string (_tmp11_, "unit-category", _tmp13_);
	_g_free0 (_tmp13_);
	_tmp14_ = self->priv->settings;
	_tmp15_ = math_converter_get_source_units (converter, &_tmp16_);
	_tmp15__length1 = _tmp16_;
	_tmp17_ = _tmp15_;
	_tmp17__length1 = _tmp15__length1;
	_tmp18_ = _tmp17_;
	_tmp18__length1 = _tmp17__length1;
	g_settings_set_strv (_tmp14_, "source-units", _tmp18_);
	_tmp18_ = (_vala_array_free (_tmp18_, _tmp18__length1, (GDestroyNotify) g_free), NULL);
	_tmp19_ = self->priv->settings;
	_tmp20_ = math_converter_get_target_units (converter, &_tmp21_);
	_tmp20__length1 = _tmp21_;
	_tmp22_ = _tmp20_;
	_tmp22__length1 = _tmp20__length1;
	_tmp23_ = _tmp22_;
	_tmp23__length1 = _tmp22__length1;
	g_settings_set_strv (_tmp19_, "target-units", _tmp23_);
	_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
	_tmp24_ = self->priv->settings;
	_tmp25_ = math_buttons_get_programming_base (buttons);
	_tmp26_ = _tmp25_;
	g_settings_set_int (_tmp24_, "base", _tmp26_);
	_tmp27_ = self->priv->settings;
	g_object_get ((GtkWindow*) window, "maximized", &_tmp28_, NULL);
	_tmp29_ = _tmp28_;
	g_settings_set_boolean (_tmp27_, "window-maximized", _tmp29_);
	gtk_window_get_default_size ((GtkWindow*) window, &_tmp30_, &_tmp31_);
	width = _tmp30_;
	height = _tmp31_;
	_tmp32_ = self->priv->settings;
	g_settings_set (_tmp32_, "window-size", "(ii)", width, height);
	_tmp33_ = self->priv->settings;
	g_settings_apply (_tmp33_);
	G_APPLICATION_CLASS (calculator_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_get_type (), AdwApplication));
	_g_object_unref0 (buttons);
	_g_object_unref0 (converter);
	_g_object_unref0 (window);
}

static gchar*
_variant_get1 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gint
calculator_real_handle_local_options (GApplication* base,
                                      GVariantDict* options)
{
	Calculator * self;
	gint result;
	self = (Calculator*) base;
	g_return_val_if_fail (options != NULL, 0);
	if (g_variant_dict_contains (options, "version")) {
		FILE* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = stderr;
		_tmp1_ = calculator_program_name;
		fprintf (_tmp0_, "%1$s %2$s\n", _tmp1_, VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	if (g_variant_dict_contains (options, "solve")) {
		gchar* solve_equation = NULL;
		const GVariantType* _tmp2_;
		GVariant* _tmp3_;
		GVariant* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* tsep_string = NULL;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gboolean _tmp9_ = FALSE;
		const gchar* _tmp10_;
		gchar* decimal = NULL;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		GSettings* _tmp19_;
		AngleUnit angle_units = 0;
		GSettings* _tmp20_;
		Equation* e = NULL;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		Equation* _tmp28_;
		Equation* _tmp29_;
		Equation* _tmp30_;
		Equation* _tmp31_;
		Equation* _tmp32_;
		ErrorCode _error_ = 0;
		gchar* error_token = NULL;
		guint representation_base = 0U;
		Number* _result_ = NULL;
		Equation* _tmp33_;
		guint _tmp34_ = 0U;
		ErrorCode _tmp35_ = 0;
		gchar* _tmp36_ = NULL;
		Number* _tmp37_;
		Number* _tmp48_;
		_tmp2_ = G_VARIANT_TYPE_STRING;
		_tmp3_ = g_variant_dict_lookup_value (options, "solve", _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _variant_get1 (_tmp4_);
		_tmp6_ = _tmp5_;
		_g_variant_unref0 (_tmp4_);
		solve_equation = _tmp6_;
		_tmp7_ = nl_langinfo (THOUSEP);
		_tmp8_ = g_strdup (_tmp7_);
		tsep_string = _tmp8_;
		_tmp10_ = tsep_string;
		if (_tmp10_ == NULL) {
			_tmp9_ = TRUE;
		} else {
			const gchar* _tmp11_;
			_tmp11_ = tsep_string;
			_tmp9_ = g_strcmp0 (_tmp11_, "") == 0;
		}
		if (_tmp9_) {
			gchar* _tmp12_;
			_tmp12_ = g_strdup (" ");
			_g_free0 (tsep_string);
			tsep_string = _tmp12_;
		} else {
			const gchar* _tmp13_;
			_tmp13_ = tsep_string;
			if (g_strcmp0 (_tmp13_, ".") == 0) {
				gchar* _tmp14_;
				_tmp14_ = g_strdup ("");
				_g_free0 (tsep_string);
				tsep_string = _tmp14_;
			}
		}
		_tmp15_ = nl_langinfo (RADIXCHAR);
		_tmp16_ = g_strdup (_tmp15_);
		decimal = _tmp16_;
		_tmp17_ = decimal;
		if (_tmp17_ == NULL) {
			gchar* _tmp18_;
			_tmp18_ = g_strdup ("");
			_g_free0 (decimal);
			decimal = _tmp18_;
		}
		_tmp19_ = g_settings_new ("org.gnome.calculator");
		_g_object_unref0 (self->priv->settings);
		self->priv->settings = _tmp19_;
		_tmp20_ = self->priv->settings;
		angle_units = (AngleUnit) g_settings_get_enum (_tmp20_, "angle-units");
		_tmp21_ = solve_equation;
		_tmp22_ = tsep_string;
		_tmp23_ = string_replace (_tmp21_, _tmp22_, "");
		_tmp24_ = _tmp23_;
		_tmp25_ = decimal;
		_tmp26_ = string_replace (_tmp24_, _tmp25_, ".");
		_tmp27_ = _tmp26_;
		_tmp28_ = equation_new (_tmp27_);
		_tmp29_ = _tmp28_;
		_g_free0 (_tmp27_);
		_g_free0 (_tmp24_);
		e = _tmp29_;
		_tmp30_ = e;
		_tmp30_->base = 10;
		_tmp31_ = e;
		_tmp31_->wordlen = 32;
		_tmp32_ = e;
		_tmp32_->angle_units = angle_units;
		error_token = NULL;
		_tmp33_ = e;
		_tmp37_ = equation_parse (_tmp33_, &_tmp34_, &_tmp35_, &_tmp36_, NULL, NULL);
		representation_base = _tmp34_;
		_error_ = _tmp35_;
		_g_free0 (error_token);
		error_token = _tmp36_;
		_result_ = _tmp37_;
		if (_error_ == ERROR_CODE_UNKNOWN_RATE) {
			CurrencyManager* _tmp38_;
			CurrencyManager* _tmp39_;
			GSettings* _tmp40_;
			CurrencyManager* _tmp41_;
			CurrencyManager* _tmp42_;
			Equation* _tmp43_;
			guint _tmp44_ = 0U;
			ErrorCode _tmp45_ = 0;
			gchar* _tmp46_ = NULL;
			Number* _tmp47_;
			_tmp38_ = currency_manager_get_default (TRUE, TRUE);
			_tmp39_ = _tmp38_;
			_tmp40_ = self->priv->settings;
			currency_manager_set_refresh_interval (_tmp39_, g_settings_get_int (_tmp40_, "refresh-interval"));
			_g_object_unref0 (_tmp39_);
			_tmp41_ = currency_manager_get_default (TRUE, TRUE);
			_tmp42_ = _tmp41_;
			currency_manager_refresh_sync (_tmp42_);
			_g_object_unref0 (_tmp42_);
			_tmp43_ = e;
			_tmp47_ = equation_parse (_tmp43_, &_tmp44_, &_tmp45_, &_tmp46_, NULL, NULL);
			representation_base = _tmp44_;
			_error_ = _tmp45_;
			_g_free0 (error_token);
			error_token = _tmp46_;
			_g_object_unref0 (_result_);
			_result_ = _tmp47_;
		}
		_tmp48_ = _result_;
		if (_tmp48_ != NULL) {
			Serializer* serializer = NULL;
			Serializer* _tmp49_;
			Serializer* _tmp50_;
			gchar* eq_result = NULL;
			Serializer* _tmp51_;
			Number* _tmp52_;
			gchar* _tmp53_;
			Serializer* _tmp54_;
			const gchar* _tmp55_;
			const gchar* _tmp56_;
			FILE* _tmp61_;
			const gchar* _tmp62_;
			_tmp49_ = serializer_new (DISPLAY_FORMAT_AUTOMATIC, 10, 9);
			serializer = _tmp49_;
			_tmp50_ = serializer;
			serializer_set_representation_base (_tmp50_, representation_base);
			_tmp51_ = serializer;
			_tmp52_ = _result_;
			_tmp53_ = serializer_to_string (_tmp51_, _tmp52_);
			eq_result = _tmp53_;
			_tmp54_ = serializer;
			_tmp55_ = serializer_get_error (_tmp54_);
			_tmp56_ = _tmp55_;
			if (_tmp56_ != NULL) {
				FILE* _tmp57_;
				Serializer* _tmp58_;
				const gchar* _tmp59_;
				const gchar* _tmp60_;
				_tmp57_ = stderr;
				_tmp58_ = serializer;
				_tmp59_ = serializer_get_error (_tmp58_);
				_tmp60_ = _tmp59_;
				fprintf (_tmp57_, "%s", _tmp60_);
				result = EXIT_FAILURE;
				_g_free0 (eq_result);
				_g_object_unref0 (serializer);
				_g_object_unref0 (_result_);
				_g_free0 (error_token);
				_g_object_unref0 (e);
				_g_free0 (decimal);
				_g_free0 (tsep_string);
				_g_free0 (solve_equation);
				return result;
			}
			_tmp61_ = stdout;
			_tmp62_ = eq_result;
			fprintf (_tmp61_, "%s\n", _tmp62_);
			result = EXIT_SUCCESS;
			_g_free0 (eq_result);
			_g_object_unref0 (serializer);
			_g_object_unref0 (_result_);
			_g_free0 (error_token);
			_g_object_unref0 (e);
			_g_free0 (decimal);
			_g_free0 (tsep_string);
			_g_free0 (solve_equation);
			return result;
		} else {
			if (_error_ == ERROR_CODE_MP) {
				const gchar* _tmp63_ = NULL;
				const gchar* _tmp64_;
				const gchar* _tmp65_;
				FILE* _tmp69_;
				_tmp64_ = number_get_error ();
				_tmp65_ = _tmp64_;
				if (_tmp65_ != NULL) {
					const gchar* _tmp66_;
					const gchar* _tmp67_;
					_tmp66_ = number_get_error ();
					_tmp67_ = _tmp66_;
					_tmp63_ = _tmp67_;
				} else {
					const gchar* _tmp68_;
					_tmp68_ = error_token;
					_tmp63_ = _tmp68_;
				}
				_tmp69_ = stderr;
				fprintf (_tmp69_, "Error: %s\n", _tmp63_);
				result = EXIT_FAILURE;
				_g_object_unref0 (_result_);
				_g_free0 (error_token);
				_g_object_unref0 (e);
				_g_free0 (decimal);
				_g_free0 (tsep_string);
				_g_free0 (solve_equation);
				return result;
			} else {
				FILE* _tmp70_;
				gchar* _tmp71_;
				gchar* _tmp72_;
				_tmp70_ = stderr;
				_tmp71_ = mp_error_code_to_string (_error_);
				_tmp72_ = _tmp71_;
				fprintf (_tmp70_, "Error: %s\n", _tmp72_);
				_g_free0 (_tmp72_);
				result = EXIT_FAILURE;
				_g_object_unref0 (_result_);
				_g_free0 (error_token);
				_g_object_unref0 (e);
				_g_free0 (decimal);
				_g_free0 (tsep_string);
				_g_free0 (solve_equation);
				return result;
			}
		}
		_g_object_unref0 (_result_);
		_g_free0 (error_token);
		_g_object_unref0 (e);
		_g_free0 (decimal);
		_g_free0 (tsep_string);
		_g_free0 (solve_equation);
	}
	result = -1;
	return result;
}

static void
calculator_help_cb (Calculator* self)
{
	GtkUriLauncher* _tmp0_;
	GtkUriLauncher* _tmp1_;
	GtkWindow* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_uri_launcher_new ("help:gnome-calculator");
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_application_get_active_window ((GtkApplication*) self);
	gtk_uri_launcher_launch (_tmp1_, _tmp2_, NULL, NULL, NULL);
	_g_object_unref0 (_tmp1_);
}

static gchar**
_vala_array_dup4 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup5 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static void
calculator_about_cb (Calculator* self)
{
	gchar** developers = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gint developers_length1;
	gint _developers_size_;
	gchar** documenters = NULL;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gint documenters_length1;
	gint _documenters_size_;
	AdwAboutDialog* about = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gchar* _tmp17_;
	AdwAboutDialog* _tmp18_ = NULL;
	gchar* providers = NULL;
	CurrencyManager* _tmp19_;
	CurrencyManager* _tmp20_;
	gint _tmp21_ = 0;
	gchar** _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GtkWindow* _tmp28_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Robert Roth <robert.roth.off@gmail.com>");
	_tmp1_ = g_strdup ("Robert Ancell");
	_tmp2_ = g_strdup ("Klaus Niederkrüger");
	_tmp3_ = g_strdup ("Robin Sonefors");
	_tmp4_ = g_strdup ("Rich Burridge");
	_tmp5_ = g_new0 (gchar*, 6 + 1);
	_tmp5_[0] = _tmp0_;
	_tmp5_[1] = _tmp1_;
	_tmp5_[2] = _tmp2_;
	_tmp5_[3] = _tmp3_;
	_tmp5_[4] = _tmp4_;
	_tmp5_[5] = NULL;
	developers = _tmp5_;
	developers_length1 = 6;
	_developers_size_ = developers_length1;
	_tmp6_ = g_strdup ("Sun Microsystems");
	_tmp7_ = g_new0 (gchar*, 2 + 1);
	_tmp7_[0] = _tmp6_;
	_tmp7_[1] = NULL;
	documenters = _tmp7_;
	documenters_length1 = 2;
	_documenters_size_ = documenters_length1;
	_tmp8_ = g_strdup (_ ("Calculator"));
	_tmp9_ = g_strdup (APP_ID);
	_tmp10_ = g_strdup (_ ("The GNOME Project"));
	_tmp11_ = g_strdup (VERSION);
	_tmp12_ = g_strdup ("https://apps.gnome.org/Calculator");
	_tmp13_ = g_strdup ("https://gitlab.gnome.org/GNOME/gnome-calculator/-/issues/");
	_tmp14_ = g_strdup_printf (_ ("\xc2\xa9 1986–%d The Calculator authors"), (atoi (VERSION) / 2) + 2001);
	_tmp15_ = (developers != NULL) ? _vala_array_dup4 (developers, developers_length1) : developers;
	_tmp15__length1 = developers_length1;
	_tmp16_ = (documenters != NULL) ? _vala_array_dup5 (documenters, documenters_length1) : documenters;
	_tmp16__length1 = documenters_length1;
	_tmp17_ = g_strdup (_ ("translator-credits"));
	_tmp18_ = (AdwAboutDialog*) adw_about_dialog_new ();
	adw_about_dialog_set_application_name (_tmp18_, _tmp8_);
	_g_free0 (_tmp8_);
	adw_about_dialog_set_application_icon (_tmp18_, _tmp9_);
	_g_free0 (_tmp9_);
	adw_about_dialog_set_developer_name (_tmp18_, _tmp10_);
	_g_free0 (_tmp10_);
	adw_about_dialog_set_version (_tmp18_, _tmp11_);
	_g_free0 (_tmp11_);
	adw_about_dialog_set_website (_tmp18_, _tmp12_);
	_g_free0 (_tmp12_);
	adw_about_dialog_set_issue_url (_tmp18_, _tmp13_);
	_g_free0 (_tmp13_);
	adw_about_dialog_set_copyright (_tmp18_, _tmp14_);
	_g_free0 (_tmp14_);
	adw_about_dialog_set_license_type (_tmp18_, GTK_LICENSE_GPL_3_0);
	adw_about_dialog_set_developers (_tmp18_, _tmp15_);
	_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_free), NULL);
	adw_about_dialog_set_documenters (_tmp18_, _tmp16_);
	_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
	adw_about_dialog_set_translator_credits (_tmp18_, _tmp17_);
	_g_free0 (_tmp17_);
	g_object_ref_sink (_tmp18_);
	about = _tmp18_;
	_tmp19_ = currency_manager_get_default (TRUE, TRUE);
	_tmp20_ = _tmp19_;
	_tmp22_ = currency_manager_get_provider_links (_tmp20_, &_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp23__length1 = _tmp21_;
	_tmp24_ = _vala_g_strjoinv (", ", _tmp23_, (gint) _tmp21_);
	_tmp25_ = _tmp24_;
	_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_tmp20_);
	providers = _tmp25_;
	_tmp26_ = g_strdup_printf (_ ("Exchange rates data by %s"), providers);
	_tmp27_ = _tmp26_;
	adw_about_dialog_add_legal_section (about, _ ("Exchange Rate Data Providers"), NULL, GTK_LICENSE_CUSTOM, _tmp27_);
	_g_free0 (_tmp27_);
	_tmp28_ = gtk_application_get_active_window ((GtkApplication*) self);
	adw_dialog_present ((AdwDialog*) about, (GtkWidget*) _tmp28_);
	_g_free0 (providers);
	_g_object_unref0 (about);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	developers = (_vala_array_free (developers, developers_length1, (GDestroyNotify) g_free), NULL);
}

static void
___lambda51_ (Calculator* self,
              const gchar* _result_)
{
	g_return_if_fail (_result_ != NULL);
	if (g_strcmp0 (_result_, "close-all") == 0) {
		g_application_quit ((GApplication*) self);
	}
}

static void
____lambda51__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                         const gchar* response,
                                         gpointer self)
{
	___lambda51_ ((Calculator*) self, response);
}

static void
calculator_quit_cb (Calculator* self)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
	if (g_list_length (_tmp0_) > ((guint) 1)) {
		AdwAlertDialog* dialog = NULL;
		AdwAlertDialog* _tmp1_;
		AdwAlertDialog* _tmp2_;
		AdwAlertDialog* _tmp3_;
		AdwAlertDialog* _tmp4_;
		AdwAlertDialog* _tmp5_;
		AdwAlertDialog* _tmp6_;
		AdwAlertDialog* _tmp7_;
		GtkWindow* _tmp8_;
		_tmp1_ = (AdwAlertDialog*) adw_alert_dialog_new (_ ("Close All?"), _ ("Are you sure you want to close all open windows?"));
		g_object_ref_sink (_tmp1_);
		dialog = _tmp1_;
		_tmp2_ = dialog;
		adw_alert_dialog_add_responses (_tmp2_, "cancel", _ ("_Cancel"), "close-all", _ ("Close _All"), NULL);
		_tmp3_ = dialog;
		adw_alert_dialog_set_response_appearance (_tmp3_, "close-all", ADW_RESPONSE_DESTRUCTIVE);
		_tmp4_ = dialog;
		adw_alert_dialog_set_default_response (_tmp4_, "cancel");
		_tmp5_ = dialog;
		adw_alert_dialog_set_close_response (_tmp5_, "cancel");
		_tmp6_ = dialog;
		g_signal_connect_object (_tmp6_, "response", (GCallback) ____lambda51__adw_alert_dialog_response, self, 0);
		_tmp7_ = dialog;
		_tmp8_ = gtk_application_get_active_window ((GtkApplication*) self);
		adw_dialog_present ((AdwDialog*) _tmp7_, (GtkWidget*) _tmp8_);
		_g_object_unref0 (dialog);
	} else {
		g_application_quit ((GApplication*) self);
	}
}

static void
calculator_new_window_cb (Calculator* self)
{
	MathWindow* window = NULL;
	GSettings* _tmp0_;
	MathWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = calculator_create_new_window (self, _tmp0_);
	window = _tmp1_;
	gtk_window_present ((GtkWindow*) window);
	_g_object_unref0 (window);
}

static gint
calculator_main (gchar** args,
                 gint args_length1)
{
	GDateTime* now = NULL;
	GDateTime* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	Calculator* app = NULL;
	Calculator* _tmp3_;
	gint result;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = g_date_time_new_now_utc ();
	now = _tmp0_;
	g_random_set_seed ((guint32) g_date_time_get_microsecond (now));
	_tmp1_ = args[0];
	_tmp2_ = g_path_get_basename (_tmp1_);
	_g_free0 (calculator_program_name);
	calculator_program_name = _tmp2_;
	gtk_window_set_default_icon_name (APP_ID);
	_tmp3_ = calculator_new ();
	app = _tmp3_;
	result = g_application_run ((GApplication*) app, (gint) args_length1, args);
	_g_object_unref0 (app);
	_g_date_time_unref0 (now);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return calculator_main (argv, argc);
}

static void
calculator_class_init (CalculatorClass * klass,
                       gpointer klass_data)
{
	calculator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Calculator_private_offset);
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) calculator_real_startup;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) calculator_real_activate;
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication*)) calculator_real_shutdown;
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) calculator_real_handle_local_options;
	G_OBJECT_CLASS (klass)->finalize = calculator_finalize;
}

static void
calculator_instance_init (Calculator * self,
                          gpointer klass)
{
	self->priv = calculator_get_instance_private (self);
}

static void
calculator_finalize (GObject * obj)
{
	Calculator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CALCULATOR, Calculator);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->last_opened_window);
	G_OBJECT_CLASS (calculator_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
calculator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CalculatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) calculator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Calculator), 0, (GInstanceInitFunc) calculator_instance_init, NULL };
	GType calculator_type_id;
	calculator_type_id = g_type_register_static (adw_application_get_type (), "Calculator", &g_define_type_info, 0);
	Calculator_private_offset = g_type_add_instance_private (calculator_type_id, sizeof (CalculatorPrivate));
	return calculator_type_id;
}

GType
calculator_get_type (void)
{
	static gsize calculator_type_id__once = 0;
	if (g_once_init_enter (&calculator_type_id__once)) {
		GType calculator_type_id;
		calculator_type_id = calculator_get_type_once ();
		g_once_init_leave (&calculator_type_id__once, calculator_type_id);
	}
	return calculator_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

