{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Implements the @GtkMediaStream@ interface for files.
-- 
-- This provides a simple way to play back video files with GTK.
-- 
-- GTK provides a GIO extension point for @GtkMediaFile@ implementations
-- to allow for external implementations using various media frameworks.
-- 
-- GTK itself includes an implementation using GStreamer.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.MediaFile
    ( 

-- * Exported types
    MediaFile(..)                           ,
    IsMediaFile                             ,
    toMediaFile                             ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [clear]("GI.Gtk.Objects.MediaFile#g:method:clear"), [computeConcreteSize]("GI.Gdk.Interfaces.Paintable#g:method:computeConcreteSize"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [gerror]("GI.Gtk.Objects.MediaStream#g:method:gerror"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hasAudio]("GI.Gtk.Objects.MediaStream#g:method:hasAudio"), [hasVideo]("GI.Gtk.Objects.MediaStream#g:method:hasVideo"), [invalidateContents]("GI.Gdk.Interfaces.Paintable#g:method:invalidateContents"), [invalidateSize]("GI.Gdk.Interfaces.Paintable#g:method:invalidateSize"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isPrepared]("GI.Gtk.Objects.MediaStream#g:method:isPrepared"), [isSeekable]("GI.Gtk.Objects.MediaStream#g:method:isSeekable"), [isSeeking]("GI.Gtk.Objects.MediaStream#g:method:isSeeking"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [pause]("GI.Gtk.Objects.MediaStream#g:method:pause"), [play]("GI.Gtk.Objects.MediaStream#g:method:play"), [realize]("GI.Gtk.Objects.MediaStream#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [seek]("GI.Gtk.Objects.MediaStream#g:method:seek"), [seekFailed]("GI.Gtk.Objects.MediaStream#g:method:seekFailed"), [seekSuccess]("GI.Gtk.Objects.MediaStream#g:method:seekSuccess"), [snapshot]("GI.Gdk.Interfaces.Paintable#g:method:snapshot"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [streamEnded]("GI.Gtk.Objects.MediaStream#g:method:streamEnded"), [streamPrepared]("GI.Gtk.Objects.MediaStream#g:method:streamPrepared"), [streamUnprepared]("GI.Gtk.Objects.MediaStream#g:method:streamUnprepared"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unrealize]("GI.Gtk.Objects.MediaStream#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [update]("GI.Gtk.Objects.MediaStream#g:method:update"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getCurrentImage]("GI.Gdk.Interfaces.Paintable#g:method:getCurrentImage"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDuration]("GI.Gtk.Objects.MediaStream#g:method:getDuration"), [getEnded]("GI.Gtk.Objects.MediaStream#g:method:getEnded"), [getError]("GI.Gtk.Objects.MediaStream#g:method:getError"), [getFile]("GI.Gtk.Objects.MediaFile#g:method:getFile"), [getFlags]("GI.Gdk.Interfaces.Paintable#g:method:getFlags"), [getInputStream]("GI.Gtk.Objects.MediaFile#g:method:getInputStream"), [getIntrinsicAspectRatio]("GI.Gdk.Interfaces.Paintable#g:method:getIntrinsicAspectRatio"), [getIntrinsicHeight]("GI.Gdk.Interfaces.Paintable#g:method:getIntrinsicHeight"), [getIntrinsicWidth]("GI.Gdk.Interfaces.Paintable#g:method:getIntrinsicWidth"), [getLoop]("GI.Gtk.Objects.MediaStream#g:method:getLoop"), [getMuted]("GI.Gtk.Objects.MediaStream#g:method:getMuted"), [getPlaying]("GI.Gtk.Objects.MediaStream#g:method:getPlaying"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getTimestamp]("GI.Gtk.Objects.MediaStream#g:method:getTimestamp"), [getVolume]("GI.Gtk.Objects.MediaStream#g:method:getVolume").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setFile]("GI.Gtk.Objects.MediaFile#g:method:setFile"), [setFilename]("GI.Gtk.Objects.MediaFile#g:method:setFilename"), [setInputStream]("GI.Gtk.Objects.MediaFile#g:method:setInputStream"), [setLoop]("GI.Gtk.Objects.MediaStream#g:method:setLoop"), [setMuted]("GI.Gtk.Objects.MediaStream#g:method:setMuted"), [setPlaying]("GI.Gtk.Objects.MediaStream#g:method:setPlaying"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setResource]("GI.Gtk.Objects.MediaFile#g:method:setResource"), [setVolume]("GI.Gtk.Objects.MediaStream#g:method:setVolume").

#if defined(ENABLE_OVERLOADING)
    ResolveMediaFileMethod                  ,
#endif

-- ** clear #method:clear#

#if defined(ENABLE_OVERLOADING)
    MediaFileClearMethodInfo                ,
#endif
    mediaFileClear                          ,


-- ** getFile #method:getFile#

#if defined(ENABLE_OVERLOADING)
    MediaFileGetFileMethodInfo              ,
#endif
    mediaFileGetFile                        ,


-- ** getInputStream #method:getInputStream#

#if defined(ENABLE_OVERLOADING)
    MediaFileGetInputStreamMethodInfo       ,
#endif
    mediaFileGetInputStream                 ,


-- ** new #method:new#

    mediaFileNew                            ,


-- ** newForFile #method:newForFile#

    mediaFileNewForFile                     ,


-- ** newForFilename #method:newForFilename#

    mediaFileNewForFilename                 ,


-- ** newForInputStream #method:newForInputStream#

    mediaFileNewForInputStream              ,


-- ** newForResource #method:newForResource#

    mediaFileNewForResource                 ,


-- ** setFile #method:setFile#

#if defined(ENABLE_OVERLOADING)
    MediaFileSetFileMethodInfo              ,
#endif
    mediaFileSetFile                        ,


-- ** setFilename #method:setFilename#

#if defined(ENABLE_OVERLOADING)
    MediaFileSetFilenameMethodInfo          ,
#endif
    mediaFileSetFilename                    ,


-- ** setInputStream #method:setInputStream#

#if defined(ENABLE_OVERLOADING)
    MediaFileSetInputStreamMethodInfo       ,
#endif
    mediaFileSetInputStream                 ,


-- ** setResource #method:setResource#

#if defined(ENABLE_OVERLOADING)
    MediaFileSetResourceMethodInfo          ,
#endif
    mediaFileSetResource                    ,




 -- * Properties


-- ** file #attr:file#
-- | The file being played back or 'P.Nothing' if not playing a file.

#if defined(ENABLE_OVERLOADING)
    MediaFileFilePropertyInfo               ,
#endif
    clearMediaFileFile                      ,
    constructMediaFileFile                  ,
    getMediaFileFile                        ,
#if defined(ENABLE_OVERLOADING)
    mediaFileFile                           ,
#endif
    setMediaFileFile                        ,


-- ** inputStream #attr:inputStream#
-- | The stream being played back or 'P.Nothing' if not playing a stream.
-- 
-- This is 'P.Nothing' when playing a file.

#if defined(ENABLE_OVERLOADING)
    MediaFileInputStreamPropertyInfo        ,
#endif
    clearMediaFileInputStream               ,
    constructMediaFileInputStream           ,
    getMediaFileInputStream                 ,
#if defined(ENABLE_OVERLOADING)
    mediaFileInputStream                    ,
#endif
    setMediaFileInputStream                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gtk.Objects.MediaStream as Gtk.MediaStream

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gtk.Objects.MediaStream as Gtk.MediaStream

#endif

-- | Memory-managed wrapper type.
newtype MediaFile = MediaFile (SP.ManagedPtr MediaFile)
    deriving (Eq)

instance SP.ManagedPtrNewtype MediaFile where
    toManagedPtr (MediaFile p) = p

foreign import ccall "gtk_media_file_get_type"
    c_gtk_media_file_get_type :: IO B.Types.GType

instance B.Types.TypedObject MediaFile where
    glibType = c_gtk_media_file_get_type

instance B.Types.GObject MediaFile

-- | Type class for types which can be safely cast to t'MediaFile', for instance with `toMediaFile`.
class (SP.GObject o, O.IsDescendantOf MediaFile o) => IsMediaFile o
instance (SP.GObject o, O.IsDescendantOf MediaFile o) => IsMediaFile o

instance O.HasParentTypes MediaFile
type instance O.ParentTypes MediaFile = '[Gtk.MediaStream.MediaStream, GObject.Object.Object, Gdk.Paintable.Paintable]

-- | Cast to t'MediaFile', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toMediaFile :: (MIO.MonadIO m, IsMediaFile o) => o -> m MediaFile
toMediaFile = MIO.liftIO . B.ManagedPtr.unsafeCastTo MediaFile

-- | Convert t'MediaFile' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe MediaFile) where
    gvalueGType_ = c_gtk_media_file_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr MediaFile)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr MediaFile)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject MediaFile ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveMediaFileMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveMediaFileMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveMediaFileMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveMediaFileMethod "clear" o = MediaFileClearMethodInfo
    ResolveMediaFileMethod "computeConcreteSize" o = Gdk.Paintable.PaintableComputeConcreteSizeMethodInfo
    ResolveMediaFileMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveMediaFileMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveMediaFileMethod "gerror" o = Gtk.MediaStream.MediaStreamGerrorMethodInfo
    ResolveMediaFileMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveMediaFileMethod "hasAudio" o = Gtk.MediaStream.MediaStreamHasAudioMethodInfo
    ResolveMediaFileMethod "hasVideo" o = Gtk.MediaStream.MediaStreamHasVideoMethodInfo
    ResolveMediaFileMethod "invalidateContents" o = Gdk.Paintable.PaintableInvalidateContentsMethodInfo
    ResolveMediaFileMethod "invalidateSize" o = Gdk.Paintable.PaintableInvalidateSizeMethodInfo
    ResolveMediaFileMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveMediaFileMethod "isPrepared" o = Gtk.MediaStream.MediaStreamIsPreparedMethodInfo
    ResolveMediaFileMethod "isSeekable" o = Gtk.MediaStream.MediaStreamIsSeekableMethodInfo
    ResolveMediaFileMethod "isSeeking" o = Gtk.MediaStream.MediaStreamIsSeekingMethodInfo
    ResolveMediaFileMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveMediaFileMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveMediaFileMethod "pause" o = Gtk.MediaStream.MediaStreamPauseMethodInfo
    ResolveMediaFileMethod "play" o = Gtk.MediaStream.MediaStreamPlayMethodInfo
    ResolveMediaFileMethod "realize" o = Gtk.MediaStream.MediaStreamRealizeMethodInfo
    ResolveMediaFileMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveMediaFileMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveMediaFileMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveMediaFileMethod "seek" o = Gtk.MediaStream.MediaStreamSeekMethodInfo
    ResolveMediaFileMethod "seekFailed" o = Gtk.MediaStream.MediaStreamSeekFailedMethodInfo
    ResolveMediaFileMethod "seekSuccess" o = Gtk.MediaStream.MediaStreamSeekSuccessMethodInfo
    ResolveMediaFileMethod "snapshot" o = Gdk.Paintable.PaintableSnapshotMethodInfo
    ResolveMediaFileMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveMediaFileMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveMediaFileMethod "streamEnded" o = Gtk.MediaStream.MediaStreamStreamEndedMethodInfo
    ResolveMediaFileMethod "streamPrepared" o = Gtk.MediaStream.MediaStreamStreamPreparedMethodInfo
    ResolveMediaFileMethod "streamUnprepared" o = Gtk.MediaStream.MediaStreamStreamUnpreparedMethodInfo
    ResolveMediaFileMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveMediaFileMethod "unrealize" o = Gtk.MediaStream.MediaStreamUnrealizeMethodInfo
    ResolveMediaFileMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveMediaFileMethod "update" o = Gtk.MediaStream.MediaStreamUpdateMethodInfo
    ResolveMediaFileMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveMediaFileMethod "getCurrentImage" o = Gdk.Paintable.PaintableGetCurrentImageMethodInfo
    ResolveMediaFileMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveMediaFileMethod "getDuration" o = Gtk.MediaStream.MediaStreamGetDurationMethodInfo
    ResolveMediaFileMethod "getEnded" o = Gtk.MediaStream.MediaStreamGetEndedMethodInfo
    ResolveMediaFileMethod "getError" o = Gtk.MediaStream.MediaStreamGetErrorMethodInfo
    ResolveMediaFileMethod "getFile" o = MediaFileGetFileMethodInfo
    ResolveMediaFileMethod "getFlags" o = Gdk.Paintable.PaintableGetFlagsMethodInfo
    ResolveMediaFileMethod "getInputStream" o = MediaFileGetInputStreamMethodInfo
    ResolveMediaFileMethod "getIntrinsicAspectRatio" o = Gdk.Paintable.PaintableGetIntrinsicAspectRatioMethodInfo
    ResolveMediaFileMethod "getIntrinsicHeight" o = Gdk.Paintable.PaintableGetIntrinsicHeightMethodInfo
    ResolveMediaFileMethod "getIntrinsicWidth" o = Gdk.Paintable.PaintableGetIntrinsicWidthMethodInfo
    ResolveMediaFileMethod "getLoop" o = Gtk.MediaStream.MediaStreamGetLoopMethodInfo
    ResolveMediaFileMethod "getMuted" o = Gtk.MediaStream.MediaStreamGetMutedMethodInfo
    ResolveMediaFileMethod "getPlaying" o = Gtk.MediaStream.MediaStreamGetPlayingMethodInfo
    ResolveMediaFileMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveMediaFileMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveMediaFileMethod "getTimestamp" o = Gtk.MediaStream.MediaStreamGetTimestampMethodInfo
    ResolveMediaFileMethod "getVolume" o = Gtk.MediaStream.MediaStreamGetVolumeMethodInfo
    ResolveMediaFileMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveMediaFileMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveMediaFileMethod "setFile" o = MediaFileSetFileMethodInfo
    ResolveMediaFileMethod "setFilename" o = MediaFileSetFilenameMethodInfo
    ResolveMediaFileMethod "setInputStream" o = MediaFileSetInputStreamMethodInfo
    ResolveMediaFileMethod "setLoop" o = Gtk.MediaStream.MediaStreamSetLoopMethodInfo
    ResolveMediaFileMethod "setMuted" o = Gtk.MediaStream.MediaStreamSetMutedMethodInfo
    ResolveMediaFileMethod "setPlaying" o = Gtk.MediaStream.MediaStreamSetPlayingMethodInfo
    ResolveMediaFileMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveMediaFileMethod "setResource" o = MediaFileSetResourceMethodInfo
    ResolveMediaFileMethod "setVolume" o = Gtk.MediaStream.MediaStreamSetVolumeMethodInfo
    ResolveMediaFileMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveMediaFileMethod t MediaFile, O.OverloadedMethod info MediaFile p) => OL.IsLabel t (MediaFile -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveMediaFileMethod t MediaFile, O.OverloadedMethod info MediaFile p, R.HasField t MediaFile p) => R.HasField t MediaFile p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveMediaFileMethod t MediaFile, O.OverloadedMethodInfo info MediaFile) => OL.IsLabel t (O.MethodProxy info MediaFile) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "file"
   -- Type: TInterface (Name {namespace = "Gio", name = "File"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@file@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' mediaFile #file
-- @
getMediaFileFile :: (MonadIO m, IsMediaFile o) => o -> m (Maybe Gio.File.File)
getMediaFileFile obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "file" Gio.File.File

-- | Set the value of the “@file@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' mediaFile [ #file 'Data.GI.Base.Attributes.:=' value ]
-- @
setMediaFileFile :: (MonadIO m, IsMediaFile o, Gio.File.IsFile a) => o -> a -> m ()
setMediaFileFile obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "file" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@file@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMediaFileFile :: (IsMediaFile o, MIO.MonadIO m, Gio.File.IsFile a) => a -> m (GValueConstruct o)
constructMediaFileFile val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "file" (P.Just val)

-- | Set the value of the “@file@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #file
-- @
clearMediaFileFile :: (MonadIO m, IsMediaFile o) => o -> m ()
clearMediaFileFile obj = liftIO $ B.Properties.setObjectPropertyObject obj "file" (Nothing :: Maybe Gio.File.File)

#if defined(ENABLE_OVERLOADING)
data MediaFileFilePropertyInfo
instance AttrInfo MediaFileFilePropertyInfo where
    type AttrAllowedOps MediaFileFilePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint MediaFileFilePropertyInfo = IsMediaFile
    type AttrSetTypeConstraint MediaFileFilePropertyInfo = Gio.File.IsFile
    type AttrTransferTypeConstraint MediaFileFilePropertyInfo = Gio.File.IsFile
    type AttrTransferType MediaFileFilePropertyInfo = Gio.File.File
    type AttrGetType MediaFileFilePropertyInfo = (Maybe Gio.File.File)
    type AttrLabel MediaFileFilePropertyInfo = "file"
    type AttrOrigin MediaFileFilePropertyInfo = MediaFile
    attrGet = getMediaFileFile
    attrSet = setMediaFileFile
    attrTransfer _ v = do
        unsafeCastTo Gio.File.File v
    attrConstruct = constructMediaFileFile
    attrClear = clearMediaFileFile
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaFile.file"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaFile.html#g:attr:file"
        })
#endif

-- VVV Prop "input-stream"
   -- Type: TInterface (Name {namespace = "Gio", name = "InputStream"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@input-stream@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' mediaFile #inputStream
-- @
getMediaFileInputStream :: (MonadIO m, IsMediaFile o) => o -> m (Maybe Gio.InputStream.InputStream)
getMediaFileInputStream obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "input-stream" Gio.InputStream.InputStream

-- | Set the value of the “@input-stream@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' mediaFile [ #inputStream 'Data.GI.Base.Attributes.:=' value ]
-- @
setMediaFileInputStream :: (MonadIO m, IsMediaFile o, Gio.InputStream.IsInputStream a) => o -> a -> m ()
setMediaFileInputStream obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "input-stream" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@input-stream@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMediaFileInputStream :: (IsMediaFile o, MIO.MonadIO m, Gio.InputStream.IsInputStream a) => a -> m (GValueConstruct o)
constructMediaFileInputStream val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "input-stream" (P.Just val)

-- | Set the value of the “@input-stream@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #inputStream
-- @
clearMediaFileInputStream :: (MonadIO m, IsMediaFile o) => o -> m ()
clearMediaFileInputStream obj = liftIO $ B.Properties.setObjectPropertyObject obj "input-stream" (Nothing :: Maybe Gio.InputStream.InputStream)

#if defined(ENABLE_OVERLOADING)
data MediaFileInputStreamPropertyInfo
instance AttrInfo MediaFileInputStreamPropertyInfo where
    type AttrAllowedOps MediaFileInputStreamPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint MediaFileInputStreamPropertyInfo = IsMediaFile
    type AttrSetTypeConstraint MediaFileInputStreamPropertyInfo = Gio.InputStream.IsInputStream
    type AttrTransferTypeConstraint MediaFileInputStreamPropertyInfo = Gio.InputStream.IsInputStream
    type AttrTransferType MediaFileInputStreamPropertyInfo = Gio.InputStream.InputStream
    type AttrGetType MediaFileInputStreamPropertyInfo = (Maybe Gio.InputStream.InputStream)
    type AttrLabel MediaFileInputStreamPropertyInfo = "input-stream"
    type AttrOrigin MediaFileInputStreamPropertyInfo = MediaFile
    attrGet = getMediaFileInputStream
    attrSet = setMediaFileInputStream
    attrTransfer _ v = do
        unsafeCastTo Gio.InputStream.InputStream v
    attrConstruct = constructMediaFileInputStream
    attrClear = clearMediaFileInputStream
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaFile.inputStream"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaFile.html#g:attr:inputStream"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList MediaFile
type instance O.AttributeList MediaFile = MediaFileAttributeList
type MediaFileAttributeList = ('[ '("duration", Gtk.MediaStream.MediaStreamDurationPropertyInfo), '("ended", Gtk.MediaStream.MediaStreamEndedPropertyInfo), '("error", Gtk.MediaStream.MediaStreamErrorPropertyInfo), '("file", MediaFileFilePropertyInfo), '("hasAudio", Gtk.MediaStream.MediaStreamHasAudioPropertyInfo), '("hasVideo", Gtk.MediaStream.MediaStreamHasVideoPropertyInfo), '("inputStream", MediaFileInputStreamPropertyInfo), '("loop", Gtk.MediaStream.MediaStreamLoopPropertyInfo), '("muted", Gtk.MediaStream.MediaStreamMutedPropertyInfo), '("playing", Gtk.MediaStream.MediaStreamPlayingPropertyInfo), '("prepared", Gtk.MediaStream.MediaStreamPreparedPropertyInfo), '("seekable", Gtk.MediaStream.MediaStreamSeekablePropertyInfo), '("seeking", Gtk.MediaStream.MediaStreamSeekingPropertyInfo), '("timestamp", Gtk.MediaStream.MediaStreamTimestampPropertyInfo), '("volume", Gtk.MediaStream.MediaStreamVolumePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
mediaFileFile :: AttrLabelProxy "file"
mediaFileFile = AttrLabelProxy

mediaFileInputStream :: AttrLabelProxy "inputStream"
mediaFileInputStream = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList MediaFile = MediaFileSignalList
type MediaFileSignalList = ('[ '("invalidateContents", Gdk.Paintable.PaintableInvalidateContentsSignalInfo), '("invalidateSize", Gdk.Paintable.PaintableInvalidateSizeSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method MediaFile::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "MediaFile" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_file_new" gtk_media_file_new :: 
    IO (Ptr MediaFile)

-- | Creates a new empty media file.
mediaFileNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m MediaFile
    -- ^ __Returns:__ a new @GtkMediaFile@
mediaFileNew  = liftIO $ do
    result <- gtk_media_file_new
    checkUnexpectedReturnNULL "mediaFileNew" result
    result' <- (wrapObject MediaFile) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method MediaFile::new_for_file
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "file"
--           , argType = TInterface Name { namespace = "Gio" , name = "File" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The file to play" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "MediaFile" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_file_new_for_file" gtk_media_file_new_for_file :: 
    Ptr Gio.File.File ->                    -- file : TInterface (Name {namespace = "Gio", name = "File"})
    IO (Ptr MediaFile)

-- | Creates a new media file to play /@file@/.
mediaFileNewForFile ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.File.IsFile a) =>
    a
    -- ^ /@file@/: The file to play
    -> m MediaFile
    -- ^ __Returns:__ a new @GtkMediaFile@ playing /@file@/
mediaFileNewForFile file = liftIO $ do
    file' <- unsafeManagedPtrCastPtr file
    result <- gtk_media_file_new_for_file file'
    checkUnexpectedReturnNULL "mediaFileNewForFile" result
    result' <- (wrapObject MediaFile) result
    touchManagedPtr file
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method MediaFile::new_for_filename
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "filename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "filename to open" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "MediaFile" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_file_new_for_filename" gtk_media_file_new_for_filename :: 
    CString ->                              -- filename : TBasicType TFileName
    IO (Ptr MediaFile)

-- | Creates a new media file for the given filename.
-- 
-- This is a utility function that converts the given /@filename@/
-- to a @GFile@ and calls 'GI.Gtk.Objects.MediaFile.mediaFileNewForFile'.
mediaFileNewForFilename ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@filename@/: filename to open
    -> m MediaFile
    -- ^ __Returns:__ a new @GtkMediaFile@ playing /@filename@/
mediaFileNewForFilename filename = liftIO $ do
    filename' <- stringToCString filename
    result <- gtk_media_file_new_for_filename filename'
    checkUnexpectedReturnNULL "mediaFileNewForFilename" result
    result' <- (wrapObject MediaFile) result
    freeMem filename'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method MediaFile::new_for_input_stream
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The stream to play" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "MediaFile" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_file_new_for_input_stream" gtk_media_file_new_for_input_stream :: 
    Ptr Gio.InputStream.InputStream ->      -- stream : TInterface (Name {namespace = "Gio", name = "InputStream"})
    IO (Ptr MediaFile)

-- | Creates a new media file to play /@stream@/.
-- 
-- If you want the resulting media to be seekable,
-- the stream should implement the @GSeekable@ interface.
mediaFileNewForInputStream ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.InputStream.IsInputStream a) =>
    a
    -- ^ /@stream@/: The stream to play
    -> m MediaFile
    -- ^ __Returns:__ a new @GtkMediaFile@
mediaFileNewForInputStream stream = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    result <- gtk_media_file_new_for_input_stream stream'
    checkUnexpectedReturnNULL "mediaFileNewForInputStream" result
    result' <- (wrapObject MediaFile) result
    touchManagedPtr stream
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method MediaFile::new_for_resource
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "resource_path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "resource path to open"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "MediaFile" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_file_new_for_resource" gtk_media_file_new_for_resource :: 
    CString ->                              -- resource_path : TBasicType TUTF8
    IO (Ptr MediaFile)

-- | Creates a new new media file for the given resource.
-- 
-- This is a utility function that converts the given /@resource@/
-- to a @GFile@ and calls 'GI.Gtk.Objects.MediaFile.mediaFileNewForFile'.
mediaFileNewForResource ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@resourcePath@/: resource path to open
    -> m MediaFile
    -- ^ __Returns:__ a new @GtkMediaFile@ playing /@resourcePath@/
mediaFileNewForResource resourcePath = liftIO $ do
    resourcePath' <- textToCString resourcePath
    result <- gtk_media_file_new_for_resource resourcePath'
    checkUnexpectedReturnNULL "mediaFileNewForResource" result
    result' <- (wrapObject MediaFile) result
    freeMem resourcePath'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method MediaFile::clear
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaFile" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaFile`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_file_clear" gtk_media_file_clear :: 
    Ptr MediaFile ->                        -- self : TInterface (Name {namespace = "Gtk", name = "MediaFile"})
    IO ()

-- | Resets the media file to be empty.
mediaFileClear ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaFile a) =>
    a
    -- ^ /@self@/: a @GtkMediaFile@
    -> m ()
mediaFileClear self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_media_file_clear self'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data MediaFileClearMethodInfo
instance (signature ~ (m ()), MonadIO m, IsMediaFile a) => O.OverloadedMethod MediaFileClearMethodInfo a signature where
    overloadedMethod = mediaFileClear

instance O.OverloadedMethodInfo MediaFileClearMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaFile.mediaFileClear",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaFile.html#v:mediaFileClear"
        })


#endif

-- method MediaFile::get_file
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaFile" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaFile`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "File" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_file_get_file" gtk_media_file_get_file :: 
    Ptr MediaFile ->                        -- self : TInterface (Name {namespace = "Gtk", name = "MediaFile"})
    IO (Ptr Gio.File.File)

-- | Returns the file that /@self@/ is currently playing from.
-- 
-- When /@self@/ is not playing or not playing from a file,
-- 'P.Nothing' is returned.
mediaFileGetFile ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaFile a) =>
    a
    -- ^ /@self@/: a @GtkMediaFile@
    -> m (Maybe Gio.File.File)
    -- ^ __Returns:__ The currently playing file
mediaFileGetFile self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_media_file_get_file self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gio.File.File) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MediaFileGetFileMethodInfo
instance (signature ~ (m (Maybe Gio.File.File)), MonadIO m, IsMediaFile a) => O.OverloadedMethod MediaFileGetFileMethodInfo a signature where
    overloadedMethod = mediaFileGetFile

instance O.OverloadedMethodInfo MediaFileGetFileMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaFile.mediaFileGetFile",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaFile.html#v:mediaFileGetFile"
        })


#endif

-- method MediaFile::get_input_stream
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaFile" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaFile`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "InputStream" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_file_get_input_stream" gtk_media_file_get_input_stream :: 
    Ptr MediaFile ->                        -- self : TInterface (Name {namespace = "Gtk", name = "MediaFile"})
    IO (Ptr Gio.InputStream.InputStream)

-- | Returns the stream that /@self@/ is currently playing from.
-- 
-- When /@self@/ is not playing or not playing from a stream,
-- 'P.Nothing' is returned.
mediaFileGetInputStream ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaFile a) =>
    a
    -- ^ /@self@/: a @GtkMediaFile@
    -> m (Maybe Gio.InputStream.InputStream)
    -- ^ __Returns:__ The currently playing stream
mediaFileGetInputStream self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_media_file_get_input_stream self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gio.InputStream.InputStream) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MediaFileGetInputStreamMethodInfo
instance (signature ~ (m (Maybe Gio.InputStream.InputStream)), MonadIO m, IsMediaFile a) => O.OverloadedMethod MediaFileGetInputStreamMethodInfo a signature where
    overloadedMethod = mediaFileGetInputStream

instance O.OverloadedMethodInfo MediaFileGetInputStreamMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaFile.mediaFileGetInputStream",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaFile.html#v:mediaFileGetInputStream"
        })


#endif

-- method MediaFile::set_file
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaFile" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaFile`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "file"
--           , argType = TInterface Name { namespace = "Gio" , name = "File" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the file to play" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_file_set_file" gtk_media_file_set_file :: 
    Ptr MediaFile ->                        -- self : TInterface (Name {namespace = "Gtk", name = "MediaFile"})
    Ptr Gio.File.File ->                    -- file : TInterface (Name {namespace = "Gio", name = "File"})
    IO ()

-- | Sets the @GtkMediaFile@ to play the given file.
-- 
-- If any file is still playing, stop playing it.
mediaFileSetFile ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaFile a, Gio.File.IsFile b) =>
    a
    -- ^ /@self@/: a @GtkMediaFile@
    -> Maybe (b)
    -- ^ /@file@/: the file to play
    -> m ()
mediaFileSetFile self file = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeFile <- case file of
        Nothing -> return FP.nullPtr
        Just jFile -> do
            jFile' <- unsafeManagedPtrCastPtr jFile
            return jFile'
    gtk_media_file_set_file self' maybeFile
    touchManagedPtr self
    whenJust file touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data MediaFileSetFileMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsMediaFile a, Gio.File.IsFile b) => O.OverloadedMethod MediaFileSetFileMethodInfo a signature where
    overloadedMethod = mediaFileSetFile

instance O.OverloadedMethodInfo MediaFileSetFileMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaFile.mediaFileSetFile",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaFile.html#v:mediaFileSetFile"
        })


#endif

-- method MediaFile::set_filename
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaFile" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaFile`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "filename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "name of file to play"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_file_set_filename" gtk_media_file_set_filename :: 
    Ptr MediaFile ->                        -- self : TInterface (Name {namespace = "Gtk", name = "MediaFile"})
    CString ->                              -- filename : TBasicType TFileName
    IO ()

-- | Sets the @GtkMediaFile@ to play the given file.
-- 
-- This is a utility function that converts the given /@filename@/
-- to a @GFile@ and calls 'GI.Gtk.Objects.MediaFile.mediaFileSetFile'.
mediaFileSetFilename ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaFile a) =>
    a
    -- ^ /@self@/: a @GtkMediaFile@
    -> Maybe ([Char])
    -- ^ /@filename@/: name of file to play
    -> m ()
mediaFileSetFilename self filename = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeFilename <- case filename of
        Nothing -> return FP.nullPtr
        Just jFilename -> do
            jFilename' <- stringToCString jFilename
            return jFilename'
    gtk_media_file_set_filename self' maybeFilename
    touchManagedPtr self
    freeMem maybeFilename
    return ()

#if defined(ENABLE_OVERLOADING)
data MediaFileSetFilenameMethodInfo
instance (signature ~ (Maybe ([Char]) -> m ()), MonadIO m, IsMediaFile a) => O.OverloadedMethod MediaFileSetFilenameMethodInfo a signature where
    overloadedMethod = mediaFileSetFilename

instance O.OverloadedMethodInfo MediaFileSetFilenameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaFile.mediaFileSetFilename",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaFile.html#v:mediaFileSetFilename"
        })


#endif

-- method MediaFile::set_input_stream
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaFile" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaFile`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InputStream" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the stream to play from"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_file_set_input_stream" gtk_media_file_set_input_stream :: 
    Ptr MediaFile ->                        -- self : TInterface (Name {namespace = "Gtk", name = "MediaFile"})
    Ptr Gio.InputStream.InputStream ->      -- stream : TInterface (Name {namespace = "Gio", name = "InputStream"})
    IO ()

-- | Sets the @GtkMediaFile@ to play the given stream.
-- 
-- If anything is still playing, stop playing it.
-- 
-- Full control about the /@stream@/ is assumed for the duration of
-- playback. The stream will not be closed.
mediaFileSetInputStream ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaFile a, Gio.InputStream.IsInputStream b) =>
    a
    -- ^ /@self@/: a @GtkMediaFile@
    -> Maybe (b)
    -- ^ /@stream@/: the stream to play from
    -> m ()
mediaFileSetInputStream self stream = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeStream <- case stream of
        Nothing -> return FP.nullPtr
        Just jStream -> do
            jStream' <- unsafeManagedPtrCastPtr jStream
            return jStream'
    gtk_media_file_set_input_stream self' maybeStream
    touchManagedPtr self
    whenJust stream touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data MediaFileSetInputStreamMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsMediaFile a, Gio.InputStream.IsInputStream b) => O.OverloadedMethod MediaFileSetInputStreamMethodInfo a signature where
    overloadedMethod = mediaFileSetInputStream

instance O.OverloadedMethodInfo MediaFileSetInputStreamMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaFile.mediaFileSetInputStream",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaFile.html#v:mediaFileSetInputStream"
        })


#endif

-- method MediaFile::set_resource
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaFile" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaFile`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "resource_path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "path to resource to play"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_file_set_resource" gtk_media_file_set_resource :: 
    Ptr MediaFile ->                        -- self : TInterface (Name {namespace = "Gtk", name = "MediaFile"})
    CString ->                              -- resource_path : TBasicType TUTF8
    IO ()

-- | Sets the @GtkMediaFile@ to play the given resource.
-- 
-- This is a utility function that converts the given /@resourcePath@/
-- to a @GFile@ and calls 'GI.Gtk.Objects.MediaFile.mediaFileSetFile'.
mediaFileSetResource ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaFile a) =>
    a
    -- ^ /@self@/: a @GtkMediaFile@
    -> Maybe (T.Text)
    -- ^ /@resourcePath@/: path to resource to play
    -> m ()
mediaFileSetResource self resourcePath = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeResourcePath <- case resourcePath of
        Nothing -> return FP.nullPtr
        Just jResourcePath -> do
            jResourcePath' <- textToCString jResourcePath
            return jResourcePath'
    gtk_media_file_set_resource self' maybeResourcePath
    touchManagedPtr self
    freeMem maybeResourcePath
    return ()

#if defined(ENABLE_OVERLOADING)
data MediaFileSetResourceMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsMediaFile a) => O.OverloadedMethod MediaFileSetResourceMethodInfo a signature where
    overloadedMethod = mediaFileSetResource

instance O.OverloadedMethodInfo MediaFileSetResourceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaFile.mediaFileSetResource",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaFile.html#v:mediaFileSetResource"
        })


#endif


