// Generated with hyprwire-scanner 0.2.1. Made with vaxry's keyboard and ❤️.
// hyprpaper_core

/*
 This protocol's authors' copyright notice is:


    BSD 3-Clause License

    Copyright (c) 2025, Hypr Development

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
        list of conditions and the following disclaimer.

    2. Redistributions in binary form must reproduce the above copyright notice,
        this list of conditions and the following disclaimer in the documentation
        and/or other materials provided with the distribution.

    3. Neither the name of the copyright holder nor the names of its
        contributors may be used to endorse or promote products derived from
        this software without specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
    AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
    DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
    FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
    DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
    SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
    CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
    OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
    OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  
*/


#define private public
#include "hyprpaper_core-server.hpp"
#undef private

using namespace Hyprutils::Memory;
#define SP CSharedPointer
    
static void hyprpaperCoreManager_method0(Hyprwire::IObject* r, uint32_t seq) {
    auto& fn = rc<CHyprpaperCoreManagerObject*>(r->getData())->m_listeners.get_wallpaper_object;
    if (fn)
        fn(seq);
}

static void hyprpaperCoreManager_method1(Hyprwire::IObject* r) {
    auto& fn = rc<CHyprpaperCoreManagerObject*>(r->getData())->m_listeners.destroy;
    if (fn)
        fn();
}

CHyprpaperCoreManagerObject::CHyprpaperCoreManagerObject(Hyprutils::Memory::CSharedPointer<Hyprwire::IObject>&& object) : m_object(std::move(object)) {
    m_object->setData(this);
            
    m_object->listen(0, rc<void*>(::hyprpaperCoreManager_method0));
    m_object->listen(1, rc<void*>(::hyprpaperCoreManager_method1));
}

CHyprpaperCoreManagerObject::~CHyprpaperCoreManagerObject() {
    ; // TODO: call destructor if present
}
void CHyprpaperCoreManagerObject::sendAddMonitor(const char* monitor_name) {
    m_object->call(0, monitor_name);
}

void CHyprpaperCoreManagerObject::sendRemoveMonitor(const char* monitor_name) {
    m_object->call(1, monitor_name);
}

void CHyprpaperCoreManagerObject::setGetWallpaperObject(std::function<void(uint32_t)>&& fn) {
    m_listeners.get_wallpaper_object = std::move(fn);
}

void CHyprpaperCoreManagerObject::setDestroy(std::function<void()>&& fn) {
    m_listeners.destroy = std::move(fn);
}

static void hyprpaperWallpaper_method0(Hyprwire::IObject* r, const char* wallpaper) {
    auto& fn = rc<CHyprpaperWallpaperObject*>(r->getData())->m_listeners.path;
    if (fn)
        fn(wallpaper);
}

static void hyprpaperWallpaper_method1(Hyprwire::IObject* r, hyprpaperCoreWallpaperFitMode fit_mode) {
    auto& fn = rc<CHyprpaperWallpaperObject*>(r->getData())->m_listeners.fit_mode;
    if (fn)
        fn(fit_mode);
}

static void hyprpaperWallpaper_method2(Hyprwire::IObject* r, const char* monitor_name) {
    auto& fn = rc<CHyprpaperWallpaperObject*>(r->getData())->m_listeners.monitor_name;
    if (fn)
        fn(monitor_name);
}

static void hyprpaperWallpaper_method3(Hyprwire::IObject* r) {
    auto& fn = rc<CHyprpaperWallpaperObject*>(r->getData())->m_listeners.apply;
    if (fn)
        fn();
}

static void hyprpaperWallpaper_method4(Hyprwire::IObject* r) {
    auto& fn = rc<CHyprpaperWallpaperObject*>(r->getData())->m_listeners.destroy;
    if (fn)
        fn();
}

CHyprpaperWallpaperObject::CHyprpaperWallpaperObject(Hyprutils::Memory::CSharedPointer<Hyprwire::IObject>&& object) : m_object(std::move(object)) {
    m_object->setData(this);
            
    m_object->listen(0, rc<void*>(::hyprpaperWallpaper_method0));
    m_object->listen(1, rc<void*>(::hyprpaperWallpaper_method1));
    m_object->listen(2, rc<void*>(::hyprpaperWallpaper_method2));
    m_object->listen(3, rc<void*>(::hyprpaperWallpaper_method3));
    m_object->listen(4, rc<void*>(::hyprpaperWallpaper_method4));
}

CHyprpaperWallpaperObject::~CHyprpaperWallpaperObject() {
    ; // TODO: call destructor if present
}
void CHyprpaperWallpaperObject::sendSuccess() {
    m_object->call(0);
}

void CHyprpaperWallpaperObject::sendFailed(uint32_t error) {
    m_object->call(1, error);
}

void CHyprpaperWallpaperObject::setPath(std::function<void(const char*)>&& fn) {
    m_listeners.path = std::move(fn);
}

void CHyprpaperWallpaperObject::setFitMode(std::function<void(hyprpaperCoreWallpaperFitMode)>&& fn) {
    m_listeners.fit_mode = std::move(fn);
}

void CHyprpaperWallpaperObject::setMonitorName(std::function<void(const char*)>&& fn) {
    m_listeners.monitor_name = std::move(fn);
}

void CHyprpaperWallpaperObject::setApply(std::function<void()>&& fn) {
    m_listeners.apply = std::move(fn);
}

void CHyprpaperWallpaperObject::setDestroy(std::function<void()>&& fn) {
    m_listeners.destroy = std::move(fn);
}

CHyprpaperCoreImpl::CHyprpaperCoreImpl(uint32_t ver, std::function<void(Hyprutils::Memory::CSharedPointer<Hyprwire::IObject>)>&& bindFn) : m_version(ver), m_bindFn(bindFn) {
    ;
}

static auto hyprpaperCoreSpec = makeShared<CHyprpaperCoreProtocolSpec>();

SP<Hyprwire::IProtocolSpec> CHyprpaperCoreImpl::protocol() {
    return hyprpaperCoreSpec;
}

std::vector<SP<Hyprwire::SServerObjectImplementation>> CHyprpaperCoreImpl::implementation() {
    return {

            makeShared<Hyprwire::SServerObjectImplementation>(Hyprwire::SServerObjectImplementation{
                .objectName = "hyprpaper_core_manager",
                .version    = m_version,
                .onBind = [this] (Hyprutils::Memory::CSharedPointer<Hyprwire::IObject> r) { if (m_bindFn) m_bindFn(r); }
            }),

            makeShared<Hyprwire::SServerObjectImplementation>(Hyprwire::SServerObjectImplementation{
                .objectName = "hyprpaper_wallpaper",
                .version    = m_version,
            }),
};
}
