
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "ktoolbarspaceraction_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"

// Argument includes
#include <qcoreevent.h>
#include <qmetaobject.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qwidget.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KToolBarSpacerAction_Type = nullptr;
static PyTypeObject *Sbk_KToolBarSpacerAction_TypeF(void)
{
    return _Sbk_KToolBarSpacerAction_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KToolBarSpacerActionWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KToolBarSpacerActionWrapper::KToolBarSpacerActionWrapper(::QObject * parent) : KToolBarSpacerAction(parent)
{
}

void KToolBarSpacerActionWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToolBarSpacerAction_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KToolBarSpacerAction", funcName, gil, pyOverride, event);
}

void KToolBarSpacerActionWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToolBarSpacerAction_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KToolBarSpacerAction", funcName, gil, pyOverride, signal);
}

::QWidget * KToolBarSpacerActionWrapper::createWidget(::QWidget * parent)
{
    static const char *funcName = "createWidget";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToolBarSpacerAction_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::KToolBarSpacerAction::createWidget(parent);
    }
    return sbk_o_createWidget("KToolBarSpacerAction", funcName, gil, pyOverride, parent);
}

::QWidget * KToolBarSpacerActionWrapper::sbk_o_createWidget(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QWidget * parent)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), parent)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), parent)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return nullptr;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, PepType_GetFullyQualifiedNameStr(Shiboken::SbkType< QWidget >()), Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QWidget *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void KToolBarSpacerActionWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToolBarSpacerAction_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KToolBarSpacerAction", funcName, gil, pyOverride, event);
}

void KToolBarSpacerActionWrapper::deleteWidget(::QWidget * widget)
{
    static const char *funcName = "deleteWidget";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToolBarSpacerAction_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidgetAction::deleteWidget(widget);
    }
    sbk_o_deleteWidget("KToolBarSpacerAction", funcName, gil, pyOverride, widget);
}

void KToolBarSpacerActionWrapper::sbk_o_deleteWidget(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QWidget * widget)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), widget)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), widget)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KToolBarSpacerActionWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToolBarSpacerAction_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KToolBarSpacerAction", funcName, gil, pyOverride, signal);
}

bool KToolBarSpacerActionWrapper::event(::QEvent * arg__1)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToolBarSpacerAction_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidgetAction::event(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_event("KToolBarSpacerAction", funcName, gil, pyOverride, arg__1);
}

bool KToolBarSpacerActionWrapper::eventFilter(::QObject * arg__1, ::QEvent * arg__2)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToolBarSpacerAction_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidgetAction::eventFilter(arg__1, arg__2);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KToolBarSpacerAction", funcName, gil, pyOverride, arg__1, arg__2);
}

void KToolBarSpacerActionWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToolBarSpacerAction_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KToolBarSpacerAction", funcName, gil, pyOverride, event);
}

const QMetaObject *KToolBarSpacerActionWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KToolBarSpacerAction::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KToolBarSpacerActionWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KToolBarSpacerAction::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KToolBarSpacerActionWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KToolBarSpacerActionWrapper *>(this));
    }
    return KToolBarSpacerAction::qt_metacast(_clname);
}

KToolBarSpacerActionWrapper::~KToolBarSpacerActionWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KToolBarSpacerAction_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KToolBarSpacerAction_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KToolBarSpacerAction >()))
        return -1;

    KToolBarSpacerActionWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "KToolBarSpacerAction", 1, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KToolBarSpacerAction::KToolBarSpacerAction(QObject*)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KToolBarSpacerAction(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KToolBarSpacerAction_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KToolBarSpacerAction_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KToolBarSpacerAction(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KToolBarSpacerActionWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KToolBarSpacerActionWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KToolBarSpacerAction >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KToolBarSpacerAction_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KToolBarSpacerAction_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KToolBarSpacerActionFunc_createWidget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KToolBarSpacerAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KToolBarSpacerAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidgetAction::createWidget(QWidget*)->QWidget*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArg)))) {
        overloadId = 0; // createWidget(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "createWidget", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KToolBarSpacerAction_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // createWidget(QWidget*)
            QWidget * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KToolBarSpacerAction::createWidget(cppArg0)
                : cppSelf->createWidget(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KToolBarSpacerAction_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KToolBarSpacerAction_methods[] = {
    {"createWidget", reinterpret_cast<PyCFunction>(Sbk_KToolBarSpacerActionFunc_createWidget), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KToolBarSpacerAction_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KToolBarSpacerAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KToolBarSpacerAction_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KToolBarSpacerActionWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KToolBarSpacerAction_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KToolBarSpacerAction_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KToolBarSpacerAction_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KToolBarSpacerAction_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KToolBarSpacerAction_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KToolBarSpacerAction_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KToolBarSpacerAction_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KToolBarSpacerAction_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KToolBarSpacerAction_spec = {
    "1:KWidgetsAddons.KToolBarSpacerAction",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KToolBarSpacerAction_slots
};

} //extern "C"

static void *Sbk_KToolBarSpacerAction_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KToolBarSpacerAction *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KToolBarSpacerAction_PythonToCpp_KToolBarSpacerAction_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KToolBarSpacerAction_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KToolBarSpacerAction_PythonToCpp_KToolBarSpacerAction_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KToolBarSpacerAction_TypeF()))
        return KToolBarSpacerAction_PythonToCpp_KToolBarSpacerAction_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KToolBarSpacerAction_PTR_CppToPython_KToolBarSpacerAction(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KToolBarSpacerAction *>(const_cast<void *>(cppIn)), Sbk_KToolBarSpacerAction_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KToolBarSpacerAction_SignatureStrings[] = {
    "KWidgetsAddons.KToolBarSpacerAction(self,parent:PySide6.QtCore.QObject)",
    "KWidgetsAddons.KToolBarSpacerAction.createWidget(self,parent:PySide6.QtWidgets.QWidget)->PySide6.QtWidgets.QWidget",
    nullptr}; // Sentinel
#else
static constexpr size_t KToolBarSpacerAction_SignatureByteSize = 106;
static constexpr uint8_t KToolBarSpacerAction_SignatureBytes[106] = {
    0x78, 0xda, 0xf3, 0x0e, 0xcf, 0x4c, 0x49, 0x4f, 0x2d, 0x29, 0x76, 0x4c, 0x49, 0xc9, 0xcf, 0x2b,
    0xd6, 0xf3, 0x0e, 0xc9, 0xcf, 0xcf, 0x71, 0x4a, 0x2c, 0x0a, 0x2e, 0x48, 0x4c, 0x4e, 0x2d, 0x72,
    0x4c, 0x2e, 0xc9, 0xcc, 0xcf, 0xd3, 0x28, 0x4e, 0xcd, 0x49, 0xd3, 0x29, 0x48, 0x2c, 0x4a, 0xcd,
    0x2b, 0xb1, 0x0a, 0xa8, 0x0c, 0xce, 0x4c, 0x49, 0x35, 0xd3, 0x0b, 0x2c, 0x71, 0xce, 0x2f, 0x4a,
    0xd5, 0x0b, 0xf4, 0x4f, 0xca, 0x4a, 0x4d, 0x2e, 0xd1, 0xe4, 0xf2, 0x26, 0x6c, 0x8e, 0x5e, 0x72,
    0x51, 0x6a, 0x62, 0x49, 0x2a, 0x44, 0x21, 0x0e, 0x43, 0xa1, 0xa6, 0xe8, 0x05, 0x42, 0x18, 0x9a,
    0xba, 0x76, 0x38, 0xe5, 0xb8, 0x00, 0x5b, 0x4d, 0x44, 0x5a
};
#endif

PyTypeObject *init_KToolBarSpacerAction(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KToolBarSpacerAction_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KToolBarSpacerAction_IDX].type;

    Shiboken::AutoDecRef Sbk_KToolBarSpacerAction_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidgetAction_IDX]))));

    _Sbk_KToolBarSpacerAction_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KToolBarSpacerAction",
        "KToolBarSpacerAction*",
        &Sbk_KToolBarSpacerAction_spec,
        &Shiboken::callCppDestructor< KToolBarSpacerAction >,
        Sbk_KToolBarSpacerAction_Type_bases.object(),
        0);
    auto *pyType = Sbk_KToolBarSpacerAction_TypeF(); // references _Sbk_KToolBarSpacerAction_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KToolBarSpacerAction_SignatureStrings);
#else
    InitSignatureBytes(pyType, KToolBarSpacerAction_SignatureBytes, KToolBarSpacerAction_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KToolBarSpacerAction_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KToolBarSpacerAction_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KToolBarSpacerAction_PythonToCpp_KToolBarSpacerAction_PTR,
        is_KToolBarSpacerAction_PythonToCpp_KToolBarSpacerAction_PTR_Convertible,
        KToolBarSpacerAction_PTR_CppToPython_KToolBarSpacerAction);

    Shiboken::Conversions::registerConverterName(converter, "KToolBarSpacerAction");
    Shiboken::Conversions::registerConverterName(converter, "KToolBarSpacerAction*");
    Shiboken::Conversions::registerConverterName(converter, "KToolBarSpacerAction&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KToolBarSpacerAction).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KToolBarSpacerActionWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KToolBarSpacerAction_TypeF(), &Sbk_KToolBarSpacerAction_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KToolBarSpacerAction::staticMetaObject, sizeof(KToolBarSpacerActionWrapper));

    return pyType;
}
