
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kxmlgui_python.h"

// main header
#include "kshortcutsdialog_wrapper.h"

// Wrappers providing overrides
#include "kxmlguifactory_wrapper.h"
#include "kshortcutsdialog_wrapper.h"
#include "ktoolbar_wrapper.h"

// Argument includes
#include <QList>
#include <QString>
#include <kactioncollection.h>
#include <kshortcutseditor.h>
#include <qaction.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KShortcutsDialog_Type = nullptr;
static PyTypeObject *Sbk_KShortcutsDialog_TypeF(void)
{
    return _Sbk_KShortcutsDialog_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KShortcutsDialogWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KShortcutsDialogWrapper::KShortcutsDialogWrapper(::QFlags<KShortcutsEditor::ActionType> actionTypes, ::KShortcutsEditor::LetterShortcuts allowLetterShortcuts, ::QWidget * parent) : KShortcutsDialog(actionTypes, allowLetterShortcuts, parent)
{
}

KShortcutsDialogWrapper::KShortcutsDialogWrapper(::QWidget * parent) : KShortcutsDialog(parent)
{
}

void KShortcutsDialogWrapper::accept()
{
    static const char *funcName = "accept";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::KShortcutsDialog::accept();
    }
    sbk_o_accept("KShortcutsDialog", funcName, gil, pyOverride);
}

void KShortcutsDialogWrapper::sbk_o_accept(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if defined(PYPY_VERSION) || (defined(Py_LIMITED_API) && Py_LIMITED_API < 0x030A0000)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));
#endif

#if !defined(PYPY_VERSION) && ((defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030A0000) || !defined(Py_LIMITED_API))
    Shiboken::AutoDecRef pyResult(PyObject_CallNoArgs(pyOverride));
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KShortcutsDialogWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KToolBarWrapper::sbk_o_actionEvent("KShortcutsDialog", funcName, gil, pyOverride, event);
}

void KShortcutsDialogWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    KToolBarWrapper::sbk_o_changeEvent("KShortcutsDialog", funcName, gil, pyOverride, event);
}

void KShortcutsDialogWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXMLGUIFactoryWrapper::sbk_o_childEvent("KShortcutsDialog", funcName, gil, pyOverride, event);
}

void KShortcutsDialogWrapper::closeEvent(::QCloseEvent * arg__1)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::closeEvent(arg__1);
    }
    KToolBarWrapper::sbk_o_closeEvent("KShortcutsDialog", funcName, gil, pyOverride, arg__1);
}

void KShortcutsDialogWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXMLGUIFactoryWrapper::sbk_o_connectNotify("KShortcutsDialog", funcName, gil, pyOverride, signal);
}

void KShortcutsDialogWrapper::contextMenuEvent(::QContextMenuEvent * arg__1)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::contextMenuEvent(arg__1);
    }
    KToolBarWrapper::sbk_o_contextMenuEvent("KShortcutsDialog", funcName, gil, pyOverride, arg__1);
}

void KShortcutsDialogWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXMLGUIFactoryWrapper::sbk_o_customEvent("KShortcutsDialog", funcName, gil, pyOverride, event);
}

int KShortcutsDialogWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KToolBarWrapper::sbk_o_devType("KShortcutsDialog", funcName, gil, pyOverride);
}

void KShortcutsDialogWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXMLGUIFactoryWrapper::sbk_o_connectNotify("KShortcutsDialog", funcName, gil, pyOverride, signal);
}

void KShortcutsDialogWrapper::done(int arg__1)
{
    static const char *funcName = "done";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::done(arg__1);
    }
    sbk_o_done("KShortcutsDialog", funcName, gil, pyOverride, arg__1);
}

void KShortcutsDialogWrapper::sbk_o_done(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, int arg__1)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &arg__1)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
        arg__1
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KShortcutsDialogWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KToolBarWrapper::sbk_o_dragEnterEvent("KShortcutsDialog", funcName, gil, pyOverride, event);
}

void KShortcutsDialogWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KToolBarWrapper::sbk_o_dragLeaveEvent("KShortcutsDialog", funcName, gil, pyOverride, event);
}

void KShortcutsDialogWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KToolBarWrapper::sbk_o_dragMoveEvent("KShortcutsDialog", funcName, gil, pyOverride, event);
}

void KShortcutsDialogWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KToolBarWrapper::sbk_o_dropEvent("KShortcutsDialog", funcName, gil, pyOverride, event);
}

void KShortcutsDialogWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KToolBarWrapper::sbk_o_enterEvent("KShortcutsDialog", funcName, gil, pyOverride, event);
}

bool KShortcutsDialogWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::event(event);
    }
    return KXMLGUIFactoryWrapper::sbk_o_event("KShortcutsDialog", funcName, gil, pyOverride, event);
}

bool KShortcutsDialogWrapper::eventFilter(::QObject * arg__1, ::QEvent * arg__2)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::eventFilter(arg__1, arg__2);
    }
    return KXMLGUIFactoryWrapper::sbk_o_eventFilter("KShortcutsDialog", funcName, gil, pyOverride, arg__1, arg__2);
}

int KShortcutsDialogWrapper::exec()
{
    static const char *funcName = "exec";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::exec();
    }
    return sbk_o_exec("KShortcutsDialog", funcName, gil, pyOverride);
}

int KShortcutsDialogWrapper::sbk_o_exec(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return 0;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);

    return cppResult;
}

void KShortcutsDialogWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    KToolBarWrapper::sbk_o_focusInEvent("KShortcutsDialog", funcName, gil, pyOverride, event);
}

bool KShortcutsDialogWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KToolBarWrapper::sbk_o_focusNextPrevChild("KShortcutsDialog", funcName, gil, pyOverride, next);
}

void KShortcutsDialogWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    KToolBarWrapper::sbk_o_focusOutEvent("KShortcutsDialog", funcName, gil, pyOverride, event);
}

bool KShortcutsDialogWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KToolBarWrapper::sbk_o_hasHeightForWidth("KShortcutsDialog", funcName, gil, pyOverride);
}

int KShortcutsDialogWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KToolBarWrapper::sbk_o_heightForWidth("KShortcutsDialog", funcName, gil, pyOverride, arg__1);
}

void KShortcutsDialogWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KToolBarWrapper::sbk_o_hideEvent("KShortcutsDialog", funcName, gil, pyOverride, event);
}

void KShortcutsDialogWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KToolBarWrapper::sbk_o_initPainter("KShortcutsDialog", funcName, gil, pyOverride, painter);
}

void KShortcutsDialogWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KToolBarWrapper::sbk_o_inputMethodEvent("KShortcutsDialog", funcName, gil, pyOverride, event);
}

::QVariant KShortcutsDialogWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KToolBarWrapper::sbk_o_inputMethodQuery("KShortcutsDialog", funcName, gil, pyOverride, arg__1);
}

void KShortcutsDialogWrapper::keyPressEvent(::QKeyEvent * arg__1)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::keyPressEvent(arg__1);
    }
    KToolBarWrapper::sbk_o_keyPressEvent("KShortcutsDialog", funcName, gil, pyOverride, arg__1);
}

void KShortcutsDialogWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KToolBarWrapper::sbk_o_keyReleaseEvent("KShortcutsDialog", funcName, gil, pyOverride, event);
}

void KShortcutsDialogWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KToolBarWrapper::sbk_o_leaveEvent("KShortcutsDialog", funcName, gil, pyOverride, event);
}

int KShortcutsDialogWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KToolBarWrapper::sbk_o_metric("KShortcutsDialog", funcName, gil, pyOverride, arg__1);
}

::QSize KShortcutsDialogWrapper::minimumSizeHint() const
{
    static const char *funcName = "minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::minimumSizeHint();
    }
    return KToolBarWrapper::sbk_o_minimumSizeHint("KShortcutsDialog", funcName, gil, pyOverride);
}

void KShortcutsDialogWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KToolBarWrapper::sbk_o_mouseDoubleClickEvent("KShortcutsDialog", funcName, gil, pyOverride, event);
}

void KShortcutsDialogWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    KToolBarWrapper::sbk_o_mouseMoveEvent("KShortcutsDialog", funcName, gil, pyOverride, event);
}

void KShortcutsDialogWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    KToolBarWrapper::sbk_o_mousePressEvent("KShortcutsDialog", funcName, gil, pyOverride, event);
}

void KShortcutsDialogWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    KToolBarWrapper::sbk_o_mouseReleaseEvent("KShortcutsDialog", funcName, gil, pyOverride, event);
}

void KShortcutsDialogWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KToolBarWrapper::sbk_o_moveEvent("KShortcutsDialog", funcName, gil, pyOverride, event);
}

bool KShortcutsDialogWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KToolBarWrapper::sbk_o_nativeEvent("KShortcutsDialog", funcName, gil, pyOverride, eventType, message, result);
}

void KShortcutsDialogWrapper::open()
{
    static const char *funcName = "open";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::open();
    }
    KShortcutsDialogWrapper::sbk_o_accept("KShortcutsDialog", funcName, gil, pyOverride);
}

::QPaintEngine * KShortcutsDialogWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KToolBarWrapper::sbk_o_paintEngine("KShortcutsDialog", funcName, gil, pyOverride);
}

void KShortcutsDialogWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEvent(event);
    }
    KToolBarWrapper::sbk_o_paintEvent("KShortcutsDialog", funcName, gil, pyOverride, event);
}

::QPaintDevice * KShortcutsDialogWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KToolBarWrapper::sbk_o_redirected("KShortcutsDialog", funcName, gil, pyOverride, offset);
}

void KShortcutsDialogWrapper::reject()
{
    static const char *funcName = "reject";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::reject();
    }
    KShortcutsDialogWrapper::sbk_o_accept("KShortcutsDialog", funcName, gil, pyOverride);
}

void KShortcutsDialogWrapper::resizeEvent(::QResizeEvent * arg__1)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::resizeEvent(arg__1);
    }
    KToolBarWrapper::sbk_o_resizeEvent("KShortcutsDialog", funcName, gil, pyOverride, arg__1);
}

void KShortcutsDialogWrapper::setVisible(bool visible)
{
    static const char *funcName = "setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::setVisible(visible);
    }
    KToolBarWrapper::sbk_o_setVisible("KShortcutsDialog", funcName, gil, pyOverride, visible);
}

::QPainter * KShortcutsDialogWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KToolBarWrapper::sbk_o_sharedPainter("KShortcutsDialog", funcName, gil, pyOverride);
}

void KShortcutsDialogWrapper::showEvent(::QShowEvent * arg__1)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::showEvent(arg__1);
    }
    KToolBarWrapper::sbk_o_showEvent("KShortcutsDialog", funcName, gil, pyOverride, arg__1);
}

::QSize KShortcutsDialogWrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[48], nameCache));
    if (pyOverride.isNull()) {
        return this->::KShortcutsDialog::sizeHint();
    }
    return KToolBarWrapper::sbk_o_minimumSizeHint("KShortcutsDialog", funcName, gil, pyOverride);
}

void KShortcutsDialogWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[49], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KToolBarWrapper::sbk_o_tabletEvent("KShortcutsDialog", funcName, gil, pyOverride, event);
}

void KShortcutsDialogWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[50], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXMLGUIFactoryWrapper::sbk_o_timerEvent("KShortcutsDialog", funcName, gil, pyOverride, event);
}

void KShortcutsDialogWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsDialog_TypeF(), gil, funcName, m_PyMethodCache[51], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KToolBarWrapper::sbk_o_wheelEvent("KShortcutsDialog", funcName, gil, pyOverride, event);
}

const QMetaObject *KShortcutsDialogWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KShortcutsDialog::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KShortcutsDialogWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KShortcutsDialog::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KShortcutsDialogWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KShortcutsDialogWrapper *>(this));
    }
    return KShortcutsDialog::qt_metacast(_clname);
}

KShortcutsDialogWrapper::~KShortcutsDialogWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KShortcutsDialog_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KShortcutsDialog_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KShortcutsDialog >()))
        return -1;

    KShortcutsDialogWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OOO:KShortcutsDialog", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KShortcutsDialog::KShortcutsDialog(QFlags<KShortcutsEditor::ActionType>=,KShortcutsEditor::LetterShortcuts=,QWidget*=)
    // 1: KShortcutsDialog::KShortcutsDialog(QWidget*)
    if (numArgs == 0) {
        overloadId = 0; // KShortcutsDialog(QFlags<KShortcutsEditor::ActionType>,KShortcutsEditor::LetterShortcuts,QWidget*)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 1; // KShortcutsDialog(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_QFlags_KShortcutsEditor_ActionType_IDX])))->flagsConverter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // KShortcutsDialog(QFlags<KShortcutsEditor::ActionType>,KShortcutsEditor::LetterShortcuts,QWidget*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_LetterShortcuts_IDX])))->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // KShortcutsDialog(QFlags<KShortcutsEditor::ActionType>,KShortcutsEditor::LetterShortcuts,QWidget*)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[2])))) {
                overloadId = 0; // KShortcutsDialog(QFlags<KShortcutsEditor::ActionType>,KShortcutsEditor::LetterShortcuts,QWidget*)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutsDialog_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKXmlGuiTypeStructs[SBK_KShortcutsDialog_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KShortcutsDialog(QFlags<KShortcutsEditor::ActionType> actionTypes, KShortcutsEditor::LetterShortcuts allowLetterShortcuts, QWidget *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[3] = {{"actionTypes", 0}, {"allowLetterShortcuts", 1}, {"parent", 2}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 3, errInfo, pyArgs)
                    || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_QFlags_KShortcutsEditor_ActionType_IDX])))->flagsConverter, (pyArgs[0]))))
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_LetterShortcuts_IDX])))->converter, (pyArgs[1]))))
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[2]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutsDialog_IDX]);
                }
            }
            ::QFlags<KShortcutsEditor::ActionType> cppArg0(KShortcutsEditor::AllActions);
            if (pythonToCpp[0])
                pythonToCpp[0](pyArgs[0], &cppArg0);
            ::KShortcutsEditor::LetterShortcuts cppArg1(KShortcutsEditor::LetterShortcutsAllowed);
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QWidget *cppArg2 = nullptr;
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KShortcutsDialog(QFlags<KShortcutsEditor::ActionType>,KShortcutsEditor::LetterShortcuts,QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KShortcutsDialogWrapper(cppArg0, cppArg1, cppArg2);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KShortcutsDialogWrapper(cppArg0, cppArg1, cppArg2);
                }

            }
            break;
        }
        case 1: // KShortcutsDialog(QWidget *parent)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutsDialog_IDX]);
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KShortcutsDialog(QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KShortcutsDialogWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KShortcutsDialogWrapper(cppArg0);
                }

            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KShortcutsDialog >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutsDialog_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutsDialog_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KShortcutsDialogFunc_accept(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KShortcutsDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutsDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // accept()
        Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::KShortcutsDialog::accept()
            : cppSelf->accept();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KShortcutsDialogFunc_actionCollections(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KShortcutsDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutsDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // actionCollections()const
        QList<KActionCollection*> cppResult = const_cast<const ::KShortcutsDialog *>(cppSelf)->actionCollections();
        pyResult = Shiboken::Conversions::copyToPython(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_KActionCollectionPTR_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KShortcutsDialogFunc_addActionToSchemesMoreButton(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KShortcutsDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutsDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KShortcutsDialog::addActionToSchemesMoreButton(QAction*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), (pyArg)))) {
        overloadId = 0; // addActionToSchemesMoreButton(QAction*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "addActionToSchemesMoreButton", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutsDialog_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAction *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addActionToSchemesMoreButton(QAction*)
            cppSelf->addActionToSchemesMoreButton(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KShortcutsDialogFunc_addCollection(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KShortcutsDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutsDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "addCollection", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutsDialog_IDX]);

    if (PyArg_ParseTuple(args, "|OO:addCollection", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KShortcutsDialog::addCollection(KActionCollection*,const QString&=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // addCollection(KActionCollection*,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            overloadId = 0; // addCollection(KActionCollection*,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addCollection", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutsDialog_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"title", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "addCollection", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutsDialog_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KActionCollection *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1{};
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addCollection(KActionCollection*,QString)
            cppSelf->addCollection(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KShortcutsDialogFunc_configure(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KShortcutsDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutsDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "configure", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutsDialog_IDX]);

    if (PyArg_ParseTuple(args, "|O:configure", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KShortcutsDialog::configure(bool=)->bool
    if (numArgs == 0) {
        overloadId = 0; // configure(bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // configure(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "configure", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutsDialog_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"saveSettings", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "configure", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutsDialog_IDX]);
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // configure(bool)
            bool cppResult = cppSelf->configure(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KShortcutsDialogFunc_exportConfiguration(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KShortcutsDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutsDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KShortcutsDialog::exportConfiguration(QString)const
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // exportConfiguration(QString)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "exportConfiguration", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutsDialog_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // exportConfiguration(QString)const
            const_cast<const ::KShortcutsDialog *>(cppSelf)->exportConfiguration(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KShortcutsDialogFunc_importConfiguration(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KShortcutsDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutsDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KShortcutsDialog::importConfiguration(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // importConfiguration(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "importConfiguration", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutsDialog_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // importConfiguration(QString)
            cppSelf->importConfiguration(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KShortcutsDialogFunc_refreshSchemes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KShortcutsDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutsDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // refreshSchemes()
        cppSelf->refreshSchemes();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KShortcutsDialogFunc_showDialog(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "showDialog", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutsDialog_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:showDialog", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KShortcutsDialog::showDialog(KActionCollection*,KShortcutsEditor::LetterShortcuts=,QWidget*=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // showDialog(KActionCollection*,KShortcutsEditor::LetterShortcuts,QWidget*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_LetterShortcuts_IDX])))->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // showDialog(KActionCollection*,KShortcutsEditor::LetterShortcuts,QWidget*)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[2])))) {
                overloadId = 0; // showDialog(KActionCollection*,KShortcutsEditor::LetterShortcuts,QWidget*)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "showDialog", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutsDialog_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"allowLetterShortcuts", 1}, {"parent", 2}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_LetterShortcuts_IDX])))->converter, (pyArgs[1]))))
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "showDialog", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutsDialog_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KActionCollection *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::KShortcutsEditor::LetterShortcuts cppArg1(KShortcutsEditor::LetterShortcutsAllowed);
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QWidget *cppArg2 = nullptr;
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // showDialog(KActionCollection*,KShortcutsEditor::LetterShortcuts,QWidget*)
            ::KShortcutsDialog::showDialog(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KShortcutsDialogFunc_sizeHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KShortcutsDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutsDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // sizeHint()const
        QSize cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const ::KShortcutsDialog *>(cppSelf)->::KShortcutsDialog::sizeHint()
            : const_cast<const ::KShortcutsDialog *>(cppSelf)->sizeHint();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KShortcutsDialog_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KShortcutsDialog_methods[] = {
    {"accept", reinterpret_cast<PyCFunction>(Sbk_KShortcutsDialogFunc_accept), METH_NOARGS, nullptr},
    {"actionCollections", reinterpret_cast<PyCFunction>(Sbk_KShortcutsDialogFunc_actionCollections), METH_NOARGS, nullptr},
    {"addActionToSchemesMoreButton", reinterpret_cast<PyCFunction>(Sbk_KShortcutsDialogFunc_addActionToSchemesMoreButton), METH_O, nullptr},
    {"addCollection", reinterpret_cast<PyCFunction>(Sbk_KShortcutsDialogFunc_addCollection), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"configure", reinterpret_cast<PyCFunction>(Sbk_KShortcutsDialogFunc_configure), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"exportConfiguration", reinterpret_cast<PyCFunction>(Sbk_KShortcutsDialogFunc_exportConfiguration), METH_O, nullptr},
    {"importConfiguration", reinterpret_cast<PyCFunction>(Sbk_KShortcutsDialogFunc_importConfiguration), METH_O, nullptr},
    {"refreshSchemes", reinterpret_cast<PyCFunction>(Sbk_KShortcutsDialogFunc_refreshSchemes), METH_NOARGS, nullptr},
    {"showDialog", reinterpret_cast<PyCFunction>(Sbk_KShortcutsDialogFunc_showDialog), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"sizeHint", reinterpret_cast<PyCFunction>(Sbk_KShortcutsDialogFunc_sizeHint), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KShortcutsDialog_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KShortcutsDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutsDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KShortcutsDialogWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KShortcutsDialog_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KShortcutsDialog_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KShortcutsDialogSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KShortcutsDialog *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QDialog_IDX]))
        return static_cast< ::QDialog *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KShortcutsDialog_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KShortcutsDialog_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KShortcutsDialog_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KShortcutsDialog_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KShortcutsDialog_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KShortcutsDialog_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KShortcutsDialog_spec = {
    "1:KXmlGui.KShortcutsDialog",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KShortcutsDialog_slots
};

} //extern "C"

static void *Sbk_KShortcutsDialog_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KShortcutsDialog *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KShortcutsDialog *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KShortcutsDialog *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KShortcutsDialog_PythonToCpp_KShortcutsDialog_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KShortcutsDialog_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KShortcutsDialog_PythonToCpp_KShortcutsDialog_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KShortcutsDialog_TypeF()))
        return KShortcutsDialog_PythonToCpp_KShortcutsDialog_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KShortcutsDialog_PTR_CppToPython_KShortcutsDialog(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KShortcutsDialog *>(const_cast<void *>(cppIn)), Sbk_KShortcutsDialog_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KShortcutsDialog_SignatureStrings[] = {
    "1:KXmlGui.KShortcutsDialog(self,actionTypes:KXmlGui.KShortcutsEditor.ActionType=KShortcutsEditor.AllActions,allowLetterShortcuts:KXmlGui.KShortcutsEditor.LetterShortcuts=KShortcutsEditor.LetterShortcutsAllowed,parent:PySide6.QtWidgets.QWidget=nullptr)",
    "0:KXmlGui.KShortcutsDialog(self,parent:PySide6.QtWidgets.QWidget)",
    "KXmlGui.KShortcutsDialog.accept(self)",
    "KXmlGui.KShortcutsDialog.actionCollections(self)->QList[KXmlGui.KActionCollection]",
    "KXmlGui.KShortcutsDialog.addActionToSchemesMoreButton(self,action:PySide6.QtGui.QAction)",
    "KXmlGui.KShortcutsDialog.addCollection(self,collection:KXmlGui.KActionCollection,title:QString={})",
    "KXmlGui.KShortcutsDialog.configure(self,saveSettings:bool=true)->bool",
    "KXmlGui.KShortcutsDialog.exportConfiguration(self,path:QString)",
    "KXmlGui.KShortcutsDialog.importConfiguration(self,path:QString)",
    "KXmlGui.KShortcutsDialog.refreshSchemes(self)",
    "KXmlGui.KShortcutsDialog.showDialog(collection:KXmlGui.KActionCollection,allowLetterShortcuts:KXmlGui.KShortcutsEditor.LetterShortcuts=KShortcutsEditor.LetterShortcutsAllowed,parent:PySide6.QtWidgets.QWidget=nullptr)",
    "KXmlGui.KShortcutsDialog.sizeHint(self)->PySide6.QtCore.QSize",
    nullptr}; // Sentinel
#else
static constexpr size_t KShortcutsDialog_SignatureByteSize = 328;
static constexpr uint8_t KShortcutsDialog_SignatureBytes[328] = {
    0x78, 0xda, 0xcd, 0x93, 0x4d, 0x4b, 0xc3, 0x40, 0x10, 0x86, 0xef, 0xfd, 0x25, 0x16, 0x62, 0xd0,
    0x8b, 0x87, 0x40, 0x84, 0x58, 0x45, 0xa1, 0x15, 0x0c, 0x11, 0x14, 0xc4, 0xc3, 0x76, 0x33, 0x49,
    0x16, 0xa6, 0x3b, 0x61, 0x77, 0x62, 0xad, 0xe2, 0x7f, 0x37, 0x71, 0xd3, 0xb4, 0x54, 0x93, 0x08,
    0x5e, 0xbc, 0x6d, 0x76, 0xde, 0xf7, 0xc9, 0x7c, 0xed, 0x69, 0x30, 0x7f, 0x5c, 0xe1, 0x75, 0xa5,
    0xfc, 0x79, 0x52, 0x90, 0x61, 0x59, 0xb1, 0xbd, 0x54, 0x02, 0x29, 0x3f, 0xb2, 0x80, 0x99, 0x27,
    0x24, 0x2b, 0xd2, 0xf7, 0x9b, 0x12, 0xec, 0x0f, 0xca, 0xab, 0x54, 0x31, 0x19, 0x3f, 0xea, 0x44,
    0xe1, 0xf7, 0x18, 0xa2, 0x0b, 0x5b, 0x4f, 0x20, 0xd2, 0x7a, 0x01, 0xcc, 0x60, 0x3a, 0x55, 0x3f,
    0xf4, 0x40, 0x18, 0x8e, 0x09, 0xa2, 0x86, 0x0e, 0xa9, 0x57, 0x0a, 0x03, 0x9a, 0x83, 0xbb, 0x4d,
    0xa2, 0x52, 0x38, 0xf3, 0x63, 0x7e, 0x50, 0x69, 0x0e, 0x6c, 0xfd, 0xd8, 0x1d, 0x42, 0x5d, 0x21,
    0x96, 0x6c, 0xa6, 0x93, 0x93, 0x91, 0xda, 0xc7, 0x48, 0xd3, 0x49, 0x9f, 0xdf, 0x17, 0x52, 0x42,
    0xc9, 0x5f, 0x98, 0x41, 0x55, 0xd3, 0x98, 0x19, 0x21, 0x82, 0x6b, 0x91, 0x33, 0x1c, 0x9f, 0xc7,
    0x0b, 0x65, 0xf9, 0xa9, 0xf3, 0x45, 0x07, 0xba, 0xe7, 0x01, 0x64, 0x9a, 0xb6, 0xd3, 0xa0, 0x44,
    0x16, 0xb0, 0x02, 0x7b, 0x4b, 0x06, 0x2e, 0x2a, 0x66, 0xd2, 0xfb, 0x13, 0xdd, 0xab, 0xaa, 0xe1,
    0xc4, 0xce, 0x34, 0x1d, 0x04, 0xef, 0x12, 0x70, 0x24, 0xd9, 0x7d, 0x07, 0xbd, 0xa9, 0x7a, 0xac,
    0x18, 0x21, 0x88, 0x13, 0x36, 0x4a, 0xe7, 0xe1, 0xfb, 0xc7, 0xc0, 0x2f, 0x24, 0xe9, 0x4c, 0xe5,
    0x95, 0x01, 0x87, 0xb7, 0xe2, 0x05, 0x92, 0x7a, 0xc6, 0xb5, 0xcf, 0x06, 0x4b, 0x22, 0x0c, 0xd9,
    0x54, 0x50, 0x77, 0xa7, 0x39, 0xf7, 0x53, 0xe0, 0xb5, 0xac, 0x2f, 0x66, 0x2d, 0x4b, 0xec, 0xd2,
    0x2d, 0x05, 0x17, 0xdb, 0x44, 0x06, 0xb2, 0x50, 0xab, 0xbf, 0xf9, 0x0d, 0x64, 0x06, 0x6c, 0xd1,
    0x76, 0x7f, 0x6c, 0x05, 0x6c, 0x41, 0xeb, 0x76, 0xe7, 0x7e, 0xd5, 0xce, 0xff, 0xf6, 0x86, 0xfa,
    0x0b, 0x53, 0x6f, 0x70, 0xa3, 0x34, 0x6f, 0x57, 0x7a, 0xc7, 0x9a, 0xd5, 0x0b, 0xe9, 0xc7, 0x49,
    0x1d, 0x9f, 0x7c, 0x02, 0xe9, 0xda, 0xb1, 0x82
};
#endif

PyTypeObject *init_KShortcutsDialog(PyObject *module)
{
    if (SbkKXmlGuiTypeStructs[SBK_KShortcutsDialog_IDX].type != nullptr)
        return SbkKXmlGuiTypeStructs[SBK_KShortcutsDialog_IDX].type;

    Shiboken::AutoDecRef Sbk_KShortcutsDialog_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QDialog_IDX]))));

    _Sbk_KShortcutsDialog_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KShortcutsDialog",
        "KShortcutsDialog*",
        &Sbk_KShortcutsDialog_spec,
        &Shiboken::callCppDestructor< KShortcutsDialog >,
        Sbk_KShortcutsDialog_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = Sbk_KShortcutsDialog_TypeF(); // references _Sbk_KShortcutsDialog_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KShortcutsDialog_SignatureStrings);
#else
    InitSignatureBytes(pyType, KShortcutsDialog_SignatureBytes, KShortcutsDialog_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KShortcutsDialog_PropertyStrings);
    SbkKXmlGuiTypeStructs[SBK_KShortcutsDialog_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KShortcutsDialog_PythonToCpp_KShortcutsDialog_PTR,
        is_KShortcutsDialog_PythonToCpp_KShortcutsDialog_PTR_Convertible,
        KShortcutsDialog_PTR_CppToPython_KShortcutsDialog);

    Shiboken::Conversions::registerConverterName(converter, "KShortcutsDialog");
    Shiboken::Conversions::registerConverterName(converter, "KShortcutsDialog*");
    Shiboken::Conversions::registerConverterName(converter, "KShortcutsDialog&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KShortcutsDialog).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KShortcutsDialogWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KShortcutsDialog_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KShortcutsDialog_TypeF(), &Sbk_KShortcutsDialogSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KShortcutsDialog_TypeF(), &Sbk_KShortcutsDialog_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::KShortcutsDialog::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KShortcutsDialog::staticMetaObject, sizeof(KShortcutsDialogWrapper));

    return pyType;
}
