// Copyright (C) 2018 The Android Open Source Project
// Copyright (C) 2018 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Autogenerated module goldfish_vk_deepcopy_guest
//
// (impl) generated by ../mesa-25.3.4/src/gfxstream/codegen/scripts/genvk.py -registry ../mesa-25.3.4/src/vulkan/registry/vk.xml -registryGfxstream ../mesa-25.3.4/src/gfxstream/codegen/xml/vk_gfxstream.xml cereal -o /build/lib32-mesa/src/build/src/gfxstream/guest/vulkan_enc/host/vulkan/cereal
//
// Please do not modify directly;
// re-run mesa3d/src/gfxstream/codegen/generate-gfxstream-vulkan.sh,
// or directly from Python by defining:
// VULKAN_REGISTRY_XML_DIR : Directory containing vk.xml
// VULKAN_REGISTRY_SCRIPTS_DIR : Directory containing genvk.py
// CEREAL_OUTPUT_DIR: Where to put the generated sources.
//
// python3 $VULKAN_REGISTRY_SCRIPTS_DIR/genvk.py -registry $VULKAN_REGISTRY_XML_DIR/vk.xml cereal -o $CEREAL_OUTPUT_DIR
//

#include "goldfish_vk_deepcopy_guest.h"
#include "goldfish_vk_extension_structs_guest.h"
#include "goldfish_vk_private_defs.h"

#include <cstring>

#include "vk_util.h"

namespace gfxstream {
namespace vk {

void deepcopy_extension_struct(
    Allocator* alloc,
    VkStructureType rootType,
    const void* structExtension,
    void* structExtension_out);

#ifdef VK_VERSION_1_0
void deepcopy_VkExtent2D(
    Allocator* alloc,
    VkStructureType rootType,
    const VkExtent2D* from,
    VkExtent2D* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkExtent3D(
    Allocator* alloc,
    VkStructureType rootType,
    const VkExtent3D* from,
    VkExtent3D* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkOffset2D(
    Allocator* alloc,
    VkStructureType rootType,
    const VkOffset2D* from,
    VkOffset2D* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkOffset3D(
    Allocator* alloc,
    VkStructureType rootType,
    const VkOffset3D* from,
    VkOffset3D* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkRect2D(
    Allocator* alloc,
    VkStructureType rootType,
    const VkRect2D* from,
    VkRect2D* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    deepcopy_VkOffset2D(alloc, rootType, &from->offset, (VkOffset2D*)(&to->offset));
    deepcopy_VkExtent2D(alloc, rootType, &from->extent, (VkExtent2D*)(&to->extent));
}

void deepcopy_VkBaseInStructure(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBaseInStructure* from,
    VkBaseInStructure* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (VkBaseInStructure*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkBaseOutStructure(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBaseOutStructure* from,
    VkBaseOutStructure* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (VkBaseOutStructure*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkBufferMemoryBarrier(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBufferMemoryBarrier* from,
    VkBufferMemoryBarrier* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkDispatchIndirectCommand(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDispatchIndirectCommand* from,
    VkDispatchIndirectCommand* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkDrawIndexedIndirectCommand(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDrawIndexedIndirectCommand* from,
    VkDrawIndexedIndirectCommand* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkDrawIndirectCommand(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDrawIndirectCommand* from,
    VkDrawIndirectCommand* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkImageSubresourceRange(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageSubresourceRange* from,
    VkImageSubresourceRange* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkImageMemoryBarrier(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageMemoryBarrier* from,
    VkImageMemoryBarrier* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    deepcopy_VkImageSubresourceRange(alloc, rootType, &from->subresourceRange, (VkImageSubresourceRange*)(&to->subresourceRange));
}

void deepcopy_VkMemoryBarrier(
    Allocator* alloc,
    VkStructureType rootType,
    const VkMemoryBarrier* from,
    VkMemoryBarrier* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPipelineCacheHeaderVersionOne(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineCacheHeaderVersionOne* from,
    VkPipelineCacheHeaderVersionOne* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    memcpy(to->pipelineCacheUUID, from->pipelineCacheUUID, VK_UUID_SIZE * sizeof(uint8_t));
}

void deepcopy_VkAllocationCallbacks(
    Allocator* alloc,
    VkStructureType rootType,
    const VkAllocationCallbacks* from,
    VkAllocationCallbacks* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    to->pUserData = nullptr;
    if (from->pUserData)
    {
        to->pUserData = (void*)alloc->dupArray(from->pUserData, sizeof(uint8_t));
    }
}

void deepcopy_VkApplicationInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkApplicationInfo* from,
    VkApplicationInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pApplicationName = nullptr;
    if (from->pApplicationName)
    {
        to->pApplicationName = alloc->strDup(from->pApplicationName);
    }
    to->pEngineName = nullptr;
    if (from->pEngineName)
    {
        to->pEngineName = alloc->strDup(from->pEngineName);
    }
}

void deepcopy_VkFormatProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkFormatProperties* from,
    VkFormatProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkImageFormatProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageFormatProperties* from,
    VkImageFormatProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    deepcopy_VkExtent3D(alloc, rootType, &from->maxExtent, (VkExtent3D*)(&to->maxExtent));
}

void deepcopy_VkInstanceCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkInstanceCreateInfo* from,
    VkInstanceCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pApplicationInfo = nullptr;
    if (from->pApplicationInfo)
    {
        to->pApplicationInfo = (VkApplicationInfo*)alloc->alloc(sizeof(const VkApplicationInfo));
        deepcopy_VkApplicationInfo(alloc, rootType, from->pApplicationInfo, (VkApplicationInfo*)(to->pApplicationInfo));
    }
    to->ppEnabledLayerNames = nullptr;
    if (from->ppEnabledLayerNames && from->enabledLayerCount)
    {
        to->ppEnabledLayerNames = alloc->strDupArray(from->ppEnabledLayerNames, from->enabledLayerCount);
    }
    to->ppEnabledExtensionNames = nullptr;
    if (from->ppEnabledExtensionNames && from->enabledExtensionCount)
    {
        to->ppEnabledExtensionNames = alloc->strDupArray(from->ppEnabledExtensionNames, from->enabledExtensionCount);
    }
}

void deepcopy_VkMemoryHeap(
    Allocator* alloc,
    VkStructureType rootType,
    const VkMemoryHeap* from,
    VkMemoryHeap* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkMemoryType(
    Allocator* alloc,
    VkStructureType rootType,
    const VkMemoryType* from,
    VkMemoryType* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkPhysicalDeviceFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceFeatures* from,
    VkPhysicalDeviceFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkPhysicalDeviceLimits(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceLimits* from,
    VkPhysicalDeviceLimits* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    memcpy(to->maxComputeWorkGroupCount, from->maxComputeWorkGroupCount, 3 * sizeof(uint32_t));
    memcpy(to->maxComputeWorkGroupSize, from->maxComputeWorkGroupSize, 3 * sizeof(uint32_t));
    memcpy(to->maxViewportDimensions, from->maxViewportDimensions, 2 * sizeof(uint32_t));
    memcpy(to->viewportBoundsRange, from->viewportBoundsRange, 2 * sizeof(float));
    memcpy(to->pointSizeRange, from->pointSizeRange, 2 * sizeof(float));
    memcpy(to->lineWidthRange, from->lineWidthRange, 2 * sizeof(float));
}

void deepcopy_VkPhysicalDeviceMemoryProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceMemoryProperties* from,
    VkPhysicalDeviceMemoryProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    for (uint32_t i = 0; i < (uint32_t)VK_MAX_MEMORY_TYPES; ++i)
    {
        deepcopy_VkMemoryType(alloc, rootType, from->memoryTypes + i, (VkMemoryType*)(to->memoryTypes + i));
    }
    for (uint32_t i = 0; i < (uint32_t)VK_MAX_MEMORY_HEAPS; ++i)
    {
        deepcopy_VkMemoryHeap(alloc, rootType, from->memoryHeaps + i, (VkMemoryHeap*)(to->memoryHeaps + i));
    }
}

void deepcopy_VkPhysicalDeviceSparseProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceSparseProperties* from,
    VkPhysicalDeviceSparseProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkPhysicalDeviceProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceProperties* from,
    VkPhysicalDeviceProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    memcpy(to->deviceName, from->deviceName, VK_MAX_PHYSICAL_DEVICE_NAME_SIZE * sizeof(char));
    memcpy(to->pipelineCacheUUID, from->pipelineCacheUUID, VK_UUID_SIZE * sizeof(uint8_t));
    deepcopy_VkPhysicalDeviceLimits(alloc, rootType, &from->limits, (VkPhysicalDeviceLimits*)(&to->limits));
    deepcopy_VkPhysicalDeviceSparseProperties(alloc, rootType, &from->sparseProperties, (VkPhysicalDeviceSparseProperties*)(&to->sparseProperties));
}

void deepcopy_VkQueueFamilyProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkQueueFamilyProperties* from,
    VkQueueFamilyProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    deepcopy_VkExtent3D(alloc, rootType, &from->minImageTransferGranularity, (VkExtent3D*)(&to->minImageTransferGranularity));
}

void deepcopy_VkDeviceQueueCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDeviceQueueCreateInfo* from,
    VkDeviceQueueCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pQueuePriorities = nullptr;
    if (from->pQueuePriorities)
    {
        to->pQueuePriorities = (float*)alloc->dupArray(from->pQueuePriorities, from->queueCount * sizeof(const float));
    }
}

void deepcopy_VkDeviceCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDeviceCreateInfo* from,
    VkDeviceCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    if (from)
    {
        to->pQueueCreateInfos = nullptr;
        if (from->pQueueCreateInfos)
        {
            to->pQueueCreateInfos = (VkDeviceQueueCreateInfo*)alloc->alloc(from->queueCreateInfoCount * sizeof(const VkDeviceQueueCreateInfo));
            to->queueCreateInfoCount = from->queueCreateInfoCount;
            for (uint32_t i = 0; i < (uint32_t)from->queueCreateInfoCount; ++i)
            {
                deepcopy_VkDeviceQueueCreateInfo(alloc, rootType, from->pQueueCreateInfos + i, (VkDeviceQueueCreateInfo*)(to->pQueueCreateInfos + i));
            }
        }
    }
    to->ppEnabledLayerNames = nullptr;
    if (from->ppEnabledLayerNames && from->enabledLayerCount)
    {
        to->ppEnabledLayerNames = alloc->strDupArray(from->ppEnabledLayerNames, from->enabledLayerCount);
    }
    to->ppEnabledExtensionNames = nullptr;
    if (from->ppEnabledExtensionNames && from->enabledExtensionCount)
    {
        to->ppEnabledExtensionNames = alloc->strDupArray(from->ppEnabledExtensionNames, from->enabledExtensionCount);
    }
    to->pEnabledFeatures = nullptr;
    if (from->pEnabledFeatures)
    {
        to->pEnabledFeatures = (VkPhysicalDeviceFeatures*)alloc->alloc(sizeof(const VkPhysicalDeviceFeatures));
        deepcopy_VkPhysicalDeviceFeatures(alloc, rootType, from->pEnabledFeatures, (VkPhysicalDeviceFeatures*)(to->pEnabledFeatures));
    }
}

void deepcopy_VkExtensionProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkExtensionProperties* from,
    VkExtensionProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    memcpy(to->extensionName, from->extensionName, VK_MAX_EXTENSION_NAME_SIZE * sizeof(char));
}

void deepcopy_VkLayerProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkLayerProperties* from,
    VkLayerProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    memcpy(to->layerName, from->layerName, VK_MAX_EXTENSION_NAME_SIZE * sizeof(char));
    memcpy(to->description, from->description, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
}

void deepcopy_VkSubmitInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSubmitInfo* from,
    VkSubmitInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pWaitSemaphores = nullptr;
    if (from->pWaitSemaphores)
    {
        to->pWaitSemaphores = (VkSemaphore*)alloc->dupArray(from->pWaitSemaphores, from->waitSemaphoreCount * sizeof(const VkSemaphore));
    }
    to->pWaitDstStageMask = nullptr;
    if (from->pWaitDstStageMask)
    {
        to->pWaitDstStageMask = (VkPipelineStageFlags*)alloc->dupArray(from->pWaitDstStageMask, from->waitSemaphoreCount * sizeof(const VkPipelineStageFlags));
    }
    to->pCommandBuffers = nullptr;
    if (from->pCommandBuffers)
    {
        to->pCommandBuffers = (VkCommandBuffer*)alloc->dupArray(from->pCommandBuffers, from->commandBufferCount * sizeof(const VkCommandBuffer));
    }
    to->pSignalSemaphores = nullptr;
    if (from->pSignalSemaphores)
    {
        to->pSignalSemaphores = (VkSemaphore*)alloc->dupArray(from->pSignalSemaphores, from->signalSemaphoreCount * sizeof(const VkSemaphore));
    }
}

void deepcopy_VkMappedMemoryRange(
    Allocator* alloc,
    VkStructureType rootType,
    const VkMappedMemoryRange* from,
    VkMappedMemoryRange* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkMemoryAllocateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkMemoryAllocateInfo* from,
    VkMemoryAllocateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkMemoryRequirements(
    Allocator* alloc,
    VkStructureType rootType,
    const VkMemoryRequirements* from,
    VkMemoryRequirements* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkSparseMemoryBind(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSparseMemoryBind* from,
    VkSparseMemoryBind* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkSparseBufferMemoryBindInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSparseBufferMemoryBindInfo* from,
    VkSparseBufferMemoryBindInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (from)
    {
        to->pBinds = nullptr;
        if (from->pBinds)
        {
            to->pBinds = (VkSparseMemoryBind*)alloc->alloc(from->bindCount * sizeof(const VkSparseMemoryBind));
            to->bindCount = from->bindCount;
            for (uint32_t i = 0; i < (uint32_t)from->bindCount; ++i)
            {
                deepcopy_VkSparseMemoryBind(alloc, rootType, from->pBinds + i, (VkSparseMemoryBind*)(to->pBinds + i));
            }
        }
    }
}

void deepcopy_VkSparseImageOpaqueMemoryBindInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSparseImageOpaqueMemoryBindInfo* from,
    VkSparseImageOpaqueMemoryBindInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (from)
    {
        to->pBinds = nullptr;
        if (from->pBinds)
        {
            to->pBinds = (VkSparseMemoryBind*)alloc->alloc(from->bindCount * sizeof(const VkSparseMemoryBind));
            to->bindCount = from->bindCount;
            for (uint32_t i = 0; i < (uint32_t)from->bindCount; ++i)
            {
                deepcopy_VkSparseMemoryBind(alloc, rootType, from->pBinds + i, (VkSparseMemoryBind*)(to->pBinds + i));
            }
        }
    }
}

void deepcopy_VkImageSubresource(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageSubresource* from,
    VkImageSubresource* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkSparseImageMemoryBind(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSparseImageMemoryBind* from,
    VkSparseImageMemoryBind* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    deepcopy_VkImageSubresource(alloc, rootType, &from->subresource, (VkImageSubresource*)(&to->subresource));
    deepcopy_VkOffset3D(alloc, rootType, &from->offset, (VkOffset3D*)(&to->offset));
    deepcopy_VkExtent3D(alloc, rootType, &from->extent, (VkExtent3D*)(&to->extent));
}

void deepcopy_VkSparseImageMemoryBindInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSparseImageMemoryBindInfo* from,
    VkSparseImageMemoryBindInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (from)
    {
        to->pBinds = nullptr;
        if (from->pBinds)
        {
            to->pBinds = (VkSparseImageMemoryBind*)alloc->alloc(from->bindCount * sizeof(const VkSparseImageMemoryBind));
            to->bindCount = from->bindCount;
            for (uint32_t i = 0; i < (uint32_t)from->bindCount; ++i)
            {
                deepcopy_VkSparseImageMemoryBind(alloc, rootType, from->pBinds + i, (VkSparseImageMemoryBind*)(to->pBinds + i));
            }
        }
    }
}

void deepcopy_VkBindSparseInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBindSparseInfo* from,
    VkBindSparseInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pWaitSemaphores = nullptr;
    if (from->pWaitSemaphores)
    {
        to->pWaitSemaphores = (VkSemaphore*)alloc->dupArray(from->pWaitSemaphores, from->waitSemaphoreCount * sizeof(const VkSemaphore));
    }
    if (from)
    {
        to->pBufferBinds = nullptr;
        if (from->pBufferBinds)
        {
            to->pBufferBinds = (VkSparseBufferMemoryBindInfo*)alloc->alloc(from->bufferBindCount * sizeof(const VkSparseBufferMemoryBindInfo));
            to->bufferBindCount = from->bufferBindCount;
            for (uint32_t i = 0; i < (uint32_t)from->bufferBindCount; ++i)
            {
                deepcopy_VkSparseBufferMemoryBindInfo(alloc, rootType, from->pBufferBinds + i, (VkSparseBufferMemoryBindInfo*)(to->pBufferBinds + i));
            }
        }
    }
    if (from)
    {
        to->pImageOpaqueBinds = nullptr;
        if (from->pImageOpaqueBinds)
        {
            to->pImageOpaqueBinds = (VkSparseImageOpaqueMemoryBindInfo*)alloc->alloc(from->imageOpaqueBindCount * sizeof(const VkSparseImageOpaqueMemoryBindInfo));
            to->imageOpaqueBindCount = from->imageOpaqueBindCount;
            for (uint32_t i = 0; i < (uint32_t)from->imageOpaqueBindCount; ++i)
            {
                deepcopy_VkSparseImageOpaqueMemoryBindInfo(alloc, rootType, from->pImageOpaqueBinds + i, (VkSparseImageOpaqueMemoryBindInfo*)(to->pImageOpaqueBinds + i));
            }
        }
    }
    if (from)
    {
        to->pImageBinds = nullptr;
        if (from->pImageBinds)
        {
            to->pImageBinds = (VkSparseImageMemoryBindInfo*)alloc->alloc(from->imageBindCount * sizeof(const VkSparseImageMemoryBindInfo));
            to->imageBindCount = from->imageBindCount;
            for (uint32_t i = 0; i < (uint32_t)from->imageBindCount; ++i)
            {
                deepcopy_VkSparseImageMemoryBindInfo(alloc, rootType, from->pImageBinds + i, (VkSparseImageMemoryBindInfo*)(to->pImageBinds + i));
            }
        }
    }
    to->pSignalSemaphores = nullptr;
    if (from->pSignalSemaphores)
    {
        to->pSignalSemaphores = (VkSemaphore*)alloc->dupArray(from->pSignalSemaphores, from->signalSemaphoreCount * sizeof(const VkSemaphore));
    }
}

void deepcopy_VkSparseImageFormatProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSparseImageFormatProperties* from,
    VkSparseImageFormatProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    deepcopy_VkExtent3D(alloc, rootType, &from->imageGranularity, (VkExtent3D*)(&to->imageGranularity));
}

void deepcopy_VkSparseImageMemoryRequirements(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSparseImageMemoryRequirements* from,
    VkSparseImageMemoryRequirements* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    deepcopy_VkSparseImageFormatProperties(alloc, rootType, &from->formatProperties, (VkSparseImageFormatProperties*)(&to->formatProperties));
}

void deepcopy_VkFenceCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkFenceCreateInfo* from,
    VkFenceCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkSemaphoreCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSemaphoreCreateInfo* from,
    VkSemaphoreCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkEventCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkEventCreateInfo* from,
    VkEventCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkQueryPoolCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkQueryPoolCreateInfo* from,
    VkQueryPoolCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkBufferCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBufferCreateInfo* from,
    VkBufferCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pQueueFamilyIndices = nullptr;
    if (from->pQueueFamilyIndices)
    {
        to->pQueueFamilyIndices = (uint32_t*)alloc->dupArray(from->pQueueFamilyIndices, from->queueFamilyIndexCount * sizeof(const uint32_t));
    }
}

void deepcopy_VkBufferViewCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBufferViewCreateInfo* from,
    VkBufferViewCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkImageCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageCreateInfo* from,
    VkImageCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    deepcopy_VkExtent3D(alloc, rootType, &from->extent, (VkExtent3D*)(&to->extent));
    to->pQueueFamilyIndices = nullptr;
    if (from->pQueueFamilyIndices)
    {
        to->pQueueFamilyIndices = (uint32_t*)alloc->dupArray(from->pQueueFamilyIndices, from->queueFamilyIndexCount * sizeof(const uint32_t));
    }
}

void deepcopy_VkSubresourceLayout(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSubresourceLayout* from,
    VkSubresourceLayout* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkComponentMapping(
    Allocator* alloc,
    VkStructureType rootType,
    const VkComponentMapping* from,
    VkComponentMapping* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkImageViewCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageViewCreateInfo* from,
    VkImageViewCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    deepcopy_VkComponentMapping(alloc, rootType, &from->components, (VkComponentMapping*)(&to->components));
    deepcopy_VkImageSubresourceRange(alloc, rootType, &from->subresourceRange, (VkImageSubresourceRange*)(&to->subresourceRange));
}

void deepcopy_VkShaderModuleCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkShaderModuleCreateInfo* from,
    VkShaderModuleCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pCode = nullptr;
    if (from->pCode)
    {
        to->pCode = (uint32_t*)alloc->dupArray(from->pCode, (from->codeSize / 4) * sizeof(const uint32_t));
    }
}

void deepcopy_VkPipelineCacheCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineCacheCreateInfo* from,
    VkPipelineCacheCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pInitialData = nullptr;
    if (from->pInitialData)
    {
        to->pInitialData = (void*)alloc->dupArray(from->pInitialData, from->initialDataSize * sizeof(const uint8_t));
    }
}

void deepcopy_VkSpecializationMapEntry(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSpecializationMapEntry* from,
    VkSpecializationMapEntry* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkSpecializationInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSpecializationInfo* from,
    VkSpecializationInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (from)
    {
        to->pMapEntries = nullptr;
        if (from->pMapEntries)
        {
            to->pMapEntries = (VkSpecializationMapEntry*)alloc->alloc(from->mapEntryCount * sizeof(const VkSpecializationMapEntry));
            to->mapEntryCount = from->mapEntryCount;
            for (uint32_t i = 0; i < (uint32_t)from->mapEntryCount; ++i)
            {
                deepcopy_VkSpecializationMapEntry(alloc, rootType, from->pMapEntries + i, (VkSpecializationMapEntry*)(to->pMapEntries + i));
            }
        }
    }
    to->pData = nullptr;
    if (from->pData)
    {
        to->pData = (void*)alloc->dupArray(from->pData, from->dataSize * sizeof(const uint8_t));
    }
}

void deepcopy_VkPipelineShaderStageCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineShaderStageCreateInfo* from,
    VkPipelineShaderStageCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pName = nullptr;
    if (from->pName)
    {
        to->pName = alloc->strDup(from->pName);
    }
    to->pSpecializationInfo = nullptr;
    if (from->pSpecializationInfo)
    {
        to->pSpecializationInfo = (VkSpecializationInfo*)alloc->alloc(sizeof(const VkSpecializationInfo));
        deepcopy_VkSpecializationInfo(alloc, rootType, from->pSpecializationInfo, (VkSpecializationInfo*)(to->pSpecializationInfo));
    }
}

void deepcopy_VkComputePipelineCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkComputePipelineCreateInfo* from,
    VkComputePipelineCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    deepcopy_VkPipelineShaderStageCreateInfo(alloc, rootType, &from->stage, (VkPipelineShaderStageCreateInfo*)(&to->stage));
}

void deepcopy_VkVertexInputBindingDescription(
    Allocator* alloc,
    VkStructureType rootType,
    const VkVertexInputBindingDescription* from,
    VkVertexInputBindingDescription* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkVertexInputAttributeDescription(
    Allocator* alloc,
    VkStructureType rootType,
    const VkVertexInputAttributeDescription* from,
    VkVertexInputAttributeDescription* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkPipelineVertexInputStateCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineVertexInputStateCreateInfo* from,
    VkPipelineVertexInputStateCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    if (from)
    {
        to->pVertexBindingDescriptions = nullptr;
        if (from->pVertexBindingDescriptions)
        {
            to->pVertexBindingDescriptions = (VkVertexInputBindingDescription*)alloc->alloc(from->vertexBindingDescriptionCount * sizeof(const VkVertexInputBindingDescription));
            to->vertexBindingDescriptionCount = from->vertexBindingDescriptionCount;
            for (uint32_t i = 0; i < (uint32_t)from->vertexBindingDescriptionCount; ++i)
            {
                deepcopy_VkVertexInputBindingDescription(alloc, rootType, from->pVertexBindingDescriptions + i, (VkVertexInputBindingDescription*)(to->pVertexBindingDescriptions + i));
            }
        }
    }
    if (from)
    {
        to->pVertexAttributeDescriptions = nullptr;
        if (from->pVertexAttributeDescriptions)
        {
            to->pVertexAttributeDescriptions = (VkVertexInputAttributeDescription*)alloc->alloc(from->vertexAttributeDescriptionCount * sizeof(const VkVertexInputAttributeDescription));
            to->vertexAttributeDescriptionCount = from->vertexAttributeDescriptionCount;
            for (uint32_t i = 0; i < (uint32_t)from->vertexAttributeDescriptionCount; ++i)
            {
                deepcopy_VkVertexInputAttributeDescription(alloc, rootType, from->pVertexAttributeDescriptions + i, (VkVertexInputAttributeDescription*)(to->pVertexAttributeDescriptions + i));
            }
        }
    }
}

void deepcopy_VkPipelineInputAssemblyStateCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineInputAssemblyStateCreateInfo* from,
    VkPipelineInputAssemblyStateCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPipelineTessellationStateCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineTessellationStateCreateInfo* from,
    VkPipelineTessellationStateCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkViewport(
    Allocator* alloc,
    VkStructureType rootType,
    const VkViewport* from,
    VkViewport* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkPipelineViewportStateCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineViewportStateCreateInfo* from,
    VkPipelineViewportStateCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    if (from)
    {
        to->pViewports = nullptr;
        if (from->pViewports)
        {
            to->pViewports = (VkViewport*)alloc->alloc(from->viewportCount * sizeof(const VkViewport));
            to->viewportCount = from->viewportCount;
            for (uint32_t i = 0; i < (uint32_t)from->viewportCount; ++i)
            {
                deepcopy_VkViewport(alloc, rootType, from->pViewports + i, (VkViewport*)(to->pViewports + i));
            }
        }
    }
    if (from)
    {
        to->pScissors = nullptr;
        if (from->pScissors)
        {
            to->pScissors = (VkRect2D*)alloc->alloc(from->scissorCount * sizeof(const VkRect2D));
            to->scissorCount = from->scissorCount;
            for (uint32_t i = 0; i < (uint32_t)from->scissorCount; ++i)
            {
                deepcopy_VkRect2D(alloc, rootType, from->pScissors + i, (VkRect2D*)(to->pScissors + i));
            }
        }
    }
}

void deepcopy_VkPipelineRasterizationStateCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineRasterizationStateCreateInfo* from,
    VkPipelineRasterizationStateCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPipelineMultisampleStateCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineMultisampleStateCreateInfo* from,
    VkPipelineMultisampleStateCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pSampleMask = nullptr;
    if (from->pSampleMask)
    {
        to->pSampleMask = (VkSampleMask*)alloc->dupArray(from->pSampleMask, (((from->rasterizationSamples) + 31) / 32) * sizeof(const VkSampleMask));
    }
}

void deepcopy_VkStencilOpState(
    Allocator* alloc,
    VkStructureType rootType,
    const VkStencilOpState* from,
    VkStencilOpState* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkPipelineDepthStencilStateCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineDepthStencilStateCreateInfo* from,
    VkPipelineDepthStencilStateCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    deepcopy_VkStencilOpState(alloc, rootType, &from->front, (VkStencilOpState*)(&to->front));
    deepcopy_VkStencilOpState(alloc, rootType, &from->back, (VkStencilOpState*)(&to->back));
}

void deepcopy_VkPipelineColorBlendAttachmentState(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineColorBlendAttachmentState* from,
    VkPipelineColorBlendAttachmentState* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkPipelineColorBlendStateCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineColorBlendStateCreateInfo* from,
    VkPipelineColorBlendStateCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    if (from)
    {
        to->pAttachments = nullptr;
        if (from->pAttachments)
        {
            to->pAttachments = (VkPipelineColorBlendAttachmentState*)alloc->alloc(from->attachmentCount * sizeof(const VkPipelineColorBlendAttachmentState));
            to->attachmentCount = from->attachmentCount;
            for (uint32_t i = 0; i < (uint32_t)from->attachmentCount; ++i)
            {
                deepcopy_VkPipelineColorBlendAttachmentState(alloc, rootType, from->pAttachments + i, (VkPipelineColorBlendAttachmentState*)(to->pAttachments + i));
            }
        }
    }
    memcpy(to->blendConstants, from->blendConstants, 4 * sizeof(float));
}

void deepcopy_VkPipelineDynamicStateCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineDynamicStateCreateInfo* from,
    VkPipelineDynamicStateCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pDynamicStates = nullptr;
    if (from->pDynamicStates)
    {
        to->pDynamicStates = (VkDynamicState*)alloc->dupArray(from->pDynamicStates, from->dynamicStateCount * sizeof(const VkDynamicState));
    }
}

void deepcopy_VkGraphicsPipelineCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkGraphicsPipelineCreateInfo* from,
    VkGraphicsPipelineCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    if (from)
    {
        to->pStages = nullptr;
        if (from->pStages)
        {
            to->pStages = (VkPipelineShaderStageCreateInfo*)alloc->alloc(from->stageCount * sizeof(const VkPipelineShaderStageCreateInfo));
            to->stageCount = from->stageCount;
            for (uint32_t i = 0; i < (uint32_t)from->stageCount; ++i)
            {
                deepcopy_VkPipelineShaderStageCreateInfo(alloc, rootType, from->pStages + i, (VkPipelineShaderStageCreateInfo*)(to->pStages + i));
            }
        }
    }
    to->pVertexInputState = nullptr;
    if (from->pVertexInputState)
    {
        to->pVertexInputState = (VkPipelineVertexInputStateCreateInfo*)alloc->alloc(sizeof(const VkPipelineVertexInputStateCreateInfo));
        deepcopy_VkPipelineVertexInputStateCreateInfo(alloc, rootType, from->pVertexInputState, (VkPipelineVertexInputStateCreateInfo*)(to->pVertexInputState));
    }
    to->pInputAssemblyState = nullptr;
    if (from->pInputAssemblyState)
    {
        to->pInputAssemblyState = (VkPipelineInputAssemblyStateCreateInfo*)alloc->alloc(sizeof(const VkPipelineInputAssemblyStateCreateInfo));
        deepcopy_VkPipelineInputAssemblyStateCreateInfo(alloc, rootType, from->pInputAssemblyState, (VkPipelineInputAssemblyStateCreateInfo*)(to->pInputAssemblyState));
    }
    to->pTessellationState = nullptr;
    if (from->pTessellationState)
    {
        to->pTessellationState = (VkPipelineTessellationStateCreateInfo*)alloc->alloc(sizeof(const VkPipelineTessellationStateCreateInfo));
        deepcopy_VkPipelineTessellationStateCreateInfo(alloc, rootType, from->pTessellationState, (VkPipelineTessellationStateCreateInfo*)(to->pTessellationState));
    }
    to->pViewportState = nullptr;
    if (from->pViewportState)
    {
        to->pViewportState = (VkPipelineViewportStateCreateInfo*)alloc->alloc(sizeof(const VkPipelineViewportStateCreateInfo));
        deepcopy_VkPipelineViewportStateCreateInfo(alloc, rootType, from->pViewportState, (VkPipelineViewportStateCreateInfo*)(to->pViewportState));
    }
    to->pRasterizationState = nullptr;
    if (from->pRasterizationState)
    {
        to->pRasterizationState = (VkPipelineRasterizationStateCreateInfo*)alloc->alloc(sizeof(const VkPipelineRasterizationStateCreateInfo));
        deepcopy_VkPipelineRasterizationStateCreateInfo(alloc, rootType, from->pRasterizationState, (VkPipelineRasterizationStateCreateInfo*)(to->pRasterizationState));
    }
    to->pMultisampleState = nullptr;
    if (from->pMultisampleState)
    {
        to->pMultisampleState = (VkPipelineMultisampleStateCreateInfo*)alloc->alloc(sizeof(const VkPipelineMultisampleStateCreateInfo));
        deepcopy_VkPipelineMultisampleStateCreateInfo(alloc, rootType, from->pMultisampleState, (VkPipelineMultisampleStateCreateInfo*)(to->pMultisampleState));
    }
    to->pDepthStencilState = nullptr;
    if (from->pDepthStencilState)
    {
        to->pDepthStencilState = (VkPipelineDepthStencilStateCreateInfo*)alloc->alloc(sizeof(const VkPipelineDepthStencilStateCreateInfo));
        deepcopy_VkPipelineDepthStencilStateCreateInfo(alloc, rootType, from->pDepthStencilState, (VkPipelineDepthStencilStateCreateInfo*)(to->pDepthStencilState));
    }
    to->pColorBlendState = nullptr;
    if (from->pColorBlendState)
    {
        to->pColorBlendState = (VkPipelineColorBlendStateCreateInfo*)alloc->alloc(sizeof(const VkPipelineColorBlendStateCreateInfo));
        deepcopy_VkPipelineColorBlendStateCreateInfo(alloc, rootType, from->pColorBlendState, (VkPipelineColorBlendStateCreateInfo*)(to->pColorBlendState));
    }
    to->pDynamicState = nullptr;
    if (from->pDynamicState)
    {
        to->pDynamicState = (VkPipelineDynamicStateCreateInfo*)alloc->alloc(sizeof(const VkPipelineDynamicStateCreateInfo));
        deepcopy_VkPipelineDynamicStateCreateInfo(alloc, rootType, from->pDynamicState, (VkPipelineDynamicStateCreateInfo*)(to->pDynamicState));
    }
}

void deepcopy_VkPushConstantRange(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPushConstantRange* from,
    VkPushConstantRange* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkPipelineLayoutCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineLayoutCreateInfo* from,
    VkPipelineLayoutCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pSetLayouts = nullptr;
    if (from->pSetLayouts)
    {
        to->pSetLayouts = (VkDescriptorSetLayout*)alloc->dupArray(from->pSetLayouts, from->setLayoutCount * sizeof(const VkDescriptorSetLayout));
    }
    if (from)
    {
        to->pPushConstantRanges = nullptr;
        if (from->pPushConstantRanges)
        {
            to->pPushConstantRanges = (VkPushConstantRange*)alloc->alloc(from->pushConstantRangeCount * sizeof(const VkPushConstantRange));
            to->pushConstantRangeCount = from->pushConstantRangeCount;
            for (uint32_t i = 0; i < (uint32_t)from->pushConstantRangeCount; ++i)
            {
                deepcopy_VkPushConstantRange(alloc, rootType, from->pPushConstantRanges + i, (VkPushConstantRange*)(to->pPushConstantRanges + i));
            }
        }
    }
}

void deepcopy_VkSamplerCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSamplerCreateInfo* from,
    VkSamplerCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkCopyDescriptorSet(
    Allocator* alloc,
    VkStructureType rootType,
    const VkCopyDescriptorSet* from,
    VkCopyDescriptorSet* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkDescriptorBufferInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDescriptorBufferInfo* from,
    VkDescriptorBufferInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkDescriptorImageInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDescriptorImageInfo* from,
    VkDescriptorImageInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkDescriptorPoolSize(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDescriptorPoolSize* from,
    VkDescriptorPoolSize* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkDescriptorPoolCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDescriptorPoolCreateInfo* from,
    VkDescriptorPoolCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    if (from)
    {
        to->pPoolSizes = nullptr;
        if (from->pPoolSizes)
        {
            to->pPoolSizes = (VkDescriptorPoolSize*)alloc->alloc(from->poolSizeCount * sizeof(const VkDescriptorPoolSize));
            to->poolSizeCount = from->poolSizeCount;
            for (uint32_t i = 0; i < (uint32_t)from->poolSizeCount; ++i)
            {
                deepcopy_VkDescriptorPoolSize(alloc, rootType, from->pPoolSizes + i, (VkDescriptorPoolSize*)(to->pPoolSizes + i));
            }
        }
    }
}

void deepcopy_VkDescriptorSetAllocateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDescriptorSetAllocateInfo* from,
    VkDescriptorSetAllocateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pSetLayouts = nullptr;
    if (from->pSetLayouts)
    {
        to->pSetLayouts = (VkDescriptorSetLayout*)alloc->dupArray(from->pSetLayouts, from->descriptorSetCount * sizeof(const VkDescriptorSetLayout));
    }
}

void deepcopy_VkDescriptorSetLayoutBinding(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDescriptorSetLayoutBinding* from,
    VkDescriptorSetLayoutBinding* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    to->pImmutableSamplers = nullptr;
    if (from->pImmutableSamplers)
    {
        to->pImmutableSamplers = (VkSampler*)alloc->dupArray(from->pImmutableSamplers, from->descriptorCount * sizeof(const VkSampler));
    }
}

void deepcopy_VkDescriptorSetLayoutCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDescriptorSetLayoutCreateInfo* from,
    VkDescriptorSetLayoutCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    if (from)
    {
        to->pBindings = nullptr;
        if (from->pBindings)
        {
            to->pBindings = (VkDescriptorSetLayoutBinding*)alloc->alloc(from->bindingCount * sizeof(const VkDescriptorSetLayoutBinding));
            to->bindingCount = from->bindingCount;
            for (uint32_t i = 0; i < (uint32_t)from->bindingCount; ++i)
            {
                deepcopy_VkDescriptorSetLayoutBinding(alloc, rootType, from->pBindings + i, (VkDescriptorSetLayoutBinding*)(to->pBindings + i));
            }
        }
    }
}

void deepcopy_VkWriteDescriptorSet(
    Allocator* alloc,
    VkStructureType rootType,
    const VkWriteDescriptorSet* from,
    VkWriteDescriptorSet* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    if (from)
    {
        to->pImageInfo = nullptr;
        if (from->pImageInfo)
        {
            to->pImageInfo = (VkDescriptorImageInfo*)alloc->alloc(from->descriptorCount * sizeof(const VkDescriptorImageInfo));
            to->descriptorCount = from->descriptorCount;
            for (uint32_t i = 0; i < (uint32_t)from->descriptorCount; ++i)
            {
                deepcopy_VkDescriptorImageInfo(alloc, rootType, from->pImageInfo + i, (VkDescriptorImageInfo*)(to->pImageInfo + i));
            }
        }
    }
    if (from)
    {
        to->pBufferInfo = nullptr;
        if (from->pBufferInfo)
        {
            to->pBufferInfo = (VkDescriptorBufferInfo*)alloc->alloc(from->descriptorCount * sizeof(const VkDescriptorBufferInfo));
            to->descriptorCount = from->descriptorCount;
            for (uint32_t i = 0; i < (uint32_t)from->descriptorCount; ++i)
            {
                deepcopy_VkDescriptorBufferInfo(alloc, rootType, from->pBufferInfo + i, (VkDescriptorBufferInfo*)(to->pBufferInfo + i));
            }
        }
    }
    to->pTexelBufferView = nullptr;
    if (from->pTexelBufferView)
    {
        to->pTexelBufferView = (VkBufferView*)alloc->dupArray(from->pTexelBufferView, from->descriptorCount * sizeof(const VkBufferView));
    }
}

void deepcopy_VkAttachmentDescription(
    Allocator* alloc,
    VkStructureType rootType,
    const VkAttachmentDescription* from,
    VkAttachmentDescription* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkAttachmentReference(
    Allocator* alloc,
    VkStructureType rootType,
    const VkAttachmentReference* from,
    VkAttachmentReference* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkFramebufferCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkFramebufferCreateInfo* from,
    VkFramebufferCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pAttachments = nullptr;
    if (from->pAttachments)
    {
        to->pAttachments = (VkImageView*)alloc->dupArray(from->pAttachments, from->attachmentCount * sizeof(const VkImageView));
    }
}

void deepcopy_VkSubpassDescription(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSubpassDescription* from,
    VkSubpassDescription* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (from)
    {
        to->pInputAttachments = nullptr;
        if (from->pInputAttachments)
        {
            to->pInputAttachments = (VkAttachmentReference*)alloc->alloc(from->inputAttachmentCount * sizeof(const VkAttachmentReference));
            to->inputAttachmentCount = from->inputAttachmentCount;
            for (uint32_t i = 0; i < (uint32_t)from->inputAttachmentCount; ++i)
            {
                deepcopy_VkAttachmentReference(alloc, rootType, from->pInputAttachments + i, (VkAttachmentReference*)(to->pInputAttachments + i));
            }
        }
    }
    if (from)
    {
        to->pColorAttachments = nullptr;
        if (from->pColorAttachments)
        {
            to->pColorAttachments = (VkAttachmentReference*)alloc->alloc(from->colorAttachmentCount * sizeof(const VkAttachmentReference));
            to->colorAttachmentCount = from->colorAttachmentCount;
            for (uint32_t i = 0; i < (uint32_t)from->colorAttachmentCount; ++i)
            {
                deepcopy_VkAttachmentReference(alloc, rootType, from->pColorAttachments + i, (VkAttachmentReference*)(to->pColorAttachments + i));
            }
        }
    }
    if (from)
    {
        to->pResolveAttachments = nullptr;
        if (from->pResolveAttachments)
        {
            to->pResolveAttachments = (VkAttachmentReference*)alloc->alloc(from->colorAttachmentCount * sizeof(const VkAttachmentReference));
            to->colorAttachmentCount = from->colorAttachmentCount;
            for (uint32_t i = 0; i < (uint32_t)from->colorAttachmentCount; ++i)
            {
                deepcopy_VkAttachmentReference(alloc, rootType, from->pResolveAttachments + i, (VkAttachmentReference*)(to->pResolveAttachments + i));
            }
        }
    }
    to->pDepthStencilAttachment = nullptr;
    if (from->pDepthStencilAttachment)
    {
        to->pDepthStencilAttachment = (VkAttachmentReference*)alloc->alloc(sizeof(const VkAttachmentReference));
        deepcopy_VkAttachmentReference(alloc, rootType, from->pDepthStencilAttachment, (VkAttachmentReference*)(to->pDepthStencilAttachment));
    }
    to->pPreserveAttachments = nullptr;
    if (from->pPreserveAttachments)
    {
        to->pPreserveAttachments = (uint32_t*)alloc->dupArray(from->pPreserveAttachments, from->preserveAttachmentCount * sizeof(const uint32_t));
    }
}

void deepcopy_VkSubpassDependency(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSubpassDependency* from,
    VkSubpassDependency* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkRenderPassCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkRenderPassCreateInfo* from,
    VkRenderPassCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    if (from)
    {
        to->pAttachments = nullptr;
        if (from->pAttachments)
        {
            to->pAttachments = (VkAttachmentDescription*)alloc->alloc(from->attachmentCount * sizeof(const VkAttachmentDescription));
            to->attachmentCount = from->attachmentCount;
            for (uint32_t i = 0; i < (uint32_t)from->attachmentCount; ++i)
            {
                deepcopy_VkAttachmentDescription(alloc, rootType, from->pAttachments + i, (VkAttachmentDescription*)(to->pAttachments + i));
            }
        }
    }
    if (from)
    {
        to->pSubpasses = nullptr;
        if (from->pSubpasses)
        {
            to->pSubpasses = (VkSubpassDescription*)alloc->alloc(from->subpassCount * sizeof(const VkSubpassDescription));
            to->subpassCount = from->subpassCount;
            for (uint32_t i = 0; i < (uint32_t)from->subpassCount; ++i)
            {
                deepcopy_VkSubpassDescription(alloc, rootType, from->pSubpasses + i, (VkSubpassDescription*)(to->pSubpasses + i));
            }
        }
    }
    if (from)
    {
        to->pDependencies = nullptr;
        if (from->pDependencies)
        {
            to->pDependencies = (VkSubpassDependency*)alloc->alloc(from->dependencyCount * sizeof(const VkSubpassDependency));
            to->dependencyCount = from->dependencyCount;
            for (uint32_t i = 0; i < (uint32_t)from->dependencyCount; ++i)
            {
                deepcopy_VkSubpassDependency(alloc, rootType, from->pDependencies + i, (VkSubpassDependency*)(to->pDependencies + i));
            }
        }
    }
}

void deepcopy_VkCommandPoolCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkCommandPoolCreateInfo* from,
    VkCommandPoolCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkCommandBufferAllocateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkCommandBufferAllocateInfo* from,
    VkCommandBufferAllocateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkCommandBufferInheritanceInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkCommandBufferInheritanceInfo* from,
    VkCommandBufferInheritanceInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkCommandBufferBeginInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkCommandBufferBeginInfo* from,
    VkCommandBufferBeginInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pInheritanceInfo = nullptr;
    if (from->pInheritanceInfo)
    {
        to->pInheritanceInfo = (VkCommandBufferInheritanceInfo*)alloc->alloc(sizeof(const VkCommandBufferInheritanceInfo));
        deepcopy_VkCommandBufferInheritanceInfo(alloc, rootType, from->pInheritanceInfo, (VkCommandBufferInheritanceInfo*)(to->pInheritanceInfo));
    }
}

void deepcopy_VkBufferCopy(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBufferCopy* from,
    VkBufferCopy* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkImageSubresourceLayers(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageSubresourceLayers* from,
    VkImageSubresourceLayers* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkBufferImageCopy(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBufferImageCopy* from,
    VkBufferImageCopy* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    deepcopy_VkImageSubresourceLayers(alloc, rootType, &from->imageSubresource, (VkImageSubresourceLayers*)(&to->imageSubresource));
    deepcopy_VkOffset3D(alloc, rootType, &from->imageOffset, (VkOffset3D*)(&to->imageOffset));
    deepcopy_VkExtent3D(alloc, rootType, &from->imageExtent, (VkExtent3D*)(&to->imageExtent));
}

void deepcopy_VkClearColorValue(
    Allocator* alloc,
    VkStructureType rootType,
    const VkClearColorValue* from,
    VkClearColorValue* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    memcpy(to->float32, from->float32, 4 * sizeof(float));
    memcpy(to->int32, from->int32, 4 * sizeof(int32_t));
    memcpy(to->uint32, from->uint32, 4 * sizeof(uint32_t));
}

void deepcopy_VkClearDepthStencilValue(
    Allocator* alloc,
    VkStructureType rootType,
    const VkClearDepthStencilValue* from,
    VkClearDepthStencilValue* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkClearValue(
    Allocator* alloc,
    VkStructureType rootType,
    const VkClearValue* from,
    VkClearValue* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    deepcopy_VkClearColorValue(alloc, rootType, &from->color, (VkClearColorValue*)(&to->color));
    deepcopy_VkClearDepthStencilValue(alloc, rootType, &from->depthStencil, (VkClearDepthStencilValue*)(&to->depthStencil));
}

void deepcopy_VkClearAttachment(
    Allocator* alloc,
    VkStructureType rootType,
    const VkClearAttachment* from,
    VkClearAttachment* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    deepcopy_VkClearValue(alloc, rootType, &from->clearValue, (VkClearValue*)(&to->clearValue));
}

void deepcopy_VkClearRect(
    Allocator* alloc,
    VkStructureType rootType,
    const VkClearRect* from,
    VkClearRect* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    deepcopy_VkRect2D(alloc, rootType, &from->rect, (VkRect2D*)(&to->rect));
}

void deepcopy_VkImageBlit(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageBlit* from,
    VkImageBlit* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    deepcopy_VkImageSubresourceLayers(alloc, rootType, &from->srcSubresource, (VkImageSubresourceLayers*)(&to->srcSubresource));
    for (uint32_t i = 0; i < (uint32_t)2; ++i)
    {
        deepcopy_VkOffset3D(alloc, rootType, from->srcOffsets + i, (VkOffset3D*)(to->srcOffsets + i));
    }
    deepcopy_VkImageSubresourceLayers(alloc, rootType, &from->dstSubresource, (VkImageSubresourceLayers*)(&to->dstSubresource));
    for (uint32_t i = 0; i < (uint32_t)2; ++i)
    {
        deepcopy_VkOffset3D(alloc, rootType, from->dstOffsets + i, (VkOffset3D*)(to->dstOffsets + i));
    }
}

void deepcopy_VkImageCopy(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageCopy* from,
    VkImageCopy* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    deepcopy_VkImageSubresourceLayers(alloc, rootType, &from->srcSubresource, (VkImageSubresourceLayers*)(&to->srcSubresource));
    deepcopy_VkOffset3D(alloc, rootType, &from->srcOffset, (VkOffset3D*)(&to->srcOffset));
    deepcopy_VkImageSubresourceLayers(alloc, rootType, &from->dstSubresource, (VkImageSubresourceLayers*)(&to->dstSubresource));
    deepcopy_VkOffset3D(alloc, rootType, &from->dstOffset, (VkOffset3D*)(&to->dstOffset));
    deepcopy_VkExtent3D(alloc, rootType, &from->extent, (VkExtent3D*)(&to->extent));
}

void deepcopy_VkImageResolve(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageResolve* from,
    VkImageResolve* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    deepcopy_VkImageSubresourceLayers(alloc, rootType, &from->srcSubresource, (VkImageSubresourceLayers*)(&to->srcSubresource));
    deepcopy_VkOffset3D(alloc, rootType, &from->srcOffset, (VkOffset3D*)(&to->srcOffset));
    deepcopy_VkImageSubresourceLayers(alloc, rootType, &from->dstSubresource, (VkImageSubresourceLayers*)(&to->dstSubresource));
    deepcopy_VkOffset3D(alloc, rootType, &from->dstOffset, (VkOffset3D*)(&to->dstOffset));
    deepcopy_VkExtent3D(alloc, rootType, &from->extent, (VkExtent3D*)(&to->extent));
}

void deepcopy_VkRenderPassBeginInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkRenderPassBeginInfo* from,
    VkRenderPassBeginInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    deepcopy_VkRect2D(alloc, rootType, &from->renderArea, (VkRect2D*)(&to->renderArea));
    if (from)
    {
        to->pClearValues = nullptr;
        if (from->pClearValues)
        {
            to->pClearValues = (VkClearValue*)alloc->alloc(from->clearValueCount * sizeof(const VkClearValue));
            to->clearValueCount = from->clearValueCount;
            for (uint32_t i = 0; i < (uint32_t)from->clearValueCount; ++i)
            {
                deepcopy_VkClearValue(alloc, rootType, from->pClearValues + i, (VkClearValue*)(to->pClearValues + i));
            }
        }
    }
}

#endif
#ifdef VK_VERSION_1_1
void deepcopy_VkPhysicalDeviceSubgroupProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceSubgroupProperties* from,
    VkPhysicalDeviceSubgroupProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkBindBufferMemoryInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBindBufferMemoryInfo* from,
    VkBindBufferMemoryInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkBindImageMemoryInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBindImageMemoryInfo* from,
    VkBindImageMemoryInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDevice16BitStorageFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDevice16BitStorageFeatures* from,
    VkPhysicalDevice16BitStorageFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkMemoryDedicatedRequirements(
    Allocator* alloc,
    VkStructureType rootType,
    const VkMemoryDedicatedRequirements* from,
    VkMemoryDedicatedRequirements* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkMemoryDedicatedAllocateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkMemoryDedicatedAllocateInfo* from,
    VkMemoryDedicatedAllocateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkMemoryAllocateFlagsInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkMemoryAllocateFlagsInfo* from,
    VkMemoryAllocateFlagsInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkDeviceGroupRenderPassBeginInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDeviceGroupRenderPassBeginInfo* from,
    VkDeviceGroupRenderPassBeginInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    if (from)
    {
        to->pDeviceRenderAreas = nullptr;
        if (from->pDeviceRenderAreas)
        {
            to->pDeviceRenderAreas = (VkRect2D*)alloc->alloc(from->deviceRenderAreaCount * sizeof(const VkRect2D));
            to->deviceRenderAreaCount = from->deviceRenderAreaCount;
            for (uint32_t i = 0; i < (uint32_t)from->deviceRenderAreaCount; ++i)
            {
                deepcopy_VkRect2D(alloc, rootType, from->pDeviceRenderAreas + i, (VkRect2D*)(to->pDeviceRenderAreas + i));
            }
        }
    }
}

void deepcopy_VkDeviceGroupCommandBufferBeginInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDeviceGroupCommandBufferBeginInfo* from,
    VkDeviceGroupCommandBufferBeginInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkDeviceGroupSubmitInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDeviceGroupSubmitInfo* from,
    VkDeviceGroupSubmitInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pWaitSemaphoreDeviceIndices = nullptr;
    if (from->pWaitSemaphoreDeviceIndices)
    {
        to->pWaitSemaphoreDeviceIndices = (uint32_t*)alloc->dupArray(from->pWaitSemaphoreDeviceIndices, from->waitSemaphoreCount * sizeof(const uint32_t));
    }
    to->pCommandBufferDeviceMasks = nullptr;
    if (from->pCommandBufferDeviceMasks)
    {
        to->pCommandBufferDeviceMasks = (uint32_t*)alloc->dupArray(from->pCommandBufferDeviceMasks, from->commandBufferCount * sizeof(const uint32_t));
    }
    to->pSignalSemaphoreDeviceIndices = nullptr;
    if (from->pSignalSemaphoreDeviceIndices)
    {
        to->pSignalSemaphoreDeviceIndices = (uint32_t*)alloc->dupArray(from->pSignalSemaphoreDeviceIndices, from->signalSemaphoreCount * sizeof(const uint32_t));
    }
}

void deepcopy_VkDeviceGroupBindSparseInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDeviceGroupBindSparseInfo* from,
    VkDeviceGroupBindSparseInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkBindBufferMemoryDeviceGroupInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBindBufferMemoryDeviceGroupInfo* from,
    VkBindBufferMemoryDeviceGroupInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pDeviceIndices = nullptr;
    if (from->pDeviceIndices)
    {
        to->pDeviceIndices = (uint32_t*)alloc->dupArray(from->pDeviceIndices, from->deviceIndexCount * sizeof(const uint32_t));
    }
}

void deepcopy_VkBindImageMemoryDeviceGroupInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBindImageMemoryDeviceGroupInfo* from,
    VkBindImageMemoryDeviceGroupInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pDeviceIndices = nullptr;
    if (from->pDeviceIndices)
    {
        to->pDeviceIndices = (uint32_t*)alloc->dupArray(from->pDeviceIndices, from->deviceIndexCount * sizeof(const uint32_t));
    }
    if (from)
    {
        to->pSplitInstanceBindRegions = nullptr;
        if (from->pSplitInstanceBindRegions)
        {
            to->pSplitInstanceBindRegions = (VkRect2D*)alloc->alloc(from->splitInstanceBindRegionCount * sizeof(const VkRect2D));
            to->splitInstanceBindRegionCount = from->splitInstanceBindRegionCount;
            for (uint32_t i = 0; i < (uint32_t)from->splitInstanceBindRegionCount; ++i)
            {
                deepcopy_VkRect2D(alloc, rootType, from->pSplitInstanceBindRegions + i, (VkRect2D*)(to->pSplitInstanceBindRegions + i));
            }
        }
    }
}

void deepcopy_VkPhysicalDeviceGroupProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceGroupProperties* from,
    VkPhysicalDeviceGroupProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    memcpy(to->physicalDevices, from->physicalDevices, VK_MAX_DEVICE_GROUP_SIZE * sizeof(VkPhysicalDevice));
}

void deepcopy_VkDeviceGroupDeviceCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDeviceGroupDeviceCreateInfo* from,
    VkDeviceGroupDeviceCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pPhysicalDevices = nullptr;
    if (from->pPhysicalDevices)
    {
        to->pPhysicalDevices = (VkPhysicalDevice*)alloc->dupArray(from->pPhysicalDevices, from->physicalDeviceCount * sizeof(const VkPhysicalDevice));
    }
}

void deepcopy_VkBufferMemoryRequirementsInfo2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBufferMemoryRequirementsInfo2* from,
    VkBufferMemoryRequirementsInfo2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkImageMemoryRequirementsInfo2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageMemoryRequirementsInfo2* from,
    VkImageMemoryRequirementsInfo2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkImageSparseMemoryRequirementsInfo2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageSparseMemoryRequirementsInfo2* from,
    VkImageSparseMemoryRequirementsInfo2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkMemoryRequirements2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkMemoryRequirements2* from,
    VkMemoryRequirements2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    deepcopy_VkMemoryRequirements(alloc, rootType, &from->memoryRequirements, (VkMemoryRequirements*)(&to->memoryRequirements));
}

void deepcopy_VkSparseImageMemoryRequirements2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSparseImageMemoryRequirements2* from,
    VkSparseImageMemoryRequirements2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    deepcopy_VkSparseImageMemoryRequirements(alloc, rootType, &from->memoryRequirements, (VkSparseImageMemoryRequirements*)(&to->memoryRequirements));
}

void deepcopy_VkPhysicalDeviceFeatures2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceFeatures2* from,
    VkPhysicalDeviceFeatures2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    deepcopy_VkPhysicalDeviceFeatures(alloc, rootType, &from->features, (VkPhysicalDeviceFeatures*)(&to->features));
}

void deepcopy_VkPhysicalDeviceProperties2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceProperties2* from,
    VkPhysicalDeviceProperties2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    deepcopy_VkPhysicalDeviceProperties(alloc, rootType, &from->properties, (VkPhysicalDeviceProperties*)(&to->properties));
}

void deepcopy_VkFormatProperties2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkFormatProperties2* from,
    VkFormatProperties2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    deepcopy_VkFormatProperties(alloc, rootType, &from->formatProperties, (VkFormatProperties*)(&to->formatProperties));
}

void deepcopy_VkImageFormatProperties2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageFormatProperties2* from,
    VkImageFormatProperties2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    deepcopy_VkImageFormatProperties(alloc, rootType, &from->imageFormatProperties, (VkImageFormatProperties*)(&to->imageFormatProperties));
}

void deepcopy_VkPhysicalDeviceImageFormatInfo2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceImageFormatInfo2* from,
    VkPhysicalDeviceImageFormatInfo2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkQueueFamilyProperties2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkQueueFamilyProperties2* from,
    VkQueueFamilyProperties2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    deepcopy_VkQueueFamilyProperties(alloc, rootType, &from->queueFamilyProperties, (VkQueueFamilyProperties*)(&to->queueFamilyProperties));
}

void deepcopy_VkPhysicalDeviceMemoryProperties2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceMemoryProperties2* from,
    VkPhysicalDeviceMemoryProperties2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    deepcopy_VkPhysicalDeviceMemoryProperties(alloc, rootType, &from->memoryProperties, (VkPhysicalDeviceMemoryProperties*)(&to->memoryProperties));
}

void deepcopy_VkSparseImageFormatProperties2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSparseImageFormatProperties2* from,
    VkSparseImageFormatProperties2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    deepcopy_VkSparseImageFormatProperties(alloc, rootType, &from->properties, (VkSparseImageFormatProperties*)(&to->properties));
}

void deepcopy_VkPhysicalDeviceSparseImageFormatInfo2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceSparseImageFormatInfo2* from,
    VkPhysicalDeviceSparseImageFormatInfo2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDevicePointClippingProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDevicePointClippingProperties* from,
    VkPhysicalDevicePointClippingProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkInputAttachmentAspectReference(
    Allocator* alloc,
    VkStructureType rootType,
    const VkInputAttachmentAspectReference* from,
    VkInputAttachmentAspectReference* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkRenderPassInputAttachmentAspectCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkRenderPassInputAttachmentAspectCreateInfo* from,
    VkRenderPassInputAttachmentAspectCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    if (from)
    {
        to->pAspectReferences = nullptr;
        if (from->pAspectReferences)
        {
            to->pAspectReferences = (VkInputAttachmentAspectReference*)alloc->alloc(from->aspectReferenceCount * sizeof(const VkInputAttachmentAspectReference));
            to->aspectReferenceCount = from->aspectReferenceCount;
            for (uint32_t i = 0; i < (uint32_t)from->aspectReferenceCount; ++i)
            {
                deepcopy_VkInputAttachmentAspectReference(alloc, rootType, from->pAspectReferences + i, (VkInputAttachmentAspectReference*)(to->pAspectReferences + i));
            }
        }
    }
}

void deepcopy_VkImageViewUsageCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageViewUsageCreateInfo* from,
    VkImageViewUsageCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPipelineTessellationDomainOriginStateCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineTessellationDomainOriginStateCreateInfo* from,
    VkPipelineTessellationDomainOriginStateCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkRenderPassMultiviewCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkRenderPassMultiviewCreateInfo* from,
    VkRenderPassMultiviewCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pViewMasks = nullptr;
    if (from->pViewMasks)
    {
        to->pViewMasks = (uint32_t*)alloc->dupArray(from->pViewMasks, from->subpassCount * sizeof(const uint32_t));
    }
    to->pViewOffsets = nullptr;
    if (from->pViewOffsets)
    {
        to->pViewOffsets = (int32_t*)alloc->dupArray(from->pViewOffsets, from->dependencyCount * sizeof(const int32_t));
    }
    to->pCorrelationMasks = nullptr;
    if (from->pCorrelationMasks)
    {
        to->pCorrelationMasks = (uint32_t*)alloc->dupArray(from->pCorrelationMasks, from->correlationMaskCount * sizeof(const uint32_t));
    }
}

void deepcopy_VkPhysicalDeviceMultiviewFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceMultiviewFeatures* from,
    VkPhysicalDeviceMultiviewFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceMultiviewProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceMultiviewProperties* from,
    VkPhysicalDeviceMultiviewProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceVariablePointersFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceVariablePointersFeatures* from,
    VkPhysicalDeviceVariablePointersFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceProtectedMemoryFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceProtectedMemoryFeatures* from,
    VkPhysicalDeviceProtectedMemoryFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceProtectedMemoryProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceProtectedMemoryProperties* from,
    VkPhysicalDeviceProtectedMemoryProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkDeviceQueueInfo2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDeviceQueueInfo2* from,
    VkDeviceQueueInfo2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkProtectedSubmitInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkProtectedSubmitInfo* from,
    VkProtectedSubmitInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkSamplerYcbcrConversionCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSamplerYcbcrConversionCreateInfo* from,
    VkSamplerYcbcrConversionCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    deepcopy_VkComponentMapping(alloc, rootType, &from->components, (VkComponentMapping*)(&to->components));
}

void deepcopy_VkSamplerYcbcrConversionInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSamplerYcbcrConversionInfo* from,
    VkSamplerYcbcrConversionInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkBindImagePlaneMemoryInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBindImagePlaneMemoryInfo* from,
    VkBindImagePlaneMemoryInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkImagePlaneMemoryRequirementsInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImagePlaneMemoryRequirementsInfo* from,
    VkImagePlaneMemoryRequirementsInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceSamplerYcbcrConversionFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceSamplerYcbcrConversionFeatures* from,
    VkPhysicalDeviceSamplerYcbcrConversionFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkSamplerYcbcrConversionImageFormatProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSamplerYcbcrConversionImageFormatProperties* from,
    VkSamplerYcbcrConversionImageFormatProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkDescriptorUpdateTemplateEntry(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDescriptorUpdateTemplateEntry* from,
    VkDescriptorUpdateTemplateEntry* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkDescriptorUpdateTemplateCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDescriptorUpdateTemplateCreateInfo* from,
    VkDescriptorUpdateTemplateCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    if (from)
    {
        to->pDescriptorUpdateEntries = nullptr;
        if (from->pDescriptorUpdateEntries)
        {
            to->pDescriptorUpdateEntries = (VkDescriptorUpdateTemplateEntry*)alloc->alloc(from->descriptorUpdateEntryCount * sizeof(const VkDescriptorUpdateTemplateEntry));
            to->descriptorUpdateEntryCount = from->descriptorUpdateEntryCount;
            for (uint32_t i = 0; i < (uint32_t)from->descriptorUpdateEntryCount; ++i)
            {
                deepcopy_VkDescriptorUpdateTemplateEntry(alloc, rootType, from->pDescriptorUpdateEntries + i, (VkDescriptorUpdateTemplateEntry*)(to->pDescriptorUpdateEntries + i));
            }
        }
    }
}

void deepcopy_VkExternalMemoryProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkExternalMemoryProperties* from,
    VkExternalMemoryProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkPhysicalDeviceExternalImageFormatInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceExternalImageFormatInfo* from,
    VkPhysicalDeviceExternalImageFormatInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkExternalImageFormatProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkExternalImageFormatProperties* from,
    VkExternalImageFormatProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    deepcopy_VkExternalMemoryProperties(alloc, rootType, &from->externalMemoryProperties, (VkExternalMemoryProperties*)(&to->externalMemoryProperties));
}

void deepcopy_VkPhysicalDeviceExternalBufferInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceExternalBufferInfo* from,
    VkPhysicalDeviceExternalBufferInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkExternalBufferProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkExternalBufferProperties* from,
    VkExternalBufferProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    deepcopy_VkExternalMemoryProperties(alloc, rootType, &from->externalMemoryProperties, (VkExternalMemoryProperties*)(&to->externalMemoryProperties));
}

void deepcopy_VkPhysicalDeviceIDProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceIDProperties* from,
    VkPhysicalDeviceIDProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    memcpy(to->deviceUUID, from->deviceUUID, VK_UUID_SIZE * sizeof(uint8_t));
    memcpy(to->driverUUID, from->driverUUID, VK_UUID_SIZE * sizeof(uint8_t));
    memcpy(to->deviceLUID, from->deviceLUID, VK_LUID_SIZE * sizeof(uint8_t));
}

void deepcopy_VkExternalMemoryImageCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkExternalMemoryImageCreateInfo* from,
    VkExternalMemoryImageCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkExternalMemoryBufferCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkExternalMemoryBufferCreateInfo* from,
    VkExternalMemoryBufferCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkExportMemoryAllocateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkExportMemoryAllocateInfo* from,
    VkExportMemoryAllocateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceExternalFenceInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceExternalFenceInfo* from,
    VkPhysicalDeviceExternalFenceInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkExternalFenceProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkExternalFenceProperties* from,
    VkExternalFenceProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkExportFenceCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkExportFenceCreateInfo* from,
    VkExportFenceCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkExportSemaphoreCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkExportSemaphoreCreateInfo* from,
    VkExportSemaphoreCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceExternalSemaphoreInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceExternalSemaphoreInfo* from,
    VkPhysicalDeviceExternalSemaphoreInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkExternalSemaphoreProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkExternalSemaphoreProperties* from,
    VkExternalSemaphoreProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceMaintenance3Properties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance3Properties* from,
    VkPhysicalDeviceMaintenance3Properties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkDescriptorSetLayoutSupport(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDescriptorSetLayoutSupport* from,
    VkDescriptorSetLayoutSupport* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceShaderDrawParametersFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderDrawParametersFeatures* from,
    VkPhysicalDeviceShaderDrawParametersFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

#endif
#ifdef VK_VERSION_1_2
void deepcopy_VkPhysicalDeviceVulkan11Features(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan11Features* from,
    VkPhysicalDeviceVulkan11Features* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceVulkan11Properties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan11Properties* from,
    VkPhysicalDeviceVulkan11Properties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    memcpy(to->deviceUUID, from->deviceUUID, VK_UUID_SIZE * sizeof(uint8_t));
    memcpy(to->driverUUID, from->driverUUID, VK_UUID_SIZE * sizeof(uint8_t));
    memcpy(to->deviceLUID, from->deviceLUID, VK_LUID_SIZE * sizeof(uint8_t));
}

void deepcopy_VkPhysicalDeviceVulkan12Features(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan12Features* from,
    VkPhysicalDeviceVulkan12Features* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkConformanceVersion(
    Allocator* alloc,
    VkStructureType rootType,
    const VkConformanceVersion* from,
    VkConformanceVersion* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkPhysicalDeviceVulkan12Properties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan12Properties* from,
    VkPhysicalDeviceVulkan12Properties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    memcpy(to->driverName, from->driverName, VK_MAX_DRIVER_NAME_SIZE * sizeof(char));
    memcpy(to->driverInfo, from->driverInfo, VK_MAX_DRIVER_INFO_SIZE * sizeof(char));
    deepcopy_VkConformanceVersion(alloc, rootType, &from->conformanceVersion, (VkConformanceVersion*)(&to->conformanceVersion));
}

void deepcopy_VkImageFormatListCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageFormatListCreateInfo* from,
    VkImageFormatListCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pViewFormats = nullptr;
    if (from->pViewFormats)
    {
        to->pViewFormats = (VkFormat*)alloc->dupArray(from->pViewFormats, from->viewFormatCount * sizeof(const VkFormat));
    }
}

void deepcopy_VkAttachmentDescription2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkAttachmentDescription2* from,
    VkAttachmentDescription2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkAttachmentReference2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkAttachmentReference2* from,
    VkAttachmentReference2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkSubpassDescription2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSubpassDescription2* from,
    VkSubpassDescription2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    if (from)
    {
        to->pInputAttachments = nullptr;
        if (from->pInputAttachments)
        {
            to->pInputAttachments = (VkAttachmentReference2*)alloc->alloc(from->inputAttachmentCount * sizeof(const VkAttachmentReference2));
            to->inputAttachmentCount = from->inputAttachmentCount;
            for (uint32_t i = 0; i < (uint32_t)from->inputAttachmentCount; ++i)
            {
                deepcopy_VkAttachmentReference2(alloc, rootType, from->pInputAttachments + i, (VkAttachmentReference2*)(to->pInputAttachments + i));
            }
        }
    }
    if (from)
    {
        to->pColorAttachments = nullptr;
        if (from->pColorAttachments)
        {
            to->pColorAttachments = (VkAttachmentReference2*)alloc->alloc(from->colorAttachmentCount * sizeof(const VkAttachmentReference2));
            to->colorAttachmentCount = from->colorAttachmentCount;
            for (uint32_t i = 0; i < (uint32_t)from->colorAttachmentCount; ++i)
            {
                deepcopy_VkAttachmentReference2(alloc, rootType, from->pColorAttachments + i, (VkAttachmentReference2*)(to->pColorAttachments + i));
            }
        }
    }
    if (from)
    {
        to->pResolveAttachments = nullptr;
        if (from->pResolveAttachments)
        {
            to->pResolveAttachments = (VkAttachmentReference2*)alloc->alloc(from->colorAttachmentCount * sizeof(const VkAttachmentReference2));
            to->colorAttachmentCount = from->colorAttachmentCount;
            for (uint32_t i = 0; i < (uint32_t)from->colorAttachmentCount; ++i)
            {
                deepcopy_VkAttachmentReference2(alloc, rootType, from->pResolveAttachments + i, (VkAttachmentReference2*)(to->pResolveAttachments + i));
            }
        }
    }
    to->pDepthStencilAttachment = nullptr;
    if (from->pDepthStencilAttachment)
    {
        to->pDepthStencilAttachment = (VkAttachmentReference2*)alloc->alloc(sizeof(const VkAttachmentReference2));
        deepcopy_VkAttachmentReference2(alloc, rootType, from->pDepthStencilAttachment, (VkAttachmentReference2*)(to->pDepthStencilAttachment));
    }
    to->pPreserveAttachments = nullptr;
    if (from->pPreserveAttachments)
    {
        to->pPreserveAttachments = (uint32_t*)alloc->dupArray(from->pPreserveAttachments, from->preserveAttachmentCount * sizeof(const uint32_t));
    }
}

void deepcopy_VkSubpassDependency2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSubpassDependency2* from,
    VkSubpassDependency2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkRenderPassCreateInfo2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkRenderPassCreateInfo2* from,
    VkRenderPassCreateInfo2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    if (from)
    {
        to->pAttachments = nullptr;
        if (from->pAttachments)
        {
            to->pAttachments = (VkAttachmentDescription2*)alloc->alloc(from->attachmentCount * sizeof(const VkAttachmentDescription2));
            to->attachmentCount = from->attachmentCount;
            for (uint32_t i = 0; i < (uint32_t)from->attachmentCount; ++i)
            {
                deepcopy_VkAttachmentDescription2(alloc, rootType, from->pAttachments + i, (VkAttachmentDescription2*)(to->pAttachments + i));
            }
        }
    }
    if (from)
    {
        to->pSubpasses = nullptr;
        if (from->pSubpasses)
        {
            to->pSubpasses = (VkSubpassDescription2*)alloc->alloc(from->subpassCount * sizeof(const VkSubpassDescription2));
            to->subpassCount = from->subpassCount;
            for (uint32_t i = 0; i < (uint32_t)from->subpassCount; ++i)
            {
                deepcopy_VkSubpassDescription2(alloc, rootType, from->pSubpasses + i, (VkSubpassDescription2*)(to->pSubpasses + i));
            }
        }
    }
    if (from)
    {
        to->pDependencies = nullptr;
        if (from->pDependencies)
        {
            to->pDependencies = (VkSubpassDependency2*)alloc->alloc(from->dependencyCount * sizeof(const VkSubpassDependency2));
            to->dependencyCount = from->dependencyCount;
            for (uint32_t i = 0; i < (uint32_t)from->dependencyCount; ++i)
            {
                deepcopy_VkSubpassDependency2(alloc, rootType, from->pDependencies + i, (VkSubpassDependency2*)(to->pDependencies + i));
            }
        }
    }
    to->pCorrelatedViewMasks = nullptr;
    if (from->pCorrelatedViewMasks)
    {
        to->pCorrelatedViewMasks = (uint32_t*)alloc->dupArray(from->pCorrelatedViewMasks, from->correlatedViewMaskCount * sizeof(const uint32_t));
    }
}

void deepcopy_VkSubpassBeginInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSubpassBeginInfo* from,
    VkSubpassBeginInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkSubpassEndInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSubpassEndInfo* from,
    VkSubpassEndInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDevice8BitStorageFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDevice8BitStorageFeatures* from,
    VkPhysicalDevice8BitStorageFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceDriverProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceDriverProperties* from,
    VkPhysicalDeviceDriverProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    memcpy(to->driverName, from->driverName, VK_MAX_DRIVER_NAME_SIZE * sizeof(char));
    memcpy(to->driverInfo, from->driverInfo, VK_MAX_DRIVER_INFO_SIZE * sizeof(char));
    deepcopy_VkConformanceVersion(alloc, rootType, &from->conformanceVersion, (VkConformanceVersion*)(&to->conformanceVersion));
}

void deepcopy_VkPhysicalDeviceShaderAtomicInt64Features(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderAtomicInt64Features* from,
    VkPhysicalDeviceShaderAtomicInt64Features* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceShaderFloat16Int8Features(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderFloat16Int8Features* from,
    VkPhysicalDeviceShaderFloat16Int8Features* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceFloatControlsProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceFloatControlsProperties* from,
    VkPhysicalDeviceFloatControlsProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkDescriptorSetLayoutBindingFlagsCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDescriptorSetLayoutBindingFlagsCreateInfo* from,
    VkDescriptorSetLayoutBindingFlagsCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pBindingFlags = nullptr;
    if (from->pBindingFlags)
    {
        to->pBindingFlags = (VkDescriptorBindingFlags*)alloc->dupArray(from->pBindingFlags, from->bindingCount * sizeof(const VkDescriptorBindingFlags));
    }
}

void deepcopy_VkPhysicalDeviceDescriptorIndexingFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceDescriptorIndexingFeatures* from,
    VkPhysicalDeviceDescriptorIndexingFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceDescriptorIndexingProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceDescriptorIndexingProperties* from,
    VkPhysicalDeviceDescriptorIndexingProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkDescriptorSetVariableDescriptorCountAllocateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDescriptorSetVariableDescriptorCountAllocateInfo* from,
    VkDescriptorSetVariableDescriptorCountAllocateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pDescriptorCounts = nullptr;
    if (from->pDescriptorCounts)
    {
        to->pDescriptorCounts = (uint32_t*)alloc->dupArray(from->pDescriptorCounts, from->descriptorSetCount * sizeof(const uint32_t));
    }
}

void deepcopy_VkDescriptorSetVariableDescriptorCountLayoutSupport(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDescriptorSetVariableDescriptorCountLayoutSupport* from,
    VkDescriptorSetVariableDescriptorCountLayoutSupport* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkSubpassDescriptionDepthStencilResolve(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSubpassDescriptionDepthStencilResolve* from,
    VkSubpassDescriptionDepthStencilResolve* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pDepthStencilResolveAttachment = nullptr;
    if (from->pDepthStencilResolveAttachment)
    {
        to->pDepthStencilResolveAttachment = (VkAttachmentReference2*)alloc->alloc(sizeof(const VkAttachmentReference2));
        deepcopy_VkAttachmentReference2(alloc, rootType, from->pDepthStencilResolveAttachment, (VkAttachmentReference2*)(to->pDepthStencilResolveAttachment));
    }
}

void deepcopy_VkPhysicalDeviceDepthStencilResolveProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceDepthStencilResolveProperties* from,
    VkPhysicalDeviceDepthStencilResolveProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceScalarBlockLayoutFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceScalarBlockLayoutFeatures* from,
    VkPhysicalDeviceScalarBlockLayoutFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkImageStencilUsageCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageStencilUsageCreateInfo* from,
    VkImageStencilUsageCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkSamplerReductionModeCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSamplerReductionModeCreateInfo* from,
    VkSamplerReductionModeCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceSamplerFilterMinmaxProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceSamplerFilterMinmaxProperties* from,
    VkPhysicalDeviceSamplerFilterMinmaxProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceVulkanMemoryModelFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkanMemoryModelFeatures* from,
    VkPhysicalDeviceVulkanMemoryModelFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceImagelessFramebufferFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceImagelessFramebufferFeatures* from,
    VkPhysicalDeviceImagelessFramebufferFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkFramebufferAttachmentImageInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkFramebufferAttachmentImageInfo* from,
    VkFramebufferAttachmentImageInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pViewFormats = nullptr;
    if (from->pViewFormats)
    {
        to->pViewFormats = (VkFormat*)alloc->dupArray(from->pViewFormats, from->viewFormatCount * sizeof(const VkFormat));
    }
}

void deepcopy_VkFramebufferAttachmentsCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkFramebufferAttachmentsCreateInfo* from,
    VkFramebufferAttachmentsCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    if (from)
    {
        to->pAttachmentImageInfos = nullptr;
        if (from->pAttachmentImageInfos)
        {
            to->pAttachmentImageInfos = (VkFramebufferAttachmentImageInfo*)alloc->alloc(from->attachmentImageInfoCount * sizeof(const VkFramebufferAttachmentImageInfo));
            to->attachmentImageInfoCount = from->attachmentImageInfoCount;
            for (uint32_t i = 0; i < (uint32_t)from->attachmentImageInfoCount; ++i)
            {
                deepcopy_VkFramebufferAttachmentImageInfo(alloc, rootType, from->pAttachmentImageInfos + i, (VkFramebufferAttachmentImageInfo*)(to->pAttachmentImageInfos + i));
            }
        }
    }
}

void deepcopy_VkRenderPassAttachmentBeginInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkRenderPassAttachmentBeginInfo* from,
    VkRenderPassAttachmentBeginInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pAttachments = nullptr;
    if (from->pAttachments)
    {
        to->pAttachments = (VkImageView*)alloc->dupArray(from->pAttachments, from->attachmentCount * sizeof(const VkImageView));
    }
}

void deepcopy_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceUniformBufferStandardLayoutFeatures* from,
    VkPhysicalDeviceUniformBufferStandardLayoutFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures* from,
    VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures* from,
    VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkAttachmentReferenceStencilLayout(
    Allocator* alloc,
    VkStructureType rootType,
    const VkAttachmentReferenceStencilLayout* from,
    VkAttachmentReferenceStencilLayout* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkAttachmentDescriptionStencilLayout(
    Allocator* alloc,
    VkStructureType rootType,
    const VkAttachmentDescriptionStencilLayout* from,
    VkAttachmentDescriptionStencilLayout* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceHostQueryResetFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceHostQueryResetFeatures* from,
    VkPhysicalDeviceHostQueryResetFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceTimelineSemaphoreFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceTimelineSemaphoreFeatures* from,
    VkPhysicalDeviceTimelineSemaphoreFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceTimelineSemaphoreProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceTimelineSemaphoreProperties* from,
    VkPhysicalDeviceTimelineSemaphoreProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkSemaphoreTypeCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSemaphoreTypeCreateInfo* from,
    VkSemaphoreTypeCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkTimelineSemaphoreSubmitInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkTimelineSemaphoreSubmitInfo* from,
    VkTimelineSemaphoreSubmitInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pWaitSemaphoreValues = nullptr;
    if (from->pWaitSemaphoreValues)
    {
        to->pWaitSemaphoreValues = (uint64_t*)alloc->dupArray(from->pWaitSemaphoreValues, from->waitSemaphoreValueCount * sizeof(const uint64_t));
    }
    to->pSignalSemaphoreValues = nullptr;
    if (from->pSignalSemaphoreValues)
    {
        to->pSignalSemaphoreValues = (uint64_t*)alloc->dupArray(from->pSignalSemaphoreValues, from->signalSemaphoreValueCount * sizeof(const uint64_t));
    }
}

void deepcopy_VkSemaphoreWaitInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSemaphoreWaitInfo* from,
    VkSemaphoreWaitInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pSemaphores = nullptr;
    if (from->pSemaphores)
    {
        to->pSemaphores = (VkSemaphore*)alloc->dupArray(from->pSemaphores, from->semaphoreCount * sizeof(const VkSemaphore));
    }
    to->pValues = nullptr;
    if (from->pValues)
    {
        to->pValues = (uint64_t*)alloc->dupArray(from->pValues, from->semaphoreCount * sizeof(const uint64_t));
    }
}

void deepcopy_VkSemaphoreSignalInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSemaphoreSignalInfo* from,
    VkSemaphoreSignalInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceBufferDeviceAddressFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceBufferDeviceAddressFeatures* from,
    VkPhysicalDeviceBufferDeviceAddressFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkBufferDeviceAddressInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBufferDeviceAddressInfo* from,
    VkBufferDeviceAddressInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkBufferOpaqueCaptureAddressCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBufferOpaqueCaptureAddressCreateInfo* from,
    VkBufferOpaqueCaptureAddressCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkMemoryOpaqueCaptureAddressAllocateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkMemoryOpaqueCaptureAddressAllocateInfo* from,
    VkMemoryOpaqueCaptureAddressAllocateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkDeviceMemoryOpaqueCaptureAddressInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDeviceMemoryOpaqueCaptureAddressInfo* from,
    VkDeviceMemoryOpaqueCaptureAddressInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

#endif
#ifdef VK_VERSION_1_3
void deepcopy_VkPhysicalDeviceVulkan13Features(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan13Features* from,
    VkPhysicalDeviceVulkan13Features* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceVulkan13Properties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan13Properties* from,
    VkPhysicalDeviceVulkan13Properties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPipelineCreationFeedback(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineCreationFeedback* from,
    VkPipelineCreationFeedback* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkPipelineCreationFeedbackCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineCreationFeedbackCreateInfo* from,
    VkPipelineCreationFeedbackCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pPipelineCreationFeedback = nullptr;
    if (from->pPipelineCreationFeedback)
    {
        to->pPipelineCreationFeedback = (VkPipelineCreationFeedback*)alloc->alloc(sizeof(VkPipelineCreationFeedback));
        deepcopy_VkPipelineCreationFeedback(alloc, rootType, from->pPipelineCreationFeedback, (VkPipelineCreationFeedback*)(to->pPipelineCreationFeedback));
    }
    if (from)
    {
        to->pPipelineStageCreationFeedbacks = nullptr;
        if (from->pPipelineStageCreationFeedbacks)
        {
            to->pPipelineStageCreationFeedbacks = (VkPipelineCreationFeedback*)alloc->alloc(from->pipelineStageCreationFeedbackCount * sizeof(VkPipelineCreationFeedback));
            to->pipelineStageCreationFeedbackCount = from->pipelineStageCreationFeedbackCount;
            for (uint32_t i = 0; i < (uint32_t)from->pipelineStageCreationFeedbackCount; ++i)
            {
                deepcopy_VkPipelineCreationFeedback(alloc, rootType, from->pPipelineStageCreationFeedbacks + i, (VkPipelineCreationFeedback*)(to->pPipelineStageCreationFeedbacks + i));
            }
        }
    }
}

void deepcopy_VkPhysicalDeviceShaderTerminateInvocationFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderTerminateInvocationFeatures* from,
    VkPhysicalDeviceShaderTerminateInvocationFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceToolProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceToolProperties* from,
    VkPhysicalDeviceToolProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    memcpy(to->name, from->name, VK_MAX_EXTENSION_NAME_SIZE * sizeof(char));
    memcpy(to->version, from->version, VK_MAX_EXTENSION_NAME_SIZE * sizeof(char));
    memcpy(to->description, from->description, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    memcpy(to->layer, from->layer, VK_MAX_EXTENSION_NAME_SIZE * sizeof(char));
}

void deepcopy_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures* from,
    VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDevicePrivateDataFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDevicePrivateDataFeatures* from,
    VkPhysicalDevicePrivateDataFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkDevicePrivateDataCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDevicePrivateDataCreateInfo* from,
    VkDevicePrivateDataCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPrivateDataSlotCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPrivateDataSlotCreateInfo* from,
    VkPrivateDataSlotCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDevicePipelineCreationCacheControlFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineCreationCacheControlFeatures* from,
    VkPhysicalDevicePipelineCreationCacheControlFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkMemoryBarrier2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkMemoryBarrier2* from,
    VkMemoryBarrier2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkBufferMemoryBarrier2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBufferMemoryBarrier2* from,
    VkBufferMemoryBarrier2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkImageMemoryBarrier2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageMemoryBarrier2* from,
    VkImageMemoryBarrier2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    deepcopy_VkImageSubresourceRange(alloc, rootType, &from->subresourceRange, (VkImageSubresourceRange*)(&to->subresourceRange));
}

void deepcopy_VkDependencyInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDependencyInfo* from,
    VkDependencyInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    if (from)
    {
        to->pMemoryBarriers = nullptr;
        if (from->pMemoryBarriers)
        {
            to->pMemoryBarriers = (VkMemoryBarrier2*)alloc->alloc(from->memoryBarrierCount * sizeof(const VkMemoryBarrier2));
            to->memoryBarrierCount = from->memoryBarrierCount;
            for (uint32_t i = 0; i < (uint32_t)from->memoryBarrierCount; ++i)
            {
                deepcopy_VkMemoryBarrier2(alloc, rootType, from->pMemoryBarriers + i, (VkMemoryBarrier2*)(to->pMemoryBarriers + i));
            }
        }
    }
    if (from)
    {
        to->pBufferMemoryBarriers = nullptr;
        if (from->pBufferMemoryBarriers)
        {
            to->pBufferMemoryBarriers = (VkBufferMemoryBarrier2*)alloc->alloc(from->bufferMemoryBarrierCount * sizeof(const VkBufferMemoryBarrier2));
            to->bufferMemoryBarrierCount = from->bufferMemoryBarrierCount;
            for (uint32_t i = 0; i < (uint32_t)from->bufferMemoryBarrierCount; ++i)
            {
                deepcopy_VkBufferMemoryBarrier2(alloc, rootType, from->pBufferMemoryBarriers + i, (VkBufferMemoryBarrier2*)(to->pBufferMemoryBarriers + i));
            }
        }
    }
    if (from)
    {
        to->pImageMemoryBarriers = nullptr;
        if (from->pImageMemoryBarriers)
        {
            to->pImageMemoryBarriers = (VkImageMemoryBarrier2*)alloc->alloc(from->imageMemoryBarrierCount * sizeof(const VkImageMemoryBarrier2));
            to->imageMemoryBarrierCount = from->imageMemoryBarrierCount;
            for (uint32_t i = 0; i < (uint32_t)from->imageMemoryBarrierCount; ++i)
            {
                deepcopy_VkImageMemoryBarrier2(alloc, rootType, from->pImageMemoryBarriers + i, (VkImageMemoryBarrier2*)(to->pImageMemoryBarriers + i));
            }
        }
    }
}

void deepcopy_VkSemaphoreSubmitInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSemaphoreSubmitInfo* from,
    VkSemaphoreSubmitInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkCommandBufferSubmitInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkCommandBufferSubmitInfo* from,
    VkCommandBufferSubmitInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkSubmitInfo2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSubmitInfo2* from,
    VkSubmitInfo2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    if (from)
    {
        to->pWaitSemaphoreInfos = nullptr;
        if (from->pWaitSemaphoreInfos)
        {
            to->pWaitSemaphoreInfos = (VkSemaphoreSubmitInfo*)alloc->alloc(from->waitSemaphoreInfoCount * sizeof(const VkSemaphoreSubmitInfo));
            to->waitSemaphoreInfoCount = from->waitSemaphoreInfoCount;
            for (uint32_t i = 0; i < (uint32_t)from->waitSemaphoreInfoCount; ++i)
            {
                deepcopy_VkSemaphoreSubmitInfo(alloc, rootType, from->pWaitSemaphoreInfos + i, (VkSemaphoreSubmitInfo*)(to->pWaitSemaphoreInfos + i));
            }
        }
    }
    if (from)
    {
        to->pCommandBufferInfos = nullptr;
        if (from->pCommandBufferInfos)
        {
            to->pCommandBufferInfos = (VkCommandBufferSubmitInfo*)alloc->alloc(from->commandBufferInfoCount * sizeof(const VkCommandBufferSubmitInfo));
            to->commandBufferInfoCount = from->commandBufferInfoCount;
            for (uint32_t i = 0; i < (uint32_t)from->commandBufferInfoCount; ++i)
            {
                deepcopy_VkCommandBufferSubmitInfo(alloc, rootType, from->pCommandBufferInfos + i, (VkCommandBufferSubmitInfo*)(to->pCommandBufferInfos + i));
            }
        }
    }
    if (from)
    {
        to->pSignalSemaphoreInfos = nullptr;
        if (from->pSignalSemaphoreInfos)
        {
            to->pSignalSemaphoreInfos = (VkSemaphoreSubmitInfo*)alloc->alloc(from->signalSemaphoreInfoCount * sizeof(const VkSemaphoreSubmitInfo));
            to->signalSemaphoreInfoCount = from->signalSemaphoreInfoCount;
            for (uint32_t i = 0; i < (uint32_t)from->signalSemaphoreInfoCount; ++i)
            {
                deepcopy_VkSemaphoreSubmitInfo(alloc, rootType, from->pSignalSemaphoreInfos + i, (VkSemaphoreSubmitInfo*)(to->pSignalSemaphoreInfos + i));
            }
        }
    }
}

void deepcopy_VkPhysicalDeviceSynchronization2Features(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceSynchronization2Features* from,
    VkPhysicalDeviceSynchronization2Features* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures* from,
    VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceImageRobustnessFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceImageRobustnessFeatures* from,
    VkPhysicalDeviceImageRobustnessFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkBufferCopy2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBufferCopy2* from,
    VkBufferCopy2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkCopyBufferInfo2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkCopyBufferInfo2* from,
    VkCopyBufferInfo2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    if (from)
    {
        to->pRegions = nullptr;
        if (from->pRegions)
        {
            to->pRegions = (VkBufferCopy2*)alloc->alloc(from->regionCount * sizeof(const VkBufferCopy2));
            to->regionCount = from->regionCount;
            for (uint32_t i = 0; i < (uint32_t)from->regionCount; ++i)
            {
                deepcopy_VkBufferCopy2(alloc, rootType, from->pRegions + i, (VkBufferCopy2*)(to->pRegions + i));
            }
        }
    }
}

void deepcopy_VkImageCopy2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageCopy2* from,
    VkImageCopy2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    deepcopy_VkImageSubresourceLayers(alloc, rootType, &from->srcSubresource, (VkImageSubresourceLayers*)(&to->srcSubresource));
    deepcopy_VkOffset3D(alloc, rootType, &from->srcOffset, (VkOffset3D*)(&to->srcOffset));
    deepcopy_VkImageSubresourceLayers(alloc, rootType, &from->dstSubresource, (VkImageSubresourceLayers*)(&to->dstSubresource));
    deepcopy_VkOffset3D(alloc, rootType, &from->dstOffset, (VkOffset3D*)(&to->dstOffset));
    deepcopy_VkExtent3D(alloc, rootType, &from->extent, (VkExtent3D*)(&to->extent));
}

void deepcopy_VkCopyImageInfo2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkCopyImageInfo2* from,
    VkCopyImageInfo2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    if (from)
    {
        to->pRegions = nullptr;
        if (from->pRegions)
        {
            to->pRegions = (VkImageCopy2*)alloc->alloc(from->regionCount * sizeof(const VkImageCopy2));
            to->regionCount = from->regionCount;
            for (uint32_t i = 0; i < (uint32_t)from->regionCount; ++i)
            {
                deepcopy_VkImageCopy2(alloc, rootType, from->pRegions + i, (VkImageCopy2*)(to->pRegions + i));
            }
        }
    }
}

void deepcopy_VkBufferImageCopy2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBufferImageCopy2* from,
    VkBufferImageCopy2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    deepcopy_VkImageSubresourceLayers(alloc, rootType, &from->imageSubresource, (VkImageSubresourceLayers*)(&to->imageSubresource));
    deepcopy_VkOffset3D(alloc, rootType, &from->imageOffset, (VkOffset3D*)(&to->imageOffset));
    deepcopy_VkExtent3D(alloc, rootType, &from->imageExtent, (VkExtent3D*)(&to->imageExtent));
}

void deepcopy_VkCopyBufferToImageInfo2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkCopyBufferToImageInfo2* from,
    VkCopyBufferToImageInfo2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    if (from)
    {
        to->pRegions = nullptr;
        if (from->pRegions)
        {
            to->pRegions = (VkBufferImageCopy2*)alloc->alloc(from->regionCount * sizeof(const VkBufferImageCopy2));
            to->regionCount = from->regionCount;
            for (uint32_t i = 0; i < (uint32_t)from->regionCount; ++i)
            {
                deepcopy_VkBufferImageCopy2(alloc, rootType, from->pRegions + i, (VkBufferImageCopy2*)(to->pRegions + i));
            }
        }
    }
}

void deepcopy_VkCopyImageToBufferInfo2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkCopyImageToBufferInfo2* from,
    VkCopyImageToBufferInfo2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    if (from)
    {
        to->pRegions = nullptr;
        if (from->pRegions)
        {
            to->pRegions = (VkBufferImageCopy2*)alloc->alloc(from->regionCount * sizeof(const VkBufferImageCopy2));
            to->regionCount = from->regionCount;
            for (uint32_t i = 0; i < (uint32_t)from->regionCount; ++i)
            {
                deepcopy_VkBufferImageCopy2(alloc, rootType, from->pRegions + i, (VkBufferImageCopy2*)(to->pRegions + i));
            }
        }
    }
}

void deepcopy_VkImageBlit2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageBlit2* from,
    VkImageBlit2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    deepcopy_VkImageSubresourceLayers(alloc, rootType, &from->srcSubresource, (VkImageSubresourceLayers*)(&to->srcSubresource));
    for (uint32_t i = 0; i < (uint32_t)2; ++i)
    {
        deepcopy_VkOffset3D(alloc, rootType, from->srcOffsets + i, (VkOffset3D*)(to->srcOffsets + i));
    }
    deepcopy_VkImageSubresourceLayers(alloc, rootType, &from->dstSubresource, (VkImageSubresourceLayers*)(&to->dstSubresource));
    for (uint32_t i = 0; i < (uint32_t)2; ++i)
    {
        deepcopy_VkOffset3D(alloc, rootType, from->dstOffsets + i, (VkOffset3D*)(to->dstOffsets + i));
    }
}

void deepcopy_VkBlitImageInfo2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBlitImageInfo2* from,
    VkBlitImageInfo2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    if (from)
    {
        to->pRegions = nullptr;
        if (from->pRegions)
        {
            to->pRegions = (VkImageBlit2*)alloc->alloc(from->regionCount * sizeof(const VkImageBlit2));
            to->regionCount = from->regionCount;
            for (uint32_t i = 0; i < (uint32_t)from->regionCount; ++i)
            {
                deepcopy_VkImageBlit2(alloc, rootType, from->pRegions + i, (VkImageBlit2*)(to->pRegions + i));
            }
        }
    }
}

void deepcopy_VkImageResolve2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageResolve2* from,
    VkImageResolve2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    deepcopy_VkImageSubresourceLayers(alloc, rootType, &from->srcSubresource, (VkImageSubresourceLayers*)(&to->srcSubresource));
    deepcopy_VkOffset3D(alloc, rootType, &from->srcOffset, (VkOffset3D*)(&to->srcOffset));
    deepcopy_VkImageSubresourceLayers(alloc, rootType, &from->dstSubresource, (VkImageSubresourceLayers*)(&to->dstSubresource));
    deepcopy_VkOffset3D(alloc, rootType, &from->dstOffset, (VkOffset3D*)(&to->dstOffset));
    deepcopy_VkExtent3D(alloc, rootType, &from->extent, (VkExtent3D*)(&to->extent));
}

void deepcopy_VkResolveImageInfo2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkResolveImageInfo2* from,
    VkResolveImageInfo2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    if (from)
    {
        to->pRegions = nullptr;
        if (from->pRegions)
        {
            to->pRegions = (VkImageResolve2*)alloc->alloc(from->regionCount * sizeof(const VkImageResolve2));
            to->regionCount = from->regionCount;
            for (uint32_t i = 0; i < (uint32_t)from->regionCount; ++i)
            {
                deepcopy_VkImageResolve2(alloc, rootType, from->pRegions + i, (VkImageResolve2*)(to->pRegions + i));
            }
        }
    }
}

void deepcopy_VkPhysicalDeviceSubgroupSizeControlFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceSubgroupSizeControlFeatures* from,
    VkPhysicalDeviceSubgroupSizeControlFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceSubgroupSizeControlProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceSubgroupSizeControlProperties* from,
    VkPhysicalDeviceSubgroupSizeControlProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineShaderStageRequiredSubgroupSizeCreateInfo* from,
    VkPipelineShaderStageRequiredSubgroupSizeCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceInlineUniformBlockFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceInlineUniformBlockFeatures* from,
    VkPhysicalDeviceInlineUniformBlockFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceInlineUniformBlockProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceInlineUniformBlockProperties* from,
    VkPhysicalDeviceInlineUniformBlockProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkWriteDescriptorSetInlineUniformBlock(
    Allocator* alloc,
    VkStructureType rootType,
    const VkWriteDescriptorSetInlineUniformBlock* from,
    VkWriteDescriptorSetInlineUniformBlock* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pData = nullptr;
    if (from->pData)
    {
        to->pData = (void*)alloc->dupArray(from->pData, from->dataSize * sizeof(const uint8_t));
    }
}

void deepcopy_VkDescriptorPoolInlineUniformBlockCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDescriptorPoolInlineUniformBlockCreateInfo* from,
    VkDescriptorPoolInlineUniformBlockCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceTextureCompressionASTCHDRFeatures* from,
    VkPhysicalDeviceTextureCompressionASTCHDRFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkRenderingAttachmentInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkRenderingAttachmentInfo* from,
    VkRenderingAttachmentInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    deepcopy_VkClearValue(alloc, rootType, &from->clearValue, (VkClearValue*)(&to->clearValue));
}

void deepcopy_VkRenderingInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkRenderingInfo* from,
    VkRenderingInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    deepcopy_VkRect2D(alloc, rootType, &from->renderArea, (VkRect2D*)(&to->renderArea));
    if (from)
    {
        to->pColorAttachments = nullptr;
        if (from->pColorAttachments)
        {
            to->pColorAttachments = (VkRenderingAttachmentInfo*)alloc->alloc(from->colorAttachmentCount * sizeof(const VkRenderingAttachmentInfo));
            to->colorAttachmentCount = from->colorAttachmentCount;
            for (uint32_t i = 0; i < (uint32_t)from->colorAttachmentCount; ++i)
            {
                deepcopy_VkRenderingAttachmentInfo(alloc, rootType, from->pColorAttachments + i, (VkRenderingAttachmentInfo*)(to->pColorAttachments + i));
            }
        }
    }
    to->pDepthAttachment = nullptr;
    if (from->pDepthAttachment)
    {
        to->pDepthAttachment = (VkRenderingAttachmentInfo*)alloc->alloc(sizeof(const VkRenderingAttachmentInfo));
        deepcopy_VkRenderingAttachmentInfo(alloc, rootType, from->pDepthAttachment, (VkRenderingAttachmentInfo*)(to->pDepthAttachment));
    }
    to->pStencilAttachment = nullptr;
    if (from->pStencilAttachment)
    {
        to->pStencilAttachment = (VkRenderingAttachmentInfo*)alloc->alloc(sizeof(const VkRenderingAttachmentInfo));
        deepcopy_VkRenderingAttachmentInfo(alloc, rootType, from->pStencilAttachment, (VkRenderingAttachmentInfo*)(to->pStencilAttachment));
    }
}

void deepcopy_VkPipelineRenderingCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineRenderingCreateInfo* from,
    VkPipelineRenderingCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pColorAttachmentFormats = nullptr;
    if (from->pColorAttachmentFormats)
    {
        to->pColorAttachmentFormats = (VkFormat*)alloc->dupArray(from->pColorAttachmentFormats, from->colorAttachmentCount * sizeof(const VkFormat));
    }
}

void deepcopy_VkPhysicalDeviceDynamicRenderingFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceDynamicRenderingFeatures* from,
    VkPhysicalDeviceDynamicRenderingFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkCommandBufferInheritanceRenderingInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkCommandBufferInheritanceRenderingInfo* from,
    VkCommandBufferInheritanceRenderingInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pColorAttachmentFormats = nullptr;
    if (from->pColorAttachmentFormats)
    {
        to->pColorAttachmentFormats = (VkFormat*)alloc->dupArray(from->pColorAttachmentFormats, from->colorAttachmentCount * sizeof(const VkFormat));
    }
}

void deepcopy_VkPhysicalDeviceShaderIntegerDotProductFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderIntegerDotProductFeatures* from,
    VkPhysicalDeviceShaderIntegerDotProductFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceShaderIntegerDotProductProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderIntegerDotProductProperties* from,
    VkPhysicalDeviceShaderIntegerDotProductProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceTexelBufferAlignmentProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceTexelBufferAlignmentProperties* from,
    VkPhysicalDeviceTexelBufferAlignmentProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkFormatProperties3(
    Allocator* alloc,
    VkStructureType rootType,
    const VkFormatProperties3* from,
    VkFormatProperties3* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceMaintenance4Features(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance4Features* from,
    VkPhysicalDeviceMaintenance4Features* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceMaintenance4Properties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance4Properties* from,
    VkPhysicalDeviceMaintenance4Properties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkDeviceBufferMemoryRequirements(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDeviceBufferMemoryRequirements* from,
    VkDeviceBufferMemoryRequirements* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pCreateInfo = nullptr;
    if (from->pCreateInfo)
    {
        to->pCreateInfo = (VkBufferCreateInfo*)alloc->alloc(sizeof(const VkBufferCreateInfo));
        deepcopy_VkBufferCreateInfo(alloc, rootType, from->pCreateInfo, (VkBufferCreateInfo*)(to->pCreateInfo));
    }
}

void deepcopy_VkDeviceImageMemoryRequirements(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDeviceImageMemoryRequirements* from,
    VkDeviceImageMemoryRequirements* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pCreateInfo = nullptr;
    if (from->pCreateInfo)
    {
        to->pCreateInfo = (VkImageCreateInfo*)alloc->alloc(sizeof(const VkImageCreateInfo));
        deepcopy_VkImageCreateInfo(alloc, rootType, from->pCreateInfo, (VkImageCreateInfo*)(to->pCreateInfo));
    }
}

#endif
#ifdef VK_VERSION_1_4
void deepcopy_VkPhysicalDeviceVulkan14Features(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan14Features* from,
    VkPhysicalDeviceVulkan14Features* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceVulkan14Properties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan14Properties* from,
    VkPhysicalDeviceVulkan14Properties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pCopySrcLayouts = nullptr;
    if (from->pCopySrcLayouts)
    {
        to->pCopySrcLayouts = (VkImageLayout*)alloc->dupArray(from->pCopySrcLayouts, from->copySrcLayoutCount * sizeof(VkImageLayout));
    }
    to->pCopyDstLayouts = nullptr;
    if (from->pCopyDstLayouts)
    {
        to->pCopyDstLayouts = (VkImageLayout*)alloc->dupArray(from->pCopyDstLayouts, from->copyDstLayoutCount * sizeof(VkImageLayout));
    }
    memcpy(to->optimalTilingLayoutUUID, from->optimalTilingLayoutUUID, VK_UUID_SIZE * sizeof(uint8_t));
}

void deepcopy_VkDeviceQueueGlobalPriorityCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDeviceQueueGlobalPriorityCreateInfo* from,
    VkDeviceQueueGlobalPriorityCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceGlobalPriorityQueryFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceGlobalPriorityQueryFeatures* from,
    VkPhysicalDeviceGlobalPriorityQueryFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkQueueFamilyGlobalPriorityProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkQueueFamilyGlobalPriorityProperties* from,
    VkQueueFamilyGlobalPriorityProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    memcpy(to->priorities, from->priorities, VK_MAX_GLOBAL_PRIORITY_SIZE * sizeof(VkQueueGlobalPriority));
}

void deepcopy_VkPhysicalDeviceShaderSubgroupRotateFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderSubgroupRotateFeatures* from,
    VkPhysicalDeviceShaderSubgroupRotateFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceShaderFloatControls2Features(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderFloatControls2Features* from,
    VkPhysicalDeviceShaderFloatControls2Features* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceShaderExpectAssumeFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderExpectAssumeFeatures* from,
    VkPhysicalDeviceShaderExpectAssumeFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceLineRasterizationFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceLineRasterizationFeatures* from,
    VkPhysicalDeviceLineRasterizationFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceLineRasterizationProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceLineRasterizationProperties* from,
    VkPhysicalDeviceLineRasterizationProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPipelineRasterizationLineStateCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineRasterizationLineStateCreateInfo* from,
    VkPipelineRasterizationLineStateCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceVertexAttributeDivisorProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceVertexAttributeDivisorProperties* from,
    VkPhysicalDeviceVertexAttributeDivisorProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkVertexInputBindingDivisorDescription(
    Allocator* alloc,
    VkStructureType rootType,
    const VkVertexInputBindingDivisorDescription* from,
    VkVertexInputBindingDivisorDescription* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkPipelineVertexInputDivisorStateCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineVertexInputDivisorStateCreateInfo* from,
    VkPipelineVertexInputDivisorStateCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    if (from)
    {
        to->pVertexBindingDivisors = nullptr;
        if (from->pVertexBindingDivisors)
        {
            to->pVertexBindingDivisors = (VkVertexInputBindingDivisorDescription*)alloc->alloc(from->vertexBindingDivisorCount * sizeof(const VkVertexInputBindingDivisorDescription));
            to->vertexBindingDivisorCount = from->vertexBindingDivisorCount;
            for (uint32_t i = 0; i < (uint32_t)from->vertexBindingDivisorCount; ++i)
            {
                deepcopy_VkVertexInputBindingDivisorDescription(alloc, rootType, from->pVertexBindingDivisors + i, (VkVertexInputBindingDivisorDescription*)(to->pVertexBindingDivisors + i));
            }
        }
    }
}

void deepcopy_VkPhysicalDeviceVertexAttributeDivisorFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceVertexAttributeDivisorFeatures* from,
    VkPhysicalDeviceVertexAttributeDivisorFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceIndexTypeUint8Features(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceIndexTypeUint8Features* from,
    VkPhysicalDeviceIndexTypeUint8Features* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkMemoryMapInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkMemoryMapInfo* from,
    VkMemoryMapInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkMemoryUnmapInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkMemoryUnmapInfo* from,
    VkMemoryUnmapInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceMaintenance5Features(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance5Features* from,
    VkPhysicalDeviceMaintenance5Features* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceMaintenance5Properties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance5Properties* from,
    VkPhysicalDeviceMaintenance5Properties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkRenderingAreaInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkRenderingAreaInfo* from,
    VkRenderingAreaInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pColorAttachmentFormats = nullptr;
    if (from->pColorAttachmentFormats)
    {
        to->pColorAttachmentFormats = (VkFormat*)alloc->dupArray(from->pColorAttachmentFormats, from->colorAttachmentCount * sizeof(const VkFormat));
    }
}

void deepcopy_VkImageSubresource2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageSubresource2* from,
    VkImageSubresource2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    deepcopy_VkImageSubresource(alloc, rootType, &from->imageSubresource, (VkImageSubresource*)(&to->imageSubresource));
}

void deepcopy_VkDeviceImageSubresourceInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDeviceImageSubresourceInfo* from,
    VkDeviceImageSubresourceInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pCreateInfo = nullptr;
    if (from->pCreateInfo)
    {
        to->pCreateInfo = (VkImageCreateInfo*)alloc->alloc(sizeof(const VkImageCreateInfo));
        deepcopy_VkImageCreateInfo(alloc, rootType, from->pCreateInfo, (VkImageCreateInfo*)(to->pCreateInfo));
    }
    to->pSubresource = nullptr;
    if (from->pSubresource)
    {
        to->pSubresource = (VkImageSubresource2*)alloc->alloc(sizeof(const VkImageSubresource2));
        deepcopy_VkImageSubresource2(alloc, rootType, from->pSubresource, (VkImageSubresource2*)(to->pSubresource));
    }
}

void deepcopy_VkSubresourceLayout2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSubresourceLayout2* from,
    VkSubresourceLayout2* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    deepcopy_VkSubresourceLayout(alloc, rootType, &from->subresourceLayout, (VkSubresourceLayout*)(&to->subresourceLayout));
}

void deepcopy_VkPipelineCreateFlags2CreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineCreateFlags2CreateInfo* from,
    VkPipelineCreateFlags2CreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkBufferUsageFlags2CreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBufferUsageFlags2CreateInfo* from,
    VkBufferUsageFlags2CreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDevicePushDescriptorProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDevicePushDescriptorProperties* from,
    VkPhysicalDevicePushDescriptorProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceDynamicRenderingLocalReadFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceDynamicRenderingLocalReadFeatures* from,
    VkPhysicalDeviceDynamicRenderingLocalReadFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkRenderingAttachmentLocationInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkRenderingAttachmentLocationInfo* from,
    VkRenderingAttachmentLocationInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pColorAttachmentLocations = nullptr;
    if (from->pColorAttachmentLocations)
    {
        to->pColorAttachmentLocations = (uint32_t*)alloc->dupArray(from->pColorAttachmentLocations, from->colorAttachmentCount * sizeof(const uint32_t));
    }
}

void deepcopy_VkRenderingInputAttachmentIndexInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkRenderingInputAttachmentIndexInfo* from,
    VkRenderingInputAttachmentIndexInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pColorAttachmentInputIndices = nullptr;
    if (from->pColorAttachmentInputIndices)
    {
        to->pColorAttachmentInputIndices = (uint32_t*)alloc->dupArray(from->pColorAttachmentInputIndices, from->colorAttachmentCount * sizeof(const uint32_t));
    }
    to->pDepthInputAttachmentIndex = nullptr;
    if (from->pDepthInputAttachmentIndex)
    {
        to->pDepthInputAttachmentIndex = (uint32_t*)alloc->dupArray(from->pDepthInputAttachmentIndex, sizeof(const uint32_t));
    }
    to->pStencilInputAttachmentIndex = nullptr;
    if (from->pStencilInputAttachmentIndex)
    {
        to->pStencilInputAttachmentIndex = (uint32_t*)alloc->dupArray(from->pStencilInputAttachmentIndex, sizeof(const uint32_t));
    }
}

void deepcopy_VkPhysicalDeviceMaintenance6Features(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance6Features* from,
    VkPhysicalDeviceMaintenance6Features* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceMaintenance6Properties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance6Properties* from,
    VkPhysicalDeviceMaintenance6Properties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkBindMemoryStatus(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBindMemoryStatus* from,
    VkBindMemoryStatus* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pResult = nullptr;
    if (from->pResult)
    {
        to->pResult = (VkResult*)alloc->dupArray(from->pResult, sizeof(VkResult));
    }
}

void deepcopy_VkBindDescriptorSetsInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBindDescriptorSetsInfo* from,
    VkBindDescriptorSetsInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pDescriptorSets = nullptr;
    if (from->pDescriptorSets)
    {
        to->pDescriptorSets = (VkDescriptorSet*)alloc->dupArray(from->pDescriptorSets, from->descriptorSetCount * sizeof(const VkDescriptorSet));
    }
    to->pDynamicOffsets = nullptr;
    if (from->pDynamicOffsets)
    {
        to->pDynamicOffsets = (uint32_t*)alloc->dupArray(from->pDynamicOffsets, from->dynamicOffsetCount * sizeof(const uint32_t));
    }
}

void deepcopy_VkPushConstantsInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPushConstantsInfo* from,
    VkPushConstantsInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pValues = nullptr;
    if (from->pValues)
    {
        to->pValues = (void*)alloc->dupArray(from->pValues, from->size * sizeof(const uint8_t));
    }
}

void deepcopy_VkPushDescriptorSetInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPushDescriptorSetInfo* from,
    VkPushDescriptorSetInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    if (from)
    {
        to->pDescriptorWrites = nullptr;
        if (from->pDescriptorWrites)
        {
            to->pDescriptorWrites = (VkWriteDescriptorSet*)alloc->alloc(from->descriptorWriteCount * sizeof(const VkWriteDescriptorSet));
            to->descriptorWriteCount = from->descriptorWriteCount;
            for (uint32_t i = 0; i < (uint32_t)from->descriptorWriteCount; ++i)
            {
                deepcopy_VkWriteDescriptorSet(alloc, rootType, from->pDescriptorWrites + i, (VkWriteDescriptorSet*)(to->pDescriptorWrites + i));
            }
        }
    }
}

void deepcopy_VkPushDescriptorSetWithTemplateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPushDescriptorSetWithTemplateInfo* from,
    VkPushDescriptorSetWithTemplateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pData = nullptr;
    if (from->pData)
    {
        to->pData = (void*)alloc->dupArray(from->pData, sizeof(const uint8_t));
    }
}

void deepcopy_VkPhysicalDevicePipelineProtectedAccessFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineProtectedAccessFeatures* from,
    VkPhysicalDevicePipelineProtectedAccessFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDevicePipelineRobustnessFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineRobustnessFeatures* from,
    VkPhysicalDevicePipelineRobustnessFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDevicePipelineRobustnessProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineRobustnessProperties* from,
    VkPhysicalDevicePipelineRobustnessProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPipelineRobustnessCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineRobustnessCreateInfo* from,
    VkPipelineRobustnessCreateInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceHostImageCopyFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceHostImageCopyFeatures* from,
    VkPhysicalDeviceHostImageCopyFeatures* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceHostImageCopyProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceHostImageCopyProperties* from,
    VkPhysicalDeviceHostImageCopyProperties* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pCopySrcLayouts = nullptr;
    if (from->pCopySrcLayouts)
    {
        to->pCopySrcLayouts = (VkImageLayout*)alloc->dupArray(from->pCopySrcLayouts, from->copySrcLayoutCount * sizeof(VkImageLayout));
    }
    to->pCopyDstLayouts = nullptr;
    if (from->pCopyDstLayouts)
    {
        to->pCopyDstLayouts = (VkImageLayout*)alloc->dupArray(from->pCopyDstLayouts, from->copyDstLayoutCount * sizeof(VkImageLayout));
    }
    memcpy(to->optimalTilingLayoutUUID, from->optimalTilingLayoutUUID, VK_UUID_SIZE * sizeof(uint8_t));
}

void deepcopy_VkMemoryToImageCopy(
    Allocator* alloc,
    VkStructureType rootType,
    const VkMemoryToImageCopy* from,
    VkMemoryToImageCopy* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pHostPointer = nullptr;
    if (from->pHostPointer)
    {
        to->pHostPointer = (void*)alloc->dupArray(from->pHostPointer, sizeof(const uint8_t));
    }
    deepcopy_VkImageSubresourceLayers(alloc, rootType, &from->imageSubresource, (VkImageSubresourceLayers*)(&to->imageSubresource));
    deepcopy_VkOffset3D(alloc, rootType, &from->imageOffset, (VkOffset3D*)(&to->imageOffset));
    deepcopy_VkExtent3D(alloc, rootType, &from->imageExtent, (VkExtent3D*)(&to->imageExtent));
}

void deepcopy_VkImageToMemoryCopy(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageToMemoryCopy* from,
    VkImageToMemoryCopy* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pHostPointer = nullptr;
    if (from->pHostPointer)
    {
        to->pHostPointer = (void*)alloc->dupArray(from->pHostPointer, sizeof(uint8_t));
    }
    deepcopy_VkImageSubresourceLayers(alloc, rootType, &from->imageSubresource, (VkImageSubresourceLayers*)(&to->imageSubresource));
    deepcopy_VkOffset3D(alloc, rootType, &from->imageOffset, (VkOffset3D*)(&to->imageOffset));
    deepcopy_VkExtent3D(alloc, rootType, &from->imageExtent, (VkExtent3D*)(&to->imageExtent));
}

void deepcopy_VkCopyMemoryToImageInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkCopyMemoryToImageInfo* from,
    VkCopyMemoryToImageInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    if (from)
    {
        to->pRegions = nullptr;
        if (from->pRegions)
        {
            to->pRegions = (VkMemoryToImageCopy*)alloc->alloc(from->regionCount * sizeof(const VkMemoryToImageCopy));
            to->regionCount = from->regionCount;
            for (uint32_t i = 0; i < (uint32_t)from->regionCount; ++i)
            {
                deepcopy_VkMemoryToImageCopy(alloc, rootType, from->pRegions + i, (VkMemoryToImageCopy*)(to->pRegions + i));
            }
        }
    }
}

void deepcopy_VkCopyImageToMemoryInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkCopyImageToMemoryInfo* from,
    VkCopyImageToMemoryInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    if (from)
    {
        to->pRegions = nullptr;
        if (from->pRegions)
        {
            to->pRegions = (VkImageToMemoryCopy*)alloc->alloc(from->regionCount * sizeof(const VkImageToMemoryCopy));
            to->regionCount = from->regionCount;
            for (uint32_t i = 0; i < (uint32_t)from->regionCount; ++i)
            {
                deepcopy_VkImageToMemoryCopy(alloc, rootType, from->pRegions + i, (VkImageToMemoryCopy*)(to->pRegions + i));
            }
        }
    }
}

void deepcopy_VkCopyImageToImageInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkCopyImageToImageInfo* from,
    VkCopyImageToImageInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    if (from)
    {
        to->pRegions = nullptr;
        if (from->pRegions)
        {
            to->pRegions = (VkImageCopy2*)alloc->alloc(from->regionCount * sizeof(const VkImageCopy2));
            to->regionCount = from->regionCount;
            for (uint32_t i = 0; i < (uint32_t)from->regionCount; ++i)
            {
                deepcopy_VkImageCopy2(alloc, rootType, from->pRegions + i, (VkImageCopy2*)(to->pRegions + i));
            }
        }
    }
}

void deepcopy_VkHostImageLayoutTransitionInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkHostImageLayoutTransitionInfo* from,
    VkHostImageLayoutTransitionInfo* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    deepcopy_VkImageSubresourceRange(alloc, rootType, &from->subresourceRange, (VkImageSubresourceRange*)(&to->subresourceRange));
}

void deepcopy_VkSubresourceHostMemcpySize(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSubresourceHostMemcpySize* from,
    VkSubresourceHostMemcpySize* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkHostImageCopyDevicePerformanceQuery(
    Allocator* alloc,
    VkStructureType rootType,
    const VkHostImageCopyDevicePerformanceQuery* from,
    VkHostImageCopyDevicePerformanceQuery* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

#endif
#ifdef VK_KHR_external_semaphore_fd
void deepcopy_VkImportSemaphoreFdInfoKHR(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImportSemaphoreFdInfoKHR* from,
    VkImportSemaphoreFdInfoKHR* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkSemaphoreGetFdInfoKHR(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSemaphoreGetFdInfoKHR* from,
    VkSemaphoreGetFdInfoKHR* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

#endif
#ifdef VK_KHR_incremental_present
void deepcopy_VkRectLayerKHR(
    Allocator* alloc,
    VkStructureType rootType,
    const VkRectLayerKHR* from,
    VkRectLayerKHR* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    deepcopy_VkOffset2D(alloc, rootType, &from->offset, (VkOffset2D*)(&to->offset));
    deepcopy_VkExtent2D(alloc, rootType, &from->extent, (VkExtent2D*)(&to->extent));
}

void deepcopy_VkPresentRegionKHR(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPresentRegionKHR* from,
    VkPresentRegionKHR* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (from)
    {
        to->pRectangles = nullptr;
        if (from->pRectangles)
        {
            to->pRectangles = (VkRectLayerKHR*)alloc->alloc(from->rectangleCount * sizeof(const VkRectLayerKHR));
            to->rectangleCount = from->rectangleCount;
            for (uint32_t i = 0; i < (uint32_t)from->rectangleCount; ++i)
            {
                deepcopy_VkRectLayerKHR(alloc, rootType, from->pRectangles + i, (VkRectLayerKHR*)(to->pRectangles + i));
            }
        }
    }
}

void deepcopy_VkPresentRegionsKHR(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPresentRegionsKHR* from,
    VkPresentRegionsKHR* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    if (from)
    {
        to->pRegions = nullptr;
        if (from->pRegions)
        {
            to->pRegions = (VkPresentRegionKHR*)alloc->alloc(from->swapchainCount * sizeof(const VkPresentRegionKHR));
            to->swapchainCount = from->swapchainCount;
            for (uint32_t i = 0; i < (uint32_t)from->swapchainCount; ++i)
            {
                deepcopy_VkPresentRegionKHR(alloc, rootType, from->pRegions + i, (VkPresentRegionKHR*)(to->pRegions + i));
            }
        }
    }
}

#endif
#ifdef VK_KHR_external_fence_fd
void deepcopy_VkImportFenceFdInfoKHR(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImportFenceFdInfoKHR* from,
    VkImportFenceFdInfoKHR* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkFenceGetFdInfoKHR(
    Allocator* alloc,
    VkStructureType rootType,
    const VkFenceGetFdInfoKHR* from,
    VkFenceGetFdInfoKHR* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

#endif
#ifdef VK_KHR_pipeline_executable_properties
void deepcopy_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR* from,
    VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPipelineInfoKHR(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineInfoKHR* from,
    VkPipelineInfoKHR* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPipelineExecutablePropertiesKHR(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineExecutablePropertiesKHR* from,
    VkPipelineExecutablePropertiesKHR* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    memcpy(to->name, from->name, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    memcpy(to->description, from->description, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
}

void deepcopy_VkPipelineExecutableInfoKHR(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineExecutableInfoKHR* from,
    VkPipelineExecutableInfoKHR* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPipelineExecutableStatisticValueKHR(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineExecutableStatisticValueKHR* from,
    VkPipelineExecutableStatisticValueKHR* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkPipelineExecutableStatisticKHR(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineExecutableStatisticKHR* from,
    VkPipelineExecutableStatisticKHR* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    memcpy(to->name, from->name, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    memcpy(to->description, from->description, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    deepcopy_VkPipelineExecutableStatisticValueKHR(alloc, rootType, &from->value, (VkPipelineExecutableStatisticValueKHR*)(&to->value));
}

void deepcopy_VkPipelineExecutableInternalRepresentationKHR(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineExecutableInternalRepresentationKHR* from,
    VkPipelineExecutableInternalRepresentationKHR* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    memcpy(to->name, from->name, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    memcpy(to->description, from->description, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    to->pData = nullptr;
    if (from->pData)
    {
        to->pData = (void*)alloc->dupArray(from->pData, from->dataSize * sizeof(uint8_t));
    }
}

#endif
#ifdef VK_ANDROID_native_buffer
void deepcopy_VkNativeBufferUsage2ANDROID(
    Allocator* alloc,
    VkStructureType rootType,
    const VkNativeBufferUsage2ANDROID* from,
    VkNativeBufferUsage2ANDROID* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkNativeBufferANDROID(
    Allocator* alloc,
    VkStructureType rootType,
    const VkNativeBufferANDROID* from,
    VkNativeBufferANDROID* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->handle = nullptr;
    if (from->handle)
    {
        to->handle = (uint32_t*)alloc->dupArray(from->handle, sizeof(const uint32_t));
    }
    deepcopy_VkNativeBufferUsage2ANDROID(alloc, rootType, &from->usage2, (VkNativeBufferUsage2ANDROID*)(&to->usage2));
}

void deepcopy_VkSwapchainImageCreateInfoANDROID(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSwapchainImageCreateInfoANDROID* from,
    VkSwapchainImageCreateInfoANDROID* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDevicePresentationPropertiesANDROID(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDevicePresentationPropertiesANDROID* from,
    VkPhysicalDevicePresentationPropertiesANDROID* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

#endif
#ifdef VK_EXT_transform_feedback
void deepcopy_VkPhysicalDeviceTransformFeedbackFeaturesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceTransformFeedbackFeaturesEXT* from,
    VkPhysicalDeviceTransformFeedbackFeaturesEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceTransformFeedbackPropertiesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceTransformFeedbackPropertiesEXT* from,
    VkPhysicalDeviceTransformFeedbackPropertiesEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPipelineRasterizationStateStreamCreateInfoEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineRasterizationStateStreamCreateInfoEXT* from,
    VkPipelineRasterizationStateStreamCreateInfoEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

#endif
#ifdef VK_EXT_depth_clip_enable
void deepcopy_VkPhysicalDeviceDepthClipEnableFeaturesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceDepthClipEnableFeaturesEXT* from,
    VkPhysicalDeviceDepthClipEnableFeaturesEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPipelineRasterizationDepthClipStateCreateInfoEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineRasterizationDepthClipStateCreateInfoEXT* from,
    VkPipelineRasterizationDepthClipStateCreateInfoEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

#endif
#ifdef VK_EXT_image_drm_format_modifier
void deepcopy_VkDrmFormatModifierPropertiesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDrmFormatModifierPropertiesEXT* from,
    VkDrmFormatModifierPropertiesEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkDrmFormatModifierPropertiesListEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDrmFormatModifierPropertiesListEXT* from,
    VkDrmFormatModifierPropertiesListEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    if (from)
    {
        to->pDrmFormatModifierProperties = nullptr;
        if (from->pDrmFormatModifierProperties)
        {
            to->pDrmFormatModifierProperties = (VkDrmFormatModifierPropertiesEXT*)alloc->alloc(from->drmFormatModifierCount * sizeof(VkDrmFormatModifierPropertiesEXT));
            to->drmFormatModifierCount = from->drmFormatModifierCount;
            for (uint32_t i = 0; i < (uint32_t)from->drmFormatModifierCount; ++i)
            {
                deepcopy_VkDrmFormatModifierPropertiesEXT(alloc, rootType, from->pDrmFormatModifierProperties + i, (VkDrmFormatModifierPropertiesEXT*)(to->pDrmFormatModifierProperties + i));
            }
        }
    }
}

void deepcopy_VkPhysicalDeviceImageDrmFormatModifierInfoEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceImageDrmFormatModifierInfoEXT* from,
    VkPhysicalDeviceImageDrmFormatModifierInfoEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pQueueFamilyIndices = nullptr;
    if (from->pQueueFamilyIndices)
    {
        to->pQueueFamilyIndices = (uint32_t*)alloc->dupArray(from->pQueueFamilyIndices, from->queueFamilyIndexCount * sizeof(const uint32_t));
    }
}

void deepcopy_VkImageDrmFormatModifierListCreateInfoEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageDrmFormatModifierListCreateInfoEXT* from,
    VkImageDrmFormatModifierListCreateInfoEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pDrmFormatModifiers = nullptr;
    if (from->pDrmFormatModifiers)
    {
        to->pDrmFormatModifiers = (uint64_t*)alloc->dupArray(from->pDrmFormatModifiers, from->drmFormatModifierCount * sizeof(const uint64_t));
    }
}

void deepcopy_VkImageDrmFormatModifierExplicitCreateInfoEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageDrmFormatModifierExplicitCreateInfoEXT* from,
    VkImageDrmFormatModifierExplicitCreateInfoEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    if (from)
    {
        to->pPlaneLayouts = nullptr;
        if (from->pPlaneLayouts)
        {
            to->pPlaneLayouts = (VkSubresourceLayout*)alloc->alloc(from->drmFormatModifierPlaneCount * sizeof(const VkSubresourceLayout));
            to->drmFormatModifierPlaneCount = from->drmFormatModifierPlaneCount;
            for (uint32_t i = 0; i < (uint32_t)from->drmFormatModifierPlaneCount; ++i)
            {
                deepcopy_VkSubresourceLayout(alloc, rootType, from->pPlaneLayouts + i, (VkSubresourceLayout*)(to->pPlaneLayouts + i));
            }
        }
    }
}

void deepcopy_VkImageDrmFormatModifierPropertiesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageDrmFormatModifierPropertiesEXT* from,
    VkImageDrmFormatModifierPropertiesEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkDrmFormatModifierProperties2EXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDrmFormatModifierProperties2EXT* from,
    VkDrmFormatModifierProperties2EXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
}

void deepcopy_VkDrmFormatModifierPropertiesList2EXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDrmFormatModifierPropertiesList2EXT* from,
    VkDrmFormatModifierPropertiesList2EXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    if (from)
    {
        to->pDrmFormatModifierProperties = nullptr;
        if (from->pDrmFormatModifierProperties)
        {
            to->pDrmFormatModifierProperties = (VkDrmFormatModifierProperties2EXT*)alloc->alloc(from->drmFormatModifierCount * sizeof(VkDrmFormatModifierProperties2EXT));
            to->drmFormatModifierCount = from->drmFormatModifierCount;
            for (uint32_t i = 0; i < (uint32_t)from->drmFormatModifierCount; ++i)
            {
                deepcopy_VkDrmFormatModifierProperties2EXT(alloc, rootType, from->pDrmFormatModifierProperties + i, (VkDrmFormatModifierProperties2EXT*)(to->pDrmFormatModifierProperties + i));
            }
        }
    }
}

#endif
#ifdef VK_EXT_vertex_attribute_divisor
void deepcopy_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT* from,
    VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

#endif
#ifdef VK_EXT_fragment_density_map
void deepcopy_VkPhysicalDeviceFragmentDensityMapFeaturesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceFragmentDensityMapFeaturesEXT* from,
    VkPhysicalDeviceFragmentDensityMapFeaturesEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceFragmentDensityMapPropertiesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceFragmentDensityMapPropertiesEXT* from,
    VkPhysicalDeviceFragmentDensityMapPropertiesEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    deepcopy_VkExtent2D(alloc, rootType, &from->minFragmentDensityTexelSize, (VkExtent2D*)(&to->minFragmentDensityTexelSize));
    deepcopy_VkExtent2D(alloc, rootType, &from->maxFragmentDensityTexelSize, (VkExtent2D*)(&to->maxFragmentDensityTexelSize));
}

void deepcopy_VkRenderPassFragmentDensityMapCreateInfoEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkRenderPassFragmentDensityMapCreateInfoEXT* from,
    VkRenderPassFragmentDensityMapCreateInfoEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    deepcopy_VkAttachmentReference(alloc, rootType, &from->fragmentDensityMapAttachment, (VkAttachmentReference*)(&to->fragmentDensityMapAttachment));
}

void deepcopy_VkRenderingFragmentDensityMapAttachmentInfoEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkRenderingFragmentDensityMapAttachmentInfoEXT* from,
    VkRenderingFragmentDensityMapAttachmentInfoEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

#endif
#ifdef VK_EXT_memory_budget
void deepcopy_VkPhysicalDeviceMemoryBudgetPropertiesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceMemoryBudgetPropertiesEXT* from,
    VkPhysicalDeviceMemoryBudgetPropertiesEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    memcpy(to->heapBudget, from->heapBudget, VK_MAX_MEMORY_HEAPS * sizeof(VkDeviceSize));
    memcpy(to->heapUsage, from->heapUsage, VK_MAX_MEMORY_HEAPS * sizeof(VkDeviceSize));
}

#endif
#ifdef VK_EXT_provoking_vertex
void deepcopy_VkPhysicalDeviceProvokingVertexFeaturesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceProvokingVertexFeaturesEXT* from,
    VkPhysicalDeviceProvokingVertexFeaturesEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceProvokingVertexPropertiesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceProvokingVertexPropertiesEXT* from,
    VkPhysicalDeviceProvokingVertexPropertiesEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineRasterizationProvokingVertexStateCreateInfoEXT* from,
    VkPipelineRasterizationProvokingVertexStateCreateInfoEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

#endif
#ifdef VK_EXT_extended_dynamic_state
void deepcopy_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT* from,
    VkPhysicalDeviceExtendedDynamicStateFeaturesEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

#endif
#ifdef VK_EXT_texel_buffer_alignment
void deepcopy_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT* from,
    VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

#endif
#ifdef VK_EXT_device_memory_report
void deepcopy_VkPhysicalDeviceDeviceMemoryReportFeaturesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceDeviceMemoryReportFeaturesEXT* from,
    VkPhysicalDeviceDeviceMemoryReportFeaturesEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkDeviceMemoryReportCallbackDataEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDeviceMemoryReportCallbackDataEXT* from,
    VkDeviceMemoryReportCallbackDataEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkDeviceDeviceMemoryReportCreateInfoEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDeviceDeviceMemoryReportCreateInfoEXT* from,
    VkDeviceDeviceMemoryReportCreateInfoEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pUserData = nullptr;
    if (from->pUserData)
    {
        to->pUserData = (void*)alloc->dupArray(from->pUserData, sizeof(uint8_t));
    }
}

#endif
#ifdef VK_EXT_custom_border_color
void deepcopy_VkSamplerCustomBorderColorCreateInfoEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSamplerCustomBorderColorCreateInfoEXT* from,
    VkSamplerCustomBorderColorCreateInfoEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    deepcopy_VkClearColorValue(alloc, rootType, &from->customBorderColor, (VkClearColorValue*)(&to->customBorderColor));
}

void deepcopy_VkPhysicalDeviceCustomBorderColorPropertiesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceCustomBorderColorPropertiesEXT* from,
    VkPhysicalDeviceCustomBorderColorPropertiesEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceCustomBorderColorFeaturesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceCustomBorderColorFeaturesEXT* from,
    VkPhysicalDeviceCustomBorderColorFeaturesEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

#endif
#ifdef VK_EXT_graphics_pipeline_library
void deepcopy_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT* from,
    VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT* from,
    VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkGraphicsPipelineLibraryCreateInfoEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkGraphicsPipelineLibraryCreateInfoEXT* from,
    VkGraphicsPipelineLibraryCreateInfoEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

#endif
#ifdef VK_EXT_ycbcr_2plane_444_formats
void deepcopy_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT* from,
    VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

#endif
#ifdef VK_EXT_image_compression_control
void deepcopy_VkPhysicalDeviceImageCompressionControlFeaturesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceImageCompressionControlFeaturesEXT* from,
    VkPhysicalDeviceImageCompressionControlFeaturesEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkImageCompressionControlEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageCompressionControlEXT* from,
    VkImageCompressionControlEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pFixedRateFlags = nullptr;
    if (from->pFixedRateFlags)
    {
        to->pFixedRateFlags = (VkImageCompressionFixedRateFlagsEXT*)alloc->dupArray(from->pFixedRateFlags, from->compressionControlPlaneCount * sizeof(VkImageCompressionFixedRateFlagsEXT));
    }
}

void deepcopy_VkImageCompressionPropertiesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageCompressionPropertiesEXT* from,
    VkImageCompressionPropertiesEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

#endif
#ifdef VK_EXT_4444_formats
void deepcopy_VkPhysicalDevice4444FormatsFeaturesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDevice4444FormatsFeaturesEXT* from,
    VkPhysicalDevice4444FormatsFeaturesEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

#endif
#ifdef VK_EXT_primitive_topology_list_restart
void deepcopy_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT* from,
    VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

#endif
#ifdef VK_EXT_extended_dynamic_state2
void deepcopy_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT* from,
    VkPhysicalDeviceExtendedDynamicState2FeaturesEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

#endif
#ifdef VK_EXT_color_write_enable
void deepcopy_VkPhysicalDeviceColorWriteEnableFeaturesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceColorWriteEnableFeaturesEXT* from,
    VkPhysicalDeviceColorWriteEnableFeaturesEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkPipelineColorWriteCreateInfoEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineColorWriteCreateInfoEXT* from,
    VkPipelineColorWriteCreateInfoEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
    to->pColorWriteEnables = nullptr;
    if (from->pColorWriteEnables)
    {
        to->pColorWriteEnables = (VkBool32*)alloc->dupArray(from->pColorWriteEnables, from->attachmentCount * sizeof(const VkBool32));
    }
}

#endif
#ifdef VK_GOOGLE_gfxstream
void deepcopy_VkImportColorBufferGOOGLE(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImportColorBufferGOOGLE* from,
    VkImportColorBufferGOOGLE* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkImportBufferGOOGLE(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImportBufferGOOGLE* from,
    VkImportBufferGOOGLE* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

void deepcopy_VkCreateBlobGOOGLE(
    Allocator* alloc,
    VkStructureType rootType,
    const VkCreateBlobGOOGLE* from,
    VkCreateBlobGOOGLE* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

#endif
#ifdef VK_EXT_image_compression_control_swapchain
void deepcopy_VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT* from,
    VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT* to)
{
    (void)alloc;
    (void)rootType;
    *to = *from;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = from->sType;
    }
    const void* from_pNext = from;
    size_t pNext_size = 0u;
    while (!pNext_size && from_pNext)
    {
        from_pNext = static_cast<const VkBaseOutStructure*>(from_pNext)->pNext;
        pNext_size = goldfish_vk_extension_struct_size(rootType, from_pNext);
    }
    to->pNext = nullptr;
    if (pNext_size)
    {
        to->pNext = (void*)alloc->alloc(pNext_size);
        deepcopy_extension_struct(alloc, rootType, from_pNext, (void*)(to->pNext));
    }
}

#endif
void deepcopy_extension_struct(
    Allocator* alloc,
    VkStructureType rootType,
    const void* structExtension,
    void* structExtension_out)
{
    if (!structExtension)
    {
        return;
    }
    uint32_t structType = (uint32_t)goldfish_vk_struct_type(structExtension);
    switch(structType)
    {
#ifdef VK_VERSION_1_0
        case VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO:
        {
            deepcopy_VkShaderModuleCreateInfo(alloc, rootType, reinterpret_cast<const VkShaderModuleCreateInfo*>(structExtension), reinterpret_cast<VkShaderModuleCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO:
        {
            deepcopy_VkPipelineLayoutCreateInfo(alloc, rootType, reinterpret_cast<const VkPipelineLayoutCreateInfo*>(structExtension), reinterpret_cast<VkPipelineLayoutCreateInfo*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_VERSION_1_1
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES:
        {
            deepcopy_VkPhysicalDeviceSubgroupProperties(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceSubgroupProperties*>(structExtension), reinterpret_cast<VkPhysicalDeviceSubgroupProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
        {
            deepcopy_VkPhysicalDevice16BitStorageFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDevice16BitStorageFeatures*>(structExtension), reinterpret_cast<VkPhysicalDevice16BitStorageFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS:
        {
            deepcopy_VkMemoryDedicatedRequirements(alloc, rootType, reinterpret_cast<const VkMemoryDedicatedRequirements*>(structExtension), reinterpret_cast<VkMemoryDedicatedRequirements*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO:
        {
            deepcopy_VkMemoryDedicatedAllocateInfo(alloc, rootType, reinterpret_cast<const VkMemoryDedicatedAllocateInfo*>(structExtension), reinterpret_cast<VkMemoryDedicatedAllocateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO:
        {
            deepcopy_VkMemoryAllocateFlagsInfo(alloc, rootType, reinterpret_cast<const VkMemoryAllocateFlagsInfo*>(structExtension), reinterpret_cast<VkMemoryAllocateFlagsInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO:
        {
            deepcopy_VkDeviceGroupRenderPassBeginInfo(alloc, rootType, reinterpret_cast<const VkDeviceGroupRenderPassBeginInfo*>(structExtension), reinterpret_cast<VkDeviceGroupRenderPassBeginInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO:
        {
            deepcopy_VkDeviceGroupCommandBufferBeginInfo(alloc, rootType, reinterpret_cast<const VkDeviceGroupCommandBufferBeginInfo*>(structExtension), reinterpret_cast<VkDeviceGroupCommandBufferBeginInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO:
        {
            deepcopy_VkDeviceGroupSubmitInfo(alloc, rootType, reinterpret_cast<const VkDeviceGroupSubmitInfo*>(structExtension), reinterpret_cast<VkDeviceGroupSubmitInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO:
        {
            deepcopy_VkDeviceGroupBindSparseInfo(alloc, rootType, reinterpret_cast<const VkDeviceGroupBindSparseInfo*>(structExtension), reinterpret_cast<VkDeviceGroupBindSparseInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO:
        {
            deepcopy_VkBindBufferMemoryDeviceGroupInfo(alloc, rootType, reinterpret_cast<const VkBindBufferMemoryDeviceGroupInfo*>(structExtension), reinterpret_cast<VkBindBufferMemoryDeviceGroupInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO:
        {
            deepcopy_VkBindImageMemoryDeviceGroupInfo(alloc, rootType, reinterpret_cast<const VkBindImageMemoryDeviceGroupInfo*>(structExtension), reinterpret_cast<VkBindImageMemoryDeviceGroupInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO:
        {
            deepcopy_VkDeviceGroupDeviceCreateInfo(alloc, rootType, reinterpret_cast<const VkDeviceGroupDeviceCreateInfo*>(structExtension), reinterpret_cast<VkDeviceGroupDeviceCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2:
        {
            deepcopy_VkPhysicalDeviceFeatures2(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceFeatures2*>(structExtension), reinterpret_cast<VkPhysicalDeviceFeatures2*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES:
        {
            deepcopy_VkPhysicalDevicePointClippingProperties(alloc, rootType, reinterpret_cast<const VkPhysicalDevicePointClippingProperties*>(structExtension), reinterpret_cast<VkPhysicalDevicePointClippingProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO:
        {
            deepcopy_VkRenderPassInputAttachmentAspectCreateInfo(alloc, rootType, reinterpret_cast<const VkRenderPassInputAttachmentAspectCreateInfo*>(structExtension), reinterpret_cast<VkRenderPassInputAttachmentAspectCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO:
        {
            deepcopy_VkImageViewUsageCreateInfo(alloc, rootType, reinterpret_cast<const VkImageViewUsageCreateInfo*>(structExtension), reinterpret_cast<VkImageViewUsageCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO:
        {
            deepcopy_VkPipelineTessellationDomainOriginStateCreateInfo(alloc, rootType, reinterpret_cast<const VkPipelineTessellationDomainOriginStateCreateInfo*>(structExtension), reinterpret_cast<VkPipelineTessellationDomainOriginStateCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO:
        {
            deepcopy_VkRenderPassMultiviewCreateInfo(alloc, rootType, reinterpret_cast<const VkRenderPassMultiviewCreateInfo*>(structExtension), reinterpret_cast<VkRenderPassMultiviewCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
        {
            deepcopy_VkPhysicalDeviceMultiviewFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceMultiviewFeatures*>(structExtension), reinterpret_cast<VkPhysicalDeviceMultiviewFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES:
        {
            deepcopy_VkPhysicalDeviceMultiviewProperties(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceMultiviewProperties*>(structExtension), reinterpret_cast<VkPhysicalDeviceMultiviewProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
        {
            deepcopy_VkPhysicalDeviceVariablePointersFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceVariablePointersFeatures*>(structExtension), reinterpret_cast<VkPhysicalDeviceVariablePointersFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
        {
            deepcopy_VkPhysicalDeviceProtectedMemoryFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceProtectedMemoryFeatures*>(structExtension), reinterpret_cast<VkPhysicalDeviceProtectedMemoryFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES:
        {
            deepcopy_VkPhysicalDeviceProtectedMemoryProperties(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceProtectedMemoryProperties*>(structExtension), reinterpret_cast<VkPhysicalDeviceProtectedMemoryProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO:
        {
            deepcopy_VkProtectedSubmitInfo(alloc, rootType, reinterpret_cast<const VkProtectedSubmitInfo*>(structExtension), reinterpret_cast<VkProtectedSubmitInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO:
        {
            deepcopy_VkSamplerYcbcrConversionInfo(alloc, rootType, reinterpret_cast<const VkSamplerYcbcrConversionInfo*>(structExtension), reinterpret_cast<VkSamplerYcbcrConversionInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO:
        {
            deepcopy_VkBindImagePlaneMemoryInfo(alloc, rootType, reinterpret_cast<const VkBindImagePlaneMemoryInfo*>(structExtension), reinterpret_cast<VkBindImagePlaneMemoryInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO:
        {
            deepcopy_VkImagePlaneMemoryRequirementsInfo(alloc, rootType, reinterpret_cast<const VkImagePlaneMemoryRequirementsInfo*>(structExtension), reinterpret_cast<VkImagePlaneMemoryRequirementsInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
        {
            deepcopy_VkPhysicalDeviceSamplerYcbcrConversionFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceSamplerYcbcrConversionFeatures*>(structExtension), reinterpret_cast<VkPhysicalDeviceSamplerYcbcrConversionFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES:
        {
            deepcopy_VkSamplerYcbcrConversionImageFormatProperties(alloc, rootType, reinterpret_cast<const VkSamplerYcbcrConversionImageFormatProperties*>(structExtension), reinterpret_cast<VkSamplerYcbcrConversionImageFormatProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO:
        {
            deepcopy_VkPhysicalDeviceExternalImageFormatInfo(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceExternalImageFormatInfo*>(structExtension), reinterpret_cast<VkPhysicalDeviceExternalImageFormatInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES:
        {
            deepcopy_VkExternalImageFormatProperties(alloc, rootType, reinterpret_cast<const VkExternalImageFormatProperties*>(structExtension), reinterpret_cast<VkExternalImageFormatProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES:
        {
            deepcopy_VkPhysicalDeviceIDProperties(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceIDProperties*>(structExtension), reinterpret_cast<VkPhysicalDeviceIDProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO:
        {
            deepcopy_VkExternalMemoryImageCreateInfo(alloc, rootType, reinterpret_cast<const VkExternalMemoryImageCreateInfo*>(structExtension), reinterpret_cast<VkExternalMemoryImageCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO:
        {
            deepcopy_VkExternalMemoryBufferCreateInfo(alloc, rootType, reinterpret_cast<const VkExternalMemoryBufferCreateInfo*>(structExtension), reinterpret_cast<VkExternalMemoryBufferCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO:
        {
            deepcopy_VkExportMemoryAllocateInfo(alloc, rootType, reinterpret_cast<const VkExportMemoryAllocateInfo*>(structExtension), reinterpret_cast<VkExportMemoryAllocateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO:
        {
            deepcopy_VkExportFenceCreateInfo(alloc, rootType, reinterpret_cast<const VkExportFenceCreateInfo*>(structExtension), reinterpret_cast<VkExportFenceCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO:
        {
            deepcopy_VkExportSemaphoreCreateInfo(alloc, rootType, reinterpret_cast<const VkExportSemaphoreCreateInfo*>(structExtension), reinterpret_cast<VkExportSemaphoreCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES:
        {
            deepcopy_VkPhysicalDeviceMaintenance3Properties(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceMaintenance3Properties*>(structExtension), reinterpret_cast<VkPhysicalDeviceMaintenance3Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
        {
            deepcopy_VkPhysicalDeviceShaderDrawParametersFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceShaderDrawParametersFeatures*>(structExtension), reinterpret_cast<VkPhysicalDeviceShaderDrawParametersFeatures*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_VERSION_1_2
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
        {
            deepcopy_VkPhysicalDeviceVulkan11Features(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceVulkan11Features*>(structExtension), reinterpret_cast<VkPhysicalDeviceVulkan11Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES:
        {
            deepcopy_VkPhysicalDeviceVulkan11Properties(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceVulkan11Properties*>(structExtension), reinterpret_cast<VkPhysicalDeviceVulkan11Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
        {
            deepcopy_VkPhysicalDeviceVulkan12Features(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceVulkan12Features*>(structExtension), reinterpret_cast<VkPhysicalDeviceVulkan12Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES:
        {
            deepcopy_VkPhysicalDeviceVulkan12Properties(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceVulkan12Properties*>(structExtension), reinterpret_cast<VkPhysicalDeviceVulkan12Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO:
        {
            deepcopy_VkImageFormatListCreateInfo(alloc, rootType, reinterpret_cast<const VkImageFormatListCreateInfo*>(structExtension), reinterpret_cast<VkImageFormatListCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
        {
            deepcopy_VkPhysicalDevice8BitStorageFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDevice8BitStorageFeatures*>(structExtension), reinterpret_cast<VkPhysicalDevice8BitStorageFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES:
        {
            deepcopy_VkPhysicalDeviceDriverProperties(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceDriverProperties*>(structExtension), reinterpret_cast<VkPhysicalDeviceDriverProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
        {
            deepcopy_VkPhysicalDeviceShaderAtomicInt64Features(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceShaderAtomicInt64Features*>(structExtension), reinterpret_cast<VkPhysicalDeviceShaderAtomicInt64Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
        {
            deepcopy_VkPhysicalDeviceShaderFloat16Int8Features(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceShaderFloat16Int8Features*>(structExtension), reinterpret_cast<VkPhysicalDeviceShaderFloat16Int8Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES:
        {
            deepcopy_VkPhysicalDeviceFloatControlsProperties(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceFloatControlsProperties*>(structExtension), reinterpret_cast<VkPhysicalDeviceFloatControlsProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO:
        {
            deepcopy_VkDescriptorSetLayoutBindingFlagsCreateInfo(alloc, rootType, reinterpret_cast<const VkDescriptorSetLayoutBindingFlagsCreateInfo*>(structExtension), reinterpret_cast<VkDescriptorSetLayoutBindingFlagsCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
        {
            deepcopy_VkPhysicalDeviceDescriptorIndexingFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceDescriptorIndexingFeatures*>(structExtension), reinterpret_cast<VkPhysicalDeviceDescriptorIndexingFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES:
        {
            deepcopy_VkPhysicalDeviceDescriptorIndexingProperties(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceDescriptorIndexingProperties*>(structExtension), reinterpret_cast<VkPhysicalDeviceDescriptorIndexingProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO:
        {
            deepcopy_VkDescriptorSetVariableDescriptorCountAllocateInfo(alloc, rootType, reinterpret_cast<const VkDescriptorSetVariableDescriptorCountAllocateInfo*>(structExtension), reinterpret_cast<VkDescriptorSetVariableDescriptorCountAllocateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT:
        {
            deepcopy_VkDescriptorSetVariableDescriptorCountLayoutSupport(alloc, rootType, reinterpret_cast<const VkDescriptorSetVariableDescriptorCountLayoutSupport*>(structExtension), reinterpret_cast<VkDescriptorSetVariableDescriptorCountLayoutSupport*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE:
        {
            deepcopy_VkSubpassDescriptionDepthStencilResolve(alloc, rootType, reinterpret_cast<const VkSubpassDescriptionDepthStencilResolve*>(structExtension), reinterpret_cast<VkSubpassDescriptionDepthStencilResolve*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES:
        {
            deepcopy_VkPhysicalDeviceDepthStencilResolveProperties(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceDepthStencilResolveProperties*>(structExtension), reinterpret_cast<VkPhysicalDeviceDepthStencilResolveProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
        {
            deepcopy_VkPhysicalDeviceScalarBlockLayoutFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceScalarBlockLayoutFeatures*>(structExtension), reinterpret_cast<VkPhysicalDeviceScalarBlockLayoutFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO:
        {
            deepcopy_VkImageStencilUsageCreateInfo(alloc, rootType, reinterpret_cast<const VkImageStencilUsageCreateInfo*>(structExtension), reinterpret_cast<VkImageStencilUsageCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO:
        {
            deepcopy_VkSamplerReductionModeCreateInfo(alloc, rootType, reinterpret_cast<const VkSamplerReductionModeCreateInfo*>(structExtension), reinterpret_cast<VkSamplerReductionModeCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES:
        {
            deepcopy_VkPhysicalDeviceSamplerFilterMinmaxProperties(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceSamplerFilterMinmaxProperties*>(structExtension), reinterpret_cast<VkPhysicalDeviceSamplerFilterMinmaxProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
        {
            deepcopy_VkPhysicalDeviceVulkanMemoryModelFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceVulkanMemoryModelFeatures*>(structExtension), reinterpret_cast<VkPhysicalDeviceVulkanMemoryModelFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
        {
            deepcopy_VkPhysicalDeviceImagelessFramebufferFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceImagelessFramebufferFeatures*>(structExtension), reinterpret_cast<VkPhysicalDeviceImagelessFramebufferFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO:
        {
            deepcopy_VkFramebufferAttachmentsCreateInfo(alloc, rootType, reinterpret_cast<const VkFramebufferAttachmentsCreateInfo*>(structExtension), reinterpret_cast<VkFramebufferAttachmentsCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO:
        {
            deepcopy_VkRenderPassAttachmentBeginInfo(alloc, rootType, reinterpret_cast<const VkRenderPassAttachmentBeginInfo*>(structExtension), reinterpret_cast<VkRenderPassAttachmentBeginInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
        {
            deepcopy_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceUniformBufferStandardLayoutFeatures*>(structExtension), reinterpret_cast<VkPhysicalDeviceUniformBufferStandardLayoutFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
        {
            deepcopy_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures*>(structExtension), reinterpret_cast<VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
        {
            deepcopy_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures*>(structExtension), reinterpret_cast<VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT:
        {
            deepcopy_VkAttachmentReferenceStencilLayout(alloc, rootType, reinterpret_cast<const VkAttachmentReferenceStencilLayout*>(structExtension), reinterpret_cast<VkAttachmentReferenceStencilLayout*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT:
        {
            deepcopy_VkAttachmentDescriptionStencilLayout(alloc, rootType, reinterpret_cast<const VkAttachmentDescriptionStencilLayout*>(structExtension), reinterpret_cast<VkAttachmentDescriptionStencilLayout*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
        {
            deepcopy_VkPhysicalDeviceHostQueryResetFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceHostQueryResetFeatures*>(structExtension), reinterpret_cast<VkPhysicalDeviceHostQueryResetFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
        {
            deepcopy_VkPhysicalDeviceTimelineSemaphoreFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceTimelineSemaphoreFeatures*>(structExtension), reinterpret_cast<VkPhysicalDeviceTimelineSemaphoreFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES:
        {
            deepcopy_VkPhysicalDeviceTimelineSemaphoreProperties(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceTimelineSemaphoreProperties*>(structExtension), reinterpret_cast<VkPhysicalDeviceTimelineSemaphoreProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO:
        {
            deepcopy_VkSemaphoreTypeCreateInfo(alloc, rootType, reinterpret_cast<const VkSemaphoreTypeCreateInfo*>(structExtension), reinterpret_cast<VkSemaphoreTypeCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO:
        {
            deepcopy_VkTimelineSemaphoreSubmitInfo(alloc, rootType, reinterpret_cast<const VkTimelineSemaphoreSubmitInfo*>(structExtension), reinterpret_cast<VkTimelineSemaphoreSubmitInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
        {
            deepcopy_VkPhysicalDeviceBufferDeviceAddressFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceBufferDeviceAddressFeatures*>(structExtension), reinterpret_cast<VkPhysicalDeviceBufferDeviceAddressFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO:
        {
            deepcopy_VkBufferOpaqueCaptureAddressCreateInfo(alloc, rootType, reinterpret_cast<const VkBufferOpaqueCaptureAddressCreateInfo*>(structExtension), reinterpret_cast<VkBufferOpaqueCaptureAddressCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO:
        {
            deepcopy_VkMemoryOpaqueCaptureAddressAllocateInfo(alloc, rootType, reinterpret_cast<const VkMemoryOpaqueCaptureAddressAllocateInfo*>(structExtension), reinterpret_cast<VkMemoryOpaqueCaptureAddressAllocateInfo*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_VERSION_1_3
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
        {
            deepcopy_VkPhysicalDeviceVulkan13Features(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceVulkan13Features*>(structExtension), reinterpret_cast<VkPhysicalDeviceVulkan13Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES:
        {
            deepcopy_VkPhysicalDeviceVulkan13Properties(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceVulkan13Properties*>(structExtension), reinterpret_cast<VkPhysicalDeviceVulkan13Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO:
        {
            deepcopy_VkPipelineCreationFeedbackCreateInfo(alloc, rootType, reinterpret_cast<const VkPipelineCreationFeedbackCreateInfo*>(structExtension), reinterpret_cast<VkPipelineCreationFeedbackCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
        {
            deepcopy_VkPhysicalDeviceShaderTerminateInvocationFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceShaderTerminateInvocationFeatures*>(structExtension), reinterpret_cast<VkPhysicalDeviceShaderTerminateInvocationFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
        {
            deepcopy_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures*>(structExtension), reinterpret_cast<VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
        {
            deepcopy_VkPhysicalDevicePrivateDataFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDevicePrivateDataFeatures*>(structExtension), reinterpret_cast<VkPhysicalDevicePrivateDataFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO:
        {
            deepcopy_VkDevicePrivateDataCreateInfo(alloc, rootType, reinterpret_cast<const VkDevicePrivateDataCreateInfo*>(structExtension), reinterpret_cast<VkDevicePrivateDataCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
        {
            deepcopy_VkPhysicalDevicePipelineCreationCacheControlFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDevicePipelineCreationCacheControlFeatures*>(structExtension), reinterpret_cast<VkPhysicalDevicePipelineCreationCacheControlFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_BARRIER_2:
        {
            deepcopy_VkMemoryBarrier2(alloc, rootType, reinterpret_cast<const VkMemoryBarrier2*>(structExtension), reinterpret_cast<VkMemoryBarrier2*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
        {
            deepcopy_VkPhysicalDeviceSynchronization2Features(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceSynchronization2Features*>(structExtension), reinterpret_cast<VkPhysicalDeviceSynchronization2Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
        {
            deepcopy_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures*>(structExtension), reinterpret_cast<VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
        {
            deepcopy_VkPhysicalDeviceImageRobustnessFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceImageRobustnessFeatures*>(structExtension), reinterpret_cast<VkPhysicalDeviceImageRobustnessFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
        {
            deepcopy_VkPhysicalDeviceSubgroupSizeControlFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceSubgroupSizeControlFeatures*>(structExtension), reinterpret_cast<VkPhysicalDeviceSubgroupSizeControlFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES:
        {
            deepcopy_VkPhysicalDeviceSubgroupSizeControlProperties(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceSubgroupSizeControlProperties*>(structExtension), reinterpret_cast<VkPhysicalDeviceSubgroupSizeControlProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO:
        {
            deepcopy_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo(alloc, rootType, reinterpret_cast<const VkPipelineShaderStageRequiredSubgroupSizeCreateInfo*>(structExtension), reinterpret_cast<VkPipelineShaderStageRequiredSubgroupSizeCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
        {
            deepcopy_VkPhysicalDeviceInlineUniformBlockFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceInlineUniformBlockFeatures*>(structExtension), reinterpret_cast<VkPhysicalDeviceInlineUniformBlockFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES:
        {
            deepcopy_VkPhysicalDeviceInlineUniformBlockProperties(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceInlineUniformBlockProperties*>(structExtension), reinterpret_cast<VkPhysicalDeviceInlineUniformBlockProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK:
        {
            deepcopy_VkWriteDescriptorSetInlineUniformBlock(alloc, rootType, reinterpret_cast<const VkWriteDescriptorSetInlineUniformBlock*>(structExtension), reinterpret_cast<VkWriteDescriptorSetInlineUniformBlock*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO:
        {
            deepcopy_VkDescriptorPoolInlineUniformBlockCreateInfo(alloc, rootType, reinterpret_cast<const VkDescriptorPoolInlineUniformBlockCreateInfo*>(structExtension), reinterpret_cast<VkDescriptorPoolInlineUniformBlockCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
        {
            deepcopy_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceTextureCompressionASTCHDRFeatures*>(structExtension), reinterpret_cast<VkPhysicalDeviceTextureCompressionASTCHDRFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO:
        {
            deepcopy_VkPipelineRenderingCreateInfo(alloc, rootType, reinterpret_cast<const VkPipelineRenderingCreateInfo*>(structExtension), reinterpret_cast<VkPipelineRenderingCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
        {
            deepcopy_VkPhysicalDeviceDynamicRenderingFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceDynamicRenderingFeatures*>(structExtension), reinterpret_cast<VkPhysicalDeviceDynamicRenderingFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO:
        {
            deepcopy_VkCommandBufferInheritanceRenderingInfo(alloc, rootType, reinterpret_cast<const VkCommandBufferInheritanceRenderingInfo*>(structExtension), reinterpret_cast<VkCommandBufferInheritanceRenderingInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
        {
            deepcopy_VkPhysicalDeviceShaderIntegerDotProductFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceShaderIntegerDotProductFeatures*>(structExtension), reinterpret_cast<VkPhysicalDeviceShaderIntegerDotProductFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES:
        {
            deepcopy_VkPhysicalDeviceShaderIntegerDotProductProperties(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceShaderIntegerDotProductProperties*>(structExtension), reinterpret_cast<VkPhysicalDeviceShaderIntegerDotProductProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES:
        {
            deepcopy_VkPhysicalDeviceTexelBufferAlignmentProperties(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceTexelBufferAlignmentProperties*>(structExtension), reinterpret_cast<VkPhysicalDeviceTexelBufferAlignmentProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3:
        {
            deepcopy_VkFormatProperties3(alloc, rootType, reinterpret_cast<const VkFormatProperties3*>(structExtension), reinterpret_cast<VkFormatProperties3*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
        {
            deepcopy_VkPhysicalDeviceMaintenance4Features(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceMaintenance4Features*>(structExtension), reinterpret_cast<VkPhysicalDeviceMaintenance4Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES:
        {
            deepcopy_VkPhysicalDeviceMaintenance4Properties(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceMaintenance4Properties*>(structExtension), reinterpret_cast<VkPhysicalDeviceMaintenance4Properties*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_VERSION_1_4
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES:
        {
            deepcopy_VkPhysicalDeviceVulkan14Features(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceVulkan14Features*>(structExtension), reinterpret_cast<VkPhysicalDeviceVulkan14Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_PROPERTIES:
        {
            deepcopy_VkPhysicalDeviceVulkan14Properties(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceVulkan14Properties*>(structExtension), reinterpret_cast<VkPhysicalDeviceVulkan14Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO:
        {
            deepcopy_VkDeviceQueueGlobalPriorityCreateInfo(alloc, rootType, reinterpret_cast<const VkDeviceQueueGlobalPriorityCreateInfo*>(structExtension), reinterpret_cast<VkDeviceQueueGlobalPriorityCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES:
        {
            deepcopy_VkPhysicalDeviceGlobalPriorityQueryFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceGlobalPriorityQueryFeatures*>(structExtension), reinterpret_cast<VkPhysicalDeviceGlobalPriorityQueryFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_QUEUE_FAMILY_GLOBAL_PRIORITY_PROPERTIES:
        {
            deepcopy_VkQueueFamilyGlobalPriorityProperties(alloc, rootType, reinterpret_cast<const VkQueueFamilyGlobalPriorityProperties*>(structExtension), reinterpret_cast<VkQueueFamilyGlobalPriorityProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_ROTATE_FEATURES:
        {
            deepcopy_VkPhysicalDeviceShaderSubgroupRotateFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceShaderSubgroupRotateFeatures*>(structExtension), reinterpret_cast<VkPhysicalDeviceShaderSubgroupRotateFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT_CONTROLS_2_FEATURES:
        {
            deepcopy_VkPhysicalDeviceShaderFloatControls2Features(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceShaderFloatControls2Features*>(structExtension), reinterpret_cast<VkPhysicalDeviceShaderFloatControls2Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EXPECT_ASSUME_FEATURES:
        {
            deepcopy_VkPhysicalDeviceShaderExpectAssumeFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceShaderExpectAssumeFeatures*>(structExtension), reinterpret_cast<VkPhysicalDeviceShaderExpectAssumeFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES:
        {
            deepcopy_VkPhysicalDeviceLineRasterizationFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceLineRasterizationFeatures*>(structExtension), reinterpret_cast<VkPhysicalDeviceLineRasterizationFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES:
        {
            deepcopy_VkPhysicalDeviceLineRasterizationProperties(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceLineRasterizationProperties*>(structExtension), reinterpret_cast<VkPhysicalDeviceLineRasterizationProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO:
        {
            deepcopy_VkPipelineRasterizationLineStateCreateInfo(alloc, rootType, reinterpret_cast<const VkPipelineRasterizationLineStateCreateInfo*>(structExtension), reinterpret_cast<VkPipelineRasterizationLineStateCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES:
        {
            deepcopy_VkPhysicalDeviceVertexAttributeDivisorProperties(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceVertexAttributeDivisorProperties*>(structExtension), reinterpret_cast<VkPhysicalDeviceVertexAttributeDivisorProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO:
        {
            deepcopy_VkPipelineVertexInputDivisorStateCreateInfo(alloc, rootType, reinterpret_cast<const VkPipelineVertexInputDivisorStateCreateInfo*>(structExtension), reinterpret_cast<VkPipelineVertexInputDivisorStateCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES:
        {
            deepcopy_VkPhysicalDeviceVertexAttributeDivisorFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceVertexAttributeDivisorFeatures*>(structExtension), reinterpret_cast<VkPhysicalDeviceVertexAttributeDivisorFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES:
        {
            deepcopy_VkPhysicalDeviceIndexTypeUint8Features(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceIndexTypeUint8Features*>(structExtension), reinterpret_cast<VkPhysicalDeviceIndexTypeUint8Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_FEATURES:
        {
            deepcopy_VkPhysicalDeviceMaintenance5Features(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceMaintenance5Features*>(structExtension), reinterpret_cast<VkPhysicalDeviceMaintenance5Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_PROPERTIES:
        {
            deepcopy_VkPhysicalDeviceMaintenance5Properties(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceMaintenance5Properties*>(structExtension), reinterpret_cast<VkPhysicalDeviceMaintenance5Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_CREATE_FLAGS_2_CREATE_INFO:
        {
            deepcopy_VkPipelineCreateFlags2CreateInfo(alloc, rootType, reinterpret_cast<const VkPipelineCreateFlags2CreateInfo*>(structExtension), reinterpret_cast<VkPipelineCreateFlags2CreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_BUFFER_USAGE_FLAGS_2_CREATE_INFO:
        {
            deepcopy_VkBufferUsageFlags2CreateInfo(alloc, rootType, reinterpret_cast<const VkBufferUsageFlags2CreateInfo*>(structExtension), reinterpret_cast<VkBufferUsageFlags2CreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES:
        {
            deepcopy_VkPhysicalDevicePushDescriptorProperties(alloc, rootType, reinterpret_cast<const VkPhysicalDevicePushDescriptorProperties*>(structExtension), reinterpret_cast<VkPhysicalDevicePushDescriptorProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_LOCAL_READ_FEATURES:
        {
            deepcopy_VkPhysicalDeviceDynamicRenderingLocalReadFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceDynamicRenderingLocalReadFeatures*>(structExtension), reinterpret_cast<VkPhysicalDeviceDynamicRenderingLocalReadFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_LOCATION_INFO:
        {
            deepcopy_VkRenderingAttachmentLocationInfo(alloc, rootType, reinterpret_cast<const VkRenderingAttachmentLocationInfo*>(structExtension), reinterpret_cast<VkRenderingAttachmentLocationInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDERING_INPUT_ATTACHMENT_INDEX_INFO:
        {
            deepcopy_VkRenderingInputAttachmentIndexInfo(alloc, rootType, reinterpret_cast<const VkRenderingInputAttachmentIndexInfo*>(structExtension), reinterpret_cast<VkRenderingInputAttachmentIndexInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_FEATURES:
        {
            deepcopy_VkPhysicalDeviceMaintenance6Features(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceMaintenance6Features*>(structExtension), reinterpret_cast<VkPhysicalDeviceMaintenance6Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_PROPERTIES:
        {
            deepcopy_VkPhysicalDeviceMaintenance6Properties(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceMaintenance6Properties*>(structExtension), reinterpret_cast<VkPhysicalDeviceMaintenance6Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_MEMORY_STATUS:
        {
            deepcopy_VkBindMemoryStatus(alloc, rootType, reinterpret_cast<const VkBindMemoryStatus*>(structExtension), reinterpret_cast<VkBindMemoryStatus*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES:
        {
            deepcopy_VkPhysicalDevicePipelineProtectedAccessFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDevicePipelineProtectedAccessFeatures*>(structExtension), reinterpret_cast<VkPhysicalDevicePipelineProtectedAccessFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES:
        {
            deepcopy_VkPhysicalDevicePipelineRobustnessFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDevicePipelineRobustnessFeatures*>(structExtension), reinterpret_cast<VkPhysicalDevicePipelineRobustnessFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_PROPERTIES:
        {
            deepcopy_VkPhysicalDevicePipelineRobustnessProperties(alloc, rootType, reinterpret_cast<const VkPhysicalDevicePipelineRobustnessProperties*>(structExtension), reinterpret_cast<VkPhysicalDevicePipelineRobustnessProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_ROBUSTNESS_CREATE_INFO:
        {
            deepcopy_VkPipelineRobustnessCreateInfo(alloc, rootType, reinterpret_cast<const VkPipelineRobustnessCreateInfo*>(structExtension), reinterpret_cast<VkPipelineRobustnessCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_FEATURES:
        {
            deepcopy_VkPhysicalDeviceHostImageCopyFeatures(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceHostImageCopyFeatures*>(structExtension), reinterpret_cast<VkPhysicalDeviceHostImageCopyFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_PROPERTIES:
        {
            deepcopy_VkPhysicalDeviceHostImageCopyProperties(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceHostImageCopyProperties*>(structExtension), reinterpret_cast<VkPhysicalDeviceHostImageCopyProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SUBRESOURCE_HOST_MEMCPY_SIZE:
        {
            deepcopy_VkSubresourceHostMemcpySize(alloc, rootType, reinterpret_cast<const VkSubresourceHostMemcpySize*>(structExtension), reinterpret_cast<VkSubresourceHostMemcpySize*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_HOST_IMAGE_COPY_DEVICE_PERFORMANCE_QUERY:
        {
            deepcopy_VkHostImageCopyDevicePerformanceQuery(alloc, rootType, reinterpret_cast<const VkHostImageCopyDevicePerformanceQuery*>(structExtension), reinterpret_cast<VkHostImageCopyDevicePerformanceQuery*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_KHR_incremental_present
        case VK_STRUCTURE_TYPE_PRESENT_REGIONS_KHR:
        {
            deepcopy_VkPresentRegionsKHR(alloc, rootType, reinterpret_cast<const VkPresentRegionsKHR*>(structExtension), reinterpret_cast<VkPresentRegionsKHR*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_KHR_pipeline_executable_properties
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR:
        {
            deepcopy_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR(alloc, rootType, reinterpret_cast<const VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR*>(structExtension), reinterpret_cast<VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_ANDROID_native_buffer
        case VK_STRUCTURE_TYPE_NATIVE_BUFFER_ANDROID:
        {
            deepcopy_VkNativeBufferANDROID(alloc, rootType, reinterpret_cast<const VkNativeBufferANDROID*>(structExtension), reinterpret_cast<VkNativeBufferANDROID*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SWAPCHAIN_IMAGE_CREATE_INFO_ANDROID:
        {
            deepcopy_VkSwapchainImageCreateInfoANDROID(alloc, rootType, reinterpret_cast<const VkSwapchainImageCreateInfoANDROID*>(structExtension), reinterpret_cast<VkSwapchainImageCreateInfoANDROID*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENTATION_PROPERTIES_ANDROID:
        {
            deepcopy_VkPhysicalDevicePresentationPropertiesANDROID(alloc, rootType, reinterpret_cast<const VkPhysicalDevicePresentationPropertiesANDROID*>(structExtension), reinterpret_cast<VkPhysicalDevicePresentationPropertiesANDROID*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_transform_feedback
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
        {
            deepcopy_VkPhysicalDeviceTransformFeedbackFeaturesEXT(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceTransformFeedbackFeaturesEXT*>(structExtension), reinterpret_cast<VkPhysicalDeviceTransformFeedbackFeaturesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT:
        {
            deepcopy_VkPhysicalDeviceTransformFeedbackPropertiesEXT(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceTransformFeedbackPropertiesEXT*>(structExtension), reinterpret_cast<VkPhysicalDeviceTransformFeedbackPropertiesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT:
        {
            deepcopy_VkPipelineRasterizationStateStreamCreateInfoEXT(alloc, rootType, reinterpret_cast<const VkPipelineRasterizationStateStreamCreateInfoEXT*>(structExtension), reinterpret_cast<VkPipelineRasterizationStateStreamCreateInfoEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_depth_clip_enable
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT:
        {
            deepcopy_VkPhysicalDeviceDepthClipEnableFeaturesEXT(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceDepthClipEnableFeaturesEXT*>(structExtension), reinterpret_cast<VkPhysicalDeviceDepthClipEnableFeaturesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT:
        {
            deepcopy_VkPipelineRasterizationDepthClipStateCreateInfoEXT(alloc, rootType, reinterpret_cast<const VkPipelineRasterizationDepthClipStateCreateInfoEXT*>(structExtension), reinterpret_cast<VkPipelineRasterizationDepthClipStateCreateInfoEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_image_drm_format_modifier
        case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT:
        {
            deepcopy_VkDrmFormatModifierPropertiesListEXT(alloc, rootType, reinterpret_cast<const VkDrmFormatModifierPropertiesListEXT*>(structExtension), reinterpret_cast<VkDrmFormatModifierPropertiesListEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT:
        {
            deepcopy_VkPhysicalDeviceImageDrmFormatModifierInfoEXT(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceImageDrmFormatModifierInfoEXT*>(structExtension), reinterpret_cast<VkPhysicalDeviceImageDrmFormatModifierInfoEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT:
        {
            deepcopy_VkImageDrmFormatModifierListCreateInfoEXT(alloc, rootType, reinterpret_cast<const VkImageDrmFormatModifierListCreateInfoEXT*>(structExtension), reinterpret_cast<VkImageDrmFormatModifierListCreateInfoEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT:
        {
            deepcopy_VkImageDrmFormatModifierExplicitCreateInfoEXT(alloc, rootType, reinterpret_cast<const VkImageDrmFormatModifierExplicitCreateInfoEXT*>(structExtension), reinterpret_cast<VkImageDrmFormatModifierExplicitCreateInfoEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT:
        {
            deepcopy_VkDrmFormatModifierPropertiesList2EXT(alloc, rootType, reinterpret_cast<const VkDrmFormatModifierPropertiesList2EXT*>(structExtension), reinterpret_cast<VkDrmFormatModifierPropertiesList2EXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_vertex_attribute_divisor
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT:
        {
            deepcopy_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT*>(structExtension), reinterpret_cast<VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_fragment_density_map
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT:
        {
            switch(rootType)
            {
                case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2:
                {
                    deepcopy_VkPhysicalDeviceFragmentDensityMapFeaturesEXT(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceFragmentDensityMapFeaturesEXT*>(structExtension), reinterpret_cast<VkPhysicalDeviceFragmentDensityMapFeaturesEXT*>(structExtension_out));
                    break;
                }
                case VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO:
                {
                    deepcopy_VkPhysicalDeviceFragmentDensityMapFeaturesEXT(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceFragmentDensityMapFeaturesEXT*>(structExtension), reinterpret_cast<VkPhysicalDeviceFragmentDensityMapFeaturesEXT*>(structExtension_out));
                    break;
                }
                case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO:
                {
                    deepcopy_VkImportColorBufferGOOGLE(alloc, rootType, reinterpret_cast<const VkImportColorBufferGOOGLE*>(structExtension), reinterpret_cast<VkImportColorBufferGOOGLE*>(structExtension_out));
                    break;
                }
                default:
                {
                    deepcopy_VkPhysicalDeviceFragmentDensityMapFeaturesEXT(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceFragmentDensityMapFeaturesEXT*>(structExtension), reinterpret_cast<VkPhysicalDeviceFragmentDensityMapFeaturesEXT*>(structExtension_out));
                    break;
                }
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_PROPERTIES_EXT:
        {
            switch(rootType)
            {
                case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2:
                {
                    deepcopy_VkPhysicalDeviceFragmentDensityMapPropertiesEXT(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceFragmentDensityMapPropertiesEXT*>(structExtension), reinterpret_cast<VkPhysicalDeviceFragmentDensityMapPropertiesEXT*>(structExtension_out));
                    break;
                }
                case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO:
                {
                    deepcopy_VkCreateBlobGOOGLE(alloc, rootType, reinterpret_cast<const VkCreateBlobGOOGLE*>(structExtension), reinterpret_cast<VkCreateBlobGOOGLE*>(structExtension_out));
                    break;
                }
                default:
                {
                    deepcopy_VkPhysicalDeviceFragmentDensityMapPropertiesEXT(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceFragmentDensityMapPropertiesEXT*>(structExtension), reinterpret_cast<VkPhysicalDeviceFragmentDensityMapPropertiesEXT*>(structExtension_out));
                    break;
                }
            }
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT:
        {
            switch(rootType)
            {
                case VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO:
                {
                    deepcopy_VkRenderPassFragmentDensityMapCreateInfoEXT(alloc, rootType, reinterpret_cast<const VkRenderPassFragmentDensityMapCreateInfoEXT*>(structExtension), reinterpret_cast<VkRenderPassFragmentDensityMapCreateInfoEXT*>(structExtension_out));
                    break;
                }
                case VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2:
                {
                    deepcopy_VkRenderPassFragmentDensityMapCreateInfoEXT(alloc, rootType, reinterpret_cast<const VkRenderPassFragmentDensityMapCreateInfoEXT*>(structExtension), reinterpret_cast<VkRenderPassFragmentDensityMapCreateInfoEXT*>(structExtension_out));
                    break;
                }
                case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO:
                {
                    deepcopy_VkImportBufferGOOGLE(alloc, rootType, reinterpret_cast<const VkImportBufferGOOGLE*>(structExtension), reinterpret_cast<VkImportBufferGOOGLE*>(structExtension_out));
                    break;
                }
                default:
                {
                    deepcopy_VkRenderPassFragmentDensityMapCreateInfoEXT(alloc, rootType, reinterpret_cast<const VkRenderPassFragmentDensityMapCreateInfoEXT*>(structExtension), reinterpret_cast<VkRenderPassFragmentDensityMapCreateInfoEXT*>(structExtension_out));
                    break;
                }
            }
            break;
        }
        case VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_INFO_EXT:
        {
            deepcopy_VkRenderingFragmentDensityMapAttachmentInfoEXT(alloc, rootType, reinterpret_cast<const VkRenderingFragmentDensityMapAttachmentInfoEXT*>(structExtension), reinterpret_cast<VkRenderingFragmentDensityMapAttachmentInfoEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_memory_budget
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT:
        {
            deepcopy_VkPhysicalDeviceMemoryBudgetPropertiesEXT(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceMemoryBudgetPropertiesEXT*>(structExtension), reinterpret_cast<VkPhysicalDeviceMemoryBudgetPropertiesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_provoking_vertex
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT:
        {
            deepcopy_VkPhysicalDeviceProvokingVertexFeaturesEXT(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceProvokingVertexFeaturesEXT*>(structExtension), reinterpret_cast<VkPhysicalDeviceProvokingVertexFeaturesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT:
        {
            deepcopy_VkPhysicalDeviceProvokingVertexPropertiesEXT(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceProvokingVertexPropertiesEXT*>(structExtension), reinterpret_cast<VkPhysicalDeviceProvokingVertexPropertiesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT:
        {
            deepcopy_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT(alloc, rootType, reinterpret_cast<const VkPipelineRasterizationProvokingVertexStateCreateInfoEXT*>(structExtension), reinterpret_cast<VkPipelineRasterizationProvokingVertexStateCreateInfoEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_extended_dynamic_state
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
        {
            deepcopy_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT*>(structExtension), reinterpret_cast<VkPhysicalDeviceExtendedDynamicStateFeaturesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_texel_buffer_alignment
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
        {
            deepcopy_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT*>(structExtension), reinterpret_cast<VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_device_memory_report
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT:
        {
            deepcopy_VkPhysicalDeviceDeviceMemoryReportFeaturesEXT(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceDeviceMemoryReportFeaturesEXT*>(structExtension), reinterpret_cast<VkPhysicalDeviceDeviceMemoryReportFeaturesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT:
        {
            deepcopy_VkDeviceDeviceMemoryReportCreateInfoEXT(alloc, rootType, reinterpret_cast<const VkDeviceDeviceMemoryReportCreateInfoEXT*>(structExtension), reinterpret_cast<VkDeviceDeviceMemoryReportCreateInfoEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_custom_border_color
        case VK_STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT:
        {
            deepcopy_VkSamplerCustomBorderColorCreateInfoEXT(alloc, rootType, reinterpret_cast<const VkSamplerCustomBorderColorCreateInfoEXT*>(structExtension), reinterpret_cast<VkSamplerCustomBorderColorCreateInfoEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT:
        {
            deepcopy_VkPhysicalDeviceCustomBorderColorPropertiesEXT(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceCustomBorderColorPropertiesEXT*>(structExtension), reinterpret_cast<VkPhysicalDeviceCustomBorderColorPropertiesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT:
        {
            deepcopy_VkPhysicalDeviceCustomBorderColorFeaturesEXT(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceCustomBorderColorFeaturesEXT*>(structExtension), reinterpret_cast<VkPhysicalDeviceCustomBorderColorFeaturesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_graphics_pipeline_library
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT:
        {
            deepcopy_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT*>(structExtension), reinterpret_cast<VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_PROPERTIES_EXT:
        {
            deepcopy_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT*>(structExtension), reinterpret_cast<VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_LIBRARY_CREATE_INFO_EXT:
        {
            deepcopy_VkGraphicsPipelineLibraryCreateInfoEXT(alloc, rootType, reinterpret_cast<const VkGraphicsPipelineLibraryCreateInfoEXT*>(structExtension), reinterpret_cast<VkGraphicsPipelineLibraryCreateInfoEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_ycbcr_2plane_444_formats
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
        {
            deepcopy_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT*>(structExtension), reinterpret_cast<VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_image_compression_control
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_FEATURES_EXT:
        {
            deepcopy_VkPhysicalDeviceImageCompressionControlFeaturesEXT(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceImageCompressionControlFeaturesEXT*>(structExtension), reinterpret_cast<VkPhysicalDeviceImageCompressionControlFeaturesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_CONTROL_EXT:
        {
            deepcopy_VkImageCompressionControlEXT(alloc, rootType, reinterpret_cast<const VkImageCompressionControlEXT*>(structExtension), reinterpret_cast<VkImageCompressionControlEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_PROPERTIES_EXT:
        {
            deepcopy_VkImageCompressionPropertiesEXT(alloc, rootType, reinterpret_cast<const VkImageCompressionPropertiesEXT*>(structExtension), reinterpret_cast<VkImageCompressionPropertiesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_4444_formats
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
        {
            deepcopy_VkPhysicalDevice4444FormatsFeaturesEXT(alloc, rootType, reinterpret_cast<const VkPhysicalDevice4444FormatsFeaturesEXT*>(structExtension), reinterpret_cast<VkPhysicalDevice4444FormatsFeaturesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_primitive_topology_list_restart
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT:
        {
            deepcopy_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT(alloc, rootType, reinterpret_cast<const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT*>(structExtension), reinterpret_cast<VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_extended_dynamic_state2
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
        {
            deepcopy_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT*>(structExtension), reinterpret_cast<VkPhysicalDeviceExtendedDynamicState2FeaturesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_color_write_enable
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT:
        {
            deepcopy_VkPhysicalDeviceColorWriteEnableFeaturesEXT(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceColorWriteEnableFeaturesEXT*>(structExtension), reinterpret_cast<VkPhysicalDeviceColorWriteEnableFeaturesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_COLOR_WRITE_CREATE_INFO_EXT:
        {
            deepcopy_VkPipelineColorWriteCreateInfoEXT(alloc, rootType, reinterpret_cast<const VkPipelineColorWriteCreateInfoEXT*>(structExtension), reinterpret_cast<VkPipelineColorWriteCreateInfoEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_GOOGLE_gfxstream
        case VK_STRUCTURE_TYPE_IMPORT_COLOR_BUFFER_GOOGLE:
        {
            deepcopy_VkImportColorBufferGOOGLE(alloc, rootType, reinterpret_cast<const VkImportColorBufferGOOGLE*>(structExtension), reinterpret_cast<VkImportColorBufferGOOGLE*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMPORT_BUFFER_GOOGLE:
        {
            deepcopy_VkImportBufferGOOGLE(alloc, rootType, reinterpret_cast<const VkImportBufferGOOGLE*>(structExtension), reinterpret_cast<VkImportBufferGOOGLE*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_CREATE_BLOB_GOOGLE:
        {
            deepcopy_VkCreateBlobGOOGLE(alloc, rootType, reinterpret_cast<const VkCreateBlobGOOGLE*>(structExtension), reinterpret_cast<VkCreateBlobGOOGLE*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_image_compression_control_swapchain
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_SWAPCHAIN_FEATURES_EXT:
        {
            deepcopy_VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT(alloc, rootType, reinterpret_cast<const VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT*>(structExtension), reinterpret_cast<VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT*>(structExtension_out));
            break;
        }
#endif
        default:
        {
            return;
        }
    }
}


}  // namespace vk
}  // namespace gfxstream
