#[doc(hidden)] // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:229
macro_rules! isle_assembler_methods {
    () => {
        fn x64_pabsb_a_raw(&mut self, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pabsb_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpabsb_a_raw(&mut self, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpabsb_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pabsw_a_raw(&mut self, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pabsw_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpabsw_a_raw(&mut self, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpabsw_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pabsd_a_raw(&mut self, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pabsd_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpabsd_a_raw(&mut self, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpabsd_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpabsd_c_raw(&mut self, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpabsd_c::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpabsq_c_raw(&mut self, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpabsq_c::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_addb_i_raw(&mut self, al: Gpr, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let al = self.convert_gpr_to_assembler_fixed_read_write_gpr(al); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::addb_i::new(al.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = al.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_addw_i_raw(&mut self, ax: Gpr, imm16: u16) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let ax = self.convert_gpr_to_assembler_fixed_read_write_gpr(ax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm16 = cranelift_assembler_x64::Imm16::new(imm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::addw_i::new(ax.clone(), imm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = ax.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_addl_i_raw(&mut self, eax: Gpr, imm32: u32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let eax = self.convert_gpr_to_assembler_fixed_read_write_gpr(eax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Imm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::addl_i::new(eax.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = eax.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_addq_i_sxl_raw(&mut self, rax: Gpr, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rax = self.convert_gpr_to_assembler_fixed_read_write_gpr(rax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::addq_i_sxl::new(rax.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = rax.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_addb_mi_raw(&mut self, rm8: &GprMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm8 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::addb_mi::new(rm8.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm8 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_addw_mi_raw(&mut self, rm16: &GprMem, imm16: u16) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm16 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm16 = cranelift_assembler_x64::Imm16::new(imm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::addw_mi::new(rm16.clone(), imm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm16 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_addl_mi_raw(&mut self, rm32: &GprMem, imm32: u32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Imm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::addl_mi::new(rm32.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm32 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_addq_mi_sxl_raw(&mut self, rm64: &GprMem, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm64 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::addq_mi_sxl::new(rm64.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm64 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_addl_mi_sxb_raw(&mut self, rm32: &GprMem, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::addl_mi_sxb::new(rm32.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm32 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_addq_mi_sxb_raw(&mut self, rm64: &GprMem, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm64 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::addq_mi_sxb::new(rm64.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm64 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_addb_mr_raw(&mut self, rm8: &GprMem, r8: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm8 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r8 = cranelift_assembler_x64::Gpr::new(r8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::addb_mr::new(rm8.clone(), r8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm8 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_addw_mr_raw(&mut self, rm16: &GprMem, r16: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm16 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r16 = cranelift_assembler_x64::Gpr::new(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::addw_mr::new(rm16.clone(), r16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm16 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_addl_mr_raw(&mut self, rm32: &GprMem, r32: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r32 = cranelift_assembler_x64::Gpr::new(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::addl_mr::new(rm32.clone(), r32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm32 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_addq_mr_raw(&mut self, rm64: &GprMem, r64: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm64 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r64 = cranelift_assembler_x64::Gpr::new(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::addq_mr::new(rm64.clone(), r64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm64 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_addb_rm_raw(&mut self, r8: Gpr, rm8: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r8 = self.convert_gpr_to_assembler_read_write_gpr(r8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm8 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::addb_rm::new(r8.clone(), rm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r8.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_addw_rm_raw(&mut self, r16: Gpr, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = self.convert_gpr_to_assembler_read_write_gpr(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::addw_rm::new(r16.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_addl_rm_raw(&mut self, r32: Gpr, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = self.convert_gpr_to_assembler_read_write_gpr(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::addl_rm::new(r32.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_addq_rm_raw(&mut self, r64: Gpr, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = self.convert_gpr_to_assembler_read_write_gpr(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::addq_rm::new(r64.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_adcb_i_raw(&mut self, al: Gpr, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let al = self.convert_gpr_to_assembler_fixed_read_write_gpr(al); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::adcb_i::new(al.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = al.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_adcw_i_raw(&mut self, ax: Gpr, imm16: u16) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let ax = self.convert_gpr_to_assembler_fixed_read_write_gpr(ax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm16 = cranelift_assembler_x64::Imm16::new(imm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::adcw_i::new(ax.clone(), imm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = ax.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_adcl_i_raw(&mut self, eax: Gpr, imm32: u32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let eax = self.convert_gpr_to_assembler_fixed_read_write_gpr(eax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Imm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::adcl_i::new(eax.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = eax.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_adcq_i_sxl_raw(&mut self, rax: Gpr, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rax = self.convert_gpr_to_assembler_fixed_read_write_gpr(rax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::adcq_i_sxl::new(rax.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = rax.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_adcb_mi_raw(&mut self, rm8: &GprMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm8 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::adcb_mi::new(rm8.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm8 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_adcw_mi_raw(&mut self, rm16: &GprMem, imm16: u16) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm16 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm16 = cranelift_assembler_x64::Imm16::new(imm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::adcw_mi::new(rm16.clone(), imm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm16 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_adcl_mi_raw(&mut self, rm32: &GprMem, imm32: u32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Imm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::adcl_mi::new(rm32.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm32 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_adcq_mi_sxl_raw(&mut self, rm64: &GprMem, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm64 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::adcq_mi_sxl::new(rm64.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm64 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_adcl_mi_sxb_raw(&mut self, rm32: &GprMem, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::adcl_mi_sxb::new(rm32.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm32 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_adcq_mi_sxb_raw(&mut self, rm64: &GprMem, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm64 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::adcq_mi_sxb::new(rm64.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm64 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_adcb_mr_raw(&mut self, rm8: &GprMem, r8: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm8 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r8 = cranelift_assembler_x64::Gpr::new(r8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::adcb_mr::new(rm8.clone(), r8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm8 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_adcw_mr_raw(&mut self, rm16: &GprMem, r16: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm16 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r16 = cranelift_assembler_x64::Gpr::new(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::adcw_mr::new(rm16.clone(), r16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm16 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_adcl_mr_raw(&mut self, rm32: &GprMem, r32: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r32 = cranelift_assembler_x64::Gpr::new(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::adcl_mr::new(rm32.clone(), r32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm32 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_adcq_mr_raw(&mut self, rm64: &GprMem, r64: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm64 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r64 = cranelift_assembler_x64::Gpr::new(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::adcq_mr::new(rm64.clone(), r64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm64 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_adcb_rm_raw(&mut self, r8: Gpr, rm8: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r8 = self.convert_gpr_to_assembler_read_write_gpr(r8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm8 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::adcb_rm::new(r8.clone(), rm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r8.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_adcw_rm_raw(&mut self, r16: Gpr, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = self.convert_gpr_to_assembler_read_write_gpr(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::adcw_rm::new(r16.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_adcl_rm_raw(&mut self, r32: Gpr, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = self.convert_gpr_to_assembler_read_write_gpr(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::adcl_rm::new(r32.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_adcq_rm_raw(&mut self, r64: Gpr, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = self.convert_gpr_to_assembler_read_write_gpr(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::adcq_rm::new(r64.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_lock_addb_mi_raw(&mut self, m8: &SyntheticAmode, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m8 = self.convert_amode_to_assembler_amode(m8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_addb_mi::new(m8.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_addw_mi_raw(&mut self, m16: &SyntheticAmode, imm16: u16) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m16 = self.convert_amode_to_assembler_amode(m16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm16 = cranelift_assembler_x64::Imm16::new(imm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_addw_mi::new(m16.clone(), imm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_addl_mi_raw(&mut self, m32: &SyntheticAmode, imm32: u32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m32 = self.convert_amode_to_assembler_amode(m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Imm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_addl_mi::new(m32.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_addq_mi_sxl_raw(&mut self, m64: &SyntheticAmode, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m64 = self.convert_amode_to_assembler_amode(m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_addq_mi_sxl::new(m64.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_addl_mi_sxb_raw(&mut self, m32: &SyntheticAmode, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m32 = self.convert_amode_to_assembler_amode(m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_addl_mi_sxb::new(m32.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_addq_mi_sxb_raw(&mut self, m64: &SyntheticAmode, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m64 = self.convert_amode_to_assembler_amode(m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_addq_mi_sxb::new(m64.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_addb_mr_raw(&mut self, m8: &SyntheticAmode, r8: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m8 = self.convert_amode_to_assembler_amode(m8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r8 = cranelift_assembler_x64::Gpr::new(r8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_addb_mr::new(m8.clone(), r8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_addw_mr_raw(&mut self, m16: &SyntheticAmode, r16: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m16 = self.convert_amode_to_assembler_amode(m16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r16 = cranelift_assembler_x64::Gpr::new(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_addw_mr::new(m16.clone(), r16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_addl_mr_raw(&mut self, m32: &SyntheticAmode, r32: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m32 = self.convert_amode_to_assembler_amode(m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r32 = cranelift_assembler_x64::Gpr::new(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_addl_mr::new(m32.clone(), r32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_addq_mr_raw(&mut self, m64: &SyntheticAmode, r64: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m64 = self.convert_amode_to_assembler_amode(m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r64 = cranelift_assembler_x64::Gpr::new(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_addq_mr::new(m64.clone(), r64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_adcb_mi_raw(&mut self, m8: &SyntheticAmode, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m8 = self.convert_amode_to_assembler_amode(m8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_adcb_mi::new(m8.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_adcw_mi_raw(&mut self, m16: &SyntheticAmode, imm16: u16) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m16 = self.convert_amode_to_assembler_amode(m16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm16 = cranelift_assembler_x64::Imm16::new(imm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_adcw_mi::new(m16.clone(), imm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_adcl_mi_raw(&mut self, m32: &SyntheticAmode, imm32: u32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m32 = self.convert_amode_to_assembler_amode(m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Imm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_adcl_mi::new(m32.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_adcq_mi_sxl_raw(&mut self, m64: &SyntheticAmode, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m64 = self.convert_amode_to_assembler_amode(m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_adcq_mi_sxl::new(m64.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_adcl_mi_sxb_raw(&mut self, m32: &SyntheticAmode, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m32 = self.convert_amode_to_assembler_amode(m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_adcl_mi_sxb::new(m32.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_adcq_mi_sxb_raw(&mut self, m64: &SyntheticAmode, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m64 = self.convert_amode_to_assembler_amode(m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_adcq_mi_sxb::new(m64.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_adcb_mr_raw(&mut self, m8: &SyntheticAmode, r8: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m8 = self.convert_amode_to_assembler_amode(m8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r8 = cranelift_assembler_x64::Gpr::new(r8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_adcb_mr::new(m8.clone(), r8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_adcw_mr_raw(&mut self, m16: &SyntheticAmode, r16: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m16 = self.convert_amode_to_assembler_amode(m16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r16 = cranelift_assembler_x64::Gpr::new(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_adcw_mr::new(m16.clone(), r16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_adcl_mr_raw(&mut self, m32: &SyntheticAmode, r32: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m32 = self.convert_amode_to_assembler_amode(m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r32 = cranelift_assembler_x64::Gpr::new(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_adcl_mr::new(m32.clone(), r32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_adcq_mr_raw(&mut self, m64: &SyntheticAmode, r64: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m64 = self.convert_amode_to_assembler_amode(m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r64 = cranelift_assembler_x64::Gpr::new(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_adcq_mr::new(m64.clone(), r64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_xaddb_mr_raw(&mut self, m8: &SyntheticAmode, r8: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m8 = self.convert_amode_to_assembler_amode(m8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r8 = self.convert_gpr_to_assembler_read_write_gpr(r8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_xaddb_mr::new(m8.clone(), r8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r8.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:201
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_lock_xaddw_mr_raw(&mut self, m16: &SyntheticAmode, r16: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m16 = self.convert_amode_to_assembler_amode(m16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r16 = self.convert_gpr_to_assembler_read_write_gpr(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_xaddw_mr::new(m16.clone(), r16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:201
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_lock_xaddl_mr_raw(&mut self, m32: &SyntheticAmode, r32: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m32 = self.convert_amode_to_assembler_amode(m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r32 = self.convert_gpr_to_assembler_read_write_gpr(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_xaddl_mr::new(m32.clone(), r32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:201
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_lock_xaddq_mr_raw(&mut self, m64: &SyntheticAmode, r64: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m64 = self.convert_amode_to_assembler_amode(m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r64 = self.convert_gpr_to_assembler_read_write_gpr(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_xaddq_mr::new(m64.clone(), r64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:201
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_addss_a_raw(&mut self, xmm1: Xmm, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::addss_a::new(xmm1.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_addsd_a_raw(&mut self, xmm1: Xmm, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::addsd_a::new(xmm1.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_addps_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::addps_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_addpd_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::addpd_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_paddb_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::paddb_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_paddw_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::paddw_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_paddd_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::paddd_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_paddq_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::paddq_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_paddsb_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::paddsb_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_paddsw_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::paddsw_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_paddusb_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::paddusb_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_paddusw_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::paddusw_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_phaddw_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::phaddw_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_phaddd_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::phaddd_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vaddss_b_raw(&mut self, xmm2: Xmm, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vaddss_b::new(xmm1.clone(), xmm2.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vaddsd_b_raw(&mut self, xmm2: Xmm, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vaddsd_b::new(xmm1.clone(), xmm2.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vaddps_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vaddps_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vaddpd_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vaddpd_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpaddb_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpaddb_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpaddw_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpaddw_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpaddd_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpaddd_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpaddq_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpaddq_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpaddsb_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpaddsb_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpaddsw_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpaddsw_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpaddusb_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpaddusb_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpaddusw_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpaddusw_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vphaddw_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vphaddw_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vphaddd_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vphaddd_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vaddpd_c_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vaddpd_c::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_palignr_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::palignr_a::new(xmm1.clone(), xmm_m128.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpalignr_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpalignr_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_andb_i_raw(&mut self, al: Gpr, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let al = self.convert_gpr_to_assembler_fixed_read_write_gpr(al); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::andb_i::new(al.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = al.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_andw_i_raw(&mut self, ax: Gpr, imm16: u16) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let ax = self.convert_gpr_to_assembler_fixed_read_write_gpr(ax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm16 = cranelift_assembler_x64::Imm16::new(imm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::andw_i::new(ax.clone(), imm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = ax.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_andl_i_raw(&mut self, eax: Gpr, imm32: u32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let eax = self.convert_gpr_to_assembler_fixed_read_write_gpr(eax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Imm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::andl_i::new(eax.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = eax.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_andq_i_sxl_raw(&mut self, rax: Gpr, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rax = self.convert_gpr_to_assembler_fixed_read_write_gpr(rax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::andq_i_sxl::new(rax.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = rax.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_andb_mi_raw(&mut self, rm8: &GprMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm8 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::andb_mi::new(rm8.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm8 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_andw_mi_raw(&mut self, rm16: &GprMem, imm16: u16) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm16 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm16 = cranelift_assembler_x64::Imm16::new(imm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::andw_mi::new(rm16.clone(), imm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm16 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_andl_mi_raw(&mut self, rm32: &GprMem, imm32: u32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Imm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::andl_mi::new(rm32.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm32 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_andq_mi_sxl_raw(&mut self, rm64: &GprMem, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm64 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::andq_mi_sxl::new(rm64.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm64 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_andl_mi_sxb_raw(&mut self, rm32: &GprMem, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::andl_mi_sxb::new(rm32.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm32 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_andq_mi_sxb_raw(&mut self, rm64: &GprMem, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm64 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::andq_mi_sxb::new(rm64.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm64 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_andb_mr_raw(&mut self, rm8: &GprMem, r8: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm8 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r8 = cranelift_assembler_x64::Gpr::new(r8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::andb_mr::new(rm8.clone(), r8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm8 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_andw_mr_raw(&mut self, rm16: &GprMem, r16: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm16 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r16 = cranelift_assembler_x64::Gpr::new(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::andw_mr::new(rm16.clone(), r16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm16 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_andl_mr_raw(&mut self, rm32: &GprMem, r32: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r32 = cranelift_assembler_x64::Gpr::new(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::andl_mr::new(rm32.clone(), r32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm32 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_andq_mr_raw(&mut self, rm64: &GprMem, r64: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm64 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r64 = cranelift_assembler_x64::Gpr::new(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::andq_mr::new(rm64.clone(), r64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm64 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_andb_rm_raw(&mut self, r8: Gpr, rm8: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r8 = self.convert_gpr_to_assembler_read_write_gpr(r8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm8 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::andb_rm::new(r8.clone(), rm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r8.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_andw_rm_raw(&mut self, r16: Gpr, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = self.convert_gpr_to_assembler_read_write_gpr(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::andw_rm::new(r16.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_andl_rm_raw(&mut self, r32: Gpr, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = self.convert_gpr_to_assembler_read_write_gpr(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::andl_rm::new(r32.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_andq_rm_raw(&mut self, r64: Gpr, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = self.convert_gpr_to_assembler_read_write_gpr(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::andq_rm::new(r64.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_andnl_rvm_raw(&mut self, r32b: Gpr, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32a = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r32b = cranelift_assembler_x64::Gpr::new(r32b); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::andnl_rvm::new(r32a.clone(), r32b.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32a.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_andnq_rvm_raw(&mut self, r64b: Gpr, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64a = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r64b = cranelift_assembler_x64::Gpr::new(r64b); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::andnq_rvm::new(r64a.clone(), r64b.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64a.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_lock_andb_mi_raw(&mut self, m8: &SyntheticAmode, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m8 = self.convert_amode_to_assembler_amode(m8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_andb_mi::new(m8.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_andw_mi_raw(&mut self, m16: &SyntheticAmode, imm16: u16) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m16 = self.convert_amode_to_assembler_amode(m16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm16 = cranelift_assembler_x64::Imm16::new(imm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_andw_mi::new(m16.clone(), imm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_andl_mi_raw(&mut self, m32: &SyntheticAmode, imm32: u32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m32 = self.convert_amode_to_assembler_amode(m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Imm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_andl_mi::new(m32.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_andq_mi_sxl_raw(&mut self, m64: &SyntheticAmode, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m64 = self.convert_amode_to_assembler_amode(m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_andq_mi_sxl::new(m64.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_andl_mi_sxb_raw(&mut self, m32: &SyntheticAmode, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m32 = self.convert_amode_to_assembler_amode(m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_andl_mi_sxb::new(m32.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_andq_mi_sxb_raw(&mut self, m64: &SyntheticAmode, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m64 = self.convert_amode_to_assembler_amode(m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_andq_mi_sxb::new(m64.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_andb_mr_raw(&mut self, m8: &SyntheticAmode, r8: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m8 = self.convert_amode_to_assembler_amode(m8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r8 = cranelift_assembler_x64::Gpr::new(r8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_andb_mr::new(m8.clone(), r8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_andw_mr_raw(&mut self, m16: &SyntheticAmode, r16: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m16 = self.convert_amode_to_assembler_amode(m16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r16 = cranelift_assembler_x64::Gpr::new(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_andw_mr::new(m16.clone(), r16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_andl_mr_raw(&mut self, m32: &SyntheticAmode, r32: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m32 = self.convert_amode_to_assembler_amode(m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r32 = cranelift_assembler_x64::Gpr::new(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_andl_mr::new(m32.clone(), r32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_andq_mr_raw(&mut self, m64: &SyntheticAmode, r64: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m64 = self.convert_amode_to_assembler_amode(m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r64 = cranelift_assembler_x64::Gpr::new(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_andq_mr::new(m64.clone(), r64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_andps_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::andps_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_andpd_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::andpd_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_andnps_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::andnps_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_andnpd_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::andnpd_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pand_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pand_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pandn_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pandn_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vandps_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vandps_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vandpd_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vandpd_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vandnps_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vandnps_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vandnpd_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vandnpd_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpand_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpand_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpandn_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpandn_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_xchgb_rm_raw(&mut self, r8: Gpr, m8: &SyntheticAmode) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r8 = self.convert_gpr_to_assembler_read_write_gpr(r8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let m8 = self.convert_amode_to_assembler_amode(m8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::xchgb_rm::new(r8.clone(), m8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r8.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:201
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_xchgw_rm_raw(&mut self, r16: Gpr, m16: &SyntheticAmode) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = self.convert_gpr_to_assembler_read_write_gpr(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let m16 = self.convert_amode_to_assembler_amode(m16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::xchgw_rm::new(r16.clone(), m16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:201
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_xchgl_rm_raw(&mut self, r32: Gpr, m32: &SyntheticAmode) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = self.convert_gpr_to_assembler_read_write_gpr(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let m32 = self.convert_amode_to_assembler_amode(m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::xchgl_rm::new(r32.clone(), m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:201
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_xchgq_rm_raw(&mut self, r64: Gpr, m64: &SyntheticAmode) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = self.convert_gpr_to_assembler_read_write_gpr(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let m64 = self.convert_amode_to_assembler_amode(m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::xchgq_rm::new(r64.clone(), m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:201
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmpxchg16b_m_raw(&mut self, rax: Gpr, rdx: Gpr, rbx: Gpr, rcx: Gpr, m128: &SyntheticAmode) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rax = self.convert_gpr_to_assembler_fixed_read_write_gpr(rax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rdx = self.convert_gpr_to_assembler_fixed_read_write_gpr(rdx); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rbx = cranelift_assembler_x64::Fixed(rbx); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rcx = cranelift_assembler_x64::Fixed(rcx); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let m128 = self.convert_amode_to_assembler_amode(m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmpxchg16b_m::new(rax.clone(), rdx.clone(), rbx.clone(), rcx.clone(), m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let one = rax.as_ref().write.to_reg().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:213
            let two = rdx.as_ref().write.to_reg().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:214
            let regs = ValueRegs::two(one, two); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:215
            AssemblerOutputs::RetValueRegs { inst, regs }
        }
        fn x64_lock_cmpxchg16b_m_raw(&mut self, rax: Gpr, rdx: Gpr, rbx: Gpr, rcx: Gpr, m128: &SyntheticAmode) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rax = self.convert_gpr_to_assembler_fixed_read_write_gpr(rax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rdx = self.convert_gpr_to_assembler_fixed_read_write_gpr(rdx); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rbx = cranelift_assembler_x64::Fixed(rbx); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rcx = cranelift_assembler_x64::Fixed(rcx); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let m128 = self.convert_amode_to_assembler_amode(m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_cmpxchg16b_m::new(rax.clone(), rdx.clone(), rbx.clone(), rcx.clone(), m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let one = rax.as_ref().write.to_reg().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:213
            let two = rdx.as_ref().write.to_reg().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:214
            let regs = ValueRegs::two(one, two); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:215
            AssemblerOutputs::RetValueRegs { inst, regs }
        }
        fn x64_cmpxchgb_mr_raw(&mut self, rm8: &GprMem, r8: Gpr, al: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm8 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r8 = cranelift_assembler_x64::Gpr::new(r8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let al = self.convert_gpr_to_assembler_fixed_read_write_gpr(al); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmpxchgb_mr::new(rm8.clone(), r8.clone(), al.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = al.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:201
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmpxchgw_mr_raw(&mut self, rm16: &GprMem, r16: Gpr, ax: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm16 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r16 = cranelift_assembler_x64::Gpr::new(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let ax = self.convert_gpr_to_assembler_fixed_read_write_gpr(ax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmpxchgw_mr::new(rm16.clone(), r16.clone(), ax.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = ax.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:201
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmpxchgl_mr_raw(&mut self, rm32: &GprMem, r32: Gpr, eax: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r32 = cranelift_assembler_x64::Gpr::new(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let eax = self.convert_gpr_to_assembler_fixed_read_write_gpr(eax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmpxchgl_mr::new(rm32.clone(), r32.clone(), eax.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = eax.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:201
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmpxchgq_mr_raw(&mut self, rm64: &GprMem, r64: Gpr, rax: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm64 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r64 = cranelift_assembler_x64::Gpr::new(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rax = self.convert_gpr_to_assembler_fixed_read_write_gpr(rax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmpxchgq_mr::new(rm64.clone(), r64.clone(), rax.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = rax.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:201
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_lock_cmpxchgb_mr_raw(&mut self, m8: &SyntheticAmode, r8: Gpr, al: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m8 = self.convert_amode_to_assembler_amode(m8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r8 = cranelift_assembler_x64::Gpr::new(r8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let al = self.convert_gpr_to_assembler_fixed_read_write_gpr(al); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_cmpxchgb_mr::new(m8.clone(), r8.clone(), al.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = al.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:201
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_lock_cmpxchgw_mr_raw(&mut self, m16: &SyntheticAmode, r16: Gpr, ax: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m16 = self.convert_amode_to_assembler_amode(m16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r16 = cranelift_assembler_x64::Gpr::new(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let ax = self.convert_gpr_to_assembler_fixed_read_write_gpr(ax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_cmpxchgw_mr::new(m16.clone(), r16.clone(), ax.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = ax.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:201
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_lock_cmpxchgl_mr_raw(&mut self, m32: &SyntheticAmode, r32: Gpr, eax: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m32 = self.convert_amode_to_assembler_amode(m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r32 = cranelift_assembler_x64::Gpr::new(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let eax = self.convert_gpr_to_assembler_fixed_read_write_gpr(eax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_cmpxchgl_mr::new(m32.clone(), r32.clone(), eax.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = eax.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:201
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_lock_cmpxchgq_mr_raw(&mut self, m64: &SyntheticAmode, r64: Gpr, rax: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m64 = self.convert_amode_to_assembler_amode(m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r64 = cranelift_assembler_x64::Gpr::new(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rax = self.convert_gpr_to_assembler_fixed_read_write_gpr(rax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_cmpxchgq_mr::new(m64.clone(), r64.clone(), rax.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = rax.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:201
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_pavgb_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pavgb_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pavgw_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pavgw_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpavgb_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpavgb_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpavgw_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpavgw_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_bsfw_rm_raw(&mut self, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::bsfw_rm::new(r16.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_bsfl_rm_raw(&mut self, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::bsfl_rm::new(r32.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_bsfq_rm_raw(&mut self, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::bsfq_rm::new(r64.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_bsrw_rm_raw(&mut self, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::bsrw_rm::new(r16.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_bsrl_rm_raw(&mut self, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::bsrl_rm::new(r32.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_bsrq_rm_raw(&mut self, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::bsrq_rm::new(r64.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_tzcntw_a_raw(&mut self, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::tzcntw_a::new(r16.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_tzcntl_a_raw(&mut self, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::tzcntl_a::new(r32.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_tzcntq_a_raw(&mut self, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::tzcntq_a::new(r64.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_lzcntw_rm_raw(&mut self, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lzcntw_rm::new(r16.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_lzcntl_rm_raw(&mut self, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lzcntl_rm::new(r32.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_lzcntq_rm_raw(&mut self, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lzcntq_rm::new(r64.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_popcntw_rm_raw(&mut self, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::popcntw_rm::new(r16.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_popcntl_rm_raw(&mut self, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::popcntl_rm::new(r32.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_popcntq_rm_raw(&mut self, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::popcntq_rm::new(r64.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_btw_mr_raw(&mut self, rm16: &GprMem, r16: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r16 = cranelift_assembler_x64::Gpr::new(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::btw_mr::new(rm16.clone(), r16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_btl_mr_raw(&mut self, rm32: &GprMem, r32: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r32 = cranelift_assembler_x64::Gpr::new(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::btl_mr::new(rm32.clone(), r32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_btq_mr_raw(&mut self, rm64: &GprMem, r64: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r64 = cranelift_assembler_x64::Gpr::new(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::btq_mr::new(rm64.clone(), r64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_btw_mi_raw(&mut self, rm16: &GprMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::btw_mi::new(rm16.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_btl_mi_raw(&mut self, rm32: &GprMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::btl_mi::new(rm32.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_btq_mi_raw(&mut self, rm64: &GprMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::btq_mi::new(rm64.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_cbtw_zo_raw(&mut self, ax: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let ax = self.convert_gpr_to_assembler_fixed_read_write_gpr(ax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cbtw_zo::new(ax.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = ax.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cwtl_zo_raw(&mut self, eax: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let eax = self.convert_gpr_to_assembler_fixed_read_write_gpr(eax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cwtl_zo::new(eax.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = eax.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cltq_zo_raw(&mut self, rax: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rax = self.convert_gpr_to_assembler_fixed_read_write_gpr(rax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cltq_zo::new(rax.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = rax.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cwtd_zo_raw(&mut self, ax: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let dx = cranelift_assembler_x64::Fixed(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let ax = cranelift_assembler_x64::Fixed(ax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cwtd_zo::new(dx.clone(), ax.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = dx.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cltd_zo_raw(&mut self, eax: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let edx = cranelift_assembler_x64::Fixed(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let eax = cranelift_assembler_x64::Fixed(eax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cltd_zo::new(edx.clone(), eax.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = edx.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cqto_zo_raw(&mut self, rax: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rdx = cranelift_assembler_x64::Fixed(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rax = cranelift_assembler_x64::Fixed(rax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cqto_zo::new(rdx.clone(), rax.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = rdx.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_bswapl_o_raw(&mut self, r32: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = self.convert_gpr_to_assembler_read_write_gpr(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::bswapl_o::new(r32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_bswapq_o_raw(&mut self, r64: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = self.convert_gpr_to_assembler_read_write_gpr(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::bswapq_o::new(r64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_blsrl_vm_raw(&mut self, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::blsrl_vm::new(r32.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_blsrq_vm_raw(&mut self, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::blsrq_vm::new(r64.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_blsmskl_vm_raw(&mut self, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::blsmskl_vm::new(r32.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_blsmskq_vm_raw(&mut self, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::blsmskq_vm::new(r64.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_blsil_vm_raw(&mut self, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::blsil_vm::new(r32.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_blsiq_vm_raw(&mut self, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::blsiq_vm::new(r64.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_bzhil_rmv_raw(&mut self, rm32: &GprMem, r32b: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32a = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r32b = cranelift_assembler_x64::Gpr::new(r32b); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::bzhil_rmv::new(r32a.clone(), rm32.clone(), r32b.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32a.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_bzhiq_rmv_raw(&mut self, rm64: &GprMem, r64b: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64a = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r64b = cranelift_assembler_x64::Gpr::new(r64b); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::bzhiq_rmv::new(r64a.clone(), rm64.clone(), r64b.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64a.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_vpopcntb_a_raw(&mut self, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpopcntb_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpopcntw_a_raw(&mut self, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpopcntw_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_cmovaw_rm_raw(&mut self, r16: Gpr, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = self.convert_gpr_to_assembler_read_write_gpr(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovaw_rm::new(r16.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmoval_rm_raw(&mut self, r32: Gpr, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = self.convert_gpr_to_assembler_read_write_gpr(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmoval_rm::new(r32.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovaq_rm_raw(&mut self, r64: Gpr, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = self.convert_gpr_to_assembler_read_write_gpr(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovaq_rm::new(r64.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovaew_rm_raw(&mut self, r16: Gpr, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = self.convert_gpr_to_assembler_read_write_gpr(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovaew_rm::new(r16.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovael_rm_raw(&mut self, r32: Gpr, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = self.convert_gpr_to_assembler_read_write_gpr(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovael_rm::new(r32.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovaeq_rm_raw(&mut self, r64: Gpr, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = self.convert_gpr_to_assembler_read_write_gpr(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovaeq_rm::new(r64.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovbw_rm_raw(&mut self, r16: Gpr, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = self.convert_gpr_to_assembler_read_write_gpr(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovbw_rm::new(r16.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovbl_rm_raw(&mut self, r32: Gpr, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = self.convert_gpr_to_assembler_read_write_gpr(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovbl_rm::new(r32.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovbq_rm_raw(&mut self, r64: Gpr, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = self.convert_gpr_to_assembler_read_write_gpr(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovbq_rm::new(r64.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovbew_rm_raw(&mut self, r16: Gpr, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = self.convert_gpr_to_assembler_read_write_gpr(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovbew_rm::new(r16.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovbel_rm_raw(&mut self, r32: Gpr, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = self.convert_gpr_to_assembler_read_write_gpr(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovbel_rm::new(r32.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovbeq_rm_raw(&mut self, r64: Gpr, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = self.convert_gpr_to_assembler_read_write_gpr(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovbeq_rm::new(r64.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovew_rm_raw(&mut self, r16: Gpr, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = self.convert_gpr_to_assembler_read_write_gpr(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovew_rm::new(r16.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovel_rm_raw(&mut self, r32: Gpr, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = self.convert_gpr_to_assembler_read_write_gpr(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovel_rm::new(r32.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmoveq_rm_raw(&mut self, r64: Gpr, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = self.convert_gpr_to_assembler_read_write_gpr(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmoveq_rm::new(r64.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovgw_rm_raw(&mut self, r16: Gpr, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = self.convert_gpr_to_assembler_read_write_gpr(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovgw_rm::new(r16.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovgl_rm_raw(&mut self, r32: Gpr, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = self.convert_gpr_to_assembler_read_write_gpr(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovgl_rm::new(r32.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovgq_rm_raw(&mut self, r64: Gpr, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = self.convert_gpr_to_assembler_read_write_gpr(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovgq_rm::new(r64.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovgew_rm_raw(&mut self, r16: Gpr, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = self.convert_gpr_to_assembler_read_write_gpr(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovgew_rm::new(r16.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovgel_rm_raw(&mut self, r32: Gpr, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = self.convert_gpr_to_assembler_read_write_gpr(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovgel_rm::new(r32.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovgeq_rm_raw(&mut self, r64: Gpr, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = self.convert_gpr_to_assembler_read_write_gpr(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovgeq_rm::new(r64.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovlw_rm_raw(&mut self, r16: Gpr, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = self.convert_gpr_to_assembler_read_write_gpr(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovlw_rm::new(r16.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovll_rm_raw(&mut self, r32: Gpr, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = self.convert_gpr_to_assembler_read_write_gpr(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovll_rm::new(r32.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovlq_rm_raw(&mut self, r64: Gpr, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = self.convert_gpr_to_assembler_read_write_gpr(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovlq_rm::new(r64.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovlew_rm_raw(&mut self, r16: Gpr, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = self.convert_gpr_to_assembler_read_write_gpr(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovlew_rm::new(r16.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovlel_rm_raw(&mut self, r32: Gpr, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = self.convert_gpr_to_assembler_read_write_gpr(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovlel_rm::new(r32.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovleq_rm_raw(&mut self, r64: Gpr, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = self.convert_gpr_to_assembler_read_write_gpr(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovleq_rm::new(r64.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovnew_rm_raw(&mut self, r16: Gpr, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = self.convert_gpr_to_assembler_read_write_gpr(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovnew_rm::new(r16.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovnel_rm_raw(&mut self, r32: Gpr, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = self.convert_gpr_to_assembler_read_write_gpr(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovnel_rm::new(r32.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovneq_rm_raw(&mut self, r64: Gpr, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = self.convert_gpr_to_assembler_read_write_gpr(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovneq_rm::new(r64.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovnow_rm_raw(&mut self, r16: Gpr, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = self.convert_gpr_to_assembler_read_write_gpr(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovnow_rm::new(r16.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovnol_rm_raw(&mut self, r32: Gpr, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = self.convert_gpr_to_assembler_read_write_gpr(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovnol_rm::new(r32.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovnoq_rm_raw(&mut self, r64: Gpr, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = self.convert_gpr_to_assembler_read_write_gpr(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovnoq_rm::new(r64.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovnpw_rm_raw(&mut self, r16: Gpr, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = self.convert_gpr_to_assembler_read_write_gpr(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovnpw_rm::new(r16.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovnpl_rm_raw(&mut self, r32: Gpr, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = self.convert_gpr_to_assembler_read_write_gpr(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovnpl_rm::new(r32.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovnpq_rm_raw(&mut self, r64: Gpr, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = self.convert_gpr_to_assembler_read_write_gpr(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovnpq_rm::new(r64.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovnsw_rm_raw(&mut self, r16: Gpr, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = self.convert_gpr_to_assembler_read_write_gpr(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovnsw_rm::new(r16.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovnsl_rm_raw(&mut self, r32: Gpr, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = self.convert_gpr_to_assembler_read_write_gpr(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovnsl_rm::new(r32.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovnsq_rm_raw(&mut self, r64: Gpr, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = self.convert_gpr_to_assembler_read_write_gpr(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovnsq_rm::new(r64.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovow_rm_raw(&mut self, r16: Gpr, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = self.convert_gpr_to_assembler_read_write_gpr(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovow_rm::new(r16.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovol_rm_raw(&mut self, r32: Gpr, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = self.convert_gpr_to_assembler_read_write_gpr(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovol_rm::new(r32.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovoq_rm_raw(&mut self, r64: Gpr, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = self.convert_gpr_to_assembler_read_write_gpr(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovoq_rm::new(r64.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovpw_rm_raw(&mut self, r16: Gpr, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = self.convert_gpr_to_assembler_read_write_gpr(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovpw_rm::new(r16.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovpl_rm_raw(&mut self, r32: Gpr, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = self.convert_gpr_to_assembler_read_write_gpr(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovpl_rm::new(r32.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovpq_rm_raw(&mut self, r64: Gpr, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = self.convert_gpr_to_assembler_read_write_gpr(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovpq_rm::new(r64.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovsw_rm_raw(&mut self, r16: Gpr, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = self.convert_gpr_to_assembler_read_write_gpr(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovsw_rm::new(r16.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovsl_rm_raw(&mut self, r32: Gpr, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = self.convert_gpr_to_assembler_read_write_gpr(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovsl_rm::new(r32.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmovsq_rm_raw(&mut self, r64: Gpr, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = self.convert_gpr_to_assembler_read_write_gpr(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmovsq_rm::new(r64.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cmpb_i_raw(&mut self, al: Gpr, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let al = cranelift_assembler_x64::Fixed(al); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmpb_i::new(al.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_cmpw_i_raw(&mut self, ax: Gpr, imm16: u16) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let ax = cranelift_assembler_x64::Fixed(ax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm16 = cranelift_assembler_x64::Imm16::new(imm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmpw_i::new(ax.clone(), imm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_cmpl_i_raw(&mut self, eax: Gpr, imm32: u32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let eax = cranelift_assembler_x64::Fixed(eax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Imm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmpl_i::new(eax.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_cmpq_i_raw(&mut self, rax: Gpr, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rax = cranelift_assembler_x64::Fixed(rax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmpq_i::new(rax.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_cmpb_mi_raw(&mut self, rm8: &GprMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm8 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmpb_mi::new(rm8.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_cmpw_mi_raw(&mut self, rm16: &GprMem, imm16: u16) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm16 = cranelift_assembler_x64::Imm16::new(imm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmpw_mi::new(rm16.clone(), imm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_cmpl_mi_raw(&mut self, rm32: &GprMem, imm32: u32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Imm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmpl_mi::new(rm32.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_cmpq_mi_raw(&mut self, rm64: &GprMem, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmpq_mi::new(rm64.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_cmpw_mi_sxb_raw(&mut self, rm16: &GprMem, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmpw_mi_sxb::new(rm16.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_cmpl_mi_sxb_raw(&mut self, rm32: &GprMem, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmpl_mi_sxb::new(rm32.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_cmpq_mi_sxb_raw(&mut self, rm64: &GprMem, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmpq_mi_sxb::new(rm64.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_cmpb_mr_raw(&mut self, rm8: &GprMem, r8: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm8 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r8 = cranelift_assembler_x64::Gpr::new(r8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmpb_mr::new(rm8.clone(), r8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_cmpw_mr_raw(&mut self, rm16: &GprMem, r16: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r16 = cranelift_assembler_x64::Gpr::new(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmpw_mr::new(rm16.clone(), r16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_cmpl_mr_raw(&mut self, rm32: &GprMem, r32: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r32 = cranelift_assembler_x64::Gpr::new(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmpl_mr::new(rm32.clone(), r32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_cmpq_mr_raw(&mut self, rm64: &GprMem, r64: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r64 = cranelift_assembler_x64::Gpr::new(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmpq_mr::new(rm64.clone(), r64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_cmpb_rm_raw(&mut self, r8: Gpr, rm8: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r8 = cranelift_assembler_x64::Gpr::new(r8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm8 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmpb_rm::new(r8.clone(), rm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_cmpw_rm_raw(&mut self, r16: Gpr, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = cranelift_assembler_x64::Gpr::new(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmpw_rm::new(r16.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_cmpl_rm_raw(&mut self, r32: Gpr, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmpl_rm::new(r32.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_cmpq_rm_raw(&mut self, r64: Gpr, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = cranelift_assembler_x64::Gpr::new(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmpq_rm::new(r64.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_testb_i_raw(&mut self, al: Gpr, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let al = cranelift_assembler_x64::Fixed(al); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::testb_i::new(al.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_testw_i_raw(&mut self, ax: Gpr, imm16: u16) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let ax = cranelift_assembler_x64::Fixed(ax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm16 = cranelift_assembler_x64::Imm16::new(imm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::testw_i::new(ax.clone(), imm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_testl_i_raw(&mut self, eax: Gpr, imm32: u32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let eax = cranelift_assembler_x64::Fixed(eax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Imm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::testl_i::new(eax.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_testq_i_raw(&mut self, rax: Gpr, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rax = cranelift_assembler_x64::Fixed(rax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::testq_i::new(rax.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_testb_mi_raw(&mut self, rm8: &GprMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm8 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::testb_mi::new(rm8.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_testw_mi_raw(&mut self, rm16: &GprMem, imm16: u16) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm16 = cranelift_assembler_x64::Imm16::new(imm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::testw_mi::new(rm16.clone(), imm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_testl_mi_raw(&mut self, rm32: &GprMem, imm32: u32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Imm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::testl_mi::new(rm32.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_testq_mi_raw(&mut self, rm64: &GprMem, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::testq_mi::new(rm64.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_testb_mr_raw(&mut self, rm8: &GprMem, r8: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm8 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r8 = cranelift_assembler_x64::Gpr::new(r8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::testb_mr::new(rm8.clone(), r8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_testw_mr_raw(&mut self, rm16: &GprMem, r16: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r16 = cranelift_assembler_x64::Gpr::new(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::testw_mr::new(rm16.clone(), r16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_testl_mr_raw(&mut self, rm32: &GprMem, r32: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r32 = cranelift_assembler_x64::Gpr::new(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::testl_mr::new(rm32.clone(), r32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_testq_mr_raw(&mut self, rm64: &GprMem, r64: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r64 = cranelift_assembler_x64::Gpr::new(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::testq_mr::new(rm64.clone(), r64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_ptest_rm_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::ptest_rm::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_vptest_rm_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vptest_rm::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_ucomiss_a_raw(&mut self, xmm1: Xmm, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::ucomiss_a::new(xmm1.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_ucomisd_a_raw(&mut self, xmm1: Xmm, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::ucomisd_a::new(xmm1.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_vucomiss_a_raw(&mut self, xmm2: Xmm, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vucomiss_a::new(xmm2.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_vucomisd_a_raw(&mut self, xmm2: Xmm, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vucomisd_a::new(xmm2.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_cmpss_a_raw(&mut self, xmm1: Xmm, xmm_m32: &XmmMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmpss_a::new(xmm1.clone(), xmm_m32.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_cmpsd_a_raw(&mut self, xmm1: Xmm, xmm_m64: &XmmMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmpsd_a::new(xmm1.clone(), xmm_m64.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_cmpps_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmpps_a::new(xmm1.clone(), xmm_m128.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_cmppd_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cmppd_a::new(xmm1.clone(), xmm_m128.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vcmpss_b_raw(&mut self, xmm2: Xmm, xmm_m32: &XmmMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vcmpss_b::new(xmm1.clone(), xmm2.clone(), xmm_m32.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vcmpsd_b_raw(&mut self, xmm2: Xmm, xmm_m64: &XmmMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vcmpsd_b::new(xmm1.clone(), xmm2.clone(), xmm_m64.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vcmpps_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vcmpps_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vcmppd_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vcmppd_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pcmpeqb_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pcmpeqb_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pcmpeqw_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pcmpeqw_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pcmpeqd_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pcmpeqd_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pcmpeqq_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pcmpeqq_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pcmpgtb_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pcmpgtb_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pcmpgtw_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pcmpgtw_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pcmpgtd_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pcmpgtd_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pcmpgtq_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pcmpgtq_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpcmpeqb_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpcmpeqb_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpcmpeqw_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpcmpeqw_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpcmpeqd_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpcmpeqd_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpcmpeqq_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpcmpeqq_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpcmpgtb_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpcmpgtb_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpcmpgtw_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpcmpgtw_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpcmpgtd_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpcmpgtd_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpcmpgtq_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpcmpgtq_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_cvtps2pd_a_raw(&mut self, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cvtps2pd_a::new(xmm1.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_cvttps2dq_a_raw(&mut self, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cvttps2dq_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_cvtss2sd_a_raw(&mut self, xmm1: Xmm, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cvtss2sd_a::new(xmm1.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_cvtss2si_a_raw(&mut self, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cvtss2si_a::new(r32.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cvtss2si_aq_raw(&mut self, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cvtss2si_aq::new(r64.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cvttss2si_a_raw(&mut self, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cvttss2si_a::new(r32.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cvttss2si_aq_raw(&mut self, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cvttss2si_aq::new(r64.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_vcvtps2pd_a_raw(&mut self, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vcvtps2pd_a::new(xmm1.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vcvttps2dq_a_raw(&mut self, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vcvttps2dq_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vcvtss2sd_b_raw(&mut self, xmm2: Xmm, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vcvtss2sd_b::new(xmm1.clone(), xmm2.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vcvtss2si_a_raw(&mut self, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vcvtss2si_a::new(r32.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_vcvtss2si_aq_raw(&mut self, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vcvtss2si_aq::new(r64.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_vcvttss2si_a_raw(&mut self, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vcvttss2si_a::new(r32.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_vcvttss2si_aq_raw(&mut self, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vcvttss2si_aq::new(r64.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cvtpd2ps_a_raw(&mut self, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cvtpd2ps_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_cvttpd2dq_a_raw(&mut self, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cvttpd2dq_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_cvtsd2ss_a_raw(&mut self, xmm1: Xmm, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cvtsd2ss_a::new(xmm1.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_cvtsd2si_a_raw(&mut self, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cvtsd2si_a::new(r32.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cvtsd2si_aq_raw(&mut self, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cvtsd2si_aq::new(r64.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cvttsd2si_a_raw(&mut self, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cvttsd2si_a::new(r32.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cvttsd2si_aq_raw(&mut self, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cvttsd2si_aq::new(r64.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_vcvtpd2ps_a_raw(&mut self, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vcvtpd2ps_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vcvttpd2dq_a_raw(&mut self, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vcvttpd2dq_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vcvtsd2ss_b_raw(&mut self, xmm2: Xmm, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vcvtsd2ss_b::new(xmm1.clone(), xmm2.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vcvtsd2si_a_raw(&mut self, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vcvtsd2si_a::new(r32.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_vcvtsd2si_aq_raw(&mut self, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vcvtsd2si_aq::new(r64.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_vcvttsd2si_a_raw(&mut self, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vcvttsd2si_a::new(r32.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_vcvttsd2si_aq_raw(&mut self, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vcvttsd2si_aq::new(r64.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_cvtdq2ps_a_raw(&mut self, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cvtdq2ps_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_cvtdq2pd_a_raw(&mut self, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cvtdq2pd_a::new(xmm1.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_cvtsi2ssl_a_raw(&mut self, xmm1: Xmm, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cvtsi2ssl_a::new(xmm1.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_cvtsi2ssq_a_raw(&mut self, xmm1: Xmm, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cvtsi2ssq_a::new(xmm1.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_cvtsi2sdl_a_raw(&mut self, xmm1: Xmm, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cvtsi2sdl_a::new(xmm1.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_cvtsi2sdq_a_raw(&mut self, xmm1: Xmm, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::cvtsi2sdq_a::new(xmm1.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vcvtdq2pd_a_raw(&mut self, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vcvtdq2pd_a::new(xmm1.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vcvtdq2ps_a_raw(&mut self, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vcvtdq2ps_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vcvtsi2sdl_b_raw(&mut self, xmm2: Xmm, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vcvtsi2sdl_b::new(xmm1.clone(), xmm2.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vcvtsi2sdq_b_raw(&mut self, xmm2: Xmm, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vcvtsi2sdq_b::new(xmm1.clone(), xmm2.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vcvtsi2ssl_b_raw(&mut self, xmm2: Xmm, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vcvtsi2ssl_b::new(xmm1.clone(), xmm2.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vcvtsi2ssq_b_raw(&mut self, xmm2: Xmm, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vcvtsi2ssq_b::new(xmm1.clone(), xmm2.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vcvtudq2ps_a_raw(&mut self, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vcvtudq2ps_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_divb_m_raw(&mut self, ax: Gpr, rm8: &GprMem, trap: &TrapCode) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let ax = self.convert_gpr_to_assembler_fixed_read_write_gpr(ax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm8 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::divb_m::new(ax.clone(), rm8.clone(), cranelift_assembler_x64::TrapCode(trap.as_raw())).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = ax.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_divw_m_raw(&mut self, ax: Gpr, dx: Gpr, rm16: &GprMem, trap: &TrapCode) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let ax = self.convert_gpr_to_assembler_fixed_read_write_gpr(ax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let dx = self.convert_gpr_to_assembler_fixed_read_write_gpr(dx); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::divw_m::new(ax.clone(), dx.clone(), rm16.clone(), cranelift_assembler_x64::TrapCode(trap.as_raw())).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let one = ax.as_ref().write.to_reg().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:194
            let two = dx.as_ref().write.to_reg().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:195
            let regs = ValueRegs::two(one, two); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:196
            AssemblerOutputs::RetValueRegs { inst, regs }
        }
        fn x64_divl_m_raw(&mut self, eax: Gpr, edx: Gpr, rm32: &GprMem, trap: &TrapCode) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let eax = self.convert_gpr_to_assembler_fixed_read_write_gpr(eax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let edx = self.convert_gpr_to_assembler_fixed_read_write_gpr(edx); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::divl_m::new(eax.clone(), edx.clone(), rm32.clone(), cranelift_assembler_x64::TrapCode(trap.as_raw())).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let one = eax.as_ref().write.to_reg().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:194
            let two = edx.as_ref().write.to_reg().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:195
            let regs = ValueRegs::two(one, two); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:196
            AssemblerOutputs::RetValueRegs { inst, regs }
        }
        fn x64_divq_m_raw(&mut self, rax: Gpr, rdx: Gpr, rm64: &GprMem, trap: &TrapCode) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rax = self.convert_gpr_to_assembler_fixed_read_write_gpr(rax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rdx = self.convert_gpr_to_assembler_fixed_read_write_gpr(rdx); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::divq_m::new(rax.clone(), rdx.clone(), rm64.clone(), cranelift_assembler_x64::TrapCode(trap.as_raw())).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let one = rax.as_ref().write.to_reg().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:194
            let two = rdx.as_ref().write.to_reg().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:195
            let regs = ValueRegs::two(one, two); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:196
            AssemblerOutputs::RetValueRegs { inst, regs }
        }
        fn x64_idivb_m_raw(&mut self, ax: Gpr, rm8: &GprMem, trap: &TrapCode) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let ax = self.convert_gpr_to_assembler_fixed_read_write_gpr(ax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm8 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::idivb_m::new(ax.clone(), rm8.clone(), cranelift_assembler_x64::TrapCode(trap.as_raw())).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = ax.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_idivw_m_raw(&mut self, ax: Gpr, dx: Gpr, rm16: &GprMem, trap: &TrapCode) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let ax = self.convert_gpr_to_assembler_fixed_read_write_gpr(ax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let dx = self.convert_gpr_to_assembler_fixed_read_write_gpr(dx); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::idivw_m::new(ax.clone(), dx.clone(), rm16.clone(), cranelift_assembler_x64::TrapCode(trap.as_raw())).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let one = ax.as_ref().write.to_reg().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:194
            let two = dx.as_ref().write.to_reg().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:195
            let regs = ValueRegs::two(one, two); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:196
            AssemblerOutputs::RetValueRegs { inst, regs }
        }
        fn x64_idivl_m_raw(&mut self, eax: Gpr, edx: Gpr, rm32: &GprMem, trap: &TrapCode) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let eax = self.convert_gpr_to_assembler_fixed_read_write_gpr(eax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let edx = self.convert_gpr_to_assembler_fixed_read_write_gpr(edx); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::idivl_m::new(eax.clone(), edx.clone(), rm32.clone(), cranelift_assembler_x64::TrapCode(trap.as_raw())).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let one = eax.as_ref().write.to_reg().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:194
            let two = edx.as_ref().write.to_reg().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:195
            let regs = ValueRegs::two(one, two); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:196
            AssemblerOutputs::RetValueRegs { inst, regs }
        }
        fn x64_idivq_m_raw(&mut self, rax: Gpr, rdx: Gpr, rm64: &GprMem, trap: &TrapCode) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rax = self.convert_gpr_to_assembler_fixed_read_write_gpr(rax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rdx = self.convert_gpr_to_assembler_fixed_read_write_gpr(rdx); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::idivq_m::new(rax.clone(), rdx.clone(), rm64.clone(), cranelift_assembler_x64::TrapCode(trap.as_raw())).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let one = rax.as_ref().write.to_reg().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:194
            let two = rdx.as_ref().write.to_reg().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:195
            let regs = ValueRegs::two(one, two); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:196
            AssemblerOutputs::RetValueRegs { inst, regs }
        }
        fn x64_divss_a_raw(&mut self, xmm1: Xmm, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::divss_a::new(xmm1.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_divsd_a_raw(&mut self, xmm1: Xmm, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::divsd_a::new(xmm1.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_divps_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::divps_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_divpd_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::divpd_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vdivss_b_raw(&mut self, xmm2: Xmm, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vdivss_b::new(xmm1.clone(), xmm2.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vdivsd_b_raw(&mut self, xmm2: Xmm, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vdivsd_b::new(xmm1.clone(), xmm2.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vdivps_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vdivps_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vdivpd_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vdivpd_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfmadd132ss_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfmadd132ss_a::new(xmm1.clone(), xmm2.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfmadd213ss_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfmadd213ss_a::new(xmm1.clone(), xmm2.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfmadd231ss_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfmadd231ss_a::new(xmm1.clone(), xmm2.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfmadd132sd_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfmadd132sd_a::new(xmm1.clone(), xmm2.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfmadd213sd_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfmadd213sd_a::new(xmm1.clone(), xmm2.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfmadd231sd_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfmadd231sd_a::new(xmm1.clone(), xmm2.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfmadd132ps_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfmadd132ps_a::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfmadd213ps_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfmadd213ps_a::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfmadd231ps_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfmadd231ps_a::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfmadd132pd_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfmadd132pd_a::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfmadd213pd_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfmadd213pd_a::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfmadd231pd_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfmadd231pd_a::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfnmadd132ss_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfnmadd132ss_a::new(xmm1.clone(), xmm2.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfnmadd213ss_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfnmadd213ss_a::new(xmm1.clone(), xmm2.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfnmadd231ss_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfnmadd231ss_a::new(xmm1.clone(), xmm2.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfnmadd132sd_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfnmadd132sd_a::new(xmm1.clone(), xmm2.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfnmadd213sd_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfnmadd213sd_a::new(xmm1.clone(), xmm2.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfnmadd231sd_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfnmadd231sd_a::new(xmm1.clone(), xmm2.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfnmadd132ps_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfnmadd132ps_a::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfnmadd213ps_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfnmadd213ps_a::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfnmadd231ps_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfnmadd231ps_a::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfnmadd132pd_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfnmadd132pd_a::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfnmadd213pd_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfnmadd213pd_a::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfnmadd231pd_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfnmadd231pd_a::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfmsub132ss_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfmsub132ss_a::new(xmm1.clone(), xmm2.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfmsub213ss_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfmsub213ss_a::new(xmm1.clone(), xmm2.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfmsub231ss_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfmsub231ss_a::new(xmm1.clone(), xmm2.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfmsub132sd_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfmsub132sd_a::new(xmm1.clone(), xmm2.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfmsub213sd_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfmsub213sd_a::new(xmm1.clone(), xmm2.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfmsub231sd_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfmsub231sd_a::new(xmm1.clone(), xmm2.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfmsub132ps_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfmsub132ps_a::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfmsub213ps_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfmsub213ps_a::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfmsub231ps_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfmsub231ps_a::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfmsub132pd_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfmsub132pd_a::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfmsub213pd_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfmsub213pd_a::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfmsub231pd_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfmsub231pd_a::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfnmsub132ss_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfnmsub132ss_a::new(xmm1.clone(), xmm2.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfnmsub213ss_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfnmsub213ss_a::new(xmm1.clone(), xmm2.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfnmsub231ss_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfnmsub231ss_a::new(xmm1.clone(), xmm2.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfnmsub132sd_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfnmsub132sd_a::new(xmm1.clone(), xmm2.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfnmsub213sd_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfnmsub213sd_a::new(xmm1.clone(), xmm2.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfnmsub231sd_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfnmsub231sd_a::new(xmm1.clone(), xmm2.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfnmsub132ps_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfnmsub132ps_a::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfnmsub213ps_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfnmsub213ps_a::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfnmsub231ps_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfnmsub231ps_a::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfnmsub132pd_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfnmsub132pd_a::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfnmsub213pd_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfnmsub213pd_a::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vfnmsub231pd_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vfnmsub231pd_a::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_jmpq_m_raw(&mut self, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::jmpq_m::new(rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_jmp_d8_raw(&mut self, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::jmp_d8::new(imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_jmp_d32_raw(&mut self, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::jmp_d32::new(imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_ja_d8_raw(&mut self, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::ja_d8::new(imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_ja_d32_raw(&mut self, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::ja_d32::new(imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_jae_d8_raw(&mut self, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::jae_d8::new(imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_jae_d32_raw(&mut self, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::jae_d32::new(imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_jb_d8_raw(&mut self, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::jb_d8::new(imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_jb_d32_raw(&mut self, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::jb_d32::new(imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_jbe_d8_raw(&mut self, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::jbe_d8::new(imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_jbe_d32_raw(&mut self, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::jbe_d32::new(imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_je_d8_raw(&mut self, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::je_d8::new(imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_je_d32_raw(&mut self, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::je_d32::new(imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_jg_d8_raw(&mut self, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::jg_d8::new(imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_jg_d32_raw(&mut self, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::jg_d32::new(imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_jge_d8_raw(&mut self, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::jge_d8::new(imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_jge_d32_raw(&mut self, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::jge_d32::new(imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_jl_d8_raw(&mut self, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::jl_d8::new(imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_jl_d32_raw(&mut self, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::jl_d32::new(imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_jle_d8_raw(&mut self, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::jle_d8::new(imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_jle_d32_raw(&mut self, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::jle_d32::new(imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_jne_d8_raw(&mut self, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::jne_d8::new(imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_jne_d32_raw(&mut self, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::jne_d32::new(imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_jno_d8_raw(&mut self, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::jno_d8::new(imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_jno_d32_raw(&mut self, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::jno_d32::new(imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_jnp_d8_raw(&mut self, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::jnp_d8::new(imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_jnp_d32_raw(&mut self, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::jnp_d32::new(imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_jns_d8_raw(&mut self, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::jns_d8::new(imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_jns_d32_raw(&mut self, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::jns_d32::new(imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_jo_d8_raw(&mut self, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::jo_d8::new(imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_jo_d32_raw(&mut self, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::jo_d32::new(imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_jp_d8_raw(&mut self, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::jp_d8::new(imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_jp_d32_raw(&mut self, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::jp_d32::new(imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_js_d8_raw(&mut self, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::js_d8::new(imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_js_d32_raw(&mut self, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::js_d32::new(imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_extractps_a_raw(&mut self, rm32: &GprMem, xmm1: Xmm, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_write_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm1 = cranelift_assembler_x64::Xmm::new(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::extractps_a::new(rm32.clone(), xmm1.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm32 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_pextrb_a_raw(&mut self, rm32: &GprMem, xmm2: Xmm, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_write_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pextrb_a::new(rm32.clone(), xmm2.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm32 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_pextrw_a_raw(&mut self, xmm2: Xmm, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pextrw_a::new(r32.clone(), xmm2.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_pextrw_b_raw(&mut self, rm32: &GprMem, xmm2: Xmm, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_write_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pextrw_b::new(rm32.clone(), xmm2.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm32 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_pextrd_a_raw(&mut self, rm32: &GprMem, xmm2: Xmm, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_write_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pextrd_a::new(rm32.clone(), xmm2.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm32 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_pextrq_a_raw(&mut self, rm64: &GprMem, xmm2: Xmm, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm64 = self.convert_gpr_mem_to_assembler_write_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pextrq_a::new(rm64.clone(), xmm2.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm64 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_vextractps_b_raw(&mut self, rm32: &GprMem, xmm1: Xmm, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_write_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm1 = cranelift_assembler_x64::Xmm::new(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vextractps_b::new(rm32.clone(), xmm1.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm32 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_vpextrb_a_raw(&mut self, rm32: &GprMem, xmm2: Xmm, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_write_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpextrb_a::new(rm32.clone(), xmm2.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm32 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_vpextrw_a_raw(&mut self, xmm2: Xmm, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpextrw_a::new(r32.clone(), xmm2.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_vpextrw_b_raw(&mut self, rm32: &GprMem, xmm2: Xmm, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_write_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpextrw_b::new(rm32.clone(), xmm2.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm32 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_vpextrd_a_raw(&mut self, rm32: &GprMem, xmm2: Xmm, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_write_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpextrd_a::new(rm32.clone(), xmm2.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm32 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_vpextrq_a_raw(&mut self, rm64: &GprMem, xmm2: Xmm, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm64 = self.convert_gpr_mem_to_assembler_write_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpextrq_a::new(rm64.clone(), xmm2.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm64 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_insertps_a_raw(&mut self, xmm1: Xmm, xmm_m32: &XmmMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::insertps_a::new(xmm1.clone(), xmm_m32.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pinsrb_a_raw(&mut self, xmm1: Xmm, rm32: &GprMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pinsrb_a::new(xmm1.clone(), rm32.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pinsrw_a_raw(&mut self, xmm1: Xmm, rm32: &GprMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pinsrw_a::new(xmm1.clone(), rm32.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pinsrd_a_raw(&mut self, xmm1: Xmm, rm32: &GprMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pinsrd_a::new(xmm1.clone(), rm32.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pinsrq_a_raw(&mut self, xmm1: Xmm, rm64: &GprMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pinsrq_a::new(xmm1.clone(), rm64.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vinsertps_b_raw(&mut self, xmm2: Xmm, xmm_m32: &XmmMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vinsertps_b::new(xmm1.clone(), xmm2.clone(), xmm_m32.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpinsrb_b_raw(&mut self, xmm2: Xmm, rm32: &GprMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpinsrb_b::new(xmm1.clone(), xmm2.clone(), rm32.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpinsrw_b_raw(&mut self, xmm2: Xmm, rm32: &GprMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpinsrw_b::new(xmm1.clone(), xmm2.clone(), rm32.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpinsrd_b_raw(&mut self, xmm2: Xmm, rm32: &GprMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpinsrd_b::new(xmm1.clone(), xmm2.clone(), rm32.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpinsrq_b_raw(&mut self, xmm2: Xmm, rm64: &GprMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpinsrq_b::new(xmm1.clone(), xmm2.clone(), rm64.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_movmskps_rm_raw(&mut self, xmm2: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movmskps_rm::new(r32.clone(), xmm2.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_movmskpd_rm_raw(&mut self, xmm2: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movmskpd_rm::new(r32.clone(), xmm2.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_pmovmskb_rm_raw(&mut self, xmm2: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pmovmskb_rm::new(r32.clone(), xmm2.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_vmovmskps_rm_raw(&mut self, xmm2: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmovmskps_rm::new(r32.clone(), xmm2.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_vmovmskpd_rm_raw(&mut self, xmm2: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmovmskpd_rm::new(r32.clone(), xmm2.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_vpmovmskb_rm_raw(&mut self, xmm2: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpmovmskb_rm::new(r32.clone(), xmm2.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_movhps_a_raw(&mut self, xmm1: Xmm, m64: &SyntheticAmode) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let m64 = self.convert_amode_to_assembler_amode(m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movhps_a::new(xmm1.clone(), m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_movlhps_rm_raw(&mut self, xmm1: Xmm, xmm2: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movlhps_rm::new(xmm1.clone(), xmm2.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vmovhps_b_raw(&mut self, xmm1: Xmm, m64: &SyntheticAmode) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm2 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm1 = cranelift_assembler_x64::Xmm::new(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let m64 = self.convert_amode_to_assembler_amode(m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmovhps_b::new(xmm2.clone(), xmm1.clone(), m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm2.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vmovlhps_rvm_raw(&mut self, xmm2: Xmm, xmm3: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm3 = cranelift_assembler_x64::Xmm::new(xmm3); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmovlhps_rvm::new(xmm1.clone(), xmm2.clone(), xmm3.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_movddup_a_raw(&mut self, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movddup_a::new(xmm1.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vmovddup_a_raw(&mut self, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmovddup_a::new(xmm1.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pblendw_rmi_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pblendw_rmi::new(xmm1.clone(), xmm_m128.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pblendvb_rm_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned, xmm0: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm0 = cranelift_assembler_x64::Fixed(xmm0); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pblendvb_rm::new(xmm1.clone(), xmm_m128.clone(), xmm0.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_blendvps_rm0_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned, xmm0: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm0 = cranelift_assembler_x64::Fixed(xmm0); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::blendvps_rm0::new(xmm1.clone(), xmm_m128.clone(), xmm0.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_blendvpd_rm0_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned, xmm0: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm0 = cranelift_assembler_x64::Fixed(xmm0); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::blendvpd_rm0::new(xmm1.clone(), xmm_m128.clone(), xmm0.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpblendw_rvmi_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpblendw_rvmi::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpblendvb_rvmr_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem, xmm3: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm3 = cranelift_assembler_x64::Xmm::new(xmm3); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpblendvb_rvmr::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone(), xmm3.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vblendvps_rvmr_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem, xmm3: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm3 = cranelift_assembler_x64::Xmm::new(xmm3); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vblendvps_rvmr::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone(), xmm3.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vblendvpd_rvmr_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem, xmm3: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm3 = cranelift_assembler_x64::Xmm::new(xmm3); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vblendvpd_rvmr::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone(), xmm3.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_shufpd_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::shufpd_a::new(xmm1.clone(), xmm_m128.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vshufpd_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vshufpd_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_shufps_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::shufps_a::new(xmm1.clone(), xmm_m128.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vshufps_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vshufps_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pshufb_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pshufb_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pshufd_a_raw(&mut self, xmm_m128: &XmmMemAligned, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pshufd_a::new(xmm1.clone(), xmm_m128.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pshuflw_a_raw(&mut self, xmm_m128: &XmmMemAligned, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pshuflw_a::new(xmm1.clone(), xmm_m128.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pshufhw_a_raw(&mut self, xmm_m128: &XmmMemAligned, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pshufhw_a::new(xmm1.clone(), xmm_m128.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpshufb_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpshufb_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpshufd_a_raw(&mut self, xmm_m128: &XmmMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpshufd_a::new(xmm1.clone(), xmm_m128.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpshuflw_a_raw(&mut self, xmm_m128: &XmmMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpshuflw_a::new(xmm1.clone(), xmm_m128.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpshufhw_a_raw(&mut self, xmm_m128: &XmmMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpshufhw_a::new(xmm1.clone(), xmm_m128.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vbroadcastss_a_m_raw(&mut self, m32: &SyntheticAmode) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let m32 = self.convert_amode_to_assembler_amode(m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vbroadcastss_a_m::new(xmm1.clone(), m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vbroadcastss_a_r_raw(&mut self, xmm2: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vbroadcastss_a_r::new(xmm1.clone(), xmm2.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpbroadcastb_a_raw(&mut self, xmm_m8: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m8 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpbroadcastb_a::new(xmm1.clone(), xmm_m8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpbroadcastw_a_raw(&mut self, xmm_m16: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m16 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpbroadcastw_a::new(xmm1.clone(), xmm_m16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpbroadcastd_a_raw(&mut self, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpbroadcastd_a::new(xmm1.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpbroadcastq_a_raw(&mut self, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpbroadcastq_a::new(xmm1.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpermi2b_a_raw(&mut self, xmm1: Xmm, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpermi2b_a::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_maxss_a_raw(&mut self, xmm1: Xmm, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::maxss_a::new(xmm1.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_maxsd_a_raw(&mut self, xmm1: Xmm, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::maxsd_a::new(xmm1.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_maxps_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::maxps_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_maxpd_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::maxpd_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vmaxss_b_raw(&mut self, xmm2: Xmm, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmaxss_b::new(xmm1.clone(), xmm2.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vmaxsd_b_raw(&mut self, xmm2: Xmm, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmaxsd_b::new(xmm1.clone(), xmm2.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vmaxps_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmaxps_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vmaxpd_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmaxpd_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pmaxsb_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pmaxsb_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pmaxsw_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pmaxsw_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pmaxsd_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pmaxsd_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pmaxub_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pmaxub_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pmaxuw_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pmaxuw_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pmaxud_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pmaxud_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpmaxsb_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpmaxsb_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpmaxsw_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpmaxsw_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpmaxsd_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpmaxsd_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpmaxub_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpmaxub_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpmaxuw_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpmaxuw_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpmaxud_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpmaxud_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_minss_a_raw(&mut self, xmm1: Xmm, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::minss_a::new(xmm1.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_minsd_a_raw(&mut self, xmm1: Xmm, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::minsd_a::new(xmm1.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_minps_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::minps_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_minpd_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::minpd_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vminss_b_raw(&mut self, xmm2: Xmm, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vminss_b::new(xmm1.clone(), xmm2.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vminsd_b_raw(&mut self, xmm2: Xmm, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vminsd_b::new(xmm1.clone(), xmm2.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vminps_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vminps_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vminpd_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vminpd_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pminsb_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pminsb_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pminsw_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pminsw_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pminsd_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pminsd_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pminub_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pminub_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pminuw_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pminuw_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pminud_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pminud_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpminsb_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpminsb_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpminsw_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpminsw_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpminsd_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpminsd_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpminub_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpminub_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpminuw_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpminuw_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpminud_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpminud_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_mfence_zo_raw(&mut self, ) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::mfence_zo::new().into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_sfence_zo_raw(&mut self, ) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::sfence_zo::new().into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lfence_zo_raw(&mut self, ) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lfence_zo::new().into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_hlt_zo_raw(&mut self, ) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::hlt_zo::new().into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_ud2_zo_raw(&mut self, trap: &TrapCode) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::ud2_zo::new(cranelift_assembler_x64::TrapCode(trap.as_raw())).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_int3_zo_raw(&mut self, ) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::int3_zo::new().into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_retq_zo_raw(&mut self, ) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::retq_zo::new().into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_retq_i_raw(&mut self, imm16: u16) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm16 = cranelift_assembler_x64::Imm16::new(imm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::retq_i::new(imm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_leaw_rm_raw(&mut self, m16: &SyntheticAmode) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let m16 = self.convert_amode_to_assembler_amode(m16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::leaw_rm::new(r16.clone(), m16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_leal_rm_raw(&mut self, m32: &SyntheticAmode) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let m32 = self.convert_amode_to_assembler_amode(m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::leal_rm::new(r32.clone(), m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_leaq_rm_raw(&mut self, m64: &SyntheticAmode) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let m64 = self.convert_amode_to_assembler_amode(m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::leaq_rm::new(r64.clone(), m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_callq_d_raw(&mut self, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::callq_d::new(imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_callq_m_raw(&mut self, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::callq_m::new(rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_movb_mr_raw(&mut self, rm8: &GprMem, r8: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm8 = self.convert_gpr_mem_to_assembler_write_gpr_mem(rm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r8 = cranelift_assembler_x64::Gpr::new(r8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movb_mr::new(rm8.clone(), r8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm8 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_movw_mr_raw(&mut self, rm16: &GprMem, r16: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm16 = self.convert_gpr_mem_to_assembler_write_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r16 = cranelift_assembler_x64::Gpr::new(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movw_mr::new(rm16.clone(), r16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm16 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_movl_mr_raw(&mut self, rm32: &GprMem, r32: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_write_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r32 = cranelift_assembler_x64::Gpr::new(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movl_mr::new(rm32.clone(), r32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm32 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_movq_mr_raw(&mut self, rm64: &GprMem, r64: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm64 = self.convert_gpr_mem_to_assembler_write_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r64 = cranelift_assembler_x64::Gpr::new(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movq_mr::new(rm64.clone(), r64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm64 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_movb_rm_raw(&mut self, rm8: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r8 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm8 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movb_rm::new(r8.clone(), rm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r8.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_movw_rm_raw(&mut self, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movw_rm::new(r16.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_movl_rm_raw(&mut self, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movl_rm::new(r32.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_movq_rm_raw(&mut self, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movq_rm::new(r64.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_movb_oi_raw(&mut self, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r8 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movb_oi::new(r8.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r8.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_movw_oi_raw(&mut self, imm16: u16) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm16 = cranelift_assembler_x64::Imm16::new(imm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movw_oi::new(r16.clone(), imm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_movl_oi_raw(&mut self, imm32: u32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Imm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movl_oi::new(r32.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_movabsq_oi_raw(&mut self, imm64: u64) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm64 = cranelift_assembler_x64::Imm64::new(imm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movabsq_oi::new(r64.clone(), imm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_movb_mi_raw(&mut self, rm8: &GprMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm8 = self.convert_gpr_mem_to_assembler_write_gpr_mem(rm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movb_mi::new(rm8.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm8 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_movw_mi_raw(&mut self, rm16: &GprMem, imm16: u16) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm16 = self.convert_gpr_mem_to_assembler_write_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm16 = cranelift_assembler_x64::Imm16::new(imm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movw_mi::new(rm16.clone(), imm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm16 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_movl_mi_raw(&mut self, rm32: &GprMem, imm32: u32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_write_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Imm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movl_mi::new(rm32.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm32 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_movq_mi_sxl_raw(&mut self, rm64: &GprMem, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm64 = self.convert_gpr_mem_to_assembler_write_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movq_mi_sxl::new(rm64.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm64 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_movsbw_rm_raw(&mut self, rm8: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm8 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movsbw_rm::new(r16.clone(), rm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_movsbl_rm_raw(&mut self, rm8: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm8 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movsbl_rm::new(r32.clone(), rm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_movsbq_rm_raw(&mut self, rm8: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm8 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movsbq_rm::new(r64.clone(), rm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_movsww_rm_raw(&mut self, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movsww_rm::new(r16.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_movswl_rm_raw(&mut self, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movswl_rm::new(r32.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_movswq_rm_raw(&mut self, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movswq_rm::new(r64.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_movslq_rm_raw(&mut self, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movslq_rm::new(r64.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_movzbw_rm_raw(&mut self, rm8: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm8 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movzbw_rm::new(r16.clone(), rm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_movzbl_rm_raw(&mut self, rm8: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm8 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movzbl_rm::new(r32.clone(), rm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_movzbq_rm_raw(&mut self, rm8: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm8 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movzbq_rm::new(r64.clone(), rm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_movzww_rm_raw(&mut self, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movzww_rm::new(r16.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_movzwl_rm_raw(&mut self, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movzwl_rm::new(r32.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_movzwq_rm_raw(&mut self, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movzwq_rm::new(r64.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_movd_a_raw(&mut self, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movd_a::new(xmm1.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_movq_a_raw(&mut self, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movq_a::new(xmm1.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_movd_b_raw(&mut self, rm32: &GprMem, xmm2: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_write_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movd_b::new(rm32.clone(), xmm2.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm32 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_movq_b_raw(&mut self, rm64: &GprMem, xmm2: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm64 = self.convert_gpr_mem_to_assembler_write_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movq_b::new(rm64.clone(), xmm2.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm64 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_vmovd_a_raw(&mut self, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmovd_a::new(xmm1.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vmovq_a_raw(&mut self, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmovq_a::new(xmm1.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vmovd_b_raw(&mut self, rm32: &GprMem, xmm2: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_write_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmovd_b::new(rm32.clone(), xmm2.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm32 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_vmovq_b_raw(&mut self, rm64: &GprMem, xmm2: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm64 = self.convert_gpr_mem_to_assembler_write_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmovq_b::new(rm64.clone(), xmm2.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm64 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_movss_a_m_raw(&mut self, m32: &SyntheticAmode) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let m32 = self.convert_amode_to_assembler_amode(m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movss_a_m::new(xmm1.clone(), m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_movss_a_r_raw(&mut self, xmm1: Xmm, xmm2: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movss_a_r::new(xmm1.clone(), xmm2.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_movss_c_m_raw(&mut self, m32: &SyntheticAmode, xmm1: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m32 = self.convert_amode_to_assembler_amode(m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm1 = cranelift_assembler_x64::Xmm::new(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movss_c_m::new(m32.clone(), xmm1.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_movsd_a_m_raw(&mut self, m64: &SyntheticAmode) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let m64 = self.convert_amode_to_assembler_amode(m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movsd_a_m::new(xmm1.clone(), m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_movsd_a_r_raw(&mut self, xmm1: Xmm, xmm2: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movsd_a_r::new(xmm1.clone(), xmm2.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_movsd_c_m_raw(&mut self, m64: &SyntheticAmode, xmm1: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m64 = self.convert_amode_to_assembler_amode(m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm1 = cranelift_assembler_x64::Xmm::new(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movsd_c_m::new(m64.clone(), xmm1.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_vmovss_d_raw(&mut self, m32: &SyntheticAmode) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let m32 = self.convert_amode_to_assembler_amode(m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmovss_d::new(xmm1.clone(), m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vmovss_b_raw(&mut self, xmm2: Xmm, xmm3: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm3 = cranelift_assembler_x64::Xmm::new(xmm3); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmovss_b::new(xmm1.clone(), xmm2.clone(), xmm3.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vmovss_c_m_raw(&mut self, m32: &SyntheticAmode, xmm1: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m32 = self.convert_amode_to_assembler_amode(m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm1 = cranelift_assembler_x64::Xmm::new(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmovss_c_m::new(m32.clone(), xmm1.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_vmovsd_d_raw(&mut self, m64: &SyntheticAmode) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let m64 = self.convert_amode_to_assembler_amode(m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmovsd_d::new(xmm1.clone(), m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vmovsd_b_raw(&mut self, xmm2: Xmm, xmm3: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm3 = cranelift_assembler_x64::Xmm::new(xmm3); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmovsd_b::new(xmm1.clone(), xmm2.clone(), xmm3.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vmovsd_c_m_raw(&mut self, m64: &SyntheticAmode, xmm1: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m64 = self.convert_amode_to_assembler_amode(m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm1 = cranelift_assembler_x64::Xmm::new(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmovsd_c_m::new(m64.clone(), xmm1.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_movapd_a_raw(&mut self, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movapd_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_movapd_b_raw(&mut self, xmm_m128: &XmmMemAligned, xmm1: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm_m128 = self.convert_xmm_mem_to_assembler_write_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm1 = cranelift_assembler_x64::Xmm::new(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movapd_b::new(xmm_m128.clone(), xmm1.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match xmm_m128 {
                cranelift_assembler_x64::XmmMem::Xmm(reg) =>  {
                    let xmm = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetXmm { inst, xmm }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::XmmMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_movaps_a_raw(&mut self, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movaps_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_movaps_b_raw(&mut self, xmm_m128: &XmmMemAligned, xmm1: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm_m128 = self.convert_xmm_mem_to_assembler_write_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm1 = cranelift_assembler_x64::Xmm::new(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movaps_b::new(xmm_m128.clone(), xmm1.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match xmm_m128 {
                cranelift_assembler_x64::XmmMem::Xmm(reg) =>  {
                    let xmm = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetXmm { inst, xmm }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::XmmMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_movdqa_a_raw(&mut self, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movdqa_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_movdqa_b_raw(&mut self, xmm_m128: &XmmMemAligned, xmm1: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm_m128 = self.convert_xmm_mem_to_assembler_write_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm1 = cranelift_assembler_x64::Xmm::new(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movdqa_b::new(xmm_m128.clone(), xmm1.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match xmm_m128 {
                cranelift_assembler_x64::XmmMem::Xmm(reg) =>  {
                    let xmm = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetXmm { inst, xmm }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::XmmMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_vmovapd_a_raw(&mut self, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmovapd_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vmovapd_b_raw(&mut self, xmm_m128: &XmmMemAligned, xmm1: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm_m128 = self.convert_xmm_mem_to_assembler_write_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm1 = cranelift_assembler_x64::Xmm::new(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmovapd_b::new(xmm_m128.clone(), xmm1.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match xmm_m128 {
                cranelift_assembler_x64::XmmMem::Xmm(reg) =>  {
                    let xmm = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetXmm { inst, xmm }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::XmmMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_vmovaps_a_raw(&mut self, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmovaps_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vmovaps_b_raw(&mut self, xmm_m128: &XmmMemAligned, xmm1: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm_m128 = self.convert_xmm_mem_to_assembler_write_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm1 = cranelift_assembler_x64::Xmm::new(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmovaps_b::new(xmm_m128.clone(), xmm1.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match xmm_m128 {
                cranelift_assembler_x64::XmmMem::Xmm(reg) =>  {
                    let xmm = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetXmm { inst, xmm }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::XmmMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_vmovdqa_a_raw(&mut self, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmovdqa_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vmovdqa_b_raw(&mut self, xmm_m128: &XmmMemAligned, xmm1: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm_m128 = self.convert_xmm_mem_to_assembler_write_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm1 = cranelift_assembler_x64::Xmm::new(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmovdqa_b::new(xmm_m128.clone(), xmm1.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match xmm_m128 {
                cranelift_assembler_x64::XmmMem::Xmm(reg) =>  {
                    let xmm = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetXmm { inst, xmm }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::XmmMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_movupd_a_raw(&mut self, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movupd_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_movupd_b_raw(&mut self, xmm_m128: &XmmMem, xmm1: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm_m128 = self.convert_xmm_mem_to_assembler_write_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm1 = cranelift_assembler_x64::Xmm::new(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movupd_b::new(xmm_m128.clone(), xmm1.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match xmm_m128 {
                cranelift_assembler_x64::XmmMem::Xmm(reg) =>  {
                    let xmm = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetXmm { inst, xmm }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::XmmMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_movups_a_raw(&mut self, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movups_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_movups_b_raw(&mut self, xmm_m128: &XmmMem, xmm1: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm_m128 = self.convert_xmm_mem_to_assembler_write_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm1 = cranelift_assembler_x64::Xmm::new(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movups_b::new(xmm_m128.clone(), xmm1.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match xmm_m128 {
                cranelift_assembler_x64::XmmMem::Xmm(reg) =>  {
                    let xmm = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetXmm { inst, xmm }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::XmmMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_movdqu_a_raw(&mut self, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movdqu_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_movdqu_b_raw(&mut self, xmm_m128: &XmmMem, xmm1: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm_m128 = self.convert_xmm_mem_to_assembler_write_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm1 = cranelift_assembler_x64::Xmm::new(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::movdqu_b::new(xmm_m128.clone(), xmm1.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match xmm_m128 {
                cranelift_assembler_x64::XmmMem::Xmm(reg) =>  {
                    let xmm = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetXmm { inst, xmm }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::XmmMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_vmovupd_a_raw(&mut self, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmovupd_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vmovupd_b_raw(&mut self, xmm_m128: &XmmMem, xmm1: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm_m128 = self.convert_xmm_mem_to_assembler_write_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm1 = cranelift_assembler_x64::Xmm::new(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmovupd_b::new(xmm_m128.clone(), xmm1.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match xmm_m128 {
                cranelift_assembler_x64::XmmMem::Xmm(reg) =>  {
                    let xmm = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetXmm { inst, xmm }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::XmmMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_vmovups_a_raw(&mut self, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmovups_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vmovups_b_raw(&mut self, xmm_m128: &XmmMem, xmm1: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm_m128 = self.convert_xmm_mem_to_assembler_write_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm1 = cranelift_assembler_x64::Xmm::new(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmovups_b::new(xmm_m128.clone(), xmm1.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match xmm_m128 {
                cranelift_assembler_x64::XmmMem::Xmm(reg) =>  {
                    let xmm = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetXmm { inst, xmm }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::XmmMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_vmovdqu_a_raw(&mut self, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmovdqu_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vmovdqu_b_raw(&mut self, xmm_m128: &XmmMem, xmm1: Xmm) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm_m128 = self.convert_xmm_mem_to_assembler_write_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm1 = cranelift_assembler_x64::Xmm::new(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmovdqu_b::new(xmm_m128.clone(), xmm1.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match xmm_m128 {
                cranelift_assembler_x64::XmmMem::Xmm(reg) =>  {
                    let xmm = reg.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetXmm { inst, xmm }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::XmmMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_pmovsxbw_a_raw(&mut self, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pmovsxbw_a::new(xmm1.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pmovsxbd_a_raw(&mut self, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pmovsxbd_a::new(xmm1.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pmovsxbq_a_raw(&mut self, xmm_m16: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m16 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pmovsxbq_a::new(xmm1.clone(), xmm_m16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pmovsxwd_a_raw(&mut self, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pmovsxwd_a::new(xmm1.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pmovsxwq_a_raw(&mut self, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pmovsxwq_a::new(xmm1.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pmovsxdq_a_raw(&mut self, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pmovsxdq_a::new(xmm1.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpmovsxbw_a_raw(&mut self, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpmovsxbw_a::new(xmm1.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpmovsxbd_a_raw(&mut self, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpmovsxbd_a::new(xmm1.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpmovsxbq_a_raw(&mut self, xmm_m16: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m16 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpmovsxbq_a::new(xmm1.clone(), xmm_m16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpmovsxwd_a_raw(&mut self, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpmovsxwd_a::new(xmm1.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpmovsxwq_a_raw(&mut self, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpmovsxwq_a::new(xmm1.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpmovsxdq_a_raw(&mut self, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpmovsxdq_a::new(xmm1.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pmovzxbw_a_raw(&mut self, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pmovzxbw_a::new(xmm1.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pmovzxbd_a_raw(&mut self, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pmovzxbd_a::new(xmm1.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pmovzxbq_a_raw(&mut self, xmm_m16: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m16 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pmovzxbq_a::new(xmm1.clone(), xmm_m16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pmovzxwd_a_raw(&mut self, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pmovzxwd_a::new(xmm1.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pmovzxwq_a_raw(&mut self, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pmovzxwq_a::new(xmm1.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pmovzxdq_a_raw(&mut self, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pmovzxdq_a::new(xmm1.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpmovzxbw_a_raw(&mut self, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpmovzxbw_a::new(xmm1.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpmovzxbd_a_raw(&mut self, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpmovzxbd_a::new(xmm1.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpmovzxbq_a_raw(&mut self, xmm_m16: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m16 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpmovzxbq_a::new(xmm1.clone(), xmm_m16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpmovzxwd_a_raw(&mut self, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpmovzxwd_a::new(xmm1.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpmovzxwq_a_raw(&mut self, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpmovzxwq_a::new(xmm1.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpmovzxdq_a_raw(&mut self, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpmovzxdq_a::new(xmm1.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_mulb_m_raw(&mut self, ax: Gpr, rm8: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let ax = self.convert_gpr_to_assembler_fixed_read_write_gpr(ax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm8 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::mulb_m::new(ax.clone(), rm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = ax.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_mulw_m_raw(&mut self, ax: Gpr, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let ax = self.convert_gpr_to_assembler_fixed_read_write_gpr(ax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let dx = cranelift_assembler_x64::Fixed(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::mulw_m::new(ax.clone(), dx.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let one = ax.as_ref().write.to_reg().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:194
            let two = dx.as_ref().to_reg().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:195
            let regs = ValueRegs::two(one, two); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:196
            AssemblerOutputs::RetValueRegs { inst, regs }
        }
        fn x64_mull_m_raw(&mut self, eax: Gpr, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let eax = self.convert_gpr_to_assembler_fixed_read_write_gpr(eax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let edx = cranelift_assembler_x64::Fixed(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::mull_m::new(eax.clone(), edx.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let one = eax.as_ref().write.to_reg().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:194
            let two = edx.as_ref().to_reg().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:195
            let regs = ValueRegs::two(one, two); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:196
            AssemblerOutputs::RetValueRegs { inst, regs }
        }
        fn x64_mulq_m_raw(&mut self, rax: Gpr, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rax = self.convert_gpr_to_assembler_fixed_read_write_gpr(rax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rdx = cranelift_assembler_x64::Fixed(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::mulq_m::new(rax.clone(), rdx.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let one = rax.as_ref().write.to_reg().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:194
            let two = rdx.as_ref().to_reg().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:195
            let regs = ValueRegs::two(one, two); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:196
            AssemblerOutputs::RetValueRegs { inst, regs }
        }
        fn x64_imulb_m_raw(&mut self, ax: Gpr, rm8: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let ax = self.convert_gpr_to_assembler_fixed_read_write_gpr(ax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm8 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::imulb_m::new(ax.clone(), rm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = ax.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_imulw_m_raw(&mut self, ax: Gpr, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let ax = self.convert_gpr_to_assembler_fixed_read_write_gpr(ax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let dx = cranelift_assembler_x64::Fixed(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::imulw_m::new(ax.clone(), dx.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let one = ax.as_ref().write.to_reg().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:194
            let two = dx.as_ref().to_reg().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:195
            let regs = ValueRegs::two(one, two); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:196
            AssemblerOutputs::RetValueRegs { inst, regs }
        }
        fn x64_imull_m_raw(&mut self, eax: Gpr, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let eax = self.convert_gpr_to_assembler_fixed_read_write_gpr(eax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let edx = cranelift_assembler_x64::Fixed(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::imull_m::new(eax.clone(), edx.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let one = eax.as_ref().write.to_reg().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:194
            let two = edx.as_ref().to_reg().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:195
            let regs = ValueRegs::two(one, two); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:196
            AssemblerOutputs::RetValueRegs { inst, regs }
        }
        fn x64_imulq_m_raw(&mut self, rax: Gpr, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rax = self.convert_gpr_to_assembler_fixed_read_write_gpr(rax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rdx = cranelift_assembler_x64::Fixed(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::imulq_m::new(rax.clone(), rdx.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let one = rax.as_ref().write.to_reg().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:194
            let two = rdx.as_ref().to_reg().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:195
            let regs = ValueRegs::two(one, two); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:196
            AssemblerOutputs::RetValueRegs { inst, regs }
        }
        fn x64_imulw_rm_raw(&mut self, r16: Gpr, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = self.convert_gpr_to_assembler_read_write_gpr(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::imulw_rm::new(r16.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_imull_rm_raw(&mut self, r32: Gpr, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = self.convert_gpr_to_assembler_read_write_gpr(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::imull_rm::new(r32.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_imulq_rm_raw(&mut self, r64: Gpr, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = self.convert_gpr_to_assembler_read_write_gpr(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::imulq_rm::new(r64.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_imulw_rmi_sxb_raw(&mut self, rm16: &GprMem, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::imulw_rmi_sxb::new(r16.clone(), rm16.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_imull_rmi_sxb_raw(&mut self, rm32: &GprMem, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::imull_rmi_sxb::new(r32.clone(), rm32.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_imulq_rmi_sxb_raw(&mut self, rm64: &GprMem, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::imulq_rmi_sxb::new(r64.clone(), rm64.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_imulw_rmi_raw(&mut self, rm16: &GprMem, imm16: u16) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm16 = cranelift_assembler_x64::Imm16::new(imm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::imulw_rmi::new(r16.clone(), rm16.clone(), imm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_imull_rmi_raw(&mut self, rm32: &GprMem, imm32: u32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Imm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::imull_rmi::new(r32.clone(), rm32.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_imulq_rmi_sxl_raw(&mut self, rm64: &GprMem, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::imulq_rmi_sxl::new(r64.clone(), rm64.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_mulxl_rvm_raw(&mut self, rm32: &GprMem, edx: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32a = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r32b = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let edx = cranelift_assembler_x64::Fixed(edx); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::mulxl_rvm::new(r32a.clone(), r32b.clone(), rm32.clone(), edx.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let one = r32a.as_ref().to_reg().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:194
            let two = r32b.as_ref().to_reg().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:195
            let regs = ValueRegs::two(one, two); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:196
            AssemblerOutputs::RetValueRegs { inst, regs }
        }
        fn x64_mulxq_rvm_raw(&mut self, rm64: &GprMem, rdx: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64a = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r64b = cranelift_assembler_x64::Gpr::new(self.temp_writable_gpr()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rdx = cranelift_assembler_x64::Fixed(rdx); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::mulxq_rvm::new(r64a.clone(), r64b.clone(), rm64.clone(), rdx.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let one = r64a.as_ref().to_reg().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:194
            let two = r64b.as_ref().to_reg().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:195
            let regs = ValueRegs::two(one, two); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:196
            AssemblerOutputs::RetValueRegs { inst, regs }
        }
        fn x64_mulss_a_raw(&mut self, xmm1: Xmm, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::mulss_a::new(xmm1.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_mulsd_a_raw(&mut self, xmm1: Xmm, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::mulsd_a::new(xmm1.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_mulps_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::mulps_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_mulpd_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::mulpd_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pmuldq_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pmuldq_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pmulhrsw_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pmulhrsw_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pmulhuw_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pmulhuw_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pmulhw_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pmulhw_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pmulld_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pmulld_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pmullw_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pmullw_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pmuludq_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pmuludq_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vmulss_b_raw(&mut self, xmm2: Xmm, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmulss_b::new(xmm1.clone(), xmm2.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vmulsd_b_raw(&mut self, xmm2: Xmm, xmm_m64: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmulsd_b::new(xmm1.clone(), xmm2.clone(), xmm_m64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vmulps_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmulps_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vmulpd_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vmulpd_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpmuldq_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpmuldq_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpmulhrsw_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpmulhrsw_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpmulhuw_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpmulhuw_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpmulhw_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpmulhw_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpmulld_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpmulld_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpmullw_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpmullw_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpmuludq_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpmuludq_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpmulld_c_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpmulld_c::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpmullq_c_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpmullq_c::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_negb_m_raw(&mut self, rm8: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm8 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::negb_m::new(rm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm8 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_negw_m_raw(&mut self, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm16 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::negw_m::new(rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm16 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_negl_m_raw(&mut self, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::negl_m::new(rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm32 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_negq_m_raw(&mut self, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm64 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::negq_m::new(rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm64 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_notb_m_raw(&mut self, rm8: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm8 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::notb_m::new(rm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm8 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_notw_m_raw(&mut self, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm16 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::notw_m::new(rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm16 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_notl_m_raw(&mut self, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::notl_m::new(rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm32 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_notq_m_raw(&mut self, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm64 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::notq_m::new(rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm64 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_nop_zo_raw(&mut self, ) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::nop_zo::new().into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_nopl_m_raw(&mut self, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::nopl_m::new(rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_nop_1b_raw(&mut self, ) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::nop_1b::new().into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_nop_2b_raw(&mut self, ) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::nop_2b::new().into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_nop_3b_raw(&mut self, ) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::nop_3b::new().into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_nop_4b_raw(&mut self, ) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::nop_4b::new().into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_nop_5b_raw(&mut self, ) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::nop_5b::new().into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_nop_6b_raw(&mut self, ) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::nop_6b::new().into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_nop_7b_raw(&mut self, ) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::nop_7b::new().into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_nop_8b_raw(&mut self, ) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::nop_8b::new().into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_nop_9b_raw(&mut self, ) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::nop_9b::new().into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_orb_i_raw(&mut self, al: Gpr, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let al = self.convert_gpr_to_assembler_fixed_read_write_gpr(al); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::orb_i::new(al.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = al.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_orw_i_raw(&mut self, ax: Gpr, imm16: u16) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let ax = self.convert_gpr_to_assembler_fixed_read_write_gpr(ax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm16 = cranelift_assembler_x64::Imm16::new(imm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::orw_i::new(ax.clone(), imm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = ax.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_orl_i_raw(&mut self, eax: Gpr, imm32: u32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let eax = self.convert_gpr_to_assembler_fixed_read_write_gpr(eax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Imm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::orl_i::new(eax.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = eax.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_orq_i_sxl_raw(&mut self, rax: Gpr, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rax = self.convert_gpr_to_assembler_fixed_read_write_gpr(rax); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::orq_i_sxl::new(rax.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = rax.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_orb_mi_raw(&mut self, rm8: &GprMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm8 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::orb_mi::new(rm8.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm8 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_orw_mi_raw(&mut self, rm16: &GprMem, imm16: u16) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm16 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm16 = cranelift_assembler_x64::Imm16::new(imm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::orw_mi::new(rm16.clone(), imm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm16 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_orl_mi_raw(&mut self, rm32: &GprMem, imm32: u32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Imm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::orl_mi::new(rm32.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm32 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_orq_mi_sxl_raw(&mut self, rm64: &GprMem, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm64 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::orq_mi_sxl::new(rm64.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm64 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_orl_mi_sxb_raw(&mut self, rm32: &GprMem, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::orl_mi_sxb::new(rm32.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm32 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_orq_mi_sxb_raw(&mut self, rm64: &GprMem, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm64 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::orq_mi_sxb::new(rm64.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm64 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_orb_mr_raw(&mut self, rm8: &GprMem, r8: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm8 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r8 = cranelift_assembler_x64::Gpr::new(r8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::orb_mr::new(rm8.clone(), r8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm8 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_orw_mr_raw(&mut self, rm16: &GprMem, r16: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm16 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r16 = cranelift_assembler_x64::Gpr::new(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::orw_mr::new(rm16.clone(), r16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm16 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_orl_mr_raw(&mut self, rm32: &GprMem, r32: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm32 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r32 = cranelift_assembler_x64::Gpr::new(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::orl_mr::new(rm32.clone(), r32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm32 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_orq_mr_raw(&mut self, rm64: &GprMem, r64: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let rm64 = self.convert_gpr_mem_to_assembler_read_write_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r64 = cranelift_assembler_x64::Gpr::new(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::orq_mr::new(rm64.clone(), r64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            match rm64 {
                cranelift_assembler_x64::GprMem::Gpr(reg) =>  {
                    let gpr = reg.write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:180
                    AssemblerOutputs::RetGpr { inst, gpr }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:181
                }
                cranelift_assembler_x64::GprMem::Mem(_) =>  {
                    AssemblerOutputs::SideEffect { inst }  // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:184
                }
            }
        }
        fn x64_orb_rm_raw(&mut self, r8: Gpr, rm8: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r8 = self.convert_gpr_to_assembler_read_write_gpr(r8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm8 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::orb_rm::new(r8.clone(), rm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r8.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_orw_rm_raw(&mut self, r16: Gpr, rm16: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r16 = self.convert_gpr_to_assembler_read_write_gpr(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm16 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::orw_rm::new(r16.clone(), rm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r16.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_orl_rm_raw(&mut self, r32: Gpr, rm32: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r32 = self.convert_gpr_to_assembler_read_write_gpr(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm32 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::orl_rm::new(r32.clone(), rm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r32.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_orq_rm_raw(&mut self, r64: Gpr, rm64: &GprMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let r64 = self.convert_gpr_to_assembler_read_write_gpr(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let rm64 = self.convert_gpr_mem_to_assembler_read_gpr_mem(rm64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::orq_rm::new(r64.clone(), rm64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let gpr = r64.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetGpr { inst, gpr }
        }
        fn x64_lock_orb_mi_raw(&mut self, m8: &SyntheticAmode, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m8 = self.convert_amode_to_assembler_amode(m8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_orb_mi::new(m8.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_orw_mi_raw(&mut self, m16: &SyntheticAmode, imm16: u16) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m16 = self.convert_amode_to_assembler_amode(m16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm16 = cranelift_assembler_x64::Imm16::new(imm16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_orw_mi::new(m16.clone(), imm16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_orl_mi_raw(&mut self, m32: &SyntheticAmode, imm32: u32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m32 = self.convert_amode_to_assembler_amode(m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Imm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_orl_mi::new(m32.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_orq_mi_sxl_raw(&mut self, m64: &SyntheticAmode, imm32: i32) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m64 = self.convert_amode_to_assembler_amode(m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm32 = cranelift_assembler_x64::Simm32::new(imm32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_orq_mi_sxl::new(m64.clone(), imm32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_orl_mi_sxb_raw(&mut self, m32: &SyntheticAmode, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m32 = self.convert_amode_to_assembler_amode(m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_orl_mi_sxb::new(m32.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_orq_mi_sxb_raw(&mut self, m64: &SyntheticAmode, imm8: i8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m64 = self.convert_amode_to_assembler_amode(m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Simm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_orq_mi_sxb::new(m64.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_orb_mr_raw(&mut self, m8: &SyntheticAmode, r8: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m8 = self.convert_amode_to_assembler_amode(m8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r8 = cranelift_assembler_x64::Gpr::new(r8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_orb_mr::new(m8.clone(), r8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_orw_mr_raw(&mut self, m16: &SyntheticAmode, r16: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m16 = self.convert_amode_to_assembler_amode(m16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r16 = cranelift_assembler_x64::Gpr::new(r16); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_orw_mr::new(m16.clone(), r16.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_orl_mr_raw(&mut self, m32: &SyntheticAmode, r32: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m32 = self.convert_amode_to_assembler_amode(m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r32 = cranelift_assembler_x64::Gpr::new(r32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_orl_mr::new(m32.clone(), r32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_lock_orq_mr_raw(&mut self, m64: &SyntheticAmode, r64: Gpr) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let m64 = self.convert_amode_to_assembler_amode(m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let r64 = cranelift_assembler_x64::Gpr::new(r64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::lock_orq_mr::new(m64.clone(), r64.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            AssemblerOutputs::SideEffect { inst }
        }
        fn x64_orps_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::orps_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_orpd_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::orpd_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_por_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::por_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vorps_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vorps_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vorpd_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vorpd_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpor_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpor_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_packsswb_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::packsswb_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_packssdw_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::packssdw_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpacksswb_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpacksswb_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpackssdw_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpackssdw_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_packuswb_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::packuswb_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_packusdw_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::packusdw_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpackuswb_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpackuswb_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpackusdw_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpackusdw_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pmaddwd_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pmaddwd_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpmaddwd_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpmaddwd_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_pmaddubsw_a_raw(&mut self, xmm1: Xmm, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = self.convert_xmm_to_assembler_read_write_xmm(xmm1); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::pmaddubsw_a::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().write.to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vpmaddubsw_b_raw(&mut self, xmm2: Xmm, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vpmaddubsw_b::new(xmm1.clone(), xmm2.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_rcpps_rm_raw(&mut self, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::rcpps_rm::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_rcpss_rm_raw(&mut self, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::rcpss_rm::new(xmm1.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_rsqrtps_rm_raw(&mut self, xmm_m128: &XmmMemAligned) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::rsqrtps_rm::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_rsqrtss_rm_raw(&mut self, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::rsqrtss_rm::new(xmm1.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vrcpps_rm_raw(&mut self, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vrcpps_rm::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vrcpss_rvm_raw(&mut self, xmm2: Xmm, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vrcpss_rvm::new(xmm1.clone(), xmm2.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vrsqrtps_rm_raw(&mut self, xmm_m128: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vrsqrtps_rm::new(xmm1.clone(), xmm_m128.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_vrsqrtss_rvm_raw(&mut self, xmm2: Xmm, xmm_m32: &XmmMem) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm2 = cranelift_assembler_x64::Xmm::new(xmm2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::vrsqrtss_rvm::new(xmm1.clone(), xmm2.clone(), xmm_m32.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_roundpd_rmi_raw(&mut self, xmm_m128: &XmmMemAligned, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::roundpd_rmi::new(xmm1.clone(), xmm_m128.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_roundps_rmi_raw(&mut self, xmm_m128: &XmmMemAligned, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m128 = self.convert_xmm_mem_to_assembler_read_xmm_mem_aligned(xmm_m128); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::roundps_rmi::new(xmm1.clone(), xmm_m128.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_roundsd_rmi_raw(&mut self, xmm_m64: &XmmMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m64 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m64); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127

            // Build the instruction.
            let inst = cranelift_assembler_x64::inst::roundsd_rmi::new(xmm1.clone(), xmm_m64.clone(), imm8.clone()).into(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:140
            let inst = MInst::External { inst }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:144

            // Return a type ISLE can work with.
            let xmm = xmm1.as_ref().to_reg(); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:170
            AssemblerOutputs::RetXmm { inst, xmm }
        }
        fn x64_roundss_rmi_raw(&mut self, xmm_m32: &XmmMem, imm8: u8) -> AssemblerOutputs {
            // Convert ISLE types to assembler types.
            let xmm1 = cranelift_assembler_x64::Xmm::new(self.temp_writable_xmm()); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let xmm_m32 = self.convert_xmm_mem_to_assembler_read_xmm_mem(xmm_m32); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_asm.rs:127
            let imm8 = cranelift_assembler_x64::Imm8::new(imm8); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.125.4/src/gen_as