/* NodesMenu.c generated by valac 0.56.18, the Vala compiler
 * generated from NodesMenu.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <granite.h>
#include <stdlib.h>
#include <string.h>
#include <handy.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_NODES_MENU (nodes_menu_get_type ())
#define NODES_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODES_MENU, NodesMenu))
#define NODES_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODES_MENU, NodesMenuClass))
#define IS_NODES_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODES_MENU))
#define IS_NODES_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODES_MENU))
#define NODES_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODES_MENU, NodesMenuClass))

typedef struct _NodesMenu NodesMenu;
typedef struct _NodesMenuClass NodesMenuClass;
typedef struct _NodesMenuPrivate NodesMenuPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;
enum  {
	NODES_MENU_0_PROPERTY,
	NODES_MENU_NUM_PROPERTIES
};
static GParamSpec* nodes_menu_properties[NODES_MENU_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

struct _NodesMenu {
	GtkMenu parent_instance;
	NodesMenuPrivate * priv;
};

struct _NodesMenuClass {
	GtkMenuClass parent_class;
};

struct _NodesMenuPrivate {
	DrawArea* _da;
	GtkMenuItem* _copy;
	GtkMenuItem* _cut;
	GtkMenuItem* _delete;
	GtkMenuItem* _task;
	GtkMenuItem* _fold;
	GtkMenuItem* _sequence;
	GtkMenuItem* _connect;
	GtkMenuItem* _link;
	GtkMenuItem* _link_colors;
	GtkMenuItem* _parent_link_colors;
	GtkMenuItem* _align;
	GtkMenuItem* _selnodes;
	GtkMenuItem* _selparent;
	GtkMenuItem* _selchildren;
};

static gint NodesMenu_private_offset;
static gpointer nodes_menu_parent_class = NULL;

VALA_EXTERN GType nodes_menu_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NodesMenu, g_object_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN NodesMenu* nodes_menu_new (DrawArea* da,
                           GtkAccelGroup* accel_group);
VALA_EXTERN NodesMenu* nodes_menu_construct (GType object_type,
                                 DrawArea* da,
                                 GtkAccelGroup* accel_group);
static void nodes_menu_copy_nodes (NodesMenu* self);
static void _nodes_menu_copy_nodes_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                    gpointer self);
static void nodes_menu_cut_nodes (NodesMenu* self);
static void _nodes_menu_cut_nodes_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                   gpointer self);
static void nodes_menu_delete_nodes (NodesMenu* self);
static void _nodes_menu_delete_nodes_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                      gpointer self);
static void nodes_menu_toggle_tasks (NodesMenu* self);
static void _nodes_menu_toggle_tasks_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                      gpointer self);
static void nodes_menu_fold_nodes (NodesMenu* self);
static void _nodes_menu_fold_nodes_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                    gpointer self);
static void nodes_menu_toggle_sequences (NodesMenu* self);
static void _nodes_menu_toggle_sequences_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                          gpointer self);
static void nodes_menu_connect_nodes (NodesMenu* self);
static void _nodes_menu_connect_nodes_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                       gpointer self);
static void nodes_menu_link_nodes (NodesMenu* self);
static void _nodes_menu_link_nodes_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                    gpointer self);
VALA_EXTERN void nodes_menu_change_link_colors (NodesMenu* self);
static void _nodes_menu_change_link_colors_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                            gpointer self);
static void nodes_menu_randomize_link_colors (NodesMenu* self);
static void _nodes_menu_randomize_link_colors_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                               gpointer self);
static void nodes_menu_reparent_link_colors (NodesMenu* self);
static void _nodes_menu_reparent_link_colors_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                              gpointer self);
static void nodes_menu_select_parent_nodes (NodesMenu* self);
static void _nodes_menu_select_parent_nodes_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                             gpointer self);
static void nodes_menu_select_child_nodes (NodesMenu* self);
static void _nodes_menu_select_child_nodes_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                            gpointer self);
static void nodes_menu_align_to_top (NodesMenu* self);
static void _nodes_menu_align_to_top_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                      gpointer self);
static void nodes_menu_align_to_hcenter (NodesMenu* self);
static void _nodes_menu_align_to_hcenter_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                          gpointer self);
static void nodes_menu_align_to_bottom (NodesMenu* self);
static void _nodes_menu_align_to_bottom_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                         gpointer self);
static void nodes_menu_align_to_left (NodesMenu* self);
static void _nodes_menu_align_to_left_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                       gpointer self);
static void nodes_menu_align_to_vcenter (NodesMenu* self);
static void _nodes_menu_align_to_vcenter_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                          gpointer self);
static void nodes_menu_align_to_right (NodesMenu* self);
static void _nodes_menu_align_to_right_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                        gpointer self);
static void nodes_menu_on_popup (NodesMenu* self);
static void _nodes_menu_on_popup_gtk_widget_show (GtkWidget* _sender,
                                           gpointer self);
static void nodes_menu_nodes_foldable_status (NodesMenu* self,
                                       gboolean* foldable,
                                       gboolean* unfoldable);
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN GArray* draw_area_get_selected_nodes (DrawArea* self);
VALA_EXTERN gboolean node_is_leaf (Node* self);
VALA_EXTERN gboolean node_get_folded (Node* self);
static gboolean nodes_menu_link_colors_parentable (NodesMenu* self);
VALA_EXTERN gboolean node_get_link_color_root (Node* self);
VALA_EXTERN gboolean draw_area_any_selected_nodes_linked (DrawArea* self);
VALA_EXTERN gboolean draw_area_nodes_summarizable (DrawArea* self);
VALA_EXTERN gboolean draw_area_sequences_togglable (DrawArea* self);
VALA_EXTERN gboolean draw_area_nodes_alignable (DrawArea* self);
VALA_EXTERN gboolean draw_area_parent_selectable (DrawArea* self);
VALA_EXTERN gboolean draw_area_children_selectable (DrawArea* self);
static gboolean nodes_menu_have_same_parent (NodesMenu* self,
                                      GArray* nodes);
VALA_EXTERN Node* node_get_parent (Node* self);
VALA_EXTERN void draw_area_do_copy (DrawArea* self);
VALA_EXTERN void draw_area_do_cut (DrawArea* self);
VALA_EXTERN void draw_area_delete_nodes (DrawArea* self);
VALA_EXTERN void draw_area_change_selected_tasks (DrawArea* self);
VALA_EXTERN void draw_area_toggle_folds (DrawArea* self,
                             gboolean deep);
VALA_EXTERN void draw_area_toggle_sequence (DrawArea* self);
VALA_EXTERN void draw_area_create_connection (DrawArea* self);
VALA_EXTERN void draw_area_toggle_links (DrawArea* self);
static void nodes_menu_summarize (NodesMenu* self);
VALA_EXTERN void draw_area_add_summary_node_from_selected (DrawArea* self);
VALA_EXTERN GType main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
VALA_EXTERN MainWindow* draw_area_get_win (DrawArea* self);
VALA_EXTERN void draw_area_change_link_colors (DrawArea* self,
                                   GdkRGBA* color);
VALA_EXTERN void draw_area_randomize_link_colors (DrawArea* self);
VALA_EXTERN void draw_area_reparent_link_colors (DrawArea* self);
VALA_EXTERN void draw_area_select_parent_nodes (DrawArea* self);
VALA_EXTERN void draw_area_select_child_nodes (DrawArea* self);
VALA_EXTERN void node_align_align_top (DrawArea* da,
                           GArray* nodes);
VALA_EXTERN void node_align_align_hcenter (DrawArea* da,
                               GArray* nodes);
VALA_EXTERN void node_align_align_bottom (DrawArea* da,
                              GArray* nodes);
VALA_EXTERN void node_align_align_left (DrawArea* da,
                            GArray* nodes);
VALA_EXTERN void node_align_align_vcenter (DrawArea* da,
                               GArray* nodes);
VALA_EXTERN void node_align_align_right (DrawArea* da,
                             GArray* nodes);
static void nodes_menu_finalize (GObject * obj);
static GType nodes_menu_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
nodes_menu_get_instance_private (NodesMenu* self)
{
	return G_STRUCT_MEMBER_P (self, NodesMenu_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_nodes_menu_copy_nodes_gtk_menu_item_activate (GtkMenuItem* _sender,
                                               gpointer self)
{
	nodes_menu_copy_nodes ((NodesMenu*) self);
}

static void
_nodes_menu_cut_nodes_gtk_menu_item_activate (GtkMenuItem* _sender,
                                              gpointer self)
{
	nodes_menu_cut_nodes ((NodesMenu*) self);
}

static void
_nodes_menu_delete_nodes_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                 gpointer self)
{
	nodes_menu_delete_nodes ((NodesMenu*) self);
}

static void
_nodes_menu_toggle_tasks_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                 gpointer self)
{
	nodes_menu_toggle_tasks ((NodesMenu*) self);
}

static void
_nodes_menu_fold_nodes_gtk_menu_item_activate (GtkMenuItem* _sender,
                                               gpointer self)
{
	nodes_menu_fold_nodes ((NodesMenu*) self);
}

static void
_nodes_menu_toggle_sequences_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                     gpointer self)
{
	nodes_menu_toggle_sequences ((NodesMenu*) self);
}

static void
_nodes_menu_connect_nodes_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                  gpointer self)
{
	nodes_menu_connect_nodes ((NodesMenu*) self);
}

static void
_nodes_menu_link_nodes_gtk_menu_item_activate (GtkMenuItem* _sender,
                                               gpointer self)
{
	nodes_menu_link_nodes ((NodesMenu*) self);
}

static void
_nodes_menu_change_link_colors_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                       gpointer self)
{
	nodes_menu_change_link_colors ((NodesMenu*) self);
}

static void
_nodes_menu_randomize_link_colors_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                          gpointer self)
{
	nodes_menu_randomize_link_colors ((NodesMenu*) self);
}

static void
_nodes_menu_reparent_link_colors_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                         gpointer self)
{
	nodes_menu_reparent_link_colors ((NodesMenu*) self);
}

static void
_nodes_menu_select_parent_nodes_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                        gpointer self)
{
	nodes_menu_select_parent_nodes ((NodesMenu*) self);
}

static void
_nodes_menu_select_child_nodes_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                       gpointer self)
{
	nodes_menu_select_child_nodes ((NodesMenu*) self);
}

static void
_nodes_menu_align_to_top_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                 gpointer self)
{
	nodes_menu_align_to_top ((NodesMenu*) self);
}

static void
_nodes_menu_align_to_hcenter_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                     gpointer self)
{
	nodes_menu_align_to_hcenter ((NodesMenu*) self);
}

static void
_nodes_menu_align_to_bottom_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                    gpointer self)
{
	nodes_menu_align_to_bottom ((NodesMenu*) self);
}

static void
_nodes_menu_align_to_left_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                  gpointer self)
{
	nodes_menu_align_to_left ((NodesMenu*) self);
}

static void
_nodes_menu_align_to_vcenter_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                     gpointer self)
{
	nodes_menu_align_to_vcenter ((NodesMenu*) self);
}

static void
_nodes_menu_align_to_right_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                   gpointer self)
{
	nodes_menu_align_to_right ((NodesMenu*) self);
}

static void
_nodes_menu_on_popup_gtk_widget_show (GtkWidget* _sender,
                                      gpointer self)
{
	nodes_menu_on_popup ((NodesMenu*) self);
}

NodesMenu*
nodes_menu_construct (GType object_type,
                      DrawArea* da,
                      GtkAccelGroup* accel_group)
{
	NodesMenu * self = NULL;
	DrawArea* _tmp0_;
	GtkMenuItem* _tmp1_;
	GtkMenuItem* _tmp2_;
	GraniteAccelLabel* _tmp3_;
	GraniteAccelLabel* _tmp4_;
	GtkMenuItem* _tmp5_;
	GtkMenuItem* _tmp6_;
	GtkMenuItem* _tmp7_;
	GraniteAccelLabel* _tmp8_;
	GraniteAccelLabel* _tmp9_;
	GtkMenuItem* _tmp10_;
	GtkMenuItem* _tmp11_;
	GtkMenuItem* _tmp12_;
	GraniteAccelLabel* _tmp13_;
	GraniteAccelLabel* _tmp14_;
	GtkMenuItem* _tmp15_;
	GtkMenuItem* _tmp16_;
	GtkMenuItem* _tmp17_;
	GraniteAccelLabel* _tmp18_;
	GraniteAccelLabel* _tmp19_;
	GtkMenuItem* _tmp20_;
	GtkMenuItem* _tmp21_;
	GtkMenuItem* _tmp22_;
	GraniteAccelLabel* _tmp23_;
	GraniteAccelLabel* _tmp24_;
	GtkMenuItem* _tmp25_;
	GtkMenuItem* _tmp26_;
	GtkMenuItem* _tmp27_;
	GraniteAccelLabel* _tmp28_;
	GraniteAccelLabel* _tmp29_;
	GtkMenuItem* _tmp30_;
	GtkMenuItem* _tmp31_;
	GtkMenuItem* _tmp32_;
	GraniteAccelLabel* _tmp33_;
	GraniteAccelLabel* _tmp34_;
	GtkMenuItem* _tmp35_;
	GtkMenuItem* _tmp36_;
	GtkMenuItem* _tmp37_;
	GraniteAccelLabel* _tmp38_;
	GraniteAccelLabel* _tmp39_;
	GtkMenuItem* _tmp40_;
	GtkMenu* link_color_menu = NULL;
	GtkMenu* _tmp41_;
	GtkMenuItem* _tmp42_;
	GtkMenuItem* _tmp43_;
	GtkMenuItem* set_link_colors = NULL;
	GtkMenuItem* _tmp44_;
	GraniteAccelLabel* _tmp45_;
	GraniteAccelLabel* _tmp46_;
	GtkMenuItem* rand_link_colors = NULL;
	GtkMenuItem* _tmp47_;
	GtkMenuItem* _tmp48_;
	GtkMenuItem* _tmp49_;
	GtkMenuItem* _tmp50_;
	GtkMenu* selmenu = NULL;
	GtkMenu* _tmp51_;
	GtkMenuItem* _tmp52_;
	GtkMenuItem* _tmp53_;
	GtkMenuItem* _tmp54_;
	GtkMenuItem* _tmp55_;
	GraniteAccelLabel* _tmp56_;
	GraniteAccelLabel* _tmp57_;
	GtkMenuItem* _tmp58_;
	GtkMenuItem* _tmp59_;
	GtkMenuItem* _tmp60_;
	GraniteAccelLabel* _tmp61_;
	GraniteAccelLabel* _tmp62_;
	GtkMenuItem* _tmp63_;
	GtkMenuItem* _tmp64_;
	GtkMenuItem* _tmp65_;
	GtkMenu* align_menu = NULL;
	GtkMenu* _tmp66_;
	GtkMenuItem* _tmp67_;
	GtkMenuItem* _tmp68_;
	GtkMenuItem* align_top = NULL;
	GtkMenuItem* _tmp69_;
	GraniteAccelLabel* _tmp70_;
	GraniteAccelLabel* _tmp71_;
	GtkMenuItem* align_hcenter = NULL;
	GtkMenuItem* _tmp72_;
	GraniteAccelLabel* _tmp73_;
	GraniteAccelLabel* _tmp74_;
	GtkMenuItem* align_bottom = NULL;
	GtkMenuItem* _tmp75_;
	GraniteAccelLabel* _tmp76_;
	GraniteAccelLabel* _tmp77_;
	GtkMenuItem* align_left = NULL;
	GtkMenuItem* _tmp78_;
	GraniteAccelLabel* _tmp79_;
	GraniteAccelLabel* _tmp80_;
	GtkMenuItem* align_vcenter = NULL;
	GtkMenuItem* _tmp81_;
	GraniteAccelLabel* _tmp82_;
	GraniteAccelLabel* _tmp83_;
	GtkMenuItem* align_right = NULL;
	GtkMenuItem* _tmp84_;
	GraniteAccelLabel* _tmp85_;
	GraniteAccelLabel* _tmp86_;
	GtkSeparatorMenuItem* _tmp87_;
	GtkSeparatorMenuItem* _tmp88_;
	GtkMenuItem* _tmp89_;
	GtkMenuItem* _tmp90_;
	GtkMenuItem* _tmp91_;
	GtkSeparatorMenuItem* _tmp92_;
	GtkSeparatorMenuItem* _tmp93_;
	GtkMenuItem* _tmp94_;
	GtkMenuItem* _tmp95_;
	GtkMenuItem* _tmp96_;
	GtkMenuItem* _tmp97_;
	GtkSeparatorMenuItem* _tmp98_;
	GtkSeparatorMenuItem* _tmp99_;
	GtkMenuItem* _tmp100_;
	GtkMenuItem* _tmp101_;
	GtkSeparatorMenuItem* _tmp102_;
	GtkSeparatorMenuItem* _tmp103_;
	GtkMenuItem* _tmp104_;
	GtkSeparatorMenuItem* _tmp105_;
	GtkSeparatorMenuItem* _tmp106_;
	GtkMenuItem* _tmp107_;
	g_return_val_if_fail (da != NULL, NULL);
	g_return_val_if_fail (accel_group != NULL, NULL);
	self = (NodesMenu*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (da);
	_g_object_unref0 (self->priv->_da);
	self->priv->_da = _tmp0_;
	_tmp1_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->_copy);
	self->priv->_copy = _tmp1_;
	_tmp2_ = self->priv->_copy;
	_tmp3_ = granite_accel_label_new (_ ("Copy"), "<Control>c");
	g_object_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	gtk_container_add ((GtkContainer*) _tmp2_, (GtkWidget*) _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = self->priv->_copy;
	g_signal_connect_object (_tmp5_, "activate", (GCallback) _nodes_menu_copy_nodes_gtk_menu_item_activate, self, 0);
	_tmp6_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->_cut);
	self->priv->_cut = _tmp6_;
	_tmp7_ = self->priv->_cut;
	_tmp8_ = granite_accel_label_new (_ ("Cut"), "<Control>x");
	g_object_ref_sink (_tmp8_);
	_tmp9_ = _tmp8_;
	gtk_container_add ((GtkContainer*) _tmp7_, (GtkWidget*) _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = self->priv->_cut;
	g_signal_connect_object (_tmp10_, "activate", (GCallback) _nodes_menu_cut_nodes_gtk_menu_item_activate, self, 0);
	_tmp11_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->_delete);
	self->priv->_delete = _tmp11_;
	_tmp12_ = self->priv->_delete;
	_tmp13_ = granite_accel_label_new (_ ("Delete"), "Delete");
	g_object_ref_sink (_tmp13_);
	_tmp14_ = _tmp13_;
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) _tmp14_);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = self->priv->_delete;
	g_signal_connect_object (_tmp15_, "activate", (GCallback) _nodes_menu_delete_nodes_gtk_menu_item_activate, self, 0);
	_tmp16_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->_task);
	self->priv->_task = _tmp16_;
	_tmp17_ = self->priv->_task;
	_tmp18_ = granite_accel_label_new (_ ("Toggle Tasks"), "t");
	g_object_ref_sink (_tmp18_);
	_tmp19_ = _tmp18_;
	gtk_container_add ((GtkContainer*) _tmp17_, (GtkWidget*) _tmp19_);
	_g_object_unref0 (_tmp19_);
	_tmp20_ = self->priv->_task;
	g_signal_connect_object (_tmp20_, "activate", (GCallback) _nodes_menu_toggle_tasks_gtk_menu_item_activate, self, 0);
	_tmp21_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->_fold);
	self->priv->_fold = _tmp21_;
	_tmp22_ = self->priv->_fold;
	_tmp23_ = granite_accel_label_new (_ ("Fold Children"), "f");
	g_object_ref_sink (_tmp23_);
	_tmp24_ = _tmp23_;
	gtk_container_add ((GtkContainer*) _tmp22_, (GtkWidget*) _tmp24_);
	_g_object_unref0 (_tmp24_);
	_tmp25_ = self->priv->_fold;
	g_signal_connect_object (_tmp25_, "activate", (GCallback) _nodes_menu_fold_nodes_gtk_menu_item_activate, self, 0);
	_tmp26_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp26_);
	_g_object_unref0 (self->priv->_sequence);
	self->priv->_sequence = _tmp26_;
	_tmp27_ = self->priv->_sequence;
	_tmp28_ = granite_accel_label_new (_ ("Toggle Sequences"), "numbersign");
	g_object_ref_sink (_tmp28_);
	_tmp29_ = _tmp28_;
	gtk_container_add ((GtkContainer*) _tmp27_, (GtkWidget*) _tmp29_);
	_g_object_unref0 (_tmp29_);
	_tmp30_ = self->priv->_sequence;
	g_signal_connect_object (_tmp30_, "activate", (GCallback) _nodes_menu_toggle_sequences_gtk_menu_item_activate, self, 0);
	_tmp31_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->priv->_connect);
	self->priv->_connect = _tmp31_;
	_tmp32_ = self->priv->_connect;
	_tmp33_ = granite_accel_label_new (_ ("Connect"), "x");
	g_object_ref_sink (_tmp33_);
	_tmp34_ = _tmp33_;
	gtk_container_add ((GtkContainer*) _tmp32_, (GtkWidget*) _tmp34_);
	_g_object_unref0 (_tmp34_);
	_tmp35_ = self->priv->_connect;
	g_signal_connect_object (_tmp35_, "activate", (GCallback) _nodes_menu_connect_nodes_gtk_menu_item_activate, self, 0);
	_tmp36_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp36_);
	_g_object_unref0 (self->priv->_link);
	self->priv->_link = _tmp36_;
	_tmp37_ = self->priv->_link;
	_tmp38_ = granite_accel_label_new (_ ("Link Nodes"), "y");
	g_object_ref_sink (_tmp38_);
	_tmp39_ = _tmp38_;
	gtk_container_add ((GtkContainer*) _tmp37_, (GtkWidget*) _tmp39_);
	_g_object_unref0 (_tmp39_);
	_tmp40_ = self->priv->_link;
	g_signal_connect_object (_tmp40_, "activate", (GCallback) _nodes_menu_link_nodes_gtk_menu_item_activate, self, 0);
	_tmp41_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp41_);
	link_color_menu = _tmp41_;
	_tmp42_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Link Colors"));
	g_object_ref_sink (_tmp42_);
	_g_object_unref0 (self->priv->_link_colors);
	self->priv->_link_colors = _tmp42_;
	_tmp43_ = self->priv->_link_colors;
	gtk_menu_item_set_submenu (_tmp43_, link_color_menu);
	_tmp44_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp44_);
	set_link_colors = _tmp44_;
	_tmp45_ = granite_accel_label_new (_ ("Set to color…"), "<Shift>l");
	g_object_ref_sink (_tmp45_);
	_tmp46_ = _tmp45_;
	gtk_container_add ((GtkContainer*) set_link_colors, (GtkWidget*) _tmp46_);
	_g_object_unref0 (_tmp46_);
	g_signal_connect_object (set_link_colors, "activate", (GCallback) _nodes_menu_change_link_colors_gtk_menu_item_activate, self, 0);
	_tmp47_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Randomize colors"));
	g_object_ref_sink (_tmp47_);
	rand_link_colors = _tmp47_;
	g_signal_connect_object (rand_link_colors, "activate", (GCallback) _nodes_menu_randomize_link_colors_gtk_menu_item_activate, self, 0);
	_tmp48_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Use parent color"));
	g_object_ref_sink (_tmp48_);
	_g_object_unref0 (self->priv->_parent_link_colors);
	self->priv->_parent_link_colors = _tmp48_;
	_tmp49_ = self->priv->_parent_link_colors;
	g_signal_connect_object (_tmp49_, "activate", (GCallback) _nodes_menu_reparent_link_colors_gtk_menu_item_activate, self, 0);
	gtk_container_add ((GtkContainer*) link_color_menu, (GtkWidget*) set_link_colors);
	gtk_container_add ((GtkContainer*) link_color_menu, (GtkWidget*) rand_link_colors);
	_tmp50_ = self->priv->_parent_link_colors;
	gtk_container_add ((GtkContainer*) link_color_menu, (GtkWidget*) _tmp50_);
	_tmp51_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp51_);
	selmenu = _tmp51_;
	_tmp52_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Select"));
	g_object_ref_sink (_tmp52_);
	_g_object_unref0 (self->priv->_selnodes);
	self->priv->_selnodes = _tmp52_;
	_tmp53_ = self->priv->_selnodes;
	gtk_menu_item_set_submenu (_tmp53_, selmenu);
	_tmp54_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp54_);
	_g_object_unref0 (self->priv->_selparent);
	self->priv->_selparent = _tmp54_;
	_tmp55_ = self->priv->_selparent;
	_tmp56_ = granite_accel_label_new (_ ("Parent Nodes"), "a");
	g_object_ref_sink (_tmp56_);
	_tmp57_ = _tmp56_;
	gtk_container_add ((GtkContainer*) _tmp55_, (GtkWidget*) _tmp57_);
	_g_object_unref0 (_tmp57_);
	_tmp58_ = self->priv->_selparent;
	g_signal_connect_object (_tmp58_, "activate", (GCallback) _nodes_menu_select_parent_nodes_gtk_menu_item_activate, self, 0);
	_tmp59_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp59_);
	_g_object_unref0 (self->priv->_selchildren);
	self->priv->_selchildren = _tmp59_;
	_tmp60_ = self->priv->_selchildren;
	_tmp61_ = granite_accel_label_new (_ ("Child Nodes"), "d");
	g_object_ref_sink (_tmp61_);
	_tmp62_ = _tmp61_;
	gtk_container_add ((GtkContainer*) _tmp60_, (GtkWidget*) _tmp62_);
	_g_object_unref0 (_tmp62_);
	_tmp63_ = self->priv->_selchildren;
	g_signal_connect_object (_tmp63_, "activate", (GCallback) _nodes_menu_select_child_nodes_gtk_menu_item_activate, self, 0);
	_tmp64_ = self->priv->_selparent;
	gtk_container_add ((GtkContainer*) selmenu, (GtkWidget*) _tmp64_);
	_tmp65_ = self->priv->_selchildren;
	gtk_container_add ((GtkContainer*) selmenu, (GtkWidget*) _tmp65_);
	_tmp66_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp66_);
	align_menu = _tmp66_;
	_tmp67_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Align Nodes"));
	g_object_ref_sink (_tmp67_);
	_g_object_unref0 (self->priv->_align);
	self->priv->_align = _tmp67_;
	_tmp68_ = self->priv->_align;
	gtk_menu_item_set_submenu (_tmp68_, align_menu);
	_tmp69_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp69_);
	align_top = _tmp69_;
	_tmp70_ = granite_accel_label_new (_ ("Align Top"), "minus");
	g_object_ref_sink (_tmp70_);
	_tmp71_ = _tmp70_;
	gtk_container_add ((GtkContainer*) align_top, (GtkWidget*) _tmp71_);
	_g_object_unref0 (_tmp71_);
	g_signal_connect_object (align_top, "activate", (GCallback) _nodes_menu_align_to_top_gtk_menu_item_activate, self, 0);
	_tmp72_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp72_);
	align_hcenter = _tmp72_;
	_tmp73_ = granite_accel_label_new (_ ("Align Center Horizontally"), "equal");
	g_object_ref_sink (_tmp73_);
	_tmp74_ = _tmp73_;
	gtk_container_add ((GtkContainer*) align_hcenter, (GtkWidget*) _tmp74_);
	_g_object_unref0 (_tmp74_);
	g_signal_connect_object (align_hcenter, "activate", (GCallback) _nodes_menu_align_to_hcenter_gtk_menu_item_activate, self, 0);
	_tmp75_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp75_);
	align_bottom = _tmp75_;
	_tmp76_ = granite_accel_label_new (_ ("Align Bottom"), "underscore");
	g_object_ref_sink (_tmp76_);
	_tmp77_ = _tmp76_;
	gtk_container_add ((GtkContainer*) align_bottom, (GtkWidget*) _tmp77_);
	_g_object_unref0 (_tmp77_);
	g_signal_connect_object (align_bottom, "activate", (GCallback) _nodes_menu_align_to_bottom_gtk_menu_item_activate, self, 0);
	_tmp78_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp78_);
	align_left = _tmp78_;
	_tmp79_ = granite_accel_label_new (_ ("Align Left"), "bracketleft");
	g_object_ref_sink (_tmp79_);
	_tmp80_ = _tmp79_;
	gtk_container_add ((GtkContainer*) align_left, (GtkWidget*) _tmp80_);
	_g_object_unref0 (_tmp80_);
	g_signal_connect_object (align_left, "activate", (GCallback) _nodes_menu_align_to_left_gtk_menu_item_activate, self, 0);
	_tmp81_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp81_);
	align_vcenter = _tmp81_;
	_tmp82_ = granite_accel_label_new (_ ("Align Center Vertically"), "bar");
	g_object_ref_sink (_tmp82_);
	_tmp83_ = _tmp82_;
	gtk_container_add ((GtkContainer*) align_vcenter, (GtkWidget*) _tmp83_);
	_g_object_unref0 (_tmp83_);
	g_signal_connect_object (align_vcenter, "activate", (GCallback) _nodes_menu_align_to_vcenter_gtk_menu_item_activate, self, 0);
	_tmp84_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp84_);
	align_right = _tmp84_;
	_tmp85_ = granite_accel_label_new (_ ("Align Right"), "bracketright");
	g_object_ref_sink (_tmp85_);
	_tmp86_ = _tmp85_;
	gtk_container_add ((GtkContainer*) align_right, (GtkWidget*) _tmp86_);
	_g_object_unref0 (_tmp86_);
	g_signal_connect_object (align_right, "activate", (GCallback) _nodes_menu_align_to_right_gtk_menu_item_activate, self, 0);
	gtk_container_add ((GtkContainer*) align_menu, (GtkWidget*) align_top);
	gtk_container_add ((GtkContainer*) align_menu, (GtkWidget*) align_hcenter);
	gtk_container_add ((GtkContainer*) align_menu, (GtkWidget*) align_bottom);
	_tmp87_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp87_);
	_tmp88_ = _tmp87_;
	gtk_container_add ((GtkContainer*) align_menu, (GtkWidget*) _tmp88_);
	_g_object_unref0 (_tmp88_);
	gtk_container_add ((GtkContainer*) align_menu, (GtkWidget*) align_left);
	gtk_container_add ((GtkContainer*) align_menu, (GtkWidget*) align_vcenter);
	gtk_container_add ((GtkContainer*) align_menu, (GtkWidget*) align_right);
	_tmp89_ = self->priv->_copy;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp89_);
	_tmp90_ = self->priv->_cut;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp90_);
	_tmp91_ = self->priv->_delete;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp91_);
	_tmp92_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp92_);
	_tmp93_ = _tmp92_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp93_);
	_g_object_unref0 (_tmp93_);
	_tmp94_ = self->priv->_task;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp94_);
	_tmp95_ = self->priv->_link_colors;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp95_);
	_tmp96_ = self->priv->_fold;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp96_);
	_tmp97_ = self->priv->_sequence;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp97_);
	_tmp98_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp98_);
	_tmp99_ = _tmp98_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp99_);
	_g_object_unref0 (_tmp99_);
	_tmp100_ = self->priv->_connect;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp100_);
	_tmp101_ = self->priv->_link;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp101_);
	_tmp102_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp102_);
	_tmp103_ = _tmp102_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp103_);
	_g_object_unref0 (_tmp103_);
	_tmp104_ = self->priv->_selnodes;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp104_);
	_tmp105_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp105_);
	_tmp106_ = _tmp105_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp106_);
	_g_object_unref0 (_tmp106_);
	_tmp107_ = self->priv->_align;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp107_);
	gtk_widget_show_all ((GtkWidget*) self);
	g_signal_connect_object ((GtkWidget*) self, "show", (GCallback) _nodes_menu_on_popup_gtk_widget_show, self, 0);
	_g_object_unref0 (align_right);
	_g_object_unref0 (align_vcenter);
	_g_object_unref0 (align_left);
	_g_object_unref0 (align_bottom);
	_g_object_unref0 (align_hcenter);
	_g_object_unref0 (align_top);
	_g_object_unref0 (align_menu);
	_g_object_unref0 (selmenu);
	_g_object_unref0 (rand_link_colors);
	_g_object_unref0 (set_link_colors);
	_g_object_unref0 (link_color_menu);
	return self;
}

NodesMenu*
nodes_menu_new (DrawArea* da,
                GtkAccelGroup* accel_group)
{
	return nodes_menu_construct (TYPE_NODES_MENU, da, accel_group);
}

static void
nodes_menu_nodes_foldable_status (NodesMenu* self,
                                  gboolean* foldable,
                                  gboolean* unfoldable)
{
	gboolean _vala_foldable = FALSE;
	gboolean _vala_unfoldable = FALSE;
	GArray* nodes = NULL;
	DrawArea* _tmp0_;
	GArray* _tmp1_;
	g_return_if_fail (self != NULL);
	_vala_unfoldable = FALSE;
	_vala_foldable = _vala_unfoldable;
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_selected_nodes (_tmp0_);
	nodes = _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				GArray* _tmp4_;
				GArray* _tmp5_;
				Node* _tmp6_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = nodes;
				if (!(((guint) i) < _tmp4_->len)) {
					break;
				}
				_tmp5_ = nodes;
				_tmp6_ = g_array_index (_tmp5_, Node*, (guint) i);
				if (!node_is_leaf (_tmp6_)) {
					GArray* _tmp7_;
					Node* _tmp8_;
					gboolean _tmp9_;
					gboolean _tmp10_;
					GArray* _tmp11_;
					Node* _tmp12_;
					gboolean _tmp13_;
					gboolean _tmp14_;
					_tmp7_ = nodes;
					_tmp8_ = g_array_index (_tmp7_, Node*, (guint) i);
					_tmp9_ = node_get_folded (_tmp8_);
					_tmp10_ = _tmp9_;
					_vala_foldable = _vala_foldable | (!_tmp10_);
					_tmp11_ = nodes;
					_tmp12_ = g_array_index (_tmp11_, Node*, (guint) i);
					_tmp13_ = node_get_folded (_tmp12_);
					_tmp14_ = _tmp13_;
					_vala_unfoldable = _vala_unfoldable | _tmp14_;
				}
			}
		}
	}
	_g_array_unref0 (nodes);
	if (foldable) {
		*foldable = _vala_foldable;
	}
	if (unfoldable) {
		*unfoldable = _vala_unfoldable;
	}
}

static gboolean
nodes_menu_link_colors_parentable (NodesMenu* self)
{
	GArray* nodes = NULL;
	DrawArea* _tmp0_;
	GArray* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_selected_nodes (_tmp0_);
	nodes = _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				GArray* _tmp4_;
				GArray* _tmp5_;
				Node* _tmp6_;
				gboolean _tmp7_;
				gboolean _tmp8_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = nodes;
				if (!(((guint) i) < _tmp4_->len)) {
					break;
				}
				_tmp5_ = nodes;
				_tmp6_ = g_array_index (_tmp5_, Node*, (guint) i);
				_tmp7_ = node_get_link_color_root (_tmp6_);
				_tmp8_ = _tmp7_;
				if (_tmp8_) {
					result = TRUE;
					_g_array_unref0 (nodes);
					return result;
				}
			}
		}
	}
	result = FALSE;
	_g_array_unref0 (nodes);
	return result;
}

static void
nodes_menu_on_popup (NodesMenu* self)
{
	GArray* nodes = NULL;
	DrawArea* _tmp0_;
	GArray* _tmp1_;
	guint node_num = 0U;
	GArray* _tmp2_;
	gboolean has_link = FALSE;
	DrawArea* _tmp3_;
	gboolean summarizable = FALSE;
	DrawArea* _tmp4_;
	gboolean foldable = FALSE;
	gboolean unfoldable = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GtkMenuItem* _tmp8_;
	GtkMenuItem* _tmp9_;
	DrawArea* _tmp10_;
	GtkMenuItem* _tmp11_;
	GtkMenuItem* _tmp12_;
	GtkMenuItem* _tmp13_;
	DrawArea* _tmp14_;
	GtkMenuItem* _tmp15_;
	DrawArea* _tmp16_;
	GtkMenuItem* _tmp17_;
	DrawArea* _tmp18_;
	GraniteAccelLabel* fold_acc = NULL;
	GtkMenuItem* _tmp19_;
	GtkWidget* _tmp20_;
	GraniteAccelLabel* _tmp21_;
	GraniteAccelLabel* link_acc = NULL;
	GtkMenuItem* _tmp22_;
	GtkWidget* _tmp23_;
	GraniteAccelLabel* _tmp24_;
	const gchar* _tmp25_ = NULL;
	gchar* fold_lbl = NULL;
	gchar* _tmp26_;
	const gchar* _tmp27_ = NULL;
	gchar* link_lbl = NULL;
	gchar* _tmp28_;
	GtkMenuItem* _tmp29_;
	GtkWidget* _tmp30_;
	GtkMenuItem* _tmp31_;
	const gchar* _tmp32_;
	GraniteAccelLabel* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	GraniteAccelLabel* _tmp36_;
	GraniteAccelLabel* _tmp37_;
	GtkMenuItem* _tmp38_;
	GtkWidget* _tmp39_;
	GtkMenuItem* _tmp40_;
	GraniteAccelLabel* _tmp41_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	GraniteAccelLabel* _tmp44_;
	GraniteAccelLabel* _tmp45_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_selected_nodes (_tmp0_);
	nodes = _tmp1_;
	_tmp2_ = nodes;
	node_num = _tmp2_->len;
	_tmp3_ = self->priv->_da;
	has_link = draw_area_any_selected_nodes_linked (_tmp3_);
	_tmp4_ = self->priv->_da;
	summarizable = draw_area_nodes_summarizable (_tmp4_);
	nodes_menu_nodes_foldable_status (self, &_tmp5_, &_tmp6_);
	foldable = _tmp5_;
	unfoldable = _tmp6_;
	if (foldable) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = unfoldable;
	}
	_tmp8_ = self->priv->_fold;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, _tmp7_);
	_tmp9_ = self->priv->_sequence;
	_tmp10_ = self->priv->_da;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, draw_area_sequences_togglable (_tmp10_));
	_tmp11_ = self->priv->_connect;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, node_num == ((guint) 2));
	_tmp12_ = self->priv->_parent_link_colors;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp12_, nodes_menu_link_colors_parentable (self));
	_tmp13_ = self->priv->_align;
	_tmp14_ = self->priv->_da;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp13_, draw_area_nodes_alignable (_tmp14_));
	_tmp15_ = self->priv->_selparent;
	_tmp16_ = self->priv->_da;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp15_, draw_area_parent_selectable (_tmp16_));
	_tmp17_ = self->priv->_selchildren;
	_tmp18_ = self->priv->_da;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp17_, draw_area_children_selectable (_tmp18_));
	_tmp19_ = self->priv->_fold;
	_tmp20_ = gtk_bin_get_child ((GtkBin*) _tmp19_);
	_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GRANITE_TYPE_ACCEL_LABEL, GraniteAccelLabel));
	fold_acc = _tmp21_;
	_tmp22_ = self->priv->_link;
	_tmp23_ = gtk_bin_get_child ((GtkBin*) _tmp22_);
	_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GRANITE_TYPE_ACCEL_LABEL, GraniteAccelLabel));
	link_acc = _tmp24_;
	if (unfoldable) {
		_tmp25_ = _ ("Unfold Children");
	} else {
		_tmp25_ = _ ("Fold Children");
	}
	_tmp26_ = g_strdup (_tmp25_);
	fold_lbl = _tmp26_;
	if (has_link) {
		_tmp27_ = _ ("Remove Node Links");
	} else {
		_tmp27_ = _ ("Link Nodes");
	}
	_tmp28_ = g_strdup (_tmp27_);
	link_lbl = _tmp28_;
	_tmp29_ = self->priv->_fold;
	_tmp30_ = gtk_bin_get_child ((GtkBin*) _tmp29_);
	gtk_widget_destroy (_tmp30_);
	_tmp31_ = self->priv->_fold;
	_tmp32_ = fold_lbl;
	_tmp33_ = fold_acc;
	_tmp34_ = granite_accel_label_get_accel_string (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = granite_accel_label_new (_tmp32_, _tmp35_);
	g_object_ref_sink (_tmp36_);
	_tmp37_ = _tmp36_;
	gtk_container_add ((GtkContainer*) _tmp31_, (GtkWidget*) _tmp37_);
	_g_object_unref0 (_tmp37_);
	_tmp38_ = self->priv->_link;
	_tmp39_ = gtk_bin_get_child ((GtkBin*) _tmp38_);
	gtk_widget_destroy (_tmp39_);
	_tmp40_ = self->priv->_link;
	_tmp41_ = link_acc;
	_tmp42_ = granite_accel_label_get_accel_string (_tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = granite_accel_label_new (link_lbl, _tmp43_);
	g_object_ref_sink (_tmp44_);
	_tmp45_ = _tmp44_;
	gtk_container_add ((GtkContainer*) _tmp40_, (GtkWidget*) _tmp45_);
	_g_object_unref0 (_tmp45_);
	_g_free0 (link_lbl);
	_g_free0 (fold_lbl);
	_g_object_unref0 (link_acc);
	_g_object_unref0 (fold_acc);
	_g_array_unref0 (nodes);
}

static gboolean
nodes_menu_have_same_parent (NodesMenu* self,
                             GArray* nodes)
{
	Node* first = NULL;
	Node* _tmp0_;
	Node* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (nodes != NULL, FALSE);
	_tmp0_ = g_array_index (nodes, Node*, (guint) 0);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	first = _tmp1_;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				Node* node = NULL;
				Node* _tmp4_;
				Node* _tmp5_;
				Node* _tmp6_;
				Node* _tmp7_;
				Node* _tmp8_;
				Node* _tmp9_;
				Node* _tmp10_;
				Node* _tmp11_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(((guint) i) < nodes->len)) {
					break;
				}
				_tmp4_ = g_array_index (nodes, Node*, (guint) i);
				_tmp5_ = _g_object_ref0 (_tmp4_);
				node = _tmp5_;
				_tmp6_ = first;
				_tmp7_ = node_get_parent (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = node;
				_tmp10_ = node_get_parent (_tmp9_);
				_tmp11_ = _tmp10_;
				if (_tmp8_ != _tmp11_) {
					result = FALSE;
					_g_object_unref0 (node);
					_g_object_unref0 (first);
					return result;
				}
				_g_object_unref0 (node);
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (first);
	return result;
}

static void
nodes_menu_copy_nodes (NodesMenu* self)
{
	DrawArea* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	draw_area_do_copy (_tmp0_);
}

static void
nodes_menu_cut_nodes (NodesMenu* self)
{
	DrawArea* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	draw_area_do_cut (_tmp0_);
}

static void
nodes_menu_delete_nodes (NodesMenu* self)
{
	DrawArea* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	draw_area_delete_nodes (_tmp0_);
}

static void
nodes_menu_toggle_tasks (NodesMenu* self)
{
	DrawArea* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	draw_area_change_selected_tasks (_tmp0_);
}

static void
nodes_menu_fold_nodes (NodesMenu* self)
{
	DrawArea* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	draw_area_toggle_folds (_tmp0_, FALSE);
}

static void
nodes_menu_toggle_sequences (NodesMenu* self)
{
	DrawArea* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	draw_area_toggle_sequence (_tmp0_);
}

static void
nodes_menu_connect_nodes (NodesMenu* self)
{
	DrawArea* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	draw_area_create_connection (_tmp0_);
}

static void
nodes_menu_link_nodes (NodesMenu* self)
{
	DrawArea* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	draw_area_toggle_links (_tmp0_);
}

static void
nodes_menu_summarize (NodesMenu* self)
{
	DrawArea* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	draw_area_add_summary_node_from_selected (_tmp0_);
}

void
nodes_menu_change_link_colors (NodesMenu* self)
{
	GtkColorChooserDialog* color_picker = NULL;
	DrawArea* _tmp0_;
	MainWindow* _tmp1_;
	MainWindow* _tmp2_;
	GtkColorChooserDialog* _tmp3_;
	GtkColorChooserDialog* _tmp4_;
	GtkColorChooserDialog* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_win (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = (GtkColorChooserDialog*) gtk_color_chooser_dialog_new (_ ("Select a link color"), (GtkWindow*) _tmp2_);
	g_object_ref_sink (_tmp3_);
	color_picker = _tmp3_;
	_tmp4_ = color_picker;
	if (gtk_dialog_run ((GtkDialog*) _tmp4_) == ((gint) GTK_RESPONSE_OK)) {
		DrawArea* _tmp5_;
		GtkColorChooserDialog* _tmp6_;
		GdkRGBA _tmp7_ = {0};
		_tmp5_ = self->priv->_da;
		_tmp6_ = color_picker;
		gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp6_, &_tmp7_);
		draw_area_change_link_colors (_tmp5_, &_tmp7_);
	}
	_tmp8_ = color_picker;
	g_signal_emit_by_name ((GtkDialog*) _tmp8_, "close");
	_g_object_unref0 (color_picker);
}

static void
nodes_menu_randomize_link_colors (NodesMenu* self)
{
	DrawArea* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	draw_area_randomize_link_colors (_tmp0_);
}

static void
nodes_menu_reparent_link_colors (NodesMenu* self)
{
	DrawArea* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	draw_area_reparent_link_colors (_tmp0_);
}

static void
nodes_menu_select_parent_nodes (NodesMenu* self)
{
	DrawArea* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	draw_area_select_parent_nodes (_tmp0_);
}

static void
nodes_menu_select_child_nodes (NodesMenu* self)
{
	DrawArea* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	draw_area_select_child_nodes (_tmp0_);
}

static void
nodes_menu_align_to_top (NodesMenu* self)
{
	DrawArea* _tmp0_;
	DrawArea* _tmp1_;
	GArray* _tmp2_;
	GArray* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	_tmp1_ = self->priv->_da;
	_tmp2_ = draw_area_get_selected_nodes (_tmp1_);
	_tmp3_ = _tmp2_;
	node_align_align_top (_tmp0_, _tmp3_);
	_g_array_unref0 (_tmp3_);
}

static void
nodes_menu_align_to_hcenter (NodesMenu* self)
{
	DrawArea* _tmp0_;
	DrawArea* _tmp1_;
	GArray* _tmp2_;
	GArray* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	_tmp1_ = self->priv->_da;
	_tmp2_ = draw_area_get_selected_nodes (_tmp1_);
	_tmp3_ = _tmp2_;
	node_align_align_hcenter (_tmp0_, _tmp3_);
	_g_array_unref0 (_tmp3_);
}

static void
nodes_menu_align_to_bottom (NodesMenu* self)
{
	DrawArea* _tmp0_;
	DrawArea* _tmp1_;
	GArray* _tmp2_;
	GArray* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	_tmp1_ = self->priv->_da;
	_tmp2_ = draw_area_get_selected_nodes (_tmp1_);
	_tmp3_ = _tmp2_;
	node_align_align_bottom (_tmp0_, _tmp3_);
	_g_array_unref0 (_tmp3_);
}

static void
nodes_menu_align_to_left (NodesMenu* self)
{
	DrawArea* _tmp0_;
	DrawArea* _tmp1_;
	GArray* _tmp2_;
	GArray* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	_tmp1_ = self->priv->_da;
	_tmp2_ = draw_area_get_selected_nodes (_tmp1_);
	_tmp3_ = _tmp2_;
	node_align_align_left (_tmp0_, _tmp3_);
	_g_array_unref0 (_tmp3_);
}

static void
nodes_menu_align_to_vcenter (NodesMenu* self)
{
	DrawArea* _tmp0_;
	DrawArea* _tmp1_;
	GArray* _tmp2_;
	GArray* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	_tmp1_ = self->priv->_da;
	_tmp2_ = draw_area_get_selected_nodes (_tmp1_);
	_tmp3_ = _tmp2_;
	node_align_align_vcenter (_tmp0_, _tmp3_);
	_g_array_unref0 (_tmp3_);
}

static void
nodes_menu_align_to_right (NodesMenu* self)
{
	DrawArea* _tmp0_;
	DrawArea* _tmp1_;
	GArray* _tmp2_;
	GArray* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	_tmp1_ = self->priv->_da;
	_tmp2_ = draw_area_get_selected_nodes (_tmp1_);
	_tmp3_ = _tmp2_;
	node_align_align_right (_tmp0_, _tmp3_);
	_g_array_unref0 (_tmp3_);
}

static void
nodes_menu_class_init (NodesMenuClass * klass,
                       gpointer klass_data)
{
	nodes_menu_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NodesMenu_private_offset);
	G_OBJECT_CLASS (klass)->finalize = nodes_menu_finalize;
}

static void
nodes_menu_instance_init (NodesMenu * self,
                          gpointer klass)
{
	self->priv = nodes_menu_get_instance_private (self);
}

static void
nodes_menu_finalize (GObject * obj)
{
	NodesMenu * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NODES_MENU, NodesMenu);
	_g_object_unref0 (self->priv->_da);
	_g_object_unref0 (self->priv->_copy);
	_g_object_unref0 (self->priv->_cut);
	_g_object_unref0 (self->priv->_delete);
	_g_object_unref0 (self->priv->_task);
	_g_object_unref0 (self->priv->_fold);
	_g_object_unref0 (self->priv->_sequence);
	_g_object_unref0 (self->priv->_connect);
	_g_object_unref0 (self->priv->_link);
	_g_object_unref0 (self->priv->_link_colors);
	_g_object_unref0 (self->priv->_parent_link_colors);
	_g_object_unref0 (self->priv->_align);
	_g_object_unref0 (self->priv->_selnodes);
	_g_object_unref0 (self->priv->_selparent);
	_g_object_unref0 (self->priv->_selchildren);
	G_OBJECT_CLASS (nodes_menu_parent_class)->finalize (obj);
}

static GType
nodes_menu_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NodesMenuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nodes_menu_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NodesMenu), 0, (GInstanceInitFunc) nodes_menu_instance_init, NULL };
	GType nodes_menu_type_id;
	nodes_menu_type_id = g_type_register_static (gtk_menu_get_type (), "NodesMenu", &g_define_type_info, 0);
	NodesMenu_private_offset = g_type_add_instance_private (nodes_menu_type_id, sizeof (NodesMenuPrivate));
	return nodes_menu_type_id;
}

GType
nodes_menu_get_type (void)
{
	static volatile gsize nodes_menu_type_id__once = 0;
	if (g_once_init_enter (&nodes_menu_type_id__once)) {
		GType nodes_menu_type_id;
		nodes_menu_type_id = nodes_menu_get_type_once ();
		g_once_init_leave (&nodes_menu_type_id__once, nodes_menu_type_id);
	}
	return nodes_menu_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

