/* Preferences.c generated by valac 0.56.18, the Vala compiler
 * generated from Preferences.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <handy.h>
#include <gio/gio.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PREFERENCES (preferences_get_type ())
#define PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES, Preferences))
#define PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES, PreferencesClass))
#define IS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES))
#define IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES))
#define PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES, PreferencesClass))

typedef struct _Preferences Preferences;
typedef struct _PreferencesClass PreferencesClass;
typedef struct _PreferencesPrivate PreferencesPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
enum  {
	PREFERENCES_0_PROPERTY,
	PREFERENCES_NUM_PROPERTIES
};
static GParamSpec* preferences_properties[PREFERENCES_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block34Data Block34Data;

#define TYPE_THEMES (themes_get_type ())
#define THEMES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEMES, Themes))
#define THEMES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEMES, ThemesClass))
#define IS_THEMES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEMES))
#define IS_THEMES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEMES))
#define THEMES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEMES, ThemesClass))

typedef struct _Themes Themes;
typedef struct _ThemesClass ThemesClass;

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block35Data Block35Data;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))

struct _Preferences {
	GtkDialog parent_instance;
	PreferencesPrivate * priv;
};

struct _PreferencesClass {
	GtkDialogClass parent_class;
};

struct _PreferencesPrivate {
	MainWindow* _win;
	GSettings* _settings;
};

struct _Block34Data {
	int _ref_count_;
	Preferences* self;
	GtkMenuButton* mb;
};

struct _Block35Data {
	int _ref_count_;
	Block34Data * _data34_;
	gchar* name;
	gchar* lbl;
};

static gint Preferences_private_offset;
static gpointer preferences_parent_class = NULL;

VALA_EXTERN GType preferences_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Preferences, g_object_unref)
VALA_EXTERN GType main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
VALA_EXTERN Preferences* preferences_new (MainWindow* win,
                              GSettings* settings);
VALA_EXTERN Preferences* preferences_construct (GType object_type,
                                    MainWindow* win,
                                    GSettings* settings);
static GtkGrid* preferences_create_behavior (Preferences* self);
static GtkGrid* preferences_create_appearance (Preferences* self);
static void __lambda163_ (Preferences* self);
static void ___lambda163__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static GtkLabel* preferences_make_label (Preferences* self,
                                  const gchar* label);
static GtkSwitch* preferences_make_switch (Preferences* self,
                                    const gchar* setting);
static GtkImage* preferences_make_info (Preferences* self,
                                 const gchar* detail);
static GtkMenuButton* preferences_make_themes (Preferences* self);
static GtkSpinButton* preferences_make_spinner (Preferences* self,
                                         const gchar* setting,
                                         gint min_value,
                                         gint max_value,
                                         gint step);
static Block34Data* block34_data_ref (Block34Data* _data34_);
static void block34_data_unref (void * _userdata_);
VALA_EXTERN GType themes_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Themes, g_object_unref)
VALA_EXTERN Themes* main_window_get_themes (MainWindow* self);
VALA_EXTERN GType theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Theme, g_object_unref)
VALA_EXTERN Theme* themes_get_theme (Themes* self,
                         const gchar* name);
VALA_EXTERN const gchar* theme_get_label (Theme* self);
static void _g_free0_ (gpointer var);
static void _vala_gchar_free_function_content_of (gpointer data);
VALA_EXTERN void themes_names (Themes* self,
                   GArray** names);
static Block35Data* block35_data_ref (Block35Data* _data35_);
static void block35_data_unref (void * _userdata_);
static void _____lambda162_ (Block35Data* _data35_);
static void ______lambda162__gtk_menu_item_activate (GtkMenuItem* _sender,
                                              gpointer self);
static void preferences_finalize (GObject * obj);
static GType preferences_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
preferences_get_instance_private (Preferences* self)
{
	return G_STRUCT_MEMBER_P (self, Preferences_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda163_ (Preferences* self)
{
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
___lambda163__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	__lambda163_ ((Preferences*) self);
}

Preferences*
preferences_construct (GType object_type,
                       MainWindow* win,
                       GSettings* settings)
{
	Preferences * self = NULL;
	MainWindow* _tmp0_;
	GSettings* _tmp1_;
	GtkStack* stack = NULL;
	GtkStack* _tmp2_;
	GtkGrid* _tmp3_;
	GtkGrid* _tmp4_;
	GtkGrid* _tmp5_;
	GtkGrid* _tmp6_;
	GtkStackSwitcher* switcher = NULL;
	GtkStackSwitcher* _tmp7_;
	GtkBox* box = NULL;
	GtkBox* _tmp8_;
	GtkBox* _tmp9_;
	GtkButton* close_button = NULL;
	GtkButton* _tmp10_;
	g_return_val_if_fail (win != NULL, NULL);
	g_return_val_if_fail (settings != NULL, NULL);
	self = (Preferences*) g_object_new (object_type, "border-width", 5, "deletable", FALSE, "resizable", FALSE, "title", _ ("Preferences"), "transient-for", win, NULL);
	_tmp0_ = _g_object_ref0 (win);
	_g_object_unref0 (self->priv->_win);
	self->priv->_win = _tmp0_;
	_tmp1_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->_settings);
	self->priv->_settings = _tmp1_;
	_tmp2_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp2_);
	stack = _tmp2_;
	g_object_set ((GtkWidget*) stack, "margin", 6, NULL);
	gtk_widget_set_margin_bottom ((GtkWidget*) stack, 18);
	gtk_widget_set_margin_top ((GtkWidget*) stack, 24);
	_tmp3_ = preferences_create_behavior (self);
	_tmp4_ = _tmp3_;
	gtk_stack_add_titled (stack, (GtkWidget*) _tmp4_, "behavior", _ ("Behavior"));
	_g_object_unref0 (_tmp4_);
	_tmp5_ = preferences_create_appearance (self);
	_tmp6_ = _tmp5_;
	gtk_stack_add_titled (stack, (GtkWidget*) _tmp6_, "appearance", _ ("Appearance"));
	_g_object_unref0 (_tmp6_);
	_tmp7_ = (GtkStackSwitcher*) gtk_stack_switcher_new ();
	g_object_ref_sink (_tmp7_);
	switcher = _tmp7_;
	gtk_stack_switcher_set_stack (switcher, stack);
	gtk_widget_set_halign ((GtkWidget*) switcher, GTK_ALIGN_CENTER);
	_tmp8_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp8_);
	box = _tmp8_;
	gtk_box_pack_start (box, (GtkWidget*) switcher, FALSE, TRUE, (guint) 0);
	gtk_box_pack_start (box, (GtkWidget*) stack, TRUE, TRUE, (guint) 0);
	_tmp9_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) box);
	_tmp10_ = (GtkButton*) gtk_button_new_with_label (_ ("Close"));
	g_object_ref_sink (_tmp10_);
	close_button = _tmp10_;
	g_signal_connect_object (close_button, "clicked", (GCallback) ___lambda163__gtk_button_clicked, self, 0);
	gtk_dialog_add_action_widget ((GtkDialog*) self, (GtkWidget*) close_button, 0);
	_g_object_unref0 (close_button);
	_g_object_unref0 (box);
	_g_object_unref0 (switcher);
	_g_object_unref0 (stack);
	return self;
}

Preferences*
preferences_new (MainWindow* win,
                 GSettings* settings)
{
	return preferences_construct (TYPE_PREFERENCES, win, settings);
}

static GtkGrid*
preferences_create_behavior (Preferences* self)
{
	GtkGrid* grid = NULL;
	GtkGrid* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkSwitch* _tmp3_;
	GtkSwitch* _tmp4_;
	GtkImage* _tmp5_;
	GtkImage* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkSwitch* _tmp9_;
	GtkSwitch* _tmp10_;
	GtkImage* _tmp11_;
	GtkImage* _tmp12_;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	GtkSwitch* _tmp15_;
	GtkSwitch* _tmp16_;
	GtkLabel* _tmp17_;
	GtkLabel* _tmp18_;
	GtkSwitch* _tmp19_;
	GtkSwitch* _tmp20_;
	GtkImage* _tmp21_;
	GtkImage* _tmp22_;
	GtkLabel* _tmp23_;
	GtkLabel* _tmp24_;
	GtkSwitch* _tmp25_;
	GtkSwitch* _tmp26_;
	GtkImage* _tmp27_;
	GtkImage* _tmp28_;
	GtkLabel* _tmp29_;
	GtkLabel* _tmp30_;
	GtkSwitch* _tmp31_;
	GtkSwitch* _tmp32_;
	GtkImage* _tmp33_;
	GtkImage* _tmp34_;
	GtkGrid* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	grid = _tmp0_;
	gtk_grid_set_column_spacing (grid, 12);
	gtk_grid_set_row_spacing (grid, 6);
	_tmp1_ = preferences_make_label (self, _ ("Create new node from edit mode"));
	_tmp2_ = _tmp1_;
	gtk_grid_attach (grid, (GtkWidget*) _tmp2_, 0, 0, 1, 1);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = preferences_make_switch (self, "new-node-from-edit");
	_tmp4_ = _tmp3_;
	gtk_grid_attach (grid, (GtkWidget*) _tmp4_, 1, 0, 1, 1);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = preferences_make_info (self, _ ("Specifies if we should create a new node directly from edit mode if Re" \
"turn or Tab is pressed."));
	_tmp6_ = _tmp5_;
	gtk_grid_attach (grid, (GtkWidget*) _tmp6_, 3, 0, 1, 1);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = preferences_make_label (self, _ ("Automatically make embedded URLs into links"));
	_tmp8_ = _tmp7_;
	gtk_grid_attach (grid, (GtkWidget*) _tmp8_, 0, 1, 1, 1);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = preferences_make_switch (self, "auto-parse-embedded-urls");
	_tmp10_ = _tmp9_;
	gtk_grid_attach (grid, (GtkWidget*) _tmp10_, 1, 1, 1, 1);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = preferences_make_info (self, _ ("Specifies if embedded URLs found in node titles should be automaticall" \
"y highlighted."));
	_tmp12_ = _tmp11_;
	gtk_grid_attach (grid, (GtkWidget*) _tmp12_, 3, 1, 1, 1);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = preferences_make_label (self, _ ("Enable Markdown"));
	_tmp14_ = _tmp13_;
	gtk_grid_attach (grid, (GtkWidget*) _tmp14_, 0, 2, 1, 1);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = preferences_make_switch (self, "enable-markdown");
	_tmp16_ = _tmp15_;
	gtk_grid_attach (grid, (GtkWidget*) _tmp16_, 1, 2, 1, 1);
	_g_object_unref0 (_tmp16_);
	_tmp17_ = preferences_make_label (self, _ ("Enable Unicode input"));
	_tmp18_ = _tmp17_;
	gtk_grid_attach (grid, (GtkWidget*) _tmp18_, 0, 3, 1, 1);
	_g_object_unref0 (_tmp18_);
	_tmp19_ = preferences_make_switch (self, "enable-unicode-input");
	_tmp20_ = _tmp19_;
	gtk_grid_attach (grid, (GtkWidget*) _tmp20_, 1, 3, 1, 1);
	_g_object_unref0 (_tmp20_);
	_tmp21_ = preferences_make_info (self, _ ("Specifies if Unicode characters can be input using backslash prefixed " \
"descriptors (ex. \\pi)"));
	_tmp22_ = _tmp21_;
	gtk_grid_attach (grid, (GtkWidget*) _tmp22_, 3, 3, 1, 1);
	_g_object_unref0 (_tmp22_);
	_tmp23_ = preferences_make_label (self, _ ("Create connection title on creation"));
	_tmp24_ = _tmp23_;
	gtk_grid_attach (grid, (GtkWidget*) _tmp24_, 0, 4, 1, 1);
	_g_object_unref0 (_tmp24_);
	_tmp25_ = preferences_make_switch (self, "edit-connection-title-on-creation");
	_tmp26_ = _tmp25_;
	gtk_grid_attach (grid, (GtkWidget*) _tmp26_, 1, 4, 1, 1);
	_g_object_unref0 (_tmp26_);
	_tmp27_ = preferences_make_info (self, _ ("Specifies if the connection title will be added and put into edit mode" \
" immediately after the connection is made."));
	_tmp28_ = _tmp27_;
	gtk_grid_attach (grid, (GtkWidget*) _tmp28_, 3, 4, 1, 1);
	_g_object_unref0 (_tmp28_);
	_tmp29_ = preferences_make_label (self, _ ("Select items on mouse hover"));
	_tmp30_ = _tmp29_;
	gtk_grid_attach (grid, (GtkWidget*) _tmp30_, 0, 5, 1, 1);
	_g_object_unref0 (_tmp30_);
	_tmp31_ = preferences_make_switch (self, "select-on-hover");
	_tmp32_ = _tmp31_;
	gtk_grid_attach (grid, (GtkWidget*) _tmp32_, 1, 5, 1, 1);
	_g_object_unref0 (_tmp32_);
	_tmp33_ = preferences_make_info (self, _ ("If enabled, selects items when mouse cursor hovers over the item."));
	_tmp34_ = _tmp33_;
	gtk_grid_attach (grid, (GtkWidget*) _tmp34_, 3, 5, 1, 1);
	_g_object_unref0 (_tmp34_);
	result = grid;
	return result;
}

static GtkGrid*
preferences_create_appearance (Preferences* self)
{
	GtkGrid* grid = NULL;
	GtkGrid* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkSwitch* _tmp3_;
	GtkSwitch* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkMenuButton* _tmp7_;
	GtkMenuButton* _tmp8_;
	GtkImage* _tmp9_;
	GtkImage* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp12_;
	GtkSwitch* _tmp13_;
	GtkSwitch* _tmp14_;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp16_;
	GtkSwitch* _tmp17_;
	GtkSwitch* _tmp18_;
	GtkSpinButton* _tmp19_;
	GtkSpinButton* _tmp20_;
	GtkImage* _tmp21_;
	GtkImage* _tmp22_;
	GtkLabel* _tmp23_;
	GtkLabel* _tmp24_;
	GtkSwitch* _tmp25_;
	GtkSwitch* _tmp26_;
	GtkGrid* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	grid = _tmp0_;
	gtk_grid_set_column_spacing (grid, 12);
	gtk_grid_set_row_spacing (grid, 6);
	_tmp1_ = preferences_make_label (self, _ ("Hide themes not matching visual style"));
	_tmp2_ = _tmp1_;
	gtk_grid_attach (grid, (GtkWidget*) _tmp2_, 0, 0, 1, 1);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = preferences_make_switch (self, "hide-themes-not-matching-visual-style");
	_tmp4_ = _tmp3_;
	gtk_grid_attach (grid, (GtkWidget*) _tmp4_, 1, 0, 1, 1);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = preferences_make_label (self, _ ("Default theme"));
	_tmp6_ = _tmp5_;
	gtk_grid_attach (grid, (GtkWidget*) _tmp6_, 0, 1, 1, 1);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = preferences_make_themes (self);
	_tmp8_ = _tmp7_;
	gtk_grid_attach (grid, (GtkWidget*) _tmp8_, 1, 1, 2, 1);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = preferences_make_info (self, _ ("Sets the default theme to use for newly created mindmaps (use Map side" \
"bar panel to make immediate changes)."));
	_tmp10_ = _tmp9_;
	gtk_grid_attach (grid, (GtkWidget*) _tmp10_, 3, 1, 1, 1);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = preferences_make_label (self, _ ("Enable animations"));
	_tmp12_ = _tmp11_;
	gtk_grid_attach (grid, (GtkWidget*) _tmp12_, 0, 2, 1, 1);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = preferences_make_switch (self, "enable-animations");
	_tmp14_ = _tmp13_;
	gtk_grid_attach (grid, (GtkWidget*) _tmp14_, 1, 2, 1, 1);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = preferences_make_label (self, _ ("Text field font size"));
	_tmp16_ = _tmp15_;
	gtk_grid_attach (grid, (GtkWidget*) _tmp16_, 0, 3, 1, 1);
	_g_object_unref0 (_tmp16_);
	_tmp17_ = preferences_make_switch (self, "text-field-use-custom-font-size");
	_tmp18_ = _tmp17_;
	gtk_grid_attach (grid, (GtkWidget*) _tmp18_, 1, 3, 1, 1);
	_g_object_unref0 (_tmp18_);
	_tmp19_ = preferences_make_spinner (self, "text-field-custom-font-size", 8, 24, 1);
	_tmp20_ = _tmp19_;
	gtk_grid_attach (grid, (GtkWidget*) _tmp20_, 2, 3, 1, 1);
	_g_object_unref0 (_tmp20_);
	_tmp21_ = preferences_make_info (self, _ ("Specifies the custom font size to use in text editing fields (i.e, qui" \
"ck entry or notes field)."));
	_tmp22_ = _tmp21_;
	gtk_grid_attach (grid, (GtkWidget*) _tmp22_, 3, 3, 1, 1);
	_g_object_unref0 (_tmp22_);
	_tmp23_ = preferences_make_label (self, _ ("Colorize note fields"));
	_tmp24_ = _tmp23_;
	gtk_grid_attach (grid, (GtkWidget*) _tmp24_, 0, 4, 1, 1);
	_g_object_unref0 (_tmp24_);
	_tmp25_ = preferences_make_switch (self, "colorize-notes");
	_tmp26_ = _tmp25_;
	gtk_grid_attach (grid, (GtkWidget*) _tmp26_, 1, 4, 1, 1);
	_g_object_unref0 (_tmp26_);
	result = grid;
	return result;
}

static GtkLabel*
preferences_make_label (Preferences* self,
                        const gchar* label)
{
	GtkLabel* w = NULL;
	GtkLabel* _tmp0_;
	GtkLabel* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new (label);
	g_object_ref_sink (_tmp0_);
	w = _tmp0_;
	gtk_widget_set_halign ((GtkWidget*) w, GTK_ALIGN_END);
	gtk_widget_set_margin_start ((GtkWidget*) self, 12);
	result = w;
	return result;
}

static GtkSwitch*
preferences_make_switch (Preferences* self,
                         const gchar* setting)
{
	GtkSwitch* w = NULL;
	GtkSwitch* _tmp0_;
	GSettings* _tmp1_;
	GtkSwitch* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (setting != NULL, NULL);
	_tmp0_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp0_);
	w = _tmp0_;
	gtk_widget_set_halign ((GtkWidget*) w, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) w, GTK_ALIGN_CENTER);
	_tmp1_ = self->priv->_settings;
	g_settings_bind (_tmp1_, setting, (GObject*) w, "active", G_SETTINGS_BIND_DEFAULT);
	result = w;
	return result;
}

static GtkSpinButton*
preferences_make_spinner (Preferences* self,
                          const gchar* setting,
                          gint min_value,
                          gint max_value,
                          gint step)
{
	GtkSpinButton* w = NULL;
	GtkSpinButton* _tmp0_;
	GSettings* _tmp1_;
	GtkSpinButton* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (setting != NULL, NULL);
	_tmp0_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) min_value, (gdouble) max_value, (gdouble) step);
	g_object_ref_sink (_tmp0_);
	w = _tmp0_;
	_tmp1_ = self->priv->_settings;
	g_settings_bind (_tmp1_, setting, (GObject*) w, "value", G_SETTINGS_BIND_DEFAULT);
	result = w;
	return result;
}

static GtkImage*
preferences_make_info (Preferences* self,
                       const gchar* detail)
{
	GtkImage* w = NULL;
	GtkImage* _tmp0_;
	GtkImage* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (detail != NULL, NULL);
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name ("dialog-information-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp0_);
	w = _tmp0_;
	gtk_widget_set_halign ((GtkWidget*) w, GTK_ALIGN_START);
	gtk_widget_set_tooltip_text ((GtkWidget*) w, detail);
	result = w;
	return result;
}

static Block34Data*
block34_data_ref (Block34Data* _data34_)
{
	g_atomic_int_inc (&_data34_->_ref_count_);
	return _data34_;
}

static void
block34_data_unref (void * _userdata_)
{
	Block34Data* _data34_;
	_data34_ = (Block34Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data34_->_ref_count_)) {
		Preferences* self;
		self = _data34_->self;
		_g_object_unref0 (_data34_->mb);
		_g_object_unref0 (self);
		g_slice_free (Block34Data, _data34_);
	}
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_vala_gchar_free_function_content_of (gpointer data)
{
	gchar* self;
	self = *((gchar**) data);
	_g_free0_ (self);
}

static Block35Data*
block35_data_ref (Block35Data* _data35_)
{
	g_atomic_int_inc (&_data35_->_ref_count_);
	return _data35_;
}

static void
block35_data_unref (void * _userdata_)
{
	Block35Data* _data35_;
	_data35_ = (Block35Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data35_->_ref_count_)) {
		Preferences* self;
		self = _data35_->_data34_->self;
		_g_free0 (_data35_->lbl);
		_g_free0 (_data35_->name);
		block34_data_unref (_data35_->_data34_);
		_data35_->_data34_ = NULL;
		g_slice_free (Block35Data, _data35_);
	}
}

static void
_____lambda162_ (Block35Data* _data35_)
{
	Block34Data* _data34_;
	Preferences* self;
	GSettings* _tmp0_;
	const gchar* _tmp1_;
	GtkMenuButton* _tmp2_;
	const gchar* _tmp3_;
	_data34_ = _data35_->_data34_;
	self = _data34_->self;
	_tmp0_ = self->priv->_settings;
	_tmp1_ = _data35_->name;
	g_settings_set_string (_tmp0_, "default-theme", _tmp1_);
	_tmp2_ = _data34_->mb;
	_tmp3_ = _data35_->lbl;
	gtk_button_set_label ((GtkButton*) _tmp2_, _tmp3_);
}

static void
______lambda162__gtk_menu_item_activate (GtkMenuItem* _sender,
                                         gpointer self)
{
	_____lambda162_ (self);
}

static GtkMenuButton*
preferences_make_themes (Preferences* self)
{
	Block34Data* _data34_;
	GtkMenuButton* _tmp0_;
	GtkMenu* mnu = NULL;
	GtkMenu* _tmp1_;
	GtkMenuButton* _tmp2_;
	MainWindow* _tmp3_;
	Themes* _tmp4_;
	Themes* _tmp5_;
	GSettings* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	Theme* _tmp9_;
	Theme* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GtkMenuButton* _tmp13_;
	GtkMenu* _tmp14_;
	GArray* names = NULL;
	GArray* _tmp15_;
	MainWindow* _tmp16_;
	Themes* _tmp17_;
	Themes* _tmp18_;
	GtkMenu* _tmp40_;
	GtkMenuButton* _tmp41_;
	GtkMenuButton* _tmp42_;
	GtkMenuButton* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data34_ = g_slice_new0 (Block34Data);
	_data34_->_ref_count_ = 1;
	_data34_->self = g_object_ref (self);
	_tmp0_ = (GtkMenuButton*) gtk_menu_button_new ();
	g_object_ref_sink (_tmp0_);
	_data34_->mb = _tmp0_;
	_tmp1_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp1_);
	mnu = _tmp1_;
	_tmp2_ = _data34_->mb;
	_tmp3_ = self->priv->_win;
	_tmp4_ = main_window_get_themes (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->_settings;
	_tmp7_ = g_settings_get_string (_tmp6_, "default-theme");
	_tmp8_ = _tmp7_;
	_tmp9_ = themes_get_theme (_tmp5_, _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = theme_get_label (_tmp10_);
	_tmp12_ = _tmp11_;
	gtk_button_set_label ((GtkButton*) _tmp2_, _tmp12_);
	_g_object_unref0 (_tmp10_);
	_g_free0 (_tmp8_);
	_tmp13_ = _data34_->mb;
	_tmp14_ = mnu;
	gtk_menu_button_set_popup (_tmp13_, _tmp14_);
	_tmp15_ = g_array_new (TRUE, TRUE, sizeof (gchar*));
	g_array_set_clear_func (_tmp15_, (GDestroyNotify) _vala_gchar_free_function_content_of);
	names = _tmp15_;
	_tmp16_ = self->priv->_win;
	_tmp17_ = main_window_get_themes (_tmp16_);
	_tmp18_ = _tmp17_;
	themes_names (_tmp18_, &names);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp19_ = FALSE;
			_tmp19_ = TRUE;
			while (TRUE) {
				Block35Data* _data35_;
				GArray* _tmp21_;
				GArray* _tmp22_;
				const gchar* _tmp23_;
				gchar* _tmp24_;
				MainWindow* _tmp25_;
				Themes* _tmp26_;
				Themes* _tmp27_;
				const gchar* _tmp28_;
				Theme* _tmp29_;
				Theme* _tmp30_;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				GtkMenuItem* item = NULL;
				const gchar* _tmp35_;
				GtkMenuItem* _tmp36_;
				GtkMenuItem* _tmp37_;
				GtkMenu* _tmp38_;
				GtkMenuItem* _tmp39_;
				_data35_ = g_slice_new0 (Block35Data);
				_data35_->_ref_count_ = 1;
				_data35_->_data34_ = block34_data_ref (_data34_);
				if (!_tmp19_) {
					gint _tmp20_;
					_tmp20_ = i;
					i = _tmp20_ + 1;
				}
				_tmp19_ = FALSE;
				_tmp21_ = names;
				if (!(((guint) i) < _tmp21_->len)) {
					block35_data_unref (_data35_);
					_data35_ = NULL;
					break;
				}
				_tmp22_ = names;
				_tmp23_ = g_array_index (_tmp22_, gchar*, (guint) i);
				_tmp24_ = g_strdup (_tmp23_);
				_data35_->name = _tmp24_;
				_tmp25_ = self->priv->_win;
				_tmp26_ = main_window_get_themes (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = _data35_->name;
				_tmp29_ = themes_get_theme (_tmp27_, _tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = theme_get_label (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = g_strdup (_tmp32_);
				_tmp34_ = _tmp33_;
				_g_object_unref0 (_tmp30_);
				_data35_->lbl = _tmp34_;
				_tmp35_ = _data35_->lbl;
				_tmp36_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp35_);
				g_object_ref_sink (_tmp36_);
				item = _tmp36_;
				_tmp37_ = item;
				g_signal_connect_data (_tmp37_, "activate", (GCallback) ______lambda162__gtk_menu_item_activate, block35_data_ref (_data35_), (GClosureNotify) block35_data_unref, 0);
				_tmp38_ = mnu;
				_tmp39_ = item;
				gtk_container_add ((GtkContainer*) _tmp38_, (GtkWidget*) _tmp39_);
				_g_object_unref0 (item);
				block35_data_unref (_data35_);
				_data35_ = NULL;
			}
		}
	}
	_tmp40_ = mnu;
	gtk_widget_show_all ((GtkWidget*) _tmp40_);
	_tmp41_ = _data34_->mb;
	_tmp42_ = _g_object_ref0 (_tmp41_);
	result = _tmp42_;
	_g_array_unref0 (names);
	_g_object_unref0 (mnu);
	block34_data_unref (_data34_);
	_data34_ = NULL;
	return result;
}

static void
preferences_class_init (PreferencesClass * klass,
                        gpointer klass_data)
{
	preferences_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Preferences_private_offset);
	G_OBJECT_CLASS (klass)->finalize = preferences_finalize;
}

static void
preferences_instance_init (Preferences * self,
                           gpointer klass)
{
	self->priv = preferences_get_instance_private (self);
}

static void
preferences_finalize (GObject * obj)
{
	Preferences * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PREFERENCES, Preferences);
	_g_object_unref0 (self->priv->_win);
	_g_object_unref0 (self->priv->_settings);
	G_OBJECT_CLASS (preferences_parent_class)->finalize (obj);
}

static GType
preferences_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PreferencesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) preferences_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Preferences), 0, (GInstanceInitFunc) preferences_instance_init, NULL };
	GType preferences_type_id;
	preferences_type_id = g_type_register_static (gtk_dialog_get_type (), "Preferences", &g_define_type_info, 0);
	Preferences_private_offset = g_type_add_instance_private (preferences_type_id, sizeof (PreferencesPrivate));
	return preferences_type_id;
}

GType
preferences_get_type (void)
{
	static volatile gsize preferences_type_id__once = 0;
	if (g_once_init_enter (&preferences_type_id__once)) {
		GType preferences_type_id;
		preferences_type_id = preferences_get_type_once ();
		g_once_init_leave (&preferences_type_id__once, preferences_type_id);
	}
	return preferences_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

