/* ExportImage.c generated by valac 0.56.18, the Vala compiler
 * generated from ExportImage.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <libxml/tree.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_EXPORT (export_get_type ())
#define EXPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT, Export))
#define EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT, ExportClass))
#define IS_EXPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT))
#define IS_EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT))
#define EXPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT, ExportClass))

typedef struct _Export Export;
typedef struct _ExportClass ExportClass;
typedef struct _ExportPrivate ExportPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_EXPORT_IMAGE (export_image_get_type ())
#define EXPORT_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT_IMAGE, ExportImage))
#define EXPORT_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT_IMAGE, ExportImageClass))
#define IS_EXPORT_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT_IMAGE))
#define IS_EXPORT_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT_IMAGE))
#define EXPORT_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT_IMAGE, ExportImageClass))

typedef struct _ExportImage ExportImage;
typedef struct _ExportImageClass ExportImageClass;
typedef struct _ExportImagePrivate ExportImagePrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _Export {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ExportPrivate * priv;
};

struct _ExportClass {
	GTypeClass parent_class;
	void (*finalize) (Export *self);
	gboolean (*export) (Export* self, const gchar* fname, DrawArea* da);
	gboolean (*import) (Export* self, const gchar* fname, DrawArea* da);
	void (*add_settings) (Export* self, GtkGrid* grid);
	void (*save_settings) (Export* self, xmlNode* node);
	void (*load_settings) (Export* self, xmlNode* node);
};

struct _ExportImage {
	Export parent_instance;
	ExportImagePrivate * priv;
};

struct _ExportImageClass {
	ExportClass parent_class;
};

static gpointer export_image_parent_class = NULL;

VALA_EXTERN gpointer export_ref (gpointer instance);
VALA_EXTERN void export_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_export (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_export (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_export (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_export (const GValue* value);
VALA_EXTERN GType export_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Export, export_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN GType export_image_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ExportImage, export_unref)
VALA_EXTERN gboolean export_export (Export* self,
                        const gchar* fname,
                        DrawArea* da);
VALA_EXTERN void export_add_settings (Export* self,
                          GtkGrid* grid);
VALA_EXTERN void export_save_settings (Export* self,
                           xmlNode* node);
VALA_EXTERN void export_load_settings (Export* self,
                           xmlNode* node);
VALA_EXTERN ExportImage* export_image_new (const gchar* type,
                               const gchar* label,
                               gchar** extensions,
                               gint extensions_length1);
VALA_EXTERN ExportImage* export_image_construct (GType object_type,
                                     const gchar* type,
                                     const gchar* label,
                                     gchar** extensions,
                                     gint extensions_length1);
VALA_EXTERN Export* export_new (const gchar* name,
                    const gchar* label,
                    gchar** extensions,
                    gint extensions_length1,
                    gboolean exportable,
                    gboolean importable,
                    gboolean dir);
VALA_EXTERN Export* export_construct (GType object_type,
                          const gchar* name,
                          const gchar* label,
                          gchar** extensions,
                          gint extensions_length1,
                          gboolean exportable,
                          gboolean importable,
                          gboolean dir);
static gboolean export_image_real_export (Export* base,
                                   const gchar* fname,
                                   DrawArea* da);
VALA_EXTERN gint export_get_zoom (Export* self,
                      const gchar* name);
VALA_EXTERN void draw_area_document_rectangle (DrawArea* self,
                                   gdouble* x,
                                   gdouble* y,
                                   gdouble* width,
                                   gdouble* height);
VALA_EXTERN void draw_area_draw_all (DrawArea* self,
                         cairo_t* ctx,
                         gboolean exporting);
VALA_EXTERN const gchar* export_get_name (Export* self);
VALA_EXTERN gint export_get_scale (Export* self,
                       const gchar* name);
static void _vala_array_add28 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add29 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void export_image_real_add_settings (Export* base,
                                     GtkGrid* grid);
VALA_EXTERN void export_add_setting_zoom (Export* self,
                              const gchar* name,
                              GtkGrid* grid,
                              const gchar* label,
                              const gchar* help,
                              gint min,
                              gint max,
                              gint step,
                              gint dflt);
static void export_image_add_settings_jpeg (ExportImage* self,
                                     GtkGrid* grid);
VALA_EXTERN void export_add_setting_scale (Export* self,
                               const gchar* name,
                               GtkGrid* grid,
                               const gchar* label,
                               const gchar* help,
                               gint min,
                               gint max,
                               gint step,
                               gint dflt);
static void export_image_real_save_settings (Export* base,
                                      xmlNode* node);
static void export_image_save_settings_jpeg (ExportImage* self,
                                      xmlNode* node);
static void export_image_real_load_settings (Export* base,
                                      xmlNode* node);
VALA_EXTERN void export_set_zoom (Export* self,
                      const gchar* name,
                      gint value);
static void export_image_load_settings_jpeg (ExportImage* self,
                                      xmlNode* node);
VALA_EXTERN void export_set_scale (Export* self,
                       const gchar* name,
                       gint value);
static GType export_image_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

ExportImage*
export_image_construct (GType object_type,
                        const gchar* type,
                        const gchar* label,
                        gchar** extensions,
                        gint extensions_length1)
{
	ExportImage* self = NULL;
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	self = (ExportImage*) export_construct (object_type, type, label, extensions, (gint) extensions_length1, TRUE, FALSE, FALSE);
	return self;
}

ExportImage*
export_image_new (const gchar* type,
                  const gchar* label,
                  gchar** extensions,
                  gint extensions_length1)
{
	return export_image_construct (TYPE_EXPORT_IMAGE, type, label, extensions, extensions_length1);
}

static void
_vala_array_add28 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add29 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
export_image_real_export (Export* base,
                          const gchar* fname,
                          DrawArea* da)
{
	ExportImage * self;
	gdouble scale = 0.0;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble w = 0.0;
	gdouble h = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	cairo_surface_t* surface = NULL;
	cairo_surface_t* _tmp4_;
	cairo_t* context = NULL;
	cairo_t* _tmp5_;
	GtkStyleContext* _tmp6_;
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp7_;
	gchar** option_keys = NULL;
	gchar** _tmp8_;
	gint option_keys_length1;
	gint _option_keys_size_;
	gchar** option_values = NULL;
	gchar** _tmp9_;
	gint option_values_length1;
	gint _option_values_size_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GQuark _tmp14_ = 0U;
	static GQuark _tmp13_label0 = 0;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (ExportImage*) base;
	g_return_val_if_fail (fname != NULL, FALSE);
	g_return_val_if_fail (da != NULL, FALSE);
	scale = export_get_zoom ((Export*) self, "zoom") / 100.0;
	draw_area_document_rectangle (da, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	x = _tmp0_;
	y = _tmp1_;
	w = _tmp2_;
	h = _tmp3_;
	w *= scale;
	h *= scale;
	_tmp4_ = cairo_image_surface_create (CAIRO_FORMAT_RGB24, ((gint) w) + 20, ((gint) h) + 20);
	surface = _tmp4_;
	_tmp5_ = cairo_create (surface);
	context = _tmp5_;
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) da);
	gtk_render_background (_tmp6_, context, (gdouble) 0, (gdouble) 0, (gdouble) (((gint) w) + 20), (gdouble) (((gint) h) + 20));
	cairo_translate (context, 10 - x, 10 - y);
	cairo_scale (context, scale, scale);
	draw_area_draw_all (da, context, TRUE);
	_tmp7_ = gdk_pixbuf_get_from_surface (surface, 0, 0, ((gint) w) + 20, ((gint) h) + 20);
	pixbuf = _tmp7_;
	_tmp8_ = g_new0 (gchar*, 0 + 1);
	option_keys = _tmp8_;
	option_keys_length1 = 0;
	_option_keys_size_ = option_keys_length1;
	_tmp9_ = g_new0 (gchar*, 0 + 1);
	option_values = _tmp9_;
	option_values_length1 = 0;
	_option_values_size_ = option_values_length1;
	_tmp10_ = export_get_name ((Export*) self);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp14_ = (NULL == _tmp12_) ? 0 : g_quark_from_string (_tmp12_);
	if (_tmp14_ == ((0 != _tmp13_label0) ? _tmp13_label0 : (_tmp13_label0 = g_quark_from_static_string ("jpeg")))) {
		switch (0) {
			default:
			{
				gint value = 0;
				gchar* _tmp15_;
				gchar* _tmp16_;
				value = export_get_scale ((Export*) self, "quality");
				_tmp15_ = g_strdup ("quality");
				_vala_array_add28 (&option_keys, &option_keys_length1, &_option_keys_size_, _tmp15_);
				_tmp16_ = g_strdup_printf ("%i", value);
				_vala_array_add29 (&option_values, &option_values_length1, &_option_values_size_, _tmp16_);
				break;
			}
		}
	}
	{
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar** _tmp19_;
		gint _tmp19__length1;
		gchar** _tmp20_;
		gint _tmp20__length1;
		_tmp17_ = export_get_name ((Export*) self);
		_tmp18_ = _tmp17_;
		_tmp19_ = option_keys;
		_tmp19__length1 = option_keys_length1;
		_tmp20_ = option_values;
		_tmp20__length1 = option_values_length1;
		gdk_pixbuf_savev (pixbuf, fname, _tmp18_, _tmp19_, _tmp20_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		GError* _tmp24_;
		const gchar* _tmp25_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp21_ = stdout;
		_tmp22_ = export_get_name ((Export*) self);
		_tmp23_ = _tmp22_;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->message;
		fprintf (_tmp21_, "Error writing %s: %s\n", _tmp23_, _tmp25_);
		result = FALSE;
		_g_error_free0 (e);
		option_values = (_vala_array_free (option_values, option_values_length1, (GDestroyNotify) g_free), NULL);
		option_keys = (_vala_array_free (option_keys, option_keys_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (pixbuf);
		_cairo_destroy0 (context);
		_cairo_surface_destroy0 (surface);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp26_ = FALSE;
		option_values = (_vala_array_free (option_values, option_values_length1, (GDestroyNotify) g_free), NULL);
		option_keys = (_vala_array_free (option_keys, option_keys_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (pixbuf);
		_cairo_destroy0 (context);
		_cairo_surface_destroy0 (surface);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp26_;
	}
	result = TRUE;
	option_values = (_vala_array_free (option_values, option_values_length1, (GDestroyNotify) g_free), NULL);
	option_keys = (_vala_array_free (option_keys, option_keys_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (pixbuf);
	_cairo_destroy0 (context);
	_cairo_surface_destroy0 (surface);
	return result;
}

static void
export_image_real_add_settings (Export* base,
                                GtkGrid* grid)
{
	ExportImage * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	self = (ExportImage*) base;
	g_return_if_fail (grid != NULL);
	export_add_setting_zoom ((Export*) self, "zoom", grid, _ ("Zoom %"), NULL, 50, 500, 25, 100);
	_tmp0_ = export_get_name ((Export*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("jpeg")))) {
		switch (0) {
			default:
			{
				export_image_add_settings_jpeg (self, grid);
				break;
			}
		}
	}
}

static void
export_image_add_settings_jpeg (ExportImage* self,
                                GtkGrid* grid)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (grid != NULL);
	export_add_setting_scale ((Export*) self, "quality", grid, _ ("Quality"), NULL, 0, 100, 1, 90);
}

static void
export_image_real_save_settings (Export* base,
                                 xmlNode* node)
{
	ExportImage * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	self = (ExportImage*) base;
	_tmp0_ = g_strdup_printf ("%i", export_get_zoom ((Export*) self, "zoom"));
	_tmp1_ = _tmp0_;
	xmlSetProp (node, (xmlChar*) "zoom", (xmlChar*) _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = export_get_name ((Export*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("jpeg")))) {
		switch (0) {
			default:
			{
				export_image_save_settings_jpeg (self, node);
				break;
			}
		}
	}
}

static void
export_image_save_settings_jpeg (ExportImage* self,
                                 xmlNode* node)
{
	gint value = 0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	value = export_get_scale ((Export*) self, "quality");
	_tmp0_ = g_strdup_printf ("%i", value);
	_tmp1_ = _tmp0_;
	xmlSetProp (node, (xmlChar*) "quality", (xmlChar*) _tmp1_);
	_g_free0 (_tmp1_);
}

static void
export_image_real_load_settings (Export* base,
                                 xmlNode* node)
{
	ExportImage * self;
	gchar* z = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GQuark _tmp7_ = 0U;
	static GQuark _tmp6_label0 = 0;
	self = (ExportImage*) base;
	_tmp0_ = (gchar*) xmlGetProp (node, (xmlChar*) "zoom");
	z = _tmp0_;
	_tmp1_ = z;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = z;
		export_set_zoom ((Export*) self, "zoom", atoi (_tmp2_));
	}
	_tmp3_ = export_get_name ((Export*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("jpeg")))) {
		switch (0) {
			default:
			{
				export_image_load_settings_jpeg (self, node);
				break;
			}
		}
	}
	_g_free0 (z);
}

static void
export_image_load_settings_jpeg (ExportImage* self,
                                 xmlNode* node)
{
	gchar* q = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (gchar*) xmlGetProp (node, (xmlChar*) "quality");
	q = _tmp0_;
	_tmp1_ = q;
	if (_tmp1_ != NULL) {
		gint value = 0;
		const gchar* _tmp2_;
		_tmp2_ = q;
		value = atoi (_tmp2_);
		export_set_scale ((Export*) self, "quality", value);
	}
	_g_free0 (q);
}

static void
export_image_class_init (ExportImageClass * klass,
                         gpointer klass_data)
{
	export_image_parent_class = g_type_class_peek_parent (klass);
	((ExportClass *) klass)->export = (gboolean (*) (Export*, const gchar*, DrawArea*)) export_image_real_export;
	((ExportClass *) klass)->add_settings = (void (*) (Export*, GtkGrid*)) export_image_real_add_settings;
	((ExportClass *) klass)->save_settings = (void (*) (Export*, xmlNode*)) export_image_real_save_settings;
	((ExportClass *) klass)->load_settings = (void (*) (Export*, xmlNode*)) export_image_real_load_settings;
}

static void
export_image_instance_init (ExportImage * self,
                            gpointer klass)
{
}

static GType
export_image_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ExportImageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) export_image_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExportImage), 0, (GInstanceInitFunc) export_image_instance_init, NULL };
	GType export_image_type_id;
	export_image_type_id = g_type_register_static (TYPE_EXPORT, "ExportImage", &g_define_type_info, 0);
	return export_image_type_id;
}

GType
export_image_get_type (void)
{
	static volatile gsize export_image_type_id__once = 0;
	if (g_once_init_enter (&export_image_type_id__once)) {
		GType export_image_type_id;
		export_image_type_id = export_image_get_type_once ();
		g_once_init_leave (&export_image_type_id__once, export_image_type_id);
	}
	return export_image_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

