/* ExportPNG.c generated by valac 0.56.18, the Vala compiler
 * generated from ExportPNG.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <libxml/tree.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <stdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_EXPORT (export_get_type ())
#define EXPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT, Export))
#define EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT, ExportClass))
#define IS_EXPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT))
#define IS_EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT))
#define EXPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT, ExportClass))

typedef struct _Export Export;
typedef struct _ExportClass ExportClass;
typedef struct _ExportPrivate ExportPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_EXPORT_PNG (export_png_get_type ())
#define EXPORT_PNG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT_PNG, ExportPNG))
#define EXPORT_PNG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT_PNG, ExportPNGClass))
#define IS_EXPORT_PNG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT_PNG))
#define IS_EXPORT_PNG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT_PNG))
#define EXPORT_PNG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT_PNG, ExportPNGClass))

typedef struct _ExportPNG ExportPNG;
typedef struct _ExportPNGClass ExportPNGClass;
typedef struct _ExportPNGPrivate ExportPNGPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _Export {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ExportPrivate * priv;
};

struct _ExportClass {
	GTypeClass parent_class;
	void (*finalize) (Export *self);
	gboolean (*export) (Export* self, const gchar* fname, DrawArea* da);
	gboolean (*import) (Export* self, const gchar* fname, DrawArea* da);
	void (*add_settings) (Export* self, GtkGrid* grid);
	void (*save_settings) (Export* self, xmlNode* node);
	void (*load_settings) (Export* self, xmlNode* node);
};

struct _ExportPNG {
	Export parent_instance;
	ExportPNGPrivate * priv;
};

struct _ExportPNGClass {
	ExportClass parent_class;
};

static gpointer export_png_parent_class = NULL;

VALA_EXTERN gpointer export_ref (gpointer instance);
VALA_EXTERN void export_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_export (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_export (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_export (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_export (const GValue* value);
VALA_EXTERN GType export_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Export, export_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN GType export_png_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ExportPNG, export_unref)
VALA_EXTERN gboolean export_export (Export* self,
                        const gchar* fname,
                        DrawArea* da);
VALA_EXTERN void export_add_settings (Export* self,
                          GtkGrid* grid);
VALA_EXTERN void export_save_settings (Export* self,
                           xmlNode* node);
VALA_EXTERN void export_load_settings (Export* self,
                           xmlNode* node);
VALA_EXTERN ExportPNG* export_png_new (void);
VALA_EXTERN ExportPNG* export_png_construct (GType object_type);
VALA_EXTERN Export* export_new (const gchar* name,
                    const gchar* label,
                    gchar** extensions,
                    gint extensions_length1,
                    gboolean exportable,
                    gboolean importable,
                    gboolean dir);
VALA_EXTERN Export* export_construct (GType object_type,
                          const gchar* name,
                          const gchar* label,
                          gchar** extensions,
                          gint extensions_length1,
                          gboolean exportable,
                          gboolean importable,
                          gboolean dir);
static gboolean export_png_real_export (Export* base,
                                 const gchar* fname,
                                 DrawArea* da);
VALA_EXTERN gboolean export_get_bool (Export* self,
                          const gchar* name);
VALA_EXTERN gint export_get_zoom (Export* self,
                      const gchar* name);
VALA_EXTERN void draw_area_document_rectangle (DrawArea* self,
                                   gdouble* x,
                                   gdouble* y,
                                   gdouble* width,
                                   gdouble* height);
VALA_EXTERN void draw_area_draw_all (DrawArea* self,
                         cairo_t* ctx,
                         gboolean exporting);
VALA_EXTERN gint export_get_scale (Export* self,
                       const gchar* name);
static void _vala_array_add30 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add31 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
VALA_EXTERN const gchar* export_get_name (Export* self);
static void export_png_real_add_settings (Export* base,
                                   GtkGrid* grid);
VALA_EXTERN void export_add_setting_zoom (Export* self,
                              const gchar* name,
                              GtkGrid* grid,
                              const gchar* label,
                              const gchar* help,
                              gint min,
                              gint max,
                              gint step,
                              gint dflt);
VALA_EXTERN void export_add_setting_bool (Export* self,
                              const gchar* name,
                              GtkGrid* grid,
                              const gchar* label,
                              const gchar* help,
                              gboolean dflt);
VALA_EXTERN void export_add_setting_scale (Export* self,
                               const gchar* name,
                               GtkGrid* grid,
                               const gchar* label,
                               const gchar* help,
                               gint min,
                               gint max,
                               gint step,
                               gint dflt);
static void export_png_real_save_settings (Export* base,
                                    xmlNode* node);
static void export_png_real_load_settings (Export* base,
                                    xmlNode* node);
VALA_EXTERN void export_set_zoom (Export* self,
                      const gchar* name,
                      gint value);
VALA_EXTERN void export_set_bool (Export* self,
                      const gchar* name,
                      gboolean value);
VALA_EXTERN void export_set_scale (Export* self,
                       const gchar* name,
                       gint value);
static GType export_png_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

ExportPNG*
export_png_construct (GType object_type)
{
	ExportPNG* self = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	_tmp0_ = g_strdup (".png");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	self = (ExportPNG*) export_construct (object_type, "png", _ ("PNG"), _tmp2_, (gint) 1, TRUE, FALSE, FALSE);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	return self;
}

ExportPNG*
export_png_new (void)
{
	return export_png_construct (TYPE_EXPORT_PNG);
}

static void
_vala_array_add30 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add31 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
export_png_real_export (Export* base,
                        const gchar* fname,
                        DrawArea* da)
{
	ExportPNG * self;
	gboolean transparent = FALSE;
	gdouble scale = 0.0;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble w = 0.0;
	gdouble h = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	cairo_format_t _tmp4_ = 0;
	cairo_surface_t* surface = NULL;
	cairo_surface_t* _tmp5_;
	cairo_t* context = NULL;
	cairo_surface_t* _tmp6_;
	cairo_t* _tmp7_;
	cairo_t* _tmp10_;
	cairo_t* _tmp11_;
	cairo_t* _tmp12_;
	GdkPixbuf* pixbuf = NULL;
	cairo_surface_t* _tmp13_;
	GdkPixbuf* _tmp14_;
	gchar** option_keys = NULL;
	gchar** _tmp15_;
	gint option_keys_length1;
	gint _option_keys_size_;
	gchar** option_values = NULL;
	gchar** _tmp16_;
	gint option_values_length1;
	gint _option_values_size_;
	gint value = 0;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (ExportPNG*) base;
	g_return_val_if_fail (fname != NULL, FALSE);
	g_return_val_if_fail (da != NULL, FALSE);
	transparent = export_get_bool ((Export*) self, "transparent");
	scale = export_get_zoom ((Export*) self, "zoom") / 100.0;
	draw_area_document_rectangle (da, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	x = _tmp0_;
	y = _tmp1_;
	w = _tmp2_;
	h = _tmp3_;
	w *= scale;
	h *= scale;
	if (transparent) {
		_tmp4_ = CAIRO_FORMAT_ARGB32;
	} else {
		_tmp4_ = CAIRO_FORMAT_RGB24;
	}
	_tmp5_ = cairo_image_surface_create (_tmp4_, ((gint) w) + 20, ((gint) h) + 20);
	surface = _tmp5_;
	_tmp6_ = surface;
	_tmp7_ = cairo_create (_tmp6_);
	context = _tmp7_;
	if (!transparent) {
		GtkStyleContext* _tmp8_;
		cairo_t* _tmp9_;
		_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) da);
		_tmp9_ = context;
		gtk_render_background (_tmp8_, _tmp9_, (gdouble) 0, (gdouble) 0, (gdouble) (((gint) w) + 20), (gdouble) (((gint) h) + 20));
	}
	_tmp10_ = context;
	cairo_translate (_tmp10_, 10 - x, 10 - y);
	_tmp11_ = context;
	cairo_scale (_tmp11_, scale, scale);
	_tmp12_ = context;
	draw_area_draw_all (da, _tmp12_, TRUE);
	_tmp13_ = surface;
	_tmp14_ = gdk_pixbuf_get_from_surface (_tmp13_, 0, 0, ((gint) w) + 20, ((gint) h) + 20);
	pixbuf = _tmp14_;
	_tmp15_ = g_new0 (gchar*, 0 + 1);
	option_keys = _tmp15_;
	option_keys_length1 = 0;
	_option_keys_size_ = option_keys_length1;
	_tmp16_ = g_new0 (gchar*, 0 + 1);
	option_values = _tmp16_;
	option_values_length1 = 0;
	_option_values_size_ = option_values_length1;
	value = export_get_scale ((Export*) self, "compression");
	_tmp17_ = g_strdup ("compression");
	_vala_array_add30 (&option_keys, &option_keys_length1, &_option_keys_size_, _tmp17_);
	_tmp18_ = g_strdup_printf ("%i", value);
	_vala_array_add31 (&option_values, &option_values_length1, &_option_values_size_, _tmp18_);
	{
		GdkPixbuf* _tmp19_;
		gchar** _tmp20_;
		gint _tmp20__length1;
		gchar** _tmp21_;
		gint _tmp21__length1;
		_tmp19_ = pixbuf;
		_tmp20_ = option_keys;
		_tmp20__length1 = option_keys_length1;
		_tmp21_ = option_values;
		_tmp21__length1 = option_values_length1;
		gdk_pixbuf_savev (_tmp19_, fname, "png", _tmp20_, _tmp21_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		GError* _tmp25_;
		const gchar* _tmp26_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp22_ = stdout;
		_tmp23_ = export_get_name ((Export*) self);
		_tmp24_ = _tmp23_;
		_tmp25_ = e;
		_tmp26_ = _tmp25_->message;
		fprintf (_tmp22_, "Error writing %s: %s\n", _tmp24_, _tmp26_);
		result = FALSE;
		_g_error_free0 (e);
		option_values = (_vala_array_free (option_values, option_values_length1, (GDestroyNotify) g_free), NULL);
		option_keys = (_vala_array_free (option_keys, option_keys_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (pixbuf);
		_cairo_destroy0 (context);
		_cairo_surface_destroy0 (surface);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp27_ = FALSE;
		option_values = (_vala_array_free (option_values, option_values_length1, (GDestroyNotify) g_free), NULL);
		option_keys = (_vala_array_free (option_keys, option_keys_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (pixbuf);
		_cairo_destroy0 (context);
		_cairo_surface_destroy0 (surface);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp27_;
	}
	result = TRUE;
	option_values = (_vala_array_free (option_values, option_values_length1, (GDestroyNotify) g_free), NULL);
	option_keys = (_vala_array_free (option_keys, option_keys_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (pixbuf);
	_cairo_destroy0 (context);
	_cairo_surface_destroy0 (surface);
	return result;
}

static void
export_png_real_add_settings (Export* base,
                              GtkGrid* grid)
{
	ExportPNG * self;
	self = (ExportPNG*) base;
	g_return_if_fail (grid != NULL);
	export_add_setting_zoom ((Export*) self, "zoom", grid, _ ("Zoom %"), NULL, 50, 500, 25, 100);
	export_add_setting_bool ((Export*) self, "transparent", grid, _ ("Enable Transparent Background"), NULL, FALSE);
	export_add_setting_scale ((Export*) self, "compression", grid, _ ("Compression"), NULL, 0, 9, 1, 5);
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static void
export_png_real_save_settings (Export* base,
                               xmlNode* node)
{
	ExportPNG * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	self = (ExportPNG*) base;
	_tmp0_ = g_strdup_printf ("%i", export_get_zoom ((Export*) self, "zoom"));
	_tmp1_ = _tmp0_;
	xmlSetProp (node, (xmlChar*) "zoom", (xmlChar*) _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = bool_to_string (export_get_bool ((Export*) self, "transparent"));
	_tmp3_ = _tmp2_;
	xmlSetProp (node, (xmlChar*) "transparent", (xmlChar*) _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = g_strdup_printf ("%i", export_get_scale ((Export*) self, "compression"));
	_tmp5_ = _tmp4_;
	xmlSetProp (node, (xmlChar*) "compression", (xmlChar*) _tmp5_);
	_g_free0 (_tmp5_);
}

static gboolean
bool_parse (const gchar* str)
{
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	if (g_strcmp0 (str, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
export_png_real_load_settings (Export* base,
                               xmlNode* node)
{
	ExportPNG * self;
	gchar* z = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* t = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* c = NULL;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	self = (ExportPNG*) base;
	_tmp0_ = (gchar*) xmlGetProp (node, (xmlChar*) "zoom");
	z = _tmp0_;
	_tmp1_ = z;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = z;
		export_set_zoom ((Export*) self, "zoom", atoi (_tmp2_));
	}
	_tmp3_ = (gchar*) xmlGetProp (node, (xmlChar*) "transparent");
	t = _tmp3_;
	_tmp4_ = t;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		_tmp5_ = t;
		export_set_bool ((Export*) self, "transparent", bool_parse (_tmp5_));
	}
	_tmp6_ = (gchar*) xmlGetProp (node, (xmlChar*) "compression");
	c = _tmp6_;
	_tmp7_ = c;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_;
		_tmp8_ = c;
		export_set_scale ((Export*) self, "compression", atoi (_tmp8_));
	}
	_g_free0 (c);
	_g_free0 (t);
	_g_free0 (z);
}

static void
export_png_class_init (ExportPNGClass * klass,
                       gpointer klass_data)
{
	export_png_parent_class = g_type_class_peek_parent (klass);
	((ExportClass *) klass)->export = (gboolean (*) (Export*, const gchar*, DrawArea*)) export_png_real_export;
	((ExportClass *) klass)->add_settings = (void (*) (Export*, GtkGrid*)) export_png_real_add_settings;
	((ExportClass *) klass)->save_settings = (void (*) (Export*, xmlNode*)) export_png_real_save_settings;
	((ExportClass *) klass)->load_settings = (void (*) (Export*, xmlNode*)) export_png_real_load_settings;
}

static void
export_png_instance_init (ExportPNG * self,
                          gpointer klass)
{
}

static GType
export_png_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ExportPNGClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) export_png_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExportPNG), 0, (GInstanceInitFunc) export_png_instance_init, NULL };
	GType export_png_type_id;
	export_png_type_id = g_type_register_static (TYPE_EXPORT, "ExportPNG", &g_define_type_info, 0);
	return export_png_type_id;
}

GType
export_png_get_type (void)
{
	static volatile gsize export_png_type_id__once = 0;
	if (g_once_init_enter (&export_png_type_id__once)) {
		GType export_png_type_id;
		export_png_type_id = export_png_get_type_once ();
		g_once_init_leave (&export_png_type_id__once, export_png_type_id);
	}
	return export_png_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

