/* Generated by wayland-scanner 1.24.0 */

#ifndef COMMIT_TIMING_V1_SERVER_PROTOCOL_H
#define COMMIT_TIMING_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server-core.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_commit_timing_v1 The commit_timing_v1 protocol
 * @section page_ifaces_commit_timing_v1 Interfaces
 * - @subpage page_iface_wp_commit_timing_manager_v1 - commit timing
 * - @subpage page_iface_wp_commit_timer_v1 - Surface commit timer
 * @section page_copyright_commit_timing_v1 Copyright
 * <pre>
 *
 * Copyright © 2023 Valve Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_surface;
struct wp_commit_timer_v1;
struct wp_commit_timing_manager_v1;

#ifndef WP_COMMIT_TIMING_MANAGER_V1_INTERFACE
#define WP_COMMIT_TIMING_MANAGER_V1_INTERFACE
/**
 * @page page_iface_wp_commit_timing_manager_v1 wp_commit_timing_manager_v1
 * @section page_iface_wp_commit_timing_manager_v1_desc Description
 *
 * When a compositor latches on to new content updates it will check for
 * any number of requirements of the available content updates (such as
 * fences of all buffers being signalled) to consider the update ready.
 *
 * This protocol provides a method for adding a time constraint to surface
 * content. This constraint indicates to the compositor that a content
 * update should be presented as closely as possible to, but not before,
 * a specified time.
 *
 * This protocol does not change the Wayland property that content
 * updates are applied in the order they are received, even when some
 * content updates contain timestamps and others do not.
 *
 * To provide timestamps, this global factory interface must be used to
 * acquire a wp_commit_timing_v1 object for a surface, which may then be
 * used to provide timestamp information for commits.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_wp_commit_timing_manager_v1_api API
 * See @ref iface_wp_commit_timing_manager_v1.
 */
/**
 * @defgroup iface_wp_commit_timing_manager_v1 The wp_commit_timing_manager_v1 interface
 *
 * When a compositor latches on to new content updates it will check for
 * any number of requirements of the available content updates (such as
 * fences of all buffers being signalled) to consider the update ready.
 *
 * This protocol provides a method for adding a time constraint to surface
 * content. This constraint indicates to the compositor that a content
 * update should be presented as closely as possible to, but not before,
 * a specified time.
 *
 * This protocol does not change the Wayland property that content
 * updates are applied in the order they are received, even when some
 * content updates contain timestamps and others do not.
 *
 * To provide timestamps, this global factory interface must be used to
 * acquire a wp_commit_timing_v1 object for a surface, which may then be
 * used to provide timestamp information for commits.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface wp_commit_timing_manager_v1_interface;
#endif
#ifndef WP_COMMIT_TIMER_V1_INTERFACE
#define WP_COMMIT_TIMER_V1_INTERFACE
/**
 * @page page_iface_wp_commit_timer_v1 wp_commit_timer_v1
 * @section page_iface_wp_commit_timer_v1_desc Description
 *
 * An object to set a time constraint for a content update on a surface.
 * @section page_iface_wp_commit_timer_v1_api API
 * See @ref iface_wp_commit_timer_v1.
 */
/**
 * @defgroup iface_wp_commit_timer_v1 The wp_commit_timer_v1 interface
 *
 * An object to set a time constraint for a content update on a surface.
 */
extern const struct wl_interface wp_commit_timer_v1_interface;
#endif

#ifndef WP_COMMIT_TIMING_MANAGER_V1_ERROR_ENUM
#define WP_COMMIT_TIMING_MANAGER_V1_ERROR_ENUM
enum wp_commit_timing_manager_v1_error {
	/**
	 * commit timer already exists for surface
	 */
	WP_COMMIT_TIMING_MANAGER_V1_ERROR_COMMIT_TIMER_EXISTS = 0,
};
#endif /* WP_COMMIT_TIMING_MANAGER_V1_ERROR_ENUM */

#ifndef WP_COMMIT_TIMING_MANAGER_V1_ERROR_ENUM_IS_VALID
#define WP_COMMIT_TIMING_MANAGER_V1_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_wp_commit_timing_manager_v1
 * Validate a wp_commit_timing_manager_v1 error value.
 *
 * @return true on success, false on error.
 * @ref wp_commit_timing_manager_v1_error
 */
static inline bool
wp_commit_timing_manager_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case WP_COMMIT_TIMING_MANAGER_V1_ERROR_COMMIT_TIMER_EXISTS:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* WP_COMMIT_TIMING_MANAGER_V1_ERROR_ENUM_IS_VALID */

/**
 * @ingroup iface_wp_commit_timing_manager_v1
 * @struct wp_commit_timing_manager_v1_interface
 */
struct wp_commit_timing_manager_v1_interface {
	/**
	 * unbind from the commit timing interface
	 *
	 * Informs the server that the client will no longer be using
	 * this protocol object. Existing objects created by this object
	 * are not affected.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * request commit timer interface for surface
	 *
	 * Establish a timing controller for a surface.
	 *
	 * Only one commit timer can be created for a surface, or a
	 * commit_timer_exists protocol error will be generated.
	 */
	void (*get_timer)(struct wl_client *client,
			  struct wl_resource *resource,
			  uint32_t id,
			  struct wl_resource *surface);
};


/**
 * @ingroup iface_wp_commit_timing_manager_v1
 */
#define WP_COMMIT_TIMING_MANAGER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_wp_commit_timing_manager_v1
 */
#define WP_COMMIT_TIMING_MANAGER_V1_GET_TIMER_SINCE_VERSION 1

#ifndef WP_COMMIT_TIMER_V1_ERROR_ENUM
#define WP_COMMIT_TIMER_V1_ERROR_ENUM
enum wp_commit_timer_v1_error {
	/**
	 * timestamp contains an invalid value
	 */
	WP_COMMIT_TIMER_V1_ERROR_INVALID_TIMESTAMP = 0,
	/**
	 * timestamp exists
	 */
	WP_COMMIT_TIMER_V1_ERROR_TIMESTAMP_EXISTS = 1,
	/**
	 * the associated surface no longer exists
	 */
	WP_COMMIT_TIMER_V1_ERROR_SURFACE_DESTROYED = 2,
};
#endif /* WP_COMMIT_TIMER_V1_ERROR_ENUM */

#ifndef WP_COMMIT_TIMER_V1_ERROR_ENUM_IS_VALID
#define WP_COMMIT_TIMER_V1_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_wp_commit_timer_v1
 * Validate a wp_commit_timer_v1 error value.
 *
 * @return true on success, false on error.
 * @ref wp_commit_timer_v1_error
 */
static inline bool
wp_commit_timer_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case WP_COMMIT_TIMER_V1_ERROR_INVALID_TIMESTAMP:
		return version >= 1;
	case WP_COMMIT_TIMER_V1_ERROR_TIMESTAMP_EXISTS:
		return version >= 1;
	case WP_COMMIT_TIMER_V1_ERROR_SURFACE_DESTROYED:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* WP_COMMIT_TIMER_V1_ERROR_ENUM_IS_VALID */

/**
 * @ingroup iface_wp_commit_timer_v1
 * @struct wp_commit_timer_v1_interface
 */
struct wp_commit_timer_v1_interface {
	/**
	 * Specify time the following commit takes effect
	 *
	 * Provide a timing constraint for a surface content update.
	 *
	 * A set_timestamp request may be made before a wl_surface.commit
	 * to tell the compositor that the content is intended to be
	 * presented as closely as possible to, but not before, the
	 * specified time. The time is in the domain of the compositor's
	 * presentation clock.
	 *
	 * An invalid_timestamp error will be generated for invalid
	 * tv_nsec.
	 *
	 * If a timestamp already exists on the surface, a timestamp_exists
	 * error is generated.
	 *
	 * Requesting set_timestamp after the commit_timer object's surface
	 * is destroyed will generate a "surface_destroyed" error.
	 * @param tv_sec_hi high 32 bits of the seconds part of target time
	 * @param tv_sec_lo low 32 bits of the seconds part of target time
	 * @param tv_nsec nanoseconds part of target time
	 */
	void (*set_timestamp)(struct wl_client *client,
			      struct wl_resource *resource,
			      uint32_t tv_sec_hi,
			      uint32_t tv_sec_lo,
			      uint32_t tv_nsec);
	/**
	 * Destroy the timer
	 *
	 * Informs the server that the client will no longer be using
	 * this protocol object.
	 *
	 * Existing timing constraints are not affected by the destruction.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};


/**
 * @ingroup iface_wp_commit_timer_v1
 */
#define WP_COMMIT_TIMER_V1_SET_TIMESTAMP_SINCE_VERSION 1
/**
 * @ingroup iface_wp_commit_timer_v1
 */
#define WP_COMMIT_TIMER_V1_DESTROY_SINCE_VERSION 1

#ifdef  __cplusplus
}
#endif

#endif
