# 16 "src/lexers.mll"
 
exception Error of (string * Loc.location)

let error source lexbuf fmt =
  Printf.ksprintf (fun s ->
    raise (Error (s, Loc.of_lexbuf source lexbuf))
  ) fmt

open Glob_ast

type conf_values =
  { plus_tags   : (string * Loc.location) list;
    minus_tags  : (string * Loc.location) list }

type conf = (Glob.globber * conf_values) list

let empty = { plus_tags = []; minus_tags = [] }

let locate source lexbuf txt =
  (txt, Loc.of_lexbuf source lexbuf)

let sublex lexer s = lexer (Lexing.from_string s)

# 26 "src/lexers.ml"
let __ocaml_lex_tables = {
  Lexing.lex_base =
   "\000\000\253\255\254\255\001\000\255\255\002\000\007\000\008\000\
    \254\255\012\000\017\000\022\000\033\000\254\255\013\000\003\000\
    \038\000\043\000\018\000\004\000\054\000\059\000\252\255\064\000\
    \069\000\075\000\080\000\090\000\096\000\254\255\023\000\255\255\
    \027\000\086\000\252\255\253\255\102\000\104\000\108\000\255\255\
    \029\000\112\000\253\255\254\255\117\000\123\000\130\000\138\000\
    \145\000\151\000\252\255\253\255\156\000\160\000\164\000\255\255\
    \166\000\175\000\253\255\181\000\182\000\190\000\197\000\203\000\
    \208\000\218\000\250\255\226\000\252\255\026\000\253\255\232\000\
    \035\001\255\000\238\000\013\001\026\001\097\001\254\255\047\000\
    \255\255\069\001\036\001\041\001\088\001\070\000\104\001\112\001\
    \211\000\233\000\051\001\023\001\128\000\125\001\082\001\196\001\
    \253\255\212\001\232\001\245\001\021\000\255\001\009\002\056\000\
    \032\002\045\002\255\255\055\002\254\255\175\001\252\255\253\255\
    \094\000\254\255\167\001\252\000\218\001\006\001\047\002\092\002\
    \075\001\182\001\114\000\251\255\079\000\142\000\008\003\108\001\
    \254\255\253\255\118\000\041\000\253\255\254\255\140\000\255\255\
    \137\001\254\255\026\000\188\001\210\001\030\000\250\001\014\002\
    \038\000\036\000\048\000\050\000\063\000\108\000\102\002\202\001\
    \050\002\155\001\070\000\070\000\087\000\083\000\096\000\091\000\
    \089\000\105\000\100\000\106\000\160\000\131\002\200\001\221\001\
    \159\001\122\000\118\000\118\000\132\000\127\000\134\000\191\000\
    \136\002\211\001\233\001\173\001\140\000\156\000\157\000\161\000\
    \152\000\170\000\240\000\166\000\245\000\235\000\144\002\097\002\
    \106\002\192\001\193\000\198\000\206\000\203\000\209\000\206\000\
    \213\000\018\001\157\002\107\002\108\002\068\002\222\000\244\000\
    \248\000\238\000\254\000\000\001\009\001\067\001\168\002\112\002\
    \117\002\148\002\178\002\185\002\194\002\209\002\119\002\215\002\
    \198\002\254\255\236\002\098\001\255\255\170\002\253\255\125\002\
    \153\002\116\001\254\255";
  Lexing.lex_backtrk =
   "\255\255\255\255\255\255\002\000\255\255\255\255\255\255\001\000\
    \255\255\000\000\002\000\255\255\255\255\255\255\002\000\002\000\
    \000\000\002\000\255\255\255\255\255\255\255\255\255\255\002\000\
    \002\000\004\000\004\000\255\255\255\255\255\255\000\000\255\255\
    \255\255\255\255\255\255\255\255\001\000\003\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\002\000\002\000\255\255\255\255\
    \000\000\255\255\255\255\255\255\001\000\003\000\255\255\255\255\
    \255\255\255\255\255\255\001\000\003\000\003\000\255\255\255\255\
    \000\000\255\255\255\255\005\000\255\255\002\000\255\255\005\000\
    \005\000\004\000\255\255\255\255\255\255\255\255\255\255\000\000\
    \255\255\004\000\255\255\000\000\000\000\255\255\255\255\255\255\
    \255\255\255\255\000\000\000\000\255\255\004\000\255\255\255\255\
    \255\255\001\000\001\000\001\000\255\255\255\255\000\000\255\255\
    \255\255\000\000\255\255\001\000\255\255\255\255\255\255\255\255\
    \001\000\255\255\000\000\003\000\003\000\255\255\255\255\255\255\
    \255\255\000\000\255\255\255\255\003\000\000\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\001\000\255\255\
    \255\255\255\255\001\000\001\000\001\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\000\000\
    \000\000\255\255\000\000\000\000\000\000\000\000\000\000\000\000\
    \255\255\255\255\000\000\255\255\255\255\000\000\255\255\255\255\
    \000\000\001\000\255\255";
  Lexing.lex_default =
   "\003\000\000\000\000\000\005\000\000\000\005\000\009\000\255\255\
    \000\000\009\000\009\000\009\000\016\000\000\000\255\255\255\255\
    \016\000\016\000\255\255\255\255\016\000\023\000\000\000\023\000\
    \024\000\023\000\023\000\023\000\023\000\000\000\255\255\000\000\
    \032\000\036\000\000\000\000\000\036\000\036\000\036\000\000\000\
    \255\255\042\000\000\000\000\000\048\000\255\255\048\000\255\255\
    \048\000\052\000\000\000\000\000\052\000\052\000\052\000\000\000\
    \255\255\059\000\000\000\059\000\064\000\059\000\064\000\059\000\
    \064\000\067\000\000\000\074\000\000\000\255\255\000\000\076\000\
    \074\000\255\255\074\000\074\000\076\000\074\000\000\000\255\255\
    \000\000\088\000\076\000\255\255\255\255\255\255\255\255\255\255\
    \088\000\088\000\255\255\255\255\255\255\255\255\074\000\097\000\
    \000\000\097\000\097\000\102\000\100\000\107\000\102\000\103\000\
    \105\000\105\000\000\000\107\000\000\000\110\000\000\000\000\000\
    \255\255\000\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\125\000\000\000\255\255\125\000\255\255\127\000\
    \000\000\000\000\255\255\133\000\000\000\000\000\255\255\000\000\
    \137\000\000\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\153\000\255\255\
    \255\255\153\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\168\000\255\255\255\255\
    \168\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \179\000\255\255\255\255\179\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\193\000\255\255\
    \255\255\193\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\205\000\255\255\255\255\205\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\217\000\255\255\
    \255\255\217\000\219\000\219\000\219\000\219\000\255\255\255\255\
    \226\000\000\000\226\000\227\000\000\000\255\255\000\000\255\255\
    \255\255\255\255\000\000";
  Lexing.lex_trans =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\001\000\255\255\255\255\001\000\255\255\255\255\
    \010\000\008\000\008\000\010\000\007\000\255\255\255\255\019\000\
    \255\255\255\255\011\000\008\000\019\000\011\000\007\000\011\000\
    \008\000\031\000\011\000\007\000\070\000\031\000\040\000\010\000\
    \030\000\040\000\017\000\015\000\255\255\017\000\014\000\255\255\
    \255\255\011\000\255\255\255\255\020\000\019\000\011\000\020\000\
    \018\000\080\000\001\000\004\000\004\000\040\000\108\000\020\000\
    \019\000\017\000\020\000\018\000\025\000\025\000\255\255\025\000\
    \026\000\255\255\255\255\020\000\255\255\255\255\032\000\031\000\
    \086\000\032\000\030\000\087\000\027\000\027\000\020\000\027\000\
    \028\000\027\000\027\000\025\000\027\000\028\000\024\000\037\000\
    \255\255\106\000\037\000\027\000\027\000\032\000\027\000\028\000\
    \113\000\027\000\027\000\027\000\027\000\028\000\024\000\040\000\
    \027\000\038\000\040\000\024\000\038\000\038\000\037\000\126\000\
    \038\000\045\000\027\000\144\000\045\000\024\000\046\000\144\000\
    \027\000\046\000\034\000\024\000\047\000\134\000\040\000\047\000\
    \038\000\145\000\073\000\046\000\038\000\093\000\046\000\146\000\
    \045\000\147\000\255\255\047\000\255\255\046\000\047\000\124\000\
    \255\255\148\000\255\255\047\000\044\000\255\255\127\000\127\000\
    \053\000\255\255\046\000\053\000\149\000\056\000\150\000\046\000\
    \056\000\054\000\047\000\155\000\054\000\054\000\255\255\056\000\
    \054\000\255\255\056\000\255\255\135\000\135\000\046\000\053\000\
    \061\000\156\000\157\000\061\000\056\000\255\255\255\255\062\000\
    \054\000\255\255\062\000\050\000\054\000\158\000\056\000\063\000\
    \255\255\159\000\063\000\160\000\255\255\161\000\062\000\061\000\
    \255\255\062\000\162\000\163\000\063\000\255\255\062\000\063\000\
    \164\000\255\255\165\000\060\000\255\255\080\000\063\000\170\000\
    \079\000\255\255\255\255\072\000\070\000\062\000\072\000\069\000\
    \171\000\172\000\062\000\063\000\255\255\173\000\174\000\255\255\
    \255\255\255\255\080\000\091\000\175\000\079\000\090\000\062\000\
    \255\255\176\000\072\000\255\255\255\255\071\000\181\000\182\000\
    \002\000\255\255\255\255\013\000\013\000\183\000\118\000\255\255\
    \073\000\119\000\184\000\073\000\255\255\013\000\185\000\186\000\
    \118\000\255\255\013\000\119\000\066\000\255\255\255\255\086\000\
    \187\000\188\000\087\000\029\000\073\000\039\000\189\000\073\000\
    \073\000\013\000\081\000\073\000\080\000\190\000\255\255\079\000\
    \073\000\132\000\195\000\013\000\077\000\070\000\084\000\077\000\
    \069\000\083\000\086\000\084\000\196\000\086\000\013\000\073\000\
    \255\255\197\000\198\000\022\000\073\000\091\000\094\000\073\000\
    \255\255\199\000\200\000\077\000\082\000\029\000\076\000\073\000\
    \201\000\086\000\094\000\022\000\202\000\207\000\081\000\080\000\
    \022\000\081\000\079\000\073\000\081\000\114\000\035\000\208\000\
    \121\000\209\000\022\000\092\000\086\000\073\000\081\000\087\000\
    \022\000\086\000\210\000\073\000\086\000\081\000\039\000\211\000\
    \035\000\094\000\077\000\070\000\035\000\077\000\069\000\212\000\
    \043\000\086\000\123\000\092\000\086\000\255\255\082\000\213\000\
    \086\000\086\000\086\000\043\000\086\000\214\000\234\000\075\000\
    \082\000\077\000\255\255\000\000\076\000\085\000\073\000\073\000\
    \086\000\073\000\043\000\228\000\073\000\000\000\255\255\092\000\
    \086\000\255\255\073\000\140\000\255\255\129\000\139\000\051\000\
    \000\000\000\000\000\000\073\000\055\000\073\000\000\000\000\000\
    \051\000\089\000\073\000\000\000\051\000\152\000\055\000\000\000\
    \151\000\167\000\073\000\000\000\166\000\000\000\094\000\058\000\
    \114\000\000\000\000\000\114\000\085\000\255\255\255\255\178\000\
    \116\000\113\000\177\000\116\000\112\000\075\000\058\000\114\000\
    \114\000\000\000\114\000\000\000\085\000\255\255\143\000\114\000\
    \130\000\142\000\192\000\058\000\085\000\191\000\096\000\116\000\
    \255\255\096\000\167\000\078\000\152\000\166\000\114\000\151\000\
    \000\000\092\000\068\000\114\000\143\000\178\000\255\255\142\000\
    \177\000\255\255\255\255\118\000\096\000\000\000\118\000\167\000\
    \078\000\078\000\166\000\096\000\096\000\096\000\255\255\098\000\
    \096\000\099\000\255\255\178\000\255\255\255\255\177\000\000\000\
    \000\000\138\000\118\000\255\255\100\000\255\255\096\000\255\255\
    \255\255\000\000\255\255\120\000\143\000\000\000\114\000\142\000\
    \255\255\255\255\000\000\115\000\255\255\255\255\101\000\255\255\
    \100\000\255\255\120\000\255\255\255\255\255\255\255\255\000\000\
    \143\000\000\000\078\000\142\000\255\255\100\000\255\255\255\255\
    \000\000\255\255\101\000\068\000\078\000\000\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\141\000\255\255\154\000\101\000\
    \255\255\103\000\255\255\000\000\180\000\255\255\117\000\255\255\
    \118\000\255\255\255\255\118\000\152\000\000\000\169\000\151\000\
    \255\255\255\255\141\000\104\000\255\255\078\000\000\000\255\255\
    \255\255\255\255\180\000\000\000\255\255\255\255\204\000\118\000\
    \000\000\203\000\255\255\169\000\255\255\255\255\255\255\255\255\
    \000\000\255\255\255\255\114\000\000\000\000\000\255\255\255\255\
    \255\255\068\000\255\255\255\255\000\000\118\000\118\000\255\255\
    \118\000\000\000\141\000\192\000\255\255\000\000\191\000\150\000\
    \152\000\255\255\150\000\151\000\192\000\204\000\204\000\191\000\
    \203\000\203\000\216\000\000\000\118\000\215\000\141\000\216\000\
    \222\000\222\000\215\000\222\000\223\000\000\000\150\000\234\000\
    \114\000\255\255\233\000\117\000\165\000\167\000\000\000\165\000\
    \166\000\176\000\178\000\000\000\176\000\177\000\154\000\222\000\
    \000\000\190\000\192\000\255\255\190\000\191\000\216\000\255\255\
    \000\000\215\000\232\000\165\000\000\000\232\000\202\000\204\000\
    \176\000\202\000\203\000\000\000\000\000\255\255\000\000\111\000\
    \190\000\214\000\216\000\232\000\214\000\215\000\232\000\000\000\
    \117\000\232\000\000\000\220\000\220\000\202\000\220\000\221\000\
    \255\255\000\000\222\000\222\000\096\000\222\000\223\000\000\000\
    \214\000\000\000\232\000\220\000\220\000\194\000\220\000\221\000\
    \225\000\000\000\220\000\225\000\255\255\000\000\194\000\206\000\
    \206\000\222\000\220\000\220\000\000\000\220\000\221\000\000\000\
    \222\000\222\000\220\000\222\000\223\000\000\000\225\000\000\000\
    \255\255\000\000\000\000\000\000\000\000\225\000\225\000\225\000\
    \000\000\220\000\225\000\000\000\000\000\255\255\255\255\222\000\
    \000\000\255\255\000\000\000\000\000\000\000\000\000\000\255\255\
    \225\000\000\000\000\000\000\000\000\000\000\000\231\000\000\000\
    \000\000\255\255\000\000\000\000\255\255\000\000\000\000\000\000\
    \000\000\000\000\000\000\255\255\227\000\255\255\000\000\000\000\
    \255\255\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \255\255\000\000\000\000\000\000\000\000\000\000\255\255\000\000\
    \000\000\000\000\000\000\000\000\000\000\255\255\000\000\000\000\
    \000\000\128\000\000\000\000\000\000\000\126\000\000\000\255\255\
    \126\000\126\000\126\000\126\000\126\000\126\000\126\000\126\000\
    \126\000\126\000\127\000\000\000\255\255\000\000\000\000\000\000\
    \000\000\126\000\126\000\126\000\126\000\126\000\126\000\126\000\
    \126\000\126\000\126\000\126\000\126\000\126\000\126\000\126\000\
    \126\000\126\000\126\000\126\000\126\000\126\000\126\000\126\000\
    \126\000\126\000\126\000\000\000\000\000\000\000\255\255\126\000\
    \000\000\126\000\126\000\126\000\126\000\126\000\126\000\126\000\
    \126\000\126\000\126\000\126\000\126\000\126\000\126\000\126\000\
    \126\000\126\000\126\000\126\000\126\000\126\000\126\000\126\000\
    \126\000\126\000\126\000\255\255\000\000\000\000\000\000\000\000\
    \255\255\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \255\255\000\000\000\000\000\000\255\255\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\255\255\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \255\255\000\000\230\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\255\255\000\000\000\000\000\000\000\000\000\000\
    \000\000\255\255\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\255\255\000\000\000\000\000\000\255\255\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\255\255\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\255\255\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000";
  Lexing.lex_check =
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\000\000\003\000\005\000\000\000\003\000\005\000\
    \006\000\006\000\007\000\006\000\006\000\009\000\009\000\014\000\
    \009\000\009\000\010\000\010\000\018\000\010\000\010\000\011\000\
    \011\000\030\000\011\000\011\000\069\000\032\000\040\000\006\000\
    \032\000\040\000\012\000\012\000\009\000\012\000\012\000\016\000\
    \016\000\010\000\016\000\016\000\017\000\017\000\011\000\017\000\
    \017\000\079\000\000\000\003\000\005\000\040\000\100\000\020\000\
    \020\000\012\000\020\000\020\000\021\000\021\000\016\000\021\000\
    \021\000\023\000\023\000\017\000\023\000\023\000\024\000\024\000\
    \085\000\024\000\024\000\085\000\025\000\025\000\020\000\025\000\
    \025\000\026\000\026\000\021\000\026\000\026\000\021\000\033\000\
    \023\000\103\000\033\000\027\000\027\000\024\000\027\000\027\000\
    \112\000\028\000\028\000\025\000\028\000\028\000\025\000\036\000\
    \026\000\037\000\036\000\026\000\037\000\038\000\033\000\124\000\
    \038\000\041\000\027\000\138\000\041\000\027\000\044\000\141\000\
    \028\000\044\000\033\000\028\000\045\000\131\000\036\000\045\000\
    \037\000\144\000\092\000\046\000\038\000\092\000\046\000\145\000\
    \041\000\146\000\036\000\047\000\037\000\044\000\047\000\122\000\
    \038\000\147\000\048\000\045\000\041\000\048\000\130\000\130\000\
    \049\000\044\000\046\000\049\000\148\000\052\000\149\000\045\000\
    \052\000\053\000\047\000\154\000\053\000\054\000\046\000\056\000\
    \054\000\048\000\056\000\125\000\134\000\134\000\047\000\049\000\
    \057\000\155\000\156\000\057\000\052\000\048\000\059\000\060\000\
    \053\000\059\000\060\000\049\000\054\000\157\000\056\000\061\000\
    \052\000\158\000\061\000\159\000\053\000\160\000\062\000\057\000\
    \054\000\062\000\161\000\162\000\063\000\059\000\060\000\063\000\
    \163\000\064\000\164\000\057\000\064\000\088\000\061\000\169\000\
    \088\000\059\000\060\000\065\000\065\000\062\000\065\000\065\000\
    \170\000\171\000\061\000\063\000\067\000\172\000\173\000\067\000\
    \064\000\062\000\071\000\089\000\174\000\071\000\089\000\063\000\
    \074\000\175\000\065\000\074\000\064\000\065\000\180\000\181\000\
    \000\000\003\000\005\000\015\000\019\000\182\000\115\000\006\000\
    \073\000\115\000\183\000\073\000\009\000\014\000\184\000\185\000\
    \117\000\010\000\018\000\117\000\065\000\100\000\011\000\075\000\
    \186\000\187\000\075\000\032\000\067\000\040\000\188\000\073\000\
    \091\000\012\000\071\000\091\000\076\000\189\000\016\000\076\000\
    \074\000\131\000\194\000\017\000\072\000\072\000\082\000\072\000\
    \072\000\082\000\083\000\083\000\195\000\083\000\020\000\091\000\
    \103\000\196\000\197\000\021\000\090\000\090\000\067\000\090\000\
    \023\000\198\000\199\000\072\000\071\000\024\000\072\000\075\000\
    \200\000\083\000\074\000\025\000\201\000\206\000\081\000\081\000\
    \026\000\081\000\081\000\090\000\076\000\120\000\033\000\207\000\
    \120\000\208\000\027\000\073\000\094\000\072\000\082\000\094\000\
    \028\000\084\000\209\000\083\000\084\000\081\000\036\000\210\000\
    \037\000\075\000\077\000\077\000\038\000\077\000\077\000\211\000\
    \041\000\086\000\122\000\091\000\086\000\044\000\076\000\212\000\
    \084\000\087\000\087\000\045\000\087\000\213\000\233\000\072\000\
    \082\000\077\000\046\000\255\255\077\000\083\000\093\000\093\000\
    \086\000\093\000\047\000\227\000\094\000\255\255\125\000\090\000\
    \087\000\048\000\084\000\136\000\127\000\127\000\136\000\049\000\
    \255\255\255\255\255\255\077\000\052\000\093\000\255\255\255\255\
    \053\000\081\000\086\000\255\255\054\000\153\000\056\000\255\255\
    \153\000\168\000\087\000\255\255\168\000\255\255\094\000\057\000\
    \114\000\255\255\255\255\114\000\084\000\059\000\060\000\179\000\
    \109\000\109\000\179\000\109\000\109\000\077\000\061\000\121\000\
    \121\000\255\255\121\000\255\255\086\000\062\000\139\000\114\000\
    \127\000\139\000\193\000\063\000\087\000\193\000\095\000\109\000\
    \064\000\095\000\166\000\088\000\151\000\166\000\121\000\151\000\
    \255\255\093\000\065\000\109\000\140\000\177\000\097\000\140\000\
    \177\000\097\000\067\000\116\000\095\000\255\255\116\000\167\000\
    \071\000\089\000\167\000\095\000\095\000\095\000\074\000\095\000\
    \095\000\095\000\098\000\178\000\097\000\098\000\178\000\255\255\
    \255\255\136\000\116\000\097\000\097\000\097\000\095\000\099\000\
    \097\000\255\255\099\000\114\000\142\000\255\255\116\000\142\000\
    \098\000\101\000\255\255\109\000\101\000\075\000\097\000\098\000\
    \098\000\098\000\121\000\102\000\098\000\099\000\102\000\255\255\
    \143\000\255\255\076\000\143\000\099\000\099\000\099\000\101\000\
    \255\255\099\000\098\000\072\000\082\000\255\255\101\000\101\000\
    \101\000\102\000\104\000\101\000\139\000\104\000\151\000\099\000\
    \102\000\102\000\102\000\255\255\177\000\102\000\116\000\105\000\
    \118\000\101\000\105\000\118\000\152\000\255\255\166\000\152\000\
    \104\000\107\000\140\000\102\000\107\000\081\000\255\255\104\000\
    \104\000\104\000\178\000\255\255\104\000\105\000\205\000\118\000\
    \255\255\205\000\094\000\167\000\105\000\105\000\105\000\107\000\
    \255\255\105\000\104\000\118\000\255\255\255\255\107\000\107\000\
    \107\000\077\000\227\000\107\000\255\255\119\000\119\000\105\000\
    \119\000\255\255\142\000\191\000\127\000\255\255\191\000\150\000\
    \150\000\107\000\150\000\150\000\192\000\203\000\204\000\192\000\
    \203\000\204\000\215\000\255\255\119\000\215\000\143\000\216\000\
    \222\000\222\000\216\000\222\000\222\000\255\255\150\000\231\000\
    \119\000\136\000\231\000\118\000\165\000\165\000\255\255\165\000\
    \165\000\176\000\176\000\255\255\176\000\176\000\152\000\222\000\
    \255\255\190\000\190\000\153\000\190\000\190\000\217\000\168\000\
    \255\255\217\000\232\000\165\000\255\255\232\000\202\000\202\000\
    \176\000\202\000\202\000\255\255\255\255\179\000\255\255\109\000\
    \190\000\214\000\214\000\229\000\214\000\214\000\229\000\255\255\
    \119\000\232\000\255\255\218\000\218\000\202\000\218\000\218\000\
    \193\000\255\255\219\000\219\000\095\000\219\000\219\000\255\255\
    \214\000\255\255\229\000\220\000\220\000\191\000\220\000\220\000\
    \224\000\255\255\218\000\224\000\097\000\255\255\192\000\203\000\
    \204\000\219\000\221\000\221\000\255\255\221\000\221\000\255\255\
    \223\000\223\000\220\000\223\000\223\000\255\255\224\000\255\255\
    \098\000\255\255\255\255\255\255\255\255\224\000\224\000\224\000\
    \255\255\221\000\224\000\255\255\255\255\099\000\226\000\223\000\
    \255\255\226\000\255\255\255\255\255\255\255\255\255\255\101\000\
    \224\000\255\255\255\255\255\255\255\255\255\255\229\000\255\255\
    \255\255\102\000\255\255\255\255\226\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\226\000\226\000\226\000\255\255\255\255\
    \226\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \104\000\255\255\255\255\255\255\255\255\255\255\226\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\105\000\255\255\255\255\
    \255\255\126\000\255\255\255\255\255\255\126\000\255\255\107\000\
    \126\000\126\000\126\000\126\000\126\000\126\000\126\000\126\000\
    \126\000\126\000\126\000\255\255\205\000\255\255\255\255\255\255\
    \255\255\126\000\126\000\126\000\126\000\126\000\126\000\126\000\
    \126\000\126\000\126\000\126\000\126\000\126\000\126\000\126\000\
    \126\000\126\000\126\000\126\000\126\000\126\000\126\000\126\000\
    \126\000\126\000\126\000\255\255\255\255\255\255\150\000\126\000\
    \255\255\126\000\126\000\126\000\126\000\126\000\126\000\126\000\
    \126\000\126\000\126\000\126\000\126\000\126\000\126\000\126\000\
    \126\000\126\000\126\000\126\000\126\000\126\000\126\000\126\000\
    \126\000\126\000\126\000\165\000\255\255\255\255\255\255\255\255\
    \176\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \190\000\255\255\255\255\255\255\217\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\202\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \214\000\255\255\229\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\218\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\219\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\220\000\255\255\255\255\255\255\224\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\221\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\226\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255";
  Lexing.lex_base_code =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\001\000\002\000\006\000\000\000\000\000\000\000\
    \000\000\007\000\000\000\000\000\008\000\012\000\000\000\000\000\
    \000\000\017\000\033\000\038\000\043\000\000\000\000\000\000\000\
    \000\000\045\000\000\000\000\000\049\000\050\000\051\000\018\000\
    \000\000\020\000\000\000\000\000\059\000\022\000\060\000\023\000\
    \000\000\064\000\000\000\000\000\075\000\088\000\089\000\018\000\
    \000\000\090\000\000\000\000\000\094\000\103\000\104\000\105\000\
    \000\000\118\000\000\000\128\000\000\000\000\000\000\000\129\000\
    \142\000\012\000\130\000\135\000\143\000\148\000\000\000\000\000\
    \000\000\000\000\149\000\157\000\159\000\018\000\166\000\172\000\
    \000\000\000\000\187\000\193\000\013\000\199\000\160\000\031\000\
    \000\000\000\000\216\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\004\000\201\000\000\000\000\000\
    \000\000\000\000\000\000\075\000\227\000\182\000\233\000\234\000\
    \000\000\000\000\000\000\000\000\001\000\000\000\120\001\000\000\
    \000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\020\000\002\001\000\000\
    \000\000\184\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\021\000\007\001\000\000\000\000\
    \248\000\000\000\000\000\000\000\000\000\000\000\000\000\022\000\
    \012\001\000\000\000\000\013\001\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\028\000\020\001\000\000\
    \000\000\018\001\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\032\000\028\001\000\000\000\000\033\001\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\047\000\044\001\000\000\
    \000\000\045\001\053\001\058\001\068\001\074\001\000\000\000\000\
    \069\001\000\000\082\001\069\000\033\001\000\000\000\000\000\000\
    \000\000\000\000\000\000";
  Lexing.lex_backtrk_code =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \004\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\
    \004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\015\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \004\000\000\000\000\000\000\000\015\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\
    \026\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\079\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\126\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\126\000\000\000\000\000\
    \000\000\004\000\004\000\004\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\232\000\
    \232\000\000\000\001\001\001\001\001\001\006\001\001\001\001\001\
    \000\000\000\000\028\001\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000";
  Lexing.lex_default_code =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\007\000\000\000\000\000\007\000\007\000\007\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\007\000\000\000\000\000\007\000\007\000\007\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\029\000\000\000\041\000\000\000\000\000\000\000\041\000\
    \029\000\000\000\029\000\029\000\029\000\041\000\000\000\000\000\
    \000\000\000\000\029\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\029\000\000\000\
    \000\000\000\000\151\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\159\000\000\000\
    \000\000\159\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\172\000\000\000\000\000\
    \172\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \185\000\000\000\000\000\185\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\198\000\000\000\
    \000\000\198\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\211\000\000\000\000\000\211\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\224\000\000\000\
    \000\000\224\000\023\000\023\000\023\000\011\001\000\000\000\000\
    \025\001\000\000\025\001\133\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000";
  Lexing.lex_trans_code =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\086\000\
    \001\000\001\000\001\000\001\000\133\000\001\000\001\000\133\000\
    \001\000\001\000\001\000\000\000\000\000\000\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\010\000\001\000\
    \001\000\010\000\000\000\010\000\010\000\000\000\010\000\010\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\010\000\023\000\001\000\010\000\010\000\154\000\167\000\
    \180\000\000\000\010\000\010\000\000\000\001\000\193\000\000\000\
    \001\000\000\000\206\000\001\000\001\000\000\000\000\000\000\000\
    \010\000\010\000\010\000\001\000\010\000\010\000\001\000\023\000\
    \057\000\219\000\023\000\000\000\000\000\000\000\000\000\000\000\
    \001\000\023\000\001\000\001\000\023\000\001\000\000\000\000\000\
    \010\000\010\000\001\000\000\000\000\000\000\000\023\000\034\000\
    \000\000\000\000\034\000\000\000\000\000\000\000\023\000\001\000\
    \023\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\096\000\000\000\023\000\096\000\023\000\034\000\067\000\
    \000\000\000\000\067\000\000\000\000\000\106\000\000\000\133\000\
    \106\000\000\000\133\000\000\000\000\000\000\000\133\000\133\000\
    \133\000\133\000\146\000\133\000\000\000\146\000\067\000\133\000\
    \000\000\000\000\133\000\000\000\106\000\133\000\133\000\000\000\
    \133\000\000\000\000\000\057\000\086\000\133\000\000\000\133\000\
    \001\000\101\000\000\000\001\000\086\000\000\000\133\000\086\000\
    \000\000\000\000\086\000\000\000\133\000\086\000\086\000\136\000\
    \086\000\086\000\001\000\086\000\000\000\001\000\000\000\086\000\
    \000\000\086\000\086\000\086\000\048\000\060\000\089\000\000\000\
    \086\000\086\000\000\000\000\000\000\000\000\000\086\000\086\000\
    \000\000\001\000\074\000\074\000\001\000\000\000\000\000\001\000\
    \115\000\139\000\001\000\001\000\001\000\001\000\001\000\000\000\
    \000\000\000\000\000\000\000\000\089\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\
    \000\000\001\000\001\000\162\000\000\000\000\000\162\000\000\000\
    \175\000\000\000\000\000\175\000\000\000\188\000\000\000\000\000\
    \188\000\000\000\000\000\000\000\000\000\201\000\000\000\000\000\
    \201\000\000\000\162\000\000\000\000\000\214\000\000\000\175\000\
    \214\000\000\000\000\000\000\000\188\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\201\000\227\000\000\000\000\000\
    \227\000\000\000\000\000\000\000\214\000\000\000\010\000\010\000\
    \000\000\010\000\029\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\227\000\010\000\010\000\000\000\
    \010\000\029\000\000\000\010\000\010\000\010\000\010\000\016\001\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\010\000\000\000\000\000\000\000\
    \000\000\000\000\010\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\029\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\000\000\000\000\000\000\000\000\001\000\
    \000\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000";
  Lexing.lex_check_code =
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\006\000\010\000\011\000\006\000\010\000\011\000\012\000\
    \017\000\020\000\012\000\017\000\020\000\021\000\021\000\092\000\
    \021\000\021\000\025\000\025\000\085\000\025\000\025\000\085\000\
    \006\000\010\000\011\000\255\255\255\255\255\255\012\000\017\000\
    \020\000\124\000\026\000\026\000\021\000\026\000\026\000\027\000\
    \027\000\025\000\027\000\027\000\028\000\028\000\033\000\028\000\
    \028\000\033\000\036\000\037\000\038\000\036\000\037\000\038\000\
    \041\000\026\000\045\000\047\000\044\000\046\000\027\000\044\000\
    \046\000\049\000\095\000\028\000\049\000\033\000\149\000\164\000\
    \175\000\036\000\037\000\038\000\052\000\115\000\189\000\052\000\
    \115\000\033\000\201\000\044\000\046\000\036\000\037\000\038\000\
    \049\000\053\000\054\000\057\000\053\000\054\000\057\000\060\000\
    \073\000\213\000\060\000\052\000\049\000\255\255\227\000\255\255\
    \061\000\062\000\063\000\061\000\062\000\063\000\255\255\052\000\
    \053\000\054\000\057\000\255\255\255\255\255\255\060\000\065\000\
    \065\000\255\255\065\000\065\000\053\000\054\000\057\000\061\000\
    \062\000\063\000\067\000\071\000\074\000\067\000\071\000\074\000\
    \255\255\075\000\255\255\061\000\075\000\063\000\065\000\072\000\
    \072\000\076\000\072\000\072\000\076\000\077\000\077\000\082\000\
    \077\000\077\000\082\000\255\255\255\255\255\255\083\000\083\000\
    \084\000\083\000\094\000\084\000\255\255\094\000\072\000\086\000\
    \065\000\255\255\086\000\255\255\077\000\087\000\087\000\255\255\
    \087\000\255\255\067\000\071\000\074\000\083\000\255\255\084\000\
    \117\000\075\000\153\000\117\000\090\000\153\000\086\000\090\000\
    \072\000\076\000\091\000\255\255\087\000\091\000\077\000\082\000\
    \093\000\093\000\109\000\093\000\255\255\109\000\255\255\083\000\
    \255\255\084\000\094\000\090\000\067\000\071\000\074\000\255\255\
    \086\000\091\000\098\000\255\255\255\255\098\000\087\000\093\000\
    \255\255\109\000\072\000\076\000\116\000\255\255\255\255\116\000\
    \077\000\082\000\118\000\119\000\119\000\118\000\119\000\255\255\
    \098\000\255\255\255\255\255\255\094\000\255\255\255\255\098\000\
    \098\000\098\000\168\000\116\000\098\000\168\000\255\255\255\255\
    \255\255\118\000\119\000\150\000\150\000\255\255\150\000\150\000\
    \165\000\165\000\098\000\165\000\165\000\176\000\176\000\179\000\
    \176\000\176\000\179\000\255\255\193\000\190\000\190\000\193\000\
    \190\000\190\000\150\000\255\255\255\255\202\000\202\000\165\000\
    \202\000\202\000\255\255\205\000\176\000\033\000\205\000\255\255\
    \255\255\036\000\037\000\038\000\190\000\214\000\214\000\217\000\
    \214\000\214\000\217\000\255\255\202\000\255\255\218\000\218\000\
    \049\000\218\000\218\000\219\000\219\000\227\000\219\000\219\000\
    \255\255\255\255\255\255\052\000\214\000\220\000\220\000\224\000\
    \220\000\220\000\224\000\221\000\221\000\218\000\221\000\221\000\
    \053\000\054\000\219\000\255\255\226\000\255\255\255\255\226\000\
    \255\255\255\255\255\255\255\255\220\000\224\000\255\255\255\255\
    \255\255\255\255\221\000\255\255\224\000\224\000\224\000\255\255\
    \255\255\224\000\226\000\255\255\255\255\255\255\065\000\255\255\
    \255\255\226\000\226\000\226\000\255\255\255\255\226\000\224\000\
    \067\000\071\000\074\000\255\255\255\255\255\255\255\255\075\000\
    \255\255\255\255\255\255\255\255\226\000\255\255\072\000\076\000\
    \255\255\255\255\255\255\255\255\077\000\082\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \094\000\255\255\255\255\255\255\255\255\126\000\255\255\255\255\
    \126\000\126\000\126\000\126\000\126\000\126\000\126\000\126\000\
    \126\000\126\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \153\000\126\000\126\000\126\000\126\000\126\000\126\000\126\000\
    \126\000\126\000\126\000\126\000\126\000\126\000\126\000\126\000\
    \126\000\126\000\126\000\126\000\126\000\126\000\126\000\126\000\
    \126\000\126\000\126\000\255\255\255\255\255\255\255\255\126\000\
    \098\000\126\000\126\000\126\000\126\000\126\000\126\000\126\000\
    \126\000\126\000\126\000\126\000\126\000\126\000\126\000\126\000\
    \126\000\126\000\126\000\126\000\126\000\126\000\126\000\126\000\
    \126\000\126\000\126\000\255\255\255\255\255\255\255\255\255\255\
    \168\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\150\000\255\255\255\255\255\255\255\255\165\000\
    \255\255\255\255\255\255\255\255\176\000\179\000\255\255\255\255\
    \255\255\255\255\193\000\255\255\190\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\202\000\255\255\255\255\255\255\
    \255\255\205\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\214\000\217\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\218\000\255\255\255\255\
    \255\255\255\255\219\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\220\000\224\000\255\255\255\255\
    \255\255\255\255\221\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\226\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255";
  Lexing.lex_code =
   "\255\001\255\255\000\001\255\004\255\255\003\255\002\255\255\000\
    \003\255\000\002\001\004\255\002\255\255\000\002\255\005\255\004\
    \255\255\006\255\005\255\004\255\255\005\255\006\003\004\255\255\
    \007\004\005\255\006\003\004\255\255\006\003\255\005\255\006\003\
    \007\255\255\005\255\004\255\003\255\255\007\255\005\255\255\002\
    \005\000\003\001\004\255\003\006\255\007\004\005\255\004\255\255\
    \005\255\006\003\255\003\006\004\007\255\006\003\005\255\003\255\
    \004\255\255\008\003\003\006\006\008\005\255\007\255\255\002\005\
    \000\006\001\004\255\005\255\255\004\007\255\004\007\005\255\007\
    \255\255\005\255\004\007\255\001\002\255\013\255\012\255\255\013\
    \255\255\012\255\013\255\255\015\255\014\255\255\015\255\255\014\
    \255\015\255\255\017\255\016\255\255\017\255\255\016\255\017\255\
    \255\019\255\018\255\255\019\255\255\018\255\019\255\255\021\255\
    \020\255\255\021\255\255\020\255\021\255\255\023\255\022\255\255\
    \023\255\255\022\255\023\255\255\004\016\005\017\000\012\001\013\
    \008\020\009\021\010\022\011\023\002\014\003\015\006\018\007\019\
    \255\000\003\001\002\255\000\005\001\004\255\003\005\002\255\255\
    \003\005\002\004\005\255\004\255\255\003\255\255\002\255\000\003\
    \255\002\004\001\005\000\003\255";
}

let rec ocamldep_output source lexbuf =
   __ocaml_lex_ocamldep_output_rec source lexbuf 0
and __ocaml_lex_ocamldep_output_rec source lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 56 "src/lexers.mll"
                            k
# 668 "src/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos (lexbuf.Lexing.lex_curr_pos + -1) in
# 56 "src/lexers.mll"
                                   ( let x = (k, space_sep_strings_nl source lexbuf) in x :: ocamldep_output source lexbuf )
# 672 "src/lexers.ml"

  | 1 ->
# 57 "src/lexers.mll"
        ( [] )
# 677 "src/lexers.ml"

  | 2 ->
# 58 "src/lexers.mll"
      ( error source lexbuf "Expecting colon followed by space-separated module name list" )
# 682 "src/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_ocamldep_output_rec source lexbuf __ocaml_lex_state

and space_sep_strings_nl source lexbuf =
  lexbuf.Lexing.lex_mem <- Array.make 2 (-1);(* L=1 [1] <- p ;  *)
  lexbuf.Lexing.lex_mem.(1) <- lexbuf.Lexing.lex_curr_pos ;
 __ocaml_lex_space_sep_strings_nl_rec source lexbuf 6
and __ocaml_lex_space_sep_strings_nl_rec source lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 61 "src/lexers.mll"
                          word
# 697 "src/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_curr_pos in
# 61 "src/lexers.mll"
                                ( word :: space_sep_strings_nl source lexbuf )
# 701 "src/lexers.ml"

  | 1 ->
# 62 "src/lexers.mll"
                   ( Lexing.new_line lexbuf; [] )
# 706 "src/lexers.ml"

  | 2 ->
# 63 "src/lexers.mll"
      ( error source lexbuf "Expecting space-separated strings terminated with newline" )
# 711 "src/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_space_sep_strings_nl_rec source lexbuf __ocaml_lex_state

and space_sep_strings source lexbuf =
  lexbuf.Lexing.lex_mem <- Array.make 2 (-1);(* L=1 [1] <- p ;  *)
  lexbuf.Lexing.lex_mem.(1) <- lexbuf.Lexing.lex_curr_pos ;
 __ocaml_lex_space_sep_strings_rec source lexbuf 12
and __ocaml_lex_space_sep_strings_rec source lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 66 "src/lexers.mll"
                          word
# 726 "src/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_curr_pos in
# 66 "src/lexers.mll"
                                ( word :: space_sep_strings source lexbuf )
# 730 "src/lexers.ml"

  | 1 ->
# 67 "src/lexers.mll"
                        ( [] )
# 735 "src/lexers.ml"

  | 2 ->
# 68 "src/lexers.mll"
      ( error source lexbuf "Expecting space-separated strings" )
# 740 "src/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_space_sep_strings_rec source lexbuf __ocaml_lex_state

and blank_sep_strings source lexbuf =
  lexbuf.Lexing.lex_mem <- Array.make 2 (-1);(* L=1 [1] <- p ;  *)
  lexbuf.Lexing.lex_mem.(1) <- lexbuf.Lexing.lex_curr_pos ;
 __ocaml_lex_blank_sep_strings_rec source lexbuf 21
and __ocaml_lex_blank_sep_strings_rec source lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 71 "src/lexers.mll"
                                    ( blank_sep_strings source lexbuf )
# 754 "src/lexers.ml"

  | 1 ->
# 72 "src/lexers.mll"
                                ( [] )
# 759 "src/lexers.ml"

  | 2 ->
let
# 73 "src/lexers.mll"
                          word
# 765 "src/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_curr_pos in
# 73 "src/lexers.mll"
                                ( word :: blank_sep_strings source lexbuf )
# 769 "src/lexers.ml"

  | 3 ->
# 74 "src/lexers.mll"
               ( [] )
# 774 "src/lexers.ml"

  | 4 ->
# 75 "src/lexers.mll"
      ( error source lexbuf "Expecting blank-separated strings" )
# 779 "src/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_blank_sep_strings_rec source lexbuf __ocaml_lex_state

and comma_sep_strings source lexbuf =
  lexbuf.Lexing.lex_mem <- Array.make 5 (-1);(* L=2 [3] <- p ; [2] <- p ;  *)
  lexbuf.Lexing.lex_mem.(3) <- lexbuf.Lexing.lex_curr_pos ;
  lexbuf.Lexing.lex_mem.(2) <- lexbuf.Lexing.lex_curr_pos ;
 __ocaml_lex_comma_sep_strings_rec source lexbuf 33
and __ocaml_lex_comma_sep_strings_rec source lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 78 "src/lexers.mll"
                                    word
# 795 "src/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_mem.(1) in
# 78 "src/lexers.mll"
                                                     ( [word] )
# 799 "src/lexers.ml"

  | 1 ->
let
# 79 "src/lexers.mll"
                                    word
# 805 "src/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_curr_pos in
# 79 "src/lexers.mll"
                                          ( word :: comma_sep_strings_aux source lexbuf )
# 809 "src/lexers.ml"

  | 2 ->
# 80 "src/lexers.mll"
               ( [] )
# 814 "src/lexers.ml"

  | 3 ->
# 81 "src/lexers.mll"
      ( error source lexbuf "Expecting comma-separated strings (1)" )
# 819 "src/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_comma_sep_strings_rec source lexbuf __ocaml_lex_state

and comma_sep_strings_aux source lexbuf =
  lexbuf.Lexing.lex_mem <- Array.make 2 (-1); __ocaml_lex_comma_sep_strings_aux_rec source lexbuf 41
and __ocaml_lex_comma_sep_strings_aux_rec source lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 83 "src/lexers.mll"
                                               word
# 832 "src/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_curr_pos in
# 83 "src/lexers.mll"
                                                     ( word :: comma_sep_strings_aux source lexbuf )
# 836 "src/lexers.ml"

  | 1 ->
# 84 "src/lexers.mll"
               ( [] )
# 841 "src/lexers.ml"

  | 2 ->
# 85 "src/lexers.mll"
      ( error source lexbuf "Expecting comma-separated strings (2)" )
# 846 "src/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_comma_sep_strings_aux_rec source lexbuf __ocaml_lex_state

and comma_or_blank_sep_strings source lexbuf =
  lexbuf.Lexing.lex_mem <- Array.make 5 (-1);(* L=2 [3] <- p ; [2] <- p ;  *)
  lexbuf.Lexing.lex_mem.(3) <- lexbuf.Lexing.lex_curr_pos ;
  lexbuf.Lexing.lex_mem.(2) <- lexbuf.Lexing.lex_curr_pos ;
 __ocaml_lex_comma_or_blank_sep_strings_rec source lexbuf 49
and __ocaml_lex_comma_or_blank_sep_strings_rec source lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 88 "src/lexers.mll"
                                    word
# 862 "src/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_mem.(1) in
# 88 "src/lexers.mll"
                                                     ( [word] )
# 866 "src/lexers.ml"

  | 1 ->
let
# 89 "src/lexers.mll"
                                    word
# 872 "src/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_curr_pos in
# 89 "src/lexers.mll"
                                          ( word :: comma_or_blank_sep_strings_aux source lexbuf )
# 876 "src/lexers.ml"

  | 2 ->
# 90 "src/lexers.mll"
               ( [] )
# 881 "src/lexers.ml"

  | 3 ->
# 91 "src/lexers.mll"
      ( error source lexbuf "Expecting (comma|blank)-separated strings (1)" )
# 886 "src/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_comma_or_blank_sep_strings_rec source lexbuf __ocaml_lex_state

and comma_or_blank_sep_strings_aux source lexbuf =
  lexbuf.Lexing.lex_mem <- Array.make 3 (-1);(* L=1 [1] <- p ;  *)
  lexbuf.Lexing.lex_mem.(1) <- lexbuf.Lexing.lex_curr_pos ;
 __ocaml_lex_comma_or_blank_sep_strings_aux_rec source lexbuf 57
and __ocaml_lex_comma_or_blank_sep_strings_aux_rec source lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 93 "src/lexers.mll"
                                               word
# 901 "src/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_curr_pos in
# 93 "src/lexers.mll"
                                                     ( word :: comma_or_blank_sep_strings_aux source lexbuf )
# 905 "src/lexers.ml"

  | 1 ->
let
# 94 "src/lexers.mll"
                                    word
# 911 "src/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_curr_pos in
# 94 "src/lexers.mll"
                                          ( word :: comma_or_blank_sep_strings_aux source lexbuf )
# 915 "src/lexers.ml"

  | 2 ->
# 95 "src/lexers.mll"
               ( [] )
# 920 "src/lexers.ml"

  | 3 ->
# 96 "src/lexers.mll"
      ( error source lexbuf "Expecting (comma|blank)-separated strings (2)" )
# 925 "src/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_comma_or_blank_sep_strings_aux_rec source lexbuf __ocaml_lex_state

and conf_lines dir source lexbuf =
  lexbuf.Lexing.lex_mem <- Array.make 9 (-1);(* L=1 [3] <- p ;  *)
  lexbuf.Lexing.lex_mem.(3) <- lexbuf.Lexing.lex_curr_pos ;
 __ocaml_lex_conf_lines_rec dir source lexbuf 65
and __ocaml_lex_conf_lines_rec dir source lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 99 "src/lexers.mll"
                                    ( Lexing.new_line lexbuf; conf_lines dir source lexbuf )
# 939 "src/lexers.ml"

  | 1 ->
# 100 "src/lexers.mll"
                                ( [] )
# 944 "src/lexers.ml"

  | 2 ->
# 101 "src/lexers.mll"
                   ( Lexing.new_line lexbuf; conf_lines dir source lexbuf )
# 949 "src/lexers.ml"

  | 3 ->
# 102 "src/lexers.mll"
               ( [] )
# 954 "src/lexers.ml"

  | 4 ->
let
# 103 "src/lexers.mll"
                                      k
# 960 "src/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_mem.(1)
and
# 103 "src/lexers.mll"
                                                 s1
# 965 "src/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(1) lexbuf.Lexing.lex_mem.(2)
and
# 103 "src/lexers.mll"
                                                                 s2
# 970 "src/lexers.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_mem.(2) + 1) lexbuf.Lexing.lex_curr_pos in
# 104 "src/lexers.mll"
      (
        let bexpr =
          try Glob.parse ?dir k
          with _exn -> error source lexbuf "Invalid globbing pattern %S" k
        in
        sublex (count_lines lexbuf) s1; sublex (count_lines lexbuf) s2;
        let v1 = conf_value empty source lexbuf in
        let v2 = conf_values v1 source lexbuf in
        let rest = conf_lines dir source lexbuf in (bexpr,v2) :: rest
      )
# 983 "src/lexers.ml"

  | 5 ->
# 114 "src/lexers.mll"
      ( error source lexbuf "Invalid line syntax" )
# 988 "src/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_conf_lines_rec dir source lexbuf __ocaml_lex_state

and conf_value x source lexbuf =
  lexbuf.Lexing.lex_mem <- Array.make 3 (-1);(* L=1 [1] <- p ;  *)
  lexbuf.Lexing.lex_mem.(1) <- lexbuf.Lexing.lex_curr_pos ;
 __ocaml_lex_conf_value_rec x source lexbuf 95
and __ocaml_lex_conf_value_rec x source lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 117 "src/lexers.mll"
                 tag
# 1003 "src/lexers.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 1) lexbuf.Lexing.lex_curr_pos in
# 117 "src/lexers.mll"
                      ( { (x) with minus_tags = locate source lexbuf tag :: x.minus_tags } )
# 1007 "src/lexers.ml"

  | 1 ->
let
# 118 "src/lexers.mll"
                 tag
# 1013 "src/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_curr_pos in
# 118 "src/lexers.mll"
                      ( { (x) with plus_tags = locate source lexbuf tag :: x.plus_tags } )
# 1017 "src/lexers.ml"

  | 2 ->
# 119 "src/lexers.mll"
              ( error source lexbuf "Invalid tag modifier only '+ or '-' are allowed as prefix for tag" )
# 1022 "src/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_conf_value_rec x source lexbuf __ocaml_lex_state

and conf_values x source lexbuf =
  lexbuf.Lexing.lex_mem <- Array.make 2 (-1);(* L=1 [1] <- p ;  *)
  lexbuf.Lexing.lex_mem.(1) <- lexbuf.Lexing.lex_curr_pos ;
 __ocaml_lex_conf_values_rec x source lexbuf 109
and __ocaml_lex_conf_values_rec x source lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 122 "src/lexers.mll"
            s1
# 1037 "src/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_mem.(0)
and
# 122 "src/lexers.mll"
                            s2
# 1042 "src/lexers.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_mem.(0) + 1) lexbuf.Lexing.lex_curr_pos in
# 122 "src/lexers.mll"
                                (
      sublex (count_lines lexbuf) s1; sublex (count_lines lexbuf) s2;
      conf_values (conf_value x source lexbuf) source lexbuf
    )
# 1049 "src/lexers.ml"

  | 1 ->
# 126 "src/lexers.mll"
            ( Lexing.new_line lexbuf; x )
# 1054 "src/lexers.ml"

  | 2 ->
# 127 "src/lexers.mll"
        ( x )
# 1059 "src/lexers.ml"

  | 3 ->
# 128 "src/lexers.mll"
      ( error source lexbuf "Only ',' separated tags are allowed" )
# 1064 "src/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_conf_values_rec x source lexbuf __ocaml_lex_state

and path_scheme patt_allowed source lexbuf =
  lexbuf.Lexing.lex_mem <- Array.make 2 (-1); __ocaml_lex_path_scheme_rec patt_allowed source lexbuf 122
and __ocaml_lex_path_scheme_rec patt_allowed source lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 131 "src/lexers.mll"
                  prefix
# 1077 "src/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 132 "src/lexers.mll"
      ( `Word prefix :: path_scheme patt_allowed source lexbuf )
# 1081 "src/lexers.ml"

  | 1 ->
let
# 133 "src/lexers.mll"
                      var
# 1087 "src/lexers.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 2) (lexbuf.Lexing.lex_curr_pos + -1) in
# 134 "src/lexers.mll"
      ( `Var (var, Bool.True) :: path_scheme patt_allowed source lexbuf )
# 1091 "src/lexers.ml"

  | 2 ->
let
# 135 "src/lexers.mll"
                      var
# 1097 "src/lexers.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 2) lexbuf.Lexing.lex_mem.(0)
and
# 135 "src/lexers.mll"
                                           patt
# 1102 "src/lexers.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_mem.(0) + 1) (lexbuf.Lexing.lex_curr_pos + -1) in
# 136 "src/lexers.mll"
      ( if patt_allowed then
          let patt = My_std.String.implode (unescape (Lexing.from_string patt)) in
          `Var (var, Glob.parse patt) :: path_scheme patt_allowed source lexbuf
        else
          error source lexbuf "Patterns are not allowed in this pathname (%%(%s:%s) only in ~prod)" var patt )
# 1110 "src/lexers.ml"

  | 3 ->
# 142 "src/lexers.mll"
      ( `Var ("", Bool.True) :: path_scheme patt_allowed source lexbuf )
# 1115 "src/lexers.ml"

  | 4 ->
# 144 "src/lexers.mll"
      ( [] )
# 1120 "src/lexers.ml"

  | 5 ->
# 145 "src/lexers.mll"
      ( error source lexbuf "Bad pathanme scheme" )
# 1125 "src/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_path_scheme_rec patt_allowed source lexbuf __ocaml_lex_state

and unescape lexbuf =
   __ocaml_lex_unescape_rec lexbuf 131
and __ocaml_lex_unescape_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 148 "src/lexers.mll"
                       c
# 1138 "src/lexers.ml"
= Lexing.sub_lexeme_char lexbuf (lexbuf.Lexing.lex_start_pos + 1) in
# 148 "src/lexers.mll"
                                 ( c :: unescape lexbuf )
# 1142 "src/lexers.ml"

  | 1 ->
let
# 149 "src/lexers.mll"
         c
# 1148 "src/lexers.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 149 "src/lexers.mll"
                                 ( c :: unescape lexbuf )
# 1152 "src/lexers.ml"

  | 2 ->
# 150 "src/lexers.mll"
                                 ( [] )
# 1157 "src/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_unescape_rec lexbuf __ocaml_lex_state

and ocamlfind_query source lexbuf =
  lexbuf.Lexing.lex_mem <- Array.make 24 (-1); __ocaml_lex_ocamlfind_query_rec source lexbuf 136
and __ocaml_lex_ocamlfind_query_rec source lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 154 "src/lexers.mll"
                                       n
# 1170 "src/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_mem.(1)
and
# 155 "src/lexers.mll"
                                           d
# 1175 "src/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(2) lexbuf.Lexing.lex_mem.(3)
and
# 156 "src/lexers.mll"
                                       v
# 1180 "src/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(4) lexbuf.Lexing.lex_mem.(5)
and
# 157 "src/lexers.mll"
                                          a
# 1185 "src/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(6) lexbuf.Lexing.lex_mem.(7)
and
# 158 "src/lexers.mll"
                                        lo
# 1190 "src/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(8) lexbuf.Lexing.lex_mem.(9)
and
# 159 "src/lexers.mll"
                                        l
# 1195 "src/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(10) lexbuf.Lexing.lex_mem.(11) in
# 160 "src/lexers.mll"
    ( n, d, v, a, lo, l )
# 1199 "src/lexers.ml"

  | 1 ->
# 161 "src/lexers.mll"
      ( error source lexbuf "Bad ocamlfind query" )
# 1204 "src/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_ocamlfind_query_rec source lexbuf __ocaml_lex_state

and trim_blanks source lexbuf =
  lexbuf.Lexing.lex_mem <- Array.make 6 (-1);(* L=2 [3] <- p ; [2] <- p ;  *)
  lexbuf.Lexing.lex_mem.(3) <- lexbuf.Lexing.lex_curr_pos ;
  lexbuf.Lexing.lex_mem.(2) <- lexbuf.Lexing.lex_curr_pos ;
 __ocaml_lex_trim_blanks_rec source lexbuf 218
and __ocaml_lex_trim_blanks_rec source lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 164 "src/lexers.mll"
                          word
# 1220 "src/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_mem.(1) in
# 164 "src/lexers.mll"
                                       ( word )
# 1224 "src/lexers.ml"

  | 1 ->
# 165 "src/lexers.mll"
      ( error source lexbuf "Bad input for trim_blanks" )
# 1229 "src/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_trim_blanks_rec source lexbuf __ocaml_lex_state

and tag_gen source lexbuf =
  lexbuf.Lexing.lex_mem <- Array.make 6 (-1); __ocaml_lex_tag_gen_rec source lexbuf 224
and __ocaml_lex_tag_gen_rec source lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 168 "src/lexers.mll"
                name
# 1242 "src/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_mem.(0)
and
# 168 "src/lexers.mll"
                                       param
# 1247 "src/lexers.ml"
= Lexing.sub_lexeme_opt lexbuf lexbuf.Lexing.lex_mem.(2) lexbuf.Lexing.lex_mem.(1) in
# 168 "src/lexers.mll"
                                                    ( name, param )
# 1251 "src/lexers.ml"

  | 1 ->
# 169 "src/lexers.mll"
      ( error source lexbuf "Not a valid parametrized tag" )
# 1256 "src/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_tag_gen_rec source lexbuf __ocaml_lex_state

and count_lines lb lexbuf =
   __ocaml_lex_count_lines_rec lb lexbuf 229
and __ocaml_lex_count_lines_rec lb lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 172 "src/lexers.mll"
           ( count_lines lb lexbuf )
# 1268 "src/lexers.ml"

  | 1 ->
# 173 "src/lexers.mll"
                 ( Lexing.new_line lb; count_lines lb lexbuf )
# 1273 "src/lexers.ml"

  | 2 ->
# 174 "src/lexers.mll"
        ( () )
# 1278 "src/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_count_lines_rec lb lexbuf __ocaml_lex_state

;;

