/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 17 "gram.y"

/*
 *  pmlogrewrite parser
 */
#include "pmapi.h"
#include "libpcp.h"
#include "logger.h"
#include <errno.h>
#include <assert.h>

#define PM_TEXT_TYPE_MASK (PM_TEXT_ONELINE | PM_TEXT_HELP)

static indomspec_t	*current_indomspec;
static int		current_star_indom;
static int		do_walk_indom;
static int		star_domain;

static metricspec_t	*current_metricspec;
static int		current_star_metric;
static int		star_cluster;
static int		do_walk_metric;
static int		output = OUTPUT_ALL;
static int		one_inst;
static char		*one_name;

static textspec_t	*current_textspec;
static int		do_walk_text;

static int		current_label_id;
static char *		current_label_name;
static char *		current_label_value;
static int		current_label_instance;
static char *		current_label_instance_name;
static labelspec_t	*current_labelspec;
static int		do_walk_label;

indomspec_t *
walk_indom(int mode)
{
    static indomspec_t	*ip;

    if (do_walk_indom) {
	if (mode == W_START)
	    ip = indom_root;
	else
	    ip = ip->i_next;
	while (ip != NULL && pmInDom_domain(ip->old_indom) != star_domain)
	    ip = ip->i_next;
    }
    else {
	if (mode == W_START)
	    ip = current_indomspec;
	else
	    ip = NULL;
    }

    return ip;
}

metricspec_t *
walk_metric(int mode, int flag, char *which, int dupok)
{
    static metricspec_t	*mp;

    if (do_walk_metric) {
	if (mode == W_START)
	    mp = metric_root;
	else
	    mp = mp->m_next;
	while (mp != NULL) {
	    if (pmID_domain(mp->old_desc.pmid) == star_domain &&
		(star_cluster == PM_ID_NULL || star_cluster == pmID_cluster(mp->old_desc.pmid)))
		break;
	    mp = mp->m_next;
	}
    }
    else {
	if (mode == W_START)
	    mp = current_metricspec;
	else
	    mp = NULL;
    }

    if (mp != NULL) {
	if (!dupok && (mp->flags & flag)) {
	    pmsprintf(mess, sizeof(mess), "Duplicate %s clause for metric %s", which, mp->old_name);
	    yyerror(mess);
	}
	if (flag != METRIC_DELETE) {
	    if (mp->flags & METRIC_DELETE) {
		pmsprintf(mess, sizeof(mess), "Conflicting %s clause for deleted metric %s", which, mp->old_name);
		yyerror(mess);
	    }
	}
	else {
	    if (mp->flags & (~METRIC_DELETE)) {
		pmsprintf(mess, sizeof(mess), "Conflicting delete and other clauses for metric %s", mp->old_name);
		yyerror(mess);
	    }
	}
    }

    return mp;
}

static const char *
textTypeStr(int type)
{
    switch(type)
	{
	case PM_TEXT_ONELINE:
	    return "one line";
	case PM_TEXT_HELP:
	    return "help";
	default:
	    break;
	}

    return "unknown";
}
 
textspec_t *
walk_text(int mode, int flag, char *which, int dupok)
{
    static textspec_t	*tp;

    if (do_walk_text) {
	if (mode == W_START)
	    tp = text_root;
	else
	    tp = tp->t_next;

	/* Only consider the active specs. */
	while (tp != NULL && (tp->flags & TEXT_ACTIVE) == 0)
	    tp = tp->t_next;
    }
    else {
	if (mode == W_START) {
	    tp = current_textspec;
	    if (tp)
		assert ((tp->flags & TEXT_ACTIVE));
	}
	else
	    tp = NULL;
    }

    if (tp != NULL) {
	tp->flags &= ~TEXT_ACTIVE;
	
	if (!dupok && (tp->flags & flag)) {
	    if ((tp->old_type & PM_TEXT_PMID)) {
		pmsprintf(mess, sizeof(mess), "Duplicate %s clause for %s text for metric %s",
			  which, textTypeStr(tp->old_type), pmIDStr(tp->old_id));
	    }
	    else {
		assert((tp->old_type & PM_TEXT_INDOM));
		pmsprintf(mess, sizeof(mess), "Duplicate %s clause for %s text for indom %s",
			  which, textTypeStr(tp->old_type), pmInDomStr(tp->old_id));
	    }
	    yyerror(mess);
	}
	if (flag != TEXT_DELETE) {
	    if (tp->flags & TEXT_DELETE) {
		if ((tp->old_type & PM_TEXT_PMID)) {
		    pmsprintf(mess, sizeof(mess), "Conflicting %s clause for deleted %s text for metric %s",
			      which, textTypeStr(tp->old_type), pmIDStr(tp->old_id));
		}
		else {
		    assert((tp->old_type & PM_TEXT_INDOM));
		    pmsprintf(mess, sizeof(mess), "Conflicting %s clause for deleted %s text for indom %s",
			      which, textTypeStr(tp->old_type), pmInDomStr(tp->old_id));
		}
		yyerror(mess);
	    }
	}
	else {
	    if (tp->flags & (~TEXT_DELETE)) {
		if ((tp->old_type & PM_TEXT_PMID)) {
		    pmsprintf(mess, sizeof(mess), "Conflicting delete and other clauses for %s text for metric %s",
			      textTypeStr(tp->old_type), pmIDStr(tp->old_id));
		}
		else {
		    assert((tp->old_type & PM_TEXT_INDOM));
		    pmsprintf(mess, sizeof(mess), "Conflicting delete and other clauses for %s text for indom %s",
			      textTypeStr(tp->old_type), pmInDomStr(tp->old_id));
		}
		yyerror(mess);
	    }
	}
    }

    return tp;
}

labelspec_t *
walk_label(int mode, int flag, char *which, int dupok)
{
    static labelspec_t	*lp;

    if (do_walk_label > 1) {
	if (mode == W_START)
	    lp = label_root;
	else
	    lp = lp->l_next;

	/* Only consider the active specs. */
	while (lp != NULL && (lp->flags & LABEL_ACTIVE) == 0)
	    lp = lp->l_next;
    }
    else {
	if (mode == W_START)
	    lp = current_labelspec;
	else
	    lp = NULL;
    }

    if (lp != NULL) {
	lp->flags &= ~LABEL_ACTIVE;
	
	if (!dupok && (lp->flags & flag)) {
	    if ((lp->old_type & PM_LABEL_CONTEXT)) {
		pmsprintf(mess, sizeof(mess), "Duplicate %s clause for context label",
			  which);
	    }
	    else if ((lp->old_type & PM_LABEL_DOMAIN)) {
		pmsprintf(mess, sizeof(mess), "Duplicate %s clause for label for domain %d",
			  which, pmID_domain(lp->old_id));
	    }
	    else if ((lp->old_type & PM_LABEL_CLUSTER)) {
		pmsprintf(mess, sizeof(mess), "Duplicate %s clause for label for cluster %d.%d",
			  which, pmID_domain(lp->old_id), pmID_cluster(lp->old_id));
	    }
	    else if ((lp->old_type & PM_LABEL_ITEM)) {
		pmsprintf(mess, sizeof(mess), "Duplicate %s clause for label for metric %s",
			  which, pmIDStr(lp->old_id));
	    }
	    else if ((lp->old_type & PM_LABEL_INDOM)) {
		pmsprintf(mess, sizeof(mess), "Duplicate %s clause for label for indom %s",
			  which, pmInDomStr(lp->old_id));
	    }
	    else if ((lp->old_type & PM_LABEL_INSTANCES)) {
		pmsprintf(mess, sizeof(mess), "Duplicate %s clause for label for the instances of indom %s",
			  which, pmInDomStr(lp->old_id));
	    }
	    yyerror(mess);
	}
	if (flag != LABEL_DELETE) {
	    if (lp->flags & LABEL_DELETE) {
		if ((lp->old_type & PM_LABEL_CONTEXT)) {
		    pmsprintf(mess, sizeof(mess), "Conflicting %s clause for deleted context label",
			      which);
		}
		else if ((lp->old_type & PM_LABEL_DOMAIN)) {
		    pmsprintf(mess, sizeof(mess), "Conflicting %s clause for deleted label for domain %d",
			      which, pmID_domain(lp->old_id));
		}
		else if ((lp->old_type & PM_LABEL_CLUSTER)) {
		    pmsprintf(mess, sizeof(mess), "Conflicting %s clause for deleted label for cluster %d.%d",
			      which, pmID_domain(lp->old_id), pmID_cluster(lp->old_id));
		}
		else if ((lp->old_type & PM_LABEL_ITEM)) {
		    pmsprintf(mess, sizeof(mess), "Conflicting %s clause for deleted label for metric %s",
			      which, pmIDStr(lp->old_id));
		}
		else if ((lp->old_type & PM_LABEL_INDOM)) {
		    pmsprintf(mess, sizeof(mess), "Conflicting %s clause for deleted label for indom %s",
			      which, pmInDomStr(lp->old_id));
		}
		else if ((lp->old_type & PM_LABEL_INSTANCES)) {
		    pmsprintf(mess, sizeof(mess), "Conflicting %s clause for deleted label for the instances of indom %s",
			      which, pmInDomStr(lp->old_id));
		}
		yyerror(mess);
	    }
	}
	else {
	    if (lp->flags & (~LABEL_DELETE)) {
		if ((lp->old_type & PM_LABEL_CONTEXT)) {
		    pmsprintf(mess, sizeof(mess), "Conflicting delete and other clauses for context label");
		}
		else if ((lp->old_type & PM_LABEL_DOMAIN)) {
		    pmsprintf(mess, sizeof(mess), "Conflicting delete and other clauses for label for domain %d",
			      pmID_domain(lp->old_id));
		}
		else if ((lp->old_type & PM_LABEL_CLUSTER)) {
		    pmsprintf(mess, sizeof(mess), "Conflicting delete and other clauses for label for cluster %d.%d",
			      pmID_domain(lp->old_id), pmID_cluster(lp->old_id));
		}
		else if ((lp->old_type & PM_LABEL_ITEM)) {
		    pmsprintf(mess, sizeof(mess), "Conflicting delete and other clauses for label for metric %s",
			      pmIDStr(lp->old_id));
		}
		else if ((lp->old_type & PM_LABEL_INDOM)) {
		    pmsprintf(mess, sizeof(mess), "Conflicting delete and other clauses for label for indom %s",
			      pmInDomStr(lp->old_id));
		}
		else if ((lp->old_type & PM_LABEL_INSTANCES)) {
		    pmsprintf(mess, sizeof(mess), "Conflicting delete and other clauses for label for the instances of indom %s",
			      pmInDomStr(lp->old_id));
		}
		yyerror(mess);
	    }
	}
    }

    return lp;
}

void
deactivate_labels(void)
{
    labelspec_t	*lp;
    for (lp = walk_label(W_START, LABEL_ACTIVE, "active", 0); lp != NULL; lp = walk_label(W_NEXT, 0, "", 0)) {
	lp->flags &= ~LABEL_ACTIVE;
    }
}

void
new_context_label()
{
    labelspec_t	*lp;
    int		sts;
    char	buf[PM_MAXLABELJSONLEN];

    /*
     * Ignore the other change specs which were identified and
     * add the new label to the generic context label change spec.
     * Search for an existing one first.
     */
    deactivate_labels();
    for (lp = label_root; lp != NULL; lp = lp->l_next) {
	if (lp->old_type == PM_LABEL_CONTEXT) {
	    assert (lp->old_id == PM_ID_NULL);
	    if (lp->old_label == NULL)
		break;
	}
    }

    /* Create one if none exists. */
    if (lp == NULL)
	lp = create_label(PM_LABEL_CONTEXT, PM_ID_NULL, 0, NULL, NULL);

    /* Add the new label to the label change spec. */
    pmsprintf(buf, sizeof(buf), "{%s:%s}",
	      current_label_name, current_label_value);
    if ((sts = __pmAddLabels(&lp->new_labels, buf, PM_LABEL_CONTEXT)) < 0) {
	pmsprintf(mess, sizeof(mess),
		  "Unable to add new context label %s: %s",
		  buf, pmErrStr(sts));
	yyerror(mess);
    }
    lp->new_labels->inst = 0;
    lp->flags |= LABEL_NEW;
}

void
new_domain_label(int domain)
{
    labelspec_t		*lp;
    int			sts;
    int			found = 0;
    __pmContext		*ctxp;
    __pmHashCtl		*hcp;
    __pmHashNode	*node;
    char		buf[PM_MAXLABELJSONLEN];

    /*
     * Ignore the change specs which were previously identified and instead
     * search the metadata for metrics in the given domain.
     * Create or re-use the change record for each one found. 
     */
    deactivate_labels();

    ctxp = __pmHandleToPtr(pmWhichContext());
    assert(ctxp != NULL);
    /*
     * Note: This application is single threaded, and once we have ctxp
     *	     the associated __pmContext will not move and will only be
     *	     accessed or modified synchronously either here or in libpcp.
     *	     We unlock the context so that it can be locked as required
     *	     within libpcp.
     */
    PM_UNLOCK(ctxp->c_lock);

    /* Prepare the JSON for the new label. */
    pmsprintf(buf, sizeof(buf), "{%s:%s}",
	      current_label_name, current_label_value);

    hcp = &ctxp->c_archctl->ac_log->hashpmid;
    for (node = __pmHashWalk(hcp, PM_HASH_WALK_START);
	 node != NULL;
	 node = __pmHashWalk(hcp, PM_HASH_WALK_NEXT)) {
	if (pmID_domain(node->key) != domain)
	    continue;

	/*
	 * A metric in this domain exists.
	 * Add the new label to the generic label change spec for this
	 * domain. Search for an existing one first.
	 */
	found = 1;
	for (lp = label_root; lp != NULL; lp = lp->l_next) {
	    if (lp->old_type != PM_LABEL_DOMAIN)
		continue;
	    if (lp->old_id != domain)
		continue;
	    if (lp->old_label == NULL)
		break;
	}

	/* Create one if none exists. */
	if (lp == NULL)
	    lp = create_label(PM_LABEL_DOMAIN, domain, 0, NULL, NULL);

	/* Add the new label to the label change spec. */
	if ((sts = __pmAddLabels(&lp->new_labels, buf, PM_LABEL_DOMAIN)) < 0) {
	    pmsprintf(mess, sizeof(mess),
		      "Unable to add new domain label %s: %s",
		      buf, pmErrStr(sts));
	    yyerror(mess);
	}
	lp->new_labels->inst = 0;
	lp->flags |= LABEL_NEW;

	/* We only need to find one metric in the specified domain. */
	break;
    }

    /* Did we find any clusters matching the spec? */
    if (! found) {
	pmsprintf(mess, sizeof(mess),
		  "No matching domain for new label %s", buf);
	yywarn(mess);
    }
}

void
new_cluster_label(int cluster)
{
    labelspec_t		*lp;
    int			sts;
    int			found = 0;
    __pmContext		*ctxp;
    __pmHashCtl		*hcp;
    __pmHashNode	*node;
    char		buf[PM_MAXLABELJSONLEN] = "";

    /*
     * Ignore the change specs which were previously identified and instead
     * search the metadata for metrics in the given domain.
     * Create or re-use the change record for each one found. 
     */
    deactivate_labels();

    ctxp = __pmHandleToPtr(pmWhichContext());
    assert(ctxp != NULL);
    /*
     * Note: This application is single threaded, and once we have ctxp
     *	     the associated __pmContext will not move and will only be
     *	     accessed or modified synchronously either here or in libpcp.
     *	     We unlock the context so that it can be locked as required
     *	     within libpcp.
     */
    PM_UNLOCK(ctxp->c_lock);

    /* Prepare the JSON for the new label. */
    pmsprintf(buf, sizeof(buf), "{%s:%s}",
	      current_label_name, current_label_value);

    hcp = &ctxp->c_archctl->ac_log->hashpmid;
    for (node = __pmHashWalk(hcp, PM_HASH_WALK_START);
	 node != NULL;
	 node = __pmHashWalk(hcp, PM_HASH_WALK_NEXT)) {
	if (pmID_domain(node->key) != pmID_domain(cluster))
	    continue;
	if (! current_star_metric && 
	    pmID_cluster(node->key) != pmID_cluster(cluster))
	    continue;

	/*
	 * A metric in this cluster exists.
	 * Add the new label to the generic label change spec for the
	 * identified cluster. Search for an existing one first.
	 */
	found = 1;
	for (lp = label_root; lp != NULL; lp = lp->l_next) {
	    if (lp->old_type != PM_LABEL_CLUSTER)
		continue;
	    if (pmID_domain(lp->old_id) != pmID_domain((pmID)(node->key)))
		continue;
	    if (pmID_cluster(lp->old_id) != pmID_cluster((pmID)(node->key)))
		continue;
	    if (lp->old_label == NULL)
		break;
	}

	if (lp == NULL) {
	    pmID current_cluster =
		pmID_build(pmID_domain(node->key), pmID_cluster(node->key), 0);
	    lp = create_label(PM_LABEL_CLUSTER, current_cluster, 0, NULL, NULL);
	}

	/* Add the new label to the label change spec. */
	if ((sts = __pmAddLabels(&lp->new_labels, buf, PM_LABEL_CLUSTER)) < 0) {
	    pmsprintf(mess, sizeof(mess),
		      "Unable to add new cluster label %s: %s",
		      buf, pmErrStr(sts));
	    yyerror(mess);
	}
	lp->new_labels->inst = 0;
	lp->flags |= LABEL_NEW;

	/* Do we need to look for more clusters? */
	if (! current_star_metric)
	    break;
    }

    /* Did we find any clusters matching the spec? */
    if (! found) {
	pmsprintf(mess, sizeof(mess),
		  "No matching cluster for new label %s", buf);
	yywarn(mess);
    }
}

void
new_item_label(int item)
{
    labelspec_t		*lp;
    int			sts;
    int			found = 0;
    __pmContext		*ctxp;
    __pmHashCtl		*hcp;
    __pmHashNode	*node;
    char		buf[PM_MAXLABELJSONLEN] = "";

    /*
     * Ignore the change specs which were previously identified and instead
     * search the metadata for metrics in the given domain.
     * Create or re-use the change record for each one found. 
     */
    deactivate_labels();

    ctxp = __pmHandleToPtr(pmWhichContext());
    assert(ctxp != NULL);
    /*
     * Note: This application is single threaded, and once we have ctxp
     *	     the associated __pmContext will not move and will only be
     *	     accessed or modified synchronously either here or in libpcp.
     *	     We unlock the context so that it can be locked as required
     *	     within libpcp.
     */
    PM_UNLOCK(ctxp->c_lock);

    /* Prepare the JSON for the new label. */
    pmsprintf(buf, sizeof(buf), "{%s:%s}",
	      current_label_name, current_label_value);

    hcp = &ctxp->c_archctl->ac_log->hashpmid;
    for (node = __pmHashWalk(hcp, PM_HASH_WALK_START);
	 node != NULL;
	 node = __pmHashWalk(hcp, PM_HASH_WALK_NEXT)) {
	if (pmID_domain(node->key) != pmID_domain(item))
	    continue;
	if (current_star_metric < 2) {
	    if (pmID_cluster(node->key) != pmID_cluster(item))
		continue;
	    if (! current_star_metric && (pmID)(node->key) != (pmID)item)
		continue;
	}

	/*
	 * A metric with this pmID exists.
	 * Add the new label to the generic label change spec for the
	 * identified item. Search for an existing one first.
	 */
	found = 1;
	for (lp = label_root; lp != NULL; lp = lp->l_next) {
	    if (lp->old_type != PM_LABEL_ITEM)
		continue;
	    if ((pmID)(lp->old_id) != (pmID)(node->key))
		continue;
	    if (lp->old_label == NULL)
		break;
	}

	if (lp == NULL)
	    lp = create_label(PM_LABEL_ITEM, (pmID)node->key, 0, NULL, NULL);

	/* Add the new label to the label change spec. */
	if ((sts = __pmAddLabels(&lp->new_labels, buf, PM_LABEL_ITEM)) < 0) {
	    pmsprintf(mess, sizeof(mess),
		      "Unable to add new metric item label %s: %s",
		      buf, pmErrStr(sts));
	    yyerror(mess);
	}
	lp->new_labels->inst = 0;
	lp->flags |= LABEL_NEW;

	/* Do we need to look for more items? */
	if (! current_star_metric)
	    break;
    }

    /* Did we find any items matching the spec? */
    if (! found) {
	pmsprintf(mess, sizeof(mess),
		  "No matching metric for new label %s", buf);
	yywarn(mess);
    }
}

void
new_indom_label(int indom)
{
    labelspec_t		*lp;
    int			sts;
    int			found = 0;
    __pmContext		*ctxp;
    __pmHashCtl		*hcp;
    __pmHashNode	*node;
    char		buf[PM_MAXLABELJSONLEN] = "";

    /*
     * Ignore the change specs which were previously identified and instead
     * search the metadata for metrics in the given domain.
     * Create or re-use the change record for each one found. 
     */
    deactivate_labels();

    ctxp = __pmHandleToPtr(pmWhichContext());
    assert(ctxp != NULL);
    /*
     * Note: This application is single threaded, and once we have ctxp
     *	     the associated __pmContext will not move and will only be
     *	     accessed or modified synchronously either here or in libpcp.
     *	     We unlock the context so that it can be locked as required
     *	     within libpcp.
     */
    PM_UNLOCK(ctxp->c_lock);

    /* Prepare the JSON for the new label. */
    pmsprintf(buf, sizeof(buf), "{%s:%s}",
	      current_label_name, current_label_value);

    hcp = &ctxp->c_archctl->ac_log->hashindom;
    for (node = __pmHashWalk(hcp, PM_HASH_WALK_START);
	 node != NULL;
	 node = __pmHashWalk(hcp, PM_HASH_WALK_NEXT)) {
	if (pmInDom_domain(node->key) != pmInDom_domain(indom))
	    continue;
	if (! current_star_indom && 
	    pmInDom_serial(node->key) != pmInDom_serial(indom))
	    continue;

	/*
	 * A metric in this indom exists.
	 * Add the new label to the generic label change spec for the
	 * identified indom. Search for an existing one first.
	 */
	found = 1;
	for (lp = label_root; lp != NULL; lp = lp->l_next) {
	    if (lp->old_type != PM_LABEL_INDOM)
		continue;
	    if (pmInDom_domain(lp->old_id) != pmInDom_domain((pmInDom)(node->key)))
		continue;
	    if (pmInDom_serial(lp->old_id) != pmInDom_serial((pmInDom)(node->key)))
		continue;
	    if (lp->old_instance != -1)
		continue;
	    if (lp->old_label == NULL)
		break;
	}

	if (lp == NULL) {
	    pmInDom current_indom =
		pmInDom_build(pmInDom_domain(node->key), pmInDom_serial(node->key));
	    lp = create_label(PM_LABEL_INDOM, current_indom, 0, NULL, NULL);
	}

	/* Add the new label to the label change spec. */
	if ((sts = __pmAddLabels(&lp->new_labels, buf, PM_LABEL_INDOM)) < 0) {
	    pmsprintf(mess, sizeof(mess),
		      "Unable to add new indom label %s: %s",
		      buf, pmErrStr(sts));
	    yyerror(mess);
	}
	lp->new_labels->inst = 0;
	lp->flags |= LABEL_NEW;

	/* Do we need to look for more indoms? */
	if (! current_star_indom)
	    break;
    }

    /* Did we find any indoms matching the spec? */
    if (! found) {
	pmsprintf(mess, sizeof(mess),
		  "No matching indom for new label %s", buf);
	yywarn(mess);
    }
}

void
new_indom_instance_label(int indom)
{
    labelspec_t		*lp;
    int			sts;
    int			found = 0;
    __pmContext		*ctxp;
    __pmHashCtl		*hcp;
    __pmHashNode	*node;
    __pmLogInDom	*idp;
    char		buf[PM_MAXLABELJSONLEN] = "";

    /*
     * Ignore the change specs which were previously identified and instead
     * search the metadata for metrics in the given domain.
     * Create or re-use the change record for each one found. 
     */
    deactivate_labels();

    ctxp = __pmHandleToPtr(pmWhichContext());
    assert(ctxp != NULL);
    /*
     * Note: This application is single threaded, and once we have ctxp
     *	     the associated __pmContext will not move and will only be
     *	     accessed or modified synchronously either here or in libpcp.
     *	     We unlock the context so that it can be locked as required
     *	     within libpcp.
     */
    PM_UNLOCK(ctxp->c_lock);

    /* Prepare the JSON for the new label. */
    pmsprintf(buf, sizeof(buf), "{%s:%s}",
	      current_label_name, current_label_value);

    hcp = &ctxp->c_archctl->ac_log->hashindom;
    for (node = __pmHashWalk(hcp, PM_HASH_WALK_START);
	 node != NULL;
	 node = __pmHashWalk(hcp, PM_HASH_WALK_NEXT)) {
	if (pmInDom_domain(node->key) != pmInDom_domain(indom))
	    continue;
	if (! current_star_indom && 
	    pmInDom_serial(node->key) != pmInDom_serial(indom))
	    continue;

	/*
	 * A metric in this indom exists.
	 * Add the new label to the generic label change specs for the
	 * identified indom instances. Search for existing ones first.
	 */
	for (idp = (__pmLogInDom *)node->data; idp != NULL; idp = idp->next) {
	    int indom_ix;
	    for (indom_ix = 0; indom_ix < idp->numinst; ++indom_ix) {
		int instance = idp->instlist[indom_ix];
		if (current_label_instance != -1 && instance != current_label_instance)
		    continue;
		found = 1;
		for (lp = label_root; lp != NULL; lp = lp->l_next) {
		    if (lp->old_type != PM_LABEL_INSTANCES)
			continue;
		    if (pmInDom_domain(lp->old_id) != pmInDom_domain((pmInDom)(node->key)))
			continue;
		    if (pmInDom_serial(lp->old_id) != pmInDom_serial((pmInDom)(node->key)))
			continue;
		    if (lp->old_instance != instance)
			continue;
		    if (lp->old_label == NULL)
			break;
		}

		if (lp == NULL) {
		    pmInDom current_indom =
			pmInDom_build(pmInDom_domain(node->key), pmInDom_serial(node->key));
		    lp = create_label(PM_LABEL_INSTANCES, current_indom,
				      instance, NULL, NULL);
		}

		/* Add the new label to the label change spec. */
		if ((sts = __pmAddLabels(&lp->new_labels, buf, PM_LABEL_INSTANCES)) < 0) {
		    pmsprintf(mess, sizeof(mess),
			      "Unable to add new indom instance label %s: %s",
			      buf, pmErrStr(sts));
		    yyerror(mess);
		}
		lp->new_labels->inst = instance;
		lp->flags |= LABEL_NEW;
	    }
	}

	/* Do we need to look for more indoms? */
	if (! current_star_indom)
	    break;
    }

    /* Did we find any indom instances matching the spec? */
    if (! found) {
	pmsprintf(mess, sizeof(mess),
		  "No matching indom instance for new label %s", buf);
	yywarn(mess);
    }
}


#line 877 "gram.tab.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "gram.tab.h"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_TOK_LBRACE = 3,                 /* TOK_LBRACE  */
  YYSYMBOL_TOK_RBRACE = 4,                 /* TOK_RBRACE  */
  YYSYMBOL_TOK_PLUS = 5,                   /* TOK_PLUS  */
  YYSYMBOL_TOK_MINUS = 6,                  /* TOK_MINUS  */
  YYSYMBOL_TOK_COLON = 7,                  /* TOK_COLON  */
  YYSYMBOL_TOK_COMMA = 8,                  /* TOK_COMMA  */
  YYSYMBOL_TOK_LPAREN = 9,                 /* TOK_LPAREN  */
  YYSYMBOL_TOK_RPAREN = 10,                /* TOK_RPAREN  */
  YYSYMBOL_TOK_ASSIGN = 11,                /* TOK_ASSIGN  */
  YYSYMBOL_TOK_GLOBAL = 12,                /* TOK_GLOBAL  */
  YYSYMBOL_TOK_INDOM = 13,                 /* TOK_INDOM  */
  YYSYMBOL_TOK_DUPLICATE = 14,             /* TOK_DUPLICATE  */
  YYSYMBOL_TOK_METRIC = 15,                /* TOK_METRIC  */
  YYSYMBOL_TOK_HOSTNAME = 16,              /* TOK_HOSTNAME  */
  YYSYMBOL_TOK_TIMEZONE = 17,              /* TOK_TIMEZONE  */
  YYSYMBOL_TOK_ZONEINFO = 18,              /* TOK_ZONEINFO  */
  YYSYMBOL_TOK_FEATURES = 19,              /* TOK_FEATURES  */
  YYSYMBOL_TOK_TIME = 20,                  /* TOK_TIME  */
  YYSYMBOL_TOK_NAME = 21,                  /* TOK_NAME  */
  YYSYMBOL_TOK_INST = 22,                  /* TOK_INST  */
  YYSYMBOL_TOK_INAME = 23,                 /* TOK_INAME  */
  YYSYMBOL_TOK_DELETE = 24,                /* TOK_DELETE  */
  YYSYMBOL_TOK_REDACT = 25,                /* TOK_REDACT  */
  YYSYMBOL_TOK_REPLACE = 26,               /* TOK_REPLACE  */
  YYSYMBOL_TOK_PMID = 27,                  /* TOK_PMID  */
  YYSYMBOL_TOK_NULL_INT = 28,              /* TOK_NULL_INT  */
  YYSYMBOL_TOK_TYPE = 29,                  /* TOK_TYPE  */
  YYSYMBOL_TOK_IF = 30,                    /* TOK_IF  */
  YYSYMBOL_TOK_SEM = 31,                   /* TOK_SEM  */
  YYSYMBOL_TOK_UNITS = 32,                 /* TOK_UNITS  */
  YYSYMBOL_TOK_METRIC_VALUE = 33,          /* TOK_METRIC_VALUE  */
  YYSYMBOL_TOK_OUTPUT = 34,                /* TOK_OUTPUT  */
  YYSYMBOL_TOK_RESCALE = 35,               /* TOK_RESCALE  */
  YYSYMBOL_TOK_TEXT = 36,                  /* TOK_TEXT  */
  YYSYMBOL_TOK_ONELINE = 37,               /* TOK_ONELINE  */
  YYSYMBOL_TOK_HELP = 38,                  /* TOK_HELP  */
  YYSYMBOL_TOK_TEXT_STAR = 39,             /* TOK_TEXT_STAR  */
  YYSYMBOL_TOK_LABEL = 40,                 /* TOK_LABEL  */
  YYSYMBOL_TOK_CONTEXT = 41,               /* TOK_CONTEXT  */
  YYSYMBOL_TOK_LABEL_STAR = 42,            /* TOK_LABEL_STAR  */
  YYSYMBOL_TOK_DOMAIN = 43,                /* TOK_DOMAIN  */
  YYSYMBOL_TOK_CLUSTER = 44,               /* TOK_CLUSTER  */
  YYSYMBOL_TOK_ITEM = 45,                  /* TOK_ITEM  */
  YYSYMBOL_TOK_INSTANCES = 46,             /* TOK_INSTANCES  */
  YYSYMBOL_TOK_INSTANCE = 47,              /* TOK_INSTANCE  */
  YYSYMBOL_TOK_NEW = 48,                   /* TOK_NEW  */
  YYSYMBOL_TOK_VALUE = 49,                 /* TOK_VALUE  */
  YYSYMBOL_TOK_BITS = 50,                  /* TOK_BITS  */
  YYSYMBOL_TOK_GNAME = 51,                 /* TOK_GNAME  */
  YYSYMBOL_TOK_NUMBER = 52,                /* TOK_NUMBER  */
  YYSYMBOL_TOK_STRING = 53,                /* TOK_STRING  */
  YYSYMBOL_TOK_TEXT_STRING = 54,           /* TOK_TEXT_STRING  */
  YYSYMBOL_TOK_HNAME = 55,                 /* TOK_HNAME  */
  YYSYMBOL_TOK_FLOAT = 56,                 /* TOK_FLOAT  */
  YYSYMBOL_TOK_PATTERN = 57,               /* TOK_PATTERN  */
  YYSYMBOL_TOK_JSON_STRING = 58,           /* TOK_JSON_STRING  */
  YYSYMBOL_TOK_JSON_NUMBER = 59,           /* TOK_JSON_NUMBER  */
  YYSYMBOL_TOK_JSON_TRUE = 60,             /* TOK_JSON_TRUE  */
  YYSYMBOL_TOK_JSON_FALSE = 61,            /* TOK_JSON_FALSE  */
  YYSYMBOL_TOK_JSON_NULL = 62,             /* TOK_JSON_NULL  */
  YYSYMBOL_TOK_INDOM_STAR = 63,            /* TOK_INDOM_STAR  */
  YYSYMBOL_TOK_PMID_INT = 64,              /* TOK_PMID_INT  */
  YYSYMBOL_TOK_PMID_STAR = 65,             /* TOK_PMID_STAR  */
  YYSYMBOL_TOK_TYPE_NAME = 66,             /* TOK_TYPE_NAME  */
  YYSYMBOL_TOK_SEM_NAME = 67,              /* TOK_SEM_NAME  */
  YYSYMBOL_TOK_SPACE_NAME = 68,            /* TOK_SPACE_NAME  */
  YYSYMBOL_TOK_TIME_NAME = 69,             /* TOK_TIME_NAME  */
  YYSYMBOL_TOK_COUNT_NAME = 70,            /* TOK_COUNT_NAME  */
  YYSYMBOL_TOK_OUTPUT_TYPE = 71,           /* TOK_OUTPUT_TYPE  */
  YYSYMBOL_YYACCEPT = 72,                  /* $accept  */
  YYSYMBOL_config = 73,                    /* config  */
  YYSYMBOL_speclist = 74,                  /* speclist  */
  YYSYMBOL_spec = 75,                      /* spec  */
  YYSYMBOL_globalspec = 76,                /* globalspec  */
  YYSYMBOL_globaloptlist = 77,             /* globaloptlist  */
  YYSYMBOL_globalopt = 78,                 /* globalopt  */
  YYSYMBOL_feature_bits = 79,              /* feature_bits  */
  YYSYMBOL_bits_list = 80,                 /* bits_list  */
  YYSYMBOL_hname = 81,                     /* hname  */
  YYSYMBOL_signnumber = 82,                /* signnumber  */
  YYSYMBOL_number = 83,                    /* number  */
  YYSYMBOL_float = 84,                     /* float  */
  YYSYMBOL_signtime = 85,                  /* signtime  */
  YYSYMBOL_time = 86,                      /* time  */
  YYSYMBOL_indomspec = 87,                 /* indomspec  */
  YYSYMBOL_88_1 = 88,                      /* $@1  */
  YYSYMBOL_indom_int = 89,                 /* indom_int  */
  YYSYMBOL_optindomopt = 90,               /* optindomopt  */
  YYSYMBOL_indomoptlist = 91,              /* indomoptlist  */
  YYSYMBOL_indomopt = 92,                  /* indomopt  */
  YYSYMBOL_duplicateopt = 93,              /* duplicateopt  */
  YYSYMBOL_metricspec = 94,                /* metricspec  */
  YYSYMBOL_95_2 = 95,                      /* $@2  */
  YYSYMBOL_pmid_or_name = 96,              /* pmid_or_name  */
  YYSYMBOL_pmid_int = 97,                  /* pmid_int  */
  YYSYMBOL_optmetricoptlist = 98,          /* optmetricoptlist  */
  YYSYMBOL_metricoptlist = 99,             /* metricoptlist  */
  YYSYMBOL_metricopt = 100,                /* metricopt  */
  YYSYMBOL_optreplace = 101,               /* optreplace  */
  YYSYMBOL_null_or_indom = 102,            /* null_or_indom  */
  YYSYMBOL_pick = 103,                     /* pick  */
  YYSYMBOL_rescaleopt = 104,               /* rescaleopt  */
  YYSYMBOL_textspec = 105,                 /* textspec  */
  YYSYMBOL_textmetricorindomspec = 106,    /* textmetricorindomspec  */
  YYSYMBOL_textmetricspec = 107,           /* textmetricspec  */
  YYSYMBOL_108_3 = 108,                    /* $@3  */
  YYSYMBOL_opttexttypes = 109,             /* opttexttypes  */
  YYSYMBOL_texttypes = 110,                /* texttypes  */
  YYSYMBOL_texttype = 111,                 /* texttype  */
  YYSYMBOL_opttextvalue = 112,             /* opttextvalue  */
  YYSYMBOL_opttextmetricoptlist = 113,     /* opttextmetricoptlist  */
  YYSYMBOL_textmetricoptlist = 114,        /* textmetricoptlist  */
  YYSYMBOL_textmetricopt = 115,            /* textmetricopt  */
  YYSYMBOL_textstring = 116,               /* textstring  */
  YYSYMBOL_pattern = 117,                  /* pattern  */
  YYSYMBOL_replacement = 118,              /* replacement  */
  YYSYMBOL_textindomspec = 119,            /* textindomspec  */
  YYSYMBOL_120_4 = 120,                    /* $@4  */
  YYSYMBOL_opttextindomoptlist = 121,      /* opttextindomoptlist  */
  YYSYMBOL_textindomoptlist = 122,         /* textindomoptlist  */
  YYSYMBOL_textindomopt = 123,             /* textindomopt  */
  YYSYMBOL_labelspec = 124,                /* labelspec  */
  YYSYMBOL_labelcontextormetricorindomspec = 125, /* labelcontextormetricorindomspec  */
  YYSYMBOL_labelcontextspec = 126,         /* labelcontextspec  */
  YYSYMBOL_127_5 = 127,                    /* $@5  */
  YYSYMBOL_optlabeldetails = 128,          /* optlabeldetails  */
  YYSYMBOL_jsonname = 129,                 /* jsonname  */
  YYSYMBOL_optlabelvalue = 130,            /* optlabelvalue  */
  YYSYMBOL_jsonvalue = 131,                /* jsonvalue  */
  YYSYMBOL_jsonnumber = 132,               /* jsonnumber  */
  YYSYMBOL_optlabelcontextoptlist = 133,   /* optlabelcontextoptlist  */
  YYSYMBOL_labelcontextoptlist = 134,      /* labelcontextoptlist  */
  YYSYMBOL_labelcontextopt = 135,          /* labelcontextopt  */
  YYSYMBOL_newlabelspec = 136,             /* newlabelspec  */
  YYSYMBOL_labeldomainspec = 137,          /* labeldomainspec  */
  YYSYMBOL_138_6 = 138,                    /* $@6  */
  YYSYMBOL_pmid_domain = 139,              /* pmid_domain  */
  YYSYMBOL_optlabeldomainoptlist = 140,    /* optlabeldomainoptlist  */
  YYSYMBOL_labeldomainoptlist = 141,       /* labeldomainoptlist  */
  YYSYMBOL_labeldomainopt = 142,           /* labeldomainopt  */
  YYSYMBOL_labelclusterspec = 143,         /* labelclusterspec  */
  YYSYMBOL_144_7 = 144,                    /* $@7  */
  YYSYMBOL_pmid_cluster = 145,             /* pmid_cluster  */
  YYSYMBOL_optlabelclusteroptlist = 146,   /* optlabelclusteroptlist  */
  YYSYMBOL_labelclusteroptlist = 147,      /* labelclusteroptlist  */
  YYSYMBOL_labelclusteropt = 148,          /* labelclusteropt  */
  YYSYMBOL_labelitemspec = 149,            /* labelitemspec  */
  YYSYMBOL_150_8 = 150,                    /* $@8  */
  YYSYMBOL_optlabelitemoptlist = 151,      /* optlabelitemoptlist  */
  YYSYMBOL_labelitemoptlist = 152,         /* labelitemoptlist  */
  YYSYMBOL_labelitemopt = 153,             /* labelitemopt  */
  YYSYMBOL_labelindomspec = 154,           /* labelindomspec  */
  YYSYMBOL_155_9 = 155,                    /* $@9  */
  YYSYMBOL_optlabelindomoptlist = 156,     /* optlabelindomoptlist  */
  YYSYMBOL_labelindomoptlist = 157,        /* labelindomoptlist  */
  YYSYMBOL_labelindomopt = 158,            /* labelindomopt  */
  YYSYMBOL_labelinstancesspec = 159,       /* labelinstancesspec  */
  YYSYMBOL_160_10 = 160,                   /* $@10  */
  YYSYMBOL_optinstancelabeldetails = 161,  /* optinstancelabeldetails  */
  YYSYMBOL_optlabelinstancesoptlist = 162, /* optlabelinstancesoptlist  */
  YYSYMBOL_labelinstancesoptlist = 163,    /* labelinstancesoptlist  */
  YYSYMBOL_labelinstancesopt = 164         /* labelinstancesopt  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  41
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   362

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  72
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  93
/* YYNRULES -- Number of rules.  */
#define YYNRULES  262
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  376

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   326


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   901,   901,   904,   905,   908,   909,   910,   911,   912,
     915,   916,   919,   920,   923,   942,   961,   984,  1006,  1022,
    1027,  1032,  1037,  1042,  1047,  1052,  1057,  1062,  1067,  1074,
    1080,  1084,  1089,  1094,  1101,  1112,  1132,  1133,  1134,  1135,
    1136,  1139,  1144,  1149,  1156,  1163,  1170,  1171,  1172,  1175,
    1188,  1200,  1213,  1225,  1234,  1246,  1245,  1278,  1285,  1303,
    1318,  1319,  1322,  1323,  1326,  1351,  1361,  1370,  1378,  1404,
    1412,  1420,  1425,  1430,  1435,  1440,  1445,  1450,  1455,  1460,
    1465,  1470,  1478,  1479,  1483,  1482,  1525,  1532,  1533,  1551,
    1578,  1614,  1615,  1618,  1619,  1622,  1646,  1674,  1702,  1733,
    1807,  1824,  1870,  1908,  1915,  1920,  1925,  1930,  1935,  1940,
    1945,  1950,  1955,  1960,  1965,  1970,  1975,  1980,  1987,  1988,
    1991,  1992,  1998,  2004,  2010,  2014,  2019,  2022,  2024,  2027,
    2030,  2031,  2035,  2034,  2134,  2137,  2140,  2142,  2146,  2148,
    2150,  2154,  2157,  2160,  2162,  2170,  2171,  2174,  2181,  2210,
    2259,  2261,  2265,  2267,  2271,  2273,  2278,  2277,  2370,  2372,
    2380,  2381,  2384,  2391,  2420,  2448,  2451,  2452,  2453,  2454,
    2455,  2456,  2460,  2459,  2514,  2516,  2519,  2525,  2527,  2534,
    2536,  2539,  2542,  2544,  2546,  2548,  2550,  2554,  2559,  2561,
    2566,  2570,  2572,  2577,  2578,  2581,  2588,  2612,  2637,  2642,
    2658,  2657,  2717,  2736,  2738,  2743,  2744,  2747,  2754,  2783,
    2807,  2831,  2838,  2837,  2916,  2938,  2957,  2959,  2964,  2965,
    2968,  2975,  3001,  3024,  3047,  3054,  3053,  3143,  3145,  3150,
    3151,  3154,  3161,  3189,  3212,  3235,  3242,  3241,  3324,  3326,
    3331,  3332,  3335,  3342,  3368,  3391,  3414,  3421,  3420,  3505,
    3510,  3516,  3522,  3530,  3532,  3537,  3538,  3541,  3548,  3574,
    3599,  3622,  3645
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "TOK_LBRACE",
  "TOK_RBRACE", "TOK_PLUS", "TOK_MINUS", "TOK_COLON", "TOK_COMMA",
  "TOK_LPAREN", "TOK_RPAREN", "TOK_ASSIGN", "TOK_GLOBAL", "TOK_INDOM",
  "TOK_DUPLICATE", "TOK_METRIC", "TOK_HOSTNAME", "TOK_TIMEZONE",
  "TOK_ZONEINFO", "TOK_FEATURES", "TOK_TIME", "TOK_NAME", "TOK_INST",
  "TOK_INAME", "TOK_DELETE", "TOK_REDACT", "TOK_REPLACE", "TOK_PMID",
  "TOK_NULL_INT", "TOK_TYPE", "TOK_IF", "TOK_SEM", "TOK_UNITS",
  "TOK_METRIC_VALUE", "TOK_OUTPUT", "TOK_RESCALE", "TOK_TEXT",
  "TOK_ONELINE", "TOK_HELP", "TOK_TEXT_STAR", "TOK_LABEL", "TOK_CONTEXT",
  "TOK_LABEL_STAR", "TOK_DOMAIN", "TOK_CLUSTER", "TOK_ITEM",
  "TOK_INSTANCES", "TOK_INSTANCE", "TOK_NEW", "TOK_VALUE", "TOK_BITS",
  "TOK_GNAME", "TOK_NUMBER", "TOK_STRING", "TOK_TEXT_STRING", "TOK_HNAME",
  "TOK_FLOAT", "TOK_PATTERN", "TOK_JSON_STRING", "TOK_JSON_NUMBER",
  "TOK_JSON_TRUE", "TOK_JSON_FALSE", "TOK_JSON_NULL", "TOK_INDOM_STAR",
  "TOK_PMID_INT", "TOK_PMID_STAR", "TOK_TYPE_NAME", "TOK_SEM_NAME",
  "TOK_SPACE_NAME", "TOK_TIME_NAME", "TOK_COUNT_NAME", "TOK_OUTPUT_TYPE",
  "$accept", "config", "speclist", "spec", "globalspec", "globaloptlist",
  "globalopt", "feature_bits", "bits_list", "hname", "signnumber",
  "number", "float", "signtime", "time", "indomspec", "$@1", "indom_int",
  "optindomopt", "indomoptlist", "indomopt", "duplicateopt", "metricspec",
  "$@2", "pmid_or_name", "pmid_int", "optmetricoptlist", "metricoptlist",
  "metricopt", "optreplace", "null_or_indom", "pick", "rescaleopt",
  "textspec", "textmetricorindomspec", "textmetricspec", "$@3",
  "opttexttypes", "texttypes", "texttype", "opttextvalue",
  "opttextmetricoptlist", "textmetricoptlist", "textmetricopt",
  "textstring", "pattern", "replacement", "textindomspec", "$@4",
  "opttextindomoptlist", "textindomoptlist", "textindomopt", "labelspec",
  "labelcontextormetricorindomspec", "labelcontextspec", "$@5",
  "optlabeldetails", "jsonname", "optlabelvalue", "jsonvalue",
  "jsonnumber", "optlabelcontextoptlist", "labelcontextoptlist",
  "labelcontextopt", "newlabelspec", "labeldomainspec", "$@6",
  "pmid_domain", "optlabeldomainoptlist", "labeldomainoptlist",
  "labeldomainopt", "labelclusterspec", "$@7", "pmid_cluster",
  "optlabelclusteroptlist", "labelclusteroptlist", "labelclusteropt",
  "labelitemspec", "$@8", "optlabelitemoptlist", "labelitemoptlist",
  "labelitemopt", "labelindomspec", "$@9", "optlabelindomoptlist",
  "labelindomoptlist", "labelindomopt", "labelinstancesspec", "$@10",
  "optinstancelabeldetails", "optlabelinstancesoptlist",
  "labelinstancesoptlist", "labelinstancesopt", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-276)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-84)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
      98,    82,    32,    65,   148,    79,   127,  -276,    98,  -276,
    -276,  -276,  -276,  -276,   177,  -276,  -276,  -276,  -276,  -276,
    -276,  -276,  -276,    32,    65,  -276,  -276,  -276,    32,   -17,
     117,    58,    65,    32,  -276,  -276,  -276,  -276,  -276,  -276,
    -276,  -276,  -276,  -276,   139,   171,   176,   178,   196,   174,
     193,   212,   216,   167,   167,   -17,     1,  -276,  -276,  -276,
       1,  -276,   -17,  -276,  -276,   -17,   -17,    30,   147,   168,
     169,    85,    25,  -276,  -276,    67,   159,  -276,  -276,  -276,
      46,  -276,   167,    46,  -276,    99,  -276,  -276,  -276,  -276,
    -276,  -276,  -276,  -276,  -276,  -276,   217,  -276,  -276,  -276,
    -276,   -17,   -17,   -17,  -276,  -276,  -276,  -276,  -276,  -276,
    -276,  -276,  -276,   214,  -276,  -276,   -24,   -24,  -276,  -276,
     218,  -276,  -276,  -276,   213,   175,    41,   222,  -276,    67,
     219,   220,  -276,   221,    35,   223,   224,   202,   225,  -276,
     159,  -276,  -276,  -276,  -276,  -276,  -276,   230,  -276,  -276,
     136,   233,   234,   235,  -276,  -276,  -276,   236,   188,  -276,
    -276,   -24,    -6,   231,  -276,   122,   232,  -276,  -276,   -11,
     190,     6,   179,   180,   181,    17,  -276,   122,  -276,  -276,
     241,   244,     0,  -276,   238,    73,   239,   247,  -276,   136,
    -276,   119,   104,   125,    93,  -276,   156,   245,  -276,  -276,
      32,   -10,  -276,  -276,   242,     5,  -276,  -276,   226,  -276,
    -276,  -276,   243,  -276,   203,   204,  -276,   249,   248,    20,
      11,   250,  -276,   251,   252,  -276,   254,  -276,     0,    73,
      45,    45,  -276,  -276,  -276,   253,   255,   256,  -276,   261,
    -276,   119,  -276,   258,   259,   260,  -276,   269,  -276,   104,
    -276,   263,   265,   266,  -276,   274,  -276,   125,  -276,   268,
     270,   271,   272,  -276,   280,  -276,    93,   237,  -276,   -24,
    -276,  -276,  -276,   161,  -276,  -276,    -7,  -276,   227,  -276,
    -276,    17,   161,   275,  -276,   276,   284,  -276,    20,   281,
    -276,   283,   287,  -276,    11,    32,    73,    45,  -276,  -276,
    -276,  -276,  -276,    73,   246,    45,  -276,  -276,    73,    58,
      45,  -276,  -276,    73,     6,    45,  -276,  -276,    73,    32,
     257,    45,  -276,  -276,  -276,  -276,  -276,  -276,  -276,  -276,
     175,   262,  -276,  -276,   289,  -276,    32,    46,  -276,  -276,
       6,    46,  -276,  -276,  -276,  -276,  -276,  -276,  -276,  -276,
    -276,  -276,  -276,  -276,  -276,  -276,  -276,  -276,  -276,  -276,
    -276,  -276,    17,  -276,  -276,  -276,  -276,   291,   240,   292,
     264,   293,   267,   277,  -276,  -276
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       0,     0,    57,    86,     0,     0,     0,     2,     3,     5,
       6,     7,     8,     9,     0,    58,    59,    55,    88,    89,
      90,    84,    87,     0,     0,   129,   130,   131,     0,   176,
       0,     0,     0,     0,   165,   166,   167,   168,   169,   170,
     171,     1,     4,    11,    20,    22,    24,    26,    28,     0,
      12,     0,     0,   135,   135,   176,   181,   178,   177,   172,
     181,   202,   176,   214,   215,   176,   176,   252,    19,    21,
      23,    25,    27,    10,    13,    61,    92,   140,   139,   138,
     142,   134,   136,   142,   236,     0,   180,   188,   190,   184,
     185,   186,   182,   175,   179,   183,     0,   174,   200,   212,
     225,   176,   176,   176,   247,    37,    38,    40,    36,    39,
      14,    15,    16,    33,    29,    17,     0,     0,    44,    45,
      54,    53,    18,    48,    72,    78,    75,     0,    60,    62,
       0,     0,   103,     0,     0,     0,     0,   119,     0,    91,
      93,   150,   151,   156,   141,   137,   132,     0,   187,   189,
     192,     0,     0,     0,   251,   250,   249,     0,    32,    46,
      47,     0,    71,    77,    67,    81,    74,    56,    63,   109,
     105,   104,   106,   107,   110,   111,   118,   117,    85,    94,
       0,     0,   239,   195,     0,     0,     0,     0,   191,   193,
     198,   204,   217,   228,   254,    34,    31,    52,    51,    82,
       0,    76,   153,   152,    80,    73,   121,   120,   126,    96,
      95,    97,     0,   100,     0,     0,    43,     0,   116,   159,
     144,     0,   242,     0,     0,   246,     0,   238,   240,     0,
       0,     0,   173,   194,   207,     0,     0,     0,   211,     0,
     203,   205,   220,     0,     0,     0,   224,     0,   216,   218,
     231,     0,     0,     0,   235,     0,   227,   229,   257,     0,
       0,     0,     0,   262,     0,   253,   255,     0,    30,     0,
      64,    70,    69,    79,    66,    65,   125,    99,   108,    41,
      42,     0,   115,     0,   162,     0,     0,   158,   160,     0,
     147,     0,     0,   143,   145,     0,     0,     0,   237,   241,
     196,   199,   197,     0,     0,     0,   201,   206,     0,     0,
       0,   213,   219,     0,     0,     0,   226,   230,     0,     0,
       0,     0,   248,   256,    35,    50,    49,   154,   155,    68,
       0,     0,   124,    98,     0,   102,     0,     0,   157,   161,
       0,     0,   133,   146,   243,   244,   245,   209,   208,   210,
     222,   221,   223,   233,   232,   234,   260,   258,   259,   261,
     122,   123,     0,   164,   163,   149,   148,     0,   112,     0,
     113,     0,   114,   128,   127,   101
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -276,  -276,   294,  -276,  -276,   273,  -276,  -276,  -276,  -276,
    -275,  -122,  -157,  -276,   100,  -276,  -276,   -23,  -276,   166,
    -276,  -276,  -276,  -276,    77,  -169,  -276,   163,  -276,  -276,
    -276,  -276,  -276,  -276,  -276,  -276,  -276,   278,   228,  -276,
     279,  -276,    10,  -276,  -205,   128,    24,  -276,  -276,  -276,
      19,  -276,  -276,  -276,  -276,  -276,    53,   -28,   282,  -219,
    -276,  -276,   129,  -276,  -173,  -276,  -276,  -276,  -276,    70,
    -276,  -276,  -276,     7,  -276,    68,  -276,  -276,  -276,  -276,
      57,  -276,  -276,  -276,  -276,    91,  -276,  -276,  -276,  -276,
    -276,    54,  -276
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,     6,     7,     8,     9,    49,    50,   115,   196,   110,
     217,   120,   121,   122,   123,    10,    51,    17,   127,   128,
     129,   200,    11,    52,    21,    22,   138,   139,   140,   177,
     208,   277,   375,    12,    25,    26,   181,    80,    81,    82,
     143,   292,   293,   294,   144,   204,   329,    27,   180,   286,
     287,   288,    13,    34,    35,    96,    59,    92,    93,    94,
      95,   187,   188,   189,   190,    36,   151,    62,   239,   240,
     241,    37,   152,    65,   247,   248,   249,    38,   153,   255,
     256,   257,    39,   147,   226,   227,   228,    40,   157,   104,
     264,   265,   266
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      53,    60,   210,   163,   198,    55,   334,    85,   199,   225,
      67,   301,   302,   221,   271,   330,   331,   206,   238,   246,
     254,   263,   214,   215,   222,    56,   289,    60,   118,   274,
     116,   117,   119,   283,    60,   290,    57,    60,    60,   197,
     223,    58,   118,    86,   284,    15,   172,   291,   185,   224,
     -83,    85,    16,    87,    57,   225,   285,   -83,   275,    58,
      88,    89,    90,    91,   332,   173,   164,   165,   238,   216,
      19,    20,   101,    60,    60,    60,   246,   118,   346,   272,
     124,   119,   102,   103,   254,    14,   349,   367,    15,   125,
     126,   352,    28,   263,   166,    16,   355,    87,    57,   141,
     142,    54,   359,    58,    88,    89,    90,    91,    84,    66,
       1,     2,   326,     3,    63,    98,    18,   258,    99,   100,
      29,    64,    30,    31,    32,    33,    57,    41,   242,    19,
      20,    58,   364,   259,     4,   113,   366,   114,     5,   260,
     261,   185,   262,   234,   243,   354,   207,   325,   244,   250,
      68,   148,   185,   245,   154,   155,   156,   230,   149,   235,
     183,    23,   236,    24,   267,   251,   268,   185,   237,    61,
     252,   365,   130,   185,   253,   202,   184,   270,    73,   203,
     131,    43,    69,   132,   185,   186,   133,    70,   134,    71,
     135,   136,   137,    44,    45,    46,    47,    48,   105,   106,
     107,   300,   108,   109,    77,    78,    79,    72,   360,    44,
      45,    46,    47,    48,   327,    75,   159,   160,   328,    76,
     150,   111,   112,   158,   162,   161,   167,   118,   176,   178,
     169,   170,   171,   182,   174,   175,   191,   192,   193,   194,
     195,   209,   201,   205,   219,   211,   212,   220,   213,   229,
     231,   232,   269,   273,   278,   279,   280,   281,   298,   282,
     276,   295,   296,   297,   303,   306,   304,   305,   345,   308,
     309,   310,   344,   311,   313,   347,   314,   315,   316,   318,
     350,   319,   320,   321,   322,   353,   336,   337,   338,   324,
     356,   342,   340,   333,   341,   168,   357,   362,   348,   368,
     370,   372,    42,   179,   343,   218,   335,   339,   369,   358,
     145,   307,   374,   363,   317,   361,   351,   312,   233,   299,
     323,     0,     0,    74,     0,     0,     0,     0,     0,     0,
       0,     0,    83,   371,     0,     0,     0,   373,     0,     0,
       0,     0,    97,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   146
};

static const yytype_int16 yycheck[] =
{
      23,    29,   171,   125,   161,    28,   281,     6,    14,   182,
      33,   230,   231,    13,    24,    22,    23,    28,   191,   192,
     193,   194,     5,     6,    24,    42,    15,    55,    52,    24,
       5,     6,    56,    13,    62,    24,    53,    65,    66,   161,
      40,    58,    52,    42,    24,    56,    11,    36,    48,    49,
      56,     6,    63,    52,    53,   228,    36,    63,    53,    58,
      59,    60,    61,    62,    71,    30,    25,    26,   241,    52,
      64,    65,    42,   101,   102,   103,   249,    52,   297,   201,
      13,    56,    52,    53,   257,     3,   305,   362,    56,    22,
      23,   310,    13,   266,    53,    63,   315,    52,    53,    53,
      54,    24,   321,    58,    59,    60,    61,    62,    55,    32,
      12,    13,   269,    15,    56,    62,    51,    24,    65,    66,
      41,    63,    43,    44,    45,    46,    53,     0,    24,    64,
      65,    58,   337,    40,    36,    50,   341,    52,    40,    46,
      47,    48,    49,    24,    40,   314,   169,   269,    44,    24,
      11,    52,    48,    49,   101,   102,   103,   185,    59,    40,
      24,    13,    43,    15,     8,    40,    10,    48,    49,    52,
      45,   340,    13,    48,    49,    53,    40,   200,     4,    57,
      21,     4,    11,    24,    48,    49,    27,    11,    29,    11,
      31,    32,    33,    16,    17,    18,    19,    20,    51,    52,
      53,   229,    55,    56,    37,    38,    39,    11,   330,    16,
      17,    18,    19,    20,    53,     3,   116,   117,    57,     3,
       3,    53,    53,     9,    11,     7,     4,    52,    26,     4,
      11,    11,    11,     3,    11,    11,     3,     3,     3,     3,
      52,    51,    11,    11,     3,    66,    66,     3,    67,    11,
      11,     4,     7,    11,    11,    52,    52,     8,     4,    11,
      34,    11,    11,    11,    11,     4,    11,    11,   296,    11,
      11,    11,   295,     4,    11,   303,    11,    11,     4,    11,
     308,    11,    11,    11,     4,   313,    11,    11,     4,    52,
     318,     4,    11,    66,    11,   129,   319,     8,    52,     8,
       8,     8,     8,   140,   294,   177,   282,   288,    68,    52,
      82,   241,    35,   336,   257,    53,   309,   249,   189,   228,
     266,    -1,    -1,    50,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    54,    69,    -1,    -1,    -1,    70,    -1,    -1,
      -1,    -1,    60,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    83
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,    12,    13,    15,    36,    40,    73,    74,    75,    76,
      87,    94,   105,   124,     3,    56,    63,    89,    51,    64,
      65,    96,    97,    13,    15,   106,   107,   119,    13,    41,
      43,    44,    45,    46,   125,   126,   137,   143,   149,   154,
     159,     0,    74,     4,    16,    17,    18,    19,    20,    77,
      78,    88,    95,    89,    96,    89,    42,    53,    58,   128,
     129,    52,   139,    56,    63,   145,    96,    89,    11,    11,
      11,    11,    11,     4,    77,     3,     3,    37,    38,    39,
     109,   110,   111,   109,   128,     6,    42,    52,    59,    60,
      61,    62,   129,   130,   131,   132,   127,   130,   128,   128,
     128,    42,    52,    53,   161,    51,    52,    53,    55,    56,
      81,    53,    53,    50,    52,    79,     5,     6,    52,    56,
      83,    84,    85,    86,    13,    22,    23,    90,    91,    92,
      13,    21,    24,    27,    29,    31,    32,    33,    98,    99,
     100,    53,    54,   112,   116,   110,   112,   155,    52,    59,
       3,   138,   144,   150,   128,   128,   128,   160,     9,    86,
      86,     7,    11,    83,    25,    26,    53,     4,    91,    11,
      11,    11,    11,    30,    11,    11,    26,   101,     4,    99,
     120,   108,     3,    24,    40,    48,    49,   133,   134,   135,
     136,     3,     3,     3,     3,    52,    80,    83,    84,    14,
      93,    11,    53,    57,   117,    11,    28,    89,   102,    51,
      97,    66,    66,    67,     5,     6,    52,    82,   117,     3,
       3,    13,    24,    40,    49,   136,   156,   157,   158,    11,
     129,    11,     4,   134,    24,    40,    43,    49,   136,   140,
     141,   142,    24,    40,    44,    49,   136,   146,   147,   148,
      24,    40,    45,    49,   136,   151,   152,   153,    24,    40,
      46,    47,    49,   136,   162,   163,   164,     8,    10,     7,
      89,    24,    83,    11,    24,    53,    34,   103,    11,    52,
      52,     8,    11,    13,    24,    36,   121,   122,   123,    15,
      24,    36,   113,   114,   115,    11,    11,    11,     4,   157,
     129,   131,   131,    11,    11,    11,     4,   141,    11,    11,
      11,     4,   147,    11,    11,    11,     4,   152,    11,    11,
      11,    11,     4,   163,    52,    83,    84,    53,    57,   118,
      22,    23,    71,    66,    82,   118,    11,    11,     4,   122,
      11,    11,     4,   114,    89,   129,   131,   129,    52,   131,
     129,   145,   131,   129,    97,   131,   129,    89,    52,   131,
      83,    53,     8,    89,   116,    97,   116,    82,     8,    68,
       8,    69,     8,    70,    35,   104
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_uint8 yyr1[] =
{
       0,    72,    73,    74,    74,    75,    75,    75,    75,    75,
      76,    76,    77,    77,    78,    78,    78,    78,    78,    78,
      78,    78,    78,    78,    78,    78,    78,    78,    78,    79,
      79,    79,    79,    79,    80,    80,    81,    81,    81,    81,
      81,    82,    82,    82,    83,    84,    85,    85,    85,    86,
      86,    86,    86,    86,    86,    88,    87,    87,    89,    89,
      90,    90,    91,    91,    92,    92,    92,    92,    92,    92,
      92,    92,    92,    92,    92,    92,    92,    92,    92,    92,
      92,    92,    93,    93,    95,    94,    94,    96,    96,    97,
      97,    98,    98,    99,    99,   100,   100,   100,   100,   100,
     100,   100,   100,   100,   100,   100,   100,   100,   100,   100,
     100,   100,   100,   100,   100,   100,   100,   100,   101,   101,
     102,   102,   103,   103,   103,   103,   103,   104,   104,   105,
     106,   106,   108,   107,   109,   109,   110,   110,   111,   111,
     111,   112,   112,   113,   113,   114,   114,   115,   115,   115,
     116,   116,   117,   117,   118,   118,   120,   119,   121,   121,
     122,   122,   123,   123,   123,   124,   125,   125,   125,   125,
     125,   125,   127,   126,   128,   128,   128,   129,   129,   130,
     130,   130,   131,   131,   131,   131,   131,   132,   132,   132,
     132,   133,   133,   134,   134,   135,   135,   135,   135,   136,
     138,   137,   139,   140,   140,   141,   141,   142,   142,   142,
     142,   142,   144,   143,   145,   145,   146,   146,   147,   147,
     148,   148,   148,   148,   148,   150,   149,   151,   151,   152,
     152,   153,   153,   153,   153,   153,   155,   154,   156,   156,
     157,   157,   158,   158,   158,   158,   158,   160,   159,   161,
     161,   161,   161,   162,   162,   163,   163,   164,   164,   164,
     164,   164,   164
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     1,     1,     2,     1,     1,     1,     1,     1,
       4,     3,     1,     2,     3,     3,     3,     3,     3,     2,
       1,     2,     1,     2,     1,     2,     1,     2,     1,     1,
       4,     3,     2,     1,     1,     3,     1,     1,     1,     1,
       1,     2,     2,     1,     1,     1,     2,     2,     1,     5,
       5,     3,     3,     1,     1,     0,     6,     1,     1,     1,
       1,     0,     1,     2,     4,     4,     4,     2,     5,     4,
       4,     2,     1,     3,     2,     1,     3,     2,     1,     4,
       3,     2,     1,     0,     0,     6,     1,     1,     1,     1,
       1,     1,     0,     1,     2,     3,     3,     3,     5,     4,
       3,    14,     5,     1,     2,     2,     2,     2,     4,     2,
       2,     2,     8,    10,    12,     4,     3,     2,     1,     0,
       1,     1,     3,     3,     2,     1,     0,     1,     0,     2,
       1,     1,     0,     8,     1,     0,     1,     2,     1,     1,
       1,     1,     0,     1,     0,     1,     2,     1,     3,     3,
       1,     1,     1,     1,     1,     1,     0,     8,     1,     0,
       1,     2,     1,     3,     3,     2,     1,     1,     1,     1,
       1,     1,     0,     6,     2,     2,     0,     1,     1,     1,
       1,     0,     1,     1,     1,     1,     1,     2,     1,     2,
       1,     1,     0,     1,     2,     1,     3,     3,     1,     3,
       0,     7,     1,     1,     0,     1,     2,     1,     3,     3,
       3,     1,     0,     7,     1,     1,     1,     0,     1,     2,
       1,     3,     3,     3,     1,     0,     7,     1,     0,     1,
       2,     1,     3,     3,     3,     1,     0,     7,     1,     0,
       1,     2,     1,     3,     3,     3,     1,     0,     7,     2,
       2,     2,     0,     1,     0,     1,     2,     1,     3,     3,
       3,     3,     1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YY_USE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 14: /* globalopt: TOK_HOSTNAME TOK_ASSIGN hname  */
#line 924 "gram.y"
                    {
			if (global.flags & GLOBAL_CHANGE_HOSTNAME) {
			    pmsprintf(mess, sizeof(mess), "Duplicate global hostname clause");
			    yyerror(mess);
			}
			if (inarch.label.hostname != NULL && strcmp(inarch.label.hostname, (yyvsp[0].str)) == 0) {
			    /* no change ... */
			    if (wflag) {
				pmsprintf(mess, sizeof(mess), "Global hostname (%s): No change", inarch.label.hostname);
				yywarn(mess);
			    }
			    free((yyvsp[0].str));
			}
			else {
			    global.hostname = (yyvsp[0].str);
			    global.flags |= GLOBAL_CHANGE_HOSTNAME;
			}
		    }
#line 2354 "gram.tab.c"
    break;

  case 15: /* globalopt: TOK_TIMEZONE TOK_ASSIGN TOK_STRING  */
#line 943 "gram.y"
                    {
			if (global.flags & GLOBAL_CHANGE_TIMEZONE) {
			    pmsprintf(mess, sizeof(mess), "Duplicate global timezone clause");
			    yyerror(mess);
			}
			if (inarch.label.timezone != NULL && strcmp(inarch.label.timezone, (yyvsp[0].str)) == 0) {
			    /* no change ... */
			    if (wflag) {
				pmsprintf(mess, sizeof(mess), "Global timezone (%s): No change", inarch.label.timezone);
				yywarn(mess);
			    }
			    free((yyvsp[0].str));
			}
			else {
			    global.timezone =  (yyvsp[0].str);
			    global.flags |= GLOBAL_CHANGE_TIMEZONE;
			}
		    }
#line 2377 "gram.tab.c"
    break;

  case 16: /* globalopt: TOK_ZONEINFO TOK_ASSIGN TOK_STRING  */
#line 962 "gram.y"
                    {
			if (global.flags & GLOBAL_CHANGE_ZONEINFO) {
			    pmsprintf(mess, sizeof(mess), "Duplicate global zoneinfo clause");
			    yyerror(mess);
			}
			if (outarch.version < PM_LOG_VERS03) {
			    pmsprintf(mess, sizeof(mess), "Global zoneinfo clause requires output archive version of 3 or greater");
			    yyerror(mess);
			}
			if (inarch.label.zoneinfo != NULL && strcmp(inarch.label.zoneinfo, (yyvsp[0].str)) == 0) {
			    /* no change ... */
			    if (wflag) {
				pmsprintf(mess, sizeof(mess), "Global zoneinfo (%s): No change", inarch.label.zoneinfo);
				yywarn(mess);
			    }
			    free((yyvsp[0].str));
			}
			else {
			    global.zoneinfo = (yyvsp[0].str);
			    global.flags |= GLOBAL_CHANGE_ZONEINFO;
			}
		    }
#line 2404 "gram.tab.c"
    break;

  case 17: /* globalopt: TOK_FEATURES TOK_ASSIGN feature_bits  */
#line 985 "gram.y"
                    {
			if (global.flags & GLOBAL_CHANGE_FEATURES) {
			    pmsprintf(mess, sizeof(mess), "Duplicate global features clause");
			    yyerror(mess);
			}
			if (outarch.version < PM_LOG_VERS03) {
			    pmsprintf(mess, sizeof(mess), "Global features clause requires output archive version of 3 or greater");
			    yyerror(mess);
			}
			if (inarch.label.features == (yyvsp[0].uival)) {
			    /* no change ... */
			    if (wflag) {
				pmsprintf(mess, sizeof(mess), "Global features (%d): No change", inarch.label.features);
				yywarn(mess);
			    }
			}
			else {
			    global.features = (yyvsp[0].uival);
			    global.flags |= GLOBAL_CHANGE_FEATURES;
			}
		    }
#line 2430 "gram.tab.c"
    break;

  case 18: /* globalopt: TOK_TIME TOK_ASSIGN signtime  */
#line 1007 "gram.y"
                    {
			if (global.flags & GLOBAL_CHANGE_TIME) {
			    pmsprintf(mess, sizeof(mess), "Duplicate global time clause");
			    yyerror(mess);
			}
			if (global.time.sec == 0 && global.time.nsec == 0) {
			    /* no change ... */
			    if (wflag) {
				pmsprintf(mess, sizeof(mess), "Global time: No change");
				yywarn(mess);
			    }
			}
			else
			    global.flags |= GLOBAL_CHANGE_TIME;
		    }
#line 2450 "gram.tab.c"
    break;

  case 19: /* globalopt: TOK_HOSTNAME TOK_ASSIGN  */
#line 1023 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting <hostname> in hostname clause");
			yyerror(mess);
		    }
#line 2459 "gram.tab.c"
    break;

  case 20: /* globalopt: TOK_HOSTNAME  */
#line 1028 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting -> in hostname clause");
			yyerror(mess);
		    }
#line 2468 "gram.tab.c"
    break;

  case 21: /* globalopt: TOK_TIMEZONE TOK_ASSIGN  */
#line 1033 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting <timezone_string> in timezone clause");
			yyerror(mess);
		    }
#line 2477 "gram.tab.c"
    break;

  case 22: /* globalopt: TOK_TIMEZONE  */
#line 1038 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting -> in timezone clause");
			yyerror(mess);
		    }
#line 2486 "gram.tab.c"
    break;

  case 23: /* globalopt: TOK_ZONEINFO TOK_ASSIGN  */
#line 1043 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting <zoneinfo_string> in zoneinfo clause");
			yyerror(mess);
		    }
#line 2495 "gram.tab.c"
    break;

  case 24: /* globalopt: TOK_ZONEINFO  */
#line 1048 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting -> in zoneinfo clause");
			yyerror(mess);
		    }
#line 2504 "gram.tab.c"
    break;

  case 25: /* globalopt: TOK_FEATURES TOK_ASSIGN  */
#line 1053 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting <features_value> in features clause");
			yyerror(mess);
		    }
#line 2513 "gram.tab.c"
    break;

  case 26: /* globalopt: TOK_FEATURES  */
#line 1058 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting -> in features clause");
			yyerror(mess);
		    }
#line 2522 "gram.tab.c"
    break;

  case 27: /* globalopt: TOK_TIME TOK_ASSIGN  */
#line 1063 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting <delta> of the form [+-][HH:[MM:]]SS[.d...] in time clause");
			yyerror(mess);
		    }
#line 2531 "gram.tab.c"
    break;

  case 28: /* globalopt: TOK_TIME  */
#line 1068 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting -> in time clause");
			yyerror(mess);
		    }
#line 2540 "gram.tab.c"
    break;

  case 29: /* feature_bits: TOK_NUMBER  */
#line 1075 "gram.y"
                    {
			char	*q;
			(yyval.uival) = (unsigned int)strtoul((yyvsp[0].str), &q, 10);
			free((yyvsp[0].str));
		    }
#line 2550 "gram.tab.c"
    break;

  case 30: /* feature_bits: TOK_BITS TOK_LPAREN bits_list TOK_RPAREN  */
#line 1081 "gram.y"
                    {
			(yyval.uival) = (yyvsp[-1].uival);
		    }
#line 2558 "gram.tab.c"
    break;

  case 31: /* feature_bits: TOK_BITS TOK_LPAREN bits_list  */
#line 1085 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting ) after \"bits(\" in features clause");
			yyerror(mess);
		    }
#line 2567 "gram.tab.c"
    break;

  case 32: /* feature_bits: TOK_BITS TOK_LPAREN  */
#line 1090 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting <list_of_bit_numbers> after \"bits(\" in features clause");
			yyerror(mess);
		    }
#line 2576 "gram.tab.c"
    break;

  case 33: /* feature_bits: TOK_BITS  */
#line 1095 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting ( after \"bits\" in features clause");
			yyerror(mess);
		    }
#line 2585 "gram.tab.c"
    break;

  case 34: /* bits_list: TOK_NUMBER  */
#line 1102 "gram.y"
                    {
			int	b;
			b = atoi((yyvsp[0].str));
			if (b < 0 || b > 31) {
			    pmsprintf(mess, sizeof(mess), "Bit \"%s\" not in the range 0..31", (yyvsp[0].str));
			    yyerror(mess);
			}
			(yyval.uival) = (unsigned int)1 << b;
			free((yyvsp[0].str));
		    }
#line 2600 "gram.tab.c"
    break;

  case 35: /* bits_list: bits_list TOK_COMMA TOK_NUMBER  */
#line 1113 "gram.y"
                    {
			int	b;
			b = atoi((yyvsp[0].str));
			if (b < 0 || b > 31) {
			    pmsprintf(mess, sizeof(mess), "Bit \"%s\" not in the range 0..31", (yyvsp[0].str));
			    yyerror(mess);
			}
			(yyval.uival) = (unsigned int)(yyvsp[-2].uival) | ((unsigned int)1 << b);
			free((yyvsp[0].str));
		    }
#line 2615 "gram.tab.c"
    break;

  case 41: /* signnumber: TOK_PLUS TOK_NUMBER  */
#line 1140 "gram.y"
                    {
			(yyval.ival) = atoi((yyvsp[0].str));
			free((yyvsp[0].str));
		    }
#line 2624 "gram.tab.c"
    break;

  case 42: /* signnumber: TOK_MINUS TOK_NUMBER  */
#line 1145 "gram.y"
                    {
			(yyval.ival) = -atoi((yyvsp[0].str));
			free((yyvsp[0].str));
		    }
#line 2633 "gram.tab.c"
    break;

  case 43: /* signnumber: TOK_NUMBER  */
#line 1150 "gram.y"
                    {
			(yyval.ival) = atoi((yyvsp[0].str));
			free((yyvsp[0].str));
		    }
#line 2642 "gram.tab.c"
    break;

  case 44: /* number: TOK_NUMBER  */
#line 1157 "gram.y"
                    {
			(yyval.ival) = atoi((yyvsp[0].str));
			free((yyvsp[0].str));
		    }
#line 2651 "gram.tab.c"
    break;

  case 45: /* float: TOK_FLOAT  */
#line 1164 "gram.y"
                    {
			(yyval.dval) = atof((yyvsp[0].str));
			free((yyvsp[0].str));
		    }
#line 2660 "gram.tab.c"
    break;

  case 47: /* signtime: TOK_MINUS time  */
#line 1171 "gram.y"
                                 { global.time.sec = -global.time.sec; }
#line 2666 "gram.tab.c"
    break;

  case 49: /* time: number TOK_COLON number TOK_COLON float  */
#line 1176 "gram.y"
                    { 
			if ((yyvsp[-2].ival) > 59) {
			    pmsprintf(mess, sizeof(mess), "Minutes (%d) in time clause more than 59", (yyvsp[-2].ival));
			    yywarn(mess);
			}
			if ((yyvsp[0].dval) > 59) {
			    pmsprintf(mess, sizeof(mess), "Seconds (%.6f) in time clause more than 59", (yyvsp[0].dval));
			    yywarn(mess);
			}
			global.time.sec = (yyvsp[-4].ival) * 3600 + (yyvsp[-2].ival) * 60 + (int)(yyvsp[0].dval);
			global.time.nsec = (int)(1000000000*(((yyvsp[0].dval) - (int)(yyvsp[0].dval)))+0.5);
		    }
#line 2683 "gram.tab.c"
    break;

  case 50: /* time: number TOK_COLON number TOK_COLON number  */
#line 1189 "gram.y"
                    { 
			if ((yyvsp[-2].ival) > 59) {
			    pmsprintf(mess, sizeof(mess), "Minutes (%d) in time clause more than 59", (yyvsp[-2].ival));
			    yywarn(mess);
			}
			if ((yyvsp[0].ival) > 59) {
			    pmsprintf(mess, sizeof(mess), "Seconds (%d) in time clause more than 59", (yyvsp[0].ival));
			    yywarn(mess);
			}
			global.time.sec = (yyvsp[-4].ival) * 3600 + (yyvsp[-2].ival) * 60 + (yyvsp[0].ival);
		    }
#line 2699 "gram.tab.c"
    break;

  case 51: /* time: number TOK_COLON float  */
#line 1201 "gram.y"
                    { 
			if ((yyvsp[-2].ival) > 59) {
			    pmsprintf(mess, sizeof(mess), "Minutes (%d) in time clause more than 59", (yyvsp[-2].ival));
			    yywarn(mess);
			}
			if ((yyvsp[0].dval) > 59) {
			    pmsprintf(mess, sizeof(mess), "Seconds (%.6f) in time clause more than 59", (yyvsp[0].dval));
			    yywarn(mess);
			}
			global.time.sec = (yyvsp[-2].ival) * 60 + (int)(yyvsp[0].dval);
			global.time.nsec = (int)(1000000000*(((yyvsp[0].dval) - (int)(yyvsp[0].dval)))+0.5);
		    }
#line 2716 "gram.tab.c"
    break;

  case 52: /* time: number TOK_COLON number  */
#line 1214 "gram.y"
                    { 
			if ((yyvsp[-2].ival) > 59) {
			    pmsprintf(mess, sizeof(mess), "Minutes (%d) in time clause more than 59", (yyvsp[-2].ival));
			    yywarn(mess);
			}
			if ((yyvsp[0].ival) > 59) {
			    pmsprintf(mess, sizeof(mess), "Seconds (%d) in time clause more than 59", (yyvsp[0].ival));
			    yywarn(mess);
			}
			global.time.sec = (yyvsp[-2].ival) * 60 + (yyvsp[0].ival);
		    }
#line 2732 "gram.tab.c"
    break;

  case 53: /* time: float  */
#line 1226 "gram.y"
                    {
			if ((yyvsp[0].dval) > 59) {
			    pmsprintf(mess, sizeof(mess), "Seconds (%.6f) in time clause more than 59", (yyvsp[0].dval));
			    yywarn(mess);
			}
			global.time.sec = (int)(yyvsp[0].dval);
			global.time.nsec = (int)(1000000000*(((yyvsp[0].dval) - (int)(yyvsp[0].dval)))+0.5);
		    }
#line 2745 "gram.tab.c"
    break;

  case 54: /* time: number  */
#line 1235 "gram.y"
                    {
			if ((yyvsp[0].ival) > 59) {
			    pmsprintf(mess, sizeof(mess), "Seconds (%d) in time clause more than 59", (yyvsp[0].ival));
			    yywarn(mess);
			}
			global.time.sec = (yyvsp[0].ival);
			global.time.nsec = 0;
		    }
#line 2758 "gram.tab.c"
    break;

  case 55: /* $@1: %empty  */
#line 1246 "gram.y"
                    {
			if (current_star_indom) {
			    __pmContext		*ctxp;
			    __pmHashCtl		*hcp;
			    __pmHashNode	*node;

			    ctxp = __pmHandleToPtr(pmWhichContext());
			    assert(ctxp != NULL);
    /*
     * Note: This application is single threaded, and once we have ctxp
     *	     the associated __pmContext will not move and will only be
     *	     accessed or modified synchronously either here or in libpcp.
     *	     We unlock the context so that it can be locked as required
     *	     within libpcp.
     */
			    PM_UNLOCK(ctxp->c_lock);
			    hcp = &ctxp->c_archctl->ac_log->hashindom;
			    star_domain = pmInDom_domain((yyvsp[0].indom));
			    for (node = __pmHashWalk(hcp, PM_HASH_WALK_START);
				 node != NULL;
				 node = __pmHashWalk(hcp, PM_HASH_WALK_NEXT)) {
				if (pmInDom_domain((pmInDom)(node->key)) == star_domain)
				    current_indomspec = start_indom((pmInDom)(node->key), 0);
			    }
			    do_walk_indom = 1;
			}
			else {
			    current_indomspec = start_indom((yyvsp[0].indom), 0);
			    do_walk_indom = 0;
			}
		    }
#line 2794 "gram.tab.c"
    break;

  case 57: /* indomspec: TOK_INDOM  */
#line 1279 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting <domain>.<serial> or <domain>.* in indom rule");
			yyerror(mess);
		    }
#line 2803 "gram.tab.c"
    break;

  case 58: /* indom_int: TOK_FLOAT  */
#line 1286 "gram.y"
                    {
			int		domain;
			int		serial;
			/* TOK_FLOAT => domain >= 0 && serial >= 0 after sscanf */
			sscanf((yyvsp[0].str), "%d.%d", &domain, &serial);
			if (domain >= DYNAMIC_PMID) {
			    pmsprintf(mess, sizeof(mess), "Illegal domain field (%d) for indom", domain);
			    yyerror(mess);
			}
			if (serial >= 4194304) {
			    pmsprintf(mess, sizeof(mess), "Illegal serial field (%d) for indom", serial);
			    yyerror(mess);
			}
			current_star_indom = 0;
			free((yyvsp[0].str));
			(yyval.indom) = pmInDom_build(domain, serial);
		    }
#line 2825 "gram.tab.c"
    break;

  case 59: /* indom_int: TOK_INDOM_STAR  */
#line 1304 "gram.y"
                    {
			int		domain;
			/* TOK_INDOM_STAR => domain >= 0 after sscanf */
			sscanf((yyvsp[0].str), "%d.", &domain);
			if (domain >= DYNAMIC_PMID) {
			    pmsprintf(mess, sizeof(mess), "Illegal domain field (%d) for indom", domain);
			    yyerror(mess);
			}
			current_star_indom = 1;
			free((yyvsp[0].str));
			(yyval.indom) = pmInDom_build(domain, 0);
		    }
#line 2842 "gram.tab.c"
    break;

  case 64: /* indomopt: TOK_INDOM TOK_ASSIGN duplicateopt indom_int  */
#line 1327 "gram.y"
                    {
			indomspec_t	*ip;
			for (ip = walk_indom(W_START); ip != NULL; ip = walk_indom(W_NEXT)) {
			    pmInDom	indom;
			    if (indom_root->new_indom != indom_root->old_indom) {
				pmsprintf(mess, sizeof(mess), "Duplicate indom clause for indom %s", pmInDomStr(indom_root->old_indom));
				yyerror(mess);
			    }
			    if (current_star_indom)
				indom = pmInDom_build(pmInDom_domain((yyvsp[0].indom)), pmInDom_serial(ip->old_indom));
			    else
				indom = (yyvsp[0].indom);
			    if (indom != ip->old_indom)
				ip->new_indom = indom;
			    else {
				/* no change ... */
				if (wflag) {
				    pmsprintf(mess, sizeof(mess), "Instance domain %s: indom: No change", pmInDomStr(ip->old_indom));
				    yywarn(mess);
				}
			    }
			    ip->indom_flags |= (yyvsp[-1].ival);
			}
		    }
#line 2871 "gram.tab.c"
    break;

  case 65: /* indomopt: TOK_INAME TOK_STRING TOK_ASSIGN TOK_STRING  */
#line 1352 "gram.y"
                    {
			indomspec_t	*ip;
			for (ip = walk_indom(W_START); ip != NULL; ip = walk_indom(W_NEXT)) {
			    if (change_inst_by_name(ip->old_indom, (yyvsp[-2].str), (yyvsp[0].str)) < 0)
				yyerror(mess);
			}
			free((yyvsp[-2].str));
			/* Note: $4 referenced from new_iname[] */
		    }
#line 2885 "gram.tab.c"
    break;

  case 66: /* indomopt: TOK_INAME TOK_STRING TOK_ASSIGN TOK_DELETE  */
#line 1362 "gram.y"
                    {
			indomspec_t	*ip;
			for (ip = walk_indom(W_START); ip != NULL; ip = walk_indom(W_NEXT)) {
			    if (change_inst_by_name(ip->old_indom, (yyvsp[-2].str), NULL) < 0)
			    	yyerror(mess);
			}
			free((yyvsp[-2].str));
		    }
#line 2898 "gram.tab.c"
    break;

  case 67: /* indomopt: TOK_INAME TOK_REDACT  */
#line 1371 "gram.y"
                    {
			indomspec_t	*ip;
			for (ip = walk_indom(W_START); ip != NULL; ip = walk_indom(W_NEXT)) {
			    if (redact_indom(ip->old_indom) < 0)
			    	yyerror(mess);
			}
		    }
#line 2910 "gram.tab.c"
    break;

  case 68: /* indomopt: TOK_INAME TOK_REPLACE pattern TOK_ASSIGN replacement  */
#line 1379 "gram.y"
                    {
			int		sts;
			indomspec_t	*ip;
			value_change_t	vc;
			vc.pat = (yyvsp[-2].str);
			if (pmDebugOptions.appl5)
			    fprintf(stderr, "compiling iname regex /%s/\n", vc.pat);
			if ((sts = regcomp(&vc.regex, vc.pat, REG_EXTENDED)) != 0) {
			    size_t	pfx;
			    pmstrncat(mess, sizeof(mess), "regcomp error: ");
			    pfx = strlen(mess);
			    regerror(sts, &vc.regex, &mess[pfx], sizeof(mess)-pfx-1);
			    yyerror(mess);
			}
			vc.replace = (yyvsp[0].str);
			for (ip = walk_indom(W_START); ip != NULL; ip = walk_indom(W_NEXT)) {
			    if (replace_indom(ip->old_indom, &vc) < 0) {
				/* mess[] set in replace_indom() for errors */
			    	yyerror(mess);
			    }
			}
			regfree(&vc.regex);
			free((yyvsp[-2].str));
			free((yyvsp[0].str));
		    }
#line 2940 "gram.tab.c"
    break;

  case 69: /* indomopt: TOK_INST number TOK_ASSIGN number  */
#line 1405 "gram.y"
                    {
			indomspec_t	*ip;
			for (ip = walk_indom(W_START); ip != NULL; ip = walk_indom(W_NEXT)) {
			    if (change_inst_by_inst(ip->old_indom, (yyvsp[-2].ival), (yyvsp[0].ival)) < 0)
				yyerror(mess);
			}
		    }
#line 2952 "gram.tab.c"
    break;

  case 70: /* indomopt: TOK_INST number TOK_ASSIGN TOK_DELETE  */
#line 1413 "gram.y"
                    {
			indomspec_t	*ip;
			for (ip = walk_indom(W_START); ip != NULL; ip = walk_indom(W_NEXT)) {
			    if (change_inst_by_inst(ip->old_indom, (yyvsp[-2].ival), PM_IN_NULL) < 0)
				yyerror(mess);
			}
		    }
#line 2964 "gram.tab.c"
    break;

  case 71: /* indomopt: TOK_INDOM TOK_ASSIGN  */
#line 1421 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting <domain>.<serial> or <domain>.* in indom clause");
			yyerror(mess);
		    }
#line 2973 "gram.tab.c"
    break;

  case 72: /* indomopt: TOK_INDOM  */
#line 1426 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting -> in indom clause");
			yyerror(mess);
		    }
#line 2982 "gram.tab.c"
    break;

  case 73: /* indomopt: TOK_INAME TOK_STRING TOK_ASSIGN  */
#line 1431 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting new <external_instance_name> or DELETE in iname clause");
			yyerror(mess);
		    }
#line 2991 "gram.tab.c"
    break;

  case 74: /* indomopt: TOK_INAME TOK_STRING  */
#line 1436 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting -> in iname clause");
			yyerror(mess);
		    }
#line 3000 "gram.tab.c"
    break;

  case 75: /* indomopt: TOK_INAME  */
#line 1441 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting old <external_instance_name> or REDACT or REPLACE in iname clause");
			yyerror(mess);
		    }
#line 3009 "gram.tab.c"
    break;

  case 76: /* indomopt: TOK_INST number TOK_ASSIGN  */
#line 1446 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting new <internal_instance_identifier> or DELETE in inst clause");
			yyerror(mess);
		    }
#line 3018 "gram.tab.c"
    break;

  case 77: /* indomopt: TOK_INST number  */
#line 1451 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting -> in inst clause");
			yyerror(mess);
		    }
#line 3027 "gram.tab.c"
    break;

  case 78: /* indomopt: TOK_INST  */
#line 1456 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting old <internal_instance_identifier> in inst clause");
			yyerror(mess);
		    }
#line 3036 "gram.tab.c"
    break;

  case 79: /* indomopt: TOK_INAME TOK_REPLACE pattern TOK_ASSIGN  */
#line 1461 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting <replacement> in iname clause");
			yyerror(mess);
		    }
#line 3045 "gram.tab.c"
    break;

  case 80: /* indomopt: TOK_INAME TOK_REPLACE pattern  */
#line 1466 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting -> in iname clause");
			yyerror(mess);
		    }
#line 3054 "gram.tab.c"
    break;

  case 81: /* indomopt: TOK_INAME TOK_REPLACE  */
#line 1471 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting <regular expression> in iname clause");
			yyerror(mess);
		    }
#line 3063 "gram.tab.c"
    break;

  case 82: /* duplicateopt: TOK_DUPLICATE  */
#line 1478 "gram.y"
                                        { (yyval.ival) = INDOM_DUPLICATE; }
#line 3069 "gram.tab.c"
    break;

  case 83: /* duplicateopt: %empty  */
#line 1479 "gram.y"
                                        { (yyval.ival) = 0; }
#line 3075 "gram.tab.c"
    break;

  case 84: /* $@2: %empty  */
#line 1483 "gram.y"
                    {
			if (current_star_metric) {
			    __pmContext		*ctxp;
			    __pmHashCtl		*hcp;
			    __pmHashNode	*node;

			    ctxp = __pmHandleToPtr(pmWhichContext());
			    assert(ctxp != NULL);
    /*
     * Note: This application is single threaded, and once we have ctxp
     *	     the associated __pmContext will not move and will only be
     *	     accessed or modified synchronously either here or in libpcp.
     *	     We unlock the context so that it can be locked as required
     *	     within libpcp.
     */
			    PM_UNLOCK(ctxp->c_lock);
			    hcp = &ctxp->c_archctl->ac_log->hashpmid;
			    star_domain = pmID_domain((yyvsp[0].pmid));
			    if (current_star_metric == 1)
				star_cluster = pmID_cluster((yyvsp[0].pmid));
			    else
				star_cluster = PM_ID_NULL;
			    for (node = __pmHashWalk(hcp, PM_HASH_WALK_START);
				 node != NULL;
				 node = __pmHashWalk(hcp, PM_HASH_WALK_NEXT)) {
				if (pmID_domain((pmID)(node->key)) == star_domain &&
				    (star_cluster == PM_ID_NULL ||
				     star_cluster == pmID_cluster((pmID)(node->key))))
				    current_metricspec = start_metric((pmID)(node->key));
			    }
			    do_walk_metric = 1;
			}
			else {
			    if ((yyvsp[0].pmid) == PM_ID_NULL)
				/* metric not in archive */
				current_metricspec = NULL;
			    else
				current_metricspec = start_metric((yyvsp[0].pmid));
			    do_walk_metric = 0;
			}
		    }
#line 3121 "gram.tab.c"
    break;

  case 86: /* metricspec: TOK_METRIC  */
#line 1526 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting <metric_name> or <domain>.<cluster>.<item> or <domain>.<cluster>.* or <domain>.*.* in metric rule");
			yyerror(mess);
		    }
#line 3130 "gram.tab.c"
    break;

  case 88: /* pmid_or_name: TOK_GNAME  */
#line 1534 "gram.y"
                    {
			int	sts;
			pmID	pmid;
			sts = pmLookupName(1, (const char **)&(yyvsp[0].str), &pmid);
			if (sts < 0) {
			    if (wflag) {
				pmsprintf(mess, sizeof(mess), "Metric: %s: %s", (yyvsp[0].str), pmErrStr(sts));
				yywarn(mess);
			    }
			    pmid = PM_ID_NULL;
			}
			current_star_metric = 0;
			free((yyvsp[0].str));
			(yyval.pmid) = pmid;
		    }
#line 3150 "gram.tab.c"
    break;

  case 89: /* pmid_int: TOK_PMID_INT  */
#line 1552 "gram.y"
                    {
			int	domain;
			int	cluster;
			int	item;
			/* TOK_PMID_INT => domain >= 0 && cluster >=0 && item >= 0 after sscanf */
			sscanf((yyvsp[0].str), "%d.%d.%d", &domain, &cluster, &item);
			if (domain > DYNAMIC_PMID) {
			    pmsprintf(mess, sizeof(mess), "Illegal domain field (%d) for pmid", domain);
			    yyerror(mess);
			}
			else if (domain == DYNAMIC_PMID) {
			    pmsprintf(mess, sizeof(mess), "Dynamic metric domain field (%d) for pmid", domain);
			    yywarn(mess);
			}
			if (cluster >= 4096) {
			    pmsprintf(mess, sizeof(mess), "Illegal cluster field (%d) for pmid", cluster);
			    yyerror(mess);
			}
			if (item >= 1024) {
			    pmsprintf(mess, sizeof(mess), "Illegal item field (%d) for pmid", item);
			    yyerror(mess);
			}
			current_star_metric = 0;
			free((yyvsp[0].str));
			(yyval.pmid) = pmID_build(domain, cluster, item);
		    }
#line 3181 "gram.tab.c"
    break;

  case 90: /* pmid_int: TOK_PMID_STAR  */
#line 1579 "gram.y"
                    {
			int	domain;
			int	cluster;
			int	sts;
			/*
			 * TOK_PMID_STAR matches <n>.<n>.* or <n>.*.*
			 * => domain >= 0, but cluster may be undefined after sscanf
			 */
			sts = sscanf((yyvsp[0].str), "%d.%d.", &domain, &cluster);
			if (domain > DYNAMIC_PMID) {
			    pmsprintf(mess, sizeof(mess), "Illegal domain field (%d) for pmid", domain);
			    yyerror(mess);
			}
			else if (domain == DYNAMIC_PMID) {
			    pmsprintf(mess, sizeof(mess), "Dynamic metric domain field (%d) for pmid", domain);
			    yywarn(mess);
			}
			if (sts == 2) {
			    /* cluster is <n> */
			    if (cluster >= 4096) {
				pmsprintf(mess, sizeof(mess), "Illegal cluster field (%d) for pmid", cluster);
				yyerror(mess);
			    }
			    current_star_metric = 1;
			}
			else {
			    /* cluster is "*" */
			    cluster = 0;
			    current_star_metric = 2;
			}
			free((yyvsp[0].str));
			(yyval.pmid) = pmID_build(domain, cluster, 0);
		    }
#line 3219 "gram.tab.c"
    break;

  case 95: /* metricopt: TOK_PMID TOK_ASSIGN pmid_int  */
#line 1623 "gram.y"
                    {
			metricspec_t	*mp;
			pmID		pmid;
			for (mp = walk_metric(W_START, METRIC_CHANGE_PMID, "pmid", 0); mp != NULL; mp = walk_metric(W_NEXT, METRIC_CHANGE_PMID, "pmid", 0)) {
			    if (current_star_metric == 1)
				pmid = pmID_build(pmID_domain((yyvsp[0].pmid)), pmID_cluster((yyvsp[0].pmid)), pmID_item(mp->old_desc.pmid));
			    else if (current_star_metric == 2)
				pmid = pmID_build(pmID_domain((yyvsp[0].pmid)), pmID_cluster(mp->old_desc.pmid), pmID_item(mp->old_desc.pmid));
			    else
				pmid = (yyvsp[0].pmid);
			    if (pmid == mp->old_desc.pmid) {
				/* no change ... */
				if (wflag) {
				    pmsprintf(mess, sizeof(mess), "Metric: %s (%s): pmid: No change", mp->old_name, pmIDStr(mp->old_desc.pmid));
				    yywarn(mess);
				}
			    }
			    else {
				mp->new_desc.pmid = pmid;
				mp->flags |= METRIC_CHANGE_PMID;
			    }
			}
		    }
#line 3247 "gram.tab.c"
    break;

  case 96: /* metricopt: TOK_NAME TOK_ASSIGN TOK_GNAME  */
#line 1647 "gram.y"
                    {
			metricspec_t	*mp;
			int		picked = 0;
			for (mp = walk_metric(W_START, METRIC_CHANGE_NAME, "name", 0); mp != NULL; mp = walk_metric(W_NEXT, METRIC_CHANGE_NAME, "name", 0)) {
			    if (strcmp((yyvsp[0].str), mp->old_name) == 0) {
				/* no change ... */
				if (wflag) {
				    pmsprintf(mess, sizeof(mess), "Metric: %s (%s): name: No change", mp->old_name, pmIDStr(mp->old_desc.pmid));
				    yywarn(mess);
				}
			    }
			    else {
				int	sts;
				pmID	pmid;
				sts = pmLookupName(1, (const char **)&(yyvsp[0].str), &pmid);
				if (sts >= 0) {
				    pmsprintf(mess, sizeof(mess), "Metric name %s already assigned for PMID %s", (yyvsp[0].str), pmIDStr(pmid));
				    yyerror(mess);
				}
				mp->new_name = (yyvsp[0].str);
				mp->flags |= METRIC_CHANGE_NAME;
				picked = 1;
			    }
			}
			if (!picked)
			    free((yyvsp[0].str));
		    }
#line 3279 "gram.tab.c"
    break;

  case 97: /* metricopt: TOK_TYPE TOK_ASSIGN TOK_TYPE_NAME  */
#line 1675 "gram.y"
                    {
			metricspec_t	*mp;
			for (mp = walk_metric(W_START, METRIC_CHANGE_TYPE, "type", 0); mp != NULL; mp = walk_metric(W_NEXT, METRIC_CHANGE_TYPE, "type", 0)) {
			    if ((yyvsp[0].ival) == mp->old_desc.type) {
				/* old == new, so no change ... */
				if (wflag) {
				    pmsprintf(mess, sizeof(mess), "Metric: %s (%s): type: PM_TYPE_%s: No change", mp->old_name, pmIDStr(mp->old_desc.pmid), pmTypeStr(mp->old_desc.type));
				    yywarn(mess);
				}
			    }
			    else {
				if (mp->old_desc.type == PM_TYPE_32 ||
				    mp->old_desc.type == PM_TYPE_U32 ||
				    mp->old_desc.type == PM_TYPE_64 ||
				    mp->old_desc.type == PM_TYPE_U64 ||
				    mp->old_desc.type == PM_TYPE_FLOAT ||
				    mp->old_desc.type == PM_TYPE_DOUBLE) {
				    mp->new_desc.type = (yyvsp[0].ival);
				    mp->flags |= METRIC_CHANGE_TYPE;
				}
				else {
				    pmsprintf(mess, sizeof(mess), "Old type (PM_TYPE_%s) must be numeric", pmTypeStr(mp->old_desc.type));
				    yyerror(mess);
				}
			    }
			}
		    }
#line 3311 "gram.tab.c"
    break;

  case 98: /* metricopt: TOK_TYPE TOK_IF TOK_TYPE_NAME TOK_ASSIGN TOK_TYPE_NAME  */
#line 1703 "gram.y"
                    {
			metricspec_t	*mp;
			for (mp = walk_metric(W_START, METRIC_CHANGE_TYPE, "type", 1); mp != NULL; mp = walk_metric(W_NEXT, METRIC_CHANGE_TYPE, "type", 1)) {
			    if (mp->old_desc.type != (yyvsp[-2].ival)) {
				if (wflag) {
				    char	tbuf0[20];
				    char	tbuf1[20];
				    pmTypeStr_r(mp->old_desc.type, tbuf0, sizeof(tbuf0));
				    pmTypeStr_r((yyvsp[0].ival), tbuf1, sizeof(tbuf1));
				    pmsprintf(mess, sizeof(mess), "Metric: %s (%s): type: PM_TYPE_%s: No conditional change to PM_TYPE_%s", mp->old_name, pmIDStr(mp->old_desc.pmid), tbuf0, tbuf1);
				    yywarn(mess);
				}
			    }
			    else {
				if (mp->old_desc.type == PM_TYPE_32 ||
				    mp->old_desc.type == PM_TYPE_U32 ||
				    mp->old_desc.type == PM_TYPE_64 ||
				    mp->old_desc.type == PM_TYPE_U64 ||
				    mp->old_desc.type == PM_TYPE_FLOAT ||
				    mp->old_desc.type == PM_TYPE_DOUBLE) {
				    mp->new_desc.type = (yyvsp[0].ival);
				    mp->flags |= METRIC_CHANGE_TYPE;
				}
				else {
				    pmsprintf(mess, sizeof(mess), "Old type (PM_TYPE_%s) must be numeric", pmTypeStr(mp->old_desc.type));
				    yyerror(mess);
				}
			    }
			}
		    }
#line 3346 "gram.tab.c"
    break;

  case 99: /* metricopt: TOK_INDOM TOK_ASSIGN null_or_indom pick  */
#line 1734 "gram.y"
                    {
			metricspec_t	*mp;
			pmInDom		indom;
			for (mp = walk_metric(W_START, METRIC_CHANGE_INDOM, "indom", 0); mp != NULL; mp = walk_metric(W_NEXT, METRIC_CHANGE_INDOM, "indom", 0)) {
			    if (current_star_indom)
				indom = pmInDom_build(pmInDom_domain((yyvsp[-1].indom)), pmInDom_serial(mp->old_desc.indom));
			    else
				indom = (yyvsp[-1].indom);
			    if (indom == mp->old_desc.indom) {
				/* no change ... */
				if (wflag) {
				    pmsprintf(mess, sizeof(mess), "Metric: %s (%s): indom: %s: No change", mp->old_name, pmIDStr(mp->old_desc.pmid), pmInDomStr(mp->old_desc.indom));
				    yywarn(mess);
				}
			    }
			    else {
				if ((output == OUTPUT_MIN ||
					  output == OUTPUT_MAX ||
					  output == OUTPUT_SUM ||
					  output == OUTPUT_AVG) &&
					 mp->old_desc.type != PM_TYPE_32 &&
					 mp->old_desc.type != PM_TYPE_U32 &&
					 mp->old_desc.type != PM_TYPE_64 &&
					 mp->old_desc.type != PM_TYPE_U64 &&
					 mp->old_desc.type != PM_TYPE_FLOAT &&
					 mp->old_desc.type != PM_TYPE_DOUBLE) {
				    pmsprintf(mess, sizeof(mess), "OUTPUT option MIN, MAX, AVG or SUM requires type to be numeric, not PM_TYPE_%s", pmTypeStr(mp->old_desc.type));
				    yyerror(mess);
				}
				mp->new_desc.indom = indom;
				mp->flags |= METRIC_CHANGE_INDOM;
				mp->output = output;
				if (output == OUTPUT_ONE) {
				    mp->one_name = one_name;
				    mp->one_inst = one_inst;
				    if (mp->old_desc.indom == PM_INDOM_NULL)
					/*
					 * singular input, pick first (only)
					 * value, not one_inst matching ...
					 * one_inst used for output instance
					 * id
					 */
					mp->output = OUTPUT_FIRST;
				}
				if (output == OUTPUT_ALL) {
				    /*
				     * No OUTPUT clause, set up the defaults
				     * based on indom types:
				     * non-NULL -> NULL
				     *		OUTPUT_FIRST, inst PM_IN_NULL
				     * NULL -> non-NULL
				     *		OUTPUT_FIRST, inst 0
				     * non-NULL -> non-NULL
				     * 		all instances selected
				     *		(nothing to do for defaults)
				     * NULL -> NULL
				     *		caught above in no change case
				     */
				    if (mp->old_desc.indom != PM_INDOM_NULL &&
				        mp->new_desc.indom == PM_INDOM_NULL) {
					mp->output = OUTPUT_FIRST;
					mp->one_inst = PM_IN_NULL;
				    }
				    else if (mp->old_desc.indom == PM_INDOM_NULL &&
				             mp->new_desc.indom != PM_INDOM_NULL) {
					mp->output = OUTPUT_FIRST;
					mp->one_inst = 0;
				    }
				}
			    }
			}
			output = OUTPUT_ALL;	/* for next time */
		    }
#line 3424 "gram.tab.c"
    break;

  case 100: /* metricopt: TOK_SEM TOK_ASSIGN TOK_SEM_NAME  */
#line 1808 "gram.y"
                    {
			metricspec_t	*mp;
			for (mp = walk_metric(W_START, METRIC_CHANGE_SEM, "sem", 0); mp != NULL; mp = walk_metric(W_NEXT, METRIC_CHANGE_SEM, "sem", 0)) {
			    if ((yyvsp[0].ival) == mp->old_desc.sem) {
				/* no change ... */
				if (wflag) {
				    pmsprintf(mess, sizeof(mess), "Metric: %s (%s): sem: %s: No change", mp->old_name, pmIDStr(mp->old_desc.pmid), SemStr(mp->old_desc.sem));
				    yywarn(mess);
				}
			    }
			    else {
				mp->new_desc.sem = (yyvsp[0].ival);
				mp->flags |= METRIC_CHANGE_SEM;
			    }
			}
		    }
#line 3445 "gram.tab.c"
    break;

  case 101: /* metricopt: TOK_UNITS TOK_ASSIGN signnumber TOK_COMMA signnumber TOK_COMMA signnumber TOK_COMMA TOK_SPACE_NAME TOK_COMMA TOK_TIME_NAME TOK_COMMA TOK_COUNT_NAME rescaleopt  */
#line 1825 "gram.y"
                    {
			metricspec_t	*mp;
			for (mp = walk_metric(W_START, METRIC_CHANGE_UNITS, "units", 0); mp != NULL; mp = walk_metric(W_NEXT, METRIC_CHANGE_UNITS, "units", 0)) {
			    if ((yyvsp[-11].ival) == mp->old_desc.units.dimSpace &&
			        (yyvsp[-9].ival) == mp->old_desc.units.dimTime &&
			        (yyvsp[-7].ival) == mp->old_desc.units.dimCount &&
			        (yyvsp[-5].ival) == mp->old_desc.units.scaleSpace &&
			        (yyvsp[-3].ival) == mp->old_desc.units.scaleTime &&
			        (yyvsp[-1].ival) == mp->old_desc.units.scaleCount) {
				/* no change ... */
				if (wflag) {
				    pmsprintf(mess, sizeof(mess), "Metric: %s (%s): units: %s: No change", mp->old_name, pmIDStr(mp->old_desc.pmid), pmUnitsStr(&mp->old_desc.units));
				    yywarn(mess);
				}
			    }
			    else {
				mp->new_desc.units.dimSpace = (yyvsp[-11].ival);
				mp->new_desc.units.dimTime = (yyvsp[-9].ival);
				mp->new_desc.units.dimCount = (yyvsp[-7].ival);
				mp->new_desc.units.scaleSpace = (yyvsp[-5].ival);
				mp->new_desc.units.scaleTime = (yyvsp[-3].ival);
				mp->new_desc.units.scaleCount = (yyvsp[-1].ival);
				mp->flags |= METRIC_CHANGE_UNITS;
				if ((yyvsp[0].ival) == 1) {
				    if ((yyvsp[-11].ival) == mp->old_desc.units.dimSpace &&
					(yyvsp[-9].ival) == mp->old_desc.units.dimTime &&
					(yyvsp[-7].ival) == mp->old_desc.units.dimCount)
					/* OK, no dim changes */
					mp->flags |= METRIC_RESCALE;
				    else {
					if (wflag) {
					    pmsprintf(mess, sizeof(mess), "Metric: %s (%s): Dimension changed, cannot rescale", mp->old_name, pmIDStr(mp->old_desc.pmid));
					    yywarn(mess);
					}
				    }
				}
				else if (sflag) {
				    if ((yyvsp[-11].ival) == mp->old_desc.units.dimSpace &&
					(yyvsp[-9].ival) == mp->old_desc.units.dimTime &&
					(yyvsp[-7].ival) == mp->old_desc.units.dimCount)
					mp->flags |= METRIC_RESCALE;
				}
			    }
			}
		    }
#line 3495 "gram.tab.c"
    break;

  case 102: /* metricopt: TOK_METRIC_VALUE optreplace pattern TOK_ASSIGN replacement  */
#line 1871 "gram.y"
                    {
			metricspec_t	*mp;
			for (mp = walk_metric(W_START, METRIC_CHANGE_VALUE, "value", 1); mp != NULL; mp = walk_metric(W_NEXT, METRIC_CHANGE_VALUE, "value", 1)) {
			    value_change_t	*vc_tmp;
			    value_change_t	*vcp;
			    int			sts;

			    if (mp->old_desc.type != PM_TYPE_STRING) {
				pmsprintf(mess, sizeof(mess), "Metric: %s (%s): Type %s not STRING, cannot change value", mp->old_name, pmIDStr(mp->old_desc.pmid), pmTypeStr(mp->old_desc.type));
				free((yyvsp[-2].str));
				free((yyvsp[0].str));
				yywarn(mess);
				continue;
			    }
			    mp->flags |= METRIC_CHANGE_VALUE;
			    mp->nvc++;
			    vc_tmp = (value_change_t *)realloc(mp->vc, mp->nvc * sizeof(value_change_t));
			    if (vc_tmp == NULL) {
				pmsprintf(mess, sizeof(mess), "value_change realloc(%d) failed: %s\n", (int)(mp->nvc * sizeof(value_change_t)), strerror(errno));
				yyerror(mess);
			    }
			    else
				mp->vc = vc_tmp;
			    vcp = &mp->vc[mp->nvc-1];
			    vcp->pat = (yyvsp[-2].str);
			    vcp->replace = (yyvsp[0].str);
			    if (pmDebugOptions.appl5)
				fprintf(stderr, "compiling value regex /%s/\n", vcp->pat);
			    if ((sts = regcomp(&vcp->regex, vcp->pat, REG_EXTENDED)) != 0) {
				size_t	pfx;
				pmstrncat(mess, sizeof(mess), "regcomp error: ");
				pfx = strlen(mess);
				regerror(sts, &vcp->regex, &mess[pfx], sizeof(mess)-pfx-1);
				yyerror(mess);
			    }
			}
		    }
#line 3537 "gram.tab.c"
    break;

  case 103: /* metricopt: TOK_DELETE  */
#line 1909 "gram.y"
                    {
			metricspec_t	*mp;
			for (mp = walk_metric(W_START, METRIC_DELETE, "delete", 1); mp != NULL; mp = walk_metric(W_NEXT, METRIC_DELETE, "delete", 0)) {
			    mp->flags |= METRIC_DELETE;
			}
		    }
#line 3548 "gram.tab.c"
    break;

  case 104: /* metricopt: TOK_PMID TOK_ASSIGN  */
#line 1916 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting <domain>.<cluster>.<item> or <domain>.<cluster>.* or <domain>.*.* in pmid clause");
			yyerror(mess);
		    }
#line 3557 "gram.tab.c"
    break;

  case 105: /* metricopt: TOK_NAME TOK_ASSIGN  */
#line 1921 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting <metric_name> in iname clause");
			yyerror(mess);
		    }
#line 3566 "gram.tab.c"
    break;

  case 106: /* metricopt: TOK_TYPE TOK_ASSIGN  */
#line 1926 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting XXX (from PM_TYPE_XXX) in type clause");
			yyerror(mess);
		    }
#line 3575 "gram.tab.c"
    break;

  case 107: /* metricopt: TOK_TYPE TOK_IF  */
#line 1931 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting XXX (from PM_TYPE_XXX) after if in type clause");
			yyerror(mess);
		    }
#line 3584 "gram.tab.c"
    break;

  case 108: /* metricopt: TOK_TYPE TOK_IF TOK_TYPE_NAME TOK_ASSIGN  */
#line 1936 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting XXX (from PM_TYPE_XXX) in type clause");
			yyerror(mess);
		    }
#line 3593 "gram.tab.c"
    break;

  case 109: /* metricopt: TOK_INDOM TOK_ASSIGN  */
#line 1941 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting <domain>.<serial> or NULL in indom clause");
			yyerror(mess);
		    }
#line 3602 "gram.tab.c"
    break;

  case 110: /* metricopt: TOK_SEM TOK_ASSIGN  */
#line 1946 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting XXX (from PM_SEM_XXX) in sem clause");
			yyerror(mess);
		    }
#line 3611 "gram.tab.c"
    break;

  case 111: /* metricopt: TOK_UNITS TOK_ASSIGN  */
#line 1951 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting 3 numeric values for dim* fields of units");
			yyerror(mess);
		    }
#line 3620 "gram.tab.c"
    break;

  case 112: /* metricopt: TOK_UNITS TOK_ASSIGN signnumber TOK_COMMA signnumber TOK_COMMA signnumber TOK_COMMA  */
#line 1956 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting 0 or XXX (from PM_SPACE_XXX) for scaleSpace field of units");
			yyerror(mess);
		    }
#line 3629 "gram.tab.c"
    break;

  case 113: /* metricopt: TOK_UNITS TOK_ASSIGN signnumber TOK_COMMA signnumber TOK_COMMA signnumber TOK_COMMA TOK_SPACE_NAME TOK_COMMA  */
#line 1961 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting 0 or XXX (from PM_TIME_XXX) for scaleTime field of units");
			yyerror(mess);
		    }
#line 3638 "gram.tab.c"
    break;

  case 114: /* metricopt: TOK_UNITS TOK_ASSIGN signnumber TOK_COMMA signnumber TOK_COMMA signnumber TOK_COMMA TOK_SPACE_NAME TOK_COMMA TOK_TIME_NAME TOK_COMMA  */
#line 1966 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting 0 or ONE for scaleCount field of units");
			yyerror(mess);
		    }
#line 3647 "gram.tab.c"
    break;

  case 115: /* metricopt: TOK_METRIC_VALUE optreplace pattern TOK_ASSIGN  */
#line 1971 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting <replacement> in metric value clause");
			yyerror(mess);
		    }
#line 3656 "gram.tab.c"
    break;

  case 116: /* metricopt: TOK_METRIC_VALUE optreplace pattern  */
#line 1976 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting -> in metric value clause");
			yyerror(mess);
		    }
#line 3665 "gram.tab.c"
    break;

  case 117: /* metricopt: TOK_METRIC_VALUE optreplace  */
#line 1981 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting <regular expression> in metric value clause");
			yyerror(mess);
		    }
#line 3674 "gram.tab.c"
    break;

  case 121: /* null_or_indom: TOK_NULL_INT  */
#line 1993 "gram.y"
                    {
			(yyval.indom) = PM_INDOM_NULL;
		    }
#line 3682 "gram.tab.c"
    break;

  case 122: /* pick: TOK_OUTPUT TOK_INST number  */
#line 1999 "gram.y"
                    {
			output = OUTPUT_ONE;
			one_inst = (yyvsp[0].ival);
			one_name = NULL;
		    }
#line 3692 "gram.tab.c"
    break;

  case 123: /* pick: TOK_OUTPUT TOK_INAME TOK_STRING  */
#line 2005 "gram.y"
                    {
			output = OUTPUT_ONE;
			one_inst = PM_IN_NULL;
			one_name = (yyvsp[0].str);
		    }
#line 3702 "gram.tab.c"
    break;

  case 124: /* pick: TOK_OUTPUT TOK_OUTPUT_TYPE  */
#line 2011 "gram.y"
                    {
			output = (yyvsp[0].ival);
		    }
#line 3710 "gram.tab.c"
    break;

  case 125: /* pick: TOK_OUTPUT  */
#line 2015 "gram.y"
                    {
			pmsprintf(mess, sizeof(mess), "Expecting FIRST or LAST or INST or INAME or MIN or MAX or AVG for OUTPUT instance option");
			yyerror(mess);
		    }
#line 3719 "gram.tab.c"
    break;

  case 127: /* rescaleopt: TOK_RESCALE  */
#line 2022 "gram.y"
                              { (yyval.ival) = 1; }
#line 3725 "gram.tab.c"
    break;

  case 128: /* rescaleopt: %empty  */
#line 2024 "gram.y"
                    { (yyval.ival) = 0; }
#line 3731 "gram.tab.c"
    break;

  case 132: /* $@3: %empty  */
#line 2035 "gram.y"
                    {
			__pmContext	*ctxp;
			__pmHashCtl	*hcp1;
			__pmHashNode	*node1;
			int		target_types;
			int		this_type;
			int		type;

			ctxp = __pmHandleToPtr(pmWhichContext());
			assert(ctxp != NULL);
    /*
     * Note: This application is single threaded, and once we have ctxp,
     *	     the associated __pmContext will not move and will only be
     *	     accessed or modified synchronously either here or in libpcp.
     *	     We unlock the context so that it can be locked as required
     *	     within libpcp.
     */
			PM_UNLOCK(ctxp->c_lock);
			
			current_textspec = NULL;
			if ((yyvsp[-2].pmid) == PM_ID_NULL) {
			    /* Metric referenced by name is not in the archive */
			    do_walk_text = 0;
			}
			else {
			    int found = 0;
			    
			    if (current_star_metric) {
				/* Set up for metrics specified using globbing. */
				star_domain = pmID_domain((yyvsp[-2].pmid));
				if (current_star_metric == 1)
				    star_cluster = pmID_cluster((yyvsp[-2].pmid));
				else
				    star_cluster = PM_ID_NULL;
			    }

			    /* We're looking for text of the specified type(s) for metric(s). */
			    target_types = PM_TEXT_PMID | (yyvsp[-1].ival);
			    hcp1 = &ctxp->c_archctl->ac_log->hashtext;
			    for (node1 = __pmHashWalk(hcp1, PM_HASH_WALK_START);
				 node1 != NULL;
				 node1 = __pmHashWalk(hcp1, PM_HASH_WALK_NEXT)) {
				__pmHashCtl	*hcp2;
				__pmHashNode	*node2;

				/* Was this object type selected? */
				this_type = (int)(node1->key);
				if ((this_type & target_types) != this_type)
				    continue;

				/*
				 * Collect the text records associated with the specified
				 * metric(s).
				 */
				hcp2 = (__pmHashCtl *)(node1->data);
				for (node2 = __pmHashWalk(hcp2, PM_HASH_WALK_START);
				     node2 != NULL;
				     node2 = __pmHashWalk(hcp2, PM_HASH_WALK_NEXT)) {
				    if (current_star_metric) {
					/* Match the globbed metric spec and keep looking. */
					if (pmID_domain((pmID)(node2->key)) == star_domain &&
					    (star_cluster == PM_ID_NULL ||
					     star_cluster == pmID_cluster((pmID)(node2->key)))) {
					    current_textspec = start_text(this_type, (pmID)(node2->key), (yyvsp[0].str));
					    if (current_textspec) {
						current_textspec->flags |= TEXT_ACTIVE;
						++found;
					    }

					}
				    }
				    else {
					/* Match the exact metric PMID. */
					if ((pmID)(node2->key) == (yyvsp[-2].pmid)) {
					    current_textspec = start_text(this_type, (pmID)(node2->key), (yyvsp[0].str));
					    if (current_textspec) {
						current_textspec->flags |= TEXT_ACTIVE;
						++found;
					    }
					    /*
					     * Stop looking if we have found all of the specified
					     * types.
					     */
					    type = this_type & PM_TEXT_TYPE_MASK;
					    target_types ^= type;
					    if ((target_types & PM_TEXT_TYPE_MASK) == 0)
						break;
					}
				    }
				}
				if ((target_types & PM_TEXT_TYPE_MASK) == 0)
				    break;
			    }
			    do_walk_text = (found > 1);
			}
		    }
#line 3832 "gram.tab.c"
    break;

  case 134: /* opttexttypes: texttypes  */
#line 2135 "gram.y"
                    { (yyval.ival) = (yyvsp[0].ival); }
#line 3838 "gram.tab.c"
    break;

  case 135: /* opttexttypes: %empty  */
#line 2137 "gram.y"
                    { (yyval.ival) = PM_TEXT_ONELINE; }
#line 3844 "gram.tab.c"
    break;

  case 136: /* texttypes: texttype  */
#line 2141 "gram.y"
                    { (yyval.ival) = (yyvsp[0].ival); }
#line 3850 "gram.tab.c"
    break;

  case 137: /* texttypes: texttype texttypes  */
#line 2143 "gram.y"
                    { (yyval.ival) = (yyvsp[-1].ival) | (yyvsp[0].ival); }
#line 3856 "gram.tab.c"
    break;

  case 138: /* texttype: TOK_TEXT_STAR  */
#line 2147 "gram.y"
                    { (yyval.ival) = PM_TEXT_ONELINE | PM_TEXT_HELP; }
#line 3862 "gram.tab.c"
    break;

  case 139: /* texttype: TOK_HELP  */
#line 2149 "gram.y"
                    { (yyval.ival) = PM_TEXT_HELP; }
#line 3868 "gram.tab.c"
    break;

  case 140: /* texttype: TOK_ONELINE  */
#line 2151 "gram.y"
                    { (yyval.ival) = PM_TEXT_ONELINE; }
#line 3874 "gram.tab.c"
    break;

  case 141: /* opttextvalue: textstring  */
#line 2155 "gram.y"
                    { (yyval.str) = (yyvsp[0].str); }
#line 3880 "gram.tab.c"
    break;

  case 142: /* opttextvalue: %empty  */
#line 2157 "gram.y"
                    { (yyval.str) = NULL; }
#line 3886 "gram.tab.c"
    break;

  case 144: /* opttextmetricoptlist: %empty  */
#line 2162 "gram.y"
                    {
			textspec_t	*tp;
			for (tp = walk_text(W_START, TEXT_ACTIVE, "active", 0); tp != NULL; tp = walk_text(W_NEXT, 0, "", 0)) {
			    tp->flags &= ~TEXT_ACTIVE;
			}
		    }
#line 3897 "gram.tab.c"
    break;

  case 147: /* textmetricopt: TOK_DELETE  */
#line 2175 "gram.y"
                    {
			textspec_t	*tp;
			for (tp = walk_text(W_START, TEXT_DELETE, "delete", 0); tp != NULL; tp = walk_text(W_NEXT, TEXT_DELETE, "delete", 0)) {
			    tp->flags |= TEXT_DELETE;
			}
		    }
#line 3908 "gram.tab.c"
    break;

  case 148: /* textmetricopt: TOK_TEXT TOK_ASSIGN textstring  */
#line 2182 "gram.y"
                    {
			textspec_t	*tp;
			for (tp = walk_text(W_START, TEXT_CHANGE_TEXT, "text", 0); tp != NULL; tp = walk_text(W_NEXT, TEXT_CHANGE_TEXT, "text", 0)) {
			    if (tp->new_text) {
				if (strcmp(tp->new_text, (yyvsp[0].str)) == 0) {
				    pmsprintf(mess, sizeof(mess), "Duplicate text change clause");
				    yyerror(mess);
				}
				else {
				    pmsprintf(mess, sizeof(mess), "Conflicting text change clause");
				    yyerror(mess);
				}
				free((yyvsp[0].str));
			    }
			    else if (strcmp(tp->old_text, (yyvsp[0].str)) == 0) {
				/* no change ... */
				if (wflag) {
				    pmsprintf(mess, sizeof(mess), "Help text: No change");
				    yywarn(mess);
				}
				free((yyvsp[0].str));
			    }
			    else {
				tp->new_text = (yyvsp[0].str);
				tp->flags |= TEXT_CHANGE_TEXT;
			    }
			}
		    }
#line 3941 "gram.tab.c"
    break;

  case 149: /* textmetricopt: TOK_METRIC TOK_ASSIGN pmid_int  */
#line 2211 "gram.y"
                    {
			textspec_t	*tp;
			pmID		pmid;
			for (tp = walk_text(W_START, TEXT_CHANGE_ID, "id", 0); tp != NULL; tp = walk_text(W_NEXT, TEXT_CHANGE_ID, "id", 0)) {
			    if (current_star_metric == 1)
				pmid = pmID_build(pmID_domain((yyvsp[0].pmid)), pmID_cluster((yyvsp[0].pmid)), pmID_item(tp->old_id));
			    else if (current_star_metric == 2)
				pmid = pmID_build(pmID_domain((yyvsp[0].pmid)), pmID_cluster(tp->old_id), pmID_item(tp->old_id));
			    else
				pmid = (yyvsp[0].pmid);
			    if (pmid == tp->old_id) {
				/* no change ... */
				if (wflag) {
				    pmsprintf(mess, sizeof(mess), "Text for metric: %s: metric: No change", pmIDStr(tp->old_id));
				    yywarn(mess);
				}
			    }
			    else {
				const textspec_t *tp1;
				/* Warn if the target metric already has text of this type. */
				/*
				 * Search all of the change specs for others targeting
				 * the same metric.
				 */
				for (tp1 = text_root; tp1 != NULL; tp1 = tp1->t_next) {
				    if (! (tp1->flags & TEXT_CHANGE_ID))
					continue; /* not an id change spec */
				    if (tp1->new_type != tp->new_type)
					continue; /* target is a different type */
				    if (tp1 == tp)
					continue; /* same spec */
				    if (tp1->new_id == pmid) {
					/* conflict with another change spec. */
					pmsprintf(mess, sizeof(mess), "Text for metric: %s: metric: Conflicting metric change", pmIDStr(tp->old_id));
					yyerror(mess);
					break;
				    }
				}
				if (tp1 == NULL) {
				    /* No conflict */
				    tp->new_id = pmid;
				    tp->flags |= TEXT_CHANGE_ID;
				}
			    }
			}
		    }
#line 3992 "gram.tab.c"
    break;

  case 150: /* textstring: TOK_STRING  */
#line 2260 "gram.y"
                    { (yyval.str) = (yyvsp[0].str); }
#line 3998 "gram.tab.c"
    break;

  case 151: /* textstring: TOK_TEXT_STRING  */
#line 2262 "gram.y"
                    { (yyval.str) = (yyvsp[0].str); }
#line 4004 "gram.tab.c"
    break;

  case 152: /* pattern: TOK_PATTERN  */
#line 2266 "gram.y"
                    { (yyval.str) = (yyvsp[0].str); }
#line 4010 "gram.tab.c"
    break;

  case 153: /* pattern: TOK_STRING  */
#line 2268 "gram.y"
                    { (yyval.str) = (yyvsp[0].str); }
#line 4016 "gram.tab.c"
    break;

  case 154: /* replacement: TOK_STRING  */
#line 2272 "gram.y"
                    { (yyval.str) = (yyvsp[0].str); }
#line 4022 "gram.tab.c"
    break;

  case 155: /* replacement: TOK_PATTERN  */
#line 2274 "gram.y"
                    { (yyval.str) = (yyvsp[0].str); }
#line 4028 "gram.tab.c"
    break;

  case 156: /* $@4: %empty  */
#line 2278 "gram.y"
                    {
			__pmContext	*ctxp;
			__pmHashCtl	*hcp1;
			__pmHashNode	*node1;
			int		target_types;
			int		this_type;
			int		type;

			ctxp = __pmHandleToPtr(pmWhichContext());
			assert(ctxp != NULL);
    /*
     * Note: This application is single threaded, and once we have ctxp,
     *	     the associated __pmContext will not move and will only be
     *	     accessed or modified synchronously either here or in libpcp.
     *	     We unlock the context so that it can be locked as required
     *	     within libpcp.
     */
			PM_UNLOCK(ctxp->c_lock);
			
			current_textspec = NULL;
			if ((yyvsp[-2].indom) == PM_ID_NULL) {
			    /* Indom is not in the archive */
			    do_walk_text = 0;
			}
			else {
			    int found = 0;
			    
			    if (current_star_indom) {
				/* Set up for indoms specified using globbing. */
				star_domain = pmInDom_domain((yyvsp[-2].indom));
			    }

			    /* We're looking for text of the specified type(s) for indom(s). */
			    target_types = PM_TEXT_INDOM | (yyvsp[-1].ival);
			    hcp1 = &ctxp->c_archctl->ac_log->hashtext;
			    for (node1 = __pmHashWalk(hcp1, PM_HASH_WALK_START);
				 node1 != NULL;
				 node1 = __pmHashWalk(hcp1, PM_HASH_WALK_NEXT)) {
				__pmHashCtl	*hcp2;
				__pmHashNode	*node2;

				/* Was this object type selected? */
				this_type = (int)(node1->key);
				if ((this_type & target_types) != this_type)
				    continue;

				/*
				 * Collect the text records associated with the specified
				 * metric(s).
				 */
				hcp2 = (__pmHashCtl *)(node1->data);
				for (node2 = __pmHashWalk(hcp2, PM_HASH_WALK_START);
				     node2 != NULL;
				     node2 = __pmHashWalk(hcp2, PM_HASH_WALK_NEXT)) {
				    if (current_star_indom) {
					/* Match the globbed metric spec and keep looking. */
					if (pmInDom_domain((pmID)(node2->key)) == star_domain) {
					    current_textspec = start_text(this_type, (pmID)(node2->key), (yyvsp[0].str));
					    if (current_textspec) {
						current_textspec->flags |= TEXT_ACTIVE;
						++found;
					    }
					}
				    }
				    else {
					/* Match the exact indom id. */
					if ((pmID)(node2->key) == (yyvsp[-2].indom)) {
					    current_textspec = start_text(this_type, (pmID)(node2->key), (yyvsp[0].str));
					    if (current_textspec) {
						current_textspec->flags |= TEXT_ACTIVE;
						++found;
					    }
					    /*
					     * Stop looking if we have found all of the specified
					     * types.
					     */
					    type = this_type & PM_TEXT_TYPE_MASK;
					    target_types ^= type;
					    if ((target_types & PM_TEXT_TYPE_MASK) == 0)
						break;
					}
				    }
				}
				if ((target_types & PM_TEXT_TYPE_MASK) == 0)
				    break;
			    }
			    do_walk_text = (found > 1);
			}
		    }
#line 4122 "gram.tab.c"
    break;

  case 159: /* opttextindomoptlist: %empty  */
#line 2372 "gram.y"
                    {
			textspec_t	*tp;
			for (tp = walk_text(W_START, TEXT_ACTIVE, "active", 0); tp != NULL; tp = walk_text(W_NEXT, 0, "", 0)) {
			    tp->flags &= ~TEXT_ACTIVE;
			}
		    }
#line 4133 "gram.tab.c"
    break;

  case 162: /* textindomopt: TOK_DELETE  */
#line 2385 "gram.y"
                    {
			textspec_t	*tp;
			for (tp = walk_text(W_START, TEXT_DELETE, "delete", 0); tp != NULL; tp = walk_text(W_NEXT, TEXT_DELETE, "delete", 0)) {
			    tp->flags |= TEXT_DELETE;
			}
		    }
#line 4144 "gram.tab.c"
    break;

  case 163: /* textindomopt: TOK_TEXT TOK_ASSIGN textstring  */
#line 2392 "gram.y"
                    {
			textspec_t	*tp;
			for (tp = walk_text(W_START, TEXT_CHANGE_TEXT, "text", 0); tp != NULL; tp = walk_text(W_NEXT, TEXT_CHANGE_TEXT, "text", 0)) {
			    if (tp->new_text) {
				if (strcmp(tp->new_text, (yyvsp[0].str)) == 0) {
				    pmsprintf(mess, sizeof(mess), "Duplicate text change clause");
				    yyerror(mess);
				}
				else {
				    pmsprintf(mess, sizeof(mess), "Conflicting text change clause");
				    yyerror(mess);
				}
				free((yyvsp[0].str));
			    }
			    else if (strcmp(tp->old_text, (yyvsp[0].str)) == 0) {
				/* no change ... */
				if (wflag) {
				    pmsprintf(mess, sizeof(mess), "Help text: No change");
				    yywarn(mess);
				}
				free((yyvsp[0].str));
			    }
			    else {
				tp->new_text = (yyvsp[0].str);
				tp->flags |= TEXT_CHANGE_TEXT;
			    }
			}
		    }
#line 4177 "gram.tab.c"
    break;

  case 164: /* textindomopt: TOK_INDOM TOK_ASSIGN indom_int  */
#line 2421 "gram.y"
                    {
			textspec_t	*tp;
			for (tp = walk_text(W_START, TEXT_CHANGE_ID, "id", 0); tp != NULL; tp = walk_text(W_NEXT, TEXT_CHANGE_ID, "id", 0)) {
			    pmInDom	indom;
			    if (tp->new_id != tp->old_id) {
				pmsprintf(mess, sizeof(mess), "Duplicate text clause for indom %s", pmInDomStr(tp->old_id));
				yyerror(mess);
			    }
			    if (current_star_indom)
				indom = pmInDom_build(pmInDom_domain((yyvsp[0].indom)), pmInDom_serial(tp->old_id));
			    else
				indom = (yyvsp[0].indom);
			    if (indom != tp->old_id) {
				tp->new_id = indom;
				tp->flags |= TEXT_CHANGE_ID;
			    }
			    else {
				/* no change ... */
				if (wflag) {
				    pmsprintf(mess, sizeof(mess), "Text for instance domain %s: indom: No change", pmInDomStr(tp->old_id));
				    yywarn(mess);
				}
			    }
			}
		    }
#line 4207 "gram.tab.c"
    break;

  case 172: /* $@5: %empty  */
#line 2460 "gram.y"
                    {
			__pmContext	*ctxp;
			__pmHashCtl	*hcp1;
			__pmHashNode	*node1;
			int		found = 0;

			ctxp = __pmHandleToPtr(pmWhichContext());
			assert(ctxp != NULL);
    /*
     * Note: This application is single threaded, and once we have ctxp,
     *	     the associated __pmContext will not move and will only be
     *	     accessed or modified synchronously either here or in libpcp.
     *	     We unlock the context so that it can be locked as required
     *	     within libpcp.
     */
			PM_UNLOCK(ctxp->c_lock);
			
			/* We're looking for context labels. */
			current_labelspec = NULL;
			hcp1 = &ctxp->c_archctl->ac_log->hashlabels;
			for (node1 = __pmHashWalk(hcp1, PM_HASH_WALK_START);
			     node1 != NULL;
			     node1 = __pmHashWalk(hcp1, PM_HASH_WALK_NEXT)) {
			    __pmHashCtl	*hcp2;
			    __pmHashNode	*node2;
			    int		this_type;

			    /* Was this object type selected? */
			    this_type = (int)(node1->key);
			    if (this_type != PM_LABEL_CONTEXT)
				continue;

			    /*
			     * Collect the label records associated with the specified
			     * metric(s).
			     */
			    hcp2 = (__pmHashCtl *)(node1->data);
			    for (node2 = __pmHashWalk(hcp2, PM_HASH_WALK_START);
				 node2 != NULL;
				 node2 = __pmHashWalk(hcp2, PM_HASH_WALK_NEXT)) {
				/* We want all of the context labels. */
				current_labelspec = start_label(this_type, (pmID)(node2->key), 0, NULL,
								current_label_name, current_label_value);
				if (current_labelspec) {
				    current_labelspec->flags |= LABEL_ACTIVE;
				    ++found;
				}
			    }
			}
			do_walk_label = found;
		    }
#line 4263 "gram.tab.c"
    break;

  case 174: /* optlabeldetails: jsonname optlabelvalue  */
#line 2515 "gram.y"
                    { current_label_name = (yyvsp[-1].str); }
#line 4269 "gram.tab.c"
    break;

  case 175: /* optlabeldetails: TOK_LABEL_STAR optlabelvalue  */
#line 2517 "gram.y"
                    { current_label_name = NULL; }
#line 4275 "gram.tab.c"
    break;

  case 176: /* optlabeldetails: %empty  */
#line 2519 "gram.y"
                    {
			current_label_name = NULL;
			current_label_value = NULL;
		    }
#line 4284 "gram.tab.c"
    break;

  case 177: /* jsonname: TOK_JSON_STRING  */
#line 2526 "gram.y"
                    { (yyval.str) = (yyvsp[0].str); }
#line 4290 "gram.tab.c"
    break;

  case 178: /* jsonname: TOK_STRING  */
#line 2528 "gram.y"
                    {
			(yyval.str) = add_quotes((yyvsp[0].str));
			free((yyvsp[0].str));
		    }
#line 4299 "gram.tab.c"
    break;

  case 179: /* optlabelvalue: jsonvalue  */
#line 2535 "gram.y"
                    { current_label_value = (yyvsp[0].str); }
#line 4305 "gram.tab.c"
    break;

  case 180: /* optlabelvalue: TOK_LABEL_STAR  */
#line 2537 "gram.y"
                    { current_label_value = NULL; }
#line 4311 "gram.tab.c"
    break;

  case 181: /* optlabelvalue: %empty  */
#line 2539 "gram.y"
                    { current_label_value = NULL; }
#line 4317 "gram.tab.c"
    break;

  case 182: /* jsonvalue: jsonname  */
#line 2543 "gram.y"
                    { (yyval.str) = (yyvsp[0].str); }
#line 4323 "gram.tab.c"
    break;

  case 183: /* jsonvalue: jsonnumber  */
#line 2545 "gram.y"
                    { (yyval.str) = (yyvsp[0].str); }
#line 4329 "gram.tab.c"
    break;

  case 184: /* jsonvalue: TOK_JSON_TRUE  */
#line 2547 "gram.y"
                    { (yyval.str) = (yyvsp[0].str); }
#line 4335 "gram.tab.c"
    break;

  case 185: /* jsonvalue: TOK_JSON_FALSE  */
#line 2549 "gram.y"
                    { (yyval.str) = (yyvsp[0].str); }
#line 4341 "gram.tab.c"
    break;

  case 186: /* jsonvalue: TOK_JSON_NULL  */
#line 2551 "gram.y"
                    { (yyval.str) = (yyvsp[0].str); }
#line 4347 "gram.tab.c"
    break;

  case 187: /* jsonnumber: TOK_MINUS TOK_NUMBER  */
#line 2555 "gram.y"
                    {
			(yyval.str) = dupcat("-", (yyvsp[0].str));
			free((yyvsp[0].str));
		    }
#line 4356 "gram.tab.c"
    break;

  case 188: /* jsonnumber: TOK_NUMBER  */
#line 2560 "gram.y"
                    { (yyval.str) = (yyvsp[0].str); }
#line 4362 "gram.tab.c"
    break;

  case 189: /* jsonnumber: TOK_MINUS TOK_JSON_NUMBER  */
#line 2562 "gram.y"
                    {
			(yyval.str) = dupcat("-", (yyvsp[0].str));
			free((yyvsp[0].str));
		    }
#line 4371 "gram.tab.c"
    break;

  case 190: /* jsonnumber: TOK_JSON_NUMBER  */
#line 2567 "gram.y"
                    { (yyval.str) = (yyvsp[0].str); }
#line 4377 "gram.tab.c"
    break;

  case 192: /* optlabelcontextoptlist: %empty  */
#line 2572 "gram.y"
                    {
			deactivate_labels();
		    }
#line 4385 "gram.tab.c"
    break;

  case 195: /* labelcontextopt: TOK_DELETE  */
#line 2582 "gram.y"
                    {
			labelspec_t	*lp;
			for (lp = walk_label(W_START, LABEL_DELETE, "delete", 0); lp != NULL; lp = walk_label(W_NEXT, LABEL_DELETE, "delete", 0)) {
			    lp->flags |= LABEL_DELETE;
			}
		    }
#line 4396 "gram.tab.c"
    break;

  case 196: /* labelcontextopt: TOK_LABEL TOK_ASSIGN jsonname  */
#line 2589 "gram.y"
                    {
			labelspec_t	*lp;
			for (lp = walk_label(W_START, LABEL_CHANGE_LABEL, "label", 0); lp != NULL; lp = walk_label(W_NEXT, LABEL_CHANGE_LABEL, "label", 0)) {
			    if (lp->new_label != NULL) {
				pmsprintf(mess, sizeof(mess), "Duplicate label clause for context");
				yyerror(mess);
			    }
			    if (lp->old_label != NULL &&
				strcmp(lp->old_label, (yyvsp[0].str)) == 0) {
				/* no change ... */
				if (wflag) {
				    pmsprintf(mess, sizeof(mess), "Label for context: label: No change");
				    yywarn(mess);
				}
				free((yyvsp[0].str));
			    }
			    else {
				lp->new_label = (yyvsp[0].str);
				lp->flags |= LABEL_CHANGE_LABEL;
			    }
			}
		    }
#line 4423 "gram.tab.c"
    break;

  case 197: /* labelcontextopt: TOK_VALUE TOK_ASSIGN jsonvalue  */
#line 2613 "gram.y"
                    {
			labelspec_t	*lp;
			for (lp = walk_label(W_START, LABEL_CHANGE_VALUE, "value", 0); lp != NULL; lp = walk_label(W_NEXT, LABEL_CHANGE_VALUE, "value", 0)) {
			    if (lp->new_value != NULL) {
				pmsprintf(mess, sizeof(mess), "Duplicate label value clause for cluster %d.%d", pmID_domain(lp->old_id), pmID_cluster(lp->old_id));
				yyerror(mess);
			    }
			    if (lp->old_value != NULL &&
				strcmp(lp->old_value, (yyvsp[0].str)) == 0) {
				/* no change ... */
				if (wflag) {
				    pmsprintf(mess, sizeof(mess), "Label for cluster %d.%d: value: No change", pmID_domain(lp->old_id), pmID_cluster(lp->old_id));
				    yywarn(mess);
				}
				free((yyvsp[0].str));
			    }
			    else {
				lp->new_label = lp->old_label;
				lp->new_value = (yyvsp[0].str);
				lp->flags |= LABEL_CHANGE_VALUE;
			    }
			}
		    }
#line 4451 "gram.tab.c"
    break;

  case 198: /* labelcontextopt: newlabelspec  */
#line 2638 "gram.y"
                    {
			new_context_label();
		    }
#line 4459 "gram.tab.c"
    break;

  case 199: /* newlabelspec: TOK_NEW jsonname jsonvalue  */
#line 2643 "gram.y"
                    {
			/* The current label name and value must both NOT be specified. */
			if (current_label_name || current_label_value) {
			    pmsprintf(mess, sizeof(mess), "The target label name and value must both not be specified for a NEW label and will be ignored");
			    yywarn(mess);
			    if (current_label_name)
				free(current_label_name);
			    if (current_label_value)
				free(current_label_value);
			}
			current_label_name = (yyvsp[-1].str);
			current_label_value = (yyvsp[0].str);
		    }
#line 4477 "gram.tab.c"
    break;

  case 200: /* $@6: %empty  */
#line 2658 "gram.y"
                    {
			__pmContext	*ctxp;
			__pmHashCtl	*hcp1;
			__pmHashNode	*node1;
			int		 found = 0;

			ctxp = __pmHandleToPtr(pmWhichContext());
			assert(ctxp != NULL);
    /*
     * Note: This application is single threaded, and once we have ctxp,
     *	     the associated __pmContext will not move and will only be
     *	     accessed or modified synchronously either here or in libpcp.
     *	     We unlock the context so that it can be locked as required
     *	     within libpcp.
     */
			PM_UNLOCK(ctxp->c_lock);
			
			current_labelspec = NULL;
			assert ((yyvsp[-1].ival) != PM_ID_NULL);
			current_label_id = (yyvsp[-1].ival);
			    
			/* We're looking for domain labels. */
			hcp1 = &ctxp->c_archctl->ac_log->hashlabels;
			for (node1 = __pmHashWalk(hcp1, PM_HASH_WALK_START);
			     node1 != NULL;
			     node1 = __pmHashWalk(hcp1, PM_HASH_WALK_NEXT)) {
			    __pmHashCtl	*hcp2;
			    __pmHashNode	*node2;
			    int		this_type;

			    /* Was this object type selected? */
			    this_type = (int)(node1->key);
			    if (this_type != PM_LABEL_DOMAIN)
				continue;

			    /*
			     * Collect the label records associated with the specified
			     * metric domain.
			     */
			    hcp2 = (__pmHashCtl *)(node1->data);
			    for (node2 = __pmHashWalk(hcp2, PM_HASH_WALK_START);
				 node2 != NULL;
				 node2 = __pmHashWalk(hcp2, PM_HASH_WALK_NEXT)) {
				/* Match the exact metric domain. */
				if ((pmID)(node2->key) == (yyvsp[-1].ival)) {
				    current_labelspec = start_label(this_type, (pmID)(node2->key), 0, NULL,
								    current_label_name, current_label_value);
				    if (current_labelspec) {
					current_labelspec->flags |= LABEL_ACTIVE;
					++found;
				    }
				}
			    }
			}
			do_walk_label = found;
		    }
#line 4538 "gram.tab.c"
    break;

  case 202: /* pmid_domain: TOK_NUMBER  */
#line 2718 "gram.y"
                    {
			int	domain;
			/* TOK_NUMBER => domain >= 0 after sscanf */
			sscanf((yyvsp[0].str), "%d", &domain);
			if (domain > DYNAMIC_PMID) {
			    pmsprintf(mess, sizeof(mess), "Illegal domain field (%d) for pmid", domain);
			    yyerror(mess);
			}
			else if (domain == DYNAMIC_PMID) {
			    pmsprintf(mess, sizeof(mess), "Dynamic metric domain field (%d) for pmid", domain);
			    yywarn(mess);
			}
			current_star_metric = 0;
			free((yyvsp[0].str));
			(yyval.ival) = domain;
		    }
#line 4559 "gram.tab.c"
    break;

  case 204: /* optlabeldomainoptlist: %empty  */
#line 2738 "gram.y"
                    {
			deactivate_labels();
		    }
#line 4567 "gram.tab.c"
    break;

  case 207: /* labeldomainopt: TOK_DELETE  */
#line 2748 "gram.y"
                    {
			labelspec_t	*lp;
			for (lp = walk_label(W_START, LABEL_DELETE, "delete", 0); lp != NULL; lp = walk_label(W_NEXT, LABEL_DELETE, "delete", 0)) {
			    lp->flags |= LABEL_DELETE;
			}
		    }
#line 4578 "gram.tab.c"
    break;

  case 208: /* labeldomainopt: TOK_DOMAIN TOK_ASSIGN TOK_NUMBER  */
#line 2755 "gram.y"
                    {
			labelspec_t	*lp;
			int		domain;
			/* TOK_NUMBER => domain >= 0 after sscanf */
			sscanf((yyvsp[0].str), "%d", &domain);
			if (domain >= DYNAMIC_PMID) {
			    pmsprintf(mess, sizeof(mess), "Illegal domain field (%d) for label", domain);
			    yyerror(mess);
			}
			free((yyvsp[0].str));
			for (lp = walk_label(W_START, LABEL_CHANGE_ID, "id", 0); lp != NULL; lp = walk_label(W_NEXT, LABEL_CHANGE_ID, "id", 0)) {
			    if (domain == lp->old_id) {
				/* no change ... */
				if (wflag) {
				    pmsprintf(mess, sizeof(mess), "Label for metric domain: %d: No change", lp->old_id);
				    yywarn(mess);
				}
			    }
			    else {
				/*
				 * No need to check for conflicts. Multiple label set records for
				 * the same domain are ok.
				 */
				lp->new_id = domain;
				lp->flags |= LABEL_CHANGE_ID;
			    }
			}
		    }
#line 4611 "gram.tab.c"
    break;

  case 209: /* labeldomainopt: TOK_LABEL TOK_ASSIGN jsonname  */
#line 2784 "gram.y"
                    {
			labelspec_t	*lp;
			for (lp = walk_label(W_START, LABEL_CHANGE_LABEL, "label", 0); lp != NULL; lp = walk_label(W_NEXT, LABEL_CHANGE_LABEL, "label", 0)) {
			    if (lp->new_label != NULL) {
				pmsprintf(mess, sizeof(mess), "Duplicate label clause for domain %d", lp->old_id);
				yyerror(mess);
			    }
			    if (lp->old_label != NULL &&
				strcmp(lp->old_label, (yyvsp[0].str)) == 0) {
				/* no change ... */
				if (wflag) {
				    pmsprintf(mess, sizeof(mess), "Label for domain %d: label: No change", lp->old_id);
				    yywarn(mess);
				}
				free((yyvsp[0].str));
			    }
			    else {
				lp->new_label = (yyvsp[0].str);
				lp->flags |= LABEL_CHANGE_LABEL;
			    }
			}
		    }
#line 4638 "gram.tab.c"
    break;

  case 210: /* labeldomainopt: TOK_VALUE TOK_ASSIGN jsonvalue  */
#line 2808 "gram.y"
                    {
			labelspec_t	*lp;
			for (lp = walk_label(W_START, LABEL_CHANGE_VALUE, "value", 0); lp != NULL; lp = walk_label(W_NEXT, LABEL_CHANGE_VALUE, "value", 0)) {
			    if (lp->new_value != NULL) {
				pmsprintf(mess, sizeof(mess), "Duplicate label value clause for cluster %d.%d", pmID_domain(lp->old_id), pmID_cluster(lp->old_id));
				yyerror(mess);
			    }
			    if (lp->old_value != NULL &&
				strcmp(lp->old_value, (yyvsp[0].str)) == 0) {
				/* no change ... */
				if (wflag) {
				    pmsprintf(mess, sizeof(mess), "Label for cluster %d.%d: value: No change", pmID_domain(lp->old_id), pmID_cluster(lp->old_id));
				    yywarn(mess);
				}
				free((yyvsp[0].str));
			    }
			    else {
				lp->new_value = (yyvsp[0].str);
				lp->flags |= LABEL_CHANGE_VALUE;
			    }
			}
		    }
#line 4665 "gram.tab.c"
    break;

  case 211: /* labeldomainopt: newlabelspec  */
#line 2832 "gram.y"
                    {
			new_domain_label(current_label_id);
		    }
#line 4673 "gram.tab.c"
    break;

  case 212: /* $@7: %empty  */
#line 2838 "gram.y"
                    {
			__pmContext	*ctxp;
			__pmHashCtl	*hcp1;
			__pmHashNode	*node1;
			int		found = 0;

			ctxp = __pmHandleToPtr(pmWhichContext());
			assert(ctxp != NULL);
    /*
     * Note: This application is single threaded, and once we have ctxp,
     *	     the associated __pmContext will not move and will only be
     *	     accessed or modified synchronously either here or in libpcp.
     *	     We unlock the context so that it can be locked as required
     *	     within libpcp.
     */
			PM_UNLOCK(ctxp->c_lock);
			
			current_labelspec = NULL;
			assert ((yyvsp[-1].ival) != PM_ID_NULL);
			current_label_id = (yyvsp[-1].ival);
			    
			if (current_star_metric) {
			    /* Set up for metrics specified using globbing. */
			    star_domain = pmID_domain((yyvsp[-1].ival));
			    star_cluster = PM_ID_NULL;
			}

			/* We're looking for cluster labels. */
			hcp1 = &ctxp->c_archctl->ac_log->hashlabels;
			for (node1 = __pmHashWalk(hcp1, PM_HASH_WALK_START);
			     node1 != NULL;
			     node1 = __pmHashWalk(hcp1, PM_HASH_WALK_NEXT)) {
			    __pmHashCtl		*hcp2;
			    __pmHashNode	*node2;
			    int			this_type;

			    /* Was this object type selected? */
			    this_type = (int)(node1->key);
			    if (this_type != PM_LABEL_CLUSTER)
				continue;

			    /*
			     * Collect the label records associated with the specified
			     * metric(s).
			     */
			    hcp2 = (__pmHashCtl *)(node1->data);
			    for (node2 = __pmHashWalk(hcp2, PM_HASH_WALK_START);
				 node2 != NULL;
				 node2 = __pmHashWalk(hcp2, PM_HASH_WALK_NEXT)) {
				if (current_star_metric) {
				    /* Match the globbed cluster spec and keep looking. */
				    if (pmID_domain((pmID)(node2->key)) == star_domain) {
					current_labelspec = start_label(this_type, (pmID)(node2->key), 0, NULL,
									current_label_name, current_label_value);
					if (current_labelspec) {
					    current_labelspec->flags |= LABEL_ACTIVE;
					    ++found;
					}
				    }
				}
				else {
				    /* Match the exact cluster spec. */
				    if ((pmID)(node2->key) == (yyvsp[-1].ival)) {
					current_labelspec = start_label(this_type, (pmID)(node2->key), 0, NULL,
									current_label_name, current_label_value);
					if (current_labelspec) {
					    current_labelspec->flags |= LABEL_ACTIVE;
					    ++found;
					}
				    }
				}
			    }
			}
			do_walk_label = found;
		    }
#line 4753 "gram.tab.c"
    break;

  case 214: /* pmid_cluster: TOK_FLOAT  */
#line 2917 "gram.y"
                    {
			int	domain;
			int	cluster;
			/* TOK_FLOAT => domain >= 0 && serial >= 0 after sscanf */
			sscanf((yyvsp[0].str), "%d.%d", &domain, &cluster);
			if (domain > DYNAMIC_PMID) {
			    pmsprintf(mess, sizeof(mess), "Illegal domain field (%d) for pmid", domain);
			    yyerror(mess);
			}
			else if (domain == DYNAMIC_PMID) {
			    pmsprintf(mess, sizeof(mess), "Dynamic metric domain field (%d) for pmid", domain);
			    yywarn(mess);
			}
			if (cluster >= 4096) {
			    pmsprintf(mess, sizeof(mess), "Illegal cluster field (%d) for pmid", cluster);
			    yyerror(mess);
			}
			current_star_metric = 0;
			free((yyvsp[0].str));
			(yyval.ival) = pmID_build(domain, cluster, 0);
		    }
#line 4779 "gram.tab.c"
    break;

  case 215: /* pmid_cluster: TOK_INDOM_STAR  */
#line 2939 "gram.y"
                    {
			int	domain;
			/* TOK_INDOM_STAR => domain >= 0 after sscanf */
			sscanf((yyvsp[0].str), "%d.", &domain);
			if (domain > DYNAMIC_PMID) {
			    pmsprintf(mess, sizeof(mess), "Illegal domain field (%d) for pmid", domain);
			    yyerror(mess);
			}
			else if (domain == DYNAMIC_PMID) {
			    pmsprintf(mess, sizeof(mess), "Dynamic metric domain field (%d) for pmid", domain);
			    yywarn(mess);
			}
			current_star_metric = 1;
			free((yyvsp[0].str));
			(yyval.ival) = pmID_build(domain, 0, 0);
		    }
#line 4800 "gram.tab.c"
    break;

  case 217: /* optlabelclusteroptlist: %empty  */
#line 2959 "gram.y"
                    {
			deactivate_labels();
		    }
#line 4808 "gram.tab.c"
    break;

  case 220: /* labelclusteropt: TOK_DELETE  */
#line 2969 "gram.y"
                    {
			labelspec_t	*lp;
			for (lp = walk_label(W_START, LABEL_DELETE, "delete", 0); lp != NULL; lp = walk_label(W_NEXT, LABEL_DELETE, "delete", 0)) {
			    lp->flags |= LABEL_DELETE;
			}
		    }
#line 4819 "gram.tab.c"
    break;

  case 221: /* labelclusteropt: TOK_CLUSTER TOK_ASSIGN pmid_cluster  */
#line 2976 "gram.y"
                    {
			labelspec_t	*lp;
			int		cluster;
			for (lp = walk_label(W_START, LABEL_CHANGE_ID, "id", 0); lp != NULL; lp = walk_label(W_NEXT, LABEL_CHANGE_ID, "id", 0)) {
			    if (current_star_metric)
				cluster = pmID_build(pmID_domain((yyvsp[0].ival)), pmID_cluster(lp->old_id), PM_ID_NULL);
			    else
				cluster = pmID_build(pmID_domain((yyvsp[0].ival)), pmID_cluster((yyvsp[0].ival)), PM_ID_NULL);
			    if (cluster == lp->old_id) {
				/* no change ... */
				if (wflag) {
				    pmsprintf(mess, sizeof(mess), "Label for cluster: %d.%d: No change", pmID_domain(lp->old_id), pmID_cluster(lp->old_id));
				    yywarn(mess);
				}
			    }
			    else {
				/*
				 * No need to check for conflicts. Multiple label set records for
				 * the same cluster are ok.
				 */
				lp->new_id = cluster;
				lp->flags |= LABEL_CHANGE_ID;
			    }
			}
		    }
#line 4849 "gram.tab.c"
    break;

  case 222: /* labelclusteropt: TOK_LABEL TOK_ASSIGN jsonname  */
#line 3002 "gram.y"
                    {
			labelspec_t	*lp;
			for (lp = walk_label(W_START, LABEL_CHANGE_LABEL, "label", 0); lp != NULL; lp = walk_label(W_NEXT, LABEL_CHANGE_LABEL, "label", 0)) {
			    if (lp->new_label != NULL) {
				pmsprintf(mess, sizeof(mess), "Duplicate label clause for cluster %d.%d", pmID_domain(lp->old_id), pmID_cluster(lp->old_id));
				yyerror(mess);
			    }
			    if (lp->old_label != NULL &&
				strcmp(lp->old_label, (yyvsp[0].str)) == 0) {
				/* no change ... */
				if (wflag) {
				    pmsprintf(mess, sizeof(mess), "Label for cluster %d.%d: label: No change", pmID_domain(lp->old_id), pmID_cluster(lp->old_id));
				    yywarn(mess);
				}
				free((yyvsp[0].str));
			    }
			    else {
				lp->new_label = (yyvsp[0].str);
				lp->flags |= LABEL_CHANGE_LABEL;
			    }
			}
		    }
#line 4876 "gram.tab.c"
    break;

  case 223: /* labelclusteropt: TOK_VALUE TOK_ASSIGN jsonvalue  */
#line 3025 "gram.y"
                    {
			labelspec_t	*lp;
			for (lp = walk_label(W_START, LABEL_CHANGE_VALUE, "value", 0); lp != NULL; lp = walk_label(W_NEXT, LABEL_CHANGE_VALUE, "value", 0)) {
			    if (lp->new_value != NULL) {
				pmsprintf(mess, sizeof(mess), "Duplicate label value clause for cluster %d.%d", pmID_domain(lp->old_id), pmID_cluster(lp->old_id));
				yyerror(mess);
			    }
			    if (lp->old_value != NULL &&
				strcmp(lp->old_value, (yyvsp[0].str)) == 0) {
				/* no change ... */
				if (wflag) {
				    pmsprintf(mess, sizeof(mess), "Label for cluster %d.%d: value: No change", pmID_domain(lp->old_id), pmID_cluster(lp->old_id));
				    yywarn(mess);
				}
				free((yyvsp[0].str));
			    }
			    else {
				lp->new_value = (yyvsp[0].str);
				lp->flags |= LABEL_CHANGE_VALUE;
			    }
			}
		    }
#line 4903 "gram.tab.c"
    break;

  case 224: /* labelclusteropt: newlabelspec  */
#line 3048 "gram.y"
                    {
			new_cluster_label(current_label_id);
		    }
#line 4911 "gram.tab.c"
    break;

  case 225: /* $@8: %empty  */
#line 3054 "gram.y"
                    {
			__pmContext	*ctxp;
			__pmHashCtl	*hcp1;
			__pmHashNode	*node1;

			ctxp = __pmHandleToPtr(pmWhichContext());
			assert(ctxp != NULL);
    /*
     * Note: This application is single threaded, and once we have ctxp,
     *	     the associated __pmContext will not move and will only be
     *	     accessed or modified synchronously either here or in libpcp.
     *	     We unlock the context so that it can be locked as required
     *	     within libpcp.
     */
			PM_UNLOCK(ctxp->c_lock);
			
			current_labelspec = NULL;
			current_label_id = (yyvsp[-1].pmid);
			if ((yyvsp[-1].pmid) == PM_ID_NULL) {
			    /* Metric referenced by name is not in the archive */
			    do_walk_label = 0;
			}
			else {
			    int found = 0;
			    
			    if (current_star_metric) {
				/* Set up for metrics specified using globbing. */
				star_domain = pmID_domain((yyvsp[-1].pmid));
				if (current_star_metric == 1)
				    star_cluster = pmID_cluster((yyvsp[-1].pmid));
				else
				    star_cluster = PM_ID_NULL;
			    }

			    /* We're looking for item labels. */
			    hcp1 = &ctxp->c_archctl->ac_log->hashlabels;
			    for (node1 = __pmHashWalk(hcp1, PM_HASH_WALK_START);
				 node1 != NULL;
				 node1 = __pmHashWalk(hcp1, PM_HASH_WALK_NEXT)) {
				__pmHashCtl	*hcp2;
				__pmHashNode	*node2;
				int		this_type;

				/* Was this object type selected? */
				this_type = (int)(node1->key);
				if (this_type != PM_LABEL_ITEM)
				    continue;

				/*
				 * Collect the label records associated with the specified
				 * metric(s).
				 */
				hcp2 = (__pmHashCtl *)(node1->data);
				for (node2 = __pmHashWalk(hcp2, PM_HASH_WALK_START);
				     node2 != NULL;
				     node2 = __pmHashWalk(hcp2, PM_HASH_WALK_NEXT)) {
				    if (current_star_metric) {
					/* Match the globbed metric spec and keep looking. */
					if (pmID_domain((pmID)(node2->key)) == star_domain &&
					    (star_cluster == PM_ID_NULL ||
					     star_cluster == pmID_cluster((pmID)(node2->key)))) {
					    current_labelspec = start_label(this_type, (pmID)(node2->key), 0, NULL,
									    current_label_name, current_label_value);
					    if (current_labelspec) {
						current_labelspec->flags |= LABEL_ACTIVE;
						++found;
					    }

					}
				    }
				    else {
					/* Match the exact metric PMID. */
					if ((pmID)(node2->key) == (yyvsp[-1].pmid)) {
					    current_labelspec = start_label(this_type, (pmID)(node2->key), 0, NULL,
									    current_label_name, current_label_value);
					    if (current_labelspec) {
						current_labelspec->flags |= LABEL_ACTIVE;
						++found;
					    }
					}
				    }
				}
			    }
			    do_walk_label = found;
			}
		    }
#line 5002 "gram.tab.c"
    break;

  case 228: /* optlabelitemoptlist: %empty  */
#line 3145 "gram.y"
                    {
			deactivate_labels();
		    }
#line 5010 "gram.tab.c"
    break;

  case 231: /* labelitemopt: TOK_DELETE  */
#line 3155 "gram.y"
                    {
			labelspec_t	*lp;
			for (lp = walk_label(W_START, LABEL_DELETE, "delete", 0); lp != NULL; lp = walk_label(W_NEXT, LABEL_DELETE, "delete", 0)) {
			    lp->flags |= LABEL_DELETE;
			}
		    }
#line 5021 "gram.tab.c"
    break;

  case 232: /* labelitemopt: TOK_ITEM TOK_ASSIGN pmid_int  */
#line 3162 "gram.y"
                    {
			labelspec_t	*lp;
			pmID		pmid;
			for (lp = walk_label(W_START, LABEL_CHANGE_ID, "id", 0); lp != NULL; lp = walk_label(W_NEXT, LABEL_CHANGE_ID, "id", 0)) {
			    if (current_star_metric == 1)
				pmid = pmID_build(pmID_domain((yyvsp[0].pmid)), pmID_cluster((yyvsp[0].pmid)), pmID_item(lp->old_id));
			    else if (current_star_metric == 2)
				pmid = pmID_build(pmID_domain((yyvsp[0].pmid)), pmID_cluster(lp->old_id), pmID_item(lp->old_id));
			    else
				pmid = (yyvsp[0].pmid);
			    if (pmid == lp->old_id) {
				/* no change ... */
				if (wflag) {
				    pmsprintf(mess, sizeof(mess), "Label for metric: %s: item: No change", pmIDStr(lp->old_id));
				    yywarn(mess);
				}
			    }
			    else {
				/*
				 * No need to check for conflicts. Multiple label set records for
				 * the same pmid are ok.
				 */
				lp->new_id = pmid;
				lp->flags |= LABEL_CHANGE_ID;
			    }
			}
		    }
#line 5053 "gram.tab.c"
    break;

  case 233: /* labelitemopt: TOK_LABEL TOK_ASSIGN jsonname  */
#line 3190 "gram.y"
                    {
			labelspec_t	*lp;
			for (lp = walk_label(W_START, LABEL_CHANGE_LABEL, "label", 0); lp != NULL; lp = walk_label(W_NEXT, LABEL_CHANGE_LABEL, "label", 0)) {
			    if (lp->new_label != NULL) {
				pmsprintf(mess, sizeof(mess), "Duplicate label clause for metric %s", pmIDStr(lp->old_id));
				yyerror(mess);
			    }
			    if (lp->old_label != NULL &&
				strcmp(lp->old_label, (yyvsp[0].str)) == 0) {
				/* no change ... */
				if (wflag) {
				    pmsprintf(mess, sizeof(mess), "Label for metric %s: label: No change", pmIDStr(lp->old_id));
				    yywarn(mess);
				}
				free((yyvsp[0].str));
			    }
			    else {
				lp->new_label = (yyvsp[0].str);
				lp->flags |= LABEL_CHANGE_LABEL;
			    }
			}
		    }
#line 5080 "gram.tab.c"
    break;

  case 234: /* labelitemopt: TOK_VALUE TOK_ASSIGN jsonvalue  */
#line 3213 "gram.y"
                    {
			labelspec_t	*lp;
			for (lp = walk_label(W_START, LABEL_CHANGE_VALUE, "value", 0); lp != NULL; lp = walk_label(W_NEXT, LABEL_CHANGE_VALUE, "value", 0)) {
			    if (lp->new_value != NULL) {
				pmsprintf(mess, sizeof(mess), "Duplicate label value clause for metric %s", pmIDStr(lp->old_id));
				yyerror(mess);
			    }
			    if (lp->old_value != NULL &&
				strcmp(lp->old_value, (yyvsp[0].str)) == 0) {
				/* no change ... */
				if (wflag) {
				    pmsprintf(mess, sizeof(mess), "Label for metric %s: value: No change", pmIDStr(lp->old_id));
				    yywarn(mess);
				}
				free((yyvsp[0].str));
			    }
			    else {
				lp->new_value = (yyvsp[0].str);
				lp->flags |= LABEL_CHANGE_VALUE;
			    }
			}
		    }
#line 5107 "gram.tab.c"
    break;

  case 235: /* labelitemopt: newlabelspec  */
#line 3236 "gram.y"
                    {
			new_item_label(current_label_id);
		    }
#line 5115 "gram.tab.c"
    break;

  case 236: /* $@9: %empty  */
#line 3242 "gram.y"
                    {
			__pmContext	*ctxp;
			__pmHashCtl	*hcp1;
			__pmHashNode	*node1;

			ctxp = __pmHandleToPtr(pmWhichContext());
			assert(ctxp != NULL);
    /*
     * Note: This application is single threaded, and once we have ctxp,
     *	     the associated __pmContext will not move and will only be
     *	     accessed or modified synchronously either here or in libpcp.
     *	     We unlock the context so that it can be locked as required
     *	     within libpcp.
     */
			PM_UNLOCK(ctxp->c_lock);
			
			current_labelspec = NULL;
			current_label_id = (yyvsp[-1].indom);
			if ((yyvsp[-1].indom) == PM_ID_NULL) {
			    /* Indom is not in the archive */
			    do_walk_label = 0;
			}
			else {
			    int found = 0;
			    
			    if (current_star_indom) {
				/* Set up for indoms specified using globbing. */
				star_domain = pmInDom_domain((yyvsp[-1].indom));
			    }

			    /* We're looking for label sets for indom(s). */
			    hcp1 = &ctxp->c_archctl->ac_log->hashlabels;
			    for (node1 = __pmHashWalk(hcp1, PM_HASH_WALK_START);
				 node1 != NULL;
				 node1 = __pmHashWalk(hcp1, PM_HASH_WALK_NEXT)) {
				__pmHashCtl	*hcp2;
				__pmHashNode	*node2;
				int		this_type;

				/* Was this object type selected? */
				this_type = (int)(node1->key);
				if (this_type != PM_LABEL_INDOM)
				    continue;

				/*
				 * Collect the label records associated with the specified
				 * imdom(s).
				 */
				hcp2 = (__pmHashCtl *)(node1->data);
				for (node2 = __pmHashWalk(hcp2, PM_HASH_WALK_START);
				     node2 != NULL;
				     node2 = __pmHashWalk(hcp2, PM_HASH_WALK_NEXT)) {
				    if (current_star_indom) {
					/* Match the globbed indom spec and keep looking. */
					if (pmInDom_domain((pmID)(node2->key)) == star_domain) {
					    current_labelspec = start_label(this_type, (pmID)(node2->key), 0, NULL,
									    current_label_name, current_label_value);
					    if (current_labelspec) {
						current_labelspec->flags |= LABEL_ACTIVE;
						++found;
					    }
					}
				    }
				    else {
					/* Match the exact indom id. */
					if ((pmID)(node2->key) == (yyvsp[-1].indom)) {
					    current_labelspec = start_label(this_type, (pmID)(node2->key), 0, NULL,
									    current_label_name, current_label_value);
					    if (current_labelspec) {
						current_labelspec->flags |= LABEL_ACTIVE;
						++found;
					    }
					}
				    }
				}
			    }
			    do_walk_label = found;
			}
		    }
#line 5199 "gram.tab.c"
    break;

  case 239: /* optlabelindomoptlist: %empty  */
#line 3326 "gram.y"
                    {
			deactivate_labels();
		    }
#line 5207 "gram.tab.c"
    break;

  case 242: /* labelindomopt: TOK_DELETE  */
#line 3336 "gram.y"
                    {
			labelspec_t	*lp;
			for (lp = walk_label(W_START, LABEL_DELETE, "delete", 0); lp != NULL; lp = walk_label(W_NEXT, LABEL_DELETE, "delete", 0)) {
			    lp->flags |= LABEL_DELETE;
			}
		    }
#line 5218 "gram.tab.c"
    break;

  case 243: /* labelindomopt: TOK_INDOM TOK_ASSIGN indom_int  */
#line 3343 "gram.y"
                    {
			labelspec_t	*lp;
			for (lp = walk_label(W_START, LABEL_CHANGE_ID, "id", 0); lp != NULL; lp = walk_label(W_NEXT, LABEL_CHANGE_ID, "id", 0)) {
			    pmInDom	indom;
			    if (lp->new_id != lp->old_id) {
				pmsprintf(mess, sizeof(mess), "Duplicate label clause for indom %s", pmInDomStr(lp->old_id));
				yyerror(mess);
			    }
			    if (current_star_indom)
				indom = pmInDom_build(pmInDom_domain((yyvsp[0].indom)), pmInDom_serial(lp->old_id));
			    else
				indom = (yyvsp[0].indom);
			    if (indom != lp->old_id) {
				lp->new_id = indom;
				lp->flags |= LABEL_CHANGE_ID;
			    }
			    else {
				/* no change ... */
				if (wflag) {
				    pmsprintf(mess, sizeof(mess), "Label for instance domain %s: indom: No change", pmInDomStr(lp->old_id));
				    yywarn(mess);
				}
			    }
			}
		    }
#line 5248 "gram.tab.c"
    break;

  case 244: /* labelindomopt: TOK_LABEL TOK_ASSIGN jsonname  */
#line 3369 "gram.y"
                    {
			labelspec_t	*lp;
			for (lp = walk_label(W_START, LABEL_CHANGE_LABEL, "label", 0); lp != NULL; lp = walk_label(W_NEXT, LABEL_CHANGE_LABEL, "label", 0)) {
			    if (lp->new_label != NULL) {
				pmsprintf(mess, sizeof(mess), "Duplicate label clause for indom %s", pmInDomStr(lp->old_id));
				yyerror(mess);
			    }
			    if (lp->old_label != NULL &&
				strcmp(lp->old_label, (yyvsp[0].str)) == 0) {
				/* no change ... */
				if (wflag) {
				    pmsprintf(mess, sizeof(mess), "Label for instance domain %s: label: No change", pmInDomStr(lp->old_id));
				    yywarn(mess);
				}
				free((yyvsp[0].str));
			    }
			    else {
				lp->new_label = (yyvsp[0].str);
				lp->flags |= LABEL_CHANGE_LABEL;
			    }
			}
		    }
#line 5275 "gram.tab.c"
    break;

  case 245: /* labelindomopt: TOK_VALUE TOK_ASSIGN jsonvalue  */
#line 3392 "gram.y"
                    {
			labelspec_t	*lp;
			for (lp = walk_label(W_START, LABEL_CHANGE_VALUE, "value", 0); lp != NULL; lp = walk_label(W_NEXT, LABEL_CHANGE_VALUE, "value", 0)) {
			    if (lp->new_value != NULL) {
				pmsprintf(mess, sizeof(mess), "Duplicate label value clause for indom %s", pmInDomStr(lp->old_id));
				yyerror(mess);
			    }
			    if (lp->old_value != NULL &&
				strcmp(lp->old_value, (yyvsp[0].str)) == 0) {
				/* no change ... */
				if (wflag) {
				    pmsprintf(mess, sizeof(mess), "Label for instance domain %s: value: No change", pmInDomStr(lp->old_id));
				    yywarn(mess);
				}
				free((yyvsp[0].str));
			    }
			    else {
				lp->new_value = (yyvsp[0].str);
				lp->flags |= LABEL_CHANGE_VALUE;
			    }
			}
		    }
#line 5302 "gram.tab.c"
    break;

  case 246: /* labelindomopt: newlabelspec  */
#line 3415 "gram.y"
                    {
			new_indom_label(current_label_id);
		    }
#line 5310 "gram.tab.c"
    break;

  case 247: /* $@10: %empty  */
#line 3421 "gram.y"
                    {
			__pmContext	*ctxp;
			__pmHashCtl	*hcp1;
			__pmHashNode	*node1;

			ctxp = __pmHandleToPtr(pmWhichContext());
			assert(ctxp != NULL);
    /*
     * Note: This application is single threaded, and once we have ctxp,
     *	     the associated __pmContext will not move and will only be
     *	     accessed or modified synchronously either here or in libpcp.
     *	     We unlock the context so that it can be locked as required
     *	     within libpcp.
     */
			PM_UNLOCK(ctxp->c_lock);
			
			current_labelspec = NULL;
			current_label_id = (yyvsp[-1].indom);
			if ((yyvsp[-1].indom) == PM_ID_NULL) {
			    /* Indom is not in the archive */
			    do_walk_label = 0;
			}
			else {
			    int found = 0;
			    
			    if (current_star_indom) {
				/* Set up for indoms specified using globbing. */
				star_domain = pmInDom_domain((yyvsp[-1].indom));
			    }

			    /* We're looking for label sets for the instances of the indom(s). */
			    hcp1 = &ctxp->c_archctl->ac_log->hashlabels;
			    for (node1 = __pmHashWalk(hcp1, PM_HASH_WALK_START);
				 node1 != NULL;
				 node1 = __pmHashWalk(hcp1, PM_HASH_WALK_NEXT)) {
				__pmHashCtl	*hcp2;
				__pmHashNode	*node2;
				int		this_type;

				/* Was this object type selected? */
				this_type = (int)(node1->key);
				if (this_type != PM_LABEL_INSTANCES)
				    continue;

				/*
				 * Collect the label records associated with the specified
				 * indom instance(s).
				 */
				hcp2 = (__pmHashCtl *)(node1->data);
				for (node2 = __pmHashWalk(hcp2, PM_HASH_WALK_START);
				     node2 != NULL;
				     node2 = __pmHashWalk(hcp2, PM_HASH_WALK_NEXT)) {
				    if (current_star_indom) {
					/* Match the globbed indom spec and keep looking. */
					if (pmInDom_domain((pmID)(node2->key)) == star_domain) {
					    current_labelspec = start_label(this_type, (pmID)(node2->key),
									    current_label_instance, current_label_instance_name,
									    current_label_name, current_label_value);
					    if (current_labelspec) {
						current_labelspec->flags |= LABEL_ACTIVE;
						++found;
					    }
					}
				    }
				    else {
					/* Match the exact indom id. */
					if ((pmID)(node2->key) == (yyvsp[-1].indom)) {
					    current_labelspec = start_label(this_type, (pmID)(node2->key),
									    current_label_instance, current_label_instance_name,
									    current_label_name, current_label_value);
					    if (current_labelspec) {
						current_labelspec->flags |= LABEL_ACTIVE;
						++found;
					    }
					}
				    }
				}
			    }
			    do_walk_label = found;
			}
		    }
#line 5396 "gram.tab.c"
    break;

  case 249: /* optinstancelabeldetails: TOK_STRING optlabeldetails  */
#line 3506 "gram.y"
                    {
			current_label_instance = -1;
			current_label_instance_name = (yyvsp[-1].str);
		    }
#line 5405 "gram.tab.c"
    break;

  case 250: /* optinstancelabeldetails: TOK_NUMBER optlabeldetails  */
#line 3511 "gram.y"
                    {
			current_label_instance = atoi((yyvsp[-1].str));
			free((yyvsp[-1].str));
			current_label_instance_name = NULL;
		    }
#line 5415 "gram.tab.c"
    break;

  case 251: /* optinstancelabeldetails: TOK_LABEL_STAR optlabeldetails  */
#line 3517 "gram.y"
                    {
			current_label_instance = -1;
			current_label_instance_name = NULL;
		    }
#line 5424 "gram.tab.c"
    break;

  case 252: /* optinstancelabeldetails: %empty  */
#line 3522 "gram.y"
                    {
			current_label_instance = -1;
			current_label_instance_name = NULL;
			current_label_name = NULL;
			current_label_value = NULL;
		    }
#line 5435 "gram.tab.c"
    break;

  case 254: /* optlabelinstancesoptlist: %empty  */
#line 3532 "gram.y"
                    {
			deactivate_labels();
		    }
#line 5443 "gram.tab.c"
    break;

  case 257: /* labelinstancesopt: TOK_DELETE  */
#line 3542 "gram.y"
                    {
			labelspec_t	*lp;
			for (lp = walk_label(W_START, LABEL_DELETE, "delete", 0); lp != NULL; lp = walk_label(W_NEXT, LABEL_DELETE, "delete", 0)) {
			    lp->flags |= LABEL_DELETE;
			}
		    }
#line 5454 "gram.tab.c"
    break;

  case 258: /* labelinstancesopt: TOK_INSTANCES TOK_ASSIGN indom_int  */
#line 3549 "gram.y"
                    {
			labelspec_t	*lp;
			for (lp = walk_label(W_START, LABEL_CHANGE_ID, "id", 0); lp != NULL; lp = walk_label(W_NEXT, LABEL_CHANGE_ID, "id", 0)) {
			    pmInDom	indom;
			    if (lp->new_id != lp->old_id) {
				pmsprintf(mess, sizeof(mess), "Duplicate label clause for instances of indom %s", pmInDomStr(lp->old_id));
				yyerror(mess);
			    }
			    if (current_star_indom)
				indom = pmInDom_build(pmInDom_domain((yyvsp[0].indom)), pmInDom_serial(lp->old_id));
			    else
				indom = (yyvsp[0].indom);
			    if (indom != lp->old_id) {
				lp->new_id = indom;
				lp->flags |= LABEL_CHANGE_ID;
			    }
			    else {
				/* no change ... */
				if (wflag) {
				    pmsprintf(mess, sizeof(mess), "Label for instance domain %s: indom: No change", pmInDomStr(lp->old_id));
				    yywarn(mess);
				}
			    }
			}
		    }
#line 5484 "gram.tab.c"
    break;

  case 259: /* labelinstancesopt: TOK_INSTANCE TOK_ASSIGN TOK_NUMBER  */
#line 3575 "gram.y"
                    {
			labelspec_t	*lp;
			for (lp = walk_label(W_START, LABEL_CHANGE_ID, "id", 0); lp != NULL; lp = walk_label(W_NEXT, LABEL_CHANGE_ID, "id", 0)) {
			    int	instance;
			    if (lp->new_instance != lp->old_instance) {
				pmsprintf(mess, sizeof(mess), "Duplicate label clause for instances of indom %s", pmInDomStr(lp->old_id));
				yyerror(mess);
			    }
			    instance = atoi((yyvsp[0].str));
			    free((yyvsp[0].str));
			    if (instance != lp->old_instance) {
				lp->new_instance = instance;
				lp->flags |= LABEL_CHANGE_INSTANCE;
			    }
			    else {
				/* no change ... */
				if (wflag) {
				    pmsprintf(mess, sizeof(mess), "Label for instance domain %s instance %d: instance: No change", pmInDomStr(lp->old_id), lp->old_instance);
				    yywarn(mess);
				}
				free((yyvsp[0].str));
			    }
			}
		    }
#line 5513 "gram.tab.c"
    break;

  case 260: /* labelinstancesopt: TOK_LABEL TOK_ASSIGN jsonname  */
#line 3600 "gram.y"
                    {
			labelspec_t	*lp;
			for (lp = walk_label(W_START, LABEL_CHANGE_LABEL, "label", 0); lp != NULL; lp = walk_label(W_NEXT, LABEL_CHANGE_LABEL, "label", 0)) {
			    if (lp->new_label != NULL) {
				pmsprintf(mess, sizeof(mess), "Duplicate label clause for instances of indom %s", pmInDomStr(lp->old_id));
				yyerror(mess);
			    }
			    if (lp->old_label != NULL &&
				strcmp(lp->old_label, (yyvsp[0].str)) == 0) {
				/* no change ... */
				if (wflag) {
				    pmsprintf(mess, sizeof(mess), "Label for instances of instance domain %s: label: No change", pmInDomStr(lp->old_id));
				    yywarn(mess);
				}
				free((yyvsp[0].str));
			    }
			    else {
				lp->new_label = (yyvsp[0].str);
				lp->flags |= LABEL_CHANGE_LABEL;
			    }
			}
		    }
#line 5540 "gram.tab.c"
    break;

  case 261: /* labelinstancesopt: TOK_VALUE TOK_ASSIGN jsonvalue  */
#line 3623 "gram.y"
                    {
			labelspec_t	*lp;
			for (lp = walk_label(W_START, LABEL_CHANGE_VALUE, "value", 0); lp != NULL; lp = walk_label(W_NEXT, LABEL_CHANGE_VALUE, "value", 0)) {
			    if (lp->new_value != NULL) {
				pmsprintf(mess, sizeof(mess), "Duplicate label value clause for instances of indom %s", pmInDomStr(lp->old_id));
				yyerror(mess);
			    }
			    if (lp->old_value != NULL &&
				strcmp(lp->old_value, (yyvsp[0].str)) == 0) {
				/* no change ... */
				if (wflag) {
				    pmsprintf(mess, sizeof(mess), "Label for instances of instance domain %s: value: No change", pmInDomStr(lp->old_id));
				    yywarn(mess);
				}
				free((yyvsp[0].str));
			    }
			    else {
				lp->new_value = (yyvsp[0].str);
				lp->flags |= LABEL_CHANGE_VALUE;
			    }
			}
		    }
#line 5567 "gram.tab.c"
    break;

  case 262: /* labelinstancesopt: newlabelspec  */
#line 3646 "gram.y"
                    {
			new_indom_instance_label(current_label_id);
		    }
#line 5575 "gram.tab.c"
    break;


#line 5579 "gram.tab.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (YY_("syntax error"));
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 3651 "gram.y"

