/* Generated by wayland-scanner 1.24.0 */

#ifndef PHOC_DEVICE_STATE_UNSTABLE_V1_CLIENT_PROTOCOL_H
#define PHOC_DEVICE_STATE_UNSTABLE_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_phoc_device_state_unstable_v1 The phoc_device_state_unstable_v1 protocol
 * @section page_ifaces_phoc_device_state_unstable_v1 Interfaces
 * - @subpage page_iface_zphoc_device_state_v1 - Device state information
 * - @subpage page_iface_zphoc_tablet_mode_switch_v1 - A tablet mode switch
 * - @subpage page_iface_zphoc_lid_switch_v1 - A tablet mode switch
 * @section page_copyright_phoc_device_state_unstable_v1 Copyright
 * <pre>
 *
 * Copyright (C) 2023 Phosh.mobi e.V.
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct zphoc_device_state_v1;
struct zphoc_lid_switch_v1;
struct zphoc_tablet_mode_switch_v1;

#ifndef ZPHOC_DEVICE_STATE_V1_INTERFACE
#define ZPHOC_DEVICE_STATE_V1_INTERFACE
/**
 * @page page_iface_zphoc_device_state_v1 zphoc_device_state_v1
 * @section page_iface_zphoc_device_state_v1_desc Description
 *
 * Phones, tablets, convertibles, laptops can have additional hardware attached or switch
 * their operation mode from e.g. tablet to laptop. This protocol is meant to provide information
 * about these changes to interested clients.
 *
 * Warning! The protocol described in this file is experimental and
 * backward incompatible changes may be made. Backward compatible changes
 * may be added together with the corresponding interface version bump.
 * Backward incompatible changes are done by bumping the version number in
 * the protocol and interface names and resetting the interface version.
 * Once the protocol is to be declared stable, the 'z' prefix and the
 * version number in the protocol and interface names are removed and the
 * interface version number is reset.
 *
 * This protocol is meant to collect necessary bits before we propose an
 * upstream solution.
 * @section page_iface_zphoc_device_state_v1_api API
 * See @ref iface_zphoc_device_state_v1.
 */
/**
 * @defgroup iface_zphoc_device_state_v1 The zphoc_device_state_v1 interface
 *
 * Phones, tablets, convertibles, laptops can have additional hardware attached or switch
 * their operation mode from e.g. tablet to laptop. This protocol is meant to provide information
 * about these changes to interested clients.
 *
 * Warning! The protocol described in this file is experimental and
 * backward incompatible changes may be made. Backward compatible changes
 * may be added together with the corresponding interface version bump.
 * Backward incompatible changes are done by bumping the version number in
 * the protocol and interface names and resetting the interface version.
 * Once the protocol is to be declared stable, the 'z' prefix and the
 * version number in the protocol and interface names are removed and the
 * interface version number is reset.
 *
 * This protocol is meant to collect necessary bits before we propose an
 * upstream solution.
 */
extern const struct wl_interface zphoc_device_state_v1_interface;
#endif
#ifndef ZPHOC_TABLET_MODE_SWITCH_V1_INTERFACE
#define ZPHOC_TABLET_MODE_SWITCH_V1_INTERFACE
/**
 * @page page_iface_zphoc_tablet_mode_switch_v1 zphoc_tablet_mode_switch_v1
 * @section page_iface_zphoc_tablet_mode_switch_v1_desc Description
 *
 * The tablet_mode_switch interface represents a tablet mode switch.
 * It can have two possible values:
 *
 * The wl_pointer interface generates enabled and disabled events to indicate
 * switch state changes
 * @section page_iface_zphoc_tablet_mode_switch_v1_api API
 * See @ref iface_zphoc_tablet_mode_switch_v1.
 */
/**
 * @defgroup iface_zphoc_tablet_mode_switch_v1 The zphoc_tablet_mode_switch_v1 interface
 *
 * The tablet_mode_switch interface represents a tablet mode switch.
 * It can have two possible values:
 *
 * The wl_pointer interface generates enabled and disabled events to indicate
 * switch state changes
 */
extern const struct wl_interface zphoc_tablet_mode_switch_v1_interface;
#endif
#ifndef ZPHOC_LID_SWITCH_V1_INTERFACE
#define ZPHOC_LID_SWITCH_V1_INTERFACE
/**
 * @page page_iface_zphoc_lid_switch_v1 zphoc_lid_switch_v1
 * @section page_iface_zphoc_lid_switch_v1_desc Description
 *
 * The lid_switch interface represents a tablet mode switch.
 * It can have two possible values:
 *
 * The wl_pointer interface generates enabled and disabled events to indicate
 * switch state changes
 * @section page_iface_zphoc_lid_switch_v1_api API
 * See @ref iface_zphoc_lid_switch_v1.
 */
/**
 * @defgroup iface_zphoc_lid_switch_v1 The zphoc_lid_switch_v1 interface
 *
 * The lid_switch interface represents a tablet mode switch.
 * It can have two possible values:
 *
 * The wl_pointer interface generates enabled and disabled events to indicate
 * switch state changes
 */
extern const struct wl_interface zphoc_lid_switch_v1_interface;
#endif

#ifndef ZPHOC_DEVICE_STATE_V1_CAPABILITY_ENUM
#define ZPHOC_DEVICE_STATE_V1_CAPABILITY_ENUM
/**
 * @ingroup iface_zphoc_device_state_v1
 * Device capability bitmask
 *
 * This is a bitmask of capabilities this devices has; if a member is
 * set, then the hardware is present.
 */
enum zphoc_device_state_v1_capability {
	/**
	 * The device has a tablet mode switch
	 */
	ZPHOC_DEVICE_STATE_V1_CAPABILITY_TABLET_MODE_SWITCH = 1,
	/**
	 * The device has a lid switch
	 */
	ZPHOC_DEVICE_STATE_V1_CAPABILITY_LID_SWITCH = 2,
};
#endif /* ZPHOC_DEVICE_STATE_V1_CAPABILITY_ENUM */

#ifndef ZPHOC_DEVICE_STATE_V1_ERROR_ENUM
#define ZPHOC_DEVICE_STATE_V1_ERROR_ENUM
/**
 * @ingroup iface_zphoc_device_state_v1
 * zphoc_device_state_v1 error values
 *
 * These errors can be emitted in response to zphoc_device_state_v1 requests.
 */
enum zphoc_device_state_v1_error {
	/**
	 * get_tablet_mode_switch called on device without the matching capability
	 */
	ZPHOC_DEVICE_STATE_V1_ERROR_MISSING_CAPABILITY = 0,
};
#endif /* ZPHOC_DEVICE_STATE_V1_ERROR_ENUM */

/**
 * @ingroup iface_zphoc_device_state_v1
 * @struct zphoc_device_state_v1_listener
 */
struct zphoc_device_state_v1_listener {
	/**
	 * The device capabilitiers changed
	 *
	 * This is emitted whenever a device gains or loses a capbility.
	 * The argument is a capability enum containing the complete set of
	 * hw capabilities this device has.
	 * @param capabilities Hardware capabilities of the device
	 */
	void (*capabilities)(void *data,
			     struct zphoc_device_state_v1 *zphoc_device_state_v1,
			     uint32_t capabilities);
};

/**
 * @ingroup iface_zphoc_device_state_v1
 */
static inline int
zphoc_device_state_v1_add_listener(struct zphoc_device_state_v1 *zphoc_device_state_v1,
				   const struct zphoc_device_state_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zphoc_device_state_v1,
				     (void (**)(void)) listener, data);
}

#define ZPHOC_DEVICE_STATE_V1_GET_TABLET_MODE_SWITCH 0
#define ZPHOC_DEVICE_STATE_V1_GET_LID_SWITCH 1

/**
 * @ingroup iface_zphoc_device_state_v1
 */
#define ZPHOC_DEVICE_STATE_V1_CAPABILITIES_SINCE_VERSION 1

/**
 * @ingroup iface_zphoc_device_state_v1
 */
#define ZPHOC_DEVICE_STATE_V1_GET_TABLET_MODE_SWITCH_SINCE_VERSION 1
/**
 * @ingroup iface_zphoc_device_state_v1
 */
#define ZPHOC_DEVICE_STATE_V1_GET_LID_SWITCH_SINCE_VERSION 1

/** @ingroup iface_zphoc_device_state_v1 */
static inline void
zphoc_device_state_v1_set_user_data(struct zphoc_device_state_v1 *zphoc_device_state_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zphoc_device_state_v1, user_data);
}

/** @ingroup iface_zphoc_device_state_v1 */
static inline void *
zphoc_device_state_v1_get_user_data(struct zphoc_device_state_v1 *zphoc_device_state_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zphoc_device_state_v1);
}

static inline uint32_t
zphoc_device_state_v1_get_version(struct zphoc_device_state_v1 *zphoc_device_state_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zphoc_device_state_v1);
}

/** @ingroup iface_zphoc_device_state_v1 */
static inline void
zphoc_device_state_v1_destroy(struct zphoc_device_state_v1 *zphoc_device_state_v1)
{
	wl_proxy_destroy((struct wl_proxy *) zphoc_device_state_v1);
}

/**
 * @ingroup iface_zphoc_device_state_v1
 *
 * The ID provided will be initialized to the phoc_tablet_mode_switch interface
 * for this device
 *
 * This request only takes effect if the seat has the tablet-mode-switch
 * capability, or has had the tablet-mode-switch capability in the past.
 * It is a protocol violation to issue this request on a seat that has
 * never had the tablet-mode-switch capability. The
 * missing_capability error will be sent in this case.
 */
static inline struct zphoc_tablet_mode_switch_v1 *
zphoc_device_state_v1_get_tablet_mode_switch(struct zphoc_device_state_v1 *zphoc_device_state_v1)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) zphoc_device_state_v1,
			 ZPHOC_DEVICE_STATE_V1_GET_TABLET_MODE_SWITCH, &zphoc_tablet_mode_switch_v1_interface, wl_proxy_get_version((struct wl_proxy *) zphoc_device_state_v1), 0, NULL);

	return (struct zphoc_tablet_mode_switch_v1 *) id;
}

/**
 * @ingroup iface_zphoc_device_state_v1
 *
 * The ID provided will be initialized to the phoc_lid_switch interface
 * for this device
 *
 * This request only takes effect if the seat has the lid-switch
 * capability, or has had the lid-switch capability in the past.
 * It is a protocol violation to issue this request on a seat that has
 * never had the tablet-mode-switch capability. The
 * missing_capability error will be sent in this case.
 */
static inline struct zphoc_lid_switch_v1 *
zphoc_device_state_v1_get_lid_switch(struct zphoc_device_state_v1 *zphoc_device_state_v1)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) zphoc_device_state_v1,
			 ZPHOC_DEVICE_STATE_V1_GET_LID_SWITCH, &zphoc_lid_switch_v1_interface, wl_proxy_get_version((struct wl_proxy *) zphoc_device_state_v1), 0, NULL);

	return (struct zphoc_lid_switch_v1 *) id;
}

/**
 * @ingroup iface_zphoc_tablet_mode_switch_v1
 * @struct zphoc_tablet_mode_switch_v1_listener
 */
struct zphoc_tablet_mode_switch_v1_listener {
	/**
	 * Tablet mode got disabled
	 *
	 * 
	 */
	void (*disabled)(void *data,
			 struct zphoc_tablet_mode_switch_v1 *zphoc_tablet_mode_switch_v1);
	/**
	 * Tablet mode got enabled
	 *
	 * 
	 */
	void (*enabled)(void *data,
			struct zphoc_tablet_mode_switch_v1 *zphoc_tablet_mode_switch_v1);
};

/**
 * @ingroup iface_zphoc_tablet_mode_switch_v1
 */
static inline int
zphoc_tablet_mode_switch_v1_add_listener(struct zphoc_tablet_mode_switch_v1 *zphoc_tablet_mode_switch_v1,
					 const struct zphoc_tablet_mode_switch_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zphoc_tablet_mode_switch_v1,
				     (void (**)(void)) listener, data);
}

#define ZPHOC_TABLET_MODE_SWITCH_V1_DESTROY 0

/**
 * @ingroup iface_zphoc_tablet_mode_switch_v1
 */
#define ZPHOC_TABLET_MODE_SWITCH_V1_DISABLED_SINCE_VERSION 1
/**
 * @ingroup iface_zphoc_tablet_mode_switch_v1
 */
#define ZPHOC_TABLET_MODE_SWITCH_V1_ENABLED_SINCE_VERSION 1

/**
 * @ingroup iface_zphoc_tablet_mode_switch_v1
 */
#define ZPHOC_TABLET_MODE_SWITCH_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_zphoc_tablet_mode_switch_v1 */
static inline void
zphoc_tablet_mode_switch_v1_set_user_data(struct zphoc_tablet_mode_switch_v1 *zphoc_tablet_mode_switch_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zphoc_tablet_mode_switch_v1, user_data);
}

/** @ingroup iface_zphoc_tablet_mode_switch_v1 */
static inline void *
zphoc_tablet_mode_switch_v1_get_user_data(struct zphoc_tablet_mode_switch_v1 *zphoc_tablet_mode_switch_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zphoc_tablet_mode_switch_v1);
}

static inline uint32_t
zphoc_tablet_mode_switch_v1_get_version(struct zphoc_tablet_mode_switch_v1 *zphoc_tablet_mode_switch_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zphoc_tablet_mode_switch_v1);
}

/**
 * @ingroup iface_zphoc_tablet_mode_switch_v1
 *
 * Using this request a client can tell the server that it is not going to
 * use the switch object anymore.
 */
static inline void
zphoc_tablet_mode_switch_v1_destroy(struct zphoc_tablet_mode_switch_v1 *zphoc_tablet_mode_switch_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zphoc_tablet_mode_switch_v1,
			 ZPHOC_TABLET_MODE_SWITCH_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zphoc_tablet_mode_switch_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_zphoc_lid_switch_v1
 * @struct zphoc_lid_switch_v1_listener
 */
struct zphoc_lid_switch_v1_listener {
	/**
	 * Lid got opened
	 *
	 * 
	 */
	void (*opened)(void *data,
		       struct zphoc_lid_switch_v1 *zphoc_lid_switch_v1);
	/**
	 * Lid got closed
	 *
	 * 
	 */
	void (*closed)(void *data,
		       struct zphoc_lid_switch_v1 *zphoc_lid_switch_v1);
};

/**
 * @ingroup iface_zphoc_lid_switch_v1
 */
static inline int
zphoc_lid_switch_v1_add_listener(struct zphoc_lid_switch_v1 *zphoc_lid_switch_v1,
				 const struct zphoc_lid_switch_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zphoc_lid_switch_v1,
				     (void (**)(void)) listener, data);
}

#define ZPHOC_LID_SWITCH_V1_DESTROY 0

/**
 * @ingroup iface_zphoc_lid_switch_v1
 */
#define ZPHOC_LID_SWITCH_V1_OPENED_SINCE_VERSION 1
/**
 * @ingroup iface_zphoc_lid_switch_v1
 */
#define ZPHOC_LID_SWITCH_V1_CLOSED_SINCE_VERSION 1

/**
 * @ingroup iface_zphoc_lid_switch_v1
 */
#define ZPHOC_LID_SWITCH_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_zphoc_lid_switch_v1 */
static inline void
zphoc_lid_switch_v1_set_user_data(struct zphoc_lid_switch_v1 *zphoc_lid_switch_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zphoc_lid_switch_v1, user_data);
}

/** @ingroup iface_zphoc_lid_switch_v1 */
static inline void *
zphoc_lid_switch_v1_get_user_data(struct zphoc_lid_switch_v1 *zphoc_lid_switch_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zphoc_lid_switch_v1);
}

static inline uint32_t
zphoc_lid_switch_v1_get_version(struct zphoc_lid_switch_v1 *zphoc_lid_switch_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zphoc_lid_switch_v1);
}

/**
 * @ingroup iface_zphoc_lid_switch_v1
 *
 * Using this request a client can tell the server that it is not going to
 * use the switch object anymore.
 */
static inline void
zphoc_lid_switch_v1_destroy(struct zphoc_lid_switch_v1 *zphoc_lid_switch_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zphoc_lid_switch_v1,
			 ZPHOC_LID_SWITCH_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zphoc_lid_switch_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
