/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 * Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtNetwork.h"

#line 28 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtNetwork/qnetworkrequestfactory.sip"
#include <qnetworkrequestfactory.h>
#line 29 "/build/pyqt6/src/pyqt6-6.10.1/build/QtNetwork/sipQtNetworkQNetworkRequestFactory.cpp"

#line 26 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qurl.sip"
#include <qurl.h>
#line 33 "/build/pyqt6/src/pyqt6-6.10.1/build/QtNetwork/sipQtNetworkQNetworkRequestFactory.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtNetwork/qnetworkrequest.sip"
#include <qnetworkrequest.h>
#line 36 "/build/pyqt6/src/pyqt6-6.10.1/build/QtNetwork/sipQtNetworkQNetworkRequestFactory.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qvariant.sip"
#include <qvariant.h>
#line 39 "/build/pyqt6/src/pyqt6-6.10.1/build/QtNetwork/sipQtNetworkQNetworkRequestFactory.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qurlquery.sip"
#include <qurlquery.h>
#line 42 "/build/pyqt6/src/pyqt6-6.10.1/build/QtNetwork/sipQtNetworkQNetworkRequestFactory.cpp"
#line 27 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qpycore_std_chrono_duration.sip"
#include <chrono>
#line 45 "/build/pyqt6/src/pyqt6-6.10.1/build/QtNetwork/sipQtNetworkQNetworkRequestFactory.cpp"
#line 24 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 48 "/build/pyqt6/src/pyqt6-6.10.1/build/QtNetwork/sipQtNetworkQNetworkRequestFactory.cpp"
#line 30 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 51 "/build/pyqt6/src/pyqt6-6.10.1/build/QtNetwork/sipQtNetworkQNetworkRequestFactory.cpp"
#line 28 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtNetwork/qhttpheaders.sip"
#include <qhttpheaders.h>
#line 54 "/build/pyqt6/src/pyqt6-6.10.1/build/QtNetwork/sipQtNetworkQNetworkRequestFactory.cpp"
#line 28 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtNetwork/qsslconfiguration.sip"
#include <qsslconfiguration.h>
#line 57 "/build/pyqt6/src/pyqt6-6.10.1/build/QtNetwork/sipQtNetworkQNetworkRequestFactory.cpp"


PyDoc_STRVAR(doc_QNetworkRequestFactory_swap, "swap(self, other: QNetworkRequestFactory)");

extern "C" {static PyObject *meth_QNetworkRequestFactory_swap(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequestFactory_swap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QNetworkRequestFactory* a0;
        ::QNetworkRequestFactory *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QNetworkRequestFactory, &sipCpp, sipType_QNetworkRequestFactory, &a0))
        {
            sipCpp->swap(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequestFactory, sipName_swap, doc_QNetworkRequestFactory_swap);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequestFactory_baseUrl, "baseUrl(self) -> QUrl");

extern "C" {static PyObject *meth_QNetworkRequestFactory_baseUrl(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequestFactory_baseUrl(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkRequestFactory *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkRequestFactory, &sipCpp))
        {
            ::QUrl*sipRes;

            sipRes = new ::QUrl(sipCpp->baseUrl());

            return sipConvertFromNewType(sipRes, sipType_QUrl, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequestFactory, sipName_baseUrl, doc_QNetworkRequestFactory_baseUrl);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequestFactory_setBaseUrl, "setBaseUrl(self, url: QUrl)");

extern "C" {static PyObject *meth_QNetworkRequestFactory_setBaseUrl(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequestFactory_setBaseUrl(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QUrl* a0;
        ::QNetworkRequestFactory *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QNetworkRequestFactory, &sipCpp, sipType_QUrl, &a0))
        {
            sipCpp->setBaseUrl(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequestFactory, sipName_setBaseUrl, doc_QNetworkRequestFactory_setBaseUrl);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequestFactory_sslConfiguration, "sslConfiguration(self) -> QSslConfiguration");

extern "C" {static PyObject *meth_QNetworkRequestFactory_sslConfiguration(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequestFactory_sslConfiguration(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkRequestFactory *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkRequestFactory, &sipCpp))
        {
            ::QSslConfiguration*sipRes;

            sipRes = new ::QSslConfiguration(sipCpp->sslConfiguration());

            return sipConvertFromNewType(sipRes, sipType_QSslConfiguration, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequestFactory, sipName_sslConfiguration, doc_QNetworkRequestFactory_sslConfiguration);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequestFactory_setSslConfiguration, "setSslConfiguration(self, configuration: QSslConfiguration)");

extern "C" {static PyObject *meth_QNetworkRequestFactory_setSslConfiguration(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequestFactory_setSslConfiguration(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSslConfiguration* a0;
        ::QNetworkRequestFactory *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QNetworkRequestFactory, &sipCpp, sipType_QSslConfiguration, &a0))
        {
            sipCpp->setSslConfiguration(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequestFactory, sipName_setSslConfiguration, doc_QNetworkRequestFactory_setSslConfiguration);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequestFactory_createRequest, "createRequest(self) -> QNetworkRequest\n"
"createRequest(self, query: QUrlQuery) -> QNetworkRequest\n"
"createRequest(self, path: str|None) -> QNetworkRequest\n"
"createRequest(self, path: str|None, query: QUrlQuery) -> QNetworkRequest");

extern "C" {static PyObject *meth_QNetworkRequestFactory_createRequest(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequestFactory_createRequest(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkRequestFactory *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkRequestFactory, &sipCpp))
        {
            ::QNetworkRequest*sipRes;

            sipRes = new ::QNetworkRequest(sipCpp->createRequest());

            return sipConvertFromNewType(sipRes, sipType_QNetworkRequest, SIP_NULLPTR);
        }
    }

    {
        const ::QUrlQuery* a0;
        const ::QNetworkRequestFactory *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QNetworkRequestFactory, &sipCpp, sipType_QUrlQuery, &a0))
        {
            ::QNetworkRequest*sipRes;

            sipRes = new ::QNetworkRequest(sipCpp->createRequest(*a0));

            return sipConvertFromNewType(sipRes, sipType_QNetworkRequest, SIP_NULLPTR);
        }
    }

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QNetworkRequestFactory *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QNetworkRequestFactory, &sipCpp, sipType_QString, &a0, &a0State))
        {
            ::QNetworkRequest*sipRes;

            sipRes = new ::QNetworkRequest(sipCpp->createRequest(*a0));
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipConvertFromNewType(sipRes, sipType_QNetworkRequest, SIP_NULLPTR);
        }
    }

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QUrlQuery* a1;
        const ::QNetworkRequestFactory *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1J9", &sipSelf, sipType_QNetworkRequestFactory, &sipCpp, sipType_QString, &a0, &a0State, sipType_QUrlQuery, &a1))
        {
            ::QNetworkRequest*sipRes;

            sipRes = new ::QNetworkRequest(sipCpp->createRequest(*a0, *a1));
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipConvertFromNewType(sipRes, sipType_QNetworkRequest, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequestFactory, sipName_createRequest, doc_QNetworkRequestFactory_createRequest);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequestFactory_setCommonHeaders, "setCommonHeaders(self, headers: QHttpHeaders)");

extern "C" {static PyObject *meth_QNetworkRequestFactory_setCommonHeaders(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequestFactory_setCommonHeaders(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QHttpHeaders* a0;
        ::QNetworkRequestFactory *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QNetworkRequestFactory, &sipCpp, sipType_QHttpHeaders, &a0))
        {
            sipCpp->setCommonHeaders(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequestFactory, sipName_setCommonHeaders, doc_QNetworkRequestFactory_setCommonHeaders);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequestFactory_commonHeaders, "commonHeaders(self) -> QHttpHeaders");

extern "C" {static PyObject *meth_QNetworkRequestFactory_commonHeaders(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequestFactory_commonHeaders(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkRequestFactory *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkRequestFactory, &sipCpp))
        {
            ::QHttpHeaders*sipRes;

            sipRes = new ::QHttpHeaders(sipCpp->commonHeaders());

            return sipConvertFromNewType(sipRes, sipType_QHttpHeaders, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequestFactory, sipName_commonHeaders, doc_QNetworkRequestFactory_commonHeaders);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequestFactory_clearCommonHeaders, "clearCommonHeaders(self)");

extern "C" {static PyObject *meth_QNetworkRequestFactory_clearCommonHeaders(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequestFactory_clearCommonHeaders(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QNetworkRequestFactory *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkRequestFactory, &sipCpp))
        {
            sipCpp->clearCommonHeaders();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequestFactory, sipName_clearCommonHeaders, doc_QNetworkRequestFactory_clearCommonHeaders);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequestFactory_bearerToken, "bearerToken(self) -> QByteArray");

extern "C" {static PyObject *meth_QNetworkRequestFactory_bearerToken(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequestFactory_bearerToken(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkRequestFactory *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkRequestFactory, &sipCpp))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(sipCpp->bearerToken());

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequestFactory, sipName_bearerToken, doc_QNetworkRequestFactory_bearerToken);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequestFactory_setBearerToken, "setBearerToken(self, token: QByteArray|bytes|bytearray|memoryview)");

extern "C" {static PyObject *meth_QNetworkRequestFactory_setBearerToken(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequestFactory_setBearerToken(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray* a0;
        int a0State = 0;
        ::QNetworkRequestFactory *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QNetworkRequestFactory, &sipCpp, sipType_QByteArray, &a0, &a0State))
        {
            sipCpp->setBearerToken(*a0);
            sipReleaseType(const_cast< ::QByteArray *>(a0), sipType_QByteArray, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequestFactory, sipName_setBearerToken, doc_QNetworkRequestFactory_setBearerToken);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequestFactory_clearBearerToken, "clearBearerToken(self)");

extern "C" {static PyObject *meth_QNetworkRequestFactory_clearBearerToken(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequestFactory_clearBearerToken(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QNetworkRequestFactory *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkRequestFactory, &sipCpp))
        {
            sipCpp->clearBearerToken();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequestFactory, sipName_clearBearerToken, doc_QNetworkRequestFactory_clearBearerToken);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequestFactory_userName, "userName(self) -> str");

extern "C" {static PyObject *meth_QNetworkRequestFactory_userName(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequestFactory_userName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkRequestFactory *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkRequestFactory, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->userName());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequestFactory, sipName_userName, doc_QNetworkRequestFactory_userName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequestFactory_setUserName, "setUserName(self, userName: str|None)");

extern "C" {static PyObject *meth_QNetworkRequestFactory_setUserName(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequestFactory_setUserName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QNetworkRequestFactory *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QNetworkRequestFactory, &sipCpp, sipType_QString, &a0, &a0State))
        {
            sipCpp->setUserName(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequestFactory, sipName_setUserName, doc_QNetworkRequestFactory_setUserName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequestFactory_clearUserName, "clearUserName(self)");

extern "C" {static PyObject *meth_QNetworkRequestFactory_clearUserName(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequestFactory_clearUserName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QNetworkRequestFactory *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkRequestFactory, &sipCpp))
        {
            sipCpp->clearUserName();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequestFactory, sipName_clearUserName, doc_QNetworkRequestFactory_clearUserName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequestFactory_password, "password(self) -> str");

extern "C" {static PyObject *meth_QNetworkRequestFactory_password(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequestFactory_password(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkRequestFactory *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkRequestFactory, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->password());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequestFactory, sipName_password, doc_QNetworkRequestFactory_password);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequestFactory_setPassword, "setPassword(self, password: str|None)");

extern "C" {static PyObject *meth_QNetworkRequestFactory_setPassword(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequestFactory_setPassword(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QNetworkRequestFactory *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QNetworkRequestFactory, &sipCpp, sipType_QString, &a0, &a0State))
        {
            sipCpp->setPassword(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequestFactory, sipName_setPassword, doc_QNetworkRequestFactory_setPassword);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequestFactory_clearPassword, "clearPassword(self)");

extern "C" {static PyObject *meth_QNetworkRequestFactory_clearPassword(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequestFactory_clearPassword(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QNetworkRequestFactory *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkRequestFactory, &sipCpp))
        {
            sipCpp->clearPassword();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequestFactory, sipName_clearPassword, doc_QNetworkRequestFactory_clearPassword);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequestFactory_setTransferTimeout, "setTransferTimeout(self, timeout: int)");

extern "C" {static PyObject *meth_QNetworkRequestFactory_setTransferTimeout(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequestFactory_setTransferTimeout(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::std::chrono::milliseconds* a0;
        int a0State = 0;
        ::QNetworkRequestFactory *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QNetworkRequestFactory, &sipCpp, sipType_std_chrono_milliseconds, &a0, &a0State))
        {
            sipCpp->setTransferTimeout(*a0);
            sipReleaseType(a0, sipType_std_chrono_milliseconds, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequestFactory, sipName_setTransferTimeout, doc_QNetworkRequestFactory_setTransferTimeout);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequestFactory_transferTimeout, "transferTimeout(self) -> int");

extern "C" {static PyObject *meth_QNetworkRequestFactory_transferTimeout(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequestFactory_transferTimeout(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkRequestFactory *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkRequestFactory, &sipCpp))
        {
            ::std::chrono::milliseconds*sipRes;

            sipRes = new ::std::chrono::milliseconds(sipCpp->transferTimeout());

            return sipConvertFromNewType(sipRes, sipType_std_chrono_milliseconds, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequestFactory, sipName_transferTimeout, doc_QNetworkRequestFactory_transferTimeout);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequestFactory_queryParameters, "queryParameters(self) -> QUrlQuery");

extern "C" {static PyObject *meth_QNetworkRequestFactory_queryParameters(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequestFactory_queryParameters(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkRequestFactory *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkRequestFactory, &sipCpp))
        {
            ::QUrlQuery*sipRes;

            sipRes = new ::QUrlQuery(sipCpp->queryParameters());

            return sipConvertFromNewType(sipRes, sipType_QUrlQuery, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequestFactory, sipName_queryParameters, doc_QNetworkRequestFactory_queryParameters);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequestFactory_setQueryParameters, "setQueryParameters(self, query: QUrlQuery)");

extern "C" {static PyObject *meth_QNetworkRequestFactory_setQueryParameters(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequestFactory_setQueryParameters(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QUrlQuery* a0;
        ::QNetworkRequestFactory *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QNetworkRequestFactory, &sipCpp, sipType_QUrlQuery, &a0))
        {
            sipCpp->setQueryParameters(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequestFactory, sipName_setQueryParameters, doc_QNetworkRequestFactory_setQueryParameters);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequestFactory_clearQueryParameters, "clearQueryParameters(self)");

extern "C" {static PyObject *meth_QNetworkRequestFactory_clearQueryParameters(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequestFactory_clearQueryParameters(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QNetworkRequestFactory *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkRequestFactory, &sipCpp))
        {
            sipCpp->clearQueryParameters();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequestFactory, sipName_clearQueryParameters, doc_QNetworkRequestFactory_clearQueryParameters);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequestFactory_setPriority, "setPriority(self, priority: QNetworkRequest.Priority)");

extern "C" {static PyObject *meth_QNetworkRequestFactory_setPriority(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequestFactory_setPriority(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QNetworkRequest::Priority a0;
        ::QNetworkRequestFactory *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QNetworkRequestFactory, &sipCpp, sipType_QNetworkRequest_Priority, &a0))
        {
            sipCpp->setPriority(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequestFactory, sipName_setPriority, doc_QNetworkRequestFactory_setPriority);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequestFactory_priority, "priority(self) -> QNetworkRequest.Priority");

extern "C" {static PyObject *meth_QNetworkRequestFactory_priority(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequestFactory_priority(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkRequestFactory *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkRequestFactory, &sipCpp))
        {
            ::QNetworkRequest::Priority sipRes;

            sipRes = sipCpp->priority();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QNetworkRequest_Priority);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequestFactory, sipName_priority, doc_QNetworkRequestFactory_priority);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequestFactory_attribute, "attribute(self, attribute: QNetworkRequest.Attribute) -> Any\n"
"attribute(self, attribute: QNetworkRequest.Attribute, defaultValue: Any) -> Any");

extern "C" {static PyObject *meth_QNetworkRequestFactory_attribute(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequestFactory_attribute(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QNetworkRequest::Attribute a0;
        const ::QNetworkRequestFactory *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QNetworkRequestFactory, &sipCpp, sipType_QNetworkRequest_Attribute, &a0))
        {
            ::QVariant*sipRes;

            sipRes = new ::QVariant(sipCpp->attribute(a0));

            return sipConvertFromNewType(sipRes, sipType_QVariant, SIP_NULLPTR);
        }
    }

    {
        ::QNetworkRequest::Attribute a0;
        const ::QVariant* a1;
        int a1State = 0;
        const ::QNetworkRequestFactory *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BEJ1", &sipSelf, sipType_QNetworkRequestFactory, &sipCpp, sipType_QNetworkRequest_Attribute, &a0, sipType_QVariant, &a1, &a1State))
        {
            ::QVariant*sipRes;

            sipRes = new ::QVariant(sipCpp->attribute(a0, *a1));
            sipReleaseType(const_cast< ::QVariant *>(a1), sipType_QVariant, a1State);

            return sipConvertFromNewType(sipRes, sipType_QVariant, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequestFactory, sipName_attribute, doc_QNetworkRequestFactory_attribute);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequestFactory_setAttribute, "setAttribute(self, attribute: QNetworkRequest.Attribute, value: Any)");

extern "C" {static PyObject *meth_QNetworkRequestFactory_setAttribute(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequestFactory_setAttribute(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QNetworkRequest::Attribute a0;
        const ::QVariant* a1;
        int a1State = 0;
        ::QNetworkRequestFactory *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BEJ1", &sipSelf, sipType_QNetworkRequestFactory, &sipCpp, sipType_QNetworkRequest_Attribute, &a0, sipType_QVariant, &a1, &a1State))
        {
            sipCpp->setAttribute(a0, *a1);
            sipReleaseType(const_cast< ::QVariant *>(a1), sipType_QVariant, a1State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequestFactory, sipName_setAttribute, doc_QNetworkRequestFactory_setAttribute);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequestFactory_clearAttribute, "clearAttribute(self, attribute: QNetworkRequest.Attribute)");

extern "C" {static PyObject *meth_QNetworkRequestFactory_clearAttribute(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequestFactory_clearAttribute(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QNetworkRequest::Attribute a0;
        ::QNetworkRequestFactory *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QNetworkRequestFactory, &sipCpp, sipType_QNetworkRequest_Attribute, &a0))
        {
            sipCpp->clearAttribute(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequestFactory, sipName_clearAttribute, doc_QNetworkRequestFactory_clearAttribute);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequestFactory_clearAttributes, "clearAttributes(self)");

extern "C" {static PyObject *meth_QNetworkRequestFactory_clearAttributes(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequestFactory_clearAttributes(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QNetworkRequestFactory *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkRequestFactory, &sipCpp))
        {
            sipCpp->clearAttributes();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequestFactory, sipName_clearAttributes, doc_QNetworkRequestFactory_clearAttributes);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QNetworkRequestFactory(void *, int);}
static void release_QNetworkRequestFactory(void *sipCppV, int)
{
    delete reinterpret_cast< ::QNetworkRequestFactory *>(sipCppV);
}


extern "C" {static void *array_QNetworkRequestFactory(Py_ssize_t);}
static void *array_QNetworkRequestFactory(Py_ssize_t sipNrElem)
{
    return new ::QNetworkRequestFactory[sipNrElem];
}


extern "C" {static void array_delete_QNetworkRequestFactory(void *);}
static void array_delete_QNetworkRequestFactory(void *sipCpp)
{
    delete[] reinterpret_cast< ::QNetworkRequestFactory *>(sipCpp);
}


extern "C" {static void assign_QNetworkRequestFactory(void *, Py_ssize_t, void *);}
static void assign_QNetworkRequestFactory(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QNetworkRequestFactory *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QNetworkRequestFactory *>(sipSrc);
}


extern "C" {static void *copy_QNetworkRequestFactory(const void *, Py_ssize_t);}
static void *copy_QNetworkRequestFactory(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QNetworkRequestFactory(reinterpret_cast<const ::QNetworkRequestFactory *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QNetworkRequestFactory(sipSimpleWrapper *);}
static void dealloc_QNetworkRequestFactory(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QNetworkRequestFactory(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QNetworkRequestFactory(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QNetworkRequestFactory(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QNetworkRequestFactory *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QNetworkRequestFactory();

            return sipCpp;
        }
    }

    {
        const ::QUrl* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QUrl, &a0))
        {
            sipCpp = new ::QNetworkRequestFactory(*a0);

            return sipCpp;
        }
    }

    {
        const ::QNetworkRequestFactory* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QNetworkRequestFactory, &a0))
        {
            sipCpp = new ::QNetworkRequestFactory(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QNetworkRequestFactory[] = {
    {sipName_attribute, meth_QNetworkRequestFactory_attribute, METH_VARARGS, doc_QNetworkRequestFactory_attribute},
    {sipName_baseUrl, meth_QNetworkRequestFactory_baseUrl, METH_VARARGS, doc_QNetworkRequestFactory_baseUrl},
    {sipName_bearerToken, meth_QNetworkRequestFactory_bearerToken, METH_VARARGS, doc_QNetworkRequestFactory_bearerToken},
    {sipName_clearAttribute, meth_QNetworkRequestFactory_clearAttribute, METH_VARARGS, doc_QNetworkRequestFactory_clearAttribute},
    {sipName_clearAttributes, meth_QNetworkRequestFactory_clearAttributes, METH_VARARGS, doc_QNetworkRequestFactory_clearAttributes},
    {sipName_clearBearerToken, meth_QNetworkRequestFactory_clearBearerToken, METH_VARARGS, doc_QNetworkRequestFactory_clearBearerToken},
    {sipName_clearCommonHeaders, meth_QNetworkRequestFactory_clearCommonHeaders, METH_VARARGS, doc_QNetworkRequestFactory_clearCommonHeaders},
    {sipName_clearPassword, meth_QNetworkRequestFactory_clearPassword, METH_VARARGS, doc_QNetworkRequestFactory_clearPassword},
    {sipName_clearQueryParameters, meth_QNetworkRequestFactory_clearQueryParameters, METH_VARARGS, doc_QNetworkRequestFactory_clearQueryParameters},
    {sipName_clearUserName, meth_QNetworkRequestFactory_clearUserName, METH_VARARGS, doc_QNetworkRequestFactory_clearUserName},
    {sipName_commonHeaders, meth_QNetworkRequestFactory_commonHeaders, METH_VARARGS, doc_QNetworkRequestFactory_commonHeaders},
    {sipName_createRequest, meth_QNetworkRequestFactory_createRequest, METH_VARARGS, doc_QNetworkRequestFactory_createRequest},
    {sipName_password, meth_QNetworkRequestFactory_password, METH_VARARGS, doc_QNetworkRequestFactory_password},
    {sipName_priority, meth_QNetworkRequestFactory_priority, METH_VARARGS, doc_QNetworkRequestFactory_priority},
    {sipName_queryParameters, meth_QNetworkRequestFactory_queryParameters, METH_VARARGS, doc_QNetworkRequestFactory_queryParameters},
    {sipName_setAttribute, meth_QNetworkRequestFactory_setAttribute, METH_VARARGS, doc_QNetworkRequestFactory_setAttribute},
    {sipName_setBaseUrl, meth_QNetworkRequestFactory_setBaseUrl, METH_VARARGS, doc_QNetworkRequestFactory_setBaseUrl},
    {sipName_setBearerToken, meth_QNetworkRequestFactory_setBearerToken, METH_VARARGS, doc_QNetworkRequestFactory_setBearerToken},
    {sipName_setCommonHeaders, meth_QNetworkRequestFactory_setCommonHeaders, METH_VARARGS, doc_QNetworkRequestFactory_setCommonHeaders},
    {sipName_setPassword, meth_QNetworkRequestFactory_setPassword, METH_VARARGS, doc_QNetworkRequestFactory_setPassword},
    {sipName_setPriority, meth_QNetworkRequestFactory_setPriority, METH_VARARGS, doc_QNetworkRequestFactory_setPriority},
    {sipName_setQueryParameters, meth_QNetworkRequestFactory_setQueryParameters, METH_VARARGS, doc_QNetworkRequestFactory_setQueryParameters},
    {sipName_setSslConfiguration, meth_QNetworkRequestFactory_setSslConfiguration, METH_VARARGS, doc_QNetworkRequestFactory_setSslConfiguration},
    {sipName_setTransferTimeout, meth_QNetworkRequestFactory_setTransferTimeout, METH_VARARGS, doc_QNetworkRequestFactory_setTransferTimeout},
    {sipName_setUserName, meth_QNetworkRequestFactory_setUserName, METH_VARARGS, doc_QNetworkRequestFactory_setUserName},
    {sipName_sslConfiguration, meth_QNetworkRequestFactory_sslConfiguration, METH_VARARGS, doc_QNetworkRequestFactory_sslConfiguration},
    {sipName_swap, meth_QNetworkRequestFactory_swap, METH_VARARGS, doc_QNetworkRequestFactory_swap},
    {sipName_transferTimeout, meth_QNetworkRequestFactory_transferTimeout, METH_VARARGS, doc_QNetworkRequestFactory_transferTimeout},
    {sipName_userName, meth_QNetworkRequestFactory_userName, METH_VARARGS, doc_QNetworkRequestFactory_userName}
};

PyDoc_STRVAR(doc_QNetworkRequestFactory, "\1QNetworkRequestFactory()\n"
"QNetworkRequestFactory(baseUrl: QUrl)\n"
"QNetworkRequestFactory(other: QNetworkRequestFactory)");


sipClassTypeDef sipTypeDef_QtNetwork_QNetworkRequestFactory = {
    {
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QNetworkRequestFactory,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_QNetworkRequestFactory,
        {0, 0, 1},
        29, methods_QNetworkRequestFactory,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QNetworkRequestFactory,
    -1,
    sipNameNr_PyQt6_sip_simplewrapper,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QNetworkRequestFactory,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QNetworkRequestFactory,
    assign_QNetworkRequestFactory,
    array_QNetworkRequestFactory,
    copy_QNetworkRequestFactory,
    release_QNetworkRequestFactory,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QNetworkRequestFactory,
    sizeof (::QNetworkRequestFactory),
};
