// Copyright © 2023-2025 Advanced Micro Devices, Inc.
// SPDX-License-Identifier: MIT

#include "../iface.op_attn_bwd.h"
// #include <aotriton/cpp_tune.h>  // TODO: add op_tune
#include <string_view>
#ifndef NDEBUG
#include <iostream>
#endif

#define CURRENT_ENTRY_PUBLIC Optune_op_attn_bwd__A9__F353

#define ARRAY_SIZE(array)  (sizeof(array) / sizeof(array[0]))

namespace { // Anonymous namespace

using namespace std::literals::string_view_literals;

static int8_t lut[1][10][10] =
{
// GPU gfx1201_mod0
{{1,1,1,1,1,0,1,1,1,1},
 {1,1,0,1,1,0,1,1,0,0},
 {1,0,1,1,1,1,0,1,1,1},
 {1,1,1,1,0,1,1,1,1,0},
 {1,1,1,1,1,0,1,1,0,1},
 {1,1,1,1,1,1,1,1,0,1},
 {1,0,1,1,1,0,1,1,1,0},
 {1,1,1,1,1,1,1,1,1,0},
 {1,1,0,0,1,1,1,1,1,1},
 {1,1,1,1,0,1,0,1,1,1}}
// End of GPU gfx1201_mod0
}
;

}; // End of anonymous namespace

namespace AOTRITON_NS::v3::flash::optune {

void CURRENT_ENTRY_PUBLIC(OpAttnBwdContext& context, int mod_number) {
    auto backend_index = op_attn_bwd__lut_lambda__0(*context.params, mod_number, lut);
    if (backend_index < 0) {
        return ;
    }
    context.backend_index = static_cast<OpAttnBwdContext::BackendEnum>(backend_index);
}

#undef CURRENT_ENTRY_PUBLIC
}

// Human-readable Signature 
// Q = "*bf16:16"
// sm_scale = "fp32"
// DQ_ACC = "*fp32:16"
// L = "*fp32:16"
// num_head_q = "i32"
// cu_seqlens_q = "*i32:16"
// num_seqlens = "i32"
// dropout_p = 0
// philox_seed_ptr = 0
// philox_offset1 = 0
// philox_offset2 = 0
// Window_left = 0
// BLOCK_DMODEL = 256
// CAUSAL_TYPE = 0
// ENABLE_DROPOUT = False
// PADDED_HEAD = False
// BIAS_TYPE = 1

// vim: set fileencoding=utf-8

