/* s3 compat server functions auto-generated by pidl */
#include "bin/default/librpc/gen_ndr/ndr_srvsvc.h"
#include "bin/default/librpc/gen_ndr/ndr_srvsvc_scompat.h"
#include <librpc/rpc/dcesrv_core.h>
#include <rpc_server/rpc_config.h>
#include <rpc_server/rpc_server.h>
#include <util/debug.h>

enum s3compat_rpc_dispatch {
	S3COMPAT_RPC_DISPATCH_EXTERNAL = 0x00000001,
	S3COMPAT_RPC_DISPATCH_INTERNAL = 0x00000002,
};

/* srvsvc - dcerpc server boilerplate generated by pidl */
static NTSTATUS srvsvc__op_bind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_SRVSVC_BIND
	return DCESRV_INTERFACE_SRVSVC_BIND(context,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void srvsvc__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_SRVSVC_UNBIND
	DCESRV_INTERFACE_SRVSVC_UNBIND(context, iface);
#else
	return;
#endif
}

NTSTATUS srvsvc__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= ndr_table_srvsvc.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx, ndr_table_srvsvc.calls[opnum].struct_size, "struct %s", ndr_table_srvsvc.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

	/* unravel the NDR for the packet */
	ndr_err = ndr_table_srvsvc.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS srvsvc__op_dispatch_internal(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r, enum s3compat_rpc_dispatch dispatch)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;
	struct pipes_struct *p = NULL;
	NTSTATUS status = NT_STATUS_OK;
	bool impersonated = false;

	/* Retrieve pipes struct */
	p = dcesrv_get_pipes_struct(dce_call->conn);
	p->dce_call = dce_call;
	p->mem_ctx = mem_ctx;
	/* Reset pipes struct fault state */
	p->fault_state = 0;

	/* Impersonate */
	if (dispatch == S3COMPAT_RPC_DISPATCH_EXTERNAL) {
		impersonated = become_authenticated_pipe_user(dce_call->auth_state->session_info);
		if (!impersonated) {
			dce_call->fault_code = DCERPC_FAULT_ACCESS_DENIED;
			status = NT_STATUS_NET_WRITE_FAULT;
			goto fail;
		}
	}

	switch (opnum) {
	case 0: { /* srvsvc_NetCharDevEnum */
		struct srvsvc_NetCharDevEnum *r2 = (struct srvsvc_NetCharDevEnum *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetCharDevEnum, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info_ctr = r2->in.info_ctr;
		r2->out.resume_handle = r2->in.resume_handle;
		r2->out.totalentries = talloc_zero(r2, uint32_t);
		if (r2->out.totalentries == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _srvsvc_NetCharDevEnum(p, r2);
		break;
	}
	case 1: { /* srvsvc_NetCharDevGetInfo */
		struct srvsvc_NetCharDevGetInfo *r2 = (struct srvsvc_NetCharDevGetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetCharDevGetInfo, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = talloc_zero(r2, union srvsvc_NetCharDevInfo);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _srvsvc_NetCharDevGetInfo(p, r2);
		break;
	}
	case 2: { /* srvsvc_NetCharDevControl */
		struct srvsvc_NetCharDevControl *r2 = (struct srvsvc_NetCharDevControl *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetCharDevControl, NDR_IN, r2);
		}
		r2->out.result = _srvsvc_NetCharDevControl(p, r2);
		break;
	}
	case 3: { /* srvsvc_NetCharDevQEnum */
		struct srvsvc_NetCharDevQEnum *r2 = (struct srvsvc_NetCharDevQEnum *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetCharDevQEnum, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info_ctr = r2->in.info_ctr;
		r2->out.resume_handle = r2->in.resume_handle;
		r2->out.totalentries = talloc_zero(r2, uint32_t);
		if (r2->out.totalentries == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _srvsvc_NetCharDevQEnum(p, r2);
		break;
	}
	case 4: { /* srvsvc_NetCharDevQGetInfo */
		struct srvsvc_NetCharDevQGetInfo *r2 = (struct srvsvc_NetCharDevQGetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetCharDevQGetInfo, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = talloc_zero(r2, union srvsvc_NetCharDevQInfo);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _srvsvc_NetCharDevQGetInfo(p, r2);
		break;
	}
	case 5: { /* srvsvc_NetCharDevQSetInfo */
		struct srvsvc_NetCharDevQSetInfo *r2 = (struct srvsvc_NetCharDevQSetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetCharDevQSetInfo, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.parm_error = r2->in.parm_error;
		r2->out.result = _srvsvc_NetCharDevQSetInfo(p, r2);
		break;
	}
	case 6: { /* srvsvc_NetCharDevQPurge */
		struct srvsvc_NetCharDevQPurge *r2 = (struct srvsvc_NetCharDevQPurge *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetCharDevQPurge, NDR_IN, r2);
		}
		r2->out.result = _srvsvc_NetCharDevQPurge(p, r2);
		break;
	}
	case 7: { /* srvsvc_NetCharDevQPurgeSelf */
		struct srvsvc_NetCharDevQPurgeSelf *r2 = (struct srvsvc_NetCharDevQPurgeSelf *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetCharDevQPurgeSelf, NDR_IN, r2);
		}
		r2->out.result = _srvsvc_NetCharDevQPurgeSelf(p, r2);
		break;
	}
	case 8: { /* srvsvc_NetConnEnum */
		struct srvsvc_NetConnEnum *r2 = (struct srvsvc_NetConnEnum *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetConnEnum, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info_ctr = r2->in.info_ctr;
		r2->out.resume_handle = r2->in.resume_handle;
		r2->out.totalentries = talloc_zero(r2, uint32_t);
		if (r2->out.totalentries == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _srvsvc_NetConnEnum(p, r2);
		break;
	}
	case 9: { /* srvsvc_NetFileEnum */
		struct srvsvc_NetFileEnum *r2 = (struct srvsvc_NetFileEnum *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetFileEnum, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info_ctr = r2->in.info_ctr;
		r2->out.resume_handle = r2->in.resume_handle;
		r2->out.totalentries = talloc_zero(r2, uint32_t);
		if (r2->out.totalentries == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _srvsvc_NetFileEnum(p, r2);
		break;
	}
	case 10: { /* srvsvc_NetFileGetInfo */
		struct srvsvc_NetFileGetInfo *r2 = (struct srvsvc_NetFileGetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetFileGetInfo, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = talloc_zero(r2, union srvsvc_NetFileInfo);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _srvsvc_NetFileGetInfo(p, r2);
		break;
	}
	case 11: { /* srvsvc_NetFileClose */
		struct srvsvc_NetFileClose *r2 = (struct srvsvc_NetFileClose *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetFileClose, NDR_IN, r2);
		}
		r2->out.result = _srvsvc_NetFileClose(p, r2);
		break;
	}
	case 12: { /* srvsvc_NetSessEnum */
		struct srvsvc_NetSessEnum *r2 = (struct srvsvc_NetSessEnum *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetSessEnum, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info_ctr = r2->in.info_ctr;
		r2->out.resume_handle = r2->in.resume_handle;
		r2->out.totalentries = talloc_zero(r2, uint32_t);
		if (r2->out.totalentries == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _srvsvc_NetSessEnum(p, r2);
		break;
	}
	case 13: { /* srvsvc_NetSessDel */
		struct srvsvc_NetSessDel *r2 = (struct srvsvc_NetSessDel *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetSessDel, NDR_IN, r2);
		}
		r2->out.result = _srvsvc_NetSessDel(p, r2);
		break;
	}
	case 14: { /* srvsvc_NetShareAdd */
		struct srvsvc_NetShareAdd *r2 = (struct srvsvc_NetShareAdd *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareAdd, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.parm_error = r2->in.parm_error;
		r2->out.result = _srvsvc_NetShareAdd(p, r2);
		break;
	}
	case 15: { /* srvsvc_NetShareEnumAll */
		struct srvsvc_NetShareEnumAll *r2 = (struct srvsvc_NetShareEnumAll *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareEnumAll, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info_ctr = r2->in.info_ctr;
		r2->out.resume_handle = r2->in.resume_handle;
		r2->out.totalentries = talloc_zero(r2, uint32_t);
		if (r2->out.totalentries == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _srvsvc_NetShareEnumAll(p, r2);
		break;
	}
	case 16: { /* srvsvc_NetShareGetInfo */
		struct srvsvc_NetShareGetInfo *r2 = (struct srvsvc_NetShareGetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareGetInfo, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = talloc_zero(r2, union srvsvc_NetShareInfo);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _srvsvc_NetShareGetInfo(p, r2);
		break;
	}
	case 17: { /* srvsvc_NetShareSetInfo */
		struct srvsvc_NetShareSetInfo *r2 = (struct srvsvc_NetShareSetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareSetInfo, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.parm_error = r2->in.parm_error;
		r2->out.result = _srvsvc_NetShareSetInfo(p, r2);
		break;
	}
	case 18: { /* srvsvc_NetShareDel */
		struct srvsvc_NetShareDel *r2 = (struct srvsvc_NetShareDel *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareDel, NDR_IN, r2);
		}
		r2->out.result = _srvsvc_NetShareDel(p, r2);
		break;
	}
	case 19: { /* srvsvc_NetShareDelSticky */
		struct srvsvc_NetShareDelSticky *r2 = (struct srvsvc_NetShareDelSticky *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareDelSticky, NDR_IN, r2);
		}
		r2->out.result = _srvsvc_NetShareDelSticky(p, r2);
		break;
	}
	case 20: { /* srvsvc_NetShareCheck */
		struct srvsvc_NetShareCheck *r2 = (struct srvsvc_NetShareCheck *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareCheck, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.type = talloc_zero(r2, enum srvsvc_ShareType);
		if (r2->out.type == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _srvsvc_NetShareCheck(p, r2);
		break;
	}
	case 21: { /* srvsvc_NetSrvGetInfo */
		struct srvsvc_NetSrvGetInfo *r2 = (struct srvsvc_NetSrvGetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetSrvGetInfo, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = talloc_zero(r2, union srvsvc_NetSrvInfo);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _srvsvc_NetSrvGetInfo(p, r2);
		break;
	}
	case 22: { /* srvsvc_NetSrvSetInfo */
		struct srvsvc_NetSrvSetInfo *r2 = (struct srvsvc_NetSrvSetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetSrvSetInfo, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.parm_error = r2->in.parm_error;
		r2->out.result = _srvsvc_NetSrvSetInfo(p, r2);
		break;
	}
	case 23: { /* srvsvc_NetDiskEnum */
		struct srvsvc_NetDiskEnum *r2 = (struct srvsvc_NetDiskEnum *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetDiskEnum, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = r2->in.info;
		r2->out.resume_handle = r2->in.resume_handle;
		r2->out.totalentries = talloc_zero(r2, uint32_t);
		if (r2->out.totalentries == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _srvsvc_NetDiskEnum(p, r2);
		break;
	}
	case 24: { /* srvsvc_NetServerStatisticsGet */
		struct srvsvc_NetServerStatisticsGet *r2 = (struct srvsvc_NetServerStatisticsGet *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetServerStatisticsGet, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.stats = talloc_zero(r2, struct srvsvc_Statistics *);
		if (r2->out.stats == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _srvsvc_NetServerStatisticsGet(p, r2);
		break;
	}
	case 25: { /* srvsvc_NetTransportAdd */
		struct srvsvc_NetTransportAdd *r2 = (struct srvsvc_NetTransportAdd *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetTransportAdd, NDR_IN, r2);
		}
		r2->out.result = _srvsvc_NetTransportAdd(p, r2);
		break;
	}
	case 26: { /* srvsvc_NetTransportEnum */
		struct srvsvc_NetTransportEnum *r2 = (struct srvsvc_NetTransportEnum *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetTransportEnum, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.transports = r2->in.transports;
		r2->out.resume_handle = r2->in.resume_handle;
		r2->out.totalentries = talloc_zero(r2, uint32_t);
		if (r2->out.totalentries == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _srvsvc_NetTransportEnum(p, r2);
		break;
	}
	case 27: { /* srvsvc_NetTransportDel */
		struct srvsvc_NetTransportDel *r2 = (struct srvsvc_NetTransportDel *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetTransportDel, NDR_IN, r2);
		}
		r2->out.result = _srvsvc_NetTransportDel(p, r2);
		break;
	}
	case 28: { /* srvsvc_NetRemoteTOD */
		struct srvsvc_NetRemoteTOD *r2 = (struct srvsvc_NetRemoteTOD *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetRemoteTOD, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = talloc_zero(r2, struct srvsvc_NetRemoteTODInfo *);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _srvsvc_NetRemoteTOD(p, r2);
		break;
	}
	case 29: { /* srvsvc_NetSetServiceBits */
		struct srvsvc_NetSetServiceBits *r2 = (struct srvsvc_NetSetServiceBits *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetSetServiceBits, NDR_IN, r2);
		}
		r2->out.result = _srvsvc_NetSetServiceBits(p, r2);
		break;
	}
	case 30: { /* srvsvc_NetPathType */
		struct srvsvc_NetPathType *r2 = (struct srvsvc_NetPathType *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetPathType, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pathtype = talloc_zero(r2, uint32_t);
		if (r2->out.pathtype == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _srvsvc_NetPathType(p, r2);
		break;
	}
	case 31: { /* srvsvc_NetPathCanonicalize */
		struct srvsvc_NetPathCanonicalize *r2 = (struct srvsvc_NetPathCanonicalize *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetPathCanonicalize, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pathtype = r2->in.pathtype;
		r2->out.can_path = talloc_zero_array(r2, uint8_t, r2->in.maxbuf);
		if (r2->out.can_path == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _srvsvc_NetPathCanonicalize(p, r2);
		break;
	}
	case 32: { /* srvsvc_NetPathCompare */
		struct srvsvc_NetPathCompare *r2 = (struct srvsvc_NetPathCompare *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetPathCompare, NDR_IN, r2);
		}
		r2->out.result = _srvsvc_NetPathCompare(p, r2);
		break;
	}
	case 33: { /* srvsvc_NetNameValidate */
		struct srvsvc_NetNameValidate *r2 = (struct srvsvc_NetNameValidate *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetNameValidate, NDR_IN, r2);
		}
		r2->out.result = _srvsvc_NetNameValidate(p, r2);
		break;
	}
	case 34: { /* srvsvc_NETRPRNAMECANONICALIZE */
		struct srvsvc_NETRPRNAMECANONICALIZE *r2 = (struct srvsvc_NETRPRNAMECANONICALIZE *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRPRNAMECANONICALIZE, NDR_IN, r2);
		}
		r2->out.result = _srvsvc_NETRPRNAMECANONICALIZE(p, r2);
		break;
	}
	case 35: { /* srvsvc_NetPRNameCompare */
		struct srvsvc_NetPRNameCompare *r2 = (struct srvsvc_NetPRNameCompare *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetPRNameCompare, NDR_IN, r2);
		}
		r2->out.result = _srvsvc_NetPRNameCompare(p, r2);
		break;
	}
	case 36: { /* srvsvc_NetShareEnum */
		struct srvsvc_NetShareEnum *r2 = (struct srvsvc_NetShareEnum *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareEnum, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info_ctr = r2->in.info_ctr;
		r2->out.resume_handle = r2->in.resume_handle;
		r2->out.totalentries = talloc_zero(r2, uint32_t);
		if (r2->out.totalentries == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _srvsvc_NetShareEnum(p, r2);
		break;
	}
	case 37: { /* srvsvc_NetShareDelStart */
		struct srvsvc_NetShareDelStart *r2 = (struct srvsvc_NetShareDelStart *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareDelStart, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.hnd = talloc_zero(r2, struct policy_handle);
		if (r2->out.hnd == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _srvsvc_NetShareDelStart(p, r2);
		break;
	}
	case 38: { /* srvsvc_NetShareDelCommit */
		struct srvsvc_NetShareDelCommit *r2 = (struct srvsvc_NetShareDelCommit *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareDelCommit, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.hnd = r2->in.hnd;
		r2->out.result = _srvsvc_NetShareDelCommit(p, r2);
		break;
	}
	case 39: { /* srvsvc_NetGetFileSecurity */
		struct srvsvc_NetGetFileSecurity *r2 = (struct srvsvc_NetGetFileSecurity *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetGetFileSecurity, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.sd_buf = talloc_zero(r2, struct sec_desc_buf *);
		if (r2->out.sd_buf == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _srvsvc_NetGetFileSecurity(p, r2);
		break;
	}
	case 40: { /* srvsvc_NetSetFileSecurity */
		struct srvsvc_NetSetFileSecurity *r2 = (struct srvsvc_NetSetFileSecurity *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetSetFileSecurity, NDR_IN, r2);
		}
		r2->out.result = _srvsvc_NetSetFileSecurity(p, r2);
		break;
	}
	case 41: { /* srvsvc_NetServerTransportAddEx */
		struct srvsvc_NetServerTransportAddEx *r2 = (struct srvsvc_NetServerTransportAddEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetServerTransportAddEx, NDR_IN, r2);
		}
		r2->out.result = _srvsvc_NetServerTransportAddEx(p, r2);
		break;
	}
	case 42: { /* srvsvc_NetServerSetServiceBitsEx */
		struct srvsvc_NetServerSetServiceBitsEx *r2 = (struct srvsvc_NetServerSetServiceBitsEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetServerSetServiceBitsEx, NDR_IN, r2);
		}
		r2->out.result = _srvsvc_NetServerSetServiceBitsEx(p, r2);
		break;
	}
	case 43: { /* srvsvc_NETRDFSGETVERSION */
		struct srvsvc_NETRDFSGETVERSION *r2 = (struct srvsvc_NETRDFSGETVERSION *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSGETVERSION, NDR_IN, r2);
		}
		r2->out.result = _srvsvc_NETRDFSGETVERSION(p, r2);
		break;
	}
	case 44: { /* srvsvc_NETRDFSCREATELOCALPARTITION */
		struct srvsvc_NETRDFSCREATELOCALPARTITION *r2 = (struct srvsvc_NETRDFSCREATELOCALPARTITION *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSCREATELOCALPARTITION, NDR_IN, r2);
		}
		r2->out.result = _srvsvc_NETRDFSCREATELOCALPARTITION(p, r2);
		break;
	}
	case 45: { /* srvsvc_NETRDFSDELETELOCALPARTITION */
		struct srvsvc_NETRDFSDELETELOCALPARTITION *r2 = (struct srvsvc_NETRDFSDELETELOCALPARTITION *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSDELETELOCALPARTITION, NDR_IN, r2);
		}
		r2->out.result = _srvsvc_NETRDFSDELETELOCALPARTITION(p, r2);
		break;
	}
	case 46: { /* srvsvc_NETRDFSSETLOCALVOLUMESTATE */
		struct srvsvc_NETRDFSSETLOCALVOLUMESTATE *r2 = (struct srvsvc_NETRDFSSETLOCALVOLUMESTATE *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSSETLOCALVOLUMESTATE, NDR_IN, r2);
		}
		r2->out.result = _srvsvc_NETRDFSSETLOCALVOLUMESTATE(p, r2);
		break;
	}
	case 47: { /* srvsvc_NETRDFSSETSERVERINFO */
		struct srvsvc_NETRDFSSETSERVERINFO *r2 = (struct srvsvc_NETRDFSSETSERVERINFO *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSSETSERVERINFO, NDR_IN, r2);
		}
		r2->out.result = _srvsvc_NETRDFSSETSERVERINFO(p, r2);
		break;
	}
	case 48: { /* srvsvc_NETRDFSCREATEEXITPOINT */
		struct srvsvc_NETRDFSCREATEEXITPOINT *r2 = (struct srvsvc_NETRDFSCREATEEXITPOINT *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSCREATEEXITPOINT, NDR_IN, r2);
		}
		r2->out.result = _srvsvc_NETRDFSCREATEEXITPOINT(p, r2);
		break;
	}
	case 49: { /* srvsvc_NETRDFSDELETEEXITPOINT */
		struct srvsvc_NETRDFSDELETEEXITPOINT *r2 = (struct srvsvc_NETRDFSDELETEEXITPOINT *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSDELETEEXITPOINT, NDR_IN, r2);
		}
		r2->out.result = _srvsvc_NETRDFSDELETEEXITPOINT(p, r2);
		break;
	}
	case 50: { /* srvsvc_NETRDFSMODIFYPREFIX */
		struct srvsvc_NETRDFSMODIFYPREFIX *r2 = (struct srvsvc_NETRDFSMODIFYPREFIX *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSMODIFYPREFIX, NDR_IN, r2);
		}
		r2->out.result = _srvsvc_NETRDFSMODIFYPREFIX(p, r2);
		break;
	}
	case 51: { /* srvsvc_NETRDFSFIXLOCALVOLUME */
		struct srvsvc_NETRDFSFIXLOCALVOLUME *r2 = (struct srvsvc_NETRDFSFIXLOCALVOLUME *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSFIXLOCALVOLUME, NDR_IN, r2);
		}
		r2->out.result = _srvsvc_NETRDFSFIXLOCALVOLUME(p, r2);
		break;
	}
	case 52: { /* srvsvc_NETRDFSMANAGERREPORTSITEINFO */
		struct srvsvc_NETRDFSMANAGERREPORTSITEINFO *r2 = (struct srvsvc_NETRDFSMANAGERREPORTSITEINFO *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSMANAGERREPORTSITEINFO, NDR_IN, r2);
		}
		r2->out.result = _srvsvc_NETRDFSMANAGERREPORTSITEINFO(p, r2);
		break;
	}
	case 53: { /* srvsvc_NETRSERVERTRANSPORTDELEX */
		struct srvsvc_NETRSERVERTRANSPORTDELEX *r2 = (struct srvsvc_NETRSERVERTRANSPORTDELEX *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRSERVERTRANSPORTDELEX, NDR_IN, r2);
		}
		r2->out.result = _srvsvc_NETRSERVERTRANSPORTDELEX(p, r2);
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

fail:
	/* Unimpersonate */
	if (impersonated) {
		unbecome_authenticated_pipe_user();
	}

	p->dce_call = NULL;
	p->mem_ctx = NULL;
	/* Check pipes struct fault state */
	if (p->fault_state != 0) {
		dce_call->fault_code = p->fault_state;
	}
	if (dce_call->fault_code != 0) {
		status = NT_STATUS_NET_WRITE_FAULT;
	}

	return status;
}

NTSTATUS srvsvc__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return srvsvc__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_EXTERNAL);
}

NTSTATUS srvsvc__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: { /* srvsvc_NetCharDevEnum */
		struct srvsvc_NetCharDevEnum *r2 = (struct srvsvc_NetCharDevEnum *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetCharDevEnum replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetCharDevEnum, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetCharDevEnum\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 1: { /* srvsvc_NetCharDevGetInfo */
		struct srvsvc_NetCharDevGetInfo *r2 = (struct srvsvc_NetCharDevGetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetCharDevGetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetCharDevGetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetCharDevGetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 2: { /* srvsvc_NetCharDevControl */
		struct srvsvc_NetCharDevControl *r2 = (struct srvsvc_NetCharDevControl *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetCharDevControl replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetCharDevControl, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetCharDevControl\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 3: { /* srvsvc_NetCharDevQEnum */
		struct srvsvc_NetCharDevQEnum *r2 = (struct srvsvc_NetCharDevQEnum *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetCharDevQEnum replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetCharDevQEnum, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetCharDevQEnum\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 4: { /* srvsvc_NetCharDevQGetInfo */
		struct srvsvc_NetCharDevQGetInfo *r2 = (struct srvsvc_NetCharDevQGetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetCharDevQGetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetCharDevQGetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetCharDevQGetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 5: { /* srvsvc_NetCharDevQSetInfo */
		struct srvsvc_NetCharDevQSetInfo *r2 = (struct srvsvc_NetCharDevQSetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetCharDevQSetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetCharDevQSetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetCharDevQSetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 6: { /* srvsvc_NetCharDevQPurge */
		struct srvsvc_NetCharDevQPurge *r2 = (struct srvsvc_NetCharDevQPurge *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetCharDevQPurge replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetCharDevQPurge, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetCharDevQPurge\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 7: { /* srvsvc_NetCharDevQPurgeSelf */
		struct srvsvc_NetCharDevQPurgeSelf *r2 = (struct srvsvc_NetCharDevQPurgeSelf *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetCharDevQPurgeSelf replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetCharDevQPurgeSelf, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetCharDevQPurgeSelf\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 8: { /* srvsvc_NetConnEnum */
		struct srvsvc_NetConnEnum *r2 = (struct srvsvc_NetConnEnum *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetConnEnum replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetConnEnum, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetConnEnum\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 9: { /* srvsvc_NetFileEnum */
		struct srvsvc_NetFileEnum *r2 = (struct srvsvc_NetFileEnum *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetFileEnum replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetFileEnum, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetFileEnum\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 10: { /* srvsvc_NetFileGetInfo */
		struct srvsvc_NetFileGetInfo *r2 = (struct srvsvc_NetFileGetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetFileGetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetFileGetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetFileGetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 11: { /* srvsvc_NetFileClose */
		struct srvsvc_NetFileClose *r2 = (struct srvsvc_NetFileClose *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetFileClose replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetFileClose, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetFileClose\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 12: { /* srvsvc_NetSessEnum */
		struct srvsvc_NetSessEnum *r2 = (struct srvsvc_NetSessEnum *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetSessEnum replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetSessEnum, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetSessEnum\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 13: { /* srvsvc_NetSessDel */
		struct srvsvc_NetSessDel *r2 = (struct srvsvc_NetSessDel *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetSessDel replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetSessDel, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetSessDel\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 14: { /* srvsvc_NetShareAdd */
		struct srvsvc_NetShareAdd *r2 = (struct srvsvc_NetShareAdd *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetShareAdd replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareAdd, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetShareAdd\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 15: { /* srvsvc_NetShareEnumAll */
		struct srvsvc_NetShareEnumAll *r2 = (struct srvsvc_NetShareEnumAll *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetShareEnumAll replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareEnumAll, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetShareEnumAll\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 16: { /* srvsvc_NetShareGetInfo */
		struct srvsvc_NetShareGetInfo *r2 = (struct srvsvc_NetShareGetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetShareGetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareGetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetShareGetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 17: { /* srvsvc_NetShareSetInfo */
		struct srvsvc_NetShareSetInfo *r2 = (struct srvsvc_NetShareSetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetShareSetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareSetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetShareSetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 18: { /* srvsvc_NetShareDel */
		struct srvsvc_NetShareDel *r2 = (struct srvsvc_NetShareDel *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetShareDel replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareDel, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetShareDel\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 19: { /* srvsvc_NetShareDelSticky */
		struct srvsvc_NetShareDelSticky *r2 = (struct srvsvc_NetShareDelSticky *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetShareDelSticky replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareDelSticky, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetShareDelSticky\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 20: { /* srvsvc_NetShareCheck */
		struct srvsvc_NetShareCheck *r2 = (struct srvsvc_NetShareCheck *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetShareCheck replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareCheck, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetShareCheck\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 21: { /* srvsvc_NetSrvGetInfo */
		struct srvsvc_NetSrvGetInfo *r2 = (struct srvsvc_NetSrvGetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetSrvGetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetSrvGetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetSrvGetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 22: { /* srvsvc_NetSrvSetInfo */
		struct srvsvc_NetSrvSetInfo *r2 = (struct srvsvc_NetSrvSetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetSrvSetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetSrvSetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetSrvSetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 23: { /* srvsvc_NetDiskEnum */
		struct srvsvc_NetDiskEnum *r2 = (struct srvsvc_NetDiskEnum *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetDiskEnum replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetDiskEnum, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetDiskEnum\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 24: { /* srvsvc_NetServerStatisticsGet */
		struct srvsvc_NetServerStatisticsGet *r2 = (struct srvsvc_NetServerStatisticsGet *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetServerStatisticsGet replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetServerStatisticsGet, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetServerStatisticsGet\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 25: { /* srvsvc_NetTransportAdd */
		struct srvsvc_NetTransportAdd *r2 = (struct srvsvc_NetTransportAdd *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetTransportAdd replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetTransportAdd, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetTransportAdd\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 26: { /* srvsvc_NetTransportEnum */
		struct srvsvc_NetTransportEnum *r2 = (struct srvsvc_NetTransportEnum *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetTransportEnum replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetTransportEnum, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetTransportEnum\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 27: { /* srvsvc_NetTransportDel */
		struct srvsvc_NetTransportDel *r2 = (struct srvsvc_NetTransportDel *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetTransportDel replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetTransportDel, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetTransportDel\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 28: { /* srvsvc_NetRemoteTOD */
		struct srvsvc_NetRemoteTOD *r2 = (struct srvsvc_NetRemoteTOD *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetRemoteTOD replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetRemoteTOD, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetRemoteTOD\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 29: { /* srvsvc_NetSetServiceBits */
		struct srvsvc_NetSetServiceBits *r2 = (struct srvsvc_NetSetServiceBits *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetSetServiceBits replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetSetServiceBits, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetSetServiceBits\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 30: { /* srvsvc_NetPathType */
		struct srvsvc_NetPathType *r2 = (struct srvsvc_NetPathType *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetPathType replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetPathType, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetPathType\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 31: { /* srvsvc_NetPathCanonicalize */
		struct srvsvc_NetPathCanonicalize *r2 = (struct srvsvc_NetPathCanonicalize *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetPathCanonicalize replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetPathCanonicalize, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetPathCanonicalize\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 32: { /* srvsvc_NetPathCompare */
		struct srvsvc_NetPathCompare *r2 = (struct srvsvc_NetPathCompare *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetPathCompare replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetPathCompare, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetPathCompare\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 33: { /* srvsvc_NetNameValidate */
		struct srvsvc_NetNameValidate *r2 = (struct srvsvc_NetNameValidate *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetNameValidate replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetNameValidate, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetNameValidate\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 34: { /* srvsvc_NETRPRNAMECANONICALIZE */
		struct srvsvc_NETRPRNAMECANONICALIZE *r2 = (struct srvsvc_NETRPRNAMECANONICALIZE *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRPRNAMECANONICALIZE replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRPRNAMECANONICALIZE, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NETRPRNAMECANONICALIZE\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 35: { /* srvsvc_NetPRNameCompare */
		struct srvsvc_NetPRNameCompare *r2 = (struct srvsvc_NetPRNameCompare *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetPRNameCompare replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetPRNameCompare, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetPRNameCompare\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 36: { /* srvsvc_NetShareEnum */
		struct srvsvc_NetShareEnum *r2 = (struct srvsvc_NetShareEnum *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetShareEnum replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareEnum, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetShareEnum\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 37: { /* srvsvc_NetShareDelStart */
		struct srvsvc_NetShareDelStart *r2 = (struct srvsvc_NetShareDelStart *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetShareDelStart replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareDelStart, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetShareDelStart\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 38: { /* srvsvc_NetShareDelCommit */
		struct srvsvc_NetShareDelCommit *r2 = (struct srvsvc_NetShareDelCommit *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetShareDelCommit replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareDelCommit, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetShareDelCommit\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 39: { /* srvsvc_NetGetFileSecurity */
		struct srvsvc_NetGetFileSecurity *r2 = (struct srvsvc_NetGetFileSecurity *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetGetFileSecurity replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetGetFileSecurity, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetGetFileSecurity\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 40: { /* srvsvc_NetSetFileSecurity */
		struct srvsvc_NetSetFileSecurity *r2 = (struct srvsvc_NetSetFileSecurity *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetSetFileSecurity replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetSetFileSecurity, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetSetFileSecurity\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 41: { /* srvsvc_NetServerTransportAddEx */
		struct srvsvc_NetServerTransportAddEx *r2 = (struct srvsvc_NetServerTransportAddEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetServerTransportAddEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetServerTransportAddEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetServerTransportAddEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 42: { /* srvsvc_NetServerSetServiceBitsEx */
		struct srvsvc_NetServerSetServiceBitsEx *r2 = (struct srvsvc_NetServerSetServiceBitsEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetServerSetServiceBitsEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetServerSetServiceBitsEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NetServerSetServiceBitsEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 43: { /* srvsvc_NETRDFSGETVERSION */
		struct srvsvc_NETRDFSGETVERSION *r2 = (struct srvsvc_NETRDFSGETVERSION *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRDFSGETVERSION replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSGETVERSION, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NETRDFSGETVERSION\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 44: { /* srvsvc_NETRDFSCREATELOCALPARTITION */
		struct srvsvc_NETRDFSCREATELOCALPARTITION *r2 = (struct srvsvc_NETRDFSCREATELOCALPARTITION *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRDFSCREATELOCALPARTITION replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSCREATELOCALPARTITION, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NETRDFSCREATELOCALPARTITION\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 45: { /* srvsvc_NETRDFSDELETELOCALPARTITION */
		struct srvsvc_NETRDFSDELETELOCALPARTITION *r2 = (struct srvsvc_NETRDFSDELETELOCALPARTITION *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRDFSDELETELOCALPARTITION replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSDELETELOCALPARTITION, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NETRDFSDELETELOCALPARTITION\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 46: { /* srvsvc_NETRDFSSETLOCALVOLUMESTATE */
		struct srvsvc_NETRDFSSETLOCALVOLUMESTATE *r2 = (struct srvsvc_NETRDFSSETLOCALVOLUMESTATE *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRDFSSETLOCALVOLUMESTATE replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSSETLOCALVOLUMESTATE, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NETRDFSSETLOCALVOLUMESTATE\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 47: { /* srvsvc_NETRDFSSETSERVERINFO */
		struct srvsvc_NETRDFSSETSERVERINFO *r2 = (struct srvsvc_NETRDFSSETSERVERINFO *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRDFSSETSERVERINFO replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSSETSERVERINFO, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NETRDFSSETSERVERINFO\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 48: { /* srvsvc_NETRDFSCREATEEXITPOINT */
		struct srvsvc_NETRDFSCREATEEXITPOINT *r2 = (struct srvsvc_NETRDFSCREATEEXITPOINT *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRDFSCREATEEXITPOINT replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSCREATEEXITPOINT, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NETRDFSCREATEEXITPOINT\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 49: { /* srvsvc_NETRDFSDELETEEXITPOINT */
		struct srvsvc_NETRDFSDELETEEXITPOINT *r2 = (struct srvsvc_NETRDFSDELETEEXITPOINT *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRDFSDELETEEXITPOINT replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSDELETEEXITPOINT, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NETRDFSDELETEEXITPOINT\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 50: { /* srvsvc_NETRDFSMODIFYPREFIX */
		struct srvsvc_NETRDFSMODIFYPREFIX *r2 = (struct srvsvc_NETRDFSMODIFYPREFIX *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRDFSMODIFYPREFIX replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSMODIFYPREFIX, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NETRDFSMODIFYPREFIX\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 51: { /* srvsvc_NETRDFSFIXLOCALVOLUME */
		struct srvsvc_NETRDFSFIXLOCALVOLUME *r2 = (struct srvsvc_NETRDFSFIXLOCALVOLUME *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRDFSFIXLOCALVOLUME replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSFIXLOCALVOLUME, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NETRDFSFIXLOCALVOLUME\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 52: { /* srvsvc_NETRDFSMANAGERREPORTSITEINFO */
		struct srvsvc_NETRDFSMANAGERREPORTSITEINFO *r2 = (struct srvsvc_NETRDFSMANAGERREPORTSITEINFO *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRDFSMANAGERREPORTSITEINFO replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSMANAGERREPORTSITEINFO, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NETRDFSMANAGERREPORTSITEINFO\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 53: { /* srvsvc_NETRSERVERTRANSPORTDELEX */
		struct srvsvc_NETRSERVERTRANSPORTDELEX *r2 = (struct srvsvc_NETRSERVERTRANSPORTDELEX *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRSERVERTRANSPORTDELEX replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRSERVERTRANSPORTDELEX, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in srvsvc_NETRSERVERTRANSPORTDELEX\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS srvsvc__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	ndr_err = ndr_table_srvsvc.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS srvsvc__op_local(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return srvsvc__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_INTERNAL);
}

static const struct dcesrv_interface dcesrv_srvsvc_interface = {
	.name      = "srvsvc",
	.syntax_id = {{0x4b324fc8,0x1670,0x01d3,{0x12,0x78},{0x5a,0x47,0xbf,0x6e,0xe1,0x88}},3.0},
	.bind      = srvsvc__op_bind,
	.unbind    = srvsvc__op_unbind,
	.ndr_pull  = srvsvc__op_ndr_pull,
	.dispatch  = srvsvc__op_dispatch,
	.reply     = srvsvc__op_reply,
	.ndr_push  = srvsvc__op_ndr_push,
	.local     = srvsvc__op_local,
#ifdef DCESRV_INTERFACE_SRVSVC_FLAGS
	.flags     = DCESRV_INTERFACE_SRVSVC_FLAGS
#else
	.flags     = 0
#endif
};

static NTSTATUS srvsvc__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	uint32_t i;
	NTSTATUS ret;

#ifdef DCESRV_INTERFACE_SRVSVC_NCACN_NP_SECONDARY_ENDPOINT
	const char *ncacn_np_secondary_endpoint = DCESRV_INTERFACE_SRVSVC_NCACN_NP_SECONDARY_ENDPOINT;
#else
	const char *ncacn_np_secondary_endpoint = NULL;
#endif

	for (i=0;i<ndr_table_srvsvc.endpoints->count;i++) {
		const char *name = ndr_table_srvsvc.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, ncacn_np_secondary_endpoint, &dcesrv_srvsvc_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DBG_ERR("Failed to register endpoint '%s'\n",name);
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static NTSTATUS srvsvc__op_shutdown_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	return NT_STATUS_OK;
}

static bool srvsvc__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_srvsvc_interface.syntax_id.if_version == if_version && GUID_equal(&dcesrv_srvsvc_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_srvsvc_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool srvsvc__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_srvsvc_interface.name, name)==0) {
		memcpy(iface, &dcesrv_srvsvc_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static const struct dcesrv_endpoint_server srvsvc_ep_server = {
	/* fill in our name */
	.name = "srvsvc",

	/* Initialization flag */
	.initialized = false,

	/* fill in all the operations */
#ifdef DCESRV_INTERFACE_SRVSVC_INIT_SERVER
	.init_server = DCESRV_INTERFACE_SRVSVC_INIT_SERVER,
#else
	.init_server = srvsvc__op_init_server,
#endif
#ifdef DCESRV_INTERFACE_SRVSVC_SHUTDOWN_SERVER
	.shutdown_server = DCESRV_INTERFACE_SRVSVC_SHUTDOWN_SERVER,
#else
	.shutdown_server = srvsvc__op_shutdown_server,
#endif
	.interface_by_uuid = srvsvc__op_interface_by_uuid,
	.interface_by_name = srvsvc__op_interface_by_name
};

const struct dcesrv_endpoint_server *srvsvc_get_ep_server(void)
{
	return &srvsvc_ep_server;
}
