
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_drsuapi.h"
#include "bin/default/librpc/gen_ndr/ndr_drsuapi_c.h"

/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

#include "librpc/gen_ndr/security.h"
#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/lsa.h"
#include "librpc/gen_ndr/samr.h"
static PyTypeObject drsuapi_DsBindInfo24_Type;
static PyTypeObject drsuapi_DsBindInfo28_Type;
static PyTypeObject drsuapi_DsBindInfo32_Type;
static PyTypeObject drsuapi_DsBindInfo48_Type;
static PyTypeObject drsuapi_DsBindInfo52_Type;
static PyTypeObject drsuapi_DsBindInfoFallBack_Type;
static PyTypeObject drsuapi_DsBindInfo_Type;
static PyTypeObject drsuapi_DsBindInfoCtr_Type;
static PyTypeObject drsuapi_DsReplicaObjectIdentifier_Type;
static PyTypeObject drsuapi_DsReplicaSyncRequest1_Type;
static PyTypeObject drsuapi_DsReplicaSyncRequest_Type;
static PyTypeObject drsuapi_DsReplicaHighWaterMark_Type;
static PyTypeObject drsuapi_DsReplicaCursor_Type;
static PyTypeObject drsuapi_DsReplicaCursorCtrEx_Type;
static PyTypeObject drsuapi_DsGetNCChangesRequest5_Type;
static PyTypeObject drsuapi_DsReplicaOID_Type;
static PyTypeObject drsuapi_DsReplicaOIDMapping_Type;
static PyTypeObject drsuapi_DsReplicaOIDMapping_Ctr_Type;
static PyTypeObject drsuapi_DsPartialAttributeSet_Type;
static PyTypeObject drsuapi_DsGetNCChangesRequest8_Type;
static PyTypeObject drsuapi_DsGetNCChangesRequest10_Type;
static PyTypeObject drsuapi_DsGetNCChangesRequest_Type;
static PyTypeObject drsuapi_DsReplicaCursor2_Type;
static PyTypeObject drsuapi_DsReplicaCursor2CtrEx_Type;
static PyTypeObject drsuapi_DsAttributeValue_Type;
static PyTypeObject drsuapi_DsAttributeValueCtr_Type;
static PyTypeObject drsuapi_DsReplicaObjectIdentifier3_Type;
static PyTypeObject drsuapi_DsReplicaObjectIdentifier3Binary_Type;
static PyTypeObject drsuapi_DsReplicaAttribute_Type;
static PyTypeObject drsuapi_DsReplicaAttributeCtr_Type;
static PyTypeObject drsuapi_DsReplicaObject_Type;
static PyTypeObject drsuapi_DsReplicaMetaData_Type;
static PyTypeObject drsuapi_DsReplicaMetaDataCtr_Type;
static PyTypeObject drsuapi_DsReplicaObjectListItemEx_Type;
static PyTypeObject drsuapi_DsGetNCChangesCtr1_Type;
static PyTypeObject drsuapi_DsReplicaLinkedAttribute_Type;
static PyTypeObject drsuapi_DsGetNCChangesCtr6_Type;
static PyTypeObject drsuapi_DsGetNCChangesCtr1TS_Type;
static PyTypeObject drsuapi_DsGetNCChangesCtr6TS_Type;
static PyTypeObject drsuapi_DsGetNCChangesMSZIPCtr1_Type;
static PyTypeObject drsuapi_DsGetNCChangesMSZIPCtr6_Type;
static PyTypeObject drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1_Type;
static PyTypeObject drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6_Type;
static PyTypeObject drsuapi_DsGetNCChangesCompressedCtr_Type;
static PyTypeObject drsuapi_DsGetNCChangesCtr2_Type;
static PyTypeObject drsuapi_DsGetNCChangesCtr7_Type;
static PyTypeObject drsuapi_DsGetNCChangesCtr_Type;
static PyTypeObject drsuapi_DsReplicaUpdateRefsRequest1_Type;
static PyTypeObject drsuapi_DsReplicaUpdateRefsRequest_Type;
static PyTypeObject drsuapi_DsReplicaAddRequest1_Type;
static PyTypeObject drsuapi_DsReplicaAddRequest2_Type;
static PyTypeObject drsuapi_DsReplicaAddRequest_Type;
static PyTypeObject drsuapi_DsReplicaDelRequest1_Type;
static PyTypeObject drsuapi_DsReplicaDelRequest_Type;
static PyTypeObject drsuapi_DsReplicaModRequest1_Type;
static PyTypeObject drsuapi_DsReplicaModRequest_Type;
static PyTypeObject drsuapi_DsGetMembershipsCtr1_Type;
static PyTypeObject drsuapi_DsGetMembershipsCtr_Type;
static PyTypeObject drsuapi_DsGetMembershipsRequest1_Type;
static PyTypeObject drsuapi_DsGetMembershipsRequest_Type;
static PyTypeObject drsuapi_DsGetNT4ChangeLogRequest1_Type;
static PyTypeObject drsuapi_DsGetNT4ChangeLogRequest_Type;
static PyTypeObject drsuapi_DsGetNT4ChangeLogInfo1_Type;
static PyTypeObject drsuapi_DsGetNT4ChangeLogInfo_Type;
static PyTypeObject drsuapi_DsNameString_Type;
static PyTypeObject drsuapi_DsNameRequest1_Type;
static PyTypeObject drsuapi_DsNameRequest_Type;
static PyTypeObject drsuapi_DsNameInfo1_Type;
static PyTypeObject drsuapi_DsNameCtr1_Type;
static PyTypeObject drsuapi_DsNameCtr_Type;
static PyTypeObject drsuapi_DsWriteAccountSpnRequest1_Type;
static PyTypeObject drsuapi_DsWriteAccountSpnRequest_Type;
static PyTypeObject drsuapi_DsWriteAccountSpnResult1_Type;
static PyTypeObject drsuapi_DsWriteAccountSpnResult_Type;
static PyTypeObject drsuapi_DsRemoveDSServerRequest1_Type;
static PyTypeObject drsuapi_DsRemoveDSServerRequest_Type;
static PyTypeObject drsuapi_DsRemoveDSServerResult1_Type;
static PyTypeObject drsuapi_DsRemoveDSServerResult_Type;
static PyTypeObject drsuapi_DsGetDCInfoRequest1_Type;
static PyTypeObject drsuapi_DsGetDCInfoRequest_Type;
static PyTypeObject drsuapi_DsGetDCInfo1_Type;
static PyTypeObject drsuapi_DsGetDCInfoCtr1_Type;
static PyTypeObject drsuapi_DsGetDCInfo2_Type;
static PyTypeObject drsuapi_DsGetDCInfoCtr2_Type;
static PyTypeObject drsuapi_DsGetDCInfo3_Type;
static PyTypeObject drsuapi_DsGetDCInfoCtr3_Type;
static PyTypeObject drsuapi_DsGetDCConnection01_Type;
static PyTypeObject drsuapi_DsGetDCConnectionCtr01_Type;
static PyTypeObject drsuapi_DsGetDCInfoCtr_Type;
static PyTypeObject drsuapi_DsReplicaObjectListItem_Type;
static PyTypeObject drsuapi_DsAddEntryRequest2_Type;
static PyTypeObject drsuapi_SecBuffer_Type;
static PyTypeObject drsuapi_SecBufferDesc_Type;
static PyTypeObject drsuapi_DsAddEntryRequest3_Type;
static PyTypeObject drsuapi_DsAddEntryRequest_Type;
static PyTypeObject drsuapi_DsAddEntryErrorInfoX_Type;
static PyTypeObject drsuapi_DsAddEntry_AttrErr_V1_Type;
static PyTypeObject drsuapi_DsAddEntry_AttrErrListItem_V1_Type;
static PyTypeObject drsuapi_DsAddEntryErrorInfo_Attr_V1_Type;
static PyTypeObject drsuapi_DsAddEntryErrorInfo_Name_V1_Type;
static PyTypeObject drsuapi_NameResOp_V1_Type;
static PyTypeObject drsuapi_DsaAddressListItem_V1_Type;
static PyTypeObject drsuapi_DsAddEntry_RefErrListItem_V1_Type;
static PyTypeObject drsuapi_DsAddEntryErrorInfo_Referr_V1_Type;
static PyTypeObject drsuapi_DsAddEntryErrorInfo_Type;
static PyTypeObject drsuapi_DsAddEntry_ErrData_V1_Type;
static PyTypeObject drsuapi_DsAddEntry_ErrData_Type;
static PyTypeObject drsuapi_DsReplicaObjectIdentifier2_Type;
static PyTypeObject drsuapi_DsAddEntryCtr2_Type;
static PyTypeObject drsuapi_DsAddEntryCtr3_Type;
static PyTypeObject drsuapi_DsAddEntryCtr_Type;
static PyTypeObject drsuapi_DsExecuteKCC1_Type;
static PyTypeObject drsuapi_DsExecuteKCCRequest_Type;
static PyTypeObject drsuapi_DsReplicaGetInfoRequest1_Type;
static PyTypeObject drsuapi_DsReplicaGetInfoRequest2_Type;
static PyTypeObject drsuapi_DsReplicaGetInfoRequest_Type;
static PyTypeObject drsuapi_DsReplicaNeighbour_Type;
static PyTypeObject drsuapi_DsReplicaNeighbourCtr_Type;
static PyTypeObject drsuapi_DsReplicaCursorCtr_Type;
static PyTypeObject drsuapi_DsReplicaObjMetaData_Type;
static PyTypeObject drsuapi_DsReplicaObjMetaDataCtr_Type;
static PyTypeObject drsuapi_DsReplicaKccDsaFailure_Type;
static PyTypeObject drsuapi_DsReplicaKccDsaFailuresCtr_Type;
static PyTypeObject drsuapi_DsReplicaOp_Type;
static PyTypeObject drsuapi_DsReplicaOpCtr_Type;
static PyTypeObject drsuapi_DsReplicaAttrValMetaData_Type;
static PyTypeObject drsuapi_DsReplicaAttrValMetaDataCtr_Type;
static PyTypeObject drsuapi_DsReplicaCursor2Ctr_Type;
static PyTypeObject drsuapi_DsReplicaCursor3_Type;
static PyTypeObject drsuapi_DsReplicaCursor3Ctr_Type;
static PyTypeObject drsuapi_DsReplicaObjMetaData2_Type;
static PyTypeObject drsuapi_DsReplicaObjMetaData2Ctr_Type;
static PyTypeObject drsuapi_DsReplicaAttrValMetaData2_Type;
static PyTypeObject drsuapi_DsReplicaAttrValMetaData2Ctr_Type;
static PyTypeObject drsuapi_DsReplicaConnection04_Type;
static PyTypeObject drsuapi_DsReplicaConnection04Ctr_Type;
static PyTypeObject drsuapi_DsReplica06_Type;
static PyTypeObject drsuapi_DsReplica06Ctr_Type;
static PyTypeObject drsuapi_DsReplicaInfo_Type;
static PyTypeObject drsuapi_DsGetMemberships2Ctr1_Type;
static PyTypeObject drsuapi_DsGetMemberships2Ctr_Type;
static PyTypeObject drsuapi_DsGetMemberships2Request1_Type;
static PyTypeObject drsuapi_DsGetMemberships2Request_Type;
static PyTypeObject drsuapi_DsSiteCostInfo_Type;
static PyTypeObject drsuapi_QuerySitesByCostCtr1_Type;
static PyTypeObject drsuapi_QuerySitesByCostCtr_Type;
static PyTypeObject drsuapi_QuerySitesByCostRequest1_Type;
static PyTypeObject drsuapi_QuerySitesByCostRequest_Type;
static PyTypeObject drsuapi_InterfaceType;
static PyTypeObject drsuapi_DsBind_Type;
static PyTypeObject drsuapi_DsUnbind_Type;
static PyTypeObject drsuapi_DsReplicaSync_Type;
static PyTypeObject drsuapi_DsGetNCChanges_Type;
static PyTypeObject drsuapi_DsReplicaUpdateRefs_Type;
static PyTypeObject drsuapi_DsReplicaAdd_Type;
static PyTypeObject drsuapi_DsReplicaDel_Type;
static PyTypeObject drsuapi_DsReplicaMod_Type;
static PyTypeObject drsuapi_DsGetMemberships_Type;
static PyTypeObject drsuapi_DsGetNT4ChangeLog_Type;
static PyTypeObject drsuapi_DsCrackNames_Type;
static PyTypeObject drsuapi_DsWriteAccountSpn_Type;
static PyTypeObject drsuapi_DsRemoveDSServer_Type;
static PyTypeObject drsuapi_DsGetDomainControllerInfo_Type;
static PyTypeObject drsuapi_DsAddEntry_Type;
static PyTypeObject drsuapi_DsExecuteKCC_Type;
static PyTypeObject drsuapi_DsReplicaGetInfo_Type;
static PyTypeObject drsuapi_DsGetMemberships2_Type;
static PyTypeObject drsuapi_QuerySitesByCost_Type;

static PyTypeObject *GUID_Type;
static PyTypeObject *BaseObject_Type;
static PyTypeObject *dom_sid_Type;
static PyTypeObject *lsa_String_Type;
static PyTypeObject *policy_handle_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *ndr_syntax_id_Type;

static PyObject *py_drsuapi_DsBindInfo24_get_supported_extensions(PyObject *obj, void *closure)
{
	struct drsuapi_DsBindInfo24 *object = pytalloc_get_ptr(obj);
	PyObject *py_supported_extensions;
	py_supported_extensions = PyLong_FromUnsignedLongLong((uint32_t)(object->supported_extensions));
	return py_supported_extensions;
}

static int py_drsuapi_DsBindInfo24_set_supported_extensions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsBindInfo24 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->supported_extensions");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->supported_extensions));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->supported_extensions = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsBindInfo24_get_site_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsBindInfo24 *object = pytalloc_get_ptr(obj);
	PyObject *py_site_guid;
	py_site_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->site_guid);
	return py_site_guid;
}

static int py_drsuapi_DsBindInfo24_set_site_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsBindInfo24 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->site_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->site_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsBindInfo24_get_pid(PyObject *obj, void *closure)
{
	struct drsuapi_DsBindInfo24 *object = pytalloc_get_ptr(obj);
	PyObject *py_pid;
	py_pid = PyLong_FromUnsignedLongLong((uint32_t)(object->pid));
	return py_pid;
}

static int py_drsuapi_DsBindInfo24_set_pid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsBindInfo24 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsBindInfo24_getsetters[] = {
	{
		.name = discard_const_p(char, "supported_extensions"),
		.get = py_drsuapi_DsBindInfo24_get_supported_extensions,
		.set = py_drsuapi_DsBindInfo24_set_supported_extensions,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_SupportedExtensions")
	},
	{
		.name = discard_const_p(char, "site_guid"),
		.get = py_drsuapi_DsBindInfo24_get_site_guid,
		.set = py_drsuapi_DsBindInfo24_set_site_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "pid"),
		.get = py_drsuapi_DsBindInfo24_get_pid,
		.set = py_drsuapi_DsBindInfo24_set_pid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsBindInfo24_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsBindInfo24, type);
}

static PyObject *py_drsuapi_DsBindInfo24_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct drsuapi_DsBindInfo24 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsBindInfo24);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_drsuapi_DsBindInfo24_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsBindInfo24 *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsBindInfo24);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsBindInfo24);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_drsuapi_DsBindInfo24_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsBindInfo24 *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsBindInfo24, "drsuapi_DsBindInfo24", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsBindInfo24, "drsuapi_DsBindInfo24", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_drsuapi_DsBindInfo24_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_drsuapi_DsBindInfo24_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsBindInfo24_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsBindInfo24_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject drsuapi_DsBindInfo24_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsBindInfo24",
	.tp_getset = py_drsuapi_DsBindInfo24_getsetters,
	.tp_methods = py_drsuapi_DsBindInfo24_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsBindInfo24_new,
};


static PyObject *py_drsuapi_DsBindInfo28_get_supported_extensions(PyObject *obj, void *closure)
{
	struct drsuapi_DsBindInfo28 *object = pytalloc_get_ptr(obj);
	PyObject *py_supported_extensions;
	py_supported_extensions = PyLong_FromUnsignedLongLong((uint32_t)(object->supported_extensions));
	return py_supported_extensions;
}

static int py_drsuapi_DsBindInfo28_set_supported_extensions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsBindInfo28 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->supported_extensions");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->supported_extensions));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->supported_extensions = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsBindInfo28_get_site_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsBindInfo28 *object = pytalloc_get_ptr(obj);
	PyObject *py_site_guid;
	py_site_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->site_guid);
	return py_site_guid;
}

static int py_drsuapi_DsBindInfo28_set_site_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsBindInfo28 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->site_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->site_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsBindInfo28_get_pid(PyObject *obj, void *closure)
{
	struct drsuapi_DsBindInfo28 *object = pytalloc_get_ptr(obj);
	PyObject *py_pid;
	py_pid = PyLong_FromUnsignedLongLong((uint32_t)(object->pid));
	return py_pid;
}

static int py_drsuapi_DsBindInfo28_set_pid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsBindInfo28 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsBindInfo28_get_repl_epoch(PyObject *obj, void *closure)
{
	struct drsuapi_DsBindInfo28 *object = pytalloc_get_ptr(obj);
	PyObject *py_repl_epoch;
	py_repl_epoch = PyLong_FromUnsignedLongLong((uint32_t)(object->repl_epoch));
	return py_repl_epoch;
}

static int py_drsuapi_DsBindInfo28_set_repl_epoch(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsBindInfo28 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->repl_epoch");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->repl_epoch));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->repl_epoch = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsBindInfo28_getsetters[] = {
	{
		.name = discard_const_p(char, "supported_extensions"),
		.get = py_drsuapi_DsBindInfo28_get_supported_extensions,
		.set = py_drsuapi_DsBindInfo28_set_supported_extensions,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_SupportedExtensions")
	},
	{
		.name = discard_const_p(char, "site_guid"),
		.get = py_drsuapi_DsBindInfo28_get_site_guid,
		.set = py_drsuapi_DsBindInfo28_set_site_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "pid"),
		.get = py_drsuapi_DsBindInfo28_get_pid,
		.set = py_drsuapi_DsBindInfo28_set_pid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "repl_epoch"),
		.get = py_drsuapi_DsBindInfo28_get_repl_epoch,
		.set = py_drsuapi_DsBindInfo28_set_repl_epoch,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsBindInfo28_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsBindInfo28, type);
}

static PyObject *py_drsuapi_DsBindInfo28_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct drsuapi_DsBindInfo28 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsBindInfo28);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_drsuapi_DsBindInfo28_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsBindInfo28 *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsBindInfo28);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsBindInfo28);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_drsuapi_DsBindInfo28_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsBindInfo28 *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsBindInfo28, "drsuapi_DsBindInfo28", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsBindInfo28, "drsuapi_DsBindInfo28", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_drsuapi_DsBindInfo28_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_drsuapi_DsBindInfo28_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsBindInfo28_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsBindInfo28_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject drsuapi_DsBindInfo28_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsBindInfo28",
	.tp_getset = py_drsuapi_DsBindInfo28_getsetters,
	.tp_methods = py_drsuapi_DsBindInfo28_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsBindInfo28_new,
};


static PyObject *py_drsuapi_DsBindInfo32_get_supported_extensions(PyObject *obj, void *closure)
{
	struct drsuapi_DsBindInfo32 *object = pytalloc_get_ptr(obj);
	PyObject *py_supported_extensions;
	py_supported_extensions = PyLong_FromUnsignedLongLong((uint32_t)(object->supported_extensions));
	return py_supported_extensions;
}

static int py_drsuapi_DsBindInfo32_set_supported_extensions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsBindInfo32 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->supported_extensions");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->supported_extensions));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->supported_extensions = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsBindInfo32_get_site_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsBindInfo32 *object = pytalloc_get_ptr(obj);
	PyObject *py_site_guid;
	py_site_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->site_guid);
	return py_site_guid;
}

static int py_drsuapi_DsBindInfo32_set_site_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsBindInfo32 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->site_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->site_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsBindInfo32_get_pid(PyObject *obj, void *closure)
{
	struct drsuapi_DsBindInfo32 *object = pytalloc_get_ptr(obj);
	PyObject *py_pid;
	py_pid = PyLong_FromUnsignedLongLong((uint32_t)(object->pid));
	return py_pid;
}

static int py_drsuapi_DsBindInfo32_set_pid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsBindInfo32 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsBindInfo32_get_repl_epoch(PyObject *obj, void *closure)
{
	struct drsuapi_DsBindInfo32 *object = pytalloc_get_ptr(obj);
	PyObject *py_repl_epoch;
	py_repl_epoch = PyLong_FromUnsignedLongLong((uint32_t)(object->repl_epoch));
	return py_repl_epoch;
}

static int py_drsuapi_DsBindInfo32_set_repl_epoch(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsBindInfo32 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->repl_epoch");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->repl_epoch));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->repl_epoch = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsBindInfo32_get_supported_extensions_ext(PyObject *obj, void *closure)
{
	struct drsuapi_DsBindInfo32 *object = pytalloc_get_ptr(obj);
	PyObject *py_supported_extensions_ext;
	py_supported_extensions_ext = PyLong_FromUnsignedLongLong((uint32_t)(object->supported_extensions_ext));
	return py_supported_extensions_ext;
}

static int py_drsuapi_DsBindInfo32_set_supported_extensions_ext(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsBindInfo32 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->supported_extensions_ext");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->supported_extensions_ext));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->supported_extensions_ext = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsBindInfo32_getsetters[] = {
	{
		.name = discard_const_p(char, "supported_extensions"),
		.get = py_drsuapi_DsBindInfo32_get_supported_extensions,
		.set = py_drsuapi_DsBindInfo32_set_supported_extensions,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_SupportedExtensions")
	},
	{
		.name = discard_const_p(char, "site_guid"),
		.get = py_drsuapi_DsBindInfo32_get_site_guid,
		.set = py_drsuapi_DsBindInfo32_set_site_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "pid"),
		.get = py_drsuapi_DsBindInfo32_get_pid,
		.set = py_drsuapi_DsBindInfo32_set_pid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "repl_epoch"),
		.get = py_drsuapi_DsBindInfo32_get_repl_epoch,
		.set = py_drsuapi_DsBindInfo32_set_repl_epoch,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "supported_extensions_ext"),
		.get = py_drsuapi_DsBindInfo32_get_supported_extensions_ext,
		.set = py_drsuapi_DsBindInfo32_set_supported_extensions_ext,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_SupportedExtensionsExt")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsBindInfo32_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsBindInfo32, type);
}

static PyObject *py_drsuapi_DsBindInfo32_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct drsuapi_DsBindInfo32 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsBindInfo32);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_drsuapi_DsBindInfo32_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsBindInfo32 *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsBindInfo32);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsBindInfo32);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_drsuapi_DsBindInfo32_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsBindInfo32 *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsBindInfo32, "drsuapi_DsBindInfo32", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsBindInfo32, "drsuapi_DsBindInfo32", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_drsuapi_DsBindInfo32_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_drsuapi_DsBindInfo32_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsBindInfo32_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsBindInfo32_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject drsuapi_DsBindInfo32_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsBindInfo32",
	.tp_getset = py_drsuapi_DsBindInfo32_getsetters,
	.tp_methods = py_drsuapi_DsBindInfo32_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsBindInfo32_new,
};


static PyObject *py_drsuapi_DsBindInfo48_get_supported_extensions(PyObject *obj, void *closure)
{
	struct drsuapi_DsBindInfo48 *object = pytalloc_get_ptr(obj);
	PyObject *py_supported_extensions;
	py_supported_extensions = PyLong_FromUnsignedLongLong((uint32_t)(object->supported_extensions));
	return py_supported_extensions;
}

static int py_drsuapi_DsBindInfo48_set_supported_extensions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsBindInfo48 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->supported_extensions");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->supported_extensions));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->supported_extensions = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsBindInfo48_get_site_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsBindInfo48 *object = pytalloc_get_ptr(obj);
	PyObject *py_site_guid;
	py_site_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->site_guid);
	return py_site_guid;
}

static int py_drsuapi_DsBindInfo48_set_site_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsBindInfo48 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->site_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->site_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsBindInfo48_get_pid(PyObject *obj, void *closure)
{
	struct drsuapi_DsBindInfo48 *object = pytalloc_get_ptr(obj);
	PyObject *py_pid;
	py_pid = PyLong_FromUnsignedLongLong((uint32_t)(object->pid));
	return py_pid;
}

static int py_drsuapi_DsBindInfo48_set_pid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsBindInfo48 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsBindInfo48_get_repl_epoch(PyObject *obj, void *closure)
{
	struct drsuapi_DsBindInfo48 *object = pytalloc_get_ptr(obj);
	PyObject *py_repl_epoch;
	py_repl_epoch = PyLong_FromUnsignedLongLong((uint32_t)(object->repl_epoch));
	return py_repl_epoch;
}

static int py_drsuapi_DsBindInfo48_set_repl_epoch(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsBindInfo48 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->repl_epoch");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->repl_epoch));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->repl_epoch = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsBindInfo48_get_supported_extensions_ext(PyObject *obj, void *closure)
{
	struct drsuapi_DsBindInfo48 *object = pytalloc_get_ptr(obj);
	PyObject *py_supported_extensions_ext;
	py_supported_extensions_ext = PyLong_FromUnsignedLongLong((uint32_t)(object->supported_extensions_ext));
	return py_supported_extensions_ext;
}

static int py_drsuapi_DsBindInfo48_set_supported_extensions_ext(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsBindInfo48 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->supported_extensions_ext");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->supported_extensions_ext));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->supported_extensions_ext = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsBindInfo48_get_config_dn_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsBindInfo48 *object = pytalloc_get_ptr(obj);
	PyObject *py_config_dn_guid;
	py_config_dn_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->config_dn_guid);
	return py_config_dn_guid;
}

static int py_drsuapi_DsBindInfo48_set_config_dn_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsBindInfo48 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->config_dn_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->config_dn_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_drsuapi_DsBindInfo48_getsetters[] = {
	{
		.name = discard_const_p(char, "supported_extensions"),
		.get = py_drsuapi_DsBindInfo48_get_supported_extensions,
		.set = py_drsuapi_DsBindInfo48_set_supported_extensions,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_SupportedExtensions")
	},
	{
		.name = discard_const_p(char, "site_guid"),
		.get = py_drsuapi_DsBindInfo48_get_site_guid,
		.set = py_drsuapi_DsBindInfo48_set_site_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "pid"),
		.get = py_drsuapi_DsBindInfo48_get_pid,
		.set = py_drsuapi_DsBindInfo48_set_pid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "repl_epoch"),
		.get = py_drsuapi_DsBindInfo48_get_repl_epoch,
		.set = py_drsuapi_DsBindInfo48_set_repl_epoch,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "supported_extensions_ext"),
		.get = py_drsuapi_DsBindInfo48_get_supported_extensions_ext,
		.set = py_drsuapi_DsBindInfo48_set_supported_extensions_ext,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_SupportedExtensionsExt")
	},
	{
		.name = discard_const_p(char, "config_dn_guid"),
		.get = py_drsuapi_DsBindInfo48_get_config_dn_guid,
		.set = py_drsuapi_DsBindInfo48_set_config_dn_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsBindInfo48_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsBindInfo48, type);
}

static PyObject *py_drsuapi_DsBindInfo48_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct drsuapi_DsBindInfo48 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsBindInfo48);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_drsuapi_DsBindInfo48_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsBindInfo48 *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsBindInfo48);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsBindInfo48);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_drsuapi_DsBindInfo48_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsBindInfo48 *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsBindInfo48, "drsuapi_DsBindInfo48", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsBindInfo48, "drsuapi_DsBindInfo48", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_drsuapi_DsBindInfo48_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_drsuapi_DsBindInfo48_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsBindInfo48_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsBindInfo48_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject drsuapi_DsBindInfo48_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsBindInfo48",
	.tp_getset = py_drsuapi_DsBindInfo48_getsetters,
	.tp_methods = py_drsuapi_DsBindInfo48_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsBindInfo48_new,
};


static PyObject *py_drsuapi_DsBindInfo52_get_supported_extensions(PyObject *obj, void *closure)
{
	struct drsuapi_DsBindInfo52 *object = pytalloc_get_ptr(obj);
	PyObject *py_supported_extensions;
	py_supported_extensions = PyLong_FromUnsignedLongLong((uint32_t)(object->supported_extensions));
	return py_supported_extensions;
}

static int py_drsuapi_DsBindInfo52_set_supported_extensions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsBindInfo52 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->supported_extensions");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->supported_extensions));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->supported_extensions = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsBindInfo52_get_site_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsBindInfo52 *object = pytalloc_get_ptr(obj);
	PyObject *py_site_guid;
	py_site_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->site_guid);
	return py_site_guid;
}

static int py_drsuapi_DsBindInfo52_set_site_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsBindInfo52 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->site_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->site_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsBindInfo52_get_pid(PyObject *obj, void *closure)
{
	struct drsuapi_DsBindInfo52 *object = pytalloc_get_ptr(obj);
	PyObject *py_pid;
	py_pid = PyLong_FromUnsignedLongLong((uint32_t)(object->pid));
	return py_pid;
}

static int py_drsuapi_DsBindInfo52_set_pid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsBindInfo52 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsBindInfo52_get_repl_epoch(PyObject *obj, void *closure)
{
	struct drsuapi_DsBindInfo52 *object = pytalloc_get_ptr(obj);
	PyObject *py_repl_epoch;
	py_repl_epoch = PyLong_FromUnsignedLongLong((uint32_t)(object->repl_epoch));
	return py_repl_epoch;
}

static int py_drsuapi_DsBindInfo52_set_repl_epoch(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsBindInfo52 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->repl_epoch");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->repl_epoch));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->repl_epoch = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsBindInfo52_get_supported_extensions_ext(PyObject *obj, void *closure)
{
	struct drsuapi_DsBindInfo52 *object = pytalloc_get_ptr(obj);
	PyObject *py_supported_extensions_ext;
	py_supported_extensions_ext = PyLong_FromUnsignedLongLong((uint32_t)(object->supported_extensions_ext));
	return py_supported_extensions_ext;
}

static int py_drsuapi_DsBindInfo52_set_supported_extensions_ext(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsBindInfo52 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->supported_extensions_ext");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->supported_extensions_ext));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->supported_extensions_ext = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsBindInfo52_get_config_dn_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsBindInfo52 *object = pytalloc_get_ptr(obj);
	PyObject *py_config_dn_guid;
	py_config_dn_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->config_dn_guid);
	return py_config_dn_guid;
}

static int py_drsuapi_DsBindInfo52_set_config_dn_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsBindInfo52 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->config_dn_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->config_dn_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsBindInfo52_get_supported_capabilities_ext(PyObject *obj, void *closure)
{
	struct drsuapi_DsBindInfo52 *object = pytalloc_get_ptr(obj);
	PyObject *py_supported_capabilities_ext;
	py_supported_capabilities_ext = PyLong_FromUnsignedLongLong((uint32_t)(object->supported_capabilities_ext));
	return py_supported_capabilities_ext;
}

static int py_drsuapi_DsBindInfo52_set_supported_capabilities_ext(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsBindInfo52 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->supported_capabilities_ext");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->supported_capabilities_ext));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->supported_capabilities_ext = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsBindInfo52_getsetters[] = {
	{
		.name = discard_const_p(char, "supported_extensions"),
		.get = py_drsuapi_DsBindInfo52_get_supported_extensions,
		.set = py_drsuapi_DsBindInfo52_set_supported_extensions,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_SupportedExtensions")
	},
	{
		.name = discard_const_p(char, "site_guid"),
		.get = py_drsuapi_DsBindInfo52_get_site_guid,
		.set = py_drsuapi_DsBindInfo52_set_site_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "pid"),
		.get = py_drsuapi_DsBindInfo52_get_pid,
		.set = py_drsuapi_DsBindInfo52_set_pid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "repl_epoch"),
		.get = py_drsuapi_DsBindInfo52_get_repl_epoch,
		.set = py_drsuapi_DsBindInfo52_set_repl_epoch,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "supported_extensions_ext"),
		.get = py_drsuapi_DsBindInfo52_get_supported_extensions_ext,
		.set = py_drsuapi_DsBindInfo52_set_supported_extensions_ext,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_SupportedExtensionsExt")
	},
	{
		.name = discard_const_p(char, "config_dn_guid"),
		.get = py_drsuapi_DsBindInfo52_get_config_dn_guid,
		.set = py_drsuapi_DsBindInfo52_set_config_dn_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "supported_capabilities_ext"),
		.get = py_drsuapi_DsBindInfo52_get_supported_capabilities_ext,
		.set = py_drsuapi_DsBindInfo52_set_supported_capabilities_ext,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_SupportedExtensionsExt")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsBindInfo52_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsBindInfo52, type);
}

static PyObject *py_drsuapi_DsBindInfo52_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct drsuapi_DsBindInfo52 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsBindInfo52);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_drsuapi_DsBindInfo52_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsBindInfo52 *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsBindInfo52);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsBindInfo52);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_drsuapi_DsBindInfo52_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsBindInfo52 *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsBindInfo52, "drsuapi_DsBindInfo52", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsBindInfo52, "drsuapi_DsBindInfo52", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_drsuapi_DsBindInfo52_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_drsuapi_DsBindInfo52_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsBindInfo52_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsBindInfo52_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject drsuapi_DsBindInfo52_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsBindInfo52",
	.tp_getset = py_drsuapi_DsBindInfo52_getsetters,
	.tp_methods = py_drsuapi_DsBindInfo52_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsBindInfo52_new,
};


static PyObject *py_drsuapi_DsBindInfoFallBack_get_info(PyObject *obj, void *closure)
{
	struct drsuapi_DsBindInfoFallBack *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	py_info = PyBytes_FromStringAndSize((char *)(object->info).data, (object->info).length);
	return py_info;
}

static int py_drsuapi_DsBindInfoFallBack_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsBindInfoFallBack *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info");
		return -1;
	}
	object->info = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_drsuapi_DsBindInfoFallBack_getsetters[] = {
	{
		.name = discard_const_p(char, "info"),
		.get = py_drsuapi_DsBindInfoFallBack_get_info,
		.set = py_drsuapi_DsBindInfoFallBack_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsBindInfoFallBack_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsBindInfoFallBack, type);
}

static PyObject *py_drsuapi_DsBindInfoFallBack_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct drsuapi_DsBindInfoFallBack *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsBindInfoFallBack);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_drsuapi_DsBindInfoFallBack_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsBindInfoFallBack *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsBindInfoFallBack);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsBindInfoFallBack);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_drsuapi_DsBindInfoFallBack_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsBindInfoFallBack *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsBindInfoFallBack, "drsuapi_DsBindInfoFallBack", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsBindInfoFallBack, "drsuapi_DsBindInfoFallBack", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_drsuapi_DsBindInfoFallBack_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_drsuapi_DsBindInfoFallBack_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsBindInfoFallBack_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsBindInfoFallBack_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject drsuapi_DsBindInfoFallBack_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsBindInfoFallBack",
	.tp_getset = py_drsuapi_DsBindInfoFallBack_getsetters,
	.tp_methods = py_drsuapi_DsBindInfoFallBack_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsBindInfoFallBack_new,
};

static PyObject *py_import_drsuapi_DsBindInfo(TALLOC_CTX *mem_ctx, int level, union drsuapi_DsBindInfo *in)
{
	PyObject *ret;

	switch (level) {
		case 24:
			ret = pytalloc_reference_ex(&drsuapi_DsBindInfo24_Type, mem_ctx, &in->info24);
			return ret;

		case 28:
			ret = pytalloc_reference_ex(&drsuapi_DsBindInfo28_Type, mem_ctx, &in->info28);
			return ret;

		case 32:
			ret = pytalloc_reference_ex(&drsuapi_DsBindInfo32_Type, mem_ctx, &in->info32);
			return ret;

		case 48:
			ret = pytalloc_reference_ex(&drsuapi_DsBindInfo48_Type, mem_ctx, &in->info48);
			return ret;

		case 52:
			ret = pytalloc_reference_ex(&drsuapi_DsBindInfo52_Type, mem_ctx, &in->info52);
			return ret;

		default:
			ret = pytalloc_reference_ex(&drsuapi_DsBindInfoFallBack_Type, mem_ctx, &in->Fallback);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union drsuapi_DsBindInfo *py_export_drsuapi_DsBindInfo(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union drsuapi_DsBindInfo *ret = talloc_zero(mem_ctx, union drsuapi_DsBindInfo);
	switch (level) {
		case 24:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info24");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsBindInfo24_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info24 = *(struct drsuapi_DsBindInfo24 *)pytalloc_get_ptr(in);
			break;

		case 28:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info28");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsBindInfo28_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info28 = *(struct drsuapi_DsBindInfo28 *)pytalloc_get_ptr(in);
			break;

		case 32:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info32");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsBindInfo32_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info32 = *(struct drsuapi_DsBindInfo32 *)pytalloc_get_ptr(in);
			break;

		case 48:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info48");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsBindInfo48_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info48 = *(struct drsuapi_DsBindInfo48 *)pytalloc_get_ptr(in);
			break;

		case 52:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info52");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsBindInfo52_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info52 = *(struct drsuapi_DsBindInfo52 *)pytalloc_get_ptr(in);
			break;

		default:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->Fallback");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsBindInfoFallBack_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->Fallback = *(struct drsuapi_DsBindInfoFallBack *)pytalloc_get_ptr(in);
			break;

	}

	return ret;
}

static PyObject *py_drsuapi_DsBindInfo_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union drsuapi_DsBindInfo *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union drsuapi_DsBindInfo *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union drsuapi_DsBindInfo!");
		return NULL;
	}

	return py_import_drsuapi_DsBindInfo(mem_ctx, level, in);
}

static PyObject *py_drsuapi_DsBindInfo_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union drsuapi_DsBindInfo *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_drsuapi_DsBindInfo(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_drsuapi_DsBindInfo_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsBindInfo_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsBindInfo_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_drsuapi_DsBindInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject drsuapi_DsBindInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsBindInfo",
	.tp_getset = NULL,
	.tp_methods = py_drsuapi_DsBindInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsBindInfo_new,
};


static PyObject *py_drsuapi_DsBindInfoCtr_get_length(PyObject *obj, void *closure)
{
	struct drsuapi_DsBindInfoCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromUnsignedLongLong((uint32_t)(object->length));
	return py_length;
}

static int py_drsuapi_DsBindInfoCtr_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsBindInfoCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsBindInfoCtr_get___ndr_length(PyObject *obj, void *closure)
{
	struct drsuapi_DsBindInfoCtr *object = pytalloc_get_ptr(obj);
	PyObject *py___ndr_length;
	py___ndr_length = PyLong_FromUnsignedLongLong((uint32_t)(object->__ndr_length));
	return py___ndr_length;
}

static int py_drsuapi_DsBindInfoCtr_set___ndr_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsBindInfoCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->__ndr_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->__ndr_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->__ndr_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsBindInfoCtr_get_info(PyObject *obj, void *closure)
{
	struct drsuapi_DsBindInfoCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	py_info = pyrpc_import_union(&drsuapi_DsBindInfo_Type, pytalloc_get_mem_ctx(obj), object->length, &object->info, "union drsuapi_DsBindInfo");
	if (py_info == NULL) {
		return NULL;
	}
	return py_info;
}

static int py_drsuapi_DsBindInfoCtr_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsBindInfoCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info");
		return -1;
	}
	{
		union drsuapi_DsBindInfo *info_switch_0;
		info_switch_0 = (union drsuapi_DsBindInfo *)pyrpc_export_union(&drsuapi_DsBindInfo_Type, pytalloc_get_mem_ctx(py_obj), object->length, value, "union drsuapi_DsBindInfo");
		if (info_switch_0 == NULL) {
			return -1;
		}
		object->info = *info_switch_0;
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsBindInfoCtr_getsetters[] = {
	{
		.name = discard_const_p(char, "length"),
		.get = py_drsuapi_DsBindInfoCtr_get_length,
		.set = py_drsuapi_DsBindInfoCtr_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint3264")
	},
	{
		.name = discard_const_p(char, "__ndr_length"),
		.get = py_drsuapi_DsBindInfoCtr_get___ndr_length,
		.set = py_drsuapi_DsBindInfoCtr_set___ndr_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "info"),
		.get = py_drsuapi_DsBindInfoCtr_get_info,
		.set = py_drsuapi_DsBindInfoCtr_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsBindInfo")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsBindInfoCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsBindInfoCtr, type);
}


static PyTypeObject drsuapi_DsBindInfoCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsBindInfoCtr",
	.tp_getset = py_drsuapi_DsBindInfoCtr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsBindInfoCtr_new,
};


static PyObject *py_drsuapi_DsReplicaObjectIdentifier_get___ndr_size(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier *object = pytalloc_get_ptr(obj);
	PyObject *py___ndr_size;
	py___ndr_size = PyLong_FromUnsignedLongLong((uint32_t)(object->__ndr_size));
	return py___ndr_size;
}

static int py_drsuapi_DsReplicaObjectIdentifier_set___ndr_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->__ndr_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->__ndr_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->__ndr_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaObjectIdentifier_get___ndr_size_sid(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier *object = pytalloc_get_ptr(obj);
	PyObject *py___ndr_size_sid;
	py___ndr_size_sid = PyLong_FromUnsignedLongLong((uint32_t)(object->__ndr_size_sid));
	return py___ndr_size_sid;
}

static int py_drsuapi_DsReplicaObjectIdentifier_set___ndr_size_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->__ndr_size_sid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->__ndr_size_sid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->__ndr_size_sid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaObjectIdentifier_get_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier *object = pytalloc_get_ptr(obj);
	PyObject *py_guid;
	py_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->guid);
	return py_guid;
}

static int py_drsuapi_DsReplicaObjectIdentifier_set_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsReplicaObjectIdentifier_get_sid(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	py_sid = pytalloc_reference_ex(dom_sid_Type, pytalloc_get_mem_ctx(obj), &object->sid);
	return py_sid;
}

static int py_drsuapi_DsReplicaObjectIdentifier_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sid");
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sid = *(struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsReplicaObjectIdentifier_get___ndr_size_dn(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier *object = pytalloc_get_ptr(obj);
	PyObject *py___ndr_size_dn;
	py___ndr_size_dn = PyLong_FromUnsignedLongLong((uint32_t)(object->__ndr_size_dn));
	return py___ndr_size_dn;
}

static int py_drsuapi_DsReplicaObjectIdentifier_set___ndr_size_dn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->__ndr_size_dn");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->__ndr_size_dn));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->__ndr_size_dn = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaObjectIdentifier_get_dn(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier *object = pytalloc_get_ptr(obj);
	PyObject *py_dn;
	if (object->dn == NULL) {
		py_dn = Py_None;
		Py_INCREF(py_dn);
	} else {
		py_dn = PyUnicode_Decode(object->dn, strlen(object->dn), "utf-8", "ignore");
	}
	return py_dn;
}

static int py_drsuapi_DsReplicaObjectIdentifier_set_dn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dn");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->dn = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaObjectIdentifier_getsetters[] = {
	{
		.name = discard_const_p(char, "__ndr_size"),
		.get = py_drsuapi_DsReplicaObjectIdentifier_get___ndr_size,
		.set = py_drsuapi_DsReplicaObjectIdentifier_set___ndr_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "__ndr_size_sid"),
		.get = py_drsuapi_DsReplicaObjectIdentifier_get___ndr_size_sid,
		.set = py_drsuapi_DsReplicaObjectIdentifier_set___ndr_size_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "guid"),
		.get = py_drsuapi_DsReplicaObjectIdentifier_get_guid,
		.set = py_drsuapi_DsReplicaObjectIdentifier_set_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "sid"),
		.get = py_drsuapi_DsReplicaObjectIdentifier_get_sid,
		.set = py_drsuapi_DsReplicaObjectIdentifier_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid28")
	},
	{
		.name = discard_const_p(char, "__ndr_size_dn"),
		.get = py_drsuapi_DsReplicaObjectIdentifier_get___ndr_size_dn,
		.set = py_drsuapi_DsReplicaObjectIdentifier_set___ndr_size_dn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dn"),
		.get = py_drsuapi_DsReplicaObjectIdentifier_get_dn,
		.set = py_drsuapi_DsReplicaObjectIdentifier_set_dn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaObjectIdentifier_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaObjectIdentifier, type);
}

static PyObject *py_drsuapi_DsReplicaObjectIdentifier_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct drsuapi_DsReplicaObjectIdentifier *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsReplicaObjectIdentifier);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_drsuapi_DsReplicaObjectIdentifier_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsReplicaObjectIdentifier *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsReplicaObjectIdentifier);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsReplicaObjectIdentifier);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_drsuapi_DsReplicaObjectIdentifier_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsReplicaObjectIdentifier *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsReplicaObjectIdentifier, "drsuapi_DsReplicaObjectIdentifier", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsReplicaObjectIdentifier, "drsuapi_DsReplicaObjectIdentifier", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_drsuapi_DsReplicaObjectIdentifier_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_drsuapi_DsReplicaObjectIdentifier_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaObjectIdentifier_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaObjectIdentifier_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject drsuapi_DsReplicaObjectIdentifier_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaObjectIdentifier",
	.tp_getset = py_drsuapi_DsReplicaObjectIdentifier_getsetters,
	.tp_methods = py_drsuapi_DsReplicaObjectIdentifier_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaObjectIdentifier_new,
};


static PyObject *py_drsuapi_DsReplicaSyncRequest1_get_naming_context(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaSyncRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_naming_context;
	if (object->naming_context == NULL) {
		Py_RETURN_NONE;
	}
	py_naming_context = pytalloc_reference_ex(&drsuapi_DsReplicaObjectIdentifier_Type, object->naming_context, object->naming_context);
	return py_naming_context;
}

static int py_drsuapi_DsReplicaSyncRequest1_set_naming_context(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaSyncRequest1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->naming_context));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->naming_context");
		return -1;
	}
	object->naming_context = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->naming_context);
	if (object->naming_context == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsReplicaObjectIdentifier_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->naming_context = (struct drsuapi_DsReplicaObjectIdentifier *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsReplicaSyncRequest1_get_source_dsa_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaSyncRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_source_dsa_guid;
	py_source_dsa_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->source_dsa_guid);
	return py_source_dsa_guid;
}

static int py_drsuapi_DsReplicaSyncRequest1_set_source_dsa_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaSyncRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->source_dsa_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->source_dsa_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsReplicaSyncRequest1_get_source_dsa_dns(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaSyncRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_source_dsa_dns;
	if (object->source_dsa_dns == NULL) {
		Py_RETURN_NONE;
	}
	if (object->source_dsa_dns == NULL) {
		py_source_dsa_dns = Py_None;
		Py_INCREF(py_source_dsa_dns);
	} else {
		if (object->source_dsa_dns == NULL) {
			py_source_dsa_dns = Py_None;
			Py_INCREF(py_source_dsa_dns);
		} else {
			py_source_dsa_dns = PyUnicode_Decode(object->source_dsa_dns, strlen(object->source_dsa_dns), "utf-8", "ignore");
		}
	}
	return py_source_dsa_dns;
}

static int py_drsuapi_DsReplicaSyncRequest1_set_source_dsa_dns(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaSyncRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->source_dsa_dns");
		return -1;
	}
	if (value == Py_None) {
		object->source_dsa_dns = NULL;
	} else {
		object->source_dsa_dns = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->source_dsa_dns = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaSyncRequest1_get_options(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaSyncRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_options;
	py_options = PyLong_FromUnsignedLongLong((uint32_t)(object->options));
	return py_options;
}

static int py_drsuapi_DsReplicaSyncRequest1_set_options(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaSyncRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->options");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->options));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->options = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaSyncRequest1_getsetters[] = {
	{
		.name = discard_const_p(char, "naming_context"),
		.get = py_drsuapi_DsReplicaSyncRequest1_get_naming_context,
		.set = py_drsuapi_DsReplicaSyncRequest1_set_naming_context,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObjectIdentifier")
	},
	{
		.name = discard_const_p(char, "source_dsa_guid"),
		.get = py_drsuapi_DsReplicaSyncRequest1_get_source_dsa_guid,
		.set = py_drsuapi_DsReplicaSyncRequest1_set_source_dsa_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "source_dsa_dns"),
		.get = py_drsuapi_DsReplicaSyncRequest1_get_source_dsa_dns,
		.set = py_drsuapi_DsReplicaSyncRequest1_set_source_dsa_dns,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "options"),
		.get = py_drsuapi_DsReplicaSyncRequest1_get_options,
		.set = py_drsuapi_DsReplicaSyncRequest1_set_options,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DrsOptions")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaSyncRequest1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaSyncRequest1, type);
}


static PyTypeObject drsuapi_DsReplicaSyncRequest1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaSyncRequest1",
	.tp_getset = py_drsuapi_DsReplicaSyncRequest1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaSyncRequest1_new,
};

static PyObject *py_import_drsuapi_DsReplicaSyncRequest(TALLOC_CTX *mem_ctx, int level, union drsuapi_DsReplicaSyncRequest *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = pytalloc_reference_ex(&drsuapi_DsReplicaSyncRequest1_Type, mem_ctx, &in->req1);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union drsuapi_DsReplicaSyncRequest *py_export_drsuapi_DsReplicaSyncRequest(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union drsuapi_DsReplicaSyncRequest *ret = talloc_zero(mem_ctx, union drsuapi_DsReplicaSyncRequest);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->req1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsReplicaSyncRequest1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->req1 = *(struct drsuapi_DsReplicaSyncRequest1 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_drsuapi_DsReplicaSyncRequest_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union drsuapi_DsReplicaSyncRequest *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union drsuapi_DsReplicaSyncRequest *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union drsuapi_DsReplicaSyncRequest!");
		return NULL;
	}

	return py_import_drsuapi_DsReplicaSyncRequest(mem_ctx, level, in);
}

static PyObject *py_drsuapi_DsReplicaSyncRequest_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union drsuapi_DsReplicaSyncRequest *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_drsuapi_DsReplicaSyncRequest(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_drsuapi_DsReplicaSyncRequest_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaSyncRequest_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaSyncRequest_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_drsuapi_DsReplicaSyncRequest_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject drsuapi_DsReplicaSyncRequest_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaSyncRequest",
	.tp_getset = NULL,
	.tp_methods = py_drsuapi_DsReplicaSyncRequest_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaSyncRequest_new,
};


static PyObject *py_drsuapi_DsReplicaHighWaterMark_get_tmp_highest_usn(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaHighWaterMark *object = pytalloc_get_ptr(obj);
	PyObject *py_tmp_highest_usn;
	py_tmp_highest_usn = PyLong_FromUnsignedLongLong(object->tmp_highest_usn);
	return py_tmp_highest_usn;
}

static int py_drsuapi_DsReplicaHighWaterMark_set_tmp_highest_usn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaHighWaterMark *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->tmp_highest_usn");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->tmp_highest_usn));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->tmp_highest_usn = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaHighWaterMark_get_reserved_usn(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaHighWaterMark *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved_usn;
	py_reserved_usn = PyLong_FromUnsignedLongLong(object->reserved_usn);
	return py_reserved_usn;
}

static int py_drsuapi_DsReplicaHighWaterMark_set_reserved_usn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaHighWaterMark *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved_usn");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved_usn));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved_usn = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaHighWaterMark_get_highest_usn(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaHighWaterMark *object = pytalloc_get_ptr(obj);
	PyObject *py_highest_usn;
	py_highest_usn = PyLong_FromUnsignedLongLong(object->highest_usn);
	return py_highest_usn;
}

static int py_drsuapi_DsReplicaHighWaterMark_set_highest_usn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaHighWaterMark *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->highest_usn");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->highest_usn));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->highest_usn = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaHighWaterMark_getsetters[] = {
	{
		.name = discard_const_p(char, "tmp_highest_usn"),
		.get = py_drsuapi_DsReplicaHighWaterMark_get_tmp_highest_usn,
		.set = py_drsuapi_DsReplicaHighWaterMark_set_tmp_highest_usn,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "reserved_usn"),
		.get = py_drsuapi_DsReplicaHighWaterMark_get_reserved_usn,
		.set = py_drsuapi_DsReplicaHighWaterMark_set_reserved_usn,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "highest_usn"),
		.get = py_drsuapi_DsReplicaHighWaterMark_get_highest_usn,
		.set = py_drsuapi_DsReplicaHighWaterMark_set_highest_usn,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaHighWaterMark_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaHighWaterMark, type);
}

static PyObject *py_drsuapi_DsReplicaHighWaterMark_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct drsuapi_DsReplicaHighWaterMark *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsReplicaHighWaterMark);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_drsuapi_DsReplicaHighWaterMark_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsReplicaHighWaterMark *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsReplicaHighWaterMark);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsReplicaHighWaterMark);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_drsuapi_DsReplicaHighWaterMark_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsReplicaHighWaterMark *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsReplicaHighWaterMark, "drsuapi_DsReplicaHighWaterMark", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsReplicaHighWaterMark, "drsuapi_DsReplicaHighWaterMark", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_drsuapi_DsReplicaHighWaterMark_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_drsuapi_DsReplicaHighWaterMark_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaHighWaterMark_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaHighWaterMark_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject drsuapi_DsReplicaHighWaterMark_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaHighWaterMark",
	.tp_getset = py_drsuapi_DsReplicaHighWaterMark_getsetters,
	.tp_methods = py_drsuapi_DsReplicaHighWaterMark_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaHighWaterMark_new,
};


static PyObject *py_drsuapi_DsReplicaCursor_get_source_dsa_invocation_id(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaCursor *object = pytalloc_get_ptr(obj);
	PyObject *py_source_dsa_invocation_id;
	py_source_dsa_invocation_id = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->source_dsa_invocation_id);
	return py_source_dsa_invocation_id;
}

static int py_drsuapi_DsReplicaCursor_set_source_dsa_invocation_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaCursor *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->source_dsa_invocation_id");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->source_dsa_invocation_id = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsReplicaCursor_get_highest_usn(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaCursor *object = pytalloc_get_ptr(obj);
	PyObject *py_highest_usn;
	py_highest_usn = PyLong_FromUnsignedLongLong(object->highest_usn);
	return py_highest_usn;
}

static int py_drsuapi_DsReplicaCursor_set_highest_usn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaCursor *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->highest_usn");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->highest_usn));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->highest_usn = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaCursor_getsetters[] = {
	{
		.name = discard_const_p(char, "source_dsa_invocation_id"),
		.get = py_drsuapi_DsReplicaCursor_get_source_dsa_invocation_id,
		.set = py_drsuapi_DsReplicaCursor_set_source_dsa_invocation_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "highest_usn"),
		.get = py_drsuapi_DsReplicaCursor_get_highest_usn,
		.set = py_drsuapi_DsReplicaCursor_set_highest_usn,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaCursor_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaCursor, type);
}

static PyObject *py_drsuapi_DsReplicaCursor_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct drsuapi_DsReplicaCursor *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsReplicaCursor);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_drsuapi_DsReplicaCursor_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsReplicaCursor *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsReplicaCursor);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsReplicaCursor);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_drsuapi_DsReplicaCursor_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsReplicaCursor *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsReplicaCursor, "drsuapi_DsReplicaCursor", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsReplicaCursor, "drsuapi_DsReplicaCursor", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_drsuapi_DsReplicaCursor_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_drsuapi_DsReplicaCursor_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaCursor_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaCursor_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject drsuapi_DsReplicaCursor_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaCursor",
	.tp_getset = py_drsuapi_DsReplicaCursor_getsetters,
	.tp_methods = py_drsuapi_DsReplicaCursor_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaCursor_new,
};


static PyObject *py_drsuapi_DsReplicaCursorCtrEx_get_version(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaCursorCtrEx *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_drsuapi_DsReplicaCursorCtrEx_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaCursorCtrEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaCursorCtrEx_get_reserved1(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaCursorCtrEx *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved1;
	py_reserved1 = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved1));
	return py_reserved1;
}

static int py_drsuapi_DsReplicaCursorCtrEx_set_reserved1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaCursorCtrEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaCursorCtrEx_get_count(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaCursorCtrEx *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_drsuapi_DsReplicaCursorCtrEx_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaCursorCtrEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaCursorCtrEx_get_reserved2(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaCursorCtrEx *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved2;
	py_reserved2 = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved2));
	return py_reserved2;
}

static int py_drsuapi_DsReplicaCursorCtrEx_set_reserved2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaCursorCtrEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaCursorCtrEx_get_cursors(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaCursorCtrEx *object = pytalloc_get_ptr(obj);
	PyObject *py_cursors;
	py_cursors = PyList_New(object->count);
	if (py_cursors == NULL) {
		return NULL;
	}
	{
		int cursors_cntr_0;
		for (cursors_cntr_0 = 0; cursors_cntr_0 < (object->count); cursors_cntr_0++) {
			PyObject *py_cursors_0;
			py_cursors_0 = pytalloc_reference_ex(&drsuapi_DsReplicaCursor_Type, object->cursors, &(object->cursors)[cursors_cntr_0]);
			PyList_SetItem(py_cursors, cursors_cntr_0, py_cursors_0);
		}
	}
	return py_cursors;
}

static int py_drsuapi_DsReplicaCursorCtrEx_set_cursors(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaCursorCtrEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->cursors");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int cursors_cntr_0;
		object->cursors = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->cursors, PyList_GET_SIZE(value));
		if (!object->cursors) { return -1; }
		talloc_set_name_const(object->cursors, "ARRAY: object->cursors");
		for (cursors_cntr_0 = 0; cursors_cntr_0 < PyList_GET_SIZE(value); cursors_cntr_0++) {
			if (PyList_GET_ITEM(value, cursors_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->cursors)[cursors_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&drsuapi_DsReplicaCursor_Type, PyList_GET_ITEM(value, cursors_cntr_0), return -1;);
			if (talloc_reference(object->cursors, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, cursors_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->cursors)[cursors_cntr_0] = *(struct drsuapi_DsReplicaCursor *)pytalloc_get_ptr(PyList_GET_ITEM(value, cursors_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaCursorCtrEx_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_drsuapi_DsReplicaCursorCtrEx_get_version,
		.set = py_drsuapi_DsReplicaCursorCtrEx_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "reserved1"),
		.get = py_drsuapi_DsReplicaCursorCtrEx_get_reserved1,
		.set = py_drsuapi_DsReplicaCursorCtrEx_set_reserved1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "count"),
		.get = py_drsuapi_DsReplicaCursorCtrEx_get_count,
		.set = py_drsuapi_DsReplicaCursorCtrEx_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "reserved2"),
		.get = py_drsuapi_DsReplicaCursorCtrEx_get_reserved2,
		.set = py_drsuapi_DsReplicaCursorCtrEx_set_reserved2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "cursors"),
		.get = py_drsuapi_DsReplicaCursorCtrEx_get_cursors,
		.set = py_drsuapi_DsReplicaCursorCtrEx_set_cursors,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaCursor")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaCursorCtrEx_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaCursorCtrEx, type);
}


static PyTypeObject drsuapi_DsReplicaCursorCtrEx_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaCursorCtrEx",
	.tp_getset = py_drsuapi_DsReplicaCursorCtrEx_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaCursorCtrEx_new,
};


static PyObject *py_drsuapi_DsGetNCChangesRequest5_get_destination_dsa_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest5 *object = pytalloc_get_ptr(obj);
	PyObject *py_destination_dsa_guid;
	py_destination_dsa_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->destination_dsa_guid);
	return py_destination_dsa_guid;
}

static int py_drsuapi_DsGetNCChangesRequest5_set_destination_dsa_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest5 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->destination_dsa_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->destination_dsa_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest5_get_source_dsa_invocation_id(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest5 *object = pytalloc_get_ptr(obj);
	PyObject *py_source_dsa_invocation_id;
	py_source_dsa_invocation_id = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->source_dsa_invocation_id);
	return py_source_dsa_invocation_id;
}

static int py_drsuapi_DsGetNCChangesRequest5_set_source_dsa_invocation_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest5 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->source_dsa_invocation_id");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->source_dsa_invocation_id = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest5_get_naming_context(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest5 *object = pytalloc_get_ptr(obj);
	PyObject *py_naming_context;
	if (object->naming_context == NULL) {
		Py_RETURN_NONE;
	}
	py_naming_context = pytalloc_reference_ex(&drsuapi_DsReplicaObjectIdentifier_Type, object->naming_context, object->naming_context);
	return py_naming_context;
}

static int py_drsuapi_DsGetNCChangesRequest5_set_naming_context(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest5 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->naming_context));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->naming_context");
		return -1;
	}
	object->naming_context = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->naming_context);
	if (object->naming_context == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsReplicaObjectIdentifier_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->naming_context = (struct drsuapi_DsReplicaObjectIdentifier *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest5_get_highwatermark(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest5 *object = pytalloc_get_ptr(obj);
	PyObject *py_highwatermark;
	py_highwatermark = pytalloc_reference_ex(&drsuapi_DsReplicaHighWaterMark_Type, pytalloc_get_mem_ctx(obj), &object->highwatermark);
	return py_highwatermark;
}

static int py_drsuapi_DsGetNCChangesRequest5_set_highwatermark(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest5 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->highwatermark");
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsReplicaHighWaterMark_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->highwatermark = *(struct drsuapi_DsReplicaHighWaterMark *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest5_get_uptodateness_vector(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest5 *object = pytalloc_get_ptr(obj);
	PyObject *py_uptodateness_vector;
	if (object->uptodateness_vector == NULL) {
		Py_RETURN_NONE;
	}
	if (object->uptodateness_vector == NULL) {
		py_uptodateness_vector = Py_None;
		Py_INCREF(py_uptodateness_vector);
	} else {
		py_uptodateness_vector = pytalloc_reference_ex(&drsuapi_DsReplicaCursorCtrEx_Type, object->uptodateness_vector, object->uptodateness_vector);
	}
	return py_uptodateness_vector;
}

static int py_drsuapi_DsGetNCChangesRequest5_set_uptodateness_vector(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest5 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->uptodateness_vector));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->uptodateness_vector");
		return -1;
	}
	if (value == Py_None) {
		object->uptodateness_vector = NULL;
	} else {
		object->uptodateness_vector = NULL;
		PY_CHECK_TYPE(&drsuapi_DsReplicaCursorCtrEx_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->uptodateness_vector = (struct drsuapi_DsReplicaCursorCtrEx *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest5_get_replica_flags(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest5 *object = pytalloc_get_ptr(obj);
	PyObject *py_replica_flags;
	py_replica_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->replica_flags));
	return py_replica_flags;
}

static int py_drsuapi_DsGetNCChangesRequest5_set_replica_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest5 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->replica_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->replica_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->replica_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest5_get_max_object_count(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest5 *object = pytalloc_get_ptr(obj);
	PyObject *py_max_object_count;
	py_max_object_count = PyLong_FromUnsignedLongLong((uint32_t)(object->max_object_count));
	return py_max_object_count;
}

static int py_drsuapi_DsGetNCChangesRequest5_set_max_object_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest5 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->max_object_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->max_object_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->max_object_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest5_get_max_ndr_size(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest5 *object = pytalloc_get_ptr(obj);
	PyObject *py_max_ndr_size;
	py_max_ndr_size = PyLong_FromUnsignedLongLong((uint32_t)(object->max_ndr_size));
	return py_max_ndr_size;
}

static int py_drsuapi_DsGetNCChangesRequest5_set_max_ndr_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest5 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->max_ndr_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->max_ndr_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->max_ndr_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest5_get_extended_op(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest5 *object = pytalloc_get_ptr(obj);
	PyObject *py_extended_op;
	py_extended_op = PyLong_FromUnsignedLongLong((uint32_t)(object->extended_op));
	return py_extended_op;
}

static int py_drsuapi_DsGetNCChangesRequest5_set_extended_op(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest5 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->extended_op");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->extended_op));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->extended_op = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest5_get_fsmo_info(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest5 *object = pytalloc_get_ptr(obj);
	PyObject *py_fsmo_info;
	py_fsmo_info = PyLong_FromUnsignedLongLong(object->fsmo_info);
	return py_fsmo_info;
}

static int py_drsuapi_DsGetNCChangesRequest5_set_fsmo_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest5 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fsmo_info");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fsmo_info));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fsmo_info = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsGetNCChangesRequest5_getsetters[] = {
	{
		.name = discard_const_p(char, "destination_dsa_guid"),
		.get = py_drsuapi_DsGetNCChangesRequest5_get_destination_dsa_guid,
		.set = py_drsuapi_DsGetNCChangesRequest5_set_destination_dsa_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "source_dsa_invocation_id"),
		.get = py_drsuapi_DsGetNCChangesRequest5_get_source_dsa_invocation_id,
		.set = py_drsuapi_DsGetNCChangesRequest5_set_source_dsa_invocation_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "naming_context"),
		.get = py_drsuapi_DsGetNCChangesRequest5_get_naming_context,
		.set = py_drsuapi_DsGetNCChangesRequest5_set_naming_context,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObjectIdentifier")
	},
	{
		.name = discard_const_p(char, "highwatermark"),
		.get = py_drsuapi_DsGetNCChangesRequest5_get_highwatermark,
		.set = py_drsuapi_DsGetNCChangesRequest5_set_highwatermark,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaHighWaterMark")
	},
	{
		.name = discard_const_p(char, "uptodateness_vector"),
		.get = py_drsuapi_DsGetNCChangesRequest5_get_uptodateness_vector,
		.set = py_drsuapi_DsGetNCChangesRequest5_set_uptodateness_vector,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaCursorCtrEx")
	},
	{
		.name = discard_const_p(char, "replica_flags"),
		.get = py_drsuapi_DsGetNCChangesRequest5_get_replica_flags,
		.set = py_drsuapi_DsGetNCChangesRequest5_set_replica_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DrsOptions")
	},
	{
		.name = discard_const_p(char, "max_object_count"),
		.get = py_drsuapi_DsGetNCChangesRequest5_get_max_object_count,
		.set = py_drsuapi_DsGetNCChangesRequest5_set_max_object_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "max_ndr_size"),
		.get = py_drsuapi_DsGetNCChangesRequest5_get_max_ndr_size,
		.set = py_drsuapi_DsGetNCChangesRequest5_set_max_ndr_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "extended_op"),
		.get = py_drsuapi_DsGetNCChangesRequest5_get_extended_op,
		.set = py_drsuapi_DsGetNCChangesRequest5_set_extended_op,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsExtendedOperation")
	},
	{
		.name = discard_const_p(char, "fsmo_info"),
		.get = py_drsuapi_DsGetNCChangesRequest5_get_fsmo_info,
		.set = py_drsuapi_DsGetNCChangesRequest5_set_fsmo_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsGetNCChangesRequest5_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsGetNCChangesRequest5, type);
}


static PyTypeObject drsuapi_DsGetNCChangesRequest5_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetNCChangesRequest5",
	.tp_getset = py_drsuapi_DsGetNCChangesRequest5_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetNCChangesRequest5_new,
};


static PyObject *py_drsuapi_DsReplicaOID_get_length(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaOID *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromUnsignedLongLong((uint32_t)(object->length));
	return py_length;
}

static int py_drsuapi_DsReplicaOID_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaOID *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaOID_get_binary_oid(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaOID *object = pytalloc_get_ptr(obj);
	PyObject *py_binary_oid;
	if (object->binary_oid == NULL) {
		Py_RETURN_NONE;
	}
	if (object->binary_oid == NULL) {
		py_binary_oid = Py_None;
		Py_INCREF(py_binary_oid);
	} else {
		py_binary_oid = PyList_New(object->length);
		if (py_binary_oid == NULL) {
			return NULL;
		}
		{
			int binary_oid_cntr_1;
			for (binary_oid_cntr_1 = 0; binary_oid_cntr_1 < (object->length); binary_oid_cntr_1++) {
				PyObject *py_binary_oid_1;
				py_binary_oid_1 = PyLong_FromLong((uint16_t)((object->binary_oid)[binary_oid_cntr_1]));
				PyList_SetItem(py_binary_oid, binary_oid_cntr_1, py_binary_oid_1);
			}
		}
	}
	return py_binary_oid;
}

static int py_drsuapi_DsReplicaOID_set_binary_oid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaOID *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->binary_oid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->binary_oid");
		return -1;
	}
	if (value == Py_None) {
		object->binary_oid = NULL;
	} else {
		object->binary_oid = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int binary_oid_cntr_1;
			object->binary_oid = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->binary_oid, PyList_GET_SIZE(value));
			if (!object->binary_oid) { return -1; }
			talloc_set_name_const(object->binary_oid, "ARRAY: object->binary_oid");
			for (binary_oid_cntr_1 = 0; binary_oid_cntr_1 < PyList_GET_SIZE(value); binary_oid_cntr_1++) {
				if (PyList_GET_ITEM(value, binary_oid_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->binary_oid)[binary_oid_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->binary_oid)[binary_oid_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, binary_oid_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, binary_oid_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->binary_oid)[binary_oid_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaOID_getsetters[] = {
	{
		.name = discard_const_p(char, "length"),
		.get = py_drsuapi_DsReplicaOID_get_length,
		.set = py_drsuapi_DsReplicaOID_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "binary_oid"),
		.get = py_drsuapi_DsReplicaOID_get_binary_oid,
		.set = py_drsuapi_DsReplicaOID_set_binary_oid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaOID_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaOID, type);
}


static PyTypeObject drsuapi_DsReplicaOID_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaOID",
	.tp_getset = py_drsuapi_DsReplicaOID_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaOID_new,
};


static PyObject *py_drsuapi_DsReplicaOIDMapping_get_id_prefix(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaOIDMapping *object = pytalloc_get_ptr(obj);
	PyObject *py_id_prefix;
	py_id_prefix = PyLong_FromUnsignedLongLong((uint32_t)(object->id_prefix));
	return py_id_prefix;
}

static int py_drsuapi_DsReplicaOIDMapping_set_id_prefix(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaOIDMapping *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->id_prefix");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->id_prefix));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->id_prefix = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaOIDMapping_get_oid(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaOIDMapping *object = pytalloc_get_ptr(obj);
	PyObject *py_oid;
	py_oid = pytalloc_reference_ex(&drsuapi_DsReplicaOID_Type, pytalloc_get_mem_ctx(obj), &object->oid);
	return py_oid;
}

static int py_drsuapi_DsReplicaOIDMapping_set_oid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaOIDMapping *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->oid");
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsReplicaOID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->oid = *(struct drsuapi_DsReplicaOID *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaOIDMapping_getsetters[] = {
	{
		.name = discard_const_p(char, "id_prefix"),
		.get = py_drsuapi_DsReplicaOIDMapping_get_id_prefix,
		.set = py_drsuapi_DsReplicaOIDMapping_set_id_prefix,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "oid"),
		.get = py_drsuapi_DsReplicaOIDMapping_get_oid,
		.set = py_drsuapi_DsReplicaOIDMapping_set_oid,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaOID")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaOIDMapping_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaOIDMapping, type);
}


static PyTypeObject drsuapi_DsReplicaOIDMapping_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaOIDMapping",
	.tp_getset = py_drsuapi_DsReplicaOIDMapping_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaOIDMapping_new,
};


static PyObject *py_drsuapi_DsReplicaOIDMapping_Ctr_get_num_mappings(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaOIDMapping_Ctr *object = pytalloc_get_ptr(obj);
	PyObject *py_num_mappings;
	py_num_mappings = PyLong_FromUnsignedLongLong((uint32_t)(object->num_mappings));
	return py_num_mappings;
}

static int py_drsuapi_DsReplicaOIDMapping_Ctr_set_num_mappings(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaOIDMapping_Ctr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_mappings");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_mappings));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_mappings = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaOIDMapping_Ctr_get_mappings(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaOIDMapping_Ctr *object = pytalloc_get_ptr(obj);
	PyObject *py_mappings;
	if (object->mappings == NULL) {
		Py_RETURN_NONE;
	}
	if (object->mappings == NULL) {
		py_mappings = Py_None;
		Py_INCREF(py_mappings);
	} else {
		py_mappings = PyList_New(object->num_mappings);
		if (py_mappings == NULL) {
			return NULL;
		}
		{
			int mappings_cntr_1;
			for (mappings_cntr_1 = 0; mappings_cntr_1 < (object->num_mappings); mappings_cntr_1++) {
				PyObject *py_mappings_1;
				py_mappings_1 = pytalloc_reference_ex(&drsuapi_DsReplicaOIDMapping_Type, object->mappings, &(object->mappings)[mappings_cntr_1]);
				PyList_SetItem(py_mappings, mappings_cntr_1, py_mappings_1);
			}
		}
	}
	return py_mappings;
}

static int py_drsuapi_DsReplicaOIDMapping_Ctr_set_mappings(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaOIDMapping_Ctr *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->mappings));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->mappings");
		return -1;
	}
	if (value == Py_None) {
		object->mappings = NULL;
	} else {
		object->mappings = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int mappings_cntr_1;
			object->mappings = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->mappings, PyList_GET_SIZE(value));
			if (!object->mappings) { return -1; }
			talloc_set_name_const(object->mappings, "ARRAY: object->mappings");
			for (mappings_cntr_1 = 0; mappings_cntr_1 < PyList_GET_SIZE(value); mappings_cntr_1++) {
				if (PyList_GET_ITEM(value, mappings_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->mappings)[mappings_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&drsuapi_DsReplicaOIDMapping_Type, PyList_GET_ITEM(value, mappings_cntr_1), return -1;);
				if (talloc_reference(object->mappings, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, mappings_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->mappings)[mappings_cntr_1] = *(struct drsuapi_DsReplicaOIDMapping *)pytalloc_get_ptr(PyList_GET_ITEM(value, mappings_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaOIDMapping_Ctr_getsetters[] = {
	{
		.name = discard_const_p(char, "num_mappings"),
		.get = py_drsuapi_DsReplicaOIDMapping_Ctr_get_num_mappings,
		.set = py_drsuapi_DsReplicaOIDMapping_Ctr_set_num_mappings,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "mappings"),
		.get = py_drsuapi_DsReplicaOIDMapping_Ctr_get_mappings,
		.set = py_drsuapi_DsReplicaOIDMapping_Ctr_set_mappings,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaOIDMapping")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaOIDMapping_Ctr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaOIDMapping_Ctr, type);
}

static PyObject *py_drsuapi_DsReplicaOIDMapping_Ctr_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct drsuapi_DsReplicaOIDMapping_Ctr *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsReplicaOIDMapping_Ctr);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_drsuapi_DsReplicaOIDMapping_Ctr_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsReplicaOIDMapping_Ctr *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsReplicaOIDMapping_Ctr);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsReplicaOIDMapping_Ctr);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_drsuapi_DsReplicaOIDMapping_Ctr_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsReplicaOIDMapping_Ctr *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsReplicaOIDMapping_Ctr, "drsuapi_DsReplicaOIDMapping_Ctr", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsReplicaOIDMapping_Ctr, "drsuapi_DsReplicaOIDMapping_Ctr", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_drsuapi_DsReplicaOIDMapping_Ctr_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_drsuapi_DsReplicaOIDMapping_Ctr_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaOIDMapping_Ctr_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaOIDMapping_Ctr_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject drsuapi_DsReplicaOIDMapping_Ctr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaOIDMapping_Ctr",
	.tp_getset = py_drsuapi_DsReplicaOIDMapping_Ctr_getsetters,
	.tp_methods = py_drsuapi_DsReplicaOIDMapping_Ctr_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaOIDMapping_Ctr_new,
};


static PyObject *py_drsuapi_DsPartialAttributeSet_get_version(PyObject *obj, void *closure)
{
	struct drsuapi_DsPartialAttributeSet *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_drsuapi_DsPartialAttributeSet_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsPartialAttributeSet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsPartialAttributeSet_get_reserved1(PyObject *obj, void *closure)
{
	struct drsuapi_DsPartialAttributeSet *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved1;
	py_reserved1 = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved1));
	return py_reserved1;
}

static int py_drsuapi_DsPartialAttributeSet_set_reserved1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsPartialAttributeSet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsPartialAttributeSet_get_num_attids(PyObject *obj, void *closure)
{
	struct drsuapi_DsPartialAttributeSet *object = pytalloc_get_ptr(obj);
	PyObject *py_num_attids;
	py_num_attids = PyLong_FromUnsignedLongLong((uint32_t)(object->num_attids));
	return py_num_attids;
}

static int py_drsuapi_DsPartialAttributeSet_set_num_attids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsPartialAttributeSet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_attids");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_attids));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_attids = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsPartialAttributeSet_get_attids(PyObject *obj, void *closure)
{
	struct drsuapi_DsPartialAttributeSet *object = pytalloc_get_ptr(obj);
	PyObject *py_attids;
	py_attids = PyList_New(object->num_attids);
	if (py_attids == NULL) {
		return NULL;
	}
	{
		int attids_cntr_0;
		for (attids_cntr_0 = 0; attids_cntr_0 < (object->num_attids); attids_cntr_0++) {
			PyObject *py_attids_0;
			py_attids_0 = PyLong_FromUnsignedLongLong((uint32_t)((object->attids)[attids_cntr_0]));
			PyList_SetItem(py_attids, attids_cntr_0, py_attids_0);
		}
	}
	return py_attids;
}

static int py_drsuapi_DsPartialAttributeSet_set_attids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsPartialAttributeSet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->attids");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int attids_cntr_0;
		object->attids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->attids, PyList_GET_SIZE(value));
		if (!object->attids) { return -1; }
		talloc_set_name_const(object->attids, "ARRAY: object->attids");
		for (attids_cntr_0 = 0; attids_cntr_0 < PyList_GET_SIZE(value); attids_cntr_0++) {
			if (PyList_GET_ITEM(value, attids_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->attids)[attids_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->attids)[attids_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, attids_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, attids_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->attids)[attids_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsPartialAttributeSet_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_drsuapi_DsPartialAttributeSet_get_version,
		.set = py_drsuapi_DsPartialAttributeSet_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "reserved1"),
		.get = py_drsuapi_DsPartialAttributeSet_get_reserved1,
		.set = py_drsuapi_DsPartialAttributeSet_set_reserved1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "num_attids"),
		.get = py_drsuapi_DsPartialAttributeSet_get_num_attids,
		.set = py_drsuapi_DsPartialAttributeSet_set_num_attids,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "attids"),
		.get = py_drsuapi_DsPartialAttributeSet_get_attids,
		.set = py_drsuapi_DsPartialAttributeSet_set_attids,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsAttributeId")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsPartialAttributeSet_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsPartialAttributeSet, type);
}


static PyTypeObject drsuapi_DsPartialAttributeSet_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsPartialAttributeSet",
	.tp_getset = py_drsuapi_DsPartialAttributeSet_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsPartialAttributeSet_new,
};


static PyObject *py_drsuapi_DsGetNCChangesRequest8_get_destination_dsa_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest8 *object = pytalloc_get_ptr(obj);
	PyObject *py_destination_dsa_guid;
	py_destination_dsa_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->destination_dsa_guid);
	return py_destination_dsa_guid;
}

static int py_drsuapi_DsGetNCChangesRequest8_set_destination_dsa_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest8 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->destination_dsa_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->destination_dsa_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest8_get_source_dsa_invocation_id(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest8 *object = pytalloc_get_ptr(obj);
	PyObject *py_source_dsa_invocation_id;
	py_source_dsa_invocation_id = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->source_dsa_invocation_id);
	return py_source_dsa_invocation_id;
}

static int py_drsuapi_DsGetNCChangesRequest8_set_source_dsa_invocation_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest8 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->source_dsa_invocation_id");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->source_dsa_invocation_id = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest8_get_naming_context(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest8 *object = pytalloc_get_ptr(obj);
	PyObject *py_naming_context;
	if (object->naming_context == NULL) {
		Py_RETURN_NONE;
	}
	py_naming_context = pytalloc_reference_ex(&drsuapi_DsReplicaObjectIdentifier_Type, object->naming_context, object->naming_context);
	return py_naming_context;
}

static int py_drsuapi_DsGetNCChangesRequest8_set_naming_context(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest8 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->naming_context));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->naming_context");
		return -1;
	}
	object->naming_context = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->naming_context);
	if (object->naming_context == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsReplicaObjectIdentifier_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->naming_context = (struct drsuapi_DsReplicaObjectIdentifier *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest8_get_highwatermark(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest8 *object = pytalloc_get_ptr(obj);
	PyObject *py_highwatermark;
	py_highwatermark = pytalloc_reference_ex(&drsuapi_DsReplicaHighWaterMark_Type, pytalloc_get_mem_ctx(obj), &object->highwatermark);
	return py_highwatermark;
}

static int py_drsuapi_DsGetNCChangesRequest8_set_highwatermark(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest8 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->highwatermark");
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsReplicaHighWaterMark_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->highwatermark = *(struct drsuapi_DsReplicaHighWaterMark *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest8_get_uptodateness_vector(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest8 *object = pytalloc_get_ptr(obj);
	PyObject *py_uptodateness_vector;
	if (object->uptodateness_vector == NULL) {
		Py_RETURN_NONE;
	}
	if (object->uptodateness_vector == NULL) {
		py_uptodateness_vector = Py_None;
		Py_INCREF(py_uptodateness_vector);
	} else {
		py_uptodateness_vector = pytalloc_reference_ex(&drsuapi_DsReplicaCursorCtrEx_Type, object->uptodateness_vector, object->uptodateness_vector);
	}
	return py_uptodateness_vector;
}

static int py_drsuapi_DsGetNCChangesRequest8_set_uptodateness_vector(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest8 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->uptodateness_vector));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->uptodateness_vector");
		return -1;
	}
	if (value == Py_None) {
		object->uptodateness_vector = NULL;
	} else {
		object->uptodateness_vector = NULL;
		PY_CHECK_TYPE(&drsuapi_DsReplicaCursorCtrEx_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->uptodateness_vector = (struct drsuapi_DsReplicaCursorCtrEx *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest8_get_replica_flags(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest8 *object = pytalloc_get_ptr(obj);
	PyObject *py_replica_flags;
	py_replica_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->replica_flags));
	return py_replica_flags;
}

static int py_drsuapi_DsGetNCChangesRequest8_set_replica_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest8 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->replica_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->replica_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->replica_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest8_get_max_object_count(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest8 *object = pytalloc_get_ptr(obj);
	PyObject *py_max_object_count;
	py_max_object_count = PyLong_FromUnsignedLongLong((uint32_t)(object->max_object_count));
	return py_max_object_count;
}

static int py_drsuapi_DsGetNCChangesRequest8_set_max_object_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest8 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->max_object_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->max_object_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->max_object_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest8_get_max_ndr_size(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest8 *object = pytalloc_get_ptr(obj);
	PyObject *py_max_ndr_size;
	py_max_ndr_size = PyLong_FromUnsignedLongLong((uint32_t)(object->max_ndr_size));
	return py_max_ndr_size;
}

static int py_drsuapi_DsGetNCChangesRequest8_set_max_ndr_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest8 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->max_ndr_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->max_ndr_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->max_ndr_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest8_get_extended_op(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest8 *object = pytalloc_get_ptr(obj);
	PyObject *py_extended_op;
	py_extended_op = PyLong_FromUnsignedLongLong((uint32_t)(object->extended_op));
	return py_extended_op;
}

static int py_drsuapi_DsGetNCChangesRequest8_set_extended_op(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest8 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->extended_op");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->extended_op));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->extended_op = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest8_get_fsmo_info(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest8 *object = pytalloc_get_ptr(obj);
	PyObject *py_fsmo_info;
	py_fsmo_info = PyLong_FromUnsignedLongLong(object->fsmo_info);
	return py_fsmo_info;
}

static int py_drsuapi_DsGetNCChangesRequest8_set_fsmo_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest8 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fsmo_info");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fsmo_info));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fsmo_info = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest8_get_partial_attribute_set(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest8 *object = pytalloc_get_ptr(obj);
	PyObject *py_partial_attribute_set;
	if (object->partial_attribute_set == NULL) {
		Py_RETURN_NONE;
	}
	if (object->partial_attribute_set == NULL) {
		py_partial_attribute_set = Py_None;
		Py_INCREF(py_partial_attribute_set);
	} else {
		py_partial_attribute_set = pytalloc_reference_ex(&drsuapi_DsPartialAttributeSet_Type, object->partial_attribute_set, object->partial_attribute_set);
	}
	return py_partial_attribute_set;
}

static int py_drsuapi_DsGetNCChangesRequest8_set_partial_attribute_set(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest8 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->partial_attribute_set));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->partial_attribute_set");
		return -1;
	}
	if (value == Py_None) {
		object->partial_attribute_set = NULL;
	} else {
		object->partial_attribute_set = NULL;
		PY_CHECK_TYPE(&drsuapi_DsPartialAttributeSet_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->partial_attribute_set = (struct drsuapi_DsPartialAttributeSet *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest8_get_partial_attribute_set_ex(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest8 *object = pytalloc_get_ptr(obj);
	PyObject *py_partial_attribute_set_ex;
	if (object->partial_attribute_set_ex == NULL) {
		Py_RETURN_NONE;
	}
	if (object->partial_attribute_set_ex == NULL) {
		py_partial_attribute_set_ex = Py_None;
		Py_INCREF(py_partial_attribute_set_ex);
	} else {
		py_partial_attribute_set_ex = pytalloc_reference_ex(&drsuapi_DsPartialAttributeSet_Type, object->partial_attribute_set_ex, object->partial_attribute_set_ex);
	}
	return py_partial_attribute_set_ex;
}

static int py_drsuapi_DsGetNCChangesRequest8_set_partial_attribute_set_ex(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest8 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->partial_attribute_set_ex));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->partial_attribute_set_ex");
		return -1;
	}
	if (value == Py_None) {
		object->partial_attribute_set_ex = NULL;
	} else {
		object->partial_attribute_set_ex = NULL;
		PY_CHECK_TYPE(&drsuapi_DsPartialAttributeSet_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->partial_attribute_set_ex = (struct drsuapi_DsPartialAttributeSet *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest8_get_mapping_ctr(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest8 *object = pytalloc_get_ptr(obj);
	PyObject *py_mapping_ctr;
	py_mapping_ctr = pytalloc_reference_ex(&drsuapi_DsReplicaOIDMapping_Ctr_Type, pytalloc_get_mem_ctx(obj), &object->mapping_ctr);
	return py_mapping_ctr;
}

static int py_drsuapi_DsGetNCChangesRequest8_set_mapping_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest8 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->mapping_ctr");
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsReplicaOIDMapping_Ctr_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->mapping_ctr = *(struct drsuapi_DsReplicaOIDMapping_Ctr *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_drsuapi_DsGetNCChangesRequest8_getsetters[] = {
	{
		.name = discard_const_p(char, "destination_dsa_guid"),
		.get = py_drsuapi_DsGetNCChangesRequest8_get_destination_dsa_guid,
		.set = py_drsuapi_DsGetNCChangesRequest8_set_destination_dsa_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "source_dsa_invocation_id"),
		.get = py_drsuapi_DsGetNCChangesRequest8_get_source_dsa_invocation_id,
		.set = py_drsuapi_DsGetNCChangesRequest8_set_source_dsa_invocation_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "naming_context"),
		.get = py_drsuapi_DsGetNCChangesRequest8_get_naming_context,
		.set = py_drsuapi_DsGetNCChangesRequest8_set_naming_context,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObjectIdentifier")
	},
	{
		.name = discard_const_p(char, "highwatermark"),
		.get = py_drsuapi_DsGetNCChangesRequest8_get_highwatermark,
		.set = py_drsuapi_DsGetNCChangesRequest8_set_highwatermark,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaHighWaterMark")
	},
	{
		.name = discard_const_p(char, "uptodateness_vector"),
		.get = py_drsuapi_DsGetNCChangesRequest8_get_uptodateness_vector,
		.set = py_drsuapi_DsGetNCChangesRequest8_set_uptodateness_vector,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaCursorCtrEx")
	},
	{
		.name = discard_const_p(char, "replica_flags"),
		.get = py_drsuapi_DsGetNCChangesRequest8_get_replica_flags,
		.set = py_drsuapi_DsGetNCChangesRequest8_set_replica_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DrsOptions")
	},
	{
		.name = discard_const_p(char, "max_object_count"),
		.get = py_drsuapi_DsGetNCChangesRequest8_get_max_object_count,
		.set = py_drsuapi_DsGetNCChangesRequest8_set_max_object_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "max_ndr_size"),
		.get = py_drsuapi_DsGetNCChangesRequest8_get_max_ndr_size,
		.set = py_drsuapi_DsGetNCChangesRequest8_set_max_ndr_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "extended_op"),
		.get = py_drsuapi_DsGetNCChangesRequest8_get_extended_op,
		.set = py_drsuapi_DsGetNCChangesRequest8_set_extended_op,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsExtendedOperation")
	},
	{
		.name = discard_const_p(char, "fsmo_info"),
		.get = py_drsuapi_DsGetNCChangesRequest8_get_fsmo_info,
		.set = py_drsuapi_DsGetNCChangesRequest8_set_fsmo_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "partial_attribute_set"),
		.get = py_drsuapi_DsGetNCChangesRequest8_get_partial_attribute_set,
		.set = py_drsuapi_DsGetNCChangesRequest8_set_partial_attribute_set,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsPartialAttributeSet")
	},
	{
		.name = discard_const_p(char, "partial_attribute_set_ex"),
		.get = py_drsuapi_DsGetNCChangesRequest8_get_partial_attribute_set_ex,
		.set = py_drsuapi_DsGetNCChangesRequest8_set_partial_attribute_set_ex,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsPartialAttributeSet")
	},
	{
		.name = discard_const_p(char, "mapping_ctr"),
		.get = py_drsuapi_DsGetNCChangesRequest8_get_mapping_ctr,
		.set = py_drsuapi_DsGetNCChangesRequest8_set_mapping_ctr,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaOIDMapping_Ctr")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsGetNCChangesRequest8_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsGetNCChangesRequest8, type);
}

static PyObject *py_drsuapi_DsGetNCChangesRequest8_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct drsuapi_DsGetNCChangesRequest8 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsGetNCChangesRequest8);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest8_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsGetNCChangesRequest8 *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsGetNCChangesRequest8);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsGetNCChangesRequest8);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest8_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsGetNCChangesRequest8 *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsGetNCChangesRequest8, "drsuapi_DsGetNCChangesRequest8", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsGetNCChangesRequest8, "drsuapi_DsGetNCChangesRequest8", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_drsuapi_DsGetNCChangesRequest8_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_drsuapi_DsGetNCChangesRequest8_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsGetNCChangesRequest8_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsGetNCChangesRequest8_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject drsuapi_DsGetNCChangesRequest8_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetNCChangesRequest8",
	.tp_getset = py_drsuapi_DsGetNCChangesRequest8_getsetters,
	.tp_methods = py_drsuapi_DsGetNCChangesRequest8_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetNCChangesRequest8_new,
};


static PyObject *py_drsuapi_DsGetNCChangesRequest10_get_destination_dsa_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest10 *object = pytalloc_get_ptr(obj);
	PyObject *py_destination_dsa_guid;
	py_destination_dsa_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->destination_dsa_guid);
	return py_destination_dsa_guid;
}

static int py_drsuapi_DsGetNCChangesRequest10_set_destination_dsa_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest10 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->destination_dsa_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->destination_dsa_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest10_get_source_dsa_invocation_id(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest10 *object = pytalloc_get_ptr(obj);
	PyObject *py_source_dsa_invocation_id;
	py_source_dsa_invocation_id = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->source_dsa_invocation_id);
	return py_source_dsa_invocation_id;
}

static int py_drsuapi_DsGetNCChangesRequest10_set_source_dsa_invocation_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest10 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->source_dsa_invocation_id");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->source_dsa_invocation_id = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest10_get_naming_context(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest10 *object = pytalloc_get_ptr(obj);
	PyObject *py_naming_context;
	if (object->naming_context == NULL) {
		Py_RETURN_NONE;
	}
	py_naming_context = pytalloc_reference_ex(&drsuapi_DsReplicaObjectIdentifier_Type, object->naming_context, object->naming_context);
	return py_naming_context;
}

static int py_drsuapi_DsGetNCChangesRequest10_set_naming_context(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest10 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->naming_context));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->naming_context");
		return -1;
	}
	object->naming_context = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->naming_context);
	if (object->naming_context == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsReplicaObjectIdentifier_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->naming_context = (struct drsuapi_DsReplicaObjectIdentifier *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest10_get_highwatermark(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest10 *object = pytalloc_get_ptr(obj);
	PyObject *py_highwatermark;
	py_highwatermark = pytalloc_reference_ex(&drsuapi_DsReplicaHighWaterMark_Type, pytalloc_get_mem_ctx(obj), &object->highwatermark);
	return py_highwatermark;
}

static int py_drsuapi_DsGetNCChangesRequest10_set_highwatermark(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest10 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->highwatermark");
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsReplicaHighWaterMark_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->highwatermark = *(struct drsuapi_DsReplicaHighWaterMark *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest10_get_uptodateness_vector(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest10 *object = pytalloc_get_ptr(obj);
	PyObject *py_uptodateness_vector;
	if (object->uptodateness_vector == NULL) {
		Py_RETURN_NONE;
	}
	if (object->uptodateness_vector == NULL) {
		py_uptodateness_vector = Py_None;
		Py_INCREF(py_uptodateness_vector);
	} else {
		py_uptodateness_vector = pytalloc_reference_ex(&drsuapi_DsReplicaCursorCtrEx_Type, object->uptodateness_vector, object->uptodateness_vector);
	}
	return py_uptodateness_vector;
}

static int py_drsuapi_DsGetNCChangesRequest10_set_uptodateness_vector(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest10 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->uptodateness_vector));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->uptodateness_vector");
		return -1;
	}
	if (value == Py_None) {
		object->uptodateness_vector = NULL;
	} else {
		object->uptodateness_vector = NULL;
		PY_CHECK_TYPE(&drsuapi_DsReplicaCursorCtrEx_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->uptodateness_vector = (struct drsuapi_DsReplicaCursorCtrEx *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest10_get_replica_flags(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest10 *object = pytalloc_get_ptr(obj);
	PyObject *py_replica_flags;
	py_replica_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->replica_flags));
	return py_replica_flags;
}

static int py_drsuapi_DsGetNCChangesRequest10_set_replica_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest10 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->replica_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->replica_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->replica_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest10_get_max_object_count(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest10 *object = pytalloc_get_ptr(obj);
	PyObject *py_max_object_count;
	py_max_object_count = PyLong_FromUnsignedLongLong((uint32_t)(object->max_object_count));
	return py_max_object_count;
}

static int py_drsuapi_DsGetNCChangesRequest10_set_max_object_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest10 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->max_object_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->max_object_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->max_object_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest10_get_max_ndr_size(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest10 *object = pytalloc_get_ptr(obj);
	PyObject *py_max_ndr_size;
	py_max_ndr_size = PyLong_FromUnsignedLongLong((uint32_t)(object->max_ndr_size));
	return py_max_ndr_size;
}

static int py_drsuapi_DsGetNCChangesRequest10_set_max_ndr_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest10 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->max_ndr_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->max_ndr_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->max_ndr_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest10_get_extended_op(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest10 *object = pytalloc_get_ptr(obj);
	PyObject *py_extended_op;
	py_extended_op = PyLong_FromUnsignedLongLong((uint32_t)(object->extended_op));
	return py_extended_op;
}

static int py_drsuapi_DsGetNCChangesRequest10_set_extended_op(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest10 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->extended_op");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->extended_op));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->extended_op = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest10_get_fsmo_info(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest10 *object = pytalloc_get_ptr(obj);
	PyObject *py_fsmo_info;
	py_fsmo_info = PyLong_FromUnsignedLongLong(object->fsmo_info);
	return py_fsmo_info;
}

static int py_drsuapi_DsGetNCChangesRequest10_set_fsmo_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest10 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fsmo_info");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fsmo_info));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fsmo_info = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest10_get_partial_attribute_set(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest10 *object = pytalloc_get_ptr(obj);
	PyObject *py_partial_attribute_set;
	if (object->partial_attribute_set == NULL) {
		Py_RETURN_NONE;
	}
	if (object->partial_attribute_set == NULL) {
		py_partial_attribute_set = Py_None;
		Py_INCREF(py_partial_attribute_set);
	} else {
		py_partial_attribute_set = pytalloc_reference_ex(&drsuapi_DsPartialAttributeSet_Type, object->partial_attribute_set, object->partial_attribute_set);
	}
	return py_partial_attribute_set;
}

static int py_drsuapi_DsGetNCChangesRequest10_set_partial_attribute_set(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest10 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->partial_attribute_set));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->partial_attribute_set");
		return -1;
	}
	if (value == Py_None) {
		object->partial_attribute_set = NULL;
	} else {
		object->partial_attribute_set = NULL;
		PY_CHECK_TYPE(&drsuapi_DsPartialAttributeSet_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->partial_attribute_set = (struct drsuapi_DsPartialAttributeSet *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest10_get_partial_attribute_set_ex(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest10 *object = pytalloc_get_ptr(obj);
	PyObject *py_partial_attribute_set_ex;
	if (object->partial_attribute_set_ex == NULL) {
		Py_RETURN_NONE;
	}
	if (object->partial_attribute_set_ex == NULL) {
		py_partial_attribute_set_ex = Py_None;
		Py_INCREF(py_partial_attribute_set_ex);
	} else {
		py_partial_attribute_set_ex = pytalloc_reference_ex(&drsuapi_DsPartialAttributeSet_Type, object->partial_attribute_set_ex, object->partial_attribute_set_ex);
	}
	return py_partial_attribute_set_ex;
}

static int py_drsuapi_DsGetNCChangesRequest10_set_partial_attribute_set_ex(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest10 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->partial_attribute_set_ex));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->partial_attribute_set_ex");
		return -1;
	}
	if (value == Py_None) {
		object->partial_attribute_set_ex = NULL;
	} else {
		object->partial_attribute_set_ex = NULL;
		PY_CHECK_TYPE(&drsuapi_DsPartialAttributeSet_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->partial_attribute_set_ex = (struct drsuapi_DsPartialAttributeSet *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest10_get_mapping_ctr(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest10 *object = pytalloc_get_ptr(obj);
	PyObject *py_mapping_ctr;
	py_mapping_ctr = pytalloc_reference_ex(&drsuapi_DsReplicaOIDMapping_Ctr_Type, pytalloc_get_mem_ctx(obj), &object->mapping_ctr);
	return py_mapping_ctr;
}

static int py_drsuapi_DsGetNCChangesRequest10_set_mapping_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest10 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->mapping_ctr");
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsReplicaOIDMapping_Ctr_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->mapping_ctr = *(struct drsuapi_DsReplicaOIDMapping_Ctr *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest10_get_more_flags(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest10 *object = pytalloc_get_ptr(obj);
	PyObject *py_more_flags;
	py_more_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->more_flags));
	return py_more_flags;
}

static int py_drsuapi_DsGetNCChangesRequest10_set_more_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesRequest10 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->more_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->more_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->more_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsGetNCChangesRequest10_getsetters[] = {
	{
		.name = discard_const_p(char, "destination_dsa_guid"),
		.get = py_drsuapi_DsGetNCChangesRequest10_get_destination_dsa_guid,
		.set = py_drsuapi_DsGetNCChangesRequest10_set_destination_dsa_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "source_dsa_invocation_id"),
		.get = py_drsuapi_DsGetNCChangesRequest10_get_source_dsa_invocation_id,
		.set = py_drsuapi_DsGetNCChangesRequest10_set_source_dsa_invocation_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "naming_context"),
		.get = py_drsuapi_DsGetNCChangesRequest10_get_naming_context,
		.set = py_drsuapi_DsGetNCChangesRequest10_set_naming_context,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObjectIdentifier")
	},
	{
		.name = discard_const_p(char, "highwatermark"),
		.get = py_drsuapi_DsGetNCChangesRequest10_get_highwatermark,
		.set = py_drsuapi_DsGetNCChangesRequest10_set_highwatermark,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaHighWaterMark")
	},
	{
		.name = discard_const_p(char, "uptodateness_vector"),
		.get = py_drsuapi_DsGetNCChangesRequest10_get_uptodateness_vector,
		.set = py_drsuapi_DsGetNCChangesRequest10_set_uptodateness_vector,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaCursorCtrEx")
	},
	{
		.name = discard_const_p(char, "replica_flags"),
		.get = py_drsuapi_DsGetNCChangesRequest10_get_replica_flags,
		.set = py_drsuapi_DsGetNCChangesRequest10_set_replica_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DrsOptions")
	},
	{
		.name = discard_const_p(char, "max_object_count"),
		.get = py_drsuapi_DsGetNCChangesRequest10_get_max_object_count,
		.set = py_drsuapi_DsGetNCChangesRequest10_set_max_object_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "max_ndr_size"),
		.get = py_drsuapi_DsGetNCChangesRequest10_get_max_ndr_size,
		.set = py_drsuapi_DsGetNCChangesRequest10_set_max_ndr_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "extended_op"),
		.get = py_drsuapi_DsGetNCChangesRequest10_get_extended_op,
		.set = py_drsuapi_DsGetNCChangesRequest10_set_extended_op,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsExtendedOperation")
	},
	{
		.name = discard_const_p(char, "fsmo_info"),
		.get = py_drsuapi_DsGetNCChangesRequest10_get_fsmo_info,
		.set = py_drsuapi_DsGetNCChangesRequest10_set_fsmo_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "partial_attribute_set"),
		.get = py_drsuapi_DsGetNCChangesRequest10_get_partial_attribute_set,
		.set = py_drsuapi_DsGetNCChangesRequest10_set_partial_attribute_set,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsPartialAttributeSet")
	},
	{
		.name = discard_const_p(char, "partial_attribute_set_ex"),
		.get = py_drsuapi_DsGetNCChangesRequest10_get_partial_attribute_set_ex,
		.set = py_drsuapi_DsGetNCChangesRequest10_set_partial_attribute_set_ex,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsPartialAttributeSet")
	},
	{
		.name = discard_const_p(char, "mapping_ctr"),
		.get = py_drsuapi_DsGetNCChangesRequest10_get_mapping_ctr,
		.set = py_drsuapi_DsGetNCChangesRequest10_set_mapping_ctr,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaOIDMapping_Ctr")
	},
	{
		.name = discard_const_p(char, "more_flags"),
		.get = py_drsuapi_DsGetNCChangesRequest10_get_more_flags,
		.set = py_drsuapi_DsGetNCChangesRequest10_set_more_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DrsMoreOptions")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsGetNCChangesRequest10_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsGetNCChangesRequest10, type);
}

static PyObject *py_drsuapi_DsGetNCChangesRequest10_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct drsuapi_DsGetNCChangesRequest10 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsGetNCChangesRequest10);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest10_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsGetNCChangesRequest10 *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsGetNCChangesRequest10);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsGetNCChangesRequest10);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest10_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsGetNCChangesRequest10 *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsGetNCChangesRequest10, "drsuapi_DsGetNCChangesRequest10", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsGetNCChangesRequest10, "drsuapi_DsGetNCChangesRequest10", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_drsuapi_DsGetNCChangesRequest10_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_drsuapi_DsGetNCChangesRequest10_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsGetNCChangesRequest10_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsGetNCChangesRequest10_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject drsuapi_DsGetNCChangesRequest10_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetNCChangesRequest10",
	.tp_getset = py_drsuapi_DsGetNCChangesRequest10_getsetters,
	.tp_methods = py_drsuapi_DsGetNCChangesRequest10_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetNCChangesRequest10_new,
};

static PyObject *py_import_drsuapi_DsGetNCChangesRequest(TALLOC_CTX *mem_ctx, int level, union drsuapi_DsGetNCChangesRequest *in)
{
	PyObject *ret;

	switch (level) {
		case 5:
			ret = pytalloc_reference_ex(&drsuapi_DsGetNCChangesRequest5_Type, mem_ctx, &in->req5);
			return ret;

		case 8:
			ret = pytalloc_reference_ex(&drsuapi_DsGetNCChangesRequest8_Type, mem_ctx, &in->req8);
			return ret;

		case 10:
			ret = pytalloc_reference_ex(&drsuapi_DsGetNCChangesRequest10_Type, mem_ctx, &in->req10);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union drsuapi_DsGetNCChangesRequest *py_export_drsuapi_DsGetNCChangesRequest(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union drsuapi_DsGetNCChangesRequest *ret = talloc_zero(mem_ctx, union drsuapi_DsGetNCChangesRequest);
	switch (level) {
		case 5:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->req5");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsGetNCChangesRequest5_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->req5 = *(struct drsuapi_DsGetNCChangesRequest5 *)pytalloc_get_ptr(in);
			break;

		case 8:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->req8");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsGetNCChangesRequest8_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->req8 = *(struct drsuapi_DsGetNCChangesRequest8 *)pytalloc_get_ptr(in);
			break;

		case 10:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->req10");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsGetNCChangesRequest10_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->req10 = *(struct drsuapi_DsGetNCChangesRequest10 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_drsuapi_DsGetNCChangesRequest_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union drsuapi_DsGetNCChangesRequest *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union drsuapi_DsGetNCChangesRequest *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union drsuapi_DsGetNCChangesRequest!");
		return NULL;
	}

	return py_import_drsuapi_DsGetNCChangesRequest(mem_ctx, level, in);
}

static PyObject *py_drsuapi_DsGetNCChangesRequest_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union drsuapi_DsGetNCChangesRequest *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_drsuapi_DsGetNCChangesRequest(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_drsuapi_DsGetNCChangesRequest_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsGetNCChangesRequest_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsGetNCChangesRequest_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_drsuapi_DsGetNCChangesRequest_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject drsuapi_DsGetNCChangesRequest_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetNCChangesRequest",
	.tp_getset = NULL,
	.tp_methods = py_drsuapi_DsGetNCChangesRequest_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetNCChangesRequest_new,
};


static PyObject *py_drsuapi_DsReplicaCursor2_get_source_dsa_invocation_id(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaCursor2 *object = pytalloc_get_ptr(obj);
	PyObject *py_source_dsa_invocation_id;
	py_source_dsa_invocation_id = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->source_dsa_invocation_id);
	return py_source_dsa_invocation_id;
}

static int py_drsuapi_DsReplicaCursor2_set_source_dsa_invocation_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaCursor2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->source_dsa_invocation_id");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->source_dsa_invocation_id = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsReplicaCursor2_get_highest_usn(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaCursor2 *object = pytalloc_get_ptr(obj);
	PyObject *py_highest_usn;
	py_highest_usn = PyLong_FromUnsignedLongLong(object->highest_usn);
	return py_highest_usn;
}

static int py_drsuapi_DsReplicaCursor2_set_highest_usn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaCursor2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->highest_usn");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->highest_usn));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->highest_usn = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaCursor2_get_last_sync_success(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaCursor2 *object = pytalloc_get_ptr(obj);
	PyObject *py_last_sync_success;
	py_last_sync_success = PyLong_FromUnsignedLongLong(object->last_sync_success);
	return py_last_sync_success;
}

static int py_drsuapi_DsReplicaCursor2_set_last_sync_success(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaCursor2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->last_sync_success");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->last_sync_success));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->last_sync_success = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaCursor2_getsetters[] = {
	{
		.name = discard_const_p(char, "source_dsa_invocation_id"),
		.get = py_drsuapi_DsReplicaCursor2_get_source_dsa_invocation_id,
		.set = py_drsuapi_DsReplicaCursor2_set_source_dsa_invocation_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "highest_usn"),
		.get = py_drsuapi_DsReplicaCursor2_get_highest_usn,
		.set = py_drsuapi_DsReplicaCursor2_set_highest_usn,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "last_sync_success"),
		.get = py_drsuapi_DsReplicaCursor2_get_last_sync_success,
		.set = py_drsuapi_DsReplicaCursor2_set_last_sync_success,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaCursor2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaCursor2, type);
}

static PyObject *py_drsuapi_DsReplicaCursor2_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct drsuapi_DsReplicaCursor2 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsReplicaCursor2);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_drsuapi_DsReplicaCursor2_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsReplicaCursor2 *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsReplicaCursor2);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsReplicaCursor2);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_drsuapi_DsReplicaCursor2_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsReplicaCursor2 *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsReplicaCursor2, "drsuapi_DsReplicaCursor2", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsReplicaCursor2, "drsuapi_DsReplicaCursor2", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_drsuapi_DsReplicaCursor2_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_drsuapi_DsReplicaCursor2_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaCursor2_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaCursor2_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject drsuapi_DsReplicaCursor2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaCursor2",
	.tp_getset = py_drsuapi_DsReplicaCursor2_getsetters,
	.tp_methods = py_drsuapi_DsReplicaCursor2_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaCursor2_new,
};


static PyObject *py_drsuapi_DsReplicaCursor2CtrEx_get_version(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaCursor2CtrEx *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_drsuapi_DsReplicaCursor2CtrEx_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaCursor2CtrEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaCursor2CtrEx_get_reserved1(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaCursor2CtrEx *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved1;
	py_reserved1 = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved1));
	return py_reserved1;
}

static int py_drsuapi_DsReplicaCursor2CtrEx_set_reserved1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaCursor2CtrEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaCursor2CtrEx_get_count(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaCursor2CtrEx *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_drsuapi_DsReplicaCursor2CtrEx_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaCursor2CtrEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaCursor2CtrEx_get_reserved2(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaCursor2CtrEx *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved2;
	py_reserved2 = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved2));
	return py_reserved2;
}

static int py_drsuapi_DsReplicaCursor2CtrEx_set_reserved2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaCursor2CtrEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaCursor2CtrEx_get_cursors(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaCursor2CtrEx *object = pytalloc_get_ptr(obj);
	PyObject *py_cursors;
	py_cursors = PyList_New(object->count);
	if (py_cursors == NULL) {
		return NULL;
	}
	{
		int cursors_cntr_0;
		for (cursors_cntr_0 = 0; cursors_cntr_0 < (object->count); cursors_cntr_0++) {
			PyObject *py_cursors_0;
			py_cursors_0 = pytalloc_reference_ex(&drsuapi_DsReplicaCursor2_Type, object->cursors, &(object->cursors)[cursors_cntr_0]);
			PyList_SetItem(py_cursors, cursors_cntr_0, py_cursors_0);
		}
	}
	return py_cursors;
}

static int py_drsuapi_DsReplicaCursor2CtrEx_set_cursors(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaCursor2CtrEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->cursors");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int cursors_cntr_0;
		object->cursors = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->cursors, PyList_GET_SIZE(value));
		if (!object->cursors) { return -1; }
		talloc_set_name_const(object->cursors, "ARRAY: object->cursors");
		for (cursors_cntr_0 = 0; cursors_cntr_0 < PyList_GET_SIZE(value); cursors_cntr_0++) {
			if (PyList_GET_ITEM(value, cursors_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->cursors)[cursors_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&drsuapi_DsReplicaCursor2_Type, PyList_GET_ITEM(value, cursors_cntr_0), return -1;);
			if (talloc_reference(object->cursors, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, cursors_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->cursors)[cursors_cntr_0] = *(struct drsuapi_DsReplicaCursor2 *)pytalloc_get_ptr(PyList_GET_ITEM(value, cursors_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaCursor2CtrEx_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_drsuapi_DsReplicaCursor2CtrEx_get_version,
		.set = py_drsuapi_DsReplicaCursor2CtrEx_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "reserved1"),
		.get = py_drsuapi_DsReplicaCursor2CtrEx_get_reserved1,
		.set = py_drsuapi_DsReplicaCursor2CtrEx_set_reserved1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "count"),
		.get = py_drsuapi_DsReplicaCursor2CtrEx_get_count,
		.set = py_drsuapi_DsReplicaCursor2CtrEx_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "reserved2"),
		.get = py_drsuapi_DsReplicaCursor2CtrEx_get_reserved2,
		.set = py_drsuapi_DsReplicaCursor2CtrEx_set_reserved2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "cursors"),
		.get = py_drsuapi_DsReplicaCursor2CtrEx_get_cursors,
		.set = py_drsuapi_DsReplicaCursor2CtrEx_set_cursors,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaCursor2")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaCursor2CtrEx_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaCursor2CtrEx, type);
}


static PyTypeObject drsuapi_DsReplicaCursor2CtrEx_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaCursor2CtrEx",
	.tp_getset = py_drsuapi_DsReplicaCursor2CtrEx_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaCursor2CtrEx_new,
};


static PyObject *py_drsuapi_DsAttributeValue_get___ndr_size(PyObject *obj, void *closure)
{
	struct drsuapi_DsAttributeValue *object = pytalloc_get_ptr(obj);
	PyObject *py___ndr_size;
	py___ndr_size = PyLong_FromUnsignedLongLong((uint32_t)(object->__ndr_size));
	return py___ndr_size;
}

static int py_drsuapi_DsAttributeValue_set___ndr_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAttributeValue *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->__ndr_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->__ndr_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->__ndr_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsAttributeValue_get_blob(PyObject *obj, void *closure)
{
	struct drsuapi_DsAttributeValue *object = pytalloc_get_ptr(obj);
	PyObject *py_blob;
	if (object->blob == NULL) {
		Py_RETURN_NONE;
	}
	if (object->blob == NULL) {
		py_blob = Py_None;
		Py_INCREF(py_blob);
	} else {
		py_blob = PyBytes_FromStringAndSize((char *)(*object->blob).data, (*object->blob).length);
	}
	return py_blob;
}

static int py_drsuapi_DsAttributeValue_set_blob(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAttributeValue *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->blob));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->blob");
		return -1;
	}
	if (value == Py_None) {
		object->blob = NULL;
	} else {
		object->blob = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->blob);
		if (object->blob == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		*object->blob = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsAttributeValue_getsetters[] = {
	{
		.name = discard_const_p(char, "__ndr_size"),
		.get = py_drsuapi_DsAttributeValue_get___ndr_size,
		.set = py_drsuapi_DsAttributeValue_set___ndr_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "blob"),
		.get = py_drsuapi_DsAttributeValue_get_blob,
		.set = py_drsuapi_DsAttributeValue_set_blob,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsAttributeValue_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsAttributeValue, type);
}


static PyTypeObject drsuapi_DsAttributeValue_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsAttributeValue",
	.tp_getset = py_drsuapi_DsAttributeValue_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsAttributeValue_new,
};


static PyObject *py_drsuapi_DsAttributeValueCtr_get_num_values(PyObject *obj, void *closure)
{
	struct drsuapi_DsAttributeValueCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_num_values;
	py_num_values = PyLong_FromUnsignedLongLong((uint32_t)(object->num_values));
	return py_num_values;
}

static int py_drsuapi_DsAttributeValueCtr_set_num_values(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAttributeValueCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_values");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_values));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_values = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsAttributeValueCtr_get_values(PyObject *obj, void *closure)
{
	struct drsuapi_DsAttributeValueCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_values;
	if (object->values == NULL) {
		Py_RETURN_NONE;
	}
	if (object->values == NULL) {
		py_values = Py_None;
		Py_INCREF(py_values);
	} else {
		py_values = PyList_New(object->num_values);
		if (py_values == NULL) {
			return NULL;
		}
		{
			int values_cntr_1;
			for (values_cntr_1 = 0; values_cntr_1 < (object->num_values); values_cntr_1++) {
				PyObject *py_values_1;
				py_values_1 = pytalloc_reference_ex(&drsuapi_DsAttributeValue_Type, object->values, &(object->values)[values_cntr_1]);
				PyList_SetItem(py_values, values_cntr_1, py_values_1);
			}
		}
	}
	return py_values;
}

static int py_drsuapi_DsAttributeValueCtr_set_values(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAttributeValueCtr *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->values));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->values");
		return -1;
	}
	if (value == Py_None) {
		object->values = NULL;
	} else {
		object->values = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int values_cntr_1;
			object->values = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->values, PyList_GET_SIZE(value));
			if (!object->values) { return -1; }
			talloc_set_name_const(object->values, "ARRAY: object->values");
			for (values_cntr_1 = 0; values_cntr_1 < PyList_GET_SIZE(value); values_cntr_1++) {
				if (PyList_GET_ITEM(value, values_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->values)[values_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&drsuapi_DsAttributeValue_Type, PyList_GET_ITEM(value, values_cntr_1), return -1;);
				if (talloc_reference(object->values, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, values_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->values)[values_cntr_1] = *(struct drsuapi_DsAttributeValue *)pytalloc_get_ptr(PyList_GET_ITEM(value, values_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsAttributeValueCtr_getsetters[] = {
	{
		.name = discard_const_p(char, "num_values"),
		.get = py_drsuapi_DsAttributeValueCtr_get_num_values,
		.set = py_drsuapi_DsAttributeValueCtr_set_num_values,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "values"),
		.get = py_drsuapi_DsAttributeValueCtr_get_values,
		.set = py_drsuapi_DsAttributeValueCtr_set_values,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsAttributeValue")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsAttributeValueCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsAttributeValueCtr, type);
}


static PyTypeObject drsuapi_DsAttributeValueCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsAttributeValueCtr",
	.tp_getset = py_drsuapi_DsAttributeValueCtr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsAttributeValueCtr_new,
};


static PyObject *py_drsuapi_DsReplicaObjectIdentifier3_get___ndr_size(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier3 *object = pytalloc_get_ptr(obj);
	PyObject *py___ndr_size;
	py___ndr_size = PyLong_FromUnsignedLongLong((uint32_t)(object->__ndr_size));
	return py___ndr_size;
}

static int py_drsuapi_DsReplicaObjectIdentifier3_set___ndr_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->__ndr_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->__ndr_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->__ndr_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaObjectIdentifier3_get___ndr_size_sid(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier3 *object = pytalloc_get_ptr(obj);
	PyObject *py___ndr_size_sid;
	py___ndr_size_sid = PyLong_FromUnsignedLongLong((uint32_t)(object->__ndr_size_sid));
	return py___ndr_size_sid;
}

static int py_drsuapi_DsReplicaObjectIdentifier3_set___ndr_size_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->__ndr_size_sid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->__ndr_size_sid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->__ndr_size_sid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaObjectIdentifier3_get_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier3 *object = pytalloc_get_ptr(obj);
	PyObject *py_guid;
	py_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->guid);
	return py_guid;
}

static int py_drsuapi_DsReplicaObjectIdentifier3_set_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsReplicaObjectIdentifier3_get_sid(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier3 *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	py_sid = pytalloc_reference_ex(dom_sid_Type, pytalloc_get_mem_ctx(obj), &object->sid);
	return py_sid;
}

static int py_drsuapi_DsReplicaObjectIdentifier3_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sid");
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sid = *(struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsReplicaObjectIdentifier3_get___ndr_size_dn(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier3 *object = pytalloc_get_ptr(obj);
	PyObject *py___ndr_size_dn;
	py___ndr_size_dn = PyLong_FromUnsignedLongLong((uint32_t)(object->__ndr_size_dn));
	return py___ndr_size_dn;
}

static int py_drsuapi_DsReplicaObjectIdentifier3_set___ndr_size_dn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->__ndr_size_dn");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->__ndr_size_dn));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->__ndr_size_dn = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaObjectIdentifier3_get_dn(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier3 *object = pytalloc_get_ptr(obj);
	PyObject *py_dn;
	if (object->dn == NULL) {
		py_dn = Py_None;
		Py_INCREF(py_dn);
	} else {
		py_dn = PyUnicode_Decode(object->dn, strlen(object->dn), "utf-8", "ignore");
	}
	return py_dn;
}

static int py_drsuapi_DsReplicaObjectIdentifier3_set_dn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dn");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->dn = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaObjectIdentifier3_getsetters[] = {
	{
		.name = discard_const_p(char, "__ndr_size"),
		.get = py_drsuapi_DsReplicaObjectIdentifier3_get___ndr_size,
		.set = py_drsuapi_DsReplicaObjectIdentifier3_set___ndr_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "__ndr_size_sid"),
		.get = py_drsuapi_DsReplicaObjectIdentifier3_get___ndr_size_sid,
		.set = py_drsuapi_DsReplicaObjectIdentifier3_set___ndr_size_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "guid"),
		.get = py_drsuapi_DsReplicaObjectIdentifier3_get_guid,
		.set = py_drsuapi_DsReplicaObjectIdentifier3_set_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "sid"),
		.get = py_drsuapi_DsReplicaObjectIdentifier3_get_sid,
		.set = py_drsuapi_DsReplicaObjectIdentifier3_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid28")
	},
	{
		.name = discard_const_p(char, "__ndr_size_dn"),
		.get = py_drsuapi_DsReplicaObjectIdentifier3_get___ndr_size_dn,
		.set = py_drsuapi_DsReplicaObjectIdentifier3_set___ndr_size_dn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dn"),
		.get = py_drsuapi_DsReplicaObjectIdentifier3_get_dn,
		.set = py_drsuapi_DsReplicaObjectIdentifier3_set_dn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaObjectIdentifier3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaObjectIdentifier3, type);
}

static PyObject *py_drsuapi_DsReplicaObjectIdentifier3_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct drsuapi_DsReplicaObjectIdentifier3 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsReplicaObjectIdentifier3);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_drsuapi_DsReplicaObjectIdentifier3_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsReplicaObjectIdentifier3 *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsReplicaObjectIdentifier3);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsReplicaObjectIdentifier3);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_drsuapi_DsReplicaObjectIdentifier3_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsReplicaObjectIdentifier3 *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsReplicaObjectIdentifier3, "drsuapi_DsReplicaObjectIdentifier3", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsReplicaObjectIdentifier3, "drsuapi_DsReplicaObjectIdentifier3", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_drsuapi_DsReplicaObjectIdentifier3_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_drsuapi_DsReplicaObjectIdentifier3_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaObjectIdentifier3_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaObjectIdentifier3_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject drsuapi_DsReplicaObjectIdentifier3_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaObjectIdentifier3",
	.tp_getset = py_drsuapi_DsReplicaObjectIdentifier3_getsetters,
	.tp_methods = py_drsuapi_DsReplicaObjectIdentifier3_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaObjectIdentifier3_new,
};


static PyObject *py_drsuapi_DsReplicaObjectIdentifier3Binary_get___ndr_size(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier3Binary *object = pytalloc_get_ptr(obj);
	PyObject *py___ndr_size;
	py___ndr_size = PyLong_FromUnsignedLongLong((uint32_t)(object->__ndr_size));
	return py___ndr_size;
}

static int py_drsuapi_DsReplicaObjectIdentifier3Binary_set___ndr_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier3Binary *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->__ndr_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->__ndr_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->__ndr_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaObjectIdentifier3Binary_get___ndr_size_sid(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier3Binary *object = pytalloc_get_ptr(obj);
	PyObject *py___ndr_size_sid;
	py___ndr_size_sid = PyLong_FromUnsignedLongLong((uint32_t)(object->__ndr_size_sid));
	return py___ndr_size_sid;
}

static int py_drsuapi_DsReplicaObjectIdentifier3Binary_set___ndr_size_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier3Binary *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->__ndr_size_sid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->__ndr_size_sid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->__ndr_size_sid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaObjectIdentifier3Binary_get_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier3Binary *object = pytalloc_get_ptr(obj);
	PyObject *py_guid;
	py_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->guid);
	return py_guid;
}

static int py_drsuapi_DsReplicaObjectIdentifier3Binary_set_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier3Binary *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsReplicaObjectIdentifier3Binary_get_sid(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier3Binary *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	py_sid = pytalloc_reference_ex(dom_sid_Type, pytalloc_get_mem_ctx(obj), &object->sid);
	return py_sid;
}

static int py_drsuapi_DsReplicaObjectIdentifier3Binary_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier3Binary *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sid");
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sid = *(struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsReplicaObjectIdentifier3Binary_get___ndr_size_dn(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier3Binary *object = pytalloc_get_ptr(obj);
	PyObject *py___ndr_size_dn;
	py___ndr_size_dn = PyLong_FromUnsignedLongLong((uint32_t)(object->__ndr_size_dn));
	return py___ndr_size_dn;
}

static int py_drsuapi_DsReplicaObjectIdentifier3Binary_set___ndr_size_dn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier3Binary *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->__ndr_size_dn");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->__ndr_size_dn));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->__ndr_size_dn = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaObjectIdentifier3Binary_get_dn(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier3Binary *object = pytalloc_get_ptr(obj);
	PyObject *py_dn;
	if (object->dn == NULL) {
		py_dn = Py_None;
		Py_INCREF(py_dn);
	} else {
		py_dn = PyUnicode_Decode(object->dn, strlen(object->dn), "utf-8", "ignore");
	}
	return py_dn;
}

static int py_drsuapi_DsReplicaObjectIdentifier3Binary_set_dn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier3Binary *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dn");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->dn = talloc_str;
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaObjectIdentifier3Binary_get___ndr_size_binary(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier3Binary *object = pytalloc_get_ptr(obj);
	PyObject *py___ndr_size_binary;
	py___ndr_size_binary = PyLong_FromUnsignedLongLong((uint32_t)(object->__ndr_size_binary));
	return py___ndr_size_binary;
}

static int py_drsuapi_DsReplicaObjectIdentifier3Binary_set___ndr_size_binary(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier3Binary *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->__ndr_size_binary");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->__ndr_size_binary));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->__ndr_size_binary = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaObjectIdentifier3Binary_get_binary(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier3Binary *object = pytalloc_get_ptr(obj);
	PyObject *py_binary;
	py_binary = PyBytes_FromStringAndSize((char *)(object->binary).data, (object->binary).length);
	return py_binary;
}

static int py_drsuapi_DsReplicaObjectIdentifier3Binary_set_binary(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier3Binary *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->binary");
		return -1;
	}
	object->binary = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaObjectIdentifier3Binary_getsetters[] = {
	{
		.name = discard_const_p(char, "__ndr_size"),
		.get = py_drsuapi_DsReplicaObjectIdentifier3Binary_get___ndr_size,
		.set = py_drsuapi_DsReplicaObjectIdentifier3Binary_set___ndr_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "__ndr_size_sid"),
		.get = py_drsuapi_DsReplicaObjectIdentifier3Binary_get___ndr_size_sid,
		.set = py_drsuapi_DsReplicaObjectIdentifier3Binary_set___ndr_size_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "guid"),
		.get = py_drsuapi_DsReplicaObjectIdentifier3Binary_get_guid,
		.set = py_drsuapi_DsReplicaObjectIdentifier3Binary_set_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "sid"),
		.get = py_drsuapi_DsReplicaObjectIdentifier3Binary_get_sid,
		.set = py_drsuapi_DsReplicaObjectIdentifier3Binary_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid28")
	},
	{
		.name = discard_const_p(char, "__ndr_size_dn"),
		.get = py_drsuapi_DsReplicaObjectIdentifier3Binary_get___ndr_size_dn,
		.set = py_drsuapi_DsReplicaObjectIdentifier3Binary_set___ndr_size_dn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dn"),
		.get = py_drsuapi_DsReplicaObjectIdentifier3Binary_get_dn,
		.set = py_drsuapi_DsReplicaObjectIdentifier3Binary_set_dn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "__ndr_size_binary"),
		.get = py_drsuapi_DsReplicaObjectIdentifier3Binary_get___ndr_size_binary,
		.set = py_drsuapi_DsReplicaObjectIdentifier3Binary_set___ndr_size_binary,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "binary"),
		.get = py_drsuapi_DsReplicaObjectIdentifier3Binary_get_binary,
		.set = py_drsuapi_DsReplicaObjectIdentifier3Binary_set_binary,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaObjectIdentifier3Binary_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaObjectIdentifier3Binary, type);
}

static PyObject *py_drsuapi_DsReplicaObjectIdentifier3Binary_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct drsuapi_DsReplicaObjectIdentifier3Binary *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsReplicaObjectIdentifier3Binary);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_drsuapi_DsReplicaObjectIdentifier3Binary_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsReplicaObjectIdentifier3Binary *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsReplicaObjectIdentifier3Binary);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsReplicaObjectIdentifier3Binary);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_drsuapi_DsReplicaObjectIdentifier3Binary_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsReplicaObjectIdentifier3Binary *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsReplicaObjectIdentifier3Binary, "drsuapi_DsReplicaObjectIdentifier3Binary", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsReplicaObjectIdentifier3Binary, "drsuapi_DsReplicaObjectIdentifier3Binary", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_drsuapi_DsReplicaObjectIdentifier3Binary_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_drsuapi_DsReplicaObjectIdentifier3Binary_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaObjectIdentifier3Binary_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaObjectIdentifier3Binary_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject drsuapi_DsReplicaObjectIdentifier3Binary_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaObjectIdentifier3Binary",
	.tp_getset = py_drsuapi_DsReplicaObjectIdentifier3Binary_getsetters,
	.tp_methods = py_drsuapi_DsReplicaObjectIdentifier3Binary_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaObjectIdentifier3Binary_new,
};


static PyObject *py_drsuapi_DsReplicaAttribute_get_attid(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaAttribute *object = pytalloc_get_ptr(obj);
	PyObject *py_attid;
	py_attid = PyLong_FromUnsignedLongLong((uint32_t)(object->attid));
	return py_attid;
}

static int py_drsuapi_DsReplicaAttribute_set_attid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaAttribute *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->attid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->attid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->attid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaAttribute_get_value_ctr(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaAttribute *object = pytalloc_get_ptr(obj);
	PyObject *py_value_ctr;
	py_value_ctr = pytalloc_reference_ex(&drsuapi_DsAttributeValueCtr_Type, pytalloc_get_mem_ctx(obj), &object->value_ctr);
	return py_value_ctr;
}

static int py_drsuapi_DsReplicaAttribute_set_value_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaAttribute *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->value_ctr");
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsAttributeValueCtr_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->value_ctr = *(struct drsuapi_DsAttributeValueCtr *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaAttribute_getsetters[] = {
	{
		.name = discard_const_p(char, "attid"),
		.get = py_drsuapi_DsReplicaAttribute_get_attid,
		.set = py_drsuapi_DsReplicaAttribute_set_attid,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsAttributeId")
	},
	{
		.name = discard_const_p(char, "value_ctr"),
		.get = py_drsuapi_DsReplicaAttribute_get_value_ctr,
		.set = py_drsuapi_DsReplicaAttribute_set_value_ctr,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsAttributeValueCtr")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaAttribute_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaAttribute, type);
}

static PyObject *py_drsuapi_DsReplicaAttribute_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct drsuapi_DsReplicaAttribute *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsReplicaAttribute);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_drsuapi_DsReplicaAttribute_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsReplicaAttribute *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsReplicaAttribute);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsReplicaAttribute);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_drsuapi_DsReplicaAttribute_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsReplicaAttribute *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsReplicaAttribute, "drsuapi_DsReplicaAttribute", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsReplicaAttribute, "drsuapi_DsReplicaAttribute", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_drsuapi_DsReplicaAttribute_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_drsuapi_DsReplicaAttribute_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaAttribute_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaAttribute_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject drsuapi_DsReplicaAttribute_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaAttribute",
	.tp_getset = py_drsuapi_DsReplicaAttribute_getsetters,
	.tp_methods = py_drsuapi_DsReplicaAttribute_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaAttribute_new,
};


static PyObject *py_drsuapi_DsReplicaAttributeCtr_get_num_attributes(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaAttributeCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_num_attributes;
	py_num_attributes = PyLong_FromUnsignedLongLong((uint32_t)(object->num_attributes));
	return py_num_attributes;
}

static int py_drsuapi_DsReplicaAttributeCtr_set_num_attributes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaAttributeCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_attributes");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_attributes));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_attributes = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaAttributeCtr_get_attributes(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaAttributeCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_attributes;
	if (object->attributes == NULL) {
		Py_RETURN_NONE;
	}
	if (object->attributes == NULL) {
		py_attributes = Py_None;
		Py_INCREF(py_attributes);
	} else {
		py_attributes = PyList_New(object->num_attributes);
		if (py_attributes == NULL) {
			return NULL;
		}
		{
			int attributes_cntr_1;
			for (attributes_cntr_1 = 0; attributes_cntr_1 < (object->num_attributes); attributes_cntr_1++) {
				PyObject *py_attributes_1;
				py_attributes_1 = pytalloc_reference_ex(&drsuapi_DsReplicaAttribute_Type, object->attributes, &(object->attributes)[attributes_cntr_1]);
				PyList_SetItem(py_attributes, attributes_cntr_1, py_attributes_1);
			}
		}
	}
	return py_attributes;
}

static int py_drsuapi_DsReplicaAttributeCtr_set_attributes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaAttributeCtr *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->attributes));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->attributes");
		return -1;
	}
	if (value == Py_None) {
		object->attributes = NULL;
	} else {
		object->attributes = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int attributes_cntr_1;
			object->attributes = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->attributes, PyList_GET_SIZE(value));
			if (!object->attributes) { return -1; }
			talloc_set_name_const(object->attributes, "ARRAY: object->attributes");
			for (attributes_cntr_1 = 0; attributes_cntr_1 < PyList_GET_SIZE(value); attributes_cntr_1++) {
				if (PyList_GET_ITEM(value, attributes_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->attributes)[attributes_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&drsuapi_DsReplicaAttribute_Type, PyList_GET_ITEM(value, attributes_cntr_1), return -1;);
				if (talloc_reference(object->attributes, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, attributes_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->attributes)[attributes_cntr_1] = *(struct drsuapi_DsReplicaAttribute *)pytalloc_get_ptr(PyList_GET_ITEM(value, attributes_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaAttributeCtr_getsetters[] = {
	{
		.name = discard_const_p(char, "num_attributes"),
		.get = py_drsuapi_DsReplicaAttributeCtr_get_num_attributes,
		.set = py_drsuapi_DsReplicaAttributeCtr_set_num_attributes,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "attributes"),
		.get = py_drsuapi_DsReplicaAttributeCtr_get_attributes,
		.set = py_drsuapi_DsReplicaAttributeCtr_set_attributes,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaAttribute")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaAttributeCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaAttributeCtr, type);
}


static PyTypeObject drsuapi_DsReplicaAttributeCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaAttributeCtr",
	.tp_getset = py_drsuapi_DsReplicaAttributeCtr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaAttributeCtr_new,
};


static PyObject *py_drsuapi_DsReplicaObject_get_identifier(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObject *object = pytalloc_get_ptr(obj);
	PyObject *py_identifier;
	if (object->identifier == NULL) {
		Py_RETURN_NONE;
	}
	if (object->identifier == NULL) {
		py_identifier = Py_None;
		Py_INCREF(py_identifier);
	} else {
		py_identifier = pytalloc_reference_ex(&drsuapi_DsReplicaObjectIdentifier_Type, object->identifier, object->identifier);
	}
	return py_identifier;
}

static int py_drsuapi_DsReplicaObject_set_identifier(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObject *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->identifier));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->identifier");
		return -1;
	}
	if (value == Py_None) {
		object->identifier = NULL;
	} else {
		object->identifier = NULL;
		PY_CHECK_TYPE(&drsuapi_DsReplicaObjectIdentifier_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->identifier = (struct drsuapi_DsReplicaObjectIdentifier *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaObject_get_flags(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObject *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->flags));
	return py_flags;
}

static int py_drsuapi_DsReplicaObject_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObject *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaObject_get_attribute_ctr(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObject *object = pytalloc_get_ptr(obj);
	PyObject *py_attribute_ctr;
	py_attribute_ctr = pytalloc_reference_ex(&drsuapi_DsReplicaAttributeCtr_Type, pytalloc_get_mem_ctx(obj), &object->attribute_ctr);
	return py_attribute_ctr;
}

static int py_drsuapi_DsReplicaObject_set_attribute_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObject *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->attribute_ctr");
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsReplicaAttributeCtr_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->attribute_ctr = *(struct drsuapi_DsReplicaAttributeCtr *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaObject_getsetters[] = {
	{
		.name = discard_const_p(char, "identifier"),
		.get = py_drsuapi_DsReplicaObject_get_identifier,
		.set = py_drsuapi_DsReplicaObject_set_identifier,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObjectIdentifier")
	},
	{
		.name = discard_const_p(char, "flags"),
		.get = py_drsuapi_DsReplicaObject_get_flags,
		.set = py_drsuapi_DsReplicaObject_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObjectFlags")
	},
	{
		.name = discard_const_p(char, "attribute_ctr"),
		.get = py_drsuapi_DsReplicaObject_get_attribute_ctr,
		.set = py_drsuapi_DsReplicaObject_set_attribute_ctr,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaAttributeCtr")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaObject_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaObject, type);
}

static PyObject *py_drsuapi_DsReplicaObject_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct drsuapi_DsReplicaObject *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsReplicaObject);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_drsuapi_DsReplicaObject_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsReplicaObject *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsReplicaObject);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsReplicaObject);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_drsuapi_DsReplicaObject_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsReplicaObject *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsReplicaObject, "drsuapi_DsReplicaObject", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsReplicaObject, "drsuapi_DsReplicaObject", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_drsuapi_DsReplicaObject_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_drsuapi_DsReplicaObject_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaObject_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaObject_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject drsuapi_DsReplicaObject_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaObject",
	.tp_getset = py_drsuapi_DsReplicaObject_getsetters,
	.tp_methods = py_drsuapi_DsReplicaObject_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaObject_new,
};


static PyObject *py_drsuapi_DsReplicaMetaData_get_version(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaMetaData *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_drsuapi_DsReplicaMetaData_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaMetaData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaMetaData_get_originating_change_time(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaMetaData *object = pytalloc_get_ptr(obj);
	PyObject *py_originating_change_time;
	py_originating_change_time = PyLong_FromUnsignedLongLong(object->originating_change_time);
	return py_originating_change_time;
}

static int py_drsuapi_DsReplicaMetaData_set_originating_change_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaMetaData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->originating_change_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->originating_change_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->originating_change_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaMetaData_get_originating_invocation_id(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaMetaData *object = pytalloc_get_ptr(obj);
	PyObject *py_originating_invocation_id;
	py_originating_invocation_id = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->originating_invocation_id);
	return py_originating_invocation_id;
}

static int py_drsuapi_DsReplicaMetaData_set_originating_invocation_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaMetaData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->originating_invocation_id");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->originating_invocation_id = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsReplicaMetaData_get_originating_usn(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaMetaData *object = pytalloc_get_ptr(obj);
	PyObject *py_originating_usn;
	py_originating_usn = PyLong_FromUnsignedLongLong(object->originating_usn);
	return py_originating_usn;
}

static int py_drsuapi_DsReplicaMetaData_set_originating_usn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaMetaData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->originating_usn");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->originating_usn));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->originating_usn = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaMetaData_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_drsuapi_DsReplicaMetaData_get_version,
		.set = py_drsuapi_DsReplicaMetaData_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "originating_change_time"),
		.get = py_drsuapi_DsReplicaMetaData_get_originating_change_time,
		.set = py_drsuapi_DsReplicaMetaData_set_originating_change_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME_1sec")
	},
	{
		.name = discard_const_p(char, "originating_invocation_id"),
		.get = py_drsuapi_DsReplicaMetaData_get_originating_invocation_id,
		.set = py_drsuapi_DsReplicaMetaData_set_originating_invocation_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "originating_usn"),
		.get = py_drsuapi_DsReplicaMetaData_get_originating_usn,
		.set = py_drsuapi_DsReplicaMetaData_set_originating_usn,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaMetaData_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaMetaData, type);
}


static PyTypeObject drsuapi_DsReplicaMetaData_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaMetaData",
	.tp_getset = py_drsuapi_DsReplicaMetaData_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaMetaData_new,
};


static PyObject *py_drsuapi_DsReplicaMetaDataCtr_get_count(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaMetaDataCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_drsuapi_DsReplicaMetaDataCtr_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaMetaDataCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaMetaDataCtr_get_meta_data(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaMetaDataCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_meta_data;
	py_meta_data = PyList_New(object->count);
	if (py_meta_data == NULL) {
		return NULL;
	}
	{
		int meta_data_cntr_0;
		for (meta_data_cntr_0 = 0; meta_data_cntr_0 < (object->count); meta_data_cntr_0++) {
			PyObject *py_meta_data_0;
			py_meta_data_0 = pytalloc_reference_ex(&drsuapi_DsReplicaMetaData_Type, object->meta_data, &(object->meta_data)[meta_data_cntr_0]);
			PyList_SetItem(py_meta_data, meta_data_cntr_0, py_meta_data_0);
		}
	}
	return py_meta_data;
}

static int py_drsuapi_DsReplicaMetaDataCtr_set_meta_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaMetaDataCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->meta_data");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int meta_data_cntr_0;
		object->meta_data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->meta_data, PyList_GET_SIZE(value));
		if (!object->meta_data) { return -1; }
		talloc_set_name_const(object->meta_data, "ARRAY: object->meta_data");
		for (meta_data_cntr_0 = 0; meta_data_cntr_0 < PyList_GET_SIZE(value); meta_data_cntr_0++) {
			if (PyList_GET_ITEM(value, meta_data_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->meta_data)[meta_data_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&drsuapi_DsReplicaMetaData_Type, PyList_GET_ITEM(value, meta_data_cntr_0), return -1;);
			if (talloc_reference(object->meta_data, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, meta_data_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->meta_data)[meta_data_cntr_0] = *(struct drsuapi_DsReplicaMetaData *)pytalloc_get_ptr(PyList_GET_ITEM(value, meta_data_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaMetaDataCtr_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_drsuapi_DsReplicaMetaDataCtr_get_count,
		.set = py_drsuapi_DsReplicaMetaDataCtr_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "meta_data"),
		.get = py_drsuapi_DsReplicaMetaDataCtr_get_meta_data,
		.set = py_drsuapi_DsReplicaMetaDataCtr_set_meta_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaMetaData")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaMetaDataCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaMetaDataCtr, type);
}

static PyObject *py_drsuapi_DsReplicaMetaDataCtr_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct drsuapi_DsReplicaMetaDataCtr *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsReplicaMetaDataCtr);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_drsuapi_DsReplicaMetaDataCtr_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsReplicaMetaDataCtr *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsReplicaMetaDataCtr);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsReplicaMetaDataCtr);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_drsuapi_DsReplicaMetaDataCtr_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsReplicaMetaDataCtr *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsReplicaMetaDataCtr, "drsuapi_DsReplicaMetaDataCtr", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsReplicaMetaDataCtr, "drsuapi_DsReplicaMetaDataCtr", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_drsuapi_DsReplicaMetaDataCtr_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_drsuapi_DsReplicaMetaDataCtr_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaMetaDataCtr_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaMetaDataCtr_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject drsuapi_DsReplicaMetaDataCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaMetaDataCtr",
	.tp_getset = py_drsuapi_DsReplicaMetaDataCtr_getsetters,
	.tp_methods = py_drsuapi_DsReplicaMetaDataCtr_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaMetaDataCtr_new,
};


static PyObject *py_drsuapi_DsReplicaObjectListItemEx_get_next_object(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjectListItemEx *object = pytalloc_get_ptr(obj);
	PyObject *py_next_object;
	if (object->next_object == NULL) {
		Py_RETURN_NONE;
	}
	if (object->next_object == NULL) {
		py_next_object = Py_None;
		Py_INCREF(py_next_object);
	} else {
		py_next_object = pytalloc_reference_ex(&drsuapi_DsReplicaObjectListItemEx_Type, object->next_object, object->next_object);
	}
	return py_next_object;
}

static int py_drsuapi_DsReplicaObjectListItemEx_set_next_object(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjectListItemEx *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->next_object));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->next_object");
		return -1;
	}
	if (value == Py_None) {
		object->next_object = NULL;
	} else {
		object->next_object = NULL;
		PY_CHECK_TYPE(&drsuapi_DsReplicaObjectListItemEx_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->next_object = (struct drsuapi_DsReplicaObjectListItemEx *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaObjectListItemEx_get_object(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjectListItemEx *object = pytalloc_get_ptr(obj);
	PyObject *py_object;
	py_object = pytalloc_reference_ex(&drsuapi_DsReplicaObject_Type, pytalloc_get_mem_ctx(obj), &object->object);
	return py_object;
}

static int py_drsuapi_DsReplicaObjectListItemEx_set_object(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjectListItemEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->object");
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsReplicaObject_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->object = *(struct drsuapi_DsReplicaObject *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsReplicaObjectListItemEx_get_is_nc_prefix(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjectListItemEx *object = pytalloc_get_ptr(obj);
	PyObject *py_is_nc_prefix;
	py_is_nc_prefix = PyLong_FromUnsignedLongLong((uint32_t)(object->is_nc_prefix));
	return py_is_nc_prefix;
}

static int py_drsuapi_DsReplicaObjectListItemEx_set_is_nc_prefix(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjectListItemEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->is_nc_prefix");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->is_nc_prefix));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->is_nc_prefix = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaObjectListItemEx_get_parent_object_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjectListItemEx *object = pytalloc_get_ptr(obj);
	PyObject *py_parent_object_guid;
	if (object->parent_object_guid == NULL) {
		Py_RETURN_NONE;
	}
	if (object->parent_object_guid == NULL) {
		py_parent_object_guid = Py_None;
		Py_INCREF(py_parent_object_guid);
	} else {
		py_parent_object_guid = pytalloc_reference_ex(GUID_Type, object->parent_object_guid, object->parent_object_guid);
	}
	return py_parent_object_guid;
}

static int py_drsuapi_DsReplicaObjectListItemEx_set_parent_object_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjectListItemEx *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->parent_object_guid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->parent_object_guid");
		return -1;
	}
	if (value == Py_None) {
		object->parent_object_guid = NULL;
	} else {
		object->parent_object_guid = NULL;
		PY_CHECK_TYPE(GUID_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->parent_object_guid = (struct GUID *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaObjectListItemEx_get_meta_data_ctr(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjectListItemEx *object = pytalloc_get_ptr(obj);
	PyObject *py_meta_data_ctr;
	if (object->meta_data_ctr == NULL) {
		Py_RETURN_NONE;
	}
	if (object->meta_data_ctr == NULL) {
		py_meta_data_ctr = Py_None;
		Py_INCREF(py_meta_data_ctr);
	} else {
		py_meta_data_ctr = pytalloc_reference_ex(&drsuapi_DsReplicaMetaDataCtr_Type, object->meta_data_ctr, object->meta_data_ctr);
	}
	return py_meta_data_ctr;
}

static int py_drsuapi_DsReplicaObjectListItemEx_set_meta_data_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjectListItemEx *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->meta_data_ctr));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->meta_data_ctr");
		return -1;
	}
	if (value == Py_None) {
		object->meta_data_ctr = NULL;
	} else {
		object->meta_data_ctr = NULL;
		PY_CHECK_TYPE(&drsuapi_DsReplicaMetaDataCtr_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->meta_data_ctr = (struct drsuapi_DsReplicaMetaDataCtr *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaObjectListItemEx_getsetters[] = {
	{
		.name = discard_const_p(char, "next_object"),
		.get = py_drsuapi_DsReplicaObjectListItemEx_get_next_object,
		.set = py_drsuapi_DsReplicaObjectListItemEx_set_next_object,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObjectListItemEx")
	},
	{
		.name = discard_const_p(char, "object"),
		.get = py_drsuapi_DsReplicaObjectListItemEx_get_object,
		.set = py_drsuapi_DsReplicaObjectListItemEx_set_object,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObject")
	},
	{
		.name = discard_const_p(char, "is_nc_prefix"),
		.get = py_drsuapi_DsReplicaObjectListItemEx_get_is_nc_prefix,
		.set = py_drsuapi_DsReplicaObjectListItemEx_set_is_nc_prefix,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "parent_object_guid"),
		.get = py_drsuapi_DsReplicaObjectListItemEx_get_parent_object_guid,
		.set = py_drsuapi_DsReplicaObjectListItemEx_set_parent_object_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "meta_data_ctr"),
		.get = py_drsuapi_DsReplicaObjectListItemEx_get_meta_data_ctr,
		.set = py_drsuapi_DsReplicaObjectListItemEx_set_meta_data_ctr,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaMetaDataCtr")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaObjectListItemEx_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaObjectListItemEx, type);
}

static PyObject *py_drsuapi_DsReplicaObjectListItemEx_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct drsuapi_DsReplicaObjectListItemEx *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsReplicaObjectListItemEx);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_drsuapi_DsReplicaObjectListItemEx_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsReplicaObjectListItemEx *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsReplicaObjectListItemEx);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsReplicaObjectListItemEx);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_drsuapi_DsReplicaObjectListItemEx_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsReplicaObjectListItemEx *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsReplicaObjectListItemEx, "drsuapi_DsReplicaObjectListItemEx", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsReplicaObjectListItemEx, "drsuapi_DsReplicaObjectListItemEx", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_drsuapi_DsReplicaObjectListItemEx_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_drsuapi_DsReplicaObjectListItemEx_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaObjectListItemEx_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaObjectListItemEx_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject drsuapi_DsReplicaObjectListItemEx_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaObjectListItemEx",
	.tp_getset = py_drsuapi_DsReplicaObjectListItemEx_getsetters,
	.tp_methods = py_drsuapi_DsReplicaObjectListItemEx_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaObjectListItemEx_new,
};


static PyObject *py_drsuapi_DsGetNCChangesCtr1_get_source_dsa_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_source_dsa_guid;
	py_source_dsa_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->source_dsa_guid);
	return py_source_dsa_guid;
}

static int py_drsuapi_DsGetNCChangesCtr1_set_source_dsa_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->source_dsa_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->source_dsa_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr1_get_source_dsa_invocation_id(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_source_dsa_invocation_id;
	py_source_dsa_invocation_id = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->source_dsa_invocation_id);
	return py_source_dsa_invocation_id;
}

static int py_drsuapi_DsGetNCChangesCtr1_set_source_dsa_invocation_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->source_dsa_invocation_id");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->source_dsa_invocation_id = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr1_get_naming_context(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_naming_context;
	if (object->naming_context == NULL) {
		Py_RETURN_NONE;
	}
	if (object->naming_context == NULL) {
		py_naming_context = Py_None;
		Py_INCREF(py_naming_context);
	} else {
		py_naming_context = pytalloc_reference_ex(&drsuapi_DsReplicaObjectIdentifier_Type, object->naming_context, object->naming_context);
	}
	return py_naming_context;
}

static int py_drsuapi_DsGetNCChangesCtr1_set_naming_context(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->naming_context));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->naming_context");
		return -1;
	}
	if (value == Py_None) {
		object->naming_context = NULL;
	} else {
		object->naming_context = NULL;
		PY_CHECK_TYPE(&drsuapi_DsReplicaObjectIdentifier_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->naming_context = (struct drsuapi_DsReplicaObjectIdentifier *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr1_get_old_highwatermark(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_old_highwatermark;
	py_old_highwatermark = pytalloc_reference_ex(&drsuapi_DsReplicaHighWaterMark_Type, pytalloc_get_mem_ctx(obj), &object->old_highwatermark);
	return py_old_highwatermark;
}

static int py_drsuapi_DsGetNCChangesCtr1_set_old_highwatermark(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->old_highwatermark");
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsReplicaHighWaterMark_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->old_highwatermark = *(struct drsuapi_DsReplicaHighWaterMark *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr1_get_new_highwatermark(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_new_highwatermark;
	py_new_highwatermark = pytalloc_reference_ex(&drsuapi_DsReplicaHighWaterMark_Type, pytalloc_get_mem_ctx(obj), &object->new_highwatermark);
	return py_new_highwatermark;
}

static int py_drsuapi_DsGetNCChangesCtr1_set_new_highwatermark(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->new_highwatermark");
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsReplicaHighWaterMark_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->new_highwatermark = *(struct drsuapi_DsReplicaHighWaterMark *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr1_get_uptodateness_vector(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_uptodateness_vector;
	if (object->uptodateness_vector == NULL) {
		Py_RETURN_NONE;
	}
	if (object->uptodateness_vector == NULL) {
		py_uptodateness_vector = Py_None;
		Py_INCREF(py_uptodateness_vector);
	} else {
		py_uptodateness_vector = pytalloc_reference_ex(&drsuapi_DsReplicaCursorCtrEx_Type, object->uptodateness_vector, object->uptodateness_vector);
	}
	return py_uptodateness_vector;
}

static int py_drsuapi_DsGetNCChangesCtr1_set_uptodateness_vector(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->uptodateness_vector));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->uptodateness_vector");
		return -1;
	}
	if (value == Py_None) {
		object->uptodateness_vector = NULL;
	} else {
		object->uptodateness_vector = NULL;
		PY_CHECK_TYPE(&drsuapi_DsReplicaCursorCtrEx_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->uptodateness_vector = (struct drsuapi_DsReplicaCursorCtrEx *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr1_get_mapping_ctr(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_mapping_ctr;
	py_mapping_ctr = pytalloc_reference_ex(&drsuapi_DsReplicaOIDMapping_Ctr_Type, pytalloc_get_mem_ctx(obj), &object->mapping_ctr);
	return py_mapping_ctr;
}

static int py_drsuapi_DsGetNCChangesCtr1_set_mapping_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->mapping_ctr");
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsReplicaOIDMapping_Ctr_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->mapping_ctr = *(struct drsuapi_DsReplicaOIDMapping_Ctr *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr1_get_extended_ret(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_extended_ret;
	py_extended_ret = PyLong_FromUnsignedLongLong((uint32_t)(object->extended_ret));
	return py_extended_ret;
}

static int py_drsuapi_DsGetNCChangesCtr1_set_extended_ret(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->extended_ret");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->extended_ret));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->extended_ret = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr1_get_object_count(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_object_count;
	py_object_count = PyLong_FromUnsignedLongLong((uint32_t)(object->object_count));
	return py_object_count;
}

static int py_drsuapi_DsGetNCChangesCtr1_set_object_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->object_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->object_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->object_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr1_get___ndr_size(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py___ndr_size;
	py___ndr_size = PyLong_FromUnsignedLongLong((uint32_t)(object->__ndr_size));
	return py___ndr_size;
}

static int py_drsuapi_DsGetNCChangesCtr1_set___ndr_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->__ndr_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->__ndr_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->__ndr_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr1_get_first_object(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_first_object;
	if (object->first_object == NULL) {
		Py_RETURN_NONE;
	}
	if (object->first_object == NULL) {
		py_first_object = Py_None;
		Py_INCREF(py_first_object);
	} else {
		py_first_object = pytalloc_reference_ex(&drsuapi_DsReplicaObjectListItemEx_Type, object->first_object, object->first_object);
	}
	return py_first_object;
}

static int py_drsuapi_DsGetNCChangesCtr1_set_first_object(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->first_object));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->first_object");
		return -1;
	}
	if (value == Py_None) {
		object->first_object = NULL;
	} else {
		object->first_object = NULL;
		PY_CHECK_TYPE(&drsuapi_DsReplicaObjectListItemEx_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->first_object = (struct drsuapi_DsReplicaObjectListItemEx *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr1_get_more_data(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_more_data;
	py_more_data = PyLong_FromUnsignedLongLong((uint32_t)(object->more_data));
	return py_more_data;
}

static int py_drsuapi_DsGetNCChangesCtr1_set_more_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->more_data");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->more_data));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->more_data = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsGetNCChangesCtr1_getsetters[] = {
	{
		.name = discard_const_p(char, "source_dsa_guid"),
		.get = py_drsuapi_DsGetNCChangesCtr1_get_source_dsa_guid,
		.set = py_drsuapi_DsGetNCChangesCtr1_set_source_dsa_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "source_dsa_invocation_id"),
		.get = py_drsuapi_DsGetNCChangesCtr1_get_source_dsa_invocation_id,
		.set = py_drsuapi_DsGetNCChangesCtr1_set_source_dsa_invocation_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "naming_context"),
		.get = py_drsuapi_DsGetNCChangesCtr1_get_naming_context,
		.set = py_drsuapi_DsGetNCChangesCtr1_set_naming_context,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObjectIdentifier")
	},
	{
		.name = discard_const_p(char, "old_highwatermark"),
		.get = py_drsuapi_DsGetNCChangesCtr1_get_old_highwatermark,
		.set = py_drsuapi_DsGetNCChangesCtr1_set_old_highwatermark,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaHighWaterMark")
	},
	{
		.name = discard_const_p(char, "new_highwatermark"),
		.get = py_drsuapi_DsGetNCChangesCtr1_get_new_highwatermark,
		.set = py_drsuapi_DsGetNCChangesCtr1_set_new_highwatermark,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaHighWaterMark")
	},
	{
		.name = discard_const_p(char, "uptodateness_vector"),
		.get = py_drsuapi_DsGetNCChangesCtr1_get_uptodateness_vector,
		.set = py_drsuapi_DsGetNCChangesCtr1_set_uptodateness_vector,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaCursorCtrEx")
	},
	{
		.name = discard_const_p(char, "mapping_ctr"),
		.get = py_drsuapi_DsGetNCChangesCtr1_get_mapping_ctr,
		.set = py_drsuapi_DsGetNCChangesCtr1_set_mapping_ctr,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaOIDMapping_Ctr")
	},
	{
		.name = discard_const_p(char, "extended_ret"),
		.get = py_drsuapi_DsGetNCChangesCtr1_get_extended_ret,
		.set = py_drsuapi_DsGetNCChangesCtr1_set_extended_ret,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsExtendedError")
	},
	{
		.name = discard_const_p(char, "object_count"),
		.get = py_drsuapi_DsGetNCChangesCtr1_get_object_count,
		.set = py_drsuapi_DsGetNCChangesCtr1_set_object_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "__ndr_size"),
		.get = py_drsuapi_DsGetNCChangesCtr1_get___ndr_size,
		.set = py_drsuapi_DsGetNCChangesCtr1_set___ndr_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "first_object"),
		.get = py_drsuapi_DsGetNCChangesCtr1_get_first_object,
		.set = py_drsuapi_DsGetNCChangesCtr1_set_first_object,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObjectListItemEx")
	},
	{
		.name = discard_const_p(char, "more_data"),
		.get = py_drsuapi_DsGetNCChangesCtr1_get_more_data,
		.set = py_drsuapi_DsGetNCChangesCtr1_set_more_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsGetNCChangesCtr1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsGetNCChangesCtr1, type);
}

static PyObject *py_drsuapi_DsGetNCChangesCtr1_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct drsuapi_DsGetNCChangesCtr1 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsGetNCChangesCtr1);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr1_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsGetNCChangesCtr1 *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsGetNCChangesCtr1);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsGetNCChangesCtr1);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr1_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsGetNCChangesCtr1 *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsGetNCChangesCtr1, "drsuapi_DsGetNCChangesCtr1", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsGetNCChangesCtr1, "drsuapi_DsGetNCChangesCtr1", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_drsuapi_DsGetNCChangesCtr1_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_drsuapi_DsGetNCChangesCtr1_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsGetNCChangesCtr1_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsGetNCChangesCtr1_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject drsuapi_DsGetNCChangesCtr1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetNCChangesCtr1",
	.tp_getset = py_drsuapi_DsGetNCChangesCtr1_getsetters,
	.tp_methods = py_drsuapi_DsGetNCChangesCtr1_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetNCChangesCtr1_new,
};


static PyObject *py_drsuapi_DsReplicaLinkedAttribute_get_identifier(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaLinkedAttribute *object = pytalloc_get_ptr(obj);
	PyObject *py_identifier;
	if (object->identifier == NULL) {
		Py_RETURN_NONE;
	}
	if (object->identifier == NULL) {
		py_identifier = Py_None;
		Py_INCREF(py_identifier);
	} else {
		py_identifier = pytalloc_reference_ex(&drsuapi_DsReplicaObjectIdentifier_Type, object->identifier, object->identifier);
	}
	return py_identifier;
}

static int py_drsuapi_DsReplicaLinkedAttribute_set_identifier(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaLinkedAttribute *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->identifier));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->identifier");
		return -1;
	}
	if (value == Py_None) {
		object->identifier = NULL;
	} else {
		object->identifier = NULL;
		PY_CHECK_TYPE(&drsuapi_DsReplicaObjectIdentifier_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->identifier = (struct drsuapi_DsReplicaObjectIdentifier *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaLinkedAttribute_get_attid(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaLinkedAttribute *object = pytalloc_get_ptr(obj);
	PyObject *py_attid;
	py_attid = PyLong_FromUnsignedLongLong((uint32_t)(object->attid));
	return py_attid;
}

static int py_drsuapi_DsReplicaLinkedAttribute_set_attid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaLinkedAttribute *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->attid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->attid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->attid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaLinkedAttribute_get_value(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaLinkedAttribute *object = pytalloc_get_ptr(obj);
	PyObject *py_value;
	py_value = pytalloc_reference_ex(&drsuapi_DsAttributeValue_Type, pytalloc_get_mem_ctx(obj), &object->value);
	return py_value;
}

static int py_drsuapi_DsReplicaLinkedAttribute_set_value(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaLinkedAttribute *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->value");
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsAttributeValue_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->value = *(struct drsuapi_DsAttributeValue *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsReplicaLinkedAttribute_get_flags(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaLinkedAttribute *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->flags));
	return py_flags;
}

static int py_drsuapi_DsReplicaLinkedAttribute_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaLinkedAttribute *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaLinkedAttribute_get_originating_add_time(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaLinkedAttribute *object = pytalloc_get_ptr(obj);
	PyObject *py_originating_add_time;
	py_originating_add_time = PyLong_FromUnsignedLongLong(object->originating_add_time);
	return py_originating_add_time;
}

static int py_drsuapi_DsReplicaLinkedAttribute_set_originating_add_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaLinkedAttribute *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->originating_add_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->originating_add_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->originating_add_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaLinkedAttribute_get_meta_data(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaLinkedAttribute *object = pytalloc_get_ptr(obj);
	PyObject *py_meta_data;
	py_meta_data = pytalloc_reference_ex(&drsuapi_DsReplicaMetaData_Type, pytalloc_get_mem_ctx(obj), &object->meta_data);
	return py_meta_data;
}

static int py_drsuapi_DsReplicaLinkedAttribute_set_meta_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaLinkedAttribute *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->meta_data");
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsReplicaMetaData_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->meta_data = *(struct drsuapi_DsReplicaMetaData *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaLinkedAttribute_getsetters[] = {
	{
		.name = discard_const_p(char, "identifier"),
		.get = py_drsuapi_DsReplicaLinkedAttribute_get_identifier,
		.set = py_drsuapi_DsReplicaLinkedAttribute_set_identifier,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObjectIdentifier")
	},
	{
		.name = discard_const_p(char, "attid"),
		.get = py_drsuapi_DsReplicaLinkedAttribute_get_attid,
		.set = py_drsuapi_DsReplicaLinkedAttribute_set_attid,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsAttributeId")
	},
	{
		.name = discard_const_p(char, "value"),
		.get = py_drsuapi_DsReplicaLinkedAttribute_get_value,
		.set = py_drsuapi_DsReplicaLinkedAttribute_set_value,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsAttributeValue")
	},
	{
		.name = discard_const_p(char, "flags"),
		.get = py_drsuapi_DsReplicaLinkedAttribute_get_flags,
		.set = py_drsuapi_DsReplicaLinkedAttribute_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsLinkedAttributeFlags")
	},
	{
		.name = discard_const_p(char, "originating_add_time"),
		.get = py_drsuapi_DsReplicaLinkedAttribute_get_originating_add_time,
		.set = py_drsuapi_DsReplicaLinkedAttribute_set_originating_add_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME_1sec")
	},
	{
		.name = discard_const_p(char, "meta_data"),
		.get = py_drsuapi_DsReplicaLinkedAttribute_get_meta_data,
		.set = py_drsuapi_DsReplicaLinkedAttribute_set_meta_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaMetaData")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaLinkedAttribute_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaLinkedAttribute, type);
}

static PyObject *py_drsuapi_DsReplicaLinkedAttribute_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct drsuapi_DsReplicaLinkedAttribute *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsReplicaLinkedAttribute);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_drsuapi_DsReplicaLinkedAttribute_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsReplicaLinkedAttribute *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsReplicaLinkedAttribute);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsReplicaLinkedAttribute);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_drsuapi_DsReplicaLinkedAttribute_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsReplicaLinkedAttribute *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsReplicaLinkedAttribute, "drsuapi_DsReplicaLinkedAttribute", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsReplicaLinkedAttribute, "drsuapi_DsReplicaLinkedAttribute", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_drsuapi_DsReplicaLinkedAttribute_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_drsuapi_DsReplicaLinkedAttribute_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaLinkedAttribute_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaLinkedAttribute_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject drsuapi_DsReplicaLinkedAttribute_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaLinkedAttribute",
	.tp_getset = py_drsuapi_DsReplicaLinkedAttribute_getsetters,
	.tp_methods = py_drsuapi_DsReplicaLinkedAttribute_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaLinkedAttribute_new,
};


static PyObject *py_drsuapi_DsGetNCChangesCtr6_get_source_dsa_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(obj);
	PyObject *py_source_dsa_guid;
	py_source_dsa_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->source_dsa_guid);
	return py_source_dsa_guid;
}

static int py_drsuapi_DsGetNCChangesCtr6_set_source_dsa_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->source_dsa_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->source_dsa_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr6_get_source_dsa_invocation_id(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(obj);
	PyObject *py_source_dsa_invocation_id;
	py_source_dsa_invocation_id = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->source_dsa_invocation_id);
	return py_source_dsa_invocation_id;
}

static int py_drsuapi_DsGetNCChangesCtr6_set_source_dsa_invocation_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->source_dsa_invocation_id");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->source_dsa_invocation_id = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr6_get_naming_context(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(obj);
	PyObject *py_naming_context;
	if (object->naming_context == NULL) {
		Py_RETURN_NONE;
	}
	if (object->naming_context == NULL) {
		py_naming_context = Py_None;
		Py_INCREF(py_naming_context);
	} else {
		py_naming_context = pytalloc_reference_ex(&drsuapi_DsReplicaObjectIdentifier_Type, object->naming_context, object->naming_context);
	}
	return py_naming_context;
}

static int py_drsuapi_DsGetNCChangesCtr6_set_naming_context(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->naming_context));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->naming_context");
		return -1;
	}
	if (value == Py_None) {
		object->naming_context = NULL;
	} else {
		object->naming_context = NULL;
		PY_CHECK_TYPE(&drsuapi_DsReplicaObjectIdentifier_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->naming_context = (struct drsuapi_DsReplicaObjectIdentifier *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr6_get_old_highwatermark(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(obj);
	PyObject *py_old_highwatermark;
	py_old_highwatermark = pytalloc_reference_ex(&drsuapi_DsReplicaHighWaterMark_Type, pytalloc_get_mem_ctx(obj), &object->old_highwatermark);
	return py_old_highwatermark;
}

static int py_drsuapi_DsGetNCChangesCtr6_set_old_highwatermark(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->old_highwatermark");
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsReplicaHighWaterMark_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->old_highwatermark = *(struct drsuapi_DsReplicaHighWaterMark *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr6_get_new_highwatermark(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(obj);
	PyObject *py_new_highwatermark;
	py_new_highwatermark = pytalloc_reference_ex(&drsuapi_DsReplicaHighWaterMark_Type, pytalloc_get_mem_ctx(obj), &object->new_highwatermark);
	return py_new_highwatermark;
}

static int py_drsuapi_DsGetNCChangesCtr6_set_new_highwatermark(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->new_highwatermark");
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsReplicaHighWaterMark_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->new_highwatermark = *(struct drsuapi_DsReplicaHighWaterMark *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr6_get_uptodateness_vector(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(obj);
	PyObject *py_uptodateness_vector;
	if (object->uptodateness_vector == NULL) {
		Py_RETURN_NONE;
	}
	if (object->uptodateness_vector == NULL) {
		py_uptodateness_vector = Py_None;
		Py_INCREF(py_uptodateness_vector);
	} else {
		py_uptodateness_vector = pytalloc_reference_ex(&drsuapi_DsReplicaCursor2CtrEx_Type, object->uptodateness_vector, object->uptodateness_vector);
	}
	return py_uptodateness_vector;
}

static int py_drsuapi_DsGetNCChangesCtr6_set_uptodateness_vector(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->uptodateness_vector));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->uptodateness_vector");
		return -1;
	}
	if (value == Py_None) {
		object->uptodateness_vector = NULL;
	} else {
		object->uptodateness_vector = NULL;
		PY_CHECK_TYPE(&drsuapi_DsReplicaCursor2CtrEx_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->uptodateness_vector = (struct drsuapi_DsReplicaCursor2CtrEx *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr6_get_mapping_ctr(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(obj);
	PyObject *py_mapping_ctr;
	py_mapping_ctr = pytalloc_reference_ex(&drsuapi_DsReplicaOIDMapping_Ctr_Type, pytalloc_get_mem_ctx(obj), &object->mapping_ctr);
	return py_mapping_ctr;
}

static int py_drsuapi_DsGetNCChangesCtr6_set_mapping_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->mapping_ctr");
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsReplicaOIDMapping_Ctr_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->mapping_ctr = *(struct drsuapi_DsReplicaOIDMapping_Ctr *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr6_get_extended_ret(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(obj);
	PyObject *py_extended_ret;
	py_extended_ret = PyLong_FromUnsignedLongLong((uint32_t)(object->extended_ret));
	return py_extended_ret;
}

static int py_drsuapi_DsGetNCChangesCtr6_set_extended_ret(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->extended_ret");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->extended_ret));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->extended_ret = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr6_get_object_count(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(obj);
	PyObject *py_object_count;
	py_object_count = PyLong_FromUnsignedLongLong((uint32_t)(object->object_count));
	return py_object_count;
}

static int py_drsuapi_DsGetNCChangesCtr6_set_object_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->object_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->object_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->object_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr6_get___ndr_size(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(obj);
	PyObject *py___ndr_size;
	py___ndr_size = PyLong_FromUnsignedLongLong((uint32_t)(object->__ndr_size));
	return py___ndr_size;
}

static int py_drsuapi_DsGetNCChangesCtr6_set___ndr_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->__ndr_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->__ndr_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->__ndr_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr6_get_first_object(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(obj);
	PyObject *py_first_object;
	if (object->first_object == NULL) {
		Py_RETURN_NONE;
	}
	if (object->first_object == NULL) {
		py_first_object = Py_None;
		Py_INCREF(py_first_object);
	} else {
		py_first_object = pytalloc_reference_ex(&drsuapi_DsReplicaObjectListItemEx_Type, object->first_object, object->first_object);
	}
	return py_first_object;
}

static int py_drsuapi_DsGetNCChangesCtr6_set_first_object(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->first_object));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->first_object");
		return -1;
	}
	if (value == Py_None) {
		object->first_object = NULL;
	} else {
		object->first_object = NULL;
		PY_CHECK_TYPE(&drsuapi_DsReplicaObjectListItemEx_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->first_object = (struct drsuapi_DsReplicaObjectListItemEx *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr6_get_more_data(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(obj);
	PyObject *py_more_data;
	py_more_data = PyLong_FromUnsignedLongLong((uint32_t)(object->more_data));
	return py_more_data;
}

static int py_drsuapi_DsGetNCChangesCtr6_set_more_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->more_data");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->more_data));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->more_data = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr6_get_nc_object_count(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(obj);
	PyObject *py_nc_object_count;
	py_nc_object_count = PyLong_FromUnsignedLongLong((uint32_t)(object->nc_object_count));
	return py_nc_object_count;
}

static int py_drsuapi_DsGetNCChangesCtr6_set_nc_object_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->nc_object_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->nc_object_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->nc_object_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr6_get_nc_linked_attributes_count(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(obj);
	PyObject *py_nc_linked_attributes_count;
	py_nc_linked_attributes_count = PyLong_FromUnsignedLongLong((uint32_t)(object->nc_linked_attributes_count));
	return py_nc_linked_attributes_count;
}

static int py_drsuapi_DsGetNCChangesCtr6_set_nc_linked_attributes_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->nc_linked_attributes_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->nc_linked_attributes_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->nc_linked_attributes_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr6_get_linked_attributes_count(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(obj);
	PyObject *py_linked_attributes_count;
	py_linked_attributes_count = PyLong_FromUnsignedLongLong((uint32_t)(object->linked_attributes_count));
	return py_linked_attributes_count;
}

static int py_drsuapi_DsGetNCChangesCtr6_set_linked_attributes_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->linked_attributes_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->linked_attributes_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->linked_attributes_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr6_get_linked_attributes(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(obj);
	PyObject *py_linked_attributes;
	if (object->linked_attributes == NULL) {
		Py_RETURN_NONE;
	}
	if (object->linked_attributes == NULL) {
		py_linked_attributes = Py_None;
		Py_INCREF(py_linked_attributes);
	} else {
		py_linked_attributes = PyList_New(object->linked_attributes_count);
		if (py_linked_attributes == NULL) {
			return NULL;
		}
		{
			int linked_attributes_cntr_1;
			for (linked_attributes_cntr_1 = 0; linked_attributes_cntr_1 < (object->linked_attributes_count); linked_attributes_cntr_1++) {
				PyObject *py_linked_attributes_1;
				py_linked_attributes_1 = pytalloc_reference_ex(&drsuapi_DsReplicaLinkedAttribute_Type, object->linked_attributes, &(object->linked_attributes)[linked_attributes_cntr_1]);
				PyList_SetItem(py_linked_attributes, linked_attributes_cntr_1, py_linked_attributes_1);
			}
		}
	}
	return py_linked_attributes;
}

static int py_drsuapi_DsGetNCChangesCtr6_set_linked_attributes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->linked_attributes));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->linked_attributes");
		return -1;
	}
	if (value == Py_None) {
		object->linked_attributes = NULL;
	} else {
		object->linked_attributes = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int linked_attributes_cntr_1;
			object->linked_attributes = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->linked_attributes, PyList_GET_SIZE(value));
			if (!object->linked_attributes) { return -1; }
			talloc_set_name_const(object->linked_attributes, "ARRAY: object->linked_attributes");
			for (linked_attributes_cntr_1 = 0; linked_attributes_cntr_1 < PyList_GET_SIZE(value); linked_attributes_cntr_1++) {
				if (PyList_GET_ITEM(value, linked_attributes_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->linked_attributes)[linked_attributes_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&drsuapi_DsReplicaLinkedAttribute_Type, PyList_GET_ITEM(value, linked_attributes_cntr_1), return -1;);
				if (talloc_reference(object->linked_attributes, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, linked_attributes_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->linked_attributes)[linked_attributes_cntr_1] = *(struct drsuapi_DsReplicaLinkedAttribute *)pytalloc_get_ptr(PyList_GET_ITEM(value, linked_attributes_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr6_get_drs_error(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(obj);
	PyObject *py_drs_error;
	py_drs_error = PyErr_FromWERROR(object->drs_error);
	return py_drs_error;
}

static int py_drsuapi_DsGetNCChangesCtr6_set_drs_error(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->drs_error");
		return -1;
	}
	object->drs_error = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_drsuapi_DsGetNCChangesCtr6_getsetters[] = {
	{
		.name = discard_const_p(char, "source_dsa_guid"),
		.get = py_drsuapi_DsGetNCChangesCtr6_get_source_dsa_guid,
		.set = py_drsuapi_DsGetNCChangesCtr6_set_source_dsa_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "source_dsa_invocation_id"),
		.get = py_drsuapi_DsGetNCChangesCtr6_get_source_dsa_invocation_id,
		.set = py_drsuapi_DsGetNCChangesCtr6_set_source_dsa_invocation_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "naming_context"),
		.get = py_drsuapi_DsGetNCChangesCtr6_get_naming_context,
		.set = py_drsuapi_DsGetNCChangesCtr6_set_naming_context,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObjectIdentifier")
	},
	{
		.name = discard_const_p(char, "old_highwatermark"),
		.get = py_drsuapi_DsGetNCChangesCtr6_get_old_highwatermark,
		.set = py_drsuapi_DsGetNCChangesCtr6_set_old_highwatermark,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaHighWaterMark")
	},
	{
		.name = discard_const_p(char, "new_highwatermark"),
		.get = py_drsuapi_DsGetNCChangesCtr6_get_new_highwatermark,
		.set = py_drsuapi_DsGetNCChangesCtr6_set_new_highwatermark,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaHighWaterMark")
	},
	{
		.name = discard_const_p(char, "uptodateness_vector"),
		.get = py_drsuapi_DsGetNCChangesCtr6_get_uptodateness_vector,
		.set = py_drsuapi_DsGetNCChangesCtr6_set_uptodateness_vector,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaCursor2CtrEx")
	},
	{
		.name = discard_const_p(char, "mapping_ctr"),
		.get = py_drsuapi_DsGetNCChangesCtr6_get_mapping_ctr,
		.set = py_drsuapi_DsGetNCChangesCtr6_set_mapping_ctr,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaOIDMapping_Ctr")
	},
	{
		.name = discard_const_p(char, "extended_ret"),
		.get = py_drsuapi_DsGetNCChangesCtr6_get_extended_ret,
		.set = py_drsuapi_DsGetNCChangesCtr6_set_extended_ret,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsExtendedError")
	},
	{
		.name = discard_const_p(char, "object_count"),
		.get = py_drsuapi_DsGetNCChangesCtr6_get_object_count,
		.set = py_drsuapi_DsGetNCChangesCtr6_set_object_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "__ndr_size"),
		.get = py_drsuapi_DsGetNCChangesCtr6_get___ndr_size,
		.set = py_drsuapi_DsGetNCChangesCtr6_set___ndr_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "first_object"),
		.get = py_drsuapi_DsGetNCChangesCtr6_get_first_object,
		.set = py_drsuapi_DsGetNCChangesCtr6_set_first_object,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObjectListItemEx")
	},
	{
		.name = discard_const_p(char, "more_data"),
		.get = py_drsuapi_DsGetNCChangesCtr6_get_more_data,
		.set = py_drsuapi_DsGetNCChangesCtr6_set_more_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "nc_object_count"),
		.get = py_drsuapi_DsGetNCChangesCtr6_get_nc_object_count,
		.set = py_drsuapi_DsGetNCChangesCtr6_set_nc_object_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "nc_linked_attributes_count"),
		.get = py_drsuapi_DsGetNCChangesCtr6_get_nc_linked_attributes_count,
		.set = py_drsuapi_DsGetNCChangesCtr6_set_nc_linked_attributes_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "linked_attributes_count"),
		.get = py_drsuapi_DsGetNCChangesCtr6_get_linked_attributes_count,
		.set = py_drsuapi_DsGetNCChangesCtr6_set_linked_attributes_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "linked_attributes"),
		.get = py_drsuapi_DsGetNCChangesCtr6_get_linked_attributes,
		.set = py_drsuapi_DsGetNCChangesCtr6_set_linked_attributes,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaLinkedAttribute")
	},
	{
		.name = discard_const_p(char, "drs_error"),
		.get = py_drsuapi_DsGetNCChangesCtr6_get_drs_error,
		.set = py_drsuapi_DsGetNCChangesCtr6_set_drs_error,
		.doc = discard_const_p(char, "PIDL-generated element of base type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsGetNCChangesCtr6_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsGetNCChangesCtr6, type);
}

static PyObject *py_drsuapi_DsGetNCChangesCtr6_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsGetNCChangesCtr6);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr6_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsGetNCChangesCtr6);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsGetNCChangesCtr6);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr6_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsGetNCChangesCtr6 *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsGetNCChangesCtr6, "drsuapi_DsGetNCChangesCtr6", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsGetNCChangesCtr6, "drsuapi_DsGetNCChangesCtr6", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_drsuapi_DsGetNCChangesCtr6_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_drsuapi_DsGetNCChangesCtr6_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsGetNCChangesCtr6_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsGetNCChangesCtr6_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject drsuapi_DsGetNCChangesCtr6_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetNCChangesCtr6",
	.tp_getset = py_drsuapi_DsGetNCChangesCtr6_getsetters,
	.tp_methods = py_drsuapi_DsGetNCChangesCtr6_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetNCChangesCtr6_new,
};


static PyObject *py_drsuapi_DsGetNCChangesCtr1TS_get_ctr1(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr1TS *object = pytalloc_get_ptr(obj);
	PyObject *py_ctr1;
	py_ctr1 = pytalloc_reference_ex(&drsuapi_DsGetNCChangesCtr1_Type, pytalloc_get_mem_ctx(obj), &object->ctr1);
	return py_ctr1;
}

static int py_drsuapi_DsGetNCChangesCtr1TS_set_ctr1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr1TS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ctr1");
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsGetNCChangesCtr1_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->ctr1 = *(struct drsuapi_DsGetNCChangesCtr1 *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_drsuapi_DsGetNCChangesCtr1TS_getsetters[] = {
	{
		.name = discard_const_p(char, "ctr1"),
		.get = py_drsuapi_DsGetNCChangesCtr1TS_get_ctr1,
		.set = py_drsuapi_DsGetNCChangesCtr1TS_set_ctr1,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsGetNCChangesCtr1")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsGetNCChangesCtr1TS_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsGetNCChangesCtr1TS, type);
}

static PyObject *py_drsuapi_DsGetNCChangesCtr1TS_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct drsuapi_DsGetNCChangesCtr1TS *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsGetNCChangesCtr1TS);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr1TS_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsGetNCChangesCtr1TS *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsGetNCChangesCtr1TS);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsGetNCChangesCtr1TS);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr1TS_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsGetNCChangesCtr1TS *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsGetNCChangesCtr1TS, "drsuapi_DsGetNCChangesCtr1TS", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsGetNCChangesCtr1TS, "drsuapi_DsGetNCChangesCtr1TS", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_drsuapi_DsGetNCChangesCtr1TS_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_drsuapi_DsGetNCChangesCtr1TS_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsGetNCChangesCtr1TS_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsGetNCChangesCtr1TS_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject drsuapi_DsGetNCChangesCtr1TS_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetNCChangesCtr1TS",
	.tp_getset = py_drsuapi_DsGetNCChangesCtr1TS_getsetters,
	.tp_methods = py_drsuapi_DsGetNCChangesCtr1TS_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetNCChangesCtr1TS_new,
};


static PyObject *py_drsuapi_DsGetNCChangesCtr6TS_get_ctr6(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6TS *object = pytalloc_get_ptr(obj);
	PyObject *py_ctr6;
	py_ctr6 = pytalloc_reference_ex(&drsuapi_DsGetNCChangesCtr6_Type, pytalloc_get_mem_ctx(obj), &object->ctr6);
	return py_ctr6;
}

static int py_drsuapi_DsGetNCChangesCtr6TS_set_ctr6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr6TS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ctr6");
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsGetNCChangesCtr6_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->ctr6 = *(struct drsuapi_DsGetNCChangesCtr6 *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_drsuapi_DsGetNCChangesCtr6TS_getsetters[] = {
	{
		.name = discard_const_p(char, "ctr6"),
		.get = py_drsuapi_DsGetNCChangesCtr6TS_get_ctr6,
		.set = py_drsuapi_DsGetNCChangesCtr6TS_set_ctr6,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsGetNCChangesCtr6")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsGetNCChangesCtr6TS_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsGetNCChangesCtr6TS, type);
}

static PyObject *py_drsuapi_DsGetNCChangesCtr6TS_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct drsuapi_DsGetNCChangesCtr6TS *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsGetNCChangesCtr6TS);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr6TS_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsGetNCChangesCtr6TS *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsGetNCChangesCtr6TS);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsGetNCChangesCtr6TS);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr6TS_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsGetNCChangesCtr6TS *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsGetNCChangesCtr6TS, "drsuapi_DsGetNCChangesCtr6TS", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsGetNCChangesCtr6TS, "drsuapi_DsGetNCChangesCtr6TS", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_drsuapi_DsGetNCChangesCtr6TS_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_drsuapi_DsGetNCChangesCtr6TS_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsGetNCChangesCtr6TS_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsGetNCChangesCtr6TS_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject drsuapi_DsGetNCChangesCtr6TS_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetNCChangesCtr6TS",
	.tp_getset = py_drsuapi_DsGetNCChangesCtr6TS_getsetters,
	.tp_methods = py_drsuapi_DsGetNCChangesCtr6TS_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetNCChangesCtr6TS_new,
};


static PyObject *py_drsuapi_DsGetNCChangesMSZIPCtr1_get_decompressed_length(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesMSZIPCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_decompressed_length;
	py_decompressed_length = PyLong_FromUnsignedLongLong((uint32_t)(object->decompressed_length));
	return py_decompressed_length;
}

static int py_drsuapi_DsGetNCChangesMSZIPCtr1_set_decompressed_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesMSZIPCtr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->decompressed_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->decompressed_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->decompressed_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesMSZIPCtr1_get_compressed_length(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesMSZIPCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_compressed_length;
	py_compressed_length = PyLong_FromUnsignedLongLong((uint32_t)(object->compressed_length));
	return py_compressed_length;
}

static int py_drsuapi_DsGetNCChangesMSZIPCtr1_set_compressed_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesMSZIPCtr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->compressed_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->compressed_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->compressed_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesMSZIPCtr1_get_ts(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesMSZIPCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_ts;
	if (object->ts == NULL) {
		Py_RETURN_NONE;
	}
	if (object->ts == NULL) {
		py_ts = Py_None;
		Py_INCREF(py_ts);
	} else {
		py_ts = pytalloc_reference_ex(&drsuapi_DsGetNCChangesCtr1TS_Type, object->ts, object->ts);
	}
	return py_ts;
}

static int py_drsuapi_DsGetNCChangesMSZIPCtr1_set_ts(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesMSZIPCtr1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->ts));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ts");
		return -1;
	}
	if (value == Py_None) {
		object->ts = NULL;
	} else {
		object->ts = NULL;
		PY_CHECK_TYPE(&drsuapi_DsGetNCChangesCtr1TS_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->ts = (struct drsuapi_DsGetNCChangesCtr1TS *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsGetNCChangesMSZIPCtr1_getsetters[] = {
	{
		.name = discard_const_p(char, "decompressed_length"),
		.get = py_drsuapi_DsGetNCChangesMSZIPCtr1_get_decompressed_length,
		.set = py_drsuapi_DsGetNCChangesMSZIPCtr1_set_decompressed_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "compressed_length"),
		.get = py_drsuapi_DsGetNCChangesMSZIPCtr1_get_compressed_length,
		.set = py_drsuapi_DsGetNCChangesMSZIPCtr1_set_compressed_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ts"),
		.get = py_drsuapi_DsGetNCChangesMSZIPCtr1_get_ts,
		.set = py_drsuapi_DsGetNCChangesMSZIPCtr1_set_ts,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsGetNCChangesCtr1TS")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsGetNCChangesMSZIPCtr1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsGetNCChangesMSZIPCtr1, type);
}


static PyTypeObject drsuapi_DsGetNCChangesMSZIPCtr1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetNCChangesMSZIPCtr1",
	.tp_getset = py_drsuapi_DsGetNCChangesMSZIPCtr1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetNCChangesMSZIPCtr1_new,
};


static PyObject *py_drsuapi_DsGetNCChangesMSZIPCtr6_get_decompressed_length(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesMSZIPCtr6 *object = pytalloc_get_ptr(obj);
	PyObject *py_decompressed_length;
	py_decompressed_length = PyLong_FromUnsignedLongLong((uint32_t)(object->decompressed_length));
	return py_decompressed_length;
}

static int py_drsuapi_DsGetNCChangesMSZIPCtr6_set_decompressed_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesMSZIPCtr6 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->decompressed_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->decompressed_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->decompressed_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesMSZIPCtr6_get_compressed_length(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesMSZIPCtr6 *object = pytalloc_get_ptr(obj);
	PyObject *py_compressed_length;
	py_compressed_length = PyLong_FromUnsignedLongLong((uint32_t)(object->compressed_length));
	return py_compressed_length;
}

static int py_drsuapi_DsGetNCChangesMSZIPCtr6_set_compressed_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesMSZIPCtr6 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->compressed_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->compressed_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->compressed_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesMSZIPCtr6_get_ts(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesMSZIPCtr6 *object = pytalloc_get_ptr(obj);
	PyObject *py_ts;
	if (object->ts == NULL) {
		Py_RETURN_NONE;
	}
	if (object->ts == NULL) {
		py_ts = Py_None;
		Py_INCREF(py_ts);
	} else {
		py_ts = pytalloc_reference_ex(&drsuapi_DsGetNCChangesCtr6TS_Type, object->ts, object->ts);
	}
	return py_ts;
}

static int py_drsuapi_DsGetNCChangesMSZIPCtr6_set_ts(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesMSZIPCtr6 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->ts));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ts");
		return -1;
	}
	if (value == Py_None) {
		object->ts = NULL;
	} else {
		object->ts = NULL;
		PY_CHECK_TYPE(&drsuapi_DsGetNCChangesCtr6TS_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->ts = (struct drsuapi_DsGetNCChangesCtr6TS *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsGetNCChangesMSZIPCtr6_getsetters[] = {
	{
		.name = discard_const_p(char, "decompressed_length"),
		.get = py_drsuapi_DsGetNCChangesMSZIPCtr6_get_decompressed_length,
		.set = py_drsuapi_DsGetNCChangesMSZIPCtr6_set_decompressed_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "compressed_length"),
		.get = py_drsuapi_DsGetNCChangesMSZIPCtr6_get_compressed_length,
		.set = py_drsuapi_DsGetNCChangesMSZIPCtr6_set_compressed_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ts"),
		.get = py_drsuapi_DsGetNCChangesMSZIPCtr6_get_ts,
		.set = py_drsuapi_DsGetNCChangesMSZIPCtr6_set_ts,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsGetNCChangesCtr6TS")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsGetNCChangesMSZIPCtr6_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsGetNCChangesMSZIPCtr6, type);
}


static PyTypeObject drsuapi_DsGetNCChangesMSZIPCtr6_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetNCChangesMSZIPCtr6",
	.tp_getset = py_drsuapi_DsGetNCChangesMSZIPCtr6_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetNCChangesMSZIPCtr6_new,
};


static PyObject *py_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1_get_decompressed_length(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_decompressed_length;
	py_decompressed_length = PyLong_FromUnsignedLongLong((uint32_t)(object->decompressed_length));
	return py_decompressed_length;
}

static int py_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1_set_decompressed_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->decompressed_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->decompressed_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->decompressed_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1_get_compressed_length(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_compressed_length;
	py_compressed_length = PyLong_FromUnsignedLongLong((uint32_t)(object->compressed_length));
	return py_compressed_length;
}

static int py_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1_set_compressed_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->compressed_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->compressed_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->compressed_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1_get_ts(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_ts;
	if (object->ts == NULL) {
		Py_RETURN_NONE;
	}
	if (object->ts == NULL) {
		py_ts = Py_None;
		Py_INCREF(py_ts);
	} else {
		py_ts = pytalloc_reference_ex(&drsuapi_DsGetNCChangesCtr1TS_Type, object->ts, object->ts);
	}
	return py_ts;
}

static int py_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1_set_ts(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->ts));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ts");
		return -1;
	}
	if (value == Py_None) {
		object->ts = NULL;
	} else {
		object->ts = NULL;
		PY_CHECK_TYPE(&drsuapi_DsGetNCChangesCtr1TS_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->ts = (struct drsuapi_DsGetNCChangesCtr1TS *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1_getsetters[] = {
	{
		.name = discard_const_p(char, "decompressed_length"),
		.get = py_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1_get_decompressed_length,
		.set = py_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1_set_decompressed_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "compressed_length"),
		.get = py_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1_get_compressed_length,
		.set = py_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1_set_compressed_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ts"),
		.get = py_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1_get_ts,
		.set = py_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1_set_ts,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsGetNCChangesCtr1TS")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1, type);
}


static PyTypeObject drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1",
	.tp_getset = py_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1_new,
};


static PyObject *py_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6_get_decompressed_length(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6 *object = pytalloc_get_ptr(obj);
	PyObject *py_decompressed_length;
	py_decompressed_length = PyLong_FromUnsignedLongLong((uint32_t)(object->decompressed_length));
	return py_decompressed_length;
}

static int py_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6_set_decompressed_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->decompressed_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->decompressed_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->decompressed_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6_get_compressed_length(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6 *object = pytalloc_get_ptr(obj);
	PyObject *py_compressed_length;
	py_compressed_length = PyLong_FromUnsignedLongLong((uint32_t)(object->compressed_length));
	return py_compressed_length;
}

static int py_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6_set_compressed_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->compressed_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->compressed_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->compressed_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6_get_ts(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6 *object = pytalloc_get_ptr(obj);
	PyObject *py_ts;
	if (object->ts == NULL) {
		Py_RETURN_NONE;
	}
	if (object->ts == NULL) {
		py_ts = Py_None;
		Py_INCREF(py_ts);
	} else {
		py_ts = pytalloc_reference_ex(&drsuapi_DsGetNCChangesCtr6TS_Type, object->ts, object->ts);
	}
	return py_ts;
}

static int py_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6_set_ts(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->ts));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ts");
		return -1;
	}
	if (value == Py_None) {
		object->ts = NULL;
	} else {
		object->ts = NULL;
		PY_CHECK_TYPE(&drsuapi_DsGetNCChangesCtr6TS_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->ts = (struct drsuapi_DsGetNCChangesCtr6TS *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6_getsetters[] = {
	{
		.name = discard_const_p(char, "decompressed_length"),
		.get = py_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6_get_decompressed_length,
		.set = py_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6_set_decompressed_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "compressed_length"),
		.get = py_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6_get_compressed_length,
		.set = py_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6_set_compressed_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ts"),
		.get = py_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6_get_ts,
		.set = py_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6_set_ts,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsGetNCChangesCtr6TS")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6, type);
}


static PyTypeObject drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6",
	.tp_getset = py_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6_new,
};

static PyObject *py_import_drsuapi_DsGetNCChangesCompressedCtr(TALLOC_CTX *mem_ctx, int level, union drsuapi_DsGetNCChangesCompressedCtr *in)
{
	PyObject *ret;

	switch (level) {
		case 1|(DRSUAPI_COMPRESSION_TYPE_MSZIP<<16):
			ret = pytalloc_reference_ex(&drsuapi_DsGetNCChangesMSZIPCtr1_Type, mem_ctx, &in->mszip1);
			return ret;

		case 6|(DRSUAPI_COMPRESSION_TYPE_MSZIP<<16):
			ret = pytalloc_reference_ex(&drsuapi_DsGetNCChangesMSZIPCtr6_Type, mem_ctx, &in->mszip6);
			return ret;

		case 1|(DRSUAPI_COMPRESSION_TYPE_WIN2K3_LZ77_DIRECT2<<16):
			ret = pytalloc_reference_ex(&drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1_Type, mem_ctx, &in->xpress1);
			return ret;

		case 6|(DRSUAPI_COMPRESSION_TYPE_WIN2K3_LZ77_DIRECT2<<16):
			ret = pytalloc_reference_ex(&drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6_Type, mem_ctx, &in->xpress6);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union drsuapi_DsGetNCChangesCompressedCtr *py_export_drsuapi_DsGetNCChangesCompressedCtr(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union drsuapi_DsGetNCChangesCompressedCtr *ret = talloc_zero(mem_ctx, union drsuapi_DsGetNCChangesCompressedCtr);
	switch (level) {
		case 1|(DRSUAPI_COMPRESSION_TYPE_MSZIP<<16):
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->mszip1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsGetNCChangesMSZIPCtr1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->mszip1 = *(struct drsuapi_DsGetNCChangesMSZIPCtr1 *)pytalloc_get_ptr(in);
			break;

		case 6|(DRSUAPI_COMPRESSION_TYPE_MSZIP<<16):
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->mszip6");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsGetNCChangesMSZIPCtr6_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->mszip6 = *(struct drsuapi_DsGetNCChangesMSZIPCtr6 *)pytalloc_get_ptr(in);
			break;

		case 1|(DRSUAPI_COMPRESSION_TYPE_WIN2K3_LZ77_DIRECT2<<16):
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->xpress1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->xpress1 = *(struct drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1 *)pytalloc_get_ptr(in);
			break;

		case 6|(DRSUAPI_COMPRESSION_TYPE_WIN2K3_LZ77_DIRECT2<<16):
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->xpress6");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->xpress6 = *(struct drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_drsuapi_DsGetNCChangesCompressedCtr_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union drsuapi_DsGetNCChangesCompressedCtr *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union drsuapi_DsGetNCChangesCompressedCtr *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union drsuapi_DsGetNCChangesCompressedCtr!");
		return NULL;
	}

	return py_import_drsuapi_DsGetNCChangesCompressedCtr(mem_ctx, level, in);
}

static PyObject *py_drsuapi_DsGetNCChangesCompressedCtr_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union drsuapi_DsGetNCChangesCompressedCtr *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_drsuapi_DsGetNCChangesCompressedCtr(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_drsuapi_DsGetNCChangesCompressedCtr_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsGetNCChangesCompressedCtr_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsGetNCChangesCompressedCtr_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_drsuapi_DsGetNCChangesCompressedCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject drsuapi_DsGetNCChangesCompressedCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetNCChangesCompressedCtr",
	.tp_getset = NULL,
	.tp_methods = py_drsuapi_DsGetNCChangesCompressedCtr_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetNCChangesCompressedCtr_new,
};


static PyObject *py_drsuapi_DsGetNCChangesCtr2_get_mszip1(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr2 *object = pytalloc_get_ptr(obj);
	PyObject *py_mszip1;
	py_mszip1 = pytalloc_reference_ex(&drsuapi_DsGetNCChangesMSZIPCtr1_Type, pytalloc_get_mem_ctx(obj), &object->mszip1);
	return py_mszip1;
}

static int py_drsuapi_DsGetNCChangesCtr2_set_mszip1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->mszip1");
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsGetNCChangesMSZIPCtr1_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->mszip1 = *(struct drsuapi_DsGetNCChangesMSZIPCtr1 *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_drsuapi_DsGetNCChangesCtr2_getsetters[] = {
	{
		.name = discard_const_p(char, "mszip1"),
		.get = py_drsuapi_DsGetNCChangesCtr2_get_mszip1,
		.set = py_drsuapi_DsGetNCChangesCtr2_set_mszip1,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsGetNCChangesMSZIPCtr1")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsGetNCChangesCtr2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsGetNCChangesCtr2, type);
}


static PyTypeObject drsuapi_DsGetNCChangesCtr2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetNCChangesCtr2",
	.tp_getset = py_drsuapi_DsGetNCChangesCtr2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetNCChangesCtr2_new,
};


static PyObject *py_drsuapi_DsGetNCChangesCtr7_get_level(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr7 *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromUnsignedLongLong((uint32_t)(object->level));
	return py_level;
}

static int py_drsuapi_DsGetNCChangesCtr7_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr7 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr7_get_type(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr7 *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromLong((uint16_t)(object->type));
	return py_type;
}

static int py_drsuapi_DsGetNCChangesCtr7_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr7 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr7_get_ctr(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr7 *object = pytalloc_get_ptr(obj);
	PyObject *py_ctr;
	py_ctr = pyrpc_import_union(&drsuapi_DsGetNCChangesCompressedCtr_Type, pytalloc_get_mem_ctx(obj), object->level | (object->type << 16), &object->ctr, "union drsuapi_DsGetNCChangesCompressedCtr");
	if (py_ctr == NULL) {
		return NULL;
	}
	return py_ctr;
}

static int py_drsuapi_DsGetNCChangesCtr7_set_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNCChangesCtr7 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ctr");
		return -1;
	}
	{
		union drsuapi_DsGetNCChangesCompressedCtr *ctr_switch_0;
		ctr_switch_0 = (union drsuapi_DsGetNCChangesCompressedCtr *)pyrpc_export_union(&drsuapi_DsGetNCChangesCompressedCtr_Type, pytalloc_get_mem_ctx(py_obj), object->level | (object->type << 16), value, "union drsuapi_DsGetNCChangesCompressedCtr");
		if (ctr_switch_0 == NULL) {
			return -1;
		}
		object->ctr = *ctr_switch_0;
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsGetNCChangesCtr7_getsetters[] = {
	{
		.name = discard_const_p(char, "level"),
		.get = py_drsuapi_DsGetNCChangesCtr7_get_level,
		.set = py_drsuapi_DsGetNCChangesCtr7_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "type"),
		.get = py_drsuapi_DsGetNCChangesCtr7_get_type,
		.set = py_drsuapi_DsGetNCChangesCtr7_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsGetNCChangesCompressionType")
	},
	{
		.name = discard_const_p(char, "ctr"),
		.get = py_drsuapi_DsGetNCChangesCtr7_get_ctr,
		.set = py_drsuapi_DsGetNCChangesCtr7_set_ctr,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsGetNCChangesCompressedCtr")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsGetNCChangesCtr7_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsGetNCChangesCtr7, type);
}


static PyTypeObject drsuapi_DsGetNCChangesCtr7_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetNCChangesCtr7",
	.tp_getset = py_drsuapi_DsGetNCChangesCtr7_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetNCChangesCtr7_new,
};

static PyObject *py_import_drsuapi_DsGetNCChangesCtr(TALLOC_CTX *mem_ctx, int level, union drsuapi_DsGetNCChangesCtr *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = pytalloc_reference_ex(&drsuapi_DsGetNCChangesCtr1_Type, mem_ctx, &in->ctr1);
			return ret;

		case 2:
			ret = pytalloc_reference_ex(&drsuapi_DsGetNCChangesCtr2_Type, mem_ctx, &in->ctr2);
			return ret;

		case 6:
			ret = pytalloc_reference_ex(&drsuapi_DsGetNCChangesCtr6_Type, mem_ctx, &in->ctr6);
			return ret;

		case 7:
			ret = pytalloc_reference_ex(&drsuapi_DsGetNCChangesCtr7_Type, mem_ctx, &in->ctr7);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union drsuapi_DsGetNCChangesCtr *py_export_drsuapi_DsGetNCChangesCtr(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union drsuapi_DsGetNCChangesCtr *ret = talloc_zero(mem_ctx, union drsuapi_DsGetNCChangesCtr);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsGetNCChangesCtr1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ctr1 = *(struct drsuapi_DsGetNCChangesCtr1 *)pytalloc_get_ptr(in);
			break;

		case 2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr2");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsGetNCChangesCtr2_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ctr2 = *(struct drsuapi_DsGetNCChangesCtr2 *)pytalloc_get_ptr(in);
			break;

		case 6:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr6");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsGetNCChangesCtr6_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ctr6 = *(struct drsuapi_DsGetNCChangesCtr6 *)pytalloc_get_ptr(in);
			break;

		case 7:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr7");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsGetNCChangesCtr7_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ctr7 = *(struct drsuapi_DsGetNCChangesCtr7 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_drsuapi_DsGetNCChangesCtr_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union drsuapi_DsGetNCChangesCtr *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union drsuapi_DsGetNCChangesCtr *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union drsuapi_DsGetNCChangesCtr!");
		return NULL;
	}

	return py_import_drsuapi_DsGetNCChangesCtr(mem_ctx, level, in);
}

static PyObject *py_drsuapi_DsGetNCChangesCtr_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union drsuapi_DsGetNCChangesCtr *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_drsuapi_DsGetNCChangesCtr(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_drsuapi_DsGetNCChangesCtr_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsGetNCChangesCtr_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsGetNCChangesCtr_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_drsuapi_DsGetNCChangesCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject drsuapi_DsGetNCChangesCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetNCChangesCtr",
	.tp_getset = NULL,
	.tp_methods = py_drsuapi_DsGetNCChangesCtr_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetNCChangesCtr_new,
};


static PyObject *py_drsuapi_DsReplicaUpdateRefsRequest1_get_naming_context(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaUpdateRefsRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_naming_context;
	if (object->naming_context == NULL) {
		Py_RETURN_NONE;
	}
	py_naming_context = pytalloc_reference_ex(&drsuapi_DsReplicaObjectIdentifier_Type, object->naming_context, object->naming_context);
	return py_naming_context;
}

static int py_drsuapi_DsReplicaUpdateRefsRequest1_set_naming_context(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaUpdateRefsRequest1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->naming_context));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->naming_context");
		return -1;
	}
	object->naming_context = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->naming_context);
	if (object->naming_context == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsReplicaObjectIdentifier_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->naming_context = (struct drsuapi_DsReplicaObjectIdentifier *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsReplicaUpdateRefsRequest1_get_dest_dsa_dns_name(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaUpdateRefsRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_dest_dsa_dns_name;
	if (object->dest_dsa_dns_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->dest_dsa_dns_name == NULL) {
		py_dest_dsa_dns_name = Py_None;
		Py_INCREF(py_dest_dsa_dns_name);
	} else {
		py_dest_dsa_dns_name = PyUnicode_Decode(object->dest_dsa_dns_name, strlen(object->dest_dsa_dns_name), "utf-8", "ignore");
	}
	return py_dest_dsa_dns_name;
}

static int py_drsuapi_DsReplicaUpdateRefsRequest1_set_dest_dsa_dns_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaUpdateRefsRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dest_dsa_dns_name");
		return -1;
	}
	object->dest_dsa_dns_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->dest_dsa_dns_name);
	if (object->dest_dsa_dns_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->dest_dsa_dns_name = talloc_str;
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaUpdateRefsRequest1_get_dest_dsa_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaUpdateRefsRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_dest_dsa_guid;
	py_dest_dsa_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->dest_dsa_guid);
	return py_dest_dsa_guid;
}

static int py_drsuapi_DsReplicaUpdateRefsRequest1_set_dest_dsa_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaUpdateRefsRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dest_dsa_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dest_dsa_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsReplicaUpdateRefsRequest1_get_options(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaUpdateRefsRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_options;
	py_options = PyLong_FromUnsignedLongLong((uint32_t)(object->options));
	return py_options;
}

static int py_drsuapi_DsReplicaUpdateRefsRequest1_set_options(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaUpdateRefsRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->options");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->options));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->options = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaUpdateRefsRequest1_getsetters[] = {
	{
		.name = discard_const_p(char, "naming_context"),
		.get = py_drsuapi_DsReplicaUpdateRefsRequest1_get_naming_context,
		.set = py_drsuapi_DsReplicaUpdateRefsRequest1_set_naming_context,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObjectIdentifier")
	},
	{
		.name = discard_const_p(char, "dest_dsa_dns_name"),
		.get = py_drsuapi_DsReplicaUpdateRefsRequest1_get_dest_dsa_dns_name,
		.set = py_drsuapi_DsReplicaUpdateRefsRequest1_set_dest_dsa_dns_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "dest_dsa_guid"),
		.get = py_drsuapi_DsReplicaUpdateRefsRequest1_get_dest_dsa_guid,
		.set = py_drsuapi_DsReplicaUpdateRefsRequest1_set_dest_dsa_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "options"),
		.get = py_drsuapi_DsReplicaUpdateRefsRequest1_get_options,
		.set = py_drsuapi_DsReplicaUpdateRefsRequest1_set_options,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DrsOptions")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaUpdateRefsRequest1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaUpdateRefsRequest1, type);
}


static PyTypeObject drsuapi_DsReplicaUpdateRefsRequest1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaUpdateRefsRequest1",
	.tp_getset = py_drsuapi_DsReplicaUpdateRefsRequest1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaUpdateRefsRequest1_new,
};

static PyObject *py_import_drsuapi_DsReplicaUpdateRefsRequest(TALLOC_CTX *mem_ctx, int level, union drsuapi_DsReplicaUpdateRefsRequest *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = pytalloc_reference_ex(&drsuapi_DsReplicaUpdateRefsRequest1_Type, mem_ctx, &in->req1);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union drsuapi_DsReplicaUpdateRefsRequest *py_export_drsuapi_DsReplicaUpdateRefsRequest(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union drsuapi_DsReplicaUpdateRefsRequest *ret = talloc_zero(mem_ctx, union drsuapi_DsReplicaUpdateRefsRequest);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->req1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsReplicaUpdateRefsRequest1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->req1 = *(struct drsuapi_DsReplicaUpdateRefsRequest1 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_drsuapi_DsReplicaUpdateRefsRequest_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union drsuapi_DsReplicaUpdateRefsRequest *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union drsuapi_DsReplicaUpdateRefsRequest *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union drsuapi_DsReplicaUpdateRefsRequest!");
		return NULL;
	}

	return py_import_drsuapi_DsReplicaUpdateRefsRequest(mem_ctx, level, in);
}

static PyObject *py_drsuapi_DsReplicaUpdateRefsRequest_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union drsuapi_DsReplicaUpdateRefsRequest *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_drsuapi_DsReplicaUpdateRefsRequest(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_drsuapi_DsReplicaUpdateRefsRequest_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaUpdateRefsRequest_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaUpdateRefsRequest_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_drsuapi_DsReplicaUpdateRefsRequest_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject drsuapi_DsReplicaUpdateRefsRequest_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaUpdateRefsRequest",
	.tp_getset = NULL,
	.tp_methods = py_drsuapi_DsReplicaUpdateRefsRequest_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaUpdateRefsRequest_new,
};


static PyObject *py_drsuapi_DsReplicaAddRequest1_get_naming_context(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaAddRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_naming_context;
	if (object->naming_context == NULL) {
		Py_RETURN_NONE;
	}
	py_naming_context = pytalloc_reference_ex(&drsuapi_DsReplicaObjectIdentifier_Type, object->naming_context, object->naming_context);
	return py_naming_context;
}

static int py_drsuapi_DsReplicaAddRequest1_set_naming_context(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaAddRequest1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->naming_context));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->naming_context");
		return -1;
	}
	object->naming_context = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->naming_context);
	if (object->naming_context == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsReplicaObjectIdentifier_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->naming_context = (struct drsuapi_DsReplicaObjectIdentifier *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsReplicaAddRequest1_get_source_dsa_address(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaAddRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_source_dsa_address;
	if (object->source_dsa_address == NULL) {
		Py_RETURN_NONE;
	}
	if (object->source_dsa_address == NULL) {
		py_source_dsa_address = Py_None;
		Py_INCREF(py_source_dsa_address);
	} else {
		if (object->source_dsa_address == NULL) {
			py_source_dsa_address = Py_None;
			Py_INCREF(py_source_dsa_address);
		} else {
			py_source_dsa_address = PyUnicode_Decode(object->source_dsa_address, strlen(object->source_dsa_address), "utf-8", "ignore");
		}
	}
	return py_source_dsa_address;
}

static int py_drsuapi_DsReplicaAddRequest1_set_source_dsa_address(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaAddRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->source_dsa_address");
		return -1;
	}
	if (value == Py_None) {
		object->source_dsa_address = NULL;
	} else {
		object->source_dsa_address = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->source_dsa_address = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaAddRequest1_get_schedule(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaAddRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_schedule;
	py_schedule = PyList_New(84);
	if (py_schedule == NULL) {
		return NULL;
	}
	{
		int schedule_cntr_0;
		for (schedule_cntr_0 = 0; schedule_cntr_0 < (84); schedule_cntr_0++) {
			PyObject *py_schedule_0;
			py_schedule_0 = PyLong_FromLong((uint16_t)((object->schedule)[schedule_cntr_0]));
			PyList_SetItem(py_schedule, schedule_cntr_0, py_schedule_0);
		}
	}
	return py_schedule;
}

static int py_drsuapi_DsReplicaAddRequest1_set_schedule(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaAddRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->schedule");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int schedule_cntr_0;
		if (ARRAY_SIZE(object->schedule) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->schedule),  PyList_GET_SIZE(value));
			return -1;
		}
		for (schedule_cntr_0 = 0; schedule_cntr_0 < PyList_GET_SIZE(value); schedule_cntr_0++) {
			if (PyList_GET_ITEM(value, schedule_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->schedule)[schedule_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->schedule)[schedule_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, schedule_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, schedule_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->schedule)[schedule_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaAddRequest1_get_options(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaAddRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_options;
	py_options = PyLong_FromUnsignedLongLong((uint32_t)(object->options));
	return py_options;
}

static int py_drsuapi_DsReplicaAddRequest1_set_options(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaAddRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->options");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->options));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->options = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaAddRequest1_getsetters[] = {
	{
		.name = discard_const_p(char, "naming_context"),
		.get = py_drsuapi_DsReplicaAddRequest1_get_naming_context,
		.set = py_drsuapi_DsReplicaAddRequest1_set_naming_context,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObjectIdentifier")
	},
	{
		.name = discard_const_p(char, "source_dsa_address"),
		.get = py_drsuapi_DsReplicaAddRequest1_get_source_dsa_address,
		.set = py_drsuapi_DsReplicaAddRequest1_set_source_dsa_address,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "schedule"),
		.get = py_drsuapi_DsReplicaAddRequest1_get_schedule,
		.set = py_drsuapi_DsReplicaAddRequest1_set_schedule,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "options"),
		.get = py_drsuapi_DsReplicaAddRequest1_get_options,
		.set = py_drsuapi_DsReplicaAddRequest1_set_options,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DrsOptions")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaAddRequest1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaAddRequest1, type);
}


static PyTypeObject drsuapi_DsReplicaAddRequest1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaAddRequest1",
	.tp_getset = py_drsuapi_DsReplicaAddRequest1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaAddRequest1_new,
};


static PyObject *py_drsuapi_DsReplicaAddRequest2_get_naming_context(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaAddRequest2 *object = pytalloc_get_ptr(obj);
	PyObject *py_naming_context;
	if (object->naming_context == NULL) {
		Py_RETURN_NONE;
	}
	py_naming_context = pytalloc_reference_ex(&drsuapi_DsReplicaObjectIdentifier_Type, object->naming_context, object->naming_context);
	return py_naming_context;
}

static int py_drsuapi_DsReplicaAddRequest2_set_naming_context(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaAddRequest2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->naming_context));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->naming_context");
		return -1;
	}
	object->naming_context = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->naming_context);
	if (object->naming_context == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsReplicaObjectIdentifier_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->naming_context = (struct drsuapi_DsReplicaObjectIdentifier *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsReplicaAddRequest2_get_source_dsa_dn(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaAddRequest2 *object = pytalloc_get_ptr(obj);
	PyObject *py_source_dsa_dn;
	if (object->source_dsa_dn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->source_dsa_dn == NULL) {
		py_source_dsa_dn = Py_None;
		Py_INCREF(py_source_dsa_dn);
	} else {
		py_source_dsa_dn = pytalloc_reference_ex(&drsuapi_DsReplicaObjectIdentifier_Type, object->source_dsa_dn, object->source_dsa_dn);
	}
	return py_source_dsa_dn;
}

static int py_drsuapi_DsReplicaAddRequest2_set_source_dsa_dn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaAddRequest2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->source_dsa_dn));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->source_dsa_dn");
		return -1;
	}
	if (value == Py_None) {
		object->source_dsa_dn = NULL;
	} else {
		object->source_dsa_dn = NULL;
		PY_CHECK_TYPE(&drsuapi_DsReplicaObjectIdentifier_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->source_dsa_dn = (struct drsuapi_DsReplicaObjectIdentifier *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaAddRequest2_get_transport_dn(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaAddRequest2 *object = pytalloc_get_ptr(obj);
	PyObject *py_transport_dn;
	if (object->transport_dn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->transport_dn == NULL) {
		py_transport_dn = Py_None;
		Py_INCREF(py_transport_dn);
	} else {
		py_transport_dn = pytalloc_reference_ex(&drsuapi_DsReplicaObjectIdentifier_Type, object->transport_dn, object->transport_dn);
	}
	return py_transport_dn;
}

static int py_drsuapi_DsReplicaAddRequest2_set_transport_dn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaAddRequest2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->transport_dn));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->transport_dn");
		return -1;
	}
	if (value == Py_None) {
		object->transport_dn = NULL;
	} else {
		object->transport_dn = NULL;
		PY_CHECK_TYPE(&drsuapi_DsReplicaObjectIdentifier_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->transport_dn = (struct drsuapi_DsReplicaObjectIdentifier *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaAddRequest2_get_source_dsa_address(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaAddRequest2 *object = pytalloc_get_ptr(obj);
	PyObject *py_source_dsa_address;
	if (object->source_dsa_address == NULL) {
		Py_RETURN_NONE;
	}
	if (object->source_dsa_address == NULL) {
		py_source_dsa_address = Py_None;
		Py_INCREF(py_source_dsa_address);
	} else {
		if (object->source_dsa_address == NULL) {
			py_source_dsa_address = Py_None;
			Py_INCREF(py_source_dsa_address);
		} else {
			py_source_dsa_address = PyUnicode_Decode(object->source_dsa_address, strlen(object->source_dsa_address), "utf-8", "ignore");
		}
	}
	return py_source_dsa_address;
}

static int py_drsuapi_DsReplicaAddRequest2_set_source_dsa_address(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaAddRequest2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->source_dsa_address");
		return -1;
	}
	if (value == Py_None) {
		object->source_dsa_address = NULL;
	} else {
		object->source_dsa_address = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->source_dsa_address = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaAddRequest2_get_schedule(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaAddRequest2 *object = pytalloc_get_ptr(obj);
	PyObject *py_schedule;
	py_schedule = PyList_New(84);
	if (py_schedule == NULL) {
		return NULL;
	}
	{
		int schedule_cntr_0;
		for (schedule_cntr_0 = 0; schedule_cntr_0 < (84); schedule_cntr_0++) {
			PyObject *py_schedule_0;
			py_schedule_0 = PyLong_FromLong((uint16_t)((object->schedule)[schedule_cntr_0]));
			PyList_SetItem(py_schedule, schedule_cntr_0, py_schedule_0);
		}
	}
	return py_schedule;
}

static int py_drsuapi_DsReplicaAddRequest2_set_schedule(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaAddRequest2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->schedule");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int schedule_cntr_0;
		if (ARRAY_SIZE(object->schedule) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->schedule),  PyList_GET_SIZE(value));
			return -1;
		}
		for (schedule_cntr_0 = 0; schedule_cntr_0 < PyList_GET_SIZE(value); schedule_cntr_0++) {
			if (PyList_GET_ITEM(value, schedule_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->schedule)[schedule_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->schedule)[schedule_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, schedule_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, schedule_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->schedule)[schedule_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaAddRequest2_get_options(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaAddRequest2 *object = pytalloc_get_ptr(obj);
	PyObject *py_options;
	py_options = PyLong_FromUnsignedLongLong((uint32_t)(object->options));
	return py_options;
}

static int py_drsuapi_DsReplicaAddRequest2_set_options(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaAddRequest2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->options");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->options));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->options = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaAddRequest2_getsetters[] = {
	{
		.name = discard_const_p(char, "naming_context"),
		.get = py_drsuapi_DsReplicaAddRequest2_get_naming_context,
		.set = py_drsuapi_DsReplicaAddRequest2_set_naming_context,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObjectIdentifier")
	},
	{
		.name = discard_const_p(char, "source_dsa_dn"),
		.get = py_drsuapi_DsReplicaAddRequest2_get_source_dsa_dn,
		.set = py_drsuapi_DsReplicaAddRequest2_set_source_dsa_dn,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObjectIdentifier")
	},
	{
		.name = discard_const_p(char, "transport_dn"),
		.get = py_drsuapi_DsReplicaAddRequest2_get_transport_dn,
		.set = py_drsuapi_DsReplicaAddRequest2_set_transport_dn,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObjectIdentifier")
	},
	{
		.name = discard_const_p(char, "source_dsa_address"),
		.get = py_drsuapi_DsReplicaAddRequest2_get_source_dsa_address,
		.set = py_drsuapi_DsReplicaAddRequest2_set_source_dsa_address,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "schedule"),
		.get = py_drsuapi_DsReplicaAddRequest2_get_schedule,
		.set = py_drsuapi_DsReplicaAddRequest2_set_schedule,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "options"),
		.get = py_drsuapi_DsReplicaAddRequest2_get_options,
		.set = py_drsuapi_DsReplicaAddRequest2_set_options,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DrsOptions")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaAddRequest2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaAddRequest2, type);
}


static PyTypeObject drsuapi_DsReplicaAddRequest2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaAddRequest2",
	.tp_getset = py_drsuapi_DsReplicaAddRequest2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaAddRequest2_new,
};

static PyObject *py_import_drsuapi_DsReplicaAddRequest(TALLOC_CTX *mem_ctx, int level, union drsuapi_DsReplicaAddRequest *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = pytalloc_reference_ex(&drsuapi_DsReplicaAddRequest1_Type, mem_ctx, &in->req1);
			return ret;

		case 2:
			ret = pytalloc_reference_ex(&drsuapi_DsReplicaAddRequest2_Type, mem_ctx, &in->req2);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union drsuapi_DsReplicaAddRequest *py_export_drsuapi_DsReplicaAddRequest(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union drsuapi_DsReplicaAddRequest *ret = talloc_zero(mem_ctx, union drsuapi_DsReplicaAddRequest);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->req1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsReplicaAddRequest1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->req1 = *(struct drsuapi_DsReplicaAddRequest1 *)pytalloc_get_ptr(in);
			break;

		case 2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->req2");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsReplicaAddRequest2_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->req2 = *(struct drsuapi_DsReplicaAddRequest2 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_drsuapi_DsReplicaAddRequest_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union drsuapi_DsReplicaAddRequest *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union drsuapi_DsReplicaAddRequest *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union drsuapi_DsReplicaAddRequest!");
		return NULL;
	}

	return py_import_drsuapi_DsReplicaAddRequest(mem_ctx, level, in);
}

static PyObject *py_drsuapi_DsReplicaAddRequest_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union drsuapi_DsReplicaAddRequest *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_drsuapi_DsReplicaAddRequest(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_drsuapi_DsReplicaAddRequest_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaAddRequest_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaAddRequest_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_drsuapi_DsReplicaAddRequest_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject drsuapi_DsReplicaAddRequest_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaAddRequest",
	.tp_getset = NULL,
	.tp_methods = py_drsuapi_DsReplicaAddRequest_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaAddRequest_new,
};


static PyObject *py_drsuapi_DsReplicaDelRequest1_get_naming_context(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaDelRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_naming_context;
	if (object->naming_context == NULL) {
		Py_RETURN_NONE;
	}
	py_naming_context = pytalloc_reference_ex(&drsuapi_DsReplicaObjectIdentifier_Type, object->naming_context, object->naming_context);
	return py_naming_context;
}

static int py_drsuapi_DsReplicaDelRequest1_set_naming_context(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaDelRequest1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->naming_context));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->naming_context");
		return -1;
	}
	object->naming_context = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->naming_context);
	if (object->naming_context == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsReplicaObjectIdentifier_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->naming_context = (struct drsuapi_DsReplicaObjectIdentifier *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsReplicaDelRequest1_get_source_dsa_address(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaDelRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_source_dsa_address;
	if (object->source_dsa_address == NULL) {
		Py_RETURN_NONE;
	}
	if (object->source_dsa_address == NULL) {
		py_source_dsa_address = Py_None;
		Py_INCREF(py_source_dsa_address);
	} else {
		if (object->source_dsa_address == NULL) {
			py_source_dsa_address = Py_None;
			Py_INCREF(py_source_dsa_address);
		} else {
			py_source_dsa_address = PyUnicode_Decode(object->source_dsa_address, strlen(object->source_dsa_address), "utf-8", "ignore");
		}
	}
	return py_source_dsa_address;
}

static int py_drsuapi_DsReplicaDelRequest1_set_source_dsa_address(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaDelRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->source_dsa_address");
		return -1;
	}
	if (value == Py_None) {
		object->source_dsa_address = NULL;
	} else {
		object->source_dsa_address = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->source_dsa_address = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaDelRequest1_get_options(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaDelRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_options;
	py_options = PyLong_FromUnsignedLongLong((uint32_t)(object->options));
	return py_options;
}

static int py_drsuapi_DsReplicaDelRequest1_set_options(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaDelRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->options");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->options));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->options = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaDelRequest1_getsetters[] = {
	{
		.name = discard_const_p(char, "naming_context"),
		.get = py_drsuapi_DsReplicaDelRequest1_get_naming_context,
		.set = py_drsuapi_DsReplicaDelRequest1_set_naming_context,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObjectIdentifier")
	},
	{
		.name = discard_const_p(char, "source_dsa_address"),
		.get = py_drsuapi_DsReplicaDelRequest1_get_source_dsa_address,
		.set = py_drsuapi_DsReplicaDelRequest1_set_source_dsa_address,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "options"),
		.get = py_drsuapi_DsReplicaDelRequest1_get_options,
		.set = py_drsuapi_DsReplicaDelRequest1_set_options,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DrsOptions")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaDelRequest1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaDelRequest1, type);
}


static PyTypeObject drsuapi_DsReplicaDelRequest1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaDelRequest1",
	.tp_getset = py_drsuapi_DsReplicaDelRequest1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaDelRequest1_new,
};

static PyObject *py_import_drsuapi_DsReplicaDelRequest(TALLOC_CTX *mem_ctx, int level, union drsuapi_DsReplicaDelRequest *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = pytalloc_reference_ex(&drsuapi_DsReplicaDelRequest1_Type, mem_ctx, &in->req1);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union drsuapi_DsReplicaDelRequest *py_export_drsuapi_DsReplicaDelRequest(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union drsuapi_DsReplicaDelRequest *ret = talloc_zero(mem_ctx, union drsuapi_DsReplicaDelRequest);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->req1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsReplicaDelRequest1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->req1 = *(struct drsuapi_DsReplicaDelRequest1 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_drsuapi_DsReplicaDelRequest_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union drsuapi_DsReplicaDelRequest *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union drsuapi_DsReplicaDelRequest *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union drsuapi_DsReplicaDelRequest!");
		return NULL;
	}

	return py_import_drsuapi_DsReplicaDelRequest(mem_ctx, level, in);
}

static PyObject *py_drsuapi_DsReplicaDelRequest_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union drsuapi_DsReplicaDelRequest *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_drsuapi_DsReplicaDelRequest(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_drsuapi_DsReplicaDelRequest_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaDelRequest_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaDelRequest_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_drsuapi_DsReplicaDelRequest_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject drsuapi_DsReplicaDelRequest_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaDelRequest",
	.tp_getset = NULL,
	.tp_methods = py_drsuapi_DsReplicaDelRequest_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaDelRequest_new,
};


static PyObject *py_drsuapi_DsReplicaModRequest1_get_naming_context(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaModRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_naming_context;
	if (object->naming_context == NULL) {
		Py_RETURN_NONE;
	}
	py_naming_context = pytalloc_reference_ex(&drsuapi_DsReplicaObjectIdentifier_Type, object->naming_context, object->naming_context);
	return py_naming_context;
}

static int py_drsuapi_DsReplicaModRequest1_set_naming_context(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaModRequest1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->naming_context));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->naming_context");
		return -1;
	}
	object->naming_context = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->naming_context);
	if (object->naming_context == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsReplicaObjectIdentifier_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->naming_context = (struct drsuapi_DsReplicaObjectIdentifier *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsReplicaModRequest1_get_source_dsa(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaModRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_source_dsa;
	py_source_dsa = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->source_dsa);
	return py_source_dsa;
}

static int py_drsuapi_DsReplicaModRequest1_set_source_dsa(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaModRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->source_dsa");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->source_dsa = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsReplicaModRequest1_get_source_dsa_address(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaModRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_source_dsa_address;
	if (object->source_dsa_address == NULL) {
		Py_RETURN_NONE;
	}
	if (object->source_dsa_address == NULL) {
		py_source_dsa_address = Py_None;
		Py_INCREF(py_source_dsa_address);
	} else {
		if (object->source_dsa_address == NULL) {
			py_source_dsa_address = Py_None;
			Py_INCREF(py_source_dsa_address);
		} else {
			py_source_dsa_address = PyUnicode_Decode(object->source_dsa_address, strlen(object->source_dsa_address), "utf-8", "ignore");
		}
	}
	return py_source_dsa_address;
}

static int py_drsuapi_DsReplicaModRequest1_set_source_dsa_address(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaModRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->source_dsa_address");
		return -1;
	}
	if (value == Py_None) {
		object->source_dsa_address = NULL;
	} else {
		object->source_dsa_address = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->source_dsa_address = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaModRequest1_get_schedule(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaModRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_schedule;
	py_schedule = PyList_New(84);
	if (py_schedule == NULL) {
		return NULL;
	}
	{
		int schedule_cntr_0;
		for (schedule_cntr_0 = 0; schedule_cntr_0 < (84); schedule_cntr_0++) {
			PyObject *py_schedule_0;
			py_schedule_0 = PyLong_FromLong((uint16_t)((object->schedule)[schedule_cntr_0]));
			PyList_SetItem(py_schedule, schedule_cntr_0, py_schedule_0);
		}
	}
	return py_schedule;
}

static int py_drsuapi_DsReplicaModRequest1_set_schedule(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaModRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->schedule");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int schedule_cntr_0;
		if (ARRAY_SIZE(object->schedule) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->schedule),  PyList_GET_SIZE(value));
			return -1;
		}
		for (schedule_cntr_0 = 0; schedule_cntr_0 < PyList_GET_SIZE(value); schedule_cntr_0++) {
			if (PyList_GET_ITEM(value, schedule_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->schedule)[schedule_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->schedule)[schedule_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, schedule_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, schedule_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->schedule)[schedule_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaModRequest1_get_replica_flags(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaModRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_replica_flags;
	py_replica_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->replica_flags));
	return py_replica_flags;
}

static int py_drsuapi_DsReplicaModRequest1_set_replica_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaModRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->replica_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->replica_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->replica_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaModRequest1_get_modify_fields(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaModRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_modify_fields;
	py_modify_fields = PyLong_FromUnsignedLongLong((uint32_t)(object->modify_fields));
	return py_modify_fields;
}

static int py_drsuapi_DsReplicaModRequest1_set_modify_fields(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaModRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->modify_fields");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->modify_fields));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->modify_fields = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaModRequest1_get_options(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaModRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_options;
	py_options = PyLong_FromUnsignedLongLong((uint32_t)(object->options));
	return py_options;
}

static int py_drsuapi_DsReplicaModRequest1_set_options(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaModRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->options");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->options));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->options = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaModRequest1_getsetters[] = {
	{
		.name = discard_const_p(char, "naming_context"),
		.get = py_drsuapi_DsReplicaModRequest1_get_naming_context,
		.set = py_drsuapi_DsReplicaModRequest1_set_naming_context,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObjectIdentifier")
	},
	{
		.name = discard_const_p(char, "source_dsa"),
		.get = py_drsuapi_DsReplicaModRequest1_get_source_dsa,
		.set = py_drsuapi_DsReplicaModRequest1_set_source_dsa,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "source_dsa_address"),
		.get = py_drsuapi_DsReplicaModRequest1_get_source_dsa_address,
		.set = py_drsuapi_DsReplicaModRequest1_set_source_dsa_address,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "schedule"),
		.get = py_drsuapi_DsReplicaModRequest1_get_schedule,
		.set = py_drsuapi_DsReplicaModRequest1_set_schedule,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "replica_flags"),
		.get = py_drsuapi_DsReplicaModRequest1_get_replica_flags,
		.set = py_drsuapi_DsReplicaModRequest1_set_replica_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DrsOptions")
	},
	{
		.name = discard_const_p(char, "modify_fields"),
		.get = py_drsuapi_DsReplicaModRequest1_get_modify_fields,
		.set = py_drsuapi_DsReplicaModRequest1_set_modify_fields,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "options"),
		.get = py_drsuapi_DsReplicaModRequest1_get_options,
		.set = py_drsuapi_DsReplicaModRequest1_set_options,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DrsOptions")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaModRequest1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaModRequest1, type);
}


static PyTypeObject drsuapi_DsReplicaModRequest1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaModRequest1",
	.tp_getset = py_drsuapi_DsReplicaModRequest1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaModRequest1_new,
};

static PyObject *py_import_drsuapi_DsReplicaModRequest(TALLOC_CTX *mem_ctx, int level, union drsuapi_DsReplicaModRequest *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = pytalloc_reference_ex(&drsuapi_DsReplicaModRequest1_Type, mem_ctx, &in->req1);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union drsuapi_DsReplicaModRequest *py_export_drsuapi_DsReplicaModRequest(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union drsuapi_DsReplicaModRequest *ret = talloc_zero(mem_ctx, union drsuapi_DsReplicaModRequest);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->req1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsReplicaModRequest1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->req1 = *(struct drsuapi_DsReplicaModRequest1 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_drsuapi_DsReplicaModRequest_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union drsuapi_DsReplicaModRequest *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union drsuapi_DsReplicaModRequest *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union drsuapi_DsReplicaModRequest!");
		return NULL;
	}

	return py_import_drsuapi_DsReplicaModRequest(mem_ctx, level, in);
}

static PyObject *py_drsuapi_DsReplicaModRequest_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union drsuapi_DsReplicaModRequest *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_drsuapi_DsReplicaModRequest(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_drsuapi_DsReplicaModRequest_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaModRequest_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaModRequest_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_drsuapi_DsReplicaModRequest_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject drsuapi_DsReplicaModRequest_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaModRequest",
	.tp_getset = NULL,
	.tp_methods = py_drsuapi_DsReplicaModRequest_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaModRequest_new,
};


static PyObject *py_drsuapi_DsGetMembershipsCtr1_get_status(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetMembershipsCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_status;
	py_status = PyErr_FromNTSTATUS(object->status);
	return py_status;
}

static int py_drsuapi_DsGetMembershipsCtr1_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetMembershipsCtr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->status");
		return -1;
	}
	object->status = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyObject *py_drsuapi_DsGetMembershipsCtr1_get_num_memberships(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetMembershipsCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_num_memberships;
	py_num_memberships = PyLong_FromUnsignedLongLong((uint32_t)(object->num_memberships));
	return py_num_memberships;
}

static int py_drsuapi_DsGetMembershipsCtr1_set_num_memberships(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetMembershipsCtr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_memberships");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_memberships));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_memberships = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetMembershipsCtr1_get_num_sids(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetMembershipsCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_num_sids;
	py_num_sids = PyLong_FromUnsignedLongLong((uint32_t)(object->num_sids));
	return py_num_sids;
}

static int py_drsuapi_DsGetMembershipsCtr1_set_num_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetMembershipsCtr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_sids");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_sids));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_sids = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetMembershipsCtr1_get_info_array(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetMembershipsCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_info_array;
	if (object->info_array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->info_array == NULL) {
		py_info_array = Py_None;
		Py_INCREF(py_info_array);
	} else {
		py_info_array = PyList_New(object->num_memberships);
		if (py_info_array == NULL) {
			return NULL;
		}
		{
			int info_array_cntr_1;
			for (info_array_cntr_1 = 0; info_array_cntr_1 < (object->num_memberships); info_array_cntr_1++) {
				PyObject *py_info_array_1;
				if ((object->info_array)[info_array_cntr_1] == NULL) {
					py_info_array_1 = Py_None;
					Py_INCREF(py_info_array_1);
				} else {
					py_info_array_1 = pytalloc_reference_ex(&drsuapi_DsReplicaObjectIdentifier_Type, (object->info_array)[info_array_cntr_1], (object->info_array)[info_array_cntr_1]);
				}
				PyList_SetItem(py_info_array, info_array_cntr_1, py_info_array_1);
			}
		}
	}
	return py_info_array;
}

static int py_drsuapi_DsGetMembershipsCtr1_set_info_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetMembershipsCtr1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->info_array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info_array");
		return -1;
	}
	if (value == Py_None) {
		object->info_array = NULL;
	} else {
		object->info_array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int info_array_cntr_1;
			object->info_array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->info_array, PyList_GET_SIZE(value));
			if (!object->info_array) { return -1; }
			talloc_set_name_const(object->info_array, "ARRAY: object->info_array");
			for (info_array_cntr_1 = 0; info_array_cntr_1 < PyList_GET_SIZE(value); info_array_cntr_1++) {
				if (PyList_GET_ITEM(value, info_array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->info_array)[info_array_cntr_1]");
					return -1;
				}
				if (PyList_GET_ITEM(value, info_array_cntr_1) == Py_None) {
					(object->info_array)[info_array_cntr_1] = NULL;
				} else {
					(object->info_array)[info_array_cntr_1] = NULL;
					PY_CHECK_TYPE(&drsuapi_DsReplicaObjectIdentifier_Type, PyList_GET_ITEM(value, info_array_cntr_1), return -1;);
					if (talloc_reference(object->info_array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, info_array_cntr_1))) == NULL) {
						PyErr_NoMemory();
						return -1;
					}
					(object->info_array)[info_array_cntr_1] = (struct drsuapi_DsReplicaObjectIdentifier *)pytalloc_get_ptr(PyList_GET_ITEM(value, info_array_cntr_1));
				}
			}
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetMembershipsCtr1_get_group_attrs(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetMembershipsCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_group_attrs;
	if (object->group_attrs == NULL) {
		Py_RETURN_NONE;
	}
	if (object->group_attrs == NULL) {
		py_group_attrs = Py_None;
		Py_INCREF(py_group_attrs);
	} else {
		py_group_attrs = PyList_New(object->num_memberships);
		if (py_group_attrs == NULL) {
			return NULL;
		}
		{
			int group_attrs_cntr_1;
			for (group_attrs_cntr_1 = 0; group_attrs_cntr_1 < (object->num_memberships); group_attrs_cntr_1++) {
				PyObject *py_group_attrs_1;
				py_group_attrs_1 = PyLong_FromUnsignedLongLong((uint32_t)((object->group_attrs)[group_attrs_cntr_1]));
				PyList_SetItem(py_group_attrs, group_attrs_cntr_1, py_group_attrs_1);
			}
		}
	}
	return py_group_attrs;
}

static int py_drsuapi_DsGetMembershipsCtr1_set_group_attrs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetMembershipsCtr1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->group_attrs));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->group_attrs");
		return -1;
	}
	if (value == Py_None) {
		object->group_attrs = NULL;
	} else {
		object->group_attrs = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int group_attrs_cntr_1;
			object->group_attrs = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->group_attrs, PyList_GET_SIZE(value));
			if (!object->group_attrs) { return -1; }
			talloc_set_name_const(object->group_attrs, "ARRAY: object->group_attrs");
			for (group_attrs_cntr_1 = 0; group_attrs_cntr_1 < PyList_GET_SIZE(value); group_attrs_cntr_1++) {
				if (PyList_GET_ITEM(value, group_attrs_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->group_attrs)[group_attrs_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->group_attrs)[group_attrs_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, group_attrs_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, group_attrs_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->group_attrs)[group_attrs_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetMembershipsCtr1_get_sids(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetMembershipsCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_sids;
	if (object->sids == NULL) {
		Py_RETURN_NONE;
	}
	if (object->sids == NULL) {
		py_sids = Py_None;
		Py_INCREF(py_sids);
	} else {
		py_sids = PyList_New(object->num_sids);
		if (py_sids == NULL) {
			return NULL;
		}
		{
			int sids_cntr_1;
			for (sids_cntr_1 = 0; sids_cntr_1 < (object->num_sids); sids_cntr_1++) {
				PyObject *py_sids_1;
				if ((object->sids)[sids_cntr_1] == NULL) {
					py_sids_1 = Py_None;
					Py_INCREF(py_sids_1);
				} else {
					py_sids_1 = pytalloc_reference_ex(dom_sid_Type, (object->sids)[sids_cntr_1], (object->sids)[sids_cntr_1]);
				}
				PyList_SetItem(py_sids, sids_cntr_1, py_sids_1);
			}
		}
	}
	return py_sids;
}

static int py_drsuapi_DsGetMembershipsCtr1_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetMembershipsCtr1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->sids));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sids");
		return -1;
	}
	if (value == Py_None) {
		object->sids = NULL;
	} else {
		object->sids = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int sids_cntr_1;
			object->sids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->sids, PyList_GET_SIZE(value));
			if (!object->sids) { return -1; }
			talloc_set_name_const(object->sids, "ARRAY: object->sids");
			for (sids_cntr_1 = 0; sids_cntr_1 < PyList_GET_SIZE(value); sids_cntr_1++) {
				if (PyList_GET_ITEM(value, sids_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->sids)[sids_cntr_1]");
					return -1;
				}
				if (PyList_GET_ITEM(value, sids_cntr_1) == Py_None) {
					(object->sids)[sids_cntr_1] = NULL;
				} else {
					(object->sids)[sids_cntr_1] = NULL;
					PY_CHECK_TYPE(dom_sid_Type, PyList_GET_ITEM(value, sids_cntr_1), return -1;);
					if (talloc_reference(object->sids, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, sids_cntr_1))) == NULL) {
						PyErr_NoMemory();
						return -1;
					}
					(object->sids)[sids_cntr_1] = (struct dom_sid *)pytalloc_get_ptr(PyList_GET_ITEM(value, sids_cntr_1));
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsGetMembershipsCtr1_getsetters[] = {
	{
		.name = discard_const_p(char, "status"),
		.get = py_drsuapi_DsGetMembershipsCtr1_get_status,
		.set = py_drsuapi_DsGetMembershipsCtr1_set_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTSTATUS")
	},
	{
		.name = discard_const_p(char, "num_memberships"),
		.get = py_drsuapi_DsGetMembershipsCtr1_get_num_memberships,
		.set = py_drsuapi_DsGetMembershipsCtr1_set_num_memberships,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "num_sids"),
		.get = py_drsuapi_DsGetMembershipsCtr1_get_num_sids,
		.set = py_drsuapi_DsGetMembershipsCtr1_set_num_sids,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "info_array"),
		.get = py_drsuapi_DsGetMembershipsCtr1_get_info_array,
		.set = py_drsuapi_DsGetMembershipsCtr1_set_info_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObjectIdentifier")
	},
	{
		.name = discard_const_p(char, "group_attrs"),
		.get = py_drsuapi_DsGetMembershipsCtr1_get_group_attrs,
		.set = py_drsuapi_DsGetMembershipsCtr1_set_group_attrs,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_GroupAttrs")
	},
	{
		.name = discard_const_p(char, "sids"),
		.get = py_drsuapi_DsGetMembershipsCtr1_get_sids,
		.set = py_drsuapi_DsGetMembershipsCtr1_set_sids,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid28")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsGetMembershipsCtr1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsGetMembershipsCtr1, type);
}


static PyTypeObject drsuapi_DsGetMembershipsCtr1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetMembershipsCtr1",
	.tp_getset = py_drsuapi_DsGetMembershipsCtr1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetMembershipsCtr1_new,
};

static PyObject *py_import_drsuapi_DsGetMembershipsCtr(TALLOC_CTX *mem_ctx, int level, union drsuapi_DsGetMembershipsCtr *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = pytalloc_reference_ex(&drsuapi_DsGetMembershipsCtr1_Type, mem_ctx, &in->ctr1);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union drsuapi_DsGetMembershipsCtr *py_export_drsuapi_DsGetMembershipsCtr(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union drsuapi_DsGetMembershipsCtr *ret = talloc_zero(mem_ctx, union drsuapi_DsGetMembershipsCtr);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsGetMembershipsCtr1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ctr1 = *(struct drsuapi_DsGetMembershipsCtr1 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_drsuapi_DsGetMembershipsCtr_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union drsuapi_DsGetMembershipsCtr *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union drsuapi_DsGetMembershipsCtr *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union drsuapi_DsGetMembershipsCtr!");
		return NULL;
	}

	return py_import_drsuapi_DsGetMembershipsCtr(mem_ctx, level, in);
}

static PyObject *py_drsuapi_DsGetMembershipsCtr_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union drsuapi_DsGetMembershipsCtr *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_drsuapi_DsGetMembershipsCtr(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_drsuapi_DsGetMembershipsCtr_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsGetMembershipsCtr_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsGetMembershipsCtr_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_drsuapi_DsGetMembershipsCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject drsuapi_DsGetMembershipsCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetMembershipsCtr",
	.tp_getset = NULL,
	.tp_methods = py_drsuapi_DsGetMembershipsCtr_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetMembershipsCtr_new,
};


static PyObject *py_drsuapi_DsGetMembershipsRequest1_get_count(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetMembershipsRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_drsuapi_DsGetMembershipsRequest1_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetMembershipsRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetMembershipsRequest1_get_info_array(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetMembershipsRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_info_array;
	if (object->info_array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->info_array == NULL) {
		py_info_array = Py_None;
		Py_INCREF(py_info_array);
	} else {
		py_info_array = PyList_New(object->count);
		if (py_info_array == NULL) {
			return NULL;
		}
		{
			int info_array_cntr_1;
			for (info_array_cntr_1 = 0; info_array_cntr_1 < (object->count); info_array_cntr_1++) {
				PyObject *py_info_array_1;
				if ((object->info_array)[info_array_cntr_1] == NULL) {
					py_info_array_1 = Py_None;
					Py_INCREF(py_info_array_1);
				} else {
					py_info_array_1 = pytalloc_reference_ex(&drsuapi_DsReplicaObjectIdentifier_Type, (object->info_array)[info_array_cntr_1], (object->info_array)[info_array_cntr_1]);
				}
				PyList_SetItem(py_info_array, info_array_cntr_1, py_info_array_1);
			}
		}
	}
	return py_info_array;
}

static int py_drsuapi_DsGetMembershipsRequest1_set_info_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetMembershipsRequest1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->info_array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info_array");
		return -1;
	}
	if (value == Py_None) {
		object->info_array = NULL;
	} else {
		object->info_array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int info_array_cntr_1;
			object->info_array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->info_array, PyList_GET_SIZE(value));
			if (!object->info_array) { return -1; }
			talloc_set_name_const(object->info_array, "ARRAY: object->info_array");
			for (info_array_cntr_1 = 0; info_array_cntr_1 < PyList_GET_SIZE(value); info_array_cntr_1++) {
				if (PyList_GET_ITEM(value, info_array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->info_array)[info_array_cntr_1]");
					return -1;
				}
				if (PyList_GET_ITEM(value, info_array_cntr_1) == Py_None) {
					(object->info_array)[info_array_cntr_1] = NULL;
				} else {
					(object->info_array)[info_array_cntr_1] = NULL;
					PY_CHECK_TYPE(&drsuapi_DsReplicaObjectIdentifier_Type, PyList_GET_ITEM(value, info_array_cntr_1), return -1;);
					if (talloc_reference(object->info_array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, info_array_cntr_1))) == NULL) {
						PyErr_NoMemory();
						return -1;
					}
					(object->info_array)[info_array_cntr_1] = (struct drsuapi_DsReplicaObjectIdentifier *)pytalloc_get_ptr(PyList_GET_ITEM(value, info_array_cntr_1));
				}
			}
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetMembershipsRequest1_get_flags(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetMembershipsRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->flags));
	return py_flags;
}

static int py_drsuapi_DsGetMembershipsRequest1_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetMembershipsRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetMembershipsRequest1_get_type(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetMembershipsRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromUnsignedLongLong((uint32_t)(object->type));
	return py_type;
}

static int py_drsuapi_DsGetMembershipsRequest1_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetMembershipsRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetMembershipsRequest1_get_domain(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetMembershipsRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_domain;
	if (object->domain == NULL) {
		Py_RETURN_NONE;
	}
	if (object->domain == NULL) {
		py_domain = Py_None;
		Py_INCREF(py_domain);
	} else {
		py_domain = pytalloc_reference_ex(&drsuapi_DsReplicaObjectIdentifier_Type, object->domain, object->domain);
	}
	return py_domain;
}

static int py_drsuapi_DsGetMembershipsRequest1_set_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetMembershipsRequest1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->domain));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain");
		return -1;
	}
	if (value == Py_None) {
		object->domain = NULL;
	} else {
		object->domain = NULL;
		PY_CHECK_TYPE(&drsuapi_DsReplicaObjectIdentifier_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->domain = (struct drsuapi_DsReplicaObjectIdentifier *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsGetMembershipsRequest1_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_drsuapi_DsGetMembershipsRequest1_get_count,
		.set = py_drsuapi_DsGetMembershipsRequest1_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "info_array"),
		.get = py_drsuapi_DsGetMembershipsRequest1_get_info_array,
		.set = py_drsuapi_DsGetMembershipsRequest1_set_info_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObjectIdentifier")
	},
	{
		.name = discard_const_p(char, "flags"),
		.get = py_drsuapi_DsGetMembershipsRequest1_get_flags,
		.set = py_drsuapi_DsGetMembershipsRequest1_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "type"),
		.get = py_drsuapi_DsGetMembershipsRequest1_get_type,
		.set = py_drsuapi_DsGetMembershipsRequest1_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsMembershipType")
	},
	{
		.name = discard_const_p(char, "domain"),
		.get = py_drsuapi_DsGetMembershipsRequest1_get_domain,
		.set = py_drsuapi_DsGetMembershipsRequest1_set_domain,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObjectIdentifier")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsGetMembershipsRequest1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsGetMembershipsRequest1, type);
}


static PyTypeObject drsuapi_DsGetMembershipsRequest1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetMembershipsRequest1",
	.tp_getset = py_drsuapi_DsGetMembershipsRequest1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetMembershipsRequest1_new,
};

static PyObject *py_import_drsuapi_DsGetMembershipsRequest(TALLOC_CTX *mem_ctx, int level, union drsuapi_DsGetMembershipsRequest *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = pytalloc_reference_ex(&drsuapi_DsGetMembershipsRequest1_Type, mem_ctx, &in->req1);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union drsuapi_DsGetMembershipsRequest *py_export_drsuapi_DsGetMembershipsRequest(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union drsuapi_DsGetMembershipsRequest *ret = talloc_zero(mem_ctx, union drsuapi_DsGetMembershipsRequest);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->req1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsGetMembershipsRequest1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->req1 = *(struct drsuapi_DsGetMembershipsRequest1 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_drsuapi_DsGetMembershipsRequest_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union drsuapi_DsGetMembershipsRequest *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union drsuapi_DsGetMembershipsRequest *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union drsuapi_DsGetMembershipsRequest!");
		return NULL;
	}

	return py_import_drsuapi_DsGetMembershipsRequest(mem_ctx, level, in);
}

static PyObject *py_drsuapi_DsGetMembershipsRequest_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union drsuapi_DsGetMembershipsRequest *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_drsuapi_DsGetMembershipsRequest(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_drsuapi_DsGetMembershipsRequest_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsGetMembershipsRequest_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsGetMembershipsRequest_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_drsuapi_DsGetMembershipsRequest_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject drsuapi_DsGetMembershipsRequest_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetMembershipsRequest",
	.tp_getset = NULL,
	.tp_methods = py_drsuapi_DsGetMembershipsRequest_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetMembershipsRequest_new,
};


static PyObject *py_drsuapi_DsGetNT4ChangeLogRequest1_get_flags(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNT4ChangeLogRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->flags));
	return py_flags;
}

static int py_drsuapi_DsGetNT4ChangeLogRequest1_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNT4ChangeLogRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNT4ChangeLogRequest1_get_preferred_maximum_length(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNT4ChangeLogRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_preferred_maximum_length;
	py_preferred_maximum_length = PyLong_FromUnsignedLongLong((uint32_t)(object->preferred_maximum_length));
	return py_preferred_maximum_length;
}

static int py_drsuapi_DsGetNT4ChangeLogRequest1_set_preferred_maximum_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNT4ChangeLogRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->preferred_maximum_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->preferred_maximum_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->preferred_maximum_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNT4ChangeLogRequest1_get_restart_length(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNT4ChangeLogRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_restart_length;
	py_restart_length = PyLong_FromUnsignedLongLong((uint32_t)(object->restart_length));
	return py_restart_length;
}

static int py_drsuapi_DsGetNT4ChangeLogRequest1_set_restart_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNT4ChangeLogRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->restart_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->restart_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->restart_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNT4ChangeLogRequest1_get_restart_data(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNT4ChangeLogRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_restart_data;
	if (object->restart_data == NULL) {
		Py_RETURN_NONE;
	}
	if (object->restart_data == NULL) {
		py_restart_data = Py_None;
		Py_INCREF(py_restart_data);
	} else {
		py_restart_data = PyList_New(object->restart_length);
		if (py_restart_data == NULL) {
			return NULL;
		}
		{
			int restart_data_cntr_1;
			for (restart_data_cntr_1 = 0; restart_data_cntr_1 < (object->restart_length); restart_data_cntr_1++) {
				PyObject *py_restart_data_1;
				py_restart_data_1 = PyLong_FromLong((uint16_t)((object->restart_data)[restart_data_cntr_1]));
				PyList_SetItem(py_restart_data, restart_data_cntr_1, py_restart_data_1);
			}
		}
	}
	return py_restart_data;
}

static int py_drsuapi_DsGetNT4ChangeLogRequest1_set_restart_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNT4ChangeLogRequest1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->restart_data));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->restart_data");
		return -1;
	}
	if (value == Py_None) {
		object->restart_data = NULL;
	} else {
		object->restart_data = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int restart_data_cntr_1;
			object->restart_data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->restart_data, PyList_GET_SIZE(value));
			if (!object->restart_data) { return -1; }
			talloc_set_name_const(object->restart_data, "ARRAY: object->restart_data");
			for (restart_data_cntr_1 = 0; restart_data_cntr_1 < PyList_GET_SIZE(value); restart_data_cntr_1++) {
				if (PyList_GET_ITEM(value, restart_data_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->restart_data)[restart_data_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->restart_data)[restart_data_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, restart_data_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, restart_data_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->restart_data)[restart_data_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsGetNT4ChangeLogRequest1_getsetters[] = {
	{
		.name = discard_const_p(char, "flags"),
		.get = py_drsuapi_DsGetNT4ChangeLogRequest1_get_flags,
		.set = py_drsuapi_DsGetNT4ChangeLogRequest1_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsGetNT4ChangeLogFlags")
	},
	{
		.name = discard_const_p(char, "preferred_maximum_length"),
		.get = py_drsuapi_DsGetNT4ChangeLogRequest1_get_preferred_maximum_length,
		.set = py_drsuapi_DsGetNT4ChangeLogRequest1_set_preferred_maximum_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "restart_length"),
		.get = py_drsuapi_DsGetNT4ChangeLogRequest1_get_restart_length,
		.set = py_drsuapi_DsGetNT4ChangeLogRequest1_set_restart_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "restart_data"),
		.get = py_drsuapi_DsGetNT4ChangeLogRequest1_get_restart_data,
		.set = py_drsuapi_DsGetNT4ChangeLogRequest1_set_restart_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsGetNT4ChangeLogRequest1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsGetNT4ChangeLogRequest1, type);
}


static PyTypeObject drsuapi_DsGetNT4ChangeLogRequest1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetNT4ChangeLogRequest1",
	.tp_getset = py_drsuapi_DsGetNT4ChangeLogRequest1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetNT4ChangeLogRequest1_new,
};

static PyObject *py_import_drsuapi_DsGetNT4ChangeLogRequest(TALLOC_CTX *mem_ctx, int level, union drsuapi_DsGetNT4ChangeLogRequest *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = pytalloc_reference_ex(&drsuapi_DsGetNT4ChangeLogRequest1_Type, mem_ctx, &in->req1);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union drsuapi_DsGetNT4ChangeLogRequest *py_export_drsuapi_DsGetNT4ChangeLogRequest(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union drsuapi_DsGetNT4ChangeLogRequest *ret = talloc_zero(mem_ctx, union drsuapi_DsGetNT4ChangeLogRequest);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->req1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsGetNT4ChangeLogRequest1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->req1 = *(struct drsuapi_DsGetNT4ChangeLogRequest1 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_drsuapi_DsGetNT4ChangeLogRequest_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union drsuapi_DsGetNT4ChangeLogRequest *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union drsuapi_DsGetNT4ChangeLogRequest *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union drsuapi_DsGetNT4ChangeLogRequest!");
		return NULL;
	}

	return py_import_drsuapi_DsGetNT4ChangeLogRequest(mem_ctx, level, in);
}

static PyObject *py_drsuapi_DsGetNT4ChangeLogRequest_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union drsuapi_DsGetNT4ChangeLogRequest *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_drsuapi_DsGetNT4ChangeLogRequest(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_drsuapi_DsGetNT4ChangeLogRequest_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsGetNT4ChangeLogRequest_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsGetNT4ChangeLogRequest_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_drsuapi_DsGetNT4ChangeLogRequest_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject drsuapi_DsGetNT4ChangeLogRequest_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetNT4ChangeLogRequest",
	.tp_getset = NULL,
	.tp_methods = py_drsuapi_DsGetNT4ChangeLogRequest_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetNT4ChangeLogRequest_new,
};


static PyObject *py_drsuapi_DsGetNT4ChangeLogInfo1_get_restart_length(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNT4ChangeLogInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_restart_length;
	py_restart_length = PyLong_FromUnsignedLongLong((uint32_t)(object->restart_length));
	return py_restart_length;
}

static int py_drsuapi_DsGetNT4ChangeLogInfo1_set_restart_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNT4ChangeLogInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->restart_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->restart_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->restart_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNT4ChangeLogInfo1_get_log_length(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNT4ChangeLogInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_log_length;
	py_log_length = PyLong_FromUnsignedLongLong((uint32_t)(object->log_length));
	return py_log_length;
}

static int py_drsuapi_DsGetNT4ChangeLogInfo1_set_log_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNT4ChangeLogInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->log_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->log_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->log_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNT4ChangeLogInfo1_get_sam_serial_number(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNT4ChangeLogInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_sam_serial_number;
	py_sam_serial_number = PyLong_FromUnsignedLongLong(object->sam_serial_number);
	return py_sam_serial_number;
}

static int py_drsuapi_DsGetNT4ChangeLogInfo1_set_sam_serial_number(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNT4ChangeLogInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sam_serial_number");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sam_serial_number));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sam_serial_number = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNT4ChangeLogInfo1_get_sam_creation_time(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNT4ChangeLogInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_sam_creation_time;
	py_sam_creation_time = PyLong_FromUnsignedLongLong(object->sam_creation_time);
	return py_sam_creation_time;
}

static int py_drsuapi_DsGetNT4ChangeLogInfo1_set_sam_creation_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNT4ChangeLogInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sam_creation_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sam_creation_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sam_creation_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNT4ChangeLogInfo1_get_builtin_serial_number(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNT4ChangeLogInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_builtin_serial_number;
	py_builtin_serial_number = PyLong_FromUnsignedLongLong(object->builtin_serial_number);
	return py_builtin_serial_number;
}

static int py_drsuapi_DsGetNT4ChangeLogInfo1_set_builtin_serial_number(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNT4ChangeLogInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->builtin_serial_number");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->builtin_serial_number));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->builtin_serial_number = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNT4ChangeLogInfo1_get_builtin_creation_time(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNT4ChangeLogInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_builtin_creation_time;
	py_builtin_creation_time = PyLong_FromUnsignedLongLong(object->builtin_creation_time);
	return py_builtin_creation_time;
}

static int py_drsuapi_DsGetNT4ChangeLogInfo1_set_builtin_creation_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNT4ChangeLogInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->builtin_creation_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->builtin_creation_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->builtin_creation_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNT4ChangeLogInfo1_get_lsa_serial_number(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNT4ChangeLogInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_lsa_serial_number;
	py_lsa_serial_number = PyLong_FromUnsignedLongLong(object->lsa_serial_number);
	return py_lsa_serial_number;
}

static int py_drsuapi_DsGetNT4ChangeLogInfo1_set_lsa_serial_number(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNT4ChangeLogInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lsa_serial_number");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lsa_serial_number));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lsa_serial_number = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNT4ChangeLogInfo1_get_lsa_creation_time(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNT4ChangeLogInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_lsa_creation_time;
	py_lsa_creation_time = PyLong_FromUnsignedLongLong(object->lsa_creation_time);
	return py_lsa_creation_time;
}

static int py_drsuapi_DsGetNT4ChangeLogInfo1_set_lsa_creation_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNT4ChangeLogInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lsa_creation_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lsa_creation_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lsa_creation_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNT4ChangeLogInfo1_get_status(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNT4ChangeLogInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_status;
	py_status = PyErr_FromNTSTATUS(object->status);
	return py_status;
}

static int py_drsuapi_DsGetNT4ChangeLogInfo1_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNT4ChangeLogInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->status");
		return -1;
	}
	object->status = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyObject *py_drsuapi_DsGetNT4ChangeLogInfo1_get_restart_data(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNT4ChangeLogInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_restart_data;
	if (object->restart_data == NULL) {
		Py_RETURN_NONE;
	}
	if (object->restart_data == NULL) {
		py_restart_data = Py_None;
		Py_INCREF(py_restart_data);
	} else {
		py_restart_data = PyList_New(object->restart_length);
		if (py_restart_data == NULL) {
			return NULL;
		}
		{
			int restart_data_cntr_1;
			for (restart_data_cntr_1 = 0; restart_data_cntr_1 < (object->restart_length); restart_data_cntr_1++) {
				PyObject *py_restart_data_1;
				py_restart_data_1 = PyLong_FromLong((uint16_t)((object->restart_data)[restart_data_cntr_1]));
				PyList_SetItem(py_restart_data, restart_data_cntr_1, py_restart_data_1);
			}
		}
	}
	return py_restart_data;
}

static int py_drsuapi_DsGetNT4ChangeLogInfo1_set_restart_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNT4ChangeLogInfo1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->restart_data));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->restart_data");
		return -1;
	}
	if (value == Py_None) {
		object->restart_data = NULL;
	} else {
		object->restart_data = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int restart_data_cntr_1;
			object->restart_data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->restart_data, PyList_GET_SIZE(value));
			if (!object->restart_data) { return -1; }
			talloc_set_name_const(object->restart_data, "ARRAY: object->restart_data");
			for (restart_data_cntr_1 = 0; restart_data_cntr_1 < PyList_GET_SIZE(value); restart_data_cntr_1++) {
				if (PyList_GET_ITEM(value, restart_data_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->restart_data)[restart_data_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->restart_data)[restart_data_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, restart_data_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, restart_data_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->restart_data)[restart_data_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetNT4ChangeLogInfo1_get_log_data(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetNT4ChangeLogInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_log_data;
	if (object->log_data == NULL) {
		Py_RETURN_NONE;
	}
	if (object->log_data == NULL) {
		py_log_data = Py_None;
		Py_INCREF(py_log_data);
	} else {
		py_log_data = PyList_New(object->log_length);
		if (py_log_data == NULL) {
			return NULL;
		}
		{
			int log_data_cntr_1;
			for (log_data_cntr_1 = 0; log_data_cntr_1 < (object->log_length); log_data_cntr_1++) {
				PyObject *py_log_data_1;
				py_log_data_1 = PyLong_FromLong((uint16_t)((object->log_data)[log_data_cntr_1]));
				PyList_SetItem(py_log_data, log_data_cntr_1, py_log_data_1);
			}
		}
	}
	return py_log_data;
}

static int py_drsuapi_DsGetNT4ChangeLogInfo1_set_log_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetNT4ChangeLogInfo1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->log_data));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->log_data");
		return -1;
	}
	if (value == Py_None) {
		object->log_data = NULL;
	} else {
		object->log_data = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int log_data_cntr_1;
			object->log_data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->log_data, PyList_GET_SIZE(value));
			if (!object->log_data) { return -1; }
			talloc_set_name_const(object->log_data, "ARRAY: object->log_data");
			for (log_data_cntr_1 = 0; log_data_cntr_1 < PyList_GET_SIZE(value); log_data_cntr_1++) {
				if (PyList_GET_ITEM(value, log_data_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->log_data)[log_data_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->log_data)[log_data_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, log_data_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, log_data_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->log_data)[log_data_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsGetNT4ChangeLogInfo1_getsetters[] = {
	{
		.name = discard_const_p(char, "restart_length"),
		.get = py_drsuapi_DsGetNT4ChangeLogInfo1_get_restart_length,
		.set = py_drsuapi_DsGetNT4ChangeLogInfo1_set_restart_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "log_length"),
		.get = py_drsuapi_DsGetNT4ChangeLogInfo1_get_log_length,
		.set = py_drsuapi_DsGetNT4ChangeLogInfo1_set_log_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sam_serial_number"),
		.get = py_drsuapi_DsGetNT4ChangeLogInfo1_get_sam_serial_number,
		.set = py_drsuapi_DsGetNT4ChangeLogInfo1_set_sam_serial_number,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "sam_creation_time"),
		.get = py_drsuapi_DsGetNT4ChangeLogInfo1_get_sam_creation_time,
		.set = py_drsuapi_DsGetNT4ChangeLogInfo1_set_sam_creation_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "builtin_serial_number"),
		.get = py_drsuapi_DsGetNT4ChangeLogInfo1_get_builtin_serial_number,
		.set = py_drsuapi_DsGetNT4ChangeLogInfo1_set_builtin_serial_number,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "builtin_creation_time"),
		.get = py_drsuapi_DsGetNT4ChangeLogInfo1_get_builtin_creation_time,
		.set = py_drsuapi_DsGetNT4ChangeLogInfo1_set_builtin_creation_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "lsa_serial_number"),
		.get = py_drsuapi_DsGetNT4ChangeLogInfo1_get_lsa_serial_number,
		.set = py_drsuapi_DsGetNT4ChangeLogInfo1_set_lsa_serial_number,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "lsa_creation_time"),
		.get = py_drsuapi_DsGetNT4ChangeLogInfo1_get_lsa_creation_time,
		.set = py_drsuapi_DsGetNT4ChangeLogInfo1_set_lsa_creation_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "status"),
		.get = py_drsuapi_DsGetNT4ChangeLogInfo1_get_status,
		.set = py_drsuapi_DsGetNT4ChangeLogInfo1_set_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTSTATUS")
	},
	{
		.name = discard_const_p(char, "restart_data"),
		.get = py_drsuapi_DsGetNT4ChangeLogInfo1_get_restart_data,
		.set = py_drsuapi_DsGetNT4ChangeLogInfo1_set_restart_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "log_data"),
		.get = py_drsuapi_DsGetNT4ChangeLogInfo1_get_log_data,
		.set = py_drsuapi_DsGetNT4ChangeLogInfo1_set_log_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsGetNT4ChangeLogInfo1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsGetNT4ChangeLogInfo1, type);
}


static PyTypeObject drsuapi_DsGetNT4ChangeLogInfo1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetNT4ChangeLogInfo1",
	.tp_getset = py_drsuapi_DsGetNT4ChangeLogInfo1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetNT4ChangeLogInfo1_new,
};

static PyObject *py_import_drsuapi_DsGetNT4ChangeLogInfo(TALLOC_CTX *mem_ctx, int level, union drsuapi_DsGetNT4ChangeLogInfo *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = pytalloc_reference_ex(&drsuapi_DsGetNT4ChangeLogInfo1_Type, mem_ctx, &in->info1);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union drsuapi_DsGetNT4ChangeLogInfo *py_export_drsuapi_DsGetNT4ChangeLogInfo(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union drsuapi_DsGetNT4ChangeLogInfo *ret = talloc_zero(mem_ctx, union drsuapi_DsGetNT4ChangeLogInfo);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsGetNT4ChangeLogInfo1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info1 = *(struct drsuapi_DsGetNT4ChangeLogInfo1 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_drsuapi_DsGetNT4ChangeLogInfo_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union drsuapi_DsGetNT4ChangeLogInfo *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union drsuapi_DsGetNT4ChangeLogInfo *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union drsuapi_DsGetNT4ChangeLogInfo!");
		return NULL;
	}

	return py_import_drsuapi_DsGetNT4ChangeLogInfo(mem_ctx, level, in);
}

static PyObject *py_drsuapi_DsGetNT4ChangeLogInfo_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union drsuapi_DsGetNT4ChangeLogInfo *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_drsuapi_DsGetNT4ChangeLogInfo(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_drsuapi_DsGetNT4ChangeLogInfo_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsGetNT4ChangeLogInfo_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsGetNT4ChangeLogInfo_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_drsuapi_DsGetNT4ChangeLogInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject drsuapi_DsGetNT4ChangeLogInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetNT4ChangeLogInfo",
	.tp_getset = NULL,
	.tp_methods = py_drsuapi_DsGetNT4ChangeLogInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetNT4ChangeLogInfo_new,
};


static PyObject *py_drsuapi_DsNameString_get_str(PyObject *obj, void *closure)
{
	struct drsuapi_DsNameString *object = pytalloc_get_ptr(obj);
	PyObject *py_str;
	if (object->str == NULL) {
		Py_RETURN_NONE;
	}
	if (object->str == NULL) {
		py_str = Py_None;
		Py_INCREF(py_str);
	} else {
		if (object->str == NULL) {
			py_str = Py_None;
			Py_INCREF(py_str);
		} else {
			py_str = PyUnicode_Decode(object->str, strlen(object->str), "utf-8", "ignore");
		}
	}
	return py_str;
}

static int py_drsuapi_DsNameString_set_str(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsNameString *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->str");
		return -1;
	}
	if (value == Py_None) {
		object->str = NULL;
	} else {
		object->str = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->str = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsNameString_getsetters[] = {
	{
		.name = discard_const_p(char, "str"),
		.get = py_drsuapi_DsNameString_get_str,
		.set = py_drsuapi_DsNameString_set_str,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsNameString_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsNameString, type);
}


static PyTypeObject drsuapi_DsNameString_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsNameString",
	.tp_getset = py_drsuapi_DsNameString_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsNameString_new,
};


static PyObject *py_drsuapi_DsNameRequest1_get_codepage(PyObject *obj, void *closure)
{
	struct drsuapi_DsNameRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_codepage;
	py_codepage = PyLong_FromUnsignedLongLong((uint32_t)(object->codepage));
	return py_codepage;
}

static int py_drsuapi_DsNameRequest1_set_codepage(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsNameRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->codepage");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->codepage));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->codepage = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsNameRequest1_get_language(PyObject *obj, void *closure)
{
	struct drsuapi_DsNameRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_language;
	py_language = PyLong_FromUnsignedLongLong((uint32_t)(object->language));
	return py_language;
}

static int py_drsuapi_DsNameRequest1_set_language(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsNameRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->language");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->language));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->language = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsNameRequest1_get_format_flags(PyObject *obj, void *closure)
{
	struct drsuapi_DsNameRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_format_flags;
	py_format_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->format_flags));
	return py_format_flags;
}

static int py_drsuapi_DsNameRequest1_set_format_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsNameRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->format_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->format_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->format_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsNameRequest1_get_format_offered(PyObject *obj, void *closure)
{
	struct drsuapi_DsNameRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_format_offered;
	py_format_offered = PyLong_FromUnsignedLongLong((uint32_t)(object->format_offered));
	return py_format_offered;
}

static int py_drsuapi_DsNameRequest1_set_format_offered(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsNameRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->format_offered");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->format_offered));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->format_offered = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsNameRequest1_get_format_desired(PyObject *obj, void *closure)
{
	struct drsuapi_DsNameRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_format_desired;
	py_format_desired = PyLong_FromUnsignedLongLong((uint32_t)(object->format_desired));
	return py_format_desired;
}

static int py_drsuapi_DsNameRequest1_set_format_desired(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsNameRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->format_desired");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->format_desired));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->format_desired = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsNameRequest1_get_count(PyObject *obj, void *closure)
{
	struct drsuapi_DsNameRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_drsuapi_DsNameRequest1_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsNameRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsNameRequest1_get_names(PyObject *obj, void *closure)
{
	struct drsuapi_DsNameRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_names;
	if (object->names == NULL) {
		Py_RETURN_NONE;
	}
	if (object->names == NULL) {
		py_names = Py_None;
		Py_INCREF(py_names);
	} else {
		py_names = PyList_New(object->count);
		if (py_names == NULL) {
			return NULL;
		}
		{
			int names_cntr_1;
			for (names_cntr_1 = 0; names_cntr_1 < (object->count); names_cntr_1++) {
				PyObject *py_names_1;
				py_names_1 = pytalloc_reference_ex(&drsuapi_DsNameString_Type, object->names, &(object->names)[names_cntr_1]);
				PyList_SetItem(py_names, names_cntr_1, py_names_1);
			}
		}
	}
	return py_names;
}

static int py_drsuapi_DsNameRequest1_set_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsNameRequest1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->names));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->names");
		return -1;
	}
	if (value == Py_None) {
		object->names = NULL;
	} else {
		object->names = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int names_cntr_1;
			object->names = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->names, PyList_GET_SIZE(value));
			if (!object->names) { return -1; }
			talloc_set_name_const(object->names, "ARRAY: object->names");
			for (names_cntr_1 = 0; names_cntr_1 < PyList_GET_SIZE(value); names_cntr_1++) {
				if (PyList_GET_ITEM(value, names_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->names)[names_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&drsuapi_DsNameString_Type, PyList_GET_ITEM(value, names_cntr_1), return -1;);
				if (talloc_reference(object->names, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, names_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->names)[names_cntr_1] = *(struct drsuapi_DsNameString *)pytalloc_get_ptr(PyList_GET_ITEM(value, names_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsNameRequest1_getsetters[] = {
	{
		.name = discard_const_p(char, "codepage"),
		.get = py_drsuapi_DsNameRequest1_get_codepage,
		.set = py_drsuapi_DsNameRequest1_set_codepage,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "language"),
		.get = py_drsuapi_DsNameRequest1_get_language,
		.set = py_drsuapi_DsNameRequest1_set_language,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "format_flags"),
		.get = py_drsuapi_DsNameRequest1_get_format_flags,
		.set = py_drsuapi_DsNameRequest1_set_format_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsNameFlags")
	},
	{
		.name = discard_const_p(char, "format_offered"),
		.get = py_drsuapi_DsNameRequest1_get_format_offered,
		.set = py_drsuapi_DsNameRequest1_set_format_offered,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsNameFormat")
	},
	{
		.name = discard_const_p(char, "format_desired"),
		.get = py_drsuapi_DsNameRequest1_get_format_desired,
		.set = py_drsuapi_DsNameRequest1_set_format_desired,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsNameFormat")
	},
	{
		.name = discard_const_p(char, "count"),
		.get = py_drsuapi_DsNameRequest1_get_count,
		.set = py_drsuapi_DsNameRequest1_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "names"),
		.get = py_drsuapi_DsNameRequest1_get_names,
		.set = py_drsuapi_DsNameRequest1_set_names,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsNameString")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsNameRequest1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsNameRequest1, type);
}


static PyTypeObject drsuapi_DsNameRequest1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsNameRequest1",
	.tp_getset = py_drsuapi_DsNameRequest1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsNameRequest1_new,
};

static PyObject *py_import_drsuapi_DsNameRequest(TALLOC_CTX *mem_ctx, int level, union drsuapi_DsNameRequest *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = pytalloc_reference_ex(&drsuapi_DsNameRequest1_Type, mem_ctx, &in->req1);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union drsuapi_DsNameRequest *py_export_drsuapi_DsNameRequest(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union drsuapi_DsNameRequest *ret = talloc_zero(mem_ctx, union drsuapi_DsNameRequest);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->req1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsNameRequest1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->req1 = *(struct drsuapi_DsNameRequest1 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_drsuapi_DsNameRequest_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union drsuapi_DsNameRequest *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union drsuapi_DsNameRequest *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union drsuapi_DsNameRequest!");
		return NULL;
	}

	return py_import_drsuapi_DsNameRequest(mem_ctx, level, in);
}

static PyObject *py_drsuapi_DsNameRequest_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union drsuapi_DsNameRequest *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_drsuapi_DsNameRequest(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_drsuapi_DsNameRequest_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsNameRequest_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsNameRequest_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_drsuapi_DsNameRequest_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject drsuapi_DsNameRequest_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsNameRequest",
	.tp_getset = NULL,
	.tp_methods = py_drsuapi_DsNameRequest_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsNameRequest_new,
};


static PyObject *py_drsuapi_DsNameInfo1_get_status(PyObject *obj, void *closure)
{
	struct drsuapi_DsNameInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_status;
	py_status = PyLong_FromUnsignedLongLong((uint32_t)(object->status));
	return py_status;
}

static int py_drsuapi_DsNameInfo1_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsNameInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->status");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->status));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->status = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsNameInfo1_get_dns_domain_name(PyObject *obj, void *closure)
{
	struct drsuapi_DsNameInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_dns_domain_name;
	if (object->dns_domain_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->dns_domain_name == NULL) {
		py_dns_domain_name = Py_None;
		Py_INCREF(py_dns_domain_name);
	} else {
		if (object->dns_domain_name == NULL) {
			py_dns_domain_name = Py_None;
			Py_INCREF(py_dns_domain_name);
		} else {
			py_dns_domain_name = PyUnicode_Decode(object->dns_domain_name, strlen(object->dns_domain_name), "utf-8", "ignore");
		}
	}
	return py_dns_domain_name;
}

static int py_drsuapi_DsNameInfo1_set_dns_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsNameInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dns_domain_name");
		return -1;
	}
	if (value == Py_None) {
		object->dns_domain_name = NULL;
	} else {
		object->dns_domain_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->dns_domain_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsNameInfo1_get_result_name(PyObject *obj, void *closure)
{
	struct drsuapi_DsNameInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_result_name;
	if (object->result_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->result_name == NULL) {
		py_result_name = Py_None;
		Py_INCREF(py_result_name);
	} else {
		if (object->result_name == NULL) {
			py_result_name = Py_None;
			Py_INCREF(py_result_name);
		} else {
			py_result_name = PyUnicode_Decode(object->result_name, strlen(object->result_name), "utf-8", "ignore");
		}
	}
	return py_result_name;
}

static int py_drsuapi_DsNameInfo1_set_result_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsNameInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->result_name");
		return -1;
	}
	if (value == Py_None) {
		object->result_name = NULL;
	} else {
		object->result_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->result_name = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsNameInfo1_getsetters[] = {
	{
		.name = discard_const_p(char, "status"),
		.get = py_drsuapi_DsNameInfo1_get_status,
		.set = py_drsuapi_DsNameInfo1_set_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsNameStatus")
	},
	{
		.name = discard_const_p(char, "dns_domain_name"),
		.get = py_drsuapi_DsNameInfo1_get_dns_domain_name,
		.set = py_drsuapi_DsNameInfo1_set_dns_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "result_name"),
		.get = py_drsuapi_DsNameInfo1_get_result_name,
		.set = py_drsuapi_DsNameInfo1_set_result_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsNameInfo1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsNameInfo1, type);
}


static PyTypeObject drsuapi_DsNameInfo1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsNameInfo1",
	.tp_getset = py_drsuapi_DsNameInfo1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsNameInfo1_new,
};


static PyObject *py_drsuapi_DsNameCtr1_get_count(PyObject *obj, void *closure)
{
	struct drsuapi_DsNameCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_drsuapi_DsNameCtr1_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsNameCtr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsNameCtr1_get_array(PyObject *obj, void *closure)
{
	struct drsuapi_DsNameCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&drsuapi_DsNameInfo1_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_drsuapi_DsNameCtr1_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsNameCtr1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&drsuapi_DsNameInfo1_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct drsuapi_DsNameInfo1 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsNameCtr1_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_drsuapi_DsNameCtr1_get_count,
		.set = py_drsuapi_DsNameCtr1_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_drsuapi_DsNameCtr1_get_array,
		.set = py_drsuapi_DsNameCtr1_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsNameInfo1")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsNameCtr1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsNameCtr1, type);
}


static PyTypeObject drsuapi_DsNameCtr1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsNameCtr1",
	.tp_getset = py_drsuapi_DsNameCtr1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsNameCtr1_new,
};

static PyObject *py_import_drsuapi_DsNameCtr(TALLOC_CTX *mem_ctx, int level, union drsuapi_DsNameCtr *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			if (in->ctr1 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&drsuapi_DsNameCtr1_Type, in->ctr1, in->ctr1);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union drsuapi_DsNameCtr *py_export_drsuapi_DsNameCtr(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union drsuapi_DsNameCtr *ret = talloc_zero(mem_ctx, union drsuapi_DsNameCtr);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr1");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ctr1 = NULL;
			} else {
				ret->ctr1 = NULL;
				PY_CHECK_TYPE(&drsuapi_DsNameCtr1_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ctr1 = (struct drsuapi_DsNameCtr1 *)pytalloc_get_ptr(in);
			}
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_drsuapi_DsNameCtr_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union drsuapi_DsNameCtr *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union drsuapi_DsNameCtr *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union drsuapi_DsNameCtr!");
		return NULL;
	}

	return py_import_drsuapi_DsNameCtr(mem_ctx, level, in);
}

static PyObject *py_drsuapi_DsNameCtr_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union drsuapi_DsNameCtr *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_drsuapi_DsNameCtr(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_drsuapi_DsNameCtr_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsNameCtr_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsNameCtr_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_drsuapi_DsNameCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject drsuapi_DsNameCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsNameCtr",
	.tp_getset = NULL,
	.tp_methods = py_drsuapi_DsNameCtr_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsNameCtr_new,
};


static PyObject *py_drsuapi_DsWriteAccountSpnRequest1_get_operation(PyObject *obj, void *closure)
{
	struct drsuapi_DsWriteAccountSpnRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_operation;
	py_operation = PyLong_FromUnsignedLongLong((uint32_t)(object->operation));
	return py_operation;
}

static int py_drsuapi_DsWriteAccountSpnRequest1_set_operation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsWriteAccountSpnRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->operation");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->operation));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->operation = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsWriteAccountSpnRequest1_get_unknown1(PyObject *obj, void *closure)
{
	struct drsuapi_DsWriteAccountSpnRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown1));
	return py_unknown1;
}

static int py_drsuapi_DsWriteAccountSpnRequest1_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsWriteAccountSpnRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsWriteAccountSpnRequest1_get_object_dn(PyObject *obj, void *closure)
{
	struct drsuapi_DsWriteAccountSpnRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_object_dn;
	if (object->object_dn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->object_dn == NULL) {
		py_object_dn = Py_None;
		Py_INCREF(py_object_dn);
	} else {
		if (object->object_dn == NULL) {
			py_object_dn = Py_None;
			Py_INCREF(py_object_dn);
		} else {
			py_object_dn = PyUnicode_Decode(object->object_dn, strlen(object->object_dn), "utf-8", "ignore");
		}
	}
	return py_object_dn;
}

static int py_drsuapi_DsWriteAccountSpnRequest1_set_object_dn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsWriteAccountSpnRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->object_dn");
		return -1;
	}
	if (value == Py_None) {
		object->object_dn = NULL;
	} else {
		object->object_dn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->object_dn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsWriteAccountSpnRequest1_get_count(PyObject *obj, void *closure)
{
	struct drsuapi_DsWriteAccountSpnRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_drsuapi_DsWriteAccountSpnRequest1_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsWriteAccountSpnRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsWriteAccountSpnRequest1_get_spn_names(PyObject *obj, void *closure)
{
	struct drsuapi_DsWriteAccountSpnRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_spn_names;
	if (object->spn_names == NULL) {
		Py_RETURN_NONE;
	}
	if (object->spn_names == NULL) {
		py_spn_names = Py_None;
		Py_INCREF(py_spn_names);
	} else {
		py_spn_names = PyList_New(object->count);
		if (py_spn_names == NULL) {
			return NULL;
		}
		{
			int spn_names_cntr_1;
			for (spn_names_cntr_1 = 0; spn_names_cntr_1 < (object->count); spn_names_cntr_1++) {
				PyObject *py_spn_names_1;
				py_spn_names_1 = pytalloc_reference_ex(&drsuapi_DsNameString_Type, object->spn_names, &(object->spn_names)[spn_names_cntr_1]);
				PyList_SetItem(py_spn_names, spn_names_cntr_1, py_spn_names_1);
			}
		}
	}
	return py_spn_names;
}

static int py_drsuapi_DsWriteAccountSpnRequest1_set_spn_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsWriteAccountSpnRequest1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->spn_names));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->spn_names");
		return -1;
	}
	if (value == Py_None) {
		object->spn_names = NULL;
	} else {
		object->spn_names = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int spn_names_cntr_1;
			object->spn_names = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->spn_names, PyList_GET_SIZE(value));
			if (!object->spn_names) { return -1; }
			talloc_set_name_const(object->spn_names, "ARRAY: object->spn_names");
			for (spn_names_cntr_1 = 0; spn_names_cntr_1 < PyList_GET_SIZE(value); spn_names_cntr_1++) {
				if (PyList_GET_ITEM(value, spn_names_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->spn_names)[spn_names_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&drsuapi_DsNameString_Type, PyList_GET_ITEM(value, spn_names_cntr_1), return -1;);
				if (talloc_reference(object->spn_names, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, spn_names_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->spn_names)[spn_names_cntr_1] = *(struct drsuapi_DsNameString *)pytalloc_get_ptr(PyList_GET_ITEM(value, spn_names_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsWriteAccountSpnRequest1_getsetters[] = {
	{
		.name = discard_const_p(char, "operation"),
		.get = py_drsuapi_DsWriteAccountSpnRequest1_get_operation,
		.set = py_drsuapi_DsWriteAccountSpnRequest1_set_operation,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsSpnOperation")
	},
	{
		.name = discard_const_p(char, "unknown1"),
		.get = py_drsuapi_DsWriteAccountSpnRequest1_get_unknown1,
		.set = py_drsuapi_DsWriteAccountSpnRequest1_set_unknown1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "object_dn"),
		.get = py_drsuapi_DsWriteAccountSpnRequest1_get_object_dn,
		.set = py_drsuapi_DsWriteAccountSpnRequest1_set_object_dn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "count"),
		.get = py_drsuapi_DsWriteAccountSpnRequest1_get_count,
		.set = py_drsuapi_DsWriteAccountSpnRequest1_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "spn_names"),
		.get = py_drsuapi_DsWriteAccountSpnRequest1_get_spn_names,
		.set = py_drsuapi_DsWriteAccountSpnRequest1_set_spn_names,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsNameString")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsWriteAccountSpnRequest1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsWriteAccountSpnRequest1, type);
}


static PyTypeObject drsuapi_DsWriteAccountSpnRequest1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsWriteAccountSpnRequest1",
	.tp_getset = py_drsuapi_DsWriteAccountSpnRequest1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsWriteAccountSpnRequest1_new,
};

static PyObject *py_import_drsuapi_DsWriteAccountSpnRequest(TALLOC_CTX *mem_ctx, int level, union drsuapi_DsWriteAccountSpnRequest *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = pytalloc_reference_ex(&drsuapi_DsWriteAccountSpnRequest1_Type, mem_ctx, &in->req1);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union drsuapi_DsWriteAccountSpnRequest *py_export_drsuapi_DsWriteAccountSpnRequest(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union drsuapi_DsWriteAccountSpnRequest *ret = talloc_zero(mem_ctx, union drsuapi_DsWriteAccountSpnRequest);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->req1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsWriteAccountSpnRequest1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->req1 = *(struct drsuapi_DsWriteAccountSpnRequest1 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_drsuapi_DsWriteAccountSpnRequest_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union drsuapi_DsWriteAccountSpnRequest *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union drsuapi_DsWriteAccountSpnRequest *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union drsuapi_DsWriteAccountSpnRequest!");
		return NULL;
	}

	return py_import_drsuapi_DsWriteAccountSpnRequest(mem_ctx, level, in);
}

static PyObject *py_drsuapi_DsWriteAccountSpnRequest_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union drsuapi_DsWriteAccountSpnRequest *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_drsuapi_DsWriteAccountSpnRequest(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_drsuapi_DsWriteAccountSpnRequest_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsWriteAccountSpnRequest_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsWriteAccountSpnRequest_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_drsuapi_DsWriteAccountSpnRequest_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject drsuapi_DsWriteAccountSpnRequest_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsWriteAccountSpnRequest",
	.tp_getset = NULL,
	.tp_methods = py_drsuapi_DsWriteAccountSpnRequest_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsWriteAccountSpnRequest_new,
};


static PyObject *py_drsuapi_DsWriteAccountSpnResult1_get_status(PyObject *obj, void *closure)
{
	struct drsuapi_DsWriteAccountSpnResult1 *object = pytalloc_get_ptr(obj);
	PyObject *py_status;
	py_status = PyErr_FromWERROR(object->status);
	return py_status;
}

static int py_drsuapi_DsWriteAccountSpnResult1_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsWriteAccountSpnResult1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->status");
		return -1;
	}
	object->status = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_drsuapi_DsWriteAccountSpnResult1_getsetters[] = {
	{
		.name = discard_const_p(char, "status"),
		.get = py_drsuapi_DsWriteAccountSpnResult1_get_status,
		.set = py_drsuapi_DsWriteAccountSpnResult1_set_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsWriteAccountSpnResult1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsWriteAccountSpnResult1, type);
}


static PyTypeObject drsuapi_DsWriteAccountSpnResult1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsWriteAccountSpnResult1",
	.tp_getset = py_drsuapi_DsWriteAccountSpnResult1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsWriteAccountSpnResult1_new,
};

static PyObject *py_import_drsuapi_DsWriteAccountSpnResult(TALLOC_CTX *mem_ctx, int level, union drsuapi_DsWriteAccountSpnResult *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = pytalloc_reference_ex(&drsuapi_DsWriteAccountSpnResult1_Type, mem_ctx, &in->res1);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union drsuapi_DsWriteAccountSpnResult *py_export_drsuapi_DsWriteAccountSpnResult(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union drsuapi_DsWriteAccountSpnResult *ret = talloc_zero(mem_ctx, union drsuapi_DsWriteAccountSpnResult);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->res1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsWriteAccountSpnResult1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->res1 = *(struct drsuapi_DsWriteAccountSpnResult1 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_drsuapi_DsWriteAccountSpnResult_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union drsuapi_DsWriteAccountSpnResult *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union drsuapi_DsWriteAccountSpnResult *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union drsuapi_DsWriteAccountSpnResult!");
		return NULL;
	}

	return py_import_drsuapi_DsWriteAccountSpnResult(mem_ctx, level, in);
}

static PyObject *py_drsuapi_DsWriteAccountSpnResult_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union drsuapi_DsWriteAccountSpnResult *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_drsuapi_DsWriteAccountSpnResult(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_drsuapi_DsWriteAccountSpnResult_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsWriteAccountSpnResult_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsWriteAccountSpnResult_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_drsuapi_DsWriteAccountSpnResult_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject drsuapi_DsWriteAccountSpnResult_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsWriteAccountSpnResult",
	.tp_getset = NULL,
	.tp_methods = py_drsuapi_DsWriteAccountSpnResult_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsWriteAccountSpnResult_new,
};


static PyObject *py_drsuapi_DsRemoveDSServerRequest1_get_server_dn(PyObject *obj, void *closure)
{
	struct drsuapi_DsRemoveDSServerRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_server_dn;
	if (object->server_dn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->server_dn == NULL) {
		py_server_dn = Py_None;
		Py_INCREF(py_server_dn);
	} else {
		if (object->server_dn == NULL) {
			py_server_dn = Py_None;
			Py_INCREF(py_server_dn);
		} else {
			py_server_dn = PyUnicode_Decode(object->server_dn, strlen(object->server_dn), "utf-8", "ignore");
		}
	}
	return py_server_dn;
}

static int py_drsuapi_DsRemoveDSServerRequest1_set_server_dn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsRemoveDSServerRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->server_dn");
		return -1;
	}
	if (value == Py_None) {
		object->server_dn = NULL;
	} else {
		object->server_dn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->server_dn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsRemoveDSServerRequest1_get_domain_dn(PyObject *obj, void *closure)
{
	struct drsuapi_DsRemoveDSServerRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_dn;
	if (object->domain_dn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->domain_dn == NULL) {
		py_domain_dn = Py_None;
		Py_INCREF(py_domain_dn);
	} else {
		if (object->domain_dn == NULL) {
			py_domain_dn = Py_None;
			Py_INCREF(py_domain_dn);
		} else {
			py_domain_dn = PyUnicode_Decode(object->domain_dn, strlen(object->domain_dn), "utf-8", "ignore");
		}
	}
	return py_domain_dn;
}

static int py_drsuapi_DsRemoveDSServerRequest1_set_domain_dn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsRemoveDSServerRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain_dn");
		return -1;
	}
	if (value == Py_None) {
		object->domain_dn = NULL;
	} else {
		object->domain_dn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->domain_dn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsRemoveDSServerRequest1_get_commit(PyObject *obj, void *closure)
{
	struct drsuapi_DsRemoveDSServerRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_commit;
	py_commit = PyLong_FromUnsignedLongLong((uint32_t)(object->commit));
	return py_commit;
}

static int py_drsuapi_DsRemoveDSServerRequest1_set_commit(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsRemoveDSServerRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->commit");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->commit));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->commit = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsRemoveDSServerRequest1_getsetters[] = {
	{
		.name = discard_const_p(char, "server_dn"),
		.get = py_drsuapi_DsRemoveDSServerRequest1_get_server_dn,
		.set = py_drsuapi_DsRemoveDSServerRequest1_set_server_dn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "domain_dn"),
		.get = py_drsuapi_DsRemoveDSServerRequest1_get_domain_dn,
		.set = py_drsuapi_DsRemoveDSServerRequest1_set_domain_dn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "commit"),
		.get = py_drsuapi_DsRemoveDSServerRequest1_get_commit,
		.set = py_drsuapi_DsRemoveDSServerRequest1_set_commit,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsRemoveDSServerRequest1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsRemoveDSServerRequest1, type);
}


static PyTypeObject drsuapi_DsRemoveDSServerRequest1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsRemoveDSServerRequest1",
	.tp_getset = py_drsuapi_DsRemoveDSServerRequest1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsRemoveDSServerRequest1_new,
};

static PyObject *py_import_drsuapi_DsRemoveDSServerRequest(TALLOC_CTX *mem_ctx, int level, union drsuapi_DsRemoveDSServerRequest *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = pytalloc_reference_ex(&drsuapi_DsRemoveDSServerRequest1_Type, mem_ctx, &in->req1);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union drsuapi_DsRemoveDSServerRequest *py_export_drsuapi_DsRemoveDSServerRequest(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union drsuapi_DsRemoveDSServerRequest *ret = talloc_zero(mem_ctx, union drsuapi_DsRemoveDSServerRequest);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->req1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsRemoveDSServerRequest1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->req1 = *(struct drsuapi_DsRemoveDSServerRequest1 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_drsuapi_DsRemoveDSServerRequest_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union drsuapi_DsRemoveDSServerRequest *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union drsuapi_DsRemoveDSServerRequest *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union drsuapi_DsRemoveDSServerRequest!");
		return NULL;
	}

	return py_import_drsuapi_DsRemoveDSServerRequest(mem_ctx, level, in);
}

static PyObject *py_drsuapi_DsRemoveDSServerRequest_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union drsuapi_DsRemoveDSServerRequest *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_drsuapi_DsRemoveDSServerRequest(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_drsuapi_DsRemoveDSServerRequest_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsRemoveDSServerRequest_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsRemoveDSServerRequest_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_drsuapi_DsRemoveDSServerRequest_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject drsuapi_DsRemoveDSServerRequest_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsRemoveDSServerRequest",
	.tp_getset = NULL,
	.tp_methods = py_drsuapi_DsRemoveDSServerRequest_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsRemoveDSServerRequest_new,
};


static PyObject *py_drsuapi_DsRemoveDSServerResult1_get_last_dc_in_domain(PyObject *obj, void *closure)
{
	struct drsuapi_DsRemoveDSServerResult1 *object = pytalloc_get_ptr(obj);
	PyObject *py_last_dc_in_domain;
	py_last_dc_in_domain = PyLong_FromUnsignedLongLong((uint32_t)(object->last_dc_in_domain));
	return py_last_dc_in_domain;
}

static int py_drsuapi_DsRemoveDSServerResult1_set_last_dc_in_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsRemoveDSServerResult1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->last_dc_in_domain");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->last_dc_in_domain));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->last_dc_in_domain = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsRemoveDSServerResult1_getsetters[] = {
	{
		.name = discard_const_p(char, "last_dc_in_domain"),
		.get = py_drsuapi_DsRemoveDSServerResult1_get_last_dc_in_domain,
		.set = py_drsuapi_DsRemoveDSServerResult1_set_last_dc_in_domain,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsRemoveDSServerResult1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsRemoveDSServerResult1, type);
}


static PyTypeObject drsuapi_DsRemoveDSServerResult1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsRemoveDSServerResult1",
	.tp_getset = py_drsuapi_DsRemoveDSServerResult1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsRemoveDSServerResult1_new,
};

static PyObject *py_import_drsuapi_DsRemoveDSServerResult(TALLOC_CTX *mem_ctx, int level, union drsuapi_DsRemoveDSServerResult *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = pytalloc_reference_ex(&drsuapi_DsRemoveDSServerResult1_Type, mem_ctx, &in->res1);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union drsuapi_DsRemoveDSServerResult *py_export_drsuapi_DsRemoveDSServerResult(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union drsuapi_DsRemoveDSServerResult *ret = talloc_zero(mem_ctx, union drsuapi_DsRemoveDSServerResult);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->res1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsRemoveDSServerResult1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->res1 = *(struct drsuapi_DsRemoveDSServerResult1 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_drsuapi_DsRemoveDSServerResult_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union drsuapi_DsRemoveDSServerResult *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union drsuapi_DsRemoveDSServerResult *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union drsuapi_DsRemoveDSServerResult!");
		return NULL;
	}

	return py_import_drsuapi_DsRemoveDSServerResult(mem_ctx, level, in);
}

static PyObject *py_drsuapi_DsRemoveDSServerResult_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union drsuapi_DsRemoveDSServerResult *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_drsuapi_DsRemoveDSServerResult(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_drsuapi_DsRemoveDSServerResult_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsRemoveDSServerResult_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsRemoveDSServerResult_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_drsuapi_DsRemoveDSServerResult_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject drsuapi_DsRemoveDSServerResult_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsRemoveDSServerResult",
	.tp_getset = NULL,
	.tp_methods = py_drsuapi_DsRemoveDSServerResult_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsRemoveDSServerResult_new,
};


static PyObject *py_drsuapi_DsGetDCInfoRequest1_get_domain_name(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfoRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	if (object->domain_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->domain_name == NULL) {
		py_domain_name = Py_None;
		Py_INCREF(py_domain_name);
	} else {
		if (object->domain_name == NULL) {
			py_domain_name = Py_None;
			Py_INCREF(py_domain_name);
		} else {
			py_domain_name = PyUnicode_Decode(object->domain_name, strlen(object->domain_name), "utf-8", "ignore");
		}
	}
	return py_domain_name;
}

static int py_drsuapi_DsGetDCInfoRequest1_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfoRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain_name");
		return -1;
	}
	if (value == Py_None) {
		object->domain_name = NULL;
	} else {
		object->domain_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->domain_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfoRequest1_get_level(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfoRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromUnsignedLongLong((uint32_t)(object->level));
	return py_level;
}

static int py_drsuapi_DsGetDCInfoRequest1_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfoRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsGetDCInfoRequest1_getsetters[] = {
	{
		.name = discard_const_p(char, "domain_name"),
		.get = py_drsuapi_DsGetDCInfoRequest1_get_domain_name,
		.set = py_drsuapi_DsGetDCInfoRequest1_set_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "level"),
		.get = py_drsuapi_DsGetDCInfoRequest1_get_level,
		.set = py_drsuapi_DsGetDCInfoRequest1_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsGetDCInfoCtrLevels")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsGetDCInfoRequest1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsGetDCInfoRequest1, type);
}


static PyTypeObject drsuapi_DsGetDCInfoRequest1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetDCInfoRequest1",
	.tp_getset = py_drsuapi_DsGetDCInfoRequest1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetDCInfoRequest1_new,
};

static PyObject *py_import_drsuapi_DsGetDCInfoRequest(TALLOC_CTX *mem_ctx, int level, union drsuapi_DsGetDCInfoRequest *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = pytalloc_reference_ex(&drsuapi_DsGetDCInfoRequest1_Type, mem_ctx, &in->req1);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union drsuapi_DsGetDCInfoRequest *py_export_drsuapi_DsGetDCInfoRequest(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union drsuapi_DsGetDCInfoRequest *ret = talloc_zero(mem_ctx, union drsuapi_DsGetDCInfoRequest);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->req1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsGetDCInfoRequest1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->req1 = *(struct drsuapi_DsGetDCInfoRequest1 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_drsuapi_DsGetDCInfoRequest_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union drsuapi_DsGetDCInfoRequest *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union drsuapi_DsGetDCInfoRequest *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union drsuapi_DsGetDCInfoRequest!");
		return NULL;
	}

	return py_import_drsuapi_DsGetDCInfoRequest(mem_ctx, level, in);
}

static PyObject *py_drsuapi_DsGetDCInfoRequest_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union drsuapi_DsGetDCInfoRequest *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_drsuapi_DsGetDCInfoRequest(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_drsuapi_DsGetDCInfoRequest_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsGetDCInfoRequest_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsGetDCInfoRequest_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_drsuapi_DsGetDCInfoRequest_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject drsuapi_DsGetDCInfoRequest_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetDCInfoRequest",
	.tp_getset = NULL,
	.tp_methods = py_drsuapi_DsGetDCInfoRequest_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetDCInfoRequest_new,
};


static PyObject *py_drsuapi_DsGetDCInfo1_get_netbios_name(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_netbios_name;
	if (object->netbios_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->netbios_name == NULL) {
		py_netbios_name = Py_None;
		Py_INCREF(py_netbios_name);
	} else {
		if (object->netbios_name == NULL) {
			py_netbios_name = Py_None;
			Py_INCREF(py_netbios_name);
		} else {
			py_netbios_name = PyUnicode_Decode(object->netbios_name, strlen(object->netbios_name), "utf-8", "ignore");
		}
	}
	return py_netbios_name;
}

static int py_drsuapi_DsGetDCInfo1_set_netbios_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->netbios_name");
		return -1;
	}
	if (value == Py_None) {
		object->netbios_name = NULL;
	} else {
		object->netbios_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->netbios_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfo1_get_dns_name(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_dns_name;
	if (object->dns_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->dns_name == NULL) {
		py_dns_name = Py_None;
		Py_INCREF(py_dns_name);
	} else {
		if (object->dns_name == NULL) {
			py_dns_name = Py_None;
			Py_INCREF(py_dns_name);
		} else {
			py_dns_name = PyUnicode_Decode(object->dns_name, strlen(object->dns_name), "utf-8", "ignore");
		}
	}
	return py_dns_name;
}

static int py_drsuapi_DsGetDCInfo1_set_dns_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dns_name");
		return -1;
	}
	if (value == Py_None) {
		object->dns_name = NULL;
	} else {
		object->dns_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->dns_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfo1_get_site_name(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_site_name;
	if (object->site_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->site_name == NULL) {
		py_site_name = Py_None;
		Py_INCREF(py_site_name);
	} else {
		if (object->site_name == NULL) {
			py_site_name = Py_None;
			Py_INCREF(py_site_name);
		} else {
			py_site_name = PyUnicode_Decode(object->site_name, strlen(object->site_name), "utf-8", "ignore");
		}
	}
	return py_site_name;
}

static int py_drsuapi_DsGetDCInfo1_set_site_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->site_name");
		return -1;
	}
	if (value == Py_None) {
		object->site_name = NULL;
	} else {
		object->site_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->site_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfo1_get_computer_dn(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_computer_dn;
	if (object->computer_dn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->computer_dn == NULL) {
		py_computer_dn = Py_None;
		Py_INCREF(py_computer_dn);
	} else {
		if (object->computer_dn == NULL) {
			py_computer_dn = Py_None;
			Py_INCREF(py_computer_dn);
		} else {
			py_computer_dn = PyUnicode_Decode(object->computer_dn, strlen(object->computer_dn), "utf-8", "ignore");
		}
	}
	return py_computer_dn;
}

static int py_drsuapi_DsGetDCInfo1_set_computer_dn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->computer_dn");
		return -1;
	}
	if (value == Py_None) {
		object->computer_dn = NULL;
	} else {
		object->computer_dn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->computer_dn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfo1_get_server_dn(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_server_dn;
	if (object->server_dn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->server_dn == NULL) {
		py_server_dn = Py_None;
		Py_INCREF(py_server_dn);
	} else {
		if (object->server_dn == NULL) {
			py_server_dn = Py_None;
			Py_INCREF(py_server_dn);
		} else {
			py_server_dn = PyUnicode_Decode(object->server_dn, strlen(object->server_dn), "utf-8", "ignore");
		}
	}
	return py_server_dn;
}

static int py_drsuapi_DsGetDCInfo1_set_server_dn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->server_dn");
		return -1;
	}
	if (value == Py_None) {
		object->server_dn = NULL;
	} else {
		object->server_dn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->server_dn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfo1_get_is_pdc(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_is_pdc;
	py_is_pdc = PyLong_FromUnsignedLongLong((uint32_t)(object->is_pdc));
	return py_is_pdc;
}

static int py_drsuapi_DsGetDCInfo1_set_is_pdc(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->is_pdc");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->is_pdc));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->is_pdc = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfo1_get_is_enabled(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_is_enabled;
	py_is_enabled = PyLong_FromUnsignedLongLong((uint32_t)(object->is_enabled));
	return py_is_enabled;
}

static int py_drsuapi_DsGetDCInfo1_set_is_enabled(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->is_enabled");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->is_enabled));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->is_enabled = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsGetDCInfo1_getsetters[] = {
	{
		.name = discard_const_p(char, "netbios_name"),
		.get = py_drsuapi_DsGetDCInfo1_get_netbios_name,
		.set = py_drsuapi_DsGetDCInfo1_set_netbios_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "dns_name"),
		.get = py_drsuapi_DsGetDCInfo1_get_dns_name,
		.set = py_drsuapi_DsGetDCInfo1_set_dns_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "site_name"),
		.get = py_drsuapi_DsGetDCInfo1_get_site_name,
		.set = py_drsuapi_DsGetDCInfo1_set_site_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "computer_dn"),
		.get = py_drsuapi_DsGetDCInfo1_get_computer_dn,
		.set = py_drsuapi_DsGetDCInfo1_set_computer_dn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "server_dn"),
		.get = py_drsuapi_DsGetDCInfo1_get_server_dn,
		.set = py_drsuapi_DsGetDCInfo1_set_server_dn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "is_pdc"),
		.get = py_drsuapi_DsGetDCInfo1_get_is_pdc,
		.set = py_drsuapi_DsGetDCInfo1_set_is_pdc,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "is_enabled"),
		.get = py_drsuapi_DsGetDCInfo1_get_is_enabled,
		.set = py_drsuapi_DsGetDCInfo1_set_is_enabled,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsGetDCInfo1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsGetDCInfo1, type);
}


static PyTypeObject drsuapi_DsGetDCInfo1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetDCInfo1",
	.tp_getset = py_drsuapi_DsGetDCInfo1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetDCInfo1_new,
};


static PyObject *py_drsuapi_DsGetDCInfoCtr1_get_count(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfoCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_drsuapi_DsGetDCInfoCtr1_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfoCtr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfoCtr1_get_array(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfoCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&drsuapi_DsGetDCInfo1_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_drsuapi_DsGetDCInfoCtr1_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfoCtr1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&drsuapi_DsGetDCInfo1_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct drsuapi_DsGetDCInfo1 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsGetDCInfoCtr1_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_drsuapi_DsGetDCInfoCtr1_get_count,
		.set = py_drsuapi_DsGetDCInfoCtr1_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_drsuapi_DsGetDCInfoCtr1_get_array,
		.set = py_drsuapi_DsGetDCInfoCtr1_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsGetDCInfo1")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsGetDCInfoCtr1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsGetDCInfoCtr1, type);
}


static PyTypeObject drsuapi_DsGetDCInfoCtr1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetDCInfoCtr1",
	.tp_getset = py_drsuapi_DsGetDCInfoCtr1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetDCInfoCtr1_new,
};


static PyObject *py_drsuapi_DsGetDCInfo2_get_netbios_name(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_netbios_name;
	if (object->netbios_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->netbios_name == NULL) {
		py_netbios_name = Py_None;
		Py_INCREF(py_netbios_name);
	} else {
		if (object->netbios_name == NULL) {
			py_netbios_name = Py_None;
			Py_INCREF(py_netbios_name);
		} else {
			py_netbios_name = PyUnicode_Decode(object->netbios_name, strlen(object->netbios_name), "utf-8", "ignore");
		}
	}
	return py_netbios_name;
}

static int py_drsuapi_DsGetDCInfo2_set_netbios_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->netbios_name");
		return -1;
	}
	if (value == Py_None) {
		object->netbios_name = NULL;
	} else {
		object->netbios_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->netbios_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfo2_get_dns_name(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_dns_name;
	if (object->dns_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->dns_name == NULL) {
		py_dns_name = Py_None;
		Py_INCREF(py_dns_name);
	} else {
		if (object->dns_name == NULL) {
			py_dns_name = Py_None;
			Py_INCREF(py_dns_name);
		} else {
			py_dns_name = PyUnicode_Decode(object->dns_name, strlen(object->dns_name), "utf-8", "ignore");
		}
	}
	return py_dns_name;
}

static int py_drsuapi_DsGetDCInfo2_set_dns_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dns_name");
		return -1;
	}
	if (value == Py_None) {
		object->dns_name = NULL;
	} else {
		object->dns_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->dns_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfo2_get_site_name(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_site_name;
	if (object->site_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->site_name == NULL) {
		py_site_name = Py_None;
		Py_INCREF(py_site_name);
	} else {
		if (object->site_name == NULL) {
			py_site_name = Py_None;
			Py_INCREF(py_site_name);
		} else {
			py_site_name = PyUnicode_Decode(object->site_name, strlen(object->site_name), "utf-8", "ignore");
		}
	}
	return py_site_name;
}

static int py_drsuapi_DsGetDCInfo2_set_site_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->site_name");
		return -1;
	}
	if (value == Py_None) {
		object->site_name = NULL;
	} else {
		object->site_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->site_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfo2_get_site_dn(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_site_dn;
	if (object->site_dn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->site_dn == NULL) {
		py_site_dn = Py_None;
		Py_INCREF(py_site_dn);
	} else {
		if (object->site_dn == NULL) {
			py_site_dn = Py_None;
			Py_INCREF(py_site_dn);
		} else {
			py_site_dn = PyUnicode_Decode(object->site_dn, strlen(object->site_dn), "utf-8", "ignore");
		}
	}
	return py_site_dn;
}

static int py_drsuapi_DsGetDCInfo2_set_site_dn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->site_dn");
		return -1;
	}
	if (value == Py_None) {
		object->site_dn = NULL;
	} else {
		object->site_dn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->site_dn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfo2_get_computer_dn(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_computer_dn;
	if (object->computer_dn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->computer_dn == NULL) {
		py_computer_dn = Py_None;
		Py_INCREF(py_computer_dn);
	} else {
		if (object->computer_dn == NULL) {
			py_computer_dn = Py_None;
			Py_INCREF(py_computer_dn);
		} else {
			py_computer_dn = PyUnicode_Decode(object->computer_dn, strlen(object->computer_dn), "utf-8", "ignore");
		}
	}
	return py_computer_dn;
}

static int py_drsuapi_DsGetDCInfo2_set_computer_dn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->computer_dn");
		return -1;
	}
	if (value == Py_None) {
		object->computer_dn = NULL;
	} else {
		object->computer_dn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->computer_dn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfo2_get_server_dn(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_server_dn;
	if (object->server_dn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->server_dn == NULL) {
		py_server_dn = Py_None;
		Py_INCREF(py_server_dn);
	} else {
		if (object->server_dn == NULL) {
			py_server_dn = Py_None;
			Py_INCREF(py_server_dn);
		} else {
			py_server_dn = PyUnicode_Decode(object->server_dn, strlen(object->server_dn), "utf-8", "ignore");
		}
	}
	return py_server_dn;
}

static int py_drsuapi_DsGetDCInfo2_set_server_dn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->server_dn");
		return -1;
	}
	if (value == Py_None) {
		object->server_dn = NULL;
	} else {
		object->server_dn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->server_dn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfo2_get_ntds_dn(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_ntds_dn;
	if (object->ntds_dn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->ntds_dn == NULL) {
		py_ntds_dn = Py_None;
		Py_INCREF(py_ntds_dn);
	} else {
		if (object->ntds_dn == NULL) {
			py_ntds_dn = Py_None;
			Py_INCREF(py_ntds_dn);
		} else {
			py_ntds_dn = PyUnicode_Decode(object->ntds_dn, strlen(object->ntds_dn), "utf-8", "ignore");
		}
	}
	return py_ntds_dn;
}

static int py_drsuapi_DsGetDCInfo2_set_ntds_dn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ntds_dn");
		return -1;
	}
	if (value == Py_None) {
		object->ntds_dn = NULL;
	} else {
		object->ntds_dn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->ntds_dn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfo2_get_is_pdc(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_is_pdc;
	py_is_pdc = PyLong_FromUnsignedLongLong((uint32_t)(object->is_pdc));
	return py_is_pdc;
}

static int py_drsuapi_DsGetDCInfo2_set_is_pdc(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->is_pdc");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->is_pdc));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->is_pdc = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfo2_get_is_enabled(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_is_enabled;
	py_is_enabled = PyLong_FromUnsignedLongLong((uint32_t)(object->is_enabled));
	return py_is_enabled;
}

static int py_drsuapi_DsGetDCInfo2_set_is_enabled(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->is_enabled");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->is_enabled));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->is_enabled = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfo2_get_is_gc(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_is_gc;
	py_is_gc = PyLong_FromUnsignedLongLong((uint32_t)(object->is_gc));
	return py_is_gc;
}

static int py_drsuapi_DsGetDCInfo2_set_is_gc(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->is_gc");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->is_gc));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->is_gc = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfo2_get_site_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_site_guid;
	py_site_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->site_guid);
	return py_site_guid;
}

static int py_drsuapi_DsGetDCInfo2_set_site_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->site_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->site_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfo2_get_computer_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_computer_guid;
	py_computer_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->computer_guid);
	return py_computer_guid;
}

static int py_drsuapi_DsGetDCInfo2_set_computer_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->computer_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->computer_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfo2_get_server_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_server_guid;
	py_server_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->server_guid);
	return py_server_guid;
}

static int py_drsuapi_DsGetDCInfo2_set_server_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->server_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->server_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfo2_get_ntds_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_ntds_guid;
	py_ntds_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->ntds_guid);
	return py_ntds_guid;
}

static int py_drsuapi_DsGetDCInfo2_set_ntds_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ntds_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->ntds_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_drsuapi_DsGetDCInfo2_getsetters[] = {
	{
		.name = discard_const_p(char, "netbios_name"),
		.get = py_drsuapi_DsGetDCInfo2_get_netbios_name,
		.set = py_drsuapi_DsGetDCInfo2_set_netbios_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "dns_name"),
		.get = py_drsuapi_DsGetDCInfo2_get_dns_name,
		.set = py_drsuapi_DsGetDCInfo2_set_dns_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "site_name"),
		.get = py_drsuapi_DsGetDCInfo2_get_site_name,
		.set = py_drsuapi_DsGetDCInfo2_set_site_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "site_dn"),
		.get = py_drsuapi_DsGetDCInfo2_get_site_dn,
		.set = py_drsuapi_DsGetDCInfo2_set_site_dn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "computer_dn"),
		.get = py_drsuapi_DsGetDCInfo2_get_computer_dn,
		.set = py_drsuapi_DsGetDCInfo2_set_computer_dn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "server_dn"),
		.get = py_drsuapi_DsGetDCInfo2_get_server_dn,
		.set = py_drsuapi_DsGetDCInfo2_set_server_dn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "ntds_dn"),
		.get = py_drsuapi_DsGetDCInfo2_get_ntds_dn,
		.set = py_drsuapi_DsGetDCInfo2_set_ntds_dn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "is_pdc"),
		.get = py_drsuapi_DsGetDCInfo2_get_is_pdc,
		.set = py_drsuapi_DsGetDCInfo2_set_is_pdc,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "is_enabled"),
		.get = py_drsuapi_DsGetDCInfo2_get_is_enabled,
		.set = py_drsuapi_DsGetDCInfo2_set_is_enabled,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "is_gc"),
		.get = py_drsuapi_DsGetDCInfo2_get_is_gc,
		.set = py_drsuapi_DsGetDCInfo2_set_is_gc,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "site_guid"),
		.get = py_drsuapi_DsGetDCInfo2_get_site_guid,
		.set = py_drsuapi_DsGetDCInfo2_set_site_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "computer_guid"),
		.get = py_drsuapi_DsGetDCInfo2_get_computer_guid,
		.set = py_drsuapi_DsGetDCInfo2_set_computer_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "server_guid"),
		.get = py_drsuapi_DsGetDCInfo2_get_server_guid,
		.set = py_drsuapi_DsGetDCInfo2_set_server_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "ntds_guid"),
		.get = py_drsuapi_DsGetDCInfo2_get_ntds_guid,
		.set = py_drsuapi_DsGetDCInfo2_set_ntds_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsGetDCInfo2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsGetDCInfo2, type);
}


static PyTypeObject drsuapi_DsGetDCInfo2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetDCInfo2",
	.tp_getset = py_drsuapi_DsGetDCInfo2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetDCInfo2_new,
};


static PyObject *py_drsuapi_DsGetDCInfoCtr2_get_count(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfoCtr2 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_drsuapi_DsGetDCInfoCtr2_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfoCtr2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfoCtr2_get_array(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfoCtr2 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&drsuapi_DsGetDCInfo2_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_drsuapi_DsGetDCInfoCtr2_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfoCtr2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&drsuapi_DsGetDCInfo2_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct drsuapi_DsGetDCInfo2 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsGetDCInfoCtr2_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_drsuapi_DsGetDCInfoCtr2_get_count,
		.set = py_drsuapi_DsGetDCInfoCtr2_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_drsuapi_DsGetDCInfoCtr2_get_array,
		.set = py_drsuapi_DsGetDCInfoCtr2_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsGetDCInfo2")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsGetDCInfoCtr2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsGetDCInfoCtr2, type);
}


static PyTypeObject drsuapi_DsGetDCInfoCtr2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetDCInfoCtr2",
	.tp_getset = py_drsuapi_DsGetDCInfoCtr2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetDCInfoCtr2_new,
};


static PyObject *py_drsuapi_DsGetDCInfo3_get_netbios_name(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_netbios_name;
	if (object->netbios_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->netbios_name == NULL) {
		py_netbios_name = Py_None;
		Py_INCREF(py_netbios_name);
	} else {
		if (object->netbios_name == NULL) {
			py_netbios_name = Py_None;
			Py_INCREF(py_netbios_name);
		} else {
			py_netbios_name = PyUnicode_Decode(object->netbios_name, strlen(object->netbios_name), "utf-8", "ignore");
		}
	}
	return py_netbios_name;
}

static int py_drsuapi_DsGetDCInfo3_set_netbios_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->netbios_name");
		return -1;
	}
	if (value == Py_None) {
		object->netbios_name = NULL;
	} else {
		object->netbios_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->netbios_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfo3_get_dns_name(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_dns_name;
	if (object->dns_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->dns_name == NULL) {
		py_dns_name = Py_None;
		Py_INCREF(py_dns_name);
	} else {
		if (object->dns_name == NULL) {
			py_dns_name = Py_None;
			Py_INCREF(py_dns_name);
		} else {
			py_dns_name = PyUnicode_Decode(object->dns_name, strlen(object->dns_name), "utf-8", "ignore");
		}
	}
	return py_dns_name;
}

static int py_drsuapi_DsGetDCInfo3_set_dns_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dns_name");
		return -1;
	}
	if (value == Py_None) {
		object->dns_name = NULL;
	} else {
		object->dns_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->dns_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfo3_get_site_name(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_site_name;
	if (object->site_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->site_name == NULL) {
		py_site_name = Py_None;
		Py_INCREF(py_site_name);
	} else {
		if (object->site_name == NULL) {
			py_site_name = Py_None;
			Py_INCREF(py_site_name);
		} else {
			py_site_name = PyUnicode_Decode(object->site_name, strlen(object->site_name), "utf-8", "ignore");
		}
	}
	return py_site_name;
}

static int py_drsuapi_DsGetDCInfo3_set_site_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->site_name");
		return -1;
	}
	if (value == Py_None) {
		object->site_name = NULL;
	} else {
		object->site_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->site_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfo3_get_site_dn(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_site_dn;
	if (object->site_dn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->site_dn == NULL) {
		py_site_dn = Py_None;
		Py_INCREF(py_site_dn);
	} else {
		if (object->site_dn == NULL) {
			py_site_dn = Py_None;
			Py_INCREF(py_site_dn);
		} else {
			py_site_dn = PyUnicode_Decode(object->site_dn, strlen(object->site_dn), "utf-8", "ignore");
		}
	}
	return py_site_dn;
}

static int py_drsuapi_DsGetDCInfo3_set_site_dn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->site_dn");
		return -1;
	}
	if (value == Py_None) {
		object->site_dn = NULL;
	} else {
		object->site_dn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->site_dn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfo3_get_computer_dn(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_computer_dn;
	if (object->computer_dn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->computer_dn == NULL) {
		py_computer_dn = Py_None;
		Py_INCREF(py_computer_dn);
	} else {
		if (object->computer_dn == NULL) {
			py_computer_dn = Py_None;
			Py_INCREF(py_computer_dn);
		} else {
			py_computer_dn = PyUnicode_Decode(object->computer_dn, strlen(object->computer_dn), "utf-8", "ignore");
		}
	}
	return py_computer_dn;
}

static int py_drsuapi_DsGetDCInfo3_set_computer_dn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->computer_dn");
		return -1;
	}
	if (value == Py_None) {
		object->computer_dn = NULL;
	} else {
		object->computer_dn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->computer_dn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfo3_get_server_dn(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_server_dn;
	if (object->server_dn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->server_dn == NULL) {
		py_server_dn = Py_None;
		Py_INCREF(py_server_dn);
	} else {
		if (object->server_dn == NULL) {
			py_server_dn = Py_None;
			Py_INCREF(py_server_dn);
		} else {
			py_server_dn = PyUnicode_Decode(object->server_dn, strlen(object->server_dn), "utf-8", "ignore");
		}
	}
	return py_server_dn;
}

static int py_drsuapi_DsGetDCInfo3_set_server_dn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->server_dn");
		return -1;
	}
	if (value == Py_None) {
		object->server_dn = NULL;
	} else {
		object->server_dn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->server_dn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfo3_get_ntds_dn(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_ntds_dn;
	if (object->ntds_dn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->ntds_dn == NULL) {
		py_ntds_dn = Py_None;
		Py_INCREF(py_ntds_dn);
	} else {
		if (object->ntds_dn == NULL) {
			py_ntds_dn = Py_None;
			Py_INCREF(py_ntds_dn);
		} else {
			py_ntds_dn = PyUnicode_Decode(object->ntds_dn, strlen(object->ntds_dn), "utf-8", "ignore");
		}
	}
	return py_ntds_dn;
}

static int py_drsuapi_DsGetDCInfo3_set_ntds_dn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ntds_dn");
		return -1;
	}
	if (value == Py_None) {
		object->ntds_dn = NULL;
	} else {
		object->ntds_dn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->ntds_dn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfo3_get_is_pdc(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_is_pdc;
	py_is_pdc = PyLong_FromUnsignedLongLong((uint32_t)(object->is_pdc));
	return py_is_pdc;
}

static int py_drsuapi_DsGetDCInfo3_set_is_pdc(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->is_pdc");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->is_pdc));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->is_pdc = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfo3_get_is_enabled(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_is_enabled;
	py_is_enabled = PyLong_FromUnsignedLongLong((uint32_t)(object->is_enabled));
	return py_is_enabled;
}

static int py_drsuapi_DsGetDCInfo3_set_is_enabled(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->is_enabled");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->is_enabled));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->is_enabled = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfo3_get_is_gc(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_is_gc;
	py_is_gc = PyLong_FromUnsignedLongLong((uint32_t)(object->is_gc));
	return py_is_gc;
}

static int py_drsuapi_DsGetDCInfo3_set_is_gc(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->is_gc");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->is_gc));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->is_gc = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfo3_get_is_rodc(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_is_rodc;
	py_is_rodc = PyLong_FromUnsignedLongLong((uint32_t)(object->is_rodc));
	return py_is_rodc;
}

static int py_drsuapi_DsGetDCInfo3_set_is_rodc(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->is_rodc");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->is_rodc));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->is_rodc = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfo3_get_site_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_site_guid;
	py_site_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->site_guid);
	return py_site_guid;
}

static int py_drsuapi_DsGetDCInfo3_set_site_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->site_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->site_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfo3_get_computer_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_computer_guid;
	py_computer_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->computer_guid);
	return py_computer_guid;
}

static int py_drsuapi_DsGetDCInfo3_set_computer_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->computer_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->computer_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfo3_get_server_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_server_guid;
	py_server_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->server_guid);
	return py_server_guid;
}

static int py_drsuapi_DsGetDCInfo3_set_server_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->server_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->server_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfo3_get_ntds_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_ntds_guid;
	py_ntds_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->ntds_guid);
	return py_ntds_guid;
}

static int py_drsuapi_DsGetDCInfo3_set_ntds_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ntds_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->ntds_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_drsuapi_DsGetDCInfo3_getsetters[] = {
	{
		.name = discard_const_p(char, "netbios_name"),
		.get = py_drsuapi_DsGetDCInfo3_get_netbios_name,
		.set = py_drsuapi_DsGetDCInfo3_set_netbios_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "dns_name"),
		.get = py_drsuapi_DsGetDCInfo3_get_dns_name,
		.set = py_drsuapi_DsGetDCInfo3_set_dns_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "site_name"),
		.get = py_drsuapi_DsGetDCInfo3_get_site_name,
		.set = py_drsuapi_DsGetDCInfo3_set_site_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "site_dn"),
		.get = py_drsuapi_DsGetDCInfo3_get_site_dn,
		.set = py_drsuapi_DsGetDCInfo3_set_site_dn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "computer_dn"),
		.get = py_drsuapi_DsGetDCInfo3_get_computer_dn,
		.set = py_drsuapi_DsGetDCInfo3_set_computer_dn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "server_dn"),
		.get = py_drsuapi_DsGetDCInfo3_get_server_dn,
		.set = py_drsuapi_DsGetDCInfo3_set_server_dn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "ntds_dn"),
		.get = py_drsuapi_DsGetDCInfo3_get_ntds_dn,
		.set = py_drsuapi_DsGetDCInfo3_set_ntds_dn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "is_pdc"),
		.get = py_drsuapi_DsGetDCInfo3_get_is_pdc,
		.set = py_drsuapi_DsGetDCInfo3_set_is_pdc,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "is_enabled"),
		.get = py_drsuapi_DsGetDCInfo3_get_is_enabled,
		.set = py_drsuapi_DsGetDCInfo3_set_is_enabled,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "is_gc"),
		.get = py_drsuapi_DsGetDCInfo3_get_is_gc,
		.set = py_drsuapi_DsGetDCInfo3_set_is_gc,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "is_rodc"),
		.get = py_drsuapi_DsGetDCInfo3_get_is_rodc,
		.set = py_drsuapi_DsGetDCInfo3_set_is_rodc,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "site_guid"),
		.get = py_drsuapi_DsGetDCInfo3_get_site_guid,
		.set = py_drsuapi_DsGetDCInfo3_set_site_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "computer_guid"),
		.get = py_drsuapi_DsGetDCInfo3_get_computer_guid,
		.set = py_drsuapi_DsGetDCInfo3_set_computer_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "server_guid"),
		.get = py_drsuapi_DsGetDCInfo3_get_server_guid,
		.set = py_drsuapi_DsGetDCInfo3_set_server_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "ntds_guid"),
		.get = py_drsuapi_DsGetDCInfo3_get_ntds_guid,
		.set = py_drsuapi_DsGetDCInfo3_set_ntds_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsGetDCInfo3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsGetDCInfo3, type);
}


static PyTypeObject drsuapi_DsGetDCInfo3_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetDCInfo3",
	.tp_getset = py_drsuapi_DsGetDCInfo3_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetDCInfo3_new,
};


static PyObject *py_drsuapi_DsGetDCInfoCtr3_get_count(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfoCtr3 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_drsuapi_DsGetDCInfoCtr3_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfoCtr3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCInfoCtr3_get_array(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCInfoCtr3 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&drsuapi_DsGetDCInfo3_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_drsuapi_DsGetDCInfoCtr3_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCInfoCtr3 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&drsuapi_DsGetDCInfo3_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct drsuapi_DsGetDCInfo3 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsGetDCInfoCtr3_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_drsuapi_DsGetDCInfoCtr3_get_count,
		.set = py_drsuapi_DsGetDCInfoCtr3_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_drsuapi_DsGetDCInfoCtr3_get_array,
		.set = py_drsuapi_DsGetDCInfoCtr3_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsGetDCInfo3")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsGetDCInfoCtr3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsGetDCInfoCtr3, type);
}


static PyTypeObject drsuapi_DsGetDCInfoCtr3_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetDCInfoCtr3",
	.tp_getset = py_drsuapi_DsGetDCInfoCtr3_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetDCInfoCtr3_new,
};


static PyObject *py_drsuapi_DsGetDCConnection01_get_client_ip_address(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCConnection01 *object = pytalloc_get_ptr(obj);
	PyObject *py_client_ip_address;
	py_client_ip_address = PyString_FromStringOrNULL(object->client_ip_address);
	return py_client_ip_address;
}

static int py_drsuapi_DsGetDCConnection01_set_client_ip_address(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCConnection01 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->client_ip_address");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->client_ip_address = talloc_str;
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCConnection01_get_unknown2(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCConnection01 *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown2));
	return py_unknown2;
}

static int py_drsuapi_DsGetDCConnection01_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCConnection01 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCConnection01_get_connection_time(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCConnection01 *object = pytalloc_get_ptr(obj);
	PyObject *py_connection_time;
	py_connection_time = PyLong_FromUnsignedLongLong((uint32_t)(object->connection_time));
	return py_connection_time;
}

static int py_drsuapi_DsGetDCConnection01_set_connection_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCConnection01 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->connection_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->connection_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->connection_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCConnection01_get_unknown4(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCConnection01 *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown4));
	return py_unknown4;
}

static int py_drsuapi_DsGetDCConnection01_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCConnection01 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown4");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown4));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown4 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCConnection01_get_unknown5(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCConnection01 *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown5;
	py_unknown5 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown5));
	return py_unknown5;
}

static int py_drsuapi_DsGetDCConnection01_set_unknown5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCConnection01 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown5");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown5));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown5 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCConnection01_get_unknown6(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCConnection01 *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown6));
	return py_unknown6;
}

static int py_drsuapi_DsGetDCConnection01_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCConnection01 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown6");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown6));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown6 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCConnection01_get_client_account(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCConnection01 *object = pytalloc_get_ptr(obj);
	PyObject *py_client_account;
	if (object->client_account == NULL) {
		Py_RETURN_NONE;
	}
	if (object->client_account == NULL) {
		py_client_account = Py_None;
		Py_INCREF(py_client_account);
	} else {
		if (object->client_account == NULL) {
			py_client_account = Py_None;
			Py_INCREF(py_client_account);
		} else {
			py_client_account = PyUnicode_Decode(object->client_account, strlen(object->client_account), "utf-8", "ignore");
		}
	}
	return py_client_account;
}

static int py_drsuapi_DsGetDCConnection01_set_client_account(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCConnection01 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->client_account");
		return -1;
	}
	if (value == Py_None) {
		object->client_account = NULL;
	} else {
		object->client_account = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->client_account = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsGetDCConnection01_getsetters[] = {
	{
		.name = discard_const_p(char, "client_ip_address"),
		.get = py_drsuapi_DsGetDCConnection01_get_client_ip_address,
		.set = py_drsuapi_DsGetDCConnection01_set_client_ip_address,
		.doc = discard_const_p(char, "PIDL-generated element of base type ipv4address")
	},
	{
		.name = discard_const_p(char, "unknown2"),
		.get = py_drsuapi_DsGetDCConnection01_get_unknown2,
		.set = py_drsuapi_DsGetDCConnection01_set_unknown2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "connection_time"),
		.get = py_drsuapi_DsGetDCConnection01_get_connection_time,
		.set = py_drsuapi_DsGetDCConnection01_set_connection_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown4"),
		.get = py_drsuapi_DsGetDCConnection01_get_unknown4,
		.set = py_drsuapi_DsGetDCConnection01_set_unknown4,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown5"),
		.get = py_drsuapi_DsGetDCConnection01_get_unknown5,
		.set = py_drsuapi_DsGetDCConnection01_set_unknown5,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown6"),
		.get = py_drsuapi_DsGetDCConnection01_get_unknown6,
		.set = py_drsuapi_DsGetDCConnection01_set_unknown6,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "client_account"),
		.get = py_drsuapi_DsGetDCConnection01_get_client_account,
		.set = py_drsuapi_DsGetDCConnection01_set_client_account,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsGetDCConnection01_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsGetDCConnection01, type);
}


static PyTypeObject drsuapi_DsGetDCConnection01_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetDCConnection01",
	.tp_getset = py_drsuapi_DsGetDCConnection01_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetDCConnection01_new,
};


static PyObject *py_drsuapi_DsGetDCConnectionCtr01_get_count(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCConnectionCtr01 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_drsuapi_DsGetDCConnectionCtr01_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCConnectionCtr01 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsGetDCConnectionCtr01_get_array(PyObject *obj, void *closure)
{
	struct drsuapi_DsGetDCConnectionCtr01 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&drsuapi_DsGetDCConnection01_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_drsuapi_DsGetDCConnectionCtr01_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsGetDCConnectionCtr01 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&drsuapi_DsGetDCConnection01_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct drsuapi_DsGetDCConnection01 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsGetDCConnectionCtr01_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_drsuapi_DsGetDCConnectionCtr01_get_count,
		.set = py_drsuapi_DsGetDCConnectionCtr01_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_drsuapi_DsGetDCConnectionCtr01_get_array,
		.set = py_drsuapi_DsGetDCConnectionCtr01_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsGetDCConnection01")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsGetDCConnectionCtr01_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsGetDCConnectionCtr01, type);
}


static PyTypeObject drsuapi_DsGetDCConnectionCtr01_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetDCConnectionCtr01",
	.tp_getset = py_drsuapi_DsGetDCConnectionCtr01_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetDCConnectionCtr01_new,
};

static PyObject *py_import_drsuapi_DsGetDCInfoCtr(TALLOC_CTX *mem_ctx, int level, union drsuapi_DsGetDCInfoCtr *in)
{
	PyObject *ret;

	switch (level) {
		case DRSUAPI_DC_INFO_CTR_1:
			ret = pytalloc_reference_ex(&drsuapi_DsGetDCInfoCtr1_Type, mem_ctx, &in->ctr1);
			return ret;

		case DRSUAPI_DC_INFO_CTR_2:
			ret = pytalloc_reference_ex(&drsuapi_DsGetDCInfoCtr2_Type, mem_ctx, &in->ctr2);
			return ret;

		case DRSUAPI_DC_INFO_CTR_3:
			ret = pytalloc_reference_ex(&drsuapi_DsGetDCInfoCtr3_Type, mem_ctx, &in->ctr3);
			return ret;

		case DRSUAPI_DC_CONNECTION_CTR_01:
			ret = pytalloc_reference_ex(&drsuapi_DsGetDCConnectionCtr01_Type, mem_ctx, &in->ctr01);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union drsuapi_DsGetDCInfoCtr *py_export_drsuapi_DsGetDCInfoCtr(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union drsuapi_DsGetDCInfoCtr *ret = talloc_zero(mem_ctx, union drsuapi_DsGetDCInfoCtr);
	switch (level) {
		case DRSUAPI_DC_INFO_CTR_1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsGetDCInfoCtr1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ctr1 = *(struct drsuapi_DsGetDCInfoCtr1 *)pytalloc_get_ptr(in);
			break;

		case DRSUAPI_DC_INFO_CTR_2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr2");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsGetDCInfoCtr2_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ctr2 = *(struct drsuapi_DsGetDCInfoCtr2 *)pytalloc_get_ptr(in);
			break;

		case DRSUAPI_DC_INFO_CTR_3:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr3");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsGetDCInfoCtr3_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ctr3 = *(struct drsuapi_DsGetDCInfoCtr3 *)pytalloc_get_ptr(in);
			break;

		case DRSUAPI_DC_CONNECTION_CTR_01:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr01");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsGetDCConnectionCtr01_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ctr01 = *(struct drsuapi_DsGetDCConnectionCtr01 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_drsuapi_DsGetDCInfoCtr_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union drsuapi_DsGetDCInfoCtr *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union drsuapi_DsGetDCInfoCtr *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union drsuapi_DsGetDCInfoCtr!");
		return NULL;
	}

	return py_import_drsuapi_DsGetDCInfoCtr(mem_ctx, level, in);
}

static PyObject *py_drsuapi_DsGetDCInfoCtr_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union drsuapi_DsGetDCInfoCtr *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_drsuapi_DsGetDCInfoCtr(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_drsuapi_DsGetDCInfoCtr_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsGetDCInfoCtr_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsGetDCInfoCtr_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_drsuapi_DsGetDCInfoCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject drsuapi_DsGetDCInfoCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsGetDCInfoCtr",
	.tp_getset = NULL,
	.tp_methods = py_drsuapi_DsGetDCInfoCtr_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsGetDCInfoCtr_new,
};


static PyObject *py_drsuapi_DsReplicaObjectListItem_get_next_object(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjectListItem *object = pytalloc_get_ptr(obj);
	PyObject *py_next_object;
	if (object->next_object == NULL) {
		Py_RETURN_NONE;
	}
	if (object->next_object == NULL) {
		py_next_object = Py_None;
		Py_INCREF(py_next_object);
	} else {
		py_next_object = pytalloc_reference_ex(&drsuapi_DsReplicaObjectListItem_Type, object->next_object, object->next_object);
	}
	return py_next_object;
}

static int py_drsuapi_DsReplicaObjectListItem_set_next_object(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjectListItem *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->next_object));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->next_object");
		return -1;
	}
	if (value == Py_None) {
		object->next_object = NULL;
	} else {
		object->next_object = NULL;
		PY_CHECK_TYPE(&drsuapi_DsReplicaObjectListItem_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->next_object = (struct drsuapi_DsReplicaObjectListItem *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaObjectListItem_get_object(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjectListItem *object = pytalloc_get_ptr(obj);
	PyObject *py_object;
	py_object = pytalloc_reference_ex(&drsuapi_DsReplicaObject_Type, pytalloc_get_mem_ctx(obj), &object->object);
	return py_object;
}

static int py_drsuapi_DsReplicaObjectListItem_set_object(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjectListItem *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->object");
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsReplicaObject_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->object = *(struct drsuapi_DsReplicaObject *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaObjectListItem_getsetters[] = {
	{
		.name = discard_const_p(char, "next_object"),
		.get = py_drsuapi_DsReplicaObjectListItem_get_next_object,
		.set = py_drsuapi_DsReplicaObjectListItem_set_next_object,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObjectListItem")
	},
	{
		.name = discard_const_p(char, "object"),
		.get = py_drsuapi_DsReplicaObjectListItem_get_object,
		.set = py_drsuapi_DsReplicaObjectListItem_set_object,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObject")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaObjectListItem_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaObjectListItem, type);
}

static PyObject *py_drsuapi_DsReplicaObjectListItem_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct drsuapi_DsReplicaObjectListItem *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsReplicaObjectListItem);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_drsuapi_DsReplicaObjectListItem_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsReplicaObjectListItem *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsReplicaObjectListItem);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_DsReplicaObjectListItem);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_drsuapi_DsReplicaObjectListItem_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_DsReplicaObjectListItem *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsReplicaObjectListItem, "drsuapi_DsReplicaObjectListItem", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_DsReplicaObjectListItem, "drsuapi_DsReplicaObjectListItem", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_drsuapi_DsReplicaObjectListItem_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_drsuapi_DsReplicaObjectListItem_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaObjectListItem_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaObjectListItem_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject drsuapi_DsReplicaObjectListItem_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaObjectListItem",
	.tp_getset = py_drsuapi_DsReplicaObjectListItem_getsetters,
	.tp_methods = py_drsuapi_DsReplicaObjectListItem_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaObjectListItem_new,
};


static PyObject *py_drsuapi_DsAddEntryRequest2_get_first_object(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntryRequest2 *object = pytalloc_get_ptr(obj);
	PyObject *py_first_object;
	py_first_object = pytalloc_reference_ex(&drsuapi_DsReplicaObjectListItem_Type, pytalloc_get_mem_ctx(obj), &object->first_object);
	return py_first_object;
}

static int py_drsuapi_DsAddEntryRequest2_set_first_object(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntryRequest2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->first_object");
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsReplicaObjectListItem_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->first_object = *(struct drsuapi_DsReplicaObjectListItem *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_drsuapi_DsAddEntryRequest2_getsetters[] = {
	{
		.name = discard_const_p(char, "first_object"),
		.get = py_drsuapi_DsAddEntryRequest2_get_first_object,
		.set = py_drsuapi_DsAddEntryRequest2_set_first_object,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObjectListItem")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsAddEntryRequest2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsAddEntryRequest2, type);
}


static PyTypeObject drsuapi_DsAddEntryRequest2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsAddEntryRequest2",
	.tp_getset = py_drsuapi_DsAddEntryRequest2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsAddEntryRequest2_new,
};


static PyObject *py_drsuapi_SecBuffer_get_buf_size(PyObject *obj, void *closure)
{
	struct drsuapi_SecBuffer *object = pytalloc_get_ptr(obj);
	PyObject *py_buf_size;
	py_buf_size = PyLong_FromUnsignedLongLong((uint32_t)(object->buf_size));
	return py_buf_size;
}

static int py_drsuapi_SecBuffer_set_buf_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_SecBuffer *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->buf_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->buf_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->buf_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_SecBuffer_get_buf_type(PyObject *obj, void *closure)
{
	struct drsuapi_SecBuffer *object = pytalloc_get_ptr(obj);
	PyObject *py_buf_type;
	py_buf_type = PyLong_FromUnsignedLongLong((uint32_t)(object->buf_type));
	return py_buf_type;
}

static int py_drsuapi_SecBuffer_set_buf_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_SecBuffer *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->buf_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->buf_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->buf_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_SecBuffer_get_buffer(PyObject *obj, void *closure)
{
	struct drsuapi_SecBuffer *object = pytalloc_get_ptr(obj);
	PyObject *py_buffer;
	if (object->buffer == NULL) {
		Py_RETURN_NONE;
	}
	if (object->buffer == NULL) {
		py_buffer = Py_None;
		Py_INCREF(py_buffer);
	} else {
		py_buffer = PyList_New(object->buf_size);
		if (py_buffer == NULL) {
			return NULL;
		}
		{
			int buffer_cntr_1;
			for (buffer_cntr_1 = 0; buffer_cntr_1 < (object->buf_size); buffer_cntr_1++) {
				PyObject *py_buffer_1;
				py_buffer_1 = PyLong_FromLong((uint16_t)((object->buffer)[buffer_cntr_1]));
				PyList_SetItem(py_buffer, buffer_cntr_1, py_buffer_1);
			}
		}
	}
	return py_buffer;
}

static int py_drsuapi_SecBuffer_set_buffer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_SecBuffer *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->buffer));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->buffer");
		return -1;
	}
	if (value == Py_None) {
		object->buffer = NULL;
	} else {
		object->buffer = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int buffer_cntr_1;
			object->buffer = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->buffer, PyList_GET_SIZE(value));
			if (!object->buffer) { return -1; }
			talloc_set_name_const(object->buffer, "ARRAY: object->buffer");
			for (buffer_cntr_1 = 0; buffer_cntr_1 < PyList_GET_SIZE(value); buffer_cntr_1++) {
				if (PyList_GET_ITEM(value, buffer_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->buffer)[buffer_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->buffer)[buffer_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, buffer_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, buffer_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->buffer)[buffer_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_SecBuffer_getsetters[] = {
	{
		.name = discard_const_p(char, "buf_size"),
		.get = py_drsuapi_SecBuffer_get_buf_size,
		.set = py_drsuapi_SecBuffer_set_buf_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "buf_type"),
		.get = py_drsuapi_SecBuffer_get_buf_type,
		.set = py_drsuapi_SecBuffer_set_buf_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_SecBufferType")
	},
	{
		.name = discard_const_p(char, "buffer"),
		.get = py_drsuapi_SecBuffer_get_buffer,
		.set = py_drsuapi_SecBuffer_set_buffer,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_SecBuffer_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_SecBuffer, type);
}


static PyTypeObject drsuapi_SecBuffer_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.SecBuffer",
	.tp_getset = py_drsuapi_SecBuffer_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_SecBuffer_new,
};


static PyObject *py_drsuapi_SecBufferDesc_get_version(PyObject *obj, void *closure)
{
	struct drsuapi_SecBufferDesc *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_drsuapi_SecBufferDesc_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_SecBufferDesc *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_SecBufferDesc_get_buff_count(PyObject *obj, void *closure)
{
	struct drsuapi_SecBufferDesc *object = pytalloc_get_ptr(obj);
	PyObject *py_buff_count;
	py_buff_count = PyLong_FromUnsignedLongLong((uint32_t)(object->buff_count));
	return py_buff_count;
}

static int py_drsuapi_SecBufferDesc_set_buff_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_SecBufferDesc *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->buff_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->buff_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->buff_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_SecBufferDesc_get_buffers(PyObject *obj, void *closure)
{
	struct drsuapi_SecBufferDesc *object = pytalloc_get_ptr(obj);
	PyObject *py_buffers;
	if (object->buffers == NULL) {
		Py_RETURN_NONE;
	}
	if (object->buffers == NULL) {
		py_buffers = Py_None;
		Py_INCREF(py_buffers);
	} else {
		py_buffers = PyList_New(object->buff_count);
		if (py_buffers == NULL) {
			return NULL;
		}
		{
			int buffers_cntr_1;
			for (buffers_cntr_1 = 0; buffers_cntr_1 < (object->buff_count); buffers_cntr_1++) {
				PyObject *py_buffers_1;
				py_buffers_1 = pytalloc_reference_ex(&drsuapi_SecBuffer_Type, object->buffers, &(object->buffers)[buffers_cntr_1]);
				PyList_SetItem(py_buffers, buffers_cntr_1, py_buffers_1);
			}
		}
	}
	return py_buffers;
}

static int py_drsuapi_SecBufferDesc_set_buffers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_SecBufferDesc *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->buffers));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->buffers");
		return -1;
	}
	if (value == Py_None) {
		object->buffers = NULL;
	} else {
		object->buffers = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int buffers_cntr_1;
			object->buffers = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->buffers, PyList_GET_SIZE(value));
			if (!object->buffers) { return -1; }
			talloc_set_name_const(object->buffers, "ARRAY: object->buffers");
			for (buffers_cntr_1 = 0; buffers_cntr_1 < PyList_GET_SIZE(value); buffers_cntr_1++) {
				if (PyList_GET_ITEM(value, buffers_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->buffers)[buffers_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&drsuapi_SecBuffer_Type, PyList_GET_ITEM(value, buffers_cntr_1), return -1;);
				if (talloc_reference(object->buffers, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, buffers_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->buffers)[buffers_cntr_1] = *(struct drsuapi_SecBuffer *)pytalloc_get_ptr(PyList_GET_ITEM(value, buffers_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_SecBufferDesc_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_drsuapi_SecBufferDesc_get_version,
		.set = py_drsuapi_SecBufferDesc_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "buff_count"),
		.get = py_drsuapi_SecBufferDesc_get_buff_count,
		.set = py_drsuapi_SecBufferDesc_set_buff_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "buffers"),
		.get = py_drsuapi_SecBufferDesc_get_buffers,
		.set = py_drsuapi_SecBufferDesc_set_buffers,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_SecBuffer")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_SecBufferDesc_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_SecBufferDesc, type);
}


static PyTypeObject drsuapi_SecBufferDesc_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.SecBufferDesc",
	.tp_getset = py_drsuapi_SecBufferDesc_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_SecBufferDesc_new,
};


static PyObject *py_drsuapi_DsAddEntryRequest3_get_first_object(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntryRequest3 *object = pytalloc_get_ptr(obj);
	PyObject *py_first_object;
	py_first_object = pytalloc_reference_ex(&drsuapi_DsReplicaObjectListItem_Type, pytalloc_get_mem_ctx(obj), &object->first_object);
	return py_first_object;
}

static int py_drsuapi_DsAddEntryRequest3_set_first_object(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntryRequest3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->first_object");
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsReplicaObjectListItem_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->first_object = *(struct drsuapi_DsReplicaObjectListItem *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsAddEntryRequest3_get_client_creds(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntryRequest3 *object = pytalloc_get_ptr(obj);
	PyObject *py_client_creds;
	if (object->client_creds == NULL) {
		Py_RETURN_NONE;
	}
	if (object->client_creds == NULL) {
		py_client_creds = Py_None;
		Py_INCREF(py_client_creds);
	} else {
		py_client_creds = pytalloc_reference_ex(&drsuapi_SecBufferDesc_Type, object->client_creds, object->client_creds);
	}
	return py_client_creds;
}

static int py_drsuapi_DsAddEntryRequest3_set_client_creds(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntryRequest3 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->client_creds));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->client_creds");
		return -1;
	}
	if (value == Py_None) {
		object->client_creds = NULL;
	} else {
		object->client_creds = NULL;
		PY_CHECK_TYPE(&drsuapi_SecBufferDesc_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->client_creds = (struct drsuapi_SecBufferDesc *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsAddEntryRequest3_getsetters[] = {
	{
		.name = discard_const_p(char, "first_object"),
		.get = py_drsuapi_DsAddEntryRequest3_get_first_object,
		.set = py_drsuapi_DsAddEntryRequest3_set_first_object,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObjectListItem")
	},
	{
		.name = discard_const_p(char, "client_creds"),
		.get = py_drsuapi_DsAddEntryRequest3_get_client_creds,
		.set = py_drsuapi_DsAddEntryRequest3_set_client_creds,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_SecBufferDesc")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsAddEntryRequest3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsAddEntryRequest3, type);
}


static PyTypeObject drsuapi_DsAddEntryRequest3_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsAddEntryRequest3",
	.tp_getset = py_drsuapi_DsAddEntryRequest3_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsAddEntryRequest3_new,
};

static PyObject *py_import_drsuapi_DsAddEntryRequest(TALLOC_CTX *mem_ctx, int level, union drsuapi_DsAddEntryRequest *in)
{
	PyObject *ret;

	switch (level) {
		case 2:
			ret = pytalloc_reference_ex(&drsuapi_DsAddEntryRequest2_Type, mem_ctx, &in->req2);
			return ret;

		case 3:
			ret = pytalloc_reference_ex(&drsuapi_DsAddEntryRequest3_Type, mem_ctx, &in->req3);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union drsuapi_DsAddEntryRequest *py_export_drsuapi_DsAddEntryRequest(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union drsuapi_DsAddEntryRequest *ret = talloc_zero(mem_ctx, union drsuapi_DsAddEntryRequest);
	switch (level) {
		case 2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->req2");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsAddEntryRequest2_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->req2 = *(struct drsuapi_DsAddEntryRequest2 *)pytalloc_get_ptr(in);
			break;

		case 3:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->req3");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsAddEntryRequest3_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->req3 = *(struct drsuapi_DsAddEntryRequest3 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_drsuapi_DsAddEntryRequest_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union drsuapi_DsAddEntryRequest *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union drsuapi_DsAddEntryRequest *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union drsuapi_DsAddEntryRequest!");
		return NULL;
	}

	return py_import_drsuapi_DsAddEntryRequest(mem_ctx, level, in);
}

static PyObject *py_drsuapi_DsAddEntryRequest_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union drsuapi_DsAddEntryRequest *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_drsuapi_DsAddEntryRequest(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_drsuapi_DsAddEntryRequest_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsAddEntryRequest_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsAddEntryRequest_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_drsuapi_DsAddEntryRequest_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject drsuapi_DsAddEntryRequest_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsAddEntryRequest",
	.tp_getset = NULL,
	.tp_methods = py_drsuapi_DsAddEntryRequest_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsAddEntryRequest_new,
};


static PyObject *py_drsuapi_DsAddEntryErrorInfoX_get_dsid(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntryErrorInfoX *object = pytalloc_get_ptr(obj);
	PyObject *py_dsid;
	py_dsid = PyLong_FromUnsignedLongLong((uint32_t)(object->dsid));
	return py_dsid;
}

static int py_drsuapi_DsAddEntryErrorInfoX_set_dsid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntryErrorInfoX *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dsid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dsid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dsid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntryErrorInfoX_get_extended_err(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntryErrorInfoX *object = pytalloc_get_ptr(obj);
	PyObject *py_extended_err;
	py_extended_err = PyErr_FromWERROR(object->extended_err);
	return py_extended_err;
}

static int py_drsuapi_DsAddEntryErrorInfoX_set_extended_err(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntryErrorInfoX *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->extended_err");
		return -1;
	}
	object->extended_err = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyObject *py_drsuapi_DsAddEntryErrorInfoX_get_extended_data(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntryErrorInfoX *object = pytalloc_get_ptr(obj);
	PyObject *py_extended_data;
	py_extended_data = PyLong_FromUnsignedLongLong((uint32_t)(object->extended_data));
	return py_extended_data;
}

static int py_drsuapi_DsAddEntryErrorInfoX_set_extended_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntryErrorInfoX *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->extended_data");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->extended_data));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->extended_data = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntryErrorInfoX_get_problem(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntryErrorInfoX *object = pytalloc_get_ptr(obj);
	PyObject *py_problem;
	py_problem = PyLong_FromLong((uint16_t)(object->problem));
	return py_problem;
}

static int py_drsuapi_DsAddEntryErrorInfoX_set_problem(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntryErrorInfoX *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->problem");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->problem));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->problem = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsAddEntryErrorInfoX_getsetters[] = {
	{
		.name = discard_const_p(char, "dsid"),
		.get = py_drsuapi_DsAddEntryErrorInfoX_get_dsid,
		.set = py_drsuapi_DsAddEntryErrorInfoX_set_dsid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "extended_err"),
		.get = py_drsuapi_DsAddEntryErrorInfoX_get_extended_err,
		.set = py_drsuapi_DsAddEntryErrorInfoX_set_extended_err,
		.doc = discard_const_p(char, "PIDL-generated element of base type WERROR")
	},
	{
		.name = discard_const_p(char, "extended_data"),
		.get = py_drsuapi_DsAddEntryErrorInfoX_get_extended_data,
		.set = py_drsuapi_DsAddEntryErrorInfoX_set_extended_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "problem"),
		.get = py_drsuapi_DsAddEntryErrorInfoX_get_problem,
		.set = py_drsuapi_DsAddEntryErrorInfoX_set_problem,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsAddEntryErrorInfoX_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsAddEntryErrorInfoX, type);
}


static PyTypeObject drsuapi_DsAddEntryErrorInfoX_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsAddEntryErrorInfoX",
	.tp_getset = py_drsuapi_DsAddEntryErrorInfoX_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsAddEntryErrorInfoX_new,
};


static PyObject *py_drsuapi_DsAddEntry_AttrErr_V1_get_dsid(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntry_AttrErr_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_dsid;
	py_dsid = PyLong_FromUnsignedLongLong((uint32_t)(object->dsid));
	return py_dsid;
}

static int py_drsuapi_DsAddEntry_AttrErr_V1_set_dsid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntry_AttrErr_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dsid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dsid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dsid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntry_AttrErr_V1_get_extended_err(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntry_AttrErr_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_extended_err;
	py_extended_err = PyErr_FromWERROR(object->extended_err);
	return py_extended_err;
}

static int py_drsuapi_DsAddEntry_AttrErr_V1_set_extended_err(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntry_AttrErr_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->extended_err");
		return -1;
	}
	object->extended_err = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyObject *py_drsuapi_DsAddEntry_AttrErr_V1_get_extended_data(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntry_AttrErr_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_extended_data;
	py_extended_data = PyLong_FromUnsignedLongLong((uint32_t)(object->extended_data));
	return py_extended_data;
}

static int py_drsuapi_DsAddEntry_AttrErr_V1_set_extended_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntry_AttrErr_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->extended_data");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->extended_data));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->extended_data = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntry_AttrErr_V1_get_problem(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntry_AttrErr_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_problem;
	py_problem = PyLong_FromLong((uint16_t)(object->problem));
	return py_problem;
}

static int py_drsuapi_DsAddEntry_AttrErr_V1_set_problem(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntry_AttrErr_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->problem");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->problem));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->problem = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntry_AttrErr_V1_get_attid(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntry_AttrErr_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_attid;
	py_attid = PyLong_FromUnsignedLongLong((uint32_t)(object->attid));
	return py_attid;
}

static int py_drsuapi_DsAddEntry_AttrErr_V1_set_attid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntry_AttrErr_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->attid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->attid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->attid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntry_AttrErr_V1_get_is_val_returned(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntry_AttrErr_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_is_val_returned;
	py_is_val_returned = PyLong_FromUnsignedLongLong((uint32_t)(object->is_val_returned));
	return py_is_val_returned;
}

static int py_drsuapi_DsAddEntry_AttrErr_V1_set_is_val_returned(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntry_AttrErr_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->is_val_returned");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->is_val_returned));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->is_val_returned = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntry_AttrErr_V1_get_attr_val(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntry_AttrErr_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_attr_val;
	py_attr_val = pytalloc_reference_ex(&drsuapi_DsAttributeValue_Type, pytalloc_get_mem_ctx(obj), &object->attr_val);
	return py_attr_val;
}

static int py_drsuapi_DsAddEntry_AttrErr_V1_set_attr_val(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntry_AttrErr_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->attr_val");
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsAttributeValue_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->attr_val = *(struct drsuapi_DsAttributeValue *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_drsuapi_DsAddEntry_AttrErr_V1_getsetters[] = {
	{
		.name = discard_const_p(char, "dsid"),
		.get = py_drsuapi_DsAddEntry_AttrErr_V1_get_dsid,
		.set = py_drsuapi_DsAddEntry_AttrErr_V1_set_dsid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "extended_err"),
		.get = py_drsuapi_DsAddEntry_AttrErr_V1_get_extended_err,
		.set = py_drsuapi_DsAddEntry_AttrErr_V1_set_extended_err,
		.doc = discard_const_p(char, "PIDL-generated element of base type WERROR")
	},
	{
		.name = discard_const_p(char, "extended_data"),
		.get = py_drsuapi_DsAddEntry_AttrErr_V1_get_extended_data,
		.set = py_drsuapi_DsAddEntry_AttrErr_V1_set_extended_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "problem"),
		.get = py_drsuapi_DsAddEntry_AttrErr_V1_get_problem,
		.set = py_drsuapi_DsAddEntry_AttrErr_V1_set_problem,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "attid"),
		.get = py_drsuapi_DsAddEntry_AttrErr_V1_get_attid,
		.set = py_drsuapi_DsAddEntry_AttrErr_V1_set_attid,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsAttributeId")
	},
	{
		.name = discard_const_p(char, "is_val_returned"),
		.get = py_drsuapi_DsAddEntry_AttrErr_V1_get_is_val_returned,
		.set = py_drsuapi_DsAddEntry_AttrErr_V1_set_is_val_returned,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "attr_val"),
		.get = py_drsuapi_DsAddEntry_AttrErr_V1_get_attr_val,
		.set = py_drsuapi_DsAddEntry_AttrErr_V1_set_attr_val,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsAttributeValue")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsAddEntry_AttrErr_V1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsAddEntry_AttrErr_V1, type);
}


static PyTypeObject drsuapi_DsAddEntry_AttrErr_V1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsAddEntry_AttrErr_V1",
	.tp_getset = py_drsuapi_DsAddEntry_AttrErr_V1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsAddEntry_AttrErr_V1_new,
};


static PyObject *py_drsuapi_DsAddEntry_AttrErrListItem_V1_get_next(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntry_AttrErrListItem_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_next;
	if (object->next == NULL) {
		Py_RETURN_NONE;
	}
	if (object->next == NULL) {
		py_next = Py_None;
		Py_INCREF(py_next);
	} else {
		py_next = pytalloc_reference_ex(&drsuapi_DsAddEntry_AttrErrListItem_V1_Type, object->next, object->next);
	}
	return py_next;
}

static int py_drsuapi_DsAddEntry_AttrErrListItem_V1_set_next(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntry_AttrErrListItem_V1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->next));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->next");
		return -1;
	}
	if (value == Py_None) {
		object->next = NULL;
	} else {
		object->next = NULL;
		PY_CHECK_TYPE(&drsuapi_DsAddEntry_AttrErrListItem_V1_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->next = (struct drsuapi_DsAddEntry_AttrErrListItem_V1 *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntry_AttrErrListItem_V1_get_err_data(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntry_AttrErrListItem_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_err_data;
	py_err_data = pytalloc_reference_ex(&drsuapi_DsAddEntry_AttrErr_V1_Type, pytalloc_get_mem_ctx(obj), &object->err_data);
	return py_err_data;
}

static int py_drsuapi_DsAddEntry_AttrErrListItem_V1_set_err_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntry_AttrErrListItem_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->err_data");
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsAddEntry_AttrErr_V1_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->err_data = *(struct drsuapi_DsAddEntry_AttrErr_V1 *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_drsuapi_DsAddEntry_AttrErrListItem_V1_getsetters[] = {
	{
		.name = discard_const_p(char, "next"),
		.get = py_drsuapi_DsAddEntry_AttrErrListItem_V1_get_next,
		.set = py_drsuapi_DsAddEntry_AttrErrListItem_V1_set_next,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsAddEntry_AttrErrListItem_V1")
	},
	{
		.name = discard_const_p(char, "err_data"),
		.get = py_drsuapi_DsAddEntry_AttrErrListItem_V1_get_err_data,
		.set = py_drsuapi_DsAddEntry_AttrErrListItem_V1_set_err_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsAddEntry_AttrErr_V1")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsAddEntry_AttrErrListItem_V1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsAddEntry_AttrErrListItem_V1, type);
}


static PyTypeObject drsuapi_DsAddEntry_AttrErrListItem_V1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsAddEntry_AttrErrListItem_V1",
	.tp_getset = py_drsuapi_DsAddEntry_AttrErrListItem_V1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsAddEntry_AttrErrListItem_V1_new,
};


static PyObject *py_drsuapi_DsAddEntryErrorInfo_Attr_V1_get_id(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntryErrorInfo_Attr_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_id;
	if (object->id == NULL) {
		Py_RETURN_NONE;
	}
	if (object->id == NULL) {
		py_id = Py_None;
		Py_INCREF(py_id);
	} else {
		py_id = pytalloc_reference_ex(&drsuapi_DsReplicaObjectIdentifier_Type, object->id, object->id);
	}
	return py_id;
}

static int py_drsuapi_DsAddEntryErrorInfo_Attr_V1_set_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntryErrorInfo_Attr_V1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->id));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->id");
		return -1;
	}
	if (value == Py_None) {
		object->id = NULL;
	} else {
		object->id = NULL;
		PY_CHECK_TYPE(&drsuapi_DsReplicaObjectIdentifier_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->id = (struct drsuapi_DsReplicaObjectIdentifier *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntryErrorInfo_Attr_V1_get_count(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntryErrorInfo_Attr_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_drsuapi_DsAddEntryErrorInfo_Attr_V1_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntryErrorInfo_Attr_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntryErrorInfo_Attr_V1_get_first(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntryErrorInfo_Attr_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_first;
	py_first = pytalloc_reference_ex(&drsuapi_DsAddEntry_AttrErrListItem_V1_Type, pytalloc_get_mem_ctx(obj), &object->first);
	return py_first;
}

static int py_drsuapi_DsAddEntryErrorInfo_Attr_V1_set_first(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntryErrorInfo_Attr_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->first");
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsAddEntry_AttrErrListItem_V1_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->first = *(struct drsuapi_DsAddEntry_AttrErrListItem_V1 *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_drsuapi_DsAddEntryErrorInfo_Attr_V1_getsetters[] = {
	{
		.name = discard_const_p(char, "id"),
		.get = py_drsuapi_DsAddEntryErrorInfo_Attr_V1_get_id,
		.set = py_drsuapi_DsAddEntryErrorInfo_Attr_V1_set_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObjectIdentifier")
	},
	{
		.name = discard_const_p(char, "count"),
		.get = py_drsuapi_DsAddEntryErrorInfo_Attr_V1_get_count,
		.set = py_drsuapi_DsAddEntryErrorInfo_Attr_V1_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "first"),
		.get = py_drsuapi_DsAddEntryErrorInfo_Attr_V1_get_first,
		.set = py_drsuapi_DsAddEntryErrorInfo_Attr_V1_set_first,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsAddEntry_AttrErrListItem_V1")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsAddEntryErrorInfo_Attr_V1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsAddEntryErrorInfo_Attr_V1, type);
}


static PyTypeObject drsuapi_DsAddEntryErrorInfo_Attr_V1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsAddEntryErrorInfo_Attr_V1",
	.tp_getset = py_drsuapi_DsAddEntryErrorInfo_Attr_V1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsAddEntryErrorInfo_Attr_V1_new,
};


static PyObject *py_drsuapi_DsAddEntryErrorInfo_Name_V1_get_dsid(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntryErrorInfo_Name_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_dsid;
	py_dsid = PyLong_FromUnsignedLongLong((uint32_t)(object->dsid));
	return py_dsid;
}

static int py_drsuapi_DsAddEntryErrorInfo_Name_V1_set_dsid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntryErrorInfo_Name_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dsid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dsid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dsid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntryErrorInfo_Name_V1_get_extended_err(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntryErrorInfo_Name_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_extended_err;
	py_extended_err = PyErr_FromWERROR(object->extended_err);
	return py_extended_err;
}

static int py_drsuapi_DsAddEntryErrorInfo_Name_V1_set_extended_err(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntryErrorInfo_Name_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->extended_err");
		return -1;
	}
	object->extended_err = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyObject *py_drsuapi_DsAddEntryErrorInfo_Name_V1_get_extended_data(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntryErrorInfo_Name_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_extended_data;
	py_extended_data = PyLong_FromUnsignedLongLong((uint32_t)(object->extended_data));
	return py_extended_data;
}

static int py_drsuapi_DsAddEntryErrorInfo_Name_V1_set_extended_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntryErrorInfo_Name_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->extended_data");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->extended_data));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->extended_data = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntryErrorInfo_Name_V1_get_problem(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntryErrorInfo_Name_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_problem;
	py_problem = PyLong_FromLong((uint16_t)(object->problem));
	return py_problem;
}

static int py_drsuapi_DsAddEntryErrorInfo_Name_V1_set_problem(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntryErrorInfo_Name_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->problem");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->problem));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->problem = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntryErrorInfo_Name_V1_get_id_matched(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntryErrorInfo_Name_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_id_matched;
	if (object->id_matched == NULL) {
		Py_RETURN_NONE;
	}
	if (object->id_matched == NULL) {
		py_id_matched = Py_None;
		Py_INCREF(py_id_matched);
	} else {
		py_id_matched = pytalloc_reference_ex(&drsuapi_DsReplicaObjectIdentifier_Type, object->id_matched, object->id_matched);
	}
	return py_id_matched;
}

static int py_drsuapi_DsAddEntryErrorInfo_Name_V1_set_id_matched(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntryErrorInfo_Name_V1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->id_matched));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->id_matched");
		return -1;
	}
	if (value == Py_None) {
		object->id_matched = NULL;
	} else {
		object->id_matched = NULL;
		PY_CHECK_TYPE(&drsuapi_DsReplicaObjectIdentifier_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->id_matched = (struct drsuapi_DsReplicaObjectIdentifier *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsAddEntryErrorInfo_Name_V1_getsetters[] = {
	{
		.name = discard_const_p(char, "dsid"),
		.get = py_drsuapi_DsAddEntryErrorInfo_Name_V1_get_dsid,
		.set = py_drsuapi_DsAddEntryErrorInfo_Name_V1_set_dsid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "extended_err"),
		.get = py_drsuapi_DsAddEntryErrorInfo_Name_V1_get_extended_err,
		.set = py_drsuapi_DsAddEntryErrorInfo_Name_V1_set_extended_err,
		.doc = discard_const_p(char, "PIDL-generated element of base type WERROR")
	},
	{
		.name = discard_const_p(char, "extended_data"),
		.get = py_drsuapi_DsAddEntryErrorInfo_Name_V1_get_extended_data,
		.set = py_drsuapi_DsAddEntryErrorInfo_Name_V1_set_extended_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "problem"),
		.get = py_drsuapi_DsAddEntryErrorInfo_Name_V1_get_problem,
		.set = py_drsuapi_DsAddEntryErrorInfo_Name_V1_set_problem,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "id_matched"),
		.get = py_drsuapi_DsAddEntryErrorInfo_Name_V1_get_id_matched,
		.set = py_drsuapi_DsAddEntryErrorInfo_Name_V1_set_id_matched,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObjectIdentifier")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsAddEntryErrorInfo_Name_V1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsAddEntryErrorInfo_Name_V1, type);
}


static PyTypeObject drsuapi_DsAddEntryErrorInfo_Name_V1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsAddEntryErrorInfo_Name_V1",
	.tp_getset = py_drsuapi_DsAddEntryErrorInfo_Name_V1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsAddEntryErrorInfo_Name_V1_new,
};


static PyObject *py_drsuapi_NameResOp_V1_get_name_res(PyObject *obj, void *closure)
{
	struct drsuapi_NameResOp_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_name_res;
	py_name_res = PyLong_FromLong((uint16_t)(object->name_res));
	return py_name_res;
}

static int py_drsuapi_NameResOp_V1_set_name_res(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_NameResOp_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->name_res");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->name_res));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->name_res = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_NameResOp_V1_get_unused_pad(PyObject *obj, void *closure)
{
	struct drsuapi_NameResOp_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_unused_pad;
	py_unused_pad = PyLong_FromLong((uint16_t)(object->unused_pad));
	return py_unused_pad;
}

static int py_drsuapi_NameResOp_V1_set_unused_pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_NameResOp_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unused_pad");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unused_pad));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unused_pad = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_NameResOp_V1_get_next_rdn(PyObject *obj, void *closure)
{
	struct drsuapi_NameResOp_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_next_rdn;
	py_next_rdn = PyLong_FromLong((uint16_t)(object->next_rdn));
	return py_next_rdn;
}

static int py_drsuapi_NameResOp_V1_set_next_rdn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_NameResOp_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->next_rdn");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->next_rdn));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->next_rdn = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_NameResOp_V1_getsetters[] = {
	{
		.name = discard_const_p(char, "name_res"),
		.get = py_drsuapi_NameResOp_V1_get_name_res,
		.set = py_drsuapi_NameResOp_V1_set_name_res,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "unused_pad"),
		.get = py_drsuapi_NameResOp_V1_get_unused_pad,
		.set = py_drsuapi_NameResOp_V1_set_unused_pad,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "next_rdn"),
		.get = py_drsuapi_NameResOp_V1_get_next_rdn,
		.set = py_drsuapi_NameResOp_V1_set_next_rdn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_NameResOp_V1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_NameResOp_V1, type);
}


static PyTypeObject drsuapi_NameResOp_V1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.NameResOp_V1",
	.tp_getset = py_drsuapi_NameResOp_V1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_NameResOp_V1_new,
};


static PyObject *py_drsuapi_DsaAddressListItem_V1_get_next(PyObject *obj, void *closure)
{
	struct drsuapi_DsaAddressListItem_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_next;
	if (object->next == NULL) {
		Py_RETURN_NONE;
	}
	if (object->next == NULL) {
		py_next = Py_None;
		Py_INCREF(py_next);
	} else {
		py_next = pytalloc_reference_ex(&drsuapi_DsaAddressListItem_V1_Type, object->next, object->next);
	}
	return py_next;
}

static int py_drsuapi_DsaAddressListItem_V1_set_next(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsaAddressListItem_V1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->next));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->next");
		return -1;
	}
	if (value == Py_None) {
		object->next = NULL;
	} else {
		object->next = NULL;
		PY_CHECK_TYPE(&drsuapi_DsaAddressListItem_V1_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->next = (struct drsuapi_DsaAddressListItem_V1 *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_drsuapi_DsaAddressListItem_V1_get_address(PyObject *obj, void *closure)
{
	struct drsuapi_DsaAddressListItem_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_address;
	if (object->address == NULL) {
		Py_RETURN_NONE;
	}
	if (object->address == NULL) {
		py_address = Py_None;
		Py_INCREF(py_address);
	} else {
		py_address = pytalloc_reference_ex(lsa_String_Type, object->address, object->address);
	}
	return py_address;
}

static int py_drsuapi_DsaAddressListItem_V1_set_address(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsaAddressListItem_V1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->address));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->address");
		return -1;
	}
	if (value == Py_None) {
		object->address = NULL;
	} else {
		object->address = NULL;
		PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->address = (struct lsa_String *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsaAddressListItem_V1_getsetters[] = {
	{
		.name = discard_const_p(char, "next"),
		.get = py_drsuapi_DsaAddressListItem_V1_get_next,
		.set = py_drsuapi_DsaAddressListItem_V1_set_next,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsaAddressListItem_V1")
	},
	{
		.name = discard_const_p(char, "address"),
		.get = py_drsuapi_DsaAddressListItem_V1_get_address,
		.set = py_drsuapi_DsaAddressListItem_V1_set_address,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsaAddressListItem_V1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsaAddressListItem_V1, type);
}


static PyTypeObject drsuapi_DsaAddressListItem_V1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsaAddressListItem_V1",
	.tp_getset = py_drsuapi_DsaAddressListItem_V1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsaAddressListItem_V1_new,
};


static PyObject *py_drsuapi_DsAddEntry_RefErrListItem_V1_get_id_target(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntry_RefErrListItem_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_id_target;
	if (object->id_target == NULL) {
		Py_RETURN_NONE;
	}
	if (object->id_target == NULL) {
		py_id_target = Py_None;
		Py_INCREF(py_id_target);
	} else {
		py_id_target = pytalloc_reference_ex(&drsuapi_DsReplicaObjectIdentifier_Type, object->id_target, object->id_target);
	}
	return py_id_target;
}

static int py_drsuapi_DsAddEntry_RefErrListItem_V1_set_id_target(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntry_RefErrListItem_V1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->id_target));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->id_target");
		return -1;
	}
	if (value == Py_None) {
		object->id_target = NULL;
	} else {
		object->id_target = NULL;
		PY_CHECK_TYPE(&drsuapi_DsReplicaObjectIdentifier_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->id_target = (struct drsuapi_DsReplicaObjectIdentifier *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntry_RefErrListItem_V1_get_op_state(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntry_RefErrListItem_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_op_state;
	py_op_state = pytalloc_reference_ex(&drsuapi_NameResOp_V1_Type, pytalloc_get_mem_ctx(obj), &object->op_state);
	return py_op_state;
}

static int py_drsuapi_DsAddEntry_RefErrListItem_V1_set_op_state(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntry_RefErrListItem_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->op_state");
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_NameResOp_V1_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->op_state = *(struct drsuapi_NameResOp_V1 *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsAddEntry_RefErrListItem_V1_get_rdn_alias(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntry_RefErrListItem_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_rdn_alias;
	py_rdn_alias = PyLong_FromLong((uint16_t)(object->rdn_alias));
	return py_rdn_alias;
}

static int py_drsuapi_DsAddEntry_RefErrListItem_V1_set_rdn_alias(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntry_RefErrListItem_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rdn_alias");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->rdn_alias));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->rdn_alias = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntry_RefErrListItem_V1_get_rdn_internal(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntry_RefErrListItem_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_rdn_internal;
	py_rdn_internal = PyLong_FromLong((uint16_t)(object->rdn_internal));
	return py_rdn_internal;
}

static int py_drsuapi_DsAddEntry_RefErrListItem_V1_set_rdn_internal(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntry_RefErrListItem_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rdn_internal");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->rdn_internal));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->rdn_internal = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntry_RefErrListItem_V1_get_ref_type(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntry_RefErrListItem_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_ref_type;
	py_ref_type = PyLong_FromLong((uint16_t)(object->ref_type));
	return py_ref_type;
}

static int py_drsuapi_DsAddEntry_RefErrListItem_V1_set_ref_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntry_RefErrListItem_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ref_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ref_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ref_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntry_RefErrListItem_V1_get_addr_list_count(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntry_RefErrListItem_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_addr_list_count;
	py_addr_list_count = PyLong_FromLong((uint16_t)(object->addr_list_count));
	return py_addr_list_count;
}

static int py_drsuapi_DsAddEntry_RefErrListItem_V1_set_addr_list_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntry_RefErrListItem_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->addr_list_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->addr_list_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->addr_list_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntry_RefErrListItem_V1_get_addr_list(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntry_RefErrListItem_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_addr_list;
	if (object->addr_list == NULL) {
		Py_RETURN_NONE;
	}
	if (object->addr_list == NULL) {
		py_addr_list = Py_None;
		Py_INCREF(py_addr_list);
	} else {
		py_addr_list = pytalloc_reference_ex(&drsuapi_DsaAddressListItem_V1_Type, object->addr_list, object->addr_list);
	}
	return py_addr_list;
}

static int py_drsuapi_DsAddEntry_RefErrListItem_V1_set_addr_list(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntry_RefErrListItem_V1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->addr_list));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->addr_list");
		return -1;
	}
	if (value == Py_None) {
		object->addr_list = NULL;
	} else {
		object->addr_list = NULL;
		PY_CHECK_TYPE(&drsuapi_DsaAddressListItem_V1_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->addr_list = (struct drsuapi_DsaAddressListItem_V1 *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntry_RefErrListItem_V1_get_next(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntry_RefErrListItem_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_next;
	if (object->next == NULL) {
		Py_RETURN_NONE;
	}
	if (object->next == NULL) {
		py_next = Py_None;
		Py_INCREF(py_next);
	} else {
		py_next = pytalloc_reference_ex(&drsuapi_DsAddEntry_RefErrListItem_V1_Type, object->next, object->next);
	}
	return py_next;
}

static int py_drsuapi_DsAddEntry_RefErrListItem_V1_set_next(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntry_RefErrListItem_V1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->next));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->next");
		return -1;
	}
	if (value == Py_None) {
		object->next = NULL;
	} else {
		object->next = NULL;
		PY_CHECK_TYPE(&drsuapi_DsAddEntry_RefErrListItem_V1_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->next = (struct drsuapi_DsAddEntry_RefErrListItem_V1 *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntry_RefErrListItem_V1_get_is_choice_set(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntry_RefErrListItem_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_is_choice_set;
	py_is_choice_set = PyLong_FromUnsignedLongLong((uint32_t)(object->is_choice_set));
	return py_is_choice_set;
}

static int py_drsuapi_DsAddEntry_RefErrListItem_V1_set_is_choice_set(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntry_RefErrListItem_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->is_choice_set");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->is_choice_set));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->is_choice_set = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntry_RefErrListItem_V1_get_choice(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntry_RefErrListItem_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_choice;
	py_choice = PyLong_FromLong((uint16_t)(object->choice));
	return py_choice;
}

static int py_drsuapi_DsAddEntry_RefErrListItem_V1_set_choice(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntry_RefErrListItem_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->choice");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->choice));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->choice = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsAddEntry_RefErrListItem_V1_getsetters[] = {
	{
		.name = discard_const_p(char, "id_target"),
		.get = py_drsuapi_DsAddEntry_RefErrListItem_V1_get_id_target,
		.set = py_drsuapi_DsAddEntry_RefErrListItem_V1_set_id_target,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObjectIdentifier")
	},
	{
		.name = discard_const_p(char, "op_state"),
		.get = py_drsuapi_DsAddEntry_RefErrListItem_V1_get_op_state,
		.set = py_drsuapi_DsAddEntry_RefErrListItem_V1_set_op_state,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_NameResOp_V1")
	},
	{
		.name = discard_const_p(char, "rdn_alias"),
		.get = py_drsuapi_DsAddEntry_RefErrListItem_V1_get_rdn_alias,
		.set = py_drsuapi_DsAddEntry_RefErrListItem_V1_set_rdn_alias,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "rdn_internal"),
		.get = py_drsuapi_DsAddEntry_RefErrListItem_V1_get_rdn_internal,
		.set = py_drsuapi_DsAddEntry_RefErrListItem_V1_set_rdn_internal,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "ref_type"),
		.get = py_drsuapi_DsAddEntry_RefErrListItem_V1_get_ref_type,
		.set = py_drsuapi_DsAddEntry_RefErrListItem_V1_set_ref_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsAddEntry_RefType")
	},
	{
		.name = discard_const_p(char, "addr_list_count"),
		.get = py_drsuapi_DsAddEntry_RefErrListItem_V1_get_addr_list_count,
		.set = py_drsuapi_DsAddEntry_RefErrListItem_V1_set_addr_list_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "addr_list"),
		.get = py_drsuapi_DsAddEntry_RefErrListItem_V1_get_addr_list,
		.set = py_drsuapi_DsAddEntry_RefErrListItem_V1_set_addr_list,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsaAddressListItem_V1")
	},
	{
		.name = discard_const_p(char, "next"),
		.get = py_drsuapi_DsAddEntry_RefErrListItem_V1_get_next,
		.set = py_drsuapi_DsAddEntry_RefErrListItem_V1_set_next,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsAddEntry_RefErrListItem_V1")
	},
	{
		.name = discard_const_p(char, "is_choice_set"),
		.get = py_drsuapi_DsAddEntry_RefErrListItem_V1_get_is_choice_set,
		.set = py_drsuapi_DsAddEntry_RefErrListItem_V1_set_is_choice_set,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "choice"),
		.get = py_drsuapi_DsAddEntry_RefErrListItem_V1_get_choice,
		.set = py_drsuapi_DsAddEntry_RefErrListItem_V1_set_choice,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsAddEntry_ChoiceType")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsAddEntry_RefErrListItem_V1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsAddEntry_RefErrListItem_V1, type);
}


static PyTypeObject drsuapi_DsAddEntry_RefErrListItem_V1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsAddEntry_RefErrListItem_V1",
	.tp_getset = py_drsuapi_DsAddEntry_RefErrListItem_V1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsAddEntry_RefErrListItem_V1_new,
};


static PyObject *py_drsuapi_DsAddEntryErrorInfo_Referr_V1_get_dsid(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntryErrorInfo_Referr_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_dsid;
	py_dsid = PyLong_FromUnsignedLongLong((uint32_t)(object->dsid));
	return py_dsid;
}

static int py_drsuapi_DsAddEntryErrorInfo_Referr_V1_set_dsid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntryErrorInfo_Referr_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dsid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dsid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dsid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntryErrorInfo_Referr_V1_get_extended_err(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntryErrorInfo_Referr_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_extended_err;
	py_extended_err = PyErr_FromWERROR(object->extended_err);
	return py_extended_err;
}

static int py_drsuapi_DsAddEntryErrorInfo_Referr_V1_set_extended_err(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntryErrorInfo_Referr_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->extended_err");
		return -1;
	}
	object->extended_err = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyObject *py_drsuapi_DsAddEntryErrorInfo_Referr_V1_get_extended_data(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntryErrorInfo_Referr_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_extended_data;
	py_extended_data = PyLong_FromUnsignedLongLong((uint32_t)(object->extended_data));
	return py_extended_data;
}

static int py_drsuapi_DsAddEntryErrorInfo_Referr_V1_set_extended_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntryErrorInfo_Referr_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->extended_data");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->extended_data));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->extended_data = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntryErrorInfo_Referr_V1_get_refer(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntryErrorInfo_Referr_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_refer;
	py_refer = pytalloc_reference_ex(&drsuapi_DsAddEntry_RefErrListItem_V1_Type, pytalloc_get_mem_ctx(obj), &object->refer);
	return py_refer;
}

static int py_drsuapi_DsAddEntryErrorInfo_Referr_V1_set_refer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntryErrorInfo_Referr_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->refer");
		return -1;
	}
	PY_CHECK_TYPE(&drsuapi_DsAddEntry_RefErrListItem_V1_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->refer = *(struct drsuapi_DsAddEntry_RefErrListItem_V1 *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_drsuapi_DsAddEntryErrorInfo_Referr_V1_getsetters[] = {
	{
		.name = discard_const_p(char, "dsid"),
		.get = py_drsuapi_DsAddEntryErrorInfo_Referr_V1_get_dsid,
		.set = py_drsuapi_DsAddEntryErrorInfo_Referr_V1_set_dsid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "extended_err"),
		.get = py_drsuapi_DsAddEntryErrorInfo_Referr_V1_get_extended_err,
		.set = py_drsuapi_DsAddEntryErrorInfo_Referr_V1_set_extended_err,
		.doc = discard_const_p(char, "PIDL-generated element of base type WERROR")
	},
	{
		.name = discard_const_p(char, "extended_data"),
		.get = py_drsuapi_DsAddEntryErrorInfo_Referr_V1_get_extended_data,
		.set = py_drsuapi_DsAddEntryErrorInfo_Referr_V1_set_extended_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "refer"),
		.get = py_drsuapi_DsAddEntryErrorInfo_Referr_V1_get_refer,
		.set = py_drsuapi_DsAddEntryErrorInfo_Referr_V1_set_refer,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsAddEntry_RefErrListItem_V1")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsAddEntryErrorInfo_Referr_V1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsAddEntryErrorInfo_Referr_V1, type);
}


static PyTypeObject drsuapi_DsAddEntryErrorInfo_Referr_V1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsAddEntryErrorInfo_Referr_V1",
	.tp_getset = py_drsuapi_DsAddEntryErrorInfo_Referr_V1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsAddEntryErrorInfo_Referr_V1_new,
};

static PyObject *py_import_drsuapi_DsAddEntryErrorInfo(TALLOC_CTX *mem_ctx, int level, union drsuapi_DsAddEntryErrorInfo *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = pytalloc_reference_ex(&drsuapi_DsAddEntryErrorInfo_Attr_V1_Type, mem_ctx, &in->attr_err);
			return ret;

		case 2:
			ret = pytalloc_reference_ex(&drsuapi_DsAddEntryErrorInfo_Name_V1_Type, mem_ctx, &in->name_err);
			return ret;

		case 3:
			ret = pytalloc_reference_ex(&drsuapi_DsAddEntryErrorInfo_Referr_V1_Type, mem_ctx, &in->referral_err);
			return ret;

		case 4:
			ret = pytalloc_reference_ex(&drsuapi_DsAddEntryErrorInfoX_Type, mem_ctx, &in->security_err);
			return ret;

		case 5:
			ret = pytalloc_reference_ex(&drsuapi_DsAddEntryErrorInfoX_Type, mem_ctx, &in->service_err);
			return ret;

		case 6:
			ret = pytalloc_reference_ex(&drsuapi_DsAddEntryErrorInfoX_Type, mem_ctx, &in->update_err);
			return ret;

		case 7:
			ret = pytalloc_reference_ex(&drsuapi_DsAddEntryErrorInfoX_Type, mem_ctx, &in->system_err);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union drsuapi_DsAddEntryErrorInfo *py_export_drsuapi_DsAddEntryErrorInfo(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union drsuapi_DsAddEntryErrorInfo *ret = talloc_zero(mem_ctx, union drsuapi_DsAddEntryErrorInfo);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->attr_err");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsAddEntryErrorInfo_Attr_V1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->attr_err = *(struct drsuapi_DsAddEntryErrorInfo_Attr_V1 *)pytalloc_get_ptr(in);
			break;

		case 2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->name_err");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsAddEntryErrorInfo_Name_V1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->name_err = *(struct drsuapi_DsAddEntryErrorInfo_Name_V1 *)pytalloc_get_ptr(in);
			break;

		case 3:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->referral_err");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsAddEntryErrorInfo_Referr_V1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->referral_err = *(struct drsuapi_DsAddEntryErrorInfo_Referr_V1 *)pytalloc_get_ptr(in);
			break;

		case 4:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->security_err");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsAddEntryErrorInfoX_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->security_err = *(struct drsuapi_DsAddEntryErrorInfoX *)pytalloc_get_ptr(in);
			break;

		case 5:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->service_err");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsAddEntryErrorInfoX_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->service_err = *(struct drsuapi_DsAddEntryErrorInfoX *)pytalloc_get_ptr(in);
			break;

		case 6:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->update_err");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsAddEntryErrorInfoX_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->update_err = *(struct drsuapi_DsAddEntryErrorInfoX *)pytalloc_get_ptr(in);
			break;

		case 7:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->system_err");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsAddEntryErrorInfoX_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->system_err = *(struct drsuapi_DsAddEntryErrorInfoX *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_drsuapi_DsAddEntryErrorInfo_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union drsuapi_DsAddEntryErrorInfo *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union drsuapi_DsAddEntryErrorInfo *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union drsuapi_DsAddEntryErrorInfo!");
		return NULL;
	}

	return py_import_drsuapi_DsAddEntryErrorInfo(mem_ctx, level, in);
}

static PyObject *py_drsuapi_DsAddEntryErrorInfo_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union drsuapi_DsAddEntryErrorInfo *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_drsuapi_DsAddEntryErrorInfo(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_drsuapi_DsAddEntryErrorInfo_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsAddEntryErrorInfo_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsAddEntryErrorInfo_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_drsuapi_DsAddEntryErrorInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject drsuapi_DsAddEntryErrorInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsAddEntryErrorInfo",
	.tp_getset = NULL,
	.tp_methods = py_drsuapi_DsAddEntryErrorInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsAddEntryErrorInfo_new,
};


static PyObject *py_drsuapi_DsAddEntry_ErrData_V1_get_status(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntry_ErrData_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_status;
	py_status = PyErr_FromWERROR(object->status);
	return py_status;
}

static int py_drsuapi_DsAddEntry_ErrData_V1_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntry_ErrData_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->status");
		return -1;
	}
	object->status = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyObject *py_drsuapi_DsAddEntry_ErrData_V1_get_dir_err(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntry_ErrData_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_dir_err;
	py_dir_err = PyLong_FromUnsignedLongLong((uint32_t)(object->dir_err));
	return py_dir_err;
}

static int py_drsuapi_DsAddEntry_ErrData_V1_set_dir_err(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntry_ErrData_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dir_err");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dir_err));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dir_err = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntry_ErrData_V1_get_info(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntry_ErrData_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->info == NULL) {
		Py_RETURN_NONE;
	}
	if (object->info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pyrpc_import_union(&drsuapi_DsAddEntryErrorInfo_Type, object->info, object->dir_err, object->info, "union drsuapi_DsAddEntryErrorInfo");
		if (py_info == NULL) {
			return NULL;
		}
	}
	return py_info;
}

static int py_drsuapi_DsAddEntry_ErrData_V1_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntry_ErrData_V1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info");
		return -1;
	}
	if (value == Py_None) {
		object->info = NULL;
	} else {
		object->info = NULL;
		{
			union drsuapi_DsAddEntryErrorInfo *info_switch_1;
			info_switch_1 = (union drsuapi_DsAddEntryErrorInfo *)pyrpc_export_union(&drsuapi_DsAddEntryErrorInfo_Type, pytalloc_get_mem_ctx(py_obj), object->dir_err, value, "union drsuapi_DsAddEntryErrorInfo");
			if (info_switch_1 == NULL) {
				return -1;
			}
			object->info = info_switch_1;
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsAddEntry_ErrData_V1_getsetters[] = {
	{
		.name = discard_const_p(char, "status"),
		.get = py_drsuapi_DsAddEntry_ErrData_V1_get_status,
		.set = py_drsuapi_DsAddEntry_ErrData_V1_set_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type WERROR")
	},
	{
		.name = discard_const_p(char, "dir_err"),
		.get = py_drsuapi_DsAddEntry_ErrData_V1_get_dir_err,
		.set = py_drsuapi_DsAddEntry_ErrData_V1_set_dir_err,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsAddEntry_DirErr")
	},
	{
		.name = discard_const_p(char, "info"),
		.get = py_drsuapi_DsAddEntry_ErrData_V1_get_info,
		.set = py_drsuapi_DsAddEntry_ErrData_V1_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsAddEntryErrorInfo")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsAddEntry_ErrData_V1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsAddEntry_ErrData_V1, type);
}


static PyTypeObject drsuapi_DsAddEntry_ErrData_V1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsAddEntry_ErrData_V1",
	.tp_getset = py_drsuapi_DsAddEntry_ErrData_V1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsAddEntry_ErrData_V1_new,
};

static PyObject *py_import_drsuapi_DsAddEntry_ErrData(TALLOC_CTX *mem_ctx, int level, union drsuapi_DsAddEntry_ErrData *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = pytalloc_reference_ex(&drsuapi_DsAddEntry_ErrData_V1_Type, mem_ctx, &in->v1);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union drsuapi_DsAddEntry_ErrData *py_export_drsuapi_DsAddEntry_ErrData(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union drsuapi_DsAddEntry_ErrData *ret = talloc_zero(mem_ctx, union drsuapi_DsAddEntry_ErrData);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->v1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsAddEntry_ErrData_V1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->v1 = *(struct drsuapi_DsAddEntry_ErrData_V1 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_drsuapi_DsAddEntry_ErrData_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union drsuapi_DsAddEntry_ErrData *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union drsuapi_DsAddEntry_ErrData *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union drsuapi_DsAddEntry_ErrData!");
		return NULL;
	}

	return py_import_drsuapi_DsAddEntry_ErrData(mem_ctx, level, in);
}

static PyObject *py_drsuapi_DsAddEntry_ErrData_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union drsuapi_DsAddEntry_ErrData *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_drsuapi_DsAddEntry_ErrData(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_drsuapi_DsAddEntry_ErrData_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsAddEntry_ErrData_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsAddEntry_ErrData_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_drsuapi_DsAddEntry_ErrData_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject drsuapi_DsAddEntry_ErrData_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsAddEntry_ErrData",
	.tp_getset = NULL,
	.tp_methods = py_drsuapi_DsAddEntry_ErrData_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsAddEntry_ErrData_new,
};


static PyObject *py_drsuapi_DsReplicaObjectIdentifier2_get_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier2 *object = pytalloc_get_ptr(obj);
	PyObject *py_guid;
	py_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->guid);
	return py_guid;
}

static int py_drsuapi_DsReplicaObjectIdentifier2_set_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsReplicaObjectIdentifier2_get_sid(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier2 *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	py_sid = pytalloc_reference_ex(dom_sid_Type, pytalloc_get_mem_ctx(obj), &object->sid);
	return py_sid;
}

static int py_drsuapi_DsReplicaObjectIdentifier2_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjectIdentifier2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sid");
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sid = *(struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaObjectIdentifier2_getsetters[] = {
	{
		.name = discard_const_p(char, "guid"),
		.get = py_drsuapi_DsReplicaObjectIdentifier2_get_guid,
		.set = py_drsuapi_DsReplicaObjectIdentifier2_set_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "sid"),
		.get = py_drsuapi_DsReplicaObjectIdentifier2_get_sid,
		.set = py_drsuapi_DsReplicaObjectIdentifier2_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid28")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaObjectIdentifier2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaObjectIdentifier2, type);
}


static PyTypeObject drsuapi_DsReplicaObjectIdentifier2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaObjectIdentifier2",
	.tp_getset = py_drsuapi_DsReplicaObjectIdentifier2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaObjectIdentifier2_new,
};


static PyObject *py_drsuapi_DsAddEntryCtr2_get_id(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntryCtr2 *object = pytalloc_get_ptr(obj);
	PyObject *py_id;
	if (object->id == NULL) {
		Py_RETURN_NONE;
	}
	if (object->id == NULL) {
		py_id = Py_None;
		Py_INCREF(py_id);
	} else {
		py_id = pytalloc_reference_ex(&drsuapi_DsReplicaObjectIdentifier_Type, object->id, object->id);
	}
	return py_id;
}

static int py_drsuapi_DsAddEntryCtr2_set_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntryCtr2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->id));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->id");
		return -1;
	}
	if (value == Py_None) {
		object->id = NULL;
	} else {
		object->id = NULL;
		PY_CHECK_TYPE(&drsuapi_DsReplicaObjectIdentifier_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->id = (struct drsuapi_DsReplicaObjectIdentifier *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntryCtr2_get_dir_err(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntryCtr2 *object = pytalloc_get_ptr(obj);
	PyObject *py_dir_err;
	py_dir_err = PyLong_FromUnsignedLongLong((uint32_t)(object->dir_err));
	return py_dir_err;
}

static int py_drsuapi_DsAddEntryCtr2_set_dir_err(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntryCtr2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dir_err");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dir_err));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dir_err = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntryCtr2_get_dsid(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntryCtr2 *object = pytalloc_get_ptr(obj);
	PyObject *py_dsid;
	py_dsid = PyLong_FromUnsignedLongLong((uint32_t)(object->dsid));
	return py_dsid;
}

static int py_drsuapi_DsAddEntryCtr2_set_dsid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntryCtr2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dsid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dsid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dsid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntryCtr2_get_extended_err(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntryCtr2 *object = pytalloc_get_ptr(obj);
	PyObject *py_extended_err;
	py_extended_err = PyErr_FromWERROR(object->extended_err);
	return py_extended_err;
}

static int py_drsuapi_DsAddEntryCtr2_set_extended_err(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntryCtr2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->extended_err");
		return -1;
	}
	object->extended_err = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyObject *py_drsuapi_DsAddEntryCtr2_get_extended_data(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntryCtr2 *object = pytalloc_get_ptr(obj);
	PyObject *py_extended_data;
	py_extended_data = PyLong_FromUnsignedLongLong((uint32_t)(object->extended_data));
	return py_extended_data;
}

static int py_drsuapi_DsAddEntryCtr2_set_extended_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntryCtr2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->extended_data");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->extended_data));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->extended_data = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntryCtr2_get_problem(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntryCtr2 *object = pytalloc_get_ptr(obj);
	PyObject *py_problem;
	py_problem = PyLong_FromLong((uint16_t)(object->problem));
	return py_problem;
}

static int py_drsuapi_DsAddEntryCtr2_set_problem(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntryCtr2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->problem");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->problem));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->problem = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntryCtr2_get_count(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntryCtr2 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_drsuapi_DsAddEntryCtr2_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntryCtr2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntryCtr2_get_objects(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntryCtr2 *object = pytalloc_get_ptr(obj);
	PyObject *py_objects;
	if (object->objects == NULL) {
		Py_RETURN_NONE;
	}
	if (object->objects == NULL) {
		py_objects = Py_None;
		Py_INCREF(py_objects);
	} else {
		py_objects = PyList_New(object->count);
		if (py_objects == NULL) {
			return NULL;
		}
		{
			int objects_cntr_1;
			for (objects_cntr_1 = 0; objects_cntr_1 < (object->count); objects_cntr_1++) {
				PyObject *py_objects_1;
				py_objects_1 = pytalloc_reference_ex(&drsuapi_DsReplicaObjectIdentifier2_Type, object->objects, &(object->objects)[objects_cntr_1]);
				PyList_SetItem(py_objects, objects_cntr_1, py_objects_1);
			}
		}
	}
	return py_objects;
}

static int py_drsuapi_DsAddEntryCtr2_set_objects(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntryCtr2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->objects));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->objects");
		return -1;
	}
	if (value == Py_None) {
		object->objects = NULL;
	} else {
		object->objects = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int objects_cntr_1;
			object->objects = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->objects, PyList_GET_SIZE(value));
			if (!object->objects) { return -1; }
			talloc_set_name_const(object->objects, "ARRAY: object->objects");
			for (objects_cntr_1 = 0; objects_cntr_1 < PyList_GET_SIZE(value); objects_cntr_1++) {
				if (PyList_GET_ITEM(value, objects_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->objects)[objects_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&drsuapi_DsReplicaObjectIdentifier2_Type, PyList_GET_ITEM(value, objects_cntr_1), return -1;);
				if (talloc_reference(object->objects, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, objects_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->objects)[objects_cntr_1] = *(struct drsuapi_DsReplicaObjectIdentifier2 *)pytalloc_get_ptr(PyList_GET_ITEM(value, objects_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsAddEntryCtr2_getsetters[] = {
	{
		.name = discard_const_p(char, "id"),
		.get = py_drsuapi_DsAddEntryCtr2_get_id,
		.set = py_drsuapi_DsAddEntryCtr2_set_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObjectIdentifier")
	},
	{
		.name = discard_const_p(char, "dir_err"),
		.get = py_drsuapi_DsAddEntryCtr2_get_dir_err,
		.set = py_drsuapi_DsAddEntryCtr2_set_dir_err,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsAddEntry_DirErr")
	},
	{
		.name = discard_const_p(char, "dsid"),
		.get = py_drsuapi_DsAddEntryCtr2_get_dsid,
		.set = py_drsuapi_DsAddEntryCtr2_set_dsid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "extended_err"),
		.get = py_drsuapi_DsAddEntryCtr2_get_extended_err,
		.set = py_drsuapi_DsAddEntryCtr2_set_extended_err,
		.doc = discard_const_p(char, "PIDL-generated element of base type WERROR")
	},
	{
		.name = discard_const_p(char, "extended_data"),
		.get = py_drsuapi_DsAddEntryCtr2_get_extended_data,
		.set = py_drsuapi_DsAddEntryCtr2_set_extended_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "problem"),
		.get = py_drsuapi_DsAddEntryCtr2_get_problem,
		.set = py_drsuapi_DsAddEntryCtr2_set_problem,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "count"),
		.get = py_drsuapi_DsAddEntryCtr2_get_count,
		.set = py_drsuapi_DsAddEntryCtr2_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "objects"),
		.get = py_drsuapi_DsAddEntryCtr2_get_objects,
		.set = py_drsuapi_DsAddEntryCtr2_set_objects,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObjectIdentifier2")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsAddEntryCtr2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsAddEntryCtr2, type);
}


static PyTypeObject drsuapi_DsAddEntryCtr2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsAddEntryCtr2",
	.tp_getset = py_drsuapi_DsAddEntryCtr2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsAddEntryCtr2_new,
};


static PyObject *py_drsuapi_DsAddEntryCtr3_get_id(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntryCtr3 *object = pytalloc_get_ptr(obj);
	PyObject *py_id;
	if (object->id == NULL) {
		Py_RETURN_NONE;
	}
	if (object->id == NULL) {
		py_id = Py_None;
		Py_INCREF(py_id);
	} else {
		py_id = pytalloc_reference_ex(&drsuapi_DsReplicaObjectIdentifier_Type, object->id, object->id);
	}
	return py_id;
}

static int py_drsuapi_DsAddEntryCtr3_set_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntryCtr3 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->id));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->id");
		return -1;
	}
	if (value == Py_None) {
		object->id = NULL;
	} else {
		object->id = NULL;
		PY_CHECK_TYPE(&drsuapi_DsReplicaObjectIdentifier_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->id = (struct drsuapi_DsReplicaObjectIdentifier *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntryCtr3_get_err_ver(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntryCtr3 *object = pytalloc_get_ptr(obj);
	PyObject *py_err_ver;
	py_err_ver = PyLong_FromUnsignedLongLong((uint32_t)(object->err_ver));
	return py_err_ver;
}

static int py_drsuapi_DsAddEntryCtr3_set_err_ver(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntryCtr3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->err_ver");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->err_ver));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->err_ver = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntryCtr3_get_err_data(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntryCtr3 *object = pytalloc_get_ptr(obj);
	PyObject *py_err_data;
	if (object->err_data == NULL) {
		Py_RETURN_NONE;
	}
	if (object->err_data == NULL) {
		py_err_data = Py_None;
		Py_INCREF(py_err_data);
	} else {
		py_err_data = pyrpc_import_union(&drsuapi_DsAddEntry_ErrData_Type, object->err_data, object->err_ver, object->err_data, "union drsuapi_DsAddEntry_ErrData");
		if (py_err_data == NULL) {
			return NULL;
		}
	}
	return py_err_data;
}

static int py_drsuapi_DsAddEntryCtr3_set_err_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntryCtr3 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->err_data));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->err_data");
		return -1;
	}
	if (value == Py_None) {
		object->err_data = NULL;
	} else {
		object->err_data = NULL;
		{
			union drsuapi_DsAddEntry_ErrData *err_data_switch_1;
			err_data_switch_1 = (union drsuapi_DsAddEntry_ErrData *)pyrpc_export_union(&drsuapi_DsAddEntry_ErrData_Type, pytalloc_get_mem_ctx(py_obj), object->err_ver, value, "union drsuapi_DsAddEntry_ErrData");
			if (err_data_switch_1 == NULL) {
				return -1;
			}
			object->err_data = err_data_switch_1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntryCtr3_get_count(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntryCtr3 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_drsuapi_DsAddEntryCtr3_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntryCtr3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsAddEntryCtr3_get_objects(PyObject *obj, void *closure)
{
	struct drsuapi_DsAddEntryCtr3 *object = pytalloc_get_ptr(obj);
	PyObject *py_objects;
	if (object->objects == NULL) {
		Py_RETURN_NONE;
	}
	if (object->objects == NULL) {
		py_objects = Py_None;
		Py_INCREF(py_objects);
	} else {
		py_objects = PyList_New(object->count);
		if (py_objects == NULL) {
			return NULL;
		}
		{
			int objects_cntr_1;
			for (objects_cntr_1 = 0; objects_cntr_1 < (object->count); objects_cntr_1++) {
				PyObject *py_objects_1;
				py_objects_1 = pytalloc_reference_ex(&drsuapi_DsReplicaObjectIdentifier2_Type, object->objects, &(object->objects)[objects_cntr_1]);
				PyList_SetItem(py_objects, objects_cntr_1, py_objects_1);
			}
		}
	}
	return py_objects;
}

static int py_drsuapi_DsAddEntryCtr3_set_objects(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsAddEntryCtr3 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->objects));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->objects");
		return -1;
	}
	if (value == Py_None) {
		object->objects = NULL;
	} else {
		object->objects = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int objects_cntr_1;
			object->objects = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->objects, PyList_GET_SIZE(value));
			if (!object->objects) { return -1; }
			talloc_set_name_const(object->objects, "ARRAY: object->objects");
			for (objects_cntr_1 = 0; objects_cntr_1 < PyList_GET_SIZE(value); objects_cntr_1++) {
				if (PyList_GET_ITEM(value, objects_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->objects)[objects_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&drsuapi_DsReplicaObjectIdentifier2_Type, PyList_GET_ITEM(value, objects_cntr_1), return -1;);
				if (talloc_reference(object->objects, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, objects_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->objects)[objects_cntr_1] = *(struct drsuapi_DsReplicaObjectIdentifier2 *)pytalloc_get_ptr(PyList_GET_ITEM(value, objects_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsAddEntryCtr3_getsetters[] = {
	{
		.name = discard_const_p(char, "id"),
		.get = py_drsuapi_DsAddEntryCtr3_get_id,
		.set = py_drsuapi_DsAddEntryCtr3_set_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObjectIdentifier")
	},
	{
		.name = discard_const_p(char, "err_ver"),
		.get = py_drsuapi_DsAddEntryCtr3_get_err_ver,
		.set = py_drsuapi_DsAddEntryCtr3_set_err_ver,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "err_data"),
		.get = py_drsuapi_DsAddEntryCtr3_get_err_data,
		.set = py_drsuapi_DsAddEntryCtr3_set_err_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsAddEntry_ErrData")
	},
	{
		.name = discard_const_p(char, "count"),
		.get = py_drsuapi_DsAddEntryCtr3_get_count,
		.set = py_drsuapi_DsAddEntryCtr3_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "objects"),
		.get = py_drsuapi_DsAddEntryCtr3_get_objects,
		.set = py_drsuapi_DsAddEntryCtr3_set_objects,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObjectIdentifier2")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsAddEntryCtr3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsAddEntryCtr3, type);
}


static PyTypeObject drsuapi_DsAddEntryCtr3_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsAddEntryCtr3",
	.tp_getset = py_drsuapi_DsAddEntryCtr3_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsAddEntryCtr3_new,
};

static PyObject *py_import_drsuapi_DsAddEntryCtr(TALLOC_CTX *mem_ctx, int level, union drsuapi_DsAddEntryCtr *in)
{
	PyObject *ret;

	switch (level) {
		case 2:
			ret = pytalloc_reference_ex(&drsuapi_DsAddEntryCtr2_Type, mem_ctx, &in->ctr2);
			return ret;

		case 3:
			ret = pytalloc_reference_ex(&drsuapi_DsAddEntryCtr3_Type, mem_ctx, &in->ctr3);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union drsuapi_DsAddEntryCtr *py_export_drsuapi_DsAddEntryCtr(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union drsuapi_DsAddEntryCtr *ret = talloc_zero(mem_ctx, union drsuapi_DsAddEntryCtr);
	switch (level) {
		case 2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr2");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsAddEntryCtr2_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ctr2 = *(struct drsuapi_DsAddEntryCtr2 *)pytalloc_get_ptr(in);
			break;

		case 3:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr3");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsAddEntryCtr3_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ctr3 = *(struct drsuapi_DsAddEntryCtr3 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_drsuapi_DsAddEntryCtr_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union drsuapi_DsAddEntryCtr *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union drsuapi_DsAddEntryCtr *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union drsuapi_DsAddEntryCtr!");
		return NULL;
	}

	return py_import_drsuapi_DsAddEntryCtr(mem_ctx, level, in);
}

static PyObject *py_drsuapi_DsAddEntryCtr_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union drsuapi_DsAddEntryCtr *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_drsuapi_DsAddEntryCtr(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_drsuapi_DsAddEntryCtr_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsAddEntryCtr_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsAddEntryCtr_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_drsuapi_DsAddEntryCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject drsuapi_DsAddEntryCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsAddEntryCtr",
	.tp_getset = NULL,
	.tp_methods = py_drsuapi_DsAddEntryCtr_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsAddEntryCtr_new,
};


static PyObject *py_drsuapi_DsExecuteKCC1_get_taskID(PyObject *obj, void *closure)
{
	struct drsuapi_DsExecuteKCC1 *object = pytalloc_get_ptr(obj);
	PyObject *py_taskID;
	py_taskID = PyLong_FromUnsignedLongLong((uint32_t)(object->taskID));
	return py_taskID;
}

static int py_drsuapi_DsExecuteKCC1_set_taskID(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsExecuteKCC1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->taskID");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->taskID));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->taskID = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsExecuteKCC1_get_flags(PyObject *obj, void *closure)
{
	struct drsuapi_DsExecuteKCC1 *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->flags));
	return py_flags;
}

static int py_drsuapi_DsExecuteKCC1_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsExecuteKCC1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsExecuteKCC1_getsetters[] = {
	{
		.name = discard_const_p(char, "taskID"),
		.get = py_drsuapi_DsExecuteKCC1_get_taskID,
		.set = py_drsuapi_DsExecuteKCC1_set_taskID,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "flags"),
		.get = py_drsuapi_DsExecuteKCC1_get_flags,
		.set = py_drsuapi_DsExecuteKCC1_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsExecuteKCCFlags")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsExecuteKCC1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsExecuteKCC1, type);
}


static PyTypeObject drsuapi_DsExecuteKCC1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsExecuteKCC1",
	.tp_getset = py_drsuapi_DsExecuteKCC1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsExecuteKCC1_new,
};

static PyObject *py_import_drsuapi_DsExecuteKCCRequest(TALLOC_CTX *mem_ctx, int level, union drsuapi_DsExecuteKCCRequest *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = pytalloc_reference_ex(&drsuapi_DsExecuteKCC1_Type, mem_ctx, &in->ctr1);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union drsuapi_DsExecuteKCCRequest *py_export_drsuapi_DsExecuteKCCRequest(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union drsuapi_DsExecuteKCCRequest *ret = talloc_zero(mem_ctx, union drsuapi_DsExecuteKCCRequest);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsExecuteKCC1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ctr1 = *(struct drsuapi_DsExecuteKCC1 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_drsuapi_DsExecuteKCCRequest_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union drsuapi_DsExecuteKCCRequest *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union drsuapi_DsExecuteKCCRequest *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union drsuapi_DsExecuteKCCRequest!");
		return NULL;
	}

	return py_import_drsuapi_DsExecuteKCCRequest(mem_ctx, level, in);
}

static PyObject *py_drsuapi_DsExecuteKCCRequest_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union drsuapi_DsExecuteKCCRequest *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_drsuapi_DsExecuteKCCRequest(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_drsuapi_DsExecuteKCCRequest_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsExecuteKCCRequest_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsExecuteKCCRequest_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_drsuapi_DsExecuteKCCRequest_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject drsuapi_DsExecuteKCCRequest_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsExecuteKCCRequest",
	.tp_getset = NULL,
	.tp_methods = py_drsuapi_DsExecuteKCCRequest_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsExecuteKCCRequest_new,
};


static PyObject *py_drsuapi_DsReplicaGetInfoRequest1_get_info_type(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaGetInfoRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_info_type;
	py_info_type = PyLong_FromUnsignedLongLong((uint32_t)(object->info_type));
	return py_info_type;
}

static int py_drsuapi_DsReplicaGetInfoRequest1_set_info_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaGetInfoRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->info_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->info_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaGetInfoRequest1_get_object_dn(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaGetInfoRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_object_dn;
	if (object->object_dn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->object_dn == NULL) {
		py_object_dn = Py_None;
		Py_INCREF(py_object_dn);
	} else {
		if (object->object_dn == NULL) {
			py_object_dn = Py_None;
			Py_INCREF(py_object_dn);
		} else {
			py_object_dn = PyUnicode_Decode(object->object_dn, strlen(object->object_dn), "utf-8", "ignore");
		}
	}
	return py_object_dn;
}

static int py_drsuapi_DsReplicaGetInfoRequest1_set_object_dn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaGetInfoRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->object_dn");
		return -1;
	}
	if (value == Py_None) {
		object->object_dn = NULL;
	} else {
		object->object_dn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->object_dn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaGetInfoRequest1_get_source_dsa_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaGetInfoRequest1 *object = pytalloc_get_ptr(obj);
	PyObject *py_source_dsa_guid;
	py_source_dsa_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->source_dsa_guid);
	return py_source_dsa_guid;
}

static int py_drsuapi_DsReplicaGetInfoRequest1_set_source_dsa_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaGetInfoRequest1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->source_dsa_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->source_dsa_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaGetInfoRequest1_getsetters[] = {
	{
		.name = discard_const_p(char, "info_type"),
		.get = py_drsuapi_DsReplicaGetInfoRequest1_get_info_type,
		.set = py_drsuapi_DsReplicaGetInfoRequest1_set_info_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaInfoType")
	},
	{
		.name = discard_const_p(char, "object_dn"),
		.get = py_drsuapi_DsReplicaGetInfoRequest1_get_object_dn,
		.set = py_drsuapi_DsReplicaGetInfoRequest1_set_object_dn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "source_dsa_guid"),
		.get = py_drsuapi_DsReplicaGetInfoRequest1_get_source_dsa_guid,
		.set = py_drsuapi_DsReplicaGetInfoRequest1_set_source_dsa_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaGetInfoRequest1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaGetInfoRequest1, type);
}


static PyTypeObject drsuapi_DsReplicaGetInfoRequest1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaGetInfoRequest1",
	.tp_getset = py_drsuapi_DsReplicaGetInfoRequest1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaGetInfoRequest1_new,
};


static PyObject *py_drsuapi_DsReplicaGetInfoRequest2_get_info_type(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaGetInfoRequest2 *object = pytalloc_get_ptr(obj);
	PyObject *py_info_type;
	py_info_type = PyLong_FromUnsignedLongLong((uint32_t)(object->info_type));
	return py_info_type;
}

static int py_drsuapi_DsReplicaGetInfoRequest2_set_info_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaGetInfoRequest2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->info_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->info_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaGetInfoRequest2_get_object_dn(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaGetInfoRequest2 *object = pytalloc_get_ptr(obj);
	PyObject *py_object_dn;
	if (object->object_dn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->object_dn == NULL) {
		py_object_dn = Py_None;
		Py_INCREF(py_object_dn);
	} else {
		if (object->object_dn == NULL) {
			py_object_dn = Py_None;
			Py_INCREF(py_object_dn);
		} else {
			py_object_dn = PyUnicode_Decode(object->object_dn, strlen(object->object_dn), "utf-8", "ignore");
		}
	}
	return py_object_dn;
}

static int py_drsuapi_DsReplicaGetInfoRequest2_set_object_dn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaGetInfoRequest2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->object_dn");
		return -1;
	}
	if (value == Py_None) {
		object->object_dn = NULL;
	} else {
		object->object_dn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->object_dn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaGetInfoRequest2_get_source_dsa_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaGetInfoRequest2 *object = pytalloc_get_ptr(obj);
	PyObject *py_source_dsa_guid;
	py_source_dsa_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->source_dsa_guid);
	return py_source_dsa_guid;
}

static int py_drsuapi_DsReplicaGetInfoRequest2_set_source_dsa_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaGetInfoRequest2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->source_dsa_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->source_dsa_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsReplicaGetInfoRequest2_get_flags(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaGetInfoRequest2 *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->flags));
	return py_flags;
}

static int py_drsuapi_DsReplicaGetInfoRequest2_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaGetInfoRequest2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaGetInfoRequest2_get_attribute_name(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaGetInfoRequest2 *object = pytalloc_get_ptr(obj);
	PyObject *py_attribute_name;
	if (object->attribute_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->attribute_name == NULL) {
		py_attribute_name = Py_None;
		Py_INCREF(py_attribute_name);
	} else {
		if (object->attribute_name == NULL) {
			py_attribute_name = Py_None;
			Py_INCREF(py_attribute_name);
		} else {
			py_attribute_name = PyUnicode_Decode(object->attribute_name, strlen(object->attribute_name), "utf-8", "ignore");
		}
	}
	return py_attribute_name;
}

static int py_drsuapi_DsReplicaGetInfoRequest2_set_attribute_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaGetInfoRequest2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->attribute_name");
		return -1;
	}
	if (value == Py_None) {
		object->attribute_name = NULL;
	} else {
		object->attribute_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->attribute_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaGetInfoRequest2_get_value_dn_str(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaGetInfoRequest2 *object = pytalloc_get_ptr(obj);
	PyObject *py_value_dn_str;
	if (object->value_dn_str == NULL) {
		Py_RETURN_NONE;
	}
	if (object->value_dn_str == NULL) {
		py_value_dn_str = Py_None;
		Py_INCREF(py_value_dn_str);
	} else {
		if (object->value_dn_str == NULL) {
			py_value_dn_str = Py_None;
			Py_INCREF(py_value_dn_str);
		} else {
			py_value_dn_str = PyUnicode_Decode(object->value_dn_str, strlen(object->value_dn_str), "utf-8", "ignore");
		}
	}
	return py_value_dn_str;
}

static int py_drsuapi_DsReplicaGetInfoRequest2_set_value_dn_str(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaGetInfoRequest2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->value_dn_str");
		return -1;
	}
	if (value == Py_None) {
		object->value_dn_str = NULL;
	} else {
		object->value_dn_str = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->value_dn_str = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaGetInfoRequest2_get_enumeration_context(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaGetInfoRequest2 *object = pytalloc_get_ptr(obj);
	PyObject *py_enumeration_context;
	py_enumeration_context = PyLong_FromUnsignedLongLong((uint32_t)(object->enumeration_context));
	return py_enumeration_context;
}

static int py_drsuapi_DsReplicaGetInfoRequest2_set_enumeration_context(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaGetInfoRequest2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->enumeration_context");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->enumeration_context));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->enumeration_context = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaGetInfoRequest2_getsetters[] = {
	{
		.name = discard_const_p(char, "info_type"),
		.get = py_drsuapi_DsReplicaGetInfoRequest2_get_info_type,
		.set = py_drsuapi_DsReplicaGetInfoRequest2_set_info_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaInfoType")
	},
	{
		.name = discard_const_p(char, "object_dn"),
		.get = py_drsuapi_DsReplicaGetInfoRequest2_get_object_dn,
		.set = py_drsuapi_DsReplicaGetInfoRequest2_set_object_dn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "source_dsa_guid"),
		.get = py_drsuapi_DsReplicaGetInfoRequest2_get_source_dsa_guid,
		.set = py_drsuapi_DsReplicaGetInfoRequest2_set_source_dsa_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "flags"),
		.get = py_drsuapi_DsReplicaGetInfoRequest2_get_flags,
		.set = py_drsuapi_DsReplicaGetInfoRequest2_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "attribute_name"),
		.get = py_drsuapi_DsReplicaGetInfoRequest2_get_attribute_name,
		.set = py_drsuapi_DsReplicaGetInfoRequest2_set_attribute_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "value_dn_str"),
		.get = py_drsuapi_DsReplicaGetInfoRequest2_get_value_dn_str,
		.set = py_drsuapi_DsReplicaGetInfoRequest2_set_value_dn_str,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "enumeration_context"),
		.get = py_drsuapi_DsReplicaGetInfoRequest2_get_enumeration_context,
		.set = py_drsuapi_DsReplicaGetInfoRequest2_set_enumeration_context,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaGetInfoRequest2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaGetInfoRequest2, type);
}


static PyTypeObject drsuapi_DsReplicaGetInfoRequest2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaGetInfoRequest2",
	.tp_getset = py_drsuapi_DsReplicaGetInfoRequest2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaGetInfoRequest2_new,
};

static PyObject *py_import_drsuapi_DsReplicaGetInfoRequest(TALLOC_CTX *mem_ctx, int level, union drsuapi_DsReplicaGetInfoRequest *in)
{
	PyObject *ret;

	switch (level) {
		case DRSUAPI_DS_REPLICA_GET_INFO:
			ret = pytalloc_reference_ex(&drsuapi_DsReplicaGetInfoRequest1_Type, mem_ctx, &in->req1);
			return ret;

		case DRSUAPI_DS_REPLICA_GET_INFO2:
			ret = pytalloc_reference_ex(&drsuapi_DsReplicaGetInfoRequest2_Type, mem_ctx, &in->req2);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union drsuapi_DsReplicaGetInfoRequest *py_export_drsuapi_DsReplicaGetInfoRequest(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union drsuapi_DsReplicaGetInfoRequest *ret = talloc_zero(mem_ctx, union drsuapi_DsReplicaGetInfoRequest);
	switch (level) {
		case DRSUAPI_DS_REPLICA_GET_INFO:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->req1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsReplicaGetInfoRequest1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->req1 = *(struct drsuapi_DsReplicaGetInfoRequest1 *)pytalloc_get_ptr(in);
			break;

		case DRSUAPI_DS_REPLICA_GET_INFO2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->req2");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&drsuapi_DsReplicaGetInfoRequest2_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->req2 = *(struct drsuapi_DsReplicaGetInfoRequest2 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_drsuapi_DsReplicaGetInfoRequest_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union drsuapi_DsReplicaGetInfoRequest *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union drsuapi_DsReplicaGetInfoRequest *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union drsuapi_DsReplicaGetInfoRequest!");
		return NULL;
	}

	return py_import_drsuapi_DsReplicaGetInfoRequest(mem_ctx, level, in);
}

static PyObject *py_drsuapi_DsReplicaGetInfoRequest_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union drsuapi_DsReplicaGetInfoRequest *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_drsuapi_DsReplicaGetInfoRequest(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_drsuapi_DsReplicaGetInfoRequest_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaGetInfoRequest_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_DsReplicaGetInfoRequest_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_drsuapi_DsReplicaGetInfoRequest_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject drsuapi_DsReplicaGetInfoRequest_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaGetInfoRequest",
	.tp_getset = NULL,
	.tp_methods = py_drsuapi_DsReplicaGetInfoRequest_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaGetInfoRequest_new,
};


static PyObject *py_drsuapi_DsReplicaNeighbour_get_naming_context_dn(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaNeighbour *object = pytalloc_get_ptr(obj);
	PyObject *py_naming_context_dn;
	if (object->naming_context_dn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->naming_context_dn == NULL) {
		py_naming_context_dn = Py_None;
		Py_INCREF(py_naming_context_dn);
	} else {
		if (object->naming_context_dn == NULL) {
			py_naming_context_dn = Py_None;
			Py_INCREF(py_naming_context_dn);
		} else {
			py_naming_context_dn = PyUnicode_Decode(object->naming_context_dn, strlen(object->naming_context_dn), "utf-8", "ignore");
		}
	}
	return py_naming_context_dn;
}

static int py_drsuapi_DsReplicaNeighbour_set_naming_context_dn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaNeighbour *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->naming_context_dn");
		return -1;
	}
	if (value == Py_None) {
		object->naming_context_dn = NULL;
	} else {
		object->naming_context_dn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->naming_context_dn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaNeighbour_get_source_dsa_obj_dn(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaNeighbour *object = pytalloc_get_ptr(obj);
	PyObject *py_source_dsa_obj_dn;
	if (object->source_dsa_obj_dn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->source_dsa_obj_dn == NULL) {
		py_source_dsa_obj_dn = Py_None;
		Py_INCREF(py_source_dsa_obj_dn);
	} else {
		if (object->source_dsa_obj_dn == NULL) {
			py_source_dsa_obj_dn = Py_None;
			Py_INCREF(py_source_dsa_obj_dn);
		} else {
			py_source_dsa_obj_dn = PyUnicode_Decode(object->source_dsa_obj_dn, strlen(object->source_dsa_obj_dn), "utf-8", "ignore");
		}
	}
	return py_source_dsa_obj_dn;
}

static int py_drsuapi_DsReplicaNeighbour_set_source_dsa_obj_dn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaNeighbour *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->source_dsa_obj_dn");
		return -1;
	}
	if (value == Py_None) {
		object->source_dsa_obj_dn = NULL;
	} else {
		object->source_dsa_obj_dn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->source_dsa_obj_dn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaNeighbour_get_source_dsa_address(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaNeighbour *object = pytalloc_get_ptr(obj);
	PyObject *py_source_dsa_address;
	if (object->source_dsa_address == NULL) {
		Py_RETURN_NONE;
	}
	if (object->source_dsa_address == NULL) {
		py_source_dsa_address = Py_None;
		Py_INCREF(py_source_dsa_address);
	} else {
		if (object->source_dsa_address == NULL) {
			py_source_dsa_address = Py_None;
			Py_INCREF(py_source_dsa_address);
		} else {
			py_source_dsa_address = PyUnicode_Decode(object->source_dsa_address, strlen(object->source_dsa_address), "utf-8", "ignore");
		}
	}
	return py_source_dsa_address;
}

static int py_drsuapi_DsReplicaNeighbour_set_source_dsa_address(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaNeighbour *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->source_dsa_address");
		return -1;
	}
	if (value == Py_None) {
		object->source_dsa_address = NULL;
	} else {
		object->source_dsa_address = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->source_dsa_address = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaNeighbour_get_transport_obj_dn(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaNeighbour *object = pytalloc_get_ptr(obj);
	PyObject *py_transport_obj_dn;
	if (object->transport_obj_dn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->transport_obj_dn == NULL) {
		py_transport_obj_dn = Py_None;
		Py_INCREF(py_transport_obj_dn);
	} else {
		if (object->transport_obj_dn == NULL) {
			py_transport_obj_dn = Py_None;
			Py_INCREF(py_transport_obj_dn);
		} else {
			py_transport_obj_dn = PyUnicode_Decode(object->transport_obj_dn, strlen(object->transport_obj_dn), "utf-8", "ignore");
		}
	}
	return py_transport_obj_dn;
}

static int py_drsuapi_DsReplicaNeighbour_set_transport_obj_dn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaNeighbour *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->transport_obj_dn");
		return -1;
	}
	if (value == Py_None) {
		object->transport_obj_dn = NULL;
	} else {
		object->transport_obj_dn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->transport_obj_dn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaNeighbour_get_replica_flags(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaNeighbour *object = pytalloc_get_ptr(obj);
	PyObject *py_replica_flags;
	py_replica_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->replica_flags));
	return py_replica_flags;
}

static int py_drsuapi_DsReplicaNeighbour_set_replica_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaNeighbour *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->replica_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->replica_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->replica_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaNeighbour_get_reserved(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaNeighbour *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved));
	return py_reserved;
}

static int py_drsuapi_DsReplicaNeighbour_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaNeighbour *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaNeighbour_get_naming_context_obj_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaNeighbour *object = pytalloc_get_ptr(obj);
	PyObject *py_naming_context_obj_guid;
	py_naming_context_obj_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->naming_context_obj_guid);
	return py_naming_context_obj_guid;
}

static int py_drsuapi_DsReplicaNeighbour_set_naming_context_obj_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaNeighbour *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->naming_context_obj_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->naming_context_obj_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsReplicaNeighbour_get_source_dsa_obj_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaNeighbour *object = pytalloc_get_ptr(obj);
	PyObject *py_source_dsa_obj_guid;
	py_source_dsa_obj_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->source_dsa_obj_guid);
	return py_source_dsa_obj_guid;
}

static int py_drsuapi_DsReplicaNeighbour_set_source_dsa_obj_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaNeighbour *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->source_dsa_obj_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->source_dsa_obj_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsReplicaNeighbour_get_source_dsa_invocation_id(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaNeighbour *object = pytalloc_get_ptr(obj);
	PyObject *py_source_dsa_invocation_id;
	py_source_dsa_invocation_id = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->source_dsa_invocation_id);
	return py_source_dsa_invocation_id;
}

static int py_drsuapi_DsReplicaNeighbour_set_source_dsa_invocation_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaNeighbour *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->source_dsa_invocation_id");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->source_dsa_invocation_id = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsReplicaNeighbour_get_transport_obj_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaNeighbour *object = pytalloc_get_ptr(obj);
	PyObject *py_transport_obj_guid;
	py_transport_obj_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->transport_obj_guid);
	return py_transport_obj_guid;
}

static int py_drsuapi_DsReplicaNeighbour_set_transport_obj_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaNeighbour *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->transport_obj_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->transport_obj_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsReplicaNeighbour_get_tmp_highest_usn(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaNeighbour *object = pytalloc_get_ptr(obj);
	PyObject *py_tmp_highest_usn;
	py_tmp_highest_usn = PyLong_FromUnsignedLongLong(object->tmp_highest_usn);
	return py_tmp_highest_usn;
}

static int py_drsuapi_DsReplicaNeighbour_set_tmp_highest_usn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaNeighbour *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->tmp_highest_usn");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->tmp_highest_usn));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->tmp_highest_usn = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaNeighbour_get_highest_usn(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaNeighbour *object = pytalloc_get_ptr(obj);
	PyObject *py_highest_usn;
	py_highest_usn = PyLong_FromUnsignedLongLong(object->highest_usn);
	return py_highest_usn;
}

static int py_drsuapi_DsReplicaNeighbour_set_highest_usn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaNeighbour *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->highest_usn");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->highest_usn));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->highest_usn = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaNeighbour_get_last_success(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaNeighbour *object = pytalloc_get_ptr(obj);
	PyObject *py_last_success;
	py_last_success = PyLong_FromUnsignedLongLong(object->last_success);
	return py_last_success;
}

static int py_drsuapi_DsReplicaNeighbour_set_last_success(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaNeighbour *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->last_success");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->last_success));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->last_success = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaNeighbour_get_last_attempt(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaNeighbour *object = pytalloc_get_ptr(obj);
	PyObject *py_last_attempt;
	py_last_attempt = PyLong_FromUnsignedLongLong(object->last_attempt);
	return py_last_attempt;
}

static int py_drsuapi_DsReplicaNeighbour_set_last_attempt(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaNeighbour *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->last_attempt");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->last_attempt));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->last_attempt = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaNeighbour_get_result_last_attempt(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaNeighbour *object = pytalloc_get_ptr(obj);
	PyObject *py_result_last_attempt;
	py_result_last_attempt = PyErr_FromWERROR(object->result_last_attempt);
	return py_result_last_attempt;
}

static int py_drsuapi_DsReplicaNeighbour_set_result_last_attempt(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaNeighbour *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->result_last_attempt");
		return -1;
	}
	object->result_last_attempt = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyObject *py_drsuapi_DsReplicaNeighbour_get_consecutive_sync_failures(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaNeighbour *object = pytalloc_get_ptr(obj);
	PyObject *py_consecutive_sync_failures;
	py_consecutive_sync_failures = PyLong_FromUnsignedLongLong((uint32_t)(object->consecutive_sync_failures));
	return py_consecutive_sync_failures;
}

static int py_drsuapi_DsReplicaNeighbour_set_consecutive_sync_failures(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaNeighbour *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->consecutive_sync_failures");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->consecutive_sync_failures));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->consecutive_sync_failures = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaNeighbour_getsetters[] = {
	{
		.name = discard_const_p(char, "naming_context_dn"),
		.get = py_drsuapi_DsReplicaNeighbour_get_naming_context_dn,
		.set = py_drsuapi_DsReplicaNeighbour_set_naming_context_dn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "source_dsa_obj_dn"),
		.get = py_drsuapi_DsReplicaNeighbour_get_source_dsa_obj_dn,
		.set = py_drsuapi_DsReplicaNeighbour_set_source_dsa_obj_dn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "source_dsa_address"),
		.get = py_drsuapi_DsReplicaNeighbour_get_source_dsa_address,
		.set = py_drsuapi_DsReplicaNeighbour_set_source_dsa_address,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "transport_obj_dn"),
		.get = py_drsuapi_DsReplicaNeighbour_get_transport_obj_dn,
		.set = py_drsuapi_DsReplicaNeighbour_set_transport_obj_dn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "replica_flags"),
		.get = py_drsuapi_DsReplicaNeighbour_get_replica_flags,
		.set = py_drsuapi_DsReplicaNeighbour_set_replica_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DrsOptions")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_drsuapi_DsReplicaNeighbour_get_reserved,
		.set = py_drsuapi_DsReplicaNeighbour_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "naming_context_obj_guid"),
		.get = py_drsuapi_DsReplicaNeighbour_get_naming_context_obj_guid,
		.set = py_drsuapi_DsReplicaNeighbour_set_naming_context_obj_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "source_dsa_obj_guid"),
		.get = py_drsuapi_DsReplicaNeighbour_get_source_dsa_obj_guid,
		.set = py_drsuapi_DsReplicaNeighbour_set_source_dsa_obj_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "source_dsa_invocation_id"),
		.get = py_drsuapi_DsReplicaNeighbour_get_source_dsa_invocation_id,
		.set = py_drsuapi_DsReplicaNeighbour_set_source_dsa_invocation_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "transport_obj_guid"),
		.get = py_drsuapi_DsReplicaNeighbour_get_transport_obj_guid,
		.set = py_drsuapi_DsReplicaNeighbour_set_transport_obj_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "tmp_highest_usn"),
		.get = py_drsuapi_DsReplicaNeighbour_get_tmp_highest_usn,
		.set = py_drsuapi_DsReplicaNeighbour_set_tmp_highest_usn,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "highest_usn"),
		.get = py_drsuapi_DsReplicaNeighbour_get_highest_usn,
		.set = py_drsuapi_DsReplicaNeighbour_set_highest_usn,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "last_success"),
		.get = py_drsuapi_DsReplicaNeighbour_get_last_success,
		.set = py_drsuapi_DsReplicaNeighbour_set_last_success,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "last_attempt"),
		.get = py_drsuapi_DsReplicaNeighbour_get_last_attempt,
		.set = py_drsuapi_DsReplicaNeighbour_set_last_attempt,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "result_last_attempt"),
		.get = py_drsuapi_DsReplicaNeighbour_get_result_last_attempt,
		.set = py_drsuapi_DsReplicaNeighbour_set_result_last_attempt,
		.doc = discard_const_p(char, "PIDL-generated element of base type WERROR")
	},
	{
		.name = discard_const_p(char, "consecutive_sync_failures"),
		.get = py_drsuapi_DsReplicaNeighbour_get_consecutive_sync_failures,
		.set = py_drsuapi_DsReplicaNeighbour_set_consecutive_sync_failures,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaNeighbour_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaNeighbour, type);
}


static PyTypeObject drsuapi_DsReplicaNeighbour_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaNeighbour",
	.tp_getset = py_drsuapi_DsReplicaNeighbour_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaNeighbour_new,
};


static PyObject *py_drsuapi_DsReplicaNeighbourCtr_get_count(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaNeighbourCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_drsuapi_DsReplicaNeighbourCtr_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaNeighbourCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaNeighbourCtr_get_reserved(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaNeighbourCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved));
	return py_reserved;
}

static int py_drsuapi_DsReplicaNeighbourCtr_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaNeighbourCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaNeighbourCtr_get_array(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaNeighbourCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	py_array = PyList_New(object->count);
	if (py_array == NULL) {
		return NULL;
	}
	{
		int array_cntr_0;
		for (array_cntr_0 = 0; array_cntr_0 < (object->count); array_cntr_0++) {
			PyObject *py_array_0;
			py_array_0 = pytalloc_reference_ex(&drsuapi_DsReplicaNeighbour_Type, object->array, &(object->array)[array_cntr_0]);
			PyList_SetItem(py_array, array_cntr_0, py_array_0);
		}
	}
	return py_array;
}

static int py_drsuapi_DsReplicaNeighbourCtr_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaNeighbourCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int array_cntr_0;
		object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
		if (!object->array) { return -1; }
		talloc_set_name_const(object->array, "ARRAY: object->array");
		for (array_cntr_0 = 0; array_cntr_0 < PyList_GET_SIZE(value); array_cntr_0++) {
			if (PyList_GET_ITEM(value, array_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&drsuapi_DsReplicaNeighbour_Type, PyList_GET_ITEM(value, array_cntr_0), return -1;);
			if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->array)[array_cntr_0] = *(struct drsuapi_DsReplicaNeighbour *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaNeighbourCtr_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_drsuapi_DsReplicaNeighbourCtr_get_count,
		.set = py_drsuapi_DsReplicaNeighbourCtr_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_drsuapi_DsReplicaNeighbourCtr_get_reserved,
		.set = py_drsuapi_DsReplicaNeighbourCtr_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_drsuapi_DsReplicaNeighbourCtr_get_array,
		.set = py_drsuapi_DsReplicaNeighbourCtr_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaNeighbour")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaNeighbourCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaNeighbourCtr, type);
}


static PyTypeObject drsuapi_DsReplicaNeighbourCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaNeighbourCtr",
	.tp_getset = py_drsuapi_DsReplicaNeighbourCtr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaNeighbourCtr_new,
};


static PyObject *py_drsuapi_DsReplicaCursorCtr_get_count(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaCursorCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_drsuapi_DsReplicaCursorCtr_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaCursorCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaCursorCtr_get_reserved(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaCursorCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved));
	return py_reserved;
}

static int py_drsuapi_DsReplicaCursorCtr_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaCursorCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaCursorCtr_get_array(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaCursorCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	py_array = PyList_New(object->count);
	if (py_array == NULL) {
		return NULL;
	}
	{
		int array_cntr_0;
		for (array_cntr_0 = 0; array_cntr_0 < (object->count); array_cntr_0++) {
			PyObject *py_array_0;
			py_array_0 = pytalloc_reference_ex(&drsuapi_DsReplicaCursor_Type, object->array, &(object->array)[array_cntr_0]);
			PyList_SetItem(py_array, array_cntr_0, py_array_0);
		}
	}
	return py_array;
}

static int py_drsuapi_DsReplicaCursorCtr_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaCursorCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int array_cntr_0;
		object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
		if (!object->array) { return -1; }
		talloc_set_name_const(object->array, "ARRAY: object->array");
		for (array_cntr_0 = 0; array_cntr_0 < PyList_GET_SIZE(value); array_cntr_0++) {
			if (PyList_GET_ITEM(value, array_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&drsuapi_DsReplicaCursor_Type, PyList_GET_ITEM(value, array_cntr_0), return -1;);
			if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->array)[array_cntr_0] = *(struct drsuapi_DsReplicaCursor *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaCursorCtr_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_drsuapi_DsReplicaCursorCtr_get_count,
		.set = py_drsuapi_DsReplicaCursorCtr_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_drsuapi_DsReplicaCursorCtr_get_reserved,
		.set = py_drsuapi_DsReplicaCursorCtr_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_drsuapi_DsReplicaCursorCtr_get_array,
		.set = py_drsuapi_DsReplicaCursorCtr_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaCursor")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaCursorCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaCursorCtr, type);
}


static PyTypeObject drsuapi_DsReplicaCursorCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaCursorCtr",
	.tp_getset = py_drsuapi_DsReplicaCursorCtr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaCursorCtr_new,
};


static PyObject *py_drsuapi_DsReplicaObjMetaData_get_attribute_name(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjMetaData *object = pytalloc_get_ptr(obj);
	PyObject *py_attribute_name;
	if (object->attribute_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->attribute_name == NULL) {
		py_attribute_name = Py_None;
		Py_INCREF(py_attribute_name);
	} else {
		if (object->attribute_name == NULL) {
			py_attribute_name = Py_None;
			Py_INCREF(py_attribute_name);
		} else {
			py_attribute_name = PyUnicode_Decode(object->attribute_name, strlen(object->attribute_name), "utf-8", "ignore");
		}
	}
	return py_attribute_name;
}

static int py_drsuapi_DsReplicaObjMetaData_set_attribute_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjMetaData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->attribute_name");
		return -1;
	}
	if (value == Py_None) {
		object->attribute_name = NULL;
	} else {
		object->attribute_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->attribute_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaObjMetaData_get_version(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjMetaData *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_drsuapi_DsReplicaObjMetaData_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjMetaData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaObjMetaData_get_originating_change_time(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjMetaData *object = pytalloc_get_ptr(obj);
	PyObject *py_originating_change_time;
	py_originating_change_time = PyLong_FromUnsignedLongLong(object->originating_change_time);
	return py_originating_change_time;
}

static int py_drsuapi_DsReplicaObjMetaData_set_originating_change_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjMetaData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->originating_change_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->originating_change_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->originating_change_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaObjMetaData_get_originating_invocation_id(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjMetaData *object = pytalloc_get_ptr(obj);
	PyObject *py_originating_invocation_id;
	py_originating_invocation_id = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->originating_invocation_id);
	return py_originating_invocation_id;
}

static int py_drsuapi_DsReplicaObjMetaData_set_originating_invocation_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjMetaData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->originating_invocation_id");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->originating_invocation_id = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsReplicaObjMetaData_get_originating_usn(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjMetaData *object = pytalloc_get_ptr(obj);
	PyObject *py_originating_usn;
	py_originating_usn = PyLong_FromUnsignedLongLong(object->originating_usn);
	return py_originating_usn;
}

static int py_drsuapi_DsReplicaObjMetaData_set_originating_usn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjMetaData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->originating_usn");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->originating_usn));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->originating_usn = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaObjMetaData_get_local_usn(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjMetaData *object = pytalloc_get_ptr(obj);
	PyObject *py_local_usn;
	py_local_usn = PyLong_FromUnsignedLongLong(object->local_usn);
	return py_local_usn;
}

static int py_drsuapi_DsReplicaObjMetaData_set_local_usn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjMetaData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->local_usn");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->local_usn));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->local_usn = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaObjMetaData_getsetters[] = {
	{
		.name = discard_const_p(char, "attribute_name"),
		.get = py_drsuapi_DsReplicaObjMetaData_get_attribute_name,
		.set = py_drsuapi_DsReplicaObjMetaData_set_attribute_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "version"),
		.get = py_drsuapi_DsReplicaObjMetaData_get_version,
		.set = py_drsuapi_DsReplicaObjMetaData_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "originating_change_time"),
		.get = py_drsuapi_DsReplicaObjMetaData_get_originating_change_time,
		.set = py_drsuapi_DsReplicaObjMetaData_set_originating_change_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "originating_invocation_id"),
		.get = py_drsuapi_DsReplicaObjMetaData_get_originating_invocation_id,
		.set = py_drsuapi_DsReplicaObjMetaData_set_originating_invocation_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "originating_usn"),
		.get = py_drsuapi_DsReplicaObjMetaData_get_originating_usn,
		.set = py_drsuapi_DsReplicaObjMetaData_set_originating_usn,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "local_usn"),
		.get = py_drsuapi_DsReplicaObjMetaData_get_local_usn,
		.set = py_drsuapi_DsReplicaObjMetaData_set_local_usn,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaObjMetaData_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaObjMetaData, type);
}


static PyTypeObject drsuapi_DsReplicaObjMetaData_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaObjMetaData",
	.tp_getset = py_drsuapi_DsReplicaObjMetaData_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaObjMetaData_new,
};


static PyObject *py_drsuapi_DsReplicaObjMetaDataCtr_get_count(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjMetaDataCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_drsuapi_DsReplicaObjMetaDataCtr_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjMetaDataCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaObjMetaDataCtr_get_reserved(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjMetaDataCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved));
	return py_reserved;
}

static int py_drsuapi_DsReplicaObjMetaDataCtr_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjMetaDataCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaObjMetaDataCtr_get_array(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaObjMetaDataCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	py_array = PyList_New(object->count);
	if (py_array == NULL) {
		return NULL;
	}
	{
		int array_cntr_0;
		for (array_cntr_0 = 0; array_cntr_0 < (object->count); array_cntr_0++) {
			PyObject *py_array_0;
			py_array_0 = pytalloc_reference_ex(&drsuapi_DsReplicaObjMetaData_Type, object->array, &(object->array)[array_cntr_0]);
			PyList_SetItem(py_array, array_cntr_0, py_array_0);
		}
	}
	return py_array;
}

static int py_drsuapi_DsReplicaObjMetaDataCtr_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaObjMetaDataCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int array_cntr_0;
		object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
		if (!object->array) { return -1; }
		talloc_set_name_const(object->array, "ARRAY: object->array");
		for (array_cntr_0 = 0; array_cntr_0 < PyList_GET_SIZE(value); array_cntr_0++) {
			if (PyList_GET_ITEM(value, array_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&drsuapi_DsReplicaObjMetaData_Type, PyList_GET_ITEM(value, array_cntr_0), return -1;);
			if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->array)[array_cntr_0] = *(struct drsuapi_DsReplicaObjMetaData *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaObjMetaDataCtr_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_drsuapi_DsReplicaObjMetaDataCtr_get_count,
		.set = py_drsuapi_DsReplicaObjMetaDataCtr_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_drsuapi_DsReplicaObjMetaDataCtr_get_reserved,
		.set = py_drsuapi_DsReplicaObjMetaDataCtr_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_drsuapi_DsReplicaObjMetaDataCtr_get_array,
		.set = py_drsuapi_DsReplicaObjMetaDataCtr_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaObjMetaData")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaObjMetaDataCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaObjMetaDataCtr, type);
}


static PyTypeObject drsuapi_DsReplicaObjMetaDataCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaObjMetaDataCtr",
	.tp_getset = py_drsuapi_DsReplicaObjMetaDataCtr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaObjMetaDataCtr_new,
};


static PyObject *py_drsuapi_DsReplicaKccDsaFailure_get_dsa_obj_dn(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaKccDsaFailure *object = pytalloc_get_ptr(obj);
	PyObject *py_dsa_obj_dn;
	if (object->dsa_obj_dn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->dsa_obj_dn == NULL) {
		py_dsa_obj_dn = Py_None;
		Py_INCREF(py_dsa_obj_dn);
	} else {
		if (object->dsa_obj_dn == NULL) {
			py_dsa_obj_dn = Py_None;
			Py_INCREF(py_dsa_obj_dn);
		} else {
			py_dsa_obj_dn = PyUnicode_Decode(object->dsa_obj_dn, strlen(object->dsa_obj_dn), "utf-8", "ignore");
		}
	}
	return py_dsa_obj_dn;
}

static int py_drsuapi_DsReplicaKccDsaFailure_set_dsa_obj_dn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaKccDsaFailure *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dsa_obj_dn");
		return -1;
	}
	if (value == Py_None) {
		object->dsa_obj_dn = NULL;
	} else {
		object->dsa_obj_dn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->dsa_obj_dn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaKccDsaFailure_get_dsa_obj_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaKccDsaFailure *object = pytalloc_get_ptr(obj);
	PyObject *py_dsa_obj_guid;
	py_dsa_obj_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->dsa_obj_guid);
	return py_dsa_obj_guid;
}

static int py_drsuapi_DsReplicaKccDsaFailure_set_dsa_obj_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaKccDsaFailure *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dsa_obj_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dsa_obj_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsReplicaKccDsaFailure_get_first_failure(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaKccDsaFailure *object = pytalloc_get_ptr(obj);
	PyObject *py_first_failure;
	py_first_failure = PyLong_FromUnsignedLongLong(object->first_failure);
	return py_first_failure;
}

static int py_drsuapi_DsReplicaKccDsaFailure_set_first_failure(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaKccDsaFailure *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->first_failure");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->first_failure));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->first_failure = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaKccDsaFailure_get_num_failures(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaKccDsaFailure *object = pytalloc_get_ptr(obj);
	PyObject *py_num_failures;
	py_num_failures = PyLong_FromUnsignedLongLong((uint32_t)(object->num_failures));
	return py_num_failures;
}

static int py_drsuapi_DsReplicaKccDsaFailure_set_num_failures(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaKccDsaFailure *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_failures");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_failures));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_failures = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaKccDsaFailure_get_last_result(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaKccDsaFailure *object = pytalloc_get_ptr(obj);
	PyObject *py_last_result;
	py_last_result = PyErr_FromWERROR(object->last_result);
	return py_last_result;
}

static int py_drsuapi_DsReplicaKccDsaFailure_set_last_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaKccDsaFailure *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->last_result");
		return -1;
	}
	object->last_result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaKccDsaFailure_getsetters[] = {
	{
		.name = discard_const_p(char, "dsa_obj_dn"),
		.get = py_drsuapi_DsReplicaKccDsaFailure_get_dsa_obj_dn,
		.set = py_drsuapi_DsReplicaKccDsaFailure_set_dsa_obj_dn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "dsa_obj_guid"),
		.get = py_drsuapi_DsReplicaKccDsaFailure_get_dsa_obj_guid,
		.set = py_drsuapi_DsReplicaKccDsaFailure_set_dsa_obj_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "first_failure"),
		.get = py_drsuapi_DsReplicaKccDsaFailure_get_first_failure,
		.set = py_drsuapi_DsReplicaKccDsaFailure_set_first_failure,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "num_failures"),
		.get = py_drsuapi_DsReplicaKccDsaFailure_get_num_failures,
		.set = py_drsuapi_DsReplicaKccDsaFailure_set_num_failures,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "last_result"),
		.get = py_drsuapi_DsReplicaKccDsaFailure_get_last_result,
		.set = py_drsuapi_DsReplicaKccDsaFailure_set_last_result,
		.doc = discard_const_p(char, "PIDL-generated element of base type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaKccDsaFailure_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaKccDsaFailure, type);
}


static PyTypeObject drsuapi_DsReplicaKccDsaFailure_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaKccDsaFailure",
	.tp_getset = py_drsuapi_DsReplicaKccDsaFailure_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaKccDsaFailure_new,
};


static PyObject *py_drsuapi_DsReplicaKccDsaFailuresCtr_get_count(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaKccDsaFailuresCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_drsuapi_DsReplicaKccDsaFailuresCtr_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaKccDsaFailuresCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaKccDsaFailuresCtr_get_reserved(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaKccDsaFailuresCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved));
	return py_reserved;
}

static int py_drsuapi_DsReplicaKccDsaFailuresCtr_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaKccDsaFailuresCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaKccDsaFailuresCtr_get_array(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaKccDsaFailuresCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	py_array = PyList_New(object->count);
	if (py_array == NULL) {
		return NULL;
	}
	{
		int array_cntr_0;
		for (array_cntr_0 = 0; array_cntr_0 < (object->count); array_cntr_0++) {
			PyObject *py_array_0;
			py_array_0 = pytalloc_reference_ex(&drsuapi_DsReplicaKccDsaFailure_Type, object->array, &(object->array)[array_cntr_0]);
			PyList_SetItem(py_array, array_cntr_0, py_array_0);
		}
	}
	return py_array;
}

static int py_drsuapi_DsReplicaKccDsaFailuresCtr_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaKccDsaFailuresCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int array_cntr_0;
		object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
		if (!object->array) { return -1; }
		talloc_set_name_const(object->array, "ARRAY: object->array");
		for (array_cntr_0 = 0; array_cntr_0 < PyList_GET_SIZE(value); array_cntr_0++) {
			if (PyList_GET_ITEM(value, array_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&drsuapi_DsReplicaKccDsaFailure_Type, PyList_GET_ITEM(value, array_cntr_0), return -1;);
			if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->array)[array_cntr_0] = *(struct drsuapi_DsReplicaKccDsaFailure *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaKccDsaFailuresCtr_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_drsuapi_DsReplicaKccDsaFailuresCtr_get_count,
		.set = py_drsuapi_DsReplicaKccDsaFailuresCtr_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_drsuapi_DsReplicaKccDsaFailuresCtr_get_reserved,
		.set = py_drsuapi_DsReplicaKccDsaFailuresCtr_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_drsuapi_DsReplicaKccDsaFailuresCtr_get_array,
		.set = py_drsuapi_DsReplicaKccDsaFailuresCtr_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaKccDsaFailure")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaKccDsaFailuresCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaKccDsaFailuresCtr, type);
}


static PyTypeObject drsuapi_DsReplicaKccDsaFailuresCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaKccDsaFailuresCtr",
	.tp_getset = py_drsuapi_DsReplicaKccDsaFailuresCtr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaKccDsaFailuresCtr_new,
};


static PyObject *py_drsuapi_DsReplicaOp_get_operation_start(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaOp *object = pytalloc_get_ptr(obj);
	PyObject *py_operation_start;
	py_operation_start = PyLong_FromUnsignedLongLong(object->operation_start);
	return py_operation_start;
}

static int py_drsuapi_DsReplicaOp_set_operation_start(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaOp *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->operation_start");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->operation_start));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->operation_start = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaOp_get_serial_num(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaOp *object = pytalloc_get_ptr(obj);
	PyObject *py_serial_num;
	py_serial_num = PyLong_FromUnsignedLongLong((uint32_t)(object->serial_num));
	return py_serial_num;
}

static int py_drsuapi_DsReplicaOp_set_serial_num(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaOp *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->serial_num");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->serial_num));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->serial_num = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaOp_get_priority(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaOp *object = pytalloc_get_ptr(obj);
	PyObject *py_priority;
	py_priority = PyLong_FromUnsignedLongLong((uint32_t)(object->priority));
	return py_priority;
}

static int py_drsuapi_DsReplicaOp_set_priority(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaOp *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->priority");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->priority));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->priority = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaOp_get_operation_type(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaOp *object = pytalloc_get_ptr(obj);
	PyObject *py_operation_type;
	py_operation_type = PyLong_FromLong((uint16_t)(object->operation_type));
	return py_operation_type;
}

static int py_drsuapi_DsReplicaOp_set_operation_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaOp *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->operation_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->operation_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->operation_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaOp_get_options(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaOp *object = pytalloc_get_ptr(obj);
	PyObject *py_options;
	py_options = PyLong_FromUnsignedLongLong((uint32_t)(object->options));
	return py_options;
}

static int py_drsuapi_DsReplicaOp_set_options(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaOp *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->options");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->options));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->options = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaOp_get_nc_dn(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaOp *object = pytalloc_get_ptr(obj);
	PyObject *py_nc_dn;
	if (object->nc_dn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->nc_dn == NULL) {
		py_nc_dn = Py_None;
		Py_INCREF(py_nc_dn);
	} else {
		if (object->nc_dn == NULL) {
			py_nc_dn = Py_None;
			Py_INCREF(py_nc_dn);
		} else {
			py_nc_dn = PyUnicode_Decode(object->nc_dn, strlen(object->nc_dn), "utf-8", "ignore");
		}
	}
	return py_nc_dn;
}

static int py_drsuapi_DsReplicaOp_set_nc_dn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaOp *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->nc_dn");
		return -1;
	}
	if (value == Py_None) {
		object->nc_dn = NULL;
	} else {
		object->nc_dn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->nc_dn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaOp_get_remote_dsa_obj_dn(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaOp *object = pytalloc_get_ptr(obj);
	PyObject *py_remote_dsa_obj_dn;
	if (object->remote_dsa_obj_dn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->remote_dsa_obj_dn == NULL) {
		py_remote_dsa_obj_dn = Py_None;
		Py_INCREF(py_remote_dsa_obj_dn);
	} else {
		if (object->remote_dsa_obj_dn == NULL) {
			py_remote_dsa_obj_dn = Py_None;
			Py_INCREF(py_remote_dsa_obj_dn);
		} else {
			py_remote_dsa_obj_dn = PyUnicode_Decode(object->remote_dsa_obj_dn, strlen(object->remote_dsa_obj_dn), "utf-8", "ignore");
		}
	}
	return py_remote_dsa_obj_dn;
}

static int py_drsuapi_DsReplicaOp_set_remote_dsa_obj_dn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaOp *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->remote_dsa_obj_dn");
		return -1;
	}
	if (value == Py_None) {
		object->remote_dsa_obj_dn = NULL;
	} else {
		object->remote_dsa_obj_dn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->remote_dsa_obj_dn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaOp_get_remote_dsa_address(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaOp *object = pytalloc_get_ptr(obj);
	PyObject *py_remote_dsa_address;
	if (object->remote_dsa_address == NULL) {
		Py_RETURN_NONE;
	}
	if (object->remote_dsa_address == NULL) {
		py_remote_dsa_address = Py_None;
		Py_INCREF(py_remote_dsa_address);
	} else {
		if (object->remote_dsa_address == NULL) {
			py_remote_dsa_address = Py_None;
			Py_INCREF(py_remote_dsa_address);
		} else {
			py_remote_dsa_address = PyUnicode_Decode(object->remote_dsa_address, strlen(object->remote_dsa_address), "utf-8", "ignore");
		}
	}
	return py_remote_dsa_address;
}

static int py_drsuapi_DsReplicaOp_set_remote_dsa_address(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaOp *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->remote_dsa_address");
		return -1;
	}
	if (value == Py_None) {
		object->remote_dsa_address = NULL;
	} else {
		object->remote_dsa_address = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->remote_dsa_address = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaOp_get_nc_obj_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaOp *object = pytalloc_get_ptr(obj);
	PyObject *py_nc_obj_guid;
	py_nc_obj_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->nc_obj_guid);
	return py_nc_obj_guid;
}

static int py_drsuapi_DsReplicaOp_set_nc_obj_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaOp *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->nc_obj_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->nc_obj_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsReplicaOp_get_remote_dsa_obj_guid(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaOp *object = pytalloc_get_ptr(obj);
	PyObject *py_remote_dsa_obj_guid;
	py_remote_dsa_obj_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->remote_dsa_obj_guid);
	return py_remote_dsa_obj_guid;
}

static int py_drsuapi_DsReplicaOp_set_remote_dsa_obj_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaOp *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->remote_dsa_obj_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->remote_dsa_obj_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaOp_getsetters[] = {
	{
		.name = discard_const_p(char, "operation_start"),
		.get = py_drsuapi_DsReplicaOp_get_operation_start,
		.set = py_drsuapi_DsReplicaOp_set_operation_start,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "serial_num"),
		.get = py_drsuapi_DsReplicaOp_get_serial_num,
		.set = py_drsuapi_DsReplicaOp_set_serial_num,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "priority"),
		.get = py_drsuapi_DsReplicaOp_get_priority,
		.set = py_drsuapi_DsReplicaOp_set_priority,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "operation_type"),
		.get = py_drsuapi_DsReplicaOp_get_operation_type,
		.set = py_drsuapi_DsReplicaOp_set_operation_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaOpType")
	},
	{
		.name = discard_const_p(char, "options"),
		.get = py_drsuapi_DsReplicaOp_get_options,
		.set = py_drsuapi_DsReplicaOp_set_options,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DrsOptions")
	},
	{
		.name = discard_const_p(char, "nc_dn"),
		.get = py_drsuapi_DsReplicaOp_get_nc_dn,
		.set = py_drsuapi_DsReplicaOp_set_nc_dn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "remote_dsa_obj_dn"),
		.get = py_drsuapi_DsReplicaOp_get_remote_dsa_obj_dn,
		.set = py_drsuapi_DsReplicaOp_set_remote_dsa_obj_dn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "remote_dsa_address"),
		.get = py_drsuapi_DsReplicaOp_get_remote_dsa_address,
		.set = py_drsuapi_DsReplicaOp_set_remote_dsa_address,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "nc_obj_guid"),
		.get = py_drsuapi_DsReplicaOp_get_nc_obj_guid,
		.set = py_drsuapi_DsReplicaOp_set_nc_obj_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "remote_dsa_obj_guid"),
		.get = py_drsuapi_DsReplicaOp_get_remote_dsa_obj_guid,
		.set = py_drsuapi_DsReplicaOp_set_remote_dsa_obj_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaOp_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaOp, type);
}


static PyTypeObject drsuapi_DsReplicaOp_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaOp",
	.tp_getset = py_drsuapi_DsReplicaOp_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaOp_new,
};


static PyObject *py_drsuapi_DsReplicaOpCtr_get_time(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaOpCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_time;
	py_time = PyLong_FromUnsignedLongLong(object->time);
	return py_time;
}

static int py_drsuapi_DsReplicaOpCtr_set_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaOpCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaOpCtr_get_count(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaOpCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_drsuapi_DsReplicaOpCtr_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaOpCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaOpCtr_get_array(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaOpCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	py_array = PyList_New(object->count);
	if (py_array == NULL) {
		return NULL;
	}
	{
		int array_cntr_0;
		for (array_cntr_0 = 0; array_cntr_0 < (object->count); array_cntr_0++) {
			PyObject *py_array_0;
			py_array_0 = pytalloc_reference_ex(&drsuapi_DsReplicaOp_Type, object->array, &(object->array)[array_cntr_0]);
			PyList_SetItem(py_array, array_cntr_0, py_array_0);
		}
	}
	return py_array;
}

static int py_drsuapi_DsReplicaOpCtr_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaOpCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int array_cntr_0;
		object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
		if (!object->array) { return -1; }
		talloc_set_name_const(object->array, "ARRAY: object->array");
		for (array_cntr_0 = 0; array_cntr_0 < PyList_GET_SIZE(value); array_cntr_0++) {
			if (PyList_GET_ITEM(value, array_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&drsuapi_DsReplicaOp_Type, PyList_GET_ITEM(value, array_cntr_0), return -1;);
			if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->array)[array_cntr_0] = *(struct drsuapi_DsReplicaOp *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaOpCtr_getsetters[] = {
	{
		.name = discard_const_p(char, "time"),
		.get = py_drsuapi_DsReplicaOpCtr_get_time,
		.set = py_drsuapi_DsReplicaOpCtr_set_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "count"),
		.get = py_drsuapi_DsReplicaOpCtr_get_count,
		.set = py_drsuapi_DsReplicaOpCtr_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_drsuapi_DsReplicaOpCtr_get_array,
		.set = py_drsuapi_DsReplicaOpCtr_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaOp")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaOpCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaOpCtr, type);
}


static PyTypeObject drsuapi_DsReplicaOpCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaOpCtr",
	.tp_getset = py_drsuapi_DsReplicaOpCtr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaOpCtr_new,
};


static PyObject *py_drsuapi_DsReplicaAttrValMetaData_get_attribute_name(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaAttrValMetaData *object = pytalloc_get_ptr(obj);
	PyObject *py_attribute_name;
	if (object->attribute_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->attribute_name == NULL) {
		py_attribute_name = Py_None;
		Py_INCREF(py_attribute_name);
	} else {
		if (object->attribute_name == NULL) {
			py_attribute_name = Py_None;
			Py_INCREF(py_attribute_name);
		} else {
			py_attribute_name = PyUnicode_Decode(object->attribute_name, strlen(object->attribute_name), "utf-8", "ignore");
		}
	}
	return py_attribute_name;
}

static int py_drsuapi_DsReplicaAttrValMetaData_set_attribute_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaAttrValMetaData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->attribute_name");
		return -1;
	}
	if (value == Py_None) {
		object->attribute_name = NULL;
	} else {
		object->attribute_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->attribute_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaAttrValMetaData_get_object_dn(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaAttrValMetaData *object = pytalloc_get_ptr(obj);
	PyObject *py_object_dn;
	if (object->object_dn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->object_dn == NULL) {
		py_object_dn = Py_None;
		Py_INCREF(py_object_dn);
	} else {
		if (object->object_dn == NULL) {
			py_object_dn = Py_None;
			Py_INCREF(py_object_dn);
		} else {
			py_object_dn = PyUnicode_Decode(object->object_dn, strlen(object->object_dn), "utf-8", "ignore");
		}
	}
	return py_object_dn;
}

static int py_drsuapi_DsReplicaAttrValMetaData_set_object_dn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaAttrValMetaData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->object_dn");
		return -1;
	}
	if (value == Py_None) {
		object->object_dn = NULL;
	} else {
		object->object_dn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->object_dn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaAttrValMetaData_get___ndr_size_binary(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaAttrValMetaData *object = pytalloc_get_ptr(obj);
	PyObject *py___ndr_size_binary;
	py___ndr_size_binary = PyLong_FromUnsignedLongLong((uint32_t)(object->__ndr_size_binary));
	return py___ndr_size_binary;
}

static int py_drsuapi_DsReplicaAttrValMetaData_set___ndr_size_binary(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaAttrValMetaData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->__ndr_size_binary");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->__ndr_size_binary));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->__ndr_size_binary = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaAttrValMetaData_get_binary(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaAttrValMetaData *object = pytalloc_get_ptr(obj);
	PyObject *py_binary;
	if (object->binary == NULL) {
		Py_RETURN_NONE;
	}
	if (object->binary == NULL) {
		py_binary = Py_None;
		Py_INCREF(py_binary);
	} else {
		py_binary = PyBytes_FromStringAndSize((char *)(*object->binary).data, (*object->binary).length);
	}
	return py_binary;
}

static int py_drsuapi_DsReplicaAttrValMetaData_set_binary(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaAttrValMetaData *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->binary));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->binary");
		return -1;
	}
	if (value == Py_None) {
		object->binary = NULL;
	} else {
		object->binary = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->binary);
		if (object->binary == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		*object->binary = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaAttrValMetaData_get_deleted(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaAttrValMetaData *object = pytalloc_get_ptr(obj);
	PyObject *py_deleted;
	py_deleted = PyLong_FromUnsignedLongLong(object->deleted);
	return py_deleted;
}

static int py_drsuapi_DsReplicaAttrValMetaData_set_deleted(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaAttrValMetaData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->deleted");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->deleted));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->deleted = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaAttrValMetaData_get_created(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaAttrValMetaData *object = pytalloc_get_ptr(obj);
	PyObject *py_created;
	py_created = PyLong_FromUnsignedLongLong(object->created);
	return py_created;
}

static int py_drsuapi_DsReplicaAttrValMetaData_set_created(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaAttrValMetaData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->created");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->created));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->created = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaAttrValMetaData_get_version(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaAttrValMetaData *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_drsuapi_DsReplicaAttrValMetaData_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaAttrValMetaData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaAttrValMetaData_get_originating_change_time(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaAttrValMetaData *object = pytalloc_get_ptr(obj);
	PyObject *py_originating_change_time;
	py_originating_change_time = PyLong_FromUnsignedLongLong(object->originating_change_time);
	return py_originating_change_time;
}

static int py_drsuapi_DsReplicaAttrValMetaData_set_originating_change_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaAttrValMetaData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->originating_change_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->originating_change_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->originating_change_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaAttrValMetaData_get_originating_invocation_id(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaAttrValMetaData *object = pytalloc_get_ptr(obj);
	PyObject *py_originating_invocation_id;
	py_originating_invocation_id = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->originating_invocation_id);
	return py_originating_invocation_id;
}

static int py_drsuapi_DsReplicaAttrValMetaData_set_originating_invocation_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaAttrValMetaData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->originating_invocation_id");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->originating_invocation_id = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_drsuapi_DsReplicaAttrValMetaData_get_originating_usn(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaAttrValMetaData *object = pytalloc_get_ptr(obj);
	PyObject *py_originating_usn;
	py_originating_usn = PyLong_FromUnsignedLongLong(object->originating_usn);
	return py_originating_usn;
}

static int py_drsuapi_DsReplicaAttrValMetaData_set_originating_usn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaAttrValMetaData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->originating_usn");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->originating_usn));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->originating_usn = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaAttrValMetaData_get_local_usn(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaAttrValMetaData *object = pytalloc_get_ptr(obj);
	PyObject *py_local_usn;
	py_local_usn = PyLong_FromUnsignedLongLong(object->local_usn);
	return py_local_usn;
}

static int py_drsuapi_DsReplicaAttrValMetaData_set_local_usn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaAttrValMetaData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->local_usn");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->local_usn));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->local_usn = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaAttrValMetaData_getsetters[] = {
	{
		.name = discard_const_p(char, "attribute_name"),
		.get = py_drsuapi_DsReplicaAttrValMetaData_get_attribute_name,
		.set = py_drsuapi_DsReplicaAttrValMetaData_set_attribute_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "object_dn"),
		.get = py_drsuapi_DsReplicaAttrValMetaData_get_object_dn,
		.set = py_drsuapi_DsReplicaAttrValMetaData_set_object_dn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "__ndr_size_binary"),
		.get = py_drsuapi_DsReplicaAttrValMetaData_get___ndr_size_binary,
		.set = py_drsuapi_DsReplicaAttrValMetaData_set___ndr_size_binary,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "binary"),
		.get = py_drsuapi_DsReplicaAttrValMetaData_get_binary,
		.set = py_drsuapi_DsReplicaAttrValMetaData_set_binary,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{
		.name = discard_const_p(char, "deleted"),
		.get = py_drsuapi_DsReplicaAttrValMetaData_get_deleted,
		.set = py_drsuapi_DsReplicaAttrValMetaData_set_deleted,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "created"),
		.get = py_drsuapi_DsReplicaAttrValMetaData_get_created,
		.set = py_drsuapi_DsReplicaAttrValMetaData_set_created,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "version"),
		.get = py_drsuapi_DsReplicaAttrValMetaData_get_version,
		.set = py_drsuapi_DsReplicaAttrValMetaData_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "originating_change_time"),
		.get = py_drsuapi_DsReplicaAttrValMetaData_get_originating_change_time,
		.set = py_drsuapi_DsReplicaAttrValMetaData_set_originating_change_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "originating_invocation_id"),
		.get = py_drsuapi_DsReplicaAttrValMetaData_get_originating_invocation_id,
		.set = py_drsuapi_DsReplicaAttrValMetaData_set_originating_invocation_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "originating_usn"),
		.get = py_drsuapi_DsReplicaAttrValMetaData_get_originating_usn,
		.set = py_drsuapi_DsReplicaAttrValMetaData_set_originating_usn,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "local_usn"),
		.get = py_drsuapi_DsReplicaAttrValMetaData_get_local_usn,
		.set = py_drsuapi_DsReplicaAttrValMetaData_set_local_usn,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaAttrValMetaData_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaAttrValMetaData, type);
}


static PyTypeObject drsuapi_DsReplicaAttrValMetaData_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaAttrValMetaData",
	.tp_getset = py_drsuapi_DsReplicaAttrValMetaData_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaAttrValMetaData_new,
};


static PyObject *py_drsuapi_DsReplicaAttrValMetaDataCtr_get_count(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaAttrValMetaDataCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_drsuapi_DsReplicaAttrValMetaDataCtr_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaAttrValMetaDataCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaAttrValMetaDataCtr_get_enumeration_context(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaAttrValMetaDataCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_enumeration_context;
	py_enumeration_context = PyLong_FromUnsignedLongLong((uint32_t)(object->enumeration_context));
	return py_enumeration_context;
}

static int py_drsuapi_DsReplicaAttrValMetaDataCtr_set_enumeration_context(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaAttrValMetaDataCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->enumeration_context");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->enumeration_context));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->enumeration_context = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaAttrValMetaDataCtr_get_array(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaAttrValMetaDataCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	py_array = PyList_New(object->count);
	if (py_array == NULL) {
		return NULL;
	}
	{
		int array_cntr_0;
		for (array_cntr_0 = 0; array_cntr_0 < (object->count); array_cntr_0++) {
			PyObject *py_array_0;
			py_array_0 = pytalloc_reference_ex(&drsuapi_DsReplicaAttrValMetaData_Type, object->array, &(object->array)[array_cntr_0]);
			PyList_SetItem(py_array, array_cntr_0, py_array_0);
		}
	}
	return py_array;
}

static int py_drsuapi_DsReplicaAttrValMetaDataCtr_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaAttrValMetaDataCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int array_cntr_0;
		object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
		if (!object->array) { return -1; }
		talloc_set_name_const(object->array, "ARRAY: object->array");
		for (array_cntr_0 = 0; array_cntr_0 < PyList_GET_SIZE(value); array_cntr_0++) {
			if (PyList_GET_ITEM(value, array_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&drsuapi_DsReplicaAttrValMetaData_Type, PyList_GET_ITEM(value, array_cntr_0), return -1;);
			if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->array)[array_cntr_0] = *(struct drsuapi_DsReplicaAttrValMetaData *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_DsReplicaAttrValMetaDataCtr_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_drsuapi_DsReplicaAttrValMetaDataCtr_get_count,
		.set = py_drsuapi_DsReplicaAttrValMetaDataCtr_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "enumeration_context"),
		.get = py_drsuapi_DsReplicaAttrValMetaDataCtr_get_enumeration_context,
		.set = py_drsuapi_DsReplicaAttrValMetaDataCtr_set_enumeration_context,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_drsuapi_DsReplicaAttrValMetaDataCtr_get_array,
		.set = py_drsuapi_DsReplicaAttrValMetaDataCtr_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaAttrValMetaData")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_DsReplicaAttrValMetaDataCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_DsReplicaAttrValMetaDataCtr, type);
}


static PyTypeObject drsuapi_DsReplicaAttrValMetaDataCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsuapi.DsReplicaAttrValMetaDataCtr",
	.tp_getset = py_drsuapi_DsReplicaAttrValMetaDataCtr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_DsReplicaAttrValMetaDataCtr_new,
};


static PyObject *py_drsuapi_DsReplicaCursor2Ctr_get_count(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaCursor2Ctr *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_drsuapi_DsReplicaCursor2Ctr_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaCursor2Ctr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaCursor2Ctr_get_enumeration_context(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaCursor2Ctr *object = pytalloc_get_ptr(obj);
	PyObject *py_enumeration_context;
	py_enumeration_context = PyLong_FromUnsignedLongLong((uint32_t)(object->enumeration_context));
	return py_enumeration_context;
}

static int py_drsuapi_DsReplicaCursor2Ctr_set_enumeration_context(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaCursor2Ctr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->enumeration_context");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->enumeration_context));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->enumeration_context = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_DsReplicaCursor2Ctr_get_array(PyObject *obj, void *closure)
{
	struct drsuapi_DsReplicaCursor2Ctr *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	py_array = PyList_New(object->count);
	if (py_array == NULL) {
		return NULL;
	}
	{
		int array_cntr_0;
		for (array_cntr_0 = 0; array_cntr_0 < (object->count); array_cntr_0++) {
			PyObject *py_array_0;
			py_array_0 = pytalloc_reference_ex(&drsuapi_DsReplicaCursor2_Type, object->array, &(object->array)[array_cntr_0]);
			PyList_SetItem(py_array, array_cntr_0, py_array_0);
		}
	}
	return py_array;
}

static int py_drsuapi_DsReplicaCursor2Ctr_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_DsReplicaCursor2Ctr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int array_cntr_0;
		object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
		if (!object->array) { return -1; }
		talloc_set_name_const(object->array, "ARRAY: object->array");
		for (array_cntr_0 = 0; array_cntr_0 < PyList