/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// EnvVarSourceApplyConfiguration represents a declarative configuration of the EnvVarSource type for use
// with apply.
//
// EnvVarSource represents a source for the value of an EnvVar.
type EnvVarSourceApplyConfiguration struct {
	// Selects a field of the pod: supports metadata.name, metadata.namespace, `metadata.labels['<KEY>']`, `metadata.annotations['<KEY>']`,
	// spec.nodeName, spec.serviceAccountName, status.hostIP, status.podIP, status.podIPs.
	FieldRef *ObjectFieldSelectorApplyConfiguration `json:"fieldRef,omitempty"`
	// Selects a resource of the container: only resources limits and requests
	// (limits.cpu, limits.memory, limits.ephemeral-storage, requests.cpu, requests.memory and requests.ephemeral-storage) are currently supported.
	ResourceFieldRef *ResourceFieldSelectorApplyConfiguration `json:"resourceFieldRef,omitempty"`
	// Selects a key of a ConfigMap.
	ConfigMapKeyRef *ConfigMapKeySelectorApplyConfiguration `json:"configMapKeyRef,omitempty"`
	// Selects a key of a secret in the pod's namespace
	SecretKeyRef *SecretKeySelectorApplyConfiguration `json:"secretKeyRef,omitempty"`
	// FileKeyRef selects a key of the env file.
	// Requires the EnvFiles feature gate to be enabled.
	FileKeyRef *FileKeySelectorApplyConfiguration `json:"fileKeyRef,omitempty"`
}

// EnvVarSourceApplyConfiguration constructs a declarative configuration of the EnvVarSource type for use with
// apply.
func EnvVarSource() *EnvVarSourceApplyConfiguration {
	return &EnvVarSourceApplyConfiguration{}
}

// WithFieldRef sets the FieldRef field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the FieldRef field is set to the value of the last call.
func (b *EnvVarSourceApplyConfiguration) WithFieldRef(value *ObjectFieldSelectorApplyConfiguration) *EnvVarSourceApplyConfiguration {
	b.FieldRef = value
	return b
}

// WithResourceFieldRef sets the ResourceFieldRef field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ResourceFieldRef field is set to the value of the last call.
func (b *EnvVarSourceApplyConfiguration) WithResourceFieldRef(value *ResourceFieldSelectorApplyConfiguration) *EnvVarSourceApplyConfiguration {
	b.ResourceFieldRef = value
	return b
}

// WithConfigMapKeyRef sets the ConfigMapKeyRef field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ConfigMapKeyRef field is set to the value of the last call.
func (b *EnvVarSourceApplyConfiguration) WithConfigMapKeyRef(value *ConfigMapKeySelectorApplyConfiguration) *EnvVarSourceApplyConfiguration {
	b.ConfigMapKeyRef = value
	return b
}

// WithSecretKeyRef sets the SecretKeyRef field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SecretKeyRef field is set to the value of the last call.
func (b *EnvVarSourceApplyConfiguration) WithSecretKeyRef(value *SecretKeySelectorApplyConfiguration) *EnvVarSourceApplyConfiguration {
	b.SecretKeyRef = value
	return b
}

// WithFileKeyRef sets the FileKeyRef field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the FileKeyRef field is set to the value of the last call.
func (b *EnvVarSourceApplyConfiguration) WithFileKeyRef(value *FileKeySelectorApplyConfiguration) *EnvVarSourceApplyConfiguration {
	b.FileKeyRef = value
	return b
}
