/* OSDNotify.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from OSDNotify.vala, do not modify */

/*
 * OSDNotify.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define OSD_NOTIFY_NOTIFICATION_INTERVAL 3
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_OSD_NOTIFY (osd_notify_get_type ())
#define OSD_NOTIFY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_OSD_NOTIFY, OSDNotify))
#define OSD_NOTIFY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_OSD_NOTIFY, OSDNotifyClass))
#define IS_OSD_NOTIFY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_OSD_NOTIFY))
#define IS_OSD_NOTIFY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_OSD_NOTIFY))
#define OSD_NOTIFY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_OSD_NOTIFY, OSDNotifyClass))

typedef struct _OSDNotify OSDNotify;
typedef struct _OSDNotifyClass OSDNotifyClass;
typedef struct _OSDNotifyPrivate OSDNotifyPrivate;
enum  {
	OSD_NOTIFY_0_PROPERTY,
	OSD_NOTIFY_NUM_PROPERTIES
};
static GParamSpec* osd_notify_properties[OSD_NOTIFY_NUM_PROPERTIES];
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _OSDNotify {
	GObject parent_instance;
	OSDNotifyPrivate * priv;
};

struct _OSDNotifyClass {
	GObjectClass parent_class;
};

static gpointer osd_notify_parent_class = NULL;
static GDateTime* osd_notify_dt_last_notification;
static GDateTime* osd_notify_dt_last_notification = NULL;

VALA_EXTERN GType osd_notify_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (OSDNotify, g_object_unref)
VALA_EXTERN gint osd_notify_notify_send (const gchar* title,
                             const gchar* message,
                             gint durationMillis,
                             const gchar* urgency,
                             const gchar* dialog_type);
VALA_EXTERN gboolean osd_notify_is_supported (void);
VALA_EXTERN gint tee_jee_process_helper_exec_user_async (const gchar* command);
VALA_EXTERN gboolean tee_jee_process_helper_cmd_exists (const gchar* cmd_tool);
VALA_EXTERN OSDNotify* osd_notify_new (void);
VALA_EXTERN OSDNotify* osd_notify_construct (GType object_type);
static void osd_notify_finalize (GObject * obj);
static GType osd_notify_get_type_once (void);

gint
osd_notify_notify_send (const gchar* title,
                        const gchar* message,
                        gint durationMillis,
                        const gchar* urgency,
                        const gchar* dialog_type)
{
	gint retVal = 0;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	glong seconds = 0L;
	GDateTime* _tmp3_;
	gint result;
	g_return_val_if_fail (title != NULL, 0);
	g_return_val_if_fail (message != NULL, 0);
	g_return_val_if_fail (urgency != NULL, 0);
	g_return_val_if_fail (dialog_type != NULL, 0);
	retVal = 0;
	_tmp0_ = dialog_type;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (((_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("error")))) || (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("info"))))) || (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("warning"))))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				dialog_type = "info";
				break;
			}
		}
	}
	seconds = (glong) 9999;
	_tmp3_ = osd_notify_dt_last_notification;
	if (_tmp3_ != NULL) {
		GDateTime* dt_end = NULL;
		GDateTime* _tmp4_;
		GTimeSpan elapsed = 0LL;
		GDateTime* _tmp5_;
		GDateTime* _tmp6_;
		_tmp4_ = g_date_time_new_now_local ();
		dt_end = _tmp4_;
		_tmp5_ = dt_end;
		_tmp6_ = osd_notify_dt_last_notification;
		elapsed = g_date_time_difference (_tmp5_, _tmp6_);
		seconds = (glong) ((elapsed * 1.0) / G_TIME_SPAN_SECOND);
		_g_date_time_unref0 (dt_end);
	}
	if (seconds > ((glong) OSD_NOTIFY_NOTIFICATION_INTERVAL)) {
		if (osd_notify_is_supported ()) {
			gchar* desktop_entry = NULL;
			gchar* _tmp7_;
			gchar* hint = NULL;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* s = NULL;
			gchar* _tmp10_;
			gchar* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			GDateTime* _tmp16_;
			_tmp7_ = g_strdup ("timeshift-gtk");
			desktop_entry = _tmp7_;
			_tmp8_ = desktop_entry;
			_tmp9_ = g_strdup_printf ("string:desktop-entry:%s", _tmp8_);
			hint = _tmp9_;
			_tmp10_ = g_strconcat ("gtk-dialog-", dialog_type, NULL);
			_tmp11_ = _tmp10_;
			_tmp12_ = hint;
			_tmp13_ = g_strdup_printf ("notify-send -t %d -u %s -i %s \"%s\" \"%s\" -h %s", durationMillis, urgency, _tmp11_, title, message, _tmp12_);
			_tmp14_ = _tmp13_;
			_g_free0 (_tmp11_);
			s = _tmp14_;
			_tmp15_ = s;
			retVal = tee_jee_process_helper_exec_user_async (_tmp15_);
			_tmp16_ = g_date_time_new_now_local ();
			_g_date_time_unref0 (osd_notify_dt_last_notification);
			osd_notify_dt_last_notification = _tmp16_;
			_g_free0 (s);
			_g_free0 (hint);
			_g_free0 (desktop_entry);
		}
	}
	result = retVal;
	return result;
}

gboolean
osd_notify_is_supported (void)
{
	gboolean result;
	result = tee_jee_process_helper_cmd_exists ("notify-send");
	return result;
}

OSDNotify*
osd_notify_construct (GType object_type)
{
	OSDNotify * self = NULL;
	self = (OSDNotify*) g_object_new (object_type, NULL);
	return self;
}

OSDNotify*
osd_notify_new (void)
{
	return osd_notify_construct (TYPE_OSD_NOTIFY);
}

static void
osd_notify_class_init (OSDNotifyClass * klass,
                       gpointer klass_data)
{
	osd_notify_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = osd_notify_finalize;
}

static void
osd_notify_instance_init (OSDNotify * self,
                          gpointer klass)
{
}

static void
osd_notify_finalize (GObject * obj)
{
	OSDNotify * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_OSD_NOTIFY, OSDNotify);
	G_OBJECT_CLASS (osd_notify_parent_class)->finalize (obj);
}

static GType
osd_notify_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (OSDNotifyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) osd_notify_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (OSDNotify), 0, (GInstanceInitFunc) osd_notify_instance_init, NULL };
	GType osd_notify_type_id;
	osd_notify_type_id = g_type_register_static (G_TYPE_OBJECT, "OSDNotify", &g_define_type_info, 0);
	return osd_notify_type_id;
}

GType
osd_notify_get_type (void)
{
	static volatile gsize osd_notify_type_id__once = 0;
	if (g_once_init_enter (&osd_notify_type_id__once)) {
		GType osd_notify_type_id;
		osd_notify_type_id = osd_notify_get_type_once ();
		g_once_init_leave (&osd_notify_type_id__once, osd_notify_type_id);
	}
	return osd_notify_type_id__once;
}

