/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta2

import (
	resource "k8s.io/apimachinery/pkg/api/resource"
)

// CapacityRequestPolicyApplyConfiguration represents a declarative configuration of the CapacityRequestPolicy type for use
// with apply.
//
// CapacityRequestPolicy defines how requests consume device capacity.
//
// Must not set more than one ValidRequestValues.
type CapacityRequestPolicyApplyConfiguration struct {
	// Default specifies how much of this capacity is consumed by a request
	// that does not contain an entry for it in DeviceRequest's Capacity.
	Default *resource.Quantity `json:"default,omitempty"`
	// ValidValues defines a set of acceptable quantity values in consuming requests.
	//
	// Must not contain more than 10 entries.
	// Must be sorted in ascending order.
	//
	// If this field is set,
	// Default must be defined and it must be included in ValidValues list.
	//
	// If the requested amount does not match any valid value but smaller than some valid values,
	// the scheduler calculates the smallest valid value that is greater than or equal to the request.
	// That is: min(ceil(requestedValue) ∈ validValues), where requestedValue ≤ max(validValues).
	//
	// If the requested amount exceeds all valid values, the request violates the policy,
	// and this device cannot be allocated.
	ValidValues []resource.Quantity `json:"validValues,omitempty"`
	// ValidRange defines an acceptable quantity value range in consuming requests.
	//
	// If this field is set,
	// Default must be defined and it must fall within the defined ValidRange.
	//
	// If the requested amount does not fall within the defined range, the request violates the policy,
	// and this device cannot be allocated.
	//
	// If the request doesn't contain this capacity entry, Default value is used.
	ValidRange *CapacityRequestPolicyRangeApplyConfiguration `json:"validRange,omitempty"`
}

// CapacityRequestPolicyApplyConfiguration constructs a declarative configuration of the CapacityRequestPolicy type for use with
// apply.
func CapacityRequestPolicy() *CapacityRequestPolicyApplyConfiguration {
	return &CapacityRequestPolicyApplyConfiguration{}
}

// WithDefault sets the Default field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Default field is set to the value of the last call.
func (b *CapacityRequestPolicyApplyConfiguration) WithDefault(value resource.Quantity) *CapacityRequestPolicyApplyConfiguration {
	b.Default = &value
	return b
}

// WithValidValues adds the given value to the ValidValues field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the ValidValues field.
func (b *CapacityRequestPolicyApplyConfiguration) WithValidValues(values ...resource.Quantity) *CapacityRequestPolicyApplyConfiguration {
	for i := range values {
		b.ValidValues = append(b.ValidValues, values[i])
	}
	return b
}

// WithValidRange sets the ValidRange field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ValidRange field is set to the value of the last call.
func (b *CapacityRequestPolicyApplyConfiguration) WithValidRange(value *CapacityRequestPolicyRangeApplyConfiguration) *CapacityRequestPolicyApplyConfiguration {
	b.ValidRange = value
	return b
}
